/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import nl.grauw.glass.AssemblyException;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.ContextLiteral;
import nl.grauw.glass.expressions.ErrorLiteral;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Type;

public class Scope
implements Context {
    private final Scope parent;
    private final Map<String, Expression> symbols = new HashMap<String, Expression>();
    private Expression address;

    public Scope() {
        this(null);
    }

    public Scope(Scope parent) {
        this.parent = parent;
    }

    public Scope getParent() {
        return this.parent;
    }

    public Set<String> getSymbols() {
        return this.symbols.keySet();
    }

    @Override
    public Expression getAddress() {
        if (this.address == null) {
            throw new EvaluationException("Address not initialized.");
        }
        return this.address;
    }

    public void setAddress(Expression address) {
        if (this.address != null) {
            throw new AssemblyException("Address was already set.");
        }
        this.address = address;
    }

    public void addSymbol(String name, Expression value) {
        if (name == null || value == null) {
            throw new AssemblyException("Symbol name and value must not be null.");
        }
        if (this.symbols.containsKey(name)) {
            throw new AssemblyException("Can not redefine symbol: " + name);
        }
        this.symbols.put(name, value);
    }

    public void addSymbol(String name, Scope context) {
        this.addSymbol(name, new ContextLiteral(context));
    }

    public void addSymbols(Scope other) {
        for (Map.Entry<String, Expression> entry : other.symbols.entrySet()) {
            this.addSymbol(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public boolean hasSymbol(String name) {
        return this.hasLocalSymbol(name) || this.parent != null && this.parent.hasSymbol(name);
    }

    @Override
    public Expression getSymbol(String name) {
        Expression value = this.getLocalSymbolOrNull(name);
        if (value != null) {
            return value;
        }
        if (this.parent != null) {
            return this.parent.getSymbol(name);
        }
        return new ErrorLiteral(new SymbolNotFoundException(name));
    }

    @Override
    public boolean hasLocalSymbol(String name) {
        return this.getLocalSymbolOrNull(name) != null;
    }

    @Override
    public Expression getLocalSymbol(String name) {
        Expression value = this.getLocalSymbolOrNull(name);
        if (value != null) {
            return value;
        }
        return new ErrorLiteral(new SymbolNotFoundException(name));
    }

    private Expression getLocalSymbolOrNull(String name) {
        Expression value = this.symbols.get(name);
        if (value != null) {
            return value;
        }
        int index = name.length();
        while ((index = name.lastIndexOf(46, index - 1)) != -1) {
            Expression result = this.symbols.get(name.substring(0, index));
            if (result == null || !result.is(Type.CONTEXT)) continue;
            return ((Scope)result.getContext()).getLocalSymbolOrNull(name.substring(index + 1));
        }
        return null;
    }

    public String serializeSymbols() {
        return this.serializeSymbols("");
    }

    public String serializeSymbols(String namePrefix) {
        StringBuilder builder = new StringBuilder();
        TreeMap<String, Expression> sortedMap = new TreeMap<String, Expression>(this.symbols);
        for (Map.Entry<String, Expression> entry : sortedMap.entrySet()) {
            String name = String.valueOf(namePrefix) + entry.getKey();
            Expression value = entry.getValue();
            if (value.is(Type.INTEGER)) {
                try {
                    builder.append(String.valueOf(name) + ": equ " + value.getHexValue() + "\n");
                }
                catch (EvaluationException evaluationException) {
                    // empty catch block
                }
            }
            if (!value.is(Type.CONTEXT)) continue;
            try {
                Scope context = (Scope)value.getContext();
                builder.append(context.serializeSymbols(String.valueOf(name) + "."));
            }
            catch (EvaluationException evaluationException) {
                // empty catch block
            }
        }
        return builder.toString();
    }

    public String toString() {
        return this.serializeSymbols();
    }

    public class SymbolNotFoundException
    extends EvaluationException {
        private static final long serialVersionUID = 1L;
        private String name;

        public SymbolNotFoundException(String name) {
            super("Symbol not found: " + name);
            this.name = name;
        }

        public Scope getScope() {
            return Scope.this;
        }

        public String getName() {
            return this.name;
        }
    }
}

