/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.Type;

public class Annotation
extends Expression {
    private final Identifier annotation;
    private final Expression annotee;

    public Annotation(Identifier annotation, Expression annotee) {
        this.annotation = annotation;
        this.annotee = annotee;
    }

    @Override
    public Annotation copy(Context context) {
        return new Annotation(this.annotation.copy(context), this.annotee.copy(context));
    }

    @Override
    public Identifier getAnnotation() {
        return this.annotation;
    }

    @Override
    public Expression getAnnotee() {
        return this.annotee;
    }

    @Override
    public boolean is(Expression type) {
        return type.is(Type.ANNOTATION);
    }

    @Override
    public Expression get(Expression type) {
        if (type.is(Type.ANNOTATION)) {
            return this;
        }
        return super.get(type);
    }

    public String toString() {
        return this.annotation + " " + this.annotee;
    }

    @Override
    public String toDebugString() {
        return "{" + this.annotation.toDebugString() + " " + this.annotee.toDebugString() + "}";
    }
}

