/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import java.util.ArrayList;
import java.util.List;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.ErrorLiteral;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Flag;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.SectionContext;
import nl.grauw.glass.expressions.Type;
import nl.grauw.glass.instructions.InstructionFactory;

public abstract class Expression {
    public abstract String toDebugString();

    public abstract Expression copy(Context var1);

    public abstract boolean is(Expression var1);

    public Expression get(Expression type) {
        return new ErrorLiteral(new EvaluationException("Not of type " + type)).get(type);
    }

    public int getInteger() {
        if (this.is(Type.INTEGER)) {
            return this.get(Type.INTEGER).getInteger();
        }
        throw new EvaluationException("Not an integer.");
    }

    public String getString() {
        if (this.is(Type.STRING)) {
            return this.get(Type.STRING).getString();
        }
        throw new EvaluationException("Not a string.");
    }

    public Register getRegister() {
        Expression register;
        if (this.is(Type.REGISTER) && (register = this.get(Type.REGISTER)) instanceof Register) {
            return (Register)register;
        }
        throw new EvaluationException("Not a register.");
    }

    public Flag getFlag() {
        Expression flag;
        if (this.is(Type.FLAG) && (flag = this.get(Type.FLAG)) instanceof Flag) {
            return (Flag)flag;
        }
        throw new EvaluationException("Not a flag.");
    }

    public Identifier getAnnotation() {
        if (this.is(Type.ANNOTATION)) {
            return this.get(Type.ANNOTATION).getAnnotation();
        }
        throw new EvaluationException("Not an annotation.");
    }

    public Expression getAnnotee() {
        if (this.is(Type.ANNOTATION)) {
            return this.get(Type.ANNOTATION).getAnnotee();
        }
        throw new EvaluationException("Not an annotation.");
    }

    public InstructionFactory getInstruction() {
        if (this.is(Type.INSTRUCTION)) {
            return this.get(Type.INSTRUCTION).getInstruction();
        }
        throw new EvaluationException("Not an instruction.");
    }

    public Context getContext() {
        if (this.is(Type.CONTEXT)) {
            return this.get(Type.CONTEXT).getContext();
        }
        throw new EvaluationException("Not a context.");
    }

    public SectionContext getSectionContext() {
        if (this.is(Type.SECTIONCONTEXT)) {
            return this.get(Type.SECTIONCONTEXT).getSectionContext();
        }
        throw new EvaluationException("Not a section context.");
    }

    public Expression getHead() {
        return this;
    }

    public Expression getTail() {
        return null;
    }

    public List<Expression> getFlatList() {
        ArrayList<Expression> list = new ArrayList<Expression>();
        this.addToFlatList(list);
        return list;
    }

    private void addToFlatList(List<Expression> list) {
        Expression tail = this;
        while (tail.is(Type.SEQUENCE)) {
            Expression sequence = tail.get(Type.SEQUENCE);
            sequence.getHead().addToFlatList(list);
            tail = sequence.getTail();
        }
        list.add(tail);
    }

    public Expression getElement(int index) {
        return index == 0 ? this : null;
    }

    public String getHexValue() {
        int value = this.getInteger();
        String string = Integer.toHexString(Math.abs(value)).toUpperCase();
        return String.valueOf(value < 0 ? "-" : "") + (string.charAt(0) >= 'A' && string.charAt(0) <= 'F' ? "0" : "") + string + "H";
    }
}

