/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Type;

public class Flag
extends Expression {
    public static Flag NZ = new Flag("nz", 0);
    public static Flag Z = new Flag("z", 1);
    public static Flag NC = new Flag("nc", 2);
    public static Flag C = new Flag("c", 3);
    public static Flag PO = new Flag("po", 4);
    public static Flag PE = new Flag("pe", 5);
    public static Flag P = new Flag("p", 6);
    public static Flag M = new Flag("m", 7);
    private final String name;
    private final int code;

    public Flag(String name, int code) {
        this.name = name;
        this.code = code;
    }

    @Override
    public Flag copy(Context context) {
        return this;
    }

    public int getCode() {
        return this.code;
    }

    @Override
    public boolean is(Expression type) {
        return type.is(Type.FLAG);
    }

    @Override
    public Expression get(Expression type) {
        if (type.is(Type.FLAG)) {
            return this;
        }
        return super.get(type);
    }

    public String toString() {
        return this.name;
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }

    public static Flag getByName(String name) {
        switch (name) {
            case "NZ": 
            case "nz": {
                return NZ;
            }
            case "Z": 
            case "z": {
                return Z;
            }
            case "NC": 
            case "nc": {
                return NC;
            }
            case "C": 
            case "c": {
                return C;
            }
            case "PO": 
            case "po": {
                return PO;
            }
            case "PE": 
            case "pe": {
                return PE;
            }
            case "P": 
            case "p": {
                return P;
            }
            case "M": 
            case "m": {
                return M;
            }
        }
        return null;
    }
}

