/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import java.util.List;
import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Dd
extends InstructionFactory {
    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        if (arguments != null) {
            return new Dd_N(context, arguments.getFlatList());
        }
        throw new ArgumentException();
    }

    public static class Dd_N
    extends InstructionObject {
        private List<Expression> arguments;

        public Dd_N(Scope context, List<Expression> arguments) {
            super(context);
            this.arguments = arguments;
        }

        @Override
        public Expression getSize() {
            return IntegerLiteral.of(this.arguments.size() * 4);
        }

        @Override
        public byte[] getBytes() {
            byte[] bytes = new byte[this.arguments.size() * 4];
            int i = 0;
            int length = this.arguments.size();
            while (i < length) {
                bytes[i * 4] = (byte)this.arguments.get(i).getInteger();
                bytes[i * 4 + 1] = (byte)(this.arguments.get(i).getInteger() >> 8);
                bytes[i * 4 + 2] = (byte)(this.arguments.get(i).getInteger() >> 16);
                bytes[i * 4 + 3] = (byte)(this.arguments.get(i).getInteger() >> 24);
                ++i;
            }
            return bytes;
        }
    }
}

