/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass;

import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import nl.grauw.glass.AssemblyException;

public class SourceFile {
    private final Path path;
    private final List<String> content;

    public SourceFile(Path path) {
        this.path = path;
        try {
            this.content = Files.readAllLines(path, Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            throw new AssemblyException(e);
        }
    }

    public SourceFile(String string) {
        this.path = null;
        this.content = Arrays.asList(string.split("\\R", -1));
    }

    public SourceFileReader getReader() {
        return new SourceFileReader();
    }

    public Path getPath() {
        return this.path;
    }

    public String getLine(int lineNumber) {
        return this.content.get(lineNumber);
    }

    public class SourceFileReader {
        int lineNumber = 0;

        private SourceFileReader() {
        }

        public SourceFile getSourceFile() {
            return SourceFile.this;
        }

        public String readLine() {
            if (this.lineNumber >= SourceFile.this.content.size()) {
                return null;
            }
            return SourceFile.this.getLine(this.lineNumber++);
        }

        public SourceFileSpan getSpan(SourceFileSpan span) {
            return new SourceFileSpan(span != null ? span.lineStart : this.lineNumber, this.lineNumber >= SourceFile.this.content.size() ? this.lineNumber : this.lineNumber + 1);
        }
    }

    public class SourceFileSpan {
        final int lineStart;
        final int lineEnd;
        final int column;

        public SourceFileSpan(int lineStart, int lineEnd, int column) {
            this.lineStart = lineStart;
            this.lineEnd = lineEnd;
            this.column = column;
        }

        public SourceFileSpan(int lineStart, int lineEnd) {
            this(lineStart, lineEnd, -1);
        }

        public SourceFile getSourceFile() {
            return SourceFile.this;
        }

        public SourceFileSpan atColumn(int column) {
            return new SourceFileSpan(this.lineStart, this.lineEnd, column);
        }

        public String toString() {
            String string = "[at " + this.getSourceFile().getPath() + ":" + (this.lineStart + 1) + (this.column != -1 ? "," + (this.column + 1) : "") + "]";
            int i = this.lineStart;
            while (i < this.lineEnd) {
                string = String.valueOf(string) + "\n" + SourceFile.this.getLine(i);
                ++i;
            }
            if (this.column != -1) {
                String line = SourceFile.this.getLine(Math.min(this.lineEnd, SourceFile.this.content.size()) - 1);
                int end = Math.min(this.column, line.length());
                string = String.valueOf(string) + "\n" + line.substring(0, end).replaceAll("[^\t]", " ") + "^";
            }
            return string;
        }
    }
}

