/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.directives;

import java.util.HashSet;
import nl.grauw.glass.Line;
import nl.grauw.glass.Scope;
import nl.grauw.glass.Source;
import nl.grauw.glass.directives.Directive;
import nl.grauw.glass.expressions.ContextLiteral;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.IfElse;
import nl.grauw.glass.expressions.Member;

public class If
extends Directive {
    private final Source thenSource;
    private final Source elseSource;

    public If(Source thenSource, Source elseSource) {
        this.thenSource = thenSource;
        this.elseSource = elseSource;
    }

    @Override
    public Directive copy(Scope scope) {
        return new If(this.thenSource.copy(new Scope(scope.getParent())), this.elseSource.copy(new Scope(scope.getParent())));
    }

    @Override
    public void register(Scope scope, Line line) {
        line.setInstruction(new nl.grauw.glass.instructions.If(this.thenSource, this.elseSource));
        super.register(scope, line);
        this.thenSource.register();
        this.elseSource.register();
        HashSet<String> symbols = new HashSet<String>();
        symbols.addAll(this.thenSource.getScope().getSymbols());
        symbols.addAll(this.elseSource.getScope().getSymbols());
        for (String symbol : symbols) {
            scope.addSymbol(symbol, new IfElse(line.getArguments(), new Member(new ContextLiteral(this.thenSource.getScope()), new Identifier(symbol, null)), new Member(new ContextLiteral(this.elseSource.getScope()), new Identifier(symbol, null))));
        }
    }
}

