/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.ErrorLiteral;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Passthrough;
import nl.grauw.glass.expressions.Type;

public class Index
extends Passthrough {
    private final Expression sequence;
    private final Expression index;

    public Index(Expression sequence, Expression index) {
        this.sequence = sequence;
        this.index = index;
    }

    @Override
    public Index copy(Context context) {
        return new Index(this.sequence.copy(context), this.index.copy(context));
    }

    public Expression getSequence() {
        return this.sequence;
    }

    public Expression getIndex() {
        return this.index;
    }

    @Override
    public Expression resolve() {
        int index = this.index.get(Type.INTEGER).getInteger();
        Expression tail = this.sequence;
        while (index > 0 && tail.is(Type.SEQUENCE)) {
            tail = tail.get(Type.SEQUENCE).getTail();
            --index;
        }
        if (index != 0) {
            return new ErrorLiteral(new EvaluationException("Index out of bounds."));
        }
        if (tail.is(Type.SEQUENCE)) {
            return tail.get(Type.SEQUENCE).getHead();
        }
        return tail;
    }

    public String toString() {
        return this.sequence + "[" + this.index + "]";
    }

    @Override
    public String toDebugString() {
        return "{" + this.sequence.toDebugString() + "[" + this.index.toDebugString() + "]}";
    }
}

