/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.ErrorLiteral;
import nl.grauw.glass.expressions.EvaluationException;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.Passthrough;
import nl.grauw.glass.expressions.Type;

public class Member
extends Passthrough {
    private final Expression object;
    private final Identifier subject;

    public Member(Expression object, Identifier subject) {
        this.object = object;
        this.subject = subject;
    }

    @Override
    public Member copy(Context context) {
        return new Member(this.object.copy(context), this.subject.copy(context));
    }

    public Expression getObject() {
        return this.object;
    }

    public Expression getSubject() {
        return this.subject;
    }

    @Override
    public Expression resolve() {
        if (!this.object.is(Type.CONTEXT)) {
            return new ErrorLiteral(new EvaluationException("Object not found."));
        }
        return this.object.getContext().getLocalSymbol(this.subject.getName());
    }

    public String toString() {
        return this.object + "." + this.subject;
    }

    @Override
    public String toDebugString() {
        return "{" + this.object.toDebugString() + "." + this.subject.toDebugString() + "}";
    }
}

