/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Identifier;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.SchemaType;
import nl.grauw.glass.expressions.Type;

public class Schema
implements SchemaType {
    private SchemaType[] types;
    public static SchemaType ANY = new IsAny();
    public static SchemaType DIRECT = new IsDirect();
    public static SchemaType INDIRECT = new IsIndirect();
    public static SchemaType INTEGER = new IsInteger();
    public static SchemaType STRING = new IsString();
    public static SchemaType IDENTIFIER = new IsIdentifier();
    public static SchemaType DIRECT_N = new And(DIRECT, INTEGER);
    public static SchemaType DIRECT_R = new And(DIRECT, new IsRegister8Bit());
    public static SchemaType DIRECT_A = new And(DIRECT, new IsRegister(Register.A));
    public static SchemaType DIRECT_IR = new And(DIRECT, new IsRegister(Register.I, Register.R));
    public static SchemaType DIRECT_RR = new And(DIRECT, new IsRegister(Register.BC, Register.DE, Register.HL, Register.SP));
    public static SchemaType DIRECT_RR_INDEX = new And(DIRECT, new IsRegister(Register.BC, Register.DE, Register.HL, Register.SP, Register.IX, Register.IY));
    public static SchemaType DIRECT_RR_AF_INDEX = new And(DIRECT, new IsRegister(Register.BC, Register.DE, Register.HL, Register.AF, Register.IX, Register.IY));
    public static SchemaType DIRECT_DE = new And(DIRECT, new IsRegister(Register.DE));
    public static SchemaType DIRECT_HL = new And(DIRECT, new IsRegister(Register.HL));
    public static SchemaType DIRECT_HL_IX_IY = new And(DIRECT, new IsRegister(Register.HL, Register.IX, Register.IY));
    public static SchemaType DIRECT_SP = new And(DIRECT, new IsRegister(Register.SP));
    public static SchemaType DIRECT_AF = new And(DIRECT, new IsRegister(Register.AF));
    public static SchemaType DIRECT_AF_ = new And(DIRECT, new IsRegister(Register.AF_));
    public static SchemaType INDIRECT_N = new And(INDIRECT, INTEGER);
    public static SchemaType INDIRECT_C = new And(INDIRECT, new IsRegister(Register.C));
    public static SchemaType INDIRECT_BC_DE = new And(INDIRECT, new IsRegister(Register.BC, Register.DE));
    public static SchemaType INDIRECT_HL_IX_IY = new And(INDIRECT, new IsRegister(Register.HL, Register.IX, Register.IY));
    public static SchemaType INDIRECT_SP = new And(INDIRECT, new IsRegister(Register.SP));
    public static SchemaType DIRECT_R_INDIRECT_HL_IX_IY = new IsDirectRIndirectHLIXIY();

    public Schema(SchemaType ... types) {
        this.types = types;
    }

    @Override
    public boolean check(Expression arguments) {
        SchemaType[] schemaTypeArray = this.types;
        int n = this.types.length;
        int n2 = 0;
        while (n2 < n) {
            SchemaType type = schemaTypeArray[n2];
            if (arguments == null || !type.check(arguments.getHead())) {
                return false;
            }
            arguments = arguments.getTail();
            ++n2;
        }
        return arguments == null;
    }

    public static class And
    implements SchemaType {
        private SchemaType[] types;

        public And(SchemaType ... types) {
            this.types = types;
        }

        @Override
        public boolean check(Expression argument) {
            SchemaType[] schemaTypeArray = this.types;
            int n = this.types.length;
            int n2 = 0;
            while (n2 < n) {
                SchemaType type = schemaTypeArray[n2];
                if (!type.check(argument)) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
    }

    public static class IsAnnotation
    implements SchemaType {
        private final SchemaType rhsType;

        public IsAnnotation(SchemaType rhsType) {
            this.rhsType = rhsType;
        }

        @Override
        public boolean check(Expression argument) {
            return argument.is(Type.ANNOTATION) && this.rhsType.check(argument.getAnnotee());
        }
    }

    public static class IsAny
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return true;
        }
    }

    public static class IsDirect
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return !argument.is(Type.GROUP);
        }
    }

    public static class IsDirectRIndirectHLIXIY
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            if (argument.is(Type.REGISTER)) {
                Register register = argument.getRegister();
                return DIRECT.check(argument) && !register.isPair() && register != Register.I && register != Register.R || INDIRECT.check(argument) && (register == Register.HL || register.isIndex());
            }
            return false;
        }
    }

    public static class IsFlag
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return argument.is(Type.FLAG);
        }
    }

    public static class IsFlagZC
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return argument.is(Type.FLAG) && argument.getFlag().getCode() < 4;
        }
    }

    public static class IsIdentifier
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return argument instanceof Identifier;
        }
    }

    public static class IsIndirect
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return argument.is(Type.GROUP);
        }
    }

    public static class IsInteger
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return argument.is(Type.INTEGER);
        }
    }

    public static class IsRegister
    implements SchemaType {
        private Register[] registers;

        public IsRegister(Register ... registers) {
            this.registers = registers;
        }

        @Override
        public boolean check(Expression argument) {
            if (argument.is(Type.REGISTER)) {
                Register register = argument.getRegister();
                Register[] registerArray = this.registers;
                int n = this.registers.length;
                int n2 = 0;
                while (n2 < n) {
                    Register expected = registerArray[n2];
                    if (register == expected) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }

    public static class IsRegister8Bit
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            if (argument.is(Type.REGISTER)) {
                Register register = argument.getRegister();
                return !register.isPair() && register != Register.I && register != Register.R;
            }
            return false;
        }
    }

    public static class IsString
    implements SchemaType {
        @Override
        public boolean check(Expression argument) {
            return argument.is(Type.STRING);
        }
    }
}

