/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.BinaryOperator;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Type;

public class Sequence
extends BinaryOperator {
    public Sequence(Expression head, Expression tail) {
        super(head, tail);
    }

    @Override
    public Sequence copy(Context context) {
        return new Sequence(this.term1.copy(context), this.term2.copy(context));
    }

    @Override
    public Expression getHead() {
        return this.term1;
    }

    @Override
    public Expression getTail() {
        return this.term2;
    }

    @Override
    public boolean is(Expression type) {
        return type.is(Type.SEQUENCE);
    }

    @Override
    public Expression get(Expression type) {
        if (type.is(Type.SEQUENCE)) {
            return this;
        }
        return super.get(type);
    }

    @Override
    public Expression getElement(int index) {
        return index == 0 ? this.term1 : this.term2.getElement(index - 1);
    }

    @Override
    public String getLexeme() {
        return ",";
    }

    @Override
    public String toString() {
        return this.term1 + ", " + this.term2;
    }

    @Override
    public String toDebugString() {
        return "{" + this.term1.toDebugString() + ", " + this.term2.toDebugString() + "}";
    }
}

