/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.expressions;

import nl.grauw.glass.expressions.CharacterLiteral;
import nl.grauw.glass.expressions.Context;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.Sequence;
import nl.grauw.glass.expressions.Type;

public class StringLiteral
extends Expression {
    private final String string;

    public StringLiteral(String string) {
        this.string = string;
    }

    @Override
    public StringLiteral copy(Context context) {
        return this;
    }

    @Override
    public String getString() {
        return this.string;
    }

    @Override
    public boolean is(Expression type) {
        return type.is(Type.STRING) || type.is(Type.INTEGER) && this.string.length() == 1 || type.is(Type.SEQUENCE) && this.string.length() > 1;
    }

    @Override
    public Expression get(Expression type) {
        if (type.is(Type.STRING)) {
            return this;
        }
        if (type.is(Type.INTEGER) && this.string.length() == 1) {
            return new CharacterLiteral(this.string.charAt(0));
        }
        if (type.is(Type.SEQUENCE) && this.string.length() > 1) {
            Expression tail = new CharacterLiteral(this.string.charAt(this.string.length() - 1));
            int i = this.string.length() - 2;
            while (i >= 0) {
                tail = new Sequence(new CharacterLiteral(this.string.charAt(i)), tail);
                --i;
            }
            return tail;
        }
        return super.get(type);
    }

    public String toString() {
        String escaped = this.string;
        escaped = escaped.replace("\\", "\\\\");
        escaped = escaped.replace("\"", "\\\"");
        escaped = escaped.replace("\u0000", "\\0");
        escaped = escaped.replace("\u0007", "\\a");
        escaped = escaped.replace("\t", "\\t");
        escaped = escaped.replace("\n", "\\n");
        escaped = escaped.replace("\f", "\\f");
        escaped = escaped.replace("\r", "\\r");
        escaped = escaped.replace("\u001b", "\\e");
        return "\"" + escaped + "\"";
    }

    @Override
    public String toDebugString() {
        return this.toString();
    }
}

