/*
 * Decompiled with CFR 0.152.
 */
package nl.grauw.glass.instructions;

import nl.grauw.glass.Scope;
import nl.grauw.glass.expressions.Expression;
import nl.grauw.glass.expressions.IntegerLiteral;
import nl.grauw.glass.expressions.Register;
import nl.grauw.glass.expressions.Schema;
import nl.grauw.glass.instructions.ArgumentException;
import nl.grauw.glass.instructions.InstructionFactory;
import nl.grauw.glass.instructions.InstructionObject;

public class Xor
extends InstructionFactory {
    @Override
    public InstructionObject createObject(Scope context, Expression arguments) {
        if (Xor_R.ARGUMENTS.check(arguments)) {
            return new Xor_R(context, arguments);
        }
        if (Xor_N.ARGUMENTS.check(arguments)) {
            return new Xor_N(context, arguments);
        }
        throw new ArgumentException();
    }

    public static class Xor_N
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_N);
        private Expression argument;

        public Xor_N(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public Expression getSize() {
            return IntegerLiteral.TWO;
        }

        @Override
        public byte[] getBytes() {
            return new byte[]{-18, (byte)this.argument.getInteger()};
        }
    }

    public static class Xor_R
    extends InstructionObject {
        public static Schema ARGUMENTS = new Schema(Schema.DIRECT_R_INDIRECT_HL_IX_IY);
        private Expression argument;

        public Xor_R(Scope context, Expression arguments) {
            super(context);
            this.argument = arguments;
        }

        @Override
        public Expression getSize() {
            return this.indexifyIndirect(this.argument.getRegister(), IntegerLiteral.ONE);
        }

        @Override
        public byte[] getBytes() {
            Register register = this.argument.getRegister();
            return this.indexifyIndirect(register, (byte)(0xA8 | register.get8BitCode()));
        }
    }
}

