/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontConverterUI
extends JFrame {
    String path;
    File fontFile;
    byte[] fontData;
    BufferedImage image;
    private JButton BtnAbout;
    private JButton BtnConvert;
    private JButton BtnDrowse;
    private JButton BtnExit;
    private JScrollPane PanFontsList;
    private JTextField TxtFldPath;
    private JFileChooser chooser;
    private JLabel fontInfo;
    private JLabel fontInfoLabel;
    private JLabel fontViewLabel;
    private JList<String> listFonts;
    private JPanel panel;

    public FontConverterUI() {
        this.initComponents();
    }

    private void initComponents() {
        this.chooser = new JFileChooser();
        this.panel = new ImageLayout();
        this.fontInfoLabel = new JLabel();
        this.fontInfo = new JLabel();
        this.fontViewLabel = new JLabel();
        this.BtnDrowse = new JButton();
        this.BtnConvert = new JButton();
        this.PanFontsList = new JScrollPane();
        this.listFonts = new JList();
        this.TxtFldPath = new JTextField();
        this.BtnAbout = new JButton();
        this.BtnExit = new JButton();
        this.chooser.setAcceptAllFileFilterUsed(false);
        this.chooser.setCurrentDirectory(null);
        this.chooser.setDialogTitle("Choose font directory...");
        this.chooser.setFileSelectionMode(1);
        this.setDefaultCloseOperation(3);
        this.setTitle("C64 font to AGD Converter");
        this.panel.setBorder(BorderFactory.createBevelBorder(0));
        this.fontInfoLabel.setFont(new Font("sansserif", 1, 12));
        this.fontInfoLabel.setText("Font info");
        this.fontInfo.setText("None loaded");
        this.fontViewLabel.setFont(new Font("sansserif", 1, 12));
        this.fontViewLabel.setText("Font view");
        GroupLayout panelLayout = new GroupLayout(this.panel);
        this.panel.setLayout(panelLayout);
        panelLayout.setHorizontalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(panelLayout.createSequentialGroup().addContainerGap().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontInfo, -1, 514, Short.MAX_VALUE).addGroup(panelLayout.createSequentialGroup().addGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fontInfoLabel, -2, 61, -2).addComponent(this.fontViewLabel, -2, 61, -2)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        panelLayout.setVerticalGroup(panelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, panelLayout.createSequentialGroup().addContainerGap().addComponent(this.fontViewLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 143, Short.MAX_VALUE).addComponent(this.fontInfoLabel).addGap(4, 4, 4).addComponent(this.fontInfo, -2, 16, -2).addGap(14, 14, 14)));
        this.BtnDrowse.setText("Browse...");
        this.BtnDrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontConverterUI.this.BtnDrowseActionPerformed(evt);
            }
        });
        this.BtnConvert.setText("Convert");
        this.BtnConvert.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontConverterUI.this.BtnConvertActionPerformed(evt);
            }
        });
        this.listFonts.setSelectionMode(0);
        this.listFonts.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent evt) {
                FontConverterUI.this.listFontsValueChanged(evt);
            }
        });
        this.PanFontsList.setViewportView(this.listFonts);
        this.TxtFldPath.setText("Select a font directory...");
        this.BtnAbout.setText("About");
        this.BtnExit.setText("Exit");
        this.BtnExit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                FontConverterUI.this.BtnExitActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.BtnDrowse).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.TxtFldPath)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.panel, -2, -1, -2).addGroup(layout.createSequentialGroup().addComponent(this.PanFontsList, -2, 432, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.BtnAbout, -1, -1, Short.MAX_VALUE).addComponent(this.BtnExit, -1, -1, Short.MAX_VALUE).addComponent(this.BtnConvert, -1, 92, Short.MAX_VALUE)))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.panel, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.BtnDrowse).addComponent(this.TxtFldPath, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.BtnConvert).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.BtnAbout).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.BtnExit)).addComponent(this.PanFontsList, GroupLayout.Alignment.TRAILING, -2, 154, -2)).addContainerGap()));
        this.pack();
    }

    private void BtnDrowseActionPerformed(ActionEvent evt) {
        this.chooser.setCurrentDirectory(new File(System.getProperty("user.dir")));
        int returnVal = this.chooser.showOpenDialog(this);
        if (returnVal == 0) {
            this.path = this.chooser.getSelectedFile().toString();
            this.TxtFldPath.setText(this.path);
            this.populateList(this.path);
        } else {
            System.out.println("File access cancelled by user.");
        }
    }

    private void BtnExitActionPerformed(ActionEvent evt) {
        System.exit(0);
    }

    private void listFontsValueChanged(ListSelectionEvent evt) {
        if (!evt.getValueIsAdjusting()) {
            String selectedValue = this.listFonts.getSelectedValue();
            this.fontFile = new File(this.path + "\\" + selectedValue);
            int l = (int)this.fontFile.length() - 2;
            int nchars = l % 8 == 0 ? l / 8 : (l + (8 - l % 8)) / 8;
            String info = selectedValue + ", " + this.fontFile.length() + " bytes, " + nchars + " chars";
            this.fontInfo.setText(info);
            try {
                byte[] tmp = Files.readAllBytes(this.fontFile.toPath());
                l = tmp.length - 2;
                this.fontData = l % 8 == 0 ? new byte[l] : new byte[l + (256 - l % 256)];
                System.arraycopy(tmp, 2, this.fontData, 0, l);
                this.drawFont(this.fontData);
            }
            catch (IOException ex) {
                Logger.getLogger(FontConverterUI.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    private void BtnConvertActionPerformed(ActionEvent evt) {
        byte[] agdfont = new byte[768];
        if (this.fontData.length > 512) {
            System.arraycopy(this.fontData, 0, agdfont, 512, 256);
            System.arraycopy(this.fontData, 256, agdfont, 0, 256);
            System.arraycopy(this.fontData, 512, agdfont, 256, 256);
        } else {
            System.arraycopy(this.fontData, 0, agdfont, 256, 256);
            System.arraycopy(this.fontData, 256, agdfont, 0, 256);
        }
        String name = this.fontFile.getAbsolutePath();
        try (FileOutputStream fos = new FileOutputStream(name.substring(0, name.lastIndexOf(46)) + ".chr");){
            fos.write(agdfont);
            this.fontInfo.setText("Font succesfully converted!!");
        }
        catch (IOException ex) {
            Logger.getLogger(FontConverterUI.class.getName()).log(Level.SEVERE, null, ex);
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(FontConverterUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(FontConverterUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(FontConverterUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(FontConverterUI.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new FontConverterUI().setVisible(true);
            }
        });
    }

    private void drawFont(byte[] data) {
        int rows = data.length / 256;
        ((ImageLayout)this.panel).clear();
        for (int y = 0; y < rows; ++y) {
            for (int x = 0; x < 32; ++x) {
                for (int cy = 0; cy < 8; ++cy) {
                    this.drawByte(x * 16, y * 16 + cy * 2, data[y * 256 + x * 8 + cy]);
                    this.drawByte(x * 16, y * 16 + cy * 2 + 1, data[y * 256 + x * 8 + cy]);
                }
            }
        }
        this.panel.repaint();
    }

    private void drawByte(int x, int y, byte b) {
        for (int s = 0; s < 8; ++s) {
            if ((b & 128 >> s) == 0) continue;
            ((ImageLayout)this.panel).getImage().setRGB(x + s * 2, y, Color.WHITE.getRGB());
            ((ImageLayout)this.panel).getImage().setRGB(x + s * 2 + 1, y, Color.WHITE.getRGB());
        }
    }

    private void populateList(String dirName) {
        DefaultListModel<String> dlm = new DefaultListModel<String>();
        for (String f : this.listFiles(dirName, new String[]{"64c"})) {
            dlm.addElement(f);
        }
        this.listFonts.setModel(dlm);
    }

    private List<String> listFiles(String dirName, final String[] exts) {
        File[] files;
        ArrayList<String> results = new ArrayList<String>();
        for (File file : files = new File(dirName).listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                boolean res = false;
                for (String ext : exts) {
                    res = name.endsWith("." + ext);
                }
                return res;
            }
        })) {
            if (!file.isFile()) continue;
            results.add(file.getName());
        }
        return results;
    }
}

