﻿NDSummary.OnToolTipsLoaded("File:math.h",{897:"<div class=\"NDToolTip TGroup LC\"><div class=\"TTSummary\">Helper macros</div></div>",898:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Get absolute value of a signed 8-bits integer</div></div>",899:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Get absolute value of a signed 16-bits integer</div></div>",900:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Get absolute value of a signed 32-bits integer</div></div>",901:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Invert sign of a signed integer</div></div>",902:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Merge two 4 bits value into a 8 bits integer</div></div>",903:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Merge two 8 bits value into a 16 bits integer</div></div>",904:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Get the power-of-2 modulo of a integer (ie. &quot;MOD_POW2(100, 32)&quot;)</div></div>",905:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Clamp a 8-bits value into a interval</div></div>",906:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Clamp a 16-bits value into a interval</div></div>",907:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Find highest value</div></div>",908:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Find lowest value</div></div>",909:"<div class=\"NDToolTip TGroup LC\"><div class=\"TTSummary\">Quick math routines</div></div>",910:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype910\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i8 Math_Div10(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __FASTCALL __PRESERVES(a, b, c, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">8-bits fast 10 times division</div></div>",911:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype911\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i16 Math_Div10_16b(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __FASTCALL __PRESERVES(b, d, e, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">16-bits fast 10 times division</div></div>",912:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype912\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 Math_Mod10(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, c, d, e, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">8-bits fast modulo-10</div></div>",913:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype913\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 Math_Mod10_16b(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __FASTCALL __PRESERVES(b, c, d, e, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">16-bits fast modulo-10</div></div>",914:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype914\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 Math_Flip(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Bits flip routine</div></div>",915:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype915\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u16 Math_Flip_16b(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(c, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Bits flip routine</div></div>",916:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype916\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> i8 Math_Negative(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get the negative (additive inverse) of a 8-bit register</div></div>",917:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype917\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i16 Math_Negative16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __FASTCALL __PRESERVES(b, c, d, e, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Get the negative (additive inverse) of a 16-bit register</div></div>",918:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype918\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u16 Math_Swap(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(a, b, c, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Swap MSB and LSB bytes</div></div>",919:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype919\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i8 Math_SignedDiv2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __naked __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Divide a signed 8-bits integer by 2 using shift</div></div>",920:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype920\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i8 Math_SignedDiv4(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __naked __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Divide a signed 8-bits integer by 4 using shift</div></div>",921:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype921\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i8 Math_SignedDiv8(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __naked __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Divide a signed 8-bits integer by 8 using shift</div></div>",922:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype922\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i8 Math_SignedDiv16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __naked __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Divide a signed 8-bits integer by 16 using shift</div></div>",923:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype923\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">i8 Math_SignedDiv32(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __naked __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Divide a signed 8-bits integer by 32 using shift</div></div>",924:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype924\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u8 Math_Abs(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get absolute value of a signed 8-bits integer</div></div>",925:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype925\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u16 Math_Abs_16b(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get absolute value of a signed 16-bits integer</div></div>",926:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype926\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u32 Math_Abs_32b(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i32&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get absolute value of a signed 32-bits integer</div></div>",927:"<div class=\"NDToolTip TGroup LC\"><div class=\"TTSummary\">Random routines</div></div>",928:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype928\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> Math_SetRandomSeed8(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">seed</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Initialize random generator seed</div></div>",929:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype929\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">u8 Math_GetRandom8()</div></div><div class=\"TTSummary\">Generates 8-bit pseudorandom numbers</div></div>",930:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype930\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u8 Math_GetRandomMax8(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Generates 8-bit pseudorandom numbers between 0 and max-1 value.</div></div>",931:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype931\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u8 Math_GetRandomRange8(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Generates 8-bit pseudorandom numbers between min and max-1 value.</div></div>",932:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype932\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> Math_SetRandomSeed16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">seed</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Initialize random generator seed</div></div>",933:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype933\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">u16 Math_GetRandom16() __FASTCALL</div></div><div class=\"TTSummary\">Generates 16-bit pseudorandom numbers</div></div>",934:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype934\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u16 Math_GetRandomMax16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Generates 16-bit pseudorandom numbers between 0 and max-1 value.</div></div>",935:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype935\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u16 Math_GetRandomRange16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Generates 16-bit pseudorandom numbers between min and max-1 value.</div></div>"});