﻿NDSummary.OnToolTipsLoaded("File:tool/qrcode.h",{161:"<div class=\"NDToolTip TEnumeration LC\"><div class=\"TTSummary\">The error correction level in a QR Code symbol.&nbsp; enum QRCODE_ECC { // Must be declared in ascending order of error protection // so that an internal qrcodegen function works properly QRCODE_ECC_LOW = 0 ,&nbsp; // The QR Code can tolerate about&nbsp; 7% erroneous codewords QRCODE_ECC_MEDIUM&nbsp; ,&nbsp; // The QR Code can tolerate about 15% erroneous codewords QRCODE_ECC_QUARTILE,&nbsp; // The QR Code can tolerate about 25% erroneous codewords QRCODE_ECC_HIGH&nbsp; ,&nbsp; // The QR Code can tolerate about 30% erroneous codewords // QRCODE_ECC_MAX, };</div></div>",162:"<div class=\"NDToolTip TEnumeration LC\"><div class=\"TTSummary\">The mask pattern used in a QR Code symbol.&nbsp; enum QRCODE_MASK { // A special value to tell the QR Code encoder to // automatically select an appropriate mask pattern QRCODE_MASK_AUTO = -1, // The eight actual mask patterns QRCODE_MASK_0 = 0, // (i + j) % 2 = 0 QRCODE_MASK_1,&nbsp; // i % 2 = 0 QRCODE_MASK_2,&nbsp; // j % 3 = 0 QRCODE_MASK_3,&nbsp; // (i + j) % 3 = 0 QRCODE_MASK_4,&nbsp; // (i / 2 + j / 3) % 2 = 0 QRCODE_MASK_5,&nbsp; // (i * j) % 2 + (i * j) % 3 = 0 QRCODE_MASK_6,&nbsp; // ((i * j) % 3 + i * j) % 2 = 0 QRCODE_MASK_7,&nbsp; // ((i * j) % 3 + i + j) % 2 = 0 // QRCODE_MASK_MAX, };</div></div>",163:"<div class=\"NDToolTip TEnumeration LC\"><div class=\"TTSummary\">Describes how a segment\'s data bits are interpreted.</div></div>",165:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">Calculates the number of bytes needed to store any QR Code up to and including the given version number, as a compile-time constant. For example, \'u8 buffer[QRCODE_BUFFER_LEN_FOR_VERSION(25)];\' can store any single QR Code from version 1 to 25 (inclusive). The result fits in an i16 (or int16).&nbsp; Requires QRCODE_VERSION_MIN &lt;= n &lt;= QRCODE_VERSION_MAX.</div></div>",166:"<div class=\"NDToolTip TMacro LC\"><div class=\"TTSummary\">The worst-case number of bytes needed to store one QR Code, up to and including version 40. This value equals 3918, which is just under 4 kilobytes.&nbsp; Use this more convenient value to avoid calculating tighter memory bounds for buffers.</div></div>",168:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype168\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_EncodeText(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">char</span>&nbsp;</td><td class=\"PSymbols\">*</td><td class=\"PName last\">text,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td></td><td class=\"PName last\">tempBuffer[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td></td><td class=\"PName last\">qrcode[],</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_ECC&nbsp;</td><td></td><td class=\"PName last\">ecl,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_MASK&nbsp;</td><td></td><td class=\"PName last\">mask</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Encodes the given text string to a QR Code, returning TRUE if successful.&nbsp; If the data is too long to fit in any version in the given range at the given ECC level, then FALSE is returned.</div></div>",169:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype169\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_EncodeBinary(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">dataAndTemp[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">dataLen,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[],</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_ECC&nbsp;</td><td class=\"PName last\">ecl,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_MASK&nbsp;</td><td class=\"PName last\">mask</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Encodes the given binary data to a QR Code, returning TRUE if successful.&nbsp; If the data is too long to fit in any version in the given range at the given ECC level, then FALSE is returned.</div></div>",170:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype170\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_EncodeSegments(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const struct</span>&nbsp;</td><td class=\"PType\">QRCode_Segment&nbsp;</td><td class=\"PName last\">segs[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_ECC&nbsp;</td><td class=\"PName last\">ecl,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">tempBuffer[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[]</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Encodes the given segments to a QR Code, returning TRUE if successful.&nbsp; If the data is too long to fit in any version at the given ECC level, then FALSE is returned.</div></div>",171:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype171\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_EncodeSegmentsAdvanced(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const struct</span>&nbsp;</td><td class=\"PType\">QRCode_Segment&nbsp;</td><td class=\"PName last\">segs[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_ECC&nbsp;</td><td class=\"PName last\">ecl,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_MASK&nbsp;</td><td class=\"PName last\">mask,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">tempBuffer[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[]</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Encodes the given segments to a QR Code, returning TRUE if successful.&nbsp; If the data is too long to fit in any version in the given range at the given ECC level, then FALSE is returned.</div></div>",172:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype172\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_IsNumeric(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">char</span>&nbsp;</td><td class=\"PSymbols\">*</td><td class=\"PName last\">text</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Tests whether the given string can be encoded as a segment in numeric mode.&nbsp; A string is encodable iff each character is in the range 0 to 9.</div></div>",173:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype173\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_IsAlphanumeric(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">char</span>&nbsp;</td><td class=\"PSymbols\">*</td><td class=\"PName last\">text</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Tests whether the given string can be encoded as a segment in alphanumeric mode.&nbsp; A string is encodable iff each character is in the following set: 0 to 9, A to Z (uppercase only), space, dollar, percent, asterisk, plus, hyphen, period, slash, colon.</div></div>",174:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype174\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u16 QRCode_CalcSegmentBufferSize(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">enum</span>&nbsp;</td><td class=\"PType\">QRCODE_MODE&nbsp;</td><td class=\"PName last\">mode,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">numChars</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns the number of bytes (u8) needed for the data buffer of a segment containing the given number of characters using the given mode. Notes: - Returns SIZE_MAX on failure, i.e. numChars &gt; INT16_MAX or the internal calculation of the number of needed bits exceeds INT16_MAX (i.e. 32767).&nbsp; - Otherwise, all valid results are in the range [0, ceil(INT16_MAX / 8)], i.e. at most 4096.&nbsp; - It is okay for the user to allocate more bytes for the buffer than needed.&nbsp; - For byte mode, numChars measures the number of bytes, not Unicode code points.&nbsp; - For ECI mode, numChars must be 0, and the worst-case number of bytes is returned.&nbsp; An actual ECI segment can have shorter data. For non-ECI modes, the result is exact.</div></div>",175:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype175\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> QRCode_MakeBytes(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">data[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">len,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">buf[],</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">struct</span>&nbsp;</td><td class=\"PType\">QRCode_Segment*&nbsp;</td><td class=\"PName last\">seg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns a segment representing the given binary data encoded in byte mode. All input byte arrays are acceptable. Any text string can be converted to UTF-8 bytes and encoded as a byte mode segment.</div></div>",176:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype176\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> QRCode_MakeNumeric(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">char</span>&nbsp;</td><td class=\"PSymbols\">*</td><td class=\"PName last\">digits,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td></td><td class=\"PName last\">buf[],</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">struct</span>&nbsp;</td><td class=\"PType\">QRCode_Segment*&nbsp;</td><td></td><td class=\"PName last\">seg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns a segment representing the given string of decimal digits encoded in numeric mode.</div></div>",177:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype177\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> QRCode_MakeAlphanumeric(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\"><span class=\"SHKeyword\">char</span>&nbsp;</td><td class=\"PSymbols\">*</td><td class=\"PName last\">text,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td></td><td class=\"PName last\">buf[],</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">struct</span>&nbsp;</td><td class=\"PType\">QRCode_Segment*&nbsp;</td><td></td><td class=\"PName last\">seg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns a segment representing the given text string encoded in alphanumeric mode.&nbsp; The characters allowed are: 0 to 9, A to Z (uppercase only), space, dollar, percent, asterisk, plus, hyphen, period, slash, colon.</div></div>",178:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype178\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> QRCode_MakeECI(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">i32&nbsp;</td><td class=\"PName last\">assignVal,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">buf[],</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">struct</span>&nbsp;</td><td class=\"PType\">QRCode_Segment*&nbsp;</td><td class=\"PName last\">seg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns a segment representing an Extended Channel Interpretation (ECI) designator with the given assignment value.</div></div>",179:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype179\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 QRCode_GetSize(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[]</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns the side length of the given QR Code, assuming that encoding succeeded.&nbsp; The result is in the range [21, 177]. Note that the length of the array buffer is related to the side length - every \'u8 qrcode[]\' must have length at least QRCODE_BUFFER_LEN_FOR_VERSION(version), which equals ceil(size^2 / 8 + 1).</div></div>",180:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype180\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">bool</span> QRCode_GetModule(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns the color of the module (pixel) at the given coordinates, which is FALSE for light or TRUE for dark.&nbsp; The top left corner has the coordinates (x=0, y=0).&nbsp; Coordinates must be in bounds.</div></div>",181:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype181\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 QRCode_GetByte(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[],</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Returns colors of 8 module (byte) at the given coordinates, which is 0 for light or 1 for dark.&nbsp; The top left corner has the coordinates (x=0, y=0).</div></div>",182:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype182\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u8 QRCode_GetVersion(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">qrcode[]</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div></div>",183:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype183\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> QRCode_SetVersion(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">min,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">max</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set minimum and maximum version to use for the next encoding.&nbsp; Must be called before QRCode_Encode* functions.</div></div>",184:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype184\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> QRCode_SetBoostECL(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">boost</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set ECC level boost option.</div></div>"});