﻿NDSummary.OnToolTipsLoaded("File:v9990.h",{84:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype84\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetPort(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">port,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">value</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, d, e, h, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Set port value.</div></div>",984:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype984\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 V9_GetPort(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">port</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Get port value.</div></div>",985:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype985\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetRegister(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">reg,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, c, d, e, h, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Set register value.&nbsp; This function as no effect if register is read-only.</div></div>",986:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype986\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetRegister16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">reg,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Set register value.&nbsp; This function as no effect if register is read-only.</div></div>",987:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype987\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\">u8 V9_GetRegister(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">reg</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Get register value.</div></div>",988:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype988\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetFlag(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">reg,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">mask,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">flag</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Helper function to change some bits in a given register.&nbsp; The function get a register value, apply a mask, \'or\' the new value, than set the register.</div></div>",989:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype989\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetWriteAddress(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Initialize VRAM address for writing.</div></div>",990:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype990\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetReadAddress(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Initialize VRAM address for reading.</div></div>",466:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype466\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_FillVRAM_CurrentAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">value,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Fill VRAM with 8-bits value from the previously setup write VRAM address.&nbsp; V9_SetWriteAddress have to be called first.</div></div>",775:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype775\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_FillVRAM16_CurrentAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">value,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Fill VRAM with 16-bits value from the previously setup write VRAM address.&nbsp; V9_SetWriteAddress have to be called first.</div></div>",776:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype776\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_WriteVRAM_CurrentAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8*&nbsp;</td><td class=\"PName last\">src,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Copy data from RAM buffer to the previously setup write VRAM address.&nbsp; V9_SetWriteAddress have to be called first.</div></div>",777:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype777\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_ReadVRAM_CurrentAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8*&nbsp;</td><td class=\"PName last\">dest,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Copy data from the previously setup read VRAM address to a RAM buffer.&nbsp; V9_SetReadAddress have to be called first.</div></div>",778:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype778\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_Poke_CurrentAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, c, d, e, h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Write a 8-bits value to the previously setup write VRAM address.&nbsp; V9_SetWriteAddress have to be called first.</div></div>",779:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype779\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_Poke16_CurrentAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(b, c, d, e, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Write a 16-bits value to the previously setup write VRAM address.&nbsp; V9_SetWriteAddress have to be called first.</div></div>",780:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype780\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">u8 V9_Peek_CurrentAddr() __PRESERVES(b, c, d, e, h, l, iyl, iyh)</div></div><div class=\"TTSummary\">Read a 8-bits value from the previously setup write VRAM address.&nbsp; V9_SetReadAddress have to be called first.</div></div>",781:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype781\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\">u16 V9_Peek16_CurrentAddr() __PRESERVES(b, c, h, l, iyl, iyh)</div></div><div class=\"TTSummary\">Read a 16-bits value from the previously setup write VRAM address.&nbsp; V9_SetReadAddress have to be called first.</div></div>",1006:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1006\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_FillVRAM(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">value,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Fill VRAM with 8-bits value start to a given VRAM address.</div></div>",1007:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1007\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_FillVRAM16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">value,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Fill VRAM with 16-bits value start to the given VRAM address.</div></div>",1008:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1008\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_WriteVRAM(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u32&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8*&nbsp;</td><td class=\"PName last\">src,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Copy data from a RAM buffer to the given VRAM address.</div></div>",1009:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1009\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_ReadVRAM(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u32&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8*&nbsp;</td><td class=\"PName last\">dest,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u16&nbsp;</td><td class=\"PName last\">count</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Copy data from a given VRAM address to a RAM buffer.</div></div>",1010:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1010\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_Poke(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Write a 8-bits value to the given VRAM address.</div></div>",1011:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1011\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_Poke16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">val</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Write a 16-bits value to the given VRAM address.</div></div>",1012:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1012\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u8 V9_Peek(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Read a 8-bits value from at the given VRAM address.</div></div>",1013:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1013\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u16 V9_Peek16(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Read a 16-bits value from at the given VRAM address.</div></div>",1133:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1133\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetScreenMode(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">mode</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the current screen mode.</div></div>",1134:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1134\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetBPP(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">bpp</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set bitmap bit-per-pixel value.</div></div>",1135:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1135\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetColorMode(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">mode</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set bitmap color mode.</div></div>",1016:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1016\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline</span> u8 V9_GetBPP()</div></div><div class=\"TTSummary\">Get bit number per pixel.</div></div>",1017:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1017\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetImageSpaceWidth(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">width</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set number of pixels in X direction of image space.</div></div>",1018:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1018\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline</span> u8 V9_GetImageSpaceWidth()</div></div><div class=\"TTSummary\">Get number of pixels in X direction of image space.</div></div>",1019:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1019\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetDisplayEnable(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Enalbe or disable the screen display.</div></div>",1020:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1020\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetBackgroundColor(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">color</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set background color.</div></div>",1021:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1021\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline</span> u8 V9_GetBackgroundColor()</div></div><div class=\"TTSummary\">Get background color.</div></div>",1022:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1022\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetAdjustOffset(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">offset</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Adjustment of the display location on the screen.</div></div>",1023:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1023\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetAdjustOffsetXY(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">i8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Adjustment of the display location on the screen.</div></div>",1024:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1024\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetLayerPriority(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set layer priority for P1 mode.</div></div>",1025:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1025\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline</span> u8 V9_GetStatus()</div></div><div class=\"TTSummary\">Get status port value.</div></div>",1026:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1026\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline bool</span> V9_IsVBlank()</div></div><div class=\"TTSummary\">Is vertical non-display period.</div></div>",1027:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1027\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline bool</span> V9_IsHBlank()</div></div><div class=\"TTSummary\">Is horizontal non-display period.</div></div>",1028:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1028\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline bool</span> V9_IsCmdDataReady()</div></div><div class=\"TTSummary\">Check if command data transfer ready.</div></div>",1029:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1029\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline bool</span> V9_IsCmdRunning()</div></div><div class=\"TTSummary\">Check if a command is in process.</div></div>",1030:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1030\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline bool</span> V9_IsCmdComplete()</div></div><div class=\"TTSummary\">Check if a no command is in process.</div></div>",1031:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1031\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline bool</span> V9_IsSecondField()</div></div><div class=\"TTSummary\">Check if render is in the second field period during interlace.</div></div>",1032:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1032\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetInterrupt(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">flags</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set interruption flags.</div></div>",1033:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1033\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline void</span> V9_DisableInterrupt()</div></div><div class=\"TTSummary\">Disable all interruptions.</div></div>",1034:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1034\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetVBlankInterrupt(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set vertical blank interruption.</div></div>",1035:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1035\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetHBlankInterrupt(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set horizontal blank interruption.</div></div>",1036:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1036\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCmdEndInterrupt(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set command end interruption.</div></div>",1037:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1037\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetInterruptLine(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">line</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Specification of vertical position where display position interrupt occurs.</div></div>",1038:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1038\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline void</span> V9_SetInterruptEveryLine()</div></div><div class=\"TTSummary\">Set line interrupt on every line.</div></div>",1039:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1039\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetInterruptX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Specification of horizontal position where display position interrupt occurs.</div></div>",1040:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1040\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetScrollingX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">x</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set horizontal scrolling value.</div></div>",1041:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1041\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetScrollingY(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set vertical scrolling value.</div></div>",1042:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1042\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetScrolling(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set horizontal and vertical scrolling values.</div></div>",1043:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1043\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetScrollingBX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">x</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set horizontal scrolling value for layer B (P1 mode only).</div></div>",1044:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1044\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetScrollingBY(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set vertical scrolling value for layer B (P1 mode only).</div></div>",1045:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1045\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetScrollingB(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set horizontal and vertical scrolling values for layer B (P1 mode only).</div></div>",93:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype93\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCursorEnable(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Enable/disable all cursor display.</div></div>",1046:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1046\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetCursorAttribute(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">y,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">color</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the given cursor atribute (for bitmap modes).</div></div>",405:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype405\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetCursorDisplay(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Display/hide the given cursor</div></div>",1115:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1115\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCursorPattern(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u8*&nbsp;</td><td class=\"PName last\">data</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the given cursor pattern.</div></div>",1049:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1049\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCursorPalette(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">offset</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set cursor palette offset.</div></div>",1050:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1050\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteEnable(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">enable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Enable/disable all sprites display.</div></div>",1051:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1051\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePatternAddr(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">addr</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite patterns VRAM address.</div></div>",224:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype224\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePaletteOffset(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">offset</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite palette offset.</div></div>",233:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype233\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const struct</span>&nbsp;</td><td class=\"PType\">V9_Sprite*&nbsp;</td><td class=\"PName last\">attr</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite attribute for P1 mode.</div></div>",478:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype478\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePatternP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">pat</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite pattern for P1 mode.</div></div>",583:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype583\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePositionP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite position for P1 mode.</div></div>",597:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype597\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteInfoP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">info</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite additionnal information for P1 mode.</div></div>",966:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype966\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteDisableP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">disable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite disable flag for P1 mode.</div></div>",1146:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1146\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePriorityP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">prio</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite priority for P1 mode.</div></div>",1147:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1147\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePaletteP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">pal</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite palette for P1 mode.</div></div>",1171:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1171\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const struct</span>&nbsp;</td><td class=\"PType\">V9_Sprite*&nbsp;</td><td class=\"PName last\">attr</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite attribute for P2 mode.</div></div>",1172:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1172\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePatternP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">pat</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite pattern for P2 mode.</div></div>",1173:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1173\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePositionP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite position for P2 mode.</div></div>",1174:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1174\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteInfoP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">info</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite additionnal information for P2 mode.</div></div>",1175:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1175\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpriteDisableP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\"><span class=\"SHKeyword\">bool</span>&nbsp;</td><td class=\"PName last\">disable</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite disable flag for P2 mode.</div></div>",1176:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1176\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePriorityP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">prio</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite priority for P2 mode.</div></div>",1177:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1177\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetSpritePaletteP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">id,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">pal</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set sprite palette for P2 mode.</div></div>",1059:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1059\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">void</span> V9_SetPaletteEntry(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">index,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">color</td></tr></table></td><td class=\"PAfterParameters\">) __PRESERVES(h, l, iyl, iyh)</td></tr></table></div></div><div class=\"TTSummary\">Set the color of a given palette entry.</div></div>",1060:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1060\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetPalette(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">first,</td></tr><tr><td class=\"first\"></td><td class=\"PType\">u8&nbsp;</td><td class=\"PName last\">num,</td></tr><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u16*&nbsp;</td><td class=\"PName last\">table</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the colors of a given palette entries.</div></div>",1061:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1061\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetPaletteAll(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PModifierQualifier first\"><span class=\"SHKeyword\">const</span>&nbsp;</td><td class=\"PType\">u16*&nbsp;</td><td class=\"PName last\">table</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the colors of all the palette 64 entries.</div></div>",1062:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1062\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SelectPaletteP1(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">a,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">b</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the P1 mode palette offset.</div></div>",1063:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1063\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SelectPaletteP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">a</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the P2 mode palette offset.</div></div>",1064:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1064\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SelectPaletteBP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">a</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the BP2 mode palette offset (R#13 PLTO5-2).</div></div>",1065:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1065\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SelectPaletteBP4(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">a</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the BP4 mode palette offset (R#13 PLTO5-4).</div></div>",1066:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1066\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandSX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sx</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set source X-coordinate.</div></div>",1067:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1067\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandSY(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sy</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set source Y-coordinate.</div></div>",1068:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1068\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandSA(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">sa</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set source VRAM address.</div></div>",1069:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1069\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandDX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set destination X-coordinate.</div></div>",1070:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1070\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandDY(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set destination Y-coordinate.</div></div>",1071:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1071\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandDA(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">da</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set destination VRAM address.</div></div>",1072:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1072\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandNX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the number of pixels in X direction.</div></div>",1073:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1073\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandNY(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the number of pixels in Y direction.</div></div>",1074:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1074\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandMJ(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">mj</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the length of the longer side of the rectangle.</div></div>",1075:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1075\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandMI(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">mi</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the length of the shorter side of the rectangle.</div></div>",1076:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1076\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandNA(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">na</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set the number of bytes.</div></div>",1077:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1077\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandArgument(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set command argument.</div></div>",1078:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1078\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandLogicalOp(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">lop</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set command logical operation.</div></div>",1079:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1079\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandWriteMask(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">wm</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set command write mask.</div></div>",1080:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1080\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandFC(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set color code of font data &quot;1&quot;.</div></div>",1081:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1081\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_SetCommandBC(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">bc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set color code of font data &quot;0&quot;.</div></div>",1082:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1082\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_ExecCommand(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">op</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Set operation code.</div></div>",1083:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1083\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline</span> u16 GetCommandBX()</div></div><div class=\"TTSummary\">Set search command border coordinate.</div></div>",701:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype701\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline void</span> V9_CommandSTOP()</div></div><div class=\"TTSummary\">Command being executed is stopped.</div></div>",1084:"<div class=\"NDToolTip TFunction LC\"><div class=\"TTSummary\">Data is transferred from CPU to VRAM rectangle area.&nbsp; Note: Infinished function; don\'t use it.</div></div>",1085:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1085\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandLMMV(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">VRAM rectangle area is painted out.</div></div>",1086:"<div class=\"NDToolTip TFunction LC\"><div class=\"TTSummary\">VRAM rectangle area data is transferred to CPU.&nbsp; Note: Infinished function; don\'t use it.</div></div>",1087:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1087\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandLMMM(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Rectangle area data is transferred from VRAM to VRAM.</div></div>",1088:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1088\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandCMMC(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">bc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">CPU character data is color-developed and transferred to VRAM rectangle area.</div></div>",1089:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1089\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandCMMM(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">sa,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">bc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">VRAM character data is color-developed and transferred to VRAM rectangle area.</div></div>",1090:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1090\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandBMXL(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">sa,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Data on VRAM linear address is transferred to VRAM rectangle area.</div></div>",1091:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1091\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandBMLX(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sy,</td></tr><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">da,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">nx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">ny,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">VRAM rectangle area data is transferred onto VRAM linear address.</div></div>",1092:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1092\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandBMLL(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">sa,</td></tr><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">da,</td></tr><tr><td class=\"PType first\">u32&nbsp;</td><td class=\"PName last\">na,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Data on VRAM linear address is transferred onto VRAM linear address.</div></div>",1093:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1093\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandLINE(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">mj,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">mi,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Straight line is drawn on X/Y-coordinates.</div></div>",1094:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1094\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandSEARCH(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sy,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">arg,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Border color coordinates on X/Y space are detected.</div></div>",1095:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1095\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandPOINT(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">sy</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Color code of specified point on X/Y-coordinates is read out.</div></div>",1096:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1096\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandPSET(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">fc,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">shift</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Drawing is executed at drawing point on X/Y-coordinates.</div></div>",1097:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1097\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline void</span> V9_CommandADVANCE(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dx,</td></tr><tr><td class=\"PType first\">u16&nbsp;</td><td class=\"PName last\">dy,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">shift</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Drawing point on X/Y-coordinates is shifted.</div></div>",1098:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1098\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">bool</span> V9_Detect()</div></div><div class=\"TTSummary\">Detecting the presence of a V9990 card</div></div>",1131:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1131\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">void</span> V9_ClearVRAM() __PRESERVES(d, e, h, l, iyl, iyh)</div></div><div class=\"TTSummary\">Clear the whole 512 KB of VRAM with zero</div></div>",631:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype631\" class=\"NDPrototype\"><div class=\"PSection PPlainSection\"><span class=\"SHKeyword\">inline void</span> V9_WaitCmdEnd()</div></div><div class=\"TTSummary\">Wait for current command completion</div></div>",1099:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1099\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u32 V9_CellAddrP1A(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get address fo the given X/Y cell coordiante for player A of P1 mode.</div></div>",1100:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1100\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u32 V9_CellAddrP1B(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get address fo the given X/Y cell coordiante for player B of P1 mode.</div></div>",1101:"<div class=\"NDToolTip TFunction LC\"><div id=\"NDPrototype1101\" class=\"NDPrototype WideForm\"><div class=\"PSection PParameterSection CStyle\"><table><tr><td class=\"PBeforeParameters\"><span class=\"SHKeyword\">inline</span> u32 V9_CellAddrP2(</td><td class=\"PParametersParentCell\"><table class=\"PParameters\"><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">x,</td></tr><tr><td class=\"PType first\">u8&nbsp;</td><td class=\"PName last\">y</td></tr></table></td><td class=\"PAfterParameters\">)</td></tr></table></div></div><div class=\"TTSummary\">Get address fo the given X/Y cell coordiante for P2 mode.</div></div>"});