const locUtil = require("./localize_util.js"); 

//-----------------------------------------------------------------------------
// Name:   Map from MSX Russian (video) character set to Unicode
// Date:   2019 September 28
// Author: Rebecca Bettencourt <support@kreativekorp.com>
const MapCYRtoMSX = {
	0x0000: [ 0x00 ], // NULL
	0x263A: [ 0x01 ], // WHITE SMILING FACE
	0x263B: [ 0x02 ], // BLACK SMILING FACE
	0x2665: [ 0x03 ], // BLACK HEART SUIT
	0x2666: [ 0x04 ], // BLACK DIAMOND SUIT
	0x2663: [ 0x05 ], // BLACK CLUB SUIT
	0x2660: [ 0x06 ], // BLACK SPADE SUIT
	0x2022: [ 0x07 ], // BULLET
	0x25D8: [ 0x08 ], // INVERSE BULLET
	0x25CB: [ 0x09 ], // WHITE CIRCLE
	0x25D9: [ 0x0A ], // INVERSE WHITE CIRCLE
	0x2642: [ 0x0B ], // MALE SIGN
	0x2640: [ 0x0C ], // FEMALE SIGN
	0x266A: [ 0x0D ], // EIGHTH NOTE
	0x266B: [ 0x0E ], // BEAMED EIGHTH NOTES
	0x263C: [ 0x0F ], // WHITE SUN WITH RAYS
	0x27CA: [ 0x10 ], // VERTICAL BAR WITH HORIZONTAL STROKE
	0x2534: [ 0x11 ], // BOX DRAWINGS LIGHT UP AND HORIZONTAL
	0x252C: [ 0x12 ], // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
	0x2524: [ 0x13 ], // BOX DRAWINGS LIGHT VERTICAL AND LEFT
	0x251C: [ 0x14 ], // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
	0x253C: [ 0x15 ], // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
	0x2502: [ 0x16 ], // BOX DRAWINGS LIGHT VERTICAL
	0x2500: [ 0x17 ], // BOX DRAWINGS LIGHT HORIZONTAL
	0x250C: [ 0x18 ], // BOX DRAWINGS LIGHT DOWN AND RIGHT
	0x2510: [ 0x19 ], // BOX DRAWINGS LIGHT DOWN AND LEFT
	0x2514: [ 0x1A ], // BOX DRAWINGS LIGHT UP AND RIGHT
	0x2518: [ 0x1B ], // BOX DRAWINGS LIGHT UP AND LEFT
	0x2573: [ 0x1C ], // BOX DRAWINGS LIGHT DIAGONAL CROSS
	0x2571: [ 0x1D ], // BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
	0x2572: [ 0x1E ], // BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
	0x1FBAF: [ 0x1F ], // BOX DRAWINGS LIGHT HORIZONTAL WITH VERTICAL STROKE
	0x0020: [ 0x20 ], // SPACE
	0x0021: [ 0x21 ], // EXCLAMATION MARK
	0x0022: [ 0x22 ], // QUOTATION MARK
	0x0023: [ 0x23 ], // NUMBER SIGN
	0x0024: [ 0x24 ], // DOLLAR SIGN
	0x0025: [ 0x25 ], // PERCENT SIGN
	0x0026: [ 0x26 ], // AMPERSAND
	0x0027: [ 0x27 ], // APOSTROPHE
	0x0028: [ 0x28 ], // LEFT PARENTHESIS
	0x0029: [ 0x29 ], // RIGHT PARENTHESIS
	0x002A: [ 0x2A ], // ASTERISK
	0x002B: [ 0x2B ], // PLUS SIGN
	0x002C: [ 0x2C ], // COMMA
	0x002D: [ 0x2D ], // HYPHEN-MINUS
	0x002E: [ 0x2E ], // FULL STOP
	0x002F: [ 0x2F ], // SOLIDUS
	0x0030: [ 0x30 ], // DIGIT ZERO
	0x0031: [ 0x31 ], // DIGIT ONE
	0x0032: [ 0x32 ], // DIGIT TWO
	0x0033: [ 0x33 ], // DIGIT THREE
	0x0034: [ 0x34 ], // DIGIT FOUR
	0x0035: [ 0x35 ], // DIGIT FIVE
	0x0036: [ 0x36 ], // DIGIT SIX
	0x0037: [ 0x37 ], // DIGIT SEVEN
	0x0038: [ 0x38 ], // DIGIT EIGHT
	0x0039: [ 0x39 ], // DIGIT NINE
	0x003A: [ 0x3A ], // COLON
	0x003B: [ 0x3B ], // SEMICOLON
	0x003C: [ 0x3C ], // LESS-THAN SIGN
	0x003D: [ 0x3D ], // EQUALS SIGN
	0x003E: [ 0x3E ], // GREATER-THAN SIGN
	0x003F: [ 0x3F ], // QUESTION MARK
	0x0040: [ 0x40 ], // COMMERCIAL AT
	0x0041: [ 0x41 ], // LATIN CAPITAL LETTER A
	0x0042: [ 0x42 ], // LATIN CAPITAL LETTER B
	0x0043: [ 0x43 ], // LATIN CAPITAL LETTER C
	0x0044: [ 0x44 ], // LATIN CAPITAL LETTER D
	0x0045: [ 0x45 ], // LATIN CAPITAL LETTER E
	0x0046: [ 0x46 ], // LATIN CAPITAL LETTER F
	0x0047: [ 0x47 ], // LATIN CAPITAL LETTER G
	0x0048: [ 0x48 ], // LATIN CAPITAL LETTER H
	0x0049: [ 0x49 ], // LATIN CAPITAL LETTER I
	0x004A: [ 0x4A ], // LATIN CAPITAL LETTER J
	0x004B: [ 0x4B ], // LATIN CAPITAL LETTER K
	0x004C: [ 0x4C ], // LATIN CAPITAL LETTER L
	0x004D: [ 0x4D ], // LATIN CAPITAL LETTER M
	0x004E: [ 0x4E ], // LATIN CAPITAL LETTER N
	0x004F: [ 0x4F ], // LATIN CAPITAL LETTER O
	0x0050: [ 0x50 ], // LATIN CAPITAL LETTER P
	0x0051: [ 0x51 ], // LATIN CAPITAL LETTER Q
	0x0052: [ 0x52 ], // LATIN CAPITAL LETTER R
	0x0053: [ 0x53 ], // LATIN CAPITAL LETTER S
	0x0054: [ 0x54 ], // LATIN CAPITAL LETTER T
	0x0055: [ 0x55 ], // LATIN CAPITAL LETTER U
	0x0056: [ 0x56 ], // LATIN CAPITAL LETTER V
	0x0057: [ 0x57 ], // LATIN CAPITAL LETTER W
	0x0058: [ 0x58 ], // LATIN CAPITAL LETTER X
	0x0059: [ 0x59 ], // LATIN CAPITAL LETTER Y
	0x005A: [ 0x5A ], // LATIN CAPITAL LETTER Z
	0x005B: [ 0x5B ], // LEFT SQUARE BRACKET
	0x005C: [ 0x5C ], // REVERSE SOLIDUS
	0x005D: [ 0x5D ], // RIGHT SQUARE BRACKET
	0x005E: [ 0x5E ], // CIRCUMFLEX ACCENT
	0x005F: [ 0x5F ], // LOW LINE
	0x0060: [ 0x60 ], // GRAVE ACCENT
	0x0061: [ 0x61 ], // LATIN SMALL LETTER A
	0x0062: [ 0x62 ], // LATIN SMALL LETTER B
	0x0063: [ 0x63 ], // LATIN SMALL LETTER C
	0x0064: [ 0x64 ], // LATIN SMALL LETTER D
	0x0065: [ 0x65 ], // LATIN SMALL LETTER E
	0x0066: [ 0x66 ], // LATIN SMALL LETTER F
	0x0067: [ 0x67 ], // LATIN SMALL LETTER G
	0x0068: [ 0x68 ], // LATIN SMALL LETTER H
	0x0069: [ 0x69 ], // LATIN SMALL LETTER I
	0x006A: [ 0x6A ], // LATIN SMALL LETTER J
	0x006B: [ 0x6B ], // LATIN SMALL LETTER K
	0x006C: [ 0x6C ], // LATIN SMALL LETTER L
	0x006D: [ 0x6D ], // LATIN SMALL LETTER M
	0x006E: [ 0x6E ], // LATIN SMALL LETTER N
	0x006F: [ 0x6F ], // LATIN SMALL LETTER O
	0x0070: [ 0x70 ], // LATIN SMALL LETTER P
	0x0071: [ 0x71 ], // LATIN SMALL LETTER Q
	0x0072: [ 0x72 ], // LATIN SMALL LETTER R
	0x0073: [ 0x73 ], // LATIN SMALL LETTER S
	0x0074: [ 0x74 ], // LATIN SMALL LETTER T
	0x0075: [ 0x75 ], // LATIN SMALL LETTER U
	0x0076: [ 0x76 ], // LATIN SMALL LETTER V
	0x0077: [ 0x77 ], // LATIN SMALL LETTER W
	0x0078: [ 0x78 ], // LATIN SMALL LETTER X
	0x0079: [ 0x79 ], // LATIN SMALL LETTER Y
	0x007A: [ 0x7A ], // LATIN SMALL LETTER Z
	0x007B: [ 0x7B ], // LEFT CURLY BRACKET
	0x007C: [ 0x7C ], // VERTICAL LINE
	0x007D: [ 0x7D ], // RIGHT CURLY BRACKET
	0x007E: [ 0x7E ], // TILDE
	0x2302: [ 0x7F ], // HOUSE
	0x2582: [ 0x80 ], // LOWER ONE QUARTER BLOCK
	0x259A: [ 0x81 ], // QUADRANT UPPER LEFT AND LOWER RIGHT
	0x2586: [ 0x82 ], // LOWER THREE QUARTERS BLOCK
	0x1FB82: [ 0x83 ], // UPPER ONE QUARTER BLOCK
	0x25AC: [ 0x84 ], // BLACK RECTANGLE
	0x1FB85: [ 0x85 ], // UPPER THREE QUARTERS BLOCK
	0x258E: [ 0x86 ], // LEFT ONE QUARTER BLOCK
	0x259E: [ 0x87 ], // QUADRANT UPPER RIGHT AND LOWER LEFT
	0x258A: [ 0x88 ], // LEFT THREE QUARTERS BLOCK
	0x1FB87: [ 0x89 ], // RIGHT ONE QUARTER BLOCK
	0x1FB8A: [ 0x8A ], // RIGHT THREE QUARTERS BLOCK
	0x1FB99: [ 0x8B ], // UPPER RIGHT TO LOWER LEFT FILL
	0x1FB98: [ 0x8C ], // UPPER LEFT TO LOWER RIGHT FILL
	0x1FB6D: [ 0x8D ], // UPPER TRIANGULAR ONE QUARTER BLOCK
	0x1FB6F: [ 0x8E ], // LOWER TRIANGULAR ONE QUARTER BLOCK
	0x1FB6C: [ 0x8F ], // LEFT TRIANGULAR ONE QUARTER BLOCK
	0x1FB6E: [ 0x90 ], // RIGHT TRIANGULAR ONE QUARTER BLOCK
	0x1FB9A: [ 0x91 ], // UPPER AND LOWER TRIANGULAR HALF BLOCK
	0x1FB9B: [ 0x92 ], // LEFT AND RIGHT TRIANGULAR HALF BLOCK
	0x2598: [ 0x93 ], // QUADRANT UPPER LEFT
	0x2597: [ 0x94 ], // QUADRANT LOWER RIGHT
	0x259D: [ 0x95 ], // QUADRANT UPPER RIGHT
	0x2596: [ 0x96 ], // QUADRANT LOWER LEFT
	0x1FB96: [ 0x97 ], // INVERSE CHECKER BOARD FILL
	0x0394: [ 0x98 ], // GREEK CAPITAL LETTER DELTA
	0x2021: [ 0x99 ], // DOUBLE DAGGER
	0x03C9: [ 0x9A ], // GREEK SMALL LETTER OMEGA
	0x2588: [ 0x9B ], // FULL BLOCK
	0x2584: [ 0x9C ], // LOWER HALF BLOCK
	0x258C: [ 0x9D ], // LEFT HALF BLOCK
	0x2590: [ 0x9E ], // RIGHT HALF BLOCK
	0x2580: [ 0x9F ], // UPPER HALF BLOCK
	0x03B1: [ 0xA0 ], // GREEK SMALL LETTER ALPHA
	0x00DF: [ 0xA1 ], // LATIN SMALL LETTER SHARP S
	0x0393: [ 0xA2 ], // GREEK CAPITAL LETTER GAMMA
	0x03C0: [ 0xA3 ], // GREEK SMALL LETTER PI
	0x03A3: [ 0xA4 ], // GREEK CAPITAL LETTER SIGMA
	0x03C3: [ 0xA5 ], // GREEK SMALL LETTER SIGMA
	0x00B5: [ 0xA6 ], // MICRO SIGN
	0x03C4: [ 0xA7 ], // GREEK SMALL LETTER TAU
	0x03A6: [ 0xA8 ], // GREEK CAPITAL LETTER PHI
	0x0398: [ 0xA9 ], // GREEK CAPITAL LETTER THETA
	0x03A9: [ 0xAA ], // GREEK CAPITAL LETTER OMEGA
	0x03B4: [ 0xAB ], // GREEK SMALL LETTER DELTA
	0x221E: [ 0xAC ], // INFINITY
	0x2205: [ 0xAD ], // EMPTY SET
	0x2208: [ 0xAE ], // ELEMENT OF
	0x2229: [ 0xAF ], // INTERSECTION
	0x2261: [ 0xB0 ], // IDENTICAL TO
	0x00B1: [ 0xB1 ], // PLUS-MINUS SIGN
	0x2265: [ 0xB2 ], // GREATER-THAN OR EQUAL TO
	0x2264: [ 0xB3 ], // LESS-THAN OR EQUAL TO
	0x2320: [ 0xB4 ], // TOP HALF INTEGRAL
	0x2321: [ 0xB5 ], // BOTTOM HALF INTEGRAL
	0x00F7: [ 0xB6 ], // DIVISION SIGN
	0x2248: [ 0xB7 ], // ALMOST EQUAL TO
	0x00B0: [ 0xB8 ], // DEGREE SIGN
	0x2219: [ 0xB9 ], // BULLET OPERATOR
	0x00B7: [ 0xBA ], // MIDDLE DOT
	0x221A: [ 0xBB ], // SQUARE ROOT
	0x207F: [ 0xBC ], // SUPERSCRIPT LATIN SMALL LETTER N
	0x00B2: [ 0xBD ], // SUPERSCRIPT TWO
	0x25A0: [ 0xBE ], // BLACK SQUARE
	0x00A4: [ 0xBF ], // CURRENCY SIGN
	0x044E: [ 0xC0 ], // CYRILLIC SMALL LETTER YU
	0x0430: [ 0xC1 ], // CYRILLIC SMALL LETTER A
	0x0431: [ 0xC2 ], // CYRILLIC SMALL LETTER BE
	0x0446: [ 0xC3 ], // CYRILLIC SMALL LETTER TSE
	0x0434: [ 0xC4 ], // CYRILLIC SMALL LETTER DE
	0x0435: [ 0xC5 ], // CYRILLIC SMALL LETTER IE
	0x0444: [ 0xC6 ], // CYRILLIC SMALL LETTER EF
	0x0433: [ 0xC7 ], // CYRILLIC SMALL LETTER GHE
	0x0445: [ 0xC8 ], // CYRILLIC SMALL LETTER HA
	0x0438: [ 0xC9 ], // CYRILLIC SMALL LETTER I
	0x0439: [ 0xCA ], // CYRILLIC SMALL LETTER SHORT I
	0x043A: [ 0xCB ], // CYRILLIC SMALL LETTER KA
	0x043B: [ 0xCC ], // CYRILLIC SMALL LETTER EL
	0x043C: [ 0xCD ], // CYRILLIC SMALL LETTER EM
	0x043D: [ 0xCE ], // CYRILLIC SMALL LETTER EN
	0x043E: [ 0xCF ], // CYRILLIC SMALL LETTER O
	0x043F: [ 0xD0 ], // CYRILLIC SMALL LETTER PE
	0x044F: [ 0xD1 ], // CYRILLIC SMALL LETTER YA
	0x0440: [ 0xD2 ], // CYRILLIC SMALL LETTER ER
	0x0441: [ 0xD3 ], // CYRILLIC SMALL LETTER ES
	0x0442: [ 0xD4 ], // CYRILLIC SMALL LETTER TE
	0x0443: [ 0xD5 ], // CYRILLIC SMALL LETTER U
	0x0436: [ 0xD6 ], // CYRILLIC SMALL LETTER ZHE
	0x0432: [ 0xD7 ], // CYRILLIC SMALL LETTER VE
	0x044C: [ 0xD8 ], // CYRILLIC SMALL LETTER SOFT SIGN
	0x044B: [ 0xD9 ], // CYRILLIC SMALL LETTER YERU
	0x0437: [ 0xDA ], // CYRILLIC SMALL LETTER ZE
	0x0448: [ 0xDB ], // CYRILLIC SMALL LETTER SHA
	0x044D: [ 0xDC ], // CYRILLIC SMALL LETTER E
	0x0449: [ 0xDD ], // CYRILLIC SMALL LETTER SHCHA
	0x0447: [ 0xDE ], // CYRILLIC SMALL LETTER CHE
	0x044A: [ 0xDF ], // CYRILLIC SMALL LETTER HARD SIGN
	0x042E: [ 0xE0 ], // CYRILLIC CAPITAL LETTER YU
	0x0410: [ 0xE1 ], // CYRILLIC CAPITAL LETTER A
	0x0411: [ 0xE2 ], // CYRILLIC CAPITAL LETTER BE
	0x0426: [ 0xE3 ], // CYRILLIC CAPITAL LETTER TSE
	0x0414: [ 0xE4 ], // CYRILLIC CAPITAL LETTER DE
	0x0415: [ 0xE5 ], // CYRILLIC CAPITAL LETTER IE
	0x0424: [ 0xE6 ], // CYRILLIC CAPITAL LETTER EF
	0x0413: [ 0xE7 ], // CYRILLIC CAPITAL LETTER GHE
	0x0425: [ 0xE8 ], // CYRILLIC CAPITAL LETTER HA
	0x0418: [ 0xE9 ], // CYRILLIC CAPITAL LETTER I
	0x0419: [ 0xEA ], // CYRILLIC CAPITAL LETTER SHORT I
	0x041A: [ 0xEB ], // CYRILLIC CAPITAL LETTER KA
	0x041B: [ 0xEC ], // CYRILLIC CAPITAL LETTER EL
	0x041C: [ 0xED ], // CYRILLIC CAPITAL LETTER EM
	0x041D: [ 0xEE ], // CYRILLIC CAPITAL LETTER EN
	0x041E: [ 0xEF ], // CYRILLIC CAPITAL LETTER O
	0x041F: [ 0xF0 ], // CYRILLIC CAPITAL LETTER PE
	0x042F: [ 0xF1 ], // CYRILLIC CAPITAL LETTER YA
	0x0420: [ 0xF2 ], // CYRILLIC CAPITAL LETTER ER
	0x0421: [ 0xF3 ], // CYRILLIC CAPITAL LETTER ES
	0x0422: [ 0xF4 ], // CYRILLIC CAPITAL LETTER TE
	0x0423: [ 0xF5 ], // CYRILLIC CAPITAL LETTER U
	0x0416: [ 0xF6 ], // CYRILLIC CAPITAL LETTER ZHE
	0x0412: [ 0xF7 ], // CYRILLIC CAPITAL LETTER VE
	0x042C: [ 0xF8 ], // CYRILLIC CAPITAL LETTER SOFT SIGN
	0x042B: [ 0xF9 ], // CYRILLIC CAPITAL LETTER YERU
	0x0417: [ 0xFA ], // CYRILLIC CAPITAL LETTER ZE
	0x0428: [ 0xFB ], // CYRILLIC CAPITAL LETTER SHA
	0x042D: [ 0xFC ], // CYRILLIC CAPITAL LETTER E
	0x0429: [ 0xFD ], // CYRILLIC CAPITAL LETTER SHCHA
	0x0427: [ 0xFE ], // CYRILLIC CAPITAL LETTER CHE
};

// Convert string to match MSX system font
module.exports.convertToMSX = function (str)
{
	return locUtil.mapCharacter(str, MapCYRtoMSX);
}