const locUtil = require("./localize_util.js"); 

//-----------------------------------------------------------------------------
// Name:   Map from MSX Korean (video) character set to Unicode
// Date:   2019 September 27
// Author: Rebecca Bettencourt <support@kreativekorp.com>
const MapKORtoMSX = {
	0x0000: [ 0x00 ], // NULL
	0x3000: [ 0x01 ], // IDEOGRAPHIC SPACE
	0xD3EC: [ 0x02 ],
	0xD45C: [ 0x03 ],
	0xD478: [ 0x04 ],
	0xD4E8: [ 0x05 ],
	0xD504: [ 0x06 ],
	0xD638: [ 0x07 ],
	0xD6A8: [ 0x08 ],
	0xD6C4: [ 0x09 ],
	0xD734: [ 0x0A ],
	0xD750: [ 0x0B ],
	0x2018: [ 0x0C ], // LEFT SINGLE QUOTATION MARK
	0x2019: [ 0x0D ], // RIGHT SINGLE QUOTATION MARK
	0x201C: [ 0x0E ], // LEFT DOUBLE QUOTATION MARK
	0x201D: [ 0x0F ], // RIGHT DOUBLE QUOTATION MARK
	0x03C0: [ 0x10 ], // GREEK SMALL LETTER PI
	0x2534: [ 0x11 ], // BOX DRAWINGS LIGHT UP AND HORIZONTAL
	0x252C: [ 0x12 ], // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
	0x2524: [ 0x13 ], // BOX DRAWINGS LIGHT VERTICAL AND LEFT
	0x251C: [ 0x14 ], // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
	0x253C: [ 0x15 ], // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
	0x2502: [ 0x16 ], // BOX DRAWINGS LIGHT VERTICAL
	0x2500: [ 0x17 ], // BOX DRAWINGS LIGHT HORIZONTAL
	0x250C: [ 0x18 ], // BOX DRAWINGS LIGHT DOWN AND RIGHT
	0x2510: [ 0x19 ], // BOX DRAWINGS LIGHT DOWN AND LEFT
	0x2514: [ 0x1A ], // BOX DRAWINGS LIGHT UP AND RIGHT
	0x2518: [ 0x1B ], // BOX DRAWINGS LIGHT UP AND LEFT
	0x2573: [ 0x1C ], // BOX DRAWINGS LIGHT DIAGONAL CROSS
	0x0020: [ 0x20 ], // SPACE
	0x0021: [ 0x21 ], // EXCLAMATION MARK
	0x0022: [ 0x22 ], // QUOTATION MARK
	0x0023: [ 0x23 ], // NUMBER SIGN
	0x0024: [ 0x24 ], // DOLLAR SIGN
	0x0025: [ 0x25 ], // PERCENT SIGN
	0x0026: [ 0x26 ], // AMPERSAND
	0x0027: [ 0x27 ], // APOSTROPHE
	0x0028: [ 0x28 ], // LEFT PARENTHESIS
	0x0029: [ 0x29 ], // RIGHT PARENTHESIS
	0x002A: [ 0x2A ], // ASTERISK
	0x002B: [ 0x2B ], // PLUS SIGN
	0x002C: [ 0x2C ], // COMMA
	0x002D: [ 0x2D ], // HYPHEN-MINUS
	0x002E: [ 0x2E ], // FULL STOP
	0x002F: [ 0x2F ], // SOLIDUS
	0x0030: [ 0x30 ], // DIGIT ZERO
	0x0031: [ 0x31 ], // DIGIT ONE
	0x0032: [ 0x32 ], // DIGIT TWO
	0x0033: [ 0x33 ], // DIGIT THREE
	0x0034: [ 0x34 ], // DIGIT FOUR
	0x0035: [ 0x35 ], // DIGIT FIVE
	0x0036: [ 0x36 ], // DIGIT SIX
	0x0037: [ 0x37 ], // DIGIT SEVEN
	0x0038: [ 0x38 ], // DIGIT EIGHT
	0x0039: [ 0x39 ], // DIGIT NINE
	0x003A: [ 0x3A ], // COLON
	0x003B: [ 0x3B ], // SEMICOLON
	0x003C: [ 0x3C ], // LESS-THAN SIGN
	0x003D: [ 0x3D ], // EQUALS SIGN
	0x003E: [ 0x3E ], // GREATER-THAN SIGN
	0x003F: [ 0x3F ], // QUESTION MARK
	0x0040: [ 0x40 ], // COMMERCIAL AT
	0x0041: [ 0x41 ], // LATIN CAPITAL LETTER A
	0x0042: [ 0x42 ], // LATIN CAPITAL LETTER B
	0x0043: [ 0x43 ], // LATIN CAPITAL LETTER C
	0x0044: [ 0x44 ], // LATIN CAPITAL LETTER D
	0x0045: [ 0x45 ], // LATIN CAPITAL LETTER E
	0x0046: [ 0x46 ], // LATIN CAPITAL LETTER F
	0x0047: [ 0x47 ], // LATIN CAPITAL LETTER G
	0x0048: [ 0x48 ], // LATIN CAPITAL LETTER H
	0x0049: [ 0x49 ], // LATIN CAPITAL LETTER I
	0x004A: [ 0x4A ], // LATIN CAPITAL LETTER J
	0x004B: [ 0x4B ], // LATIN CAPITAL LETTER K
	0x004C: [ 0x4C ], // LATIN CAPITAL LETTER L
	0x004D: [ 0x4D ], // LATIN CAPITAL LETTER M
	0x004E: [ 0x4E ], // LATIN CAPITAL LETTER N
	0x004F: [ 0x4F ], // LATIN CAPITAL LETTER O
	0x0050: [ 0x50 ], // LATIN CAPITAL LETTER P
	0x0051: [ 0x51 ], // LATIN CAPITAL LETTER Q
	0x0052: [ 0x52 ], // LATIN CAPITAL LETTER R
	0x0053: [ 0x53 ], // LATIN CAPITAL LETTER S
	0x0054: [ 0x54 ], // LATIN CAPITAL LETTER T
	0x0055: [ 0x55 ], // LATIN CAPITAL LETTER U
	0x0056: [ 0x56 ], // LATIN CAPITAL LETTER V
	0x0057: [ 0x57 ], // LATIN CAPITAL LETTER W
	0x0058: [ 0x58 ], // LATIN CAPITAL LETTER X
	0x0059: [ 0x59 ], // LATIN CAPITAL LETTER Y
	0x005A: [ 0x5A ], // LATIN CAPITAL LETTER Z
	0x005B: [ 0x5B ], // LEFT SQUARE BRACKET
	0x20A9: [ 0x5C ], // WON SIGN
	0x005D: [ 0x5D ], // RIGHT SQUARE BRACKET
	0x005E: [ 0x5E ], // CIRCUMFLEX ACCENT
	0x005F: [ 0x5F ], // LOW LINE
	0x0060: [ 0x60 ], // GRAVE ACCENT
	0x0061: [ 0x61 ], // LATIN SMALL LETTER A
	0x0062: [ 0x62 ], // LATIN SMALL LETTER B
	0x0063: [ 0x63 ], // LATIN SMALL LETTER C
	0x0064: [ 0x64 ], // LATIN SMALL LETTER D
	0x0065: [ 0x65 ], // LATIN SMALL LETTER E
	0x0066: [ 0x66 ], // LATIN SMALL LETTER F
	0x0067: [ 0x67 ], // LATIN SMALL LETTER G
	0x0068: [ 0x68 ], // LATIN SMALL LETTER H
	0x0069: [ 0x69 ], // LATIN SMALL LETTER I
	0x006A: [ 0x6A ], // LATIN SMALL LETTER J
	0x006B: [ 0x6B ], // LATIN SMALL LETTER K
	0x006C: [ 0x6C ], // LATIN SMALL LETTER L
	0x006D: [ 0x6D ], // LATIN SMALL LETTER M
	0x006E: [ 0x6E ], // LATIN SMALL LETTER N
	0x006F: [ 0x6F ], // LATIN SMALL LETTER O
	0x0070: [ 0x70 ], // LATIN SMALL LETTER P
	0x0071: [ 0x71 ], // LATIN SMALL LETTER Q
	0x0072: [ 0x72 ], // LATIN SMALL LETTER R
	0x0073: [ 0x73 ], // LATIN SMALL LETTER S
	0x0074: [ 0x74 ], // LATIN SMALL LETTER T
	0x0075: [ 0x75 ], // LATIN SMALL LETTER U
	0x0076: [ 0x76 ], // LATIN SMALL LETTER V
	0x0077: [ 0x77 ], // LATIN SMALL LETTER W
	0x0078: [ 0x78 ], // LATIN SMALL LETTER X
	0x0079: [ 0x79 ], // LATIN SMALL LETTER Y
	0x007A: [ 0x7A ], // LATIN SMALL LETTER Z
	0x007B: [ 0x7B ], // LEFT CURLY BRACKET
	0x007C: [ 0x7C ], // VERTICAL LINE
	0x007D: [ 0x7D ], // RIGHT CURLY BRACKET
	0x007E: [ 0x7E ], // TILDE
	0x2660: [ 0x80 ], // BLACK SPADE SUIT
	0x2665: [ 0x81 ], // BLACK HEART SUIT
	0x2663: [ 0x82 ], // BLACK CLUB SUIT
	0x2666: [ 0x83 ], // BLACK DIAMOND SUIT
	0x25CB: [ 0x84 ], // WHITE CIRCLE
	0x25CF: [ 0x85 ], // BLACK CIRCLE
	0x3131: [ 0x86 ], // HANGUL LETTER KIYEOK
	0x3132: [ 0x87 ], // HANGUL LETTER SSANGKIYEOK
	0x3134: [ 0x88 ], // HANGUL LETTER NIEUN
	0x3137: [ 0x89 ], // HANGUL LETTER TIKEUT
	0x3138: [ 0x8A ], // HANGUL LETTER SSANGTIKEUT
	0x3139: [ 0x8B ], // HANGUL LETTER RIEUL
	0x3141: [ 0x8C ], // HANGUL LETTER MIEUM
	0x3142: [ 0x8D ], // HANGUL LETTER PIEUP
	0x3143: [ 0x8E ], // HANGUL LETTER SSANGPIEUP
	0x3145: [ 0x8F ], // HANGUL LETTER SIOS
	0x3146: [ 0x90 ], // HANGUL LETTER SSANGSIOS
	0x3147: [ 0x91 ], // HANGUL LETTER IEUNG
	0x3148: [ 0x92 ], // HANGUL LETTER CIEUC
	0x3149: [ 0x93 ], // HANGUL LETTER SSANGCIEUC
	0x314A: [ 0x94 ], // HANGUL LETTER CHIEUCH
	0x314B: [ 0x95 ], // HANGUL LETTER KHIEUKH
	0x314C: [ 0x96 ], // HANGUL LETTER THIEUTH
	0x314D: [ 0x97 ], // HANGUL LETTER PHIEUPH
	0x314E: [ 0x98 ], // HANGUL LETTER HIEUH
	0x314F: [ 0x99 ], // HANGUL LETTER A
	0x3150: [ 0x9A ], // HANGUL LETTER AE
	0x3151: [ 0x9B ], // HANGUL LETTER YA
	0x3152: [ 0x9C ], // HANGUL LETTER YAE
	0x3153: [ 0x9D ], // HANGUL LETTER EO
	0x3154: [ 0x9E ], // HANGUL LETTER E
	0x3155: [ 0x9F ], // HANGUL LETTER YEO
	0x3156: [ 0xA0 ], // HANGUL LETTER YE
	0x3157: [ 0xA1 ], // HANGUL LETTER O
	0x315B: [ 0xA2 ], // HANGUL LETTER YO
	0x315C: [ 0xA3 ], // HANGUL LETTER U
	0x3160: [ 0xA4 ], // HANGUL LETTER YU
	0x3161: [ 0xA5 ], // HANGUL LETTER EU
	0x3163: [ 0xA6 ], // HANGUL LETTER I
	0xACE0: [ 0xA7 ],
	0xAD50: [ 0xA8 ],
	0xAD6C: [ 0xA9 ],
	0xADDC: [ 0xAA ],
	0xADF8: [ 0xAB ],
	0xAF2C: [ 0xAC ],
	0xAF9C: [ 0xAD ],
	0xAFB8: [ 0xAE ],
	0xB028: [ 0xAF ],
	0xB044: [ 0xB0 ],
	0xB178: [ 0xB1 ],
	0xB1E8: [ 0xB2 ],
	0xB204: [ 0xB3 ],
	0xB274: [ 0xB4 ],
	0xB290: [ 0xB5 ],
	0xB3C4: [ 0xB6 ],
	0xB434: [ 0xB7 ],
	0xB450: [ 0xB8 ],
	0xB4C0: [ 0xB9 ],
	0xB4DC: [ 0xBA ],
	0xB610: [ 0xBB ],
	0xB680: [ 0xBC ],
	0xB69C: [ 0xBD ],
	0xB70C: [ 0xBE ],
	0xB728: [ 0xBF ],
	0xB85C: [ 0xC0 ],
	0xB8CC: [ 0xC1 ],
	0xB8E8: [ 0xC2 ],
	0xB958: [ 0xC3 ],
	0xB974: [ 0xC4 ],
	0xBAA8: [ 0xC5 ],
	0xBB18: [ 0xC6 ],
	0xBB34: [ 0xC7 ],
	0xBBA4: [ 0xC8 ],
	0xBBC0: [ 0xC9 ],
	0xBCF4: [ 0xCA ],
	0xBD64: [ 0xCB ],
	0xBD80: [ 0xCC ],
	0xBDF0: [ 0xCD ],
	0xBE0C: [ 0xCE ],
	0xBF40: [ 0xCF ],
	0xBFB0: [ 0xD0 ],
	0xBFCC: [ 0xD1 ],
	0xC03C: [ 0xD2 ],
	0xC058: [ 0xD3 ],
	0xC18C: [ 0xD4 ],
	0xC1FC: [ 0xD5 ],
	0xC218: [ 0xD6 ],
	0xC288: [ 0xD7 ],
	0xC2A4: [ 0xD8 ],
	0xC3D8: [ 0xD9 ],
	0xC448: [ 0xDA ],
	0xC464: [ 0xDB ],
	0xC4D4: [ 0xDC ],
	0xC4F0: [ 0xDD ],
	0xC624: [ 0xDE ],
	0xC694: [ 0xDF ],
	0xC6B0: [ 0xE0 ],
	0xC720: [ 0xE1 ],
	0xC73C: [ 0xE2 ],
	0xC870: [ 0xE3 ],
	0xC8E0: [ 0xE4 ],
	0xC8FC: [ 0xE5 ],
	0xC96C: [ 0xE6 ],
	0xC988: [ 0xE7 ],
	0xCABC: [ 0xE8 ],
	0xCB2C: [ 0xE9 ],
	0xCB48: [ 0xEA ],
	0xCBB8: [ 0xEB ],
	0xCBD4: [ 0xEC ],
	0xCD08: [ 0xED ],
	0xCD78: [ 0xEE ],
	0xCD94: [ 0xEF ],
	0xCE04: [ 0xF0 ],
	0xCE20: [ 0xF1 ],
	0xCF54: [ 0xF2 ],
	0xCFC4: [ 0xF3 ],
	0xCFE0: [ 0xF4 ],
	0xD050: [ 0xF5 ],
	0xD06C: [ 0xF6 ],
	0xD1A0: [ 0xF7 ],
	0xD210: [ 0xF8 ],
	0xD22C: [ 0xF9 ],
	0xD29C: [ 0xFA ],
	0xD2B8: [ 0xFB ],
};

// Convert string to match MSX system font
module.exports.convertToMSX = function (str)
{
	return locUtil.mapCharacter(str, MapKORtoMSX);
}