const locUtil = require("./localize_util.js"); 

//-----------------------------------------------------------------------------
// Name:   Map from MSX international (video) character set to Unicode
// Date:   2019 September 25
// Author: Rebecca Bettencourt <support@kreativekorp.com>
const MapINTtoMSX = {
	0x0000: [ 0x00 ],	// NULL
	0x263A: [ 0x01 ],	// WHITE SMILING FACE
	0x263B: [ 0x02 ],	// BLACK SMILING FACE
	0x2665: [ 0x03 ],	// BLACK HEART SUIT
	0x2666: [ 0x04 ],	// BLACK DIAMOND SUIT
	0x2663: [ 0x05 ],	// BLACK CLUB SUIT
	0x2660: [ 0x06 ],	// BLACK SPADE SUIT
	0x2022: [ 0x07 ],	// BULLET
	0x25D8: [ 0x08 ],	// INVERSE BULLET
	0x25CB: [ 0x09 ],	// WHITE CIRCLE
	0x25D9: [ 0x0A ],	// INVERSE WHITE CIRCLE
	0x2642: [ 0x0B ],	// MALE SIGN
	0x2640: [ 0x0C ],	// FEMALE SIGN
	0x266A: [ 0x0D ],	// EIGHTH NOTE
	0x266B: [ 0x0E ],	// BEAMED EIGHTH NOTES
	0x263C: [ 0x0F ],	// WHITE SUN WITH RAYS
	0x27CA: [ 0x10 ],	// VERTICAL BAR WITH HORIZONTAL STROKE
	0x2534: [ 0x11 ],	// BOX DRAWINGS LIGHT UP AND HORIZONTAL
	0x252C: [ 0x12 ],	// BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
	0x2524: [ 0x13 ],	// BOX DRAWINGS LIGHT VERTICAL AND LEFT
	0x251C: [ 0x14 ],	// BOX DRAWINGS LIGHT VERTICAL AND RIGHT
	0x253C: [ 0x15 ],	// BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
	0x2502: [ 0x16 ],	// BOX DRAWINGS LIGHT VERTICAL
	0x2500: [ 0x17 ],	// BOX DRAWINGS LIGHT HORIZONTAL
	0x250C: [ 0x18 ],	// BOX DRAWINGS LIGHT DOWN AND RIGHT
	0x2510: [ 0x19 ],	// BOX DRAWINGS LIGHT DOWN AND LEFT
	0x2514: [ 0x1A ],	// BOX DRAWINGS LIGHT UP AND RIGHT
	0x2518: [ 0x1B ],	// BOX DRAWINGS LIGHT UP AND LEFT
	0x2573: [ 0x1C ],	// BOX DRAWINGS LIGHT DIAGONAL CROSS
	0x2571: [ 0x1D ],	// BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
	0x2572: [ 0x1E ],	// BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
	0x1FBAF: [ 0x1F ],	// BOX DRAWINGS LIGHT HORIZONTAL WITH VERTICAL STROKE
	0x0020: [ 0x20 ],	// SPACE
	0x0021: [ 0x21 ],	// EXCLAMATION MARK
	0x0022: [ 0x22 ],	// QUOTATION MARK
	0x0023: [ 0x23 ],	// NUMBER SIGN
	0x0024: [ 0x24 ],	// DOLLAR SIGN
	0x0025: [ 0x25 ],	// PERCENT SIGN
	0x0026: [ 0x26 ],	// AMPERSAND
	0x0027: [ 0x27 ],	// APOSTROPHE
	0x0028: [ 0x28 ],	// LEFT PARENTHESIS
	0x0029: [ 0x29 ],	// RIGHT PARENTHESIS
	0x002A: [ 0x2A ],	// ASTERISK
	0x002B: [ 0x2B ],	// PLUS SIGN
	0x002C: [ 0x2C ],	// COMMA
	0x002D: [ 0x2D ],	// HYPHEN-MINUS
	0x002E: [ 0x2E ],	// FULL STOP
	0x002F: [ 0x2F ],	// SOLIDUS
	0x0030: [ 0x30 ],	// DIGIT ZERO
	0x0031: [ 0x31 ],	// DIGIT ONE
	0x0032: [ 0x32 ],	// DIGIT TWO
	0x0033: [ 0x33 ],	// DIGIT THREE
	0x0034: [ 0x34 ],	// DIGIT FOUR
	0x0035: [ 0x35 ],	// DIGIT FIVE
	0x0036: [ 0x36 ],	// DIGIT SIX
	0x0037: [ 0x37 ],	// DIGIT SEVEN
	0x0038: [ 0x38 ],	// DIGIT EIGHT
	0x0039: [ 0x39 ],	// DIGIT NINE
	0x003A: [ 0x3A ],	// COLON
	0x003B: [ 0x3B ],	// SEMICOLON
	0x003C: [ 0x3C ],	// LESS-THAN SIGN
	0x003D: [ 0x3D ],	// EQUALS SIGN
	0x003E: [ 0x3E ],	// GREATER-THAN SIGN
	0x003F: [ 0x3F ],	// QUESTION MARK
	0x0040: [ 0x40 ],	// COMMERCIAL AT
	0x0041: [ 0x41 ],	// LATIN CAPITAL LETTER A
	0x0042: [ 0x42 ],	// LATIN CAPITAL LETTER B
	0x0043: [ 0x43 ],	// LATIN CAPITAL LETTER C
	0x0044: [ 0x44 ],	// LATIN CAPITAL LETTER D
	0x0045: [ 0x45 ],	// LATIN CAPITAL LETTER E
	0x0046: [ 0x46 ],	// LATIN CAPITAL LETTER F
	0x0047: [ 0x47 ],	// LATIN CAPITAL LETTER G
	0x0048: [ 0x48 ],	// LATIN CAPITAL LETTER H
	0x0049: [ 0x49 ],	// LATIN CAPITAL LETTER I
	0x004A: [ 0x4A ],	// LATIN CAPITAL LETTER J
	0x004B: [ 0x4B ],	// LATIN CAPITAL LETTER K
	0x004C: [ 0x4C ],	// LATIN CAPITAL LETTER L
	0x004D: [ 0x4D ],	// LATIN CAPITAL LETTER M
	0x004E: [ 0x4E ],	// LATIN CAPITAL LETTER N
	0x004F: [ 0x4F ],	// LATIN CAPITAL LETTER O
	0x0050: [ 0x50 ],	// LATIN CAPITAL LETTER P
	0x0051: [ 0x51 ],	// LATIN CAPITAL LETTER Q
	0x0052: [ 0x52 ],	// LATIN CAPITAL LETTER R
	0x0053: [ 0x53 ],	// LATIN CAPITAL LETTER S
	0x0054: [ 0x54 ],	// LATIN CAPITAL LETTER T
	0x0055: [ 0x55 ],	// LATIN CAPITAL LETTER U
	0x0056: [ 0x56 ],	// LATIN CAPITAL LETTER V
	0x0057: [ 0x57 ],	// LATIN CAPITAL LETTER W
	0x0058: [ 0x58 ],	// LATIN CAPITAL LETTER X
	0x0059: [ 0x59 ],	// LATIN CAPITAL LETTER Y
	0x005A: [ 0x5A ],	// LATIN CAPITAL LETTER Z
	0x005B: [ 0x5B ],	// LEFT SQUARE BRACKET
	0x005C: [ 0x5C ],	// REVERSE SOLIDUS
	0x005D: [ 0x5D ],	// RIGHT SQUARE BRACKET
	0x005E: [ 0x5E ],	// CIRCUMFLEX ACCENT
	0x005F: [ 0x5F ],	// LOW LINE
	0x0060: [ 0x60 ],	// GRAVE ACCENT
	0x0061: [ 0x61 ],	// LATIN SMALL LETTER A
	0x0062: [ 0x62 ],	// LATIN SMALL LETTER B
	0x0063: [ 0x63 ],	// LATIN SMALL LETTER C
	0x0064: [ 0x64 ],	// LATIN SMALL LETTER D
	0x0065: [ 0x65 ],	// LATIN SMALL LETTER E
	0x0066: [ 0x66 ],	// LATIN SMALL LETTER F
	0x0067: [ 0x67 ],	// LATIN SMALL LETTER G
	0x0068: [ 0x68 ],	// LATIN SMALL LETTER H
	0x0069: [ 0x69 ],	// LATIN SMALL LETTER I
	0x006A: [ 0x6A ],	// LATIN SMALL LETTER J
	0x006B: [ 0x6B ],	// LATIN SMALL LETTER K
	0x006C: [ 0x6C ],	// LATIN SMALL LETTER L
	0x006D: [ 0x6D ],	// LATIN SMALL LETTER M
	0x006E: [ 0x6E ],	// LATIN SMALL LETTER N
	0x006F: [ 0x6F ],	// LATIN SMALL LETTER O
	0x0070: [ 0x70 ],	// LATIN SMALL LETTER P
	0x0071: [ 0x71 ],	// LATIN SMALL LETTER Q
	0x0072: [ 0x72 ],	// LATIN SMALL LETTER R
	0x0073: [ 0x73 ],	// LATIN SMALL LETTER S
	0x0074: [ 0x74 ],	// LATIN SMALL LETTER T
	0x0075: [ 0x75 ],	// LATIN SMALL LETTER U
	0x0076: [ 0x76 ],	// LATIN SMALL LETTER V
	0x0077: [ 0x77 ],	// LATIN SMALL LETTER W
	0x0078: [ 0x78 ],	// LATIN SMALL LETTER X
	0x0079: [ 0x79 ],	// LATIN SMALL LETTER Y
	0x007A: [ 0x7A ],	// LATIN SMALL LETTER Z
	0x007B: [ 0x7B ],	// LEFT CURLY BRACKET
	0x007C: [ 0x7C ],	// VERTICAL LINE
	0x007D: [ 0x7D ],	// RIGHT CURLY BRACKET
	0x007E: [ 0x7E ],	// TILDE
	0x2302: [ 0x7F ],	// HOUSE
	0x00C7: [ 0x80 ],	// LATIN CAPITAL LETTER C WITH CEDILLA
	0x00FC: [ 0x81 ],	// LATIN SMALL LETTER U WITH DIAERESIS
	0x00E9: [ 0x82 ],	// LATIN SMALL LETTER E WITH ACUTE
	0x00E2: [ 0x83 ],	// LATIN SMALL LETTER A WITH CIRCUMFLEX
	0x00E4: [ 0x84 ],	// LATIN SMALL LETTER A WITH DIAERESIS
	0x00E0: [ 0x85 ],	// LATIN SMALL LETTER A WITH GRAVE
	0x00E5: [ 0x86 ],	// LATIN SMALL LETTER A WITH RING ABOVE
	0x00E7: [ 0x87 ],	// LATIN SMALL LETTER C WITH CEDILLA
	0x00EA: [ 0x88 ],	// LATIN SMALL LETTER E WITH CIRCUMFLEX
	0x00EB: [ 0x89 ],	// LATIN SMALL LETTER E WITH DIAERESIS
	0x00E8: [ 0x8A ],	// LATIN SMALL LETTER E WITH GRAVE
	0x00EF: [ 0x8B ],	// LATIN SMALL LETTER I WITH DIAERESIS
	0x00EE: [ 0x8C ],	// LATIN SMALL LETTER I WITH CIRCUMFLEX
	0x00EC: [ 0x8D ],	// LATIN SMALL LETTER I WITH GRAVE
	0x00C4: [ 0x8E ],	// LATIN CAPITAL LETTER A WITH DIAERESIS
	0x00C5: [ 0x8F ],	// LATIN CAPITAL LETTER A WITH RING ABOVE
	0x00C9: [ 0x90 ],	// LATIN CAPITAL LETTER E WITH ACUTE
	0x00E6: [ 0x91 ],	// LATIN SMALL LETTER AE
	0x00C6: [ 0x92 ],	// LATIN CAPITAL LETTER AE
	0x00F4: [ 0x93 ],	// LATIN SMALL LETTER O WITH CIRCUMFLEX
	0x00F6: [ 0x94 ],	// LATIN SMALL LETTER O WITH DIAERESIS
	0x00F2: [ 0x95 ],	// LATIN SMALL LETTER O WITH GRAVE
	0x00FB: [ 0x96 ],	// LATIN SMALL LETTER U WITH CIRCUMFLEX
	0x00F9: [ 0x97 ],	// LATIN SMALL LETTER U WITH GRAVE
	0x00FF: [ 0x98 ],	// LATIN SMALL LETTER Y WITH DIAERESIS
	0x00D6: [ 0x99 ],	// LATIN CAPITAL LETTER O WITH DIAERESIS
	0x00DC: [ 0x9A ],	// LATIN CAPITAL LETTER U WITH DIAERESIS
	0x00A2: [ 0x9B ],	// CENT SIGN
	0x00A3: [ 0x9C ],	// POUND SIGN
	0x00A5: [ 0x9D ],	// YEN SIGN
	0x20A7: [ 0x9E ],	// PESETA SIGN
	0x0192: [ 0x9F ],	// LATIN SMALL LETTER F WITH HOOK
	0x00E1: [ 0xA0 ],	// LATIN SMALL LETTER A WITH ACUTE
	0x00ED: [ 0xA1 ],	// LATIN SMALL LETTER I WITH ACUTE
	0x00F3: [ 0xA2 ],	// LATIN SMALL LETTER O WITH ACUTE
	0x00FA: [ 0xA3 ],	// LATIN SMALL LETTER U WITH ACUTE
	0x00F1: [ 0xA4 ],	// LATIN SMALL LETTER N WITH TILDE
	0x00D1: [ 0xA5 ],	// LATIN CAPITAL LETTER N WITH TILDE
	0x00AA: [ 0xA6 ],	// FEMININE ORDINAL INDICATOR
	0x00BA: [ 0xA7 ],	// MASCULINE ORDINAL INDICATOR
	0x00BF: [ 0xA8 ],	// INVERTED QUESTION MARK
	0x2310: [ 0xA9 ],	// REVERSED NOT SIGN
	0x00AC: [ 0xAA ],	// NOT SIGN
	0x00BD: [ 0xAB ],	// VULGAR FRACTION ONE HALF
	0x00BC: [ 0xAC ],	// VULGAR FRACTION ONE QUARTER
	0x00A1: [ 0xAD ],	// INVERTED EXCLAMATION MARK
	0x00AB: [ 0xAE ],	// LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	0x00BB: [ 0xAF ],	// RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	0x00C3: [ 0xB0 ],	// LATIN CAPITAL LETTER A WITH TILDE
	0x00E3: [ 0xB1 ],	// LATIN SMALL LETTER A WITH TILDE
	0x0128: [ 0xB2 ],	// LATIN CAPITAL LETTER I WITH TILDE
	0x0129: [ 0xB3 ],	// LATIN SMALL LETTER I WITH TILDE
	0x00D5: [ 0xB4 ],	// LATIN CAPITAL LETTER O WITH TILDE
	0x00F5: [ 0xB5 ],	// LATIN SMALL LETTER O WITH TILDE
	0x0168: [ 0xB6 ],	// LATIN CAPITAL LETTER U WITH TILDE
	0x0169: [ 0xB7 ],	// LATIN SMALL LETTER U WITH TILDE
	0x0132: [ 0xB8 ],	// LATIN CAPITAL LIGATURE IJ
	0x0133: [ 0xB9 ],	// LATIN SMALL LIGATURE IJ
	0x00BE: [ 0xBA ],	// VULGAR FRACTION THREE QUARTERS
	0x223D: [ 0xBB ],	// REVERSED TILDE
	0x25C7: [ 0xBC ],	// WHITE DIAMOND
	0x2030: [ 0xBD ],	// PER MILLE SIGN
	0x00B6: [ 0xBE ],	// PILCROW SIGN
	0x00A7: [ 0xBF ],	// SECTION SIGN
	0x2582: [ 0xC0 ],	// LOWER ONE QUARTER BLOCK
	0x259A: [ 0xC1 ],	// QUADRANT UPPER LEFT AND LOWER RIGHT
	0x2586: [ 0xC2 ],	// LOWER THREE QUARTERS BLOCK
	0x1FB82: [ 0xC3 ],	// UPPER ONE QUARTER BLOCK
	0x25AC: [ 0xC4 ],	// BLACK RECTANGLE
	0x1FB85: [ 0xC5 ],	// UPPER THREE QUARTERS BLOCK
	0x258E: [ 0xC6 ],	// LEFT ONE QUARTER BLOCK
	0x259E: [ 0xC7 ],	// QUADRANT UPPER RIGHT AND LOWER LEFT
	0x258A: [ 0xC8 ],	// LEFT THREE QUARTERS BLOCK
	0x1FB87: [ 0xC9 ],	// RIGHT ONE QUARTER BLOCK
	0x1FB8A: [ 0xCA ],	// RIGHT THREE QUARTERS BLOCK
	0x1FB99: [ 0xCB ],	// UPPER RIGHT TO LOWER LEFT FILL
	0x1FB98: [ 0xCC ],	// UPPER LEFT TO LOWER RIGHT FILL
	0x1FB6D: [ 0xCD ],	// UPPER TRIANGULAR ONE QUARTER BLOCK
	0x1FB6F: [ 0xCE ],	// LOWER TRIANGULAR ONE QUARTER BLOCK
	0x1FB6C: [ 0xCF ],	// LEFT TRIANGULAR ONE QUARTER BLOCK
	0x1FB6E: [ 0xD0 ],	// RIGHT TRIANGULAR ONE QUARTER BLOCK
	0x1FB9A: [ 0xD1 ],	// UPPER AND LOWER TRIANGULAR HALF BLOCK
	0x1FB9B: [ 0xD2 ],	// LEFT AND RIGHT TRIANGULAR HALF BLOCK
	0x2598: [ 0xD3 ],	// QUADRANT UPPER LEFT
	0x2597: [ 0xD4 ],	// QUADRANT LOWER RIGHT
	0x259D: [ 0xD5 ],	// QUADRANT UPPER RIGHT
	0x2596: [ 0xD6 ],	// QUADRANT LOWER LEFT
	0x1FB96: [ 0xD7 ],	// INVERSE CHECKER BOARD FILL
	0x0394: [ 0xD8 ],	// GREEK CAPITAL LETTER DELTA
	0x2021: [ 0xD9 ],	// DOUBLE DAGGER
	0x03C9: [ 0xDA ],	// GREEK SMALL LETTER OMEGA
	0x2588: [ 0xDB ],	// FULL BLOCK
	0x2584: [ 0xDC ],	// LOWER HALF BLOCK
	0x258C: [ 0xDD ],	// LEFT HALF BLOCK
	0x2590: [ 0xDE ],	// RIGHT HALF BLOCK
	0x2580: [ 0xDF ],	// UPPER HALF BLOCK
	0x03B1: [ 0xE0 ],	// GREEK SMALL LETTER ALPHA
	0x00DF: [ 0xE1 ],	// LATIN SMALL LETTER SHARP S
	0x0393: [ 0xE2 ],	// GREEK CAPITAL LETTER GAMMA
	0x03C0: [ 0xE3 ],	// GREEK SMALL LETTER PI
	0x03A3: [ 0xE4 ],	// GREEK CAPITAL LETTER SIGMA
	0x03C3: [ 0xE5 ],	// GREEK SMALL LETTER SIGMA
	0x00B5: [ 0xE6 ],	// MICRO SIGN
	0x03C4: [ 0xE7 ],	// GREEK SMALL LETTER TAU
	0x03A6: [ 0xE8 ],	// GREEK CAPITAL LETTER PHI
	0x0398: [ 0xE9 ],	// GREEK CAPITAL LETTER THETA
	0x03A9: [ 0xEA ],	// GREEK CAPITAL LETTER OMEGA
	0x03B4: [ 0xEB ],	// GREEK SMALL LETTER DELTA
	0x221E: [ 0xEC ],	// INFINITY
	0x2205: [ 0xED ],	// EMPTY SET
	0x2208: [ 0xEE ],	// ELEMENT OF
	0x2229: [ 0xEF ],	// INTERSECTION
	0x2261: [ 0xF0 ],	// IDENTICAL TO
	0x00B1: [ 0xF1 ],	// PLUS-MINUS SIGN
	0x2265: [ 0xF2 ],	// GREATER-THAN OR EQUAL TO
	0x2264: [ 0xF3 ],	// LESS-THAN OR EQUAL TO
	0x2320: [ 0xF4 ],	// TOP HALF INTEGRAL
	0x2321: [ 0xF5 ],	// BOTTOM HALF INTEGRAL
	0x00F7: [ 0xF6 ],	// DIVISION SIGN
	0x2248: [ 0xF7 ],	// ALMOST EQUAL TO
	0x00B0: [ 0xF8 ],	// DEGREE SIGN
	0x2219: [ 0xF9 ],	// BULLET OPERATOR
	0x00B7: [ 0xFA ],	// MIDDLE DOT
	0x221A: [ 0xFB ],	// SQUARE ROOT
	0x207F: [ 0xFC ],	// SUPERSCRIPT LATIN SMALL LETTER N
	0x00B2: [ 0xFD ],	// SUPERSCRIPT TWO
	0x25A0: [ 0xFE ],	// BLACK SQUARE

	0x0152: [ 0x4F, 0x45 ],	// LATIN CAPITAL LETTER OE
	0x0153: [ 0x6F, 0x65 ],	// LATIN SMALL LETTER oe
};


//-----------------------------------------------------------------------------
// Name:   Map from MSX Brazilian (Gradiente Expert DDPlus, Sharp Hotbit 1.2) (video) character set to Unicode
// Date:   2019 September 28
// Author: Rebecca Bettencourt <support@kreativekorp.com>
const MapBRtoMSX = {
	0x0000: [ 0x00 ], // NULL
	0x263A: [ 0x01 ], // WHITE SMILING FACE
	0x263B: [ 0x02 ], // BLACK SMILING FACE
	0x2665: [ 0x03 ], // BLACK HEART SUIT
	0x2666: [ 0x04 ], // BLACK DIAMOND SUIT
	0x2663: [ 0x05 ], // BLACK CLUB SUIT
	0x2660: [ 0x06 ], // BLACK SPADE SUIT
	0x2022: [ 0x07 ], // BULLET
	0x25D8: [ 0x08 ], // INVERSE BULLET
	0x25CB: [ 0x09 ], // WHITE CIRCLE
	0x25D9: [ 0x0A ], // INVERSE WHITE CIRCLE
	0x2642: [ 0x0B ], // MALE SIGN
	0x2640: [ 0x0C ], // FEMALE SIGN
	0x266A: [ 0x0D ], // EIGHTH NOTE
	0x266B: [ 0x0E ], // BEAMED EIGHTH NOTES
	0x263C: [ 0x0F ], // WHITE SUN WITH RAYS
	0x27CA: [ 0x10 ], // VERTICAL BAR WITH HORIZONTAL STROKE
	0x2534: [ 0x11 ], // BOX DRAWINGS LIGHT UP AND HORIZONTAL
	0x252C: [ 0x12 ], // BOX DRAWINGS LIGHT DOWN AND HORIZONTAL
	0x2524: [ 0x13 ], // BOX DRAWINGS LIGHT VERTICAL AND LEFT
	0x251C: [ 0x14 ], // BOX DRAWINGS LIGHT VERTICAL AND RIGHT
	0x253C: [ 0x15 ], // BOX DRAWINGS LIGHT VERTICAL AND HORIZONTAL
	0x2502: [ 0x16 ], // BOX DRAWINGS LIGHT VERTICAL
	0x2500: [ 0x17 ], // BOX DRAWINGS LIGHT HORIZONTAL
	0x250C: [ 0x18 ], // BOX DRAWINGS LIGHT DOWN AND RIGHT
	0x2510: [ 0x19 ], // BOX DRAWINGS LIGHT DOWN AND LEFT
	0x2514: [ 0x1A ], // BOX DRAWINGS LIGHT UP AND RIGHT
	0x2518: [ 0x1B ], // BOX DRAWINGS LIGHT UP AND LEFT
	0x2573: [ 0x1C ], // BOX DRAWINGS LIGHT DIAGONAL CROSS
	0x2571: [ 0x1D ], // BOX DRAWINGS LIGHT DIAGONAL UPPER RIGHT TO LOWER LEFT
	0x2572: [ 0x1E ], // BOX DRAWINGS LIGHT DIAGONAL UPPER LEFT TO LOWER RIGHT
	0x1FBAF: [ 0x1F ], // BOX DRAWINGS LIGHT HORIZONTAL WITH VERTICAL STROKE
	0x0020: [ 0x20 ], // SPACE
	0x0021: [ 0x21 ], // EXCLAMATION MARK
	0x0022: [ 0x22 ], // QUOTATION MARK
	0x0023: [ 0x23 ], // NUMBER SIGN
	0x0024: [ 0x24 ], // DOLLAR SIGN
	0x0025: [ 0x25 ], // PERCENT SIGN
	0x0026: [ 0x26 ], // AMPERSAND
	0x0027: [ 0x27 ], // APOSTROPHE
	0x0028: [ 0x28 ], // LEFT PARENTHESIS
	0x0029: [ 0x29 ], // RIGHT PARENTHESIS
	0x002A: [ 0x2A ], // ASTERISK
	0x002B: [ 0x2B ], // PLUS SIGN
	0x002C: [ 0x2C ], // COMMA
	0x002D: [ 0x2D ], // HYPHEN-MINUS
	0x002E: [ 0x2E ], // FULL STOP
	0x002F: [ 0x2F ], // SOLIDUS
	0x0030: [ 0x30 ], // DIGIT ZERO
	0x0031: [ 0x31 ], // DIGIT ONE
	0x0032: [ 0x32 ], // DIGIT TWO
	0x0033: [ 0x33 ], // DIGIT THREE
	0x0034: [ 0x34 ], // DIGIT FOUR
	0x0035: [ 0x35 ], // DIGIT FIVE
	0x0036: [ 0x36 ], // DIGIT SIX
	0x0037: [ 0x37 ], // DIGIT SEVEN
	0x0038: [ 0x38 ], // DIGIT EIGHT
	0x0039: [ 0x39 ], // DIGIT NINE
	0x003A: [ 0x3A ], // COLON
	0x003B: [ 0x3B ], // SEMICOLON
	0x003C: [ 0x3C ], // LESS-THAN SIGN
	0x003D: [ 0x3D ], // EQUALS SIGN
	0x003E: [ 0x3E ], // GREATER-THAN SIGN
	0x003F: [ 0x3F ], // QUESTION MARK
	0x0040: [ 0x40 ], // COMMERCIAL AT
	0x0041: [ 0x41 ], // LATIN CAPITAL LETTER A
	0x0042: [ 0x42 ], // LATIN CAPITAL LETTER B
	0x0043: [ 0x43 ], // LATIN CAPITAL LETTER C
	0x0044: [ 0x44 ], // LATIN CAPITAL LETTER D
	0x0045: [ 0x45 ], // LATIN CAPITAL LETTER E
	0x0046: [ 0x46 ], // LATIN CAPITAL LETTER F
	0x0047: [ 0x47 ], // LATIN CAPITAL LETTER G
	0x0048: [ 0x48 ], // LATIN CAPITAL LETTER H
	0x0049: [ 0x49 ], // LATIN CAPITAL LETTER I
	0x004A: [ 0x4A ], // LATIN CAPITAL LETTER J
	0x004B: [ 0x4B ], // LATIN CAPITAL LETTER K
	0x004C: [ 0x4C ], // LATIN CAPITAL LETTER L
	0x004D: [ 0x4D ], // LATIN CAPITAL LETTER M
	0x004E: [ 0x4E ], // LATIN CAPITAL LETTER N
	0x004F: [ 0x4F ], // LATIN CAPITAL LETTER O
	0x0050: [ 0x50 ], // LATIN CAPITAL LETTER P
	0x0051: [ 0x51 ], // LATIN CAPITAL LETTER Q
	0x0052: [ 0x52 ], // LATIN CAPITAL LETTER R
	0x0053: [ 0x53 ], // LATIN CAPITAL LETTER S
	0x0054: [ 0x54 ], // LATIN CAPITAL LETTER T
	0x0055: [ 0x55 ], // LATIN CAPITAL LETTER U
	0x0056: [ 0x56 ], // LATIN CAPITAL LETTER V
	0x0057: [ 0x57 ], // LATIN CAPITAL LETTER W
	0x0058: [ 0x58 ], // LATIN CAPITAL LETTER X
	0x0059: [ 0x59 ], // LATIN CAPITAL LETTER Y
	0x005A: [ 0x5A ], // LATIN CAPITAL LETTER Z
	0x005B: [ 0x5B ], // LEFT SQUARE BRACKET
	0x005C: [ 0x5C ], // REVERSE SOLIDUS
	0x005D: [ 0x5D ], // RIGHT SQUARE BRACKET
	0x005E: [ 0x5E ], // CIRCUMFLEX ACCENT
	0x005F: [ 0x5F ], // LOW LINE
	0x0060: [ 0x60 ], // GRAVE ACCENT
	0x0061: [ 0x61 ], // LATIN SMALL LETTER A
	0x0062: [ 0x62 ], // LATIN SMALL LETTER B
	0x0063: [ 0x63 ], // LATIN SMALL LETTER C
	0x0064: [ 0x64 ], // LATIN SMALL LETTER D
	0x0065: [ 0x65 ], // LATIN SMALL LETTER E
	0x0066: [ 0x66 ], // LATIN SMALL LETTER F
	0x0067: [ 0x67 ], // LATIN SMALL LETTER G
	0x0068: [ 0x68 ], // LATIN SMALL LETTER H
	0x0069: [ 0x69 ], // LATIN SMALL LETTER I
	0x006A: [ 0x6A ], // LATIN SMALL LETTER J
	0x006B: [ 0x6B ], // LATIN SMALL LETTER K
	0x006C: [ 0x6C ], // LATIN SMALL LETTER L
	0x006D: [ 0x6D ], // LATIN SMALL LETTER M
	0x006E: [ 0x6E ], // LATIN SMALL LETTER N
	0x006F: [ 0x6F ], // LATIN SMALL LETTER O
	0x0070: [ 0x70 ], // LATIN SMALL LETTER P
	0x0071: [ 0x71 ], // LATIN SMALL LETTER Q
	0x0072: [ 0x72 ], // LATIN SMALL LETTER R
	0x0073: [ 0x73 ], // LATIN SMALL LETTER S
	0x0074: [ 0x74 ], // LATIN SMALL LETTER T
	0x0075: [ 0x75 ], // LATIN SMALL LETTER U
	0x0076: [ 0x76 ], // LATIN SMALL LETTER V
	0x0077: [ 0x77 ], // LATIN SMALL LETTER W
	0x0078: [ 0x78 ], // LATIN SMALL LETTER X
	0x0079: [ 0x79 ], // LATIN SMALL LETTER Y
	0x007A: [ 0x7A ], // LATIN SMALL LETTER Z
	0x007B: [ 0x7B ], // LEFT CURLY BRACKET
	0x007C: [ 0x7C ], // VERTICAL LINE
	0x007D: [ 0x7D ], // RIGHT CURLY BRACKET
	0x007E: [ 0x7E ], // TILDE
	0x2302: [ 0x7F ], // HOUSE
	0x00C7: [ 0x80 ], // LATIN CAPITAL LETTER C WITH CEDILLA
	0x00FC: [ 0x81 ], // LATIN SMALL LETTER U WITH DIAERESIS
	0x00E9: [ 0x82 ], // LATIN SMALL LETTER E WITH ACUTE
	0x00E2: [ 0x83 ], // LATIN SMALL LETTER A WITH CIRCUMFLEX
	0x00C1: [ 0x84 ], // LATIN CAPITAL LETTER A WITH ACUTE
	0x00E0: [ 0x85 ], // LATIN SMALL LETTER A WITH GRAVE
	0x00A8: [ 0x86 ], // DIAERESIS
	0x00E7: [ 0x87 ], // LATIN SMALL LETTER C WITH CEDILLA
	0x00EA: [ 0x88 ], // LATIN SMALL LETTER E WITH CIRCUMFLEX
	0x00CD: [ 0x89 ], // LATIN CAPITAL LETTER I WITH ACUTE
	0x00D3: [ 0x8A ], // LATIN CAPITAL LETTER O WITH ACUTE
	0x00DA: [ 0x8B ], // LATIN CAPITAL LETTER U WITH ACUTE
	0x00C2: [ 0x8C ], // LATIN CAPITAL LETTER A WITH CIRCUMFLEX
	0x00CA: [ 0x8D ], // LATIN CAPITAL LETTER E WITH CIRCUMFLEX
	0x00D4: [ 0x8E ], // LATIN CAPITAL LETTER O WITH CIRCUMFLEX
	0x00C0: [ 0x8F ], // LATIN CAPITAL LETTER A WITH GRAVE
	0x00C9: [ 0x90 ], // LATIN CAPITAL LETTER E WITH ACUTE
	0x00E6: [ 0x91 ], // LATIN SMALL LETTER AE
	0x00C6: [ 0x92 ], // LATIN CAPITAL LETTER AE
	0x00F4: [ 0x93 ], // LATIN SMALL LETTER O WITH CIRCUMFLEX
	0x00F6: [ 0x94 ], // LATIN SMALL LETTER O WITH DIAERESIS
	0x00F2: [ 0x95 ], // LATIN SMALL LETTER O WITH GRAVE
	0x00FB: [ 0x96 ], // LATIN SMALL LETTER U WITH CIRCUMFLEX
	0x00F9: [ 0x97 ], // LATIN SMALL LETTER U WITH GRAVE
	0x00FF: [ 0x98 ], // LATIN SMALL LETTER Y WITH DIAERESIS
	0x00D6: [ 0x99 ], // LATIN CAPITAL LETTER O WITH DIAERESIS
	0x00DC: [ 0x9A ], // LATIN CAPITAL LETTER U WITH DIAERESIS
	0x00A2: [ 0x9B ], // CENT SIGN
	0x00A3: [ 0x9C ], // POUND SIGN
	0x00A5: [ 0x9D ], // YEN SIGN
	0x20A2: [ 0x9E ], // CRUZEIRO SIGN
	0x0192: [ 0x9F ], // LATIN SMALL LETTER F WITH HOOK
	0x00E1: [ 0xA0 ], // LATIN SMALL LETTER A WITH ACUTE
	0x00ED: [ 0xA1 ], // LATIN SMALL LETTER I WITH ACUTE
	0x00F3: [ 0xA2 ], // LATIN SMALL LETTER O WITH ACUTE
	0x00FA: [ 0xA3 ], // LATIN SMALL LETTER U WITH ACUTE
	0x00F1: [ 0xA4 ], // LATIN SMALL LETTER N WITH TILDE
	0x00D1: [ 0xA5 ], // LATIN CAPITAL LETTER N WITH TILDE
	0x00AA: [ 0xA6 ], // FEMININE ORDINAL INDICATOR
	0x00BA: [ 0xA7 ], // MASCULINE ORDINAL INDICATOR
	0x00BF: [ 0xA8 ], // INVERTED QUESTION MARK
	0x2310: [ 0xA9 ], // REVERSED NOT SIGN
	0x00AC: [ 0xAA ], // NOT SIGN
	0x00BD: [ 0xAB ], // VULGAR FRACTION ONE HALF
	0x00BC: [ 0xAC ], // VULGAR FRACTION ONE QUARTER
	0x00A1: [ 0xAD ], // INVERTED EXCLAMATION MARK
	0x00AB: [ 0xAE ], // LEFT-POINTING DOUBLE ANGLE QUOTATION MARK
	0x00BB: [ 0xAF ], // RIGHT-POINTING DOUBLE ANGLE QUOTATION MARK
	0x00C3: [ 0xB0 ], // LATIN CAPITAL LETTER A WITH TILDE
	0x00E3: [ 0xB1 ], // LATIN SMALL LETTER A WITH TILDE
	0x0128: [ 0xB2 ], // LATIN CAPITAL LETTER I WITH TILDE
	0x0129: [ 0xB3 ], // LATIN SMALL LETTER I WITH TILDE
	0x00D5: [ 0xB4 ], // LATIN CAPITAL LETTER O WITH TILDE
	0x00F5: [ 0xB5 ], // LATIN SMALL LETTER O WITH TILDE
	0x0168: [ 0xB6 ], // LATIN CAPITAL LETTER U WITH TILDE
	0x0169: [ 0xB7 ], // LATIN SMALL LETTER U WITH TILDE
	0x0132: [ 0xB8 ], // LATIN CAPITAL LIGATURE IJ
	0x0133: [ 0xB9 ], // LATIN SMALL LIGATURE IJ
	0x00BE: [ 0xBA ], // VULGAR FRACTION THREE QUARTERS
	0x223D: [ 0xBB ], // REVERSED TILDE
	0x25C7: [ 0xBC ], // WHITE DIAMOND
	0x2030: [ 0xBD ], // PER MILLE SIGN
	0x00B6: [ 0xBE ], // PILCROW SIGN
	0x00A7: [ 0xBF ], // SECTION SIGN
	0x2582: [ 0xC0 ], // LOWER ONE QUARTER BLOCK
	0x259A: [ 0xC1 ], // QUADRANT UPPER LEFT AND LOWER RIGHT
	0x2586: [ 0xC2 ], // LOWER THREE QUARTERS BLOCK
	0x1FB82: [ 0xC3 ], // UPPER ONE QUARTER BLOCK
	0x25AC: [ 0xC4 ], // BLACK RECTANGLE
	0x1FB85: [ 0xC5 ], // UPPER THREE QUARTERS BLOCK
	0x258E: [ 0xC6 ], // LEFT ONE QUARTER BLOCK
	0x259E: [ 0xC7 ], // QUADRANT UPPER RIGHT AND LOWER LEFT
	0x258A: [ 0xC8 ], // LEFT THREE QUARTERS BLOCK
	0x1FB87: [ 0xC9 ], // RIGHT ONE QUARTER BLOCK
	0x1FB8A: [ 0xCA ], // RIGHT THREE QUARTERS BLOCK
	0x1FB99: [ 0xCB ], // UPPER RIGHT TO LOWER LEFT FILL
	0x1FB98: [ 0xCC ], // UPPER LEFT TO LOWER RIGHT FILL
	0x1FB6D: [ 0xCD ], // UPPER TRIANGULAR ONE QUARTER BLOCK
	0x1FB6F: [ 0xCE ], // LOWER TRIANGULAR ONE QUARTER BLOCK
	0x1FB6C: [ 0xCF ], // LEFT TRIANGULAR ONE QUARTER BLOCK
	0x1FB6E: [ 0xD0 ], // RIGHT TRIANGULAR ONE QUARTER BLOCK
	0x1FB9A: [ 0xD1 ], // UPPER AND LOWER TRIANGULAR HALF BLOCK
	0x1FB9B: [ 0xD2 ], // LEFT AND RIGHT TRIANGULAR HALF BLOCK
	0x2598: [ 0xD3 ], // QUADRANT UPPER LEFT
	0x2597: [ 0xD4 ], // QUADRANT LOWER RIGHT
	0x259D: [ 0xD5 ], // QUADRANT UPPER RIGHT
	0x2596: [ 0xD6 ], // QUADRANT LOWER LEFT
	0x1FB96: [ 0xD7 ], // INVERSE CHECKER BOARD FILL
	0x0394: [ 0xD8 ], // GREEK CAPITAL LETTER DELTA
	0x2021: [ 0xD9 ], // DOUBLE DAGGER
	0x03C9: [ 0xDA ], // GREEK SMALL LETTER OMEGA
	0x2588: [ 0xDB ], // FULL BLOCK
	0x2584: [ 0xDC ], // LOWER HALF BLOCK
	0x258C: [ 0xDD ], // LEFT HALF BLOCK
	0x2590: [ 0xDE ], // RIGHT HALF BLOCK
	0x2580: [ 0xDF ], // UPPER HALF BLOCK
	0x03B1: [ 0xE0 ], // GREEK SMALL LETTER ALPHA
	0x00DF: [ 0xE1 ], // LATIN SMALL LETTER SHARP S
	0x0393: [ 0xE2 ], // GREEK CAPITAL LETTER GAMMA
	0x03C0: [ 0xE3 ], // GREEK SMALL LETTER PI
	0x03A3: [ 0xE4 ], // GREEK CAPITAL LETTER SIGMA
	0x03C3: [ 0xE5 ], // GREEK SMALL LETTER SIGMA
	0x00B5: [ 0xE6 ], // MICRO SIGN
	0x03C4: [ 0xE7 ], // GREEK SMALL LETTER TAU
	0x03A6: [ 0xE8 ], // GREEK CAPITAL LETTER PHI
	0x0398: [ 0xE9 ], // GREEK CAPITAL LETTER THETA
	0x03A9: [ 0xEA ], // GREEK CAPITAL LETTER OMEGA
	0x03B4: [ 0xEB ], // GREEK SMALL LETTER DELTA
	0x221E: [ 0xEC ], // INFINITY
	0x2205: [ 0xED ], // EMPTY SET
	0x2208: [ 0xEE ], // ELEMENT OF
	0x2229: [ 0xEF ], // INTERSECTION
	0x2261: [ 0xF0 ], // IDENTICAL TO
	0x00B1: [ 0xF1 ], // PLUS-MINUS SIGN
	0x2265: [ 0xF2 ], // GREATER-THAN OR EQUAL TO
	0x2264: [ 0xF3 ], // LESS-THAN OR EQUAL TO
	0x2320: [ 0xF4 ], // TOP HALF INTEGRAL
	0x2321: [ 0xF5 ], // BOTTOM HALF INTEGRAL
	0x00F7: [ 0xF6 ], // DIVISION SIGN
	0x2248: [ 0xF7 ], // ALMOST EQUAL TO
	0x00B0: [ 0xF8 ], // DEGREE SIGN
	0x2219: [ 0xF9 ], // BULLET OPERATOR
	0x00B7: [ 0xFA ], // MIDDLE DOT
	0x221A: [ 0xFB ], // SQUARE ROOT
	0x207F: [ 0xFC ], // SUPERSCRIPT LATIN SMALL LETTER N
	0x00B2: [ 0xFD ], // SUPERSCRIPT TWO
	0x25A0: [ 0xFE ], // BLACK SQUARE
};

// Convert string to match MSX system font
module.exports.convertToMSX = function (str)
{
	return locUtil.mapCharacter(str, MapINTtoMSX);
}