; ____________________________                                                 
; ██▀▀█▀▀██▀▀▀▀▀▀▀█▀▀█        │   ▄▄       ▄▄                                  
; ██  ▀  █▄  ▀██▄ ▀ ▄█ ▄▀▀ █  │  ██▄█ ██▄▀ ██▄▀ ▄█▀▄  ██▀                      
; █  █ █  ▀▀  ▄█  █  █ ▀▄█ █▄ │  ██ █ ██   ██ █ ▀█▄▀ ▄██                       
; ▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀────────┘                                                
;  by Guillaume 'Aoineko' Blanchard under CC BY-SA license                     
;==============================================================================
; Autogenerated Arkos AKG player for MSX-GL library                           
;  on 10/02/2023 at  0:02:36, 44                                                         
;                                                                              
; Arkos Tracker and the Z80 players are coded and designed                     
;  by Julien Névo (aka Targhan/Arkos) under MIT License.                       
;==============================================================================
PLY_AKG_FULL_INIT_CODE = .+1
PLY_AKG_STOP_SOUNDS = .+1
PLY_AKG_BITFORSOUND = .+2
PLY_AKG_SOUNDEFFECTDATA_OFFSETINVERTEDVOLUME = .+2
PLY_AKG_START:
_PLY_AKG_INITSOUNDEFFECTS::
PLY_AKG_INITSOUNDEFFECTS:
PLY_AKG_OFFSET2B:
PLY_AKG_OFFSET1B:
PLY_AKG_USE_HOOKS:
PLY_AKG_OPCODE_OR_A:
PLY_AKG_OPCODE_ADD_HL_BC_MSB:
	ld (PLY_AKG_PTSOUNDEFFECTTABLE), hl
PLY_AKG_SOUNDEFFECTDATA_OFFSETCURRENTSTEP:
	ret 
_PLY_AKG_PLAYSOUNDEFFECT::
PLY_AKG_PLAYSOUNDEFFECT:
PLY_AKG_SOUNDEFFECTDATA_OFFSETSPEED:
	dec a
PLY_AKG_BITFORNOISE:
	ld hl, (PLY_AKG_PTSOUNDEFFECTTABLE)
    ld e, a
PLY_AKG_OPCODE_ADD_HL_BC_LSB:
	ld d, #0x0
    add hl, de
    add hl, de
    ld e, (hl)
    inc hl
    ld d, (hl)
    ld a, (de)
    inc de
    ex af, af';'
    ld a, b
    ld hl, #PLY_AKG_CHANNEL1_SOUNDEFFECTDATA
    ld b, #0x0
    sla c
    sla c
    sla c
    add hl, bc
    ld (hl), e
    inc hl
    ld (hl), d
PLY_AKG_OPCODE_INC_HL:
	inc hl
    ld (hl), a
    inc hl
    ld (hl), #0x0
    inc hl
    ex af, af';'
    ld (hl), a
PLY_AKG_OPCODE_DEC_HL:
	ret 
_PLY_AKG_STOPSOUNDEFFECTFROMCHANNEL::
PLY_AKG_STOPSOUNDEFFECTFROMCHANNEL:
	add a, a
    add a, a
    add a, a
    ld e, a
    ld d, #0x0
    ld hl, #PLY_AKG_CHANNEL1_SOUNDEFFECTDATA
    add hl, de
    ld (hl), d
    inc hl
    ld (hl), d
    ret 
PLY_AKG_PLAYSOUNDEFFECTSSTREAM:
	rla 
    rla 
    ld ix, #PLY_AKG_CHANNEL1_SOUNDEFFECTDATA
PLY_AKG_OPCODE_SBC_HL_BC_LSB = .+2
    ld iy, #PLY_AKG_PSGREG8
    ld hl, #PLY_AKG_PSGREG01_INSTR
    exx
    ld c, a
    call PLY_AKG_PSES_PLAY
    ld ix, #PLY_AKG_CHANNEL2_SOUNDEFFECTDATA
    ld iy, #PLY_AKG_PSGREG9_10_INSTR
    exx
    ld hl, #PLY_AKG_PSGREG23_INSTR
    exx
    srl c
    call PLY_AKG_PSES_PLAY
    ld ix, #PLY_AKG_CHANNEL3_SOUNDEFFECTDATA
    ld iy, #PLY_AKG_PSGREG10
    exx
    ld hl, #PLY_AKG_PSGREG45_INSTR
    exx
    scf
    rr c
    call PLY_AKG_PSES_PLAY
    ld a, c
    ret 
PLY_AKG_PSES_PLAY:
	ld l, +0(ix)
    ld h, +1(ix)
    ld a, l
    or h
    ret z
PLY_AKG_PSES_READFIRSTBYTE:
	ld a, (hl)
    inc hl
    ld b, a
    rra 
    jr c, PLY_AKG_PSES_SOFTWAREORSOFTWAREANDHARDWARE
    rra 
    jr c, PLY_AKG_PSES_HARDWAREONLY
    rra 
    jr c, PLY_AKG_PSES_S_ENDORLOOP
    call PLY_AKG_PSES_MANAGEVOLUMEFROMA_FILTER4BITS
    rl b
    call PLY_AKG_PSES_READNOISEIFNEEDEDANDOPENORCLOSENOISECHANNEL
    set 2, c
    jr PLY_AKG_PSES_SAVEPOINTERANDEXIT
PLY_AKG_PSES_S_ENDORLOOP:
	rra 
    jr c, PLY_AKG_PSES_S_LOOP
    xor a
    ld +0(ix), a
    ld +1(ix), a
    ret 
PLY_AKG_PSES_S_LOOP:
	ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    jr PLY_AKG_PSES_READFIRSTBYTE
PLY_AKG_PSES_SAVEPOINTERANDEXIT:
	ld a, +3(ix)
    cp +4(ix)
    jr c, PLY_AKG_PSES_NOTREACHED
    ld +3(ix), #0x0
    .db 0xdd
    .db 0x75
    .db 0x0
    .db 0xdd
    .db 0x74
    .db 0x1
    ret 
PLY_AKG_PSES_NOTREACHED:
	inc +3(ix)
    ret 
PLY_AKG_PSES_HARDWAREONLY:
	call PLY_AKG_PSES_SHARED_READRETRIGHARDWAREENVPERIODNOISE
    set 2, c
    jr PLY_AKG_PSES_SAVEPOINTERANDEXIT
PLY_AKG_PSES_SOFTWAREORSOFTWAREANDHARDWARE:
PLY_AKG_OPCODE_JP:
	rra 
    jr c, PLY_AKG_PSES_SOFTWAREANDHARDWARE
PLY_AKG_OPCODE_ADD_A_IMMEDIATE:
	call PLY_AKG_PSES_MANAGEVOLUMEFROMA_FILTER4BITS
    rl b
    call PLY_AKG_PSES_READNOISEIFNEEDEDANDOPENORCLOSENOISECHANNEL
    res 2, c
    call PLY_AKG_PSES_READSOFTWAREPERIOD
    jr PLY_AKG_PSES_SAVEPOINTERANDEXIT
PLY_AKG_OPCODE_SUB_IMMEDIATE = .+1
PLY_AKG_PSES_SOFTWAREANDHARDWARE:
	call PLY_AKG_PSES_SHARED_READRETRIGHARDWAREENVPERIODNOISE
    call PLY_AKG_PSES_READSOFTWAREPERIOD
    res 2, c
    jr PLY_AKG_PSES_SAVEPOINTERANDEXIT
PLY_AKG_PSES_SHARED_READRETRIGHARDWAREENVPERIODNOISE:
	rra 
    jr nc, PLY_AKG_PSES_H_AFTERRETRIG
    ld d, a
    ld a, #0xff
    ld (PLY_AKG_PSGREG13_OLDVALUE), a
    ld a, d
PLY_AKG_PSES_H_AFTERRETRIG:
	and #0x7
    add a, #0x8
PLY_AKG_OPCODE_SBC_HL_BC_MSB:
	ld (PLY_AKG_PSGREG13_INSTR), a
    rl b
    call PLY_AKG_PSES_READNOISEIFNEEDEDANDOPENORCLOSENOISECHANNEL
    call PLY_AKG_PSES_READHARDWAREPERIOD
    ld a, #0x10
    jp PLY_AKG_PSES_MANAGEVOLUMEFROMA_HARD
PLY_AKG_PSES_READNOISEIFNEEDEDANDOPENORCLOSENOISECHANNEL:
	jr c, PLY_AKG_PSES_READNOISEANDOPENNOISECHANNEL_OPENNOISE
PLY_AKG_OPCODE_SCF:
	set 5, c
    ret 
PLY_AKG_PSES_READNOISEANDOPENNOISECHANNEL_OPENNOISE:
	ld a, (hl)
    ld (PLY_AKG_PSGREG6_8_INSTR), a
    inc hl
    res 5, c
    ret 
PLY_AKG_PSES_READHARDWAREPERIOD:
	ld a, (hl)
    ld (PLY_AKG_PSGHARDWAREPERIOD_INSTR), a
    inc hl
    ld a, (hl)
    ld (PLY_AKG_PSGHARDWAREPERIOD_INSTR+1), a
    inc hl
    ret 
PLY_AKG_PSES_READSOFTWAREPERIOD:
	ld a, (hl)
    inc hl
    exx
    ld (hl), a
    inc hl
    exx
    ld a, (hl)
    inc hl
    exx
    ld (hl), a
    exx
    ret 
PLY_AKG_PSES_MANAGEVOLUMEFROMA_FILTER4BITS:
	and #0xf
PLY_AKG_PSES_MANAGEVOLUMEFROMA_HARD:
	sub +2(ix)
    jr nc, PLY_AKG_PSES_MVFA_NOOVERFLOW
    xor a
PLY_AKG_PSES_MVFA_NOOVERFLOW:
	ld +0(iy), a
    ret 
_PLY_AKG_INIT::
PLY_AKG_INIT:
	ld de, #0x4
    add hl, de
    ld de, #PLY_AKG_ARPEGGIOSTABLE
    ldi
    ldi
    ld de, #PLY_AKG_PITCHESTABLE
    ldi
    ldi
    ld de, #PLY_AKG_INSTRUMENTSTABLE
    ldi
    ldi
    ld c, (hl)
    inc hl
    ld b, (hl)
    inc hl
    ld (PLY_AKG_CHANNEL_READEFFECTS_EFFECTBLOCKS1), bc
    add a, a
    ld e, a
    ld d, #0x0
    add hl, de
    ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    ld de, #0x5
    add hl, de
    ld de, #PLY_AKG_CURRENTSPEED
    ldi
    ld de, #PLY_AKG_BASENOTEINDEX
    ldi
    ld (PLY_AKG_READLINKER_PTLINKER), hl
    ld hl, #PLY_AKG_INITTABLE0
    ld bc, #0xe00
    call PLY_AKG_INIT_READWORDSANDFILL
    inc c
    ld hl, #PLY_AKG_INITTABLE0_END
    ld b, #0x3
    call PLY_AKG_INIT_READWORDSANDFILL
    ld hl, #PLY_AKG_INITTABLE1_END
    ld bc, #0xd00
    call PLY_AKG_INIT_READWORDSANDFILL
    ld hl, #PLY_AKG_INITTABLEORA_END
    ld bc, #0xcc3
    call PLY_AKG_INIT_READWORDSANDFILL
    ld a, #0xff
    ld (PLY_AKG_PSGREG13_OLDVALUE), a
    ld hl, (PLY_AKG_INSTRUMENTSTABLE)
    ld e, (hl)
    inc hl
    ld d, (hl)
    ex de, hl
    inc hl
    ld (PLY_AKG_EMPTYINSTRUMENTDATAPT), hl
    ld (PLY_AKG_CHANNEL1_PTINSTRUMENT), hl
    ld (PLY_AKG_CHANNEL2_PTINSTRUMENT), hl
    ld (PLY_AKG_CHANNEL3_PTINSTRUMENT), hl
    xor a
    ld (PLY_AKG_CHANNEL1_PITCHTRACK+1), a
    ld hl, #PLY_AKG_CHANNEL1_PITCHTRACKINTEGERADDORSUBRETURN
    ld (PLY_AKG_CHANNEL1_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS+1), hl
    ld hl, #PLY_AKG_CHANNEL1_PITCHTRACKADDORSBC_16BITSRETURN
    ld (PLY_AKG_CHANNEL1_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS+1), hl
    ld hl, #PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTRANDVALUERETURNAFTERJP
    ld (PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTRANDVALUERETURNJP+1), hl
    ld (PLY_AKG_CHANNEL2_PITCHTRACK+1), a
    ld hl, #PLY_AKG_CHANNEL2_PITCHTRACKINTEGERADDORSUBRETURN
    ld (PLY_AKG_CHANNEL2_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS+1), hl
    ld hl, #PLY_AKG_CHANNEL2_PITCHTRACKADDORSBC_16BITSRETURN
    ld (PLY_AKG_CHANNEL2_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS+1), hl
    ld hl, #PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTRANDVALUERETURNAFTERJP
    ld (PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTRANDVALUERETURNJP+1), hl
    ld (PLY_AKG_CHANNEL3_PITCHTRACK+1), a
    ld hl, #PLY_AKG_CHANNEL3_PITCHTRACKINTEGERADDORSUBRETURN
    ld (PLY_AKG_CHANNEL3_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS+1), hl
    ld hl, #PLY_AKG_CHANNEL3_PITCHTRACKADDORSBC_16BITSRETURN
    ld (PLY_AKG_CHANNEL3_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS+1), hl
    ld hl, #PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTRANDVALUERETURNAFTERJP
    ld (PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTRANDVALUERETURNJP+1), hl
    ld hl, #0x0
    ld (PLY_AKG_CHANNEL1_SOUNDEFFECTDATA), hl
    ld (PLY_AKG_CHANNEL2_SOUNDEFFECTDATA), hl
    ld (PLY_AKG_CHANNEL3_SOUNDEFFECTDATA), hl
    ret 
PLY_AKG_INIT_READWORDSANDFILL_LOOP:
	ld e, (hl)
    inc hl
    ld d, (hl)
    inc hl
    ld a, c
    ld (de), a
PLY_AKG_INIT_READWORDSANDFILL:
	djnz PLY_AKG_INIT_READWORDSANDFILL_LOOP
    ret 
PLY_AKG_INITTABLE0:
	.dw PLY_AKG_CHANNEL1_INVERTEDVOLUMEINTEGERANDDECIMAL
    .dw PLY_AKG_CHANNEL1_INVERTEDVOLUMEINTEGER
    .dw PLY_AKG_CHANNEL2_INVERTEDVOLUMEINTEGERANDDECIMAL
    .dw PLY_AKG_CHANNEL2_INVERTEDVOLUMEINTEGER
    .dw PLY_AKG_CHANNEL3_INVERTEDVOLUMEINTEGERANDDECIMAL
    .dw PLY_AKG_CHANNEL3_INVERTEDVOLUMEINTEGER
    .dw PLY_AKG_CHANNEL1_PITCH
    .dw PLY_AKG_CHANNEL1_PITCH+1
    .dw PLY_AKG_CHANNEL2_PITCH
    .dw PLY_AKG_CHANNEL2_PITCH+1
    .dw PLY_AKG_CHANNEL3_PITCH
    .dw PLY_AKG_CHANNEL3_PITCH+1
    .dw PLY_AKG_CHANNEL_RE_READNEXTEFFECTINBLOCK
PLY_AKG_INITTABLE0_END:
PLY_AKG_INITTABLE1:
	.dw PLY_AKG_PATTERNDECREASINGHEIGHT
    .dw PLY_AKG_TICKDECREASINGCOUNTER
PLY_AKG_INITTABLE1_END:
PLY_AKG_INITTABLEORA:
	.dw PLY_AKG_CHANNEL1_ISVOLUMESLIDE
    .dw PLY_AKG_CHANNEL2_ISVOLUMESLIDE
    .dw PLY_AKG_CHANNEL3_ISVOLUMESLIDE
    .dw PLY_AKG_CHANNEL1_ISARPEGGIOTABLE
    .dw PLY_AKG_CHANNEL2_ISARPEGGIOTABLE
    .dw PLY_AKG_CHANNEL3_ISARPEGGIOTABLE
    .dw PLY_AKG_CHANNEL1_ISPITCHTABLE
    .dw PLY_AKG_CHANNEL2_ISPITCHTABLE
    .dw PLY_AKG_CHANNEL3_ISPITCHTABLE
    .dw PLY_AKG_CHANNEL1_ISPITCH
    .dw PLY_AKG_CHANNEL2_ISPITCH
    .dw PLY_AKG_CHANNEL3_ISPITCH
PLY_AKG_INITTABLEORA_END:
PLY_AKG_INITTABLEJP:
	.dw PLY_AKG_CHANNEL1_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS
    .dw PLY_AKG_CHANNEL2_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS
    .dw PLY_AKG_CHANNEL3_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS
    .dw PLY_AKG_CHANNEL1_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS
    .dw PLY_AKG_CHANNEL2_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS
    .dw PLY_AKG_CHANNEL3_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS
    .dw PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTRANDVALUERETURNJP
    .dw PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTRANDVALUERETURNJP
    .dw PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTRANDVALUERETURNJP
    .dw PLY_AKG_CHANNEL_READEFFECTS_ENDJUMPINSTRANDADDRESS
    .dw PLY_AKG_TEMPPLAYINSTRUMENTJUMPINSTRANDADDRESS
PLY_AKG_INITTABLEJP_END:
_PLY_AKG_STOP::
PLY_AKG_STOP:
	ld (PLY_AKG_SAVESP), sp
    xor a
    ld l, a
    ld h, a
    ld (PLY_AKG_PSGREG8), a
    ld (PLY_AKG_PSGREG9_10_INSTR), hl
    ld a, #0xbf
    jp PLY_AKG_SENDPSGREGISTERS
_PLY_AKG_PLAY::
PLY_AKG_PLAY:
	ld (PLY_AKG_SAVESP), sp
    xor a
    ld (PLY_AKG_EVENT), a
    ld a, (PLY_AKG_TICKDECREASINGCOUNTER)
    dec a
    jp nz, PLY_AKG_SETSPEEDBEFOREPLAYSTREAMS
    ld a, (PLY_AKG_PATTERNDECREASINGHEIGHT)
    dec a
    jr nz, PLY_AKG_SETCURRENTLINEBEFOREREADLINE
PLY_AKG_READLINKER:
	ld sp, (PLY_AKG_READLINKER_PTLINKER)
    pop hl
    ld a, l
    or h
    jr nz, PLY_AKG_READLINKER_NOLOOP
    pop hl
    ld sp, hl
    pop hl
; MSXgl - Start
	ld		a, #0xFF
	ld		(_g_AKG_EndOfSong), a
; MSXgl - End
PLY_AKG_READLINKER_NOLOOP:
	ld (PLY_AKG_CHANNEL1_PTTRACK), hl
    pop hl
    ld (PLY_AKG_CHANNEL2_PTTRACK), hl
    pop hl
    ld (PLY_AKG_CHANNEL3_PTTRACK), hl
    pop hl
    ld (PLY_AKG_READLINKER_PTLINKER), sp
    ld sp, hl
    pop hl
    ld c, l
    ld a, h
    ld (PLY_AKG_CHANNEL1_SOUNDSTREAM_RELATIVEMODIFIERADDRESS), a
    pop hl
    ld a, l
    ld (PLY_AKG_CHANNEL2_PLAYINSTRUMENT_RELATIVEMODIFIERADDRESS), a
    ld a, h
    ld (PLY_AKG_CHANNEL3_SOUNDSTREAM_RELATIVEMODIFIERADDRESS), a
    pop hl
    ld (PLY_AKG_SPEEDTRACK_PTTRACK), hl
    pop hl
    ld (PLY_AKG_EVENTTRACK_PTTRACK), hl
    xor a
    ld (PLY_AKG_SPEEDTRACK_WAITCOUNTER), a
    ld (PLY_AKG_EVENTTRACK_WAITCOUNTER), a
    ld (PLY_AKG_CHANNEL1_WAITCOUNTER), a
    ld (PLY_AKG_CHANNEL2_WAITCOUNTER), a
    ld (PLY_AKG_CHANNEL3_WAITCOUNTER), a
    ld a, c
PLY_AKG_SETCURRENTLINEBEFOREREADLINE:
	ld (PLY_AKG_PATTERNDECREASINGHEIGHT), a
PLY_AKG_READLINE:
	ld a, (PLY_AKG_SPEEDTRACK_WAITCOUNTER)
    sub #0x1
    jr nc, PLY_AKG_SPEEDTRACK_MUSTWAIT
    ld hl, (PLY_AKG_SPEEDTRACK_PTTRACK)
    ld a, (hl)
    inc hl
    srl a
    jr c, PLY_AKG_SPEEDTRACK_STOREPOINTERANDWAITCOUNTER
    jr nz, PLY_AKG_SPEEDTRACK_NORMALVALUE
    ld a, (hl)
    inc hl
PLY_AKG_SPEEDTRACK_NORMALVALUE:
	ld (PLY_AKG_CURRENTSPEED), a
    xor a
PLY_AKG_SPEEDTRACK_STOREPOINTERANDWAITCOUNTER:
	ld (PLY_AKG_SPEEDTRACK_PTTRACK), hl
PLY_AKG_SPEEDTRACK_MUSTWAIT:
	ld (PLY_AKG_SPEEDTRACK_WAITCOUNTER), a
PLY_AKG_SPEEDTRACK_END:
	ld a, (PLY_AKG_EVENTTRACK_WAITCOUNTER)
    sub #0x1
    jr nc, PLY_AKG_EVENTTRACK_MUSTWAIT
    ld hl, (PLY_AKG_EVENTTRACK_PTTRACK)
    ld a, (hl)
    inc hl
    srl a
    jr c, PLY_AKG_EVENTTRACK_STOREPOINTERANDWAITCOUNTER
    jr nz, PLY_AKG_EVENTTRACK_NORMALVALUE
    ld a, (hl)
    inc hl
PLY_AKG_EVENTTRACK_NORMALVALUE:
	ld (PLY_AKG_EVENT), a
    xor a
PLY_AKG_EVENTTRACK_STOREPOINTERANDWAITCOUNTER:
	ld (PLY_AKG_EVENTTRACK_PTTRACK), hl
PLY_AKG_EVENTTRACK_MUSTWAIT:
	ld (PLY_AKG_EVENTTRACK_WAITCOUNTER), a
PLY_AKG_EVENTTRACK_END:
	ld a, (PLY_AKG_CHANNEL1_WAITCOUNTER)
    sub #0x1
    jr c, PLY_AKG_CHANNEL1_READTRACK
    ld (PLY_AKG_CHANNEL1_WAITCOUNTER), a
    jp PLY_AKG_CHANNEL1_READCELLEND
PLY_AKG_CHANNEL1_READTRACK:
	ld hl, (PLY_AKG_CHANNEL1_PTTRACK)
    ld c, (hl)
    inc hl
    ld a, c
    and #0x3f
    cp #0x3c
    jr c, PLY_AKG_CHANNEL1_NOTE
    sub #0x3c
    jp z, PLY_AKG_CHANNEL1_MAYBEEFFECTS
    dec a
    jr z, PLY_AKG_CHANNEL1_WAIT
    dec a
    jr z, PLY_AKG_CHANNEL1_SMALLWAIT
    ld a, (hl)
    inc hl
    jr PLY_AKG_CHANNEL1_AFTERNOTEKNOWN
PLY_AKG_CHANNEL1_SMALLWAIT:
	ld a, c
    rlca 
    rlca 
    and #0x3
    inc a
    ld (PLY_AKG_CHANNEL1_WAITCOUNTER), a
    jr PLY_AKG_CHANNEL1_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL1_WAIT:
	ld a, (hl)
    ld (PLY_AKG_CHANNEL1_WAITCOUNTER), a
    inc hl
    jr PLY_AKG_CHANNEL1_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL1_SAMEINSTRUMENT:
	ld de, (PLY_AKG_CHANNEL1_PTBASEINSTRUMENT)
    ld (PLY_AKG_CHANNEL1_PTINSTRUMENT), de
    jr PLY_AKG_CHANNEL1_AFTERINSTRUMENT
PLY_AKG_CHANNEL1_NOTE:
	ld b, a
    ld a, (PLY_AKG_BASENOTEINDEX)
    add a, b
PLY_AKG_CHANNEL1_AFTERNOTEKNOWN:
	ld b, a
    ld a, (PLY_AKG_CHANNEL1_SOUNDSTREAM_RELATIVEMODIFIERADDRESS)
    add a, b
    ld (PLY_AKG_CHANNEL1_TRACKNOTE), a
    rl c
    jr nc, PLY_AKG_CHANNEL1_SAMEINSTRUMENT
    ld a, (hl)
    inc hl
    exx
    ld l, a
    ld h, #0x0
    add hl, hl
    ld de, (PLY_AKG_INSTRUMENTSTABLE)
    add hl, de
    ld sp, hl
    pop hl
    ld a, (hl)
    inc hl
    ld (PLY_AKG_CHANNEL1_INSTRUMENTORIGINALSPEED), a
    ld (PLY_AKG_CHANNEL1_PTINSTRUMENT), hl
    ld (PLY_AKG_CHANNEL1_PTBASEINSTRUMENT), hl
    exx
PLY_AKG_CHANNEL1_AFTERINSTRUMENT:
	ex de, hl
    xor a
    ld l, a
    ld h, a
    ld (PLY_AKG_CHANNEL1_PITCH), hl
    ld (PLY_AKG_CHANNEL1_ARPEGGIOTABLECURRENTSTEP), a
    ld (PLY_AKG_CHANNEL1_PITCHTABLECURRENTSTEP), a
    ld (PLY_AKG_CHANNEL1_INSTRUMENTSTEP), a
    ld a, (PLY_AKG_CHANNEL1_INSTRUMENTORIGINALSPEED)
    ld (PLY_AKG_CHANNEL1_INSTRUMENTSPEED), a
    ld a, #0x0
    ld (PLY_AKG_CHANNEL1_ISPITCH), a
    ld a, (PLY_AKG_CHANNEL1_ARPEGGIOBASESPEED)
    ld (PLY_AKG_CHANNEL1_ARPEGGIOTABLESPEED), a
    ld a, (PLY_AKG_CHANNEL1_PITCHBASESPEED)
    ld (PLY_AKG_CHANNEL1_PITCHTABLESPEED), a
    ld hl, (PLY_AKG_CHANNEL1_ARPEGGIOTABLEBASE)
    ld (PLY_AKG_CHANNEL1_ARPEGGIOTABLE), hl
    ld hl, (PLY_AKG_CHANNEL1_PITCHTABLEBASE)
    ld (PLY_AKG_CHANNEL1_PITCHTABLE), hl
    ex de, hl
    rl c
    jp c, PLY_AKG_CHANNEL1_READEFFECTS
PLY_AKG_CHANNEL1_BEFOREEND_STORECELLPOINTER:
	ld (PLY_AKG_CHANNEL1_PTTRACK), hl
PLY_AKG_CHANNEL1_READCELLEND:
	ld a, (PLY_AKG_CHANNEL2_WAITCOUNTER)
    sub #0x1
    jr c, PLY_AKG_CHANNEL2_READTRACK
    ld (PLY_AKG_CHANNEL2_WAITCOUNTER), a
    jp PLY_AKG_CHANNEL2_READCELLEND
PLY_AKG_CHANNEL2_READTRACK:
	ld hl, (PLY_AKG_CHANNEL2_PTTRACK)
    ld c, (hl)
    inc hl
    ld a, c
    and #0x3f
    cp #0x3c
    jr c, PLY_AKG_CHANNEL2_NOTE
    sub #0x3c
    jp z, PLY_AKG_CHANNEL1_READEFFECTSEND
    dec a
    jr z, PLY_AKG_CHANNEL2_WAIT
    dec a
    jr z, PLY_AKG_CHANNEL2_SMALLWAIT
    ld a, (hl)
    inc hl
    jr PLY_AKG_CHANNEL2_AFTERNOTEKNOWN
PLY_AKG_CHANNEL2_SMALLWAIT:
	ld a, c
    rlca 
    rlca 
    and #0x3
    inc a
    ld (PLY_AKG_CHANNEL2_WAITCOUNTER), a
    jr PLY_AKG_CHANNEL2_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL2_WAIT:
	ld a, (hl)
    ld (PLY_AKG_CHANNEL2_WAITCOUNTER), a
    inc hl
    jr PLY_AKG_CHANNEL2_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL2_SAMEINSTRUMENT:
	ld de, (PLY_AKG_CHANNEL2_PTBASEINSTRUMENT)
    ld (PLY_AKG_CHANNEL2_PTINSTRUMENT), de
    jr PLY_AKG_CHANNEL2_AFTERINSTRUMENT
PLY_AKG_CHANNEL2_NOTE:
	ld b, a
    ld a, (PLY_AKG_BASENOTEINDEX)
    add a, b
PLY_AKG_CHANNEL2_AFTERNOTEKNOWN:
	ld b, a
    ld a, (PLY_AKG_CHANNEL2_PLAYINSTRUMENT_RELATIVEMODIFIERADDRESS)
    add a, b
    ld (PLY_AKG_CHANNEL2_TRACKNOTE), a
    rl c
    jr nc, PLY_AKG_CHANNEL2_SAMEINSTRUMENT
    ld a, (hl)
    inc hl
    exx
    ld e, a
    ld d, #0x0
    ld hl, (PLY_AKG_INSTRUMENTSTABLE)
    add hl, de
    add hl, de
    ld sp, hl
    pop hl
    ld a, (hl)
    inc hl
    ld (PLY_AKG_CHANNEL2_INSTRUMENTORIGINALSPEED), a
    ld (PLY_AKG_CHANNEL2_PTINSTRUMENT), hl
    ld (PLY_AKG_CHANNEL2_PTBASEINSTRUMENT), hl
    exx
PLY_AKG_CHANNEL2_AFTERINSTRUMENT:
	ex de, hl
    xor a
    ld l, a
    ld h, a
    ld (PLY_AKG_CHANNEL2_PITCH), hl
    ld (PLY_AKG_CHANNEL2_ARPEGGIOTABLECURRENTSTEP), a
    ld (PLY_AKG_CHANNEL2_PITCHTABLECURRENTSTEP), a
    ld (PLY_AKG_CHANNEL2_INSTRUMENTSTEP), a
    ld a, (PLY_AKG_CHANNEL2_INSTRUMENTORIGINALSPEED)
    ld (PLY_AKG_CHANNEL2_INSTRUMENTSPEED), a
    ld a, #0x0
    ld (PLY_AKG_CHANNEL2_ISPITCH), a
    ld a, (PLY_AKG_CHANNEL2_ARPEGGIOBASESPEED)
    ld (PLY_AKG_CHANNEL2_ARPEGGIOTABLESPEED), a
    ld a, (PLY_AKG_CHANNEL2_PITCHBASESPEED)
    ld (PLY_AKG_CHANNEL2_PITCHTABLESPEED), a
    ld hl, (PLY_AKG_CHANNEL2_ARPEGGIOTABLEBASE)
    ld (PLY_AKG_CHANNEL2_ARPEGGIOTABLE), hl
    ld hl, (PLY_AKG_CHANNEL2_PITCHTABLEBASE)
    ld (PLY_AKG_CHANNEL2_PITCHTABLE), hl
    ex de, hl
    rl c
    jp c, PLY_AKG_CHANNEL2_READEFFECTS
PLY_AKG_CHANNEL2_BEFOREEND_STORECELLPOINTER:
	ld (PLY_AKG_CHANNEL2_PTTRACK), hl
PLY_AKG_CHANNEL2_READCELLEND:
	ld a, (PLY_AKG_CHANNEL3_WAITCOUNTER)
    sub #0x1
    jr c, PLY_AKG_CHANNEL3_READTRACK
    ld (PLY_AKG_CHANNEL3_WAITCOUNTER), a
    jp PLY_AKG_CHANNEL3_READCELLEND
PLY_AKG_CHANNEL3_READTRACK:
	ld hl, (PLY_AKG_CHANNEL3_PTTRACK)
    ld c, (hl)
    inc hl
    ld a, c
    and #0x3f
    cp #0x3c
    jr c, PLY_AKG_CHANNEL3_NOTE
    sub #0x3c
    jp z, PLY_AKG_CHANNEL2_READEFFECTSEND
    dec a
    jr z, PLY_AKG_CHANNEL3_WAIT
    dec a
    jr z, PLY_AKG_CHANNEL3_SMALLWAIT
    ld a, (hl)
    inc hl
    jr PLY_AKG_CHANNEL3_AFTERNOTEKNOWN
PLY_AKG_CHANNEL3_SMALLWAIT:
	ld a, c
    rlca 
    rlca 
    and #0x3
    inc a
    ld (PLY_AKG_CHANNEL3_WAITCOUNTER), a
    jr PLY_AKG_CHANNEL3_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL3_WAIT:
	ld a, (hl)
    ld (PLY_AKG_CHANNEL3_WAITCOUNTER), a
    inc hl
    jr PLY_AKG_CHANNEL3_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL3_SAMEINSTRUMENT:
	ld de, (PLY_AKG_CHANNEL3_PTBASEINSTRUMENT)
    ld (PLY_AKG_CHANNEL3_PTINSTRUMENT), de
    jr PLY_AKG_CHANNEL3_AFTERINSTRUMENT
PLY_AKG_CHANNEL3_NOTE:
	ld b, a
    ld a, (PLY_AKG_BASENOTEINDEX)
    add a, b
PLY_AKG_CHANNEL3_AFTERNOTEKNOWN:
	ld b, a
    ld a, (PLY_AKG_CHANNEL3_SOUNDSTREAM_RELATIVEMODIFIERADDRESS)
    add a, b
    ld (PLY_AKG_CHANNEL3_TRACKNOTE), a
    rl c
    jr nc, PLY_AKG_CHANNEL3_SAMEINSTRUMENT
    ld a, (hl)
    inc hl
    exx
    ld e, a
    ld d, #0x0
    ld hl, (PLY_AKG_INSTRUMENTSTABLE)
    add hl, de
    add hl, de
    ld sp, hl
    pop hl
    ld a, (hl)
    inc hl
    ld (PLY_AKG_CHANNEL3_INSTRUMENTORIGINALSPEED), a
    ld (PLY_AKG_CHANNEL3_PTINSTRUMENT), hl
    ld (PLY_AKG_CHANNEL3_PTBASEINSTRUMENT), hl
    exx
PLY_AKG_CHANNEL3_AFTERINSTRUMENT:
	ex de, hl
    xor a
    ld l, a
    ld h, a
    ld (PLY_AKG_CHANNEL3_PITCH), hl
    ld (PLY_AKG_CHANNEL3_ARPEGGIOTABLECURRENTSTEP), a
    ld (PLY_AKG_CHANNEL3_PITCHTABLECURRENTSTEP), a
    ld (PLY_AKG_CHANNEL3_INSTRUMENTSTEP), a
    ld a, (PLY_AKG_CHANNEL3_INSTRUMENTORIGINALSPEED)
    ld (PLY_AKG_CHANNEL3_INSTRUMENTSPEED), a
    ld a, #0x0
    ld (PLY_AKG_CHANNEL3_ISPITCH), a
    ld a, (PLY_AKG_CHANNEL3_ARPEGGIOBASESPEED)
    ld (PLY_AKG_CHANNEL3_ARPEGGIOTABLESPEED), a
    ld a, (PLY_AKG_CHANNEL3_PITCHBASESPEED)
    ld (PLY_AKG_CHANNEL3_PITCHTABLESPEED), a
    ld hl, (PLY_AKG_CHANNEL3_ARPEGGIOTABLEBASE)
    ld (PLY_AKG_CHANNEL3_ARPEGGIOTABLE), hl
    ld hl, (PLY_AKG_CHANNEL3_PITCHTABLEBASE)
    ld (PLY_AKG_CHANNEL3_PITCHTABLE), hl
    ex de, hl
    rl c
    jp c, PLY_AKG_CHANNEL3_READEFFECTS
PLY_AKG_CHANNEL3_BEFOREEND_STORECELLPOINTER:
	ld (PLY_AKG_CHANNEL3_PTTRACK), hl
PLY_AKG_CHANNEL3_READCELLEND:
	ld a, (PLY_AKG_CURRENTSPEED)
PLY_AKG_SETSPEEDBEFOREPLAYSTREAMS:
	ld (PLY_AKG_TICKDECREASINGCOUNTER), a
    ld hl, (PLY_AKG_CHANNEL1_INVERTEDVOLUMEINTEGERANDDECIMAL)
    ld a, (PLY_AKG_CHANNEL1_ISVOLUMESLIDE)
    add a, a
    jr nc, PLY_AKG_CHANNEL1_VOLUMESLIDE_END
    ld de, (PLY_AKG_CHANNEL1_VOLUMESLIDEVALUE)
    add hl, de
    bit 7, h
    jr z, PLY_AKG_CHANNEL1_VOLUMENOTOVERFLOW
    ld h, #0x0
    jr PLY_AKG_CHANNEL1_VOLUMESETAGAIN
PLY_AKG_CHANNEL1_VOLUMENOTOVERFLOW:
	ld a, h
    cp #0x10
    jr c, PLY_AKG_CHANNEL1_VOLUMESETAGAIN
    ld h, #0xf
PLY_AKG_CHANNEL1_VOLUMESETAGAIN:
	ld (PLY_AKG_CHANNEL1_INVERTEDVOLUMEINTEGERANDDECIMAL), hl
PLY_AKG_CHANNEL1_VOLUMESLIDE_END:
	ld a, h
    ld (PLY_AKG_CHANNEL1_GENERATEDCURRENTINVERTEDVOLUME), a
    ld c, #0x0
    ld a, (PLY_AKG_CHANNEL1_ISARPEGGIOTABLE)
    add a, a
    jr nc, PLY_AKG_CHANNEL1_ARPEGGIOTABLE_END
    ld hl, (PLY_AKG_CHANNEL1_ARPEGGIOTABLE)
    ld a, (hl)
    cp #0x80
    jr nz, PLY_AKG_CHANNEL1_ARPEGGIOTABLE_AFTERLOOPTEST
    inc hl
    ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    ld a, (hl)
PLY_AKG_CHANNEL1_ARPEGGIOTABLE_AFTERLOOPTEST:
	ld c, a
    ld a, (PLY_AKG_CHANNEL1_ARPEGGIOTABLESPEED)
    ld d, a
    ld a, (PLY_AKG_CHANNEL1_ARPEGGIOTABLECURRENTSTEP)
    inc a
    cp d
    jr c, PLY_AKG_CHANNEL1_ARPEGGIOTABLE_BEFOREEND_SAVESTEP
    inc hl
    ld (PLY_AKG_CHANNEL1_ARPEGGIOTABLE), hl
    xor a
PLY_AKG_CHANNEL1_ARPEGGIOTABLE_BEFOREEND_SAVESTEP:
	ld (PLY_AKG_CHANNEL1_ARPEGGIOTABLECURRENTSTEP), a
PLY_AKG_CHANNEL1_ARPEGGIOTABLE_END:
	ld de, #0x0
    ld a, (PLY_AKG_CHANNEL1_ISPITCHTABLE)
    add a, a
    jr nc, PLY_AKG_CHANNEL1_PITCHTABLE_END
    ld sp, (PLY_AKG_CHANNEL1_PITCHTABLE)
    pop de
    pop hl
    ld a, (PLY_AKG_CHANNEL1_PITCHTABLESPEED)
    ld b, a
    ld a, (PLY_AKG_CHANNEL1_PITCHTABLECURRENTSTEP)
    inc a
    cp b
    jr c, PLY_AKG_CHANNEL1_PITCHTABLE_BEFOREEND_SAVESTEP
    ld (PLY_AKG_CHANNEL1_PITCHTABLE), hl
    xor a
PLY_AKG_CHANNEL1_PITCHTABLE_BEFOREEND_SAVESTEP:
	ld (PLY_AKG_CHANNEL1_PITCHTABLECURRENTSTEP), a
PLY_AKG_CHANNEL1_PITCHTABLE_END:
	ld hl, (PLY_AKG_CHANNEL1_PITCH)
    ld a, (PLY_AKG_CHANNEL1_ISPITCH)
    add a, a
    jr nc, PLY_AKG_CHANNEL1_PITCH_END
    .db 0xdd
    .db 0x69
    ld bc, (PLY_AKG_CHANNEL1_PITCHTRACK)
    or a
    jp PLY_AKG_CHANNEL1_PITCHTRACKADDORSBC_16BITS
PLY_AKG_CHANNEL1_PITCHTRACKADDORSBC_16BITSRETURN:
	ld a, (PLY_AKG_CHANNEL1_PITCHTRACKDECIMALVALUE)
    ld b, a
    ld a, (PLY_AKG_CHANNEL1_PITCHTRACKDECIMALCOUNTER)
    jp PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTR
PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTRANDVALUERETURNAFTERJP:
	ld (PLY_AKG_CHANNEL1_PITCHTRACKDECIMALCOUNTER), a
    jr nc, PLY_AKG_CHANNEL1_PITCHTRACKINTEGERADDORSUBRETURN
    jp PLY_AKG_CHANNEL1_PITCHTRACKINTEGERADDORSUB
PLY_AKG_CHANNEL1_PITCHTRACKINTEGERADDORSUBRETURN:
PLY_AKG_CHANNEL1_PITCHNOCARRY:
	ld (PLY_AKG_CHANNEL1_PITCH), hl
    ld a, (PLY_AKG_CHANNEL1_GLIDEDIRECTION)
    or a
    jr z, PLY_AKG_CHANNEL1_GLIDE_END
    ld (PLY_AKG_CHANNEL1_GLIDE_SAVEHL), hl
    ld c, l
    ld b, h
    ex af, af';'
    ld a, (PLY_AKG_CHANNEL1_TRACKNOTE)
    add a, a
    ld l, a
    ex af, af';'
    ld h, #0x0
    ld sp, #PLY_AKG_PERIODTABLE
    add hl, sp
    ld sp, hl
    pop hl
    dec sp
    dec sp
    add hl, bc
    ld bc, (PLY_AKG_CHANNEL1_GLIDETOREACH)
    rra 
    jr nc, PLY_AKG_CHANNEL1_GLIDEDOWNCHECK
    or a
    sbc hl, bc
    jr nc, PLY_AKG_CHANNEL1_GLIDE_BEFOREEND
    jr PLY_AKG_CHANNEL1_GLIDEOVER
PLY_AKG_CHANNEL1_GLIDEDOWNCHECK:
	sbc hl, bc
    jr c, PLY_AKG_CHANNEL1_GLIDE_BEFOREEND
PLY_AKG_CHANNEL1_GLIDEOVER:
	ld l, c
    ld h, b
    pop bc
    or a
    sbc hl, bc
    ld (PLY_AKG_CHANNEL1_PITCH), hl
    ld a, #0x0
    ld (PLY_AKG_CHANNEL1_ISPITCH), a
    jr PLY_AKG_CHANNEL1_GLIDE_END
PLY_AKG_CHANNEL1_GLIDE_BEFOREEND:
	ld hl, (PLY_AKG_CHANNEL1_GLIDE_SAVEHL)
PLY_AKG_CHANNEL1_GLIDE_END:
	.db 0xdd
    .db 0x4d
PLY_AKG_CHANNEL1_PITCH_END:
	add hl, de
    ld (PLY_AKG_CHANNEL1_GENERATEDCURRENTPITCH), hl
    ld a, c
    ld (PLY_AKG_CHANNEL1_GENERATEDCURRENTARPNOTE), a
    ld hl, (PLY_AKG_CHANNEL2_INVERTEDVOLUMEINTEGERANDDECIMAL)
    ld a, (PLY_AKG_CHANNEL2_ISVOLUMESLIDE)
    add a, a
    jr nc, PLY_AKG_CHANNEL2_VOLUMESLIDE_END
    ld de, (PLY_AKG_CHANNEL2_VOLUMESLIDEVALUE)
    add hl, de
    bit 7, h
    jr z, PLY_AKG_CHANNEL2_VOLUMENOTOVERFLOW
    ld h, #0x0
    jr PLY_AKG_CHANNEL2_VOLUMESETAGAIN
PLY_AKG_CHANNEL2_VOLUMENOTOVERFLOW:
	ld a, h
    cp #0x10
    jr c, PLY_AKG_CHANNEL2_VOLUMESETAGAIN
    ld h, #0xf
PLY_AKG_CHANNEL2_VOLUMESETAGAIN:
	ld (PLY_AKG_CHANNEL2_INVERTEDVOLUMEINTEGERANDDECIMAL), hl
PLY_AKG_CHANNEL2_VOLUMESLIDE_END:
	ld a, h
    ld (PLY_AKG_CHANNEL2_GENERATEDCURRENTINVERTEDVOLUME), a
    ld c, #0x0
    ld a, (PLY_AKG_CHANNEL2_ISARPEGGIOTABLE)
    add a, a
    jr nc, PLY_AKG_CHANNEL2_ARPEGGIOTABLE_END
    ld hl, (PLY_AKG_CHANNEL2_ARPEGGIOTABLE)
    ld a, (hl)
    cp #0x80
    jr nz, PLY_AKG_CHANNEL2_ARPEGGIOTABLE_AFTERLOOPTEST
    inc hl
    ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    ld a, (hl)
PLY_AKG_CHANNEL2_ARPEGGIOTABLE_AFTERLOOPTEST:
	ld c, a
    ld a, (PLY_AKG_CHANNEL2_ARPEGGIOTABLESPEED)
    ld d, a
    ld a, (PLY_AKG_CHANNEL2_ARPEGGIOTABLECURRENTSTEP)
    inc a
    cp d
    jr c, PLY_AKG_CHANNEL2_ARPEGGIOTABLE_BEFOREEND_SAVESTEP
    inc hl
    ld (PLY_AKG_CHANNEL2_ARPEGGIOTABLE), hl
    xor a
PLY_AKG_CHANNEL2_ARPEGGIOTABLE_BEFOREEND_SAVESTEP:
	ld (PLY_AKG_CHANNEL2_ARPEGGIOTABLECURRENTSTEP), a
PLY_AKG_CHANNEL2_ARPEGGIOTABLE_END:
	ld de, #0x0
    ld a, (PLY_AKG_CHANNEL2_ISPITCHTABLE)
    add a, a
    jr nc, PLY_AKG_CHANNEL2_PITCHTABLE_END
    ld sp, (PLY_AKG_CHANNEL2_PITCHTABLE)
    pop de
    pop hl
    ld a, (PLY_AKG_CHANNEL2_PITCHTABLESPEED)
    ld b, a
    ld a, (PLY_AKG_CHANNEL2_PITCHTABLECURRENTSTEP)
    inc a
    cp b
    jr c, PLY_AKG_CHANNEL2_PITCHTABLE_BEFOREEND_SAVESTEP
    ld (PLY_AKG_CHANNEL2_PITCHTABLE), hl
    xor a
PLY_AKG_CHANNEL2_PITCHTABLE_BEFOREEND_SAVESTEP:
	ld (PLY_AKG_CHANNEL2_PITCHTABLECURRENTSTEP), a
PLY_AKG_CHANNEL2_PITCHTABLE_END:
	ld hl, (PLY_AKG_CHANNEL2_PITCH)
    ld a, (PLY_AKG_CHANNEL2_ISPITCH)
    add a, a
    jr nc, PLY_AKG_CHANNEL2_PITCH_END
    .db 0xdd
    .db 0x69
    ld bc, (PLY_AKG_CHANNEL2_PITCHTRACK)
    or a
    jp PLY_AKG_CHANNEL2_PITCHTRACKADDORSBC_16BITS
PLY_AKG_CHANNEL2_PITCHTRACKADDORSBC_16BITSRETURN:
	ld a, (PLY_AKG_CHANNEL2_PITCHTRACKDECIMALVALUE)
    ld b, a
    ld a, (PLY_AKG_CHANNEL2_PITCHTRACKDECIMALCOUNTER)
    jp PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTR
PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTRANDVALUERETURNAFTERJP:
	ld (PLY_AKG_CHANNEL2_PITCHTRACKDECIMALCOUNTER), a
    jr nc, PLY_AKG_CHANNEL2_PITCHTRACKINTEGERADDORSUBRETURN
    jp PLY_AKG_CHANNEL2_PITCHTRACKINTEGERADDORSUB
PLY_AKG_CHANNEL2_PITCHTRACKINTEGERADDORSUBRETURN:
PLY_AKG_CHANNEL2_PITCHNOCARRY:
	ld (PLY_AKG_CHANNEL2_PITCH), hl
    ld a, (PLY_AKG_CHANNEL2_GLIDEDIRECTION)
    or a
    jr z, PLY_AKG_CHANNEL2_GLIDE_END
    ld (PLY_AKG_CHANNEL2_GLIDE_SAVEHL), hl
    ld c, l
    ld b, h
    ex af, af';'
    ld a, (PLY_AKG_CHANNEL2_TRACKNOTE)
    add a, a
    ld l, a
    ex af, af';'
    ld h, #0x0
    ld sp, #PLY_AKG_PERIODTABLE
    add hl, sp
    ld sp, hl
    pop hl
    dec sp
    dec sp
    add hl, bc
    ld bc, (PLY_AKG_CHANNEL2_GLIDETOREACH)
    rra 
    jr nc, PLY_AKG_CHANNEL2_GLIDEDOWNCHECK
    or a
    sbc hl, bc
    jr nc, PLY_AKG_CHANNEL2_GLIDE_BEFOREEND
    jr PLY_AKG_CHANNEL2_GLIDEOVER
PLY_AKG_CHANNEL2_GLIDEDOWNCHECK:
	sbc hl, bc
    jr c, PLY_AKG_CHANNEL2_GLIDE_BEFOREEND
PLY_AKG_CHANNEL2_GLIDEOVER:
	ld l, c
    ld h, b
    pop bc
    or a
    sbc hl, bc
    ld (PLY_AKG_CHANNEL2_PITCH), hl
    ld a, #0x0
    ld (PLY_AKG_CHANNEL2_ISPITCH), a
    jr PLY_AKG_CHANNEL2_GLIDE_END
PLY_AKG_CHANNEL2_GLIDE_BEFOREEND:
	ld hl, (PLY_AKG_CHANNEL2_GLIDE_SAVEHL)
PLY_AKG_CHANNEL2_GLIDE_END:
	.db 0xdd
    .db 0x4d
PLY_AKG_CHANNEL2_PITCH_END:
	add hl, de
    ld (PLY_AKG_CHANNEL2_GENERATEDCURRENTPITCH), hl
    ld a, c
    ld (PLY_AKG_CHANNEL2_GENERATEDCURRENTARPNOTE), a
    ld hl, (PLY_AKG_CHANNEL3_INVERTEDVOLUMEINTEGERANDDECIMAL)
    ld a, (PLY_AKG_CHANNEL3_ISVOLUMESLIDE)
    add a, a
    jr nc, PLY_AKG_CHANNEL3_VOLUMESLIDE_END
    ld de, (PLY_AKG_CHANNEL3_VOLUMESLIDEVALUE)
    add hl, de
    bit 7, h
    jr z, PLY_AKG_CHANNEL3_VOLUMENOTOVERFLOW
    ld h, #0x0
    jr PLY_AKG_CHANNEL3_VOLUMESETAGAIN
PLY_AKG_CHANNEL3_VOLUMENOTOVERFLOW:
	ld a, h
    cp #0x10
    jr c, PLY_AKG_CHANNEL3_VOLUMESETAGAIN
    ld h, #0xf
PLY_AKG_CHANNEL3_VOLUMESETAGAIN:
	ld (PLY_AKG_CHANNEL3_INVERTEDVOLUMEINTEGERANDDECIMAL), hl
PLY_AKG_CHANNEL3_VOLUMESLIDE_END:
	ld a, h
    ld (PLY_AKG_CHANNEL3_GENERATEDCURRENTINVERTEDVOLUME), a
    ld c, #0x0
    ld a, (PLY_AKG_CHANNEL3_ISARPEGGIOTABLE)
    add a, a
    jr nc, PLY_AKG_CHANNEL3_ARPEGGIOTABLE_END
    ld hl, (PLY_AKG_CHANNEL3_ARPEGGIOTABLE)
    ld a, (hl)
    cp #0x80
    jr nz, PLY_AKG_CHANNEL3_ARPEGGIOTABLE_AFTERLOOPTEST
    inc hl
    ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    ld a, (hl)
PLY_AKG_CHANNEL3_ARPEGGIOTABLE_AFTERLOOPTEST:
	ld c, a
    ld a, (PLY_AKG_CHANNEL3_ARPEGGIOTABLESPEED)
    ld d, a
    ld a, (PLY_AKG_CHANNEL3_ARPEGGIOTABLECURRENTSTEP)
    inc a
    cp d
    jr c, PLY_AKG_CHANNEL3_ARPEGGIOTABLE_BEFOREEND_SAVESTEP
    inc hl
    ld (PLY_AKG_CHANNEL3_ARPEGGIOTABLE), hl
    xor a
PLY_AKG_CHANNEL3_ARPEGGIOTABLE_BEFOREEND_SAVESTEP:
	ld (PLY_AKG_CHANNEL3_ARPEGGIOTABLECURRENTSTEP), a
PLY_AKG_CHANNEL3_ARPEGGIOTABLE_END:
	ld de, #0x0
    ld a, (PLY_AKG_CHANNEL3_ISPITCHTABLE)
    add a, a
    jr nc, PLY_AKG_CHANNEL3_PITCHTABLE_END
    ld sp, (PLY_AKG_CHANNEL3_PITCHTABLE)
    pop de
    pop hl
    ld a, (PLY_AKG_CHANNEL3_PITCHTABLESPEED)
    ld b, a
    ld a, (PLY_AKG_CHANNEL3_PITCHTABLECURRENTSTEP)
    inc a
    cp b
    jr c, PLY_AKG_CHANNEL3_PITCHTABLE_BEFOREEND_SAVESTEP
    ld (PLY_AKG_CHANNEL3_PITCHTABLE), hl
    xor a
PLY_AKG_CHANNEL3_PITCHTABLE_BEFOREEND_SAVESTEP:
	ld (PLY_AKG_CHANNEL3_PITCHTABLECURRENTSTEP), a
PLY_AKG_CHANNEL3_PITCHTABLE_END:
	ld hl, (PLY_AKG_CHANNEL3_PITCH)
    ld a, (PLY_AKG_CHANNEL3_ISPITCH)
    add a, a
    jr nc, PLY_AKG_CHANNEL3_PITCH_END
    .db 0xdd
    .db 0x69
    ld bc, (PLY_AKG_CHANNEL3_PITCHTRACK)
    or a
    jp PLY_AKG_CHANNEL3_PITCHTRACKADDORSBC_16BITS
PLY_AKG_CHANNEL3_PITCHTRACKADDORSBC_16BITSRETURN:
	ld a, (PLY_AKG_CHANNEL3_PITCHTRACKDECIMALVALUE)
    ld b, a
    ld a, (PLY_AKG_CHANNEL3_PITCHTRACKDECIMALCOUNTER)
    jp PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTR
PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTRANDVALUERETURNAFTERJP:
	ld (PLY_AKG_CHANNEL3_PITCHTRACKDECIMALCOUNTER), a
    jr nc, PLY_AKG_CHANNEL3_PITCHTRACKINTEGERADDORSUBRETURN
    jp PLY_AKG_CHANNEL3_PITCHTRACKINTEGERADDORSUB
PLY_AKG_CHANNEL3_PITCHTRACKINTEGERADDORSUBRETURN:
PLY_AKG_CHANNEL3_PITCHNOCARRY:
	ld (PLY_AKG_CHANNEL3_PITCH), hl
    ld a, (PLY_AKG_CHANNEL3_GLIDEDIRECTION)
    or a
    jr z, PLY_AKG_CHANNEL3_GLIDE_END
    ld (PLY_AKG_CHANNEL3_GLIDE_SAVEHL), hl
    ld c, l
    ld b, h
    ex af, af';'
    ld a, (PLY_AKG_CHANNEL3_TRACKNOTE)
    add a, a
    ld l, a
    ex af, af';'
    ld h, #0x0
    ld sp, #PLY_AKG_PERIODTABLE
    add hl, sp
    ld sp, hl
    pop hl
    dec sp
    dec sp
    add hl, bc
    ld bc, (PLY_AKG_CHANNEL3_GLIDETOREACH)
    rra 
    jr nc, PLY_AKG_CHANNEL3_GLIDEDOWNCHECK
    or a
    sbc hl, bc
    jr nc, PLY_AKG_CHANNEL3_GLIDE_BEFOREEND
    jr PLY_AKG_CHANNEL3_GLIDEOVER
PLY_AKG_CHANNEL3_GLIDEDOWNCHECK:
	sbc hl, bc
    jr c, PLY_AKG_CHANNEL3_GLIDE_BEFOREEND
PLY_AKG_CHANNEL3_GLIDEOVER:
	ld l, c
    ld h, b
    pop bc
    or a
    sbc hl, bc
    ld (PLY_AKG_CHANNEL3_PITCH), hl
    ld a, #0x0
    ld (PLY_AKG_CHANNEL3_ISPITCH), a
    jr PLY_AKG_CHANNEL3_GLIDE_END
PLY_AKG_CHANNEL3_GLIDE_BEFOREEND:
	ld hl, (PLY_AKG_CHANNEL3_GLIDE_SAVEHL)
PLY_AKG_CHANNEL3_GLIDE_END:
	.db 0xdd
    .db 0x4d
PLY_AKG_CHANNEL3_PITCH_END:
	add hl, de
    ld (PLY_AKG_CHANNEL3_GENERATEDCURRENTPITCH), hl
    ld a, c
    ld (PLY_AKG_CHANNEL3_GENERATEDCURRENTARPNOTE), a
    ld sp, (PLY_AKG_SAVESP)
    ld hl, (PLY_AKG_CHANNEL1_GENERATEDCURRENTPITCH)
    ld a, (PLY_AKG_CHANNEL1_TRACKNOTE)
    ld e, a
    ld a, (PLY_AKG_CHANNEL1_GENERATEDCURRENTARPNOTE)
    add a, e
    ld e, a
    ld d, #0x0
    exx
    ld a, (PLY_AKG_CHANNEL1_INSTRUMENTSTEP)
    .db 0xfd
    .db 0x6f
    ld hl, (PLY_AKG_CHANNEL1_PTINSTRUMENT)
    ld a, (PLY_AKG_CHANNEL1_GENERATEDCURRENTINVERTEDVOLUME)
    ld e, a
    ld d, #0xe0
    call PLY_AKG_READINSTRUMENTCELL
    ld a, (PLY_AKG_CHANNEL1_INSTRUMENTSPEED)
    ld b, a
    .db 0xfd
    .db 0x7d
    inc a
    cp b
    jr c, PLY_AKG_CHANNEL1_SETINSTRUMENTSTEP
    ld (PLY_AKG_CHANNEL1_PTINSTRUMENT), hl
    xor a
PLY_AKG_CHANNEL1_SETINSTRUMENTSTEP:
	ld (PLY_AKG_CHANNEL1_INSTRUMENTSTEP), a
    ld a, e
    ld (PLY_AKG_PSGREG8), a
    srl d
    exx
    ld (PLY_AKG_PSGREG01_INSTR), hl
    ld hl, (PLY_AKG_CHANNEL2_GENERATEDCURRENTPITCH)
    ld a, (PLY_AKG_CHANNEL2_TRACKNOTE)
    ld e, a
    ld a, (PLY_AKG_CHANNEL2_GENERATEDCURRENTARPNOTE)
    add a, e
    ld e, a
    ld d, #0x0
    exx
    ld a, (PLY_AKG_CHANNEL2_INSTRUMENTSTEP)
    .db 0xfd
    .db 0x6f
    ld hl, (PLY_AKG_CHANNEL2_PTINSTRUMENT)
    ld a, (PLY_AKG_CHANNEL2_GENERATEDCURRENTINVERTEDVOLUME)
    ld e, a
    call PLY_AKG_READINSTRUMENTCELL
    ld a, (PLY_AKG_CHANNEL2_INSTRUMENTSPEED)
    ld b, a
    .db 0xfd
    .db 0x7d
    inc a
    cp b
    jr c, PLY_AKG_CHANNEL2_SETINSTRUMENTSTEP
    ld (PLY_AKG_CHANNEL2_PTINSTRUMENT), hl
    xor a
PLY_AKG_CHANNEL2_SETINSTRUMENTSTEP:
	ld (PLY_AKG_CHANNEL2_INSTRUMENTSTEP), a
    ld a, e
    ld (PLY_AKG_PSGREG9_10_INSTR), a
    scf
    rr d
    exx
    ld (PLY_AKG_PSGREG23_INSTR), hl
    ld hl, (PLY_AKG_CHANNEL3_GENERATEDCURRENTPITCH)
    ld a, (PLY_AKG_CHANNEL3_TRACKNOTE)
    ld e, a
    ld a, (PLY_AKG_CHANNEL3_GENERATEDCURRENTARPNOTE)
    add a, e
    ld e, a
    ld d, #0x0
    exx
    ld a, (PLY_AKG_CHANNEL3_INSTRUMENTSTEP)
    .db 0xfd
    .db 0x6f
    ld hl, (PLY_AKG_CHANNEL3_PTINSTRUMENT)
    ld a, (PLY_AKG_CHANNEL3_GENERATEDCURRENTINVERTEDVOLUME)
    ld e, a
    call PLY_AKG_READINSTRUMENTCELL
    ld a, (PLY_AKG_CHANNEL3_INSTRUMENTSPEED)
    ld b, a
    .db 0xfd
    .db 0x7d
    inc a
    cp b
    jr c, PLY_AKG_CHANNEL3_SETINSTRUMENTSTEP
    ld (PLY_AKG_CHANNEL3_PTINSTRUMENT), hl
    xor a
PLY_AKG_CHANNEL3_SETINSTRUMENTSTEP:
	ld (PLY_AKG_CHANNEL3_INSTRUMENTSTEP), a
    ld a, e
    ld (PLY_AKG_PSGREG10), a
    ld a, d
    exx
    ld (PLY_AKG_PSGREG45_INSTR), hl
    call PLY_AKG_PLAYSOUNDEFFECTSSTREAM
PLY_AKG_SENDPSGREGISTERS:
	ld b, a
    ld a, #0x7
    out (0xa0), a
    ld a, b
    out (0xa1), a
    ld hl, (PLY_AKG_PSGREG01_INSTR)
    xor a
    out (0xa0), a
    ld a, l
    out (0xa1), a
    ld a, #0x1
    out (0xa0), a
    ld a, h
    out (0xa1), a
    ld hl, (PLY_AKG_PSGREG23_INSTR)
    ld a, #0x2
    out (0xa0), a
    ld a, l
    out (0xa1), a
    ld a, #0x3
    out (0xa0), a
    ld a, h
    out (0xa1), a
    ld hl, (PLY_AKG_PSGREG45_INSTR)
    ld a, #0x4
    out (0xa0), a
    ld a, l
    out (0xa1), a
    ld a, #0x5
    out (0xa0), a
    ld a, h
    out (0xa1), a
    ld hl, (PLY_AKG_PSGREG6_8_INSTR)
    ld a, #0x6
    out (0xa0), a
    ld a, l
    out (0xa1), a
    ld a, #0x8
    out (0xa0), a
    ld a, h
    out (0xa1), a
    ld hl, (PLY_AKG_PSGREG9_10_INSTR)
    ld a, #0x9
    out (0xa0), a
    ld a, l
    out (0xa1), a
    ld a, #0xa
    out (0xa0), a
    ld a, h
    out (0xa1), a
    ld hl, (PLY_AKG_PSGHARDWAREPERIOD_INSTR)
    ld a, #0xb
    out (0xa0), a
    ld a, l
    out (0xa1), a
    ld a, #0xc
    out (0xa0), a
    ld a, h
    out (0xa1), a
    ld a, #0xd
    out (0xa0), a
    ld a, (PLY_AKG_PSGREG13_INSTR)
    ld l, a
    ld a, (PLY_AKG_RETRIG)
    ld h, a
    ld a, (PLY_AKG_PSGREG13_OLDVALUE)
    or h
    cp l
    jr z, PLY_AKG_PSGREG13_END
    ld a, l
    ld (PLY_AKG_PSGREG13_OLDVALUE), a
    out (0xa1), a
    xor a
    ld (PLY_AKG_RETRIG), a
PLY_AKG_PSGREG13_END:
	ld sp, (PLY_AKG_SAVESP)
    ret 
PLY_AKG_CHANNEL1_MAYBEEFFECTS:
	ld (PLY_AKG_CHANNEL1_WAITCOUNTER), a
    bit 6, c
    jp z, PLY_AKG_CHANNEL1_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL1_READEFFECTS:
	ld iy, #PLY_AKG_CHANNEL1_SOUNDSTREAM_RELATIVEMODIFIERADDRESS
    ld ix, #PLY_AKG_CHANNEL1_SOUNDSTREAM_RELATIVEMODIFIERADDRESS
    ld de, #PLY_AKG_CHANNEL1_BEFOREEND_STORECELLPOINTER
    jr PLY_AKG_CHANNEL3_READEFFECTSEND
PLY_AKG_CHANNEL1_READEFFECTSEND:
PLY_AKG_CHANNEL2_MAYBEEFFECTS:
	ld (PLY_AKG_CHANNEL2_WAITCOUNTER), a
    bit 6, c
    jp z, PLY_AKG_CHANNEL2_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL2_READEFFECTS:
	ld iy, #PLY_AKG_CHANNEL2_PLAYINSTRUMENT_RELATIVEMODIFIERADDRESS
    ld ix, #PLY_AKG_CHANNEL2_PLAYINSTRUMENT_RELATIVEMODIFIERADDRESS
    ld de, #PLY_AKG_CHANNEL2_BEFOREEND_STORECELLPOINTER
    jr PLY_AKG_CHANNEL3_READEFFECTSEND
PLY_AKG_CHANNEL2_READEFFECTSEND:
PLY_AKG_CHANNEL3_MAYBEEFFECTS:
	ld (PLY_AKG_CHANNEL3_WAITCOUNTER), a
    bit 6, c
    jp z, PLY_AKG_CHANNEL3_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL3_READEFFECTS:
	ld iy, #PLY_AKG_CHANNEL3_SOUNDSTREAM_RELATIVEMODIFIERADDRESS
    ld ix, #PLY_AKG_CHANNEL3_SOUNDSTREAM_RELATIVEMODIFIERADDRESS
    ld de, #PLY_AKG_CHANNEL3_BEFOREEND_STORECELLPOINTER
PLY_AKG_CHANNEL3_READEFFECTSEND:
PLY_AKG_CHANNEL_READEFFECTS:
	ld (PLY_AKG_CHANNEL_READEFFECTS_ENDJUMPINSTRANDADDRESS+1), de
    ex de, hl
    ld a, (de)
    inc de
    sla a
    jr c, PLY_AKG_CHANNEL_READEFFECTS_RELATIVEADDRESS
    exx
    ld l, a
    ld h, #0x0
    ld de, (PLY_AKG_CHANNEL_READEFFECTS_EFFECTBLOCKS1)
    add hl, de
    ld e, (hl)
    inc hl
    ld d, (hl)
PLY_AKG_CHANNEL_RE_EFFECTADDRESSKNOWN:
	ld a, (de)
    inc de
    ld (PLY_AKG_CHANNEL_RE_READNEXTEFFECTINBLOCK), a
    and #0xfe
    ld l, a
    ld h, #0x0
    ld sp, #PLY_AKG_EFFECTTABLE
    add hl, sp
    ld sp, hl
    ret 
PLY_AKG_CHANNEL_RE_EFFECTRETURN:
	ld a, (PLY_AKG_CHANNEL_RE_READNEXTEFFECTINBLOCK)
    rra 
    jr c, PLY_AKG_CHANNEL_RE_EFFECTADDRESSKNOWN
    exx
    ex de, hl
    jp PLY_AKG_CHANNEL_READEFFECTS_ENDJUMPINSTRANDADDRESS
PLY_AKG_CHANNEL_READEFFECTS_RELATIVEADDRESS:
	srl a
    exx
    ld h, a
    exx
    ld a, (de)
    inc de
    exx
    ld l, a
    ld de, (PLY_AKG_CHANNEL_READEFFECTS_EFFECTBLOCKS1)
    add hl, de
    jr PLY_AKG_CHANNEL_RE_EFFECTADDRESSKNOWN
PLY_AKG_READINSTRUMENTCELL:
	ld a, (hl)
    inc hl
    ld b, a
    rra 
    jp c, PLY_AKG_S_OR_H_OR_SAH_OR_ENDWITHLOOP
    rra 
    jp c, PLY_AKG_STH_OR_ENDWITHOUTLOOP
    rra 
    jr c, PLY_AKG_HARDTOSOFT
PLY_AKG_NOSOFTNOHARD:
	and #0xf
    sub e
    jr nc, PLY_AKG_NOSOFTNOHARD+6
    xor a
    ld e, a
    rl b
    jr nc, PLY_AKG_NSNH_NONOISE
    ld a, (hl)
    inc hl
    ld (PLY_AKG_PSGREG6_8_INSTR), a
    set 2, d
    res 5, d
    ret 
PLY_AKG_NSNH_NONOISE:
	set 2, d
    ret 
PLY_AKG_SOFT:
	and #0xf
    sub e
    jr nc, PLY_AKG_SOFTONLY_HARDONLY_TESTSIMPLE_COMMON-1
    xor a
    ld e, a
PLY_AKG_SOFTONLY_HARDONLY_TESTSIMPLE_COMMON:
	rl b
    jr nc, PLY_AKG_S_NOTSIMPLE
    ld c, #0x0
    jr PLY_AKG_S_AFTERSIMPLETEST
PLY_AKG_S_NOTSIMPLE:
	ld b, (hl)
    ld c, b
    inc hl
PLY_AKG_S_AFTERSIMPLETEST:
	call PLY_AKG_S_OR_H_CHECKIFSIMPLEFIRST_CALCULATEPERIOD
    ld a, c
    and #0x1f
    ret z
    ld (PLY_AKG_PSGREG6_8_INSTR), a
    res 5, d
    ret 
PLY_AKG_HARDTOSOFT:
	call PLY_AKG_STOH_HTOS_SANDH_COMMON
    exx
    ld bc, #PLY_AKG_HS_JUMPRATIO
    add a, c
    ld c, a
    ld a, b
    adc a, #0x0
    ld b, a
    ld (PLY_AKG_TEMPPLAYINSTRUMENTJUMPINSTRANDADDRESS+1), bc
    exx
    ld a, b
    exx
    ld (PLY_AKG_PSGHARDWAREPERIOD_INSTR), hl
    jp PLY_AKG_TEMPPLAYINSTRUMENTJUMPINSTRANDADDRESS
PLY_AKG_HS_JUMPRATIO:
	sla l
    rl h
    sla l
    rl h
    sla l
    rl h
    sla l
    rl h
    sla l
    rl h
    sla l
    rl h
    sla l
    rl h
    rla 
    jr nc, PLY_AKG_SH_NOSOFTWAREPITCHSHIFT
    exx
    ld a, (hl)
    inc hl
    exx
    add a, l
    ld l, a
    exx
    ld a, (hl)
    inc hl
    exx
    adc a, h
    ld h, a
PLY_AKG_SH_NOSOFTWAREPITCHSHIFT:
	exx
    ret 
PLY_AKG_ENDWITHOUTLOOP:
	ld hl, (PLY_AKG_EMPTYINSTRUMENTDATAPT)
    inc hl
    xor a
    ld b, a
    jp PLY_AKG_NOSOFTNOHARD
PLY_AKG_STH_OR_ENDWITHOUTLOOP:
	rra 
    jr c, PLY_AKG_ENDWITHOUTLOOP
    call PLY_AKG_STOH_HTOS_SANDH_COMMON
    exx
    ld bc, #PLY_AKG_SH_JUMPRATIO
    add a, c
    ld c, a
    ld a, b
    adc a, #0x0
    ld b, a
    ld (PLY_AKG_TEMPPLAYINSTRUMENTJUMPINSTRANDADDRESS+1), bc
    exx
    ld a, b
    exx
    ld e, l
    ld d, h
    jp PLY_AKG_TEMPPLAYINSTRUMENTJUMPINSTRANDADDRESS
PLY_AKG_SH_JUMPRATIO:
	srl h
    rr l
    srl h
    rr l
    srl h
    rr l
    srl h
    rr l
    srl h
    rr l
    srl h
    rr l
    srl h
    rr l
    jr nc, PLY_AKG_SH_JUMPRATIOEND
    inc hl
PLY_AKG_SH_JUMPRATIOEND:
	rla 
    jr nc, PLY_AKG_SH_NOHARDWAREPITCHSHIFT
    exx
    ld a, (hl)
    inc hl
    exx
    add a, l
    ld l, a
    exx
    ld a, (hl)
    inc hl
    exx
    adc a, h
    ld h, a
PLY_AKG_SH_NOHARDWAREPITCHSHIFT:
	ld (PLY_AKG_PSGHARDWAREPERIOD_INSTR), hl
    ex de, hl
    exx
    ret 
PLY_AKG_S_OR_H_OR_SAH_OR_ENDWITHLOOP:
	rra 
    jr c, PLY_AKG_H_OR_ENDWITHLOOP
    rra 
    jp nc, PLY_AKG_SOFT
    exx
    push hl
    push de
    exx
    call PLY_AKG_STOH_HTOS_SANDH_COMMON
    exx
    ld (PLY_AKG_PSGHARDWAREPERIOD_INSTR), hl
    pop de
    pop hl
    exx
    rl b
    jp PLY_AKG_S_OR_H_CHECKIFSIMPLEFIRST_CALCULATEPERIOD
PLY_AKG_H_OR_ENDWITHLOOP:
	rra 
    jr c, PLY_AKG_ENDWITHLOOP
    ld e, #0x10
    rra 
    jr nc, PLY_AKG_H_AFTERRETRIG
    ld c, a
    .db 0xfd
    .db 0x7d
    or a
    jr nz, PLY_AKG_H_RETRIGEND
    ld a, e
    ld (PLY_AKG_RETRIG), a
PLY_AKG_H_RETRIGEND:
	ld a, c
PLY_AKG_H_AFTERRETRIG:
	and #0x7
    add a, #0x8
    ld (PLY_AKG_PSGREG13_INSTR), a
    call PLY_AKG_SOFTONLY_HARDONLY_TESTSIMPLE_COMMON
    exx
    ld (PLY_AKG_PSGHARDWAREPERIOD_INSTR), hl
    exx
    set 2, d
    ret 
PLY_AKG_ENDWITHLOOP:
	ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    jp PLY_AKG_READINSTRUMENTCELL
PLY_AKG_S_OR_H_CHECKIFSIMPLEFIRST_CALCULATEPERIOD:
	jr nc, PLY_AKG_S_OR_H_NEXTBYTE
    exx
    ex de, hl
    add hl, hl
    ld bc, #PLY_AKG_PERIODTABLE
    add hl, bc
    ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    add hl, de
    exx
    rl b
    rl b
    rl b
    ret 
PLY_AKG_S_OR_H_NEXTBYTE:
	rl b
    jr c, PLY_AKG_S_OR_H_FORCEDPERIOD
    rl b
    jr nc, PLY_AKG_S_OR_H_AFTERARPEGGIO
    ld a, (hl)
    inc hl
    exx
    add a, e
    ld e, a
    exx
PLY_AKG_S_OR_H_AFTERARPEGGIO:
	rl b
    jr nc, PLY_AKG_S_OR_H_AFTERPITCH
    ld a, (hl)
    inc hl
    exx
    add a, l
    ld l, a
    exx
    ld a, (hl)
    inc hl
    exx
    adc a, h
    ld h, a
    exx
PLY_AKG_S_OR_H_AFTERPITCH:
	exx
    ex de, hl
    add hl, hl
    ld bc, #PLY_AKG_PERIODTABLE
    add hl, bc
    ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    add hl, de
    exx
    ret 
PLY_AKG_S_OR_H_FORCEDPERIOD:
	ld a, (hl)
    inc hl
    exx
    ld l, a
    exx
    ld a, (hl)
    inc hl
    exx
    ld h, a
    exx
    rl b
    rl b
    ret 
PLY_AKG_STOH_HTOS_SANDH_COMMON:
	ld e, #0x10
    rra 
    jr nc, PLY_AKG_SHOHS_AFTERRETRIG
    ld c, a
    .db 0xfd
    .db 0x7d
    or a
    jr nz, PLY_AKG_SHOHS_RETRIGEND
    dec a
    ld (PLY_AKG_RETRIG), a
PLY_AKG_SHOHS_RETRIGEND:
	ld a, c
PLY_AKG_SHOHS_AFTERRETRIG:
	and #0x7
    add a, #0x8
    ld (PLY_AKG_PSGREG13_INSTR), a
    rl b
    jr nc, PLY_AKG_SHOHS_AFTERNOISE
    ld a, (hl)
    inc hl
    ld (PLY_AKG_PSGREG6_8_INSTR), a
    res 5, d
PLY_AKG_SHOHS_AFTERNOISE:
	ld c, (hl)
    ld b, c
    inc hl
    rl b
    call PLY_AKG_S_OR_H_CHECKIFSIMPLEFIRST_CALCULATEPERIOD
    ld a, c
    rla 
    rla 
    and #0x1c
    ret 
PLY_AKG_EFFECTTABLE:
	.dw PLY_AKG_EFFECT_RESETFULLVOLUME
    .dw PLY_AKG_EFFECT_RESET
    .dw PLY_AKG_EFFECT_VOLUME
    .dw PLY_AKG_EFFECT_ARPEGGIOTABLE
    .dw PLY_AKG_EFFECT_ARPEGGIOTABLESTOP
    .dw PLY_AKG_EFFECT_PITCHTABLE
    .dw PLY_AKG_EFFECT_PITCHTABLESTOP
    .dw PLY_AKG_EFFECT_VOLUMESLIDE
    .dw PLY_AKG_EFFECT_VOLUMESLIDESTOP
    .dw PLY_AKG_EFFECT_PITCHUP
    .dw PLY_AKG_EFFECT_PITCHDOWN
    .dw PLY_AKG_EFFECT_PITCHSTOP
    .dw PLY_AKG_EFFECT_GLIDEWITHNOTE
    .dw PLY_AKG_EFFECT_GLIDE_READSPEED
    .dw PLY_AKG_EFFECT_LEGATO
    .dw PLY_AKG_EFFECT_FORCEINSTRUMENTSPEED
    .dw PLY_AKG_EFFECT_FORCEARPEGGIOSPEED
    .dw PLY_AKG_EFFECT_FORCEPITCHSPEED
PLY_AKG_EFFECT_RESETFULLVOLUME:
	xor a
    jr PLY_AKG_EFFECT_RESETVOLUME_AFTERREADING
PLY_AKG_EFFECT_RESET:
	ld a, (de)
    inc de
PLY_AKG_EFFECT_RESETVOLUME_AFTERREADING:
	ld +38(iy), a
    xor a
    ld +39(iy), a
    ld +40(iy), a
    ld a, #0x0
    ld +5(iy), a
    ld +4(iy), a
    ld +3(iy), a
    ld +2(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_VOLUME:
	ld a, (de)
    inc de
    ld +38(iy), a
    ld +2(iy), #0x0
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_ARPEGGIOTABLE:
	ld a, (de)
    inc de
    ld l, a
    ld h, #0x0
    add hl, hl
    ld bc, (PLY_AKG_ARPEGGIOSTABLE)
    add hl, bc
    ld c, (hl)
    inc hl
    ld b, (hl)
    inc hl
    ld a, (bc)
    inc bc
    ld +12(iy), a
    ld +11(iy), a
    ld +23(iy), c
    ld +24(iy), b
    ld +25(iy), c
    ld +26(iy), b
    ld +3(iy), #0xff
    xor a
    ld +9(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_ARPEGGIOTABLESTOP:
	ld +3(iy), #0x0
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_PITCHTABLE:
	ld a, (de)
    inc de
    ld l, a
    ld h, #0x0
    add hl, hl
    ld bc, (PLY_AKG_PITCHESTABLE)
    add hl, bc
    ld c, (hl)
    inc hl
    ld b, (hl)
    inc hl
    ld a, (bc)
    inc bc
    ld +15(iy), a
    ld +14(iy), a
    ld +29(iy), c
    ld +30(iy), b
    ld +31(iy), c
    ld +32(iy), b
    ld +4(iy), #0xff
    xor a
    ld +13(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_PITCHTABLESTOP:
	ld +4(iy), #0x0
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_VOLUMESLIDE:
	ld a, (de)
    inc de
    ld +45(iy), a
    ld a, (de)
    inc de
    ld +46(iy), a
    ld +2(iy), #0xff
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_VOLUMESLIDESTOP:
	ld +2(iy), #0x0
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_PITCHDOWN:
	ld +58(iy), #0x0
    ld +59(iy), #0x9
    ld +51(iy), #0xc6
    ld +63(iy), #0x23
PLY_AKG_EFFECT_PITCHUPDOWN_COMMON:
	ld +5(iy), #0xff
    ld +19(iy), #0x0
    ld a, (de)
    inc de
    ld +52(iy), a
    ld a, (de)
    inc de
    ld +27(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_PITCHUP:
	ld +58(iy), #0xed
    ld +59(iy), #0x42
    ld +51(iy), #0xd6
    ld +63(iy), #0x2b
    jr PLY_AKG_EFFECT_PITCHUPDOWN_COMMON
PLY_AKG_EFFECT_PITCHSTOP:
	ld +5(iy), #0x0
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_GLIDEWITHNOTE:
	ld a, (de)
    inc de
    ld (PLY_AKG_EFFECT_GLIDEWITHNOTESAVEDE), de
    add a, a
    ld l, a
    ld h, #0x0
    ld bc, #PLY_AKG_PERIODTABLE
    add hl, bc
    ld sp, hl
    pop de
    ld +47(iy), e
    ld +48(iy), d
    ld a, +18(ix)
    add a, a
    ld l, a
    ld h, #0x0
    add hl, bc
    ld sp, hl
    pop hl
    ld c, +39(iy)
    ld b, +40(iy)
    add hl, bc
    or a
    sbc hl, de
    ld de, (PLY_AKG_EFFECT_GLIDEWITHNOTESAVEDE)
    jr c, PLY_AKG_EFFECT_GLIDE_PITCHDOWN
    ld +19(iy), #0x1
    ld +58(iy), #0xed
    ld +59(iy), #0x42
    ld +51(iy), #0xd6
    ld +63(iy), #0x2b
PLY_AKG_EFFECT_GLIDE_READSPEED:
PLY_AKG_EFFECT_GLIDESPEED:
	ld a, (de)
    inc de
    ld +52(iy), a
    ld a, (de)
    inc de
    ld +27(iy), a
    ld a, #0xff
    ld +5(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_GLIDE_PITCHDOWN:
	ld +19(iy), #0x2
    ld +58(iy), #0x0
    ld +59(iy), #0x9
    ld +51(iy), #0xc6
    ld +63(iy), #0x23
    jr PLY_AKG_EFFECT_GLIDE_READSPEED
PLY_AKG_EFFECT_LEGATO:
	ld a, (de)
    inc de
    ld +18(ix), a
    ld a, #0x0
    ld +5(iy), a
    xor a
    ld +39(iy), a
    ld +40(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_FORCEINSTRUMENTSPEED:
	ld a, (de)
    inc de
    ld +7(ix), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_FORCEARPEGGIOSPEED:
	ld a, (de)
    inc de
    ld +12(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_EFFECT_FORCEPITCHSPEED:
	ld a, (de)
    inc de
    ld +15(iy), a
    jp PLY_AKG_CHANNEL_RE_EFFECTRETURN
PLY_AKG_PERIODTABLE:
	.dw 0x1a7a
    .dw 0x18fe
    .dw 0x1797
    .dw 0x1644
    .dw 0x1504
    .dw 0x13d6
    .dw 0x12b9
    .dw 0x11ac
    .dw 0x10ae
    .dw 0xfbe
    .dw 0xedc
    .dw 0xe07
    .dw 0xd3d
    .dw 0xc7f
    .dw 0xbcb
    .dw 0xb22
    .dw 0xa82
    .dw 0x9eb
    .dw 0x95d
    .dw 0x8d6
    .dw 0x857
    .dw 0x7df
    .dw 0x76e
    .dw 0x703
    .dw 0x69f
    .dw 0x63f
    .dw 0x5e6
    .dw 0x591
    .dw 0x541
    .dw 0x4f6
    .dw 0x4ae
    .dw 0x46b
    .dw 0x42c
    .dw 0x3f0
    .dw 0x3b7
    .dw 0x382
    .dw 0x34f
    .dw 0x320
    .dw 0x2f3
    .dw 0x2c8
    .dw 0x2a1
    .dw 0x27b
    .dw 0x257
    .dw 0x236
    .dw 0x216
    .dw 0x1f8
    .dw 0x1dc
    .dw 0x1c1
    .dw 0x1a8
    .dw 0x190
    .dw 0x179
    .dw 0x164
    .dw 0x150
    .dw 0x13d
    .dw 0x12c
    .dw 0x11b
    .dw 0x10b
    .dw 0xfc
    .dw 0xee
    .dw 0xe0
    .dw 0xd4
    .dw 0xc8
    .dw 0xbd
    .dw 0xb2
    .dw 0xa8
    .dw 0x9f
    .dw 0x96
    .dw 0x8d
    .dw 0x85
    .dw 0x7e
    .dw 0x77
    .dw 0x70
    .dw 0x6a
    .dw 0x64
    .dw 0x5e
    .dw 0x59
    .dw 0x54
    .dw 0x4f
    .dw 0x4b
    .dw 0x47
    .dw 0x43
    .dw 0x3f
    .dw 0x3b
    .dw 0x38
    .dw 0x35
    .dw 0x32
    .dw 0x2f
    .dw 0x2d
    .dw 0x2a
    .dw 0x28
    .dw 0x25
    .dw 0x23
    .dw 0x21
    .dw 0x1f
    .dw 0x1e
    .dw 0x1c
    .dw 0x1a
    .dw 0x19
    .dw 0x18
    .dw 0x16
    .dw 0x15
    .dw 0x14
    .dw 0x13
    .dw 0x12
    .dw 0x11
    .dw 0x10
    .dw 0xf
    .dw 0xe
    .dw 0xd
    .dw 0xc
    .dw 0xc
    .dw 0xb
    .dw 0xb
    .dw 0xa
    .dw 0x9
    .dw 0x9
    .dw 0x8
    .dw 0x8
    .dw 0x7
    .dw 0x7
    .dw 0x7
    .dw 0x6
    .dw 0x6
    .dw 0x6
    .dw 0x5
    .dw 0x5
    .dw 0x5
    .dw 0x4
PLY_AKG_ARPEGGIOSTABLE = 0xf011
PLY_AKG_BASENOTEINDEX = 0xf002
PLY_AKG_CHANNEL1_ARPEGGIOBASESPEED = 0xf03c
PLY_AKG_CHANNEL1_ARPEGGIOTABLE = 0xf048
PLY_AKG_CHANNEL1_ARPEGGIOTABLEBASE = 0xf04a
PLY_AKG_CHANNEL1_ARPEGGIOTABLECURRENTSTEP = 0xf03a
PLY_AKG_CHANNEL1_ARPEGGIOTABLESPEED = 0xf03d
PLY_AKG_CHANNEL1_GENERATEDCURRENTARPNOTE = 0xf03b
PLY_AKG_CHANNEL1_GENERATEDCURRENTINVERTEDVOLUME = 0xf045
PLY_AKG_CHANNEL1_GENERATEDCURRENTPITCH = 0xf069
PLY_AKG_CHANNEL1_GLIDEDIRECTION = 0xf044
PLY_AKG_CHANNEL1_GLIDETOREACH = 0xf060
PLY_AKG_CHANNEL1_GLIDE_SAVEHL = 0xf062
PLY_AKG_CHANNEL1_INSTRUMENTORIGINALSPEED = 0xf037
PLY_AKG_CHANNEL1_INSTRUMENTSPEED = 0xf038
PLY_AKG_CHANNEL1_INSTRUMENTSTEP = 0xf039
PLY_AKG_CHANNEL1_INVERTEDVOLUMEINTEGER = 0xf057
PLY_AKG_CHANNEL1_INVERTEDVOLUMEINTEGERANDDECIMAL = 0xf056
PLY_AKG_CHANNEL1_ISARPEGGIOTABLE = 0xf034
PLY_AKG_CHANNEL1_ISPITCH = 0xf036
PLY_AKG_CHANNEL1_ISPITCHTABLE = 0xf035
PLY_AKG_CHANNEL1_ISVOLUMESLIDE = 0xf033
PLY_AKG_CHANNEL1_PITCH = 0xf058
PLY_AKG_CHANNEL1_PITCHBASESPEED = 0xf03f
PLY_AKG_CHANNEL1_PITCHTABLE = 0xf04e
PLY_AKG_CHANNEL1_PITCHTABLEBASE = 0xf050
PLY_AKG_CHANNEL1_PITCHTABLECURRENTSTEP = 0xf03e
PLY_AKG_CHANNEL1_PITCHTABLESPEED = 0xf040
PLY_AKG_CHANNEL1_PITCHTRACK = 0xf04c
PLY_AKG_CHANNEL1_PITCHTRACKADDORSBC_16BITS = 0xf06b
PLY_AKG_CHANNEL1_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS = 0xf06d
PLY_AKG_CHANNEL1_PITCHTRACKDECIMALCOUNTER = 0xf042
PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTR = 0xf064
PLY_AKG_CHANNEL1_PITCHTRACKDECIMALINSTRANDVALUERETURNJP = 0xf066
PLY_AKG_CHANNEL1_PITCHTRACKDECIMALVALUE = 0xf065
PLY_AKG_CHANNEL1_PITCHTRACKINTEGERADDORSUB = 0xf070
PLY_AKG_CHANNEL1_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS = 0xf071
PLY_AKG_CHANNEL1_PTBASEINSTRUMENT = 0xf05c
PLY_AKG_CHANNEL1_PTINSTRUMENT = 0xf05a
PLY_AKG_CHANNEL1_PTTRACK = 0xf046
PLY_AKG_CHANNEL1_SOUNDEFFECTDATA = 0xf0fc
PLY_AKG_CHANNEL1_SOUNDSTREAM_RELATIVEMODIFIERADDRESS = 0xf031
PLY_AKG_CHANNEL1_TRACKNOTE = 0xf043
PLY_AKG_CHANNEL1_VOLUMESLIDEVALUE = 0xf05e
PLY_AKG_CHANNEL1_WAITCOUNTER = 0xf032
PLY_AKG_CHANNEL2_ARPEGGIOBASESPEED = 0xf07f
PLY_AKG_CHANNEL2_ARPEGGIOTABLE = 0xf08b
PLY_AKG_CHANNEL2_ARPEGGIOTABLEBASE = 0xf08d
PLY_AKG_CHANNEL2_ARPEGGIOTABLECURRENTSTEP = 0xf07d
PLY_AKG_CHANNEL2_ARPEGGIOTABLESPEED = 0xf080
PLY_AKG_CHANNEL2_GENERATEDCURRENTARPNOTE = 0xf07e
PLY_AKG_CHANNEL2_GENERATEDCURRENTINVERTEDVOLUME = 0xf088
PLY_AKG_CHANNEL2_GENERATEDCURRENTPITCH = 0xf0ac
PLY_AKG_CHANNEL2_GLIDEDIRECTION = 0xf087
PLY_AKG_CHANNEL2_GLIDETOREACH = 0xf0a3
PLY_AKG_CHANNEL2_GLIDE_SAVEHL = 0xf0a5
PLY_AKG_CHANNEL2_INSTRUMENTORIGINALSPEED = 0xf07a
PLY_AKG_CHANNEL2_INSTRUMENTSPEED = 0xf07b
PLY_AKG_CHANNEL2_INSTRUMENTSTEP = 0xf07c
PLY_AKG_CHANNEL2_INVERTEDVOLUMEINTEGER = 0xf09a
PLY_AKG_CHANNEL2_INVERTEDVOLUMEINTEGERANDDECIMAL = 0xf099
PLY_AKG_CHANNEL2_ISARPEGGIOTABLE = 0xf077
PLY_AKG_CHANNEL2_ISPITCH = 0xf079
PLY_AKG_CHANNEL2_ISPITCHTABLE = 0xf078
PLY_AKG_CHANNEL2_ISVOLUMESLIDE = 0xf076
PLY_AKG_CHANNEL2_PITCH = 0xf09b
PLY_AKG_CHANNEL2_PITCHBASESPEED = 0xf082
PLY_AKG_CHANNEL2_PITCHTABLE = 0xf091
PLY_AKG_CHANNEL2_PITCHTABLEBASE = 0xf093
PLY_AKG_CHANNEL2_PITCHTABLECURRENTSTEP = 0xf081
PLY_AKG_CHANNEL2_PITCHTABLESPEED = 0xf083
PLY_AKG_CHANNEL2_PITCHTRACK = 0xf08f
PLY_AKG_CHANNEL2_PITCHTRACKADDORSBC_16BITS = 0xf0ae
PLY_AKG_CHANNEL2_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS = 0xf0b0
PLY_AKG_CHANNEL2_PITCHTRACKDECIMALCOUNTER = 0xf085
PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTR = 0xf0a7
PLY_AKG_CHANNEL2_PITCHTRACKDECIMALINSTRANDVALUERETURNJP = 0xf0a9
PLY_AKG_CHANNEL2_PITCHTRACKDECIMALVALUE = 0xf0a8
PLY_AKG_CHANNEL2_PITCHTRACKINTEGERADDORSUB = 0xf0b3
PLY_AKG_CHANNEL2_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS = 0xf0b4
PLY_AKG_CHANNEL2_PLAYINSTRUMENT_RELATIVEMODIFIERADDRESS = 0xf074
PLY_AKG_CHANNEL2_PTBASEINSTRUMENT = 0xf09f
PLY_AKG_CHANNEL2_PTINSTRUMENT = 0xf09d
PLY_AKG_CHANNEL2_PTTRACK = 0xf089
PLY_AKG_CHANNEL2_SOUNDEFFECTDATA = 0xf104
PLY_AKG_CHANNEL2_TRACKNOTE = 0xf086
PLY_AKG_CHANNEL2_VOLUMESLIDEVALUE = 0xf0a1
PLY_AKG_CHANNEL2_WAITCOUNTER = 0xf075
PLY_AKG_CHANNEL3_ARPEGGIOBASESPEED = 0xf0c2
PLY_AKG_CHANNEL3_ARPEGGIOTABLE = 0xf0ce
PLY_AKG_CHANNEL3_ARPEGGIOTABLEBASE = 0xf0d0
PLY_AKG_CHANNEL3_ARPEGGIOTABLECURRENTSTEP = 0xf0c0
PLY_AKG_CHANNEL3_ARPEGGIOTABLESPEED = 0xf0c3
PLY_AKG_CHANNEL3_GENERATEDCURRENTARPNOTE = 0xf0c1
PLY_AKG_CHANNEL3_GENERATEDCURRENTINVERTEDVOLUME = 0xf0cb
PLY_AKG_CHANNEL3_GENERATEDCURRENTPITCH = 0xf0ef
PLY_AKG_CHANNEL3_GLIDEDIRECTION = 0xf0ca
PLY_AKG_CHANNEL3_GLIDETOREACH = 0xf0e6
PLY_AKG_CHANNEL3_GLIDE_SAVEHL = 0xf0e8
PLY_AKG_CHANNEL3_INSTRUMENTORIGINALSPEED = 0xf0bd
PLY_AKG_CHANNEL3_INSTRUMENTSPEED = 0xf0be
PLY_AKG_CHANNEL3_INSTRUMENTSTEP = 0xf0bf
PLY_AKG_CHANNEL3_INVERTEDVOLUMEINTEGER = 0xf0dd
PLY_AKG_CHANNEL3_INVERTEDVOLUMEINTEGERANDDECIMAL = 0xf0dc
PLY_AKG_CHANNEL3_ISARPEGGIOTABLE = 0xf0ba
PLY_AKG_CHANNEL3_ISPITCH = 0xf0bc
PLY_AKG_CHANNEL3_ISPITCHTABLE = 0xf0bb
PLY_AKG_CHANNEL3_ISVOLUMESLIDE = 0xf0b9
PLY_AKG_CHANNEL3_PITCH = 0xf0de
PLY_AKG_CHANNEL3_PITCHBASESPEED = 0xf0c5
PLY_AKG_CHANNEL3_PITCHTABLE = 0xf0d4
PLY_AKG_CHANNEL3_PITCHTABLEBASE = 0xf0d6
PLY_AKG_CHANNEL3_PITCHTABLECURRENTSTEP = 0xf0c4
PLY_AKG_CHANNEL3_PITCHTABLESPEED = 0xf0c6
PLY_AKG_CHANNEL3_PITCHTRACK = 0xf0d2
PLY_AKG_CHANNEL3_PITCHTRACKADDORSBC_16BITS = 0xf0f1
PLY_AKG_CHANNEL3_PITCHTRACKAFTERADDORSBCJUMPINSTRANDADDRESS = 0xf0f3
PLY_AKG_CHANNEL3_PITCHTRACKDECIMALCOUNTER = 0xf0c8
PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTR = 0xf0ea
PLY_AKG_CHANNEL3_PITCHTRACKDECIMALINSTRANDVALUERETURNJP = 0xf0ec
PLY_AKG_CHANNEL3_PITCHTRACKDECIMALVALUE = 0xf0eb
PLY_AKG_CHANNEL3_PITCHTRACKINTEGERADDORSUB = 0xf0f6
PLY_AKG_CHANNEL3_PITCHTRACKINTEGERAFTERADDORSUBJUMPINSTRANDADDRESS = 0xf0f7
PLY_AKG_CHANNEL3_PTBASEINSTRUMENT = 0xf0e2
PLY_AKG_CHANNEL3_PTINSTRUMENT = 0xf0e0
PLY_AKG_CHANNEL3_PTTRACK = 0xf0cc
PLY_AKG_CHANNEL3_SOUNDEFFECTDATA = 0xf10c
PLY_AKG_CHANNEL3_SOUNDSTREAM_RELATIVEMODIFIERADDRESS = 0xf0b7
PLY_AKG_CHANNEL3_TRACKNOTE = 0xf0c9
PLY_AKG_CHANNEL3_VOLUMESLIDEVALUE = 0xf0e4
PLY_AKG_CHANNEL3_WAITCOUNTER = 0xf0b8
PLY_AKG_CHANNEL_READEFFECTS_EFFECTBLOCKS1 = 0xf017
PLY_AKG_CHANNEL_READEFFECTS_ENDJUMPINSTRANDADDRESS = 0xf029
PLY_AKG_CHANNEL_RE_READNEXTEFFECTINBLOCK = 0xf00a
PLY_AKG_CURRENTSPEED = 0xf001
PLY_AKG_EFFECT_GLIDEWITHNOTESAVEDE = 0xf02c
PLY_AKG_EMPTYINSTRUMENTDATAPT = 0xf019
PLY_AKG_EVENT = 0xf000
PLY_AKG_EVENTTRACK_PTTRACK = 0xf00f
PLY_AKG_EVENTTRACK_WAITCOUNTER = 0xf006
PLY_AKG_INSTRUMENTSTABLE = 0xf015
PLY_AKG_PATTERNDECREASINGHEIGHT = 0xf003
PLY_AKG_PITCHESTABLE = 0xf013
PLY_AKG_PSGHARDWAREPERIOD_INSTR = 0xf027
PLY_AKG_PSGREG01_INSTR = 0xf01d
PLY_AKG_PSGREG10 = 0xf026
PLY_AKG_PSGREG13_INSTR = 0xf008
PLY_AKG_PSGREG13_OLDVALUE = 0xf007
PLY_AKG_PSGREG23_INSTR = 0xf01f
PLY_AKG_PSGREG45_INSTR = 0xf021
PLY_AKG_PSGREG6_8_INSTR = 0xf023
PLY_AKG_PSGREG8 = 0xf024
PLY_AKG_PSGREG9_10_INSTR = 0xf025
PLY_AKG_PTSOUNDEFFECTTABLE = 0xf0fa
PLY_AKG_READLINKER_PTLINKER = 0xf00b
PLY_AKG_RETRIG = 0xf009
PLY_AKG_SAVESP = 0xf01b
PLY_AKG_SPEEDTRACK_PTTRACK = 0xf00d
PLY_AKG_SPEEDTRACK_WAITCOUNTER = 0xf005
PLY_AKG_TEMPPLAYINSTRUMENTJUMPINSTRANDADDRESS = 0xf02e
PLY_AKG_TICKDECREASINGCOUNTER = 0xf004
