; ____________________________                                                 
; ██▀▀█▀▀██▀▀▀▀▀▀▀█▀▀█        │   ▄▄       ▄▄                                  
; ██  ▀  █▄  ▀██▄ ▀ ▄█ ▄▀▀ █  │  ██▄█ ██▄▀ ██▄▀ ▄█▀▄  ██▀                      
; █  █ █  ▀▀  ▄█  █  █ ▀▄█ █▄ │  ██ █ ██   ██ █ ▀█▄▀ ▄██                       
; ▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀────────┘                                                
;  by Guillaume 'Aoineko' Blanchard under CC BY-SA license                     
;==============================================================================
; Autogenerated Arkos AKY player for MSX-GL library                           
;  on 10/02/2023 at  0:02:37, 49                                                         
;                                                                              
; Arkos Tracker and the Z80 players are coded and designed                     
;  by Julien Névo (aka Targhan/Arkos) under MIT License.                       
;==============================================================================
PLY_AKY_START:
_PLY_AKY_INIT::
PLY_AKY_INIT:
PLY_AKY_USEHOOKS:
PLY_AKY_OPCODE_OR_A:
PLY_AKY_OFFSET1B:
	inc hl
    ld a, (hl)
PLY_AKY_RRB_SOUNDCHANNELBIT:
	inc hl
PLY_AKY_RRB_NOISECHANNELBIT = .+2
    ld de, #0x4
PLY_AKY_INIT_SKIPHEADERLOOP:
	add hl, de
    sub #0x3
    jr z, PLY_AKY_INIT_SKIPHEADEREND
    jr nc, PLY_AKY_INIT_SKIPHEADERLOOP
PLY_AKY_INIT_SKIPHEADEREND:
	ld (PLY_AKY_PTLINKER), hl
    ld a, #0x0
    ld (PLY_AKY_CHANNEL1_REGISTERBLOCKLINESTATE_OPCODE), a
    ld (PLY_AKY_CHANNEL2_REGISTERBLOCKLINESTATE_OPCODE), a
    ld (PLY_AKY_CHANNEL3_REGISTERBLOCKLINESTATE_OPCODE), a
    ld hl, #0x1
    ld (PLY_AKY_PATTERNFRAMECOUNTER), hl
    ret 
_PLY_AKY_PLAY::
PLY_AKY_PLAY:
	ld (PLY_AKY_SAVESP), sp
    ld hl, (PLY_AKY_PATTERNFRAMECOUNTER)
    dec hl
    ld a, l
    or h
    jr z, PLY_AKY_PATTERNFRAMECOUNTER_OVER
    ld (PLY_AKY_PATTERNFRAMECOUNTER), hl
    jr PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK_START
PLY_AKY_PATTERNFRAMECOUNTER_OVER:
	ld sp, (PLY_AKY_PTLINKER)
    pop hl
    ld a, l
    or h
    jr nz, PLY_AKY_LINKERNOTENDSONG
    pop hl
    ld sp, hl
    pop hl
; MSXgl - Start
	push	af
	ld		a, #1
	ld		(_g_AKY_EndOfSong), a
	pop		af
; MSXgl - End
PLY_AKY_LINKERNOTENDSONG:
	ld (PLY_AKY_PATTERNFRAMECOUNTER), hl
    pop hl
    ld (PLY_AKY_CHANNEL1_PTTRACK), hl
    pop hl
    ld (PLY_AKY_CHANNEL2_PTTRACK), hl
    pop hl
    ld (PLY_AKY_CHANNEL3_PTTRACK), hl
    ld (PLY_AKY_PTLINKER), sp
    ld a, #0x1
    ld (PLY_AKY_CHANNEL2_WAITBEFORENEXTREGISTERBLOCK), a
    ld (PLY_AKY_CHANNEL3_WAITBEFORENEXTREGISTERBLOCK), a
    jr PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK_OVER
PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK_START:
	ld a, (PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK)
    dec a
    jr nz, PLY_AKY_CHANNEL1_REGISTERBLOCK_PROCESS
PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK_OVER:
	ld a, #0x0
    ld (PLY_AKY_CHANNEL1_REGISTERBLOCKLINESTATE_OPCODE), a
    ld sp, (PLY_AKY_CHANNEL1_PTTRACK)
    dec sp
    pop af
    pop hl
    ld (PLY_AKY_CHANNEL1_PTTRACK), sp
    ld (PLY_AKY_CHANNEL1_PTREGISTERBLOCK), hl
PLY_AKY_CHANNEL1_REGISTERBLOCK_PROCESS:
	ld (PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK), a
PLY_AKY_CHANNEL2_WAITBEFORENEXTREGISTERBLOCK_START:
	ld a, (PLY_AKY_CHANNEL2_WAITBEFORENEXTREGISTERBLOCK)
    dec a
    jr nz, PLY_AKY_CHANNEL2_REGISTERBLOCK_PROCESS
PLY_AKY_CHANNEL2_WAITBEFORENEXTREGISTERBLOCK_OVER:
	ld a, #0x0
    ld (PLY_AKY_CHANNEL2_REGISTERBLOCKLINESTATE_OPCODE), a
    ld sp, (PLY_AKY_CHANNEL2_PTTRACK)
    dec sp
    pop af
    pop hl
    ld (PLY_AKY_CHANNEL2_PTTRACK), sp
    ld (PLY_AKY_CHANNEL2_PTREGISTERBLOCK), hl
PLY_AKY_CHANNEL2_REGISTERBLOCK_PROCESS:
	ld (PLY_AKY_CHANNEL2_WAITBEFORENEXTREGISTERBLOCK), a
PLY_AKY_CHANNEL3_WAITBEFORENEXTREGISTERBLOCK_START:
	ld a, (PLY_AKY_CHANNEL3_WAITBEFORENEXTREGISTERBLOCK)
    dec a
    jr nz, PLY_AKY_CHANNEL3_REGISTERBLOCK_PROCESS
PLY_AKY_CHANNEL3_WAITBEFORENEXTREGISTERBLOCK_OVER:
	ld a, #0x0
    ld (PLY_AKY_CHANNEL3_REGISTERBLOCKLINESTATE_OPCODE), a
    ld sp, (PLY_AKY_CHANNEL3_PTTRACK)
    dec sp
    pop af
    pop hl
    ld (PLY_AKY_CHANNEL3_PTTRACK), sp
    ld (PLY_AKY_CHANNEL3_PTREGISTERBLOCK), hl
PLY_AKY_CHANNEL3_REGISTERBLOCK_PROCESS:
	ld (PLY_AKY_CHANNEL3_WAITBEFORENEXTREGISTERBLOCK), a
    ld hl, #0x8
    ld c, #0x10
    exx
    ld bc, #0xe0ff
    ld sp, #PLY_AKY_RETTABLE_READREGISTERBLOCK
    ld hl, (PLY_AKY_CHANNEL1_PTREGISTERBLOCK)
    ld a, (PLY_AKY_CHANNEL1_REGISTERBLOCKLINESTATE_OPCODE)
    add a, a
    jp PLY_AKY_READREGISTERBLOCK
PLY_AKY_CHANNEL1_REGISTERBLOCK_RETURN:
	ld a, #0xff
    ld (PLY_AKY_CHANNEL1_REGISTERBLOCKLINESTATE_OPCODE), a
    ld (PLY_AKY_CHANNEL1_PTREGISTERBLOCK), hl
    srl b
    ld hl, (PLY_AKY_CHANNEL2_PTREGISTERBLOCK)
    ld a, (PLY_AKY_CHANNEL2_REGISTERBLOCKLINESTATE_OPCODE)
    add a, a
    jp PLY_AKY_READREGISTERBLOCK
PLY_AKY_CHANNEL2_REGISTERBLOCK_RETURN:
	ld a, #0xff
    ld (PLY_AKY_CHANNEL2_REGISTERBLOCKLINESTATE_OPCODE), a
    ld (PLY_AKY_CHANNEL2_PTREGISTERBLOCK), hl
    scf
    rr b
    ld hl, (PLY_AKY_CHANNEL3_PTREGISTERBLOCK)
    ld a, (PLY_AKY_CHANNEL3_REGISTERBLOCKLINESTATE_OPCODE)
    add a, a
    jp PLY_AKY_READREGISTERBLOCK
PLY_AKY_CHANNEL3_REGISTERBLOCK_RETURN:
	ld a, #0xff
    ld (PLY_AKY_CHANNEL3_REGISTERBLOCKLINESTATE_OPCODE), a
    ld (PLY_AKY_CHANNEL3_PTREGISTERBLOCK), hl
    ld a, b
    exx
    ld b, a
    ld a, #0x7
    out (0xa0), a
    ld a, b
PLY_AKY_OPCODE_SCF:
	out (0xa1), a
    ld a, #0x6
    out (0xa0), a
    ld a, (PLY_AKY_PSGREGISTER6)
    out (0xa1), a
    ld a, #0xb
    out (0xa0), a
    ld a, (PLY_AKY_PSGREGISTER11)
    out (0xa1), a
    ld a, #0xc
    out (0xa0), a
    ld a, (PLY_AKY_PSGREGISTER12)
    out (0xa1), a
PLY_AKY_PSGREGISTER13_CODE:
	ld a, (PLY_AKY_PSGREGISTER13_RETRIG)
    ld b, a
    ld a, (PLY_AKY_PSGREGISTER13)
    cp b
    jr z, PLY_AKY_PSGREGISTER13_END
    ld (PLY_AKY_PSGREGISTER13_RETRIG), a
    ld b, a
    ld a, #0xd
    out (0xa0), a
    ld a, b
    out (0xa1), a
PLY_AKY_PSGREGISTER13_END:
	ld sp, (PLY_AKY_SAVESP)
    ret 
PLY_AKY_READREGISTERBLOCK:
	ld a, (hl)
    inc hl
    jp c, PLY_AKY_RRB_NONINITIALSTATE
    rra 
    jr c, PLY_AKY_RRB_IS_SOFTWAREONLYORSOFTWAREANDHARDWARE
    rra 
    jr c, PLY_AKY_RRB_IS_HARDWAREONLY
PLY_AKY_RRB_IS_NOSOFTWARENOHARDWARE:
	rra 
    jr nc, PLY_AKY_RRB_NIS_NOSOFTWARENOHARDWARE_READVOLUME
    ld de, #PLY_AKY_PSGREGISTER6
    ldi
    res 5, b
PLY_AKY_RRB_NIS_NOSOFTWARENOHARDWARE_READVOLUME:
	exx
    ld b, a
    ld a, l
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc l
    inc h
    inc h
    exx
    set 2, b
    ret 
PLY_AKY_RRB_IS_HARDWAREONLY:
	rra 
    jr nc, PLY_AKY_RRB_IS_HO_NORETRIG
    set 7, a
    ld (PLY_AKY_PSGREGISTER13_RETRIG), a
PLY_AKY_RRB_IS_HO_NORETRIG:
	rra 
    jr nc, PLY_AKY_RRB_IS_HO_NONOISE
    ld de, #PLY_AKY_PSGREGISTER6
    ldi
    res 5, b
PLY_AKY_RRB_IS_HO_NONOISE:
	and #0xf
    ld (PLY_AKY_PSGREGISTER13), a
    ld de, #PLY_AKY_PSGREGISTER11
    ldi
    ldi
    set 2, b
    exx
    ld a, l
    out (0xa0), a
    ld a, c
    out (0xa1), a
    inc l
    inc h
    inc h
    exx
    ret 
PLY_AKY_RRB_IS_SOFTWAREONLYORSOFTWAREANDHARDWARE:
	rra 
    jr c, PLY_AKY_RRB_IS_SOFTWAREANDHARDWARE
    rra 
    jr nc, PLY_AKY_RRB_IS_SOFTWAREONLY_NONOISE
    ld de, #PLY_AKY_PSGREGISTER6
    ldi
    res 5, b
PLY_AKY_RRB_IS_SOFTWAREONLY_NONOISE:
	exx
    ld b, a
    ld a, l
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc l
    exx
    ld a, (hl)
    inc hl
    exx
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc h
    exx
    ld a, (hl)
    inc hl
    exx
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc h
    exx
    ret 
PLY_AKY_RRB_IS_SOFTWAREANDHARDWARE:
	rra 
    jr nc, PLY_AKY_RRB_IS_SAH_NORETRIG
    set 7, a
    ld (PLY_AKY_PSGREGISTER13_RETRIG), a
PLY_AKY_RRB_IS_SAH_NORETRIG:
	rra 
    jr nc, PLY_AKY_RRB_IS_SAH_NONOISE
    ld de, #PLY_AKY_PSGREGISTER6
    ldi
    res 5, b
PLY_AKY_RRB_IS_SAH_NONOISE:
	and #0xf
    ld (PLY_AKY_PSGREGISTER13), a
    ld a, (hl)
    inc hl
    exx
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc h
    exx
    ld a, (hl)
    inc hl
    exx
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc h
    ld a, l
    out (0xa0), a
    ld a, c
    out (0xa1), a
    inc l
    exx
    ld de, #PLY_AKY_PSGREGISTER11
    ldi
    ldi
    ret 
PLY_AKY_RRB_NIS_NOSOFTWARENOHARDWARE_LOOP:
	ld a, (hl)
    inc hl
    ld h, (hl)
    ld l, a
    ld a, (hl)
    inc hl
PLY_AKY_RRB_NONINITIALSTATE:
	rra 
    jr c, PLY_AKY_RRB_NIS_SOFTWAREONLYORSOFTWAREANDHARDWARE
    rra 
    jp c, PLY_AKY_RRB_NIS_HARDWAREONLY
    ld e, a
    and #0x3
    cp #0x2
    jr z, PLY_AKY_RRB_NIS_NOSOFTWARENOHARDWARE_LOOP
    set 2, b
    ld a, e
    rra 
    jr nc, PLY_AKY_RRB_NIS_NOVOLUME
    and #0xf
    exx
    ld b, a
    ld a, l
    out (0xa0), a
    ld a, b
    out (0xa1), a
    exx
PLY_AKY_RRB_NIS_NOVOLUME:
	exx
    inc l
    inc h
    inc h
    exx
    bit 5, e
    ret z
    ld a, (hl)
    ld (PLY_AKY_PSGREGISTER6), a
    inc hl
    res 5, b
    ret 
PLY_AKY_RRB_NIS_SOFTWAREONLYORSOFTWAREANDHARDWARE:
	rra 
    jp c, PLY_AKY_RRB_NIS_SOFTWAREANDHARDWARE
    ld e, a
    and #0xf
    exx
    ld b, a
    ld a, l
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc l
    exx
    bit 4, e
    jr z, PLY_AKY_RRB_NIS_SOFTWAREONLY_NOLSP
    ld a, (hl)
    inc hl
    exx
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    exx
PLY_AKY_RRB_NIS_SOFTWAREONLY_NOLSP:
	bit 5, e
    jr nz, PLY_AKY_RRB_NIS_SOFTWAREONLY_MSPANDMAYBENOISE
    exx
    inc h
    inc h
    exx
    ret 
PLY_AKY_RRB_NIS_SOFTWAREONLY_MSPANDMAYBENOISE:
	ld a, (hl)
    inc hl
    exx
    inc h
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    inc h
    exx
    rla 
    ret nc
    res 5, b
    rla 
    ret nc
    ld de, #PLY_AKY_PSGREGISTER6
    ldi
    ret 
PLY_AKY_RRB_NIS_HARDWAREONLY:
	rla 
    ld e, a
    and #0xe
    ld (PLY_AKY_PSGREGISTER13), a
    set 2, b
    exx
    ld a, l
    out (0xa0), a
    ld a, c
    out (0xa1), a
    inc l
    inc h
    inc h
    exx
    ld a, e
    rla 
    rla 
    jr nc, PLY_AKY_RRB_NIS_HARDWAREONLY_NOLSB
    ld de, #PLY_AKY_PSGREGISTER11
    ldi
PLY_AKY_RRB_NIS_HARDWAREONLY_NOLSB:
	rla 
    jr nc, PLY_AKY_RRB_NIS_HARDWAREONLY_NOMSB
    ld de, #PLY_AKY_PSGREGISTER12
    ldi
PLY_AKY_RRB_NIS_HARDWAREONLY_NOMSB:
	rla 
    jr c, PLY_AKY_RRB_NIS_HARDWARE_SHARED_NOISEORRETRIG_ANDSTOP
    ret 
PLY_AKY_RRB_NIS_SOFTWAREANDHARDWARE:
	exx
    ld b, a
    ld a, l
    out (0xa0), a
    ld a, c
    out (0xa1), a
    ld a, b
    inc l
    exx
    rra 
    jr nc, PLY_AKY_RRB_NIS_SAHH_AFTERLSBH
    ld de, #PLY_AKY_PSGREGISTER11
    ldi
PLY_AKY_RRB_NIS_SAHH_AFTERLSBH:
	rra 
    jr nc, PLY_AKY_RRB_NIS_SAHH_AFTERMSBH
    ld de, #PLY_AKY_PSGREGISTER12
    ldi
PLY_AKY_RRB_NIS_SAHH_AFTERMSBH:
	rra 
    jr nc, PLY_AKY_RRB_NIS_SAHH_AFTERLSBS
    ld e, a
    ld a, (hl)
    inc hl
    exx
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    exx
    ld a, e
PLY_AKY_RRB_NIS_SAHH_AFTERLSBS:
	rra 
    jr nc, PLY_AKY_RRB_NIS_SAHH_AFTERMSBS
    ld e, a
    ld a, (hl)
    inc hl
    exx
    inc h
    ld b, a
    ld a, h
    out (0xa0), a
    ld a, b
    out (0xa1), a
    dec h
    exx
    ld a, e
PLY_AKY_RRB_NIS_SAHH_AFTERMSBS:
	exx
    inc h
    inc h
    exx
    rra 
    jr nc, PLY_AKY_RRB_NIS_SAHH_AFTERENVELOPE
    ld de, #PLY_AKY_PSGREGISTER13
    ldi
PLY_AKY_RRB_NIS_SAHH_AFTERENVELOPE:
	rra 
    ret nc
PLY_AKY_RRB_NIS_HARDWARE_SHARED_NOISEORRETRIG_ANDSTOP:
	ld a, (hl)
    inc hl
    rra 
    jr nc, PLY_AKY_RRB_NIS_S_NOR_NORETRIG
    set 7, a
    ld (PLY_AKY_PSGREGISTER13_RETRIG), a
PLY_AKY_RRB_NIS_S_NOR_NORETRIG:
	rra 
    ret nc
    res 5, b
    rra 
    ret nc
    ld (PLY_AKY_PSGREGISTER6), a
    ret 
PLY_AKY_RETTABLE_READREGISTERBLOCK:
	.dw PLY_AKY_CHANNEL1_REGISTERBLOCK_RETURN
    .dw PLY_AKY_CHANNEL2_REGISTERBLOCK_RETURN
    .dw PLY_AKY_CHANNEL3_REGISTERBLOCK_RETURN
PLY_AKY_CHANNEL1_PTREGISTERBLOCK = 0xf017
PLY_AKY_CHANNEL1_PTTRACK = 0xf011
PLY_AKY_CHANNEL1_REGISTERBLOCKLINESTATE_OPCODE = 0xf003
PLY_AKY_CHANNEL1_WAITBEFORENEXTREGISTERBLOCK = 0xf000
PLY_AKY_CHANNEL2_PTREGISTERBLOCK = 0xf019
PLY_AKY_CHANNEL2_PTTRACK = 0xf013
PLY_AKY_CHANNEL2_REGISTERBLOCKLINESTATE_OPCODE = 0xf004
PLY_AKY_CHANNEL2_WAITBEFORENEXTREGISTERBLOCK = 0xf001
PLY_AKY_CHANNEL3_PTREGISTERBLOCK = 0xf01b
PLY_AKY_CHANNEL3_PTTRACK = 0xf015
PLY_AKY_CHANNEL3_REGISTERBLOCKLINESTATE_OPCODE = 0xf005
PLY_AKY_CHANNEL3_WAITBEFORENEXTREGISTERBLOCK = 0xf002
PLY_AKY_PATTERNFRAMECOUNTER = 0xf00f
PLY_AKY_PSGREGISTER11 = 0xf007
PLY_AKY_PSGREGISTER12 = 0xf008
PLY_AKY_PSGREGISTER13 = 0xf009
PLY_AKY_PSGREGISTER13_RETRIG = 0xf00a
PLY_AKY_PSGREGISTER6 = 0xf006
PLY_AKY_PTLINKER = 0xf00b
PLY_AKY_SAVESP = 0xf00d
