// ____________________________
// ██▀▀█▀▀██▀▀▀▀▀▀▀█▀▀█        │   ▄▄▄                ▄▄
// ██  ▀  █▄  ▀██▄ ▀ ▄█ ▄▀▀ █  │  ▀█▄  ▄▀██ ▄█▄█ ██▀▄ ██  ▄███
// █  █ █  ▀▀  ▄█  █  █ ▀▄█ █▄ │  ▄▄█▀ ▀▄██ ██ █ ██▀  ▀█▄ ▀█▄▄
// ▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀────────┘                 ▀▀
//  Driver sample
//─────────────────────────────────────────────────────────────────────────────
#include "msxgl.h"
#include "dos.h"

//=============================================================================
// DEFINES
//=============================================================================

//=============================================================================
// READ-ONLY DATA
//=============================================================================

// Table use to quick decimal-to-hexadecimal conversion
const c8 g_HexChar[16] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F' };

//=============================================================================
// MEMORY DATA
//=============================================================================

u8 g_MyVar;

//=============================================================================
// CODE
//=============================================================================

//-----------------------------------------------------------------------------
// Output character
void DOS_CharOutput(c8 chr)
{
	chr;	// A
__asm
	push	ix
	ld		e, a
	ld		c, #DOS_FUNC_CONOUT
	call	BDOS
	pop		ix
__endasm;
}

//-----------------------------------------------------------------------------
// Print a 8-bits hexadecimal value
void DOS_PrintHexa(u8 value)
{
	DOS_CharOutput(g_HexChar[(value >> 4) & 0x000F]);
	DOS_CharOutput(g_HexChar[value & 0x000F]);
}

//-----------------------------------------------------------------------------
// Print a string
void DOS_PrintText(const c8* str)
{
	while(*str)
		DOS_CharOutput(*str++);
}

//-----------------------------------------------------------------------------
// Program entry point
u8 main(u8 arg)
{
	g_MyVar = arg;
	DOS_PrintText("-> Driver start!\n\r");
	DOS_PrintText("-> Argument: ");
	DOS_PrintHexa(g_MyVar);
	DOS_PrintText("\n\r");
	DOS_PrintText("-> Driver end!\n\r");

	return g_MyVar * 2;
}