// ____________________________
// ██▀▀█▀▀██▀▀▀▀▀▀▀█▀▀█        │   ▄▄▄                ▄▄
// ██  ▀  █▄  ▀██▄ ▀ ▄█ ▄▀▀ █  │  ▀█▄  ▄▀██ ▄█▄█ ██▀▄ ██  ▄███
// █  █ █  ▀▀  ▄█  █  █ ▀▄█ █▄ │  ▄▄█▀ ▀▄██ ██ █ ██▀  ▀█▄ ▀█▄▄
// ▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀▀────────┘                 ▀▀
//  Ninja Tap sample
//─────────────────────────────────────────────────────────────────────────────
#include "msxgl.h"
#include "device/ninjatap.h"
#include "basic_usr.h"

//=============================================================================
// DEFINES
//=============================================================================

//=============================================================================
// READ-ONLY DATA
//=============================================================================

//=============================================================================
// MEMORY DATA
//=============================================================================

//=============================================================================
// CODE
//=============================================================================

//-----------------------------------------------------------------------------
//
void Bios_PrintText(const c8* str)
{
	while(*str)
		Bios_TextPrintChar(*str++);
}

//-----------------------------------------------------------------------------
// Program entry point
void main()
{
	if(Basic_GetType() != BASIC_TYPE_INT)
	{
		Basic_SetByte(-1);
		return;
	}

	i16 ret = 0;
	i8 val = Basic_GetByte();
	switch(val)
	{
	case 0:
		// Bios_PrintText("Ntap:Init");
		ret = NTap_Check();
		break;
	case 1:
	case 2:
	case 3:
	case 4:
	case 5:
	case 6:
	case 7:
	case 8:
		// Bios_PrintText("Ntap:Read");
		ret = (i16)(u8)~NTap_GetData(val-1);
		break;
	case -1:
		// Bios_PrintText("Ntap:Update");
		NTap_Update();
		ret = 1;
		break;
	default:
		// Bios_PrintText("Ntap:Unknow");
		break;
	}

	Basic_SetWord(ret);
}