// Copyright 2015 by Paulo Augusto Peccin. See license.txt distributed with this file.

// MSX International Keyboard Mattix
wmsx.KeyboardKeys = {

    D0             : { m:  [ 0, 0 ], key: "D0",            c_en: "0",   cs_en: ")",                     cs_ja: " " },
    D1             : { m:  [ 0, 1 ], key: "D1",            c_en: "1",   cs_en: "!" },
    D2             : { m:  [ 0, 2 ], key: "D2",            c_en: "2",   cs_en: "@",                     cs_ja: "\"" },
    D3             : { m:  [ 0, 3 ], key: "D3",            c_en: "3",   cs_en: "#" },
    D4             : { m:  [ 0, 4 ], key: "D4",            c_en: "4",   cs_en: "$" },
    D5             : { m:  [ 0, 5 ], key: "D5",            c_en: "5",   cs_en: "%" },
    D6             : { m:  [ 0, 6 ], key: "D6",            c_en: "6",   cs_en: "^",                     cs_ja: "&" },
    D7             : { m:  [ 0, 7 ], key: "D7",            c_en: "7",   cs_en: "&",                     cs_ja: "'" },
    D8             : { m:  [ 1, 0 ], key: "D8",            c_en: "8",   cs_en: "*",                     cs_ja: "(" },
    D9             : { m:  [ 1, 1 ], key: "D9",            c_en: "9",   cs_en: "(",                     cs_ja: ")" },
    MINUS          : { m:  [ 1, 2 ], key: "MINUS",         c_en: "-",   cs_en: "_",                     cs_ja: "=" },
    EQUAL          : { m:  [ 1, 3 ], key: "EQUAL",         c_en: "=",   cs_en: "+",     c_ja: "^",      cs_ja: "~" },
    BACKSLASH      : { m:  [ 1, 4 ], key: "BACKSLASH",     c_en: "\\",  cs_en: "|",     c_ja: "&yen;",  cs_ja: "|" },
    OPEN_BRACKET   : { m:  [ 1, 5 ], key: "OPEN_BRACKET",  c_en: "[",   cs_en: "{",     c_ja: "@",      cs_ja: "`" },
    CLOSE_BRACKET  : { m:  [ 1, 6 ], key: "CLOSE_BRACKET", c_en: "]",   cs_en: "}",     c_ja: "[",      cs_ja: "{" },
    SEMICOLON      : { m:  [ 1, 7 ], key: "SEMICOLON",     c_en: ";",   cs_en: ":",                     cs_ja: "+" },
    QUOTE          : { m:  [ 2, 0 ], key: "QUOTE",         c_en: "'",   cs_en: "\"",    c_ja: ":",      cs_ja: "*" },
    BACKQUOTE      : { m:  [ 2, 1 ], key: "BACKQUOTE",     c_en: "`",   cs_en: "~",     c_ja: "]",      cs_ja: "}" },
    COMMA          : { m:  [ 2, 2 ], key: "COMMA",         c_en: ",",   cs_en: "<" },
    PERIOD         : { m:  [ 2, 3 ], key: "PERIOD",        c_en: ".",   cs_en: ">" },
    SLASH          : { m:  [ 2, 4 ], key: "SLASH",         c_en: "/",   cs_en: "?" },
    DEAD           : { m:  [ 2, 5 ], key: "DEAD",          c_en: "à",   cs_en: "á",     c_ja: " ",      cs_ja: "_" ,    cns_en: "à",   cns_ja: "_" },
    A              : { m:  [ 2, 6 ], key: "A",             c_en: "A" },
    B              : { m:  [ 2, 7 ], key: "B",             c_en: "B" },
    C              : { m:  [ 3, 0 ], key: "C",             c_en: "C" },
    D              : { m:  [ 3, 1 ], key: "D",             c_en: "D" },
    E              : { m:  [ 3, 2 ], key: "E",             c_en: "E" },
    F              : { m:  [ 3, 3 ], key: "F",             c_en: "F" },
    G              : { m:  [ 3, 4 ], key: "G",             c_en: "G" },
    H              : { m:  [ 3, 5 ], key: "H",             c_en: "H" },
    I              : { m:  [ 3, 6 ], key: "I",             c_en: "I" },
    J              : { m:  [ 3, 7 ], key: "J",             c_en: "J" },
    K              : { m:  [ 4, 0 ], key: "K",             c_en: "K" },
    L              : { m:  [ 4, 1 ], key: "L",             c_en: "L" },
    M              : { m:  [ 4, 2 ], key: "M",             c_en: "M" },
    N              : { m:  [ 4, 3 ], key: "N",             c_en: "N" },
    O              : { m:  [ 4, 4 ], key: "O",             c_en: "O" },
    P              : { m:  [ 4, 5 ], key: "P",             c_en: "P" },
    Q              : { m:  [ 4, 6 ], key: "Q",             c_en: "Q" },
    R              : { m:  [ 4, 7 ], key: "R",             c_en: "R" },
    S              : { m:  [ 5, 0 ], key: "S",             c_en: "S" },
    T              : { m:  [ 5, 1 ], key: "T",             c_en: "T" },
    U              : { m:  [ 5, 2 ], key: "U",             c_en: "U" },
    V              : { m:  [ 5, 3 ], key: "V",             c_en: "V" },
    W              : { m:  [ 5, 4 ], key: "W",             c_en: "W" },
    X              : { m:  [ 5, 5 ], key: "X",             c_en: "X" },
    Y              : { m:  [ 5, 6 ], key: "Y",             c_en: "Y" },
    Z              : { m:  [ 5, 7 ], key: "Z",             c_en: "Z" },
    SHIFT          : { m:  [ 6, 0 ], key: "SHIFT",         c_en: "SHF" },
    CONTROL        : { m:  [ 6, 1 ], key: "CONTROL",       c_en: "CTR" },
    CAPSLOCK       : { m:  [ 6, 3 ], key: "CAPSLOCK",      c_en: "CAP" },
    GRAPH          : { m:  [ 6, 2 ], key: "GRAPH",         c_en: "GRA" },
    CODE           : { m:  [ 6, 4 ], key: "CODE",          c_en: "COD",                 c_ja: "KANA",   cs_ja: "KANA" },
    F1             : { m:  [ 6, 5 ], key: "F1",            c_en: "F1",   cs_en: "F6" },
    F2             : { m:  [ 6, 6 ], key: "F2",            c_en: "F2",   cs_en: "F7" },
    F3             : { m:  [ 6, 7 ], key: "F3",            c_en: "F3",   cs_en: "F8" },
    F4             : { m:  [ 7, 0 ], key: "F4",            c_en: "F4",   cs_en: "F9" },
    F5             : { m:  [ 7, 1 ], key: "F5",            c_en: "F5",   cs_en: "F10" },
    ESCAPE         : { m:  [ 7, 2 ], key: "ESCAPE",        c_en: "ESC" },
    TAB            : { m:  [ 7, 3 ], key: "TAB",           c_en: "TAB" },
    STOP           : { m:  [ 7, 4 ], key: "STOP",          c_en: "STP" },
    BACKSPACE      : { m:  [ 7, 5 ], key: "BACKSPACE",     c_en: "BS" },
    SELECT         : { m:  [ 7, 6 ], key: "SELECT",        c_en: "SEL" },
    ENTER          : { m:  [ 7, 7 ], key: "ENTER",         c_en: "RET" },
    SPACE          : { m:  [ 8, 0 ], key: "SPACE",         c_en: "SPC" },
    HOME           : { m:  [ 8, 1 ], key: "HOME",          c_en: "HOM" },
    INSERT         : { m:  [ 8, 2 ], key: "INSERT",        c_en: "INS" },
    DELETE         : { m:  [ 8, 3 ], key: "DELETE",        c_en: "DEL" },
    LEFT           : { m:  [ 8, 4 ], key: "LEFT",          c_en: "LFT" },
    UP             : { m:  [ 8, 5 ], key: "UP",            c_en: "UP" },
    DOWN           : { m:  [ 8, 6 ], key: "DOWN",          c_en: "DWN" },
    RIGHT          : { m:  [ 8, 7 ], key: "RIGHT",         c_en: "RGH" },
    NUM_MULTIPLY   : { m:  [ 9, 0 ], key: "NUM_MULTIPLY",  c_en: "*" },
    NUM_PLUS       : { m:  [ 9, 1 ], key: "NUM_PLUS",      c_en: "+" },
    NUM_DIVIDE     : { m:  [ 9, 2 ], key: "NUM_DIVIDE",    c_en: "/" },
    NUM_0          : { m:  [ 9, 3 ], key: "NUM_0",         c_en: "0" },
    NUM_1          : { m:  [ 9, 4 ], key: "NUM_1",         c_en: "1" },
    NUM_2          : { m:  [ 9, 5 ], key: "NUM_2",         c_en: "2" },
    NUM_3          : { m:  [ 9, 6 ], key: "NUM_3",         c_en: "3" },
    NUM_4          : { m:  [ 9, 7 ], key: "NUM_4",         c_en: "4" },
    NUM_5          : { m: [ 10, 0 ], key: "NUM_5",         c_en: "5" },
    NUM_6          : { m: [ 10, 1 ], key: "NUM_6",         c_en: "6" },
    NUM_7          : { m: [ 10, 2 ], key: "NUM_7",         c_en: "7" },
    NUM_8          : { m: [ 10, 3 ], key: "NUM_8",         c_en: "8" },
    NUM_9          : { m: [ 10, 4 ], key: "NUM_9",         c_en: "9" },
    NUM_MINUS      : { m: [ 10, 5 ], key: "NUM_MINUS",     c_en: "-" },
    NUM_COMMA      : { m: [ 10, 6 ], key: "NUM_COMMA",     c_en: "," },
    NUM_PERIOD     : { m: [ 10, 7 ], key: "NUM_PERIOD",    c_en: "." },
    YES            : { m: [ 11, 1 ], key: "YES",           c_en: "YES",                 c_ja: "HAI",    cs_ja: "HAI" },
    NO             : { m: [ 11, 3 ], key: "NO",            c_en: "NO",                  c_ja: "IIE",    cs_ja: "IIE" }

};

