// WebMSX version 5.4.4
// Copyright 2015 by Paulo Augusto Peccin. See license.txt distributed with this file.

// Main Emulator parameters.
// May be overridden dynamically by external Config File or URL query parameters

WMSX = {

    // Main Setup
    ENVIRONMENT:                     0,                         // 0: Default Emulator Environment. 1..99: Custom User Environment
    CONFIG_URL:                     "",                         // Configuration file to merge. Processed before URL parameters
    MACHINE:                        "",                         // Machine Type. See Machine Configuration. Leave blank for auto-detection
    PRESETS:                        "",                         // Configuration Presets to apply. See Presets Configuration

    // Full or relative URL of Media files to load
    CARTRIDGE1_URL:                 "",
    CARTRIDGE2_URL:                 "",
    DISKA_URL:                      "",                         // Image files
    DISKB_URL:                      "",
    HARDDISK_URL:                   "",
    DISKA_FILES_URL:                "",                         // File to load into a Disk. For several files, use a ZIP file
    DISKB_FILES_URL:                "",
    HARDDISK_FILES_URL:             "",
    TAPE_URL:                       "",
    STATE_URL:                      "",
    AUTODETECT_URL:                 "",

    // Forcing ROM formats
    CARTRIDGE1_FORMAT:              "",                         // Normal, ASCII8, ASCII16, Konami, KonamiSCC, KonamiSCCI, FMPAC, etc...
    CARTRIDGE2_FORMAT:              "",

    // BASIC loading/typing commands. Not needed for AUTOEXEC.BAS, AUTOEXEC.BAT or Tape Images
    BASIC_RUN:                      "",
    BASIC_LOAD:                     "",
    BASIC_BRUN:                     "",
    BASIC_BLOAD:                    "",
    BASIC_TYPE:                     "",
    BASIC_ENTER:                    "",

    // Boot Options
    BOOT_KEYS:                      "",                         // Keys to keep pressed at every boot, comma separated
    BOOT_KEYS_ONCE:                 "",                         // Same as above, but only on first boot (do not use both)
    BOOT_KEYS_FRAMES:               -1,                         // -1: auto; > 0: number of frames for Boot Keys
    FAST_BOOT:                       0,                         // 0: off; 1: auto (same as Boot Keys frames); > 1: number of frames for 10x speed at boot

    // NetPlay
    NETPLAY_JOIN:                   "",                         // Join NetPlay! Session automatically
    NETPLAY_NICK:                   "",                         // NetPlay! Nickname, optional

    // Internal Machine configuration
    BIOS_SLOT:                      [0],                        // Slot to use when loading ROM of type
    CARTRIDGE1_SLOT:                [1],
    CARTRIDGE2_SLOT:                [2],
    EXPANSION1_SLOT:                [2, 1],
    EXPANSION2_SLOT:                [2, 2],
    BIOSEXT_SLOT:                   [3, 1],
    RAMMAPPER_SIZE:                 512,                        // 64, 128, 256, 512, 1024, 2048, 4096: RAM Mapper size in KB when active
    RAMNORMAL_SIZE:                 64,                         // 16..64: Normal RAM size in KB when active
    EXTENSIONS:                     { },                        // Extensions active. See Extensions Configuration. Use Presets to activate/deactivate
    VDP_TYPE:                       -1,                         // -1: auto; 1: V9918; 2: V9938; 3: V9958
    RTC_ACTIVE:                     -1,                         // -1: auto; 0: not present; 1: present

    // General options
    VOL:                            1.0,                        // Master Volume factor
    SPEED:                          100,                        // Default emulation speed (in %)
    AUTO_START:                     true,
    AUTO_POWER_ON_DELAY:            1200,                       // -1: no auto Power-ON; >= 0: wait specified milliseconds before Power-ON
    MEDIA_CHANGE_DISABLED:          false,
    SCREEN_RESIZE_DISABLED:         false,
    SCREEN_ELEMENT_ID:              "wmsx-screen",
    SCREEN_FULLSCREEN_MODE:         -1,                         // -2: disabled; -1: auto; 0: off; 1: on (Full Screen); 2: on (Full Windowed)
    SCREEN_FILTER_MODE:             -3,                         // -3: user set (default auto); -2: browser default; -1: auto; 0..3: smoothing level
    SCREEN_CRT_SCANLINES:           -1,                         // -1: user set (default off); 0: off; 1..10: level
    SCREEN_CRT_PHOSPHOR:            -1,                         // -1: auto; 0: off; 1: on
    SCREEN_DEFAULT_SCALE:           -1,                         // -1: auto; 0.5..N in 0.05 steps: scale
    SCREEN_DEFAULT_ASPECT:          1.14,                       // in 0.01 steps
    SCREEN_CONTROL_BAR:             1,                          // 0: on hover; 1: always
    SCREEN_FORCE_HOST_NATIVE_FPS:   -1,                         // -1: auto. Don't change! :-)
    SCREEN_VSYNC_MODE:              -2,                         // -2: user set (default auto); -1: disabled; 0: off; 1: auto (on when available)
    AUDIO_MONITOR_BUFFER_BASE:      -3,                         // -3: user set (default auto); -2: disable audio; -1: auto; 0: browser default; 1..6: base value. More buffer = more delay
    AUDIO_MONITOR_BUFFER_SIZE:      -1,                         // -1: auto; 256, 512, 1024, 2048, 4096, 8192, 16384: buffer size.     More buffer = more delay. Don't change! :-)
    AUDIO_SIGNAL_BUFFER_RATIO:      2,                          // Internal Audio Signal buffer based on Monitor buffer
    AUDIO_SIGNAL_ADD_FRAMES:        3,                          // Additional frames in internal Audio Signal buffer based on Monitor buffer
    JOYSTICKS_MODE:                 0,                          // -1: disabled; 0: auto; 1: auto (swapped)
    JOYKEYS_MODE:                   -1,                         // -1: disabled; 0: enabled at port 1; 1: enabled at port 2; 2: enabled at both ports; 3: enabled at both ports (swapped)
    MOUSE_MODE:                     -1,                         // -1: disabled; 0: auto; 1: enabled at port 1; 2: enabled at port 2
    TOUCH_MODE:                     0,                          // -1: disabled; 0: auto; 1: enabled at port 1; 2: enabled at port 2
    CPU_TURBO_MODE:                 0,                          // -1: off; 0: auto (software activation); (0..8]: CPU clock multiplier; 1: 2x multiplier (backward compatibility)
    VDP_TURBO_MODE:                 0,                          // -1: off; 0: auto (software activation); 2..8: VDP Command Engine clock multiplier; 9: instantaneous
    CPU_SOFT_TURBO_MULTI:           2,                          // 1..8 CPU clock multiplier when in AUTO mode and activated by software
    VDP_SOFT_TURBO_MULTI:           2,                          // 1..9 VDP Command Engine clock multiplier when in AUTO mode and activated by software
    KEYBOARD_JAPAN_LAYOUT:          1,                          // 0: ANSI; 1: JIS
    DEBUG_MODE:                     0,                          // 0: off; 1..7: debug mode. Don't change! :-)
    SPRITES_DEBUG_MODE:             0,                          // 0: off; 1: unlimited; 2: no collisions; 3: both. May cause problems :-)
    ROM_MAX_HASH_SIZE_KB:           3072,                       // Maximum ROM size for Hash calculation
    HARDDISK_MIN_SIZE_KB:           720,                        // Minimum file size to be accepted as HardDisk image (besides all valid Floppy formats)
    MEGARAM_SIZE:                   2048,                       // 256, 512, 1024, 2048: MegaRAM size in KB
    DISK_ROM_START_PAGE:            0,                          // 0..1: Change starting page for ROMs > 16KB when format is DiskPatch
    LIGHT_STATES:                   true,

    PSG_VOL:                        "f",                        // 0..f (hex digit):       PSG Volume adjust. Set globally or for each channel (4 values)
    PSG_PAN:                        "8",                        // 0; 1..8..f (hex digit): PSG PanPot adjust. Set globally or for each channel (4 values)
    SCC_VOL:                        "f",                        // SCC Volume adjust. Same as above (5 values)
    SCC_PAN:                        "8",                        // SCC PanPot adjust. Same as above (5 values)
    OPLL_VOL:                       "f",                        // OPLL Volume adjust. Same as above (14 values)
    OPLL_PAN:                       "8",                        // OPLL PanPot adjust. Same as above (14 values)

    IMAGES_PATH:                    window.WMSX_IMAGES_PATH || "images/",
    FILE_SEPARATOR_REGEX:           /[\\/?:]/,
    PAGE_BACK_CSS:                  "",                         // CSS to modify page background color. Applied to the body element

    WEB_EXTENSIONS_SERVER:          "webmsx.herokuapp.com",     // Server address for NetPlay!

    STATE_VERSION:                  530,
    STATE_VERSIONS_ACCEPTED:        { 9: true, 50: true, 51: true, 511: true, 520: true, 530: true },

    ALLOW_URL_PARAMETERS:           true                        // Allows user to override any of these parameters via URL query parameters

};

WMSX.MACHINES_CONFIG = {
    MSX2PP:   { DESCX: "MSX2++ Auto Detect",    AUTO_TYPE: 4 },
    MSX2P:    { DESCX: "MSX2+ Auto Detect",     AUTO_TYPE: 3 },
    MSX2:     { DESCX: "MSX2 Auto Detect",      AUTO_TYPE: 2 },
    MSX1:     { DESCX: "MSX Auto Detect",       AUTO_TYPE: 1 },
    MSX2PPA:  { DESC:  "MSX2++ America (NTSC)", TYPE: 4, PRESETS: "_MSX2PPA" },
    MSX2PPE:  { DESC:  "MSX2++ Europe (PAL)",   TYPE: 4, PRESETS: "_MSX2PPE" },
    MSX2PPJ:  { DESC:  "MSX2++ Japan (NTSC)",   TYPE: 4, PRESETS: "_MSX2PPJ", LANG: "ja", CODE_LABEL: "KANA" },
    MSX2PA:   { DESC:  "MSX2+ America (NTSC)",  TYPE: 3, PRESETS: "_MSX2PA" },
    MSX2PE:   { DESC:  "MSX2+ Europe (PAL)",    TYPE: 3, PRESETS: "_MSX2PE" },
    MSX2PJ:   { DESC:  "MSX2+ Japan (NTSC)",    TYPE: 3, PRESETS: "_MSX2PJ",  LANG: "ja", CODE_LABEL: "KANA" },
    MSX2A:    { DESC:  "MSX2 America (NTSC)",   TYPE: 2, PRESETS: "_MSX2A" },
    MSX2E:    { DESC:  "MSX2 Europe (PAL)",     TYPE: 2, PRESETS: "_MSX2E" },
    MSX2J:    { DESC:  "MSX2 Japan (NTSC)",     TYPE: 2, PRESETS: "_MSX2J",   LANG: "ja", CODE_LABEL: "KANA" },
    MSX1A:    { DESC:  "MSX America (NTSC)",    TYPE: 1, PRESETS: "_MSX1A" },
    MSX1E:    { DESC:  "MSX Europe (PAL)",      TYPE: 1, PRESETS: "_MSX1E" },
    MSX1J:    { DESC:  "MSX Japan (NTSC)",      TYPE: 1, PRESETS: "_MSX1J",   LANG: "ja", CODE_LABEL: "KANA" },
    EMPTY2PP: { DESCX: "MSX2++ Empty (NTSC)",   TYPE: 4, PRESETS: "_EMPTY" },
    EMPTY2P:  { DESCX: "MSX2+ Empty (NTSC)",    TYPE: 3, PRESETS: "_EMPTY" },
    EMPTY2:   { DESCX: "MSX2 Empty (NTSC)",     TYPE: 2, PRESETS: "_EMPTY" },
    EMPTY1:   { DESCX: "MSX Empty (NTSC)",      TYPE: 1, PRESETS: "_EMPTY" }
};

WMSX.EXTENSIONS_CONFIG = {
    HARDDISK:  { DESC: "Hard Drive",    URL: "@[Nextor16Patch].rom", SLOT: [2, 3], SLOT2: [3, 3], TOGGLE: "DISK", CHANGE: { RAMMAPPER: 1 } },
    DISK:      { DESC: "Floppy Drives", URL: "@[DiskPatch].rom",     SLOT: [2, 3], SLOT2: [3, 3], TOGGLE: "HARDDISK" },
    RAMMAPPER: { DESC: "RAM Mapper",    URL: "@[RAMMapper].rom",     SLOT: [3],                   MUTUAL: "RAMNORMAL" },
    RAMNORMAL: {                        URL: "@[RAMNormal].rom",     SLOT: [3],                   MUTUAL: "RAMMAPPER" },
    KANJI:     { DESC: "KANJI Fonts",   URL: "@[Kanji1].rom",        SLOT: [4, 0] },
    MSXMUSIC:  { DESC: "MSX-MUSIC",     URL: "@[MSXMUSIC].rom",      SLOT: [3, 2] },
    OPL4:      { DESC: "OPL4 Wave",     URL: "@[MoonSound].rom",     SLOT: [4, 1] },
    DOUBLEPSG: { DESC: "Double PSG",    URL: "@[ExtraPSG].rom",      SLOT: [4, 2] },
    SCCI:      { DESC: "Konami SCC+",   URL: "@[SCCIExpansion].rom", SLOT: [1],    SLOT2: [2], CHANGE: { SCC:  0, PAC: 0, MEGARAM: 0 } },
    SCC:       {                        URL: "@[SCCExpansion].rom",  SLOT: [1],    SLOT2: [2], CHANGE: { SCCI: 0, PAC: 0, MEGARAM: 0 } },
    PAC:       { DESC: "PAC SRAM",      URL: "@[PACExpansion].rom",  SLOT: [1],    SLOT2: [2], CHANGE: { SCCI: 0, SCC: 0, MEGARAM: 0 } },
    MEGARAM:   { DESC: "MegaRAM",       URL: "@[MegaRAM].rom",       SLOT: [1],    SLOT2: [2], CHANGE: { SCCI: 0, SCC: 0, PAC: 0 } }
};

WMSX.PRESETS_CONFIG = {

    // Extensions Options Presets. Must be specified in this order

    // Hard Disk: Nextor Removable Device
    HARDDISK:   { "EXTENSIONS.HARDDISK": 1, "EXTENSIONS.DISK": 2, _INCLUDE: "RAMMAPPER" },
    HARDDISKC:  { "EXTENSIONS.HARDDISK": 2, "EXTENSIONS.DISK": 1, _INCLUDE: "RAMMAPPER" },
    DOS2:       { "EXTENSIONS.HARDDISK": 1, "EXTENSIONS.DISK": 2, _INCLUDE: "RAMMAPPER" },
    NOHARDDISK: { "EXTENSIONS.HARDDISK": 0 },

    // Floppy Disk Drives
    DISK:     { "EXTENSIONS.DISK": 2 },
    DISKA:    { "EXTENSIONS.DISK": 1 },
    NODISK:   { "EXTENSIONS.DISK": 0 },

    // RAM type
    RAMMAPPER: { "EXTENSIONS.RAMMAPPER": 1, "EXTENSIONS.RAMNORMAL": 0 },
    RAMNORMAL: { "EXTENSIONS.RAMMAPPER": 0, "EXTENSIONS.RAMNORMAL": 1 },
    NORAM:     { "EXTENSIONS.RAMMAPPER": 0, "EXTENSIONS.RAMNORMAL": 0 },

    // Japanese character support
    KANJI:   { "EXTENSIONS.KANJI":  1 },
    NOKANJI: { "EXTENSIONS.KANJI":  0 },

    // Sound Devices
    MSXMUSIC:   { "EXTENSIONS.MSXMUSIC": 1 },
    NOMSXMUSIC: { "EXTENSIONS.MSXMUSIC": 0 },
    DOUBLEPSG:  { "EXTENSIONS.DOUBLEPSG": 1 },
    OPL4:       { "EXTENSIONS.OPL4": 1 },

    // Other Cartridge extensions

    SCCI:  { "EXTENSIONS.SCCI": 1 },
    SCCI2: { "EXTENSIONS.SCCI": 2 },

    SCC:  { "EXTENSIONS.SCC": 1 },
    SCC2: { "EXTENSIONS.SCC": 2 },

    PAC:  { "EXTENSIONS.PAC": 1 },
    PAC2: { "EXTENSIONS.PAC": 2 },

    MEGARAM:  { "EXTENSIONS.MEGARAM": 1 },
    MEGARAM2: { "EXTENSIONS.MEGARAM": 2 },

    // Configuration Helper Presets

    RAM128:      { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 128 },
    RAM256:      { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 256 },
    RAM512:      { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 512 },
    RAM1024:     { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 1024 },
    RAM2048:     { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 2048 },
    RAM4096:     { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 4096 },
    NORAMMAPPER: { _INCLUDE: "RAMNORMAL"},

    MEGARAM256:  { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 256 },
    MEGARAM512:  { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 512 },
    MEGARAM1024: { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 1024 },
    MEGARAM2048: { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 2048 },

    VSYNCDISABLED: { SCREEN_VSYNC_MODE: -1 },
    VSYNCOFF:      { SCREEN_VSYNC_MODE: 0 },
    VSYNCON:       { SCREEN_VSYNC_MODE: 1 },

    PSGSTEREO:  { PSG_PAN: "4c8" },
    PSGSTEREO2: { PSG_PAN: "8c4" },
    SCCSTEREO:  { SCC_PAN: "8c4c4" },
    SCCSTEREO2: { PSG_PAN: "4c4c8" },
    OPLLSTEREO: { OPLL_PAN: "4c4c4c4c488888" },
    ALLSTEREO:  { _INCLUDE: "PSGSTEREO,  SCCSTEREO,  OPLLSTEREO" },
    ALLSTEREO2: { _INCLUDE: "PSGSTEREO2, SCCSTEREO2, OPLLSTEREO" },

    // Alternate Slot Configuration: try to keep RAM alone on primary Slot 3

    ALTSLOTCONFIG: {
        EXPANSION1_SLOT:                   [3, 2],
        EXPANSION2_SLOT:                   [3, 3],
        "EXTENSIONS_CONFIG.MSXMUSIC.SLOT": [2, 2],
        "PRESETS_CONFIG.DISK":             { "EXTENSIONS.DISK": 1 }
    },

    // Boosted Machine Preset

    BOOSTED:    { CPU_TURBO_MODE: 3, VDP_TURBO_MODE: 3, BOOT_DURATION_AUTO: 165, _INCLUDE: "HARDDISK" },

    // MSX2++ Machine Presets. Do not use directly

    _MSX2PPA: {
        _INCLUDE:           "_MSX2PA, _MSX2PPBASE",
        BOOT_DURATION_AUTO: 165
    },
    _MSX2PPE: {
        _INCLUDE:           "_MSX2PE, _MSX2PPBASE",
        BOOT_DURATION_AUTO: 175
    },
    _MSX2PPJ: {
        _INCLUDE:           "_MSX2PJ, _MSX2PPBASE",
        BOOT_DURATION_AUTO: 165
    },
    _MSX2PPBASE: {
        _INCLUDE:           "HARDDISK",
        CPU_TURBO_MODE:     4,
        VDP_TURBO_MODE:     4
    },

    // MSX2+ Machine Presets. Do not use directly

    _MSX2PA: {
        _INCLUDE:           "_MSX2PBASE",
        SLOT0_URL:          "@MSX2P_NTSC.bios",
        SLOT31_URL:         "@MSX2PEXT_NTSC.bios | @KanjiBasic.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSX2PE: {
        _INCLUDE:           "_MSX2PBASE",
        SLOT0_URL:          "@MSX2P_PAL.bios",
        SLOT31_URL:         "@MSX2PEXT_PAL.bios | @KanjiBasic_PAL.bios",
        BOOT_DURATION_AUTO: 395
    },
    _MSX2PJ: {
        _INCLUDE:           "_MSX2PBASE, KANJI",
        SLOT0_URL:          "@MSX2P_JAP.bios",
        SLOT31_URL:         "@MSX2PEXT_JAP.bios | @KanjiBasic.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSX2PBASE: {
        _INCLUDE:           "_MSX2BASE"
    },

    // MSX2 Machine Presets. Do not use directly

    _MSX2A: {
        _INCLUDE:           "_MSX2BASE",
        SLOT0_URL:          "@MSX2_NTSC.bios",
        SLOT31_URL:         "@MSX2EXT_NTSC.bios",
        BOOT_DURATION_AUTO: 385
    },
    _MSX2E: {
        _INCLUDE:           "_MSX2BASE",
        SLOT0_URL:          "@MSX2_PAL.bios",
        SLOT31_URL:         "@MSX2EXT_PAL.bios",
        BOOT_DURATION_AUTO: 400
    },
    _MSX2J: {
        _INCLUDE:           "_MSX2BASE, KANJI",
        SLOT0_URL:          "@MSX2_JAP.bios",
        SLOT31_URL:         "@MSX2EXT_JAP.bios | @KanjiBasic.bios",
        BOOT_DURATION_AUTO: 360
    },
    _MSX2BASE: {
        _INCLUDE:           "_BASE, RAMMAPPER, DISK, MSXMUSIC, NOKANJI"
    },

    // MSX1 Machine Presets. Do not use directly

    _MSX1A: {
        _INCLUDE:           "_MSX1BASE",
        SLOT0_URL:          "@MSX1_NTSC.bios",
        BOOT_DURATION_AUTO: 375
    },
    _MSX1E: {
        _INCLUDE:           "_MSX1BASE",
        SLOT0_URL:          "@MSX1_PAL.bios",
        BOOT_DURATION_AUTO: 375
    },
    _MSX1J: {
        _INCLUDE:           "_MSX1BASE",
        SLOT0_URL:          "@MSX1_JAP.bios",
        BOOT_DURATION_AUTO: 230
    },
    _MSX1BASE: {
        _INCLUDE:           "_BASE, RAMNORMAL, DISK, NOHARDDISK, NOMSXMUSIC, NOKANJI",
        SLOT31_URL :        ""       // MSX1 has no BIOS Extension
    },

    // Base Machines Presets. Do not use directly

    _EMPTY: {
        _INCLUDE:           "_BASE",
        EXTENSIONS:         null,
        SLOT0P_URL:         "",
        SLOT1P_URL:         "",
        SLOT2P_URL:         "",
        SLOT3P_URL:         "",
        SLOT4P_URL:         ""      // Special Device I/O only slot
    },

    _BASE: {
        CPU_TURBO_MODE:     0,
        VDP_TURBO_MODE:     0
    }

};

WMSX.params = {};                   // Additional parameter overrides

wmsx = window.wmsx || {};           // Namespace

function onUpdateReady(){alert("A new version is available!\nWebMSX will restart..."),window.applicationCache.swapCache(),window.location.reload()}WMSXFullScreenSetup={apply:function(){if(!this.cssApplied){var a=document.createElement("style");a.type="text/css",a.innerHTML=this.css,document.head.appendChild(a),this.cssApplied=!0}document.documentElement.classList.toggle("wmsx-full-screen",this.shouldStartInFullScreen())},shouldStartInFullScreen:function(){return window.WMSX?WMSX.SCREEN_FULLSCREEN_MODE>=1||-1===WMSX.SCREEN_FULLSCREEN_MODE&&this.isBrowserStandaloneMode():this.isBrowserStandaloneMode()},isBrowserStandaloneMode:function(){return navigator.standalone||window.matchMedia("(display-mode: standalone)").matches},css:"html.wmsx-full-screen, html.wmsx-full-screen body {   background: black;}html.wmsx-full-screen .wmsx-full-screen-hidden {   display: none;}html:not(.wmsx-full-screen) .wmsx-full-screen-only {   display: none;}"},WMSXFullScreenSetup.apply(),wmsx.Util=new function(){"use strict";function a(a,b){return a.name<b.name?-1:a.name>b.name?1:0}function b(a){return a.stopPropagation(),a.cancelable&&a.preventDefault(),!1}this.log=function(a){var b=[">> wmsx:"];Array.prototype.push.apply(b,arguments),console.log.apply(console,b)},this.warning=function(a){var b=[">> wmsx Warning:"];Array.prototype.push.apply(b,arguments),console.warn.apply(console,b)},this.error=function(a){var b=[">> wmsx Error:"];Array.prototype.push.apply(b,arguments),console.error.apply(console,b)},this.message=function(a){console.info(a),alert(a)},this.asNormalArray=function(a,b,c){return!c&&a instanceof Array?a:c?this.arrayCopy(a,b,new Array(c)):this.arrayCopy(a,0,new Array(a.length))},this.arrayFill=function(a,b,c,d){if(a.fill)return a.fill(b,c,d);void 0===c&&(c=0);for(var e=(void 0===d?a.length:d)-1;e>=c;e-=1)a[e]=b;return a},this.arrayCopy=function(a,b,c,d,e){d=d||0;for(var f=e?b+e:a.length;b<f;)c[d++]=a[b++];return c},this.arrayAdd=function(a,b){return a[a.length]=b,a},this.arrayRemoveAllElement=function(a,b){for(var c;(c=a.indexOf(b))>=0;)a.splice(c,1);return a},this.arraysConcatAll=function(a){for(var b=0,c=0;c<a.length;++c)b+=a[c].length;var d=new a[0].constructor(b),e=0;for(c=0;c<a.length;++c)this.arrayCopy(a[c],0,d,e),e+=a[c].length;return d},this.int8BitArrayToByteString=function(a,b,c){if(null===a||void 0==a)return a;void 0===b&&(b=0),void 0===c&&(c=a.length-b);for(var d="",e=b,f=b+c;e<f;e+=1)d+=String.fromCharCode(255&a[e]);return d},this.byteStringToInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0;e<c;e+=1)d[e]=255&a.charCodeAt(e);return d}},this.byteStringToSignedInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0;e<c;e+=1){var f=255&a.charCodeAt(e);d[e]=f<128?f:f-256}return d}},this.int16BitArrayToByteString=function(a,b,c){if(null===a||void 0==a)return a;void 0===b&&(b=0),void 0===c&&(c=a.length-b);for(var d="",e=b,f=b+c;e<f;e+=1)d+=String.fromCharCode(255&a[e])+String.fromCharCode(a[e]>>8&255);return d},this.byteStringToInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length/2|0,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0,f=0;e<c;e+=1,f+=2)d[e]=255&a.charCodeAt(f)|(255&a.charCodeAt(f+1))<<8;return d}},this.byteStringToSignedInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length/2|0,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0,f=0;e<c;e+=1,f+=2){var g=255&a.charCodeAt(f)|(255&a.charCodeAt(f+1))<<8;d[e]=g<32768?g:g-65536}return d}},this.int32BitArrayToByteString=function(a,b,c){if(null===a||void 0==a)return a;void 0===b&&(b=0),void 0===c&&(c=a.length-b);for(var d="",e=b,f=b+c;e<f;e+=1)d+=String.fromCharCode(255&a[e])+String.fromCharCode(a[e]>>8&255)+String.fromCharCode(a[e]>>16&255)+String.fromCharCode(a[e]>>24&255);return d},this.byteStringToInt32BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length/4|0,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0,f=0;e<c;e+=1,f+=4)d[e]=255&a.charCodeAt(f)|(255&a.charCodeAt(f+1))<<8|(255&a.charCodeAt(f+2))<<16|(255&a.charCodeAt(f+3))<<24;return d}},this.storeInt8BitArrayToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?"":btoa(this.int8BitArrayToByteString(a))},this.restoreStringBase64ToInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToInt8BitArray(atob(a),b)},this.restoreStringBase64ToSignedInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToSignedInt8BitArray(atob(a),b)},this.compressInt8BitArrayToStringBase64=function(a,b,c){return null===a||void 0===a?a:0===a.length?"":(b||(b=a.length),c|=0,c||b<a.length?btoa(this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.compress(a.slice(c,c+b)))):btoa(this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.compress(a))))},this.uncompressStringBase64ToInt8BitArray=function(a,b,c,d,e){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){if(""==a)return[];var f=JSZip.compressions.DEFLATE.uncompress(atob(a));return b&&(c||b.length===f.length)?this.arrayCopy(f,0,b,e):this.arrayCopy(f,0,new(d||(b?b.constructor:Array))(f.length),e)}},this.storeInt16BitArrayToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?"":btoa(this.int16BitArrayToByteString(a))},this.restoreStringBase64ToInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToInt16BitArray(atob(a),b)},this.restoreStringBase64ToSignedInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToSignedInt16BitArray(atob(a),b)},this.storeInt32BitArrayToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?"":btoa(this.int32BitArrayToByteString(a))},this.restoreStringBase64ToInt32BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToInt32BitArray(atob(a),b)},this.compressStringToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?a:btoa(this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.compress(a)))},this.uncompressStringBase64ToString=function(a){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?a:this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.uncompress(atob(a)))},this.toHex2=function(a){if(null===a||void 0===a)return a;var b=a.toString(16).toUpperCase();return a>=0&&b.length%2?"0"+b:b},this.toHex4=function(a){if(null===a||void 0===a)return a;var b=a.toString(16).toUpperCase();if(a<0)return b;switch(b.length){case 4:return b;case 3:return"0"+b;case 2:return"00"+b;case 1:return"000"+b;default:return b}},this.escapeHtml=function(a){return a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;").replace(/\//g,"&#047;").replace(/\?/g,"&#063;").replace(/\-/g,"&#045;").replace(/\|/g,"&#0124;")},this.arrayFind=function(a,b){if(a.find)return a.find(b);for(var c=0,d=a.length;c<d;++c)if(b(a[c],c,a))return a[c]},this.arrayFindIndex=function(a,b){if(a.findIndex)return a.findIndex(b);for(var c=0,d=a.length;c<d;++c)if(b(a[c],c,a))return c;return-1},this.arrayIndexOfSubArray=function(a,b,c,d){var e=b.length,f=a.length,g=d||1;a:for(var h=c;h>=0&&h<f;h+=g){for(var i=0;i<e;i+=1)if(a[h+i]!==b[i])continue a;return h}return-1},this.stringCountOccurrences=function(a,b){
for(var c=0,d=0,e=a.length;d<e;++d)a[d]==b&&++c;return c},this.stringStartsWith=function(a,b){return a.startsWith?a.startsWith(b):a.substr(0,b.length)===b},this.stringEndsWith=function(a,b){return a.endsWith?a.endsWith(b):a.substr(a.length-b.length)===b},this.checkContentIsZIP=function(a){if(a&&80===a[0]&&75===a[1])try{return new JSZip(a)}catch(a){}return null},this.getZIPFilesSorted=function(b){var c=b.file(/.+/);return c.sort(a),c},this.checkContentIsGZIP=function(a){if(!a||31!==a[0]||139!==a[1]||8!==a[2])return null;try{var b=a[3],c=2&b,d=4&b,e=8&b,f=16&b,g=10;if(d){var h=a[g++]|a[g++]<<8;g+=h}if(e)for(;0!==a[g++];);if(f)for(;0!==a[g++];);return c&&(g+=2),JSZip.compressions.DEFLATE.uncompress(a.slice(g,a.length-8))}catch(a){return null}},this.leafFilename=function(a){if(!a)return"";for(var b=a.split(WMSX.FILE_SEPARATOR_REGEX),c=b.length-1;c>=0;--c){var d=b[c].trim();if(d)return d}return""},this.leafFilenameNoExtension=function(a){var b=this.leafFilename(a),c=b.lastIndexOf(".");return c<=0?b:b.substr(0,c).trim()},this.leafFilenameOnlyExtension=function(a){var b=this.leafFilename(a),c=b.lastIndexOf(".");return c<=0?"":b.substr(c+1).trim()},this.dump=function(a,b,c,d){var e="",f=b||0;d=d||1;for(var g=0;g<d;g++){for(var h=0;h<c;h++){var i=a[f++];e+=void 0!=i?i.toString(16,2)+" ":"? "}e+="   "}console.log(e)},this.dumpSlot=function(a,b,c,d){var e="",f=b||0;d=d||1;for(var g=0;g<d;g++){for(var h=0;h<c;h++){var i=a.read(f++);e+=void 0!=i?i.toString(16,2)+" ":"? "}e+="   "}console.log(e)},this.browserInfo=function(){if(this.browserInfoAvailable)return this.browserInfoAvailable;var a,b=navigator.userAgent,c=b.match(/(opera|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(c[1]))return a=/\brv[ :]+(\d+)/g.exec(b)||[],this.browserInfoAvailable={name:"IE",version:a[1]||""};if("Chrome"===c[1]&&null!=(a=b.match(/\bOPR\/(\d+)/)))return this.browserInfoAvailable={name:"Opera",version:a[1]};c=c[2]?[c[1],c[2]]:[navigator.appName,navigator.appVersion,"-?"],null!=(a=b.match(/version\/(\d+)/i))&&c.splice(1,1,a[1]);var d=c[0].toUpperCase();return this.browserInfoAvailable={name:this.isIOSDevice()||"NETSCAPE"===d?"SAFARI":d,version:c[1]}},this.userLanguage=function(){return(navigator.languages&&navigator.languages[0]||navigator.language||navigator.userLanguage||"en-US").trim()},this.browserCurrentURL=function(){return window.location.origin+window.location.pathname},this.isOfficialHomepage=function(){var a=window.location;return a&&"webmsx.org"===a.hostname.toLowerCase()&&(""===a.port||"80"===a.port)},this.isTouchDevice=function(){return WMSX.TOUCH_MODE>0||"ontouchstart"in window||navigator.maxTouchPoints>0||navigator.msMaxTouchPoints>0},this.isMobileDevice=function(){return this.isTouchDevice()&&/android|blackberry|iemobile|ipad|iphone|ipod|opera mini|webos/i.test(navigator.userAgent)},this.isIOSDevice=function(){return/ipad|iphone|ipod/i.test(navigator.userAgent)},this.isBrowserStandaloneMode=function(){return navigator.standalone||window.matchMedia("(display-mode: standalone)").matches},this.onTapOrMouseDown=function(a,b){this.addEventsListener(a,this.isTouchDevice()?"touchstart mousedown":"mousedown",b)},this.onTapOrMouseDownWithBlock=function(a,c){function d(a){return c(a),b(a)}this.addEventsListener(a,this.isTouchDevice()?"touchstart mousedown":"mousedown",d)},this.onTapOrMouseUpWithBlock=function(a,c){function d(a){return c(a),b(a)}this.addEventsListener(a,this.isTouchDevice()?"touchstart mouseup":"mouseup",d)},this.onTapOrMouseDownWithBlockUIG=function(a,c){function d(a){if("touchend"===a.type&&!a.target.wmsxNeedsUIG)return b(a);var d="touchstart"===a.type&&a.target.wmsxNeedsUIG,e="touchend"===a.type;return c(a,d,e),b(a)}this.addEventsListener(a,this.isTouchDevice()?"touchstart touchend mousedown":"mousedown",d)},this.blockEvent=b,this.addEventsListener=function(a,b,c,d){b=b.split(" ");for(var e=0;e<b.length;++e)b[e]&&a.addEventListener(b[e],c,d)},this.removeEventsListener=function(a,b,c,d){b=b.split(" ");for(var e=0;e<b.length;++e)b[e]&&a.removeEventListener(b[e],c,d)},this.insertCSS=function(a){var b=document.createElement("style");b.type="text/css",b.innerHTML=a,document.head.appendChild(b)},this.scaleToFitParentHeight=function(a,b,c){var d=b.clientHeight-c-20,e=a.clientHeight,f=e<d?1:d/e;a.style.transform="translateY(-"+(c/2|0)+"px) scale("+f.toFixed(4)+")"},this.scaleToFitParentWidth=function(a,b,c){var d=b.clientWidth-(2*c|0),e=a.clientWidth,f=e<d?1:d/e,g=e*f|0,h=Math.floor((d-g)/2+c);a.style.left=h+"px",a.style.right="initial",a.style.transform="scale("+f.toFixed(4)+")"},this.log2=function(a){return Math.log(a)/Math.log(2)},this.exp2=function(a){return Math.pow(2,a)},this.performanceNow=function(){return c?Date.now()-c:window.performance.now()},this.applyPatchObject=function(a,b){if(!a||a.constructor!==Object||b.constructor!==Object)return b;b._clear&&(a={});for(var c in b)if("_clear"!==c){var d=b[c];null===d?delete a[c]:a[c]=this.applyPatchObject(a[c],d)}return a};var c=window.performance&&window.performance.now?void 0:Date.now()},wmsx.Util.sha1Generator={hex_chr:"0123456789abcdef",hex:function(a){for(var b="",c=7;c>=0;c--)b+=this.hex_chr.charAt(a>>4*c&15);return b},str2blks_SHA1:function(a){for(var b=1+(a.length+8>>6),c=new Array(16*b),d=0;d<16*b;d++)c[d]=0;for(d=0;d<a.length;d++)c[d>>2]|=a.charCodeAt(d)<<24-d%4*8;return c[d>>2]|=128<<24-d%4*8,c[16*b-1]=8*a.length,c},add:function(a,b){var c=(65535&a)+(65535&b);return(a>>16)+(b>>16)+(c>>16)<<16|65535&c},rol:function(a,b){return a<<b|a>>>32-b},ft:function(a,b,c,d){return a<20?b&c|~b&d:a<40?b^c^d:a<60?b&c|b&d|c&d:b^c^d},kt:function(a){return a<20?1518500249:a<40?1859775393:a<60?-1894007588:-899497514},calcSHA1FromByteArray:function(a){for(var b="",c=0;c<a.length;c++)b+=String.fromCharCode(a[c]);return this.calcSHA1(b)},calcSHA1:function(a){if(""!=a){for(var b,c=this.str2blks_SHA1(a),d=new Array(80),e=1732584193,f=-271733879,g=-1732584194,h=271733878,i=-1009589776,j=0;j<c.length;j+=16){for(var k=e,l=f,m=g,n=h,o=i,p=0;p<80;p++)d[p]=p<16?c[j+p]:this.rol(d[p-3]^d[p-8]^d[p-14]^d[p-16],1),b=this.add(this.add(this.rol(e,5),this.ft(p,f,g,h)),this.add(this.add(i,d[p]),this.kt(p))),i=h,h=g,g=this.rol(f,30),f=e,e=b;e=this.add(e,k),f=this.add(f,l),g=this.add(g,m),h=this.add(h,n),i=this.add(i,o)}return this.hex(e)+this.hex(f)+this.hex(g)+this.hex(h)+this.hex(i)}return""}},function(a){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=a();else if("function"==typeof define&&define.amd)define([],a);else{var b;"undefined"!=typeof window?b=window:"undefined"!=typeof global?b=global:"undefined"!=typeof self&&(b=self),b.JSZip=a()}}(function(){return function a(b,c,d){function e(g,h){if(!c[g]){if(!b[g]){var i="function"==typeof require&&require;if(!h&&i)return i(g,!0);if(f)return f(g,!0);throw new Error("Cannot find module '"+g+"'")}var j=c[g]={exports:{}};b[g][0].call(j.exports,function(a){var c=b[g][1][a];return e(c||a)},j,j.exports,a,b,c,d)}return c[g].exports}for(var f="function"==typeof require&&require,g=0;g<d.length;g++)e(d[g]);return e}({1:[function(a,b,c){"use strict";var d="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";c.encode=function(a){for(var b,c,e,f,g,h,i,j="",k=0;k<a.length;)b=a.charCodeAt(k++),c=a.charCodeAt(k++),e=a.charCodeAt(k++),f=b>>2,g=(3&b)<<4|c>>4,h=(15&c)<<2|e>>6,i=63&e,isNaN(c)?h=i=64:isNaN(e)&&(i=64),j=j+d.charAt(f)+d.charAt(g)+d.charAt(h)+d.charAt(i);return j},c.decode=function(a){var b,c,e,f,g,h,i,j="",k=0;for(a=a.replace(/[^A-Za-z0-9\+\/\=]/g,"");k<a.length;)f=d.indexOf(a.charAt(k++)),g=d.indexOf(a.charAt(k++)),h=d.indexOf(a.charAt(k++)),i=d.indexOf(a.charAt(k++)),b=f<<2|g>>4,c=(15&g)<<4|h>>2,e=(3&h)<<6|i,j+=String.fromCharCode(b),64!=h&&(j+=String.fromCharCode(c)),64!=i&&(j+=String.fromCharCode(e));return j}},{}],2:[function(a,b){"use strict";function c(){this.compressedSize=0,this.uncompressedSize=0,this.crc32=0,
this.compressionMethod=null,this.compressedContent=null}c.prototype={getContent:function(){return null},getCompressedContent:function(){return null}},b.exports=c},{}],3:[function(a,b,c){"use strict";c.STORE={magic:"\0\0",compress:function(a){return a},uncompress:function(a){return a},compressInputType:null,uncompressInputType:null},c.DEFLATE=a("./flate")},{"./flate":8}],4:[function(a,b){"use strict";var c=a("./utils"),d=[0,1996959894,3993919788,2567524794,124634137,1886057615,3915621685,2657392035,249268274,2044508324,3772115230,2547177864,162941995,2125561021,3887607047,2428444049,498536548,1789927666,4089016648,2227061214,450548861,1843258603,4107580753,2211677639,325883990,1684777152,4251122042,2321926636,335633487,1661365465,4195302755,2366115317,997073096,1281953886,3579855332,2724688242,1006888145,1258607687,3524101629,2768942443,901097722,1119000684,3686517206,2898065728,853044451,1172266101,3705015759,2882616665,651767980,1373503546,3369554304,3218104598,565507253,1454621731,3485111705,3099436303,671266974,1594198024,3322730930,2970347812,795835527,1483230225,3244367275,3060149565,1994146192,31158534,2563907772,4023717930,1907459465,112637215,2680153253,3904427059,2013776290,251722036,2517215374,3775830040,2137656763,141376813,2439277719,3865271297,1802195444,476864866,2238001368,4066508878,1812370925,453092731,2181625025,4111451223,1706088902,314042704,2344532202,4240017532,1658658271,366619977,2362670323,4224994405,1303535960,984961486,2747007092,3569037538,1256170817,1037604311,2765210733,3554079995,1131014506,879679996,2909243462,3663771856,1141124467,855842277,2852801631,3708648649,1342533948,654459306,3188396048,3373015174,1466479909,544179635,3110523913,3462522015,1591671054,702138776,2966460450,3352799412,1504918807,783551873,3082640443,3233442989,3988292384,2596254646,62317068,1957810842,3939845945,2647816111,81470997,1943803523,3814918930,2489596804,225274430,2053790376,3826175755,2466906013,167816743,2097651377,4027552580,2265490386,503444072,1762050814,4150417245,2154129355,426522225,1852507879,4275313526,2312317920,282753626,1742555852,4189708143,2394877945,397917763,1622183637,3604390888,2714866558,953729732,1340076626,3518719985,2797360999,1068828381,1219638859,3624741850,2936675148,906185462,1090812512,3747672003,2825379669,829329135,1181335161,3412177804,3160834842,628085408,1382605366,3423369109,3138078467,570562233,1426400815,3317316542,2998733608,733239954,1555261956,3268935591,3050360625,752459403,1541320221,2607071920,3965973030,1969922972,40735498,2617837225,3943577151,1913087877,83908371,2512341634,3803740692,2075208622,213261112,2463272603,3855990285,2094854071,198958881,2262029012,4057260610,1759359992,534414190,2176718541,4139329115,1873836001,414664567,2282248934,4279200368,1711684554,285281116,2405801727,4167216745,1634467795,376229701,2685067896,3608007406,1308918612,956543938,2808555105,3495958263,1231636301,1047427035,2932959818,3654703836,1088359270,936918e3,2847714899,3736837829,1202900863,817233897,3183342108,3401237130,1404277552,615818150,3134207493,3453421203,1423857449,601450431,3009837614,3294710456,1567103746,711928724,3020668471,3272380065,1510334235,755167117];b.exports=function(a,b){if(void 0===a||!a.length)return 0;var e="string"!==c.getTypeOf(a);void 0===b&&(b=0);var f=0,g=0,h=0;b^=-1;for(var i=0,j=a.length;j>i;i++)h=e?a[i]:a.charCodeAt(i),g=255&(b^h),f=d[g],b=b>>>8^f;return-1^b}},{"./utils":21}],5:[function(a,b){"use strict";function c(){this.data=null,this.length=0,this.index=0}var d=a("./utils");c.prototype={checkOffset:function(a){this.checkIndex(this.index+a)},checkIndex:function(a){if(this.length<a||0>a)throw new Error("End of data reached (data length = "+this.length+", asked index = "+a+"). Corrupted zip ?")},setIndex:function(a){this.checkIndex(a),this.index=a},skip:function(a){this.setIndex(this.index+a)},byteAt:function(){},readInt:function(a){var b,c=0;for(this.checkOffset(a),b=this.index+a-1;b>=this.index;b--)c=(c<<8)+this.byteAt(b);return this.index+=a,c},readString:function(a){return d.transformTo("string",this.readData(a))},readData:function(){},lastIndexOfSignature:function(){},readDate:function(){var a=this.readInt(4);return new Date(1980+(a>>25&127),(a>>21&15)-1,a>>16&31,a>>11&31,a>>5&63,(31&a)<<1)}},b.exports=c},{"./utils":21}],6:[function(a,b,c){"use strict";c.base64=!1,c.binary=!1,c.dir=!1,c.createFolders=!1,c.date=null,c.compression=null,c.comment=null},{}],7:[function(a,b,c){"use strict";var d=a("./utils");c.string2binary=function(a){return d.string2binary(a)},c.string2Uint8Array=function(a){return d.transformTo("uint8array",a)},c.uint8Array2String=function(a){return d.transformTo("string",a)},c.string2Blob=function(a){var b=d.transformTo("arraybuffer",a);return d.arrayBuffer2Blob(b)},c.arrayBuffer2Blob=function(a){return d.arrayBuffer2Blob(a)},c.transformTo=function(a,b){return d.transformTo(a,b)},c.getTypeOf=function(a){return d.getTypeOf(a)},c.checkSupport=function(a){return d.checkSupport(a)},c.MAX_VALUE_16BITS=d.MAX_VALUE_16BITS,c.MAX_VALUE_32BITS=d.MAX_VALUE_32BITS,c.pretty=function(a){return d.pretty(a)},c.findCompression=function(a){return d.findCompression(a)},c.isRegExp=function(a){return d.isRegExp(a)}},{"./utils":21}],8:[function(a,b,c){"use strict";var d="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,e=a("pako");c.uncompressInputType=d?"uint8array":"array",c.compressInputType=d?"uint8array":"array",c.magic="\b\0",c.compress=function(a){return e.deflateRaw(a)},c.uncompress=function(a){return e.inflateRaw(a)}},{pako:24}],9:[function(a,b){"use strict";function c(a,b){return this instanceof c?(this.files={},this.comment=null,this.root="",a&&this.load(a,b),void(this.clone=function(){var a=new c;for(var b in this)"function"!=typeof this[b]&&(a[b]=this[b]);return a})):new c(a,b)}var d=a("./base64");c.prototype=a("./object"),c.prototype.load=a("./load"),c.support=a("./support"),c.defaults=a("./defaults"),c.utils=a("./deprecatedPublicUtils"),c.base64={encode:function(a){return d.encode(a)},decode:function(a){return d.decode(a)}},c.compressions=a("./compressions"),b.exports=c},{"./base64":1,"./compressions":3,"./defaults":6,"./deprecatedPublicUtils":7,"./load":10,"./object":13,"./support":17}],10:[function(a,b){"use strict";var c=a("./base64"),d=a("./zipEntries");b.exports=function(a,b){var e,f,g,h;for(b=b||{},b.base64&&(a=c.decode(a)),f=new d(a,b),e=f.files,g=0;g<e.length;g++)h=e[g],this.file(h.fileName,h.decompressed,{binary:!0,optimizedBinaryString:!0,date:h.date,dir:h.dir,comment:h.fileComment.length?h.fileComment:null,createFolders:b.createFolders});return f.zipComment.length&&(this.comment=f.zipComment),this}},{"./base64":1,"./zipEntries":22}],11:[function(a,b){(function(a){"use strict";b.exports=function(b,c){return new a(b,c)},b.exports.test=function(b){return a.isBuffer(b)}}).call(this,"undefined"!=typeof Buffer?Buffer:void 0)},{}],12:[function(a,b){"use strict";function c(a){this.data=a,this.length=this.data.length,this.index=0}var d=a("./uint8ArrayReader");c.prototype=new d,c.prototype.readData=function(a){this.checkOffset(a);var b=this.data.slice(this.index,this.index+a);return this.index+=a,b},b.exports=c},{"./uint8ArrayReader":18}],13:[function(a,b){"use strict";var c=a("./support"),d=a("./utils"),e=a("./crc32"),f=a("./signature"),g=a("./defaults"),h=a("./base64"),i=a("./compressions"),j=a("./compressedObject"),k=a("./nodeBuffer"),l=a("./utf8"),m=a("./stringWriter"),n=a("./uint8ArrayWriter"),o=function(a){if(a._data instanceof j&&(a._data=a._data.getContent(),a.options.binary=!0,a.options.base64=!1,"uint8array"===d.getTypeOf(a._data))){var b=a._data;a._data=new Uint8Array(b.length),0!==b.length&&a._data.set(b,0)}return a._data},p=function(a){var b=o(a);return"string"===d.getTypeOf(b)?!a.options.binary&&c.nodebuffer?k(b,"utf-8"):a.asBinary():b},q=function(a){var b=o(this)
;return null===b||void 0===b?"":(this.options.base64&&(b=h.decode(b)),b=a&&this.options.binary?A.utf8decode(b):d.transformTo("string",b),a||this.options.binary||(b=d.transformTo("string",A.utf8encode(b))),b)},r=function(a,b,c){this.name=a,this.dir=c.dir,this.date=c.date,this.comment=c.comment,this._data=b,this.options=c,this._initialMetadata={dir:c.dir,date:c.date}};r.prototype={asText:function(){return q.call(this,!0)},asBinary:function(){return q.call(this,!1)},asNodeBuffer:function(){var a=p(this);return d.transformTo("nodebuffer",a)},asUint8Array:function(){var a=p(this);return d.transformTo("uint8array",a)},asArrayBuffer:function(){return this.asUint8Array().buffer}};var s=function(a,b){var c,d="";for(c=0;b>c;c++)d+=String.fromCharCode(255&a),a>>>=8;return d},t=function(){var a,b,c={};for(a=0;a<arguments.length;a++)for(b in arguments[a])arguments[a].hasOwnProperty(b)&&void 0===c[b]&&(c[b]=arguments[a][b]);return c},u=function(a){return a=a||{},!0!==a.base64||null!==a.binary&&void 0!==a.binary||(a.binary=!0),a=t(a,g),a.date=a.date||new Date,null!==a.compression&&(a.compression=a.compression.toUpperCase()),a},v=function(a,b,c){var e,f=d.getTypeOf(b);if(c=u(c),c.createFolders&&(e=w(a))&&x.call(this,e,!0),c.dir||null===b||void 0===b)c.base64=!1,c.binary=!1,b=null;else if("string"===f)c.binary&&!c.base64&&!0!==c.optimizedBinaryString&&(b=d.string2binary(b));else{if(c.base64=!1,c.binary=!0,!(f||b instanceof j))throw new Error("The data of '"+a+"' is in an unsupported format !");"arraybuffer"===f&&(b=d.transformTo("uint8array",b))}var g=new r(a,b,c);return this.files[a]=g,g},w=function(a){"/"==a.slice(-1)&&(a=a.substring(0,a.length-1));var b=a.lastIndexOf("/");return b>0?a.substring(0,b):""},x=function(a,b){return"/"!=a.slice(-1)&&(a+="/"),b=void 0!==b&&b,this.files[a]||v.call(this,a,null,{dir:!0,createFolders:b}),this.files[a]},y=function(a,b){var c,f=new j;return a._data instanceof j?(f.uncompressedSize=a._data.uncompressedSize,f.crc32=a._data.crc32,0===f.uncompressedSize||a.dir?(b=i.STORE,f.compressedContent="",f.crc32=0):a._data.compressionMethod===b.magic?f.compressedContent=a._data.getCompressedContent():(c=a._data.getContent(),f.compressedContent=b.compress(d.transformTo(b.compressInputType,c)))):(c=p(a),(!c||0===c.length||a.dir)&&(b=i.STORE,c=""),f.uncompressedSize=c.length,f.crc32=e(c),f.compressedContent=b.compress(d.transformTo(b.compressInputType,c))),f.compressedSize=f.compressedContent.length,f.compressionMethod=b.magic,f},z=function(a,b,c,g){var h,i,j,k,m=(c.compressedContent,d.transformTo("string",l.utf8encode(b.name))),n=b.comment||"",o=d.transformTo("string",l.utf8encode(n)),p=m.length!==b.name.length,q=o.length!==n.length,r=b.options,t="",u="",v="";j=b._initialMetadata.dir!==b.dir?b.dir:r.dir,k=b._initialMetadata.date!==b.date?b.date:r.date,h=k.getHours(),h<<=6,h|=k.getMinutes(),h<<=5,h|=k.getSeconds()/2,i=k.getFullYear()-1980,i<<=4,i|=k.getMonth()+1,i<<=5,i|=k.getDate(),p&&(u=s(1,1)+s(e(m),4)+m,t+="up"+s(u.length,2)+u),q&&(v=s(1,1)+s(this.crc32(o),4)+o,t+="uc"+s(v.length,2)+v);var w="";return w+="\n\0",w+=p||q?"\0\b":"\0\0",w+=c.compressionMethod,w+=s(h,2),w+=s(i,2),w+=s(c.crc32,4),w+=s(c.compressedSize,4),w+=s(c.uncompressedSize,4),w+=s(m.length,2),w+=s(t.length,2),{fileRecord:f.LOCAL_FILE_HEADER+w+m+t,dirRecord:f.CENTRAL_FILE_HEADER+"\0"+w+s(o.length,2)+"\0\0\0\0"+(!0===j?"\0\0\0":"\0\0\0\0")+s(g,4)+m+t+o,compressedObject:c}},A={load:function(){throw new Error("Load method is not defined. Is the file jszip-load.js included ?")},filter:function(a){var b,c,d,e,f=[];for(b in this.files)this.files.hasOwnProperty(b)&&(d=this.files[b],e=new r(d.name,d._data,t(d.options)),c=b.slice(this.root.length,b.length),b.slice(0,this.root.length)===this.root&&a(c,e)&&f.push(e));return f},file:function(a,b,c){if(1===arguments.length){if(d.isRegExp(a)){var e=a;return this.filter(function(a,b){return!b.dir&&e.test(a)})}return this.filter(function(b,c){return!c.dir&&b===a})[0]||null}return a=this.root+a,v.call(this,a,b,c),this},folder:function(a){if(!a)return this;if(d.isRegExp(a))return this.filter(function(b,c){return c.dir&&a.test(b)});var b=this.root+a,c=x.call(this,b),e=this.clone();return e.root=c.name,e},remove:function(a){a=this.root+a;var b=this.files[a];if(b||("/"!=a.slice(-1)&&(a+="/"),b=this.files[a]),b&&!b.dir)delete this.files[a];else for(var c=this.filter(function(b,c){return c.name.slice(0,a.length)===a}),d=0;d<c.length;d++)delete this.files[c[d].name];return this},generate:function(a){a=t(a||{},{base64:!0,compression:"STORE",type:"base64",comment:null}),d.checkSupport(a.type);var b,c,e=[],g=0,j=0,k=d.transformTo("string",this.utf8encode(a.comment||this.comment||""));for(var l in this.files)if(this.files.hasOwnProperty(l)){var o=this.files[l],p=o.options.compression||a.compression.toUpperCase(),q=i[p];if(!q)throw new Error(p+" is not a valid compression method !");var r=y.call(this,o,q),u=z.call(this,l,o,r,g);g+=u.fileRecord.length+r.compressedSize,j+=u.dirRecord.length,e.push(u)}var v="";v=f.CENTRAL_DIRECTORY_END+"\0\0\0\0"+s(e.length,2)+s(e.length,2)+s(j,4)+s(g,4)+s(k.length,2)+k;var w=a.type.toLowerCase();for(b="uint8array"===w||"arraybuffer"===w||"blob"===w||"nodebuffer"===w?new n(g+j+v.length):new m(g+j+v.length),c=0;c<e.length;c++)b.append(e[c].fileRecord),b.append(e[c].compressedObject.compressedContent);for(c=0;c<e.length;c++)b.append(e[c].dirRecord);b.append(v);var x=b.finalize();switch(a.type.toLowerCase()){case"uint8array":case"arraybuffer":case"nodebuffer":return d.transformTo(a.type.toLowerCase(),x);case"blob":return d.arrayBuffer2Blob(d.transformTo("arraybuffer",x));case"base64":return a.base64?h.encode(x):x;default:return x}},crc32:function(a,b){return e(a,b)},utf8encode:function(a){return d.transformTo("string",l.utf8encode(a))},utf8decode:function(a){return l.utf8decode(a)}};b.exports=A},{"./base64":1,"./compressedObject":2,"./compressions":3,"./crc32":4,"./defaults":6,"./nodeBuffer":11,"./signature":14,"./stringWriter":16,"./support":17,"./uint8ArrayWriter":19,"./utf8":20,"./utils":21}],14:[function(a,b,c){"use strict";c.LOCAL_FILE_HEADER="PK",c.CENTRAL_FILE_HEADER="PK",c.CENTRAL_DIRECTORY_END="PK",c.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",c.ZIP64_CENTRAL_DIRECTORY_END="PK",c.DATA_DESCRIPTOR="PK\b"},{}],15:[function(a,b){"use strict";function c(a,b){this.data=a,b||(this.data=e.string2binary(this.data)),this.length=this.data.length,this.index=0}var d=a("./dataReader"),e=a("./utils");c.prototype=new d,c.prototype.byteAt=function(a){return this.data.charCodeAt(a)},c.prototype.lastIndexOfSignature=function(a){return this.data.lastIndexOf(a)},c.prototype.readData=function(a){this.checkOffset(a);var b=this.data.slice(this.index,this.index+a);return this.index+=a,b},b.exports=c},{"./dataReader":5,"./utils":21}],16:[function(a,b){"use strict";var c=a("./utils"),d=function(){this.data=[]};d.prototype={append:function(a){a=c.transformTo("string",a),this.data.push(a)},finalize:function(){return this.data.join("")}},b.exports=d},{"./utils":21}],17:[function(a,b,c){(function(a){"use strict";if(c.base64=!0,c.array=!0,c.string=!0,c.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,c.nodebuffer=void 0!==a,c.uint8array="undefined"!=typeof Uint8Array,"undefined"==typeof ArrayBuffer)c.blob=!1;else{var b=new ArrayBuffer(0);try{c.blob=0===new Blob([b],{type:"application/zip"}).size}catch(a){try{var d=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,e=new d;e.append(b),c.blob=0===e.getBlob("application/zip").size}catch(a){c.blob=!1}}}}).call(this,"undefined"!=typeof Buffer?Buffer:void 0)},{}],18:[function(a,b){"use strict";function c(a){a&&(this.data=a,this.length=this.data.length,this.index=0)}var d=a("./dataReader");c.prototype=new d,c.prototype.byteAt=function(a){return this.data[a]},c.prototype.lastIndexOfSignature=function(a){
for(var b=a.charCodeAt(0),c=a.charCodeAt(1),d=a.charCodeAt(2),e=a.charCodeAt(3),f=this.length-4;f>=0;--f)if(this.data[f]===b&&this.data[f+1]===c&&this.data[f+2]===d&&this.data[f+3]===e)return f;return-1},c.prototype.readData=function(a){if(this.checkOffset(a),0===a)return new Uint8Array(0);var b=this.data.subarray(this.index,this.index+a);return this.index+=a,b},b.exports=c},{"./dataReader":5}],19:[function(a,b){"use strict";var c=a("./utils"),d=function(a){this.data=new Uint8Array(a),this.index=0};d.prototype={append:function(a){0!==a.length&&(a=c.transformTo("uint8array",a),this.data.set(a,this.index),this.index+=a.length)},finalize:function(){return this.data}},b.exports=d},{"./utils":21}],20:[function(a,b,c){"use strict";for(var d=a("./utils"),e=a("./support"),f=a("./nodeBuffer"),g=new Array(256),h=0;256>h;h++)g[h]=h>=252?6:h>=248?5:h>=240?4:h>=224?3:h>=192?2:1;g[254]=g[254]=1;var i=function(a){var b,c,d,f,g,h=a.length,i=0;for(f=0;h>f;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),i+=128>c?1:2048>c?2:65536>c?3:4;for(b=e.uint8array?new Uint8Array(i):new Array(i),g=0,f=0;i>g;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),128>c?b[g++]=c:2048>c?(b[g++]=192|c>>>6,b[g++]=128|63&c):65536>c?(b[g++]=224|c>>>12,b[g++]=128|c>>>6&63,b[g++]=128|63&c):(b[g++]=240|c>>>18,b[g++]=128|c>>>12&63,b[g++]=128|c>>>6&63,b[g++]=128|63&c);return b},j=function(a,b){var c;for(b=b||a.length,b>a.length&&(b=a.length),c=b-1;c>=0&&128==(192&a[c]);)c--;return 0>c?b:0===c?b:c+g[a[c]]>b?c:b},k=function(a){var b,c,e,f,h=a.length,i=new Array(2*h);for(c=0,b=0;h>b;)if(128>(e=a[b++]))i[c++]=e;else if((f=g[e])>4)i[c++]=65533,b+=f-1;else{for(e&=2===f?31:3===f?15:7;f>1&&h>b;)e=e<<6|63&a[b++],f--;f>1?i[c++]=65533:65536>e?i[c++]=e:(e-=65536,i[c++]=55296|e>>10&1023,i[c++]=56320|1023&e)}return i.length!==c&&(i.subarray?i=i.subarray(0,c):i.length=c),d.applyFromCharCode(i)};c.utf8encode=function(a){return e.nodebuffer?f(a,"utf-8"):i(a)},c.utf8decode=function(a){if(e.nodebuffer)return d.transformTo("nodebuffer",a).toString("utf-8");a=d.transformTo(e.uint8array?"uint8array":"array",a);for(var b=[],c=0,f=a.length;f>c;){var g=j(a,Math.min(c+65536,f));b.push(k(e.uint8array?a.subarray(c,g):a.slice(c,g))),c=g}return b.join("")}},{"./nodeBuffer":11,"./support":17,"./utils":21}],21:[function(a,b,c){"use strict";function d(a){return a}function e(a,b){for(var c=0;c<a.length;++c)b[c]=255&a.charCodeAt(c);return b}function f(a){var b=65536,d=[],e=a.length,f=c.getTypeOf(a),g=0,h=!0;try{switch(f){case"uint8array":String.fromCharCode.apply(null,new Uint8Array(0));break;case"nodebuffer":String.fromCharCode.apply(null,j(0))}}catch(a){h=!1}if(!h){for(var i="",k=0;k<a.length;k++)i+=String.fromCharCode(a[k]);return i}for(;e>g&&b>1;)try{d.push("array"===f||"nodebuffer"===f?String.fromCharCode.apply(null,a.slice(g,Math.min(g+b,e))):String.fromCharCode.apply(null,a.subarray(g,Math.min(g+b,e)))),g+=b}catch(a){b=Math.floor(b/2)}return d.join("")}function g(a,b){for(var c=0;c<a.length;c++)b[c]=a[c];return b}var h=a("./support"),i=a("./compressions"),j=a("./nodeBuffer");c.string2binary=function(a){for(var b="",c=0;c<a.length;c++)b+=String.fromCharCode(255&a.charCodeAt(c));return b},c.arrayBuffer2Blob=function(a){c.checkSupport("blob");try{return new Blob([a],{type:"application/zip"})}catch(c){try{var b=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,d=new b;return d.append(a),d.getBlob("application/zip")}catch(a){throw new Error("Bug : can't construct the Blob.")}}},c.applyFromCharCode=f;var k={};k.string={string:d,array:function(a){return e(a,new Array(a.length))},arraybuffer:function(a){return k.string.uint8array(a).buffer},uint8array:function(a){return e(a,new Uint8Array(a.length))},nodebuffer:function(a){return e(a,j(a.length))}},k.array={string:f,array:d,arraybuffer:function(a){return new Uint8Array(a).buffer},uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return j(a)}},k.arraybuffer={string:function(a){return f(new Uint8Array(a))},array:function(a){return g(new Uint8Array(a),new Array(a.byteLength))},arraybuffer:d,uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return j(new Uint8Array(a))}},k.uint8array={string:f,array:function(a){return g(a,new Array(a.length))},arraybuffer:function(a){return a.buffer},uint8array:d,nodebuffer:function(a){return j(a)}},k.nodebuffer={string:f,array:function(a){return g(a,new Array(a.length))},arraybuffer:function(a){return k.nodebuffer.uint8array(a).buffer},uint8array:function(a){return g(a,new Uint8Array(a.length))},nodebuffer:d},c.transformTo=function(a,b){if(b||(b=""),!a)return b;c.checkSupport(a);var d=c.getTypeOf(b);return k[d][a](b)},c.getTypeOf=function(a){return"string"==typeof a?"string":"[object Array]"===Object.prototype.toString.call(a)?"array":h.nodebuffer&&j.test(a)?"nodebuffer":h.uint8array&&a instanceof Uint8Array?"uint8array":h.arraybuffer&&a instanceof ArrayBuffer?"arraybuffer":void 0},c.checkSupport=function(a){if(!h[a.toLowerCase()])throw new Error(a+" is not supported by this browser")},c.MAX_VALUE_16BITS=65535,c.MAX_VALUE_32BITS=-1,c.pretty=function(a){var b,c,d="";for(c=0;c<(a||"").length;c++)b=a.charCodeAt(c),d+="\\x"+(16>b?"0":"")+b.toString(16).toUpperCase();return d},c.findCompression=function(a){for(var b in i)if(i.hasOwnProperty(b)&&i[b].magic===a)return i[b];return null},c.isRegExp=function(a){return"[object RegExp]"===Object.prototype.toString.call(a)}},{"./compressions":3,"./nodeBuffer":11,"./support":17}],22:[function(a,b){"use strict";function c(a,b){this.files=[],this.loadOptions=b,a&&this.load(a)}var d=a("./stringReader"),e=a("./nodeBufferReader"),f=a("./uint8ArrayReader"),g=a("./utils"),h=a("./signature"),i=a("./zipEntry"),j=a("./support"),k=a("./object");c.prototype={checkSignature:function(a){var b=this.reader.readString(4);if(b!==a)throw new Error("Corrupted zip or bug : unexpected signature ("+g.pretty(b)+", expected "+g.pretty(a)+")")},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2),this.zipComment=this.reader.readString(this.zipCommentLength),this.zipComment=k.utf8decode(this.zipComment)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.versionMadeBy=this.reader.readString(2),this.versionNeeded=this.reader.readInt(2),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var a,b,c,d=this.zip64EndOfCentralSize-44;d>0;)a=this.reader.readInt(2),b=this.reader.readInt(4),c=this.reader.readString(b),this.zip64ExtensibleData[a]={id:a,length:b,value:c}},readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),this.disksCount>1)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var a,b;for(a=0;a<this.files.length;a++)b=this.files[a],this.reader.setIndex(b.localHeaderOffset),this.checkSignature(h.LOCAL_FILE_HEADER),b.readLocalPart(this.reader),b.handleUTF8()},readCentralDir:function(){var a;for(this.reader.setIndex(this.centralDirOffset);this.reader.readString(4)===h.CENTRAL_FILE_HEADER;)a=new i({zip64:this.zip64},this.loadOptions),
a.readCentralPart(this.reader),this.files.push(a)},readEndOfCentral:function(){var a=this.reader.lastIndexOfSignature(h.CENTRAL_DIRECTORY_END);if(-1===a)throw new Error("Corrupted zip : can't find end of central directory");if(this.reader.setIndex(a),this.checkSignature(h.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===g.MAX_VALUE_16BITS||this.diskWithCentralDirStart===g.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===g.MAX_VALUE_16BITS||this.centralDirRecords===g.MAX_VALUE_16BITS||this.centralDirSize===g.MAX_VALUE_32BITS||this.centralDirOffset===g.MAX_VALUE_32BITS){if(this.zip64=!0,-1===(a=this.reader.lastIndexOfSignature(h.ZIP64_CENTRAL_DIRECTORY_LOCATOR)))throw new Error("Corrupted zip : can't find the ZIP64 end of central directory locator");this.reader.setIndex(a),this.checkSignature(h.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(h.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}},prepareReader:function(a){var b=g.getTypeOf(a);this.reader="string"!==b||j.uint8array?"nodebuffer"===b?new e(a):new f(g.transformTo("uint8array",a)):new d(a,this.loadOptions.optimizedBinaryString)},load:function(a){this.prepareReader(a),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},b.exports=c},{"./nodeBufferReader":12,"./object":13,"./signature":14,"./stringReader":15,"./support":17,"./uint8ArrayReader":18,"./utils":21,"./zipEntry":23}],23:[function(a,b){"use strict";function c(a,b){this.options=a,this.loadOptions=b}var d=a("./stringReader"),e=a("./utils"),f=a("./compressedObject"),g=a("./object");c.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},prepareCompressedContent:function(a,b,c){return function(){var d=a.index;a.setIndex(b);var e=a.readData(c);return a.setIndex(d),e}},prepareContent:function(a,b,c,d,f){return function(){var a=e.transformTo(d.uncompressInputType,this.getCompressedContent()),b=d.uncompress(a);if(b.length!==f)throw new Error("Bug : uncompressed data size mismatch");return b}},readLocalPart:function(a){var b,c;if(a.skip(22),this.fileNameLength=a.readInt(2),c=a.readInt(2),this.fileName=a.readString(this.fileNameLength),a.skip(c),-1==this.compressedSize||-1==this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize == -1 || uncompressedSize == -1)");if(null===(b=e.findCompression(this.compressionMethod)))throw new Error("Corrupted zip : compression "+e.pretty(this.compressionMethod)+" unknown (inner file : "+this.fileName+")");if(this.decompressed=new f,this.decompressed.compressedSize=this.compressedSize,this.decompressed.uncompressedSize=this.uncompressedSize,this.decompressed.crc32=this.crc32,this.decompressed.compressionMethod=this.compressionMethod,this.decompressed.getCompressedContent=this.prepareCompressedContent(a,a.index,this.compressedSize,b),this.decompressed.getContent=this.prepareContent(a,a.index,this.compressedSize,b,this.uncompressedSize),this.loadOptions.checkCRC32&&(this.decompressed=e.transformTo("string",this.decompressed.getContent()),g.crc32(this.decompressed)!==this.crc32))throw new Error("Corrupted zip : CRC32 mismatch")},readCentralPart:function(a){if(this.versionMadeBy=a.readString(2),this.versionNeeded=a.readInt(2),this.bitFlag=a.readInt(2),this.compressionMethod=a.readString(2),this.date=a.readDate(),this.crc32=a.readInt(4),this.compressedSize=a.readInt(4),this.uncompressedSize=a.readInt(4),this.fileNameLength=a.readInt(2),this.extraFieldsLength=a.readInt(2),this.fileCommentLength=a.readInt(2),this.diskNumberStart=a.readInt(2),this.internalFileAttributes=a.readInt(2),this.externalFileAttributes=a.readInt(4),this.localHeaderOffset=a.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");this.fileName=a.readString(this.fileNameLength),this.readExtraFields(a),this.parseZIP64ExtraField(a),this.fileComment=a.readString(this.fileCommentLength),this.dir=!!(16&this.externalFileAttributes)},parseZIP64ExtraField:function(){if(this.extraFields[1]){var a=new d(this.extraFields[1].value);this.uncompressedSize===e.MAX_VALUE_32BITS&&(this.uncompressedSize=a.readInt(8)),this.compressedSize===e.MAX_VALUE_32BITS&&(this.compressedSize=a.readInt(8)),this.localHeaderOffset===e.MAX_VALUE_32BITS&&(this.localHeaderOffset=a.readInt(8)),this.diskNumberStart===e.MAX_VALUE_32BITS&&(this.diskNumberStart=a.readInt(4))}},readExtraFields:function(a){var b,c,d,e=a.index;for(this.extraFields=this.extraFields||{};a.index<e+this.extraFieldsLength;)b=a.readInt(2),c=a.readInt(2),d=a.readString(c),this.extraFields[b]={id:b,length:c,value:d}},handleUTF8:function(){if(this.useUTF8())this.fileName=g.utf8decode(this.fileName),this.fileComment=g.utf8decode(this.fileComment);else{var a=this.findExtraFieldUnicodePath();null!==a&&(this.fileName=a);var b=this.findExtraFieldUnicodeComment();null!==b&&(this.fileComment=b)}},findExtraFieldUnicodePath:function(){var a=this.extraFields[28789];if(a){var b=new d(a.value);return 1!==b.readInt(1)?null:g.crc32(this.fileName)!==b.readInt(4)?null:g.utf8decode(b.readString(a.length-5))}return null},findExtraFieldUnicodeComment:function(){var a=this.extraFields[25461];if(a){var b=new d(a.value);return 1!==b.readInt(1)?null:g.crc32(this.fileComment)!==b.readInt(4)?null:g.utf8decode(b.readString(a.length-5))}return null}},b.exports=c},{"./compressedObject":2,"./object":13,"./stringReader":15,"./utils":21}],24:[function(a,b){"use strict";var c=a("./lib/utils/common").assign,d=a("./lib/deflate"),e=a("./lib/inflate"),f=a("./lib/zlib/constants"),g={};c(g,d,e,f),b.exports=g},{"./lib/deflate":25,"./lib/inflate":26,"./lib/utils/common":27,"./lib/zlib/constants":30}],25:[function(a,b,c){"use strict";function d(a,b){var c=new l(b);if(c.push(a,!0),c.err)throw c.msg;return c.result}function e(a,b){return b=b||{},b.raw=!0,d(a,b)}function f(a,b){return b=b||{},b.gzip=!0,d(a,b)}var g=a("./zlib/deflate.js"),h=a("./utils/common"),i=a("./utils/strings"),j=a("./zlib/messages"),k=a("./zlib/zstream"),l=function(a){this.options=h.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},a||{});var b=this.options;b.raw&&b.windowBits>0?b.windowBits=-b.windowBits:b.gzip&&b.windowBits>0&&b.windowBits<16&&(b.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new k,this.strm.avail_out=0;var c=g.deflateInit2(this.strm,b.level,b.method,b.windowBits,b.memLevel,b.strategy);if(0!==c)throw new Error(j[c]);b.header&&g.deflateSetHeader(this.strm,b.header)};l.prototype.push=function(a,b){var c,d,e=this.strm,f=this.options.chunkSize;if(this.ended)return!1;d=b===~~b?b:!0===b?4:0,e.input="string"==typeof a?i.string2buf(a):a,e.next_in=0,e.avail_in=e.input.length;do{if(0===e.avail_out&&(e.output=new h.Buf8(f),e.next_out=0,e.avail_out=f),1!==(c=g.deflate(e,d))&&0!==c)return this.onEnd(c),this.ended=!0,!1;(0===e.avail_out||0===e.avail_in&&4===d)&&this.onData("string"===this.options.to?i.buf2binstring(h.shrinkBuf(e.output,e.next_out)):h.shrinkBuf(e.output,e.next_out))}while((e.avail_in>0||0===e.avail_out)&&1!==c);return 4!==d||(c=g.deflateEnd(this.strm),this.onEnd(c),this.ended=!0,0===c)},l.prototype.onData=function(a){this.chunks.push(a)},l.prototype.onEnd=function(a){0===a&&(this.result="string"===this.options.to?this.chunks.join(""):h.flattenChunks(this.chunks)),this.chunks=[],this.err=a,this.msg=this.strm.msg},c.Deflate=l,c.deflate=d,c.deflateRaw=e,c.gzip=f},{"./utils/common":27,"./utils/strings":28,"./zlib/deflate.js":32,"./zlib/messages":37,"./zlib/zstream":39}],26:[function(a,b,c){"use strict";function d(a,b){var c=new m(b);if(c.push(a,!0),c.err)throw c.msg;return c.result}function e(a,b){return b=b||{},b.raw=!0,d(a,b)}
var f=a("./zlib/inflate.js"),g=a("./utils/common"),h=a("./utils/strings"),i=a("./zlib/constants"),j=a("./zlib/messages"),k=a("./zlib/zstream"),l=a("./zlib/gzheader"),m=function(a){this.options=g.assign({chunkSize:16384,windowBits:0,to:""},a||{});var b=this.options;b.raw&&b.windowBits>=0&&b.windowBits<16&&(b.windowBits=-b.windowBits,0===b.windowBits&&(b.windowBits=-15)),!(b.windowBits>=0&&b.windowBits<16)||a&&a.windowBits||(b.windowBits+=32),b.windowBits>15&&b.windowBits<48&&0==(15&b.windowBits)&&(b.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new k,this.strm.avail_out=0;var c=f.inflateInit2(this.strm,b.windowBits);if(c!==i.Z_OK)throw new Error(j[c]);this.header=new l,f.inflateGetHeader(this.strm,this.header)};m.prototype.push=function(a,b){var c,d,e,j,k,l=this.strm,m=this.options.chunkSize;if(this.ended)return!1;d=b===~~b?b:!0===b?i.Z_FINISH:i.Z_NO_FLUSH,l.input="string"==typeof a?h.binstring2buf(a):a,l.next_in=0,l.avail_in=l.input.length;do{if(0===l.avail_out&&(l.output=new g.Buf8(m),l.next_out=0,l.avail_out=m),(c=f.inflate(l,i.Z_NO_FLUSH))!==i.Z_STREAM_END&&c!==i.Z_OK)return this.onEnd(c),this.ended=!0,!1;l.next_out&&(0===l.avail_out||c===i.Z_STREAM_END||0===l.avail_in&&d===i.Z_FINISH)&&("string"===this.options.to?(e=h.utf8border(l.output,l.next_out),j=l.next_out-e,k=h.buf2string(l.output,e),l.next_out=j,l.avail_out=m-j,j&&g.arraySet(l.output,l.output,e,j,0),this.onData(k)):this.onData(g.shrinkBuf(l.output,l.next_out)))}while(l.avail_in>0&&c!==i.Z_STREAM_END);return c===i.Z_STREAM_END&&(d=i.Z_FINISH),d!==i.Z_FINISH||(c=f.inflateEnd(this.strm),this.onEnd(c),this.ended=!0,c===i.Z_OK)},m.prototype.onData=function(a){this.chunks.push(a)},m.prototype.onEnd=function(a){a===i.Z_OK&&(this.result="string"===this.options.to?this.chunks.join(""):g.flattenChunks(this.chunks)),this.chunks=[],this.err=a,this.msg=this.strm.msg},c.Inflate=m,c.inflate=d,c.inflateRaw=e,c.ungzip=d},{"./utils/common":27,"./utils/strings":28,"./zlib/constants":30,"./zlib/gzheader":33,"./zlib/inflate.js":35,"./zlib/messages":37,"./zlib/zstream":39}],27:[function(a,b,c){"use strict";var d="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;c.assign=function(a){for(var b=Array.prototype.slice.call(arguments,1);b.length;){var c=b.shift();if(c){if("object"!=typeof c)throw new TypeError(c+"must be non-object");for(var d in c)c.hasOwnProperty(d)&&(a[d]=c[d])}}return a},c.shrinkBuf=function(a,b){return a.length===b?a:a.subarray?a.subarray(0,b):(a.length=b,a)};var e={arraySet:function(a,b,c,d,e){if(b.subarray&&a.subarray)return void a.set(b.subarray(c,c+d),e);for(var f=0;d>f;f++)a[e+f]=b[c+f]},flattenChunks:function(a){var b,c,d,e,f,g;for(d=0,b=0,c=a.length;c>b;b++)d+=a[b].length;for(g=new Uint8Array(d),e=0,b=0,c=a.length;c>b;b++)f=a[b],g.set(f,e),e+=f.length;return g}},f={arraySet:function(a,b,c,d,e){for(var f=0;d>f;f++)a[e+f]=b[c+f]},flattenChunks:function(a){return[].concat.apply([],a)}};c.setTyped=function(a){a?(c.Buf8=Uint8Array,c.Buf16=Uint16Array,c.Buf32=Int32Array,c.assign(c,e)):(c.Buf8=Array,c.Buf16=Array,c.Buf32=Array,c.assign(c,f))},c.setTyped(d)},{}],28:[function(a,b,c){"use strict";function d(a,b){if(65537>b&&(a.subarray&&g||!a.subarray&&f))return String.fromCharCode.apply(null,e.shrinkBuf(a,b));for(var c="",d=0;b>d;d++)c+=String.fromCharCode(a[d]);return c}var e=a("./common"),f=!0,g=!0;try{String.fromCharCode.apply(null,[0])}catch(a){f=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(a){g=!1}for(var h=new e.Buf8(256),i=0;256>i;i++)h[i]=i>=252?6:i>=248?5:i>=240?4:i>=224?3:i>=192?2:1;h[254]=h[254]=1,c.string2buf=function(a){var b,c,d,f,g,h=a.length,i=0;for(f=0;h>f;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),i+=128>c?1:2048>c?2:65536>c?3:4;for(b=new e.Buf8(i),g=0,f=0;i>g;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),128>c?b[g++]=c:2048>c?(b[g++]=192|c>>>6,b[g++]=128|63&c):65536>c?(b[g++]=224|c>>>12,b[g++]=128|c>>>6&63,b[g++]=128|63&c):(b[g++]=240|c>>>18,b[g++]=128|c>>>12&63,b[g++]=128|c>>>6&63,b[g++]=128|63&c);return b},c.buf2binstring=function(a){return d(a,a.length)},c.binstring2buf=function(a){for(var b=new e.Buf8(a.length),c=0,d=b.length;d>c;c++)b[c]=a.charCodeAt(c);return b},c.buf2string=function(a,b){var c,e,f,g,i=b||a.length,j=new Array(2*i);for(e=0,c=0;i>c;)if(128>(f=a[c++]))j[e++]=f;else if((g=h[f])>4)j[e++]=65533,c+=g-1;else{for(f&=2===g?31:3===g?15:7;g>1&&i>c;)f=f<<6|63&a[c++],g--;g>1?j[e++]=65533:65536>f?j[e++]=f:(f-=65536,j[e++]=55296|f>>10&1023,j[e++]=56320|1023&f)}return d(j,e)},c.utf8border=function(a,b){var c;for(b=b||a.length,b>a.length&&(b=a.length),c=b-1;c>=0&&128==(192&a[c]);)c--;return 0>c?b:0===c?b:c+h[a[c]]>b?c:b}},{"./common":27}],29:[function(a,b){"use strict";function c(a,b,c,d){for(var e=65535&a|0,f=a>>>16&65535|0,g=0;0!==c;){g=c>2e3?2e3:c,c-=g;do{e=e+b[d++]|0,f=f+e|0}while(--g);e%=65521,f%=65521}return e|f<<16|0}b.exports=c},{}],30:[function(a,b){b.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],31:[function(a,b){"use strict";function c(a,b,c,e){var f=d,g=e+c;a^=-1;for(var h=e;g>h;h++)a=a>>>8^f[255&(a^b[h])];return-1^a}var d=function(){for(var a,b=[],c=0;256>c;c++){a=c;for(var d=0;8>d;d++)a=1&a?3988292384^a>>>1:a>>>1;b[c]=a}return b}();b.exports=c},{}],32:[function(a,b,c){"use strict";function d(a,b){return a.msg=G[b],b}function e(a){return(a<<1)-(a>4?9:0)}function f(a){for(var b=a.length;--b>=0;)a[b]=0}function g(a){var b=a.state,c=b.pending;c>a.avail_out&&(c=a.avail_out),0!==c&&(C.arraySet(a.output,b.pending_buf,b.pending_out,c,a.next_out),a.next_out+=c,b.pending_out+=c,a.total_out+=c,a.avail_out-=c,b.pending-=c,0===b.pending&&(b.pending_out=0))}function h(a,b){D._tr_flush_block(a,a.block_start>=0?a.block_start:-1,a.strstart-a.block_start,b),a.block_start=a.strstart,g(a.strm)}function i(a,b){a.pending_buf[a.pending++]=b}function j(a,b){a.pending_buf[a.pending++]=b>>>8&255,a.pending_buf[a.pending++]=255&b}function k(a,b,c,d){var e=a.avail_in;return e>d&&(e=d),0===e?0:(a.avail_in-=e,C.arraySet(b,a.input,a.next_in,e,c),1===a.state.wrap?a.adler=E(a.adler,b,e,c):2===a.state.wrap&&(a.adler=F(a.adler,b,e,c)),a.next_in+=e,a.total_in+=e,e)}function l(a,b){var c,d,e=a.max_chain_length,f=a.strstart,g=a.prev_length,h=a.nice_match,i=a.strstart>a.w_size-ha?a.strstart-(a.w_size-ha):0,j=a.window,k=a.w_mask,l=a.prev,m=a.strstart+ga,n=j[f+g-1],o=j[f+g];a.prev_length>=a.good_match&&(e>>=2),h>a.lookahead&&(h=a.lookahead);do{if(c=b,j[c+g]===o&&j[c+g-1]===n&&j[c]===j[f]&&j[++c]===j[f+1]){f+=2,c++;do{}while(j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&m>f);if(d=ga-(m-f),f=m-ga,d>g){if(a.match_start=b,g=d,d>=h)break;n=j[f+g-1],o=j[f+g]}}}while((b=l[b&k])>i&&0!=--e);return g<=a.lookahead?g:a.lookahead}function m(a){var b,c,d,e,f,g=a.w_size;do{if(e=a.window_size-a.lookahead-a.strstart,a.strstart>=g+(g-ha)){C.arraySet(a.window,a.window,g,g,0),a.match_start-=g,a.strstart-=g,a.block_start-=g,c=a.hash_size,b=c;do{d=a.head[--b],a.head[b]=d>=g?d-g:0}while(--c);c=g,b=c;do{d=a.prev[--b],a.prev[b]=d>=g?d-g:0}while(--c);e+=g}if(0===a.strm.avail_in)break;if(c=k(a.strm,a.window,a.strstart+a.lookahead,e),a.lookahead+=c,a.lookahead+a.insert>=fa)for(f=a.strstart-a.insert,a.ins_h=a.window[f],a.ins_h=(a.ins_h<<a.hash_shift^a.window[f+1])&a.hash_mask;a.insert&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[f+fa-1])&a.hash_mask,
a.prev[f&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=f,f++,a.insert--,!(a.lookahead+a.insert<fa)););}while(a.lookahead<ha&&0!==a.strm.avail_in)}function n(a,b){var c=65535;for(c>a.pending_buf_size-5&&(c=a.pending_buf_size-5);;){if(a.lookahead<=1){if(m(a),0===a.lookahead&&b===H)return qa;if(0===a.lookahead)break}a.strstart+=a.lookahead,a.lookahead=0;var d=a.block_start+c;if((0===a.strstart||a.strstart>=d)&&(a.lookahead=a.strstart-d,a.strstart=d,h(a,!1),0===a.strm.avail_out))return qa;if(a.strstart-a.block_start>=a.w_size-ha&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=0,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):(a.strstart>a.block_start&&(h(a,!1),a.strm.avail_out),qa)}function o(a,b){for(var c,d;;){if(a.lookahead<ha){if(m(a),a.lookahead<ha&&b===H)return qa;if(0===a.lookahead)break}if(c=0,a.lookahead>=fa&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart),0!==c&&a.strstart-c<=a.w_size-ha&&(a.match_length=l(a,c)),a.match_length>=fa)if(d=D._tr_tally(a,a.strstart-a.match_start,a.match_length-fa),a.lookahead-=a.match_length,a.match_length<=a.max_lazy_match&&a.lookahead>=fa){a.match_length--;do{a.strstart++,a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart}while(0!=--a.match_length);a.strstart++}else a.strstart+=a.match_length,a.match_length=0,a.ins_h=a.window[a.strstart],a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+1])&a.hash_mask;else d=D._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++;if(d&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=a.strstart<fa-1?a.strstart:fa-1,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function p(a,b){for(var c,d,e;;){if(a.lookahead<ha){if(m(a),a.lookahead<ha&&b===H)return qa;if(0===a.lookahead)break}if(c=0,a.lookahead>=fa&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart),a.prev_length=a.match_length,a.prev_match=a.match_start,a.match_length=fa-1,0!==c&&a.prev_length<a.max_lazy_match&&a.strstart-c<=a.w_size-ha&&(a.match_length=l(a,c),a.match_length<=5&&(a.strategy===S||a.match_length===fa&&a.strstart-a.match_start>4096)&&(a.match_length=fa-1)),a.prev_length>=fa&&a.match_length<=a.prev_length){e=a.strstart+a.lookahead-fa,d=D._tr_tally(a,a.strstart-1-a.prev_match,a.prev_length-fa),a.lookahead-=a.prev_length-1,a.prev_length-=2;do{++a.strstart<=e&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart)}while(0!=--a.prev_length);if(a.match_available=0,a.match_length=fa-1,a.strstart++,d&&(h(a,!1),0===a.strm.avail_out))return qa}else if(a.match_available){if(d=D._tr_tally(a,0,a.window[a.strstart-1]),d&&h(a,!1),a.strstart++,a.lookahead--,0===a.strm.avail_out)return qa}else a.match_available=1,a.strstart++,a.lookahead--}return a.match_available&&(d=D._tr_tally(a,0,a.window[a.strstart-1]),a.match_available=0),a.insert=a.strstart<fa-1?a.strstart:fa-1,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function q(a,b){for(var c,d,e,f,g=a.window;;){if(a.lookahead<=ga){if(m(a),a.lookahead<=ga&&b===H)return qa;if(0===a.lookahead)break}if(a.match_length=0,a.lookahead>=fa&&a.strstart>0&&(e=a.strstart-1,(d=g[e])===g[++e]&&d===g[++e]&&d===g[++e])){f=a.strstart+ga;do{}while(d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&f>e);a.match_length=ga-(f-e),a.match_length>a.lookahead&&(a.match_length=a.lookahead)}if(a.match_length>=fa?(c=D._tr_tally(a,1,a.match_length-fa),a.lookahead-=a.match_length,a.strstart+=a.match_length,a.match_length=0):(c=D._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++),c&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=0,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function r(a,b){for(var c;;){if(0===a.lookahead&&(m(a),0===a.lookahead)){if(b===H)return qa;break}if(a.match_length=0,c=D._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++,c&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=0,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function s(a){a.window_size=2*a.w_size,f(a.head),a.max_lazy_match=B[a.level].max_lazy,a.good_match=B[a.level].good_length,a.nice_match=B[a.level].nice_length,a.max_chain_length=B[a.level].max_chain,a.strstart=0,a.block_start=0,a.lookahead=0,a.insert=0,a.match_length=a.prev_length=fa-1,a.match_available=0,a.ins_h=0}function t(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Y,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new C.Buf16(2*da),this.dyn_dtree=new C.Buf16(2*(2*ba+1)),this.bl_tree=new C.Buf16(2*(2*ca+1)),f(this.dyn_ltree),f(this.dyn_dtree),f(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new C.Buf16(ea+1),this.heap=new C.Buf16(2*aa+1),f(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new C.Buf16(2*aa+1),f(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function u(a){var b;return a&&a.state?(a.total_in=a.total_out=0,a.data_type=X,b=a.state,b.pending=0,b.pending_out=0,b.wrap<0&&(b.wrap=-b.wrap),b.status=b.wrap?ja:oa,a.adler=2===b.wrap?0:1,b.last_flush=H,D._tr_init(b),M):d(a,O)}function v(a){var b=u(a);return b===M&&s(a.state),b}function w(a,b){return a&&a.state?2!==a.state.wrap?O:(a.state.gzhead=b,M):O}function x(a,b,c,e,f,g){if(!a)return O;var h=1;if(b===R&&(b=6),0>e?(h=0,e=-e):e>15&&(h=2,e-=16),1>f||f>Z||c!==Y||8>e||e>15||0>b||b>9||0>g||g>V)return d(a,O);8===e&&(e=9);var i=new t;return a.state=i,i.strm=a,i.wrap=h,i.gzhead=null,i.w_bits=e,i.w_size=1<<i.w_bits,i.w_mask=i.w_size-1,i.hash_bits=f+7,i.hash_size=1<<i.hash_bits,i.hash_mask=i.hash_size-1,i.hash_shift=~~((i.hash_bits+fa-1)/fa),i.window=new C.Buf8(2*i.w_size),i.head=new C.Buf16(i.hash_size),i.prev=new C.Buf16(i.w_size),i.lit_bufsize=1<<f+6,i.pending_buf_size=4*i.lit_bufsize,i.pending_buf=new C.Buf8(i.pending_buf_size),i.d_buf=i.lit_bufsize>>1,i.l_buf=3*i.lit_bufsize,i.level=b,i.strategy=g,i.method=c,v(a)}function y(a,b){return x(a,b,Y,$,_,W)}function z(a,b){var c,h,k,l;if(!a||!a.state||b>L||0>b)return a?d(a,O):O;if(h=a.state,!a.output||!a.input&&0!==a.avail_in||h.status===pa&&b!==K)return d(a,0===a.avail_out?Q:O);if(h.strm=a,c=h.last_flush,h.last_flush=b,h.status===ja)if(2===h.wrap)a.adler=0,i(h,31),i(h,139),i(h,8),h.gzhead?(i(h,(h.gzhead.text?1:0)+(h.gzhead.hcrc?2:0)+(h.gzhead.extra?4:0)+(h.gzhead.name?8:0)+(h.gzhead.comment?16:0)),i(h,255&h.gzhead.time),i(h,h.gzhead.time>>8&255),i(h,h.gzhead.time>>16&255),i(h,h.gzhead.time>>24&255),i(h,9===h.level?2:h.strategy>=T||h.level<2?4:0),i(h,255&h.gzhead.os),h.gzhead.extra&&h.gzhead.extra.length&&(i(h,255&h.gzhead.extra.length),i(h,h.gzhead.extra.length>>8&255)),h.gzhead.hcrc&&(a.adler=F(a.adler,h.pending_buf,h.pending,0)),h.gzindex=0,h.status=ka):(i(h,0),i(h,0),i(h,0),i(h,0),i(h,0),i(h,9===h.level?2:h.strategy>=T||h.level<2?4:0),i(h,ua),h.status=oa);else{var m=Y+(h.w_bits-8<<4)<<8,n=-1
;n=h.strategy>=T||h.level<2?0:h.level<6?1:6===h.level?2:3,m|=n<<6,0!==h.strstart&&(m|=ia),m+=31-m%31,h.status=oa,j(h,m),0!==h.strstart&&(j(h,a.adler>>>16),j(h,65535&a.adler)),a.adler=1}if(h.status===ka)if(h.gzhead.extra){for(k=h.pending;h.gzindex<(65535&h.gzhead.extra.length)&&(h.pending!==h.pending_buf_size||(h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),g(a),k=h.pending,h.pending!==h.pending_buf_size));)i(h,255&h.gzhead.extra[h.gzindex]),h.gzindex++;h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),h.gzindex===h.gzhead.extra.length&&(h.gzindex=0,h.status=la)}else h.status=la;if(h.status===la)if(h.gzhead.name){k=h.pending;do{if(h.pending===h.pending_buf_size&&(h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),g(a),k=h.pending,h.pending===h.pending_buf_size)){l=1;break}l=h.gzindex<h.gzhead.name.length?255&h.gzhead.name.charCodeAt(h.gzindex++):0,i(h,l)}while(0!==l);h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),0===l&&(h.gzindex=0,h.status=ma)}else h.status=ma;if(h.status===ma)if(h.gzhead.comment){k=h.pending;do{if(h.pending===h.pending_buf_size&&(h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),g(a),k=h.pending,h.pending===h.pending_buf_size)){l=1;break}l=h.gzindex<h.gzhead.comment.length?255&h.gzhead.comment.charCodeAt(h.gzindex++):0,i(h,l)}while(0!==l);h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),0===l&&(h.status=na)}else h.status=na;if(h.status===na&&(h.gzhead.hcrc?(h.pending+2>h.pending_buf_size&&g(a),h.pending+2<=h.pending_buf_size&&(i(h,255&a.adler),i(h,a.adler>>8&255),a.adler=0,h.status=oa)):h.status=oa),0!==h.pending){if(g(a),0===a.avail_out)return h.last_flush=-1,M}else if(0===a.avail_in&&e(b)<=e(c)&&b!==K)return d(a,Q);if(h.status===pa&&0!==a.avail_in)return d(a,Q);if(0!==a.avail_in||0!==h.lookahead||b!==H&&h.status!==pa){var o=h.strategy===T?r(h,b):h.strategy===U?q(h,b):B[h.level].func(h,b);if((o===sa||o===ta)&&(h.status=pa),o===qa||o===sa)return 0===a.avail_out&&(h.last_flush=-1),M;if(o===ra&&(b===I?D._tr_align(h):b!==L&&(D._tr_stored_block(h,0,0,!1),b===J&&(f(h.head),0===h.lookahead&&(h.strstart=0,h.block_start=0,h.insert=0))),g(a),0===a.avail_out))return h.last_flush=-1,M}return b!==K?M:h.wrap<=0?N:(2===h.wrap?(i(h,255&a.adler),i(h,a.adler>>8&255),i(h,a.adler>>16&255),i(h,a.adler>>24&255),i(h,255&a.total_in),i(h,a.total_in>>8&255),i(h,a.total_in>>16&255),i(h,a.total_in>>24&255)):(j(h,a.adler>>>16),j(h,65535&a.adler)),g(a),h.wrap>0&&(h.wrap=-h.wrap),0!==h.pending?M:N)}function A(a){var b;return a&&a.state?(b=a.state.status,b!==ja&&b!==ka&&b!==la&&b!==ma&&b!==na&&b!==oa&&b!==pa?d(a,O):(a.state=null,b===oa?d(a,P):M)):O}var B,C=a("../utils/common"),D=a("./trees"),E=a("./adler32"),F=a("./crc32"),G=a("./messages"),H=0,I=1,J=3,K=4,L=5,M=0,N=1,O=-2,P=-3,Q=-5,R=-1,S=1,T=2,U=3,V=4,W=0,X=2,Y=8,Z=9,$=15,_=8,aa=286,ba=30,ca=19,da=2*aa+1,ea=15,fa=3,ga=258,ha=ga+fa+1,ia=32,ja=42,ka=69,la=73,ma=91,na=103,oa=113,pa=666,qa=1,ra=2,sa=3,ta=4,ua=3,va=function(a,b,c,d,e){this.good_length=a,this.max_lazy=b,this.nice_length=c,this.max_chain=d,this.func=e};B=[new va(0,0,0,0,n),new va(4,4,8,4,o),new va(4,5,16,8,o),new va(4,6,32,32,o),new va(4,4,16,16,p),new va(8,16,32,32,p),new va(8,16,128,128,p),new va(8,32,128,256,p),new va(32,128,258,1024,p),new va(32,258,258,4096,p)],c.deflateInit=y,c.deflateInit2=x,c.deflateReset=v,c.deflateResetKeep=u,c.deflateSetHeader=w,c.deflate=z,c.deflateEnd=A,c.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":27,"./adler32":29,"./crc32":31,"./messages":37,"./trees":38}],33:[function(a,b){"use strict";function c(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}b.exports=c},{}],34:[function(a,b){"use strict";b.exports=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A;c=a.state,d=a.next_in,z=a.input,e=d+(a.avail_in-5),f=a.next_out,A=a.output,g=f-(b-a.avail_out),h=f+(a.avail_out-257),i=c.dmax,j=c.wsize,k=c.whave,l=c.wnext,m=c.window,n=c.hold,o=c.bits,p=c.lencode,q=c.distcode,r=(1<<c.lenbits)-1,s=(1<<c.distbits)-1;a:do{15>o&&(n+=z[d++]<<o,o+=8,n+=z[d++]<<o,o+=8),t=p[n&r];b:for(;;){if(u=t>>>24,n>>>=u,o-=u,0===(u=t>>>16&255))A[f++]=65535&t;else{if(!(16&u)){if(0==(64&u)){t=p[(65535&t)+(n&(1<<u)-1)];continue b}if(32&u){c.mode=12;break a}a.msg="invalid literal/length code",c.mode=30;break a}v=65535&t,u&=15,u&&(u>o&&(n+=z[d++]<<o,o+=8),v+=n&(1<<u)-1,n>>>=u,o-=u),15>o&&(n+=z[d++]<<o,o+=8,n+=z[d++]<<o,o+=8),t=q[n&s];c:for(;;){if(u=t>>>24,n>>>=u,o-=u,!(16&(u=t>>>16&255))){if(0==(64&u)){t=q[(65535&t)+(n&(1<<u)-1)];continue c}a.msg="invalid distance code",c.mode=30;break a}if(w=65535&t,u&=15,u>o&&(n+=z[d++]<<o,o+=8,u>o&&(n+=z[d++]<<o,o+=8)),(w+=n&(1<<u)-1)>i){a.msg="invalid distance too far back",c.mode=30;break a}if(n>>>=u,o-=u,u=f-g,w>u){if((u=w-u)>k&&c.sane){a.msg="invalid distance too far back",c.mode=30;break a}if(x=0,y=m,0===l){if(x+=j-u,v>u){v-=u;do{A[f++]=m[x++]}while(--u);x=f-w,y=A}}else if(u>l){if(x+=j+l-u,u-=l,v>u){v-=u;do{A[f++]=m[x++]}while(--u);if(x=0,v>l){u=l,v-=u;do{A[f++]=m[x++]}while(--u);x=f-w,y=A}}}else if(x+=l-u,v>u){v-=u;do{A[f++]=m[x++]}while(--u);x=f-w,y=A}for(;v>2;)A[f++]=y[x++],A[f++]=y[x++],A[f++]=y[x++],v-=3;v&&(A[f++]=y[x++],v>1&&(A[f++]=y[x++]))}else{x=f-w;do{A[f++]=A[x++],A[f++]=A[x++],A[f++]=A[x++],v-=3}while(v>2);v&&(A[f++]=A[x++],v>1&&(A[f++]=A[x++]))}break}}break}}while(e>d&&h>f);v=o>>3,d-=v,o-=v<<3,n&=(1<<o)-1,a.next_in=d,a.next_out=f,a.avail_in=e>d?e-d+5:5-(d-e),a.avail_out=h>f?h-f+257:257-(f-h),c.hold=n,c.bits=o}},{}],35:[function(a,b,c){"use strict";function d(a){return(a>>>24&255)+(a>>>8&65280)+((65280&a)<<8)+((255&a)<<24)}function e(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new r.Buf16(320),this.work=new r.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function f(a){var b;return a&&a.state?(b=a.state,a.total_in=a.total_out=b.total=0,a.msg="",b.wrap&&(a.adler=1&b.wrap),b.mode=K,b.last=0,b.havedict=0,b.dmax=32768,b.head=null,b.hold=0,b.bits=0,b.lencode=b.lendyn=new r.Buf32(oa),b.distcode=b.distdyn=new r.Buf32(pa),b.sane=1,b.back=-1,C):F}function g(a){var b;return a&&a.state?(b=a.state,b.wsize=0,b.whave=0,b.wnext=0,f(a)):F}function h(a,b){var c,d;return a&&a.state?(d=a.state,0>b?(c=0,b=-b):(c=1+(b>>4),48>b&&(b&=15)),b&&(8>b||b>15)?F:(null!==d.window&&d.wbits!==b&&(d.window=null),d.wrap=c,d.wbits=b,g(a))):F}function i(a,b){var c,d;return a?(d=new e,a.state=d,d.window=null,c=h(a,b),c!==C&&(a.state=null),c):F}function j(a){return i(a,qa)}function k(a){if(ra){var b;for(p=new r.Buf32(512),q=new r.Buf32(32),b=0;144>b;)a.lens[b++]=8;for(;256>b;)a.lens[b++]=9;for(;280>b;)a.lens[b++]=7;for(;288>b;)a.lens[b++]=8;for(v(x,a.lens,0,288,p,0,a.work,{bits:9}),b=0;32>b;)a.lens[b++]=5;v(y,a.lens,0,32,q,0,a.work,{bits:5}),ra=!1}a.lencode=p,a.lenbits=9,a.distcode=q,a.distbits=5}function l(a,b,c,d){var e,f=a.state;return null===f.window&&(f.wsize=1<<f.wbits,f.wnext=0,f.whave=0,f.window=new r.Buf8(f.wsize)),d>=f.wsize?(r.arraySet(f.window,b,c-f.wsize,f.wsize,0),f.wnext=0,f.whave=f.wsize):(e=f.wsize-f.wnext,e>d&&(e=d),r.arraySet(f.window,b,c-d,e,f.wnext),d-=e,d?(r.arraySet(f.window,b,c-d,d,0),f.wnext=d,f.whave=f.wsize):(f.wnext+=e,f.wnext===f.wsize&&(f.wnext=0),f.whave<f.wsize&&(f.whave+=e))),0}function m(a,b){var c,e,f,g,h,i,j,m,n,o,p,q,oa,pa,qa,ra,sa,ta,ua,va,wa,xa,ya,za,Aa=0,Ba=new r.Buf8(4),Ca=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15]
;if(!a||!a.state||!a.output||!a.input&&0!==a.avail_in)return F;c=a.state,c.mode===V&&(c.mode=W),h=a.next_out,f=a.output,j=a.avail_out,g=a.next_in,e=a.input,i=a.avail_in,m=c.hold,n=c.bits,o=i,p=j,xa=C;a:for(;;)switch(c.mode){case K:if(0===c.wrap){c.mode=W;break}for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(2&c.wrap&&35615===m){c.check=0,Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0),m=0,n=0,c.mode=L;break}if(c.flags=0,c.head&&(c.head.done=!1),!(1&c.wrap)||(((255&m)<<8)+(m>>8))%31){a.msg="incorrect header check",c.mode=la;break}if((15&m)!==J){a.msg="unknown compression method",c.mode=la;break}if(m>>>=4,n-=4,wa=8+(15&m),0===c.wbits)c.wbits=wa;else if(wa>c.wbits){a.msg="invalid window size",c.mode=la;break}c.dmax=1<<wa,a.adler=c.check=1,c.mode=512&m?T:V,m=0,n=0;break;case L:for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(c.flags=m,(255&c.flags)!==J){a.msg="unknown compression method",c.mode=la;break}if(57344&c.flags){a.msg="unknown header flags set",c.mode=la;break}c.head&&(c.head.text=m>>8&1),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0)),m=0,n=0,c.mode=M;case M:for(;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.head&&(c.head.time=m),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,Ba[2]=m>>>16&255,Ba[3]=m>>>24&255,c.check=t(c.check,Ba,4,0)),m=0,n=0,c.mode=N;case N:for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.head&&(c.head.xflags=255&m,c.head.os=m>>8),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0)),m=0,n=0,c.mode=O;case O:if(1024&c.flags){for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.length=m,c.head&&(c.head.extra_len=m),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0)),m=0,n=0}else c.head&&(c.head.extra=null);c.mode=P;case P:if(1024&c.flags&&(q=c.length,q>i&&(q=i),q&&(c.head&&(wa=c.head.extra_len-c.length,c.head.extra||(c.head.extra=new Array(c.head.extra_len)),r.arraySet(c.head.extra,e,g,q,wa)),512&c.flags&&(c.check=t(c.check,e,q,g)),i-=q,g+=q,c.length-=q),c.length))break a;c.length=0,c.mode=Q;case Q:if(2048&c.flags){if(0===i)break a;q=0;do{wa=e[g+q++],c.head&&wa&&c.length<65536&&(c.head.name+=String.fromCharCode(wa))}while(wa&&i>q);if(512&c.flags&&(c.check=t(c.check,e,q,g)),i-=q,g+=q,wa)break a}else c.head&&(c.head.name=null);c.length=0,c.mode=R;case R:if(4096&c.flags){if(0===i)break a;q=0;do{wa=e[g+q++],c.head&&wa&&c.length<65536&&(c.head.comment+=String.fromCharCode(wa))}while(wa&&i>q);if(512&c.flags&&(c.check=t(c.check,e,q,g)),i-=q,g+=q,wa)break a}else c.head&&(c.head.comment=null);c.mode=S;case S:if(512&c.flags){for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(m!==(65535&c.check)){a.msg="header crc mismatch",c.mode=la;break}m=0,n=0}c.head&&(c.head.hcrc=c.flags>>9&1,c.head.done=!0),a.adler=c.check=0,c.mode=V;break;case T:for(;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}a.adler=c.check=d(m),m=0,n=0,c.mode=U;case U:if(0===c.havedict)return a.next_out=h,a.avail_out=j,a.next_in=g,a.avail_in=i,c.hold=m,c.bits=n,E;a.adler=c.check=1,c.mode=V;case V:if(b===A||b===B)break a;case W:if(c.last){m>>>=7&n,n-=7&n,c.mode=ia;break}for(;3>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}switch(c.last=1&m,m>>>=1,n-=1,3&m){case 0:c.mode=X;break;case 1:if(k(c),c.mode=ba,b===B){m>>>=2,n-=2;break a}break;case 2:c.mode=$;break;case 3:a.msg="invalid block type",c.mode=la}m>>>=2,n-=2;break;case X:for(m>>>=7&n,n-=7&n;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if((65535&m)!=(m>>>16^65535)){a.msg="invalid stored block lengths",c.mode=la;break}if(c.length=65535&m,m=0,n=0,c.mode=Y,b===B)break a;case Y:c.mode=Z;case Z:if(q=c.length){if(q>i&&(q=i),q>j&&(q=j),0===q)break a;r.arraySet(f,e,g,q,h),i-=q,g+=q,j-=q,h+=q,c.length-=q;break}c.mode=V;break;case $:for(;14>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(c.nlen=257+(31&m),m>>>=5,n-=5,c.ndist=1+(31&m),m>>>=5,n-=5,c.ncode=4+(15&m),m>>>=4,n-=4,c.nlen>286||c.ndist>30){a.msg="too many length or distance symbols",c.mode=la;break}c.have=0,c.mode=_;case _:for(;c.have<c.ncode;){for(;3>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.lens[Ca[c.have++]]=7&m,m>>>=3,n-=3}for(;c.have<19;)c.lens[Ca[c.have++]]=0;if(c.lencode=c.lendyn,c.lenbits=7,ya={bits:c.lenbits},xa=v(w,c.lens,0,19,c.lencode,0,c.work,ya),c.lenbits=ya.bits,xa){a.msg="invalid code lengths set",c.mode=la;break}c.have=0,c.mode=aa;case aa:for(;c.have<c.nlen+c.ndist;){for(;Aa=c.lencode[m&(1<<c.lenbits)-1],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(16>sa)m>>>=qa,n-=qa,c.lens[c.have++]=sa;else{if(16===sa){for(za=qa+2;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(m>>>=qa,n-=qa,0===c.have){a.msg="invalid bit length repeat",c.mode=la;break}wa=c.lens[c.have-1],q=3+(3&m),m>>>=2,n-=2}else if(17===sa){for(za=qa+3;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=qa,n-=qa,wa=0,q=3+(7&m),m>>>=3,n-=3}else{for(za=qa+7;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=qa,n-=qa,wa=0,q=11+(127&m),m>>>=7,n-=7}if(c.have+q>c.nlen+c.ndist){a.msg="invalid bit length repeat",c.mode=la;break}for(;q--;)c.lens[c.have++]=wa}}if(c.mode===la)break;if(0===c.lens[256]){a.msg="invalid code -- missing end-of-block",c.mode=la;break}if(c.lenbits=9,ya={bits:c.lenbits},xa=v(x,c.lens,0,c.nlen,c.lencode,0,c.work,ya),c.lenbits=ya.bits,xa){a.msg="invalid literal/lengths set",c.mode=la;break}if(c.distbits=6,c.distcode=c.distdyn,ya={bits:c.distbits},xa=v(y,c.lens,c.nlen,c.ndist,c.distcode,0,c.work,ya),c.distbits=ya.bits,xa){a.msg="invalid distances set",c.mode=la;break}if(c.mode=ba,b===B)break a;case ba:c.mode=ca;case ca:if(i>=6&&j>=258){a.next_out=h,a.avail_out=j,a.next_in=g,a.avail_in=i,c.hold=m,c.bits=n,u(a,p),h=a.next_out,f=a.output,j=a.avail_out,g=a.next_in,e=a.input,i=a.avail_in,m=c.hold,n=c.bits,c.mode===V&&(c.back=-1);break}for(c.back=0;Aa=c.lencode[m&(1<<c.lenbits)-1],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(ra&&0==(240&ra)){for(ta=qa,ua=ra,va=sa;Aa=c.lencode[va+((m&(1<<ta+ua)-1)>>ta)],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=ta+qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=ta,n-=ta,c.back+=ta}if(m>>>=qa,n-=qa,c.back+=qa,c.length=sa,0===ra){c.mode=ha;break}if(32&ra){c.back=-1,c.mode=V;break}if(64&ra){a.msg="invalid literal/length code",c.mode=la;break}c.extra=15&ra,c.mode=da;case da:if(c.extra){for(za=c.extra;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.length+=m&(1<<c.extra)-1,m>>>=c.extra,n-=c.extra,c.back+=c.extra}c.was=c.length,c.mode=ea;case ea:for(;Aa=c.distcode[m&(1<<c.distbits)-1],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(0==(240&ra)){for(ta=qa,ua=ra,va=sa;Aa=c.distcode[va+((m&(1<<ta+ua)-1)>>ta)],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=ta+qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=ta,n-=ta,c.back+=ta}if(m>>>=qa,n-=qa,c.back+=qa,64&ra){a.msg="invalid distance code",c.mode=la;break}c.offset=sa,c.extra=15&ra,c.mode=fa;case fa:if(c.extra){for(za=c.extra;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.offset+=m&(1<<c.extra)-1,m>>>=c.extra,n-=c.extra,c.back+=c.extra}if(c.offset>c.dmax){a.msg="invalid distance too far back",c.mode=la;break}c.mode=ga;case ga:if(0===j)break a;if(q=p-j,c.offset>q){if((q=c.offset-q)>c.whave&&c.sane){a.msg="invalid distance too far back",c.mode=la;break}q>c.wnext?(q-=c.wnext,oa=c.wsize-q):oa=c.wnext-q,q>c.length&&(q=c.length),pa=c.window}else pa=f,oa=h-c.offset,q=c.length;q>j&&(q=j),j-=q,c.length-=q;do{f[h++]=pa[oa++]}while(--q);0===c.length&&(c.mode=ca);break;case ha:if(0===j)break a;f[h++]=c.length,j--,c.mode=ca;break;case ia:if(c.wrap){for(;32>n;){if(0===i)break a;i--,m|=e[g++]<<n,n+=8}if(p-=j,a.total_out+=p,c.total+=p,p&&(a.adler=c.check=c.flags?t(c.check,f,p,h-p):s(c.check,f,p,h-p)),p=j,(c.flags?m:d(m))!==c.check){a.msg="incorrect data check",c.mode=la;break}m=0,n=0}c.mode=ja;case ja:if(c.wrap&&c.flags){for(;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(m!==(4294967295&c.total)){a.msg="incorrect length check",
c.mode=la;break}m=0,n=0}c.mode=ka;case ka:xa=D;break a;case la:xa=G;break a;case ma:return H;case na:default:return F}return a.next_out=h,a.avail_out=j,a.next_in=g,a.avail_in=i,c.hold=m,c.bits=n,(c.wsize||p!==a.avail_out&&c.mode<la&&(c.mode<ia||b!==z))&&l(a,a.output,a.next_out,p-a.avail_out)?(c.mode=ma,H):(o-=a.avail_in,p-=a.avail_out,a.total_in+=o,a.total_out+=p,c.total+=p,c.wrap&&p&&(a.adler=c.check=c.flags?t(c.check,f,p,a.next_out-p):s(c.check,f,p,a.next_out-p)),a.data_type=c.bits+(c.last?64:0)+(c.mode===V?128:0)+(c.mode===ba||c.mode===Y?256:0),(0===o&&0===p||b===z)&&xa===C&&(xa=I),xa)}function n(a){if(!a||!a.state)return F;var b=a.state;return b.window&&(b.window=null),a.state=null,C}function o(a,b){var c;return a&&a.state?(c=a.state,0==(2&c.wrap)?F:(c.head=b,b.done=!1,C)):F}var p,q,r=a("../utils/common"),s=a("./adler32"),t=a("./crc32"),u=a("./inffast"),v=a("./inftrees"),w=0,x=1,y=2,z=4,A=5,B=6,C=0,D=1,E=2,F=-2,G=-3,H=-4,I=-5,J=8,K=1,L=2,M=3,N=4,O=5,P=6,Q=7,R=8,S=9,T=10,U=11,V=12,W=13,X=14,Y=15,Z=16,$=17,_=18,aa=19,ba=20,ca=21,da=22,ea=23,fa=24,ga=25,ha=26,ia=27,ja=28,ka=29,la=30,ma=31,na=32,oa=852,pa=592,qa=15,ra=!0;c.inflateReset=g,c.inflateReset2=h,c.inflateResetKeep=f,c.inflateInit=j,c.inflateInit2=i,c.inflate=m,c.inflateEnd=n,c.inflateGetHeader=o,c.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":27,"./adler32":29,"./crc32":31,"./inffast":34,"./inftrees":36}],36:[function(a,b){"use strict";var c=a("../utils/common"),d=15,e=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],f=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],g=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],h=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];b.exports=function(a,b,i,j,k,l,m,n){var o,p,q,r,s,t,u,v,w,x=n.bits,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=null,J=0,K=new c.Buf16(16),L=new c.Buf16(16),M=null,N=0;for(y=0;d>=y;y++)K[y]=0;for(z=0;j>z;z++)K[b[i+z]]++;for(C=x,B=d;B>=1&&0===K[B];B--);if(C>B&&(C=B),0===B)return k[l++]=20971520,k[l++]=20971520,n.bits=1,0;for(A=1;B>A&&0===K[A];A++);for(A>C&&(C=A),F=1,y=1;d>=y;y++)if(F<<=1,0>(F-=K[y]))return-1;if(F>0&&(0===a||1!==B))return-1;for(L[1]=0,y=1;d>y;y++)L[y+1]=L[y]+K[y];for(z=0;j>z;z++)0!==b[i+z]&&(m[L[b[i+z]]++]=z);if(0===a?(I=M=m,t=19):1===a?(I=e,J-=257,M=f,N-=257,t=256):(I=g,M=h,t=-1),H=0,z=0,y=A,s=l,D=C,E=0,q=-1,G=1<<C,r=G-1,1===a&&G>852||2===a&&G>592)return 1;for(var O=0;;){O++,u=y-E,m[z]<t?(v=0,w=m[z]):m[z]>t?(v=M[N+m[z]],w=I[J+m[z]]):(v=96,w=0),o=1<<y-E,p=1<<D,A=p;do{p-=o,k[s+(H>>E)+p]=u<<24|v<<16|w|0}while(0!==p);for(o=1<<y-1;H&o;)o>>=1;if(0!==o?(H&=o-1,H+=o):H=0,z++,0==--K[y]){if(y===B)break;y=b[i+m[z]]}if(y>C&&(H&r)!==q){for(0===E&&(E=C),s+=A,D=y-E,F=1<<D;B>D+E&&!(0>=(F-=K[D+E]));)D++,F<<=1;if(G+=1<<D,1===a&&G>852||2===a&&G>592)return 1;q=H&r,k[q]=C<<24|D<<16|s-l|0}}return 0!==H&&(k[s+H]=y-E<<24|64<<16|0),n.bits=C,0}},{"../utils/common":27}],37:[function(a,b){"use strict";b.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],38:[function(a,b,c){"use strict";function d(a){for(var b=a.length;--b>=0;)a[b]=0}function e(a){return 256>a?da[a]:da[256+(a>>>7)]}function f(a,b){a.pending_buf[a.pending++]=255&b,a.pending_buf[a.pending++]=b>>>8&255}function g(a,b,c){a.bi_valid>T-c?(a.bi_buf|=b<<a.bi_valid&65535,f(a,a.bi_buf),a.bi_buf=b>>T-a.bi_valid,a.bi_valid+=c-T):(a.bi_buf|=b<<a.bi_valid&65535,a.bi_valid+=c)}function h(a,b,c){g(a,c[2*b],c[2*b+1])}function i(a,b){var c=0;do{c|=1&a,a>>>=1,c<<=1}while(--b>0);return c>>>1}function j(a){16===a.bi_valid?(f(a,a.bi_buf),a.bi_buf=0,a.bi_valid=0):a.bi_valid>=8&&(a.pending_buf[a.pending++]=255&a.bi_buf,a.bi_buf>>=8,a.bi_valid-=8)}function k(a,b){var c,d,e,f,g,h,i=b.dyn_tree,j=b.max_code,k=b.stat_desc.static_tree,l=b.stat_desc.has_stree,m=b.stat_desc.extra_bits,n=b.stat_desc.extra_base,o=b.stat_desc.max_length,p=0;for(f=0;S>=f;f++)a.bl_count[f]=0;for(i[2*a.heap[a.heap_max]+1]=0,c=a.heap_max+1;R>c;c++)d=a.heap[c],f=i[2*i[2*d+1]+1]+1,f>o&&(f=o,p++),i[2*d+1]=f,d>j||(a.bl_count[f]++,g=0,d>=n&&(g=m[d-n]),h=i[2*d],a.opt_len+=h*(f+g),l&&(a.static_len+=h*(k[2*d+1]+g)));if(0!==p){do{for(f=o-1;0===a.bl_count[f];)f--;a.bl_count[f]--,a.bl_count[f+1]+=2,a.bl_count[o]--,p-=2}while(p>0);for(f=o;0!==f;f--)for(d=a.bl_count[f];0!==d;)(e=a.heap[--c])>j||(i[2*e+1]!==f&&(a.opt_len+=(f-i[2*e+1])*i[2*e],i[2*e+1]=f),d--)}}function l(a,b,c){var d,e,f=new Array(S+1),g=0;for(d=1;S>=d;d++)f[d]=g=g+c[d-1]<<1;for(e=0;b>=e;e++){var h=a[2*e+1];0!==h&&(a[2*e]=i(f[h]++,h))}}function m(){var a,b,c,d,e,f=new Array(S+1);for(c=0,d=0;M-1>d;d++)for(fa[d]=c,a=0;a<1<<Z[d];a++)ea[c++]=d;for(ea[c-1]=d,e=0,d=0;16>d;d++)for(ga[d]=e,a=0;a<1<<$[d];a++)da[e++]=d;for(e>>=7;P>d;d++)for(ga[d]=e<<7,a=0;a<1<<$[d]-7;a++)da[256+e++]=d;for(b=0;S>=b;b++)f[b]=0;for(a=0;143>=a;)ba[2*a+1]=8,a++,f[8]++;for(;255>=a;)ba[2*a+1]=9,a++,f[9]++;for(;279>=a;)ba[2*a+1]=7,a++,f[7]++;for(;287>=a;)ba[2*a+1]=8,a++,f[8]++;for(l(ba,O+1,f),a=0;P>a;a++)ca[2*a+1]=5,ca[2*a]=i(a,5);ha=new ka(ba,Z,N+1,O,S),ia=new ka(ca,$,0,P,S),ja=new ka(new Array(0),_,0,Q,U)}function n(a){var b;for(b=0;O>b;b++)a.dyn_ltree[2*b]=0;for(b=0;P>b;b++)a.dyn_dtree[2*b]=0;for(b=0;Q>b;b++)a.bl_tree[2*b]=0;a.dyn_ltree[2*V]=1,a.opt_len=a.static_len=0,a.last_lit=a.matches=0}function o(a){a.bi_valid>8?f(a,a.bi_buf):a.bi_valid>0&&(a.pending_buf[a.pending++]=a.bi_buf),a.bi_buf=0,a.bi_valid=0}function p(a,b,c,d){o(a),d&&(f(a,c),f(a,~c)),E.arraySet(a.pending_buf,a.window,b,c,a.pending),a.pending+=c}function q(a,b,c,d){var e=2*b,f=2*c;return a[e]<a[f]||a[e]===a[f]&&d[b]<=d[c]}function r(a,b,c){for(var d=a.heap[c],e=c<<1;e<=a.heap_len&&(e<a.heap_len&&q(b,a.heap[e+1],a.heap[e],a.depth)&&e++,!q(b,d,a.heap[e],a.depth));)a.heap[c]=a.heap[e],c=e,e<<=1;a.heap[c]=d}function s(a,b,c){var d,f,i,j,k=0;if(0!==a.last_lit)do{d=a.pending_buf[a.d_buf+2*k]<<8|a.pending_buf[a.d_buf+2*k+1],f=a.pending_buf[a.l_buf+k],k++,0===d?h(a,f,b):(i=ea[f],h(a,i+N+1,b),j=Z[i],0!==j&&(f-=fa[i],g(a,f,j)),d--,i=e(d),h(a,i,c),0!==(j=$[i])&&(d-=ga[i],g(a,d,j)))}while(k<a.last_lit);h(a,V,b)}function t(a,b){var c,d,e,f=b.dyn_tree,g=b.stat_desc.static_tree,h=b.stat_desc.has_stree,i=b.stat_desc.elems,j=-1;for(a.heap_len=0,a.heap_max=R,c=0;i>c;c++)0!==f[2*c]?(a.heap[++a.heap_len]=j=c,a.depth[c]=0):f[2*c+1]=0;for(;a.heap_len<2;)e=a.heap[++a.heap_len]=2>j?++j:0,f[2*e]=1,a.depth[e]=0,a.opt_len--,h&&(a.static_len-=g[2*e+1]);for(b.max_code=j,c=a.heap_len>>1;c>=1;c--)r(a,f,c);e=i;do{c=a.heap[1],a.heap[1]=a.heap[a.heap_len--],r(a,f,1),d=a.heap[1],a.heap[--a.heap_max]=c,a.heap[--a.heap_max]=d,f[2*e]=f[2*c]+f[2*d],a.depth[e]=(a.depth[c]>=a.depth[d]?a.depth[c]:a.depth[d])+1,f[2*c+1]=f[2*d+1]=e,a.heap[1]=e++,r(a,f,1)}while(a.heap_len>=2);a.heap[--a.heap_max]=a.heap[1],k(a,b),l(f,j,a.bl_count)}function u(a,b,c){var d,e,f=-1,g=b[1],h=0,i=7,j=4;for(0===g&&(i=138,j=3),b[2*(c+1)+1]=65535,d=0;c>=d;d++)e=g,g=b[2*(d+1)+1],++h<i&&e===g||(j>h?a.bl_tree[2*e]+=h:0!==e?(e!==f&&a.bl_tree[2*e]++,a.bl_tree[2*W]++):10>=h?a.bl_tree[2*X]++:a.bl_tree[2*Y]++,h=0,f=e,0===g?(i=138,j=3):e===g?(i=6,j=3):(i=7,j=4))}function v(a,b,c){var d,e,f=-1,i=b[1],j=0,k=7,l=4;for(0===i&&(k=138,l=3),d=0;c>=d;d++)if(e=i,i=b[2*(d+1)+1],!(++j<k&&e===i)){if(l>j)do{h(a,e,a.bl_tree)}while(0!=--j);else 0!==e?(e!==f&&(h(a,e,a.bl_tree),j--),h(a,W,a.bl_tree),g(a,j-3,2)):10>=j?(h(a,X,a.bl_tree),g(a,j-3,3)):(h(a,Y,a.bl_tree),g(a,j-11,7));j=0,f=e,0===i?(k=138,l=3):e===i?(k=6,l=3):(k=7,l=4)}}function w(a){var b;for(u(a,a.dyn_ltree,a.l_desc.max_code),u(a,a.dyn_dtree,a.d_desc.max_code),t(a,a.bl_desc),b=Q-1;b>=3&&0===a.bl_tree[2*aa[b]+1];b--);return a.opt_len+=3*(b+1)+5+5+4,b}function x(a,b,c,d){var e;for(g(a,b-257,5),g(a,c-1,5),g(a,d-4,4),
e=0;d>e;e++)g(a,a.bl_tree[2*aa[e]+1],3);v(a,a.dyn_ltree,b-1),v(a,a.dyn_dtree,c-1)}function y(a){var b,c=4093624447;for(b=0;31>=b;b++,c>>>=1)if(1&c&&0!==a.dyn_ltree[2*b])return G;if(0!==a.dyn_ltree[18]||0!==a.dyn_ltree[20]||0!==a.dyn_ltree[26])return H;for(b=32;N>b;b++)if(0!==a.dyn_ltree[2*b])return H;return G}function z(a){ma||(m(),ma=!0),a.l_desc=new la(a.dyn_ltree,ha),a.d_desc=new la(a.dyn_dtree,ia),a.bl_desc=new la(a.bl_tree,ja),a.bi_buf=0,a.bi_valid=0,n(a)}function A(a,b,c,d){g(a,(J<<1)+(d?1:0),3),p(a,b,c,!0)}function B(a){g(a,K<<1,3),h(a,V,ba),j(a)}function C(a,b,c,d){var e,f,h=0;a.level>0?(a.strm.data_type===I&&(a.strm.data_type=y(a)),t(a,a.l_desc),t(a,a.d_desc),h=w(a),e=a.opt_len+3+7>>>3,f=a.static_len+3+7>>>3,e>=f&&(e=f)):e=f=c+5,e>=c+4&&-1!==b?A(a,b,c,d):a.strategy===F||f===e?(g(a,(K<<1)+(d?1:0),3),s(a,ba,ca)):(g(a,(L<<1)+(d?1:0),3),x(a,a.l_desc.max_code+1,a.d_desc.max_code+1,h+1),s(a,a.dyn_ltree,a.dyn_dtree)),n(a),d&&o(a)}function D(a,b,c){return a.pending_buf[a.d_buf+2*a.last_lit]=b>>>8&255,a.pending_buf[a.d_buf+2*a.last_lit+1]=255&b,a.pending_buf[a.l_buf+a.last_lit]=255&c,a.last_lit++,0===b?a.dyn_ltree[2*c]++:(a.matches++,b--,a.dyn_ltree[2*(ea[c]+N+1)]++,a.dyn_dtree[2*e(b)]++),a.last_lit===a.lit_bufsize-1}var E=a("../utils/common"),F=4,G=0,H=1,I=2,J=0,K=1,L=2,M=29,N=256,O=N+1+M,P=30,Q=19,R=2*O+1,S=15,T=16,U=7,V=256,W=16,X=17,Y=18,Z=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],$=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],_=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],aa=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],ba=new Array(2*(O+2));d(ba);var ca=new Array(2*P);d(ca);var da=new Array(512);d(da);var ea=new Array(256);d(ea);var fa=new Array(M);d(fa);var ga=new Array(P);d(ga);var ha,ia,ja,ka=function(a,b,c,d,e){this.static_tree=a,this.extra_bits=b,this.extra_base=c,this.elems=d,this.max_length=e,this.has_stree=a&&a.length},la=function(a,b){this.dyn_tree=a,this.max_code=0,this.stat_desc=b},ma=!1;c._tr_init=z,c._tr_stored_block=A,c._tr_flush_block=C,c._tr_tally=D,c._tr_align=B},{"../utils/common":27}],39:[function(a,b){"use strict";function c(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}b.exports=c},{}]},{},[9])(9)}),wmsx.EmbeddedFiles={get:function(a){if(a.indexOf("|")<0)return this.getFile(a);for(var b=a.split(/\s*\|\s*/),c=new Array(b.length),d=0;d<b.length;++d)c[d]=this.getFile(b[d]).content;return{name:a,content:wmsx.Util.arraysConcatAll(c)}},getFile:function(a){a=a.substr(1);var b=this.compressedContent[a];if(void 0!==b)return{name:a,content:wmsx.Util.uncompressStringBase64ToInt8BitArray(b)};var c=this.diffsContent[a];if(void 0!==c){var d=this.getFile(c.based);if(void 0!==d){var e=d.content;for(var f in c.diffs)for(var g=c.diffs[f],h=0;h<g.length;++h)e[(0|f)+h]=g[h];return{name:a,content:e}}}},embedFileCompressedContent:function(a,b){this.compressedContent[a]=b},embedFileDiff:function(a,b){this.diffsContent[a]=b},isEmbeddedURL:function(a){return a&&"@"===a[0]},compressedContent:{},diffsContent:{}},wmsx.MultiDownloader=function(a,b,c,d){"use strict";function e(a){if(a){var b=a.url.trim();if(!b)return i(a,"Empty URL");var c=wmsx.EmbeddedFiles.isEmbeddedURL(b)?[b]:b.split(/\s*\|\s*/);a.filesToLoad=c.length,a.filesContent=new Array(a.filesToLoad);for(var d=0;d<c.length;++d){var e=c[d];wmsx.EmbeddedFiles.isEmbeddedURL(e)?f(a,d,e):g(a,d,e)}}}function f(a,b,c){var d=wmsx.EmbeddedFiles.get(c);void 0!==d?h(a,b,d.content):i(a,"Embedded file not found!")}function g(a,b,c){var e=k(c)?l(c):c,f=new XMLHttpRequest;f.open("GET",e,!0),f.responseType="arraybuffer",f.timeout=void 0!==d?d:s,f.onload=function(){200!==f.status&&0!==f.status||!f.response?f.onerror():h(a,b,new Uint8Array(f.response))},f.onerror=f.ontimeout=function(){i(a,f.status+" "+f.statusText)},wmsx.Util.log("Reading file from: "+c),f.send()}function h(a,b,c){a.filesContent[b]=c,--a.filesToLoad>0||(a.success=!0,a.content=wmsx.Util.arraysConcatAll(a.filesContent),a.onSuccess&&a.onSuccess(a),j())}function i(a,b){var d="Could not load file: "+a.url+"\nError: "+b;a.success=!1,a.error=b,a.errorMessage=d,a.onError?(wmsx.Util.error(d),a.onError(a)):c||wmsx.Util.message(d),j()}function j(){if(!q){for(var d=0;d<a.length;d++)if(a[d]&&void 0===a[d].success)return;for(q=!0,n(),d=0;d<a.length;d++)if(a[d]&&!a[d].success)return void(c&&c(a[d]));b&&b(a)}}function k(a){return a&&(0===a.indexOf("http:")||0===a.indexOf("https:"))}function l(a){return WMSX.WEB_EXTENSIONS_PROXY_SERVER?"https://"+WMSX.WEB_EXTENSIONS_PROXY_SERVER+"/proxy-remote-download?url="+a:a}function m(){WMSX.room&&!WMSX.room.isLoading&&(p=window.setTimeout(function(){p=null,o=!0,WMSX.room.setLoading(!0)},r))}function n(){p&&(window.clearTimeout(p),p=null),o&&(o=!1,WMSX.room.setLoading(!1))}this.start=function(){if(a&&0!==a.length){m();for(var b=0;b<a.length;b++)e(a[b])}j()};var o=!1,p=null,q=!1,r=100,s=15e3},wmsx.MultiFileReader=function(a,b,c,d){"use strict";function e(a){if(a){wmsx.Util.log("Reading file: "+a.name);var b=new FileReader;b.onload=function(b){a.wmsxSuccess=!0,a.content=new Uint8Array(b.target.result),f()},b.onerror=function(b){a.wmsxSuccess=!1,a.wmsxError=b.target.error.name,console.log("ERROR:",a.name,a.wmsxError),f()},b.readAsArrayBuffer(a)}}function f(){if(!h){for(var a=0;a<g.length;a++)if(g[a]&&void 0===g[a].wmsxSuccess)return;for(h=!0,a=0;a<g.length;a++)if(g[a]&&!g[a].wmsxSuccess)return c&&c(g,g[a].wmsxError),g;b&&b(g)}}this.start=function(){if(a&&0!==a.length){for(var c=0;c<a.length;c++)g.push(a[c]);for(var d=0;d<g.length;d++)e(g[d]);f()}else b(a)};var g=[],h=!1},wmsx.Z80=function(){"use strict";function init(){defineAllInstructions()}function setINT(a){INT!==a&&(INT=a,ackINT=255!==a&&IFF1&&0===prefix)}function fetchNextInstruction(){opcode=fromN(),selectInstruction(),T=instruction.remainCycles}function acknowledgeINT(){pINT()}function selectInstruction(){0===prefix?instruction=instructions[opcode]:(instruction=instructionsByPrefix[prefix][opcode]||instructions[opcode],255!==INT&&IFF1&&(ackINT=!0),prefix=0)}function pcInc(){var a=PC;return PC=PC+1&65535,a}function spInc(){var a=SP;return SP=SP+1&65535,a}function decSP(){return SP=SP-1&65535}function fromA(){return A}function fromB(){return B}function fromC(){return C}function fromD(){return DE>>>8}function fromE(){return 255&DE}function fromH(){return HL>>>8}function fromL(){return 255&HL}function fromIXh(){return IX>>>8}function fromIXl(){return 255&IX}function fromIYh(){return IY>>>8}function fromIYl(){return 255&IY}function toA(a){A=a}function toB(a){B=a}function toC(a){C=a}function toD(a){DE=255&DE|a<<8}function toE(a){DE=65280&DE|a}function toH(a){HL=255&HL|a<<8}function toL(a){HL=65280&HL|a}function toIXh(a){IX=255&IX|a<<8}function toIXl(a){IX=65280&IX|a}function toIYh(a){IY=255&IY|a<<8}function toIYl(a){IY=65280&IY|a}function fromAF(){return A<<8|F}function fromBC(){return B<<8|C}function fromDE(){return DE}function fromHL(){return HL}function fromSP(){return SP}function fromIX(){return IX}function fromIY(){return IY}function toAF(a){A=a>>>8,F=255&a}function toBC(a){B=a>>>8,C=255&a}function toDE(a){DE=a}function toHL(a){HL=a}function toSP(a){SP=a}function toIX(a){IX=a}function toIY(a){IY=a}function from_BC_8(){return bus.read(fromBC())}function from_DE_8(){return bus.read(DE)}function from_HL_8(){return bus.read(HL)}function from_SP_16(){var a=SP+1;return a>65535&&(a=0),bus.read(SP)|bus.read(a)<<8}function to_BC_8(a){bus.write(fromBC(),a)}function to_DE_8(a){bus.write(DE,a)}function to_HL_8(a){bus.write(HL,a)}function to_SP_16(a){bus.write(SP,255&a);var b=SP+1;b>65535&&(b=0),bus.write(b,a>>>8)}function preReadIXYd(){preReadIXYdOffset=bus.read(pcInc())}function from_IXd_8(){return bus.read(sum16Signed(IX,bus.read(pcInc())))}function from_IYd_8(){
return bus.read(sum16Signed(IY,bus.read(pcInc())))}function to_IXd_8(a){bus.write(sum16Signed(IX,bus.read(pcInc())),a)}function to_IYd_8(a){bus.write(sum16Signed(IY,bus.read(pcInc())),a)}function fromN(){return bus.read(pcInc())}function fromNN(){return bus.read(pcInc())|bus.read(pcInc())<<8}function from_NN_8(){return bus.read(bus.read(pcInc())|bus.read(pcInc())<<8)}function to_NN_8(a){var b=bus.read(pcInc())|bus.read(pcInc())<<8;bus.write(b,a)}function from_NN_16(){var a=bus.read(pcInc())|bus.read(pcInc())<<8,b=bus.read(a);return a+=1,a>65535&&(a=0),bus.read(a)<<8|b}function to_NN_16(a){var b=bus.read(pcInc())|bus.read(pcInc())<<8;bus.write(b,255&a),b+=1,b>65535&&(b=0),bus.write(b,a>>>8)}function sum16Signed(a,b){return a+(b>127?-256+b:b)&65535}function push16(a){bus.write(decSP(),a>>>8),bus.write(decSP(),255&a)}function pop16(){return bus.read(spInc())|bus.read(spInc())<<8}function NOP(){}function HALT(){--PC}function newLD(a,b){return function(){a(b())}}function LDAI(){A=I,F=1&F|168&A|(0===A)<<nZ|IFF1<<nPV}function LDAR(){A=127&R,F=1&F|168&A|(0===A)<<nZ|IFF1<<nPV}function LDIA(){I=A}function LDRA(){R=A}function newPUSH(a){return function(){push16(a())}}function newPOP(a){return function(){a(pop16())}}function EXDEHL(){var a=DE;DE=HL,HL=a}function EXX(){var a=fromBC();toBC(BC2),BC2=a,a=DE,DE=DE2,DE2=a,a=HL,HL=HL2,HL2=a}function EXAFAF2(){var a=fromAF();toAF(AF2),AF2=a}function LDI(){to_DE_8(from_HL_8()),DE=DE+1&65535,HL=HL+1&65535,--C<0&&(C=255,B=B-1&255),F=193&F|(B+C!==0)<<nPV}function LDIR(){LDI(),F&bPV&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function LDD(){to_DE_8(from_HL_8()),DE=DE-1&65535,HL=HL-1&65535,--C<0&&(C=255,B=B-1&255),F=193&F|(B+C!==0)<<nPV}function LDDR(){LDD(),F&bPV&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function CPI(){var a=from_HL_8();--C<0&&(C=255,B=B-1&255),HL=HL+1&65535;var b=A-a;F=F&bC|bN|168&b|(0===b)<<nZ|(A^a^b)&bH|(B+C!==0)<<nPV}function CPIR(){CPI(),F&bPV&&!(F&bZ)&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function CPD(){var a=from_HL_8();--C<0&&(C=255,B=B-1&255),HL=HL-1&65535;var b=A-a;F=F&bC|bN|168&b|(0===b)<<nZ|(A^a^b)&bH|(B+C!==0)<<nPV}function CPDR(){CPD(),F&bPV&&!(F&bZ)&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function DAA(){var a=A;F&bN?((F&bH||(15&A)>9)&&(a-=6),(F&bC||A>153)&&(a-=96)):((F&bH||(15&A)>9)&&(a+=6),(F&bC||A>153)&&(a+=96)),a&=255,F=3&F|168&a|(0===a)<<nZ|(A^a)&bH|parities[a]|A>153,A=a}function CPL(){A=255&~A,F=197&F|18|40&A}function NEG(){var a=A;A=255&-A,F=bN|168&A|(0===A)<<nZ|(0!=(15&a))<<nH|(128===a)<<nPV|0!==a}function CCF(){F=196&F|40&A|(F&bC)<<nH|~F&bC}function SCF(){F=196&F|bC}function DI(){IFF1=0,ackINT=!1}function EI(){IFF1=1,prefix=7,ackINT=!1}function RLCA(){A=255&(A<<1|A>>>7),F=196&F|40&A|A&bC}function RLA(){var a=A;A=255&(A<<1|F&bC),F=196&F|40&A|a>>>7&bC}function RRCA(){A=255&(A>>>1|A<<7),F=196&F|40&A|A>>>7}function RRA(){var a=A;A=A>>>1|(F&bC)<<7,F=196&F|40&A|a&bC}function RLD(){var a=from_HL_8();to_HL_8(255&(a<<4|15&A)),A=240&A|a>>>4,F=F&bC|168&A|(0===A)<<nZ|parities[A]}function RRD(){var a=from_HL_8();to_HL_8(255&(A<<4|a>>>4)),A=240&A|15&a,F=F&bC|168&A|(0===A)<<nZ|parities[A]}function JR(){var a=fromN();PC=sum16Signed(PC,a)}function DJNZ(){var a=fromN();0!==(B=B-1&255)&&(PC=sum16Signed(PC,a),T+=5,instruction=instructionADT_CYCLES)}function CALL(){var a=fromNN();push16(PC),PC=a}function RET(){PC=pop16()}function RETI(){RET()}function RETN(){RET()}function INAn(){var a=fromN();A=bus.input(A<<8|a)}function INI(){to_HL_8(bus.input(fromBC())),HL=HL+1&65535,B=B-1&255,F=F&bC|bN|(0===B)<<nZ}function INIR(){INI(),0!==B&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function IND(){to_HL_8(bus.input(fromBC())),HL=HL-1&65535,B=B-1&255,F=F&bC|bN|(0===B)<<nZ}function INDR(){IND(),0!==B&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function OUTnA(){var a=fromN();bus.output(A<<8|a,A)}function OUTI(){B=B-1&255,bus.output(fromBC(),from_HL_8()),HL=HL+1&65535,F=F&bC|bN|(0===B)<<nZ}function OTIR(){OUTI(),0!==B&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function OUTD(){B=B-1&255,bus.output(fromBC(),from_HL_8()),HL=HL-1&65535,F=F&bC|bN|(0===B)<<nZ}function OTDR(){OUTD(),0!==B&&(PC-=2,T+=5,instruction=instructionADT_CYCLES)}function newLD_PreRead_IXYd_(a,b){return function(){preReadIXYd(),a(b())}}function newEXr_SP_16(a,b){return function(){var c=from_SP_16();to_SP_16(b()),a(c)}}function newADD(a){return function(){var b=a(),c=A+b,d=A^b^c;A=255&c,F=168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newADC(a){return function(){var b=a(),c=A+b+(F&bC),d=A^b^c;A=255&c,F=168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newSUB(a){return function(){var b=a(),c=A-b,d=A^b^c;A=255&c,F=bN|168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newSBC(a){return function(){var b=a(),c=A-b-(F&bC),d=A^b^c;A=255&c,F=bN|168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newAND(a){return function(){A&=a(),F=bH|168&A|(0===A)<<nZ|parities[A]}}function newOR(a){return function(){A|=a(),F=168&A|(0===A)<<nZ|parities[A]}}function newXOR(a){return function(){A^=a(),F=168&A|(0===A)<<nZ|parities[A]}}function newCP(a){return function(){var b=a(),c=A-b,d=A^b^c;F=bN|c&bS|40&b|(0===c)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newINC(a,b){return function(){var c=a()+1&255;b(c),F=F&bC|168&c|(0===c)<<nZ|(0==(15&c))<<nH|(128===c)<<nPV}}function newINC_PreRead_IXYd_(a,b){return function(){preReadIXYd();var c=a()+1&255;b(c),F=F&bC|168&c|(0===c)<<nZ|(0==(15&c))<<nH|(128===c)<<nPV}}function newDEC(a,b){return function(){var c=a()-1&255;b(c),F=F&bC|bN|168&c|(0===c)<<nZ|(15==(15&c))<<nH|(127===c)<<nPV}}function newDEC_PreRead_IXYd_(a,b){return function(){preReadIXYd();var c=a()-1&255;b(c),F=F&bC|bN|168&c|(0===c)<<nZ|(15==(15&c))<<nH|(127===c)<<nPV}}function newIM(a){return function(){IM=a}}function newADD16(a,b,c){return function(){var d=b(),e=c(),f=d+e;a(65535&f),F=196&F|f>>>8&40|(d^e^f)>>>8&bH|f>>>16&bC}}function newADC16(a,b,c){return function(){var d=b(),e=c(),f=d+e+(F&bC);a(65535&f);var g=(d^e^f)>>>8;F=f>>>8&168|(0==(65535&f))<<nZ|g&bH|(g>>>6^g>>>5)&bPV|f>>>16&bC}}function newSBC16(a,b,c){return function(){var d=b(),e=c(),f=d-e-(F&bC);a(65535&f);var g=(d^e^f)>>>8;F=bN|f>>>8&168|(0==(65535&f))<<nZ|g&bH|(g>>>6^g>>>5)&bPV|f>>>16&bC}}function newINC16(a,b){return function(){a(b()+1&65535)}}function newDEC16(a,b){return function(){a(b()-1&65535)}}function newRLC(a,b,c){return function(){var d=b(),e=255&(d<<1|d>>>7);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|e&bC}}function newRL(a,b,c){return function(){var d=b(),e=255&(d<<1|F&bC);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d>>>7&bC}}function newRRC(a,b,c){return function(){var d=b(),e=255&(d>>>1|d<<7);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newRR(a,b,c){return function(){var d=b(),e=255&(d>>>1|(F&bC)<<7);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newSLA(a,b,c){return function(){var d=b(),e=d<<1&255;a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d>>>7&bC}}function newSRA(a,b,c){return function(){var d=b(),e=d>>>1|128&d;a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newSLL(a,b,c){return function(){var d=b(),e=255&(d<<1|1);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d>>>7&bC}}function newSRL(a,b,c){return function(){var d=b(),e=d>>>1;a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newBIT(a,b,c,d){return function(){var a=b()&1<<c;a?(F=F&bC|bH|a&bS,d&&(F|=40&a)):F=F&bC|84}}function newSET(a,b,c,d){return function(){var e=b()|1<<c;a(e),d&&d(e)}}function newRES(a,b,c,d){return function(){var e=b()&~(1<<c);a(e),d&&d(e)}}function newJP(a){return function(){PC=a()}}function newJPcc(a,b){return function(){var c=fromNN();(F&a)===b&&(PC=c)}}function newJRcc(a,b){return function(){var c=fromN();(F&a)===b&&(PC=sum16Signed(PC,c),T+=5,instruction=instructionADT_CYCLES)}}function newCALLcc(a,b){return function(){var c=fromNN();(F&a)===b&&(push16(PC),PC=c,T+=7,
instruction=instructionADT_CYCLES)}}function newRETcc(a,b){return function(){(F&a)===b&&(RET(),T+=6,instruction=instructionADT_CYCLES)}}function newRST(a){return function(){push16(PC),PC=a}}function newINrC(a){return function(){var b=bus.input(fromBC());a(b),F=F&bC|168&b|(0===b)<<nZ|parities[b]}}function newOUTCr(a){return function(){bus.output(fromBC(),a())}}function uNOP(){}function uIN_C(){var a=bus.input(fromBC());F=F&bC|168&a|(0===a)<<nZ|parities[a]}function uOUTC0(){bus.output(fromBC(),0)}function pINT(){if(IFF1=0,ackINT=!1,instruction===instructionHALT&&pcInc(),push16(PC),instruction=instructionADT_CYCLES,1===IM)PC=56,T=13;else if(2===IM){var a=I<<8|255;PC=bus.read(a)|bus.read(a+1)<<8,T=19}else PC=56,T=13}function pSET_CB(){prefix=2,ackINT=!1}function pSET_ED(){prefix=1,ackINT=!1}function pSET_DD(){prefix=3,ackINT=!1}function pSET_FD(){prefix=4,ackINT=!1}function pSET_DDCB(){prefix=5,ackINT=!1,preReadIXYd(),R-=1}function pSET_FDCB(){prefix=6,ackINT=!1,preReadIXYd(),R-=1}function pADT_CYCLES(){}function newpEXT(a){function b(a){return{extNum:a,extPC:PC-2,PC:PC,SP:SP,A:A,F:F,B:B,C:C,DE:DE,HL:HL,IX:IX,IY:IY,AF2:AF2,BC2:BC2,DE2:DE2,HL2:HL2,I:I,R:R,IM:IM}}function c(a){a&&(void 0!==a.PC&&(PC=a.PC),void 0!==a.SP&&(SP=a.SP),void 0!==a.A&&(A=a.A),void 0!==a.F&&(F=a.F),void 0!==a.B&&(B=a.B),void 0!==a.C&&(C=a.C),void 0!==a.DE&&(DE=a.DE),void 0!==a.HL&&(HL=a.HL),void 0!==a.I&&(I=a.I),void 0!==a.R&&(R=a.R),void 0!==a.IX&&(IX=a.IX),void 0!==a.IY&&(IY=a.IY),void 0!==a.AF2&&(AF2=a.AF2),void 0!==a.BC2&&(BC2=a.BC2),void 0!==a.DE2&&(DE2=a.DE2),void 0!==a.HL2&&(HL2=a.HL2),void 0!==a.IM&&(IM=a.IM),a.extraIterations>0&&(extensionExtraIterations=a.extraIterations))}return function d(){if(null===extensionCurrentlyRunning){extensionCurrentlyRunning=a,extensionExtraIterations=0;c(bus.cpuExtensionBegin(b(a))),d()}else if(extensionExtraIterations>0)extensionExtraIterations--,PC-=2;else{var e=bus.cpuExtensionFinish(b(a));c(e),extensionCurrentlyRunning=null}}}function defineAllInstructions(){function a(a,c,d,e,f,g,h){var i={};return i.prefix=c?a<<8|c:a,i.opcode=d,i.remainCycles=e+1,i.totalCycles=i.remainCycles+(a?5:0)+(c?4:0),i.operation=f,i.mnemonic=g,i.undocumented=h,i.opcodeString=(i.prefix?wmsx.Util.toHex2(i.prefix):"")+(56779===i.prefix||64971===i.prefix?" ":"")+wmsx.Util.toHex2(i.opcode)+" "+g+(h?"*":""),i.toString=function(){return this.opcodeString},b(i),i}function b(a){if(self.instructionsAll.push(a),a.prefix)if(237===a.prefix)instructionsED[a.opcode]=a;else if(203===a.prefix)instructionsCB[a.opcode]=a;else if(56779===a.prefix)instructionsDDCB[a.opcode]=a;else if(64971===a.prefix)instructionsFDCB[a.opcode]=a;else if(221===a.prefix)instructionsDD[a.opcode]=a;else{if(253!==a.prefix)throw new Error("Invalid instruction prefix!");instructionsFD[a.opcode]=a}else instructions[a.opcode]=a}var c={A:{bits:7,to:toA,from:fromA,desc:"A"},B:{bits:0,to:toB,from:fromB,desc:"B"},C:{bits:1,to:toC,from:fromC,desc:"C"},D:{bits:2,to:toD,from:fromD,desc:"D"},E:{bits:3,to:toE,from:fromE,desc:"E"},H:{bits:4,to:toH,from:fromH,desc:"H"},L:{bits:5,to:toL,from:fromL,desc:"L"}},d={A:{bits:7,to:toA,from:fromA,desc:"A"},B:{bits:0,to:toB,from:fromB,desc:"B"},C:{bits:1,to:toC,from:fromC,desc:"C"},D:{bits:2,to:toD,from:fromD,desc:"D"},E:{bits:3,to:toE,from:fromE,desc:"E"},H:{bits:4,to:toH,from:fromH,desc:"H",nopref:!0},L:{bits:5,to:toL,from:fromL,desc:"L",nopref:!0},IXh:{bits:4,to:toIXh,from:fromIXh,desc:"IXh",pref:221},IXl:{bits:5,to:toIXl,from:fromIXl,desc:"IXl",pref:221},IYh:{bits:4,to:toIYh,from:fromIYh,desc:"IYh",pref:253},IYl:{bits:5,to:toIYl,from:fromIYl,desc:"IYl",pref:253}},e={_HL_:{to:to_HL_8,from:from_HL_8,desc:"(HL)"},_IXd_:{to:to_IXd_8,from:from_IXd_8,desc:"(IX+d)",pref:221},_IYd_:{to:to_IYd_8,from:from_IYd_8,desc:"(IY+d)",pref:253}},f=64;for(var g in d){var h=d[g];for(var i in d){var j=d[i];if(!(h.pref&&(j.nopref||j.pref&&j.pref!=h.pref)||j.pref&&(h.nopref||h.pref&&h.pref!=j.pref))){var k=f|h.bits<<3|j.bits,l=newLD(h.to,j.from),m=h.pref|j.pref;a(m,null,k,4,l,"LD "+h.desc+", "+j.desc,m)}}}f=6;for(g in d)h=d[g],k=f|h.bits<<3,l=newLD(h.to,fromN),m=h.pref,a(m,null,k,7,l,"LD "+h.desc+", n",m);f=70;for(g in c){h=c[g];for(i in e)j=e[i],k=f|h.bits<<3,l=newLD(h.to,j.from),m=j.pref,a(m,null,k,7+(m?8:0),l,"LD "+h.desc+", "+j.desc,!1)}f=112;for(g in e){h=e[g];for(i in c)j=c[i],k=f|j.bits,l=newLD(h.to,j.from),m=h.pref,a(m,null,k,7+(m?8:0),l,"LD "+h.desc+", "+j.desc,!1)}f=54;for(g in e)h=e[g],k=f,m=h.pref,l=m?newLD_PreRead_IXYd_(h.to.toPreReadAddr,fromN):newLD(h.to,fromN),a(m,null,k,10+(m?5:0),l,"LD "+h.desc+", n",!1);k=10,l=newLD(toA,from_BC_8),a(null,null,k,7,l,"LD A, (BC)",!1),k=26,l=newLD(toA,from_DE_8),a(null,null,k,7,l,"LD A, (DE)",!1),k=58,l=newLD(toA,from_NN_8),a(null,null,k,13,l,"LD A, (nn)",!1),k=2,l=newLD(to_BC_8,fromA),a(null,null,k,7,l,"LD (BC), A",!1),k=18,l=newLD(to_DE_8,fromA),a(null,null,k,7,l,"LD (DE), A",!1),k=50,l=newLD(to_NN_8,fromA),a(null,null,k,13,l,"LD (nn), A",!1),k=87,l=LDAI,a(null,237,k,5,l,"LD A, I",!1),k=95,l=LDAR,a(null,237,k,5,l,"LD A, R",!1),k=71,l=LDIA,a(null,237,k,5,l,"LD I, A",!1),k=79,l=LDRA,a(null,237,k,5,l,"LD R, A",!1);var n={BC:{bits:0,to:toBC,from:fromBC,desc:"BC"},DE:{bits:1,to:toDE,from:fromDE,desc:"DE"},HL:{bits:2,to:toHL,from:fromHL,desc:"HL"},SP:{bits:3,to:toSP,from:fromSP,desc:"SP"}},o={BC:{bits:0,to:toBC,from:fromBC,desc:"BC"},DE:{bits:1,to:toDE,from:fromDE,desc:"DE"},HL:{bits:2,to:toHL,from:fromHL,desc:"HL",nopref:!0},SP:{bits:3,to:toSP,from:fromSP,desc:"SP"},IX:{bits:2,to:toIX,from:fromIX,desc:"IX",pref:221},IY:{bits:2,to:toIY,from:fromIY,desc:"IY",pref:253}},p={BC:{bits:0,to:toBC,from:fromBC,desc:"BC"},DE:{bits:1,to:toDE,from:fromDE,desc:"DE"},HL:{bits:2,to:toHL,from:fromHL,desc:"HL"},AF:{bits:3,to:toAF,from:fromAF,desc:"AF"},IX:{bits:2,to:toIX,from:fromIX,desc:"IX",pref:221},IY:{bits:2,to:toIY,from:fromIY,desc:"IY",pref:253}},q={HL:{to:toHL,from:fromHL,desc:"HL",nopref:!0},IXd:{to:toIX,from:fromIX,desc:"IX",pref:221},IYd:{to:toIY,from:fromIY,desc:"IY",pref:253}};f=1;for(g in o)h=o[g],k=f|h.bits<<4,l=newLD(h.to,fromNN),m=h.pref,a(m,null,k,10,l,"LD "+h.desc+", nn",!1);k=42;for(g in q)h=q[g],l=newLD(h.to,from_NN_16),m=h.pref,a(m,null,k,16,l,"LD "+h.desc+", (nn)",!1);f=75;for(g in n)h=n[g],k=f|h.bits<<4,l=newLD(h.to,from_NN_16),a(null,237,k,16,l,"LD "+h.desc+", (nn)",!1);k=34;for(i in q)j=q[i],l=newLD(to_NN_16,j.from),m=j.pref,a(m,null,k,16,l,"LD (nn), "+j.desc,!1);f=67;for(i in n)j=n[i],k=f|j.bits<<4,l=newLD(to_NN_16,j.from),a(null,237,k,16,l,"LD (nn), "+j.desc,!1);k=249;for(i in q)j=q[i],l=newLD(toSP,j.from),m=j.pref,a(m,null,k,6,l,"LD SP, "+j.desc,!1);f=197;for(i in p)j=p[i],k=f|j.bits<<4,l=newPUSH(j.from),m=j.pref,a(m,null,k,11,l,"PUSH "+j.desc,!1);f=193;for(g in p)h=p[g],k=f|h.bits<<4,l=newPOP(h.to),m=h.pref,a(m,null,k,10,l,"POP "+h.desc,!1);k=235,l=EXDEHL,a(null,null,k,4,l,"EX DE, HL",!1),k=8,l=EXAFAF2,a(null,null,k,4,l,"EX AF, AF'",!1),k=217,l=EXX,a(null,null,k,4,l,"EXX",!1),k=227;for(var r in q){var s=q[r];l=newEXr_SP_16(s.to,s.from),m=s.pref,a(m,null,k,19,l,"EX (SP), "+s.desc,!1)}k=160,l=LDI,a(null,237,k,12,l,"LDI",!1),k=176,l=LDIR,a(null,237,k,12,l,"LDIR",!1),k=168,l=LDD,a(null,237,k,12,l,"LDD",!1),k=184,l=LDDR,a(null,237,k,12,l,"LDDR",!1),k=161,l=CPI,a(null,237,k,12,l,"CPI",!1),k=177,l=CPIR,a(null,237,k,12,l,"CPIR",!1),k=169,l=CPD,a(null,237,k,12,l,"CPD",!1),k=185,l=CPDR,a(null,237,k,12,l,"CPDR",!1);var t={ADD:{desc:"ADD A, ",instr:newADD,variations:{rp:{opcode:128},n:{opcode:198},_HLp_:{opcode:134,T:7}}},ADC:{desc:"ADC A, ",instr:newADC,variations:{rp:{opcode:136},n:{opcode:206},_HLp_:{opcode:142,T:7}}},SUB:{desc:"SUB ",instr:newSUB,variations:{rp:{opcode:144},n:{opcode:214},_HLp_:{opcode:150,T:7}}},SBC:{desc:"SBC A, ",instr:newSBC,variations:{rp:{opcode:152},n:{opcode:222},_HLp_:{opcode:158,T:7}}},AND:{desc:"AND ",instr:newAND,variations:{rp:{opcode:160},n:{opcode:230},_HLp_:{opcode:166,T:7}}},OR:{desc:"OR ",instr:newOR,variations:{
rp:{opcode:176},n:{opcode:246},_HLp_:{opcode:182,T:7}}},XOR:{desc:"XOR ",instr:newXOR,variations:{rp:{opcode:168},n:{opcode:238},_HLp_:{opcode:174,T:7}}},CP:{desc:"CP ",instr:newCP,variations:{rp:{opcode:184},n:{opcode:254},_HLp_:{opcode:190,T:7}}},INC:{desc:"INC ",instr:newINC,selfModifyInstr:newINC_PreRead_IXYd_,variations:{rp:{opcode:4,rShift:3},_HLp_:{opcode:52,T:11}}},DEC:{desc:"DEC ",instr:newDEC,selfModifyInstr:newDEC_PreRead_IXYd_,variations:{rp:{opcode:5,rShift:3},_HLp_:{opcode:53,T:11}}}};for(var u in t){var v=t[u],w=v.variations.rp;f=w.opcode;for(r in d)s=d[r],k=f|s.bits<<w.rShift,l=v.instr(s.from,s.to),m=s.pref,a(m,null,k,4,l,v.desc+s.desc,m);w=v.variations.n,w&&(k=w.opcode,l=v.instr(fromN,null),a(null,null,k,7,l,v.desc+"n",!1)),w=v.variations._HLp_,k=w.opcode;for(r in e)s=e[r],m=s.pref,l=m&&v.selfModifyInstr?v.selfModifyInstr(s.from.fromPreReadAddr,s.to.toPreReadAddr):v.instr(s.from,s.to),a(m,null,k,w.T+(m?8:0),l,v.desc+s.desc,!1)}k=39,l=DAA,a(null,null,k,4,l,"DAA",!1),k=47,l=CPL,a(null,null,k,4,l,"CPL",!1),k=68,l=NEG,a(null,237,k,4,l,"NEG",!1),k=63,l=CCF,a(null,null,k,4,l,"CCF",!1),k=55,l=SCF,a(null,null,k,4,l,"SCF",!1),k=0,l=NOP,a(null,null,k,4,l,"NOP",!1),k=118,l=HALT,instructionHALT=a(null,null,k,4,l,"HALT",!1),k=243,l=DI,a(null,null,k,4,l,"DI",!1),k=251,l=EI,a(null,null,k,4,l,"EI",!1),k=70,l=newIM(0),a(null,237,k,4,l,"IM 0",!1),k=86,l=newIM(1),a(null,237,k,4,l,"IM 1",!1),k=94,l=newIM(2),a(null,237,k,4,l,"IM 2",!1);var x={ADC:{desc:"ADC HL, ",instr:newADC16,opcode:74},SBC:{desc:"SBC HL, ",instr:newSBC16,opcode:66}},y={INC:{desc:"INC ",instr:newINC16,opcode:3},DEC:{desc:"DEC ",instr:newDEC16,opcode:11}};f=9;for(g in q){h=q[g];for(i in o)j=o[i],h.pref&&(j.nopref||j.pref&&j.pref!=h.pref)||j.pref&&(h.nopref||h.pref&&h.pref!=j.pref)||(k=f|j.bits<<4,l=newADD16(h.to,h.from,j.from),m=h.pref,a(m,null,k,11,l,"ADD "+h.desc+", "+j.desc,!1))}for(u in x){v=x[u],f=v.opcode;for(r in n)s=n[r],k=f|s.bits<<4,l=v.instr(toHL,fromHL,s.from),a(null,237,k,11,l,v.desc+s.desc,!1)}for(u in y){v=y[u],f=v.opcode;for(r in o)s=o[r],k=f|s.bits<<4,l=v.instr(s.to,s.from),m=s.pref,a(m,null,k,6,l,v.desc+s.desc,!1)}k=7,l=RLCA,a(null,null,k,4,l,"RLCA",!1),k=23,l=RLA,a(null,null,k,4,l,"RLA",!1),k=15,l=RRCA,a(null,null,k,4,l,"RRCA",!1),k=31,l=RRA,a(null,null,k,4,l,"RRA",!1);var z={A:{bits:7,to:toA,from:fromA,desc:"A"},B:{bits:0,to:toB,from:fromB,desc:"B"},C:{bits:1,to:toC,from:fromC,desc:"C"},D:{bits:2,to:toD,from:fromD,desc:"D"},E:{bits:3,to:toE,from:fromE,desc:"E"},H:{bits:4,to:toH,from:fromH,desc:"H"},L:{bits:5,to:toL,from:fromL,desc:"L"},_HL_:{bits:6,to:to_HL_8,from:from_HL_8,desc:"(HL)"}},A={_IXd_:{prefix:221,to:to_IXd_8.toPreReadAddr,from:from_IXd_8.fromPreReadAddr,desc:"(IX+d)"},_IYd_:{prefix:253,to:to_IYd_8.toPreReadAddr,from:from_IYd_8.fromPreReadAddr,desc:"(IY+d)"}},B={RLC:{desc:"RLC ",instr:newRLC,opcode:0},RL:{desc:"RL ",instr:newRL,opcode:16},RRC:{desc:"RRC ",instr:newRRC,opcode:8},RR:{desc:"RR ",instr:newRR,opcode:24},SLA:{desc:"SLA ",instr:newSLA,opcode:32},SRA:{desc:"SRA ",instr:newSRA,opcode:40},SLL:{desc:"SLL ",instr:newSLL,opcode:48,undoc:!0},SRL:{desc:"SRL ",instr:newSRL,opcode:56}};for(u in B){v=B[u],f=v.opcode;for(r in z)s=z[r],k=f|s.bits,l=v.instr(s.to,s.from,null),T="_HL_"==r?11:4,a(null,203,k,T,l,v.desc+s.desc,v.undoc);for(var C in A){var D=A[C];for(r in z){s=z[r],k=f|s.bits;var E="_HL_"!=r?s.to:null;l=v.instr(D.to,D.from,E),a(D.prefix,203,k,11+(D.prefix?4:0),l,v.desc+D.desc+(E?", "+s.desc:""),v.undoc||E)}}}k=111,l=RLD,a(null,237,k,14,l,"RLD",!1),k=103,l=RRD,a(null,237,k,14,l,"RRD",!1);var F={BIT:{desc:"BIT ",instr:newBIT,opcode:64,T_HL_:8},SET:{desc:"SET ",instr:newSET,opcode:192,T_HL_:11,toExt:!0},RES:{desc:"RES ",instr:newRES,opcode:128,T_HL_:11,toExt:!0}};for(u in F){v=F[u],f=v.opcode;for(r in z){s=z[r];for(var G=0;G<=7;G++)k=f|G<<3|s.bits,l=v.instr(s.to,s.from,G,null),T="_HL_"==r?v.T_HL_:4,a(null,203,k,T,l,v.desc+G+", "+s.desc,!1)}for(C in A){D=A[C];for(r in z)for(s=z[r],G=0;G<=7;G++){k=f|G<<3|s.bits;var H="_HL_"!=r;E=H&&v.toExt?s.to:null,l=v.instr(D.to,D.from,G,E),a(D.prefix,203,k,v.T_HL_+(D.prefix?4:0),l,v.desc+G+", "+D.desc+(E?", "+s.desc:""),H)}}}var I={nn:{desc:"nn",from:fromNN,opcode:195,T:10},HL:{desc:"(HL)",from:fromHL,opcode:233,T:4},IX:{desc:"(IX)",from:fromIX,opcode:233,T:4,pref:221},IY:{desc:"(IY)",from:fromIY,opcode:233,T:4,pref:253}},J={NZ:{bits:0,desc:"NZ",flag:bZ,val:0},Z:{bits:1,desc:"Z",flag:bZ,val:bZ},NC:{bits:2,desc:"NC",flag:bC,val:0},C:{bits:3,desc:"C",flag:bC,val:bC},PO:{bits:4,desc:"PO",flag:bPV,val:0},PE:{bits:5,desc:"PE",flag:bPV,val:bPV},P:{bits:6,desc:"P",flag:bS,val:0},M:{bits:7,desc:"M",flag:bS,val:bS}};for(r in I)s=I[r],k=s.opcode,l=newJP(s.from),m=s.pref,a(m,null,k,s.T,l,"JP "+s.desc,!1);f=194;for(r in J)s=J[r],k=f|s.bits<<3,l=newJPcc(s.flag,s.val),a(null,null,k,10,l,"JP "+s.desc+", nn",!1);k=24,l=JR,a(null,null,k,12,l,"JR e",!1);var K={C:{opcode:56,desc:"C",flag:bC,val:bC},NC:{opcode:48,desc:"NC",flag:bC,val:0},Z:{opcode:40,desc:"Z",flag:bZ,val:bZ},NZ:{opcode:32,desc:"NZ",flag:bZ,val:0}};for(r in K)s=K[r],k=s.opcode,l=newJRcc(s.flag,s.val),a(null,null,k,7,l,"JR "+s.desc+", e",!1);k=16,l=DJNZ,a(null,null,k,8,l,"DJNZ e",!1),k=205,l=CALL,a(null,null,k,17,l,"CALL nn",!1),f=196;for(r in J)s=J[r],k=f|s.bits<<3,l=newCALLcc(s.flag,s.val),a(null,null,k,10,l,"CALL "+s.desc+", nn",!1);k=201,l=RET,a(null,null,k,10,l,"RET",!1),f=192;for(r in J)s=J[r],k=f|s.bits<<3,l=newRETcc(s.flag,s.val),a(null,null,k,5,l,"RET "+s.desc,!1);k=77,l=RETI,a(null,237,k,10,l,"RETI",!1),k=69,l=RETN,a(null,237,k,10,l,"RETN",!1);var L={h00:{bits:0,addr:0,desc:"00h"},h08:{bits:1,addr:8,desc:"08h"},h10:{bits:2,addr:16,desc:"10h"},h18:{bits:3,addr:24,desc:"18h"},h20:{bits:4,addr:32,desc:"20h"},h28:{bits:5,addr:40,desc:"28h"},h30:{bits:6,addr:48,desc:"30h"},h38:{bits:7,addr:56,desc:"38h"}};f=199;for(r in L)s=L[r],k=f|s.bits<<3,l=newRST(s.addr),a(null,null,k,11,l,"RST "+s.desc,!1);k=219,l=INAn,a(null,null,k,11,l,"IN A, (n)",!1),f=64;for(r in c)s=c[r],k=f|s.bits<<3,l=newINrC(s.to),a(null,237,k,8,l,"IN "+s.desc+", (C)",!1);k=162,l=INI,a(null,237,k,12,l,"INI",!1),k=178,l=INIR,a(null,237,k,12,l,"INIR",!1),k=170,l=IND,a(null,237,k,12,l,"IND",!1),k=186,l=INDR,a(null,237,k,12,l,"INDR",!1),k=211,l=OUTnA,a(null,null,k,11,l,"OUT (n), A",!1),f=65;for(r in c)s=c[r],k=f|s.bits<<3,l=newOUTCr(s.from),a(null,237,k,8,l,"OUT (C), "+s.desc,!1);k=163,l=OUTI,a(null,237,k,12,l,"OUTI",!1),k=179,l=OTIR,a(null,237,k,12,l,"OTIR",!1),k=171,l=OUTD,a(null,237,k,12,l,"OUTD",!1),k=187,l=OTDR,a(null,237,k,12,l,"OTDR",!1);var M=[76,84,92,100,108,116,124];for(u=0;u<M.length;u++)k=M[u],l=NEG,a(null,237,k,4,l,"NEG",!0);for(M=[85,93,101,109,117,125],u=0;u<M.length;u++)k=M[u],l=RETN,a(null,237,k,10,l,"RETN",!0);for(M=[78,102,110],u=0;u<M.length;u++)k=M[u],l=newIM(0),a(null,237,k,4,l,"IM 0",!0);for(k=118,l=newIM(1),a(null,237,k,4,l,"IM 1",!0),k=126,l=newIM(2),a(null,237,k,4,l,"IM 2",!0),k=112,l=uIN_C,a(null,237,k,8,l,"IN (C)",!0),k=113,l=uOUTC0,a(null,237,k,8,l,"OUT (C), 0",!0),k=224;k<=255;k++)l=newpEXT(k),a(null,237,k,4,l,"EXT "+k.toString(16),!0);for(u=0;u<=255;u++)instructionsED[u]||(k=u,l=uNOP,a(null,237,k,4,l,"NOP",!0));k=203,l=pSET_CB,a(null,null,k,4,l,"< SET CB >",!1),k=237,l=pSET_ED,a(null,null,k,4,l,"< SET ED >",!1),k=221,l=pSET_DD,a(null,null,k,4,l,"< SET DD >",!1),k=221,l=pSET_DD,a(221,null,k,4,l,"< SET DD again >",!1),k=253,l=pSET_FD,a(221,null,k,4,l,"< SWITCH to FD >",!1),k=203,l=pSET_DDCB,a(221,null,k,3,l,"< SET DDCB >",!1),k=253,l=pSET_FD,a(null,null,k,4,l,"< SET FD >",!1),k=253,l=pSET_FD,a(253,null,k,4,l,"< SET FD again >",!1),k=221,l=pSET_DD,a(253,null,k,4,l,"< SWITCH to DD >",!1),k=203,l=pSET_FDCB,a(253,null,k,3,l,"< SET FDCB >",!1),k=257,l=pADT_CYCLES,instructionADT_CYCLES=a(null,null,k,0,l,"< ADT CYCLES >",!1)}var self=this;this.powerOn=function(){toAF(65533),toBC(65535),DE=65535,HL=65535,AF2=65533,BC2=65535,DE2=65535,HL2=65535,toIX(65535),toIY(65535),SP=65535,
setINT(255),this.reset()},this.powerOff=function(){},this.clockPulses=function(a){for(var b=a*turboClockMulti|0,c=b;c>0;--c)--T>1||(T>0?instruction.operation():(++R,ackINT?acknowledgeINT():fetchNextInstruction()));busCycles+=a},this.connectBus=function(a){bus=a},this.reset=function(){busCycles=0,T=-1,opcode=null,ackINT=!1,instruction=null,prefix=0,PC=0,I=0,R=0,IFF1=0,IM=0,extensionCurrentlyRunning=null,extensionExtraIterations=0},this.setINTChannel=function(a,b){setINT(b?INT|1<<a:INT&~(1<<a))},this.getBUSCycles=function(){return busCycles},this.setCPUTurboMulti=function(a){turboClockMulti=a<0?1:a>8?8:a},this.getCPUTurboMulti=function(){return turboClockMulti},this.getCPUTurboFreqDesc=function(){return(3.58*turboClockMulti).toFixed(2)+" MHz"};var turboClockMulti=1,extensionCurrentlyRunning=null,extensionExtraIterations=0,bus,INT=255,PC=0,SP=0,A=0,F=0,B=0,C=0,DE=0,HL=0,IX=0,IY=0,AF2=0,BC2=0,DE2=0,HL2=0,I=0,R=0,IFF1=0,IM=0,bS=128,nS=7,bZ=64,nZ=6,bF5=32,nF5=5,bH=16,nH=4,bF3=8,nF3=3,bPV=4,nPV=2,bN=2,nN=1,bC=1,nC=0,busCycles=0,T=-1,opcode,prefix,instruction,ackINT=!1,instructions=new Array(270),instructionsED=new Array(270),instructionsCB=new Array(270),instructionsDD=new Array(270),instructionsFD=new Array(270),instructionsDDCB=new Array(270),instructionsFDCB=new Array(270),instructionsByPrefix=[instructions,instructionsED,instructionsCB,instructionsDD,instructionsFD,instructionsDDCB,instructionsFDCB,instructions],instructionADT_CYCLES,instructionHALT;this.instructionsAll=[];var preReadIXYdOffset=0;from_IXd_8.fromPreReadAddr=function(){return bus.read(sum16Signed(IX,preReadIXYdOffset))},from_IYd_8.fromPreReadAddr=function(){return bus.read(sum16Signed(IY,preReadIXYdOffset))},to_IXd_8.toPreReadAddr=function(a){bus.write(sum16Signed(IX,preReadIXYdOffset),a)},to_IYd_8.toPreReadAddr=function(a){bus.write(sum16Signed(IY,preReadIXYdOffset),a)};var parities=[4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4];this.saveState=function(){return{PC:PC,SP:SP,A:A,F:F,B:B,C:C,DE:DE,HL:HL,IX:IX,IY:IY,AF2:AF2,BC2:BC2,DE2:DE2,HL2:HL2,I:I,R:R,IM:IM,IFF1:IFF1,INT:INT,nINT:1,c:busCycles,T:T,o:opcode,p:prefix,ai:ackINT,ii:this.instructionsAll.indexOf(instruction),ecr:extensionCurrentlyRunning,eei:extensionExtraIterations,tcm:turboClockMulti}},this.loadState=function(a){PC=a.PC,SP=a.SP,A=a.A,F=a.F,B=a.B,C=a.C,DE=a.DE,HL=a.HL,IX=a.IX,IY=a.IY,AF2=a.AF2,BC2=a.BC2,DE2=a.DE2,HL2=a.HL2,I=a.I,R=a.R,IM=a.IM,IFF1=a.IFF1,setINT(a.nINT?a.INT:a.INT?255:254),busCycles=a.c,T=a.T,opcode=a.o,prefix=a.p,ackINT=a.ai,instruction=this.instructionsAll[a.ii]||null,extensionCurrentlyRunning=a.ecr,extensionExtraIterations=a.eei,turboClockMulti=void 0!==a.tcm?a.tcm:a.tcs>0?2:1},this.toString=function(){return"CPU  PC: "+wmsx.Util.toHex2(PC)+"      op: "+(instruction?instruction.mnemonic:"NULL")+"          cycle: "+busCycles+"\n\nA: "+wmsx.Util.toHex2(A)+"     B: "+wmsx.Util.toHex2(B)+"     C: "+wmsx.Util.toHex2(C)+"     D: "+wmsx.Util.toHex2(DE>>>8)+"     E: "+wmsx.Util.toHex2(255&DE)+"     H: "+wmsx.Util.toHex2(HL>>>8)+"     L: "+wmsx.Util.toHex2(255&HL)+"\nBC: "+wmsx.Util.toHex2(fromBC())+"  DE: "+wmsx.Util.toHex2(DE)+"  HL: "+wmsx.Util.toHex2(HL)+"  IX: "+wmsx.Util.toHex2(IX)+"  IY: "+wmsx.Util.toHex2(IY)+"       SP: "+wmsx.Util.toHex2(SP)+"\n\nFlags: "+(F&bS?"S ":"- ")+(F&bZ?"Z ":"- ")+(F&bF5?"5 ":"- ")+(F&bH?"H ":"- ")+(F&bF3?"3 ":"- ")+(F&bPV?"P ":"- ")+(F&bN?"N ":"- ")+(F&bC?"C":"-")+"            IFF: "+IFF1+"     INT: "+wmsx.Util.toHex2(INT)+"     prefix: "+prefix},this.eval=function(str){return eval(str)},init()},wmsx.Z80.BASE_CLOCK=3584160,wmsx.PPI=function(a,b,c){"use strict";function d(){i=15&h}function e(){a.setPulseSignal((160&h)>0)}function f(){c.ledStateChanged(0,0==(64&h))}this.connectBus=function(a){g=a,g.connectInputDevice(168,this.inputA8),g.connectOutputDevice(168,this.outputA8),g.connectInputDevice(169,this.inputA9),g.connectOutputDevice(169,wmsx.DeviceMissing.outputPortIgnored),g.connectInputDevice(170,this.inputAA),g.connectOutputDevice(170,this.outputAA),g.connectInputDevice(171,wmsx.DeviceMissing.inputPortIgnored),g.connectOutputDevice(171,this.outputAB)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.reset=function(){h=80,i=0,e(),f()},this.inputA8=function(){return g.getPrimarySlotConfig()},this.outputA8=function(a){g.setPrimarySlotConfig(a)},this.inputA9=function(){return b.readKeyboardPort(i)},this.inputAA=function(){return h},this.outputAA=function(a){var b=h^a;b&&(h=a,15&b&&d(),160&b&&e(),64&b&&f())},this.outputAB=function(a){var b=(14&a)>>>1;0==(1&a)?h&=~(1<<b):h|=1<<b,b<=3?d():5===b||7===b?e():6===b&&f()};var g,h=80,i=0;this.saveState=function(){return{c:h}},this.loadState=function(a){h=a.c||0,d(),e(),f()}},wmsx.VDP=function(machine,cpu){"use strict";function init(){videoSignal=new wmsx.VideoSignal(self),cpuClockPulses=cpu.clockPulses,audioClockPulse32=machine.getAudioSocket().audioClockPulse32,initFrameResources(!1),initColorCaches(),initDebugPatternTables(),initSpritesConflictMap(),modeData=modes[0],pendingBackdropCacheUpdate=!0,self.setDefaults(),commandProcessor=new wmsx.VDPCommandProcessor,commandProcessor.connectVDP(self,vram,register,status),commandProcessor.setVDPModeData(modeData)}function registerWrite(a,b){if(!(a>46)){var c,d=register[a]^b;switch(register[a]=b,a){case 0:16&d&&updateIRQ(),14&d&&updateMode();break;case 1:32&d&&updateIRQ(),64&d&&(blankingChangePending=!0),24&d&&updateMode(),4&d&&updateBlinking(),3&d&&updateSpritesConfig();break;case 2:127&d&&updateLayoutTableAddress();break;case 10:if(0==(7&d))break;case 3:c=131071&(register[10]<<14|register[3]<<6),colorTableAddress=c&modeData.colorTBase,colorTableAddressMask=c|colorTableAddressMaskBase;break;case 4:if(0==(63&d))break;c=b<<11&131071,patternTableAddress=c&modeData.patTBase,patternTableAddressMask=c|patternTableAddressMaskBase;break;case 11:if(0==(3&d))break;case 5:c=131071&(register[11]<<15|register[5]<<7),spriteAttrTableAddress=c&modeData.sprAttrTBase;break;case 6:63&d&&updateSpritePatternTableAddress();break;case 7:d&(modeData.bdPaletted?15:255)&&updateBackdropColor();break;case 8:32&d&&updateTransparency(),2&d&&updateSpritesConfig();break;case 9:128&d&&updateSignalMetrics(!1),8&d&&updateRenderMetrics(!1),4&d&&updateLayoutTableAddressMask(),2&d&&updateVideoStandardSoft();break;case 13:updateBlinking();break;case 14:7&d&&(vramPointer=(7&b)<<14|16383&vramPointer);break;case 16:paletteFirstWrite=null;break;case 18:15&d&&(horizontalAdjust=(15&b^7)-7),240&d&&(verticalAdjust=(b>>>4^7)-7,updateSignalMetrics(!1));break;case 19:horizontalIntLine=b-register[23]&255;break;case 23:horizontalIntLine=register[19]-b&255;break;case 25:isV9958&&(24&d&&updateMode(),leftMask=0!=(2&b),leftScroll2Pages=0!=(1&b));break;case 26:isV9958&&(leftScrollChars=63&b,leftScrollCharsInPage=31&leftScrollChars);break;case 27:isV9958&&(rightScrollPixels=7&b);break;case 44:commandProcessor.cpuWrite(b);break;case 46:commandProcessor.startCommand(b)}}}function updateLayoutTableAddress(){var a=modeData.vramInter?(63&register[2])<<11|1024:(127&register[2])<<10;layoutTableAddress=a&modeData.layTBase,layoutTableAddressMaskSetValue=a|layoutTableAddressMaskBase,updateLayoutTableAddressMask()}function updateLayoutTableAddressMask(){layoutTableAddressMask=layoutTableAddressMaskSetValue&(blinkEvenPage||4&register[9]&&0==(2&status[2])?modeData.blinkPageMask:-1)}function updateSpritePatternTableAddress(){
spritePatternTableAddress=debugModeSpriteInfo?16===spritesSize?DEBUG_PAT_DIGI16_TABLE_ADDRESS:DEBUG_PAT_DIGI8_TABLE_ADDRESS:register[6]<<11&131071}function getStatus0(){var a=0;return verticalIntReached&&(a|=128,verticalIntReached=!1,updateIRQ()),spritesCollided&&(a|=32,spritesCollided=!1),spritesInvalid>=0?(a|=64|spritesInvalid,spritesInvalid=-1):a|=spritesMaxComputed,spritesMaxComputed=0,a}function checkVRAMPointerWrap(){0==(16383&vramPointer)&&(modeData.isV9938&&(register[14]=register[14]+1&7),vramPointer=register[14]<<14)}function paletteRegisterWrite(a,b,c){if(paletteRegister[a]!==b||c){paletteRegister[a]=b;var d=colors512[(1792&b)>>>2|(112&b)>>>1|7&b];colorPaletteReal[a]=d,debugModeSpriteHighlight&&(d&=DEBUG_DIM_ALPHA_MASK),colorPaletteSolid[a]=d,0===a?color0Solid&&(colorPalette[0]=d):colorPalette[a]=d,a===backdropColor?updateBackdropValue():modeData.tiled&&a<=3&&(pendingBackdropCacheUpdate=!0)}}function setDebugMode(a){debugMode=(a+8)%8;var b=debugModeSpriteHighlight;debugModeSpriteHighlight=debugMode>=1&&debugMode<=3,debugModeSpriteInfo=2===debugMode||3===debugMode,debugModeSpriteInfoNumbers=2===debugMode,debugModeSpritesHidden=debugMode>=4;var c=debugModePatternInfo;debugModePatternInfo=debugMode>=5,debugModePatternInfoBlocks=6===debugMode,debugModePatternInfoNames=7===debugMode,b===debugModeSpriteHighlight&&c===debugModePatternInfo||debugAdjustPalette(),initFrameResources(debugModeSpriteHighlight),updateLineActiveType(),updateSpritesConfig(),updateSpritePatternTableAddress(),videoSignal.setDebugMode(debugMode>0)}function setSpriteDebugMode(a){spriteDebugMode=a>=0?a%4:4+a,spriteDebugModeLimit=0===spriteDebugMode||2===spriteDebugMode,spriteDebugModeCollisions=spriteDebugMode<2}function debugAdjustPalette(){if(isV9918)initColorPalette();else for(var a=0;a<16;a++)paletteRegisterWrite(a,paletteRegister[a],!0)}function updateSynchronization(){pulldown=1===vSynchMode?videoStandard.pulldowns[machine.getVideoClockSocket().getVSynchNativeFrequency()]||videoStandard.pulldowns.TIMER:videoStandard.pulldowns.TIMER}function cycleEvents(){var a=framePulldown.linesPerCycle;pulldown.steps>1&&frame%pulldown.steps==0&&(a+=pulldown.firstStepCycleLinesAdjust);for(var b=a;b>0;b-=1)lineEvents(),(currentScanline+=1)>=finishingScanline&&finishFrame()}function lineEvents(){blinkPerLine&&blinkPageDuration>0&&clockPageBlinking()&&updateLayoutTableAddressMask(),currentScanline===startingActiveScanline?setActiveDisplay():currentScanline-frameStartingActiveScanline===signalActiveHeight&&setBorderDisplay(),cpuClockPulses(33),audioClockPulse32(),blankingChangePending&&updateLineActiveType(),1&status[1]&&0==(16&register[0])&&(status[1]&=-2),currentScanline===startingActiveScanline-1?status[2]&=-65:currentScanline-frameStartingActiveScanline===signalActiveHeight&&triggerVerticalInterrupt(),cpuClockPulses(10),status[2]&=-33,cpuClockPulses(22),audioClockPulse32(),cpuClockPulses(33),audioClockPulse32(),cpuClockPulses(32),audioClockPulse32(),currentScanline>=startingVisibleTopBorderScanline&&currentScanline<startingInvisibleScanline&&renderLine(),cpuClockPulses(33),audioClockPulse32(),cpuClockPulses(32),audioClockPulse32(),cpuClockPulses(18),status[2]|=32,currentScanline-frameStartingActiveScanline===horizontalIntLine&&triggerHorizontalInterrupt(),cpuClockPulses(15),audioClockPulse32(),0==(7&currentScanline)&&audioClockPulse32()}function triggerVerticalInterrupt(){status[2]|=64,verticalIntReached||(verticalIntReached=!0,updateIRQ())}function triggerHorizontalInterrupt(){0==(1&status[1])&&(status[1]|=1,updateIRQ())}function updateIRQ(){verticalIntReached&&32&register[1]||1&status[1]&&16&register[0]?cpu.setINTChannel(0,0):cpu.setINTChannel(0,1)}function updateVRAMInterleaving(){!0!==modeData.vramInter||vramInterleaving?!1===modeData.vramInter&&vramInterleaving&&vramExitInterleaving():vramEnterInterleaving()}function vramEnterInterleaving(){for(var a=0,b=VRAM_SIZE>>1,c=vram.slice(0,b),d=0;d<VRAM_SIZE;d+=2)vram[d]=c[a++],vram[d+1]=vram[b++];vramInterleaving=!0}function vramExitInterleaving(){for(var a=VRAM_SIZE>>1,b=0,c=a,d=vram.slice(a),e=0;e<a;e+=2)vram[b++]=vram[e],vram[c++]=vram[e+1];for(e=0;e<a;e+=2)vram[b++]=d[e],vram[c++]=d[e+1];vramInterleaving=!1}function setMode(a){registerWrite(0,-15&register[0]|(7&a)<<1),registerWrite(1,-25&register[1]|24&a)}function updateMode(){var a=modeData,b=24&register[1]|(register[0]&(isV9918?2:14))>>>1;commandProcessor.setVDPModeData(modes[b]),isV9958&&0!=(8&register[25])&&0==(16&b)&&(b=32|(24&register[25])>>3),modeData=modes[b];var c;updateLayoutTableAddress(),c=131071&(register[10]<<14|register[3]<<6),colorTableAddress=c&modeData.colorTBase,colorTableAddressMask=c|colorTableAddressMaskBase,c=register[4]<<11&131071,patternTableAddress=c&modeData.patTBase,patternTableAddressMask=c|patternTableAddressMaskBase,c=131071&(register[11]<<15|register[5]<<7),spriteAttrTableAddress=c&modeData.sprAttrTBase,updateSpritePatternTableAddress(),modeData.bdPaletted!==a.bdPaletted&&updateBackdropColor(),modeData.tiled!==a.tiled&&(pendingBackdropCacheUpdate=!0),updateVRAMInterleaving(),updateLineActiveType(),updateRenderMetrics(!1)}function updateVideoStandardSoft(){var a=2&register[9];machine.setVideoStandardSoft(a?wmsx.VideoStandard.PAL:wmsx.VideoStandard.NTSC)}function updateSignalMetrics(a){var b;isV9918?(signalActiveHeight=192,b=0):128&register[9]?(signalActiveHeight=212,b=0):(signalActiveHeight=192,b=10),startingVisibleTopBorderScanline=8,startingActiveScanline=startingVisibleTopBorderScanline+8+b+verticalAdjust,startingInvisibleScanline=startingActiveScanline+signalActiveHeight+8+b-verticalAdjust,finishingScanline=frameVideoStandard.totalHeight,a&&(frameStartingActiveScanline=startingActiveScanline)}function updateRenderMetrics(a){var b,c,d,e,f=!1;isV9918?(b=wmsx.VDP.SIGNAL_WIDTH_V9918,d=2,c=wmsx.VDP.SIGNAL_HEIGHT_V9918,e=2):(512===modeData.width?(b=544,d=1):(b=272,d=2),8&register[9]?(c=456,e=1):(c=228,e=2)),renderMetricsChangePending=!1,b===renderWidth&&c===renderHeight||(b!==renderWidth&&(currentScanline<startingVisibleTopBorderScanline||b>renderWidth?(currentScanline>=startingVisibleTopBorderScanline&&stretchFromCurrentToTopScanline(),renderWidth=b,f=!0):renderMetricsChangePending=!0),c!==renderHeight&&(a?(cleanFrameBuffer(),renderHeight=c,f=!0):renderMetricsChangePending=!0),f&&videoSignal.setPixelMetrics(d,e))}function setActiveDisplay(){renderLine=renderLineActive}function setBorderDisplay(){renderLine=renderLineBorders}function updateLineActiveType(){var a=renderLine===renderLineActive;renderLineActive=0==(64&register[1])?renderLineBlanked:debugModePatternInfo?modeData.renderLinePatInfo:modeData.renderLine,a&&(renderLine=renderLineActive),blankingChangePending=!1}function updateSpritesConfig(){spritesEnabled=!debugModeSpritesHidden&&0==(2&register[8]),spritesSize=2&register[1]?16:8,spritesMag=1&register[1]}function updateTransparency(){color0Solid=0!=(32&register[8]),colorPalette[0]=color0Solid?colorPaletteSolid[0]:backdropValue}function updateBackdropColor(){backdropColor=register[7]&(modeData.bdPaletted?15:255),updateBackdropValue()}function updateBackdropValue(){var a=debugModePatternInfo?debugBackdropValue:modeData.bdPaletted?colorPaletteSolid[backdropColor]:colors256[backdropColor];backdropValue!==a&&(backdropValue=a,color0Solid||(colorPalette[0]=a),pendingBackdropCacheUpdate=!0)}function updateBackdropCache(){if(modeData.tiled&&!debugModePatternInfo){for(var a=colorPaletteSolid[backdropColor>>>2],b=colorPaletteSolid[3&backdropColor],c=0;c<LINE_WIDTH;c+=2)backdropFullLineCache[c]=a,backdropFullLineCache[c+1]=b;backdropTileOdd=a,backdropTileEven=b}else wmsx.Util.arrayFill(backdropFullLineCache,backdropValue),modeData.tiled&&(backdropTileOdd=backdropTileEven=backdropValue);pendingBackdropCacheUpdate=!1}function updateBlinking(){blinkPerLine=0!=(4&register[1]),register[13]>>>4==0?(blinkEvenPage=!1,
blinkPageDuration=0):0==(15&register[13])?(blinkEvenPage=!0,blinkPageDuration=0):(blinkEvenPage=!0,blinkPageDuration=1),updateLayoutTableAddressMask()}function clockPageBlinking(){return 0==--blinkPageDuration&&(blinkEvenPage=!blinkEvenPage,blinkPageDuration=10*(register[13]>>>(blinkEvenPage?4:0)&15),!0)}function renderLineBorders(){pendingBackdropCacheUpdate&&updateBackdropCache(),frameBackBuffer.set(backdropFullLineCache,bufferPosition),bufferPosition+=bufferLineAdvance}function renderLineBlanked(){renderLineBorders()}function getRealLine(){return currentScanline-frameStartingActiveScanline+register[23]&255}function renderLineModeT1(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=register[7],d=patternTableAddress+(7&b),e=colorPalette[c>>>4],f=colorPalette[15&c],g=layoutTableAddress+40*(b>>>3);paintBackdrop8(a),a+=8;for(var h=0;h<40;++h){var i=vram[g++];paintPattern6(a,vram[(i<<3)+d],e,f),a+=6}paintBackdrop8(a),a+=8,a-=rightScrollPixels+256,leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeT2(){paintBackdrop32(bufferPosition),paintBackdrop32(bufferPosition+512);var a,b,c,d,e,f=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),g=getRealLine(),h=patternTableAddress+(7&g),i=layoutTableAddress+80*(g>>>3);if(paintBackdrop16(f),f+=16,blinkEvenPage)for(var j=colorTableAddress+10*(g>>>3),k=7,l=0;l<80;++l){var m=vram[j&colorTableAddressMask]>>>k&1;a=vram[i++&layoutTableAddressMask],c=register[m?12:7],b=vram[(a<<3)+h],d=m?colorPaletteSolid[c>>>4]:colorPalette[c>>>4],e=m?colorPaletteSolid[15&c]:colorPalette[15&c],paintPattern6(f,b,d,e),--k<0&&(j++,k=7),f+=6}else for(c=register[7],d=colorPalette[c>>>4],e=colorPalette[15&c],l=0;l<80;++l)a=vram[i++&layoutTableAddressMask],b=vram[(a<<3)+h],paintPattern6(f,b,d,e),f+=6;paintBackdrop16(f),f+=16,f-=512+(rightScrollPixels<<1),leftMask&&paintBackdrop16(f),rightScrollPixels&&paintBackdrop16(f+512),bufferPosition+=bufferLineAdvance}function renderLineModeMC(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=patternTableAddress+((b>>>3&3)<<1)+(b>>>2&1),d=layoutTableAddress+(b>>>3<<5),e=d+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(e&=modeData.evenPageMask);for(var f=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,g=0;g<32;++g){g===f&&(e=leftScroll2Pages&&leftScrollChars>=32?d&modeData.evenPageMask:d);var h=vram[e++],i=(h<<3)+c,j=vram[i];paintPattern8(a,240,colorPalette[j>>>4],colorPalette[15&j]),a+=8}a-=rightScrollPixels+256,renderSpritesLineMode1(b,a),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG1(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=patternTableAddress+(7&b),d=layoutTableAddress+(b>>>3<<5),e=d+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(e&=modeData.evenPageMask);for(var f=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,g=0;g<32;++g){g===f&&(e=leftScroll2Pages&&leftScrollChars>=32?d&modeData.evenPageMask:d);var h=vram[e++],i=vram[colorTableAddress+(h>>>3)];paintPattern8(a,vram[(h<<3)+c],colorPalette[i>>>4],colorPalette[15&i]),a+=8}a-=rightScrollPixels+256,renderSpritesLineMode1(b,a),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG2(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=colorTableAddress+(7&b),d=patternTableAddress+(7&b),e=(192&b)<<2,f=layoutTableAddress+(b>>>3<<5),g=f+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(g&=modeData.evenPageMask);for(var h=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,i=0;i<32;++i){i===h&&(g=leftScroll2Pages&&leftScrollChars>=32?f&modeData.evenPageMask:f);var j=vram[g++]|e,k=vram[(j<<3)+c&colorTableAddressMask];paintPattern8(a,vram[(j<<3)+d&patternTableAddressMask],colorPalette[k>>>4],colorPalette[15&k]),a+=8}a-=rightScrollPixels+256,renderSpritesLineMode1(b,a),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG3(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=colorTableAddress+(7&b),d=patternTableAddress+(7&b),e=(192&b)<<2,f=layoutTableAddress+(b>>>3<<5),g=f+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(g&=modeData.evenPageMask);for(var h=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,i=0;i<32;++i){i===h&&(g=leftScroll2Pages&&leftScrollChars>=32?f&modeData.evenPageMask:f);var j=vram[g++]|e,k=vram[(j<<3)+c&colorTableAddressMask];paintPattern8(a,vram[(j<<3)+d&patternTableAddressMask],colorPalette[k>>>4],colorPalette[15&k]),a+=8}a-=rightScrollPixels+256,spritesEnabled&&renderSpritesLineMode2(b,a,colorPaletteReal),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG4(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=layoutTableAddress+(b<<7),d=c+(leftScrollCharsInPage<<2);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d++&layoutTableAddressMask];frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g]}a-=rightScrollPixels+256,spritesEnabled&&renderSpritesLineMode2(b,a,colorPaletteReal),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG5(){paintBackdrop32Tiled(bufferPosition),paintBackdrop32Tiled(bufferPosition+512);var a=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),b=getRealLine(),c=layoutTableAddress+(b<<7),d=c+(leftScrollCharsInPage<<2);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1;if(color0Solid)for(var f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d++&layoutTableAddressMask];frameBackBuffer[a++]=colorPaletteSolid[g>>>6],frameBackBuffer[a++]=colorPaletteSolid[g>>>4&3],frameBackBuffer[a++]=colorPaletteSolid[g>>>2&3],frameBackBuffer[a++]=colorPaletteSolid[3&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPaletteSolid[g>>>6],frameBackBuffer[a++]=colorPaletteSolid[g>>>4&3],frameBackBuffer[a++]=colorPaletteSolid[g>>>2&3],frameBackBuffer[a++]=colorPaletteSolid[3&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPaletteSolid[g>>>6],frameBackBuffer[a++]=colorPaletteSolid[g>>>4&3],frameBackBuffer[a++]=colorPaletteSolid[g>>>2&3],frameBackBuffer[a++]=colorPaletteSolid[3&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPaletteSolid[g>>>6],frameBackBuffer[a++]=colorPaletteSolid[g>>>4&3],
frameBackBuffer[a++]=colorPaletteSolid[g>>>2&3],frameBackBuffer[a++]=colorPaletteSolid[3&g]}else for(f=0;f<32;++f)f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c),g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,frameBackBuffer[a++]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,frameBackBuffer[a++]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,frameBackBuffer[a++]=3&g?colorPaletteSolid[3&g]:backdropTileEven,g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,frameBackBuffer[a++]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,frameBackBuffer[a++]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,frameBackBuffer[a++]=3&g?colorPaletteSolid[3&g]:backdropTileEven,g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,frameBackBuffer[a++]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,frameBackBuffer[a++]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,frameBackBuffer[a++]=3&g?colorPaletteSolid[3&g]:backdropTileEven,g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,frameBackBuffer[a++]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,frameBackBuffer[a++]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,frameBackBuffer[a++]=3&g?colorPaletteSolid[3&g]:backdropTileEven;a-=512+(rightScrollPixels<<1),spritesEnabled&&renderSpritesLineMode2Tiled(b,a),leftMask&&paintBackdrop16Tiled(a),rightScrollPixels&&paintBackdrop16Tiled(a+512),bufferPosition+=bufferLineAdvance}function renderLineModeG6(){paintBackdrop32(bufferPosition),paintBackdrop32(bufferPosition+512);var a=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),b=getRealLine(),c=layoutTableAddress+(b<<8),d=c+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d++&layoutTableAddressMask];frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g],g=vram[d++&layoutTableAddressMask],frameBackBuffer[a++]=colorPalette[g>>>4],frameBackBuffer[a++]=colorPalette[15&g]}a-=512+(rightScrollPixels<<1),spritesEnabled&&renderSpritesLineMode2Stretched(b,a),leftMask&&paintBackdrop16(a),rightScrollPixels&&paintBackdrop16(a+512),bufferPosition+=bufferLineAdvance}function renderLineModeG7(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=debugModeSpriteHighlight?DEBUG_DIM_ALPHA_MASK:4294967295,d=layoutTableAddress+(b<<8),e=d+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(e&=modeData.evenPageMask);for(var f=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,g=0;g<32;++g)g===f&&(e=leftScroll2Pages&&leftScrollChars>=32?d&modeData.evenPageMask:d),frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c,frameBackBuffer[a++]=colors256[vram[e++&layoutTableAddressMask]]&c;a-=rightScrollPixels+256,spritesEnabled&&renderSpritesLineMode2(b,a,spritePaletteG7),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeYJK(){paintBackdrop20(bufferPosition),paintBackdrop16(bufferPosition+256+4);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels+4,b=getRealLine(),c=layoutTableAddress+(b<<8),d=c+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e,f,g,h,i,j,k,l,m,n,o=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,p=4278190080&(debugModeSpriteHighlight?DEBUG_DIM_ALPHA_MASK:4278190080),q=0;q<32;++q)q===o&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c),e=vram[d++&layoutTableAddressMask],f=vram[d++&layoutTableAddressMask],g=vram[d++&layoutTableAddressMask],h=vram[d++&layoutTableAddressMask],j=(7&g|(3&h)<<3)-((4&h)<<3),k=(7&e|(3&f)<<3)-((4&f)<<3),i=e>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,i=f>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,i=g>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,i=h>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,e=vram[d++&layoutTableAddressMask],f=vram[d++&layoutTableAddressMask],g=vram[d++&layoutTableAddressMask],h=vram[d++&layoutTableAddressMask],j=(7&g|(3&h)<<3)-((4&h)<<3),k=(7&e|(3&f)<<3)-((4&f)<<3),i=e>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,i=f>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,i=g>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l,i=h>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l;a-=rightScrollPixels+256,spritesEnabled&&renderSpritesLineMode2(b,a,colorPaletteReal),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeYAE(){paintBackdrop20(bufferPosition),paintBackdrop16(bufferPosition+256+4);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels+4,b=getRealLine(),c=layoutTableAddress+(b<<8),d=c+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e,f,g,h,i,j,k,l,m,n,o=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,p=4278190080&(debugModeSpriteHighlight?DEBUG_DIM_ALPHA_MASK:4278190080),q=0;q<32;++q)q===o&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c),e=vram[d++&layoutTableAddressMask],f=vram[d++&layoutTableAddressMask],g=vram[d++&layoutTableAddressMask],h=vram[d++&layoutTableAddressMask],j=(7&g|(3&h)<<3)-((4&h)<<3),k=(7&e|(3&f)<<3)-((4&f)<<3),8&e?frameBackBuffer[a++]=colorPalette[e>>4]:(i=e>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),8&f?frameBackBuffer[a++]=colorPalette[f>>4]:(i=f>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),8&g?frameBackBuffer[a++]=colorPalette[g>>4]:(i=g>>3,
l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),8&h?frameBackBuffer[a++]=colorPalette[h>>4]:(i=h>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),e=vram[d++&layoutTableAddressMask],f=vram[d++&layoutTableAddressMask],g=vram[d++&layoutTableAddressMask],h=vram[d++&layoutTableAddressMask],j=(7&g|(3&h)<<3)-((4&h)<<3),k=(7&e|(3&f)<<3)-((4&f)<<3),8&e?frameBackBuffer[a++]=colorPalette[e>>4]:(i=e>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),8&f?frameBackBuffer[a++]=colorPalette[f>>4]:(i=f>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),8&g?frameBackBuffer[a++]=colorPalette[g>>4]:(i=g>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l),8&h?frameBackBuffer[a++]=colorPalette[h>>4]:(i=h>>3,l=from5bitsTruncTo8bits(i+j),m=from5bitsTruncTo8bits(i+k),n=from5bitsTruncTo8bits(5*i-(j<<1)-k>>2),frameBackBuffer[a++]=p|n<<16|m<<8|l);a-=rightScrollPixels+256,spritesEnabled&&renderSpritesLineMode2(b,a,colorPaletteReal),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function from5bitsTruncTo8bits(a){return a<=0?0:a>=31?color5to8bits[31]:color5to8bits[a]}function renderLineModeT1PatInfo(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=7&b,d=layoutTableAddress+40*(b>>>3);paintBackdrop8(a),a+=8;for(var e=0;e<40;++e){var f=vram[d++];if(debugModePatternInfoNames){var g=0===f||32===f?4293787648:4294967295,h=vram[DEBUG_PAT_DIGI6_TABLE_ADDRESS+(f<<3)+c];paintPattern6TInfo(a,h,g,4278190080)}else h=vram[patternTableAddress+(f<<3)+c],paintPattern6(a,h,4294967295,4278190080);a+=6}paintBackdrop8(a),a+=8,a-=rightScrollPixels+256,leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeT2PatInfo(){paintBackdrop32(bufferPosition),paintBackdrop32(bufferPosition+512);var a,b,c,d=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),e=getRealLine(),f=7&e,g=layoutTableAddress+80*(e>>>3);if(paintBackdrop16(d),d+=16,blinkEvenPage)for(var h=colorTableAddress+10*(e>>>3),i=7,j=0;j<80;++j){var k=vram[h&colorTableAddressMask]>>>i&1;a=vram[g++&layoutTableAddressMask],debugModePatternInfoNames?(c=0===a||32===a?4293787648:4294967295,k&&(c&=4288716960),b=vram[DEBUG_PAT_DIGI6_TABLE_ADDRESS+(a<<3)+f],paintPattern6TInfo(d,b,c,4278190080)):(b=vram[patternTableAddress+(a<<3)+f],paintPattern6(d,b,k?4288716960:4294967295,4278190080)),--i<0&&(h++,i=7),d+=6}else for(j=0;j<80;++j)a=vram[g++&layoutTableAddressMask],debugModePatternInfoNames?(c=0===a||32===a?4293787648:4294967295,b=vram[DEBUG_PAT_DIGI6_TABLE_ADDRESS+(a<<3)+f],paintPattern6TInfo(d,b,c,4278190080)):(b=vram[patternTableAddress+(a<<3)+f],paintPattern6(d,b,4294967295,4278190080)),d+=6;paintBackdrop16(d),d+=16,d-=512+(rightScrollPixels<<1),leftMask&&paintBackdrop16(d),rightScrollPixels&&paintBackdrop16(d+512),bufferPosition+=bufferLineAdvance}function paintPattern6TInfo(a,b,c,d){var e=2550136831&c;frameBackBuffer[a]=128&b?c:d,frameBackBuffer[a+1]=64&b?c:d,frameBackBuffer[a+2]=32&b?c:d,frameBackBuffer[a+3]=16&b?e:d,frameBackBuffer[a+4]=8&b?e:d,frameBackBuffer[a+5]=4&b?e:d}function renderLineModeMCPatInfo(){if(!debugModePatternInfoNames)return renderLineModeMC();paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=layoutTableAddress+(b>>>3<<5),d=c+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d++];paintPattern8(a,vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(g<<3)+(7&b)],4294967295,4278190080),a+=8}a-=rightScrollPixels+256,renderSpritesLineMode1(b,a),leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG1PatInfo(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a,b,c,d=bufferPosition+8+horizontalAdjust+rightScrollPixels,e=getRealLine(),f=7&e,g=layoutTableAddress+(e>>>3<<5),h=g+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(h&=modeData.evenPageMask);for(var i=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,j=0;j<32;++j){j===i&&(h=leftScroll2Pages&&leftScrollChars>=32?g&modeData.evenPageMask:g);var k=vram[h++];if(debugModePatternInfoNames)b=0===k||32===k?4293787648:4294967295,c=4278190080,a=vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(k<<3)+f];else if(debugModePatternInfoBlocks){var l=vram[colorTableAddress+(k>>>3)];b=colorPalette[l>>>4],c=colorPalette[15&l],a=vram[DEBUG_PAT_BLOCK_TABLE_ADDRESS+f]}else b=4294967295,c=4278190080,a=vram[patternTableAddress+(k<<3)+f];paintPattern8(d,a,b,c),d+=8}d-=rightScrollPixels+256,renderSpritesLineMode1(e,d),leftMask&&paintBackdrop8(d),rightScrollPixels&&paintBackdrop8(d+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG2PatInfo(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a,b,c,d=bufferPosition+8+horizontalAdjust+rightScrollPixels,e=getRealLine(),f=7&e,g=(192&e)<<2,h=layoutTableAddress+(e>>>3<<5),i=h+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(i&=modeData.evenPageMask);for(var j=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,k=0;k<32;++k){k===j&&(i=leftScroll2Pages&&leftScrollChars>=32?h&modeData.evenPageMask:h);var l=vram[i++]|g;if(debugModePatternInfoNames)l&=255,b=0===l||32===l?4293787648:4294967295,c=4278190080,a=vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(l<<3)+f];else if(debugModePatternInfoBlocks){var m=vram[colorTableAddress+(l<<3)+f&colorTableAddressMask];b=colorPalette[m>>>4],c=colorPalette[15&m],a=vram[DEBUG_PAT_BLOCK_TABLE_ADDRESS+f]}else b=4294967295,c=4278190080,a=vram[patternTableAddress+(l<<3)+f&patternTableAddressMask];paintPattern8(d,a,b,c),d+=8}d-=rightScrollPixels+256,renderSpritesLineMode1(e,d),leftMask&&paintBackdrop8(d),rightScrollPixels&&paintBackdrop8(d+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG3PatInfo(){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a,b,c,d=bufferPosition+8+horizontalAdjust+rightScrollPixels,e=getRealLine(),f=7&e,g=(192&e)<<2,h=layoutTableAddress+(e>>>3<<5),i=h+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(i&=modeData.evenPageMask);for(var j=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,k=0;k<32;++k){k===j&&(i=leftScroll2Pages&&leftScrollChars>=32?h&modeData.evenPageMask:h);var l=vram[i++]|g;if(debugModePatternInfoNames)l&=255,b=0===l||32===l?4293787648:4294967295,c=4278190080,a=vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(l<<3)+f];else if(debugModePatternInfoBlocks){var m=vram[colorTableAddress+(l<<3)+f&colorTableAddressMask];b=colorPalette[m>>>4],c=colorPalette[15&m],a=vram[DEBUG_PAT_BLOCK_TABLE_ADDRESS+f]}else b=4294967295,c=4278190080,a=vram[patternTableAddress+(l<<3)+f&patternTableAddressMask];paintPattern8(d,a,b,c),d+=8}d-=rightScrollPixels+256,spritesEnabled&&renderSpritesLineMode2(e,d,colorPaletteReal),leftMask&&paintBackdrop8(d),rightScrollPixels&&paintBackdrop8(d+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function paintPattern6(a,b,c,d){frameBackBuffer[a]=128&b?c:d,frameBackBuffer[a+1]=64&b?c:d,
frameBackBuffer[a+2]=32&b?c:d,frameBackBuffer[a+3]=16&b?c:d,frameBackBuffer[a+4]=8&b?c:d,frameBackBuffer[a+5]=4&b?c:d}function paintPattern8(a,b,c,d){frameBackBuffer[a]=128&b?c:d,frameBackBuffer[a+1]=64&b?c:d,frameBackBuffer[a+2]=32&b?c:d,frameBackBuffer[a+3]=16&b?c:d,frameBackBuffer[a+4]=8&b?c:d,frameBackBuffer[a+5]=4&b?c:d,frameBackBuffer[a+6]=2&b?c:d,frameBackBuffer[a+7]=1&b?c:d}function paintBackdrop8(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[a+1]=backdropValue,frameBackBuffer[a+2]=backdropValue,frameBackBuffer[a+3]=backdropValue,frameBackBuffer[a+4]=backdropValue,frameBackBuffer[a+5]=backdropValue,frameBackBuffer[a+6]=backdropValue,frameBackBuffer[a+7]=backdropValue}function paintBackdrop16(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[a+1]=backdropValue,frameBackBuffer[a+2]=backdropValue,frameBackBuffer[a+3]=backdropValue,frameBackBuffer[a+4]=backdropValue,frameBackBuffer[a+5]=backdropValue,frameBackBuffer[a+6]=backdropValue,frameBackBuffer[a+7]=backdropValue,frameBackBuffer[a+8]=backdropValue,frameBackBuffer[a+9]=backdropValue,frameBackBuffer[a+10]=backdropValue,frameBackBuffer[a+11]=backdropValue,frameBackBuffer[a+12]=backdropValue,frameBackBuffer[a+13]=backdropValue,frameBackBuffer[a+14]=backdropValue,frameBackBuffer[a+15]=backdropValue}function paintBackdrop20(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[a+1]=backdropValue,frameBackBuffer[a+2]=backdropValue,frameBackBuffer[a+3]=backdropValue,frameBackBuffer[a+4]=backdropValue,frameBackBuffer[a+5]=backdropValue,frameBackBuffer[a+6]=backdropValue,frameBackBuffer[a+7]=backdropValue,frameBackBuffer[a+8]=backdropValue,frameBackBuffer[a+9]=backdropValue,frameBackBuffer[a+10]=backdropValue,frameBackBuffer[a+11]=backdropValue,frameBackBuffer[a+12]=backdropValue,frameBackBuffer[a+13]=backdropValue,frameBackBuffer[a+14]=backdropValue,frameBackBuffer[a+15]=backdropValue,frameBackBuffer[a+16]=backdropValue,frameBackBuffer[a+17]=backdropValue,frameBackBuffer[a+18]=backdropValue,frameBackBuffer[a+19]=backdropValue}function paintBackdrop32(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[a+1]=backdropValue,frameBackBuffer[a+2]=backdropValue,frameBackBuffer[a+3]=backdropValue,frameBackBuffer[a+4]=backdropValue,frameBackBuffer[a+5]=backdropValue,frameBackBuffer[a+6]=backdropValue,frameBackBuffer[a+7]=backdropValue,frameBackBuffer[a+8]=backdropValue,frameBackBuffer[a+9]=backdropValue,frameBackBuffer[a+10]=backdropValue,frameBackBuffer[a+11]=backdropValue,frameBackBuffer[a+12]=backdropValue,frameBackBuffer[a+13]=backdropValue,frameBackBuffer[a+14]=backdropValue,frameBackBuffer[a+15]=backdropValue,frameBackBuffer[a+16]=backdropValue,frameBackBuffer[a+17]=backdropValue,frameBackBuffer[a+18]=backdropValue,frameBackBuffer[a+19]=backdropValue,frameBackBuffer[a+20]=backdropValue,frameBackBuffer[a+21]=backdropValue,frameBackBuffer[a+22]=backdropValue,frameBackBuffer[a+23]=backdropValue,frameBackBuffer[a+24]=backdropValue,frameBackBuffer[a+25]=backdropValue,frameBackBuffer[a+26]=backdropValue,frameBackBuffer[a+27]=backdropValue,frameBackBuffer[a+28]=backdropValue,frameBackBuffer[a+29]=backdropValue,frameBackBuffer[a+30]=backdropValue,frameBackBuffer[a+31]=backdropValue}function paintBackdrop16Tiled(a){var b=backdropTileOdd,c=backdropTileEven;frameBackBuffer[a]=b,frameBackBuffer[a+1]=c,frameBackBuffer[a+2]=b,frameBackBuffer[a+3]=c,frameBackBuffer[a+4]=b,frameBackBuffer[a+5]=c,frameBackBuffer[a+6]=b,frameBackBuffer[a+7]=c,frameBackBuffer[a+8]=b,frameBackBuffer[a+9]=c,frameBackBuffer[a+10]=b,frameBackBuffer[a+11]=c,frameBackBuffer[a+12]=b,frameBackBuffer[a+13]=c,frameBackBuffer[a+14]=b,frameBackBuffer[a+15]=c}function paintBackdrop32Tiled(a){var b=backdropTileOdd,c=backdropTileEven;frameBackBuffer[a]=b,frameBackBuffer[a+1]=c,frameBackBuffer[a+2]=b,frameBackBuffer[a+3]=c,frameBackBuffer[a+4]=b,frameBackBuffer[a+5]=c,frameBackBuffer[a+6]=b,frameBackBuffer[a+7]=c,frameBackBuffer[a+8]=b,frameBackBuffer[a+9]=c,frameBackBuffer[a+10]=b,frameBackBuffer[a+11]=c,frameBackBuffer[a+12]=b,frameBackBuffer[a+13]=c,frameBackBuffer[a+14]=b,frameBackBuffer[a+15]=c,frameBackBuffer[a+16]=b,frameBackBuffer[a+17]=c,frameBackBuffer[a+18]=b,frameBackBuffer[a+19]=c,frameBackBuffer[a+20]=b,frameBackBuffer[a+21]=c,frameBackBuffer[a+22]=b,frameBackBuffer[a+23]=c,frameBackBuffer[a+24]=b,frameBackBuffer[a+25]=c,frameBackBuffer[a+26]=b,frameBackBuffer[a+27]=c,frameBackBuffer[a+28]=b,frameBackBuffer[a+29]=c,frameBackBuffer[a+30]=b,frameBackBuffer[a+31]=c}function renderSpritesLineMode1(a,b){if(!debugModeSpritesHidden&&208!==vram[spriteAttrTableAddress]){var c,d,e,f,g,h,i,j,k,l,m=spritesSize<<spritesMag,n=-1,o=0;spritesGlobalPriority-=32,c=spriteAttrTableAddress-4;for(var p=0;p<32&&(c+=4,n+=1,208!==(h=vram[c]));p+=1)if(!((i=a-h-1&255)>=m)){if(++o>4&&(spritesInvalid<0&&!verticalIntReached&&(spritesInvalid=n),spriteDebugModeLimit))return;j=vram[c+1],d=vram[c+3],128&d&&(j-=32)<=-m||(d&=15,16===spritesSize?(e=debugModeSpriteInfoNumbers?n<<2:252&vram[c+2],f=spritePatternTableAddress+(e<<3)+(i>>>spritesMag),g=vram[f]<<8|vram[f+16]):(e=debugModeSpriteInfoNumbers?n:vram[c+2],g=vram[spritePatternTableAddress+(e<<3)+(i>>>spritesMag)]),k=j<=256-m?0:j-(256-m),l=j>=0?m:m+j,j+=m-l,paintSpriteMode1(j,a,b+j,spritesGlobalPriority+n,g,d,k,l,spritesMag,spriteDebugModeCollisions&&o<5))}spritesInvalid<0&&n>spritesMaxComputed&&(spritesMaxComputed=n)}}function paintSpriteMode1(a,b,c,d,e,f,g,h,i,j){for(var k=h-1;k>=g;k-=1,a+=1,c+=1){0!==(e>>>(k>>>i)&1)&&(spritesLinePriorities[a]<d?(j&&!spritesCollided&&setSpritesCollision(a,b),0!==f&&0===spritesLineColors[a]&&(spritesLineColors[a]=f,frameBackBuffer[c]=colorPaletteReal[f])):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,0!==f&&(frameBackBuffer[c]=colorPaletteReal[f])))}}function renderSpritesLineMode2(a,b,c){if(216!==vram[spriteAttrTableAddress+512]){var d,e,f,g,h,i,j,k,l,m,n,o,p=spritesSize<<spritesMag,q=-1,r=SPRITE_MAX_PRIORITY,s=0;spritesGlobalPriority-=32,d=spriteAttrTableAddress+512-4,e=spriteAttrTableAddress-16;for(var t=0;t<32&&(q+=1,d+=4,e+=16,216!==(j=vram[d]));t+=1)if(!((k=a-j-1&255)>=p)){if(++s>8&&(spritesInvalid<0&&!verticalIntReached&&(spritesInvalid=q),spriteDebugModeLimit))return;if(k>>>=spritesMag,f=vram[e+k],o=64&f){if(r===SPRITE_MAX_PRIORITY||debugModeSpriteInfo)continue}else r=spritesGlobalPriority+q;(0!=(15&f)||color0Solid)&&(l=vram[d+1],128&f&&(l-=32)<=-p||(16===spritesSize?(g=debugModeSpriteInfoNumbers?q<<2:252&vram[d+2],h=spritePatternTableAddress+(g<<3)+k,i=vram[h]<<8|vram[h+16]):(g=debugModeSpriteInfoNumbers?q:vram[d+2],i=vram[spritePatternTableAddress+(g<<3)+k]),m=l<=256-p?0:l-(256-p),n=l>=0?p:p+l,l+=p-n,o?paintSpriteMode2CC(l,b+l,r,i,15&f,c,m,n,spritesMag):paintSpriteMode2(l,a,b+l,r,i,15&f,c,m,n,spritesMag,spriteDebugModeCollisions&&0==(32&f)&&s<9)))}spritesInvalid<0&&q>spritesMaxComputed&&(spritesMaxComputed=q)}}function paintSpriteMode2(a,b,c,d,e,f,g,h,i,j,k){for(var l=i-1;l>=h;l-=1,a+=1,c+=1){0!==(e>>>(l>>>j)&1)&&(spritesLinePriorities[a]<d?k&&!spritesCollided&&setSpritesCollision(a,b):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,frameBackBuffer[c]=g[f]))}}function paintSpriteMode2CC(a,b,c,d,e,f,g,h,i){for(var j,k=h-1;k>=g;k-=1,a+=1,b+=1){if(0!==(d>>>(k>>>i)&1)){var l=spritesLinePriorities[a];l<c||(l===c?j=e|spritesLineColors[a]:(spritesLinePriorities[a]=c,j=e),spritesLineColors[a]=j,frameBackBuffer[b]=f[j])}}}function renderSpritesLineMode2Tiled(a,b){if(216!==vram[spriteAttrTableAddress+512]){var c,d,e,f,g,h,i,j,k,l,m,n,o=spritesSize<<spritesMag,p=-1,q=SPRITE_MAX_PRIORITY,r=0;spritesGlobalPriority-=32,c=spriteAttrTableAddress+512-4,d=spriteAttrTableAddress-16;for(var s=0;s<32&&(p+=1,c+=4,d+=16,216!==(i=vram[c]));s+=1)if(!((j=a-i-1&255)>=o)){if(++r>8&&(spritesInvalid<0&&!verticalIntReached&&(spritesInvalid=p),spriteDebugModeLimit))return;if(j>>>=spritesMag,e=vram[d+j],n=64&e){if(q===SPRITE_MAX_PRIORITY||debugModeSpriteInfo)continue}else q=spritesGlobalPriority+p
;(0!=(15&e)||color0Solid)&&(k=vram[c+1],128&e&&(k-=32)<=-o||(16===spritesSize?(f=debugModeSpriteInfoNumbers?p<<2:252&vram[c+2],g=spritePatternTableAddress+(f<<3)+j,h=vram[g]<<8|vram[g+16]):(f=debugModeSpriteInfoNumbers?p:vram[c+2],h=vram[spritePatternTableAddress+(f<<3)+j]),l=k<=256-o?0:k-(256-o),m=k>=0?o:o+k,k+=o-m,n?paintSpriteMode2TiledCC(k,b+(k<<1),q,h,15&e,l,m,spritesMag):paintSpriteMode2Tiled(k,a,b+(k<<1),q,h,15&e,l,m,spritesMag,spriteDebugModeCollisions&&0==(32&e)&&r<9)))}spritesInvalid<0&&p>spritesMaxComputed&&(spritesMaxComputed=p)}}function paintSpriteMode2Tiled(a,b,c,d,e,f,g,h,i,j){for(var k=h-1;k>=g;k-=1,a+=1,c+=2){0!==(e>>>(k>>>i)&1)&&(spritesLinePriorities[a]<d?j&&!spritesCollided&&setSpritesCollision(a,b):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,frameBackBuffer[c]=colorPaletteReal[f>>>2],frameBackBuffer[c+1]=colorPaletteReal[3&f]))}}function paintSpriteMode2TiledCC(a,b,c,d,e,f,g,h){for(var i,j=g-1;j>=f;j-=1,a+=1,b+=2){if(0!==(d>>>(j>>>h)&1)){var k=spritesLinePriorities[a];k<c||(k===c?i=e|spritesLineColors[a]:(spritesLinePriorities[a]=c,i=e),spritesLineColors[a]=i,frameBackBuffer[b]=colorPaletteReal[i>>>2],frameBackBuffer[b+1]=colorPaletteReal[3&i])}}}function renderSpritesLineMode2Stretched(a,b){if(216!==vram[spriteAttrTableAddress+512]){var c,d,e,f,g,h,i,j,k,l,m,n,o=spritesSize<<spritesMag,p=-1,q=SPRITE_MAX_PRIORITY,r=0;spritesGlobalPriority-=32,c=spriteAttrTableAddress+512-4,d=spriteAttrTableAddress-16;for(var s=0;s<32&&(p+=1,c+=4,d+=16,216!==(i=vram[c]));s+=1)if(!((j=a-i-1&255)>=o)){if(++r>8&&(spritesInvalid<0&&!verticalIntReached&&(spritesInvalid=p),spriteDebugModeLimit))return;if(j>>>=spritesMag,e=vram[d+j],n=64&e){if(q===SPRITE_MAX_PRIORITY||debugModeSpriteInfo)continue}else q=spritesGlobalPriority+p;(0!=(15&e)||color0Solid)&&(k=vram[c+1],128&e&&(k-=32)<=-o||(16===spritesSize?(f=debugModeSpriteInfoNumbers?p<<2:252&vram[c+2],g=spritePatternTableAddress+(f<<3)+j,h=vram[g]<<8|vram[g+16]):(f=debugModeSpriteInfoNumbers?p:vram[c+2],h=vram[spritePatternTableAddress+(f<<3)+j]),l=k<=256-o?0:k-(256-o),m=k>=0?o:o+k,k+=o-m,n?paintSpriteMode2StretchedCC(k,b+(k<<1),q,h,15&e,l,m,spritesMag):paintSpriteMode2Stretched(k,a,b+(k<<1),q,h,15&e,l,m,spritesMag,spriteDebugModeCollisions&&0==(32&e)&&r<9)))}spritesInvalid<0&&p>spritesMaxComputed&&(spritesMaxComputed=p)}}function paintSpriteMode2Stretched(a,b,c,d,e,f,g,h,i,j){for(var k=h-1;k>=g;k-=1,a+=1,c+=2){0!==(e>>>(k>>>i)&1)&&(spritesLinePriorities[a]<d?j&&!spritesCollided&&setSpritesCollision(a,b):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,frameBackBuffer[c]=frameBackBuffer[c+1]=colorPaletteReal[f]))}}function paintSpriteMode2StretchedCC(a,b,c,d,e,f,g,h){for(var i,j=g-1;j>=f;j-=1,a+=1,b+=2){if(0!==(d>>>(j>>>h)&1)){var k=spritesLinePriorities[a];k<c||(k===c?i=e|spritesLineColors[a]:(spritesLinePriorities[a]=c,i=e),spritesLineColors[a]=i,frameBackBuffer[b]=frameBackBuffer[b+1]=colorPaletteReal[i])}}}function setSpritesCollision(a,b){spritesCollided=!0,spritesCollisionX>=0||(spritesCollisionX=a+12,spritesCollisionY=b+8,0==(192&register[8])&&(status[3]=255&spritesCollisionX,status[4]=254|spritesCollisionX>>>8,status[5]=255&spritesCollisionY,status[6]=252|spritesCollisionY>>>8))}function stretchCurrentLine(){for(var a=bufferPosition+272-1,b=bufferPosition+544-2,c=272;c>0;--c,--a,b-=2)frameBackBuffer[b]=frameBackBuffer[b+1]=frameBackBuffer[a]}function stretchFromCurrentToTopScanline(){for(var a=bufferPosition,b=currentScanline;b>=startingVisibleTopBorderScanline;--b,a-=bufferLineAdvance)for(var c=a+272-1,d=a+544-2,e=272;e>0;--e,--c,d-=2)frameBackBuffer[d]=frameBackBuffer[d+1]=frameBackBuffer[c]}function cleanFrameBuffer(){wmsx.Util.arrayFill(frameBackBuffer,modeData.tiled?4278190080:backdropValue)}function refresh(){videoSignal.newFrame(frameCanvas,refreshWidth,refreshHeight),refreshWidth=refreshHeight=0}function beginFrame(){framePulldown!==pulldown&&(frameVideoStandard=videoStandard,framePulldown=pulldown,updateSignalMetrics(!1)),currentScanline=0,frameStartingActiveScanline=startingActiveScanline,renderMetricsChangePending&&updateRenderMetrics(!0),!blinkPerLine&&blinkPageDuration>0&&clockPageBlinking(),status[2]^=2,8&register[9]?(bufferPosition=2&status[2]?LINE_WIDTH:0,bufferLineAdvance=2*LINE_WIDTH):(bufferPosition=0,bufferLineAdvance=LINE_WIDTH),updateLayoutTableAddressMask()}function finishFrame(){refreshWidth=renderWidth,refreshHeight=renderHeight,frameContext.putImageData(frameImageData,0,0,0,0,refreshWidth,refreshHeight),frame+=1,beginFrame()}function refreshDisplayMetrics(){videoSignal.setDisplayMetrics(wmsx.VDP.SIGNAL_MAX_WIDTH_V9938,isV9918?2*wmsx.VDP.SIGNAL_HEIGHT_V9918:wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938)}function initRegisters(){wmsx.Util.arrayFill(register,0),wmsx.Util.arrayFill(status,0),register[9]=videoStandard===wmsx.VideoStandard.PAL?2:0,status[1]=isV9958?4:0,status[2]=12,status[4]=254,status[6]=252,status[9]=254}function initFrameResources(a){(!frameCanvas||!frameContextUsingAlpha&&a)&&(frameContextUsingAlpha=!!a,frameCanvas=document.createElement("canvas"),frameCanvas.width=wmsx.VDP.SIGNAL_MAX_WIDTH_V9938,frameCanvas.height=wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938,frameContext=frameCanvas.getContext("2d",{alpha:frameContextUsingAlpha,antialias:!1}),frameImageData||(frameImageData=frameContext.createImageData(frameCanvas.width,frameCanvas.height+1+1),frameBackBuffer=new Uint32Array(frameImageData.data.buffer,0,frameCanvas.width*(frameCanvas.height+1)),backdropFullLineCache=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*(frameCanvas.height+1)*4,frameCanvas.width)))}function initColorPalette(){for(var a=isV9918?colorPaletteInitialV9918:colorPaletteInitialV9938,b=0;b<16;b+=1){paletteRegister[b]=paletteRegisterInitialValuesV9938[b];var c=a[b];colorPaletteReal[b]=c,debugModeSpriteHighlight&&(c&=DEBUG_DIM_ALPHA_MASK),colorPalette[b]=c,colorPaletteSolid[b]=c}}function initColorCaches(){for(var a=0;a<=511;a++)1&a&&(colors256[a>>>1]=4278190080|color2to8bits[a>>>1&3]<<16|color3to8bits[a>>>6]<<8|color3to8bits[a>>>3&7]),colors512[a]=4278190080|color3to8bits[7&a]<<16|color3to8bits[a>>>6]<<8|color3to8bits[a>>>3&7]}function initDebugPatternTables(){for(var a=[["111","101","101","101","111"],["110","010","010","010","111"],["111","001","111","100","111"],["111","001","111","001","111"],["101","101","111","001","001"],["111","100","111","001","111"],["111","100","111","101","111"],["111","001","001","001","001"],["111","101","111","101","111"],["111","101","111","001","001"],["110","001","111","101","111"],["100","100","111","101","110"],["000","111","100","100","111"],["001","001","111","101","111"],["110","101","111","100","011"],["011","100","110","100","100"]],b=DEBUG_PAT_DIGI6_TABLE_ADDRESS,c=DEBUG_PAT_DIGI8_TABLE_ADDRESS,d=DEBUG_PAT_DIGI16_TABLE_ADDRESS,e=DEBUG_PAT_BLOCK_TABLE_ADDRESS,f=0;f<256;f++){for(var g=f/16|0,h=f%16,i=0;i<5;i++)vram[b++]=parseInt(a[g][i]+a[h][i]+"00",2),vram[c++]=parseInt(a[g][i]+"0"+a[h][i]+"0",2);for(vram[b++]=vram[c++]=parseInt("00000000",2),vram[b++]=vram[c++]=parseInt("01111100",2),vram[b++]=vram[c++]=parseInt("00000000",2),vram[d++]=parseInt("11111111",2),i=0;i<4;i++)vram[d++]=parseInt("10000000",2);for(i=0;i<5;i++)vram[d++]=parseInt("1000"+a[g][i]+"0",2);for(i=0;i<5;i++)vram[d++]=parseInt("10000000",2);for(i=0;i<2;i++)vram[d++]=parseInt("11111111",2);for(i=0;i<4;i++)vram[d++]=parseInt("00000001",2);for(i=0;i<5;i++)vram[d++]=parseInt("0"+a[h][i]+"0001",2);for(i=0;i<5;i++)vram[d++]=parseInt("00000001",2);vram[d++]=parseInt("11111111",2)}vram[e]=vram[e+7]=0,vram[e+1]=vram[e+2]=vram[e+3]=vram[e+4]=vram[e+5]=vram[e+6]=126}function initSpritesConflictMap(){wmsx.Util.arrayFill(spritesLinePriorities,SPRITE_MAX_PRIORITY),wmsx.Util.arrayFill(spritesLineColors,0),spritesGlobalPriority=SPRITE_MAX_PRIORITY}function logInfo(a){cpu.getBUSCycles()
;console.log(a+", currentScanLine: "+currentScanline+", activeRenderScanline: "+(currentScanline-frameStartingActiveScanline)+", activeHeigh: "+signalActiveHeight)}var self=this;this.setMachineType=function(a){var b=WMSX.VDP_TYPE>0?WMSX.VDP_TYPE:a;isV9918=b<=1,isV9938=2===b,isV9958=b>=3,refreshDisplayMetrics()},this.connectBus=function(a){a.connectInputDevice(152,this.input98),a.connectOutputDevice(152,this.output98),a.connectInputDevice(153,this.input99),a.connectOutputDevice(153,this.output99),a.connectInputDevice(154,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(154,this.output9a),a.connectInputDevice(155,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(155,this.output9b)},this.powerOn=function(){this.reset()},this.powerOff=function(){videoSignal.signalOff()},this.setVideoStandard=function(a){videoStandard=a,updateSynchronization()},this.setVSynchMode=function(a){vSynchMode=a,updateSynchronization()},this.getVideoOutput=function(){return videoSignal},this.getDesiredVideoPulldown=function(){return pulldown},this.videoClockPulse=function(){cycleEvents(),refreshWidth&&refresh()},this.input98=function(){dataFirstWrite=null;var a=dataPreRead;return dataPreRead=vram[vramPointer++],checkVRAMPointerWrap(),a},this.output98=function(a){dataFirstWrite=null,vram[vramPointer++]=dataPreRead=a,checkVRAMPointerWrap()},this.input99=function(){dataFirstWrite=null;var a,b=register[15];switch(b){case 0:a=getStatus0();break;case 1:a=status[1],status[1]&=-129,16&register[0]&&1&status[1]&&(status[1]&=-2,updateIRQ());break;case 2:commandProcessor.updateStatus(),a=status[2];break;case 3:case 4:case 6:a=status[b];break;case 5:a=status[5],spritesCollisionX=spritesCollisionY=-1,status[3]=status[4]=status[5]=status[6]=0;break;case 7:a=status[7],commandProcessor.cpuRead();break;case 8:case 9:a=status[b];break;default:a=255}return a},this.output99=function(a){null===dataFirstWrite?(dataFirstWrite=a,isV9918&&(vramPointer=-256&vramPointer|a)):(128&a?isV9918?(registerWrite(7&a,dataFirstWrite),vramPointer=114943&vramPointer|(63&a)<<8):0==(64&a)&&registerWrite(63&a,dataFirstWrite):(vramPointer=114688&vramPointer|(63&a)<<8|dataFirstWrite,0==(64&a)&&(dataPreRead=vram[vramPointer++],checkVRAMPointerWrap())),dataFirstWrite=null)},this.output9a=function(a){isV9918||(null===paletteFirstWrite?paletteFirstWrite=a:(paletteRegisterWrite(register[16],a<<8|paletteFirstWrite,!1),++register[16]>15&&(register[16]=0),paletteFirstWrite=null))},this.output9b=function(a){if(!isV9918){var b=63&register[17];17!==b&&registerWrite(b,a),0==(128&register[17])&&(register[17]=b+1&63)}},this.toggleDebugModes=function(a){return setDebugMode(debugMode+(a?-1:1)),videoSignal.showOSD("Debug Mode"+(debugMode>0?" "+debugMode:"")+": "+["OFF","Sprites Highlighted","Sprite Numbers","Sprite Names","Sprites Hidden","Pattern Bits","Pattern Color Blocks","Pattern Names"][debugMode],!0),debugMode},this.toggleSpriteDebugModes=function(a){setSpriteDebugMode(spriteDebugMode+(a?-1:1)),videoSignal.showOSD("Sprites Mode"+(spriteDebugMode>0?" "+spriteDebugMode:"")+": "+["Normal","Unlimited","NO Collisions","Unlimited, No Collisions"][spriteDebugMode],!0)},this.getSpriteDebugModeQuickDesc=function(){return["Normal","Unlimited","No Collis.","Both"][spriteDebugMode]},this.setVDPTurboMulti=function(a){commandProcessor.setVDPTurboMulti(a)},this.getVDPTurboMulti=function(){return commandProcessor.getVDPTurboMulti()},this.setDefaults=function(){setDebugMode(STARTING_DEBUG_MODE),setSpriteDebugMode(STARTING_SPRITES_DEBUG_MODE)},this.reset=function(){frame=cycles=lastBUSCyclesComputed=0,dataFirstWrite=null,dataPreRead=0,vramPointer=0,paletteFirstWrite=null,verticalAdjust=horizontalAdjust=0,leftMask=leftScroll2Pages=!1,leftScrollChars=leftScrollCharsInPage=rightScrollPixels=0,backdropColor=backdropValue=0,spritesCollided=!1,spritesCollisionX=spritesCollisionY=spritesInvalid=-1,spritesMaxComputed=0,verticalIntReached=!1,horizontalIntLine=0,vramInterleaving=!1,renderMetricsChangePending=!1,refreshWidth=refreshHeight=0,frameVideoStandard=videoStandard,framePulldown=pulldown,currentScanline=-1,initRegisters(),initColorPalette(),commandProcessor.reset(),updateSignalMetrics(!0),updateIRQ(),updateMode(),updateSpritesConfig(),updateBackdropColor(),updateTransparency(),updateSynchronization(),updateBlinking(),beginFrame()},this.updateCycles=function(){var a=cpu.getBUSCycles();if(a===lastBUSCyclesComputed)return cycles;var b=6*(a-lastBUSCyclesComputed);return lastBUSCyclesComputed=a,cycles+=b},this.getScreenText=function(){var a=modeData.textCols;if(!a)return null;for(var b=128&register[9]?27:24,c=[],d=0;d<b;++d)c.push(wmsx.Util.int8BitArrayToByteString(vram,layoutTableAddress+d*a,a).replace(/\s+$/,""));return c.join("\n").replace(/[\x00\xff]/g," ").replace(/\s+$/,"")};var LINE_WIDTH=wmsx.VDP.SIGNAL_MAX_WIDTH_V9938,SPRITE_MAX_PRIORITY=9e15,DEBUG_DIM_ALPHA_MASK=1090519039,VRAM_SIZE=wmsx.VDP.VRAM_LIMIT+1,DEBUG_PAT_DIGI6_TABLE_ADDRESS=VRAM_SIZE,DEBUG_PAT_DIGI8_TABLE_ADDRESS=DEBUG_PAT_DIGI6_TABLE_ADDRESS+2048,DEBUG_PAT_DIGI16_TABLE_ADDRESS=DEBUG_PAT_DIGI8_TABLE_ADDRESS+2048,DEBUG_PAT_BLOCK_TABLE_ADDRESS=DEBUG_PAT_DIGI16_TABLE_ADDRESS+8192,VRAM_TOTAL_SIZE=DEBUG_PAT_BLOCK_TABLE_ADDRESS+8,STARTING_DEBUG_MODE=WMSX.DEBUG_MODE,STARTING_SPRITES_DEBUG_MODE=WMSX.SPRITES_DEBUG_MODE,frameCanvas,frameContext,frameImageData,frameBackBuffer,backdropFullLineCache,frameContextUsingAlpha=!1,isV9918,isV9938,isV9958,vram=wmsx.Util.arrayFill(new Array(VRAM_TOTAL_SIZE),0);this.vram=vram;var vramInterleaving,frame,blinkEvenPage,blinkPageDuration,blinkPerLine,vSynchMode,videoStandard,pulldown,bufferPosition,bufferLineAdvance,currentScanline,cycles,lastBUSCyclesComputed,signalActiveHeight,finishingScanline,startingActiveScanline,frameStartingActiveScanline,startingVisibleTopBorderScanline,startingInvisibleScanline,frameVideoStandard,framePulldown,verticalIntReached=!1,horizontalIntLine=0,status=new Array(10),register=new Array(47),paletteRegister=new Array(16),modeData,renderMetricsChangePending,renderWidth,renderHeight,refreshWidth,refreshHeight,blankingChangePending,pendingBackdropCacheUpdate,spritesEnabled,spritesSize,spritesMag,spritesCollided,spritesInvalid,spritesMaxComputed,spritesCollisionX,spritesCollisionY,spritesLinePriorities=new Array(256),spritesLineColors=new Array(256),spritesGlobalPriority,vramPointer=0,paletteFirstWrite,dataFirstWrite=null,dataPreRead=0,backdropColor,backdropValue,backdropTileOdd,backdropTileEven,verticalAdjust,horizontalAdjust,leftMask,leftScroll2Pages,leftScrollChars,leftScrollCharsInPage,rightScrollPixels,layoutTableAddress,colorTableAddress,patternTableAddress,spriteAttrTableAddress,spritePatternTableAddress,layoutTableAddressMask,layoutTableAddressMaskSetValue,colorTableAddressMask,patternTableAddressMask,layoutTableAddressMaskBase=1023,colorTableAddressMaskBase=63,patternTableAddressMaskBase=2047,modes=wmsx.Util.arrayFill(new Array(36),{name:"NUL",isV9938:!0,layTBase:0,colorTBase:0,patTBase:0,sprAttrTBase:0,width:256,layLineBytes:0,evenPageMask:-1,blinkPageMask:-1,renderLine:renderLineBlanked,renderLinePatInfo:renderLineBlanked,ppb:0,spriteMode:0,tiled:!1,vramInter:null,bdPaletted:!0,textCols:0});modes[16]={name:"T1",isV9938:!1,layTBase:-1024,colorTBase:0,patTBase:-2048,sprAttrTBase:0,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeT1,renderLinePatInfo:renderLineModeT1PatInfo,ppb:0,spriteMode:0,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:40},modes[18]={name:"T2",isV9938:!0,layTBase:-4096,colorTBase:-512,patTBase:-2048,sprAttrTBase:0,width:512,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeT2,renderLinePatInfo:renderLineModeT2PatInfo,ppb:0,spriteMode:0,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:80},modes[8]={name:"MC",isV9938:!1,layTBase:-1024,colorTBase:0,patTBase:-2048,sprAttrTBase:-128,width:256,layLineBytes:0,evenPageMask:-32769,
blinkPageMask:-1,renderLine:renderLineModeMC,renderLinePatInfo:renderLineModeMCPatInfo,ppb:0,spriteMode:1,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[0]={name:"G1",isV9938:!1,layTBase:-1024,colorTBase:-64,patTBase:-2048,sprAttrTBase:-128,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeG1,renderLinePatInfo:renderLineModeG1PatInfo,ppb:0,spriteMode:1,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:32},modes[1]={name:"G2",isV9938:!1,layTBase:-1024,colorTBase:-8192,patTBase:-8192,sprAttrTBase:-128,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeG2,renderLinePatInfo:renderLineModeG2PatInfo,ppb:0,spriteMode:1,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[2]={name:"G3",isV9938:!0,layTBase:-1024,colorTBase:-8192,patTBase:-8192,sprAttrTBase:-1024,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-32769,renderLine:renderLineModeG3,renderLinePatInfo:renderLineModeG3PatInfo,ppb:0,spriteMode:2,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[3]={name:"G4",isV9938:!0,layTBase:-32768,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:128,evenPageMask:-32769,blinkPageMask:-32769,renderLine:renderLineModeG4,renderLinePatInfo:renderLineModeG4,ppb:2,spriteMode:2,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[4]={name:"G5",isV9938:!0,layTBase:-32768,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:512,layLineBytes:128,evenPageMask:-32769,blinkPageMask:-32769,renderLine:renderLineModeG5,renderLinePatInfo:renderLineModeG5,ppb:4,spriteMode:2,tiled:!0,vramInter:!1,bdPaletted:!0,textCols:0},modes[5]={name:"G6",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:512,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeG6,renderLinePatInfo:renderLineModeG6,ppb:2,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!0,textCols:0},modes[7]={name:"G7",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeG7,renderLinePatInfo:renderLineModeG7,ppb:1,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!1,textCols:0},modes[33]={name:"YJK",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeYJK,renderLinePatInfo:renderLineModeYJK,ppb:1,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!0,textCols:0},modes[35]={name:"YAE",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeYAE,renderLinePatInfo:renderLineModeYAE,ppb:1,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!0,textCols:0};var renderLine,renderLineActive,colors256=new Uint32Array(256),colors512=new Uint32Array(512),color2to8bits=[0,73,146,255],color3to8bits=[0,36,73,109,146,182,219,255],color5to8bits=[0,8,16,24,32,41,49,57,65,74,82,90,98,106,115,123,131,139,148,156,164,172,180,189,197,205,213,222,230,238,246,255],color0Solid=!1,colorPalette=new Uint32Array(16),colorPaletteSolid=new Uint32Array(16),colorPaletteReal=new Uint32Array(16),spritePaletteG7=new Uint32Array([4278190080,4282974208,4278190189,4282974317,4278217984,4283002112,4278218093,4283002221,4283011839,4294901760,4278190335,4294902015,4278255360,4294967040,4278255615,4294967295]),colorPaletteInitialV9918=new Uint32Array([4278190080,4278190080,4280863239,4284867133,4293936196,4294208880,4279447760,4293978176,4282532595,4286085364,4281387728,4287225052,4280330502,4291117274,4290559164,4294967295]),colorPaletteInitialV9938=new Uint32Array([4278190080,4278190080,4280605476,4285398893,4294911012,4294929737,4280558774,4294957897,4280558847,4285361663,4280605659,4287814619,4280586788,4290136539,4290164406,4294967295]),paletteRegisterInitialValuesV9938=[0,0,1553,1843,279,807,337,1575,289,883,1633,1636,1041,613,869,1911],debugMode=0,debugModeSpriteHighlight=!1,debugModeSpriteInfo=!1,debugModeSpriteInfoNumbers=!1,debugModeSpritesHidden=!1,debugModePatternInfo=!1,debugModePatternInfoBlocks=!1,debugModePatternInfoNames=!1,spriteDebugMode=0,spriteDebugModeLimit=!0,spriteDebugModeCollisions=!0,debugBackdropValue=4280953386,debugLineStartBUSCycles=0,videoSignal,cpuClockPulses,audioClockPulse32,commandProcessor;this.saveState=function(a){var b={v1:isV9918,v3:isV9938,v5:isV9958,l:currentScanline,b:bufferPosition,ba:bufferLineAdvance,ad:renderLine===renderLineActive,fs:frameStartingActiveScanline,f:frame,c:cycles,cc:lastBUSCyclesComputed,vp:vramPointer,d:dataFirstWrite,dr:dataPreRead,pw:paletteFirstWrite,ha:horizontalAdjust,va:verticalAdjust,hil:horizontalIntLine,lm:leftMask,ls2:leftScroll2Pages,lsc:leftScrollChars,rsp:rightScrollPixels,bp:blinkEvenPage,bpd:blinkPageDuration,bpl:blinkPerLine,sc:spritesCollided,sx:spritesCollisionX,sy:spritesCollisionY,si:spritesInvalid,sm:spritesMaxComputed,vi:verticalIntReached,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),s:wmsx.Util.storeInt8BitArrayToStringBase64(status),p:wmsx.Util.storeInt16BitArrayToStringBase64(paletteRegister),vram:wmsx.Util.compressInt8BitArrayToStringBase64(vram,VRAM_SIZE),vrint:vramInterleaving,cp:commandProcessor.saveState()};return a&&(b.dm=debugMode,b.sd=spriteDebugMode),b},this.loadState=function(a){isV9918=a.v1,isV9938=a.v3,isV9958=a.v5,refreshDisplayMetrics(),register=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r,register),status=wmsx.Util.restoreStringBase64ToInt8BitArray(a.s,status),paletteRegister=wmsx.Util.restoreStringBase64ToInt16BitArray(a.p,paletteRegister),vram=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.vram,vram,!0),currentScanline=a.l,bufferPosition=a.b,bufferLineAdvance=a.ba,a.ad?setActiveDisplay():setBorderDisplay(),frame=a.f||0,cycles=a.c,lastBUSCyclesComputed=a.cc,vramPointer=a.vp,dataFirstWrite=a.d,dataPreRead=a.dr||0,paletteFirstWrite=a.pw,horizontalAdjust=a.ha,verticalAdjust=a.va,horizontalIntLine=a.hil,leftMask=a.lm,leftScroll2Pages=a.ls2,leftScrollChars=a.lsc,rightScrollPixels=a.rsp,leftScrollCharsInPage=31&leftScrollChars,blinkEvenPage=a.bp,blinkPageDuration=a.bpd,blinkPerLine=void 0!==a.bpl?a.bpl:0!=(4&register[1]),spritesCollided=a.sc,spritesCollisionX=a.sx,spritesCollisionY=a.sy,spritesInvalid=a.si,spritesMaxComputed=a.sm,verticalIntReached=a.vi,vramInterleaving=a.vrint,commandProcessor.loadState(a.cp),commandProcessor.connectVDP(this,vram,register,status),frameVideoStandard=videoStandard,framePulldown=pulldown,updateSignalMetrics(!0),void 0!==a.fs&&(frameStartingActiveScanline=a.fs),updateIRQ(),updateMode(),updateSpritesConfig(),debugAdjustPalette(),updateBackdropColor(),updateTransparency(),updateRenderMetrics(!0),void 0!==a.dm&&setDebugMode(a.dm),void 0!==a.sd&&setSpriteDebugMode(a.sd)},init(),this.logInfo=logInfo,this.eval=function(str){return eval(str)}},wmsx.VDP.VRAM_LIMIT=131071,wmsx.VDP.SIGNAL_MAX_WIDTH_V9938=544,wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938=456,wmsx.VDP.SIGNAL_WIDTH_V9918=272,wmsx.VDP.SIGNAL_HEIGHT_V9918=208,wmsx.VDPCommandProcessor=function(){"use strict";function getSX(){return(1&register[33])<<8|register[32]}function getSY(){return(3&register[35])<<8|register[34]}function setSY(a){register[35]=a>>8&3,register[34]=255&a}function getDX(){return(1&register[37])<<8|register[36]}function getDY(){return(3&register[39])<<8|register[38]}function setDY(a){register[39]=a>>8&3,register[38]=255&a}function getNX(){return(1&register[41])<<8|register[40]}function getNY(){return(3&register[43])<<8|register[42]}function setNY(a){register[43]=a>>8&3,register[42]=255&a}function getDIX(){return 4&register[45]?-1:1}function getDIY(){return 8&register[45]?-1:1}function getCLR(){return register[44]}function setCLR(a){register[44]=a}function getMAJ(){return 1&register[45]}function getEQ(){return 0==(2&register[45])}function getLOP(){return LOGICAL_OPERATIONS[15&register[46]]}function HMMC(){
var a=getDX();DY=getDY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),a>>=modePPBShift,NX>>=modePPBShift,a>=layoutLineBytes?(a&=layoutLineBytes-1,NX=1):(NX=NX||layoutLineBytes,NX=1===DIX?min(NX,layoutLineBytes-a):min(NX,a+1)),NY=NY||1024,ENY=1===DIY?NY:min(NY,DY+1),destPos=DY*layoutLineBytes+a,writeStart(HMMCNextWrite)}function HMMCNextWrite(a){vram[destPos&VRAM_LIMIT]=a,CX+=1,CX>=NX?(destPos-=DIX*(NX-1),CX=0,CY+=1,CY>=ENY?finish():destPos+=DIY*layoutLineBytes):destPos+=DIX,setDY(DY+DIY*CY),setNY(NY-CY)}function YMMM(){var a=getSY(),b=getDX(),c=getDY(),d=getNY(),e=getDIX(),f=getDIY();(b>>=modePPBShift)>=layoutLineBytes&&(b&=layoutLineBytes-1);var g=1===e?layoutLineBytes-b:b+1;d=d||1024;for(var h=1===f?d:min(d,min(a,c)+1),i=a*layoutLineBytes+b,j=c*layoutLineBytes+b,k=-e*g+layoutLineBytes*f,l=h;l>0;l-=1){for(var m=g;m>0;m-=1)vram[j&VRAM_LIMIT]=vram[i&VRAM_LIMIT],i+=e,j+=e;i+=k,j+=k}setSY(a+f*h),setDY(c+f*h),setNY(d-h),start(g*h,64,h,0)}function HMMM(){var a=getSX(),b=getSY(),c=getDX(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY();a>>=modePPBShift,c>>=modePPBShift,e>>=modePPBShift,a>=layoutLineBytes||c>=layoutLineBytes?(a&=layoutLineBytes-1,c&=layoutLineBytes-1,e=1):(e=e||layoutLineBytes,e=1===g?min(e,layoutLineBytes-max(a,c)):min(e,min(a,c)+1)),f=f||1024;for(var i=1===h?f:min(f,min(b,d)+1),j=b*layoutLineBytes+a,k=d*layoutLineBytes+c,l=-g*e+layoutLineBytes*h,m=i;m>0;m-=1){for(var n=e;n>0;n-=1)vram[k&VRAM_LIMIT]=vram[j&VRAM_LIMIT],j+=g,k+=g;j+=l,k+=l}setSY(b+h*i),setDY(d+h*i),setNY(f-i),start(e*i,88,i,64)}function HMMV(){var a=getDX(),b=getDY(),c=getNX(),d=getNY(),e=getCLR(),f=getDIX(),g=getDIY();a>>=modePPBShift,c>>=modePPBShift,a>=layoutLineBytes?(a&=layoutLineBytes-1,c=1):(c=c||layoutLineBytes,c=1===f?min(c,layoutLineBytes-a):min(c,a+1)),d=d||1024;for(var h=1===g?d:min(d,b+1),i=b*layoutLineBytes+a,j=-f*c+layoutLineBytes*g,k=h;k>0;k-=1){for(var l=c;l>0;l-=1)vram[i&VRAM_LIMIT]=e,i+=f;i+=j}setDY(b+g*h),setNY(d-h),start(c*h,48,h,56)}function LMMC(){DX=getDX(),DY=getDY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),LOP=getLOP(),DX>=modeWidth?(DX&=modeWidth-1,NX=1):(NX=NX||modeWidth,NX=1===DIX?min(NX,modeWidth-DX):min(NX,DX+1)),NY=NY||1024,ENY=1===DIY?NY:min(NY,DY+1),writeStart(LMMCNextWrite)}function LMMCNextWrite(a){logicalPSET(DX,DY,a,LOP),CX+=1,CX>=NX?(DX-=DIX*(NX-1),CX=0,CY+=1,DY+=DIY,CY>=ENY&&finish()):DX+=DIX,setDY(DY),setNY(NY-CY)}function LMCM(){SX=getSX(),SY=getSY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),SX>=modeWidth?(SX&=modeWidth-1,NX=1):(NX=NX||modeWidth,NX=1===DIX?min(NX,modeWidth-SX):min(NX,SX+1)),NY=NY||1024,ENY=1===DIY?NY:min(NY,SY+1),readStart(LMCMNextRead)}function LMCMNextRead(){status[7]=normalPGET(SX,SY),CX+=1,CX>=NX?(SX-=DIX*(NX-1),CX=0,CY+=1,SY+=DIY,CY>=ENY&&finish()):SX+=DIX,setSY(SY),setNY(NY-CY)}function LMMM(){var a=getSX(),b=getSY(),c=getDX(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY(),i=getLOP();a>=modeWidth||c>=modeWidth?(a&=modeWidth-1,c&=modeWidth-1,e=1):(e=e||modeWidth,e=1===g?min(e,modeWidth-max(a,c)):min(e,min(a,c)+1)),f=f||1024;for(var j=1===h?f:min(f,min(b,d)+1),k=j;k>0;k-=1){for(var l=e;l>0;l-=1)logicalPCOPY(c,d,a,b,i),a+=g,c+=g;a-=g*e,c-=g*e,b+=h,d+=h}setSY(b),setDY(d),setNY(f-j),start(e*j,120,j,64)}function LMMV(){var a=getDX(),b=getDY(),c=getNX(),d=getNY(),e=getCLR(),f=getDIX(),g=getDIY(),h=getLOP();a>=modeWidth?(a&=modeWidth-1,c=1):(c=c||modeWidth,c=1===f?min(c,modeWidth-a):min(c,a+1)),d=d||1024;for(var i=1===g?d:min(d,b+1),j=i;j>0;j-=1){for(var k=c;k>0;k-=1)logicalPSET(a,b,e,h),a+=f;a-=f*c,b+=g}setDY(b),setNY(d-i),start(c*i,96,i,64)}function LINE(){var a=getDX(),b=getDY(),c=getNX(),d=getNY(),e=getCLR(),f=getDIX(),g=getDIY(),h=getMAJ(),i=getLOP(),j=modeWidth-1;a&=j;var k=0,l=0;if(0===h)for(var m=0;m<=c&&(logicalPSET(a,b,e,i),a+=f,d>0&&(l+=d)<<1>=c&&(b+=g,l-=c,k+=1),!(a>j||a<0||b<0));m+=1);else for(m=0;m<=c&&(logicalPSET(a,b,e,i),b+=g,d>0&&(l+=d)<<1>=c&&(a+=f,l-=c,k+=1),!(a>j||a<0||b<0));m+=1);setDY(b),start(m,112,k,32)}function SRCH(){var a=getSX(),b=getSY(),c=getCLR(),d=getDIX(),e=getEQ();a>=modeWidth&&(a&=modeWidth-1);var f=1===d?modeWidth:-1,g=a,h=!1;if(e)do{if(normalPGET(g,b)===c){h=!0;break}g+=d}while(g!==f);else do{if(normalPGET(g,b)!==c){h=!0;break}g+=d}while(g!==f);status[2]=-17&status[2]|(h?16:0),status[8]=255&g,status[9]=g>>8&1,start(Math.abs(g-a)+1,86,1,50)}function PSET(){var a=getDX(),b=getDY(),c=getCLR(),d=getLOP();a>=modeWidth&&(a&=modeWidth-1),logicalPSET(a,b,c,d),start(0,0,1,40)}function POINT(){var a=getSX(),b=getSY();a>=modeWidth&&(a&=modeWidth-1);var c=normalPGET(a,b);setCLR(c),status[7]=c,start(0,0,1,40)}function STOP(){finish()}function normalPGET(a,b){var c,d;switch(modePPB){case 2:c=1&a?0:4,a>>>=1,d=15<<c;break;case 4:c=2*(3-(3&a)),a>>>=2,d=3<<c;break;default:c=0,d=255}return(vram[b*layoutLineBytes+a&VRAM_LIMIT]&d)>>c}function logicalPSET(a,b,c,d){var e,f;switch(modePPB){case 2:e=1&a?0:4,a>>>=1,c=(15&c)<<e,f=15<<e;break;case 4:e=2*(3-(3&a)),a>>>=2,c=(3&c)<<e,f=3<<e;break;default:f=255}var g=b*layoutLineBytes+a;vram[g&VRAM_LIMIT]=d(vram[g&VRAM_LIMIT],c,f)}function logicalPCOPY(a,b,c,d,e){var f,g,h;switch(modePPB){case 2:f=1&c?0:4,g=1&a?0:4,c>>>=1,a>>>=1,h=15;break;case 4:f=2*(3-(3&c)),g=2*(3-(3&a)),c>>>=2,a>>>=2,h=3;break;default:f=g=0,h=255}var i=d*layoutLineBytes+c,j=b*layoutLineBytes+a,k=(vram[i&VRAM_LIMIT]>>f&h)<<g;vram[j&VRAM_LIMIT]=e(vram[j&VRAM_LIMIT],k,h<<g)}function lopIMP(a,b,c){return a&~c|b}function lopAND(a,b,c){return a&(b|~c)}function lopOR(a,b,c){return a|b}function lopXOR(a,b,c){return a^b}function lopNOT(a,b,c){return a&~c|~b&c}function lopTIMP(a,b,c){return 0===b?a:a&~c|b}function lopTAND(a,b,c){return 0===b?a:a&(b|~c)}function lopTOR(a,b,c){return 0===b?a:a|b}function lopTXOR(a,b,c){return a^b}function lopTNOT(a,b,c){return 0===b?a:a&~c|~b&c}function min(a,b){return a<b?a:b}function max(a,b){return a>b?a:b}function start(a,b,c,d,e){CE=1,writeHandler=null,readHandler=null,estimateDuration(a,b,c,d,e)}function estimateDuration(a,b,c,d,e){if(e)finishingCycle=-1;else if(0===turboClockMulti)finishingCycle=0;else{var f=(a*b*COMMAND_PER_PIXEL_DURATION_FACTOR+c*d)/turboClockMulti|0;finishingCycle=vdp.updateCycles()+f}}function writeStart(a){start(0,0,0,0,!0),CX=0,CY=0,writeHandler=a,TR=1,writeReady&&(writeHandler(getCLR()),writeReady=!1)}function readStart(a){start(0,0,0,0,!0),CX=0,CY=0,readHandler=a,TR=1,readHandler()}function finish(){CE=0,writeHandler=null,writeReady=!1,readHandler=null,register[46]&=-241}this.connectVDP=function(a,b,c,d){vdp=a,vram=b,register=c,status=d},this.reset=function(){STOP()},this.startCommand=function(a){switch(240&a){case 240:HMMC();break;case 224:YMMM();break;case 208:HMMM();break;case 192:HMMV();break;case 176:LMMC();break;case 160:LMCM();break;case 144:LMMM();break;case 128:LMMV();break;case 112:LINE();break;case 96:SRCH();break;case 80:PSET();break;case 64:POINT();break;case 0:STOP()}},this.cpuWrite=function(a){writeHandler?writeHandler(a):(writeReady=!0,TR=0)},this.cpuRead=function(){readHandler?readHandler():TR=0},this.updateStatus=function(){CE&&finishingCycle>=0&&(0===finishingCycle||vdp.updateCycles()>=finishingCycle)&&finish(),status[2]=-130&status[2]|TR<<7|CE},this.setVDPModeData=function(a){modeData=a,modeWidth=modeData.width,modePPB=modeData.ppb||1,modePPBShift=modePPB>>1,modePPBMask=-1<<modePPBShift,layoutLineBytes=modeData.layLineBytes||256},this.setVDPTurboMulti=function(a){turboClockMulti=a<0||a>8?0:a},this.getVDPTurboMulti=function(){return turboClockMulti};var VRAM_LIMIT=wmsx.VDP.VRAM_LIMIT,COMMAND_HANDLERS={HMMCNextWrite:HMMCNextWrite,LMMCNextWrite:LMMCNextWrite,LMCMNextRead:LMCMNextRead
},COMMAND_PER_PIXEL_DURATION_FACTOR=1.1,LOGICAL_OPERATIONS=[lopIMP,lopAND,lopOR,lopXOR,lopNOT,lopIMP,lopIMP,lopIMP,lopTIMP,lopTAND,lopTOR,lopTXOR,lopTNOT,lopIMP,lopIMP,lopIMP],turboClockMulti=1,vdp,vram,register,status,CE=!1,TR=!1,SX,SY,DX,DY,NX,NY,ENY,DIX,DIY,CX,CY,LOP,destPos,writeReady=!1,writeHandler=null,readHandler=null,finishingCycle=0,modeData,modePPB,modePPBShift,modePPBMask,modeWidth,layoutLineBytes;this.saveState=function(){return{ce:CE,tr:TR,wr:writeReady,wh:writeHandler&&writeHandler.name,rh:readHandler&&readHandler.name,fc:finishingCycle,SX:SX,SY:SY,DX:DX,DY:DY,NX:NX,NY:NY,ENY:ENY,DIX:DIX,DIY:DIY,CX:CX,CY:CY,LOP:LOP&&LOGICAL_OPERATIONS.indexOf(LOP),dp:destPos,tcm:turboClockMulti}},this.loadState=function(a){CE=a.ce,TR=a.tr,writeReady=a.wr,writeHandler=COMMAND_HANDLERS[a.wh],readHandler=COMMAND_HANDLERS[a.rh],finishingCycle=a.fc,SX=a.SX,SY=a.SY,DX=a.DX,DY=a.DY,NX=a.NX,NY=a.NY,ENY=a.ENY,DIX=a.DIX,DIY=a.DIY,CX=a.CX,CY=a.CY,LOP=a.LOP>=0?LOGICAL_OPERATIONS[a.LOP]:void 0,destPos=a.dp,turboClockMulti=void 0!==a.tcm?a.tcm:1},this.eval=function(str){return eval(str)}},wmsx.VideoSignal=function(a){"use strict";this.connectMonitor=function(a){b=a},this.newFrame=function(a,c,d){b.newFrame(a,c,d)},this.signalOff=function(){b&&b.signalOff()},this.showOSD=function(a,c,d){b&&b.showOSD(a,c,d)},this.setDisplayMetrics=function(a,c){b&&b.setDisplayMetrics(a,c)},this.setPixelMetrics=function(a,c){b&&b.setPixelMetrics(a,c)},this.setDebugMode=function(a){b&&b.setDebugMode(a)},this.getScreenText=function(){return a.getScreenText()};var b},wmsx.VideoStandard={NTSC:{name:"NTSC",desc:"NTSC 60Hz",totalWidth:342,totalHeight:262,topBorderHeight:16,targetFPS:60,pulldowns:{60:{standard:"NTSC",frequency:60,divider:1,linesPerCycle:262,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},120:{standard:"NTSC",frequency:120,divider:2,linesPerCycle:262,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},"120s":{standard:"NTSC",frequency:120,divider:1,linesPerCycle:131,firstStepCycleLinesAdjust:0,cadence:[0,1],steps:2},50:{standard:"NTSC",frequency:50,divider:1,linesPerCycle:314,firstStepCycleLinesAdjust:2,cadence:[1,1,1,1,2],steps:5},100:{standard:"NTSC",frequency:100,divider:2,linesPerCycle:314,firstStepCycleLinesAdjust:2,cadence:[1,1,1,1,2],steps:5},"100s":{standard:"NTSC",frequency:100,divider:1,linesPerCycle:157,firstStepCycleLinesAdjust:2,cadence:[0,1,0,1,1,0,1,0,1,1],steps:10},TIMER:{standard:"NTSC",frequency:62.5,divider:1,linesPerCycle:262,firstStepCycleLinesAdjust:0,cadence:[1],steps:1}}},PAL:{name:"PAL",desc:"PAL 50Hz",totalWidth:342,totalHeight:313,topBorderHeight:43,targetFPS:50,pulldowns:{50:{standard:"PAL",frequency:50,divider:1,linesPerCycle:313,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},100:{standard:"PAL",frequency:100,divider:2,linesPerCycle:313,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},"100s":{standard:"PAL",frequency:100,divider:1,linesPerCycle:156,firstStepCycleLinesAdjust:1,cadence:[0,1],steps:2},60:{standard:"PAL",frequency:60,divider:1,linesPerCycle:261,firstStepCycleLinesAdjust:-1,cadence:[0,1,1,1,1,1],steps:6},120:{standard:"PAL",frequency:120,divider:2,linesPerCycle:261,firstStepCycleLinesAdjust:-1,cadence:[0,1,1,1,1,1],steps:6},"120s":{standard:"PAL",frequency:120,divider:1,linesPerCycle:130,firstStepCycleLinesAdjust:5,cadence:[0,0,1,0,1,0,0,1,0,1,0,1],steps:12},TIMER:{standard:"PAL",frequency:50,divider:1,linesPerCycle:313,firstStepCycleLinesAdjust:0,cadence:[1],steps:1}}}},wmsx.AudioTables={setupVolPan:function(a,b,c,d,e){this.createVolPanVolumeTable();for(var f=0;f<a;++f){var g=Number("0x"+(1===b.length?b[0]:b.length>f?b[f]:"f")),h=Number("0x"+(1===c.length?c[0]:c.length>f?c[f]:"8"));d[f]=this.VOLPAN_VOLUME_TABLE[this.VOL_VALUES[g]+this.PAN_VALUES[0][h]],e[f]=this.VOLPAN_VOLUME_TABLE[this.VOL_VALUES[g]+this.PAN_VALUES[1][h]]}},createVolPanVolumeTable:function(){if(!this.VOLPAN_VOLUME_TABLE){for(var a=new Array(256),b=0;b<127;++b)a[b]=Math.pow(10,-.75*b/20);for(b=127;b<256;++b)a[b]=0;this.VOLPAN_VOLUME_TABLE=a}},VOL_VALUES:[128,28,26,24,22,20,18,16,14,12,10,8,6,4,2,0],PAN_VALUES:[[127,0,0,0,0,0,0,0,0,4,8,12,16,20,24,127],[127,127,24,20,16,12,8,4,0,0,0,0,0,0,0,0]],VOLPAN_VOLUME_TABLE:void 0},wmsx.PSG=function(controllersSocket,ledsSocket,secondary){"use strict";function updateKanaLed(){ledsSocket&&ledsSocket.ledStateChanged(1,0==(128&register[15]))}this.connectBus=function(a){var b=secondary?16:160;a.connectInputDevice(b,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(b,this.outputA0),a.connectInputDevice(b+1,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(b+1,this.outputA1),a.connectInputDevice(b+2,this.inputA2),a.connectOutputDevice(b+2,wmsx.DeviceMissing.outputPortIgnored),powerIsOn&&audioChannel.connectAudio()},this.disconnectBus=function(a){var b=secondary?16:160;a.disconnectInputDevice(b,wmsx.DeviceMissing.inputPortIgnored),a.disconnectOutputDevice(b,this.outputA0),a.disconnectInputDevice(b+1,wmsx.DeviceMissing.inputPortIgnored),a.disconnectOutputDevice(b+1,this.outputA1),a.disconnectInputDevice(b+2,this.inputA2),a.disconnectOutputDevice(b+2,wmsx.DeviceMissing.outputPortIgnored),audioChannel.disconnectAudio()},this.setAudioSocket=function(a){audioChannel.setAudioSocket(a)},this.powerOn=function(){this.reset(),powerIsOn=!0,audioChannel.powerOn()},this.powerOff=function(){powerIsOn=!1,audioChannel.powerOff()},this.reset=function(){wmsx.Util.arrayFill(register,0),register[15]=143,updateKanaLed(),audioChannel.reset()},this.getAudioChannel=function(){return audioChannel},this.outputA0=function(a){registerAddress=a>15?0:a},this.outputA1=function(a){switch(register[registerAddress]=a,registerAddress){case 0:case 1:audioChannel.setPeriodA((15&register[1])<<8|register[0]);break;case 2:case 3:audioChannel.setPeriodB((15&register[3])<<8|register[2]);break;case 4:case 5:audioChannel.setPeriodC((15&register[5])<<8|register[4]);break;case 6:audioChannel.setPeriodN(31&a);break;case 7:audioChannel.setMixerControl(a);break;case 8:audioChannel.setAmplitudeA(a);break;case 9:audioChannel.setAmplitudeB(a);break;case 10:audioChannel.setAmplitudeC(a);break;case 11:case 12:audioChannel.setPeriodE(register[12]<<8|register[11]);break;case 13:audioChannel.setEnvelopeControl(a);break;case 15:controllersSocket&&(controllersSocket.writeControllerPin8Port(0,(16&a)>>4),controllersSocket.writeControllerPin8Port(1,(32&a)>>5)),updateKanaLed()}},this.inputA2=function(){if(14!==registerAddress)return register[registerAddress];var a=register[15]>>6&1;return controllersSocket?controllersSocket.readControllerPort(a):63};var powerIsOn=!1,registerAddress=0,register=wmsx.Util.arrayFill(new Array(16),0),audioChannel=new wmsx.PSGAudio(secondary);this.saveState=function(){return{p:powerIsOn,ra:registerAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),ac:audioChannel.saveState()}},this.loadState=function(a){powerIsOn=void 0===a.p||a.p,registerAddress=a.ra,register=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r,register),updateKanaLed(),audioChannel.loadState(a.ac)},this.eval=function(str){return eval(str)}},wmsx.AudioSignal=function(a,b,c,d,e,f){"use strict";function g(a){switch(a){case 32:return j;case 72:return k;case 81:return l;default:throw new Error("Unsupported AudioSignal Sample Rate CPU Clock multiple: "+a)}}function h(a){switch(a){case 72:return m;default:throw new Error("Unsupported AudioSignal Clock CPU Clock multiple: "+a)}}function i(){var a=H*WMSX.AUDIO_SIGNAL_BUFFER_RATIO+v*WMSX.AUDIO_SIGNAL_ADD_FRAMES&-8;F.length=a,a>C&&wmsx.Util.arrayFill(F,0,C,a),e&&(G.length=a,a>C&&wmsx.Util.arrayFill(G,0,C,a)),C=a,I.bufferSize=C,E=C-2,s.flush()}function j(){if(B>0){if(D<=0)return void(B=0);t(),--B,--D}}function k(){1&--w||8===w||(0===w&&(w=9),j())}function l(){--x,1&x&&j(),0===x&&(x=5)}function m(){1&--y||8===y||(0===y&&(y=9),b.audioClockPulse())}function n(){F[z]=b.nextSample()*c,++z>=C&&(z=0)}function o(){var a=b.nextSample();F[z]=a[0]*c,
G[z]=a[1]*c,++z>=C&&(z=0)}function p(){F[z]=0,++z>=C&&(z=0)}function q(){F[z]=G[z]=0,++z>=C&&(z=0)}function r(a,b){if(b)for(var c=a;c>0;c-=1)u();else for(var d=a;d>0;d-=1)t();D-=a}var s=this;this.audioClockPulse=null,this.flush=function(){z=0,A=0,D=E},this.setFps=function(a){v=Math.floor(d/a),i()},this.audioFinishFrame=function(){if(B>0)for(;B>0;)j();B=v},this.retrieveSamples=function(a,b){var c=E-D,d=a-c;d>-4&&(d+4>D&&(d=D-4),r(d+4,b)),I.start=A;var e=c+d;return D+=e,A+=e,A>=C&&(A-=C),I},this.getSampleRate=function(){return d},this.toString=function(){return"AudioSignal "+a},this.setAudioMonitorBufferSize=function(a){H=a,i()};var t=n,u=p;this.name=a;var v,w=9,x=5,y=9,z=0,A=0,B=0,C=0,D=0,E=0,F=wmsx.Util.arrayFill(new Array(C),0),G=e?wmsx.Util.arrayFill(new Array(C),0):F,H=0,I={stereo:e,buffer0:F,buffer1:G,bufferSize:C,start:0};!function(){c=1.1*c*WMSX.VOL,t=e?o:n,u=e?q:p;var a=Math.floor(wmsx.Machine.BASE_CPU_CLOCK/d),b=g(a);if(f){a=Math.floor(wmsx.Machine.BASE_CPU_CLOCK/f);var i=h(a);s.audioClockPulse=function(){i(),b()}}else s.audioClockPulse=b}()},wmsx.PSGAudio=function(a){"use strict";function b(a,b){a^b&&(L=!L),I=L?0:15,J=b?0:L?1:-1}function c(){o&&(l=R[I]),v&&(s=R[I]),C&&(z=R[I])}function d(){return 1&(P=P>>1|(1&(P>>2^1&P))<<16)}function e(){for(var a=0;a<16;a++)R[a]=(Math.pow(V,a/15)-1)/(V-1)*U}var f=this;this.setAudioSocket=function(a){h=a},this.powerOn=function(){this.reset(),this.connectAudio()},this.powerOff=function(){this.disconnectAudio()},this.reset=function(){this.setMixerControl(255),this.setAmplitudeA(0),this.setAmplitudeB(0),this.setAmplitudeC(0),O=!1},this.nextSample=function(){if(i>0&&(j+=2)>=i&&(j=j-i&1,k=k?0:1),p>0&&(q+=2)>=p&&(q=q-p&1,r=r?0:1),w>0&&(x+=2)>=w&&(x=x-w&1,y=y?0:1),(n||u||B)&&(E+=1)>=D&&(E=0,F=d()),0!==J&&(H+=1)>=G&&(H=0,I+=J,(I<0||I>15)&&(K?b(M,N):(L=!0,b(!0,!0))),c()),$){var a=0===l||m&&!k||n&&!F?0:l,e=0===s||t&&!r||u&&!F?0:s,f=0===z||A&&!y||B&&!F?0:z,g=O?U:0;return Q[0]=a*S[0]+e*S[1]+f*S[2]+g*S[3],Q[1]=a*T[0]+e*T[1]+f*T[2]+g*T[3],Q}return(0===l||m&&!k||n&&!F?0:l)+(0===s||t&&!r||u&&!F?0:s)+(0===z||A&&!y||B&&!F?0:z)+(O?U:0)},this.setPeriodA=function(a){i!==a&&(a<2?(i=0,k=1):i=a)},this.setPeriodB=function(a){p!==a&&(a<2?(p=0,r=1):p=a)},this.setPeriodC=function(a){w!==a&&(a<2?(w=0,y=1):w=a)},this.setPeriodN=function(a){D!==a&&(D=a<1?1:a)},this.setPeriodE=function(a){G!==a&&(G=a<1?1:a)},this.setAmplitudeA=function(a){16&a?(o=!0,l=R[I]):(o=!1,l=R[15&a])},this.setAmplitudeB=function(a){16&a?(v=!0,s=R[I]):(v=!1,s=R[15&a])},this.setAmplitudeC=function(a){16&a?(C=!0,z=R[I]):(C=!1,z=R[15&a])},this.setMixerControl=function(a){m=0==(1&a),n=0==(8&a),t=0==(2&a),u=0==(16&a),A=0==(4&a),B=0==(32&a)},this.setEnvelopeControl=function(a){K=(8&a)>0,L=(4&a)>0,M=(2&a)>0,N=(1&a)>0,b(!1,!1),c()},this.setPulseSignal=function(a){O=a},this.connectAudio=function(){h&&(g||(g=new wmsx.AudioSignal("PSG"+(a?"2":""),f,W,X,$)),h.connectAudioSignal(g))},this.disconnectAudio=function(){h&&g&&h.disconnectAudioSignal(g)};var g,h,i=0,j=0,k=0,l=0,m=!1,n=!1,o=!1,p=0,q=0,r=0,s=0,t=!1,u=!1,v=!1,w=0,x=0,y=0,z=0,A=!1,B=!1,C=!1,D=1,E=1,F=0,G=1,H=1,I=0,J=0,K=!1,L=!1,M=!1,N=!1,O=!1,P=131070,Q=[0,0],R=new Array(16),S=new Array(4),T=new Array(4),U=.25,V=30,W=.66,X=112005,Y=(a&&WMSX.PSG2_VOL||WMSX.PSG_VOL||"f").toUpperCase(),Z=(a&&WMSX.PSG2_PAN||WMSX.PSG_PAN||"0").toUpperCase(),$="F"!==Y||"8"!==Z;this.saveState=function(){return{pa:i,pac:j,ca:k,aa:l,ta:m,na:n,ea:o,pb:p,pbc:q,cb:r,ab:s,tb:t,nb:u,eb:v,pc:w,pcc:x,cc:y,ac:z,tc:A,nc:B,ec:C,pn:D,pnc:E,cn:F,pe:G,pec:H,ce:I,de:J,cne:K,ate:L,ale:M,he:N,ps:O,lf:P}},this.loadState=function(a){i=a.pa,j=a.pac,k=a.ca,l=a.aa,m=a.ta,n=a.na,o=a.ea,p=a.pb,q=a.pbc,r=a.cb,s=a.ab,t=a.tb,u=a.nb,v=a.eb,w=a.pc,x=a.pcc,y=a.cc,z=a.ac,A=a.tc,B=a.nc,C=a.ec,D=a.pn,E=a.pnc,F=a.cn,G=a.pe,H=a.pec,I=a.ce,J=a.de,K=a.cne,L=a.ate,M=a.ale,N=a.he,O=a.ps,P=a.lf},function(){e(),$&&wmsx.AudioTables.setupVolPan(4,Y,Z,S,T)}()},wmsx.PCM8BitAudio=function(){"use strict";this.setAudioSocket=function(a){c=a},this.connectAudio=function(){b||(b=new wmsx.AudioSignal("PCM 8 bit",this,e,f)),c&&c.connectAudioSignal(b)},this.disconnectAudio=function(){b&&c&&c.disconnectAudioSignal(b)},this.reset=function(){a=0},this.setSampleValue=function(b){a=b-128},this.nextSample=function(){return a*d};var a,b,c,d=.25/128,e=.66,f=112005;this.saveState=function(){return{s:a}},this.loadState=function(b){a=b.s}},wmsx.SCCIAudio=function(){"use strict";function a(a,b){if((a&=255)<128)return U[a>>>5][31&a]=b<128?b:-256+b,void(a>>>5==3&&(O[31&a]=b<128?b:-256+b));if(a<160){if((a&=239)<138)return void f(a-128>>>1,b,1&a);if(a<143)return void e(a-138,15&b);g(b)}}function b(a){return a&=255,a<128?255&U[a>>>5][31&a]:255}function c(a,b){if((a&=255)<160)return void(U[a>>>5][31&a]=b<128?b:-256+b);if(a<192){if((a&=239)<170)return void f(a-160>>>1,b,1&a);if(a<175)return void e(a-170,15&b);g(b)}}function d(a){return a&=255,a<160?255&U[a>>>5][31&a]:255}function e(a,b){switch(a){case 0:r=W[b];break;case 1:y=W[b];break;case 2:F=W[b];break;case 3:M=W[b];break;case 4:T=W[b]}}function f(a,b,c){switch(a){case 0:n=c?255&n|(15&b)<<8:65280&n|b;break;case 1:u=c?255&u|(15&b)<<8:65280&u|b;break;case 2:B=c?255&B|(15&b)<<8:65280&B|b;break;case 3:I=c?255&I|(15&b)<<8:65280&I|b;break;case 4:P=c?255&P|(15&b)<<8:65280&P|b}}function g(a){l=1&a?1:0,s=2&a?1:0,z=4&a?1:0,G=8&a?1:0,N=16&a?1:0}function h(){for(var a=0;a<16;a++)W[a]=(Math.pow($,a/15)-1)/($-1)*Z}this.setAudioSocket=function(a){k=a},this.connectAudio=function(){j||(j=new wmsx.AudioSignal("SCC",this,_,aa,da)),k&&k.connectAudioSignal(j)},this.disconnectAudio=function(){j&&k&&k.disconnectAudioSignal(j)},this.reset=function(){this.disconnectAudio(),g(0),r=y=F=M=T=0,n=u=B=I=P=0,o=v=C=J=Q=0,p=w=D=K=R=0,q=x=E=L=S=0;for(var a=0;a<5;a++)wmsx.Util.arrayFill(U[a],0);this.setSCCIMode(!1)},this.setSCCIMode=function(e){i!==e&&(i=!!e,i?(this.read=d,this.write=c):(this.read=b,this.write=a))},this.nextSample=function(){var a=0,b=0,c=0,d=0,e=0;if(n>0)for(l&&(a=q*r),o+=32;o>=n;)o-=n,++p>31&&(p=0),q=m[p];if(u>0)for(s&&(b=x*y),v+=32;v>=u;)v-=u,++w>31&&(w=0),x=t[w];if(B>0)for(z&&(c=E*F),C+=32;C>=B;)C-=B,++D>31&&(D=0),E=A[D];if(I>0)for(G&&(d=L*M),J+=32;J>=I;)J-=I,++K>31&&(K=0),L=H[K];if(P>0)for(N&&(e=S*T),Q+=32;Q>=P;)Q-=P,++R>31&&(R=0),S=O[R];return da?(V[0]=a*X[0]+b*X[1]+c*X[2]+d*X[3]+e*X[4],V[1]=a*Y[0]+b*Y[1]+c*Y[2]+d*Y[3]+e*Y[4],V):a+b+c+d+e};var i,j,k,l=0,m=wmsx.Util.arrayFill(new Array(32),0),n=0,o=0,p=0,q=0,r=0,s=0,t=wmsx.Util.arrayFill(new Array(32),0),u=0,v=0,w=0,x=0,y=0,z=0,A=wmsx.Util.arrayFill(new Array(32),0),B=0,C=0,D=0,E=0,F=0,G=0,H=wmsx.Util.arrayFill(new Array(32),0),I=0,J=0,K=0,L=0,M=0,N=!1,O=wmsx.Util.arrayFill(new Array(32),0),P=0,Q=0,R=0,S=0,T=0,U=[m,t,A,H,O],V=[0,0],W=new Array(16),X=new Array(5),Y=new Array(5),Z=.23/128,$=3,_=.65,aa=112005,ba=(WMSX.SCC_VOL||"f").toUpperCase(),ca=(WMSX.SCC_PAN||"8").toUpperCase(),da="F"!==ba||"8"!==ca;this.saveState=function(){return{m:i,c1:l,p1:n,pc1:o,sc1:p,cs1:q,a1:r,c2:s,p2:u,pc2:v,sc2:w,cs2:x,a2:y,c3:z,p3:B,pc3:C,sc3:D,cs3:E,a3:F,c4:G,p4:I,pc4:J,sc4:K,cs4:L,a4:M,c5:N,p5:P,pc5:Q,sc5:R,cs5:S,a5:T,s1:wmsx.Util.storeInt8BitArrayToStringBase64(m),s2:wmsx.Util.storeInt8BitArrayToStringBase64(t),s3:wmsx.Util.storeInt8BitArrayToStringBase64(A),s4:wmsx.Util.storeInt8BitArrayToStringBase64(H),s5:wmsx.Util.storeInt8BitArrayToStringBase64(O)}},this.loadState=function(a){this.reset(),l=a.c1,n=a.p1,o=a.pc1,p=a.sc1,q=a.cs1,r=a.a1,s=a.c2,u=a.p2,v=a.pc2,w=a.sc2,x=a.cs2,y=a.a2,z=a.c3,B=a.p3,C=a.pc3,D=a.sc3,E=a.cs3,F=a.a3,G=a.c4,I=a.p4,J=a.pc4,K=a.sc4,L=a.cs4,M=a.a4,N=a.c5,P=a.p5,Q=a.pc5,R=a.sc5,S=a.cs5,T=a.a5,m=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s1,m),t=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s2,t),A=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s3,A),H=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s4,H),O=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s5||a.s4,O),U[0]!==m&&(U[0]=m),
U[1]!==t&&(U[1]=t),U[2]!==A&&(U[2]=A),U[3]!==H&&(U[3]=H),U[4]!==O&&(U[4]=O),this.setSCCIMode(!0===a.m)},function(a){h(),da&&wmsx.AudioTables.setupVolPan(5,ba,ca,X,Y),a.setSCCIMode(!1)}(this)},wmsx.YM2413Tables=function(){"use strict";this.getFullSineTable=function(){for(var a=new Array(1024),b=0;b<1024;++b)a[b]=(b>511?16384:0)|Math.round(256*-wmsx.Util.log2(Math.abs(Math.sin(2*(b+.5)*Math.PI/1024))));return a},this.getHalfSineTable=function(){for(var a=new Array(1024),b=0;b<1024;++b)a[b]=Math.round(256*-wmsx.Util.log2(Math.abs(Math.sin(2*(b<512?b+.5:.5)*Math.PI/1024))));return a},this.getExpTable=function(){for(var a=new Array(32768),b=0;b<32768;++b){var c=Math.round(1024*wmsx.Util.exp2((255&b^255)/256))<<1>>Math.min((16128&b)>>8,31);16384&b&&(c=-c),a[b]=c}return a},this.getInstrumentsROM=function(){return this.INSTRUMENT_ROM},this.getVIBValues=function(){return this.VIB_VALUES},this.getKSLValues=function(){return this.KSL_VALUES},this.getMultiFactorsDoubled=function(){return this.MULTI_FACTORS},this.getRateDecayDurations=function(){for(var a=new Array(76),b=0;b<64;++b){var c=this.RATE_DECAY_DURATIONS[b];a[b]=c>=0?Math.max(1,Math.round(c/1e3*49780/128)):0}for(b=64;b<76;++b)a[b]=a[63];return a},this.getRateAttackDurations=function(){for(var a=new Array(76),b=0;b<64;++b){var c=this.RATE_ATTACK_DURATIONS[b];a[b]=c>=0?Math.max(1,Math.round(c/1e3*49780/128*8)):0}for(b=64;b<76;++b)a[b]=a[63];return a},this.INSTRUMENT_ROM=[[0,0,0,0,0,0,0,0],[97,97,30,23,240,127,0,23],[19,65,22,14,253,244,35,35],[3,1,154,4,243,243,19,243],[17,97,14,7,250,100,112,23],[34,33,30,6,240,118,0,40],[33,34,22,5,240,113,0,24],[33,97,29,7,130,128,23,23],[35,33,45,22,144,144,0,7],[33,33,27,6,100,101,16,23],[33,33,11,26,133,160,112,7],[35,1,131,16,255,180,16,244],[151,193,32,7,255,244,34,34],[97,0,12,5,194,246,64,68],[1,1,86,3,148,194,3,18],[33,1,137,3,241,228,240,35],[1,1,20,0,253,248,111,141],[1,17,0,0,248,247,248,247],[5,17,0,0,248,250,248,85]],this.VIB_VALUES=[[0,0,0,0,0,0,0,0],[0,0,1,0,0,0,-1,0],[0,1,2,1,0,-1,-2,-1],[0,1,3,1,0,-1,-3,-1],[0,2,4,2,0,-2,-4,-2],[0,2,5,2,0,-2,-5,-2],[0,3,6,3,0,-3,-6,-3],[0,3,7,3,0,-3,-7,-3]],this.KSL_VALUES=[[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]],[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4],[0,0,0,0,0,1,2,3,4,5,5,6,6,7,7,8],[0,0,0,2,4,5,6,7,8,9,9,10,10,11,11,12],[0,0,4,6,8,9,10,11,12,13,13,14,14,15,15,16],[0,4,8,10,12,13,14,15,16,17,17,18,18,19,19,20],[0,8,12,14,16,17,18,19,20,21,21,22,22,23,23,24],[0,12,16,18,20,21,22,23,24,25,25,26,26,27,27,28]],[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,2,3,4,5,6,7,8],[0,0,0,0,0,3,5,7,8,10,11,12,13,14,15,16],[0,0,0,5,8,11,13,15,16,18,19,20,21,22,23,24],[0,0,8,13,16,19,21,23,24,26,27,28,29,30,31,32],[0,8,16,21,24,27,29,31,32,34,35,36,37,38,39,40],[0,16,24,29,32,35,37,39,40,42,43,44,45,46,47,48],[0,24,32,37,40,43,45,47,48,50,51,52,53,54,55,56]],[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,4,6,8,10,12,14,16],[0,0,0,0,0,6,10,14,16,20,22,24,26,28,30,32],[0,0,0,10,16,22,26,30,32,36,38,40,42,44,46,48],[0,0,16,26,32,38,42,46,48,52,54,56,58,60,62,64],[0,16,32,42,48,54,58,62,64,68,70,72,74,76,78,80],[0,32,48,58,64,70,74,78,80,84,86,88,90,92,94,96],[0,48,64,74,80,86,90,94,96,100,102,104,106,108,110,112]]],this.MULTI_FACTORS=[1,2,4,6,8,10,12,14,16,18,20,20,24,24,30,30],this.RATE_DECAY_DURATIONS=[-1,-1,-1,-1,20926.6,16807.2,14006,12028.7,10463.3,8403.58,7002.98,6014.32,5231.64,4201.79,3501.49,3007.16,2615.82,2100.89,1750.75,1503.58,1307.91,1050.45,875.37,751.79,653.95,525.22,437.69,375.9,326.98,262.61,218.84,187.95,163.49,131.31,109.42,93.97,81.74,65.65,54.71,46.99,40.87,32.83,27.36,23.49,20.44,16.41,13.68,11.75,10.22,8.21,6.84,5.87,5.11,4.1,3.42,2.94,2.55,2.05,1.71,1.47,1.27,1.27,1.27,1.27],this.RATE_ATTACK_DURATIONS=[-1,-1,-1,-1,1730.15,1400.6,1153.43,988.66,865.08,700.3,576.72,494.33,432.54,350.15,288.36,247.16,216.27,175.07,144.18,123.58,108.13,87.54,72.09,61.79,54.07,43.77,36.04,30.9,27.03,21.88,18.02,15.45,13.52,10.94,9.01,7.72,6.76,5.47,4.51,3.86,3.38,2.74,2.25,1.93,1.69,1.37,1.13,.97,.84,.7,.6,.54,.5,.42,.34,.3,.28,.22,.18,.14,0,0,0,0]},wmsx.YM2413Audio=function(pName){"use strict";function init(){name=pName||"YM2413";var a=new wmsx.YM2413Tables;sineTable=a.getFullSineTable(),halfSineTable=a.getHalfSineTable(),expTable=a.getExpTable(),instrumentsParameters=a.getInstrumentsROM(),multiFactors=a.getMultiFactorsDoubled(),vibValues=a.getVIBValues(),kslValues=a.getKSLValues(),rateAttackDurTable=a.getRateAttackDurations(),rateDecayDurTable=a.getRateDecayDurations(),VOLPAN&&wmsx.AudioTables.setupVolPan(14,VOL,PAN,volPanL,volPanR)}function connectAudio(){audioSocket&&(audioSignal||(audioSignal=new wmsx.AudioSignal(name,self,VOLUME,SAMPLE_RATE,VOLPAN)),audioSocket.connectAudioSignal(audioSignal),audioConnected=!0)}function disconnectAudio(){audioSocket&&audioSignal&&audioSocket.disconnectAudioSignal(audioSignal),audioConnected=!1}function registerWrite(a,b){var c=15&a;c>8&&(c-=9);var d=c<<1,e=d+1,f=register[a]^b;switch(register[a]=b,a){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:f&&(instrumentsParameters[0][a]=b,updateCustomInstrChannels());break;case 14:32&f&&setRhythmMode(0!=(32&b)),rhythmMode&&(48&f&&(setRhythmKeyOnOp(12,(16&b)>>4),setRhythmKeyOnOp(13,(16&b)>>4)),40&f&&setRhythmKeyOnOp(15,(8&b)>>3),36&f&&setRhythmKeyOnOp(16,(4&b)>>2),34&f&&setRhythmKeyOnOp(17,(2&b)>>1),33&f&&setRhythmKeyOnOp(14,1&b));break;case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:f&&(fNum[d]=-256&fNum[d]|b,fNum[e]=fNum[d],updateFrequency(c));break;case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:32&f&&setSustain(c,(32&b)>>5),16&f&&!(rhythmMode&&c>5)&&setKeyOn(c,(16&b)>>4),1&f&&(fNum[d]=-257&fNum[d]|(1&b)<<8,fNum[e]=fNum[d]),14&f&&(block[d]=b>>1&7,block[e]=block[d]),15&f&&updateFrequency(c);break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:rhythmMode&&c>5?(240&f&&c>6&&setVolumeOp(d,b>>>4),15&f&&setVolumeOp(e,15&b)):(240&f&&(audioConnected||connectAudio(),setInstr(c,b>>>4)),15&f&&setVolumeOp(e,15&b))}}function clockNoise(){noiseRegister>>=1,(noiseOutput=1&noiseRegister)&&(noiseRegister^=134230048)}function clockAM(){return!(511&clock)&&(0!==amLevel&&13!==amLevel||(amLevelInc=-amLevelInc),amLevel+=amLevelInc,!0)}function clockVIB(){return!(1023&clock)&&(vibPhase=clock>>10&7,!0)}function clockEnvelope(a){envLevel[a]===envStepNextAtLevel[a]?setEnvStepOp(a,envStepNext[a]):clock===envStepLevelIncClock[a]&&(envStepLevelIncClock[a]+=envStepLevelDur[a],envLevel[a]+=envStepLevelInc[a],updateEnvAttenuationOp(a))}function setSustain(a,b){sustain[a]=b}function setKeyOn(a,b){var c=a<<1,d=c+1;keyOn[c]=b,keyOn[d]=b,b?setEnvStep(a,DAMP):envStep[d]!==IDLE&&setEnvStepOp(d,RELEASE)}function setRhythmKeyOnOp(a,b){keyOn[a]=b,b?setEnvStepOp(a,DAMP):envStep[a]!==IDLE&&setEnvStepOp(a,RELEASE)}function setEnvStep(a,b){var c=a<<1,d=c+1;setEnvStepOp(c,b),setEnvStepOp(d,b)}function setEnvStepOp(a,b){switch(envStep[a]=b,b){case DAMP:envStepLevelDur[a]=rateDecayDurTable[48+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=ATTACK;break;case ATTACK:envStepLevelDur[a]=rateAttackDurTable[(ar[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=-8,envStepNextAtLevel[a]=0,envStepNext[a]=DECAY,phaseCounter[a]=0;break;case DECAY:envStepLevelDur[a]=rateDecayDurTable[(dr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,
envStepNextAtLevel[a]=sl[a]<<3,envStepNext[a]=SUSTAIN;break;case SUSTAIN:envType[a]?(envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=SUSTAIN):(envStepLevelDur[a]=rateDecayDurTable[(rr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE);break;case RELEASE:var c=envType[a]?sustain[a>>1]?5:rr[a]:sustain[a>>1]?5:7;envStepLevelDur[a]=rateDecayDurTable[(c<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE;break;case IDLE:default:envLevel[a]=128,envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=IDLE}}function setRhythmMode(a){rhythmMode=a,rhythmMode?(audioConnected||connectAudio(),setInstr(6,16),setInstr(7,17),setInstr(8,18)):(setEnvStep(6,IDLE),updateEnvAttenuation(6),setEnvStep(7,IDLE),updateEnvAttenuation(7),setEnvStep(8,IDLE),updateEnvAttenuation(8),setInstr(6,register[36]>>4),setInstr(7,register[37]>>4),setInstr(8,register[38]>>4))}function setInstr(a,b){instr[a]=b;var c=a<<1,d=c+1,e=instrumentsParameters[b];am[c]=e[0]>>7&1,am[d]=e[1]>>7&1,vib[c]=e[0]>>6&1,vib[d]=e[1]>>6&1,envType[c]=e[0]>>5&1,envType[d]=e[1]>>5&1,ksr[c]=e[0]>>4&1,ksr[d]=e[1]>>4&1,multi[c]=multiFactors[15&e[0]],multi[d]=multiFactors[15&e[1]],ksl[c]=e[2]>>6,ksl[d]=e[3]>>6,modTL[c]=63&e[2],halfWave[c]=e[3]>>3&1,halfWave[d]=e[3]>>4&1,fbShift[a]=7&e[3]?8-(7&e[3]):0,ar[c]=e[4]>>4,ar[d]=e[5]>>4,dr[c]=15&e[4],dr[d]=15&e[5],sl[c]=e[6]>>4,sl[d]=e[7]>>4,rr[c]=15&e[6],rr[d]=15&e[7],updateAMAttenuation(a),updateFrequency(a),updateModAttenuationOp(c)}function updateCustomInstrChannels(){for(var a=0;a<9;a++)0===instr[a]&&setInstr(a,0)}function setVolumeOp(a,b){volume[a]=b,updateVolumeAttenuationOp(a)}function updateFrequency(a){var b=a<<1,c=b+1,d=vib[b]?vibValues[fNum[b]>>6][vibPhase]:0;phaseInc[b]=((fNum[b]<<1)+d)*multi[b]<<block[b]>>2,d=vib[c]?vibValues[fNum[c]>>6][vibPhase]:0,phaseInc[c]=((fNum[c]<<1)+d)*multi[c]<<block[c]>>2,updateKSLAttenuation(a),updateKSROffset(a)}function updateFrequencyOp(a){var b=vib[a]?vibValues[fNum[a]>>6][vibPhase]:0;phaseInc[a]=((fNum[a]<<1)+b)*multi[a]<<block[a]>>2,updateKSLAttenuationOp(a),updateKSROffsetOp(a)}function updateKSROffset(a){var b=a<<1,c=b+1;ksrOffset[b]=(ksr[b]?block[b]<<1:block[b]>>1)|fNum[b]>>>9-ksr[b],ksrOffset[c]=(ksr[c]?block[c]<<1:block[c]>>1)|fNum[c]>>>9-ksr[c]}function updateKSROffsetOp(a){ksrOffset[a]=(ksr[a]?block[a]<<1:block[a]>>1)|fNum[a]>>>9-ksr[a]}function updateAMAttenuation(a){var b=a<<1,c=b+1;amAtt[b]=am[b]?amLevel<<4:0,amAtt[c]=am[c]?amLevel<<4:0,updateTotalAttenuation(a)}function updateAMAttenuationOp(a){amAtt[a]=am[a]?amLevel<<4:0,updateTotalAttenuationOp(a)}function updateKSLAttenuation(a){var b=a<<1,c=b+1;kslAtt[b]=kslValues[ksl[b]][block[b]][fNum[b]>>>5]<<4,kslAtt[c]=kslValues[ksl[c]][block[c]][fNum[c]>>>5]<<4,updateTotalAttenuation(a)}function updateKSLAttenuationOp(a){kslAtt[a]=kslValues[ksl[a]][block[a]][fNum[a]>>>5]<<4,updateTotalAttenuationOp(a)}function updateEnvAttenuation(a){var b=a<<1,c=b+1;envAtt[b]=(128===envLevel[b]?256:envLevel[b])<<4,envAtt[c]=(128===envLevel[c]?256:envLevel[c])<<4,updateTotalAttenuation(a)}function updateEnvAttenuationOp(a){envAtt[a]=(128===envLevel[a]?256:envLevel[a])<<4,updateTotalAttenuationOp(a)}function updateModAttenuationOp(a){volModAtt[a]=modTL[a]<<5,updateTotalAttenuationOp(a)}function updateVolumeAttenuationOp(a){volModAtt[a]=(15===volume[a]?30:volume[a])<<7,updateTotalAttenuationOp(a)}function updateTotalAttenuation(a){var b=a<<1,c=b+1;totalAtt[b]=amAtt[b]+kslAtt[b]+envAtt[b]+volModAtt[b],totalAtt[c]=amAtt[c]+kslAtt[c]+envAtt[c]+volModAtt[c]}function updateTotalAttenuationOp(a){totalAtt[a]=amAtt[a]+kslAtt[a]+envAtt[a]+volModAtt[a]}var self=this;this.connect=function(a){a.bus.connectInputDevice(124,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectInputDevice(125,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectOutputDevice(124,this.output7C),a.bus.connectOutputDevice(125,this.output7D),audioSocket=a.getAudioSocket(),audioConnected&&connectAudio()},this.disconnect=function(a){a.bus.disconnectInputDevice(124,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectInputDevice(125,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(124,this.output7C),a.bus.disconnectOutputDevice(125,this.output7D),disconnectAudio(),audioSocket=null},this.powerOn=function(){this.reset()},this.powerOff=function(){disconnectAudio()},this.reset=function(){registerAddress=0,wmsx.Util.arrayFill(register,0),wmsx.Util.arrayFill(instrumentsParameters[0],0),clock=0,noiseRegister=65535,noiseOutput=0,amLevel=0,amLevelInc=-1,vibPhase=0,rhythmMode=!1,wmsx.Util.arrayFill(sustain,0),wmsx.Util.arrayFill(instr,0),wmsx.Util.arrayFill(keyOn,0),wmsx.Util.arrayFill(am,0),wmsx.Util.arrayFill(vib,0),wmsx.Util.arrayFill(envType,0),wmsx.Util.arrayFill(ksr,0),wmsx.Util.arrayFill(multi,0),wmsx.Util.arrayFill(ksl,0),wmsx.Util.arrayFill(halfWave,0),wmsx.Util.arrayFill(ar,0),wmsx.Util.arrayFill(dr,0),wmsx.Util.arrayFill(sl,0),wmsx.Util.arrayFill(rr,0),wmsx.Util.arrayFill(fNum,0),wmsx.Util.arrayFill(block,0),wmsx.Util.arrayFill(volume,0),wmsx.Util.arrayFill(modTL,0),wmsx.Util.arrayFill(fbShift,0),wmsx.Util.arrayFill(volModAtt,0),wmsx.Util.arrayFill(amAtt,0),wmsx.Util.arrayFill(envAtt,0),wmsx.Util.arrayFill(kslAtt,0),wmsx.Util.arrayFill(totalAtt,0),wmsx.Util.arrayFill(envStep,IDLE),wmsx.Util.arrayFill(envStepLevelDur,0),wmsx.Util.arrayFill(envStepLevelIncClock,0),wmsx.Util.arrayFill(envStepLevelInc,0),wmsx.Util.arrayFill(envStepNext,DAMP),wmsx.Util.arrayFill(envStepNextAtLevel,0),wmsx.Util.arrayFill(envLevel,0),wmsx.Util.arrayFill(ksrOffset,0),wmsx.Util.arrayFill(fbLastMod1,0),wmsx.Util.arrayFill(fbLastMod2,0),wmsx.Util.arrayFill(phaseInc,0),wmsx.Util.arrayFill(phaseCounter,0),disconnectAudio()},this.output7C=function(a){registerAddress=63&a},this.output7D=function(a){registerWrite(registerAddress,a)},this.nextSample=function(){var a,b,c,d,e,f,g=!1;++clock,(a=clockAM())&&(g=clockVIB());for(var h=0,i=0,j=0,k=0,l=rhythmMode?5:8,m=l;m>=0;--m)b=m<<1,c=b+1,envStep[c]!==IDLE&&(a&&(am[b]&&updateAMAttenuationOp(b),am[c]&&updateAMAttenuationOp(c),g&&(vib[b]&&updateFrequencyOp(b),vib[c]&&updateFrequencyOp(c))),envStep[b]!==IDLE&&clockEnvelope(b),clockEnvelope(c),d=(phaseCounter[b]+=phaseInc[b])>>9,e=(phaseCounter[c]+=phaseInc[c])>>9,fbShift[m]?(d+=fbLastMod1[m]+fbLastMod2[m]>>fbShift[m],f=expTable[(halfWave[b]?halfSineTable:sineTable)[1023&d]+totalAtt[b]],fbLastMod2[m]=fbLastMod1[m]>>1,fbLastMod1[m]=f>>1):f=expTable[(halfWave[b]?halfSineTable:sineTable)[1023&d]+totalAtt[b]],h=expTable[(halfWave[c]?halfSineTable:sineTable)[e+f&1023]+totalAtt[c]]>>4,VOLPAN?(i+=h*volPanL[m],j+=h*volPanR[m]):k+=h);if(rhythmMode&&(clockNoise(),c=13,envStep[c]!==IDLE&&(b=12,clockEnvelope(b),clockEnvelope(c),d=((phaseCounter[b]+=phaseInc[b])>>9)-1,e=(phaseCounter[c]+=phaseInc[c])>>9,f=expTable[sineTable[1023&d]+totalAtt[b]],h=expTable[sineTable[e+f&1023]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[9],j+=h*volPanR[9]):k+=h),c=15,envStep[c]!==IDLE&&(clockEnvelope(c),e=(phaseCounter[c]+=phaseInc[c])>>9,h=expTable[sineTable[256&e?noiseOutput?0:130:noiseOutput?0:893]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[10],j+=h*volPanR[10]):k+=h),c=16,envStep[c]!==IDLE&&(clockEnvelope(c),e=(phaseCounter[c]+=phaseInc[c])>>9,h=expTable[sineTable[1023&e]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[11],j+=h*volPanR[11]):k+=h),envStep[17]!==IDLE||envStep[14]!==IDLE)){var n=(phaseCounter[14]+=phaseInc[14])>>9,o=(phaseCounter[17]+=phaseInc[17])>>9,p=(0!=(4&o)&&0==(16&o))!=(0!=(2&n)!=(0!=(256&n))||0!=(4&n));c=17,envStep[c]!==IDLE&&(clockEnvelope(c),h=expTable[sineTable[p?200:823]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[12],j+=h*volPanR[12]):k+=h),c=14,envStep[c]!==IDLE&&(clockEnvelope(c),
h=expTable[sineTable[p?noiseOutput?40:10:noiseOutput?983:1013]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[13],j+=h*volPanR[13]):k+=h)}return VOLPAN?(sampleResult[0]=i,sampleResult[1]=j,sampleResult):k};var name,audioConnected=!1,IDLE=255,DAMP=0,ATTACK=1,DECAY=2,SUSTAIN=3,RELEASE=4,clock,noiseRegister,noiseOutput,amLevel,amLevelInc,vibPhase,registerAddress,register=new Array(56),rhythmMode,sustain=new Array(9),instr=new Array(9),keyOn=new Array(18),am=new Array(18),vib=new Array(18),envType=new Array(18),ksr=new Array(18),multi=new Array(18),ksl=new Array(18),halfWave=new Array(18),ar=new Array(18),dr=new Array(18),sl=new Array(18),rr=new Array(18),fNum=new Array(18),block=new Array(18),volume=new Array(18),modTL=new Array(18),fbShift=new Array(9),volModAtt=new Array(18),amAtt=new Array(18),envAtt=new Array(18),kslAtt=new Array(18),totalAtt=new Array(18),envStep=new Array(18),envStepLevelDur=new Array(18),envStepLevelIncClock=new Array(18),envStepLevelInc=new Array(18),envStepNext=new Array(18),envStepNextAtLevel=new Array(18),envLevel=new Array(18),ksrOffset=new Array(18),fbLastMod1=new Array(9),fbLastMod2=new Array(9),phaseInc=new Array(18),phaseCounter=new Array(18),volPanL=new Array(14),volPanR=new Array(14),sineTable,halfSineTable,expTable,instrumentsParameters,multiFactors,vibValues,kslValues,rateAttackDurTable,rateDecayDurTable,audioSocket,audioSignal,sampleResult=[0,0],VOLUME=1.58/9/256*.68,SAMPLE_RATE=49780,VOL=(WMSX.OPLL_VOL||"f").toUpperCase(),PAN=(WMSX.OPLL_PAN||"8").toUpperCase(),VOLPAN="F"!==VOL||"8"!==PAN;this.saveState=function(){return{n:name,ac:audioConnected,ra:registerAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),c:clock,nr:noiseRegister,no:noiseOutput,al:amLevel,ai:amLevelInc,vp:vibPhase,amt:wmsx.Util.storeInt16BitArrayToStringBase64(amAtt),evt:wmsx.Util.storeInt16BitArrayToStringBase64(envAtt),kst:wmsx.Util.storeInt16BitArrayToStringBase64(kslAtt),tot:wmsx.Util.storeInt16BitArrayToStringBase64(totalAtt),evs:wmsx.Util.storeInt8BitArrayToStringBase64(envStep),evd:wmsx.Util.storeInt32BitArrayToStringBase64(envStepLevelDur),evc:envStepLevelIncClock,evi:wmsx.Util.storeInt8BitArrayToStringBase64(envStepLevelInc),evn:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNext),evl:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNextAtLevel),eve:wmsx.Util.storeInt8BitArrayToStringBase64(envLevel),kso:wmsx.Util.storeInt8BitArrayToStringBase64(ksrOffset),fb1:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod1),fb2:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod2)}},this.loadState=function(a){this.reset(),name=a.n,audioConnected=a.ac,registerAddress=a.ra;for(var b=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r),c=0;c<b.length;c++)registerWrite(c,b[c]);clock=a.c,noiseRegister=a.nr,noiseOutput=a.no,amLevel=a.al,amLevelInc=a.ai,vibPhase=a.vp,amAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.amt,amAtt),envAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.evt,envAtt),kslAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.kst,kslAtt),totalAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.tot,totalAtt),envStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evs,envStep),envStepLevelDur=wmsx.Util.restoreStringBase64ToInt32BitArray(a.evd),envStepLevelIncClock=a.evc,envStepLevelInc=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.evi,envStepLevelInc),envStepNext=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evn,envStepNext),envStepNextAtLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evl,envStepNextAtLevel),envLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.eve,envLevel),ksrOffset=wmsx.Util.restoreStringBase64ToInt8BitArray(a.kso,ksrOffset),fbLastMod1=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb1,fbLastMod1),fbLastMod2=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb2,fbLastMod2),audioConnected&&connectAudio()},init(),this.eval=function(str){return eval(str)}},wmsx.OPL4WaveTables=function(){"use strict";this.getRegisterWriteMasks=function(){var a,b=wmsx.Util.arrayFill(new Array(256),255);for(b[0]=b[1]=0,b[2]=29,b[3]=63,b[7]=0,a=128;a<=151;++a)b[a]=63;for(a=224;a<=247;++a)b[a]=7;for(b[248]=b[249]=63,a=250;a<=255;++a)b[a]=0;return b},this.getPanPotValues=function(){return this.PANPOT_VALUES},this.getVolumeTable=function(){for(var a=new Array(2048),b=0;b<1024;++b)a[b]=Math.pow(10,-.1875*b/20);for(b=1024;b<2048;++b)a[b]=0;return a},this.getRateAttackPatterns=function(){for(var a=new Array(832),b=0;b<64;++b)for(var c=0;c<8;++c)a[8*b+c]=b<52?this.RATE_ATTACK_SHIFTS[3&b][c]:this.RATE_ATTACK_SHIFTS[b-52+4][c];for(c=512;c<832;++c)a[c]=0;return a},this.getRateDecayPatterns=function(){for(var a=new Array(832),b=0;b<64;++b)for(var c=0;c<8;++c)a[8*b+c]=b<56?this.RATE_DECAY_INCS[3&b][c]:this.RATE_DECAY_INCS[b-56+4][c];for(c=512;c<832;++c)a[c]=2;return a},this.getLFOStepClocks=function(){for(var a=new Array(8),b=0;b<8;++b)a[b]=Math.round(44100/this.LFO_FREQS[b]/128);return a},this.getVIBOffsets=function(){for(var a=new Array(1024),b=0;b<8;++b)for(var c=this.VIB_DEPTHS[b],d=0;d<128;++d)a[128*b+d]=Math.round(d<32?d/32*c:d<96?(64-d)/32*c:(d-128)/32*c);return a},this.getAMOffsets=function(){for(var a=new Array(1024),b=0;b<8;++b)for(var c=this.AM_DEPTHS[b]/.1875,d=0;d<128;++d)a[128*b+d]=Math.round(d<64?d/64*c:(128-d)/64*c);return a},this.PANPOT_VALUES=[[0,16,32,48,64,80,96,512,512,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,512,512,96,80,64,48,32,16]],this.RATE_ATTACK_SHIFTS=[[3,-1,3,-1,3,-1,4,4],[3,-1,3,3,-1,3,3,-1],[3,3,3,-1,3,3,3,-1],[3,3,3,-1,3,3,3,4],[3,-1,4,-1,3,-1,4,4],[3,-1,3,-1,3,-1,3,4],[3,4,4,4,3,4,4,4],[3,4,3,4,3,4,3,4],[3,3,3,4,3,3,3,4],[2,3,3,3,4,3,3,3],[2,3,3,2,3,3,2,3],[2,2,3,2,2,3,2,3],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[0,0,0,0,0,0,0,0]],this.RATE_DECAY_INCS=[[-1,1,-1,1,-1,1,-1,1],[-1,1,-1,1,1,-1,1,1],[-1,1,1,1,-1,1,1,1],[-1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1],[1,1,1,2,1,1,1,2],[1,2,1,2,1,2,1,2],[1,2,2,2,1,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2]],this.LFO_FREQS=[.168,2.019,3.196,4.206,5.215,5.888,6.224,7.066],this.VIB_DEPTHS=[0,2,3,4,6,12,24,48],this.AM_DEPTHS=[0,1.781,2.906,3.656,4.406,5.906,7.406,11.91]},wmsx.OPL4Audio=function(pName,cart){"use strict";function init(a){name=pName||"OPL4",a.fm=fm=new wmsx.OPL4AudioFM(a),a.wave=wave=new wmsx.OPL4AudioWave(a)}function connectAudio(){audioSocket&&(audioSignal||(audioSignal=new wmsx.AudioSignal(name,self,VOLUME,SAMPLE_RATE,!0,CLOCK)),audioSocket.connectAudioSignal(audioSignal),audioConnected=!0)}function disconnectAudio(){audioSocket&&audioSignal&&audioSocket.disconnectAudioSignal(audioSignal),audioConnected=!1}var self=this;this.connect=function(a){fm.connect(a),wave.connect(a),audioSocket=a.getAudioSocket(),audioConnected&&connectAudio()},this.disconnect=function(a){fm.disconnect(a),wave.disconnect(a),disconnectAudio(),audioSocket=null},this.powerOn=function(){this.reset()},this.powerOff=function(){disconnectAudio()},this.reset=function(){connectAudio(),fm.reset(),wave.reset()},this.audioClockPulse=function(){try{fm.audioClockPulse()}catch(a){window.E=a,console.error(a)}},this.nextSample=function(){try{return wave.nextSample()}catch(a){return window.E=a,console.error(a),0}},this.memoryRead=cart.opl4ReadMemory,this.memoryWrite=cart.opl4WriteMemory;var name,audioConnected=!1,fm,wave,audioSocket,audioSignal,VOLUME=7/24/32768*.66,SAMPLE_RATE=44100,CLOCK=49780;this.saveState=function(){return{n:name,ac:audioConnected,fm:fm.saveState(),wv:wave.saveState()}},this.loadState=function(a){this.reset(),name=a.n,audioConnected=a.ac,fm.loadState(a.fm),wave.loadState(a.wv),audioConnected&&connectAudio()},init(this),this.eval=function(str){return eval(str)}},wmsx.OPL4AudioFM=function(opl4){"use strict";function init(){var a=new wmsx.YM2413Tables;sineTable=a.getFullSineTable(),halfSineTable=a.getHalfSineTable(),expTable=a.getExpTable(),instrumentsParameters=a.getInstrumentsROM(),multiFactors=a.getMultiFactorsDoubled(),
vibValues=a.getVIBValues(),kslValues=a.getKSLValues(),rateAttackDurTable=a.getRateAttackDurations(),rateDecayDurTable=a.getRateDecayDurations()}function clockTimers(){timer1Active&&++timer1Counter>255&&(timer1Counter=register[2],timer1Masked||(status|=192,updateIRQ())),timer2Active&&0==(15&clock)&&++timer2Counter>255&&(timer2Counter=register[3],timer2Masked||(status|=160,updateIRQ()))}function updateIRQ(){cpu.setINTChannel(1,0==(128&status))}function connectAudio(){}function registerWrite(a,b){if(4===a&&128&b)return register[4]&=-129,status=0,void updateIRQ();var c=register[a]^b;switch(register[a]=b,a){case 4:1&c&&(timer1Active=0!=(1&b))&&(timer1Counter=register[2]),2&c&&(timer2Active=0!=(2&b))&&(timer2Counter=register[3]),64&c&&(timer1Masked=0!=(64&b)),32&c&&(timer2Masked=0!=(32&b))}}function clockNoise(){noiseRegister>>=1,(noiseOutput=1&noiseRegister)&&(noiseRegister^=134230048)}function clockAM(){return!(511&clock)&&(0!==amLevel&&13!==amLevel||(amLevelInc=-amLevelInc),amLevel+=amLevelInc,!0)}function clockVIB(){return!(1023&clock)&&(vibPhase=clock>>10&7,!0)}function clockEnvelope(a){envLevel[a]===envStepNextAtLevel[a]?setEnvStepOp(a,envStepNext[a]):clock===envStepLevelIncClock[a]&&(envStepLevelIncClock[a]+=envStepLevelDur[a],envLevel[a]+=envStepLevelInc[a],updateEnvAttenuationOp(a))}function setSustain(a,b){sustain[a]=b}function setKeyOn(a,b){var c=a<<1,d=c+1;keyOn[c]=b,keyOn[d]=b,b?setEnvStep(a,DAMP):envStep[d]!==IDLE&&setEnvStepOp(d,RELEASE)}function setRhythmKeyOnOp(a,b){keyOn[a]=b,b?setEnvStepOp(a,DAMP):envStep[a]!==IDLE&&setEnvStepOp(a,RELEASE)}function setEnvStep(a,b){var c=a<<1,d=c+1;setEnvStepOp(c,b),setEnvStepOp(d,b)}function setEnvStepOp(a,b){switch(envStep[a]=b,b){case DAMP:envStepLevelDur[a]=rateDecayDurTable[48+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=ATTACK;break;case ATTACK:envStepLevelDur[a]=rateAttackDurTable[(ar[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=-8,envStepNextAtLevel[a]=0,envStepNext[a]=DECAY,phaseCounter[a]=0;break;case DECAY:envStepLevelDur[a]=rateDecayDurTable[(dr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=sl[a]<<3,envStepNext[a]=SUSTAIN;break;case SUSTAIN:envType[a]?(envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=SUSTAIN):(envStepLevelDur[a]=rateDecayDurTable[(rr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE);break;case RELEASE:var c=envType[a]?sustain[a>>1]?5:rr[a]:sustain[a>>1]?5:7;envStepLevelDur[a]=rateDecayDurTable[(c<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE;break;case IDLE:default:envLevel[a]=128,envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=IDLE}}function setRhythmMode(a){rhythmMode=a,rhythmMode?(audioConnected||connectAudio(),setInstr(6,16),setInstr(7,17),setInstr(8,18)):(setEnvStep(6,IDLE),updateEnvAttenuation(6),setEnvStep(7,IDLE),updateEnvAttenuation(7),setEnvStep(8,IDLE),updateEnvAttenuation(8),setInstr(6,register[36]>>4),setInstr(7,register[37]>>4),setInstr(8,register[38]>>4))}function setInstr(a,b){instr[a]=b;var c=a<<1,d=c+1,e=instrumentsParameters[b];am[c]=e[0]>>7&1,am[d]=e[1]>>7&1,vib[c]=e[0]>>6&1,vib[d]=e[1]>>6&1,envType[c]=e[0]>>5&1,envType[d]=e[1]>>5&1,ksr[c]=e[0]>>4&1,ksr[d]=e[1]>>4&1,multi[c]=multiFactors[15&e[0]],multi[d]=multiFactors[15&e[1]],ksl[c]=e[2]>>6,ksl[d]=e[3]>>6,modTL[c]=63&e[2],halfWave[c]=e[3]>>3&1,halfWave[d]=e[3]>>4&1,fbShift[a]=7&e[3]?8-(7&e[3]):0,ar[c]=e[4]>>4,ar[d]=e[5]>>4,dr[c]=15&e[4],dr[d]=15&e[5],sl[c]=e[6]>>4,sl[d]=e[7]>>4,rr[c]=15&e[6],rr[d]=15&e[7],updateAMAttenuation(a),updateFrequency(a),updateModAttenuationOp(c)}function updateCustomInstrChannels(){for(var a=0;a<9;a++)0===instr[a]&&setInstr(a,0)}function setVolumeOp(a,b){volume[a]=b,updateVolumeAttenuationOp(a)}function updateFrequency(a){var b=a<<1,c=b+1,d=vib[b]?vibValues[fNum[b]>>6][vibPhase]:0;phaseInc[b]=((fNum[b]<<1)+d)*multi[b]<<block[b]>>2,d=vib[c]?vibValues[fNum[c]>>6][vibPhase]:0,phaseInc[c]=((fNum[c]<<1)+d)*multi[c]<<block[c]>>2,updateKSLAttenuation(a),updateKSROffset(a)}function updateFrequencyOp(a){var b=vib[a]?vibValues[fNum[a]>>6][vibPhase]:0;phaseInc[a]=((fNum[a]<<1)+b)*multi[a]<<block[a]>>2,updateKSLAttenuationOp(a),updateKSROffsetOp(a)}function updateKSROffset(a){var b=a<<1,c=b+1;ksrOffset[b]=(ksr[b]?block[b]<<1:block[b]>>1)|fNum[b]>>>9-ksr[b],ksrOffset[c]=(ksr[c]?block[c]<<1:block[c]>>1)|fNum[c]>>>9-ksr[c]}function updateKSROffsetOp(a){ksrOffset[a]=(ksr[a]?block[a]<<1:block[a]>>1)|fNum[a]>>>9-ksr[a]}function updateAMAttenuation(a){var b=a<<1,c=b+1;amAtt[b]=am[b]?amLevel<<4:0,amAtt[c]=am[c]?amLevel<<4:0,updateTotalAttenuation(a)}function updateAMAttenuationOp(a){amAtt[a]=am[a]?amLevel<<4:0,updateTotalAttenuationOp(a)}function updateKSLAttenuation(a){var b=a<<1,c=b+1;kslAtt[b]=kslValues[ksl[b]][block[b]][fNum[b]>>>5]<<4,kslAtt[c]=kslValues[ksl[c]][block[c]][fNum[c]>>>5]<<4,updateTotalAttenuation(a)}function updateKSLAttenuationOp(a){kslAtt[a]=kslValues[ksl[a]][block[a]][fNum[a]>>>5]<<4,updateTotalAttenuationOp(a)}function updateEnvAttenuation(a){var b=a<<1,c=b+1;envAtt[b]=(128===envLevel[b]?256:envLevel[b])<<4,envAtt[c]=(128===envLevel[c]?256:envLevel[c])<<4,updateTotalAttenuation(a)}function updateEnvAttenuationOp(a){envAtt[a]=(128===envLevel[a]?256:envLevel[a])<<4,updateTotalAttenuationOp(a)}function updateModAttenuationOp(a){volModAtt[a]=modTL[a]<<5,updateTotalAttenuationOp(a)}function updateVolumeAttenuationOp(a){volModAtt[a]=(15===volume[a]?30:volume[a])<<7,updateTotalAttenuationOp(a)}function updateTotalAttenuation(a){var b=a<<1,c=b+1;totalAtt[b]=amAtt[b]+kslAtt[b]+envAtt[b]+volModAtt[b],totalAtt[c]=amAtt[c]+kslAtt[c]+envAtt[c]+volModAtt[c]}function updateTotalAttenuationOp(a){totalAtt[a]=amAtt[a]+kslAtt[a]+envAtt[a]+volModAtt[a]}var self=this;this.connect=function(a){cpu=a.cpu,a.bus.connectInputDevice(196,this.inputC4),a.bus.connectOutputDevice(196,this.outputC4),a.bus.connectInputDevice(197,this.inputC5),a.bus.connectOutputDevice(197,this.outputC5),a.bus.connectInputDevice(198,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectOutputDevice(198,this.outputC6),a.bus.connectInputDevice(199,this.inputC5),a.bus.connectOutputDevice(199,this.outputC5)},this.disconnect=function(a){a.bus.disconnectInputDevice(196,this.inputC4),a.bus.disconnectOutputDevice(196,this.outputC4),a.bus.disconnectInputDevice(197,this.inputC5),a.bus.disconnectOutputDevice(197,this.outputC5),a.bus.disconnectInputDevice(198,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(198,this.outputC6),a.bus.disconnectInputDevice(199,this.inputC5),a.bus.disconnectOutputDevice(199,this.outputC5)},this.reset=function(){status=0,registerAddress=0,wmsx.Util.arrayFill(register,0),clock=0,busyUntilBUSCycle=0,timer1Counter=timer2Counter=0,timer1Active=timer2Active=!1,timer1Masked=timer2Masked=0,wmsx.Util.arrayFill(instrumentsParameters[0],0),noiseRegister=65535,noiseOutput=0,amLevel=0,amLevelInc=-1,vibPhase=0,rhythmMode=!1,wmsx.Util.arrayFill(sustain,0),wmsx.Util.arrayFill(instr,0),wmsx.Util.arrayFill(keyOn,0),wmsx.Util.arrayFill(am,0),wmsx.Util.arrayFill(vib,0),wmsx.Util.arrayFill(envType,0),wmsx.Util.arrayFill(ksr,0),wmsx.Util.arrayFill(multi,0),wmsx.Util.arrayFill(ksl,0),wmsx.Util.arrayFill(halfWave,0),wmsx.Util.arrayFill(ar,0),wmsx.Util.arrayFill(dr,0),wmsx.Util.arrayFill(sl,0),wmsx.Util.arrayFill(rr,0),wmsx.Util.arrayFill(fNum,0),wmsx.Util.arrayFill(block,0),wmsx.Util.arrayFill(volume,0),wmsx.Util.arrayFill(modTL,0),wmsx.Util.arrayFill(fbShift,0),wmsx.Util.arrayFill(volModAtt,0),wmsx.Util.arrayFill(amAtt,0),
wmsx.Util.arrayFill(envAtt,0),wmsx.Util.arrayFill(kslAtt,0),wmsx.Util.arrayFill(totalAtt,0),wmsx.Util.arrayFill(envStep,IDLE),wmsx.Util.arrayFill(envStepLevelDur,0),wmsx.Util.arrayFill(envStepLevelIncClock,0),wmsx.Util.arrayFill(envStepLevelInc,0),wmsx.Util.arrayFill(envStepNext,DAMP),wmsx.Util.arrayFill(envStepNextAtLevel,0),wmsx.Util.arrayFill(envLevel,0),wmsx.Util.arrayFill(ksrOffset,0),wmsx.Util.arrayFill(fbLastMod1,0),wmsx.Util.arrayFill(fbLastMod2,0),wmsx.Util.arrayFill(phaseInc,0),wmsx.Util.arrayFill(phaseCounter,0)},this.inputC4=function(){return status},this.outputC4=function(a){registerAddress=a},this.inputC5=function(){return register[registerAddress]},this.outputC5=function(a){registerWrite(registerAddress,a)},this.outputC6=function(a){registerAddress=256|a},this.audioClockPulse=function(){0==(3&++clock)&&clockTimers()},this.setBusyCycles=function(a){},this.nextSample=function(){return 0};var cpu,busyUntilBUSCycle,audioConnected=!1,status=0,registerAddress=0,register=new Array(56),timer1Counter=0,timer2Counter=0,timer1Active=!1,timer2Active=!1,timer1Masked=!1,timer2Masked=!1,IDLE=255,DAMP=0,ATTACK=1,DECAY=2,SUSTAIN=3,RELEASE=4,clock,noiseRegister,noiseOutput,amLevel,amLevelInc,vibPhase,rhythmMode,sustain=new Array(9),instr=new Array(9),keyOn=new Array(18),am=new Array(18),vib=new Array(18),envType=new Array(18),ksr=new Array(18),multi=new Array(18),ksl=new Array(18),halfWave=new Array(18),ar=new Array(18),dr=new Array(18),sl=new Array(18),rr=new Array(18),fNum=new Array(18),block=new Array(18),volume=new Array(18),modTL=new Array(18),fbShift=new Array(9),volModAtt=new Array(18),amAtt=new Array(18),envAtt=new Array(18),kslAtt=new Array(18),totalAtt=new Array(18),envStep=new Array(18),envStepLevelDur=new Array(18),envStepLevelIncClock=new Array(18),envStepLevelInc=new Array(18),envStepNext=new Array(18),envStepNextAtLevel=new Array(18),envLevel=new Array(18),ksrOffset=new Array(18),fbLastMod1=new Array(9),fbLastMod2=new Array(9),phaseInc=new Array(18),phaseCounter=new Array(18),sineTable,halfSineTable,expTable,instrumentsParameters,multiFactors,vibValues,kslValues,rateAttackDurTable,rateDecayDurTable,VOLUME=1.55/9/256*.65;this.saveState=function(){return{ac:audioConnected,s:status,ra:registerAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),c:clock,nr:noiseRegister,no:noiseOutput,al:amLevel,ai:amLevelInc,vp:vibPhase,t1c:timer1Counter,t2c:timer2Counter,t1a:timer1Active,t2a:timer2Active,t1m:timer1Masked,t2m:timer2Masked,amt:wmsx.Util.storeInt16BitArrayToStringBase64(amAtt),evt:wmsx.Util.storeInt16BitArrayToStringBase64(envAtt),kst:wmsx.Util.storeInt16BitArrayToStringBase64(kslAtt),tot:wmsx.Util.storeInt16BitArrayToStringBase64(totalAtt),evs:wmsx.Util.storeInt8BitArrayToStringBase64(envStep),evd:wmsx.Util.storeInt32BitArrayToStringBase64(envStepLevelDur),evc:envStepLevelIncClock,evi:wmsx.Util.storeInt8BitArrayToStringBase64(envStepLevelInc),evn:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNext),evl:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNextAtLevel),eve:wmsx.Util.storeInt8BitArrayToStringBase64(envLevel),kso:wmsx.Util.storeInt8BitArrayToStringBase64(ksrOffset),fb1:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod1),fb2:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod2)}},this.loadState=function(a){this.reset(),audioConnected=a.ac,status=a.s,registerAddress=a.ra;for(var b=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r),c=0;c<b.length;c++)registerWrite(c,b[c]);clock=a.c,noiseRegister=a.nr,noiseOutput=a.no,amLevel=a.al,amLevelInc=a.ai,vibPhase=a.vp,timer1Counter=a.t1c,timer2Counter=a.t2c,timer1Active=a.t1a,timer2Active=a.t2a,timer1Masked=a.t1m,timer2Masked=a.t2m,amAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.amt,amAtt),envAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.evt,envAtt),kslAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.kst,kslAtt),totalAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.tot,totalAtt),envStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evs,envStep),envStepLevelDur=wmsx.Util.restoreStringBase64ToInt32BitArray(a.evd),envStepLevelIncClock=a.evc,envStepLevelInc=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.evi,envStepLevelInc),envStepNext=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evn,envStepNext),envStepNextAtLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evl,envStepNextAtLevel),envLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.eve,envLevel),ksrOffset=wmsx.Util.restoreStringBase64ToInt8BitArray(a.kso,ksrOffset),fbLastMod1=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb1,fbLastMod1),fbLastMod2=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb2,fbLastMod2)},init(),this.eval=function(str){return eval(str)}},wmsx.OPL4AudioWave=function(opl4){"use strict";function init(){var a=new wmsx.OPL4WaveTables;regWriteMasks=a.getRegisterWriteMasks(),rateAttackPatterns=a.getRateAttackPatterns(),rateDecayPatterns=a.getRateDecayPatterns(),lfoStepClocks=a.getLFOStepClocks(),vibStepOffsets=a.getVIBOffsets(),amStepOffsets=a.getAMOffsets(),panpotValues=a.getPanPotValues(),volumeTable=a.getVolumeTable()}function registerWrite(a,b){var c,d=register[a]^b,e=regWriteMasks[a];switch(register[a]=register[a]&~e|b&e,a){case 5:memoryAddress=(63&register[3])<<16|register[4]<<8|register[5];break;case 6:opl4.memoryWrite(memoryAddress,b),++memoryAddress>=4194304&&(memoryAddress=0);break;case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:c=a-8,readWaveHeader(c,(1&register[32+c])<<8|b);break;case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:c=a-32,254&d&&(fNum[c]=b>>1|(7&register[56+c])<<7,updateFrequency(c));break;case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:case 64:case 65:case 66:case 67:case 68:case 69:case 70:case 71:case 72:case 73:case 74:case 75:case 76:case 77:case 78:case 79:c=a-56,240&d&&(octave[c]=128&b?(b>>4)-16:b>>4),7&d&&(fNum[c]=(7&b)<<7|register[32+c]>>1),247&d&&updateFrequency(c),8&d&&(reverb[c]=(8&b)>>3);break;case 80:case 81:case 82:case 83:case 84:case 85:case 86:case 87:case 88:case 89:case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:case 98:case 99:case 100:case 101:case 102:case 103:c=a-80,254&d&&(volumeAtt[c]=254&b,updateSettingsAttenuation(c));break;case 104:case 105:case 106:case 107:case 108:case 109:case 110:case 111:case 112:case 113:case 114:case 115:case 116:case 117:case 118:case 119:case 120:case 121:case 122:case 123:case 124:case 125:case 126:case 127:c=a-104,192&d&&setKeyOnAndDamp(c,128&b,64&b),32&d&&setLFOReset(c,32&b),15&d&&(panpotAttL[c]=panpotValues[0][15&b],panpotAttR[c]=panpotValues[1][15&b],updateSettingsAttenuation(c));break;case 128:case 129:case 130:case 131:case 132:case 133:case 134:case 135:case 136:case 137:case 138:case 139:case 140:case 141:case 142:case 143:case 144:case 145:case 146:case 147:case 148:case 149:case 150:case 151:c=a-128,56&d&&(lfoStepDur[c]=lfoStepClocks[(56&b)>>3]),7&d&&(vibDepth[c]=7&b,updateVIBOffset(c,lfoStep[c]));break;case 152:case 153:case 154:case 155:case 156:case 157:case 158:case 159:case 160:case 161:case 162:case 163:case 164:case 165:case 166:case 167:case 168:case 169:case 170:case 171:case 172:case 173:case 174:case 175:c=a-152,240&d&&(ar[c]=b>=240?63:(240&b)>>2),15&d&&(d1r[c]=15==(15&b)?63:(15&b)<<2);break;case 176:case 177:case 178:case 179:case 180:case 181:case 182:case 183:case 184:case 185:case 186:case 187:case 188:case 189:case 190:case 191:case 192:case 193:case 194:case 195:case 196:case 197:case 198:case 199:c=a-176,240&d&&(dl[c]=(b>=240?31:b>>4)<<4),15&d&&(d2r[c]=15==(15&b)?63:(15&b)<<2);break;case 200:case 201:case 202:case 203:case 204:case 205:case 206:case 207:case 208:
case 209:case 210:case 211:case 212:case 213:case 214:case 215:case 216:case 217:case 218:case 219:case 220:case 221:case 222:case 223:c=a-200,240&d&&(rc[c]=b>>4,updateRateCorrOffset(c)),15&d&&(rr[c]=15==(15&b)?63:(15&b)<<2);break;case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 240:case 241:case 242:case 243:case 244:case 245:case 246:case 247:c=a-224,7&d&&(amDepth[c]=7&b,updateAMAttenuation(c,lfoStep[c]));break;case 249:if(63&d)for(mixerAttL=7==(7&b)?512:(7&b)<<4,mixerAttR=56==(56&b)?512:(56&b)<<1,c=23;c>=0;--c)updateSettingsAttenuation(c)}}function registerRead(a){var b;switch(a){case 6:b=opl4.memoryRead(memoryAddress),++memoryAddress>=4194304&&(memoryAddress=0);break;default:b=register[a]}return b}function readWaveHeader(a,b){var c=register[2]>>2&7,d=b<384||0===c?12*b:(c<<19)+12*(b-384),e=opl4.memoryRead(d++);dataBits[a]=e>>6,startAddress[a]=(63&e)<<16|opl4.memoryRead(d++)<<8|opl4.memoryRead(d++),loopPosition[a]=opl4.memoryRead(d++)<<8|opl4.memoryRead(d++),endPosition[a]=65535&~(opl4.memoryRead(d++)<<8|opl4.memoryRead(d++)),registerWrite(128+a,opl4.memoryRead(d++)),registerWrite(152+a,opl4.memoryRead(d++)),registerWrite(176+a,opl4.memoryRead(d++)),registerWrite(200+a,opl4.memoryRead(d++)),registerWrite(224+a,opl4.memoryRead(d++)),envStep[a]!==IDLE&&startSample(a)}function clockLFO(a){return clock!==lfoStepChangeClock[a]?-1:(lfoStepChangeClock[a]+=lfoStepDur[a],lfoStep[a]=lfoStep[a]+1&127)}function updateVIBOffset(a,b){var c=vibStepOffsets[vibDepth[a]<<7|b];vibOffset[a]!==c&&(vibOffset[a]=c,updateFrequency(a))}function updateAMAttenuation(a,b){var c=amStepOffsets[amDepth[a]<<7|b];amAtt[a]!==c&&(amAtt[a]=c,updateDynamicLevel(a))}function clockEnvelope(a){if(clock===envStepLevelChangeClock[a]){var b=envStepLevelPattCounter[a]=envStepLevelPattCounter[a]+1&7;if(envStep[a]===ATTACK){var c=rateAttackPatterns[envStepRate[a]<<3|b];if(c>=0){if(envAtt[a]-=1+(envAtt[a]>>c),envAtt[a]<=0)return setEnvStep(a,DECAY1);updateDynamicLevel(a)}}else if((c=rateDecayPatterns[envStepRate[a]<<3|b])>=0){if(envAtt[a]+=c,envAtt[a]>=envStepNextAtLevel[a])return setEnvStep(a,envStepNext[a]);updateDynamicLevel(a)}envStepLevelChangeClock[a]+=envStepLevelDur[a]}}function setKeyOnAndDamp(a,b,c){c?envStep[a]!==IDLE&&envStep[a]!==DAMP&&setEnvStep(a,DAMP):b?(startSample(a),setEnvStep(a,ATTACK)):envStep[a]!==IDLE&&envStep[a]!==REVERB&&envStep[a]!==DAMP&&setEnvStep(a,RELEASE)}function setLFOReset(a,b){b?(lfoStep[a]=0,lfoStepChangeClock[a]=0,0!==vibOffset[a]&&(vibOffset[a]=0,updateFrequency(a)),0!==amAtt[a]&&(amAtt[a]=0,updateDynamicLevel(a))):lfoStepChangeClock[a]=clock+lfoStepDur[a]}function startSample(a){samplePos[a]=0,phaseCounter[a]=0,sampleValue[a]=readSample(a,0),sampleValue2[a]=readSample(a,advancedSamplePos(a,0,1))}function advanceSample(a,b){var c=advancedSamplePos(a,samplePos[a],b);samplePos[a]=c,sampleValue[a]=readSample(a,c),sampleValue2[a]=readSample(a,advancedSamplePos(a,c,1))}function advancedSamplePos(a,b,c){var d=b+c;return d>endPosition[a]?loopPosition[a]+(d-endPosition[a])-1:d}function readSample(a,b){var c,d,e=startAddress[a],f=dataBits[a];return 1===f?(c=e+3*(b>>1),d=1&b?opl4.memoryRead(c+2)<<4|15&opl4.memoryRead(c+1):opl4.memoryRead(c)<<4|opl4.memoryRead(c+1)>>4,d=d<<4|(2047&d)>>7):2===f?(c=e+(b<<1),d=opl4.memoryRead(c)<<8|opl4.memoryRead(c+1)):0===f?(c=e+b,d=opl4.memoryRead(c),d=d<<8|(127&d)<<1):d=0,32768&d?d-65536:d}function setEnvStep(a,b){var c,d;switch(b){case ATTACK:d=0===ar[a]?0:ar[a]+rcOffset[a];break;case DECAY1:if(envAtt[a]=0,0===(c=dl[a]))return setEnvStep(a,DECAY2);d=0===d1r[a]?0:d1r[a]+rcOffset[a],reverb[a]&&c>=REVERB_ENV_LEVEL?(envStepNextAtLevel[a]=REVERB_ENV_LEVEL,envStepNext[a]=REVERB):(envStepNextAtLevel[a]=c,envStepNext[a]=DECAY2);break;case DECAY2:d=0===d2r[a]?0:d2r[a]+rcOffset[a],reverb[a]&&envAtt[a]<REVERB_ENV_LEVEL?(envStepNextAtLevel[a]=REVERB_ENV_LEVEL,envStepNext[a]=REVERB):(envStepNextAtLevel[a]=512,envStepNext[a]=IDLE);break;case RELEASE:if(d=0===rr[a]?0:rr[a]+rcOffset[a],reverb[a]){if(!(envAtt[a]<REVERB_ENV_LEVEL))return setEnvStep(a,REVERB);envStepNextAtLevel[a]=REVERB_ENV_LEVEL,envStepNext[a]=REVERB}else envStepNextAtLevel[a]=512,envStepNext[a]=IDLE;break;case REVERB:d=REVERB_RATE,envStepNextAtLevel[a]=512,envStepNext[a]=IDLE;break;case DAMP:d=DAMP_RATE,envStepNextAtLevel[a]=512,envStepNext[a]=IDLE;break;case IDLE:default:d=0,envAtt[a]=512,envStepNextAtLevel[a]=1024,envStepNext[a]=IDLE}envStep[a]=b,envStepRate[a]=d,envStepLevelDur[a]=d<4?0:d>=52?1:1<<13-(d>>2),envStepLevelChangeClock[a]=clock+envStepLevelDur[a],envStepLevelPattCounter[a]=0,updateDynamicLevel(a)}function updateFrequency(a){phaseInc[a]=(1024+fNum[a]<<8)+256*vibOffset[a]>>8-octave[a]+1,updateRateCorrOffset(a)}function updateRateCorrOffset(a){if(15===rc[a])return rcOffset[a]=0;var b=(rc[a]+octave[a]<<1)+(fNum[a]>>9);rcOffset[a]=b>=0?b:0}function updateSettingsAttenuation(a){settingsAttL[a]=volumeAtt[a]+panpotAttL[a]+mixerAttL,settingsAttR[a]=volumeAtt[a]+panpotAttR[a]+mixerAttR,updateDynamicLevel(a)}function updateDynamicLevel(a){var b=amAtt[a]+envAtt[a];dynamicLevelL[a]=volumeTable[b+settingsAttL[a]],dynamicLevelR[a]=volumeTable[b+settingsAttR[a]]}var self=this;this.connect=function(a){a.bus.connectOutputDevice(126,this.output7E),a.bus.connectInputDevice(127,this.input7F),a.bus.connectOutputDevice(127,this.output7F)},this.disconnect=function(a){a.bus.disconnectOutputDevice(126,this.output7E),a.bus.disconnectInputDevice(127,this.input7F),a.bus.disconnectOutputDevice(127,this.output7F)},this.reset=function(){clock=0,memoryAddress=0,registerAddress=0,wmsx.Util.arrayFill(register,0),register[2]=34,register[248]=27,register[0]=register[1]=register[7]=register[250]=register[251]=register[252]=register[253]=register[254]=register[255]=255,wmsx.Util.arrayFill(dataBits,0),wmsx.Util.arrayFill(startAddress,0),wmsx.Util.arrayFill(loopPosition,0),wmsx.Util.arrayFill(endPosition,0),wmsx.Util.arrayFill(phaseInc,512),wmsx.Util.arrayFill(fNum,0),wmsx.Util.arrayFill(octave,0),wmsx.Util.arrayFill(reverb,0),wmsx.Util.arrayFill(ar,0),wmsx.Util.arrayFill(d1r,0),wmsx.Util.arrayFill(dl,0),wmsx.Util.arrayFill(d2r,0),wmsx.Util.arrayFill(rr,0),wmsx.Util.arrayFill(rc,0),wmsx.Util.arrayFill(rcOffset,0),wmsx.Util.arrayFill(lfoStepDur,0),wmsx.Util.arrayFill(vibDepth,0),wmsx.Util.arrayFill(amDepth,0),wmsx.Util.arrayFill(volumeAtt,0),wmsx.Util.arrayFill(panpotAttL,0),wmsx.Util.arrayFill(panpotAttR,0),mixerAttL=0,mixerAttR=0,wmsx.Util.arrayFill(samplePos,0),wmsx.Util.arrayFill(sampleValue,0),wmsx.Util.arrayFill(sampleValue2,0),wmsx.Util.arrayFill(phaseCounter,0),wmsx.Util.arrayFill(envStep,IDLE),wmsx.Util.arrayFill(envStepNext,IDLE),wmsx.Util.arrayFill(envStepNextAtLevel,0),wmsx.Util.arrayFill(envStepRate,0),wmsx.Util.arrayFill(envStepLevelDur,0),wmsx.Util.arrayFill(envStepLevelChangeClock,0),wmsx.Util.arrayFill(envStepLevelPattCounter,0),wmsx.Util.arrayFill(envAtt,512),wmsx.Util.arrayFill(lfoStep,0),wmsx.Util.arrayFill(lfoStepChangeClock,0),wmsx.Util.arrayFill(vibOffset,0),wmsx.Util.arrayFill(amAtt,0),wmsx.Util.arrayFill(settingsAttL,0),wmsx.Util.arrayFill(settingsAttR,0),wmsx.Util.arrayFill(dynamicLevelL,0),wmsx.Util.arrayFill(dynamicLevelR,0)},this.output7E=function(a){registerAddress=a},this.input7F=function(){return registerRead(registerAddress)},this.output7F=function(a){registerWrite(registerAddress,a)},this.nextSample=function(){var a,b,c,d,e,f=0,g=0,h=0;for(++clock,e=23;e>=0;--e)a=clockLFO(e),a>=0&&(vibDepth[e]&&updateVIBOffset(e,a),amDepth[e]&&updateAMAttenuation(e,a)),envStep[e]!==IDLE&&(clockEnvelope(e),b=phaseCounter[e],c=phaseCounter[e]=b+phaseInc[e]&2147483647,d=(c>>10)-(b>>10),d>0&&advanceSample(e,d),f=sampleValue[e]*(1024-(1023&c))+sampleValue2[e]*(1023&c)>>10,g+=f*dynamicLevelL[e],h+=f*dynamicLevelR[e]);return sampleResult[0]=g,sampleResult[1]=h,sampleResult}
;var memoryAddress,registerAddress,register=new Array(255),clock,dataBits=new Array(24),startAddress=new Array(24),loopPosition=new Array(24),endPosition=new Array(24),samplePos=new Array(24),sampleValue=new Array(24),sampleValue2=new Array(24),phaseInc=new Array(24),phaseCounter=new Array(24),fNum=new Array(24),octave=new Array(24),reverb=new Array(24),ar=new Array(24),d1r=new Array(24),dl=new Array(24),d2r=new Array(24),rc=new Array(24),rr=new Array(24),rcOffset=new Array(24),lfoStepDur=new Array(24),vibDepth=new Array(24),amDepth=new Array(24),volumeAtt=new Array(24),panpotAttL=new Array(24),panpotAttR=new Array(24),mixerAttL=0,mixerAttR=0,settingsAttL=new Array(24),settingsAttR=new Array(24),envStep=new Array(24),envStepNext=new Array(24),envStepNextAtLevel=new Array(24),envStepRate=new Array(24),envStepLevelDur=new Array(24),envStepLevelChangeClock=new Array(24),envStepLevelPattCounter=new Array(24),envAtt=new Array(24),lfoStep=new Array(24),lfoStepChangeClock=new Array(24),vibOffset=new Array(24),amAtt=new Array(24),dynamicLevelL=new Array(24),dynamicLevelR=new Array(24),IDLE=255,ATTACK=1,DECAY1=2,DECAY2=3,RELEASE=4,REVERB=5,DAMP=6,REVERB_ENV_LEVEL=96,REVERB_RATE=20,DAMP_RATE=60,regWriteMasks,rateAttackPatterns,rateDecayPatterns,lfoStepClocks,vibStepOffsets,amStepOffsets,panpotValues,volumeTable,sampleResult=[0,0];this.saveState=function(){return{c:clock,ra:registerAddress,ma:memoryAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),db:wmsx.Util.storeInt8BitArrayToStringBase64(dataBits),sa:wmsx.Util.storeInt32BitArrayToStringBase64(startAddress),lp:wmsx.Util.storeInt16BitArrayToStringBase64(loopPosition),ep:wmsx.Util.storeInt16BitArrayToStringBase64(endPosition),sp:wmsx.Util.storeInt16BitArrayToStringBase64(samplePos),sv:wmsx.Util.storeInt16BitArrayToStringBase64(sampleValue),pc:wmsx.Util.storeInt32BitArrayToStringBase64(phaseCounter),evs:wmsx.Util.storeInt8BitArrayToStringBase64(envStep),evr:wmsx.Util.storeInt8BitArrayToStringBase64(envStepRate),evd:wmsx.Util.storeInt32BitArrayToStringBase64(envStepLevelDur),evc:envStepLevelChangeClock,evn:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNext),evl:wmsx.Util.storeInt16BitArrayToStringBase64(envStepNextAtLevel),epc:wmsx.Util.storeInt8BitArrayToStringBase64(envStepLevelPattCounter),eva:wmsx.Util.storeInt16BitArrayToStringBase64(envAtt),lfs:wmsx.Util.storeInt8BitArrayToStringBase64(lfoStep),lfc:lfoStepChangeClock,vio:wmsx.Util.storeInt8BitArrayToStringBase64(vibOffset),ama:wmsx.Util.storeInt8BitArrayToStringBase64(amAtt),saL:wmsx.Util.storeInt16BitArrayToStringBase64(settingsAttL),saR:wmsx.Util.storeInt16BitArrayToStringBase64(settingsAttR),dlvL:dynamicLevelL,dlvR:dynamicLevelR}},this.loadState=function(a){this.reset(),registerAddress=a.ra;for(var b=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r),c=2;c<6;c++)registerWrite(c,b[c]);for(c=8;c<32;c++)register[c]=b[c];for(c=32;c<250;c++)registerWrite(c,b[c]);memoryAddress=a.ma,clock=a.c,dataBits=wmsx.Util.restoreStringBase64ToInt8BitArray(a.db,dataBits),startAddress=wmsx.Util.restoreStringBase64ToInt32BitArray(a.sa,startAddress),loopPosition=wmsx.Util.restoreStringBase64ToInt16BitArray(a.lp,loopPosition),endPosition=wmsx.Util.restoreStringBase64ToInt16BitArray(a.ep,endPosition),phaseCounter=wmsx.Util.restoreStringBase64ToInt32BitArray(a.pc,phaseCounter),samplePos=wmsx.Util.restoreStringBase64ToInt16BitArray(a.sp,samplePos),sampleValue=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.sv,sampleValue),envStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evs,envStep),envStepRate=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evr,envStepRate),envStepLevelDur=wmsx.Util.restoreStringBase64ToInt32BitArray(a.evd,envStepLevelDur),envStepLevelChangeClock=a.evc,envStepNext=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evn,envStepNext),envStepNextAtLevel=wmsx.Util.restoreStringBase64ToInt16BitArray(a.evl,envStepNextAtLevel),envStepLevelPattCounter=wmsx.Util.restoreStringBase64ToInt16BitArray(a.epc,envStepLevelPattCounter),envAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.eva,envAtt),lfoStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.lfs,lfoStep),lfoStepChangeClock=a.lfc,vibOffset=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.vio,vibOffset),amAtt=wmsx.Util.restoreStringBase64ToInt8BitArray(a.ama,amAtt),settingsAttL=wmsx.Util.restoreStringBase64ToInt16BitArray(a.saL,settingsAttL),settingsAttR=wmsx.Util.restoreStringBase64ToInt16BitArray(a.saR,settingsAttR),dynamicLevelL=a.dlvL,dynamicLevelR=a.dlvR},init(),this.eval=function(str){return eval(str)}},wmsx.RTC=function(a){"use strict";function b(a){j!==a&&(a?(d(),j=!0):(j=!1,c()))}function c(){i||(i=new Date(Math.floor(h))),l[0]=i.getUTCSeconds()%10,l[1]=i.getUTCSeconds()/10|0,l[2]=i.getUTCMinutes()%10,l[3]=i.getUTCMinutes()/10|0,m[10]?(l[4]=i.getUTCHours()%10,l[5]=i.getUTCHours()/10|0):(l[4]=i.getUTCHours()%12%10,l[5]=i.getUTCHours()%12/10|0,i.getUTCHours()>=12&&(l[5]|=2)),l[6]=i.getUTCDay()+1,l[7]=i.getUTCDate()%10,l[8]=i.getUTCDate()/10|0,l[9]=(i.getUTCMonth()+1)%10,l[10]=(i.getUTCMonth()+1)/10|0,l[11]=(i.getUTCFullYear()-1980)%10,l[12]=(i.getUTCFullYear()-1980)/10|0}function d(){i||(i=new Date),i.setUTCSeconds(l[0]+10*l[1]),i.setUTCMinutes(l[2]+10*l[3]),1&m[10]?i.setUTCHours(l[4]+10*l[5]):i.setUTCHours(l[4]+(2&l[5]?12:0)+(1&l[5]?10:0)),i.setUTCDate(l[7]+10*l[8]),i.setUTCMonth(l[9]+10*l[10]-1),i.setUTCFullYear(l[11]+10*l[12]+1980),h=i.getTime()}function e(a){if(a&=1,(1&m[10])!==a){var b;a?(b=l[4]+(2&l[5]?12:0)+(1&l[5]?10:0),l[5]=b/10|0,l[4]=b%10):(b=l[4]+10*l[5],l[5]=(b>=12?2:0)|(b%12>=10?1:0),l[4]=b%12%10)}}this.setMachineType=function(a){f=WMSX.RTC_ACTIVE>=0?!!WMSX.RTC_ACTIVE:a>=2,f&&wmsx.Util.arrayFill(n[0],0),wmsx.Util.arrayFill(n[1],0)},this.connectBus=function(a){a.connectInputDevice(180,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(180,this.outputB4),a.connectInputDevice(181,this.inputB5),a.connectOutputDevice(181,this.outputB5)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.reset=function(){g=0,b(!0)},this.videoClockPulse=function(){h+=k,i&&(i=void 0)},this.setFps=function(a){k=1e3/a},this.syncTimeWithSource=function(){var b=a.getRealTime();b<=h||(h=b,j||c())},this.outputB4=function(a){f&&(o=15&a)},this.outputB5=function(a){if(f)if(a&=15,o<13)switch(g){case 0:l[o]=a&p[o];break;case 1:10===o&&e(a),m[o]=a&q[o];break;case 2:case 3:n[1&g][o]=a}else switch(o){case 13:g=3&a,b(0!=(8&a))}},this.inputB5=function(){if(!f)return 255;var a;if(o<13)switch(g){case 0:j&&c(),a=l[o];break;case 1:a=m[o];break;case 2:case 3:a=n[1&g][o]}else switch(o){case 13:a=(j?8:0)|g;break;case 14:case 15:a=15}return a};var f,g=0,h=0,i=void 0,j=!0,k=1e3/60,l=wmsx.Util.arrayFill(new Array(13),0),m=wmsx.Util.arrayFill(new Array(13),0),n=[new Array(13),new Array(13)],o=0,p=[15,7,15,7,15,3,7,15,3,15,1,15,15],q=[0,0,15,7,15,3,7,15,3,0,1,3,0];this.saveState=function(){return{a:f,m:g,i:h,c:j,rc:wmsx.Util.storeInt8BitArrayToStringBase64(l),rm:wmsx.Util.storeInt8BitArrayToStringBase64(m),r0:wmsx.Util.storeInt8BitArrayToStringBase64(n[0]),r1:wmsx.Util.storeInt8BitArrayToStringBase64(n[1]),ra:o}},this.loadState=function(a){f=void 0!==a.a?a.a:a.m2,g=a.m,j=a.c,h=a.i?a.i:a.co+a.t,i=void 0,l=wmsx.Util.restoreStringBase64ToInt8BitArray(a.rc,l),m=wmsx.Util.restoreStringBase64ToInt8BitArray(a.rm,m),n[0]=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r0,n[0]),n[1]=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r1,n[1]),o=a.ra}},wmsx.SystemFlags=function(){"use strict";this.setMachineType=function(b){a=b>=3},this.connectBus=function(a){a.connectInputDevice(243,this.inputF3),a.connectOutputDevice(243,this.outputF3),a.connectInputDevice(244,this.inputF4),a.connectOutputDevice(244,this.outputF4),a.connectInputDevice(245,wmsx.DeviceMissing.outputPortIgnored),a.connectOutputDevice(245,wmsx.DeviceMissing.outputPortIgnored),a.connectInputDevice(246,wmsx.DeviceMissing.inputPortIgnored),
a.connectOutputDevice(246,wmsx.DeviceMissing.outputPortIgnored),a.connectInputDevice(247,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(247,wmsx.DeviceMissing.outputPortIgnored),a.connectInputDevice(248,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(248,wmsx.DeviceMissing.outputPortIgnored)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.reset=function(){b=d,c=e},this.inputF3=function(){return a?c:255},this.outputF3=function(b){a&&(c=b)},this.inputF4=function(){return a?b:255},this.outputF4=function(c){a&&(b=c)};var a,b,c,d=255,e=0;this.saveState=function(){return{a:a,bf:b,vf:c}},this.loadState=function(d){a=void 0!==d.a?d.a:d.m2p,b=d.bf,c=d.vf}},wmsx.ImageCassetteDriver=function(){"use strict";function a(a){return l.motor(!0),l.readHeader()?h(a,o):i(a)}function b(a){var b=l.readByte();if(null===b)return i(a);var c=h(a,p);return c.A=b,c}function c(){l.motor(!1)}function d(a,b){return l.motor(!0),l.writeHeader(a)?h(b,a?m:n):i(b)}function e(a,b){return l.writeByte(a)?h(b,p):i(b)}function f(){l.finishWriting(),l.motor(!1)}function g(a){l.motor(255===a?null:a>0)}function h(a,b){return{F:254&a,extraIterations:b}}function i(a){return{F:a|=1}}var j=this;this.connect=function(a,b){b.getCassetteSocket().connectDriver(this),l=b.getCassetteSocket().getDeck(),k=a.getKeyboardExtension()},this.disconnect=function(a,b){b.getCassetteSocket().connectDriver(null)},this.powerOff=function(){l&&l.motor(!1)},this.typeCurrentAutoRunCommand=function(){var a=j.currentAutoRunCommand();a&&k.typeString(a)},this.currentAutoRunCommand=function(){var a=l.peekFileInfoAtCurrentPosition();if(!a)return null;switch(a.type){case"Binary":return'\r\r\rbload "cas:'+a.name+'", r\r';case"Basic":return'\r\r\rcload "'+a.name+'"\rrun\r';case"ASCII":return'\r\r\rrun "cas:'+a.name+'"\r'}return null},this.cpuExtensionBegin=function(h){switch(h.extNum){case 224:return a(h.F);case 225:return b(h.F);case 226:return c();case 227:return d(h.A,h.F);case 228:return e(h.A,h.F);case 229:return f();case 230:return g(h.A)}},this.cpuExtensionFinish=function(a){},this.patchBIOS=function(a){a[225]=237,a[226]=224,a[227]=201,a[228]=237,a[229]=225,a[230]=201,a[231]=237,a[232]=226,a[233]=201,a[234]=237,a[235]=227,a[236]=201,a[237]=237,a[238]=228,a[239]=201,a[240]=237,a[241]=229,a[242]=201,a[243]=237,a[244]=230,a[245]=201};var k,l,m=3e5,n=m/3,o=.4*n,p=10},wmsx.TurboDriver=function(){"use strict";function a(){var a=f.bytes;237!==a[400]&&(a[384]=195,a[385]=141,a[386]=1,a[387]=195,a[388]=144,a[389]=1,a[397]=237,a[398]=232,a[399]=201,a[400]=237,a[401]=233,a[402]=201)}function b(){var a=f.bytes;237===a[400]&&(a[384]=a[387]=a[397]=a[400]=201)}function c(a){i=131&a;var b=(3&i)>0;j!==b&&(j=b,0===h.getCPUTurboMode()?(e.turboModesUpdate(),h.showCPUTurboModeMessage()):h.showOSD("Could not set CPU Turbo by software: mode is FORCED "+h.getCPUTurboModeDesc(),!0,!0))}function d(){return{A:i}}var e=this;this.connect=function(a,b){f=a,g=b.getBIOSSocket(),h=b,this.turboModesUpdate()},this.reset=function(){i=0,j&&(j=!1,this.turboModesUpdate())},this.turboModesUpdate=function(){var c=h.machineType>=2,d=h.getCPUTurboMode(),e=h.getVDPTurboMode();d<0||!c?b():a(),h.cpu.setCPUTurboMulti(0===d&&c&&j?WMSX.CPU_SOFT_TURBO_MULTI:d<=0?1:d),h.vdp.setVDPTurboMulti(0===e&&c&&j?WMSX.VDP_SOFT_TURBO_MULTI:e>1?e:1),g.fireMachineTurboModesStateUpdate()},this.cpuExtensionBegin=function(a){if(!(h.machineType<=1))switch(a.extNum){case 232:return c(a.A);case 233:return d()}},this.cpuExtensionFinish=function(a){},this.saveState=function(){return{st:j,cv:i}},this.loadState=function(a){j=!!a&&a.st,i=a?a.cv:0};var f,g,h,i=0,j=!1},wmsx.BIOSKeyboardExtension=function(){"use strict";this.connect=function(b){a=b.bus},this.typeString=function(a){if(void 0!==a&&null!==a){var c=a.toString();c&&(c=c.replace(/\r\n/g,"\r").replace(/\n/g,"\r"),b=(b||"")+c)}},this.cancelTypeString=function(){b=null,c=0},this.keyboardExtensionClockPulse=function(){if(b){var h=a.read(e)|a.read(e+1)<<8;if(!(h<f||h>g)){var i=a.read(d)|a.read(d+1)<<8;if(!(i<f||i>g)){var j=h-i-1;if(j<0&&(j+=40),!(j<=0)){for(var k=b.substr(c,j),l=0;l<k.length;l++)a.write(i,255&k.charCodeAt(l)),++i>g&&(i=f);a.write(d,255&i),a.write(d+1,i>>8),c+=k.length,c>=b.length&&this.cancelTypeString()}}}}},this.saveState=function(){return{s:b&&btoa(b),p:c}},this.loadState=function(a){b=a.s&&atob(a.s),c=a.p};var a,b,c=0,d=62456,e=62458,f=64496,g=64535},wmsx.ImageDiskDriver=function(){"use strict";function a(a,b){return{HL:65280&b|(64&a?1:2)}}function b(a,b,e,f,g,h){return 1&a?d(a,b,e,f,g,h):c(a,b,e,f,g,h)}function c(a,b,c,d,e,f){var g=o.motorOn(b);return o.readSectorsToSlot(b,e,c,k(f),f)?{F:-2&a,B:0,extraIterations:g+c*u}:{F:1|a,A:2,B:c,extraIterations:g}}function d(a,b,c,d,e,f){var g=o.motorOn(b);return o.isDiskInserted(b)&&o.writeSectorsFromSlot(b,e,c,k(f),f)?{F:-2&a,B:0,extraIterations:g+c*u}:{F:1|a,A:2,B:c,extraIterations:g}}function e(a,b,c,d,e){var g=o.diskHasChanged(b);if(!1===g)return{F:-2&a,B:1};var h=o.motorOn(b),i=o.readByte(b,r);return null===i?{F:1|a,A:2,B:0,extraIterations:h}:(f(b,i,d,e),{F:-2&a,B:!0===g?255:0,extraIterations:h})}function f(a,b,c,d){var e=0===b?c:b;if(!(e<248)){j(o.MEDIA_TYPE_DPB[e],d+1)}}function g(){return{HL:t}}function h(a,b,c){var d=c>>>8,e=b-1;if(e<0||e>1||d<0||d>1)return{F:1|a,A:12};var f=o.FORMAT_OPTIONS_MEDIA_TYPES[e];return o.insertNewDisk(d,f,!1,!0),o.motorOn(d),o.formatCurrentDisk(d,f),{F:-2&a,extraIterations:v}}function i(){o.allMotorsOffNow()}function j(a,b){for(var c=k(b),d=0;d<a.length;d++)c.write(b+d,a[d])}function k(a){var b;if(a>=16384&&a<=32767){var c=p.read(62274);b=p.getSlot(3&c),0!=(128&c)&&b.isExpanded()&&(b=b.getSubSlot(c>>2&3))}else b=p.getSlotForAddress(a),b.isExpanded()&&(b=b.getSubSlotForAddress(a));return b}function l(a,b,c){delete q[b];var d=p.read(c+26),e=3&d,f=e<=1;return f&&(o.motorFlash(e),!o.isDiskInserted(e))?{F:1|a,A:26}:(p.write(c+0,f?1:0),p.write(c+1,130),p.write(c+12+0,0),p.write(c+12+1,0),p.write(c+12+2,0),p.write(c+12+3,0),p.write(c+28,9),p.write(c+29,0),p.write(c+30,2),q[b]=e,{F:-2&a})}function m(a,b,c,d,e,f){var g=q[b];return g>=0&&o.motorFlash(g),void 0!==g&&o.isDiskInserted(g)?o.readSectorsToSlot(g,(f<<16)+e,c,p,d)?{F:-2&a}:{F:1|a,A:6}:{F:1|a,A:26}}function n(a,b,c,d,e,f){var g=q[b];return g>=0&&o.motorFlash(g),void 0!==g&&o.isDiskInserted(g)?o.writeSectorsFromSlot(g,(f<<16)+e,c,p,d)?{F:-2&a}:{F:1|a,A:6}:{F:1|a,A:26}}this.connect=function(a,b){o=b.getDiskDriveSocket().getDrive(),p=b.bus,p.setCpuExtensionHandler(243,this),p.setCpuExtensionHandler(244,this),p.setCpuExtensionHandler(245,this)},this.disconnect=function(a,b){o.allMotorsOff(),p.setCpuExtensionHandler(243,void 0),p.setCpuExtensionHandler(244,void 0),p.setCpuExtensionHandler(245,void 0)},this.powerOff=function(){o.allMotorsOff()},this.cpuExtensionBegin=function(c){switch(c.extNum){case 232:return;case 233:return a(c.F,c.HL);case 234:return b(c.F,c.A,c.B,c.C,c.DE,c.HL);case 235:return e(c.F,c.A,c.B,c.C,c.HL);case 236:return f(c.A,c.B,c.C,c.HL);case 237:return g();case 238:return h(c.F,c.A,c.DE);case 239:return i();case 243:return m(c.F,c.C,c.B,c.HL,c.IX,c.IY);case 244:return n(c.F,c.C,c.B,c.HL,c.IX,c.IY);case 245:return l(c.F,c.C,c.HL)}},this.cpuExtensionFinish=function(a){o.allMotorsOff()},this.patchDiskBIOS=function(a,b){a[b+5999]=237,a[b+6e3]=232,a[b+6001]=0,a[b+6224]=237,a[b+6225]=233,a[b+6226]=0,a[b+16]=237,a[b+17]=234,a[b+18]=201,a[b+19]=237,a[b+20]=235,a[b+21]=201,a[b+22]=237,a[b+23]=236,a[b+24]=201,a[b+25]=237,a[b+26]=237,a[b+27]=201,a[b+28]=237,a[b+29]=238,a[b+30]=201,a[b+31]=237,a[b+32]=239,a[b+33]=201,wmsx.Util.arrayFill(a,255,b+16384);for(var c=0;c<s.length;c++)a[b+t-16384+c]=s.charCodeAt(c)},this.saveState=function(){return{sd:q}},this.loadState=function(a){q=void 0!==(a&&a.sd)?a.sd:{}}
;var o,p,q={},r=512,s="A new disk will be created.\r\nPlease choose format:\r\n1) 720KB, Double Sided\r\n2) 360KB, Single Sided\r\n\0",t=32832,u=5e3,v=2e6},wmsx.ImageNextorDeviceDriver=function(){"use strict";function a(){return{A:5,B:0,C:0}}function b(a,b,c){return{F:0,A:0,HL:0}}function c(a,b,c,f,g,h){return 1!==b||1!==f?{A:p,B:0}:(l.motorFlash(2),l.isDiskInserted(2)?1&a?e(a,b,c,f,g,h):d(a,b,c,f,g,h):{A:o,B:0})}function d(a,b,c,d,e,f){var g=m.read(e+0)|m.read(e+1)<<8|m.read(e+2)<<16|m.read(e+3)<<24;return l.readSectorsToSlot(2,g,c,m,f)?{A:0}:{A:o,B:0}}function e(a,b,c,d,e,f){var g=m.read(e)|m.read(e+1)<<8|m.read(e+2)<<16|m.read(e+3)<<24;return l.writeSectorsFromSlot(2,g,c,m,f)?{A:0}:{A:o,B:0}}function f(a,b,c){if(1!==a)return{A:1};if(0===b)return m.write(c,1),m.write(c+1,0),{A:0};if(1===b){for(var d="WebMSX                                                                   ",e=0;e<64;++e)m.write(c+e,d.charCodeAt(e));return{A:0}}if(2===b){for(d="WebMSX Removable Hard Disk                                                   ",e=0;e<64;++e)m.write(c+e,d.charCodeAt(e));return{A:0}}return{A:1}}function g(a,b){if(1!==a||1!==b)return{A:0};var c=l.diskHasChanged(2);return{A:null===c?3:c?2:1}}function h(a,b,c){if(1!==a||1!==b)return{A:1};for(var d=l.getTotalSectorsAvailable(2)||0,e=[0,0,2,255&d,d>>8&255,d>>16&255,d>>24&255,1,0,0,0,0],f=0;f<12;++f)m.write(c+f,e[f]);return{A:0}}function i(a,b,c){delete n[b];var d=m.read(c+26),e=d>>4,f=15&d,g=0===e,h=0;if(g){if(l.motorFlash(2),!l.isDiskInserted(2))return{F:1|a,A:26};var i=l.readByte(2,510)<<8|l.readByte(2,511);if(null===i)return{F:1|a,A:26};var j=21930===i;if(f>0){if(!j)return{F:1|a,A:4};var k=446+16*(f-1),o=l.readByte(2,k+4);if(h=l.readDWord(2,k+8),null===o||null===h)return{F:1|a,A:26};if(!h||!o)return{F:1|a,A:4}}else if(j)return{F:1|a,A:4}}return m.write(c+0,g?1:0),m.write(c+1,145),m.write(c+12+0,255&h),m.write(c+12+1,h>>8&255),m.write(c+12+2,h>>16&255),m.write(c+12+3,h>>24&255),m.write(c+31,0),n[b]=h,{F:-2&a}}function j(a,b,c,d,e,f){var g=n[b];return g>=0&&l.motorFlash(2),void 0!==g&&l.isDiskInserted(2)?l.readSectorsToSlot(2,g+(f<<16)+e,c,m,d)?{F:-2&a}:{F:1|a,A:9}:{F:1|a,A:26}}function k(a,b,c,d,e,f){var g=n[b];return g>=0&&l.motorFlash(2),void 0!==g&&l.isDiskInserted(2)?l.writeSectorsFromSlot(2,g+(f<<16)+e,c,m,d)?{F:-2&a}:{F:1|a,A:9}:{F:1|a,A:26}}this.connect=function(a,b){l=b.getDiskDriveSocket().getDrive(),m=b.bus,m.setCpuExtensionHandler(240,this),m.setCpuExtensionHandler(241,this),m.setCpuExtensionHandler(242,this)},this.disconnect=function(a,b){b.bus.setCpuExtensionHandler(240,void 0),b.bus.setCpuExtensionHandler(241,void 0),b.bus.setCpuExtensionHandler(242,void 0)},this.powerOff=function(){},this.cpuExtensionBegin=function(d){switch(d.extNum){case 224:return a();case 225:return b(d.A,d.B,d.HL);case 232:return c(d.F,d.A,d.B,d.C,d.DE,d.HL);case 233:return f(d.A,d.B,d.HL);case 234:return g(d.A,d.B);case 235:return h(d.A,d.B,d.HL);case 240:return j(d.F,d.C,d.B,d.HL,d.IX,d.IY);case 241:return k(d.F,d.C,d.B,d.HL,d.IX,d.IY);case 242:return i(d.F,d.C,d.HL)}},this.cpuExtensionFinish=function(a){},this.patchNextorKernel=function(a){a[114958]=1;for(var b="WebMSX Nextor Device Driver     ",c=0;c<32;++c)a[114960+c]=b.charCodeAt(c);for(a[114992]=201,a[114993]=201,a[114994]=201,a[114995]=237,a[114996]=224,a[114997]=201,a[114998]=237,a[114999]=225,a[115e3]=201,a[115001]=55,a[115002]=201,a[115003]=201,a[115004]=55,a[115005]=201,a[115006]=201,a[115007]=201,a[115008]=201,a[115009]=201,c=115010;c<115026;++c)a[c]=201;a[115040]=237,a[115041]=232,a[115042]=201,a[115043]=237,a[115044]=233,a[115045]=201,a[115046]=237,a[115047]=234,a[115048]=201,a[115049]=237,a[115050]=235,a[115051]=201},this.saveState=function(){return{so:n}},this.loadState=function(a){n=void 0!==(a&&a.so)?a.so:{}};var l,m,n={},o=252,p=181},wmsx.ROM=function(a,b,c,d){"use strict";this.source=wmsx.Util.leafFilename(a),this.content=b,this.info=c||wmsx.SlotCreator.produceInfo(this,d),this.saveState=function(){return{s:this.source,i:this.info}},this.reloadEmbeddedContent=function(){if(!this.content&&wmsx.EmbeddedFiles.isEmbeddedURL(this.source)){var a=wmsx.EmbeddedFiles.get(this.source);this.content=a&&a.content}}},wmsx.ROM.loadState=function(a){return new wmsx.ROM(a.s,null,a.i)},wmsx.ROMDatabase={uncompress:function(){wmsx.ROMDatabase=JSON.parse(wmsx.Util.uncompressStringBase64ToString(this.data))},
data:"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"
},wmsx.SlotCreator=function(){"use strict";function a(a,b){var c,d=[];for(var e in wmsx.SlotFormats)c=wmsx.SlotFormats[e],c.prioritySelected=c.priorityForRom(a,b),c.prioritySelected&&(f(c,a.info),c.prioritySelected>=j||d.push(c));return d.sort(function(a,b){return a.prioritySelected-b.prioritySelected}),d}function b(a){var b={};return a.n&&(b.n=a.n),a.h&&(b.h=a.h),a.f&&(b.f=a.f),a.t&&(b.t=a.t),a.l&&(b.l=a.l),a.e&&(b.e=a.e),b}this.createFromROM=function(a,b){var d=c.getForROM(a);if(d){var e=wmsx.SlotFormats[d];if(e.priorityForRom(a))return wmsx.Util.log("USER Format selected: "+e.desc),e.createFromROM(a)}var f=this.getBestFormatOption(a,b);if(f){return wmsx.EmbeddedFiles.isEmbeddedURL(a.source)||wmsx.Util.log("AUTO Format selected: "+f.desc+", priority: "+f.prioritySelected),f.createFromROM(a)}},this.recreateFromSaveState=function(a,b){var c=wmsx.SlotFormats[a.f];if(!c)throw new Error("Unsupported ROM Format in Savestate: "+a.f);return b&&b.format!==c&&(b=null),c.recreateFromSaveState(a,b)},this.changeCartridgeFormat=function(a,b){return b.createFromROM(a.rom)},this.getBestFormatOption=function(b,c){var d=a(b,c);return 0===d.length?void 0:d[0]},this.getUserFormatOptionNames=function(a){for(var b=[],c=0,d=wmsx.SlotFormatsUserOptions.length;c<d;++c){var e=wmsx.SlotFormatsUserOptions[c];wmsx.SlotFormats[e].priorityForRom(a)&&b.push(e)}return b},this.produceInfo=function(a,c){var f=a.content.length,g=a.content.length>m?void 0:wmsx.Util.sha1Generator.calcSHA1FromByteArray(a.content).toUpperCase();a.content.length>f&&(a.content.length=f);var h=wmsx.ROMDatabase[g],i=wmsx.EmbeddedFiles.isEmbeddedURL(a.source);return h?(h=b(h),i||wmsx.Util.log("ROM: "+h.n+(h.f?", format: "+h.f:"")+" ("+g+")")):(h=d(a.source),i||wmsx.Util.log("ROM: "+(f>0?"Unknown content":"No content")+", "+h.n+(h.f?", format: "+h.f:"")+(g?" ("+g+")":" (no hash computed)"))),e(h,a.source,g,c),h},this.setUserROMFormats=function(a){c=a};var c,d=function(a){var b={n:"Unknown"};return a?(b.n=wmsx.Util.leafFilenameNoExtension(a)||"Unknown",b):b},e=function(a,b,c,d){if(a.h=c,d){d=d.trim().toUpperCase();for(var e in wmsx.SlotFormats)if(e.toUpperCase()===d){a.f=wmsx.SlotFormats[e].name,a.t=!0;break}}if(!a.t){var f=b.toUpperCase();for(e in wmsx.SlotFormats)if(g(e.toUpperCase(),f)){a.f=wmsx.SlotFormats[e].name,a.t=!0;break}}},f=function(a,b){b.f&&a.name===b.f&&(a.prioritySelected-=b.t?l:k)},g=function(a,b){return b.match(h+a+i)},h="\\[",i="\\]",j=1e3,k=1e3,l=5e3,m=1024*(WMSX.ROM_MAX_HASH_SIZE_KB||3072);this.FORMAT_PRIORITY_BOOST=k},wmsx.SlotCreator=new wmsx.SlotCreator,wmsx.SlotFormats={Empty:{name:"Empty",desc:"Empty Slot",priority:1001,internal:!0,embeddedURL:"@[Empty].rom",priorityForRom:function(a){return a&&a.content&&0!==a.content.length?null:this.priority},createFromROM:function(a){return wmsx.SlotEmpty.singleton},recreateFromSaveState:function(a,b){return wmsx.SlotEmpty.singleton}},Expanded:{name:"Expanded",desc:"Expanded Slot",priority:1002,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpanded.recreateFromSaveState(a,b)}},ExpandedS:{name:"ExpandedS",desc:"Special System Expanded Slot",priority:1003,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpandedSpecial.recreateFromSaveState(a,b)}},ExpandedM:{name:"ExpandedM",desc:"Special System Expanded Slot for Modules (Device-only Slots)",priority:1004,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpandedModules.recreateFromSaveState(a,b)}},BIOS:{name:"BIOS",desc:"Main BIOS",priority:201,internal:!0,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=65536&&243===a.content[0]&&(195===a.content[1]||24===a.content[1])?this.priority:null},createFromROM:function(a){return new wmsx.SlotBIOS(a)},recreateFromSaveState:function(a,b){return wmsx.SlotBIOS.recreateFromSaveState(a,b)}},MSX2BIOSExt:{name:"MSX2BIOSExt",desc:"MSX2/2+ BIOS Extension",priority:202,internal:!0,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=65536&&67===a.content[0]&&68===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.SlotMSX2BIOSExt(a)},recreateFromSaveState:function(a,b){return wmsx.SlotMSX2BIOSExt.recreateFromSaveState(a,b)}},RAMNormal:{name:"RAMNormal",desc:"Normal RAM (unmapped)",priority:1011,internal:!0,embeddedURL:"@[RAMNormal].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.SlotRAMNormal(a)},recreateFromSaveState:function(a,b){return wmsx.SlotRAMNormal.recreateFromSaveState(a,b)}},RAMMapper:{name:"RAMMapper",desc:"Standard RAM Mapper",priority:1012,internal:!0,embeddedURL:"@[RAMMapper].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.SlotRAMMapper(a)},recreateFromSaveState:function(a,b){return wmsx.SlotRAMMapper.recreateFromSaveState(a,b)}},DiskPatch:{name:"DiskPatch",desc:"Generic Patched Disk BIOS",priority:1301,internal:!0,embeddedURL:"@[DiskPatch].rom",priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=65536?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDiskPatched(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDiskPatched.recreateFromSaveState(a,b)}},Nextor16Patch:{name:"Nextor16Patch",desc:"Nextor ASCII-16 Patched Kernel",priority:1302,internal:!0,embeddedURL:"@[Nextor16Patch].rom",priorityForRom:function(a){return 131072===a.content.length&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeNextorPatched(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeNextorPatched.recreateFromSaveState(a,b)}},SCCExpansion:{name:"SCCExpansion",desc:"Konami SCC Sound Cartridge",priority:1501,internal:!0,embeddedURL:"@[SCCExpansion].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSCCExpansion(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSCCExpansion.recreateFromSaveState(a,b)}},SCCIExpansion:{name:"SCCIExpansion",desc:"Konami SCC+ Sound Mapper Cartridge",priority:1502,internal:!0,embeddedURL:"@[SCCIExpansion].rom",priorityForRom:function(a){return a.content.length<=131072?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSCCIExpansion(a,this,!1)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSCCIExpansion.recreateFromSaveState(a,b)}},MSXMUSIC:{name:"MSXMUSIC",desc:"MSX-MUSIC Sound Extension",priority:1503,internal:!0,embeddedURL:"@[MSXMUSIC].rom",priorityForRom:function(a){return 16384===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMSXMUSIC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMSXMUSIC.recreateFromSaveState(a,b)}},PACExpansion:{name:"PACExpansion",desc:"PAC SRAM Cartridge",priority:1505,internal:!0,embeddedURL:"@[PACExpansion].rom",priorityForRom:function(a,b){return 0===a.content.length?this.priority:!wmsx.CartridgePAC.isPACFileContentValid(a.content)||b&&b.format!==wmsx.SlotFormats.PACExpansion&&b.format!==wmsx.SlotFormats.FMPAC?null:this.priority-wmsx.SlotCreator.FORMAT_PRIORITY_BOOST},createFromROM:function(a){return new wmsx.CartridgePAC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgePAC.recreateFromSaveState(a,b)}},Kanji1:{name:"Kanji1",desc:"Kanji Font Driver",priority:1506,internal:!0,embeddedURL:"@[Kanji1].rom",priorityForRom:function(a){return 131072===a.content.length||262144===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKanjiFont(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKanjiFont.recreateFromSaveState(a,b)}},MoonSound:{
name:"MoonSound",desc:"MoonSound OPL4 Sound Cartridge",priority:1507,internal:!0,embeddedURL:"@[MoonSound].rom",priorityForRom:function(a){return 2097152===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMoonSound(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMoonSound.recreateFromSaveState(a,b)}},ExtraPSG:{name:"ExtraPSG",desc:"Extra PSG Sound Chip",priority:1508,internal:!0,embeddedURL:"@[ExtraPSG].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeExtraPSG(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeExtraPSG.recreateFromSaveState(a,b)}},MegaRAM:{name:"MegaRAM",desc:"MegaRAM Mapper Cartridge",priority:1509,internal:!0,embeddedURL:"@[MegaRAM].rom",priorityForRom:function(a){return a.content.length<=2097152?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMegaRAM(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMegaRAM.recreateFromSaveState(a,b)}},Normal:{name:"Normal",desc:"Normal ROM, Mirroring Auto",priority:901,priorityForRom:function(a){return 8192!==a.content.length&&16384!==a.content.length||65!==a.content[0]||66!==a.content[1]?32768===a.content.length&&(65===a.content[0]&&66===a.content[1]||65===a.content[16384]&&66===a.content[16385])?this.priority:65536!==a.content.length&&49152!==a.content.length||!(65===a.content[16384]&&66===a.content[16385]||65===a.content[32768]&&66===a.content[32769])?null:this.priority:this.priority},createFromROM:function(a){return new wmsx.SlotNormal(a,this)},recreateFromSaveState:function(a,b){return wmsx.SlotNormal.recreateFromSaveState(a,b)}},Mirrored:{name:"Mirrored",desc:"Normal ROM, Mirrored",priority:902,priorityForRom:function(a){return wmsx.SlotFormats.Normal.priorityForRom(a)},createFromROM:function(a){return new wmsx.SlotNormal(a,this)},recreateFromSaveState:function(a,b){return wmsx.SlotNormal.recreateFromSaveState(a,b)}},NotMirrored:{name:"NotMirrored",desc:"Normal ROM, Not Mirrored",priority:903,priorityForRom:function(a){return wmsx.SlotFormats.Normal.priorityForRom(a)},createFromROM:function(a){return new wmsx.SlotNormal(a,this)},recreateFromSaveState:function(a,b){return wmsx.SlotNormal.recreateFromSaveState(a,b)}},ASCII8:{name:"ASCII8",desc:"ASCII 8K Mapper Cartridge",priority:911,priorityForRom:function(a){return a.content.length>=8192&&0==(8191&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8K(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8K.recreateFromSaveState(a,b)}},ASCII16:{name:"ASCII16",desc:"ASCII 16K Mapper Cartridge",priority:912,priorityForRom:function(a){return a.content.length>=16384&&0==(16383&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16K(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16K.recreateFromSaveState(a,b)}},Konami:{name:"Konami",desc:"Konami Mapper Cartridge",priority:913,priorityForRom:function(a){return a.content.length>=8192&&0==(8191&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKonami(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKonami.recreateFromSaveState(a,b)}},KonamiSCC:{name:"KonamiSCC",desc:"KonamiSCC Sound Mapper Cartridge",priority:914,priorityForRom:function(a){return a.content.length>=8192&&0==(8191&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKonamiSCC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKonamiSCC.recreateFromSaveState(a,b)}},KonamiSCCI:{name:"KonamiSCCI",desc:"Konami SCC+ Sound Mapper Cartridge (in SCC-I mode)",priority:1101,priorityForRom:function(a){return a.content.length>0&&a.content.length<=131072?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSCCIExpansion(a,this,!0)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSCCIExpansion.recreateFromSaveState(a,b)}},ASCII8SRAM2:{name:"ASCII8SRAM2",desc:"ASCII 8K SRAM 2K Mapper Cartridge",priority:1102,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},ASCII8SRAM8:{name:"ASCII8SRAM8",desc:"ASCII 8K SRAM 8K Mapper Cartridge",priority:1103,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},KoeiSRAM8:{name:"KoeiSRAM8",desc:"Koei SRAM 8K Mapper Cartridge",priority:1104,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},KoeiSRAM32:{name:"KoeiSRAM32",desc:"Koei SRAM 32K Mapper Cartridge",priority:1105,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},Wizardry:{name:"Wizardry",desc:"Wizardry SRAM Mapper Cartridge",priority:1106,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},ASCII16SRAM2:{name:"ASCII16SRAM2",desc:"ASCII 16K SRAM 2K Mapper Cartridge",priority:1107,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=2097152&&0==(16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16KSRAM.recreateFromSaveState(a,b)}},ASCII16SRAM8:{name:"ASCII16SRAM8",desc:"ASCII 16K SRAM 8K Mapper Cartridge",priority:1108,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=2097152&&0==(16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16KSRAM.recreateFromSaveState(a,b)}},RType:{name:"RType",desc:"R-Type Mapper Cartridge",priority:1111,priorityForRom:function(a){return 393216===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeRType(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeRType.recreateFromSaveState(a,b)}},CrossBlaim:{name:"CrossBlaim",desc:"CrossBlaim Mapper Cartridge",priority:1112,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeCrossBlaim(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeCrossBlaim.recreateFromSaveState(a,b)}},Manbow2:{name:"Manbow2",desc:"Space Manbow 2 SCC Sound Mapper Cartridge",priority:1113,priorityForRom:function(a){return 524288===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeManbow2(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeManbow2.recreateFromSaveState(a,b)}},Majutsushi:{name:"Majutsushi",
desc:"Konami Hai no Majutsushi PCM Mapper Cartridge",priority:1114,priorityForRom:function(a){return a.content.length>0&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMajutsushi(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMajutsushi.recreateFromSaveState(a,b)}},Synthesizer:{name:"Synthesizer",desc:"Konami Synthesizer PCM Cartridge",priority:1115,priorityForRom:function(a){return a.content.length>0&&a.content.length<=32768&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSynthesizer(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSynthesizer.recreateFromSaveState(a,b)}},GameMaster2:{name:"GameMaster2",desc:"Konami Game Master 2 SRAM Mapper Cartridge",priority:1116,priorityForRom:function(a){return 131072===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeGameMaster2(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeGameMaster2.recreateFromSaveState(a,b)}},HarryFox:{name:"HarryFox",desc:"HarryFox Mapper Cartridge",priority:1117,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeHarryFox(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeHarryFox.recreateFromSaveState(a,b)}},Halnote:{name:"Halnote",desc:"Halnote SRAM Mapper Cartridge",priority:1118,priorityForRom:function(a){return 1048576===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeHalnote(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeHalnote.recreateFromSaveState(a,b)}},AlQuran:{name:"AlQuran",desc:"The Holy Quran Mapper Cartridge (Encoded)",priority:1119,priorityForRom:function(a){return 1048576===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeAlQuran(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeAlQuran.recreateFromSaveState(a,b)}},AlQuranDecoded:{name:"AlQuranDecoded",desc:"The Holy Quran Mapper Cartridge (Decoded)",priority:1120,priorityForRom:function(a){return 1048576===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeAlQuran(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeAlQuran.recreateFromSaveState(a,b)}},SuperSwangi:{name:"SuperSwangi",desc:"Super Swangi Mapper Cartridge",priority:1121,priorityForRom:function(a){return a.content.length>=16384&&0==(16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSuperSwangi(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSuperSwangi.recreateFromSaveState(a,b)}},MSXWrite:{name:"MSXWrite",desc:"MSX Write Mapper Cartridge",priority:1122,priorityForRom:function(a){return 524288===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16K(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16K.recreateFromSaveState(a,b)}},Zemina80in1:{name:"Zemina80in1",desc:"Zemina 80 in 1 Mapper Cartridge",priority:1123,priorityForRom:function(a){return 0===(a.content.length>=8192&&8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeZemina80(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeZemina80.recreateFromSaveState(a,b)}},Zemina90in1:{name:"Zemina90in1",desc:"Zemina 90 in 1 Mapper Cartridge",priority:1124,priorityForRom:function(a){return 0===(a.content.length>=16384&&16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeZemina90(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeZemina90.recreateFromSaveState(a,b)}},Zemina126in1:{name:"Zemina126in1",desc:"Zemina 126 in 1 Mapper Cartridge",priority:1125,priorityForRom:function(a){return 0===(a.content.length>=16384&&16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeZemina126(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeZemina126.recreateFromSaveState(a,b)}},SuperLodeRunner:{name:"SuperLodeRunner",desc:"Super Lode Runner Mapper Cartridge",priority:1126,priorityForRom:function(a){return 0===(a.content.length>=16384&&16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSuperLodeRunner(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSuperLodeRunner.recreateFromSaveState(a,b)}},Dooly:{name:"Dooly",desc:"Agigongnyong Dooly Mapper Cartridge",priority:1127,priorityForRom:function(a){return 32768===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDooly(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDooly.recreateFromSaveState(a,b)}},FMPAC:{name:"FMPAC",desc:"FM-PAC SRAM Sound Mapper Cartridge",priority:1151,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeFMPAC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeFMPAC.recreateFromSaveState(a,b)}},MSXDOS2:{name:"MSXDOS2",desc:"MSX-DOS 2 Mapper Cartridge",priority:1504,embeddedURL:"@[MSXDOS2]v22.rom",priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDOS2(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDOS2.recreateFromSaveState(a,b)}}},wmsx.SlotFormats.GenericKonami=wmsx.SlotFormats.Normal,wmsx.SlotFormats.Manbow2_2=wmsx.SlotFormats.Manbow2,wmsx.SlotFormats.HamarajaNight=wmsx.SlotFormats.Manbow2,wmsx.SlotFormats.Kanji12=wmsx.SlotFormats.Kanji1,wmsx.SlotFormats.FMPAK=wmsx.SlotFormats.FMPAC,wmsx.SlotFormatsUserOptions=["Normal","Mirrored","NotMirrored","ASCII8","ASCII16","Konami","KonamiSCC","KonamiSCCI","ASCII8SRAM2","ASCII8SRAM8","ASCII16SRAM2","ASCII16SRAM8","MegaRAM","GameMaster2","AlQuran","AlQuranDecoded","CrossBlaim","Dooly","Halnote","HarryFox","KoeiSRAM8","KoeiSRAM32","Majutsushi","Manbow2","MSXWrite","RType","SuperLodeRunner","SuperSwangi","Synthesizer","Wizardry","Zemina80in1","Zemina90in1","Zemina126in1","FMPAC","Kanji1","MSXDOS2","MSXMUSIC"],wmsx.Slot=function(){"use strict";this.connect=function(a){},this.refreshConnect=function(a){},this.disconnect=function(a){},this.getDataDesc=function(){},this.loadData=function(a,b){},this.getDataToSave=function(){},this.dataModified=function(){return!1},this.powerOn=function(){},this.powerOff=function(){},this.reset=function(){},this.read=function(a){return 255},this.write=function(a,b){},this.cpuExtensionBegin=function(a){},this.cpuExtensionFinish=function(a){},this.isExpanded=function(){return!1},this.reinsertROMContent=function(){this.rom.content||(this.rom.content=this.bytes||[])},this.lightState=function(){return WMSX.LIGHT_STATES&&wmsx.EmbeddedFiles.isEmbeddedURL(this.rom.source)},this.format=void 0,this.rom=void 0,this.bytes=void 0,this.dumpBytes=function(a,b,c){wmsx.Util.dump(this.bytes,a,b,c)},this.dumpRead=function(a,b,c){var d="",e=a||0;c=c||1;for(var f=0;f<c;f++){for(var g=0;g<b;g++){var h=this.read(e++);d+=void 0!=h?h.toString(16,2)+" ":"? "}d+="   "}console.log(d)}},wmsx.Slot.base=new wmsx.Slot,wmsx.SlotEmpty={},wmsx.SlotEmpty.impl=function(){"use strict";this.read=function(a){return 255},this.rom=new wmsx.ROM("EMPTY",[],{n:"EMPTY",h:"",l:"EMPTY"}),this.format=wmsx.SlotFormats.Empty,this.saveState=function(){return{f:this.format.name}}},wmsx.SlotEmpty.impl.prototype=wmsx.Slot.base,wmsx.SlotEmpty.singleton=new wmsx.SlotEmpty.impl,wmsx.SlotExpanded=function(){"use strict";function a(a){switch(a>>14&3){case 0:return f;case 1:return g;case 2:return h;case 3:return i}}function b(){e=[k,k,k,k],c.subSlots=e}var c=this;this.isExpanded=function(){return!0},this.connect=function(a){d=a;for(var b=0;b<4;++b)e[b].connect(d)},this.refreshConnect=function(){for(var a=0;a<4;++a)e[a].refreshConnect()},this.disconnect=function(a){
for(var b=0;b<4;++b)e[b].disconnect(a);d=null},this.powerOn=function(){this.setSecondarySlotConfig(0);for(var a=0;a<4;a++)e[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)e[a].powerOff()},this.reset=function(){this.setSecondarySlotConfig(0);for(var a=0;a<4;a++)e[a].reset()},this.isAllEmpty=function(){return e[0]===k&&e[1]===k&&e[2]===k&&e[3]===k},this.insertSubSlot=function(a,b){a=a||wmsx.SlotEmpty.singleton,e[b]!==a&&(d&&e[b].disconnect(d),e[b]=a,d&&e[b].connect(d),this.setSecondarySlotConfig(j))},this.getSubSlot=function(a){return e[a]},this.getSubSlotForAddress=a,this.read=function(a){switch(a>>14&3){case 0:return f.read(a);case 1:return g.read(a);case 2:return h.read(a);case 3:return 65535===a?255&~j:i.read(a)}},this.write=function(a,b){switch(a>>14&3){case 0:return void f.write(a,b);case 1:return void g.write(a,b);case 2:return void h.write(a,b);case 3:return 65535===a?void this.setSecondarySlotConfig(b):void i.write(a,b)}},this.setSecondarySlotConfig=function(a){j=a,f=e[3&a],g=e[a>>2&3],h=e[a>>4&3],i=e[a>>6&3]},this.getSecondarySlotConfig=function(){return j},this.cpuExtensionBegin=function(b){return a(b.extPC).cpuExtensionBegin(b)},this.cpuExtensionFinish=function(b){return a(b.extPC).cpuExtensionFinish(b)};var d,e,f,g,h,i,j=0,k=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.Expanded,this.saveState=function(){return{f:this.format.name,s:j,s0:e[0].saveState(),s1:e[1].saveState(),s2:e[2].saveState(),s3:e[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,e[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,e[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,e[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,e[3]),3),this.setSecondarySlotConfig(a.s)},function(){b()}()},wmsx.SlotExpanded.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpanded;return c.loadState(a),c},wmsx.SlotExpandedSpecial=function(){"use strict";function a(a){switch(a>>14&3){case 0:return f;case 1:return g;case 2:return h;case 3:return i}}function b(){e=[k,k,k,k],c.subSlots=e}var c=this;this.isExpanded=function(){return!0},this.connect=function(a){d=a;for(var b=0;b<4;++b)e[b].connect(d)},this.refreshConnect=function(){for(var a=0;a<4;++a)e[a].refreshConnect()},this.disconnect=function(a){for(var b=0;b<4;++b)e[b].disconnect(a);d=null},this.powerOn=function(){this.setSecondarySlotConfig(0);for(var a=0;a<4;a++)e[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)e[a].powerOff()},this.reset=function(){this.setSecondarySlotConfig(0);for(var a=0;a<4;a++)e[a].reset()},this.isAllEmpty=function(){return e[0]===k&&e[1]===k&&e[2]===k&&e[3]===k},this.insertSubSlot=function(a,b){a=a||wmsx.SlotEmpty.singleton,e[b]!==a&&(d&&e[b].disconnect(d),e[b]=a,d&&e[b].connect(d),this.setSecondarySlotConfig(j))},this.getSubSlot=function(a){return e[a]},this.getSubSlotForAddress=a,this.read=function(a){switch(a>>14&3){case 0:return f.read(a);case 1:return g.read(a);case 2:return h.read(a);case 3:return 65535===a?255&~j:i.read(a)}},this.write=function(a,b){switch(a>>14&3){case 0:return void f.write(a,b);case 1:return void g.write(a,b);case 2:return void h.write(a,b);case 3:return 65535===a?void this.setSecondarySlotConfig(b):void i.write(a,b)}},this.setSecondarySlotConfig=function(a){j=a,f=e[3&a],g=e[a>>2&3],h=e[a>>4&3],i=e[a>>6&3]},this.getSecondarySlotConfig=function(){return j},this.cpuExtensionBegin=function(b){return a(b.extPC).cpuExtensionBegin(b)},this.cpuExtensionFinish=function(b){return a(b.extPC).cpuExtensionFinish(b)};var d,e,f,g,h,i,j=0,k=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.ExpandedS,this.saveState=function(){return{f:this.format.name,s:j,s0:e[0].saveState(),s1:e[1].saveState(),s2:e[2].saveState(),s3:e[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,e[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,e[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,e[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,e[3]),3),this.setSecondarySlotConfig(a.s)},function(){b()}()},wmsx.SlotExpandedSpecial.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpandedSpecial;return c.loadState(a),c},wmsx.SlotExpandedModules=function(){"use strict";function a(){d=[e,e,e,e],b.subSlots=d}var b=this;this.isExpanded=function(){return!0},this.connect=function(a){c=a;for(var b=0;b<4;++b)d[b].connect(c)},this.refreshConnect=function(){for(var a=0;a<4;++a)d[a].refreshConnect()},this.disconnect=function(a){for(var b=0;b<4;++b)d[b].disconnect(a);c=null},this.powerOn=function(){for(var a=0;a<4;a++)d[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)d[a].powerOff()},this.reset=function(){for(var a=0;a<4;a++)d[a].reset()},this.isAllEmpty=function(){return d[0]===e&&d[1]===e&&d[2]===e&&d[3]===e},this.insertSubSlot=function(a,b){a=a||wmsx.SlotEmpty.singleton,d[b]!==a&&(c&&d[b].disconnect(c),d[b]=a,c&&d[b].connect(c))},this.getSubSlot=function(a){return d[a]},this.getSubSlotForAddress=function(a){},this.read=function(a){},this.write=function(a,b){},this.setSecondarySlotConfig=function(a){},this.getSecondarySlotConfig=function(){},this.cpuExtensionBegin=function(a){},this.cpuExtensionFinish=function(a){};var c,d,e=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.ExpandedM,this.saveState=function(){return{f:this.format.name,s0:d[0].saveState(),s1:d[1].saveState(),s2:d[2].saveState(),s3:d[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,d[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,d[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,d[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,d[3]),3)},function(){a()}()},wmsx.SlotExpandedModules.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpandedModules;return c.loadState(a),c},wmsx.SlotNormal=function(a,b){"use strict";function c(a){if(65!==d[a]||66!==d[a+1])return null;for(var b=null,c=65535,e=a+2;e<=a+8;e+=2){var f=d[e+1]<<8|d[e];0!==f&&(f<c&&(c=f),e===a+8&&(!b||f<b)&&(b=f))}return 65535===c?null:{lowestHandlerPage:c>>14,lowestBasicPage:null!==b?b>>14:null}}this.read=function(a){return a>=e&&a<f?d[a-e]:h?d[a+65536-e&g]:255};var d;this.bytes=null;var e,f,g,h;this.rom=null,this.format=null,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),ba:e,m:h}},this.loadState=function(a){this.format=void 0===a.m?wmsx.SlotFormats.Normal:wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,e=a.ba,f=e+d.length,g=d.length-1,h=void 0!==a.m?a.m:a.f===wmsx.SlotFormats.Mirrored.name},a&&function(i){i.rom=a,d=wmsx.Util.asNormalArray(a.content),i.bytes=d;var j=d.length;g=j-1,i.format=b;var k=0;if(h=b===wmsx.SlotFormats.Mirrored||b!==wmsx.SlotFormats.NotMirrored&&null,65536===j||49152===j)k=0;else{var l=a.info.s?parseInt(a.info.s):-1;if(l>=0)k=l>>14;else{for(var m=null,n=null,o=0;o<j;o+=16384){var p=c(o);if(null!=p){m=p.lowestHandlerPage,n=p.lowestBasicPage;break}}null===m?k=1:32768===j?k=0===o?3===m?2:1:0===m?0:1:(k=2===m?2:1,null===h&&2===k&&2===n&&(h=!1)),null===h&&(h=!0)}}h=!!h,e=k<<14,f=Math.min(e+j,65536),wmsx.Util.log("Address: 0x"+wmsx.Util.toHex4(e)+" - 0x"+wmsx.Util.toHex4(f-1)+", Mirrored: "+h)}(this)},wmsx.SlotNormal.prototype=wmsx.Slot.base,wmsx.SlotNormal.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotNormal;return c.loadState(a),c},wmsx.SlotRAMNormal=function(a){"use strict";function b(b){b.rom=a;var e=WMSX.RAMNORMAL_SIZE;e<1?e=1:e>64&&(e=64),c=wmsx.Util.arrayFill(new Array(1024*e),0),d=65536-c.length,b.bytes=c}this.refreshConnect=function(){1024*WMSX.RAMNORMAL_SIZE!==c.length&&b(self)},
this.powerOff=function(){wmsx.Util.arrayFill(c,0)},this.read=function(a){return a>=d?c[a-d]:255},this.write=function(a,b){a>=d&&(c[a-d]=b)};var c;this.bytes=null;var d=0;this.rom=null,this.format=wmsx.SlotFormats.RAMNormal,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c)}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=65536-c.length},a&&b(this)},wmsx.SlotRAMNormal.prototype=wmsx.Slot.base,wmsx.SlotRAMNormal.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotRAMNormal;return c.loadState(a),c},wmsx.SlotRAMMapper=function(rom){"use strict";function init(a){a.rom=rom;for(var b=0;VALID_SIZES[b]<WMSX.RAMMAPPER_SIZE&&b<VALID_SIZES.length-1;)b++;var c=VALID_SIZES[b];bytes=wmsx.Util.arrayFill(new Array(1024*c),0),a.bytes=bytes,pageMask=(bytes.length>>14)-1,pageReadBackOR=255&~pageMask}this.connect=function(a){a.bus.connectInputDevice(252,this.inputAll),a.bus.connectInputDevice(253,this.inputAll),a.bus.connectInputDevice(254,this.inputAll),a.bus.connectInputDevice(255,this.inputAll),a.bus.connectOutputDevice(252,this.outputFC),a.bus.connectOutputDevice(253,this.outputFD),a.bus.connectOutputDevice(254,this.outputFE),a.bus.connectOutputDevice(255,this.outputFF)},this.refreshConnect=function(){1024*WMSX.RAMMAPPER_SIZE!==bytes.length&&init(self)},this.disconnect=function(a){a.bus.disconnectInputDevice(252,this.inputAll),a.bus.disconnectInputDevice(253,this.inputAll),a.bus.disconnectInputDevice(254,this.inputAll),a.bus.disconnectInputDevice(255,this.inputAll),a.bus.disconnectOutputDevice(252,this.outputFC),a.bus.disconnectOutputDevice(253,this.outputFD),a.bus.disconnectOutputDevice(254,this.outputFE),a.bus.disconnectOutputDevice(255,this.outputFF)},this.powerOff=function(){wmsx.Util.arrayFill(bytes,0)},this.reset=function(){page0Offset=page1Offset=page2Offset=page3Offset=0},this.outputFC=function(a){page0Offset=(a&pageMask)<<14},this.outputFD=function(a){page1Offset=((a&pageMask)<<14)-16384},this.outputFE=function(a){page2Offset=((a&pageMask)<<14)-32768},this.outputFF=function(a){page3Offset=((a&pageMask)<<14)-49152},this.inputAll=function(a){switch(255&a){case 252:return pageReadBackOR|page0Offset>>14;case 253:return pageReadBackOR|page1Offset+16384>>14;case 254:return pageReadBackOR|page2Offset+32768>>14;case 255:return pageReadBackOR|page3Offset+49152>>14}},this.read=function(a){switch(49152&a){case 0:return bytes[a+page0Offset];case 16384:return bytes[a+page1Offset];case 32768:return bytes[a+page2Offset];case 49152:return bytes[a+page3Offset]}},this.write=function(a,b){switch(49152&a){case 0:return void(bytes[a+page0Offset]=b);case 16384:return void(bytes[a+page1Offset]=b);case 32768:return void(bytes[a+page2Offset]=b);case 49152:return void(bytes[a+page3Offset]=b)}};var page0Offset=0,page1Offset=0,page2Offset=0,page3Offset=0,pageMask=0,pageReadBackOR=0,bytes;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.RAMMapper;var VALID_SIZES=[64,128,256,512,1024,2048,4096];this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),p0:page0Offset,p1:page1Offset,p2:page2Offset,p3:page3Offset}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,pageMask=(bytes.length>>14)-1,page0Offset=a.p0,page1Offset=a.p1,page2Offset=a.p2,page3Offset=a.p3,pageReadBackOR=255&~pageMask},rom&&init(this),this.eval=function(str){return eval(str)}},wmsx.SlotRAMMapper.prototype=wmsx.Slot.base,wmsx.SlotRAMMapper.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotRAMMapper;return c.loadState(a),c},wmsx.SlotBIOS=function(a){"use strict";this.connect=function(a){e.connect(a),d.connect(this,a),f.connect(this,a),a.setBIOS(this)},this.disconnect=function(a){d&&d.disconnect(this,a),a.setBIOS(null)},this.getKeyboardExtension=function(){return e},this.getTurboDriver=function(){return f},this.powerOff=function(){d&&d.powerOff()},this.reset=function(){f&&f.reset()},this.read=function(a){return a<c?b[a]:255},this.cpuExtensionBegin=function(a){return a.extNum<232?d.cpuExtensionBegin(a):f.cpuExtensionBegin(a)},this.cpuExtensionFinish=function(a){return a.extNum<232?d.cpuExtensionFinish(a):f.cpuExtensionFinish(a)},this.setVideoStandardForced=function(a){a===wmsx.VideoStandard.PAL?b[43]|=128:b[43]&=-129},this.setVideoStandardUseOriginal=function(){this.originalVideoStandard===wmsx.VideoStandard.PAL?b[43]|=128:b[43]&=-129};var b;this.bytes=null;var c,d=new wmsx.ImageCassetteDriver,e=new wmsx.BIOSKeyboardExtension,f=new wmsx.TurboDriver;this.rom=null,this.format=wmsx.SlotFormats.BIOS,this.originalVideoStandard=null,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),v:this.originalVideoStandard.name,b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),ke:e.saveState(),td:f.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),this.originalVideoStandard=wmsx.VideoStandard[a.v],a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b),d.patchBIOS(b)),this.bytes=b,c=b.length,a.ke&&e.loadState(a.ke),f.loadState(a.td)},a&&function(e){e.rom=a,b=wmsx.Util.asNormalArray(a.content),e.bytes=b,c=b.length,e.originalVideoStandard=0==(128&b[43])?wmsx.VideoStandard.NTSC:wmsx.VideoStandard.PAL,d.patchBIOS(b)}(this)},wmsx.SlotBIOS.prototype=wmsx.Slot.base,wmsx.SlotBIOS.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotBIOS;return c.loadState(a),c},wmsx.SlotMSX2BIOSExt=function(a){"use strict";this.read=function(a){return a<c?b[a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.MSX2BIOSExt,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b)}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,c=b.length},a&&function(d){d.rom=a,b=wmsx.Util.asNormalArray(a.content),d.bytes=b,c=b.length}(this)},wmsx.SlotMSX2BIOSExt.prototype=wmsx.Slot.base,wmsx.SlotMSX2BIOSExt.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotMSX2BIOSExt;return c.loadState(a),c},wmsx.CartridgeASCII8K=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=-16384,d=-24576,e=-32768,f=-40960},this.write=function(a,b){if(!(a<24576))return a<26624?void(c=(b%g<<13)-16384):a<28672?void(d=(b%g<<13)-24576):a<30720?void(e=(b%g<<13)-32768):void(a<32768&&(f=(b%g<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return b[c+a];case 24576:return b[d+a];case 32768:return b[e+a];case 40960:return b[f+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g;this.rom=null,this.format=wmsx.SlotFormats.ASCII8,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d,b3:e,b4:f,n:g}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=a.b3,f=a.b4,g=a.n},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,g=b.length/8192|0}(this)},wmsx.CartridgeASCII8K.prototype=wmsx.Slot.base,wmsx.CartridgeASCII8K.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII8K;return c.loadState(a),c},wmsx.CartridgeASCII16K=function(a,b){"use strict";function c(a){a===wmsx.SlotFormats.MSXWrite?(h=28671,i=32767):(h=-1,i=-1)}
this.powerOn=function(){this.reset()},this.reset=function(){e=-16384,f=-32768},this.write=function(a,b){if(a>=24576&&a<26624||a===h)return void(e=(b%g<<14)-16384);(a>=28672&&a<30720||a===i)&&(f=(b%g<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?d[e+a]:a<49152?d[f+a]:255};var d;this.bytes=null;var e,f,g,h,i;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),b1:e,b2:f,n:g}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,e=a.b1,f=a.b2,g=a.n,c(this.format)},a&&function(e){e.rom=a,d=wmsx.Util.asNormalArray(a.content),e.bytes=d,g=d.length/16384|0,c(b)}(this)},wmsx.CartridgeASCII16K.prototype=wmsx.Slot.base,wmsx.CartridgeASCII16K.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII16K;return c.loadState(a),c},wmsx.CartridgeKonami=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=e=-16384},this.write=function(a,b){a>=24576&&a<32767?c=(b%f<<13)-24576:a>=32768&&a<40959?d=(b%f<<13)-32768:a>=40960&&a<49151&&(e=(b%f<<13)-40960)},this.read=function(a){switch(57344&a){case 16384:return b[a-16384];case 24576:return b[c+a];case 32768:return b[d+a];case 40960:return b[e+a];default:return 255}};var b;this.bytes=null;var c,d,e,f;this.rom=null,this.format=wmsx.SlotFormats.Konami,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c,b3:d,b4:e,n:f}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=a.b3,e=a.b4,f=a.n},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,f=b.length/8192|0}(this)},wmsx.CartridgeKonami.prototype=wmsx.Slot.base,wmsx.CartridgeKonami.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKonami;return c.loadState(a),c},wmsx.CartridgeRType=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=-32768},this.write=function(a,b){a>=28672&&a<32768&&(c=(b%24<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[229376+a]:a<49152?b[c+a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.RType,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeRType.prototype=wmsx.Slot.base,wmsx.CartridgeRType.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeRType;return c.loadState(a),c},wmsx.CartridgeCrossBlaim=function(a){this.powerOn=function(){this.reset()},this.reset=function(){c=-16384},this.write=function(a,b){16453===a&&(c=((3&b)<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[a-16384]:a<49152?b[c+a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.CrossBlaim,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeCrossBlaim.prototype=wmsx.Slot.base,wmsx.CartridgeCrossBlaim.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeCrossBlaim;return c.loadState(a),c},wmsx.CartridgeDOS2=function(a){"use strict";this.connect=function(a){a.getDiskDriveSocket().dos2ROMConnected(this)},this.disconnect=function(a){a.getDiskDriveSocket().dos2ROMDisconnected(this)},this.powerOn=function(){this.reset()},this.reset=function(){c=-16384},this.write=function(a,b){32766===a&&(c=((3&b)<<14)-16384)},this.read=function(a){return a>=16384&&a<32768?b[c+a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.MSXDOS2,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeDOS2.prototype=wmsx.Slot.base,wmsx.CartridgeDOS2.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDOS2;return c.loadState(a),c},wmsx.CartridgeHarryFox=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=-16384},this.write=function(a,b){if(a>=24576&&a<28672)return void(c=(1&b?32768:0)-16384);a>=28672&&a<32768&&(d=(1&b?49152:16384)-32768)},this.read=function(a){return a<16384?255:a<32768?b[c+a]:a<49152?b[d+a]:255};var b;this.bytes=null;var c,d;this.rom=null,this.format=wmsx.SlotFormats.HarryFox,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeHarryFox.prototype=wmsx.Slot.base,wmsx.CartridgeHarryFox.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeHarryFox;return c.loadState(a),c},wmsx.CartridgeAlQuran=function(a,b){"use strict";function c(){for(var a=new Array(256),b=0;b<256;++b)a[b]=77^(b<<4&80|b>>3&5|b<<1&160|b<<2&8|b>>6&2);for(var c=0,e=d.length;c<e;++c)d[c]=a[d[c]]}this.powerOn=function(){this.reset()},this.reset=function(){e=-16384,f=-24576,g=-32768,h=-40960},this.write=function(a,b){if(!(a<20480))return a<21504?void(e=((127&b)<<13)-16384):a<22528?void(f=((127&b)<<13)-24576):a<23552?void(g=((127&b)<<13)-32768):void(a<24576&&(h=((127&b)<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return d[e+a];case 24576:return d[f+a];case 32768:return d[g+a];case 40960:return d[h+a];default:return 255}};var d;this.bytes=null;var e,f,g,h;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),b1:e,b2:f,b3:g,b4:h}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,e=a.b1,f=a.b2,g=a.b3,h=a.b4},a&&function(e){e.rom=a,d=wmsx.Util.asNormalArray(a.content),e.bytes=d,b===wmsx.SlotFormats.AlQuran&&c()}(this)},wmsx.CartridgeAlQuran.prototype=wmsx.Slot.base,wmsx.CartridgeAlQuran.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeAlQuran;return c.loadState(a),c},wmsx.CartridgeSuperSwangi=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=-32768},this.write=function(a,b){32768===a&&(c=((b>>1)%d<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[a-16384]:a<49152?b[c+a]:255};var b;this.bytes=null;var c,d;this.rom=null,this.format=wmsx.SlotFormats.SuperSwangi,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=b.length/16384|0},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,d=b.length/16384|0}(this)},wmsx.CartridgeSuperSwangi.prototype=wmsx.Slot.base,wmsx.CartridgeSuperSwangi.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSuperSwangi;return c.loadState(a),c},wmsx.CartridgeZemina80=function(a){"use strict"
;this.powerOn=function(){this.reset()},this.reset=function(){c=d=e=f=-16384},this.write=function(a,b){switch(a){case 16384:return void(c=(b%g<<13)-16384);case 16385:return void(d=(b%g<<13)-24576);case 16386:return void(e=(b%g<<13)-32768);case 16387:f=(b%g<<13)-40960}},this.read=function(a){switch(57344&a){case 16384:return b[c+a];case 24576:return b[d+a];case 32768:return b[e+a];case 40960:return b[f+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g;this.rom=null,this.format=wmsx.SlotFormats.Zemina80in1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d,b3:e,b4:f}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=a.b3,f=a.b4,g=b.length/8192|0},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,g=b.length/8192|0}(this)},wmsx.CartridgeZemina80.prototype=wmsx.Slot.base,wmsx.CartridgeZemina80.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeZemina80;return c.loadState(a),c},wmsx.CartridgeZemina90=function(a){"use strict";this.connect=function(a){a.bus.connectOutputDevice(119,this.output77)},this.disconnect=function(a){a.bus.disconnectOutputDevice(119,this.output77)},this.powerOn=function(){this.reset()},this.reset=function(){this.output77(0)},this.read=function(a){return a<16384?255:a<32768?b[d+a]:a<49152?f?b[e+a^8192]:b[e+a]:255},this.output77=function(a,b){c=a;var g=63&a,h=a>>6;2===h?(d=((62&g)<<14)-16384,e=((1|g)<<14)-32768):(d=(g<<14)-16384,e=(g<<14)-32768),f=3===h};var b;this.bytes=null;var c,d,e,f;this.rom=null,this.format=wmsx.SlotFormats.Zemina90in1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),bc:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,this.output77(a.bc)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeZemina90.prototype=wmsx.Slot.base,wmsx.CartridgeZemina90.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeZemina90;return c.loadState(a),c},wmsx.CartridgeZemina126=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=-16384},this.write=function(a,b){if(16384===a)return void(c=(b%e<<14)-16384);16385===a&&(d=(b%e<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[c+a]:a<49152?b[d+a]:255};var b;this.bytes=null;var c,d,e;this.rom=null,this.format=wmsx.SlotFormats.Zemina126in1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=b.length/16384|0},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,e=b.length/16384|0}(this)},wmsx.CartridgeZemina126.prototype=wmsx.Slot.base,wmsx.CartridgeZemina126.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeZemina126;return c.loadState(a),c},wmsx.CartridgeSuperLodeRunner=function(a){"use strict";function b(a,b){0===a&&(d=(b%e<<14)-32768)}this.connect=function(a){a.bus.setWriteMonitor(b)},this.disconnect=function(a){a.bus.setWriteMonitor(null)},this.powerOn=function(){this.reset()},this.reset=function(){d=32768},this.read=function(a){return a>=32768&&a<49152?c[d+a]:255};var c;this.bytes=null;var d,e;this.rom=null,this.format=wmsx.SlotFormats.SuperLodeRunner,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c),b1:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=a.b1,e=c.length/16384|0},a&&function(b){b.rom=a,c=wmsx.Util.asNormalArray(a.content),b.bytes=c,e=c.length/16384|0}(this)},wmsx.CartridgeSuperLodeRunner.prototype=wmsx.Slot.base,wmsx.CartridgeSuperLodeRunner.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSuperLodeRunner;return c.loadState(a),c},wmsx.CartridgeDooly=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=0},this.write=function(a,b){a>=16384&&a<49152&&(c=7&b)},this.read=function(a){if(a>=16384&&a<49152){var d=b[a-16384];switch(c){case 0:return d;case 1:return 248&d|d<<2&4|d>>1&3;case 4:return 248&d|d>>2&1|d<<1&6;case 2:case 5:case 6:switch(7&d){case 1:case 2:case 4:return 248&d;case 3:case 5:case 6:if(2==c)return 248&d|7^(d<<2&4|d>>1&3);if(5==c)return 7^d;if(6==c)return 248&d|7^(d>>2&1|d<<1&6);default:return d}default:return 7|d}}return 255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.Dooly,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),e:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.e},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeDooly.prototype=wmsx.Slot.base,wmsx.CartridgeDooly.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDooly;return c.loadState(a),c},wmsx.CartridgeMegaRAM=function(a){"use strict";this.reinsertROMContent=function(){this.rom.content&&this.rom.content.length||(this.rom.content=this.bytes.slice(0,this.bytes.length))},this.connect=function(a){a.bus.connectInputDevice(142,this.input8E),a.bus.connectOutputDevice(142,this.output8E)},this.disconnect=function(a){a.bus.disconnectInputDevice(142,this.input8E),a.bus.disconnectOutputDevice(142,this.output8E)},this.powerOn=function(){this.reset()},this.reset=function(){h=!1},this.input8E=function(){return h=!0,255},this.output8E=function(a){h=!1},this.write=function(a,i){if(!(a<16384))return a<24576?void(h?b[d+a]=i:d=(i%c<<13)-16384):a<32768?void(h?b[e+a]=i:e=(i%c<<13)-24576):a<40960?void(h?b[f+a]=i:f=(i%c<<13)-32768):void(a<49152&&(h?b[g+a]=i:g=(i%c<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return b[d+a];case 24576:return b[e+a];case 32768:return b[f+a];case 40960:return b[g+a];default:return 255}};var b;this.bytes=null;var c,d=-16384,e=-16384,f=-16384,g=-16384,h=!1;this.rom=null,this.format=wmsx.SlotFormats.MegaRAM;var i=Math.min(WMSX.MEGARAM_SIZE/8,256),j=[32,64,128,256];this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:d,b2:e,b3:f,b4:g,n:c,m:h}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,d=a.b1,e=a.b2,f=a.b3,g=a.b4,c=a.n,h=a.m},a&&function(d){d.rom=a;var e=a.content;if(e&&e.length){c=Math.ceil(e.length/8192);for(var f=0;j[f]<c;)++f;c=j[f]}else c=i;b=new Array(8192*c),wmsx.Util.arrayCopy(e,0,b),wmsx.Util.arrayFill(b,0,e.length),d.bytes=b}(this)},wmsx.CartridgeMegaRAM.prototype=wmsx.Slot.base,wmsx.CartridgeMegaRAM.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMegaRAM;return c.loadState(a),c},wmsx.CartridgeDiskPatched=function(a){"use strict";this.connect=function(a){e.connect(this,a),a.getDiskDriveSocket().diskInterfaceConnected(this)},this.disconnect=function(a){e.disconnect(this,a),a.getDiskDriveSocket().diskInterfaceDisconnected(this)},this.powerOff=function(){e.powerOff()},this.read=function(a){return a>=c&&a<d?b[a-c]:255},this.cpuExtensionBegin=function(a){return e.cpuExtensionBegin(a)},this.cpuExtensionFinish=function(a){return e.cpuExtensionFinish(a)};var b;this.bytes=null;var c,d;this.rom=null,this.format=wmsx.SlotFormats.DiskPatch;var e=new wmsx.ImageDiskDriver;this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),d:e.saveState(),ba:c
}},this.loadState=function(a){if(this.rom=wmsx.ROM.loadState(a.r),c=void 0!==a.ba?a.ba:16384,a.b)b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b);else{this.rom.reloadEmbeddedContent();var f=this.rom.content.length+256;b&&b.length===f||(b=new Array(f)),wmsx.Util.arrayCopy(this.rom.content,0,b),e.patchDiskBIOS(b,16384===c?0:16384)}this.bytes=b,d=c+b.length,e.loadState(a.d)},a&&function(f){f.rom=a,b=new Array(a.content.length+256),wmsx.Util.arrayCopy(a.content,0,b),f.bytes=b,c=16384===a.content.length?16384:16384*(WMSX.DISK_ROM_START_PAGE||0),d=c+b.length,e.patchDiskBIOS(b,16384===c?0:16384)}(this)},wmsx.CartridgeDiskPatched.prototype=wmsx.Slot.base,wmsx.CartridgeDiskPatched.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDiskPatched(null,null);return c.loadState(a),c},wmsx.CartridgeNextorPatched=function(a){"use strict";this.connect=function(a){d.connect(this,a),a.getDiskDriveSocket().hardDiskInterfaceConnected(this)},this.disconnect=function(a){d.disconnect(this,a),a.getDiskDriveSocket().hardDiskInterfaceDisconnected(this)},this.powerOn=function(){this.reset()},this.powerOff=function(){d.powerOff()},this.reset=function(){c=-16384},this.write=function(a,b){a>=24576&&a<26624&&(c=((7&b)<<14)-16384)},this.read=function(a){return a>=16384&&a<32768?b[c+a]:255},this.cpuExtensionBegin=function(a){return d.cpuExtensionBegin(a)},this.cpuExtensionFinish=function(a){return d.cpuExtensionFinish(a)};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.Nextor16Patch;var d=new wmsx.ImageNextorDeviceDriver;this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,d:d.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b),d.patchNextorKernel(b)),this.bytes=b,c=a.b1,d.loadState(a.d)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,d.patchNextorKernel(b)}(this)},wmsx.CartridgeNextorPatched.prototype=wmsx.Slot.base,wmsx.CartridgeNextorPatched.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeNextorPatched;return c.loadState(a),c},wmsx.CartridgeKonamiSCC=function(rom){"use strict";function init(a){a.rom=rom,bytes=wmsx.Util.asNormalArray(rom.content),a.bytes=bytes,numBanks=bytes.length/8192|0}function connectSCC(){scc.connectAudio(),sccConnected=!0}this.connect=function(a){scc.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC()},this.disconnect=function(a){scc.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio()},this.reset=function(){bank1Offset=bank2Offset=bank3Offset=bank4Offset=-16384,sccSelected=sccConnected=!1,scc.reset()},this.write=function(a,b){return a>=20480&&a<=22527?void(bank1Offset=(b%numBanks<<13)-16384):a>=28672&&a<=30719?void(bank2Offset=(b%numBanks<<13)-24576):a>=36864&&a<=38911?(bank3Offset=(b%numBanks<<13)-32768,void(63==(63&b)?(sccSelected=!0,sccConnected||connectSCC()):sccSelected=!1)):sccSelected&&a>=38912&&a<=40959?void scc.write(a,b):void(a>=45056&&a<=47103&&(bank4Offset=(b%numBanks<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return bytes[bank1Offset+a];case 24576:return bytes[bank2Offset+a];case 32768:return a>=38912&&sccSelected?scc.read(a):bytes[bank3Offset+a];case 40960:return bytes[bank4Offset+a];default:return 255}};var bytes;this.bytes=null;var bank1Offset,bank2Offset,bank3Offset,bank4Offset,numBanks,scc=new wmsx.SCCIAudio,sccSelected=!1,sccConnected=!1;this.rom=null,this.format=wmsx.SlotFormats.KonamiSCC,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),b1:bank1Offset,b2:bank2Offset,b3:bank3Offset,b4:bank4Offset,n:numBanks,scc:scc.saveState(),scs:sccSelected,scn:sccConnected}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,bank1Offset=a.b1,bank2Offset=a.b2,bank3Offset=a.b3,bank4Offset=a.b4,numBanks=a.n,scc.loadState(a.scc),sccSelected=a.scs,(sccConnected=a.scn)&&connectSCC()},rom&&init(this),this.eval=function(arg){return eval(arg)}},wmsx.CartridgeKonamiSCC.prototype=wmsx.Slot.base,wmsx.CartridgeKonamiSCC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKonamiSCC;return c.loadState(a),c},wmsx.CartridgeSCCExpansion=function(a){"use strict";function b(){c.connectAudio(),e=!0}this.connect=function(a){c.setAudioSocket(a.getAudioSocket()),e&&b()},this.disconnect=function(a){c.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){c.disconnectAudio()},this.reset=function(){d=e=!1,c.reset()},this.write=function(a,f){if(a>=36864&&a<=38911)return void(63==(63&f)?(d=!0,e||b()):d=!1);d&&a>=38912&&a<=40959&&c.write(a,f)},this.read=function(a){return d&&a>=38912&&a<=40959?c.read(a):255};var c=new wmsx.SCCIAudio,d=!1,e=!1;this.rom=null,this.format=wmsx.SlotFormats.SCCExpansion,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),scc:c.saveState(),scs:d,scn:e}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),c.loadState(a.scc),d=a.scs,(e=a.scn)&&b()},a&&function(b){b.rom=a}(this)},wmsx.CartridgeSCCExpansion.prototype=wmsx.Slot.base,wmsx.CartridgeSCCExpansion.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSCCExpansion;return c.loadState(a),c},wmsx.CartridgeSCCIExpansion=function(rom,format,startInSCCI){"use strict";function init(a){a.rom=rom;var b=rom.content;bytes=wmsx.Util.arrayFill(new Array(131072),255),a.bytes=bytes,b.length>0&&(a.preLoadedContentSize=b.length,wmsx.Util.arrayCopy(b,0,bytes),b.length<=65536&&wmsx.Util.arrayCopy(b,0,bytes,65536)),startingMode=startInSCCI?32:0}function setMode(a){mode=a,scciMode=0!=(32&a),scc.setSCCIMode(scciMode);var b=0!=(16&a);bank4RamMode=b,bank3RamMode=b||scciMode&&0!=(4&a),bank2RamMode=b||0!=(2&a),bank1RamMode=b||0!=(1&a)}function connectSCC(){scc.connectAudio(),sccConnected=!0}this.reinsertROMContent=function(){this.rom.content||(this.rom.content=this.bytes?this.bytes.slice(0,this.preLoadedContentSize):[])},this.connect=function(a){scc.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC()},this.disconnect=function(a){scc.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio(),0===this.preLoadedContentSize&&wmsx.Util.arrayFill(bytes,255)},this.reset=function(){bank1Offset=bank2Offset=bank3Offset=bank4Offset=-16384,sccSelected=scciSelected=sccConnected=!1,scc.reset(),setMode(startingMode)},this.read=function(a){switch(57344&a){case 16384:return bytes[bank1Offset+a];case 24576:return bytes[bank2Offset+a];case 32768:return a>=38912&&sccSelected&&!scciMode?scc.read(a):bytes[bank3Offset+a];case 40960:return a>=47104&&scciSelected&&scciMode?scc.read(a):bytes[bank4Offset+a];default:return 255}},this.write=function(a,b){if(49150===a||49151===a)return void setMode(b);switch(57344&a){case 16384:return void(bank1RamMode?bytes[bank1Offset+a]=b:a>=20480&&a<=22527&&(bank1Offset=((15&b)<<13)-16384));case 24576:return void(bank2RamMode?bytes[bank2Offset+a]=b:a>=28672&&a<=30719&&(bank2Offset=((15&b)<<13)-24576));case 32768:return void(bank3RamMode?bytes[bank3Offset+a]=b:a>=36864&&a<=38911?(bank3Offset=((15&b)<<13)-32768,(sccSelected=63==(63&b))&&!sccConnected&&connectSCC()):a>=38912&&sccSelected&&!scciMode&&scc.write(a,b));case 40960:bank4RamMode?bytes[bank4Offset+a]=b:a>=45056&&a<=47103?(bank4Offset=((15&b)<<13)-40960,(scciSelected=128==(128&b))&&!sccConnected&&connectSCC()):a>=47104&&scciSelected&&scciMode&&scc.write(a,b)}};var bytes;this.bytes=null
;var startingMode=0,mode,scciMode,bank4RamMode,bank3RamMode,bank2RamMode,bank1RamMode,bank1Offset,bank2Offset,bank3Offset,bank4Offset,scc=new wmsx.SCCIAudio,sccSelected,scciSelected=!1,sccConnected=!1;this.rom=null,this.format=format,this.preLoadedContentSize=0,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),pcs:this.preLoadedContentSize,b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),sm:startingMode,m:mode,b1:bank1Offset,b2:bank2Offset,b3:bank3Offset,b4:bank4Offset,scc:scc.saveState(),scs:sccSelected,sis:scciSelected,scn:sccConnected}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),this.preLoadedContentSize=a.pcs||0,bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,bank1Offset=a.b1,bank2Offset=a.b2,bank3Offset=a.b3,bank4Offset=a.b4,startingMode=a.sm||0,setMode(void 0!==a.m?a.m:startingMode),scc.loadState(a.scc),sccSelected=a.scs,scciSelected=a.sis,(sccConnected=a.scn)&&connectSCC()},this.eval=function(str){return eval(str)},rom&&init(this)},wmsx.CartridgeSCCIExpansion.prototype=wmsx.Slot.base,wmsx.CartridgeSCCIExpansion.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSCCIExpansion;return c.loadState(a),c},wmsx.CartridgeManbow2=function(rom){"use strict";function init(a){a.rom=rom,bytes=wmsx.Util.asNormalArray(rom.content),a.bytes=bytes}function writeMem(a,b){a>=458752&&a<524288&&(bytes[a]=b,sramModif||(sramModif=!0,cartridgeSocket.fireCartridgesModifiedStateUpdate()))}function connectSCC(){scc.connectAudio(),sccConnected=!0}this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){if(65536!==b.length)return null;for(var c=0;c<65536;++c)bytes[458752+c]=b[c];return sramContentName=a,b},this.getDataToSave=function(){sramModif=!1,cartridgeSocket.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(bytes.slice(458752));return{fileName:sramContentName||"Manbow2.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return sramModif},this.connect=function(a){cartridgeSocket=a.getCartridgeSocket(),scc.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC()},this.disconnect=function(a){scc.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio()},this.reset=function(){bank1Offset=bank2Offset=bank3Offset=bank4Offset=-16384,sccSelected=sccConnected=!1,scc.reset()},this.read=function(a){switch(57344&a){case 16384:return bytes[bank1Offset+a];case 24576:return bytes[bank2Offset+a];case 32768:return sccSelected&&a>=38912?scc.read(a):bytes[bank3Offset+a];case 40960:return bytes[bank4Offset+a];default:return 255}},this.write=function(a,b){switch(57344&a){case 16384:return writeMem(bank1Offset+a,b),void(a>=20480&&a<=22527&&(bank1Offset=((b&bankSelMask)<<13)-16384));case 24576:return writeMem(bank2Offset+a,b),void(a>=28672&&a<=30719&&(bank2Offset=((b&bankSelMask)<<13)-24576));case 32768:return sccSelected&&a>=38912&&scc.write(a,b),writeMem(bank3Offset+a,b),void(a>=36864&&a<=38911&&(bank3Offset=((b&bankSelMask)<<13)-32768,(sccSelected=63==(63&b))&&!sccConnected&&connectSCC()));case 40960:writeMem(bank4Offset+a,b),a>=45056&&a<=47103&&(bank4Offset=8192*(b&bankSelMask)-40960)}};var bytes;this.bytes=null;var bank1Offset,bank2Offset,bank3Offset,bank4Offset,bankSelMask=63,scc=new wmsx.SCCIAudio,sccSelected=!1,sccConnected=!1,sramContentName,sramModif=!1,cartridgeSocket;this.rom=null,this.format=wmsx.SlotFormats.Manbow2,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),b1:bank1Offset,b2:bank2Offset,b3:bank3Offset,b4:bank4Offset,scc:scc.saveState(),scs:sccSelected,scn:sccConnected,sn:sramContentName,d:sramModif}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,bank1Offset=a.b1,bank2Offset=a.b2,bank3Offset=a.b3,bank4Offset=a.b4,scc.loadState(a.scc),sccSelected=a.scs,sccConnected=a.scn,sramContentName=a.sn,sramModif=!!a.d,sccConnected&&connectSCC()},this.eval=function(str){return eval(str)},rom&&init(this)},wmsx.CartridgeManbow2.prototype=wmsx.Slot.base,wmsx.CartridgeManbow2.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeManbow2;return c.loadState(a),c},wmsx.CartridgeKanjiFont=function(a){"use strict";this.connect=function(a){a.bus.connectInputDevice(216,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectInputDevice(217,this.inputD9),a.bus.connectOutputDevice(216,this.outputD8),a.bus.connectOutputDevice(217,this.outputD9),a.bus.connectInputDevice(218,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectInputDevice(219,this.inputDB),a.bus.connectOutputDevice(218,this.outputDA),a.bus.connectOutputDevice(219,this.outputDB)},this.disconnect=function(a){a.bus.disconnectInputDevice(216,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectInputDevice(217,this.inputD9),a.bus.disconnectOutputDevice(216,this.outputD8),a.bus.disconnectOutputDevice(217,this.outputD9),a.bus.disconnectInputDevice(218,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectInputDevice(219,this.inputDB),a.bus.disconnectOutputDevice(218,this.outputDA),a.bus.disconnectOutputDevice(219,this.outputDB)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.reset=function(){b=c=0,d=e=0},this.read=function(a){return 255},this.write=function(a,b){},this.outputD8=function(a){b=4032&b|63&a,d=b<<5},this.outputD9=function(a){b=63&b|(63&a)<<6,d=b<<5},this.inputD9=function(){return f[131071&d++]},this.outputDA=function(a){c=4032&c|63&a,e=c<<5},this.outputDB=function(a){c=63&c|(63&a)<<6,e=c<<5},this.inputDB=function(){return g?f[131072+(131071&e++)]:255};var b,c,d,e,f,g=!1;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.Kanji1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(f),c1:b,r1:d,c2:c,r2:e,j2:g}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?f=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,f):(this.rom.reloadEmbeddedContent(),f&&f.length===this.rom.content.length||(f=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,f)),this.bytes=f,b=a.c1,d=a.r1,c=a.c2,e=a.r2,g=a.j2},a&&function(b){b.rom=a,f=wmsx.Util.asNormalArray(a.content),b.bytes=f,g=262144===f.length}(this)},wmsx.CartridgeKanjiFont.prototype=wmsx.Slot.base,wmsx.CartridgeKanjiFont.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKanjiFont;return c.loadState(a),c},wmsx.CartridgePAC=function(a){"use strict";function b(a,b){e=a;for(var d=wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length,f=0,g=c.length-2;f<g;f++)c[f]=b[d+f]}this.connect=function(a){f=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,d){return wmsx.CartridgePAC.isPACFileContentValid(d)?(b(a,d),c):null},this.getDataToSave=function(){g=!1,f.fireCartridgesModifiedStateUpdate();var a=wmsx.CartridgePAC.buildPACFileContentToSave(c);return{fileName:e||"PAC SRAM.pac",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return g},this.powerOn=function(){this.reset()},this.reset=function(){d=!1},this.write=function(a,b){if(24574===a||24575===a)return c[a-16384]=b,void(d=77===c[8190]&&105===c[8191]);d&&a>=16384&&a<=24573&&(c[a-16384]=b,g||(g=!0,f.fireCartridgesModifiedStateUpdate()))},this.read=function(a){return d&&a>=16384&&a<=24575?c[a-16384]:255};var c,d;this.sram=null;var e,f,g=!1;this.rom=null,this.format=wmsx.SlotFormats.PACExpansion,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),sa:d,s:wmsx.Util.compressInt8BitArrayToStringBase64(c),sn:e,d:g}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),d=a.sa,c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,c),e=a.sn,g=!!a.d},a&&function(d){d.rom=a,c=wmsx.Util.arrayFill(new Array(8192),0),d.sram=c,
0!==a.content.length&&b(a.source,a.content)}(this)},wmsx.CartridgePAC.prototype=wmsx.Slot.base,wmsx.CartridgePAC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgePAC;return c.loadState(a),c},wmsx.CartridgePAC.isPACFileContentValid=function(a){return 8206===a.length&&wmsx.Util.int8BitArrayToByteString(a,0,wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length)==wmsx.CartridgePAC.DATA_FILE_IDENTIFIER},wmsx.CartridgePAC.buildPACFileContentToSave=function(a){var b=new Uint8Array(wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length+a.length-2);return b.set(wmsx.Util.byteStringToInt8BitArray(wmsx.CartridgePAC.DATA_FILE_IDENTIFIER)),b.set(a.slice(0,-2),wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length),b},wmsx.CartridgePAC.DATA_FILE_IDENTIFIER="PAC2 BACKUP DATA",wmsx.CartridgeMSXMUSIC=function(a){"use strict";this.connect=function(a){c.connect(a)},this.disconnect=function(a){c.disconnect(a)},this.powerOn=function(){c.powerOn(),this.reset()},this.powerOff=function(){c.powerOff()},this.reset=function(){c.reset()},this.read=function(a){return a>=16384&&a<32768?b[a-16384]:255};var b;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.MSXMUSIC;var c=new wmsx.YM2413Audio("MSX-MUSIC");this.opll=c,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),fm:c.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,c.loadState(a.fm)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeMSXMUSIC.prototype=wmsx.Slot.base,wmsx.CartridgeMSXMUSIC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMSXMUSIC;return c.loadState(a),c},wmsx.CartridgeFMPAC=function(a){"use strict";function b(){k&&(1&i?m.connect(k):m.disconnect(k))}function c(a,b){g=a;for(var c=wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length,d=0,f=e.length-2;d<f;d++)e[d]=b[c+d]}this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){return wmsx.CartridgePAC.isPACFileContentValid(b)?(c(a,b),e):null},this.getDataToSave=function(){l=!1,h.fireCartridgesModifiedStateUpdate();var a=wmsx.CartridgePAC.buildPACFileContentToSave(e);return{fileName:g||"PAC SRAM.pac",content:a,desc:this.getDataDesc()}},this.connect=function(a){k=a,h=k.getCartridgeSocket(),b()},this.disconnect=function(a){m.disconnect(a)},this.dataModified=function(){return l},this.powerOn=function(){m.powerOn(),this.reset()},this.powerOff=function(){m.powerOff()},this.reset=function(){f=!1,j=-16384,i=0,b(),m.reset()},this.write=function(a,c){switch(a){case 32756:m.output7C(c);break;case 32757:m.output7D(c);break;case 32758:i=17&c,b();break;case 32759:j=((3&c)<<14)-16384;break;case 24574:case 24575:e[a-16384]=c,f=77===e[8190]&&105===e[8191]}f&&a>=16384&&a<=24573&&(e[a-16384]=c,l||(l=!0,h.fireCartridgesModifiedStateUpdate()))},this.read=function(a){return 32758===a?i:32759===a?j+16384>>14:f?a>=16384&&a<=24575?e[a-16384]:255:a>=16384&&a<32768?d[j+a]:255};var d;this.bytes=null;var e,f;this.sram=null;var g,h,i,j,k,l=!1;this.rom=null,this.format=wmsx.SlotFormats.FMPAC;var m=new wmsx.YM2413Audio("FM-PAC");this.opll=m,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),b1:j,fe:i,sa:f,s:wmsx.Util.compressInt8BitArrayToStringBase64(e),sn:g,fm:m.saveState(),d:l}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,j=a.b1,i=a.fe,f=a.sa,e=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,e),g=a.sn,m.loadState(a.fm),l=!!a.d,b()},a&&function(b){b.rom=a,d=wmsx.Util.asNormalArray(a.content),b.bytes=d,e=wmsx.Util.arrayFill(new Array(8192),0),b.sram=e}(this)},wmsx.CartridgeFMPAC.prototype=wmsx.Slot.base,wmsx.CartridgeFMPAC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeFMPAC;return c.loadState(a),c},wmsx.CartridgeMoonSound=function(a){"use strict";this.connect=function(a){c.connect(a)},this.disconnect=function(a){c.disconnect(a)},this.powerOn=function(){c.powerOn(),this.reset()},this.powerOff=function(){c.powerOff()},this.reset=function(){c.reset()},this.opl4ReadMemory=function(a){return b[4194303&a]},this.opl4WriteMemory=function(a,c){(4194303&a)<2097152||(b[4194303&a]=c)};var b;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.MoonSound;var c=new wmsx.OPL4Audio("MoonSound",this);this.opl4=c,this.saveState=function(){var a=this.lightState();return{f:this.format.name,r:this.rom.saveState(),b:a?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),ra:a?wmsx.Util.compressInt8BitArrayToStringBase64(b,2097152,2097152):null,opl4:c.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b||(b=new Array(4194304)),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.ra,b,!0,null,2097152),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,c.loadState(a.opl4)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content,0,4194304),wmsx.Util.arrayFill(b,0,2097152),c.bytes=b}(this)},wmsx.CartridgeMoonSound.prototype=wmsx.Slot.base,wmsx.CartridgeMoonSound.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMoonSound;return c.loadState(a),c},wmsx.CartridgeExtraPSG=function(a){"use strict";this.connect=function(a){b.setAudioSocket(a.getAudioSocket()),b.connectBus(a.bus)},this.disconnect=function(a){b.disconnectBus(a.bus)},this.powerOn=function(){b.powerOn()},this.powerOff=function(){b.powerOff()},this.reset=function(){b.reset()};var b=new wmsx.PSG(null,null,!0);this.rom=null,this.format=wmsx.SlotFormats.ExtraPSG,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),p:b.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b.loadState(a.p)},a&&function(b){b.rom=a}(this)},wmsx.CartridgeExtraPSG.prototype=wmsx.Slot.base,wmsx.CartridgeExtraPSG.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeExtraPSG;return c.loadState(a),c},wmsx.CartridgeGameMaster2=function(a){"use strict";this.connect=function(a){h=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){if(8192!==b.length)return null;for(var c=0;c<8192;++c)f[c]=b[c];return g=a,b},this.getDataToSave=function(){i=!1,h.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(f);return{fileName:g||"GameMaster2.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return i},this.powerOn=function(){this.reset()},this.reset=function(){c=1,d=2,e=3},this.write=function(a,b){if(!(a<24576||a>=49152))return a<28672?void(c=b):a>=32768&&a<36864?void(d=b):a>=40960&&a<45056?void(e=b):void(a>=45056&&16&e&&(f[((32&e)<<7)+a-45056]=b,i||(i=!0,h.fireCartridgesModifiedStateUpdate())))},this.read=function(a){switch(57344&a){case 16384:return b[a-16384];case 24576:return 16&c?f[((32&c)<<7)+(a-24576&4095)]:b[((15&c)<<13)+a-24576];case 32768:return 16&d?f[((32&d)<<7)+(a-32768&4095)]:b[((15&d)<<13)+a-32768];case 40960:return 16&e?f[((32&e)<<7)+(a-40960&4095)]:b[((15&e)<<13)+a-40960];default:return 255}};var b;this.bytes=null;var c,d,e,f;this.sram=null;var g,h,i=!1;this.rom=null,this.format=wmsx.SlotFormats.GameMaster2,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c,b3:d,b4:e,s:wmsx.Util.compressInt8BitArrayToStringBase64(f),sn:g,d:i}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=a.b3,e=a.b4,f=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,f),this.sram=f,g=a.sn,i=!!a.d},a&&function(c){c.rom=a,
b=wmsx.Util.asNormalArray(a.content),c.bytes=b,f=wmsx.Util.arrayFill(new Array(8192),0),c.sram=f}(this)},wmsx.CartridgeGameMaster2.prototype=wmsx.Slot.base,wmsx.CartridgeGameMaster2.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeGameMaster2;return c.loadState(a),c},wmsx.CartridgeASCII8KSRAM=function(a,b){"use strict";this.connect=function(a){n=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){var c=l+1;if(b.length!==c)return null;for(var d=0;d<c;++d)k[d]=b[d];return m=a,b},this.getDataToSave=function(){o=!1,n.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(k);return{fileName:m||"Data.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return o},this.powerOn=function(){this.reset()},this.reset=function(){d=e=f=g=0},this.write=function(a,b){if(!(a<24576||a>=49152))return a<26624?void(d=b):a<28672?void(e=b):a<30720?void(f=b):a<32768?void(g=b):a<40960&&f&j?(k[((3&f)<<13)+a-32768&l]=b,void(o||(o=!0,n.fireCartridgesModifiedStateUpdate()))):void(g&j&&(k[((3&g)<<13)+a-40960&l]=b,o||(o=!0,n.fireCartridgesModifiedStateUpdate())))},this.read=function(a){switch(57344&a){case 16384:return d&j?k[((3&d)<<13)+a-16384&l]:c[((d&i)%h<<13)+a-16384];case 24576:return e&j?k[((3&e)<<13)+a-24576&l]:c[((e&i)%h<<13)+a-24576];case 32768:return f&j?k[((3&f)<<13)+a-32768&l]:c[((f&i)%h<<13)+a-32768];case 40960:return g&j?k[((3&g)<<13)+a-40960&l]:c[((g&i)%h<<13)+a-40960];default:return 255}};var c;this.bytes=null;var d,e,f,g,h,i,j,k;this.sram=null;var l,m,n,o=!1;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c),b1:d,b2:e,b3:f,b4:g,n:h,rsm:i,s:wmsx.Util.compressInt8BitArrayToStringBase64(k),sn:m,ssm:j,d:o}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=a.b1,e=a.b2,f=a.b3,g=a.b4,h=a.n,i=a.rsm,k=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,k),this.sram=k,l=k.length-1,m=a.sn,j=a.ssm,o=!!a.d},a&&function(d){d.rom=a,c=wmsx.Util.asNormalArray(a.content),d.bytes=c,h=c.length/8192|0;var e=b===wmsx.SlotFormats.KoeiSRAM32?32768:b===wmsx.SlotFormats.ASCII16SRAM2?2048:8192;l=e-1,k=wmsx.Util.arrayFill(new Array(e),0),d.sram=k;var f=Math.max(32,1<<Math.ceil(wmsx.Util.log2(h)));i=f-1,j=b===wmsx.SlotFormats.Wizardry?128:f}(this)},wmsx.CartridgeASCII8KSRAM.prototype=wmsx.Slot.base,wmsx.CartridgeASCII8KSRAM.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII8K;return c.loadState(a),c},wmsx.CartridgeASCII16KSRAM=function(a,b){"use strict";this.connect=function(a){l=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){var c=j+1;if(b.length!==c)return null;for(var d=0;d<c;++d)i[d]=b[d];return k=a,b},this.getDataToSave=function(){m=!1,l.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(i);return{fileName:k||"Data.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return m},this.powerOn=function(){this.reset()},this.reset=function(){d=e=0},this.write=function(a,b){return a>=24576&&a<26624?void(d=b):a>=28672&&a<30720?void(e=b):void(a>=32768&&a<49152&&e&h&&(i[a-32768&j]=b,m||(m=!0,l.fireCartridgesModifiedStateUpdate())))},this.read=function(a){switch(49152&a){case 16384:return d&h?i[a-16384&j]:c[((d&g)%f<<14)+a-16384];case 32768:return e&h?i[a-32768&j]:c[((e&g)%f<<14)+a-32768];default:return 255}};var c;this.bytes=null;var d,e,f,g,h,i;this.sram=null;var j,k,l,m=!1;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c),b1:d,b2:e,n:f,rsm:g,s:wmsx.Util.compressInt8BitArrayToStringBase64(i),sn:k,ssm:h,d:m}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=a.b1,e=a.b2,f=a.n,g=a.rsm,i=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,i),this.sram=i,j=i.length-1,k=a.sn,h=a.ssm,m=!!a.d},a&&function(d){d.rom=a,c=wmsx.Util.asNormalArray(a.content),d.bytes=c,f=c.length/16384|0;var e=b===wmsx.SlotFormats.ASCII16SRAM2?2048:8192;j=e-1,i=wmsx.Util.arrayFill(new Array(e),0),d.sram=i;var k=1<<Math.ceil(wmsx.Util.log2(f));g=k-1,h=Math.max(16,k)}(this)},wmsx.CartridgeASCII16KSRAM.prototype=wmsx.Slot.base,wmsx.CartridgeASCII16KSRAM.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII16KSRAM;return c.loadState(a),c},wmsx.CartridgeHalnote=function(a){"use strict";this.connect=function(a){m=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){if(16384!==b.length)return null;for(var c=0;c<16384;++c)j[c]=b[c];return l=a,b},this.getDataToSave=function(){n=!1,m.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(j);return{fileName:l||"Halnote.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return n},this.powerOn=function(){this.reset()},this.reset=function(){c=-16384,d=-24576,e=-32768,f=-40960,g=495616,h=493568,i=k=!1},this.write=function(a,b){switch(a){case 20479:return c=((127&b)<<13)-16384,void(k=0!=(128&b));case 28671:return d=((127&b)<<13)-24576,void(i=0!=(128&b));case 36863:return void(e=((127&b)<<13)-32768);case 45055:return void(f=((127&b)<<13)-40960);case 30719:return void(g=(b<<11)-28672+524288);case 32767:h=(b<<11)-30720+524288}},this.read=function(a){switch(57344&a){case 0:case 8192:return k?j[a]:255;case 16384:return b[c+a];case 24576:return a>=28672&&i?b[(a<30720?g:h)+a]:b[d+a];case 32768:return b[e+a];case 40960:return b[f+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g,h,i,j;this.sram=null;var k,l,m,n=!1;this.rom=null,this.format=wmsx.SlotFormats.Halnote,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d,b3:e,b4:f,sb1:g,sb2:h,sbe:i,s:wmsx.Util.compressInt8BitArrayToStringBase64(j),se:k,sn:l,d:n}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=a.b3,f=a.b4,g=a.sb1,h=a.sb2,i=a.sbe,j=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,j),this.sram=j,k=a.se,l=a.sn,n=!!a.d},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,j=wmsx.Util.arrayFill(new Array(16384),0),c.sram=j}(this)},wmsx.CartridgeHalnote.prototype=wmsx.Slot.base,wmsx.CartridgeHalnote.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeHalnote;return c.loadState(a),c},wmsx.CartridgeMajutsushi=function(a){"use strict";this.connect=function(a){g.setAudioSocket(a.getAudioSocket()),g.connectAudio()},this.disconnect=function(a){g.disconnectAudio()},this.powerOn=function(){this.reset(),g.connectAudio()},this.powerOff=function(){g.disconnectAudio(),this.reset()},this.reset=function(){c=d=e=-16384,g.reset()},this.write=function(a,b){a>=20480&&a<24575?g.setSampleValue(b):a>=24576&&a<32767?c=(b%f<<13)-24576:a>=32768&&a<40959?d=(b%f<<13)-32768:a>=40960&&a<49151&&(e=(b%f<<13)-40960)},this.read=function(a){switch(57344&a){case 16384:return b[a-16384];case 24576:return b[c+a];case 32768:return b[d+a];case 40960:return b[e+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g=new wmsx.PCM8BitAudio;this.rom=null,this.format=wmsx.SlotFormats.Majutsushi,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c,b3:d,b4:e,n:f,p:g.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=a.b3,e=a.b4,f=a.n,g.loadState(a.p)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,f=b.length/8192|0}(this)},wmsx.CartridgeMajutsushi.prototype=wmsx.Slot.base,
wmsx.CartridgeMajutsushi.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMajutsushi;return c.loadState(a),c},wmsx.CartridgeSynthesizer=function(a){"use strict";this.connect=function(a){c.setAudioSocket(a.getAudioSocket()),c.connectAudio()},this.disconnect=function(a){c.disconnectAudio()},this.powerOn=function(){this.reset(),c.connectAudio()},this.powerOff=function(){c.disconnectAudio(),this.reset()},this.reset=function(){c.reset()},this.write=function(a,b){16384==(49168&a)&&c.setSampleValue(b)},this.read=function(a){return a>=16384&&a<49152?b[a-16384]:255};var b;this.bytes=null;var c=new wmsx.PCM8BitAudio;this.rom=null,this.format=wmsx.SlotFormats.Synthesizer,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),p:c.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c.loadState(a.p)},a&&function(c){c.rom=a,b=wmsx.Util.arrayFill(new Array(32768),255),c.bytes=b;for(var d=a.content.length,e=0;e<32768;++e)b[e]=a.content[e%d]}(this)},wmsx.CartridgeSynthesizer.prototype=wmsx.Slot.base,wmsx.CartridgeSynthesizer.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSynthesizer;return c.loadState(a),c},wmsx.MachineTypeSocket=function(a){"use strict";this.getMachine=function(){return a.machineName},this.getMachineLang=function(){return WMSX.MACHINES_CONFIG[a.machineName].LANG||"en"},this.getCodeKeyLabel=function(){return WMSX.MACHINES_CONFIG[a.machineName].CODE_LABEL||"CODE"},this.changeMachine=function(b){if(a.machineName!==b){if(WMSX.MEDIA_CHANGE_DISABLED)return b.showOSD("Machine change is disabled!",!0,!0);var c=WMSX.MACHINES_CONFIG[b];if(c){var d=a.powerIsOn;a.powerOff();var e=a.systemPause(!0);WMSX.MACHINE=b,wmsx.Configurator.applyFinalConfig(),a.updateMachineType(),new wmsx.MultiDownloader(wmsx.Configurator.slotURLSpecs(),function(){a.getExtensionsSocket().refreshSlotsFromConfig(function(){a.getSavestateSocket().externalStateChange(),a.showOSD((c.DESC||c.DESCX)+" machine activated",!0),e||a.systemPause(!1),d&&a.powerOn()})},function(a){wmsx.Util.message(a.errorMessage)}).start()}}},this.addMachineTypeStateListener=function(a,c){b.indexOf(a)<0&&(b.push(a),c||a.machineTypeStateUpdate())},this.fireMachineTypeStateUpdate=function(){for(var a=0;a<b.length;++a)b[a].machineTypeStateUpdate()};var b=[]},wmsx.ExtensionsSocket=function(a){"use strict";function b(a,c,e,g){if(f[a]&&(e=e&&!!f[a].SLOT2,d.isActiveOnConf(a,e)!==c&&(WMSX.EXTENSIONS[a]^=e?2:1,!g))){var h=f[a];if(h.MUTUAL&&b(h.MUTUAL,!c,e,!0),c){if(h.CHANGE)for(var i in h.CHANGE)b(i,!!h.CHANGE[i],e,!0);h.TOGGLE&&(i=h.TOGGLE,d.isActiveOnConf(i,e)&&(b(i,!1,e,!0),d.isActiveOnConf(a,!e)||b(i,!0,!e,!0)))}}}function c(a,b){return{url:f[a].URL||"",onSuccess:function(c){e.loadFromContentAsSlot(c.url,c.content,b?f[a].SLOT2:f[a].SLOT,!0,null,!0)}}}var d=this;this.connectFileLoader=function(a){e=a},this.addExtensionsAndCartridgesStateListener=function(b){a.getCartridgeSocket().addCartridgesStateListener(this,!0),h.indexOf(b)<0&&(h.push(b),b.extensionsAndCartridgesStateUpdate())},this.cartridgesStateUpdate=function(){this.refreshConfigFromSlots(),this.fireExtensionsAndCartridgesStateUpdate()},this.configurationStateUpdate=function(){f=WMSX.EXTENSIONS_CONFIG},this.isActiveOnConf=function(a,b){if(!f[a])return!1;var c=f[a].SLOT2&&b?2:1;return 0!=(WMSX.EXTENSIONS[a]&c)},this.isActiveOnSlot=function(a,b){var c=f[a];if(!c)return!1;var d=!!c.SLOT2,e=g.slotInserted(b&&d?c.SLOT2:c.SLOT);return!!e&&e.rom.source===c.URL},this.activateExtension=function(a,b,c,d,e){this.isActiveOnSlot(a,c)||this.toggleExtension(a,b,c,d,e)},this.toggleExtension=function(c,d,e,g,h){var i=f[c];if(i){var j=!!i.SLOT2,k=j&&!i.TOGGLE;e=e&&j;var l=0;switch(WMSX.EXTENSIONS[c]||0){case 0:l=e?2:1;break;case 1:l=e?k?3:2:0;break;case 2:l=e?0:k?3:1;break;case 3:l=e?1:2}j?0==(1&l)?(b(c,!1,!1),b(c,0!=(2&l),!0)):(b(c,0!=(2&l),!0),b(c,!0,!1)):b(c,0!=(1&l),!1);var m=a.powerIsOn;!d&&m&&a.powerOff();var n=a.systemPause(!0);this.refreshSlotsFromConfig(function(b){if(h||a.getSavestateSocket().externalStateChange(),n||a.systemPause(!1),!d&&m&&a.userPowerOn(!1),b&&!g){var c=a.getSlotSocket().getSlotDesc(2&l?i.SLOT2:i.SLOT),e=i.DESC+" Extension "+(l?"enabled"+(3===l?" at both slots":c?" at slot "+c:""):"disabled");a.showOSD(e,!0),wmsx.Util.log(e)}})}},this.getInitialLoaderURLSpecs=function(){var a=[];for(var b in f)1&WMSX.EXTENSIONS[b]&&a.push(c(b,!1)),f[b].SLOT2&&2&WMSX.EXTENSIONS[b]&&a.push(c(b,!0));return a},this.fireExtensionsAndCartridgesStateUpdate=function(){for(var a=0;a<h.length;++a)h[a].extensionsAndCartridgesStateUpdate()},this.refreshSlotsFromConfig=function(a){var b=[],e=[];for(var h in f){var i=f[h];1&WMSX.EXTENSIONS[h]?d.isActiveOnSlot(h,!1)||b.push(c(h,!1)):d.isActiveOnSlot(h,!1)&&e.push(i.SLOT),i.SLOT2&&(2&WMSX.EXTENSIONS[h]?d.isActiveOnSlot(h,!0)||b.push(c(h,!0)):d.isActiveOnSlot(h,!0)&&e.push(i.SLOT2))}if(0===b.length&&0===e.length)return d.fireExtensionsAndCartridgesStateUpdate(),a(!1);for(var j=0;j<e.length;++j)g.insertSlot(null,e[j],!0,!0);new wmsx.MultiDownloader(b,function(){d.fireExtensionsAndCartridgesStateUpdate(),a(!0)},function(a){wmsx.Util.message(a.errorMessage)}).start()},this.refreshConfigFromSlots=function(){for(var a in f){var b=d.isActiveOnSlot(a,!1)?1:0;b|=f[a].SLOT2&&d.isActiveOnSlot(a,!0)?2:0,WMSX.EXTENSIONS[a]=b}};var e,f=WMSX.EXTENSIONS_CONFIG,g=a.getSlotSocket(),h=[];!function(){wmsx.Configurator.addConfigurationStateListener(d)}()},wmsx.DeviceMissing={inputPort:function(a){return 255},outputPort:function(a,b){},inputPortIgnored:function(a){return 255},outputPortIgnored:function(a,b){},IGNORED_PORTS:new Set([144,145,147,184,185,186,187,128,129,130,131,132,133,134,135,220,221,192,193,194,195,200,201,202,203,204,205,206,207]),setDebugMode:function(a){self.debugMode=a},debugMode:0},wmsx.BUS=function(machine,cpu){"use strict";function init(){create()}function getSlotForAddress(a){switch(primarySlotConfig>>(a>>14<<1)&3){case 0:return slot0;case 1:return slot1;case 2:return slot2;case 3:return slot3}}function create(){slot0=slot1=slot2=slot3=slotModules=slotEmpty,slots=[slot0,slot1,slot2,slot3,slotModules],devicesInputPorts=wmsx.Util.arrayFill(new Array(256),deviceInputMissing),devicesOutputPorts=wmsx.Util.arrayFill(new Array(256),deviceOutputMissing),self.slots=slots,self.devicesInputPorts=devicesInputPorts,self.devicesOutputPorts=devicesOutputPorts}var self=this;this.powerOn=function(){this.setPrimarySlotConfig(0);for(var a=0;a<5;a++)slots[a].powerOn()},this.powerOff=function(){for(var a=0;a<5;a++)slots[a].powerOff()},this.reset=function(){this.setPrimarySlotConfig(0);for(var a=0;a<5;a++)slots[a].reset()},this.refreshConnect=function(){for(var a=0;a<5;++a)slots[a].refreshConnect()},this.insertSlot=function(a,b){if(a=a||slotEmpty,slots[b]!==a)switch(slots[b].disconnect(machine),slots[b]=a,slots[b].connect(machine),b){case 0:return void(slot0=a);case 1:return void(slot1=a);case 2:return void(slot2=a);case 3:return void(slot3=a);case 4:return void(slotModules=a)}},this.getSlot=function(a){return slots[a]},this.getSlotForAddress=getSlotForAddress,this.read=function(a){switch(primarySlotConfig>>(a>>14<<1)&3){case 0:return slot0.read(a);case 1:return slot1.read(a);case 2:return slot2.read(a);case 3:return slot3.read(a)}},this.write=function(a,b){switch(primarySlotConfig>>(a>>14<<1)&3){case 0:return void slot0.write(a,b);case 1:return void slot1.write(a,b);case 2:return void slot2.write(a,b);case 3:return void slot3.write(a,b)}},this.writeWithBusMonitor=function(a,b){switch(writeMonitor&&writeMonitor(a,b),primarySlotConfig>>(a>>14<<1)&3){case 0:return void slot0.write(a,b);case 1:return void slot1.write(a,b);case 2:return void slot2.write(a,b);case 3:return void slot3.write(a,b)}},this.input=function(a){return devicesInputPorts[255&a](a)},
this.output=function(a,b){return devicesOutputPorts[255&a](b,a)},this.setPrimarySlotConfig=function(a){primarySlotConfig=a},this.getPrimarySlotConfig=function(){return primarySlotConfig},this.cpuExtensionBegin=function(a){if(a.extNum<240)return getSlotForAddress(a.extPC).cpuExtensionBegin(a);var b=cpuExtensionHandlers[a.extNum];return b?b.cpuExtensionBegin(a):void 0},this.cpuExtensionFinish=function(a){if(a.extNum<240)return getSlotForAddress(a.extPC).cpuExtensionFinish(a);var b=cpuExtensionHandlers[a.extNum];return b?b.cpuExtensionFinish(a):void 0},this.setCpuExtensionHandler=function(a,b){cpuExtensionHandlers[a]=b},this.connectInputDevice=function(a,b){devicesInputPorts[a]=b},this.connectOutputDevice=function(a,b){devicesOutputPorts[a]=b},this.disconnectInputDevice=function(a,b){b&&devicesInputPorts[a]!==b||(devicesInputPorts[a]=deviceInputMissing)},this.disconnectOutputDevice=function(a,b){b&&devicesOutputPorts[a]!==b||(devicesOutputPorts[a]=deviceOutputMissing)},this.setWriteMonitor=function(a){(writeMonitor=a)&&(this.write=this.writeWithBusMonitor)};var slots,slot0,slot1,slot2,slot3,slotModules,primarySlotConfig=0,slotEmpty=wmsx.SlotEmpty.singleton,deviceInputMissing=wmsx.DeviceMissing.inputPort,deviceOutputMissing=wmsx.DeviceMissing.outputPort,devicesInputPorts,devicesOutputPorts,writeMonitor,cpuExtensionHandlers={};this.saveState=function(){return{p:primarySlotConfig,s0:slot0.saveState(),s1:slot1.saveState(),s2:slot2.saveState(),s3:slot3.saveState(),sM:slotModules.saveState()}},this.loadState=function(a){this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,slot0),0),this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,slot1),1),this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,slot2),2),this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,slot3),3),this.insertSlot(a.sM?wmsx.SlotCreator.recreateFromSaveState(a.sM,slotModules):slotEmpty,4),this.setPrimarySlotConfig(a.p)},init(),this.eval=function(str){return eval(str)}},wmsx.Machine=function(){"use strict";function init(){socketsCreate(),mainComponentsCreate(),computeBasicAutoRunCommandParameters()}function getSlot(a){"number"==typeof a&&(a=[a]);var b=a[0],c=a[1],d=bus.getSlot(b);return c>=0?d=d.isExpanded()?d.getSubSlot(c):null:d.isExpanded()&&(d=d.getSubSlot(0)),d}function getSlotDesc(a){var b="number"==typeof a?a:a[0];return b>3?void 0:b.toString()+(bus.getSlot(b).isExpanded()?"-"+(a[1]||0):"")}function insertSlot(a,b){"number"==typeof b&&(b=[b]);var c=!a||a===EMPTY_SLOT;if(!c||-1===e||(getSlot(b)||EMPTY_SLOT)!==EMPTY_SLOT){var d=b[0],e=b[1],f=bus.getSlot(d);if(e>=0){if(!f.isExpanded()){var g=f;f=2===d?new wmsx.SlotExpandedSpecial:4===d?new wmsx.SlotExpandedModules:new wmsx.SlotExpanded,bus.insertSlot(f,d),g!==EMPTY_SLOT&&e>0&&f.insertSubSlot(g,0)}f.insertSubSlot(a,e),c&&f.isAllEmpty()&&bus.insertSlot(a,d)}else f.isExpanded()&&-1!==e?(f.insertSubSlot(a,0),c&&f.isAllEmpty()&&bus.insertSlot(a,d)):bus.insertSlot(a,d)}}function setVideoStandard(a,b,c){!1!==c&&self.showOSD((videoStandardIsAuto?"AUTO: ":"FORCED: ")+a.desc,!!c),(b||videoStandard!==a)&&(videoStandard=a,vdp.setVideoStandard(videoStandard),videoClockUpdateSpeed())}function setVideoStandardAuto(a){videoStandardIsAuto=!0;var b=wmsx.VideoStandard.NTSC;videoStandardSoft?b=videoStandardSoft:bios&&(bios.setVideoStandardUseOriginal(),b=bios.originalVideoStandard),setVideoStandard(b,!0,a)}function setVideoStandardForced(a){videoStandardIsAuto=!1,bios&&bios.setVideoStandardForced(a),setVideoStandard(a,!1,!0)}function setVSynchMode(a,b){(vSynchMode!==a||b)&&(vSynchMode=a<0?a:a%2,vdp.setVSynchMode(vSynchMode),videoClockUpdateSpeed())}function vSynchModeToggle(){if(vSynchMode<0||-1===videoClockSocket.getVSynchNativeFrequency())return self.showOSD("VSync is disabled / unsupported",!0,!0);setVSynchMode(vSynchMode+1),self.showOSD("VSync: "+(1===vSynchMode?"Auto ("+(videoClockSocket.isVSynchActive()?"ON":"OFF")+")":0===vSynchMode?"OFF":"DISABLED"),!0),WMSX.userPreferences.current.vSynch=vSynchMode,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save()}function saveState(a){var b={cfg:wmsx.Configurator.saveState(),mn:self.machineName,mt:self.machineType,b:bus.saveState(),rc:rtc.saveState(),sf:syf.saveState(),pp:ppi.saveState(),ps:psg.saveState(),vd:vdp.saveState(a),c:cpu.saveState(),va:videoStandardIsAuto,vs:videoStandard.name,ctm:cpuTurboMode,vtm:vdpTurboMode,s:speedControl,br:basicAutoRunDone,bc:basicAutoRunCommand||"",vss:videoStandardSoft&&videoStandardSoft.name,dd:diskDriveSocket.getDrive().saveState(),ct:cassetteSocket.getDeck().saveState(),cs:controllersSocket.saveState()};return a&&(b.vy=vSynchMode,b.pw=self.powerIsOn,b.up=userPaused,b.upf=userPauseMoreFrames),b}function loadState(a){wmsx.Configurator.loadState(a,a.cfg),void 0!==a.vy&&setVSynchMode(a.vy,!0),void 0!==a.pw&&self.powerIsOn!==a.pw&&(a.pw?self.powerOn(!0):self.powerOff()),void 0!==a.up&&self.userPause(a.up),void 0!==a.upf&&(userPauseMoreFrames=a.upf),self.machineName=a.mn,self.machineType=a.mt,videoStandardIsAuto=a.va,setVideoStandard(wmsx.VideoStandard[a.vs]),videoStandardSoft=a.vss&&wmsx.VideoStandard[a.vss],speedControl=a.s||1,1===speedControl&&(speedControl=defaultSpeed),basicAutoRunDone=!!a.br,void 0!==a.bc&&(basicAutoRunCommand=a.bc),videoClockUpdateSpeed(),cpu.loadState(a.c),vdp.loadState(a.vd),psg.loadState(a.ps),ppi.loadState(a.pp),rtc.loadState(a.rc),syf.loadState(a.sf),bus.loadState(a.b),diskDriveSocket.getDrive().loadState(a.dd),cassetteSocket.getDeck().loadState(a.ct),a.cs&&controllersSocket.loadState(a.cs),machineTypeSocket.fireMachineTypeStateUpdate(),cartridgeSocket.fireCartridgesStateUpdate(),machineControlsSocket.firePowerAndUserPauseStateUpdate(),audioSocket.flushAllSignals(),diskDriveSocket.fireInterfacesChangeUpdate(),cpuTurboMode=void 0!==a.ctm?a.ctm:cpu.getCPUTurboMulti()>1?cpu.getCPUTurboMulti():0,vdpTurboMode=void 0!==a.vtm?a.vtm:vdp.getVDPTurboMulti()>1?vdp.getVDPTurboMulti():0,biosSocket.turboDriverTurboModesUpdate(),saveStateSocket.externalStateChange()}function videoClockUpdateSpeed(){var a=vdp.getDesiredVideoPulldown();videoClockSocket.setVSynch(1===vSynchMode);var b=a.frequency*(alternateSpeed||speedControl)|0;videoClockSocket.setFrequency(b,a.divider),audioSocket.setFps(b/a.divider),rtc.setFps(a.frequency/a.divider)}function mainComponentsCreate(){self.cpu=cpu=new wmsx.Z80,self.vdp=vdp=new wmsx.VDP(self,cpu),self.psg=psg=new wmsx.PSG(controllersSocket,ledsSocket,!1),self.ppi=ppi=new wmsx.PPI(psg.getAudioChannel(),controllersSocket,ledsSocket),self.rtc=rtc=new wmsx.RTC(videoClockSocket),self.syf=syf=new wmsx.SystemFlags,self.bus=bus=new wmsx.BUS(self,cpu),cpu.connectBus(bus),ppi.connectBus(bus),vdp.connectBus(bus),psg.setAudioSocket(audioSocket),psg.connectBus(bus),rtc.connectBus(bus),syf.connectBus(bus)}function socketsCreate(){machineTypeSocket=new wmsx.MachineTypeSocket(self),videoClockSocket=new VideoClockSocket,slotSocket=new SlotSocket,biosSocket=new BIOSSocket,extensionsSocket=new wmsx.ExtensionsSocket(self),cartridgeSocket=new CartridgeSocket,expansionSocket=new ExpansionSocket,controllersSocket=new ControllersSocket,saveStateSocket=new SaveStateSocket,cassetteSocket=new CassetteSocket,audioSocket=new AudioSocket,diskDriveSocket=new DiskDriveSocket,machineControlsSocket=new MachineControlsSocket,ledsSocket=new LedsSocket}function computeBasicAutoRunCommandParameters(){basicAutoRunCommand=(WMSX.BASIC_ENTER?WMSX.BASIC_ENTER+"\r":"")+(WMSX.BASIC_TYPE||""),WMSX.BASIC_RUN?basicAutoRunCommand='\r\r\rRUN "'+WMSX.BASIC_RUN+'"\r'+basicAutoRunCommand:WMSX.BASIC_LOAD?basicAutoRunCommand='\r\r\rLOAD "'+WMSX.BASIC_LOAD+'"\r'+basicAutoRunCommand:WMSX.BASIC_BRUN?basicAutoRunCommand='\r\r\rBLOAD "'+WMSX.BASIC_BRUN+'",r\r'+basicAutoRunCommand:WMSX.BASIC_BLOAD&&(basicAutoRunCommand='\r\r\rBLOAD "'+WMSX.BASIC_BLOAD+'"\r'+basicAutoRunCommand)}function typeBasicAutoRunCommand(){
diskDriveSocket.hasAnyMediaInserted()||cartridgeSocket.hasAnyMediaInserted()||cassetteSocket.typeAutoRunCommand(),basicAutoRunDone||(basicAutoRunCommand&&biosSocket.keyboardExtensionTypeString(basicAutoRunCommand),basicAutoRunDone=!0,basicAutoRunCommand=void 0)}function controlStateChanged(a,b,c,d){if(!isLoading){if(a===controls.FAST_SPEED&&!c)return void(b&&alternateSpeed!==SPEED_FAST?(alternateSpeed=SPEED_FAST,videoClockUpdateSpeed(),self.showOSD("FAST FORWARD",!0)):b||alternateSpeed!==SPEED_FAST||(alternateSpeed=null,videoClockUpdateSpeed(),self.showOSD(null,!0)));if(a===controls.FAST_SPEED&&c)return void(b&&alternateSpeed!==SPEED_SLOW?(alternateSpeed=SPEED_SLOW,videoClockUpdateSpeed(),self.showOSD("SLOW MOTION",!0)):b||alternateSpeed!==SPEED_SLOW||(alternateSpeed=null,videoClockUpdateSpeed(),self.showOSD(null,!0)));if(b)switch(a){case controls.POWER:c?self.powerIsOn&&self.reset():self.powerIsOn?self.powerOff():self.userPowerOn(!1);break;case controls.POWER_OFF:self.powerIsOn&&self.powerOff();break;case controls.PAUSE:return self.userPause(!userPaused,c),void self.getVideoOutput().showOSD(userPaused?"PAUSE"+(c?" with AUDIO ON":""):"RESUME",!0);case controls.FRAME:return void(userPaused&&(userPauseMoreFrames=1));case controls.INC_SPEED:case controls.DEC_SPEED:case controls.NORMAL_SPEED:case controls.MIN_SPEED:var e=SPEEDS.indexOf(speedControl);return a===controls.INC_SPEED&&e<SPEEDS.length-1?++e:a===controls.DEC_SPEED&&e>0?--e:a===controls.MIN_SPEED?e=0:a===controls.NORMAL_SPEED&&(e=SPEEDS.indexOf(1)),speedControl=SPEEDS[e],self.showOSD("Speed: "+(100*speedControl|0)+"%",!0),void videoClockUpdateSpeed();case controls.SAVE_STATE_0:case controls.SAVE_STATE_1:case controls.SAVE_STATE_2:case controls.SAVE_STATE_3:case controls.SAVE_STATE_4:case controls.SAVE_STATE_5:case controls.SAVE_STATE_6:case controls.SAVE_STATE_7:case controls.SAVE_STATE_8:case controls.SAVE_STATE_9:case controls.SAVE_STATE_10:case controls.SAVE_STATE_11:case controls.SAVE_STATE_12:saveStateSocket.saveState(255&a);break;case controls.SAVE_STATE_FILE:saveStateSocket.saveStateFile();break;case controls.LOAD_STATE_0:case controls.LOAD_STATE_1:case controls.LOAD_STATE_2:case controls.LOAD_STATE_3:case controls.LOAD_STATE_4:case controls.LOAD_STATE_5:case controls.LOAD_STATE_6:case controls.LOAD_STATE_7:case controls.LOAD_STATE_8:case controls.LOAD_STATE_9:case controls.LOAD_STATE_10:case controls.LOAD_STATE_11:case controls.LOAD_STATE_12:saveStateSocket.loadState(255&a);break;case controls.TYPE_STRING:biosSocket.keyboardExtensionTypeString(d);break;case controls.VIDEO_STANDARD:videoStandardIsAuto?setVideoStandardForced(c?wmsx.VideoStandard.PAL:wmsx.VideoStandard.NTSC):videoStandard==wmsx.VideoStandard.NTSC?c?setVideoStandardAuto(!0):setVideoStandardForced(wmsx.VideoStandard.PAL):c?setVideoStandardForced(wmsx.VideoStandard.NTSC):setVideoStandardAuto(!0);break;case controls.VSYNCH:vSynchModeToggle();break;case controls.CPU_TURBO_MODE:self.toggleCPUTurboMode(c);break;case controls.VDP_TURBO_MODE:self.toggleVDPTurboMode(c);break;case controls.DEBUG:var f=vdp.toggleDebugModes(c);wmsx.DeviceMissing.setDebugMode(f);break;case controls.SPRITE_MODE:vdp.toggleSpriteDebugModes(c);break;case controls.DEFAULTS:self.setDefaults(),self.showOSD("Default Settings",!0)}}}function VideoClockSocket(){this.connectClock=function(b){a=b,rtc.syncTimeWithSource()},this.getVSynchNativeFrequency=function(){return a.getVSynchNativeFrequency()},this.setVSynch=function(b){a.setVSynch(b)},this.setFrequency=function(b,c){a.setFrequency(b,c)},this.isVSynchActive=function(){return a.isVSynchActive()},this.getRealTime=function(){return a.getRealTime()};var a}function BIOSSocket(){this.insertBIOS=function(a,b){slotSocket.insertSlot(a,WMSX.BIOS_SLOT,b)},this.insertBIOSEXT=function(a,b){slotSocket.insertSlot(a,WMSX.BIOSEXT_SLOT,b)},this.keyboardExtensionTypeString=function(a){bios&&bios.getKeyboardExtension().typeString(a)},this.keyboardExtensionCancelTypeString=function(){bios&&bios.getKeyboardExtension().cancelTypeString()},this.turboDriverTurboModesUpdate=function(){bios&&bios.getTurboDriver().turboModesUpdate()},this.setMachineTurboModesStateListener=function(b){a=b,a.machineTurboModesStateUpdate()},this.fireMachineTurboModesStateUpdate=function(){a&&a.machineTurboModesStateUpdate()};var a}function ExpansionSocket(){this.insertExpansion=function(a,b,c){var d=b?WMSX.EXPANSION2_SLOT:WMSX.EXPANSION1_SLOT;a!==slotSocket.slotInserted(d)&&(slotSocket.insertSlot(a,d,c),cartridgeSocket.fireCartridgesStateUpdate(),self.showOSD("Expansion "+(1===b?"2":"1")+" (slot "+getSlotDesc(d)+"): "+(a?a.rom.source:"EMPTY"),!0))},this.expansionInserted=function(a){return slotSocket.slotInserted(a?WMSX.EXPANSION2_SLOT:WMSX.EXPANSION1_SLOT)}}function CartridgeSocket(){this.insertCartridge=function(a,b,c,d){var e=1===b?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT;slotSocket.insertSlot(a,e,c,!0),this.fireCartridgesStateUpdate(),d||self.showOSD("Cartridge "+(1===b?"2":"1")+": "+(a?a.rom.source:"EMPTY"),!0)},this.removeCartridge=function(a,b){var c=1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT;return null===slotSocket.slotInserted(c)?(self.showOSD("No Cartridge in Slot "+(1===a?"2":"1"),!0,!0),!1):(slotSocket.insertSlot(null,c,b,!0),this.fireCartridgesStateUpdate(),self.showOSD("Cartridge "+(1===a?"2":"1")+" removed",!0),!0)},this.cartridgeInserted=function(a){return slotSocket.slotInserted(1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT)},this.dataOperationNotSupportedMessage=function(a,b,c){var d=1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT,e=slotSocket.slotInserted(d);return null===e?(c||self.showOSD("No Cartridge in Slot "+(1===a?"2":"1"),!0,!0),!0):!e.getDataDesc()&&(c||self.showOSD("Data "+(b?"Saving":"Loading")+" not supported for Cartridge "+(1===a?"2":"1"),!0,!0),!0)},this.loadCartridgeData=function(a,b,c){var d=1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT,e=slotSocket.slotInserted(d);if(e&&e.loadData(wmsx.Util.leafFilename(b),c))return self.showOSD(e.getDataDesc()+" loaded in Cartridge "+(1===a?"2":"1"),!0),c},this.getCartridgeData=function(a){if(!this.dataOperationNotSupportedMessage(a,!0,!1)){return slotSocket.slotInserted(1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT).getDataToSave()}},this.fireCartridgesStateUpdate=function(){for(var a=0;a<b.length;a++)b[a].cartridgesStateUpdate()},this.fireCartridgesModifiedStateUpdate=function(){a&&a.cartridgesModifiedStateUpdate(slotSocket.slotInserted(WMSX.CARTRIDGE1_SLOT),slotSocket.slotInserted(WMSX.CARTRIDGE2_SLOT))},this.addCartridgesStateListener=function(a,c){b.indexOf(a)<0&&(b.push(a),c||a.cartridgesStateUpdate())},this.setCartridgesModifiedStateListener=function(b){a=b,this.fireCartridgesModifiedStateUpdate()},this.hasAnyMediaInserted=function(){return slotSocket.slotInserted(WMSX.CARTRIDGE1_SLOT)||slotSocket.slotInserted(WMSX.CARTRIDGE2_SLOT)};var a,b=[]}function SlotSocket(){this.insertSlot=function(a,b,c,d){var e=self.powerIsOn;e&&!c&&self.powerOff(),insertSlot(a,b),c||!a&&!e?a&&self.powerIsOn&&a.powerOn():self.userPowerOn(!1),d||saveStateSocket.externalStateChange()},this.slotInserted=function(a){var b=getSlot(a);return b===EMPTY_SLOT?null:b},this.getSlotDesc=function(a){return getSlotDesc(a)}}function AudioSocket(){this.connectMonitor=function(b){a=b;for(var d=c.length-1;d>=0;d--)a.connectAudioSignal(c[d])},this.connectAudioSignal=function(d){c.indexOf(d)>=0||(wmsx.Util.arrayAdd(c,d),this.flushAllSignals(),d.setFps(b),a&&a.connectAudioSignal(d))},this.disconnectAudioSignal=function(b){wmsx.Util.arrayRemoveAllElement(c,b),a&&a.disconnectAudioSignal(b)},this.audioClockPulse32=function(){for(var a=c.length-1;a>=0;--a)c[a].audioClockPulse()},this.audioFinishFrame=function(){for(var a=c.length-1;a>=0;--a)c[a].audioFinishFrame()},this.muteAudio=function(){a&&a.mute()},this.unMuteAudio=function(){a&&a.unMute()},this.setFps=function(a){b=a
;for(var d=c.length-1;d>=0;--d)c[d].setFps(b)},this.pauseAudio=function(){a&&a.pauseAudio()},this.unpauseAudio=function(){a&&a.unpauseAudio()},this.flushAllSignals=function(){for(var a=c.length-1;a>=0;--a)c[a].flush()};var a,b,c=[]}function CassetteSocket(){this.connectDeck=function(b){a=b},this.connectDriver=function(a){b=a},this.getDeck=function(){return a},this.getDriver=function(){return b},this.autoPowerCycle=function(a){b&&b.currentAutoRunCommand()&&(self.powerIsOn||a||self.userPowerOn(!0))},this.typeAutoRunCommand=function(){b&&b.typeCurrentAutoRunCommand()};var a,b}function DiskDriveSocket(){this.connectDrive=function(a){b=a},this.getDrive=function(){return b},this.autoPowerCycle=function(a){self.powerIsOn||a||self.userPowerOn(!1)},this.diskInterfaceConnected=function(a){c.add(a),this.fireInterfacesChangeUpdate()},this.diskInterfaceDisconnected=function(a){c.delete(a),this.fireInterfacesChangeUpdate()},this.hardDiskInterfaceConnected=function(a){d.add(a),this.fireInterfacesChangeUpdate()},this.hardDiskInterfaceDisconnected=function(a){d.delete(a),this.fireInterfacesChangeUpdate()},this.dos2ROMConnected=function(a){e.add(a)},this.dos2ROMDisconnected=function(a){e.delete(a)},this.hasDiskInterface=function(){return c.size>0},this.hasHardDiskInterface=function(){return d.size>0},this.hasDOS2=function(){return e.size>0||d.size>0},this.setInterfacesChangeListener=function(b){a=b,this.fireInterfacesChangeUpdate()},this.fireInterfacesChangeUpdate=function(){a&&a.diskInterfacesStateUpdate(this.hasDiskInterface(),this.hasHardDiskInterface())},this.hasAnyMediaInserted=function(){return this.getDrive().hasAnyMediaInserted()};var a,b,c=new Set,d=new Set,e=new Set}function ControllersSocket(){this.connectControls=function(b){a=b},this.readKeyboardPort=function(b){return a.readKeyboardPort(b)},this.readControllerPort=function(b){return a.readControllerPort(b)},this.writeControllerPin8Port=function(b,c){a.writeControllerPin8Port(b,c)},this.releaseControllers=function(){a.releaseControllers()},this.resetControllers=function(){a.resetControllers()},this.getBUSCycles=function(){return cpu.getBUSCycles()},this.saveState=function(){return a.saveState()},this.loadState=function(b){a.loadState(b)};var a}function MachineControlsSocket(){this.controlStateChanged=function(a,b,c,d){controlStateChanged(a,b,c,d)},this.addPowerAndUserPauseStateListener=function(b){a.indexOf(b)>=0||(a.push(b),this.firePowerAndUserPauseStateUpdate())},this.firePowerAndUserPauseStateUpdate=function(){for(var b=0;b<a.length;++b)a[b].machinePowerAndUserPauseStateUpdate(self.powerIsOn,userPaused)},this.getControlReport=function(a){switch(a){case controls.VIDEO_STANDARD:return{label:videoStandardIsAuto?"Auto":videoStandard.name,active:!videoStandardIsAuto};case controls.CPU_TURBO_MODE:var b=cpu.getCPUTurboMulti(),c=cpuTurboMode<0?"OFF":0===cpuTurboMode?"Auto"+(1!==b?" "+b+"x":""):b+"x";return{label:c,active:b>1};case controls.VDP_TURBO_MODE:return b=vdp.getVDPTurboMulti(),{label:self.getVDPTurboModeDesc(),active:1!==b};case controls.SPRITE_MODE:return c=vdp.getSpriteDebugModeQuickDesc(),{label:c,active:"Normal"!==c};case controls.VSYNCH:return{label:vSynchMode<0?"DISABL":vSynchMode?"Auto":"OFF",active:0===vSynchMode}}return{label:"Unknown",active:!1}};var a=[]}function LedsSocket(){this.ledStateChanged=function(a,c){b[a]!==c&&(b[a]=c,this.fireLedsStateUpdate())},this.setLedsStateListener=function(b){a=b,this.fireLedsStateUpdate()},this.fireLedsStateUpdate=function(){a&&a.ledsStateUpdate(b[0],b[1])};var a,b=[!1,!1]}function SaveStateSocket(){this.connectMedia=function(b){a=b},this.saveState=function(c){if(self.powerIsOn&&a){var d=self.systemPause(!0);self.showOSD("Saving State "+c,!0);var e=saveState();e.v=b,a.persistState(c,e,function(a){a?self.showOSD("State "+c+" saved",!0):self.showOSD("State "+c+" save FAILED!",!0,!0),d||self.systemPause(!1)})}},this.loadState=function(b){if(a){var d=self.systemPause(!0);self.showOSD("Loading State "+b,!0),a.retrieveState(b,function(a){a?c[a.v]?(self.powerIsOn?self.reset(!0):self.powerOn(!0),loadState(a),WMSX.userPreferences.current.syncTimeLoadState&&rtc.syncTimeWithSource(),self.showOSD("State "+b+" loaded",!0)):self.showOSD("State "+b+" load failed. State version incompatible!",!0,!0):self.showOSD("State "+b+" not found!",!0,!0),d||self.systemPause(!1)})}},this.saveStateFile=function(){if(self.powerIsOn&&a){var c=self.systemPause(!0);self.showOSD("Saving State File",!0);var d=saveState();d.v=b,a.saveStateFile(d),c||self.systemPause(!1)}},this.loadStateFile=function(b){if(!a)return!1;self.showOSD("Loading State File",!0);var d=a.loadStateFile(b);return d?(wmsx.Util.log("State file loaded"),c[d.v]?(self.powerIsOn?self.reset(!0):self.powerOn(!0),loadState(d),self.showOSD("State File loaded",!0)):self.showOSD("State File load failed. State version incompatible!",!0,!0),!0):(self.showOSD(null,!0),!1)},this.externalStateChange=function(){a.externalStateChange()};var a,b=WMSX.STATE_VERSION,c=WMSX.STATE_VERSIONS_ACCEPTED}var self=this;this.socketsConnected=function(){self.updateMachineType(),self.setCPUTurboMode(cpuTurboMode),self.setVDPTurboMode(vdpTurboMode),self.setDefaults()},this.updateMachineType=function(){this.machineName=WMSX.MACHINE,this.machineType=WMSX.MACHINES_CONFIG[this.machineName].TYPE||3,vdp.setMachineType(this.machineType),rtc.setMachineType(this.machineType),syf.setMachineType(this.machineType),cpuTurboMode=1===WMSX.CPU_TURBO_MODE?2:WMSX.CPU_TURBO_MODE,vdpTurboMode=WMSX.VDP_TURBO_MODE,biosSocket.turboDriverTurboModesUpdate(),bus.refreshConnect(),machineTypeSocket.fireMachineTypeStateUpdate()},this.preStart=function(){extensionsSocket.refreshConfigFromSlots()},this.powerOn=function(a){this.powerIsOn&&this.powerOff(),bus.powerOn(),syf.powerOn(),rtc.powerOn(),ppi.powerOn(),psg.powerOn(),vdp.powerOn(),cpu.powerOn(),this.reset(a),this.powerIsOn=!0,a||machineControlsSocket.firePowerAndUserPauseStateUpdate()},this.powerOff=function(){cpu.powerOff(),vdp.powerOff(),psg.powerOff(),ppi.powerOff(),rtc.powerOff(),syf.powerOff(),bus.powerOff(),controllersSocket.resetControllers(),this.powerIsOn=!1,userPaused?this.userPause(!1):machineControlsSocket.firePowerAndUserPauseStateUpdate()},this.reset=function(a){videoStandardSoft=null,videoStandardIsAuto&&setVideoStandardAuto(),controllersSocket.resetControllers(),syf.reset(),rtc.reset(),ppi.reset(),psg.reset(),vdp.reset(),cpu.reset(),bus.reset(),audioSocket.flushAllSignals(),fastBootFrames>0&&(a?fastBootCountdown>0&&(alternateSpeed=null,videoClockUpdateSpeed()):(fastBootCountdown=fastBootFrames,alternateSpeed=SPEED_FAST,videoClockUpdateSpeed()))},this.userPowerOn=function(a){if(!isLoading){if(!bios)return void this.getVideoOutput().showOSD("Insert BIOS!",!0,!0);this.powerOn(),a&&typeBasicAutoRunCommand()}},this.videoClockPulse=function(){fastBootCountdown>0&&--fastBootCountdown<=0&&(alternateSpeed=null,videoClockUpdateSpeed()),rtc.videoClockPulse(),bios&&bios.getKeyboardExtension().keyboardExtensionClockPulse(),self.powerIsOn&&(userPaused&&userPauseMoreFrames--<=0||(vdp.videoClockPulse(),audioSocket.audioFinishFrame()))},this.getMachineTypeSocket=function(){return machineTypeSocket},this.getVideoClockSocket=function(){return videoClockSocket},this.getSlotSocket=function(){return slotSocket},this.getBIOSSocket=function(){return biosSocket},this.getExtensionsSocket=function(){return extensionsSocket},this.getExpansionSocket=function(){return expansionSocket},this.getCartridgeSocket=function(){return cartridgeSocket},this.getMachineControlsSocket=function(){return machineControlsSocket},this.getControllersSocket=function(){return controllersSocket},this.getVideoOutput=function(){return vdp.getVideoOutput()},this.getAudioSocket=function(){return audioSocket},this.getSavestateSocket=function(){return saveStateSocket},this.getCassetteSocket=function(){return cassetteSocket},this.getDiskDriveSocket=function(){
return diskDriveSocket},this.getLedsSocket=function(){return ledsSocket},this.showOSD=function(a,b,c){this.getVideoOutput().showOSD(a,b,c)},this.setVideoStandardSoft=function(a){videoStandardSoft=a,videoStandardIsAuto&&videoStandard!==a?setVideoStandard(a,!1,!0):videoStandardIsAuto||videoStandard===a||self.showOSD("Cannot change Video Standard. Its FORCED: "+videoStandard.desc,!0,!0)},this.setBIOS=function(a){bios=a===EMPTY_SLOT?null:a,videoStandardSoft=null,setVideoStandardAuto()},this.setLoading=function(a){isLoading=a},this.userPause=function(a,b){var c=userPaused;return userPaused!==a&&(userPaused=!!a,userPauseMoreFrames=-1,userPaused&&!b?audioSocket.muteAudio():audioSocket.unMuteAudio(),machineControlsSocket.firePowerAndUserPauseStateUpdate()),c},this.systemPause=function(a){var b=systemPaused;return systemPaused!==a&&(systemPaused=!!a,systemPaused?audioSocket.pauseAudio():audioSocket.unpauseAudio()),b},this.isSystemPaused=function(){return systemPaused},this.vSynchSetSupported=function(a){var b=WMSX.userPreferences.current.vSynch;setVSynchMode(-1!==WMSX.SCREEN_VSYNC_MODE&&a?WMSX.SCREEN_VSYNC_MODE>=0?WMSX.SCREEN_VSYNC_MODE:null!==b&&b>=0?b:1:-1,!0)},this.toggleCPUTurboMode=function(a){a?this.setCPUTurboMode(cpuTurboMode<0?8:0===cpuTurboMode?-1:cpuTurboMode<=1.5?0:cpuTurboMode<=2?1.5:(0|cpuTurboMode)-1):this.setCPUTurboMode(0===cpuTurboMode?1.5:cpuTurboMode<1?0:cpuTurboMode<1.5?1.5:1+(0|cpuTurboMode)),this.showCPUTurboModeMessage()},this.setCPUTurboMode=function(a){cpuTurboMode=a<0||a>8?-1:1===a?2:a,biosSocket.turboDriverTurboModesUpdate()},this.getCPUTurboMode=function(){return cpuTurboMode},this.showCPUTurboModeMessage=function(){self.showOSD("CPU Turbo: "+this.getCPUTurboModeDesc(),!0)},this.getCPUTurboModeDesc=function(){var a=cpuTurboMode<0?"OFF ":0===cpuTurboMode?"Auto ":"",b=cpu.getCPUTurboMulti();return a+=(1!==b?b+"x ":"")+"("+cpu.getCPUTurboFreqDesc()+")"},this.toggleVDPTurboMode=function(a){a?this.setVDPTurboMode(vdpTurboMode<0?9:2===vdpTurboMode?0:vdpTurboMode-1):this.setVDPTurboMode(vdpTurboMode+1),self.showOSD("VDP Engine Turbo: "+this.getVDPTurboModeDesc(),!0)},this.setVDPTurboMode=function(a){vdpTurboMode=a<0||a>9?-1:1===a?2:a,biosSocket.turboDriverTurboModesUpdate()},this.getVDPTurboMode=function(){return vdpTurboMode},this.getVDPTurboModeDesc=function(){var a=vdpTurboMode<0?"OFF ":0===vdpTurboMode?"Auto ":9===vdpTurboMode?"Instant":"",b=vdp.getVDPTurboMulti();return a+=b>1&&b<9?b+"x ":""},this.setDefaults=function(){setVideoStandardAuto(!1),vdp.setDefaults(),speedControl=defaultSpeed,alternateSpeed=null,videoClockUpdateSpeed()},this.saveState=saveState,this.loadState=loadState,this.machineName=null,this.machineType=0,this.powerIsOn=!1;var speedControl=1,alternateSpeed=!1,defaultSpeed=WMSX.SPEED>0?WMSX.SPEED/100:1,isLoading=!1,basicAutoRunDone=!1,basicAutoRunCommand,cpu,bus,ppi,vdp,psg,rtc,syf,userPaused=!1,userPauseMoreFrames=0,systemPaused=!1,machineTypeSocket,videoClockSocket,slotSocket,biosSocket,extensionsSocket,expansionSocket,cartridgeSocket,saveStateSocket,cassetteSocket,diskDriveSocket,machineControlsSocket,controllersSocket,audioSocket,ledsSocket,bios,videoStandard,videoStandardSoft,videoStandardIsAuto=!1,vSynchMode,fastBootFrames=WMSX.FAST_BOOT<=0?0:WMSX.FAST_BOOT>1?WMSX.FAST_BOOT:WMSX.BOOT_KEYS_FRAMES>0?WMSX.BOOT_KEYS_FRAMES:WMSX.BOOT_DURATION_AUTO,fastBootCountdown=0,cpuTurboMode=0,vdpTurboMode=0,EMPTY_SLOT=wmsx.SlotEmpty.singleton,SPEEDS=[.05,.1,.2,.3,.4,.5,.6,.7,.8,.9,1,1.1,1.25,1.5,2,3,5,10],SPEED_FAST=10,SPEED_SLOW=.3,controls=wmsx.MachineControls;this.eval=function(str){return eval(str)},init()},wmsx.Machine.BASE_CPU_CLOCK=3584160,wmsx.KeyboardKeys={D0:{m:[0,0],key:"D0",c_en:"0",cs_en:")",cs_ja:" "},D1:{m:[0,1],key:"D1",c_en:"1",cs_en:"!"},D2:{m:[0,2],key:"D2",c_en:"2",cs_en:"@",cs_ja:'"'},D3:{m:[0,3],key:"D3",c_en:"3",cs_en:"#"},D4:{m:[0,4],key:"D4",c_en:"4",cs_en:"$"},D5:{m:[0,5],key:"D5",c_en:"5",cs_en:"%"},D6:{m:[0,6],key:"D6",c_en:"6",cs_en:"^",cs_ja:"&"},D7:{m:[0,7],key:"D7",c_en:"7",cs_en:"&",cs_ja:"'"},D8:{m:[1,0],key:"D8",c_en:"8",cs_en:"*",cs_ja:"("},D9:{m:[1,1],key:"D9",c_en:"9",cs_en:"(",cs_ja:")"},MINUS:{m:[1,2],key:"MINUS",c_en:"-",cs_en:"_",cs_ja:"="},EQUAL:{m:[1,3],key:"EQUAL",c_en:"=",cs_en:"+",c_ja:"^",cs_ja:"~"},BACKSLASH:{m:[1,4],key:"BACKSLASH",c_en:"\\",cs_en:"|",c_ja:"&yen;",cs_ja:"|"},OPEN_BRACKET:{m:[1,5],key:"OPEN_BRACKET",c_en:"[",cs_en:"{",c_ja:"@",cs_ja:"`"},CLOSE_BRACKET:{m:[1,6],key:"CLOSE_BRACKET",c_en:"]",cs_en:"}",c_ja:"[",cs_ja:"{"},SEMICOLON:{m:[1,7],key:"SEMICOLON",c_en:";",cs_en:":",cs_ja:"+"},QUOTE:{m:[2,0],key:"QUOTE",c_en:"'",cs_en:'"',c_ja:":",cs_ja:"*"},BACKQUOTE:{m:[2,1],key:"BACKQUOTE",c_en:"`",cs_en:"~",c_ja:"]",cs_ja:"}"},COMMA:{m:[2,2],key:"COMMA",c_en:",",cs_en:"<"},PERIOD:{m:[2,3],key:"PERIOD",c_en:".",cs_en:">"},SLASH:{m:[2,4],key:"SLASH",c_en:"/",cs_en:"?"},DEAD:{m:[2,5],key:"DEAD",c_en:"à",cs_en:"á",c_ja:" ",cs_ja:"_",cns_en:"à",cns_ja:"_"},A:{m:[2,6],key:"A",c_en:"A"},B:{m:[2,7],key:"B",c_en:"B"},C:{m:[3,0],key:"C",c_en:"C"},D:{m:[3,1],key:"D",c_en:"D"},E:{m:[3,2],key:"E",c_en:"E"},F:{m:[3,3],key:"F",c_en:"F"},G:{m:[3,4],key:"G",c_en:"G"},H:{m:[3,5],key:"H",c_en:"H"},I:{m:[3,6],key:"I",c_en:"I"},J:{m:[3,7],key:"J",c_en:"J"},K:{m:[4,0],key:"K",c_en:"K"},L:{m:[4,1],key:"L",c_en:"L"},M:{m:[4,2],key:"M",c_en:"M"},N:{m:[4,3],key:"N",c_en:"N"},O:{m:[4,4],key:"O",c_en:"O"},P:{m:[4,5],key:"P",c_en:"P"},Q:{m:[4,6],key:"Q",c_en:"Q"},R:{m:[4,7],key:"R",c_en:"R"},S:{m:[5,0],key:"S",c_en:"S"},T:{m:[5,1],key:"T",c_en:"T"},U:{m:[5,2],key:"U",c_en:"U"},V:{m:[5,3],key:"V",c_en:"V"},W:{m:[5,4],key:"W",c_en:"W"},X:{m:[5,5],key:"X",c_en:"X"},Y:{m:[5,6],key:"Y",c_en:"Y"},Z:{m:[5,7],key:"Z",c_en:"Z"},SHIFT:{m:[6,0],key:"SHIFT",c_en:"SHF"},CONTROL:{m:[6,1],key:"CONTROL",c_en:"CTR"},CAPSLOCK:{m:[6,3],key:"CAPSLOCK",c_en:"CAP"},GRAPH:{m:[6,2],key:"GRAPH",c_en:"GRA"},CODE:{m:[6,4],key:"CODE",c_en:"COD",c_ja:"KANA",cs_ja:"KANA"},F1:{m:[6,5],key:"F1",c_en:"F1",cs_en:"F6"},F2:{m:[6,6],key:"F2",c_en:"F2",cs_en:"F7"},F3:{m:[6,7],key:"F3",c_en:"F3",cs_en:"F8"},F4:{m:[7,0],key:"F4",c_en:"F4",cs_en:"F9"},F5:{m:[7,1],key:"F5",c_en:"F5",cs_en:"F10"},ESCAPE:{m:[7,2],key:"ESCAPE",c_en:"ESC"},TAB:{m:[7,3],key:"TAB",c_en:"TAB"},STOP:{m:[7,4],key:"STOP",c_en:"STP"},BACKSPACE:{m:[7,5],key:"BACKSPACE",c_en:"BS"},SELECT:{m:[7,6],key:"SELECT",c_en:"SEL"},ENTER:{m:[7,7],key:"ENTER",c_en:"RET"},SPACE:{m:[8,0],key:"SPACE",c_en:"SPC"},HOME:{m:[8,1],key:"HOME",c_en:"HOM"},INSERT:{m:[8,2],key:"INSERT",c_en:"INS"},DELETE:{m:[8,3],key:"DELETE",c_en:"DEL"},LEFT:{m:[8,4],key:"LEFT",c_en:"LFT"},UP:{m:[8,5],key:"UP",c_en:"UP"},DOWN:{m:[8,6],key:"DOWN",c_en:"DWN"},RIGHT:{m:[8,7],key:"RIGHT",c_en:"RGH"},NUM_MULTIPLY:{m:[9,0],key:"NUM_MULTIPLY",c_en:"*"},NUM_PLUS:{m:[9,1],key:"NUM_PLUS",c_en:"+"},NUM_DIVIDE:{m:[9,2],key:"NUM_DIVIDE",c_en:"/"},NUM_0:{m:[9,3],key:"NUM_0",c_en:"0"},NUM_1:{m:[9,4],key:"NUM_1",c_en:"1"},NUM_2:{m:[9,5],key:"NUM_2",c_en:"2"},NUM_3:{m:[9,6],key:"NUM_3",c_en:"3"},NUM_4:{m:[9,7],key:"NUM_4",c_en:"4"},NUM_5:{m:[10,0],key:"NUM_5",c_en:"5"},NUM_6:{m:[10,1],key:"NUM_6",c_en:"6"},NUM_7:{m:[10,2],key:"NUM_7",c_en:"7"},NUM_8:{m:[10,3],key:"NUM_8",c_en:"8"},NUM_9:{m:[10,4],key:"NUM_9",c_en:"9"},NUM_MINUS:{m:[10,5],key:"NUM_MINUS",c_en:"-"},NUM_COMMA:{m:[10,6],key:"NUM_COMMA",c_en:","},NUM_PERIOD:{m:[10,7],key:"NUM_PERIOD",c_en:"."},YES:{m:[11,1],key:"YES",c_en:"YES",c_ja:"HAI",cs_ja:"HAI"},NO:{m:[11,3],key:"NO",c_en:"NO",c_ja:"IIE",cs_ja:"IIE"}},wmsx.JoystickButtons={J_UP:{button:"J_UP",mask:1,n:"UP"},J_DOWN:{button:"J_DOWN",mask:2,n:"DOWN"},J_LEFT:{button:"J_LEFT",mask:4,n:"LEFT"},J_RIGHT:{button:"J_RIGHT",mask:8,n:"RIGHT"},J_A:{button:"J_A",mask:16,n:"A"},J_B:{button:"J_B",mask:32,n:"B"},J_AB:{button:"J_AB",mask:48,n:"AB"},J_X:{button:"J_X",n:"X"},J_Y:{button:"J_Y",n:"Y"},J_L:{button:"J_L",n:"L"},J_R:{button:"J_R",n:"R"},J_BACK:{button:"J_BACK",n:"BACK"},J_START:{button:"J_START",n:"START"}},
wmsx.MachineControls={POWER:51,POWER_OFF:53,DEBUG:101,TRACE:102,PAUSE:103,FRAME:105,FAST_SPEED:111,INC_SPEED:113,DEC_SPEED:114,NORMAL_SPEED:115,MIN_SPEED:116,SPRITE_MODE:121,VIDEO_STANDARD:123,VSYNCH:124,CPU_TURBO_MODE:125,VDP_TURBO_MODE:126,DEFAULTS:130,SAVE_STATE_0:256,SAVE_STATE_1:257,SAVE_STATE_2:258,SAVE_STATE_3:259,SAVE_STATE_4:260,SAVE_STATE_5:261,SAVE_STATE_6:262,SAVE_STATE_7:263,SAVE_STATE_8:264,SAVE_STATE_9:265,SAVE_STATE_10:266,SAVE_STATE_11:267,SAVE_STATE_12:268,LOAD_STATE_0:512,LOAD_STATE_1:513,LOAD_STATE_2:514,LOAD_STATE_3:515,LOAD_STATE_4:516,LOAD_STATE_5:517,LOAD_STATE_6:518,LOAD_STATE_7:519,LOAD_STATE_8:520,LOAD_STATE_9:521,LOAD_STATE_10:522,LOAD_STATE_11:523,LOAD_STATE_12:524,SAVE_STATE_FILE:201,TYPE_STRING:301},wmsx.Images={embedded:!1,count:5,urls:{logo:WMSX.IMAGES_PATH+"logo.png",sprites:WMSX.IMAGES_PATH+"sprites.png",loading:WMSX.IMAGES_PATH+"loading.gif",mouseCursor:WMSX.IMAGES_PATH+"mouse-cursor.png",logoMiniBrightBack:WMSX.IMAGES_PATH+"logo-mini-bright-back.png"}},WMSX.userPreferences={},WMSX.userPreferences.currentVersion=50,WMSX.userPreferences.compatibleVersions=new Set([50]),WMSX.userPreferences.defaults=function(){"use strict";var a=wmsx.KeyboardKeys,b=wmsx.JoystickButtons,c=wmsx.DOMKeys,d=wmsx.GamepadButtons;return{hostKeyboard:{en:void 0,ja:void 0},customHostKeyboards:{en:{},ja:{}},customHostKeys:{nextCode:1001,keys:[]},joysticks:[{buttons:{J_UP:[d.GB_UP],J_DOWN:[d.GB_DOWN],J_LEFT:[d.GB_LEFT],J_RIGHT:[d.GB_RIGHT],J_A:[d.GB_1,d.GB_3],J_B:[d.GB_2,d.GB_3],J_X:[],J_Y:[],J_L:[d.GB_L1,d.GB_L2],J_R:[d.GB_R1,d.GB_R2],J_BACK:[d.GB_BACK],J_START:[d.GB_START]},virtualButtonsKeys:{J_X:[],J_Y:[],J_L:[{wc:c.VK_F12.wc|c.SHIFT,n:["Shift","F12"]}],J_R:[c.VK_F12],J_BACK:[c.VK_ESCAPE],J_START:[{wc:c.VK_P.wc|c.ALT,n:["Alt","P"]}]},settings:{device:-1,xAxis:0,xAxisSig:1,yAxis:1,yAxisSig:1,deadzone:.3}},{buttons:{J_UP:[d.GB_UP],J_DOWN:[d.GB_DOWN],J_LEFT:[d.GB_LEFT],J_RIGHT:[d.GB_RIGHT],J_A:[d.GB_1,d.GB_3],J_B:[d.GB_2,d.GB_3],J_X:[],J_Y:[],J_L:[d.GB_L1,d.GB_L2],J_R:[d.GB_R1,d.GB_R2],J_BACK:[d.GB_BACK],J_START:[d.GB_START]},virtualButtonsKeys:{J_X:[],J_Y:[],J_L:[{wc:c.VK_F12.wc|c.SHIFT,n:["Shift","F12"]}],J_R:[c.VK_F12],J_BACK:[c.VK_ESCAPE],J_START:[{wc:c.VK_P.wc|c.ALT,n:["Alt","P"]}]},settings:{device:-1,xAxis:0,xAxisSig:1,yAxis:1,yAxisSig:1,deadzone:.3}}],joykeys:[{buttons:{J_UP:[c.VK_UP],J_DOWN:[c.VK_DOWN],J_LEFT:[c.VK_LEFT],J_RIGHT:[c.VK_RIGHT],J_A:[c.VK_SPACE,c.VK_LSHIFT,c.VK_INSERT],J_B:[c.VK_M,c.VK_LCONTROL,c.VK_DELETE]}},{buttons:{J_UP:[c.VK_T],J_DOWN:[c.VK_G],J_LEFT:[c.VK_F],J_RIGHT:[c.VK_H],J_A:[c.VK_A],J_B:[c.VK_Z]}}],touch:{directional:"JOYSTICK",directionalBig:!1,mirrored:!1,buttons:{T_A:b.J_A,T_B:b.J_B,T_C:b.J_AB,T_D:a.ESCAPE,T_E:a.SPACE,T_F:a.F1,T_G:a.ENTER,T_X:null,T_Y:null}},vSynch:1,crtFilter:-1,crtScanlines:0,hapticFeedback:!0,audioBufferBase:-1,netPlaySessionName:"",netPlayNick:"",syncTimeLoadState:!1}},WMSX.userPreferences.load=function(){var a;try{a=JSON.parse(localStorage["wmsxprefs"+this.getEnvSuffix()]||"{}"),a.version&&delete a.version}catch(a){}if(!a||!WMSX.userPreferences.compatibleVersions.has(a.prefsVersion)){a={}}var b=WMSX.userPreferences.defaults();for(var c in b)void 0===a[c]&&(a[c]=b[c]);a.prefsVersion=WMSX.userPreferences.currentVersion,WMSX.userPreferences.current=a,wmsx.DOMKeys.initPreferences()},WMSX.userPreferences.save=function(){if(WMSX.userPreferences.isDirty)try{WMSX.userPreferences.current.wmsxVersion=WMSX.VERSION,localStorage["wmsxprefs"+this.getEnvSuffix()]=JSON.stringify(WMSX.userPreferences.current),delete WMSX.userPreferences.isDirty,wmsx.Util.log("Preferences saved!")}catch(a){}},WMSX.userPreferences.getEnvSuffix=function(){return void 0===this.envSuffix&&(this.envSuffix=WMSX.ENVIRONMENT?"_"+WMSX.ENVIRONMENT:""),this.envSuffix},WMSX.userPreferences.setDirty=function(){WMSX.userPreferences.isDirty=!0},WMSX.userROMFormats={init:function(){wmsx.SlotCreator.setUserROMFormats(this),this.userFormats=JSON.parse(localStorage.wmsxuserformats||"{}")},getForROM:function(a){return this.userFormats[a.info.h]},setForROM:function(a,b,c){a.info.h&&(c?delete this.userFormats[a.info.h]:this.userFormats[a.info.h]=b,localStorage.wmsxuserformats=JSON.stringify(this.userFormats))}},wmsx.Clock=function(clockPulse){"use strict";this.connect=function(a){a.connectClock(this)},this.go=function(){running||(useRequestAnimationFrame=vSynch&&cyclesPerSecond===this.getVSynchNativeFrequency(),running=!0,useRequestAnimationFrame?animationFrame=requestAnimationFrame(pulse):interval=setInterval(pulse,cycleTimeMs))},this.pause=function(){running=!1,animationFrame&&(cancelAnimationFrame(animationFrame),animationFrame=null),interval&&(clearInterval(interval),interval=null)},this.setFrequency=function(a,b){running?(this.pause(),internalSetFrequency(a,b),this.go()):internalSetFrequency(a,b)},this.setVSynch=function(a){running?(this.pause(),vSynch=a,this.go()):vSynch=a},this.getVSynchNativeFrequency=function(){return vSynchAltNativeFrequency||vSynchNativeFrequency},this.setVSynchAltNativeFrequency=function(a){vSynchAltNativeFrequency=a},this.isVSynchActive=function(){return useRequestAnimationFrame},this.getRealTime=function(){return Date.now()-60*(new Date).getTimezoneOffset()*1e3};var internalSetFrequency=function(a,b){cyclesPerSecond=a,cycleTimeMs=1e3/a,divider=b>=1?b:1,dividerCounter>divider&&(dividerCounter=divider)},pulse=function(){animationFrame=null,divider>1?--dividerCounter<=0&&(dividerCounter=divider,clockPulse()):clockPulse(),useRequestAnimationFrame&&!animationFrame&&(animationFrame=requestAnimationFrame(pulse))};this.detectHostNativeFPSAndCallback=function(a){function b(){vSynchNativeFrequency=-1,wmsx.Util.error("Could not detect video native frequency. VSync DISABLED!"),a&&a(vSynchNativeFrequency)}if(-1===WMSX.SCREEN_VSYNC_MODE)return wmsx.Util.warning("Video native VSync disabled in configuration"),void(a&&a(vSynchNativeFrequency));if(-1!==WMSX.SCREEN_FORCE_HOST_NATIVE_FPS)return wmsx.Util.warning("Host video frequency forced in configuration: "+WMSX.SCREEN_FORCE_HOST_NATIVE_FPS),void(a&&a(vSynchNativeFrequency));if(!window.requestAnimationFrame)return b();var c=0,d=0,e=0,f=0,g=0,h=0,i=function(){if(e>=12||f>=18||g>=14||h>=18)return vSynchNativeFrequency=e>=12?60:f>=18?50:g>=14?120:100,wmsx.Util.log("Video native frequency detected: "+vSynchNativeFrequency+"Hz"),void(a&&a(vSynchNativeFrequency));if(!(++c<=70))return b();var j=wmsx.Util.performanceNow(),k=1e3/(j-d);d=j,k>=47&&k<=53&&f++,k>=56.4&&k<=63.6&&e++,k>=112.8&&k<=127.2&&g++,k>=94&&k<=106&&h++,requestAnimationFrame(i)};i()},this.eval=function(str){return eval(str)};var running=!1,cyclesPerSecond=1,cycleTimeMs=1e3,divider=1,dividerCounter=1,useRequestAnimationFrame,animationFrame=null,interval=null,vSynch=!0,vSynchNativeFrequency=-1===WMSX.SCREEN_VSYNC_MODE?-1:WMSX.SCREEN_FORCE_HOST_NATIVE_FPS,vSynchAltNativeFrequency=void 0};wmsx.FileLoader=function(a){"use strict";function b(a,b,c,d,e){return z.loadAsDiskFromFiles(c,a,p.createTreeFromZip(b),d,e)}function c(a,b,c,d){return z.loadAsDiskFromFiles(b,null,a,c,d)}function d(a,b,c,d,f,g,h){if((b===P.DISK||b===P.AUTO)&&z.loadDiskStackFromFiles(c,a,d,f,h))return!0;if(b!==P.DISK)for(var i=0;i<a.length;i++)if(e(a[i],b,c,d,f,g,h))return!0;return!1}function e(a,b,c,d,g,h,i,j){try{i&&!a.content&&(a.content=a.asUint8Array());var k=a.content;if(!j){var l=wmsx.Util.checkContentIsZIP(k);if(l){for(var m=wmsx.Util.getZIPFilesSorted(l),n=0;n<m.length;n++)if(e(m[n],b,c,d,g,h,!0,!0))return!0;return!1}}var o=wmsx.Util.checkContentIsGZIP(k);if(o)return e({name:a.name,content:o},b,c,d,g,h,!1,!0)}catch(a){return wmsx.Util.error(a),!1}return f(a.name,k,b,c,d,g,h)}function f(a,b,c,d,e,f,g){if(c=c||P.AUTO,d=d<0?-d:void 0===d?0:d,(c===P.TAPE||c===P.AUTO)&&y.loadTapeFile(a,b,e))return!0;if((c===P.STATE||c===P.AUTO)&&u.loadStateFile(b))return!0;if((c===P.CART_DATA||c===P.AUTO)&&x.loadCartridgeData(d,a,b))return!0;if(c===P.ROM||c===P.AUTO){
var h=wmsx.SlotCreator.createFromROM(new wmsx.ROM(a,b,null,g),x.cartridgeInserted(d));if(h)return h.format===wmsx.SlotFormats.BIOS?s.insertBIOS(h,e):h.format===wmsx.SlotFormats.MSX2BIOSExt?s.insertBIOSEXT(h,e):f?t.insertExpansion(h,d,e):x.insertCartridge(h,d,e),!0}return!1}function g(a,b,c,d,e,f){var g=wmsx.SlotCreator.createFromROM(new wmsx.ROM(a,b,null,e));return!!g&&(r.insertSlot(g,c,d,f),!0)}function h(a){if(a.returnValue=!1,a.preventDefault(),a.stopPropagation(),a.target.focus(),this.files&&0!==this.files.length){var b=wmsx.Util.asNormalArray(this.files);try{A.value=""}catch(a){}var c=q.systemPause(!0),d=function(a){c||q.systemPause(!1)};return b&&b.length>0&&(1===b.length?p.readFromFile(b[0],C,G,H,I,d):p.readFromFiles(b,C,G,H,I,d)),!1}}function i(a){if(a.returnValue=!1,a.preventDefault(),a.stopPropagation(),!J&&a.dataTransfer){var b=(a.shiftKey?L:0)|(a.ctrlKey?M:0)|(a.altKey?N:0)|(a.buttons&K?O:0);j(a.target,b),a.dataTransfer.dropEffect=!D||D.disabled?"none":"link",F&&clearTimeout(F),F=setTimeout(k,250)}}function j(a,b){if(a&&w.mediaChangeDisabledWarning())a=void 0;else for(;a&&!a.wmsxDropInfo;)a=a.parentElement;if(a){var c=a.wmsxDropInfo;c.subFiles&&b&N?c=c.subFiles:c.subAdd&&b&M&&(c=c.subAdd)}if(D!==c||E!==b){if(D!==c){if(D){D.element.classList.remove("wmsx-selected");var d=D.mainEle;d&&d.classList.remove("wmsx-selected")}D=c,D&&(D.element.classList.add("wmsx-selected"),(d=D.mainEle)&&d.classList.add("wmsx-selected"))}E=b;var e;D&&(e=b&L&&D.mesSec?D.mesSec:D.mes,D.files&&b&M&&(e+=" (do not expand ZIP contents)"),b&O&&(e+=" - no Reset")),v.setFileLoaderDragMessage(e)}}function k(){j(void 0,0),F=void 0}function l(a){if(a.returnValue=!1,a.preventDefault(),a.target.focus(),J||!D||D.disabled||!a.dataTransfer)return k();var b=D,c=E;k();var d=c&O,e=b.files||c&N,f=b.add||c&M,g=void 0!==b.port?b.port:c&L?-1:void 0,h=b.openType;!e||h!==P.DISK&&h!==P.AUTO||(h=f?P.FILES_AS_DISK:P.AUTO_AS_DISK);var i=a.dataTransfer&&a.dataTransfer.files,j=q.systemPause(!0),l=function(a){j||q.systemPause(!1)};if(i&&i.length>0)1===i.length?p.readFromFile(i[0],h,g,d,f,l):p.readFromFiles(i,h,g,d,f,l);else{var m=a.dataTransfer.getData("text");m&&m.length>0?p.readFromURL(m,h,g,d,f,l):l()}}function m(a){if(!a||!a.trim())return a;var b=a.lastIndexOf(".");return(b>0?a.substring(0,b):a).trim()}function n(a){wmsx.Util.message("Could not load file(s):\n\n"+a+"\n")}function o(){A=document.createElement("input"),A.id="wmsx-file-loader-input",A.type="file",A.multiple=!0,A.accept=Q.AUTO,A.style.display="none",A.addEventListener("change",h),B.appendChild(A)}var p=this;this.connect=function(a){q=a,r=q.getSlotSocket(),s=q.getBIOSSocket(),q.getExtensionsSocket().connectFileLoader(this),t=q.getExpansionSocket(),u=q.getSavestateSocket()},this.connectPeripherals=function(a,b,c,d,e){v=a,w=b,x=c,y=d,z=e},this.registerForDnD=function(a){a.addEventListener("dragover",i,!1),a.addEventListener("drop",l,!1)},this.registerForFileInputElement=function(a){B=a},this.openFileChooserDialog=function(a,b,c,d){A||o(),A.multiple=R[P[a]||P.AUTO]&&!(a===P.DISK&&2===c),A.accept=Q[P[a]||P.AUTO],C=a,G=c,H=b,I=d,A.click()},this.openURLChooserDialog=function(a,b,c,d){var e;try{e=localStorage&&localStorage[T]}catch(a){}var f=q.systemPause(!0);if(e=prompt("Load file from URL:",e||""),e=e&&e.toString().trim()){try{localStorage[T]=e}catch(a){}this.readFromURL(e,a,c,b,d,function(){f||q.systemPause(!1)})}else f||q.systemPause(!1)},this.readFromFile=function(a,b,c,d,e,f){wmsx.Util.log("Reading file: "+a.name);var g=new FileReader;g.onload=function(g){var h=new Uint8Array(g.target.result),i={name:a.name,content:h,lastModifiedDate:a.lastModified?new Date(a.lastModified):a.lastModifiedDate};p.loadFromFile(i,b,c,d,e),f&&f(!0)},g.onerror=function(a){n("File reading error: "+a.target.error.name+U),f&&f(!1)},g.readAsArrayBuffer(a)},this.readFromURL=function(a,b,c,d,e,f){new wmsx.MultiDownloader([{url:a}],function(g){var h={name:a,content:g[0].content,lastModifiedDate:null};p.loadFromFile(h,b,c,d,e),f&&f(!0)},function(a){n("URL reading error: "+a.error),f&&f(!1)}).start()},this.readFromFiles=function(a,b,c,d,e,f){new wmsx.MultiFileReader(a,function(a){p.loadFromFiles(a,b,c,d,e),f&&f(!0)},function(a,b,c){c||(b+=U),n("File reading error: "+b),f&&f(!1)},b===P.AUTO_AS_DISK||b===P.FILES_AS_DISK||b===P.ZIP_AS_DISK?-1:void 0).start()},this.loadFromContent=function(a,b,c,d,e,f,g){return this.loadFromFile({name:a,content:b},c,d,e,f,g)},this.loadFromFile=function(a,e,f,g,h,i){var j,k;if(e===P.AUTO_AS_DISK||e===P.FILES_AS_DISK||e===P.ZIP_AS_DISK){try{if(e===P.FILES_AS_DISK){if(c([a],f,g,h))return}else if(j=wmsx.Util.checkContentIsZIP(a.content)){if(b(m(a.name),j,f,g,h))return}else if(e===P.ZIP_AS_DISK)k="Not a ZIP file!";else if(c([a],f,g,h))return}catch(a){a.wmsx&&(k=a.message)}n("Error loading "+S[e]+(k?": "+k:""))}else{if(j=wmsx.Util.checkContentIsZIP(a.content))try{if(d(wmsx.Util.getZIPFilesSorted(j),e,f,g,h,i,!0))return;if(e===P.AUTO&&b(m(a.name),j,f,g,h))return}catch(a){wmsx.Util.error(a)}else if(d([a],e,f,g,h,i,!1))return;n("No valid "+S[e]+" found.")}},this.loadFromFiles=function(a,b,e,f,g){if(a=wmsx.Util.asNormalArray(a).slice(0),a.sort(function(a,b){return a.name<b.name?-1:a.name>b.name?1:0}),b===P.AUTO_AS_DISK||b===P.FILES_AS_DISK||b===P.ZIP_AS_DISK){var h;try{if(c(a,e,f,g))return}catch(a){a.wmsx&&(h=a.message)}n("Error loading "+S[b]+(h?": "+h:""))}else{if(d(a,b,e,f,g,null,!1))return;n("No valid "+S[b]+" found.")}},this.loadFromContentAsSlot=function(a,b,c,d,e,f){var h=wmsx.Util.checkContentIsZIP(b);if(h)try{for(var i=wmsx.Util.getZIPFilesSorted(h),j=0;j<i.length;j++)if(g(a,i[j].asUint8Array(),c,d,e,f))return}catch(a){}else if(g(a,b,c,d,e,f))return;n("Unsupported ROM file!")},this.createTreeFromZip=function(a){var b=[],c=a.folder(/.+/);c=c.filter(function(a){return a.dir&&a.name&&a.name.trim()}),c.sort(function(a,b){return void 0===a.dirDepth&&(a.dirDepth=wmsx.Util.stringCountOccurrences(a.name,"/")),void 0===b.dirDepth&&(b.dirDepth=wmsx.Util.stringCountOccurrences(b.name,"/")),a.dirDepth-b.dirDepth});for(var d=0;d<c.length;++d)!function(a){for(var c=a.name.split("/"),d=b,e=0;e<c.length-1;++e){var f=c[e],g=d.find(function(a){return a.isDir&&a.name==f});g||(g={isDir:!0,name:f,lastModifiedDate:a.date,items:[]},d.push(g)),d=g.items}}(c[d]);for(var e=a.file(/.+/).filter(function(a){return!a.dir&&a.name&&a.name.trim()}),f=0;f<e.length;++f)!function(a){for(var c=a.name.split("/"),d=b,e=0;e<c.length-1;++e){var f=c[e],g=d.find(function(a){return a.isDir&&a.name==f});g||(g={isDir:!0,name:f,lastModifiedDate:a.date,items:[]},d.push(g)),d=g.items}var h=c[c.length-1];h&&h.trim()&&(a.name=h,a.isDir=!1,a.lastModifiedDate=a.date,a.content=a.asUint8Array(),d.push(a))}(e[f]);return b},this.setDragAndDropDisabled=function(a){J=!!a};var q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G=0,H=!1,I=!1,J=!1,K=2,L=1,M=2,N=4,O=8,P=wmsx.FileLoader.OPEN_TYPE;this.OPEN_TYPE=P;var Q={ROM:".bin,.BIN,.rom,.ROM,.bios,.BIOS,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP",DISK:".bin,.BIN,.dsk,.DSK,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP",TAPE:".bin,.BIN,.cas,.CAS,.tape,.TAPE,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP",STATE:".wst,.WST",CART_DATA:".pac,.PAC,.dat,.DAT,.sram,.SRAM",FILES_AS_DISK:"",ZIP_AS_DISK:".zip,.ZIP",AUTO_AS_DISK:"",AUTO:".bin,.BIN,.dsk,.DSK,.rom,.ROM,.bios,.BIOS,.cas,.CAS,.tape,.TAPE,.wst,.WST,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP"},R={ROM:!1,DISK:!0,TAPE:!1,STATE:!1,CART_DATA:!1,FILES_AS_DISK:!0,ZIP_AS_DISK:!1,AUTO_AS_DISK:!0,AUTO:!1},S={ROM:"ROM",DISK:"Disk",TAPE:"Cassette",STATE:"Savestate",CART_DATA:"Cartridge Data",FILES_AS_DISK:"Files",ZIP_AS_DISK:"ZIP Contents",AUTO_AS_DISK:"Files",AUTO:"ROM, Cassette or Disk"},T="wmsxlasturl",U="\n\nIMPORTANT: Directories are not supported for loading!\nPlease use a ZIP File if you need directories support.";WMSX.fileLoader=this},wmsx.FileLoader.OPEN_TYPE={AUTO:"AUTO",ROM:"ROM",DISK:"DISK",TAPE:"TAPE",STATE:"STATE",CART_DATA:"CART_DATA",FILES_AS_DISK:"FILES_AS_DISK",
ZIP_AS_DISK:"ZIP_AS_DISK",AUTO_AS_DISK:"AUTO_AS_DISK"},wmsx.FileDownloader=function(){"use strict";function a(){if("NONE"===c)return alert("Unfortunately file saving in WebApps is broken in this version of iOS. The file could not be saved. If you really need to save a file, you must run WebMSX on the official homepage."),!0}function b(){"NONE"!==(c=wmsx.Util.isIOSDevice()?wmsx.Util.isBrowserStandaloneMode()?"NONE":"DATA":"SAFARI"===wmsx.Util.browserInfo().name?"DATA":"BLOB")&&(d=document.createElement("a"),d.style.display="none",d.target="_blank",d.href="#",e.appendChild(d))}this.connectPeripherals=function(a){f=a},this.registerForDownloadElement=function(a){e=a},this.startDownloadBinary=function(e,g,h){try{if(c||b(),a())return!1;var i;if("BLOB"===c){d.href&&(window.URL||window.webkitURL).revokeObjectURL(d.href);var j=new Blob([g],{type:"data:application/octet-stream"});i=(window.URL||window.webkitURL).createObjectURL(j)}else i="data:application/octet-stream;base64,"+btoa("string"==typeof g?g:wmsx.Util.int8BitArrayToByteString(g));return d.download=e&&e.trim(),d.href=i,d.click(),f.showOSD(h+" saved",!0),!0}catch(a){return f.showOSD(h+" save FAILED!",!0,!0),wmsx.Util.error(a),!1}},this.startDownloadURL=function(e,g,h){try{if(c||b(),a())return;"BLOB"===c&&d.href&&(window.URL||window.webkitURL).revokeObjectURL(d.href),d.download=e&&e.trim(),d.href=g,d.click(),f.showOSD(h+" saved",!0)}catch(a){f.showOSD(h+" save FAILED!",!0,!0),wmsx.Util.error(a)}};var c,d,e,f},wmsx.DOMKeys={keys:{},keysByCode:{},keysByLegacyCode:{},SHIFT:65536,CONTROL:131072,ALT:262144,META:524288,LOCLEFT:1048576,LOCRIGHT:2097152,LOCNUM:3145728,LOC_BIT_SHIFT:20,nextCustomCode:10001},wmsx.DOMKeys.IGNORE_ALL_MODIFIERS_MASK=~(wmsx.DOMKeys.SHIFT|wmsx.DOMKeys.CONTROL|wmsx.DOMKeys.ALT|wmsx.DOMKeys.META),wmsx.DOMKeys.addKeyToIdentification=function(a){a.wc&&!a.a&&(this.keys[a.wc]=a,a.d&&(this.keysByCode[a.d]=a),a.c>0&&(this.keysByLegacyCode[a.c]=a))},function(a,b,c,d){a.VK_1={wc:1,d:"Digit1",c:49,n:"1"},a.VK_2={wc:2,d:"Digit2",c:50,n:"2"},a.VK_3={wc:3,d:"Digit3",c:51,n:"3"},a.VK_4={wc:4,d:"Digit4",c:52,n:"4"},a.VK_5={wc:5,d:"Digit5",c:53,n:"5"},a.VK_6={wc:6,d:"Digit6",c:54,n:"6"},a.VK_7={wc:7,d:"Digit7",c:55,n:"7"},a.VK_8={wc:8,d:"Digit8",c:56,n:"8"},a.VK_9={wc:9,d:"Digit9",c:57,n:"9"},a.VK_0={wc:10,d:"Digit0",c:48,n:"0"},a.VK_F1={wc:21,d:"F1",c:112,n:"F1"},a.VK_F2={wc:22,d:"F2",c:113,n:"F2"},a.VK_F3={wc:23,d:"F3",c:114,n:"F3"},a.VK_F4={wc:24,d:"F4",c:115,n:"F4"},a.VK_F5={wc:25,d:"F5",c:116,n:"F5"},a.VK_F6={wc:26,d:"F6",c:117,n:"F6"},a.VK_F7={wc:27,d:"F7",c:118,n:"F7"},a.VK_F8={wc:28,d:"F8",c:119,n:"F8"},a.VK_F9={wc:29,d:"F9",c:120,n:"F9"},a.VK_F10={wc:30,d:"F10",c:121,n:"F10"},a.VK_F11={wc:31,d:"F11",c:122,n:"F11"},a.VK_F12={wc:32,d:"F12",c:123,n:"F12"},a.VK_Q={wc:101,d:"KeyQ",c:81,n:"Q"},a.VK_W={wc:102,d:"KeyW",c:87,n:"W"},a.VK_E={wc:103,d:"KeyE",c:69,n:"E"},a.VK_R={wc:104,d:"KeyR",c:82,n:"R"},a.VK_T={wc:105,d:"KeyT",c:84,n:"T"},a.VK_Y={wc:106,d:"KeyY",c:89,n:"Y"},a.VK_U={wc:107,d:"KeyU",c:85,n:"U"},a.VK_I={wc:108,d:"KeyI",c:73,n:"I"},a.VK_O={wc:109,d:"KeyO",c:79,n:"O"},a.VK_P={wc:110,d:"KeyP",c:80,n:"P"},a.VK_A={wc:111,d:"KeyA",c:65,n:"A"},a.VK_S={wc:112,d:"KeyS",c:83,n:"S"},a.VK_D={wc:113,d:"KeyD",c:68,n:"D"},a.VK_F={wc:114,d:"KeyF",c:70,n:"F"},a.VK_G={wc:115,d:"KeyG",c:71,n:"G"},a.VK_H={wc:116,d:"KeyH",c:72,n:"H"},a.VK_J={wc:117,d:"KeyJ",c:74,n:"J"},a.VK_K={wc:118,d:"KeyK",c:75,n:"K"},a.VK_L={wc:119,d:"KeyL",c:76,n:"L"},a.VK_Z={wc:120,d:"KeyZ",c:90,n:"Z"},a.VK_X={wc:121,d:"KeyX",c:88,n:"X"},a.VK_C={wc:122,d:"KeyC",c:67,n:"C"},a.VK_V={wc:123,d:"KeyV",c:86,n:"V"},a.VK_B={wc:124,d:"KeyB",c:66,n:"B"},a.VK_N={wc:125,d:"KeyN",c:78,n:"N"},a.VK_M={wc:126,d:"KeyM",c:77,n:"M"},a.VK_ESCAPE={wc:201,d:"Escape",c:27,n:"Esc",fn:!0},a.VK_BACKSPACE={wc:202,d:"Backspace",c:8,n:"BackSpc",fn:!0},a.VK_TAB={wc:203,d:"Tab",c:9,n:"Tab",fn:!0},a.VK_ENTER={wc:204,d:"Enter",c:13,n:"Enter",fn:!0},a.VK_SPACE={wc:205,d:"Space",c:32,n:"Space",fn:!0},a.VK_BACKQUOTE={wc:221,d:"Backquote",c:192,n:"`"},a.VK_MINUS={wc:222,d:"Minus",c:189,n:"-"},a.VK_EQUALS={wc:223,d:"Equal",c:187,n:"="},a.VK_INT_YEN={wc:224,d:"IntlYen",c:-1,n:"Int ¥"},a.VK_OPEN_BRACKET={wc:225,d:"BracketLeft",c:219,n:"["},a.VK_CLOSE_BRACKET={wc:226,d:"BracketRight",c:221,n:"]"},a.VK_SEMICOLON={wc:227,d:"Semicolon",c:186,n:";"},a.VK_QUOTE={wc:228,d:"Quote",c:222,n:"'"},a.VK_BACKSLASH={wc:229,d:"Backslash",c:220,n:"\\"},a.VK_INT_BACKSLASH={wc:230,d:"IntlBackslash",c:226,n:"Int \\"},a.VK_COMMA={wc:231,d:"Comma",c:188,n:","},a.VK_PERIOD={wc:232,d:"Period",c:190,n:"."},a.VK_SLASH={wc:233,d:"Slash",c:191,n:"/"},a.VK_INT_RO={wc:234,d:"IntlRo",c:193,n:"Int ろ"},a.VK_INSERT={wc:251,d:"Insert",c:45,n:"Ins",fn:!0},a.VK_DELETE={wc:252,d:"Delete",c:46,n:"Del",fn:!0},a.VK_HOME={wc:253,d:"Home",c:36,n:"Home",fn:!0},a.VK_END={wc:254,d:"End",c:35,n:"End",fn:!0},a.VK_PAGE_UP={wc:255,d:"PageUp",c:33,n:"PgUp",fn:!0},a.VK_PAGE_DOWN={wc:256,d:"PageDown",c:34,n:"PgDown",fn:!0},a.VK_UP={wc:271,d:"ArrowUp",c:38,n:"Up",fn:!0},a.VK_DOWN={wc:272,d:"ArrowDown",c:40,n:"Down",fn:!0},a.VK_LEFT={wc:273,d:"ArrowLeft",c:37,n:"Left",fn:!0},a.VK_RIGHT={wc:274,d:"ArrowRight",c:39,n:"Right",fn:!0},a.VK_PRINT_SCREEN={wc:281,d:"PrintScreen",c:44,n:"PrtScr",fn:!0},a.VK_SCROLL_LOCK={wc:282,d:"ScrollLock",c:145,n:"ScrLck",fn:!0},a.VK_PAUSE={wc:283,d:"Pause",c:19,n:"Pause",fn:!0},a.VK_BREAK={wc:284,d:"",c:3,n:"Break",fn:!0},a.VK_CONTEXT={wc:285,d:"ContextMenu",c:93,n:"Context",fn:!0},a.VK_LSHIFT={wc:301,d:"ShiftLeft",c:16|b,n:"L-Shift",fn:!0},a.VK_LCONTROL={wc:302,d:"ControlLeft",c:17|b,n:"L-Control",fn:!0},a.VK_LALT={wc:303,d:"AltLeft",c:18|b,n:"L-Alt",fn:!0},a.VK_LMETA={wc:304,d:"MetaLeft",c:91|b,n:"L-Meta",fn:!0},a.VK_RSHIFT={wc:305,d:"ShiftRight",c:16|c,n:"R-Shift",fn:!0},a.VK_RCONTROL={wc:306,d:"ControlRight",c:17|c,n:"R-Control",fn:!0},a.VK_RALT={wc:307,d:"AltRight",c:18|c,n:"R-Alt",fn:!0},a.VK_RMETA={wc:308,d:"MetaRight",c:91|c,n:"R-Meta",fn:!0},a.VK_CAPS_LOCK={wc:309,d:"CapsLock",c:20,n:"CapsLock",fn:!0},a.VK_NON_CONVERT={wc:310,d:"NonConvert",c:29,n:"NonConvert",fn:!0},a.VK_CONVERT={wc:311,d:"Convert",c:28,n:"Convert",fn:!0},a.VK_KANA={wc:312,d:"KanaMode",c:-1,n:"Kana",fn:!0},a.VK_NUMLOCK={wc:401,d:"NumLock",c:144,n:"NumLock"},a.VK_NUM_COMMA={wc:402,d:"NumpadComma",c:110|d,n:"Num ,"},a.VK_NUM_DIVIDE={wc:403,d:"NumpadDivide",c:111|d,n:"Num /"},a.VK_NUM_MULTIPLY={wc:404,d:"NumpadMultiply",c:106|d,n:"Num *"},a.VK_NUM_MINUS={wc:405,d:"NumpadSubtract",c:109|d,n:"Num -"},a.VK_NUM_PLUS={wc:406,d:"NumpadAdd",c:107|d,n:"Num +"},a.VK_NUM_ENTER={wc:407,d:"NumpadEnter",c:13|d,n:"Num Enter",fn:!0},a.VK_NUM_PERIOD={wc:408,d:"NumpadDecimal",c:194|d,n:"Num .",fn:!0},a.VK_NUM_1={wc:421,d:"Numpad1",c:97|d,n:"Num 1",fn:!0},a.VK_NUM_2={wc:422,d:"Numpad2",c:98|d,n:"Num 2",fn:!0},a.VK_NUM_3={wc:423,d:"Numpad3",c:99|d,n:"Num 3",fn:!0},a.VK_NUM_4={wc:424,d:"Numpad4",c:100|d,n:"Num 4",fn:!0},a.VK_NUM_5={wc:425,d:"Numpad5",c:101|d,n:"Num 5",fn:!0},a.VK_NUM_6={wc:426,d:"Numpad6",c:102|d,n:"Num 6",fn:!0},a.VK_NUM_7={wc:427,d:"Numpad7",c:103|d,n:"Num 7",fn:!0},a.VK_NUM_8={wc:428,d:"Numpad8",c:104|d,n:"Num 8",fn:!0},a.VK_NUM_9={wc:429,d:"Numpad9",c:105|d,n:"Num 9",fn:!0},a.VK_NUM_0={wc:430,d:"Numpad0",c:96|d,n:"Num 0",fn:!0},a.VK_VOID={wc:-1,d:"",c:-1,n:"Unbound",fn:!0},a.VK_BR_QUOTE={wc:221,d:"Backquote",c:192,n:"'",a:"BR"},a.VK_BR_ACUTE={wc:225,d:"BracketLeft",c:219,n:"´",a:"BR"},a.VK_BR_OPEN_BRACKET={wc:226,d:"BracketRight",c:221,n:"[",a:"BR"},a.VK_BR_CEDILLA={wc:227,d:"Semicolon",c:186,n:"Ç",a:"BR"},a.VK_BR_TILDE={wc:228,d:"Quote",c:222,n:"~",a:"BR"},a.VK_BR_CLOSE_BRACKET={wc:229,d:"Backslash",c:220,n:"]",a:"BR"},a.VK_BR_SEMICOLON={wc:233,d:"Slash",c:191,n:";",a:"BR"},a.VK_BR_BACKSLASH={wc:230,d:"IntlBackslash",c:226,n:"\\",a:"BR"},a.VK_BR_SLASH={wc:234,d:"IntlRo",c:193,n:"/",a:"BR"},a.VK_JP_CIRCUMFLEX={wc:223,d:"Equal",c:187,n:"^",a:"JP"},a.VK_JP_YEN={wc:224,d:"IntlYen",c:-1,n:"¥",a:"JP"},a.VK_JP_ARROBA={wc:225,
d:"BracketLeft",c:219,n:"@",a:"JP"},a.VK_JP_OPEN_BRACKET={wc:226,d:"BracketRight",c:221,n:"[",a:"JP"},a.VK_JP_COLLON={wc:228,d:"Quote",c:222,n:":",a:"JP"},a.VK_JP_CLOSE_BRACKET={wc:229,d:"Backslash",c:220,n:"]",a:"JP"},a.VK_JP_RO={wc:234,d:"IntlRo",c:193,n:"\\ ろ",a:"JP"},a.VK_JP_NON_CONVERT={wc:310,d:"NonConvert",c:29,n:"NonConvert",fn:!0},a.VK_ES_ORDINAL={wc:221,d:"Backquote",c:192,n:"º",a:"ES"},a.VK_ES_QUOTE={wc:222,d:"Minus",c:189,n:"'",a:"ES"},a.VK_ES_INV_EXCLA={wc:223,d:"Equal",c:187,n:"¡",a:"ES"},a.VK_ES_GRAVE={wc:225,d:"BracketLeft",c:219,n:"`",a:"ES"},a.VK_ES_PLUS={wc:226,d:"BracketRight",c:221,n:"+",a:"ES"},a.VK_ES_ENNE={wc:227,d:"Semicolon",c:186,n:"Ñ",a:"ES"},a.VK_ES_ACUTE={wc:228,d:"Quote",c:222,n:"´",a:"ES"},a.VK_ES_CEDILLA={wc:229,d:"Backslash",c:220,n:"Ç",a:"ES"},a.VK_ES_LESSER={wc:230,d:"IntlBackslash",c:226,n:"<",a:"ES"},a.VK_ES_MINUS={wc:233,d:"Slash",c:191,n:"-",a:"ES"},a.VK_NL_ARROBA={wc:221,d:"Backquote",c:192,n:"@",a:"NL"},a.VK_NL_SLASH={wc:222,d:"Minus",c:189,n:"/",a:"NL"},a.VK_NL_ORDINAL={wc:223,d:"Equal",c:187,n:"°",a:"NL"},a.VK_NL_UMLAUT={wc:225,d:"BracketLeft",c:219,n:"¨",a:"NL"},a.VK_NL_STAR={wc:226,d:"BracketRight",c:221,n:"*",a:"NL"},a.VK_NL_PLUS={wc:227,d:"Semicolon",c:186,n:"+",a:"NL"},a.VK_NL_ACUTE={wc:228,d:"Quote",c:222,n:"´",a:"NL"},a.VK_NL_LESSER={wc:229,d:"Backslash",c:220,n:"<",a:"NL"},a.VK_NL_CLOSE_BRACKET={wc:230,d:"IntlBackslash",c:226,n:"]",a:"NL"},a.VK_NL_MINUS={wc:233,d:"Slash",c:191,n:"-",a:"NL"},a.VK_IT_BACKSLASH={wc:221,d:"Backquote",c:192,n:"\\",a:"IT"},a.VK_IT_QUOTE={wc:222,d:"Minus",c:189,n:"'",a:"IT"},a.VK_IT_GRAVE_I={wc:223,d:"Equal",c:187,n:"ì",a:"IT"},a.VK_IT_GRAVE_E={wc:225,d:"BracketLeft",c:219,n:"è",a:"IT"},a.VK_IT_PLUS={wc:226,d:"BracketRight",c:221,n:"+",a:"IT"},a.VK_IT_GRAVE_O={wc:227,d:"Semicolon",c:186,n:"ò",a:"IT"},a.VK_IT_GRAVE_A={wc:228,d:"Quote",c:222,n:"à",a:"IT"},a.VK_IT_GRAVE_U={wc:229,d:"Backslash",c:220,n:"ù",a:"IT"},a.VK_IT_LESSER={wc:230,d:"IntlBackslash",c:226,n:"<",a:"IT"},a.VK_IT_MINUS={wc:233,d:"Slash",c:191,n:"-",a:"IT"};for(var e in a)a.addKeyToIdentification(a[e])}(wmsx.DOMKeys,wmsx.DOMKeys.LOCLEFT,wmsx.DOMKeys.LOCRIGHT,wmsx.DOMKeys.LOCNUM),wmsx.DOMKeys.isModifierKey=function(a){var b=a.keyCode;return 16===b||17===b||18===b||91===b},wmsx.DOMKeys.codeNewForKeyboardEvent=function(a){var b=this.keysByCode[a.code]||this.keysByLegacyCode[a.keyCode|a.location<<this.LOC_BIT_SHIFT];return b?this.isModifierKey(a)?b.wc:b.wc|(a.shiftKey?this.SHIFT:0)|(a.ctrlKey?this.CONTROL:0)|(a.altKey?this.ALT:0)|(a.metaKey?this.META:0):0},wmsx.DOMKeys.nameForKeyboardEvent=function(a){var b=this.codeNewForKeyboardEvent(a),c=this.keys[b&this.IGNORE_ALL_MODIFIERS_MASK];if(c||a.code||a.keyCode>0){var d=a.keyCode,e=a.key;if(c&&c.fn)e=c.n;else{var f=e&&e.toUpperCase();switch(f&&"UNIDENTIFIED"!==f&&"UNDEFINED"!==f&&"UNKNOWN"!==f?"DEAD"===f&&(e="Dead#"+d):e=a.code||"#"+d,1===e.length?e=e.toUpperCase():e.length>12&&(e=e.substr(0,12)),a.location){case 1:e="L-"+e;break;case 2:e="R-"+e;break;case 3:e="Num "+e}}return c||(wmsx.Util.warning("New Host Key discovered:",a),b=WMSX.userPreferences.current.customHostKeys.nextCode++,c={wc:b,d:a.code||"",c:a.code?0:a.keyCode&this.IGNORE_ALL_MODIFIERS_MASK|a.location<<this.LOC_BIT_SHIFT,n:e},this.addKeyToIdentification(c),WMSX.userPreferences.current.customHostKeys.keys.push(c),WMSX.userPreferences.setDirty()),(a.shiftKey||a.ctrlKey||a.altKey||a.metaKey)&&(e=[e],a.metaKey&&e.unshift("Meta"),a.altKey&&e.unshift("Alt"),a.ctrlKey&&e.unshift("Ctrl"),a.shiftKey&&e.unshift("Shift")),e}},wmsx.DOMKeys.initPreferences=function(){for(var a=WMSX.userPreferences.current.customHostKeys.keys,b=0,c=a.length;b<c;++b)this.addKeyToIdentification(a[b])},wmsx.GamepadButtons={GB_1:{b:0,n:"1"},GB_2:{b:1,n:"2"},GB_3:{b:2,n:"3"},GB_4:{b:3,n:"4"},GB_L1:{b:4,n:"L1"},GB_R1:{b:5,n:"R1"},GB_L2:{b:6,n:"L2"},GB_R2:{b:7,n:"R2"},GB_BACK:{b:8,n:"BACK"},GB_START:{b:9,n:"START"},GB_S1:{b:10,n:"S1"},GB_S2:{b:11,n:"S2"},GB_UP:{b:12,n:"&#9650;"},GB_DOWN:{b:13,n:"&#9660;"},GB_LEFT:{b:14,n:"&#9668;"},GB_RIGHT:{b:15,n:"&#9658;"},GB_LOGO:{b:16,n:"LOGO"},GB_VOID:{b:-1,n:"Unbound"}},wmsx.TouchControls={directional:"T_DIR",buttons:["T_A","T_B","T_C","T_D","T_E","T_F","T_G","T_X","T_Y"],buttonsLeftSide:["T_X","T_Y"],buttonsRightSide:["T_F","T_D","T_B","T_A","T_C","T_E","T_G"]},function(){var a=wmsx.DOMKeys,b={D0:a.VK_0,D1:a.VK_1,D2:a.VK_2,D3:a.VK_3,D4:a.VK_4,D5:a.VK_5,D6:a.VK_6,D7:a.VK_7,D8:a.VK_8,D9:a.VK_9,MINUS:a.VK_MINUS,EQUAL:a.VK_EQUALS,BACKSLASH:[a.VK_BACKSLASH,a.VK_INT_BACKSLASH,a.VK_INT_YEN],OPEN_BRACKET:a.VK_OPEN_BRACKET,CLOSE_BRACKET:a.VK_CLOSE_BRACKET,SEMICOLON:a.VK_SEMICOLON,QUOTE:a.VK_QUOTE,BACKQUOTE:a.VK_BACKQUOTE,COMMA:a.VK_COMMA,PERIOD:a.VK_PERIOD,SLASH:a.VK_SLASH,DEAD:[a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],A:a.VK_A,B:a.VK_B,C:a.VK_C,D:a.VK_D,E:a.VK_E,F:a.VK_F,G:a.VK_G,H:a.VK_H,I:a.VK_I,J:a.VK_J,K:a.VK_K,L:a.VK_L,M:a.VK_M,N:a.VK_N,O:a.VK_O,P:a.VK_P,Q:a.VK_Q,R:a.VK_R,S:a.VK_S,T:a.VK_T,U:a.VK_U,V:a.VK_V,W:a.VK_W,X:a.VK_X,Y:a.VK_Y,Z:a.VK_Z,SHIFT:[a.VK_LSHIFT,a.VK_RSHIFT],CONTROL:[a.VK_LCONTROL],CAPSLOCK:a.VK_CAPS_LOCK,GRAPH:[a.VK_LALT,a.VK_PAGE_UP],CODE:[a.VK_RALT,a.VK_PAGE_DOWN],F1:a.VK_F1,F2:a.VK_F2,F3:a.VK_F3,F4:a.VK_F4,F5:a.VK_F5,ESCAPE:[a.VK_ESCAPE,{wc:a.VK_BACKQUOTE.wc|a.ALT,n:["Alt","`"]}],TAB:a.VK_TAB,STOP:[a.VK_PAUSE,a.VK_BREAK,a.VK_F9],BACKSPACE:a.VK_BACKSPACE,SELECT:[a.VK_SCROLL_LOCK,a.VK_F10],ENTER:[a.VK_ENTER,a.VK_NUM_ENTER],SPACE:a.VK_SPACE,HOME:[a.VK_HOME,{wc:a.VK_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],INSERT:[a.VK_INSERT,{wc:a.VK_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],DELETE:[a.VK_DELETE,{wc:a.VK_BACKSLASH.wc|a.ALT,n:["Alt","\\"]}],UP:a.VK_UP,DOWN:a.VK_DOWN,RIGHT:a.VK_RIGHT,LEFT:a.VK_LEFT,NUM_MULTIPLY:a.VK_NUM_MULTIPLY,NUM_PLUS:a.VK_NUM_PLUS,NUM_DIVIDE:a.VK_NUM_DIVIDE,NUM_0:a.VK_NUM_0,NUM_1:a.VK_NUM_1,NUM_2:a.VK_NUM_2,NUM_3:a.VK_NUM_3,NUM_4:a.VK_NUM_4,NUM_5:a.VK_NUM_5,NUM_6:a.VK_NUM_6,NUM_7:a.VK_NUM_7,NUM_8:a.VK_NUM_8,NUM_9:a.VK_NUM_9,NUM_MINUS:a.VK_NUM_MINUS,NUM_COMMA:a.VK_NUM_COMMA,NUM_PERIOD:a.VK_NUM_PERIOD,YES:a.VK_VOID,NO:a.VK_VOID},c={};for(var d in b)c[d]=b[d];var e={};for(d in b)e[d]=b[d];e.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_BR_QUOTE.wc|a.ALT,n:["Alt","'"]}],e.BACKSLASH=[a.VK_BR_BACKSLASH,a.VK_INT_YEN],e.OPEN_BRACKET=a.VK_BR_OPEN_BRACKET,e.CLOSE_BRACKET=a.VK_BR_CLOSE_BRACKET,e.SEMICOLON=a.VK_BR_SEMICOLON,e.QUOTE=a.VK_BR_QUOTE,e.BACKQUOTE=a.VK_BR_ACUTE,e.SLASH=a.VK_BR_SLASH,e.DEAD=[a.VK_BR_TILDE,a.VK_BR_CEDILLA,a.VK_RCONTROL,a.VK_END],e.HOME=[a.VK_HOME,{wc:a.VK_BR_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],e.INSERT=[a.VK_INSERT,{wc:a.VK_BR_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],e.DELETE=[a.VK_DELETE,{wc:a.VK_BR_SLASH.wc|a.ALT,n:["Alt","/"]}];var f={};for(d in b)f[d]=b[d];f.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_JP_YEN.wc|a.ALT,n:["Alt","¥"]}],f.EQUAL=a.VK_JP_CIRCUMFLEX,f.BACKSLASH=[a.VK_JP_YEN,a.VK_INT_BACKSLASH],f.OPEN_BRACKET=a.VK_JP_OPEN_BRACKET,f.CLOSE_BRACKET=a.VK_JP_CLOSE_BRACKET,f.QUOTE=a.VK_JP_COLLON,f.BACKQUOTE=a.VK_JP_ARROBA,f.DEAD=[a.VK_JP_RO,a.VK_RCONTROL,a.VK_END],f.CAPSLOCK=a.VK_JP_NON_CONVERT,f.HOME=[a.VK_HOME,{wc:a.VK_JP_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],f.INSERT=[a.VK_INSERT,{wc:a.VK_JP_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],f.DELETE=[a.VK_DELETE,{wc:a.VK_JP_RO.wc|a.ALT,n:["Alt","\\ ろ"]}];var g={};for(d in b)g[d]=b[d];g.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_ES_ORDINAL.wc|a.ALT,n:["Alt","º"]}],g.MINUS=a.VK_ES_MINUS,g.EQUAL=a.VK_ES_INV_EXCLA,g.BACKSLASH=[a.VK_ES_ORDINAL,a.VK_INT_YEN],g.OPEN_BRACKET=a.VK_ES_GRAVE,g.CLOSE_BRACKET=a.VK_ES_PLUS,g.SEMICOLON=a.VK_ES_ENNE,g.QUOTE=a.VK_ES_QUOTE,g.BACKQUOTE=a.VK_ES_ACUTE,g.SLASH=a.VK_ES_LESSER,g.DEAD=[a.VK_ES_CEDILLA,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],g.HOME=[a.VK_HOME,{wc:a.VK_ES_GRAVE.wc|a.ALT,n:["Alt","`"]}],g.INSERT=[a.VK_INSERT,{wc:a.VK_ES_PLUS.wc|a.ALT,n:["Alt","+"]}],g.DELETE=[a.VK_DELETE,{wc:a.VK_ES_CEDILLA.wc|a.ALT,n:["Alt","Ç"]}];var h={};for(d in b)h[d]=b[d];h.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_NL_ARROBA.wc|a.ALT,n:["Alt","@"]}],
h.MINUS=a.VK_NL_MINUS,h.EQUAL=a.VK_NL_ORDINAL,h.BACKSLASH=[a.VK_NL_CLOSE_BRACKET,a.VK_INT_YEN],h.OPEN_BRACKET=a.VK_NL_UMLAUT,h.CLOSE_BRACKET=a.VK_NL_STAR,h.SEMICOLON=a.VK_NL_PLUS,h.QUOTE=a.VK_NL_ACUTE,h.BACKQUOTE=a.VK_NL_ARROBA,h.SLASH=a.VK_NL_SLASH,h.DEAD=[a.VK_NL_LESSER,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],h.HOME=[a.VK_HOME,{wc:a.VK_NL_UMLAUT.wc|a.ALT,n:["Alt","¨"]}],h.INSERT=[a.VK_INSERT,{wc:a.VK_NL_STAR.wc|a.ALT,n:["Alt","*"]}],h.DELETE=[a.VK_DELETE,{wc:a.VK_NL_LESSER.wc|a.ALT,n:["Alt","<"]}];var i={};for(d in b)i[d]=b[d];i.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_IT_BACKSLASH.wc|a.ALT,n:["Alt","\\"]}],i.MINUS=a.VK_IT_MINUS,i.EQUAL=a.VK_IT_GRAVE_I,i.BACKSLASH=[a.VK_IT_BACKSLASH,a.VK_INT_YEN],i.OPEN_BRACKET=a.VK_IT_GRAVE_E,i.CLOSE_BRACKET=a.VK_IT_PLUS,i.SEMICOLON=a.VK_IT_GRAVE_O,i.QUOTE=a.VK_IT_QUOTE,i.BACKQUOTE=a.VK_IT_GRAVE_A,i.SLASH=a.VK_IT_LESSER,i.DEAD=[a.VK_IT_GRAVE_U,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],i.HOME=[a.VK_HOME,{wc:a.VK_IT_GRAVE_E.wc|a.ALT,n:["Alt","è"]}],i.INSERT=[a.VK_INSERT,{wc:a.VK_IT_PLUS.wc|a.ALT,n:["Alt","+"]}],i.DELETE=[a.VK_DELETE,{wc:a.VK_IT_GRAVE_U.wc|a.ALT,n:["Alt","ù"]}];var j={};for(d in b)j[d]=b[d];j.OPEN_BRACKET=a.VK_BACKQUOTE,j.CLOSE_BRACKET=a.VK_OPEN_BRACKET,j.BACKQUOTE=a.VK_CLOSE_BRACKET;var k={};for(d in b)k[d]=b[d];k.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_BR_QUOTE.wc|a.ALT,n:["Alt","'"]}],k.BACKSLASH=[a.VK_BR_BACKSLASH,a.VK_INT_YEN],k.OPEN_BRACKET=[a.VK_BR_QUOTE,a.VK_BR_ACUTE],k.CLOSE_BRACKET=a.VK_BR_OPEN_BRACKET,k.SEMICOLON=a.VK_BR_SEMICOLON,k.QUOTE=a.VK_BR_CEDILLA,k.BACKQUOTE=a.VK_BR_CLOSE_BRACKET,k.SLASH=a.VK_BR_SLASH,k.DEAD=[a.VK_BR_TILDE,a.VK_BR_CEDILLA,a.VK_RCONTROL,a.VK_END],k.HOME=[a.VK_HOME,{wc:a.VK_BR_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],k.INSERT=[a.VK_INSERT,{wc:a.VK_BR_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],k.DELETE=[a.VK_DELETE,{wc:a.VK_BR_SLASH.wc|a.ALT,n:["Alt","/"]}];var l={};for(d in b)l[d]=b[d];l.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_JP_YEN.wc|a.ALT,n:["Alt","¥"]}],l.EQUAL=a.VK_JP_CIRCUMFLEX,l.BACKSLASH=[a.VK_JP_YEN,a.VK_INT_BACKSLASH],l.OPEN_BRACKET=a.VK_JP_ARROBA,l.CLOSE_BRACKET=a.VK_JP_OPEN_BRACKET,l.QUOTE=a.VK_JP_COLLON,l.BACKQUOTE=a.VK_JP_CLOSE_BRACKET,l.DEAD=[a.VK_JP_RO,a.VK_RCONTROL,a.VK_END],l.CAPSLOCK=a.VK_JP_NON_CONVERT,l.HOME=[a.VK_HOME,{wc:a.VK_JP_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],l.INSERT=[a.VK_INSERT,{wc:a.VK_JP_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],l.DELETE=[a.VK_DELETE,{wc:a.VK_JP_RO.wc|a.ALT,n:["Alt","\\ ろ"]}];var m={};for(d in b)m[d]=b[d];m.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_ES_ORDINAL.wc|a.ALT,n:["Alt","º"]}],m.MINUS=a.VK_ES_MINUS,m.EQUAL=a.VK_ES_INV_EXCLA,m.BACKSLASH=[a.VK_ES_ORDINAL,a.VK_INT_YEN],m.OPEN_BRACKET=a.VK_ES_QUOTE,m.CLOSE_BRACKET=a.VK_ES_GRAVE,m.SEMICOLON=a.VK_ES_ENNE,m.QUOTE=a.VK_ES_ACUTE,m.BACKQUOTE=a.VK_ES_PLUS,m.SLASH=a.VK_ES_LESSER,m.DEAD=[a.VK_ES_CEDILLA,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],m.HOME=[a.VK_HOME,{wc:a.VK_ES_GRAVE.wc|a.ALT,n:["Alt","`"]}],m.INSERT=[a.VK_INSERT,{wc:a.VK_ES_PLUS.wc|a.ALT,n:["Alt","+"]}],m.DELETE=[a.VK_DELETE,{wc:a.VK_ES_CEDILLA.wc|a.ALT,n:["Alt","Ç"]}];var n={};for(d in b)n[d]=b[d];n.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_NL_ARROBA.wc|a.ALT,n:["Alt","@"]}],n.MINUS=a.VK_NL_MINUS,n.EQUAL=a.VK_NL_ORDINAL,n.BACKSLASH=[a.VK_NL_CLOSE_BRACKET,a.VK_INT_YEN],n.OPEN_BRACKET=a.VK_NL_ARROBA,n.CLOSE_BRACKET=a.VK_NL_UMLAUT,n.SEMICOLON=a.VK_NL_PLUS,n.QUOTE=a.VK_NL_ACUTE,n.BACKQUOTE=a.VK_NL_STAR,n.SLASH=a.VK_NL_SLASH,n.DEAD=[a.VK_NL_LESSER,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],n.HOME=[a.VK_HOME,{wc:a.VK_NL_UMLAUT.wc|a.ALT,n:["Alt","¨"]}],n.INSERT=[a.VK_INSERT,{wc:a.VK_NL_STAR.wc|a.ALT,n:["Alt","*"]}],n.DELETE=[a.VK_DELETE,{wc:a.VK_NL_LESSER.wc|a.ALT,n:["Alt","<"]}];var o={};for(d in b)o[d]=b[d];o.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_IT_BACKSLASH.wc|a.ALT,n:["Alt","\\"]}],o.MINUS=a.VK_IT_MINUS,o.EQUAL=a.VK_IT_GRAVE_I,o.BACKSLASH=[a.VK_IT_BACKSLASH,a.VK_INT_YEN],o.OPEN_BRACKET=a.VK_IT_QUOTE,o.CLOSE_BRACKET=a.VK_IT_GRAVE_E,o.SEMICOLON=a.VK_IT_GRAVE_O,o.QUOTE=a.VK_IT_GRAVE_A,o.BACKQUOTE=a.VK_IT_PLUS,o.SLASH=a.VK_IT_LESSER,o.DEAD=[a.VK_IT_GRAVE_U,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],o.HOME=[a.VK_HOME,{wc:a.VK_IT_GRAVE_E.wc|a.ALT,n:["Alt","è"]}],o.INSERT=[a.VK_INSERT,{wc:a.VK_IT_PLUS.wc|a.ALT,n:["Alt","+"]}],o.DELETE=[a.VK_DELETE,{wc:a.VK_IT_GRAVE_U.wc|a.ALT,n:["Alt","ù"]}],wmsx.BuiltInKeyboards={en:{"en-US":c,"pt-BR":e,"ja-JP":f,"es-ES":g,"nl-NL":h,"it-IT":i},ja:{"en-US":j,"pt-BR":k,"ja-JP":l,"es-ES":m,"nl-NL":n,"it-IT":o}}}(),wmsx.DOMKeyboard=function(a,b,c){"use strict";function d(a,c,d){b.netController&&J.push(a<<8|c<<4|d),2!==b.netPlayMode&&e(a,c,d)}function e(a,b,c){c?y[a]&=~(1<<b):y[a]|=1<<b}function f(){C=A>0?A:WMSX.BOOT_DURATION_AUTO}function g(){var a=(wmsx.Util.userLanguage()||"en-US").toUpperCase();"nl"===a.substr(0,2)&&(a="en-US");for(var b=0;b<t.length;++b)if(0===t[b].toUpperCase().indexOf(a))return j.setKeyboard(t[b],!0);for(a=a.substr(0,2),b=0;b<t.length;++b)if(0===t[b].toUpperCase().indexOf(a))return j.setKeyboard(t[b],!0);j.setKeyboard(t[0],!0)}function h(){var a=m+"-CUSTOM";v[a]||(v[a]={},t.push(a));var b=v[a];for(var c in D)b[c]=D[c].slice(0);j.setKeyboard(a,!1)}function i(){u=wmsx.BuiltInKeyboards[w]||{},v=WMSX.userPreferences.current.customHostKeyboards[w]||{},t=Object.keys(u).concat(Object.keys(v));var a=WMSX.userPreferences.current.hostKeyboard[w];t.indexOf(a)>=0?j.setKeyboard(a,!1):g()}var j=this;this.connect=function(a,b){o=a,o.addMachineTypeStateListener(j,!0),p=b},this.connectPeripherals=function(a){q=a},this.resetControllers=function(){this.releaseControllers(),B&&f()},this.machineTypeStateUpdate=function(){var a=o.getMachineLang();a!==w&&(w=a,i())},this.powerOn=function(){if(WMSX.BOOT_KEYS||WMSX.BOOT_KEYS_ONCE){for(var a=(WMSX.BOOT_KEYS||WMSX.BOOT_KEYS_ONCE).split(","),b=[],c=0;c<a.length;++c){var d=a[c].trim().toUpperCase(),e=r[d]||r[N[d]];e&&(b.push(e.key),z[e.m[0]]&=~(1<<e.m[1]))}b.length&&f(),C&&!WMSX.BOOT_KEYS_ONCE&&(B=!0),wmsx.Util.log("Boot Keys"+(B?"":" (once)")+": "+b.join(", "))}},this.powerOff=function(){},this.typeString=function(a){p.keyboardExtensionTypeString(a)},this.cancelTypeString=function(){p.keyboardExtensionCancelTypeString()},this.isShiftPressed=function(){return 0==(1&y[6])},this.controllersClockPulse=function(){if(C>0&&--C,F&&I){if(--G===H||0===G){var a=G>0,b=r.SPACE.m;d(b[0],b[1],a)}G<=0&&(G=F)}},this.readKeyboardPort=function(a){return C>0?y[a]&z[a]:y[a]},this.toggleKeyboardLayout=function(a){var b;b=a?n?t.length-1:t.indexOf(m)-1||0:n?0:t.indexOf(m)+1||0,b<0||b>=t.length?g():this.setKeyboard(t[b],!1),q.showOSD("Host Keyboard: "+this.getCurrentKeyboardDesc(),!0)},this.getCurrentKeyboardDesc=function(){return(n?"AUTO: ":"")+m},this.setKeyboard=function(a,b){m=a,n=b,k(),q&&q.keyboardSettingsStateUpdate();var c=b?void 0:a;WMSX.userPreferences.current.hostKeyboard[w]!==c&&(WMSX.userPreferences.current.hostKeyboard[w]=c,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())},this.setTurboFireClocks=function(a){F=a,H=F/2|0,G=0},this.releaseControllers=function(){for(var a in x)x[a]&&this.processMSXKey(a,!1);I=!1},this.getKeyMapping=function(a){return D[a]},this.clearKey=function(a){0!==D[a].length&&(v[m]||h(),D[a].length=0,l(),WMSX.userPreferences.setDirty())},this.customizeKey=function(a,b){if(E[b.wc]!==a){v[m]||h();for(var c in D){var d=D[c];if(0!==d.length)for(var e;(e=wmsx.Util.arrayFindIndex(d,function(a){return a.wc===b.wc}))>=0;)d.splice(e,1)}d=D[a],d.length>=M&&d.splice(0,d.length-(M-1)),d.push(b),l(),WMSX.userPreferences.setDirty()}},this.processKey=function(a,b){var e=E[a];if(!e){if(c.processKey(a,b))return;e=E[a&L]}if(e){if(a===K&&x.CONTROL){var f=r.CONTROL.m;d(f[0],f[1],!1)}this.processMSXKey(e,b)}},this.processMSXKey=function(a,b){if(F&&"SPACE"===a){if(I===b)return;b&&(G=H),I=b}if(x[a]!==b){x[a]=b;var c=r[a].m;d(c[0],c[1],b)}};var k=function(){var a=v[m]||u[m];for(var b in r)D[b]=a[b]?a[b].constructor===Array?a[b]:[a[b]]:[];l()},l=function(){E={};for(var a in D)if(0!==D[a].length)for(var b=0;b<D[a].length;++b)E[D[a][b].wc]=a}
;this.netGetMatrixChangesToSend=function(){return J.length?J:void 0},this.netClearMatrixChangesToSend=function(){J.length=0},this.netServerProcessMatrixChanges=function(a){for(var b=0,c=a.length;b<c;++b){var d=a[b];J.push(d),e(d>>8,(240&d)>>4,1&d)}},this.netClientApplyMatrixChanges=function(a){for(var b=0,c=a.length;b<c;++b)e(a[b]>>8,(240&a[b])>>4,1&a[b])},this.saveState=function(){return{k:wmsx.Util.storeInt8BitArrayToStringBase64(y),kb:wmsx.Util.storeInt8BitArrayToStringBase64(z),bf:A,ba:B,bc:C}},this.loadState=function(a){wmsx.Util.restoreStringBase64ToInt8BitArray(a.k,y),wmsx.Util.restoreStringBase64ToInt8BitArray(a.kb,z),A=a.bf,B=a.ba,C=a.bc};var m,n,o,p,q,r=wmsx.KeyboardKeys,s=wmsx.DOMKeys,t=[],u={},v={},w="en",x={},y=wmsx.Util.arrayFill(new Array(12),255),z=wmsx.Util.arrayFill(new Array(12),255),A=WMSX.BOOT_KEYS_FRAMES,B=!1,C=0,D={},E={},F=0,G=0,H=0,I=!1,J=new Array(100);J.length=0;var K=s.VK_RALT.wc,L=s.IGNORE_ALL_MODIFIERS_MASK,M=4,N={CTRL:"CONTROL",ESC:"ESCAPE",CAPS:"CAPSLOCK",KANA:"CODE",RETURN:"ENTER",RET:"ENTER",0:"D0",1:"D1",2:"D2",3:"D3",4:"D4",5:"D5",6:"D6",7:"D7",8:"D8",9:"D9"};i()},wmsx.GamepadJoysticksControls=function(a,b,c){"use strict";function d(){-2===w?p=q=null:-1===w&&(v=-1,n.controllersClockPulse(!0)),x=0===w,h(),e()}function e(){var a=p?J+" 1":null,c=q?J+" 2":null;b.updateJoystickConnections(x?c:a,x?a:c)}function f(a,c){e(),b.showStatusMessage("Joystick "+(a?"1":"2")+(c?" connected":" disconnected"))}function g(a,b,c){if(c&&0!==c.length){var d=a.settings.device;if(d>=0)return c[d]&&c[d].buttons.length>0?new m(d,a):null;for(var e=0,f=c.length;e<f;e++)if(c[e]&&c[e].buttons.length>0&&!(e===b.device||p&&p.index===e||q&&q.index===e))return new m(e,a)}}function h(){B.reset(),C.reset()}function i(a,b,d){if(d===E)return j(a);var e=b.buttonsState,f=e.J_A;for(var g in t){var h=d.buttons[g];if(h&&h.length>0){for(var i=!1,k=0;!i&&k<h.length;++k)a.getButtonDigital(h[k].b)&&(i=!0);if(e[g]!==i)if(e[g]=i,t[g].mask)i?b.portValue&=~t[g].mask:b.portValue|=t[g].mask;else{var l=d.virtualButtonsKeys[g];if(l)for(var m=0;m<l.length;++m)c.processKey(l[m].wc,i)}}}if(y&&b.buttonsState.J_A&&!f&&(z=A),!(e.UP||e.DOWN||e.LEFT||e.RIGHT)){var n=a.getStickDirection();n!==b.analogDirection&&(b.analogDirection=n,b.portValue=-16&b.portValue|L[n+1])}}function j(a){for(var b in wmsx.GamepadButtons){var c=wmsx.GamepadButtons[b].b;if(c>=0&&a.getButtonDigital(c))return F.joystickButtonDetected(wmsx.GamepadButtons[b],(E===s?1:0)^x)}}function k(){D[0]=r=WMSX.userPreferences.current.joysticks[0],D[1]=s=WMSX.userPreferences.current.joysticks[1]}function l(){this.reset=function(){this.analogDirection=-1,this.buttonsState={},this.portValue=63,this.pin8Value=0},this.reset()}function m(a,b){this.index=a,this.update=function(b){return!!(c=b[a])},this.hasMoved=function(){var a=c.timestamp;return!a||a>i&&(i=a,!0)},this.getButtonDigital=function(a){var b=c.buttons[a];return"object"==typeof b?b.pressed||b.value>.5:b>.5},this.getStickDirection=function(){var a=c.axes[d],b=c.axes[e];if(isNaN(a)||(a<0?-a:a)<h?a=0:a*=f,isNaN(b)||(b<0?-b:b)<h?b=0:b*=g,0===a&&0===b)return-1;var i=(1-Math.atan2(a,b)/Math.PI)/2;return i+=1/16,i>=1&&(i-=1),8*i|0};var c,d=b.settings.xAxis,e=b.settings.yAxis,f=b.settings.xAxisSig,g=b.settings.yAxisSig,h=b.settings.deadzone,i=Number.MIN_VALUE}var n=this;this.connectPeripherals=function(a){o=a},this.powerOn=function(){(u=!!navigator.getGamepads)&&(k(),w>=-1&&d())},this.powerOff=function(){u=!1},this.releaseControllers=function(){h()},this.resetControllers=function(){this.releaseControllers(),e()},this.readControllerPort=function(c){return a.netController?b.netGetMergedPortValues()[c]:this.readLocalControllerPort(c)},this.readLocalControllerPort=function(a){var b=1===a^x?C:B;return b.pin8Value?63:z>A?16|b.portValue:b.portValue},this.writeControllerPin8Port=function(a,b){(1===a^x?C:B).pin8Value=b},this.toggleMode=function(c){if(!u)return void b.showErrorMessage("Joysticks unavailable (not supported by browser)");var d=(2!==a.netPlayMode||G?H:I)[c?1:0][w+2];this.setMode(d),b.showStatusMessage("Joysticks "+this.getModeDesc())},this.setMode=function(a){w=a,d()},this.getMode=function(){return w},this.getModeDesc=function(){switch(w){case-1:return"AUTO";case 0:return"AUTO (swapped)";default:return u?"DISABLED":"NOT SUPPORTED"}},this.getSwappedState=function(){return x},this.netClientAdaptToServerControlsModes=function(a){G=a.sw,-2!==w&&(-1!==w||G?0===w&&G&&this.setMode(-1):this.setMode(0))},this.setTurboFireClocks=function(a){y=a,A=y/2|0,z=0},this.controllersClockPulse=function(a){if(u&&-2!==w&&(++v>=K&&(v=0),p||q||0===v)){var b=navigator.getGamepads();y&&--z<=0&&(z=y),p?p.update(b)?p.hasMoved()&&i(p,B,r):(p=null,B.reset(),a||f(!0,!1)):0===v&&(p=g(r,s,b))&&!a&&f(!0,!0),q?q.update(b)?q.hasMoved()&&i(q,C,s):(q=null,C.reset(),a||f(!1,!1)):0===v&&(q=g(s,r,b))&&!a&&f(!1,!0)}},this.getMappingForControl=function(a,b){var c=D[b^x];return t[a].mask?c.buttons[a]:0!==c.buttons[a].length||0!==c.virtualButtonsKeys[a].length?{from:c.buttons[a],to:c.virtualButtonsKeys[a]}:[]},this.getMappingPopupText=function(a,b){var c=!t[a].mask;return{heading:c?"Virtual Button mapping:":"Button mapped to host buttons:",footer:c?"Press new button / key.<br>(right-click to clear)":"Press new button.<br>(right-click to clear)"}},this.customizeControl=function(a,b,c){var d;if(c.wc){if(c.wc&&t[a].mask)return;if(d=D[b^x].virtualButtonsKeys[a],wmsx.Util.arrayFind(d,function(a){return a.wc===c.wc}))return}else if(d=D[b^x].buttons[a],wmsx.Util.arrayFind(d,function(a){return a.b===c.b}))return;d.length>=M&&d.splice(0,d.length-(M-1)),d.push(c),h(),WMSX.userPreferences.setDirty()},this.clearControl=function(a,b){D[b^x].buttons[a].length=0,t[a].mask||(D[b^x].virtualButtonsKeys[a].length=0),h(),WMSX.userPreferences.setDirty()},this.startButtonDetection=function(a,b){E=D[a^x],F=b},this.stopButtonDetection=function(){E=F=null};var o,p,q,r,s,t=wmsx.JoystickButtons,u=!1,v=1,w=WMSX.JOYSTICKS_MODE-1,x=!1,y=0,z=0,A=0,B=new l,C=new l,D=[],E=null,F=null,G=!1,H=[[-1,0,-2],[0,-2,-1]],I=[[0,-2,-1],[-1,0,-2]],J=wmsx.ControllersHub.JOYSTICK,K=60,L=[15,14,6,7,5,13,9,11,10],M=4},wmsx.DOMJoykeysControls=function(a,b,c){"use strict";function d(){p=1===o||3===o,h(),g(),e()}function e(){q={},o>=0&&f(l.buttons,0),o>=2&&f(m.buttons,1)}function f(a,b){for(var c in a)for(var d=0;d<a[c].length;++d)q[a[c][d].wc]||(q[a[c][d].wc]=[]),q[a[c][d].wc].push({b:c,p:b})}function g(){var a=o>=0?C+" 1":null,c=o>=2?C+" 2":null;b.updateJoykeysConnections(p?c:a,p?a:c)}function h(){s.reset(),t.reset()}function i(){y[0]=l=WMSX.userPreferences.current.joykeys[0],y[1]=m=WMSX.userPreferences.current.joykeys[1]}function j(){this.reset=function(){this.portValue=63,this.pin8Value=0},this.reset()}this.connectPeripherals=function(a){k=a},this.powerOn=function(){i(),o>=0&&d()},this.powerOff=function(){},this.releaseControllers=function(){h()},this.resetControllers=function(){this.releaseControllers(),g()},this.readControllerPort=function(c){return a.netController?b.netGetMergedPortValues()[c]:this.readLocalControllerPort(c)},this.readLocalControllerPort=function(a){var b=u[a^p];return b.pin8Value?63:w>x?16|b.portValue:b.portValue},this.writeControllerPin8Port=function(a,b){u[a^p].pin8Value=b},this.controllersClockPulse=function(){o>=0&&v&&--w<=0&&(w=v)},this.toggleMode=function(c){var d=(2!==a.netPlayMode||z?A:B)[c?1:0][o+1];this.setMode(d),b.showStatusMessage("Joykeys "+this.getModeDesc())},this.setMode=function(a){a>=0&&o<0&&(r={}),o=a,d()},this.getMode=function(){return o},this.getModeDesc=function(){switch(o){case 0:return"SINGLE";case 1:return"SINGLE (port 2)";case 2:return"DUAL";case 3:return"DUAL (swapped)";default:return"DISABLED"}},this.getSwappedState=function(){return p},this.netClientAdaptToServerControlsModes=function(a){z=a.sw,-1!==o&&(z?1===o?this.setMode(0):3===o&&this.setMode(2):0===o?this.setMode(1):2===o&&this.setMode(3))},
this.setTurboFireClocks=function(a){v=a,x=v/2|0,w=0},this.processKey=function(a,b){if(o<0)return c.processKey(a,b);var d=q[a];if(!d)return c.processKey(a,b);if(r[a]===b)return void(b||c.processKey(a,b));r[a]=b;for(var e=0;e<d.length;++e)b?(u[d[e].p].portValue&=~n[d[e].b].mask,v&&"J_A"===d[e].b&&(w=x+1)):u[d[e].p].portValue|=n[d[e].b].mask;b||c.processKey(a,b)},this.getMappingForControl=function(a,b){return y[b^p].buttons[a]},this.getMappingPopupText=function(a,b){return{heading:"Button mapped to host keys:",footer:"Press new key.<br>(right-click to clear)"}},this.customizeControl=function(a,b,c){if(!q[c.wc]||!wmsx.Util.arrayFind(q[c.wc],function(c){return c.b===a&&c.p===b})){var d=y[b^p].buttons[a];d.length>=D&&d.splice(0,d.length-(D-1)),d.push(c),h(),e(),WMSX.userPreferences.setDirty()}},this.clearControl=function(a,b){y[b^p].buttons[a].length=0,h(),e(),WMSX.userPreferences.setDirty()};var k,l,m,n=wmsx.JoystickButtons,o=WMSX.JOYKEYS_MODE,p=!1,q={},r={},s=new j,t=new j,u=[s,t],v=0,w=0,x=0,y=[],z=!1,A=[[0,1,2,3,-1],[3,-1,0,1,2]],B=[[1,3,0,-1,2],[2,1,-1,3,0]],C=wmsx.ControllersHub.JOYKEYS,D=4},wmsx.DOMMouseControls=function(a,b){"use strict";function c(a){C=void 0!==a?a:B<0?-1:B,z?q(y):p(x),n()}function d(a){return a===C?y.portValue:b.portValueAllReleased}function e(){if(G=!1,C<0)return w.showOSD("Mouse Pointer Locking only when MOUSE is ENABLED!",!0,!0);var a=t.requestPointerLock||t.mozRequestPointerLock||t.webkitRequestPointerLock;a&&a.apply(t)}function f(){G=!1;var a=document.exitPointerLock||document.mozExitPointerLock||document.webkitExitPointerLock;a&&a.apply(document)}function g(){x.portValue=-49&x.portValue|(3&~x.buttons)<<4}function h(){switch(x.readCycle){case 0:x.portValue=-16&x.portValue|x.readDX>>4&15;break;case 1:x.portValue=-16&x.portValue|15&x.readDX;break;case 2:x.portValue=-16&x.portValue|x.readDY>>4&15;break;case 3:x.portValue=-16&x.portValue|15&x.readDY;break;default:x.portValue=-16&x.portValue}}function i(){var a=Math.round(-x.dX);a>127?a=127:a<-127&&(a=-127),x.dX+=a,x.readDX=a;var b=Math.round(-x.dY);b>127?b=127:b<-127&&(b=-127),x.dY+=b,x.readDY=b}function j(a){if(!(C<0)){a.preventDefault();var b=0,c=0;F?(b=a.movementX||a.mozMovementX||a.webkitMovementX||0,c=a.movementY||a.mozMovementY||a.webkitMovementY||0):u&&(b=a.clientX-u.clientX,c=a.clientY-u.clientY),u=a,y.dX+=b/D,y.dY+=c/E,A=y}}function k(a){if(4&a.buttons&&(a.preventDefault(),s.togglePointerLock()),C>=0){if(G&&a.buttons)return 1&a.buttons&&!F&&e(),void(G=!1);y.buttons=3&a.buttons,z||g(),A=y}}function l(){var a=document.pointerLockElement||document.mozPointerLockElement||document.webkitPointerLockElement;F=a===t,w.mousePointerLocked(F),w.showOSD(F?"Mouse Pointer Locked":"Mouse Pointer Released",F)}function m(a,b){C=a,s.writeControllerPin8Port(C,b),n(),o("Mouse AUTO-ENABLED")}function n(){F&&C<0&&f(),b.updateMouseConnections(0===C?I:null,1===C?I:null),w.mouseActiveCursorStateUpdate(C>=0)}function o(a){b.showStatusMessage(a)}function p(a){return a.readCycle=-1,a.dX=0,a.dY=0,a.buttons=0,a.portValue=b.portValueAllReleased,a.pin8Value=0,a.lastPin8FlipBUSCycle=0,a.readDX=0,a.readDY=0,A=x,a}function q(a){return a.dX=0,a.dY=0,a.buttons=void 0,A=void 0,a}function r(a){return a===C?x.portValue:b.portValueAllReleased}var s=this;this.connect=function(a){v=a},this.connectPeripherals=function(a){w=a},this.powerOn=function(){c()},this.powerOff=function(){},this.releaseControllers=function(){C>=0&&(z?q(y):p(x))},this.resetControllers=function(){this.releaseControllers(),-1===B&&(C=-1),n()},this.screenFullscreenStateUpdate=function(a){G=a&&!F},this.toggleMode=function(a){var b;a?(b=B-1)<-2&&(b=1):(b=B+1)>1&&(b=-2),this.setMode(b),o("Mouse "+this.getModeDesc())},this.setMode=function(a){B=a,c()},this.setModeEffective=function(a){B=a.m,c(a.p)},this.getMode=function(){return B},this.getModeEffective=function(){return{m:B,p:C}},this.getModeDesc=function(){switch(B){case-1:return"AUTO";case 0:return"ENABLED";case 1:return"ENABLED (port 2)";default:return"DISABLED"}},this.netClientAdaptToServerControlsModes=function(a){this.setModeEffective(a.m)},this.readControllerPort=function(b){return a.netController?r(b):d(b)},this.writeControllerPin8Port=function(a,b){if(a===C){if(x.pin8Value^b){x.pin8Value=b;var c=v.getBUSCycles()-x.lastPin8FlipBUSCycle;x.lastPin8FlipBUSCycle+=c,c>J&&(x.readCycle=-1),++x.readCycle,0===x.readCycle&&i(),h()}}},this.portPin8Announced=function(a,b){1===b&&!H&&C<0&&0===a&&-1===B&&m(a,b)},this.togglePointerLock=function(){F?f():e()},this.setMouseInputElement=function(a){t=a,"onpointerlockchange"in document?document.addEventListener("pointerlockchange",l,!1):"onmozpointerlockchange"in document&&document.addEventListener("mozpointerlockchange",l,!1),t.addEventListener("mousemove",j),t.addEventListener("mousedown",k),t.addEventListener("mouseup",k)},this.setScreenPixelScale=function(a,b){D=a,E=b},this.getMappingForControl=function(a,b){return[{wc:999999,n:["Alt","CapsLock"]}]},this.getMappingPopupText=function(a,b){return{heading:"Lock / Unlock pointer:",footer:"or click Middle Button"}},this.customizeControl=function(a,b,c){},this.clearControl=function(a,b){},this.netGetMouseStateToSend=function(){return A},this.netClearMouseInfoToSend=function(){z?q(y):A=void 0},this.netServerGetMouseState=function(){return x},this.netServerReceiveClientMouseState=function(a){x.dX+=a.dX,x.dY+=a.dY,void 0!==a.buttons&&(x.buttons=a.buttons,g()),A=x},this.netClientReceiveServerMouseState=function(a){x=a},this.netSetClientMode=function(a){z=a,y=a?q({}):x};var t,u,v,w,x=p({}),y=x,z=!1,A=void 0,B=WMSX.MOUSE_MODE-1,C=-1,D=1,E=1,F=!1,G=!1,H=wmsx.Util.isMobileDevice(),I=wmsx.ControllersHub.MOUSE,J=wmsx.Z80.BASE_CLOCK/1e3*1.5|0},wmsx.DOMTouchControls=function(a,b,c,d){"use strict";function e(){C.classList.toggle("wmsx-poweroff",!V),C.classList.toggle("wmsx-paused",W)}function f(){J=-2===I?-1:-1===I?G&&H?0:-1:I,v(),u()}function g(a){if(wmsx.Util.blockEvent(a),E)return E.touchControlDetected("T_DIR",a)}function h(a){if(wmsx.Util.blockEvent(a),E)return E.touchControlDetected("T_DIR",a);if(null===Q){void 0===A&&m();var b=a.changedTouches[0];Q=b.identifier,k(b.pageX,b.pageY)}}function i(a){wmsx.Util.blockEvent(a),null!==Q&&(Q=null,l(-1))}function j(a){if(wmsx.Util.blockEvent(a),null!==Q)for(var b=a.changedTouches,c=0;c<b.length;++c)if(b[c].identifier===Q)return void k(b[c].pageX,b[c].pageY)}function k(a,b){var c=-1,d=a-A,e=b-B;Math.sqrt(d*d+e*e)>S&&(c=(1-Math.atan2(d,e)/Math.PI)/2,c+=1/16,c>=1&&(c-=1),c=8*c|0),l(c)}function l(a){if(R!==a){if(P.wmsxMappingIsKeys){var d=Z[R+1];d[0]&&c.processMSXKey(d[0],!1),d[1]&&c.processMSXKey(d[1],!1);var e=Z[a+1];e[0]&&c.processMSXKey(e[0],!0),e[1]&&c.processMSXKey(e[1],!0)}else U.portValue=-16&U.portValue|Y[a+1];a>=0&&b.hapticFeedback(),R=a}}function m(){var a=P.getBoundingClientRect();S=.14*(a.right-a.left)|0,A=((a.left+a.right)/2|0)+window.pageXOffset,B=((a.top+a.bottom)/2|0)+window.pageYOffset}function n(a){if(wmsx.Util.blockEvent(a),E)return E.touchControlDetected(a.target.wmsxControl,a);p(a.target.wmsxMapping,!0)}function o(a){wmsx.Util.blockEvent(a),p(a.target.wmsxMapping,!1)}function p(a,d){a&&(d&&b.hapticFeedback(),a.button?d?(U.portValue&=~a.mask,K&&16&a.mask&&(L=M+1)):U.portValue|=a.mask:a.key&&c.processMSXKey(a.key,d))}function q(a){wmsx.Util.blockEvent(a),b.hapticFeedback(),d.processControlState(V?F.PAUSE:F.POWER,!0)}function r(a){wmsx.Util.blockEvent(a),b.hapticFeedback(),d.processControlState(W?F.FRAME:F.FAST_SPEED,!0)}function s(a){wmsx.Util.blockEvent(a),W||(b.hapticFeedback(),d.processControlState(W?F.FRAME:F.FAST_SPEED,!1))}function t(){y.updateMappingFor("T_DIR");for(var a in T)y.updateMappingFor(a)}function u(){b.updateTouchControlsConnections(0===J?X:null,1===J?X:null)}function v(){U.reset(),A=B=void 0,Q=null,l(-1)}function w(){D=WMSX.userPreferences.current.touch,N=!!D.directionalBig,O=!!D.mirrored}function x(){this.reset=function(){this.portValue=63,
this.pin8Value=0},this.reset()}var y=this;this.connect=function(a){a.addPowerAndUserPauseStateListener(this)},this.connectPeripherals=function(a){z=a},this.powerOn=function(){w(),f()},this.powerOff=function(){},this.releaseControllers=function(){v()},this.resetControllers=function(){this.releaseControllers(),u()},this.readControllerPort=function(c){return a.netController?b.netGetMergedPortValues()[c]:this.readLocalControllerPort(c)},this.readLocalControllerPort=function(a){return a===J?U.pin8Value?63:L>M?16|U.portValue:U.portValue:63},this.writeControllerPin8Port=function(a,b){a===J&&(U.pin8Value=b)},this.controllersClockPulse=function(){J>=0&&K&&--L<=0&&(L=K)},this.toggleMode=function(a,c){if(!G)return void b.showErrorMessage("Touch Controls unavailable. Not a touch device!");var d;c?(d=a?J<0?1:0===J?-2:I-1:I-1)<-2&&(d=1):(d=a?0===J?1:-2===I?0:I+1:I+1)>1&&(d=-2),this.setMode(d),b.showStatusMessage("Touch Controls "+this.getModeDesc())},this.setMode=function(a){I=a,f()},this.getMode=function(){return I},this.getModeDesc=function(){switch(I){case-1:return"AUTO";case 0:return"ENABLED";case 1:return"ENABLED (port 2)";default:return G?"DISABLED":"NOT SUPPORTED"}},this.getSwappedState=function(){return 1===J},this.netClientAdaptToServerControlsModes=function(a){-1!==J&&(0!==J||a.sw?1===J&&a.sw&&this.setMode(0):this.setMode(1))},this.toggleDirBig=function(){N=!N,D.directionalBig=N,WMSX.userPreferences.setDirty(),this.controllersSettingsStateUpdate()},this.toggleMirrored=function(){O=!O,D.mirrored=O,WMSX.userPreferences.setDirty(),this.controllersSettingsStateUpdate()},this.isDirBig=function(){return N},this.isMirrored=function(){return O},this.getPortActive=function(){return J},this.setTurboFireClocks=function(a){K=a,M=K/2|0,L=0},this.getMappingForControl=function(a,b){return null},this.screenReadjustedUpdate=function(){this.releaseControllers()},this.setupTouchControlsIfNeeded=function(a){function b(a,b){var c=wmsx.DOMTouchControls.createButton("wmsx-touch-"+b);c.wmsxControl=b,c.addEventListener("touchstart",n),c.addEventListener("touchmove",wmsx.Util.blockEvent),c.addEventListener("touchend",o),c.addEventListener("touchcancel",o),c.addEventListener("mousedown",n),c.addEventListener("mouseup",o),T[b]=c,a.appendChild(c)}if(!(P||J<0)){C=document.createElement("div"),C.id="wmsx-touch-speed";var c=document.createElement("div");c.id="wmsx-touch-pause",c.addEventListener("touchstart",q),c.addEventListener("mousedown",q),C.appendChild(c);var d=document.createElement("div");d.id="wmsx-touch-fast",d.addEventListener("touchstart",r),d.addEventListener("touchend",s),d.addEventListener("mousedown",r),d.addEventListener("mouseup",s),C.appendChild(d),a.appendChild(C);var f=document.createElement("div");f.id="wmsx-touch-left",b(f,wmsx.TouchControls.buttonsLeftSide[0]),P=wmsx.DOMTouchControls.createDirectional(),P.addEventListener("touchstart",h),P.addEventListener("touchmove",j),P.addEventListener("touchend",i),P.addEventListener("touchcancel",i),P.addEventListener("mousedown",g),f.appendChild(P),b(f,wmsx.TouchControls.buttonsLeftSide[1]),a.appendChild(f),f=document.createElement("div"),f.id="wmsx-touch-right";var k=wmsx.TouchControls.buttonsRightSide;for(var l in k)b(f,k[l]);a.appendChild(f),e(),t()}},this.startTouchDetection=function(a){E=a},this.stopTouchDetection=function(){E=null},this.customizeControl=function(a,b){"T_DIR"===a?D.directional=b:D.buttons[a]=b,this.updateMappingFor(a),WMSX.userPreferences.setDirty()},this.updateMappingFor=function(a){if("T_DIR"===a)P.wmsxMappingIsKeys="KEYBOARD"===D.directional,wmsx.DOMTouchControls.styleDirectionalMapping(P,D.directional);else{var b=T[a],c=D.buttons[a];b.wmsxMapping=c,wmsx.DOMTouchControls.styleButtonMapping(b,c)}},this.controllersSettingsStateUpdate=function(){var a=!!b.getSettingsState().touchActive;document.documentElement.classList.toggle("wmsx-touch-active",a),document.documentElement.classList.toggle("wmsx-dir-big",N),document.documentElement.classList.toggle("wmsx-touch-mirror",O),z.touchControlsActiveUpdate(a,N,O)},this.machinePowerAndUserPauseStateUpdate=function(a,b){V=a,W=b,C&&e()};var z,A,B,C,D,E,F=wmsx.MachineControls,G=wmsx.Util.isTouchDevice(),H=wmsx.Util.isMobileDevice(),I=WMSX.TOUCH_MODE>=1?WMSX.TOUCH_MODE-1:G?-1:-2,J=-1,K=0,L=0,M=0,N=!1,O=!1,P=null,Q=null,R=-1,S=0,T={},U=new x,V=!1,W=!1,X=wmsx.ControllersHub.TOUCH,Y=[15,14,6,7,5,13,9,11,10],Z=[[],["UP"],["RIGHT","UP"],["RIGHT"],["RIGHT","DOWN"],["DOWN"],["LEFT","DOWN"],["LEFT"],["LEFT","UP"]];this.saveState=function(){return{p:D}},this.loadState=function(a){if(v(),a.p){delete a.p.directionalBig,delete a.p.mirrored;for(var b in a.p)D[b]=a.p[b];for(var c in D.buttons){var d=D.buttons[c];d&&d.sn&&!d.c_en&&(d.c_en=d.sn)}P&&t()}}},wmsx.DOMTouchControls.createDirectional=function(a){function b(a){var b=document.createElement("div");b.classList.add("wmsx-touch-dir-"+a),c.appendChild(b);var d=document.createElement("div");d.classList.add("wmsx-arrow-"+a),c.appendChild(d)}var c=document.createElement("div");return a&&(c.id=a),c.classList.add("wmsx-touch-dir"),b("left"),b("right"),b("up"),b("down"),c},wmsx.DOMTouchControls.createButton=function(a){var b=document.createElement("div");return a&&(b.id=a),b.classList.add("wmsx-touch-button"),b},wmsx.DOMTouchControls.styleDirectionalMapping=function(a,b){a.classList.toggle("wmsx-touch-dir-key","KEYBOARD"===b),a.classList.toggle("wmsx-touch-dir-joy","KEYBOARD"!==b)},wmsx.DOMTouchControls.styleButtonMapping=function(a,b){if(a.innerHTML=b?b.n||b.c_en:"",b)if(b.button){a.classList.add("wmsx-touch-button-joy"),a.classList.remove("wmsx-touch-button-key","wmsx-touch-button-none");for(var c=["A","B","AB"],d=0;d<c.length;++d)b&&b.n===c[d]?a.classList.add("wmsx-touch-button-joy-"+c[d]):a.classList.remove("wmsx-touch-button-joy-"+c[d])}else b.key&&(a.classList.add("wmsx-touch-button-key"),a.classList.remove("wmsx-touch-button-joy","wmsx-touch-button-none"));else a.classList.add("wmsx-touch-button-none"),a.classList.remove("wmsx-touch-button-joy","wmsx-touch-button-key")},wmsx.ControllersHub=function(a,b){"use strict";function c(a){var b=j[a];return b&&b!==q?b.readLocalControllerPort(a)|y:z}function d(){for(var a=0;a<=1;++a)k[a]?j[a]=q:l[a]?j[a]=r:m[a]?j[a]=s:n[a]?j[a]=t:j[a]=null;t.controllersSettingsStateUpdate(),B.controllersSettingsStateUpdate()}function e(){var a=c(0),b=c(1);D[0]===a&&D[1]===b||(D[0]=a,D[1]=b,A=D)}function f(){if(F){g.netServerClearClientsMergedInfo();var b=a.netController.clients;for(var d in b){var e=b[d].controllersPortValues;e&&(E[0]&=e[0],E[1]&=e[1])}}var f=c(0)&E[0],h=c(1)&E[1];C[0]===f&&C[1]===h||(C[0]=f,C[1]=h,A=C)}var g=this;this.connect=function(a,b,c,d){c.connectControls(this),p.connect(a,d),q.connect(c),t.connect(b)},this.connectPeripherals=function(a){B=a,p.connectPeripherals(B),q.connectPeripherals(B),r.connectPeripherals(B),s.connectPeripherals(B),t.connectPeripherals(B)},this.powerOn=function(){p.powerOn(),q.powerOn(),r.powerOn(),s.powerOn(),t.powerOn()},this.powerOff=function(){p.powerOff(),q.powerOff(),r.powerOff(),s.powerOff(),t.powerOff()},this.getKeyboard=function(){return p},this.getTouchControls=function(){return t},this.releaseControllers=function(){p.releaseControllers(),r.releaseControllers(),s.releaseControllers(),q.releaseControllers(),t.releaseControllers()},this.resetControllers=function(){p.resetControllers(),r.resetControllers(),s.resetControllers(),q.resetControllers()},this.roomNetPlayStatusChangeUpdate=function(b){q.netSetClientMode(2===a.netPlayMode)},this.readKeyboardPort=function(a){return p.readKeyboardPort(a)},this.readControllerPort=function(a){var b=j[a];return b?b.readControllerPort(a):this.netGetMergedPortValues()[a]},this.writeControllerPin8Port=function(a,b){q.portPin8Announced(a,b);var c=j[a];c&&c.writeControllerPin8Port(a,b)},this.controllersClockPulse=function(){p.controllersClockPulse(),s.controllersClockPulse(),r.controllersClockPulse(),
t.controllersClockPulse(),1===a.netPlayMode?f():2===a.netPlayMode&&e()},this.toggleKeyboardLayout=function(a){p.toggleKeyboardLayout(a)},this.toggleJoystickMode=function(a){r.toggleMode(a)},this.toggleJoykeysMode=function(a){s.toggleMode(a)},this.toggleMouseMode=function(a){q.toggleMode(a)},this.toggleMouseLock=function(){q.togglePointerLock()},this.toggleTouchControlsMode=function(a,b){t.toggleMode(a,b)},this.toggleHapticFeedback=function(){w?(x=!x,WMSX.userPreferences.current.hapticFeedback=x,WMSX.userPreferences.setDirty()):this.showErrorMessage("Haptic Feedback not available")},this.toggleTurboFireSpeed=function(a){u+=a?-1:1,u=u>=0?u%11:11+u;var b=u?60/v[u]|0:0;p.setTurboFireClocks(b),r.setTurboFireClocks(b),s.setTurboFireClocks(b),t.setTurboFireClocks(b),B.controllersSettingsStateUpdate(),B.showOSD("Turbo Fire"+(u?" speed: "+this.getTurboFireSpeedDesc():": OFF"),!0)},this.getTurboFireSpeedDesc=function(){return u?u+"x":"OFF"},this.getControlReport=function(a){switch(a){case wmsx.PeripheralControls.TOUCH_TOGGLE_DIR_BIG:var b=t.isDirBig();return{label:b?"ON":"OFF",active:b};case wmsx.PeripheralControls.TOUCH_TOGGLE_MIRRORED:var c=t.isMirrored();return{label:c?"ON":"OFF",active:c};case wmsx.PeripheralControls.HAPTIC_FEEDBACK_TOGGLE_MODE:return{label:x?"ON":"OFF",active:!!x};case wmsx.PeripheralControls.TURBO_FIRE_TOGGLE:return{label:this.getTurboFireSpeedDesc(),active:!!u}}return{label:"Unknown",active:!1}},this.setupTouchControlsIfNeeded=function(a){t.setupTouchControlsIfNeeded(a)},this.setKeyInputElement=function(a){a.addEventListener("keydown",this.keyDown),a.addEventListener("keyup",this.keyUp)},this.screenReadjustedUpdate=function(){t.screenReadjustedUpdate()},this.screenFullscreenStateUpdate=function(a){q.screenFullscreenStateUpdate(a)},this.keyDown=function(a){return h(a,!0)},this.keyUp=function(a){return h(a,!1)},this.setMouseInputElement=function(a){q.setMouseInputElement(a)},this.setScreenPixelScale=function(a,b){q.setScreenPixelScale(a,b)},this.updateMouseConnections=function(a,b){k[0]=a,k[1]=b,d()},this.updateJoystickConnections=function(a,b){l[0]=a,l[1]=b,d()},this.updateJoykeysConnections=function(a,b){m[0]=a,m[1]=b,d()},this.updateTouchControlsConnections=function(a,b){n[0]=a,n[1]=b,d()},this.showStatusMessage=function(a){var b=k[0]||l[0]||m[0]||n[0]||"&nbsp-&nbsp-&nbsp&nbsp",c=k[1]||l[1]||m[1]||n[1]||"&nbsp-&nbsp-&nbsp&nbsp";B.showOSD((a?a+".&nbsp&nbsp":"")+"Port 1:&nbsp&nbsp"+b+",&nbsp&nbspPort 2:&nbsp&nbsp"+c,!0)},this.showErrorMessage=function(a){B.showOSD(a,!0,!0)},this.getSettingsState=function(){return o.mouseModeDesc=q.getModeDesc(),o.joysticksModeDesc=r.getModeDesc(),o.joykeysModeDesc=s.getModeDesc(),o.touchPortSet=t.getPortActive(),o.touchActive=j[0]===t||j[1]===t,o.ports[0]=k[0]||l[0]||m[0]||n[0]||wmsx.ControllersHub.NONE,o.ports[1]=k[1]||l[1]||m[1]||n[1]||wmsx.ControllersHub.NONE,o.turboFireSpeedDesc=this.getTurboFireSpeedDesc(),o},this.getMappingForControl=function(a,b){return j[b]&&j[b].getMappingForControl(a,b)},this.getMappingPopupText=function(a,b){return j[b]&&j[b].getMappingPopupText(a,b)},this.mappingPopupVisibility=function(a,b,c){c&&j[b]===r?r.startButtonDetection(b,a):r.stopButtonDetection()},this.customizeControl=function(a,b,c){j[b].customizeControl(a,b,c)},this.clearControl=function(a,b){return j[b].clearControl(a,b)},this.hapticFeedback=function(){x&&navigator.vibrate(8)},this.hapticFeedbackOnTouch=function(a){!x||"touchstart"!==a.type&&"touchend"!==a.type&&"touchmove"!==a.type||navigator.vibrate(8)};var h=function(a,b){a.returnValue=!1,a.preventDefault(),a.stopPropagation();var c=i.codeNewForKeyboardEvent(a);return s.processKey(c,b),!1};this.netGetInfoToSend=function(){var a=q.netGetMouseStateToSend();return a||A?{m:a,p:A}:void 0},this.netClearInfoToSend=function(){A=void 0,q.netClearMouseInfoToSend()},this.netServerGetFullInfo=function(){return{m:q.netServerGetMouseState(),p:C}},this.netGetMergedPortValues=function(){return C},this.netClientReceiveServerInfo=function(a){a.m&&q.netClientReceiveServerMouseState(a.m);var b=a.p;b&&(C[0]=b[0],C[1]=b[1])},this.netServerReceiveClientInfo=function(a,b){b.m&&q.netServerReceiveClientMouseState(b.m);var c=b.p;c&&(F=!0,a.controllersPortValues=c[0]!==z||c[1]!==z?c:void 0)},this.netServerClearClientsMergedInfo=function(){E[0]=z,E[1]=z,F=!1},this.netServerGetControlsModes=function(){return{m:q.getModeEffective(),sw:s.getSwappedState()||r.getSwappedState()||t.getSwappedState()}},this.netClientGetControlsModes=function(){return{k:s.getMode(),j:r.getMode(),m:q.getModeEffective(),t:t.getMode()}},this.netClientRestoreControlsModes=function(a){s.setMode(a.k),r.setMode(a.j),q.setModeEffective(a.m),t.setMode(a.t)},this.netClientAdaptToServerControlsModes=function(a){s.netClientAdaptToServerControlsModes(a),r.netClientAdaptToServerControlsModes(a),q.netClientAdaptToServerControlsModes(a),t.netClientAdaptToServerControlsModes(a)},this.saveState=function(){return{jk:y,t:t.saveState(),h:x}},this.loadState=function(a){void 0!==a.jk&&(y=a.jk,z=63|y,this.portValueAllReleased=z),a.t&&t.loadState(a.t),void 0!==a.h&&(x=a.h&&w)};var i=wmsx.DOMKeys,j=[null,null],k=[null,null],l=[null,null],m=[null,null],n=[null,null],o={ports:[null,null]},p=new wmsx.DOMKeyboard(this,a,b),q=new wmsx.DOMMouseControls(a,this),r=new wmsx.GamepadJoysticksControls(a,this,p),s=new wmsx.DOMJoykeysControls(a,this,p),t=new wmsx.DOMTouchControls(a,this,p,b),u=0,v=[0,2,2.4,3,4,5,6,7.5,10,12,15],w=!!navigator.vibrate,x=w&&!!WMSX.userPreferences.current.hapticFeedback,y=0!==WMSX.KEYBOARD_JAPAN_LAYOUT?64:0,z=63|y;this.portValueAllReleased=z;var A,B,C=[z,z],D=[z,z],E=[z,z],F=!1;wmsx.ControllersHub.hapticFeedback=this.hapticFeedback,wmsx.ControllersHub.hapticFeedbackOnTouch=this.hapticFeedbackOnTouch},wmsx.ControllersHub.MOUSE="MOUSE",wmsx.ControllersHub.JOYSTICK="JOYSTICK",wmsx.ControllersHub.JOYKEYS="JOYKEYS",wmsx.ControllersHub.TOUCH="TOUCH",wmsx.ControllersHub.JOY_ANY="JOY",wmsx.ControllersHub.NONE="NO DEVICE",wmsx.DOMMachineControls=function(a,b){"use strict";function c(b,c,e,f){if(2===a.netPlayMode&&(S.has(b)||T.has(b)))return a.showOSD("Function not available in NetPlay Client mode",!0,!0);1===a.netPlayMode&&S.has(b)||n.push({c:b<<4|e<<1|c,d:f}),2!==a.netPlayMode&&d(b,c,e,f)}function d(a,b,c,d){g.controlStateChanged(a,b,c,d),R.has(a)&&h.quickOptionsControlsStateUpdate()}this.connect=function(a){g=a},this.connectPeripherals=function(a){h=a},this.powerOn=function(){e()},this.powerOff=function(){},this.processKey=function(a,d){var e=a&Q,f=k[e];return!f||m[a]?b.processKey(a,d):d===l[e]||(l[e]=d,c(f,d,e!==a),!0)},this.processControlState=c,this.getControlReport=function(a){return g.getControlReport(a)};var e=function(){window.onhelp=function(){return!1}},f=function(){var a=i;k[o]=j.POWER,k[o|a.ALT]=j.POWER,k[p]=j.FAST_SPEED,k[p|a.ALT]=j.FAST_SPEED,k[q|a.ALT]=j.INC_SPEED,k[r|a.ALT]=j.DEC_SPEED,k[s|a.ALT]=j.NORMAL_SPEED,k[t|a.ALT]=j.MIN_SPEED,m[q|a.ALT]=!0,m[r|a.ALT]=!0,m[s|a.ALT]=!0,m[t|a.ALT]=!0,k[u|a.ALT]=j.PAUSE,k[v|a.ALT]=j.FRAME,k[w|a.ALT]=j.FRAME,k[x|a.ALT]=j.DEBUG,k[y|a.ALT]=j.SPRITE_MODE,k[z|a.ALT]=j.VIDEO_STANDARD,k[A|a.ALT]=j.CPU_TURBO_MODE,k[B|a.ALT]=j.VDP_TURBO_MODE,k[C|a.CONTROL|a.ALT]=j.SAVE_STATE_0,k[D|a.CONTROL|a.ALT]=j.SAVE_STATE_0,k[E|a.CONTROL|a.ALT]=j.SAVE_STATE_1,k[F|a.CONTROL|a.ALT]=j.SAVE_STATE_2,k[G|a.CONTROL|a.ALT]=j.SAVE_STATE_3,k[H|a.CONTROL|a.ALT]=j.SAVE_STATE_4,k[I|a.CONTROL|a.ALT]=j.SAVE_STATE_5,k[J|a.CONTROL|a.ALT]=j.SAVE_STATE_6,k[K|a.CONTROL|a.ALT]=j.SAVE_STATE_7,k[L|a.CONTROL|a.ALT]=j.SAVE_STATE_8,k[M|a.CONTROL|a.ALT]=j.SAVE_STATE_9,k[N|a.CONTROL|a.ALT]=j.SAVE_STATE_10,k[O|a.CONTROL|a.ALT]=j.SAVE_STATE_11,k[P|a.CONTROL|a.ALT]=j.SAVE_STATE_12,k[C|a.ALT]=j.LOAD_STATE_0,k[D|a.ALT]=j.LOAD_STATE_0,k[E|a.ALT]=j.LOAD_STATE_1,k[F|a.ALT]=j.LOAD_STATE_2,k[G|a.ALT]=j.LOAD_STATE_3,k[H|a.ALT]=j.LOAD_STATE_4,k[I|a.ALT]=j.LOAD_STATE_5,k[J|a.ALT]=j.LOAD_STATE_6,k[K|a.ALT]=j.LOAD_STATE_7,
k[L|a.ALT]=j.LOAD_STATE_8,k[M|a.ALT]=j.LOAD_STATE_9,k[N|a.ALT]=j.LOAD_STATE_10,k[O|a.ALT]=j.LOAD_STATE_11,k[P|a.ALT]=j.LOAD_STATE_12};this.netGetControlsToSend=function(){return n.length?n:void 0},this.netClearControlsToSend=function(){n.length=0},this.netServerProcessControlsChanges=function(a){for(var b=0,c=a.length;b<c;++b){var e=a[b];S.has(e.c>>4)||n.push(e),d(e.c>>4,1&e.c,2&e.c,e.d)}},this.netClientApplyControlsChanges=function(a){for(var b=0,c=a.length;b<c;++b){var e=a[b];d(e.c>>4,1&e.c,2&e.c,e.d)}};var g,h,i=wmsx.DOMKeys,j=wmsx.MachineControls,k={},l={},m={},n=new Array(100);n.length=0;var o=i.VK_F11.wc,p=i.VK_F12.wc,q=i.VK_UP.wc,r=i.VK_DOWN.wc,s=i.VK_RIGHT.wc,t=i.VK_LEFT.wc,u=i.VK_P.wc,v=i.VK_O.wc,w=i.VK_F.wc,x=i.VK_D.wc,y=i.VK_S.wc,z=i.VK_Q.wc,A=i.VK_T.wc,B=i.VK_Y.wc,C=i.VK_QUOTE.wc,D=i.VK_BACKQUOTE.wc,E=i.VK_1.wc,F=i.VK_2.wc,G=i.VK_3.wc,H=i.VK_4.wc,I=i.VK_5.wc,J=i.VK_6.wc,K=i.VK_7.wc,L=i.VK_8.wc,M=i.VK_9.wc,N=i.VK_0.wc,O=i.VK_MINUS.wc,P=i.VK_EQUALS.wc,Q=~i.SHIFT,R=new Set([j.VIDEO_STANDARD,j.CPU_TURBO_MODE,j.VDP_TURBO_MODE,j.SPRITE_MODE,j.VSYNCH]),S=new Set([j.SAVE_STATE_0,j.SAVE_STATE_1,j.SAVE_STATE_2,j.SAVE_STATE_3,j.SAVE_STATE_4,j.SAVE_STATE_5,j.SAVE_STATE_6,j.SAVE_STATE_7,j.SAVE_STATE_8,j.SAVE_STATE_9,j.SAVE_STATE_10,j.SAVE_STATE_11,j.SAVE_STATE_12,j.SAVE_STATE_FILE,j.LOAD_STATE_0,j.LOAD_STATE_1,j.LOAD_STATE_2,j.LOAD_STATE_3,j.LOAD_STATE_4,j.LOAD_STATE_5,j.LOAD_STATE_6,j.LOAD_STATE_7,j.LOAD_STATE_8,j.LOAD_STATE_9,j.LOAD_STATE_10,j.LOAD_STATE_11,j.LOAD_STATE_12,j.TRACE]),T=new Set([j.VSYNCH]);!function(){f()}()},wmsx.DOMVirtualKeyboard=function(a,b,c){"use strict";function d(a){a.addEventListener("touchstart",e),a.addEventListener("mousedown",e),a.addEventListener("touchend",f),a.addEventListener("mouseup",f)}function e(a){h(a);var c=a.target.wmsxKey;c&&(b.processMSXKey(c,!0),"SHIFT"===c&&g())}function f(a){h(a);var c=a.target.wmsxKey;c&&(b.processMSXKey(c,!1),"SHIFT"===c&&g())}function g(){var a=b.isShiftPressed();a!==k&&(k=a,j&&wmsx.VirtualKeyboard.updateKeysLabels(j,k,l,m))}function h(a){a.stopPropagation(),a.preventDefault()}var i=this;this.machineTypeStateUpdate=function(){var a=c.getMachineLang(),b=c.getCodeKeyLabel();a===l&&b===m||(l=a,m=b,j&&wmsx.VirtualKeyboard.updateKeysLabels(j,k,l,m))};var j,k=!1,l="en",m="CODE";!function(){c.addMachineTypeStateListener(i),j=wmsx.VirtualKeyboard.create(a,d,k,l,m)}()},wmsx.ScreenGUI=wmsx.Util.isMobileDevice()?{BAR_HEIGHT:29,BAR_MENU_WIDTH:150,BAR_MENU_ITEM_HEIGHT:33,BAR_MENU_ITEM_FONT_SIZE:14,LOGO_SCREEN_WIDTH:597,LOGO_SCREEN_HEIGHT:455,TOUCH_CONTROLS_LEFT_WIDTH:119,TOUCH_CONTROLS_LEFT_WIDTH_BIG:143,TOUCH_CONTROLS_RIGHT_WIDTH:80}:{BAR_HEIGHT:29,BAR_MENU_WIDTH:140,BAR_MENU_ITEM_HEIGHT:29,BAR_MENU_ITEM_FONT_SIZE:13,LOGO_SCREEN_WIDTH:597,LOGO_SCREEN_HEIGHT:455,TOUCH_CONTROLS_LEFT_WIDTH:119,TOUCH_CONTROLS_LEFT_WIDTH_BIG:143,TOUCH_CONTROLS_RIGHT_WIDTH:80},wmsx.ScreenGUI.html=function(){return'<div id="wmsx-screen-fs" tabindex="0"> <div id="wmsx-screen-fs-center" tabindex="-1"> <div id="wmsx-screen-canvas-outer"> <canvas id="wmsx-screen-canvas" tabindex="-1"></canvas> <img id="wmsx-canvas-loading-icon" draggable="false" src="'+wmsx.Images.urls.loading+'"> <div id="wmsx-unmute-message"></div> <div id="wmsx-logo"> <div id="wmsx-logo-center"> <img id="wmsx-logo-image" draggable="false" src="'+wmsx.Images.urls.logo+'"> <img id="wmsx-logo-loading-icon" draggable="false" src="'+wmsx.Images.urls.loading+'"> <div id="wmsx-logo-message"> <div id="wmsx-logo-message-text"></div> <div id="wmsx-logo-message-ok"> <div id="wmsx-logo-message-ok-text"></div> </div> </div> </div> </div> <div id="wmsx-osd"></div> </div> <div id="wmsx-drop-area"> <div id="wmsx-drop-drivea"><div id="wmsx-drop-drivea-add" class="wmsx-drop-add"></div><i></i><div id="wmsx-drop-drivea-files" class="wmsx-drop-files"></div><br>Drive A</div> <div id="wmsx-drop-driveb"><div id="wmsx-drop-driveb-add" class="wmsx-drop-add"></div><i></i><div id="wmsx-drop-driveb-files" class="wmsx-drop-files"></div><br>Drive B</div> <div id="wmsx-drop-driveh"><i></i><div id="wmsx-drop-driveh-files" class="wmsx-drop-files"></div><br>Hard Drive</div> <div id="wmsx-drop-cart1"><i></i><br>Cartridge 1</div> <div id="wmsx-drop-cart2"><i></i><br>Cartridge 2</div> <div id="wmsx-drop-tape"><i></i><br>Cassette</div> <span id="wmsx-drop-area-message"></span> </div> <div id="wmsx-bar"> <div id="wmsx-bar-inner"></div> </div> </div> <div id="wmsx-screen-scroll-message"> Swipe up/down on the Screen <br>to hide the browser bars! </div> </div>'},wmsx.ScreenGUI.css=function(){
return"html.wmsx-full-screen-scroll-hack body { position: absolute; width: 100%; height: "+Math.max(1280,1.4*Math.max(screen.width,screen.height)|0)+"px; top: 0; left: 0; margin: 0; padding: 0; border: none; overflow-x: hidden; overflow-y: auto; } #wmsx-screen-fs, #wmsx-screen-fs div, #wmsx-screen-fs canvas { outline: none; } #"+WMSX.SCREEN_ELEMENT_ID+" { display: inline-block; visibility: hidden; font-family: sans-serif; font-weight: normal; margin: 0; padding: 0; border: 1px solid black; background: black; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; -webkit-touch-callout: none; touch-callout: none; -webkit-tap-highlight-color: transparent; tap-highlight-color: transparent; -webkit-text-size-adjust: none; -moz-text-size-adjust: none; text-size-adjust: none; } html.wmsx-full-screen #"+WMSX.SCREEN_ELEMENT_ID+" { display: block; position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: none; box-shadow: none; z-index: 2147483646;    /* one behind fsElement */ } html.wmsx-started #"+WMSX.SCREEN_ELEMENT_ID+" { visibility: visible; } #wmsx-screen-scroll-message { position: absolute; left: 0; right: 0; bottom: -50%; width: 0; height: 0; padding: 0; margin: 0 auto; font-size: 16px; line-height: 28px; color: hsl(0, 0%, 4%); white-space: nowrap; background: hsl(0, 0%, 92%); border-radius: 15px; box-shadow: 2px 2px 9px rgba(0, 0, 0, 0.7); transition: all 1.7s step-end, opacity 1.6s linear; opacity: 0; z-index: -1; } html.wmsx-full-screen-scroll-hack #wmsx-screen-fs.wmsx-scroll-message #wmsx-screen-scroll-message { opacity: 1; bottom: 23%; width: 215px; height: 56px; padding: 13px 20px; z-index: 10; transition: none; } #wmsx-screen-fs { position: relative; background: black; text-align: center; overflow: hidden; -webkit-tap-highlight-color: rgba(0,0,0,0); tap-highlight-color: rgba(0,0,0,0) } html.wmsx-full-screen #wmsx-screen-fs { position: absolute; width: 100%; height: 100%; left: 0; bottom: 0; right: 0; z-index: 2147483647; } html.wmsx-full-screen-scroll-hack #wmsx-screen-fs { position: fixed; bottom: 0; height: 100vh; } html.wmsx-full-screen #wmsx-screen-fs-center {      /* Used to center and move things horizontally in Landscape Full Screen */ position: absolute; top: 0; bottom: 0; left: 0; right: 0; } #wmsx-screen-canvas-outer { display: inline-block; position: relative; vertical-align: top; line-height: 1px; z-index: 3; } #wmsx-screen-canvas { display: block; } #wmsx-bar { position: relative; left: 0; right: 0; height: "+this.BAR_HEIGHT+'px; margin: 0 auto; border-top: 1px solid black; background: hsl(0, 0%, 16%); overflow: visible;                    /* for the Menu to show through */ box-sizing: content-box; z-index: 5; } #wmsx-bar-inner { position: absolute; overflow: hidden; top: 0; bottom: 0; left: 0; right: 0; text-align: left; } html.wmsx-bar-auto-hide #wmsx-bar, html.wmsx-full-screen #wmsx-bar { position: absolute; bottom: 0; transition: height 0.08s ease-in-out; } html.wmsx-bar-auto-hide #wmsx-bar.wmsx-hidden { transition: height 0.5s ease-in-out; height: 0; bottom: -1px; } @media only screen and (orientation: landscape) { html.wmsx-full-screen #wmsx-bar.wmsx-hidden { transition: height 0.5s ease-in-out; height: 0; bottom: -1px; } } #wmsx-bar.wmsx-narrow .wmsx-narrow-hidden { display: none; } .wmsx-bar-button { display: inline-block; width: 24px; height: 29px; margin: 0 1px; background-image: url("'+wmsx.Images.urls.sprites+'"); background-repeat: no-repeat; background-size: 568px 206px; cursor: pointer; } .wmsx-bar-button.wmsx-media-button { background-size: 284px 103px; } .wmsx-bar-button.wmsx-hidden { display: none; } /* Firefox-specific rules */ @-moz-document url-prefix() { .wmsx-bar-button { image-rendering: optimizequality; } } /* .wmsx-bar-button { border: 1px solid yellow; background-origin: border-box; box-sizing: border-box; } */ #wmsx-bar-power { margin-left: 6px; } #wmsx-bar-media-icons { margin-left: 10px; } #wmsx-bar-settings, #wmsx-bar-full-screen, #wmsx-bar-scale-plus, #wmsx-bar-scale-minus { float: right; margin: 0; } #wmsx-bar-settings { margin-right: 5px; } #wmsx-bar-full-screen.wmsx-mobile { margin: 0 6px; } #wmsx-bar-scale-plus { width: 21px; } #wmsx-bar-scale-minus { width: 18px; } #wmsx-bar-text { float: right; width: 32px; } #wmsx-bar-text.wmsx-mobile { margin: 0 0 0 6px; } #wmsx-bar-keyboard { position: absolute; left: 0; right: 0; width: 37px; margin: 0 auto; } #wmsx-bar.wmsx-narrow #wmsx-bar-keyboard { position: static; float: right; } #wmsx-bar-logo { position: absolute; left: 0; right: 0; width: 52px; margin: 0 auto; } #wmsx-bar-turbo, #wmsx-bar-caps, #wmsx-bar-kana { position: absolute; left: 0; right: 0; width: 47px; margin: 0 auto; padding: 8px 0 0 0; color: hsl(0, 98%, 61%); font-weight: bold; font-size: 12px; line-height: 14px; text-shadow: 2px 2px 0 black; vertical-align: top; box-sizing: border-box; } #wmsx-bar-turbo     { left: 109px; padding-left: 25px } #wmsx-bar-caps      { left: calc(166px + 10%); height: 29px; background: none; } #wmsx-bar-kana      { left: calc(170px + 25%); height: 29px; background: none; } #wmsx-bar-menu { position: absolute; display: none; bottom: '+this.BAR_HEIGHT+"px; font-size: "+this.BAR_MENU_ITEM_FONT_SIZE+"px; line-height: 1px; overflow: hidden; transform-origin: bottom center; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } #wmsx-bar-menu-inner { display: inline-block; padding-bottom: 2px; border: 1px solid black; background: hsl(0, 0%, 16%); } .wmsx-bar-menu-item, #wmsx-bar-menu-title { position: relative; display: none; width: "+this.BAR_MENU_WIDTH+"px; height: "+this.BAR_MENU_ITEM_HEIGHT+"px; color: rgb(205, 205, 205); border: none; padding: 0; line-height: "+this.BAR_MENU_ITEM_HEIGHT+'px; text-shadow: 1px 1px 1px black; background: transparent; outline: none; overflow: hidden; backface-visibility: hidden; -webkit-backface-visibility: hidden; cursor: pointer; box-sizing: border-box; } #wmsx-bar-menu-title { display: block; color: white; font-weight: bold; border-bottom: 1px solid black; margin-bottom: 1px; text-align: center; background: rgb(70, 70, 70); cursor: auto; } .wmsx-bar-menu-item.wmsx-hover:not(.wmsx-bar-menu-item-disabled):not(.wmsx-bar-menu-item-divider) { color: white; background: hsl(358, 67%, 46%); } .wmsx-bar-menu-item-disabled { color: rgb(110, 110, 110); } .wmsx-bar-menu-item-divider { height: 1px; margin: 1px 0; background: black; } .wmsx-bar-menu-item-toggle { text-align: left; padding-left: 33px; } .wmsx-bar-menu-item-toggle::before, .wmsx-bar-menu-item-toggle::after { content: ""; position: absolute; width: 6px; height: 9px; top: '+((this.BAR_MENU_ITEM_HEIGHT-21)/2|0)+"px; left: 12px; background: rgb(82, 82, 82); box-shadow: black 1px 1px 1px; } .wmsx-bar-menu-item-toggle::after { top: "+((this.BAR_MENU_ITEM_HEIGHT-21)/2+10|0)+"px; } .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked { color: white; } .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked.wmsx-op1::before, .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked.wmsx-op3::before { background: rgb(254, 32, 30); } .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked.wmsx-op2::after, .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked.wmsx-op3::after { background: rgb(254, 32, 30); } .wmsx-bar-menu-item-toggle.wmsx-no-op2::before { top: "+((this.BAR_MENU_ITEM_HEIGHT-21)/2+2|0)+'px; height: 16px; } .wmsx-bar-menu-item-toggle.wmsx-no-op2::after { display: none; } .wmsx-select-dialog { position: absolute; overflow: hidden; display: none; top: 0; bottom: 0; left: 0; right: 0; width: 540px; max-width: 92%; height: 297px; margin: auto; color: white; font-size: 18px; background: hsl(0, 0%, 16%); padding: 14px 0 0; text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 4; } .wmsx-select-dialog.wmsx-show { display: block; } .wmsx-select-dialog > .wmsx-footer { position: absolute; width: 100%; bottom: 7px; font-size: 13px; text-align: center; color: rgb(170, 170, 170); } .wmsx-select-dialog > ul { position: relative; width: 88%; top: 5px; margin: auto; padding: 0; list-style: none; font-size: 14px; color: hsl(0, 0%, 88%); } .wmsx-select-dialog > ul li { display: none; position: relative; overflow: hidden; height: 26px; background: rgb(70, 70, 70); margin: 7px 0; padding: 11px 10px 0; line-height: 0; text-align: left; text-overflow: ellipsis; border: 2px dashed transparent; box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); white-space: nowrap; box-sizing: border-box; cursor: pointer; } .wmsx-select-dialog > ul li.wmsx-visible { display: block; } .wmsx-select-dialog > ul li.wmsx-selected { color: white; background: hsl(358, 67%, 46%); } .wmsx-select-dialog > ul li.wmsx-droptarget { color: white; border-color: lightgray; } .wmsx-select-dialog > ul li.wmsx-toggle::after { content: ""; position: absolute; width: 6px; height: 17px; top: 2px; left: 6px; background: rgb(60, 60, 60); box-shadow: black 1px 1px 1px; } .wmsx-select-dialog > ul li.wmsx-toggle-checked::after { background: rgb(254, 32, 30); } #wmsx-diskselect.wmsx-select-dialog li { padding-left: 23px; } #wmsx-diskselect.wmsx-select-dialog li.wmsx-toggle::after { background: hsl(0, 0%, 73%); } #wmsx-diskselect.wmsx-select-dialog li.wmsx-toggle-checked::after { background: rgb(230, 205, 31); } #wmsx-cartridge-format.wmsx-select-dialog > ul { width: 100%; height: 292px; margin: 7px auto 0; padding: 0 0 0 30px; overflow-y: auto; box-sizing: border-box; } #wmsx-cartridge-format.wmsx-select-dialog > ul li { width: 220px; margin: 7px 0 2px 0; } #wmsx-cartridge-format.wmsx-select-dialog > ul li:first-child { margin-top: 0; } #wmsx-cartridge-format ::-webkit-scrollbar { width: 12px; } #wmsx-cartridge-format ::-webkit-scrollbar-track { background: transparent; } #wmsx-cartridge-format ::-webkit-scrollbar-thumb { border: solid transparent; border-width: 1px 1px 1px 2px; background: rgb(80, 80, 80); background-clip: content-box; } #wmsx-cartridge-format ul.wmsx-quick-options-list { width: 220px; margin: 18px 0 0 30px; } #wmsx-cartridge-format ul.wmsx-quick-options-list li div { height: 24px; line-height: 24px; } #wmsx-cartridge-format .wmsx-control { width: 52px; line-height: 24px; cursor: pointer; } /* Firefox-specific rules */ @-moz-document url-prefix() { /* Try to hide scrollbar, since we cant style it :-( */ #wmsx-cartridge-format.wmsx-select-dialog > ul { width: 304px; } } #wmsx-savestate { width: 280px; height: 403px; } #wmsx-savestate.wmsx-load { height: 438px; } #wmsx-savestate ul.wmsx-quick-options-list { display: none; width: 220px; margin: 18px 0 0 30px; } #wmsx-savestate.wmsx-load ul.wmsx-quick-options-list { display: block; } #wmsx-savestate ul.wmsx-quick-options-list li div { height: 24px; line-height: 24px; } #wmsx-savestate .wmsx-control { width: 52px; cursor: pointer; } #wmsx-logo { position: absolute; display: none; top: 0; bottom: 0; left: 0; right: 0; background: black; } #wmsx-logo.wmsx-show { display: block; } #wmsx-logo-center { position: absolute; top: 50%; left: 50%; width: 598px; height: 456px; transform: translate(-50%, -50%); } #wmsx-screen-fs:not(.wmsx-logo-message-active) #wmsx-logo-center { max-width: 100%; max-height: 100%; } #wmsx-logo-image { position: absolute; top: 50%; left: 50%; width: 334px; max-width: 57%; transform: translate(-50%, -50%); -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; } html.wmsx-full-screen #wmsx-logo-image { max-width: 67%; } #wmsx-screen-fs.wmsx-logo-message-active #wmsx-logo-image { top: 138px; max-width: initial; } #wmsx-unmute-message { display: none; position: absolute; left: 50%; bottom: 5px; height: 30px; padding: 0 10px; margin: 0 auto; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; font-weight: 500; font-size: 15px; line-height: 30px; color: rgb(210, 210, 210); background: rgba(0, 0, 0, 0.7); transform-origin: bottom center; transform: translate(-50%, 0); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } #wmsx-unmute-message::before { content: ""; display: inline-block; width: 24px; height: 20px; margin: 5px 9px 0 0; background-image: url("'+wmsx.Images.urls.muteIcon+'"); background-repeat: no-repeat; background-size: 24px 20px; vertical-align: top; } #wmsx-unmute-message::after { content: "Audio is muted. Click to unmute"; } #wmsx-unmute-message.wmsx-show { display: inline-block; } #wmsx-logo-loading-icon, #wmsx-canvas-loading-icon { display: none; position: absolute; top: 62%; left: 0; right: 0; width: 14%; height: 3%; margin: 0 auto; background-color: rgba(0, 0, 0, .8); border: solid transparent; border-width: 12px 30px; border-radius: 3px; box-sizing: content-box; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; } #wmsx-screen-fs.wmsx-logo-message-active #wmsx-logo-loading-icon { top: 190px; } #wmsx-logo-message { display: none; position: absolute; top: 224px; width: 100%; color: hsl(0, 0%, 97%); font-size: 29px; line-height: 34px; } #wmsx-screen-fs.wmsx-logo-message-active #wmsx-logo-message { display: block; } #wmsx-logo-message-ok { display: block; position: absolute; top: 91px; left: 193px; width: 214px; height: 130px; } #wmsx-logo-message-ok.wmsx-higher { top: 74px; } #wmsx-logo-message-ok-text { position: absolute; top: 49%; left: 50%; width: 120px; height: 47px; font-size: 23px; line-height: 47px; background: hsl(358, 67%, 46%); border-radius: 6px; color: white; transform: translate(-50%, -50%); } #wmsx-osd { position: absolute; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; top: -29px; right: 20px; height: 28px; padding: 0 10px; margin: 0; font-weight: bold; font-size: 15px; line-height: 28px; color: rgb(0, 255, 0); background: rgba(0, 0, 0, 0.7); transform-origin: top right; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; opacity: 0; } #wmsx-copy-texarea { position: absolute; width: 50px; height: 0; bottom: 0; z-index: -10; opacity: 0; } #wmsx-paste-cover { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 340px; height: 136px; margin: auto; border-radius: 20px; background: rgba(0, 0, 0, 0.4); z-index: 1; } #wmsx-paste-cover.wmsx-show { display: block; } #wmsx-paste-box { position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 270px; height: 66px; margin: auto; background: rgba(255, 40, 40, 0.75); font-weight: bold; font-size: 26px; text-align: center; color: transparent; border: 2px dashed rgba(240, 240, 240, 0.70); box-sizing: initial; border-radius: 10px; text-shadow: 0 0 0 rgb(240, 240, 240); padding: 0; outline: none; } #wmsx-text-entry-dialog { display: none; position: absolute; top: 25px; left: 0; right: 0; width: 96%; max-width: 540px; height: 47%; max-height: 450px; margin: 0 auto; color: white; font-size: 19px; line-height: 23px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 4; } #wmsx-text-entry-dialog.wmsx-show { display: block; } #wmsx-text-entry-dialog-bar { position: absolute; height: 40px; width: 100%; line-height: 40px; background: inherit; overflow: hidden; } #wmsx-text-entry-dialog-bar::before { content: "Input Text"; } #wmsx-text-entry-dialog-ok, #wmsx-text-entry-dialog-cancel { display: inline-block; float: right; width: 70px; height: 22px; margin-right: 15px; border: 9px solid hsl(0, 0%, 16%); border-left: none; border-right: none; font-size: 14px; line-height: 22px; background: hsl(358, 67%, 46%); cursor: pointer; } #wmsx-text-entry-dialog-cancel { color: hsl(0, 0%, 90%); background: hsl(0, 0%, 30%); } #wmsx-text-entry-dialog-ok::before { content: "OK"; } #wmsx-text-entry-dialog-cancel::before { content: "CANCEL"; } #wmsx-text-entry-input { position: absolute; top: 15px; left: 15px; width: calc(100% - 30px); height: calc(100% - 30px); padding: 29px 6px 4px; font-size: 16px; border: none; border-radius: 0; background: hsl(0, 0%, 90%); box-sizing: border-box; resize: none; outline: none; -webkit-touch-callout: default; touch-callout: default; } .wmsx-arrow-up, .wmsx-arrow-down, .wmsx-arrow-left, .wmsx-arrow-right { border: 0px solid transparent; box-sizing: border-box; } .wmsx-arrow-up    { border-bottom-color: inherit; } .wmsx-arrow-down  { border-top-color: inherit; } .wmsx-arrow-left  { border-right-color: inherit; } .wmsx-arrow-right { border-left-color: inherit; } .wmsx-keyboard-key { position: absolute; height: 25px; padding: 5px 0 0; overflow: hidden; font-weight: normal; font-size: 10px; line-height: 10px; text-align: center; vertical-align: top; color: white; background: hsl(0, 0%, 66%); border: 3px solid hsl(0, 0%, 50%); border-top: 1px solid hsl(0, 0%, 54%); border-bottom: 5px solid hsl(0, 0%, 33%); border-radius: 3px 3px 0 0; box-shadow: 0 1px 0 1px rgb(0, 0, 0); box-sizing: border-box; cursor: pointer; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } .wmsx-keyboard-key.wmsx-keyboard-key-dark { background: hsl(0, 0%, 46%); border-color: hsl(0, 0%, 36%); border-top-color: hsl(0, 0%, 40%); border-bottom-color: hsl(0, 0%, 24%); } .wmsx-keyboard-key.wmsx-keyboard-key-unmapped { color: rgb(30, 30, 30); font-weight: bold; -webkit-font-smoothing: initial; -moz-osx-font-smoothing: initial; } .wmsx-keyboard-alpha, .wmsx-keyboard-num, .wmsx-keyboard-arrows { position: absolute; } .wmsx-keyboard-alpha > div, .wmsx-keyboard-num > div, .wmsx-keyboard-arrows > div { position: absolute; } .wmsx-keyboard-num { left: 416px; } .wmsx-keyboard-arrows { top: 104px; left: 417px; } .wmsx-keyboard-f1, .wmsx-keyboard-f2, .wmsx-keyboard-f3, .wmsx-keyboard-f4, .wmsx-keyboard-f5, .wmsx-keyboard-stop, .wmsx-keyboard-select, .wmsx-keyboard-home, .wmsx-keyboard-insert, .wmsx-keyboard-delete { height: 18px; padding-top: 2px; font-size: 9px; line-height: 9px; border-width: 1px 2px 4px; } .wmsx-keyboard-stop { margin-left: 10px; background: hsl(0, 70%, 54%); border-color: hsl(0, 70%, 36%); border-top-color: hsl(0, 70%, 40%); border-bottom-color: hsl(0, 70%, 28%); } .wmsx-keyboard-enter { border-radius: 2px 3px 0 0; border-top: none; box-shadow: none; overflow: visible; } .wmsx-keyboard-enter::after { content: ""; display: block; position: absolute; left: -10px; bottom: -7px; width: 20px; height: 2px; background: black; } .wmsx-keyboard-enter_x1 { border-radius: 2px 0 0 0; border-width: 1px; border-right: none; box-shadow: -1px 1px 0 0 black; } .wmsx-keyboard-enter_x2 { overflow: visible; padding: 0; border: none; border-radius: 0 3px 0 0; box-shadow: none; box-shadow: 1px 1px 0 0 black; } .wmsx-keyboard-enter_x2::after { content: ""; display: block; width: 30px; height: 50px; background: inherit; border: 3px solid hsl(0, 0%, 36%); border-top: 1px solid hsl(0, 0%, 40%); border-bottom: 5px solid hsl(0, 0%, 24%); border-radius: 0 3px 0 0; box-shadow: 1px 2px 0 0 black, 1px 0 0 0 black; box-sizing: border-box; } .wmsx-keyboard-capslock { margin-left: 16px; } .wmsx-keyboard-space { left: 103px; width: 217px; } .wmsx-keyboard-dead { left: 333px; width: 26px; } .wmsx-keyboard-shift2 { left: 360px; width: 41px; } .wmsx-keyboard-code { left: 321px; width: 46px; } .wmsx-keyboard-num .wmsx-keyboard-key { height: 23px; padding-top: 4px; } .wmsx-keyboard-arrows .wmsx-keyboard-key { font-size: 8px; line-height: 9px; background: rgb(70, 85, 180); border-width: 1px 2px 4px; border-radius: 2px 2px 0 0; border-color: hsl(232, 44%, 37%); border-top-color: hsl(232, 44%, 40%); border-bottom-color: hsl(232, 44%, 24%); } .wmsx-keyboard-left, .wmsx-keyboard-right { top: 6px; width: 26px; height: 33px; padding: 10px 0 0 6px; } .wmsx-keyboard-up, .wmsx-keyboard-down { left: 27px; width: 37px; height: 23px; padding: 5px 0 0 12px; } .wmsx-keyboard-down { top: 23px; padding-top: 7px; } .wmsx-keyboard-right { left: 65px; padding-left: 10px; } .wmsx-keyboard-up::after, .wmsx-keyboard-down::after, .wmsx-keyboard-left::after, .wmsx-keyboard-right::after { content: ""; display: block; border: 4px solid transparent; width: 6px; height: 6px; box-sizing: border-box; } .wmsx-keyboard-up::after { border-bottom: 5px solid white; border-top-width: 0; } .wmsx-keyboard-up.wmsx-keyboard-key-unmapped::after { border-bottom-color: black; } .wmsx-keyboard-down::after { border-top: 5px solid white; border-bottom-width: 0; } .wmsx-keyboard-down.wmsx-keyboard-key-unmapped::after { border-top-color: black; } .wmsx-keyboard-left::after { border-right: 5px solid white; border-left-width: 0; } .wmsx-keyboard-left.wmsx-keyboard-key-unmapped::after { border-right-color: black; } .wmsx-keyboard-right::after { border-left: 5px solid white; border-right-width: 0; } .wmsx-keyboard-right.wmsx-keyboard-key-unmapped::after { border-left-color: black; } .wmsx-keyboard-narrow .wmsx-keyboard-num { display: none; } .wmsx-keyboard-narrow .wmsx-keyboard-arrows { left: 336px; } .wmsx-keyboard-narrow .wmsx-keyboard-space { width: 155px; } .wmsx-keyboard-narrow .wmsx-keyboard-code { left: 259px; width: 39px; } .wmsx-keyboard-narrow .wmsx-keyboard-dead { left: 299px; top: 25px; } .wmsx-keyboard-narrow .wmsx-keyboard-shift2 { display: none; } .wmsx-keyboard-narrow .wmsx-keyboard-left, .wmsx-keyboard-narrow .wmsx-keyboard-right  { top: 9px; width: 23px; height: 27px; padding: 7px 0 0 5px; border-bottom-width: 3px; } .wmsx-keyboard-narrow .wmsx-keyboard-up, .wmsx-keyboard-narrow .wmsx-keyboard-down  { left: 24px; width: 26px; padding-left: 7px; border-bottom-width: 3px; } .wmsx-keyboard-narrow .wmsx-keyboard-right  { left: 51px; padding-left: 8px; } #wmsx-virtual-keyboard { display: none; position: absolute; left: 50%; bottom: '+(this.BAR_HEIGHT+2)+'px; overflow: hidden; margin: 0 auto; padding: 5px 0 0 4px; width: 518px; height: 161px; background: hsl(0, 0%, 16%); box-sizing: border-box; transform: translateX(-50%); transform-origin: center bottom; transition: height 0.3s ease-in-out; text-align: left; z-index: 2; } html.wmsx-full-screen.wmsx-virtual-keyboard-active #wmsx-virtual-keyboard { display: block; } .wmsx-quick-options-list { margin-top: 12px; padding: 0; list-style: none; color: hsl(0, 0%, 88%); } .wmsx-quick-options-list li { margin-top: 9px; line-height: 1px; text-align: left; } .wmsx-quick-options-list li div { display: inline-block; overflow: hidden; height: 26px; font-size: 14px; line-height: 26px; text-overflow: ellipsis; white-space: nowrap; box-sizing: border-box; } .wmsx-quick-options-list .wmsx-control { position: relative; float: right; width: 134px; font-size: 15px; line-height: 25px; color: hsl(0, 0%, 70%); background: black; text-align: center; box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); } .wmsx-quick-options-list .wmsx-control > button { position: absolute; top: 0; bottom: 0; width: 26px; height: 100%; background: rgb(70, 70, 70); border: none; outline: none; cursor: pointer; -webkit-appearance: none; } .wmsx-quick-options-list .wmsx-control > button::after { content: ""; position: absolute; top: 7px; border: 6px solid transparent; } .wmsx-quick-options-list .wmsx-control .wmsx-control-dec { left: 0; border-right: 1px solid black; } .wmsx-quick-options-list .wmsx-control .wmsx-control-dec::after { left: 2px; border-right-color: #c0c0c0; } .wmsx-quick-options-list .wmsx-control .wmsx-control-inc { right: 0; border-left: 1px solid black; } .wmsx-quick-options-list .wmsx-control .wmsx-control-inc::after { right: 2px; border-left-color: #c0c0c0; } .wmsx-quick-options-list .wmsx-control.wmsx-selected { color: white; background: hsl(358, 67%, 46%); box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); } .wmsx-quick-options-list .wmsx-control.wmsx-selected.wmsx-inactive { line-height: 21px; border: 2px dashed hsl(358, 67%, 46%); background: black; } #wmsx-quick-options { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 270px; height: 351px; margin: auto; padding: 14px 15px 0; color: white; font-size: 18px; line-height: 22px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 3; } #wmsx-quick-options.wmsx-show { display: block; } #wmsx-quick-options::before { content: "Quick Options"; display: block; } #wmsx-netplay { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 390px; height: 220px; margin: auto; padding-top: 11px; color: white; font-size: 18px; line-height: 22px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); transform-origin: left center; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 50; } #wmsx-netplay.wmsx-show { display: block; } #wmsx-netplay::before { content: "Net Play!"; display: block; } #wmsx-netplay-status-box { position: relative; margin-top: 17px; } #wmsx-netplay-status { display: inline-block; position: relative; width: 340px; font-size: 15px; line-height: 27px; background: black; vertical-align: top; text-shadow: none; -webkit-user-select: text; -moz-user-select: text; -ms-user-select: text; user-select: text; box-sizing: border-box; cursor: auto; } #wmsx-netplay-status-box.wmsx-active #wmsx-netplay-status { padding: 0 16px 0 12px; } #wmsx-netplay-status-box.wmsx-active #wmsx-netplay-status::after { content: ""; position: absolute; width: 6px; height: 18px; top: 4px; left: 7px; background: rgb(254, 32, 30); } #wmsx-netplay-link { display: none; position: absolute; right: 25px; top: 0; width: 26px; height: 27px; color: white; font-size: 15px; font-weight: 600; line-height: 27px; text-decoration: none; background: black; text-align: center; } #wmsx-netplay-link:hover { background: hsl(358, 67%, 46%); cursor: pointer; } #wmsx-netplay-status-box.wmsx-active #wmsx-netplay-link { display: block; } .wmsx-netplay-button { display: inline-block; width: 86px; padding: 0; margin: 0; font-size: 15px; line-height: 26px; color: white; background: hsl(358, 67%, 46%); text-shadow: 1px 1px 1px black; border: none; box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); cursor: pointer; } #wmsx-netplay-session-box { margin-top: 18px; } #wmsx-netplay-session-label, #wmsx-netplay-nick-label { font-size: 15px; margin-bottom: 4px; } #wmsx-netplay-session-label::before { content: "Session Name"; } #wmsx-netplay-session-box input { width: 150px; height: 26px; padding: 0 10px; margin: 0 8px; font-size: 15px; line-height: 26px; background: rgb(240, 240, 240); border: none; border-radius: 0; box-sizing: border-box; outline: none; -webkit-user-select: text; -moz-user-select: text; -ms-user-select: text; user-select: text; cursor: auto; } #wmsx-netplay-nick-label { margin-top: 10px; } #wmsx-netplay-nick-label::before { content: "User Nickname"; } .wmsx-netplay-button:disabled { color: rgb(130, 130, 130); background: rgb(70, 70, 70); cursor: default; } #wmsx-netplay input:disabled { color: black; background: rgb(180, 180, 180); cursor: default; } #wmsx-netplay-session-box.wmsx-disabled div { color: rgb(130, 130, 130); } input#wmsx-netplay-link-text { position: absolute; top: 8px; left: 50px; width: 1px; height: 1px; padding: 0; margin: 0; border: none; color: transparent; background: transparent; opacity: 0; z-index: -10; -webkit-user-select: text; -moz-user-select: text; -ms-user-select: text; user-select: text; } #wmsx-touch-config { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 294px; height: 304px; margin: auto; padding: 0 16px; color: white; font-size: 18px; line-height: 22px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: border-box; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 3; } #wmsx-screen-fs.wmsx-touch-config-active #wmsx-touch-config { display: block; } #wmsx-touch-config::after { content: "Tap Control to Setup"; position: absolute; display: block; top: 14px; left: 0; width: 100%; } #wmsx-touch-config::before { content: ""; display: block; margin-top: 46px; height: 68px; background: black; } #wmsx-touch-config-minus, #wmsx-touch-config-plus { position: absolute; top: 46px; width: 72px; height: 68px; cursor: pointer; } #wmsx-touch-config-minus { left: 19px; } #wmsx-touch-config-plus { right: 19px; } #wmsx-touch-config-minus::after, #wmsx-touch-config-plus::after { content: ""; position: absolute; top: 20px; border: 14px solid transparent; } #wmsx-touch-config-minus::after { left: 9px; border-right: 18px solid #c0c0c0; } #wmsx-touch-config-minus.wmsx-disabled::after { border-right-color: #404040; } #wmsx-touch-config-plus::after { right: 9px; border-left: 18px solid #c0c0c0; } #wmsx-touch-config-plus.wmsx-disabled::after { border-left-color: #404040; } #wmsx-touch-config-dir { display: none; position: absolute; top: 15px; left: 79px; transform: scale(.70); } #wmsx-touch-config-dir.wmsx-show { display: block; } #wmsx-touch-config-dir::before { display: none; } #wmsx-touch-config-button { display: none; position: absolute; top: 46px; right: 109px; text-shadow: none; } #wmsx-touch-config-button.wmsx-show { display: block; } #wmsx-touch-config .wmsx-quick-options-list { margin-top: 11px; } #wmsx-touch-config .wmsx-control { width: 110px; } #wmsx-touch-left, #wmsx-touch-right { display: none; position: absolute; z-index: 1; } #wmsx-touch-speed { display: none; } html.wmsx-full-screen.wmsx-touch-active #wmsx-touch-left, html.wmsx-full-screen.wmsx-touch-active #wmsx-touch-right, html.wmsx-full-screen.wmsx-touch-active #wmsx-touch-speed { display: block; } .wmsx-touch-dir { position: relative; width: 130px; height: 130px; color: hsl(0, 0%, 75%); border-radius: 100%; z-index: 2 } .wmsx-touch-dir::before { content: ""; position: absolute; top: 14px; left: 14px; right: 14px; bottom: 14px; border: 1px solid hsl(0, 0%, 26%); border-radius: 100%; } .wmsx-touch-dir-joy .wmsx-touch-dir-up, .wmsx-touch-dir-joy .wmsx-touch-dir-left { position: absolute; background: hsl(0, 0%, 31%); border-radius: 2px 2px 0 0; box-shadow: inset 1px 2px 0px hsl(0, 0%, 43%), inset -1px -1px hsl(0, 0%, 19%), 0 3px 0 1px hsl(0, 0%, 21%); } .wmsx-touch-dir-joy .wmsx-touch-dir-up { width: 26px; height: 78px; top: 24px; left: 52px; } .wmsx-touch-dir-joy .wmsx-touch-dir-left { width: 78px; height: 25px; top: 51px; left: 26px; } .wmsx-touch-dir-joy .wmsx-touch-dir-left::before { content: ""; position: absolute; top: 2px; left: 23px; width: 33px; height: 22px; background: inherit; z-index: 1; } .wmsx-touch-dir-joy .wmsx-touch-dir-left::after { content: ""; position: absolute; top: 4px; left: 30px; height: 17px; width: 17px; border-radius: 100%; box-shadow:  inset 0 0 2px hsl(0, 0%, 22%), inset 1px 2px 3px 1px hsl(0, 0%, 26%), inset -1px -2px 1px hsl(0, 0%, 64%); z-index: 2; } .wmsx-touch-dir-key .wmsx-touch-dir-up, .wmsx-touch-dir-key .wmsx-touch-dir-left, .wmsx-touch-dir-key .wmsx-touch-dir-down, .wmsx-touch-dir-key .wmsx-touch-dir-right { position: absolute; background: rgb(70, 85, 180); border: 0 solid hsl(232, 44%, 37%); border-width: 1px 2px 4px; border-top-color: hsl(232, 44%, 40%); border-bottom-color: hsl(232, 44%, 24%); border-radius: 2px 2px 0 0; box-sizing: border-box; } .wmsx-touch-dir-key .wmsx-touch-dir-up, .wmsx-touch-dir-key .wmsx-touch-dir-down { left: 50px; width: 30px; } .wmsx-touch-dir-key .wmsx-touch-dir-up { top: 26px; height: 25px; border-bottom-width: 2px; } .wmsx-touch-dir-key .wmsx-touch-dir-down { bottom: 26px; height: 27px; } .wmsx-touch-dir-key .wmsx-touch-dir-left, .wmsx-touch-dir-key .wmsx-touch-dir-right { top: 47px; width: 25px; height: 36px; } .wmsx-touch-dir-key .wmsx-touch-dir-left { left: 24px; } .wmsx-touch-dir-key .wmsx-touch-dir-right { right: 24px; } .wmsx-touch-dir-key .wmsx-touch-dir-up::after { content: ""; position: absolute; top: 26px; left: -1px; width: 28px; height: 22px; background: hsl(0, 0%, 20%); } .wmsx-touch-dir .wmsx-arrow-up, .wmsx-touch-dir .wmsx-arrow-down, .wmsx-touch-dir .wmsx-arrow-left, .wmsx-touch-dir .wmsx-arrow-right { position: absolute; border-width: 5px; z-index: 2; } .wmsx-touch-dir .wmsx-arrow-up { top: 26px; left: 60px; border-bottom-width: 11px; } .wmsx-touch-dir .wmsx-arrow-down { bottom: 29px; left: 60px; border-top-width: 11px; } .wmsx-touch-dir .wmsx-arrow-left { top: 58px; left: 26px; border-right-width: 11px; } .wmsx-touch-dir .wmsx-arrow-right { top: 58px; right: 26px; border-left-width: 11px; } .wmsx-touch-button { position: relative; display: block; width: 72px; height: 72px; font-size: 20px; line-height: 67px; color: hsl(0, 0%, 79%); border-radius: 100%; cursor: default; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; z-index: 0; } .wmsx-touch-button::before { content: ""; position: absolute; box-sizing: border-box; z-index: -1; } .wmsx-touch-button-joy::before, .wmsx-touch-button-none::before { width: 50px; height: 48px; top: 9px; left: 11px; border-radius: 100%; } #wmsx-screen-fs.wmsx-touch-config-active .wmsx-touch-button-none::before { border: 2px solid hsl(0, 0%, 30%); } .wmsx-touch-button-joy.wmsx-touch-button-joy-A::before { border: none; background: hsl(120, 76%, 31%); box-shadow: inset 0 2px hsl(120, 76%, 41%), 0 4px 0 1px hsl(120, 76%, 20%); } .wmsx-touch-button-joy.wmsx-touch-button-joy-B::before { border: none; background: hsl(0, 60%, 35%); box-shadow: inset 0 2px hsl(0, 60%, 48%), 0 4px 0 1px hsl(0, 60%, 23%); } .wmsx-touch-button-joy.wmsx-touch-button-joy-AB::before { border: none; background: hsl(240, 50%, 48%); box-shadow: inset 0 2px hsl(240, 50%, 60%), 0 4px 0 1px hsl(240, 50%, 31%); } .wmsx-touch-button-key { font-size: 16px; line-height: 69px; } .wmsx-touch-button-key::before { width: 48px; height: 46px; top: 13px; left: 12px; background: hsl(0, 0%, 44%); border: 4px solid hsl(0, 0%, 31%); border-top: 2px solid hsl(0, 0%, 54%); border-bottom: 6px solid hsl(0, 0%, 22%); border-radius: 3px 3px 1px 1px; } #wmsx-touch-T_A { z-index: 7 } #wmsx-touch-T_B { z-index: 6 } #wmsx-touch-T_C { z-index: 5 } #wmsx-touch-T_D { z-index: 4 } #wmsx-touch-T_E { z-index: 3 } #wmsx-touch-T_F { z-index: 2 } #wmsx-touch-T_G { z-index: 1 } #wmsx-touch-T_X { z-index: 1 } #wmsx-touch-T_Y { z-index: 1 } #wmsx-touch-pause, #wmsx-touch-fast { float: left; width: 46px; height: 48px; border-color: hsl(0, 0%, 70%); } #wmsx-touch-pause::after, #wmsx-touch-fast::before, #wmsx-touch-fast::after { content: ""; display: inline-block; border: 0 solid transparent; box-sizing: border-box; } #wmsx-touch-pause::after { margin-top: 16px; width: 14px; height: 16px; border-width: 0; border-left-width: 4px; border-left-color: inherit; border-right-width: 4px; border-right-color: inherit; } #wmsx-touch-fast::before, #wmsx-touch-fast::after { margin-top: 16px; width: 12px; height: 16px; border-width: 8px; border-left-width: 12px; border-left-color: inherit; border-right-width: 0; } #wmsx-touch-speed.wmsx-paused #wmsx-touch-pause::after, #wmsx-touch-speed.wmsx-poweroff #wmsx-touch-pause::after { margin-top: 14px; width: 17px; height: 20px; border-width: 10px; border-left-width: 17px; border-right-width: 0; } #wmsx-touch-speed.wmsx-paused  #wmsx-touch-fast::after { width: 7px; border-width: 0; border-left-width: 3px; } #wmsx-touch-speed.wmsx-poweroff #wmsx-touch-fast { display: none; } .wmsx-hd-first { float: left; } #wmsx-drop-area { position: absolute; display: none; bottom: 56px; width: 574px; height: 238px; margin: auto; padding: 0; font-size: 0; line-height: 0; color: hsl(0, 0%, 82%); background: black; text-align: left; transform-origin: left bottom; z-index: 99; } #wmsx-drop-area.wmsx-visible { display: block; } #wmsx-drop-area > div { position: relative; display: inline-block; width: 178px; height: 90px; margin: 10px 0 0 10px; padding: 0; font-size: 19px; line-height: 24px; text-shadow: 2px 2px black; text-align: center; background: hsl(0, 0%, 16%); vertical-align: bottom; box-sizing: border-box; } #wmsx-drop-area > div.wmsx-disabled { color: #616161; } #wmsx-drop-area > div:not(.wmsx-disabled).wmsx-selected { background: hsl(358, 67%, 38%); } #wmsx-drop-area-message { position: absolute; left: 0; right: 0; bottom: 2px; height: 34px; font-size: 16px; line-height: 34px; text-align: center; } #wmsx-drop-area i { display: inline-block; margin: 11px auto 7px; width: 41px; height: 36px; background: url("'+wmsx.Images.urls.sprites+'"); background-size: 568px 206px; vertical-align: bottom; } #wmsx-drop-drivea i { background-position: -334px -107px; } #wmsx-drop-drivea.wmsx-disabled i { background-position: -334px -156px; } #wmsx-drop-driveb i { background-position: -392px -107px; } #wmsx-drop-driveb.wmsx-disabled i { background-position: -392px -156px; } #wmsx-drop-driveh i { background-position: -508px -107px; } #wmsx-drop-driveh.wmsx-disabled i { background-position: -508px -156px; } #wmsx-drop-cart1 i  { background-position: -159px -107px; } #wmsx-drop-cart2 i  { background-position: -217px -107px; } #wmsx-drop-tape i   { background-position: -275px -107px; } .wmsx-drop-add, .wmsx-drop-files { position: absolute; display: none; left: 0; top: 0; width: 50px; height: 34px; padding-top: 10px; font-size: 11px; line-height: 9px; text-shadow: 1px 1px 1px black; border: 3px solid transparent; box-sizing: border-box; white-space: nowrap; overflow: visible; } .wmsx-drop-files { left: unset; right: 0; } .wmsx-drop-add::after { content: "+ DISKS"; } .wmsx-drop-files::after { content: "+ FILES "; } #wmsx-drop-area > div:not(.wmsx-disabled).wmsx-selected .wmsx-drop-add, #wmsx-drop-area > div:not(.wmsx-disabled).wmsx-selected .wmsx-drop-files { display: block; } .wmsx-drop-add.wmsx-selected, .wmsx-drop-files.wmsx-selected { border-color: hsl(0, 0%, 82%); box-shadow: 0 0 0 1px rgba(0, 0, 0, .8); } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-touch-left .wmsx-touch-dir { transform: scale(1.2); transform-origin: left center; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-touch-left .wmsx-touch-dir { transform-origin: right center; } #wmsx-touch-left .wmsx-touch-button { margin-left: 11px; } html.wmsx-touch-mirror #wmsx-touch-left .wmsx-touch-button { margin-left: 47px; } #wmsx-touch-T_X { margin-bottom: var(--touch-left-button-vert-margin); } #wmsx-touch-T_Y { margin-top: var(--touch-left-button-vert-margin); } @media only screen and (orientation: landscape) {    /* Landscape */ #wmsx-touch-left { left: calc(-6px - '+this.TOUCH_CONTROLS_LEFT_WIDTH+"px); bottom: 50%; transform: translateY(50%); --touch-left-button-vert-margin: 10px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-touch-left { left: calc(-6px - "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px); --touch-left-button-vert-margin: 20px; } html.wmsx-touch-mirror #wmsx-touch-left { right: calc(-6px - "+this.TOUCH_CONTROLS_LEFT_WIDTH+"px); left: initial  !important; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-touch-left { right: calc(-6px - "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px); } #wmsx-touch-right { right: calc(5px - "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px); bottom: 50%; transform: translateY(50%); } html.wmsx-touch-mirror #wmsx-touch-right { left: calc(5px - "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px); right: initial  !important; } #wmsx-touch-speed { position: absolute; left: -106px; top: 8px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-touch-speed { left: -130px; } html.wmsx-touch-mirror #wmsx-touch-speed { right: -106px; left: initial  !important; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-touch-speed { right: -130px; } /* Adjust centered elements leaving space to the touch controls on both sides */ html.wmsx-full-screen.wmsx-touch-active #wmsx-screen-fs-center { left: "+this.TOUCH_CONTROLS_LEFT_WIDTH+"px; right: "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-screen-fs-center { left: "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror #wmsx-screen-fs-center { right: "+this.TOUCH_CONTROLS_LEFT_WIDTH+"px; left: "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-screen-fs-center { right: "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px; } } @media only screen and (orientation: landscape) and (max-height: 511px) {    /* Medium/Large Landscape */ #wmsx-touch-left { --touch-left-button-vert-margin: 10px  !important; } #wmsx-touch-T_F, #wmsx-touch-T_G { display: none; } #wmsx-touch-speed { top: 2px; } } @media only screen and (orientation: landscape) and (max-height: 410px) {    /* Medium Landscape */ #wmsx-touch-left { --touch-left-button-vert-margin: -2px  !important; } } @media only screen and (orientation: landscape) and (max-height: 359px) {    /* Short Landscape */ #wmsx-touch-left { --touch-left-button-vert-margin: 6px  !important; } #wmsx-touch-T_E { display: none; } #wmsx-touch-T_X { visibility: hidden; } #wmsx-touch-speed { top: 8px; } } @media only screen and (orientation: portrait) {    /* Portrait */ #wmsx-touch-left { left: 2px; bottom: 182px; } html.wmsx-touch-mirror #wmsx-touch-left { right: 2px; left: initial  !important; } #wmsx-touch-right { right: 5px; bottom: 36px; width: 112px; height: 224px; } html.wmsx-touch-mirror #wmsx-touch-right { left: 77px; right: initial  !important; } #wmsx-touch-speed { position: absolute; left: 19px; bottom: "+(this.BAR_HEIGHT+10)+"px; } html.wmsx-touch-mirror #wmsx-touch-speed { right: 19px; left: initial  !important; } .wmsx-touch-button { position: absolute; } #wmsx-touch-T_A { bottom: 75%; right: 50%; } #wmsx-touch-T_B { bottom: 100%; right: 0%; } #wmsx-touch-T_C { bottom: 50%; right: 100%; } #wmsx-touch-T_D { bottom: 25%; right: 50%; } #wmsx-touch-T_E { bottom: 50%; right: 0%; } #wmsx-touch-T_F { bottom: 0%; right: 100%; } #wmsx-touch-T_G { bottom: 0%; right: 0%; } #wmsx-touch-T_X { display: none; } #wmsx-touch-T_Y { bottom: -88px; } html.wmsx-touch-mirror #wmsx-touch-T_B { right: 100%; } html.wmsx-touch-mirror #wmsx-touch-T_C { right: 0%; } html.wmsx-touch-mirror #wmsx-touch-T_E { right: 100%; } html.wmsx-touch-mirror #wmsx-touch-T_F { right: 0%; } html.wmsx-touch-mirror #wmsx-touch-T_G { right: 100%; } html.wmsx-full-screen.wmsx-virtual-keyboard-active #wmsx-touch-left, html.wmsx-full-screen.wmsx-virtual-keyboard-active #wmsx-touch-right { display: none; } } @media only screen and (orientation: portrait) and (max-device-height: 638px) {    /* Medium Portrait. Like iPhone 5 */ #wmsx-touch-right { bottom: -18px; } #wmsx-touch-T_F, #wmsx-touch-T_G { display: none; } } @media only screen and (orientation: portrait) and (max-device-height: 518px) {    /* Short Portrait. Like iPhone 4 */ #wmsx-touch-left { bottom: 98px; } #wmsx-touch-right { bottom: -74px; } #wmsx-touch-T_E, #wmsx-touch-T_Y { display: none; } #wmsx-touch-T_D { bottom: 50%; right: 0%; } html.wmsx-touch-mirror #wmsx-touch-T_D { right: 100%; } }"
},wmsx.VirtualKeyboard={create:function(a,b,c,d,e,f){"use strict";var g=document.createElement("div");g.style.position="absolute",a.appendChild(g);var h=[];for(var i in this.sections){var j=document.createElement("div");j.classList.add("wmsx-keyboard-"+i),g.appendChild(j);for(var k=this.sections[i],l=0,m=0;m<k.length;++m){var n=document.createElement("div");n.style.top=l+"px",l+=this.sectionRowHeight[i],j.appendChild(n);for(var o=k[m],p=1,q=0;q<o.length;++q){var r=o[q],s="wmsx-keyboard-"+r.toLowerCase(),t=document.createElement("div");if(!this.byCSSKeys.has(r)){var u=this.keyWidth[r]||this.sectionKeyWidth[i];t.style.width=u+"px",t.style.left=p+"px",p+=this.keySpace[r]||u+1}t.classList.add("wmsx-keyboard-key"),t.classList.add(s),this.dark.indexOf(s)>=0&&t.classList.add("wmsx-keyboard-key-dark"),t.wmsxKeyID=r,t.wmsxKey=this.idToMSMKey[r]||r,n.appendChild(t),h.push(t),b&&b(t)}}}return this.updateKeysLabels(h,c,d,e,f),h},updateKeysLabels:function(a,b,c,d,e){this.finalLabels.COD=d||"CODE";var f,g,h;e?(f="cns_"+c,g="c_"+c,h="c_en"):(f=(b?"cs_":"c_")+c,g=b?"cs_en":"c_en",h="c_en");for(var i=a.length-1;i>=0;--i){var j=a[i];if(!this.blankKeys.has(j.wmsxKeyID)){var k=wmsx.KeyboardKeys[j.wmsxKey][f]||wmsx.KeyboardKeys[j.wmsxKey][g]||wmsx.KeyboardKeys[j.wmsxKey][h];k=this.finalLabels[k]||k,j.wmsxLabel!==k&&(j.wmsxLabel=k,j.innerHTML=k)}}},sections:{alpha:[["F1","F2","F3","F4","F5","STOP","SELECT","HOME","INSERT","DELETE"],["ESCAPE","D1","D2","D3","D4","D5","D6","D7","D8","D9","D0","MINUS","EQUAL","BACKSLASH","BACKSPACE"],["TAB","Q","W","E","R","T","Y","U","I","O","P","OPEN_BRACKET","CLOSE_BRACKET","ENTER_X1","ENTER_X2"],["CONTROL","A","S","D","F","G","H","J","K","L","SEMICOLON","QUOTE","BACKQUOTE","ENTER"],["SHIFT","Z","X","C","V","B","N","M","COMMA","PERIOD","SLASH","DEAD","SHIFT2"],["CAPSLOCK","GRAPH","SPACE","CODE"]],num:[["NUM_7","NUM_8","NUM_9","NUM_DIVIDE"],["NUM_4","NUM_5","NUM_6","NUM_MULTIPLY"],["NUM_1","NUM_2","NUM_3","NUM_MINUS"],["NUM_0","NUM_PERIOD","NUM_COMMA","NUM_PLUS"]],arrows:[["LEFT","UP","RIGHT","DOWN"]]},sectionRowHeight:{alpha:25,num:23,arrows:50},sectionKeyWidth:{alpha:26,num:22},keyWidth:{F1:39,F2:39,F3:39,F4:39,F5:39,STOP:39,SELECT:39,HOME:39,INSERT:39,DELETE:39,ESCAPE:29,BACKSPACE:28,TAB:41,CONTROL:48,SHIFT:61,SHIFT2:61,ENTER:36,ENTER_X1:13,ENTER_X2:30,SPACE:189,CAPSLOCK:38,DEAD:38,GRAPH:46,CODE:46},keySpace:{STOP:50,ENTER_X1:13,CAPSLOCK:55},dark:["wmsx-keyboard-escape","wmsx-keyboard-tab","wmsx-keyboard-control","wmsx-keyboard-shift","wmsx-keyboard-capslock","wmsx-keyboard-graph","wmsx-keyboard-backspace","wmsx-keyboard-enter","wmsx-keyboard-enter_x1","wmsx-keyboard-enter_x2","wmsx-keyboard-shift2","wmsx-keyboard-code","wmsx-keyboard-num_divide","wmsx-keyboard-num_multiply","wmsx-keyboard-num_minus","wmsx-keyboard-num_plus"],idToMSMKey:{ENTER_X1:"ENTER",ENTER_X2:"ENTER",SHIFT2:"SHIFT"},finalLabels:{STP:"STOP",HOM:"HOME",CTR:"CTRL",SHF:"SHIFT",CAP:"CAPS",SPC:"SPACE",GRA:"GRAPH",COD:"CODE"},blankKeys:new Set(["ENTER_X1","ENTER_X2","UP","DOWN","LEFT","RIGHT"]),byCSSKeys:new Set(["SHIFT2","SPACE","CODE","DEAD","UP","DOWN","LEFT","RIGHT"])},wmsx.Monitor=function(a){"use strict";function b(a){var b=a<.5?.5:a>2.5?2.5:a;return Math.round(b/wmsx.Monitor.ASPECT_STEP)*wmsx.Monitor.ASPECT_STEP}function c(a){var b=a<.5?.5:a;return Math.round(b/wmsx.Monitor.SCALE_STEP)*wmsx.Monitor.SCALE_STEP}this.connect=function(a){d=a,d.connectMonitor(this)},this.newFrame=function(b,c,d){a.refresh(b,c,d)},this.signalOff=function(){a.videoSignalOff()},this.showOSD=function(b,c,d){a.showOSD(b,c,d)},this.setDisplayMetrics=function(b,c){a.displayMetrics(b,c)},this.setPixelMetrics=function(b,c){a.displayPixelMetrics(b,c)},this.setDefaults=function(){a.crtPhosphorSetDefault(),a.crtScanlinesSetDefault(),a.crtFilterSetDefault(),a.aspectAndScaleSetDefault(),a.requestReadjust(!0)},this.setDebugMode=function(b){a.setDebugMode(b)},this.crtFilterToggle=function(b){a.crtFilterToggle(b)},this.crtScanlinesToggle=function(b){a.crtScanlinesToggle(b)},this.crtPhosphorToggle=function(b){a.crtPhosphorToggle(b)},this.fullscreenToggle=function(b){a.displayToggleFullscreen(b)},this.displayAspectDecrease=function(){this.displayScale(b(e-wmsx.Monitor.ASPECT_STEP),f),this.showOSD("Display Aspect: "+e.toFixed(2)+"x",!0)},this.displayAspectIncrease=function(){this.displayScale(b(e+wmsx.Monitor.ASPECT_STEP),f),this.showOSD("Display Aspect: "+e.toFixed(2)+"x",!0)},this.displayScaleDecrease=function(){this.displayScale(e,c(f-wmsx.Monitor.SCALE_STEP)),this.showOSD("Display Size: "+f.toFixed(2)+"x",!0)},this.displayScaleIncrease=function(){this.displayScale(e,c(f+wmsx.Monitor.SCALE_STEP)),this.showOSD("Display Size: "+f.toFixed(2)+"x",!0)},this.getScreenText=function(){return d.getScreenText()},this.displayScale=function(b,c){e=b,f=c,a.displayScale(e,f)};var d,e,f},wmsx.Monitor.SCALE_STEP=.05,wmsx.Monitor.ASPECT_STEP=.01,wmsx.CanvasDisplay=function(room,mainElement){"use strict";function init(){wmsx.Util.insertCSS(wmsx.ScreenGUI.css()),delete wmsx.ScreenGUI.css,setupMain(),setupBar(),setupFileLoaderDropTargets(),setupFullscreen(),monitor=new wmsx.Monitor(self)}function displayDefaultScale(){if(WMSX.SCREEN_DEFAULT_SCALE>0)return WMSX.SCREEN_DEFAULT_SCALE;var a=Number.parseFloat(window.getComputedStyle(mainElement.parentElement).width);return crtScanlines?a>=660?1:a>=420?.75:.5:a>=660?1.1:a>=540?.9:a>=420?.7:a>=320?.55:.5}function hideOSD(){osd.style.transition="all 0.15s linear",osd.style.top="-29px",osd.style.opacity=0,osdShowing=!1}function setVirtualKeyboard(a){if(virtualKeyboardMode!==a){if(a){if(!isTouchDevice)return self.showOSD("Virtual Keyboard unavailable. Not a touch device!",!0,!0);virtualKeyboardElement||setupVirtualKeyboard(),virtualKeyboardElement.classList.toggle("wmsx-keyboard-narrow",2==a)}showCursorAndBar(!0),document.documentElement.classList.toggle("wmsx-virtual-keyboard-active",!!a),virtualKeyboardMode=a,self.requestReadjust(!0)}}function releaseControllersOnLostFocus(){controllersSocket.releaseControllers()}function hideCursorAndBar(){hideCursor(),hideBar(),cursorHideFrameCountdown=-1}function showCursorAndBar(a){showCursor(),!a&&mousePointerLocked||showBar(),cursorHideFrameCountdown=CURSOR_HIDE_FRAMES}function showCursor(){cursorShowing||(fsElement.style.cursor=cursorType,cursorShowing=!0)}function hideCursor(){cursorShowing&&(fsElement.style.cursor="none",cursorShowing=!1)}function fullscreenByAPIChanged(){var a=isFullscreen,b=isFullScreenByAPI();b||fullScreenAPIExitUserRequested||!isBrowserStandalone?setFullscreenState(b):self.requestReadjust(),a&&!b&&!fullScreenAPIExitUserRequested&&isMobileDevice&&(isBrowserStandalone?setEnterFullscreenByAPIOnFirstTouch():(machine.systemPause(!0),showLogoMessage("<br>Emulation suspended","RESUME",!0,function(){self.setFullscreen(!0),machine.systemPause(!1)}))),fullScreenAPIExitUserRequested=!1}function isFullScreenByAPI(){return!!document[fullScreenAPIQueryProp]}function enterFullScreenByAPI(){if(fullscreenAPIEnterMethod)try{fullscreenAPIEnterMethod.call(fsElement)}catch(a){}}function exitFullScreenByAPI(){if(fullScreenAPIExitMethod)try{fullScreenAPIExitUserRequested=!0,fullScreenAPIExitMethod.call(document)}catch(a){}}function updateScale(){var a=Math.round(targetWidth*scaleY*aspectX),b=Math.round(targetHeight*scaleY);canvas.style.width=a+"px",canvas.style.height=b+"px",updateBarWidth(a),signalIsOn||updateLogoScale(),settingsDialog&&settingsDialog.isVisible()&&settingsDialog.position()}function updateBarWidth(a){var b=buttonsBarDesiredWidth>0?buttonsBarDesiredWidth:a;buttonsBar.style.width=-1===buttonsBarDesiredWidth?"100%":b+"px",buttonsBar.classList.toggle("wmsx-narrow",b<NARROW_WIDTH)}function updateKeyboardWidth(a){var b=Math.min(1024,a),c=1===virtualKeyboardMode?VIRTUAL_KEYBOARD_WIDE_WIDTH:VIRTUAL_KEYBOARD_NARROW_WIDTH,d=b/c;return virtualKeyboardElement.style.width=c+"px",
virtualKeyboardElement.style.transform="translateX(-50%) scale("+d.toFixed(8)+")",{w:b,h:Math.ceil(VIRTUAL_KEYBOARD_HEIGHT*d)}}function updateCanvasContentSize(){canvas.width=targetWidth,canvas.height=crtScanlines?2*targetHeight:targetHeight,canvasContext=null}function setCRTFilter(a){crtFilter=a,crtFilterEffective=-2===crtFilter?null:-1===crtFilter?crtFilterAutoValue():a,canvasContext=null}function crtFilterAutoValue(){return isMobileDevice&&!isIOSDevice&&"FIREFOX"===browserName?2:1}function setCRTScanlines(a){crtScanlines=a,crtScanlines&&updateScanlines(),canvasContext=null}function setCRTPhosphor(a){crtPhosphor=a,crtPhosphorEffective=-1===crtPhosphor?0:crtPhosphor,canvasContext=null}function updateLogo(){signalIsOn||(updateLogoScale(),closePowerOnModals(),showCursorAndBar(!0),canvasContext&&canvasContext.clearRect(0,0,canvas.width,canvas.height)),logo.classList.toggle("wmsx-show",!signalIsOn)}function updateLoading(){var a=isLoading?"block":"none";logoLoadingIcon.style.display=a,canvasLoadingIcon.style.display=a}function createCanvasContext(){canvasContext=canvas.getContext("2d",{alpha:!1,antialias:!1}),updateImageComposition(),updateImageSmoothing()}function updateImageComposition(){debugMode||!crtPhosphorEffective&&!crtScanlines?(canvasContext.globalCompositeOperation="copy",canvasContext.globalAlpha=1):(canvasContext.globalCompositeOperation="source-over",canvasContext.globalAlpha=crtPhosphorEffective?.8:1)}function updateImageSmoothing(){if(null!==crtFilterEffective){canvas.style.imageRendering=1===crtFilterEffective||3===crtFilterEffective?"initial":canvasImageRenderingValue;var a=crtFilterEffective>=2;void 0!==canvasContext.imageSmoothingEnabled?canvasContext.imageSmoothingEnabled=a:(canvasContext.webkitImageSmoothingEnabled=a,canvasContext.mozImageSmoothingEnabled=a,canvasContext.msImageSmoothingEnabled=a)}}function updateLeds(){capsLed.textContent=1&ledsUpdatePending?"CAPS":"",kanaLed.textContent=2&ledsUpdatePending?machineTypeSocket.getCodeKeyLabel():"",ledsUpdatePending=-1}function suppressContextMenu(a){a.addEventListener("contextmenu",wmsx.Util.blockEvent)}function preventDrag(a){a.ondragstart=wmsx.Util.blockEvent}function setupMain(){switch(mainElement.innerHTML=wmsx.ScreenGUI.html(),mainElement.tabIndex=-1,delete wmsx.ScreenGUI.html,fsElement=document.getElementById("wmsx-screen-fs"),fsElementCenter=document.getElementById("wmsx-screen-fs-center"),canvasOuter=document.getElementById("wmsx-screen-canvas-outer"),canvas=document.getElementById("wmsx-screen-canvas"),canvasLoadingIcon=document.getElementById("wmsx-canvas-loading-icon"),osd=document.getElementById("wmsx-osd"),logo=document.getElementById("wmsx-logo"),logoCenter=document.getElementById("wmsx-logo-center"),logoImage=document.getElementById("wmsx-logo-image"),logoLoadingIcon=document.getElementById("wmsx-logo-loading-icon"),logoMessage=document.getElementById("wmsx-logo-message"),logoMessageText=document.getElementById("wmsx-logo-message-text"),logoMessageOK=document.getElementById("wmsx-logo-message-ok"),logoMessageOKText=document.getElementById("wmsx-logo-message-ok-text"),scrollMessage=document.getElementById("wmsx-screen-scroll-message"),unmuteMessage=document.getElementById("wmsx-unmute-message"),scanlinesImage=document.createElement("canvas"),scanlinesImage.width=1,scanlinesImage.height=wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938,suppressContextMenu(mainElement),preventDrag(logoImage),preventDrag(logoLoadingIcon),preventDrag(canvasLoadingIcon),updateCanvasContentSize(),browserName){case"CHROME":case"EDGE":case"OPERA":canvasImageRenderingValue="pixelated";break;case"FIREFOX":canvasImageRenderingValue="-moz-crisp-edges";break;case"SAFARI":canvasImageRenderingValue="-webkit-optimize-contrast";break;default:canvasImageRenderingValue="pixelated"}setupMainEvents()}function updateScanlines(){var a=scanlinesImage.getContext("2d",{alpha:!0,antialias:!1});a.clearRect(0,0,1,scanlinesImage.height),a.fillStyle="black",a.globalAlpha=crtScanlines/10;for(var b=1,c=scanlinesImage.height;b<c;b+=2)a.fillRect(0,b,1,1)}function setupMainEvents(){function a(){closeAllOverlays(),signalIsOn?hideCursorAndBar():showCursorAndBar(),self.requestReadjust()}(isMobileDevice?canvasOuter:fsElement).addEventListener("mousemove",function(){showCursorAndBar()}),"onblur"in document?fsElement.addEventListener("blur",releaseControllersOnLostFocus,!0):fsElement.addEventListener("focusout",releaseControllersOnLostFocus,!0),window.addEventListener("orientationchange",a),window.addEventListener("resize",function(){isFullscreen&&a()}),mainElement.addEventListener("drop",closeAllOverlays,!1),logoMessageOK.wmsxNeedsUIG=logoMessageOKText.wmsxNeedsUIG=!0,wmsx.Util.onTapOrMouseDownWithBlockUIG(logoMessageOK,closeLogoMessage),wmsx.Util.addEventsListener(fsElementCenter,"touchstart touchend mousedown",function(a){"touchend"!==a.type?(closeAllOverlays(),showCursorAndBar()):a.cancelable&&a.preventDefault()})}function setupVirtualKeyboard(){virtualKeyboardElement=document.createElement("div"),virtualKeyboardElement.id="wmsx-virtual-keyboard",fsElementCenter.appendChild(virtualKeyboardElement),virtualKeyboard=new wmsx.DOMVirtualKeyboard(virtualKeyboardElement,controllersHub.getKeyboard(),machineTypeSocket)}function setupBar(){buttonsBar=document.getElementById("wmsx-bar"),buttonsBarInner=document.getElementById("wmsx-bar-inner"),BAR_AUTO_HIDE&&(document.documentElement.classList.add("wmsx-bar-auto-hide"),fsElement.addEventListener("mouseleave",hideBar),hideBar());var a=[{label:"Power",clickModif:0,control:wmsx.PeripheralControls.MACHINE_POWER_TOGGLE},{label:"Reset",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.MACHINE_POWER_RESET},{label:"",divider:!0},{label:"Net Play!",control:wmsx.PeripheralControls.SCREEN_OPEN_NETPLAY},{label:"",divider:!0},{label:"Open File",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.AUTO_LOAD_FILE,needsUIG:!0},{label:"Open URL",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.AUTO_LOAD_URL,needsUIG:!0},{label:"",divider:!0},{label:"Load State",control:wmsx.PeripheralControls.MACHINE_LOAD_STATE_MENU},{label:"Save State",control:wmsx.PeripheralControls.MACHINE_SAVE_STATE_MENU}];if(powerButton=addPeripheralControlButton("wmsx-bar-power",-120,-26,!1,"System Power",null,a,"System"),barMenuSystem=a,netplayButton=addPeripheralControlButton("wmsx-bar-netplay",-1,-91,!1,"NetPlay!",wmsx.PeripheralControls.SCREEN_OPEN_NETPLAY),netplayButton.classList.add("wmsx-hidden"),mediaIconsContainer=document.createElement("div"),mediaIconsContainer.id="wmsx-bar-media-icons",mediaIconsContainer.style.display="inline-block",buttonsBarInner.appendChild(mediaIconsContainer),barMenus.push(null),a=[{label:"Load Disk Images",clickModif:0,control:wmsx.PeripheralControls.DISK_LOAD_FILES,needsUIG:!0},{label:"Add Disk Images",control:wmsx.PeripheralControls.DISK_ADD_FILES,needsUIG:!0},{label:"Add Blank Disk",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_EMPTY},{label:"Add Boot Disk",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_BOOT},{label:"Import Files to Disk",control:wmsx.PeripheralControls.DISK_LOAD_FILES_AS_DISK,needsUIG:!0},{label:"Expand ZIP to Disk",control:wmsx.PeripheralControls.DISK_LOAD_ZIP_AS_DISK,needsUIG:!0},{label:"Select Disk",control:wmsx.PeripheralControls.DISK_SELECT,disabled:!0},{label:"Save Disk Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_SAVE_FILE,disabled:!0,needsUIG:!0},{label:"Remove Disk",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_REMOVE,disabled:!0}],diskAButton=addPeripheralControlButton("wmsx-bar-diska",-165,-72,!0,"Drive A",null,a,"Drive A",mediaIconsContainer),WMSX.EXTENSIONS.DISK||diskAButton.classList.add("wmsx-hidden"),a=[{label:"Load Disk Images",clickModif:0,control:wmsx.PeripheralControls.DISK_LOAD_FILES,secSlot:!0,needsUIG:!0},{label:"Add Disk Images",
control:wmsx.PeripheralControls.DISK_ADD_FILES,secSlot:!0,needsUIG:!0},{label:"Add Blank Disk",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_EMPTY,secSlot:!0},{label:"Add Boot Disk",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_BOOT,secSlot:!0},{label:"Import Files to Disk",control:wmsx.PeripheralControls.DISK_LOAD_FILES_AS_DISK,secSlot:!0,needsUIG:!0},{label:"Expand ZIP to Disk",control:wmsx.PeripheralControls.DISK_LOAD_ZIP_AS_DISK,secSlot:!0,needsUIG:!0},{label:"Select Disk",control:wmsx.PeripheralControls.DISK_SELECT,secSlot:!0,disabled:!0},{label:"Save Disk Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_SAVE_FILE,secSlot:!0,disabled:!0,needsUIG:!0},{label:"Remove Disk",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_REMOVE,secSlot:!0,disabled:!0}],diskBButton=addPeripheralControlButton("wmsx-bar-diskb",-194,-72,!0,"Drive B",null,a,"Drive B",mediaIconsContainer),WMSX.EXTENSIONS.DISK||diskBButton.classList.add("wmsx-hidden"),a=[{label:"Load Disk Image",clickModif:0,control:wmsx.PeripheralControls.HARDDISK_LOAD_FILE,needsUIG:!0},{label:"New Blank Disk",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.HARDDISK_CHOOSE_EMPTY},{label:"New Boot Disk",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.HARDDISK_CHOOSE_BOOT},{label:"Import Files to Disk",control:wmsx.PeripheralControls.HARDDISK_LOAD_FILES_AS_DISK,needsUIG:!0},{label:"Expand ZIP to Disk",control:wmsx.PeripheralControls.HARDDISK_LOAD_ZIP_AS_DISK,needsUIG:!0},{label:"Save Disk Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.HARDDISK_SAVE_FILE,disabled:!0,needsUIG:!0},{label:"Remove Disk",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.HARDDISK_REMOVE,disabled:!0}],diskHButton=addPeripheralControlButton("wmsx-bar-diskh",-252,-72,!0,"Hard Drive",null,a,"Hard Drive",mediaIconsContainer),WMSX.EXTENSIONS.HARDDISK||diskHButton.classList.add("wmsx-hidden"),2!==WMSX.EXTENSIONS.HARDDISK&&diskHButton.classList.add("wmsx-hd-first"),a=[{label:"Load ROM Image",clickModif:0,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_FILE,needsUIG:!0},{label:"Set ROM Format",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_CHOOSE_FORMAT},{label:"Load Data File",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_DATA_FILE,disabled:!0,needsUIG:!0},{label:"Save Data File",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_SAVE_DATA_FILE,disabled:!0,needsUIG:!0},{label:"Remove Cartridge",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_REMOVE,disabled:!0}],cartridge1Button=addPeripheralControlButton("wmsx-bar-cart1",-78,-72,!0,"Cartridge 1",null,a,"Cartridge 1",mediaIconsContainer),a=[{label:"Load ROM Image",clickModif:0,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_FILE,secSlot:!0,needsUIG:!0},{label:"Set ROM Format",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_CHOOSE_FORMAT,secSlot:!0},{label:"Load Data File",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_DATA_FILE,secSlot:!0,disabled:!0,needsUIG:!0},{label:"Save Data File",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_SAVE_DATA_FILE,secSlot:!0,disabled:!0,needsUIG:!0},{label:"Remove Cartridge",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_REMOVE,secSlot:!0,disabled:!0}],cartridge2Button=addPeripheralControlButton("wmsx-bar-cart2",-107,-72,!0,"Cartridge 2",null,a,"Cartridge 2",mediaIconsContainer),a=[{label:"Load Tape Image",clickModif:0,control:wmsx.PeripheralControls.TAPE_LOAD_FILE,secSlot:!0,needsUIG:!0},{label:"New Blank Tape",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.TAPE_EMPTY,secSlot:!0},{label:"Rewind Tape",control:wmsx.PeripheralControls.TAPE_REWIND,disabled:!0,secSlot:!0},{label:"Run Program",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.TAPE_AUTO_RUN,secSlot:!0,disabled:!0},{label:"Save Tape Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.TAPE_SAVE_FILE,disabled:!0,secSlot:!0,needsUIG:!0},{label:"Remove Tape",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.TAPE_REMOVE,disabled:!0,secSlot:!0}],tapeButton=addPeripheralControlButton("wmsx-bar-tape",-136,-72,!0,"Cassette",null,a,"Cassette",mediaIconsContainer),a=createSettingsMenuOptions(),settingsButton=addPeripheralControlButton("wmsx-bar-settings",-96,-1,!1,"Settings",null,a,"Settings"),defineSettingsMenuExtensions(),-2!==FULLSCREEN_MODE&&(fullscreenButton=addPeripheralControlButton("wmsx-bar-full-screen",-71,-1,!1,"Full Screen",wmsx.PeripheralControls.SCREEN_FULLSCREEN),fullscreenButton.wmsxNeedsUIG=!0,isMobileDevice&&fullscreenButton.classList.add("wmsx-mobile")),WMSX.SCREEN_RESIZE_DISABLED||isMobileDevice||(scaleUpButton=addPeripheralControlButton("wmsx-bar-scale-plus",-48,-1,!1,"Increase Screen",wmsx.PeripheralControls.SCREEN_SCALE_PLUS),scaleUpButton.classList.add("wmsx-full-screen-hidden"),scaleDownButton=addPeripheralControlButton("wmsx-bar-scale-minus",-26,-1,!1,"Decrease Screen",wmsx.PeripheralControls.SCREEN_SCALE_MINUS),scaleDownButton.classList.add("wmsx-full-screen-hidden")),isMobileDevice){addPeripheralControlButton("wmsx-bar-text",-53,-51,!1,"Toggle Text Input",wmsx.PeripheralControls.OPEN_ENTER_STRING).classList.add("wmsx-mobile")}if(isTouchDevice){addPeripheralControlButton("wmsx-bar-keyboard",-83,-25,!1,"Toggle Virtual Keyboard",wmsx.PeripheralControls.SCREEN_TOGGLE_VIRTUAL_KEYBOARD).classList.add("wmsx-full-screen-only")}var b=addPeripheralControlButton("wmsx-bar-logo",-8,-25,!1,"About WebMSX",wmsx.PeripheralControls.SCREEN_OPEN_ABOUT);isTouchDevice&&b.classList.add("wmsx-full-screen-hidden"),b.classList.add("wmsx-narrow-hidden"),turboButton=addPeripheralControlButton("wmsx-bar-turbo",0,-68,!1,"CPU Turbo",wmsx.PeripheralControls.SCREEN_OPEN_QUICK_OPTIONS),turboButton.classList.add("wmsx-hidden"),turboButton.classList.add("wmsx-narrow-hidden"),capsLed=addPeripheralControlButton("wmsx-bar-caps",0,0),capsLed.classList.add("wmsx-narrow-hidden"),kanaLed=addPeripheralControlButton("wmsx-bar-kana",0,0),kanaLed.classList.add("wmsx-narrow-hidden"),wmsx.Util.onTapOrMouseDownWithBlockUIG(buttonsBar,barElementTapOrMouseDown),wmsx.Util.addEventsListener(buttonsBar,"touchmove",barElementTouchMove),wmsx.Util.addEventsListener(buttonsBar,"mouseup touchend",barElementTouchEndOrMouseUp)}function addPeripheralControlButton(a,b,c,d,e,f,g,h,i){var j=document.createElement("div");return j.id=a,j.classList.add("wmsx-bar-button"),d&&j.classList.add("wmsx-media-button"),j.wmsxBarElementType=1,j.wmsxControl=f,j.style.backgroundPosition=b+"px "+c+"px",j.wmsxBX=b,g&&(j.wmsxMenu=g,g.wmsxTitle=h,g.wmsxRefElement=j,g.wmsxMenuIndex=barMenus.length,barMenus.push(g)),e&&(j.title=e),j.addEventListener("mouseenter",function(a){barButtonHoverOver(a.target,a)}),(i||buttonsBarInner).appendChild(j),j}function barButtonTapOrMousedown(a,b,c,d){if(d||controllersHub.hapticFeedbackOnTouch(b),!logoMessageActive&&!c){var e=barMenuActive;closeAllOverlays();var f=0|(b.altKey&&KEY_ALT_MASK)|(b.ctrlKey&&KEY_CTRL_MASK)|(b.shiftKey&&KEY_SHIFT_MASK);if(a.wmsxControl)return void(b.button&&2!==b.button||peripheralControls.processControlActivated(a.wmsxControl,!1,2===b.button||f===KEY_SHIFT_MASK));var g=a.wmsxMenu;if(g){if(0===f&&!b.button)return void(e!==g&&(showBarMenu(g),"touchstart"===b.type&&barButtonLongTouchStart(b)));for(var h=0;h<g.length;++h)if(g[h].clickModif===f)return void peripheralControls.processControlActivated(g[h].control,1===b.button,g[h].secSlot)}}}function barButtonLongTouchStart(a){barButtonLongTouchTarget=a.target,barButtonLongTouchSelectTimeout=window.setTimeout(function(){if(barMenuActive)for(var a=barMenu.wmsxItems,b=0;b<a.length;++b){var c=a[b].wmsxMenuOption
;if(c&&0===c.clickModif)return void barMenuItemSetActive(a[b],!0)}},450)}function barButtonLongTouchCancel(){barButtonLongTouchSelectTimeout&&(clearTimeout(barButtonLongTouchSelectTimeout),barButtonLongTouchSelectTimeout=null)}function barButtonHoverOver(a,b){barMenuActive&&a.wmsxMenu&&barMenuActive!==a.wmsxMenu&&(controllersHub.hapticFeedbackOnTouch(b),showBarMenu(a.wmsxMenu))}function barButtonTouchEndOrMouseUp(a){logoMessageActive||barMenuItemActive&&barMenuItemFireActive(a.shiftKey||2===a.button,a.ctrlKey)}function barMenuItemTapOrMouseDown(a,b,c){c||barMenuItemSetActive(a,"touchstart"===b.type)}function barMenuItemHoverOver(a,b){barMenuItemSetActive(a,"touchmove"===b.type)}function barMenuItemHoverOut(){barMenuItemSetActive(null)}function barMenuItemTouchEndOrMouseUp(a){if(!logoMessageActive){var b=a.shiftKey||2===a.button;barMenuItemTouchActivation&&wmsx.Util.performanceNow()-barMenuItemTouchActivation>TOUCH_EXT_SLOT2_TIME&&(b|=!0),barMenuItemActive&&barMenuItemFireActive(b,a.ctrlKey)}}function barMenuItemFireActive(a,b){var c=barMenuItemActive.wmsxMenuOption;barMenuItemSetActive(null),c&&!c.disabled&&(c.extension?extensionChangeDisabledWarning()||peripheralControls.processControlActivated(wmsx.PeripheralControls.EXTENSION_TOGGLE,b,a,c.extension):c.control&&(a=c.secSlot,closeAllOverlays(),peripheralControls.processControlActivated(c.control,b,a)))}function barMenuItemSetActive(a,b){a!==barMenuItemActive&&(barMenuItemActive&&barMenuItemActive.classList.remove("wmsx-hover"),a&&a.wmsxMenuOption?(barMenuItemActive=a,b&&controllersHub.hapticFeedback(),barMenuItemActive.classList.add("wmsx-hover")):barMenuItemActive=null,barMenuItemTouchActivation=b&&barMenuItemActive?wmsx.Util.performanceNow():void 0)}function barElementTapOrMouseDown(a,b,c){cursorHideFrameCountdown=CURSOR_HIDE_FRAMES;var d=a.target;1===d.wmsxBarElementType?barButtonTapOrMousedown(d,a,b,c):2===d.wmsxBarElementType?barMenuItemTapOrMouseDown(d,a,c):hideBarMenu()}function barElementTouchMove(a){wmsx.Util.blockEvent(a);var b=a.changedTouches[0],c=b&&document.elementFromPoint(b.clientX,b.clientY);barButtonLongTouchTarget&&c!==barButtonLongTouchTarget&&barButtonLongTouchCancel(),2!==c.wmsxBarElementType&&c!==barButtonLongTouchTarget&&barMenuItemSetActive(null),1===c.wmsxBarElementType?barButtonHoverOver(c,a):2===c.wmsxBarElementType&&barMenuItemHoverOver(c,a)}function barElementTouchEndOrMouseUp(a){cursorHideFrameCountdown=CURSOR_HIDE_FRAMES,wmsx.Util.blockEvent(a),barButtonLongTouchCancel();var b=a.target;1===b.wmsxBarElementType?barButtonTouchEndOrMouseUp(a):2===b.wmsxBarElementType&&barMenuItemTouchEndOrMouseUp(a)}function createSettingsMenuOptions(){var a=[];return a.push({label:"Select Machine",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.SCREEN_OPEN_MACHINE_SELECT}),isMobileDevice?a.push({label:"Quick Options",clickModif:0,control:wmsx.PeripheralControls.SCREEN_OPEN_QUICK_OPTIONS}):(a.push({label:"Help & Settings",clickModif:0,control:wmsx.PeripheralControls.SCREEN_OPEN_SETTINGS}),a.push({label:"Quick Options",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.SCREEN_OPEN_QUICK_OPTIONS})),isTouchDevice&&a.push({label:"Touch Setup",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.SCREEN_OPEN_TOUCH_CONFIG,fullScreenOnly:!0}),isMobileDevice||a.push({label:"Defaults",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.SCREEN_DEFAULTS}),a}function defineSettingsMenuExtensions(){for(var a=settingsButton.wmsxMenu;a[0].extension;)a.shift();a[0].divider||a.unshift({label:"",divider:!0});for(var b=WMSX.EXTENSIONS_CONFIG,c=Object.keys(b).reverse(),d=0;d<c.length;++d){var e=c[d],f=b[e];if(f.DESC){var g={label:f.DESC,extension:e,toggle:!0,checkedOp:0};a.unshift(g)}}a[0].divider&&a.shift()}function refreshSettingsMenuForExtensions(){for(var a=settingsButton.wmsxMenu,b=0;b<a.length;++b){var c=a[b];c.extension&&(c.checkedOp=WMSX.EXTENSIONS[c.extension],c.noOp2=!WMSX.EXTENSIONS_CONFIG[c.extension].SLOT2)}barMenuActive===a&&refreshBarMenu(a)}function refreshSettingsMenuForMachineType(){var a=settingsButton.wmsxMenu,b=WMSX.MACHINES_CONFIG[machineTypeSocket.getMachine()];a.wmsxTitle=((b.DESC||b.DESCX).split("(")[0]||"Settings").trim(),settingsButton.wmsxMenu[settingsButton.wmsxMenu.length-5].disabled=2===room.netPlayMode,barMenuActive===a&&refreshBarMenu(a)}function setupCopyTextArea(){copyTextArea=document.createElement("textarea"),copyTextArea.id="wmsx-copy-texarea",fsElement.appendChild(copyTextArea)}function setupFullscreen(){fullscreenAPIEnterMethod=fsElement.requestFullscreen||fsElement.webkitRequestFullscreen||fsElement.webkitRequestFullScreen||fsElement.mozRequestFullScreen,fullScreenAPIExitMethod=document.exitFullscreen||document.webkitExitFullscreen||document.mozCancelFullScreen,"fullscreenElement"in document?fullScreenAPIQueryProp="fullscreenElement":"webkitFullscreenElement"in document?fullScreenAPIQueryProp="webkitFullscreenElement":"mozFullScreenElement"in document&&(fullScreenAPIQueryProp="mozFullScreenElement"),fullscreenAPIEnterMethod||!isMobileDevice||isBrowserStandalone||(fullScreenScrollHack=!0),"onfullscreenchange"in document?document.addEventListener("fullscreenchange",fullscreenByAPIChanged):"onwebkitfullscreenchange"in document?document.addEventListener("webkitfullscreenchange",fullscreenByAPIChanged):"onmozfullscreenchange"in document&&document.addEventListener("mozfullscreenchange",fullscreenByAPIChanged),fullscreenAPIEnterMethod||(scrollMessage.wmsxScroll=canvas.wmsxScroll=logo.wmsxScroll=logoCenter.wmsxScroll=logoImage.wmsxScroll=logoMessage.wmsxScroll=logoMessageText.wmsxScroll=logoMessageOK.wmsxScroll=logoMessageOKText.wmsxScroll=!0,fsElement.addEventListener("touchmove",function(a){if(isFullscreen){if(!fullScreenScrollHack||!a.target.wmsxScroll)return wmsx.Util.blockEvent(a);scrollMessageActive&&setScrollMessage(!1)}}))}function setEnterFullscreenByAPIOnFirstTouch(){if(fullscreenAPIEnterMethod){var a=!1,b=function(){a||(a=!0,wmsx.Util.removeEventsListener(fsElement,"touchend mousedown",b,!0),enterFullScreenByAPI())};wmsx.Util.addEventsListener(fsElement,"touchend mousedown",b,!0)}}function setFullscreenState(a){isFullscreen=a,a?(setViewport(),document.documentElement.classList.add("wmsx-full-screen"),fullScreenScrollHack&&document.documentElement.classList.add("wmsx-full-screen-scroll-hack"),controllersHub.setupTouchControlsIfNeeded(fsElementCenter),fullScreenScrollHack&&setScrollMessage(!0),fullscreenAPIEnterMethod||tryToFixSafariBugOnFullScreenChange()):(restoreViewport(),document.documentElement.classList.remove("wmsx-full-screen"),fullScreenScrollHack&&document.documentElement.classList.remove("wmsx-full-screen-scroll-hack"),fullscreenAPIEnterMethod||tryToFixSafariBugOnFullScreenChange()),closeAllOverlays(),self.requestReadjust(),controllersHub.screenFullscreenStateUpdate(isFullscreen)}function tryToFixSafariBugOnFullScreenChange(){var a=document.getElementById("wmsx-dummy-element");a?mainElement.removeChild(a):(a=document.createElement("div"),a.id="wmsx-dummy-element",mainElement.appendChild(a))}function showBar(){buttonsBar.classList.remove("wmsx-hidden")}function hideBar(){!BAR_AUTO_HIDE&&!isFullscreen||barMenuActive||virtualKeyboardMode||(hideBarMenu(),buttonsBar.classList.add("wmsx-hidden"))}function showBarMenu(a,b){if(a&&barMenuActive!==a){if(!barMenu)return setupBarMenu(),void setTimeout(function(){showBarMenu(a,b)},1);refreshBarMenu(a),barMenuItemSetActive(b?barMenu.wmsxDefaultItem:null);var c=a.wmsxRefElement,d=c&&c.offsetLeft-15||0;d+wmsx.ScreenGUI.BAR_MENU_WIDTH>buttonsBarInner.clientWidth?(barMenu.style.right=0,barMenu.style.left="auto",barMenu.style.transformOrigin="bottom right"):(d<0&&(d=0),barMenu.style.left=d+"px",barMenu.style.right="auto",barMenu.style.transformOrigin="bottom left"),showCursorAndBar(!0),barMenuActive=a,barMenu.style.display="inline-block",barMenu.wmsxTitle.focus()}}
function refreshBarMenu(a){barMenu.wmsxTitle.innerHTML=a.wmsxTitle,barMenu.wmsxDefaultItem=null;for(var b,c=0,d=Math.min(a.length,BAR_MENU_MAX_ITEMS),e=wmsx.ScreenGUI.BAR_MENU_ITEM_HEIGHT+3,f=0;f<d;++f){var g=a[f];void 0!==g.label&&(b=barMenu.wmsxItems[c],b.firstChild.textContent=g.label,b.wmsxMenuOption=null,g.hidden||isFullscreen&&g.fullScreenHidden||!isFullscreen&&g.fullScreenOnly?b.style.display="none":(b.style.display="block",g.divider?b.classList.add("wmsx-bar-menu-item-divider"):(b.classList.remove("wmsx-bar-menu-item-divider"),e+=wmsx.ScreenGUI.BAR_MENU_ITEM_HEIGHT,b.classList.toggle("wmsx-bar-menu-item-toggle",void 0!==g.toggle),b.classList.toggle("wmsx-no-op2",g.noOp2),g.disabled?b.classList.add("wmsx-bar-menu-item-disabled"):(b.classList.remove("wmsx-bar-menu-item-disabled"),b.wmsxMenuOption=g,0===g.clickModif&&(barMenu.wmsxDefaultItem=b),b.wmsxNeedsUIG=g.needsUIG,void 0!==g.toggle&&(b.classList.toggle("wmsx-bar-menu-item-toggle-checked",!!g.checkedOp),b.classList.toggle("wmsx-op1",0!=(1&g.checkedOp)),b.classList.toggle("wmsx-op2",0!=(2&g.checkedOp)))))),++c)}for(var h=c;h<BAR_MENU_MAX_ITEMS;++h)b=barMenu.wmsxItems[h],b.firstChild.textContent="",b.style.display="none",b.wmsxMenuOption=null;var i=fsElementCenter.clientHeight-wmsx.ScreenGUI.BAR_HEIGHT-12,j=e<i?1:i/e;barMenu&&(barMenu.style.transform="scale("+j.toFixed(4)+")")}function hideBarMenu(){barMenuActive&&(barMenuActive=null,barMenu.style.display="none",barMenuItemSetActive(null),cursorHideFrameCountdown=CURSOR_HIDE_FRAMES,self.focus())}function setupBarMenu(){barMenu=document.createElement("div"),barMenu.id="wmsx-bar-menu";var a=document.createElement("div");a.id="wmsx-bar-menu-inner",barMenu.appendChild(a);var b=document.createElement("div");b.id="wmsx-bar-menu-title",b.tabIndex=-1,b.innerHTML="Menu Title",a.appendChild(b),barMenu.wmsxTitle=b,barMenu.wmsxItems=new Array(BAR_MENU_MAX_ITEMS);for(var c=0;c<BAR_MENU_MAX_ITEMS;++c){var d=document.createElement("div");d.classList.add("wmsx-bar-menu-item"),d.style.display="none",d.innerHTML="Menu Item "+c,d.wmsxBarElementType=2,d.wmsxItemIndex=c,d.addEventListener("mouseenter",function(a){barMenuItemHoverOver(a.target,a)}),d.addEventListener("mouseleave",barMenuItemHoverOut),a.appendChild(d),barMenu.wmsxItems[c]=d}barMenu.addEventListener("keydown",function(a){var b=domKeys.codeNewForKeyboardEvent(a);if(MENU_CLOSE_KEYS[b])hideBarMenu();else if(barMenuItemActive&&MENU_EXEC_KEYS[b&~KEY_SHIFT_MASK&~KEY_CTRL_MASK])barMenuItemFireActive(a.shiftKey,a.ctrlKey);else if(MENU_SELECT_KEYS[b]){if(!barMenuActive)return;var c=barMenuActive.wmsxMenuIndex;do{c=(barMenus.length+c+MENU_SELECT_KEYS[b])%barMenus.length;var d=barMenus[c]}while(!d||d.wmsxHidden);showBarMenu(d,!0)}else if(MENU_ITEM_SELECT_KEYS[b]){var e=barMenu.wmsxItems,f=barMenuItemActive?barMenuItemActive.wmsxItemIndex:-1,g=BAR_MENU_MAX_ITEMS+1;do{f=(f+e.length+MENU_ITEM_SELECT_KEYS[b])%e.length}while(--g>=0&&!e[f].wmsxMenuOption);g>=0&&barMenuItemSetActive(e[f])}return wmsx.Util.blockEvent(a)}),buttonsBar.appendChild(barMenu)}function closePowerOnModals(){pasteDialog&&pasteDialog.hide(),textEntryDialog&&textEntryDialog.hide()}function closeAllOverlays(){hideBarMenu(),pasteDialog&&pasteDialog.hide(),textEntryDialog&&textEntryDialog.hide(),machineSelectDialog&&machineSelectDialog.hide(),diskSelectDialog&&diskSelectDialog.hide(),newHardDiskDialog&&newHardDiskDialog.hide(),saveStateDialog&&saveStateDialog.hide(),touchConfigDialog&&touchConfigDialog.hide(),quickOtionsDialog&&quickOtionsDialog.hide(),netPlayDialog&&netPlayDialog.hide(),cartFormatDialog&&cartFormatDialog.hide(),settingsDialog&&settingsDialog.hide()}function showLogoMessage(a,b,c,d){logoMessageActive||(closeAllOverlays(),d&&(afterMessageAction=d),logoMessageText.innerHTML=a,logoMessageOK.classList.toggle("wmsx-higher",!!c),logoMessageOKText.innerHTML=b||"OK",fsElement.classList.add("wmsx-logo-message-active"),logoMessageActive=!0,signalIsOn=!1,updateLogo())}function closeLogoMessage(a,b,c){if(c||controllersHub.hapticFeedbackOnTouch(a),!b&&(fsElement.classList.remove("wmsx-logo-message-active"),logoMessageActive=!1,afterMessageAction)){var d=afterMessageAction;afterMessageAction=null,d()}}function updateLogoScale(){if(logoMessageActive){var a=canvasOuter.clientWidth,b=Math.min(a/wmsx.ScreenGUI.LOGO_SCREEN_WIDTH,1);logoCenter.style.transform="translate(-50%, -50%) scale("+b.toFixed(4)+")"}else logoCenter.style.transform="translate(-50%, -50%)"}function setScrollMessage(a){fsElement.classList.toggle("wmsx-scroll-message",a),scrollMessageActive=a,a&&setTimeout(function(){setScrollMessage(!1)},5e3)}function readjustAll(a){if(readjustScreeSizeChanged(a)){if(isFullscreen){var b=readjustScreenSize.w>readjustScreenSize.h,c=virtualKeyboardMode&&updateKeyboardWidth(readjustScreenSize.w);buttonsBarDesiredWidth=b?virtualKeyboardMode?c.w:0:-1;var d=readjustScreenSize.h;b&&!virtualKeyboardMode||(d-=wmsx.ScreenGUI.BAR_HEIGHT+2),virtualKeyboardMode&&(d-=c.h+2),monitor.displayScale(aspectX,displayOptimalScaleY(readjustScreenSize.w,d))}else buttonsBarDesiredWidth=-1,monitor.displayScale(aspectX,scaleYBeforeUserFullscreen||displayDefaultScale());self.focus(),controllersHub.screenReadjustedUpdate()}readjustInterval&&wmsx.Util.performanceNow()-readjustRequestTime>=1e3&&(clearInterval(readjustInterval),readjustInterval=null)}function readjustScreeSizeChanged(a){var b=mainElement.parentElement.clientWidth,c=fsElementCenter.clientWidth,d=fsElementCenter.clientHeight;return!(!a&&readjustScreenSize.pw===b&&readjustScreenSize.w===c&&readjustScreenSize.h===d)&&(readjustScreenSize.pw=b,readjustScreenSize.w=c,readjustScreenSize.h=d,!0)}function displayOptimalScaleY(a,b){var c=b/targetHeight;return targetWidth*aspectX*c>a&&(c=a/(targetWidth*aspectX)),c}function setViewport(){if(isMobileDevice){if(void 0===viewPortOriginalContent&&(viewPortOriginalTag=document.querySelector("meta[name=viewport]"),viewPortOriginalContent=viewPortOriginalTag&&viewPortOriginalTag.content||null),viewportTag||(viewportTag=document.createElement("meta"),viewportTag.name="viewport",viewportTag.content="width = device-width, height = device-height, initial-scale = 1.0, minimum-scale = 1.0, maximum-scale = 1.0, user-scalable = yes",document.head.appendChild(viewportTag)),viewPortOriginalTag)try{document.head.removeChild(viewPortOriginalTag)}catch(a){}viewPortOriginalTag=null}}function restoreViewport(){if(isMobileDevice){if(!viewPortOriginalTag&&viewPortOriginalContent&&(viewPortOriginalTag=document.createElement("meta"),viewPortOriginalTag.name="viewport",viewPortOriginalTag.content=viewPortOriginalContent,document.head.appendChild(viewPortOriginalTag)),viewportTag)try{document.head.removeChild(viewportTag)}catch(a){}viewportTag=null}}function setPageVisibilityHandling(){function a(){logoMessageActive||(document.hidden?b=!machine.systemPause(!0):b&&machine.systemPause(!1))}var b;document.addEventListener("visibilitychange",a)}function extensionChangeDisabledWarning(){return!!WMSX.MEDIA_CHANGE_DISABLED&&(machine.showOSD("Extension change is disabled!",!0,!0),!0)}function setupFileLoaderDropTargets(){fileLoaderDropArea=document.getElementById("wmsx-drop-area"),fileLoaderDropAreaMessage=document.getElementById("wmsx-drop-area-message");var a,b,c,d;a=fsElement,c={element:a,openType:OPEN_TYPE.DISK,port:void 0,add:!0,mainEle:a,mes:"Add Disk(s) to Drive (auto-detect)",mesSec:"Add Disk(s) to Drive B Stack"},d={element:a,openType:OPEN_TYPE.DISK,port:void 0,files:!0,mainEle:a,mes:"Add Files to Drive (auto-detect)",mesSec:"Add Files to Disk in Drive B"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.AUTO,port:void 0,subAdd:c,subFiles:d,mes:"Auto detect media",mesSec:"Auto detect media (to Drive B / Cartridge 2)"},diskAButton.wmsxDropTarget=a=document.getElementById("wmsx-drop-drivea"),b=document.getElementById("wmsx-drop-drivea-add"),b.wmsxDropInfo=c={element:b,openType:OPEN_TYPE.DISK,port:0,add:!0,
mainEle:a,mes:"Add Disk(s) to Drive A Stack"},b=document.getElementById("wmsx-drop-drivea-files"),b.wmsxDropInfo=d={element:b,openType:OPEN_TYPE.DISK,port:0,files:!0,mainEle:a,mes:"Add Files to Disk in Drive A"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.DISK,port:0,subAdd:c,subFiles:d,mes:"Load Disk(s) in Drive A"},diskBButton.wmsxDropTarget=a=document.getElementById("wmsx-drop-driveb"),b=document.getElementById("wmsx-drop-driveb-add"),b.wmsxDropInfo=c={element:b,openType:OPEN_TYPE.DISK,port:1,add:!0,mainEle:a,mes:"Add Disk(s) to Drive B Stack"},b=document.getElementById("wmsx-drop-driveb-files"),b.wmsxDropInfo=d={element:b,openType:OPEN_TYPE.DISK,port:1,files:!0,mainEle:a,mes:"Add Files to Disk in Drive B"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.DISK,port:1,subAdd:c,subFiles:d,mes:"Load Disk(s) in Drive B"},diskHButton.wmsxDropTarget=a=document.getElementById("wmsx-drop-driveh"),b=document.getElementById("wmsx-drop-driveh-files"),b.wmsxDropInfo=d={element:b,openType:OPEN_TYPE.DISK,port:2,files:!0,mainEle:a,mes:"Add Files to Hard Disk"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.DISK,port:2,subFiles:d,mes:"Load Hard Disk"},a=document.getElementById("wmsx-drop-cart1"),a.wmsxDropInfo={element:a,openType:OPEN_TYPE.ROM,port:0,mes:"Load Cartride 1"},a=document.getElementById("wmsx-drop-cart2"),a.wmsxDropInfo={element:a,openType:OPEN_TYPE.ROM,port:1,mes:"Load Cartride 2"},a=document.getElementById("wmsx-drop-tape"),a.wmsxDropInfo={element:a,openType:OPEN_TYPE.TAPE,port:0,mes:"Load Cassette Tape"}}var self=this;this.connect=function(a){machine=a,monitor.connect(machine.getVideoOutput()),controllersSocket=machine.getControllersSocket(),cartridgeSocket=machine.getCartridgeSocket(),extensionsSocket=machine.getExtensionsSocket(),machineTypeSocket=machine.getMachineTypeSocket()},this.connectPeripherals=function(a,b,c,d,e,f,g,h){cartridgeSlot=a,fileLoader=b,fileLoader.registerForDnD(fsElement),fileLoader.registerForFileInputElement(fsElement),fileDownloader=c,fileDownloader.registerForDownloadElement(fsElement),machineControls=d,peripheralControls=e,controllersHub=f,controllersHub.setKeyInputElement(fsElement),controllersHub.setMouseInputElement(canvas),diskDrive=g,stateMedia=h},this.powerOn=function(){monitor.setDefaults(),updateLogo(),document.documentElement.classList.add("wmsx-started"),setPageVisibilityHandling(),this.focus(),WMSXFullScreenSetup.shouldStartInFullScreen()&&(setFullscreenState(!0),1===FULLSCREEN_MODE&&setEnterFullscreenByAPIOnFirstTouch())},this.powerOff=function(){document.documentElement.classList.remove("wmsx-started")},this.start=function(a){function b(){self.setFullscreen(!0),a()}!isMobileDevice||isBrowserStandalone||isFullscreen?a():wmsx.Util.isOfficialHomepage()?showLogoMessage("For "+(fullscreenAPIEnterMethod?"the best":"a full-screen")+' experience, use<br>the "Add to Home Screen" function<br>then launch from the Installed App',"NICE!",!1,b):showLogoMessage("For the best experience,<br>WebMSX will go full-screen","GO!",!0,b)},this.refresh=function(a,b,c){cursorHideFrameCountdown>0&&--cursorHideFrameCountdown<=0&&hideCursorAndBar(),signalIsOn||(signalIsOn=!0,updateLogo()),canvasContext||createCanvasContext(),canvasContext.drawImage(a,0,0,b,c,0,0,canvas.width,canvas.height),crtScanlines&&pixelHeight>1&&!debugMode&&canvasContext.drawImage(scanlinesImage,0,0,1,2*c,0,0,canvas.width,canvas.height),ledsUpdatePending>=0&&updateLeds()},this.videoSignalOff=function(){signalIsOn=!1,ledsUpdatePending=0,showCursorAndBar(),updateLeds(),updateLogo()},this.mousePointerLocked=function(a){mousePointerLocked=a,mousePointerLocked?hideCursorAndBar():showCursorAndBar()},this.openHelp=function(){return self.openSettings("GENERAL"),!1},this.openAbout=function(){return self.openSettings("ABOUT"),!1},this.openSettings=function(a){closeAllOverlays(),settingsDialog||(settingsDialog=new wmsx.SettingsDialog(fsElementCenter,controllersHub,peripheralControls,machineTypeSocket)),settingsDialog.show(a)},this.openSaveStateDialog=function(a){closeAllOverlays(),saveStateDialog||(saveStateDialog=new wmsx.SaveStateDialog(fsElementCenter,machineControls,peripheralControls,stateMedia)),saveStateDialog.show(a)},this.openDiskSelectDialog=function(a,b,c){closeAllOverlays(),diskSelectDialog||(diskSelectDialog=new wmsx.DiskSelectDialog(fsElementCenter,diskDrive,peripheralControls,fileLoader)),diskSelectDialog.show(a,b,c)},this.openNewHardDiskDialog=function(a,b){closeAllOverlays(),newHardDiskDialog||(newHardDiskDialog=new wmsx.NewHardDiskDialog(fsElementCenter,peripheralControls)),newHardDiskDialog.show(a,b)},this.openMachineSelectDialog=function(){if(closeAllOverlays(),WMSX.MEDIA_CHANGE_DISABLED)return this.showOSD("Machine change is disabled!",!0,!0);machineSelectDialog||(machineSelectDialog=new wmsx.MachineSelectDialog(fsElementCenter,machineTypeSocket,peripheralControls)),machineSelectDialog.show()},this.openTouchConfigDialog=function(){closeAllOverlays(),virtualKeyboardMode&&setVirtualKeyboard(0),touchConfigDialog||(touchConfigDialog=new wmsx.TouchConfigDialog(fsElement,canvasOuter,controllersHub,peripheralControls)),touchConfigDialog.show()},this.openQuickOptionsDialog=function(){closeAllOverlays(),virtualKeyboardMode&&setVirtualKeyboard(0),quickOtionsDialog||(quickOtionsDialog=new wmsx.QuickOptionsDialog(fsElementCenter,machineControls,peripheralControls)),quickOtionsDialog.show()},this.openNetPlayDialog=function(){closeAllOverlays(),netPlayDialog||(netPlayDialog=new wmsx.NetPlayDialog(room,fsElementCenter)),netPlayDialog.show()},this.openCartridgeFormatDialog=function(a,b){closeAllOverlays(),cartFormatDialog||(cartFormatDialog=new wmsx.CartridgeFormatDialog(this,fsElementCenter,machine,cartridgeSlot)),cartFormatDialog.show(a,b)},this.openLoadFileDialog=function(){return peripheralControls.processControlActivated(wmsx.PeripheralControls.AUTO_LOAD_FILE),!1},this.executeTextCopy=function(){if(!signalIsOn)return this.showOSD("Screen Text Copy only available when Power is ON!",!0,!0);if(!document.queryCommandSupported||!document.queryCommandSupported("copy"))return this.showOSD("Copy to Clipboard not supported by the browser!",!0,!0);var a=monitor.getScreenText();if(!a)return this.showOSD("Screen Text Copy not available in this Screen!",!0,!0);copyTextArea||setupCopyTextArea(),copyTextArea.innerHTML=a,copyTextArea.select(),document.execCommand("copy")?this.showOSD("Screen text copied to Clipboard",!0):this.showOSD("Copy to Clipboard not supported by the browser!",!0,!0),this.focus()},this.toggleTextPasteDialog=function(){return signalIsOn?(pasteDialog||(pasteDialog=new wmsx.PasteDialog(canvasOuter,this,machineControls)),pasteDialog.toggle(),!1):this.showOSD("Text Paste only available when Power is ON!",!0,!0)},this.toggleTextEntryDialog=function(){return signalIsOn?(virtualKeyboardMode&&setVirtualKeyboard(0),textEntryDialog||(textEntryDialog=new wmsx.TextEntryDialog(fsElementCenter,this,machineControls)),textEntryDialog.toggle(),!1):this.showOSD("Text Entry only available when Power is ON!",!0,!0)},this.toggleMenuByKey=function(){barMenuActive?hideBarMenu():(closeAllOverlays(),showBarMenu(barMenuSystem,!0))},this.toggleVirtualKeyboard=function(){setVirtualKeyboard((virtualKeyboardMode+1)%3)},this.getScreenCapture=function(){if(signalIsOn)return canvas.toDataURL("image/png")},this.saveScreenCapture=function(){var a=this.getScreenCapture();a&&fileDownloader.startDownloadURL("WMSX Screen.png",a,"WebMSX Screen Capture")},this.displayMetrics=function(a,b){targetWidth===a&&targetHeight===b||(targetWidth=a,targetHeight=b,updateCanvasContentSize(),isFullscreen?this.requestReadjust(!0):updateScale())},this.displayPixelMetrics=function(a,b){pixelWidth===a&&pixelHeight===b||(pixelWidth=a,pixelHeight=b,controllersHub&&controllersHub.setScreenPixelScale(pixelWidth*scaleY*aspectX,pixelHeight*scaleY))},this.displayScale=function(a,b){aspectX=a,scaleY=b,updateScale(),
controllersHub&&controllersHub.setScreenPixelScale(pixelWidth*scaleY*aspectX,pixelHeight*scaleY)},this.getMonitor=function(){return monitor},this.showOSD=function(a,b,c){if(osdTimeout&&clearTimeout(osdTimeout),!a)return osd.style.transition="all 0.15s linear",osd.style.top="-29px",osd.style.opacity=0,void(osdShowing=!1);!b&&osdShowing||(osd.innerHTML=a,osd.style.color=c?"rgb(255, 60, 40)":"rgb(0, 255, 0)"),osd.style.transition="none",osd.style.top="12px",osd.style.opacity=1,osdShowing=!0;var d=canvasOuter.clientWidth-30,e=osd.clientWidth,f=e<d?1:d/e;osd.style.transform="scale("+f.toFixed(4)+")",osdTimeout=setTimeout(hideOSD,OSD_TIME)},this.setDebugMode=function(a){debugMode=!!a,canvasContext=null},this.aspectAndScaleSetDefault=function(){aspectX=WMSX.SCREEN_DEFAULT_ASPECT,scaleY=displayDefaultScale(),scaleYBeforeUserFullscreen=0},this.crtFilterToggle=function(a){var b;a?(b=crtFilter-1)<-2&&(b=3):(b=crtFilter+1)>3&&(b=-2),setCRTFilter(b);var c=null===crtFilterEffective?"browser default":crtFilterEffective<1?"OFF":"level "+crtFilterEffective;this.showOSD("CRT Filter: "+(-1===crtFilter?"AUTO ("+c+")":c),!0),WMSX.userPreferences.current.crtFilter!==crtFilter&&(WMSX.userPreferences.current.crtFilter=crtFilter,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())},this.crtFilterSetDefault=function(){var a=WMSX.userPreferences.current.crtFilter;setCRTFilter(-3!==WMSX.SCREEN_FILTER_MODE?WMSX.SCREEN_FILTER_MODE:null!==a&&a>-3?a:-1)},this.crtScanlinesToggle=function(a){var b;if(a?(b=crtScanlines-1)<0&&(b=10):(b=crtScanlines+1)>10&&(b=0),!crtScanlines&&b){for(var c=[.5,.75,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5],d=0;d<c.length-1&&scaleY>=c[d];)++d;monitor.displayScale(aspectX,c[d-1])}setCRTScanlines(b),this.showOSD("CRT Scanlines: "+(0===crtScanlines?"OFF":10*crtScanlines+"%"),!0),WMSX.userPreferences.current.crtScanlines!==crtScanlines&&(WMSX.userPreferences.current.crtScanlines=crtScanlines,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())},this.crtScanlinesSetDefault=function(){var a=WMSX.userPreferences.current.crtScanlines;setCRTScanlines(-1!==WMSX.SCREEN_CRT_SCANLINES?WMSX.SCREEN_CRT_SCANLINES:null!==a&&a>-1?a:0)},this.crtPhosphorToggle=function(a){var b;a?(b=crtPhosphor-1)<-1&&(b=1):(b=crtPhosphor+1)>1&&(b=-1),setCRTPhosphor(b);var c=1===crtPhosphorEffective?"ON":"OFF";this.showOSD("CRT Phosphor: "+(-1===crtPhosphor?"AUTO ("+c+")":c),!0)},this.crtPhosphorSetDefault=function(){setCRTPhosphor(WMSX.SCREEN_CRT_PHOSPHOR)},this.getControlReport=function(a){switch(a){case wmsx.PeripheralControls.SCREEN_CRT_FILTER:return{label:-2===crtFilter?"Browser":-1===crtFilter?"Auto":0===crtFilter?"OFF":"Level "+crtFilter,active:crtFilter>=0};case wmsx.PeripheralControls.SCREEN_CRT_SCANLINES:return{label:0===crtScanlines?"OFF":10*crtScanlines+"%",active:crtScanlines>0}}return{label:"Unknown",active:!1}},this.displayToggleFullscreen=function(a){-2!==FULLSCREEN_MODE&&(isFullscreen||isMobileDevice||(scaleYBeforeUserFullscreen=scaleY),this.setFullscreen(!isFullscreen,a))},this.setFullscreen=function(a,b){a?!b&&fullscreenAPIEnterMethod?enterFullScreenByAPI():setFullscreenState(!0):isFullScreenByAPI()?exitFullScreenByAPI():setFullscreenState(!1)},this.focus=function(){canvas.focus()},this.machinePowerAndUserPauseStateUpdate=function(a,b){powerButton.style.backgroundPosition=powerButton.wmsxBX+"px "+barButtonBackYOffsets[a?2:1]+"px",2===room.netPlayMode?(powerButton.wmsxMenu[5].disabled=powerButton.wmsxMenu[6].disabled=powerButton.wmsxMenu[8].disabled=powerButton.wmsxMenu[9].disabled=!0,powerButton.wmsxMenu[1].disabled=!a):(powerButton.wmsxMenu[5].disabled=powerButton.wmsxMenu[6].disabled=powerButton.wmsxMenu[8].disabled=!1,powerButton.wmsxMenu[1].disabled=powerButton.wmsxMenu[9].disabled=!a)},this.diskDrivesMediaStateUpdate=function(a){var b=2===a?diskHButton:1===a?diskBButton:diskAButton,c=diskDrive.getDriveStack(a);if(b.title=diskDrive.getCurrentDiskDesc(a),a<2?(b.wmsxMenu[8].label="Remove "+(c.length>1?"Stack":"Disk"),2===room.netPlayMode?b.wmsxMenu[0].disabled=b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=b.wmsxMenu[4].disabled=b.wmsxMenu[5].disabled=b.wmsxMenu[6].disabled=b.wmsxMenu[7].disabled=b.wmsxMenu[8].disabled=!0:(b.wmsxMenu[0].disabled=b.wmsxMenu[4].disabled=b.wmsxMenu[5].disabled=!1,b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=c.length>=wmsx.FileDiskDrive.MAX_STACK,b.wmsxMenu[6].disabled=c.length<=1,b.wmsxMenu[7].disabled=b.wmsxMenu[8].disabled=0===c.length)):2===room.netPlayMode?b.wmsxMenu[0].disabled=b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=b.wmsxMenu[4].disabled=b.wmsxMenu[5].disabled=b.wmsxMenu[6].disabled=!0:(b.wmsxMenu[0].disabled=b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=b.wmsxMenu[4].disabled=!1,b.wmsxMenu[5].disabled=b.wmsxMenu[6].disabled=0===c.length),diskSelectDialog&&diskSelectDialog.diskDrivesMediaStateUpdate(a),c.length>1){var d=diskDrive.getCurrentDiskNum(a)+1;b.wmsxMenu.wmsxTitle=diskDrive.getDriveName(a)+"&nbsp;&nbsp;("+d+"/"+c.length+")"}else b.wmsxMenu.wmsxTitle=diskDrive.getDriveName(a)},this.diskDrivesMotorStateUpdate=function(a,b,c,d,e,f,g,h,i){diskAButton.style.backgroundPosition=diskAButton.wmsxBX+"px "+mediaButtonBackYOffsets[b?3:a?c?2:1:0]+"px",diskBButton.style.backgroundPosition=diskBButton.wmsxBX+"px "+mediaButtonBackYOffsets[e?3:d?f?2:1:0]+"px",diskHButton.style.backgroundPosition=diskHButton.wmsxBX+"px "+mediaButtonBackYOffsets[h?3:g?i?2:1:0]+"px"},this.diskInterfacesStateUpdate=function(a,b){peripheralControls.diskInterfacesStateUpdate(a,b),diskAButton.classList.toggle("wmsx-hidden",!a),diskAButton.wmsxDropTarget.classList.toggle("wmsx-disabled",!a),diskAButton.wmsxDropTarget.wmsxDropInfo.disabled=!a,diskAButton.wmsxMenu.wmsxHidden=!a,diskBButton.classList.toggle("wmsx-hidden",!a),diskBButton.wmsxDropTarget.classList.toggle("wmsx-disabled",!a),diskBButton.wmsxDropTarget.wmsxDropInfo.disabled=!a,diskBButton.wmsxMenu.wmsxHidden=!a,diskHButton.classList.toggle("wmsx-hidden",!b),diskHButton.wmsxDropTarget.classList.toggle("wmsx-disabled",!b),diskHButton.wmsxDropTarget.wmsxDropInfo.disabled=!b;var c=diskHButton.wmsxMenu;c.wmsxHidden=!b;var d=diskDrive.isHardDriveFirst();diskHButton.classList.toggle("wmsx-hd-first",!!d),diskHButton.wmsxDropTarget.classList.toggle("wmsx-hd-first",!!d);var e=d?1:4;barMenus[1]=1===e?c:null,barMenus[4]=4===e?c:null,c.wmsxMenuIndex=e},this.extensionsAndCartridgesStateUpdate=function(){var a=cartridgeSocket.cartridgeInserted(0),b=cartridgeSocket.cartridgeInserted(1);cartridge1Button.title="Cartridge 1"+(a?": "+(a.format.internal?a.format.desc:(a.rom.source||"<Unknown>")+"  ["+a.format.name+"]"):""),cartridge2Button.title="Cartridge 2"+(b?": "+(b.format.internal?b.format.desc:(b.rom.source||"<Unknown>")+"  ["+b.format.name+"]"):"");var c=a&&a.getDataDesc();cartridge1Button.wmsxMenu[2].label="Load "+(c||"Data")+" File",cartridge1Button.wmsxMenu[3].label="Save "+(c||"Data")+" File",2===room.netPlayMode?cartridge1Button.wmsxMenu[0].disabled=cartridge1Button.wmsxMenu[1].disabled=cartridge1Button.wmsxMenu[2].disabled=cartridge1Button.wmsxMenu[3].disabled=cartridge1Button.wmsxMenu[4].disabled=!0:(cartridge1Button.wmsxMenu[0].disabled=!1,cartridge1Button.wmsxMenu[2].disabled=cartridge1Button.wmsxMenu[3].disabled=!c,cartridge1Button.wmsxMenu[1].disabled=!a||a.format.internal,cartridge1Button.wmsxMenu[4].disabled=!a),c=b&&b.getDataDesc(),cartridge2Button.wmsxMenu[2].label="Load "+(c||"Data")+" File",cartridge2Button.wmsxMenu[3].label="Save "+(c||"Data")+" File",2===room.netPlayMode?cartridge2Button.wmsxMenu[0].disabled=cartridge2Button.wmsxMenu[1].disabled=cartridge2Button.wmsxMenu[2].disabled=cartridge2Button.wmsxMenu[3].disabled=cartridge2Button.wmsxMenu[4].disabled=!0:(cartridge2Button.wmsxMenu[0].disabled=!1,cartridge2Button.wmsxMenu[2].disabled=cartridge2Button.wmsxMenu[3].disabled=!c,
cartridge2Button.wmsxMenu[1].disabled=!b||b.format.internal,cartridge2Button.wmsxMenu[4].disabled=!b),this.cartridgesModifiedStateUpdate(a,b),refreshSettingsMenuForExtensions()},this.cartridgesModifiedStateUpdate=function(a,b){cartridge1Button.style.backgroundPosition=cartridge1Button.wmsxBX+"px "+mediaButtonBackYOffsets[a?a.dataModified()?2:1:0]+"px",cartridge2Button.style.backgroundPosition=cartridge2Button.wmsxBX+"px "+mediaButtonBackYOffsets[b?b.dataModified()?2:1:0]+"px"},this.tapeStateUpdate=function(a,b,c){tapeButton.title="Cassette Tape"+(a?": "+a:""),tapeButton.style.backgroundPosition=tapeButton.wmsxBX+"px "+mediaButtonBackYOffsets[b?3:a?c?2:1:0]+"px",2===room.netPlayMode?(tapeButton.wmsxMenu[0].disabled=tapeButton.wmsxMenu[1].disabled=tapeButton.wmsxMenu[2].disabled=tapeButton.wmsxMenu[4].disabled=tapeButton.wmsxMenu[5].disabled=!0,tapeButton.wmsxMenu[3].disabled=!a):(tapeButton.wmsxMenu[0].disabled=tapeButton.wmsxMenu[1].disabled=!1,tapeButton.wmsxMenu[2].disabled=tapeButton.wmsxMenu[3].disabled=tapeButton.wmsxMenu[4].disabled=tapeButton.wmsxMenu[5].disabled=!a)},this.machineTypeStateUpdate=function(){machineSelectDialog&&machineSelectDialog.machineTypeStateUpdate(),refreshSettingsMenuForMachineType()},this.keyboardSettingsStateUpdate=function(){settingsDialog&&settingsDialog.keyboardSettingsStateUpdate()},this.controllersSettingsStateUpdate=function(){settingsDialog&&settingsDialog.controllersSettingsStateUpdate(),touchConfigDialog&&touchConfigDialog.controllersSettingsStateUpdate()},this.mouseActiveCursorStateUpdate=function(a){cursorType=a?'url("'+wmsx.Images.urls.mouseCursor+'"), auto':"auto",fsElement.style.cursor=cursorShowing?cursorType:"none",showCursorAndBar()},this.touchControlsActiveUpdate=function(a,b,c){touchControlsActive===a&&touchControlsDirBig===b&&touchControlsMirror===c||(touchControlsActive=a,touchControlsDirBig=b,touchControlsMirror=c,isFullscreen&&(touchControlsActive&&controllersHub.setupTouchControlsIfNeeded(fsElementCenter),this.requestReadjust(!0)))},this.roomNetPlayStatusChangeUpdate=function(a){netPlayDialog&&netPlayDialog.isVisible()||closeAllOverlays(),netPlayDialog&&netPlayDialog.roomNetPlayStatusChangeUpdate(a),netplayButton.classList.toggle("wmsx-hidden",room.netPlayMode<1)},this.quickOptionsControlsStateUpdate=function(){quickOtionsDialog&&quickOtionsDialog.quickOptionsControlsStateUpdate()},this.machineTurboModesStateUpdate=function(){quickOtionsDialog&&quickOtionsDialog.machineTurboModesStateUpdate();var a=machine.cpu.getCPUTurboMulti();turboButton.classList.toggle("wmsx-hidden",1===a),1!==a&&(turboButton.textContent=a+"x")},this.speakerUnlockStateUpdate=function(a){if(unmuteMessage.classList.toggle("wmsx-show",!a),!a){var b=canvasOuter.clientWidth-30,c=unmuteMessage.clientWidth,d=c<b?1:b/c;unmuteMessage.style.transform="translate(-50%, 0) scale("+d.toFixed(4)+")"}},this.configurationStateUpdate=function(){closeAllOverlays(),machineSelectDialog&&machineSelectDialog.configurationStateUpdate(),defineSettingsMenuExtensions()},this.ledsStateUpdate=function(a,b){ledsUpdatePending=(b?2:0)|(a?1:0)},this.setLoading=function(a){isLoading=a,updateLoading(),a||(wmsx.Configurator.addConfigurationStateListener(this),machine.getMachineControlsSocket().addPowerAndUserPauseStateListener(this),machineTypeSocket.addMachineTypeStateListener(this),extensionsSocket.addExtensionsAndCartridgesStateListener(this),machine.getDiskDriveSocket().setInterfacesChangeListener(this),machine.getBIOSSocket().setMachineTurboModesStateListener(this),machine.getCartridgeSocket().setCartridgesModifiedStateListener(this),machine.getLedsSocket().setLedsStateListener(this))},this.requestReadjust=function(a){a?readjustAll(!0):(readjustRequestTime=wmsx.Util.performanceNow(),readjustInterval||(readjustInterval=setInterval(readjustAll,50)))},this.setFileLoaderDragMessage=function(a){var b=!!a;b&&(closeAllOverlays(),fileLoaderDropAreaMessage.textContent=a),b!=fileLoaderDragActive&&(fileLoaderDragActive=b,fileLoaderDropArea.classList.toggle("wmsx-visible",b),b&&wmsx.Util.scaleToFitParentWidth(fileLoaderDropArea,fsElement,11))};var afterMessageAction,machine,monitor,machineControls,peripheralControls,cartridgeSlot,fileLoader,fileDownloader,controllersHub,extensionsSocket,machineTypeSocket,controllersSocket,cartridgeSocket,diskDrive,stateMedia,readjustInterval=0,readjustRequestTime=0,readjustScreenSize={w:0,wk:0,h:0,pw:0},isFullscreen=!1,isTouchDevice=wmsx.Util.isTouchDevice(),isMobileDevice=wmsx.Util.isMobileDevice(),isIOSDevice=wmsx.Util.isIOSDevice(),isBrowserStandalone=wmsx.Util.isBrowserStandaloneMode(),browserName=wmsx.Util.browserInfo().name,fileLoaderDropArea,fileLoaderDragActive=!1,fileLoaderDropAreaMessage,fullscreenAPIEnterMethod,fullScreenAPIExitMethod,fullScreenAPIQueryProp,fullScreenAPIExitUserRequested=!1,fullScreenScrollHack=!1,viewportTag,viewPortOriginalTag,viewPortOriginalContent,settingsDialog,saveStateDialog,diskSelectDialog,newHardDiskDialog,machineSelectDialog,touchConfigDialog,quickOtionsDialog,netPlayDialog,cartFormatDialog,pasteDialog,textEntryDialog,copyTextArea,unmuteMessage,fsElement,fsElementCenter,canvas,canvasOuter,canvasLoadingIcon,canvasContext,canvasImageRenderingValue,scanlinesImage,touchControlsActive=!1,touchControlsDirBig=!1,touchControlsMirror=!1,virtualKeyboardMode=0,virtualKeyboardElement,virtualKeyboard,buttonsBar,buttonsBarInner,buttonsBarDesiredWidth=-1,barButtonLongTouchTarget,barButtonLongTouchSelectTimeout,barMenu,barMenus=[],barMenuActive,barMenuItemActive,barMenuSystem,barMenuItemTouchActivation=0,osd,osdTimeout,osdShowing=!1,cursorType="auto",cursorShowing=!0,cursorHideFrameCountdown=-1,signalIsOn=!1,crtFilter=-1,crtFilterEffective=null,crtScanlines=0,crtPhosphor=-1,crtPhosphorEffective=0,debugMode=!1,isLoading=!1,ledsUpdatePending=-1,aspectX=WMSX.SCREEN_DEFAULT_ASPECT,scaleY=1,scaleYBeforeUserFullscreen=0,pixelWidth=1,pixelHeight=1,mousePointerLocked=!1,targetWidth=wmsx.VDP.SIGNAL_MAX_WIDTH_V9938,targetHeight=1===WMSX.MACHINES_CONFIG[WMSX.MACHINE].TYPE?2*wmsx.VDP.SIGNAL_HEIGHT_V9918:wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938,logo,logoCenter,logoImage,logoMessage,logoMessageText,logoMessageOK,logoMessageOKText,logoMessageActive=!1,logoLoadingIcon,scrollMessage,scrollMessageActive=!1,powerButton,mediaIconsContainer,diskAButton,diskBButton,diskHButton,cartridge1Button,cartridge2Button,tapeButton,turboButton,capsLed,kanaLed,netplayButton,scaleDownButton,scaleUpButton,fullscreenButton,settingsButton,barButtonBackYOffsets=[-51,-26,-1],mediaButtonBackYOffsets=[-72,-48,-24,0],OSD_TIME=4500,CURSOR_HIDE_FRAMES=180,FULLSCREEN_MODE=WMSX.SCREEN_FULLSCREEN_MODE,BAR_AUTO_HIDE=0===WMSX.SCREEN_CONTROL_BAR,BAR_MENU_MAX_ITEMS=25,VIRTUAL_KEYBOARD_WIDE_WIDTH=518,VIRTUAL_KEYBOARD_NARROW_WIDTH=419,VIRTUAL_KEYBOARD_HEIGHT=161,NARROW_WIDTH=500,domKeys=wmsx.DOMKeys,TOUCH_EXT_SLOT2_TIME=650,KEY_CTRL_MASK=domKeys.CONTROL,KEY_ALT_MASK=domKeys.ALT,KEY_SHIFT_MASK=domKeys.SHIFT,MENU_CLOSE_KEYS={};MENU_CLOSE_KEYS[domKeys.VK_ESCAPE.wc]=1,MENU_CLOSE_KEYS[domKeys.VK_CONTEXT.wc]=1;var MENU_EXEC_KEYS={};MENU_EXEC_KEYS[domKeys.VK_ENTER.wc]=1,MENU_EXEC_KEYS[domKeys.VK_SPACE.wc]=1;var MENU_SELECT_KEYS={};MENU_SELECT_KEYS[domKeys.VK_LEFT.wc]=-1,MENU_SELECT_KEYS[domKeys.VK_RIGHT.wc]=1;var MENU_ITEM_SELECT_KEYS={};MENU_ITEM_SELECT_KEYS[domKeys.VK_UP.wc]=-1,MENU_ITEM_SELECT_KEYS[domKeys.VK_DOWN.wc]=1;var OPEN_TYPE=wmsx.FileLoader.OPEN_TYPE;init(),this.eval=function(str){return eval(str)}},wmsx.SettingsGUI={},wmsx.SettingsGUI.html=function(){
return'<div id="wmsx-modal" tabindex="-1"> <div id="wmsx-menu"> <div id="wmsx-back"> <div class="wmsx-back-arrow"> </div> </div> <div class="wmsx-caption"> Help & Settings </div> <div class="wmsx-items"> <div id="wmsx-menu-general" class="wmsx-item wmsx-selected"> GENERAL </div> <div id="wmsx-menu-media" class="wmsx-item"> MEDIA </div> <div id="wmsx-menu-inputs" class="wmsx-item"> KEYBOARD </div> <div id="wmsx-menu-ports" class="wmsx-item"> PORTS </div> <div id="wmsx-menu-about" class="wmsx-item"> ABOUT </div> <div id="wmsx-menu-selection"> </div> </div> </div> <div id="wmsx-content"> <div id="wmsx-general"> <div class="wmsx-left"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> F11 </div> </div> <div class="wmsx-desc"> Power </div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> Shift </div>&nbsp;+&nbsp;<div class="wmsx-key"> F11 </div> </div> <div class="wmsx-desc">Reset</div> </div> <div class="wmsx-full-divider"></div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> T </div> </div> <div class="wmsx-desc">CPU Turbo Mode</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Y </div> </div> <div class="wmsx-desc">VDP Turbo Mode</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Q </div> </div> <div class="wmsx-desc">NTSC/PAL</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> E </div> </div> <div class="wmsx-desc">CRT Filters</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> R </div> </div> <div class="wmsx-desc">CRT Scanlines</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> D </div> </div> <div class="wmsx-desc">Debug Modes</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> S </div> </div> <div class="wmsx-desc">Sprite Modes</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key"> Shift </div> </div> <div class="wmsx-desc">Go back Modes</div> </div> <div class="wmsx-full-divider"></div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> G </div> </div> <div class="wmsx-desc">Capture Screen</div> </div> </div> <div class="wmsx-right"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> 0 - 9 </div> </div> <div class="wmsx-desc">Load State</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> 0 - 9 </div> </div> <div class="wmsx-desc">Save State</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> F12 </div> </div> <div class="wmsx-desc">Save State File</div> </div> <div class="wmsx-full-divider"></div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> F12 </div>&nbsp;&nbsp;/&nbsp;&nbsp;<div class="wmsx-key"> Shift </div>&nbsp;+&nbsp;<div class="wmsx-key"> F12 </div> </div> <div class="wmsx-desc">Fast / Slow Speed</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> Shift </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Arrows </div> </div> <div class="wmsx-desc">Adjust Speed</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> P </div> </div> <div class="wmsx-desc">Toggle Pause</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> O </div>&nbsp;/&nbsp;<div class="wmsx-key"> F </div> </div> <div class="wmsx-desc">Next Frame</div> </div> <div class="wmsx-divider"></div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Enter </div> </div> <div class="wmsx-desc">Full Screen</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Arrows </div> </div> <div class="wmsx-desc">Screen Size / Width</div> </div> <div class="wmsx-full-divider"></div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Backspace </div> </div> <div class="wmsx-desc">Defaults</div> </div> </div> </div> <div id="wmsx-media"> <div class="wmsx-top-left"> <div class="wmsx-hotkey wmsx-heading"> Media Commands: </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> F6 </div> </div> <div class="wmsx-desc">Load Drive A / B</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> F7 </div> </div> <div class="wmsx-desc">Load Cartridge 1 / 2</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> F8 </div> </div> <div class="wmsx-desc">Load Hard Drive / Tape</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key"> Ctrl </div>&nbsp;+&nbsp;<div class="wmsx-key"> F11 </div> </div> <div class="wmsx-desc">Open File (autodetect)</div> </div> </div> <div class="wmsx-top-right"> <div class="wmsx-hotkey wmsx-heading"> Modifiers for Media Commands: </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key"> Shift </div> </div> <div class="wmsx-desc">Drive B / Slot 2 / Tape</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key wmsx-key-fixed"> Ctrl </div> </div> <div class="wmsx-desc">Load Empty Media</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key wmsx-key-fixed"> Alt </div> </div> <div class="wmsx-desc">Remove Media</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div> </div> <div class="wmsx-desc">Save Media File</div> </div> <div class="wmsx-hotkey wmsx-clear"> <div class="wmsx-desc"> Right-Drag / Ctrl-Click: No Auto-Reset </div> </div> </div> <div class="wmsx-clear"></div> <div class="wmsx-middle-left"> <div class="wmsx-hotkey"> <div class="wmsx-desc wmsx-heading"> Drag &amp; Drop Files or URLs: </div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key wmsx-key-fixed"> Ctrl </div> </div> <div class="wmsx-desc">&nbsp; Load Image Files and Add Disks to Drive (A, B) Stack (up to 10 Disks) </div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key wmsx-key-fixed"> Alt </div> </div> <div class="wmsx-desc">&nbsp; Add Files or ZIP Contents do Disk </div> </div> </div> <div class="wmsx-middle-right"> <div class="wmsx-hotkey"> <div class="wmsx-command"> + <div class="wmsx-key wmsx-key-fixed"> Ctrl </div> <div class="wmsx-key wmsx-key-fixed"> Alt </div> </div> <div class="wmsx-desc">Don&apos;t expand ZIP Contents </div> </div> </div> <div class="wmsx-full-divider"></div> <div class="wmsx-bottom-left"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Home </div> </div> <div class="wmsx-desc">Rewind Tape</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Pg Up / Dn </div> </div> <div class="wmsx-desc">Seek Tape</div> </div> </div> <div class="wmsx-bottom-right"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> Pg Up / Dn </div> </div> <div class="wmsx-desc">Select Disk (A, B)</div> </div> </div> <div class="wmsx-clear"></div> <div class="wmsx-hotkey wmsx-bottom"> <div class="wmsx-command"> <div class="wmsx-key"> Shift </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Ctrl </div>&nbsp;<div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> F12 </div> </div> <div class="wmsx-desc"> Auto-Run Cassette program at current Tape position </div> </div> </div> <div id="wmsx-inputs"> <div class="wmsx-left"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> C </div> </div> <div class="wmsx-desc">Copy Screen Text</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> H </div> </div> <div class="wmsx-desc">Adjust Turbo Fire speed</div> </div> </div> <div class="wmsx-right"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> V </div> </div> <div class="wmsx-desc">Open Text Paste box</div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> B </div> </div> <div class="wmsx-desc">Open Text Input box</div> </div> </div> <div class="wmsx-bottom"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> L </div> </div> <div class="wmsx-desc">Toggle Host Keyboard Layout</div> </div> <div class="wmsx-right" > <div id="wmsx-inputs-msx-lang" class="wmsx-heading" > MSX Language: English </div> <ul class="wmsx-quick-options-list"> <li><div> </div><div id="wmsx-inputs-keyboard-name" class="wmsx-control"><button class="wmsx-control-dec"></button><span>AUTO</span><button class="wmsx-control-inc"></button></div></li> </ul> </div> <div id="wmsx-keyboard"></div> </div> <div class="wmsx-footer"> (hover mouse pointer over MSX Keyboard keys to display/modify mappings) </div> </div> <div id="wmsx-ports"> <div class="wmsx-left"> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> J </div> </div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> K </div> </div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> M </div> </div> </div> <div class="wmsx-hotkey"> <div class="wmsx-command"> <div class="wmsx-key wmsx-key-fixed"> Alt </div>&nbsp;+&nbsp;<div class="wmsx-key"> H </div> </div> </div> </div> <div class="wmsx-right"> <ul class="wmsx-quick-options-list"> <li><div>Toggle Joysticks mode</div><div id="wmsx-ports-joysticks-mode" class="wmsx-control"><button class="wmsx-control-dec"></button><span>AUTO</span><button class="wmsx-control-inc"></button></div></li> <li><div>Toggle Joykeys mode</div><div id="wmsx-ports-joykeys-mode" class="wmsx-control"><button class="wmsx-control-dec"></button><span>DISABLED</span><button class="wmsx-control-inc"></button></div></li> <li><div>Toggle Mouse mode</div><div id="wmsx-ports-mouse-mode" class="wmsx-control"><button class="wmsx-control-dec"></button><span>AUTO</span><button class="wmsx-control-inc"></button></div></li> <li><div>Adjust Turbo Fire speed</div><div id="wmsx-ports-turbofire-speed" class="wmsx-control"><button class="wmsx-control-dec"></button><span>OFF</span><button class="wmsx-control-inc"></button></div></li> </ul> </div> <div class="wmsx-bottom"> <div class="wmsx-bottom-left"> PORT 1 <div id="wmsx-ports-device1" class="wmsx-none-device"> <div id="wmsx-ports-device1-title" class="wmsx-device-title">NO DEVICE</div> <div class="wmsx-joy"> <div class="wmsx-virtual wmsx-joy-trig wmsx-joy-L"></div> <div class="wmsx-virtual wmsx-joy-trig wmsx-joy-R"></div> <div class="wmsx-joy-middle"></div> <div class="wmsx-joy-logo"></div> <div class="wmsx-joy-outleft"></div> <div class="wmsx-joy-outright"></div> <div class="wmsx-joy-left"> <div class="wmsx-joy-dir wmsx-joy-dirh"></div> <div class="wmsx-joy-dir wmsx-joy-dirv"></div> <div class="wmsx-joy-dir-center"></div> </div> <div class="wmsx-joy-right"> <div class="wmsx-joy-button wmsx-joy-A"></div> <div class="wmsx-joy-button wmsx-joy-B"></div> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-X"></div> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-Y"></div> </div> <div class="wmsx-joy-center"> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-BACK"></div> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-START"></div> </div> <div id="wmsx-joy1-UP" class="wmsx-joy-hs wmsx-joy-hs-UP">&#9650;</div> <div id="wmsx-joy1-DOWN" class="wmsx-joy-hs wmsx-joy-hs-DOWN">&#9660;</div> <div id="wmsx-joy1-LEFT" class="wmsx-joy-hs wmsx-joy-hs-LEFT">&#9668;</div> <div id="wmsx-joy1-RIGHT" class="wmsx-joy-hs wmsx-joy-hs-RIGHT">&#9658;</div> <div id="wmsx-joy1-A" class="wmsx-joy-hs wmsx-joy-hs-A">A</div> <div id="wmsx-joy1-B" class="wmsx-joy-hs wmsx-joy-hs-B">B</div> <div id="wmsx-joy1-X" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-X">X</div> <div id="wmsx-joy1-Y" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-Y">Y</div> <div id="wmsx-joy1-L" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-L">L</div> <div id="wmsx-joy1-R" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-R">R</div> <div id="wmsx-joy1-BACK" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-BACK">BACK</div> <div id="wmsx-joy1-START" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-START">START</div> </div> <div class="wmsx-mouse"> <div id="wmsx-mouse1" class="wmsx-mouse-body"> <div class="wmsx-mouse-button1"></div><div class="wmsx-mouse-button2"></div> <div class="wmsx-mouse-logo"></div> </div> </div> <div class="wmsx-touch"></div> <div class="wmsx-none"></div> </div> </div> <div class="wmsx-bottom-right"> PORT 2 <div id="wmsx-ports-device2" class="wmsx-none-device"> <div id="wmsx-ports-device2-title" class="wmsx-device-title">NO DEVICE</div> <div class="wmsx-joy"> <div class="wmsx-virtual wmsx-joy-trig wmsx-joy-L"> </div> <div class="wmsx-virtual wmsx-joy-trig wmsx-joy-R"> </div> <div class="wmsx-joy-middle"> </div> <div class="wmsx-joy-logo"> </div> <div class="wmsx-joy-outleft"> </div> <div class="wmsx-joy-outright"> </div> <div class="wmsx-joy-left"> <div class="wmsx-joy-dir wmsx-joy-dirh"></div> <div class="wmsx-joy-dir wmsx-joy-dirv"></div> <div class="wmsx-joy-dir-center"></div> </div> <div class="wmsx-joy-right"> <div class="wmsx-joy-button wmsx-joy-A"></div> <div class="wmsx-joy-button wmsx-joy-B"></div> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-X"></div> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-Y"></div> </div> <div class="wmsx-joy-center"> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-BACK"></div> <div class="wmsx-virtual wmsx-joy-button wmsx-joy-START"></div> </div> <div id="wmsx-joy2-UP" class="wmsx-joy-hs wmsx-joy-hs-UP">&#9650;</div> <div id="wmsx-joy2-DOWN" class="wmsx-joy-hs wmsx-joy-hs-DOWN">&#9660;</div> <div id="wmsx-joy2-LEFT" class="wmsx-joy-hs wmsx-joy-hs-LEFT">&#9668;</div> <div id="wmsx-joy2-RIGHT" class="wmsx-joy-hs wmsx-joy-hs-RIGHT">&#9658;</div> <div id="wmsx-joy2-A" class="wmsx-joy-hs wmsx-joy-hs-A">A</div> <div id="wmsx-joy2-B" class="wmsx-joy-hs wmsx-joy-hs-B">B</div> <div id="wmsx-joy2-X" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-X">X</div> <div id="wmsx-joy2-Y" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-Y">Y</div> <div id="wmsx-joy2-L" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-L">L</div> <div id="wmsx-joy2-R" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-R">R</div> <div id="wmsx-joy2-BACK" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-BACK">BACK</div> <div id="wmsx-joy2-START" wmsx-virtual="true" class="wmsx-virtual wmsx-joy-hs wmsx-joy-hs-START">START</div> </div> <div class="wmsx-mouse"> <div id="wmsx-mouse2" class="wmsx-mouse-body"> <div class="wmsx-mouse-button1"></div><div class="wmsx-mouse-button2"></div> <div class="wmsx-mouse-logo"></div> </div> </div> <div class="wmsx-touch"></div> <div class="wmsx-none"></div> </div> </div> </div> <div class="wmsx-footer"> (hover mouse pointer over Controller buttons to display/modify mappings) </div> </div> <div id="wmsx-about"> <div id="wmsx-logo-version"> WebMSX&nbsp;&nbsp;-&nbsp;&nbsp;version&nbsp'+WMSX.VERSION+' </div> <div class="wmsx-info"> '+atob("Q3JlYXRlZCBieSBQYXVsbyBBdWd1c3RvIFBlY2Npbg==")+" <br> "+atob("PGEgdGFyZ2V0PSJfYmxhbmsiIGhyZWY9Imh0dHBzOi8vd2VibXN4Lm9yZyI+aHR0cHM6Ly93ZWJtc3gub3JnPC9hPg==")+' </div> <div id="wmsx-browserinfo"> </div> </div> </div> </div> <div id="wmsx-control-mapping-popup"> <div id="wmsx-control-mapping-popup-heading"> Control mapped to: </div> <div id="wmsx-control-mapping-popup-mapping" class="wmsx-command"></div> <div id="wmsx-control-mapping-popup-footer"> Press new key. <br> (right-click to clear) </div> </div>'
},wmsx.SettingsGUI.css=function(){
return'#wmsx-modal * { outline: none; box-sizing: border-box; } #wmsx-modal { position: absolute; overflow: hidden; width: 600px; height: 0; opacity: 0; visibility: hidden; top: 22px; left: 29px; color: hsl(0, 0%, 10%); font: normal 13px sans-serif; white-space: nowrap; text-align: initial; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); transform: scale(0.85); transition: visibility .2s ease-out, opacity .2s ease-out, transform .2s ease-out, height .25s step-end; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; cursor: auto; z-index: 9; } #wmsx-modal.wmsx-show { transform: scale(1); transition: visibility .2s ease-out, opacity .2s ease-out, transform .2s ease-out; height: 440px; visibility: visible; opacity: 1; } #wmsx-modal .wmsx-heading { font-weight: 700; color: hsl(0, 0%, 30%); } #wmsx-modal .wmsx-link { font-weight: 700; line-height: 21px; color: hsl(228, 90%, 40%); cursor: pointer; } #wmsx-modal .wmsx-link:hover { outline: 1px solid; } .wmsx-command { position: relative; display: inline-block; font-weight: 600; color: hsl(0, 0%, 43%); } .wmsx-hotkey { height: 27px; padding: 3px 5px; box-sizing: border-box; } .wmsx-hotkey .wmsx-desc { display: inline-block; line-height: 21px; } .wmsx-key { position: relative; display: inline-block; top: -1px; min-width: 25px; height: 21px; padding: 4px 6px 3px; box-sizing: border-box; font-weight: 600; font-size: 12px; line-height: 12px; color: hsl(0, 0%, 42%); background: white; border-radius: 3px; border: 1px solid rgb(210, 210, 210); box-shadow: 0 1px 0 1px hsl(0, 0%, 47%); text-align: center; } .wmsx-key-fixed { width: 31px; padding-left: 0; padding-right: 2px; } .wmsx-footer { position: absolute; bottom: 13px; width: 543px; margin-top: 16px; text-align: center; } #wmsx-modal .wmsx-quick-options-list { margin: 1px 0 0; color: inherit; } #wmsx-modal .wmsx-quick-options-list > li { margin: 0; } #wmsx-modal .wmsx-quick-options-list > li > * { height: 25px; line-height: 25px; font-size: inherit; } #wmsx-modal .wmsx-control { width: 180px; font-weight: bold; background: rgb(243, 243, 243); border-radius: 3px; box-shadow: 1px 1px 1px rgba(0, 0, 0, .27) } #wmsx-modal .wmsx-control > button { background: white; border-color: hsl(0, 0%, 80%); } #wmsx-modal .wmsx-control > button::after { top: 6px; } #wmsx-modal .wmsx-control > button.wmsx-control-dec::after { left: 3px; border-right-color: hsl(0, 0%, 55%); } #wmsx-modal .wmsx-control > button.wmsx-control-inc::after { right: 3px; border-left-color: hsl(0, 0%, 55%); } #wmsx-menu { position: relative; background: white; border-bottom: 1px solid hsl(0, 0%, 72%); } #wmsx-menu #wmsx-back { position: absolute; width: 40px; height: 34px; margin: 3px 1px; padding: 16px 12px; cursor: pointer; } #wmsx-menu #wmsx-back:hover { background: rgba(0, 0, 0, .12); } .wmsx-back-arrow { display: block; width: 16px; height: 2px; border-radius: 1000px; background: hsl(0, 0%, 98%); } .wmsx-back-arrow:before { content: ""; display: block; position: absolute; width: 10px; height: 2px; border-radius: inherit; background: inherit; transform: rotate(-45deg); transform-origin: 1px 1px; } .wmsx-back-arrow:after { content: ""; display: block; position: absolute; width: 10px; height: 2px; border-radius: inherit; background: inherit; transform: rotate(45deg); transform-origin: 1px 1px; } #wmsx-menu .wmsx-caption { height: 29px; margin: 0 -1px; padding: 10px 0 0 48px; font-size: 18px; color: white; background: hsl(358, 66%, 50%); box-shadow: 0 1px 3px rgba(0, 0, 0, .9); vertical-align: middle; box-sizing: content-box; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } #wmsx-menu .wmsx-items { position: relative; width: 80%; height: 39px; margin: 0 auto; font-weight: 600; } #wmsx-menu .wmsx-item { float: left; width: 20%; height: 100%; padding-top: 13px; font-size: 14px; color: rgba(0, 0, 0, .43); text-align: center; cursor: pointer; } #wmsx-menu .wmsx-selected { color: hsl(358, 67%, 46%); } #wmsx-menu #wmsx-menu-selection { position: absolute; left: 0; bottom: 0; width: 20%; height: 3px; background: hsl(358, 67%, 46%); transition: left 0.3s ease-in-out; } #wmsx-content { position: relative; left: 0; width: 3000px; height: 362px; background: rgb(218, 218, 218); transition: left 0.3s ease-in-out } #wmsx-general, #wmsx-inputs, #wmsx-media, #wmsx-ports, #wmsx-about { position: absolute; width: 600px; height: 100%; box-sizing: border-box; } #wmsx-general { padding-top: 13px; padding-left: 36px; } #wmsx-general .wmsx-left { float: left; width: 248px; } #wmsx-general .wmsx-left .wmsx-command { width: 105px; } #wmsx-general .wmsx-right { float: left; } #wmsx-general .wmsx-right .wmsx-command { width: 160px; } #wmsx-media { left: 600px; } #wmsx-media { padding-top: 8px; padding-left: 32px; } #wmsx-media .wmsx-top-left { float: left; width: 287px; } #wmsx-media .wmsx-top-right { float: left; height: 154px; } #wmsx-media .wmsx-middle-left { float: left; width: 287px; } #wmsx-media .wmsx-middle-right { float: left; margin-top: 54px; } #wmsx-media .wmsx-bottom-left { float: left; width: 298px; } #wmsx-media .wmsx-bottom-right { float: left; } #wmsx-media .wmsx-top-left .wmsx-command { width: 101px; } #wmsx-media .wmsx-top-right .wmsx-command { width: 96px; } #wmsx-media .wmsx-middle-right .wmsx-command { width: 84px; } #wmsx-media .wmsx-bottom-left .wmsx-command { width: 174px; } #wmsx-media .wmsx-bottom-right .wmsx-command { width: 131px; } #wmsx-media .wmsx-bottom .wmsx-command { width: 174px; } #wmsx-inputs { left: 1200px; padding: 12px 0 0 33px; } #wmsx-inputs .wmsx-left { float: left; width: 290px; } #wmsx-inputs .wmsx-command { width: 85px; } #wmsx-inputs .wmsx-bottom { margin-top: 18px; } #wmsx-inputs .wmsx-bottom .wmsx-hotkey { display: inline-block; width: 280px; margin-bottom: 2px; vertical-align: bottom; } #wmsx-inputs .wmsx-bottom .wmsx-right { display: inline-block; width: 251px; text-align: right; } #wmsx-inputs .wmsx-bottom .wmsx-heading { display: inline-block; width: 180px; margin-bottom: 2px; text-align: center; } #wmsx-inputs #wmsx-inputs-msx-lang { padding: 0 5px 5px 0; } #wmsx-inputs-keyboard-name { color: hsl(228, 90%, 40%); } #wmsx-keyboard { position: relative; top: 2px; width: 535px; height: 174px; padding: 12px 0 0 13px; margin-top: 5px; background: hsl(0, 0%, 25%); border-radius: 1px 1px 0 0; box-sizing: border-box; box-shadow: 0 1px 0 1px hsl(0, 0%, 20%), 0 3px 4px 1px hsl(0, 0%, 40%); } #wmsx-ports { left: 1800px; padding: 13px 0 0 27px; } #wmsx-ports .wmsx-left { float: left; width: 126px; padding-left: 32px; } #wmsx-ports .wmsx-command { width: 91px; } #wmsx-ports .wmsx-hotkey { height: 31px; } #wmsx-ports .wmsx-right { float: left; width: 375px; } #wmsx-ports .wmsx-right .wmsx-quick-options-list > li { margin: 0 0 6px; } #wmsx-ports .wmsx-bottom { width: 546px; text-align: center; clear: both; } #wmsx-ports .wmsx-bottom-left, #wmsx-ports .wmsx-bottom-right { display: inline-block; height: 162px; margin-top: 15px; vertical-align: top; text-align: center; font-size: 14px; line-height: 14px; font-weight: bold; color: hsl(0, 0%, 32%); } #wmsx-ports .wmsx-device-title { margin-top: 11px; height: 12px; font-size: 12px; line-height: 12px; font-weight: bold; color: hsl(0, 0%, 35%); text-align: center; } #wmsx-ports .wmsx-joystick-device .wmsx-joy, #wmsx-ports .wmsx-joykeys-device .wmsx-joy { display: block; } #wmsx-ports .wmsx-mouse-device .wmsx-mouse { display: block; } #wmsx-ports .wmsx-touch-device .wmsx-touch { display: block; } #wmsx-ports .wmsx-none-device .wmsx-none { display: block; } #wmsx-ports-joysticks-mode, #wmsx-ports .wmsx-joystick-device .wmsx-device-title { color: hsl(228, 90%, 40%) } #wmsx-ports-joykeys-mode, #wmsx-ports .wmsx-joykeys-device .wmsx-device-title { color: hsl(0, 90%, 43%); } #wmsx-ports-mouse-mode, #wmsx-ports .wmsx-mouse-device .wmsx-device-title { color: hsl(120, 100%, 30%); } #wmsx-ports-turbofire-speed { color: hsl(0, 0%, 30%); } #wmsx-ports .wmsx-touch-device, #wmsx-ports .wmsx-touch-device .wmsx-device-title { color: hsl(167, 100%, 31%); } #wmsx-ports .wmsx-joykeys-device .wmsx-virtual { opacity: 0.33; } #wmsx-ports .wmsx-joykeys-device .wmsx-joy-button.wmsx-virtual { background: hsl(0, 0%, 75%); box-shadow: 0 3px 0 0 hsl(0, 0%, 60%), 0 3px 0 1px hsl(0, 0%, 40%); } #wmsx-ports .wmsx-joykeys-device .wmsx-joy-hs.wmsx-virtual { display: none; } #wmsx-ports .wmsx-joy { display: none; position: relative; top: 14px; width: 252px; font-weight: bold; text-align: center; vertical-align: top; box-sizing: border-box; } #wmsx-ports-device1 .wmsx-joy { margin-right: 8px; } #wmsx-ports-device2 .wmsx-joy { margin-left: 8px; } .wmsx-joy-logo, .wmsx-mouse-logo { position: absolute; background: url("data:image/png;base64,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"); } .wmsx-joy .wmsx-joy-trig { position: absolute; top: -6px; width: 45px; height: 40px; background: hsl(0, 0%, 68%); border-radius: 5px; box-shadow: inset 1px 1px hsl(0, 0%, 90%), 0 2px 2px 2px hsl(0, 0%, 47%); } .wmsx-joy .wmsx-joy-L { left: 25px; border-top-left-radius: 16px; } .wmsx-joy .wmsx-joy-R { right: 25px; border-top-right-radius: 16px; } .wmsx-joy .wmsx-joy-middle { position: absolute; left: 2px; right: 2px; height: 85px; background: white; background: linear-gradient(hsl(0, 0%, 94%), white, white, hsl(0, 0%, 93%)); border-radius: 50px 50px 40px 40px; box-shadow: 0 5px 0 0     hsl(0, 0%, 78%), 0 1px 2px 1px hsl(0, 0%, 73%), 0 6px 4px 1px hsl(0, 0%, 40%); } .wmsx-joy-logo { top: 17px; left: 103px; width: 46px; height: 14px; } .wmsx-joy .wmsx-joy-outleft, .wmsx-joy .wmsx-joy-outright { position: absolute; width: 100px; height: 97px; background: white; border-radius: 100%; transform-origin: 50px 50px; transform: rotate(6deg); box-shadow: 0 5px 0 -1px      hsl(0, 0%, 78%), 0 6px 0 -1px      hsl(0, 0%, 78%), -1px 8px 2px -2px hsl(0, 0%, 48%), 0 9px 4px -2px    hsl(0, 0%, 36%); } .wmsx-joy .wmsx-joy-outright { right: 0; transform: rotate(-6deg); box-shadow: 0 5px 0 -1px     hsl(0, 0%, 78%), 0 6px 0 -1px     hsl(0, 0%, 78%), 1px 8px 2px -2px hsl(0, 0%, 48%), 0 9px 4px -2px   hsl(0, 0%, 36%); } .wmsx-joy .wmsx-joy-left, .wmsx-joy .wmsx-joy-right { position: absolute; top: 10px; width: 80px; height: 78px; background: hsl(0, 0%, 87%); border: 1px solid hsl(0, 0%, 76%); border-right: none; border-bottom: none; border-radius: 100%; box-sizing: border-box; } .wmsx-joy .wmsx-joy-left { left: 10px; } .wmsx-joy .wmsx-joy-left:before { content: ""; position: absolute; top: 9px; left: 10px; width: 58px; height: 58px; background: hsl(0, 0%, 77%); border-radius: 1000px; box-sizing: border-box; } .wmsx-joy .wmsx-joy-right { right: 10px; } .wmsx-joy .wmsx-joy-right:before { content: ""; position: absolute; top: 20px; right: 16px; width: 27px; height: 57px; background: hsl(0, 0%, 77%); border-radius: 1000px; box-sizing: border-box; transform: rotate(45deg); } .wmsx-joy .wmsx-joy-dir { position: absolute; color: hsl(0, 0%, 95%); background: hsl(0, 0%, 49%); border: 1px solid hsl(0, 0%, 64%); border-right-color: hsl(0, 0%, 42%); border-bottom-color: hsl(0, 0%, 35%); border-radius: 2px 2px 0 0; box-shadow:  0 3px 1px hsl(0, 0%, 40%), 0 3px 0 1px hsl(0, 0%, 15%); box-sizing: border-box; } .wmsx-joy .wmsx-joy-dirh { top: 28px; left: 16px; width: 46px; height: 14px; } .wmsx-joy .wmsx-joy-dirv { top: 12px; left: 32px; width: 14px; height: 45px; } .wmsx-joy .wmsx-joy-dir-center { position: absolute; top: 29px; left: 30px; width: 18px; height: 12px; background: hsl(0, 0%, 49%); } .wmsx-joy .wmsx-joy-dir-center:after { content: ""; position: absolute; top: 2px; left: 4px; height: 8px; width: 8px; border-radius: 1000px; box-shadow: inset 0 0 6px hsl(0, 0%, 36%), inset 1px 1px 2px -1px hsl(0, 0%, 36%), 1px 1px 0 hsl(0, 0%, 65%); } .wmsx-joy-button { position: relative; display: inline-block; top: -1px; min-width: 19px; height: 19px; margin: 0 1px; font-size: 12px; line-height: 14px; padding-top: 3px; color: hsl(0, 0%, 97%); background: hsl(0, 00%, 54%); border-radius: 100%; box-shadow: inset 0 2px 1px rgba(0, 0, 0, 0.1), 0 3px 0 0 hsl(0, 0%, 40%), 0 3px 0 1px hsl(0, 0%, 15%); box-sizing: border-box; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } .wmsx-joy-button.wmsx-square { top: -2px; min-width: 18px; height: 18px; font-size: 11px; border-radius: 1px 1px 0 0; padding: 2px 5px 0; box-shadow: inset 1px 1px hsl(0, 0%, 64%), inset -1px -1px hsl(0, 0%, 35%), 0 3px 0 0 hsl(0, 0%, 40%), 0 3px 0 1px hsl(0, 0%, 15%); } .wmsx-joy .wmsx-joy-A { position: absolute; top: 46px; left: 29px; background: hsl(132, 90%, 41%); box-shadow: inset 0 2px 1px rgba(0, 0, 0, 0.1), 0 3px 0 0 hsl(127, 90%, 30%), 0 3px 0 1px hsl(0, 0%, 15%); } .wmsx-joy .wmsx-joy-B { position: absolute; top: 26px; left: 49px; background: hsl(0, 94%, 63%); box-shadow: inset 0 2px 1px rgba(0, 0, 0, 0.1), 0 3px 0 0 hsl(0, 90%, 43%), 0 3px 0 1px hsl(0, 0%, 15%); } .wmsx-joy .wmsx-joy-X { position: absolute; top: 26px; left: 9px; background: hsl(234, 80%, 66%); box-shadow: inset 0 2px 1px rgba(0, 0, 0, 0.1), 0 3px 0 0 hsl(234, 80%, 47%), 0 3px 0 1px hsl(0, 0%, 15%); } .wmsx-joy .wmsx-joy-Y { position: absolute; top: 6px; left: 29px; background: hsl(58, 100%, 44%); box-shadow: inset 0 2px 1px rgba(0, 0, 0, 0.06), 0 3px 0 0 hsl(56, 100%, 33%), 0 3px 0 1px hsl(0, 0%, 15%); } .wmsx-joy .wmsx-joy-center .wmsx-joy-button { position: absolute; top: 43px; width: 18px; height: 09px; color: hsl(0, 0%, 58%); border-radius: 1000px; background: hsl(0, 0%, 82%); box-shadow: inset 0 1px 1px hsl(0, 0%, 70%), 0 2px 0 0 hsl(0, 0%, 62%), 0 2px 0 1px hsl(0, 0%, 30%); } .wmsx-joy .wmsx-joy-center .wmsx-joy-BACK { left: 103px; border-top-right-radius: 1px; border-bottom-right-radius: 1px; } .wmsx-joy .wmsx-joy-center .wmsx-joy-START { right: 103px; border-top-left-radius: 1px; border-bottom-left-radius: 1px; } .wmsx-joy-hs { position: absolute; border: 1px solid transparent; border-radius: 1000px; box-sizing: border-box; cursor: pointer; } .wmsx-joy-hs.wmsx-joy-hs-unmapped { color: rgb(30, 30, 30); -webkit-font-smoothing: initial; -moz-osx-font-smoothing: initial; } .wmsx-joy-hs-UP, .wmsx-joy-hs-DOWN, .wmsx-joy-hs-LEFT, .wmsx-joy-hs-RIGHT { width: 26px; height: 25px; padding-top: 6px; font-size: 10px; line-height: 10px; color: hsl(0, 0%, 95%); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } .wmsx-joy-hs-UP { top: 18px; left: 37px; padding-top: 7px; } .wmsx-joy-hs-DOWN { top: 51px; left: 37px; padding-top: 4px; } .wmsx-joy-hs-LEFT { top: 34px; left: 21px; } .wmsx-joy-hs-RIGHT { top: 34px; left: 53px; } .wmsx-joy-hs-A, .wmsx-joy-hs-B, .wmsx-joy-hs-X, .wmsx-joy-hs-Y { width: 21px; height: 23px; font-size: 12px; line-height: 18px; color: hsl(0, 0%, 99%); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } .wmsx-joy-hs-A { top: 57px; right: 39px; } .wmsx-joy-hs-B { top: 37px; right: 19px; } .wmsx-joy-hs-X { top: 37px; right: 59px; } .wmsx-joy-hs-Y { top: 17px; right: 39px; } .wmsx-joy-hs-L, .wmsx-joy-hs-R { width: 54px; height: 25px; top: -20px; color: hsl(0, 0%, 52%); font-size: 12px; line-height: 12px; border-radius: 0; } .wmsx-joy-hs-L { left: 21px; } .wmsx-joy-hs-R { right: 22px; } .wmsx-joy-hs-BACK, .wmsx-joy-hs-START { width: 26px; height: 29px; top: 39px; padding-top: 18px; font-size: 7px; font-weight: normal; line-height: 11px; color: hsl(0, 0%, 54%); border-radius: 0; } .wmsx-joy-hs-BACK { left: 99px; } .wmsx-joy-hs-START { right: 99px; } #wmsx-ports .wmsx-mouse { display: none; position: relative; width: 230px; } #wmsx-ports .wmsx-mouse-body { position: relative; top: 6px; left: -8px; overflow: visible; white-space: nowrap; width: 59px; height: 75px; margin: 14px auto; background: linear-gradient(166deg, white, white, white, white, hsl(0, 0%, 97%), hsl(0, 0%, 90%)); border: 1px solid hsl(0, 0%, 81%); border-right-color: hsl(0, 0%, 76%); border-radius: 10px 8px 25px 32px; box-sizing: border-box; transform: skew(-47deg, 30deg); box-shadow: /* inset 0px 0px 1px 0      hsl(0, 0%, 45% */ 3px 2px 0   -1px hsl(0, 0%, 70%) ,4px 3px 0   -1px hsl(0, 0%, 60%)       /* line */ ,6px 4px 0   -2px hsl(0, 0%, 82%)       /* line */ ,5px 0   0   -4px hsl(0, 0%, 70%) ,6px 0   0   -4px hsl(0, 0%, 70%) ,7px 1px 0   -4px hsl(0, 0%, 70%) ,8px 2px 0   -4px hsl(0, 0%, 70%) ,9px 3px 0   -4px hsl(0, 0%, 70%) ,10px 4px 0  -4px hsl(0, 0%, 70%) ,11px 5px 0  -4px hsl(0, 0%, 70%) ,12px 6px 0  -4px hsl(0, 0%, 70%) ,13px 7px 0  -4px hsl(0, 0%, 70%) ,14px 8px 0  -4px hsl(0, 0%, 70%) ,17px 8px 0  -6px hsl(0, 0%, 70%) ,18px 11px 0 -6px hsl(0, 0%, 70%) ,2px 6px 0   -4px hsl(0, 0%, 70%)       /* bottom correction */ ,4px 7px 0   -4px hsl(0, 0%, 70%)       /* bottom correction */ ,8px 9px 0   -4px hsl(0, 0%, 70%)       /* bottom correction */ ,10px 09px 0 -4px hsl(0, 0%, 70%)       /* bottom correction */ ,12px 10px 0 -4px hsl(0, 0%, 70%)       /* bottom correction */ ,14px 10px 0 -4px hsl(0, 0%, 70%)       /* bottom correction */ ,19px 11px 4px -6px hsl(0, 0%, 3%)      /* shadow */ ,13px 12px 4px -6px hsl(0, 0%, 3%)      /* shadow */ ; } #wmsx-ports .wmsx-mouse-button1, #wmsx-ports .wmsx-mouse-button2 { position: absolute; height: 25px; background: transparent; border: 0 solid hsl(0, 0%, 70%); box-sizing: border-box; } #wmsx-ports .wmsx-mouse-button1 { width: 48%; border-right-width: 1px; } #wmsx-ports .wmsx-mouse-button2 { width: 101%; border-bottom-width: 1px; } .wmsx-mouse-logo { top: 29px; left: 14px; width: 24px; height: 7px; background-size: 100%; } #wmsx-ports .wmsx-none { display: none; width: 104px; height: 106px; margin: 12px 63px 0; border: 12px solid hsl(0, 0%, 72%); border-radius: 100%; box-sizing: border-box; } #wmsx-ports .wmsx-none:after { content: ""; display: block; position: relative; top: 50%; left: -6px; width: 92px; height: 12px; background: hsl(0, 0%, 72%); transform: translateY(-50%) rotate(-45deg); } #wmsx-ports .wmsx-touch { display: none; width: 68px; height: 107px; margin: 8px 81px 0; background: white; border: 1px solid hsl(0, 0%, 90%); border-radius: 8px; box-sizing: border-box; box-shadow: 0 0 0 1px hsl(0, 0%, 70%), 1px 1px 0 1px hsl(0, 0%, 40%), 2px 3px 4px hsl(0, 0%, 26%); } #wmsx-ports .wmsx-touch:before { content: ""; display: block; position: relative; width: 58px; height: 77px; margin: 13px auto 4px; background: hsl(0, 0%, 35%); } #wmsx-ports .wmsx-touch:after { content: ""; position: relative; display: block; width: 6px; height: 6px; left: 29px; border: 1px solid hsl(0, 0%, 60%); background: hsl(0, 0%, 95%); border-radius: 100%; } #wmsx-about { left: 2400px; font-size: 18px; } #wmsx-about #wmsx-logo-version { width: 380px; height: 212px; margin: 36px auto 24px; color: hsl(0, 0%, 98%); padding-top: 170px; box-sizing: border-box; text-align: center; background: black url("'+wmsx.Images.urls.logo+'") center 50px no-repeat; background-size: 334px 100px; box-shadow: 3px 3px 14px rgb(75, 75, 75); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } #wmsx-about .wmsx-info { line-height: 30px; text-align: center; } #wmsx-about a { color: rgb(0, 40, 200); text-decoration: none; } #wmsx-about a:hover { text-decoration: underline; } #wmsx-about #wmsx-browserinfo { position: absolute; left: 0; right: 0; bottom: 7px; font-size: 10px; text-align: center; color: transparent; } #wmsx-control-mapping-popup { display: none; position: fixed; padding: 4px 9px; font: normal 13px sans-serif; line-height: 19px; text-align: center; vertical-align: top; border-radius: 6px; border: 8px white solid; background: rgb(220, 220, 220); box-shadow: 0 3px 3px 2px rgba(0, 0, 0, .55); box-sizing: border-box; z-index: 10; } #wmsx-control-mapping-popup.wmsx-locked { border-color: hsl(60, 100%, 68%); } #wmsx-control-mapping-popup .wmsx-command { width: auto; line-height: 21px; margin: 10px 0; font-weight: bold; } #wmsx-control-mapping-popup:after { content: ""; position: absolute; bottom: 0; left: 0; right: 0; width: 0; margin: 0 auto; border-width: 10px; border-style: solid; border-color: transparent white white transparent; box-shadow: 4px 4px 2px 0 rgba(0, 0, 0, .55); box-sizing: border-box; transform: translateY(16px) rotate(45deg); } #wmsx-control-mapping-popup.wmsx-locked:after { border-color: transparent hsl(60, 100%, 68%) hsl(60, 100%, 68%) transparent; } .wmsx-clear { clear: both; } .wmsx-divider { clear: both; height: 27px; } .wmsx-full-divider { clear: both; height: 21px; } #wmsx-general .wmsx-full-divider { clear: both; height: 18px; }'
},wmsx.ControlMappingPopup=function(){"use strict";function a(){j=document.getElementById("wmsx-control-mapping-popup"),k=document.getElementById("wmsx-control-mapping-popup-heading"),l=document.getElementById("wmsx-control-mapping-popup-mapping"),m=document.getElementById("wmsx-control-mapping-popup-footer"),j.tabIndex=-1,j.addEventListener("mousedown",b),j.addEventListener("keydown",c),j.addEventListener("keyup",d)}function b(a){wmsx.Util.blockEvent(a),3===a.which&&r.clearControlEditing()}function c(a){if(s){var b=o.codeNewForKeyboardEvent(a);if(n||b!==o.VK_ESCAPE.wc)return o.isModifierKey(a)?t=o.codeNewForKeyboardEvent(a):f(a),a.stopPropagation(),a.preventDefault(),!1}}function d(a){if(s){var b=o.codeNewForKeyboardEvent(a);return t===b&&f(a),a.stopPropagation(),a.preventDefault(),!1}}function e(){if(!r)return void(j.style.display="none");j.style.display="block",window.setTimeout(function(){j.focus()},0);var a=r.getMappingForControl(s,i)||[];l.innerHTML=h(a);var b=j.getBoundingClientRect(),c=p-b.width/2|0,d=q-b.height-u|0;j.style.top=d+"px",j.style.left=c+"px"}function f(a){var b=o.nameForKeyboardEvent(a);if(b){var c={wc:o.codeNewForKeyboardEvent(a),n:b};r.customizeControl(s,i,c),t=null,e()}}function g(a){r.customizeControl(s,i,a),e()}function h(a){if(a.constructor===String)return a;if(a.constructor===Object)return h(a.from)+"&nbsp;&nbsp;=>&nbsp;&nbsp;"+h(a.to);if(!a||0===a.length)return"- none -";for(var b="",c=0;c<a.length;c++){var d,e=a[c];if(e.constructor===String)d=e;else{c>0&&(b+="&nbsp;,&nbsp;");var f=e.n&&e.n.constructor===Array?e.n:[e.n];d="";for(var g=0,i=f.length;g<i;++g){var j=e.wc?"wmsx-key":e.n.length>1?"wmsx-joy-button wmsx-square":"wmsx-joy-button";g>0&&(d+=g===i-1?"&nbsp;+&nbsp;":"&nbsp;"),d+='<DIV class = "'+j+'">'+f[g]+"</DIV>"}}b+=d}return b}this.show=function(a,b,c,d,f,g,h,l){p=d,q=f,r=a,s=b,i=c,t=null,k.innerHTML=g,m.innerHTML=h,n=!!l,j.classList.toggle("wmsx-locked",n),e()},this.hide=function(){p=q=0,r=s=i=null,e()},this.joystickButtonDetected=function(a,b){b===i&&g(a)};var i,j,k,l,m,n,o=wmsx.DOMKeys,p=0,q=0,r=null,s=null,t=null,u=14;!function(){a()}()},wmsx.ControlMappingPopup.get=function(){"use strict";return wmsx.ControlMappingPopup.instance||(wmsx.ControlMappingPopup.instance=new wmsx.ControlMappingPopup),wmsx.ControlMappingPopup.instance},wmsx.ControlMappingPopup.instance=null,wmsx.KeyboardConfigurator=function(a,b,c){"use strict";function d(){n=document.getElementById("wmsx-inputs-msx-lang"),m=document.getElementById("wmsx-inputs-keyboard-name"),m.wmsxText=m.querySelector(":scope > span"),m.querySelector(":scope > button").wmsxDec=!0,wmsx.Util.onTapOrMouseDownWithBlock(m,function(b){"BUTTON"===b.target.tagName&&a.toggleKeyboardLayout(b.target.wmsxDec)}),b.addEventListener("mousedown",e,!0),k=document.getElementById("wmsx-keyboard"),l=wmsx.VirtualKeyboard.create(k,function(a){a.wmsxKey&&p.push(a),a.addEventListener("mouseenter",f),a.addEventListener("mouseleave",g)},!1,t,u,!0)}function e(a){var b=a.target.wmsxKey;b?r===b?1===a.which?s=!s:3===a.which&&o.clearKey(r):(q=a.target,r=q.wmsxKey,s=1===a.which):(s=!1,g()),j.refresh(),h()}function f(a){s||(a.target.wmsxKey?(q=a.target,r=q.wmsxKey,h()):g())}function g(){s||(q=r=null,h())}function h(){if(!r)return v.hide(),void b.focus();var a=q.getBoundingClientRect(),c=a.left+a.width/2,d=a.top;v.show(j,r,0,c,d,w,x,s)}function i(){for(var a=0;a<p.length;++a){var b=o.getKeyMapping(p[a].wmsxKey);p[a].classList.toggle("wmsx-keyboard-key-unmapped",!b||0===b.length)}}var j=this;this.keyboardSettingsStateUpdate=function(){this.refresh()},this.refresh=function(){n.textContent="MSX Language: "+("ja"===t?"Japanese":"English"),m.wmsxText.textContent=o.getCurrentKeyboardDesc(),i()},this.refreshLang=function(){var a=c.getMachineLang(),b=c.getCodeKeyLabel();a===t&&b===u||(t=a,u=b,wmsx.VirtualKeyboard.updateKeysLabels(l,!1,t,u,!0))},this.getMappingForControl=function(a){return o.getKeyMapping(r)||[]},this.customizeControl=function(a,b,c){o.customizeKey(a,c),j.refresh(),h()},this.cancelKeyEditing=function(){s=!1,g()},this.clearControlEditing=function(){r&&(o.clearKey(r),j.refresh(),h())};var k,l,m,n,o=a.getKeyboard(),p=[],q=null,r=null,s=!1,t="en",u="CODE",v=wmsx.ControlMappingPopup.get(),w="Key mapped to host keys:",x="Press new key.<br>(click to lock, right-click to clear)";!function(){t=c.getMachineLang(),d()}()},wmsx.PortsConfigurator=function(a,b,c){"use strict";function d(){function a(a){"BUTTON"===a.target.tagName&&b.processControlActivated(a.currentTarget.wmsxControl,!1,a.target.wmsxDec)}l=document.getElementById("wmsx-ports-joysticks-mode"),l.wmsxControl=wmsx.PeripheralControls.JOYSTICKS_TOGGLE_MODE,l.wmsxText=l.querySelector(":scope > span"),l.querySelector(":scope > button").wmsxDec=!0,m=document.getElementById("wmsx-ports-joykeys-mode"),m.wmsxControl=wmsx.PeripheralControls.JOYKEYS_TOGGLE_MODE,m.wmsxText=m.querySelector(":scope > span"),m.querySelector(":scope > button").wmsxDec=!0,k=document.getElementById("wmsx-ports-mouse-mode"),k.wmsxControl=wmsx.PeripheralControls.MOUSE_TOGGLE_MODE,k.wmsxText=k.querySelector(":scope > span"),k.querySelector(":scope > button").wmsxDec=!0,n=document.getElementById("wmsx-ports-turbofire-speed"),n.wmsxControl=wmsx.PeripheralControls.TURBO_FIRE_TOGGLE,n.wmsxText=n.querySelector(":scope > span"),n.querySelector(":scope > button").wmsxDec=!0,wmsx.Util.onTapOrMouseDownWithBlock(l,a),wmsx.Util.onTapOrMouseDownWithBlock(m,a),wmsx.Util.onTapOrMouseDownWithBlock(k,a),wmsx.Util.onTapOrMouseDownWithBlock(n,a);for(var c=1;c<=2;++c){var d=c-1;o[d]=document.getElementById("wmsx-ports-device"+c),p[d]=document.getElementById("wmsx-ports-device"+c+"-title");for(var f in wmsx.JoystickButtons){var g=document.getElementById("wmsx-joy"+c+"-"+wmsx.JoystickButtons[f].n);g&&(g.wmsxButton=f,g.wmsxPort=d,e(g),q.push(g))}o[d].addEventListener("mousedown",h);var i=document.getElementById("wmsx-mouse"+c);i.wmsxButton="MOUSE",i.wmsxPort=d,e(i)}}function e(a){a.addEventListener("mouseenter",f),a.addEventListener("mouseleave",g)}function f(a){a.target.wmsxButton?(r=a.target,s=r.wmsxButton,t=r.wmsxPort,i()):g()}function g(){r=s=t=null,i()}function h(b){s&&3===b.which&&a.clearControl(s,t),j.refresh(),i()}function i(){if(!s)return u.hide(),a.mappingPopupVisibility(u,t,!1),void c.focus();var b=r.getBoundingClientRect(),d=b.left+b.width/2,e=b.top,f=a.getMappingPopupText(s,t);u.show(j,s,t,d,e,f.heading,f.footer),a.mappingPopupVisibility(u,t,!0)}var j=this;this.controllersSettingsStateUpdate=function(){this.refresh()},this.refresh=function(){var b=a.getSettingsState();l.wmsxText.textContent=b.joysticksModeDesc,m.wmsxText.textContent=b.joykeysModeDesc,k.wmsxText.textContent=b.mouseModeDesc,n.wmsxText.textContent=b.turboFireSpeedDesc;for(var c=0;c<2;++c){var d=b.ports[c],e=o[c].classList;e.remove.apply(e,v),d.startsWith(wmsx.ControllersHub.MOUSE)?e.add("wmsx-mouse-device"):d.startsWith(wmsx.ControllersHub.JOY_ANY)?e.add(d.startsWith(wmsx.ControllersHub.JOYSTICK)?"wmsx-joystick-device":"wmsx-joykeys-device"):d.startsWith(wmsx.ControllersHub.TOUCH)?e.add("wmsx-touch-device"):e.add("wmsx-none-device"),p[c].innerHTML=d}for(var f=0;f<q.length;++f){var g=q[f],h=this.getMappingForControl(g.wmsxButton,g.wmsxPort);!h||h.constructor===Array&&0===h.length||h.constructor===Object&&(0===h.from.length||0===h.to.length)?g.classList.add("wmsx-joy-hs-unmapped"):g.classList.remove("wmsx-joy-hs-unmapped")}},this.getMappingForControl=function(b,c){return a.getMappingForControl(b,c)},this.customizeControl=function(b,c,d){a.customizeControl(b,c,d),this.refresh()},this.clearControlEditing=function(){s&&(a.clearControl(s,t),j.refresh(),i())};var k,l,m,n,o=[],p=[],q=[],r=null,s=null,t=null,u=wmsx.ControlMappingPopup.get(),v=["wmsx-none-device","wmsx-mouse-device","wmsx-joystick-device","wmsx-joykeys-device","wmsx-touch-device"];!function(){d()}()},wmsx.SettingsDialog=function(a,b,c,d){"use strict";function e(){
wmsx.Util.insertCSS(wmsx.SettingsGUI.css()),a.insertAdjacentHTML("beforeend",wmsx.SettingsGUI.html()),m=document.getElementById("wmsx-modal"),delete wmsx.SettingsGUI.html,delete wmsx.SettingsGUI.css,delete wmsx.SettingsGUI,f(),g()}function f(){function a(b,c){c(b);for(var d=b.childNodes,e=0;e<d.length;e++)a(d[e],c)}a(m,function(a){a.id&&(l[a.id]=a)})}function g(){wmsx.Util.onTapOrMouseDownWithBlock(m,function(){m.focus()}),wmsx.Util.onTapOrMouseDownWithBlock(l["wmsx-back"],l.hide),m.addEventListener("keydown",function(a){k(a,!0)}),m.addEventListener("keyup",function(a){k(a,!1)}),wmsx.Util.onTapOrMouseDownWithBlock(l["wmsx-menu-general"],function(){l.setPage("GENERAL")}),wmsx.Util.onTapOrMouseDownWithBlock(l["wmsx-menu-inputs"],function(){l.setPage("INPUTS")}),wmsx.Util.onTapOrMouseDownWithBlock(l["wmsx-menu-ports"],function(){l.setPage("PORTS")}),wmsx.Util.onTapOrMouseDownWithBlock(l["wmsx-menu-media"],function(){l.setPage("MEDIA")}),wmsx.Util.onTapOrMouseDownWithBlock(l["wmsx-menu-about"],function(){l.setPage("ABOUT")})}function h(){l["wmsx-browserinfo"].innerHTML=navigator.userAgent}function i(){n||(n=new wmsx.KeyboardConfigurator(b,m,d)),n.refreshLang(),n.refresh()}function j(){o||(o=new wmsx.PortsConfigurator(b,c,m)),o.refresh()}function k(a,b){var c=r.codeNewForKeyboardEvent(a);if(b&&c===s)return l.hide(),wmsx.Util.blockEvent(a)}var l=this;this.show=function(a){if(!m)return e(),void setTimeout(function(){l.show(a)},0);this.position()&&(this.setPage(a||p),m.classList.add("wmsx-show"),m.classList.add("wmsx-show"),q=!0,setTimeout(function(){m.focus()},50))},this.hide=function(){q&&(n&&n.cancelKeyEditing(),l.hideLesser(),WMSX.room.screen.focus())},this.hideLesser=function(){WMSX.userPreferences.save(),m.classList.remove("wmsx-show"),m.classList.remove("wmsx-show"),q=!1},this.setPage=function(a){n&&n.cancelKeyEditing(),p=a;var b={GENERAL:"0",MEDIA:"-600px",INPUTS:"-1200px",PORTS:"-1800px",ABOUT:"-2400px"}[p],c={GENERAL:"0",MEDIA:"20%",INPUTS:"40%",PORTS:"60%",ABOUT:"80%"}[p];switch(b&&(l["wmsx-content"].style.left=b),c&&(l["wmsx-menu-selection"].style.left=c),l["wmsx-menu-general"].classList.toggle("wmsx-selected","GENERAL"===p),l["wmsx-menu-media"].classList.toggle("wmsx-selected","MEDIA"===p),l["wmsx-menu-inputs"].classList.toggle("wmsx-selected","INPUTS"===p),l["wmsx-menu-ports"].classList.toggle("wmsx-selected","PORTS"===p),l["wmsx-menu-about"].classList.toggle("wmsx-selected","ABOUT"===p),p){case"ABOUT":h();break;case"INPUTS":i();break;case"PORTS":j()}},this.isVisible=function(){return q},this.position=function(){var b=a.clientWidth,c=a.clientHeight;return b<537||c<434?(this.hide(),!1):(b<600&&(b-=2),WMSX.SCREEN_CONTROL_BAR&&c>=440+wmsx.ScreenGUI.BAR_HEIGHT&&(c-=wmsx.ScreenGUI.BAR_HEIGHT+3),m.style.top=((c-440)/2|0)+"px",m.style.left=((b-600)/2|0)+"px",!0)},this.keyboardSettingsStateUpdate=function(){q&&n&&n.keyboardSettingsStateUpdate()},this.controllersSettingsStateUpdate=function(){q&&o&&o.controllersSettingsStateUpdate()};var m,n,o,p="GENERAL",q=!1,r=wmsx.DOMKeys,s=r.VK_ESCAPE.wc},wmsx.PasteDialog=function(a,b,c){"use strict";var d=this;this.toggle=function(){e&&"visible"===e.style.visibility?this.hide():this.show()},this.show=function(){if(!e)return g(),void d.show();setTimeout(function(){e.classList.add("wmsx-show"),f.focus(),i=!0},0)},this.hide=function(){i&&(e.classList.remove("wmsx-show"),i=!1,b.focus())};var e,f,g=function(){e=document.createElement("div"),e.id="wmsx-paste-cover",a.appendChild(e),f=document.createElement("input"),f.id="wmsx-paste-box",f.value="📋   PASTE NOW",f.readOnly="readonly",f.innerHTML="PASTE NOW!",e.appendChild(f),h()},h=function(){wmsx.Util.onTapOrMouseDownWithBlock(e,function(){f.focus()}),e.addEventListener("keydown",function(a){a.stopPropagation();var b=j.codeNewForKeyboardEvent(a);if(b===l||b===m||b===n)return a.preventDefault(),void d.hide();k.indexOf(b)<0&&a.preventDefault()}),f.addEventListener("paste",function(a){if(i&&a.clipboardData&&a.clipboardData.getData){var b=a.clipboardData.getData("text/plain");b&&(d.hide(),c.processControlState(wmsx.MachineControls.TYPE_STRING,!0,!1,b))}})},i=!1,j=wmsx.DOMKeys,k=[j.VK_V.wc|j.CONTROL,j.VK_INSERT.wc|j.SHIFT,j.VK_NUM_0.wc|j.SHIFT],l=j.VK_ESCAPE.wc,m=j.VK_V.wc|j.ALT,n=j.VK_INSERT.wc|j.ALT},wmsx.TextEntryDialog=function(a,b,c){"use strict";function d(){g=document.createElement("div"),g.id="wmsx-text-entry-dialog",g.tabIndex=-1,i=document.createElement("textarea"),i.id="wmsx-text-entry-input",i.spellcheck=!1,i.autocorrect=!1,i.autocapitalize=!1,g.appendChild(i),h=document.createElement("div"),h.id="wmsx-text-entry-dialog-bar",g.appendChild(h),j=document.createElement("div"),j.id="wmsx-text-entry-dialog-ok",h.appendChild(j),k=document.createElement("div"),k.id="wmsx-text-entry-dialog-cancel",h.appendChild(k),a.appendChild(g),e()}function e(){wmsx.Util.onTapOrMouseDownWithBlock(g,function(a){a.target===j||a.target===k?(wmsx.ControllersHub.hapticFeedbackOnTouch(a),f.hide(a.target===j)):g.focus()}),g.addEventListener("keydown",function(a){a.stopPropagation();var b=m.codeNewForKeyboardEvent(a);b===p&&(a.preventDefault(),f.hide(!0)),b!==n&&b!==o||(a.preventDefault(),f.hide(!1))}),i.addEventListener("contextmenu",function(a){a.stopPropagation()}),wmsx.Util.addEventsListener(i,"touchstart touchmove touchend mousedown mousemove mouseup",function(a){a.stopPropagation()})}var f=this;this.toggle=function(){l?this.hide(!1):this.show()},this.show=function(){if(!g)return d(),setTimeout(f.show,0);g.classList.add("wmsx-show"),l=!0,i.focus()},this.hide=function(a){l&&(g.classList.remove("wmsx-show"),l=!1,WMSX.room.screen.focus(),a&&c.processControlState(wmsx.MachineControls.TYPE_STRING,!0,!1,i.value))};var g,h,i,j,k,l=!1,m=wmsx.DOMKeys,n=m.VK_ESCAPE.wc,o=m.VK_B.wc|m.ALT,p=m.VK_ENTER.wc|m.CONTROL},wmsx.SaveStateDialog=function(a,b,c,d){"use strict";function e(){k.classList.toggle("wmsx-load",!o),n.textContent="Select Slot to "+(o?"Save":"Load");for(var a=o?"Save to ":"Load from ",b=0;b<q.length;++b){var c=q[b];c.innerHTML=a+v[b].d,c.classList.toggle("wmsx-selected",b===p),c.classList.toggle("wmsx-toggle-checked",d.isSlotUsed(b+1))}f(),g()}function f(){for(var a=0;a<q.length;++a)q[a].classList.toggle("wmsx-selected",a===p)}function g(){m.textContent=s?"YES":"NO",m.classList.toggle("wmsx-selected",s)}function h(){k=document.createElement("div"),k.id="wmsx-savestate",k.classList.add("wmsx-select-dialog"),k.tabIndex=-1,n=document.createTextNode("Select Slot"),k.appendChild(n),l=document.createElement("ul"),l.style.width="80%";for(var b=0;b<v.length;++b){var c=document.createElement("li");c.classList.add("wmsx-visible"),b<v.length-1&&c.classList.add("wmsx-toggle"),c.style.textAlign="center",c.innerHTML=v[b].d,c.wmsxSlot=b,c.wmsxNeedsUIG=!0,q.push(c),l.appendChild(c)}k.appendChild(l);var d=document.createElement("div"),e=document.createElement("ul");e.classList.add("wmsx-quick-options-list"),c=document.createElement("li");var f=document.createElement("div");f.innerHTML="&#128190;&nbsp; Sync time to Host",c.appendChild(f),m=document.createElement("div"),m.innerHTML="NO",m.classList.add("wmsx-control"),c.appendChild(m),e.appendChild(c),d.appendChild(e),k.appendChild(d),i(),a.appendChild(k)}function i(){function a(){j.hide(!1)}function b(){j.hide(!0)}wmsx.Util.onTapOrMouseDownWithBlock(k,function(){k.focus()}),wmsx.Util.onTapOrMouseDownWithBlockUIG(k,function(a,c){a.target.wmsxSlot>=0&&(c&&wmsx.ControllersHub.hapticFeedbackOnTouch(a),p=a.target.wmsxSlot,f(),c||setTimeout(b,120))}),wmsx.Util.onTapOrMouseDownWithBlock(m,function(a){wmsx.ControllersHub.hapticFeedbackOnTouch(a),s=!s,g(),WMSX.userPreferences.current.syncTimeLoadState=s,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save()}),k.addEventListener("keydown",function(c){var d=w.codeNewForKeyboardEvent(c);return d===x?a():y.indexOf(d)>=0?b():z[d]&&(p+=z[d],p<0?p=0:p>10&&(p=10),f()),wmsx.Util.blockEvent(c)})}var j=this
;this.show=function(b){if(!k)return h(),setTimeout(function(){j.show(b)},0);o=b,r=!0,s=WMSX.userPreferences.current.syncTimeLoadState,e(),k.classList.add("wmsx-show"),k.focus(),wmsx.Util.scaleToFitParentHeight(k,a,wmsx.ScreenGUI.BAR_HEIGHT)},this.hide=function(a){if(r&&(k.classList.remove("wmsx-show"),r=!1,WMSX.room.screen.focus(),a)){var d=v[p],e=o?d.save:d.load;d.peripheral?c.processControlActivated(e):b.processControlState(e,!0)}};var k,l,m,n,o=!1,p=0,q=[],r=!1,s=!1,t=wmsx.MachineControls,u=wmsx.PeripheralControls,v=[{d:"Slot 1",load:t.LOAD_STATE_1,save:t.SAVE_STATE_1},{d:"Slot 2",load:t.LOAD_STATE_2,save:t.SAVE_STATE_2},{d:"Slot 3",load:t.LOAD_STATE_3,save:t.SAVE_STATE_3},{d:"Slot 4",load:t.LOAD_STATE_4,save:t.SAVE_STATE_4},{d:"Slot 5",load:t.LOAD_STATE_5,save:t.SAVE_STATE_5},{d:"Slot 6",load:t.LOAD_STATE_6,save:t.SAVE_STATE_6},{d:"Slot 7",load:t.LOAD_STATE_7,save:t.SAVE_STATE_7},{d:"Slot 8",load:t.LOAD_STATE_8,save:t.SAVE_STATE_8},{d:"Slot 9",load:t.LOAD_STATE_9,save:t.SAVE_STATE_9},{d:"Slot 10",load:t.LOAD_STATE_10,save:t.SAVE_STATE_10},{d:"File",load:u.MACHINE_LOAD_STATE_FILE,save:u.MACHINE_SAVE_STATE_FILE,peripheral:!0}],w=wmsx.DOMKeys,x=w.VK_ESCAPE.wc,y=[w.VK_ENTER.wc,w.VK_SPACE.wc],z={};z[w.VK_UP.wc]=-1,z[w.VK_DOWN.wc]=1},wmsx.CartridgeFormatDialog=function(a,b,c,d){"use strict";function e(){r=0,k.reinsertROMContent(),s=wmsx.SlotCreator.getUserFormatOptionNames(k.rom);var a=wmsx.SlotCreator.getBestFormatOption(k.rom);a||(a=wmsx.SlotFormats.Normal),s.unshift(a.name);for(var b=0;b<t.length;++b)b<s.length?(s[b]===q&&(r=b),t[b].innerHTML=0===b?"AUTO: "+a.name:s[b],t[b].classList.add("wmsx-visible")):t[b].classList.remove("wmsx-visible");k.format===a&&(r=0),f(),g()}function f(){for(var a,b=0;b<s.length;++b)b===r?(a=t[b],a.classList.add("wmsx-selected")):t[b].classList.remove("wmsx-selected");m.scrollTop>a.offsetTop?m.scrollTop=a.offsetTop:m.scrollTop+m.offsetHeight<a.offsetTop+26+2&&(m.scrollTop=a.offsetTop-(m.offsetHeight-26-2))}function g(){n.textContent=w?v?"YES":"NO":"- -",n.classList.toggle("wmsx-selected",v)}function h(){l=document.createElement("div"),l.id="wmsx-cartridge-format",l.classList.add("wmsx-select-dialog"),l.style.width="280px",l.style.height="374px",l.tabIndex=-1;var a=document.createTextNode("Select ROM Format");l.appendChild(a),m=document.createElement("ul");for(var c=0,d=wmsx.SlotFormatsUserOptions.length+1;c<d;++c){var e=document.createElement("li");e.wmsxIndex=c,e.classList.add("wmsx-visible"),e.style.textAlign="center",t.push(e),m.appendChild(e)}l.appendChild(m);var f=document.createElement("div"),g=document.createElement("ul");g.classList.add("wmsx-quick-options-list"),e=document.createElement("li");var h=document.createElement("div");h.innerHTML="&#128190;&nbsp; Remember Choice",e.appendChild(h),n=document.createElement("div"),n.innerHTML="NO",n.classList.add("wmsx-control"),e.appendChild(n),g.appendChild(e),f.appendChild(g),l.appendChild(f),i(),b.appendChild(l)}function i(){function a(){j.hide(!1)}function b(){j.hide(!0)}function c(a){r=a,f()}wmsx.Util.onTapOrMouseDownWithBlock(l,function(){m.focus()}),wmsx.Util.addEventsListener(m,"touchstart touchmove touchend",function(a){a.stopPropagation()}),wmsx.Util.addEventsListener(m,"mousedown",function(a){a.stopPropagation(),wmsx.ControllersHub.hapticFeedbackOnTouch(a),a.target.wmsxIndex>=0&&c(a.target.wmsxIndex)}),wmsx.Util.addEventsListener(m,"click",function(a){if(wmsx.Util.blockEvent(a),a.target.wmsxIndex>=0){var d=a.target.wmsxIndex===r;c(a.target.wmsxIndex),setTimeout(b,d?0:120)}}),wmsx.Util.onTapOrMouseDownWithBlock(n,function(a){w&&(wmsx.ControllersHub.hapticFeedbackOnTouch(a),v=!v,g())}),l.addEventListener("keydown",function(c){var d=y.codeNewForKeyboardEvent(c);return d===z?a():A.indexOf(d)>=0?b():B[d]&&(r+=B[d],r<0?r=0:r>=s.length&&(r=s.length-1),f()),wmsx.Util.blockEvent(c)})}var j=this;this.show=function(a,c){if(!l)return h(),setTimeout(function(){j.show(a,c)},0);o=a,p=c,(k=d.cartridgeInserted(o))&&(q=k.format.name,v=!!x.getForROM(k.rom),w=!!k.rom.info.h,u=!0,l.classList.add("wmsx-show"),e(),l.focus(),wmsx.Util.scaleToFitParentHeight(l,b,wmsx.ScreenGUI.BAR_HEIGHT))},this.hide=function(b){if(u){if(l.classList.remove("wmsx-show"),u=!1,WMSX.room.screen.focus(),b){var e=s[r],f=e===s[0],g=wmsx.SlotCreator.changeCartridgeFormat(k,wmsx.SlotFormats[e]);v&&x.setForROM(k.rom,e,f),d.insertCartridge(g,o,p||!c.powerIsOn,!0),a.showOSD("ROM Format: "+e+(f?" (Auto)":""),!0)}k=void 0}};var k,l,m,n,o=0,p=!1,q="",r=0,s=[],t=[],u=!1,v=!1,w=!1,x=WMSX.userROMFormats,y=wmsx.DOMKeys,z=y.VK_ESCAPE.wc,A=[y.VK_ENTER.wc,y.VK_SPACE.wc],B={};B[y.VK_UP.wc]=-1,B[y.VK_DOWN.wc]=1},wmsx.DiskSelectDialog=function(a,b,c,d){"use strict";function e(){m.textContent="Select Disk in Drive "+(1===v?"B:":"A:")+" "+b.getCurrentDiskNumDesc(v);var a=61+33*Math.max(p.length,4);l.style.height=a+"px";for(var c=0;c<t.length;++c){var d=t[c];c<p.length?(d.classList.add("wmsx-visible"),d.innerHTML=c+1+":&nbsp;&nbsp;"+p[c].name,d.classList.toggle("wmsx-selected",c===q),d.classList.toggle("wmsx-toggle-checked",!!p[c].modified)):d.classList.remove("wmsx-visible"),d.classList.remove("wmsx-droptarget")}r=s=void 0}function f(){p=b.getDriveStack(v),q=b.getCurrentDiskNum(v)}function g(a){var b=q+a;b<0||b>=p.length||(q=b)}function h(){l=document.createElement("div"),l.id="wmsx-diskselect",l.classList.add("wmsx-select-dialog"),l.style.height="270px",l.tabIndex=-1,m=document.createTextNode("Select Disk"),l.appendChild(m),n=document.createElement("div"),n.id="wmsx-diskselect-footer",n.classList.add("wmsx-footer"),n.innerHTML="(drag items to change order)",l.appendChild(n),o=document.createElement("ul");for(var b=wmsx.FileDiskDrive.MAX_STACK+1,c=0;c<b;++c){var d=document.createElement("li");d.draggable=!0,d.wmsxDiskNum=c,d.classList.add("wmsx-toggle"),t.push(d),o.appendChild(d)}l.appendChild(o),i(),j(),a.appendChild(l)}function i(){function a(){k.hide(!1)}function b(){k.hide(!0)}wmsx.Util.onTapOrMouseDown(l,function(a){l.focus(),a.stopPropagation()}),l.addEventListener("keydown",function(d){var f=x.codeNewForKeyboardEvent(d);if(f===y)a();else if(z.indexOf(f)>=0)b();else{var h=f&C;h===A?c.processKey(f,!0):B[h]&&(g(B[h]),e())}return wmsx.Util.blockEvent(d)}),wmsx.Util.onTapOrMouseUpWithBlock(o,function(a){var c=a.target.wmsxDiskNum;return void 0!==c&&(wmsx.ControllersHub.hapticFeedbackOnTouch(a),q=c,e(),setTimeout(b,120)),!1}),o.addEventListener("mousemove",function(a){a.stopPropagation()})}function j(){o.addEventListener("dragstart",function(a){return a.stopPropagation(),void 0!==a.target.wmsxDiskNum&&(r=a.target,a.dataTransfer.setData("text/html",a.target.innerHTML),d.setDragAndDropDisabled(!0),!1)}),o.addEventListener("dragend",function(a){return a.stopPropagation(),s&&s.classList.remove("wmsx-droptarget"),r=s=void 0,d.setDragAndDropDisabled(!1),!1}),l.addEventListener("drop",function(a){if(a.preventDefault(),!r)return!1;if(a.stopPropagation(),!s)return!1;var b=r.wmsxDiskNum,d=s.wmsxDiskNum;return void 0!==b&&void 0!==d&&d!==b&&(c.processControlActivated(wmsx.PeripheralControls.DISK_MOVE,w,!1,{d:v,f:b,t:d}),!1)}),o.addEventListener("dragenter",function(a){return!(!r||void 0===a.target.wmsxDiskNum)&&(s&&s!==a.target&&s.classList.remove("wmsx-droptarget"),s=a.target!==r?a.target:void 0,s&&s.classList.add("wmsx-droptarget"),!1)})}var k=this;this.show=function(b,c,d){if(!l)return h(),setTimeout(function(){k.show(b,c,d)},0);v=b,w=d,u=!0,f(),g(c),e(),l.classList.add("wmsx-show"),l.focus(),wmsx.Util.scaleToFitParentHeight(l,a,wmsx.ScreenGUI.BAR_HEIGHT)},this.hide=function(a){d.setDragAndDropDisabled(!1),u&&(l.classList.remove("wmsx-show"),u=!1,WMSX.room.screen.focus(),a&&q>=0&&c.processControlActivated(wmsx.PeripheralControls.DISK_INSERT,w,!1,{d:v,n:q,a:w}))},this.diskDrivesMediaStateUpdate=function(a){u&&a===v&&(f(),e())}
;var l,m,n,o,p,q,r,s,t=[],u=!1,v=0,w=!0,x=wmsx.DOMKeys,y=x.VK_ESCAPE.wc,z=[x.VK_ENTER.wc,x.VK_SPACE.wc],A=x.VK_F6.wc,B={};B[x.VK_UP.wc]=-1,B[x.VK_PAGE_UP.wc]=-1,B[x.VK_DOWN.wc]=1,B[x.VK_PAGE_DOWN.wc]=1;var C=x.IGNORE_ALL_MODIFIERS_MASK},wmsx.NewHardDiskDialog=function(a,b){"use strict";function c(){for(var a=0;a<k.length;++a)k[a].classList.toggle("wmsx-selected",a===j)}function d(){g=document.createElement("div"),g.id="wmsx-new-hard-disk",g.classList.add("wmsx-select-dialog"),g.style.width="280px",g.style.height="175px",g.tabIndex=-1,i=document.createTextNode("Select Disk Size"),g.appendChild(i),h=document.createElement("ul"),h.style.width="80%";for(var b=0;b<o.length;++b){var c=document.createElement("li");c.classList.add("wmsx-visible"),c.style.textAlign="center";var d=p[o[b]];c.innerHTML=d.desc+" Disk &nbsp;&nbsp;&nbsp;"+d.secDesc,c.wmsxOption=b,k.push(c),h.appendChild(c)}g.appendChild(h),e(),a.appendChild(g)}function e(){function a(){f.hide(!1)}function b(){f.hide(!0)}wmsx.Util.onTapOrMouseDownWithBlock(g,function(){g.focus()}),wmsx.Util.onTapOrMouseDownWithBlock(g,function(a){a.target.wmsxOption>=0&&(wmsx.ControllersHub.hapticFeedbackOnTouch(a),j=a.target.wmsxOption,c(),setTimeout(b,120))}),g.addEventListener("keydown",function(d){var e=q.codeNewForKeyboardEvent(d);return e===r?a():s.indexOf(e)>=0?b():t[e]&&(j+=t[e],j<0?j=0:j>=k.length&&(j=k.length-1),c()),wmsx.Util.blockEvent(d)})}var f=this;this.show=function(b,e){if(!g)return d(),setTimeout(function(){f.show(m,e)},0);l=!0,m=b,n=e,c(),g.classList.add("wmsx-show"),g.focus(),wmsx.Util.scaleToFitParentHeight(g,a,wmsx.ScreenGUI.BAR_HEIGHT)},this.hide=function(a){if(l&&(g.classList.remove("wmsx-show"),l=!1,WMSX.room.screen.focus(),a)){var c=o[j];b.processControlActivated(wmsx.PeripheralControls.HARDDISK_NEW,m,!1,{m:c,b:n})}};var g,h,i,j=0,k=[],l=!1,m=!1,n=!1,o=wmsx.DiskImages.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES,p=wmsx.DiskImages.MEDIA_TYPE_INFO,q=(wmsx.MachineControls,wmsx.PeripheralControls,wmsx.DOMKeys),r=q.VK_ESCAPE.wc,s=[q.VK_ENTER.wc,q.VK_SPACE.wc],t={};t[q.VK_UP.wc]=-1,t[q.VK_DOWN.wc]=1},wmsx.MachineSelectDialog=function(a,b,c){"use strict";function d(){for(var a=0;a<l.length;++a){var b=l[a];b.classList.toggle("wmsx-selected",b.wmsxMachine===i)}}function e(){j=document.createElement("div"),j.id="wmsx-machineselect",j.classList.add("wmsx-select-dialog"),j.style.width="280px",j.tabIndex=-1;var b=document.createTextNode("Select Machine");j.appendChild(b),k=document.createElement("ul"),k.style.width="80%",j.appendChild(k),f(),g(),a.appendChild(j)}function f(){k.innerHTML="";for(var a=Object.keys(WMSX.MACHINES_CONFIG),b=40,c=0;c<a.length;++c){var d=WMSX.MACHINES_CONFIG[a[c]];if(d.DESC){var e=document.createElement("li");e.classList.add("wmsx-visible"),e.style.textAlign="center",e.textContent=d.DESC,e.wmsxMachine=a[c],l.push(e),k.appendChild(e),b+=33}}j.style.height=b+"px"}function g(){function a(){h.hide(!1)}function b(){h.hide(!0)}wmsx.Util.onTapOrMouseDownWithBlock(j,function(a){return a.target.wmsxMachine?(wmsx.ControllersHub.hapticFeedbackOnTouch(a),i=a.target.wmsxMachine,d(),setTimeout(b,120)):j.focus(),!1}),j.addEventListener("keydown",function(c){var e=n.codeNewForKeyboardEvent(c);if(e===o)a();else if(p.indexOf(e)>=0)b();else if(q[e]){var f=Object.keys(WMSX.MACHINES_CONFIG),g=f.indexOf(i)+q[e],h=f[g];h&&WMSX.MACHINES_CONFIG[h].DESC&&(i=h,d())}return wmsx.Util.blockEvent(c)})}var h=this;this.show=function(){if(!j)return e(),setTimeout(h.show,0);l.length||f(),m=!0,i=b.getMachine(),j.classList.add("wmsx-show"),j.focus(),d();var c=a.clientHeight-wmsx.ScreenGUI.BAR_HEIGHT-20,g=j.clientHeight,k=g<c?1:c/g;j.style.transform="translateY(-"+(wmsx.ScreenGUI.BAR_HEIGHT/2|0)+"px) scale("+k.toFixed(4)+")"},this.hide=function(a){m&&(j.classList.remove("wmsx-show"),m=!1,WMSX.room.screen.focus(),a&&c.processControlActivated(wmsx.PeripheralControls.MACHINE_SELECT,!1,!1,i))},this.machineTypeStateUpdate=function(){m&&(i=b.getMachine(),d())},this.configurationStateUpdate=function(){l.length=0};var i,j,k,l=[],m=!1,n=wmsx.DOMKeys,o=n.VK_ESCAPE.wc,p=[n.VK_ENTER.wc,n.VK_SPACE.wc],q={};q[n.VK_UP.wc]=-1,q[n.VK_DOWN.wc]=1},wmsx.TouchConfigDialog=function(a,b,c,d){"use strict";function e(){"T_DIR"===s?(n.classList.add("wmsx-show"),o.classList.remove("wmsx-show"),wmsx.DOMTouchControls.styleDirectionalMapping(n,B.directional)):(o.classList.add("wmsx-show"),n.classList.remove("wmsx-show"),wmsx.DOMTouchControls.styleButtonMapping(o,B.buttons[s])),p.classList.toggle("wmsx-disabled",u<=0),q.classList.toggle("wmsx-disabled",!t||u>=t.length-1)}function f(){var a=c.getSettingsState(),b=a.touchPortSet,e=a.touchActive;A[0].wmsxText.innerText=0===b?"Port 1":1===b?"Port 2":"OFF",A[0].classList.toggle("wmsx-selected",b>=0),A[0].classList.toggle("wmsx-inactive",!e);for(var f=1;f<r.length;++f){var g=r[f],h=d.getControlReport(g.control);g.value=h.label,g.selected=h.active,A[f].wmsxText.innerText=g.value,A[f].classList.toggle("wmsx-selected",!!g.selected)}}function g(){m=document.createElement("div"),m.id="wmsx-touch-config",m.tabIndex=-1,p=document.createElement("div"),p.id="wmsx-touch-config-minus",m.appendChild(p),q=document.createElement("div"),q.id="wmsx-touch-config-plus",m.appendChild(q),n=wmsx.DOMTouchControls.createDirectional("wmsx-touch-config-dir"),m.appendChild(n),o=wmsx.DOMTouchControls.createButton("wmsx-touch-config-button"),m.appendChild(o),r=[{label:"Touch Controller",control:wmsx.PeripheralControls.TOUCH_TOGGLE_MODE},{label:"Turbo Fire",control:wmsx.PeripheralControls.TURBO_FIRE_TOGGLE},{label:"&#128190;&nbsp; Big Directional",control:wmsx.PeripheralControls.TOUCH_TOGGLE_DIR_BIG},{label:"&#128190;&nbsp; Right Directional",control:wmsx.PeripheralControls.TOUCH_TOGGLE_MIRRORED},{label:"&#128190;&nbsp; Haptic Feedback",control:wmsx.PeripheralControls.HAPTIC_FEEDBACK_TOGGLE_MODE}];var a=document.createElement("ul");a.classList.add("wmsx-quick-options-list");for(var c=0;c<r.length;++c){var d=document.createElement("li"),e=document.createElement("div");e.innerHTML=r[c].label,d.appendChild(e);var f=document.createElement("div");f.classList.add("wmsx-control");var g=document.createElement("button");g.wmsxControlItem=r[c],g.wmsxDec=!0,g.classList.add("wmsx-control-dec"),f.appendChild(g);var h=document.createElement("span");f.wmsxText=h,f.appendChild(h),g=document.createElement("button"),g.wmsxControlItem=r[c],g.classList.add("wmsx-control-inc"),f.appendChild(g),d.appendChild(f),a.appendChild(d),A.push(f)}m.appendChild(a),i(),b.appendChild(m),x=["JOYSTICK","KEYBOARD"],y=[null],y.push(wmsx.JoystickButtons.J_A.button),y.push(wmsx.JoystickButtons.J_B.button),y.push(wmsx.JoystickButtons.J_AB.button);for(var j in wmsx.KeyboardKeys)y.push(j)}function h(a,b){if(s){if((u+=a)<0)return u=0;if(u>=t.length)return u=t.length-1;c.hapticFeedbackOnTouch(b);var d=t[u];"T_DIR"!==s&&(d=d&&(wmsx.JoystickButtons[d]||wmsx.KeyboardKeys[d])),C.customizeControl(s,d),e()}}function i(){wmsx.Util.onTapOrMouseDownWithBlock(m,function(a){a.target.wmsxControlItem?(d.processControlActivated(a.target.wmsxControlItem.control,!0,a.target.wmsxDec),c.hapticFeedbackOnTouch(a),f()):m.focus()}),m.addEventListener("keydown",function(a){var b=D.codeNewForKeyboardEvent(a);return E.indexOf(b)>=0?l.hide():F[b]&&h(F[b],a),wmsx.Util.blockEvent(a)}),wmsx.Util.addEventsListener(p,"touchstart mousedown",function(a){j(a,-1)}),wmsx.Util.addEventsListener(q,"touchstart mousedown",function(a){j(a,1)}),wmsx.Util.addEventsListener(p,"touchend mouseup",k),wmsx.Util.addEventsListener(q,"touchend mouseup",k)}function j(a,b){k(a),h(b,a),v=setTimeout(function(){w=setInterval(function(){h(b,a)},35)},415)}function k(a){wmsx.Util.blockEvent(a),v&&(clearTimeout(v),v=null),w&&(clearInterval(w),w=null)}var l=this;this.show=function(){if(!m)return g(),setTimeout(l.show,0);z=!0,a.classList.add("wmsx-touch-config-active"),m.focus(),s=t=null,u=-1,C.startTouchDetection(l),e(),f(),
wmsx.Util.scaleToFitParentHeight(m,b,0)},this.hide=function(){z&&(C.stopTouchDetection(l),WMSX.userPreferences.save(),a.classList.remove("wmsx-touch-config-active"),z=!1,WMSX.room.screen.focus())},this.touchControlDetected=function(a,b){c.hapticFeedbackOnTouch(b),s=a;var d="T_DIR"===s;t=d?x:y;var f=d?B.directional:B.buttons[s],g=d?f:f&&(f.button||f.key);u=wmsx.Util.arrayFindIndex(t,function(a){return a===g}),e()},this.controllersSettingsStateUpdate=function(){z&&f()};var m,n,o,p,q,r,s,t,u,v,w,x,y,z=!1,A=[],B=WMSX.userPreferences.current.touch,C=c.getTouchControls(),D=wmsx.DOMKeys,E=[D.VK_ESCAPE.wc,D.VK_ENTER.wc,D.VK_SPACE.wc],F={};F[D.VK_LEFT.wc]=-1,F[D.VK_RIGHT.wc]=1},wmsx.QuickOptionsDialog=function(a,b,c){"use strict";function d(){for(var a=0;a<i.length;++a){var d=i[a],e=d.peripheral?c.getControlReport(d.control):b.getControlReport(d.control);d.value=e.label,d.selected=e.active,k[a].wmsxText.innerText=d.value,k[a].classList.toggle("wmsx-selected",!!d.selected)}}function e(){h=document.createElement("div"),h.id="wmsx-quick-options",h.tabIndex=-1;var b=wmsx.MachineControls,c=wmsx.PeripheralControls;i=[{label:"NTSC / PAL",control:b.VIDEO_STANDARD},{label:"CPU Turbo",control:b.CPU_TURBO_MODE},{label:"VDP Turbo",control:b.VDP_TURBO_MODE},{label:"Sprites Mode",control:b.SPRITE_MODE},{label:"Turbo Fire",control:c.TURBO_FIRE_TOGGLE,peripheral:!0},{label:"&#128190;&nbsp; VSync",control:b.VSYNCH},{label:"&#128190;&nbsp; CRT Filter",control:c.SCREEN_CRT_FILTER,peripheral:!0},{label:"&#128190;&nbsp; CRT Scanlines",control:c.SCREEN_CRT_SCANLINES,peripheral:!0},{label:"&#128190;&nbsp; Audio Buffer",control:c.SPEAKER_BUFFER_TOGGLE,peripheral:!0}];var d=document.createElement("ul");d.classList.add("wmsx-quick-options-list");for(var e=0;e<i.length;++e){var g=document.createElement("li"),j=document.createElement("div");j.innerHTML=i[e].label,g.appendChild(j);var l=document.createElement("div");l.classList.add("wmsx-control");var m=document.createElement("button");m.wmsxControlItem=i[e],m.wmsxDec=!0,m.classList.add("wmsx-control-dec"),l.appendChild(m);var n=document.createElement("span");l.wmsxText=n,l.appendChild(n),m=document.createElement("button"),m.wmsxControlItem=i[e],m.classList.add("wmsx-control-inc"),l.appendChild(m),g.appendChild(l),d.appendChild(g),k.push(l)}h.appendChild(d),f(),a.appendChild(h)}function f(){wmsx.Util.onTapOrMouseDownWithBlock(h,function(a){if(a.target.wmsxControlItem){wmsx.ControllersHub.hapticFeedbackOnTouch(a);var e=a.target.wmsxControlItem;e.peripheral?(c.processControlActivated(e.control,!1,a.target.wmsxDec),d()):b.processControlState(e.control,!0,a.target.wmsxDec)}else h.focus()}),h.addEventListener("keydown",function(a){var b=l.codeNewForKeyboardEvent(a);return m.indexOf(b)>=0&&g.hide(),wmsx.Util.blockEvent(a)})}var g=this;this.show=function(){if(!h)return e(),setTimeout(g.show,0);d(),j=!0,h.classList.add("wmsx-show"),h.focus(),wmsx.Util.scaleToFitParentHeight(h,a,wmsx.ScreenGUI.BAR_HEIGHT)},this.hide=function(){j&&(WMSX.userPreferences.save(),h.classList.remove("wmsx-show"),j=!1,WMSX.room.screen.focus())},this.quickOptionsControlsStateUpdate=function(){j&&d()},this.machineTurboModesStateUpdate=function(){j&&d()};var h,i,j=!1,k=[],l=wmsx.DOMKeys,m=[l.VK_ESCAPE.wc]},wmsx.NetPlayDialog=function(a,b){"use strict";function c(){switch(a.netPlayMode){case 0:o.textContent="STANDALONE",m.textContent="START",n.textContent="JOIN",m.disabled=!1,n.disabled=!1,r.disabled=!1,s.disabled=!1,k.classList.remove("wmsx-active"),l.classList.remove("wmsx-disabled"),r.setAttribute("placeholder","Enter a name");break;case 1:var b=a.getNetServer();o.textContent="HOSTING Session: "+b.getSessionID(),m.textContent="STOP",n.textContent="JOIN",m.disabled=!1,n.disabled=!0,r.disabled=!0,s.disabled=!0,k.classList.add("wmsx-active"),l.classList.add("wmsx-disabled"),r.setAttribute("placeholder","Automatic"),p.href=e();break;case 2:var c=a.getNetClient();o.textContent="JOINED Session: "+c.getSessionID(),m.textContent="START",n.textContent="LEAVE",m.disabled=!0,n.disabled=!1,r.disabled=!0,s.disabled=!0,k.classList.add("wmsx-active"),l.classList.remove("wmsx-disabled"),l.classList.add("wmsx-disabled"),r.setAttribute("placeholder","Enter a name"),p.href=e();break;case-1:case-2:o.textContent="Establishing connection...",r.disabled=!0,s.disabled=!0,k.classList.remove("wmsx-active"),l.classList.add("wmsx-disabled"),-1===a.netPlayMode?(m.textContent="CANCEL",n.textContent="JOIN",m.disabled=!1,n.disabled=!0,r.setAttribute("placeholder","Automatic")):(m.textContent="START",n.textContent="CANCEL",m.disabled=!0,n.disabled=!1,r.setAttribute("placeholder","Enter a name"))}}function d(){r.value=u.netPlaySessionName,s.value=u.netPlayNick}function e(){return wmsx.Util.browserCurrentURL()+"?JOIN="+a.netController.getSessionID()}function f(b){var c=b.target;if(!c.disabled){wmsx.ControllersHub.hapticFeedbackOnTouch(b);var d=!1,e=a.netPlayMode;if(c!==m||0!==e&&1!==e&&-1!==e?c!==n||0!==e&&2!==e&&-2!==e||(0===e?(a.getNetClient().joinSession(r.value,s.value),d=!0):a.getNetClient().leaveSession(!1,-2===e?"NetPlay connection aborted":void 0)):0===e?(a.getNetServer().startSession(r.value),d=!0):a.getNetServer().stopSession(!1,-1===e?"NetPlay connection aborted":void 0),d){var f=r.value.trim(),g=s.value.trim();u.netPlaySessionName===f&&u.netPlayNick===g||(u.netPlaySessionName=f,u.netPlayNick=g,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())}}}function g(){j=document.createElement("div"),j.id="wmsx-netplay",j.tabIndex=-1,k=document.createElement("div"),k.id="wmsx-netplay-status-box",j.appendChild(k),q=document.createElement("input"),q.id="wmsx-netplay-link-text",k.appendChild(q),o=document.createElement("div"),o.id="wmsx-netplay-status",o.textContent="STANDALONE",k.appendChild(o),p=document.createElement("a"),p.id="wmsx-netplay-link",p.textContent="🔗",p.setAttribute("title","Copy Join Session link to clipboard"),k.appendChild(p),l=document.createElement("div"),l.id="wmsx-netplay-session-box",j.appendChild(l);var a=document.createElement("div");a.id="wmsx-netplay-session-label",l.appendChild(a),m=document.createElement("button"),m.id="wmsx-netplay-start",m.wmsxCommand=!0,m.classList.add("wmsx-netplay-button"),m.textContent="START",l.appendChild(m),r=document.createElement("input"),r.id="wmsx-netplay-session-name",r.setAttribute("placeholder","Enter a name"),r.setAttribute("maxlength",12),r.spellcheck=!1,r.autocorrect=!1,r.autocapitalize=!1,l.appendChild(r),n=document.createElement("button"),n.id="wmsx-netplay-join",n.wmsxCommand=!0,n.classList.add("wmsx-netplay-button"),n.textContent="JOIN",l.appendChild(n);var c=document.createElement("div");c.id="wmsx-netplay-nick-label",l.appendChild(c),s=document.createElement("input"),s.id="wmsx-netplay-nick",s.setAttribute("placeholder","Automatic"),s.setAttribute("maxlength",12),s.spellcheck=!1,s.autocorrect=!1,s.autocapitalize=!1,l.appendChild(s),h(),b.appendChild(j)}function h(){function b(a){var b=a.target,c=b.value;return!c||c.match(/^[A-Za-z0-9]+[A-Za-z0-9_\-]*@?$/)?b.wmsxLastValidValue=c:b.value=b.wmsxLastValidValue||""}wmsx.Util.onTapOrMouseDownWithBlock(j,function(a){a.target.wmsxCommand?f(a):j.focus()}),j.addEventListener("keydown",function(a){var b=v.codeNewForKeyboardEvent(a);return w.indexOf(b)>=0&&i.hide(),wmsx.Util.blockEvent(a)}),r.addEventListener("input",b),s.addEventListener("input",b),wmsx.Util.addEventsListener(o,"touchstart touchmove touchend mousedown mousemove mouseup keydown keyup",function(a){a.stopPropagation()}),wmsx.Util.addEventsListener(r,"touchstart touchmove touchend mousedown mousemove mouseup keydown keyup",function(a){a.stopPropagation()}),wmsx.Util.addEventsListener(s,"touchstart touchmove touchend mousedown mousemove mouseup keydown keyup",function(a){a.stopPropagation()}),j.ondragstart=wmsx.Util.blockEvent,k.addEventListener("contextmenu",function(a){a.stopPropagation()}),
wmsx.Util.addEventsListener(p,"click",function(b){if(wmsx.Util.blockEvent(b),!document.queryCommandSupported||!document.queryCommandSupported("copy"))return a.showOSD("Copy to Clipboard not supported by the browser!",!0,!0);q.value=e(),q.focus(),q.select(),document.execCommand("copy"),j.focus()})}var i=this;this.show=function(){if(!j)return g(),setTimeout(i.show,0);c(),d(),t=!0,j.classList.add("wmsx-show"),j.focus(),wmsx.Util.scaleToFitParentWidth(j,b,12)},this.hide=function(){t&&(j.classList.remove("wmsx-show"),t=!1,a.screen.focus())},this.roomNetPlayStatusChangeUpdate=function(b){if(t&&c(),2===a.netPlayMode&&b<0&&t)return setTimeout(function(){i.hide()},2e3);0===a.netPlayMode&&b>0&&!t&&i.show()},this.isVisible=function(){return t};var j,k,l,m,n,o,p,q,r,s,t=!1,u=WMSX.userPreferences.current,v=wmsx.DOMKeys,w=[v.VK_ESCAPE.wc]},wmsx.WebAudioSpeaker=function(a){"use strict";function b(){return wmsx.Util.isMobileDevice()?"CHROME"!==wmsx.Util.browserInfo().name||wmsx.Util.isIOSDevice()?3:4:2}function c(){return"SAFARI"===wmsx.Util.browserInfo().name||wmsx.Util.isIOSDevice()?b():0}function d(){!o||m.state&&"suspended"!==m.state||(a.addEventListener("touchend",e,!0),a.addEventListener("mousedown",e,!0),a.addEventListener("keydown",e,!0),m.addEventListener("statechange",f),i.speakerUnlockStateUpdate(!1),wmsx.Util.log("Speaker Audio Context resume event registered"))}function e(){try{m.resume()}catch(a){return}var a=m.createBufferSource();a.buffer=m.createBuffer(1,1,22050),a.connect(m.destination),a.start(0),"running"===m.state&&f()}function f(){"running"===m.state&&(a.removeEventListener("touchend",e,!0),a.removeEventListener("mousedown",e,!0),a.removeEventListener("keydown",e,!0),m.removeEventListener("statechange",f),i.speakerUnlockStateUpdate(!0),wmsx.Util.log("Speaker Audio Context restablished!"))}function g(){if(o){p.length=q.length=r.length=s.length=t.length=l.length;for(var a=0;a<l.length;a++)p[a]=l[a].getSampleRate()/m.sampleRate,q[a]=0,r[a]=s[a]=t[a]=0,l[a].setAudioMonitorBufferSize(p[a]*n|0)}}function h(a){for(var b=a.outputBuffer.getChannelData(0),c=a.outputBuffer.getChannelData(1),d=b.length,e=d-1;e>=0;e-=1)b[e]=c[e]=0;if(0!==l.length)for(var f=l.length-1;f>=0;f-=1){var g=p[f],h=d*g+q[f]|0,i=l[f].retrieveSamples(h,v),j=i.buffer0,k=i.buffer1,m=i.bufferSize,n=i.start,o=n+q[f];if(g<1){for(var u=r[f],w=s[f],x=t[f],y=0;y<d;++y,o+=g)o>=m&&(o-=m),b[y]+=u*(1-x),c[y]+=w*(1-x),u=j[0|o],w=k[0|o],b[y]+=u*x,c[y]+=w*x,x=o-(0|o);r[f]=u,s[f]=w,t[f]=x}else for(y=0;y<d;++y,o+=g)o>=m&&(o-=m),b[y]+=j[0|o],c[y]+=k[0|o];o<n&&(o+=m),q[f]=o-(n+h)}}this.connect=function(a){a.connectMonitor(this)},this.connectPeripherals=function(a){i=a},this.connectAudioSignal=function(a){l.indexOf(a)>=0||(wmsx.Util.arrayAdd(l,a),g())},this.disconnectAudioSignal=function(a){l.indexOf(a)<0||(wmsx.Util.arrayRemoveAllElement(l,a),g())},this.powerOn=function(){j(),o&&(d(),this.unpauseAudio())},this.powerOff=function(){this.pauseAudio(),m&&m.close(),m=o=void 0},this.mute=function(){v=!0},this.unMute=function(){v=!1},this.pauseAudio=function(){o&&o.disconnect()},this.unpauseAudio=function(){o&&o.connect(m.destination)},this.toggleBufferBaseSize=function(a){if(!m)return i.showOSD("Audio is DISABLED",!0,!0);a?--u<-1&&(u=6):++u>6&&(u=-1),this.pauseAudio(),k(),this.unpauseAudio(),i.showOSD("Audio Buffer size: "+(-1===u?"Auto ("+n+")":0===u?"Browser ("+n+")":n),!0),WMSX.userPreferences.current.audioBufferBase=u,WMSX.userPreferences.setDirty()},this.getControlReport=function(a){return{label:-2===u?"OFF":-1===u?"Auto":0===u?"Browser":n,active:u>0}};var i,j=function(){if(-2===u||0===WMSX.AUDIO_MONITOR_BUFFER_SIZE)return void wmsx.Util.warning("Audio disabled in configuration");try{var a=window.AudioContext||window.webkitAudioContext||window.WebkitAudioContext;if(!a)throw new Error("WebAudio API not supported by the browser");m=new a,wmsx.Util.log("Speaker AudioContext created. Sample rate: "+m.sampleRate+(m.state?", "+m.state:"")),k()}catch(a){wmsx.Util.error("Could not create AudioContext. Audio DISABLED!\n"+a)}},k=function(){try{var a=-1===u?b():0===u?c():u,d=WMSX.AUDIO_MONITOR_BUFFER_SIZE>0?WMSX.AUDIO_MONITOR_BUFFER_SIZE:a>0?wmsx.Util.exp2(0|wmsx.Util.log2((m.sampleRate+14e3)/22050))*wmsx.Util.exp2(a-1)*256:0;d=d<256?256:d>16384?16384:d,o=m.createScriptProcessor(d,2,2),o.onaudioprocess=h,n=o.bufferSize,g(),wmsx.Util.log("Audio Processor buffer size: "+o.bufferSize)}catch(a){wmsx.Util.error("Could not create ScriptProcessorNode. Audio DISABLED!\n"+a)}},l=[];this.signals=l;var m,n,o,p=[],q=[],r=[],s=[],t=[],u=-3===WMSX.AUDIO_MONITOR_BUFFER_BASE?WMSX.userPreferences.current.audioBufferBase:WMSX.AUDIO_MONITOR_BUFFER_BASE,v=!1},wmsx.SaveStateMedia=function(a){"use strict";function b(a){wmsx.Util.error("Error accessing IndexedDB, falling back to LocalStorage:",a),h=void 0}this.connect=function(a){a.connectMedia(this)},this.connectPeripherals=function(a){j=a},this.isSlotUsed=function(a){return void 0!==localStorage["wmsxsave"+a+o+"u"]||void 0!==localStorage["wmsxsave"+a+o]},this.persistState=function(a,b,d){var f=e(b);c("save"+a+o,f,d)},this.retrieveState=function(a,b){d("save"+a+o,function(a){b(a&&f(a))})},this.saveStateFile=function(a){var b=e(a);b&&j.startDownloadBinary("WMSX SaveState"+m,b,"State File")},this.loadStateFile=function(a){return f(a)},this.externalStateChange=function(){a.netController&&a.netController.processExternalStateChange()};var c=function(a,c,d){function e(){i.store(a,c,function(){localStorage["wmsx"+a+"u"]="Y",d(!0)},function(a){wmsx.Util.error(a),d(!1)})}g(function(){h?h.store(a,c,function(){localStorage["wmsx"+a+"u"]="Y",d(!0)},function(a){b(a),e()}):e()})},d=function(a,c){function e(){i.retrieve(a,function(a){c(a)},function(a){wmsx.Util.warning(a),c(void 0)})}g(function(){h?h.retrieve(a,function(a){a?c(a):e()},function(e){b(e),d(a,c)}):e()})},e=function(a){try{return k+JSON.stringify(a)}catch(a){wmsx.Util.error(a)}},f=function(a){try{var b;if((b="string"==typeof a?a.substr(0,k.length):wmsx.Util.int8BitArrayToByteString(a,0,k.length))!==k&&b!==l)return;var c;return(c="string"==typeof a?a.slice(k.length):wmsx.Util.int8BitArrayToByteString(a,k.length))&&JSON.parse(c)}catch(a){wmsx.Util.error(a)}},g=function(a){if(i)return a();i=new wmsx.LocalStoragePersistence,h=new wmsx.IndexedDBPersistence,h.open(n,a,function(){h=null,a()})};this.getIndexed=function(){return h};var h,i,j,k=String.fromCharCode(0,0)+"wmsx"+String.fromCharCode(0,0)+"state!",l="wmsxsavestate!",m=".wst",n=1,o=WMSX.ENVIRONMENT?"_"+WMSX.ENVIRONMENT:""},wmsx.LocalStoragePersistence=function(){"use strict";this.open=function(a,b,c){b()},this.store=function(a,b,c,d){try{localStorage["wmsx"+a]=b,c()}catch(a){d(a)}},this.retrieve=function(a,b,c){try{b(localStorage["wmsx"+a])}catch(a){c(a)}},this.clear=function(a,b){a()}},wmsx.IndexedDBPersistence=function(){"use strict";var a=this;this.open=function(b,c,d){function e(b){wmsx.Util.error("Error obtaining IndexedDB persistence, falling back to LocalStorage only"),a.db=null,d(b)}try{var f=indexedDB.open("WebMSX",b)}catch(a){e(a)}f.onupgradeneeded=function(a){try{var b=a.target.result;b.objectStoreNames.contains("WebMSX")||(wmsx.Util.log("Creating IndexedDB persistence..."),b.createObjectStore("MainStore"))}catch(a){e(a)}},f.onsuccess=function(b){a.db=b.target.result,wmsx.Util.log("Using IndexedDB persistence"),c(a.db)},f.onerror=e},this.store=function(a,b,c,d){try{var e=this.db.transaction("MainStore","readwrite");e.onerror=d;var f=e.objectStore("MainStore"),g=f.put(b,a);g.onsuccess=function(){c()},g.onerror=d}catch(a){d(a)}},this.retrieve=function(a,b,c){var d=this.db.transaction("MainStore");d.onerror=c;var e=d.objectStore("MainStore"),f=e.get(a);f.onsuccess=function(a){b(a.target.result)},f.onerror=c},this.clear=function(a,b){var c=indexedDB.deleteDatabase("WebMSX");c.onsuccess=a,c.onerror=b},this.db=void 0},wmsx.FileCartridgeSlot=function(a){"use strict"
;this.connect=function(a,d){b=a,c=d},this.connectPeripherals=function(a){d=a},this.insertCartridge=function(d,e,f,g){if(b.insertCartridge(d,e,f,g),d&&d.rom.info.e){var h=d.rom.info.e;h&&WMSX.EXTENSIONS_CONFIG[h]&&c.activateExtension(h,!0,0===e,!0,!0)}1===a.netPlayMode&&a.netController.addPeripheralOperationToSend({op:0,c:d.saveState(),p:e,a:f})},this.insertSerializedCartridge=function(a,c,d){var e=wmsx.SlotCreator.recreateFromSaveState(a,b.cartridgeInserted(c));this.insertCartridge(e,c,d)},this.loadCartridgeData=function(c,d,e){var f=b.loadCartridgeData(c,d,e);return f&&1===a.netPlayMode&&a.netController.addPeripheralOperationToSend({op:1,p:c,n:d,c:wmsx.Util.compressInt8BitArrayToStringBase64(e)}),f},this.loadSerializedCartridgeData=function(a,c,d){b.loadCartridgeData(a,c,wmsx.Util.uncompressStringBase64ToInt8BitArray(d))},this.cartridgeInserted=function(a){return b.cartridgeInserted(a)},this.removeCartridge=function(a,c){b.removeCartridge(a,c)},this.saveCartridgeDataFile=function(a){var c=b.getCartridgeData(a);d.startDownloadBinary(c.fileName,c.content,c.desc)};var b,c,d},wmsx.FileCassetteDeck=function(a){"use strict";function b(){k(),q.showOSD("Cassette Tape rewound."+n(),!0)}function c(){j(),q.showOSD("Cassette forwarded to Tape end",!0)}function d(){s="New Tape.cas",t=[],k(),q.showOSD("Cassette loaded with new blank Tape",!0),o()}function e(a){return a?wmsx.Util.leafFilenameNoExtension(a)+".cas":"New Tape.cas"}function f(a,b){b=b||0,-1===(u=wmsx.Util.arrayIndexOfSubArray(t,x,u+b,a))&&(-1===a?k():j())}function g(){return!t&&(q.showOSD("No Cassette Tape!",!0,!0),!0)}function h(){return u===t.length}function i(){return 0===u}function j(){u=t.length}function k(){u=0}function l(){for(;u%8;)t[u++]=0}function m(a){if(!t||t.length<a+24)return null;var b=null;if(wmsx.Util.arrayIndexOfSubArray(t,y,a)===a+8)b="Binary";else if(wmsx.Util.arrayIndexOfSubArray(t,z,a)===a+8)b="Basic";else{if(wmsx.Util.arrayIndexOfSubArray(t,A,a)!==a+8)return null;b="ASCII"}return{type:b,name:wmsx.Util.int8BitArrayToByteString(t,a+18,6).trim()}}function n(){var a="";if(t)if(0===t.length)a+=" Tape empty";else if(h())a+=" Tape at end";else{var b=m(u);b&&(a+=" Tape at "+b.type+' "'+b.name+'"')}else a+=" No Tape";return a}function o(){q.tapeStateUpdate(s,v,w)}this.connect=function(a){p=a,p.connectDeck(this)},this.connectPeripherals=function(a,b){q=a,r=b},this.loadTapeFile=function(b,c,d){if(0===wmsx.Util.arrayIndexOfSubArray(c,x,0))return 1===a.netPlayMode&&a.netController.addPeripheralOperationToSend({op:20,n:b,c:wmsx.Util.compressInt8BitArrayToStringBase64(c),p:d}),s=wmsx.Util.leafFilename(b),t=wmsx.Util.asNormalArray(c),k(),q.showOSD("Cassette: "+b+". "+n(),!0),o(),p.autoPowerCycle(d),t},this.loadSerializedTape=function(a,b,c){this.loadTapeFile(a,wmsx.Util.uncompressStringBase64ToInt8BitArray(b,t),c)},this.userLoadEmptyTape=function(){d()},this.userRemoveTape=function(){g()||(s=null,t=null,u=-1,q.showOSD("Cassette Tape removed",!0),o())},this.userRewind=function(){g()||b()},this.userSeekToEnd=function(){g()||c()},this.userSeekForward=function(){if(!g()){if(h()||f(1,1),h())return c();q.showOSD("Cassette skipped forward."+n(),!0)}},this.userSeekBackward=function(){if(!g()){if(i()||f(-1,-1),i())return b();q.showOSD("Cassette skipped backward."+n(),!0)}},this.saveTapeFile=function(){if(!g()){if(0===t.length)return void q.showOSD("Cassette Tape is empty!",!0,!0);try{if(l(),!s||"New Tape.cas"==s){var a=m(0);a&&(s=a.name&&a.name.trim(),s||(s="New Tape"),s+=".cas"),s||(s="New Tape.cas"),o()}r.startDownloadBinary(e(s),new Uint8Array(t),"Cassette Tape file")&&(w=!1,o())}catch(a){}}},this.peekFileInfoAtCurrentPosition=function(){return m(u)},this.userTypeCurrentAutoRunCommand=function(){if(!g()){if(0===t.length)return void q.showOSD("Cassette Tape is empty!",!0,!0);if(!p.getDriver().currentAutoRunCommand())return void q.showOSD("No executable at current Tape position!",!0,!0);p.getDriver().typeCurrentAutoRunCommand()}},this.readHeader=function(){return!(!t||h())&&(f(1),!h()&&(u+=8,!0))},this.readByte=function(){return!t||h()?null:t[u++]},this.writeHeader=function(a){t||d(),l();for(var b=0;b<x.length;b++)t[u++]=x[b];return w=!0,!0},this.writeByte=function(a){return t||d(),t[u++]=a,w=!0,!0},this.finishWriting=function(){t&&l()},this.motor=function(a){return v=null!==a?a:!v,o(),!0},this.saveState=function(){return{f:s,c:t&&wmsx.Util.compressInt8BitArrayToStringBase64(t),p:u,m:v,d:w}},this.loadState=function(a){s=a.f,t=a.c&&wmsx.Util.uncompressStringBase64ToInt8BitArray(a.c,t),u=a.p,v=a.m,w=!!a.d,o()};var p,q,r,s=null,t=null,u=-1,v=!1,w=!1,x=[31,166,222,186,204,19,125,116],y=[208,208,208,208,208,208,208,208,208,208],z=[211,211,211,211,211,211,211,211,211,211],A=[234,234,234,234,234,234,234,234,234,234]},wmsx.DiskImages=function(a){"use strict";var b=this;this.connect=function(a){c=a},this.writeFilesToImage=function(a,b){function c(a){f(a,{name:".",specialName:!0,lastModifiedDate:a.lastModifiedDate,isDir:!0,clusterChain:a.clusterChain}),f(a,{name:"..",specialName:!0,lastModifiedDate:a.lastModifiedDate,isDir:!0,clusterChain:a.parentDir.clusterChain});var b=a.items.length+2,c=a.items.filter(function(a){return!a.isDir});c.length>b&&(c.length=b),b-=c.length;var g=a.items.filter(function(a){return a.isDir});g.length>b&&(g.length=b),a.nextFreeEntry=2+g.length,e(a,c),a.nextFreeEntry=2,d(a,g),i(a),j(a)}function d(a,b){for(var d=0;d<b.length;++d){var e=b[d],g=o((e.items.length+2)*H);g>W?++Z:(e.content=wmsx.Util.arrayFill(new Array(g*N),0),e.parentDir=a,e.usedNames=new Set,e.nextFreeEntry=0,m(e),f(a,e),c(e),++Y)}}function e(a,b){for(var c=0;c<b.length;++c){var d=b[c];o(d.content.length)>W?++Z:(m(d),f(a,d),j(d),++Y)}}function f(a,b){for(var c=a.content,d=(a.availableEntries?a.availableEntries[a.nextFreeEntry]:a.nextFreeEntry)*H,e=q(b,a.usedNames),f=0;f<11;++f)c[d+f]=e.charCodeAt(f);var g=b.isDir?16:32;c[d+11]=g;var h=d+22,i=b.lastModified?new Date(b.lastModified):b.lastModifiedDate||$,j=s(i);c[h]=255&j,c[h+1]=j>>8;var k=t(i);c[h+2]=255&k,c[h+3]=k>>8,h=d+26,c[h]=255&b.clusterChain[0],c[h+1]=b.clusterChain[0]>>8,h=d+28;var l=b.isDir?0:b.content.length;c[h]=255&l,c[h+1]=l>>8&255,c[h+2]=l>>16&255,c[h+3]=l>>24&255,a.nextFreeEntry++}function g(a){for(var b=a.content,c=a.availableEntries=[],d=0,e=0,f=b.length;d<f;d+=H,++e)0!==b[d]&&229!==b[d]||c.push(e)}function h(a){for(var b=a.content,c=a.usedNames=new Set,d=0,e=0,f=b.length;d<f;d+=H,++e)if(0!==b[d]&&229!==b[d]){for(var g="",h=0;h<11;++h)g+=String.fromCharCode(b[d+h]);c.add(g)}}function i(a){for(var b=a.content,c=!1,d=b.length-H;d>=0;d-=H)c?0===b[d]&&(b[d]=229):0!==b[d]&&(c=!0)}function j(b){var c=b.content,d=b.continuousContentPosition;if(d)for(var e=0,f=c.length;e<f;++e)a[d+e]=c[e];else for(var g=0,h=b.clusterChain,i=0,j=h.length;i<j;++i){d=p(h[i]);for(var k=d+N;d<k;++d)a[d]=c[g++]}}function k(b,c){var d;R?(d=I*x+(b<<1),a[d]=255&c,a[d+1]=(65280&c)>>8):(d=I*x+3*(b>>1),1&b?(a[d+1]=15&a[d+1]|(15&c)<<4,a[d+2]=(4080&c)>>4):(a[d]=255&c,a[d+1]=240&a[d+1]|(3840&c)>>8))}function l(b){var c;return R?(c=I*x+(b<<1),a[c]|a[c+1]<<8):(c=I*x+3*(b>>1),1&b?a[c+1]>>4|a[c+2]<<4:a[c]|(15&a[c+1])<<8)}function m(a){var b=o(a.content.length);if(a.clusterChain=new Array(b),0===b)a.clusterChain[0]=0;else{for(var c=0;c<b;++c){var d=X;a.clusterChain[c]=d,n(),k(d,X)}k(d,65535)}}function n(){for(--W;0!==l(++X););}function o(a){return Math.ceil(a/N)}function p(a){return M+(a-2)*N}function q(a,b){if(a.specialName)return(a.name+"           ").substr(0,11);var c,d=r(wmsx.Util.leafFilenameNoExtension(a.name)),e=r(wmsx.Util.leafFilenameOnlyExtension(a.name));if(e=(e+"   ").substr(0,3),c=(d+"        ").substr(0,8)+e,d.length>8||b.has(c)){var f,g=0;do{++g,f="~"+g,c=(d.substr(0,8-f.length)+f+"        ").substr(0,8)+e}while(b.has(c))}return b.add(c),c}function r(a){return a.toUpperCase().replace(/[^a-z0-9!#$%&'\(\)\-@\^_`{}~]/gi,"_")}function s(a){
return a?a.getHours()<<11|(a.getMinutes()<<5)+a.getSeconds()/2:0}function t(a){return a?(a.getFullYear()-1980&127)<<9|(a.getMonth()+1<<5)+a.getDate():0}var u=a[510]|a[511]<<8,v=(a[450],a[454]|a[455]<<8|a[456]<<16|a[457]<<24),w=0;43605===u&&1===v&&(w=this.BYTES_PER_SECTOR);var x=a[w+11]|a[w+12]<<8,y=a[w+13],z=a[w+14]|a[w+15]<<8,A=a[w+16],B=a[w+17]|a[w+18]<<8,C=a[w+19]|a[w+20]<<8,D=a[w+21],E=a[w+22]|a[w+23]<<8,F=a[w+32]|a[w+33]<<8|a[w+34]<<16|a[w+35]<<24,G=C||F,H=32,I=v+z,J=I+A*E,K=J*x,L=J+H*B/x,M=L*x,N=y*x,O=(G-(L-v))/y|0,P=a[I*x],Q=String.fromCharCode(a[w+54],a[w+55],a[w+56],a[w+57],a[w+58],a[w+59],a[w+60],a[w+61]),R="FAT16   "===Q||"FAT12   "!==Q&&O>=4080;if(!(D===P&&(240===D||D>=248)&&O>=64)){var S=this.MEDIA_TYPE_INFO[P];if(!S||S.size!==a.length){var T=new Error("Could not write files: Current Disk format not recognized (unformatted?)");throw T.wmsx=!0,T}var U=this.MEDIA_TYPE_DPB[P];x=(U[2]<<8)+U[1],y=U[5]+1,I=(U[8]<<8)+U[7],A=U[9],B=U[10],L=(U[12]<<8)+U[11],O=(U[14]<<8)+U[13]-1,E=U[15],J=(U[17]<<8)+U[16],N=y*x,R=!1}var V=function(){for(var a=O+2-1,b=-1,c=0,d=2;d<=a;++d){0===l(d)&&(++c,b<0&&(b=d))}return{first:b,quant:c,max:a}}(),W=V.quant,X=(V.max,V.first);if(0===W)throw T=new Error("Could not write files: Disk full"),T.wmsx=!0,T;var Y=0,Z=0,$=new Date;if(function(b){var c={name:"ROOT",lastModifiedDate:$,isDir:!0,items:b,content:a.slice(K,K+B*H),nextFreeEntry:0,continuousContentPosition:K,clusterChain:[0]};g(c),h(c);var f=c.availableEntries.length,k=c.items.filter(function(a){return!a.isDir});k.length>f&&(k.length=f),f-=k.length;var l=c.items.filter(function(a){return a.isDir});l.length>f&&(l.length=f),c.nextFreeEntry=l.length,e(c,k),c.nextFreeEntry=0,d(c,l),i(c),j(c)}(b),Z>0&&0===Y)throw T=new Error("No files could fit in available Disk space"),T.wmsx=!0,T;return this.mirrorFatCopies(A,I,E,x,a),Z>0?Y+" of "+(Y+Z)+" files":Y+(1===Y?" file":" files")},this.createNewDisk=function(a,b){var c=new Uint8Array(this.MEDIA_TYPE_INFO[a].size);return b||this.formatDisk(a,c),c},this.formatDisk=function(a,b){this.HARDDISK_MEDIA_TYPE_HEADER_INFO[a]?this.formatHardDisk(a,b):this.formatFloppyDisk(a,b)},this.formatFloppyDisk=function(a,b){for(var d=c.hasDOS2()||c.hasHardDiskInterface()?this.MEDIA_TYPE_BOOT_SECTOR_DOS2[a]:this.MEDIA_TYPE_BOOT_SECTOR_DOS1[a],e=0;e<d.length;++e)b[e]=d[e];var f=d[11]|d[12]<<8,g=d[16],h=d[22]|d[23]<<8,i=d[14]|d[15]<<8,j=i*f;b[j]=a,b[j+1]=255,b[j+2]=255,this.mirrorFatCopies(g,i,h,f,b);var k=i+g*h,l=d[17]|d[18]<<8,m=k+32*l/f;for(e=m*f;e<b.length;++e)b[e]=255},this.mirrorFatCopies=function(a,b,c,d,e){for(var f=c*d,g=b*d+f,h=2;h<=a;++h)for(var i=b*d,j=0;j<f;++j)e[g++]=e[i++]},this.formatHardDisk=function(a,b){var c=this.HARDDISK_MEDIA_TYPE_HEADER_INFO[a];new wmsx.MultiDownloader([{url:c.header}],function(a){var d=a[0].content;wmsx.Util.arrayCopy(d,0,b);var e=c.fatData;for(var f in c.fatsPos){var g=c.fatsPos[f];b[g]=255&e,b[g+1]=e>>8&255,b[g+2]=e>>16&255,b[g+3]=e>>24&255}}).start()},this.makeBootDisk=function(d){var e=[{url:"@DOS1Boot.zip"}];c.hasHardDiskInterface()&&e.push({url:"@NextorBoot.zip"}),new wmsx.MultiDownloader(e,function(c){c[1]&&b.writeFilesToImage(d,a.fileLoader.createTreeFromZip(wmsx.Util.checkContentIsZIP(c[1].content))),b.writeFilesToImage(d,a.fileLoader.createTreeFromZip(wmsx.Util.checkContentIsZIP(c[0].content)))}).start()},this.hardDiskMediaTypeNeededForFiles=function(a){for(var b,c=0,d=this.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES.length;c<d;++c){b=this.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES[c];var e=this.estimatedTotalSizeOnDisk(a,b);if(this.MEDIA_TYPE_INFO[b].size>1.3*e)break}return b},this.estimatedTotalSizeOnDisk=function(a,b){for(var c=this.MEDIA_TYPE_INFO[b].clusterSize,d=0,e=0,f=a.length;e<f;++e){var g=a[e];g.isDir?(d+=Math.ceil(32*g.items.length/c)*c,d+=this.estimatedTotalSizeOnDisk(g.items,b)):d+=Math.ceil(g.content.length/c)*c}return d};var c;this.BYTES_PER_SECTOR=512,this.MEDIA_TYPE_INFO=wmsx.DiskImages.MEDIA_TYPE_INFO,this.FORMAT_OPTIONS_MEDIA_TYPES=[249,248],this.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES=wmsx.DiskImages.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES,this.MEDIA_TYPE_VALID_SIZES=[737280,655360,368640,327680,184320,163840],this.MEDIA_TYPE_BOOT_SECTOR_DOS1={249:[235,254,144,87,77,83,88,32,32,32,32,0,2,2,1,0,2,112,0,160,5,249,3,0,9,0,2,0,0,0,208,237,83,89,192,50,208,192,54,86,35,54,192,49,31,245,17,171,192,14,15,205,125,243,60,202,99,192,17,0,1,14,26,205,125,243,33,1,0,34,185,192,33,0,63,17,171,192,14,39,205,125,243,195,0,1,88,192,205,0,0,121,230,254,254,2,194,106,192,58,208,192,167,202,34,64,17,133,192,205,119,192,14,7,205,125,243,24,180,26,183,200,213,95,14,6,205,125,243,209,19,24,242,66,111,111,116,32,101,114,114,111,114,13,10,80,114,101,115,115,32,97,110,121,32,107,101,121,32,102,111,114,32,114,101,116,114,121,13,10,0,0,77,83,88,68,79,83,32,32,83,89,83,0,0,0,0,0,0,0,0,0],248:[235,254,144,87,77,83,88,32,32,32,32,0,2,2,1,0,2,112,0,208,2,248,2,0,9,0,1,0,0,0,208,237,83,89,192,50,208,192,54,86,35,54,192,49,31,245,17,171,192,14,15,205,125,243,60,202,99,192,17,0,1,14,26,205,125,243,33,1,0,34,185,192,33,0,63,17,171,192,14,39,205,125,243,195,0,1,88,192,205,0,0,121,230,254,254,2,194,106,192,58,208,192,167,202,34,64,17,133,192,205,119,192,14,7,205,125,243,24,180,26,183,200,213,95,14,6,205,125,243,209,19,24,242,66,111,111,116,32,101,114,114,111,114,13,10,80,114,101,115,115,32,97,110,121,32,107,101,121,32,102,111,114,32,114,101,116,114,121,13,10,0,0,77,83,88,68,79,83,32,32,83,89,83,0,0,0,0,0,0,0,0,0]},this.MEDIA_TYPE_BOOT_SECTOR_DOS2={249:[235,254,144,87,77,83,88,32,32,32,32,0,2,2,1,0,2,112,0,160,5,249,3,0,9,0,2,0,0,0,24,16,86,79,76,95,73,68,0,64,124,3,57,0,0,0,0,0,208,237,83,106,192,50,114,192,54,103,35,54,192,49,31,245,17,171,192,14,15,205,125,243,60,40,38,17,0,1,14,26,205,125,243,33,1,0,34,185,192,33,0,63,17,171,192,14,39,205,125,243,195,0,1,105,192,205,0,0,121,230,254,214,2,246,0,202,34,64,17,133,192,14,9,205,125,243,14,7,205,125,243,24,184,66,111,111,116,32,101,114,114,111,114,13,10,80,114,101,115,115,32,97,110,121,32,107,101,121,32,102,111,114,32,114,101,116,114,121,13,10,36,0,77,83,88,68,79,83,32,32,83,89,83,0,0,0,0,0,0,0,0,0],248:[235,254,144,87,77,83,88,32,32,32,32,0,2,2,1,0,2,112,0,208,2,248,2,0,9,0,1,0,0,0,24,16,86,79,76,95,73,68,1,153,220,28,245,0,0,0,0,0,208,237,83,106,192,50,114,192,54,103,35,54,192,49,31,245,17,171,192,14,15,205,125,243,60,40,38,17,0,1,14,26,205,125,243,33,1,0,34,185,192,33,0,63,17,171,192,14,39,205,125,243,195,0,1,105,192,205,0,0,121,230,254,214,2,246,0,202,34,64,17,133,192,14,9,205,125,243,14,7,205,125,243,24,184,66,111,111,116,32,101,114,114,111,114,13,10,80,114,101,115,115,32,97,110,121,32,107,101,121,32,102,111,114,32,114,101,116,114,121,13,10,36,0,77,83,88,68,79,83,32,32,83,89,83,0,0,0,0,0,0,0,0,0]},this.MEDIA_TYPE_DPB={248:[248,0,2,15,4,1,2,1,0,2,112,12,0,99,1,2,5,0],249:[249,0,2,15,4,1,2,1,0,2,112,14,0,202,2,3,7,0],250:[250,0,2,15,4,1,2,1,0,2,112,10,0,60,1,1,3,0],251:[251,0,2,15,4,1,2,1,0,2,112,12,0,123,2,2,5,0],252:[252,0,2,15,4,0,1,1,0,2,64,9,0,96,1,2,5,0],253:[253,0,2,15,4,1,2,1,0,2,112,12,0,99,1,2,5,0],254:[254,0,2,15,4,0,1,1,0,2,64,7,0,58,1,1,3,0],255:[255,0,2,15,4,1,2,1,0,2,112,10,0,60,1,1,3,0]},this.HARDDISK_MEDIA_TYPE_HEADER_INFO={16:{fatsPos:[512,2048],fatData:[16777200],header:"@Disk16MHeader.dat"},32:{fatsPos:[512,6656],fatData:[16777200],header:"@Disk32MHeader.dat"},64:{fatsPos:[1024,66560],fatData:[4294967280],header:"@Disk64MHeader.dat"},128:{fatsPos:[1024,132096],fatData:[4294967280],header:"@Disk128MHeader.dat"}}},wmsx.DiskImages.MEDIA_TYPE_INFO={248:{desc:"360KB",size:368640,clusterSize:1024},249:{desc:"720KB",size:737280,clusterSize:1024},250:{desc:"320KB",size:327680,clusterSize:1024},251:{desc:"640KB",size:655360,clusterSize:1024},252:{desc:"180KB",size:184320,clusterSize:512},253:{desc:"360KB",size:368640,clusterSize:1024},254:{desc:"160KB",size:163840,clusterSize:512},255:{desc:"320KB",size:327680,clusterSize:1024},16:{desc:"16MB",size:16777216,clusterSize:16384,
secDesc:"(FAT12)"},32:{desc:"32MB",size:33554432,clusterSize:8192,secDesc:"(FAT12)"},64:{desc:"64MB",size:67108864,clusterSize:2048,secDesc:"(FAT16)"},128:{desc:"128MB",size:134217728,clusterSize:2048,secDesc:"(FAT16)"}},wmsx.DiskImages.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES=[16,32,64,128],wmsx.FileDiskDrive=function(room){"use strict";function init(){emptyStack(0),emptyStack(1),emptyStack(2)}function tryLoadDiskStackFromFiles(a,b,c,d,e,f){if(2===a)e=!1;else if(e&&maxStackReachedMessage(a))return[];var g=[],h=2===a?1:e?MAX_STACK-driveStack[a].length:MAX_STACK;try{for(var i=0;i<c.length&&g.length<h;i++){var j=c[i];f&&void 0===j.content&&(j.content=j.asUint8Array());var k=checkFileHasValidImages(j,2===a,!b&&1===c.length);k&&g.push.apply(g,k)}if(g.length>0)return g.length>h&&(g=g.slice(0,h)),loadStack(a,g,null,d,e),g}catch(a){wmsx.Util.error(a)}}function checkFileHasValidImages(a,b,c,d){if(!d){var e=wmsx.Util.checkContentIsZIP(a.content);if(e){try{var f=wmsx.Util.getZIPFilesSorted(e);for(var g in f){f[g].content=f[g].asUint8Array();var h=checkFileHasValidImages(f[g],b,c,!0);if(h)return h}}catch(a){wmsx.Util.error(a)}return null}}var i=wmsx.Util.checkContentIsGZIP(a.content);if(i)return checkFileHasValidImages({name:a.name,content:i},b,c,!0);var j=checkContentIsValidImages(a.content,b,c);if(j){var k=wmsx.Util.leafFilename(a.name);if(1===j)return[{name:k,content:a.content}];for(var l=new Array(j),m=a.content.length/j|0,n=0,o=0;n<j;++n,o+=m)l[n]={name:k+(n+1),content:a.content.slice(o,o+m)};return l}return null}function checkContentIsValidImages(a,b,c){if(MEDIA_TYPE_VALID_SIZES_SET.has(a.length))return 1;if(b){if(a.length%BYTES_PER_SECTOR)return 0;if(a.length<HARDDISK_MIN_SIZE)return 0;if(c)return 1;if(85===a[510]&&170===a[511])return 1;if(a[512]>=240&&a[513]>=255)return 1;for(var d=0;d<32;++d)if(0!==a[d])return 0;return 1}var e=MEDIA_TYPE_VALID_SIZES[0];return a.length%e==0?a.length/e|0:0}function emptyStack(a){driveStack[a].length=0,curDisk[a]=-1,driveDiskChanged[a]=null}function loadStack(a,b,c,d,e,f){1===room.netPlayMode&&room.netController.addPeripheralOperationToSend({op:10,d:a,s:serializeStack(b),t:c,p:d,a:e}),e?(driveStack[a]=driveStack[a].concat(b),getCurrentDisk(a)||setCurrentDiskNum(a,0)):(driveStack[a]=b,setCurrentDiskNum(a,0)),stackLoadedMessage(a,c,b.length,e,f),fireMediaStateUpdate(a),driveStack[a].length>1?d||2===room.netPlayMode||self.openDiskSelectDialog(a,0,d):autoPower(d)}function autoPower(a){(diskDriveSocket.hasDiskInterface()&&getCurrentDisk(0)||diskDriveSocket.hasHardDiskInterface()&&getCurrentDisk(2))&&diskDriveSocket.autoPowerCycle(a)}function replaceCurrentDisk(a,b,c){c&&1===room.netPlayMode&&room.netController.addPeripheralOperationToSend({op:12,d:a,k:serializeDisk(b)}),driveStack[a][curDisk[a]]=b,driveDiskChanged[a]=!0,fireMediaStateUpdate(a)}function makeFileNameToSave(a){return a?wmsx.Util.leafFilenameNoExtension(a)+".dsk":"New Disk.dsk"}function motorOff(a,b){driveMotor[a]&&(driveMotorOffTimer[a]&&b&&(clearTimeout(driveMotorOffTimer[a]),driveMotorOffTimer[a]=null),driveMotorOffTimer[a]||(driveMotorOffTimer[a]=setTimeout(function(){driveMotorOffTimer[a]=null,driveMotor[a]=!1,fireMotorStateUpdate()},MOTOR_SPINDOWN_EXTRA_MILLIS[a])))}function setCurrentDiskNum(a,b){curDisk[a]=b,driveDiskChanged[a]=!0}function getCurrentDisk(a){return driveStack[a][curDisk[a]]}function fireMediaStateUpdate(a){screen.diskDrivesMediaStateUpdate(a),fireMotorStateUpdate()}function fireMotorStateUpdate(){var a=getCurrentDisk(0),b=getCurrentDisk(1),c=getCurrentDisk(2);screen.diskDrivesMotorStateUpdate(a,driveMotor[0],a&&a.modified,b,driveMotor[1],b&&b.modified,c,driveMotor[2],c&&c.modified)}function noDiskInsertedMessage(a){return!self.isDiskInserted(a)&&(screen.showOSD("No Disk in "+driveName[a],!0,!0),!0)}function maxStackReachedMessage(a){return driveStack[a].length>=MAX_STACK&&(screen.showOSD("Maximum Stack size in "+driveName[a]+" ("+driveStack[a].length+" disks)",!0,!0),!0)}function stackLoadedMessage(a,b,c,d,e){b=b||"Disk";var f=d?c+" "+b+(c>1?"s":"")+" added to "+driveName[a]:c>1?c+" Disks loaded in "+driveName[a]:currentDiskDesc(a);screen.showOSD(f+(e?" "+e:""),!0)}function diskInsertedMessage(a){noDiskInsertedMessage(a)||screen.showOSD(currentDiskDesc(a),!0)}function currentDiskDesc(a){var b=getCurrentDisk(a),c=currentDiskNumDesc(a);return driveName[a]+": "+(c?c+" ":"")+(b?b.name:"")}function currentDiskNumDesc(a){return driveStack[a].length>1?"("+(curDisk[a]+1)+"/"+driveStack[a].length+")":""}function serializeStack(a){for(var b=new Array(a.length),c=0;c<a.length;++c)b[c]=serializeDisk(a[c]);return b}function serializeDisk(a){return{name:a.name,content:wmsx.Util.compressInt8BitArrayToStringBase64(a.content),modif:a.modified}}function deserializeStack(a,b){if(b){b.length=a.length;for(var c=0;c<a.length;++c)b[c]=deserializeDisk(a[c],b[c]);return b}var d=new Array(a.length);for(c=0;c<a.length;++c)d[c]=deserializeDisk(a[c]);return d}function deserializeDisk(a,b){return{name:a.name,content:wmsx.Util.uncompressStringBase64ToInt8BitArray(a.content,b&&b.content,!1,Uint8Array),modified:!!a.modif}}function clearDisconnectedDiskInterfaces(){diskDriveSocket.hasDiskInterface()||(emptyStack(0),emptyStack(1),driveMotor[0]=driveMotor[1]=!1,fireMediaStateUpdate(0),fireMediaStateUpdate(1)),diskDriveSocket.hasHardDiskInterface()||clearHardDrive()}function clearHardDrive(){emptyStack(2),driveMotor[2]=!1,fireMediaStateUpdate(2)}var self=this;this.connect=function(a){diskDriveSocket=a,diskDriveSocket.connectDrive(this),images.connect(diskDriveSocket)},this.connectPeripherals=function(a,b){screen=a,fileDownloader=b},this.hasAnyMediaInserted=function(){return diskDriveSocket.hasDiskInterface()&&(driveStack[0].length||driveStack[1].length)||diskDriveSocket.hasHardDiskInterface()&&driveStack[2].length},this.isHardDriveFirst=function(){return 1&WMSX.EXTENSIONS.HARDDISK||diskDriveSocket.hasHardDiskInterface()&&!diskDriveSocket.hasDiskInterface()},this.loadDiskStackFromFiles=function(a,b,c,d,e){var f=!1;if(!(a>=0)){f=!0;var g=diskDriveSocket.hasDiskInterface(),h=diskDriveSocket.hasHardDiskInterface();if(g)a=h?a<0?-a:self.isHardDriveFirst()?2:0:a<0?-a:0;else{if(!h)return;a=2}}var i=tryLoadDiskStackFromFiles(a,f,b,c,d,e);return i||(f&&0===a&&!d&&h?tryLoadDiskStackFromFiles(2,!0,b,c,d,e):void 0)},this.loadAsDiskFromFiles=function(a,b,c,d){if(!(a>=0)){var e=diskDriveSocket.hasDiskInterface(),f=diskDriveSocket.hasHardDiskInterface();if(e)a=f?a<0?-a:this.isHardDriveFirst()?2:0:a<0?-a:0;else{if(!f)return;a=2}}var g,h=getCurrentDisk(a);if(h)g=h.content;else{try{var i=2===a?images.hardDiskMediaTypeNeededForFiles(c):this.FORMAT_OPTIONS_MEDIA_TYPES[0]}catch(b){console.error(b),i=2===a?this.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES[1]:this.FORMAT_OPTIONS_MEDIA_TYPES[0]}g=images.createNewDisk(i)}try{var j=images.writeFilesToImage(g,c);if(!j)return}catch(a){throw console.error(a),a}if(h)return screen.showOSD(driveName[a]+": "+j+" added to disk",!0),h.content=g,h.modified=!0,replaceCurrentDisk(a,h,!0),this.getDriveStack(a);b=(b||"New "+this.MEDIA_TYPE_INFO[i].desc)+".dsk";var k=[{name:b,content:g,modified:!1}];return loadStack(a,k,null,d,!1,"("+j+" added to disk)"),k},this.loadSerializedStack=function(a,b,c,d,e){loadStack(a,deserializeStack(b,e?void 0:driveStack[a]),c,d,e)},this.replaceCurrentDiskSerialized=function(a,b){replaceCurrentDisk(a,deserializeDisk(b,getCurrentDisk(a)))},this.insertNewDisk=function(a,b,c,d){if(2===a||!maxStackReachedMessage(a)){b||(b=2===a?this.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES[0]:this.FORMAT_OPTIONS_MEDIA_TYPES[0]),1===room.netPlayMode&&room.netController.addPeripheralOperationToSend({op:11,d:a,m:b,b:c,u:d});var e=(this.MEDIA_TYPE_INFO[b],"New "+this.MEDIA_TYPE_INFO[b].desc+(c?" Boot":"")+" Disk.dsk"),f=images.createNewDisk(b,d),g=0===driveStack[a].length||2!==a;g&&driveStack[a].push({}),curDisk[a]=driveStack[a].length-1,replaceCurrentDisk(a,{name:e,content:f}),
c&&images.makeBootDisk(f);var h=g&&driveStack[a].length>1;diskInsertedMessage(a),h&&2!==room.netPlayMode&&self.openDiskSelectDialog(a,0,!0)}},this.removeStack=function(a){if(!noDiskInsertedMessage(a)){var b=driveStack[a].length>1;emptyStack(a),screen.showOSD((b?"Disk Stack in ":"Disk in ")+driveName[a]+" removed",!0),fireMediaStateUpdate(a)}},this.insertDiskFromStack=function(a,b,c){setCurrentDiskNum(a,b),diskInsertedMessage(a),fireMediaStateUpdate(a),autoPower(c)},this.moveDiskInStack=function(a,b,c){var d=driveStack[a];if(!(b<0||c<0||b>d.length-1||c>d.length-1)){var e=d[curDisk[a]];d.splice(c,0,d.splice(b,1)[0]),e&&(curDisk[a]=d.indexOf(e)),fireMediaStateUpdate(a)}},this.saveDiskFile=function(a){if(!noDiskInsertedMessage(a))try{var b=getCurrentDisk(a);fileDownloader.startDownloadBinary(makeFileNameToSave(b.name),b.content.constructor===Uint8Array?b.content:new Uint8Array(b.content),driveName[a]+" Image file")&&(b.modified=!1,fireMotorStateUpdate())}catch(a){}},this.openDiskSelectDialog=function(a,b,c){noDiskInsertedMessage(a)||screen.openDiskSelectDialog(a,b,c)},this.openNewHardDiskDialog=function(a,b){screen.openNewHardDiskDialog(a,b)},this.getDriveStack=function(a){return driveStack[a]},this.getCurrentDiskNum=function(a){return curDisk[a]},this.getCurrentDiskDesc=function(a){return currentDiskDesc(a)},this.getCurrentDiskNumDesc=function(a){return currentDiskNumDesc(a)},this.getDriveName=function(a){return driveName[a]},this.diskHasChanged=function(a){return driveDiskChanged[a]?(driveDiskChanged[a]=!1,!0):driveDiskChanged[a]},this.getTotalSectorsAvailable=function(a){return this.isDiskInserted(a)?getCurrentDisk(a).content.length/BYTES_PER_SECTOR|0:null},this.isDiskInserted=function(a){return!!getCurrentDisk(a)},this.diskWriteProtected=function(a){return!1},this.readByte=function(a,b){if(!this.isDiskInserted(a))return null;var c=getCurrentDisk(a).content;return b>=c.length?null:c[b]},this.readDWord=function(a,b){if(!this.isDiskInserted(a))return null;var c=getCurrentDisk(a).content;return b+3>=c.length?null:c[b]|c[b+1]<<8|c[b+2]<<16|c[b+3]<<24},this.readSectorsToSlot=function(a,b,c,d,e){if(!this.isDiskInserted(a))return!1;var f=getCurrentDisk(a).content,g=b*BYTES_PER_SECTOR,h=c*BYTES_PER_SECTOR;if(g>=f.length||g+h>f.length)return!1;for(var i=0;i<h;i++)d.write(e+i,f[g+i]);return!0},this.writeSectorsFromSlot=function(a,b,c,d,e){var f=getCurrentDisk(a);if(!f)return!1;var g=f.content,h=b*BYTES_PER_SECTOR,i=c*BYTES_PER_SECTOR;if(h>=g.length||h+i>g.length)return!1;for(var j=0;j<i;j++)g[h+j]=d.read(e+j);return f.modified=!0,!0},this.motorOn=function(a){return driveMotorOffTimer[a]&&(clearTimeout(driveMotorOffTimer[a]),driveMotorOffTimer[a]=null),driveMotor[a]?0:(driveMotor[a]=!0,fireMotorStateUpdate(),MOTOR_SPINUP_EXTRA_ITERATIONS[a])},this.motorFlash=function(a){driveMotor[a]||(driveMotor[a]=!0,fireMotorStateUpdate(),motorOff(a))},this.allMotorsOff=function(a){motorOff(0,a),motorOff(1,a),motorOff(2)},this.allMotorsOffNow=function(){driveMotor[0]=driveMotor[1]=driveMotor[2]=!1,fireMotorStateUpdate()},this.formatCurrentDisk=function(a,b){return images.formatDisk(b,getCurrentDisk(a).content)},this.saveState=function(){return clearDisconnectedDiskInterfaces(),{s:[serializeStack(driveStack[0]),serializeStack(driveStack[1]),serializeStack(driveStack[2])],c:curDisk,g:driveDiskChanged,m:driveMotor}},this.loadState=function(a){deserializeStack(a.s[0],driveStack[0]),deserializeStack(a.s[1],driveStack[1]),a.s[2]?deserializeStack(a.s[2],driveStack[2]):clearHardDrive(),curDisk=a.c,driveDiskChanged=a.g,driveMotor=a.m,fireMediaStateUpdate(0),fireMediaStateUpdate(1),fireMediaStateUpdate(2),this.allMotorsOff(!0)},this.eval=function(str){return eval(str)};var images=new wmsx.DiskImages(room),screen,fileDownloader,diskDriveSocket,driveStack=[[],[],[]],curDisk=[0,0,0],driveDiskChanged=[null,null,null],driveMotor=[!1,!1,!1],driveMotorOffTimer=[null,null,null],driveName=["Drive A","Drive B","Hard Drive"],BYTES_PER_SECTOR=512,MOTOR_SPINUP_EXTRA_ITERATIONS=[1e5,1e5,0],MOTOR_SPINDOWN_EXTRA_MILLIS=[2300,2300,50],MAX_STACK=wmsx.FileDiskDrive.MAX_STACK,MEDIA_TYPE_VALID_SIZES=images.MEDIA_TYPE_VALID_SIZES,MEDIA_TYPE_VALID_SIZES_SET=new Set(MEDIA_TYPE_VALID_SIZES),HARDDISK_MIN_SIZE=1024*(WMSX.HARDDISK_MIN_SIZE_KB||720);this.MEDIA_TYPE_INFO=images.MEDIA_TYPE_INFO,this.MEDIA_TYPE_DPB=images.MEDIA_TYPE_DPB,this.FORMAT_OPTIONS_MEDIA_TYPES=images.FORMAT_OPTIONS_MEDIA_TYPES,this.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES=images.HARDDISK_FORMAT_OPTIONS_MEDIA_TYPES,this.HARDDISK_MEDIA_TYPE_HEADER_INFO=images.HARDDISK_MEDIA_TYPE_HEADER_INFO,init()},wmsx.FileDiskDrive.MAX_STACK=10,wmsx.PeripheralControls={SCREEN_ASPECT_PLUS:1,SCREEN_ASPECT_MINUS:2,SCREEN_SCALE_PLUS:3,SCREEN_SCALE_MINUS:4,SCREEN_FULLSCREEN:5,SCREEN_CRT_FILTER:6,SCREEN_CRT_SCANLINES:7,SCREEN_CRT_PHOSPHOR:8,SCREEN_TOGGLE_MENU:9,SCREEN_OPEN_HELP:10,SCREEN_OPEN_ABOUT:11,SCREEN_OPEN_SETTINGS:12,SCREEN_OPEN_QUICK_OPTIONS:13,SCREEN_OPEN_TOUCH_CONFIG:14,SCREEN_OPEN_MACHINE_SELECT:15,SCREEN_TOGGLE_VIRTUAL_KEYBOARD:16,SCREEN_DEFAULTS:17,SPEAKER_BUFFER_TOGGLE:18,MACHINE_POWER_TOGGLE:102,MACHINE_POWER_RESET:103,MACHINE_LOAD_STATE_FILE:104,MACHINE_SAVE_STATE_FILE:105,MACHINE_LOAD_STATE_MENU:106,MACHINE_SAVE_STATE_MENU:107,MACHINE_SELECT:108,EXTENSION_TOGGLE:109,KEYBOARD_TOGGLE_HOST_LAYOUT:201,JOYSTICKS_TOGGLE_MODE:202,JOYKEYS_TOGGLE_MODE:203,MOUSE_TOGGLE_MODE:204,MOUSE_TOGGLE_LOCK:205,TOUCH_TOGGLE_MODE:206,TOUCH_TOGGLE_DIR_BIG:207,TOUCH_TOGGLE_MIRRORED:208,HAPTIC_FEEDBACK_TOGGLE_MODE:209,TURBO_FIRE_TOGGLE:210,COPY_STRING:301,OPEN_PASTE_STRING:302,OPEN_ENTER_STRING:303,CAPTURE_SCREEN:304,DISK_LOAD_FILES:20,DISK_ADD_FILES:21,DISK_LOAD_URL:22,DISK_LOAD_FILES_AS_DISK:23,DISK_LOAD_ZIP_AS_DISK:24,DISK_REMOVE:25,DISK_EMPTY:26,DISK_BOOT:27,DISK_SAVE_FILE:29,DISK_SELECT:30,DISK_PREVIOUS:31,DISK_NEXT:32,DISK_INSERT:33,DISK_MOVE:34,HARDDISK_LOAD_FILE:40,HARDDISK_LOAD_URL:42,HARDDISK_LOAD_FILES_AS_DISK:43,HARDDISK_LOAD_ZIP_AS_DISK:44,HARDDISK_REMOVE:45,HARDDISK_CHOOSE_EMPTY:46,HARDDISK_CHOOSE_BOOT:47,HARDDISK_NEW:48,HARDDISK_SAVE_FILE:49,CARTRIDGE_LOAD_FILE:50,CARTRIDGE_LOAD_URL:52,CARTRIDGE_REMOVE:53,CARTRIDGE_LOAD_DATA_FILE:54,CARTRIDGE_SAVE_DATA_FILE:55,CARTRIDGE_CHOOSE_FORMAT:56,TAPE_LOAD_FILE:60,TAPE_LOAD_URL:62,TAPE_REMOVE:63,TAPE_EMPTY:64,TAPE_SAVE_FILE:65,TAPE_REWIND:66,TAPE_TO_END:67,TAPE_SEEK_FWD:68,TAPE_SEEK_BACK:69,TAPE_AUTO_RUN:70,AUTO_LOAD_FILE:80,AUTO_LOAD_URL:81,SCREEN_OPEN_NETPLAY:500},wmsx.DOMPeripheralControls=function(a){"use strict";function b(a,c,e,u,v){var w=e?1:0;switch(a){case r.MACHINE_POWER_TOGGLE:f.processControlState(wmsx.MachineControls.POWER,!0,c);break;case r.MACHINE_POWER_RESET:f.processControlState(wmsx.MachineControls.POWER,!0,!0);break;case r.MACHINE_LOAD_STATE_FILE:v&&d(a)||o.openFileChooserDialog(z.STATE,!1,0,!1);break;case r.MACHINE_SAVE_STATE_FILE:case r.TAPE_AUTO_RUN:if(e)return p.userTypeCurrentAutoRunCommand();v&&d(a)||f.processControlState(wmsx.MachineControls.SAVE_STATE_FILE,!0);break;case r.MACHINE_LOAD_STATE_MENU:g.openSaveStateDialog(!1);break;case r.MACHINE_SAVE_STATE_MENU:g.openSaveStateDialog(!0);break;case r.MACHINE_SELECT:k.changeMachine(u);break;case r.EXTENSION_TOGGLE:l.toggleExtension(u,c,e);break;case r.DISK_LOAD_FILES:!s||v&&d(a)||o.openFileChooserDialog(z.DISK,c,w,!1);break;case r.DISK_ADD_FILES:!s||v&&d(a)||o.openFileChooserDialog(z.DISK,c,w,!0);break;case r.DISK_LOAD_URL:!s||v&&d(a)||o.openURLChooserDialog(z.DISK,c,w);break;case r.DISK_LOAD_FILES_AS_DISK:!s||v&&d(a)||o.openFileChooserDialog(z.FILES_AS_DISK,c,w,!1);break;case r.DISK_LOAD_ZIP_AS_DISK:!s||v&&d(a)||o.openFileChooserDialog(z.ZIP_AS_DISK,c,w,!1);break;case r.DISK_REMOVE:!s||v&&d(a)||q.removeStack(w);break;case r.DISK_EMPTY:!s||v&&d(a)||q.insertNewDisk(w);break;case r.DISK_BOOT:!s||v&&d(a)||q.insertNewDisk(w,null,!0);break;case r.DISK_SAVE_FILE:!s||v&&d(a)||q.saveDiskFile(w);break;case r.DISK_SELECT:s&&q.openDiskSelectDialog(w,0,c);break
;case r.DISK_PREVIOUS:s&&q.openDiskSelectDialog(w,-1,c);break;case r.DISK_NEXT:s&&q.openDiskSelectDialog(w,1,c);break;case r.DISK_INSERT:q.insertDiskFromStack(u.d,u.n,u.a);break;case r.DISK_MOVE:q.moveDiskInStack(u.d,u.f,u.t);break;case r.CARTRIDGE_LOAD_FILE:v&&d(a)||o.openFileChooserDialog(z.ROM,c,w,!1);break;case r.CARTRIDGE_LOAD_URL:v&&d(a)||o.openURLChooserDialog(z.ROM,c,w);break;case r.CARTRIDGE_REMOVE:v&&d(a)||m.removeCartridge(w,c);break;case r.CARTRIDGE_LOAD_DATA_FILE:if(j.dataOperationNotSupportedMessage(w,!1,!1))break;o.openFileChooserDialog(z.CART_DATA,c,w,!1);break;case r.CARTRIDGE_SAVE_DATA_FILE:m.saveCartridgeDataFile(w);break;case r.CARTRIDGE_CHOOSE_FORMAT:v&&d(a)||g.openCartridgeFormatDialog(w,c);break;case r.HARDDISK_LOAD_FILE:case r.TAPE_LOAD_FILE:if(!v||!d(a)){if(!e&&t)return o.openFileChooserDialog(z.DISK,c,2,!1);o.openFileChooserDialog(z.TAPE,c,0,!1)}break;case r.HARDDISK_LOAD_URL:case r.TAPE_LOAD_URL:if(!v||!d(a)){if(!e&&t)return o.openURLChooserDialog(z.DISK,c,2);o.openURLChooserDialog(z.TAPE,c,0)}break;case r.HARDDISK_LOAD_FILES_AS_DISK:v&&d(a)||o.openFileChooserDialog(z.FILES_AS_DISK,c,2,!1);break;case r.HARDDISK_LOAD_ZIP_AS_DISK:v&&d(a)||o.openFileChooserDialog(z.ZIP_AS_DISK,c,2,!1);break;case r.HARDDISK_REMOVE:case r.TAPE_REMOVE:if(!v||!d(a)){if(!e&&t)return q.removeStack(2);p.userRemoveTape()}break;case r.HARDDISK_CHOOSE_EMPTY:case r.TAPE_EMPTY:if(!v||!d(a)){if(!e&&t)return q.openNewHardDiskDialog(c,!1);p.userLoadEmptyTape()}break;case r.HARDDISK_CHOOSE_BOOT:v&&d(a)||q.openNewHardDiskDialog(c,!0);break;case r.HARDDISK_NEW:q.insertNewDisk(2,u.m,u.b);break;case r.HARDDISK_SAVE_FILE:case r.TAPE_SAVE_FILE:if(!e&&t)return q.saveDiskFile(2);v&&d(a)||p.saveTapeFile();break;case r.TAPE_REWIND:p.userRewind();break;case r.TAPE_TO_END:p.userSeekToEnd();break;case r.TAPE_SEEK_BACK:p.userSeekBackward();break;case r.TAPE_SEEK_FWD:p.userSeekForward();break;case r.AUTO_LOAD_FILE:if(!v||!d(a)){var x=e?-1:void 0;o.openFileChooserDialog(z.AUTO,c,x,!1)}break;case r.AUTO_LOAD_URL:if(!v||!d(a)){var x=e?-1:void 0;o.openURLChooserDialog(z.AUTO,c,x,!1)}break;case r.SCREEN_CRT_FILTER:h.crtFilterToggle(e);break;case r.SCREEN_CRT_SCANLINES:h.crtScanlinesToggle(e);break;case r.SCREEN_CRT_PHOSPHOR:h.crtPhosphorToggle(e);break;case r.SCREEN_FULLSCREEN:h.fullscreenToggle(e);break;case r.SCREEN_DEFAULTS:f.processControlState(wmsx.MachineControls.DEFAULTS,!0),h.setDefaults();break;case r.SCREEN_TOGGLE_MENU:g.toggleMenuByKey();break;case r.SCREEN_OPEN_HELP:g.openHelp();break;case r.SCREEN_OPEN_ABOUT:g.openAbout();break;case r.SCREEN_OPEN_SETTINGS:if(c)return b(r.SCREEN_DEFAULTS,!1,!1,null,v);g.openSettings();break;case r.SCREEN_OPEN_QUICK_OPTIONS:g.openQuickOptionsDialog();break;case r.SCREEN_OPEN_TOUCH_CONFIG:g.openTouchConfigDialog();break;case r.SCREEN_OPEN_MACHINE_SELECT:g.openMachineSelectDialog();break;case r.SCREEN_TOGGLE_VIRTUAL_KEYBOARD:g.toggleVirtualKeyboard();break;case r.SCREEN_OPEN_NETPLAY:g.openNetPlayDialog();break;case r.KEYBOARD_TOGGLE_HOST_LAYOUT:n.toggleKeyboardLayout(e);break;case r.JOYSTICKS_TOGGLE_MODE:n.toggleJoystickMode(e);break;case r.JOYKEYS_TOGGLE_MODE:n.toggleJoykeysMode(e);break;case r.MOUSE_TOGGLE_MODE:n.toggleMouseMode(e);break;case r.MOUSE_TOGGLE_LOCK:n.toggleMouseLock();break;case r.TOUCH_TOGGLE_MODE:n.toggleTouchControlsMode(c,e);break;case r.TOUCH_TOGGLE_DIR_BIG:n.getTouchControls().toggleDirBig();break;case r.TOUCH_TOGGLE_MIRRORED:n.getTouchControls().toggleMirrored();break;case r.TURBO_FIRE_TOGGLE:n.toggleTurboFireSpeed(e);break;case r.HAPTIC_FEEDBACK_TOGGLE_MODE:n.toggleHapticFeedback();break;case r.COPY_STRING:g.executeTextCopy();break;case r.OPEN_PASTE_STRING:g.toggleTextPasteDialog();break;case r.OPEN_ENTER_STRING:g.toggleTextEntryDialog();break;case r.CAPTURE_SCREEN:g.saveScreenCapture();break;case r.SPEAKER_BUFFER_TOGGLE:i.toggleBufferBaseSize(e)}if(!ja)switch(a){case r.SCREEN_ASPECT_MINUS:h.displayAspectDecrease();break;case r.SCREEN_ASPECT_PLUS:h.displayAspectIncrease();break;case r.SCREEN_SCALE_MINUS:h.displayScaleDecrease();break;case r.SCREEN_SCALE_PLUS:h.displayScaleIncrease()}}var c=this;this.connect=function(a,b,c){k=a,l=b,j=c},this.connectPeripherals=function(a,b,c,d,e,j,k,l){m=a,f=b,g=c,i=d,h=c.getMonitor(),n=e,o=j,p=k,q=l},this.getControlReport=function(a){switch(a){case r.TOUCH_TOGGLE_DIR_BIG:case r.TOUCH_TOGGLE_MIRRORED:case r.TURBO_FIRE_TOGGLE:case r.HAPTIC_FEEDBACK_TOGGLE_MODE:return n.getControlReport(a);case r.SCREEN_CRT_FILTER:case r.SCREEN_CRT_SCANLINES:return g.getControlReport(a);case r.SPEAKER_BUFFER_TOGGLE:return i.getControlReport(a)}return{label:"Unknown",active:!1}},this.diskInterfacesStateUpdate=function(a,b){s=a,t=b},this.processKey=function(a,b){if(!b)return!1;var d=u[a&x];return!!d&&(c.processControlActivated(d,!1,!!(a&y)),!0)},this.processControlActivated=function(c,d,e,f){if(!ma.has(c)){if(2===a.netPlayMode&&(ka.has(c)||la.has(c)))return a.showOSD("Function not available in NetPlay Client mode",!0,!0);if(1===a.netPlayMode&&ka.has(c)||v.push({c:c<<4|d<<1|e,d:f}),2===a.netPlayMode)return}b(c,d,e,f,!0)};var d=function(b){return WMSX.MEDIA_CHANGE_DISABLED?(h.showOSD("Media operations are disabled!",!0,!0),!0):!(2!==a.netPlayMode||b&&!ka.has(b)&&!la.has(b))&&(h.showOSD("Media operations are disabled in NetPlay Client mode!",!0,!0),!0)};this.mediaChangeDisabledWarning=d;var e=function(){var a=w;u[ha|a.CONTROL]=r.AUTO_LOAD_FILE,u[ha|a.CONTROL|a.ALT]=r.AUTO_LOAD_URL,u[ia|a.CONTROL|a.ALT]=r.MACHINE_SAVE_STATE_FILE,u[L]=r.DISK_LOAD_FILES,u[L|a.CONTROL]=r.DISK_EMPTY,u[L|a.ALT]=r.DISK_REMOVE,u[L|a.CONTROL|a.ALT]=r.DISK_SAVE_FILE,u[T|a.ALT]=r.DISK_SELECT,u[U|a.ALT]=r.DISK_SELECT,u[V|a.ALT]=r.DISK_PREVIOUS,u[W|a.ALT]=r.DISK_NEXT,u[M]=r.CARTRIDGE_LOAD_FILE,u[M|a.ALT]=r.CARTRIDGE_REMOVE,u[M|a.CONTROL]=r.CARTRIDGE_LOAD_DATA_FILE,u[M|a.CONTROL|a.ALT]=r.CARTRIDGE_SAVE_DATA_FILE,u[N]=r.TAPE_LOAD_FILE,u[N|a.CONTROL]=r.TAPE_EMPTY,u[N|a.ALT]=r.TAPE_REMOVE,u[N|a.CONTROL|a.ALT]=r.TAPE_SAVE_FILE,u[O|a.CONTROL|a.ALT]=r.TAPE_AUTO_RUN,u[P|a.CONTROL|a.ALT]=r.TAPE_REWIND,u[Q|a.CONTROL|a.ALT]=r.TAPE_TO_END,u[R|a.CONTROL|a.ALT]=r.TAPE_SEEK_BACK,u[S|a.CONTROL|a.ALT]=r.TAPE_SEEK_FWD,u[X|a.ALT]=r.KEYBOARD_TOGGLE_HOST_LAYOUT,u[Y|a.ALT]=r.JOYSTICKS_TOGGLE_MODE,u[Z|a.ALT]=r.JOYKEYS_TOGGLE_MODE,u[$|a.ALT]=r.MOUSE_TOGGLE_MODE,u[_|a.ALT]=r.MOUSE_TOGGLE_LOCK,u[aa|a.ALT]=r.TOUCH_TOGGLE_MODE,u[ba|a.ALT]=r.TURBO_FIRE_TOGGLE,u[ca|a.ALT]=r.SCREEN_CRT_FILTER,u[da|a.ALT]=r.SCREEN_CRT_SCANLINES,u[ea|a.ALT]=r.SCREEN_OPEN_QUICK_OPTIONS,u[fa|a.ALT]=r.SCREEN_OPEN_TOUCH_CONFIG,u[ga|a.ALT]=r.SCREEN_FULLSCREEN,u[B|a.CONTROL|a.ALT]=r.SCREEN_SCALE_MINUS,u[D|a.CONTROL|a.ALT]=r.SCREEN_SCALE_PLUS,u[A|a.CONTROL|a.ALT]=r.SCREEN_ASPECT_MINUS,u[C|a.CONTROL|a.ALT]=r.SCREEN_ASPECT_PLUS,u[E]=r.SCREEN_TOGGLE_MENU,u[F|a.ALT]=r.SCREEN_DEFAULTS,u[G|a.ALT]=r.COPY_STRING,u[H|a.ALT]=r.OPEN_PASTE_STRING,u[I|a.ALT]=r.OPEN_PASTE_STRING,u[J|a.ALT]=r.OPEN_ENTER_STRING,u[K|a.ALT]=r.CAPTURE_SCREEN};this.netGetControlsToSend=function(){return v.length?v:void 0},this.netClearControlsToSend=function(){v.length=0},this.netServerProcessControlsChanges=function(a){for(var c=0,d=a.length;c<d;++c){var e=a[c];ka.has(e.c>>4)||v.push(e),b(e.c>>4,e.c>>1&1,1&e.c,e.d)}},this.netClientApplyControlsChanges=function(a){for(var c=0,d=a.length;c<d;++c){var e=a[c];b(e.c>>4,e.c>>1&1,1&e.c,e.d)}};var f,g,h,i,j,k,l,m,n,o,p,q,r=wmsx.PeripheralControls,s=!1,t=!1,u={},v=new Array(100);v.length=0;var w=wmsx.DOMKeys,x=~w.SHIFT,y=w.SHIFT,z=wmsx.FileLoader.OPEN_TYPE,A=w.VK_LEFT.wc,B=w.VK_UP.wc,C=w.VK_RIGHT.wc,D=w.VK_DOWN.wc,E=w.VK_CONTEXT.wc,F=w.VK_BACKSPACE.wc,G=w.VK_C.wc,H=w.VK_V.wc,I=w.VK_INSERT.wc,J=w.VK_B.wc,K=w.VK_G.wc,L=w.VK_F6.wc,M=w.VK_F7.wc,N=(w.VK_F8.wc,
w.VK_F8.wc),O=w.VK_F12.wc,P=w.VK_HOME.wc,Q=w.VK_END.wc,R=w.VK_PAGE_UP.wc,S=w.VK_PAGE_DOWN.wc,T=w.VK_HOME.wc,U=w.VK_END.wc,V=w.VK_PAGE_UP.wc,W=w.VK_PAGE_DOWN.wc,X=w.VK_L.wc,Y=w.VK_J.wc,Z=w.VK_K.wc,$=w.VK_M.wc,_=w.VK_CAPS_LOCK.wc,aa=w.VK_N.wc,ba=w.VK_H.wc,ca=w.VK_E.wc,da=w.VK_R.wc,ea=w.VK_U.wc,fa=w.VK_I.wc,ga=w.VK_ENTER.wc,ha=w.VK_F11.wc,ia=w.VK_F12.wc,ja=WMSX.SCREEN_RESIZE_DISABLED,ka=new Set([r.MACHINE_LOAD_STATE_FILE,r.MACHINE_SAVE_STATE_FILE,r.MACHINE_LOAD_STATE_MENU,r.MACHINE_SAVE_STATE_MENU,r.MACHINE_SELECT,r.SCREEN_OPEN_MACHINE_SELECT,r.EXTENSION_TOGGLE,r.DISK_LOAD_FILES,r.DISK_ADD_FILES,r.DISK_LOAD_URL,r.DISK_LOAD_FILES_AS_DISK,r.DISK_LOAD_ZIP_AS_DISK,r.DISK_SAVE_FILE,r.DISK_EMPTY,r.DISK_BOOT,r.DISK_SELECT,r.DISK_PREVIOUS,r.DISK_NEXT,r.HARDDISK_LOAD_FILE,r.HARDDISK_LOAD_URL,r.HARDDISK_LOAD_FILES_AS_DISK,r.HARDDISK_LOAD_ZIP_AS_DISK,r.HARDDISK_SAVE_FILE,r.HARDDISK_CHOOSE_EMPTY,r.HARDDISK_CHOOSE_BOOT,r.HARDDISK_NEW,r.CARTRIDGE_LOAD_FILE,r.CARTRIDGE_LOAD_URL,r.CARTRIDGE_LOAD_DATA_FILE,r.CARTRIDGE_SAVE_DATA_FILE,r.CARTRIDGE_CHOOSE_FORMAT,r.TAPE_LOAD_FILE,r.TAPE_LOAD_URL,r.TAPE_SAVE_FILE,r.AUTO_LOAD_FILE,r.AUTO_LOAD_URL]),la=new Set([r.DISK_MOVE,r.DISK_INSERT,r.DISK_REMOVE,r.HARDDISK_REMOVE,r.CARTRIDGE_REMOVE,r.TAPE_EMPTY,r.TAPE_REWIND,r.TAPE_TO_END,r.TAPE_SEEK_FWD,r.TAPE_SEEK_BACK,r.TAPE_REMOVE]),ma=new Set([r.SCREEN_ASPECT_PLUS,r.SCREEN_ASPECT_MINUS,r.SCREEN_SCALE_PLUS,r.SCREEN_SCALE_MINUS,r.SCREEN_FULLSCREEN,r.SCREEN_CRT_FILTER,r.SCREEN_CRT_SCANLINES,r.SCREEN_CRT_PHOSPHOR,r.SCREEN_TOGGLE_MENU,r.SCREEN_OPEN_HELP,r.SCREEN_OPEN_ABOUT,r.SCREEN_OPEN_SETTINGS,r.SCREEN_OPEN_QUICK_OPTIONS,r.SCREEN_OPEN_TOUCH_CONFIG,r.SCREEN_TOGGLE_VIRTUAL_KEYBOARD,r.SCREEN_DEFAULTS,r.SPEAKER_BUFFER_TOGGLE,r.MACHINE_POWER_TOGGLE,r.MACHINE_POWER_RESET,r.KEYBOARD_TOGGLE_HOST_LAYOUT,r.JOYSTICKS_TOGGLE_MODE,r.JOYKEYS_TOGGLE_MODE,r.TOUCH_TOGGLE_MODE,r.TOUCH_TOGGLE_DIR_BIG,r.TOUCH_TOGGLE_MIRRORED,r.HAPTIC_FEEDBACK_TOGGLE_MODE,r.TURBO_FIRE_TOGGLE,r.COPY_STRING,r.OPEN_PASTE_STRING,r.OPEN_ENTER_STRING,r.CAPTURE_SCREEN,r.SCREEN_OPEN_NETPLAY]);!function(){e()}()},wmsx.NetServer=function(a){"use strict";function b(){void 0===v&&(v=setInterval(p,3e4));var a={sessionControl:"createSession",sessionType:wmsx.NetServer.SESSION_TYPE_VERSION,wsOnly:D,queryVariables:["RTC_CONFIG","RTC_DATA_CHANNEL_CONFIG"]};u&&(a.sessionID=u),s.send(JSON.stringify(a))}function c(){r.stopSession(!0,v?"NetPlay Session stopped: Connection lost":"NetPlay: Connection error")}function d(a){var b=JSON.parse(a.data);if(b.wmsxUpdate){var c=E[a.clientNick];return void(c&&o(c,b.wmsxUpdate))}if(b.sessionControl)switch(b.sessionControl){case"sessionCreated":return void e(b);case"clientJoined":return void f(b);case"clientLeft":return void g(b);case"createError":return void r.stopSession(!0,"NetPlay: "+b.errorMessage)}else b.clientSDP&&h(b)}function e(b){try{G=JSON.parse(b.queriedVariables.RTC_CONFIG||"{}")}catch(a){}try{H=JSON.parse(b.queriedVariables.RTC_DATA_CHANNEL_CONFIG||"{}")}catch(a){}t=b.sessionID,x.netClearControlsToSend(),y.netClearMatrixChangesToSend(),z.netClearInfoToSend(),z.netServerClearClientsMergedInfo(),A.netClearControlsToSend(),F.length=0,a.enterNetServerMode(r),a.showOSD('NetPlay session "'+b.sessionID+'" started',!0),wmsx.Util.log('NetPlay session "'+b.sessionID+'" started')}function f(b){var c={nick:b.clientNick,justJoined:!0,wsOnly:D||!!b.wsOnly};if(E[c.nick]=c,a.showOSD('NetPlay client "'+c.nick+'" joined',!0),wmsx.Util.log('NetPlay client "'+c.nick+'" joined'),!c.wsOnly){var d=new RTCPeerConnection(G);c.rtcConnection=d,d.onicecandidate=function(a){a.candidate||(wmsx.Util.log("Server SDP for client "+c.nick+":",d.localDescription),s.send(JSON.stringify({toClientNick:c.nick,serverSDP:d.localDescription})))};var e=d.createDataChannel("dataChannel",H);c.dataChannel=e,e.onopen=function(a){i(c,a)},e.onclose=function(a){j(c,a)},e.onmessage=function(a){k(c,a)},d.createOffer().then(function(a){return d.setLocalDescription(a)}).catch(function(a){l(c,a)})}}function g(a){var b=E[a.clientNick];b&&n(b,!0,!1,'NetPlay client "'+b.nick+'" left')}function h(a){var b=E[a.fromClientNick];b&&(wmsx.Util.log("Client SDP from client "+b.nick+":",a.clientSDP),b.rtcConnection.setRemoteDescription(new RTCSessionDescription(a.clientSDP)).catch(l))}function i(a,b){wmsx.Util.log("Client "+a.nick+" dataChannel open"),a.dataChannelActive=!0}function j(a,b){wmsx.Util.error("NetPlay Client "+a.nick+" dataChannel closed"),n(a,!0,!0,'NetPlay client "'+a.nick+'" dropped: P2P connection lost')}function k(a,b){o(a,JSON.parse(b.data))}function l(a,b){wmsx.Util.error("NetPlay Client "+a.nick+" RTC error:",b),n(a,!0,!0,'NetPlay client "'+a.nick+'" dropped: P2P connection error')}function m(){for(var a in E)n(E[a],!1)}function n(b,c,d,e){c&&(a.showOSD(e||'NetPlay client "'+b.nick+'" left',!0,d),(d?wmsx.Util.error:wmsx.Util.log)(e||'NetPlay client "'+b.nick+'" left')),b.dataChannel&&(b.dataChannel.onopen=b.dataChannel.onclose=b.dataChannel.onmessage=void 0,b.dataChannel.close()),b.rtcConnection&&(b.rtcConnection.onicecandidate=void 0,b.rtcConnection.close()),delete E[b.nick]}function o(a,b){b.c&&x.netServerProcessControlsChanges(b.c),b.k&&y.netServerProcessMatrixChanges(b.k),b.pc&&A.netServerProcessControlsChanges(b.pc),b.ch&&z.netServerReceiveClientInfo(a,b.ch)}function p(){try{s.send('{ "sessionControl": "keep-alive" }')}catch(a){wmsx.Util.error("NetPlay error sending keep-alive"),r.stopSession(!0,"NetPlay Session stopped: connection error")}}function q(a,b){var c=b.length;if(c<I)return a.send(b);for(var d=0,e=0;;){var f=b.substr(e,J);if(e+=J,d++,!(e<c))return void a.send(L+f);a.send(K+f)}}var r=this;this.startSession=function(e){u=e?(""+e).trim():void 0;var f;u&&"@"===u[u.length-1]?(u=u.substr(0,u.length-1),f=!0):f=!1,u&&t===u&&D===f||(t&&this.stopSession(!0),a.enterNetPendingMode(this),D=f,s?b():(s=new WebSocket("wss://"+WMSX.WEB_EXTENSIONS_SERVER),s.onmessage=d,s.onopen=b,s.onclose=c))},this.stopSession=function(b,c){clearInterval(v),v=void 0,s&&(s.onmessage=s.onopen=s.onclose=void 0,s.close(),s=void 0),b?m():setTimeout(m,300),a.showOSD(c||'NetPlay Session "'+t+'" stopped',!0,b),(b?wmsx.Util.error:wmsx.Util.log)(c||'NetPlay Session "'+t+'" stopped'),t=void 0,a.enterStandaloneMode()},this.getSessionID=function(){return t},this.netVideoClockPulse=function(){z.controllersClockPulse();var b,c,d,e;for(var f in E){var g=E[f];if(g.wsOnly||g.dataChannelActive){if(g.justJoined||C){if(g.justJoined=!1,!c){e=w.systemPause(!0);var h={vf:a.mainVideoClock.getVSynchNativeFrequency(),s:w.saveState(!0),ks:y.saveState(),cm:z.netServerGetControlsModes(),ch:z.netServerGetFullInfo()};c=JSON.stringify(h)}b=c}else d||(B.c=x.netGetControlsToSend(),B.k=y.netGetMatrixChangesToSend(),B.ch=z.netGetInfoToSend(),B.pc=A.netGetControlsToSend(),B.po=F.length?F:void 0,d=JSON.stringify(B)),b=d;try{g.dataChannelActive?q(g.dataChannel,b):s.send(JSON.stringify({toClientNick:g.nick,wmsxUpdate:b}))}catch(a){n(g,!0,!0,'NetPlay client "'+g.nick+'" dropped: P2P error sending data')}}}C=!1,x.netClearControlsToSend(),y.netClearMatrixChangesToSend(),z.netClearInfoToSend(),A.netClearControlsToSend(),F.length=0,w.videoClockPulse(),!1===e&&w.systemPause(!1)},this.addPeripheralOperationToSend=function(a){F.push(a)},this.processExternalStateChange=function(){C=!0};var s,t,u,v,w=a.machine,x=a.machineControls,y=a.keyboard,z=(a.cartridgeSlot,a.controllersHub),A=a.peripheralControls,B=(a.diskDrive,a.cassetteDeck,{c:void 0,k:void 0,cp:void 0}),C=!1,D=!1,E={};this.clients=E;var F=new Array(10);F.length=0;var G,H,I=16300,J=16200,K="#@FrgS@#",L="#@FrgE@#"},wmsx.NetServer.SESSION_TYPE_VERSION="wmsx530",wmsx.NetClient=function(a){"use strict";function b(){void 0===w&&(w=setInterval(o,3e4)),r.send(JSON.stringify({sessionControl:"joinSession",sessionType:wmsx.NetServer.SESSION_TYPE_VERSION,sessionID:t,clientNick:v,wsOnly:I,queryVariables:["RTC_CONFIG"]}))}function c(){
q.leaveSession(!0,w?"NetPlay session ended: Connection lost":"NetPlay: Connection error")}function d(a){var b=JSON.parse(a.data);if(b.wmsxUpdate)return m(JSON.parse(b.wmsxUpdate));if(b.sessionControl)switch(b.sessionControl){case"sessionJoined":return void e(b);case"sessionDestroyed":return void q.leaveSession(!1,'NetPlay Session "'+s+'" ended');case"joinError":return void q.leaveSession(!0,"NetPlay: "+b.errorMessage)}else b.serverSDP&&g(b)}function e(a){if(s=a.sessionID,u=a.clientNick,K=I||a.wsOnly,J=!0,K)return f();try{x=JSON.parse(a.queriedVariables.RTC_CONFIG||"{}")}catch(a){}y=new RTCPeerConnection(x),y.onicecandidate=function(a){a.candidate||r.send(JSON.stringify({clientSDP:y.localDescription}))},y.ondatachannel=function(a){z=a.channel,z.onopen=h,z.onclose=i,z.onmessage=j}}function f(){a.showOSD('NetPlay Session "'+s+'" joined as "'+u+'"',!0),wmsx.Util.log('NetPlay Session "'+s+'" joined as "'+u+'"'),B.netClearControlsToSend(),C.netClearMatrixChangesToSend(),D.netClearInfoToSend(),E.netClearControlsToSend(),a.enterNetClientMode(q)}function g(a){y.setRemoteDescription(new RTCSessionDescription(a.serverSDP)).then(function(){return y.createAnswer()}).then(function(a){return y.setLocalDescription(a)}).catch(k)}function h(a){L=!0,M="",f()}function i(a){wmsx.Util.error("NetPlay dataChannel closed"),q.leaveSession(!0,"NetPlay session ended: P2P connection lost")}function j(a){var b=p(a);b&&m(JSON.parse(b))}function k(a){wmsx.Util.error("NetPlay RTC error:",a),q.leaveSession(!0,"NetPlay session ended: P2P connection error")}function l(){z&&(z.onpen=z.onclose=z.onmessage=void 0,z.close(),z=void 0),y&&(y.onicecandidate=y.ondatachannel=void 0,y.close(),y=void 0)}function m(b){D.controllersClockPulse();var c={c:B.netGetControlsToSend(),k:C.netGetMatrixChangesToSend(),ch:D.netGetInfoToSend(),pc:E.netGetControlsToSend()};if(L?z.send(JSON.stringify(c)):r.send(JSON.stringify({wmsxUpdate:c})),B.netClearControlsToSend(),C.netClearMatrixChangesToSend(),D.netClearInfoToSend(),E.netClearControlsToSend(),b.s){var d=A.systemPause(!0);a.mainVideoClock.setVSynchAltNativeFrequency(b.vf),A.loadState(b.s),C.loadState(b.ks),J&&(D.netClientAdaptToServerControlsModes(b.cm),J=!1),D.netClientReceiveServerInfo(b.ch),A.systemPause(d)}else b.c&&B.netClientApplyControlsChanges(b.c),b.k&&C.netClientApplyMatrixChanges(b.k),b.ch&&D.netClientReceiveServerInfo(b.ch),b.pc&&E.netClientApplyControlsChanges(b.pc),b.po&&n(b.po);A.videoClockPulse()}function n(a){for(var b=0,c=a.length;b<c;++b){var d=a[b];switch(d.op){case 0:F.insertSerializedCartridge(d.c,d.p,d.a);break;case 1:F.loadSerializedCartridgeData(d.p,d.n,d.c);break;case 10:G.loadSerializedStack(d.d,d.s,d.t,d.p,d.a);break;case 11:G.insertNewDisk(d.d,d.m,d.b,d.u);break;case 12:G.replaceCurrentDiskSerialized(d.d,d.k);break;case 20:H.loadSerializedTape(d.n,d.c,d.p)}}}function o(){try{r.send('{ "sessionControl": "keep-alive" }')}catch(a){wmsx.Util.error("NetPlay error sending keep-alive"),q.leaveSession(!0,"NetPlay session ended: Connection error")}}function p(a){var b=a.data,c=b.substr(0,8);return c!==N&&c!==O?(M="",b):(M+=b.substr(8),c===O?(b=M,M="",b):void 0)}var q=this;this.joinSession=function(e,f){if(!(t=(""+e).trim()))return a.showOSD("Must enter Session Name for joining NetPlay session",!0,!0);var g;"@"===t[t.length-1]?(t=t.substr(0,t.length-1),g=!0):g=!1,v=f,I=g,s===t&&u===v&&K===I||(s&&this.leaveSession(!0),a.enterNetPendingMode(this),r?b():(r=new WebSocket("wss://"+WMSX.WEB_EXTENSIONS_SERVER),r.onmessage=d,r.onopen=b,r.onclose=c))},this.leaveSession=function(b,c){clearInterval(w),w=void 0,s=u=void 0,K=!1,r&&(r.onpen=r.onclose=r.onmessage=void 0,r.close(),r=void 0),z&&(z.onpen=z.onclose=z.onmessage=void 0),y&&(y.onicecandidate=y.ondatachannel=void 0),L=!1,M="",b?l():setTimeout(l,300),a.showOSD(c||"NetPlay session ended",!0,b),(b?wmsx.Util.error:wmsx.Util.log)(c||"NetPlay session ended"),a.enterStandaloneMode()},this.getSessionID=function(){return s},this.netVideoClockPulse=function(){},this.processExternalStateChange=function(){a.screen.quickOptionsControlsStateUpdate()};var r,s,t,u,v,w,x,y,z,A=a.machine,B=a.machineControls,C=a.keyboard,D=a.controllersHub,E=a.peripheralControls,F=a.cartridgeSlot,G=a.diskDrive,H=a.cassetteDeck,I=!1,J=!1,K=!1,L=!1,M="",N="#@FrgS@#",O="#@FrgE@#"},wmsx.Room=function(a,b){"use strict";function c(a){var b=WMSX.AUTO_POWER_ON_DELAY;b>=0&&WMSXFullScreenSetup.shouldStartInFullScreen()&&(b+=1400),b-=Date.now()-i,b<1&&(b=1),setTimeout(a,b)}function d(){b&&h.machine.userPowerOn(!0)}function e(){h.mainVideoClock=new wmsx.Clock(h.mainVideoClockPulse)}function f(){h.peripheralControls=new wmsx.DOMPeripheralControls(h),h.machineControls=new wmsx.DOMMachineControls(h,h.peripheralControls),h.controllersHub=new wmsx.ControllersHub(h,h.machineControls),h.keyboard=h.controllersHub.getKeyboard(),h.fileDownloader=new wmsx.FileDownloader,h.stateMedia=new wmsx.SaveStateMedia(h),h.cartridgeSlot=new wmsx.FileCartridgeSlot(h),h.cassetteDeck=new wmsx.FileCassetteDeck(h),h.diskDrive=new wmsx.FileDiskDrive(h),h.fileLoader=new wmsx.FileLoader(h),h.screen=new wmsx.CanvasDisplay(h,a),h.speaker=new wmsx.WebAudioSpeaker(a),h.fileLoader.connectPeripherals(h.screen,h.peripheralControls,h.cartridgeSlot,h.cassetteDeck,h.diskDrive),h.fileDownloader.connectPeripherals(h.screen),h.screen.connectPeripherals(h.cartridgeSlot,h.fileLoader,h.fileDownloader,h.machineControls,h.peripheralControls,h.controllersHub,h.diskDrive,h.stateMedia),h.speaker.connectPeripherals(h.screen),h.machineControls.connectPeripherals(h.screen),h.controllersHub.connectPeripherals(h.screen),h.stateMedia.connectPeripherals(h.fileDownloader),h.cartridgeSlot.connectPeripherals(h.fileDownloader),h.cassetteDeck.connectPeripherals(h.screen,h.fileDownloader),h.diskDrive.connectPeripherals(h.screen,h.fileDownloader),h.peripheralControls.connectPeripherals(h.cartridgeSlot,h.machineControls,h.screen,h.speaker,h.controllersHub,h.fileLoader,h.cassetteDeck,h.diskDrive)}function g(){h.machine=new wmsx.Machine,h.mainVideoClock.connect(h.machine.getVideoClockSocket()),h.stateMedia.connect(h.machine.getSavestateSocket()),h.fileLoader.connect(h.machine),h.screen.connect(h.machine),h.speaker.connect(h.machine.getAudioSocket()),h.machineControls.connect(h.machine.getMachineControlsSocket()),h.controllersHub.connect(h.machine.getMachineTypeSocket(),h.machine.getMachineControlsSocket(),h.machine.getControllersSocket(),h.machine.getBIOSSocket()),h.cartridgeSlot.connect(h.machine.getCartridgeSocket(),h.machine.getExtensionsSocket()),h.cassetteDeck.connect(h.machine.getCassetteSocket()),h.diskDrive.connect(h.machine.getDiskDriveSocket()),h.peripheralControls.connect(h.machine.getMachineTypeSocket(),h.machine.getExtensionsSocket(),h.machine.getCartridgeSocket()),h.machine.socketsConnected()}var h=this;this.powerOn=function(){h.screen.powerOn(),h.speaker.powerOn(),h.controllersHub.powerOn(),h.setLoading(!0),h.enterStandaloneMode(),i=Date.now()},this.powerOff=function(){h.machine.powerOff(),h.controllersHub.powerOff(),h.speaker.powerOff(),h.screen.powerOff()},this.setLoading=function(a){this.isLoading!==a&&(this.isLoading=a,this.machine.setLoading(this.isLoading),this.screen.setLoading(this.isLoading))},this.start=function(a){this.mainVideoClock.detectHostNativeFPSAndCallback(function(b){h.machine.vSynchSetSupported(b>0),h.machine.preStart(),c(function(){h.setLoading(!1),h.screen.start(a||d)})})},this.showOSD=function(a,b,c){this.machine.showOSD(a,b,c)},this.mainVideoClockPulse=function(){h.machine.isSystemPaused()||(h.netController?h.netController.netVideoClockPulse():(h.controllersHub.controllersClockPulse(),h.machine.videoClockPulse()))},this.enterStandaloneMode=function(){var a=this.netPlayMode;this.netPlayMode=0,this.netController=void 0,this.mainVideoClock.setVSynchAltNativeFrequency(void 0),h.mainVideoClock.go(),
this.netPlayStateBeforeClientMode&&(this.machine.loadState(this.netPlayStateBeforeClientMode),this.controllersHub.netClientRestoreControlsModes(this.netPlayControlsModesBeforeClientMode),this.netPlayStateBeforeClientMode=this.netPlayControlsModesBeforeClientMode=void 0),a!==this.netPlayMode&&(this.screen.roomNetPlayStatusChangeUpdate(a),this.controllersHub.roomNetPlayStatusChangeUpdate(a))},this.enterNetServerMode=function(a){var b=this.netPlayMode;this.netPlayMode=1,this.netController=a,this.mainVideoClock.setVSynchAltNativeFrequency(void 0),h.mainVideoClock.go(),b!==this.netPlayMode&&(this.screen.roomNetPlayStatusChangeUpdate(b),this.controllersHub.roomNetPlayStatusChangeUpdate(b))},this.enterNetClientMode=function(a){var b=this.netPlayMode;this.netPlayMode=2,this.netController=a,h.mainVideoClock.pause(),this.netPlayStateBeforeClientMode=this.machine.saveState(!0),this.netPlayControlsModesBeforeClientMode=this.controllersHub.netClientGetControlsModes(),b!==this.netPlayMode&&(this.screen.roomNetPlayStatusChangeUpdate(b),this.controllersHub.roomNetPlayStatusChangeUpdate(b))},this.enterNetPendingMode=function(a){var b=this.netPlayMode;this.netPlayMode=a===this.netServer?-1:-2,this.netController=void 0,h.mainVideoClock.go(),b!==this.netPlayMode&&(this.screen.roomNetPlayStatusChangeUpdate(b),this.controllersHub.roomNetPlayStatusChangeUpdate(b))},this.getNetServer=function(){return this.netServer||(this.netServer=new wmsx.NetServer(this)),this.netServer},this.getNetClient=function(){return this.netClient||(this.netClient=new wmsx.NetClient(this)),this.netClient},this.mainVideoClock=null,this.machine=null,this.screen=null,this.speaker=null,this.machineControls=null,this.controllersHub=null,this.keyboard=null,this.fileDownloader=null,this.cartridgeSlot=null,this.cassetteDeck=null,this.diskDrive=null,this.stateMedia=null,this.fileLoader=null,this.peripheralControls=null,this.netPlayMode=0,this.netController=void 0,this.netServer=void 0,this.netClient=void 0,this.netPlayStateBeforeClientMode=void 0,this.netPlayControlsModesBeforeClientMode=void 0,this.isLoading=!1;var i;this.runFramesAtTopSpeed=function(a){this.mainVideoClock.pause();for(var b=wmsx.Util.performanceNow(),c=0;c<a;c++)h.mainVideoClockPulse();var d=wmsx.Util.performanceNow()-b;wmsx.Util.log("Done running "+a+" frames in "+(0|d)+" ms"),wmsx.Util.log((a/(d/1e3)).toFixed(2)+"  frames/sec"),this.mainVideoClock.go()},function(){e(),f(),g(),WMSX.userROMFormats.init()}()},wmsx.Images.embedded=!0,
wmsx.Images.urls.logo="data:image/png;base64,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",
wmsx.Images.urls.sprites="data:image/png;base64,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",
wmsx.Images.urls.loading="data:image/gif;base64,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",wmsx.Images.urls.mouseCursor="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAABL0lEQVRYw+3VP0oDQRTH8U8k+AcFFRUFERGLiFjEA1jZTo6RG6T3ArmFR9j0WlpaWBiwsNNyiwgW0Vg4CUPELhMt9guPffumeG9nf/MbvlnEYVmWo3a7PcIO1s2R3aT5KQ6wMo/GC/G5nNTWsYr6PHdgE+fJLjRxhFqMbNSxFr96K6nvYxhr7zE+Y8yUWghhNH5pNBr6/f5ksdfrXeA1xiCbBoqiUBSF6RwN7GIptwh/4wR7UyKduQZ0Op1JIc2xHTVSzzpAt9v9sdBqtczTB/6Mfz/A2AOGOYe4DCGMUqI33OAKl1MmNVsjwhmaIYTrxIBu8YA73OMZb7kG2MFhPPPH2ECJJzzG5iU+ch3DMvnfL/HcDxILztZcctPVo9stxXyYCPBDRUVFRUVFRUa+AB+1YCivg1lPAAAAAElFTkSuQmCC",
wmsx.Images.urls.logoMiniBrightBack="data:image/png;base64,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",wmsx.Images.urls.muteIcon="data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAADAAAAAoCAYAAAC4h3lxAAAEwklEQVRYw+2YbWhbZRTH/+fJTdLbuHWsVTc6cK2DtDcJK2GsbAzpUNEPgjAUZYgyFXUZ8wVxm+ua2bjCuo19UDZQRFQCgkw3/CgMi9M6i9Q1uUntRsigww6duOFi3tr790smMaTvXbLq/t+S53Dv+T3nPOc55wK39R9UOp22DQ4OLq/Eu9RCP9A0zVXJZLK7pqbm8UUHEI/H7xeRd0juAVBXCQBtIR6SSCRqM5nMswACAFoAsFLpqi1AyhjZbDYAYBuAWhEByYoBzDmFOjs7VTQa3SIi75IMiEhtNQrGnCJw7ty5ervd/hKA7SLSWM2KN2uAWCy2QUQCJJ8UEQ1Vllamhkvxb13XCQD9/f32ZcuWPWVZ1g4AfhGRub50cHDwDpfLNe52uzMzsR8ZGVnhdrsvl1v7lxORSKTJZrO9CGApAJC8PD4+fkzTtOsishfAKyIybXkkaYnIm4ZhHCpz6O9USnWRTGWz2R6/3399mog/TPIZACe8Xu/nU0ZA07R6AM+RrAcAEbmgadqHTqeTuVzuoZk4P93ZAdBFcgeACYfDwYGBgZ7169enJqlwD4pIUEQ2kPTE43HLMIyT01YhKagkQjIf503TdDocjh1KqYCIKBGxi8jrLpdrT39/f+0kl2IQwIaCTz6SwVgs5r+prcRk8nq9WcuyRi3L+qVooxwA3qirq9vd19enF6VNB8mgiGwqSksCMEn+uuA38SwgPopGoxrJ/TfKr4g4Se5qaGiwTNM8SLK9sPP3FTuvlPqUZMjj8VyqGgAArlmz5oNkMqkKECsLEDUisgvAKgD3Athc7DzJz0Qk1NraeuGm9EKzka7rTKfT71+8eFFZlrVfRO4uLNWS3CYitmLnReQEyVBLS8tIRdrpmUKEw+H3ABwA8FvRmbCV5PxJACGv1xuv2DwwU/X09FjNzc3HAXwMIFeucGma9rZhGGZFB5pZtuFrSbYAcJQp5ffk8/nN6XRa3ZIA0Wh0LYD9IvLIJCZLRWRfIpHY2dnZqW4pgKGhIZ9SKqiUerSkBTlPMlUUheUism/r1q2B0h6tagCmaRqapgVFZEvJ0leWZT1P8gCAP4sgGgB0JRKJ7eUgKgoQiURalFJBEXmsZOdPAwj5fL4zuVzu6MTERG9JJO4Ska5kMvlCaUtTMYBkMulSSj0N4ImSpa+VUt2GYXwHAH6/PyciR0geIpkuglhBcq9pmu1VAWhqakqJyFkAPxXt/DckQ62trWdK+6YrV64cBnCYZKZgOwHgi1Qq9fNUACR5meQYyTERGSv5f17Dusfj+ZJkiGSE5Lci0u3xePrK2XZ0dKSvXbvWC+BIIRLH8vn8gfb29quTthKjo6NDjY2N/4TYsiz6fL5LhcN3FECO5BYRUfOAOBWLxa4CyBqG8f1Uths3bvxrYGDg4JIlS37I5/Nn29rafp9yIpvBQLLSbrcHCsN8/Vwmsqp+Vmlraxtrbm5+i+SrAM5W8vvPgl1kuq5PeL3eMICdJD8BkF9UADdkGMaPmUzmtcLwMbroAABg3bp1f6xevbqX5MskT1cjpeZ9D+i6To/Hc0rTtJ0icrz48lkUADfkdruHnU7nLgC7AZzHYtbw8PADkUhk06KGCIfDNtzW/0B/A2/7MX7SZ6/PAAAAAElFTkSuQmCC",wmsx.CompressedSystemFiles={
"MSX1_JAP.bios":"bHwJQBPX1vAEQghrEkAcwMKEuIxhS6NijBADgsGKhCKIXaw7aKti1ZbVSFdtv74+q6/vad9rXWoLtQta28ZuljCGMtFbjQi4tTaliW1TqwETIuDwnzuo7fu+f5C52znnnnPuueeeMzPYz/QEfJOwezfz3ESC+UxAMC9CaYcyP4FgxgYQzOMxBPMYlC9NJPDFBAWMllnhzJtC5s1opjqI2RDEbA1ieoIZFMz8HsxcCWbGiBlJMJMXzBjFzEAwweyOZppFTGQQowlizgYxSSLmH0HMJ0FMgIh5SMT8LGJuiRhhMCMdw3wtZAJkTKSMOSFjHo9gTkqZr8TMYjHzvJh5U8x8o2C6FMwpBVMlZIYCmVtSJlrGFIiZV8XMxDBmTBiTEsbMFDN/yJgFUcwHUcymKGZFPPNVPPNrHOOJY+Lime/jmOejGXcMszOGscYyf8Qyi8cyWWMZ5VgmdCyzZwxzZQwzI5bRxzJPxzKGWMYUy4SQzLckc5pkfiaZujgmW8LUSZjCGMYYw8yNYUpimJdjmFdjmCUxzIoEZkMMszmGWS1kRgTE/73QhwKqxIn2CHrR8a2kBJptDoF9tOPE1l7vls7mBvXIiMfBerUjIxmVrn5oXWqucvV3NnvYmDGthnousIZFpoDBKsGl5vL9h1Fjfz3rRG8H9FrRZwIyoQuPmQR2fpB5ob8Xj9lh0C6w9HprXLOOdDZvAaI1QNDB3la2DpNRvd4uk/e2Q/GYYqGi63uH3dN7QXzb6fne6cDE0gMuNXv3H77AvNIPpADOaTWKiC0HP5Zbh0OqneILaGzABbHDYsfEgc/6UeqbxBd4Pp8A9P2HO5t5Jv+C6Kglf+z3NgQHuwKX6FqDg+/r2x6wJMPo8boCswy699vLpMPlbxs8Tay3ztUK3eWXmg0893USiSuwHEOM6fsy4O3y+oxKrKuqgx/fEcsVyOqe7Xy/pbNZV9x5SDYy0mLsbD4pFxHykZHMG6ZuCRVWbcqiRMKTFsCQE9+YMqqPZ1RTwamUd8JgUGA6MX7LroY3VKFunu6l5spbNU10KG60Szm9xnapub1Y9YGcIGY0jCqzNhguowwvlWtWZ7OIOClQhQoxgmsWPwV3Z4oQPEUD16q6/v+fRMxPolfhKfSqT/86hWBuuOyZfnljfyZx7bBRJJSfGD4Zt9fVWJ0iHbjUbARpeUI6/WilUtc4WgHljlbKazubk63D7uRvh68tZBonao8MNbU65f8e7jdlEo6hpg4ukB7n7LKiiyF3OoeaaL8XTQr1WOwOLrDViVYLUalQFSp/fLgfeSKHHCyaKdZahifq0WMBjpZr9Ud8Vsa1Qvv4sOSM8onhhk87lONuKqCYzir9/cmD/eylQ64bvuDOQ5fec0lbLx3K5msBrc7RYYfWMeS6rnYM6SLUA/3TWV1wYiMKkOkkiadxEbYE7ihc5tKrPxzWjXTuAGa98llDoidbqhXSYdlTt0Rb5Y0E7kUXYzzt4kQCELrF3nQJqo5xy8VBAhHozmNx2OPcWVygpgsmOAYgzEWxUFizfYRA1UEt6pZh9eFh7Uf96sP9yqP9ycm3lOb+5PG30EAwMgWjxGD0jyBSA5A6wR3QFh70ax7UgkGV1v7kibeUTH8y/Re0L0XokyDtj/0+PYkL1zeGSEFNf+eeWl9j554hZw3Y55V+2Bes9kq/S2CIJNBWHu6qT2oIh7r8aL8MHG+16H+Pj45+fWcUcxYAnClP80wgzITy2350JbhFFNi5O4sakt5C+3l2wPtuCAJqvoD/Q+3bflngVnIRJhaIiV3gifXwxOyYmExERArrRBRQlA5FUN7y+6jr6HOe7EN3yP63EGIQF1O2Yz4FASK0QyQKrUOviURB9fgegjuCWpxek6KiqmXy36XDVZ5PDYDhUCjCWaAxiq+ceEtAiFvQGLH21/4lShpalM6OULBCUYvv4QApkagCw8PD63Fb+hNbNZGYPHkyEgZzYjpg8mQ3kIgb7XQDfhzLY+jEZ3QUi34P7u29tDsqOqz2MDXAom9vK2HlrwRrk24pKTyx1+O19oOjHbJ07lZgoOse1g0A8Z277+BMJKomY8rUrTiZflgkBlQv3lUYx+6IilZ4pNdZtDeMnqCaqW0ZblIm3xK0BtKBAiJQR4FYaGuo/OMhEbkBTBoONaQWCwjSqmT7tb/1w7DyZL+lBc5X6Jf/1m/aBtdnyq5+ASEif/UCI729ns7dd+Vgt4B9Nbhm+fRgYXcbuAoTZw+OF3uBiqcVFInJALnPlN/0CygC0wEqXl4gD/uXcQMZqHXDSgTDgQ8ynNceHkZf34ZTHpxDdbCDzR6MDLJpgrJt/CGPPhvxoiqhJgo9L6Z9Hm/nay2dO7I7d4BTb1GPuamLQGvFnuks+nLk0g6JZNZeVpdwRffQlS3tSVca4Jd1euXvDrccr6YjPN16jtII2/XfTHewHk5ADcA+4Tf6wdvAhyoKpYd6gG0xcoRov+/PVi/zYafFojfFZ4xUhLxp2NTU9veQWiAiV17u57baekORKwzlhba2oJTwiQK0LLQVrQlNFzDbQ+VpIZHhCkVThP+4ghooUswBDJQW0sJa2eBombgwNOTJ0FBxSNjW0HBTcMQzoQkvhYx7JPS+wtDE8tCkZaGPm4LzTcHz/gh9IChs7e+hhZ+Ezn8h9KEXQ3LKQ3OXhc7OC80rCy3YGlrTGFL7XIhOINAFCHRCgW5E3TTM9r0ZkknUyh8MiZQwcSHZdGI2PSG7Wnu4X/Z9Py3KDETq8ARDbTd1LCvqfE0UW13bPZUOy6YlfI0KylIfGmazW7PU7w2z2veGm1rB00DRgd7DWjoDcjjR+TD1qaHRLeEG43bGoXfC5EnYUA8NN9EBokA4qlKkgw6BPzgEHQ9zRI4wrrD/IvbRXWLaU0NGPHi4/6uO8eR9qCy0FeqVsgm6tA4yEisXFKsO/7pDE5SafLmfTWsh/WDjV8R4iVzBVD+bLpgoIH9Gz4QC2Ovnbb+HOr0QIqD7wp9Yrrh2WG4bmuZxeFPRobA0xISlerKpPub30FHwSh5+7Z8IzpRrxxybAT4N4FMBPg3DkyGoMLQjkgI+gZnJ4U7UFwbm7dCB5xqPOVd5ITL5I9SBGT3fMVGQSt5Ax263oP+EnXEqj/Sj30PBI//QD3Ifva0b4bu1l/vlR/qP60IpwRWte0gi3+rXCTRC+Wl/ixoNycjhLhGto6KipcP2yCCYo1uoSRGNCLuDVENwxlO6aGskYVKEg3Gq/JQQbFIAsH/opK8ZQywRlAPPyoQ5WPUP/bBPuQDWGSkmQ53Afh/WNcgLUyAJbLf/M+CWw0geHsFijjoB453WleDazt0O1vroRKI0DVZ/ft7kyXHYAwEqLexOJgNDupUZTUlL4tzgk+JSLKxTdmRoIhFncjuaWF2LF7TsicK6cIL0L47uvwtifL/t/N6J3rh9aU9TX0AE2nt7SH2130XJ1w2f8EQqDwynNHxKhci3DkPMoNw3nHxgWPnWsCL5rWHtrCFjy8k4r/XyTJnFg0/kPrmvfxq1NjOwBYVHuVRenYAvg4Mth71oYpRLYDlslP/S/9G7Txol8g3Dlz2RJ2Xyhjvl03fK2jvlJly2qC8MoagIipQPAOWoTIH84pDs0pAglMgcuXYYFUV877jtwL5CfAHfh/gQxSgKkzuHanF0Uh2ukPq0hyEUioSl5n6hgr+X/1sP0b3MOSQKS0iJP04JpX4yiA9ZAA2oO4fijcDhiZciohXSm8rBfq2//3V2CB8C4KokWjQkdw99JP+h/13J5ZQwtDwCeyqsRl3YDvCzRpHYk2T1Xp4Z6bGES73MJXFoZWTs/kiVKXKKVDI1UzItSaL9MjJLKsmeI8mRSnJFkhGpZESerBg/YeIkenKZpEyyK/L1yNsRnghnxIWItMce1T8yU7s4NT1jJNvUsLQ+RbklSzdrSVriOCJhpvY+vh/XU5T3QX/Sn9lKQgghJiOo8Kit9yUmjVOmZKjuV0+ZOi1zumZGWmp6LTfSIX8nAp26zalU0XgfSFRhkrNbpNoPhpvanpPUHh9NKM7bSW+7yoABajShEOWwESEmwGXKJNDnCty2JJaQd0bE4XO/tnvMr+2UQfv+cIaLghCYvCi/FHEPigd5KA6Q28okLCaoEda2BxkfAgJ7huJMTVS0Gwx7sizDG+eOhx1bJokmB0ZjUNop/3AoLi7O5BJ0mHzC4x3VfwS1as8PZanPD/GkdOE/EGQ+st/G7PQCO00dZKb8g2FwhzpJ575LB1xbDaYMV+Phzv2s/H3cndGkC6cFWZ3v8/gSXaBKkKX+97BGAtFsNWqTagf7v+5I9vdrL4H30F6AaFsnAWvsfF8Xmk3dbtJF3kH+ELYgEKBD5fdJNRHy+VJSLP9aogmUX5OIiBBBmcQK+mgytXLvnucOd3A/nOmmuH3n2/Use+Tjo598am3/tqPn/IWLlzp/uNJ9+d3vvzzR9vWx49+cPnXGfrbrHPrus8+/+uIkY7bYWtmm5vcOvX8X/kDn4bc/Orj/nS9PtNyD//CDv8Jf/vbUEZjgXFf3d+jwD1cufm7vuHD2kuWLb7762GY+1n6aPd95pud469cnPrOeZL78vu3db081wQQffPgRhj9w8fO3gTwP3/z/g28BW9gpDQFFc42w0y+XSTxgE0ZDTu7svPw584vKibnE888+88KSxY3PEY88XLqobMEDCwnisXkEUUyUFD5EPEg8WkAotnBkq/zGEN5BqO02ejyCCoMUBkp6CHIXSGVMnJAKyCRgIxbBqkCeUQt7ygm5FRoKdLD9nfu89Z37hzysLhIvM9uSWAY5wZIsuCUe1wXfrQvOBKMpMuZrYVhvb80R6hZrQBtiUhamPJawSbGx7mhrjVo3hH6ScSP0I+WuH3E+WOdKqoaelOrwiA4oy12tlAzKJTWYZtbDcIsgnZWuRlrycE27GJr1Lqku4kSArMGlp09hDAytC7sHHUF+VnMnqxFC3tMyfaz09rsfVYMbNbfK9UMmc8c0uYBIzhlKrhhK/p8hXbB6Fti2jvc8H8aA0NmDRBQ4VPmUKJeE308sOFUJXPLZUeTvBp2kH0XKpCLXFV8hKXS1+AI790O+NcT2Y6fYLsb+cIglgiBUFQYEBovEwbhOBAYJBQFEYDAhChILgonswbVRXhd23JagIJF0sDJKRO3rFuxleQdOerOakrwGnneDJ1IqawlUBUVSsr2Fo7O//fGRzv3vde7HixFJXDqwjw4Kb9sbFTFUy3JC2e/hmiBZZ2C3MHvQGpWtfXPYr/3PcIfXnVzh35vh0htHabi+ARqewV+iMPMuMZ4bEhF1NPzT0IiK1ii64G7RjKvZqQrIyOKCVD/W7rpT665Tvzlcr/7P8FADjwehRvT5si4e3764pZJFj0SLxA+efPbkTrQuGiaoTEpKOjnmZNvJs9CWXj3508nfoNKQxOqmHSkfBXEF0LdOHjh5yNmlrPBvyThQPupQ3vn4k8794PqbBndGU4G6kDadGNwBqFoKIUj37Wv5gn2EbKtf/l70tcPsiqq1VRupP33zsqc2V/2lSVRW/Xd77ZpNm//a3vjU+oi/PokapXf/tNSpqdPxwIq1VctWJv91fP3mvyJgeukRiYl32+H/i+ClPeylZrazmTXyxvLMqK2gK5xTudK/5RMH27CzdcsuNj0AMgjNUJcsB0cWZjpYNoGIy6aG7SxqGmHRB/A7GFOTpXj38w5nSkpKr8KIfT64wU2OJ/FQJkHdV3usQ5H1bkqKU6G4N2xyPGluzdIRLARB8g23QkysFQnHbFDgH0+1ArboXcKG2h3vQvjLwvAcRZHCZGaDDcGNgKbs7w8ZzSkgLltOibkIegnEZotQSTBkQOq+fuXnw+5r88zDaM8YVS66MgbSu0ixSIxmxDq98du8l02x6INYh0bo9Eg9HgfSx6LQsRphdAR1CV0YozUP06J2ShNOCtvFGpHaPMxcFLdAgcc+H6YD2ylBu5hr1Qha1J8Pkz85rSKBu2GbKgj8FCmWtRJXNUJ3iojo/bOPENzpswMNWnwyG35mnpxZI8mb78AZXncAKOHCGCr9wVpXsFEeFhtiUqfeqoft7koy1Ln8xnpX8BEjJJQhycpbFrZRT0nFwgBBrUR3QxUAR1Xqrdpt2+6C8WjBBkg1R6G1qbeUylssAEGTtTpBCwY8WTzqCd7nhaQ8BCoGTw0txP7FJXFYWOgQBvVVxpLXOOms86BQ1on5A0xK3IXWknaLA5xqT7CxJmO/UdvXD8DvxOLM8wgk8hYcxV4Y01Y7FuAlqnlbXH7Or2ukpMzDY/mB/xkdUHfJxAQ5ie/6D+4KViUBrE5ASci1fO8Ho70hXTL/SBwwbwcZmnAABvLg8faxTtCJjBgb53Zc1URvyYJMJYLMuDd+eaxii8xPkPff6+m9gyHAGKqYLYAgsU//C0n/2C0pMvEI9AvwjE04M50R26STDLaO5QWhwsjT93qwBLobZBLfcaOPBwGAj+61Mec6yV95h2WREUFxwG8oz69wOkwxymb86KAABlUhW+6O/V9+gM0vSbyMvds0pFcwMiIJUeVLVIOe7F4nLI4DmIrrBXxjg2RLEqzoLIeBjmmBlZERVBysFq6JqTjp7xF+p3wxGWIiIxtbf7zhH+a2ZWcYPNn7HPzaYmgovXAAeXaVA96XdBxe4y/oWG/NETg9xzq70AHS7vAcJePBEGQ1RzAKGempgSVAB2EEkD5mULATwYazxjrSKC+rDLvpVkbcZL14J4g8YF9kkAfgmtQfD7OwW+Zj01xZo66ADG2NX/vxsAEZYo9REQl1Rztg06o8MgI8wkdxXSB/cu4tdd4t6IiGEU0YBqSDYIy83sVvdWXuLW3eLdje7uRKv7bC33QihOS3u8POvBeHvo1T3SPbx5O9SxL4UEDveQziu8fV9HscnY/VSPjZRDCbgrwOwjmvPVLpj0MhpEO7xm9knfK+/uOOjizAYAEcU7pojVWQ/YBmABo7pneA0Mc6QDORgibWCvuQCINgZchj8epCOt/3DLFmLz5lYHKclA15tKE36YBt2wyRRD+aH49mxWNwL1MlVIpuerd0R1ah4niPSCy5rI8/NyNeOoD08fBvdByGWEDq7eXfbMyPZ5Xim960tgfjdWGd709oeyheFwpTsni+fnycy8uFD6KpCedruR9U/VyQ5vro6StUuTAvPwNP+WV4PGRM2454wUeikIYk19byyQ07y7tF6oPDddtERHegEHLo7kD1O8NmVntwuBxVCc9fOhCsGrhT0QxAeJSUkAO/52ueudgT/4WmP12MAhM44azzXMCsk/G1knOKBBhOa3PFA1Idq31n2IAjjff7xibUZywJl96sZbFE0t9rWUw1kginQ/HwBDzMRrB/nUqRwExI8KKfObQkhhZ7vpcXrIXcUBt700wv0ZI3m6i5Hi8XQkXqKLQiQTvmJmy5mx62O4IO1YRx0Zpg6MpSj7mpHXuziU704MdVlKKp74ME7kVNArdPJWynSDH3o0bYTWk8aLH4zPfyjzfBBDqK9HiYr8R3T19TLv55lpDuLJXSec8SUTH+mKklOwmplJNqSqGkG3ZqSjloSxugD+Bz8T9CbyrIok1igtu5k3v22RcJ4R8Hrx/4TUQAjayY8YUE3fHob2s7iokGqiEPfojwDUBQKiVM0sSo5DyYvoGm6SIC0x25w8qIdPS6cadMulPe7ecvDHcHPulO+x48r3vAx+UzueNJcnzuM5hrLBfwvhMYgLK0dKdUdS/6oOCCO1FcXMy3i4v98FNMUDX7NtA3KKK1Q0rpd5OEfp++ecfupQS0eDgo9XDsEfArxX1U8wZqQzMmRfkp6h5xDFxzb7KlS+EmBvBGYsP23c0d2zcQ1NJ9wIEf2mLp0ka+VImhX6oq3uEHfv2NP0rF0h8Jlb7xxnbo92+X8ixvgAZuw60GMPFk/L/RktKTqqWtS1UktP3wQxC4AV38PBSB8cWrm5th/uLt2/3btxM3Cgo2FBTcIFQFjY2NBSrix+KCgoLiH2H+xhuNwNdoifluPIbn3c6jbSc2YG6oDYQG1LBjx1Ji+459rft2bCca+ctPbD/f3Izhtnd0NO/evR3zux3jgzB36G3f3rxjNd/GeEB/A5bfz9OliO134PG9uJhvNzefB3rbizHruI1ZIPy8WkF/enwBfDEFCwJy8qbBy/mXmNOP1+1OfYO4ZnsN8Hu4Y3vHYdze3gjzicWrd2/fvZpv+xthPWi8rljBq3fvXi3e0IiXA+aniKW8/FJChTWwVK8vKF5aXMD34n6CONMMF5RAf/t2nh6WB7c7DoMCRumJcRvrA8yl8Yb4BqHX3wBS2E53wIX5wArA84P8zdhWeQXw/ZgfkAkUAKc2rD1Fkdiu+d9WigKDaSX0zVLir5dU08BxmgZiLcdxDRopodFwXLe0ge/HbaLmebjAdGuG4aoh9BzYx7MNGNOU9fBUKPW5uSWYn3HjkgPCoSRNpGo9lFGmrBI8Tjcok8dje3/08XAshzhSU6jFU2cFBIz7c/9xVMOhj1cSROOzzz4L9jOOaAgIEJKEhuDEquK3CGowueHAgUJCn9f3QMF2FSEdFuuEjQ0ECdaM7Vv4/HHgs4AghgMIfaOJkMb6xQ2NNbz9PY/XkRNrCjRiQpjH5eXpdcRKWsVR+qz/0sVSmFdD/WXXUj/yFYhrcaHC3PvFvIUR2N0shf0LDgDvXIC+seNOP+DdwO2l+/ZBv95fUKzH/dgC/TzeDd41NTfjHcgbIU+XVmE3Ib5Dj4JdxY/zG8BPSP3YE0ihH/xlAdibf9QOawq2izGcvgZGeXgxXH4COy++3SruwH6D3xhgJ6PsaMBaCng5agpq+HmkP2J6euCqmac3uvP0YH9gxcA/PxuWb8Mdlv1w0BRjPsSqX4APsXjUn1FS8BcFeN+DpwD9+0cHQA/7pNi6MZ3m5lE+i2Hv3SDAZ90QYz/auGO7H9MBe24kavgJSczvqP74DewfXQCQbwMmAHzi2Qow/+C4ixftAH71gAA0sVcCeliNvB5bgTToYUfBn2uNLz2nf6xxH9gXp/cLhdhFD4PdaQiCC1dhPUmjxkGpI8b3FRT855CUaHyrsXHf8VYir7Du0LuH1hL630uWf/dAIUHAIYntUwhm+NbBRwlxYfucvDwNQZFU7Ms28L/UhvOviAIIHdjpf94lCbFJbML74Mfx400HD64mqOHxy/ctzwL7bGg/tHMlGF8NVZMM+6Ng+IHcQrCLr2wvfyVWgRCR4ppXNhKa5xuH2wKAz9zc3OWwTxrEqsvLdzYQVOrN8St/nkg0kNSjzwY0EPqll5fntj0K5wi1oeC754n/faFLt7WHfE1URDpBxqAfb+tmXdFRV5DztvJyf9qJyeGpybahFvW/h9FJqXz6+MgwFBfiPTGi8Kj+kC/2dsxicWwi8UBwMqK4907GI28e5gR0GOS+IV5T04m+8Z4rbCZxRYdfAaSHetSHhhlHiHjZhCjn+AROERA5UeSfENkzIejzCYHW8REPjx/z0YStxRPQ2omYNTpgosAJaA7ZY14Rl5baZUXnwyz2JjqGo1RhQfR9Rp0gKrq2XR8VHURLR9/IXOpC94XbJwpoe0I8R9GDEPc7QuyO6JYoXUSTF00OR6+KdaFXWtTNwx5Is1IBmh5EaeNb1I958Wxf488UHJqz+AsH6hSJQCDTHyPVtrTxTOp44AWUE0k5MSN26zzkCrPArOO/qlNdc2BK02s5ykuFYk5ooQdERcrwVEhw1eFfa4KQOZSUyC/3T6MEU9MFaHuoI83psHhsjpC01IkC8hDGooKADKXVjbvCv3AD2Se01U0Y70yjMdFKPCjodSRf7ueniBoPfEwALsZj4bO+om5MiKTwu8n7wtscIU6gCuO90OGAFDE9FNQKmGQQTxdgvOiPUA8VhN9beUBLWCdM2h0h00Y1gycdP4EOBjqgTR96JJTswpSmTkTjJ9I2zS1cMKpb5DejvbRZdQsXh2EEYN/Drz8fwa/clgClcjIEtwtDZQIBVK52yFZP7MKUVbPOcNrzXA4Uj5znlkFRf557EYp957l3Z+mILDaNxoqh/ala29DXEwWtStsQyzzdwLxSxlTMYf5VJjf4TeaOPxqryRB0PX205dpqkPkG4s22oAzX1h0qWUaW1ykSxxdV10ZFK6QDDkj1znhb1NyA2uiXF/g96O1JgKj1DXw0ODBRa/TDCHpo0tmsSW7T1I8GK/Xo0qSTLjIfPTFJPjAggH1spsSKiAjpALMl3XWDEjnRvyY5InTiHXSU11ogGxjAX4xYPIYW/Dav1kyHyX0Dc16sbgZSHXJuQBRs4orPp7RMf3VS9ZkU6a3RSRSZUlZe5JfdhvGW+FcnRSWkSP2s3OgHYLAbGeCJW+LfGu0/4zaByHK+T0e8Namah+UGrC3XqlKkQxbWnOQ1236a5M3IMopGZMFEXOniEJ34GaMVWDtm8Siiuwz89y8Oz5lap9XQcq1SAWgOFgTUiclrnjOkHz2Z3qE1+M22LekGEOAjV6Px5DGTa2ujIZNwtXZwrVQgU6mvade7tnYcSamW5fsFYkJ+e6Dr2jFFi0iMqdsFz9FW9DLthBH3tWNuebZfJEbLJtmhLzJYVuSPN1PChAjSH5/QJY/wb9OI6Rj8yID0ekVi0IQTYB0e8neRRCb0y4P8iEvPJOwR1Bk2xaSoZgYnyv0jcZGBIrE5/u+ggwSpP4LqY3mmF+kx0ybMffNdzncYkppd+kyCDq5xNbbyzOe4tlbT3iOZBAhwewD0D8o/DjzBsiT3DbiTbwzUqG8OyHV+kcRpVUKP8saA9uZA5Ei4wdnV4sbrgaeN3x1ld0C/6heDG3hWBbin1lqM1pMa4aJYQu4diENvTLI4asIjqExOQiskwap0qxP4g+U7TkkU0kGHBWD5FSEnOiw1pETrHViSrfYOvN93kwYzS6rVBH1WrSCD8GOP6qA2Hw2rDSoHdXLpzHO0fEUampkKJuzaqvYNyBVpSJ2K/pZOiu4NmIcbU9GpVHRaheanIkcqemUi9HL6i97J2oEBbgKU3FNnf58Mo3JZGnoUAzDeyfKENFSM6/Lracx2nsKuyagqFX0wGV1Oxapu20uDKvEMHTAFl3MxS4lpJPA09tJotDkbNxkgMy8NGVIH1yqBknxBGkpNBWK4MpNHAa4v81hrlfJH0pjUVLkqHU/7ZPrgwwbbw/yaejNz5Ck8lZ1KT5YXuqZ51G/6MMGEuwT/SgpY1vCMA0B7GnqbB3iHr4wCwN01ST6Fx+XrAKl909edU7VtbyU6mYFyVbj/jYnymWnMTMxMB3ADUmGhk76j1OA8BgbMErPENaVdqi7w64JH+UHf3qUPuDIs46jugXg2dZl5KFUewncC5MsZW8bu/YqOaTD3rUtBRhVAyaPTGNBZpT4ZiGn/XDZMyZDqpcUaEa6qecFeSUPbecGeSENv8GJ8y9MFcJ0fVfI9Dp4PaBZjtjyw20RYkTMxP6DFoher37sB04F88nI/nT5cmQrAsnI/ejxVfisVsOSeVFhFMDuUToNDki+C7YIGMHQmAQNAI1OP/SrsTJkgDbpJHWAxb0zEd+DEN4AroF+4g17g/mgGdMoMfjfM4WbBC4PjJvtA54Asw/uDGUh3JFsHMPsgzUOpSuvAr2DY8r+l9/6K+0/hnlGJgTDu0eAek1fhlEOjMtUBjHmyO7x8cyY0i1OdoAYH+RvsdjIQHJZOaJ+TUpRizab87l+BBej04U7Lk4oNCr6TiNHspnLFckIePf7F0qA4Qr/ynw9OVyzSz879R0Fc4Hh98d3YKudOqqWfcKd9//JJTy+NfV7/4gvb/6kRFecoAhYV79yjzxmzoXbFxNq5eviNG39/VM5YdZA4eOFL+pJpu6vLdqv0Y14r/YfqtR3CuwRnj9m1eYxi6f15k0LuX6N/ITYv718rppXrFwXmkvcrlo7Z+dTs52JEG6N2PZn3YE1I3GsPLhe2Pjl7yrNj1BNzlhdnPhhVK26LXq3YMH5MYM4LsZvitileCrpLui1aLqyZJliYa9hZslCo2dS2ckfFs5tDZudOzikvHqtQiFvXyBfunEyG5GjG0i9qyp9sGxOSt8dQIMjNDXrxpYpNZW1Pb1j00Gr1a7nPLC2ZO6ksui1n6tiA8YG7c5Y/Ry4IHvtP8Tcl4jUzhAQx6ynVk3OjC4hvdjwzVT1+Q7FeJgv+B6mf3BpDl4vLCp7Xx+3Zs+cfL1W2TsHX/Uvvcsg7Fy5j7N7WLLYF/BuL9qffuD6Yorat0/NeHgcAuLNq7N5KZk/GdejvezJd6R9o+LSjgfzWDbVep9IHNzeLrqS7k/0DS9ck+wbcLIy4YWB+HlukmMN/e8DiG26w2ACFpBibp3aFzxBfDdHDIBtfDafDIG+rfdjBQtmf3gWwAMMJz8j8A2yt2QZ7qDrdCVuptgMfnrV+NDMj6T229nirogZ+6+G37p+tDgdb90HDYE36F1Tgll0dTG06TBb/F+x44x10iF/+SYmAAb+FBTro0Yy26nT2OrDvB2HRYtXFSj0WSxegXuFjBVa17OlGJM9olRONdvLq9R8HOzIw3AIVKpmuqDEnGZicSVg/Zu+wXA3dbjlBgEKAQt1RW1OFgAiCUMApV6l0I11YIb3WvPlxWZrBpWssdjecY2FmepxXp2+E1fCE93prk1RiD382kUIPHFS9dUfpACnj8Nxg/pZ+4zw5/J8R38jIyPUzwMRwRwaebHAgeXigAbwFBBwBOiHzVsb1DgbW8wsVPhnhuObmnOnOUYnMdvxAPMsA9wcUteFJJo0oCS5SoHBJ4Hxe/sTk85PPx8Evfjl9Hh/Q0gsg9VUwmvN0qMN8w43kareZNd9wsNPZMPY6jmz64Bj8WzochsyL6df9cJZGRqrE2JoGByJF2NwGiftdW7tzLm5Jz3rtTEaWIcXkulEd1NFSLfWyeEAlko+MgKmNjiYSKaZyAPiCFowLosUtfEXqHndfRy0nElikwLutSO1Onu9PnudPnusH4zP4wS/iDwpqjtBROunki/ctdU92q4QhUMmmbrgdbMPYvQZgvXY3GYirzrqxe+O2Sz7oa8mwusFDehzoSDqUFjtTpG741LYHv+oYo4Z1AqJAUJOE6QWGaMZmU30We4N58Jv77TXMfeo/Gj+lY9xkgMUB2H8SeVRdY7YM7snogqYdVg1ILtJjglh/o0RlZjLEGaISTpkyXeU4GX0y6trj2dQfbksX8+n9DYcMaJzaDefXnowW4+tVtf/BOxFMDLAbYMrWFuYU0Hbd3/JsUmV9UhX6T4aHPAubETWq4YDFhwTEK313Wq5JFjvemmCPVrxvwTQtd4b20u67GsRmBPqc72ez2RTWwboFI8TS1WhPhtvETbQdK+LSvHQQl0ILUnouvjiFS7cZp3Cr6AAun4p39nBr6VCukBZxT0LPgw5adF2V0ELGmbgJtuVTOIVtwxRObntyCreSFnJ51GQzqp7S0xVLIIPxAXuPKrqeC1eFBgc/F/xit2oJ+UdiI/lbOBXYsmvJ9cGpU7AF0eF1O55r16tx6FU4xeM8BZamCnP84pT/S+1EBzJYlDXJwcJ5ez2cOqkKBfIYixKUM0fVPR4eSv5yhtNLfsRPTTbh18ynPs7wnNCq8Mdf3aq2XVOO2HZNOWA7qo6p44IpIQbsqnkmy2B1mrpV3ut99imgRBkKv6qCBGDy5LjJHmMIGMKpKaBXB6z5UXWtF3WAKVnsVDieXkdQQsxAl9WJA6tMQR0n1QTCQmWZk0SEMcRjrEuqVQn5L4irya+c8rOzUE2FQ1BdYQW1t0DYI28fyKQ+I8e1oCXTXWI6IDPFDY7Z3ZczNTMNEuIX0x2WTxSZKgg5yseCx7w4MNV2fSonPLt/qgA/msgE/DmRFAwvcVF0eM3nkUpKVO8SUoKcJ3sg/8+npVweHc6p6BtcKv07l04FpmSq6l1SGspHAbA1ZQPrBCdXHCMgAkGk7lkaccwXKmGWQRfQHeDwolczM1WnXOnoaGaKCcgMcuknXOkeOj4zX5GZ0vcTsJmRJcoQdoeqhtq1EAFUKzIJN3DFKqycsO5sxbSki9enCQJF6MVMe1130M2KTOC63nzqdXU21J1o8VQHHbABkCDgUGi/8r2+s8MEKfRNTknfSHF6BVnTrD1cWgeX0sE92mHhVBD/96jCUsiAlGoPPWQhT3no247MCawz6aJ3GhYEC2HUhDksaMJUoAlD4MBOHJjusAy+O826pGbnLsxDXSZIdPTEZvjdl2lnoqctqTWf2KV+bvDItBard7h+uqV+h2XJszWDJ6fxCFbAIGWoIrMWvZ1pbNm5C6pWgxGIWI5QgcqvfM9hcYqZcdPArXRk2IGTRTCvFyYGc/HWmr1AvdFY5xJygr3lzxh3efvoTFQ/nQpxQr4MtjPV4bF6BzMyWzKyGrOeNUQSp17FLHpurs9E+zItHiocva428dpP/srnASnpwOd27LSi7qluO0xr7sjOVCnIW5SwA+Chmk366p/NMmR1B6qG24OMYCIufauRDerbnwkEMtPBqoQF1C0FG0SJMzFNRQEb0ZqZqogMZLucVhCgxuKA7Hy6F+jFq+6cItEuSbuqWuHJnkVdJTO6ZNLpuiAYt3qdbggCrIpeHDyAPWzZVdXwRqVqIA62jt2xQeGxZFM9AFhtZ6WTfglcSYQSAkIkIEWiQDJAJLSiGaWy7oGWKEgDE5oakiq3JFXVJhmlNy3WYOntdhWn1QS0B0dZtnxCXXGz1yEMFUWekd8aEIlY2EReaxdE/JAAgFaaTj2aard4+H3Ff2qSkbVEJ7D9ZzoIhFV9HzXoUNRIDChnEvpkuqUR+wYr3gHYbvQ7wP84LGYWi29ySShxkMkMW0baX2NhRx0qThSqUu8kc7bZmkrsB2zzNTjejp+hyXIn7/XhhOQybkJFudd39mENAHudEI+PBtmj2Z4Doom+iZo73t/J/EOD8R7iyW9UjqZWzAP4va1ILiCYck3dUSqiYawqkFmkB1cOxwVM1TUaksCBIyDMNUkGUJoqCEXMoArhoFzhXP4E1N0O+mfrvfieT9AsOKbBsGLraKBvAfCpVpwaWQecmDknH/1X4jSItPP6hYzqDvYoKWDVQnZ4LDdwJBdAia13SPN+OQzk/uTGFsk+nCHdzW/hMAJKu+7nEeyg0Yf4vOs0r61HM6a3MotVv60Ynz9p1SMFa+ftfWzvvMaCXwxvGZxz2RUfG+QFiwt6V4x/oGVlesmLy38uGKe/r1hROn6luWrWhlj9fQ9MLmEI9sHFBZqVM1bqVlavPDR38dyfFnw6d3UpaUgwJBrkhsh55sdLGh6pXlQds3bxE489kbG2oGF+w9tPKNfKHmmsXb/Y+lAr4dz0W7mz3LbpVO1P9QV10+sfrm8uk9WurZlnMm9qX79zfWxDQgPVMKFB2ZDRMLWhonrZ6tdWv7H6X+mnVc+mjyivpHwweaPygZRdk4cmxyj71gj0p4wjlcKKL1eHrU5YPa7UW1+w2rtqcNW3xpFVL2d8nKFVHVfpawtrH65dUzujYca6ioYnGjY0TFgXuC5mXXnDow3LGjZqt2v3avu16TONM9fMrJ/ZOHPvzH0zm2f+MjMki8xKyVqc9VjWq1mXsnxZI1mx2VT2+OwJ2WWlp98rOuHL7RSVfhe5gBlTWlpy8FciZ4GVXZCz0Hqm0Jhz4nR+/pnWuUUH7yNyCk/ZCo0LrJ8Yiy90G4vO7SnMzzm7E8P8G0O/saCkcO53v8wtOpe4oOjbpLzcU9RCll7YOXnhCaWxM7yg5GDs3JLZhdavjIXGs18Xdu6df6KHyC/ML7U255Ranp+LXsyfs6D07Pv5c4DEB1Av+vbD/DlA5qMF84wH7fnt/1owb+7B3xbMa59YktNznChcYN1fdOKZEuD2nZIS49l3S045Ss7+tOhMmLE95cHuW4Tx7LNz8wtPHJlbmN9p/u6HEqtk7nl5sbFzEmEsPf2SkcK3BWVtf8s/9zGRv+hgAlFUXHbuhfb/KQIunEXngorOSOefGSyal//Qwd+LT3URxNzCU+fyL5wiikuAwzcL5y449xaQG5d/brtxdk6p9fzcImsLaOPTBfnnjsHgrjl45i+N34YamdT876Ly55QeFBjb02B649nv8ksM1s+MJ4ZApvR5Cw5mzMs7qJqbdzAw5zwCbs49lzPf2pnf8w/juR+J4vzvDped+893r58dmF16MH5Ou5vAHLxWdu6ocZ51t7FTlp9/cizM2laSD3fGCIPXcuD2Td6p8TknJhTmXLAQRH5pWcl3r+bnnNhW9t3L+QtKjSXWV/LR3/MXlM23NgHa53MNBaUHA4pOiPOLytAhYnZJfv53VpC11PptqfHMjvKcMwfzz52Flf6ieHbzldL8M5cN3wkfPBs897sQMJvoUuDJcLC3OGd2/sE4Y1nRiROlc2efTIbubxVEQf53F0uM3x0oMc5pfzsnt/nS6Qtz51tP5nwXQSyYW/TtzwvOfk/knIrJKSkuPXs170xHMQjWXgxikcTcvNKOfTlzz/0TFhS/33vf82Hfof6Wmz94Lw83uY7/8fX1r24QtbUNDVuL52Sp6bp6rYogXs5YpPo4442Jr0x0TdpL90x/LqNIXa5+VF2p7pguz9h4f+X9u+4/Nn+WZn4GUZS/qJSqXrN5ddVTm6k5xhJiQe36zctqqFUbN1ZtJEqw2orujRvAYnIJI9SqKqi8nNIcYu7atasql62lKp5av2Lzmqr11Ipla9cSxqdXbaxYW1V9F3TdqnVVG2uJsvUrV1WsWb9qJbUW7tT6p9YtX7WRWPDU8k0rNq7ZAJCj0BuXra9cRZSsWrlm3ar1m4AoICzbuHFZLZG35uk1uINaXkvVrdpYdW/6lWs2rlqxmSit3bCKWrdm07plm1esvjv5ps0b16yvpDZtWLZiFbFgtLG5qopaW7W+8m67omrjuqfWLuP7V1St27B2VQ0xe9n6SZup2cai0rlFZfl/Yf6pTas23hOYyFv19JoVq6i5GcY7Olu4auOaito7jaIqqgTbWD4xWtxT5ehw2foNMP/mZcvXrrrTM3/Npk2Yo6oNq0APK4lCrKnlT1VUwJxVd9U6B3Z23p/Nues3r9q4HtQwSiJ32UqqYs3aewqew9erNoOUTwFFvrls7cZVy1bW4mnWA/4G4GjDsk3AFgD8ib9s3SrQOVYtaHHZ5lWwHpupNev5UWLBqiefgvYamBcLX7V+be2fUxmL84sIDEoYn4gIJXJhticIuZCYYVJwz7bi5yDOpWvqjrrpAPdVQSzh6AjBH/yV5s2/VsOcNqKM0q7TqWhcCZx9Yfprtfhu9UI63EMH8f2ecgv6mrhW8/4BeoBFfk457mbDO1m0WPulz5w4hlIwgpXKt33J424mBggSwwSJAkFiqCAxSpAYK0gUCRJJQWIEOjLSom7wK+NuNnxKh2oTblbjvC/u5hDQSj7qw+QCkz/1CQ7qyUBBYo7yiI+5sdxSP08dc1PZ4ks2+9zKUajg5OM+d3KrT/m5r+FTt/xLHy1+lwqa5maoOS3VDyHFJvlT2eg2V89lqcScWiXi4jVBuoxucglaXKC4j7rlBDq9KGDEic4SDhM3ixI5AIO8rAu+gpMgmOJE6FSdBUaRcBOqX4eCRzDRHpwiofAR+cgIyCmX3Exu8WkP+cx0rPJ9nxNFTbV3oddzdUpNgI66oj7kQw8IIDb+iFCFtkCLmZqDNm/qycqmv/KiNQaVCIZtZXoUk8/TEHNKSnicEijqjtIiyDOg1oU+zrV7YBIkG9EE8zQK1nVZe8xe/t1qoGe699qCT33KD31xmrAu2eDIVXvy+z6NEEMCI5oIj5cSnR1XYCXnm8lgaARobk6HeBj9VurwWKyXg0rtni76fjtehc99yjZfr8UJQX/xckdym8+92WJ3KvC30wpZ0s0wuOKrFaN/5YpiR+yoPFe50g+xOXpjOUoYgTQjeaUfRFQ+7XMvf8Kk+KxDoVCYzHQkR6kGuDBNP3p8Tg95XeEGguQPMoLookPsaImhiw473Qesn1hiaCvTu+29TqCQNx8IpAAF/H331aVrcDGrY9YZ0tWiXuVTr/QhakQwUwB8QQwcLdcLtrxmbNhtkCfebImKhh+WS7bFzoZcLVi70mc20dkKLyeghKYmneDEj3mebi0t4h6gxDoBkAKC3WWU2Wsy9zY46KPH6U4vbJg/oUmXwjzYlgs9waYmepeCfCWFm6V7rctqe3u2iVsCd9nEbPReEWpeefG+PCeaMCLXabtzthlFRMhjioUOhRMGjfGurTZ3nuJzanx8tLmvYrYnHilHzIMHZlvsvkavbgT9mIdF80DJtOU6MNCe2dEkk+JFGSOyT2cb4830mOjPKT8pe+W9Q81Njv0v73rrpVcv/o1oaQMxVuE/eOX2e0/9kOfhbLSQW0JNPvdjngKmbrK15w7+OBvzrwABPORvoJdeTktncTSt4VRkD+dq+yTPi37I0/0dpvfgR1m9DAnCpdOhnPbsgTxOdfFAnnYVaNJiH/w1l07i0m2/5uoiAboLLBksuNe9BRoNjlH2u6wmtEcN3WBBoxH4GP4JpS6ACt+yKl3CharOtMtIu1fSngAY8tEnrgFUoNw/4PGaMBOKbMrnAFKyCdnRWHeDedHH46mbTEg+N7Ht11xnjwMdKuIK6AjOSAfpJjLAThgZoAvHLFnRsSILMzdPp+X/krs1MY6p0qOpI46UbFAUqIQ5BcJRqlAuBOwglIbd6gXpsmhBNtMxOwXn+IMw5IOhPgWrW6l+x4caCyxO9EhB8n6fPICYgVyzqLEhXfjvfxQKp3K/76rDTv1mv5V8xBdpd0eGo8eW416w5XE3e09fwE+xvWhlocepIvva8tHLGb0yAWHiLp+KLOlyutH76eRiyGLscv/IjFtdSJoBPumyLCENf7beA3hOnOI8mS6DBBCyKQzktaL+dIeHTEMfZ6BT6Q5rlyAHP5tEM0YAFfAi0SpA4wcB09FlxZeZCtAFGK8brE5lk69X9Kx1CtKNXNt0xIe+ILTnh8wnXloxBN7GBMYxwQy7EbbfZ7YZevww3Q0OT3tiwEyHdekeuQKuTrf4it3dIxPM6epAs0dgHzSVdT9zsbGAW3T2wweD+T9GTZ8RghNvNyoYUQDNM/jZiWqtuQO8wTIukQrSrvaZWU5KT/Uq1Kt93eNUqm4v+GqOijUpkit8E4mq5Md9ugD1Gp/cNcdjZk0K3J1SQV5Fv8xRVvjIQ1nBMNhllT3ucxvQQLrbYgcAD0AD3ZCzFXM41aysbDZRCjNxElU0F6GRKB/3wUZQ8DIxmWrtGp+atz0RDCT7B+SP+xhxRiIcP3CKCQWJYtS0UlCmt57vzjEaerg+KqQHeqBl6Kl57XxWr9zmw3+eAuY6BIuW2tpDfteDJCU3EoPA5mAHXXvkU5+tYk5KDxdJB3AR1x55HDdbQF5YrZSeM06vfHfcVY1s+RNx+KFetwo/+3Y7SKfHwdreWA5YQVxE2yNPoP3LBYI55LTIQLAt2HMWJ29bAoKwQr/ub94pVnLcaJ8Vt9wpsJAKvLZwJloBAasgwt3BRWIv6wTt9eKzECNcdVzenXvu9VxVRJguQv2ez4GeK1u6hk0U410zfyS5yRc7gn6axf2NFqRgC08MbKvSO+AEF5lcghO6FRa5YE6vGywqpaftF8PSNWApbp1DoI0kRERtgSGlx9xxrEPBJdN9WXR/9yvUH8deLid/9bQHklHo4GOnr19b0OTrAgfA75BeA9SO1dAiVPcg1MDksV+Q+QecXCCF3wM58cqBo7+qiVG2+67aVWPk//Jd1YjktXAP0dnRH5VuJKuAohe2iN3Bcu9SE3pOvwQqgIM1BO3KLX7IAWfitQWf+87j2KW+QxtzcwnzTz2S1mjut/ac/luLxfr52TK993+jeCzeRit6tCalx2LvsEK05Mkiz0FkZDKAbgJPv5QyL6LGNmcOetwAhkD2Y+JUiPpzn/oLH7NSnwVRjIl7jpYC2VagG47chhb1lz62p5UMwpUs5WiAg/XXCueaUIEvPMI8UgDTtJptDxtgTWShcHbGwtHp7qWl7tOp1x750Af6WsOfnw2fAlDyhz6IABwQC1hw0LGyECzzFOyGl4DLiylOtD/dQUt7wBZsvxjAuubMAdtnYwXg38wdPdx+yjeG6ievwLESe5MMigxA5etSek7Rm2wjD3A/244s5S7Z2h/grsDNyaXSRm6mbfABC3ZT1+mZaMJUNK0ik4KVmopKRnAEpIA6/0m8WDvm5ovcCIm/gzJol/lezD6mEZ26f9MJGmKsCvOp+goHM/kBVD4iEBMQW4QAsolK4FHxl/LcH6RY+zGPeewcvens4APdkarhDDLNixJKTk9O8XRfcdLj/oorwbi23x8AZDIQ0DKeUwVnGSA2k9529DDpD6BHIR6NvemsrILYBSzlhbamRadf4BS2v69D9fPAONEiVZcTHSHslovcCmuXiECaCocukNlZMAtypSqqYmPVOhymb9wMATdaNqJ912duM+otcu08iBQhZmVR2TqnfLGX+fc8TkH3Ob0QUnocgv+ZZ+WSdUQryqw4PdMJwuM/b/qEwLNAzJRitT1ckJlKBjmVHT5fi/pdX68AQvCDj/V2wULSCfws+kLdrCuAYx9FSjFjpC4Qu+25dde9VHJPuQG2XDiGLacDYrWi1BQ0owJ2nVseVNjbxewq6BF45lmZPWoc4XOpbfPn9cIGPjTPjlHcbT+swMQosckszyg8AUExM/LArPyazRuXUWsq11dtXLUSiwwWQ8nwMZEotFXxB8W1BW/7erjnqZ8Z+7zT1wWn6ZRYoitSgL1WxQj6dj5EjBArWkzJb/q4P85zHs2Sbs8SKgQHAIH1tm2VXPgZ+cxscII1C784YxU8XWitQ0+McA9qil0cV0c/ACECwHYHwpFqxu5gsKtQ6Rtw/gTF8IBTOTjgbA+cZ7AKkudblW/6mMrCWKL7D00iF6iK5wRjD31RfrEMf4bRQ/7aBeew3SmoMZJdNdzKM9YuWdBKebnReb3taCGmLOhYRX5pqYUQEbskKowLgMBHaHtzviqlvIYT08l1cMur4YR0SR2H+VGVytdkw2mATz38zsvK4nM7IsORPDjgSB4esNiRJR0/DX4wG8LS4BeqXnm9Eke2v9Z4AcqDzyEhfdEBpxB5AY5ui12+OJvsuvNeD5/yyRAA4NGrTvefL/yYVeoe2+P6ixBwNa88++8ijrp4bA7aMJJlGy7K5jz0T1yf7W9FEBBnVnA/2lYYR9+n/USF9oDfc6LTRjB8B7RwToQy1dC6ZgtcxJ20EbXct7bn67gOm6GeY20n6zmLLaGW+82ma+B+tc1u4K5Sip7TNKegwmADOtG6x+HcCkSLl5ye7Bz1Q2hPBpD73tZl5Jw292rud5thE9drm7yae8G2bS33iy20lvvBpi9GywtPT2Zjt6DKQrAN/tUSC+buxC8Nr58QAxETt+w8V3/GtYSF8G8NfoPcA/GfIEDA5dISgTgQokCxQCrkCvioxY1jQ61GxOVoYrqDu1WfqyKsky9W6qWDlk+r3OQP+L0iqzB1PyMigo3WnlouSBWLeUiF/T76hYEb/K27l4xH24p6t3DhmgguAT01ohJdd17WqhyyPUVdgh9moLoRWOqKNb+O4fo6uLSOGPwmyNORwmb93bKvfWQveiOdjIp9GKTCHwVlVDVkVIJAFubpQljwlzM8dq7OplVz9TbX/QK70crNoUT1n1Y1fMxyxVB7p6rhAMtlQe3DqoZDLKemxPUfApFDGeyWjLcxtQMZrPlaCQ5i7vi3qhb8phbdNHZhvvE5+S+1kz9aucBTnZUeN0TabA/EDFyCKoyTaYJ7tI/7zGONbvkb/SFuFiOevo4ySnshR8MLR19D+x9Eux7EOZvbxNFtjxT0wLqYuMm2RwpOp5L9MAzUzV7Y1G5sybDqy/QY8GZxD2wyN6zmabrF63TrGnEQffAxdy/mpgsOC0BxAIgHzvlIIXgHPqyF0BePAxrMQUeeTnXCHoaJWj3qogGPmdbAHsH/KxoSZ8jFxIxb9vTAhIQEQHnBoC0aMDZyK88+bPBuERHy4oEQI3r1QcF7xVYr81YBUOzhaU3WdcGsWpevXeiVGGFejzEjq2oizO2U/ewDDEfyzz5l0UCyC5JQ+S8+WfEAdMIBUTSg/GJAkfzFQMOnavMAkEJLCsFflumvUxLZbh9YDQQhOPBYVKH82Ve6WIG/PAmES86Tdd8C9JS76A6P0xUsN2TjHBHlwA7kU+uaI9QA6xz9DyscrYnhcNaf/oHX3GdG5r3HOBM1Blwt95xt/Rrubds31bCLjlSjrSNMmR7MFT0/0kRHaA8PN9VD/idXBXCTQRlw1H7ZoQu/Uq8+3A9j2fVUkLqlnwxUf9SPe/EJ2j4uI+s59cf97Giq8XKG21Fn5hsoqqTtYQjg6lk+FkAvjVhQba519PGHw44fKdUcsSXlwEFx6gvCitvWXvdVy8XEnF6n1Z38qQ8SBQiLQ+hA/F368yXyx7yovgTRm8gvTeYOVLlJQQ4IHvPGwjG80kcKAxVjOkzmAJwgTAA3tmwBl0yFgqv8A+fpumROS0VCK0kjGuu6jXu05r6/l/A96UlJKp2Jczmtcm+JszUslJuPb/n4VoJv2laPxxEDFznB4jAxPJovAIi0sLgmJG+O1fxq4p4/NVTC/f1U0AJTlgkCMJNrqwLioYCwGKe1C706In9Sa4jUhytKF5vMtF/Rp11gOkZ53LV2C/cIFWBSLHFtDQgcY2uqONpXtMDB7CpJ6cF/Uf7LHI/AtMDKhdkSp3PhtuTpEG8xE6Za7BCUJxq5MMhCwxMLqDDdRMDuqMc3yEs4YSKhESXK6YBExejzIJPCTFP3RjU3wkIDKSFk6WIuD5Y8n7qSSJCX6s20EMNAiA8M4PVCv5Va7FYrghA/qHRxr/Mq2MXosyyLfHouhO5tvviAwOir1C0I3tt8ySd8ye0QucwoNf31uaA9iuXtY0ap28EKXs6wXvejXSOQXPrhrBLk3/lM6bwgf5VswVKona3UC6y4zhSpBaGEtXgRPRGil5AuiFxz59npOKC6xEBHeU6ndo0Gr3VH4cxw97oxp/YufF+6xn7VffFhg93icXaRkSFQdTvlt0auOqCGv2aqO+q208H4YZGbcliRDwR1jPbTMUAJP71yh8Cx5Na+5zN3kCJBYo6Vg5DqPZ/yaV+Kgn9MBeA9ZrrfiEFq6YVo9wikDDE93EvUr5C1UT93oSchD6BCyUnQ6sItJ7AGuZImCz8UfLisCz8zBEu3OJxWFDrVYU8hP/pfz90JLoL6jUd1K3jPoIuUl5XhNMyZsiHlyZRqOOJ6jyt6QQtMxRwcDIlVQd2B5uks3Nge2Uu3RRITbG/IzEM4mg7Cn79fr+Ek9JiWKP6vJPwivYwdjndRlCha6gePYIXAVWnyGtOFKN7Uhf+bI0dKDxoH8aLmB9ZRw0k1ASIJMm9F7xVFKQClJeoOBf0ohSfWg8XzBER3CehGRvF/NOr0O7ZtO8KFaM5zw6pzDjv+Y+OkJNcslPZfCB5XoHrPbYvH7mDGEdcWLLyFDQg/+vOiM5XoSnrOAwtqjtCiOjMdYO3yqGcOQVYJG37RLbMtpJz5x+bkrCH0x0Lauc2oXHjLtO3Uw4bP6SDQH9kvOLDQajJuU1HmJKPVCUAyAWG7shBHQJcXonHl00khCis3Oyz8E8RfMRUL65TPHIJ9Gz1NmTVkUgBx0Nvv3FJNQDfl4AenwkAK9EP08ctCLttWV86l0De5NEoke728i/wNWAcL7uJmdnBa1XecSmODw0gUGqdRSodGM3cN5Ya5qAuYgOwxb5eIBpY0YVHR3ExaDH1SL3rY4GD+XYQeLseeloVSO3MI5u31QqL12HKmdmHLriVv7CqHkEcPORsc1sUPcX10rIm77IX2aRpJSvCGlEDKA7tCaR6mA4GLkGTzcPLR4bz5ys9HO+KSPx9O/nQY9qr2N/D32l/7vej9/1fWt4A3Ua2LzrRp2vQdymNSaphkgD1NShuiQIhtKA+pIlA2RVsebbFoy0tKW6AviFXPtvd4zt0HP7duX5+e495b9rfPvTciakAUm4Zgp7B2iZiGD9myxzitOlZIQ9KGhsn91wR8fAeamfX411r/+tda/2OtNWtVB9GGGgFlkyYQVSSiSZ7zC2g66RXChg9ioAHC71QMZ4pnpaoxJDB7kwoD30M2zydAc/LyUBQPufNQHg9FBHkfmgU5QREeXz36eDMYFKqhIqBUMrCNbgHlkzBaea/LvXs1lHDkhebDrzRddLzU/MZLTUs4KDexIYP6QQA3CI0YkP/3NYIHYANQhAu8b1SDuT0OGKF1NV4Xu2qoaGjF4LTNQ6sxhuiVGvx8tubq72sYAbXUXH0dv9Wk1wVMZDoJ6gdiSD4ISKI00uXFcnaE5/AAKd1skMlmkGkFKHIYB8EnolgNrtrdN6DiWbVO9mAaYweHQtKvCn+lxocLF3UxwpSsixOBUVOufkGU14+FdGmk/kZIpHIC8MKesZCIo7xg+tXoS6IYVx96f7MrmUrlO44PoB9C0DYZgmFBVCMaSqIa03eiHH49RAW6nHOqu+fUc/LhcDfcoGVj6gBhrOOh+p9Wa7pRISkzTgG9UAf5w/gA6/XqFna6gMa2eDWiA/19i60cHso+Sgu1+YSwrok62UzDw1HB8BD81kUFr4vvBKp1mKuiveyXPlMKSiFBw88gvZZv5NwG52xxmNdEIcfaTU4232g83GuZPla1Lgpk1z8cNT8UtVZFSwDC8FuoCerfcuf0hFmkoTI6tvW3UdBf2aWWAlFJYtxKnOyomACphIQV6NIWahhIJOc7Ddo0Lp9bMOnFuQLq7vQt1k0A+kj0+IAMP52sDEC7Zie5wdwsIseqKqP630YPf9BpfiTKQexPxzfMIoN84lgGVEJ2mjdFORHKEXFPk8cWmB4nYtDZsWgr369uSUXbzDBe9YujDvOiqHl5lAeCZ5N4xnVWrS+7Rx2PgyPgEEdthCmnTAxbF0UrU1OP5wB00GyJjlUti+rvjQILpnMFNJ887GTNoFMtj4qUAQp8PDFX21IMAhB/kLCjlk4thVjUZCZXzlNvJ+4UvxAfTDFWVRaFDlkITdY9xzLTJzAi9B0xDx5Iuc3Lj36etkUERlAWZTQaIFymT9y+q9AoAq0zvPoyEPJ5lNuHxG28dXnUOSByY1Wg/eI1oPuj6NZW/QNRXhTAMVZVEfWijK3owW2Cz7A4CtFjW5fiJtMvjRoeiOK++0DUywOITREWfIJvbOv9UQAs1ACoYSnuu8uio2y+Kc1wL7zTTbTVEnXScyktUKfXVEAp4T3HNB2yuLoNoW1UPo5nFV6eyk2E/cyovDze+g8lQLkZGEfRKxgqoqK+Avv5oHvNtl8OZXfpZoB1xjSr1nkhRCNyhoXRI05a8X6fyK2ZSYRReq22R7N5bRAcmyFamQYEKOw1kZrcKGf0D2D+NeCBhgnglnHJe9PHrbUjT7XrFkXtx9vJ8hnqFx7BzbKjFlu6x4txxQsLE30GLH25wbwid2deXldSlhixMCjVz9Y6zKdj5pqoe++jvuO1Z9+vvXCq9vOPa9ddrvUM1p47V/uZt3bAXetaX7didd36FXU1z1S7e+suba4joK4gEajV8F7xMORLlcouatGKh8FBFSd8N0HSKAmQXSnSApZUgLWZUY001T4s1YpAowe3K+ikGdRY59uwGZ6i1/pJbI5JGcaDIAgOeOOWv7rNejrWa1HhXWxoG2hh4B6rOhUDPdEZw3XgbOVUkq1Hdzr2YTtnUnVLCpPC/EmMAw2zywkldZs/jnHWj2POASySyuiY2NUbNpGzcV99f3PwYlekrzqPM13sTggJDvNzSMsnmoB8rc4DylpDZD16O46OPX7lkXJHhd+SgmWqChy3wWGalOabZql/rPPNTJLmgQ0+F366gZlpEjMQ7Bx5CqSyoPvXiOZR3tgF1qPf+pdI2eC39eNp9fZhdvCj+uF74eEAG0uwOiec5vcn2FLDSET9bUSj/2BCpGblN+fl552iM0An+4ROyT85+Of6vPmERrR+MHG6n6m3fjjxEf2l9f0JJ0s5ILUBlOcPJkCjpv4B5i5XXe8KcHzAp95eP8qOq99cP+plF4JtBLnhL/jAPDSciwgqV2LR9VwECHs2YlxMjNK3vG2MF6uveTxnjkyABTo5cZ1W6oaX4R2/IKcaIoFqkG+PVLiCYkAQS6vtUtFgXz3YzSlSLeiRftnCbohoCZ8a+N7ZiE0ztvVcZJRdUAdK0Sk6DXA4DUbLSflbCfpra0PE2V9XHly1bvCP5pcHj2xXqwiwQAGqnQEiBqGX489osM3MMGBDtzCQYlYnmUGYklzJLWGIQ2sWBsvosfCKh0XNlYMNqKkBqpSoTXI1mMx1YqFKNBrxknLQYqqotDMzefmThPDo5/dsh9SaYNmqdTT+RmPVusJhhUVRyCoLnV//bbvKpcKTCRx6Yi2qMQ3dj2dpqDQ8U8lmeUUBz5GWhn2rFSmApazyUfk1IAbAWp4/mNsAxlNyZu44v9I2H61uuOaor4ZXNUTqBrMaJIYtlcoHVQ0pg+HHJKMtjf3aCFHFbLk0n/3oDI2kbex0yUB7mA4pyZJsl7bZaDo1pUBynMtlCp6pLsgmUtgH5RQayOuGVETP7oqUV1MjdomxFfePb88mmcwUdh6AMGzEpz76mG9TrVTXd6aPSfx1DCsue70V05lB0dtlLBhJo2fc0+Fkc+3DC1i8HJZqSzuneKY6hQ+yaz147sTr8ggrO56WNHiYRXrQ/PuwBWL0L2EzgBCgaiYPFSn9LpEXwj77UWYmUY9Joulw9ke2g2IMJOCD/Z9uv8q2BdBwE57ZzSYoRTZpC6ZAJBQjYM4HhIZygNDLs4mOsPPszp2ouxG8QefghcderrDRQO0Lj12jouEup814liKCHLS4J+AatScNZBipSQH6Np4OtQm2//VSsy3+RpMleSl/GVWtMByIGI364xF1Ku5ifWCLoaWPm/8WAbusnWlnwAhF5yVsoaGLkv5YBO3boczXDUaQT1qcxuROoblFeFmkuUl/KoJ3gbRG9K9HELfDcNd4RQV7rYcnR0g62Xx40nW3NIZBV6Soriui74jgfR3xNQ4YViMRs3NCv35C/9GE/psIZgQew7EIF7KPKCLkmXZWMaKg509x+ER8KjVkD0eS2oM/prBy0EjKmXY6aYoDfzL47xwoKsckJ2IgaJi0TMihurUxZb4DV7CdyZ3U/X1KmY6/E5WPID0dcfYJd7bU5MiAdimFxQuVuRHQVfEYNRq7TrjYMdAya3aghTvklUAwdwO8e6hCBGKx2SLY0ULCbP684EGjfiAicv1/ae8rpdL7MMHCFwr24u0kCRLoInEXlCiEj/y5lFXpz0TwHps+mTJMW1B3dVn/7XK3drmhL3L4A7WaGGwuH9t6JjJWVXCTsznMZyfwFK1P0H08gULFwF4C18PyIkWw4vrJ/ifLA6IAgaM0SPKADy9Wq2VAngONFTQfeTZQgNf2XXhrSQboCsCb8pPykuloBnDBc5E7y6mXgnj2d/llaesybvC/GtCjFUa/YFiDLZ3WCGvg8exBySZ5Ji4gHj42vqXCp346hKc4vAIZlqz1k6qyceFxl/HIi/WHX6sGtiRAN/GQ/0moXKOfH2wQ9Qcw110DpkxrhEf/1QAp0B47dAE3uTqRhgNBe/bPdbgjfr2sf2t51GcPMz4747y154kyWkGmEapzCpAtKK0EOPF103o0XIzWm3n0bTEPVq4Awp8qJDMJvC7A4GlZYdd21JrYatzfVC7yrcY2PvFtFlpXwruOQiI2H6+479ruvv0A+uN8Hu8JQNeLfWhbCfUVXoTF661AoH5ytR8ZngBz2o5nFbyeMPI3BavrsIfvfm+ga5i87DhdenHGPenJZxh2bJm7sxhpl1BZSL+ESkP5S0Cdl1fs0KUmct5Ojx2U7N838pAaGRqFZvRZk5ezkRCkeyUiyAcpgmhW6jcI2XHGnulklR+xySfpm5IeTNMAI3ZCKvUrEZvP0IEX023JmCqhYvXrkVHocLy9T52LBzyTKBDxxdNnDKRfk7IuLGxLpm46s4NhGKui4fVISaUyrmJGLakwsBkxyAXV2bgDfhomjzZ6EuMdFArMYATozGNbOyKj5GeN/SuadGsn9Cd/lsJjWz+YGGWn2WEcScm0Aq1scmAznRo1nJyQp4kAks0TIYm8I4ARE1J/wCWLysEdQFbcgipI/IP+rQi/HvMzRjS8FRFH2S/JJU0ex4dywgHoj1DL7bsu84HRgLB910VXMCj4PJyXP/zBgHG1cb1g3DefUG3YbJQhUVUDD+J0+y6j+1SjzGUD6LN1AeC5duwRnlPnEFeay9FvGr3QophNC4ZXIyL6tAn+dG2glro3NfIBudWbixYMpE9LzqMmITn+1gqvgfeBZjd7PcaJTqlQAb3wcfhxaBeMi3G0D9qDI4cqPdB1HNV2Z8KdvBPLT6hPPofmNaI5G6HMNheU5B9iwaj0yabKUCF0cjYFYqHz5Oz0onU7wW2jw92AbUVQkcIiSCZ/AX8WBXY6ApU2QbCftCR1QCN6oC+5eAEGQuNOoCXY0oZGuZtBLaEcgPf68o9S50U7Gtkpi3MP+mZXMEDu2ukpO6MkLlbaXzhdcXklh3EdqqyXhb2gWa3X3Owwz77ZGvAY/ehVc2JfoYvfz4lDhS6vZyXnRw1rr9vIMKsOArZ4KT0s1warE0UJ+uOqCUAP0cUHPeQfzR5Mk7APaO8NVpRVnrERF/OdHQP2u8i/UOHxBdZjcvHQ0vln6Jl5WayKyQ17vS6vg+Ph1fGHp0s5YNJM7j+oH4CG8pKy4BNxIszwLLnAuEdN6byA1I3wAAYZkO13GUE7VN2H6tfKSPGuYEUAf0wW6HQO2I+Ctlx6ykJ2PpilJHyQXeMeVYVXXC/TQwQI/I1r1kDuJKeNY5VQznSokINC8QeiS6/3uyrxEPywcWzrgQh0Ezf4H5dLsjvZYjnDejSjOUw2Ts7MKLiHXWSXaMtMUHKopGRmBv1jMFxtbZwsZZOBP7v37GOoq11SxmDFbin5SsVu9oYNz1NTP8gvOkp5gebNwFk/uXIERkGhaNg+KR/nDVK6dMDuHBDUCkJjl1RgeayX3D37eLtzCdgAEgN8BRAP4NXFwfZ9+scnUZXEkfE1HpS92y49o1XQc/zS77QkO0t6g80cWj60Af4/rU2j0vxDJ7RJFOmHsCqf/W5OzsEj+1CNpPUZ62WR0R3GWffv2+ftklSoVrrSs08gFYSq1Ubw6D+aoXKCE1RlrEz0h/YCKDsDkBAsStSA8bQlARD6fi8v4KM52hMbCZ5bTPDcEnXEEQYkUZMUDLOZ9uEiJ630D20MLgmHHVoS3dpteHySTCVUwbdGeiIk6CnB8Fvmxkm789YXe4Jnexsc6G+78e4NyGKvZPRre5awqUNFQ8ud2qQw4GpJ0SYFHWEHZBS0pBj97uKNqEWClkCH8BMs9scnZaJ6eY7WCJ6wOrTH53FyQVfZ+Pd7eM6VkK8e+880Vk/t8S35jpy7BxqKOg91dk6Cx4F9nyQWgLolkN5h9OZuqH8PLsbrsinc/9Esn5vbsBda73c4NBiutCmBMO54K0ZD1GE8RK8kH7CbgHtepl4aBiLa/ENzh1h8UrA8CwEUDGBmA/jRaj8UJpGD7+6VFP3P7uMd9vBQYTAQPoLHhwD8RnQBdfPRW2DRf0IE25ks+nrQBS0nQTYezFBa9l55dh81gqb2CkoChffynHw4B4fJoyI0HPqDhHbvZmlbukWHXpUo/Z2AHFumJRe9KVHqRAD0Plv2FWjsP2HME2G2XMsY+qtE/Yh38pavdqC5e9wt+7JJienz4D0pRd0CNKKdd51isyUFmy6l0cmdIPOP7LNz5KwdHod77p7rZPBhNV1Ez9pCTZf79SNP3tl4QnY/6KiuD3uERB3AiFFMn0GPS3o6u1sqsunp1Op6iLJU6OrCynhll6TvZA1SlsBu4KV0mq4EoM6zj+3DIHOldPa6lEVndEs0Ow0SZ7EgvFUfsRmn2TQkw5jOCJKeVUApRpxiPgBOSEWsFlKpcMAMyEJdmWi8/ys33jRoPH4xoasNdw/TbGpicwx3PewPhq++ag5+8aqZ55wD7UxKX9C9Yp/WQmoXk9qlpHYRqb2f1JpJ7X2k9l5Su4TUWvGucPP/i+ENZ9m7sZTJaBb1n8bEu84jk6LRz6b/HOHyCp4uKT7ob8Y9HtI4zGdiRry0zeYNFUkb6TTw+/GAgRQrHr4DPX0/QFvPxJxsJm4rXWivYPg09h2P2+HO2pZX5NB7kl2yWvKFKjtzD94By84Ax/jc5i28wxZHTolDH+Ne3vVimcvnqaxQH2oO4D2+nop8Ju+ki87KooP5zvEdzTzvdXLOW5ub83vzTFMP8kK+k/a7Jx9ZubwqvnbDJmnlxk23KzZuiBGftbzT+nbLMy3onCT4wglWGLuy5lFb/OXeel1vswakRbB5PoHfojfAoVf235noXdAl2C6heS3Y8jkyie0oWwvP2S5CkANNtoJESd5vODIpvz6NwdPL29FXraOmZIaKoBvAp46A97D7q1b0RWsz/Jq47Ivo5H70XasLZexXifghwAMT3Qvx7aOsnHSUcN/cN/wCm+QgSxiJDKN/3599CRIGzZMTV3sbrJMTEmkOh8Lo+01BjFZtC50LZl1i2RECBPeSFQxeeRy90rJfOx1a3uin0wRd46RSSWnkxsjZaTSuzlZCEF4dz2LTcieWL6bB/ANN5rtWZTpgc4oOgyHVMikolRg3JjfKq3EO+Xl4tOROUlkJ7xk6Ha9x6eL73VktHp2yBWW1uKhTq/HHGVaias+u/bSVGNtacDOv60QfIAhZKpV25lrulJttAzpCYV+15k4pMTKgEYI76r5B4H30mMpeoHB+HiYrPVmcCu8F9C2IBiTfKqmW8awHw7j75bf7R4k2u5OhxVyRvBVXOdyjxIct/S3P7Xu5ZUvFz//vzhN2uv/3nXj3r+IRagWWuAdLwzau0/028WVLSutz+wyty1px9JPwPNwq+EhQURzt5uMxDK8AeIlkVbbvoWt4ecqd/T1u5lGCGrdD+GxbvoD+rfVCSSuPnm5lMwXV4nwmk77Fo5JWB2TBdUJsH66sksAdiJEJIOog8zOtInq9lZ4uQH15YAKJdoCc5zkqKlV2KX/Jsj7IYQmHlrUCfPtw/jD5lvu1YnC3cBhHeyVY1jPrZed9oKgLlao2nvvJe4xL0OCj1l/SoNO9jgSL/NjAvffKJbQv4bqlNKikLGK+IUxzqemyVBojTBSlkp08YcrCHfe9Ntn7PSFfEoV3AFpn3HQO2LJQQZstHR74eioO/YW4CKDWxyLOAfSdZMu6Zku/Boweujwn70lMkcHMj0XwGtobBJspS6F5jcF6pNuZmKeTDSCeuyal90F6tBCy59CPkjKON0IAU53ZLmWxGZIK+G46+yOTKzragZ1yCnoCaxw9wBVR95P4kOlB7XL0WgNYpNo8GCraOJsxLNYDB3hJS9r83e4QAQJTyv48odQWbAziMwTOnzg/5X6RoJEnLuiKD+ofjdoI86IpMPuX6hdP8eHE5La8ENvtpFO1JPlN228fDIbRBhLP0LUwm2rJAkKFN/+4eEWHlGyaibmOZ6iIOtthtkyh1IM41BKSjW/BEYawCqQ7eGX4QAfkYXcODh8w3z8lm0djVaVT+C0Uz0VVpGBYPGV0hcAG8m7fFZ2yxfFU+NuPWu+fctLJkK0VMt9AgredGdtaOgUIYJVVhFShqMvlEvCqEWW78Zf3+7dUyBm6MrA9hVfSqSSXawpfJnRl3YGQ9fUYvtXQumgq1ZKqK5+6D71KTOkWTdkjPe3Ss/1rDwAnOUpQUQAoBcpo44LHB2WHUJSY8rJgPnDg84RQhJhySWncctuhFbZDK22HVtkOPWA7tNp2qMJ2CL15cPi5g5fOHPy77tDQ9YOfxw5+8fXBCwMHa56pJnKnTZ9JEEkKZVp6emZ2bm3WG5mjGaUZr6cnpbepxLQ9aeOpPanTUy1J2jRbzmnLBsd79NriaVAfW/k7J9q5bktySWn9e6ylOA8TTf4Whh8AahiNtvIPIV7KNRVEcuupzyAHRbe03JRdnAuQkE3KCTapnUNbKiCmA4S+5WaxmvomAaYyjRbnUH7sAcgvT7CXIeUX2JyWUwsMYzcvnVrcYzRS3aaPAeTkCZaXHjMd71YSNcOZBaapc5m9le62Q8s7h8t7K/HaeoHEsBrJyM6Q8Cl/GdVURlaHtBJ69WqazMoqzoFs65SErv6gar1u30FVN3SFMlZ13np+NjUBSP5b/fMvVvvk0tfjxXw2F5VU28pPWwJQ+rUTLPkwP5NYwdQJaM1CvPMRZZXoNrWjM8X4TK7nSzbV4jRgm9A5OMuxLbZ//pn94f804aXKanUKMWohRXIizguqVqaNyU4KMHXdI5+2B2w9J9qZzED3SDmbKVtxODozU+K9XSfYFPBkZgI7ryJbOoeTcnJymA/bjV0n6EzBunQq0kNmEKp23otPGkK5B4HhQcf//QHoxeXEA9OVPWolIX026OjqcC/aO7b1asgHulQGjMxSb7UPRtE8eX08EVCPA6bL4/aYrZMmy8K22deC12yLrgXQOQLvTNgdo+YKuidjlHbogaGNQ/GhPwi6p2JUrk2B0g4b/cJMQrc/ptFokNROZUM2ZVI6sAK7gL5t54N+97TVAICmNILuoTtQ9hGSb+eklwZn75DEQeMO6ejgwh14G9n3t8l0QrowQJLp0tEBhfTZgBS/LPilP7Gp0u/YNH4J5yJTMjm/9AAdcvkTuMhbBhN7d/Ty/V4iSaqNnFDR2wM6C7kupkpsJ3yRtvkB78nsdGUuCNH/JizqFHa2nakHJ6u0kde6qXTpKayCmvD3c7lfIrYti77Ec373EOF3XyAkdvCLdukl0GRF9vpP1RQTt9kVkk9NqgTxzmLqxSb5CCg+kJ3TcYzNyj8G2GGDmE3NDe0HI2GqBXEE3vxgeDMmb3r142vdKJ1cl7GqN2Oc35YMxBWsy6buuWXpzLlnvLDTRpjIMvRaMc+NpLITtjgVAqsW2GI68hFUPnanAD7oMgHSDXxlUqbpein6isC7qCAyzQQ890uiIjiSXCYldVi+pfzklgrP2Nbv5N6RhfdYSbkX5e6gH8Kq98+BcqfJSuzDAq9ZDPm8QUHUfxc6Yh4PoQaoC+qLQ4JZWBAoPsfGUT1hfTdUj8iN/J31TFZzNxLfyRk7Yf5nSEC7iJ+iVRBt/jJ016sE7VJ24+BZIBAxxZNw1mQKcUwXC7GkSq28OfYutO3c/v9ux5fJ4aXQ/+zCcxayaMFtgJ4nKpWE0Vh2xm7J5AWwWB8lgsfwB0Les9sw3m91Cb4EkAcMOjzLBQbcZkKedZoLCje0Qjf6F0LkuZRbsnKES/HjqtByPXuJgIyvEb1RHehG64iO3k4lgQ/PV/Yw4GUYtIYYyXkXnPhOGaPfNeCRE2hxHrmQR4BJwPSc+DUM3lX5PNFtSpXKAaq3F+AAAPTrVEAKb5Ut2OiqcFcQfjBkAcuZ+ApXjV3eUm3Lg5CZBAaSxazUvW4VfyRcKOr+1K3pfIdOZjreAemlOxHStDD7g9p4Ab4fECp3+sKr3fgmzQ5i0E64nybiycuIeOpT8PulKz4nPufXYX65RIwDZCnPrcj9Wh4NUndiUikgYw9eqCzulM+XqIny0cvUnrA8vRc8bXlsqLCbQ9dvUzXo5m2qCkVvU+uRdJt6CCVL1CqUJlHLUJZEWdE0iVqEZkmUCRVIlBHpJGo+mi9ROmSUqAJkkqhZaJFETUNWicpCyyQqDa2SgB8/hCcQFh4KkSVJ6tdv6167vZgbe1fXE9KviaHaI/oHY+RRQt0T0v3mqbF3kY1wmLdHQAmyFZlrwzarWXvToCD0dFT3TUS/dkJ/IEIOECp9a8RGmt0RtMeOhAbDgzGw7/VgcfQ2oPsJ1ExAD9dlpOuvhnSX7Vi1z5Td38ju7CTsvo3dyiTjkffl23EPHvlVJoVH3HOWg4ryVQgy043L6RKp5XRgwoiGA5HEHiZyPK5C0+7TzX7KDfHE9V/c+3y47EYThe995kLZhNoV03Gx/OOVPkbQEeUo3y7olq8YBfWZNmCPx/cPvjN8mz9bQMBYyLefi5+nfv3Ct9cE9jMBtbRMc1jqs3zMM53H1JnE+D+PnFNUSkct74wkV9o03rzMTklheQlKU5bbey0KUM05ZLCjuQQgrib6Rk0KEewyQ1oPru9h8/GphJ6JtPYtnR4fyiS8ruoTDGcrP1oxn5hzvgD/zYG8O5SEoHPFVCOZxyvt/HFuyCmPB9AE5SGlPxYJo4K9Qdwqx3CGYcOamDosacrGW+2YYPL6TWIvWFAIk/+O54IBJRVekwma6yf3NOi3TxqN0LquBJQer+K5oh5r/WRzEbB8jegjVbKmKi4GLbVsvN/OkyroDw2T3LqqGppu62w78MSTxKEnWuXzCxYWm7LSCRyzYnnVQytpYmXz/s7WXU07D9ALl1ruxecbrNu1o7W5rbkRf81Dr+g88EQb3dj6xBPEpb/WUcmX/trWdQnfcZWGXgmlBeHN/eO7X5okd///5p57qGz5tMPEBR2UfKXDbMLyC1ciBlwkSRLEP++cORnPUaS6CQL+cjZH46T5xtSNqapt8xfkzFuQPXOO7CJIgrSq//X2sT4Fh84/VUcp4NnWQWXL16Lji74rRmLvVZvj8W7uf5wX/j/+/X8=",
"MSX1_PAL.bios":"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