// Copyright 2015 by Paulo Augusto Peccin. See license.txt distributed with this file.

wmsx.DeviceMissing = {

    inputPort: function (port) {
        // if (self.debugMode && !wmsx.DeviceMissing.IGNORED_PORTS.has(port & 255))
        //    wmsx.Util.log("Missing IN " + (port & 255).toString(16));
        return 0xff;
    },

    outputPort: function (val, port) {
        // if (self.debugMode && !wmsx.DeviceMissing.IGNORED_PORTS.has(port & 255))
        //    wmsx.Util.log("Missing OUT " + (port & 255).toString(16) + ", " + val.toString(16));
    },

    inputPortIgnored: function (port) {
        return 0xff;
    },

    outputPortIgnored: function (val, port) {
    },

    IGNORED_PORTS: new Set([

        //0x10, 0x11, 0x12,                   // Second PSG

        0x90, 0x91, 0x93,                   // Printer
        0xb8, 0xb9, 0xba, 0xbb,             // Card Reader?

        0x80, 0x81, 0x82, 0x83,             // RS-232
        0x84, 0x85, 0x86, 0x87,

        //0xd8, 0xd9, 0xda, 0xdb,           // Kanji 16x16 Font ROM (JIS 1/2)
        0xdc, 0xdd,                         // Kanji 12x12 Font ROM

        //0x7c, 0x7d,                       // MSX-MUSIC
        0xc0, 0xc1, 0xc2, 0xc3,             // MSX-AUDIO

        //0x7e, 0x7f,                       // MoonSound Wave
        //0xc4, 0xc5, 0xc6, 0xc7,           // MoonSound FM

        0xc8, 0xc9, 0xca, 0xcb,             // MSX-INTERFACE
        0xcc, 0xcd, 0xce, 0xcf

    ]),

    setDebugMode: function(mode) {
        self.debugMode = mode;
    },

    debugMode: 0

};