// WebMSX version 6.0.6
// Copyright 2015 by Paulo Augusto Peccin. See license.txt distributed with this file.

// Main Emulator parameters.
// May be overridden dynamically by JS code, external Config File or URL query parameters

WMSX = {

    // Main Setup
    ENVIRONMENT:                     0,                         // 0: Default Emulator Environment. 1..99: Custom User Environment
    CONFIG_URL:                     "",                         // Configuration file to merge. Processed before URL parameters
    MACHINE:                        "",                         // Machine Type. See Machine Configuration. Leave blank for auto-detection
    PRESETS:                        "",                         // Configuration Presets to apply. See Presets Configuration

    // Full or relative URL of Media files to load
    CARTRIDGE1_URL:                 "",                         // ROM file
    CARTRIDGE2_URL:                 "",
    DISKA_URL:                      "",                         // Disk Image file
    DISKB_URL:                      "",
    HARDDISK_URL:                   "",
    DISKA_FILES_URL:                "",                         // File to load into a Disk. For several files, use a ZIP file
    DISKB_FILES_URL:                "",
    HARDDISK_FILES_URL:             "",
    TAPE_URL:                       "",                         // Disk Image file
    STATE_URL:                      "",                         // Save State file
    AUTODETECT_URL:                 "",                         // Open any file in auto-detect mode

    // Forcing ROM formats
    CARTRIDGE1_FORMAT:              "",                         // Normal, ASCII8, ASCII16, Konami, KonamiSCC, KonamiSCCI, FMPAC, etc...
    CARTRIDGE2_FORMAT:              "",

    // BASIC loading/typing commands. Not needed for AUTOEXEC.BAS, AUTOEXEC.BAT or Tape Images
    BASIC_RUN:                      "",
    BASIC_LOAD:                     "",
    BASIC_BRUN:                     "",
    BASIC_BLOAD:                    "",
    BASIC_TYPE:                     "",
    BASIC_ENTER:                    "",

    // Boot Options
    BOOT_KEYS:                      "",                         // Keys to keep pressed at every boot, comma separated
    BOOT_KEYS_ONCE:                 "",                         // Same as above, but only on first boot (do not use both)
    BOOT_KEYS_FRAMES:               -1,                         // -1: auto; > 0: number of frames for Boot Keys
    FAST_BOOT:                       0,                         // 0: off; 1: auto (same as Boot Keys frames); > 1: number of frames for 10x speed at boot

    // NetPlay
    NETPLAY_JOIN:                   "",                         // Join NetPlay! Session automatically
    NETPLAY_NICK:                   "",                         // NetPlay! Nickname, optional

    // Internal Machine configuration
    BIOS_SLOT:                      [0],                        // Slot to use when loading ROM of type
    CARTRIDGE1_SLOT:                [1],
    CARTRIDGE2_SLOT:                [2],
    EXPANSION1_SLOT:                [2, 1],
    EXPANSION2_SLOT:                [2, 2],
    BIOSEXT_SLOT:                   [3, 1],
    RAMMAPPER_SIZE:                 512,                        // 64, 128, 256, 512, 1024, 2048, 4096: RAM Mapper size in KB when active
    RAMNORMAL_SIZE:                 64,                         // 16..64: Normal RAM size in KB when active
    MEGARAM_SIZE:                   2048,                       // 256, 512, 1024, 2048: MegaRAM size in KB
    EXTENSIONS:                     { },                        // Extensions active. See Extensions Configuration. Use Presets to activate/deactivate
    RTC_ACTIVE:                     -1,                         // -1: auto; 0: not present; 1: present
    VDP_TYPE:                       -1,                         // -1: auto; 1: V9918; 2: V9938; 3: V9958
    VDP_PALETTE:                    2,                          // 0: WebMSX Original; 1: V9918; 2: V9928; 3: V9938; 4: Toshiba; 5: Fujitsu FM-X

    // General options
    VOL:                            1.0,                        // Master Volume factor
    SPEED:                          100,                        // Default emulation speed (in %)
    AUTO_START:                     true,
    AUTO_POWER_ON_DELAY:            1200,                       // -1: no auto Power-ON; >= 0: wait specified milliseconds before Power-ON
    MEDIA_CHANGE_DISABLED:          false,                      // Prevents user form changing Machine Type, Extensions and Medias (Disks, Carts, Tapes)
    SCREEN_RESIZE_DISABLED:         false,
    SCREEN_ELEMENT_ID:              "wmsx-screen",
    SCREEN_FULLSCREEN_MODE:         -1,                         // -2: disabled; -1: auto; 0: off; 1: on (Full Screen); 2: on (Full Windowed)
    SCREEN_FILTER_MODE:             -3,                         // -3: user set (default auto); -2: browser default; -1: auto; 0..3: smoothing level
    SCREEN_CRT_SCANLINES:           -1,                         // -1: user set (default off); 0: off; 1..10: level
    SCREEN_CRT_PHOSPHOR:            -1,                         // -1: auto; 0: off; 1: on
    SCREEN_DEFAULT_SCALE:           -1,                         // -1: auto; 0.5..N in 0.05 steps: scale
    SCREEN_DEFAULT_ASPECT:          1.14,                       // in 0.01 steps
    SCREEN_CONTROL_BAR:             1,                          // 0: on hover; 1: always
    SCREEN_FORCE_HOST_NATIVE_FPS:   -1,                         // -1: auto. Don't change! :-)
    SCREEN_VSYNC_MODE:              -2,                         // -2: user set (default auto); -1: disabled; 0: off; 1: auto (on when available)
    SCREEN_VIDEO_OUT:               -1,                         // -1: auto; 0: Internal VDP; 1: External V9990; 2: Superimposed; 3: Mixed; 4: Dual (main: Internal); 5: Dual (main: V9990)
    SCREEN_COLORS:                  0,                          // 0: Color (default); 1: B&W; 2: Green Phosphor; 3: Amber Phosphor
    AUDIO_MONITOR_BUFFER_BASE:      -3,                         // -3: user set (default auto); -2: disable audio; -1: auto; 0: browser default; 1..6: base value. More buffer = more delay
    AUDIO_MONITOR_BUFFER_SIZE:      -1,                         // -1: auto; 256, 512, 1024, 2048, 4096, 8192, 16384: buffer size.     More buffer = more delay. Don't change! :-)
    AUDIO_SIGNAL_BUFFER_RATIO:      2,                          // Internal Audio Signal buffer based on Monitor buffer
    AUDIO_SIGNAL_ADD_FRAMES:        3,                          // Additional frames in internal Audio Signal buffer based on Monitor buffer
    JOYSTICKS_MODE:                 0,                          // -1: disabled; 0: auto; 1: auto (swapped)
    JOYKEYS_MODE:                   -1,                         // -1: disabled; 0: enabled at port 1; 1: enabled at port 2; 2: enabled at both ports; 3: enabled at both ports (swapped)
    MOUSE_MODE:                     -1,                         // -1: disabled; 0: auto; 1: enabled at port 1; 2: enabled at port 2
    TOUCH_MODE:                     0,                          // -1: disabled; 0: auto; 1: enabled at port 1; 2: enabled at port 2
    MOBILE_MODE:                    0,                          // -1: disabled; 0: auto; 1: enabled (forced)
    R800_CLOCK_MODE:                0,                          // 0: auto; (0..2]: R800 CPU clock multiplier;
    R800_TIMING:                    1,                          // 0: off, 1: on; 2: VDP waits only. Precise R800/S1990 timings. Turn off for faster and lighter emulation
    Z80_CLOCK_MODE:                 0,                          // 0: auto (soft-turbo possible); (0..8]: Z80 CPU clock multiplier;
    VDP_CLOCK_MODE:                 0,                          // 0: auto (soft-turbo possible); (0..8]: VDP Command Engine clock multiplier; 9: instantaneous
    Z80_SOFT_TURBO_MULTI:           1.5,                        // 1..8 Z80 CPU clock multiplier when in AUTO mode and activated by software or CPU_SOFT_TURBO_AUTO_ON
    VDP_SOFT_TURBO_MULTI:           1,                          // 1..9 VDP Command Engine clock multiplier when in AUTO mode and activated by software or CPU_SOFT_TURBO_AUTO_ON
    CPU_SOFT_TURBO_AUTO_ON:         0,                          // 0: off, 1: on. Automatically activate the CPU Soft Turbo when supported by machine
    CPU_FAKE_TR_TURBO:              -1,                         // -1: auto; 0: off; 1: on. Simulated tR CHGCPU Turbo activation. Auto ON for 2+, never for tR
    CPU_PANA_TURBO:                 -1,                         // -1: auto; 0: off; 1: on. Simulated Panasonic Turbo activation. Auto ON for 2+, never for tR
    KEYBOARD_JAPAN_LAYOUT:          1,                          // 0: ANSI; 1: JIS
    DEBUG_MODE:                     0,                          // 0: off; 1..7: debug mode. Don't change! :-)
    SPRITES_DEBUG_MODE:             0,                          // 0: off; 1: unlimited; 2: no collisions; 3: both. May cause problems :-)
    ROM_MAX_HASH_SIZE_KB:           5120,                       // Maximum ROM size for Hash calculation
    HARDDISK_MIN_SIZE_KB:           720,                        // Minimum file size to be accepted as HardDisk image (besides all valid Floppy formats)
    DISK_ROM_START_PAGE:            0,                          // 0..1: Change starting page for ROMs > 16KB when format is DiskPatch
    LIGHT_STATES:                   true,

    PSG_VOL:                        "f",                        // 0..f (hex digit):       PSG Volume adjust. Set globally or for each channel (4 values)
    PSG_PAN:                        "8",                        // 0; 1..8..f (hex digit): PSG PanPot adjust. Set globally or for each channel (4 values)
    SCC_VOL:                        "f",                        // SCC Volume adjust. Same as above (5 values)
    SCC_PAN:                        "8",                        // SCC PanPot adjust. Same as above (5 values)
    OPLL_VOL:                       "f",                        // OPLL Volume adjust. Same as above (14 values)
    OPLL_PAN:                       "8",                        // OPLL PanPot adjust. Same as above (14 values)

    IMAGES_PATH:                    window.WMSX_IMAGES_PATH || "images/",
    FILE_SEPARATOR_REGEX:           /[\\/?:]/,
    PAGE_BACK_CSS:                  "",                         // CSS to modify page background color. Applied to the body element

    SERVER_ADDRESS:                 "webmsx.azurewebsites.net/",
    SERVER_KEEPALIVE:               0,

    STATE_VERSION:                  600,
    STATE_VERSIONS_ACCEPTED:        { 9: true, 50: true, 51: true, 511: true, 520: true, 530: true, 600: true },

    ALLOW_URL_PARAMETERS:           true                        // Allows user to override any of these parameters via URL query parameters

};

WMSX.MACHINES_CONFIG = {
    MSXTR:   { DESCX: "MSX turbo R Auto Detect",    AUTO_TYPE: 4 },
    MSX2P:   { DESCX: "MSX2+ Auto Detect",          AUTO_TYPE: 3 },
    MSX2:    { DESCX: "MSX2 Auto Detect",           AUTO_TYPE: 2 },
    MSX1:    { DESCX: "MSX Auto Detect",            AUTO_TYPE: 1 },
    MSXTRA:  { DESC:  "MSX turbo R America (NTSC)", TYPE: 4, PRESETS: "_MSXTRA" },
    MSXTRE:  { DESC:  "MSX turbo R Europe (PAL)",   TYPE: 4, PRESETS: "_MSXTRE" },
    MSXTRJ:  { DESC:  "MSX turbo R Japan (NTSC)",   TYPE: 4, PRESETS: "_MSXTRJ",  LANG: "ja" },
    MSX2PA:  { DESC:  "MSX2+ America (NTSC)",       TYPE: 3, PRESETS: "_MSX2PA" },
    MSX2PE:  { DESC:  "MSX2+ Europe (PAL)",         TYPE: 3, PRESETS: "_MSX2PE" },
    MSX2PJ:  { DESC:  "MSX2+ Japan (NTSC)",         TYPE: 3, PRESETS: "_MSX2PJ",  LANG: "ja" },
    MSX2A:   { DESC:  "MSX2 America (NTSC)",        TYPE: 2, PRESETS: "_MSX2A" },
    MSX2E:   { DESC:  "MSX2 Europe (PAL)",          TYPE: 2, PRESETS: "_MSX2E" },
    MSX2J:   { DESC:  "MSX2 Japan (NTSC)",          TYPE: 2, PRESETS: "_MSX2J",   LANG: "ja" },
    MSX1A:   { DESC:  "MSX America (NTSC)",         TYPE: 1, PRESETS: "_MSX1A" },
    MSX1E:   { DESC:  "MSX Europe (PAL)",           TYPE: 1, PRESETS: "_MSX1E" },
    MSX1J:   { DESC:  "MSX Japan (NTSC)",           TYPE: 1, PRESETS: "_MSX1J",   LANG: "ja" },
    EMPTYTR: { DESCX: "MSX2 turbo R Empty (NTSC)",  TYPE: 4, PRESETS: "_EMPTY" },
    EMPTY2P: { DESCX: "MSX2+ Empty (NTSC)",         TYPE: 3, PRESETS: "_EMPTY" },
    EMPTY2:  { DESCX: "MSX2 Empty (NTSC)",          TYPE: 2, PRESETS: "_EMPTY" },
    EMPTY1:  { DESCX: "MSX Empty (NTSC)",           TYPE: 1, PRESETS: "_EMPTY" }
};

WMSX.EXTENSIONS_CONFIG = {
    HARDDISK:  { DESC: "Hard Drive",    URL: "@[Nextor16Patch].rom", SLOT: [2, 3], SLOT2: [3, 2], TOGGLE: "DISK", CHANGE: { RAMMAPPER: 1 } },
    DISK:      { DESC: "Floppy Drives", URL: "@[DiskPatch].rom",     SLOT: [2, 3], SLOT2: [3, 2], TOGGLE: "HARDDISK" },
    RAMMAPPER: { DESC: "RAM Mapper",    URL: "@[RAMMapper].rom",     SLOT: [3],                   MUTUAL: "RAMNORMAL" },
    RAMNORMAL: {                        URL: "@[RAMNormal].rom",     SLOT: [3],                   MUTUAL: "RAMMAPPER" },
    KANJI:     { DESC: "Kanji Support", URL: "@[Kanji1].rom",        SLOT: [4, 0],                BOUND:  [ "KANJIDRV", "MSXJE" ] },
    KANJIDRV:  {                        URL: "@KanjiBasicOnly.bios", SLOT: [2, 1] },
    MSXJE:     {                        URL: "@[MSXJE].rom",         SLOT: [2, 2] },
    V9990:     { DESC: "V9990 Video",   URL: "@[V9990].rom",         SLOT: [4, 3] },
    MSXMUSIC:  { DESC: "MSX-MUSIC",     URL: "@[MSXMUSIC].rom",      SLOT: [3, 3],                BOUND:  [ "MSXMUSICX" ] },
    MSXMUSICX: {                        URL: "",                     SLOT: [0, 2] },
    OPL4:      { DESC: "OPL4 Wave",     URL: "@[OPL4].rom",          SLOT: [4, 1] },
    DOUBLEPSG: { DESC: "Double PSG",    URL: "@[ExtraPSG].rom",      SLOT: [4, 2] },
    SCCI:      { DESC: "Konami SCC+",   URL: "@[SCCIExpansion].rom", SLOT: [1],    SLOT2: [2], CHANGE: { SCC:  0, PAC: 0, MEGARAM: 0 } },
    SCC:       {                        URL: "@[SCCExpansion].rom",  SLOT: [1],    SLOT2: [2], CHANGE: { SCCI: 0, PAC: 0, MEGARAM: 0 } },
    PAC:       { DESC: "PAC SRAM",      URL: "@[PACExpansion].rom",  SLOT: [1],    SLOT2: [2], CHANGE: { SCCI: 0, SCC: 0, MEGARAM: 0 } },
    MEGARAM:   { DESC: "MegaRAM",       URL: "@[MegaRAM].rom",       SLOT: [1],    SLOT2: [2], CHANGE: { SCCI: 0, SCC: 0, PAC: 0 } }
};

WMSX.PRESETS_CONFIG = {

    // Extensions Options Presets. Must be specified in this order

    // Hard Disk: Nextor Removable Device
    HARDDISK:   { "EXTENSIONS.HARDDISK": 1 },
    HARDDISKC:  { "EXTENSIONS.HARDDISK": 2 },
    DOS2:       { "EXTENSIONS.HARDDISK": 1 },
    NOHARDDISK: { "EXTENSIONS.HARDDISK": 0 },

    // Floppy Disk Drives
    DISK:      { "EXTENSIONS.DISK": 2 },
    DISKA:     { "EXTENSIONS.DISK": 1 },
    NODISK:    { "EXTENSIONS.DISK": 0 },

    // RAM type
    RAMMAPPER: { "EXTENSIONS.RAMMAPPER": 1 },
    RAMNORMAL: { "EXTENSIONS.RAMMAPPER": 0 },

    // Japanese character support
    KANJI:   { "EXTENSIONS.KANJI":  1 },
    NOKANJI: { "EXTENSIONS.KANJI":  0 },
    NOMSXJE: { "EXTENSIONS_CONFIG.MSXJE.URL": "" },

    // V9990 Video
    V9990: { "EXTENSIONS.V9990":  1 },

    // Sound Devices
    MSXMUSIC:   { "EXTENSIONS.MSXMUSIC": 1 },
    NOMSXMUSIC: { "EXTENSIONS.MSXMUSIC": 0 },
    DOUBLEPSG:  { "EXTENSIONS.DOUBLEPSG": 1 },
    OPL4:       { "EXTENSIONS.OPL4": 1 },

    // Other Cartridge extensions

    SCCI:  { "EXTENSIONS.SCCI": 1 },
    SCCI2: { "EXTENSIONS.SCCI": 2 },

    SCC:  { "EXTENSIONS.SCC": 1 },
    SCC2: { "EXTENSIONS.SCC": 2 },

    PAC:  { "EXTENSIONS.PAC": 1 },
    PAC2: { "EXTENSIONS.PAC": 2 },

    MEGARAM:  { "EXTENSIONS.MEGARAM": 1 },
    MEGARAM2: { "EXTENSIONS.MEGARAM": 2 },

    // Configuration Helper Presets

    RAM128:      { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 128 },
    RAM256:      { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 256 },
    RAM512:      { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 512 },
    RAM1024:     { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 1024 },
    RAM2048:     { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 2048 },
    RAM4096:     { _INCLUDE: "RAMMAPPER", RAMMAPPER_SIZE: 4096 },
    NORAMMAPPER: { _INCLUDE: "RAMNORMAL"},

    MEGARAM256:  { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 256 },
    MEGARAM512:  { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 512 },
    MEGARAM1024: { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 1024 },
    MEGARAM2048: { _INCLUDE: "MEGARAM", MEGARAM_SIZE: 2048 },

    VSYNCDISABLED: { SCREEN_VSYNC_MODE: -1 },
    VSYNCOFF:      { SCREEN_VSYNC_MODE: 0 },
    VSYNCON:       { SCREEN_VSYNC_MODE: 1 },

    PSGSTEREO:  { PSG_PAN: "4c8" },
    PSGSTEREO2: { PSG_PAN: "8c4" },
    SCCSTEREO:  { SCC_PAN: "8c4c4" },
    SCCSTEREO2: { PSG_PAN: "4c4c8" },
    OPLLSTEREO: { OPLL_PAN: "4c4c4c4c488888" },
    ALLSTEREO:  { _INCLUDE: "PSGSTEREO,  SCCSTEREO,  OPLLSTEREO" },
    ALLSTEREO2: { _INCLUDE: "PSGSTEREO2, SCCSTEREO2, OPLLSTEREO" },

    // Boosted Machine Preset
    BOOSTED: { Z80_CLOCK_MODE: 3, VDP_CLOCK_MODE: 3, BOOT_DURATION_AUTO: 165, _INCLUDE: "HARDDISK" },

    // Special Machine-defined modifications to Extensions
    DISKEXTN:    { "EXTENSIONS_CONFIG.DISK.URL": "@[DiskPatch].rom" },
    DISKEXTTR:   { "EXTENSIONS_CONFIG.DISK.URL": "@[DiskPatchDOS2TR].rom" },
    MSXMUSEXTN:  { "EXTENSIONS_CONFIG.MSXMUSIC.URL": "@[MSXMUSIC].rom",   "EXTENSIONS_CONFIG.MSXMUSIC.SLOT": [3, 3], "EXTENSIONS_CONFIG.MSXMUSICX.SLOT": [0, 2] },
    MSXMUSEXTTR: { "EXTENSIONS_CONFIG.MSXMUSIC.URL": "@[MSXMUSIC]TR.rom", "EXTENSIONS_CONFIG.MSXMUSIC.SLOT": [0, 2], "EXTENSIONS_CONFIG.MSXMUSICX.SLOT": [3, 3] },
    KANJIDRVN:   { "EXTENSIONS_CONFIG.KANJI.BOUND": [ "KANJIDRV", "MSXJE" ] },
    KANJIDRVP:   { "EXTENSIONS_CONFIG.KANJI.BOUND": [ "MSXJE" ], "EXTENSIONS.KANJIDRV": 0 },
    RAMN:        { "RAMMAPPER_SIZE": 512 },
    RAMTR:       { "RAMMAPPER_SIZE": 1024 },

    // Alternate Slot Configuration: try to keep RAM alone on primary Slot 3
    ALTSLOTCONFIG: {
        EXPANSION1_SLOT:                   [3, 2],
        EXPANSION2_SLOT:                   [3, 3],
        "PRESETS_CONFIG.DISK":             { "EXTENSIONS.DISK": 1 },
        "PRESETS_CONFIG.MSXMUSEXTN":       { "EXTENSIONS_CONFIG.MSXMUSIC.URL": "@[MSXMUSIC].rom",   "EXTENSIONS_CONFIG.MSXMUSIC.SLOT": [2, 2], "EXTENSIONS_CONFIG.MSXMUSICX.SLOT": [0, 2] },
        "PRESETS_CONFIG.MSXMUSEXTTR":      { "EXTENSIONS_CONFIG.MSXMUSIC.URL": "@[MSXMUSIC]TR.rom", "EXTENSIONS_CONFIG.MSXMUSIC.SLOT": [0, 2], "EXTENSIONS_CONFIG.MSXMUSICX.SLOT": [2, 2] },
        "EXTENSIONS_CONFIG.KANJIDRV.SLOT": [2, 1],
        "EXTENSIONS_CONFIG.MSXJE.SLOT":    [3, 3]
    },

    // MSX2 tR Machine Presets. Do not use directly
    _MSXTRA: {
        _INCLUDE:           "_MSXTRBASE",
        SLOT00_URL:         "@MSXTR_NTSC.bios",
        SLOT03_URL:         "@MSXTROPEN_NTSC.bios", SLOT03_FORMAT: "PlainROM", SLOT03_START: "0x4000",
        SLOT31_URL:         "@MSXTREXT_NTSC.bios | @KanjiBasicOnly.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSXTRE: {
        _INCLUDE:           "_MSXTRBASE",
        SLOT00_URL:         "@MSXTR_PAL.bios",
        SLOT03_URL:         "@MSXTROPEN_PAL.bios", SLOT03_FORMAT: "PlainROM", SLOT03_START: "0x4000",
        SLOT31_URL:         "@MSXTREXT_PAL.bios | @KanjiBasicOnly.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSXTRJ: {
        _INCLUDE:           "_MSXTRBASE, KANJI",
        SLOT00_URL:         "@MSXTR_JAP.bios",
        SLOT03_URL:         "@MSXTROPEN_NTSC.bios", SLOT03_FORMAT: "PlainROM", SLOT03_START: "0x4000",
        SLOT31_URL:         "@MSXTREXT_JAP.bios | @KanjiBasicOnly.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSXTRBASE: {
        _INCLUDE:           "_MSX2BASE, DISKEXTTR, MSXMUSEXTTR, KANJIDRVP, RAMTR"
    },

    // MSX2+ Machine Presets. Do not use directly
    _MSX2PA: {
        _INCLUDE:           "_MSX2PBASE",
        SLOT0P_URL:         "@MSX2P_NTSC.bios",
        SLOT31_URL:         "@MSX2PEXT_NTSC.bios | @KanjiBasic2PLogo_NTSC.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSX2PE: {
        _INCLUDE:           "_MSX2PBASE",
        SLOT0P_URL:         "@MSX2P_PAL.bios",
        SLOT31_URL:         "@MSX2PEXT_PAL.bios | @KanjiBasic2PLogo_PAL.bios",
        BOOT_DURATION_AUTO: 395
    },
    _MSX2PJ: {
        _INCLUDE:           "_MSX2PBASE, KANJI",
        SLOT0P_URL:         "@MSX2P_JAP.bios",
        SLOT31_URL:         "@MSX2PEXT_JAP.bios | @KanjiBasic2PLogo_NTSC.bios",
        BOOT_DURATION_AUTO: 380
    },
    _MSX2PBASE: {
        _INCLUDE:           "_MSX2BASE, KANJIDRVP"
    },

    // MSX2 Machine Presets. Do not use directly
    _MSX2A: {
        _INCLUDE:           "_MSX2BASE",
        SLOT0P_URL:         "@MSX2_NTSC.bios",
        SLOT31_URL:         "@MSX2EXT_NTSC.bios",
        BOOT_DURATION_AUTO: 385
    },
    _MSX2E: {
        _INCLUDE:           "_MSX2BASE",
        SLOT0P_URL:         "@MSX2_PAL.bios",
        SLOT31_URL:         "@MSX2EXT_PAL.bios",
        BOOT_DURATION_AUTO: 400
    },
    _MSX2J: {
        _INCLUDE:           "_MSX2BASE, KANJI",
        SLOT0P_URL:         "@MSX2_JAP.bios",
        SLOT31_URL:         "@MSX2EXT_JAP.bios",
        BOOT_DURATION_AUTO: 360
    },
    _MSX2BASE: {
        _INCLUDE:           "_BASE, RAMMAPPER, DISK, MSXMUSIC, NOKANJI"
    },

    // MSX1 Machine Presets. Do not use directly
    _MSX1A: {
        _INCLUDE:           "_MSX1BASE",
        SLOT0P_URL:         "@MSX1_NTSC.bios",
        BOOT_DURATION_AUTO: 375
    },
    _MSX1E: {
        _INCLUDE:           "_MSX1BASE",
        SLOT0P_URL:         "@MSX1_PAL.bios",
        BOOT_DURATION_AUTO: 375
    },
    _MSX1J: {
        _INCLUDE:           "_MSX1BASE",
        SLOT0P_URL:         "@MSX1_JAP.bios",
        BOOT_DURATION_AUTO: 230
    },
    _MSX1BASE: {
        _INCLUDE:           "_BASE, RAMNORMAL, DISK, NOHARDDISK, NOMSXMUSIC, NOKANJI",
        SLOT31_URL :        ""       // MSX1 has no BIOS Extension on slot 3-1, clear
    },

    // Base Machines Presets. Do not use directly
    _EMPTY: {
        _INCLUDE:           "_BASE",
        EXTENSIONS:         { },
        SLOT0P_URL:         "",
        SLOT1P_URL:         "",
        SLOT2P_URL:         "",
        SLOT3P_URL:         "",
        SLOT4P_URL:         ""      // Special Device I/O only slot
    },
    _BASE: {
        _INCLUDE:           "DISKEXTN, MSXMUSEXTN, KANJIDRVN, RAMN"
    }

};

WMSX.params = {};                   // Additional parameter overrides

wmsx = window.wmsx || {};           // Namespace

function onUpdateReady(){alert("A new version is available!\nWebMSX will restart..."),window.applicationCache.swapCache(),window.location.reload()}WMSXFullScreenSetup={apply:function(){if(!this.cssApplied){var a=document.createElement("style");a.type="text/css",a.innerHTML=this.css,document.head.appendChild(a),this.cssApplied=!0}document.documentElement.classList.toggle("wmsx-full-screen",this.shouldStartInFullScreen())},shouldStartInFullScreen:function(){return window.WMSX?WMSX.SCREEN_FULLSCREEN_MODE>=1||-1===WMSX.SCREEN_FULLSCREEN_MODE&&this.isBrowserStandaloneMode():this.isBrowserStandaloneMode()},isBrowserStandaloneMode:function(){return navigator.standalone||window.matchMedia("(display-mode: standalone)").matches},css:"html.wmsx-full-screen, html.wmsx-full-screen body {   background: black;}html.wmsx-full-screen .wmsx-full-screen-hidden {   display: none;}html:not(.wmsx-full-screen) .wmsx-full-screen-only {   display: none;}"},WMSXFullScreenSetup.apply(),wmsx.Util=new function(){"use strict";function a(a,b){return a.name<b.name?-1:a.name>b.name?1:0}function b(a){return a.stopPropagation(),a.cancelable&&a.preventDefault(),!1}this.log=function(a){var b=[">> wmsx:"];Array.prototype.push.apply(b,arguments),console.log.apply(console,b)},this.warning=function(a){var b=[">> wmsx Warning:"];Array.prototype.push.apply(b,arguments),console.warn.apply(console,b)},this.error=function(a){var b=[">> wmsx Error:"];Array.prototype.push.apply(b,arguments),console.error.apply(console,b)},this.message=function(a){console.info(a),alert(a)},this.asNormalArray=function(a,b,c){return!c&&a instanceof Array?a:c?this.arrayCopy(a,b,new Array(c)):this.arrayCopy(a,0,new Array(a.length))},this.arrayFill=function(a,b,c,d){if(a.fill)return a.fill(b,c,d);void 0===c&&(c=0);for(var e=(void 0===d?a.length:d)-1;e>=c;e-=1)a[e]=b;return a},this.arrayCopy=function(a,b,c,d,e){d=d||0;for(var f=e?b+e:a.length;b<f;)c[d++]=a[b++];return c},this.arrayAdd=function(a,b){return a[a.length]=b,a},this.arrayRemoveAllElement=function(a,b){for(var c;(c=a.indexOf(b))>=0;)a.splice(c,1);return a},this.arraysConcatAll=function(a){for(var b=0,c=0;c<a.length;++c)b+=a[c].length;var d=new a[0].constructor(b),e=0;for(c=0;c<a.length;++c)this.arrayCopy(a[c],0,d,e),e+=a[c].length;return d},this.int8BitArrayToByteString=function(a,b,c){if(null===a||void 0==a)return a;void 0===b&&(b=0),void 0===c&&(c=a.length-b);for(var d="",e=b,f=b+c;e<f;e+=1)d+=String.fromCharCode(255&a[e]);return d},this.byteStringToInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0;e<c;e+=1)d[e]=255&a.charCodeAt(e);return d}},this.byteStringToSignedInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0;e<c;e+=1){var f=255&a.charCodeAt(e);d[e]=f<128?f:f-256}return d}},this.int16BitArrayToByteString=function(a,b,c){if(null===a||void 0==a)return a;void 0===b&&(b=0),void 0===c&&(c=a.length-b);for(var d="",e=b,f=b+c;e<f;e+=1)d+=String.fromCharCode(255&a[e])+String.fromCharCode(a[e]>>8&255);return d},this.byteStringToInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length/2|0,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0,f=0;e<c;e+=1,f+=2)d[e]=255&a.charCodeAt(f)|(255&a.charCodeAt(f+1))<<8;return d}},this.byteStringToSignedInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length/2|0,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0,f=0;e<c;e+=1,f+=2){var g=255&a.charCodeAt(f)|(255&a.charCodeAt(f+1))<<8;d[e]=g<32768?g:g-65536}return d}},this.int32BitArrayToByteString=function(a,b,c){if(null===a||void 0==a)return a;void 0===b&&(b=0),void 0===c&&(c=a.length-b);for(var d="",e=b,f=b+c;e<f;e+=1)d+=String.fromCharCode(255&a[e])+String.fromCharCode(a[e]>>8&255)+String.fromCharCode(a[e]>>16&255)+String.fromCharCode(a[e]>>24&255);return d},this.byteStringToInt32BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){for(var c=a.length/4|0,d=b&&b.length===c?b:new(b?b.constructor:Array)(c),e=0,f=0;e<c;e+=1,f+=4)d[e]=255&a.charCodeAt(f)|(255&a.charCodeAt(f+1))<<8|(255&a.charCodeAt(f+2))<<16|(255&a.charCodeAt(f+3))<<24;return d}},this.storeInt8BitArrayToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?"":btoa(this.int8BitArrayToByteString(a))},this.restoreStringBase64ToInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToInt8BitArray(atob(a),b)},this.restoreStringBase64ToSignedInt8BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToSignedInt8BitArray(atob(a),b)},this.compressInt8BitArrayToStringBase64=function(a,b,c){return null===a||void 0===a?a:0===a.length?"":(b||(b=a.length),c|=0,c||b<a.length?btoa(this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.compress(a.slice(c,c+b)))):btoa(this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.compress(a))))},this.uncompressStringBase64ToInt8BitArray=function(a,b,c,d,e){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a){if(""==a)return[];var f=JSZip.compressions.DEFLATE.uncompress(atob(a));return b&&(c||b.length===f.length)?this.arrayCopy(f,0,b,e):this.arrayCopy(f,0,new(d||(b?b.constructor:Array))(f.length),e)}},this.storeInt16BitArrayToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?"":btoa(this.int16BitArrayToByteString(a))},this.restoreStringBase64ToInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToInt16BitArray(atob(a),b)},this.restoreStringBase64ToSignedInt16BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToSignedInt16BitArray(atob(a),b)},this.storeInt32BitArrayToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?"":btoa(this.int32BitArrayToByteString(a))},this.restoreStringBase64ToInt32BitArray=function(a,b){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?[]:this.byteStringToInt32BitArray(atob(a),b)},this.compressStringToStringBase64=function(a){return null===a||void 0===a?a:0===a.length?a:btoa(this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.compress(a)))},this.uncompressStringBase64ToString=function(a){if(null===a||void 0===a)return a;if("null"==a)return null;if("undefined"!=a)return""==a?a:this.int8BitArrayToByteString(JSZip.compressions.DEFLATE.uncompress(atob(a)))},this.toHex2=function(a){if(null===a||void 0===a)return a;var b=a.toString(16);return a>=0&&b.length%2?"0"+b:b},this.toHex4=function(a){return this.toHexN(a,4)},this.toHexN=function(a,b){if(null===a||void 0===a)return a;var c=a.toString(16);return a<0?c:(b>=0||(b=2),"00000000".substr(0,b-c.length)+c)},this.escapeHtml=function(a){return a.replace(/&/g,"&amp;").replace(/</g,"&lt;").replace(/>/g,"&gt;").replace(/"/g,"&quot;").replace(/'/g,"&#039;").replace(/\//g,"&#047;").replace(/\?/g,"&#063;").replace(/\-/g,"&#045;").replace(/\|/g,"&#0124;")},this.arrayFind=function(a,b){if(a.find)return a.find(b);for(var c=0,d=a.length;c<d;++c)if(b(a[c],c,a))return a[c]},this.arrayFindIndex=function(a,b){if(a.findIndex)return a.findIndex(b);for(var c=0,d=a.length;c<d;++c)if(b(a[c],c,a))return c;return-1},this.arrayIndexOfSubArray=function(a,b,c,d){var e=b.length,f=a.length,g=d||1;a:for(var h=c;h>=0&&h<f;h+=g){for(var i=0;i<e;i+=1)if(a[h+i]!==b[i])continue a;return h}return-1},this.stringCountOccurrences=function(a,b){for(var c=0,d=0,e=a.length;d<e;++d)a[d]==b&&++c;return c},
this.stringStartsWith=function(a,b){return a.startsWith?a.startsWith(b):a.substr(0,b.length)===b},this.stringEndsWith=function(a,b){return a.endsWith?a.endsWith(b):a.substr(a.length-b.length)===b},this.checkContentIsZIP=function(a){if(a&&80===a[0]&&75===a[1])try{return new JSZip(a)}catch(a){}return null},this.getZIPFilesSorted=function(b){var c=b.file(/.+/);return c.sort(a),c},this.checkContentIsGZIP=function(a){if(!a||31!==a[0]||139!==a[1]||8!==a[2])return null;try{var b=a[3],c=2&b,d=4&b,e=8&b,f=16&b,g=10;if(d){var h=a[g++]|a[g++]<<8;g+=h}if(e)for(;0!==a[g++];);if(f)for(;0!==a[g++];);return c&&(g+=2),JSZip.compressions.DEFLATE.uncompress(a.slice(g,a.length-8))}catch(a){return null}},this.leafFilename=function(a){if(!a)return"";for(var b=a.split(WMSX.FILE_SEPARATOR_REGEX),c=b.length-1;c>=0;--c){var d=b[c].trim();if(d)return d}return""},this.leafFilenameNoExtension=function(a){var b=this.leafFilename(a),c=b.lastIndexOf(".");return c<=0?b:b.substr(0,c).trim()},this.leafFilenameOnlyExtension=function(a){var b=this.leafFilename(a),c=b.lastIndexOf(".");return c<=0?"":b.substr(c+1).trim()},this.dump=function(a,b,c,d){var e="",f=b||0;d=d||a.length,c=c||d;for(var g=0;g<d;){for(var h=0;h<c&&g<d;h++,g++){var i=a[f++];e+=void 0!=i?this.toHex2(i)+" ":"?? "}e+="\n"}console.log(e)},this.dumpN=function(a,b,c,d,e){var f="",g=c||0;e=e||a.length,d=d||e;for(var h=0;h<e;){for(var i=0;i<d&&h<e;i++,h++){var j=a[g++];f+=void 0!=j?this.toHexN(j,b)+" ":"?? "}f+="\n"}console.log(f)},this.dumpSlot=function(a,b,c,d){var e="",f=b||0;d=d||1;for(var g=0;g<d;g++){for(var h=0;h<c;h++){var i=a.read(f++);e+=void 0!=i?this.toHex2(i)+" ":"?? "}e+="\n"}console.log(e)},this.browserInfo=function(){if(this.browserInfoAvailable)return this.browserInfoAvailable;var a,b=navigator.userAgent,c=b.match(/(opera|edge|chrome|safari|firefox|msie|trident(?=\/))\/?\s*(\d+)/i)||[];if(/trident/i.test(c[1]))return a=/\brv[ :]+(\d+)/g.exec(b)||[],this.browserInfoAvailable={name:"IE",version:a[1]||""};if("Chrome"===c[1]&&null!=(a=b.match(/\bOPR\/(\d+)/)))return this.browserInfoAvailable={name:"Opera",version:a[1]};c=c[2]?[c[1],c[2]]:[navigator.appName,navigator.appVersion,"-?"],null!=(a=b.match(/version\/(\d+)/i))&&c.splice(1,1,a[1]);var d=c[0].toUpperCase();return this.browserInfoAvailable={name:this.isIOSDevice()||"NETSCAPE"===d?"SAFARI":d,version:c[1]}},this.userLanguage=function(){return(navigator.languages&&navigator.languages[0]||navigator.language||navigator.userLanguage||"en-US").trim()},this.browserCurrentURL=function(){return window.location.origin+window.location.pathname},this.isOfficialHomepage=function(){var a=window.location;return a&&"webmsx.org"===a.hostname.toLowerCase()&&(""===a.port||"80"===a.port)},this.isTouchDevice=function(){return WMSX.TOUCH_MODE>0||"ontouchstart"in window||navigator.maxTouchPoints>0||navigator.msMaxTouchPoints>0},this.isMobileDevice=function(){return WMSX.MOBILE_MODE>0||0===WMSX.MOBILE_MODE&&this.isTouchDevice()&&(/android|blackberry|iemobile|windows mobile|ipad|iphone|ipod|opera mini|webos/i.test(navigator.userAgent)||navigator.maxTouchPoints>1&&void 0!==window.orientation&&null!==window.orientation)},this.isIOSDevice=function(){return/ipad|iphone|ipod/i.test(navigator.userAgent)},this.isAndroidDevice=function(){return/android/i.test(navigator.userAgent)},this.isBrowserStandaloneMode=function(){return navigator.standalone||window.matchMedia("(display-mode: standalone)").matches},this.onTapOrMouseDown=function(a,b){this.addEventsListener(a,this.isTouchDevice()?"touchstart mousedown":"mousedown",b)},this.onTapOrMouseDownWithBlock=function(a,c){function d(a){return c(a),b(a)}this.addEventsListener(a,this.isTouchDevice()?"touchstart mousedown":"mousedown",d)},this.onTapOrMouseUpWithBlock=function(a,c){function d(a){return c(a),b(a)}this.addEventsListener(a,this.isTouchDevice()?"touchstart mouseup":"mouseup",d)},this.onTapOrMouseDownWithBlockUIG=function(a,c){function d(a){if("touchend"===a.type&&!a.target.wmsxNeedsUIG)return b(a);var d="touchstart"===a.type&&a.target.wmsxNeedsUIG,e="touchend"===a.type;return c(a,d,e),b(a)}this.addEventsListener(a,this.isTouchDevice()?"touchstart touchend mousedown":"mousedown",d)},this.blockEvent=b,this.addEventsListener=function(a,b,c,d){b=b.split(" ");for(var e=0;e<b.length;++e)b[e]&&a.addEventListener(b[e],c,d)},this.removeEventsListener=function(a,b,c,d){b=b.split(" ");for(var e=0;e<b.length;++e)b[e]&&a.removeEventListener(b[e],c,d)},this.insertCSS=function(a,b){var c=a.createElement("style");c.type="text/css",c.innerHTML=b,a.head.appendChild(c)},this.scaleToFitParentHeight=function(a,b,c){var d=b.clientHeight-c-20,e=a.clientHeight,f=e<d?1:d/e;a.style.transform="translateY(-"+(c/2|0)+"px) scale("+f.toFixed(4)+")"},this.scaleToFitParentWidth=function(a,b,c){var d=b.clientWidth-(2*c|0),e=a.clientWidth,f=e<d?1:d/e,g=e*f|0,h=Math.floor((d-g)/2+c);a.style.left=h+"px",a.style.right="initial",a.style.transform="scale("+f.toFixed(4)+")"},this.log2=function(a){return Math.log(a)/Math.log(2)},this.exp2=function(a){return Math.pow(2,a)},this.performanceNow=function(){return c?Date.now()-c:window.performance.now()},this.applyPatchObject=function(a,b){if(!a||a.constructor!==Object||b.constructor!==Object)return b;b._clear&&(a={});for(var c in b)if("_clear"!==c){var d=b[c];null===d?delete a[c]:a[c]=this.applyPatchObject(a[c],d)}return a};var c=window.performance&&window.performance.now?void 0:Date.now()},wmsx.Util.sha1Generator={hex_chr:"0123456789abcdef",hex:function(a){for(var b="",c=7;c>=0;c--)b+=this.hex_chr.charAt(a>>4*c&15);return b},str2blks_SHA1:function(a){for(var b=1+(a.length+8>>6),c=new Array(16*b),d=0;d<16*b;d++)c[d]=0;for(d=0;d<a.length;d++)c[d>>2]|=a.charCodeAt(d)<<24-d%4*8;return c[d>>2]|=128<<24-d%4*8,c[16*b-1]=8*a.length,c},add:function(a,b){var c=(65535&a)+(65535&b);return(a>>16)+(b>>16)+(c>>16)<<16|65535&c},rol:function(a,b){return a<<b|a>>>32-b},ft:function(a,b,c,d){return a<20?b&c|~b&d:a<40?b^c^d:a<60?b&c|b&d|c&d:b^c^d},kt:function(a){return a<20?1518500249:a<40?1859775393:a<60?-1894007588:-899497514},calcSHA1FromByteArray:function(a){for(var b="",c=0;c<a.length;c++)b+=String.fromCharCode(a[c]);return this.calcSHA1(b)},calcSHA1:function(a){if(""!=a){for(var b,c=this.str2blks_SHA1(a),d=new Array(80),e=1732584193,f=-271733879,g=-1732584194,h=271733878,i=-1009589776,j=0;j<c.length;j+=16){for(var k=e,l=f,m=g,n=h,o=i,p=0;p<80;p++)d[p]=p<16?c[j+p]:this.rol(d[p-3]^d[p-8]^d[p-14]^d[p-16],1),b=this.add(this.add(this.rol(e,5),this.ft(p,f,g,h)),this.add(this.add(i,d[p]),this.kt(p))),i=h,h=g,g=this.rol(f,30),f=e,e=b;e=this.add(e,k),f=this.add(f,l),g=this.add(g,m),h=this.add(h,n),i=this.add(i,o)}return this.hex(e)+this.hex(f)+this.hex(g)+this.hex(h)+this.hex(i)}return""}},function(a){if("object"==typeof exports&&"undefined"!=typeof module)module.exports=a();else if("function"==typeof define&&define.amd)define([],a);else{var b;"undefined"!=typeof window?b=window:"undefined"!=typeof global?b=global:"undefined"!=typeof self&&(b=self),b.JSZip=a()}}(function(){return function a(b,c,d){function e(g,h){if(!c[g]){if(!b[g]){var i="function"==typeof require&&require;if(!h&&i)return i(g,!0);if(f)return f(g,!0);throw new Error("Cannot find module '"+g+"'")}var j=c[g]={exports:{}};b[g][0].call(j.exports,function(a){var c=b[g][1][a];return e(c||a)},j,j.exports,a,b,c,d)}return c[g].exports}for(var f="function"==typeof require&&require,g=0;g<d.length;g++)e(d[g]);return e}({1:[function(a,b,c){"use strict";var d="ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";c.encode=function(a){for(var b,c,e,f,g,h,i,j="",k=0;k<a.length;)b=a.charCodeAt(k++),c=a.charCodeAt(k++),e=a.charCodeAt(k++),f=b>>2,g=(3&b)<<4|c>>4,h=(15&c)<<2|e>>6,i=63&e,isNaN(c)?h=i=64:isNaN(e)&&(i=64),j=j+d.charAt(f)+d.charAt(g)+d.charAt(h)+d.charAt(i);return j},c.decode=function(a){var b,c,e,f,g,h,i,j="",k=0
;for(a=a.replace(/[^A-Za-z0-9\+\/\=]/g,"");k<a.length;)f=d.indexOf(a.charAt(k++)),g=d.indexOf(a.charAt(k++)),h=d.indexOf(a.charAt(k++)),i=d.indexOf(a.charAt(k++)),b=f<<2|g>>4,c=(15&g)<<4|h>>2,e=(3&h)<<6|i,j+=String.fromCharCode(b),64!=h&&(j+=String.fromCharCode(c)),64!=i&&(j+=String.fromCharCode(e));return j}},{}],2:[function(a,b){"use strict";function c(){this.compressedSize=0,this.uncompressedSize=0,this.crc32=0,this.compressionMethod=null,this.compressedContent=null}c.prototype={getContent:function(){return null},getCompressedContent:function(){return null}},b.exports=c},{}],3:[function(a,b,c){"use strict";c.STORE={magic:"\0\0",compress:function(a){return a},uncompress:function(a){return a},compressInputType:null,uncompressInputType:null},c.DEFLATE=a("./flate")},{"./flate":8}],4:[function(a,b){"use strict";var c=a("./utils"),d=[0,1996959894,3993919788,2567524794,124634137,1886057615,3915621685,2657392035,249268274,2044508324,3772115230,2547177864,162941995,2125561021,3887607047,2428444049,498536548,1789927666,4089016648,2227061214,450548861,1843258603,4107580753,2211677639,325883990,1684777152,4251122042,2321926636,335633487,1661365465,4195302755,2366115317,997073096,1281953886,3579855332,2724688242,1006888145,1258607687,3524101629,2768942443,901097722,1119000684,3686517206,2898065728,853044451,1172266101,3705015759,2882616665,651767980,1373503546,3369554304,3218104598,565507253,1454621731,3485111705,3099436303,671266974,1594198024,3322730930,2970347812,795835527,1483230225,3244367275,3060149565,1994146192,31158534,2563907772,4023717930,1907459465,112637215,2680153253,3904427059,2013776290,251722036,2517215374,3775830040,2137656763,141376813,2439277719,3865271297,1802195444,476864866,2238001368,4066508878,1812370925,453092731,2181625025,4111451223,1706088902,314042704,2344532202,4240017532,1658658271,366619977,2362670323,4224994405,1303535960,984961486,2747007092,3569037538,1256170817,1037604311,2765210733,3554079995,1131014506,879679996,2909243462,3663771856,1141124467,855842277,2852801631,3708648649,1342533948,654459306,3188396048,3373015174,1466479909,544179635,3110523913,3462522015,1591671054,702138776,2966460450,3352799412,1504918807,783551873,3082640443,3233442989,3988292384,2596254646,62317068,1957810842,3939845945,2647816111,81470997,1943803523,3814918930,2489596804,225274430,2053790376,3826175755,2466906013,167816743,2097651377,4027552580,2265490386,503444072,1762050814,4150417245,2154129355,426522225,1852507879,4275313526,2312317920,282753626,1742555852,4189708143,2394877945,397917763,1622183637,3604390888,2714866558,953729732,1340076626,3518719985,2797360999,1068828381,1219638859,3624741850,2936675148,906185462,1090812512,3747672003,2825379669,829329135,1181335161,3412177804,3160834842,628085408,1382605366,3423369109,3138078467,570562233,1426400815,3317316542,2998733608,733239954,1555261956,3268935591,3050360625,752459403,1541320221,2607071920,3965973030,1969922972,40735498,2617837225,3943577151,1913087877,83908371,2512341634,3803740692,2075208622,213261112,2463272603,3855990285,2094854071,198958881,2262029012,4057260610,1759359992,534414190,2176718541,4139329115,1873836001,414664567,2282248934,4279200368,1711684554,285281116,2405801727,4167216745,1634467795,376229701,2685067896,3608007406,1308918612,956543938,2808555105,3495958263,1231636301,1047427035,2932959818,3654703836,1088359270,936918e3,2847714899,3736837829,1202900863,817233897,3183342108,3401237130,1404277552,615818150,3134207493,3453421203,1423857449,601450431,3009837614,3294710456,1567103746,711928724,3020668471,3272380065,1510334235,755167117];b.exports=function(a,b){if(void 0===a||!a.length)return 0;var e="string"!==c.getTypeOf(a);void 0===b&&(b=0);var f=0,g=0,h=0;b^=-1;for(var i=0,j=a.length;j>i;i++)h=e?a[i]:a.charCodeAt(i),g=255&(b^h),f=d[g],b=b>>>8^f;return-1^b}},{"./utils":21}],5:[function(a,b){"use strict";function c(){this.data=null,this.length=0,this.index=0}var d=a("./utils");c.prototype={checkOffset:function(a){this.checkIndex(this.index+a)},checkIndex:function(a){if(this.length<a||0>a)throw new Error("End of data reached (data length = "+this.length+", asked index = "+a+"). Corrupted zip ?")},setIndex:function(a){this.checkIndex(a),this.index=a},skip:function(a){this.setIndex(this.index+a)},byteAt:function(){},readInt:function(a){var b,c=0;for(this.checkOffset(a),b=this.index+a-1;b>=this.index;b--)c=(c<<8)+this.byteAt(b);return this.index+=a,c},readString:function(a){return d.transformTo("string",this.readData(a))},readData:function(){},lastIndexOfSignature:function(){},readDate:function(){var a=this.readInt(4);return new Date(1980+(a>>25&127),(a>>21&15)-1,a>>16&31,a>>11&31,a>>5&63,(31&a)<<1)}},b.exports=c},{"./utils":21}],6:[function(a,b,c){"use strict";c.base64=!1,c.binary=!1,c.dir=!1,c.createFolders=!1,c.date=null,c.compression=null,c.comment=null},{}],7:[function(a,b,c){"use strict";var d=a("./utils");c.string2binary=function(a){return d.string2binary(a)},c.string2Uint8Array=function(a){return d.transformTo("uint8array",a)},c.uint8Array2String=function(a){return d.transformTo("string",a)},c.string2Blob=function(a){var b=d.transformTo("arraybuffer",a);return d.arrayBuffer2Blob(b)},c.arrayBuffer2Blob=function(a){return d.arrayBuffer2Blob(a)},c.transformTo=function(a,b){return d.transformTo(a,b)},c.getTypeOf=function(a){return d.getTypeOf(a)},c.checkSupport=function(a){return d.checkSupport(a)},c.MAX_VALUE_16BITS=d.MAX_VALUE_16BITS,c.MAX_VALUE_32BITS=d.MAX_VALUE_32BITS,c.pretty=function(a){return d.pretty(a)},c.findCompression=function(a){return d.findCompression(a)},c.isRegExp=function(a){return d.isRegExp(a)}},{"./utils":21}],8:[function(a,b,c){"use strict";var d="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Uint32Array,e=a("pako");c.uncompressInputType=d?"uint8array":"array",c.compressInputType=d?"uint8array":"array",c.magic="\b\0",c.compress=function(a){return e.deflateRaw(a)},c.uncompress=function(a){return e.inflateRaw(a)}},{pako:24}],9:[function(a,b){"use strict";function c(a,b){return this instanceof c?(this.files={},this.comment=null,this.root="",a&&this.load(a,b),void(this.clone=function(){var a=new c;for(var b in this)"function"!=typeof this[b]&&(a[b]=this[b]);return a})):new c(a,b)}var d=a("./base64");c.prototype=a("./object"),c.prototype.load=a("./load"),c.support=a("./support"),c.defaults=a("./defaults"),c.utils=a("./deprecatedPublicUtils"),c.base64={encode:function(a){return d.encode(a)},decode:function(a){return d.decode(a)}},c.compressions=a("./compressions"),b.exports=c},{"./base64":1,"./compressions":3,"./defaults":6,"./deprecatedPublicUtils":7,"./load":10,"./object":13,"./support":17}],10:[function(a,b){"use strict";var c=a("./base64"),d=a("./zipEntries");b.exports=function(a,b){var e,f,g,h;for(b=b||{},b.base64&&(a=c.decode(a)),f=new d(a,b),e=f.files,g=0;g<e.length;g++)h=e[g],this.file(h.fileName,h.decompressed,{binary:!0,optimizedBinaryString:!0,date:h.date,dir:h.dir,comment:h.fileComment.length?h.fileComment:null,createFolders:b.createFolders});return f.zipComment.length&&(this.comment=f.zipComment),this}},{"./base64":1,"./zipEntries":22}],11:[function(a,b){(function(a){"use strict";b.exports=function(b,c){return new a(b,c)},b.exports.test=function(b){return a.isBuffer(b)}}).call(this,"undefined"!=typeof Buffer?Buffer:void 0)},{}],12:[function(a,b){"use strict";function c(a){this.data=a,this.length=this.data.length,this.index=0}var d=a("./uint8ArrayReader");c.prototype=new d,c.prototype.readData=function(a){this.checkOffset(a);var b=this.data.slice(this.index,this.index+a);return this.index+=a,b},b.exports=c},{"./uint8ArrayReader":18}],13:[function(a,b){"use strict"
;var c=a("./support"),d=a("./utils"),e=a("./crc32"),f=a("./signature"),g=a("./defaults"),h=a("./base64"),i=a("./compressions"),j=a("./compressedObject"),k=a("./nodeBuffer"),l=a("./utf8"),m=a("./stringWriter"),n=a("./uint8ArrayWriter"),o=function(a){if(a._data instanceof j&&(a._data=a._data.getContent(),a.options.binary=!0,a.options.base64=!1,"uint8array"===d.getTypeOf(a._data))){var b=a._data;a._data=new Uint8Array(b.length),0!==b.length&&a._data.set(b,0)}return a._data},p=function(a){var b=o(a);return"string"===d.getTypeOf(b)?!a.options.binary&&c.nodebuffer?k(b,"utf-8"):a.asBinary():b},q=function(a){var b=o(this);return null===b||void 0===b?"":(this.options.base64&&(b=h.decode(b)),b=a&&this.options.binary?A.utf8decode(b):d.transformTo("string",b),a||this.options.binary||(b=d.transformTo("string",A.utf8encode(b))),b)},r=function(a,b,c){this.name=a,this.dir=c.dir,this.date=c.date,this.comment=c.comment,this._data=b,this.options=c,this._initialMetadata={dir:c.dir,date:c.date}};r.prototype={asText:function(){return q.call(this,!0)},asBinary:function(){return q.call(this,!1)},asNodeBuffer:function(){var a=p(this);return d.transformTo("nodebuffer",a)},asUint8Array:function(){var a=p(this);return d.transformTo("uint8array",a)},asArrayBuffer:function(){return this.asUint8Array().buffer}};var s=function(a,b){var c,d="";for(c=0;b>c;c++)d+=String.fromCharCode(255&a),a>>>=8;return d},t=function(){var a,b,c={};for(a=0;a<arguments.length;a++)for(b in arguments[a])arguments[a].hasOwnProperty(b)&&void 0===c[b]&&(c[b]=arguments[a][b]);return c},u=function(a){return a=a||{},!0!==a.base64||null!==a.binary&&void 0!==a.binary||(a.binary=!0),a=t(a,g),a.date=a.date||new Date,null!==a.compression&&(a.compression=a.compression.toUpperCase()),a},v=function(a,b,c){var e,f=d.getTypeOf(b);if(c=u(c),c.createFolders&&(e=w(a))&&x.call(this,e,!0),c.dir||null===b||void 0===b)c.base64=!1,c.binary=!1,b=null;else if("string"===f)c.binary&&!c.base64&&!0!==c.optimizedBinaryString&&(b=d.string2binary(b));else{if(c.base64=!1,c.binary=!0,!(f||b instanceof j))throw new Error("The data of '"+a+"' is in an unsupported format !");"arraybuffer"===f&&(b=d.transformTo("uint8array",b))}var g=new r(a,b,c);return this.files[a]=g,g},w=function(a){"/"==a.slice(-1)&&(a=a.substring(0,a.length-1));var b=a.lastIndexOf("/");return b>0?a.substring(0,b):""},x=function(a,b){return"/"!=a.slice(-1)&&(a+="/"),b=void 0!==b&&b,this.files[a]||v.call(this,a,null,{dir:!0,createFolders:b}),this.files[a]},y=function(a,b){var c,f=new j;return a._data instanceof j?(f.uncompressedSize=a._data.uncompressedSize,f.crc32=a._data.crc32,0===f.uncompressedSize||a.dir?(b=i.STORE,f.compressedContent="",f.crc32=0):a._data.compressionMethod===b.magic?f.compressedContent=a._data.getCompressedContent():(c=a._data.getContent(),f.compressedContent=b.compress(d.transformTo(b.compressInputType,c)))):(c=p(a),(!c||0===c.length||a.dir)&&(b=i.STORE,c=""),f.uncompressedSize=c.length,f.crc32=e(c),f.compressedContent=b.compress(d.transformTo(b.compressInputType,c))),f.compressedSize=f.compressedContent.length,f.compressionMethod=b.magic,f},z=function(a,b,c,g){var h,i,j,k,m=(c.compressedContent,d.transformTo("string",l.utf8encode(b.name))),n=b.comment||"",o=d.transformTo("string",l.utf8encode(n)),p=m.length!==b.name.length,q=o.length!==n.length,r=b.options,t="",u="",v="";j=b._initialMetadata.dir!==b.dir?b.dir:r.dir,k=b._initialMetadata.date!==b.date?b.date:r.date,h=k.getHours(),h<<=6,h|=k.getMinutes(),h<<=5,h|=k.getSeconds()/2,i=k.getFullYear()-1980,i<<=4,i|=k.getMonth()+1,i<<=5,i|=k.getDate(),p&&(u=s(1,1)+s(e(m),4)+m,t+="up"+s(u.length,2)+u),q&&(v=s(1,1)+s(this.crc32(o),4)+o,t+="uc"+s(v.length,2)+v);var w="";return w+="\n\0",w+=p||q?"\0\b":"\0\0",w+=c.compressionMethod,w+=s(h,2),w+=s(i,2),w+=s(c.crc32,4),w+=s(c.compressedSize,4),w+=s(c.uncompressedSize,4),w+=s(m.length,2),w+=s(t.length,2),{fileRecord:f.LOCAL_FILE_HEADER+w+m+t,dirRecord:f.CENTRAL_FILE_HEADER+"\0"+w+s(o.length,2)+"\0\0\0\0"+(!0===j?"\0\0\0":"\0\0\0\0")+s(g,4)+m+t+o,compressedObject:c}},A={load:function(){throw new Error("Load method is not defined. Is the file jszip-load.js included ?")},filter:function(a){var b,c,d,e,f=[];for(b in this.files)this.files.hasOwnProperty(b)&&(d=this.files[b],e=new r(d.name,d._data,t(d.options)),c=b.slice(this.root.length,b.length),b.slice(0,this.root.length)===this.root&&a(c,e)&&f.push(e));return f},file:function(a,b,c){if(1===arguments.length){if(d.isRegExp(a)){var e=a;return this.filter(function(a,b){return!b.dir&&e.test(a)})}return this.filter(function(b,c){return!c.dir&&b===a})[0]||null}return a=this.root+a,v.call(this,a,b,c),this},folder:function(a){if(!a)return this;if(d.isRegExp(a))return this.filter(function(b,c){return c.dir&&a.test(b)});var b=this.root+a,c=x.call(this,b),e=this.clone();return e.root=c.name,e},remove:function(a){a=this.root+a;var b=this.files[a];if(b||("/"!=a.slice(-1)&&(a+="/"),b=this.files[a]),b&&!b.dir)delete this.files[a];else for(var c=this.filter(function(b,c){return c.name.slice(0,a.length)===a}),d=0;d<c.length;d++)delete this.files[c[d].name];return this},generate:function(a){a=t(a||{},{base64:!0,compression:"STORE",type:"base64",comment:null}),d.checkSupport(a.type);var b,c,e=[],g=0,j=0,k=d.transformTo("string",this.utf8encode(a.comment||this.comment||""));for(var l in this.files)if(this.files.hasOwnProperty(l)){var o=this.files[l],p=o.options.compression||a.compression.toUpperCase(),q=i[p];if(!q)throw new Error(p+" is not a valid compression method !");var r=y.call(this,o,q),u=z.call(this,l,o,r,g);g+=u.fileRecord.length+r.compressedSize,j+=u.dirRecord.length,e.push(u)}var v="";v=f.CENTRAL_DIRECTORY_END+"\0\0\0\0"+s(e.length,2)+s(e.length,2)+s(j,4)+s(g,4)+s(k.length,2)+k;var w=a.type.toLowerCase();for(b="uint8array"===w||"arraybuffer"===w||"blob"===w||"nodebuffer"===w?new n(g+j+v.length):new m(g+j+v.length),c=0;c<e.length;c++)b.append(e[c].fileRecord),b.append(e[c].compressedObject.compressedContent);for(c=0;c<e.length;c++)b.append(e[c].dirRecord);b.append(v);var x=b.finalize();switch(a.type.toLowerCase()){case"uint8array":case"arraybuffer":case"nodebuffer":return d.transformTo(a.type.toLowerCase(),x);case"blob":return d.arrayBuffer2Blob(d.transformTo("arraybuffer",x));case"base64":return a.base64?h.encode(x):x;default:return x}},crc32:function(a,b){return e(a,b)},utf8encode:function(a){return d.transformTo("string",l.utf8encode(a))},utf8decode:function(a){return l.utf8decode(a)}};b.exports=A},{"./base64":1,"./compressedObject":2,"./compressions":3,"./crc32":4,"./defaults":6,"./nodeBuffer":11,"./signature":14,"./stringWriter":16,"./support":17,"./uint8ArrayWriter":19,"./utf8":20,"./utils":21}],14:[function(a,b,c){"use strict";c.LOCAL_FILE_HEADER="PK",c.CENTRAL_FILE_HEADER="PK",c.CENTRAL_DIRECTORY_END="PK",c.ZIP64_CENTRAL_DIRECTORY_LOCATOR="PK",c.ZIP64_CENTRAL_DIRECTORY_END="PK",c.DATA_DESCRIPTOR="PK\b"},{}],15:[function(a,b){"use strict";function c(a,b){this.data=a,b||(this.data=e.string2binary(this.data)),this.length=this.data.length,this.index=0}var d=a("./dataReader"),e=a("./utils");c.prototype=new d,c.prototype.byteAt=function(a){return this.data.charCodeAt(a)},c.prototype.lastIndexOfSignature=function(a){return this.data.lastIndexOf(a)},c.prototype.readData=function(a){this.checkOffset(a);var b=this.data.slice(this.index,this.index+a);return this.index+=a,b},b.exports=c},{"./dataReader":5,"./utils":21}],16:[function(a,b){"use strict";var c=a("./utils"),d=function(){this.data=[]};d.prototype={append:function(a){a=c.transformTo("string",a),this.data.push(a)},finalize:function(){return this.data.join("")}},b.exports=d},{"./utils":21}],17:[function(a,b,c){(function(a){"use strict";if(c.base64=!0,c.array=!0,c.string=!0,c.arraybuffer="undefined"!=typeof ArrayBuffer&&"undefined"!=typeof Uint8Array,c.nodebuffer=void 0!==a,c.uint8array="undefined"!=typeof Uint8Array,
"undefined"==typeof ArrayBuffer)c.blob=!1;else{var b=new ArrayBuffer(0);try{c.blob=0===new Blob([b],{type:"application/zip"}).size}catch(a){try{var d=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,e=new d;e.append(b),c.blob=0===e.getBlob("application/zip").size}catch(a){c.blob=!1}}}}).call(this,"undefined"!=typeof Buffer?Buffer:void 0)},{}],18:[function(a,b){"use strict";function c(a){a&&(this.data=a,this.length=this.data.length,this.index=0)}var d=a("./dataReader");c.prototype=new d,c.prototype.byteAt=function(a){return this.data[a]},c.prototype.lastIndexOfSignature=function(a){for(var b=a.charCodeAt(0),c=a.charCodeAt(1),d=a.charCodeAt(2),e=a.charCodeAt(3),f=this.length-4;f>=0;--f)if(this.data[f]===b&&this.data[f+1]===c&&this.data[f+2]===d&&this.data[f+3]===e)return f;return-1},c.prototype.readData=function(a){if(this.checkOffset(a),0===a)return new Uint8Array(0);var b=this.data.subarray(this.index,this.index+a);return this.index+=a,b},b.exports=c},{"./dataReader":5}],19:[function(a,b){"use strict";var c=a("./utils"),d=function(a){this.data=new Uint8Array(a),this.index=0};d.prototype={append:function(a){0!==a.length&&(a=c.transformTo("uint8array",a),this.data.set(a,this.index),this.index+=a.length)},finalize:function(){return this.data}},b.exports=d},{"./utils":21}],20:[function(a,b,c){"use strict";for(var d=a("./utils"),e=a("./support"),f=a("./nodeBuffer"),g=new Array(256),h=0;256>h;h++)g[h]=h>=252?6:h>=248?5:h>=240?4:h>=224?3:h>=192?2:1;g[254]=g[254]=1;var i=function(a){var b,c,d,f,g,h=a.length,i=0;for(f=0;h>f;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),i+=128>c?1:2048>c?2:65536>c?3:4;for(b=e.uint8array?new Uint8Array(i):new Array(i),g=0,f=0;i>g;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),128>c?b[g++]=c:2048>c?(b[g++]=192|c>>>6,b[g++]=128|63&c):65536>c?(b[g++]=224|c>>>12,b[g++]=128|c>>>6&63,b[g++]=128|63&c):(b[g++]=240|c>>>18,b[g++]=128|c>>>12&63,b[g++]=128|c>>>6&63,b[g++]=128|63&c);return b},j=function(a,b){var c;for(b=b||a.length,b>a.length&&(b=a.length),c=b-1;c>=0&&128==(192&a[c]);)c--;return 0>c?b:0===c?b:c+g[a[c]]>b?c:b},k=function(a){var b,c,e,f,h=a.length,i=new Array(2*h);for(c=0,b=0;h>b;)if(128>(e=a[b++]))i[c++]=e;else if((f=g[e])>4)i[c++]=65533,b+=f-1;else{for(e&=2===f?31:3===f?15:7;f>1&&h>b;)e=e<<6|63&a[b++],f--;f>1?i[c++]=65533:65536>e?i[c++]=e:(e-=65536,i[c++]=55296|e>>10&1023,i[c++]=56320|1023&e)}return i.length!==c&&(i.subarray?i=i.subarray(0,c):i.length=c),d.applyFromCharCode(i)};c.utf8encode=function(a){return e.nodebuffer?f(a,"utf-8"):i(a)},c.utf8decode=function(a){if(e.nodebuffer)return d.transformTo("nodebuffer",a).toString("utf-8");a=d.transformTo(e.uint8array?"uint8array":"array",a);for(var b=[],c=0,f=a.length;f>c;){var g=j(a,Math.min(c+65536,f));b.push(k(e.uint8array?a.subarray(c,g):a.slice(c,g))),c=g}return b.join("")}},{"./nodeBuffer":11,"./support":17,"./utils":21}],21:[function(a,b,c){"use strict";function d(a){return a}function e(a,b){for(var c=0;c<a.length;++c)b[c]=255&a.charCodeAt(c);return b}function f(a){var b=65536,d=[],e=a.length,f=c.getTypeOf(a),g=0,h=!0;try{switch(f){case"uint8array":String.fromCharCode.apply(null,new Uint8Array(0));break;case"nodebuffer":String.fromCharCode.apply(null,j(0))}}catch(a){h=!1}if(!h){for(var i="",k=0;k<a.length;k++)i+=String.fromCharCode(a[k]);return i}for(;e>g&&b>1;)try{d.push("array"===f||"nodebuffer"===f?String.fromCharCode.apply(null,a.slice(g,Math.min(g+b,e))):String.fromCharCode.apply(null,a.subarray(g,Math.min(g+b,e)))),g+=b}catch(a){b=Math.floor(b/2)}return d.join("")}function g(a,b){for(var c=0;c<a.length;c++)b[c]=a[c];return b}var h=a("./support"),i=a("./compressions"),j=a("./nodeBuffer");c.string2binary=function(a){for(var b="",c=0;c<a.length;c++)b+=String.fromCharCode(255&a.charCodeAt(c));return b},c.arrayBuffer2Blob=function(a){c.checkSupport("blob");try{return new Blob([a],{type:"application/zip"})}catch(c){try{var b=window.BlobBuilder||window.WebKitBlobBuilder||window.MozBlobBuilder||window.MSBlobBuilder,d=new b;return d.append(a),d.getBlob("application/zip")}catch(a){throw new Error("Bug : can't construct the Blob.")}}},c.applyFromCharCode=f;var k={};k.string={string:d,array:function(a){return e(a,new Array(a.length))},arraybuffer:function(a){return k.string.uint8array(a).buffer},uint8array:function(a){return e(a,new Uint8Array(a.length))},nodebuffer:function(a){return e(a,j(a.length))}},k.array={string:f,array:d,arraybuffer:function(a){return new Uint8Array(a).buffer},uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return j(a)}},k.arraybuffer={string:function(a){return f(new Uint8Array(a))},array:function(a){return g(new Uint8Array(a),new Array(a.byteLength))},arraybuffer:d,uint8array:function(a){return new Uint8Array(a)},nodebuffer:function(a){return j(new Uint8Array(a))}},k.uint8array={string:f,array:function(a){return g(a,new Array(a.length))},arraybuffer:function(a){return a.buffer},uint8array:d,nodebuffer:function(a){return j(a)}},k.nodebuffer={string:f,array:function(a){return g(a,new Array(a.length))},arraybuffer:function(a){return k.nodebuffer.uint8array(a).buffer},uint8array:function(a){return g(a,new Uint8Array(a.length))},nodebuffer:d},c.transformTo=function(a,b){if(b||(b=""),!a)return b;c.checkSupport(a);var d=c.getTypeOf(b);return k[d][a](b)},c.getTypeOf=function(a){return"string"==typeof a?"string":"[object Array]"===Object.prototype.toString.call(a)?"array":h.nodebuffer&&j.test(a)?"nodebuffer":h.uint8array&&a instanceof Uint8Array?"uint8array":h.arraybuffer&&a instanceof ArrayBuffer?"arraybuffer":void 0},c.checkSupport=function(a){if(!h[a.toLowerCase()])throw new Error(a+" is not supported by this browser")},c.MAX_VALUE_16BITS=65535,c.MAX_VALUE_32BITS=-1,c.pretty=function(a){var b,c,d="";for(c=0;c<(a||"").length;c++)b=a.charCodeAt(c),d+="\\x"+(16>b?"0":"")+b.toString(16).toUpperCase();return d},c.findCompression=function(a){for(var b in i)if(i.hasOwnProperty(b)&&i[b].magic===a)return i[b];return null},c.isRegExp=function(a){return"[object RegExp]"===Object.prototype.toString.call(a)}},{"./compressions":3,"./nodeBuffer":11,"./support":17}],22:[function(a,b){"use strict";function c(a,b){this.files=[],this.loadOptions=b,a&&this.load(a)}var d=a("./stringReader"),e=a("./nodeBufferReader"),f=a("./uint8ArrayReader"),g=a("./utils"),h=a("./signature"),i=a("./zipEntry"),j=a("./support"),k=a("./object");c.prototype={checkSignature:function(a){var b=this.reader.readString(4);if(b!==a)throw new Error("Corrupted zip or bug : unexpected signature ("+g.pretty(b)+", expected "+g.pretty(a)+")")},readBlockEndOfCentral:function(){this.diskNumber=this.reader.readInt(2),this.diskWithCentralDirStart=this.reader.readInt(2),this.centralDirRecordsOnThisDisk=this.reader.readInt(2),this.centralDirRecords=this.reader.readInt(2),this.centralDirSize=this.reader.readInt(4),this.centralDirOffset=this.reader.readInt(4),this.zipCommentLength=this.reader.readInt(2),this.zipComment=this.reader.readString(this.zipCommentLength),this.zipComment=k.utf8decode(this.zipComment)},readBlockZip64EndOfCentral:function(){this.zip64EndOfCentralSize=this.reader.readInt(8),this.versionMadeBy=this.reader.readString(2),this.versionNeeded=this.reader.readInt(2),this.diskNumber=this.reader.readInt(4),this.diskWithCentralDirStart=this.reader.readInt(4),this.centralDirRecordsOnThisDisk=this.reader.readInt(8),this.centralDirRecords=this.reader.readInt(8),this.centralDirSize=this.reader.readInt(8),this.centralDirOffset=this.reader.readInt(8),this.zip64ExtensibleData={};for(var a,b,c,d=this.zip64EndOfCentralSize-44;d>0;)a=this.reader.readInt(2),b=this.reader.readInt(4),c=this.reader.readString(b),this.zip64ExtensibleData[a]={id:a,length:b,value:c}},
readBlockZip64EndOfCentralLocator:function(){if(this.diskWithZip64CentralDirStart=this.reader.readInt(4),this.relativeOffsetEndOfZip64CentralDir=this.reader.readInt(8),this.disksCount=this.reader.readInt(4),this.disksCount>1)throw new Error("Multi-volumes zip are not supported")},readLocalFiles:function(){var a,b;for(a=0;a<this.files.length;a++)b=this.files[a],this.reader.setIndex(b.localHeaderOffset),this.checkSignature(h.LOCAL_FILE_HEADER),b.readLocalPart(this.reader),b.handleUTF8()},readCentralDir:function(){var a;for(this.reader.setIndex(this.centralDirOffset);this.reader.readString(4)===h.CENTRAL_FILE_HEADER;)a=new i({zip64:this.zip64},this.loadOptions),a.readCentralPart(this.reader),this.files.push(a)},readEndOfCentral:function(){var a=this.reader.lastIndexOfSignature(h.CENTRAL_DIRECTORY_END);if(-1===a)throw new Error("Corrupted zip : can't find end of central directory");if(this.reader.setIndex(a),this.checkSignature(h.CENTRAL_DIRECTORY_END),this.readBlockEndOfCentral(),this.diskNumber===g.MAX_VALUE_16BITS||this.diskWithCentralDirStart===g.MAX_VALUE_16BITS||this.centralDirRecordsOnThisDisk===g.MAX_VALUE_16BITS||this.centralDirRecords===g.MAX_VALUE_16BITS||this.centralDirSize===g.MAX_VALUE_32BITS||this.centralDirOffset===g.MAX_VALUE_32BITS){if(this.zip64=!0,-1===(a=this.reader.lastIndexOfSignature(h.ZIP64_CENTRAL_DIRECTORY_LOCATOR)))throw new Error("Corrupted zip : can't find the ZIP64 end of central directory locator");this.reader.setIndex(a),this.checkSignature(h.ZIP64_CENTRAL_DIRECTORY_LOCATOR),this.readBlockZip64EndOfCentralLocator(),this.reader.setIndex(this.relativeOffsetEndOfZip64CentralDir),this.checkSignature(h.ZIP64_CENTRAL_DIRECTORY_END),this.readBlockZip64EndOfCentral()}},prepareReader:function(a){var b=g.getTypeOf(a);this.reader="string"!==b||j.uint8array?"nodebuffer"===b?new e(a):new f(g.transformTo("uint8array",a)):new d(a,this.loadOptions.optimizedBinaryString)},load:function(a){this.prepareReader(a),this.readEndOfCentral(),this.readCentralDir(),this.readLocalFiles()}},b.exports=c},{"./nodeBufferReader":12,"./object":13,"./signature":14,"./stringReader":15,"./support":17,"./uint8ArrayReader":18,"./utils":21,"./zipEntry":23}],23:[function(a,b){"use strict";function c(a,b){this.options=a,this.loadOptions=b}var d=a("./stringReader"),e=a("./utils"),f=a("./compressedObject"),g=a("./object");c.prototype={isEncrypted:function(){return 1==(1&this.bitFlag)},useUTF8:function(){return 2048==(2048&this.bitFlag)},prepareCompressedContent:function(a,b,c){return function(){var d=a.index;a.setIndex(b);var e=a.readData(c);return a.setIndex(d),e}},prepareContent:function(a,b,c,d,f){return function(){var a=e.transformTo(d.uncompressInputType,this.getCompressedContent()),b=d.uncompress(a);if(b.length!==f)throw new Error("Bug : uncompressed data size mismatch");return b}},readLocalPart:function(a){var b,c;if(a.skip(22),this.fileNameLength=a.readInt(2),c=a.readInt(2),this.fileName=a.readString(this.fileNameLength),a.skip(c),-1==this.compressedSize||-1==this.uncompressedSize)throw new Error("Bug or corrupted zip : didn't get enough informations from the central directory (compressedSize == -1 || uncompressedSize == -1)");if(null===(b=e.findCompression(this.compressionMethod)))throw new Error("Corrupted zip : compression "+e.pretty(this.compressionMethod)+" unknown (inner file : "+this.fileName+")");if(this.decompressed=new f,this.decompressed.compressedSize=this.compressedSize,this.decompressed.uncompressedSize=this.uncompressedSize,this.decompressed.crc32=this.crc32,this.decompressed.compressionMethod=this.compressionMethod,this.decompressed.getCompressedContent=this.prepareCompressedContent(a,a.index,this.compressedSize,b),this.decompressed.getContent=this.prepareContent(a,a.index,this.compressedSize,b,this.uncompressedSize),this.loadOptions.checkCRC32&&(this.decompressed=e.transformTo("string",this.decompressed.getContent()),g.crc32(this.decompressed)!==this.crc32))throw new Error("Corrupted zip : CRC32 mismatch")},readCentralPart:function(a){if(this.versionMadeBy=a.readString(2),this.versionNeeded=a.readInt(2),this.bitFlag=a.readInt(2),this.compressionMethod=a.readString(2),this.date=a.readDate(),this.crc32=a.readInt(4),this.compressedSize=a.readInt(4),this.uncompressedSize=a.readInt(4),this.fileNameLength=a.readInt(2),this.extraFieldsLength=a.readInt(2),this.fileCommentLength=a.readInt(2),this.diskNumberStart=a.readInt(2),this.internalFileAttributes=a.readInt(2),this.externalFileAttributes=a.readInt(4),this.localHeaderOffset=a.readInt(4),this.isEncrypted())throw new Error("Encrypted zip are not supported");this.fileName=a.readString(this.fileNameLength),this.readExtraFields(a),this.parseZIP64ExtraField(a),this.fileComment=a.readString(this.fileCommentLength),this.dir=!!(16&this.externalFileAttributes)},parseZIP64ExtraField:function(){if(this.extraFields[1]){var a=new d(this.extraFields[1].value);this.uncompressedSize===e.MAX_VALUE_32BITS&&(this.uncompressedSize=a.readInt(8)),this.compressedSize===e.MAX_VALUE_32BITS&&(this.compressedSize=a.readInt(8)),this.localHeaderOffset===e.MAX_VALUE_32BITS&&(this.localHeaderOffset=a.readInt(8)),this.diskNumberStart===e.MAX_VALUE_32BITS&&(this.diskNumberStart=a.readInt(4))}},readExtraFields:function(a){var b,c,d,e=a.index;for(this.extraFields=this.extraFields||{};a.index<e+this.extraFieldsLength;)b=a.readInt(2),c=a.readInt(2),d=a.readString(c),this.extraFields[b]={id:b,length:c,value:d}},handleUTF8:function(){if(this.useUTF8())this.fileName=g.utf8decode(this.fileName),this.fileComment=g.utf8decode(this.fileComment);else{var a=this.findExtraFieldUnicodePath();null!==a&&(this.fileName=a);var b=this.findExtraFieldUnicodeComment();null!==b&&(this.fileComment=b)}},findExtraFieldUnicodePath:function(){var a=this.extraFields[28789];if(a){var b=new d(a.value);return 1!==b.readInt(1)?null:g.crc32(this.fileName)!==b.readInt(4)?null:g.utf8decode(b.readString(a.length-5))}return null},findExtraFieldUnicodeComment:function(){var a=this.extraFields[25461];if(a){var b=new d(a.value);return 1!==b.readInt(1)?null:g.crc32(this.fileComment)!==b.readInt(4)?null:g.utf8decode(b.readString(a.length-5))}return null}},b.exports=c},{"./compressedObject":2,"./object":13,"./stringReader":15,"./utils":21}],24:[function(a,b){"use strict";var c=a("./lib/utils/common").assign,d=a("./lib/deflate"),e=a("./lib/inflate"),f=a("./lib/zlib/constants"),g={};c(g,d,e,f),b.exports=g},{"./lib/deflate":25,"./lib/inflate":26,"./lib/utils/common":27,"./lib/zlib/constants":30}],25:[function(a,b,c){"use strict";function d(a,b){var c=new l(b);if(c.push(a,!0),c.err)throw c.msg;return c.result}function e(a,b){return b=b||{},b.raw=!0,d(a,b)}function f(a,b){return b=b||{},b.gzip=!0,d(a,b)}var g=a("./zlib/deflate.js"),h=a("./utils/common"),i=a("./utils/strings"),j=a("./zlib/messages"),k=a("./zlib/zstream"),l=function(a){this.options=h.assign({level:-1,method:8,chunkSize:16384,windowBits:15,memLevel:8,strategy:0,to:""},a||{});var b=this.options;b.raw&&b.windowBits>0?b.windowBits=-b.windowBits:b.gzip&&b.windowBits>0&&b.windowBits<16&&(b.windowBits+=16),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new k,this.strm.avail_out=0;var c=g.deflateInit2(this.strm,b.level,b.method,b.windowBits,b.memLevel,b.strategy);if(0!==c)throw new Error(j[c]);b.header&&g.deflateSetHeader(this.strm,b.header)};l.prototype.push=function(a,b){var c,d,e=this.strm,f=this.options.chunkSize;if(this.ended)return!1;d=b===~~b?b:!0===b?4:0,e.input="string"==typeof a?i.string2buf(a):a,e.next_in=0,e.avail_in=e.input.length;do{if(0===e.avail_out&&(e.output=new h.Buf8(f),e.next_out=0,e.avail_out=f),1!==(c=g.deflate(e,d))&&0!==c)return this.onEnd(c),this.ended=!0,!1;(0===e.avail_out||0===e.avail_in&&4===d)&&this.onData("string"===this.options.to?i.buf2binstring(h.shrinkBuf(e.output,e.next_out)):h.shrinkBuf(e.output,e.next_out))}while((e.avail_in>0||0===e.avail_out)&&1!==c)
;return 4!==d||(c=g.deflateEnd(this.strm),this.onEnd(c),this.ended=!0,0===c)},l.prototype.onData=function(a){this.chunks.push(a)},l.prototype.onEnd=function(a){0===a&&(this.result="string"===this.options.to?this.chunks.join(""):h.flattenChunks(this.chunks)),this.chunks=[],this.err=a,this.msg=this.strm.msg},c.Deflate=l,c.deflate=d,c.deflateRaw=e,c.gzip=f},{"./utils/common":27,"./utils/strings":28,"./zlib/deflate.js":32,"./zlib/messages":37,"./zlib/zstream":39}],26:[function(a,b,c){"use strict";function d(a,b){var c=new m(b);if(c.push(a,!0),c.err)throw c.msg;return c.result}function e(a,b){return b=b||{},b.raw=!0,d(a,b)}var f=a("./zlib/inflate.js"),g=a("./utils/common"),h=a("./utils/strings"),i=a("./zlib/constants"),j=a("./zlib/messages"),k=a("./zlib/zstream"),l=a("./zlib/gzheader"),m=function(a){this.options=g.assign({chunkSize:16384,windowBits:0,to:""},a||{});var b=this.options;b.raw&&b.windowBits>=0&&b.windowBits<16&&(b.windowBits=-b.windowBits,0===b.windowBits&&(b.windowBits=-15)),!(b.windowBits>=0&&b.windowBits<16)||a&&a.windowBits||(b.windowBits+=32),b.windowBits>15&&b.windowBits<48&&0==(15&b.windowBits)&&(b.windowBits|=15),this.err=0,this.msg="",this.ended=!1,this.chunks=[],this.strm=new k,this.strm.avail_out=0;var c=f.inflateInit2(this.strm,b.windowBits);if(c!==i.Z_OK)throw new Error(j[c]);this.header=new l,f.inflateGetHeader(this.strm,this.header)};m.prototype.push=function(a,b){var c,d,e,j,k,l=this.strm,m=this.options.chunkSize;if(this.ended)return!1;d=b===~~b?b:!0===b?i.Z_FINISH:i.Z_NO_FLUSH,l.input="string"==typeof a?h.binstring2buf(a):a,l.next_in=0,l.avail_in=l.input.length;do{if(0===l.avail_out&&(l.output=new g.Buf8(m),l.next_out=0,l.avail_out=m),(c=f.inflate(l,i.Z_NO_FLUSH))!==i.Z_STREAM_END&&c!==i.Z_OK)return this.onEnd(c),this.ended=!0,!1;l.next_out&&(0===l.avail_out||c===i.Z_STREAM_END||0===l.avail_in&&d===i.Z_FINISH)&&("string"===this.options.to?(e=h.utf8border(l.output,l.next_out),j=l.next_out-e,k=h.buf2string(l.output,e),l.next_out=j,l.avail_out=m-j,j&&g.arraySet(l.output,l.output,e,j,0),this.onData(k)):this.onData(g.shrinkBuf(l.output,l.next_out)))}while(l.avail_in>0&&c!==i.Z_STREAM_END);return c===i.Z_STREAM_END&&(d=i.Z_FINISH),d!==i.Z_FINISH||(c=f.inflateEnd(this.strm),this.onEnd(c),this.ended=!0,c===i.Z_OK)},m.prototype.onData=function(a){this.chunks.push(a)},m.prototype.onEnd=function(a){a===i.Z_OK&&(this.result="string"===this.options.to?this.chunks.join(""):g.flattenChunks(this.chunks)),this.chunks=[],this.err=a,this.msg=this.strm.msg},c.Inflate=m,c.inflate=d,c.inflateRaw=e,c.ungzip=d},{"./utils/common":27,"./utils/strings":28,"./zlib/constants":30,"./zlib/gzheader":33,"./zlib/inflate.js":35,"./zlib/messages":37,"./zlib/zstream":39}],27:[function(a,b,c){"use strict";var d="undefined"!=typeof Uint8Array&&"undefined"!=typeof Uint16Array&&"undefined"!=typeof Int32Array;c.assign=function(a){for(var b=Array.prototype.slice.call(arguments,1);b.length;){var c=b.shift();if(c){if("object"!=typeof c)throw new TypeError(c+"must be non-object");for(var d in c)c.hasOwnProperty(d)&&(a[d]=c[d])}}return a},c.shrinkBuf=function(a,b){return a.length===b?a:a.subarray?a.subarray(0,b):(a.length=b,a)};var e={arraySet:function(a,b,c,d,e){if(b.subarray&&a.subarray)return void a.set(b.subarray(c,c+d),e);for(var f=0;d>f;f++)a[e+f]=b[c+f]},flattenChunks:function(a){var b,c,d,e,f,g;for(d=0,b=0,c=a.length;c>b;b++)d+=a[b].length;for(g=new Uint8Array(d),e=0,b=0,c=a.length;c>b;b++)f=a[b],g.set(f,e),e+=f.length;return g}},f={arraySet:function(a,b,c,d,e){for(var f=0;d>f;f++)a[e+f]=b[c+f]},flattenChunks:function(a){return[].concat.apply([],a)}};c.setTyped=function(a){a?(c.Buf8=Uint8Array,c.Buf16=Uint16Array,c.Buf32=Int32Array,c.assign(c,e)):(c.Buf8=Array,c.Buf16=Array,c.Buf32=Array,c.assign(c,f))},c.setTyped(d)},{}],28:[function(a,b,c){"use strict";function d(a,b){if(65537>b&&(a.subarray&&g||!a.subarray&&f))return String.fromCharCode.apply(null,e.shrinkBuf(a,b));for(var c="",d=0;b>d;d++)c+=String.fromCharCode(a[d]);return c}var e=a("./common"),f=!0,g=!0;try{String.fromCharCode.apply(null,[0])}catch(a){f=!1}try{String.fromCharCode.apply(null,new Uint8Array(1))}catch(a){g=!1}for(var h=new e.Buf8(256),i=0;256>i;i++)h[i]=i>=252?6:i>=248?5:i>=240?4:i>=224?3:i>=192?2:1;h[254]=h[254]=1,c.string2buf=function(a){var b,c,d,f,g,h=a.length,i=0;for(f=0;h>f;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),i+=128>c?1:2048>c?2:65536>c?3:4;for(b=new e.Buf8(i),g=0,f=0;i>g;f++)c=a.charCodeAt(f),55296==(64512&c)&&h>f+1&&56320==(64512&(d=a.charCodeAt(f+1)))&&(c=65536+(c-55296<<10)+(d-56320),f++),128>c?b[g++]=c:2048>c?(b[g++]=192|c>>>6,b[g++]=128|63&c):65536>c?(b[g++]=224|c>>>12,b[g++]=128|c>>>6&63,b[g++]=128|63&c):(b[g++]=240|c>>>18,b[g++]=128|c>>>12&63,b[g++]=128|c>>>6&63,b[g++]=128|63&c);return b},c.buf2binstring=function(a){return d(a,a.length)},c.binstring2buf=function(a){for(var b=new e.Buf8(a.length),c=0,d=b.length;d>c;c++)b[c]=a.charCodeAt(c);return b},c.buf2string=function(a,b){var c,e,f,g,i=b||a.length,j=new Array(2*i);for(e=0,c=0;i>c;)if(128>(f=a[c++]))j[e++]=f;else if((g=h[f])>4)j[e++]=65533,c+=g-1;else{for(f&=2===g?31:3===g?15:7;g>1&&i>c;)f=f<<6|63&a[c++],g--;g>1?j[e++]=65533:65536>f?j[e++]=f:(f-=65536,j[e++]=55296|f>>10&1023,j[e++]=56320|1023&f)}return d(j,e)},c.utf8border=function(a,b){var c;for(b=b||a.length,b>a.length&&(b=a.length),c=b-1;c>=0&&128==(192&a[c]);)c--;return 0>c?b:0===c?b:c+h[a[c]]>b?c:b}},{"./common":27}],29:[function(a,b){"use strict";function c(a,b,c,d){for(var e=65535&a|0,f=a>>>16&65535|0,g=0;0!==c;){g=c>2e3?2e3:c,c-=g;do{e=e+b[d++]|0,f=f+e|0}while(--g);e%=65521,f%=65521}return e|f<<16|0}b.exports=c},{}],30:[function(a,b){b.exports={Z_NO_FLUSH:0,Z_PARTIAL_FLUSH:1,Z_SYNC_FLUSH:2,Z_FULL_FLUSH:3,Z_FINISH:4,Z_BLOCK:5,Z_TREES:6,Z_OK:0,Z_STREAM_END:1,Z_NEED_DICT:2,Z_ERRNO:-1,Z_STREAM_ERROR:-2,Z_DATA_ERROR:-3,Z_BUF_ERROR:-5,Z_NO_COMPRESSION:0,Z_BEST_SPEED:1,Z_BEST_COMPRESSION:9,Z_DEFAULT_COMPRESSION:-1,Z_FILTERED:1,Z_HUFFMAN_ONLY:2,Z_RLE:3,Z_FIXED:4,Z_DEFAULT_STRATEGY:0,Z_BINARY:0,Z_TEXT:1,Z_UNKNOWN:2,Z_DEFLATED:8}},{}],31:[function(a,b){"use strict";function c(a,b,c,e){var f=d,g=e+c;a^=-1;for(var h=e;g>h;h++)a=a>>>8^f[255&(a^b[h])];return-1^a}var d=function(){for(var a,b=[],c=0;256>c;c++){a=c;for(var d=0;8>d;d++)a=1&a?3988292384^a>>>1:a>>>1;b[c]=a}return b}();b.exports=c},{}],32:[function(a,b,c){"use strict";function d(a,b){return a.msg=G[b],b}function e(a){return(a<<1)-(a>4?9:0)}function f(a){for(var b=a.length;--b>=0;)a[b]=0}function g(a){var b=a.state,c=b.pending;c>a.avail_out&&(c=a.avail_out),0!==c&&(C.arraySet(a.output,b.pending_buf,b.pending_out,c,a.next_out),a.next_out+=c,b.pending_out+=c,a.total_out+=c,a.avail_out-=c,b.pending-=c,0===b.pending&&(b.pending_out=0))}function h(a,b){D._tr_flush_block(a,a.block_start>=0?a.block_start:-1,a.strstart-a.block_start,b),a.block_start=a.strstart,g(a.strm)}function i(a,b){a.pending_buf[a.pending++]=b}function j(a,b){a.pending_buf[a.pending++]=b>>>8&255,a.pending_buf[a.pending++]=255&b}function k(a,b,c,d){var e=a.avail_in;return e>d&&(e=d),0===e?0:(a.avail_in-=e,C.arraySet(b,a.input,a.next_in,e,c),1===a.state.wrap?a.adler=E(a.adler,b,e,c):2===a.state.wrap&&(a.adler=F(a.adler,b,e,c)),a.next_in+=e,a.total_in+=e,e)}function l(a,b){var c,d,e=a.max_chain_length,f=a.strstart,g=a.prev_length,h=a.nice_match,i=a.strstart>a.w_size-ha?a.strstart-(a.w_size-ha):0,j=a.window,k=a.w_mask,l=a.prev,m=a.strstart+ga,n=j[f+g-1],o=j[f+g];a.prev_length>=a.good_match&&(e>>=2),h>a.lookahead&&(h=a.lookahead);do{if(c=b,j[c+g]===o&&j[c+g-1]===n&&j[c]===j[f]&&j[++c]===j[f+1]){f+=2,c++;do{}while(j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&j[++f]===j[++c]&&m>f);if(d=ga-(m-f),f=m-ga,d>g){if(a.match_start=b,g=d,d>=h)break;n=j[f+g-1],o=j[f+g]}}}while((b=l[b&k])>i&&0!=--e)
;return g<=a.lookahead?g:a.lookahead}function m(a){var b,c,d,e,f,g=a.w_size;do{if(e=a.window_size-a.lookahead-a.strstart,a.strstart>=g+(g-ha)){C.arraySet(a.window,a.window,g,g,0),a.match_start-=g,a.strstart-=g,a.block_start-=g,c=a.hash_size,b=c;do{d=a.head[--b],a.head[b]=d>=g?d-g:0}while(--c);c=g,b=c;do{d=a.prev[--b],a.prev[b]=d>=g?d-g:0}while(--c);e+=g}if(0===a.strm.avail_in)break;if(c=k(a.strm,a.window,a.strstart+a.lookahead,e),a.lookahead+=c,a.lookahead+a.insert>=fa)for(f=a.strstart-a.insert,a.ins_h=a.window[f],a.ins_h=(a.ins_h<<a.hash_shift^a.window[f+1])&a.hash_mask;a.insert&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[f+fa-1])&a.hash_mask,a.prev[f&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=f,f++,a.insert--,!(a.lookahead+a.insert<fa)););}while(a.lookahead<ha&&0!==a.strm.avail_in)}function n(a,b){var c=65535;for(c>a.pending_buf_size-5&&(c=a.pending_buf_size-5);;){if(a.lookahead<=1){if(m(a),0===a.lookahead&&b===H)return qa;if(0===a.lookahead)break}a.strstart+=a.lookahead,a.lookahead=0;var d=a.block_start+c;if((0===a.strstart||a.strstart>=d)&&(a.lookahead=a.strstart-d,a.strstart=d,h(a,!1),0===a.strm.avail_out))return qa;if(a.strstart-a.block_start>=a.w_size-ha&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=0,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):(a.strstart>a.block_start&&(h(a,!1),a.strm.avail_out),qa)}function o(a,b){for(var c,d;;){if(a.lookahead<ha){if(m(a),a.lookahead<ha&&b===H)return qa;if(0===a.lookahead)break}if(c=0,a.lookahead>=fa&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart),0!==c&&a.strstart-c<=a.w_size-ha&&(a.match_length=l(a,c)),a.match_length>=fa)if(d=D._tr_tally(a,a.strstart-a.match_start,a.match_length-fa),a.lookahead-=a.match_length,a.match_length<=a.max_lazy_match&&a.lookahead>=fa){a.match_length--;do{a.strstart++,a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart}while(0!=--a.match_length);a.strstart++}else a.strstart+=a.match_length,a.match_length=0,a.ins_h=a.window[a.strstart],a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+1])&a.hash_mask;else d=D._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++;if(d&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=a.strstart<fa-1?a.strstart:fa-1,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function p(a,b){for(var c,d,e;;){if(a.lookahead<ha){if(m(a),a.lookahead<ha&&b===H)return qa;if(0===a.lookahead)break}if(c=0,a.lookahead>=fa&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart),a.prev_length=a.match_length,a.prev_match=a.match_start,a.match_length=fa-1,0!==c&&a.prev_length<a.max_lazy_match&&a.strstart-c<=a.w_size-ha&&(a.match_length=l(a,c),a.match_length<=5&&(a.strategy===S||a.match_length===fa&&a.strstart-a.match_start>4096)&&(a.match_length=fa-1)),a.prev_length>=fa&&a.match_length<=a.prev_length){e=a.strstart+a.lookahead-fa,d=D._tr_tally(a,a.strstart-1-a.prev_match,a.prev_length-fa),a.lookahead-=a.prev_length-1,a.prev_length-=2;do{++a.strstart<=e&&(a.ins_h=(a.ins_h<<a.hash_shift^a.window[a.strstart+fa-1])&a.hash_mask,c=a.prev[a.strstart&a.w_mask]=a.head[a.ins_h],a.head[a.ins_h]=a.strstart)}while(0!=--a.prev_length);if(a.match_available=0,a.match_length=fa-1,a.strstart++,d&&(h(a,!1),0===a.strm.avail_out))return qa}else if(a.match_available){if(d=D._tr_tally(a,0,a.window[a.strstart-1]),d&&h(a,!1),a.strstart++,a.lookahead--,0===a.strm.avail_out)return qa}else a.match_available=1,a.strstart++,a.lookahead--}return a.match_available&&(d=D._tr_tally(a,0,a.window[a.strstart-1]),a.match_available=0),a.insert=a.strstart<fa-1?a.strstart:fa-1,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function q(a,b){for(var c,d,e,f,g=a.window;;){if(a.lookahead<=ga){if(m(a),a.lookahead<=ga&&b===H)return qa;if(0===a.lookahead)break}if(a.match_length=0,a.lookahead>=fa&&a.strstart>0&&(e=a.strstart-1,(d=g[e])===g[++e]&&d===g[++e]&&d===g[++e])){f=a.strstart+ga;do{}while(d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&d===g[++e]&&f>e);a.match_length=ga-(f-e),a.match_length>a.lookahead&&(a.match_length=a.lookahead)}if(a.match_length>=fa?(c=D._tr_tally(a,1,a.match_length-fa),a.lookahead-=a.match_length,a.strstart+=a.match_length,a.match_length=0):(c=D._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++),c&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=0,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function r(a,b){for(var c;;){if(0===a.lookahead&&(m(a),0===a.lookahead)){if(b===H)return qa;break}if(a.match_length=0,c=D._tr_tally(a,0,a.window[a.strstart]),a.lookahead--,a.strstart++,c&&(h(a,!1),0===a.strm.avail_out))return qa}return a.insert=0,b===K?(h(a,!0),0===a.strm.avail_out?sa:ta):a.last_lit&&(h(a,!1),0===a.strm.avail_out)?qa:ra}function s(a){a.window_size=2*a.w_size,f(a.head),a.max_lazy_match=B[a.level].max_lazy,a.good_match=B[a.level].good_length,a.nice_match=B[a.level].nice_length,a.max_chain_length=B[a.level].max_chain,a.strstart=0,a.block_start=0,a.lookahead=0,a.insert=0,a.match_length=a.prev_length=fa-1,a.match_available=0,a.ins_h=0}function t(){this.strm=null,this.status=0,this.pending_buf=null,this.pending_buf_size=0,this.pending_out=0,this.pending=0,this.wrap=0,this.gzhead=null,this.gzindex=0,this.method=Y,this.last_flush=-1,this.w_size=0,this.w_bits=0,this.w_mask=0,this.window=null,this.window_size=0,this.prev=null,this.head=null,this.ins_h=0,this.hash_size=0,this.hash_bits=0,this.hash_mask=0,this.hash_shift=0,this.block_start=0,this.match_length=0,this.prev_match=0,this.match_available=0,this.strstart=0,this.match_start=0,this.lookahead=0,this.prev_length=0,this.max_chain_length=0,this.max_lazy_match=0,this.level=0,this.strategy=0,this.good_match=0,this.nice_match=0,this.dyn_ltree=new C.Buf16(2*da),this.dyn_dtree=new C.Buf16(2*(2*ba+1)),this.bl_tree=new C.Buf16(2*(2*ca+1)),f(this.dyn_ltree),f(this.dyn_dtree),f(this.bl_tree),this.l_desc=null,this.d_desc=null,this.bl_desc=null,this.bl_count=new C.Buf16(ea+1),this.heap=new C.Buf16(2*aa+1),f(this.heap),this.heap_len=0,this.heap_max=0,this.depth=new C.Buf16(2*aa+1),f(this.depth),this.l_buf=0,this.lit_bufsize=0,this.last_lit=0,this.d_buf=0,this.opt_len=0,this.static_len=0,this.matches=0,this.insert=0,this.bi_buf=0,this.bi_valid=0}function u(a){var b;return a&&a.state?(a.total_in=a.total_out=0,a.data_type=X,b=a.state,b.pending=0,b.pending_out=0,b.wrap<0&&(b.wrap=-b.wrap),b.status=b.wrap?ja:oa,a.adler=2===b.wrap?0:1,b.last_flush=H,D._tr_init(b),M):d(a,O)}function v(a){var b=u(a);return b===M&&s(a.state),b}function w(a,b){return a&&a.state?2!==a.state.wrap?O:(a.state.gzhead=b,M):O}function x(a,b,c,e,f,g){if(!a)return O;var h=1;if(b===R&&(b=6),0>e?(h=0,e=-e):e>15&&(h=2,e-=16),1>f||f>Z||c!==Y||8>e||e>15||0>b||b>9||0>g||g>V)return d(a,O);8===e&&(e=9);var i=new t;return a.state=i,i.strm=a,i.wrap=h,i.gzhead=null,i.w_bits=e,i.w_size=1<<i.w_bits,i.w_mask=i.w_size-1,i.hash_bits=f+7,i.hash_size=1<<i.hash_bits,i.hash_mask=i.hash_size-1,i.hash_shift=~~((i.hash_bits+fa-1)/fa),i.window=new C.Buf8(2*i.w_size),i.head=new C.Buf16(i.hash_size),i.prev=new C.Buf16(i.w_size),i.lit_bufsize=1<<f+6,i.pending_buf_size=4*i.lit_bufsize,i.pending_buf=new C.Buf8(i.pending_buf_size),i.d_buf=i.lit_bufsize>>1,i.l_buf=3*i.lit_bufsize,i.level=b,i.strategy=g,i.method=c,v(a)}function y(a,b){return x(a,b,Y,$,_,W)}function z(a,b){var c,h,k,l;if(!a||!a.state||b>L||0>b)return a?d(a,O):O;if(h=a.state,!a.output||!a.input&&0!==a.avail_in||h.status===pa&&b!==K)return d(a,0===a.avail_out?Q:O);if(h.strm=a,c=h.last_flush,h.last_flush=b,h.status===ja)if(2===h.wrap)a.adler=0,i(h,31),i(h,139),i(h,8),
h.gzhead?(i(h,(h.gzhead.text?1:0)+(h.gzhead.hcrc?2:0)+(h.gzhead.extra?4:0)+(h.gzhead.name?8:0)+(h.gzhead.comment?16:0)),i(h,255&h.gzhead.time),i(h,h.gzhead.time>>8&255),i(h,h.gzhead.time>>16&255),i(h,h.gzhead.time>>24&255),i(h,9===h.level?2:h.strategy>=T||h.level<2?4:0),i(h,255&h.gzhead.os),h.gzhead.extra&&h.gzhead.extra.length&&(i(h,255&h.gzhead.extra.length),i(h,h.gzhead.extra.length>>8&255)),h.gzhead.hcrc&&(a.adler=F(a.adler,h.pending_buf,h.pending,0)),h.gzindex=0,h.status=ka):(i(h,0),i(h,0),i(h,0),i(h,0),i(h,0),i(h,9===h.level?2:h.strategy>=T||h.level<2?4:0),i(h,ua),h.status=oa);else{var m=Y+(h.w_bits-8<<4)<<8,n=-1;n=h.strategy>=T||h.level<2?0:h.level<6?1:6===h.level?2:3,m|=n<<6,0!==h.strstart&&(m|=ia),m+=31-m%31,h.status=oa,j(h,m),0!==h.strstart&&(j(h,a.adler>>>16),j(h,65535&a.adler)),a.adler=1}if(h.status===ka)if(h.gzhead.extra){for(k=h.pending;h.gzindex<(65535&h.gzhead.extra.length)&&(h.pending!==h.pending_buf_size||(h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),g(a),k=h.pending,h.pending!==h.pending_buf_size));)i(h,255&h.gzhead.extra[h.gzindex]),h.gzindex++;h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),h.gzindex===h.gzhead.extra.length&&(h.gzindex=0,h.status=la)}else h.status=la;if(h.status===la)if(h.gzhead.name){k=h.pending;do{if(h.pending===h.pending_buf_size&&(h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),g(a),k=h.pending,h.pending===h.pending_buf_size)){l=1;break}l=h.gzindex<h.gzhead.name.length?255&h.gzhead.name.charCodeAt(h.gzindex++):0,i(h,l)}while(0!==l);h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),0===l&&(h.gzindex=0,h.status=ma)}else h.status=ma;if(h.status===ma)if(h.gzhead.comment){k=h.pending;do{if(h.pending===h.pending_buf_size&&(h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),g(a),k=h.pending,h.pending===h.pending_buf_size)){l=1;break}l=h.gzindex<h.gzhead.comment.length?255&h.gzhead.comment.charCodeAt(h.gzindex++):0,i(h,l)}while(0!==l);h.gzhead.hcrc&&h.pending>k&&(a.adler=F(a.adler,h.pending_buf,h.pending-k,k)),0===l&&(h.status=na)}else h.status=na;if(h.status===na&&(h.gzhead.hcrc?(h.pending+2>h.pending_buf_size&&g(a),h.pending+2<=h.pending_buf_size&&(i(h,255&a.adler),i(h,a.adler>>8&255),a.adler=0,h.status=oa)):h.status=oa),0!==h.pending){if(g(a),0===a.avail_out)return h.last_flush=-1,M}else if(0===a.avail_in&&e(b)<=e(c)&&b!==K)return d(a,Q);if(h.status===pa&&0!==a.avail_in)return d(a,Q);if(0!==a.avail_in||0!==h.lookahead||b!==H&&h.status!==pa){var o=h.strategy===T?r(h,b):h.strategy===U?q(h,b):B[h.level].func(h,b);if((o===sa||o===ta)&&(h.status=pa),o===qa||o===sa)return 0===a.avail_out&&(h.last_flush=-1),M;if(o===ra&&(b===I?D._tr_align(h):b!==L&&(D._tr_stored_block(h,0,0,!1),b===J&&(f(h.head),0===h.lookahead&&(h.strstart=0,h.block_start=0,h.insert=0))),g(a),0===a.avail_out))return h.last_flush=-1,M}return b!==K?M:h.wrap<=0?N:(2===h.wrap?(i(h,255&a.adler),i(h,a.adler>>8&255),i(h,a.adler>>16&255),i(h,a.adler>>24&255),i(h,255&a.total_in),i(h,a.total_in>>8&255),i(h,a.total_in>>16&255),i(h,a.total_in>>24&255)):(j(h,a.adler>>>16),j(h,65535&a.adler)),g(a),h.wrap>0&&(h.wrap=-h.wrap),0!==h.pending?M:N)}function A(a){var b;return a&&a.state?(b=a.state.status,b!==ja&&b!==ka&&b!==la&&b!==ma&&b!==na&&b!==oa&&b!==pa?d(a,O):(a.state=null,b===oa?d(a,P):M)):O}var B,C=a("../utils/common"),D=a("./trees"),E=a("./adler32"),F=a("./crc32"),G=a("./messages"),H=0,I=1,J=3,K=4,L=5,M=0,N=1,O=-2,P=-3,Q=-5,R=-1,S=1,T=2,U=3,V=4,W=0,X=2,Y=8,Z=9,$=15,_=8,aa=286,ba=30,ca=19,da=2*aa+1,ea=15,fa=3,ga=258,ha=ga+fa+1,ia=32,ja=42,ka=69,la=73,ma=91,na=103,oa=113,pa=666,qa=1,ra=2,sa=3,ta=4,ua=3,va=function(a,b,c,d,e){this.good_length=a,this.max_lazy=b,this.nice_length=c,this.max_chain=d,this.func=e};B=[new va(0,0,0,0,n),new va(4,4,8,4,o),new va(4,5,16,8,o),new va(4,6,32,32,o),new va(4,4,16,16,p),new va(8,16,32,32,p),new va(8,16,128,128,p),new va(8,32,128,256,p),new va(32,128,258,1024,p),new va(32,258,258,4096,p)],c.deflateInit=y,c.deflateInit2=x,c.deflateReset=v,c.deflateResetKeep=u,c.deflateSetHeader=w,c.deflate=z,c.deflateEnd=A,c.deflateInfo="pako deflate (from Nodeca project)"},{"../utils/common":27,"./adler32":29,"./crc32":31,"./messages":37,"./trees":38}],33:[function(a,b){"use strict";function c(){this.text=0,this.time=0,this.xflags=0,this.os=0,this.extra=null,this.extra_len=0,this.name="",this.comment="",this.hcrc=0,this.done=!1}b.exports=c},{}],34:[function(a,b){"use strict";b.exports=function(a,b){var c,d,e,f,g,h,i,j,k,l,m,n,o,p,q,r,s,t,u,v,w,x,y,z,A;c=a.state,d=a.next_in,z=a.input,e=d+(a.avail_in-5),f=a.next_out,A=a.output,g=f-(b-a.avail_out),h=f+(a.avail_out-257),i=c.dmax,j=c.wsize,k=c.whave,l=c.wnext,m=c.window,n=c.hold,o=c.bits,p=c.lencode,q=c.distcode,r=(1<<c.lenbits)-1,s=(1<<c.distbits)-1;a:do{15>o&&(n+=z[d++]<<o,o+=8,n+=z[d++]<<o,o+=8),t=p[n&r];b:for(;;){if(u=t>>>24,n>>>=u,o-=u,0===(u=t>>>16&255))A[f++]=65535&t;else{if(!(16&u)){if(0==(64&u)){t=p[(65535&t)+(n&(1<<u)-1)];continue b}if(32&u){c.mode=12;break a}a.msg="invalid literal/length code",c.mode=30;break a}v=65535&t,u&=15,u&&(u>o&&(n+=z[d++]<<o,o+=8),v+=n&(1<<u)-1,n>>>=u,o-=u),15>o&&(n+=z[d++]<<o,o+=8,n+=z[d++]<<o,o+=8),t=q[n&s];c:for(;;){if(u=t>>>24,n>>>=u,o-=u,!(16&(u=t>>>16&255))){if(0==(64&u)){t=q[(65535&t)+(n&(1<<u)-1)];continue c}a.msg="invalid distance code",c.mode=30;break a}if(w=65535&t,u&=15,u>o&&(n+=z[d++]<<o,o+=8,u>o&&(n+=z[d++]<<o,o+=8)),(w+=n&(1<<u)-1)>i){a.msg="invalid distance too far back",c.mode=30;break a}if(n>>>=u,o-=u,u=f-g,w>u){if((u=w-u)>k&&c.sane){a.msg="invalid distance too far back",c.mode=30;break a}if(x=0,y=m,0===l){if(x+=j-u,v>u){v-=u;do{A[f++]=m[x++]}while(--u);x=f-w,y=A}}else if(u>l){if(x+=j+l-u,u-=l,v>u){v-=u;do{A[f++]=m[x++]}while(--u);if(x=0,v>l){u=l,v-=u;do{A[f++]=m[x++]}while(--u);x=f-w,y=A}}}else if(x+=l-u,v>u){v-=u;do{A[f++]=m[x++]}while(--u);x=f-w,y=A}for(;v>2;)A[f++]=y[x++],A[f++]=y[x++],A[f++]=y[x++],v-=3;v&&(A[f++]=y[x++],v>1&&(A[f++]=y[x++]))}else{x=f-w;do{A[f++]=A[x++],A[f++]=A[x++],A[f++]=A[x++],v-=3}while(v>2);v&&(A[f++]=A[x++],v>1&&(A[f++]=A[x++]))}break}}break}}while(e>d&&h>f);v=o>>3,d-=v,o-=v<<3,n&=(1<<o)-1,a.next_in=d,a.next_out=f,a.avail_in=e>d?e-d+5:5-(d-e),a.avail_out=h>f?h-f+257:257-(f-h),c.hold=n,c.bits=o}},{}],35:[function(a,b,c){"use strict";function d(a){return(a>>>24&255)+(a>>>8&65280)+((65280&a)<<8)+((255&a)<<24)}function e(){this.mode=0,this.last=!1,this.wrap=0,this.havedict=!1,this.flags=0,this.dmax=0,this.check=0,this.total=0,this.head=null,this.wbits=0,this.wsize=0,this.whave=0,this.wnext=0,this.window=null,this.hold=0,this.bits=0,this.length=0,this.offset=0,this.extra=0,this.lencode=null,this.distcode=null,this.lenbits=0,this.distbits=0,this.ncode=0,this.nlen=0,this.ndist=0,this.have=0,this.next=null,this.lens=new r.Buf16(320),this.work=new r.Buf16(288),this.lendyn=null,this.distdyn=null,this.sane=0,this.back=0,this.was=0}function f(a){var b;return a&&a.state?(b=a.state,a.total_in=a.total_out=b.total=0,a.msg="",b.wrap&&(a.adler=1&b.wrap),b.mode=K,b.last=0,b.havedict=0,b.dmax=32768,b.head=null,b.hold=0,b.bits=0,b.lencode=b.lendyn=new r.Buf32(oa),b.distcode=b.distdyn=new r.Buf32(pa),b.sane=1,b.back=-1,C):F}function g(a){var b;return a&&a.state?(b=a.state,b.wsize=0,b.whave=0,b.wnext=0,f(a)):F}function h(a,b){var c,d;return a&&a.state?(d=a.state,0>b?(c=0,b=-b):(c=1+(b>>4),48>b&&(b&=15)),b&&(8>b||b>15)?F:(null!==d.window&&d.wbits!==b&&(d.window=null),d.wrap=c,d.wbits=b,g(a))):F}function i(a,b){var c,d;return a?(d=new e,a.state=d,d.window=null,c=h(a,b),c!==C&&(a.state=null),c):F}function j(a){return i(a,qa)}function k(a){if(ra){var b;for(p=new r.Buf32(512),q=new r.Buf32(32),b=0;144>b;)a.lens[b++]=8;for(;256>b;)a.lens[b++]=9;for(;280>b;)a.lens[b++]=7;for(;288>b;)a.lens[b++]=8;for(v(x,a.lens,0,288,p,0,a.work,{bits:9}),b=0;32>b;)a.lens[b++]=5;v(y,a.lens,0,32,q,0,a.work,{bits:5}),ra=!1}
a.lencode=p,a.lenbits=9,a.distcode=q,a.distbits=5}function l(a,b,c,d){var e,f=a.state;return null===f.window&&(f.wsize=1<<f.wbits,f.wnext=0,f.whave=0,f.window=new r.Buf8(f.wsize)),d>=f.wsize?(r.arraySet(f.window,b,c-f.wsize,f.wsize,0),f.wnext=0,f.whave=f.wsize):(e=f.wsize-f.wnext,e>d&&(e=d),r.arraySet(f.window,b,c-d,e,f.wnext),d-=e,d?(r.arraySet(f.window,b,c-d,d,0),f.wnext=d,f.whave=f.wsize):(f.wnext+=e,f.wnext===f.wsize&&(f.wnext=0),f.whave<f.wsize&&(f.whave+=e))),0}function m(a,b){var c,e,f,g,h,i,j,m,n,o,p,q,oa,pa,qa,ra,sa,ta,ua,va,wa,xa,ya,za,Aa=0,Ba=new r.Buf8(4),Ca=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15];if(!a||!a.state||!a.output||!a.input&&0!==a.avail_in)return F;c=a.state,c.mode===V&&(c.mode=W),h=a.next_out,f=a.output,j=a.avail_out,g=a.next_in,e=a.input,i=a.avail_in,m=c.hold,n=c.bits,o=i,p=j,xa=C;a:for(;;)switch(c.mode){case K:if(0===c.wrap){c.mode=W;break}for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(2&c.wrap&&35615===m){c.check=0,Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0),m=0,n=0,c.mode=L;break}if(c.flags=0,c.head&&(c.head.done=!1),!(1&c.wrap)||(((255&m)<<8)+(m>>8))%31){a.msg="incorrect header check",c.mode=la;break}if((15&m)!==J){a.msg="unknown compression method",c.mode=la;break}if(m>>>=4,n-=4,wa=8+(15&m),0===c.wbits)c.wbits=wa;else if(wa>c.wbits){a.msg="invalid window size",c.mode=la;break}c.dmax=1<<wa,a.adler=c.check=1,c.mode=512&m?T:V,m=0,n=0;break;case L:for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(c.flags=m,(255&c.flags)!==J){a.msg="unknown compression method",c.mode=la;break}if(57344&c.flags){a.msg="unknown header flags set",c.mode=la;break}c.head&&(c.head.text=m>>8&1),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0)),m=0,n=0,c.mode=M;case M:for(;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.head&&(c.head.time=m),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,Ba[2]=m>>>16&255,Ba[3]=m>>>24&255,c.check=t(c.check,Ba,4,0)),m=0,n=0,c.mode=N;case N:for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.head&&(c.head.xflags=255&m,c.head.os=m>>8),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0)),m=0,n=0,c.mode=O;case O:if(1024&c.flags){for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.length=m,c.head&&(c.head.extra_len=m),512&c.flags&&(Ba[0]=255&m,Ba[1]=m>>>8&255,c.check=t(c.check,Ba,2,0)),m=0,n=0}else c.head&&(c.head.extra=null);c.mode=P;case P:if(1024&c.flags&&(q=c.length,q>i&&(q=i),q&&(c.head&&(wa=c.head.extra_len-c.length,c.head.extra||(c.head.extra=new Array(c.head.extra_len)),r.arraySet(c.head.extra,e,g,q,wa)),512&c.flags&&(c.check=t(c.check,e,q,g)),i-=q,g+=q,c.length-=q),c.length))break a;c.length=0,c.mode=Q;case Q:if(2048&c.flags){if(0===i)break a;q=0;do{wa=e[g+q++],c.head&&wa&&c.length<65536&&(c.head.name+=String.fromCharCode(wa))}while(wa&&i>q);if(512&c.flags&&(c.check=t(c.check,e,q,g)),i-=q,g+=q,wa)break a}else c.head&&(c.head.name=null);c.length=0,c.mode=R;case R:if(4096&c.flags){if(0===i)break a;q=0;do{wa=e[g+q++],c.head&&wa&&c.length<65536&&(c.head.comment+=String.fromCharCode(wa))}while(wa&&i>q);if(512&c.flags&&(c.check=t(c.check,e,q,g)),i-=q,g+=q,wa)break a}else c.head&&(c.head.comment=null);c.mode=S;case S:if(512&c.flags){for(;16>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(m!==(65535&c.check)){a.msg="header crc mismatch",c.mode=la;break}m=0,n=0}c.head&&(c.head.hcrc=c.flags>>9&1,c.head.done=!0),a.adler=c.check=0,c.mode=V;break;case T:for(;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}a.adler=c.check=d(m),m=0,n=0,c.mode=U;case U:if(0===c.havedict)return a.next_out=h,a.avail_out=j,a.next_in=g,a.avail_in=i,c.hold=m,c.bits=n,E;a.adler=c.check=1,c.mode=V;case V:if(b===A||b===B)break a;case W:if(c.last){m>>>=7&n,n-=7&n,c.mode=ia;break}for(;3>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}switch(c.last=1&m,m>>>=1,n-=1,3&m){case 0:c.mode=X;break;case 1:if(k(c),c.mode=ba,b===B){m>>>=2,n-=2;break a}break;case 2:c.mode=$;break;case 3:a.msg="invalid block type",c.mode=la}m>>>=2,n-=2;break;case X:for(m>>>=7&n,n-=7&n;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if((65535&m)!=(m>>>16^65535)){a.msg="invalid stored block lengths",c.mode=la;break}if(c.length=65535&m,m=0,n=0,c.mode=Y,b===B)break a;case Y:c.mode=Z;case Z:if(q=c.length){if(q>i&&(q=i),q>j&&(q=j),0===q)break a;r.arraySet(f,e,g,q,h),i-=q,g+=q,j-=q,h+=q,c.length-=q;break}c.mode=V;break;case $:for(;14>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(c.nlen=257+(31&m),m>>>=5,n-=5,c.ndist=1+(31&m),m>>>=5,n-=5,c.ncode=4+(15&m),m>>>=4,n-=4,c.nlen>286||c.ndist>30){a.msg="too many length or distance symbols",c.mode=la;break}c.have=0,c.mode=_;case _:for(;c.have<c.ncode;){for(;3>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.lens[Ca[c.have++]]=7&m,m>>>=3,n-=3}for(;c.have<19;)c.lens[Ca[c.have++]]=0;if(c.lencode=c.lendyn,c.lenbits=7,ya={bits:c.lenbits},xa=v(w,c.lens,0,19,c.lencode,0,c.work,ya),c.lenbits=ya.bits,xa){a.msg="invalid code lengths set",c.mode=la;break}c.have=0,c.mode=aa;case aa:for(;c.have<c.nlen+c.ndist;){for(;Aa=c.lencode[m&(1<<c.lenbits)-1],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(16>sa)m>>>=qa,n-=qa,c.lens[c.have++]=sa;else{if(16===sa){for(za=qa+2;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(m>>>=qa,n-=qa,0===c.have){a.msg="invalid bit length repeat",c.mode=la;break}wa=c.lens[c.have-1],q=3+(3&m),m>>>=2,n-=2}else if(17===sa){for(za=qa+3;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=qa,n-=qa,wa=0,q=3+(7&m),m>>>=3,n-=3}else{for(za=qa+7;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=qa,n-=qa,wa=0,q=11+(127&m),m>>>=7,n-=7}if(c.have+q>c.nlen+c.ndist){a.msg="invalid bit length repeat",c.mode=la;break}for(;q--;)c.lens[c.have++]=wa}}if(c.mode===la)break;if(0===c.lens[256]){a.msg="invalid code -- missing end-of-block",c.mode=la;break}if(c.lenbits=9,ya={bits:c.lenbits},xa=v(x,c.lens,0,c.nlen,c.lencode,0,c.work,ya),c.lenbits=ya.bits,xa){a.msg="invalid literal/lengths set",c.mode=la;break}if(c.distbits=6,c.distcode=c.distdyn,ya={bits:c.distbits},xa=v(y,c.lens,c.nlen,c.ndist,c.distcode,0,c.work,ya),c.distbits=ya.bits,xa){a.msg="invalid distances set",c.mode=la;break}if(c.mode=ba,b===B)break a;case ba:c.mode=ca;case ca:if(i>=6&&j>=258){a.next_out=h,a.avail_out=j,a.next_in=g,a.avail_in=i,c.hold=m,c.bits=n,u(a,p),h=a.next_out,f=a.output,j=a.avail_out,g=a.next_in,e=a.input,i=a.avail_in,m=c.hold,n=c.bits,c.mode===V&&(c.back=-1);break}for(c.back=0;Aa=c.lencode[m&(1<<c.lenbits)-1],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(ra&&0==(240&ra)){for(ta=qa,ua=ra,va=sa;Aa=c.lencode[va+((m&(1<<ta+ua)-1)>>ta)],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=ta+qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=ta,n-=ta,c.back+=ta}if(m>>>=qa,n-=qa,c.back+=qa,c.length=sa,0===ra){c.mode=ha;break}if(32&ra){c.back=-1,c.mode=V;break}if(64&ra){a.msg="invalid literal/length code",c.mode=la;break}c.extra=15&ra,c.mode=da;case da:if(c.extra){for(za=c.extra;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.length+=m&(1<<c.extra)-1,m>>>=c.extra,n-=c.extra,c.back+=c.extra}c.was=c.length,c.mode=ea;case ea:for(;Aa=c.distcode[m&(1<<c.distbits)-1],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(0==(240&ra)){for(ta=qa,ua=ra,va=sa;Aa=c.distcode[va+((m&(1<<ta+ua)-1)>>ta)],qa=Aa>>>24,ra=Aa>>>16&255,sa=65535&Aa,!(n>=ta+qa);){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}m>>>=ta,n-=ta,c.back+=ta}if(m>>>=qa,n-=qa,c.back+=qa,64&ra){a.msg="invalid distance code",c.mode=la;break}c.offset=sa,c.extra=15&ra,c.mode=fa;case fa:if(c.extra){for(za=c.extra;za>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}c.offset+=m&(1<<c.extra)-1,m>>>=c.extra,n-=c.extra,c.back+=c.extra}if(c.offset>c.dmax){a.msg="invalid distance too far back",c.mode=la;break}c.mode=ga;case ga:if(0===j)break a;if(q=p-j,c.offset>q){if((q=c.offset-q)>c.whave&&c.sane){a.msg="invalid distance too far back",c.mode=la;break}q>c.wnext?(q-=c.wnext,oa=c.wsize-q):oa=c.wnext-q,
q>c.length&&(q=c.length),pa=c.window}else pa=f,oa=h-c.offset,q=c.length;q>j&&(q=j),j-=q,c.length-=q;do{f[h++]=pa[oa++]}while(--q);0===c.length&&(c.mode=ca);break;case ha:if(0===j)break a;f[h++]=c.length,j--,c.mode=ca;break;case ia:if(c.wrap){for(;32>n;){if(0===i)break a;i--,m|=e[g++]<<n,n+=8}if(p-=j,a.total_out+=p,c.total+=p,p&&(a.adler=c.check=c.flags?t(c.check,f,p,h-p):s(c.check,f,p,h-p)),p=j,(c.flags?m:d(m))!==c.check){a.msg="incorrect data check",c.mode=la;break}m=0,n=0}c.mode=ja;case ja:if(c.wrap&&c.flags){for(;32>n;){if(0===i)break a;i--,m+=e[g++]<<n,n+=8}if(m!==(4294967295&c.total)){a.msg="incorrect length check",c.mode=la;break}m=0,n=0}c.mode=ka;case ka:xa=D;break a;case la:xa=G;break a;case ma:return H;case na:default:return F}return a.next_out=h,a.avail_out=j,a.next_in=g,a.avail_in=i,c.hold=m,c.bits=n,(c.wsize||p!==a.avail_out&&c.mode<la&&(c.mode<ia||b!==z))&&l(a,a.output,a.next_out,p-a.avail_out)?(c.mode=ma,H):(o-=a.avail_in,p-=a.avail_out,a.total_in+=o,a.total_out+=p,c.total+=p,c.wrap&&p&&(a.adler=c.check=c.flags?t(c.check,f,p,a.next_out-p):s(c.check,f,p,a.next_out-p)),a.data_type=c.bits+(c.last?64:0)+(c.mode===V?128:0)+(c.mode===ba||c.mode===Y?256:0),(0===o&&0===p||b===z)&&xa===C&&(xa=I),xa)}function n(a){if(!a||!a.state)return F;var b=a.state;return b.window&&(b.window=null),a.state=null,C}function o(a,b){var c;return a&&a.state?(c=a.state,0==(2&c.wrap)?F:(c.head=b,b.done=!1,C)):F}var p,q,r=a("../utils/common"),s=a("./adler32"),t=a("./crc32"),u=a("./inffast"),v=a("./inftrees"),w=0,x=1,y=2,z=4,A=5,B=6,C=0,D=1,E=2,F=-2,G=-3,H=-4,I=-5,J=8,K=1,L=2,M=3,N=4,O=5,P=6,Q=7,R=8,S=9,T=10,U=11,V=12,W=13,X=14,Y=15,Z=16,$=17,_=18,aa=19,ba=20,ca=21,da=22,ea=23,fa=24,ga=25,ha=26,ia=27,ja=28,ka=29,la=30,ma=31,na=32,oa=852,pa=592,qa=15,ra=!0;c.inflateReset=g,c.inflateReset2=h,c.inflateResetKeep=f,c.inflateInit=j,c.inflateInit2=i,c.inflate=m,c.inflateEnd=n,c.inflateGetHeader=o,c.inflateInfo="pako inflate (from Nodeca project)"},{"../utils/common":27,"./adler32":29,"./crc32":31,"./inffast":34,"./inftrees":36}],36:[function(a,b){"use strict";var c=a("../utils/common"),d=15,e=[3,4,5,6,7,8,9,10,11,13,15,17,19,23,27,31,35,43,51,59,67,83,99,115,131,163,195,227,258,0,0],f=[16,16,16,16,16,16,16,16,17,17,17,17,18,18,18,18,19,19,19,19,20,20,20,20,21,21,21,21,16,72,78],g=[1,2,3,4,5,7,9,13,17,25,33,49,65,97,129,193,257,385,513,769,1025,1537,2049,3073,4097,6145,8193,12289,16385,24577,0,0],h=[16,16,16,16,17,17,18,18,19,19,20,20,21,21,22,22,23,23,24,24,25,25,26,26,27,27,28,28,29,29,64,64];b.exports=function(a,b,i,j,k,l,m,n){var o,p,q,r,s,t,u,v,w,x=n.bits,y=0,z=0,A=0,B=0,C=0,D=0,E=0,F=0,G=0,H=0,I=null,J=0,K=new c.Buf16(16),L=new c.Buf16(16),M=null,N=0;for(y=0;d>=y;y++)K[y]=0;for(z=0;j>z;z++)K[b[i+z]]++;for(C=x,B=d;B>=1&&0===K[B];B--);if(C>B&&(C=B),0===B)return k[l++]=20971520,k[l++]=20971520,n.bits=1,0;for(A=1;B>A&&0===K[A];A++);for(A>C&&(C=A),F=1,y=1;d>=y;y++)if(F<<=1,0>(F-=K[y]))return-1;if(F>0&&(0===a||1!==B))return-1;for(L[1]=0,y=1;d>y;y++)L[y+1]=L[y]+K[y];for(z=0;j>z;z++)0!==b[i+z]&&(m[L[b[i+z]]++]=z);if(0===a?(I=M=m,t=19):1===a?(I=e,J-=257,M=f,N-=257,t=256):(I=g,M=h,t=-1),H=0,z=0,y=A,s=l,D=C,E=0,q=-1,G=1<<C,r=G-1,1===a&&G>852||2===a&&G>592)return 1;for(var O=0;;){O++,u=y-E,m[z]<t?(v=0,w=m[z]):m[z]>t?(v=M[N+m[z]],w=I[J+m[z]]):(v=96,w=0),o=1<<y-E,p=1<<D,A=p;do{p-=o,k[s+(H>>E)+p]=u<<24|v<<16|w|0}while(0!==p);for(o=1<<y-1;H&o;)o>>=1;if(0!==o?(H&=o-1,H+=o):H=0,z++,0==--K[y]){if(y===B)break;y=b[i+m[z]]}if(y>C&&(H&r)!==q){for(0===E&&(E=C),s+=A,D=y-E,F=1<<D;B>D+E&&!(0>=(F-=K[D+E]));)D++,F<<=1;if(G+=1<<D,1===a&&G>852||2===a&&G>592)return 1;q=H&r,k[q]=C<<24|D<<16|s-l|0}}return 0!==H&&(k[s+H]=y-E<<24|64<<16|0),n.bits=C,0}},{"../utils/common":27}],37:[function(a,b){"use strict";b.exports={2:"need dictionary",1:"stream end",0:"","-1":"file error","-2":"stream error","-3":"data error","-4":"insufficient memory","-5":"buffer error","-6":"incompatible version"}},{}],38:[function(a,b,c){"use strict";function d(a){for(var b=a.length;--b>=0;)a[b]=0}function e(a){return 256>a?da[a]:da[256+(a>>>7)]}function f(a,b){a.pending_buf[a.pending++]=255&b,a.pending_buf[a.pending++]=b>>>8&255}function g(a,b,c){a.bi_valid>T-c?(a.bi_buf|=b<<a.bi_valid&65535,f(a,a.bi_buf),a.bi_buf=b>>T-a.bi_valid,a.bi_valid+=c-T):(a.bi_buf|=b<<a.bi_valid&65535,a.bi_valid+=c)}function h(a,b,c){g(a,c[2*b],c[2*b+1])}function i(a,b){var c=0;do{c|=1&a,a>>>=1,c<<=1}while(--b>0);return c>>>1}function j(a){16===a.bi_valid?(f(a,a.bi_buf),a.bi_buf=0,a.bi_valid=0):a.bi_valid>=8&&(a.pending_buf[a.pending++]=255&a.bi_buf,a.bi_buf>>=8,a.bi_valid-=8)}function k(a,b){var c,d,e,f,g,h,i=b.dyn_tree,j=b.max_code,k=b.stat_desc.static_tree,l=b.stat_desc.has_stree,m=b.stat_desc.extra_bits,n=b.stat_desc.extra_base,o=b.stat_desc.max_length,p=0;for(f=0;S>=f;f++)a.bl_count[f]=0;for(i[2*a.heap[a.heap_max]+1]=0,c=a.heap_max+1;R>c;c++)d=a.heap[c],f=i[2*i[2*d+1]+1]+1,f>o&&(f=o,p++),i[2*d+1]=f,d>j||(a.bl_count[f]++,g=0,d>=n&&(g=m[d-n]),h=i[2*d],a.opt_len+=h*(f+g),l&&(a.static_len+=h*(k[2*d+1]+g)));if(0!==p){do{for(f=o-1;0===a.bl_count[f];)f--;a.bl_count[f]--,a.bl_count[f+1]+=2,a.bl_count[o]--,p-=2}while(p>0);for(f=o;0!==f;f--)for(d=a.bl_count[f];0!==d;)(e=a.heap[--c])>j||(i[2*e+1]!==f&&(a.opt_len+=(f-i[2*e+1])*i[2*e],i[2*e+1]=f),d--)}}function l(a,b,c){var d,e,f=new Array(S+1),g=0;for(d=1;S>=d;d++)f[d]=g=g+c[d-1]<<1;for(e=0;b>=e;e++){var h=a[2*e+1];0!==h&&(a[2*e]=i(f[h]++,h))}}function m(){var a,b,c,d,e,f=new Array(S+1);for(c=0,d=0;M-1>d;d++)for(fa[d]=c,a=0;a<1<<Z[d];a++)ea[c++]=d;for(ea[c-1]=d,e=0,d=0;16>d;d++)for(ga[d]=e,a=0;a<1<<$[d];a++)da[e++]=d;for(e>>=7;P>d;d++)for(ga[d]=e<<7,a=0;a<1<<$[d]-7;a++)da[256+e++]=d;for(b=0;S>=b;b++)f[b]=0;for(a=0;143>=a;)ba[2*a+1]=8,a++,f[8]++;for(;255>=a;)ba[2*a+1]=9,a++,f[9]++;for(;279>=a;)ba[2*a+1]=7,a++,f[7]++;for(;287>=a;)ba[2*a+1]=8,a++,f[8]++;for(l(ba,O+1,f),a=0;P>a;a++)ca[2*a+1]=5,ca[2*a]=i(a,5);ha=new ka(ba,Z,N+1,O,S),ia=new ka(ca,$,0,P,S),ja=new ka(new Array(0),_,0,Q,U)}function n(a){var b;for(b=0;O>b;b++)a.dyn_ltree[2*b]=0;for(b=0;P>b;b++)a.dyn_dtree[2*b]=0;for(b=0;Q>b;b++)a.bl_tree[2*b]=0;a.dyn_ltree[2*V]=1,a.opt_len=a.static_len=0,a.last_lit=a.matches=0}function o(a){a.bi_valid>8?f(a,a.bi_buf):a.bi_valid>0&&(a.pending_buf[a.pending++]=a.bi_buf),a.bi_buf=0,a.bi_valid=0}function p(a,b,c,d){o(a),d&&(f(a,c),f(a,~c)),E.arraySet(a.pending_buf,a.window,b,c,a.pending),a.pending+=c}function q(a,b,c,d){var e=2*b,f=2*c;return a[e]<a[f]||a[e]===a[f]&&d[b]<=d[c]}function r(a,b,c){for(var d=a.heap[c],e=c<<1;e<=a.heap_len&&(e<a.heap_len&&q(b,a.heap[e+1],a.heap[e],a.depth)&&e++,!q(b,d,a.heap[e],a.depth));)a.heap[c]=a.heap[e],c=e,e<<=1;a.heap[c]=d}function s(a,b,c){var d,f,i,j,k=0;if(0!==a.last_lit)do{d=a.pending_buf[a.d_buf+2*k]<<8|a.pending_buf[a.d_buf+2*k+1],f=a.pending_buf[a.l_buf+k],k++,0===d?h(a,f,b):(i=ea[f],h(a,i+N+1,b),j=Z[i],0!==j&&(f-=fa[i],g(a,f,j)),d--,i=e(d),h(a,i,c),0!==(j=$[i])&&(d-=ga[i],g(a,d,j)))}while(k<a.last_lit);h(a,V,b)}function t(a,b){var c,d,e,f=b.dyn_tree,g=b.stat_desc.static_tree,h=b.stat_desc.has_stree,i=b.stat_desc.elems,j=-1;for(a.heap_len=0,a.heap_max=R,c=0;i>c;c++)0!==f[2*c]?(a.heap[++a.heap_len]=j=c,a.depth[c]=0):f[2*c+1]=0;for(;a.heap_len<2;)e=a.heap[++a.heap_len]=2>j?++j:0,f[2*e]=1,a.depth[e]=0,a.opt_len--,h&&(a.static_len-=g[2*e+1]);for(b.max_code=j,c=a.heap_len>>1;c>=1;c--)r(a,f,c);e=i;do{c=a.heap[1],a.heap[1]=a.heap[a.heap_len--],r(a,f,1),d=a.heap[1],a.heap[--a.heap_max]=c,a.heap[--a.heap_max]=d,f[2*e]=f[2*c]+f[2*d],a.depth[e]=(a.depth[c]>=a.depth[d]?a.depth[c]:a.depth[d])+1,f[2*c+1]=f[2*d+1]=e,a.heap[1]=e++,r(a,f,1)}while(a.heap_len>=2);a.heap[--a.heap_max]=a.heap[1],k(a,b),l(f,j,a.bl_count)}function u(a,b,c){var d,e,f=-1,g=b[1],h=0,i=7,j=4;for(0===g&&(i=138,j=3),b[2*(c+1)+1]=65535,d=0;c>=d;d++)e=g,g=b[2*(d+1)+1],++h<i&&e===g||(j>h?a.bl_tree[2*e]+=h:0!==e?(e!==f&&a.bl_tree[2*e]++,a.bl_tree[2*W]++):10>=h?a.bl_tree[2*X]++:a.bl_tree[2*Y]++,h=0,f=e,0===g?(i=138,j=3):e===g?(i=6,
j=3):(i=7,j=4))}function v(a,b,c){var d,e,f=-1,i=b[1],j=0,k=7,l=4;for(0===i&&(k=138,l=3),d=0;c>=d;d++)if(e=i,i=b[2*(d+1)+1],!(++j<k&&e===i)){if(l>j)do{h(a,e,a.bl_tree)}while(0!=--j);else 0!==e?(e!==f&&(h(a,e,a.bl_tree),j--),h(a,W,a.bl_tree),g(a,j-3,2)):10>=j?(h(a,X,a.bl_tree),g(a,j-3,3)):(h(a,Y,a.bl_tree),g(a,j-11,7));j=0,f=e,0===i?(k=138,l=3):e===i?(k=6,l=3):(k=7,l=4)}}function w(a){var b;for(u(a,a.dyn_ltree,a.l_desc.max_code),u(a,a.dyn_dtree,a.d_desc.max_code),t(a,a.bl_desc),b=Q-1;b>=3&&0===a.bl_tree[2*aa[b]+1];b--);return a.opt_len+=3*(b+1)+5+5+4,b}function x(a,b,c,d){var e;for(g(a,b-257,5),g(a,c-1,5),g(a,d-4,4),e=0;d>e;e++)g(a,a.bl_tree[2*aa[e]+1],3);v(a,a.dyn_ltree,b-1),v(a,a.dyn_dtree,c-1)}function y(a){var b,c=4093624447;for(b=0;31>=b;b++,c>>>=1)if(1&c&&0!==a.dyn_ltree[2*b])return G;if(0!==a.dyn_ltree[18]||0!==a.dyn_ltree[20]||0!==a.dyn_ltree[26])return H;for(b=32;N>b;b++)if(0!==a.dyn_ltree[2*b])return H;return G}function z(a){ma||(m(),ma=!0),a.l_desc=new la(a.dyn_ltree,ha),a.d_desc=new la(a.dyn_dtree,ia),a.bl_desc=new la(a.bl_tree,ja),a.bi_buf=0,a.bi_valid=0,n(a)}function A(a,b,c,d){g(a,(J<<1)+(d?1:0),3),p(a,b,c,!0)}function B(a){g(a,K<<1,3),h(a,V,ba),j(a)}function C(a,b,c,d){var e,f,h=0;a.level>0?(a.strm.data_type===I&&(a.strm.data_type=y(a)),t(a,a.l_desc),t(a,a.d_desc),h=w(a),e=a.opt_len+3+7>>>3,f=a.static_len+3+7>>>3,e>=f&&(e=f)):e=f=c+5,e>=c+4&&-1!==b?A(a,b,c,d):a.strategy===F||f===e?(g(a,(K<<1)+(d?1:0),3),s(a,ba,ca)):(g(a,(L<<1)+(d?1:0),3),x(a,a.l_desc.max_code+1,a.d_desc.max_code+1,h+1),s(a,a.dyn_ltree,a.dyn_dtree)),n(a),d&&o(a)}function D(a,b,c){return a.pending_buf[a.d_buf+2*a.last_lit]=b>>>8&255,a.pending_buf[a.d_buf+2*a.last_lit+1]=255&b,a.pending_buf[a.l_buf+a.last_lit]=255&c,a.last_lit++,0===b?a.dyn_ltree[2*c]++:(a.matches++,b--,a.dyn_ltree[2*(ea[c]+N+1)]++,a.dyn_dtree[2*e(b)]++),a.last_lit===a.lit_bufsize-1}var E=a("../utils/common"),F=4,G=0,H=1,I=2,J=0,K=1,L=2,M=29,N=256,O=N+1+M,P=30,Q=19,R=2*O+1,S=15,T=16,U=7,V=256,W=16,X=17,Y=18,Z=[0,0,0,0,0,0,0,0,1,1,1,1,2,2,2,2,3,3,3,3,4,4,4,4,5,5,5,5,0],$=[0,0,0,0,1,1,2,2,3,3,4,4,5,5,6,6,7,7,8,8,9,9,10,10,11,11,12,12,13,13],_=[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,2,3,7],aa=[16,17,18,0,8,7,9,6,10,5,11,4,12,3,13,2,14,1,15],ba=new Array(2*(O+2));d(ba);var ca=new Array(2*P);d(ca);var da=new Array(512);d(da);var ea=new Array(256);d(ea);var fa=new Array(M);d(fa);var ga=new Array(P);d(ga);var ha,ia,ja,ka=function(a,b,c,d,e){this.static_tree=a,this.extra_bits=b,this.extra_base=c,this.elems=d,this.max_length=e,this.has_stree=a&&a.length},la=function(a,b){this.dyn_tree=a,this.max_code=0,this.stat_desc=b},ma=!1;c._tr_init=z,c._tr_stored_block=A,c._tr_flush_block=C,c._tr_tally=D,c._tr_align=B},{"../utils/common":27}],39:[function(a,b){"use strict";function c(){this.input=null,this.next_in=0,this.avail_in=0,this.total_in=0,this.output=null,this.next_out=0,this.avail_out=0,this.total_out=0,this.msg="",this.state=null,this.data_type=2,this.adler=0}b.exports=c},{}]},{},[9])(9)}),wmsx.EmbeddedFiles={get:function(a){if(a.indexOf("|")<0)return this.getFile(a);for(var b=a.split(/\s*\|\s*/),c=new Array(b.length),d=0;d<b.length;++d){var e=this.getFile(b[d]);if(void 0===e)return;c[d]=e.content}return{name:a,content:wmsx.Util.arraysConcatAll(c)}},getFile:function(a){a=a.substr(1);var b=this.compressedContent[a];if(void 0!==b)return{name:a,content:wmsx.Util.uncompressStringBase64ToInt8BitArray(b)};var c=this.diffsContent[a];if(void 0!==c){var d=this.getFile(c.based);if(void 0!==d){var e=d.content;for(var f in c.diffs)for(var g=c.diffs[f],h=0;h<g.length;++h)e[(0|f)+h]=g[h];return{name:a,content:e}}}},embedFileCompressedContent:function(a,b){this.compressedContent[a]=b},embedFileDiff:function(a,b){this.diffsContent[a]=b},isEmbeddedURL:function(a){return a&&"@"===a[0]},compressedContent:{},diffsContent:{}},wmsx.MultiDownloader=function(a,b,c,d){"use strict";function e(a){if(a){var b=a.url.trim();if(!b)return i(a,"Empty URL");var c=wmsx.EmbeddedFiles.isEmbeddedURL(b)?[b]:b.split(/\s*\|\s*/);a.filesToLoad=c.length,a.filesContent=new Array(a.filesToLoad);for(var d=0;d<c.length;++d){var e=c[d];wmsx.EmbeddedFiles.isEmbeddedURL(e)?f(a,d,e):g(a,d,e)}}}function f(a,b,c){var d=wmsx.EmbeddedFiles.get(c);void 0!==d?h(a,b,d.content):i(a,"Embedded file not found!")}function g(a,b,c){var e=k(c)?l(c):c,f=new XMLHttpRequest;f.open("GET",e,!0),f.responseType="arraybuffer",f.timeout=void 0!==d?d:s,f.onload=function(){200!==f.status&&0!==f.status||!f.response?f.onerror():h(a,b,new Uint8Array(f.response))},f.onerror=f.ontimeout=function(){i(a,f.status+" "+f.statusText)},wmsx.Util.log("Reading file from: "+c),f.send()}function h(a,b,c){a.filesContent[b]=c,--a.filesToLoad>0||(a.success=!0,a.content=wmsx.Util.arraysConcatAll(a.filesContent),a.onSuccess&&a.onSuccess(a),j())}function i(a,b){var d="Could not load file: "+a.url+"\nError: "+b;a.success=!1,a.error=b,a.errorMessage=d,a.onError?(wmsx.Util.error(d),a.onError(a)):c||wmsx.Util.message(d),j()}function j(){if(!q){for(var d=0;d<a.length;d++)if(a[d]&&void 0===a[d].success)return;for(q=!0,n(),d=0;d<a.length;d++)if(a[d]&&!a[d].success)return void(c&&c(a[d]));b&&b(a)}}function k(a){return a&&(0===a.indexOf("http:")||0===a.indexOf("https:"))}function l(a){return WMSX.PROXY_SERVER_ADDRESS?"https://"+WMSX.PROXY_SERVER_ADDRESS+"/proxy-remote-download?url="+a:a}function m(){WMSX.room&&!WMSX.room.isLoading&&(p=window.setTimeout(function(){p=null,o=!0,WMSX.room.setLoading(!0)},r))}function n(){p&&(window.clearTimeout(p),p=null),o&&(o=!1,WMSX.room.setLoading(!1))}this.start=function(){if(a&&0!==a.length){m();for(var b=0;b<a.length;b++)e(a[b])}j()};var o=!1,p=null,q=!1,r=100,s=15e3},wmsx.MultiFileReader=function(a,b,c,d){"use strict";function e(a){if(a){wmsx.Util.log("Reading file: "+a.name);var b=new FileReader;b.onload=function(b){a.wmsxSuccess=!0,a.content=new Uint8Array(b.target.result),f()},b.onerror=function(b){a.wmsxSuccess=!1,a.wmsxError=b.target.error.name,console.log("ERROR:",a.name,a.wmsxError),f()},b.readAsArrayBuffer(a)}}function f(){if(!h){for(var a=0;a<g.length;a++)if(g[a]&&void 0===g[a].wmsxSuccess)return;for(h=!0,a=0;a<g.length;a++)if(g[a]&&!g[a].wmsxSuccess)return c&&c(g,g[a].wmsxError),g;b&&b(g)}}this.start=function(){if(a&&0!==a.length){for(var c=0;c<a.length;c++)g.push(a[c]);for(var d=0;d<g.length;d++)e(g[d]);f()}else b(a)};var g=[],h=!1},wmsx.CPU=function(){"use strict";function init(){defineZ80InstructionSet()}function updateR800Present(){r800Present?(defineR800InstructionSet(),self.busClockPulses=self.busClockPulsesBoth):self.busClockPulses=self.busClockPulsesZ80}function updateInstructionSet(){r800?(instructionsNoPrefix=instructionsNoPrefixR800,instructionsByPrefix=instructionsByPrefixR800):(instructionsNoPrefix=instructionsNoPrefixZ80,instructionsByPrefix=instructionsByPrefixZ80)}function defineZ80InstructionSet(){instructionsNoPrefixZ80[0]||defineInstructionSet(instructionsByPrefixZ80,!1,!1)}function defineR800InstructionSet(){instructionsNoPrefixR800[0]||defineInstructionSet(instructionsByPrefixR800,!0,!0)}function updateClockMulti(){self.getBUSCycles(),clockMulti=r800?r800ClockMulti:z80ClockMulti}function setINT(a){INT!==a&&(INT=a,ackINT=255!==a&&IFF1&&0===prefix)}function fetchNextInstruction(){++R,opcode=r800?fetchN_R800():fetchN(),selectInstruction(),T=instruction.remainCycles}function acknowledgeINT(){++R,IFF1=0,ackINT=!1,instruction.operation===HALT&&pcInc(),instruction=IM<2?instructionsNoPrefix[258]:instructionsNoPrefix[259],T=instruction.remainCycles}function selectInstruction(){0===prefix?instruction=instructionsNoPrefix[opcode]:(instruction=instructionsByPrefix[prefix][opcode]||instructionsNoPrefix[opcode],255!==INT&&IFF1&&(ackINT=!0),prefix=0)}function swapModeState(){writeState(modeFrontState);var a=modeBackState;modeBackState=modeFrontState,modeFrontState=a,readState(modeFrontState)}function writeState(a){a.ackINT=ackINT,a.prefix=prefix,a.T=T,a.W=W,a.opcode=opcode,
a.PC=PC,a.SP=SP,a.I=I,a.R=R,a.IFF1=IFF1,a.IM=IM,a.AF=fromAF(),a.BC=fromBC(),a.DE=DE,a.HL=HL,a.IX=fromIX(),a.IY=fromIY(),a.AF2=AF2,a.BC2=BC2,a.DE2=DE2,a.HL2=HL2,a.extCurrRunning=extCurrRunning,a.extExtraIters=extExtraIter}function readState(a){ackINT=a.ackINT,prefix=a.prefix,T=a.T,W=a.W,opcode=a.opcode,instruction=instrWait,PC=a.PC,SP=a.SP,I=a.I,R=a.R,IFF1=a.IFF1,IM=a.IM,toAF(a.AF),toBC(a.BC),DE=a.DE,HL=a.HL,toIX(a.IX),toIY(a.IY),AF2=a.AF2,BC2=a.BC2,DE2=a.DE2,HL2=a.HL2,extCurrRunning=a.extCurrRunning,extExtraIter=a.extExtraIters}function fetchForceNextBreak(){fetchLastAddress=131071}function busRead(a){return bus.read(a)}function busWrite(a,b){bus.write(a,b)}function fetchN(){return busRead(pcInc())}function fetchNN(){return fetchN()|fetchN()<<8}function memRead(a){return busRead(a)}function memRead16(a){return busRead(a)|busRead(a+1&65535)<<8}function memWrite(a,b){busWrite(a,b)}function memWrite16(a,b){busWrite(a,255&b),busWrite(a+1&65535,b>>>8)}function memWrite16Rev(a,b){busWrite(a+1&65535,b>>>8),busWrite(a,255&b)}function busInput(a){return bus.input(a)}function busOutput(a,b){bus.output(a,b)}function busRead_R800(a){return W+=bus.getAccessWait(a),bus.read(a)}function busWrite_R800(a,b){W+=bus.getAccessWait(a),bus.write(a,b)}function fetchN_R800(){var a=pcInc();return W+=bus.getBreakWait(a,fetchLastAddress),fetchLastAddress=a,busRead_R800(a)}function fetchNN_R800(){return fetchN_R800()|fetchN_R800()<<8}function memRead_R800(a){return fetchForceNextBreak(),busRead_R800(a)}function memRead16_R800(a){return W+=bus.getBreakWait(a,a+1),fetchForceNextBreak(),busRead_R800(a)|busRead_R800(a+1&65535)<<8}function memWrite_R800(a,b){fetchForceNextBreak(),busWrite_R800(a,b)}function memWrite16_R800(a,b){W+=bus.getBreakWait(a,a+1),fetchForceNextBreak(),busWrite_R800(a,255&b),busWrite_R800(a+1&65535,b>>>8)}function memWrite16Rev_R800(a,b){W+=bus.getBreakWait(a,a+1),fetchForceNextBreak(),busWrite_R800(a+1&65535,b>>>8),busWrite_R800(a,255&b)}function busInput_R800(a){return W+=bus.getIOWait(a,clockMulti),bus.input(a)}function busOutput_R800(a,b){W+=bus.getIOWait(a,clockMulti),bus.output(a,b)}function pcInc(){var a=PC;return PC=PC+1&65535,a}function dec2PC(){return PC=PC-2&65535}function fromA(){return A}function fromB(){return B}function fromC(){return C}function fromD(){return DE>>>8}function fromE(){return 255&DE}function fromH(){return HL>>>8}function fromL(){return 255&HL}function fromIXh(){return IX>>>8}function fromIXl(){return 255&IX}function fromIYh(){return IY>>>8}function fromIYl(){return 255&IY}function toA(a){A=a}function toB(a){B=a}function toC(a){C=a}function toD(a){DE=255&DE|a<<8}function toE(a){DE=65280&DE|a}function toH(a){HL=255&HL|a<<8}function toL(a){HL=65280&HL|a}function toIXh(a){IX=255&IX|a<<8}function toIXl(a){IX=65280&IX|a}function toIYh(a){IY=255&IY|a<<8}function toIYl(a){IY=65280&IY|a}function fromAF(){return A<<8|F}function fromBC(){return B<<8|C}function fromDE(){return DE}function fromHL(){return HL}function fromSP(){return SP}function fromIX(){return IX}function fromIY(){return IY}function toAF(a){A=a>>>8,F=255&a}function toBC(a){B=a>>>8,C=255&a}function toDE(a){DE=a}function toHL(a){HL=a}function toSP(a){SP=a}function toIX(a){IX=a}function toIY(a){IY=a}function from_BC_8(){return memRead(fromBC())}function from_BC_8_R800(){return memRead_R800(fromBC())}function from_DE_8(){return memRead(DE)}function from_DE_8_R800(){return memRead_R800(DE)}function from_HL_8(){return memRead(HL)}function from_HL_8_R800(){return memRead_R800(HL)}function from_SP_16(){return memRead16(SP)}function from_SP_16_R800(){return memRead16_R800(SP)}function to_BC_8(a){memWrite(fromBC(),a)}function to_BC_8_R800(a){memWrite_R800(fromBC(),a)}function to_DE_8(a){memWrite(DE,a)}function to_DE_8_R800(a){memWrite_R800(DE,a)}function to_HL_8(a){memWrite(HL,a)}function to_HL_8_R800(a){memWrite_R800(HL,a)}function to_SP_16(a){memWrite16(SP,a)}function to_SP_16_R800(a){memWrite16_R800(SP,a)}function preReadIXYd(){preReadIXYdOffset=fetchN()}function preReadIXYd_R800(){preReadIXYdOffset=fetchN_R800()}function from_IXd_8(){return memRead(sum16Signed(IX,fetchN()))}function from_IXd_8_R800(){return memRead_R800(sum16Signed(IX,fetchN_R800()))}function from_IYd_8(){return memRead(sum16Signed(IY,fetchN()))}function from_IYd_8_R800(){return memRead_R800(sum16Signed(IY,fetchN_R800()))}function to_IXd_8(a){memWrite(sum16Signed(IX,fetchN()),a)}function to_IXd_8_R800(a){memWrite_R800(sum16Signed(IX,fetchN_R800()),a)}function to_IYd_8(a){memWrite(sum16Signed(IY,fetchN()),a)}function to_IYd_8_R800(a){memWrite_R800(sum16Signed(IY,fetchN_R800()),a)}function from_NN_8(){return memRead(fetchNN())}function from_NN_8_R800(){return memRead_R800(fetchNN_R800())}function to_NN_8(a){memWrite(fetchNN(),a)}function to_NN_8_R800(a){memWrite_R800(fetchNN_R800(),a)}function from_NN_16(){return memRead16(fetchNN())}function from_NN_16_R800(){return memRead16_R800(fetchNN_R800())}function to_NN_16(a){memWrite16(fetchNN(),a)}function to_NN_16_R800(a){memWrite16_R800(fetchNN_R800(),a)}function push16(a){SP=SP-2&65535,memWrite16Rev(SP,a)}function push16_R800(a){SP=SP-2&65535,memWrite16Rev_R800(SP,a)}function pop16(){var a=memRead16(SP);return SP=SP+2&65535,a}function pop16_R800(){var a=memRead16_R800(SP);return SP=SP+2&65535,a}function sum16Signed(a,b){return a+(b>127?-256+b:b)&65535}function NOP(){}function HALT(){--PC}function newLD(a,b){return function(){a(b())}}function LDAI(){A=I,F=1&F|168&A|(0===A)<<nZ|IFF1<<nPV}function LDAR(){A=R7|127&R,F=1&F|168&A|(0===A)<<nZ|IFF1<<nPV}function LDIA(){I=A}function LDRA(){R=A,R7=128&A}function newPUSH(a,b){return b?function(){push16_R800(a())}:function(){push16(a())}}function newPOP(a,b){return b?function(){a(pop16_R800())}:function(){a(pop16())}}function EXDEHL(){var a=DE;DE=HL,HL=a}function EXX(){var a=fromBC();toBC(BC2),BC2=a,a=DE,DE=DE2,DE2=a,a=HL,HL=HL2,HL2=a}function EXAFAF2(){var a=fromAF();toAF(AF2),AF2=a}function newLDI(a){var b=a?from_HL_8_R800:from_HL_8,c=a?to_DE_8_R800:to_DE_8;return function(){c(b()),DE=DE+1&65535,HL=HL+1&65535,--C<0&&(C=255,B=B-1&255),F=193&F|(B+C!==0)<<nPV}}function newLDIR(a,b){var c=b?1:5;return function(){a(),F&bPV&&(dec2PC(),T+=c,instruction=instrWait)}}function newLDD(a){var b=a?from_HL_8_R800:from_HL_8,c=a?to_DE_8_R800:to_DE_8;return function(){c(b()),DE=DE-1&65535,HL=HL-1&65535,--C<0&&(C=255,B=B-1&255),F=193&F|(B+C!==0)<<nPV}}function newLDDR(a,b){var c=b?1:5;return function(){a(),F&bPV&&(dec2PC(),T+=c,instruction=instrWait)}}function newCPI(a){var b=a?from_HL_8_R800:from_HL_8;return function(){var a=b();--C<0&&(C=255,B=B-1&255),HL=HL+1&65535;var c=A-a;F=F&bC|bN|168&c|(0===c)<<nZ|(A^a^c)&bH|(B+C!==0)<<nPV}}function newCPIR(a,b){var c=b?1:5;return function(){a(),F&bPV&&!(F&bZ)&&(dec2PC(),T+=c,instruction=instrWait)}}function newCPD(a){var b=a?from_HL_8_R800:from_HL_8;return function(){var a=b();--C<0&&(C=255,B=B-1&255),HL=HL-1&65535;var c=A-a;F=F&bC|bN|168&c|(0===c)<<nZ|(A^a^c)&bH|(B+C!==0)<<nPV}}function newCPDR(a,b){var c=b?1:5;return function(){a(),F&bPV&&!(F&bZ)&&(dec2PC(),T+=c,instruction=instrWait)}}function DAA(){var a=A;F&bN?((F&bH||(15&A)>9)&&(a-=6),(F&bC||A>153)&&(a-=96)):((F&bH||(15&A)>9)&&(a+=6),(F&bC||A>153)&&(a+=96)),a&=255,F=3&F|168&a|(0===a)<<nZ|(A^a)&bH|parities[a]|A>153,A=a}function CPL(){A=255&~A,F=197&F|18|40&A}function NEG(){var a=A;A=255&-A,F=bN|168&A|(0===A)<<nZ|(0!=(15&a))<<nH|(128===a)<<nPV|0!==a}function CCF(){F=196&F|40&A|(F&bC)<<nH|~F&bC}function SCF(){F=196&F|bC}function DI(){IFF1=0,ackINT=!1}function EI(){IFF1=1,prefix=7,ackINT=!1}function RLCA(){A=255&(A<<1|A>>>7),F=196&F|40&A|A&bC}function RLA(){var a=A;A=255&(A<<1|F&bC),F=196&F|40&A|a>>>7&bC}function RRCA(){A=255&(A>>>1|A<<7),F=196&F|40&A|A>>>7}function RRA(){var a=A;A=A>>>1|(F&bC)<<7,F=196&F|40&A|a&bC}function newRLD(a){var b=a?from_HL_8_R800:from_HL_8,c=a?to_HL_8_R800:to_HL_8;return function(){var a=b();c(255&(a<<4|15&A)),A=240&A|a>>>4,
F=F&bC|168&A|(0===A)<<nZ|parities[A]}}function newRRD(a){var b=a?from_HL_8_R800:from_HL_8,c=a?to_HL_8_R800:to_HL_8;return function(){var a=b();c(255&(A<<4|a>>>4)),A=240&A|15&a,F=F&bC|168&A|(0===A)<<nZ|parities[A]}}function JR(){var a=fetchN();PC=sum16Signed(PC,a)}function JR_R800(){var a=fetchN_R800();PC=sum16Signed(PC,a)}function DJNZ(){var a=fetchN();0!==(B=B-1&255)&&(PC=sum16Signed(PC,a),T+=5,instruction=instrWait)}function DJNZ_R800(){var a=fetchN_R800();0!==(B=B-1&255)&&(PC=sum16Signed(PC,a),T+=1,instruction=instrWait)}function CALL(){var a=fetchNN();push16(PC),PC=a}function CALL_R800(){var a=fetchNN_R800();push16_R800(PC),PC=a}function RET(){PC=pop16()}function RET_R800(){PC=pop16_R800()}function INAn(){var a=fetchN();A=busInput(A<<8|a)}function INAn_R800(){var a=fetchN_R800();A=busInput_R800(A<<8|a)}function newINI(a){var b=a?to_HL_8_R800:to_HL_8,c=a?busInput_R800:busInput;return function(){b(c(fromBC())),HL=HL+1&65535,B=B-1&255,F=F&bC|bN|(0===B)<<nZ}}function newINIR(a,b){var c=b?1:5;return function(){a(),0!==B&&(dec2PC(),T+=c,instruction=instrWait)}}function newIND(a){var b=a?to_HL_8_R800:to_HL_8,c=a?busInput_R800:busInput;return function(){b(c(fromBC())),HL=HL-1&65535,B=B-1&255,F=F&bC|bN|(0===B)<<nZ}}function newINDR(a,b){var c=b?1:5;return function(){a(),0!==B&&(dec2PC(),T+=c,instruction=instrWait)}}function OUTnA(){var a=fetchN();busOutput(A<<8|a,A)}function OUTnA_R800(){var a=fetchN_R800();busOutput_R800(A<<8|a,A)}function newOUTI(a){var b=a?from_HL_8_R800:from_HL_8,c=a?busOutput_R800:busOutput;return function(){var a=b();B=B-1&255,HL=HL+1&65535,F=F&bC|bN|(0===B)<<nZ,c(fromBC(),a)}}function newOTIR(a,b){var c=b?1:5;return function(){1!==B&&(dec2PC(),T+=c,instruction=instrWait),a()}}function newOUTD(a){var b=a?from_HL_8_R800:from_HL_8,c=a?busOutput_R800:busOutput;return function(){var a=b();B=B-1&255,HL=HL-1&65535,F=F&bC|bN|(0===B)<<nZ,c(fromBC(),a)}}function newOTDR(a,b){var c=b?1:5;return function(){1!==B&&(dec2PC(),T+=c,instruction=instrWait),a()}}function newLD_PreRead_IXYd_(a,b,c){var d=c?preReadIXYd_R800:preReadIXYd;return function(){d(),a(b())}}function newEXr_SP_16(a,b,c){var d=c?from_SP_16_R800:from_SP_16,e=c?to_SP_16_R800:to_SP_16;return function(){var c=d();e(b()),a(c)}}function newADD(a){return function(){var b=a(),c=A+b,d=A^b^c;A=255&c,F=168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newADC(a){return function(){var b=a(),c=A+b+(F&bC),d=A^b^c;A=255&c,F=168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newSUB(a){return function(){var b=a(),c=A-b,d=A^b^c;A=255&c,F=bN|168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newSBC(a){return function(){var b=a(),c=A-b-(F&bC),d=A^b^c;A=255&c,F=bN|168&A|(0===A)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newAND(a){return function(){A&=a(),F=bH|168&A|(0===A)<<nZ|parities[A]}}function newOR(a){return function(){A|=a(),F=168&A|(0===A)<<nZ|parities[A]}}function newXOR(a){return function(){A^=a(),F=168&A|(0===A)<<nZ|parities[A]}}function newCP(a){return function(){var b=a(),c=A-b,d=A^b^c;F=bN|c&bS|40&b|(0===c)<<nZ|d&bH|(d>>>6^d>>>5)&bPV|c>>>8&bC}}function newINC(a,b){return function(){var c=a()+1&255;b(c),F=F&bC|168&c|(0===c)<<nZ|(0==(15&c))<<nH|(128===c)<<nPV}}function newINC_PreRead_IXYd_(a,b,c){var d=c?preReadIXYd_R800:preReadIXYd;return function(){d();var c=a()+1&255;b(c),F=F&bC|168&c|(0===c)<<nZ|(0==(15&c))<<nH|(128===c)<<nPV}}function newDEC(a,b){return function(){var c=a()-1&255;b(c),F=F&bC|bN|168&c|(0===c)<<nZ|(15==(15&c))<<nH|(127===c)<<nPV}}function newDEC_PreRead_IXYd_(a,b,c){var d=c?preReadIXYd_R800:preReadIXYd;return function(){d();var c=a()-1&255;b(c),F=F&bC|bN|168&c|(0===c)<<nZ|(15==(15&c))<<nH|(127===c)<<nPV}}function newIM(a){return function(){IM=a}}function newADD16(a,b,c){return function(){var d=b(),e=c(),f=d+e;a(65535&f),F=196&F|f>>>8&40|(d^e^f)>>>8&bH|f>>>16&bC}}function newADC16(a,b,c){return function(){var d=b(),e=c(),f=d+e+(F&bC);a(65535&f);var g=(d^e^f)>>>8;F=f>>>8&168|(0==(65535&f))<<nZ|g&bH|(g>>>6^g>>>5)&bPV|f>>>16&bC}}function newSBC16(a,b,c){return function(){var d=b(),e=c(),f=d-e-(F&bC);a(65535&f);var g=(d^e^f)>>>8;F=bN|f>>>8&168|(0==(65535&f))<<nZ|g&bH|(g>>>6^g>>>5)&bPV|f>>>16&bC}}function newINC16(a,b){return function(){a(b()+1&65535)}}function newDEC16(a,b){return function(){a(b()-1&65535)}}function newRLC(a,b,c){return function(){var d=b(),e=255&(d<<1|d>>>7);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|e&bC}}function newRL(a,b,c){return function(){var d=b(),e=255&(d<<1|F&bC);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d>>>7&bC}}function newRRC(a,b,c){return function(){var d=b(),e=255&(d>>>1|d<<7);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newRR(a,b,c){return function(){var d=b(),e=255&(d>>>1|(F&bC)<<7);a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newSLA(a,b,c){return function(){var d=b(),e=d<<1&255;a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d>>>7&bC}}function newSRA(a,b,c){return function(){var d=b(),e=d>>>1|128&d;a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newSLL(a,b,c,d){var e=d?0:1;return function(){var d=b(),f=255&(d<<1|e);a(f),c&&c(f),F=168&f|(0===f)<<nZ|parities[f]|d>>>7&bC}}function newSRL(a,b,c){return function(){var d=b(),e=d>>>1;a(e),c&&c(e),F=168&e|(0===e)<<nZ|parities[e]|d&bC}}function newBIT(a,b,c,d){return function(){var a=b()&1<<c;a?(F=F&bC|bH|a&bS,d&&(F|=40&a)):F=F&bC|84}}function newSET(a,b,c,d){return function(){var e=b()|1<<c;a(e),d&&d(e)}}function newRES(a,b,c,d){return function(){var e=b()&~(1<<c);a(e),d&&d(e)}}function newJP(a,b){return b?function(){PC=a(),fetchForceNextBreak()}:function(){PC=a()}}function newJPcc(a,b,c){return c?function(){var c=fetchNN_R800();(F&a)===b&&(PC=c,++W,fetchForceNextBreak())}:function(){var c=fetchNN();(F&a)===b&&(PC=c)}}function newJRcc(a,b,c){return c?function(){var c=fetchN_R800();(F&a)===b&&(PC=sum16Signed(PC,c),W+=1)}:function(){var c=fetchN();(F&a)===b&&(PC=sum16Signed(PC,c),T+=5,instruction=instrWait)}}function newCALLcc(a,b,c,d){var e=c?fetchNN_R800:fetchNN,f=c?push16_R800:push16,g=d?3+bw:7;return function(){var c=e();(F&a)===b&&(f(PC),PC=c,T+=g,instruction=instrWait)}}function newRETcc(a,b,c){return c?function(){(F&a)===b&&(RET_R800(),T+=2+br,instruction=instrWait)}:function(){(F&a)===b&&(RET(),T+=6,instruction=instrWait)}}function newRST(a,b){return b?function(){push16_R800(PC),PC=a}:function(){push16(PC),PC=a}}function newINrC(a,b){var c=b?busInput_R800:busInput;return function(){var b=c(fromBC());a(b),F=F&bC|168&b|(0===b)<<nZ|parities[b]}}function newOUTCr(a,b){var c=b?busOutput_R800:busOutput;return function(){c(fromBC(),a())}}function newMULUB(a){return function(){var b=A*a();HL=b,F=18&F|40&b|(0===b)<<nZ|b>255}}function newMULUW(a){return function(){var b=HL*a();DE=b>>>16,HL=65535&b,F=18&F|40&b|(0===b)<<nZ|b>65535}}function uNOP(){}function uIN_C(){var a=busInput(fromBC());F=F&bC|168&a|(0===a)<<nZ|parities[a]}function uIN_C_R800(){var a=busInput_R800(fromBC());F=F&bC|168&a|(0===a)<<nZ|parities[a]}function uOUTC0(){busOutput(fromBC(),0)}function uOUTC0_R800(){busOutput_R800(fromBC(),0)}function pINT_IM01(){push16(PC),PC=56}function pINT_IM01_R800(){push16_R800(PC),PC=56}function pINT_IM2(){push16(PC),PC=memRead16(I<<8|255)}function pINT_IM2_R800(){push16_R800(PC),PC=memRead16_R800(I<<8|255)}function pSET_CB(){prefix=2,ackINT=!1}function pSET_ED(){prefix=1,ackINT=!1}function pSET_DD(){prefix=3,ackINT=!1}function pSET_FD(){prefix=4,ackINT=!1}function newpSET_DDCB(a){var b=a?preReadIXYd_R800:preReadIXYd;return function(){prefix=5,ackINT=!1,b(),--R}}function newpSET_FDCB(a){var b=a?preReadIXYd_R800:preReadIXYd;return function(){prefix=6,ackINT=!1,b(),--R}}function newpEXT(a){function b(a){return{extNum:a,extPC:PC-2,PC:PC,SP:SP,A:A,F:F,B:B,C:C,DE:DE,HL:HL,IX:IX,IY:IY,AF2:AF2,BC2:BC2,DE2:DE2,HL2:HL2}}function c(a){a&&(void 0!==a.PC&&(PC=a.PC),void 0!==a.SP&&(SP=a.SP),void 0!==a.A&&(A=a.A),void 0!==a.F&&(F=a.F),
void 0!==a.B&&(B=a.B),void 0!==a.C&&(C=a.C),void 0!==a.DE&&(DE=a.DE),void 0!==a.HL&&(HL=a.HL),void 0!==a.IX&&(IX=a.IX),void 0!==a.IY&&(IY=a.IY),void 0!==a.AF2&&(AF2=a.AF2),void 0!==a.BC2&&(BC2=a.BC2),void 0!==a.DE2&&(DE2=a.DE2),void 0!==a.HL2&&(HL2=a.HL2),a.extraIterations>0&&(extExtraIter=a.extraIterations))}return function d(){if(null===extCurrRunning){extCurrRunning=a,extExtraIter=0;c(bus.cpuExtensionBegin(b(a))),d()}else if(extExtraIter>0)--extExtraIter,dec2PC();else{var e=bus.cpuExtensionFinish(b(a));c(e),extCurrRunning=null}}}function defineInstructionSet(a,b,c){function d(a,b,d,f,g,h,i,j){var k={};return k.prefix=b?a<<8|b:a,k.opcode=d,k.remainCyclesZ80=f+1,k.remainCyclesR800=g,k.totalCyclesZ80=k.remainCyclesZ80+(a?5:0)+(b?4:0),k.totalCyclesR800=k.remainCyclesR800+(a?1:0)+(b?1:0),k.remainCycles=c?k.remainCyclesR800-1:k.remainCyclesZ80-1,k.operation=h,k.mnemonic=i,k.undocumented=j,k.opcodeString=(k.prefix?wmsx.Util.toHex2(k.prefix):"")+(56779===k.prefix||64971===k.prefix?" ":"")+wmsx.Util.toHex2(k.opcode)+" "+i+(j?"*":""),k.toString=function(){return this.opcodeString},e(k),k}function e(b){if(instructionsAllOld.push(b),b.prefix)if(237===b.prefix)a[1][b.opcode]=b;else if(203===b.prefix)a[2][b.opcode]=b;else if(221===b.prefix)a[3][b.opcode]=b;else if(253===b.prefix)a[4][b.opcode]=b;else if(56779===b.prefix)a[5][b.opcode]=b;else{if(64971!==b.prefix)throw new Error("Invalid instruction prefix!");a[6][b.opcode]=b}else a[0][b.opcode]=b}var f,g,h=0,i=0,j={A:{bits:7,to:toA,from:fromA,desc:"A"},B:{bits:0,to:toB,from:fromB,desc:"B"},C:{bits:1,to:toC,from:fromC,desc:"C"},D:{bits:2,to:toD,from:fromD,desc:"D"},E:{bits:3,to:toE,from:fromE,desc:"E"},H:{bits:4,to:toH,from:fromH,desc:"H"},L:{bits:5,to:toL,from:fromL,desc:"L"}},k={A:{bits:7,to:toA,from:fromA,desc:"A"},B:{bits:0,to:toB,from:fromB,desc:"B"},C:{bits:1,to:toC,from:fromC,desc:"C"},D:{bits:2,to:toD,from:fromD,desc:"D"},E:{bits:3,to:toE,from:fromE,desc:"E"},H:{bits:4,to:toH,from:fromH,desc:"H",nopref:!0},L:{bits:5,to:toL,from:fromL,desc:"L",nopref:!0},IXh:{bits:4,to:toIXh,from:fromIXh,desc:"IXh",pref:221},IXl:{bits:5,to:toIXl,from:fromIXl,desc:"IXl",pref:221},IYh:{bits:4,to:toIYh,from:fromIYh,desc:"IYh",pref:253},IYl:{bits:5,to:toIYl,from:fromIYl,desc:"IYl",pref:253}},l={_HL_:{to:b?to_HL_8_R800:to_HL_8,from:b?from_HL_8_R800:from_HL_8,desc:"(HL)"},_IXd_:{to:b?to_IXd_8_R800:to_IXd_8,from:b?from_IXd_8_R800:from_IXd_8,desc:"(IX+d)",pref:221},_IYd_:{to:b?to_IYd_8_R800:to_IYd_8,from:b?from_IYd_8_R800:from_IYd_8,desc:"(IY+d)",pref:253}},m=64;for(g in k){var n=k[g];for(f in k){var o=k[f];if(!(n.pref&&(o.nopref||o.pref&&o.pref!=n.pref)||o.pref&&(n.nopref||n.pref&&n.pref!=o.pref))){var p=m|n.bits<<3|o.bits,q=newLD(n.to,o.from),r=n.pref|o.pref;d(r,null,p,4,1,q,"LD "+n.desc+", "+o.desc,r)}}}m=6;for(g in k)n=k[g],p=m|n.bits<<3,q=newLD(n.to,b?fetchN_R800:fetchN),r=n.pref,d(r,null,p,7,2,q,"LD "+n.desc+", n",r);m=70;for(g in j){n=j[g];for(f in l)o=l[f],p=m|n.bits<<3,q=newLD(n.to,o.from),r=o.pref,d(r,null,p,7+(r?8:0),2+br+(r?2:0),q,"LD "+n.desc+", "+o.desc,!1)}m=112;for(g in l){n=l[g];for(f in j)o=j[f],p=m|o.bits,q=newLD(n.to,o.from),r=n.pref,d(r,null,p,7+(r?8:0),2+bw+(r?2:0),q,"LD "+n.desc+", "+o.desc,!1)}m=54;for(g in l)n=l[g],p=m,r=n.pref,q=r?newLD_PreRead_IXYd_(n.to.toPreReadAddr,b?fetchN_R800:fetchN,b):newLD(n.to,b?fetchN_R800:fetchN),d(r,null,p,10+(r?5:0),3+bw+(r?1:0),q,"LD "+n.desc+", n",!1);p=10,q=newLD(toA,b?from_BC_8_R800:from_BC_8),d(null,null,p,7,2+br,q,"LD A, (BC)",!1),p=26,q=newLD(toA,b?from_DE_8_R800:from_DE_8),d(null,null,p,7,2+br,q,"LD A, (DE)",!1),p=58,q=newLD(toA,b?from_NN_8_R800:from_NN_8),d(null,null,p,13,4+br,q,"LD A, (nn)",!1),p=2,q=newLD(b?to_BC_8_R800:to_BC_8,fromA),d(null,null,p,7,2+bw,q,"LD (BC), A",!1),p=18,q=newLD(b?to_DE_8_R800:to_DE_8,fromA),d(null,null,p,7,2+bw,q,"LD (DE), A",!1),p=50,q=newLD(b?to_NN_8_R800:to_NN_8,fromA),d(null,null,p,13,4+bw,q,"LD (nn), A",!1),p=87,q=LDAI,d(null,237,p,5,2,q,"LD A, I",!1),p=95,q=LDAR,d(null,237,p,5,2,q,"LD A, R",!1),p=71,q=LDIA,d(null,237,p,5,2,q,"LD I, A",!1),p=79,q=LDRA,d(null,237,p,5,2,q,"LD R, A",!1);var s={BC:{bits:0,to:toBC,from:fromBC,desc:"BC"},DE:{bits:1,to:toDE,from:fromDE,desc:"DE"},HL:{bits:2,to:toHL,from:fromHL,desc:"HL"},SP:{bits:3,to:toSP,from:fromSP,desc:"SP"}},t={BC:{bits:0,to:toBC,from:fromBC,desc:"BC"},DE:{bits:1,to:toDE,from:fromDE,desc:"DE"},HL:{bits:2,to:toHL,from:fromHL,desc:"HL",nopref:!0},SP:{bits:3,to:toSP,from:fromSP,desc:"SP"},IX:{bits:2,to:toIX,from:fromIX,desc:"IX",pref:221},IY:{bits:2,to:toIY,from:fromIY,desc:"IY",pref:253}},u={BC:{bits:0,to:toBC,from:fromBC,desc:"BC"},DE:{bits:1,to:toDE,from:fromDE,desc:"DE"},HL:{bits:2,to:toHL,from:fromHL,desc:"HL"},AF:{bits:3,to:toAF,from:fromAF,desc:"AF"},IX:{bits:2,to:toIX,from:fromIX,desc:"IX",pref:221},IY:{bits:2,to:toIY,from:fromIY,desc:"IY",pref:253}},v={HL:{to:toHL,from:fromHL,desc:"HL",nopref:!0},IXd:{to:toIX,from:fromIX,desc:"IX",pref:221},IYd:{to:toIY,from:fromIY,desc:"IY",pref:253}};m=1;for(g in t)n=t[g],p=m|n.bits<<4,q=newLD(n.to,b?fetchNN_R800:fetchNN),r=n.pref,d(r,null,p,10,3,q,"LD "+n.desc+", nn",!1);p=42;for(g in v)n=v[g],q=newLD(n.to,b?from_NN_16_R800:from_NN_16),r=n.pref,d(r,null,p,16,5+br,q,"LD "+n.desc+", (nn)",!1);m=75;for(g in s)n=s[g],p=m|n.bits<<4,q=newLD(n.to,b?from_NN_16_R800:from_NN_16),d(null,237,p,16,5+br,q,"LD "+n.desc+", (nn)",!1);p=34;for(f in v)o=v[f],q=newLD(b?to_NN_16_R800:to_NN_16,o.from),r=o.pref,d(r,null,p,16,5+bw,q,"LD (nn), "+o.desc,!1);m=67;for(f in s)o=s[f],p=m|o.bits<<4,q=newLD(b?to_NN_16_R800:to_NN_16,o.from),d(null,237,p,16,5+bw,q,"LD (nn), "+o.desc,!1);p=249;for(f in v)o=v[f],q=newLD(toSP,o.from),r=o.pref,d(r,null,p,6,1,q,"LD SP, "+o.desc,!1);m=197;for(f in u)o=u[f],p=m|o.bits<<4,q=newPUSH(o.from,b),r=o.pref,d(r,null,p,11,4+bw,q,"PUSH "+o.desc,!1);m=193;for(g in u)n=u[g],p=m|n.bits<<4,q=newPOP(n.to,b),r=n.pref,d(r,null,p,10,3+br,q,"POP "+n.desc,!1);p=235,q=EXDEHL,d(null,null,p,4,1,q,"EX DE, HL",!1),p=8,q=EXAFAF2,d(null,null,p,4,1,q,"EX AF, AF'",!1),p=217,q=EXX,d(null,null,p,4,1,q,"EXX",!1),p=227;for(var w in v){var x=v[w];q=newEXr_SP_16(x.to,x.from,b),r=x.pref,d(r,null,p,19,5+bw,q,"EX (SP), "+x.desc,!1)}p=160,q=newLDI(b),d(null,237,p,12,3+br+bw,q,"LDI",!1),p=176,q=newLDIR(q,c),d(null,237,p,12,3+br+bw,q,"LDIR",!1),p=168,q=newLDD(b),d(null,237,p,12,3+br+bw,q,"LDD",!1),p=184,q=newLDDR(q,c),d(null,237,p,12,3+br+bw,q,"LDDR",!1),p=161,q=newCPI(b),d(null,237,p,12,3+br,q,"CPI",!1),p=177,q=newCPIR(q,c),d(null,237,p,12,4+br,q,"CPIR",!1),p=169,q=newCPD(b),d(null,237,p,12,3+br,q,"CPD",!1),p=185,q=newCPDR(q,c),d(null,237,p,12,4+br,q,"CPDR",!1);var y={ADD:{desc:"ADD A, ",instr:newADD,variations:{rp:{opcode:128},n:{opcode:198},_HLp_:{opcode:134,T:7,Tr:2+br}}},ADC:{desc:"ADC A, ",instr:newADC,variations:{rp:{opcode:136},n:{opcode:206},_HLp_:{opcode:142,T:7,Tr:2+br}}},SUB:{desc:"SUB ",instr:newSUB,variations:{rp:{opcode:144},n:{opcode:214},_HLp_:{opcode:150,T:7,Tr:2+br}}},SBC:{desc:"SBC A, ",instr:newSBC,variations:{rp:{opcode:152},n:{opcode:222},_HLp_:{opcode:158,T:7,Tr:2+br}}},AND:{desc:"AND ",instr:newAND,variations:{rp:{opcode:160},n:{opcode:230},_HLp_:{opcode:166,T:7,Tr:2+br}}},OR:{desc:"OR ",instr:newOR,variations:{rp:{opcode:176},n:{opcode:246},_HLp_:{opcode:182,T:7,Tr:2+br}}},XOR:{desc:"XOR ",instr:newXOR,variations:{rp:{opcode:168},n:{opcode:238},_HLp_:{opcode:174,T:7,Tr:2+br}}},CP:{desc:"CP ",instr:newCP,variations:{rp:{opcode:184},n:{opcode:254},_HLp_:{opcode:190,T:7,Tr:2+br}}},INC:{desc:"INC ",instr:newINC,selfModifyInstr:newINC_PreRead_IXYd_,variations:{rp:{opcode:4,rShift:3},_HLp_:{opcode:52,T:11,Tr:4+br+bw}}},DEC:{desc:"DEC ",instr:newDEC,selfModifyInstr:newDEC_PreRead_IXYd_,variations:{rp:{opcode:5,rShift:3},_HLp_:{opcode:53,T:11,Tr:4+br+bw}}}};for(var z in y){var A=y[z],B=A.variations.rp;m=B.opcode;for(w in k)x=k[w],p=m|x.bits<<B.rShift,q=A.instr(x.from,x.to),r=x.pref,d(r,null,p,4,1,q,A.desc+x.desc,r);B=A.variations.n,B&&(p=B.opcode,
q=A.instr(b?fetchN_R800:fetchN,null),d(null,null,p,7,2,q,A.desc+"n",!1)),B=A.variations._HLp_,p=B.opcode;for(w in l)x=l[w],r=x.pref,q=r&&A.selfModifyInstr?A.selfModifyInstr(x.from.fromPreReadAddr,x.to.toPreReadAddr,b):A.instr(x.from,x.to),d(r,null,p,B.T+(r?8:0),B.Tr+(r?2:0),q,A.desc+x.desc,!1)}p=39,q=DAA,d(null,null,p,4,1,q,"DAA",!1),p=47,q=CPL,d(null,null,p,4,1,q,"CPL",!1),p=68,q=NEG,d(null,237,p,4,1,q,"NEG",!1),p=63,q=CCF,d(null,null,p,4,1,q,"CCF",!1),p=55,q=SCF,d(null,null,p,4,1,q,"SCF",!1),p=0,q=NOP,d(null,null,p,4,1,q,"NOP",!1),p=118,q=HALT,d(null,null,p,4,2,q,"HALT",!1),p=243,q=DI,d(null,null,p,4,2,q,"DI",!1),p=251,q=EI,d(null,null,p,4,1,q,"EI",!1),p=70,q=newIM(0),d(null,237,p,4,2,q,"IM 0",!1),p=86,q=newIM(1),d(null,237,p,4,2,q,"IM 1",!1),p=94,q=newIM(2),d(null,237,p,4,2,q,"IM 2",!1);var C={ADC:{desc:"ADC HL, ",instr:newADC16,opcode:74},SBC:{desc:"SBC HL, ",instr:newSBC16,opcode:66}},D={INC:{desc:"INC ",instr:newINC16,opcode:3},DEC:{desc:"DEC ",instr:newDEC16,opcode:11}};m=9;for(g in v){n=v[g];for(f in t)o=t[f],n.pref&&(o.nopref||o.pref&&o.pref!=n.pref)||o.pref&&(n.nopref||n.pref&&n.pref!=o.pref)||(p=m|o.bits<<4,q=newADD16(n.to,n.from,o.from),r=n.pref,d(r,null,p,11,1,q,"ADD "+n.desc+", "+o.desc,!1))}for(z in C){A=C[z],m=A.opcode;for(w in s)x=s[w],p=m|x.bits<<4,q=A.instr(toHL,fromHL,x.from),d(null,237,p,11,1,q,A.desc+x.desc,!1)}for(z in D){A=D[z],m=A.opcode;for(w in t)x=t[w],p=m|x.bits<<4,q=A.instr(x.to,x.from),r=x.pref,d(r,null,p,6,1,q,A.desc+x.desc,!1)}p=7,q=RLCA,d(null,null,p,4,1,q,"RLCA",!1),p=23,q=RLA,d(null,null,p,4,1,q,"RLA",!1),p=15,q=RRCA,d(null,null,p,4,1,q,"RRCA",!1),p=31,q=RRA,d(null,null,p,4,1,q,"RRA",!1);var E={A:{bits:7,to:toA,from:fromA,desc:"A"},B:{bits:0,to:toB,from:fromB,desc:"B"},C:{bits:1,to:toC,from:fromC,desc:"C"},D:{bits:2,to:toD,from:fromD,desc:"D"},E:{bits:3,to:toE,from:fromE,desc:"E"},H:{bits:4,to:toH,from:fromH,desc:"H"},L:{bits:5,to:toL,from:fromL,desc:"L"},_HL_:{bits:6,to:b?to_HL_8_R800:to_HL_8,from:b?from_HL_8_R800:from_HL_8,desc:"(HL)"}},F={_IXd_:{prefix:221,to:(b?to_IXd_8_R800:to_IXd_8).toPreReadAddr,from:(b?from_IXd_8_R800:from_IXd_8).fromPreReadAddr,desc:"(IX+d)"},_IYd_:{prefix:253,to:(b?to_IYd_8_R800:to_IYd_8).toPreReadAddr,from:(b?from_IYd_8_R800:from_IYd_8).fromPreReadAddr,desc:"(IY+d)"}},G={RLC:{desc:"RLC ",instr:newRLC,opcode:0},RL:{desc:"RL ",instr:newRL,opcode:16},RRC:{desc:"RRC ",instr:newRRC,opcode:8},RR:{desc:"RR ",instr:newRR,opcode:24},SLA:{desc:"SLA ",instr:newSLA,opcode:32},SRA:{desc:"SRA ",instr:newSRA,opcode:40},SLL:{desc:"SLL ",instr:newSLL,opcode:48,undoc:!b},SRL:{desc:"SRL ",instr:newSRL,opcode:56}};for(z in G){A=G[z],m=A.opcode;for(w in E)x=E[w],p=m|x.bits,q=A.instr(x.to,x.from,null,b),h="_HL_"===w?11:4,i="_HL_"===w?4+br+bw:1,d(null,203,p,h,i,q,A.desc+x.desc,A.undoc);for(var H in F){var I=F[H];for(w in E){x=E[w],p=m|x.bits;var J="_HL_"!==w?x.to:null;q=A.instr(I.to,I.from,J,b),d(I.prefix,203,p,15,5+br+bw,q,A.desc+I.desc+(J?", "+x.desc:""),A.undoc||J)}}}p=111,q=newRLD(b),d(null,237,p,14,4+br+bw,q,"RLD",!1),p=103,q=newRRD(b),d(null,237,p,14,4+br+bw,q,"RRD",!1);var K={BIT:{desc:"BIT ",instr:newBIT,opcode:64,T_HL_:8,T_HL_r:2+br},SET:{desc:"SET ",instr:newSET,opcode:192,T_HL_:11,T_HL_r:4+br+bw,toExt:!0},RES:{desc:"RES ",instr:newRES,opcode:128,T_HL_:11,T_HL_r:4+br+bw,toExt:!0}};for(z in K){A=K[z],m=A.opcode;for(w in E){x=E[w];for(var L=0;L<=7;L++)p=m|L<<3|x.bits,q=A.instr(x.to,x.from,L,null),h="_HL_"===w?A.T_HL_:4,i="_HL_"===w?A.T_HL_r:1,d(null,203,p,h,i,q,A.desc+L+", "+x.desc,!1)}for(H in F){I=F[H];for(w in E)for(x=E[w],L=0;L<=7;L++){p=m|L<<3|x.bits;var M="_HL_"!=w;J=M&&A.toExt?x.to:null,q=A.instr(I.to,I.from,L,J),d(I.prefix,203,p,A.T_HL_+4,A.T_HL_r+1,q,A.desc+L+", "+I.desc+(J?", "+x.desc:""),M)}}}var N={nn:{desc:"nn",from:b?fetchNN_R800:fetchNN,opcode:195,T:10,Tr:4},HL:{desc:"(HL)",from:fromHL,opcode:233,T:4,Tr:2},IX:{desc:"(IX)",from:fromIX,opcode:233,T:4,Tr:2,pref:221},IY:{desc:"(IY)",from:fromIY,opcode:233,T:4,Tr:2,pref:253}},O={NZ:{bits:0,desc:"NZ",flag:bZ,val:0},Z:{bits:1,desc:"Z",flag:bZ,val:bZ},NC:{bits:2,desc:"NC",flag:bC,val:0},C:{bits:3,desc:"C",flag:bC,val:bC},PO:{bits:4,desc:"PO",flag:bPV,val:0},PE:{bits:5,desc:"PE",flag:bPV,val:bPV},P:{bits:6,desc:"P",flag:bS,val:0},M:{bits:7,desc:"M",flag:bS,val:bS}};for(w in N)x=N[w],p=x.opcode,q=newJP(x.from,b),r=x.pref,d(r,null,p,x.T,x.Tr,q,"JP "+x.desc,!1);m=194;for(w in O)x=O[w],p=m|x.bits<<3,q=newJPcc(x.flag,x.val,b),d(null,null,p,10,3,q,"JP "+x.desc+", nn",!1);p=24,q=b?JR_R800:JR,d(null,null,p,12,3,q,"JR e",!1);var P={C:{opcode:56,desc:"C",flag:bC,val:bC},NC:{opcode:48,desc:"NC",flag:bC,val:0},Z:{opcode:40,desc:"Z",flag:bZ,val:bZ},NZ:{opcode:32,desc:"NZ",flag:bZ,val:0}};for(w in P)x=P[w],p=x.opcode,q=newJRcc(x.flag,x.val,b),d(null,null,p,7,2,q,"JR "+x.desc+", e",!1);p=16,q=b?DJNZ_R800:DJNZ,d(null,null,p,8,2,q,"DJNZ e",!1),p=205,q=b?CALL_R800:CALL,d(null,null,p,17,6+bw,q,"CALL nn",!1),m=196;for(w in O)x=O[w],p=m|x.bits<<3,q=newCALLcc(x.flag,x.val,b,c),d(null,null,p,10,3,q,"CALL "+x.desc+", nn",!1);p=201,q=b?RET_R800:RET,d(null,null,p,10,3+br,q,"RET",!1),m=192;for(w in O)x=O[w],p=m|x.bits<<3,q=newRETcc(x.flag,x.val,b),d(null,null,p,5,1,q,"RET "+x.desc,!1);p=77,q=b?RET_R800:RET,d(null,237,p,10,4+br,q,"RETI",!1),p=69,q=b?RET_R800:RET,d(null,237,p,10,4+br,q,"RETN",!1);var Q={h00:{bits:0,addr:0,desc:"00h"},h08:{bits:1,addr:8,desc:"08h"},h10:{bits:2,addr:16,desc:"10h"},h18:{bits:3,addr:24,desc:"18h"},h20:{bits:4,addr:32,desc:"20h"},h28:{bits:5,addr:40,desc:"28h"},h30:{bits:6,addr:48,desc:"30h"},h38:{bits:7,addr:56,desc:"38h"}};m=199;for(w in Q)x=Q[w],p=m|x.bits<<3,q=newRST(x.addr,b),d(null,null,p,11,5+bw,q,"RST "+x.desc,!1);p=219,q=b?INAn_R800:INAn,d(null,null,p,11,9,q,"IN A, (n)",!1),m=64;for(w in j)x=j[w],p=m|x.bits<<3,q=newINrC(x.to,b),d(null,237,p,8,8,q,"IN "+x.desc+", (C)",!1);p=162,q=newINI(b),d(null,237,p,12,10,q,"INI",!1),p=178,q=newINIR(q,c),d(null,237,p,12,10,q,"INIR",!1),p=170,q=newIND(b),d(null,237,p,12,10,q,"IND",!1),p=186,q=newINDR(q,c),d(null,237,p,12,10,q,"INDR",!1),p=211,q=b?OUTnA_R800:OUTnA,d(null,null,p,11,9,q,"OUT (n), A",!1),m=65;for(w in j)x=j[w],p=m|x.bits<<3,q=newOUTCr(x.from,b),d(null,237,p,8,8,q,"OUT (C), "+x.desc,!1);if(p=163,q=newOUTI(b),d(null,237,p,12,10,q,"OUTI",!1),p=179,q=newOTIR(q,c),d(null,237,p,12,10,q,"OTIR",!1),p=171,q=newOUTD(b),d(null,237,p,12,10,q,"OUTD",!1),p=187,q=newOTDR(q,c),d(null,237,p,12,10,q,"OTDR",!1),b){m=193;for(w in j)x=j[w],p=m|x.bits<<3,q=newMULUB(x.from),d(null,237,p,4,13,q,"MULUB A, "+x.desc,!1);m=195;for(w in s)x=s[w],p=m|x.bits<<4,q=newMULUW(x.from),d(null,237,p,4,35,q,"MULUW HL, "+x.desc,!1)}var R=[76,84,92,100,108,116,124];for(q=NEG,z=0;z<R.length;z++)p=R[z],d(null,237,p,4,1,q,"NEG",!0);for(R=[85,93,101,109,117,125],q=b?RET_R800:RET,z=0;z<R.length;z++)p=R[z],d(null,237,p,10,4+br,q,"RETN",!0);for(R=[78,102,110],q=newIM(0),z=0;z<R.length;z++)p=R[z],d(null,237,p,4,2,q,"IM 0",!0);for(p=118,q=newIM(1),d(null,237,p,4,2,q,"IM 1",!0),p=126,q=newIM(2),d(null,237,p,4,2,q,"IM 2",!0),p=112,q=b?uIN_C_R800:uIN_C,d(null,237,p,8,8,q,"IN (C)",!0),p=113,q=b?uOUTC0_R800:uOUTC0,d(null,237,p,8,8,q,"OUT (C), 0",!0),p=224;p<=255;p++)a[1][p]||(q=newpEXT(p),d(null,237,p,4,1,q,"EXT "+p.toString(16),!0));for(q=uNOP,p=0;p<=255;p++)a[1][p]||d(null,237,p,4,1,q,"NOP",!0);p=203,q=pSET_CB,d(null,null,p,4,1,q,"< SET CB >",!1),p=237,q=pSET_ED,d(null,null,p,4,1,q,"< SET ED >",!1),p=221,q=pSET_DD,d(null,null,p,4,1,q,"< SET DD >",!1),p=221,q=pSET_DD,d(221,null,p,4,1,q,"< SET DD again >",!1),p=253,q=pSET_FD,d(221,null,p,4,1,q,"< SWITCH to FD >",!1),p=203,q=newpSET_DDCB(b),d(221,null,p,3,1,q,"< SET DDCB >",!1),p=253,q=pSET_FD,d(null,null,p,4,1,q,"< SET FD >",!1),p=253,q=pSET_FD,d(253,null,p,4,1,q,"< SET FD again >",!1),p=221,q=pSET_DD,d(253,null,p,4,1,q,"< SWITCH to DD >",!1),p=203,q=newpSET_FDCB(b),d(253,null,p,3,1,q,"< SET FDCB >",!1),p=257,q=NOP,instrWait=d(null,null,p,1,1,q,"< WAIT CYCLES >",!1),p=258,
q=b?pINT_IM01_R800:pINT_IM01,d(null,null,p,13,3+bw,q,"< INT_M01 >",!1),p=259,q=b?pINT_IM2_R800:pINT_IM2,d(null,null,p,19,5+bw+br,q,"< INT_M2 >",!1);for(var S=0,T=a.length;S<T;++S)instructionsAll.push.apply(instructionsAll,a[S])}var self=this,r800Timing=WMSX.R800_TIMING;this.connectBus=function(a){bus=a},this.setMachineType=function(a){r800Present=a>=wmsx.Machine.MACHINE_TYPE.MSXTR,updateR800Present()},this.powerOn=function(){setINT(255),this.reset(),toAF(65533),toBC(65535),DE=65535,HL=65535,AF2=65533,BC2=65535,DE2=65535,HL2=65535,toIX(65535),toIY(65535),SP=65535,writeState(modeBackState)},this.powerOff=function(){},this.reset=function(){r800=!1,cpuCycles=0,busCycles=0,cpuToBusCycles=0,ackINT=!1,prefix=0,T=0,W=0,opcode=0,instruction=void 0,PC=0,I=0,R=0,R7=0,IFF1=0,IM=0,extCurrRunning=null,extExtraIter=0,fetchForceNextBreak(),writeState(modeBackState),updateInstructionSet()},this.setR800Mode=function(a){r800!==a&&(r800=a,swapModeState(),updateInstructionSet(),updateClockMulti())},this.setZ80BUSRQ=function(a){z80BUSRQ=a},this.busClockPulsesZ80=function(a){if(!z80BUSRQ)for(var b=cpuCycles+(a*clockMulti|0);cpuCycles<b;++cpuCycles)--T>0||(T<0?ackINT?acknowledgeINT():fetchNextInstruction():instruction.operation())},this.busClockPulsesBoth=function(a){if(!z80BUSRQ||r800)for(var b=cpuCycles+(a*clockMulti|0);cpuCycles<b;++cpuCycles)if(!(--T>0))if(T<0){if(W>0){--W;continue}ackINT?acknowledgeINT():(fetchNextInstruction(),0===T&&instruction.operation())}else instruction.operation()},this.busClockPulses=this.busClockPulsesZ80,this.r800MemoryRefresh=function(){r800&&(++R,W+=28)},this.setINTChannel=function(a,b){setINT(b?INT|1<<a:INT&~(1<<a))},this.getBUSCycles=function(){return busCycles+=(cpuCycles-cpuToBusCycles)/clockMulti|0,cpuToBusCycles=cpuCycles,busCycles},this.setZ80ClockMulti=function(a){z80ClockMulti=a<=0?1:a>8?8:a,r800||updateClockMulti()},this.getZ80ClockMulti=function(){return z80ClockMulti},this.setR800ClockMulti=function(a){r800ClockMulti=2*(a<=0?1:a>2?2:a),r800&&updateClockMulti()},this.getR800ClockMulti=function(){return r800ClockMulti/2},this.getClockFreqDesc=function(a){return(3.58*a).toFixed(2)+" MHz"};var r800=!1,r800Present=!1,modeBackState={},modeFrontState={},z80BUSRQ=!1,z80ClockMulti=1,r800ClockMulti=2,clockMulti=z80ClockMulti,cpuCycles=0,busCycles=0,cpuToBusCycles=0,extCurrRunning=null,extExtraIter=0,bus,INT=255,PC=0,SP=0,A=0,F=0,B=0,C=0,DE=0,HL=0,IX=0,IY=0,AF2=0,BC2=0,DE2=0,HL2=0,I=0,R=0,R7=0,IFF1=0,IM=0,bS=128,nS=7,bZ=64,nZ=6,bF5=32,nF5=5,bH=16,nH=4,bF3=8,nF3=3,bPV=4,nPV=2,bN=2,nN=1,bC=1,nC=0,T=0,W=0,opcode=0,prefix=0,instruction,ackINT=!1,fetchLastAddress=0,instructionsNoPrefixZ80=new Array(280),instructionsByPrefixZ80=[instructionsNoPrefixZ80,new Array(280),new Array(280),new Array(280),new Array(280),new Array(280),new Array(280),instructionsNoPrefixZ80],instructionsNoPrefixR800=new Array(280),instructionsByPrefixR800=[instructionsNoPrefixR800,new Array(280),new Array(280),new Array(280),new Array(280),new Array(280),new Array(280),instructionsNoPrefixR800],instructionsAll=[],instructionsAllOld=[],instructionsNoPrefix,instructionsByPrefix,instrWait;1!==r800Timing&&(busRead_R800=busRead,busWrite_R800=busWrite,fetchN_R800=fetchN,fetchNN_R800=fetchNN,memRead_R800=memRead,memRead16_R800=memRead16,memWrite_R800=memWrite,memWrite16_R800=memWrite16,memWrite16Rev_R800=memWrite16Rev),0===r800Timing&&(busInput_R800=busInput,busOutput_R800=busOutput);var preReadIXYdOffset=0;from_IXd_8.fromPreReadAddr=function(){return memRead(sum16Signed(IX,preReadIXYdOffset))},from_IXd_8_R800.fromPreReadAddr=function(){return memRead_R800(sum16Signed(IX,preReadIXYdOffset))},from_IYd_8.fromPreReadAddr=function(){return memRead(sum16Signed(IY,preReadIXYdOffset))},from_IYd_8_R800.fromPreReadAddr=function(){return memRead_R800(sum16Signed(IY,preReadIXYdOffset))},to_IXd_8.toPreReadAddr=function(a){memWrite(sum16Signed(IX,preReadIXYdOffset),a)},to_IXd_8_R800.toPreReadAddr=function(a){memWrite_R800(sum16Signed(IX,preReadIXYdOffset),a)},to_IYd_8.toPreReadAddr=function(a){memWrite(sum16Signed(IY,preReadIXYdOffset),a)},to_IYd_8_R800.toPreReadAddr=function(a){memWrite_R800(sum16Signed(IY,preReadIXYdOffset),a)};var parities=[4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4,4,0,0,4,0,4,4,0,4,0,0,4,0,4,4,0,0,4,4,0,4,0,0,4],br=1,bw=1;this.saveState=function(){return{PC:PC,SP:SP,A:A,F:F,B:B,C:C,DE:DE,HL:HL,IX:IX,IY:IY,AF2:AF2,BC2:BC2,DE2:DE2,HL2:HL2,I:I,R:R,R7:R7,IM:IM,IFF1:IFF1,INT:INT,nINT:1,cc:cpuCycles,bc:busCycles,cbc:cpuToBusCycles,Tn:T,W:W,o:opcode,p:prefix,ai:ackINT,in:instructionsAll.indexOf(instruction),ecr:extCurrRunning,eei:extExtraIter,r8p:r800Present,r8:r800,bs:modeBackState,tcm:z80ClockMulti,rcm:r800ClockMulti}},this.loadState=function(a){PC=a.PC,SP=a.SP,A=a.A,F=a.F,B=a.B,C=a.C,DE=a.DE,HL=a.HL,IX=a.IX,IY=a.IY,AF2=a.AF2,BC2=a.BC2,DE2=a.DE2,HL2=a.HL2,I=a.I,R=a.R,R7=a.R7||0,IM=a.IM,IFF1=a.IFF1,setINT(a.nINT?a.INT:a.INT?255:254),cpuCycles=a.cc||0,busCycles=a.bc||a.c||0,cpuToBusCycles=a.cbc||0,T=void 0!==a.Tn?a.Tn:a.T-1,W=a.W||0,opcode=a.o,prefix=a.p,ackINT=a.ai,extCurrRunning=a.ecr,extExtraIter=a.eei,r800Present=!!a.r8p,r800=!!a.r8,updateR800Present(),instruction=a.in>=0?instructionsAll[a.in]:instructionsAllOld[a.ii],a.bs&&(modeBackState=a.bs),z80ClockMulti=void 0!==a.tcm?a.tcm:a.tcs>0?2:1,r800ClockMulti=void 0!==a.rcm?a.rcm:2,updateInstructionSet(),updateClockMulti()},init(),this.toString=function(){return"CPU  PC: "+wmsx.Util.toHex2(PC)+"      op: "+(instruction?instruction.mnemonic:"NULL")+"          cycle: "+busCycles+"\n\nA: "+wmsx.Util.toHex2(A)+"     B: "+wmsx.Util.toHex2(B)+"     C: "+wmsx.Util.toHex2(C)+"     D: "+wmsx.Util.toHex2(DE>>>8)+"     E: "+wmsx.Util.toHex2(255&DE)+"     H: "+wmsx.Util.toHex2(HL>>>8)+"     L: "+wmsx.Util.toHex2(255&HL)+"\nBC: "+wmsx.Util.toHex2(fromBC())+"  DE: "+wmsx.Util.toHex2(DE)+"  HL: "+wmsx.Util.toHex2(HL)+"  IX: "+wmsx.Util.toHex2(IX)+"  IY: "+wmsx.Util.toHex2(IY)+"       SP: "+wmsx.Util.toHex2(SP)+"\n\nFlags: "+(F&bS?"S ":"- ")+(F&bZ?"Z ":"- ")+(F&bF5?"5 ":"- ")+(F&bH?"H ":"- ")+(F&bF3?"3 ":"- ")+(F&bPV?"P ":"- ")+(F&bN?"N ":"- ")+(F&bC?"C":"-")+"            IFF: "+IFF1+"     INT: "+wmsx.Util.toHex2(INT)+"     prefix: "+prefix},this.eval=function(str){return eval(str)}},wmsx.CPU.BASE_CLOCK=3584160,wmsx.PPI=function(a,b,c){"use strict";function d(){i=15&h}function e(){a.setPulseSignal((160&h)>0)}function f(){c.ledStateChanged(0,(64&~h)>>6)}this.connectBus=function(a){g=a,g.connectInputDevice(168,this.inputA8),g.connectOutputDevice(168,this.outputA8),g.connectInputDevice(169,this.inputA9),g.connectOutputDevice(169,wmsx.DeviceMissing.outputPortIgnored),g.connectInputDevice(170,this.inputAA),g.connectOutputDevice(170,this.outputAA),g.connectInputDevice(171,wmsx.DeviceMissing.inputPortIgnored),g.connectOutputDevice(171,this.outputAB)},this.powerOn=function(){this.reset()},this.powerOff=function(){this.reset()},this.reset=function(){h=80,i=0,e(),f()},this.inputA8=function(){return g.getPrimarySlotConfig()},this.outputA8=function(a){g.setPrimarySlotConfig(a)},this.inputA9=function(){return b.readKeyboardPort(i)},this.inputAA=function(){return h},this.outputAA=function(a){var b=h^a;b&&(h=a,15&b&&d(),160&b&&e(),64&b&&f())},this.outputAB=function(a){var b=(14&a)>>>1;0==(1&a)?h&=~(1<<b):h|=1<<b,b<=3?d():5===b||7===b?e():6===b&&f()};var g,h=80,i=0;this.saveState=function(){return{c:h}},this.loadState=function(a){h=a.c||0,d(),e(),f()}},wmsx.ColorCache=new function(){function a(a,b,c,d){switch(d=0!==d?4278190080:0,q){case 0:
return d|(255&a)<<16|(255&b)<<8|255&c;case 1:var e=Math.min(255,Math.round(.29*c+.55*b+.16*a));return d|e<<16|e<<8|e;case 2:return e=Math.min(255,Math.round(.31*c+.58*b+.18*a)),d|e/3.1<<16|e/1<<8|e/2.5;case 3:return e=Math.min(255,Math.round(.32*c+.6*b+.18*a)),d|e/9<<16|e/1.56<<8|e/1}}function b(a){return a>31?a-64:a}function c(a){return a<=0?0:a>=31?31:a}this.setColorAndPaletteMode=function(a,b){q!==a&&(q=a,d=e=f=g=h=i=j=void 0),r!==b&&(r=b,d=void 0)},this.getColors4bit9918Values=function(){if(!d){d=new Uint32Array(16);for(var b=p[r],c=0;c<16;++c){var e=b[c];d[c]=a(e>>16&255,e>>8&255,255&e)}}return d},this.getColors8bit9938Values=function(){if(!e){e=new Uint32Array(256);for(var b=0;b<256;++b)e[b]=a(k[3&b],l[b>>5],l[b>>2&7])}return e},this.getColors9bit9938Values=function(){if(!f){f=new Uint32Array(512);for(var b=0;b<512;++b)f[b]=a(l[7&b],l[b>>6],l[b>>3&7])}return f},this.getColors8bit9990Values=function(b){if(!g){g=new Uint32Array(256);for(var c=0;c<256;++c)g[c]=a(m[3&c],n[c>>5],n[c>>2&7])}return g[0]=b?0:4278190080,g},this.getColors16bitValues=function(){if(!h){h=new Uint32Array(65536);for(var b=0;b<65536;++b)h[b]=a(o[31&b],o[b>>10&31],o[b>>5&31],b<32768?1:0)}return h},this.getColorsYUVValues=function(){if(!i){i=new Uint32Array(131072);for(var d=0;d<131072;++d){var e=d>>12,f=b(d>>6&63),g=b(63&d),h=c(e+f),j=c(5*e-(f<<1)-g>>2),k=c(e+g);i[d]=a(o[k],o[j],o[h])}}return i},this.getColorsYJKValues=function(){if(!j){j=new Uint32Array(131072);for(var d=0;d<131072;++d){var e=d>>12,f=b(d>>6&63),g=b(63&d),h=c(e+f),i=c(e+g),k=c(5*e-(f<<1)-g>>2);j[d]=a(o[k],o[i],o[h])}}return j};var d=void 0,e=void 0,f=void 0,g=void 0,h=void 0,i=void 0,j=void 0,k=[0,73,146,255],l=[0,36,73,109,146,182,219,255],m=[0,90,172,255],n=[0,32,74,106,148,180,222,255],o=[0,8,16,24,32,41,49,57,65,74,82,90,98,106,115,123,131,139,148,156,164,172,180,189,197,205,213,222,230,238,246,255],p=[new Uint32Array([4278190080,4278190080,4280863239,4284867133,4293936196,4294208880,4279447760,4293978176,4282532595,4286085364,4281387728,4287225052,4280330502,4291117274,4290559164,4294967295]),new Uint32Array([4278190080,4278190080,4279102208,4283495232,4294920013,4294927993,4281026041,4294967058,4281157119,4283460095,4278569950,4282701040,4278962944,4293019364,4291611852,4294967295]),new Uint32Array([4278190080,4278190080,4283086656,4286500725,4292302425,4293883776,4283523e3,4293843814,4284114649,4286483197,4284531660,4287156446,4282556731,4290013110,4291611852,4294967295]),new Uint32Array([4278190080,4278190080,4280605476,4285398893,4294911012,4294929737,4280558774,4294957897,4280558847,4285361663,4280605659,4287814619,4280586788,4290136539,4290164406,4294967295]),new Uint32Array([4278190080,4278190080,4284927078,4287164040,4292691012,4294932343,4283782587,4292730231,4284901085,4286019583,4283813068,4287164142,4283804245,4290467259,4291611852,4294967295]),new Uint32Array([4278190080,4278190080,4278255360,4278255360,4294901760,4294901760,4278190335,4294967040,4278190335,4278190335,4278255615,4278255615,4278255360,4294902015,4294967295,4294967295])],q=0,r=2},wmsx.VDP=function(machine,cpu,vSyncConnection){"use strict";function init(){videoSignal=new wmsx.VideoSignal(self,"Internal"),audioClockPulse32=machine.getAudioSocket().audioClockPulse32,initColorCaches(),initFrameResources(!1),initDebugPatternTables(),initSpritesConflictMap(),modeData=modes[0],backdropCacheUpdatePending=!0,self.setDefaults(),commandProcessor=new wmsx.VDPCommandProcessor,commandProcessor.connectVDP(self,vram,register,status),commandProcessor.setVDPModeData(modeData),renderWidth=wmsx.VDP.SIGNAL_START_WIDTH_V9938,renderHeight=1===WMSX.MACHINES_CONFIG[WMSX.MACHINE].TYPE?wmsx.VDP.SIGNAL_HEIGHT_V9918:wmsx.VDP.SIGNAL_START_HEIGHT_V9938}function registerWrite(a,b){if(!(a>46)){var c,d=register[a]^b;switch(register[a]=b,a){case 0:16&d&&updateIRQ(),14&d&&updateMode();break;case 1:32&d&&updateIRQ(),64&d&&(blankingChangePending=!0),24&d&&updateMode(),4&d&&updateBlinking(),3&d&&updateSpritesConfig();break;case 2:127&d&&updateLayoutTableAddress();break;case 10:if(0==(7&d))break;case 3:c=131071&(register[10]<<14|register[3]<<6),colorTableAddress=c&modeData.colorTBase,colorTableAddressMask=c|colorTableAddressMaskBase;break;case 4:if(0==(63&d))break;c=b<<11&131071,patternTableAddress=c&modeData.patTBase,patternTableAddressMask=c|patternTableAddressMaskBase;break;case 11:if(0==(3&d))break;case 5:c=131071&(register[11]<<15|register[5]<<7),spriteAttrTableAddress=c&modeData.sprAttrTBase;break;case 6:63&d&&updateSpritePatternTableAddress();break;case 7:d&(modeData.bdPaletted?15:255)&&updateBackdropColor();break;case 8:32&d&&updateTransparency(),2&d&&updateSpritesConfig();break;case 9:128&d&&updateSignalMetrics(!1),8&d&&updateRenderMetrics(!1),4&d&&updateLayoutTableAddressMask(),2&d&&updateVideoStandardSoft();break;case 13:updateBlinking();break;case 14:7&d&&(vramPointer=(7&b)<<14|16383&vramPointer);break;case 16:paletteFirstWrite=null;break;case 18:15&d&&(horizontalAdjust=(15&b^7)-7),240&d&&(verticalAdjust=(b>>>4^7)-7,updateSignalMetrics(!1));break;case 19:horizontalIntLine=b-register[23]&255;break;case 23:horizontalIntLine=register[19]-b&255;break;case 25:isV9958&&(24&d&&updateMode(),leftMask=0!=(2&b),leftScroll2Pages=0!=(1&b));break;case 26:isV9958&&(leftScrollChars=63&b,leftScrollCharsInPage=31&leftScrollChars);break;case 27:isV9958&&(rightScrollPixels=7&b);break;case 44:commandProcessor.cpuWrite(b);break;case 46:commandProcessor.startCommand(b)}}}function updateLayoutTableAddress(){var a=modeData.vramInter?(63&register[2])<<11|1024:(127&register[2])<<10;layoutTableAddress=a&modeData.layTBase,layoutTableAddressMaskSetValue=a|layoutTableAddressMaskBase,updateLayoutTableAddressMask()}function updateLayoutTableAddressMask(){layoutTableAddressMask=layoutTableAddressMaskSetValue&(blinkEvenPage||4&register[9]&&!EO?modeData.blinkPageMask:-1)}function updateSpritePatternTableAddress(){spritePatternTableAddress=debugModeSpriteInfo?16===spritesSize?DEBUG_PAT_DIGI16_TABLE_ADDRESS:DEBUG_PAT_DIGI8_TABLE_ADDRESS:register[6]<<11&131071}function getStatus0(){var a=0;return F&&(a|=128,F=0,updateIRQ()),spritesCollided&&(a|=32,spritesCollided=!1),spritesInvalid>=0?(a|=64|spritesInvalid,spritesInvalid=-1):a|=spritesMaxComputed,spritesMaxComputed=0,a}function checkVRAMPointerWrap(){0==(16383&vramPointer)&&(modeData.isV9938&&(register[14]=register[14]+1&7),vramPointer=register[14]<<14)}function paletteRegisterWrite(a,b,c){if(paletteRegister[a]!==b||c){paletteRegister[a]=b;var d=getColorValueForPaletteValue(b);colorPaletteReal[a]=d,debugModeSpriteHighlight&&(d&=DEBUG_DIM_ALPHA_MASK),colorPaletteSolid[a]=d,0===a?color0Solid&&(colorPalette[0]=d):colorPalette[a]=d,a===backdropColor?updateBackdropValue():modeData.tiled&&a<=3&&(backdropCacheUpdatePending=!0)}}function getColorValueForPaletteValue(a){return colors9bitValues[(1792&a)>>>2|(112&a)>>>1|7&a]}function setDebugMode(a){debugMode=(a+8)%8;var b=debugModeSpriteHighlight;debugModeSpriteHighlight=debugMode>=1&&debugMode<=3,debugModeSpriteInfo=2===debugMode||3===debugMode,debugModeSpriteInfoNumbers=2===debugMode,debugModeSpritesHidden=debugMode>=4;var c=debugModePatternInfo;debugModePatternInfo=debugMode>=5,debugModePatternInfoBlocks=6===debugMode,debugModePatternInfoNames=7===debugMode,b===debugModeSpriteHighlight&&c===debugModePatternInfo||updateAllPaletteValues(),initFrameResources(debugModeSpriteHighlight),updateLineActiveType(),updateSpritesConfig(),updateSpritePatternTableAddress(),slave&&slave.setDebugMode(debugMode),videoSignal.setDebugMode(debugMode>0)}function setSpriteDebugMode(a){spriteDebugMode=a>=0?a%4:4+a,spriteDebugModeLimit=0===spriteDebugMode||2===spriteDebugMode,spriteDebugModeCollisions=spriteDebugMode<2,slave&&slave.setSpriteDebugMode(spriteDebugMode)}function updateAllPaletteValues(){if(isV9918)initColorPalette();else for(var a=0;a<16;a++)paletteRegisterWrite(a,paletteRegister[a],!0)}
function updateSynchronization(){pulldown=1===vSynchMode?videoStandard.pulldowns[machine.getVideoClockSocket().getVSynchNativeFrequency()]||videoStandard.pulldowns.TIMER:videoStandard.pulldowns.TIMER}function cycleEvents(){var a=framePulldown.linesPerCycle;pulldown.steps>1&&frame%pulldown.steps==0&&(a+=pulldown.firstStepCycleLinesAdjust);for(var b=a;b>0;--b)lineEvents()}function lineEvents(){blinkPerLine&&blinkPageDuration>0&&clockPageBlinking()&&updateLayoutTableAddressMask(),currentScanline===startingActiveScanline?setActiveDisplay():currentScanline-frameStartingActiveScanline===signalActiveHeight&&setBorderDisplay(),cpuMemoryRefresh(),cpuBusClockPulses(33),audioClockPulse32(),blankingChangePending&&updateLineActiveType(),FH&&0==(16&register[0])&&(FH=0),currentScanline===startingActiveScanline-1?VR=0:currentScanline-frameStartingActiveScanline===signalActiveHeight&&triggerVerticalInterrupt(),cpuBusClockPulses(10),HR=0,slave&&slave.lineEventStartActiveDisplay(),cpuBusClockPulses(22),audioClockPulse32(),cpuBusClockPulses(33),audioClockPulse32(),cpuBusClockPulses(32),audioClockPulse32(),currentScanline>=startingVisibleTopBorderScanline&&currentScanline<startingInvisibleScanline&&renderLine(),slave&&slave.lineEventRenderLine(),cpuMemoryRefresh(),cpuBusClockPulses(33),audioClockPulse32(),cpuBusClockPulses(32),audioClockPulse32(),cpuBusClockPulses(18),HR=1,currentScanline-frameStartingActiveScanline===horizontalIntLine&&triggerHorizontalInterrupt(),slave&&slave.lineEventEndActiveDisplay(),cpuBusClockPulses(15),audioClockPulse32(),0==(7&currentScanline)&&audioClockPulse32(),++currentScanline,slave&&slave.lineEventEnd(),currentScanline>=finishingScanline&&(finishFrame(),slave&&slave.frameEventFinishFrame())}function triggerVerticalInterrupt(){VR=1,F||(F=1,updateIRQ())}function triggerHorizontalInterrupt(){FH||(FH=1,updateIRQ())}function updateIRQ(){F&&32&register[1]||FH&&16&register[0]?cpu.setINTChannel(0,0):cpu.setINTChannel(0,1)}function updateVRAMInterleaving(){!0!==modeData.vramInter||vramInterleaving?!1===modeData.vramInter&&vramInterleaving&&vramExitInterleaving():vramEnterInterleaving()}function vramEnterInterleaving(){for(var a=0,b=VRAM_SIZE>>1,c=vram.slice(0,b),d=0;d<VRAM_SIZE;d+=2,++a,++b)vram[d]=c[a],vram[d+1]=vram[b];vramInterleaving=!0}function vramExitInterleaving(){for(var a=VRAM_SIZE>>1,b=0,c=a,d=vram.slice(a),e=0;e<a;e+=2,++b,++c)vram[b]=vram[e],vram[c]=vram[e+1];for(e=0;e<a;e+=2,++b,++c)vram[b]=d[e],vram[c]=d[e+1];vramInterleaving=!1}function setMode(a){registerWrite(0,-15&register[0]|(7&a)<<1),registerWrite(1,-25&register[1]|24&a)}function updateMode(a){var b=modeData,c=24&register[1]|(register[0]&(isV9918?2:14))>>>1;commandProcessor.setVDPModeData(modes[c]),isV9958&&0!=(8&register[25])&&0==(16&c)&&(c=32|(24&register[25])>>3),modeData=modes[c];var d;updateLayoutTableAddress(),d=131071&(register[10]<<14|register[3]<<6),colorTableAddress=d&modeData.colorTBase,colorTableAddressMask=d|colorTableAddressMaskBase,d=register[4]<<11&131071,patternTableAddress=d&modeData.patTBase,patternTableAddressMask=d|patternTableAddressMaskBase,d=131071&(register[11]<<15|register[5]<<7),spriteAttrTableAddress=d&modeData.sprAttrTBase,updateSpritePatternTableAddress(),modeData.bdPaletted!==b.bdPaletted&&updateBackdropColor(),modeData.tiled!==b.tiled&&(backdropCacheUpdatePending=!0),updateVRAMInterleaving(),updateLineActiveType(),updateRenderMetrics(a)}function updateVideoStandardSoft(){var a=2&register[9];machine.setVideoStandardSoft(a?wmsx.VideoStandard.PAL:wmsx.VideoStandard.NTSC)}function updateSignalMetrics(a){var b;isV9918&&!slave?(signalActiveHeight=192,b=0):!isV9918&&128&register[9]?(signalActiveHeight=212,b=0):(signalActiveHeight=192,b=10),startingVisibleTopBorderScanline=8,startingActiveScanline=startingVisibleTopBorderScanline+8+b+verticalAdjust,startingInvisibleScanline=startingActiveScanline+signalActiveHeight+8+b-verticalAdjust,finishingScanline=frameVideoStandard.totalHeight,a&&(frameStartingActiveScanline=startingActiveScanline)}function updateRenderMetrics(a){var b,c,d=!1,e=!1;isV9918&&!slave?(b=wmsx.VDP.SIGNAL_WIDTH_V9918,c=wmsx.VDP.SIGNAL_HEIGHT_V9918):(b=512===modeData.width?544:272,c=!isV9918&&8&register[9]?456:228),renderMetricsChangePending=!1,b===renderWidth&&c===renderHeight||(b!==renderWidth&&(currentScanline<startingVisibleTopBorderScanline||b>renderWidth?(currentScanline>=startingVisibleTopBorderScanline&&(a?e=!0:stretchFromCurrentToTopScanline()),renderWidth=b,d=!0):renderMetricsChangePending=!0),c!==renderHeight&&(a?((currentScanline>=startingVisibleTopBorderScanline||c>renderHeight)&&(e=!0),renderHeight=c,d=!0):renderMetricsChangePending=!0),e&&cleanFrameBuffer(),d&&self.refreshDisplayMetrics())}function setActiveDisplay(){renderLine=renderLineActive}function setBorderDisplay(){renderLine=renderLineBorders}function updateLineActiveType(){var a=renderLine===renderLineActive;renderLineActive=0==(64&register[1])?renderLineBlanked:debugModePatternInfo?modeData.renderLinePatInfo:modeData.renderLine,a&&(renderLine=renderLineActive),blankingChangePending=!1}function updateSpritesConfig(){spritesEnabled=!debugModeSpritesHidden&&0==(2&register[8]),spritesSize=2&register[1]?16:8,spritesMag=1&register[1]}function updateTransparency(){color0Solid=0!=(32&register[8]),colorPalette[0]=color0Solid?colorPaletteSolid[0]:backdropValue}function updateBackdropColor(){backdropColor=register[7]&(modeData.bdPaletted?15:255),updateBackdropValue()}function updateBackdropValue(){var a=debugModePatternInfo?debugBackdropValue:modeData.bdPaletted?colorPaletteSolid[backdropColor]:colors8bitValues[backdropColor];backdropValue!==a&&(backdropValue=a,color0Solid||(colorPalette[0]=a),backdropCacheUpdatePending=!0)}function updateBackdropLineCache(){if(modeData.tiled&&!debugModePatternInfo){for(var a=colorPaletteSolid[backdropColor>>>2],b=colorPaletteSolid[3&backdropColor],c=0;c<LINE_WIDTH;c+=2)backdropLineCache[c]=a,backdropLineCache[c+1]=b;backdropTileOdd=a,backdropTileEven=b}else wmsx.Util.arrayFill(backdropLineCache,backdropValue),modeData.tiled&&(backdropTileOdd=backdropTileEven=backdropValue);backdropCacheUpdatePending=!1}function updateBlinking(){blinkPerLine=0!=(4&register[1]),register[13]>>>4==0?(blinkEvenPage=!1,blinkPageDuration=0):0==(15&register[13])?(blinkEvenPage=!0,blinkPageDuration=0):(blinkEvenPage=!0,blinkPageDuration=1),updateLayoutTableAddressMask()}function clockPageBlinking(){return 0==--blinkPageDuration&&(blinkEvenPage=!blinkEvenPage,blinkPageDuration=10*(register[13]>>>(blinkEvenPage?4:0)&15),!0)}function renderLineBorders(){videoDisplayed&&(backdropCacheUpdatePending&&updateBackdropLineCache(),frameBackBuffer.set(backdropLineCache,bufferPosition),bufferPosition+=bufferLineAdvance)}function renderLineBlanked(){renderLineBorders()}function getRealLine(){return currentScanline-frameStartingActiveScanline+register[23]&255}function renderLineModeT1(){if(videoDisplayed){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=register[7],d=patternTableAddress+(7&b),e=colorPalette[c>>>4],f=colorPalette[15&c],g=layoutTableAddress+40*(b>>>3);paintBackdrop8(a),a+=8;for(var h=0;h<40;++h){var i=vram[g];++g;paintPattern6(a,vram[(i<<3)+d],e,f),a+=6}paintBackdrop8(a),a+=8,a-=rightScrollPixels+256,leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}}function renderLineModeT2(){if(videoDisplayed){paintBackdrop32(bufferPosition),paintBackdrop32(bufferPosition+512);var a,b,c,d,e,f=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),g=getRealLine(),h=patternTableAddress+(7&g),i=layoutTableAddress+80*(g>>>3);if(paintBackdrop16(f),f+=16,blinkEvenPage)for(var j=colorTableAddress+10*(g>>>3),k=7,l=0;l<80;++l){var m=vram[j&colorTableAddressMask]>>>k&1;a=vram[i&layoutTableAddressMask],++i,
c=register[m?12:7],b=vram[(a<<3)+h],d=m?colorPaletteSolid[c>>>4]:colorPalette[c>>>4],e=m?colorPaletteSolid[15&c]:colorPalette[15&c],paintPattern6(f,b,d,e),--k<0&&(++j,k=7),f+=6}else for(c=register[7],d=colorPalette[c>>>4],e=colorPalette[15&c],l=0;l<80;++l)a=vram[i&layoutTableAddressMask],++i,b=vram[(a<<3)+h],paintPattern6(f,b,d,e),f+=6;paintBackdrop16(f),f+=16,f-=512+(rightScrollPixels<<1),leftMask&&paintBackdrop16(f),rightScrollPixels&&paintBackdrop16(f+512),bufferPosition+=bufferLineAdvance}}function renderLineModeMC(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode1(a,0);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=patternTableAddress+((a>>>3&3)<<1)+(a>>>2&1),d=layoutTableAddress+(a>>>3<<5),e=d+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(e&=modeData.evenPageMask);for(var f=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,g=0;g<32;++g){g===f&&(e=leftScroll2Pages&&leftScrollChars>=32?d&modeData.evenPageMask:d);var h=vram[e];++e;var i=(h<<3)+c,j=vram[i];paintPattern8(b,240,colorPalette[j>>>4],colorPalette[15&j]),b+=8}b-=rightScrollPixels+256,renderSpritesLineMode1(a,b),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG1(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode1(a,0);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=patternTableAddress+(7&a),d=layoutTableAddress+(a>>>3<<5),e=d+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(e&=modeData.evenPageMask);for(var f=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,g=0;g<32;++g){g===f&&(e=leftScroll2Pages&&leftScrollChars>=32?d&modeData.evenPageMask:d);var h=vram[e];++e;var i=vram[colorTableAddress+(h>>>3)];paintPattern8(b,vram[(h<<3)+c],colorPalette[i>>>4],colorPalette[15&i]),b+=8}b-=rightScrollPixels+256,renderSpritesLineMode1(a,b),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG2(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode1(a,0);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=colorTableAddress+(7&a),d=patternTableAddress+(7&a),e=(192&a)<<2,f=layoutTableAddress+(a>>>3<<5),g=f+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(g&=modeData.evenPageMask);for(var h=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,i=0;i<32;++i){i===h&&(g=leftScroll2Pages&&leftScrollChars>=32?f&modeData.evenPageMask:f);var j=vram[g]|e;++g;var k=vram[(j<<3)+c&colorTableAddressMask];paintPattern8(b,vram[(j<<3)+d&patternTableAddressMask],colorPalette[k>>>4],colorPalette[15&k]),b+=8}b-=rightScrollPixels+256,renderSpritesLineMode1(a,b),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG3(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2(a,0,colorPaletteReal);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=colorTableAddress+(7&a),d=patternTableAddress+(7&a),e=(192&a)<<2,f=layoutTableAddress+(a>>>3<<5),g=f+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(g&=modeData.evenPageMask);for(var h=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,i=0;i<32;++i){i===h&&(g=leftScroll2Pages&&leftScrollChars>=32?f&modeData.evenPageMask:f);var j=vram[g]|e;++g;var k=vram[(j<<3)+c&colorTableAddressMask];paintPattern8(b,vram[(j<<3)+d&patternTableAddressMask],colorPalette[k>>>4],colorPalette[15&k]),b+=8}b-=rightScrollPixels+256,renderSpritesLineMode2(a,b,colorPaletteReal),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG4(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2(a,0,colorPaletteReal);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=layoutTableAddress+(a<<7),d=c+(leftScrollCharsInPage<<2);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d&layoutTableAddressMask];++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b}b-=rightScrollPixels+256,renderSpritesLineMode2(a,b,colorPaletteReal),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG5(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2Tiled(a,0);paintBackdrop32Tiled(bufferPosition),paintBackdrop32Tiled(bufferPosition+512);var b=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),c=layoutTableAddress+(a<<7),d=c+(leftScrollCharsInPage<<2);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1;if(color0Solid)for(var f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d&layoutTableAddressMask];++d,frameBackBuffer[b]=colorPaletteSolid[g>>>6],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>4&3],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>2&3],++b,frameBackBuffer[b]=colorPaletteSolid[3&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPaletteSolid[g>>>6],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>4&3],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>2&3],++b,frameBackBuffer[b]=colorPaletteSolid[3&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPaletteSolid[g>>>6],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>4&3],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>2&3],++b,frameBackBuffer[b]=colorPaletteSolid[3&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPaletteSolid[g>>>6],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>4&3],++b,frameBackBuffer[b]=colorPaletteSolid[g>>>2&3],++b,frameBackBuffer[b]=colorPaletteSolid[3&g],++b}else for(f=0;f<32;++f)f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c),g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,++b,frameBackBuffer[b]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,++b,frameBackBuffer[b]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,++b,frameBackBuffer[b]=3&g?colorPaletteSolid[3&g]:backdropTileEven,++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,++b,frameBackBuffer[b]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,++b,frameBackBuffer[b]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,++b,frameBackBuffer[b]=3&g?colorPaletteSolid[3&g]:backdropTileEven,++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,++b,frameBackBuffer[b]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,++b,frameBackBuffer[b]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,++b,frameBackBuffer[b]=3&g?colorPaletteSolid[3&g]:backdropTileEven,++b,g=vram[d&layoutTableAddressMask],++d,
frameBackBuffer[b]=192&g?colorPaletteSolid[g>>>6]:backdropTileOdd,++b,frameBackBuffer[b]=48&g?colorPaletteSolid[g>>>4&3]:backdropTileEven,++b,frameBackBuffer[b]=12&g?colorPaletteSolid[g>>>2&3]:backdropTileOdd,++b,frameBackBuffer[b]=3&g?colorPaletteSolid[3&g]:backdropTileEven,++b;b-=512+(rightScrollPixels<<1),renderSpritesLineMode2Tiled(a,b),leftMask&&paintBackdrop16Tiled(b),rightScrollPixels&&paintBackdrop16Tiled(b+512),bufferPosition+=bufferLineAdvance}function renderLineModeG6(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2Stretched(a,0);paintBackdrop32(bufferPosition),paintBackdrop32(bufferPosition+512);var b=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),c=layoutTableAddress+(a<<8),d=c+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d&layoutTableAddressMask];++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b,g=vram[d&layoutTableAddressMask],++d,frameBackBuffer[b]=colorPalette[g>>>4],++b,frameBackBuffer[b]=colorPalette[15&g],++b}b-=512+(rightScrollPixels<<1),renderSpritesLineMode2Stretched(a,b),leftMask&&paintBackdrop16(b),rightScrollPixels&&paintBackdrop16(b+512),bufferPosition+=bufferLineAdvance}function renderLineModeG7(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2(a,0,spritePaletteG7);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=debugModeSpriteHighlight?DEBUG_DIM_ALPHA_MASK:4294967295,d=layoutTableAddress+(a<<8),e=d+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(e&=modeData.evenPageMask);for(var f=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,g=0;g<32;++g)g===f&&(e=leftScroll2Pages&&leftScrollChars>=32?d&modeData.evenPageMask:d),frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b,frameBackBuffer[b]=colors8bitValues[vram[e&layoutTableAddressMask]]&c,++e,++b;b-=rightScrollPixels+256,renderSpritesLineMode2(a,b,spritePaletteG7),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeYJK(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2(a,0,colorPaletteReal);paintBackdrop20(bufferPosition),paintBackdrop16(bufferPosition+256+4),colorsYJKValues||(colorsYJKValues=wmsx.ColorCache.getColorsYJKValues());var b=bufferPosition+8+horizontalAdjust+rightScrollPixels+4,c=layoutTableAddress+(a<<8),d=c+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e,f,g,h,i,j=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,k=0;k<32;++k)k===j&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c),e=vram[d&layoutTableAddressMask],++d,f=vram[d&layoutTableAddressMask],++d,g=vram[d&layoutTableAddressMask],++d,h=vram[d&layoutTableAddressMask],++d,i=(7&h)<<9|(7&g)<<6|(7&f)<<3|7&e,frameBackBuffer[b]=colorsYJKValues[(248&e)<<9|i],++b,frameBackBuffer[b]=colorsYJKValues[(248&f)<<9|i],++b,frameBackBuffer[b]=colorsYJKValues[(248&g)<<9|i],++b,frameBackBuffer[b]=colorsYJKValues[(248&h)<<9|i],++b,e=vram[d&layoutTableAddressMask],++d,f=vram[d&layoutTableAddressMask],++d,g=vram[d&layoutTableAddressMask],++d,h=vram[d&layoutTableAddressMask],++d,i=(7&h)<<9|(7&g)<<6|(7&f)<<3|7&e,frameBackBuffer[b]=colorsYJKValues[(248&e)<<9|i],++b,frameBackBuffer[b]=colorsYJKValues[(248&f)<<9|i],++b,frameBackBuffer[b]=colorsYJKValues[(248&g)<<9|i],++b,frameBackBuffer[b]=colorsYJKValues[(248&h)<<9|i],++b;b-=rightScrollPixels+256,renderSpritesLineMode2(a,b,colorPaletteReal),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeYAE(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2(a,0,colorPaletteReal);paintBackdrop20(bufferPosition),paintBackdrop16(bufferPosition+256+4),colorsYJKValues||(colorsYJKValues=wmsx.ColorCache.getColorsYJKValues());var b=bufferPosition+8+horizontalAdjust+rightScrollPixels+4,c=layoutTableAddress+(a<<8),d=c+(leftScrollCharsInPage<<3);leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e,f,g,h,i,j=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,k=0;k<32;++k)k===j&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c),e=vram[d&layoutTableAddressMask],++d,f=vram[d&layoutTableAddressMask],++d,g=vram[d&layoutTableAddressMask],++d,h=vram[d&layoutTableAddressMask],++d,i=(7&h)<<9|(7&g)<<6|(7&f)<<3|7&e,frameBackBuffer[b]=8&e?colorPalette[e>>4]:colorsYJKValues[(248&e)<<9|i],++b,frameBackBuffer[b]=8&f?colorPalette[f>>4]:colorsYJKValues[(248&f)<<9|i],++b,frameBackBuffer[b]=8&g?colorPalette[g>>4]:colorsYJKValues[(248&g)<<9|i],++b,frameBackBuffer[b]=8&h?colorPalette[h>>4]:colorsYJKValues[(248&h)<<9|i],++b,e=vram[d&layoutTableAddressMask],++d,f=vram[d&layoutTableAddressMask],++d,g=vram[d&layoutTableAddressMask],++d,h=vram[d&layoutTableAddressMask],++d,i=(7&h)<<9|(7&g)<<6|(7&f)<<3|7&e,frameBackBuffer[b]=8&e?colorPalette[e>>4]:colorsYJKValues[(248&e)<<9|i],++b,frameBackBuffer[b]=8&f?colorPalette[f>>4]:colorsYJKValues[(248&f)<<9|i],++b,frameBackBuffer[b]=8&g?colorPalette[g>>4]:colorsYJKValues[(248&g)<<9|i],++b,frameBackBuffer[b]=8&h?colorPalette[h>>4]:colorsYJKValues[(248&h)<<9|i],++b;b-=rightScrollPixels+256,renderSpritesLineMode2(a,b,colorPaletteReal),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeT1PatInfo(){if(videoDisplayed){paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var a=bufferPosition+8+horizontalAdjust+rightScrollPixels,b=getRealLine(),c=7&b,d=layoutTableAddress+40*(b>>>3);paintBackdrop8(a),a+=8;for(var e=0;e<40;++e){var f=vram[d];if(++d,debugModePatternInfoNames){var g=0===f||32===f?4293787648:4294967295,h=vram[DEBUG_PAT_DIGI6_TABLE_ADDRESS+(f<<3)+c];paintPattern6TInfo(a,h,g,4278190080)}else h=vram[patternTableAddress+(f<<3)+c],paintPattern6(a,h,4294967295,4278190080);a+=6}paintBackdrop8(a),a+=8,a-=rightScrollPixels+256,leftMask&&paintBackdrop8(a),rightScrollPixels&&paintBackdrop8(a+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}}function renderLineModeT2PatInfo(){if(videoDisplayed){paintBackdrop32(bufferPosition),paintBackdrop32(bufferPosition+512);var a,b,c,d=bufferPosition+16+(horizontalAdjust+rightScrollPixels<<1),e=getRealLine(),f=7&e,g=layoutTableAddress+80*(e>>>3)
;if(paintBackdrop16(d),d+=16,blinkEvenPage)for(var h=colorTableAddress+10*(e>>>3),i=7,j=0;j<80;++j){var k=vram[h&colorTableAddressMask]>>>i&1;a=vram[g&layoutTableAddressMask],++g,debugModePatternInfoNames?(c=0===a||32===a?4293787648:4294967295,k&&(c&=4288716960),b=vram[DEBUG_PAT_DIGI6_TABLE_ADDRESS+(a<<3)+f],paintPattern6TInfo(d,b,c,4278190080)):(b=vram[patternTableAddress+(a<<3)+f],paintPattern6(d,b,k?4288716960:4294967295,4278190080)),--i<0&&(++h,i=7),d+=6}else for(j=0;j<80;++j)a=vram[g&layoutTableAddressMask],++g,debugModePatternInfoNames?(c=0===a||32===a?4293787648:4294967295,b=vram[DEBUG_PAT_DIGI6_TABLE_ADDRESS+(a<<3)+f],paintPattern6TInfo(d,b,c,4278190080)):(b=vram[patternTableAddress+(a<<3)+f],paintPattern6(d,b,4294967295,4278190080)),d+=6;paintBackdrop16(d),d+=16,d-=512+(rightScrollPixels<<1),leftMask&&paintBackdrop16(d),rightScrollPixels&&paintBackdrop16(d+512),bufferPosition+=bufferLineAdvance}}function paintPattern6TInfo(a,b,c,d){var e=2550136831&c;frameBackBuffer[a]=128&b?c:d,frameBackBuffer[a+1]=64&b?c:d,frameBackBuffer[a+2]=32&b?c:d,frameBackBuffer[a+3]=16&b?e:d,frameBackBuffer[a+4]=8&b?e:d,frameBackBuffer[a+5]=4&b?e:d}function renderLineModeMCPatInfo(){if(!debugModePatternInfoNames)return renderLineModeMC();var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode1(a,0);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b=bufferPosition+8+horizontalAdjust+rightScrollPixels,c=layoutTableAddress+(a>>>3<<5),d=c+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(d&=modeData.evenPageMask);for(var e=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,f=0;f<32;++f){f===e&&(d=leftScroll2Pages&&leftScrollChars>=32?c&modeData.evenPageMask:c);var g=vram[d];++d;paintPattern8(b,vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(g<<3)+(7&a)],4294967295,4278190080),b+=8}b-=rightScrollPixels+256,renderSpritesLineMode1(a,b),leftMask&&paintBackdrop8(b),rightScrollPixels&&paintBackdrop8(b+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG1PatInfo(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode1(a,0);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b,c,d,e=bufferPosition+8+horizontalAdjust+rightScrollPixels,f=7&a,g=layoutTableAddress+(a>>>3<<5),h=g+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(h&=modeData.evenPageMask);for(var i=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,j=0;j<32;++j){j===i&&(h=leftScroll2Pages&&leftScrollChars>=32?g&modeData.evenPageMask:g);var k=vram[h];if(++h,debugModePatternInfoNames)c=0===k||32===k?4293787648:4294967295,d=4278190080,b=vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(k<<3)+f];else if(debugModePatternInfoBlocks){var l=vram[colorTableAddress+(k>>>3)];c=colorPalette[l>>>4],d=colorPalette[15&l],b=vram[DEBUG_PAT_BLOCK_TABLE_ADDRESS+f]}else c=4294967295,d=4278190080,b=vram[patternTableAddress+(k<<3)+f];paintPattern8(e,b,c,d),e+=8}e-=rightScrollPixels+256,renderSpritesLineMode1(a,e),leftMask&&paintBackdrop8(e),rightScrollPixels&&paintBackdrop8(e+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG2PatInfo(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode1(a,0);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b,c,d,e=bufferPosition+8+horizontalAdjust+rightScrollPixels,f=7&a,g=(192&a)<<2,h=layoutTableAddress+(a>>>3<<5),i=h+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(i&=modeData.evenPageMask);for(var j=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,k=0;k<32;++k){k===j&&(i=leftScroll2Pages&&leftScrollChars>=32?h&modeData.evenPageMask:h);var l=vram[i]|g;if(++i,debugModePatternInfoNames)l&=255,c=0===l||32===l?4293787648:4294967295,d=4278190080,b=vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(l<<3)+f];else if(debugModePatternInfoBlocks){var m=vram[colorTableAddress+(l<<3)+f&colorTableAddressMask];c=colorPalette[m>>>4],d=colorPalette[15&m],b=vram[DEBUG_PAT_BLOCK_TABLE_ADDRESS+f]}else c=4294967295,d=4278190080,b=vram[patternTableAddress+(l<<3)+f&patternTableAddressMask];paintPattern8(e,b,c,d),e+=8}e-=rightScrollPixels+256,renderSpritesLineMode1(a,e),leftMask&&paintBackdrop8(e),rightScrollPixels&&paintBackdrop8(e+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function renderLineModeG3PatInfo(){var a=getRealLine();if(!videoDisplayed)return renderSpritesLineMode2(a,0,colorPaletteReal);paintBackdrop16(bufferPosition),paintBackdrop16(bufferPosition+256);var b,c,d,e=bufferPosition+8+horizontalAdjust+rightScrollPixels,f=7&a,g=(192&a)<<2,h=layoutTableAddress+(a>>>3<<5),i=h+leftScrollCharsInPage;leftScroll2Pages&&leftScrollChars<32&&(i&=modeData.evenPageMask);for(var j=leftScrollCharsInPage?32-leftScrollCharsInPage:-1,k=0;k<32;++k){k===j&&(i=leftScroll2Pages&&leftScrollChars>=32?h&modeData.evenPageMask:h);var l=vram[i]|g;if(++i,debugModePatternInfoNames)l&=255,c=0===l||32===l?4293787648:4294967295,d=4278190080,b=vram[DEBUG_PAT_DIGI8_TABLE_ADDRESS+(l<<3)+f];else if(debugModePatternInfoBlocks){var m=vram[colorTableAddress+(l<<3)+f&colorTableAddressMask];c=colorPalette[m>>>4],d=colorPalette[15&m],b=vram[DEBUG_PAT_BLOCK_TABLE_ADDRESS+f]}else c=4294967295,d=4278190080,b=vram[patternTableAddress+(l<<3)+f&patternTableAddressMask];paintPattern8(e,b,c,d),e+=8}e-=rightScrollPixels+256,renderSpritesLineMode2(a,e,colorPaletteReal),leftMask&&paintBackdrop8(e),rightScrollPixels&&paintBackdrop8(e+256),renderWidth>500&&stretchCurrentLine(),bufferPosition+=bufferLineAdvance}function paintPattern6(a,b,c,d){frameBackBuffer[a]=128&b?c:d,frameBackBuffer[++a]=64&b?c:d,frameBackBuffer[++a]=32&b?c:d,frameBackBuffer[++a]=16&b?c:d,frameBackBuffer[++a]=8&b?c:d,frameBackBuffer[++a]=4&b?c:d}function paintPattern6a(a,b,c,d){for(var e=6;e>0;--e,++a)frameBackBuffer[a]=b>>e&4?c:d}function paintPattern8(a,b,c,d){frameBackBuffer[a]=128&b?c:d,frameBackBuffer[++a]=64&b?c:d,frameBackBuffer[++a]=32&b?c:d,frameBackBuffer[++a]=16&b?c:d,frameBackBuffer[++a]=8&b?c:d,frameBackBuffer[++a]=4&b?c:d,frameBackBuffer[++a]=2&b?c:d,frameBackBuffer[++a]=1&b?c:d}function paintBackdrop8(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop16(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop20(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop32(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,
frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop16Tiled(a){var b=backdropTileOdd,c=backdropTileEven;frameBackBuffer[a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c}function paintBackdrop32Tiled(a){var b=backdropTileOdd,c=backdropTileEven;frameBackBuffer[a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c,frameBackBuffer[++a]=b,frameBackBuffer[++a]=c}function renderSpritesLineMode1(a,b){if(!debugModeSpritesHidden&&208!==vram[spriteAttrTableAddress]){var c,d,e,f,g,h,i,j,k,l,m=spritesSize<<spritesMag,n=-1,o=0;spritesGlobalPriority-=32,c=spriteAttrTableAddress-4;for(var p=0;p<32&&(c+=4,n+=1,208!==(h=vram[c]));++p)if(!((i=a-h-1&255)>=m)){if(++o>4&&(spritesInvalid<0&&!F&&(spritesInvalid=n),spriteDebugModeLimit))return;d=vram[c+3],(isV9918||0!=(15&d)||color0Solid)&&(j=vram[c+1],128&d&&(j-=32)<=-m||(d&=15,16===spritesSize?(e=debugModeSpriteInfoNumbers?n<<2:252&vram[c+2],f=spritePatternTableAddress+(e<<3)+(i>>>spritesMag),g=vram[f]<<8|vram[f+16]):(e=debugModeSpriteInfoNumbers?n:vram[c+2],g=vram[spritePatternTableAddress+(e<<3)+(i>>>spritesMag)]),k=j<=256-m?0:j-(256-m),l=j>=0?m:m+j,j+=m-l,paintSpriteMode1(j,a,b+j,spritesGlobalPriority+n,g,d,k,l,spritesMag,spriteDebugModeCollisions&&o<5)))}spritesInvalid<0&&n>spritesMaxComputed&&(spritesMaxComputed=n)}}function paintSpriteMode1(a,b,c,d,e,f,g,h,i,j){for(var k=h-1;k>=g;--k,++a,++c){0!==(e>>>(k>>>i)&1)&&(spritesLinePriorities[a]<d?(j&&!spritesCollided&&setSpritesCollision(a,b),0!==f&&0===spritesLineColors[a]&&(spritesLineColors[a]=f,frameBackBuffer[c]=colorPaletteReal[f])):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,0!==f&&(frameBackBuffer[c]=colorPaletteReal[f])))}}function renderSpritesLineMode2(a,b,c){if(spritesEnabled&&216!==vram[spriteAttrTableAddress+512]){var d,e,f,g,h,i,j,k,l,m,n,o,p=spritesSize<<spritesMag,q=-1,r=SPRITE_MAX_PRIORITY,s=0;spritesGlobalPriority-=32,d=spriteAttrTableAddress+512-4,e=spriteAttrTableAddress-16;for(var t=0;t<32&&(q+=1,d+=4,e+=16,216!==(j=vram[d]));++t)if(!((k=a-j-1&255)>=p)){if(++s>8&&(spritesInvalid<0&&!F&&(spritesInvalid=q),spriteDebugModeLimit))return;if(k>>>=spritesMag,f=vram[e+k],o=64&f){if(r===SPRITE_MAX_PRIORITY||debugModeSpriteInfo)continue}else r=spritesGlobalPriority+q;(0!=(15&f)||color0Solid)&&(l=vram[d+1],128&f&&(l-=32)<=-p||(16===spritesSize?(g=debugModeSpriteInfoNumbers?q<<2:252&vram[d+2],h=spritePatternTableAddress+(g<<3)+k,i=vram[h]<<8|vram[h+16]):(g=debugModeSpriteInfoNumbers?q:vram[d+2],i=vram[spritePatternTableAddress+(g<<3)+k]),m=l<=256-p?0:l-(256-p),n=l>=0?p:p+l,l+=p-n,o?paintSpriteMode2CC(l,b+l,r,i,15&f,c,m,n,spritesMag):paintSpriteMode2(l,a,b+l,r,i,15&f,c,m,n,spritesMag,spriteDebugModeCollisions&&0==(32&f)&&s<9)))}spritesInvalid<0&&q>spritesMaxComputed&&(spritesMaxComputed=q)}}function paintSpriteMode2(a,b,c,d,e,f,g,h,i,j,k){for(var l=i-1;l>=h;--l,++a,++c){0!==(e>>>(l>>>j)&1)&&(spritesLinePriorities[a]<d?k&&!spritesCollided&&setSpritesCollision(a,b):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,frameBackBuffer[c]=g[f]))}}function paintSpriteMode2CC(a,b,c,d,e,f,g,h,i){for(var j,k=h-1;k>=g;--k,++a,++b){if(0!==(d>>>(k>>>i)&1)){var l=spritesLinePriorities[a];l<c||(l===c?j=e|spritesLineColors[a]:(spritesLinePriorities[a]=c,j=e),spritesLineColors[a]=j,frameBackBuffer[b]=f[j])}}}function renderSpritesLineMode2Tiled(a,b){if(spritesEnabled&&216!==vram[spriteAttrTableAddress+512]){var c,d,e,f,g,h,i,j,k,l,m,n,o=spritesSize<<spritesMag,p=-1,q=SPRITE_MAX_PRIORITY,r=0;spritesGlobalPriority-=32,c=spriteAttrTableAddress+512-4,d=spriteAttrTableAddress-16;for(var s=0;s<32&&(p+=1,c+=4,d+=16,216!==(i=vram[c]));++s)if(!((j=a-i-1&255)>=o)){if(++r>8&&(spritesInvalid<0&&!F&&(spritesInvalid=p),spriteDebugModeLimit))return;if(j>>>=spritesMag,e=vram[d+j],n=64&e){if(q===SPRITE_MAX_PRIORITY||debugModeSpriteInfo)continue}else q=spritesGlobalPriority+p;(0!=(15&e)||color0Solid)&&(k=vram[c+1],128&e&&(k-=32)<=-o||(16===spritesSize?(f=debugModeSpriteInfoNumbers?p<<2:252&vram[c+2],g=spritePatternTableAddress+(f<<3)+j,h=vram[g]<<8|vram[g+16]):(f=debugModeSpriteInfoNumbers?p:vram[c+2],h=vram[spritePatternTableAddress+(f<<3)+j]),l=k<=256-o?0:k-(256-o),m=k>=0?o:o+k,k+=o-m,n?paintSpriteMode2TiledCC(k,b+(k<<1),q,h,15&e,l,m,spritesMag):paintSpriteMode2Tiled(k,a,b+(k<<1),q,h,15&e,l,m,spritesMag,spriteDebugModeCollisions&&0==(32&e)&&r<9)))}spritesInvalid<0&&p>spritesMaxComputed&&(spritesMaxComputed=p)}}function paintSpriteMode2Tiled(a,b,c,d,e,f,g,h,i,j){for(var k=h-1;k>=g;--k,++a,c+=2){0!==(e>>>(k>>>i)&1)&&(spritesLinePriorities[a]<d?j&&!spritesCollided&&setSpritesCollision(a,b):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,frameBackBuffer[c]=colorPaletteReal[f>>>2],frameBackBuffer[c+1]=colorPaletteReal[3&f]))}}function paintSpriteMode2TiledCC(a,b,c,d,e,f,g,h){for(var i,j=g-1;j>=f;--j,++a,b+=2){if(0!==(d>>>(j>>>h)&1)){var k=spritesLinePriorities[a];k<c||(k===c?i=e|spritesLineColors[a]:(spritesLinePriorities[a]=c,i=e),spritesLineColors[a]=i,frameBackBuffer[b]=colorPaletteReal[i>>>2],frameBackBuffer[b+1]=colorPaletteReal[3&i])}}}function renderSpritesLineMode2Stretched(a,b){if(spritesEnabled&&216!==vram[spriteAttrTableAddress+512]){var c,d,e,f,g,h,i,j,k,l,m,n,o=spritesSize<<spritesMag,p=-1,q=SPRITE_MAX_PRIORITY,r=0;spritesGlobalPriority-=32,c=spriteAttrTableAddress+512-4,d=spriteAttrTableAddress-16;for(var s=0;s<32&&(p+=1,c+=4,d+=16,216!==(i=vram[c]));++s)if(!((j=a-i-1&255)>=o)){if(++r>8&&(spritesInvalid<0&&!F&&(spritesInvalid=p),spriteDebugModeLimit))return;if(j>>>=spritesMag,e=vram[d+j],n=64&e){if(q===SPRITE_MAX_PRIORITY||debugModeSpriteInfo)continue}else q=spritesGlobalPriority+p;(0!=(15&e)||color0Solid)&&(k=vram[c+1],128&e&&(k-=32)<=-o||(16===spritesSize?(f=debugModeSpriteInfoNumbers?p<<2:252&vram[c+2],g=spritePatternTableAddress+(f<<3)+j,h=vram[g]<<8|vram[g+16]):(f=debugModeSpriteInfoNumbers?p:vram[c+2],h=vram[spritePatternTableAddress+(f<<3)+j]),l=k<=256-o?0:k-(256-o),m=k>=0?o:o+k,k+=o-m,
n?paintSpriteMode2StretchedCC(k,b+(k<<1),q,h,15&e,l,m,spritesMag):paintSpriteMode2Stretched(k,a,b+(k<<1),q,h,15&e,l,m,spritesMag,spriteDebugModeCollisions&&0==(32&e)&&r<9)))}spritesInvalid<0&&p>spritesMaxComputed&&(spritesMaxComputed=p)}}function paintSpriteMode2Stretched(a,b,c,d,e,f,g,h,i,j){for(var k=h-1;k>=g;--k,++a,c+=2){0!==(e>>>(k>>>i)&1)&&(spritesLinePriorities[a]<d?j&&!spritesCollided&&setSpritesCollision(a,b):(spritesLinePriorities[a]=d,spritesLineColors[a]=f,frameBackBuffer[c]=frameBackBuffer[c+1]=colorPaletteReal[f]))}}function paintSpriteMode2StretchedCC(a,b,c,d,e,f,g,h){for(var i,j=g-1;j>=f;--j,++a,b+=2){if(0!==(d>>>(j>>>h)&1)){var k=spritesLinePriorities[a];k<c||(k===c?i=e|spritesLineColors[a]:(spritesLinePriorities[a]=c,i=e),spritesLineColors[a]=i,frameBackBuffer[b]=frameBackBuffer[b+1]=colorPaletteReal[i])}}}function setSpritesCollision(a,b){spritesCollided=!0,spritesCollisionX>=0||(spritesCollisionX=a+12,spritesCollisionY=b+8,0==(192&register[8])&&(status[3]=255&spritesCollisionX,status[4]=254|spritesCollisionX>>>8,status[5]=255&spritesCollisionY,status[6]=252|spritesCollisionY>>>8))}function stretchCurrentLine(){for(var a=bufferPosition+272-1,b=bufferPosition+544-2,c=272;c>0;--c,--a,b-=2)frameBackBuffer[b]=frameBackBuffer[b+1]=frameBackBuffer[a]}function stretchFromCurrentToTopScanline(){for(var a=bufferPosition,b=currentScanline;b>=startingVisibleTopBorderScanline;--b,a-=bufferLineAdvance)for(var c=a+272-1,d=a+544-2,e=272;e>0;--e,--c,d-=2)frameBackBuffer[d]=frameBackBuffer[d+1]=frameBackBuffer[c]}function cleanFrameBuffer(){wmsx.Util.arrayFill(frameBackBuffer,modeData.tiled?4278190080:backdropValue)}function refresh(){videoSignal.newFrame(frameCanvas,0,0,refreshWidth,refreshHeight),refreshWidth=refreshHeight=0}function beginFrame(){vSyncConnection.vSyncPulse(),framePulldown!==pulldown&&(frameVideoStandard=videoStandard,framePulldown=pulldown,updateSignalMetrics(!1)),currentScanline=0,frameStartingActiveScanline=startingActiveScanline,renderMetricsChangePending&&updateRenderMetrics(!0),!blinkPerLine&&blinkPageDuration>0&&clockPageBlinking(),EO^=1,!isV9918&&8&register[9]?(bufferPosition=EO?LINE_WIDTH:0,bufferLineAdvance=2*LINE_WIDTH):(bufferPosition=0,bufferLineAdvance=LINE_WIDTH),updateLayoutTableAddressMask()}function finishFrame(){videoDisplayed&&(refreshWidth=renderWidth,refreshHeight=renderHeight,frameContext.putImageData(frameImageData,0,0,0,0,refreshWidth,refreshHeight)),++frame,beginFrame()}function initRegisters(){wmsx.Util.arrayFill(register,0),wmsx.Util.arrayFill(status,0),register[9]=videoStandard===wmsx.VideoStandard.PAL?2:0,status[0]=0,F=0,status[1]=isV9958?4:0,FH=0,status[2]=12,VR=0,HR=0,EO=0,status[4]=254,status[6]=252,status[9]=254}function initFrameResources(a){(!frameCanvas||!frameContextUsingAlpha&&a)&&(frameContextUsingAlpha=!!a,frameCanvas=document.createElement("canvas"),frameCanvas.width=wmsx.VDP.SIGNAL_MAX_WIDTH_V9938,frameCanvas.height=wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938,frameContext=frameCanvas.getContext("2d",{alpha:frameContextUsingAlpha,antialias:!1}),frameImageData||(frameImageData=frameContext.createImageData(frameCanvas.width,frameCanvas.height+1+1),frameBackBuffer=new Uint32Array(frameImageData.data.buffer,0,frameCanvas.width*(frameCanvas.height+1)),backdropLineCache=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*(frameCanvas.height+1)*4,frameCanvas.width)))}function initColorCaches(){colorsV9918Values=wmsx.ColorCache.getColors4bit9918Values(),colors8bitValues=wmsx.ColorCache.getColors8bit9938Values(),colors9bitValues=wmsx.ColorCache.getColors9bit9938Values(),colorsYJKValues=void 0}function initColorPalette(){for(var a=0;a<16;++a){paletteRegister[a]=paletteRegisterInitialValuesV9938[a];var b=isV9918?colorsV9918Values[a]:getColorValueForPaletteValue(paletteRegister[a]);colorPaletteReal[a]=b,debugModeSpriteHighlight&&(b&=DEBUG_DIM_ALPHA_MASK),colorPalette[a]=b,colorPaletteSolid[a]=b}updateBackdropValue()}function initDebugPatternTables(){for(var a=[["111","101","101","101","111"],["110","010","010","010","111"],["111","001","111","100","111"],["111","001","111","001","111"],["101","101","111","001","001"],["111","100","111","001","111"],["111","100","111","101","111"],["111","001","001","001","001"],["111","101","111","101","111"],["111","101","111","001","001"],["110","001","111","101","111"],["100","100","111","101","110"],["000","111","100","100","111"],["001","001","111","101","111"],["110","101","111","100","011"],["011","100","110","100","100"]],b=DEBUG_PAT_DIGI6_TABLE_ADDRESS,c=DEBUG_PAT_DIGI8_TABLE_ADDRESS,d=DEBUG_PAT_DIGI16_TABLE_ADDRESS,e=DEBUG_PAT_BLOCK_TABLE_ADDRESS,f=0;f<256;f++){for(var g=f/16|0,h=f%16,i=0;i<5;i++)vram[b++]=parseInt(a[g][i]+a[h][i]+"00",2),vram[c++]=parseInt(a[g][i]+"0"+a[h][i]+"0",2);for(vram[b++]=vram[c++]=parseInt("00000000",2),vram[b++]=vram[c++]=parseInt("01111100",2),vram[b++]=vram[c++]=parseInt("00000000",2),vram[d++]=parseInt("11111111",2),i=0;i<4;i++)vram[d++]=parseInt("10000000",2);for(i=0;i<5;i++)vram[d++]=parseInt("1000"+a[g][i]+"0",2);for(i=0;i<5;i++)vram[d++]=parseInt("10000000",2);for(i=0;i<2;i++)vram[d++]=parseInt("11111111",2);for(i=0;i<4;i++)vram[d++]=parseInt("00000001",2);for(i=0;i<5;i++)vram[d++]=parseInt("0"+a[h][i]+"0001",2);for(i=0;i<5;i++)vram[d++]=parseInt("00000001",2);vram[d++]=parseInt("11111111",2)}vram[e]=vram[e+7]=0,vram[e+1]=vram[e+2]=vram[e+3]=vram[e+4]=vram[e+5]=vram[e+6]=126}function initSpritesConflictMap(){wmsx.Util.arrayFill(spritesLinePriorities,SPRITE_MAX_PRIORITY),wmsx.Util.arrayFill(spritesLineColors,0),spritesGlobalPriority=SPRITE_MAX_PRIORITY}function logInfo(a){console.log("VDP "+a+", currentScanLine: "+currentScanline+", activeRenderScanline: "+(currentScanline-frameStartingActiveScanline)+", activeHeight: "+signalActiveHeight)}var self=this;this.setMachineType=function(a){var b=WMSX.VDP_TYPE>0?WMSX.VDP_TYPE:a;isV9918=b<=M_TYPES.MSX1,isV9938=b===M_TYPES.MSX2,isV9958=b>=M_TYPES.MSX2P,cpuBusClockPulses=cpu.busClockPulses,cpuMemoryRefresh=cpu.r800MemoryRefresh},this.connectBus=function(a){a.connectInputDevice(152,this.input98),a.connectOutputDevice(152,this.output98),a.connectInputDevice(153,this.input99),a.connectOutputDevice(153,this.output99),a.connectInputDevice(154,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(154,this.output9a),a.connectInputDevice(155,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(155,this.output9b)},this.connectSlave=function(a){slave=a,slave&&slave.setVideoStandard(videoStandard),updateSignalMetrics(!0),updateRenderMetrics(!0)},this.powerOn=function(){this.reset()},this.powerOff=function(){videoSignal.signalOff()},this.setVideoStandard=function(a){videoStandard=a,updateSynchronization(),slave&&slave.setVideoStandard(videoStandard)},this.setVSynchMode=function(a){vSynchMode=a,updateSynchronization()},this.getVideoSignal=function(){return videoSignal},this.getDesiredVideoPulldown=function(){return pulldown},this.videoClockPulse=function(){cycleEvents(),refreshWidth&&refresh(),slave&&slave.cycleEventRefresh()},this.input98=function(){dataFirstWrite=null;var a=dataPreRead;return dataPreRead=vram[vramPointer],++vramPointer,checkVRAMPointerWrap(),a},this.output98=function(a){dataFirstWrite=null,vram[vramPointer]=dataPreRead=a,++vramPointer,checkVRAMPointerWrap()},this.input99=function(){dataFirstWrite=null;var a,b=register[15];switch(b){case 0:a=getStatus0();break;case 1:a=status[1]|FH,16&register[0]&&FH&&(FH=0,updateIRQ());break;case 2:commandProcessor.updateStatus(),a=status[2]|VR<<6|HR<<5|EO<<1;break;case 3:case 4:case 6:a=status[b];break;case 5:a=status[5],spritesCollisionX=spritesCollisionY=-1,status[3]=status[4]=status[5]=status[6]=0;break;case 7:a=status[7],commandProcessor.cpuRead();break;case 8:case 9:a=status[b];break;default:a=255}return a},this.output99=function(a){null===dataFirstWrite?(dataFirstWrite=a,
isV9918&&(vramPointer=-256&vramPointer|a)):(128&a?isV9918?(registerWrite(7&a,dataFirstWrite),vramPointer=114943&vramPointer|(63&a)<<8):0==(64&a)&&registerWrite(63&a,dataFirstWrite):(vramPointer=114688&vramPointer|(63&a)<<8|dataFirstWrite,0==(64&a)&&(dataPreRead=vram[vramPointer],++vramPointer,checkVRAMPointerWrap())),dataFirstWrite=null)},this.output9a=function(a){isV9918||(null===paletteFirstWrite?paletteFirstWrite=a:(paletteRegisterWrite(register[16],a<<8|paletteFirstWrite,!1),++register[16]>15&&(register[16]=0),paletteFirstWrite=null))},this.output9b=function(a){if(!isV9918){var b=63&register[17];17!==b&&registerWrite(b,a),0==(128&register[17])&&(register[17]=b+1&63)}},this.toggleDebugModes=function(a){return setDebugMode(debugMode+(a?-1:1)),videoSignal.showOSD("Debug Mode"+(debugMode>0?" "+debugMode:"")+": "+["OFF","Sprites Highlighted","Sprite Numbers","Sprite Names","Sprites Hidden","Pattern Bits","Pattern Color Blocks","Pattern Names"][debugMode],!0),debugMode},this.toggleSpriteDebugModes=function(a){setSpriteDebugMode(spriteDebugMode+(a?-1:1)),videoSignal.showOSD("Sprites Mode"+(spriteDebugMode>0?" "+spriteDebugMode:"")+": "+["Normal","Unlimited","NO Collisions","Unlimited, No Collisions"][spriteDebugMode],!0)},this.setColorAndPaletteMode=function(a,b){wmsx.ColorCache.setColorAndPaletteMode(a,b),initColorCaches(),updateAllPaletteValues()},this.getSpriteDebugModeQuickDesc=function(){return["Normal","Unlimited","No Collis.","Both"][spriteDebugMode]},this.setVDPTurboMulti=function(a){commandProcessor.setVDPTurboMulti(a)},this.getVDPTurboMulti=function(){return commandProcessor.getVDPTurboMulti()},this.setDefaults=function(){setDebugMode(STARTING_DEBUG_MODE),setSpriteDebugMode(STARTING_SPRITES_DEBUG_MODE)},this.videoSignalDisplayStateUpdate=function(a,b){videoDisplayed=a},this.refreshDisplayMetrics=function(){videoSignal.setDisplayMetrics(renderWidth,renderHeight)},this.resetOutputAutoMode=function(){},this.reset=function(){frame=0,dataFirstWrite=null,dataPreRead=0,vramPointer=0,paletteFirstWrite=null,verticalAdjust=horizontalAdjust=0,leftMask=leftScroll2Pages=!1,leftScrollChars=leftScrollCharsInPage=rightScrollPixels=0,backdropColor=backdropValue=0,spritesCollided=!1,spritesCollisionX=spritesCollisionY=spritesInvalid=-1,spritesMaxComputed=0,horizontalIntLine=0,vramInterleaving=!1,renderMetricsChangePending=!1,refreshWidth=refreshHeight=0,frameVideoStandard=videoStandard,framePulldown=pulldown,currentScanline=-1,initRegisters(),initColorPalette(),commandProcessor.reset(),updateSignalMetrics(!0),updateIRQ(),updateMode(!0),updateSpritesConfig(),updateBackdropColor(),updateTransparency(),updateSynchronization(),updateBlinking(),beginFrame()},this.getVDPCycles=function(){return 6*cpu.getBUSCycles()},this.getScreenText=function(){var a=modeData.textCols;if(!a)return null;for(var b=128&register[9]?27:24,c=[],d=0;d<b;++d)c.push(wmsx.Util.int8BitArrayToByteString(vram,layoutTableAddress+d*a,a).replace(/\s+$/,""));return c.join("\n").replace(/[\x00\xff]/g," ").replace(/\s+$/,"")};var LINE_WIDTH=wmsx.VDP.SIGNAL_MAX_WIDTH_V9938,SPRITE_MAX_PRIORITY=9e15,DEBUG_DIM_ALPHA_MASK=1090519039,VRAM_SIZE=wmsx.VDP.VRAM_LIMIT+1,DEBUG_PAT_DIGI6_TABLE_ADDRESS=VRAM_SIZE,DEBUG_PAT_DIGI8_TABLE_ADDRESS=DEBUG_PAT_DIGI6_TABLE_ADDRESS+2048,DEBUG_PAT_DIGI16_TABLE_ADDRESS=DEBUG_PAT_DIGI8_TABLE_ADDRESS+2048,DEBUG_PAT_BLOCK_TABLE_ADDRESS=DEBUG_PAT_DIGI16_TABLE_ADDRESS+8192,VRAM_TOTAL_SIZE=DEBUG_PAT_BLOCK_TABLE_ADDRESS+8,STARTING_DEBUG_MODE=WMSX.DEBUG_MODE,STARTING_SPRITES_DEBUG_MODE=WMSX.SPRITES_DEBUG_MODE,frameCanvas,frameContext,frameImageData,frameBackBuffer,backdropLineCache,frameContextUsingAlpha=!1,isV9918,isV9938,isV9958,vram=new Uint8Array(VRAM_TOTAL_SIZE);this.vram=vram;var vramInterleaving,frame,blinkEvenPage,blinkPageDuration,blinkPerLine,vSynchMode,videoStandard=wmsx.VideoStandard.NTSC,pulldown,bufferPosition,bufferLineAdvance,currentScanline,signalActiveHeight,finishingScanline,startingActiveScanline,frameStartingActiveScanline,startingVisibleTopBorderScanline,startingInvisibleScanline,frameVideoStandard=videoStandard,framePulldown,horizontalIntLine=0,status=new Array(10),F=0,FH=0,VR=0,HR=0,EO=0,register=new Array(47),paletteRegister=new Array(16),modeData,renderMetricsChangePending,renderWidth,renderHeight,refreshWidth,refreshHeight,blankingChangePending,backdropCacheUpdatePending,spritesEnabled,spritesSize,spritesMag,spritesCollided,spritesInvalid,spritesMaxComputed,spritesCollisionX,spritesCollisionY,spritesLinePriorities=new Array(256),spritesLineColors=new Array(256),spritesGlobalPriority,vramPointer=0,paletteFirstWrite,dataFirstWrite=null,dataPreRead=0,backdropColor,backdropValue,backdropTileOdd,backdropTileEven,verticalAdjust,horizontalAdjust,leftMask,leftScroll2Pages,leftScrollChars,leftScrollCharsInPage,rightScrollPixels,layoutTableAddress,colorTableAddress,patternTableAddress,spriteAttrTableAddress,spritePatternTableAddress,layoutTableAddressMask,layoutTableAddressMaskSetValue,colorTableAddressMask,patternTableAddressMask,layoutTableAddressMaskBase=1023,colorTableAddressMaskBase=63,patternTableAddressMaskBase=2047,modes=wmsx.Util.arrayFill(new Array(36),{name:"NUL",isV9938:!0,layTBase:0,colorTBase:0,patTBase:0,sprAttrTBase:0,width:256,layLineBytes:0,evenPageMask:-1,blinkPageMask:-1,renderLine:renderLineBlanked,renderLinePatInfo:renderLineBlanked,ppb:0,spriteMode:0,tiled:!1,vramInter:null,bdPaletted:!0,textCols:0});modes[16]={name:"T1",isV9938:!1,layTBase:-1024,colorTBase:0,patTBase:-2048,sprAttrTBase:0,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeT1,renderLinePatInfo:renderLineModeT1PatInfo,ppb:0,spriteMode:0,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:40},modes[18]={name:"T2",isV9938:!0,layTBase:-4096,colorTBase:-512,patTBase:-2048,sprAttrTBase:0,width:512,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeT2,renderLinePatInfo:renderLineModeT2PatInfo,ppb:0,spriteMode:0,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:80},modes[8]={name:"MC",isV9938:!1,layTBase:-1024,colorTBase:0,patTBase:-2048,sprAttrTBase:-128,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeMC,renderLinePatInfo:renderLineModeMCPatInfo,ppb:0,spriteMode:1,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[0]={name:"G1",isV9938:!1,layTBase:-1024,colorTBase:-64,patTBase:-2048,sprAttrTBase:-128,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeG1,renderLinePatInfo:renderLineModeG1PatInfo,ppb:0,spriteMode:1,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:32},modes[1]={name:"G2",isV9938:!1,layTBase:-1024,colorTBase:-8192,patTBase:-8192,sprAttrTBase:-128,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-1,renderLine:renderLineModeG2,renderLinePatInfo:renderLineModeG2PatInfo,ppb:0,spriteMode:1,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[2]={name:"G3",isV9938:!0,layTBase:-1024,colorTBase:-8192,patTBase:-8192,sprAttrTBase:-1024,width:256,layLineBytes:0,evenPageMask:-32769,blinkPageMask:-32769,renderLine:renderLineModeG3,renderLinePatInfo:renderLineModeG3PatInfo,ppb:0,spriteMode:2,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[3]={name:"G4",isV9938:!0,layTBase:-32768,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:128,evenPageMask:-32769,blinkPageMask:-32769,renderLine:renderLineModeG4,renderLinePatInfo:renderLineModeG4,ppb:2,spriteMode:2,tiled:!1,vramInter:!1,bdPaletted:!0,textCols:0},modes[4]={name:"G5",isV9938:!0,layTBase:-32768,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:512,layLineBytes:128,evenPageMask:-32769,blinkPageMask:-32769,renderLine:renderLineModeG5,renderLinePatInfo:renderLineModeG5,ppb:4,spriteMode:2,tiled:!0,vramInter:!1,bdPaletted:!0,textCols:0},modes[5]={name:"G6",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:512,layLineBytes:256,evenPageMask:-65537,
blinkPageMask:-65537,renderLine:renderLineModeG6,renderLinePatInfo:renderLineModeG6,ppb:2,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!0,textCols:0},modes[7]={name:"G7",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeG7,renderLinePatInfo:renderLineModeG7,ppb:1,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!1,textCols:0},modes[33]={name:"YJK",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeYJK,renderLinePatInfo:renderLineModeYJK,ppb:1,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!0,textCols:0},modes[35]={name:"YAE",isV9938:!0,layTBase:-65536,colorTBase:0,patTBase:0,sprAttrTBase:-1024,width:256,layLineBytes:256,evenPageMask:-65537,blinkPageMask:-65537,renderLine:renderLineModeYAE,renderLinePatInfo:renderLineModeYAE,ppb:1,spriteMode:2,tiled:!1,vramInter:!0,bdPaletted:!0,textCols:0};var renderLine,renderLineActive,colorsV9918Values,colors8bitValues,colors9bitValues,colorsYJKValues,color0Solid=!1,colorPalette=new Uint32Array(16),colorPaletteSolid=new Uint32Array(16),colorPaletteReal=new Uint32Array(16),spritePaletteG7=new Uint32Array([4278190080,4282974208,4278190189,4282974317,4278217984,4283002112,4278218093,4283002221,4283011839,4294901760,4278190335,4294902015,4278255360,4294967040,4278255615,4294967295]),paletteRegisterInitialValuesV9938=[0,0,1553,1843,279,807,337,1575,289,883,1633,1636,1041,613,869,1911],debugMode=0,debugModeSpriteHighlight=!1,debugModeSpriteInfo=!1,debugModeSpriteInfoNumbers=!1,debugModeSpritesHidden=!1,debugModePatternInfo=!1,debugModePatternInfoBlocks=!1,debugModePatternInfoNames=!1,spriteDebugMode=0,spriteDebugModeLimit=!0,spriteDebugModeCollisions=!0,debugBackdropValue=4280953386,debugLineStartBUSCycles=0,videoSignal,videoDisplayed=!0,cpuBusClockPulses,cpuMemoryRefresh,audioClockPulse32,commandProcessor,slave,M_TYPES=wmsx.Machine.MACHINE_TYPE;this.saveState=function(a){var b={v1:isV9918,v3:isV9938,v5:isV9958,f:frame,l:currentScanline,b:bufferPosition,ba:bufferLineAdvance,ad:renderLine===renderLineActive,fs:frameStartingActiveScanline,vp:vramPointer,d:dataFirstWrite,dr:dataPreRead,pw:paletteFirstWrite,ha:horizontalAdjust,va:verticalAdjust,hil:horizontalIntLine,lm:leftMask,ls2:leftScroll2Pages,lsc:leftScrollChars,rsp:rightScrollPixels,bp:blinkEvenPage,bpd:blinkPageDuration,bpl:blinkPerLine,sc:spritesCollided,sx:spritesCollisionX,sy:spritesCollisionY,si:spritesInvalid,sm:spritesMaxComputed,bf:F,bfh:FH,bvr:VR,bhr:HR,beo:EO,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),s:wmsx.Util.storeInt8BitArrayToStringBase64(status),p:wmsx.Util.storeInt16BitArrayToStringBase64(paletteRegister),vram:wmsx.Util.compressInt8BitArrayToStringBase64(vram,VRAM_SIZE),vrint:vramInterleaving,cp:commandProcessor.saveState()};return a&&(b.dm=debugMode,b.sd=spriteDebugMode),b},this.loadState=function(a){isV9918=a.v1,isV9938=a.v3,isV9958=a.v5,cpuBusClockPulses=cpu.busClockPulses,register=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r,register),status=wmsx.Util.restoreStringBase64ToInt8BitArray(a.s,status),paletteRegister=wmsx.Util.restoreStringBase64ToInt16BitArray(a.p,paletteRegister),vram=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.vram,vram,!0),frame=a.f||0,currentScanline=a.l,bufferPosition=a.b,bufferLineAdvance=a.ba,vramPointer=a.vp,dataFirstWrite=a.d,dataPreRead=a.dr||0,paletteFirstWrite=a.pw,horizontalAdjust=a.ha,verticalAdjust=a.va,horizontalIntLine=a.hil,leftMask=a.lm,leftScroll2Pages=a.ls2,leftScrollChars=a.lsc,rightScrollPixels=a.rsp,leftScrollCharsInPage=31&leftScrollChars,blinkEvenPage=a.bp,blinkPageDuration=a.bpd,blinkPerLine=void 0!==a.bpl?a.bpl:0!=(4&register[1]),spritesCollided=a.sc,spritesCollisionX=a.sx,spritesCollisionY=a.sy,spritesInvalid=a.si,spritesMaxComputed=a.sm,void 0!==a.bf?(F=a.bf,FH=a.bfh,VR=a.bvr,HR=a.bhr,EO=a.beo):(F=0|a.vi,FH=1&status[1],VR=status[2]>>6&1,HR=status[2]>>5&1,EO=status[2]>>1&1,status[0]&=-129,status[1]&=-2,status[2]&=-99),vramInterleaving=a.vrint,commandProcessor.loadState(a.cp),commandProcessor.connectVDP(this,vram,register,status),frameVideoStandard=videoStandard,framePulldown=pulldown,updateSignalMetrics(!0),void 0!==a.fs&&(frameStartingActiveScanline=a.fs),updateIRQ(),updateMode(!0),updateSpritesConfig(),updateAllPaletteValues(),updateBackdropColor(),updateTransparency(),a.ad?setActiveDisplay():setBorderDisplay(),void 0!==a.dm&&setDebugMode(a.dm),void 0!==a.sd&&setSpriteDebugMode(a.sd)},init(),this.logInfo=logInfo,this.eval=function(str){return eval(str)}},wmsx.VDP.VRAM_LIMIT=131071,wmsx.VDP.SIGNAL_WIDTH_V9918=272,wmsx.VDP.SIGNAL_HEIGHT_V9918=208,wmsx.VDP.SIGNAL_START_WIDTH_V9938=272,wmsx.VDP.SIGNAL_START_HEIGHT_V9938=228,wmsx.VDP.SIGNAL_MAX_WIDTH_V9938=544,wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938=456,wmsx.VDP.BASE_CLOCK=6*wmsx.CPU.BASE_CLOCK,wmsx.VDPCommandProcessor=function(){"use strict";function getSX(){return(1&register[33])<<8|register[32]}function getSY(){return(3&register[35])<<8|register[34]}function setSY(a){register[35]=a>>8&3,register[34]=255&a}function getDX(){return(1&register[37])<<8|register[36]}function getDY(){return(3&register[39])<<8|register[38]}function setDY(a){register[39]=a>>8&3,register[38]=255&a}function getNX(){return(1&register[41])<<8|register[40]}function getNY(){return(3&register[43])<<8|register[42]}function setNY(a){register[43]=a>>8&3,register[42]=255&a}function getDIX(){return 4&register[45]?-1:1}function getDIY(){return 8&register[45]?-1:1}function getCLR(){return register[44]}function setCLR(a){register[44]=a}function getMAJ(){return 1&register[45]}function getEQ(){return 0==(2&register[45])}function getLOP(){return LOGICAL_OPERATIONS[15&register[46]]}function HMMC(){var a=getDX();DY=getDY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),a>>=modePPBShift,NX>>=modePPBShift,a>=layoutLineBytes?(a&=layoutLineBytes-1,NX=1):(NX=NX||layoutLineBytes,NX=1===DIX?min(NX,layoutLineBytes-a):min(NX,a+1)),NY=NY||1024,ENY=1===DIY?NY:min(NY,DY+1),destPos=DY*layoutLineBytes+a,writeStart(HMMCNextWrite)}function HMMCNextWrite(a){vram[destPos&VRAM_LIMIT]=a,++CX,CX>=NX?(destPos-=DIX*(NX-1),CX=0,++CY,CY>=ENY?finish():destPos+=DIY*layoutLineBytes):destPos+=DIX,setDY(DY+DIY*CY),setNY(NY-CY)}function YMMM(){var a=getSY(),b=getDX(),c=getDY(),d=getNY(),e=getDIX(),f=getDIY();(b>>=modePPBShift)>=layoutLineBytes&&(b&=layoutLineBytes-1);var g=1===e?layoutLineBytes-b:b+1;d=d||1024;for(var h=1===f?d:min(d,min(a,c)+1),i=a*layoutLineBytes+b,j=c*layoutLineBytes+b,k=-e*g+layoutLineBytes*f,l=h;l>0;--l){for(var m=g;m>0;--m)vram[j&VRAM_LIMIT]=vram[i&VRAM_LIMIT],i+=e,j+=e;i+=k,j+=k}setSY(a+f*h),setDY(c+f*h),setNY(d-h),start(g*h,64,h,0)}function HMMM(){var a=getSX(),b=getSY(),c=getDX(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY();a>>=modePPBShift,c>>=modePPBShift,e>>=modePPBShift,a>=layoutLineBytes||c>=layoutLineBytes?(a&=layoutLineBytes-1,c&=layoutLineBytes-1,e=1):(e=e||layoutLineBytes,e=1===g?min(e,layoutLineBytes-max(a,c)):min(e,min(a,c)+1)),f=f||1024;for(var i=1===h?f:min(f,min(b,d)+1),j=b*layoutLineBytes+a,k=d*layoutLineBytes+c,l=-g*e+layoutLineBytes*h,m=i;m>0;--m){for(var n=e;n>0;--n)vram[k&VRAM_LIMIT]=vram[j&VRAM_LIMIT],j+=g,k+=g;j+=l,k+=l}setSY(b+h*i),setDY(d+h*i),setNY(f-i),start(e*i,88,i,64)}function HMMV(){var a=getDX(),b=getDY(),c=getNX(),d=getNY(),e=getCLR(),f=getDIX(),g=getDIY();a>>=modePPBShift,c>>=modePPBShift,a>=layoutLineBytes?(a&=layoutLineBytes-1,c=1):(c=c||layoutLineBytes,c=1===f?min(c,layoutLineBytes-a):min(c,a+1)),d=d||1024;for(var h=1===g?d:min(d,b+1),i=b*layoutLineBytes+a,j=-f*c+layoutLineBytes*g,k=h;k>0;--k){for(var l=c;l>0;--l)vram[i&VRAM_LIMIT]=e,i+=f;i+=j}setDY(b+g*h),setNY(d-h),start(c*h,48,h,56)}function LMMC(){DX=getDX(),DY=getDY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),LOP=getLOP(),DX>=modeWidth?(DX&=modeWidth-1,
NX=1):(NX=NX||modeWidth,NX=1===DIX?min(NX,modeWidth-DX):min(NX,DX+1)),NY=NY||1024,ENY=1===DIY?NY:min(NY,DY+1),writeStart(LMMCNextWrite)}function LMMCNextWrite(a){logicalPSET(DX,DY,a,LOP),++CX,CX>=NX?(DX-=DIX*(NX-1),CX=0,++CY,DY+=DIY,CY>=ENY&&finish()):DX+=DIX,setDY(DY),setNY(NY-CY)}function LMCM(){SX=getSX(),SY=getSY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),SX>=modeWidth?(SX&=modeWidth-1,NX=1):(NX=NX||modeWidth,NX=1===DIX?min(NX,modeWidth-SX):min(NX,SX+1)),NY=NY||1024,ENY=1===DIY?NY:min(NY,SY+1),readStart(LMCMNextRead)}function LMCMNextRead(){status[7]=normalPGET(SX,SY),++CX,CX>=NX?(SX-=DIX*(NX-1),CX=0,++CY,SY+=DIY,CY>=ENY&&finish()):SX+=DIX,setSY(SY),setNY(NY-CY)}function LMMM(){var a=getSX(),b=getSY(),c=getDX(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY(),i=getLOP();a>=modeWidth||c>=modeWidth?(a&=modeWidth-1,c&=modeWidth-1,e=1):(e=e||modeWidth,e=1===g?min(e,modeWidth-max(a,c)):min(e,min(a,c)+1)),f=f||1024;for(var j=1===h?f:min(f,min(b,d)+1),k=j;k>0;--k){for(var l=e;l>0;--l)logicalPCOPY(c,d,a,b,i),a+=g,c+=g;a-=g*e,c-=g*e,b+=h,d+=h}setSY(b),setDY(d),setNY(f-j),start(e*j,120,j,64)}function LMMV(){var a=getDX(),b=getDY(),c=getNX(),d=getNY(),e=getCLR(),f=getDIX(),g=getDIY(),h=getLOP();a>=modeWidth?(a&=modeWidth-1,c=1):(c=c||modeWidth,c=1===f?min(c,modeWidth-a):min(c,a+1)),d=d||1024;for(var i=1===g?d:min(d,b+1),j=i;j>0;--j){for(var k=c;k>0;--k)logicalPSET(a,b,e,h),a+=f;a-=f*c,b+=g}setDY(b),setNY(d-i),start(c*i,96,i,64)}function LINE(){var a=getDX(),b=getDY(),c=getNX(),d=getNY(),e=getCLR(),f=getDIX(),g=getDIY(),h=getMAJ(),i=getLOP(),j=modeWidth-1;a&=j;var k=0,l=0;if(0===h)for(var m=0;m<=c&&(logicalPSET(a,b,e,i),a+=f,d>0&&(l+=d)<<1>=c&&(b+=g,l-=c,++k),!(a>j||a<0||b<0));++m);else for(m=0;m<=c&&(logicalPSET(a,b,e,i),b+=g,d>0&&(l+=d)<<1>=c&&(a+=f,l-=c,++k),!(a>j||a<0||b<0));++m);setDY(b),start(m,112,k,32)}function SRCH(){var a=getSX(),b=getSY(),c=getCLR(),d=getDIX(),e=getEQ();a>=modeWidth&&(a&=modeWidth-1);var f=1===d?modeWidth:-1,g=a,h=!1;if(e)do{if(normalPGET(g,b)===c){h=!0;break}g+=d}while(g!==f);else do{if(normalPGET(g,b)!==c){h=!0;break}g+=d}while(g!==f);status[2]=-17&status[2]|(h?16:0),status[8]=255&g,status[9]=g>>8&1,start(Math.abs(g-a)+1,86,1,50)}function PSET(){var a=getDX(),b=getDY(),c=getCLR(),d=getLOP();a>=modeWidth&&(a&=modeWidth-1),logicalPSET(a,b,c,d),start(0,0,1,40)}function POINT(){var a=getSX(),b=getSY();a>=modeWidth&&(a&=modeWidth-1);var c=normalPGET(a,b);setCLR(c),status[7]=c,start(0,0,1,40)}function STOP(){finish()}function normalPGET(a,b){var c,d;switch(modePPB){case 2:c=1&a?0:4,a>>>=1,d=15<<c;break;case 4:c=2*(3-(3&a)),a>>>=2,d=3<<c;break;default:c=0,d=255}return(vram[b*layoutLineBytes+a&VRAM_LIMIT]&d)>>c}function logicalPSET(a,b,c,d){var e,f;switch(modePPB){case 2:e=1&a?0:4,a>>>=1,c=(15&c)<<e,f=15<<e;break;case 4:e=2*(3-(3&a)),a>>>=2,c=(3&c)<<e,f=3<<e;break;default:f=255}var g=b*layoutLineBytes+a;vram[g&VRAM_LIMIT]=d(vram[g&VRAM_LIMIT],c,f)}function logicalPCOPY(a,b,c,d,e){var f,g,h;switch(modePPB){case 2:f=1&c?0:4,g=1&a?0:4,c>>>=1,a>>>=1,h=15;break;case 4:f=2*(3-(3&c)),g=2*(3-(3&a)),c>>>=2,a>>>=2,h=3;break;default:f=g=0,h=255}var i=d*layoutLineBytes+c,j=b*layoutLineBytes+a,k=(vram[i&VRAM_LIMIT]>>f&h)<<g;vram[j&VRAM_LIMIT]=e(vram[j&VRAM_LIMIT],k,h<<g)}function lopIMP(a,b,c){return a&~c|b}function lopAND(a,b,c){return a&(b|~c)}function lopOR(a,b,c){return a|b}function lopXOR(a,b,c){return a^b}function lopNOT(a,b,c){return a&~c|~b&c}function lopTIMP(a,b,c){return 0===b?a:a&~c|b}function lopTAND(a,b,c){return 0===b?a:a&(b|~c)}function lopTOR(a,b,c){return 0===b?a:a|b}function lopTXOR(a,b,c){return a^b}function lopTNOT(a,b,c){return 0===b?a:a&~c|~b&c}function min(a,b){return a<b?a:b}function max(a,b){return a>b?a:b}function start(a,b,c,d,e){CE=1,writeHandler=null,readHandler=null,estimateDuration(a,b,c,d,e)}function estimateDuration(a,b,c,d,e){if(e)finishingCycle=-1;else if(0===turboClockMulti)finishingCycle=0;else{var f=(a*b*COMMAND_PER_PIXEL_DURATION_FACTOR+c*d)/turboClockMulti|0;finishingCycle=vdp.getVDPCycles()+f}}function writeStart(a){start(0,0,0,0,!0),CX=0,CY=0,writeHandler=a,TR=1,writeReady&&(writeHandler(getCLR()),writeReady=!1)}function readStart(a){start(0,0,0,0,!0),CX=0,CY=0,readHandler=a,TR=1,readHandler()}function finish(){CE=0,writeHandler=null,writeReady=!1,readHandler=null,register[46]&=-241}this.connectVDP=function(a,b,c,d){vdp=a,vram=b,register=c,status=d},this.reset=function(){STOP()},this.startCommand=function(a){switch(240&a){case 240:HMMC();break;case 224:YMMM();break;case 208:HMMM();break;case 192:HMMV();break;case 176:LMMC();break;case 160:LMCM();break;case 144:LMMM();break;case 128:LMMV();break;case 112:LINE();break;case 96:SRCH();break;case 80:PSET();break;case 64:POINT();break;case 0:STOP()}},this.cpuWrite=function(a){writeHandler?writeHandler(a):(writeReady=!0,TR=0)},this.cpuRead=function(){readHandler?readHandler():TR=0},this.updateStatus=function(){CE&&finishingCycle>=0&&(0===finishingCycle||vdp.getVDPCycles()>=finishingCycle)&&finish(),status[2]=-130&status[2]|TR<<7|CE},this.setVDPModeData=function(a){modeData=a,modeWidth=modeData.width,modePPB=modeData.ppb||1,modePPBShift=modePPB>>1,modePPBMask=-1<<modePPBShift,layoutLineBytes=modeData.layLineBytes||256},this.setVDPTurboMulti=function(a){turboClockMulti=a<0||a>8?0:a},this.getVDPTurboMulti=function(){return turboClockMulti};var VRAM_LIMIT=wmsx.VDP.VRAM_LIMIT,COMMAND_HANDLERS={HMMCNextWrite:HMMCNextWrite,LMMCNextWrite:LMMCNextWrite,LMCMNextRead:LMCMNextRead},COMMAND_PER_PIXEL_DURATION_FACTOR=1.1,LOGICAL_OPERATIONS=[lopIMP,lopAND,lopOR,lopXOR,lopNOT,lopIMP,lopIMP,lopIMP,lopTIMP,lopTAND,lopTOR,lopTXOR,lopTNOT,lopIMP,lopIMP,lopIMP],turboClockMulti=1,vdp,vram,register,status,CE=!1,TR=!1,SX,SY,DX,DY,NX,NY,ENY,DIX,DIY,CX,CY,LOP,destPos,writeReady=!1,writeHandler=null,readHandler=null,finishingCycle=0,modeData,modePPB,modePPBShift,modePPBMask,modeWidth,layoutLineBytes;this.saveState=function(){return{ce:CE,tr:TR,wr:writeReady,wh:writeHandler&&writeHandler.name,rh:readHandler&&readHandler.name,fc:finishingCycle,SX:SX,SY:SY,DX:DX,DY:DY,NX:NX,NY:NY,ENY:ENY,DIX:DIX,DIY:DIY,CX:CX,CY:CY,LOP:LOP&&LOGICAL_OPERATIONS.indexOf(LOP),dp:destPos,tcm:turboClockMulti}},this.loadState=function(a){CE=a.ce,TR=a.tr,writeReady=a.wr,writeHandler=COMMAND_HANDLERS[a.wh],readHandler=COMMAND_HANDLERS[a.rh],finishingCycle=a.fc,SX=a.SX,SY=a.SY,DX=a.DX,DY=a.DY,NX=a.NX,NY=a.NY,ENY=a.ENY,DIX=a.DIX,DIY=a.DIY,CX=a.CX,CY=a.CY,LOP=a.LOP>=0?LOGICAL_OPERATIONS[a.LOP]:void 0,destPos=a.dp,turboClockMulti=void 0!==a.tcm?a.tcm:1},this.eval=function(str){return eval(str)}},wmsx.V9990=function(){"use strict";function init(){videoSignal=new wmsx.VideoSignal(self,"V9990"),initColorCaches(),initFrameResources(!1),initDebugPatternTables(),modeData=modes.SBY,typeData=types.SBY,self.setDefaults(),commandProcessor=new wmsx.V9990CommandProcessor,commandProcessor.connectV9990(self,vram,register),commandProcessor.setV9990ModeData(modeData,typeData,imageWidth,imageHeight)}function softReset(){interruptFlags=0,vramPointerRead=0,vramPointerWrite=0,vramPointerReadInc=!0,vramPointerWriteInc=!0,vramReadData=0,palettePointer=0,palettePointerReadInc=!0,paletteOffsetA=0,paletteOffsetB=0,paletteOffset=0,scrollXOffset=0,scrollYOffset=0,scrollYOffsetFrame=0,scrollXBOffset=0,scrollYBOffset=0,scrollYBOffsetFrame=0,scrollYMax=0,scrollYHiUpdatePending=!1,scrollYBHiUpdatePending=!1,planeAEnabled=!0,planeBEnabled=!0,priBYLine=256,priBXCol=256,vramEOLineShift=0,vramEOLineAdd=0,verticalAdjust=horizontalAdjust=0,dispEnabled=!1,dispAndSpritesUpdatePending=!1,spritesEnabled=!0,horizontalIntLine=0,renderMetricsUpdatePending=!1,commandProcessor.reset(),initRegisters(),updateIRQ(),updateMode(!0),updateBackdropColor(),updateSynchronization(),commandProcessor.setV9990DisplayAndSpritesEnabled(dispEnabled,spritesEnabled),updateYSEnabled()}function updateVRAMReadPointer(){
vramPointerRead=(register[5]<<16|register[4]<<8|register[3])&VRAM_LIMIT,vramPointerReadInc=0==(128&register[5])}function updateVRAMWritePointer(a){vramPointerWrite=(register[2]<<16|register[1]<<8|register[0])&VRAM_LIMIT,vramPointerWriteInc=0==(128&register[2])}function updatePalettePointer(){palettePointer=register[14]}function updatePalettePointerReadInc(){palettePointerReadInc=0==(16&register[13])}function updatePaletteOffsets(){paletteOffsetA=(3&register[13])<<4,paletteOffsetB=(12&register[13])<<2,paletteOffset=paletteOffsetB<<2|paletteOffsetA}function updatePaletteOffsetCursor(){paletteOffsetCursor=(15&register[28])<<2}function updateYSEnabled(a){var b=superimposeActive&&0!=(32&register[8]),c=b?65535:32767;(a||ys16BitColorMask!==c)&&(ys16BitColorMask=c,updateAllPaletteValues(),colors8bitValues&&(colors8bitValues=wmsx.ColorCache.getColors8bit9990Values(b)))}function updateVRAMSize(){var a=3&register[8];a<2&&console.warn("Unsupported: V9990 Setting VRAM size < 512K !:",a)}function paletteRAMWrite(a,b){b!==paletteRAM[a]&&(paletteRAM[a]=b,updatePaletteValue(a>>2))}function registerWrite(a,b){var c=register[a]^b;switch(register[a]=b&REG_WRITE_MASK[a],a){case 0:case 1:case 2:updateVRAMWritePointer(a);break;case 3:case 4:updateVRAMReadPointer();break;case 5:updateVRAMReadPointer(),self.input60();break;case 6:240&c?updateMode():195&c?updateType():12&c&&updateImageSize();break;case 7:8&c&&updateVideoStandardSoft(),65&c?updateMode():2&c&&updateRenderMetrics();break;case 8:192&c&&(dispAndSpritesUpdatePending=!0),32&c&&updateYSEnabled(),3&c&&updateVRAMSize();break;case 9:7&c&&updateIRQ();break;case 10:c&&updateHorizontalIntLine();break;case 11:3&c&&updateHorizontalIntLine();break;case 12:15&c&&updateHorizontalIntX();break;case 13:224&c&&updateType(),16&c&&updatePalettePointerReadInc(),15&c&&updatePaletteOffsets();break;case 14:updatePalettePointer();break;case 15:63&c&&updateBackdropColor();break;case 16:15&c&&(horizontalAdjust=(15&b^7)-7),240&c&&(verticalAdjust=(b>>>4^7)-7,updateSignalMetrics(!1));break;case 17:updateScrollYLow();break;case 18:31&c&&(scrollYHiUpdatePending=!0),192&c&&updateScrollYMax();break;case 19:case 20:c&&updateScrollX();break;case 21:updateScrollYBLow();break;case 22:1&c&&(scrollYBHiUpdatePending=!0),192&c&&updatePlanesEnabled();break;case 23:case 24:c&&updateScrollXB();break;case 25:15&c&&updateSpritePattAddress();break;case 26:break;case 27:15&c&&updatePriorities();break;case 28:15&c&&updatePaletteOffsetCursor();break;case 52:commandProcessor.startCommand(b)}}function updateAllPaletteValues(){for(var a=63;a>=0;--a)updatePaletteValue(a)}function updatePaletteValue(a){var b=a<<2,c=ys16BitColorMask&((128&paletteRAM[b])<<8|(31&paletteRAM[b+1])<<10|(31&paletteRAM[b])<<5|31&paletteRAM[b+2]),d=colors16bitValues[c];paletteValuesReal[a]=d,debugModeSpriteHighlight&&(d&=DEBUG_DIM_ALPHA_MASK),paletteValues[a]=d,a===backdropColor&&updateBackdropValue()}function updateSynchronization(){pulldown=1===vSynchMode?videoStandard.pulldowns[machine.getVideoClockSocket().getVSynchNativeFrequency()]||videoStandard.pulldowns.TIMER:videoStandard.pulldowns.TIMER}function triggerVerticalInterrupt(){1&interruptFlags||(interruptFlags|=1,updateIRQ())}function triggerHorizontalInterrupt(){2&interruptFlags||(interruptFlags|=2,updateIRQ())}function updateIRQ(){register[9]&interruptFlags?cpu.setINTChannel(1,0):cpu.setINTChannel(1,1)}function updateMode(a){var b;switch(register[6]>>6){case 3:b=modes.SBY;break;case 0:b=modes.P1;break;case 1:b=modes.P2;break;case 2:switch(1&systemControl){case 0:switch((48&register[6])>>4){case 0:b=modes.B1;break;case 1:b=modes.B3;break;case 2:switch(65&register[7]){case 1:b=modes.B5;break;case 65:b=modes.B6;break;case 0:case 64:b=modes.B7}}break;case 1:switch((48&register[6])>>4){case 0:b=modes.B0;break;case 1:b=modes.B2;break;case 2:b=modes.B4}}}modeData=b||modes.SBY,updateType(),updateSpritePattAddress(),updateLineActiveType(),updateSignalMetrics(!1),updateRenderMetrics(a),updateVRAMInterleaving()}function updateType(){var a;switch(register[6]>>6){case 3:a=types.SBY;break;case 0:a=types.PP1;break;case 1:a=types.PP2;break;case 2:switch(3&register[6]){case 0:a=types.BP2;break;case 1:a=types.BP4;break;case 3:a=types.BD16;break;case 2:switch(register[13]>>6){case 0:a=types.BP6;break;case 1:a=types.BD8;break;case 2:case 3:switch(register[13]>>5){case 4:a=types.BYJK;break;case 5:a=types.BYJKP;break;case 6:a=types.BYUV;break;case 7:a=types.BYUVP}}}}typeData=a||types.SBY,updateImageSize()}function updateImageSize(){modeData===modes.P1?(imageWidth=256,imageHeight=2048):modeData===modes.P2?(imageWidth=512,imageHeight=2048):(imageWidth=256<<((12&register[6])>>2),imageHeight=VRAM_SIZE/(imageWidth*typeData.bpp>>3)),updateScrollYMax(),commandProcessor.setV9990ModeData(modeData,typeData,imageWidth,imageHeight)}function updateScrollYLow(){scrollYOffset=7936&scrollYOffset|register[17],scrollYOffsetFrame=currentScanline>frameStartingActiveScanline?scrollYOffset-(currentScanline-frameStartingActiveScanline):scrollYOffset,scrollYHiUpdatePending=!0}function updateScrollYHigh(){scrollYOffsetFrame=scrollYOffset=(31&register[18])<<8|255&scrollYOffset,scrollYHiUpdatePending=!1}function updateScrollX(){scrollXOffset=register[19]|register[20]<<3}function updateScrollYMax(){scrollYMax=128&register[18]?511:64&register[18]?255:modeData===modes.P1||modeData===modes.P2?511:imageHeight-1}function updateScrollYBLow(){scrollYBOffset=256&scrollYBOffset|register[21],scrollYBOffsetFrame=currentScanline>frameStartingActiveScanline?scrollYBOffset-(currentScanline-frameStartingActiveScanline):scrollYBOffset,scrollYBHiUpdatePending=!0}function updateScrollYBHigh(){scrollYBOffsetFrame=scrollYBOffset=(1&register[22])<<8|255&scrollYBOffset,scrollYBHiUpdatePending=!1}function updateScrollXB(){scrollXBOffset=register[23]|register[24]<<3}function updatePlanesEnabled(){planeAEnabled=0==(128&register[22]),planeBEnabled=0==(64&register[22])}function updatePriorities(){priBYLine=(register[27]>>2&3)<<6,0===priBYLine&&(priBYLine=256),0===(priBXCol=(3&register[27])<<6)&&(priBXCol=256)}function updateSpritePattAddress(){spritePattAddress=modeData===modes.P1?(14&register[25])<<14:(15&register[25])<<15}function updateHorizontalIntLine(){horizontalIntLine=(3&register[11])<<8|register[10]}function updateHorizontalIntX(){debugMode&&(15&register[12])>0&&logInfo("Unsupported: V9990 Horizontal INT X > 0 specified!")}function updateVideoStandardSoft(){var a=0!=(8&register[7]);machine.setVideoStandardSoft(a?wmsx.VideoStandard.PAL:wmsx.VideoStandard.NTSC)}function updateSignalMetrics(a){signalActiveHeight=modeData.height;var b=8*modeData.hasBorders,c=verticalAdjust;startingVisibleTopBorderScanline=16-(16-b),startingActiveScanline=startingVisibleTopBorderScanline+b+c,startingInvisibleScanline=startingActiveScanline+signalActiveHeight+b-c,a&&(frameStartingActiveScanline=startingActiveScanline,frameDoubleScan=modeData.doublesScan)}function updateRenderMetrics(a){var b,c,d,e=!1,f=!1;b=modeData.width+8*modeData.hasBorders*2*modeData.pixelWidthDiv,d=modeData.allowIL&&2&register[7]?2:1,c=(modeData.height+8*modeData.hasBorders*2)*d,renderMetricsUpdatePending=!1,b===renderWidth&&c===renderHeight||(b!==renderWidth&&(a?((currentScanline>=startingVisibleTopBorderScanline||b>renderWidth)&&(f=!0),renderWidth=b,e=!0):renderMetricsUpdatePending=!0),c!==renderHeight&&(a?((currentScanline>=startingVisibleTopBorderScanline||c>renderHeight)&&(f=!0),renderHeight=c,e=!0):renderMetricsUpdatePending=!0),f&&cleanFrameBuffer(),e&&self.refreshDisplayMetrics())}function enterActiveDisplay(){status&=-65,dispAndSpritesUpdatePending&&updateDispAndSpritesEnabled(),scrollYHiUpdatePending&&updateScrollYHigh(),scrollYBHiUpdatePending&&updateScrollYBHigh(),setActiveDisplay()}function setActiveDisplay(){renderLine=renderLineActive}function enterBorderDisplay(){status|=64,triggerVerticalInterrupt(),setBorderDisplay()}
function setBorderDisplay(){renderLine=renderLineBackdrop}function updateDispAndSpritesEnabled(){var a=0!=(128&register[8]);dispEnabled!==a&&(a&&cartridge.v9990DisplayEnabled(),dispEnabled=a),spritesEnabled=0==(64&register[8]),updateLineActiveType(),commandProcessor.setV9990DisplayAndSpritesEnabled(dispEnabled,spritesEnabled),dispAndSpritesUpdatePending=!1}function updateLineActiveType(){var a=renderLine===renderLineActive;renderLineActive=modeData===modes.SBY?renderLineModeSBY:dispEnabled?modeData.renderLine:renderLineBackdrop,a&&(renderLine=renderLineActive)}function updateBackdropColor(){backdropColor=63&register[15],updateBackdropValue()}function updateBackdropValue(){var a=debugModePatternInfo?debugBackdropValue:paletteValuesReal[backdropColor];backdropValue!==a&&(backdropValue=a,backdropCacheUpdatePending=!0)}function updateBackdropLineCache(){wmsx.Util.arrayFill(backdropLineCache,backdropValue),backdropCacheUpdatePending=!1}function renderLineBackdrop(){backdropCacheUpdatePending&&updateBackdropLineCache(),frameBackBuffer.set(backdropLineCache,bufferPosition),bufferPosition+=bufferLineAdvance}function paintBackdrop8(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop16(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop32(a){frameBackBuffer[a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue,frameBackBuffer[++a]=backdropValue}function paintBackdrop64(a){backdropCacheUpdatePending&&updateBackdropLineCache(),frameBackBuffer.set(backdrop64,a)}function paintBackdrop256(a){backdropCacheUpdatePending&&updateBackdropLineCache(),frameBackBuffer.set(backdrop256,a)}function paintBackdrop512(a){backdropCacheUpdatePending&&updateBackdropLineCache(),frameBackBuffer.set(backdrop512,a)}function renderLineModeSBY(){renderLineTypeSBY(bufferPosition),bufferPosition+=bufferLineAdvance}function renderLineModeP1(){renderLineTypePP1(bufferPosition+horizontalAdjust+8),paintBackdrop16(bufferPosition+horizontalAdjust-8),paintBackdrop16(bufferPosition+horizontalAdjust+8+256),bufferPosition+=bufferLineAdvance}function renderLineModeP2(){renderLineTypePP2(bufferPosition+(horizontalAdjust<<1)+16),paintBackdrop32(bufferPosition+(horizontalAdjust<<1)-16),paintBackdrop32(bufferPosition+(horizontalAdjust<<1)+16+512),bufferPosition+=bufferLineAdvance}function renderLineModeB0(){typeData.renderLine(bufferPosition+horizontalAdjust,192),paintBackdrop8(bufferPosition+horizontalAdjust-8),paintBackdrop8(bufferPosition+horizontalAdjust+192),bufferPosition+=bufferLineAdvance}function renderLineModeB1(){typeData.renderLine(bufferPosition+horizontalAdjust+8,256),paintBackdrop16(bufferPosition+horizontalAdjust-8),paintBackdrop16(bufferPosition+horizontalAdjust+8+256),bufferPosition+=bufferLineAdvance}function renderLineModeB2(){typeData.renderLine(bufferPosition+horizontalAdjust,384),paintBackdrop8(bufferPosition+horizontalAdjust-8),paintBackdrop8(bufferPosition+horizontalAdjust+384),bufferPosition+=bufferLineAdvance}function renderLineModeB3(){typeData.renderLine(bufferPosition+(horizontalAdjust<<1)+16,512),paintBackdrop32(bufferPosition+(horizontalAdjust<<1)-16),paintBackdrop32(bufferPosition+(horizontalAdjust<<1)+16+512),bufferPosition+=bufferLineAdvance}function renderLineModeB4(){typeData.renderLine(bufferPosition+(horizontalAdjust<<1),768),paintBackdrop16(bufferPosition+(horizontalAdjust<<1)-16),paintBackdrop16(bufferPosition+(horizontalAdjust<<1)+768),bufferPosition+=bufferLineAdvance}function renderLineModeB5(){typeData.renderLine(bufferPosition+(horizontalAdjust<<1),640),paintBackdrop16(bufferPosition+(horizontalAdjust<<1)-16),paintBackdrop16(bufferPosition+(horizontalAdjust<<1)+640),bufferPosition+=bufferLineAdvance}function renderLineModeB6(){typeData.renderLine(bufferPosition+(horizontalAdjust<<1),640),paintBackdrop16(bufferPosition+(horizontalAdjust<<1)-16),paintBackdrop16(bufferPosition+(horizontalAdjust<<1)+640),bufferPosition+=bufferLineAdvance}function renderLineModeB7(){typeData.renderLine(bufferPosition+(horizontalAdjust<<2)+32,1024),paintBackdrop64(bufferPosition+(horizontalAdjust<<2)-32),paintBackdrop64(bufferPosition+(horizontalAdjust<<2)+32+1024),bufferPosition+=bufferLineAdvance}function renderLineTypeSBY(a){frameBackBuffer.set(standByLineCache,a)}function renderLineTypePP1(a){paintBackdrop256(a),determineSpritesOnLine(currentScanline-frameStartingActiveScanline,261632);var b=currentScanline-frameStartingActiveScanline<priBYLine;b?renderLineTypePP1B(a):renderLineTypePP1A(a),renderSpritesLine(a,currentScanline-frameStartingActiveScanline,32,256,261632),b?renderLineTypePP1A(a):renderLineTypePP1B(a),renderSpritesLine(a,currentScanline-frameStartingActiveScanline,0,256,261632)}function renderLineTypePP1A(a){if(planeAEnabled){var b,c,d,e,f,g,h,i,j,k,l;e=511&scrollXOffset,b=a-(7&e),c=currentScanline-frameStartingActiveScanline+scrollYOffsetFrame&scrollYMax,d=7&c,f=507904+(c>>3<<6<<1),g=e>>3<<1,h=0|d<<7;for(var m=7&e?33:32;m>0;--m)i=vram[f+g]|vram[f+g+1]<<8,g=g+2&127,j=h+(i>>5<<10|(31&i)<<2),k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b}}function renderLineTypePP1B(a){if(planeBEnabled){var b,c,d,e,f,g,h,i,j,k,l;e=511&scrollXBOffset,b=a-(7&e),c=currentScanline-frameStartingActiveScanline+scrollYBOffsetFrame&511,d=7&c,f=516096+(c>>3<<6<<1),g=e>>3<<1,h=262144|d<<7;for(var m=7&e?33:32;m>0;--m)i=vram[f+g]|vram[f+g+1]<<8,g=g+2&127,j=h+(i>>5<<10|(31&i)<<2),k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,k=vram[j],++j,l=k>>4,
l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b}}function renderLineTypePP2(a){var b,c,d,e,f,g,h,i,j,k,l;if(paintBackdrop512(a),determineSpritesOnLine(currentScanline-frameStartingActiveScanline,507392),renderSpritesLine(a,currentScanline-frameStartingActiveScanline,32,512,507392),planeAEnabled){e=1023&scrollXOffset,b=a-(7&e),c=currentScanline-frameStartingActiveScanline+scrollYOffsetFrame&scrollYMax,d=7&c,f=507904+(c>>3<<7<<1),g=e>>3<<1,h=0|d<<8;for(var m=7&e?65:64;m>0;--m)i=vram[f+g]|vram[f+g+1]<<8,g=g+2&255,j=h+(i>>6<<11|(63&i)<<2),k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetA|l]),++b,k=vram[j],++j,l=k>>4,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b,l=15&k,l>0&&(frameBackBuffer[b]=paletteValues[paletteOffsetB|l]),++b}renderSpritesLine(a,currentScanline-frameStartingActiveScanline,0,512,507392)}function determineSpritesOnLine(a,b){if(spritesOnLineCount=0,spritesEnabled&&!debugModeSpritesHidden)for(var c=0;c<125;++c,b+=4){var d=vram[b],e=a-d-1&255;if(!(e>=16)&&(spritesOnLine[spritesOnLineCount]=c,++spritesOnLineCount>=16&&spriteDebugModeLimit))break}}function renderSpritesLine(a,b,c,d,e){for(var f=0,g=0,h=0,i=0,j=0,k=0,l=0,m=0,n=0,o=spritesOnLineCount-1;o>=0;--o)f=spritesOnLine[o],g=e+(f<<2),(48&(j=vram[g+3]))===c&&(k=vram[g],l=b-k-1&255,((m=vram[g+2]|(3&j)<<8)<d||m>=1008)&&(h=(192&j)>>2,i=debugModeSpriteInfoNumbers?f<<2:vram[g+1],n=256===d?spritePattAddress+((i>>4<<11)+((15&i)<<3))+(l<<7):spritePattAddress+((i>>5<<12)+((31&i)<<3))+(l<<8),m>=d&&(m-=1024),paintSprite(a+m,n,h)))}function paintSprite(a,b,c){for(var d=0,e=0,f=8;f>0;--f)d=vram[b],++b,e=d>>4,e>0&&(frameBackBuffer[a]=paletteValuesReal[c|e]),++a,e=15&d,e>0&&(frameBackBuffer[a]=paletteValuesReal[c|e]),++a}function renderLineTypeBYUV(a,b){colorsYUVValues||(colorsYUVValues=wmsx.ColorCache.getColorsYUVValues()),renderLineTypeBYxx(colorsYUVValues,a,b)}function renderLineTypeBYUVP(a,b){colorsYUVValues||(colorsYUVValues=wmsx.ColorCache.getColorsYUVValues()),renderLineTypeBYxxP(colorsYUVValues,a,b)}function renderLineTypeBYJK(a,b){colorsYJKValues||(colorsYJKValues=wmsx.ColorCache.getColorsYJKValues()),renderLineTypeBYxx(colorsYJKValues,a,b)}function renderLineTypeBYJKP(a,b){colorsYJKValues||(colorsYJKValues=wmsx.ColorCache.getColorsYJKValues()),renderLineTypeBYxxP(colorsYJKValues,a,b)}function renderLineTypeBYxx(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;e=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,i=e*imageWidth,g=imageWidth-1,j=-4&scrollXOffset&g,h=3&scrollXOffset,f=c+(h?4:0),d=b-h;for(var p=f;p>0;p-=4)k=vram[i+j],l=vram[i+j+1],m=vram[i+j+2],n=vram[i+j+3],j=j+4&g,o=(7&n)<<9|(7&m)<<6|(7&l)<<3|7&k,frameBackBuffer[d]=a[(248&k)<<9|o],++d,frameBackBuffer[d]=a[(248&l)<<9|o],++d,frameBackBuffer[d]=a[(248&m)<<9|o],++d,frameBackBuffer[d]=a[(248&n)<<9|o],++d;renderCursorsLine(b,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,c)}function renderLineTypeBYxxP(a,b,c){var d,e,f,g,h,i,j,k,l,m,n,o;e=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,i=e*imageWidth,g=imageWidth-1,j=-4&scrollXOffset&g,h=3&scrollXOffset,f=c+(h?4:0),d=b-h;for(var p=c>512?-33&paletteOffsetB:paletteOffsetB,q=c>512?32|paletteOffsetB:paletteOffsetB,r=f;r>0;r-=4)k=vram[i+j],l=vram[i+j+1],m=vram[i+j+2],n=vram[i+j+3],j=j+4&g,o=(7&n)<<9|(7&m)<<6|(7&l)<<3|7&k,frameBackBuffer[d]=8&k?paletteValues[p|k>>4]:a[(248&k)<<9|o],++d,frameBackBuffer[d]=8&l?paletteValues[q|l>>4]:a[(248&l)<<9|o],++d,frameBackBuffer[d]=8&m?paletteValues[p|m>>4]:a[(248&m)<<9|o],++d,frameBackBuffer[d]=8&n?paletteValues[q|n>>4]:a[(248&n)<<9|o],++d;renderCursorsLine(b,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,c)}function renderLineTypeBD16(a,b){var c,d,e,f,g,h,i;d=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,g=d*(imageWidth<<1),f=(imageWidth<<1)-1,h=modeData.width>256?(-2&scrollXOffset)<<1&f:scrollXOffset<<1&f,e=b<<1,c=a;for(var j=e;j>0;j-=2)i=ys16BitColorMask&(vram[g+h]|vram[g+h+1]<<8),h=h+2&f,frameBackBuffer[c]=colors16bitValues[i],++c;renderCursorsLine(a,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,b)}function renderLineTypeBD8(a,b){var c,d,e,f,g,h,i;colors8bitValues||(colors8bitValues=wmsx.ColorCache.getColors8bit9990Values(32767!==ys16BitColorMask)),d=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,g=d*imageWidth,f=imageWidth-1,h=scrollXOffset&f,e=b,c=a;for(var j=e;j>0;--j)i=vram[g+h],h=h+1&f,frameBackBuffer[c]=colors8bitValues[i],++c;renderCursorsLine(a,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,b)}function renderLineTypeBP6(a,b){var c,d,e,f,g,h,i;d=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,g=d*imageWidth,f=imageWidth-1,h=scrollXOffset&f,e=b,c=a;for(var j=e;j>0;--j)i=vram[g+h],h=h+1&f,frameBackBuffer[c]=paletteValues[63&i],++c;renderCursorsLine(a,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,b)}function renderLineTypeBP4(a,b){var c,d,e,f,g,h,i,j;d=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,h=d*(imageWidth>>1),f=(imageWidth>>1)-1,i=scrollXOffset>>1&f,g=1&scrollXOffset,e=(b>>1)+g,c=a-g;for(var k=b>512?-33&paletteOffsetB:paletteOffsetB,l=b>512?32|paletteOffsetB:paletteOffsetB,m=e;m>0;--m)j=vram[h+i],i=i+1&f,frameBackBuffer[c]=paletteValues[k|j>>4],++c,frameBackBuffer[c]=paletteValues[l|15&j],++c;renderCursorsLine(a,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,b)}function renderLineTypeBP2(a,b){var c,d,e,f,g,h,i,j;d=(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd+scrollYOffsetFrame&scrollYMax,h=d*(imageWidth>>2),f=(imageWidth>>2)-1,i=scrollXOffset>>2&f,g=3&scrollXOffset,e=(b>>2)+(g?1:0),c=a-g;for(var k=b>512?-33&paletteOffset:paletteOffset,l=b>512?32|paletteOffset:paletteOffset,m=e;m>0;--m)j=vram[h+i],i=i+1&f,frameBackBuffer[c]=paletteValues[k|j>>6],++c,frameBackBuffer[c]=paletteValues[l|j>>4&3],++c,frameBackBuffer[c]=paletteValues[k|j>>2&3],++c,frameBackBuffer[c]=paletteValues[l|3&j],++c;renderCursorsLine(a,(currentScanline-frameStartingActiveScanline<<vramEOLineShift)+vramEOLineAdd,b)}function renderCursorsLine(a,b,c){if(spritesEnabled&&!debugModeSpritesHidden)for(var d=0,e=!1,f=0,g=0,h=0,i=0,j=0,k=0,l=523784,m=1;m>=0;--m,l-=8)h=vram[l]|(1&vram[l+2])<<8,(i=b-h-(1<<vramEOLineShift)&511)>=32||0==(16&(g=vram[l+6]))&&((j=vram[l+4]|(3&g)<<8)<c||j>=992)&&(d=(192&g)>>6,e=0!=(32&g),f=debugModeSpriteInfoNumbers?m<<2:m,k=524032+(i<<2)+(f<<7),j>=c&&(j-=1024),paintCursor(a+j,k,d,e))}function paintCursor(a,b,c,d){var e=0,f=0;if(0!==c){f=paletteValuesReal[paletteOffsetCursor|c],d&&(f=4278190080&f|16777215&~f);for(var g=4;g>0;--g)e=vram[b],++b,128&e&&(frameBackBuffer[a]=f),++a,64&e&&(frameBackBuffer[a]=f),++a,32&e&&(frameBackBuffer[a]=f),++a,16&e&&(frameBackBuffer[a]=f),++a,8&e&&(frameBackBuffer[a]=f),++a,
4&e&&(frameBackBuffer[a]=f),++a,2&e&&(frameBackBuffer[a]=f),++a,1&e&&(frameBackBuffer[a]=f),++a}else if(d)for(g=4;g>0;--g)e=vram[b],++b,128&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,64&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,32&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,16&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,8&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,4&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,2&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a,1&e&&(f=frameBackBuffer[a],frameBackBuffer[a]=4278190080&f|16777215&~f),++a}function cleanFrameBuffer(){wmsx.Util.arrayFill(frameBackBuffer,backdropValue)}function refresh(){videoSignal.newFrame(frameCanvas,0,0,refreshWidth,refreshHeight),refreshWidth=refreshHeight=0}function beginFrame(){if(framePulldown!==pulldown&&(frameVideoStandard=videoStandard,framePulldown=pulldown,updateSignalMetrics(!1)),renderMetricsUpdatePending&&updateRenderMetrics(!0),status^=2,modeData.allowIL&&2&register[7]){bufferLineAdvance=PAINT_WIDTH<<1;var a=0!=(4&register[7]);vramEOLineShift=a?1:0,2&status?(bufferPosition=PAINT_WIDTH<<1,vramEOLineAdd=a?1:0):(bufferPosition=PAINT_WIDTH,vramEOLineAdd=0)}else bufferLineAdvance=PAINT_WIDTH,bufferPosition=PAINT_WIDTH,vramEOLineShift=0,vramEOLineAdd=0;currentScanline=0,frameStartingActiveScanline=startingActiveScanline,frameDoubleScan=modeData.doublesScan,currentScanline>=frameStartingActiveScanline&&enterActiveDisplay()}function updateVRAMInterleaving(){vramInterleaving!==(modeData!==modes.P1)&&(vramInterleaving=modeData!==modes.P1,vramInterleaving?self.vramEnterInterleaving():self.vramExitInterleaving())}function initRAM(){vramInterleaving=!1;for(var a=0;a<VRAM_SIZE;a+=1024)wmsx.Util.arrayFill(vram,0,a,a+512),wmsx.Util.arrayFill(vram,255,a+512,a+1024)}function initRegisters(){wmsx.Util.arrayFill(register,0),register[7]=videoStandard===wmsx.VideoStandard.PAL?8:0}function initFrameResources(a){(!frameCanvas||!frameContextUsingAlpha&&a)&&(frameContextUsingAlpha=!!a,frameCanvas=document.createElement("canvas"),frameCanvas.width=PAINT_WIDTH,frameCanvas.height=wmsx.V9990.SIGNAL_MAX_HEIGHT+1,frameContext=frameCanvas.getContext("2d",{alpha:frameContextUsingAlpha,antialias:!1}),frameImageData||(frameImageData=frameContext.createImageData(frameCanvas.width,frameCanvas.height+1+1),frameBackBuffer=new Uint32Array(frameImageData.data.buffer,0,frameCanvas.width*frameCanvas.height),backdropLineCache=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*frameCanvas.height*4,frameCanvas.width),standByLineCache=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*(frameCanvas.height+1)*4,272),backdrop64=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*frameCanvas.height*4,64),backdrop256=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*frameCanvas.height*4,256),backdrop512=new Uint32Array(frameImageData.data.buffer,frameCanvas.width*frameCanvas.height*4,512),wmsx.Util.arrayFill(standByLineCache,standByValue)))}function initColorCaches(){colors16bitValues=wmsx.ColorCache.getColors16bitValues(),colors8bitValues=void 0,colorsYUVValues=void 0,colorsYJKValues=void 0}function initColorPalette(){wmsx.Util.arrayFill(paletteRAM,0);for(var a=0;a<64;++a)paletteValuesReal[a]=paletteValues[a]=solidBlackValue}function initDebugPatternTables(){for(var a=[["111","101","101","101","111"],["110","010","010","010","111"],["111","001","111","100","111"],["111","001","111","001","111"],["101","101","111","001","001"],["111","100","111","001","111"],["111","100","111","101","111"],["111","001","001","001","001"],["111","101","111","101","111"],["111","101","111","001","001"],["110","001","111","101","111"],["100","100","111","101","110"],["000","111","100","100","111"],["001","001","111","101","111"],["110","101","111","100","011"],["011","100","110","100","100"]],b=DEBUG_PAT_DIGI6_TABLE_ADDRESS,c=DEBUG_PAT_DIGI8_TABLE_ADDRESS,d=DEBUG_PAT_DIGI16_TABLE_ADDRESS,e=DEBUG_PAT_BLOCK_TABLE_ADDRESS,f=0;f<256;f++){for(var g=f/16|0,h=f%16,i=0;i<5;i++)vram[b++]=parseInt(a[g][i]+a[h][i]+"00",2),vram[c++]=parseInt(a[g][i]+"0"+a[h][i]+"0",2);for(vram[b++]=vram[c++]=parseInt("00000000",2),vram[b++]=vram[c++]=parseInt("01111100",2),vram[b++]=vram[c++]=parseInt("00000000",2),vram[d++]=parseInt("11111111",2),i=0;i<4;i++)vram[d++]=parseInt("10000000",2);for(i=0;i<5;i++)vram[d++]=parseInt("1000"+a[g][i]+"0",2);for(i=0;i<5;i++)vram[d++]=parseInt("10000000",2);for(i=0;i<2;i++)vram[d++]=parseInt("11111111",2);for(i=0;i<4;i++)vram[d++]=parseInt("00000001",2);for(i=0;i<5;i++)vram[d++]=parseInt("0"+a[h][i]+"0001",2);for(i=0;i<5;i++)vram[d++]=parseInt("00000001",2);vram[d++]=parseInt("11111111",2)}vram[e]=vram[e+7]=0,vram[e+1]=vram[e+2]=vram[e+3]=vram[e+4]=vram[e+5]=vram[e+6]=126}function logInfo(a){console.log("V9990 "+a+", currentScanLine: "+currentScanline+", activeRenderScanline: "+(currentScanline-frameStartingActiveScanline))}var self=this;this.connect=function(a,b){machine=a,vdp=machine.vdp,cpu=machine.cpu,cartridge=b,machine.vdp.connectSlave(this),machine.bus.connectOutputDevice(96,this.output60),machine.bus.connectInputDevice(96,this.input60),machine.bus.connectOutputDevice(97,this.output61),machine.bus.connectInputDevice(97,this.input61),machine.bus.connectOutputDevice(98,this.output62),machine.bus.connectInputDevice(98,this.input62),machine.bus.connectOutputDevice(99,this.output63),machine.bus.connectInputDevice(99,this.input63),machine.bus.connectOutputDevice(100,this.output64),machine.bus.connectInputDevice(100,wmsx.DeviceMissing.inputPortIgnored),machine.bus.connectOutputDevice(101,wmsx.DeviceMissing.outputPortIgnored),machine.bus.connectInputDevice(101,this.input65),machine.bus.connectOutputDevice(102,this.output66),machine.bus.connectInputDevice(102,this.input66),machine.bus.connectOutputDevice(103,this.output67),machine.bus.connectInputDevice(103,wmsx.DeviceMissing.inputPortIgnored),machine.bus.connectOutputDevice(104,this.output68),machine.bus.connectInputDevice(104,wmsx.DeviceMissing.inputPortIgnored),machine.bus.connectOutputDevice(105,this.output69),machine.bus.connectInputDevice(105,this.input69),machine.bus.connectOutputDevice(106,this.output6a),machine.bus.connectInputDevice(106,wmsx.DeviceMissing.inputPortIgnored),machine.bus.connectOutputDevice(107,this.output6b),machine.bus.connectInputDevice(107,this.input6b),updateIRQ()},this.disconnect=function(a){machine=vdp=cpu=cartridge=void 0,a.vdp.connectSlave(void 0),a.bus.disconnectInputDevice(96,this.input60),a.bus.disconnectOutputDevice(96,this.output60),a.bus.disconnectInputDevice(97,this.input61),a.bus.disconnectOutputDevice(97,this.output61),a.bus.disconnectInputDevice(98,this.input62),a.bus.disconnectOutputDevice(98,this.output62),a.bus.disconnectInputDevice(99,this.input63),a.bus.disconnectOutputDevice(99,this.output63),a.bus.disconnectInputDevice(100,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(100,this.output64),a.bus.disconnectInputDevice(101,this.input65),a.bus.disconnectOutputDevice(101,wmsx.DeviceMissing.outputPortIgnored),a.bus.disconnectInputDevice(102,this.input66),a.bus.disconnectOutputDevice(102,this.output66),a.bus.disconnectInputDevice(103,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(103,this.output67)},this.powerOn=function(){initRAM(),initColorPalette(),this.reset()},this.powerOff=function(){videoSignal.signalOff()},this.setVideoStandard=function(a){videoStandard=a,updateSynchronization()},this.setVSynchMode=function(a){vSynchMode=a,updateSynchronization()},this.getVideoSignal=function(){return videoSignal},this.input60=function(){var a=vramReadData;return vramReadData=vram[vramPointerRead],
vramPointerReadInc&&++vramPointerRead>VRAM_LIMIT&&(vramPointerRead&=VRAM_LIMIT),a},this.output60=function(a){softResetON||(vram[vramPointerWrite]=a,vramPointerWriteInc&&++vramPointerWrite>VRAM_LIMIT&&(vramPointerWrite&=VRAM_LIMIT))},this.input61=function(){if(softResetON)return paletteRAM[0];if(3==(3&palettePointer))return palettePointerReadInc&&(palettePointer&=252),0;var a=paletteRAM[palettePointer];return palettePointerReadInc&&(2==(3&palettePointer)?palettePointer=palettePointer+2&255:++palettePointer),a},this.output61=function(a){return softResetON?paletteRAMWrite(0,0):3==(3&palettePointer)?palettePointer&=-4:(a&=0==(3&palettePointer)?159:31,paletteRAMWrite(palettePointer,a),void(2==(3&palettePointer)?palettePointer=palettePointer+2&255:++palettePointer))},this.input62=function(){return commandProcessor.cpuRead()},this.output62=function(a){commandProcessor.cpuWrite(a)},this.input63=function(){var a=register[registerSelect]|REG_READ_OR[registerSelect];return registerSelectReadInc&&++registerSelect>63&&(registerSelect&=63),a},this.output63=function(a){softResetON||registerWrite(registerSelect,a),registerSelectWriteInc&&++registerSelect>63&&(registerSelect&=63)},this.output64=function(a){softResetON&&(a=0),registerSelect=63&a,registerSelectWriteInc=0==(128&a),registerSelectReadInc=0==(64&a)},this.input65=function(){return commandProcessor.updateStatus(),status},this.input66=function(){return interruptFlags},this.output66=function(a){0!=(7&a)&&(interruptFlags&=~a,updateIRQ())},this.output67=function(a){var b=systemControl^a;systemControl=a,2&b&&(softResetON=0!=(2&systemControl))&&softReset(),1&b&&(status=-5&status|(1&systemControl)<<2,updateMode())},this.output68=function(a){kanjiPort1Address=129024&kanjiPort1Address|(63&a)<<5},this.output69=function(a){kanjiPort1Address=(63&a)<<11|2016&kanjiPort1Address},this.input69=function(){var a=self.readKanji(kanjiPort1Address);return kanjiPort1Address=131040&kanjiPort1Address|kanjiPort1Address+1&31,a},this.output6a=function(a){kanjiPort2Address=260096&kanjiPort2Address|(63&a)<<5},this.output6b=function(a){kanjiPort2Address=131072|(63&a)<<11|2016&kanjiPort2Address},this.input6b=function(){var a=self.readKanji(kanjiPort2Address);return kanjiPort2Address=262112&kanjiPort2Address|kanjiPort2Address+1&31,a},this.readKanji=function(a){var b=wmsx.CartridgeKanjiFont.connectedInstance;return b?b.readKanji(a):255},this.setTurboMulti=function(a){commandProcessor.setTurboMulti(a)},this.getVDPTurboMulti=function(){return commandProcessor.getVDPTurboMulti()},this.setDefaults=function(){self.setDebugMode(STARTING_DEBUG_MODE),self.setSpriteDebugMode(STARTING_SPRITES_DEBUG_MODE)},this.videoSignalDisplayStateUpdate=function(a,b){videoDisplayed=a,superimposeActive!==b&&(superimposeActive=b,superimposeActive&&initFrameResources(!0),updateYSEnabled())},this.refreshDisplayMetrics=function(){videoSignal.setDisplayMetrics(renderWidth,renderHeight)},this.resetOutputAutoMode=function(){cartridge&&cartridge.resetOutputAutoMode()},this.reset=function(){systemControl=0,status=0,softResetON=!1,registerSelect=0,registerSelectReadInc=!0,registerSelectWriteInc=!0,kanjiPort1Address=0,kanjiPort2Address=131072,softReset(),updateSignalMetrics(!0),frame=cycles=lastBUSCyclesComputed=0,frameVideoStandard=videoStandard,framePulldown=pulldown,currentScanline=-1,beginFrame()},this.getVDPCycles=function(){return vdp.getVDPCycles()},this.getScreenText=function(){},this.setStatusTR=function(a){a?status|=128:status&=-129},this.setStatusBD=function(a){a?status|=16:status&=-17},this.setStatusCE=function(a){a?status|=1:status&=-2},this.setDebugMode=function(a){debugMode=(a+8)%8;var b=debugModeSpriteHighlight;debugModeSpriteHighlight=debugMode>=1&&debugMode<=3,debugModeSpriteInfo=2===debugMode||3===debugMode,debugModeSpriteInfoNumbers=2===debugMode,debugModeSpritesHidden=debugMode>=4;var c=debugModePatternInfo;debugModePatternInfo=debugMode>=5,debugModePatternInfoBlocks=6===debugMode,debugModePatternInfoNames=7===debugMode,b===debugModeSpriteHighlight&&c===debugModePatternInfo||updateAllPaletteValues(),debugModeSpriteHighlight&&initFrameResources(!0),updateLineActiveType(),updateSpritePattAddress()},this.setSpriteDebugMode=function(a){spriteDebugMode=a>=0?a%4:4+a,spriteDebugModeLimit=0===spriteDebugMode||2===spriteDebugMode},this.setColorAndPaletteMode=function(a,b){initColorCaches(),updateAllPaletteValues()},this.cycleEventRefresh=function(){refreshWidth&&refresh()},this.lineEventStartActiveDisplay=function(){status&=-33,currentScanline===frameStartingActiveScanline&&enterActiveDisplay(),currentScanline-frameStartingActiveScanline===horizontalIntLine&&triggerHorizontalInterrupt()},this.lineEventRenderLine=function(){videoDisplayed&&currentScanline>=startingVisibleTopBorderScanline&&currentScanline<startingInvisibleScanline&&renderLine()},this.lineEventEndActiveDisplay=function(){frameDoubleScan&&(++currentScanline,this.lineEventRenderLine()),status|=32,currentScanline-frameStartingActiveScanline==signalActiveHeight-1&&enterBorderDisplay()},this.lineEventEnd=function(){++currentScanline},this.triggerCommandCompletionInterrupt=function(){4&interruptFlags||(interruptFlags|=4,updateIRQ())},this.frameEventFinishFrame=function(){videoDisplayed&&(refreshWidth=renderWidth,refreshHeight=renderHeight,frameContext.putImageData(frameImageData,0,-1,0,1,refreshWidth,refreshHeight)),++frame,beginFrame()},this.vramEnterInterleaving=function(){for(var a=0,b=VRAM_SIZE>>1,c=vram.slice(0,b),d=0;d<VRAM_SIZE;d+=2,++a,++b)vram[d]=c[a],vram[d+1]=vram[b]},this.vramExitInterleaving=function(){for(var a=VRAM_SIZE>>1,b=0,c=a,d=vram.slice(a),e=0;e<a;e+=2,++b,++c)vram[b]=vram[e],vram[c]=vram[e+1];for(e=0;e<a;e+=2,++b,++c)vram[b]=d[e],vram[c]=d[e+1]};var LINE_WIDTH=wmsx.V9990.SIGNAL_MAX_WIDTH,PAINT_WIDTH=LINE_WIDTH+64,SPRITE_MAX_PRIORITY=9e15,DEBUG_DIM_ALPHA_MASK=1090519039,VRAM_LIMIT=wmsx.V9990.VRAM_LIMIT,VRAM_SIZE=VRAM_LIMIT+1,DEBUG_PAT_DIGI6_TABLE_ADDRESS=VRAM_SIZE,DEBUG_PAT_DIGI8_TABLE_ADDRESS=DEBUG_PAT_DIGI6_TABLE_ADDRESS+2048,DEBUG_PAT_DIGI16_TABLE_ADDRESS=DEBUG_PAT_DIGI8_TABLE_ADDRESS+2048,DEBUG_PAT_BLOCK_TABLE_ADDRESS=DEBUG_PAT_DIGI16_TABLE_ADDRESS+8192,VRAM_TOTAL_SIZE=DEBUG_PAT_BLOCK_TABLE_ADDRESS+8,STARTING_DEBUG_MODE=WMSX.DEBUG_MODE,STARTING_SPRITES_DEBUG_MODE=WMSX.SPRITES_DEBUG_MODE,REG_WRITE_MASK=[255,255,135,255,255,135,255,255,255,135,255,131,15,255,255,255,255,255,223,7,255,255,193,7,63,207,255,255,15,0,0,0,255,7,255,15,255,7,255,15,255,15,255,15,15,31,255,255,255,255,255,255,255,0,0,0,0,0,0,0,0,0,0],REG_READ_OR=[255,255,255,255,255,255,0,0,0,0,0,0,0,255,255,0,0,0,0,0,0,0,0,0,0,0,0,0,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,255,0,0,255,255,255,255,255,255,255,255],frameCanvas,frameContext,frameImageData,frameBackBuffer,backdropLineCache,standByLineCache,backdrop64,backdrop256,backdrop512,frameContextUsingAlpha=!1,vram=new Uint8Array(VRAM_TOTAL_SIZE);this.vram=vram
;var frame=0,vSynchMode=0,videoStandard=wmsx.VideoStandard.NTSC,pulldown,bufferPosition=0,bufferLineAdvance=0,currentScanline=-1,cycles=0,lastBUSCyclesComputed=0,signalActiveHeight=0,startingActiveScanline=0,frameStartingActiveScanline=0,startingVisibleTopBorderScanline=0,startingInvisibleScanline=0,frameDoubleScan=!1,frameVideoStandard=videoStandard,framePulldown,horizontalIntLine=0,status=0,interruptFlags=0,systemControl=0,softResetON=!1,registerSelect=0,registerSelectReadInc=!0,registerSelectWriteInc=!0,vramPointerRead=0,vramPointerWrite=0,vramPointerReadInc=!0,vramPointerWriteInc=!0,vramReadData=0,palettePointer=0,palettePointerReadInc=!0,paletteOffsetA=0,paletteOffsetB=0,paletteOffset=0,paletteOffsetCursor=0,ys16BitColorMask=32767,superimposeActive=!1,register=new Array(64),paletteRAM=new Array(256),modeData,typeData,imageWidth=0,imageHeight=0,vramInterleaving=!1,backdropColor=0,backdropCacheUpdatePending=!0,scrollXOffset=0,scrollYOffset=0,scrollYOffsetFrame=0,scrollXBOffset=0,scrollYBOffset=0,scrollYBOffsetFrame=0,scrollYMax=0,scrollYHiUpdatePending=!1,scrollYBHiUpdatePending=!1,planeAEnabled=!0,planeBEnabled=!0,priBYLine=256,priBXCol=256,verticalAdjust=0,horizontalAdjust=0,spritePattAddress=0,spritesOnLine=wmsx.Util.arrayFill(new Array(126),0),spritesOnLineCount=0,dispEnabled=!1,spritesEnabled=!0,dispAndSpritesUpdatePending=!1,renderMetricsUpdatePending=!1,renderWidth=wmsx.V9990.SIGNAL_START_WIDTH,renderHeight=wmsx.V9990.SIGNAL_START_HEIGHT,refreshWidth=0,refreshHeight=0,vramEOLineShift=0,vramEOLineAdd=0,modes={SBY:{name:"SBY",width:256,height:212,pixelWidthDiv:1,hasBorders:1,allowIL:!1,cmdTiming:0,doublesScan:!1,renderLine:renderLineModeSBY},P1:{name:"P1",width:256,height:212,pixelWidthDiv:1,hasBorders:1,allowIL:!1,cmdTiming:2,doublesScan:!1,renderLine:renderLineModeP1},P2:{name:"P2",width:512,height:212,pixelWidthDiv:2,hasBorders:1,allowIL:!1,cmdTiming:3,doublesScan:!1,renderLine:renderLineModeP2},B0:{name:"B0",width:192,height:240,pixelWidthDiv:1,hasBorders:0,allowIL:!0,cmdTiming:1,doublesScan:!1,renderLine:renderLineModeB0},B1:{name:"B1",width:256,height:212,pixelWidthDiv:1,hasBorders:1,allowIL:!0,cmdTiming:0,doublesScan:!1,renderLine:renderLineModeB1},B2:{name:"B2",width:384,height:240,pixelWidthDiv:1,hasBorders:0,allowIL:!0,cmdTiming:1,doublesScan:!1,renderLine:renderLineModeB2},B3:{name:"B3",width:512,height:212,pixelWidthDiv:2,hasBorders:1,allowIL:!0,cmdTiming:0,doublesScan:!1,renderLine:renderLineModeB3},B4:{name:"B4",width:768,height:240,pixelWidthDiv:2,hasBorders:0,allowIL:!0,cmdTiming:1,doublesScan:!1,renderLine:renderLineModeB4},B5:{name:"B5",width:640,height:400,pixelWidthDiv:2,hasBorders:0,allowIL:!1,cmdTiming:0,doublesScan:!0,renderLine:renderLineModeB5},B6:{name:"B6",width:640,height:480,pixelWidthDiv:2,hasBorders:0,allowIL:!1,cmdTiming:0,doublesScan:!0,renderLine:renderLineModeB6},B7:{name:"B7",width:1024,height:212,pixelWidthDiv:4,hasBorders:1,allowIL:!0,cmdTiming:0,doublesScan:!1,renderLine:renderLineModeB7}},types={SBY:{name:"SBY",bpp:8,ppB:1,renderLine:renderLineTypeSBY},PP1:{name:"PP1",bpp:4,ppB:2,renderLine:renderLineTypePP1},PP2:{name:"PP2",bpp:4,ppB:2,renderLine:renderLineTypePP2},BYUV:{name:"BYUV",bpp:8,ppB:1,renderLine:renderLineTypeBYUV},BYUVP:{name:"BYUVP",bpp:8,ppB:1,renderLine:renderLineTypeBYUVP},BYJK:{name:"BYJK",bpp:8,ppB:1,renderLine:renderLineTypeBYJK},BYJKP:{name:"BYJKP",bpp:8,ppB:1,renderLine:renderLineTypeBYJKP},BD16:{name:"BD16",bpp:16,ppB:0,renderLine:renderLineTypeBD16},BD8:{name:"BD8",bpp:8,ppB:1,renderLine:renderLineTypeBD8},BP6:{name:"BP6",bpp:8,ppB:1,renderLine:renderLineTypeBP6},BP4:{name:"BP4",bpp:4,ppB:2,renderLine:renderLineTypeBP4},BP2:{name:"BP2",bpp:2,ppB:4,renderLine:renderLineTypeBP2}},renderLine,renderLineActive,solidBlackValue=4278190080,notPaintedValue=4294902015,standByValue=solidBlackValue,backdropValue=solidBlackValue,colors16bitValues,colors8bitValues,colorsYUVValues,colorsYJKValues,paletteValues=new Uint32Array(64),paletteValuesReal=new Uint32Array(64),kanjiPort1Address=0,kanjiPort2Address=0,debugMode=0,debugModeSpriteHighlight=!1,debugModeSpriteInfo=!1,debugModeSpriteInfoNumbers=!1,debugModeSpritesHidden=!1,debugModePatternInfo=!1,debugModePatternInfoBlocks=!1,debugModePatternInfoNames=!1,spriteDebugMode=0,spriteDebugModeLimit=!0,debugBackdropValue=4280953386,debugLineStartBUSCycles=0,machine,vdp,cpu,cartridge,videoSignal,videoDisplayed=!1,commandProcessor;this.saveState=function(a){var b={s:status,if:interruptFlags,sc:systemControl,sro:softResetON,rs:registerSelect,rri:registerSelectReadInc,rwi:registerSelectWriteInc,vr:vramPointerRead,vw:vramPointerWrite,vri:vramPointerReadInc,vwi:vramPointerWriteInc,vrd:vramReadData,vi:vramInterleaving,pp:palettePointer,pri:palettePointerReadInc,poa:paletteOffsetA,pob:paletteOffsetB,po:paletteOffset,poc:paletteOffsetCursor,l:currentScanline,b:bufferPosition,ba:bufferLineAdvance,ad:renderLine===renderLineActive,fs:frameStartingActiveScanline,fd:frameDoubleScan,f:frame,c:cycles,cc:lastBUSCyclesComputed,sx:scrollXOffset,sy:scrollYOffset,syf:scrollYOffsetFrame,sxb:scrollXBOffset,syb:scrollYBOffset,sybf:scrollYBOffsetFrame,sym:scrollYMax,syu:scrollYHiUpdatePending,sybu:scrollYBHiUpdatePending,pa:planeAEnabled,pb:planeBEnabled,pby:priBYLine,pbx:priBXCol,de:dispEnabled,se:spritesEnabled,dsu:dispAndSpritesUpdatePending,ha:horizontalAdjust,va:verticalAdjust,hil:horizontalIntLine,eos:vramEOLineShift,eoa:vramEOLineAdd,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),p:wmsx.Util.storeInt8BitArrayToStringBase64(paletteRAM),vram:wmsx.Util.compressInt8BitArrayToStringBase64(vram,VRAM_SIZE),k1a:kanjiPort1Address,k2a:kanjiPort2Address,cp:commandProcessor.saveState()};return a&&(b.dm=debugMode,b.sd=spriteDebugMode),b},this.loadState=function(a){status=a.s,interruptFlags=a.if,systemControl=a.sc,softResetON=a.sro,registerSelect=a.rs,registerSelectReadInc=a.rri,registerSelectWriteInc=a.rwi,vramPointerRead=a.vr,vramPointerWrite=a.vw,vramPointerReadInc=a.vri,vramPointerWriteInc=a.vwi,vramReadData=a.vrd,vramInterleaving=!!a.vi,palettePointer=a.pp,palettePointerReadInc=a.pri,paletteOffsetA=a.poa,paletteOffsetB=a.pob,paletteOffset=a.po,paletteOffsetCursor=a.poc,register=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r,register),paletteRAM=wmsx.Util.restoreStringBase64ToInt8BitArray(a.p,paletteRAM),vram=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.vram,vram,!0),currentScanline=a.l,bufferPosition=a.b,bufferLineAdvance=a.ba,frame=a.f||0,cycles=a.c,lastBUSCyclesComputed=a.cc,scrollXOffset=a.sx,scrollYOffset=a.sy,scrollYOffsetFrame=a.syf,scrollXBOffset=a.sxb,scrollYBOffset=a.syb,scrollYBOffsetFrame=a.sybf,scrollYMax=a.sym,scrollYHiUpdatePending=a.syu,scrollYBHiUpdatePending=a.sybu,planeAEnabled=a.pa,planeBEnabled=a.pb,priBYLine=a.pby,priBXCol=a.pbx,dispEnabled=a.de,spritesEnabled=a.se,dispAndSpritesUpdatePending=a.dsu,horizontalAdjust=a.ha,verticalAdjust=a.va,horizontalIntLine=a.hil,vramEOLineShift=a.eos,vramEOLineAdd=a.eoa,kanjiPort1Address=a.k1a||0,kanjiPort2Address=a.k2a||131072,commandProcessor.loadState(a.cp),commandProcessor.connectV9990(this,vram,register),frameVideoStandard=videoStandard,framePulldown=pulldown,updateSignalMetrics(!0),void 0!==a.fs&&(frameStartingActiveScanline=a.fs),void 0!==a.fd&&(frameDoubleScan=a.fd),cpu&&updateIRQ(),updateMode(!0),updateYSEnabled(!0),updateBackdropColor(),a.ad?setActiveDisplay():setBorderDisplay(),void 0!==a.dm&&self.setDebugMode(a.dm),void 0!==a.sd&&self.setSpriteDebugMode(a.sd)},init(),this.logInfo=logInfo,this.eval=function(str){return eval(str)},this.TEST=0,this.register=register,this.registerWrite=registerWrite},wmsx.V9990.VRAM_LIMIT=524287,wmsx.V9990.SIGNAL_START_WIDTH=272,wmsx.V9990.SIGNAL_START_HEIGHT=228,wmsx.V9990.SIGNAL_MAX_WIDTH=1088,wmsx.V9990.SIGNAL_MAX_HEIGHT=480,wmsx.V9990.BASE_CLOCK=wmsx.VDP.BASE_CLOCK,wmsx.V9990CommandProcessor=function(){"use strict";function getSX(){
return((7&register[33])<<8|register[32])&imageWidthMask}function setSX(a){a=getSX()&~imageWidthMask|a&imageWidthMask,register[33]=a>>8&15,register[32]=255&a}function getSY(){return((15&register[35])<<8|register[34])&imageHeightMask}function setSY(a){a=getSY()&~imageHeightMask|a&imageHeightMask,register[35]=a>>8&15,register[34]=255&a}function getSourcePlaneBOffset(){return isP1&&2&register[33]?2048:0}function getSA(){return(7&register[35])<<16|register[34]<<8|register[32]}function setSA(a){register[35]=a>>16&7,register[34]=a>>8&255,register[32]=255&a}function getKA(){return(3&register[35])<<16|register[34]<<8|register[32]}function getDX(){return((7&register[37])<<8|register[36])&imageWidthMask}function setDX(a){a=getDX()&~imageWidthMask|a&imageWidthMask,register[37]=a>>8&7,register[36]=255&a}function getDY(){return((15&register[39])<<8|register[38])&imageHeightMask}function setDY(a){a=getDY()&~imageHeightMask|a&imageHeightMask,register[39]=a>>8&15,register[38]=255&a}function getDestPlaneBOffset(){return isP1&&2&register[37]?2048:0}function getDA(){return(7&register[39])<<16|register[38]<<8|register[36]}function setDA(a){register[39]=a>>16&7,register[38]=a>>8&255,register[36]=255&a}function getNX(){return(7&register[41])<<8|register[40]||2048}function getNY(){return(15&register[43])<<8|register[42]||4096}function getNA(){return(7&register[43])<<16|register[42]<<8|register[40]||524288}function getMJ(){return(15&register[41])<<8|register[40]}function getMI(){return(15&register[43])<<8|register[42]}function getDIX(){return 4&register[44]?-1:1}function getDIY(){return 8&register[44]?-1:1}function getMAJ(){return 1&register[44]}function getNEQ(){return 0!=(2&register[44])}function getLOP(){return LOGICAL_OPERATIONS[31&register[45]]}function getWMDirect(){return register[46]<<8|register[47]}function getWM(a){return isP1?a?register[47]<<8|register[47]:register[46]<<8|register[46]:getWMDirect()}function wm8ForAddr(a,b){return a>>((1&~b)<<3)&255}function wm16ForAddr(a,b){return a>>((1&b)<<3)&255|a<<((1&b)<<3)&65280}function getFC(a){return isP1?a?register[49]<<8|register[49]:register[48]<<8|register[48]:register[48]<<8|register[49]}function getBC(a){return isP1?a?register[51]<<8|register[51]:register[50]<<8|register[50]:register[50]<<8|register[51]}function getAYME(){return register[52]>>2&3}function getAXME(){return 3&register[52]}function setBX(a){register[54]=a>>8,register[53]=255&a}function LMMC(){DX=getDX(),DESTOff=getDestPlaneBOffset(),DY=getDY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),LOP=getLOP(),WM=getWM(DESTOff),EDX=DX,CX=0,CY=0,SX=0,writeStart(LMMCNextWrite)}function LMMCNextWrite(a){4===typeBPP?(a|=a<<8,LMMCNextPixel(a),CE&&LMMCNextPixel(a)):8===typeBPP?LMMCNextPixel(a<<8|a):16===typeBPP?null===writeDataPending?writeDataPending=a:(LMMCNextPixel(writeDataPending<<8|a),writeDataPending=null):(a|=a<<8,LMMCNextPixel(a),CE&&LMMCNextPixel(a),CE&&LMMCNextPixel(a),CE&&LMMCNextPixel(a)),CE||(setDY(DY),v9990.setStatusTR(0))}function LMMCNextPixel(a){logicalPSETX(EDX,DY|DESTOff,SX,a,LOP,WM),++CX,++SX,CX>=NX?(EDX=DX,CX=0,++CY,DY=DY+DIY&imageHeightMask,CY>=NY&&finish()):EDX=EDX+DIX&imageWidthMask}function LMMV(){for(var a=getDX(),b=getDestPlaneBOffset(),c=getDY(),d=getNX(),e=getNY(),f=getDIX(),g=getDIY(),h=getLOP(),i=getWM(b),j=getFC(b),k=e;k>0;--k){for(var l=a,m=0;m<d;++m)logicalPSETX(l,c|b,l,j,h,i),l=l+f&imageWidthMask;c=c+g&imageHeightMask}setDY(c),start(LMMVTiming,d*e,e)}function LMCM(){SX=getSX(),SRCOff=getSourcePlaneBOffset(),SY=getSY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),ESX=SX,CX=0,CY=0,readStart(LMCMNextRead)}function LMCMNextRead(){4===typeBPP?(readData=15&readData|LMCMNextPixel(2),CE&&(readData=240&readData|LMCMNextPixel(3))):8===typeBPP?readData=LMCMNextPixel(1):16===typeBPP?null===readDataPending?(readDataPending=LMCMNextPixel(0),readData=readDataPending>>8):(readData=255&readDataPending,readDataPending=null):(readData=63&readData|LMCMNextPixel(4),CE&&(readData=207&readData|LMCMNextPixel(5)),CE&&(readData=243&readData|LMCMNextPixel(6)),CE&&(readData=252&readData|LMCMNextPixel(7))),CE||(setSY(SY),v9990.setStatusTR(0))}function LMCMNextPixel(a){var b=normalPGETX(ESX,SY|SRCOff,a);return++CX,CX>=NX?(ESX=SX,CX=0,++CY,SY=SY+DIY&imageHeightMask,CY>=NY&&finish()):ESX=ESX+DIX&imageWidthMask,b}function LMMM(){for(var a=getSX(),b=getSourcePlaneBOffset(),c=getSY(),d=getDX(),e=getDestPlaneBOffset(),f=getDY(),g=getNX(),h=getNY(),i=getDIX(),j=getDIY(),k=getLOP(),l=getWM(e),m=h;m>0;--m){for(var n=a,o=d,p=g;p>0;--p)logicalPCOPYXX(o,f|e,n,c|b,k,l),n=n+i&imageWidthMask,o=o+i&imageWidthMask;c=c+j&imageHeightMask,f=f+j&imageHeightMask}setSY(c),setDY(f),start(LMMMTiming,g*h,h)}function CMMC(){DX=getDX(),DESTOff=getDestPlaneBOffset(),DY=getDY(),NX=getNX(),NY=getNY(),DIX=getDIX(),DIY=getDIY(),LOP=getLOP(),WM=getWM(DESTOff),FBC=getFC(DESTOff)<<16|getBC(DESTOff),EDX=DX,CX=0,CY=0,writeStart(CMMCNextWrite)}function CMMCNextWrite(a){for(var b=7;b>=0;--b){if(logicalPSETX(EDX,DY|DESTOff,EDX,FBC>>((a>>b&1)<<4)&65535,LOP,WM),++CX>=NX){if(EDX=DX,CX=0,++CY,DY=DY+DIY&imageHeightMask,CY>=NY){finish();break}}else EDX=EDX+DIX&imageWidthMask}CE||(setDY(DY),v9990.setStatusTR(0))}function CMMM(){for(var a=getSA(),b=getDX(),c=getDestPlaneBOffset(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY(),i=getLOP(),j=getWM(c),k=getFC(c)<<16|getBC(c),l=0,m=0,n=0,o=f;o>0;--o){for(var p=b,q=0;q<e;++q)0==(7&m)&&(isP1?(l=vram[a>>>1|(1&a)<<18],a=a+1&VRAM_LIMIT):(l=vram[a],a=a+1&VRAM_LIMIT)),n=l>>7-(7&m)&1,logicalPSETX(p,d|c,p,k>>(n<<4)&65535,i,j),p=p+g&imageWidthMask,++m;d=d+h&imageHeightMask}setSA(a),setDY(d),start(BMXLTiming,e*f,f)}function CMMK(){for(var a=getKA(),b=getDX(),c=getDestPlaneBOffset(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY(),i=getLOP(),j=getWM(c),k=getFC(c)<<16|getBC(c),l=0,m=0,n=0,o=f;o>0;--o){for(var p=b,q=0;q<e;++q){if(0==(7&m)){l=v9990.readKanji(a);var r=1+(16&a|(8&a)>>3|(7&a)<<1);a=262112&a|16&r|(1&r)<<3|(14&r)>>1}n=l>>7-(7&m)&1,logicalPSETX(p,d|c,p,k>>(n<<4)&65535,i,j),p=p+g&imageWidthMask,++m}d=d+h&imageHeightMask}setDY(d),start(BMXLTiming,e*f,f)}function BMXL(){for(var a=getSA(),b=getDX(),c=getDestPlaneBOffset(),d=getDY(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY(),i=getLOP(),j=getWM(c),k=0,l=0,m=0,n=f;n>0;--n){for(var o=b,p=0;p<e;++p){if(0==(7&m))if(isP1)if(16===typeBPP){var q=a>>>1|(1&a)<<18;k=vram[q]<<8,a=a+1&VRAM_LIMIT,q=a>>>1|(1&a)<<18,k|=vram[q],a=a+1&VRAM_LIMIT}else q=a>>>1|(1&a)<<18,k=vram[q],k|=k<<8,a=a+1&VRAM_LIMIT;else 16===typeBPP?(k=vram[a]<<8|vram[a+1],a=a+2&VRAM_LIMIT):(k=vram[a],k|=k<<8,a=a+1&VRAM_LIMIT);logicalPSETX(o,d|c,l,k,i,j),o=o+g&imageWidthMask,++l,m+=typeBPP}d=d+h&imageHeightMask}setSA(a),setDY(d),start(BMXLTiming,e*f,f)}function BMLX(){var a=getSX(),b=getSourcePlaneBOffset(),c=getSY(),d=getDA(),e=getNX(),f=getNY(),g=getDIX(),h=getDIY(),i=getLOP(),j=getWMDirect(),k=0,l=0;if(isP1)for(var m=f;m>0;--m){for(var n=a,o=e;o>0;--o)logicalPCOPYLXP1(d+(l>>3)&VRAM_LIMIT,k,n,c|b,i,j),n=n+g&imageWidthMask,++k,l+=typeBPP;c=c+h&imageHeightMask}else for(m=f;m>0;--m){for(n=a,o=e;o>0;--o)logicalPCOPYLX(d+(l>>3)&VRAM_LIMIT,k,n,c|b,i,j),n=n+g&imageWidthMask,++k,l+=typeBPP;c=c+h&imageHeightMask}setSY(c),setDA(d),start(BMLXTiming,e*f,f)}function BMLL(){var a=getSA(),b=getDA(),c=getNA(),d=getDIX(),e=getLOP(),f=getWMDirect();if(isP1)for(var g=c;g>0;--g)logicalPCOPYLLP1(b,a,e,f),a=a+d&VRAM_LIMIT,b=b+d&VRAM_LIMIT;else for(g=c;g>0;--g)logicalPCOPYLL(b,a,e,f),a=a+d&VRAM_LIMIT,b=b+d&VRAM_LIMIT;setSA(a),setDA(b),start(BMLLTiming,c,0)}function LINE(){var a=getDX(),b=getDestPlaneBOffset(),c=getDY(),d=getMJ(),e=getMI(),f=getDIX(),g=getDIY(),h=getMAJ(),i=getLOP(),j=getWM(b),k=getFC(b),l=0,m=0;if(0===h)for(var n=d;n>=0;--n)logicalPSETX(a,c|b,a,k,i,j),a=a+f&imageWidthMask,e>0&&(m+=e)<<1>=d&&(c=c+g&imageHeightMask,m-=d,++l);else for(n=d;n>=0;--n)logicalPSETX(a,c|b,a,k,i,j),c=c+g&imageHeightMask,e>0&&(m+=e)<<1>=d&&(a=a+f&imageWidthMask,m-=d,++l);setDX(a),setDY(c),
start(LMMVTiming,d,e)}function SRCH(){var a=getSX(),b=getSourcePlaneBOffset(),c=getSY()|b,d=getDIX(),e=getNEQ(),f=getFC(b),g=1===d?imageWidth:-1,h=a,i=0,j=!1,k=16===typeBPP?65535:4===typeBPP?61440:2===typeBPP?49152:65280,l=(typeData.ppB<<1)-1;if(l<0&&(l=0),e)do{if(i=f&k>>(h&l)*typeBPP,normalPGETX(h,c,h)!==i){j=!0;break}h+=d}while(h!==g);else do{if(i=f&k>>(h&l)*typeBPP,normalPGETX(h,c,h)===i){j=!0;break}h+=d}while(h!==g);var m=((7&register[33])<<8|register[32])&~imageWidthMask,n=j?m|h:1===d?m+h&2047:2047;setSX(n),setBX(n),v9990.setStatusBD(j),start(LMMVTiming,Math.abs(h-a)+1,1)}function POINT(){SX=getSX(),SY=getSY()|getSourcePlaneBOffset(),readStart(POINTNextRead)}function POINTNextRead(){if(4===typeBPP)readData=15&readData|normalPGETX(SX,SY,2);else if(8===typeBPP)readData=normalPGETX(SX,SY,1);else if(16===typeBPP){if(null===readDataPending)return readDataPending=normalPGETX(SX,SY,0),void(readData=readDataPending>>8);readData=255&readDataPending,readDataPending=null}else readData=63&readData|normalPGETX(SX,SY,4);v9990.setStatusTR(0),finish()}function PSET(){var a=getDX(),b=getDestPlaneBOffset(),c=getDY(),d=getLOP(),e=getWM(b),f=getFC(b),g=getAXME(),h=getAYME();logicalPSETX(a,c|b,a,f,d,e);var i=1===g?1:3===g?-1:0,j=1===h?1:3===h?-1:0;setDX(a+i),setDY(c+j),start(LMMVTiming,1,1)}function ADVN(){var a=getDX(),b=getDY(),c=getAXME(),d=getAYME(),e=1===c?1:3===c?-1:0,f=1===d?1:3===d?-1:0;setDX(a+e),setDY(b+f),start(LMMVTiming,1,1)}function STOP(){finish(!0)}function normalPGETX(a,b,c){var d,e,f;if(4===typeBPP)d=1-(1&a)<<2,e=3-(3&c)<<2,a>>>=1,f=15;else if(8===typeBPP)d=0,e=1-(1&c)<<3,f=255;else{if(16===typeBPP){a<<=1;var g=b*imageWidthBytes+a&VRAM_LIMIT;return vram[g]<<8|vram[g+1]}d=3-(3&a)<<1,e=7-(7&c)<<1,a>>>=2,f=3}return g=b*imageWidthBytes+a&VRAM_LIMIT,(vram[g]>>d&f)<<e}function logicalPSETX(a,b,c,d,e,f){var g,h,i;if(4===typeBPP)g=3-(3&c)<<2,h=1-(1&a)<<2,a>>>=1,i=15;else if(8===typeBPP)g=1-(1&c)<<3,h=0,i=255;else{if(16===typeBPP){a<<=1;var j=b*imageWidthBytes+a&VRAM_LIMIT,k=vram[j]<<8|vram[j+1],l=e(k,d,f);return vram[j]=l>>8,void(vram[j+1]=255&l)}g=7-(7&c)<<1,h=3-(3&a)<<1,a>>>=2,i=3}j=b*imageWidthBytes+a&VRAM_LIMIT,d=(d>>g&i)<<h,vram[j]=e(vram[j],d,i<<h&wm8ForAddr(f,j))}function logicalPCOPYXX(a,b,c,d,e,f){var g,h,i;if(4===typeBPP)g=1-(1&c)<<2,h=1-(1&a)<<2,c>>>=1,a>>>=1,i=15;else if(8===typeBPP)g=h=0,i=255;else{if(16===typeBPP){c<<=1,a<<=1;var j=d*imageWidthBytes+c&VRAM_LIMIT,k=b*imageWidthBytes+a&VRAM_LIMIT,l=vram[j]<<8|vram[j+1],m=vram[k]<<8|vram[k+1],n=e(m,l,f);return vram[k]=n>>8,void(vram[k+1]=255&n)}g=3-(3&c)<<1,h=3-(3&a)<<1,c>>>=2,a>>>=2,i=3}j=d*imageWidthBytes+c&VRAM_LIMIT,k=b*imageWidthBytes+a&VRAM_LIMIT,l=(vram[j]>>g&i)<<h,vram[k]=e(vram[k],l,i<<h&wm8ForAddr(f,k))}function logicalPCOPYLX(a,b,c,d,e,f){var g,h,i;if(4===typeBPP)g=1-(1&c)<<2,h=1-(1&b)<<2,c>>>=1,i=15;else if(8===typeBPP)g=h=0,i=255;else{if(16===typeBPP){c<<=1;var j=d*imageWidthBytes+c&VRAM_LIMIT,k=vram[j]<<8|vram[j+1],l=vram[a]<<8|vram[a+1],m=e(l,k,wm16ForAddr(f,a));return vram[a]=m>>8,void(vram[a+1]=255&m)}g=3-(3&c)<<1,h=3-(3&b)<<1,c>>>=2,i=3}j=d*imageWidthBytes+c&VRAM_LIMIT,k=(vram[j]>>g&i)<<h,vram[a]=e(vram[a],k,i<<h&wm8ForAddr(f,a))}function logicalPCOPYLXP1(a,b,c,d,e,f){var g,h,i;if(4===typeBPP)g=1-(1&c)<<2,h=1-(1&b)<<2,c>>>=1,i=15;else if(8===typeBPP)g=h=0,i=255;else{if(16===typeBPP){c<<=1;var j=d*imageWidthBytes+c&VRAM_LIMIT,k=vram[j]<<8|vram[j+1],l=a>>>1|(1&a)<<18;a=a+1&VRAM_LIMIT;var m=a>>>1|(1&a)<<18,n=vram[l]<<8|vram[m],o=e(n,k,wm16ForAddr(f,a));return vram[l]=o>>8,void(vram[m]=255&o)}g=3-(3&c)<<1,h=3-(3&b)<<1,c>>>=2,i=3}f=wm8ForAddr(f,a),j=d*imageWidthBytes+c&VRAM_LIMIT,k=(vram[j]>>g&i)<<h,a=a>>>1|(1&a)<<18,vram[a]=e(vram[a],k,i<<h&f)}function logicalPCOPYLL(a,b,c,d){vram[a]=c(vram[a],vram[b],wm8ForAddr(d,a))}function logicalPCOPYLLP1(a,b,c,d){d=wm8ForAddr(d,a),a=a>>>1|(1&a)<<18,b=b>>>1|(1&b)<<18,vram[a]=c(vram[a],vram[b],d)}function lopNULL(a,b,c){return a&~c}function lopNOR(a,b,c){return a&~c|~(a|b)&c}function lopEXD(a,b,c){return a&~(b&c)}function lopNOTS(a,b,c){return a&~c|~b&c}function lopEXS(a,b,c){return a&~c|b&~a&c}function lopNOTD(a,b,c){return a&~c|~a&c}function lopXOR(a,b,c){return a^b&c}function lopNAND(a,b,c){return a&~c|~(a&b)&c}function lopAND(a,b,c){return a&(b|~c)}function lopEQV(a,b,c){return a&~c|~(a^b)&c}function lopD(a,b,c){return a}function lopNEXS(a,b,c){return a&~c|(~b|a)&c}function lopS(a,b,c){return a&~c|b&c}function lopNEXD(a,b,c){return a|(~a|b)&c}function lopOR(a,b,c){return a|b&c}function lopID(a,b,c){return a|c}function lopTNULL(a,b,c){return 0===b?a:a&~c}function lopTNOR(a,b,c){return 0===b?a:a&~c|~(a|b)&c}function lopTEXD(a,b,c){return 0===b?a:a&~(b&c)}function lopTNOTS(a,b,c){return 0===b?a:a&~c|~b&c}function lopTEXS(a,b,c){return 0===b?a:a&~c|b&~a&c}function lopTNOTD(a,b,c){return 0===b?a:a&~c|~a&c}function lopTXOR(a,b,c){return 0===b?a:a^b&c}function lopTNAND(a,b,c){return 0===b?a:a&~c|~(a&b)&c}function lopTAND(a,b,c){return 0===b?a:a&(b|~c)}function lopTEQV(a,b,c){return 0===b?a:a&~c|~(a^b)&c}function lopTD(a,b,c){return a}function lopTNEXS(a,b,c){return 0===b?a:a&~c|(~b|a)&c}function lopTS(a,b,c){return 0===b?a:a&~c|b&c}function lopTNEXD(a,b,c){return 0===b?a:a|(~a|b)&c}function lopTOR(a,b,c){return 0===b?a:a|b&c}function lopTID(a,b,c){return 0===b?a:a|c}function start(a,b,c,d){CE=1,v9990.setStatusCE(CE),writeHandler=null,readHandler=null,estimateDuration(a,b,c,d)}function estimateDuration(a,b,c,d){if(d)finishingCycle=-1;else if(a&&0!==turboClockMulti){var e=a[modeData.cmdTiming][dispAndSpritesMode],f=e[typeBPP]||e,g=BASE_CLOCK/50/256/f,h=b*g*self.COMMAND_PER_PIXEL_DURATION_FACTOR/turboClockMulti|0;finishingCycle=v9990.getVDPCycles()+h}else finishingCycle=0,finish()}function writeStart(a){start(null,0,0,!0),writeHandler=a,writeDataPending=null,v9990.setStatusTR(1)}function readStart(a){start(null,0,0,!0),readHandler=a,readDataPending=null,v9990.setStatusTR(1),readHandler()}function finish(a){CE=0,v9990.setStatusCE(CE),a||v9990.triggerCommandCompletionInterrupt(),writeHandler=null,writeDataPending=null,readDataPending=null,readHandler=null}var self=this;this.connectV9990=function(a,b,c){v9990=a,vram=b,register=c},this.reset=function(){STOP()},this.startCommand=function(a){switch(240&a){case 0:STOP();break;case 16:LMMC();break;case 32:LMMV();break;case 48:LMCM();break;case 64:LMMM();break;case 80:CMMC();break;case 96:CMMK();break;case 112:CMMM();break;case 128:BMXL();break;case 144:BMLX();break;case 160:BMLL();break;case 176:LINE();break;case 192:SRCH();break;case 208:POINT();break;case 224:PSET();break;case 240:ADVN()}},this.cpuWrite=function(a){writeHandler?writeHandler(a):v9990.setStatusTR(0)},this.cpuRead=function(){var a=readData;return readHandler?readHandler():v9990.setStatusTR(0),a},this.updateStatus=function(){CE&&finishingCycle>=0&&(0===finishingCycle||v9990.getVDPCycles()>=finishingCycle)&&finish()},this.setV9990ModeData=function(a,b,c,d){modeData=a,typeData=b,imageWidth=c,imageWidthMask=c-1,imageHeight=d,imageHeightMask=d-1,imageWidthBytes=imageWidth*typeData.bpp>>3,typeBPP=typeData.bpp,isP1="P1"===a.name,colosPPBShift=typeData.ppB>>1,colorPPBMask=-1<<colosPPBShift},this.setV9990DisplayAndSpritesEnabled=function(a,b){dispAndSpritesMode=a?b?2:1:0},this.setTurboMulti=function(a){turboClockMulti=a<0||a>8?0:a},this.getV9990TurboMulti=function(){return turboClockMulti};var BASE_CLOCK=wmsx.V9990.BASE_CLOCK,VRAM_LIMIT=wmsx.V9990.VRAM_LIMIT,COMMAND_HANDLERS={LMMCNextWrite:LMMCNextWrite,LMCMNextRead:LMCMNextRead,POINTNextRead:POINTNextRead};self.COMMAND_PER_PIXEL_DURATION_FACTOR=.99
;var v9990,vram,register,CE=0,SX=0,SY=0,SRCOff=0,DX=0,DY=0,DESTOff=0,NX=0,NY=0,ESX=0,EDX=0,DIX=0,DIY=0,CX=0,CY=0,WM=0,FBC=0,LOP,readData=0,writeDataPending=null,readDataPending=null,writeHandler=null,readHandler=null,finishingCycle=0,dispAndSpritesMode=0,turboClockMulti=1,modeData,typeData,isP1=!1,typeBPP=8,colosPPBShift=0,colorPPBMask=0,imageWidth=0,imageHeight=0,imageWidthMask=0,imageHeightMask=0,imageWidthBytes=0,LOGICAL_OPERATIONS=[lopNULL,lopNOR,lopEXD,lopNOTS,lopEXS,lopNOTD,lopXOR,lopNAND,lopAND,lopEQV,lopD,lopNEXS,lopS,lopNEXD,lopOR,lopID,lopTNULL,lopTNOR,lopTEXD,lopTNOTS,lopTEXS,lopTNOTD,lopTXOR,lopTNAND,lopTAND,lopTEQV,lopTD,lopTNEXS,lopTS,lopTNEXD,lopTOR,lopTID],LMMVTiming=[[{2:723,4:537,8:400,16:200},{2:720,4:526,8:394,16:199},{2:683,4:502,8:372,16:188}],[{2:481,4:352,8:262,16:131},{2:478,4:349,8:258,16:129},{2:441,4:315,8:232,16:116}],[393,218,167],[528,320,251]],LMMMTiming=[[{2:625,4:386,8:193,16:96},{2:625,4:376,8:188,16:95},{2:578,4:353,8:176,16:89}],[{2:409,4:248,8:123,16:62},{2:402,4:243,8:120,16:60},{2:361,4:215,8:108,16:54}],[186,104,80],[371,209,160]],BMLLTiming=[[193,188,177],[123,120,107],[186,103,79],[186,103,79]],BMXLTiming=[[{2:626,4:387,8:194,16:97},{2:626,4:377,8:189,16:95},{2:583,4:356,8:177,16:90}],[{2:417,4:250,8:125,16:62},{2:411,4:243,8:121,16:60},{2:364,4:216,8:108,16:54}],[228,129,100],[372,210,160]],BMLXTiming=[[{2:625,4:386,8:193,16:96},{2:625,4:376,8:188,16:95},{2:578,4:353,8:176,16:89}],[{2:409,4:248,8:123,16:62},{2:402,4:243,8:120,16:60},{2:361,4:215,8:108,16:54}],[195,115,90],[371,209,160]];this.saveState=function(){return{ce:CE,rd:readData,rdp:readDataPending,wdp:writeDataPending,wh:writeHandler&&writeHandler.name,rh:readHandler&&readHandler.name,fc:finishingCycle,SX:SX,SY:SY,SYP1O:SRCOff,DX:DX,DY:DY,DYP1O:DESTOff,NX:NX,NY:NY,ESX:ESX,EDX:EDX,DIX:DIX,DIY:DIY,CX:CX,CY:CY,WM:WM,FBC:FBC,LOP:LOP&&LOGICAL_OPERATIONS.indexOf(LOP),dsm:dispAndSpritesMode,tcm:turboClockMulti}},this.loadState=function(a){CE=a.ce,readData=a.rd,readDataPending=a.rdp,writeDataPending=a.wdp,writeHandler=COMMAND_HANDLERS[a.wh],readHandler=COMMAND_HANDLERS[a.rh],finishingCycle=a.fc,SX=a.SX,SY=a.SY,SRCOff=a.SYP1O,DX=a.DX,DY=a.DY,DESTOff=a.DYP1O,NX=a.NX,NY=a.NY,ESX=a.ESX,EDX=a.EDX,DIX=a.DIX,DIY=a.DIY,CX=a.CX,CY=a.CY,WM=a.WM,FBC=a.FBC,LOP=a.LOP>=0?LOGICAL_OPERATIONS[a.LOP]:void 0,dispAndSpritesMode=a.dsm,turboClockMulti=void 0!==a.tcm?a.tcm:1},this.eval=function(str){return eval(str)}},wmsx.VideoSignal=function(a,b){"use strict";this.connectMonitor=function(a){c=a},this.newFrame=function(a,b,d,e,f){c.newFrame(this,a,b,d,e,f)},this.signalOff=function(){c&&c.signalOff(this)},this.showOSD=function(a,b,d){c&&c.showOSD(a,b,d)},this.setDisplayMetrics=function(a,b){c&&c.setDisplayMetrics(this,a,b)},this.setColorAndPaletteMode=function(b,c){a.setColorAndPaletteMode(b,c)},this.resetOutputAutoMode=function(){a.resetOutputAutoMode()},this.refreshDisplayMetrics=function(){a.refreshDisplayMetrics()},this.videoSignalDisplayStateUpdate=function(b,c){a.videoSignalDisplayStateUpdate(b,c)},this.setOutputAutoMode=function(a){c&&c.setOutputAutoMode(this,a)},this.getSignalName=function(){return b},this.setDebugMode=function(a){c&&c.setDebugMode(this,a)},this.getScreenText=function(){return a.getScreenText()},this.name=b;var c},wmsx.VideoStandard={NTSC:{name:"NTSC",desc:"NTSC 60Hz",totalWidth:342,totalHeight:262,topBorderHeight:16,targetFPS:60,pulldowns:{60:{standard:"NTSC",frequency:60,divider:1,linesPerCycle:262,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},120:{standard:"NTSC",frequency:120,divider:2,linesPerCycle:262,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},"120s":{standard:"NTSC",frequency:120,divider:1,linesPerCycle:131,firstStepCycleLinesAdjust:0,cadence:[0,1],steps:2},50:{standard:"NTSC",frequency:50,divider:1,linesPerCycle:314,firstStepCycleLinesAdjust:2,cadence:[1,1,1,1,2],steps:5},100:{standard:"NTSC",frequency:100,divider:2,linesPerCycle:314,firstStepCycleLinesAdjust:2,cadence:[1,1,1,1,2],steps:5},"100s":{standard:"NTSC",frequency:100,divider:1,linesPerCycle:157,firstStepCycleLinesAdjust:2,cadence:[0,1,0,1,1,0,1,0,1,1],steps:10},TIMER:{standard:"NTSC",frequency:62.5,divider:1,linesPerCycle:262,firstStepCycleLinesAdjust:0,cadence:[1],steps:1}}},PAL:{name:"PAL",desc:"PAL 50Hz",totalWidth:342,totalHeight:313,topBorderHeight:43,targetFPS:50,pulldowns:{50:{standard:"PAL",frequency:50,divider:1,linesPerCycle:313,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},100:{standard:"PAL",frequency:100,divider:2,linesPerCycle:313,firstStepCycleLinesAdjust:0,cadence:[1],steps:1},"100s":{standard:"PAL",frequency:100,divider:1,linesPerCycle:156,firstStepCycleLinesAdjust:1,cadence:[0,1],steps:2},60:{standard:"PAL",frequency:60,divider:1,linesPerCycle:261,firstStepCycleLinesAdjust:-1,cadence:[0,1,1,1,1,1],steps:6},120:{standard:"PAL",frequency:120,divider:2,linesPerCycle:261,firstStepCycleLinesAdjust:-1,cadence:[0,1,1,1,1,1],steps:6},"120s":{standard:"PAL",frequency:120,divider:1,linesPerCycle:130,firstStepCycleLinesAdjust:5,cadence:[0,0,1,0,1,0,0,1,0,1,0,1],steps:12},TIMER:{standard:"PAL",frequency:50,divider:1,linesPerCycle:313,firstStepCycleLinesAdjust:0,cadence:[1],steps:1}}}},wmsx.AudioTables={setupVolPan:function(a,b,c,d,e){this.createVolPanVolumeTable();for(var f=0;f<a;++f){var g=Number("0x"+(1===b.length?b[0]:b.length>f?b[f]:"f")),h=Number("0x"+(1===c.length?c[0]:c.length>f?c[f]:"8"));d[f]=this.VOLPAN_VOLUME_TABLE[this.VOL_VALUES[g]+this.PAN_VALUES[0][h]],e[f]=this.VOLPAN_VOLUME_TABLE[this.VOL_VALUES[g]+this.PAN_VALUES[1][h]]}},createVolPanVolumeTable:function(){if(!this.VOLPAN_VOLUME_TABLE){for(var a=new Array(256),b=0;b<127;++b)a[b]=Math.pow(10,-.75*b/20);for(b=127;b<256;++b)a[b]=0;this.VOLPAN_VOLUME_TABLE=a}},VOL_VALUES:[128,28,26,24,22,20,18,16,14,12,10,8,6,4,2,0],PAN_VALUES:[[127,0,0,0,0,0,0,0,0,4,8,12,16,20,24,127],[127,127,24,20,16,12,8,4,0,0,0,0,0,0,0,0]],VOLPAN_VOLUME_TABLE:void 0},wmsx.PSG=function(controllersSocket,ledsSocket,secondary){"use strict";function updateKanaLed(){ledsSocket&&ledsSocket.ledStateChanged(1,(128&~register[15])>>7)}this.connectBus=function(a){var b=secondary?16:160;a.connectInputDevice(b,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(b,this.outputA0),a.connectInputDevice(b+1,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(b+1,this.outputA1),a.connectInputDevice(b+2,this.inputA2),a.connectOutputDevice(b+2,wmsx.DeviceMissing.outputPortIgnored),powerIsOn&&audioChannel.connectAudio()},this.disconnectBus=function(a){var b=secondary?16:160;a.disconnectInputDevice(b,wmsx.DeviceMissing.inputPortIgnored),a.disconnectOutputDevice(b,this.outputA0),a.disconnectInputDevice(b+1,wmsx.DeviceMissing.inputPortIgnored),a.disconnectOutputDevice(b+1,this.outputA1),a.disconnectInputDevice(b+2,this.inputA2),a.disconnectOutputDevice(b+2,wmsx.DeviceMissing.outputPortIgnored),audioChannel.disconnectAudio()},this.setAudioSocket=function(a){audioChannel.setAudioSocket(a)},this.powerOn=function(){this.reset(),powerIsOn=!0,audioChannel.powerOn()},this.powerOff=function(){powerIsOn=!1,this.reset(),audioChannel.powerOff()},this.reset=function(){wmsx.Util.arrayFill(register,0),register[15]=143,updateKanaLed(),audioChannel.reset()},this.getAudioChannel=function(){return audioChannel},this.outputA0=function(a){registerAddress=a>15?0:a},this.outputA1=function(a){switch(register[registerAddress]=a,registerAddress){case 0:case 1:audioChannel.setPeriodA((15&register[1])<<8|register[0]);break;case 2:case 3:audioChannel.setPeriodB((15&register[3])<<8|register[2]);break;case 4:case 5:audioChannel.setPeriodC((15&register[5])<<8|register[4]);break;case 6:audioChannel.setPeriodN(31&a);break;case 7:audioChannel.setMixerControl(a);break;case 8:audioChannel.setAmplitudeA(a);break;case 9:audioChannel.setAmplitudeB(a);break;case 10:audioChannel.setAmplitudeC(a);break;case 11:case 12:audioChannel.setPeriodE(register[12]<<8|register[11]);break;case 13:
audioChannel.setEnvelopeControl(a);break;case 15:controllersSocket&&(controllersSocket.writeControllerPin8Port(0,(16&a)>>4),controllersSocket.writeControllerPin8Port(1,(32&a)>>5)),updateKanaLed()}},this.inputA2=function(){if(14!==registerAddress)return register[registerAddress];var a=register[15]>>6&1;return controllersSocket?controllersSocket.readControllerPort(a):63};var powerIsOn=!1,registerAddress=0,register=wmsx.Util.arrayFill(new Array(16),0),audioChannel=new wmsx.PSGAudio(secondary);this.saveState=function(){return{p:powerIsOn,ra:registerAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),ac:audioChannel.saveState()}},this.loadState=function(a){powerIsOn=void 0===a.p||a.p,registerAddress=a.ra,register=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r,register),updateKanaLed(),audioChannel.loadState(a.ac)},this.eval=function(str){return eval(str)}},wmsx.AudioSignal=function(a,b,c,d,e,f){"use strict";function g(a){switch(a){case 32:return j;case 72:return k;case 81:return l;default:throw new Error("Unsupported AudioSignal Sample Rate CPU Clock multiple: "+a)}}function h(a){switch(a){case 72:return m;default:throw new Error("Unsupported AudioSignal Clock CPU Clock multiple: "+a)}}function i(){var a=H*WMSX.AUDIO_SIGNAL_BUFFER_RATIO+v*WMSX.AUDIO_SIGNAL_ADD_FRAMES&-8;F.length=a,a>C&&wmsx.Util.arrayFill(F,0,C,a),e&&(G.length=a,a>C&&wmsx.Util.arrayFill(G,0,C,a)),C=a,I.bufferSize=C,E=C-2,s.flush()}function j(){if(B>0){if(D<=0)return void(B=0);t(),--B,--D}}function k(){1&--w||8===w||(0===w&&(w=9),j())}function l(){--x,1&x&&j(),0===x&&(x=5)}function m(){1&--y||8===y||(0===y&&(y=9),b.audioClockPulse())}function n(){F[z]=b.nextSample()*c,++z>=C&&(z=0)}function o(){var a=b.nextSample();F[z]=a[0]*c,G[z]=a[1]*c,++z>=C&&(z=0)}function p(){F[z]=0,++z>=C&&(z=0)}function q(){F[z]=G[z]=0,++z>=C&&(z=0)}function r(a,b){if(b)for(var c=a;c>0;c-=1)u();else for(var d=a;d>0;d-=1)t();D-=a}var s=this;this.audioClockPulse=null,this.flush=function(){z=0,A=0,D=E},this.setFps=function(a){v=Math.floor(d/a),i()},this.audioFinishFrame=function(){if(B>0)for(;B>0;)j();B=v},this.retrieveSamples=function(a,b){var c=E-D,d=a-c;d>-4&&(d+4>D&&(d=D-4),r(d+4,b)),I.start=A;var e=c+d;return D+=e,A+=e,A>=C&&(A-=C),I},this.getSampleRate=function(){return d},this.toString=function(){return"AudioSignal "+a},this.setAudioMonitorBufferSize=function(a){H=a,i()};var t=n,u=p;this.name=a;var v,w=9,x=5,y=9,z=0,A=0,B=0,C=0,D=0,E=0,F=wmsx.Util.arrayFill(new Array(C),0),G=e?wmsx.Util.arrayFill(new Array(C),0):F,H=0,I={stereo:e,buffer0:F,buffer1:G,bufferSize:C,start:0};!function(){c=1.2*c*WMSX.VOL,t=e?o:n,u=e?q:p;var a=Math.floor(wmsx.Machine.BASE_CPU_CLOCK/d),b=g(a);if(f){a=Math.floor(wmsx.Machine.BASE_CPU_CLOCK/f);var i=h(a);s.audioClockPulse=function(){i(),b()}}else s.audioClockPulse=b}()},wmsx.PSGAudio=function(a){"use strict";function b(a,b){a^b&&(J=!J),G=J?0:15,H=b?0:J?1:-1}function c(){m&&(j=R[G]),t&&(q=R[G]),A&&(x=R[G])}function d(){return 1&(P=P>>1|(1&(P>>2^1&P))<<16)}function e(){R[0]=0;for(var a=1;a<16;a++)R[a]=Math.pow(2,-(15-a)/2)*W}var f=this;this.setAudioSocket=function(a){T=a},this.powerOn=function(){this.reset(),this.connectAudio()},this.powerOff=function(){this.disconnectAudio()},this.reset=function(){this.setMixerControl(255),this.setAmplitudeA(0),this.setAmplitudeB(0),this.setAmplitudeC(0),M=!1,N=0,O=0},this.nextSample=function(){if(g>0&&(h+=2)>=g&&(h=h-g&1,i=i?0:1),n>0&&(o+=2)>=n&&(o=o-n&1,p=p?0:1),u>0&&(v+=2)>=u&&(v=v-u&1,w=w?0:1),(l||s||z)&&(C+=1)>=B&&(C=0,D=d()),0!==H&&(F+=1)>=E&&(F=0,G+=H,(G<0||G>15)&&(I?b(K,L):(J=!0,b(!0,!0))),c()),ba){var a=0===j||k&&!i||l&&!D?0:j,e=0===q||r&&!p||s&&!D?0:q,f=0===x||y&&!w||z&&!D?0:x,m=0;return O&&(m=X,!M&&T.getBUSCycles()-N>=Y&&(O=0)),Q[0]=a*U[0]+e*U[1]+f*U[2]+m*U[3],Q[1]=a*V[0]+e*V[1]+f*V[2]+m*V[3],Q}var t=(0===j||k&&!i||l&&!D?0:j)+(0===q||r&&!p||s&&!D?0:q)+(0===x||y&&!w||z&&!D?0:x);return O&&(t+=X,!M&&T.getBUSCycles()-N>=Y&&(O=0)),t},this.setPeriodA=function(a){g!==a&&(a<2?(g=0,i=1):g=a)},this.setPeriodB=function(a){n!==a&&(a<2?(n=0,p=1):n=a)},this.setPeriodC=function(a){u!==a&&(a<2?(u=0,w=1):u=a)},this.setPeriodN=function(a){B!==a&&(B=a<1?1:a)},this.setPeriodE=function(a){E!==a&&(E=a<1?1:a)},this.setAmplitudeA=function(a){16&a?(m=!0,j=R[G]):(m=!1,j=R[15&a])},this.setAmplitudeB=function(a){16&a?(t=!0,q=R[G]):(t=!1,q=R[15&a])},this.setAmplitudeC=function(a){16&a?(A=!0,x=R[G]):(A=!1,x=R[15&a])},this.setMixerControl=function(a){k=0==(1&a),l=0==(8&a),r=0==(2&a),s=0==(16&a),y=0==(4&a),z=0==(32&a)},this.setEnvelopeControl=function(a){I=(8&a)>0,J=(4&a)>0,K=(2&a)>0,L=(1&a)>0,b(!1,!1),c()},this.setPulseSignal=function(a){M=a,a&&(N=T.getBUSCycles(),O=1)},this.connectAudio=function(){T&&(S||(S=new wmsx.AudioSignal("PSG"+(a?"2":""),f,Z,$,ba)),T.connectAudioSignal(S))},this.disconnectAudio=function(){T&&S&&T.disconnectAudioSignal(S)};var g=0,h=0,i=0,j=0,k=!1,l=!1,m=!1,n=0,o=0,p=0,q=0,r=!1,s=!1,t=!1,u=0,v=0,w=0,x=0,y=!1,z=!1,A=!1,B=1,C=1,D=0,E=1,F=1,G=0,H=0,I=!1,J=!1,K=!1,L=!1,M=!1,N=0,O=0,P=131070,Q=[0,0],R=new Array(16);this.volumeCurve=R;var S,T,U=new Array(4),V=new Array(4),W=.28,X=.25,Y=160,Z=.66,$=112005,_=(a&&WMSX.PSG2_VOL||WMSX.PSG_VOL||"f").toUpperCase(),aa=(a&&WMSX.PSG2_PAN||WMSX.PSG_PAN||"0").toUpperCase(),ba="F"!==_||"8"!==aa;this.saveState=function(){return{pa:g,pac:h,ca:i,aa:j,ta:k,na:l,ea:m,pb:n,pbc:o,cb:p,ab:q,tb:r,nb:s,eb:t,pc:u,pcc:v,cc:w,ac:x,tc:y,nc:z,ec:A,pn:B,pnc:C,cn:D,pe:E,pec:F,ce:G,de:H,cne:I,ate:J,ale:K,he:L,ps:M,lf:P}},this.loadState=function(a){g=a.pa,h=a.pac,i=a.ca,j=a.aa,k=a.ta,l=a.na,m=a.ea,n=a.pb,o=a.pbc,p=a.cb,q=a.ab,r=a.tb,s=a.nb,t=a.eb,u=a.pc,v=a.pcc,w=a.cc,x=a.ac,y=a.tc,z=a.nc,A=a.ec,B=a.pn,C=a.pnc,D=a.cn,E=a.pe,F=a.pec,G=a.ce,H=a.de,I=a.cne,J=a.ate,K=a.ale,L=a.he,M=a.ps,N=0,O=M?1:0,P=a.lf},function(){e(),ba&&wmsx.AudioTables.setupVolPan(4,_,aa,U,V)}()},wmsx.PCM8BitAudio=function(){"use strict";this.setAudioSocket=function(a){c=a},this.connectAudio=function(){b||(b=new wmsx.AudioSignal("PCM 8 bit",this,e,f)),c&&c.connectAudioSignal(b)},this.disconnectAudio=function(){b&&c&&c.disconnectAudioSignal(b)},this.reset=function(){a=0},this.setSampleValue=function(b){a=b-128},this.nextSample=function(){return a*d};var a,b,c,d=.25/128,e=.66,f=112005;this.saveState=function(){return{s:a}},this.loadState=function(b){a=b.s}},wmsx.SCCIAudio=function(){"use strict";function a(a,b){if((a&=255)<128)return U[a>>>5][31&a]=b<128?b:-256+b,void(a>>>5==3&&(O[31&a]=b<128?b:-256+b));if(a<160){if((a&=239)<138)return void f(a-128>>>1,b,1&a);if(a<143)return void e(a-138,15&b);g(b)}}function b(a){return a&=255,a<128?255&U[a>>>5][31&a]:255}function c(a,b){if((a&=255)<160)return void(U[a>>>5][31&a]=b<128?b:-256+b);if(a<192){if((a&=239)<170)return void f(a-160>>>1,b,1&a);if(a<175)return void e(a-170,15&b);g(b)}}function d(a){return a&=255,a<160?255&U[a>>>5][31&a]:255}function e(a,b){switch(a){case 0:r=W[b];break;case 1:y=W[b];break;case 2:F=W[b];break;case 3:M=W[b];break;case 4:T=W[b]}}function f(a,b,c){switch(a){case 0:n=c?255&n|(15&b)<<8:65280&n|b;break;case 1:u=c?255&u|(15&b)<<8:65280&u|b;break;case 2:B=c?255&B|(15&b)<<8:65280&B|b;break;case 3:I=c?255&I|(15&b)<<8:65280&I|b;break;case 4:P=c?255&P|(15&b)<<8:65280&P|b}}function g(a){l=1&a?1:0,s=2&a?1:0,z=4&a?1:0,G=8&a?1:0,N=16&a?1:0}function h(){for(var a=0;a<16;a++)W[a]=(Math.pow($,a/15)-1)/($-1)*Z}this.setAudioSocket=function(a){k=a},this.connectAudio=function(){j||(j=new wmsx.AudioSignal("SCC",this,_,aa,da)),k&&k.connectAudioSignal(j)},this.disconnectAudio=function(){j&&k&&k.disconnectAudioSignal(j)},this.reset=function(){this.disconnectAudio(),g(0),r=y=F=M=T=0,n=u=B=I=P=0,o=v=C=J=Q=0,p=w=D=K=R=0,q=x=E=L=S=0;for(var a=0;a<5;a++)wmsx.Util.arrayFill(U[a],0);this.setSCCIMode(!1)},this.setSCCIMode=function(e){i!==e&&(i=!!e,i?(this.read=d,this.write=c):(this.read=b,this.write=a))},this.nextSample=function(){var a=0,b=0,c=0,d=0,e=0;if(n>0)for(l&&(a=q*r),o+=32;o>=n;)o-=n,++p>31&&(p=0),q=m[p]
;if(u>0)for(s&&(b=x*y),v+=32;v>=u;)v-=u,++w>31&&(w=0),x=t[w];if(B>0)for(z&&(c=E*F),C+=32;C>=B;)C-=B,++D>31&&(D=0),E=A[D];if(I>0)for(G&&(d=L*M),J+=32;J>=I;)J-=I,++K>31&&(K=0),L=H[K];if(P>0)for(N&&(e=S*T),Q+=32;Q>=P;)Q-=P,++R>31&&(R=0),S=O[R];return da?(V[0]=a*X[0]+b*X[1]+c*X[2]+d*X[3]+e*X[4],V[1]=a*Y[0]+b*Y[1]+c*Y[2]+d*Y[3]+e*Y[4],V):a+b+c+d+e};var i,j,k,l=0,m=wmsx.Util.arrayFill(new Array(32),0),n=0,o=0,p=0,q=0,r=0,s=0,t=wmsx.Util.arrayFill(new Array(32),0),u=0,v=0,w=0,x=0,y=0,z=0,A=wmsx.Util.arrayFill(new Array(32),0),B=0,C=0,D=0,E=0,F=0,G=0,H=wmsx.Util.arrayFill(new Array(32),0),I=0,J=0,K=0,L=0,M=0,N=!1,O=wmsx.Util.arrayFill(new Array(32),0),P=0,Q=0,R=0,S=0,T=0,U=[m,t,A,H,O],V=[0,0],W=new Array(16),X=new Array(5),Y=new Array(5),Z=.23/128,$=3,_=.65,aa=112005,ba=(WMSX.SCC_VOL||"f").toUpperCase(),ca=(WMSX.SCC_PAN||"8").toUpperCase(),da="F"!==ba||"8"!==ca;this.saveState=function(){return{m:i,c1:l,p1:n,pc1:o,sc1:p,cs1:q,a1:r,c2:s,p2:u,pc2:v,sc2:w,cs2:x,a2:y,c3:z,p3:B,pc3:C,sc3:D,cs3:E,a3:F,c4:G,p4:I,pc4:J,sc4:K,cs4:L,a4:M,c5:N,p5:P,pc5:Q,sc5:R,cs5:S,a5:T,s1:wmsx.Util.storeInt8BitArrayToStringBase64(m),s2:wmsx.Util.storeInt8BitArrayToStringBase64(t),s3:wmsx.Util.storeInt8BitArrayToStringBase64(A),s4:wmsx.Util.storeInt8BitArrayToStringBase64(H),s5:wmsx.Util.storeInt8BitArrayToStringBase64(O)}},this.loadState=function(a){this.reset(),l=a.c1,n=a.p1,o=a.pc1,p=a.sc1,q=a.cs1,r=a.a1,s=a.c2,u=a.p2,v=a.pc2,w=a.sc2,x=a.cs2,y=a.a2,z=a.c3,B=a.p3,C=a.pc3,D=a.sc3,E=a.cs3,F=a.a3,G=a.c4,I=a.p4,J=a.pc4,K=a.sc4,L=a.cs4,M=a.a4,N=a.c5,P=a.p5,Q=a.pc5,R=a.sc5,S=a.cs5,T=a.a5,m=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s1,m),t=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s2,t),A=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s3,A),H=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s4,H),O=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.s5||a.s4,O),U[0]!==m&&(U[0]=m),U[1]!==t&&(U[1]=t),U[2]!==A&&(U[2]=A),U[3]!==H&&(U[3]=H),U[4]!==O&&(U[4]=O),this.setSCCIMode(!0===a.m)},function(a){h(),da&&wmsx.AudioTables.setupVolPan(5,ba,ca,X,Y),a.setSCCIMode(!1)}(this)},wmsx.YM2413Tables=function(){"use strict";this.getFullSineTable=function(){for(var a=new Array(1024),b=0;b<1024;++b)a[b]=(b>511?16384:0)|Math.round(256*-wmsx.Util.log2(Math.abs(Math.sin(2*(b+.5)*Math.PI/1024))));return a},this.getHalfSineTable=function(){for(var a=new Array(1024),b=0;b<1024;++b)a[b]=Math.round(256*-wmsx.Util.log2(Math.abs(Math.sin(2*(b<512?b+.5:.5)*Math.PI/1024))));return a},this.getExpTable=function(){for(var a=new Array(32768),b=0;b<32768;++b){var c=Math.round(1024*wmsx.Util.exp2((255&b^255)/256))<<1>>Math.min((16128&b)>>8,31);16384&b&&(c=-c),a[b]=c}return a},this.getInstrumentsROM=function(){return this.INSTRUMENT_ROM},this.getVIBValues=function(){return this.VIB_VALUES},this.getKSLValues=function(){return this.KSL_VALUES},this.getMultiFactorsDoubled=function(){return this.MULTI_FACTORS},this.getRateDecayDurations=function(){for(var a=new Array(76),b=0;b<64;++b){var c=this.RATE_DECAY_DURATIONS[b];a[b]=c>=0?Math.max(1,Math.round(c/1e3*49780/128)):0}for(b=64;b<76;++b)a[b]=a[63];return a},this.getRateAttackDurations=function(){for(var a=new Array(76),b=0;b<64;++b){var c=this.RATE_ATTACK_DURATIONS[b];a[b]=c>=0?Math.max(1,Math.round(c/1e3*49780/128*8)):0}for(b=64;b<76;++b)a[b]=a[63];return a},this.INSTRUMENT_ROM=[[0,0,0,0,0,0,0,0],[97,97,30,23,240,127,0,23],[19,65,22,14,253,244,35,35],[3,1,154,4,243,243,19,243],[17,97,14,7,250,100,112,23],[34,33,30,6,240,118,0,40],[33,34,22,5,240,113,0,24],[33,97,29,7,130,128,23,23],[35,33,45,22,144,144,0,7],[33,33,27,6,100,101,16,23],[33,33,11,26,133,160,112,7],[35,1,131,16,255,180,16,244],[151,193,32,7,255,244,34,34],[97,0,12,5,194,246,64,68],[1,1,86,3,148,194,3,18],[33,1,137,3,241,228,240,35],[1,1,20,0,253,248,111,141],[1,17,0,0,248,247,248,247],[5,17,0,0,248,250,248,85]],this.VIB_VALUES=[[0,0,0,0,0,0,0,0],[0,0,1,0,0,0,-1,0],[0,1,2,1,0,-1,-2,-1],[0,1,3,1,0,-1,-3,-1],[0,2,4,2,0,-2,-4,-2],[0,2,5,2,0,-2,-5,-2],[0,3,6,3,0,-3,-6,-3],[0,3,7,3,0,-3,-7,-3]],this.KSL_VALUES=[[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0]],[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,1,1,2,2,3,3,4],[0,0,0,0,0,1,2,3,4,5,5,6,6,7,7,8],[0,0,0,2,4,5,6,7,8,9,9,10,10,11,11,12],[0,0,4,6,8,9,10,11,12,13,13,14,14,15,15,16],[0,4,8,10,12,13,14,15,16,17,17,18,18,19,19,20],[0,8,12,14,16,17,18,19,20,21,21,22,22,23,23,24],[0,12,16,18,20,21,22,23,24,25,25,26,26,27,27,28]],[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,2,3,4,5,6,7,8],[0,0,0,0,0,3,5,7,8,10,11,12,13,14,15,16],[0,0,0,5,8,11,13,15,16,18,19,20,21,22,23,24],[0,0,8,13,16,19,21,23,24,26,27,28,29,30,31,32],[0,8,16,21,24,27,29,31,32,34,35,36,37,38,39,40],[0,16,24,29,32,35,37,39,40,42,43,44,45,46,47,48],[0,24,32,37,40,43,45,47,48,50,51,52,53,54,55,56]],[[0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,0,4,6,8,10,12,14,16],[0,0,0,0,0,6,10,14,16,20,22,24,26,28,30,32],[0,0,0,10,16,22,26,30,32,36,38,40,42,44,46,48],[0,0,16,26,32,38,42,46,48,52,54,56,58,60,62,64],[0,16,32,42,48,54,58,62,64,68,70,72,74,76,78,80],[0,32,48,58,64,70,74,78,80,84,86,88,90,92,94,96],[0,48,64,74,80,86,90,94,96,100,102,104,106,108,110,112]]],this.MULTI_FACTORS=[1,2,4,6,8,10,12,14,16,18,20,20,24,24,30,30],this.RATE_DECAY_DURATIONS=[-1,-1,-1,-1,20926.6,16807.2,14006,12028.7,10463.3,8403.58,7002.98,6014.32,5231.64,4201.79,3501.49,3007.16,2615.82,2100.89,1750.75,1503.58,1307.91,1050.45,875.37,751.79,653.95,525.22,437.69,375.9,326.98,262.61,218.84,187.95,163.49,131.31,109.42,93.97,81.74,65.65,54.71,46.99,40.87,32.83,27.36,23.49,20.44,16.41,13.68,11.75,10.22,8.21,6.84,5.87,5.11,4.1,3.42,2.94,2.55,2.05,1.71,1.47,1.27,1.27,1.27,1.27],this.RATE_ATTACK_DURATIONS=[-1,-1,-1,-1,1730.15,1400.6,1153.43,988.66,865.08,700.3,576.72,494.33,432.54,350.15,288.36,247.16,216.27,175.07,144.18,123.58,108.13,87.54,72.09,61.79,54.07,43.77,36.04,30.9,27.03,21.88,18.02,15.45,13.52,10.94,9.01,7.72,6.76,5.47,4.51,3.86,3.38,2.74,2.25,1.93,1.69,1.37,1.13,.97,.84,.7,.6,.54,.5,.42,.34,.3,.28,.22,.18,.14,0,0,0,0]},wmsx.YM2413Audio=function(pName){"use strict";function init(){name=pName||"YM2413";var a=new wmsx.YM2413Tables;sineTable=a.getFullSineTable(),halfSineTable=a.getHalfSineTable(),expTable=a.getExpTable(),instrumentsParameters=a.getInstrumentsROM(),multiFactors=a.getMultiFactorsDoubled(),vibValues=a.getVIBValues(),kslValues=a.getKSLValues(),rateAttackDurTable=a.getRateAttackDurations(),rateDecayDurTable=a.getRateDecayDurations(),VOLPAN&&wmsx.AudioTables.setupVolPan(14,VOL,PAN,volPanL,volPanR)}function connectAudio(){audioSocket&&(audioSignal||(audioSignal=new wmsx.AudioSignal(name,self,VOLUME,SAMPLE_RATE,VOLPAN)),audioSocket.connectAudioSignal(audioSignal),audioConnected=!0)}function disconnectAudio(){audioSocket&&audioSignal&&audioSocket.disconnectAudioSignal(audioSignal),audioConnected=!1}function registerWrite(a,b){var c=15&a;c>8&&(c-=9);var d=c<<1,e=d+1,f=register[a]^b;switch(register[a]=b,a){case 0:case 1:case 2:case 3:case 4:case 5:case 6:case 7:f&&(instrumentsParameters[0][a]=b,updateCustomInstrChannels());break;case 14:32&f&&setRhythmMode(0!=(32&b)),rhythmMode&&(48&f&&(setRhythmKeyOnOp(12,(16&b)>>4),setRhythmKeyOnOp(13,(16&b)>>4)),40&f&&setRhythmKeyOnOp(15,(8&b)>>3),36&f&&setRhythmKeyOnOp(16,(4&b)>>2),34&f&&setRhythmKeyOnOp(17,(2&b)>>1),33&f&&setRhythmKeyOnOp(14,1&b));break;case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:f&&(fNum[d]=-256&fNum[d]|b,fNum[e]=fNum[d],updateFrequency(c));break;case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:32&f&&setSustain(c,(32&b)>>5),
16&f&&!(rhythmMode&&c>5)&&setKeyOn(c,(16&b)>>4),1&f&&(fNum[d]=-257&fNum[d]|(1&b)<<8,fNum[e]=fNum[d]),14&f&&(block[d]=b>>1&7,block[e]=block[d]),15&f&&updateFrequency(c);break;case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:rhythmMode&&c>5?(240&f&&c>6&&setVolumeOp(d,b>>>4),15&f&&setVolumeOp(e,15&b)):(240&f&&(audioConnected||connectAudio(),setInstr(c,b>>>4)),15&f&&setVolumeOp(e,15&b))}}function clockNoise(){noiseRegister>>=1,(noiseOutput=1&noiseRegister)&&(noiseRegister^=134230048)}function clockAM(){return!(511&clock)&&(0!==amLevel&&13!==amLevel||(amLevelInc=-amLevelInc),amLevel+=amLevelInc,!0)}function clockVIB(){return!(1023&clock)&&(vibPhase=clock>>10&7,!0)}function clockEnvelope(a){envLevel[a]===envStepNextAtLevel[a]?setEnvStepOp(a,envStepNext[a]):clock===envStepLevelIncClock[a]&&(envStepLevelIncClock[a]+=envStepLevelDur[a],envLevel[a]+=envStepLevelInc[a],updateEnvAttenuationOp(a))}function setSustain(a,b){sustain[a]=b}function setKeyOn(a,b){var c=a<<1,d=c+1;keyOn[c]=b,keyOn[d]=b,b?setEnvStep(a,DAMP):envStep[d]!==IDLE&&setEnvStepOp(d,RELEASE)}function setRhythmKeyOnOp(a,b){keyOn[a]=b,b?setEnvStepOp(a,DAMP):envStep[a]!==IDLE&&setEnvStepOp(a,RELEASE)}function setEnvStep(a,b){var c=a<<1,d=c+1;setEnvStepOp(c,b),setEnvStepOp(d,b)}function setEnvStepOp(a,b){switch(envStep[a]=b,b){case DAMP:envStepLevelDur[a]=rateDecayDurTable[48+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=ATTACK;break;case ATTACK:envStepLevelDur[a]=rateAttackDurTable[(ar[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=-8,envStepNextAtLevel[a]=0,envStepNext[a]=DECAY,phaseCounter[a]=0;break;case DECAY:envStepLevelDur[a]=rateDecayDurTable[(dr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=sl[a]<<3,envStepNext[a]=SUSTAIN;break;case SUSTAIN:envType[a]?(envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=SUSTAIN):(envStepLevelDur[a]=rateDecayDurTable[(rr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE);break;case RELEASE:var c=envType[a]?sustain[a>>1]?5:rr[a]:sustain[a>>1]?5:7;envStepLevelDur[a]=rateDecayDurTable[(c<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE;break;case IDLE:default:envLevel[a]=128,envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=IDLE}}function setRhythmMode(a){rhythmMode=a,rhythmMode?(audioConnected||connectAudio(),setInstr(6,16),setInstr(7,17),setInstr(8,18)):(setEnvStep(6,IDLE),updateEnvAttenuation(6),setEnvStep(7,IDLE),updateEnvAttenuation(7),setEnvStep(8,IDLE),updateEnvAttenuation(8),setInstr(6,register[36]>>4),setInstr(7,register[37]>>4),setInstr(8,register[38]>>4))}function setInstr(a,b){instr[a]=b;var c=a<<1,d=c+1,e=instrumentsParameters[b];am[c]=e[0]>>7&1,am[d]=e[1]>>7&1,vib[c]=e[0]>>6&1,vib[d]=e[1]>>6&1,envType[c]=e[0]>>5&1,envType[d]=e[1]>>5&1,ksr[c]=e[0]>>4&1,ksr[d]=e[1]>>4&1,multi[c]=multiFactors[15&e[0]],multi[d]=multiFactors[15&e[1]],ksl[c]=e[2]>>6,ksl[d]=e[3]>>6,modTL[c]=63&e[2],halfWave[c]=e[3]>>3&1,halfWave[d]=e[3]>>4&1,fbShift[a]=7&e[3]?8-(7&e[3]):0,ar[c]=e[4]>>4,ar[d]=e[5]>>4,dr[c]=15&e[4],dr[d]=15&e[5],sl[c]=e[6]>>4,sl[d]=e[7]>>4,rr[c]=15&e[6],rr[d]=15&e[7],updateAMAttenuation(a),updateFrequency(a),updateModAttenuationOp(c)}function updateCustomInstrChannels(){for(var a=0;a<9;a++)0===instr[a]&&setInstr(a,0)}function setVolumeOp(a,b){volume[a]=b,updateVolumeAttenuationOp(a)}function updateFrequency(a){var b=a<<1,c=b+1,d=vib[b]?vibValues[fNum[b]>>6][vibPhase]:0;phaseInc[b]=((fNum[b]<<1)+d)*multi[b]<<block[b]>>2,d=vib[c]?vibValues[fNum[c]>>6][vibPhase]:0,phaseInc[c]=((fNum[c]<<1)+d)*multi[c]<<block[c]>>2,updateKSLAttenuation(a),updateKSROffset(a)}function updateFrequencyOp(a){var b=vib[a]?vibValues[fNum[a]>>6][vibPhase]:0;phaseInc[a]=((fNum[a]<<1)+b)*multi[a]<<block[a]>>2,updateKSLAttenuationOp(a),updateKSROffsetOp(a)}function updateKSROffset(a){var b=a<<1,c=b+1;ksrOffset[b]=(ksr[b]?block[b]<<1:block[b]>>1)|fNum[b]>>>9-ksr[b],ksrOffset[c]=(ksr[c]?block[c]<<1:block[c]>>1)|fNum[c]>>>9-ksr[c]}function updateKSROffsetOp(a){ksrOffset[a]=(ksr[a]?block[a]<<1:block[a]>>1)|fNum[a]>>>9-ksr[a]}function updateAMAttenuation(a){var b=a<<1,c=b+1;amAtt[b]=am[b]?amLevel<<4:0,amAtt[c]=am[c]?amLevel<<4:0,updateTotalAttenuation(a)}function updateAMAttenuationOp(a){amAtt[a]=am[a]?amLevel<<4:0,updateTotalAttenuationOp(a)}function updateKSLAttenuation(a){var b=a<<1,c=b+1;kslAtt[b]=kslValues[ksl[b]][block[b]][fNum[b]>>>5]<<4,kslAtt[c]=kslValues[ksl[c]][block[c]][fNum[c]>>>5]<<4,updateTotalAttenuation(a)}function updateKSLAttenuationOp(a){kslAtt[a]=kslValues[ksl[a]][block[a]][fNum[a]>>>5]<<4,updateTotalAttenuationOp(a)}function updateEnvAttenuation(a){var b=a<<1,c=b+1;envAtt[b]=(128===envLevel[b]?256:envLevel[b])<<4,envAtt[c]=(128===envLevel[c]?256:envLevel[c])<<4,updateTotalAttenuation(a)}function updateEnvAttenuationOp(a){envAtt[a]=(128===envLevel[a]?256:envLevel[a])<<4,updateTotalAttenuationOp(a)}function updateModAttenuationOp(a){volModAtt[a]=modTL[a]<<5,updateTotalAttenuationOp(a)}function updateVolumeAttenuationOp(a){volModAtt[a]=(15===volume[a]?30:volume[a])<<7,updateTotalAttenuationOp(a)}function updateTotalAttenuation(a){var b=a<<1,c=b+1;totalAtt[b]=amAtt[b]+kslAtt[b]+envAtt[b]+volModAtt[b],totalAtt[c]=amAtt[c]+kslAtt[c]+envAtt[c]+volModAtt[c]}function updateTotalAttenuationOp(a){totalAtt[a]=amAtt[a]+kslAtt[a]+envAtt[a]+volModAtt[a]}var self=this;this.connect=function(a){a.bus.connectInputDevice(124,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectInputDevice(125,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectOutputDevice(124,this.output7C),a.bus.connectOutputDevice(125,this.output7D),audioSocket=a.getAudioSocket(),audioConnected&&connectAudio()},this.disconnect=function(a){a.bus.disconnectInputDevice(124,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectInputDevice(125,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(124,this.output7C),a.bus.disconnectOutputDevice(125,this.output7D),disconnectAudio(),audioSocket=null},this.powerOn=function(){this.reset()},this.powerOff=function(){disconnectAudio()},this.reset=function(){registerAddress=0,wmsx.Util.arrayFill(register,0),wmsx.Util.arrayFill(instrumentsParameters[0],0),clock=0,noiseRegister=65535,noiseOutput=0,amLevel=0,amLevelInc=-1,vibPhase=0,rhythmMode=!1,wmsx.Util.arrayFill(sustain,0),wmsx.Util.arrayFill(instr,0),wmsx.Util.arrayFill(keyOn,0),wmsx.Util.arrayFill(am,0),wmsx.Util.arrayFill(vib,0),wmsx.Util.arrayFill(envType,0),wmsx.Util.arrayFill(ksr,0),wmsx.Util.arrayFill(multi,0),wmsx.Util.arrayFill(ksl,0),wmsx.Util.arrayFill(halfWave,0),wmsx.Util.arrayFill(ar,0),wmsx.Util.arrayFill(dr,0),wmsx.Util.arrayFill(sl,0),wmsx.Util.arrayFill(rr,0),wmsx.Util.arrayFill(fNum,0),wmsx.Util.arrayFill(block,0),wmsx.Util.arrayFill(volume,0),wmsx.Util.arrayFill(modTL,0),wmsx.Util.arrayFill(fbShift,0),wmsx.Util.arrayFill(volModAtt,0),wmsx.Util.arrayFill(amAtt,0),wmsx.Util.arrayFill(envAtt,0),wmsx.Util.arrayFill(kslAtt,0),wmsx.Util.arrayFill(totalAtt,0),wmsx.Util.arrayFill(envStep,IDLE),wmsx.Util.arrayFill(envStepLevelDur,0),wmsx.Util.arrayFill(envStepLevelIncClock,0),wmsx.Util.arrayFill(envStepLevelInc,0),wmsx.Util.arrayFill(envStepNext,DAMP),wmsx.Util.arrayFill(envStepNextAtLevel,0),wmsx.Util.arrayFill(envLevel,0),wmsx.Util.arrayFill(ksrOffset,0),wmsx.Util.arrayFill(fbLastMod1,0),wmsx.Util.arrayFill(fbLastMod2,0),wmsx.Util.arrayFill(phaseInc,0),wmsx.Util.arrayFill(phaseCounter,0),disconnectAudio()},this.output7C=function(a){registerAddress=63&a},
this.output7D=function(a){registerWrite(registerAddress,a)},this.nextSample=function(){var a,b,c,d,e,f,g=!1;++clock,(a=clockAM())&&(g=clockVIB());for(var h=0,i=0,j=0,k=0,l=rhythmMode?5:8,m=l;m>=0;--m)b=m<<1,c=b+1,envStep[c]!==IDLE&&(a&&(am[b]&&updateAMAttenuationOp(b),am[c]&&updateAMAttenuationOp(c),g&&(vib[b]&&updateFrequencyOp(b),vib[c]&&updateFrequencyOp(c))),envStep[b]!==IDLE&&clockEnvelope(b),clockEnvelope(c),d=(phaseCounter[b]+=phaseInc[b])>>9,e=(phaseCounter[c]+=phaseInc[c])>>9,fbShift[m]?(d+=fbLastMod1[m]+fbLastMod2[m]>>fbShift[m],f=expTable[(halfWave[b]?halfSineTable:sineTable)[1023&d]+totalAtt[b]],fbLastMod2[m]=fbLastMod1[m]>>1,fbLastMod1[m]=f>>1):f=expTable[(halfWave[b]?halfSineTable:sineTable)[1023&d]+totalAtt[b]],h=expTable[(halfWave[c]?halfSineTable:sineTable)[e+f&1023]+totalAtt[c]]>>4,VOLPAN?(i+=h*volPanL[m],j+=h*volPanR[m]):k+=h);if(rhythmMode&&(clockNoise(),c=13,envStep[c]!==IDLE&&(b=12,clockEnvelope(b),clockEnvelope(c),d=((phaseCounter[b]+=phaseInc[b])>>9)-1,e=(phaseCounter[c]+=phaseInc[c])>>9,f=expTable[sineTable[1023&d]+totalAtt[b]],h=expTable[sineTable[e+f&1023]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[9],j+=h*volPanR[9]):k+=h),c=15,envStep[c]!==IDLE&&(clockEnvelope(c),e=(phaseCounter[c]+=phaseInc[c])>>9,h=expTable[sineTable[256&e?noiseOutput?0:130:noiseOutput?0:893]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[10],j+=h*volPanR[10]):k+=h),c=16,envStep[c]!==IDLE&&(clockEnvelope(c),e=(phaseCounter[c]+=phaseInc[c])>>9,h=expTable[sineTable[1023&e]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[11],j+=h*volPanR[11]):k+=h),envStep[17]!==IDLE||envStep[14]!==IDLE)){var n=(phaseCounter[14]+=phaseInc[14])>>9,o=(phaseCounter[17]+=phaseInc[17])>>9,p=(0!=(4&o)&&0==(16&o))!=(0!=(2&n)!=(0!=(256&n))||0!=(4&n));c=17,envStep[c]!==IDLE&&(clockEnvelope(c),h=expTable[sineTable[p?200:823]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[12],j+=h*volPanR[12]):k+=h),c=14,envStep[c]!==IDLE&&(clockEnvelope(c),h=expTable[sineTable[p?noiseOutput?40:10:noiseOutput?983:1013]+totalAtt[c]]>>3,VOLPAN?(i+=h*volPanL[13],j+=h*volPanR[13]):k+=h)}return VOLPAN?(sampleResult[0]=i,sampleResult[1]=j,sampleResult):k};var name,audioConnected=!1,IDLE=255,DAMP=0,ATTACK=1,DECAY=2,SUSTAIN=3,RELEASE=4,clock,noiseRegister,noiseOutput,amLevel,amLevelInc,vibPhase,registerAddress,register=new Array(56),rhythmMode,sustain=new Array(9),instr=new Array(9),keyOn=new Array(18),am=new Array(18),vib=new Array(18),envType=new Array(18),ksr=new Array(18),multi=new Array(18),ksl=new Array(18),halfWave=new Array(18),ar=new Array(18),dr=new Array(18),sl=new Array(18),rr=new Array(18),fNum=new Array(18),block=new Array(18),volume=new Array(18),modTL=new Array(18),fbShift=new Array(9),volModAtt=new Array(18),amAtt=new Array(18),envAtt=new Array(18),kslAtt=new Array(18),totalAtt=new Array(18),envStep=new Array(18),envStepLevelDur=new Array(18),envStepLevelIncClock=new Array(18),envStepLevelInc=new Array(18),envStepNext=new Array(18),envStepNextAtLevel=new Array(18),envLevel=new Array(18),ksrOffset=new Array(18),fbLastMod1=new Array(9),fbLastMod2=new Array(9),phaseInc=new Array(18),phaseCounter=new Array(18),volPanL=new Array(14),volPanR=new Array(14),sineTable,halfSineTable,expTable,instrumentsParameters,multiFactors,vibValues,kslValues,rateAttackDurTable,rateDecayDurTable,audioSocket,audioSignal,sampleResult=[0,0],VOLUME=1.58/9/256*.68,SAMPLE_RATE=49780,VOL=(WMSX.OPLL_VOL||"f").toUpperCase(),PAN=(WMSX.OPLL_PAN||"8").toUpperCase(),VOLPAN="F"!==VOL||"8"!==PAN;this.saveState=function(){return{n:name,ac:audioConnected,ra:registerAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),c:clock,nr:noiseRegister,no:noiseOutput,al:amLevel,ai:amLevelInc,vp:vibPhase,amt:wmsx.Util.storeInt16BitArrayToStringBase64(amAtt),evt:wmsx.Util.storeInt16BitArrayToStringBase64(envAtt),kst:wmsx.Util.storeInt16BitArrayToStringBase64(kslAtt),tot:wmsx.Util.storeInt16BitArrayToStringBase64(totalAtt),evs:wmsx.Util.storeInt8BitArrayToStringBase64(envStep),evd:wmsx.Util.storeInt32BitArrayToStringBase64(envStepLevelDur),evc:envStepLevelIncClock,evi:wmsx.Util.storeInt8BitArrayToStringBase64(envStepLevelInc),evn:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNext),evl:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNextAtLevel),eve:wmsx.Util.storeInt8BitArrayToStringBase64(envLevel),kso:wmsx.Util.storeInt8BitArrayToStringBase64(ksrOffset),fb1:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod1),fb2:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod2)}},this.loadState=function(a){this.reset(),name=a.n,audioConnected=a.ac,registerAddress=a.ra;for(var b=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r),c=0;c<b.length;c++)registerWrite(c,b[c]);clock=a.c,noiseRegister=a.nr,noiseOutput=a.no,amLevel=a.al,amLevelInc=a.ai,vibPhase=a.vp,amAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.amt,amAtt),envAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.evt,envAtt),kslAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.kst,kslAtt),totalAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.tot,totalAtt),envStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evs,envStep),envStepLevelDur=wmsx.Util.restoreStringBase64ToInt32BitArray(a.evd),envStepLevelIncClock=a.evc,envStepLevelInc=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.evi,envStepLevelInc),envStepNext=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evn,envStepNext),envStepNextAtLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evl,envStepNextAtLevel),envLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.eve,envLevel),ksrOffset=wmsx.Util.restoreStringBase64ToInt8BitArray(a.kso,ksrOffset),fbLastMod1=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb1,fbLastMod1),fbLastMod2=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb2,fbLastMod2),audioConnected&&connectAudio()},init(),this.eval=function(str){return eval(str)}},wmsx.OPL4WaveTables=function(){"use strict";this.getRegisterWriteMasks=function(){var a,b=wmsx.Util.arrayFill(new Array(256),255);for(b[0]=b[1]=0,b[2]=29,b[3]=63,b[7]=0,a=128;a<=151;++a)b[a]=63;for(a=224;a<=247;++a)b[a]=7;for(b[248]=b[249]=63,a=250;a<=255;++a)b[a]=0;return b},this.getPanPotValues=function(){return this.PANPOT_VALUES},this.getVolumeTable=function(){for(var a=new Array(2048),b=0;b<1024;++b)a[b]=Math.pow(10,-.1875*b/20);for(b=1024;b<2048;++b)a[b]=0;return a},this.getRateAttackPatterns=function(){for(var a=new Array(832),b=0;b<64;++b)for(var c=0;c<8;++c)a[8*b+c]=b<52?this.RATE_ATTACK_SHIFTS[3&b][c]:this.RATE_ATTACK_SHIFTS[b-52+4][c];for(c=512;c<832;++c)a[c]=0;return a},this.getRateDecayPatterns=function(){for(var a=new Array(832),b=0;b<64;++b)for(var c=0;c<8;++c)a[8*b+c]=b<56?this.RATE_DECAY_INCS[3&b][c]:this.RATE_DECAY_INCS[b-56+4][c];for(c=512;c<832;++c)a[c]=2;return a},this.getLFOStepClocks=function(){for(var a=new Array(8),b=0;b<8;++b)a[b]=Math.round(44100/this.LFO_FREQS[b]/128);return a},this.getVIBOffsets=function(){for(var a=new Array(1024),b=0;b<8;++b)for(var c=this.VIB_DEPTHS[b],d=0;d<128;++d)a[128*b+d]=Math.round(d<32?d/32*c:d<96?(64-d)/32*c:(d-128)/32*c);return a},this.getAMOffsets=function(){for(var a=new Array(1024),b=0;b<8;++b)for(var c=this.AM_DEPTHS[b]/.1875,d=0;d<128;++d)a[128*b+d]=Math.round(d<64?d/64*c:(128-d)/64*c);return a},this.PANPOT_VALUES=[[0,16,32,48,64,80,96,512,512,0,0,0,0,0,0,0],[0,0,0,0,0,0,0,0,512,512,96,80,64,48,32,16]],this.RATE_ATTACK_SHIFTS=[[3,-1,3,-1,3,-1,4,4],[3,-1,3,3,-1,3,3,-1],[3,3,3,-1,3,3,3,-1],[3,3,3,-1,3,3,3,4],[3,-1,4,-1,3,-1,4,4],[3,-1,3,-1,3,-1,3,4],[3,4,4,4,3,4,4,4],[3,4,3,4,3,4,3,4],[3,3,3,4,3,3,3,4],[2,3,3,3,4,3,3,3],[2,3,3,2,3,3,2,3],[2,2,3,2,2,3,2,3],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[0,0,0,0,0,0,0,0]],this.RATE_DECAY_INCS=[[-1,1,-1,1,-1,1,-1,1],[-1,1,-1,1,1,-1,1,1],[-1,1,1,1,-1,1,1,1],[-1,1,1,1,1,1,1,1],[1,1,1,1,1,1,1,1],[1,1,1,2,1,1,1,2],[1,2,1,2,1,2,1,2],[1,2,2,2,1,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2],[2,2,2,2,2,2,2,2]],
this.LFO_FREQS=[.168,2.019,3.196,4.206,5.215,5.888,6.224,7.066],this.VIB_DEPTHS=[0,2,3,4,6,12,24,48],this.AM_DEPTHS=[0,1.781,2.906,3.656,4.406,5.906,7.406,11.91]},wmsx.OPL4Audio=function(pName,cart){"use strict";function init(a){name=pName||"OPL4",a.fm=fm=new wmsx.OPL4AudioFM(a),a.wave=wave=new wmsx.OPL4AudioWave(a)}function connectAudio(){audioSocket&&(audioSignal||(audioSignal=new wmsx.AudioSignal(name,self,VOLUME,SAMPLE_RATE,!0,CLOCK)),audioSocket.connectAudioSignal(audioSignal),audioConnected=!0)}function disconnectAudio(){audioSocket&&audioSignal&&audioSocket.disconnectAudioSignal(audioSignal),audioConnected=!1}var self=this;this.connect=function(a){fm.connect(a),wave.connect(a),audioSocket=a.getAudioSocket(),audioConnected&&connectAudio()},this.disconnect=function(a){fm.disconnect(a),wave.disconnect(a),disconnectAudio(),audioSocket=null},this.powerOn=function(){this.reset()},this.powerOff=function(){disconnectAudio()},this.reset=function(){connectAudio(),fm.reset(),wave.reset()},this.audioClockPulse=function(){fm.audioClockPulse()},this.nextSample=function(){return wave.nextSample()},this.memoryRead=cart.opl4ReadMemory,this.memoryWrite=cart.opl4WriteMemory;var name,audioConnected=!1,fm,wave,audioSocket,audioSignal,VOLUME=7/24/32768*.66,SAMPLE_RATE=44100,CLOCK=49780;this.saveState=function(){return{n:name,ac:audioConnected,fm:fm.saveState(),wv:wave.saveState()}},this.loadState=function(a){this.reset(),name=a.n,audioConnected=a.ac,fm.loadState(a.fm),wave.loadState(a.wv),audioConnected&&connectAudio()},init(this),this.eval=function(str){return eval(str)}},wmsx.OPL4AudioFM=function(opl4){"use strict";function init(){var a=new wmsx.YM2413Tables;sineTable=a.getFullSineTable(),halfSineTable=a.getHalfSineTable(),expTable=a.getExpTable(),instrumentsParameters=a.getInstrumentsROM(),multiFactors=a.getMultiFactorsDoubled(),vibValues=a.getVIBValues(),kslValues=a.getKSLValues(),rateAttackDurTable=a.getRateAttackDurations(),rateDecayDurTable=a.getRateDecayDurations()}function clockTimers(){timer1Active&&++timer1Counter>255&&(timer1Counter=register[2],timer1Masked||(status|=192,updateIRQ())),timer2Active&&0==(15&clock)&&++timer2Counter>255&&(timer2Counter=register[3],timer2Masked||(status|=160,updateIRQ()))}function updateIRQ(){cpu.setINTChannel(2,0==(128&status))}function connectAudio(){}function registerWrite(a,b){if(4===a&&128&b)return register[4]&=-129,status=0,void updateIRQ();var c=register[a]^b;switch(register[a]=b,a){case 4:1&c&&(timer1Active=0!=(1&b))&&(timer1Counter=register[2]),2&c&&(timer2Active=0!=(2&b))&&(timer2Counter=register[3]),64&c&&(timer1Masked=0!=(64&b)),32&c&&(timer2Masked=0!=(32&b))}}function clockNoise(){noiseRegister>>=1,(noiseOutput=1&noiseRegister)&&(noiseRegister^=134230048)}function clockAM(){return!(511&clock)&&(0!==amLevel&&13!==amLevel||(amLevelInc=-amLevelInc),amLevel+=amLevelInc,!0)}function clockVIB(){return!(1023&clock)&&(vibPhase=clock>>10&7,!0)}function clockEnvelope(a){envLevel[a]===envStepNextAtLevel[a]?setEnvStepOp(a,envStepNext[a]):clock===envStepLevelIncClock[a]&&(envStepLevelIncClock[a]+=envStepLevelDur[a],envLevel[a]+=envStepLevelInc[a],updateEnvAttenuationOp(a))}function setSustain(a,b){sustain[a]=b}function setKeyOn(a,b){var c=a<<1,d=c+1;keyOn[c]=b,keyOn[d]=b,b?setEnvStep(a,DAMP):envStep[d]!==IDLE&&setEnvStepOp(d,RELEASE)}function setRhythmKeyOnOp(a,b){keyOn[a]=b,b?setEnvStepOp(a,DAMP):envStep[a]!==IDLE&&setEnvStepOp(a,RELEASE)}function setEnvStep(a,b){var c=a<<1,d=c+1;setEnvStepOp(c,b),setEnvStepOp(d,b)}function setEnvStepOp(a,b){switch(envStep[a]=b,b){case DAMP:envStepLevelDur[a]=rateDecayDurTable[48+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=ATTACK;break;case ATTACK:envStepLevelDur[a]=rateAttackDurTable[(ar[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=-8,envStepNextAtLevel[a]=0,envStepNext[a]=DECAY,phaseCounter[a]=0;break;case DECAY:envStepLevelDur[a]=rateDecayDurTable[(dr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=sl[a]<<3,envStepNext[a]=SUSTAIN;break;case SUSTAIN:envType[a]?(envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=SUSTAIN):(envStepLevelDur[a]=rateDecayDurTable[(rr[a]<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE);break;case RELEASE:var c=envType[a]?sustain[a>>1]?5:rr[a]:sustain[a>>1]?5:7;envStepLevelDur[a]=rateDecayDurTable[(c<<2)+ksrOffset[a]],envStepLevelIncClock[a]=clock+envStepLevelDur[a],envStepLevelInc[a]=1,envStepNextAtLevel[a]=128,envStepNext[a]=IDLE;break;case IDLE:default:envLevel[a]=128,envStepLevelIncClock[a]=envStepLevelDur[a]=0,envStepLevelInc[a]=0,envStepNextAtLevel[a]=255,envStepNext[a]=IDLE}}function setRhythmMode(a){rhythmMode=a,rhythmMode?(audioConnected||connectAudio(),setInstr(6,16),setInstr(7,17),setInstr(8,18)):(setEnvStep(6,IDLE),updateEnvAttenuation(6),setEnvStep(7,IDLE),updateEnvAttenuation(7),setEnvStep(8,IDLE),updateEnvAttenuation(8),setInstr(6,register[36]>>4),setInstr(7,register[37]>>4),setInstr(8,register[38]>>4))}function setInstr(a,b){instr[a]=b;var c=a<<1,d=c+1,e=instrumentsParameters[b];am[c]=e[0]>>7&1,am[d]=e[1]>>7&1,vib[c]=e[0]>>6&1,vib[d]=e[1]>>6&1,envType[c]=e[0]>>5&1,envType[d]=e[1]>>5&1,ksr[c]=e[0]>>4&1,ksr[d]=e[1]>>4&1,multi[c]=multiFactors[15&e[0]],multi[d]=multiFactors[15&e[1]],ksl[c]=e[2]>>6,ksl[d]=e[3]>>6,modTL[c]=63&e[2],halfWave[c]=e[3]>>3&1,halfWave[d]=e[3]>>4&1,fbShift[a]=7&e[3]?8-(7&e[3]):0,ar[c]=e[4]>>4,ar[d]=e[5]>>4,dr[c]=15&e[4],dr[d]=15&e[5],sl[c]=e[6]>>4,sl[d]=e[7]>>4,rr[c]=15&e[6],rr[d]=15&e[7],updateAMAttenuation(a),updateFrequency(a),updateModAttenuationOp(c)}function updateCustomInstrChannels(){for(var a=0;a<9;a++)0===instr[a]&&setInstr(a,0)}function setVolumeOp(a,b){volume[a]=b,updateVolumeAttenuationOp(a)}function updateFrequency(a){var b=a<<1,c=b+1,d=vib[b]?vibValues[fNum[b]>>6][vibPhase]:0;phaseInc[b]=((fNum[b]<<1)+d)*multi[b]<<block[b]>>2,d=vib[c]?vibValues[fNum[c]>>6][vibPhase]:0,phaseInc[c]=((fNum[c]<<1)+d)*multi[c]<<block[c]>>2,updateKSLAttenuation(a),updateKSROffset(a)}function updateFrequencyOp(a){var b=vib[a]?vibValues[fNum[a]>>6][vibPhase]:0;phaseInc[a]=((fNum[a]<<1)+b)*multi[a]<<block[a]>>2,updateKSLAttenuationOp(a),updateKSROffsetOp(a)}function updateKSROffset(a){var b=a<<1,c=b+1;ksrOffset[b]=(ksr[b]?block[b]<<1:block[b]>>1)|fNum[b]>>>9-ksr[b],ksrOffset[c]=(ksr[c]?block[c]<<1:block[c]>>1)|fNum[c]>>>9-ksr[c]}function updateKSROffsetOp(a){ksrOffset[a]=(ksr[a]?block[a]<<1:block[a]>>1)|fNum[a]>>>9-ksr[a]}function updateAMAttenuation(a){var b=a<<1,c=b+1;amAtt[b]=am[b]?amLevel<<4:0,amAtt[c]=am[c]?amLevel<<4:0,updateTotalAttenuation(a)}function updateAMAttenuationOp(a){amAtt[a]=am[a]?amLevel<<4:0,updateTotalAttenuationOp(a)}function updateKSLAttenuation(a){var b=a<<1,c=b+1;kslAtt[b]=kslValues[ksl[b]][block[b]][fNum[b]>>>5]<<4,kslAtt[c]=kslValues[ksl[c]][block[c]][fNum[c]>>>5]<<4,updateTotalAttenuation(a)}function updateKSLAttenuationOp(a){kslAtt[a]=kslValues[ksl[a]][block[a]][fNum[a]>>>5]<<4,updateTotalAttenuationOp(a)}function updateEnvAttenuation(a){var b=a<<1,c=b+1;envAtt[b]=(128===envLevel[b]?256:envLevel[b])<<4,envAtt[c]=(128===envLevel[c]?256:envLevel[c])<<4,updateTotalAttenuation(a)}function updateEnvAttenuationOp(a){envAtt[a]=(128===envLevel[a]?256:envLevel[a])<<4,updateTotalAttenuationOp(a)}function updateModAttenuationOp(a){volModAtt[a]=modTL[a]<<5,updateTotalAttenuationOp(a)}function updateVolumeAttenuationOp(a){volModAtt[a]=(15===volume[a]?30:volume[a])<<7,updateTotalAttenuationOp(a)}function updateTotalAttenuation(a){var b=a<<1,c=b+1;totalAtt[b]=amAtt[b]+kslAtt[b]+envAtt[b]+volModAtt[b],totalAtt[c]=amAtt[c]+kslAtt[c]+envAtt[c]+volModAtt[c]}function updateTotalAttenuationOp(a){
totalAtt[a]=amAtt[a]+kslAtt[a]+envAtt[a]+volModAtt[a]}var self=this;this.connect=function(a){cpu=a.cpu,a.bus.connectInputDevice(196,this.inputC4),a.bus.connectOutputDevice(196,this.outputC4),a.bus.connectInputDevice(197,this.inputC5),a.bus.connectOutputDevice(197,this.outputC5),a.bus.connectInputDevice(198,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectOutputDevice(198,this.outputC6),a.bus.connectInputDevice(199,this.inputC5),a.bus.connectOutputDevice(199,this.outputC5)},this.disconnect=function(a){a.bus.disconnectInputDevice(196,this.inputC4),a.bus.disconnectOutputDevice(196,this.outputC4),a.bus.disconnectInputDevice(197,this.inputC5),a.bus.disconnectOutputDevice(197,this.outputC5),a.bus.disconnectInputDevice(198,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(198,this.outputC6),a.bus.disconnectInputDevice(199,this.inputC5),a.bus.disconnectOutputDevice(199,this.outputC5)},this.reset=function(){status=0,registerAddress=0,wmsx.Util.arrayFill(register,0),clock=0,busyUntilBUSCycle=0,timer1Counter=timer2Counter=0,timer1Active=timer2Active=!1,timer1Masked=timer2Masked=0,wmsx.Util.arrayFill(instrumentsParameters[0],0),noiseRegister=65535,noiseOutput=0,amLevel=0,amLevelInc=-1,vibPhase=0,rhythmMode=!1,wmsx.Util.arrayFill(sustain,0),wmsx.Util.arrayFill(instr,0),wmsx.Util.arrayFill(keyOn,0),wmsx.Util.arrayFill(am,0),wmsx.Util.arrayFill(vib,0),wmsx.Util.arrayFill(envType,0),wmsx.Util.arrayFill(ksr,0),wmsx.Util.arrayFill(multi,0),wmsx.Util.arrayFill(ksl,0),wmsx.Util.arrayFill(halfWave,0),wmsx.Util.arrayFill(ar,0),wmsx.Util.arrayFill(dr,0),wmsx.Util.arrayFill(sl,0),wmsx.Util.arrayFill(rr,0),wmsx.Util.arrayFill(fNum,0),wmsx.Util.arrayFill(block,0),wmsx.Util.arrayFill(volume,0),wmsx.Util.arrayFill(modTL,0),wmsx.Util.arrayFill(fbShift,0),wmsx.Util.arrayFill(volModAtt,0),wmsx.Util.arrayFill(amAtt,0),wmsx.Util.arrayFill(envAtt,0),wmsx.Util.arrayFill(kslAtt,0),wmsx.Util.arrayFill(totalAtt,0),wmsx.Util.arrayFill(envStep,IDLE),wmsx.Util.arrayFill(envStepLevelDur,0),wmsx.Util.arrayFill(envStepLevelIncClock,0),wmsx.Util.arrayFill(envStepLevelInc,0),wmsx.Util.arrayFill(envStepNext,DAMP),wmsx.Util.arrayFill(envStepNextAtLevel,0),wmsx.Util.arrayFill(envLevel,0),wmsx.Util.arrayFill(ksrOffset,0),wmsx.Util.arrayFill(fbLastMod1,0),wmsx.Util.arrayFill(fbLastMod2,0),wmsx.Util.arrayFill(phaseInc,0),wmsx.Util.arrayFill(phaseCounter,0)},this.inputC4=function(){return status},this.outputC4=function(a){registerAddress=a},this.inputC5=function(){return register[registerAddress]},this.outputC5=function(a){registerWrite(registerAddress,a)},this.outputC6=function(a){registerAddress=256|a},this.audioClockPulse=function(){0==(3&++clock)&&clockTimers()},this.setBusyCycles=function(a){},this.nextSample=function(){return 0};var cpu,busyUntilBUSCycle,audioConnected=!1,status=0,registerAddress=0,register=new Array(56),timer1Counter=0,timer2Counter=0,timer1Active=!1,timer2Active=!1,timer1Masked=!1,timer2Masked=!1,IDLE=255,DAMP=0,ATTACK=1,DECAY=2,SUSTAIN=3,RELEASE=4,clock,noiseRegister,noiseOutput,amLevel,amLevelInc,vibPhase,rhythmMode,sustain=new Array(9),instr=new Array(9),keyOn=new Array(18),am=new Array(18),vib=new Array(18),envType=new Array(18),ksr=new Array(18),multi=new Array(18),ksl=new Array(18),halfWave=new Array(18),ar=new Array(18),dr=new Array(18),sl=new Array(18),rr=new Array(18),fNum=new Array(18),block=new Array(18),volume=new Array(18),modTL=new Array(18),fbShift=new Array(9),volModAtt=new Array(18),amAtt=new Array(18),envAtt=new Array(18),kslAtt=new Array(18),totalAtt=new Array(18),envStep=new Array(18),envStepLevelDur=new Array(18),envStepLevelIncClock=new Array(18),envStepLevelInc=new Array(18),envStepNext=new Array(18),envStepNextAtLevel=new Array(18),envLevel=new Array(18),ksrOffset=new Array(18),fbLastMod1=new Array(9),fbLastMod2=new Array(9),phaseInc=new Array(18),phaseCounter=new Array(18),sineTable,halfSineTable,expTable,instrumentsParameters,multiFactors,vibValues,kslValues,rateAttackDurTable,rateDecayDurTable,VOLUME=1.55/9/256*.65;this.saveState=function(){return{ac:audioConnected,s:status,ra:registerAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),c:clock,nr:noiseRegister,no:noiseOutput,al:amLevel,ai:amLevelInc,vp:vibPhase,t1c:timer1Counter,t2c:timer2Counter,t1a:timer1Active,t2a:timer2Active,t1m:timer1Masked,t2m:timer2Masked,amt:wmsx.Util.storeInt16BitArrayToStringBase64(amAtt),evt:wmsx.Util.storeInt16BitArrayToStringBase64(envAtt),kst:wmsx.Util.storeInt16BitArrayToStringBase64(kslAtt),tot:wmsx.Util.storeInt16BitArrayToStringBase64(totalAtt),evs:wmsx.Util.storeInt8BitArrayToStringBase64(envStep),evd:wmsx.Util.storeInt32BitArrayToStringBase64(envStepLevelDur),evc:envStepLevelIncClock,evi:wmsx.Util.storeInt8BitArrayToStringBase64(envStepLevelInc),evn:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNext),evl:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNextAtLevel),eve:wmsx.Util.storeInt8BitArrayToStringBase64(envLevel),kso:wmsx.Util.storeInt8BitArrayToStringBase64(ksrOffset),fb1:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod1),fb2:wmsx.Util.storeInt16BitArrayToStringBase64(fbLastMod2)}},this.loadState=function(a){this.reset(),audioConnected=a.ac,status=a.s,registerAddress=a.ra;for(var b=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r),c=0;c<b.length;c++)registerWrite(c,b[c]);clock=a.c,noiseRegister=a.nr,noiseOutput=a.no,amLevel=a.al,amLevelInc=a.ai,vibPhase=a.vp,timer1Counter=a.t1c,timer2Counter=a.t2c,timer1Active=a.t1a,timer2Active=a.t2a,timer1Masked=a.t1m,timer2Masked=a.t2m,amAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.amt,amAtt),envAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.evt,envAtt),kslAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.kst,kslAtt),totalAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.tot,totalAtt),envStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evs,envStep),envStepLevelDur=wmsx.Util.restoreStringBase64ToInt32BitArray(a.evd),envStepLevelIncClock=a.evc,envStepLevelInc=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.evi,envStepLevelInc),envStepNext=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evn,envStepNext),envStepNextAtLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evl,envStepNextAtLevel),envLevel=wmsx.Util.restoreStringBase64ToInt8BitArray(a.eve,envLevel),ksrOffset=wmsx.Util.restoreStringBase64ToInt8BitArray(a.kso,ksrOffset),fbLastMod1=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb1,fbLastMod1),fbLastMod2=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.fb2,fbLastMod2)},init(),this.eval=function(str){return eval(str)}},wmsx.OPL4AudioWave=function(opl4){"use strict";function init(){var a=new wmsx.OPL4WaveTables;regWriteMasks=a.getRegisterWriteMasks(),rateAttackPatterns=a.getRateAttackPatterns(),rateDecayPatterns=a.getRateDecayPatterns(),lfoStepClocks=a.getLFOStepClocks(),vibStepOffsets=a.getVIBOffsets(),amStepOffsets=a.getAMOffsets(),panpotValues=a.getPanPotValues(),volumeTable=a.getVolumeTable()}function registerWrite(a,b){var c,d=register[a]^b,e=regWriteMasks[a];switch(register[a]=register[a]&~e|b&e,a){case 5:memoryAddress=(63&register[3])<<16|register[4]<<8|register[5];break;case 6:opl4.memoryWrite(memoryAddress,b),++memoryAddress>=4194304&&(memoryAddress=0);break;case 8:case 9:case 10:case 11:case 12:case 13:case 14:case 15:case 16:case 17:case 18:case 19:case 20:case 21:case 22:case 23:case 24:case 25:case 26:case 27:case 28:case 29:case 30:case 31:c=a-8,readWaveHeader(c,(1&register[32+c])<<8|b);break;case 32:case 33:case 34:case 35:case 36:case 37:case 38:case 39:case 40:case 41:case 42:case 43:case 44:case 45:case 46:case 47:case 48:case 49:case 50:case 51:case 52:case 53:case 54:case 55:c=a-32,254&d&&(fNum[c]=b>>1|(7&register[56+c])<<7,updateFrequency(c));break;case 56:case 57:case 58:case 59:case 60:case 61:case 62:case 63:case 64:case 65:case 66:case 67:case 68:case 69:case 70:case 71:case 72:case 73:case 74:case 75:case 76:case 77:case 78:case 79:
c=a-56,240&d&&(octave[c]=128&b?(b>>4)-16:b>>4),7&d&&(fNum[c]=(7&b)<<7|register[32+c]>>1),247&d&&updateFrequency(c),8&d&&(reverb[c]=(8&b)>>3);break;case 80:case 81:case 82:case 83:case 84:case 85:case 86:case 87:case 88:case 89:case 90:case 91:case 92:case 93:case 94:case 95:case 96:case 97:case 98:case 99:case 100:case 101:case 102:case 103:c=a-80,254&d&&(volumeAtt[c]=254&b,updateSettingsAttenuation(c));break;case 104:case 105:case 106:case 107:case 108:case 109:case 110:case 111:case 112:case 113:case 114:case 115:case 116:case 117:case 118:case 119:case 120:case 121:case 122:case 123:case 124:case 125:case 126:case 127:c=a-104,192&d&&setKeyOnAndDamp(c,128&b,64&b),32&d&&setLFOReset(c,32&b),15&d&&(panpotAttL[c]=panpotValues[0][15&b],panpotAttR[c]=panpotValues[1][15&b],updateSettingsAttenuation(c));break;case 128:case 129:case 130:case 131:case 132:case 133:case 134:case 135:case 136:case 137:case 138:case 139:case 140:case 141:case 142:case 143:case 144:case 145:case 146:case 147:case 148:case 149:case 150:case 151:c=a-128,56&d&&(lfoStepDur[c]=lfoStepClocks[(56&b)>>3]),7&d&&(vibDepth[c]=7&b,updateVIBOffset(c,lfoStep[c]));break;case 152:case 153:case 154:case 155:case 156:case 157:case 158:case 159:case 160:case 161:case 162:case 163:case 164:case 165:case 166:case 167:case 168:case 169:case 170:case 171:case 172:case 173:case 174:case 175:c=a-152,240&d&&(ar[c]=b>=240?63:(240&b)>>2),15&d&&(d1r[c]=15==(15&b)?63:(15&b)<<2);break;case 176:case 177:case 178:case 179:case 180:case 181:case 182:case 183:case 184:case 185:case 186:case 187:case 188:case 189:case 190:case 191:case 192:case 193:case 194:case 195:case 196:case 197:case 198:case 199:c=a-176,240&d&&(dl[c]=(b>=240?31:b>>4)<<4),15&d&&(d2r[c]=15==(15&b)?63:(15&b)<<2);break;case 200:case 201:case 202:case 203:case 204:case 205:case 206:case 207:case 208:case 209:case 210:case 211:case 212:case 213:case 214:case 215:case 216:case 217:case 218:case 219:case 220:case 221:case 222:case 223:c=a-200,240&d&&(rc[c]=b>>4,updateRateCorrOffset(c)),15&d&&(rr[c]=15==(15&b)?63:(15&b)<<2);break;case 224:case 225:case 226:case 227:case 228:case 229:case 230:case 231:case 232:case 233:case 234:case 235:case 236:case 237:case 238:case 239:case 240:case 241:case 242:case 243:case 244:case 245:case 246:case 247:c=a-224,7&d&&(amDepth[c]=7&b,updateAMAttenuation(c,lfoStep[c]));break;case 249:if(63&d)for(mixerAttL=7==(7&b)?512:(7&b)<<4,mixerAttR=56==(56&b)?512:(56&b)<<1,c=23;c>=0;--c)updateSettingsAttenuation(c)}}function registerRead(a){var b;switch(a){case 6:b=opl4.memoryRead(memoryAddress),++memoryAddress>=4194304&&(memoryAddress=0);break;default:b=register[a]}return b}function readWaveHeader(a,b){var c=register[2]>>2&7,d=b<384||0===c?12*b:(c<<19)+12*(b-384),e=opl4.memoryRead(d++);dataBits[a]=e>>6,startAddress[a]=(63&e)<<16|opl4.memoryRead(d++)<<8|opl4.memoryRead(d++),loopPosition[a]=opl4.memoryRead(d++)<<8|opl4.memoryRead(d++),endPosition[a]=65535&~(opl4.memoryRead(d++)<<8|opl4.memoryRead(d++)),registerWrite(128+a,opl4.memoryRead(d++)),registerWrite(152+a,opl4.memoryRead(d++)),registerWrite(176+a,opl4.memoryRead(d++)),registerWrite(200+a,opl4.memoryRead(d++)),registerWrite(224+a,opl4.memoryRead(d++)),envStep[a]!==IDLE&&startSample(a)}function clockLFO(a){return clock!==lfoStepChangeClock[a]?-1:(lfoStepChangeClock[a]+=lfoStepDur[a],lfoStep[a]=lfoStep[a]+1&127)}function updateVIBOffset(a,b){var c=vibStepOffsets[vibDepth[a]<<7|b];vibOffset[a]!==c&&(vibOffset[a]=c,updateFrequency(a))}function updateAMAttenuation(a,b){var c=amStepOffsets[amDepth[a]<<7|b];amAtt[a]!==c&&(amAtt[a]=c,updateDynamicLevel(a))}function clockEnvelope(a){if(clock===envStepLevelChangeClock[a]){var b=envStepLevelPattCounter[a]=envStepLevelPattCounter[a]+1&7;if(envStep[a]===ATTACK){var c=rateAttackPatterns[envStepRate[a]<<3|b];if(c>=0){if(envAtt[a]-=1+(envAtt[a]>>c),envAtt[a]<=0)return setEnvStep(a,DECAY1);updateDynamicLevel(a)}}else if((c=rateDecayPatterns[envStepRate[a]<<3|b])>=0){if(envAtt[a]+=c,envAtt[a]>=envStepNextAtLevel[a])return setEnvStep(a,envStepNext[a]);updateDynamicLevel(a)}envStepLevelChangeClock[a]+=envStepLevelDur[a]}}function setKeyOnAndDamp(a,b,c){c?envStep[a]!==IDLE&&envStep[a]!==DAMP&&setEnvStep(a,DAMP):b?(startSample(a),setEnvStep(a,ATTACK)):envStep[a]!==IDLE&&envStep[a]!==REVERB&&envStep[a]!==DAMP&&setEnvStep(a,RELEASE)}function setLFOReset(a,b){b?(lfoStep[a]=0,lfoStepChangeClock[a]=0,0!==vibOffset[a]&&(vibOffset[a]=0,updateFrequency(a)),0!==amAtt[a]&&(amAtt[a]=0,updateDynamicLevel(a))):lfoStepChangeClock[a]=clock+lfoStepDur[a]}function startSample(a){samplePos[a]=0,phaseCounter[a]=0,sampleValue[a]=readSample(a,0),sampleValue2[a]=readSample(a,advancedSamplePos(a,0,1))}function advanceSample(a,b){var c=advancedSamplePos(a,samplePos[a],b);samplePos[a]=c,sampleValue[a]=readSample(a,c),sampleValue2[a]=readSample(a,advancedSamplePos(a,c,1))}function advancedSamplePos(a,b,c){var d=b+c;return d>endPosition[a]?loopPosition[a]+(d-endPosition[a])-1:d}function readSample(a,b){var c,d,e=startAddress[a],f=dataBits[a];return 1===f?(c=e+3*(b>>1),d=1&b?opl4.memoryRead(c+2)<<4|15&opl4.memoryRead(c+1):opl4.memoryRead(c)<<4|opl4.memoryRead(c+1)>>4,d=d<<4|(2047&d)>>7):2===f?(c=e+(b<<1),d=opl4.memoryRead(c)<<8|opl4.memoryRead(c+1)):0===f?(c=e+b,d=opl4.memoryRead(c),d=d<<8|(127&d)<<1):d=0,32768&d?d-65536:d}function setEnvStep(a,b){var c,d;switch(b){case ATTACK:d=0===ar[a]?0:ar[a]+rcOffset[a];break;case DECAY1:if(envAtt[a]=0,0===(c=dl[a]))return setEnvStep(a,DECAY2);d=0===d1r[a]?0:d1r[a]+rcOffset[a],reverb[a]&&c>=REVERB_ENV_LEVEL?(envStepNextAtLevel[a]=REVERB_ENV_LEVEL,envStepNext[a]=REVERB):(envStepNextAtLevel[a]=c,envStepNext[a]=DECAY2);break;case DECAY2:d=0===d2r[a]?0:d2r[a]+rcOffset[a],reverb[a]&&envAtt[a]<REVERB_ENV_LEVEL?(envStepNextAtLevel[a]=REVERB_ENV_LEVEL,envStepNext[a]=REVERB):(envStepNextAtLevel[a]=512,envStepNext[a]=IDLE);break;case RELEASE:if(d=0===rr[a]?0:rr[a]+rcOffset[a],reverb[a]){if(!(envAtt[a]<REVERB_ENV_LEVEL))return setEnvStep(a,REVERB);envStepNextAtLevel[a]=REVERB_ENV_LEVEL,envStepNext[a]=REVERB}else envStepNextAtLevel[a]=512,envStepNext[a]=IDLE;break;case REVERB:d=REVERB_RATE,envStepNextAtLevel[a]=512,envStepNext[a]=IDLE;break;case DAMP:d=DAMP_RATE,envStepNextAtLevel[a]=512,envStepNext[a]=IDLE;break;case IDLE:default:d=0,envAtt[a]=512,envStepNextAtLevel[a]=1024,envStepNext[a]=IDLE}envStep[a]=b,envStepRate[a]=d,envStepLevelDur[a]=d<4?0:d>=52?1:1<<13-(d>>2),envStepLevelChangeClock[a]=clock+envStepLevelDur[a],envStepLevelPattCounter[a]=0,updateDynamicLevel(a)}function updateFrequency(a){phaseInc[a]=(1024+fNum[a]<<8)+256*vibOffset[a]>>8-octave[a]+1,updateRateCorrOffset(a)}function updateRateCorrOffset(a){if(15===rc[a])return rcOffset[a]=0;var b=(rc[a]+octave[a]<<1)+(fNum[a]>>9);rcOffset[a]=b>=0?b:0}function updateSettingsAttenuation(a){settingsAttL[a]=volumeAtt[a]+panpotAttL[a]+mixerAttL,settingsAttR[a]=volumeAtt[a]+panpotAttR[a]+mixerAttR,updateDynamicLevel(a)}function updateDynamicLevel(a){var b=amAtt[a]+envAtt[a];dynamicLevelL[a]=volumeTable[b+settingsAttL[a]],dynamicLevelR[a]=volumeTable[b+settingsAttR[a]]}var self=this;this.connect=function(a){a.bus.connectOutputDevice(126,this.output7E),a.bus.connectInputDevice(127,this.input7F),a.bus.connectOutputDevice(127,this.output7F)},this.disconnect=function(a){a.bus.disconnectOutputDevice(126,this.output7E),a.bus.disconnectInputDevice(127,this.input7F),a.bus.disconnectOutputDevice(127,this.output7F)},this.reset=function(){clock=0,memoryAddress=0,registerAddress=0,wmsx.Util.arrayFill(register,0),register[2]=34,register[248]=27,register[0]=register[1]=register[7]=register[250]=register[251]=register[252]=register[253]=register[254]=register[255]=255,wmsx.Util.arrayFill(dataBits,0),wmsx.Util.arrayFill(startAddress,0),wmsx.Util.arrayFill(loopPosition,0),wmsx.Util.arrayFill(endPosition,0),wmsx.Util.arrayFill(phaseInc,512),wmsx.Util.arrayFill(fNum,0),wmsx.Util.arrayFill(octave,0),
wmsx.Util.arrayFill(reverb,0),wmsx.Util.arrayFill(ar,0),wmsx.Util.arrayFill(d1r,0),wmsx.Util.arrayFill(dl,0),wmsx.Util.arrayFill(d2r,0),wmsx.Util.arrayFill(rr,0),wmsx.Util.arrayFill(rc,0),wmsx.Util.arrayFill(rcOffset,0),wmsx.Util.arrayFill(lfoStepDur,0),wmsx.Util.arrayFill(vibDepth,0),wmsx.Util.arrayFill(amDepth,0),wmsx.Util.arrayFill(volumeAtt,0),wmsx.Util.arrayFill(panpotAttL,0),wmsx.Util.arrayFill(panpotAttR,0),mixerAttL=0,mixerAttR=0,wmsx.Util.arrayFill(samplePos,0),wmsx.Util.arrayFill(sampleValue,0),wmsx.Util.arrayFill(sampleValue2,0),wmsx.Util.arrayFill(phaseCounter,0),wmsx.Util.arrayFill(envStep,IDLE),wmsx.Util.arrayFill(envStepNext,IDLE),wmsx.Util.arrayFill(envStepNextAtLevel,0),wmsx.Util.arrayFill(envStepRate,0),wmsx.Util.arrayFill(envStepLevelDur,0),wmsx.Util.arrayFill(envStepLevelChangeClock,0),wmsx.Util.arrayFill(envStepLevelPattCounter,0),wmsx.Util.arrayFill(envAtt,512),wmsx.Util.arrayFill(lfoStep,0),wmsx.Util.arrayFill(lfoStepChangeClock,0),wmsx.Util.arrayFill(vibOffset,0),wmsx.Util.arrayFill(amAtt,0),wmsx.Util.arrayFill(settingsAttL,0),wmsx.Util.arrayFill(settingsAttR,0),wmsx.Util.arrayFill(dynamicLevelL,0),wmsx.Util.arrayFill(dynamicLevelR,0)},this.output7E=function(a){registerAddress=a},this.input7F=function(){return registerRead(registerAddress)},this.output7F=function(a){registerWrite(registerAddress,a)},this.nextSample=function(){var a,b,c,d,e,f=0,g=0,h=0;for(++clock,e=23;e>=0;--e)a=clockLFO(e),a>=0&&(vibDepth[e]&&updateVIBOffset(e,a),amDepth[e]&&updateAMAttenuation(e,a)),envStep[e]!==IDLE&&(clockEnvelope(e),b=phaseCounter[e],c=phaseCounter[e]=b+phaseInc[e]&2147483647,d=(c>>10)-(b>>10),d>0&&advanceSample(e,d),f=sampleValue[e]*(1024-(1023&c))+sampleValue2[e]*(1023&c)>>10,g+=f*dynamicLevelL[e],h+=f*dynamicLevelR[e]);return sampleResult[0]=g,sampleResult[1]=h,sampleResult};var memoryAddress,registerAddress,register=new Array(255),clock,dataBits=new Array(24),startAddress=new Array(24),loopPosition=new Array(24),endPosition=new Array(24),samplePos=new Array(24),sampleValue=new Array(24),sampleValue2=new Array(24),phaseInc=new Array(24),phaseCounter=new Array(24),fNum=new Array(24),octave=new Array(24),reverb=new Array(24),ar=new Array(24),d1r=new Array(24),dl=new Array(24),d2r=new Array(24),rc=new Array(24),rr=new Array(24),rcOffset=new Array(24),lfoStepDur=new Array(24),vibDepth=new Array(24),amDepth=new Array(24),volumeAtt=new Array(24),panpotAttL=new Array(24),panpotAttR=new Array(24),mixerAttL=0,mixerAttR=0,settingsAttL=new Array(24),settingsAttR=new Array(24),envStep=new Array(24),envStepNext=new Array(24),envStepNextAtLevel=new Array(24),envStepRate=new Array(24),envStepLevelDur=new Array(24),envStepLevelChangeClock=new Array(24),envStepLevelPattCounter=new Array(24),envAtt=new Array(24),lfoStep=new Array(24),lfoStepChangeClock=new Array(24),vibOffset=new Array(24),amAtt=new Array(24),dynamicLevelL=new Array(24),dynamicLevelR=new Array(24),IDLE=255,ATTACK=1,DECAY1=2,DECAY2=3,RELEASE=4,REVERB=5,DAMP=6,REVERB_ENV_LEVEL=96,REVERB_RATE=20,DAMP_RATE=60,regWriteMasks,rateAttackPatterns,rateDecayPatterns,lfoStepClocks,vibStepOffsets,amStepOffsets,panpotValues,volumeTable,sampleResult=[0,0];this.saveState=function(){return{c:clock,ra:registerAddress,ma:memoryAddress,r:wmsx.Util.storeInt8BitArrayToStringBase64(register),db:wmsx.Util.storeInt8BitArrayToStringBase64(dataBits),sa:wmsx.Util.storeInt32BitArrayToStringBase64(startAddress),lp:wmsx.Util.storeInt16BitArrayToStringBase64(loopPosition),ep:wmsx.Util.storeInt16BitArrayToStringBase64(endPosition),sp:wmsx.Util.storeInt16BitArrayToStringBase64(samplePos),sv:wmsx.Util.storeInt16BitArrayToStringBase64(sampleValue),pc:wmsx.Util.storeInt32BitArrayToStringBase64(phaseCounter),evs:wmsx.Util.storeInt8BitArrayToStringBase64(envStep),evr:wmsx.Util.storeInt8BitArrayToStringBase64(envStepRate),evd:wmsx.Util.storeInt32BitArrayToStringBase64(envStepLevelDur),evc:envStepLevelChangeClock,evn:wmsx.Util.storeInt8BitArrayToStringBase64(envStepNext),evl:wmsx.Util.storeInt16BitArrayToStringBase64(envStepNextAtLevel),epc:wmsx.Util.storeInt8BitArrayToStringBase64(envStepLevelPattCounter),eva:wmsx.Util.storeInt16BitArrayToStringBase64(envAtt),lfs:wmsx.Util.storeInt8BitArrayToStringBase64(lfoStep),lfc:lfoStepChangeClock,vio:wmsx.Util.storeInt8BitArrayToStringBase64(vibOffset),ama:wmsx.Util.storeInt8BitArrayToStringBase64(amAtt),saL:wmsx.Util.storeInt16BitArrayToStringBase64(settingsAttL),saR:wmsx.Util.storeInt16BitArrayToStringBase64(settingsAttR),dlvL:dynamicLevelL,dlvR:dynamicLevelR}},this.loadState=function(a){this.reset(),registerAddress=a.ra;for(var b=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r),c=2;c<6;c++)registerWrite(c,b[c]);for(c=8;c<32;c++)register[c]=b[c];for(c=32;c<250;c++)registerWrite(c,b[c]);memoryAddress=a.ma,clock=a.c,dataBits=wmsx.Util.restoreStringBase64ToInt8BitArray(a.db,dataBits),startAddress=wmsx.Util.restoreStringBase64ToInt32BitArray(a.sa,startAddress),loopPosition=wmsx.Util.restoreStringBase64ToInt16BitArray(a.lp,loopPosition),endPosition=wmsx.Util.restoreStringBase64ToInt16BitArray(a.ep,endPosition),phaseCounter=wmsx.Util.restoreStringBase64ToInt32BitArray(a.pc,phaseCounter),samplePos=wmsx.Util.restoreStringBase64ToInt16BitArray(a.sp,samplePos),sampleValue=wmsx.Util.restoreStringBase64ToSignedInt16BitArray(a.sv,sampleValue),envStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evs,envStep),envStepRate=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evr,envStepRate),envStepLevelDur=wmsx.Util.restoreStringBase64ToInt32BitArray(a.evd,envStepLevelDur),envStepLevelChangeClock=a.evc,envStepNext=wmsx.Util.restoreStringBase64ToInt8BitArray(a.evn,envStepNext),envStepNextAtLevel=wmsx.Util.restoreStringBase64ToInt16BitArray(a.evl,envStepNextAtLevel),envStepLevelPattCounter=wmsx.Util.restoreStringBase64ToInt16BitArray(a.epc,envStepLevelPattCounter),envAtt=wmsx.Util.restoreStringBase64ToInt16BitArray(a.eva,envAtt),lfoStep=wmsx.Util.restoreStringBase64ToInt8BitArray(a.lfs,lfoStep),lfoStepChangeClock=a.lfc,vibOffset=wmsx.Util.restoreStringBase64ToSignedInt8BitArray(a.vio,vibOffset),amAtt=wmsx.Util.restoreStringBase64ToInt8BitArray(a.ama,amAtt),settingsAttL=wmsx.Util.restoreStringBase64ToInt16BitArray(a.saL,settingsAttL),settingsAttR=wmsx.Util.restoreStringBase64ToInt16BitArray(a.saR,settingsAttR),dynamicLevelL=a.dlvL,dynamicLevelR=a.dlvR},init(),this.eval=function(str){return eval(str)}},wmsx.RTC=function(a){"use strict";function b(a){j!==a&&(a?(d(),j=!0):(j=!1,c()))}function c(){i||(i=new Date(Math.floor(h))),l[0]=i.getUTCSeconds()%10,l[1]=i.getUTCSeconds()/10|0,l[2]=i.getUTCMinutes()%10,l[3]=i.getUTCMinutes()/10|0,m[10]?(l[4]=i.getUTCHours()%10,l[5]=i.getUTCHours()/10|0):(l[4]=i.getUTCHours()%12%10,l[5]=i.getUTCHours()%12/10|0,i.getUTCHours()>=12&&(l[5]|=2)),l[6]=i.getUTCDay()+1,l[7]=i.getUTCDate()%10,l[8]=i.getUTCDate()/10|0,l[9]=(i.getUTCMonth()+1)%10,l[10]=(i.getUTCMonth()+1)/10|0,l[11]=(i.getUTCFullYear()-1980)%10,l[12]=(i.getUTCFullYear()-1980)/10|0}function d(){i||(i=new Date),i.setUTCSeconds(l[0]+10*l[1]),i.setUTCMinutes(l[2]+10*l[3]),1&m[10]?i.setUTCHours(l[4]+10*l[5]):i.setUTCHours(l[4]+(2&l[5]?12:0)+(1&l[5]?10:0)),i.setUTCDate(l[7]+10*l[8]),i.setUTCMonth(l[9]+10*l[10]-1),i.setUTCFullYear(l[11]+10*l[12]+1980),h=i.getTime()}function e(a){if(a&=1,(1&m[10])!==a){var b;a?(b=l[4]+(2&l[5]?12:0)+(1&l[5]?10:0),l[5]=b/10|0,l[4]=b%10):(b=l[4]+10*l[5],l[5]=(b>=12?2:0)|(b%12>=10?1:0),l[4]=b%12%10)}}this.setMachineType=function(a){f=WMSX.RTC_ACTIVE>=0?!!WMSX.RTC_ACTIVE:a>=wmsx.Machine.MACHINE_TYPE.MSX2,f&&wmsx.Util.arrayFill(n[0],0),wmsx.Util.arrayFill(n[1],0)},this.connectBus=function(a){a.connectInputDevice(180,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(180,this.outputB4),a.connectInputDevice(181,this.inputB5),a.connectOutputDevice(181,this.outputB5)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.reset=function(){g=0,b(!0)},this.videoClockPulse=function(){
h+=k,i&&(i=void 0)},this.setFps=function(a){k=1e3/a},this.syncTimeWithSource=function(){var b=a.getRealTime();b<=h||(h=b,j||c())},this.outputB4=function(a){f&&(o=15&a)},this.outputB5=function(a){if(f)if(a&=15,o<13)switch(g){case 0:l[o]=a&p[o];break;case 1:10===o&&e(a),m[o]=a&q[o];break;case 2:case 3:n[1&g][o]=a}else switch(o){case 13:g=3&a,b(0!=(8&a))}},this.inputB5=function(){if(!f)return 255;var a;if(o<13)switch(g){case 0:j&&c(),a=l[o];break;case 1:a=m[o];break;case 2:case 3:a=n[1&g][o]}else switch(o){case 13:a=(j?8:0)|g;break;case 14:case 15:a=15}return a};var f,g=0,h=0,i=void 0,j=!0,k=1e3/60,l=wmsx.Util.arrayFill(new Array(13),0),m=wmsx.Util.arrayFill(new Array(13),0),n=[new Array(13),new Array(13)],o=0,p=[15,7,15,7,15,3,7,15,3,15,1,15,15],q=[0,0,15,7,15,3,7,15,3,0,1,3,0];this.saveState=function(){return{a:f,m:g,i:h,c:j,rc:wmsx.Util.storeInt8BitArrayToStringBase64(l),rm:wmsx.Util.storeInt8BitArrayToStringBase64(m),r0:wmsx.Util.storeInt8BitArrayToStringBase64(n[0]),r1:wmsx.Util.storeInt8BitArrayToStringBase64(n[1]),ra:o}},this.loadState=function(a){f=void 0!==a.a?a.a:a.m2,g=a.m,j=a.c,h=a.i?a.i:a.co+a.t,i=void 0,l=wmsx.Util.restoreStringBase64ToInt8BitArray(a.rc,l),m=wmsx.Util.restoreStringBase64ToInt8BitArray(a.rm,m),n[0]=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r0,n[0]),n[1]=wmsx.Util.restoreStringBase64ToInt8BitArray(a.r1,n[1]),o=a.ra}},wmsx.SystemFlags=function(){"use strict";this.setMachineType=function(c){a=c>=wmsx.Machine.MACHINE_TYPE.MSX2P,b=c>=wmsx.Machine.MACHINE_TYPE.MSXTR},this.connectBus=function(a){a.connectInputDevice(243,this.inputF3),a.connectOutputDevice(243,this.outputF3),a.connectInputDevice(244,this.inputF4),a.connectOutputDevice(244,this.outputF4),a.connectInputDevice(245,wmsx.DeviceMissing.outputPortIgnored),a.connectOutputDevice(245,wmsx.DeviceMissing.outputPortIgnored),a.connectInputDevice(246,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(246,wmsx.DeviceMissing.outputPortIgnored),a.connectInputDevice(247,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(247,wmsx.DeviceMissing.outputPortIgnored),a.connectInputDevice(248,wmsx.DeviceMissing.inputPortIgnored),a.connectOutputDevice(248,wmsx.DeviceMissing.outputPortIgnored)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.reset=function(){c=b?0:255,d=0},this.inputF3=function(){return a?d:255},this.outputF3=function(b){a&&(d=b)},this.inputF4=function(){return a?c:255},this.outputF4=function(b){a&&(c=b)};var a=!1,b=!1,c=0,d=0;this.saveState=function(){return{a:a,tr:b,bf:c,vf:d}},this.loadState=function(e){a=void 0!==e.a?e.a:e.m2p,b=void 0!==e.tr&&e.tr,c=e.bf,d=e.vf}},wmsx.TurboRDevices=function(a,b){"use strict";function c(){a.setZ80BUSRQ(o)}function d(a){i.setDRAMMode(l&&a),j.setDRAMMode(l&&a),k.setDRAMMode(l&&a),l&&l.setDRAMMode(a)}function e(){return(a.getBUSCycles()-u)/14&65535}function f(){b.ledStateChanged(2,1&p||o&&32&t?1:0),b.ledStateChanged(4,128&p?2+q:64&t?0:1)}function g(a){return{F:a|=1}}function h(a){return{F:a|=1}}this.setMachineType=function(a){m=a>=wmsx.Machine.MACHINE_TYPE.MSXTR},this.connectBus=function(a){i=a,i.connectInputDevice(167,this.inputA7),i.connectOutputDevice(167,this.outputA7),i.connectInputDevice(228,this.inputE4),i.connectOutputDevice(228,this.outputE4),i.connectInputDevice(229,this.inputE5),i.connectOutputDevice(229,this.outputE5),i.connectInputDevice(230,this.inputE6),i.connectInputDevice(231,this.inputE7),i.connectOutputDevice(230,this.outputE6),i.connectOutputDevice(231,wmsx.DeviceMissing.outputPortIgnored())},this.connectBIOS=function(a){j=a,this.patchPCMBIOS(j.bytes),l&&j.connectRAM(l,65536)},this.disconnectBIOS=function(a){j===a&&(j=void 0)},this.connectBIOSExt=function(a){k=a,l&&k.connectRAM(l,32768)},this.disconnectBIOSExt=function(a){k===a&&(k=void 0)},this.connectRAM=function(a){a.format===wmsx.SlotFormats.RAMMapper&&(l=a,j&&j.connectRAM(l,65536),k&&k.connectRAM(l,32768))},this.disconnectRAM=function(a){l===a&&(j&&j.disconnectRAM(l),k&&k.disconnectRAM(l),l=void 0)},this.powerOn=function(){this.reset()},this.powerOff=function(){this.reset()},this.reset=function(){p=0,q=0,r=0,t=96,this.outputE6(0),f()},this.outputA7=function(a){a&=129,m&&p!==a&&(p=a,f())},this.inputA7=function(){return m?n&&0==(32&t)?1:0:255},this.outputE4=function(a){m&&(r=a)},this.inputE4=function(){return m?r:255},this.outputE5=function(b){if(6===r){var c=96&b,e=b^t;if(!e)return;t=c,a.setR800Mode(0==(32&t)),d(0==(64&t)),32&t&&128&p||(q=64&t?0:1),(128&p||64&e)&&f()}},this.inputE5=function(){return 5===r?s:6===r?t:255},this.outputE6=function(b){u=a.getBUSCycles()},this.inputE6=function(){return m?255&e():255},this.inputE7=function(){return m?e()>>8:255},this.isR800LedOn=function(){return 0!=(128&p)},this.isCPUPaused=function(){return n},this.setCPUPause=function(a,b){n=a,b&&this.vSyncPulse()},this.vSyncPulse=function(){n!==o&&(o=n,c(),f())},this.patchPCMBIOS=function(a){m&&(a[390]=237,a[391]=236,a[392]=201,a[393]=237,a[394]=237,a[395]=201)},this.cpuExtensionBegin=function(a){switch(a.extNum){case 236:return g(a.F);case 237:return h(a.F)}},this.cpuExtensionFinish=function(a){};var i,j,k,l,m=!1,n=!1,o=!1,p=0,q=0,r=0,s=0,t=96,u=0;this.saveState=function(){return{a:m,cp:n,zp:o,ld:p,rl:q,rs:r,r5:s,r6:t,cb:u}},this.loadState=function(a){a?(m=a.a,n=a.cp,o=a.zp,p=a.ld,q=a.rl||0,r=a.rs,s=a.r5,t=a.r6,u=a.cb):(m=!1,this.reset(),n=!1,o=!1),c(),f()}},wmsx.ImageCassetteDriver=function(){"use strict";function a(a){return l.motor(!0),l.readHeader()?h(a,o):i(a)}function b(a){var b=l.readByte();if(null===b)return i(a);var c=h(a,p);return c.A=b,c}function c(){l.motor(!1)}function d(a,b){return l.motor(!0),l.writeHeader(a)?h(b,a?m:n):i(b)}function e(a,b){return l.writeByte(a)?h(b,p):i(b)}function f(){l.finishWriting(),l.motor(!1)}function g(a){l.motor(255===a?null:a>0)}function h(a,b){return{F:254&a,extraIterations:b}}function i(a){return{F:a|=1}}var j=this;this.connect=function(a,b){this.patchTapeBIOS(a.bytes,b),b.getCassetteSocket().connectDriver(this),l=b.getCassetteSocket().getDeck(),k=a.getKeyboardExtension()},this.disconnect=function(a,b){b.getCassetteSocket().connectDriver(null)},this.powerOff=function(){l&&l.motor(!1)},this.typeCurrentAutoRunCommand=function(){var a=j.currentAutoRunCommand();a&&k.typeString(a)},this.currentAutoRunCommand=function(){var a=l.peekFileInfoAtCurrentPosition();if(!a)return null;switch(a.type){case"Binary":return'\r\r\rbload "cas:'+a.name+'", r\r';case"Basic":return'\r\r\rcload "'+a.name+'"\rrun\r';case"ASCII":return'\r\r\rrun "cas:'+a.name+'"\r'}return null},this.cpuExtensionBegin=function(h){switch(h.extNum){case 224:return a(h.F);case 226:return b(h.F);case 228:return c();case 229:return d(h.A,h.F);case 230:return e(h.A,h.F);case 231:return f();case 232:return g(h.A)}},this.cpuExtensionFinish=function(a){},this.patchTapeBIOS=function(a,b){b.getMachineTypeSocket().getMachineType()>=wmsx.Machine.MACHINE_TYPE.MSXTR||(a[225]=237,a[226]=224,a[227]=201,a[228]=237,a[229]=226,a[230]=201,a[231]=237,a[232]=228,a[233]=201,a[234]=237,a[235]=229,a[236]=201,a[237]=237,a[238]=230,a[239]=201,a[240]=237,a[241]=231,a[242]=201,a[243]=237,a[244]=232,a[245]=201)};var k,l,m=3e5,n=m/3,o=.4*n,p=10},wmsx.TurboDriver=function(a){"use strict";function b(){if(h){var b=a.bytes;b[384]=195,b[385]=141,b[386]=1,b[387]=195,b[388]=144,b[389]=1,b[397]=237,b[398]=238,b[399]=201,b[400]=237,b[401]=239,b[402]=201}i?g.bus.connectSwitchedDevice(8,e):g.bus.disconnectSwitchedDevice(8,e)}function c(a){j=131&a;var b=(3&j)>0;k!==b&&(k=b,0===g.getZ80ClockMode()?(e.turboModesUpdate(),g.showZ80ClockModeMessage()):g.showOSD("Could not set Z80 Turbo by software: mode is FORCED "+g.getZ80ClockModeDesc(),!0,!0))}function d(){return{A:3&j}}var e=this;this.connect=function(a){g=a,f=g.getLedsSocket();var c=g.getMachineTypeSocket().getMachineType();h=c<l.MSXTR&&(1===WMSX.CPU_FAKE_TR_TURBO||-1===WMSX.CPU_FAKE_TR_TURBO&&c===l.MSX2P),
i=c<l.MSXTR&&(1===WMSX.CPU_PANA_TURBO||-1===WMSX.CPU_PANA_TURBO&&c===l.MSX2P),b(),this.turboModesUpdate()},this.disconnect=function(a,b){b.bus.disconnectSwitchedDevice(8,this)},this.powerOff=function(){j=0,k=!1,this.turboModesUpdate()},this.reset=function(){(h||i)&&WMSX.CPU_SOFT_TURBO_AUTO_ON?(j=130,k=!0):(j=0,k=!1),this.turboModesUpdate()},this.turboModesUpdate=function(){var a=h||i,b=g.getZ80ClockMode(),c=g.getR800ClockMode(),d=g.getVDPClockMode(),e=0===b&&a&&k?WMSX.Z80_SOFT_TURBO_MULTI:b>0?b:1;g.cpu.setZ80ClockMulti(e),g.cpu.setR800ClockMulti(c),g.vdp.setVDPTurboMulti(0===d&&a&&k?WMSX.VDP_SOFT_TURBO_MULTI:d>0?d:1);var j=g.cpu.getR800ClockMulti();f.ledStateChanged(3,1!==e?1:0),f.ledInfoChanged(3,1!==e?e+"x":""),f.ledInfoChanged(4,1!==j?j+"x":"")},this.cpuExtensionBegin=function(a){if(!(g.machineType<=1))switch(a.extNum){case 238:return c(a.A);case 239:return d()}},this.cpuExtensionFinish=function(a){},this.switchedPortInput=function(a){return 65!==a?255:k?0:1},this.switchedPortOutput=function(a,b){65===b&&c(0==(1&a)?129:0)},this.saveState=function(){return{tt:h,pt:i,st:k,cv:j}},this.loadState=function(a){k=!(!a||!a.st)&&a.st,j=a&&a.cv?a.cv:0;var c=g&&g.getMachineTypeSocket().getMachineType(),d=c===l.MSX2P;h=a&&void 0!==a.tt?a.tt:d,i=a&&void 0!==a.pt?a.pt:d,g&&b()};var f,g,h=!1,i=!1,j=0,k=!1,l=wmsx.Machine.MACHINE_TYPE},wmsx.BIOSKeyboardExtension=function(){"use strict";this.connect=function(b){a=b.bus},this.typeString=function(a){if(void 0!==a&&null!==a){var c=a.toString();c&&(c=c.replace(/\r\n/g,"\r").replace(/\n/g,"\r"),b=(b||"")+c)}},this.cancelTypeString=function(){b=null,c=0},this.keyboardExtensionClockPulse=function(){if(b){var h=a.read(e)|a.read(e+1)<<8;if(!(h<f||h>g)){var i=a.read(d)|a.read(d+1)<<8;if(!(i<f||i>g)){var j=h-i-1;if(j<0&&(j+=40),!(j<=0)){for(var k=b.substr(c,j),l=0;l<k.length;l++)a.write(i,255&k.charCodeAt(l)),++i>g&&(i=f);a.write(d,255&i),a.write(d+1,i>>8),c+=k.length,c>=b.length&&this.cancelTypeString()}}}}},this.saveState=function(){return{s:b&&btoa(b),p:c}},this.loadState=function(a){b=a.s&&atob(a.s),c=a.p};var a,b,c=0,d=62456,e=62458,f=64496,g=64535},wmsx.ImageDiskDriver=function(a){"use strict";function b(a,b){return{HL:65280&b|(64&a?1:2)}}function c(a,b,c,f,g,h){return 1&a?e(a,b,c,f,g,h):d(a,b,c,f,g,h)}function d(a,b,c,d,e,f){var g=p.motorOn(b);return p.readSectorsToSlot(b,e,c,l(f),f)?{F:-2&a,B:0,extraIterations:g+c*v}:{F:1|a,A:2,B:c,extraIterations:g}}function e(a,b,c,d,e,f){var g=p.motorOn(b);return p.isDiskInserted(b)&&p.writeSectorsFromSlot(b,e,c,l(f),f)?{F:-2&a,B:0,extraIterations:g+c*v}:{F:1|a,A:2,B:c,extraIterations:g}}function f(b,c,d,e,f){var h=p.diskHasChanged(c);if(!1===h)return{F:-2&b,B:1};var i=p.motorOn(c),j=p.readByte(c,t);return null===j?{F:1|b,A:2,B:0,extraIterations:i}:(a||g(b,c,j,e,f,!0),{F:-2&b,B:!0===h?255:0,extraIterations:i})}function g(a,b,c,d,e,f){var g=c<248?d:c;return g<248?{F:1|a}:(k(p.MEDIA_TYPE_DPB[g],e+1),{F:-2&a})}function h(a){return{HL:s[a]||0}}function i(a,b,c){var d=c>>>8,e=b>=1&&b<=2?b-1:0;if(e<0||e>1||d<0||d>1)return{F:1|a,A:12};var f=p.FORMAT_OPTIONS_MEDIA_TYPES[e];return p.insertNewDisk(d,f,!1,!0),p.motorOn(d),p.formatCurrentDisk(d,f),{F:-2&a,extraIterations:w}}function j(){p.allMotorsOffNow()}function k(a,b){for(var c=l(b),d=0;d<a.length;d++)c.write(b+d,a[d])}function l(a){var b;if(a>=16384&&a<=32767){var c=q.read(62274);b=q.getSlot(3&c),0!=(128&c)&&b.isExpanded()&&(b=b.getSubSlot(c>>2&3))}else b=q.getSlotForAddress(a),b.isExpanded()&&(b=b.getSubSlotForAddress(a));return b}function m(a,b,c){delete r[b];var d=q.read(c+26),e=3&d,f=e<=1;return f&&(p.motorFlash(e),!p.isDiskInserted(e))?{F:1|a,A:26}:(q.write(c+0,f?1:0),q.write(c+1,130),q.write(c+12+0,0),q.write(c+12+1,0),q.write(c+12+2,0),q.write(c+12+3,0),q.write(c+28,9),q.write(c+29,0),q.write(c+30,2),r[b]=e,{F:-2&a})}function n(a,b,c,d,e,f){var g=r[b];return g>=0&&p.motorFlash(g),void 0!==g&&p.isDiskInserted(g)?p.readSectorsToSlot(g,(f<<16)+e,c,q,d)?{F:-2&a}:{F:1|a,A:6}:{F:1|a,A:26}}function o(a,b,c,d,e,f){var g=r[b];return g>=0&&p.motorFlash(g),void 0!==g&&p.isDiskInserted(g)?p.writeSectorsFromSlot(g,(f<<16)+e,c,q,d)?{F:-2&a}:{F:1|a,A:6}:{F:1|a,A:26}}this.connect=function(a,b){p=b.getDiskDriveSocket().getDrive(),q=b.bus,q.setCpuExtensionHandler(244,this),q.setCpuExtensionHandler(245,this),q.setCpuExtensionHandler(246,this)},this.disconnect=function(a,b){p.allMotorsOff(),q.setCpuExtensionHandler(244,void 0),q.setCpuExtensionHandler(245,void 0),q.setCpuExtensionHandler(246,void 0)},this.powerOff=function(){p.allMotorsOff()},this.cpuExtensionBegin=function(a){switch(a.extNum){case 224:return;case 226:return b(a.F,a.HL);case 228:return c(a.F,a.A,a.B,a.C,a.DE,a.HL);case 229:return f(a.F,a.A,a.B,a.C,a.HL);case 230:return g(a.F,a.A,a.B,a.C,a.HL);case 231:return h(a.extPC);case 232:return i(a.F,a.A,a.DE);case 234:return j();case 244:return n(a.F,a.C,a.B,a.HL,a.IX,a.IY);case 245:return o(a.F,a.C,a.B,a.HL,a.IX,a.IY);case 246:return m(a.F,a.C,a.HL)}},this.cpuExtensionFinish=function(a){p.allMotorsOff()},this.patchDiskBIOS=function(a,b,c,d,e,f){var g=0,h=0;if(a[b+d+0]=237,a[b+d+1]=224,a[b+d+2]=0,a[b+e+0]=237,a[b+e+1]=226,a[b+e+2]=0,g=b+(a[b+c+16+0+1]|a[b+c+16+0+2]<<8),a[g+0]=237,a[g+1]=228,a[g+2]=201,g=b+(a[b+c+16+3+1]|a[b+c+16+3+2]<<8),a[g+0]=237,a[g+1]=229,a[g+2]=201,g=b+(a[b+c+16+6+1]|a[b+c+16+6+2]<<8),a[g+0]=237,a[g+1]=230,a[g+2]=201,g=b+(a[b+c+16+9+1]|a[b+c+16+9+2]<<8),h=g-b,a[g+0]=237,a[g+1]=231,a[g+2]=201,g=b+(a[b+c+16+12+1]|a[b+c+16+12+2]<<8),a[g+0]=237,a[g+1]=232,a[g+2]=201,g=b+(a[b+c+16+15+1]|a[b+c+16+15+2]<<8),a[g+0]=237,a[g+1]=234,a[g+2]=201,f>=0){s[h]=f;for(var i=0;i<u.length;i++)a[b+f+i]=u.charCodeAt(i)}},this.rePatchDiskBIOSOldStateForExtensions=function(a,b,c,d,e){228!==a[b+c+16+0+1]&&(a[b+d+1]=224,a[b+e+1]=226,a[b+c+16+0+1]=228,a[b+c+16+3+1]=229,a[b+c+16+6+1]=230,a[b+c+16+9+1]=231,a[b+c+16+12+1]=232,a[b+c+16+15+1]=234)},this.saveState=function(){return{sd:r,csa:s}},this.loadState=function(a){r=a&&void 0!==a.sd?a.sd:{},s=a&&void 0!==a.csa?a.csa:{}};var p,q,r={},s={},t=512,u="Adding a new Disk...\r\n1) 720KB\r\n2) 360KB\r\n\0",v=5e3,w=2e6},wmsx.ImageNextorDeviceDriver=function(){"use strict";function a(){return{A:5,B:0,C:0}}function b(a,b,c){return{F:0,A:0,HL:0}}function c(a,b,c,f,g,h){return 1!==b||1!==f?{A:p,B:0}:(l.motorFlash(2),l.isDiskInserted(2)?1&a?e(a,b,c,f,g,h):d(a,b,c,f,g,h):{A:o,B:0})}function d(a,b,c,d,e,f){var g=m.read(e+0)|m.read(e+1)<<8|m.read(e+2)<<16|m.read(e+3)<<24;return l.readSectorsToSlot(2,g,c,m,f)?{A:0}:{A:o,B:0}}function e(a,b,c,d,e,f){var g=m.read(e)|m.read(e+1)<<8|m.read(e+2)<<16|m.read(e+3)<<24;return l.writeSectorsFromSlot(2,g,c,m,f)?{A:0}:{A:o,B:0}}function f(a,b,c){if(1!==a)return{A:1};if(0===b)return m.write(c,1),m.write(c+1,0),{A:0};if(1===b){for(var d="WebMSX                                                                   ",e=0;e<64;++e)m.write(c+e,d.charCodeAt(e));return{A:0}}if(2===b){for(d="WebMSX Removable Hard Disk                                                   ",e=0;e<64;++e)m.write(c+e,d.charCodeAt(e));return{A:0}}return{A:1}}function g(a,b){if(1!==a||1!==b)return{A:0};var c=l.diskHasChanged(2);return{A:null===c?3:c?2:1}}function h(a,b,c){if(1!==a||1!==b)return{A:1};for(var d=l.getTotalSectorsAvailable(2)||0,e=[0,0,2,255&d,d>>8&255,d>>16&255,d>>24&255,1,0,0,0,0],f=0;f<12;++f)m.write(c+f,e[f]);return{A:0}}function i(a,b,c){delete n[b];var d=m.read(c+26),e=d>>4,f=15&d,g=0===e,h=0;if(g){if(l.motorFlash(2),!l.isDiskInserted(2))return{F:1|a,A:26};var i=l.readByte(2,510)<<8|l.readByte(2,511);if(null===i)return{F:1|a,A:26};var j=21930===i;if(f>0){if(!j)return{F:1|a,A:4};var k=446+16*(f-1),o=l.readByte(2,k+4);if(h=l.readDWord(2,k+8),null===o||null===h)return{F:1|a,A:26};if(!h||!o)return{F:1|a,A:4}}else if(j)return{F:1|a,A:4}}return m.write(c+0,g?1:0),m.write(c+1,145),m.write(c+12+0,255&h),m.write(c+12+1,h>>8&255),m.write(c+12+2,h>>16&255),m.write(c+12+3,h>>24&255),m.write(c+31,0),n[b]=h,{
F:-2&a}}function j(a,b,c,d,e,f){var g=n[b];return g>=0&&l.motorFlash(2),void 0!==g&&l.isDiskInserted(2)?l.readSectorsToSlot(2,g+(f<<16)+e,c,m,d)?{F:-2&a}:{F:1|a,A:9}:{F:1|a,A:26}}function k(a,b,c,d,e,f){var g=n[b];return g>=0&&l.motorFlash(2),void 0!==g&&l.isDiskInserted(2)?l.writeSectorsFromSlot(2,g+(f<<16)+e,c,m,d)?{F:-2&a}:{F:1|a,A:9}:{F:1|a,A:26}}this.connect=function(a,b){l=b.getDiskDriveSocket().getDrive(),m=b.bus,m.setCpuExtensionHandler(240,this),m.setCpuExtensionHandler(241,this),m.setCpuExtensionHandler(242,this)},this.disconnect=function(a,b){b.bus.setCpuExtensionHandler(240,void 0),b.bus.setCpuExtensionHandler(241,void 0),b.bus.setCpuExtensionHandler(242,void 0)},this.powerOff=function(){},this.cpuExtensionBegin=function(d){switch(d.extNum){case 224:return a();case 226:return b(d.A,d.B,d.HL);case 228:return c(d.F,d.A,d.B,d.C,d.DE,d.HL);case 229:return f(d.A,d.B,d.HL);case 230:return g(d.A,d.B);case 231:return h(d.A,d.B,d.HL);case 240:return j(d.F,d.C,d.B,d.HL,d.IX,d.IY);case 241:return k(d.F,d.C,d.B,d.HL,d.IX,d.IY);case 242:return i(d.F,d.C,d.HL)}},this.cpuExtensionFinish=function(a){},this.patchNextorKernel=function(a){a[114958]=1;for(var b="WebMSX Nextor Device Driver     ",c=0;c<32;++c)a[114960+c]=b.charCodeAt(c);for(a[114992]=201,a[114993]=201,a[114994]=201,a[114995]=237,a[114996]=224,a[114997]=201,a[114998]=237,a[114999]=226,a[115e3]=201,a[115001]=55,a[115002]=201,a[115003]=201,a[115004]=55,a[115005]=201,a[115006]=201,a[115007]=201,a[115008]=201,a[115009]=201,c=115010;c<115026;++c)a[c]=201;a[115040]=237,a[115041]=228,a[115042]=201,a[115043]=237,a[115044]=229,a[115045]=201,a[115046]=237,a[115047]=230,a[115048]=201,a[115049]=237,a[115050]=231,a[115051]=201},this.saveState=function(){return{so:n}},this.loadState=function(a){n=void 0!==(a&&a.so)?a.so:{}};var l,m,n={},o=252,p=181},wmsx.ROM=function(a,b,c,d,e){"use strict";this.source=wmsx.Util.leafFilename(a),this.content=b,this.info=c||wmsx.SlotCreator.produceInfo(this,d,e),this.saveState=function(){return{s:this.source,i:this.info}},this.reloadEmbeddedContent=function(){if(!this.content&&wmsx.EmbeddedFiles.isEmbeddedURL(this.source)){this.source=wmsx.Configurator.adaptROMSourceForOldState(this.source);var a=wmsx.EmbeddedFiles.get(this.source);if(!a)throw new Error("Cannot reload embedded content: "+this.source);this.content=a.content}}},wmsx.ROM.loadState=function(a){var b=wmsx.Configurator.adaptROMSourceForOldState(a.s);return new wmsx.ROM(b,null,a.i)},wmsx.ROMDatabase={uncompress:function(){wmsx.ROMDatabase=JSON.parse(wmsx.Util.uncompressStringBase64ToString(this.data))},
data:"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"
},wmsx.SlotCreator=function(){"use strict";function a(a,b){var c,d=[];for(var e in wmsx.SlotFormats)c=wmsx.SlotFormats[e],c.prioritySelected=c.priorityForRom(a,b),c.prioritySelected&&(f(c,a.info),c.prioritySelected>=j||d.push(c));return d.sort(function(a,b){return a.prioritySelected-b.prioritySelected}),d}function b(a){var b={};return a.n&&(b.n=a.n),a.h&&(b.h=a.h),a.f&&(b.f=a.f),a.t&&(b.t=a.t),a.l&&(b.l=a.l),a.e&&(b.e=a.e),b}this.createFromROM=function(a,b){var d=c.getForROM(a);if(d){var e=wmsx.SlotFormats[d];if(e.priorityForRom(a))return wmsx.Util.log("USER Format selected: "+e.desc),e.createFromROM(a)}var f=this.getBestFormatOption(a,b);if(f){return wmsx.EmbeddedFiles.isEmbeddedURL(a.source)||wmsx.Util.log("AUTO Format selected: "+f.desc+", priority: "+f.prioritySelected),f.createFromROM(a)}},this.recreateFromSaveState=function(a,b){var c=wmsx.SlotFormats[a.f];if(!c)throw new Error("Unsupported ROM Format in Savestate: "+a.f);return b&&b.format!==c&&b.formatBack!==c&&(b=null),c.recreateFromSaveState(a,b)},this.changeCartridgeFormat=function(a,b){return b.createFromROM(a.rom)},this.getBestFormatOption=function(b,c){var d=a(b,c);return 0===d.length?void 0:d[0]},this.getUserFormatOptionNames=function(a){for(var b=[],c=0,d=wmsx.SlotFormatsUserOptions.length;c<d;++c){var e=wmsx.SlotFormatsUserOptions[c];wmsx.SlotFormats[e].priorityForRom(a)&&b.push(e)}return b},this.produceInfo=function(a,c,f){var g=a.content.length,h=a.content.length>m?void 0:wmsx.Util.sha1Generator.calcSHA1FromByteArray(a.content).toUpperCase();a.content.length>g&&(a.content.length=g);var i=wmsx.ROMDatabase[h],j=wmsx.EmbeddedFiles.isEmbeddedURL(a.source);return i?(i=b(i),j||wmsx.Util.log("ROM: "+i.n+(i.f?", format: "+i.f:"")+" ("+h+")")):(i=d(a.source),j||wmsx.Util.log("ROM: "+(g>0?"Unknown content":"No content")+", "+i.n+(i.f?", format: "+i.f:"")+(h?" ("+h+")":" (no hash computed)"))),e(i,a.source,h,c,f),i},this.setUserROMFormats=function(a){c=a};var c,d=function(a){var b={n:"Unknown"};return a?(b.n=wmsx.Util.leafFilenameNoExtension(a)||"Unknown",b):b},e=function(a,b,c,d,e){if(a.h=c,d){d=d.trim().toUpperCase();for(var f in wmsx.SlotFormats)if(f.toUpperCase()===d){a.f=wmsx.SlotFormats[f].name,a.t=!0;break}}if(!a.t){var h=b.toUpperCase();for(f in wmsx.SlotFormats)if(g(f.toUpperCase(),h)){a.f=wmsx.SlotFormats[f].name,a.t=!0;break}}void 0!==e&&null!==e&&(a.s=0|parseInt(e))},f=function(a,b){b.f&&a.name===b.f&&(a.prioritySelected-=b.t?l:k)},g=function(a,b){return b.match(h+a+i)},h="\\[",i="\\]",j=1e3,k=1e3,l=5e3,m=1024*(WMSX.ROM_MAX_HASH_SIZE_KB||5120);this.FORMAT_PRIORITY_BOOST=k},wmsx.SlotCreator=new wmsx.SlotCreator,wmsx.SlotFormats={Empty:{name:"Empty",desc:"Empty Slot",priority:1001,internal:!0,embeddedURL:"@[Empty].rom",priorityForRom:function(a){return a&&a.content&&0!==a.content.length?null:this.priority},createFromROM:function(a){return wmsx.SlotEmpty.singleton},recreateFromSaveState:function(a,b){return wmsx.SlotEmpty.singleton}},Expanded0:{name:"Expanded0",desc:"Special Expanded Slot 0",priority:1002,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpanded0.recreateFromSaveState(a,b)}},Expanded3:{name:"Expanded3",desc:"Special Expanded Slot 3",priority:1003,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpanded3.recreateFromSaveState(a,b)}},ExpandedS:{name:"ExpandedS",desc:"Simple Expanded Slot",priority:1004,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpanded.recreateFromSaveState(a,b)}},ExpandedM:{name:"ExpandedM",desc:"Special Expanded Slot 4 (Modules: Device-only Slots)",priority:1005,internal:!0,priorityForRom:function(a){return null},createFromROM:null,recreateFromSaveState:function(a,b){return wmsx.SlotExpandedM.recreateFromSaveState(a,b)}},BIOS:{name:"BIOS",desc:"Main BIOS",priority:201,internal:!0,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=49152&&243===a.content[0]&&(195===a.content[1]||24===a.content[1])?this.priority:null},createFromROM:function(a){return new wmsx.SlotBIOS(a)},recreateFromSaveState:function(a,b){return wmsx.SlotBIOS.recreateFromSaveState(a,b)}},MSX2BIOSExt:{name:"MSX2BIOSExt",desc:"MSX2/2+/tR BIOS Extension",priority:202,internal:!0,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=49152&&67===a.content[0]&&68===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.SlotMSX2BIOSExt(a)},recreateFromSaveState:function(a,b){return wmsx.SlotMSX2BIOSExt.recreateFromSaveState(a,b)}},RAMNormal:{name:"RAMNormal",desc:"Normal RAM (unmapped)",priority:1011,internal:!0,embeddedURL:"@[RAMNormal].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.SlotRAMNormal(a)},recreateFromSaveState:function(a,b){return wmsx.SlotRAMNormal.recreateFromSaveState(a,b)}},RAMMapper:{name:"RAMMapper",desc:"Standard RAM Mapper",priority:1012,internal:!0,embeddedURL:"@[RAMMapper].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.SlotRAMMapper(a)},recreateFromSaveState:function(a,b){return wmsx.SlotRAMMapper.recreateFromSaveState(a,b)}},PlainROM:{name:"PlainROM",desc:"Plain ROM",priority:1013,priorityForRom:function(a){return a.content.length>0&&a.content.length<=4194304?this.priority:null},createFromROM:function(a){return new wmsx.SlotPlainROM(a)},recreateFromSaveState:function(a,b){return wmsx.SlotPlainROM.recreateFromSaveState(a,b)}},DiskPatch:{name:"DiskPatch",desc:"Generic Patched Disk BIOS",priority:1301,internal:!0,embeddedURL:"@[DiskPatch].rom",priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=65536?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDiskPatched(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDiskPatched.recreateFromSaveState(a,b)}},Nextor16Patch:{name:"Nextor16Patch",desc:"Nextor ASCII-16 Patched Kernel",priority:1302,internal:!0,embeddedURL:"@[Nextor16Patch].rom",priorityForRom:function(a){return 131072===a.content.length&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeNextorPatched(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeNextorPatched.recreateFromSaveState(a,b)}},SCCExpansion:{name:"SCCExpansion",desc:"Konami SCC Sound Cartridge",priority:1501,internal:!0,embeddedURL:"@[SCCExpansion].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSCCExpansion(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSCCExpansion.recreateFromSaveState(a,b)}},SCCIExpansion:{name:"SCCIExpansion",desc:"Konami SCC+ Sound Mapper Cartridge",priority:1502,internal:!0,embeddedURL:"@[SCCIExpansion].rom",priorityForRom:function(a){return a.content.length<=131072?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSCCIExpansion(a,this,!1)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSCCIExpansion.recreateFromSaveState(a,b)}},MSXMUSIC:{name:"MSXMUSIC",desc:"MSX-MUSIC Sound Extension",priority:1503,internal:!0,embeddedURL:"@[MSXMUSIC].rom",priorityForRom:function(a){return 16384===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMSXMUSIC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMSXMUSIC.recreateFromSaveState(a,b)}},PACExpansion:{name:"PACExpansion",desc:"PAC SRAM Cartridge",priority:1505,internal:!0,embeddedURL:"@[PACExpansion].rom",priorityForRom:function(a,b){
return 0===a.content.length?this.priority:!wmsx.CartridgePAC.isPACFileContentValid(a.content)||b&&b.format!==wmsx.SlotFormats.PACExpansion&&b.format!==wmsx.SlotFormats.FMPAC?null:this.priority-wmsx.SlotCreator.FORMAT_PRIORITY_BOOST},createFromROM:function(a){return new wmsx.CartridgePAC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgePAC.recreateFromSaveState(a,b)}},Kanji1:{name:"Kanji1",desc:"Kanji Font Driver",priority:1506,internal:!0,embeddedURL:"@[Kanji1].rom",priorityForRom:function(a){return 131072===a.content.length||262144===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKanjiFont(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKanjiFont.recreateFromSaveState(a,b)}},OPL4:{name:"OPL4",desc:"OPL4 Sound Cartridge",priority:1507,internal:!0,embeddedURL:"@[OPL4].rom",priorityForRom:function(a){return 2097152===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeOPL4(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeOPL4.recreateFromSaveState(a,b)}},ExtraPSG:{name:"ExtraPSG",desc:"Extra PSG Sound Chip",priority:1508,internal:!0,embeddedURL:"@[ExtraPSG].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeExtraPSG(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeExtraPSG.recreateFromSaveState(a,b)}},MegaRAM:{name:"MegaRAM",desc:"MegaRAM Mapper Cartridge",priority:1509,internal:!0,embeddedURL:"@[MegaRAM].rom",priorityForRom:function(a){return a.content.length<=2097152?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMegaRAM(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMegaRAM.recreateFromSaveState(a,b)}},V9990:{name:"V9990",desc:"V9990 Video Cartridge",priority:1510,internal:!0,embeddedURL:"@[V9990].rom",priorityForRom:function(a){return 0===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeV9990(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeV9990.recreateFromSaveState(a,b)}},Normal:{name:"Normal",desc:"Normal ROM, Mirroring Auto",priority:901,priorityForRom:function(a){return a.content.length>=128&&a.content.length<=16384&&65===a.content[0]&&66===a.content[1]?this.priority:a.content.length<=32768&&(65===a.content[0]&&66===a.content[1]||65===a.content[16384]&&66===a.content[16385])?this.priority:a.content.length>32768&&a.content.length<=65536&&(65===a.content[16384]&&66===a.content[16385]||65===a.content[32768]&&66===a.content[32769])?this.priority:null},createFromROM:function(a){return new wmsx.SlotNormal(a,this)},recreateFromSaveState:function(a,b){return wmsx.SlotNormal.recreateFromSaveState(a,b)}},Mirrored:{name:"Mirrored",desc:"Normal ROM, Mirrored",priority:902,priorityForRom:function(a){return wmsx.SlotFormats.Normal.priorityForRom(a)},createFromROM:function(a){return new wmsx.SlotNormal(a,this)},recreateFromSaveState:function(a,b){return wmsx.SlotNormal.recreateFromSaveState(a,b)}},NotMirrored:{name:"NotMirrored",desc:"Normal ROM, Not Mirrored",priority:903,priorityForRom:function(a){return wmsx.SlotFormats.Normal.priorityForRom(a)},createFromROM:function(a){return new wmsx.SlotNormal(a,this)},recreateFromSaveState:function(a,b){return wmsx.SlotNormal.recreateFromSaveState(a,b)}},ASCII8:{name:"ASCII8",desc:"ASCII 8K Mapper Cartridge",priority:911,priorityForRom:function(a){return a.content.length>=8192&&0==(8191&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8K(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8K.recreateFromSaveState(a,b)}},ASCII16:{name:"ASCII16",desc:"ASCII 16K Mapper Cartridge",priority:912,priorityForRom:function(a){return a.content.length>=16384&&0==(16383&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16K(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16K.recreateFromSaveState(a,b)}},Konami:{name:"Konami",desc:"Konami Mapper Cartridge",priority:913,priorityForRom:function(a){return a.content.length>=8192&&0==(8191&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKonami(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKonami.recreateFromSaveState(a,b)}},KonamiSCC:{name:"KonamiSCC",desc:"KonamiSCC Sound Mapper Cartridge",priority:914,priorityForRom:function(a){return a.content.length>=8192&&0==(8191&a.content.length)&&65===a.content[0]&&66===a.content[1]?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKonamiSCC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKonamiSCC.recreateFromSaveState(a,b)}},KonamiSCCI:{name:"KonamiSCCI",desc:"Konami SCC+ Sound Mapper Cartridge (in SCC-I mode)",priority:1101,priorityForRom:function(a){return a.content.length>0&&a.content.length<=131072?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSCCIExpansion(a,this,!0)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSCCIExpansion.recreateFromSaveState(a,b)}},ASCII8SRAM2:{name:"ASCII8SRAM2",desc:"ASCII 8K SRAM 2K Mapper Cartridge",priority:1102,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},ASCII8SRAM8:{name:"ASCII8SRAM8",desc:"ASCII 8K SRAM 8K Mapper Cartridge",priority:1103,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},KoeiSRAM8:{name:"KoeiSRAM8",desc:"Koei SRAM 8K Mapper Cartridge",priority:1104,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},KoeiSRAM32:{name:"KoeiSRAM32",desc:"Koei SRAM 32K Mapper Cartridge",priority:1105,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},Wizardry:{name:"Wizardry",desc:"Wizardry SRAM Mapper Cartridge",priority:1106,priorityForRom:function(a){return a.content.length>=8192&&a.content.length<=1048576&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII8KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII8KSRAM.recreateFromSaveState(a,b)}},ASCII16SRAM2:{name:"ASCII16SRAM2",desc:"ASCII 16K SRAM 2K Mapper Cartridge",priority:1107,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=2097152&&0==(16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16KSRAM(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16KSRAM.recreateFromSaveState(a,b)}},ASCII16SRAM8:{name:"ASCII16SRAM8",desc:"ASCII 16K SRAM 8K Mapper Cartridge",priority:1108,priorityForRom:function(a){return a.content.length>=16384&&a.content.length<=2097152&&0==(16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16KSRAM(a,this)},recreateFromSaveState:function(a,b){
return wmsx.CartridgeASCII16KSRAM.recreateFromSaveState(a,b)}},KonamiUltimateCollection:{name:"KonamiUltimateCollection",desc:"Konami Ultimate Collection SCC+/PCM Sound Mapper Cartridge",priority:1109,priorityForRom:function(a){return a.content.length<=8388608&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeKonamiUltimateCollection(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeKonamiUltimateCollection.recreateFromSaveState(a,b)}},RType:{name:"RType",desc:"R-Type Mapper Cartridge",priority:1111,priorityForRom:function(a){return 393216===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeRType(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeRType.recreateFromSaveState(a,b)}},CrossBlaim:{name:"CrossBlaim",desc:"CrossBlaim Mapper Cartridge",priority:1112,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeCrossBlaim(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeCrossBlaim.recreateFromSaveState(a,b)}},Manbow2:{name:"Manbow2",desc:"Space Manbow 2 SCC Sound Mapper Cartridge",priority:1113,priorityForRom:function(a){return 524288===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeManbow2(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeManbow2.recreateFromSaveState(a,b)}},Majutsushi:{name:"Majutsushi",desc:"Konami Hai no Majutsushi PCM Mapper Cartridge",priority:1114,priorityForRom:function(a){return a.content.length>0&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeMajutsushi(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeMajutsushi.recreateFromSaveState(a,b)}},Synthesizer:{name:"Synthesizer",desc:"Konami Synthesizer PCM Cartridge",priority:1115,priorityForRom:function(a){return a.content.length>0&&a.content.length<=32768&&0==(8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSynthesizer(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSynthesizer.recreateFromSaveState(a,b)}},GameMaster2:{name:"GameMaster2",desc:"Konami Game Master 2 SRAM Mapper Cartridge",priority:1116,priorityForRom:function(a){return 131072===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeGameMaster2(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeGameMaster2.recreateFromSaveState(a,b)}},HarryFox:{name:"HarryFox",desc:"HarryFox Mapper Cartridge",priority:1117,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeHarryFox(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeHarryFox.recreateFromSaveState(a,b)}},Halnote:{name:"Halnote",desc:"Halnote SRAM Mapper Cartridge",priority:1118,priorityForRom:function(a){return 1048576===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeHalnote(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeHalnote.recreateFromSaveState(a,b)}},AlQuran:{name:"AlQuran",desc:"The Holy Quran Mapper Cartridge (Encoded)",priority:1119,priorityForRom:function(a){return 1048576===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeAlQuran(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeAlQuran.recreateFromSaveState(a,b)}},AlQuranDecoded:{name:"AlQuranDecoded",desc:"The Holy Quran Mapper Cartridge (Decoded)",priority:1120,priorityForRom:function(a){return 1048576===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeAlQuran(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeAlQuran.recreateFromSaveState(a,b)}},SuperSwangi:{name:"SuperSwangi",desc:"Super Swangi Mapper Cartridge",priority:1121,priorityForRom:function(a){return a.content.length>=16384&&0==(16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSuperSwangi(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSuperSwangi.recreateFromSaveState(a,b)}},MSXWrite:{name:"MSXWrite",desc:"MSX Write Mapper Cartridge",priority:1122,priorityForRom:function(a){return 524288===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeASCII16K(a,this)},recreateFromSaveState:function(a,b){return wmsx.CartridgeASCII16K.recreateFromSaveState(a,b)}},Zemina80in1:{name:"Zemina80in1",desc:"Zemina 80 in 1 Mapper Cartridge",priority:1123,priorityForRom:function(a){return 0===(a.content.length>=8192&&8191&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeZemina80(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeZemina80.recreateFromSaveState(a,b)}},Zemina90in1:{name:"Zemina90in1",desc:"Zemina 90 in 1 Mapper Cartridge",priority:1124,priorityForRom:function(a){return 0===(a.content.length>=16384&&16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeZemina90(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeZemina90.recreateFromSaveState(a,b)}},Zemina126in1:{name:"Zemina126in1",desc:"Zemina 126 in 1 Mapper Cartridge",priority:1125,priorityForRom:function(a){return 0===(a.content.length>=16384&&16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeZemina126(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeZemina126.recreateFromSaveState(a,b)}},SuperLodeRunner:{name:"SuperLodeRunner",desc:"Super Lode Runner Mapper Cartridge",priority:1126,priorityForRom:function(a){return 0===(a.content.length>=16384&&16383&a.content.length)?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeSuperLodeRunner(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeSuperLodeRunner.recreateFromSaveState(a,b)}},Dooly:{name:"Dooly",desc:"Agigongnyong Dooly Mapper Cartridge",priority:1127,priorityForRom:function(a){return 32768===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDooly(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDooly.recreateFromSaveState(a,b)}},FMPAC:{name:"FMPAC",desc:"FM-PAC SRAM Sound Mapper Cartridge",priority:1151,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeFMPAC(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeFMPAC.recreateFromSaveState(a,b)}},MSXDOS2:{name:"MSXDOS2",desc:"MSX-DOS 2 Mapper Cartridge",priority:1504,embeddedURL:"@[MSXDOS2]v22.rom",priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDOS2(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDOS2.recreateFromSaveState(a,b)}},DiskPatchDOS2TR:{name:"DiskPatchDOS2TR",desc:"TR MSX-DOS2 + Patched Disk BIOS",priority:1511,priorityForRom:function(a){return 65536===a.content.length?this.priority:null},createFromROM:function(a){return new wmsx.CartridgeDiskPatchedDOS2TR(a)},recreateFromSaveState:function(a,b){return wmsx.CartridgeDiskPatchedDOS2TR.recreateFromSaveState(a,b)}}},wmsx.SlotFormats.Expanded=wmsx.SlotFormats.Expanded3,wmsx.SlotFormats.MoonSound=wmsx.SlotFormats.OPL4,wmsx.SlotFormats.GenericKonami=wmsx.SlotFormats.Normal,wmsx.SlotFormats.Manbow2_2=wmsx.SlotFormats.Manbow2,wmsx.SlotFormats.HamarajaNight=wmsx.SlotFormats.Manbow2,wmsx.SlotFormats.Kanji12=wmsx.SlotFormats.Kanji1,wmsx.SlotFormats.FMPAK=wmsx.SlotFormats.FMPAC,
wmsx.SlotFormatsUserOptions=["Normal","Mirrored","NotMirrored","ASCII8","ASCII16","Konami","KonamiSCC","KonamiSCCI","ASCII8SRAM2","ASCII8SRAM8","ASCII16SRAM2","ASCII16SRAM8","MegaRAM","GameMaster2","AlQuran","AlQuranDecoded","CrossBlaim","Dooly","Halnote","HarryFox","KoeiSRAM8","KoeiSRAM32","Majutsushi","Manbow2","MSXWrite","RType","SuperLodeRunner","SuperSwangi","Synthesizer","Wizardry","Zemina80in1","Zemina90in1","Zemina126in1","FMPAC","Kanji1","MSXDOS2","MSXMUSIC"],wmsx.Slot=function(){"use strict";this.connect=function(a){},this.refreshConnect=function(a){},this.disconnect=function(a){},this.getDataDesc=function(){},this.loadData=function(a,b){},this.getDataToSave=function(){},this.dataModified=function(){return!1},this.powerOn=function(){},this.powerOff=function(){},this.reset=function(){},this.read=function(a){return 255},this.write=function(a,b){},this.setDRAMMode=function(a){},this.getBreakWaitSub=function(a,b){return 0},this.getAccessWaitSub=function(a){return 0},this.cpuExtensionBegin=function(a){},this.cpuExtensionFinish=function(a){},this.isExpanded=function(){return!1},this.getSecondarySlotConfig=function(){return 0},this.reinsertROMContent=function(){this.rom.content||(this.rom.content=this.bytes||[])},this.lightState=function(){return WMSX.LIGHT_STATES&&wmsx.EmbeddedFiles.isEmbeddedURL(this.rom.source)},this.format=void 0,this.rom=void 0,this.bytes=void 0,this.dumpBytes=function(a,b,c){wmsx.Util.dump(this.bytes,a,b,c)},this.dumpRead=function(a,b,c){var d="",e=a||0;c=c||1;for(var f=0;f<c;f++){for(var g=0;g<b;g++){var h=this.read(e++);d+=void 0!=h?h.toString(16,2)+" ":"? "}d+="   "}console.log(d)}},wmsx.Slot.base=new wmsx.Slot,wmsx.SlotEmpty={},wmsx.SlotEmpty.impl=function(){"use strict";this.read=function(a){return 255},this.rom=new wmsx.ROM("EMPTY",[],{n:"EMPTY",h:"",l:"EMPTY"}),this.format=wmsx.SlotFormats.Empty,this.saveState=function(){return{f:this.format.name}}},wmsx.SlotEmpty.impl.prototype=wmsx.Slot.base,wmsx.SlotEmpty.singleton=new wmsx.SlotEmpty.impl,wmsx.SlotExpanded=function(){"use strict";function a(a){var b=a>>14;return 0===b?g:1===b?h:2===b?i:j}function b(a){k=a,g=f[3&a],h=f[a>>2&3],i=f[a>>4&3],j=f[a>>6&3]}function c(){f=[l,l,l,l],d.subSlots=f}var d=this;this.isExpanded=function(){return!0},this.connect=function(a){e=a;for(var b=0;b<4;++b)f[b].connect(e)},this.refreshConnect=function(){for(var a=0;a<4;++a)f[a].refreshConnect()},this.disconnect=function(a){for(var b=0;b<4;++b)f[b].disconnect(a);e=null},this.powerOn=function(){b(0);for(var a=0;a<4;a++)f[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)f[a].powerOff()},this.reset=function(){b(0);for(var a=0;a<4;a++)f[a].reset()},this.isAllEmpty=function(){return f[0]===l&&f[1]===l&&f[2]===l&&f[3]===l},this.insertSubSlot=function(a,c){a=a||wmsx.SlotEmpty.singleton,f[c]!==a&&(e&&f[c].disconnect(e),f[c]=a,e&&f[c].connect(e),b(k))},this.getSubSlot=function(a){return f[a]},this.getSubSlotForAddress=a,this.read=function(a){var b=a>>14;return 0===b?g.read(a):1===b?h.read(a):2===b?i.read(a):65535===a?255&~k:j.read(a)},this.write=function(a,c){var d=a>>14;0===d?g.write(a,c):3===d?65535===a?b(c):j.write(a,c):1===d?h.write(a,c):i.write(a,c)},this.setSecondarySlotConfig=b,this.getSecondarySlotConfig=function(){return k},this.cpuExtensionBegin=function(b){return a(b.extPC).cpuExtensionBegin(b)},this.cpuExtensionFinish=function(b){return a(b.extPC).cpuExtensionFinish(b)};var e,f,g,h,i,j,k=0,l=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.ExpandedS,this.saveState=function(){return{f:this.format.name,s:k,s0:f[0].saveState(),s1:f[1].saveState(),s2:f[2].saveState(),s3:f[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,f[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,f[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,f[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,f[3]),3),b(a.s)},function(){c()}()},wmsx.SlotExpanded.prototype=wmsx.Slot.base,wmsx.SlotExpanded.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpanded;return c.loadState(a),c},wmsx.SlotExpanded0=function(){"use strict";function a(a){var b=a>>14;return 0===b?g:1===b?h:2===b?i:j}function b(a){k=a,g=f[3&a],h=f[a>>2&3],i=f[a>>4&3],j=f[a>>6&3]}function c(){f=[l,l,l,l],d.subSlots=f}var d=this;this.isExpanded=function(){return!0},this.connect=function(a){e=a;for(var b=0;b<4;++b)f[b].connect(e)},this.refreshConnect=function(){for(var a=0;a<4;++a)f[a].refreshConnect()},this.disconnect=function(a){for(var b=0;b<4;++b)f[b].disconnect(a);e=null},this.powerOn=function(){b(0);for(var a=0;a<4;a++)f[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)f[a].powerOff()},this.reset=function(){b(0);for(var a=0;a<4;a++)f[a].reset()},this.isAllEmpty=function(){return f[0]===l&&f[1]===l&&f[2]===l&&f[3]===l},this.insertSubSlot=function(a,c){a=a||wmsx.SlotEmpty.singleton,f[c]!==a&&(e&&f[c].disconnect(e),f[c]=a,e&&f[c].connect(e),b(k))},this.getSubSlot=function(a){return f[a]},this.getSubSlotForAddress=a,this.read=function(a){var b=a>>14;return 0===b?g.read(a):2===b?i.read(a):3===b?65535===a?255&~k:j.read(a):h.read(a)},this.write=function(a,c){var d=a>>14;3===d?65535===a?b(c):j.write(a,c):0===d?g.write(a,c):1===d?h.write(a,c):i.write(a,c)},this.setSecondarySlotConfig=b,this.getSecondarySlotConfig=function(){return k},this.cpuExtensionBegin=function(b){return a(b.extPC).cpuExtensionBegin(b)},this.cpuExtensionFinish=function(b){return a(b.extPC).cpuExtensionFinish(b)};var e,f,g,h,i,j,k=0,l=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.Expanded0,this.formatBack=wmsx.SlotFormats.Expanded,this.saveState=function(){return{f:this.format.name,s:k,s0:f[0].saveState(),s1:f[1].saveState(),s2:f[2].saveState(),s3:f[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,f[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,f[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,f[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,f[3]),3),b(a.s)},function(){c()}()},wmsx.SlotExpanded0.prototype=wmsx.Slot.base,wmsx.SlotExpanded0.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpanded0;return c.loadState(a),c},wmsx.SlotExpanded3=function(){"use strict";function a(a){var b=a>>14;return 0===b?h:1===b?i:2===b?j:k}function b(a){l=a,h=g[3&a],i=g[a>>2&3],j=g[a>>4&3],k=g[a>>6&3],f&&f.setSlot3SecondaryConfig(a)}function c(){g=[m,m,m,m],d.subSlots=g}var d=this;this.isExpanded=function(){return!0},this.connect=function(a){e=a,f=e.bus;for(var c=0;c<4;++c)g[c].connect(e);b(l)},this.refreshConnect=function(){for(var a=0;a<4;++a)g[a].refreshConnect();b(l)},this.disconnect=function(a){for(var c=0;c<4;++c)g[c].disconnect(a);b(0),e=f=null},this.powerOn=function(){b(0);for(var a=0;a<4;a++)g[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)g[a].powerOff()},this.reset=function(){b(0);for(var a=0;a<4;a++)g[a].reset()},this.isAllEmpty=function(){return g[0]===m&&g[1]===m&&g[2]===m&&g[3]===m},this.insertSubSlot=function(a,c){a=a||wmsx.SlotEmpty.singleton,g[c]!==a&&(e&&g[c].disconnect(e),g[c]=a,e&&g[c].connect(e),b(l))},this.getSubSlot=function(a){return g[a]},this.getSubSlotForAddress=a,this.read=function(a){var b=a>>14;return 0===b?h.read(a):1===b?i.read(a):2===b?j.read(a):65535===a?255&~l:k.read(a)},this.write=function(a,c){var d=a>>14;0===d?h.write(a,c):3===d?65535===a?b(c):k.write(a,c):1===d?i.write(a,c):j.write(a,c)},this.setSecondarySlotConfig=b,this.getSecondarySlotConfig=function(){return l},this.cpuExtensionBegin=function(b){return a(b.extPC).cpuExtensionBegin(b)},this.cpuExtensionFinish=function(b){return a(b.extPC).cpuExtensionFinish(b)};var e,f,g,h,i,j,k,l=0,m=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.Expanded3,this.formatBack=wmsx.SlotFormats.Expanded,this.saveState=function(){
return{f:this.format.name,s:l,s0:g[0].saveState(),s1:g[1].saveState(),s2:g[2].saveState(),s3:g[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,g[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,g[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,g[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,g[3]),3),b(a.s)},function(){c()}()},wmsx.SlotExpanded3.prototype=wmsx.Slot.base,wmsx.SlotExpanded3.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpanded3;return c.loadState(a),c},wmsx.SlotExpandedM=function(){"use strict";function a(){d=[e,e,e,e],b.subSlots=d}var b=this;this.isExpanded=function(){return!0},this.connect=function(a){c=a;for(var b=0;b<4;++b)d[b].connect(c)},this.refreshConnect=function(){for(var a=0;a<4;++a)d[a].refreshConnect()},this.disconnect=function(a){for(var b=0;b<4;++b)d[b].disconnect(a);c=null},this.powerOn=function(){for(var a=0;a<4;a++)d[a].powerOn()},this.powerOff=function(){for(var a=0;a<4;a++)d[a].powerOff()},this.reset=function(){for(var a=0;a<4;a++)d[a].reset()},this.isAllEmpty=function(){return d[0]===e&&d[1]===e&&d[2]===e&&d[3]===e},this.insertSubSlot=function(a,b){a=a||wmsx.SlotEmpty.singleton,d[b]!==a&&(c&&d[b].disconnect(c),d[b]=a,c&&d[b].connect(c))},this.getSubSlot=function(a){return d[a]},this.getSubSlotForAddress=function(a){},this.read=function(a){},this.write=function(a,b){},this.getSecondarySlotConfig=function(){},this.cpuExtensionBegin=function(a){},this.cpuExtensionFinish=function(a){};var c,d,e=wmsx.SlotEmpty.singleton;this.format=wmsx.SlotFormats.ExpandedM,this.saveState=function(){return{f:this.format.name,s0:d[0].saveState(),s1:d[1].saveState(),s2:d[2].saveState(),s3:d[3].saveState()}},this.loadState=function(a){this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,d[0]),0),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,d[1]),1),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,d[2]),2),this.insertSubSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,d[3]),3)},function(){a()}()},wmsx.SlotExpandedM.prototype=wmsx.Slot.base,wmsx.SlotExpandedM.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotExpandedM;return c.loadState(a),c},wmsx.SlotNormal=function(a,b){"use strict";function c(a){if(65!==d[a]||66!==d[a+1])return null;for(var b=null,c=65535,e=a+2;e<=a+8;e+=2){var f=d[e+1]<<8|d[e];0!==f&&(f<c&&(c=f),e===a+8&&(!b||f<b)&&(b=f))}return 65535===c?null:{lowestHandlerPage:c>>14,lowestBasicPage:null!==b?b>>14:null}}this.read=function(a){return a>=e&&a<f?d[a-e]:h?d[a+65536-e&g]:255};var d;this.bytes=null;var e,f,g,h;this.rom=null,this.format=null,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),ba:e,m:h}},this.loadState=function(a){this.format=void 0===a.m?wmsx.SlotFormats.Normal:wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,e=a.ba,f=e+d.length,g=d.length-1,h=void 0!==a.m?a.m:a.f===wmsx.SlotFormats.Mirrored.name},a&&function(i){i.rom=a,d=wmsx.Util.asNormalArray(a.content),i.bytes=d;var j=d.length;g=j-1,i.format=b;var k=0;if(h=b===wmsx.SlotFormats.Mirrored||b!==wmsx.SlotFormats.NotMirrored&&null,j>32768)k=0;else{var l=a.info.s?parseInt(a.info.s):-1;if(l>=0)k=l>>14;else{for(var m=null,n=null,o=0;o<j;o+=16384){var p=c(o);if(null!=p){m=p.lowestHandlerPage,n=p.lowestBasicPage;break}}null===m?k=1:j>16384?k=0===o?3===m?2:1:0===m?0:1:(k=2===m?2:1,null===h&&2===k&&2===n&&(h=!1)),null===h&&(h=!0)}}h=!!h,e=k<<14,f=Math.min(e+j,65536),wmsx.Util.log("Address: 0x"+wmsx.Util.toHex4(e)+" - 0x"+wmsx.Util.toHex4(f-1)+", Mirrored: "+h)}(this)},wmsx.SlotNormal.prototype=wmsx.Slot.base,wmsx.SlotNormal.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotNormal;return c.loadState(a),c},wmsx.SlotPlainROM=function(a){"use strict";this.read=function(a){return a>=d&&a<c?b[a-d]:255};var b;this.bytes=null;var c,d;this.rom=null,this.format=wmsx.SlotFormats.PlainROM,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),ba:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,d=a.ba,c=d+b.length},a&&function(e){e.rom=a,b=wmsx.Util.asNormalArray(a.content),e.bytes=b,d=void 0!==a.info.s?a.info.s:0,c=d+b.length}(this)},wmsx.SlotPlainROM.prototype=wmsx.Slot.base,wmsx.SlotPlainROM.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotPlainROM;return c.loadState(a),c},wmsx.SlotRAMNormal=function(a){"use strict";function b(a,b){a.rom=b;var e=WMSX.RAMNORMAL_SIZE;e<1?e=1:e>64&&(e=64),c=new Uint8Array(1024*e),d=65536-c.length,a.bytes=c}this.refreshConnect=function(){1024*WMSX.RAMNORMAL_SIZE!==c.length&&b(this,this.rom)},this.powerOff=function(){wmsx.Util.arrayFill(c,0)},this.read=function(a){return a>=d?c[a-d]:255},this.write=function(a,b){a>=d&&(c[a-d]=b)};var c;this.bytes=null;var d=0;this.rom=null,this.format=wmsx.SlotFormats.RAMNormal,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c)}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=65536-c.length},a&&b(this,a)},wmsx.SlotRAMNormal.prototype=wmsx.Slot.base,wmsx.SlotRAMNormal.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotRAMNormal;return c.loadState(a),c},wmsx.SlotRAMMapper=function(rom){"use strict";function init(a,b){a.rom=b;for(var c=0;VALID_SIZES[c]<WMSX.RAMMAPPER_SIZE&&c<VALID_SIZES.length-1;)c++;var d=VALID_SIZES[c];bytes=new Uint8Array(1024*d),a.bytes=bytes,pageMask=(bytes.length>>14)-1,pageReadBackOR=255&~pageMask,dramModeStart=bytes.length-65536}this.connect=function(a){trd=a.trd,a.bus.connectInputDevice(252,this.inputAll),a.bus.connectInputDevice(253,this.inputAll),a.bus.connectInputDevice(254,this.inputAll),a.bus.connectInputDevice(255,this.inputAll),a.bus.connectOutputDevice(252,this.outputFC),a.bus.connectOutputDevice(253,this.outputFD),a.bus.connectOutputDevice(254,this.outputFE),a.bus.connectOutputDevice(255,this.outputFF),trd.connectRAM(this)},this.refreshConnect=function(){1024*WMSX.RAMMAPPER_SIZE!==bytes.length&&(init(this,this.rom),trd&&trd.connectRAM(this))},this.disconnect=function(a){a.bus.disconnectInputDevice(252,this.inputAll),a.bus.disconnectInputDevice(253,this.inputAll),a.bus.disconnectInputDevice(254,this.inputAll),a.bus.disconnectInputDevice(255,this.inputAll),a.bus.disconnectOutputDevice(252,this.outputFC),a.bus.disconnectOutputDevice(253,this.outputFD),a.bus.disconnectOutputDevice(254,this.outputFE),a.bus.disconnectOutputDevice(255,this.outputFF),a.trd.disconnectRAM(this)},this.setDRAMMode=function(a){dramModeOff=!a},this.powerOn=function(){this.reset()},this.powerOff=function(){wmsx.Util.arrayFill(bytes,0)},this.reset=function(){page0Offset=page1Offset=page2Offset=page3Offset=0,dramModeOff=!0},this.outputFC=function(a){page0Offset=(a&pageMask)<<14},this.outputFD=function(a){page1Offset=((a&pageMask)<<14)-16384},this.outputFE=function(a){page2Offset=((a&pageMask)<<14)-32768},this.outputFF=function(a){page3Offset=((a&pageMask)<<14)-49152},this.inputAll=function(a){switch(255&a){case 252:return pageReadBackOR|page0Offset>>14;case 253:return pageReadBackOR|page1Offset+16384>>14;case 254:return pageReadBackOR|page2Offset+32768>>14;case 255:return pageReadBackOR|page3Offset+49152>>14}},this.read=function(a){var b=a>>14;return 3===b?bytes[a+page3Offset]:0===b?bytes[a+page0Offset]:2===b?bytes[a+page2Offset]:bytes[a+page1Offset]},this.write=function(a,b){
var c=a>>14;3===c?(dramModeOff||a+page3Offset<dramModeStart)&&(bytes[a+page3Offset]=b):0===c?(dramModeOff||a+page0Offset<dramModeStart)&&(bytes[a+page0Offset]=b):2===c?(dramModeOff||a+page2Offset<dramModeStart)&&(bytes[a+page2Offset]=b):(dramModeOff||a+page1Offset<dramModeStart)&&(bytes[a+page1Offset]=b)};var trd,page0Offset=0,page1Offset=0,page2Offset=0,page3Offset=0,pageMask=0,pageReadBackOR=0,dramModeOff=!0,dramModeStart=0,bytes;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.RAMMapper;var VALID_SIZES=[64,128,256,512,1024,2048,4096];this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),p0:page0Offset,p1:page1Offset,p2:page2Offset,p3:page3Offset,dr:!dramModeOff}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,pageMask=(bytes.length>>14)-1,page0Offset=a.p0,page1Offset=a.p1,page2Offset=a.p2,page3Offset=a.p3,pageReadBackOR=255&~pageMask,dramModeStart=bytes.length-65536,dramModeOff=!a.dr,trd&&trd.connectRAM(this)},rom&&init(this,rom),this.eval=function(str){return eval(str)}},wmsx.SlotRAMMapper.prototype=wmsx.Slot.base,wmsx.SlotRAMMapper.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotRAMMapper;return c.loadState(a),c},wmsx.SlotBIOS=function(a){"use strict";this.connect=function(a){b=a,b.setBIOS(this),b.trd.connectBIOS(this),i.connect(b),h.connect(this,b),j.connect(b)},this.disconnect=function(a){b=void 0,h&&h.disconnect(this,a),j&&j.disconnect(this,a),a.trd.disconnectBIOS(this),a.setBIOS(null)},this.connectRAM=function(a,b){e=a.bytes,g=e.length-b},this.disconnectRAM=function(a){e===a.bytes&&(e=void 0,f=!1)},this.getKeyboardExtension=function(){return i},this.getTurboDriver=function(){return j},this.powerOff=function(){j&&j.powerOff(),h&&h.powerOff()},this.reset=function(){j&&j.reset(),f=!1},this.setDRAMMode=function(a){f=!!a},this.read=function(a){return a<d?f?e[g+a]:c[a]:64689===a?0:255},this.cpuExtensionBegin=function(a){return a.extNum<233?h.cpuExtensionBegin(a):a.extNum<238?b.trd.cpuExtensionBegin(a):j.cpuExtensionBegin(a)},this.cpuExtensionFinish=function(a){return a.extNum<233?h.cpuExtensionFinish(a):a.extNum<238?b.trd.cpuExtensionFinish(a):j.cpuExtensionFinish(a)},this.setVideoStandardForced=function(a){a===wmsx.VideoStandard.PAL?c[43]|=128:c[43]&=-129},this.setVideoStandardUseOriginal=function(){this.originalVideoStandard===wmsx.VideoStandard.PAL?c[43]|=128:c[43]&=-129};var b,c;this.bytes=null;var d,e,f=!1,g=0,h=new wmsx.ImageCassetteDriver,i=new wmsx.BIOSKeyboardExtension,j=new wmsx.TurboDriver(this);this.rom=null,this.format=wmsx.SlotFormats.BIOS,this.originalVideoStandard=null,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),v:this.originalVideoStandard.name,b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(c),ke:i.saveState(),td:j.saveState(),dr:f}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),this.originalVideoStandard=wmsx.VideoStandard[a.v],a.b?c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c):(this.rom.reloadEmbeddedContent(),c&&c.length===this.rom.content.length||(c=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,c),b&&b.trd.patchPCMBIOS(c)),this.bytes=c,d=c.length,b&&h.patchTapeBIOS(c,b),a.ke&&i.loadState(a.ke),j.loadState(a.td),f=!!a.dr},a&&function(b){b.rom=a,c=wmsx.Util.asNormalArray(a.content),b.bytes=c,d=c.length,b.originalVideoStandard=0==(128&c[43])?wmsx.VideoStandard.NTSC:wmsx.VideoStandard.PAL}(this)},wmsx.SlotBIOS.prototype=wmsx.Slot.base,wmsx.SlotBIOS.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotBIOS;return c.loadState(a),c},wmsx.SlotMSX2BIOSExt=function(a){"use strict";this.connect=function(a){a.trd.connectBIOSExt(this)},this.disconnect=function(a){a.trd.disconnectBIOSExt(this)},this.connectRAM=function(a,b){c=a.bytes,f=c.length-b},this.disconnectRAM=function(a){c===a.bytes&&(c=void 0,e=!1)},this.reset=function(){e=!1},this.setDRAMMode=function(a){e=!!a},this.read=function(a){return a<d?e&&a<32768?c[f+a]:b[a]:255};var b;this.bytes=null;var c,d,e=!1,f=0;this.rom=null,this.format=wmsx.SlotFormats.MSX2BIOSExt,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),dr:e}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,d=b.length,e=!!a.dr},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,d=b.length}(this)},wmsx.SlotMSX2BIOSExt.prototype=wmsx.Slot.base,wmsx.SlotMSX2BIOSExt.recreateFromSaveState=function(a,b){var c=b||new wmsx.SlotMSX2BIOSExt;return c.loadState(a),c},wmsx.CartridgeASCII8K=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=-16384,d=-24576,e=-32768,f=-40960},this.write=function(a,b){if(!(a<24576))return a<26624?void(c=(b%g<<13)-16384):a<28672?void(d=(b%g<<13)-24576):a<30720?void(e=(b%g<<13)-32768):void(a<32768&&(f=(b%g<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return b[c+a];case 24576:return b[d+a];case 32768:return b[e+a];case 40960:return b[f+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g;this.rom=null,this.format=wmsx.SlotFormats.ASCII8,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d,b3:e,b4:f,n:g}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=a.b3,f=a.b4,g=a.n},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,g=b.length/8192|0}(this)},wmsx.CartridgeASCII8K.prototype=wmsx.Slot.base,wmsx.CartridgeASCII8K.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII8K;return c.loadState(a),c},wmsx.CartridgeASCII16K=function(a,b){"use strict";function c(a){a===wmsx.SlotFormats.MSXWrite?(h=28671,i=32767):(h=-1,i=-1)}this.powerOn=function(){this.reset()},this.reset=function(){e=-16384,f=-32768},this.write=function(a,b){if(a>=24576&&a<26624||a===h)return void(e=(b%g<<14)-16384);(a>=28672&&a<30720||a===i)&&(f=(b%g<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?d[e+a]:a<49152?d[f+a]:255};var d;this.bytes=null;var e,f,g,h,i;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),b1:e,b2:f,n:g}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,e=a.b1,f=a.b2,g=a.n,c(this.format)},a&&function(e){e.rom=a,d=wmsx.Util.asNormalArray(a.content),e.bytes=d,g=d.length/16384|0,c(b)}(this)},wmsx.CartridgeASCII16K.prototype=wmsx.Slot.base,wmsx.CartridgeASCII16K.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII16K;return c.loadState(a),c},wmsx.CartridgeKonami=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=e=-16384},this.write=function(a,b){a>=24576&&a<32767?c=(b%f<<13)-24576:a>=32768&&a<40959?d=(b%f<<13)-32768:a>=40960&&a<49151&&(e=(b%f<<13)-40960)},this.read=function(a){switch(57344&a){case 16384:return b[a-16384];case 24576:return b[c+a];case 32768:return b[d+a];case 40960:return b[e+a];default:return 255}};var b;this.bytes=null;var c,d,e,f;this.rom=null,this.format=wmsx.SlotFormats.Konami,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c,b3:d,b4:e,n:f}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),
b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=a.b3,e=a.b4,f=a.n},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,f=b.length/8192|0}(this)},wmsx.CartridgeKonami.prototype=wmsx.Slot.base,wmsx.CartridgeKonami.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKonami;return c.loadState(a),c},wmsx.CartridgeRType=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=-32768},this.write=function(a,b){a>=28672&&a<32768&&(c=(b%24<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[229376+a]:a<49152?b[c+a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.RType,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeRType.prototype=wmsx.Slot.base,wmsx.CartridgeRType.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeRType;return c.loadState(a),c},wmsx.CartridgeCrossBlaim=function(a){this.powerOn=function(){this.reset()},this.reset=function(){c=-16384},this.write=function(a,b){16453===a&&(c=((3&b)<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[a-16384]:a<49152?b[c+a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.CrossBlaim,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeCrossBlaim.prototype=wmsx.Slot.base,wmsx.CartridgeCrossBlaim.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeCrossBlaim;return c.loadState(a),c},wmsx.CartridgeDOS2=function(a){"use strict";this.connect=function(a){a.getDiskDriveSocket().dos2ROMConnected(this)},this.disconnect=function(a){a.getDiskDriveSocket().dos2ROMDisconnected(this)},this.powerOn=function(){this.reset()},this.reset=function(){c=-16384},this.write=function(a,b){32766===a&&(c=((3&b)<<14)-16384)},this.read=function(a){return a>=16384&&a<32768?b[c+a]:255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.MSXDOS2,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeDOS2.prototype=wmsx.Slot.base,wmsx.CartridgeDOS2.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDOS2;return c.loadState(a),c},wmsx.CartridgeHarryFox=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=-16384},this.write=function(a,b){if(a>=24576&&a<28672)return void(c=(1&b?32768:0)-16384);a>=28672&&a<32768&&(d=(1&b?49152:16384)-32768)},this.read=function(a){return a<16384?255:a<32768?b[c+a]:a<49152?b[d+a]:255};var b;this.bytes=null;var c,d;this.rom=null,this.format=wmsx.SlotFormats.HarryFox,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeHarryFox.prototype=wmsx.Slot.base,wmsx.CartridgeHarryFox.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeHarryFox;return c.loadState(a),c},wmsx.CartridgeAlQuran=function(a,b){"use strict";function c(){for(var a=new Array(256),b=0;b<256;++b)a[b]=77^(b<<4&80|b>>3&5|b<<1&160|b<<2&8|b>>6&2);for(var c=0,e=d.length;c<e;++c)d[c]=a[d[c]]}this.powerOn=function(){this.reset()},this.reset=function(){e=-16384,f=-24576,g=-32768,h=-40960},this.write=function(a,b){if(!(a<20480))return a<21504?void(e=((127&b)<<13)-16384):a<22528?void(f=((127&b)<<13)-24576):a<23552?void(g=((127&b)<<13)-32768):void(a<24576&&(h=((127&b)<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return d[e+a];case 24576:return d[f+a];case 32768:return d[g+a];case 40960:return d[h+a];default:return 255}};var d;this.bytes=null;var e,f,g,h;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),b1:e,b2:f,b3:g,b4:h}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,e=a.b1,f=a.b2,g=a.b3,h=a.b4},a&&function(e){e.rom=a,d=wmsx.Util.asNormalArray(a.content),e.bytes=d,b===wmsx.SlotFormats.AlQuran&&c()}(this)},wmsx.CartridgeAlQuran.prototype=wmsx.Slot.base,wmsx.CartridgeAlQuran.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeAlQuran;return c.loadState(a),c},wmsx.CartridgeSuperSwangi=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=-32768},this.write=function(a,b){32768===a&&(c=((b>>1)%d<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[a-16384]:a<49152?b[c+a]:255};var b;this.bytes=null;var c,d;this.rom=null,this.format=wmsx.SlotFormats.SuperSwangi,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=b.length/16384|0},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,d=b.length/16384|0}(this)},wmsx.CartridgeSuperSwangi.prototype=wmsx.Slot.base,wmsx.CartridgeSuperSwangi.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSuperSwangi;return c.loadState(a),c},wmsx.CartridgeZemina80=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=e=f=-16384},this.write=function(a,b){switch(a){case 16384:return void(c=(b%g<<13)-16384);case 16385:return void(d=(b%g<<13)-24576);case 16386:return void(e=(b%g<<13)-32768);case 16387:f=(b%g<<13)-40960}},this.read=function(a){switch(57344&a){case 16384:return b[c+a];case 24576:return b[d+a];case 32768:return b[e+a];case 40960:return b[f+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g;this.rom=null,this.format=wmsx.SlotFormats.Zemina80in1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d,b3:e,b4:f}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=a.b3,f=a.b4,g=b.length/8192|0},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,g=b.length/8192|0}(this)},wmsx.CartridgeZemina80.prototype=wmsx.Slot.base,wmsx.CartridgeZemina80.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeZemina80;return c.loadState(a),c},wmsx.CartridgeZemina90=function(a){"use strict";this.connect=function(a){a.bus.connectOutputDevice(119,this.output77)},this.disconnect=function(a){a.bus.disconnectOutputDevice(119,this.output77)},this.powerOn=function(){this.reset()},this.reset=function(){this.output77(0)},this.read=function(a){return a<16384?255:a<32768?b[d+a]:a<49152?f?b[e+a^8192]:b[e+a]:255},this.output77=function(a,b){c=a;var g=63&a,h=a>>6;2===h?(d=((62&g)<<14)-16384,e=((1|g)<<14)-32768):(d=(g<<14)-16384,e=(g<<14)-32768),f=3===h};var b;this.bytes=null;var c,d,e,f;this.rom=null,
this.format=wmsx.SlotFormats.Zemina90in1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),bc:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,this.output77(a.bc)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeZemina90.prototype=wmsx.Slot.base,wmsx.CartridgeZemina90.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeZemina90;return c.loadState(a),c},wmsx.CartridgeZemina126=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=d=-16384},this.write=function(a,b){if(16384===a)return void(c=(b%e<<14)-16384);16385===a&&(d=(b%e<<14)-32768)},this.read=function(a){return a<16384?255:a<32768?b[c+a]:a<49152?b[d+a]:255};var b;this.bytes=null;var c,d,e;this.rom=null,this.format=wmsx.SlotFormats.Zemina126in1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b1,d=a.b2,e=b.length/16384|0},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,e=b.length/16384|0}(this)},wmsx.CartridgeZemina126.prototype=wmsx.Slot.base,wmsx.CartridgeZemina126.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeZemina126;return c.loadState(a),c},wmsx.CartridgeSuperLodeRunner=function(a){"use strict";function b(a,b){0===a&&(d=(b%e<<14)-32768)}this.connect=function(a){a.bus.setWriteMonitor(b)},this.disconnect=function(a){a.bus.setWriteMonitor(null)},this.powerOn=function(){this.reset()},this.reset=function(){d=32768},this.read=function(a){return a>=32768&&a<49152?c[d+a]:255};var c;this.bytes=null;var d,e;this.rom=null,this.format=wmsx.SlotFormats.SuperLodeRunner,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c),b1:d}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=a.b1,e=c.length/16384|0},a&&function(b){b.rom=a,c=wmsx.Util.asNormalArray(a.content),b.bytes=c,e=c.length/16384|0}(this)},wmsx.CartridgeSuperLodeRunner.prototype=wmsx.Slot.base,wmsx.CartridgeSuperLodeRunner.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSuperLodeRunner;return c.loadState(a),c},wmsx.CartridgeDooly=function(a){"use strict";this.powerOn=function(){this.reset()},this.reset=function(){c=0},this.write=function(a,b){a>=16384&&a<49152&&(c=7&b)},this.read=function(a){if(a>=16384&&a<49152){var d=b[a-16384];switch(c){case 0:return d;case 1:return 248&d|d<<2&4|d>>1&3;case 4:return 248&d|d>>2&1|d<<1&6;case 2:case 5:case 6:switch(7&d){case 1:case 2:case 4:return 248&d;case 3:case 5:case 6:if(2==c)return 248&d|7^(d<<2&4|d>>1&3);if(5==c)return 7^d;if(6==c)return 248&d|7^(d>>2&1|d<<1&6);default:return d}default:return 7|d}}return 255};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.Dooly,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),e:c}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.e},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeDooly.prototype=wmsx.Slot.base,wmsx.CartridgeDooly.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDooly;return c.loadState(a),c},wmsx.CartridgeMegaRAM=function(a){"use strict";this.reinsertROMContent=function(){this.rom.content&&this.rom.content.length||(this.rom.content=this.bytes.slice(0,this.bytes.length))},this.connect=function(a){a.bus.connectInputDevice(142,this.input8E),a.bus.connectOutputDevice(142,this.output8E)},this.disconnect=function(a){a.bus.disconnectInputDevice(142,this.input8E),a.bus.disconnectOutputDevice(142,this.output8E)},this.powerOn=function(){this.reset()},this.reset=function(){h=!1},this.input8E=function(){return h=!0,255},this.output8E=function(a){h=!1},this.write=function(a,i){if(!(a<16384))return a<24576?void(h?b[d+a]=i:d=(i%c<<13)-16384):a<32768?void(h?b[e+a]=i:e=(i%c<<13)-24576):a<40960?void(h?b[f+a]=i:f=(i%c<<13)-32768):void(a<49152&&(h?b[g+a]=i:g=(i%c<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return b[d+a];case 24576:return b[e+a];case 32768:return b[f+a];case 40960:return b[g+a];default:return 255}};var b;this.bytes=null;var c,d=-16384,e=-16384,f=-16384,g=-16384,h=!1;this.rom=null,this.format=wmsx.SlotFormats.MegaRAM;var i=Math.min(WMSX.MEGARAM_SIZE/8,256),j=[32,64,128,256];this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:d,b2:e,b3:f,b4:g,n:c,m:h}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,d=a.b1,e=a.b2,f=a.b3,g=a.b4,c=a.n,h=a.m},a&&function(d){d.rom=a;var e=a.content;if(e&&e.length){c=Math.ceil(e.length/8192);for(var f=0;j[f]<c;)++f;c=j[f]}else c=i;b=new Array(8192*c),wmsx.Util.arrayCopy(e,0,b),wmsx.Util.arrayFill(b,0,e.length),d.bytes=b}(this)},wmsx.CartridgeMegaRAM.prototype=wmsx.Slot.base,wmsx.CartridgeMegaRAM.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMegaRAM;return c.loadState(a),c},wmsx.CartridgeDiskPatched=function(a){"use strict";function b(){f.patchDiskBIOS(c,0-d,16384,22383,22608,30867)}this.connect=function(a){f.connect(this,a),a.getDiskDriveSocket().diskInterfaceConnected(this)},this.disconnect=function(a){f.disconnect(this,a),a.getDiskDriveSocket().diskInterfaceDisconnected(this)},this.powerOff=function(){f.powerOff()},this.read=function(a){return a>=d&&a<e?c[a-d]:255},this.cpuExtensionBegin=function(a){return f.cpuExtensionBegin(a)},this.cpuExtensionFinish=function(a){return f.cpuExtensionFinish(a)};var c;this.bytes=null;var d,e;this.rom=null,this.format=wmsx.SlotFormats.DiskPatch;var f=new wmsx.ImageDiskDriver(!1);this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(c),d:f.saveState(),ba:d}},this.loadState=function(a){if(this.rom=wmsx.ROM.loadState(a.r),d=void 0!==a.ba?a.ba:16384,a.b)c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),c.length=-16384&c.length,f.rePatchDiskBIOSOldStateForExtensions(c,0-d,16384,22383,22608);else{this.rom.reloadEmbeddedContent();var g=this.rom.content.length;c&&c.length===g||(c=new Array(g)),wmsx.Util.arrayCopy(this.rom.content,0,c),b()}this.bytes=c,e=d+c.length,f.loadState(a.d)},a&&function(f){f.rom=a,c=new Array(a.content.length),wmsx.Util.arrayCopy(a.content,0,c),f.bytes=c,d=16384===a.content.length?16384:16384*(WMSX.DISK_ROM_START_PAGE||0),e=d+c.length,b()}(this)},wmsx.CartridgeDiskPatched.prototype=wmsx.Slot.base,wmsx.CartridgeDiskPatched.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDiskPatched(null);return c.loadState(a),c},wmsx.CartridgeDiskPatchedDOS2TR=function(a){"use strict";function b(){e.patchDiskBIOS(c,-16384,16384,18390,18630,30756),e.patchDiskBIOS(c,32768,16384,22383,22608,30762)}this.connect=function(a){e.connect(this,a),a.getDiskDriveSocket().diskInterfaceConnected(this),a.getDiskDriveSocket().dos2ROMConnected(this)},this.disconnect=function(a){e.disconnect(this,a),a.getDiskDriveSocket().diskInterfaceDisconnected(this),a.getDiskDriveSocket().dos2ROMDisconnected(this)},this.powerOn=function(){this.reset()},this.reset=function(){d=-16384},this.powerOff=function(){e.powerOff()},this.read=function(a){return a>=16384&&a<32768?c[d+a]:255},this.write=function(a,b){32752===a&&(d=((3&b)<<14)-16384)},this.cpuExtensionBegin=function(a){return e.cpuExtensionBegin(a)},
this.cpuExtensionFinish=function(a){return e.cpuExtensionFinish(a)};var c;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.DiskPatchDOS2TR;var d,e=new wmsx.ImageDiskDriver(!0);this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(c),d:e.saveState(),b1:d}},this.loadState=function(a){if(this.rom=wmsx.ROM.loadState(a.r),a.b)c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c);else{this.rom.reloadEmbeddedContent();var f=this.rom.content.length;c&&c.length===f||(c=new Array(f)),wmsx.Util.arrayCopy(this.rom.content,0,c),b()}this.bytes=c,d=a.b1,e.loadState(a.d)},a&&function(d){d.rom=a,c=new Array(a.content.length),wmsx.Util.arrayCopy(a.content,0,c),d.bytes=c,b()}(this)},wmsx.CartridgeDiskPatchedDOS2TR.prototype=wmsx.Slot.base,wmsx.CartridgeDiskPatchedDOS2TR.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeDiskPatchedDOS2TR(null);return c.loadState(a),c},wmsx.CartridgeNextorPatched=function(a){"use strict";this.connect=function(a){d.connect(this,a),a.getDiskDriveSocket().hardDiskInterfaceConnected(this)},this.disconnect=function(a){d.disconnect(this,a),a.getDiskDriveSocket().hardDiskInterfaceDisconnected(this)},this.powerOn=function(){this.reset()},this.powerOff=function(){d.powerOff()},this.reset=function(){c=-16384},this.write=function(a,b){a>=24576&&a<26624&&(c=((7&b)<<14)-16384)},this.read=function(a){return a>=16384&&a<32768?b[c+a]:255},this.cpuExtensionBegin=function(a){return d.cpuExtensionBegin(a)},this.cpuExtensionFinish=function(a){return d.cpuExtensionFinish(a)};var b;this.bytes=null;var c;this.rom=null,this.format=wmsx.SlotFormats.Nextor16Patch;var d=new wmsx.ImageNextorDeviceDriver;this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,d:d.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),d.patchNextorKernel(b),this.bytes=b,c=a.b1,d.loadState(a.d)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,d.patchNextorKernel(b)}(this)},wmsx.CartridgeNextorPatched.prototype=wmsx.Slot.base,wmsx.CartridgeNextorPatched.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeNextorPatched;return c.loadState(a),c},wmsx.CartridgeKonamiSCC=function(rom){"use strict";function init(a){a.rom=rom,bytes=wmsx.Util.asNormalArray(rom.content),a.bytes=bytes,numBanks=bytes.length/8192|0}function connectSCC(){scc.connectAudio(),sccConnected=!0}this.connect=function(a){scc.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC()},this.disconnect=function(a){scc.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio()},this.reset=function(){bank1Offset=bank2Offset=bank3Offset=bank4Offset=-16384,sccSelected=sccConnected=!1,scc.reset()},this.write=function(a,b){return a>=20480&&a<=22527?void(bank1Offset=(b%numBanks<<13)-16384):a>=28672&&a<=30719?void(bank2Offset=(b%numBanks<<13)-24576):a>=36864&&a<=38911?(bank3Offset=(b%numBanks<<13)-32768,void(63==(63&b)?(sccSelected=!0,sccConnected||connectSCC()):sccSelected=!1)):sccSelected&&a>=38912&&a<=40959?void scc.write(a,b):void(a>=45056&&a<=47103&&(bank4Offset=(b%numBanks<<13)-40960))},this.read=function(a){switch(57344&a){case 16384:return bytes[bank1Offset+a];case 24576:return bytes[bank2Offset+a];case 32768:return a>=38912&&sccSelected?scc.read(a):bytes[bank3Offset+a];case 40960:return bytes[bank4Offset+a];default:return 255}};var bytes;this.bytes=null;var bank1Offset,bank2Offset,bank3Offset,bank4Offset,numBanks,scc=new wmsx.SCCIAudio,sccSelected=!1,sccConnected=!1;this.rom=null,this.format=wmsx.SlotFormats.KonamiSCC,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),b1:bank1Offset,b2:bank2Offset,b3:bank3Offset,b4:bank4Offset,n:numBanks,scc:scc.saveState(),scs:sccSelected,scn:sccConnected}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,bank1Offset=a.b1,bank2Offset=a.b2,bank3Offset=a.b3,bank4Offset=a.b4,numBanks=a.n,scc.loadState(a.scc),sccSelected=a.scs,(sccConnected=a.scn)&&connectSCC()},rom&&init(this),this.eval=function(arg){return eval(arg)}},wmsx.CartridgeKonamiSCC.prototype=wmsx.Slot.base,wmsx.CartridgeKonamiSCC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKonamiSCC;return c.loadState(a),c},wmsx.CartridgeSCCExpansion=function(a){"use strict";function b(){c.connectAudio(),e=!0}this.connect=function(a){c.setAudioSocket(a.getAudioSocket()),e&&b()},this.disconnect=function(a){c.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){c.disconnectAudio()},this.reset=function(){d=e=!1,c.reset()},this.write=function(a,f){if(a>=36864&&a<=38911)return void(63==(63&f)?(d=!0,e||b()):d=!1);d&&a>=38912&&a<=40959&&c.write(a,f)},this.read=function(a){return d&&a>=38912&&a<=40959?c.read(a):255};var c=new wmsx.SCCIAudio,d=!1,e=!1;this.rom=null,this.format=wmsx.SlotFormats.SCCExpansion,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),scc:c.saveState(),scs:d,scn:e}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),c.loadState(a.scc),d=a.scs,(e=a.scn)&&b()},a&&function(b){b.rom=a}(this)},wmsx.CartridgeSCCExpansion.prototype=wmsx.Slot.base,wmsx.CartridgeSCCExpansion.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSCCExpansion;return c.loadState(a),c},wmsx.CartridgeSCCIExpansion=function(rom,format,startInSCCI){"use strict";function init(a){a.rom=rom;var b=rom.content;bytes=wmsx.Util.arrayFill(new Array(131072),255),a.bytes=bytes,b.length>0&&(a.preLoadedContentSize=b.length,wmsx.Util.arrayCopy(b,0,bytes),b.length<=65536&&wmsx.Util.arrayCopy(b,0,bytes,65536)),startingMode=startInSCCI?32:0}function setMode(a){mode=a,scciMode=0!=(32&a),scc.setSCCIMode(scciMode);var b=0!=(16&a);bank4RamMode=b,bank3RamMode=b||scciMode&&0!=(4&a),bank2RamMode=b||0!=(2&a),bank1RamMode=b||0!=(1&a)}function connectSCC(){scc.connectAudio(),sccConnected=!0}this.reinsertROMContent=function(){this.rom.content||(this.rom.content=this.bytes?this.bytes.slice(0,this.preLoadedContentSize):[])},this.connect=function(a){scc.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC()},this.disconnect=function(a){scc.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio(),0===this.preLoadedContentSize&&wmsx.Util.arrayFill(bytes,255)},this.reset=function(){bank1Offset=bank2Offset=bank3Offset=bank4Offset=-16384,sccSelected=scciSelected=sccConnected=!1,scc.reset(),setMode(startingMode)},this.read=function(a){switch(57344&a){case 16384:return bytes[bank1Offset+a];case 24576:return bytes[bank2Offset+a];case 32768:return a>=38912&&sccSelected&&!scciMode?scc.read(a):bytes[bank3Offset+a];case 40960:return a>=47104&&scciSelected&&scciMode?scc.read(a):bytes[bank4Offset+a];default:return 255}},this.write=function(a,b){if(49150===a||49151===a)return void setMode(b);switch(57344&a){case 16384:return void(bank1RamMode?bytes[bank1Offset+a]=b:a>=20480&&a<=22527&&(bank1Offset=((15&b)<<13)-16384));case 24576:return void(bank2RamMode?bytes[bank2Offset+a]=b:a>=28672&&a<=30719&&(bank2Offset=((15&b)<<13)-24576));case 32768:return void(bank3RamMode?bytes[bank3Offset+a]=b:a>=36864&&a<=38911?(bank3Offset=((15&b)<<13)-32768,(sccSelected=63==(63&b))&&!sccConnected&&connectSCC()):a>=38912&&sccSelected&&!scciMode&&scc.write(a,b));case 40960:bank4RamMode?bytes[bank4Offset+a]=b:a>=45056&&a<=47103?(bank4Offset=((15&b)<<13)-40960,
(scciSelected=128==(128&b))&&!sccConnected&&connectSCC()):a>=47104&&scciSelected&&scciMode&&scc.write(a,b)}};var bytes;this.bytes=null;var startingMode=0,mode,scciMode,bank4RamMode,bank3RamMode,bank2RamMode,bank1RamMode,bank1Offset,bank2Offset,bank3Offset,bank4Offset,scc=new wmsx.SCCIAudio,sccSelected,scciSelected=!1,sccConnected=!1;this.rom=null,this.format=format,this.preLoadedContentSize=0,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),pcs:this.preLoadedContentSize,b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),sm:startingMode,m:mode,b1:bank1Offset,b2:bank2Offset,b3:bank3Offset,b4:bank4Offset,scc:scc.saveState(),scs:sccSelected,sis:scciSelected,scn:sccConnected}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),this.preLoadedContentSize=a.pcs||0,bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,bank1Offset=a.b1,bank2Offset=a.b2,bank3Offset=a.b3,bank4Offset=a.b4,startingMode=a.sm||0,setMode(void 0!==a.m?a.m:startingMode),scc.loadState(a.scc),sccSelected=a.scs,scciSelected=a.sis,(sccConnected=a.scn)&&connectSCC()},this.eval=function(str){return eval(str)},rom&&init(this)},wmsx.CartridgeSCCIExpansion.prototype=wmsx.Slot.base,wmsx.CartridgeSCCIExpansion.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSCCIExpansion;return c.loadState(a),c},wmsx.CartridgeManbow2=function(rom){"use strict";function init(a){a.rom=rom,bytes=wmsx.Util.asNormalArray(rom.content),a.bytes=bytes}function writeMem(a,b){a>=458752&&a<524288&&(bytes[a]=b,sramModif||(sramModif=!0,cartridgeSocket.fireCartridgesModifiedStateUpdate()))}function connectSCC(){scc.connectAudio(),sccConnected=!0}this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){if(65536!==b.length)return null;for(var c=0;c<65536;++c)bytes[458752+c]=b[c];return sramContentName=a,b},this.getDataToSave=function(){sramModif=!1,cartridgeSocket.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(bytes.slice(458752));return{fileName:sramContentName||"Manbow2.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return sramModif},this.connect=function(a){cartridgeSocket=a.getCartridgeSocket(),scc.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC()},this.disconnect=function(a){scc.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio()},this.reset=function(){bank1Offset=bank2Offset=bank3Offset=bank4Offset=-16384,sccSelected=sccConnected=!1,scc.reset()},this.read=function(a){switch(57344&a){case 16384:return bytes[bank1Offset+a];case 24576:return bytes[bank2Offset+a];case 32768:return sccSelected&&a>=38912?scc.read(a):bytes[bank3Offset+a];case 40960:return bytes[bank4Offset+a];default:return 255}},this.write=function(a,b){switch(57344&a){case 16384:return writeMem(bank1Offset+a,b),void(a>=20480&&a<=22527&&(bank1Offset=((b&bankSelMask)<<13)-16384));case 24576:return writeMem(bank2Offset+a,b),void(a>=28672&&a<=30719&&(bank2Offset=((b&bankSelMask)<<13)-24576));case 32768:return sccSelected&&a>=38912&&scc.write(a,b),writeMem(bank3Offset+a,b),void(a>=36864&&a<=38911&&(bank3Offset=((b&bankSelMask)<<13)-32768,(sccSelected=63==(63&b))&&!sccConnected&&connectSCC()));case 40960:writeMem(bank4Offset+a,b),a>=45056&&a<=47103&&(bank4Offset=8192*(b&bankSelMask)-40960)}};var bytes;this.bytes=null;var bank1Offset,bank2Offset,bank3Offset,bank4Offset,bankSelMask=63,scc=new wmsx.SCCIAudio,sccSelected=!1,sccConnected=!1,sramContentName,sramModif=!1,cartridgeSocket;this.rom=null,this.format=wmsx.SlotFormats.Manbow2,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),b1:bank1Offset,b2:bank2Offset,b3:bank3Offset,b4:bank4Offset,scc:scc.saveState(),scs:sccSelected,scn:sccConnected,sn:sramContentName,d:sramModif}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,bank1Offset=a.b1,bank2Offset=a.b2,bank3Offset=a.b3,bank4Offset=a.b4,scc.loadState(a.scc),sccSelected=a.scs,sccConnected=a.scn,sramContentName=a.sn,sramModif=!!a.d,sccConnected&&connectSCC()},this.eval=function(str){return eval(str)},rom&&init(this)},wmsx.CartridgeManbow2.prototype=wmsx.Slot.base,wmsx.CartridgeManbow2.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeManbow2;return c.loadState(a),c},wmsx.CartridgeKonamiUltimateCollection=function(rom){"use strict";function init(a){a.rom=rom,bytes=wmsx.Util.arrayFill(new Array(8388608),255),a.bytes=bytes,rom.content.length>0&&wmsx.Util.arrayCopy(rom.content,0,bytes)}function setSCCMode(a){sccMode=48&a,scc.setSCCIMode(0!=(32&a))}function connectSCC(){scc.connectAudio(),sccConnected=!0}function connectPCM(){pcm.connectAudio(),pcmConnected=!0}this.getDataDesc=function(){return"Flash"},this.loadData=function(a,b){return 0===b.length||b.length>8388608||0!=(8191&rom.content.length)?null:(wmsx.Util.arrayCopy(b,0,bytes),sramContentName=a,b)},this.getDataToSave=function(){sramModif=!1,cartridgeSocket.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(bytes);return{fileName:sramContentName||"KonamiUltimateCollection.dat",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return sramModif},this.connect=function(a){cartridgeSocket=a.getCartridgeSocket(),scc.setAudioSocket(a.getAudioSocket()),pcm.setAudioSocket(a.getAudioSocket()),sccConnected&&connectSCC(),pcmConnected&&connectPCM()},this.disconnect=function(a){scc.disconnectAudio(),pcm.disconnectAudio()},this.powerOn=function(){this.reset()},this.powerOff=function(){scc.disconnectAudio(),pcm.disconnectAudio(),this.reset()},this.reset=function(){mapperMode=0,banksOffset=0,addressOffset=0,bank1No=0,bank2No=1,bank3No=2,bank4No=3,sccSelected=scciSelected=sccConnected=!1,pcmConnected=!1,scc.reset(),setSCCMode(0),pcm.reset()},this.read=function(a){switch(57344&a){case 16384:return bytes[addressOffset|(bank1No+banksOffset&255)<<13|8191&a];case 24576:return bytes[addressOffset|(bank2No+banksOffset&255)<<13|8191&a];case 32768:return!(256&a)&&a>=38912&&a<40958&&sccSelected&&0===sccMode?scc.read(a):bytes[addressOffset|(bank3No+banksOffset&255)<<13|8191&a];case 40960:return!(256&a)&&a>=47104&&a<49150&&scciSelected&&32===sccMode?scc.read(a):bytes[addressOffset|(bank4No+banksOffset&255)<<13|8191&a];default:return 255}},this.write=function(a,b){if(!(256&a)&&(0===sccMode&&a>=38912&&a<40958&&sccSelected||32===sccMode&&a>=47104&&a<49150&&scciSelected))return scc.write(a,b);if(4&mapperMode||(32767===a?(mapperMode=b,addressOffset=(192&b)<<15):32766===a&&(banksOffset=b)),16&mapperMode)switch(57344&a){case 16384:bytes[addressOffset|(bank1No+banksOffset&255)<<13|8191&a]=b,sramModif=!0;break;case 24576:bytes[addressOffset|(bank2No+banksOffset&255)<<13|8191&a]=b,sramModif=!0;break;case 32768:bytes[addressOffset|(bank3No+banksOffset&255)<<13|8191&a]=b,sramModif=!0;break;case 40960:bytes[addressOffset|(bank4No+banksOffset&255)<<13|8191&a]=b,sramModif=!0}if(8&mapperMode&&16384==(49168&a)&&(pcmConnected||connectPCM(),pcm.setSampleValue(b)),!(2&mapperMode)){if(32&mapperMode)switch(57344&a){case 16384:!(8&mapperMode)&&a>=20480&&a<=22527&&(bank1No=b);break;case 24576:bank2No=b;break;case 32768:bank3No=b,sccSelected=63==(63&b);break;case 40960:bank4No=b,scciSelected=128==(128&b)}else switch(57344&a){case 16384:a>=20480&&a<=22527&&(bank1No=b);break;case 24576:a>=28672&&a<=30719&&(bank2No=b);break;case 32768:a>=36864&&a<=38911&&(bank3No=b,sccSelected=63==(63&b));break;case 40960:a>=45056&&a<=47103&&(bank4No=b,scciSelected=128==(128&b))}49150!==a&&49151!==a||setSCCMode(b),!sccSelected&&!scciSelected||sccConnected||connectSCC()}};var cartridgeSocket,bytes;this.bytes=null
;var mapperMode=0,banksOffset=0,addressOffset=0,bank1No=0,bank2No=1,bank3No=2,bank4No=3,scc=new wmsx.SCCIAudio,sccMode=0,sccSelected=!1,scciSelected=!1,sccConnected=!1,pcm=new wmsx.PCM8BitAudio,pcmConnected=!1,sramContentName,sramModif=!1;this.rom=null,this.format=wmsx.SlotFormats.KonamiUltimateCollection,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(bytes),mm:mapperMode,bo:banksOffset,ao:addressOffset,b1:bank1No,b2:bank2No,b3:bank3No,b4:bank4No,scm:sccMode,scc:scc.saveState(),scs:sccSelected,sis:scciSelected,scn:sccConnected,pcm:pcm.saveState(),pcn:pcmConnected}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),bytes=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,bytes),this.bytes=bytes,mapperMode=a.mm,banksOffset=a.bo,addressOffset=a.ao,bank1No=a.b1,bank2No=a.b2,bank3No=a.b3,bank4No=a.b4,setSCCMode(a.scm),scc.loadState(a.scc),sccSelected=a.scs,scciSelected=a.sis,sccConnected=a.scn,pcm.loadState(a.pcm),pcmConnected=a.pcn,sccConnected&&connectSCC(),pcmConnected&&connectPCM()},this.eval=function(str){return eval(str)},rom&&init(this)},wmsx.CartridgeKonamiUltimateCollection.prototype=wmsx.Slot.base,wmsx.CartridgeKonamiUltimateCollection.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKonamiUltimateCollection;return c.loadState(a),c},wmsx.CartridgeKanjiFont=function(a){"use strict";var b=this;this.connect=function(a){a.bus.connectInputDevice(216,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectInputDevice(217,this.inputD9),a.bus.connectOutputDevice(216,this.outputD8),a.bus.connectOutputDevice(217,this.outputD9),a.bus.connectInputDevice(218,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectInputDevice(219,this.inputDB),a.bus.connectOutputDevice(218,this.outputDA),a.bus.connectOutputDevice(219,this.outputDB),wmsx.CartridgeKanjiFont.connectedInstance=this},this.disconnect=function(a){a.bus.disconnectInputDevice(216,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectInputDevice(217,this.inputD9),a.bus.disconnectOutputDevice(216,this.outputD8),a.bus.disconnectOutputDevice(217,this.outputD9),a.bus.disconnectInputDevice(218,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectInputDevice(219,this.inputDB),a.bus.disconnectOutputDevice(218,this.outputDA),a.bus.disconnectOutputDevice(219,this.outputDB),wmsx.CartridgeKanjiFont.connectedInstance===this&&(wmsx.CartridgeKanjiFont.connectedInstance=void 0)},this.powerOn=function(){this.reset()},this.powerOff=function(){},this.readKanji=function(a){return f||a<131072?c[a]:255},this.reset=function(){d=0,e=131072},this.read=function(a){return 255},this.write=function(a,b){},this.outputD8=function(a){d=129024&d|(63&a)<<5},this.outputD9=function(a){d=(63&a)<<11|2016&d},this.inputD9=function(){var a=b.readKanji(d);return d=131040&d|d+1&31,a},this.outputDA=function(a){e=260096&e|(63&a)<<5},this.outputDB=function(a){e=131072|(63&a)<<11|2016&e},this.inputDB=function(){var a=b.readKanji(e);return e=262112&e|e+1&31,a};var c,d=0,e=0,f=!1;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.Kanji1,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(c),r1:d,r2:e,j2:f}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c):(this.rom.reloadEmbeddedContent(),c&&c.length===this.rom.content.length||(c=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,c)),this.bytes=c,d=a.r1,e=131072|a.r2,f=a.j2},a&&function(b){b.rom=a,c=wmsx.Util.asNormalArray(a.content),b.bytes=c,f=262144===c.length}(this)},wmsx.CartridgeKanjiFont.prototype=wmsx.Slot.base,wmsx.CartridgeKanjiFont.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeKanjiFont;return c.loadState(a),c},wmsx.CartridgeKanjiFont.connectedInstance=void 0,wmsx.CartridgePAC=function(a){"use strict";function b(a,b){e=a;for(var d=wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length,f=0,g=c.length-2;f<g;f++)c[f]=b[d+f]}this.connect=function(a){f=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,d){return wmsx.CartridgePAC.isPACFileContentValid(d)?(b(a,d),c):null},this.getDataToSave=function(){g=!1,f.fireCartridgesModifiedStateUpdate();var a=wmsx.CartridgePAC.buildPACFileContentToSave(c);return{fileName:e||"PAC SRAM.pac",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return g},this.powerOn=function(){this.reset()},this.reset=function(){d=!1},this.write=function(a,b){if(24574===a||24575===a)return c[a-16384]=b,void(d=77===c[8190]&&105===c[8191]);d&&a>=16384&&a<=24573&&(c[a-16384]=b,g||(g=!0,f.fireCartridgesModifiedStateUpdate()))},this.read=function(a){return d&&a>=16384&&a<=24575?c[a-16384]:255};var c,d;this.sram=null;var e,f,g=!1;this.rom=null,this.format=wmsx.SlotFormats.PACExpansion,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),sa:d,s:wmsx.Util.compressInt8BitArrayToStringBase64(c),sn:e,d:g}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),d=a.sa,c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,c),e=a.sn,g=!!a.d},a&&function(d){d.rom=a,c=wmsx.Util.arrayFill(new Array(8192),0),d.sram=c,0!==a.content.length&&b(a.source,a.content)}(this)},wmsx.CartridgePAC.prototype=wmsx.Slot.base,wmsx.CartridgePAC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgePAC;return c.loadState(a),c},wmsx.CartridgePAC.isPACFileContentValid=function(a){return 8206===a.length&&wmsx.Util.int8BitArrayToByteString(a,0,wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length)==wmsx.CartridgePAC.DATA_FILE_IDENTIFIER},wmsx.CartridgePAC.buildPACFileContentToSave=function(a){var b=new Uint8Array(wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length+a.length-2);return b.set(wmsx.Util.byteStringToInt8BitArray(wmsx.CartridgePAC.DATA_FILE_IDENTIFIER)),b.set(a.slice(0,-2),wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length),b},wmsx.CartridgePAC.DATA_FILE_IDENTIFIER="PAC2 BACKUP DATA",wmsx.CartridgeMSXMUSIC=function(a){"use strict";this.connect=function(a){c.connect(a)},this.disconnect=function(a){c.disconnect(a)},this.powerOn=function(){c.powerOn(),this.reset()},this.powerOff=function(){c.powerOff()},this.reset=function(){c.reset()},this.read=function(a){return a>=16384&&a<32768?b[a-16384]:255};var b;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.MSXMUSIC;var c=new wmsx.YM2413Audio("MSX-MUSIC");this.opll=c,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),fm:c.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,c.loadState(a.fm)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b}(this)},wmsx.CartridgeMSXMUSIC.prototype=wmsx.Slot.base,wmsx.CartridgeMSXMUSIC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMSXMUSIC;return c.loadState(a),c},wmsx.CartridgeFMPAC=function(a){"use strict";function b(){k&&(1&i?m.connect(k):m.disconnect(k))}function c(a,b){g=a;for(var c=wmsx.CartridgePAC.DATA_FILE_IDENTIFIER.length,d=0,f=e.length-2;d<f;d++)e[d]=b[c+d]}this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){return wmsx.CartridgePAC.isPACFileContentValid(b)?(c(a,b),e):null},this.getDataToSave=function(){l=!1,h.fireCartridgesModifiedStateUpdate();var a=wmsx.CartridgePAC.buildPACFileContentToSave(e);return{fileName:g||"PAC SRAM.pac",content:a,desc:this.getDataDesc()}},this.connect=function(a){k=a,h=k.getCartridgeSocket(),b()},this.disconnect=function(a){m.disconnect(a)},this.dataModified=function(){return l},this.powerOn=function(){m.powerOn(),this.reset()},
this.powerOff=function(){m.powerOff()},this.reset=function(){f=!1,j=-16384,i=0,b(),m.reset()},this.write=function(a,c){switch(a){case 32756:m.output7C(c);break;case 32757:m.output7D(c);break;case 32758:i=17&c,b();break;case 32759:j=((3&c)<<14)-16384;break;case 24574:case 24575:e[a-16384]=c,f=77===e[8190]&&105===e[8191]}f&&a>=16384&&a<=24573&&(e[a-16384]=c,l||(l=!0,h.fireCartridgesModifiedStateUpdate()))},this.read=function(a){return 32758===a?i:32759===a?j+16384>>14:f?a>=16384&&a<=24575?e[a-16384]:255:a>=16384&&a<32768?d[j+a]:255};var d;this.bytes=null;var e,f;this.sram=null;var g,h,i,j,k,l=!1;this.rom=null,this.format=wmsx.SlotFormats.FMPAC;var m=new wmsx.YM2413Audio("FM-PAC");this.opll=m,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(d),b1:j,fe:i,sa:f,s:wmsx.Util.compressInt8BitArrayToStringBase64(e),sn:g,fm:m.saveState(),d:l}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),d=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,d),this.bytes=d,j=a.b1,i=a.fe,f=a.sa,e=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,e),g=a.sn,m.loadState(a.fm),l=!!a.d,b()},a&&function(b){b.rom=a,d=wmsx.Util.asNormalArray(a.content),b.bytes=d,e=wmsx.Util.arrayFill(new Array(8192),0),b.sram=e}(this)},wmsx.CartridgeFMPAC.prototype=wmsx.Slot.base,wmsx.CartridgeFMPAC.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeFMPAC;return c.loadState(a),c},wmsx.CartridgeOPL4=function(a){"use strict";this.connect=function(a){c.connect(a)},this.disconnect=function(a){c.disconnect(a)},this.powerOn=function(){c.powerOn(),this.reset()},this.powerOff=function(){c.powerOff()},this.reset=function(){c.reset()},this.opl4ReadMemory=function(a){return b[4194303&a]},this.opl4WriteMemory=function(a,c){(4194303&a)<2097152||(b[4194303&a]=c)};var b;this.bytes=null,this.rom=null,this.format=wmsx.SlotFormats.OPL4;var c=new wmsx.OPL4Audio("OPL4",this);this.opl4=c,this.saveState=function(){var a=this.lightState();return{f:this.format.name,r:this.rom.saveState(),b:a?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),ra:a?wmsx.Util.compressInt8BitArrayToStringBase64(b,2097152,2097152):null,opl4:c.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b||(b=new Array(4194304)),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.ra,b,!0,null,2097152),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,c.loadState(a.opl4)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content,0,4194304),wmsx.Util.arrayFill(b,0,2097152),c.bytes=b}(this)},wmsx.CartridgeOPL4.prototype=wmsx.Slot.base,wmsx.CartridgeOPL4.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeOPL4;return c.loadState(a),c},wmsx.CartridgeExtraPSG=function(a){"use strict";this.connect=function(a){b.setAudioSocket(a.getAudioSocket()),b.connectBus(a.bus)},this.disconnect=function(a){b.disconnectBus(a.bus)},this.powerOn=function(){b.powerOn()},this.powerOff=function(){b.powerOff()},this.reset=function(){b.reset()};var b=new wmsx.PSG(null,null,!0);this.rom=null,this.format=wmsx.SlotFormats.ExtraPSG,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),p:b.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b.loadState(a.p)},a&&function(b){b.rom=a}(this)},wmsx.CartridgeExtraPSG.prototype=wmsx.Slot.base,wmsx.CartridgeExtraPSG.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeExtraPSG;return c.loadState(a),c},wmsx.CartridgeV9990=function(a){"use strict";function b(){switch(26&e){case 16:case 18:f=0;break;case 24:f=2;break;case 26:f=3;break;default:f=1}d.getVideoSignal().setOutputAutoMode(f)}var c=this;this.connect=function(a){d.connect(a,this),a.getVideoSocket().connectExternalVideoSignal(d.getVideoSignal()),a.bus.connectInputDevice(111,wmsx.DeviceMissing.inputPortIgnored),a.bus.connectOutputDevice(111,this.output6f)},this.disconnect=function(a){d.disconnect(a),a.getVideoSocket().disconnectExternalVideoSignal(d.getVideoSignal()),a.bus.disconnectInputDevice(111,wmsx.DeviceMissing.inputPortIgnored),a.bus.disconnectOutputDevice(111,this.output6f)},this.powerOn=function(){d.powerOn()},this.powerOff=function(){d.powerOff(),this.resetOutputAutoMode()},this.reset=function(){d.reset(),this.resetOutputAutoMode()},this.resetOutputAutoMode=function(){c.output6f(16)},this.v9990DisplayEnabled=function(){0===f&&this.output6f(0)},this.output6f=function(a){e=a,b()},this.rom=null,this.format=wmsx.SlotFormats.V9990;var d=new wmsx.V9990;this.v9990=d;var e=16,f=0;this.saveState=function(){this.lightState();return{f:this.format.name,r:this.rom.saveState(),c:e,vdp:d.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),e=a.c,d.loadState(a.vdp),b()},a&&function(){c.rom=a}()},wmsx.CartridgeV9990.prototype=wmsx.Slot.base,wmsx.CartridgeV9990.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeV9990;return c.loadState(a),c},wmsx.CartridgeGameMaster2=function(a){"use strict";this.connect=function(a){h=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){if(8192!==b.length)return null;for(var c=0;c<8192;++c)f[c]=b[c];return g=a,b},this.getDataToSave=function(){i=!1,h.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(f);return{fileName:g||"GameMaster2.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return i},this.powerOn=function(){this.reset()},this.reset=function(){c=1,d=2,e=3},this.write=function(a,b){if(!(a<24576||a>=49152))return a<28672?void(c=b):a>=32768&&a<36864?void(d=b):a>=40960&&a<45056?void(e=b):void(a>=45056&&16&e&&(f[((32&e)<<7)+a-45056]=b,i||(i=!0,h.fireCartridgesModifiedStateUpdate())))},this.read=function(a){switch(57344&a){case 16384:return b[a-16384];case 24576:return 16&c?f[((32&c)<<7)+(a-24576&4095)]:b[((15&c)<<13)+a-24576];case 32768:return 16&d?f[((32&d)<<7)+(a-32768&4095)]:b[((15&d)<<13)+a-32768];case 40960:return 16&e?f[((32&e)<<7)+(a-40960&4095)]:b[((15&e)<<13)+a-40960];default:return 255}};var b;this.bytes=null;var c,d,e,f;this.sram=null;var g,h,i=!1;this.rom=null,this.format=wmsx.SlotFormats.GameMaster2,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c,b3:d,b4:e,s:wmsx.Util.compressInt8BitArrayToStringBase64(f),sn:g,d:i}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=a.b3,e=a.b4,f=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,f),this.sram=f,g=a.sn,i=!!a.d},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,f=wmsx.Util.arrayFill(new Array(8192),0),c.sram=f}(this)},wmsx.CartridgeGameMaster2.prototype=wmsx.Slot.base,wmsx.CartridgeGameMaster2.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeGameMaster2;return c.loadState(a),c},wmsx.CartridgeASCII8KSRAM=function(a,b){"use strict";this.connect=function(a){n=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){var c=l+1;if(b.length!==c)return null;for(var d=0;d<c;++d)k[d]=b[d];return m=a,b},this.getDataToSave=function(){o=!1,n.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(k);return{fileName:m||"Data.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return o},this.powerOn=function(){this.reset()},this.reset=function(){d=e=f=g=0},this.write=function(a,b){if(!(a<16384||a>=49152))return a<24576?void(p&&d&j&&(k[((3&d)<<13)+a-16384&l]=b,o||(o=!0,n.fireCartridgesModifiedStateUpdate()))):a<26624?void(d=b):a<28672?void(e=b):a<30720?void(f=b):a<32768?void(g=b):a<40960?void(f&j&&(k[((3&f)<<13)+a-32768&l]=b,o||(o=!0,n.fireCartridgesModifiedStateUpdate()))):void(g&j&&(k[((3&g)<<13)+a-40960&l]=b,o||(o=!0,n.fireCartridgesModifiedStateUpdate())))},this.read=function(a){
switch(57344&a){case 16384:return p&&d&j?k[((3&d)<<13)+a-16384&l]:c[((d&i)%h<<13)+a-16384];case 24576:return 0|c[((e&i)%h<<13)+a-24576];case 32768:return f&j?k[((3&f)<<13)+a-32768&l]:c[((f&i)%h<<13)+a-32768];case 40960:return g&j?k[((3&g)<<13)+a-40960&l]:c[((g&i)%h<<13)+a-40960];default:return 255}};var c;this.bytes=null;var d,e,f,g,h,i,j,k;this.sram=null;var l,m,n,o=!1,p=!1;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c),b1:d,b2:e,b3:f,b4:g,n:h,rsm:i,s:wmsx.Util.compressInt8BitArrayToStringBase64(k),sn:m,ssm:j,d:o}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=a.b1,e=a.b2,f=a.b3,g=a.b4,h=a.n,i=a.rsm,p=this.format===wmsx.SlotFormats.KoeiSRAM8||this.format===wmsx.SlotFormats.KoeiSRAM32,k=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,k),this.sram=k,l=k.length-1,m=a.sn,j=a.ssm,o=!!a.d},a&&function(d){d.rom=a,c=wmsx.Util.asNormalArray(a.content),d.bytes=c,h=c.length/8192|0;var e=b===wmsx.SlotFormats.KoeiSRAM32?32768:b===wmsx.SlotFormats.ASCII8SRAM2?2048:8192;l=e-1,k=wmsx.Util.arrayFill(new Array(e),0),d.sram=k;var f=1<<Math.ceil(wmsx.Util.log2(h));i=f-1,j=b===wmsx.SlotFormats.Wizardry?128:Math.max(32,f),p=b===wmsx.SlotFormats.KoeiSRAM8||b===wmsx.SlotFormats.KoeiSRAM32}(this)};wmsx.CartridgeASCII8KSRAM.prototype=wmsx.Slot.base,wmsx.CartridgeASCII8KSRAM.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII8KSRAM;return c.loadState(a),c},wmsx.CartridgeASCII16KSRAM=function(a,b){"use strict";this.connect=function(a){l=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){var c=j+1;if(b.length!==c)return null;for(var d=0;d<c;++d)i[d]=b[d];return k=a,b},this.getDataToSave=function(){m=!1,l.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(i);return{fileName:k||"Data.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return m},this.powerOn=function(){this.reset()},this.reset=function(){d=e=0},this.write=function(a,b){return a>=24576&&a<26624?void(d=b):a>=28672&&a<30720?void(e=b):void(a>=32768&&a<49152&&e&h&&(i[a-32768&j]=b,m||(m=!0,l.fireCartridgesModifiedStateUpdate())))},this.read=function(a){switch(49152&a){case 16384:return d&h?i[a-16384&j]:c[((d&g)%f<<14)+a-16384];case 32768:return e&h?i[a-32768&j]:c[((e&g)%f<<14)+a-32768];default:return 255}};var c;this.bytes=null;var d,e,f,g,h,i;this.sram=null;var j,k,l,m=!1;this.rom=null,this.format=b,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(c),b1:d,b2:e,n:f,rsm:g,s:wmsx.Util.compressInt8BitArrayToStringBase64(i),sn:k,ssm:h,d:m}},this.loadState=function(a){this.format=wmsx.SlotFormats[a.f],this.rom=wmsx.ROM.loadState(a.r),c=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,c),this.bytes=c,d=a.b1,e=a.b2,f=a.n,g=a.rsm,i=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,i),this.sram=i,j=i.length-1,k=a.sn,h=a.ssm,m=!!a.d},a&&function(d){d.rom=a,c=wmsx.Util.asNormalArray(a.content),d.bytes=c,f=c.length/16384|0;var e=b===wmsx.SlotFormats.ASCII16SRAM2?2048:8192;j=e-1,i=wmsx.Util.arrayFill(new Array(e),0),d.sram=i;var k=1<<Math.ceil(wmsx.Util.log2(f));g=k-1,h=Math.max(16,k)}(this)},wmsx.CartridgeASCII16KSRAM.prototype=wmsx.Slot.base,wmsx.CartridgeASCII16KSRAM.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeASCII16KSRAM;return c.loadState(a),c},wmsx.CartridgeHalnote=function(a){"use strict";this.connect=function(a){m=a.getCartridgeSocket()},this.getDataDesc=function(){return"SRAM"},this.loadData=function(a,b){if(16384!==b.length)return null;for(var c=0;c<16384;++c)j[c]=b[c];return l=a,b},this.getDataToSave=function(){n=!1,m.fireCartridgesModifiedStateUpdate();var a=new Uint8Array(j);return{fileName:l||"Halnote.sram",content:a,desc:this.getDataDesc()}},this.dataModified=function(){return n},this.powerOn=function(){this.reset()},this.reset=function(){c=-16384,d=-24576,e=-32768,f=-40960,g=495616,h=493568,i=k=!1},this.write=function(a,b){switch(a){case 20479:return c=((127&b)<<13)-16384,void(k=0!=(128&b));case 28671:return d=((127&b)<<13)-24576,void(i=0!=(128&b));case 36863:return void(e=((127&b)<<13)-32768);case 45055:return void(f=((127&b)<<13)-40960);case 30719:return void(g=(b<<11)-28672+524288);case 32767:return void(h=(b<<11)-30720+524288)}k&&a<16384&&(n||j[a]===b||(n=!0,m.fireCartridgesModifiedStateUpdate()),j[a]=b)},this.read=function(a){switch(57344&a){case 0:case 8192:return k?j[a]:255;case 16384:return b[c+a];case 24576:return a>=28672&&i?b[(a<30720?g:h)+a]:b[d+a];case 32768:return b[e+a];case 40960:return b[f+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g,h,i,j;this.sram=null;var k,l,m,n=!1;this.rom=null,this.format=wmsx.SlotFormats.Halnote,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:this.lightState()?null:wmsx.Util.compressInt8BitArrayToStringBase64(b),b1:c,b2:d,b3:e,b4:f,sb1:g,sb2:h,sbe:i,s:wmsx.Util.compressInt8BitArrayToStringBase64(j),se:k,sn:l,d:n}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),a.b?b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b):(this.rom.reloadEmbeddedContent(),b&&b.length===this.rom.content.length||(b=new Array(this.rom.content.length)),wmsx.Util.arrayCopy(this.rom.content,0,b)),this.bytes=b,c=a.b1,d=a.b2,e=a.b3,f=a.b4,g=a.sb1,h=a.sb2,i=a.sbe,j=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.s,j),this.sram=j,k=a.se,l=a.sn,n=!!a.d},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,j=wmsx.Util.arrayFill(new Array(16384),0),c.sram=j}(this)},wmsx.CartridgeHalnote.prototype=wmsx.Slot.base,wmsx.CartridgeHalnote.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeHalnote;return c.loadState(a),c},wmsx.CartridgeMajutsushi=function(a){"use strict";this.connect=function(a){g.setAudioSocket(a.getAudioSocket()),g.connectAudio()},this.disconnect=function(a){g.disconnectAudio()},this.powerOn=function(){this.reset(),g.connectAudio()},this.powerOff=function(){g.disconnectAudio(),this.reset()},this.reset=function(){c=d=e=-16384,g.reset()},this.write=function(a,b){a>=20480&&a<24575?g.setSampleValue(b):a>=24576&&a<32767?c=(b%f<<13)-24576:a>=32768&&a<40959?d=(b%f<<13)-32768:a>=40960&&a<49151&&(e=(b%f<<13)-40960)},this.read=function(a){switch(57344&a){case 16384:return b[a-16384];case 24576:return b[c+a];case 32768:return b[d+a];case 40960:return b[e+a];default:return 255}};var b;this.bytes=null;var c,d,e,f,g=new wmsx.PCM8BitAudio;this.rom=null,this.format=wmsx.SlotFormats.Majutsushi,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),b:wmsx.Util.compressInt8BitArrayToStringBase64(b),b2:c,b3:d,b4:e,n:f,p:g.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c=a.b2,d=a.b3,e=a.b4,f=a.n,g.loadState(a.p)},a&&function(c){c.rom=a,b=wmsx.Util.asNormalArray(a.content),c.bytes=b,f=b.length/8192|0}(this)},wmsx.CartridgeMajutsushi.prototype=wmsx.Slot.base,wmsx.CartridgeMajutsushi.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeMajutsushi;return c.loadState(a),c},wmsx.CartridgeSynthesizer=function(a){"use strict";this.connect=function(a){c.setAudioSocket(a.getAudioSocket()),c.connectAudio()},this.disconnect=function(a){c.disconnectAudio()},this.powerOn=function(){this.reset(),c.connectAudio()},this.powerOff=function(){c.disconnectAudio(),this.reset()},this.reset=function(){c.reset()},this.write=function(a,b){16384==(49168&a)&&c.setSampleValue(b)},this.read=function(a){return a>=16384&&a<49152?b[a-16384]:255};var b;this.bytes=null;var c=new wmsx.PCM8BitAudio;this.rom=null,this.format=wmsx.SlotFormats.Synthesizer,this.saveState=function(){return{f:this.format.name,r:this.rom.saveState(),
b:wmsx.Util.compressInt8BitArrayToStringBase64(b),p:c.saveState()}},this.loadState=function(a){this.rom=wmsx.ROM.loadState(a.r),b=wmsx.Util.uncompressStringBase64ToInt8BitArray(a.b,b),this.bytes=b,c.loadState(a.p)},a&&function(c){c.rom=a,b=wmsx.Util.arrayFill(new Array(32768),255),c.bytes=b;for(var d=a.content.length,e=0;e<32768;++e)b[e]=a.content[e%d]}(this)},wmsx.CartridgeSynthesizer.prototype=wmsx.Slot.base,wmsx.CartridgeSynthesizer.recreateFromSaveState=function(a,b){var c=b||new wmsx.CartridgeSynthesizer;return c.loadState(a),c},wmsx.MachineTypeSocket=function(a){"use strict";this.getMachine=function(){return a.machineName},this.getMachineLang=function(){return WMSX.MACHINES_CONFIG[a.machineName].LANG||"en"},this.getMachineType=function(){return WMSX.MACHINES_CONFIG[a.machineName].TYPE||1},this.getCodeKeyLabel=function(){return WMSX.MACHINES_CONFIG[a.machineName].CODE_LABEL||"CODE"},this.getCodeLedLabel=function(){return WMSX.MACHINES_CONFIG[a.machineName].CODE_LABEL||"KANA"},this.changeMachine=function(b){if(a.machineName!==b){if(WMSX.MEDIA_CHANGE_DISABLED)return b.showOSD("Machine change is disabled!",!0,!0);var c=WMSX.MACHINES_CONFIG[b];if(c){var d=a.powerIsOn;a.powerOff();var e=a.systemPause(!0);WMSX.MACHINE=b,wmsx.Configurator.applyFinalConfig(),a.updateMachineType(),new wmsx.MultiDownloader(wmsx.Configurator.slotURLSpecs(),function(){a.getExtensionsSocket().propagateAllExtensions(),a.getExtensionsSocket().refreshSlotsFromConfig(function(){a.getSavestateSocket().externalStateChange(),a.showOSD((c.DESC||c.DESCX)+" machine activated",!0),e||a.systemPause(!1),d&&a.powerOn()})},function(a){wmsx.Util.message(a.errorMessage)}).start()}}},this.addMachineTypeStateListener=function(a,c){b.indexOf(a)<0&&(b.push(a),c||a.machineTypeStateUpdate())},this.fireMachineTypeStateUpdate=function(){for(var a=0;a<b.length;++a)b[a].machineTypeStateUpdate()};var b=[]},wmsx.ExtensionsSocket=function(a){"use strict";function b(a,b,d,f){g[a]&&(d=d&&!!g[a].SLOT2,e.isActiveOnConf(a,d)!==b&&(WMSX.EXTENSIONS[a]^=d?2:1,f||c(a,b,d)))}function c(a,c,d){var f=g[a];if(f.MUTUAL&&b(f.MUTUAL,!c,d,!0),c){if(f.BOUND)for(h in f.BOUND)b(f.BOUND[h],!0,d,!0);if(f.TOGGLE&&(h=f.TOGGLE,e.isActiveOnConf(h,d)&&(b(h,!1,d,!0),e.isActiveOnConf(a,!d)||b(h,!0,!d,!0))),f.CHANGE)for(var h in f.CHANGE)b(h,!!f.CHANGE[h],d,!0)}else if(f.BOUND)for(h in f.BOUND)b(f.BOUND[h],!1,d,!0)}function d(a,b){return{url:g[a].URL||"@[Empty].rom",onSuccess:function(c){f.loadFromContentAsSlot(c.url,c.content,b?g[a].SLOT2:g[a].SLOT,!0,null,null,!0)}}}var e=this;this.connectFileLoader=function(a){f=a},this.addExtensionsAndCartridgesStateListener=function(b){a.getCartridgeSocket().addCartridgesStateListener(this,!0),i.indexOf(b)<0&&(i.push(b),b.extensionsAndCartridgesStateUpdate())},this.cartridgesStateUpdate=function(){this.refreshConfigFromSlots(),this.fireExtensionsAndCartridgesStateUpdate()},this.configurationStateUpdate=function(){g=WMSX.EXTENSIONS_CONFIG},this.isActiveOnConf=function(a,b){if(!g[a])return!1;var c=g[a].SLOT2&&b?2:1;return 0!=(WMSX.EXTENSIONS[a]&c)},this.isActiveOnSlot=function(a,b){var c=g[a];if(!c)return!1;var d=!!c.SLOT2,e=h.slotInserted(b&&d?c.SLOT2:c.SLOT);return!!e&&e.rom.source===c.URL},this.activateExtension=function(a,b,c,d,e){this.isActiveOnSlot(a,c)||this.toggleExtension(a,b,c,d,e)},this.toggleExtension=function(c,d,e,f,h){var i=g[c];if(i){var j=!!i.SLOT2,k=j&&!i.TOGGLE;e=e&&j;var l=0;switch(WMSX.EXTENSIONS[c]||0){case 0:l=e?2:1;break;case 1:l=e?k?3:2:0;break;case 2:l=e?0:k?3:1;break;case 3:l=e?1:2}j?0==(1&l)?(b(c,!1,!1),b(c,0!=(2&l),!0)):(b(c,0!=(2&l),!0),b(c,!0,!1)):b(c,0!=(1&l),!1);var m=a.powerIsOn;!d&&m&&a.powerOff();var n=a.systemPause(!0);this.refreshSlotsFromConfig(function(b){if(h||a.getSavestateSocket().externalStateChange(),n||a.systemPause(!1),!d&&m&&a.userPowerOn(!1),b&&!f){var c=a.getSlotSocket().getSlotDesc(2&l?i.SLOT2:i.SLOT),e=i.DESC+" Extension "+(l?"enabled"+(3===l?" at both slots":c?" at slot "+c:""):"disabled");a.showOSD(e,!0),wmsx.Util.log(e)}})}},this.getInitialLoaderURLSpecs=function(){this.propagateAllExtensions();var a=[];for(var b in g)1&WMSX.EXTENSIONS[b]&&a.push(d(b,!1)),g[b].SLOT2&&2&WMSX.EXTENSIONS[b]&&a.push(d(b,!0));return a},this.fireExtensionsAndCartridgesStateUpdate=function(){for(var a=0;a<i.length;++a)i[a].extensionsAndCartridgesStateUpdate()},this.refreshSlotsFromConfig=function(a){var b=[],c=[];for(var f in g){var i=g[f];1&WMSX.EXTENSIONS[f]?e.isActiveOnSlot(f,!1)||b.push(d(f,!1)):e.isActiveOnSlot(f,!1)&&c.push(i.SLOT),i.SLOT2&&(2&WMSX.EXTENSIONS[f]?e.isActiveOnSlot(f,!0)||b.push(d(f,!0)):e.isActiveOnSlot(f,!0)&&c.push(i.SLOT2))}if(0===b.length&&0===c.length)return e.fireExtensionsAndCartridgesStateUpdate(),a(!1);for(var j=0;j<c.length;++j)h.insertSlot(null,c[j],!0,!0);new wmsx.MultiDownloader(b,function(){e.fireExtensionsAndCartridgesStateUpdate(),a(!0)},function(a){wmsx.Util.message(a.errorMessage)}).start()},this.refreshConfigFromSlots=function(){for(var a in g){var b=e.isActiveOnSlot(a,!1)?1:0;b|=g[a].SLOT2&&e.isActiveOnSlot(a,!0)?2:0,WMSX.EXTENSIONS[a]=b}},this.propagateAllExtensions=function(){for(var a in g)c(a,0!=(1&WMSX.EXTENSIONS[a]),!1),g[a].SLOT2&&c(a,0!=(2&WMSX.EXTENSIONS[a]),!0)};var f,g=WMSX.EXTENSIONS_CONFIG,h=a.getSlotSocket(),i=[];!function(){wmsx.Configurator.addConfigurationStateListener(e)}()},wmsx.DeviceMissing={inputPort:function(a){return 255},outputPort:function(a,b){},inputPortIgnored:function(a){return 255},outputPortIgnored:function(a,b){},IGNORED_PORTS:new Set([128,129,130,131,132,133,134,135,144,145,147,164,165,184,185,186,187,192,193,194,195,200,201,202,203,204,205,206,207,220,221,232,233,234,235,236,237,238,239]),setDebugMode:function(a){}},wmsx.SwitchedDevices=function(){"use strict";this.connect=function(a){a.connectInputDevice(64,this.input40),a.connectOutputDevice(64,this.output40);for(var b=65;b<=79;++b)a.connectInputDevice(b,this.inputPort),a.connectOutputDevice(b,this.outputPort)},this.reset=function(){b=0},this.connectSwitchedDevice=function(b,c){c&&(a[b]=c)},this.disconnectSwitchedDevice=function(c,d){a[c]===d&&(a[c]=void 0,b===c&&(b=0))},this.input40=function(){return 255&~b},this.output40=function(c){b=a[c]?c:0},this.inputPort=function(c){return b?a[b].switchedPortInput(255&c):255},this.outputPort=function(c,d){b&&a[b].switchedPortOutput(c,255&d)};var a=new Array(256),b=0},wmsx.BUS=function(machine,cpu){"use strict";function init(){create()}function getSlotForAddress(a){var b=primarySlotConfig>>(a>>14<<1)&3;return 0===b?slot0:1===b?slot1:2===b?slot2:slot3}function create(){slot0=slot1=slot2=slot3=slotModules=slotEmpty,slots=[slot0,slot1,slot2,slot3,slotModules],devicesInputPorts=wmsx.Util.arrayFill(new Array(256),deviceInputMissing),devicesOutputPorts=wmsx.Util.arrayFill(new Array(256),deviceOutputMissing),switchedDevices=new wmsx.SwitchedDevices,switchedDevices.connect(self),self.slots=slots,self.devicesInputPorts=devicesInputPorts,self.devicesOutputPorts=devicesOutputPorts}var self=this;this.powerOn=function(){switchedDevices.reset(),this.setPrimarySlotConfig(0);for(var a=0;a<5;a++)slots[a].powerOn()},this.powerOff=function(){for(var a=0;a<5;a++)slots[a].powerOff()},this.reset=function(){vdpIOClock=0,switchedDevices.reset(),this.setDRAMMode(!1),this.setPrimarySlotConfig(0);for(var a=0;a<5;a++)slots[a].reset()},this.refreshConnect=function(){for(var a=0;a<5;++a)slots[a].refreshConnect()},this.insertSlot=function(a,b){if(a=a||slotEmpty,slots[b]!==a)switch(slots[b].disconnect(machine),slots[b]=a,slots[b].connect(machine),b){case 0:return void(slot0=a);case 1:return void(slot1=a);case 2:return void(slot2=a);case 3:return void(slot3=a);case 4:return void(slotModules=a)}},this.getSlot=function(a){return slots[a]},this.getSlotForAddress=getSlotForAddress,this.read=function(a){var b=primarySlotConfig>>(a>>14<<1)&3;return 3===b?slot3.read(a):1===b?slot1.read(a):0===b?slot0.read(a):slot2.read(a)},
this.write=function(a,b){var c=primarySlotConfig>>(a>>14<<1)&3;3===c?slot3.write(a,b):1===c?slot1.write(a,b):2===c?slot2.write(a,b):slot0.write(a,b)};var origWrite=this.write;this.writeWithBusMonitor=function(a,b){writeMonitor(a,b),origWrite(a,b)},this.setDRAMMode=function(a){dramMode=!!a,dramWait=0|!dramMode},this.setSlot3SecondaryConfig=function(a){slot3SecondaryConfig=a},this.getBreakWait=function(a,b){var c=a>>14<<1,d=primarySlotConfig>>c&3;return 3===d?(a^b)>>8?1:(d=slot3SecondaryConfig>>c&3,0===d?0:1===d?dramWait:1):0===d?(a^b)>>8?1:dramWait:1},this.getAccessWait=function(a){var b=a>>14<<1,c=primarySlotConfig>>b&3;return 3===c?(c=slot3SecondaryConfig>>b&3,0===c?0:1===c?dramWait:1):0===c?dramWait:2},this.input=function(a){return devicesInputPorts[255&a](a)},this.output=function(a,b){return devicesOutputPorts[255&a](b,a)},this.getIOWait=function(a,b){if(a>155||a<152)return 0;var c=vdpIOClock;vdpIOClock=cpu.getBUSCycles();var d=31-(vdpIOClock-c);return d>0?d*b:0},this.setPrimarySlotConfig=function(a){primarySlotConfig=a},this.getPrimarySlotConfig=function(){return primarySlotConfig},this.cpuExtensionBegin=function(a){if(a.extNum<240)return getSlotForAddress(a.extPC).cpuExtensionBegin(a);var b=cpuExtensionHandlers[a.extNum];return b?b.cpuExtensionBegin(a):void 0},this.cpuExtensionFinish=function(a){if(a.extNum<240)return getSlotForAddress(a.extPC).cpuExtensionFinish(a);var b=cpuExtensionHandlers[a.extNum];return b?b.cpuExtensionFinish(a):void 0},this.setCpuExtensionHandler=function(a,b){cpuExtensionHandlers[a]=b},this.connectInputDevice=function(a,b){devicesInputPorts[a]=b},this.connectOutputDevice=function(a,b){devicesOutputPorts[a]=b},this.disconnectInputDevice=function(a,b){b&&devicesInputPorts[a]!==b||(devicesInputPorts[a]=deviceInputMissing)},this.disconnectOutputDevice=function(a,b){b&&devicesOutputPorts[a]!==b||(devicesOutputPorts[a]=deviceOutputMissing)},this.setWriteMonitor=function(a){writeMonitor=a,this.write=writeMonitor?this.writeWithBusMonitor:origWrite},this.connectSwitchedDevice=function(a,b){switchedDevices.connectSwitchedDevice(a,b)},this.disconnectSwitchedDevice=function(a,b){switchedDevices.disconnectSwitchedDevice(a,b)};var slots,slot0,slot1,slot2,slot3,slotModules,primarySlotConfig=0,slot3SecondaryConfig=0,slotEmpty=wmsx.SlotEmpty.singleton,deviceInputMissing=wmsx.DeviceMissing.inputPort,deviceOutputMissing=wmsx.DeviceMissing.outputPort,devicesInputPorts,devicesOutputPorts,writeMonitor,switchedDevices,vdpIOClock=0,dramMode=!1,dramWait=0,cpuExtensionHandlers={};this.saveState=function(){return{p:primarySlotConfig,s0:slot0.saveState(),s1:slot1.saveState(),s2:slot2.saveState(),s3:slot3.saveState(),sM:slotModules.saveState(),d:dramMode,vc:vdpIOClock}},this.loadState=function(a){this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s0,slot0),0),this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s1,slot1),1),this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s2,slot2),2),this.insertSlot(wmsx.SlotCreator.recreateFromSaveState(a.s3,slot3),3),this.insertSlot(a.sM?wmsx.SlotCreator.recreateFromSaveState(a.sM,slotModules):slotEmpty,4),this.setDRAMMode(!!a.d),this.setPrimarySlotConfig(a.p),vdpIOClock=a.vc||0},init(),this.eval=function(str){return eval(str)}},wmsx.Machine=function(){"use strict";function init(){socketsCreate(),mainComponentsCreate(),computeBasicAutoRunCommandParameters()}function getSlot(a){"number"==typeof a&&(a=[a]);var b=a[0],c=a[1],d=bus.getSlot(b);return c>=0?d=d.isExpanded()?d.getSubSlot(c):null:d.isExpanded()&&(d=d.getSubSlot(0)),d}function getSlotDesc(a){var b="number"==typeof a?a:a[0];return b>3?void 0:b.toString()+(bus.getSlot(b).isExpanded()?"-"+(a[1]||0):"")}function insertSlot(a,b){"number"==typeof b&&(b=[b]);var c=!a||a===EMPTY_SLOT;if(!c||-1===e||(getSlot(b)||EMPTY_SLOT)!==EMPTY_SLOT){var d=b[0],e=b[1],f=bus.getSlot(d);if(e>=0){if(!f.isExpanded()){var g=f;f=0===d?new wmsx.SlotExpanded0:3===d?new wmsx.SlotExpanded3:4===d?new wmsx.SlotExpandedM:new wmsx.SlotExpanded,bus.insertSlot(f,d),g!==EMPTY_SLOT&&e>0&&f.insertSubSlot(g,0)}f.insertSubSlot(a,e),c&&f.isAllEmpty()&&bus.insertSlot(a,d)}else f.isExpanded()&&-1!==e?(f.insertSubSlot(a,0),c&&f.isAllEmpty()&&bus.insertSlot(a,d)):bus.insertSlot(a,d)}}function setVideoStandard(a,b,c){!1!==c&&self.showOSD((videoStandardIsAuto?"AUTO: ":"FORCED: ")+a.desc,!!c),(b||videoStandard!==a)&&(videoStandard=a,vdp.setVideoStandard(videoStandard),videoClockUpdateSpeed())}function setVideoStandardAuto(a){videoStandardIsAuto=!0;var b=wmsx.VideoStandard.NTSC;videoStandardSoft?b=videoStandardSoft:bios&&(bios.setVideoStandardUseOriginal(),b=bios.originalVideoStandard),setVideoStandard(b,!0,a)}function setVideoStandardForced(a){videoStandardIsAuto=!1,bios&&bios.setVideoStandardForced(a),setVideoStandard(a,!1,!0)}function setVSynchMode(a,b){(vSynchMode!==a||b)&&(vSynchMode=a<0?a:a%2,vdp.setVSynchMode(vSynchMode),videoClockUpdateSpeed())}function vSynchModeToggle(){if(vSynchMode<0||-1===videoClockSocket.getVSynchNativeFrequency())return self.showOSD("VSync is disabled / unsupported",!0,!0);setVSynchMode(vSynchMode+1),self.showOSD("VSync: "+(1===vSynchMode?"Auto ("+(videoClockSocket.isVSynchActive()?"ON":"OFF")+")":0===vSynchMode?"OFF":"DISABLED"),!0),WMSX.userPreferences.current.vSynch=vSynchMode,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save()}function saveState(a){var b={cfg:wmsx.Configurator.saveState(),mn:self.machineName,mt:self.machineType,b:bus.saveState(),rc:rtc.saveState(),sf:syf.saveState(),td:trd.saveState(),pp:ppi.saveState(),ps:psg.saveState(),vd:vdp.saveState(a),c:cpu.saveState(),va:videoStandardIsAuto,vs:videoStandard.name,ctm:z80ClockMode,rtm:r800ClockMode,vtm:vdpClockMode,s:speedControl,br:basicAutoRunDone,bc:basicAutoRunCommand||"",vss:videoStandardSoft&&videoStandardSoft.name,vm:videoSocket.saveState(),dd:diskDriveSocket.saveState(),ct:cassetteSocket.saveState(),cs:controllersSocket.saveState()};return a&&(b.vy=vSynchMode,b.pw=self.powerIsOn,b.up=userPaused,b.upf=userPauseMoreFrames),b}function loadState(a){wmsx.Configurator.loadState(a,a.cfg),void 0!==a.vy&&setVSynchMode(a.vy,!0),void 0!==a.pw&&self.powerIsOn!==a.pw&&(a.pw?self.powerOn(!0):self.powerOff()),void 0!==a.up&&self.userPause(a.up),void 0!==a.upf&&(userPauseMoreFrames=a.upf),self.machineName=a.mn,self.machineType=a.mt,videoStandardIsAuto=a.va,setVideoStandard(wmsx.VideoStandard[a.vs]),videoStandardSoft=a.vss&&wmsx.VideoStandard[a.vss],speedControl=a.s||1,1===speedControl&&(speedControl=defaultSpeed),basicAutoRunDone=!!a.br,void 0!==a.bc&&(basicAutoRunCommand=a.bc),videoClockUpdateSpeed(),cpu.loadState(a.c),vdp.loadState(a.vd),psg.loadState(a.ps),ppi.loadState(a.pp),rtc.loadState(a.rc),syf.loadState(a.sf),trd.loadState(a.td),bus.loadState(a.b),videoSocket.loadState(a.vm),diskDriveSocket.loadState(a.dd),cassetteSocket.loadState(a.ct),a.cs&&controllersSocket.loadState(a.cs),machineTypeSocket.fireMachineTypeStateUpdate(),cartridgeSocket.fireCartridgesStateUpdate(),machineControlsSocket.firePowerAndUserPauseStateUpdate(),audioSocket.flushAllSignals(),diskDriveSocket.fireInterfacesChangeUpdate(),z80ClockMode=void 0!==a.ctm?a.ctm:cpu.getZ80ClockMulti()>1?cpu.getZ80ClockMulti():0,r800ClockMode=void 0!==a.rtm?a.rtm:cpu.getR800ClockMulti()>1?cpu.getR800ClockMulti():0,vdpClockMode=void 0!==a.vtm?a.vtm:vdp.getVDPTurboMulti()>1?vdp.getVDPTurboMulti():0,biosSocket.turboDriverTurboModesUpdate(),saveStateSocket.externalStateChange()}function videoClockUpdateSpeed(){var a=vdp.getDesiredVideoPulldown();videoClockSocket.setVSynch(1===vSynchMode);var b=a.frequency*(alternateSpeed||speedControl)|0;videoClockSocket.setFrequency(b,a.divider),audioSocket.setFps(b/a.divider),rtc.setFps(a.frequency/a.divider)}function mainComponentsCreate(){self.cpu=cpu=new wmsx.CPU,self.rtc=rtc=new wmsx.RTC(videoClockSocket),self.syf=syf=new wmsx.SystemFlags,self.trd=trd=new wmsx.TurboRDevices(cpu,ledsSocket),
self.vdp=vdp=new wmsx.VDP(self,cpu,trd),self.psg=psg=new wmsx.PSG(controllersSocket,ledsSocket,!1),self.ppi=ppi=new wmsx.PPI(psg.getAudioChannel(),controllersSocket,ledsSocket),self.bus=bus=new wmsx.BUS(self,cpu),cpu.connectBus(bus),ppi.connectBus(bus),vdp.connectBus(bus),psg.setAudioSocket(audioSocket),psg.connectBus(bus),rtc.connectBus(bus),syf.connectBus(bus),trd.connectBus(bus)}function socketsCreate(){machineTypeSocket=new wmsx.MachineTypeSocket(self),videoClockSocket=new VideoClockSocket,videoSocket=new VideoSocket,slotSocket=new SlotSocket,biosSocket=new BIOSSocket,extensionsSocket=new wmsx.ExtensionsSocket(self),cartridgeSocket=new CartridgeSocket,expansionSocket=new ExpansionSocket,controllersSocket=new ControllersSocket,saveStateSocket=new SaveStateSocket,cassetteSocket=new CassetteSocket,audioSocket=new AudioSocket,diskDriveSocket=new DiskDriveSocket,machineControlsSocket=new MachineControlsSocket,ledsSocket=new LedsSocket}function computeBasicAutoRunCommandParameters(){basicAutoRunCommand=(WMSX.BASIC_ENTER?WMSX.BASIC_ENTER+"\r":"")+(WMSX.BASIC_TYPE||""),WMSX.BASIC_RUN?basicAutoRunCommand='\r\r\rRUN "'+WMSX.BASIC_RUN+'"\r'+basicAutoRunCommand:WMSX.BASIC_LOAD?basicAutoRunCommand='\r\r\rLOAD "'+WMSX.BASIC_LOAD+'"\r'+basicAutoRunCommand:WMSX.BASIC_BRUN?basicAutoRunCommand='\r\r\rBLOAD "'+WMSX.BASIC_BRUN+'",r\r'+basicAutoRunCommand:WMSX.BASIC_BLOAD&&(basicAutoRunCommand='\r\r\rBLOAD "'+WMSX.BASIC_BLOAD+'"\r'+basicAutoRunCommand)}function typeBasicAutoRunCommand(){diskDriveSocket.hasAnyMediaInserted()||cartridgeSocket.hasAnyMediaInserted()||cassetteSocket.typeAutoRunCommand(),basicAutoRunDone||(basicAutoRunCommand&&biosSocket.keyboardExtensionTypeString(basicAutoRunCommand),basicAutoRunDone=!0,basicAutoRunCommand=void 0)}function controlStateChanged(a,b,c,d){if(!isLoading){if(a===controls.FAST_SPEED&&!c)return void(b&&alternateSpeed!==SPEED_FAST?(alternateSpeed=SPEED_FAST,videoClockUpdateSpeed(),self.showOSD("FAST FORWARD",!0)):b||alternateSpeed!==SPEED_FAST||(alternateSpeed=null,videoClockUpdateSpeed(),self.showOSD(null,!0)));if(a===controls.FAST_SPEED&&c)return void(b&&alternateSpeed!==SPEED_SLOW?(alternateSpeed=SPEED_SLOW,videoClockUpdateSpeed(),self.showOSD("SLOW MOTION",!0)):b||alternateSpeed!==SPEED_SLOW||(alternateSpeed=null,videoClockUpdateSpeed(),self.showOSD(null,!0)));if(b)switch(a){case controls.POWER:c?self.powerIsOn&&self.reset():self.powerIsOn?self.powerOff():self.userPowerOn(!1);break;case controls.POWER_OFF:self.powerIsOn&&self.powerOff();break;case controls.PAUSE_CPU:var e=!trd.isCPUPaused();self.cpuPause(e,c);break;case controls.PAUSE:self.userPause(!userPaused,c),self.showOSD(userPaused?"EMULATION PAUSED"+(c?" with AUDIO ON":""):"EMULATION RESUMED",!0);break;case controls.FRAME:userPaused&&(userPauseMoreFrames=1);break;case controls.INC_SPEED:case controls.DEC_SPEED:case controls.NORMAL_SPEED:case controls.MIN_SPEED:var f=SPEEDS.indexOf(speedControl);return a===controls.INC_SPEED&&f<SPEEDS.length-1?++f:a===controls.DEC_SPEED&&f>0?--f:a===controls.MIN_SPEED?f=0:a===controls.NORMAL_SPEED&&(f=SPEEDS.indexOf(1)),speedControl=SPEEDS[f],self.showOSD("Speed: "+(100*speedControl|0)+"%",!0),void videoClockUpdateSpeed();case controls.SAVE_STATE_0:case controls.SAVE_STATE_1:case controls.SAVE_STATE_2:case controls.SAVE_STATE_3:case controls.SAVE_STATE_4:case controls.SAVE_STATE_5:case controls.SAVE_STATE_6:case controls.SAVE_STATE_7:case controls.SAVE_STATE_8:case controls.SAVE_STATE_9:case controls.SAVE_STATE_10:case controls.SAVE_STATE_11:case controls.SAVE_STATE_12:saveStateSocket.saveState(255&a);break;case controls.SAVE_STATE_FILE:saveStateSocket.saveStateFile();break;case controls.LOAD_STATE_0:case controls.LOAD_STATE_1:case controls.LOAD_STATE_2:case controls.LOAD_STATE_3:case controls.LOAD_STATE_4:case controls.LOAD_STATE_5:case controls.LOAD_STATE_6:case controls.LOAD_STATE_7:case controls.LOAD_STATE_8:case controls.LOAD_STATE_9:case controls.LOAD_STATE_10:case controls.LOAD_STATE_11:case controls.LOAD_STATE_12:saveStateSocket.loadState(255&a);break;case controls.TYPE_STRING:biosSocket.keyboardExtensionTypeString(d);break;case controls.VIDEO_STANDARD:videoStandardIsAuto?setVideoStandardForced(c?wmsx.VideoStandard.PAL:wmsx.VideoStandard.NTSC):videoStandard==wmsx.VideoStandard.NTSC?c?setVideoStandardAuto(!0):setVideoStandardForced(wmsx.VideoStandard.PAL):c?setVideoStandardForced(wmsx.VideoStandard.NTSC):setVideoStandardAuto(!0);break;case controls.VSYNCH:vSynchModeToggle();break;case controls.CPU_CLOCK_MODE:trd.isR800LedOn()?self.toggleR800ClockMode(c):self.toggleZ80ClockMode(c);break;case controls.Z80_CLOCK_MODE:self.toggleZ80ClockMode(c);break;case controls.R800_CLOCK_MODE:self.toggleR800ClockMode(c);break;case controls.VDP_CLOCK_MODE:self.toggleVDPClockMode(c);break;case controls.DEBUG:var g=vdp.toggleDebugModes(c);wmsx.DeviceMissing.setDebugMode(g);break;case controls.SPRITE_MODE:vdp.toggleSpriteDebugModes(c);break;case controls.DEFAULTS:self.setDefaults(),self.showOSD("Default Settings",!0)}}}function VideoClockSocket(){this.connectClock=function(b){a=b,rtc.syncTimeWithSource()},this.getVSynchNativeFrequency=function(){return a.getVSynchNativeFrequency()},this.setVSynch=function(b){a.setVSynch(b)},this.setFrequency=function(b,c){a.setFrequency(b,c)},this.isVSynchActive=function(){return a.isVSynchActive()},this.getRealTime=function(){return a.getRealTime()};var a}function BIOSSocket(){this.insertBIOS=function(a,b){slotSocket.insertSlot(a,WMSX.BIOS_SLOT,b)},this.insertBIOSEXT=function(a,b){slotSocket.insertSlot(a,WMSX.BIOSEXT_SLOT,b)},this.keyboardExtensionTypeString=function(a){bios&&bios.getKeyboardExtension().typeString(a)},this.keyboardExtensionCancelTypeString=function(){bios&&bios.getKeyboardExtension().cancelTypeString()},this.turboDriverTurboModesUpdate=function(){bios&&bios.getTurboDriver().turboModesUpdate()}}function ExpansionSocket(){this.insertExpansion=function(a,b,c){var d=b?WMSX.EXPANSION2_SLOT:WMSX.EXPANSION1_SLOT;a!==slotSocket.slotInserted(d)&&(slotSocket.insertSlot(a,d,c),cartridgeSocket.fireCartridgesStateUpdate(),self.showOSD("Expansion "+(1===b?"2":"1")+" (slot "+getSlotDesc(d)+"): "+(a?a.rom.source:"EMPTY"),!0))},this.expansionInserted=function(a){return slotSocket.slotInserted(a?WMSX.EXPANSION2_SLOT:WMSX.EXPANSION1_SLOT)}}function CartridgeSocket(){this.insertCartridge=function(a,b,c,d){var e=1===b?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT;slotSocket.insertSlot(a,e,c,!0),this.fireCartridgesStateUpdate(),d||self.showOSD("Cartridge "+(1===b?"2":"1")+": "+(a?a.rom.source:"EMPTY"),!0)},this.removeCartridge=function(a,b){var c=1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT;return null===slotSocket.slotInserted(c)?(self.showOSD("No Cartridge in Slot "+(1===a?"2":"1"),!0,!0),!1):(slotSocket.insertSlot(null,c,b,!0),this.fireCartridgesStateUpdate(),self.showOSD("Cartridge "+(1===a?"2":"1")+" removed",!0),!0)},this.cartridgeInserted=function(a){return slotSocket.slotInserted(1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT)},this.dataOperationNotSupportedMessage=function(a,b,c){var d=1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT,e=slotSocket.slotInserted(d);return null===e?(c||self.showOSD("No Cartridge in Slot "+(1===a?"2":"1"),!0,!0),!0):!e.getDataDesc()&&(c||self.showOSD("Data "+(b?"Saving":"Loading")+" not supported for Cartridge "+(1===a?"2":"1"),!0,!0),!0)},this.loadCartridgeData=function(a,b,c){var d=1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT,e=slotSocket.slotInserted(d);if(e&&e.loadData(wmsx.Util.leafFilename(b),c))return self.showOSD(e.getDataDesc()+" loaded in Cartridge "+(1===a?"2":"1"),!0),c},this.getCartridgeData=function(a){if(!this.dataOperationNotSupportedMessage(a,!0,!1)){return slotSocket.slotInserted(1===a?WMSX.CARTRIDGE2_SLOT:WMSX.CARTRIDGE1_SLOT).getDataToSave()}},this.fireCartridgesStateUpdate=function(){for(var a=0;a<b.length;a++)b[a].cartridgesStateUpdate()},
this.fireCartridgesModifiedStateUpdate=function(){a&&a.cartridgesModifiedStateUpdate(slotSocket.slotInserted(WMSX.CARTRIDGE1_SLOT),slotSocket.slotInserted(WMSX.CARTRIDGE2_SLOT))},this.addCartridgesStateListener=function(a,c){b.indexOf(a)<0&&(b.push(a),c||a.cartridgesStateUpdate())},this.setCartridgesModifiedStateListener=function(b){a=b,this.fireCartridgesModifiedStateUpdate()},this.hasAnyMediaInserted=function(){return slotSocket.slotInserted(WMSX.CARTRIDGE1_SLOT)||slotSocket.slotInserted(WMSX.CARTRIDGE2_SLOT)};var a,b=[]}function SlotSocket(){this.insertSlot=function(a,b,c,d){var e=self.powerIsOn;e&&!c&&self.powerOff(),insertSlot(a,b),c||!a&&!e?a&&self.powerIsOn&&a.powerOn():self.userPowerOn(!1),d||saveStateSocket.externalStateChange()},this.slotInserted=function(a){var b=getSlot(a);return b===EMPTY_SLOT?null:b},this.getSlotDesc=function(a){return getSlotDesc(a)}}function VideoSocket(){this.connectMonitor=function(b){a=b},this.connectInternalVideoSignal=function(b){a.connectInternalVideoSignal(b)},this.connectExternalVideoSignal=function(b){a.connectExternalVideoSignal(b)},this.disconnectExternalVideoSignal=function(b){a.disconnectExternalVideoSignal(b)},this.getMonitor=function(){return a},this.saveState=function(){return a.saveState()},this.loadState=function(b){a.loadState(b)};var a}function AudioSocket(){this.connectMonitor=function(b){a=b;for(var d=c.length-1;d>=0;d--)a.connectAudioSignal(c[d])},this.connectAudioSignal=function(d){c.indexOf(d)>=0||(wmsx.Util.arrayAdd(c,d),this.flushAllSignals(),d.setFps(b),a&&a.connectAudioSignal(d))},this.disconnectAudioSignal=function(b){wmsx.Util.arrayRemoveAllElement(c,b),a&&a.disconnectAudioSignal(b)},this.audioClockPulse32=function(){for(var a=c.length-1;a>=0;--a)c[a].audioClockPulse()},this.audioFinishFrame=function(){for(var a=c.length-1;a>=0;--a)c[a].audioFinishFrame()},this.muteAudio=function(){a&&a.mute()},this.unMuteAudio=function(){a&&a.unMute()},this.setFps=function(a){b=a;for(var d=c.length-1;d>=0;--d)c[d].setFps(b)},this.pauseAudio=function(){a&&a.pauseAudio()},this.unpauseAudio=function(){a&&a.unpauseAudio()},this.flushAllSignals=function(){for(var a=c.length-1;a>=0;--a)c[a].flush()},this.getBUSCycles=function(){return cpu.getBUSCycles()};var a,b,c=[]}function CassetteSocket(){this.connectDeck=function(b){a=b},this.connectDriver=function(a){b=a},this.getDeck=function(){return a},this.getDriver=function(){return b},this.autoPowerCycle=function(a){b&&b.currentAutoRunCommand()&&(self.powerIsOn||a||self.userPowerOn(!0))},this.typeAutoRunCommand=function(){b&&b.typeCurrentAutoRunCommand()},this.saveState=function(){return a.saveState()},this.loadState=function(b){a.loadState(b)};var a,b}function DiskDriveSocket(){this.connectDrive=function(a){b=a},this.getDrive=function(){return b},this.autoPowerCycle=function(a){self.powerIsOn||a||self.userPowerOn(!1)},this.diskInterfaceConnected=function(a){c.add(a),this.fireInterfacesChangeUpdate()},this.diskInterfaceDisconnected=function(a){c.delete(a),this.fireInterfacesChangeUpdate()},this.hardDiskInterfaceConnected=function(a){d.add(a),this.fireInterfacesChangeUpdate()},this.hardDiskInterfaceDisconnected=function(a){d.delete(a),this.fireInterfacesChangeUpdate()},this.dos2ROMConnected=function(a){e.add(a)},this.dos2ROMDisconnected=function(a){e.delete(a)},this.hasDiskInterface=function(){return c.size>0},this.hasHardDiskInterface=function(){return d.size>0},this.hasDOS2=function(){return e.size>0||d.size>0},this.setInterfacesChangeListener=function(b){a=b,this.fireInterfacesChangeUpdate()},this.fireInterfacesChangeUpdate=function(){a&&a.diskInterfacesStateUpdate(this.hasDiskInterface(),this.hasHardDiskInterface())},this.hasAnyMediaInserted=function(){return this.getDrive().hasAnyMediaInserted()},this.saveState=function(){return b.saveState()},this.loadState=function(a){b.loadState(a)};var a,b,c=new Set,d=new Set,e=new Set}function ControllersSocket(){this.connectControls=function(b){a=b},this.readKeyboardPort=function(b){return a.readKeyboardPort(b)},this.readControllerPort=function(b){return a.readControllerPort(b)},this.writeControllerPin8Port=function(b,c){a.writeControllerPin8Port(b,c)},this.releaseControllers=function(){a.releaseControllers()},this.resetControllers=function(){a.resetControllers()},this.getBUSCycles=function(){return cpu.getBUSCycles()},this.saveState=function(){return a.saveState()},this.loadState=function(b){a.loadState(b)};var a}function MachineControlsSocket(){this.controlStateChanged=function(a,b,c,d){controlStateChanged(a,b,c,d)},this.addPowerAndUserPauseStateListener=function(b){a.indexOf(b)>=0||(a.push(b),this.firePowerAndUserPauseStateUpdate())},this.firePowerAndUserPauseStateUpdate=function(){for(var b=0;b<a.length;++b)a[b].machinePowerAndUserPauseStateUpdate(self.powerIsOn,userPaused)},this.getControlReport=function(a){switch(a){case controls.VIDEO_STANDARD:return{label:videoStandardIsAuto?"Auto":videoStandard.name,active:!videoStandardIsAuto};case controls.Z80_CLOCK_MODE:var b=cpu.getZ80ClockMulti(),c=0===z80ClockMode?"Auto"+(1!==b?" "+b+"x":""):1===z80ClockMode?"Normal":b+"x";return{label:c,active:1!==b};case controls.R800_CLOCK_MODE:return b=cpu.getR800ClockMulti(),c=0===r800ClockMode?"Auto"+(1!==b?" "+b+"x":""):1===r800ClockMode?"Normal":b+"x",{label:c,active:1!==b};case controls.VDP_CLOCK_MODE:return b=vdp.getVDPTurboMulti(),{label:self.getVDPClockModeDesc(),active:1!==b};case controls.SPRITE_MODE:return c=vdp.getSpriteDebugModeQuickDesc(),{label:c,active:"Normal"!==c};case controls.VSYNCH:return{label:vSynchMode<0?"DISABL":vSynchMode?"Auto":"OFF",active:0===vSynchMode}}return{label:"Unknown",active:!1}};var a=[]}function LedsSocket(){this.ledStateChanged=function(a,c){b[a]!==c&&(b[a]=c,this.fireLedsStateUpdate())},this.ledInfoChanged=function(a,b){c[a]!==b&&(c[a]=b,this.fireLedsStateUpdate())},this.setLedsStateListener=function(b){a=b,this.fireLedsStateUpdate()},this.fireLedsStateUpdate=function(){a&&a.ledsStateUpdate(b,c)};var a,b=[0,0,0,0,0],c=["","","","",""]}function SaveStateSocket(){this.connectMedia=function(b){a=b},this.saveState=function(c){if(self.powerIsOn&&a){var d=self.systemPause(!0);self.showOSD("Saving State "+c,!0);var e=saveState();e.v=b,a.persistState(c,e,function(a){a?self.showOSD("State "+c+" saved",!0):self.showOSD("State "+c+" save FAILED!",!0,!0),d||self.systemPause(!1)})}},this.loadState=function(b){if(a){var d=self.systemPause(!0);self.showOSD("Loading State "+b,!0),a.retrieveState(b,function(a){a?c[a.v]?(self.powerIsOn?self.reset(!0):self.powerOn(!0),loadState(a),WMSX.userPreferences.current.syncTimeLoadState&&rtc.syncTimeWithSource(),self.showOSD("State "+b+" loaded",!0)):self.showOSD("State "+b+" load failed. State version incompatible!",!0,!0):self.showOSD("State "+b+" not found!",!0,!0),d||self.systemPause(!1)})}},this.saveStateFile=function(){if(self.powerIsOn&&a){var c=self.systemPause(!0);self.showOSD("Saving State File",!0);var d=saveState();d.v=b,a.saveStateFile(d),c||self.systemPause(!1)}},this.loadStateFile=function(b){if(!a)return!1;self.showOSD("Loading State File",!0);var d=a.loadStateFile(b);return d?(wmsx.Util.log("State file loaded"),c[d.v]?(self.powerIsOn?self.reset(!0):self.powerOn(!0),loadState(d),self.showOSD("State File loaded",!0)):self.showOSD("State File load failed. State version incompatible!",!0,!0),!0):(self.showOSD(null,!0),!1)},this.externalStateChange=function(){a.externalStateChange()};var a,b=WMSX.STATE_VERSION,c=WMSX.STATE_VERSIONS_ACCEPTED}var self=this;this.socketsConnected=function(){videoSocket.connectInternalVideoSignal(vdp.getVideoSignal()),self.updateMachineType(),self.setZ80ClockMode(z80ClockMode),self.setR800ClockMode(r800ClockMode),self.setVDPClockMode(vdpClockMode),self.setDefaults()},this.updateMachineType=function(){this.machineName=WMSX.MACHINE,this.machineType=WMSX.MACHINES_CONFIG[this.machineName].TYPE||3,cpu.setMachineType(this.machineType),
vdp.setMachineType(this.machineType),rtc.setMachineType(this.machineType),syf.setMachineType(this.machineType),trd.setMachineType(this.machineType),biosSocket.turboDriverTurboModesUpdate(),bus.refreshConnect(),machineTypeSocket.fireMachineTypeStateUpdate()},this.preStart=function(){extensionsSocket.refreshConfigFromSlots()},this.powerOn=function(a){this.powerIsOn&&this.powerOff(),bus.powerOn(),trd.powerOn(),syf.powerOn(),rtc.powerOn(),ppi.powerOn(),psg.powerOn(),vdp.powerOn(),cpu.powerOn(),this.reset(a),this.powerIsOn=!0,a||machineControlsSocket.firePowerAndUserPauseStateUpdate()},this.powerOff=function(){cpu.powerOff(),vdp.powerOff(),psg.powerOff(),ppi.powerOff(),rtc.powerOff(),syf.powerOff(),trd.powerOff(),bus.powerOff(),controllersSocket.resetControllers(),this.powerIsOn=!1,userPaused?this.userPause(!1):machineControlsSocket.firePowerAndUserPauseStateUpdate(),this.cpuPause(!1,!1,!0)},this.reset=function(a){videoStandardSoft=null,videoStandardIsAuto&&setVideoStandardAuto(),controllersSocket.resetControllers(),trd.reset(),syf.reset(),rtc.reset(),ppi.reset(),psg.reset(),vdp.reset(),cpu.reset(),bus.reset(),audioSocket.flushAllSignals(),fastBootFrames>0&&(a?fastBootCountdown>0&&(alternateSpeed=null,videoClockUpdateSpeed()):(fastBootCountdown=fastBootFrames,alternateSpeed=SPEED_FAST,videoClockUpdateSpeed()))},this.userPowerOn=function(a){if(!isLoading){if(!bios)return void this.showOSD("Insert BIOS!",!0,!0);this.powerOn(),a&&typeBasicAutoRunCommand()}},this.videoClockPulse=function(){fastBootCountdown>0&&--fastBootCountdown<=0&&(alternateSpeed=null,videoClockUpdateSpeed()),rtc.videoClockPulse(),bios&&bios.getKeyboardExtension().keyboardExtensionClockPulse(),self.powerIsOn&&(userPaused&&userPauseMoreFrames--<=0||(vdp.videoClockPulse(),audioSocket.audioFinishFrame()))},this.getMachineTypeSocket=function(){return machineTypeSocket},this.getVideoClockSocket=function(){return videoClockSocket},this.getSlotSocket=function(){return slotSocket},this.getBIOSSocket=function(){return biosSocket},this.getExtensionsSocket=function(){return extensionsSocket},this.getExpansionSocket=function(){return expansionSocket},this.getCartridgeSocket=function(){return cartridgeSocket},this.getMachineControlsSocket=function(){return machineControlsSocket},this.getControllersSocket=function(){return controllersSocket},this.getVideoSocket=function(){return videoSocket},this.getAudioSocket=function(){return audioSocket},this.getSavestateSocket=function(){return saveStateSocket},this.getCassetteSocket=function(){return cassetteSocket},this.getDiskDriveSocket=function(){return diskDriveSocket},this.getLedsSocket=function(){return ledsSocket},this.showOSD=function(a,b,c){videoSocket.getMonitor().showOSD(a,b,c)},this.setVideoStandardSoft=function(a){videoStandardSoft=a,videoStandardIsAuto&&videoStandard!==a?setVideoStandard(a,!1,!0):videoStandardIsAuto||videoStandard===a||self.showOSD("Cannot soft-change Video Standard. It's FORCED: "+videoStandard.desc,!0,!0)},this.setBIOS=function(a){bios=a===EMPTY_SLOT?null:a,videoStandardSoft=null,setVideoStandardAuto()},this.setLoading=function(a){isLoading=a},this.userPause=function(a,b){var c=userPaused;return userPaused!==a&&(userPaused=!!a,userPauseMoreFrames=-1,userPaused?b||audioSocket.muteAudio():audioSocket.unMuteAudio(),machineControlsSocket.firePowerAndUserPauseStateUpdate()),c},this.systemPause=function(a){var b=systemPaused;return systemPaused!==a&&(systemPaused=!!a,systemPaused?audioSocket.pauseAudio():trd.isCPUPaused()||audioSocket.unpauseAudio()),b},this.isSystemPaused=function(){return systemPaused},this.cpuPause=function(a,b,c){a!==trd.isCPUPaused()&&(trd.setCPUPause(a,c),a?b||audioSocket.pauseAudio():systemPaused||audioSocket.unpauseAudio())},this.vSynchSetSupported=function(a){var b=WMSX.userPreferences.current.vSynch;setVSynchMode(-1!==WMSX.SCREEN_VSYNC_MODE&&a?WMSX.SCREEN_VSYNC_MODE>=0?WMSX.SCREEN_VSYNC_MODE:null!==b&&b>=0?b:1:-1,!0)},this.toggleZ80ClockMode=function(a){a?this.setZ80ClockMode(z80ClockMode<=0?8:z80ClockMode<=1?0:z80ClockMode<=1.5?1:z80ClockMode<=2?1.5:(0|z80ClockMode)-1):this.setZ80ClockMode(z80ClockMode>=8?0:z80ClockMode<1?1:z80ClockMode<1.5?1.5:z80ClockMode<2?2:1+(0|z80ClockMode)),this.showZ80ClockModeMessage()},this.setZ80ClockMode=function(a){z80ClockMode=a<0||a>8?0:a,biosSocket.turboDriverTurboModesUpdate()},this.getZ80ClockMode=function(){return z80ClockMode},this.showZ80ClockModeMessage=function(){self.showOSD("Z80 Clock: "+this.getZ80ClockModeDesc(),!0)},this.getZ80ClockModeDesc=function(){var a=0===z80ClockMode?"Auto ":1===z80ClockMode?"Normal ":"",b=cpu.getZ80ClockMulti();return a+=(0!==z80ClockMode&&1!==z80ClockMode?b+"x ":"")+"("+cpu.getClockFreqDesc(b)+")"},this.toggleR800ClockMode=function(a){a?this.setR800ClockMode(r800ClockMode<=0?2:r800ClockMode<=.5?0:Math.max(((4*r800ClockMode|0)-1)/4,.5)):this.setR800ClockMode(r800ClockMode>=2?0:Math.max((1+(4*r800ClockMode|0))/4,.5)),this.showR800ClockModeMessage()},this.setR800ClockMode=function(a){r800ClockMode=a<0||a>2?0:a,biosSocket.turboDriverTurboModesUpdate()},this.getR800ClockMode=function(){return r800ClockMode},this.showR800ClockModeMessage=function(){self.showOSD("R800 Clock: "+this.getR800ClockModeDesc(),!0)},this.getR800ClockModeDesc=function(){var a=0===r800ClockMode?"Auto ":1===r800ClockMode?"Normal ":"",b=cpu.getR800ClockMulti();return a+=(0!==r800ClockMode&&1!==r800ClockMode?b+"x ":"")+"("+cpu.getClockFreqDesc(2*b)+")"},this.toggleVDPClockMode=function(a){a?this.setVDPClockMode(vdpClockMode<=0?9:vdpClockMode<=1?0:(0|vdpClockMode)-1):this.setVDPClockMode(1+(0|vdpClockMode)),self.showOSD("VDP Engine Clock: "+this.getVDPClockModeDesc(),!0)},this.setVDPClockMode=function(a){vdpClockMode=a<0||a>9?0:a,biosSocket.turboDriverTurboModesUpdate()},this.getVDPClockMode=function(){return vdpClockMode},this.getVDPClockModeDesc=function(){var a=0===vdpClockMode?"Auto ":1===vdpClockMode?"Normal ":9===vdpClockMode?"Instant":"",b=vdp.getVDPTurboMulti();return a+=b>0&&1!==b&&b<9?b+"x ":""},this.setDefaults=function(){setVideoStandardAuto(!1),vdp.setDefaults(),speedControl=defaultSpeed,alternateSpeed=null,videoClockUpdateSpeed()},this.saveState=saveState,this.loadState=loadState,this.machineName=null,this.machineType=0,this.powerIsOn=!1;var speedControl=1,alternateSpeed=!1,defaultSpeed=WMSX.SPEED>0?WMSX.SPEED/100:1,isLoading=!1,basicAutoRunDone=!1,basicAutoRunCommand,cpu,bus,ppi,vdp,psg,rtc,syf,trd,userPaused=!1,userPauseMoreFrames=0,systemPaused=!1,cpuPaused=!1,machineTypeSocket,videoClockSocket,videoSocket,slotSocket,biosSocket,extensionsSocket,expansionSocket,cartridgeSocket,saveStateSocket,cassetteSocket,diskDriveSocket,machineControlsSocket,controllersSocket,audioSocket,ledsSocket,bios,videoStandard,videoStandardSoft,videoStandardIsAuto=!1,vSynchMode,fastBootFrames=WMSX.FAST_BOOT<=0?0:WMSX.FAST_BOOT>1?WMSX.FAST_BOOT:WMSX.BOOT_KEYS_FRAMES>0?WMSX.BOOT_KEYS_FRAMES:WMSX.BOOT_DURATION_AUTO,fastBootCountdown=0,z80ClockMode=WMSX.Z80_CLOCK_MODE<0?0:WMSX.Z80_CLOCK_MODE,r800ClockMode=WMSX.R800_CLOCK_MODE<0?0:WMSX.R800_CLOCK_MODE,vdpClockMode=WMSX.VDP_CLOCK_MODE<0?0:WMSX.VDP_CLOCK_MODE,EMPTY_SLOT=wmsx.SlotEmpty.singleton,SPEEDS=[.05,.1,.2,.3,.4,.5,.6,.7,.8,.9,1,1.1,1.25,1.5,2,3,5,10],SPEED_FAST=10,SPEED_SLOW=.3,controls=wmsx.MachineControls;this.eval=function(str){return eval(str)},init()},wmsx.Machine.BASE_CPU_CLOCK=3584160,wmsx.Machine.MACHINE_TYPE={MSX1:1,MSX2:2,MSX2P:3,MSXTR:4},wmsx.KeyboardKeys={D0:{m:[0,0],key:"D0",c_en:"0",cs_en:")",cs_ja:" "},D1:{m:[0,1],key:"D1",c_en:"1",cs_en:"!"},D2:{m:[0,2],key:"D2",c_en:"2",cs_en:"@",cs_ja:'"'},D3:{m:[0,3],key:"D3",c_en:"3",cs_en:"#"},D4:{m:[0,4],key:"D4",c_en:"4",cs_en:"$"},D5:{m:[0,5],key:"D5",c_en:"5",cs_en:"%"},D6:{m:[0,6],key:"D6",c_en:"6",cs_en:"^",cs_ja:"&"},D7:{m:[0,7],key:"D7",c_en:"7",cs_en:"&",cs_ja:"'"},D8:{m:[1,0],key:"D8",c_en:"8",cs_en:"*",cs_ja:"("},D9:{m:[1,1],key:"D9",c_en:"9",cs_en:"(",cs_ja:")"},
MINUS:{m:[1,2],key:"MINUS",c_en:"-",cs_en:"_",cs_ja:"="},EQUAL:{m:[1,3],key:"EQUAL",c_en:"=",cs_en:"+",c_ja:"^",cs_ja:"~"},BACKSLASH:{m:[1,4],key:"BACKSLASH",c_en:"\\",cs_en:"|",c_ja:"&yen;",cs_ja:"|"},OPEN_BRACKET:{m:[1,5],key:"OPEN_BRACKET",c_en:"[",cs_en:"{",c_ja:"@",cs_ja:"`"},CLOSE_BRACKET:{m:[1,6],key:"CLOSE_BRACKET",c_en:"]",cs_en:"}",c_ja:"[",cs_ja:"{"},SEMICOLON:{m:[1,7],key:"SEMICOLON",c_en:";",cs_en:":",cs_ja:"+"},QUOTE:{m:[2,0],key:"QUOTE",c_en:"'",cs_en:'"',c_ja:":",cs_ja:"*"},BACKQUOTE:{m:[2,1],key:"BACKQUOTE",c_en:"`",cs_en:"~",c_ja:"]",cs_ja:"}"},COMMA:{m:[2,2],key:"COMMA",c_en:",",cs_en:"<"},PERIOD:{m:[2,3],key:"PERIOD",c_en:".",cs_en:">"},SLASH:{m:[2,4],key:"SLASH",c_en:"/",cs_en:"?"},DEAD:{m:[2,5],key:"DEAD",c_en:"à",cs_en:"á",c_ja:" ",cs_ja:"_",cns_en:"à",cns_ja:"_"},A:{m:[2,6],key:"A",c_en:"A"},B:{m:[2,7],key:"B",c_en:"B"},C:{m:[3,0],key:"C",c_en:"C"},D:{m:[3,1],key:"D",c_en:"D"},E:{m:[3,2],key:"E",c_en:"E"},F:{m:[3,3],key:"F",c_en:"F"},G:{m:[3,4],key:"G",c_en:"G"},H:{m:[3,5],key:"H",c_en:"H"},I:{m:[3,6],key:"I",c_en:"I"},J:{m:[3,7],key:"J",c_en:"J"},K:{m:[4,0],key:"K",c_en:"K"},L:{m:[4,1],key:"L",c_en:"L"},M:{m:[4,2],key:"M",c_en:"M"},N:{m:[4,3],key:"N",c_en:"N"},O:{m:[4,4],key:"O",c_en:"O"},P:{m:[4,5],key:"P",c_en:"P"},Q:{m:[4,6],key:"Q",c_en:"Q"},R:{m:[4,7],key:"R",c_en:"R"},S:{m:[5,0],key:"S",c_en:"S"},T:{m:[5,1],key:"T",c_en:"T"},U:{m:[5,2],key:"U",c_en:"U"},V:{m:[5,3],key:"V",c_en:"V"},W:{m:[5,4],key:"W",c_en:"W"},X:{m:[5,5],key:"X",c_en:"X"},Y:{m:[5,6],key:"Y",c_en:"Y"},Z:{m:[5,7],key:"Z",c_en:"Z"},SHIFT:{m:[6,0],key:"SHIFT",c_en:"SHF"},CONTROL:{m:[6,1],key:"CONTROL",c_en:"CTR"},CAPSLOCK:{m:[6,3],key:"CAPSLOCK",c_en:"CAP"},GRAPH:{m:[6,2],key:"GRAPH",c_en:"GRA"},CODE:{m:[6,4],key:"CODE",c_en:"COD",c_ja:"KANA",cs_ja:"KANA"},F1:{m:[6,5],key:"F1",c_en:"F1",cs_en:"F6"},F2:{m:[6,6],key:"F2",c_en:"F2",cs_en:"F7"},F3:{m:[6,7],key:"F3",c_en:"F3",cs_en:"F8"},F4:{m:[7,0],key:"F4",c_en:"F4",cs_en:"F9"},F5:{m:[7,1],key:"F5",c_en:"F5",cs_en:"F10"},ESCAPE:{m:[7,2],key:"ESCAPE",c_en:"ESC"},TAB:{m:[7,3],key:"TAB",c_en:"TAB"},STOP:{m:[7,4],key:"STOP",c_en:"STP"},BACKSPACE:{m:[7,5],key:"BACKSPACE",c_en:"BS"},SELECT:{m:[7,6],key:"SELECT",c_en:"SEL"},ENTER:{m:[7,7],key:"ENTER",c_en:"RET"},SPACE:{m:[8,0],key:"SPACE",c_en:"SPC"},HOME:{m:[8,1],key:"HOME",c_en:"HOM"},INSERT:{m:[8,2],key:"INSERT",c_en:"INS"},DELETE:{m:[8,3],key:"DELETE",c_en:"DEL"},LEFT:{m:[8,4],key:"LEFT",c_en:"LFT"},UP:{m:[8,5],key:"UP",c_en:"UP"},DOWN:{m:[8,6],key:"DOWN",c_en:"DWN"},RIGHT:{m:[8,7],key:"RIGHT",c_en:"RGH"},NUM_MULTIPLY:{m:[9,0],key:"NUM_MULTIPLY",c_en:"*"},NUM_PLUS:{m:[9,1],key:"NUM_PLUS",c_en:"+"},NUM_DIVIDE:{m:[9,2],key:"NUM_DIVIDE",c_en:"/"},NUM_0:{m:[9,3],key:"NUM_0",c_en:"0"},NUM_1:{m:[9,4],key:"NUM_1",c_en:"1"},NUM_2:{m:[9,5],key:"NUM_2",c_en:"2"},NUM_3:{m:[9,6],key:"NUM_3",c_en:"3"},NUM_4:{m:[9,7],key:"NUM_4",c_en:"4"},NUM_5:{m:[10,0],key:"NUM_5",c_en:"5"},NUM_6:{m:[10,1],key:"NUM_6",c_en:"6"},NUM_7:{m:[10,2],key:"NUM_7",c_en:"7"},NUM_8:{m:[10,3],key:"NUM_8",c_en:"8"},NUM_9:{m:[10,4],key:"NUM_9",c_en:"9"},NUM_MINUS:{m:[10,5],key:"NUM_MINUS",c_en:"-"},NUM_COMMA:{m:[10,6],key:"NUM_COMMA",c_en:","},NUM_PERIOD:{m:[10,7],key:"NUM_PERIOD",c_en:"."},YES:{m:[11,1],key:"YES",c_en:"YES",c_ja:"HAI",cs_ja:"HAI"},NO:{m:[11,3],key:"NO",c_en:"NO",c_ja:"IIE",cs_ja:"IIE"}},wmsx.JoystickButtons={J_UP:{button:"J_UP",mask:1,n:"UP"},J_DOWN:{button:"J_DOWN",mask:2,n:"DOWN"},J_LEFT:{button:"J_LEFT",mask:4,n:"LEFT"},J_RIGHT:{button:"J_RIGHT",mask:8,n:"RIGHT"},J_A:{button:"J_A",mask:16,n:"A"},J_B:{button:"J_B",mask:32,n:"B"},J_AB:{button:"J_AB",mask:48,n:"AB"},J_X:{button:"J_X",n:"X"},J_Y:{button:"J_Y",n:"Y"},J_L:{button:"J_L",n:"L"},J_R:{button:"J_R",n:"R"},J_BACK:{button:"J_BACK",n:"BACK"},J_START:{button:"J_START",n:"START"}},wmsx.MachineControls={POWER:51,POWER_OFF:53,DEBUG:101,TRACE:102,PAUSE:103,PAUSE_CPU:104,FRAME:105,FAST_SPEED:111,INC_SPEED:113,DEC_SPEED:114,NORMAL_SPEED:115,MIN_SPEED:116,SPRITE_MODE:121,VIDEO_STANDARD:123,VSYNCH:124,CPU_CLOCK_MODE:125,Z80_CLOCK_MODE:126,R800_CLOCK_MODE:127,VDP_CLOCK_MODE:128,DEFAULTS:130,SAVE_STATE_0:256,SAVE_STATE_1:257,SAVE_STATE_2:258,SAVE_STATE_3:259,SAVE_STATE_4:260,SAVE_STATE_5:261,SAVE_STATE_6:262,SAVE_STATE_7:263,SAVE_STATE_8:264,SAVE_STATE_9:265,SAVE_STATE_10:266,SAVE_STATE_11:267,SAVE_STATE_12:268,LOAD_STATE_0:512,LOAD_STATE_1:513,LOAD_STATE_2:514,LOAD_STATE_3:515,LOAD_STATE_4:516,LOAD_STATE_5:517,LOAD_STATE_6:518,LOAD_STATE_7:519,LOAD_STATE_8:520,LOAD_STATE_9:521,LOAD_STATE_10:522,LOAD_STATE_11:523,LOAD_STATE_12:524,SAVE_STATE_FILE:201,TYPE_STRING:301},wmsx.Images={embedded:!1,count:5,urls:{logo:WMSX.IMAGES_PATH+"logo.png",sprites:WMSX.IMAGES_PATH+"sprites.png",loading:WMSX.IMAGES_PATH+"loading.gif",mouseCursor:WMSX.IMAGES_PATH+"mouse-cursor.png",logoMiniBrightBack:WMSX.IMAGES_PATH+"logo-mini-bright-back.png"}},WMSX.userPreferences={},WMSX.userPreferences.currentVersion=60,WMSX.userPreferences.compatibleVersions=new Set([60,50]),WMSX.userPreferences.defaults=function(){"use strict";var a=wmsx.KeyboardKeys,b=wmsx.JoystickButtons,c=wmsx.DOMKeys,d=wmsx.GamepadButtons;return{hostKeyboard:{en:void 0,ja:void 0},customHostKeyboards:{en:{},ja:{}},customHostKeys:{nextCode:1001,keys:[]},joysticks:[{buttons:{J_UP:[d.GB_UP],J_DOWN:[d.GB_DOWN],J_LEFT:[d.GB_LEFT],J_RIGHT:[d.GB_RIGHT],J_A:[d.GB_1,d.GB_3],J_B:[d.GB_2,d.GB_3],J_X:[],J_Y:[],J_L:[d.GB_L1,d.GB_L2],J_R:[d.GB_R1,d.GB_R2],J_BACK:[d.GB_BACK],J_START:[d.GB_START]},virtualButtonsKeys:{J_X:[],J_Y:[],J_L:[{wc:c.VK_F12.wc|c.SHIFT,n:["Shift","F12"]}],J_R:[c.VK_F12],J_BACK:[c.VK_ESCAPE],J_START:[{wc:c.VK_P.wc|c.ALT,n:["Alt","P"]}]},settings:{device:-1,xAxis:0,xAxisSig:1,yAxis:1,yAxisSig:1,deadzone:.3}},{buttons:{J_UP:[d.GB_UP],J_DOWN:[d.GB_DOWN],J_LEFT:[d.GB_LEFT],J_RIGHT:[d.GB_RIGHT],J_A:[d.GB_1,d.GB_3],J_B:[d.GB_2,d.GB_3],J_X:[],J_Y:[],J_L:[d.GB_L1,d.GB_L2],J_R:[d.GB_R1,d.GB_R2],J_BACK:[d.GB_BACK],J_START:[d.GB_START]},virtualButtonsKeys:{J_X:[],J_Y:[],J_L:[{wc:c.VK_F12.wc|c.SHIFT,n:["Shift","F12"]}],J_R:[c.VK_F12],J_BACK:[c.VK_ESCAPE],J_START:[{wc:c.VK_P.wc|c.ALT,n:["Alt","P"]}]},settings:{device:-1,xAxis:0,xAxisSig:1,yAxis:1,yAxisSig:1,deadzone:.3}}],joykeys:[{buttons:{J_UP:[c.VK_UP],J_DOWN:[c.VK_DOWN],J_LEFT:[c.VK_LEFT],J_RIGHT:[c.VK_RIGHT],J_A:[c.VK_SPACE,c.VK_LSHIFT,c.VK_INSERT],J_B:[c.VK_M,c.VK_LCONTROL,c.VK_DELETE]}},{buttons:{J_UP:[c.VK_T],J_DOWN:[c.VK_G],J_LEFT:[c.VK_F],J_RIGHT:[c.VK_H],J_A:[c.VK_A],J_B:[c.VK_Z]}}],touch:{directional:"JOYSTICK",directionalBig:!1,mirrored:!1,buttons:{T_A:b.J_A,T_B:b.J_B,T_C:b.J_AB,T_D:a.ESCAPE,T_E:a.SPACE,T_F:a.F1,T_G:a.ENTER,T_X:null,T_Y:null}},vSynch:1,crtFilter:-1,crtScanlines:0,hapticFeedback:!0,audioBufferBase:-1,netPlaySessionName:"",netPlayNick:"",syncTimeLoadState:!1}},WMSX.userPreferences.load=function(){var a;try{a=JSON.parse(localStorage["wmsxprefs"+this.getEnvSuffix()]||"{}"),a.version&&delete a.version}catch(a){}if(!a||!WMSX.userPreferences.compatibleVersions.has(a.prefsVersion)){a={}}var b=WMSX.userPreferences.defaults();for(var c in b)void 0===a[c]&&(a[c]=b[c]);a.prefsVersion=WMSX.userPreferences.currentVersion,WMSX.userPreferences.current=a,wmsx.DOMKeys.initPreferences()},WMSX.userPreferences.save=function(){if(WMSX.userPreferences.isDirty)try{WMSX.userPreferences.current.wmsxVersion=WMSX.VERSION,localStorage["wmsxprefs"+this.getEnvSuffix()]=JSON.stringify(WMSX.userPreferences.current),delete WMSX.userPreferences.isDirty,wmsx.Util.log("Preferences saved!")}catch(a){}},WMSX.userPreferences.getEnvSuffix=function(){return void 0===this.envSuffix&&(this.envSuffix=WMSX.ENVIRONMENT?"_"+WMSX.ENVIRONMENT:""),this.envSuffix},WMSX.userPreferences.setDirty=function(){WMSX.userPreferences.isDirty=!0},WMSX.userROMFormats={init:function(){wmsx.SlotCreator.setUserROMFormats(this),this.userFormats=JSON.parse(localStorage.wmsxuserformats||"{}")},getForROM:function(a){return this.userFormats[a.info.h]},setForROM:function(a,b,c){
a.info.h&&(c?delete this.userFormats[a.info.h]:this.userFormats[a.info.h]=b,localStorage.wmsxuserformats=JSON.stringify(this.userFormats))}},wmsx.Clock=function(clockPulse){"use strict";this.connect=function(a){a.connectClock(this)},this.go=function(){running||(useRequestAnimationFrame=vSynch&&cyclesPerSecond===this.getVSynchNativeFrequency(),running=!0,useRequestAnimationFrame?animationFrame=requestAnimationFrame(pulse):interval=setInterval(pulse,cycleTimeMs))},this.pause=function(){running=!1,animationFrame&&(cancelAnimationFrame(animationFrame),animationFrame=null),interval&&(clearInterval(interval),interval=null)},this.setFrequency=function(a,b){running?(this.pause(),internalSetFrequency(a,b),this.go()):internalSetFrequency(a,b)},this.setVSynch=function(a){running?(this.pause(),vSynch=a,this.go()):vSynch=a},this.getVSynchNativeFrequency=function(){return vSynchAltNativeFrequency||vSynchNativeFrequency},this.setVSynchAltNativeFrequency=function(a){vSynchAltNativeFrequency=a},this.isVSynchActive=function(){return useRequestAnimationFrame},this.getRealTime=function(){return Date.now()-60*(new Date).getTimezoneOffset()*1e3};var internalSetFrequency=function(a,b){cyclesPerSecond=a,cycleTimeMs=1e3/a,divider=b>=1?b:1,dividerCounter>divider&&(dividerCounter=divider)},pulse=function(){animationFrame=null,divider>1?--dividerCounter<=0&&(dividerCounter=divider,clockPulse()):clockPulse(),useRequestAnimationFrame&&!animationFrame&&(animationFrame=requestAnimationFrame(pulse))};this.detectHostNativeFPSAndCallback=function(a){function b(){vSynchNativeFrequency=-1,wmsx.Util.error("Could not detect video native frequency. VSync DISABLED!"),a&&a(vSynchNativeFrequency)}if(-1===WMSX.SCREEN_VSYNC_MODE)return wmsx.Util.warning("Video native VSync disabled in configuration"),void(a&&a(vSynchNativeFrequency));if(-1!==WMSX.SCREEN_FORCE_HOST_NATIVE_FPS)return wmsx.Util.warning("Host video frequency forced in configuration: "+WMSX.SCREEN_FORCE_HOST_NATIVE_FPS),void(a&&a(vSynchNativeFrequency));if(!window.requestAnimationFrame)return b();var c=0,d=0,e=0,f=0,g=0,h=0,i=function(){if(e>=12||f>=18||g>=14||h>=18)return vSynchNativeFrequency=e>=12?60:f>=18?50:g>=14?120:100,wmsx.Util.log("Video native frequency detected: "+vSynchNativeFrequency+"Hz"),void(a&&a(vSynchNativeFrequency));if(!(++c<=70))return b();var j=wmsx.Util.performanceNow(),k=1e3/(j-d);d=j,k>=47&&k<=53&&f++,k>=56.4&&k<=63.6&&e++,k>=112.8&&k<=127.2&&g++,k>=94&&k<=106&&h++,requestAnimationFrame(i)};i()},this.eval=function(str){return eval(str)};var running=!1,cyclesPerSecond=1,cycleTimeMs=1e3,divider=1,dividerCounter=1,useRequestAnimationFrame,animationFrame=null,interval=null,vSynch=!0,vSynchNativeFrequency=-1===WMSX.SCREEN_VSYNC_MODE?-1:WMSX.SCREEN_FORCE_HOST_NATIVE_FPS,vSynchAltNativeFrequency=void 0},wmsx.FileLoader=function(a){"use strict";function b(a,b,c,d,e){return z.loadAsDiskFromFiles(c,a,p.createTreeFromZip(b),d,e)}function c(a,b,c,d){return z.loadAsDiskFromFiles(b,null,a,c,d)}function d(a,b,c,d,f,g,h){if((b===P.DISK||b===P.AUTO)&&z.loadDiskStackFromFiles(c,a,d,f,h))return!0;if(b!==P.DISK)for(var i=0;i<a.length;i++)if(e(a[i],b,c,d,f,g,h))return!0;return!1}function e(a,b,c,d,g,h,i,j){try{i&&!a.content&&(a.content=a.asUint8Array());var k=a.content;if(!j){var l=wmsx.Util.checkContentIsZIP(k);if(l){for(var m=wmsx.Util.getZIPFilesSorted(l),n=0;n<m.length;n++)if(e(m[n],b,c,d,g,h,!0,!0))return!0;return!1}}var o=wmsx.Util.checkContentIsGZIP(k);if(o)return e({name:a.name,content:o},b,c,d,g,h,!1,!0)}catch(a){return wmsx.Util.error(a),!1}return f(a.name,k,b,c,d,g,h)}function f(a,b,c,d,e,f,g){if(c=c||P.AUTO,d=d<0?-d:void 0===d?0:d,(c===P.TAPE||c===P.AUTO)&&y.loadTapeFile(a,b,e))return!0;if((c===P.STATE||c===P.AUTO)&&u.loadStateFile(b))return!0;if((c===P.CART_DATA||c===P.AUTO)&&x.loadCartridgeData(d,a,b))return!0;if(c===P.ROM||c===P.AUTO){var h=wmsx.SlotCreator.createFromROM(new wmsx.ROM(a,b,null,g),x.cartridgeInserted(d));if(h)return h.format===wmsx.SlotFormats.BIOS?s.insertBIOS(h,e):h.format===wmsx.SlotFormats.MSX2BIOSExt?s.insertBIOSEXT(h,e):f?t.insertExpansion(h,d,e):x.insertCartridge(h,d,e),!0}return!1}function g(a,b,c,d,e,f,g){var h=wmsx.SlotCreator.createFromROM(new wmsx.ROM(a,b,null,e,f));return!!h&&(r.insertSlot(h,c,d,g),!0)}function h(a){if(a.returnValue=!1,a.preventDefault(),a.stopPropagation(),a.target.focus(),this.files&&0!==this.files.length){var b=wmsx.Util.asNormalArray(this.files);try{A.value=""}catch(a){}var c=q.systemPause(!0),d=function(a){c||q.systemPause(!1)};return b&&b.length>0&&(1===b.length?p.readFromFile(b[0],C,G,H,I,d):p.readFromFiles(b,C,G,H,I,d)),!1}}function i(a){if(a.returnValue=!1,a.preventDefault(),a.stopPropagation(),!J&&a.dataTransfer){var b=(a.shiftKey?L:0)|(a.ctrlKey?M:0)|(a.altKey?N:0)|(a.buttons&K?O:0);j(a.target,b),a.dataTransfer.dropEffect=!D||D.disabled?"none":"link",F&&clearTimeout(F),F=setTimeout(k,250)}}function j(a,b){if(a&&w.mediaChangeDisabledWarning())a=void 0;else for(;a&&!a.wmsxDropInfo;)a=a.parentElement;if(a){var c=a.wmsxDropInfo;c.subFiles&&b&N?c=c.subFiles:c.subAdd&&b&M&&(c=c.subAdd)}if(D!==c||E!==b){if(D!==c){if(D){D.element.classList.remove("wmsx-selected");var d=D.mainEle;d&&d.classList.remove("wmsx-selected")}D=c,D&&(D.element.classList.add("wmsx-selected"),(d=D.mainEle)&&d.classList.add("wmsx-selected"))}E=b;var e;D&&(e=b&L&&D.mesSec?D.mesSec:D.mes,D.files&&b&M&&(e+=" (do not expand ZIP contents)"),b&O&&(e+=" - no Reset")),v.setFileLoaderDragMessage(e)}}function k(){j(void 0,0),F=void 0}function l(a){if(a.returnValue=!1,a.preventDefault(),a.target.focus(),J||!D||D.disabled||!a.dataTransfer)return k();var b=D,c=E;k();var d=c&O,e=b.files||c&N,f=b.add||c&M,g=void 0!==b.port?b.port:c&L?-1:void 0,h=b.openType;!e||h!==P.DISK&&h!==P.AUTO||(h=f?P.FILES_AS_DISK:P.AUTO_AS_DISK);var i=a.dataTransfer&&a.dataTransfer.files,j=q.systemPause(!0),l=function(a){j||q.systemPause(!1)};if(i&&i.length>0)1===i.length?p.readFromFile(i[0],h,g,d,f,l):p.readFromFiles(i,h,g,d,f,l);else{var m=a.dataTransfer.getData("text");m&&m.length>0?p.readFromURL(m,h,g,d,f,l):l()}}function m(a){if(!a||!a.trim())return a;var b=a.lastIndexOf(".");return(b>0?a.substring(0,b):a).trim()}function n(a){wmsx.Util.message("Could not load file(s):\n\n"+a+"\n")}function o(){A=document.createElement("input"),A.id="wmsx-file-loader-input",A.type="file",A.multiple=!0,A.accept=Q.AUTO,A.style.display="none",A.addEventListener("change",h),B.appendChild(A)}var p=this;this.connect=function(a){q=a,r=q.getSlotSocket(),s=q.getBIOSSocket(),q.getExtensionsSocket().connectFileLoader(this),t=q.getExpansionSocket(),u=q.getSavestateSocket()},this.connectPeripherals=function(a,b,c,d,e){v=a,w=b,x=c,y=d,z=e},this.registerForDnD=function(a){a.addEventListener("dragover",i,!1),a.addEventListener("drop",l,!1)},this.registerForDnDReject=function(a){a.addEventListener("dragover",function(a){a.returnValue=!1,a.preventDefault(),a.stopPropagation(),a.dataTransfer&&(a.dataTransfer.dropEffect="none")},!1)},this.registerForFileInputElement=function(a){B=a},this.openFileChooserDialog=function(a,b,c,d){A||o(),A.multiple=R[P[a]||P.AUTO]&&!(a===P.DISK&&2===c),A.accept=Q[P[a]||P.AUTO],C=a,G=c,H=b,I=d,A.click()},this.openURLChooserDialog=function(a,b,c,d){var e;try{e=localStorage&&localStorage[T]}catch(a){}var f=q.systemPause(!0);if(e=prompt("Load file from URL:",e||""),e=e&&e.toString().trim()){try{localStorage[T]=e}catch(a){}this.readFromURL(e,a,c,b,d,function(){f||q.systemPause(!1)})}else f||q.systemPause(!1)},this.readFromFile=function(a,b,c,d,e,f){wmsx.Util.log("Reading file: "+a.name);var g=new FileReader;g.onload=function(g){var h=new Uint8Array(g.target.result),i={name:a.name,content:h,lastModifiedDate:a.lastModified?new Date(a.lastModified):a.lastModifiedDate};p.loadFromFile(i,b,c,d,e),f&&f(!0)},g.onerror=function(a){n("File reading error: "+a.target.error.name+U),f&&f(!1)},g.readAsArrayBuffer(a)},this.readFromURL=function(a,b,c,d,e,f){
new wmsx.MultiDownloader([{url:a}],function(g){var h={name:a,content:g[0].content,lastModifiedDate:null};p.loadFromFile(h,b,c,d,e),f&&f(!0)},function(a){n("URL reading error: "+a.error),f&&f(!1)}).start()},this.readFromFiles=function(a,b,c,d,e,f){new wmsx.MultiFileReader(a,function(a){p.loadFromFiles(a,b,c,d,e),f&&f(!0)},function(a,b,c){c||(b+=U),n("File reading error: "+b),f&&f(!1)},b===P.AUTO_AS_DISK||b===P.FILES_AS_DISK||b===P.ZIP_AS_DISK?-1:void 0).start()},this.loadFromContent=function(a,b,c,d,e,f,g){return this.loadFromFile({name:a,content:b},c,d,e,f,g)},this.loadFromFile=function(a,e,f,g,h,i){var j,k;if(e===P.AUTO_AS_DISK||e===P.FILES_AS_DISK||e===P.ZIP_AS_DISK){try{if(e===P.FILES_AS_DISK){if(c([a],f,g,h))return}else if(j=wmsx.Util.checkContentIsZIP(a.content)){if(b(m(a.name),j,f,g,h))return}else if(e===P.ZIP_AS_DISK)k="Not a ZIP file!";else if(c([a],f,g,h))return}catch(a){a.wmsx&&(k=a.message)}n("Error loading "+S[e]+(k?": "+k:""))}else{if(j=wmsx.Util.checkContentIsZIP(a.content))try{if(d(wmsx.Util.getZIPFilesSorted(j),e,f,g,h,i,!0))return;if(e===P.AUTO&&b(m(a.name),j,f,g,h))return}catch(a){wmsx.Util.error(a)}else if(d([a],e,f,g,h,i,!1))return;n("No valid "+S[e]+" found.")}},this.loadFromFiles=function(a,b,e,f,g){if(a=wmsx.Util.asNormalArray(a).slice(0),a.sort(function(a,b){return a.name<b.name?-1:a.name>b.name?1:0}),b===P.AUTO_AS_DISK||b===P.FILES_AS_DISK||b===P.ZIP_AS_DISK){var h;try{if(c(a,e,f,g))return}catch(a){a.wmsx&&(h=a.message)}n("Error loading "+S[b]+(h?": "+h:""))}else{if(d(a,b,e,f,g,null,!1))return;n("No valid "+S[b]+" found.")}},this.loadFromContentAsSlot=function(a,b,c,d,e,f,h){var i=wmsx.Util.checkContentIsZIP(b);if(i)try{for(var j=wmsx.Util.getZIPFilesSorted(i),k=0;k<j.length;k++)if(g(a,j[k].asUint8Array(),c,d,e,f,h))return}catch(a){}else if(g(a,b,c,d,e,f,h))return;n("Unsupported ROM file!")},this.createTreeFromZip=function(a){var b=[],c=a.folder(/.+/);c=c.filter(function(a){return a.dir&&a.name&&a.name.trim()}),c.sort(function(a,b){return void 0===a.dirDepth&&(a.dirDepth=wmsx.Util.stringCountOccurrences(a.name,"/")),void 0===b.dirDepth&&(b.dirDepth=wmsx.Util.stringCountOccurrences(b.name,"/")),a.dirDepth-b.dirDepth});for(var d=0;d<c.length;++d)!function(a){for(var c=a.name.split("/"),d=b,e=0;e<c.length-1;++e){var f=c[e],g=d.find(function(a){return a.isDir&&a.name==f});g||(g={isDir:!0,name:f,lastModifiedDate:a.date,items:[]},d.push(g)),d=g.items}}(c[d]);for(var e=a.file(/.+/).filter(function(a){return!a.dir&&a.name&&a.name.trim()}),f=0;f<e.length;++f)!function(a){for(var c=a.name.split("/"),d=b,e=0;e<c.length-1;++e){var f=c[e],g=d.find(function(a){return a.isDir&&a.name==f});g||(g={isDir:!0,name:f,lastModifiedDate:a.date,items:[]},d.push(g)),d=g.items}var h=c[c.length-1];h&&h.trim()&&(a.name=h,a.isDir=!1,a.lastModifiedDate=a.date,a.content=a.asUint8Array(),d.push(a))}(e[f]);return b},this.setDragAndDropDisabled=function(a){J=!!a};var q,r,s,t,u,v,w,x,y,z,A,B,C,D,E,F,G=0,H=!1,I=!1,J=!1,K=2,L=1,M=2,N=4,O=8,P=wmsx.FileLoader.OPEN_TYPE;this.OPEN_TYPE=P;var Q={ROM:".bin,.BIN,.rom,.ROM,.bios,.BIOS,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP",DISK:".bin,.BIN,.dsk,.DSK,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP",TAPE:".bin,.BIN,.cas,.CAS,.tape,.TAPE,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP",STATE:".wst,.WST",CART_DATA:".pac,.PAC,.dat,.DAT,.sram,.SRAM",FILES_AS_DISK:"",ZIP_AS_DISK:".zip,.ZIP",AUTO_AS_DISK:"",AUTO:".bin,.BIN,.dsk,.DSK,.rom,.ROM,.bios,.BIOS,.cas,.CAS,.tape,.TAPE,.wst,.WST,.zip,.ZIP,.gz,.GZ,.gzip,.GZIP"},R={ROM:!1,DISK:!0,TAPE:!1,STATE:!1,CART_DATA:!1,FILES_AS_DISK:!0,ZIP_AS_DISK:!1,AUTO_AS_DISK:!0,AUTO:!1},S={ROM:"ROM",DISK:"Disk",TAPE:"Cassette",STATE:"Savestate",CART_DATA:"Cartridge Data",FILES_AS_DISK:"Files",ZIP_AS_DISK:"ZIP Contents",AUTO_AS_DISK:"Files",AUTO:"ROM, Cassette or Disk"},T="wmsxlasturl",U="\n\nIMPORTANT: Directories are not supported for loading!\nPlease use a ZIP File if you need directories support.";WMSX.fileLoader=this},wmsx.FileLoader.OPEN_TYPE={AUTO:"AUTO",ROM:"ROM",DISK:"DISK",TAPE:"TAPE",STATE:"STATE",CART_DATA:"CART_DATA",FILES_AS_DISK:"FILES_AS_DISK",ZIP_AS_DISK:"ZIP_AS_DISK",AUTO_AS_DISK:"AUTO_AS_DISK"},wmsx.FileDownloader=function(){"use strict";function a(){b=wmsx.Util.isIOSDevice()?"DATA":"BLOB",c=document.createElement("a"),c.style.display="none",c.target="_blank",c.href="#",d.appendChild(c)}this.connectPeripherals=function(a){e=a},this.registerForDownloadElement=function(a){d=a},this.startDownloadBinary=function(d,f,g){try{b||a();var h;if("BLOB"===b){c.href&&(window.URL||window.webkitURL).revokeObjectURL(c.href);var i=new Blob([f],{type:"data:application/octet-stream"});h=(window.URL||window.webkitURL).createObjectURL(i)}else h="data:application/octet-stream;base64,"+btoa("string"==typeof f?f:wmsx.Util.int8BitArrayToByteString(f));return c.download=d&&d.trim(),c.href=h,c.click(),e.showOSD(g+" saved",!0),!0}catch(a){return e.showOSD(g+" save FAILED!",!0,!0),wmsx.Util.error(a),!1}},this.startDownloadURL=function(d,f,g){try{b||a(),"BLOB"===b&&c.href&&(window.URL||window.webkitURL).revokeObjectURL(c.href),c.download=d&&d.trim(),c.href=f,c.click(),e.showOSD(g+" saved",!0)}catch(a){e.showOSD(g+" save FAILED!",!0,!0),wmsx.Util.error(a)}};var b,c,d,e},wmsx.DOMKeys={keys:{},keysByCode:{},keysByLegacyCode:{},SHIFT:65536,CONTROL:131072,ALT:262144,META:524288,LOCLEFT:1048576,LOCRIGHT:2097152,LOCNUM:3145728,LOC_BIT_SHIFT:20,nextCustomCode:10001},wmsx.DOMKeys.IGNORE_ALL_MODIFIERS_MASK=~(wmsx.DOMKeys.SHIFT|wmsx.DOMKeys.CONTROL|wmsx.DOMKeys.ALT|wmsx.DOMKeys.META),wmsx.DOMKeys.addKeyToIdentification=function(a){a.wc&&!a.a&&(this.keys[a.wc]=a,a.d&&(this.keysByCode[a.d]=a),a.c>0&&(this.keysByLegacyCode[a.c]=a))},function(a,b,c,d){a.VK_1={wc:1,d:"Digit1",c:49,n:"1"},a.VK_2={wc:2,d:"Digit2",c:50,n:"2"},a.VK_3={wc:3,d:"Digit3",c:51,n:"3"},a.VK_4={wc:4,d:"Digit4",c:52,n:"4"},a.VK_5={wc:5,d:"Digit5",c:53,n:"5"},a.VK_6={wc:6,d:"Digit6",c:54,n:"6"},a.VK_7={wc:7,d:"Digit7",c:55,n:"7"},a.VK_8={wc:8,d:"Digit8",c:56,n:"8"},a.VK_9={wc:9,d:"Digit9",c:57,n:"9"},a.VK_0={wc:10,d:"Digit0",c:48,n:"0"},a.VK_F1={wc:21,d:"F1",c:112,n:"F1"},a.VK_F2={wc:22,d:"F2",c:113,n:"F2"},a.VK_F3={wc:23,d:"F3",c:114,n:"F3"},a.VK_F4={wc:24,d:"F4",c:115,n:"F4"},a.VK_F5={wc:25,d:"F5",c:116,n:"F5"},a.VK_F6={wc:26,d:"F6",c:117,n:"F6"},a.VK_F7={wc:27,d:"F7",c:118,n:"F7"},a.VK_F8={wc:28,d:"F8",c:119,n:"F8"},a.VK_F9={wc:29,d:"F9",c:120,n:"F9"},a.VK_F10={wc:30,d:"F10",c:121,n:"F10"},a.VK_F11={wc:31,d:"F11",c:122,n:"F11"},a.VK_F12={wc:32,d:"F12",c:123,n:"F12"},a.VK_Q={wc:101,d:"KeyQ",c:81,n:"Q"},a.VK_W={wc:102,d:"KeyW",c:87,n:"W"},a.VK_E={wc:103,d:"KeyE",c:69,n:"E"},a.VK_R={wc:104,d:"KeyR",c:82,n:"R"},a.VK_T={wc:105,d:"KeyT",c:84,n:"T"},a.VK_Y={wc:106,d:"KeyY",c:89,n:"Y"},a.VK_U={wc:107,d:"KeyU",c:85,n:"U"},a.VK_I={wc:108,d:"KeyI",c:73,n:"I"},a.VK_O={wc:109,d:"KeyO",c:79,n:"O"},a.VK_P={wc:110,d:"KeyP",c:80,n:"P"},a.VK_A={wc:111,d:"KeyA",c:65,n:"A"},a.VK_S={wc:112,d:"KeyS",c:83,n:"S"},a.VK_D={wc:113,d:"KeyD",c:68,n:"D"},a.VK_F={wc:114,d:"KeyF",c:70,n:"F"},a.VK_G={wc:115,d:"KeyG",c:71,n:"G"},a.VK_H={wc:116,d:"KeyH",c:72,n:"H"},a.VK_J={wc:117,d:"KeyJ",c:74,n:"J"},a.VK_K={wc:118,d:"KeyK",c:75,n:"K"},a.VK_L={wc:119,d:"KeyL",c:76,n:"L"},a.VK_Z={wc:120,d:"KeyZ",c:90,n:"Z"},a.VK_X={wc:121,d:"KeyX",c:88,n:"X"},a.VK_C={wc:122,d:"KeyC",c:67,n:"C"},a.VK_V={wc:123,d:"KeyV",c:86,n:"V"},a.VK_B={wc:124,d:"KeyB",c:66,n:"B"},a.VK_N={wc:125,d:"KeyN",c:78,n:"N"},a.VK_M={wc:126,d:"KeyM",c:77,n:"M"},a.VK_ESCAPE={wc:201,d:"Escape",c:27,n:"Esc",fn:!0},a.VK_BACKSPACE={wc:202,d:"Backspace",c:8,n:"BackSpc",fn:!0},a.VK_TAB={wc:203,d:"Tab",c:9,n:"Tab",fn:!0},a.VK_ENTER={wc:204,d:"Enter",c:13,n:"Enter",fn:!0},a.VK_SPACE={wc:205,d:"Space",c:32,n:"Space",fn:!0},a.VK_BACKQUOTE={wc:221,d:"Backquote",c:192,n:"`"},a.VK_MINUS={wc:222,d:"Minus",c:189,n:"-"},a.VK_EQUALS={wc:223,d:"Equal",c:187,n:"="},a.VK_INT_YEN={wc:224,d:"IntlYen",c:-1,n:"Int ¥"},a.VK_OPEN_BRACKET={wc:225,d:"BracketLeft",c:219,n:"["},a.VK_CLOSE_BRACKET={
wc:226,d:"BracketRight",c:221,n:"]"},a.VK_SEMICOLON={wc:227,d:"Semicolon",c:186,n:";"},a.VK_QUOTE={wc:228,d:"Quote",c:222,n:"'"},a.VK_BACKSLASH={wc:229,d:"Backslash",c:220,n:"\\"},a.VK_INT_BACKSLASH={wc:230,d:"IntlBackslash",c:226,n:"Int \\"},a.VK_COMMA={wc:231,d:"Comma",c:188,n:","},a.VK_PERIOD={wc:232,d:"Period",c:190,n:"."},a.VK_SLASH={wc:233,d:"Slash",c:191,n:"/"},a.VK_INT_RO={wc:234,d:"IntlRo",c:193,n:"Int ろ"},a.VK_INSERT={wc:251,d:"Insert",c:45,n:"Ins",fn:!0},a.VK_DELETE={wc:252,d:"Delete",c:46,n:"Del",fn:!0},a.VK_HOME={wc:253,d:"Home",c:36,n:"Home",fn:!0},a.VK_END={wc:254,d:"End",c:35,n:"End",fn:!0},a.VK_PAGE_UP={wc:255,d:"PageUp",c:33,n:"PgUp",fn:!0},a.VK_PAGE_DOWN={wc:256,d:"PageDown",c:34,n:"PgDown",fn:!0},a.VK_UP={wc:271,d:"ArrowUp",c:38,n:"Up",fn:!0},a.VK_DOWN={wc:272,d:"ArrowDown",c:40,n:"Down",fn:!0},a.VK_LEFT={wc:273,d:"ArrowLeft",c:37,n:"Left",fn:!0},a.VK_RIGHT={wc:274,d:"ArrowRight",c:39,n:"Right",fn:!0},a.VK_PRINT_SCREEN={wc:281,d:"PrintScreen",c:44,n:"PrtScr",fn:!0},a.VK_SCROLL_LOCK={wc:282,d:"ScrollLock",c:145,n:"ScrLck",fn:!0},a.VK_PAUSE={wc:283,d:"Pause",c:19,n:"Pause",fn:!0},a.VK_BREAK={wc:284,d:"",c:3,n:"Break",fn:!0},a.VK_CONTEXT={wc:285,d:"ContextMenu",c:93,n:"Context",fn:!0},a.VK_LSHIFT={wc:301,d:"ShiftLeft",c:16|b,n:"L-Shift",fn:!0},a.VK_LCONTROL={wc:302,d:"ControlLeft",c:17|b,n:"L-Control",fn:!0},a.VK_LALT={wc:303,d:"AltLeft",c:18|b,n:"L-Alt",fn:!0},a.VK_LMETA={wc:304,d:"MetaLeft",c:91|b,n:"L-Meta",fn:!0},a.VK_RSHIFT={wc:305,d:"ShiftRight",c:16|c,n:"R-Shift",fn:!0},a.VK_RCONTROL={wc:306,d:"ControlRight",c:17|c,n:"R-Control",fn:!0},a.VK_RALT={wc:307,d:"AltRight",c:18|c,n:"R-Alt",fn:!0},a.VK_RMETA={wc:308,d:"MetaRight",c:91|c,n:"R-Meta",fn:!0},a.VK_CAPS_LOCK={wc:309,d:"CapsLock",c:20,n:"CapsLock",fn:!0},a.VK_NON_CONVERT={wc:310,d:"NonConvert",c:29,n:"NonConvert",fn:!0},a.VK_CONVERT={wc:311,d:"Convert",c:28,n:"Convert",fn:!0},a.VK_KANA={wc:312,d:"KanaMode",c:-1,n:"Kana",fn:!0},a.VK_NUMLOCK={wc:401,d:"NumLock",c:144,n:"NumLock"},a.VK_NUM_COMMA={wc:402,d:"NumpadComma",c:110|d,n:"Num ,"},a.VK_NUM_DIVIDE={wc:403,d:"NumpadDivide",c:111|d,n:"Num /"},a.VK_NUM_MULTIPLY={wc:404,d:"NumpadMultiply",c:106|d,n:"Num *"},a.VK_NUM_MINUS={wc:405,d:"NumpadSubtract",c:109|d,n:"Num -"},a.VK_NUM_PLUS={wc:406,d:"NumpadAdd",c:107|d,n:"Num +"},a.VK_NUM_ENTER={wc:407,d:"NumpadEnter",c:13|d,n:"Num Enter",fn:!0},a.VK_NUM_PERIOD={wc:408,d:"NumpadDecimal",c:194|d,n:"Num .",fn:!0},a.VK_NUM_1={wc:421,d:"Numpad1",c:97|d,n:"Num 1",fn:!0},a.VK_NUM_2={wc:422,d:"Numpad2",c:98|d,n:"Num 2",fn:!0},a.VK_NUM_3={wc:423,d:"Numpad3",c:99|d,n:"Num 3",fn:!0},a.VK_NUM_4={wc:424,d:"Numpad4",c:100|d,n:"Num 4",fn:!0},a.VK_NUM_5={wc:425,d:"Numpad5",c:101|d,n:"Num 5",fn:!0},a.VK_NUM_6={wc:426,d:"Numpad6",c:102|d,n:"Num 6",fn:!0},a.VK_NUM_7={wc:427,d:"Numpad7",c:103|d,n:"Num 7",fn:!0},a.VK_NUM_8={wc:428,d:"Numpad8",c:104|d,n:"Num 8",fn:!0},a.VK_NUM_9={wc:429,d:"Numpad9",c:105|d,n:"Num 9",fn:!0},a.VK_NUM_0={wc:430,d:"Numpad0",c:96|d,n:"Num 0",fn:!0},a.VK_VOID={wc:-1,d:"",c:-1,n:"Unbound",fn:!0},a.VK_BR_QUOTE={wc:221,d:"Backquote",c:192,n:"'",a:"BR"},a.VK_BR_ACUTE={wc:225,d:"BracketLeft",c:219,n:"´",a:"BR"},a.VK_BR_OPEN_BRACKET={wc:226,d:"BracketRight",c:221,n:"[",a:"BR"},a.VK_BR_CEDILLA={wc:227,d:"Semicolon",c:186,n:"Ç",a:"BR"},a.VK_BR_TILDE={wc:228,d:"Quote",c:222,n:"~",a:"BR"},a.VK_BR_CLOSE_BRACKET={wc:229,d:"Backslash",c:220,n:"]",a:"BR"},a.VK_BR_SEMICOLON={wc:233,d:"Slash",c:191,n:";",a:"BR"},a.VK_BR_BACKSLASH={wc:230,d:"IntlBackslash",c:226,n:"\\",a:"BR"},a.VK_BR_SLASH={wc:234,d:"IntlRo",c:193,n:"/",a:"BR"},a.VK_JP_CIRCUMFLEX={wc:223,d:"Equal",c:187,n:"^",a:"JP"},a.VK_JP_YEN={wc:224,d:"IntlYen",c:-1,n:"¥",a:"JP"},a.VK_JP_ARROBA={wc:225,d:"BracketLeft",c:219,n:"@",a:"JP"},a.VK_JP_OPEN_BRACKET={wc:226,d:"BracketRight",c:221,n:"[",a:"JP"},a.VK_JP_COLLON={wc:228,d:"Quote",c:222,n:":",a:"JP"},a.VK_JP_CLOSE_BRACKET={wc:229,d:"Backslash",c:220,n:"]",a:"JP"},a.VK_JP_RO={wc:234,d:"IntlRo",c:193,n:"\\ ろ",a:"JP"},a.VK_JP_NON_CONVERT={wc:310,d:"NonConvert",c:29,n:"NonConvert",fn:!0},a.VK_ES_ORDINAL={wc:221,d:"Backquote",c:192,n:"º",a:"ES"},a.VK_ES_QUOTE={wc:222,d:"Minus",c:189,n:"'",a:"ES"},a.VK_ES_INV_EXCLA={wc:223,d:"Equal",c:187,n:"¡",a:"ES"},a.VK_ES_GRAVE={wc:225,d:"BracketLeft",c:219,n:"`",a:"ES"},a.VK_ES_PLUS={wc:226,d:"BracketRight",c:221,n:"+",a:"ES"},a.VK_ES_ENNE={wc:227,d:"Semicolon",c:186,n:"Ñ",a:"ES"},a.VK_ES_ACUTE={wc:228,d:"Quote",c:222,n:"´",a:"ES"},a.VK_ES_CEDILLA={wc:229,d:"Backslash",c:220,n:"Ç",a:"ES"},a.VK_ES_LESSER={wc:230,d:"IntlBackslash",c:226,n:"<",a:"ES"},a.VK_ES_MINUS={wc:233,d:"Slash",c:191,n:"-",a:"ES"},a.VK_NL_ARROBA={wc:221,d:"Backquote",c:192,n:"@",a:"NL"},a.VK_NL_SLASH={wc:222,d:"Minus",c:189,n:"/",a:"NL"},a.VK_NL_ORDINAL={wc:223,d:"Equal",c:187,n:"°",a:"NL"},a.VK_NL_UMLAUT={wc:225,d:"BracketLeft",c:219,n:"¨",a:"NL"},a.VK_NL_STAR={wc:226,d:"BracketRight",c:221,n:"*",a:"NL"},a.VK_NL_PLUS={wc:227,d:"Semicolon",c:186,n:"+",a:"NL"},a.VK_NL_ACUTE={wc:228,d:"Quote",c:222,n:"´",a:"NL"},a.VK_NL_LESSER={wc:229,d:"Backslash",c:220,n:"<",a:"NL"},a.VK_NL_CLOSE_BRACKET={wc:230,d:"IntlBackslash",c:226,n:"]",a:"NL"},a.VK_NL_MINUS={wc:233,d:"Slash",c:191,n:"-",a:"NL"},a.VK_IT_BACKSLASH={wc:221,d:"Backquote",c:192,n:"\\",a:"IT"},a.VK_IT_QUOTE={wc:222,d:"Minus",c:189,n:"'",a:"IT"},a.VK_IT_GRAVE_I={wc:223,d:"Equal",c:187,n:"ì",a:"IT"},a.VK_IT_GRAVE_E={wc:225,d:"BracketLeft",c:219,n:"è",a:"IT"},a.VK_IT_PLUS={wc:226,d:"BracketRight",c:221,n:"+",a:"IT"},a.VK_IT_GRAVE_O={wc:227,d:"Semicolon",c:186,n:"ò",a:"IT"},a.VK_IT_GRAVE_A={wc:228,d:"Quote",c:222,n:"à",a:"IT"},a.VK_IT_GRAVE_U={wc:229,d:"Backslash",c:220,n:"ù",a:"IT"},a.VK_IT_LESSER={wc:230,d:"IntlBackslash",c:226,n:"<",a:"IT"},a.VK_IT_MINUS={wc:233,d:"Slash",c:191,n:"-",a:"IT"},a.VK_FR_2u={wc:221,d:"Backquote",c:192,n:"²",a:"FR"},a.VK_FR_CLOSE_PARENS={wc:222,d:"Minus",c:189,n:")",a:"FR"},a.VK_FR_EQUAL={wc:223,d:"Equal",c:187,n:"=",a:"FR"},a.VK_FR_A={wc:101,d:"KeyQ",c:81,n:"A",a:"FR"},a.VK_FR_Z={wc:102,d:"KeyW",c:87,n:"Z",a:"FR"},a.VK_FR_CIRCUMFLEX={wc:225,d:"BracketLeft",c:219,n:"^",a:"FR"},a.VK_FR_DOLLAR={wc:226,d:"BracketRight",c:221,n:"$",a:"FR"},a.VK_FR_Q={wc:111,d:"KeyA",c:65,n:"Q",a:"FR"},a.VK_FR_M={wc:227,d:"Semicolon",c:186,n:"M",a:"FR"},a.VK_FR_U_GRAVE={wc:228,d:"Quote",c:222,n:"ù",a:"FR"},a.VK_FR_STAR={wc:229,d:"Backslash",c:220,n:"*",a:"FR"},a.VK_FR_LESSER={wc:230,d:"IntlBackslash",c:226,n:"<",a:"FR"},a.VK_FR_W={wc:120,d:"KeyZ",c:90,n:"W",a:"FR"},a.VK_FR_COMMA={wc:126,d:"KeyM",c:77,n:",",a:"FR"},a.VK_FR_SEMICOLON={wc:231,d:"Comma",c:188,n:";",a:"FR"},a.VK_FR_COLON={wc:232,d:"Period",c:190,n:":",a:"FR"},a.VK_FR_EXCLAMATION={wc:233,d:"Slash",c:191,n:"!",a:"FR"};for(var e in a)a.addKeyToIdentification(a[e])}(wmsx.DOMKeys,wmsx.DOMKeys.LOCLEFT,wmsx.DOMKeys.LOCRIGHT,wmsx.DOMKeys.LOCNUM),wmsx.DOMKeys.isModifierKey=function(a){var b=a.keyCode;return 16===b||17===b||18===b||91===b},wmsx.DOMKeys.codeNewForKeyboardEvent=function(a){var b=this.keysByCode[a.code]||this.keysByLegacyCode[a.keyCode|a.location<<this.LOC_BIT_SHIFT];return b?this.isModifierKey(a)?b.wc:b.wc|(a.shiftKey?this.SHIFT:0)|(a.ctrlKey?this.CONTROL:0)|(a.altKey?this.ALT:0)|(a.metaKey?this.META:0):0},wmsx.DOMKeys.nameForKeyboardEvent=function(a){var b=this.codeNewForKeyboardEvent(a),c=this.keys[b&this.IGNORE_ALL_MODIFIERS_MASK];if(c||a.code||a.keyCode>0){var d=a.keyCode,e=a.key;if(c&&c.fn)e=c.n;else{var f=e&&e.toUpperCase();switch(f&&"UNIDENTIFIED"!==f&&"UNDEFINED"!==f&&"UNKNOWN"!==f?"DEAD"===f&&(e="Dead#"+d):e=a.code||"#"+d,1===e.length?e=e.toUpperCase():e.length>12&&(e=e.substr(0,12)),a.location){case 1:e="L-"+e;break;case 2:e="R-"+e;break;case 3:e="Num "+e}}return c||(wmsx.Util.warning("New Host Key discovered:",a),b=WMSX.userPreferences.current.customHostKeys.nextCode++,c={wc:b,d:a.code||"",c:a.code?0:a.keyCode&this.IGNORE_ALL_MODIFIERS_MASK|a.location<<this.LOC_BIT_SHIFT,n:e},this.addKeyToIdentification(c),
WMSX.userPreferences.current.customHostKeys.keys.push(c),WMSX.userPreferences.setDirty()),(a.shiftKey||a.ctrlKey||a.altKey||a.metaKey)&&(e=[e],a.metaKey&&e.unshift("Meta"),a.altKey&&e.unshift("Alt"),a.ctrlKey&&e.unshift("Ctrl"),a.shiftKey&&e.unshift("Shift")),e}},wmsx.DOMKeys.initPreferences=function(){for(var a=WMSX.userPreferences.current.customHostKeys.keys,b=0,c=a.length;b<c;++b)this.addKeyToIdentification(a[b])},wmsx.GamepadButtons={GB_1:{b:0,n:"1"},GB_2:{b:1,n:"2"},GB_3:{b:2,n:"3"},GB_4:{b:3,n:"4"},GB_L1:{b:4,n:"L1"},GB_R1:{b:5,n:"R1"},GB_L2:{b:6,n:"L2"},GB_R2:{b:7,n:"R2"},GB_BACK:{b:8,n:"BACK"},GB_START:{b:9,n:"START"},GB_S1:{b:10,n:"S1"},GB_S2:{b:11,n:"S2"},GB_UP:{b:12,n:"&#9650;"},GB_DOWN:{b:13,n:"&#9660;"},GB_LEFT:{b:14,n:"&#9668;"},GB_RIGHT:{b:15,n:"&#9658;"},GB_LOGO:{b:16,n:"LOGO"},GB_VOID:{b:-1,n:"Unbound"}},wmsx.TouchControls={directional:"T_DIR",buttons:["T_A","T_B","T_C","T_D","T_E","T_F","T_G","T_X","T_Y"],buttonsLeftSide:["T_X","T_Y"],buttonsRightSide:["T_F","T_D","T_B","T_A","T_C","T_E","T_G"]},function(){var a=wmsx.DOMKeys,b={D0:a.VK_0,D1:a.VK_1,D2:a.VK_2,D3:a.VK_3,D4:a.VK_4,D5:a.VK_5,D6:a.VK_6,D7:a.VK_7,D8:a.VK_8,D9:a.VK_9,MINUS:a.VK_MINUS,EQUAL:a.VK_EQUALS,BACKSLASH:[a.VK_BACKSLASH,a.VK_INT_BACKSLASH,a.VK_INT_YEN],OPEN_BRACKET:a.VK_OPEN_BRACKET,CLOSE_BRACKET:a.VK_CLOSE_BRACKET,SEMICOLON:a.VK_SEMICOLON,QUOTE:a.VK_QUOTE,BACKQUOTE:a.VK_BACKQUOTE,COMMA:a.VK_COMMA,PERIOD:a.VK_PERIOD,SLASH:a.VK_SLASH,DEAD:[a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],A:a.VK_A,B:a.VK_B,C:a.VK_C,D:a.VK_D,E:a.VK_E,F:a.VK_F,G:a.VK_G,H:a.VK_H,I:a.VK_I,J:a.VK_J,K:a.VK_K,L:a.VK_L,M:a.VK_M,N:a.VK_N,O:a.VK_O,P:a.VK_P,Q:a.VK_Q,R:a.VK_R,S:a.VK_S,T:a.VK_T,U:a.VK_U,V:a.VK_V,W:a.VK_W,X:a.VK_X,Y:a.VK_Y,Z:a.VK_Z,SHIFT:[a.VK_LSHIFT,a.VK_RSHIFT],CONTROL:[a.VK_LCONTROL],CAPSLOCK:a.VK_CAPS_LOCK,GRAPH:[a.VK_LALT,a.VK_PAGE_UP],CODE:[a.VK_RALT,a.VK_PAGE_DOWN],F1:a.VK_F1,F2:a.VK_F2,F3:a.VK_F3,F4:a.VK_F4,F5:a.VK_F5,ESCAPE:[a.VK_ESCAPE,{wc:a.VK_BACKQUOTE.wc|a.ALT,n:["Alt","`"]}],TAB:a.VK_TAB,STOP:[a.VK_PAUSE,a.VK_BREAK,a.VK_F9],BACKSPACE:a.VK_BACKSPACE,SELECT:[a.VK_SCROLL_LOCK,a.VK_F10],ENTER:[a.VK_ENTER,a.VK_NUM_ENTER],SPACE:a.VK_SPACE,HOME:[a.VK_HOME,{wc:a.VK_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],INSERT:[a.VK_INSERT,{wc:a.VK_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],DELETE:[a.VK_DELETE,{wc:a.VK_BACKSLASH.wc|a.ALT,n:["Alt","\\"]}],UP:a.VK_UP,DOWN:a.VK_DOWN,RIGHT:a.VK_RIGHT,LEFT:a.VK_LEFT,NUM_MULTIPLY:a.VK_NUM_MULTIPLY,NUM_PLUS:a.VK_NUM_PLUS,NUM_DIVIDE:a.VK_NUM_DIVIDE,NUM_0:a.VK_NUM_0,NUM_1:a.VK_NUM_1,NUM_2:a.VK_NUM_2,NUM_3:a.VK_NUM_3,NUM_4:a.VK_NUM_4,NUM_5:a.VK_NUM_5,NUM_6:a.VK_NUM_6,NUM_7:a.VK_NUM_7,NUM_8:a.VK_NUM_8,NUM_9:a.VK_NUM_9,NUM_MINUS:a.VK_NUM_MINUS,NUM_COMMA:a.VK_NUM_COMMA,NUM_PERIOD:a.VK_NUM_PERIOD,YES:a.VK_VOID,NO:a.VK_VOID},c={};for(var d in b)c[d]=b[d];var e={};for(d in b)e[d]=b[d];e.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_BR_QUOTE.wc|a.ALT,n:["Alt","'"]}],e.BACKSLASH=[a.VK_BR_BACKSLASH,a.VK_INT_YEN],e.OPEN_BRACKET=a.VK_BR_OPEN_BRACKET,e.CLOSE_BRACKET=a.VK_BR_CLOSE_BRACKET,e.SEMICOLON=a.VK_BR_SEMICOLON,e.QUOTE=a.VK_BR_QUOTE,e.BACKQUOTE=a.VK_BR_ACUTE,e.SLASH=a.VK_BR_SLASH,e.DEAD=[a.VK_BR_TILDE,a.VK_BR_CEDILLA,a.VK_RCONTROL,a.VK_END],e.HOME=[a.VK_HOME,{wc:a.VK_BR_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],e.INSERT=[a.VK_INSERT,{wc:a.VK_BR_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],e.DELETE=[a.VK_DELETE,{wc:a.VK_BR_SLASH.wc|a.ALT,n:["Alt","/"]}];var f={};for(d in b)f[d]=b[d];f.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_JP_YEN.wc|a.ALT,n:["Alt","¥"]}],f.EQUAL=a.VK_JP_CIRCUMFLEX,f.BACKSLASH=[a.VK_JP_YEN,a.VK_INT_BACKSLASH],f.OPEN_BRACKET=a.VK_JP_OPEN_BRACKET,f.CLOSE_BRACKET=a.VK_JP_CLOSE_BRACKET,f.QUOTE=a.VK_JP_COLLON,f.BACKQUOTE=a.VK_JP_ARROBA,f.DEAD=[a.VK_JP_RO,a.VK_RCONTROL,a.VK_END],f.CAPSLOCK=a.VK_JP_NON_CONVERT,f.HOME=[a.VK_HOME,{wc:a.VK_JP_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],f.INSERT=[a.VK_INSERT,{wc:a.VK_JP_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],f.DELETE=[a.VK_DELETE,{wc:a.VK_JP_RO.wc|a.ALT,n:["Alt","\\ ろ"]}];var g={};for(d in b)g[d]=b[d];g.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_ES_ORDINAL.wc|a.ALT,n:["Alt","º"]}],g.MINUS=a.VK_ES_MINUS,g.EQUAL=a.VK_ES_INV_EXCLA,g.BACKSLASH=[a.VK_ES_ORDINAL,a.VK_INT_YEN],g.OPEN_BRACKET=a.VK_ES_GRAVE,g.CLOSE_BRACKET=a.VK_ES_PLUS,g.SEMICOLON=a.VK_ES_ENNE,g.QUOTE=a.VK_ES_QUOTE,g.BACKQUOTE=a.VK_ES_ACUTE,g.SLASH=a.VK_ES_LESSER,g.DEAD=[a.VK_ES_CEDILLA,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],g.HOME=[a.VK_HOME,{wc:a.VK_ES_GRAVE.wc|a.ALT,n:["Alt","`"]}],g.INSERT=[a.VK_INSERT,{wc:a.VK_ES_PLUS.wc|a.ALT,n:["Alt","+"]}],g.DELETE=[a.VK_DELETE,{wc:a.VK_ES_CEDILLA.wc|a.ALT,n:["Alt","Ç"]}];var h={};for(d in b)h[d]=b[d];h.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_NL_ARROBA.wc|a.ALT,n:["Alt","@"]}],h.MINUS=a.VK_NL_MINUS,h.EQUAL=a.VK_NL_ORDINAL,h.BACKSLASH=[a.VK_NL_CLOSE_BRACKET,a.VK_INT_YEN],h.OPEN_BRACKET=a.VK_NL_UMLAUT,h.CLOSE_BRACKET=a.VK_NL_STAR,h.SEMICOLON=a.VK_NL_PLUS,h.QUOTE=a.VK_NL_ACUTE,h.BACKQUOTE=a.VK_NL_ARROBA,h.SLASH=a.VK_NL_SLASH,h.DEAD=[a.VK_NL_LESSER,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],h.HOME=[a.VK_HOME,{wc:a.VK_NL_UMLAUT.wc|a.ALT,n:["Alt","¨"]}],h.INSERT=[a.VK_INSERT,{wc:a.VK_NL_STAR.wc|a.ALT,n:["Alt","*"]}],h.DELETE=[a.VK_DELETE,{wc:a.VK_NL_LESSER.wc|a.ALT,n:["Alt","<"]}];var i={};for(d in b)i[d]=b[d];i.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_IT_BACKSLASH.wc|a.ALT,n:["Alt","\\"]}],i.MINUS=a.VK_IT_MINUS,i.EQUAL=a.VK_IT_GRAVE_I,i.BACKSLASH=[a.VK_IT_BACKSLASH,a.VK_INT_YEN],i.OPEN_BRACKET=a.VK_IT_GRAVE_E,i.CLOSE_BRACKET=a.VK_IT_PLUS,i.SEMICOLON=a.VK_IT_GRAVE_O,i.QUOTE=a.VK_IT_QUOTE,i.BACKQUOTE=a.VK_IT_GRAVE_A,i.SLASH=a.VK_IT_LESSER,i.DEAD=[a.VK_IT_GRAVE_U,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],i.HOME=[a.VK_HOME,{wc:a.VK_IT_GRAVE_E.wc|a.ALT,n:["Alt","è"]}],i.INSERT=[a.VK_INSERT,{wc:a.VK_IT_PLUS.wc|a.ALT,n:["Alt","+"]}],i.DELETE=[a.VK_DELETE,{wc:a.VK_IT_GRAVE_U.wc|a.ALT,n:["Alt","ù"]}];var j={};for(d in b)j[d]=b[d];j.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_FR_2u.wc|a.ALT,n:["Alt","²"]}],j.MINUS=a.VK_FR_CLOSE_PARENS,j.BACKSLASH=[a.VK_FR_LESSER,a.VK_INT_YEN],j.Q=a.VK_FR_Q,j.W=a.VK_FR_W,j.OPEN_BRACKET=a.VK_FR_CIRCUMFLEX,j.CLOSE_BRACKET=a.VK_FR_DOLLAR,j.A=a.VK_FR_A,j.SEMICOLON=a.VK_FR_SEMICOLON,j.QUOTE=a.VK_FR_2u,j.BACKQUOTE=a.VK_FR_U_GRAVE,j.Z=a.VK_FR_Z,j.M=a.VK_FR_M,j.COMMA=a.VK_FR_COMMA,j.PERIOD=a.VK_FR_COLON,j.SLASH=a.VK_FR_EXCLAMATION,j.DEAD=[a.VK_FR_STAR,a.VK_RCONTROL,a.VK_END],j.HOME=[a.VK_HOME,{wc:a.VK_FR_DOLLAR.wc|a.ALT,n:["Alt","$"]}],j.INSERT=[a.VK_INSERT,{wc:a.VK_FR_STAR.wc|a.ALT,n:["Alt","*"]}],j.DELETE=[a.VK_DELETE,{wc:a.VK_FR_EXCLAMATION.wc|a.ALT,n:["Alt","!"]}];var k={};for(d in b)k[d]=b[d];k.OPEN_BRACKET=a.VK_BACKQUOTE,k.CLOSE_BRACKET=a.VK_OPEN_BRACKET,k.BACKQUOTE=a.VK_CLOSE_BRACKET;var l={};for(d in b)l[d]=b[d];l.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_BR_QUOTE.wc|a.ALT,n:["Alt","'"]}],l.BACKSLASH=[a.VK_BR_BACKSLASH,a.VK_INT_YEN],l.OPEN_BRACKET=[a.VK_BR_QUOTE,a.VK_BR_ACUTE],l.CLOSE_BRACKET=a.VK_BR_OPEN_BRACKET,l.SEMICOLON=a.VK_BR_SEMICOLON,l.QUOTE=a.VK_BR_CEDILLA,l.BACKQUOTE=a.VK_BR_CLOSE_BRACKET,l.SLASH=a.VK_BR_SLASH,l.DEAD=[a.VK_BR_TILDE,a.VK_RCONTROL,a.VK_END],l.HOME=[a.VK_HOME,{wc:a.VK_BR_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],l.INSERT=[a.VK_INSERT,{wc:a.VK_BR_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],l.DELETE=[a.VK_DELETE,{wc:a.VK_BR_SLASH.wc|a.ALT,n:["Alt","/"]}];var m={};for(d in b)m[d]=b[d];m.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_JP_YEN.wc|a.ALT,n:["Alt","¥"]}],m.EQUAL=a.VK_JP_CIRCUMFLEX,m.BACKSLASH=[a.VK_JP_YEN,a.VK_INT_BACKSLASH],m.OPEN_BRACKET=a.VK_JP_ARROBA,m.CLOSE_BRACKET=a.VK_JP_OPEN_BRACKET,m.QUOTE=a.VK_JP_COLLON,m.BACKQUOTE=a.VK_JP_CLOSE_BRACKET,m.DEAD=[a.VK_JP_RO,a.VK_RCONTROL,a.VK_END],m.CAPSLOCK=a.VK_JP_NON_CONVERT,m.HOME=[a.VK_HOME,{wc:a.VK_JP_OPEN_BRACKET.wc|a.ALT,n:["Alt","["]}],m.INSERT=[a.VK_INSERT,{wc:a.VK_JP_CLOSE_BRACKET.wc|a.ALT,n:["Alt","]"]}],m.DELETE=[a.VK_DELETE,{wc:a.VK_JP_RO.wc|a.ALT,n:["Alt","\\ ろ"]}];var n={};for(d in b)n[d]=b[d];n.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_ES_ORDINAL.wc|a.ALT,n:["Alt","º"]}],n.MINUS=a.VK_ES_MINUS,n.EQUAL=a.VK_ES_INV_EXCLA,n.BACKSLASH=[a.VK_ES_ORDINAL,a.VK_INT_YEN],
n.OPEN_BRACKET=a.VK_ES_QUOTE,n.CLOSE_BRACKET=a.VK_ES_GRAVE,n.SEMICOLON=a.VK_ES_ENNE,n.QUOTE=a.VK_ES_ACUTE,n.BACKQUOTE=a.VK_ES_PLUS,n.SLASH=a.VK_ES_LESSER,n.DEAD=[a.VK_ES_CEDILLA,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],n.HOME=[a.VK_HOME,{wc:a.VK_ES_GRAVE.wc|a.ALT,n:["Alt","`"]}],n.INSERT=[a.VK_INSERT,{wc:a.VK_ES_PLUS.wc|a.ALT,n:["Alt","+"]}],n.DELETE=[a.VK_DELETE,{wc:a.VK_ES_CEDILLA.wc|a.ALT,n:["Alt","Ç"]}];var o={};for(d in b)o[d]=b[d];o.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_NL_ARROBA.wc|a.ALT,n:["Alt","@"]}],o.MINUS=a.VK_NL_MINUS,o.EQUAL=a.VK_NL_ORDINAL,o.BACKSLASH=[a.VK_NL_CLOSE_BRACKET,a.VK_INT_YEN],o.OPEN_BRACKET=a.VK_NL_ARROBA,o.CLOSE_BRACKET=a.VK_NL_UMLAUT,o.SEMICOLON=a.VK_NL_PLUS,o.QUOTE=a.VK_NL_ACUTE,o.BACKQUOTE=a.VK_NL_STAR,o.SLASH=a.VK_NL_SLASH,o.DEAD=[a.VK_NL_LESSER,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],o.HOME=[a.VK_HOME,{wc:a.VK_NL_UMLAUT.wc|a.ALT,n:["Alt","¨"]}],o.INSERT=[a.VK_INSERT,{wc:a.VK_NL_STAR.wc|a.ALT,n:["Alt","*"]}],o.DELETE=[a.VK_DELETE,{wc:a.VK_NL_LESSER.wc|a.ALT,n:["Alt","<"]}];var p={};for(d in b)p[d]=b[d];p.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_IT_BACKSLASH.wc|a.ALT,n:["Alt","\\"]}],p.MINUS=a.VK_IT_MINUS,p.EQUAL=a.VK_IT_GRAVE_I,p.BACKSLASH=[a.VK_IT_BACKSLASH,a.VK_INT_YEN],p.OPEN_BRACKET=a.VK_IT_QUOTE,p.CLOSE_BRACKET=a.VK_IT_GRAVE_E,p.SEMICOLON=a.VK_IT_GRAVE_O,p.QUOTE=a.VK_IT_GRAVE_A,p.BACKQUOTE=a.VK_IT_PLUS,p.SLASH=a.VK_IT_LESSER,p.DEAD=[a.VK_IT_GRAVE_U,a.VK_INT_RO,a.VK_RCONTROL,a.VK_END],p.HOME=[a.VK_HOME,{wc:a.VK_IT_GRAVE_E.wc|a.ALT,n:["Alt","è"]}],p.INSERT=[a.VK_INSERT,{wc:a.VK_IT_PLUS.wc|a.ALT,n:["Alt","+"]}],p.DELETE=[a.VK_DELETE,{wc:a.VK_IT_GRAVE_U.wc|a.ALT,n:["Alt","ù"]}];var q={};for(d in b)q[d]=b[d];q.ESCAPE=[a.VK_ESCAPE,{wc:a.VK_FR_2u.wc|a.ALT,n:["Alt","²"]}],q.MINUS=a.VK_FR_CLOSE_PARENS,q.EQUAL=a.VK_FR_CIRCUMFLEX,q.BACKSLASH=[a.VK_FR_LESSER,a.VK_INT_YEN],q.Q=a.VK_FR_Q,q.W=a.VK_FR_W,q.OPEN_BRACKET=a.VK_FR_2u,q.CLOSE_BRACKET=a.VK_FR_EQUAL,q.A=a.VK_FR_A,q.SEMICOLON=a.VK_FR_SEMICOLON,q.QUOTE=a.VK_FR_COLON,q.BACKQUOTE=a.VK_FR_DOLLAR,q.Z=a.VK_FR_Z,q.M=a.VK_FR_M,q.COMMA=a.VK_FR_COMMA,q.PERIOD=a.VK_FR_U_GRAVE,q.SLASH=a.VK_FR_EXCLAMATION,q.DEAD=[a.VK_FR_STAR,a.VK_RCONTROL,a.VK_END],q.HOME=[a.VK_HOME,{wc:a.VK_FR_DOLLAR.wc|a.ALT,n:["Alt","$"]}],q.INSERT=[a.VK_INSERT,{wc:a.VK_FR_STAR.wc|a.ALT,n:["Alt","*"]}],q.DELETE=[a.VK_DELETE,{wc:a.VK_FR_EXCLAMATION.wc|a.ALT,n:["Alt","!"]}],wmsx.BuiltInKeyboards={en:{"en-US":c,"pt-BR":e,"ja-JP":f,"es-ES":g,"it-IT":i,"fr-FR":j,"nl-NL":h},ja:{"en-US":k,"pt-BR":l,"ja-JP":m,"es-ES":n,"it-IT":p,"fr-FR":q,"nl-NL":o}}}(),wmsx.DOMKeyboard=function(a,b,c){"use strict";function d(a,c,d){b.netController&&J.push(a<<8|c<<4|d),2!==b.netPlayMode&&e(a,c,d)}function e(a,b,c){c?y[a]&=~(1<<b):y[a]|=1<<b}function f(){C=A>0?A:WMSX.BOOT_DURATION_AUTO}function g(){var a=(wmsx.Util.userLanguage()||"en-US").toUpperCase();"NL"===a.substr(0,2)&&(a="en-US");for(var b=0;b<t.length;++b)if(0===t[b].toUpperCase().indexOf(a))return j.setKeyboard(t[b],!0);for(a=a.substr(0,2),b=0;b<t.length;++b)if(0===t[b].toUpperCase().indexOf(a))return j.setKeyboard(t[b],!0);j.setKeyboard(t[0],!0)}function h(){var a=m+"-CUSTOM";v[a]||(v[a]={},t.push(a));var b=v[a];for(var c in D)b[c]=D[c].slice(0);j.setKeyboard(a,!1)}function i(){u=wmsx.BuiltInKeyboards[w]||{},v=WMSX.userPreferences.current.customHostKeyboards[w]||{},t=Object.keys(u).concat(Object.keys(v));var a=WMSX.userPreferences.current.hostKeyboard[w];t.indexOf(a)>=0?j.setKeyboard(a,!1):g()}var j=this;this.connect=function(a,b){o=a,o.addMachineTypeStateListener(j,!0),p=b},this.connectPeripherals=function(a){q=a},this.resetControllers=function(){this.releaseControllers(),B&&f()},this.machineTypeStateUpdate=function(){var a=o.getMachineLang();a!==w&&(w=a,i())},this.powerOn=function(){if(WMSX.BOOT_KEYS||WMSX.BOOT_KEYS_ONCE){for(var a=(WMSX.BOOT_KEYS||WMSX.BOOT_KEYS_ONCE).split(","),b=[],c=0;c<a.length;++c){var d=a[c].trim().toUpperCase(),e=r[d]||r[N[d]];e&&(b.push(e.key),z[e.m[0]]&=~(1<<e.m[1]))}b.length&&f(),C&&!WMSX.BOOT_KEYS_ONCE&&(B=!0),wmsx.Util.log("Boot Keys"+(B?"":" (once)")+": "+b.join(", "))}},this.powerOff=function(){},this.typeString=function(a){p.keyboardExtensionTypeString(a)},this.cancelTypeString=function(){p.keyboardExtensionCancelTypeString()},this.isShiftPressed=function(){return 0==(1&y[6])},this.controllersClockPulse=function(){if(C>0&&--C,F&&I){if(--G===H||0===G){var a=G>0,b=r.SPACE.m;d(b[0],b[1],a)}G<=0&&(G=F)}},this.readKeyboardPort=function(a){return C>0?y[a]&z[a]:y[a]},this.toggleKeyboardLayout=function(a){var b;b=a?n?t.length-1:t.indexOf(m)-1||0:n?0:t.indexOf(m)+1||0,b<0||b>=t.length?g():this.setKeyboard(t[b],!1),q.showOSD("Host Keyboard: "+this.getCurrentKeyboardDesc(),!0)},this.getCurrentKeyboardDesc=function(){return(n?"AUTO: ":"")+m},this.setKeyboard=function(a,b){m=a,n=b,k(),q&&q.keyboardSettingsStateUpdate();var c=b?void 0:a;WMSX.userPreferences.current.hostKeyboard[w]!==c&&(WMSX.userPreferences.current.hostKeyboard[w]=c,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())},this.setTurboFireClocks=function(a){F=a,H=F/2|0,G=0},this.releaseControllers=function(){for(var a in x)x[a]&&this.processMSXKey(a,!1);I=!1},this.getKeyMapping=function(a){return D[a]},this.clearKey=function(a){0!==D[a].length&&(v[m]||h(),D[a].length=0,l(),WMSX.userPreferences.setDirty())},this.customizeKey=function(a,b){if(E[b.wc]!==a){v[m]||h();for(var c in D){var d=D[c];if(0!==d.length)for(var e;(e=wmsx.Util.arrayFindIndex(d,function(a){return a.wc===b.wc}))>=0;)d.splice(e,1)}d=D[a],d.length>=M&&d.splice(0,d.length-(M-1)),d.push(b),l(),WMSX.userPreferences.setDirty()}},this.processKey=function(a,b){var e=E[a];if(!e){if(c.processKey(a,b))return;e=E[a&L]}if(e){if(a===K&&x.CONTROL){var f=r.CONTROL.m;d(f[0],f[1],!1)}this.processMSXKey(e,b)}},this.processMSXKey=function(a,b){if(F&&"SPACE"===a){if(I===b)return;b&&(G=H),I=b}if(x[a]!==b){x[a]=b;var c=r[a].m;d(c[0],c[1],b)}};var k=function(){var a=v[m]||u[m];for(var b in r)D[b]=a[b]?a[b].constructor===Array?a[b]:[a[b]]:[];l()},l=function(){E={};for(var a in D)if(0!==D[a].length)for(var b=0;b<D[a].length;++b)E[D[a][b].wc]=a};this.netGetMatrixChangesToSend=function(){return J.length?J:void 0},this.netClearMatrixChangesToSend=function(){J.length=0},this.netServerProcessMatrixChanges=function(a){for(var b=0,c=a.length;b<c;++b){var d=a[b];J.push(d),e(d>>8,(240&d)>>4,1&d)}},this.netClientApplyMatrixChanges=function(a){for(var b=0,c=a.length;b<c;++b)e(a[b]>>8,(240&a[b])>>4,1&a[b])},this.saveState=function(){return{k:wmsx.Util.storeInt8BitArrayToStringBase64(y),kb:wmsx.Util.storeInt8BitArrayToStringBase64(z),bf:A,ba:B,bc:C}},this.loadState=function(a){wmsx.Util.restoreStringBase64ToInt8BitArray(a.k,y),wmsx.Util.restoreStringBase64ToInt8BitArray(a.kb,z),A=a.bf,B=a.ba,C=a.bc};var m,n,o,p,q,r=wmsx.KeyboardKeys,s=wmsx.DOMKeys,t=[],u={},v={},w="en",x={},y=wmsx.Util.arrayFill(new Array(12),255),z=wmsx.Util.arrayFill(new Array(12),255),A=WMSX.BOOT_KEYS_FRAMES,B=!1,C=0,D={},E={},F=0,G=0,H=0,I=!1,J=new Array(100);J.length=0;var K=s.VK_RALT.wc,L=s.IGNORE_ALL_MODIFIERS_MASK,M=4,N={CTRL:"CONTROL",ESC:"ESCAPE",CAPS:"CAPSLOCK",KANA:"CODE",RETURN:"ENTER",RET:"ENTER",0:"D0",1:"D1",2:"D2",3:"D3",4:"D4",5:"D5",6:"D6",7:"D7",8:"D8",9:"D9"};i()},wmsx.GamepadJoysticksControls=function(a,b,c){"use strict";function d(){-2===w?p=q=null:-1===w&&(v=-1,n.controllersClockPulse(!0)),x=0===w,h(),e()}function e(){var a=p?J+" 1":null,c=q?J+" 2":null;b.updateJoystickConnections(x?c:a,x?a:c)}function f(a,c){e(),b.showStatusMessage("Joystick "+(a?"1":"2")+(c?" connected":" disconnected"))}function g(a,b,c){if(c&&0!==c.length){var d=a.settings.device;if(d>=0)return c[d]&&c[d].buttons.length>0?new m(d,a):null;for(var e=0,f=c.length;e<f;e++)if(c[e]&&c[e].buttons.length>0&&!(e===b.device||p&&p.index===e||q&&q.index===e))return new m(e,a)}}function h(){B.reset(),C.reset()}function i(a,b,d){if(d===E)return j(a);var e=b.buttonsState,f=e.J_A;for(var g in t){var h=d.buttons[g];if(h&&h.length>0){
for(var i=!1,k=0;!i&&k<h.length;++k)a.getButtonDigital(h[k].b)&&(i=!0);if(e[g]!==i)if(e[g]=i,t[g].mask)i?b.portValue&=~t[g].mask:b.portValue|=t[g].mask;else{var l=d.virtualButtonsKeys[g];if(l)for(var m=0;m<l.length;++m)c.processKey(l[m].wc,i)}}}if(y&&b.buttonsState.J_A&&!f&&(z=A),!(e.UP||e.DOWN||e.LEFT||e.RIGHT)){var n=a.getStickDirection();n!==b.analogDirection&&(b.analogDirection=n,b.portValue=-16&b.portValue|L[n+1])}}function j(a){for(var b in wmsx.GamepadButtons){var c=wmsx.GamepadButtons[b].b;if(c>=0&&a.getButtonDigital(c))return F.joystickButtonDetected(wmsx.GamepadButtons[b],(E===s?1:0)^x)}}function k(){D[0]=r=WMSX.userPreferences.current.joysticks[0],D[1]=s=WMSX.userPreferences.current.joysticks[1]}function l(){this.reset=function(){this.analogDirection=-1,this.buttonsState={},this.portValue=63,this.pin8Value=0},this.reset()}function m(a,b){this.index=a,this.update=function(b){return!!(c=b[a])},this.hasMoved=function(){var a=c.timestamp;return!a||a>i&&(i=a,!0)},this.getButtonDigital=function(a){var b=c.buttons[a];return"object"==typeof b?b.pressed||b.value>.5:b>.5},this.getStickDirection=function(){var a=c.axes[d],b=c.axes[e];if(isNaN(a)||(a<0?-a:a)<h?a=0:a*=f,isNaN(b)||(b<0?-b:b)<h?b=0:b*=g,0===a&&0===b)return-1;var i=(1-Math.atan2(a,b)/Math.PI)/2;return i+=1/16,i>=1&&(i-=1),8*i|0};var c,d=b.settings.xAxis,e=b.settings.yAxis,f=b.settings.xAxisSig,g=b.settings.yAxisSig,h=b.settings.deadzone,i=Number.MIN_VALUE}var n=this;this.connectPeripherals=function(a){o=a},this.powerOn=function(){(u=!!navigator.getGamepads)&&(k(),w>=-1&&d())},this.powerOff=function(){u=!1},this.releaseControllers=function(){h()},this.resetControllers=function(){this.releaseControllers(),e()},this.readControllerPort=function(c){return a.netController?b.netGetMergedPortValues()[c]:this.readLocalControllerPort(c)},this.readLocalControllerPort=function(a){var b=1===a^x?C:B;return b.pin8Value?63:z>A?16|b.portValue:b.portValue},this.writeControllerPin8Port=function(a,b){(1===a^x?C:B).pin8Value=b},this.toggleMode=function(c){if(!u)return void b.showErrorMessage("Joysticks unavailable (not supported by browser)");var d=(2!==a.netPlayMode||G?H:I)[c?1:0][w+2];this.setMode(d),b.showStatusMessage("Joysticks "+this.getModeDesc())},this.setMode=function(a){w=a,d()},this.getMode=function(){return w},this.getModeDesc=function(){switch(w){case-1:return"AUTO";case 0:return"AUTO (swapped)";default:return u?"DISABLED":"NOT SUPPORTED"}},this.getSwappedState=function(){return x},this.netClientAdaptToServerControlsModes=function(a){G=a.sw,-2!==w&&(-1!==w||G?0===w&&G&&this.setMode(-1):this.setMode(0))},this.setTurboFireClocks=function(a){y=a,A=y/2|0,z=0},this.controllersClockPulse=function(a){if(u&&-2!==w&&(++v>=K&&(v=0),p||q||0===v)){var b=navigator.getGamepads();y&&--z<=0&&(z=y),p?p.update(b)?p.hasMoved()&&i(p,B,r):(p=null,B.reset(),a||f(!0,!1)):0===v&&(p=g(r,s,b))&&!a&&f(!0,!0),q?q.update(b)?q.hasMoved()&&i(q,C,s):(q=null,C.reset(),a||f(!1,!1)):0===v&&(q=g(s,r,b))&&!a&&f(!1,!0)}},this.getMappingForControl=function(a,b){var c=D[b^x];return t[a].mask?c.buttons[a]:0!==c.buttons[a].length||0!==c.virtualButtonsKeys[a].length?{from:c.buttons[a],to:c.virtualButtonsKeys[a]}:[]},this.getMappingPopupText=function(a,b){var c=!t[a].mask;return{heading:c?"Virtual Button mapping:":"Button mapped to host buttons:",footer:c?"Press new button / key.<br>(right-click to clear)":"Press new button.<br>(right-click to clear)"}},this.customizeControl=function(a,b,c){var d;if(c.wc){if(c.wc&&t[a].mask)return;if(d=D[b^x].virtualButtonsKeys[a],wmsx.Util.arrayFind(d,function(a){return a.wc===c.wc}))return}else if(d=D[b^x].buttons[a],wmsx.Util.arrayFind(d,function(a){return a.b===c.b}))return;d.length>=M&&d.splice(0,d.length-(M-1)),d.push(c),h(),WMSX.userPreferences.setDirty()},this.clearControl=function(a,b){D[b^x].buttons[a].length=0,t[a].mask||(D[b^x].virtualButtonsKeys[a].length=0),h(),WMSX.userPreferences.setDirty()},this.startButtonDetection=function(a,b){E=D[a^x],F=b},this.stopButtonDetection=function(){E=F=null};var o,p,q,r,s,t=wmsx.JoystickButtons,u=!1,v=1,w=WMSX.JOYSTICKS_MODE-1,x=!1,y=0,z=0,A=0,B=new l,C=new l,D=[],E=null,F=null,G=!1,H=[[-1,0,-2],[0,-2,-1]],I=[[0,-2,-1],[-1,0,-2]],J=wmsx.ControllersHub.JOYSTICK,K=60,L=[15,14,6,7,5,13,9,11,10],M=4},wmsx.DOMJoykeysControls=function(a,b,c){"use strict";function d(){p=1===o||3===o,h(),g(),e()}function e(){q={},o>=0&&f(l.buttons,0),o>=2&&f(m.buttons,1)}function f(a,b){for(var c in a)for(var d=0;d<a[c].length;++d)q[a[c][d].wc]||(q[a[c][d].wc]=[]),q[a[c][d].wc].push({b:c,p:b})}function g(){var a=o>=0?C+" 1":null,c=o>=2?C+" 2":null;b.updateJoykeysConnections(p?c:a,p?a:c)}function h(){s.reset(),t.reset()}function i(){y[0]=l=WMSX.userPreferences.current.joykeys[0],y[1]=m=WMSX.userPreferences.current.joykeys[1]}function j(){this.reset=function(){this.portValue=63,this.pin8Value=0},this.reset()}this.connectPeripherals=function(a){k=a},this.powerOn=function(){i(),o>=0&&d()},this.powerOff=function(){},this.releaseControllers=function(){h()},this.resetControllers=function(){this.releaseControllers(),g()},this.readControllerPort=function(c){return a.netController?b.netGetMergedPortValues()[c]:this.readLocalControllerPort(c)},this.readLocalControllerPort=function(a){var b=u[a^p];return b.pin8Value?63:w>x?16|b.portValue:b.portValue},this.writeControllerPin8Port=function(a,b){u[a^p].pin8Value=b},this.controllersClockPulse=function(){o>=0&&v&&--w<=0&&(w=v)},this.toggleMode=function(c){var d=(2!==a.netPlayMode||z?A:B)[c?1:0][o+1];this.setMode(d),b.showStatusMessage("Joykeys "+this.getModeDesc())},this.setMode=function(a){a>=0&&o<0&&(r={}),o=a,d()},this.getMode=function(){return o},this.getModeDesc=function(){switch(o){case 0:return"SINGLE";case 1:return"SINGLE (port 2)";case 2:return"DUAL";case 3:return"DUAL (swapped)";default:return"DISABLED"}},this.getSwappedState=function(){return p},this.netClientAdaptToServerControlsModes=function(a){z=a.sw,-1!==o&&(z?1===o?this.setMode(0):3===o&&this.setMode(2):0===o?this.setMode(1):2===o&&this.setMode(3))},this.setTurboFireClocks=function(a){v=a,x=v/2|0,w=0},this.processKey=function(a,b){if(o<0)return c.processKey(a,b);var d=q[a];if(!d)return c.processKey(a,b);if(r[a]===b)return void(b||c.processKey(a,b));r[a]=b;for(var e=0;e<d.length;++e)b?(u[d[e].p].portValue&=~n[d[e].b].mask,v&&"J_A"===d[e].b&&(w=x+1)):u[d[e].p].portValue|=n[d[e].b].mask;b||c.processKey(a,b)},this.getMappingForControl=function(a,b){return y[b^p].buttons[a]},this.getMappingPopupText=function(a,b){return{heading:"Button mapped to host keys:",footer:"Press new key.<br>(right-click to clear)"}},this.customizeControl=function(a,b,c){if(!q[c.wc]||!wmsx.Util.arrayFind(q[c.wc],function(c){return c.b===a&&c.p===b})){var d=y[b^p].buttons[a];d.length>=D&&d.splice(0,d.length-(D-1)),d.push(c),h(),e(),WMSX.userPreferences.setDirty()}},this.clearControl=function(a,b){y[b^p].buttons[a].length=0,h(),e(),WMSX.userPreferences.setDirty()};var k,l,m,n=wmsx.JoystickButtons,o=WMSX.JOYKEYS_MODE,p=!1,q={},r={},s=new j,t=new j,u=[s,t],v=0,w=0,x=0,y=[],z=!1,A=[[0,1,2,3,-1],[3,-1,0,1,2]],B=[[1,3,0,-1,2],[2,1,-1,3,0]],C=wmsx.ControllersHub.JOYKEYS,D=4},wmsx.DOMMouseControls=function(a,b){"use strict";function c(a){C=void 0!==a?a:B<0?-1:B,z?q(y):p(x),n()}function d(a){return a===C?y.portValue:b.portValueAllReleased}function e(){if(G=!1,C<0)return w.showOSD("Mouse Pointer Locking only when MOUSE is ENABLED!",!0,!0);var a=t.requestPointerLock||t.mozRequestPointerLock||t.webkitRequestPointerLock;a&&a.apply(t)}function f(){G=!1;var a=document.exitPointerLock||document.mozExitPointerLock||document.webkitExitPointerLock;a&&a.apply(document)}function g(){x.portValue=-49&x.portValue|(3&~x.buttons)<<4}function h(){switch(x.readCycle){case 0:x.portValue=-16&x.portValue|x.readDX>>4&15;break;case 1:x.portValue=-16&x.portValue|15&x.readDX;break;case 2:x.portValue=-16&x.portValue|x.readDY>>4&15;break;case 3:
x.portValue=-16&x.portValue|15&x.readDY;break;default:x.portValue=-16&x.portValue}}function i(){var a=Math.round(-x.dX);a>127?a=127:a<-127&&(a=-127),x.dX+=a,x.readDX=a;var b=Math.round(-x.dY);b>127?b=127:b<-127&&(b=-127),x.dY+=b,x.readDY=b}function j(a){if(!(C<0)){a.preventDefault();var b=0,c=0;F?(b=a.movementX||a.mozMovementX||a.webkitMovementX||0,c=a.movementY||a.mozMovementY||a.webkitMovementY||0):u&&(b=a.clientX-u.clientX,c=a.clientY-u.clientY),u=a,y.dX+=b/D,y.dY+=c/E,A=y}}function k(a){if(4&a.buttons&&(a.preventDefault(),s.togglePointerLock()),C>=0){if(G&&a.buttons)return 1&a.buttons&&!F&&e(),void(G=!1);y.buttons=3&a.buttons,z||g(),A=y}}function l(){var a=document.pointerLockElement||document.mozPointerLockElement||document.webkitPointerLockElement;F=a===t,w.mousePointerLocked(F),w.showOSD(F?"Mouse Pointer Locked":"Mouse Pointer Released",F)}function m(a,b){C=a,s.writeControllerPin8Port(C,b),n(),o("Mouse AUTO-ENABLED")}function n(){F&&C<0&&f(),b.updateMouseConnections(0===C?I:null,1===C?I:null),w.mouseActiveCursorStateUpdate(C>=0)}function o(a){b.showStatusMessage(a)}function p(a){return a.readCycle=-1,a.dX=0,a.dY=0,a.buttons=0,a.portValue=b.portValueAllReleased,a.pin8Value=0,a.lastPin8FlipBUSCycle=0,a.readDX=0,a.readDY=0,A=x,a}function q(a){return a.dX=0,a.dY=0,a.buttons=void 0,A=void 0,a}function r(a){return a===C?x.portValue:b.portValueAllReleased}var s=this;this.connect=function(a){v=a},this.connectPeripherals=function(a){w=a},this.powerOn=function(){c()},this.powerOff=function(){},this.releaseControllers=function(){C>=0&&(z?q(y):p(x))},this.resetControllers=function(){this.releaseControllers(),-1===B&&(C=-1),n()},this.screenFullscreenStateUpdate=function(a){G=a&&!F},this.toggleMode=function(a){var b;a?(b=B-1)<-2&&(b=1):(b=B+1)>1&&(b=-2),this.setMode(b),o("Mouse "+this.getModeDesc())},this.setMode=function(a){B=a,c()},this.setModeEffective=function(a){B=a.m,c(a.p)},this.getMode=function(){return B},this.getModeEffective=function(){return{m:B,p:C}},this.getModeDesc=function(){switch(B){case-1:return"AUTO";case 0:return"ENABLED";case 1:return"ENABLED (port 2)";default:return"DISABLED"}},this.netClientAdaptToServerControlsModes=function(a){this.setModeEffective(a.m)},this.readControllerPort=function(b){return a.netController?r(b):d(b)},this.writeControllerPin8Port=function(a,b){if(a===C){if(x.pin8Value^b){x.pin8Value=b;var c=v.getBUSCycles()-x.lastPin8FlipBUSCycle;x.lastPin8FlipBUSCycle+=c,c>J&&(x.readCycle=-1),++x.readCycle,0===x.readCycle&&i(),h()}}},this.portPin8Announced=function(a,b){1===b&&!H&&C<0&&0===a&&-1===B&&m(a,b)},this.togglePointerLock=function(){F?f():e()},this.setMouseInputElement=function(a){t=a,"onpointerlockchange"in document?document.addEventListener("pointerlockchange",l,!1):"onmozpointerlockchange"in document&&document.addEventListener("mozpointerlockchange",l,!1),t.addEventListener("mousemove",j),t.addEventListener("mousedown",k),t.addEventListener("mouseup",k)},this.setScreenPixelScale=function(a,b){D=a,E=b},this.getMappingForControl=function(a,b){return[{wc:999999,n:["Alt","CapsLock"]}]},this.getMappingPopupText=function(a,b){return{heading:"Lock / Unlock pointer:",footer:"or click Middle Button"}},this.customizeControl=function(a,b,c){},this.clearControl=function(a,b){},this.netGetMouseStateToSend=function(){return A},this.netClearMouseInfoToSend=function(){z?q(y):A=void 0},this.netServerGetMouseState=function(){return x},this.netServerReceiveClientMouseState=function(a){x.dX+=a.dX,x.dY+=a.dY,void 0!==a.buttons&&(x.buttons=a.buttons,g()),A=x},this.netClientReceiveServerMouseState=function(a){x=a},this.netSetClientMode=function(a){z=a,y=a?q({}):x};var t,u,v,w,x=p({}),y=x,z=!1,A=void 0,B=WMSX.MOUSE_MODE-1,C=-1,D=1,E=1,F=!1,G=!1,H=wmsx.Util.isMobileDevice(),I=wmsx.ControllersHub.MOUSE,J=wmsx.CPU.BASE_CLOCK/1e3*1.5|0},wmsx.DOMTouchControls=function(a,b,c,d){"use strict";function e(){C.classList.toggle("wmsx-poweroff",!V),C.classList.toggle("wmsx-paused",W)}function f(){J=-2===I?-1:-1===I?G&&H?0:-1:I,v(),u()}function g(a){if(wmsx.Util.blockEvent(a),E)return E.touchControlDetected("T_DIR",a)}function h(a){if(wmsx.Util.blockEvent(a),E)return E.touchControlDetected("T_DIR",a);if(null===Q){void 0===A&&m();var b=a.changedTouches[0];Q=b.identifier,k(b.pageX,b.pageY)}}function i(a){wmsx.Util.blockEvent(a),null!==Q&&(Q=null,l(-1))}function j(a){if(wmsx.Util.blockEvent(a),null!==Q)for(var b=a.changedTouches,c=0;c<b.length;++c)if(b[c].identifier===Q)return void k(b[c].pageX,b[c].pageY)}function k(a,b){var c=-1,d=a-A,e=b-B;Math.sqrt(d*d+e*e)>S&&(c=(1-Math.atan2(d,e)/Math.PI)/2,c+=1/16,c>=1&&(c-=1),c=8*c|0),l(c)}function l(a){if(R!==a){if(P.wmsxMappingIsKeys){var d=Z[R+1];d[0]&&c.processMSXKey(d[0],!1),d[1]&&c.processMSXKey(d[1],!1);var e=Z[a+1];e[0]&&c.processMSXKey(e[0],!0),e[1]&&c.processMSXKey(e[1],!0)}else U.portValue=-16&U.portValue|Y[a+1];a>=0&&b.hapticFeedback(),R=a}}function m(){var a=P.getBoundingClientRect();S=.14*(a.right-a.left)|0,A=((a.left+a.right)/2|0)+window.pageXOffset,B=((a.top+a.bottom)/2|0)+window.pageYOffset}function n(a){if(wmsx.Util.blockEvent(a),E)return E.touchControlDetected(a.target.wmsxControl,a);p(a.target.wmsxMapping,!0)}function o(a){wmsx.Util.blockEvent(a),p(a.target.wmsxMapping,!1)}function p(a,d){a&&(d&&b.hapticFeedback(),a.button?d?(U.portValue&=~a.mask,K&&16&a.mask&&(L=M+1)):U.portValue|=a.mask:a.key&&c.processMSXKey(a.key,d))}function q(a){wmsx.Util.blockEvent(a),b.hapticFeedback(),d.processControlState(V?F.PAUSE:F.POWER,!0)}function r(a){wmsx.Util.blockEvent(a),b.hapticFeedback(),d.processControlState(W?F.FRAME:F.FAST_SPEED,!0)}function s(a){wmsx.Util.blockEvent(a),W||(b.hapticFeedback(),d.processControlState(W?F.FRAME:F.FAST_SPEED,!1))}function t(){y.updateMappingFor("T_DIR");for(var a in T)y.updateMappingFor(a)}function u(){b.updateTouchControlsConnections(0===J?X:null,1===J?X:null)}function v(){U.reset(),A=B=void 0,Q=null,l(-1)}function w(){D=WMSX.userPreferences.current.touch,N=!!D.directionalBig,O=!!D.mirrored}function x(){this.reset=function(){this.portValue=63,this.pin8Value=0},this.reset()}var y=this;this.connect=function(a){a.addPowerAndUserPauseStateListener(this)},this.connectPeripherals=function(a){z=a},this.powerOn=function(){w(),f()},this.powerOff=function(){},this.releaseControllers=function(){v()},this.resetControllers=function(){this.releaseControllers(),u()},this.readControllerPort=function(c){return a.netController?b.netGetMergedPortValues()[c]:this.readLocalControllerPort(c)},this.readLocalControllerPort=function(a){return a===J?U.pin8Value?63:L>M?16|U.portValue:U.portValue:63},this.writeControllerPin8Port=function(a,b){a===J&&(U.pin8Value=b)},this.controllersClockPulse=function(){J>=0&&K&&--L<=0&&(L=K)},this.toggleMode=function(a,c){if(!G)return void b.showErrorMessage("Touch Controls unavailable. Not a touch device!");var d;c?(d=a?J<0?1:0===J?-2:I-1:I-1)<-2&&(d=1):(d=a?0===J?1:-2===I?0:I+1:I+1)>1&&(d=-2),this.setMode(d),b.showStatusMessage("Touch Controls "+this.getModeDesc())},this.setMode=function(a){I=a,f()},this.getMode=function(){return I},this.getModeDesc=function(){switch(I){case-1:return"AUTO";case 0:return"ENABLED";case 1:return"ENABLED (port 2)";default:return G?"DISABLED":"NOT SUPPORTED"}},this.getSwappedState=function(){return 1===J},this.netClientAdaptToServerControlsModes=function(a){-1!==J&&(0!==J||a.sw?1===J&&a.sw&&this.setMode(0):this.setMode(1))},this.toggleDirBig=function(){N=!N,D.directionalBig=N,WMSX.userPreferences.setDirty(),this.controllersSettingsStateUpdate()},this.toggleMirrored=function(){O=!O,D.mirrored=O,WMSX.userPreferences.setDirty(),this.controllersSettingsStateUpdate()},this.isDirBig=function(){return N},this.isMirrored=function(){return O},this.getPortActive=function(){return J},this.setTurboFireClocks=function(a){K=a,M=K/2|0,L=0},this.getMappingForControl=function(a,b){return null},this.screenReadjustedUpdate=function(){
this.releaseControllers()},this.setupTouchControlsIfNeeded=function(a){function b(a,b){var c=wmsx.DOMTouchControls.createButton("wmsx-touch-"+b);c.wmsxControl=b,c.addEventListener("touchstart",n),c.addEventListener("touchmove",wmsx.Util.blockEvent),c.addEventListener("touchend",o),c.addEventListener("touchcancel",o),c.addEventListener("mousedown",n),c.addEventListener("mouseup",o),T[b]=c,a.appendChild(c)}if(!(P||J<0)){C=document.createElement("div"),C.id="wmsx-touch-speed";var c=document.createElement("div");c.id="wmsx-touch-pause",c.addEventListener("touchstart",q),c.addEventListener("mousedown",q),C.appendChild(c);var d=document.createElement("div");d.id="wmsx-touch-fast",d.addEventListener("touchstart",r),d.addEventListener("touchend",s),d.addEventListener("mousedown",r),d.addEventListener("mouseup",s),C.appendChild(d),a.appendChild(C);var f=document.createElement("div");f.id="wmsx-touch-left",b(f,wmsx.TouchControls.buttonsLeftSide[0]),P=wmsx.DOMTouchControls.createDirectional(),P.addEventListener("touchstart",h),P.addEventListener("touchmove",j),P.addEventListener("touchend",i),P.addEventListener("touchcancel",i),P.addEventListener("mousedown",g),f.appendChild(P),b(f,wmsx.TouchControls.buttonsLeftSide[1]),a.appendChild(f),f=document.createElement("div"),f.id="wmsx-touch-right";var k=wmsx.TouchControls.buttonsRightSide;for(var l in k)b(f,k[l]);a.appendChild(f),e(),t()}},this.startTouchDetection=function(a){E=a},this.stopTouchDetection=function(){E=null},this.customizeControl=function(a,b){"T_DIR"===a?D.directional=b:D.buttons[a]=b,this.updateMappingFor(a),WMSX.userPreferences.setDirty()},this.updateMappingFor=function(a){if("T_DIR"===a)P.wmsxMappingIsKeys="KEYBOARD"===D.directional,wmsx.DOMTouchControls.styleDirectionalMapping(P,D.directional);else{var b=T[a],c=D.buttons[a];b.wmsxMapping=c,wmsx.DOMTouchControls.styleButtonMapping(b,c)}},this.controllersSettingsStateUpdate=function(){var a=!!b.getSettingsState().touchActive;document.documentElement.classList.toggle("wmsx-touch-active",a),document.documentElement.classList.toggle("wmsx-dir-big",N),document.documentElement.classList.toggle("wmsx-touch-mirror",O),z.touchControlsActiveUpdate(a,N,O)},this.machinePowerAndUserPauseStateUpdate=function(a,b){V=a,W=b,C&&e()};var z,A,B,C,D,E,F=wmsx.MachineControls,G=wmsx.Util.isTouchDevice(),H=wmsx.Util.isMobileDevice(),I=WMSX.TOUCH_MODE>=1?WMSX.TOUCH_MODE-1:G?-1:-2,J=-1,K=0,L=0,M=0,N=!1,O=!1,P=null,Q=null,R=-1,S=0,T={},U=new x,V=!1,W=!1,X=wmsx.ControllersHub.TOUCH,Y=[15,14,6,7,5,13,9,11,10],Z=[[],["UP"],["RIGHT","UP"],["RIGHT"],["RIGHT","DOWN"],["DOWN"],["LEFT","DOWN"],["LEFT"],["LEFT","UP"]];this.saveState=function(){return{p:D}},this.loadState=function(a){if(v(),a.p){delete a.p.directionalBig,delete a.p.mirrored;for(var b in a.p)D[b]=a.p[b];for(var c in D.buttons){var d=D.buttons[c];d&&d.sn&&!d.c_en&&(d.c_en=d.sn)}P&&t()}}},wmsx.DOMTouchControls.createDirectional=function(a){function b(a){var b=document.createElement("div");b.classList.add("wmsx-touch-dir-"+a),c.appendChild(b);var d=document.createElement("div");d.classList.add("wmsx-arrow-"+a),c.appendChild(d)}var c=document.createElement("div");return a&&(c.id=a),c.classList.add("wmsx-touch-dir"),b("left"),b("right"),b("up"),b("down"),c},wmsx.DOMTouchControls.createButton=function(a){var b=document.createElement("div");return a&&(b.id=a),b.classList.add("wmsx-touch-button"),b},wmsx.DOMTouchControls.styleDirectionalMapping=function(a,b){a.classList.toggle("wmsx-touch-dir-key","KEYBOARD"===b),a.classList.toggle("wmsx-touch-dir-joy","KEYBOARD"!==b)},wmsx.DOMTouchControls.styleButtonMapping=function(a,b){if(a.innerHTML=b?b.n||b.c_en:"",b)if(b.button){a.classList.add("wmsx-touch-button-joy"),a.classList.remove("wmsx-touch-button-key","wmsx-touch-button-none");for(var c=["A","B","AB"],d=0;d<c.length;++d)b&&b.n===c[d]?a.classList.add("wmsx-touch-button-joy-"+c[d]):a.classList.remove("wmsx-touch-button-joy-"+c[d])}else b.key&&(a.classList.add("wmsx-touch-button-key"),a.classList.remove("wmsx-touch-button-joy","wmsx-touch-button-none"));else a.classList.add("wmsx-touch-button-none"),a.classList.remove("wmsx-touch-button-joy","wmsx-touch-button-key")},wmsx.ControllersHub=function(a,b){"use strict";function c(a){var b=j[a];return b&&b!==q?b.readLocalControllerPort(a)|y:z}function d(){for(var a=0;a<=1;++a)k[a]?j[a]=q:l[a]?j[a]=r:m[a]?j[a]=s:n[a]?j[a]=t:j[a]=null;t.controllersSettingsStateUpdate(),B.controllersSettingsStateUpdate()}function e(){var a=c(0),b=c(1);D[0]===a&&D[1]===b||(D[0]=a,D[1]=b,A=D)}function f(){if(F){g.netServerClearClientsMergedInfo();var b=a.netController.clients;for(var d in b){var e=b[d].controllersPortValues;e&&(E[0]&=e[0],E[1]&=e[1])}}var f=c(0)&E[0],h=c(1)&E[1];C[0]===f&&C[1]===h||(C[0]=f,C[1]=h,A=C)}var g=this;this.connect=function(a,b,c,d){c.connectControls(this),p.connect(a,d),q.connect(c),t.connect(b)},this.connectPeripherals=function(a){B=a,p.connectPeripherals(B),q.connectPeripherals(B),r.connectPeripherals(B),s.connectPeripherals(B),t.connectPeripherals(B)},this.powerOn=function(){p.powerOn(),q.powerOn(),r.powerOn(),s.powerOn(),t.powerOn()},this.powerOff=function(){p.powerOff(),q.powerOff(),r.powerOff(),s.powerOff(),t.powerOff()},this.getKeyboard=function(){return p},this.getTouchControls=function(){return t},this.releaseControllers=function(){p.releaseControllers(),r.releaseControllers(),s.releaseControllers(),q.releaseControllers(),t.releaseControllers()},this.resetControllers=function(){p.resetControllers(),r.resetControllers(),s.resetControllers(),q.resetControllers()},this.roomNetPlayStatusChangeUpdate=function(b){q.netSetClientMode(2===a.netPlayMode)},this.readKeyboardPort=function(a){return p.readKeyboardPort(a)},this.readControllerPort=function(a){var b=j[a];return b?b.readControllerPort(a):this.netGetMergedPortValues()[a]},this.writeControllerPin8Port=function(a,b){q.portPin8Announced(a,b);var c=j[a];c&&c.writeControllerPin8Port(a,b)},this.controllersClockPulse=function(){p.controllersClockPulse(),s.controllersClockPulse(),r.controllersClockPulse(),t.controllersClockPulse(),1===a.netPlayMode?f():2===a.netPlayMode&&e()},this.toggleKeyboardLayout=function(a){p.toggleKeyboardLayout(a)},this.toggleJoystickMode=function(a){r.toggleMode(a)},this.toggleJoykeysMode=function(a){s.toggleMode(a)},this.toggleMouseMode=function(a){q.toggleMode(a)},this.toggleMouseLock=function(){q.togglePointerLock()},this.toggleTouchControlsMode=function(a,b){t.toggleMode(a,b)},this.toggleHapticFeedback=function(){w?(x=!x,WMSX.userPreferences.current.hapticFeedback=x,WMSX.userPreferences.setDirty()):this.showErrorMessage("Haptic Feedback not available")},this.toggleTurboFireSpeed=function(a){u+=a?-1:1,u=u>=0?u%11:11+u;var b=u?60/v[u]|0:0;p.setTurboFireClocks(b),r.setTurboFireClocks(b),s.setTurboFireClocks(b),t.setTurboFireClocks(b),B.controllersSettingsStateUpdate(),B.showOSD("Turbo Fire"+(u?" speed: "+this.getTurboFireSpeedDesc():": OFF"),!0)},this.getTurboFireSpeedDesc=function(){return u?u+"x":"OFF"},this.getControlReport=function(a){switch(a){case wmsx.PeripheralControls.TOUCH_TOGGLE_DIR_BIG:var b=t.isDirBig();return{label:b?"ON":"OFF",active:b};case wmsx.PeripheralControls.TOUCH_TOGGLE_MIRRORED:var c=t.isMirrored();return{label:c?"ON":"OFF",active:c};case wmsx.PeripheralControls.HAPTIC_FEEDBACK_TOGGLE_MODE:return{label:x?"ON":"OFF",active:!!x};case wmsx.PeripheralControls.TURBO_FIRE_TOGGLE:return{label:this.getTurboFireSpeedDesc(),active:!!u}}return{label:"Unknown",active:!1}},this.setupTouchControlsIfNeeded=function(a){t.setupTouchControlsIfNeeded(a)},this.addKeyInputElement=function(a){a.addEventListener("keydown",this.keyDown),a.addEventListener("keyup",this.keyUp)},this.screenReadjustedUpdate=function(){t.screenReadjustedUpdate()},this.screenFullscreenStateUpdate=function(a){q.screenFullscreenStateUpdate(a)},this.keyDown=function(a){return h(a,!0)},this.keyUp=function(a){return h(a,!1)},
this.setMouseInputElement=function(a){q.setMouseInputElement(a)},this.setScreenPixelScale=function(a,b){q.setScreenPixelScale(a,b)},this.updateMouseConnections=function(a,b){k[0]=a,k[1]=b,d()},this.updateJoystickConnections=function(a,b){l[0]=a,l[1]=b,d()},this.updateJoykeysConnections=function(a,b){m[0]=a,m[1]=b,d()},this.updateTouchControlsConnections=function(a,b){n[0]=a,n[1]=b,d()},this.showStatusMessage=function(a){var b=k[0]||l[0]||m[0]||n[0]||"&nbsp-&nbsp-&nbsp&nbsp",c=k[1]||l[1]||m[1]||n[1]||"&nbsp-&nbsp-&nbsp&nbsp";B.showOSD((a?a+".&nbsp&nbsp":"")+"Port 1:&nbsp&nbsp"+b+",&nbsp&nbspPort 2:&nbsp&nbsp"+c,!0)},this.showErrorMessage=function(a){B.showOSD(a,!0,!0)},this.getSettingsState=function(){return o.mouseModeDesc=q.getModeDesc(),o.joysticksModeDesc=r.getModeDesc(),o.joykeysModeDesc=s.getModeDesc(),o.touchPortSet=t.getPortActive(),o.touchActive=j[0]===t||j[1]===t,o.ports[0]=k[0]||l[0]||m[0]||n[0]||wmsx.ControllersHub.NONE,o.ports[1]=k[1]||l[1]||m[1]||n[1]||wmsx.ControllersHub.NONE,o.turboFireSpeedDesc=this.getTurboFireSpeedDesc(),o},this.getMappingForControl=function(a,b){return j[b]&&j[b].getMappingForControl(a,b)},this.getMappingPopupText=function(a,b){return j[b]&&j[b].getMappingPopupText(a,b)},this.mappingPopupVisibility=function(a,b,c){c&&j[b]===r?r.startButtonDetection(b,a):r.stopButtonDetection()},this.customizeControl=function(a,b,c){j[b].customizeControl(a,b,c)},this.clearControl=function(a,b){return j[b].clearControl(a,b)},this.hapticFeedback=function(){x&&navigator.vibrate(8)},this.hapticFeedbackOnTouch=function(a){!x||"touchstart"!==a.type&&"touchend"!==a.type&&"touchmove"!==a.type||navigator.vibrate(8)};var h=function(a,b){a.returnValue=!1,a.preventDefault(),a.stopPropagation();var c=i.codeNewForKeyboardEvent(a);return s.processKey(c,b),!1};this.netGetInfoToSend=function(){var a=q.netGetMouseStateToSend();return a||A?{m:a,p:A}:void 0},this.netClearInfoToSend=function(){A=void 0,q.netClearMouseInfoToSend()},this.netServerGetFullInfo=function(){return{m:q.netServerGetMouseState(),p:C}},this.netGetMergedPortValues=function(){return C},this.netClientReceiveServerInfo=function(a){a.m&&q.netClientReceiveServerMouseState(a.m);var b=a.p;b&&(C[0]=b[0],C[1]=b[1])},this.netServerReceiveClientInfo=function(a,b){b.m&&q.netServerReceiveClientMouseState(b.m);var c=b.p;c&&(F=!0,a.controllersPortValues=c[0]!==z||c[1]!==z?c:void 0)},this.netServerClearClientsMergedInfo=function(){E[0]=z,E[1]=z,F=!1},this.netServerGetControlsModes=function(){return{m:q.getModeEffective(),sw:s.getSwappedState()||r.getSwappedState()||t.getSwappedState()}},this.netClientGetControlsModes=function(){return{k:s.getMode(),j:r.getMode(),m:q.getModeEffective(),t:t.getMode()}},this.netClientRestoreControlsModes=function(a){s.setMode(a.k),r.setMode(a.j),q.setModeEffective(a.m),t.setMode(a.t)},this.netClientAdaptToServerControlsModes=function(a){s.netClientAdaptToServerControlsModes(a),r.netClientAdaptToServerControlsModes(a),q.netClientAdaptToServerControlsModes(a),t.netClientAdaptToServerControlsModes(a)},this.saveState=function(){return{jk:y,t:t.saveState(),h:x}},this.loadState=function(a){void 0!==a.jk&&(y=a.jk,z=63|y,this.portValueAllReleased=z),a.t&&t.loadState(a.t),void 0!==a.h&&(x=a.h&&w)};var i=wmsx.DOMKeys,j=[null,null],k=[null,null],l=[null,null],m=[null,null],n=[null,null],o={ports:[null,null]},p=new wmsx.DOMKeyboard(this,a,b),q=new wmsx.DOMMouseControls(a,this),r=new wmsx.GamepadJoysticksControls(a,this,p),s=new wmsx.DOMJoykeysControls(a,this,p),t=new wmsx.DOMTouchControls(a,this,p,b),u=0,v=[0,2,2.4,3,4,5,6,7.5,10,12,15],w=!!navigator.vibrate,x=w&&!!WMSX.userPreferences.current.hapticFeedback,y=0!==WMSX.KEYBOARD_JAPAN_LAYOUT?64:0,z=63|y;this.portValueAllReleased=z;var A,B,C=[z,z],D=[z,z],E=[z,z],F=!1;wmsx.ControllersHub.hapticFeedback=this.hapticFeedback,wmsx.ControllersHub.hapticFeedbackOnTouch=this.hapticFeedbackOnTouch},wmsx.ControllersHub.MOUSE="MOUSE",wmsx.ControllersHub.JOYSTICK="JOYSTICK",wmsx.ControllersHub.JOYKEYS="JOYKEYS",wmsx.ControllersHub.TOUCH="TOUCH",wmsx.ControllersHub.JOY_ANY="JOY",wmsx.ControllersHub.NONE="NO DEVICE",wmsx.DOMMachineControls=function(a,b){"use strict";function c(b,c,e,f){if(2===a.netPlayMode&&(T.has(b)||U.has(b)))return a.showOSD("Function not available in NetPlay Client mode",!0,!0);1===a.netPlayMode&&T.has(b)||n.push({c:b<<4|e<<1|c,d:f}),2!==a.netPlayMode&&d(b,c,e,f)}function d(a,b,c,d){g.controlStateChanged(a,b,c,d),S.has(a)&&h.quickOptionsControlsStateUpdate()}this.connect=function(a){g=a},this.connectPeripherals=function(a){h=a},this.powerOn=function(){e()},this.powerOff=function(){},this.processKey=function(a,d){var e=a&R,f=k[e];return!f||m[a]?b.processKey(a,d):d===l[e]||(l[e]=d,c(f,d,e!==a),!0)},this.processControlState=c,this.getControlReport=function(a){return g.getControlReport(a)};var e=function(){window.onhelp=function(){return!1}},f=function(){var a=i;k[o]=j.POWER,k[o|a.ALT]=j.POWER,k[u|a.CONTROL]=j.PAUSE_CPU,k[u|a.CONTROL|a.ALT]=j.PAUSE_CPU,k[v|a.CONTROL|a.ALT]=j.PAUSE_CPU,k[p]=j.FAST_SPEED,k[p|a.ALT]=j.FAST_SPEED,k[q|a.ALT]=j.INC_SPEED,k[r|a.ALT]=j.DEC_SPEED,k[s|a.ALT]=j.NORMAL_SPEED,k[t|a.ALT]=j.MIN_SPEED,m[q|a.ALT]=!0,m[r|a.ALT]=!0,m[s|a.ALT]=!0,m[t|a.ALT]=!0,k[u]=j.PAUSE,k[u|a.ALT]=j.PAUSE,k[v|a.ALT]=j.PAUSE,k[w|a.ALT]=j.FRAME,k[x|a.ALT]=j.FRAME,k[y|a.ALT]=j.DEBUG,k[z|a.ALT]=j.SPRITE_MODE,k[A|a.ALT]=j.VIDEO_STANDARD,k[B|a.ALT]=j.CPU_CLOCK_MODE,k[C|a.ALT]=j.VDP_CLOCK_MODE,k[D|a.CONTROL|a.ALT]=j.SAVE_STATE_0,k[E|a.CONTROL|a.ALT]=j.SAVE_STATE_0,k[F|a.CONTROL|a.ALT]=j.SAVE_STATE_1,k[G|a.CONTROL|a.ALT]=j.SAVE_STATE_2,k[H|a.CONTROL|a.ALT]=j.SAVE_STATE_3,k[I|a.CONTROL|a.ALT]=j.SAVE_STATE_4,k[J|a.CONTROL|a.ALT]=j.SAVE_STATE_5,k[K|a.CONTROL|a.ALT]=j.SAVE_STATE_6,k[L|a.CONTROL|a.ALT]=j.SAVE_STATE_7,k[M|a.CONTROL|a.ALT]=j.SAVE_STATE_8,k[N|a.CONTROL|a.ALT]=j.SAVE_STATE_9,k[O|a.CONTROL|a.ALT]=j.SAVE_STATE_10,k[P|a.CONTROL|a.ALT]=j.SAVE_STATE_11,k[Q|a.CONTROL|a.ALT]=j.SAVE_STATE_12,k[D|a.ALT]=j.LOAD_STATE_0,k[E|a.ALT]=j.LOAD_STATE_0,k[F|a.ALT]=j.LOAD_STATE_1,k[G|a.ALT]=j.LOAD_STATE_2,k[H|a.ALT]=j.LOAD_STATE_3,k[I|a.ALT]=j.LOAD_STATE_4,k[J|a.ALT]=j.LOAD_STATE_5,k[K|a.ALT]=j.LOAD_STATE_6,k[L|a.ALT]=j.LOAD_STATE_7,k[M|a.ALT]=j.LOAD_STATE_8,k[N|a.ALT]=j.LOAD_STATE_9,k[O|a.ALT]=j.LOAD_STATE_10,k[P|a.ALT]=j.LOAD_STATE_11,k[Q|a.ALT]=j.LOAD_STATE_12};this.netGetControlsToSend=function(){return n.length?n:void 0},this.netClearControlsToSend=function(){n.length=0},this.netServerProcessControlsChanges=function(a){for(var b=0,c=a.length;b<c;++b){var e=a[b];T.has(e.c>>4)||n.push(e),d(e.c>>4,1&e.c,2&e.c,e.d)}},this.netClientApplyControlsChanges=function(a){for(var b=0,c=a.length;b<c;++b){var e=a[b];d(e.c>>4,1&e.c,2&e.c,e.d)}};var g,h,i=wmsx.DOMKeys,j=wmsx.MachineControls,k={},l={},m={},n=new Array(100);n.length=0;var o=i.VK_F11.wc,p=i.VK_F12.wc,q=i.VK_UP.wc,r=i.VK_DOWN.wc,s=i.VK_RIGHT.wc,t=i.VK_LEFT.wc,u=i.VK_F8.wc,v=i.VK_P.wc,w=i.VK_O.wc,x=i.VK_F.wc,y=i.VK_D.wc,z=i.VK_S.wc,A=i.VK_Q.wc,B=i.VK_T.wc,C=i.VK_Y.wc,D=i.VK_QUOTE.wc,E=i.VK_BACKQUOTE.wc,F=i.VK_1.wc,G=i.VK_2.wc,H=i.VK_3.wc,I=i.VK_4.wc,J=i.VK_5.wc,K=i.VK_6.wc,L=i.VK_7.wc,M=i.VK_8.wc,N=i.VK_9.wc,O=i.VK_0.wc,P=i.VK_MINUS.wc,Q=i.VK_EQUALS.wc,R=~i.SHIFT,S=new Set([j.VIDEO_STANDARD,j.CPU_CLOCK_MODE,j.Z80_CLOCK_MODE,j.R800_CLOCK_MODE,j.VDP_CLOCK_MODE,j.SPRITE_MODE,j.VSYNCH]),T=new Set([j.SAVE_STATE_0,j.SAVE_STATE_1,j.SAVE_STATE_2,j.SAVE_STATE_3,j.SAVE_STATE_4,j.SAVE_STATE_5,j.SAVE_STATE_6,j.SAVE_STATE_7,j.SAVE_STATE_8,j.SAVE_STATE_9,j.SAVE_STATE_10,j.SAVE_STATE_11,j.SAVE_STATE_12,j.SAVE_STATE_FILE,j.LOAD_STATE_0,j.LOAD_STATE_1,j.LOAD_STATE_2,j.LOAD_STATE_3,j.LOAD_STATE_4,j.LOAD_STATE_5,j.LOAD_STATE_6,j.LOAD_STATE_7,j.LOAD_STATE_8,j.LOAD_STATE_9,j.LOAD_STATE_10,j.LOAD_STATE_11,j.LOAD_STATE_12,j.TRACE]),U=new Set([j.VSYNCH]);!function(){f()}()},wmsx.DOMVirtualKeyboard=function(a,b,c){"use strict";function d(a){a.addEventListener("touchstart",e),a.addEventListener("mousedown",e),
a.addEventListener("touchend",f),a.addEventListener("mouseup",f)}function e(a){h(a);var c=a.target.wmsxKey;c&&(b.processMSXKey(c,!0),"SHIFT"===c&&g())}function f(a){h(a);var c=a.target.wmsxKey;c&&(b.processMSXKey(c,!1),"SHIFT"===c&&g())}function g(){var a=b.isShiftPressed();a!==k&&(k=a,j&&wmsx.VirtualKeyboard.updateKeysLabels(j,k,l,m))}function h(a){a.stopPropagation(),a.preventDefault()}var i=this;this.machineTypeStateUpdate=function(){var a=c.getMachineLang(),b=c.getCodeKeyLabel();a===l&&b===m||(l=a,m=b,j&&wmsx.VirtualKeyboard.updateKeysLabels(j,k,l,m))};var j,k=!1,l="en",m="CODE";!function(){c.addMachineTypeStateListener(i),j=wmsx.VirtualKeyboard.create(a,d,k,l,m)}()},wmsx.ScreenGUI=wmsx.Util.isMobileDevice()?{BAR_HEIGHT:29,BAR_MENU_WIDTH:160,BAR_MENU_ITEM_HEIGHT:33,BAR_MENU_ITEM_FONT_SIZE:14,LOGO_SCREEN_WIDTH:597,LOGO_SCREEN_HEIGHT:455,TOUCH_CONTROLS_LEFT_WIDTH:119,TOUCH_CONTROLS_LEFT_WIDTH_BIG:143,TOUCH_CONTROLS_RIGHT_WIDTH:80}:{BAR_HEIGHT:29,BAR_MENU_WIDTH:150,BAR_MENU_ITEM_HEIGHT:29,BAR_MENU_ITEM_FONT_SIZE:13,LOGO_SCREEN_WIDTH:597,LOGO_SCREEN_HEIGHT:455,TOUCH_CONTROLS_LEFT_WIDTH:119,TOUCH_CONTROLS_LEFT_WIDTH_BIG:143,TOUCH_CONTROLS_RIGHT_WIDTH:80},wmsx.ScreenGUI.html=function(){return'<div id="wmsx-screen-fs" tabindex="0"> <div id="wmsx-screen-fs-center" tabindex="-1"> <div id="wmsx-screen-canvas-outer"> <canvas id="wmsx-screen-canvas" tabindex="-1"></canvas> <img id="wmsx-canvas-loading-icon" draggable="false" src="'+wmsx.Images.urls.loading+'"> <div id="wmsx-unmute-message"></div> <div id="wmsx-logo"> <div id="wmsx-logo-center"> <img id="wmsx-logo-image" draggable="false" src="'+wmsx.Images.urls.logo+'"> <img id="wmsx-logo-loading-icon" draggable="false" src="'+wmsx.Images.urls.loading+'"> <div id="wmsx-logo-message"> <div id="wmsx-logo-message-text"></div> <div id="wmsx-logo-message-ok"> <div id="wmsx-logo-message-ok-text"></div> </div> </div> </div> </div> <div id="wmsx-osd"></div> </div> <div id="wmsx-drop-area"> <div id="wmsx-drop-drivea"><div id="wmsx-drop-drivea-add" class="wmsx-drop-add"></div><i></i><div id="wmsx-drop-drivea-files" class="wmsx-drop-files"></div><br>Drive A</div> <div id="wmsx-drop-driveb"><div id="wmsx-drop-driveb-add" class="wmsx-drop-add"></div><i></i><div id="wmsx-drop-driveb-files" class="wmsx-drop-files"></div><br>Drive B</div> <div id="wmsx-drop-driveh"><i></i><div id="wmsx-drop-driveh-files" class="wmsx-drop-files"></div><br>Hard Drive</div> <div id="wmsx-drop-cart1"><i></i><br>Cartridge 1</div> <div id="wmsx-drop-cart2"><i></i><br>Cartridge 2</div> <div id="wmsx-drop-tape"><i></i><br>Cassette</div> <span id="wmsx-drop-area-message"></span> </div> <div id="wmsx-bar"> <div id="wmsx-bar-inner"></div> </div> </div> <div id="wmsx-screen-scroll-message"> Swipe up/down on the Screen <br>to hide the browser bars! </div> </div>'},wmsx.ScreenGUI.auxHtml=function(){return'<html class="wmsx-full-screen"> <head> <title>WebMSX: 2nd Video</title> <style type="text/css">'+wmsx.ScreenGUI.css()+'</style> </head> <body id="wmsx-aux-body"> <div id="wmsx-screen-fs" tabindex="0"> <div id="wmsx-screen-fs-center" tabindex="-1"> <div id="wmsx-screen-canvas-outer"> <canvas id="wmsx-screen-canvas" tabindex="-1"></canvas> <div id="wmsx-logo"> <div id="wmsx-logo-center"> <img id="wmsx-logo-image" draggable="false" src="'+wmsx.Images.urls.logo+'"> <div id="wmsx-logo-message"> <div id="wmsx-logo-message-text"></div> </div> </div> </div> <div id="wmsx-osd"></div> </div> </div> </div> <script> /* inner/outer dimensions are not reported consistently right after window has opened So we do some async/event tricks to improve reliability */ function onFirstResize() { window.onresize = undefined; setTimeout(function() { opener.WMSX.room.screen.auxWindowFirstResize(window); }, 121); } window.onresize = onFirstResize; /* Make sure we get control even if resize event does not fire */ setTimeout(onFirstResize, 300); <\/script> </body> </html>'},wmsx.ScreenGUI.css=function(){
return"html.wmsx-full-screen-scroll-hack body { position: absolute; width: 100%; height: "+Math.max(1280,1.4*Math.max(screen.width,screen.height)|0)+"px; top: 0; left: 0; margin: 0; padding: 0; border: none; overflow-x: hidden; overflow-y: auto; } #wmsx-aux-body { font-family: sans-serif; font-weight: normal; margin: 0; padding: 0; background: black; overflow: hidden; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; -webkit-touch-callout: none; touch-callout: none; -webkit-tap-highlight-color: transparent; tap-highlight-color: transparent; -webkit-text-size-adjust: none; -moz-text-size-adjust: none; text-size-adjust: none; } #wmsx-screen-fs, #wmsx-screen-fs div, #wmsx-screen-fs canvas { outline: none; } #"+WMSX.SCREEN_ELEMENT_ID+" { display: inline-block; visibility: hidden; font-family: sans-serif; font-weight: normal; margin: 0; padding: 0; border: 1px solid black; background: black; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; -webkit-touch-callout: none; touch-callout: none; -webkit-tap-highlight-color: transparent; tap-highlight-color: transparent; -webkit-text-size-adjust: none; -moz-text-size-adjust: none; text-size-adjust: none; } html.wmsx-full-screen #"+WMSX.SCREEN_ELEMENT_ID+" { display: block; position: absolute; top: 0; left: 0; width: 100%; height: 100%; border: none; box-shadow: none; z-index: 2147483646;    /* one behind fsElement */ } html.wmsx-started #"+WMSX.SCREEN_ELEMENT_ID+" { visibility: visible; } #wmsx-screen-scroll-message { position: absolute; left: 0; right: 0; bottom: -50%; width: 0; height: 0; padding: 0; margin: 0 auto; font-size: 16px; line-height: 28px; color: hsl(0, 0%, 4%); white-space: nowrap; background: hsl(0, 0%, 92%); border-radius: 15px; box-shadow: 2px 2px 9px rgba(0, 0, 0, 0.7); transition: all 1.7s step-end, opacity 1.6s linear; opacity: 0; z-index: -1; } html.wmsx-full-screen-scroll-hack #wmsx-screen-fs.wmsx-scroll-message #wmsx-screen-scroll-message { opacity: 1; bottom: 23%; width: 215px; height: 56px; padding: 13px 20px; z-index: 10; transition: none; } #wmsx-screen-fs { position: relative; background: black; text-align: center; overflow: hidden; -webkit-tap-highlight-color: rgba(0,0,0,0); tap-highlight-color: rgba(0,0,0,0) } html.wmsx-full-screen #wmsx-screen-fs { position: absolute; width: 100%; height: 100%; left: 0; bottom: 0; right: 0; z-index: 2147483647; } html.wmsx-full-screen-scroll-hack #wmsx-screen-fs { position: fixed; bottom: 0; height: 100vh; } html.wmsx-full-screen #wmsx-screen-fs-center {      /* Used to center and move things horizontally in Landscape Full Screen */ position: absolute; top: 0; bottom: 0; left: 0; right: 0; } #wmsx-screen-canvas-outer { display: inline-block; position: relative; vertical-align: top; line-height: 1px; z-index: 3; } #wmsx-screen-canvas { display: block; } #wmsx-bar { position: relative; left: 0; right: 0; height: "+this.BAR_HEIGHT+'px; margin: 0 auto; border-top: 1px solid black; background: hsl(0, 0%, 16%); overflow: visible;                    /* for the Menu to show through */ box-sizing: content-box; z-index: 5; } #wmsx-bar-inner { position: absolute; overflow: hidden; top: 0; bottom: 0; left: 0; right: 0; text-align: left; } html.wmsx-bar-auto-hide #wmsx-bar, html.wmsx-full-screen #wmsx-bar { position: absolute; bottom: 0; transition: height 0.08s ease-in-out; } html.wmsx-bar-auto-hide #wmsx-bar.wmsx-hidden { transition: height 0.5s ease-in-out; height: 0; bottom: -1px; } @media only screen and (orientation: landscape) { html.wmsx-full-screen #wmsx-bar.wmsx-hidden { transition: height 0.5s ease-in-out; height: 0; bottom: -1px; } } #wmsx-bar.wmsx-narrow .wmsx-narrow-hidden, #wmsx-bar.wmsx-semi-narrow .wmsx-semi-narrow-hidden { display: none; } .wmsx-bar-button { display: inline-block; width: 24px; height: 29px; margin: 0 1px; background-image: url("'+wmsx.Images.urls.sprites+'"); background-repeat: no-repeat; background-size: 568px 206px; cursor: pointer; } .wmsx-bar-button.wmsx-media-button { background-size: 284px 103px; } .wmsx-bar-button.wmsx-hidden { display: none; } /* Firefox-specific rules */ @-moz-document url-prefix() { .wmsx-bar-button { image-rendering: optimizequality; } } /* .wmsx-bar-button { border: 1px solid yellow; background-origin: border-box; box-sizing: border-box; } */ #wmsx-bar-power { margin-left: 6px; } #wmsx-bar-media-icons { margin-left: 10px; } #wmsx-bar-settings-icons { float: right; margin: 0 5px 0 -4px; } #wmsx-bar-settings, #wmsx-bar-video, #wmsx-bar-full-screen, #wmsx-bar-scale-plus, #wmsx-bar-scale-minus { margin: 0; } #wmsx-bar-scale-plus { width: 21px; } #wmsx-bar-scale-minus { width: 18px; } #wmsx-bar-text { width: 32px; float: right; } #wmsx-bar-keyboard { position: absolute; left: 0; right: 0; width: 37px; margin: 0 auto; } #wmsx-bar.wmsx-narrow #wmsx-bar-keyboard { position: static; float: right; } .wmsx-bar-mobile #wmsx-bar-settings-icons > * { margin: 0 0 0 6px; } .wmsx-bar-mobile #wmsx-bar-text, .wmsx-bar-mobile #wmsx-bar.wmsx-narrow #wmsx-bar-keyboard { margin: 0 6px 0 0; } #wmsx-bar-logo { position: absolute; left: 0; right: 0; width: 52px; margin: 0 auto; } #wmsx-bar-turbo, #wmsx-bar-caps, #wmsx-bar-kana, #wmsx-bar-pause { position: absolute; left: 0; right: 0; height: 29px; padding: 8px 0 0 0; color: hsl(0, 100%, 64%); font-weight: bold; font-size: 12px; line-height: 14px; text-shadow: 2px 2px 0 black; vertical-align: top; box-sizing: border-box; cursor: auto; } #wmsx-bar-pause     { right: 88px; width: 20px; margin: 0 auto; } #wmsx-bar-turbo     { left: 88px;  width: 20px; margin: 0 auto; padding-left: 25px; cursor: pointer; } #wmsx-bar-caps, #wmsx-bar-kana    { position: relative; float: right; width: auto; margin-right: 18px; background: none; } #wmsx-bar.wmsx-narrow #wmsx-bar-turbo { position: static; margin-right: 2px; width: auto; } #wmsx-bar-menu { position: absolute; display: none; bottom: '+this.BAR_HEIGHT+"px; font-size: "+this.BAR_MENU_ITEM_FONT_SIZE+"px; line-height: 1px; overflow: hidden; transform-origin: bottom center; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } #wmsx-bar-menu-inner { display: inline-block; padding-bottom: 2px; border: 1px solid black; background: hsl(0, 0%, 16%); } .wmsx-bar-menu-item, #wmsx-bar-menu-title { position: relative; display: none; width: "+this.BAR_MENU_WIDTH+"px; height: "+this.BAR_MENU_ITEM_HEIGHT+"px; color: rgb(205, 205, 205); border: none; padding: 0; line-height: "+this.BAR_MENU_ITEM_HEIGHT+'px; text-shadow: 1px 1px 1px black; background: transparent; outline: none; overflow: hidden; backface-visibility: hidden; -webkit-backface-visibility: hidden; cursor: pointer; box-sizing: border-box; } #wmsx-bar-menu-title { display: block; color: white; font-weight: bold; border-bottom: 1px solid black; margin-bottom: 1px; text-align: center; background: rgb(70, 70, 70); cursor: auto; } .wmsx-bar-menu-item.wmsx-hover:not(.wmsx-bar-menu-item-disabled):not(.wmsx-bar-menu-item-divider) { color: white; background: hsl(358, 67%, 46%); } .wmsx-bar-menu-item-disabled { color: rgb(110, 110, 110); } .wmsx-bar-menu-item-divider { height: 1px; margin: 1px 0; background: black; } .wmsx-bar-menu-item-toggle { text-align: left; padding-left: 40px; } .wmsx-bar-menu-item-toggle::before, .wmsx-bar-menu-item-toggle::after { content: ""; position: absolute; width: 6px; height: 9px; top: '+((this.BAR_MENU_ITEM_HEIGHT-21)/2|0)+"px; left: 16px; background: rgb(82, 82, 82); box-shadow: black 1px 1px 1px; } .wmsx-bar-menu-item-toggle::after { top: "+((this.BAR_MENU_ITEM_HEIGHT-21)/2+10|0)+"px; } .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked:not(.wmsx-bar-menu-item-disabled) { color: white; } .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked:not(.wmsx-bar-menu-item-disabled).wmsx-op1::before, .wmsx-bar-menu-item-toggle.wmsx-bar-menu-item-toggle-checked:not(.wmsx-bar-menu-item-disabled).wmsx-op2::after { background: rgb(254, 32, 30); } .wmsx-bar-menu-item-toggle.wmsx-no-op2::before { top: "+((this.BAR_MENU_ITEM_HEIGHT-21)/2+2|0)+"px; height: 16px; } .wmsx-bar-menu-item-toggle.wmsx-no-op2::after, .wmsx-bar-menu-item-toggle-radio::after { display: none; } .wmsx-bar-menu-item-toggle-radio::before { width: 12px  !important; height: 12px  !important; top: "+((this.BAR_MENU_ITEM_HEIGHT-12)/2|0)+'px  !important; left: 14px; border-radius: 100%; box-shadow: black 1px 1px 1px 1px; } .wmsx-select-dialog { position: absolute; overflow: hidden; display: none; top: 0; bottom: 0; left: 0; right: 0; width: 540px; max-width: 92%; height: 297px; margin: auto; color: white; font-size: 18px; background: hsl(0, 0%, 16%); padding: 14px 0 0; text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 4; } .wmsx-select-dialog.wmsx-show { display: block; } .wmsx-select-dialog > .wmsx-footer { position: absolute; width: 100%; bottom: 7px; font-size: 13px; text-align: center; color: rgb(170, 170, 170); } .wmsx-select-dialog > ul { position: relative; width: 88%; top: 5px; margin: auto; padding: 0; list-style: none; font-size: 14px; color: hsl(0, 0%, 88%); } .wmsx-select-dialog > ul li { display: none; position: relative; overflow: hidden; height: 26px; background: rgb(70, 70, 70); margin: 7px 0; padding: 11px 10px 0; line-height: 0; text-align: left; text-overflow: ellipsis; border: 2px dashed transparent; box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); white-space: nowrap; box-sizing: border-box; cursor: pointer; } .wmsx-select-dialog > ul li.wmsx-visible { display: block; } .wmsx-select-dialog > ul li.wmsx-selected { color: white; background: hsl(358, 67%, 46%); } .wmsx-select-dialog > ul li.wmsx-droptarget { color: white; border-color: lightgray; } .wmsx-select-dialog > ul li.wmsx-toggle::after { content: ""; position: absolute; width: 6px; height: 17px; top: 2px; left: 6px; background: rgb(60, 60, 60); box-shadow: black 1px 1px 1px; } .wmsx-select-dialog > ul li.wmsx-toggle-checked::after { background: rgb(254, 32, 30); } #wmsx-diskselect.wmsx-select-dialog li { padding-left: 23px; } #wmsx-diskselect.wmsx-select-dialog li.wmsx-toggle::after { background: hsl(0, 0%, 73%); } #wmsx-diskselect.wmsx-select-dialog li.wmsx-toggle-checked::after { background: rgb(230, 205, 31); } #wmsx-cartridge-format.wmsx-select-dialog > ul { width: 100%; height: 292px; margin: 7px auto 0; padding: 0 0 0 30px; overflow-y: auto; box-sizing: border-box; } #wmsx-cartridge-format.wmsx-select-dialog > ul li { width: 220px; margin: 7px 0 2px 0; } #wmsx-cartridge-format.wmsx-select-dialog > ul li:first-child { margin-top: 0; } #wmsx-cartridge-format ::-webkit-scrollbar { width: 12px; } #wmsx-cartridge-format ::-webkit-scrollbar-track { background: transparent; } #wmsx-cartridge-format ::-webkit-scrollbar-thumb { border: solid transparent; border-width: 1px 1px 1px 2px; background: rgb(80, 80, 80); background-clip: content-box; } #wmsx-cartridge-format ul.wmsx-quick-options-list { width: 220px; margin: 18px 0 0 30px; } #wmsx-cartridge-format ul.wmsx-quick-options-list li div { height: 24px; line-height: 24px; } #wmsx-cartridge-format .wmsx-control { width: 52px; line-height: 24px; cursor: pointer; } /* Firefox-specific rules */ @-moz-document url-prefix() { /* Try to hide scrollbar, since we cant style it :-( */ #wmsx-cartridge-format.wmsx-select-dialog > ul { width: 304px; } } #wmsx-savestate { width: 280px; height: 403px; } #wmsx-savestate.wmsx-load { height: 438px; } #wmsx-savestate ul.wmsx-quick-options-list { display: none; width: 220px; margin: 18px 0 0 30px; } #wmsx-savestate.wmsx-load ul.wmsx-quick-options-list { display: block; } #wmsx-savestate ul.wmsx-quick-options-list li div { height: 24px; line-height: 24px; } #wmsx-savestate .wmsx-control { width: 52px; cursor: pointer; } #wmsx-logo { position: absolute; display: none; top: 0; bottom: 0; left: 0; right: 0; background: black; } #wmsx-logo.wmsx-show { display: block; } #wmsx-logo-center { position: absolute; top: 50%; left: 50%; width: 598px; height: 456px; transform: translate(-50%, -50%); } #wmsx-screen-fs:not(.wmsx-logo-message-active) #wmsx-logo-center { max-width: 100%; max-height: 100%; } #wmsx-logo-image { position: absolute; top: 50%; left: 50%; width: 334px; max-width: 57%; transform: translate(-50%, -50%); -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; } html.wmsx-full-screen #wmsx-logo-image { max-width: 67%; } #wmsx-screen-fs.wmsx-logo-message-active #wmsx-logo-image { top: 138px; max-width: initial; } #wmsx-unmute-message { display: none; position: absolute; left: 50%; bottom: 5px; height: 30px; padding: 0 10px; margin: 0 auto; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; font-weight: 500; font-size: 15px; line-height: 30px; color: rgb(210, 210, 210); background: rgba(0, 0, 0, 0.7); transform-origin: bottom center; transform: translate(-50%, 0); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } #wmsx-unmute-message::before { content: ""; display: inline-block; width: 24px; height: 20px; margin: 5px 9px 0 0; background-image: url("'+wmsx.Images.urls.muteIcon+'"); background-repeat: no-repeat; background-size: 24px 20px; vertical-align: top; } #wmsx-unmute-message::after { content: "Audio is muted. Click to unmute"; } #wmsx-unmute-message.wmsx-show { display: inline-block; } #wmsx-logo-loading-icon, #wmsx-canvas-loading-icon { display: none; position: absolute; top: 62%; left: 0; right: 0; width: 14%; height: 3%; margin: 0 auto; background-color: rgba(0, 0, 0, .8); border: solid transparent; border-width: 12px 30px; border-radius: 3px; box-sizing: content-box; -webkit-user-select: none; -moz-user-select: none; -ms-user-select: none; user-select: none; } #wmsx-screen-fs.wmsx-logo-message-active #wmsx-logo-loading-icon { top: 190px; } #wmsx-logo-message { display: none; position: absolute; top: 224px; width: 100%; color: hsl(0, 0%, 97%); font-size: 29px; line-height: 34px; } #wmsx-screen-fs.wmsx-logo-message-active #wmsx-logo-message { display: block; } #wmsx-logo-message-ok { display: block; position: absolute; top: 91px; left: 193px; width: 214px; height: 130px; } #wmsx-logo-message-ok.wmsx-higher { top: 74px; } #wmsx-logo-message-ok-text { position: absolute; top: 49%; left: 50%; width: 120px; height: 47px; font-size: 23px; line-height: 47px; background: hsl(358, 67%, 46%); border-radius: 6px; color: white; transform: translate(-50%, -50%); } #wmsx-osd { position: absolute; overflow: hidden; text-overflow: ellipsis; white-space: nowrap; top: -29px; right: 20px; height: 28px; padding: 0 10px; margin: 0; font-weight: bold; font-size: 15px; line-height: 28px; color: rgb(0, 255, 0); background: rgba(0, 0, 0, 0.7); transform-origin: top right; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; opacity: 0; } #wmsx-copy-texarea { position: absolute; width: 50px; height: 0; bottom: 0; z-index: -10; opacity: 0; } #wmsx-paste-cover { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 340px; height: 136px; margin: auto; border-radius: 20px; background: rgba(0, 0, 0, 0.4); z-index: 1; } #wmsx-paste-cover.wmsx-show { display: block; } #wmsx-paste-box { position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 270px; height: 66px; margin: auto; background: rgba(255, 40, 40, 0.75); font-weight: bold; font-size: 26px; text-align: center; color: transparent; border: 2px dashed rgba(240, 240, 240, 0.70); box-sizing: initial; border-radius: 10px; text-shadow: 0 0 0 rgb(240, 240, 240); padding: 0; outline: none; } #wmsx-text-entry-dialog { display: none; position: absolute; top: 50%; left: 0; right: 0; width: 96%; max-width: 540px; height: 60%; min-height: 125px; max-height: 450px; margin: 0 auto; color: white; font-size: 19px; line-height: 23px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; transform: translate(0, -65%); cursor: auto; z-index: 4; } #wmsx-text-entry-dialog.wmsx-show { display: block; } #wmsx-text-entry-dialog-bar { position: absolute; height: 40px; width: 100%; line-height: 40px; background: inherit; overflow: hidden; } #wmsx-text-entry-dialog-bar::before { content: "Input Text"; } #wmsx-text-entry-dialog-ok, #wmsx-text-entry-dialog-cancel { display: inline-block; float: right; width: 70px; height: 22px; margin-right: 15px; border: 9px solid hsl(0, 0%, 16%); border-left: none; border-right: none; font-size: 14px; line-height: 22px; background: hsl(358, 67%, 46%); cursor: pointer; } #wmsx-text-entry-dialog-cancel { color: hsl(0, 0%, 90%); background: hsl(0, 0%, 30%); } #wmsx-text-entry-dialog-ok::before { content: "OK"; } #wmsx-text-entry-dialog-cancel::before { content: "CANCEL"; } #wmsx-text-entry-input { position: absolute; top: 15px; left: 15px; width: calc(100% - 30px); height: calc(100% - 30px); padding: 29px 6px 4px; font-size: 16px; border: none; border-radius: 0; background: hsl(0, 0%, 90%); box-sizing: border-box; resize: none; outline: none; -webkit-touch-callout: default; touch-callout: default; } .wmsx-arrow-up, .wmsx-arrow-down, .wmsx-arrow-left, .wmsx-arrow-right { border: 0px solid transparent; box-sizing: border-box; } .wmsx-arrow-up    { border-bottom-color: inherit; } .wmsx-arrow-down  { border-top-color: inherit; } .wmsx-arrow-left  { border-right-color: inherit; } .wmsx-arrow-right { border-left-color: inherit; } .wmsx-keyboard-key { position: absolute; height: 25px; padding: 5px 0 0; overflow: hidden; font-weight: normal; font-size: 10px; line-height: 10px; text-align: center; vertical-align: top; color: white; background: hsl(0, 0%, 66%); border: 3px solid hsl(0, 0%, 50%); border-top: 1px solid hsl(0, 0%, 54%); border-bottom: 5px solid hsl(0, 0%, 33%); border-radius: 3px 3px 0 0; box-shadow: 0 1px 0 1px rgb(0, 0, 0); box-sizing: border-box; cursor: pointer; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; } .wmsx-keyboard-key.wmsx-keyboard-key-dark { background: hsl(0, 0%, 46%); border-color: hsl(0, 0%, 36%); border-top-color: hsl(0, 0%, 40%); border-bottom-color: hsl(0, 0%, 24%); } .wmsx-keyboard-key.wmsx-keyboard-key-unmapped { color: rgb(30, 30, 30); font-weight: bold; -webkit-font-smoothing: initial; -moz-osx-font-smoothing: initial; } .wmsx-keyboard-alpha, .wmsx-keyboard-num, .wmsx-keyboard-arrows { position: absolute; } .wmsx-keyboard-alpha > div, .wmsx-keyboard-num > div, .wmsx-keyboard-arrows > div { position: absolute; } .wmsx-keyboard-num { left: 416px; } .wmsx-keyboard-arrows { top: 104px; left: 417px; } .wmsx-keyboard-f1, .wmsx-keyboard-f2, .wmsx-keyboard-f3, .wmsx-keyboard-f4, .wmsx-keyboard-f5, .wmsx-keyboard-stop, .wmsx-keyboard-select, .wmsx-keyboard-home, .wmsx-keyboard-insert, .wmsx-keyboard-delete { height: 18px; padding-top: 2px; font-size: 9px; line-height: 9px; border-width: 1px 2px 4px; } .wmsx-keyboard-stop { margin-left: 10px; background: hsl(0, 70%, 54%); border-color: hsl(0, 70%, 36%); border-top-color: hsl(0, 70%, 40%); border-bottom-color: hsl(0, 70%, 28%); } .wmsx-keyboard-enter { border-radius: 2px 3px 0 0; border-top: none; box-shadow: none; overflow: visible; } .wmsx-keyboard-enter::after { content: ""; display: block; position: absolute; left: -10px; bottom: -7px; width: 20px; height: 2px; background: black; } .wmsx-keyboard-enter_x1 { border-radius: 2px 0 0 0; border-width: 1px; border-right: none; box-shadow: -1px 1px 0 0 black; } .wmsx-keyboard-enter_x2 { overflow: visible; padding: 0; border: none; border-radius: 0 3px 0 0; box-shadow: none; box-shadow: 1px 1px 0 0 black; } .wmsx-keyboard-enter_x2::after { content: ""; display: block; width: 30px; height: 50px; background: inherit; border: 3px solid hsl(0, 0%, 36%); border-top: 1px solid hsl(0, 0%, 40%); border-bottom: 5px solid hsl(0, 0%, 24%); border-radius: 0 3px 0 0; box-shadow: 1px 2px 0 0 black, 1px 0 0 0 black; box-sizing: border-box; } .wmsx-keyboard-capslock { margin-left: 16px; } .wmsx-keyboard-space { left: 103px; width: 217px; } .wmsx-keyboard-dead { left: 333px; width: 26px; } .wmsx-keyboard-shift2 { left: 360px; width: 41px; } .wmsx-keyboard-code { left: 321px; width: 46px; } .wmsx-keyboard-num .wmsx-keyboard-key { height: 23px; padding-top: 4px; } .wmsx-keyboard-arrows .wmsx-keyboard-key { font-size: 8px; line-height: 9px; background: rgb(70, 85, 180); border-width: 1px 2px 4px; border-radius: 2px 2px 0 0; border-color: hsl(232, 44%, 37%); border-top-color: hsl(232, 44%, 40%); border-bottom-color: hsl(232, 44%, 24%); } .wmsx-keyboard-left, .wmsx-keyboard-right { top: 6px; width: 26px; height: 33px; padding: 10px 0 0 6px; } .wmsx-keyboard-up, .wmsx-keyboard-down { left: 27px; width: 37px; height: 23px; padding: 5px 0 0 12px; } .wmsx-keyboard-down { top: 23px; padding-top: 7px; } .wmsx-keyboard-right { left: 65px; padding-left: 10px; } .wmsx-keyboard-up::after, .wmsx-keyboard-down::after, .wmsx-keyboard-left::after, .wmsx-keyboard-right::after { content: ""; display: block; border: 4px solid transparent; width: 6px; height: 6px; box-sizing: border-box; } .wmsx-keyboard-up::after { border-bottom: 5px solid white; border-top-width: 0; } .wmsx-keyboard-up.wmsx-keyboard-key-unmapped::after { border-bottom-color: black; } .wmsx-keyboard-down::after { border-top: 5px solid white; border-bottom-width: 0; } .wmsx-keyboard-down.wmsx-keyboard-key-unmapped::after { border-top-color: black; } .wmsx-keyboard-left::after { border-right: 5px solid white; border-left-width: 0; } .wmsx-keyboard-left.wmsx-keyboard-key-unmapped::after { border-right-color: black; } .wmsx-keyboard-right::after { border-left: 5px solid white; border-right-width: 0; } .wmsx-keyboard-right.wmsx-keyboard-key-unmapped::after { border-left-color: black; } .wmsx-keyboard-narrow .wmsx-keyboard-num { display: none; } .wmsx-keyboard-narrow .wmsx-keyboard-arrows { left: 336px; } .wmsx-keyboard-narrow .wmsx-keyboard-space { width: 155px; } .wmsx-keyboard-narrow .wmsx-keyboard-code { left: 259px; width: 39px; } .wmsx-keyboard-narrow .wmsx-keyboard-dead { left: 299px; top: 25px; } .wmsx-keyboard-narrow .wmsx-keyboard-shift2 { display: none; } .wmsx-keyboard-narrow .wmsx-keyboard-left, .wmsx-keyboard-narrow .wmsx-keyboard-right  { top: 9px; width: 23px; height: 27px; padding: 7px 0 0 5px; border-bottom-width: 3px; } .wmsx-keyboard-narrow .wmsx-keyboard-up, .wmsx-keyboard-narrow .wmsx-keyboard-down  { left: 24px; width: 26px; padding-left: 7px; border-bottom-width: 3px; } .wmsx-keyboard-narrow .wmsx-keyboard-right  { left: 51px; padding-left: 8px; } #wmsx-virtual-keyboard { display: none; position: absolute; left: 50%; bottom: '+(this.BAR_HEIGHT+2)+'px; overflow: hidden; margin: 0 auto; padding: 5px 0 0 4px; width: 518px; height: 161px; background: hsl(0, 0%, 16%); box-sizing: border-box; transform: translateX(-50%); transform-origin: center bottom; transition: height 0.3s ease-in-out; text-align: left; z-index: 2; } html.wmsx-full-screen.wmsx-virtual-keyboard-active #wmsx-virtual-keyboard { display: block; } .wmsx-quick-options-list { margin-top: 12px; padding: 0; list-style: none; color: hsl(0, 0%, 88%); } .wmsx-quick-options-list li { margin-top: 9px; line-height: 1px; text-align: left; } .wmsx-quick-options-list li.wmsx-hidden { display: none; } .wmsx-quick-options-list li div { display: inline-block; overflow: hidden; height: 26px; font-size: 14px; line-height: 26px; text-overflow: ellipsis; white-space: nowrap; box-sizing: border-box; } .wmsx-quick-options-list .wmsx-control { position: relative; float: right; width: 134px; font-size: 15px; line-height: 25px; color: hsl(0, 0%, 70%); background: black; text-align: center; box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); } .wmsx-quick-options-list .wmsx-control > button { position: absolute; top: 0; bottom: 0; width: 26px; height: 100%; background: rgb(70, 70, 70); border: none; outline: none; cursor: pointer; -webkit-appearance: none; } .wmsx-quick-options-list .wmsx-control > button::after { content: ""; position: absolute; top: 7px; border: 6px solid transparent; } .wmsx-quick-options-list .wmsx-control .wmsx-control-dec { left: 0; border-right: 1px solid black; } .wmsx-quick-options-list .wmsx-control .wmsx-control-dec::after { left: 2px; border-right-color: #c0c0c0; } .wmsx-quick-options-list .wmsx-control .wmsx-control-inc { right: 0; border-left: 1px solid black; } .wmsx-quick-options-list .wmsx-control .wmsx-control-inc::after { right: 2px; border-left-color: #c0c0c0; } .wmsx-quick-options-list .wmsx-control.wmsx-selected { color: white; background: hsl(358, 67%, 46%); box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); } .wmsx-quick-options-list .wmsx-control.wmsx-selected.wmsx-inactive { line-height: 21px; border: 2px dashed hsl(358, 67%, 46%); background: black; } #wmsx-quick-options { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 270px; height: 386px; margin: auto; padding: 14px 15px 0; color: white; font-size: 18px; line-height: 22px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 3; } #wmsx-quick-options.wmsx-show { display: block; } #wmsx-quick-options::before { content: "Quick Options"; display: block; } #wmsx-netplay { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 390px; height: 220px; margin: auto; padding-top: 11px; color: white; font-size: 18px; line-height: 22px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: initial; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); transform-origin: left center; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 50; } #wmsx-netplay.wmsx-show { display: block; } #wmsx-netplay::before { content: "Net Play!"; display: block; } #wmsx-netplay-status-box { position: relative; margin-top: 17px; } #wmsx-netplay-status { display: inline-block; position: relative; width: 340px; font-size: 15px; line-height: 27px; background: black; vertical-align: top; text-shadow: none; -webkit-user-select: text; -moz-user-select: text; -ms-user-select: text; user-select: text; box-sizing: border-box; cursor: auto; } #wmsx-netplay-status-box.wmsx-active #wmsx-netplay-status { padding: 0 16px 0 12px; } #wmsx-netplay-status-box.wmsx-active #wmsx-netplay-status::after { content: ""; position: absolute; width: 6px; height: 18px; top: 4px; left: 7px; background: rgb(254, 32, 30); } #wmsx-netplay-link { display: none; position: absolute; right: 25px; top: 0; width: 26px; height: 27px; color: white; font-size: 15px; font-weight: 600; line-height: 27px; text-decoration: none; background: black; text-align: center; } #wmsx-netplay-link:hover { background: hsl(358, 67%, 46%); cursor: pointer; } #wmsx-netplay-status-box.wmsx-active #wmsx-netplay-link { display: block; } .wmsx-netplay-button { display: inline-block; width: 86px; padding: 0; margin: 0; font-size: 15px; line-height: 26px; color: white; background: hsl(358, 67%, 46%); text-shadow: 1px 1px 1px black; border: none; box-shadow: 1px 1px 1px rgba(0, 0, 0, .5); cursor: pointer; } #wmsx-netplay-session-box { margin-top: 18px; } #wmsx-netplay-session-label, #wmsx-netplay-nick-label { font-size: 15px; margin-bottom: 4px; } #wmsx-netplay-session-label::before { content: "Session Name"; } #wmsx-netplay-session-box input { width: 150px; height: 26px; padding: 0 10px; margin: 0 8px; font-size: 15px; line-height: 26px; background: rgb(240, 240, 240); border: none; border-radius: 0; box-sizing: border-box; outline: none; -webkit-user-select: text; -moz-user-select: text; -ms-user-select: text; user-select: text; cursor: auto; } #wmsx-netplay-nick-label { margin-top: 10px; } #wmsx-netplay-nick-label::before { content: "User Nickname"; } .wmsx-netplay-button:disabled { color: rgb(130, 130, 130); background: rgb(70, 70, 70); cursor: default; } #wmsx-netplay input:disabled { color: black; background: rgb(180, 180, 180); cursor: default; } #wmsx-netplay-session-box.wmsx-disabled div { color: rgb(130, 130, 130); } input#wmsx-netplay-link-text { position: absolute; top: 8px; left: 50px; width: 1px; height: 1px; padding: 0; margin: 0; border: none; color: transparent; background: transparent; opacity: 0; z-index: -10; -webkit-user-select: text; -moz-user-select: text; -ms-user-select: text; user-select: text; } #wmsx-touch-config { display: none; position: absolute; top: 0; bottom: 0; left: 0; right: 0; width: 294px; height: 304px; margin: auto; padding: 0 16px; color: white; font-size: 18px; line-height: 22px; background: hsl(0, 0%, 16%); text-align: center; border: 1px solid black; box-sizing: border-box; text-shadow: 1px 1px 1px black; box-shadow: 3px 3px 15px 2px rgba(0, 0, 0, .4); -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; cursor: auto; z-index: 3; } #wmsx-screen-fs.wmsx-touch-config-active #wmsx-touch-config { display: block; } #wmsx-touch-config::after { content: "Tap Control to Setup"; position: absolute; display: block; top: 14px; left: 0; width: 100%; } #wmsx-touch-config::before { content: ""; display: block; margin-top: 46px; height: 68px; background: black; } #wmsx-touch-config-minus, #wmsx-touch-config-plus { position: absolute; top: 46px; width: 72px; height: 68px; cursor: pointer; } #wmsx-touch-config-minus { left: 19px; } #wmsx-touch-config-plus { right: 19px; } #wmsx-touch-config-minus::after, #wmsx-touch-config-plus::after { content: ""; position: absolute; top: 20px; border: 14px solid transparent; } #wmsx-touch-config-minus::after { left: 9px; border-right: 18px solid #c0c0c0; } #wmsx-touch-config-minus.wmsx-disabled::after { border-right-color: #404040; } #wmsx-touch-config-plus::after { right: 9px; border-left: 18px solid #c0c0c0; } #wmsx-touch-config-plus.wmsx-disabled::after { border-left-color: #404040; } #wmsx-touch-config-dir { display: none; position: absolute; top: 15px; left: 79px; transform: scale(.70); } #wmsx-touch-config-dir.wmsx-show { display: block; } #wmsx-touch-config-dir::before { display: none; } #wmsx-touch-config-button { display: none; position: absolute; top: 46px; right: 109px; text-shadow: none; } #wmsx-touch-config-button.wmsx-show { display: block; } #wmsx-touch-config .wmsx-quick-options-list { margin-top: 11px; } #wmsx-touch-config .wmsx-control { width: 110px; } #wmsx-touch-left, #wmsx-touch-right { display: none; position: absolute; z-index: 1; } #wmsx-touch-speed { display: none; } html.wmsx-full-screen.wmsx-touch-active #wmsx-touch-left, html.wmsx-full-screen.wmsx-touch-active #wmsx-touch-right, html.wmsx-full-screen.wmsx-touch-active #wmsx-touch-speed { display: block; } .wmsx-touch-dir { position: relative; width: 130px; height: 130px; color: hsl(0, 0%, 75%); border-radius: 100%; z-index: 2 } .wmsx-touch-dir::before { content: ""; position: absolute; top: 14px; left: 14px; right: 14px; bottom: 14px; border: 1px solid hsl(0, 0%, 26%); border-radius: 100%; } .wmsx-touch-dir-joy .wmsx-touch-dir-up, .wmsx-touch-dir-joy .wmsx-touch-dir-left { position: absolute; background: hsl(0, 0%, 31%); border-radius: 2px 2px 0 0; box-shadow: inset 1px 2px 0px hsl(0, 0%, 43%), inset -1px -1px hsl(0, 0%, 19%), 0 3px 0 1px hsl(0, 0%, 21%); } .wmsx-touch-dir-joy .wmsx-touch-dir-up { width: 26px; height: 78px; top: 24px; left: 52px; } .wmsx-touch-dir-joy .wmsx-touch-dir-left { width: 78px; height: 25px; top: 51px; left: 26px; } .wmsx-touch-dir-joy .wmsx-touch-dir-left::before { content: ""; position: absolute; top: 2px; left: 23px; width: 33px; height: 22px; background: inherit; z-index: 1; } .wmsx-touch-dir-joy .wmsx-touch-dir-left::after { content: ""; position: absolute; top: 4px; left: 30px; height: 17px; width: 17px; border-radius: 100%; box-shadow:  inset 0 0 2px hsl(0, 0%, 22%), inset 1px 2px 3px 1px hsl(0, 0%, 26%), inset -1px -2px 1px hsl(0, 0%, 64%); z-index: 2; } .wmsx-touch-dir-key .wmsx-touch-dir-up, .wmsx-touch-dir-key .wmsx-touch-dir-left, .wmsx-touch-dir-key .wmsx-touch-dir-down, .wmsx-touch-dir-key .wmsx-touch-dir-right { position: absolute; background: rgb(70, 85, 180); border: 0 solid hsl(232, 44%, 37%); border-width: 1px 2px 4px; border-top-color: hsl(232, 44%, 40%); border-bottom-color: hsl(232, 44%, 24%); border-radius: 2px 2px 0 0; box-sizing: border-box; } .wmsx-touch-dir-key .wmsx-touch-dir-up, .wmsx-touch-dir-key .wmsx-touch-dir-down { left: 50px; width: 30px; } .wmsx-touch-dir-key .wmsx-touch-dir-up { top: 26px; height: 25px; border-bottom-width: 2px; } .wmsx-touch-dir-key .wmsx-touch-dir-down { bottom: 26px; height: 27px; } .wmsx-touch-dir-key .wmsx-touch-dir-left, .wmsx-touch-dir-key .wmsx-touch-dir-right { top: 47px; width: 25px; height: 36px; } .wmsx-touch-dir-key .wmsx-touch-dir-left { left: 24px; } .wmsx-touch-dir-key .wmsx-touch-dir-right { right: 24px; } .wmsx-touch-dir-key .wmsx-touch-dir-up::after { content: ""; position: absolute; top: 26px; left: -1px; width: 28px; height: 22px; background: hsl(0, 0%, 20%); } .wmsx-touch-dir .wmsx-arrow-up, .wmsx-touch-dir .wmsx-arrow-down, .wmsx-touch-dir .wmsx-arrow-left, .wmsx-touch-dir .wmsx-arrow-right { position: absolute; border-width: 5px; z-index: 2; } .wmsx-touch-dir .wmsx-arrow-up { top: 26px; left: 60px; border-bottom-width: 11px; } .wmsx-touch-dir .wmsx-arrow-down { bottom: 29px; left: 60px; border-top-width: 11px; } .wmsx-touch-dir .wmsx-arrow-left { top: 58px; left: 26px; border-right-width: 11px; } .wmsx-touch-dir .wmsx-arrow-right { top: 58px; right: 26px; border-left-width: 11px; } .wmsx-touch-button { position: relative; display: block; width: 72px; height: 72px; font-size: 20px; line-height: 67px; color: hsl(0, 0%, 79%); border-radius: 100%; cursor: default; -webkit-font-smoothing: antialiased; -moz-osx-font-smoothing: grayscale; z-index: 0; } .wmsx-touch-button::before { content: ""; position: absolute; box-sizing: border-box; z-index: -1; } .wmsx-touch-button-joy::before, .wmsx-touch-button-none::before { width: 50px; height: 48px; top: 9px; left: 11px; border-radius: 100%; } #wmsx-screen-fs.wmsx-touch-config-active .wmsx-touch-button-none::before { border: 2px solid hsl(0, 0%, 30%); } .wmsx-touch-button-joy.wmsx-touch-button-joy-A::before { border: none; background: hsl(120, 76%, 31%); box-shadow: inset 0 2px hsl(120, 76%, 41%), 0 4px 0 1px hsl(120, 76%, 20%); } .wmsx-touch-button-joy.wmsx-touch-button-joy-B::before { border: none; background: hsl(0, 60%, 35%); box-shadow: inset 0 2px hsl(0, 60%, 48%), 0 4px 0 1px hsl(0, 60%, 23%); } .wmsx-touch-button-joy.wmsx-touch-button-joy-AB::before { border: none; background: hsl(240, 50%, 48%); box-shadow: inset 0 2px hsl(240, 50%, 60%), 0 4px 0 1px hsl(240, 50%, 31%); } .wmsx-touch-button-key { font-size: 16px; line-height: 69px; } .wmsx-touch-button-key::before { width: 48px; height: 46px; top: 13px; left: 12px; background: hsl(0, 0%, 44%); border: 4px solid hsl(0, 0%, 31%); border-top: 2px solid hsl(0, 0%, 54%); border-bottom: 6px solid hsl(0, 0%, 22%); border-radius: 3px 3px 1px 1px; } #wmsx-touch-T_A { z-index: 7 } #wmsx-touch-T_B { z-index: 6 } #wmsx-touch-T_C { z-index: 5 } #wmsx-touch-T_D { z-index: 4 } #wmsx-touch-T_E { z-index: 3 } #wmsx-touch-T_F { z-index: 2 } #wmsx-touch-T_G { z-index: 1 } #wmsx-touch-T_X { z-index: 1 } #wmsx-touch-T_Y { z-index: 1 } #wmsx-touch-pause, #wmsx-touch-fast { float: left; width: 46px; height: 48px; border-color: hsl(0, 0%, 70%); } #wmsx-touch-pause::after, #wmsx-touch-fast::before, #wmsx-touch-fast::after { content: ""; display: inline-block; border: 0 solid transparent; box-sizing: border-box; } #wmsx-touch-pause::after { margin-top: 16px; width: 14px; height: 16px; border-width: 0; border-left-width: 4px; border-left-color: inherit; border-right-width: 4px; border-right-color: inherit; } #wmsx-touch-fast::before, #wmsx-touch-fast::after { margin-top: 16px; width: 12px; height: 16px; border-width: 8px; border-left-width: 12px; border-left-color: inherit; border-right-width: 0; } #wmsx-touch-speed.wmsx-paused #wmsx-touch-pause::after, #wmsx-touch-speed.wmsx-poweroff #wmsx-touch-pause::after { margin-top: 14px; width: 17px; height: 20px; border-width: 10px; border-left-width: 17px; border-right-width: 0; } #wmsx-touch-speed.wmsx-paused  #wmsx-touch-fast::after { width: 7px; border-width: 0; border-left-width: 3px; } #wmsx-touch-speed.wmsx-poweroff #wmsx-touch-fast { display: none; } .wmsx-hd-first { float: left; } #wmsx-drop-area { position: absolute; display: none; bottom: 56px; width: 574px; height: 238px; margin: auto; padding: 0; font-size: 0; line-height: 0; color: hsl(0, 0%, 82%); background: black; text-align: left; transform-origin: left bottom; z-index: 99; } #wmsx-drop-area.wmsx-visible { display: block; } #wmsx-drop-area > div { position: relative; display: inline-block; width: 178px; height: 90px; margin: 10px 0 0 10px; padding: 0; font-size: 19px; line-height: 24px; text-shadow: 2px 2px black; text-align: center; background: hsl(0, 0%, 16%); vertical-align: bottom; box-sizing: border-box; } #wmsx-drop-area > div.wmsx-disabled { color: #616161; } #wmsx-drop-area > div:not(.wmsx-disabled).wmsx-selected { background: hsl(358, 67%, 38%); } #wmsx-drop-area-message { position: absolute; left: 0; right: 0; bottom: 2px; height: 34px; font-size: 16px; line-height: 34px; text-align: center; } #wmsx-drop-area i { display: inline-block; margin: 11px auto 7px; width: 41px; height: 36px; background: url("'+wmsx.Images.urls.sprites+'"); background-size: 568px 206px; vertical-align: bottom; } #wmsx-drop-drivea i { background-position: -334px -107px; } #wmsx-drop-drivea.wmsx-disabled i { background-position: -334px -156px; } #wmsx-drop-driveb i { background-position: -392px -107px; } #wmsx-drop-driveb.wmsx-disabled i { background-position: -392px -156px; } #wmsx-drop-driveh i { background-position: -508px -107px; } #wmsx-drop-driveh.wmsx-disabled i { background-position: -508px -156px; } #wmsx-drop-cart1 i  { background-position: -159px -107px; } #wmsx-drop-cart2 i  { background-position: -217px -107px; } #wmsx-drop-tape i   { background-position: -275px -107px; } .wmsx-drop-add, .wmsx-drop-files { position: absolute; display: none; left: 0; top: 0; width: 50px; height: 34px; padding-top: 10px; font-size: 11px; line-height: 9px; text-shadow: 1px 1px 1px black; border: 3px solid transparent; box-sizing: border-box; white-space: nowrap; overflow: visible; } .wmsx-drop-files { left: unset; right: 0; } .wmsx-drop-add::after { content: "+ DISKS"; } .wmsx-drop-files::after { content: "+ FILES "; } #wmsx-drop-area > div:not(.wmsx-disabled).wmsx-selected .wmsx-drop-add, #wmsx-drop-area > div:not(.wmsx-disabled).wmsx-selected .wmsx-drop-files { display: block; } .wmsx-drop-add.wmsx-selected, .wmsx-drop-files.wmsx-selected { border-color: hsl(0, 0%, 82%); box-shadow: 0 0 0 1px rgba(0, 0, 0, .8); } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-touch-left .wmsx-touch-dir { transform: scale(1.2); transform-origin: left center; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-touch-left .wmsx-touch-dir { transform-origin: right center; } #wmsx-touch-left .wmsx-touch-button { margin-left: 11px; } html.wmsx-touch-mirror #wmsx-touch-left .wmsx-touch-button { margin-left: 47px; } #wmsx-touch-T_X { margin-bottom: var(--touch-left-button-vert-margin); } #wmsx-touch-T_Y { margin-top: var(--touch-left-button-vert-margin); } @media only screen and (orientation: landscape) {    /* Landscape */ #wmsx-touch-left { left: calc(-6px - '+this.TOUCH_CONTROLS_LEFT_WIDTH+"px); bottom: 50%; transform: translateY(50%); --touch-left-button-vert-margin: 10px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-touch-left { left: calc(-6px - "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px); --touch-left-button-vert-margin: 20px; } html.wmsx-touch-mirror #wmsx-touch-left { right: calc(-6px - "+this.TOUCH_CONTROLS_LEFT_WIDTH+"px); left: initial  !important; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-touch-left { right: calc(-6px - "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px); } #wmsx-touch-right { right: calc(5px - "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px); bottom: 50%; transform: translateY(50%); } html.wmsx-touch-mirror #wmsx-touch-right { left: calc(5px - "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px); right: initial  !important; } #wmsx-touch-speed { position: absolute; left: -106px; top: 8px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-touch-speed { left: -130px; } html.wmsx-touch-mirror #wmsx-touch-speed { right: -106px; left: initial  !important; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-touch-speed { right: -130px; } /* Adjust centered elements leaving space to the touch controls on both sides */ html.wmsx-full-screen.wmsx-touch-active #wmsx-screen-fs-center { left: "+this.TOUCH_CONTROLS_LEFT_WIDTH+"px; right: "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-dir-big #wmsx-screen-fs-center { left: "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror #wmsx-screen-fs-center { right: "+this.TOUCH_CONTROLS_LEFT_WIDTH+"px; left: "+this.TOUCH_CONTROLS_RIGHT_WIDTH+"px; } html.wmsx-full-screen.wmsx-touch-active.wmsx-touch-mirror.wmsx-dir-big #wmsx-screen-fs-center { right: "+this.TOUCH_CONTROLS_LEFT_WIDTH_BIG+"px; } } @media only screen and (orientation: landscape) and (max-height: 511px) {    /* Medium/Large Landscape */ #wmsx-touch-left { --touch-left-button-vert-margin: 10px  !important; } #wmsx-touch-T_F, #wmsx-touch-T_G { display: none; } #wmsx-touch-speed { top: 2px; } } @media only screen and (orientation: landscape) and (max-height: 410px) {    /* Medium Landscape */ #wmsx-touch-left { --touch-left-button-vert-margin: -2px  !important; } } @media only screen and (orientation: landscape) and (max-height: 359px) {    /* Short Landscape */ #wmsx-touch-left { --touch-left-button-vert-margin: 6px  !important; } #wmsx-touch-T_E { display: none; } #wmsx-touch-T_X { visibility: hidden; } #wmsx-touch-speed { top: 8px; } } @media only screen and (orientation: portrait) {    /* Portrait */ #wmsx-touch-left { left: 2px; bottom: 182px; } html.wmsx-touch-mirror #wmsx-touch-left { right: 2px; left: initial  !important; } #wmsx-touch-right { right: 5px; bottom: 36px; width: 112px; height: 224px; } html.wmsx-touch-mirror #wmsx-touch-right { left: 77px; right: initial  !important; } #wmsx-touch-speed { position: absolute; left: 19px; bottom: "+(this.BAR_HEIGHT+10)+"px; } html.wmsx-touch-mirror #wmsx-touch-speed { right: 19px; left: initial  !important; } .wmsx-touch-button { position: absolute; } #wmsx-touch-T_A { bottom: 75%; right: 50%; } #wmsx-touch-T_B { bottom: 100%; right: 0%; } #wmsx-touch-T_C { bottom: 50%; right: 100%; } #wmsx-touch-T_D { bottom: 25%; right: 50%; } #wmsx-touch-T_E { bottom: 50%; right: 0%; } #wmsx-touch-T_F { bottom: 0%; right: 100%; } #wmsx-touch-T_G { bottom: 0%; right: 0%; } #wmsx-touch-T_X { display: none; } #wmsx-touch-T_Y { bottom: -88px; } html.wmsx-touch-mirror #wmsx-touch-T_B { right: 100%; } html.wmsx-touch-mirror #wmsx-touch-T_C { right: 0%; } html.wmsx-touch-mirror #wmsx-touch-T_E { right: 100%; } html.wmsx-touch-mirror #wmsx-touch-T_F { right: 0%; } html.wmsx-touch-mirror #wmsx-touch-T_G { right: 100%; } html.wmsx-full-screen.wmsx-virtual-keyboard-active #wmsx-touch-left, html.wmsx-full-screen.wmsx-virtual-keyboard-active #wmsx-touch-right { display: none; } } @media only screen and (orientation: portrait) and (max-device-height: 638px) {    /* Medium Portrait. Like iPhone 5 */ #wmsx-touch-right { bottom: -18px; } #wmsx-touch-T_F, #wmsx-touch-T_G { display: none; } } @media only screen and (orientation: portrait) and (max-device-height: 518px) {    /* Short Portrait. Like iPhone 4 */ #wmsx-touch-left { bottom: 98px; } #wmsx-touch-right { bottom: -74px; } #wmsx-touch-T_E, #wmsx-touch-T_Y { display: none; } #wmsx-touch-T_D { bottom: 50%; right: 0%; } html.wmsx-touch-mirror #wmsx-touch-T_D { right: 100%; } }"
},wmsx.VirtualKeyboard={create:function(a,b,c,d,e,f){"use strict";var g=document.createElement("div");g.style.position="absolute",a.appendChild(g);var h=[];for(var i in this.sections){var j=document.createElement("div");j.classList.add("wmsx-keyboard-"+i),g.appendChild(j);for(var k=this.sections[i],l=0,m=0;m<k.length;++m){var n=document.createElement("div");n.style.top=l+"px",l+=this.sectionRowHeight[i],j.appendChild(n);for(var o=k[m],p=1,q=0;q<o.length;++q){var r=o[q],s="wmsx-keyboard-"+r.toLowerCase(),t=document.createElement("div");if(!this.byCSSKeys.has(r)){var u=this.keyWidth[r]||this.sectionKeyWidth[i];t.style.width=u+"px",t.style.left=p+"px",p+=this.keySpace[r]||u+1}t.classList.add("wmsx-keyboard-key"),t.classList.add(s),this.dark.indexOf(s)>=0&&t.classList.add("wmsx-keyboard-key-dark"),t.wmsxKeyID=r,t.wmsxKey=this.idToMSMKey[r]||r,n.appendChild(t),h.push(t),b&&b(t)}}}return this.updateKeysLabels(h,c,d,e,f),h},updateKeysLabels:function(a,b,c,d,e){this.finalLabels.COD=this.finalLabels.KANA=d||"CODE";var f,g,h;e?(f="cns_"+c,g="c_"+c,h="c_en"):(f=(b?"cs_":"c_")+c,g=b?"cs_en":"c_en",h="c_en");for(var i=a.length-1;i>=0;--i){var j=a[i];if(!this.blankKeys.has(j.wmsxKeyID)){var k=wmsx.KeyboardKeys[j.wmsxKey][f]||wmsx.KeyboardKeys[j.wmsxKey][g]||wmsx.KeyboardKeys[j.wmsxKey][h];k=this.finalLabels[k]||k,j.wmsxLabel!==k&&(j.wmsxLabel=k,j.innerHTML=k)}}},sections:{alpha:[["F1","F2","F3","F4","F5","STOP","SELECT","HOME","INSERT","DELETE"],["ESCAPE","D1","D2","D3","D4","D5","D6","D7","D8","D9","D0","MINUS","EQUAL","BACKSLASH","BACKSPACE"],["TAB","Q","W","E","R","T","Y","U","I","O","P","OPEN_BRACKET","CLOSE_BRACKET","ENTER_X1","ENTER_X2"],["CONTROL","A","S","D","F","G","H","J","K","L","SEMICOLON","QUOTE","BACKQUOTE","ENTER"],["SHIFT","Z","X","C","V","B","N","M","COMMA","PERIOD","SLASH","DEAD","SHIFT2"],["CAPSLOCK","GRAPH","SPACE","CODE"]],num:[["NUM_7","NUM_8","NUM_9","NUM_DIVIDE"],["NUM_4","NUM_5","NUM_6","NUM_MULTIPLY"],["NUM_1","NUM_2","NUM_3","NUM_MINUS"],["NUM_0","NUM_PERIOD","NUM_COMMA","NUM_PLUS"]],arrows:[["LEFT","UP","RIGHT","DOWN"]]},sectionRowHeight:{alpha:25,num:23,arrows:50},sectionKeyWidth:{alpha:26,num:22},keyWidth:{F1:39,F2:39,F3:39,F4:39,F5:39,STOP:39,SELECT:39,HOME:39,INSERT:39,DELETE:39,ESCAPE:29,BACKSPACE:28,TAB:41,CONTROL:48,SHIFT:61,SHIFT2:61,ENTER:36,ENTER_X1:13,ENTER_X2:30,SPACE:189,CAPSLOCK:38,DEAD:38,GRAPH:46,CODE:46},keySpace:{STOP:50,ENTER_X1:13,CAPSLOCK:55},dark:["wmsx-keyboard-escape","wmsx-keyboard-tab","wmsx-keyboard-control","wmsx-keyboard-shift","wmsx-keyboard-capslock","wmsx-keyboard-graph","wmsx-keyboard-backspace","wmsx-keyboard-enter","wmsx-keyboard-enter_x1","wmsx-keyboard-enter_x2","wmsx-keyboard-shift2","wmsx-keyboard-code","wmsx-keyboard-num_divide","wmsx-keyboard-num_multiply","wmsx-keyboard-num_minus","wmsx-keyboard-num_plus"],idToMSMKey:{ENTER_X1:"ENTER",ENTER_X2:"ENTER",SHIFT2:"SHIFT"},finalLabels:{STP:"STOP",HOM:"HOME",CTR:"CTRL",SHF:"SHIFT",CAP:"CAPS",SPC:"SPACE",GRA:"GRAPH",COD:"CODE"},blankKeys:new Set(["ENTER_X1","ENTER_X2","UP","DOWN","LEFT","RIGHT"]),byCSSKeys:new Set(["SHIFT2","SPACE","CODE","DEAD","UP","DOWN","LEFT","RIGHT"])},wmsx.Monitor=function(a){"use strict";function b(){l=-1===j?k:j,h.videoSignalDisplayStateUpdate(1!==l,2===l),i&&i.videoSignalDisplayStateUpdate(0!==l,2===l),a.videoOutputModeUpdate(j,l,0===k,f(-1),i&&i.getSignalName()),h.refreshDisplayMetrics(),i&&i.refreshDisplayMetrics()}function c(){h.setColorAndPaletteMode(m,n),i&&i.setColorAndPaletteMode(m,n)}function d(){a.showOSD("Video Output: "+e(j),!0)}function e(a){switch(a){case 0:return"Internal";case 1:return i?i.getSignalName():"External";case 2:return"Superimposed";case 3:return"Mixed";case 4:case 5:var b=i?i.getSignalName():"External";return"Dual Screen "+(4===a?"(Internal + "+b+")":"("+b+" + Internal)");default:return"Auto ("+e(k)+")"}}function f(a){switch(a){case 0:return"Internal";case 1:return i?i.getSignalName():"External";case 2:return"Superimp";case 3:return"Mixed";case 4:case 5:return"Dual";default:return"Auto ("+f(k)+")"}}function g(a){return 1!==l&&a===h||0!==l&&a===i}this.connectInternalVideoSignal=function(a){h=a,h.connectMonitor(this),m=WMSX.SCREEN_COLORS>=0&&WMSX.SCREEN_COLORS<=3?WMSX.SCREEN_COLORS:0,n=WMSX.VDP_PALETTE>=0&&WMSX.VDP_PALETTE<=5?WMSX.VDP_PALETTE:2,c(),b()},this.connectExternalVideoSignal=function(a){i=a,i.connectMonitor(this),WMSX.SCREEN_VIDEO_OUT>=0?this.setOutputMode(WMSX.SCREEN_VIDEO_OUT,!0):b()},this.disconnectExternalVideoSignal=function(a){i===a&&(i=void 0,k=0,j=-1,b())},this.toggleOutputMode=function(a){a?this.setOutputMode(j<=-1?3:j-1):this.setOutputMode(j>=3?-1:j+1)},this.resetOutputAutoMode=function(){h.resetOutputAutoMode(),i&&i.resetOutputAutoMode(),-1!==j&&this.setOutputMode(-1)},this.setOutputAutoMode=function(a,c){var e=l;k=c,b(),e!==l&&d()},this.setOutputMode=function(c,e){j=!i||c<-1?-1:c<4?c:a.isDualScreenAllowed()?c>5?5:c:-1,b(),e||d()},this.setOutputModeDual=function(){a.isDualScreenAllowed()&&(j>=4?(j=4===j?5:4,b(),d()):this.setOutputMode(0===l?4:5))},this.toggleColorMode=function(b){m=b?m<=0?3:m-1:m>=3?0:m+1,c(),a.showOSD("Screen Color Mode: "+o[m],!0)},this.togglePaletteMode=function(b){n=b?n<=0?5:n-1:n>=5?0:n+1,c(),a.showOSD("MSX1 Palette: "+p[n],!0)},this.newFrame=function(b,c,d,e,f,i){g(b)&&a.refresh(c,d,e,f,i,b===h)},this.signalOff=function(b){a.videoSignalOff()},this.showOSD=function(b,c,d){a.showOSD(b,c,d)},this.setDisplayMetrics=function(b,c,d){g(b)&&a.displayMetrics(c,d,b===h)},this.setDebugMode=function(b,c){a.setDebugMode(c)},this.getScreenText=function(){return h.getScreenText()},this.saveState=function(){return{m:j,me:l,ma:k,cm:m,pm:n}},this.loadState=function(a){a?(j=a.m,k=a.ma,m=a.cm||0,n=a.pm||0):(j=-1,k=0,m=0,n=2),c(),this.setOutputMode(j,!0)};var h,i,j=-1,k=0,l=0,m=0,n=2,o=["Color","B&W","Green Phosphor","Amber Phosphor"],p=["WebMSX Original","V9918","V9928","V9938","Toshiba","Fujitsu FM-X"]},wmsx.CanvasDisplay=function(room,mainElement){"use strict";function init(){wmsx.Util.insertCSS(document,wmsx.ScreenGUI.css()),setupMain(),setupBar(),setupFileLoaderDropTargets(),setupFullscreen(),monitor=new wmsx.Monitor(self)}function updateDisplayMetrics(a,b,c,d,e,f){updatePixelMetrics(a,b,e,d),targetWidth===c&&targetHeight===d&&scrTargetWidth===e&&aspectXCorrection===f||(targetWidth=c,targetHeight=d,scrTargetWidth=e,aspectXCorrection=f,updateCanvasContentSize(),isFullscreen?requestReadjust(!0):updateScale())}function updatePixelMetrics(a,b,c,d){var e=c/a,f=d/b;pixelWidth===e&&pixelHeight===f||(pixelWidth=e,pixelHeight=f,refreshPixelMetrics())}function auxUpdateDisplayMetrics(a,b,c,d,e,f){if(auxTargetWidth!==c||auxTargetHeight!==d||auxScrTargetWidth!==e||auxAspectXCorrection!==f){if(auxTargetWidth=c,auxTargetHeight=d,auxScrTargetWidth=e,auxAspectXCorrection=f,!auxWindow)return!1;auxUpdateCanvasContentSize(),auxReadjustAll(!0)}}function displayScale(a,b){aspectX=a,scaleY=b,updateScale(),refreshPixelMetrics()}function auxDisplayScale(a,b,c){auxAspectX=a,auxScaleY=b,auxUpdateScale(c)}function refreshPixelMetrics(){controllersHub&&controllersHub.setScreenPixelScale(pixelWidth*scaleY*aspectX*aspectXCorrection,pixelHeight*scaleY)}function hideOSDs(){osd.style.transition=auxOsd.style.transition="all 0.15s linear",osd.style.top=auxOsd.style.top="-29px",osd.style.opacity=auxOsd.style.opacity=0,osdShowing=!1}function displayDefaultScale(){if(WMSX.SCREEN_DEFAULT_SCALE>0)return WMSX.SCREEN_DEFAULT_SCALE;var a=mainElement.parentElement.clientWidth;return crtScanlines?a>=660?1:a>=420?.75:.5:a>=660?1.1:a>=540?.9:a>=420?.7:a>=320?.55:.5}function aspectAndScaleSetDefault(){if(isFocusOnAuxWindow())return auxAspectAndScaleSetDefault();aspectX=WMSX.SCREEN_DEFAULT_ASPECT,scaleY=displayDefaultScale(),scaleYBeforeUserFullscreen=0,requestReadjust(!0)}function auxAspectAndScaleSetDefault(){auxAspectX=WMSX.SCREEN_DEFAULT_ASPECT,auxScaleY=displayDefaultScale(),auxReadjustAll(!0)}
function crtFilterSetDefault(){var a=WMSX.userPreferences.current.crtFilter;setCRTFilter(-3!==WMSX.SCREEN_FILTER_MODE?WMSX.SCREEN_FILTER_MODE:null!==a&&a>-3?a:-1)}function crtScanlinesSetDefault(){var a=WMSX.userPreferences.current.crtScanlines;setCRTScanlines(-1!==WMSX.SCREEN_CRT_SCANLINES?Math.max(0,Math.min(10,WMSX.SCREEN_CRT_SCANLINES)):null!==a&&a>-1?a:0)}function crtPhosphorSetDefault(){setCRTPhosphor(WMSX.SCREEN_CRT_PHOSPHOR)}function auxDisplayToggleFullscreen(){auxIsFullScreenByAPI()?auxExitFullScreenByAPI():auxEnterFullScreenByAPI()}function normalizeAspectX(a){var b=a<.5?.5:a>2.5?2.5:a;return Math.round(b/ASPECT_STEP)*ASPECT_STEP}function normalizeScaleY(a){var b=a<.5?.5:a;return Math.round(b/SCALE_STEP)*SCALE_STEP}function requestReadjust(a,b){a?readjustAll(!0,b):(readjustRequestTime=wmsx.Util.performanceNow(),readjustInterval||(readjustInterval=setInterval(readjustAll,50)))}function setVirtualKeyboard(a){if(virtualKeyboardMode!==a){if(a){if(!isTouchDevice)return self.showOSD("Virtual Keyboard unavailable. Not a touch device!",!0,!0);virtualKeyboardElement||setupVirtualKeyboard(),virtualKeyboardElement.classList.toggle("wmsx-keyboard-narrow",2==a)}showCursorAndBar(!0),document.documentElement.classList.toggle("wmsx-virtual-keyboard-active",!!a),virtualKeyboardMode=a,requestReadjust(!0)}}function releaseControllersOnLostFocus(){controllersSocket.releaseControllers()}function hideCursorAndBar(){hideCursor(),hideBar(),cursorHideFrameCountdown=-1}function showCursorAndBar(a){showCursor(),!a&&mousePointerLocked||showBar(),cursorHideFrameCountdown=CURSOR_HIDE_FRAMES}function showCursor(){cursorShowing||(fsElement.style.cursor=cursorType,cursorShowing=!0)}function hideCursor(){cursorShowing&&(fsElement.style.cursor="none",cursorShowing=!1)}function fullscreenByAPIChanged(){var a=isFullscreen,b=isFullScreenByAPI();b||fullScreenAPIExitUserRequested||!isMobileDevice||!isOfficialHome?setFullscreenState(b):requestReadjust(),isMobileDevice&&a&&!b&&!fullScreenAPIExitUserRequested&&setEnterFullscreenByAPIOnFirstTouch(),fullScreenAPIExitUserRequested=!1}function isFullScreenByAPI(){return!!document[fullScreenAPIQueryProp]}function enterFullScreenByAPI(){if(fullscreenAPIEnterMethod)try{fullscreenAPIEnterMethod.call(fsElement)}catch(a){}}function exitFullScreenByAPI(){if(fullScreenAPIExitMethod)try{fullScreenAPIExitUserRequested=!0,fullScreenAPIExitMethod.call(document)}catch(a){}}function auxEnterFullScreenByAPI(){if(fullscreenAPIEnterMethod)try{fullscreenAPIEnterMethod.call(auxFsElementCenter)}catch(a){}}function auxExitFullScreenByAPI(){if(fullScreenAPIExitMethod)try{fullScreenAPIExitMethod.call(auxWindow.document)}catch(a){}}function auxIsFullScreenByAPI(){return!!auxWindow.document[fullScreenAPIQueryProp]}function auxIsMaxed(){return auxIsFullScreenByAPI()||auxWindow.outerWidth>=auxWindow.screen.availWidth&&auxWindow.outerHeight>=auxWindow.screen.availHeight}function updateScale(){var a=Math.round(scrTargetWidth*scaleY*aspectX*aspectXCorrection),b=Math.round(targetHeight*scaleY);canvas.style.width=a+"px",canvas.style.height=b+"px",updateBarWidth(a),signalIsOn||updateLogoScale(),settingsDialog&&settingsDialog.isVisible()&&settingsDialog.position()}function auxUpdateScale(a){var b=Math.round(auxScrTargetWidth*auxScaleY*auxAspectX*auxAspectXCorrection),c=Math.ceil(auxTargetHeight*auxScaleY);auxCanvas.style.width=b+"px",auxCanvas.style.height=c+"px",a&&auxWindow.resizeTo(b+auxWindowAddWidth,c+auxWindowAddHeight)}function updateBarWidth(a){var b=buttonsBarDesiredWidth>0?buttonsBarDesiredWidth:a;buttonsBar.style.width=-1===buttonsBarDesiredWidth?"100%":b+"px";var c=buttonsBar.clientWidth;buttonsBar.classList.toggle("wmsx-narrow",c<NARROW_WIDTH),buttonsBar.classList.toggle("wmsx-semi-narrow",c<SEMI_NARROW_WIDTH)}function updateKeyboardWidth(a){var b=Math.min(1024,a),c=1===virtualKeyboardMode?VIRTUAL_KEYBOARD_WIDE_WIDTH:VIRTUAL_KEYBOARD_NARROW_WIDTH,d=b/c;return virtualKeyboardElement.style.width=c+"px",virtualKeyboardElement.style.transform="translateX(-50%) scale("+d.toFixed(8)+")",{w:b,h:Math.ceil(VIRTUAL_KEYBOARD_HEIGHT*d)}}function updateCanvasContentSize(){canvas.width=targetWidth,canvas.height=targetHeight,canvasContext=null}function auxUpdateCanvasContentSize(){auxCanvas.width=auxTargetWidth,auxCanvas.height=auxTargetHeight,auxCanvasContext=null}function setCRTFilter(a){crtFilter=a,crtFilterEffective=-2===crtFilter?null:-1===crtFilter?crtFilterAutoValue():a,canvasContext=null}function crtFilterAutoValue(){return isMobileDevice&&isAndroidDevice&&"FIREFOX"===browserName?2:1}function setCRTScanlines(a){crtScanlines=a,crtScanlines&&setupScanlines(),canvasContext=null}function setCRTPhosphor(a){crtPhosphor=a,crtPhosphorEffective=-1===crtPhosphor?0:crtPhosphor,canvasContext=null}function updateLogo(){signalIsOn||(updateLogoScale(),closePowerOnModals(),showCursorAndBar(!0),canvasContext&&canvasContext.clearRect(0,0,canvas.width,canvas.height)),logo.classList.toggle("wmsx-show",!signalIsOn),auxWindow&&auxLogo.classList.toggle("wmsx-show",!signalIsOn)}function updateLoading(){var a=isLoading?"block":"none";logoLoadingIcon.style.display=a,canvasLoadingIcon.style.display=a}function createCanvasContext(){return canvasContext=canvas.getContext("2d",{alpha:!1,antialias:!1}),updateImageComposition(canvasContext),updateImageSmoothing(canvasContext),canvasContext}function auxCreateCanvasContext(){if(auxWindow)return auxCanvasContext=auxCanvas.getContext("2d",{alpha:!1,antialias:!1}),updateImageComposition(auxCanvasContext),updateImageSmoothing(auxCanvasContext),auxCanvasContext}function updateImageComposition(a){a.globalCompositeOperation=debugMode?"copy":videoOutputMode<=1||videoOutputMode>=4?crtPhosphorEffective?"source-over":"copy":3===videoOutputMode?"lighten":"source-over",a.globalAlpha=debugMode?1:videoOutputMode<=1||videoOutputMode>=4?crtPhosphorEffective?.8:1:3===videoOutputMode?.66:1}function updateImageSmoothing(a){if(null!==crtFilterEffective){canvas.style.imageRendering=1===crtFilterEffective||3===crtFilterEffective?"initial":canvasImageRenderingValue;var b=crtFilterEffective>=2;void 0!==a.imageSmoothingEnabled?a.imageSmoothingEnabled=b:(a.webkitImageSmoothingEnabled=b,a.mozImageSmoothingEnabled=b,a.msImageSmoothingEnabled=b)}}function updateLeds(){ledsStatePending&&(capsLed.classList.toggle("wmsx-hidden",!ledsStatePending[0]),kanaLed.classList.toggle("wmsx-hidden",!ledsStatePending[1]),pauseLed.classList.toggle("wmsx-hidden",!ledsStatePending[2]),turboButton.classList.toggle("wmsx-hidden",!ledsStatePending[3]&&!ledsStatePending[4]),turboButton.textContent=ledsStatePending[4]>1?ledsInfoPending[4]:ledsInfoPending[3],turboButton.style.backgroundPositionY=(3===ledsStatePending[4]?-91:2===ledsStatePending[4]?-116:1===ledsStatePending[4]?-141:-166)+"px",quickOtionsDialog&&quickOtionsDialog.machineTurboModesStateUpdate(),ledsStatePending=void 0)}function suppressContextMenu(a){a.addEventListener("contextmenu",wmsx.Util.blockEvent)}function preventDrag(a){a.ondragstart=wmsx.Util.blockEvent}function setupMain(){switch(mainElement.innerHTML=wmsx.ScreenGUI.html(),mainElement.tabIndex=-1,delete wmsx.ScreenGUI.html,fsElement=document.getElementById("wmsx-screen-fs"),fsElementCenter=document.getElementById("wmsx-screen-fs-center"),canvasOuter=document.getElementById("wmsx-screen-canvas-outer"),canvas=document.getElementById("wmsx-screen-canvas"),canvasLoadingIcon=document.getElementById("wmsx-canvas-loading-icon"),osd=document.getElementById("wmsx-osd"),logo=document.getElementById("wmsx-logo"),logoCenter=document.getElementById("wmsx-logo-center"),logoImage=document.getElementById("wmsx-logo-image"),logoLoadingIcon=document.getElementById("wmsx-logo-loading-icon"),logoMessage=document.getElementById("wmsx-logo-message"),logoMessageText=document.getElementById("wmsx-logo-message-text"),logoMessageOK=document.getElementById("wmsx-logo-message-ok"),
logoMessageOKText=document.getElementById("wmsx-logo-message-ok-text"),scrollMessage=document.getElementById("wmsx-screen-scroll-message"),unmuteMessage=document.getElementById("wmsx-unmute-message"),suppressContextMenu(mainElement),preventDrag(logoImage),preventDrag(logoLoadingIcon),preventDrag(canvasLoadingIcon),updateCanvasContentSize(),browserName){case"CHROME":case"EDGE":case"OPERA":canvasImageRenderingValue="pixelated";break;case"FIREFOX":canvasImageRenderingValue="-moz-crisp-edges";break;case"SAFARI":canvasImageRenderingValue="-webkit-optimize-contrast";break;default:canvasImageRenderingValue="pixelated"}setupMainEvents()}function setupAndShowAuxWindow(){if(!auxWindow){var a=displayDefaultScale(),b=wmsx.VDP.SIGNAL_MAX_WIDTH_V9938*auxAspectX*a,c=wmsx.VDP.SIGNAL_MAX_HEIGHT_V9938*a,d=window.open("","WebMSX: 2nd Video","width="+b+",height="+(c+1)+",scrollbars=no,status=no,location=no,toolbar=no,menubar=no"),e=d.document;e.open("text/html","replace").write(wmsx.ScreenGUI.auxHtml()),e.close()}}function auxWindowResized(){auxReadjustAll(!1,!0)}function auxWindowUnload(){monitor.setOutputMode(-1),self.focus()}function closeAuxWindow(){auxWindow&&(self.focus(),auxWindow.removeEventListener("resize",auxWindowResized),auxWindow.removeEventListener("beforeunload",auxWindowUnload),auxWindow.close(),auxWindow=auxFsElementCenter=auxLogo=auxCanvas=auxCanvasContext=void 0,auxOsd={style:{}})}function auxWindowUpdateTitle(){auxWindow&&(auxWindow.document.title="WebMSX: "+(4===videoOutputMode?"V9990 Video":"Internal Video"))}function isFocusOnAuxWindow(){return auxWindow&&auxWindow.document.hasFocus()}function setupScanlines(){if(!scanlinesImage){scanlinesImage=document.createElement("canvas"),scanlinesImage.width=1,scanlinesImage.height=wmsx.V9990.SIGNAL_MAX_HEIGHT;var a=scanlinesImage.getContext("2d",{alpha:!0,antialias:!1});a.clearRect(0,0,1,scanlinesImage.height),a.fillStyle="black";for(var b=1,c=scanlinesImage.height;b<c;b+=2)a.fillRect(0,b,1,1)}}function setupMainEvents(){(isMobileDevice?canvasOuter:fsElement).addEventListener("mousemove",function(){showCursorAndBar()}),"onblur"in document?fsElement.addEventListener("blur",releaseControllersOnLostFocus,!0):fsElement.addEventListener("focusout",releaseControllersOnLostFocus,!0),window.addEventListener("orientationchange",function(){closeAllOverlays(),signalIsOn?hideCursorAndBar():showCursorAndBar(),requestReadjust()}),window.addEventListener("resize",function(){isFullscreen&&(closeAllOverlays(!0),signalIsOn?hideCursorAndBar():showCursorAndBar(),requestReadjust(!0,!0))}),mainElement.addEventListener("drop",closeAllOverlays,!1),logoMessageOK.wmsxNeedsUIG=logoMessageOKText.wmsxNeedsUIG=!0,wmsx.Util.onTapOrMouseDownWithBlockUIG(logoMessageOK,closeLogoMessage),wmsx.Util.addEventsListener(fsElementCenter,"touchstart touchend mousedown",function(a){"touchend"!==a.type?(closeAllOverlays(),showCursorAndBar()):a.cancelable&&a.preventDefault()}),window.addEventListener("beforeunload",closeAuxWindow)}function setupVirtualKeyboard(){virtualKeyboardElement=document.createElement("div"),virtualKeyboardElement.id="wmsx-virtual-keyboard",fsElementCenter.appendChild(virtualKeyboardElement),virtualKeyboard=new wmsx.DOMVirtualKeyboard(virtualKeyboardElement,controllersHub.getKeyboard(),machineTypeSocket)}function setupBar(){buttonsBar=document.getElementById("wmsx-bar"),buttonsBarInner=document.getElementById("wmsx-bar-inner"),BAR_AUTO_HIDE&&(document.documentElement.classList.add("wmsx-bar-auto-hide"),fsElement.addEventListener("mouseleave",hideBar),hideBar()),isMobileDevice&&document.documentElement.classList.add("wmsx-bar-mobile");var a=[{label:"Power",clickModif:0,control:wmsx.PeripheralControls.MACHINE_POWER_TOGGLE},{label:"Reset",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.MACHINE_POWER_RESET},{label:"",divider:!0},{label:"Net Play!",control:wmsx.PeripheralControls.SCREEN_OPEN_NETPLAY},{label:"",divider:!0},{label:"Open File",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.AUTO_LOAD_FILE,needsUIG:!0},{label:"Open URL",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.AUTO_LOAD_URL,needsUIG:!0},{label:"",divider:!0},{label:"Load State",control:wmsx.PeripheralControls.MACHINE_LOAD_STATE_MENU},{label:"Save State",control:wmsx.PeripheralControls.MACHINE_SAVE_STATE_MENU}];powerButton=addPeripheralControlButton("wmsx-bar-power",-120,-26,!1,"System Power",null,a,"System"),barMenuSystem=a,netplayButton=addPeripheralControlButton("wmsx-bar-netplay",-91,-76,!1,"NetPlay!",wmsx.PeripheralControls.SCREEN_OPEN_NETPLAY),netplayButton.classList.add("wmsx-hidden"),mediaIconsContainer=document.createElement("div"),mediaIconsContainer.id="wmsx-bar-media-icons",mediaIconsContainer.style.display="inline-block",buttonsBarInner.appendChild(mediaIconsContainer),barMenus.push(null),a=[{label:"Load Disk Images",clickModif:0,control:wmsx.PeripheralControls.DISK_LOAD_FILES,secSlot:!1,needsUIG:!0},{label:"Add Disk Images",control:wmsx.PeripheralControls.DISK_ADD_FILES,secSlot:!1,needsUIG:!0},{label:"Add Blank Disk",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_EMPTY,secSlot:!1},{label:"Add Boot Disk",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_BOOT,secSlot:!1},{label:"Import Files to Disk",control:wmsx.PeripheralControls.DISK_LOAD_FILES_AS_DISK,secSlot:!1,needsUIG:!0},{label:"Expand ZIP to Disk",control:wmsx.PeripheralControls.DISK_LOAD_ZIP_AS_DISK,secSlot:!1,needsUIG:!0},{label:"Select Disk",control:wmsx.PeripheralControls.DISK_SELECT,secSlot:!1,disabled:!0},{label:"Save Disk Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_SAVE_FILE,secSlot:!1,disabled:!0,needsUIG:!0},{label:"Remove Disk",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_REMOVE,secSlot:!1,disabled:!0}],diskAButton=addPeripheralControlButton("wmsx-bar-diska",-165,-72,!0,"Drive A",null,a,"Drive A",mediaIconsContainer),WMSX.EXTENSIONS.DISK||diskAButton.classList.add("wmsx-hidden"),a=[{label:"Load Disk Images",clickModif:0,control:wmsx.PeripheralControls.DISK_LOAD_FILES,secSlot:!0,needsUIG:!0},{label:"Add Disk Images",control:wmsx.PeripheralControls.DISK_ADD_FILES,secSlot:!0,needsUIG:!0},{label:"Add Blank Disk",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_EMPTY,secSlot:!0},{label:"Add Boot Disk",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.DISK_BOOT,secSlot:!0},{label:"Import Files to Disk",control:wmsx.PeripheralControls.DISK_LOAD_FILES_AS_DISK,secSlot:!0,needsUIG:!0},{label:"Expand ZIP to Disk",control:wmsx.PeripheralControls.DISK_LOAD_ZIP_AS_DISK,secSlot:!0,needsUIG:!0},{label:"Select Disk",control:wmsx.PeripheralControls.DISK_SELECT,secSlot:!0,disabled:!0},{label:"Save Disk Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_SAVE_FILE,secSlot:!0,disabled:!0,needsUIG:!0},{label:"Remove Disk",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.DISK_REMOVE,secSlot:!0,disabled:!0}],diskBButton=addPeripheralControlButton("wmsx-bar-diskb",-194,-72,!0,"Drive B",null,a,"Drive B",mediaIconsContainer),WMSX.EXTENSIONS.DISK||diskBButton.classList.add("wmsx-hidden"),a=[{label:"Load Disk Image",clickModif:0,control:wmsx.PeripheralControls.HARDDISK_LOAD_FILE,needsUIG:!0},{label:"New Blank Disk",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.HARDDISK_CHOOSE_EMPTY},{label:"New Boot Disk",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.HARDDISK_CHOOSE_BOOT},{label:"Import Files to Disk",control:wmsx.PeripheralControls.HARDDISK_LOAD_FILES_AS_DISK,needsUIG:!0},{label:"Expand ZIP to Disk",control:wmsx.PeripheralControls.HARDDISK_LOAD_ZIP_AS_DISK,needsUIG:!0},{label:"Save Disk Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.HARDDISK_SAVE_FILE,disabled:!0,needsUIG:!0},{label:"Remove Disk",clickModif:KEY_ALT_MASK,
control:wmsx.PeripheralControls.HARDDISK_REMOVE,disabled:!0}],diskHButton=addPeripheralControlButton("wmsx-bar-diskh",-252,-72,!0,"Hard Drive",null,a,"Hard Drive",mediaIconsContainer),WMSX.EXTENSIONS.HARDDISK||diskHButton.classList.add("wmsx-hidden"),2!==WMSX.EXTENSIONS.HARDDISK&&diskHButton.classList.add("wmsx-hd-first"),a=[{label:"Load ROM Image",clickModif:0,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_FILE,secSlot:!1,needsUIG:!0},{label:"Set ROM Format",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_CHOOSE_FORMAT,secSlot:!1},{label:"Load Data File",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_DATA_FILE,secSlot:!1,disabled:!0,needsUIG:!0},{label:"Save Data File",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_SAVE_DATA_FILE,secSlot:!1,disabled:!0,needsUIG:!0},{label:"Remove Cartridge",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_REMOVE,secSlot:!1,disabled:!0}],cartridge1Button=addPeripheralControlButton("wmsx-bar-cart1",-78,-72,!0,"Cartridge 1",null,a,"Cartridge 1",mediaIconsContainer),a=[{label:"Load ROM Image",clickModif:0,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_FILE,secSlot:!0,needsUIG:!0},{label:"Set ROM Format",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_CHOOSE_FORMAT,secSlot:!0},{label:"Load Data File",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.CARTRIDGE_LOAD_DATA_FILE,secSlot:!0,disabled:!0,needsUIG:!0},{label:"Save Data File",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_SAVE_DATA_FILE,secSlot:!0,disabled:!0,needsUIG:!0},{label:"Remove Cartridge",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.CARTRIDGE_REMOVE,secSlot:!0,disabled:!0}],cartridge2Button=addPeripheralControlButton("wmsx-bar-cart2",-107,-72,!0,"Cartridge 2",null,a,"Cartridge 2",mediaIconsContainer),a=[{label:"Load Tape Image",clickModif:0,control:wmsx.PeripheralControls.TAPE_LOAD_FILE,secSlot:!0,needsUIG:!0},{label:"New Blank Tape",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.TAPE_EMPTY,secSlot:!0},{label:"Rewind Tape",control:wmsx.PeripheralControls.TAPE_REWIND,disabled:!0,secSlot:!0},{label:"Run Program",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.TAPE_AUTO_RUN,secSlot:!0,disabled:!0},{label:"Save Tape Image",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.TAPE_SAVE_FILE,disabled:!0,secSlot:!0,needsUIG:!0},{label:"Remove Tape",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.TAPE_REMOVE,disabled:!0,secSlot:!0}],tapeButton=addPeripheralControlButton("wmsx-bar-tape",-136,-72,!0,"Cassette",null,a,"Cassette",mediaIconsContainer);var b=document.createElement("div");if(b.id="wmsx-bar-settings-icons",b.style.display="inline-block",buttonsBarInner.appendChild(b),WMSX.SCREEN_RESIZE_DISABLED||isMobileDevice||(scaleDownButton=addPeripheralControlButton("wmsx-bar-scale-minus",-26,-3,!1,"Decrease Screen",wmsx.PeripheralControls.SCREEN_SCALE_MINUS,null,"",b),scaleDownButton.classList.add("wmsx-full-screen-hidden"),scaleUpButton=addPeripheralControlButton("wmsx-bar-scale-plus",-48,-2,!1,"Increase Screen",wmsx.PeripheralControls.SCREEN_SCALE_PLUS,null,"",b),scaleUpButton.classList.add("wmsx-full-screen-hidden")),-2!==FULLSCREEN_MODE&&(fullscreenButton=addPeripheralControlButton("wmsx-bar-full-screen",-71,-1,!1,"Full Screen",wmsx.PeripheralControls.SCREEN_FULLSCREEN,null,"",b),fullscreenButton.wmsxNeedsUIG=!0),a=[{label:"Auto",clickModif:0,control:wmsx.PeripheralControls.SCREEN_OUTPUT_AUTO,toggle:!0,radio:!0},{label:"Internal",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.SCREEN_OUTPUT_INTERNAL,toggle:!0,radio:!0},{label:"External",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.SCREEN_OUTPUT_EXTERNAL,toggle:!0,radio:!0},{label:"Superimposed",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.SCREEN_OUTPUT_SUPERIMPOSED,toggle:!0,radio:!0},{label:"Mixed",clickModif:KEY_SHIFT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.SCREEN_OUTPUT_MIXED,toggle:!0,radio:!0},{label:"",divider:!0},{label:"Dual Screen",clickModif:KEY_ALT_MASK|KEY_CTRL_MASK,control:wmsx.PeripheralControls.SCREEN_OUTPUT_DUAL,toggle:!0},{label:"",divider:!0},{label:"Reset Auto Internal",control:wmsx.PeripheralControls.SCREEN_OUTPUT_RESET_AUTO}],videoOutputButton=addPeripheralControlButton("wmsx-bar-video",-120,-176,!1,"Video Output",null,a,"Video Output",b),videoOutputButton.classList.add("wmsx-hidden"),a=createSettingsMenuOptions(),settingsButton=addPeripheralControlButton("wmsx-bar-settings",-96,-1,!1,"Settings",null,a,"Settings",b),defineSettingsMenuExtensions(),isMobileDevice){addPeripheralControlButton("wmsx-bar-text",-53,-51,!1,"Toggle Text Input",wmsx.PeripheralControls.OPEN_ENTER_STRING)}if(isTouchDevice){addPeripheralControlButton("wmsx-bar-keyboard",-83,-25,!1,"Toggle Virtual Keyboard",wmsx.PeripheralControls.SCREEN_TOGGLE_VIRTUAL_KEYBOARD).classList.add("wmsx-full-screen-only")}var c=addPeripheralControlButton("wmsx-bar-logo",-8,-25,!1,"About WebMSX",wmsx.PeripheralControls.SCREEN_OPEN_ABOUT);isTouchDevice&&c.classList.add("wmsx-full-screen-hidden"),c.classList.add("wmsx-narrow-hidden"),pauseLed=addPeripheralControlButton("wmsx-bar-pause",-94,-101),pauseLed.classList.add("wmsx-semi-narrow-hidden"),pauseLed.classList.add("wmsx-hidden"),turboButton=addPeripheralControlButton("wmsx-bar-turbo",-2,-91,!1,"CPU Turbo",wmsx.PeripheralControls.SCREEN_OPEN_QUICK_OPTIONS),turboButton.classList.add("wmsx-hidden"),kanaLed=addPeripheralControlButton("wmsx-bar-kana",0,0),kanaLed.classList.add("wmsx-semi-narrow-hidden"),kanaLed.classList.add("wmsx-hidden"),capsLed=addPeripheralControlButton("wmsx-bar-caps",0,0),capsLed.textContent="CAPS",capsLed.classList.add("wmsx-narrow-hidden"),capsLed.classList.add("wmsx-hidden"),wmsx.Util.onTapOrMouseDownWithBlockUIG(buttonsBar,barElementTapOrMouseDown),wmsx.Util.addEventsListener(buttonsBar,"touchmove",barElementTouchMove),wmsx.Util.addEventsListener(buttonsBar,"mouseup touchend",barElementTouchEndOrMouseUp)}function addPeripheralControlButton(a,b,c,d,e,f,g,h,i){var j=document.createElement("div");return j.id=a,j.classList.add("wmsx-bar-button"),d&&j.classList.add("wmsx-media-button"),j.wmsxBarElementType=1,j.wmsxControl=f,j.style.backgroundPosition=b+"px "+c+"px",j.wmsxBX=b,j.wmsxBY=c,g&&(j.wmsxMenu=g,g.wmsxTitle=h,g.wmsxRefElement=j,g.wmsxMenuIndex=barMenus.length,barMenus.push(g)),e&&(j.title=e),j.addEventListener("mouseenter",function(a){barButtonHoverOver(a.target,a)}),(i||buttonsBarInner).appendChild(j),j}function barButtonTapOrMousedown(a,b,c,d){if(d||controllersHub.hapticFeedbackOnTouch(b),!logoMessageActive&&!c){var e=barMenuActive;closeAllOverlays();var f=0|(b.altKey&&KEY_ALT_MASK)|(b.ctrlKey&&KEY_CTRL_MASK)|(b.shiftKey&&KEY_SHIFT_MASK);if(a.wmsxControl)return void(b.button&&2!==b.button||peripheralControls.processControlActivated(a.wmsxControl,!1,2===b.button||f===KEY_SHIFT_MASK));var g=a.wmsxMenu;if(g){if(0===f&&!b.button)return void(e!==g&&(showBarMenu(g),"touchstart"===b.type&&barButtonLongTouchStart(b)));for(var h=0;h<g.length;++h)if(g[h].clickModif===f)return void peripheralControls.processControlActivated(g[h].control,1===b.button,g[h].secSlot)}}}function barButtonLongTouchStart(a){barButtonLongTouchTarget=a.target,barButtonLongTouchSelectTimeout=window.setTimeout(function(){if(barMenuActive)for(var a=barMenu.wmsxItems,b=0;b<a.length;++b){var c=a[b].wmsxMenuOption;if(c&&0===c.clickModif)return void barMenuItemSetActive(a[b],!0)}},450)}function barButtonLongTouchCancel(){barButtonLongTouchSelectTimeout&&(clearTimeout(barButtonLongTouchSelectTimeout),barButtonLongTouchSelectTimeout=null)}function barButtonHoverOver(a,b){barMenuActive&&a.wmsxMenu&&barMenuActive!==a.wmsxMenu&&(controllersHub.hapticFeedbackOnTouch(b),showBarMenu(a.wmsxMenu))}function barButtonTouchEndOrMouseUp(a){
logoMessageActive||barMenuItemActive&&barMenuItemFireActive(a.shiftKey||2===a.button,a.ctrlKey)}function barMenuItemTapOrMouseDown(a,b,c){c||barMenuItemSetActive(a,"touchstart"===b.type)}function barMenuItemHoverOver(a,b){barMenuItemSetActive(a,"touchmove"===b.type)}function barMenuItemHoverOut(){barMenuItemSetActive(null)}function barMenuItemTouchEndOrMouseUp(a){if(!logoMessageActive){var b=a.shiftKey||2===a.button;barMenuItemTouchActivation&&wmsx.Util.performanceNow()-barMenuItemTouchActivation>TOUCH_EXT_SLOT2_TIME&&(b|=!0),barMenuItemActive&&barMenuItemFireActive(b,a.ctrlKey)}}function barMenuItemFireActive(a,b){var c=barMenuItemActive.wmsxMenuOption;barMenuItemSetActive(null),c&&!c.disabled&&(c.extension?extensionChangeDisabledWarning()||peripheralControls.processControlActivated(wmsx.PeripheralControls.EXTENSION_TOGGLE,b,a,c.extension):c.control&&(a=void 0!==c.secSlot?c.secSlot:a,closeAllOverlays(),peripheralControls.processControlActivated(c.control,b,a)))}function barMenuItemSetActive(a,b){a!==barMenuItemActive&&(barMenuItemActive&&barMenuItemActive.classList.remove("wmsx-hover"),a&&a.wmsxMenuOption?(barMenuItemActive=a,b&&controllersHub.hapticFeedback(),barMenuItemActive.classList.add("wmsx-hover")):barMenuItemActive=null,barMenuItemTouchActivation=b&&barMenuItemActive?wmsx.Util.performanceNow():void 0)}function barElementTapOrMouseDown(a,b,c){cursorHideFrameCountdown=CURSOR_HIDE_FRAMES;var d=a.target;1===d.wmsxBarElementType?barButtonTapOrMousedown(d,a,b,c):2===d.wmsxBarElementType?barMenuItemTapOrMouseDown(d,a,c):hideBarMenu()}function barElementTouchMove(a){wmsx.Util.blockEvent(a);var b=a.changedTouches[0],c=b&&document.elementFromPoint(b.clientX,b.clientY);barButtonLongTouchTarget&&c!==barButtonLongTouchTarget&&barButtonLongTouchCancel(),2!==c.wmsxBarElementType&&c!==barButtonLongTouchTarget&&barMenuItemSetActive(null),1===c.wmsxBarElementType?barButtonHoverOver(c,a):2===c.wmsxBarElementType&&barMenuItemHoverOver(c,a)}function barElementTouchEndOrMouseUp(a){cursorHideFrameCountdown=CURSOR_HIDE_FRAMES,wmsx.Util.blockEvent(a),barButtonLongTouchCancel();var b=a.target;1===b.wmsxBarElementType?barButtonTouchEndOrMouseUp(a):2===b.wmsxBarElementType&&barMenuItemTouchEndOrMouseUp(a)}function createSettingsMenuOptions(){var a=[];return a.push({label:"Select Machine",clickModif:KEY_ALT_MASK,control:wmsx.PeripheralControls.SCREEN_OPEN_MACHINE_SELECT}),isMobileDevice?a.push({label:"Quick Options",clickModif:0,control:wmsx.PeripheralControls.SCREEN_OPEN_QUICK_OPTIONS}):(a.push({label:"Help & Settings",clickModif:0,control:wmsx.PeripheralControls.SCREEN_OPEN_SETTINGS}),a.push({label:"Quick Options",clickModif:KEY_CTRL_MASK,control:wmsx.PeripheralControls.SCREEN_OPEN_QUICK_OPTIONS})),isTouchDevice&&a.push({label:"Touch Setup",clickModif:KEY_CTRL_MASK|KEY_ALT_MASK,control:wmsx.PeripheralControls.SCREEN_OPEN_TOUCH_CONFIG,fullScreenOnly:!0}),isMobileDevice||a.push({label:"Defaults",clickModif:KEY_SHIFT_MASK,control:wmsx.PeripheralControls.SCREEN_DEFAULTS}),a}function defineSettingsMenuExtensions(){for(var a=settingsButton.wmsxMenu;a[0].extension;)a.shift();a[0].divider||a.unshift({label:"",divider:!0});for(var b=WMSX.EXTENSIONS_CONFIG,c=Object.keys(b).reverse(),d=0;d<c.length;++d){var e=c[d],f=b[e];if(f.DESC){var g={label:f.DESC,extension:e,toggle:!0,checkedOp:0};a.unshift(g)}}a[0].divider&&a.shift()}function refreshSettingsMenuForExtensions(){for(var a=settingsButton.wmsxMenu,b=0;b<a.length;++b){var c=a[b];c.extension&&(c.checkedOp=WMSX.EXTENSIONS[c.extension],c.noOp2=!WMSX.EXTENSIONS_CONFIG[c.extension].SLOT2)}barMenuActive===a&&refreshBarMenu(a)}function refreshSettingsMenuForMachineType(){var a=settingsButton.wmsxMenu,b=WMSX.MACHINES_CONFIG[machineTypeSocket.getMachine()];a.wmsxTitle=((b.DESC||b.DESCX).split("(")[0]||"Settings").trim(),settingsButton.wmsxMenu[settingsButton.wmsxMenu.length-5].disabled=2===room.netPlayMode,barMenuActive===a&&refreshBarMenu(a)}function setupCopyTextArea(){copyTextArea=document.createElement("textarea"),copyTextArea.id="wmsx-copy-texarea",fsElement.appendChild(copyTextArea)}function setupFullscreen(){fullscreenAPIEnterMethod=fsElement.requestFullscreen||fsElement.webkitRequestFullscreen||fsElement.webkitRequestFullScreen||fsElement.mozRequestFullScreen,fullScreenAPIExitMethod=document.exitFullscreen||document.webkitExitFullscreen||document.mozCancelFullScreen,"fullscreenElement"in document?fullScreenAPIQueryProp="fullscreenElement":"webkitFullscreenElement"in document?fullScreenAPIQueryProp="webkitFullscreenElement":"mozFullScreenElement"in document&&(fullScreenAPIQueryProp="mozFullScreenElement"),fullscreenAPIEnterMethod||!isMobileDevice||isBrowserStandalone||(fullScreenScrollHack=!0),"onfullscreenchange"in document?document.addEventListener("fullscreenchange",fullscreenByAPIChanged):"onwebkitfullscreenchange"in document?document.addEventListener("webkitfullscreenchange",fullscreenByAPIChanged):"onmozfullscreenchange"in document&&document.addEventListener("mozfullscreenchange",fullscreenByAPIChanged),fullscreenAPIEnterMethod||(scrollMessage.wmsxScroll=canvas.wmsxScroll=logo.wmsxScroll=logoCenter.wmsxScroll=logoImage.wmsxScroll=logoMessage.wmsxScroll=logoMessageText.wmsxScroll=logoMessageOK.wmsxScroll=logoMessageOKText.wmsxScroll=!0,fsElement.addEventListener("touchmove",function(a){if(isFullscreen){if(!fullScreenScrollHack||!a.target.wmsxScroll)return wmsx.Util.blockEvent(a);scrollMessageActive&&setScrollMessage(!1)}}))}function setEnterFullscreenByAPIOnFirstTouch(){if(fullscreenAPIEnterMethod){var a=!1,b=function(){if(!a){for(var c=event.target;c!==fsElement&&c!==document.body;c=c.parentElement)if(c.wmsxIgnoreEnterFS)return;a=!0,wmsx.Util.removeEventsListener(fsElement,"touchend mousedown",b,!0),enterFullScreenByAPI()}};wmsx.Util.addEventsListener(fsElement,"touchend mousedown",b,!0)}}function setFullscreenState(a){isFullscreen=a,a?(setViewport(),document.documentElement.classList.add("wmsx-full-screen"),fullScreenScrollHack&&document.documentElement.classList.add("wmsx-full-screen-scroll-hack"),controllersHub.setupTouchControlsIfNeeded(fsElementCenter),fullScreenScrollHack&&setScrollMessage(!0),fullscreenAPIEnterMethod||tryToFixSafariBugOnFullScreenChange()):(restoreViewport(),document.documentElement.classList.remove("wmsx-full-screen"),fullScreenScrollHack&&document.documentElement.classList.remove("wmsx-full-screen-scroll-hack"),fullscreenAPIEnterMethod||tryToFixSafariBugOnFullScreenChange()),closeAllOverlays(),requestReadjust(),controllersHub.screenFullscreenStateUpdate(isFullscreen)}function tryToFixSafariBugOnFullScreenChange(){var a=document.getElementById("wmsx-dummy-element");a?mainElement.removeChild(a):(a=document.createElement("div"),a.id="wmsx-dummy-element",mainElement.appendChild(a))}function showBar(){buttonsBar.classList.remove("wmsx-hidden")}function hideBar(){!BAR_AUTO_HIDE&&!isFullscreen||barMenuActive||virtualKeyboardMode||(hideBarMenu(),buttonsBar.classList.add("wmsx-hidden"))}function showBarMenu(a,b){if(a&&barMenuActive!==a){if(!barMenu)return setupBarMenu(),void setTimeout(function(){showBarMenu(a,b)},1);refreshBarMenu(a),barMenuItemSetActive(b?barMenu.wmsxDefaultItem:null);var c=a.wmsxRefElement,d=c&&c.offsetLeft-15||0;d+wmsx.ScreenGUI.BAR_MENU_WIDTH>buttonsBarInner.clientWidth?(barMenu.style.right=0,barMenu.style.left="auto",barMenu.style.transformOrigin="bottom right"):(d<0&&(d=0),barMenu.style.left=d+"px",barMenu.style.right="auto",barMenu.style.transformOrigin="bottom left"),showCursorAndBar(!0),barMenuActive=a,barMenu.style.display="inline-block",barMenu.wmsxTitle.focus()}}function refreshBarMenu(a){barMenu.wmsxTitle.innerHTML=a.wmsxTitle,barMenu.wmsxDefaultItem=null;for(var b,c=0,d=Math.min(a.length,BAR_MENU_MAX_ITEMS),e=wmsx.ScreenGUI.BAR_MENU_ITEM_HEIGHT+3,f=0;f<d;++f){var g=a[f];void 0!==g.label&&(b=barMenu.wmsxItems[c],b.firstChild.textContent=g.label,b.wmsxMenuOption=null,
g.hidden||isFullscreen&&g.fullScreenHidden||!isFullscreen&&g.fullScreenOnly?b.style.display="none":(b.style.display="block",g.divider?b.classList.add("wmsx-bar-menu-item-divider"):(b.classList.remove("wmsx-bar-menu-item-divider"),e+=wmsx.ScreenGUI.BAR_MENU_ITEM_HEIGHT,b.classList.toggle("wmsx-bar-menu-item-toggle",void 0!==g.toggle),b.classList.toggle("wmsx-bar-menu-item-toggle-radio",!!g.radio),b.classList.toggle("wmsx-no-op2",g.noOp2||!!g.radio),g.disabled?b.classList.add("wmsx-bar-menu-item-disabled"):(b.classList.remove("wmsx-bar-menu-item-disabled"),b.wmsxMenuOption=g,0===g.clickModif&&(barMenu.wmsxDefaultItem=b),b.wmsxNeedsUIG=g.needsUIG,void 0!==g.toggle&&(b.classList.toggle("wmsx-bar-menu-item-toggle-checked",!!g.checkedOp),b.classList.toggle("wmsx-op1",0!=(1&g.checkedOp)),b.classList.toggle("wmsx-op2",0!=(2&g.checkedOp)))))),++c)}for(var h=c;h<BAR_MENU_MAX_ITEMS;++h)b=barMenu.wmsxItems[h],b.firstChild.textContent="",b.style.display="none",b.wmsxMenuOption=null;var i=fsElementCenter.clientHeight-wmsx.ScreenGUI.BAR_HEIGHT-12,j=e<i?1:i/e;barMenu&&(barMenu.style.transform="scale("+j.toFixed(4)+")")}function hideBarMenu(){barMenuActive&&(barMenuActive=null,barMenu.style.display="none",barMenuItemSetActive(null),cursorHideFrameCountdown=CURSOR_HIDE_FRAMES,self.focus())}function setupBarMenu(){barMenu=document.createElement("div"),barMenu.id="wmsx-bar-menu";var a=document.createElement("div");a.id="wmsx-bar-menu-inner",barMenu.appendChild(a);var b=document.createElement("div");b.id="wmsx-bar-menu-title",b.tabIndex=-1,b.innerHTML="Menu Title",a.appendChild(b),barMenu.wmsxTitle=b,barMenu.wmsxItems=new Array(BAR_MENU_MAX_ITEMS);for(var c=0;c<BAR_MENU_MAX_ITEMS;++c){var d=document.createElement("div");d.classList.add("wmsx-bar-menu-item"),d.style.display="none",d.innerHTML="Menu Item "+c,d.wmsxBarElementType=2,d.wmsxItemIndex=c,d.addEventListener("mouseenter",function(a){barMenuItemHoverOver(a.target,a)}),d.addEventListener("mouseleave",barMenuItemHoverOut),a.appendChild(d),barMenu.wmsxItems[c]=d}barMenu.addEventListener("keydown",function(a){var b=domKeys.codeNewForKeyboardEvent(a);if(MENU_CLOSE_KEYS[b])hideBarMenu();else if(barMenuItemActive&&MENU_EXEC_KEYS[b&~KEY_SHIFT_MASK&~KEY_CTRL_MASK])barMenuItemFireActive(a.shiftKey,a.ctrlKey);else if(MENU_SELECT_KEYS[b]){if(!barMenuActive)return;var c=barMenuActive.wmsxMenuIndex;do{c=(barMenus.length+c+MENU_SELECT_KEYS[b])%barMenus.length;var d=barMenus[c]}while(!d||d.wmsxHidden);showBarMenu(d,!0)}else if(MENU_ITEM_SELECT_KEYS[b]){var e=barMenu.wmsxItems,f=barMenuItemActive?barMenuItemActive.wmsxItemIndex:-1,g=BAR_MENU_MAX_ITEMS+1;do{f=(f+e.length+MENU_ITEM_SELECT_KEYS[b])%e.length}while(--g>=0&&!e[f].wmsxMenuOption);g>=0&&barMenuItemSetActive(e[f])}return wmsx.Util.blockEvent(a)}),buttonsBar.appendChild(barMenu)}function closePowerOnModals(){pasteDialog&&pasteDialog.hide(),textEntryDialog&&textEntryDialog.hide()}function closeAllOverlays(a){hideBarMenu(),pasteDialog&&pasteDialog.hide(),machineSelectDialog&&machineSelectDialog.hide(),diskSelectDialog&&diskSelectDialog.hide(),newHardDiskDialog&&newHardDiskDialog.hide(),saveStateDialog&&saveStateDialog.hide(),touchConfigDialog&&touchConfigDialog.hide(),quickOtionsDialog&&quickOtionsDialog.hide(),cartFormatDialog&&cartFormatDialog.hide(),settingsDialog&&settingsDialog.hide(),netPlayDialog&&!a&&netPlayDialog.hide(),textEntryDialog&&!a&&textEntryDialog.hide()}function showLogoMessage(a,b,c,d){logoMessageActive||(closeAllOverlays(),d&&(afterMessageAction=d),logoMessageText.innerHTML=a,logoMessageOK.classList.toggle("wmsx-higher",!!c),logoMessageOKText.innerHTML=b||"OK",fsElement.classList.add("wmsx-logo-message-active"),logoMessageActive=!0,signalIsOn=!1,updateLogo())}function closeLogoMessage(a,b,c){if(c||controllersHub.hapticFeedbackOnTouch(a),!b&&(fsElement.classList.remove("wmsx-logo-message-active"),logoMessageActive=!1,afterMessageAction)){var d=afterMessageAction;afterMessageAction=null,d()}}function updateLogoScale(){if(logoMessageActive){var a=canvasOuter.clientWidth,b=Math.min(a/wmsx.ScreenGUI.LOGO_SCREEN_WIDTH,1);logoCenter.style.transform="translate(-50%, -50%) scale("+b.toFixed(4)+")"}else logoCenter.style.transform="translate(-50%, -50%)"}function setScrollMessage(a){fsElement.classList.toggle("wmsx-scroll-message",a),scrollMessageActive=a,a&&setTimeout(function(){setScrollMessage(!1)},5e3)}function readjustAll(a,b){if(readjustScreeSizeChanged(a)){if(isFullscreen){var c=readjustScreenSize.w>readjustScreenSize.h,d=virtualKeyboardMode&&updateKeyboardWidth(readjustScreenSize.w);buttonsBarDesiredWidth=c?virtualKeyboardMode?d.w:0:-1;var e=readjustScreenSize.h;c&&!virtualKeyboardMode||(e-=wmsx.ScreenGUI.BAR_HEIGHT+2),virtualKeyboardMode&&(e-=d.h+2),displayScale(aspectX,displayOptimalScaleY(readjustScreenSize.w,e))}else buttonsBarDesiredWidth=-1,displayScale(aspectX,scaleYBeforeUserFullscreen||displayDefaultScale());b||self.focus(),controllersHub.screenReadjustedUpdate()}readjustInterval&&wmsx.Util.performanceNow()-readjustRequestTime>=1e3&&(clearInterval(readjustInterval),readjustInterval=null)}function readjustScreeSizeChanged(a){var b=mainElement.parentElement.clientWidth,c=fsElementCenter.clientWidth,d=fsElementCenter.clientHeight;return!(!a&&readjustScreenSize.pw===b&&readjustScreenSize.w===c&&readjustScreenSize.h===d)&&(readjustScreenSize.pw=b,readjustScreenSize.w=c,readjustScreenSize.h=d,!0)}function auxReadjustAll(a,b){auxReadjustScreeSizeChanged(a||b)&&(auxIsMaxed()||b?auxDisplayScale(auxAspectX,auxDisplayOptimalScaleY(auxReadjustScreenSize.w,auxReadjustScreenSize.h)):auxDisplayScale(auxAspectX,auxScaleY,!0))}function auxReadjustScreeSizeChanged(a){var b=auxWindow.document.body.clientWidth,c=auxFsElementCenter.clientWidth,d=auxFsElementCenter.clientHeight;return!(!a&&auxReadjustScreenSize.pw===b&&auxReadjustScreenSize.w===c&&auxReadjustScreenSize.h===d)&&(auxReadjustScreenSize.pw=b,auxReadjustScreenSize.w=c,auxReadjustScreenSize.h=d,!0)}function displayOptimalScaleY(a,b){var c=b/targetHeight;return scrTargetWidth*aspectX*aspectXCorrection*c>a&&(c=a/(scrTargetWidth*aspectX)),c}function auxDisplayOptimalScaleY(a,b){var c=b/auxTargetHeight;return auxScrTargetWidth*auxAspectX*auxAspectXCorrection*c>a&&(c=a/(auxScrTargetWidth*auxAspectX)),c}function setViewport(){if(isMobileDevice){if(void 0===viewPortOriginalContent&&(viewPortOriginalTag=document.querySelector("meta[name=viewport]"),viewPortOriginalContent=viewPortOriginalTag&&viewPortOriginalTag.content||null),viewportTag||(viewportTag=document.createElement("meta"),viewportTag.name="viewport",viewportTag.content="width = device-width, height = device-height, initial-scale = 1.0, minimum-scale = 1.0, maximum-scale = 1.0, user-scalable = yes",document.head.appendChild(viewportTag)),viewPortOriginalTag)try{document.head.removeChild(viewPortOriginalTag)}catch(a){}viewPortOriginalTag=null}}function restoreViewport(){if(isMobileDevice){if(!viewPortOriginalTag&&viewPortOriginalContent&&(viewPortOriginalTag=document.createElement("meta"),viewPortOriginalTag.name="viewport",viewPortOriginalTag.content=viewPortOriginalContent,document.head.appendChild(viewPortOriginalTag)),viewportTag)try{document.head.removeChild(viewportTag)}catch(a){}viewportTag=null}}function setPageVisibilityHandling(){function a(){logoMessageActive||(document.hidden?b=!machine.systemPause(!0):b&&machine.systemPause(!1))}var b;document.addEventListener("visibilitychange",a)}function extensionChangeDisabledWarning(){return!!WMSX.MEDIA_CHANGE_DISABLED&&(machine.showOSD("Extension change is disabled!",!0,!0),!0)}function setupFileLoaderDropTargets(){fileLoaderDropArea=document.getElementById("wmsx-drop-area"),fileLoaderDropAreaMessage=document.getElementById("wmsx-drop-area-message");var a,b,c,d;a=fsElement,c={element:a,openType:OPEN_TYPE.DISK,port:void 0,add:!0,mainEle:a,mes:"Add Disk(s) to Drive (auto-detect)",
mesSec:"Add Disk(s) to Drive B Stack"},d={element:a,openType:OPEN_TYPE.DISK,port:void 0,files:!0,mainEle:a,mes:"Add Files to Drive (auto-detect)",mesSec:"Add Files to Disk in Drive B"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.AUTO,port:void 0,subAdd:c,subFiles:d,mes:"Auto detect media",mesSec:"Auto detect media (to Drive B / Cartridge 2)"},diskAButton.wmsxDropTarget=a=document.getElementById("wmsx-drop-drivea"),b=document.getElementById("wmsx-drop-drivea-add"),b.wmsxDropInfo=c={element:b,openType:OPEN_TYPE.DISK,port:0,add:!0,mainEle:a,mes:"Add Disk(s) to Drive A Stack"},b=document.getElementById("wmsx-drop-drivea-files"),b.wmsxDropInfo=d={element:b,openType:OPEN_TYPE.DISK,port:0,files:!0,mainEle:a,mes:"Add Files to Disk in Drive A"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.DISK,port:0,subAdd:c,subFiles:d,mes:"Load Disk(s) in Drive A"},diskBButton.wmsxDropTarget=a=document.getElementById("wmsx-drop-driveb"),b=document.getElementById("wmsx-drop-driveb-add"),b.wmsxDropInfo=c={element:b,openType:OPEN_TYPE.DISK,port:1,add:!0,mainEle:a,mes:"Add Disk(s) to Drive B Stack"},b=document.getElementById("wmsx-drop-driveb-files"),b.wmsxDropInfo=d={element:b,openType:OPEN_TYPE.DISK,port:1,files:!0,mainEle:a,mes:"Add Files to Disk in Drive B"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.DISK,port:1,subAdd:c,subFiles:d,mes:"Load Disk(s) in Drive B"},diskHButton.wmsxDropTarget=a=document.getElementById("wmsx-drop-driveh"),b=document.getElementById("wmsx-drop-driveh-files"),b.wmsxDropInfo=d={element:b,openType:OPEN_TYPE.DISK,port:2,files:!0,mainEle:a,mes:"Add Files to Hard Disk"},a.wmsxDropInfo={element:a,openType:OPEN_TYPE.DISK,port:2,subFiles:d,mes:"Load Hard Disk"},a=document.getElementById("wmsx-drop-cart1"),a.wmsxDropInfo={element:a,openType:OPEN_TYPE.ROM,port:0,mes:"Load Cartride 1"},a=document.getElementById("wmsx-drop-cart2"),a.wmsxDropInfo={element:a,openType:OPEN_TYPE.ROM,port:1,mes:"Load Cartride 2"},a=document.getElementById("wmsx-drop-tape"),a.wmsxDropInfo={element:a,openType:OPEN_TYPE.TAPE,port:0,mes:"Load Cassette Tape"}}var self=this;this.connect=function(a){machine=a,machine.getVideoSocket().connectMonitor(monitor),controllersSocket=machine.getControllersSocket(),cartridgeSocket=machine.getCartridgeSocket(),extensionsSocket=machine.getExtensionsSocket(),machineTypeSocket=machine.getMachineTypeSocket()},this.connectPeripherals=function(a,b,c,d,e,f,g,h){cartridgeSlot=a,fileLoader=b,fileLoader.registerForDnD(fsElement),fileLoader.registerForFileInputElement(fsElement),fileDownloader=c,fileDownloader.registerForDownloadElement(fsElement),machineControls=d,peripheralControls=e,controllersHub=f,controllersHub.addKeyInputElement(fsElement),controllersHub.setMouseInputElement(canvas),diskDrive=g,stateMedia=h},this.powerOn=function(){this.setDefaults(),updateLogo(),document.documentElement.classList.add("wmsx-started"),setPageVisibilityHandling(),this.focus(),WMSXFullScreenSetup.shouldStartInFullScreen()&&(setFullscreenState(!0),2!==FULLSCREEN_MODE&isMobileDevice&&setEnterFullscreenByAPIOnFirstTouch())},this.powerOff=function(){document.documentElement.classList.remove("wmsx-started")},this.start=function(a){function b(){self.setFullscreen(!0),a()}!isMobileDevice||isBrowserStandalone||isFullscreen?a():wmsx.Util.isOfficialHomepage()?showLogoMessage("For "+(fullscreenAPIEnterMethod?"the best":"a full-screen")+' experience, use<br>the "Add to Home Screen" function<br>then launch from the Installed App',"NICE!",!1,b):showLogoMessage("For the best experience,<br>WebMSX will go full-screen","GO!",!0,b)},this.isDualScreenAllowed=function(){return!isMobileDevice},this.refresh=function(a,b,c,d,e,f){cursorHideFrameCountdown>0&&--cursorHideFrameCountdown<=0&&hideCursorAndBar(),ledsStatePending&&updateLeds(),signalIsOn||(signalIsOn=!0,updateLogo());var g,h;if(videoOutputMode<4||5===videoOutputMode^f)g=canvasContext||createCanvasContext(),h=canvas;else if(g=auxCanvasContext||auxCreateCanvasContext(),h=auxCanvas,!g)return;if(3===videoOutputMode&&f&&g.clearRect(0,0,h.width,h.height),g.drawImage(a,b,c,d,e,0,0,h.width,h.height),crtScanlines&&pixelHeight>1&&!debugMode&&(videoOutputMode>=4||videoOutputMode<=1||!f)){var i=g.globalCompositeOperation,j=g.globalAlpha;g.globalCompositeOperation="source-over",g.globalAlpha=crtScanlines/10,g.drawImage(scanlinesImage,0,0,1,h.height,0,0,h.width,h.height),g.globalCompositeOperation=i,g.globalAlpha=j}},this.videoSignalOff=function(){signalIsOn=!1,showCursorAndBar(),updateLeds(),updateLogo()},this.mousePointerLocked=function(a){mousePointerLocked=a,mousePointerLocked?hideCursorAndBar():showCursorAndBar()},this.openHelp=function(){return self.openSettings("GENERAL"),!1},this.openAbout=function(){return self.openSettings("ABOUT"),!1},this.openSettings=function(a){closeAllOverlays(),settingsDialog||(settingsDialog=new wmsx.SettingsDialog(fsElementCenter,controllersHub,peripheralControls,machineTypeSocket)),settingsDialog.show(a)},this.openSaveStateDialog=function(a){closeAllOverlays(),saveStateDialog||(saveStateDialog=new wmsx.SaveStateDialog(fsElementCenter,machineControls,peripheralControls,stateMedia)),saveStateDialog.show(a)},this.openDiskSelectDialog=function(a,b,c){closeAllOverlays(),diskSelectDialog||(diskSelectDialog=new wmsx.DiskSelectDialog(fsElementCenter,diskDrive,peripheralControls,fileLoader)),diskSelectDialog.show(a,b,c)},this.openNewHardDiskDialog=function(a,b){closeAllOverlays(),newHardDiskDialog||(newHardDiskDialog=new wmsx.NewHardDiskDialog(fsElementCenter,peripheralControls)),newHardDiskDialog.show(a,b)},this.openMachineSelectDialog=function(){if(closeAllOverlays(),WMSX.MEDIA_CHANGE_DISABLED)return this.showOSD("Machine change is disabled!",!0,!0);machineSelectDialog||(machineSelectDialog=new wmsx.MachineSelectDialog(fsElementCenter,machineTypeSocket,peripheralControls)),machineSelectDialog.show()},this.openTouchConfigDialog=function(){closeAllOverlays(),virtualKeyboardMode&&setVirtualKeyboard(0),touchConfigDialog||(touchConfigDialog=new wmsx.TouchConfigDialog(fsElement,canvasOuter,controllersHub,peripheralControls)),touchConfigDialog.show()},this.openQuickOptionsDialog=function(){closeAllOverlays(),virtualKeyboardMode&&setVirtualKeyboard(0),quickOtionsDialog||(quickOtionsDialog=new wmsx.QuickOptionsDialog(fsElementCenter,machineTypeSocket,machineControls,peripheralControls)),quickOtionsDialog.show()},this.openNetPlayDialog=function(){closeAllOverlays(),netPlayDialog||(netPlayDialog=new wmsx.NetPlayDialog(room,fsElementCenter)),netPlayDialog.show()},this.openCartridgeFormatDialog=function(a,b){closeAllOverlays(),cartFormatDialog||(cartFormatDialog=new wmsx.CartridgeFormatDialog(this,fsElementCenter,machine,cartridgeSlot)),cartFormatDialog.show(a,b)},this.openLoadFileDialog=function(){return peripheralControls.processControlActivated(wmsx.PeripheralControls.AUTO_LOAD_FILE),!1},this.executeTextCopy=function(){if(!signalIsOn)return this.showOSD("Screen Text Copy only available when Power is ON!",!0,!0);if(!document.queryCommandSupported||!document.queryCommandSupported("copy"))return this.showOSD("Copy to Clipboard not supported by the browser!",!0,!0);var a=monitor.getScreenText();if(!a)return this.showOSD("Screen Text Copy not available in this Screen!",!0,!0);copyTextArea||setupCopyTextArea(),copyTextArea.innerHTML=a,copyTextArea.select(),document.execCommand("copy")?this.showOSD("Screen text copied to Clipboard",!0):this.showOSD("Copy to Clipboard not supported by the browser!",!0,!0),this.focus()},this.toggleTextPasteDialog=function(){return signalIsOn?(pasteDialog||(pasteDialog=new wmsx.PasteDialog(canvasOuter,this,machineControls)),pasteDialog.toggle(),!1):this.showOSD("Text Paste only available when Power is ON!",!0,!0)},this.toggleTextEntryDialog=function(){return signalIsOn?(virtualKeyboardMode&&setVirtualKeyboard(0),
textEntryDialog||(textEntryDialog=new wmsx.TextEntryDialog(fsElementCenter,this,machineControls)),textEntryDialog.toggle(),!1):this.showOSD("Text Entry only available when Power is ON!",!0,!0)},this.toggleMenuByKey=function(){barMenuActive?hideBarMenu():(closeAllOverlays(),showBarMenu(barMenuSystem,!0))},this.toggleVirtualKeyboard=function(){setVirtualKeyboard((virtualKeyboardMode+1)%3)},this.getScreenCapture=function(){if(signalIsOn)return canvas.toDataURL("image/png")},this.saveScreenCapture=function(){var a=this.getScreenCapture();a&&fileDownloader.startDownloadURL("WMSX Screen.png",a,"WebMSX Screen Capture")},this.displayMetrics=function(a,b,c){var d,e,f,g;switch(a){case 192:case 384:d=384;break;case 272:case 544:d=544;break;case 640:d=640;break;case 768:d=768;break;case 1088:d=1088;break;default:d=544}switch(f=640===d?640:544,g=640===f?aspectXCorrectionVal:1,b){case 208:e=416;break;case 228:case 456:e=456;break;case 400:e=400;break;case 240:case 480:e=480;break;default:e=456}(0===videoOutputMode||4===videoOutputMode)===c?updateDisplayMetrics(a,b,d,e,f,g):auxUpdateDisplayMetrics(a,b,d,e,f,g)},this.getMonitor=function(){return monitor},this.showOSD=function(a,b,c){if(osdTimeout&&clearTimeout(osdTimeout),!a)return hideOSDs();var d,e;isFocusOnAuxWindow()?(d=auxOsd,e=auxCanvas):(d=osd,e=canvasOuter),!b&&osdShowing||(d.innerHTML=a,d.style.color=c?"rgb(255, 60, 40)":"rgb(0, 255, 0)"),d.style.transition="none",d.style.top="12px",d.style.opacity=1,osdShowing=!0;var f=e.clientWidth-30,g=d.clientWidth,h=g<f?1:f/g;d.style.transform="scale("+h.toFixed(4)+")",osdTimeout=setTimeout(hideOSDs,OSD_TIME)},this.setDebugMode=function(a){debugMode=!!a,debugMode&&videoOutputMode>1&&videoOutputMode<4&&monitor.setOutputMode(Math.min(1,videoOutputMode),!0),canvasContext=null},this.setDefaults=function(){crtPhosphorSetDefault(),crtScanlinesSetDefault(),crtFilterSetDefault(),aspectAndScaleSetDefault()},this.crtFilterToggle=function(a){var b;a?(b=crtFilter-1)<-2&&(b=3):(b=crtFilter+1)>3&&(b=-2),setCRTFilter(b);var c=null===crtFilterEffective?"browser default":crtFilterEffective<1?"OFF":"level "+crtFilterEffective;this.showOSD("CRT Filter: "+(-1===crtFilter?"AUTO ("+c+")":c),!0),WMSX.userPreferences.current.crtFilter!==crtFilter&&(WMSX.userPreferences.current.crtFilter=crtFilter,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())},this.crtScanlinesToggle=function(a){var b;if(a?(b=crtScanlines-1)<0&&(b=10):(b=crtScanlines+1)>10&&(b=0),!crtScanlines&&b){for(var c=[.5,.75,1,1.5,2,2.5,3,3.5,4,4.5,5,5.5],d=0;d<c.length-1&&scaleY>=c[d];)++d;if(displayScale(aspectX,c[d-1]),auxWindow){for(d=0;d<c.length-1&&auxScaleY>=c[d];)++d;auxDisplayScale(auxAspectX,c[d-1],!auxIsMaxed())}}setCRTScanlines(b),this.showOSD("CRT Scanlines: "+(0===crtScanlines?"OFF":10*crtScanlines+"%"),!0),WMSX.userPreferences.current.crtScanlines!==crtScanlines&&(WMSX.userPreferences.current.crtScanlines=crtScanlines,WMSX.userPreferences.setDirty(),WMSX.userPreferences.save())},this.crtPhosphorToggle=function(a){var b;a?(b=crtPhosphor-1)<-1&&(b=1):(b=crtPhosphor+1)>1&&(b=-1),setCRTPhosphor(b);var c=1===crtPhosphorEffective?"ON":"OFF";this.showOSD("CRT Phosphor: "+(-1===crtPhosphor?"AUTO ("+c+")":c),!0)},this.getControlReport=function(a){switch(a){case wmsx.PeripheralControls.SCREEN_CRT_FILTER:return{label:-2===crtFilter?"Browser":-1===crtFilter?"Auto":0===crtFilter?"OFF":"Level "+crtFilter,active:crtFilter>=0};case wmsx.PeripheralControls.SCREEN_CRT_SCANLINES:return{label:0===crtScanlines?"OFF":10*crtScanlines+"%",active:crtScanlines>0}}return{label:"Unknown",active:!1}},this.fullscreenToggle=function(a){if(-2!==FULLSCREEN_MODE){if(isFocusOnAuxWindow())return auxDisplayToggleFullscreen();isFullscreen||isMobileDevice||(scaleYBeforeUserFullscreen=scaleY),this.setFullscreen(!isFullscreen,a)}},this.setFullscreen=function(a,b){a?!b&&fullscreenAPIEnterMethod?enterFullScreenByAPI():setFullscreenState(!0):isFullScreenByAPI()?exitFullScreenByAPI():setFullscreenState(!1)},this.displayAspectDecrease=function(){isFocusOnAuxWindow()?(auxDisplayScale(normalizeAspectX(auxAspectX-ASPECT_STEP),auxScaleY,!auxIsMaxed()),this.showOSD("Display Aspect: "+auxAspectX.toFixed(2)+"x",!0)):(displayScale(normalizeAspectX(aspectX-ASPECT_STEP),scaleY),this.showOSD("Display Aspect: "+aspectX.toFixed(2)+"x",!0))},this.displayAspectIncrease=function(){isFocusOnAuxWindow()?(auxDisplayScale(normalizeAspectX(auxAspectX+ASPECT_STEP),auxScaleY,!auxIsMaxed()),this.showOSD("Display Aspect: "+auxAspectX.toFixed(2)+"x",!0)):(displayScale(normalizeAspectX(aspectX+ASPECT_STEP),scaleY),this.showOSD("Display Aspect: "+aspectX.toFixed(2)+"x",!0))},this.displayScaleDecrease=function(){isFocusOnAuxWindow()?(auxDisplayScale(auxAspectX,normalizeScaleY(auxScaleY-SCALE_STEP),!auxIsMaxed()),this.showOSD("Display Size: "+auxScaleY.toFixed(2)+"x",!0)):(displayScale(aspectX,normalizeScaleY(scaleY-SCALE_STEP)),this.showOSD("Display Size: "+scaleY.toFixed(2)+"x",!0))},this.displayScaleIncrease=function(){isFocusOnAuxWindow()?(auxDisplayScale(auxAspectX,normalizeScaleY(auxScaleY+SCALE_STEP),!auxIsMaxed()),this.showOSD("Display Size: "+auxScaleY.toFixed(2)+"x",!0)):(displayScale(aspectX,normalizeScaleY(scaleY+SCALE_STEP)),this.showOSD("Display Size: "+scaleY.toFixed(2)+"x",!0))},this.focus=function(){canvas.focus()},this.machinePowerAndUserPauseStateUpdate=function(a,b){powerButton.style.backgroundPosition=powerButton.wmsxBX+"px "+(powerButton.wmsxBY+barButtonBackYOffset*(a?1:0))+"px",2===room.netPlayMode?(powerButton.wmsxMenu[5].disabled=powerButton.wmsxMenu[6].disabled=powerButton.wmsxMenu[8].disabled=powerButton.wmsxMenu[9].disabled=!0,powerButton.wmsxMenu[1].disabled=!a):(powerButton.wmsxMenu[5].disabled=powerButton.wmsxMenu[6].disabled=powerButton.wmsxMenu[8].disabled=!1,powerButton.wmsxMenu[1].disabled=powerButton.wmsxMenu[9].disabled=!a)},this.diskDrivesMediaStateUpdate=function(a){var b=2===a?diskHButton:1===a?diskBButton:diskAButton,c=diskDrive.getDriveStack(a);if(b.title=diskDrive.getCurrentDiskDesc(a),a<2?(b.wmsxMenu[8].label="Remove "+(c.length>1?"Stack":"Disk"),2===room.netPlayMode?b.wmsxMenu[0].disabled=b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=b.wmsxMenu[4].disabled=b.wmsxMenu[5].disabled=b.wmsxMenu[6].disabled=b.wmsxMenu[7].disabled=b.wmsxMenu[8].disabled=!0:(b.wmsxMenu[0].disabled=b.wmsxMenu[4].disabled=b.wmsxMenu[5].disabled=!1,b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=c.length>=wmsx.FileDiskDrive.MAX_STACK,b.wmsxMenu[6].disabled=c.length<=1,b.wmsxMenu[7].disabled=b.wmsxMenu[8].disabled=0===c.length)):2===room.netPlayMode?b.wmsxMenu[0].disabled=b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=b.wmsxMenu[4].disabled=b.wmsxMenu[5].disabled=b.wmsxMenu[6].disabled=!0:(b.wmsxMenu[0].disabled=b.wmsxMenu[1].disabled=b.wmsxMenu[2].disabled=b.wmsxMenu[3].disabled=b.wmsxMenu[4].disabled=!1,b.wmsxMenu[5].disabled=b.wmsxMenu[6].disabled=0===c.length),diskSelectDialog&&diskSelectDialog.diskDrivesMediaStateUpdate(a),c.length>1){var d=diskDrive.getCurrentDiskNum(a)+1;b.wmsxMenu.wmsxTitle=diskDrive.getDriveName(a)+"&nbsp;&nbsp;("+d+"/"+c.length+")"}else b.wmsxMenu.wmsxTitle=diskDrive.getDriveName(a)},this.diskDrivesMotorStateUpdate=function(a,b,c,d,e,f,g,h,i){diskAButton.style.backgroundPosition=diskAButton.wmsxBX+"px "+mediaButtonBackYOffsets[b?3:a?c?2:1:0]+"px",diskBButton.style.backgroundPosition=diskBButton.wmsxBX+"px "+mediaButtonBackYOffsets[e?3:d?f?2:1:0]+"px",diskHButton.style.backgroundPosition=diskHButton.wmsxBX+"px "+mediaButtonBackYOffsets[h?3:g?i?2:1:0]+"px"},this.diskInterfacesStateUpdate=function(a,b){peripheralControls.diskInterfacesStateUpdate(a,b),diskAButton.classList.toggle("wmsx-hidden",!a),diskAButton.wmsxDropTarget.classList.toggle("wmsx-disabled",!a),diskAButton.wmsxDropTarget.wmsxDropInfo.disabled=!a,diskAButton.wmsxMenu.wmsxHidden=!a,
diskBButton.classList.toggle("wmsx-hidden",!a),diskBButton.wmsxDropTarget.classList.toggle("wmsx-disabled",!a),diskBButton.wmsxDropTarget.wmsxDropInfo.disabled=!a,diskBButton.wmsxMenu.wmsxHidden=!a,diskHButton.classList.toggle("wmsx-hidden",!b),diskHButton.wmsxDropTarget.classList.toggle("wmsx-disabled",!b),diskHButton.wmsxDropTarget.wmsxDropInfo.disabled=!b;var c=diskHButton.wmsxMenu;c.wmsxHidden=!b;var d=diskDrive.isHardDriveFirst();diskHButton.classList.toggle("wmsx-hd-first",!!d),diskHButton.wmsxDropTarget.classList.toggle("wmsx-hd-first",!!d);var e=d?1:4;barMenus[1]=1===e?c:null,barMenus[4]=4===e?c:null,c.wmsxMenuIndex=e},this.extensionsAndCartridgesStateUpdate=function(){var a=cartridgeSocket.cartridgeInserted(0),b=cartridgeSocket.cartridgeInserted(1);cartridge1Button.title="Cartridge 1"+(a?": "+(a.format.internal?a.format.desc:(a.rom.source||"<Unknown>")+"  ["+a.format.name+"]"):""),cartridge2Button.title="Cartridge 2"+(b?": "+(b.format.internal?b.format.desc:(b.rom.source||"<Unknown>")+"  ["+b.format.name+"]"):"");var c=a&&a.getDataDesc();cartridge1Button.wmsxMenu[2].label="Load "+(c||"Data")+" File",cartridge1Button.wmsxMenu[3].label="Save "+(c||"Data")+" File",2===room.netPlayMode?cartridge1Button.wmsxMenu[0].disabled=cartridge1Button.wmsxMenu[1].disabled=cartridge1Button.wmsxMenu[2].disabled=cartridge1Button.wmsxMenu[3].disabled=cartridge1Button.wmsxMenu[4].disabled=!0:(cartridge1Button.wmsxMenu[0].disabled=!1,cartridge1Button.wmsxMenu[2].disabled=cartridge1Button.wmsxMenu[3].disabled=!c,cartridge1Button.wmsxMenu[1].disabled=!a||a.format.internal,cartridge1Button.wmsxMenu[4].disabled=!a),c=b&&b.getDataDesc(),cartridge2Button.wmsxMenu[2].label="Load "+(c||"Data")+" File",cartridge2Button.wmsxMenu[3].label="Save "+(c||"Data")+" File",2===room.netPlayMode?cartridge2Button.wmsxMenu[0].disabled=cartridge2Button.wmsxMenu[1].disabled=cartridge2Button.wmsxMenu[2].disabled=cartridge2Button.wmsxMenu[3].disabled=cartridge2Button.wmsxMenu[4].disabled=!0:(cartridge2Button.wmsxMenu[0].disabled=!1,cartridge2Button.wmsxMenu[2].disabled=cartridge2Button.wmsxMenu[3].disabled=!c,cartridge2Button.wmsxMenu[1].disabled=!b||b.format.internal,cartridge2Button.wmsxMenu[4].disabled=!b),this.cartridgesModifiedStateUpdate(a,b),refreshSettingsMenuForExtensions()},this.cartridgesModifiedStateUpdate=function(a,b){cartridge1Button.style.backgroundPosition=cartridge1Button.wmsxBX+"px "+mediaButtonBackYOffsets[a?a.dataModified()?2:1:0]+"px",cartridge2Button.style.backgroundPosition=cartridge2Button.wmsxBX+"px "+mediaButtonBackYOffsets[b?b.dataModified()?2:1:0]+"px"},this.tapeStateUpdate=function(a,b,c){tapeButton.title="Cassette Tape"+(a?": "+a:""),tapeButton.style.backgroundPosition=tapeButton.wmsxBX+"px "+mediaButtonBackYOffsets[b?3:a?c?2:1:0]+"px",2===room.netPlayMode?(tapeButton.wmsxMenu[0].disabled=tapeButton.wmsxMenu[1].disabled=tapeButton.wmsxMenu[2].disabled=tapeButton.wmsxMenu[4].disabled=tapeButton.wmsxMenu[5].disabled=!0,tapeButton.wmsxMenu[3].disabled=!a):(tapeButton.wmsxMenu[0].disabled=tapeButton.wmsxMenu[1].disabled=!1,tapeButton.wmsxMenu[2].disabled=tapeButton.wmsxMenu[3].disabled=tapeButton.wmsxMenu[4].disabled=tapeButton.wmsxMenu[5].disabled=!a)},this.machineTypeStateUpdate=function(){machineSelectDialog&&machineSelectDialog.machineTypeStateUpdate(),quickOtionsDialog&&quickOtionsDialog.machineTypeStateUpdate(),kanaLed.textContent=machineTypeSocket.getCodeLedLabel(),refreshSettingsMenuForMachineType()},this.keyboardSettingsStateUpdate=function(){settingsDialog&&settingsDialog.keyboardSettingsStateUpdate()},this.controllersSettingsStateUpdate=function(){settingsDialog&&settingsDialog.controllersSettingsStateUpdate(),touchConfigDialog&&touchConfigDialog.controllersSettingsStateUpdate()},this.mouseActiveCursorStateUpdate=function(a){cursorType=a?'url("'+wmsx.Images.urls.mouseCursor+'"), auto':"auto",fsElement.style.cursor=cursorShowing?cursorType:"none",showCursorAndBar()},this.touchControlsActiveUpdate=function(a,b,c){touchControlsActive===a&&touchControlsDirBig===b&&touchControlsMirror===c||(touchControlsActive=a,touchControlsDirBig=b,touchControlsMirror=c,isFullscreen&&(touchControlsActive&&controllersHub.setupTouchControlsIfNeeded(fsElementCenter),requestReadjust(!0)))},this.roomNetPlayStatusChangeUpdate=function(a){netPlayDialog&&netPlayDialog.isVisible()||closeAllOverlays(),netPlayDialog&&netPlayDialog.roomNetPlayStatusChangeUpdate(a),netplayButton.classList.toggle("wmsx-hidden",room.netPlayMode<1)},this.quickOptionsControlsStateUpdate=function(){quickOtionsDialog&&quickOtionsDialog.quickOptionsControlsStateUpdate()},