﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace csMSX2
{
    public partial class SetsFrm : Form
    {
        public SetsFrm()
        {
            InitializeComponent();
        }

        private void SetsFrm_Load(object sender, EventArgs e)
        {
            Msx1Lbl.Text = Msx1Lbl.Text + MSX.csMSX_Version;

            if (MSX.Gi_MSX2_Sets == 0) { MsxSelt0Opt.Checked = true; } else { MsxSelt1Opt.Checked = true; };
            if (MSX.Gi_DISK_Sets == 0) { DiskSelt0Opt.Checked = true; } else { DiskSelt1Opt.Checked = true; };
            if (MSX.Gi_CHAR_Sets == 0) { FontSelt0Opt.Checked = true; } else { FontSelt1Opt.Checked = true; };
            Scale2xChk.Checked = (MSX.Gi_SC2X_Sets == 0 ? false : true);

            TimerTxt.Text = FN.gsCStr(MSX.Gi_MSX_Int_Timer, 0);
            if (MSX.Gi_MSX_Int_Timer == 0) TimerTxt.Text = "";
            if ((MSX.Gi_MSX_DisplayFrame < 0) || (MSX.Gi_MSX_DisplayFrame > 3)) MSX.Gi_MSX_DisplayFrame = 0;
            if (MSX.Gi_MSX_DisplayFrame == 0) DspFrame0Opt.Checked = true;
            if (MSX.Gi_MSX_DisplayFrame == 1) DspFrame1Opt.Checked = true;
            if (MSX.Gi_MSX_DisplayFrame == 2) DspFrame2Opt.Checked = true;
            if (MSX.Gi_MSX_DisplayFrame == 3) DspFrame3Opt.Checked = true;

            IntDupeChk.Checked = (MSX.Gi_MSX_InterruptDup == 0 ? false : true);
            AutoSpeedChk.Checked = (MSX.Gi_MSX_Auto_Speed == 0 ? false : true);
            KeyChangeChk.Checked = (MSX.Gi_MSX_KeyChange == 0 ? false : true);
            JoyStickChk.Checked = (MSX.Gi_MSX_JoyOn == 0 ? false : true);
            SpaceOnChk.Checked = (MSX.Gi_MSX_SpaceOn == 0 ? false : true);
            VdtStFfChk.Checked = (MSX.Gi_MSX_VDT_ST_FF == 0 ? false : true);

            CasFileTxt.Text = MSX.Gs_CAS_FILE;
            RomFileTxt.Text = MSX.Gs_ROM_FILE;
            if ((MSX.Gi_ROM_TYPE < 0) || (MSX.Gi_ROM_TYPE > 5)) MSX.Gi_ROM_TYPE = 0;
            if (MSX.Gi_ROM_TYPE == 0) RomSelt0Opt.Checked = true;
            if (MSX.Gi_ROM_TYPE == 1) RomSelt1Opt.Checked = true;
            if (MSX.Gi_ROM_TYPE == 2) RomSelt2Opt.Checked = true;
            if (MSX.Gi_ROM_TYPE == 3) RomSelt3Opt.Checked = true;
            if (MSX.Gi_ROM_TYPE == 4) RomSelt4Opt.Checked = true;
            if (MSX.Gi_ROM_TYPE == 5) RomSelt5Opt.Checked = true;
            DskAFileTxt.Text = MSX.Gs_DSK_A_FILE;
            DskBFileTxt.Text = MSX.Gs_DSK_B_FILE;
            DskAOnChk.Checked = (MSX.Gi_DSK_A_ON == 0 ? false : true);
            DskBOnChk.Checked = (MSX.Gi_DSK_B_ON == 0 ? false : true);
        }

        private void SetsFrm_FormClosed(object sender, FormClosedEventArgs e)
        {
            //
        }

        private void SetEnterCmd_Click(object sender, EventArgs e)
        {
            WRITE_MSX_SETTING();
            this.Close();
        }

        private void SetExitCmd_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void CasFileTxt_Leave(object sender, EventArgs e)
        {
            CasFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(CasFileTxt.Text, 100)));
            CasFileTxt.Text = MSX.gsGetCasFileName(CasFileTxt.Text);
        }

        private void RomFileTxt_Leave(object sender, EventArgs e)
        {
            RomFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(RomFileTxt.Text, 100)));
            RomFileTxt.Text = MSX.gsGetRomFileName(RomFileTxt.Text);
        }

        private void DskAFileTxt_Leave(object sender, EventArgs e)
        {
            DskAFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(DskAFileTxt.Text, 100)));
            DskAFileTxt.Text = MSX.gsGetDskFileName(DskAFileTxt.Text);
        }

        private void DskBFileTxt_Leave(object sender, EventArgs e)
        {
            DskBFileTxt.Text = FN.gsTrim(FN.gsDelete(FN.gsLeft(DskBFileTxt.Text, 100)));
            DskBFileTxt.Text = MSX.gsGetDskFileName(DskBFileTxt.Text);
        }

        private void CasWriteCmd_Click(object sender, EventArgs e)
        {
            string FileName;        
            ushort TXT_TAB, VAR_TAB, ARY_TAB, STR_END;

            SetEnterCmd.Focus();

            FileName = "C:\\MSX-" + DateTime.Now.ToString("yyyyMMdd") + "-" + DateTime.Now.ToString("HHmmss") + ".CAS";

            this.Cursor = Cursors.WaitCursor;
            CasWriteCmd.Enabled = false;

            TXT_TAB = MEM.GET_MSX_MEMORY_16(0xF676);
            VAR_TAB = MEM.GET_MSX_MEMORY_16(0xF6C2); 
            ARY_TAB = MEM.GET_MSX_MEMORY_16(0xF6C4); 
            STR_END = MEM.GET_MSX_MEMORY_16(0xF6C6);

            BinaryWriter bw = new BinaryWriter(File.Open(FileName, FileMode.Create));

            bw.Write(Z80A.giGetLngToIntL(TXT_TAB));
            bw.Write(Z80A.giGetLngToIntH(TXT_TAB));
            bw.Write(Z80A.giGetLngToIntL(VAR_TAB));
            bw.Write(Z80A.giGetLngToIntH(VAR_TAB));
            bw.Write(Z80A.giGetLngToIntL(ARY_TAB));
            bw.Write(Z80A.giGetLngToIntH(ARY_TAB));
            bw.Write(Z80A.giGetLngToIntL(STR_END));
            bw.Write(Z80A.giGetLngToIntH(STR_END));

            for (ushort L = TXT_TAB; L <= (VAR_TAB - 1); L++)
            {
                bw.Write(MEM.GET_MSX_MEMORY(L));
            };

            bw.Close();

            CasWriteCmd.Enabled = true;
            this.Cursor = Cursors.Default;
        }

        private void CasHelpCmd_Click(object sender, EventArgs e)
        {
            CasFileTxt.Text = ShowFileOpenDialog();
            CasFileTxt.Focus();
        }

        private void CasEnterCmd_Click(object sender, EventArgs e)
        {
            string FileName;
            ushort TXT_TAB, VAR_TAB, ARY_TAB, STR_END;
            int RecordCount; 
            ushort StartNo = 0;
            byte B;

            SetEnterCmd.Focus();
              
            FDC.Gi_MSX_TAPE_Work = 0; //Tape Read 초기화

            FileName = FN.gsTrim(CasFileTxt.Text);
            if (FileName == "") goto ExitProc;
            if (FN.giInStr(1, FileName, "MSX-") == 0) goto ExitProc;

            this.Cursor = Cursors.WaitCursor;
            CasEnterCmd.Enabled = false;

            TXT_TAB = 0; VAR_TAB = 0; ARY_TAB = 0; STR_END = 0;
            BinaryReader br = new BinaryReader(new FileStream(FileName, FileMode.Open));
            RecordCount = 0;

            while (true)
            {
                try
                {
                    B = br.ReadByte();
                    if (RecordCount == 0) { TXT_TAB = (ushort)(TXT_TAB + B); };
                    if (RecordCount == 1) { TXT_TAB = (ushort)(TXT_TAB + (B * 256)); StartNo = TXT_TAB; };
                    if (RecordCount == 2) { VAR_TAB = (ushort)(VAR_TAB + B); };
                    if (RecordCount == 3) { VAR_TAB = (ushort)(VAR_TAB + (B * 256)); };
                    if (RecordCount == 4) { ARY_TAB = (ushort)(ARY_TAB + B); };
                    if (RecordCount == 5) { ARY_TAB = (ushort)(ARY_TAB + (B * 256)); };
                    if (RecordCount == 6) { STR_END = (ushort)(STR_END + B); };
                    if (RecordCount == 7) { STR_END = (ushort)(STR_END + (B * 256)); };
                    if (RecordCount >= 8) 
                    {
                        MEM.PUT_MSX_MEMORY(StartNo, B);
                        StartNo++;
                    };
                    RecordCount++;
                }
                catch (EndOfStreamException ex)
                {
                    string S = ex.ToString(); //미사용오류? 
                    br.Close();
                    break;
                };
            };

            MEM.PUT_MSX_MEMORY_16(0xF6C2, VAR_TAB);
            MEM.PUT_MSX_MEMORY_16(0xF6C4, VAR_TAB);
            MEM.PUT_MSX_MEMORY_16(0xF6C6, VAR_TAB);

            br.Close();

            CasEnterCmd.Enabled = true;
            this.Cursor = Cursors.Default;

        ExitProc: ;
        }

        private void RomHelpCmd_Click(object sender, EventArgs e)
        {
            RomFileTxt.Text = ShowFileOpenDialog();
            RomFileTxt.Focus();
        }

        private void RomEnterCmd_Click(object sender, EventArgs e)
        {
            string FileName;
            int RecordCount;
            int StartNo;
            byte B, B0 = 0, B1 = 0, B2 = 0, B3 = 0;

            SetEnterCmd.Focus();
  
            FileName = FN.gsTrim(RomFileTxt.Text);
            if (FileName == "") goto ExitProc;

            this.Cursor = Cursors.WaitCursor;
            RomEnterCmd.Enabled = false;

            MEM.Gi_Big32K_ROM = 0;
            long fl = new System.IO.FileInfo(FileName).Length;
            if (fl > 32768) MEM.Gi_Big32K_ROM = 1;
  
            BinaryReader br = new BinaryReader(new FileStream(FileName, FileMode.Open));
            StartNo = 0x4000;
            RecordCount = 0;

            while (true)
            {
                try
                {
                    B = br.ReadByte();
                    if (RecordCount == 0) B0 = MEM.MSX_MEM[1, StartNo];
                    if (RecordCount == 1) B1 = MEM.MSX_MEM[1, StartNo];
                    if (RecordCount == 2) B2 = MEM.MSX_MEM[1, StartNo];
                    if (RecordCount == 3) B3 = MEM.MSX_MEM[1, StartNo];
                    if (StartNo <= 49151) MEM.MSX_MEM[1, StartNo] = B; //Slot#1 MEM [4000~7FFF]
                    MEM.MSX_ROM[RecordCount] = B; //Mega ROM [0000~4MB]
                    if ((MEM.Gi_Big32K_ROM == 0) && (RecordCount == 3) && (B >= 0x80))
                    {
                        MEM.MSX_MEM[1, 0x8000] = MEM.MSX_MEM[1, 0x4000];
                        MEM.MSX_MEM[1, 0x8001] = MEM.MSX_MEM[1, 0x4001];
                        MEM.MSX_MEM[1, 0x8002] = MEM.MSX_MEM[1, 0x4002];
                        MEM.MSX_MEM[1, 0x8003] = MEM.MSX_MEM[1, 0x4003];
                        MEM.MSX_MEM[1, 0x4000] = B0;
                        MEM.MSX_MEM[1, 0x4001] = B1;
                        MEM.MSX_MEM[1, 0x4002] = B2;
                        MEM.MSX_MEM[1, 0x4003] = B3;
                        StartNo = (ushort)(StartNo + 0x4000); //8000~
                    };
                    StartNo++;
                    RecordCount++;
                }
                catch (EndOfStreamException ex)
                {
                    string S = ex.ToString(); //미사용오류? 
                    br.Close();
                    break;
                };
            };

            br.Close();
  
            RomEnterCmd.Enabled = true;
            this.Cursor = Cursors.Default;

        ExitProc: ;
        }

        private void DskAHelpCmd_Click(object sender, EventArgs e)
        {
            DskAFileTxt.Text = ShowFileOpenDialog();
            DskAFileTxt.Focus();
        }

        private void DskBHelpCmd_Click(object sender, EventArgs e)
        {
            DskBFileTxt.Text = ShowFileOpenDialog();
            DskBFileTxt.Focus();
        }

        private void TimerTxt_Leave(object sender, EventArgs e)
        {
            int iVal;

            iVal = FN.giVal(FN.gsRight(FN.gsTrim(TimerTxt.Text), 5));
            if ((iVal < 10) || (iVal > 100)) iVal = 0;
            TimerTxt.Text = FN.gsCStr(iVal, 0);
            if (iVal == 0) TimerTxt.Text = "";
        }

        public string ShowFileOpenDialog()
        {
            string R;

            R = "";
            OpenFileDialog sDir = new OpenFileDialog();

            sDir.Title = "열기";
            sDir.FileName = "";
            sDir.Filter = "모든 파일 (*.*)|*.*|CAS 파일|*.CAS|ROM 파일|*.ROM|DISK 파일|*.DSK";

            DialogResult sFile = sDir.ShowDialog();

            if (sFile == DialogResult.OK)
            {
                string fileName = sDir.SafeFileName;
                string fileFullName = sDir.FileName;
                string filePath = fileFullName.Replace(fileName, "");
                R = fileFullName;
            }
            else
                if (sFile == DialogResult.Cancel)
                {
                    R = "";
                };

            return R;
        }

        void WRITE_MSX_SETTING()
        {
            if (MsxSelt0Opt.Checked == true) { MSX.Gi_MSX2_Sets = 0; } else { MSX.Gi_MSX2_Sets = 1; };
            if (DiskSelt0Opt.Checked == true) { MSX.Gi_DISK_Sets = 0; } else { MSX.Gi_DISK_Sets = 1; };
            if (FontSelt0Opt.Checked == true) { MSX.Gi_CHAR_Sets = 0; } else { MSX.Gi_CHAR_Sets = 1; };
            MSX.Gi_SC2X_Sets = (sbyte)(Scale2xChk.Checked == false ? 0 : 1);

            MSX.Gi_MSX_Int_Timer = (sbyte)FN.giVal(FN.gsRight(FN.gsTrim(TimerTxt.Text), 5));
            if ((MSX.Gi_MSX_Int_Timer < 10) || (MSX.Gi_MSX_Int_Timer > 100)) MSX.Gi_MSX_Int_Timer = 0;
            MSX.Gi_MSX_DisplayFrame = 0;
            if (DspFrame0Opt.Checked == true) MSX.Gi_MSX_DisplayFrame = 0;
            if (DspFrame1Opt.Checked == true) MSX.Gi_MSX_DisplayFrame = 1;
            if (DspFrame2Opt.Checked == true) MSX.Gi_MSX_DisplayFrame = 2;
            if (DspFrame3Opt.Checked == true) MSX.Gi_MSX_DisplayFrame = 3;

            MSX.Gi_MSX_InterruptDup = (sbyte)(IntDupeChk.Checked == false ? 0 : 1);
            MSX.Gi_MSX_Auto_Speed = (sbyte)(AutoSpeedChk.Checked == false ? 0 : 1);
            MSX.Gi_MSX_KeyChange = (sbyte)(KeyChangeChk.Checked == false ? 0 : 1);
            MSX.Gi_MSX_JoyOn = (sbyte)(JoyStickChk.Checked == false ? 0 : 1);
            MSX.Gi_MSX_SpaceOn = (sbyte)(SpaceOnChk.Checked == false ? 0 : 1);
            MSX.Gi_MSX_VDT_ST_FF = (sbyte)(VdtStFfChk.Checked == false ? 0 : 1);

            MSX.Gs_CAS_FILE = FN.gsTrim(FN.gsLeft(CasFileTxt.Text, 100));
            MSX.Gs_ROM_FILE = FN.gsTrim(FN.gsLeft(RomFileTxt.Text, 100));
            MSX.Gi_ROM_TYPE = 0;
            if (RomSelt0Opt.Checked == true) MSX.Gi_ROM_TYPE = 0;
            if (RomSelt1Opt.Checked == true) MSX.Gi_ROM_TYPE = 1;
            if (RomSelt2Opt.Checked == true) MSX.Gi_ROM_TYPE = 2;
            if (RomSelt3Opt.Checked == true) MSX.Gi_ROM_TYPE = 3;
            if (RomSelt4Opt.Checked == true) MSX.Gi_ROM_TYPE = 4;
            if (RomSelt5Opt.Checked == true) MSX.Gi_ROM_TYPE = 5;
            MSX.Gs_DSK_A_FILE = FN.gsTrim(FN.gsLeft(DskAFileTxt.Text, 100));
            MSX.Gs_DSK_B_FILE = FN.gsTrim(FN.gsLeft(DskBFileTxt.Text, 100));
            MSX.Gi_DSK_A_ON = (sbyte)(DskAOnChk.Checked == false ? 0 : 1);
            MSX.Gi_DSK_B_ON = (sbyte)(DskBOnChk.Checked == false ? 0 : 1);
            if (MSX.Gs_DSK_A_FILE == "") MSX.Gi_DSK_A_ON = 0;
            if (MSX.Gs_DSK_B_FILE == "") MSX.Gi_DSK_B_ON = 0;

            REG.giUpdateRegistry("MSX_Machine", MSX.Gi_MSX2_Sets);
            REG.giUpdateRegistry("MSX_DiskRom", MSX.Gi_DISK_Sets);
            REG.giUpdateRegistry("MSX_CharFont", MSX.Gi_CHAR_Sets);
            REG.giUpdateRegistry("MSX_Scale2x", MSX.Gi_SC2X_Sets);

            REG.giUpdateRegistry("MSX_IntTimer", MSX.Gi_MSX_Int_Timer);
            REG.giUpdateRegistry("MSX_DisplayFrame", MSX.Gi_MSX_DisplayFrame);

            REG.giUpdateRegistry("MSX_InterruptDup", MSX.Gi_MSX_InterruptDup);
            REG.giUpdateRegistry("MSX_AutoSpeed", MSX.Gi_MSX_Auto_Speed);
            REG.giUpdateRegistry("MSX_KeyChange", MSX.Gi_MSX_KeyChange);
            REG.giUpdateRegistry("MSX_JoyOn", MSX.Gi_MSX_JoyOn);
            REG.giUpdateRegistry("MSX_SpaceOn", MSX.Gi_MSX_SpaceOn);
            REG.giUpdateRegistry("MSX_VdtStFf", MSX.Gi_MSX_VDT_ST_FF);

            REG.gsUpdateRegistry("MSX_CasFile", MSX.Gs_CAS_FILE);
            REG.gsUpdateRegistry("MSX_RomFile", MSX.Gs_ROM_FILE);
            REG.giUpdateRegistry("MSX_RomType", MSX.Gi_ROM_TYPE);
            REG.gsUpdateRegistry("MSX_DiskAFile", MSX.Gs_DSK_A_FILE);
            REG.gsUpdateRegistry("MSX_DiskBFile", MSX.Gs_DSK_B_FILE);
        }
    }
}
