﻿namespace csMSX2
{
    public static class REG
    {
        public static int giGetRegistry(string RegKey)
        {
            return FN.giVal(GetSetting("csMSX", "Setting", RegKey, ""));
        }

        public static string gsGetRegistry(string RegKey)
        {
            return FN.gsTrim(GetSetting("csMSX", "Setting", RegKey, ""));
        }

        public static void giUpdateRegistry(string RegKey, int RegVal)
        {
            SaveSetting("csMSX", "Setting", RegKey, FN.gsCStr(RegVal, 0));
        }

        public static void gsUpdateRegistry(string RegKey, string RegVal)
        {
            SaveSetting("csMSX", "Setting", RegKey, RegVal);
        }

        public static string GetSetting(string appName, string section, string key, string sDefault) 
        { 
            string sKeyValue = string.Empty; 

            if (appName.Length != 0) 
            { 
                sKeyValue = @"SOFTWARE\VB and VBA Program Settings\" + appName + @"\" + section; 
            } 
            else 
            {
                sKeyValue = @"SOFTWARE\VB and VBA Program Settings\" + section;
            }; 
            Microsoft.Win32.RegistryKey rKey = Microsoft.Win32.Registry.CurrentUser.OpenSubKey(sKeyValue, true); 
            if (rKey != null) 
            { 
                if (rKey.GetValue(key) != null) 
                { 
                    return rKey.GetValue(key).ToString(); 
                } 
                else 
                { 
                    return sDefault;
                };
            }; 
            return sDefault; 
        }

        public static void SaveSetting(string appName, string section, string key, string setting) 
        { 
            string sKeyValue = string.Empty; 

            if (appName.Length != 0) 
            {
                sKeyValue = @"SOFTWARE\VB and VBA Program Settings\" + appName + @"\" + section; 
            } 
            else 
            {
                sKeyValue = @"SOFTWARE\VB and VBA Program Settings\" + section;
            }; 
            Microsoft.Win32.RegistryKey rKey = Microsoft.Win32.Registry.CurrentUser.OpenSubKey(sKeyValue, true); 
            if (rKey == null) 
            { 
                rKey = Microsoft.Win32.Registry.CurrentUser.CreateSubKey(sKeyValue); 
                rKey.SetValue(key, setting); 
            } 
            else 
            { 
                rKey.SetValue(key, setting);
            }; 
        }
    }
}
