﻿//*******************************************************************************
//*                                                                             *
//* 제    목 : MSX                                                              *
//*                                                                             *
//* 개발환경 : Ms Windows 2003, Visual Studio 2008 Sp1 [C#]                     *
//* 회    사 : 명도전산(MdoSoft,MdoSystem)                                      *
//* 작 성 자 : 지익훈(智翼焄), mdo1993@hanmail.net                              *
//* 작성일자 : 2018년 05월 24일                                                 *
//* 최종수정 : 2018년 07월 16일                                                 *
//*                                                                             *
//*******************************************************************************

using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.IO;
using System.Windows.Forms;

namespace csMSX2
{
    public partial class csMSX2Frm : Form
    {
        int fi_TimerCpuInterval; //1000=1초, 16.66=1초에60번

      //타이머(딜레이용-AutoSpeed)
        double fo_Exec_Time;
        double fo_ST_Timer;
        double fo_ED_Timer;

        sbyte fi_MSX_SCREEN_MODE_Bak;

        public csMSX2Frm()
        {
            InitializeComponent();
        }

        private void csMSX2Frm_Load(object sender, EventArgs e)
        {
            MSX.GiMENU = 0; //0:[초기],1:시작,2:중지

            READ_MSX_SETTING();
            SETS_MSX_SETTING();

            IO.Gi_MSX_PortWrite = 0; //1:Port Write [Test용]

            FDC.Gs_DSK_A_FILE_Bak = "";
            FDC.Gs_DSK_B_FILE_Bak = "";
        
            FDC.Gi_MSX_DISK_A_Run = 0;
            FDC.Gi_MSX_DISK_B_Run = 0;

            MSX.Gi_MSX_Execute = 0; //0:중지,1:실행중
            MSX.Gi_MSX_GotFocus = 0; //0:없음,1:포커스
            DisplayExecuteState();
            ScreenModeLbl.Text = "";
            fi_MSX_SCREEN_MODE_Bak = -1;

            MSX.MSX_INIT();

          //EI상테에서 IM1일경우 0038h 1초에 60번 발생
            MSX.Gi_MSX_Timer_60_INT = 0; //1초60번확인(INT)
            fi_TimerCpuInterval = (MSX.Gi_MSX_Int_Timer == 0 ? 16 : MSX.Gi_MSX_Int_Timer); //1000=1초, 16.66=1초에60번
            timer1.Interval = fi_TimerCpuInterval;
            timer1.Enabled = true;

          //사운드재생용
            timer2.Interval = 50; //1초에20번
            timer2.Enabled = true;

          //화면표시용
            MSX.Gi_MSX_Timer_16_VDP = 0;
            if (MSX.Gi_MSX_DisplayFrame == 0) timer3.Interval = 16; //1초에60번
            if (MSX.Gi_MSX_DisplayFrame == 1) timer3.Interval = 33; //1초에30번
            if (MSX.Gi_MSX_DisplayFrame == 2) timer3.Interval = 45; //1초에22번
            if (MSX.Gi_MSX_DisplayFrame == 3) timer3.Interval = 62; //1초에16번
            timer3.Enabled = true;

            PSGOUT.Gb_MidiOpened = false;
            PSGOUT.gt_MSX_Midi_Open();

            ToolTip ToolTip1 = new ToolTip();
            ToolTip1.ShowAlways = true;
            ToolTip1.IsBalloon = true;
            ToolTip1.AutoPopDelay = 0;
            ToolTip1.InitialDelay = 0;
            ToolTip1.ReshowDelay = 500;
            ToolTip1.SetToolTip(DiskABtn, "Disk#A동작상태, 현재상태저장하기([중지]버튼후)");
            ToolTip1.SetToolTip(DiskBBtn, "Disk#B동작상태, 현재상태불러오기(시작시,[초기]버튼후)");
            
            MSX.Gi_TEST = 0; //1:Test
            MSX.TEST_0_oAddr = 0;
            MSX.TEST_0_iVal = 0;
            MSX.TEST_1_oAddr = 0;
            MSX.TEST_1_iVal = 0;
            MSX.TEST_2_oAddr = 0;
            MSX.TEST_2_iVal = 0;
            MSX.TEST_3_oAddr = 0;
            MSX.TEST_3_iVal = 0;
        }

        private void csMSX2Frm_FormClosed(object sender, FormClosedEventArgs e)
        {
            if (PSGOUT.Gb_MidiOpened == true) PSGOUT.gt_MSX_Midi_Close();
        }

        private void StartBtn_Click(object sender, EventArgs e)
        {
            byte iSz;
  
          //========== TEST ==========
          //long foCounter;
          //MSX.Gi_TEST = 1; //1:Test
          //foCounter = 0;
          //FileStream fs = new FileStream("C:\\csMSX2.Txt", FileMode.Append, FileAccess.Write);
          //StreamWriter sw = new StreamWriter(fs, Encoding.UTF8);
          //========== ==== ==========
  
            MSX.Gi_MSX_GotFocus = 0;
            if (MSX.Gi_MSX_Execute == 1)
            {
                DisplayExecuteState();
                goto ExitProc;
            };

            MSX.GiMENU = 1; //0:초기,1:[시작],2:중지

            MSX.Gi_MSX_Execute = 1;
            DisplayExecuteState();

            fo_ST_Timer = Microsoft.VisualBasic.DateAndTime.Timer; //시작시간확인 ?????.??초
            fo_Exec_Time = 0;
            INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //직전명령이EI일경우(일정갯수명령실행까지인터럽트금지)

        LoopProc: ;
            if ((INT.Go_MSX_InterruptBack == Z80A.Z80A_REG_PC) && (INT.Go_MSX_InterruptBack != 0)) INT.Gi_MSX_Interrupt = 0; //인터럽트종료 [초기값(-1)불가]
  
          //Tape I/O
            if (MEM.Gi_MEM_PAGE0 == 0) //Page#0->Slot#0
            {
                if (Z80A.Z80A_REG_PC == 0xE1) FDC.MSX_TAPE_BIOS_TAPION();
                if (Z80A.Z80A_REG_PC == 0xE4) FDC.MSX_TAPE_BIOS_TAPIN();
                if (Z80A.Z80A_REG_PC == 0xE7) FDC.MSX_TAPE_BIOS_TAPIOF();
                if (Z80A.Z80A_REG_PC == 0xEA) FDC.MSX_TAPE_BIOS_TAPOON();
                if (Z80A.Z80A_REG_PC == 0xED) FDC.MSX_TAPE_BIOS_TAPOUT();
                if (Z80A.Z80A_REG_PC == 0xF0) FDC.MSX_TAPE_BIOS_TAPOOF();
                if (Z80A.Z80A_REG_PC == 0xF3) FDC.MSX_TAPE_BIOS_STMOTR();
            };

          //Disk I/O
            if (MEM.Gi_MEM_PAGE1 == 3) //Page#1->Slot#3
            {
                if (Z80A.Z80A_REG_PC == 0x4010) FDC.MSX_DISK_BIOS_DSKIO();  //Read/Write sectors from disk
                if (Z80A.Z80A_REG_PC == 0x4013) FDC.MSX_DISK_BIOS_DSKCHG(); //Check disk change status
                if (Z80A.Z80A_REG_PC == 0x4016) FDC.MSX_DISK_BIOS_GETDPB(); //GETDPB: Disk format
                if (Z80A.Z80A_REG_PC == 0x401C) FDC.MSX_DISK_BIOS_DSKFMT(); //Format disk
            };

            MI.EXEC_Z80A_CODE(); //Z80A 명령 실행

            MSX_REG_DISPLAY();
            Application.DoEvents();         
            if (MSX.Gi_MSX_Auto_Speed == 1) MSX_AUTO_SPEED();

            if (MSX.Gi_MSX_Execute == 0) goto ExitProc; //계속실행 아니면 종료

          //========== TEST ==========
          //foCounter++;
          //sw.WriteLine(FN.gsCStr((int)foCounter, 0) + ", " + FN.gsHex(Z80A.Z80A_REG_PC, 4) + ", " + FN.gsHex(Z80A.GET_Z80A_REG_AF(), 4) + ", " + FN.gsHex(Z80A.GET_Z80A_REG_BC(), 4) + ", " + FN.gsHex(Z80A.GET_Z80A_REG_DE(), 4) + ", " + FN.gsHex(Z80A.GET_Z80A_REG_HL(), 4) + ", " + FN.gsHex(Z80A.Z80A_REG_IX, 4) + ", " + FN.gsHex(Z80A.Z80A_REG_IY, 4) + "/ " + FN.gsHex(MSX.TEST_0_oAddr, 4) + ", " + FN.gsCStr(MSX.TEST_0_iVal, 0) + ", " + FN.gsHex(MSX.TEST_1_oAddr, 4) + ", " + FN.gsCStr(MSX.TEST_1_iVal, 0) + "/ " + FN.gsHex(MSX.TEST_2_oAddr, 4) + ", " + FN.gsCStr(MSX.TEST_2_iVal, 0) + ", " + FN.gsHex(MSX.TEST_3_oAddr, 4) + ", " + FN.gsCStr(MSX.TEST_3_iVal, 0));
          //sw.WriteLine(FN.gsCStr((int)foCounter, 0) + ", " + FN.gsHex(Z80A.Z80A_REG_PC, 4) + "/ " + FN.gsCStr((int)VDT.Gi_MSX_VRAM_IO, 0) + "," + FN.gsCStr((int)VDT.Go_MSX_VRAM_ADDRESS, 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[0], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[1], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[2], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[3], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[4], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[5], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[6], 0) + "," + FN.gsCStr((int)VDT.MSX_VDT_REG[7], 0) + "/ " + FN.gsCStr((int)PSG.Go_MSX_PSG_TONE_A, 0) + "," + FN.gsCStr((int)PSG.Go_MSX_PSG_TONE_B, 0) + "," + FN.gsCStr((int)PSG.Go_MSX_PSG_TONE_C, 0) + "," + FN.gsCStr((int)PSG.Go_MSX_PSG_NOISE, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_N_ON_C, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_N_ON_B, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_N_ON_A, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_T_ON_C, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_T_ON_B, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_T_ON_A, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_VEV_A, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_VOL_A, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_VEV_B, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_VOL_B, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_VEV_C, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_VOL_C, 0) + "," + FN.gsCStr((int)PSG.Go_MSX_PSG_TONE_EV, 0) + "," + FN.gsCStr((int)PSG.Gi_MSX_PSG_PATN_EV, 0));
          //goto LoopProc; //테스트후삭제요망
          //sw.Close();
          //fs.Close();
          //========== ==== ==========

            if (INT.Gi_Z80A_EI_Chk > 0) //EI 바로 다음은 인터럽트 금지
            {
                INT.Gi_Z80A_EI_Chk--;
                goto LoopProc;
            };
 
          //BIOS 인터럽트 금지 (Front Line)
          //if (MSX.Gi_MSX_InterruptBios == 1)
          //{
          //    if ((Z80A.Z80A_REG_PC >= 0x0000) && (Z80A.Z80A_REG_PC <= 0x3FFF)) goto LoopProc;
          //};

          //인터럽트 - 1초에60번수행, IM1에서0038H호출, EI 다음명령 후 에 실행됨
            if ((Z80A.Z80A_REG_IFF1 == 1) && (INT.Z80A_INT_MODE == 1) && (MSX.Gi_MSX_Timer_60_INT == 1))
            {
                INT.Z80A_HALT = 1;
                if ((MSX.Gi_MSX_InterruptDup == 1) || (INT.Gi_MSX_Interrupt == 0)) //0:금지,1:인터럽트중복허용(컴퓨터속도느릴경우스텍오버플로워폭주됨)
                {
                    INT.Gi_MSX_Interrupt = 1; //인터럽트시작
                    MSX.Gi_MSX_Timer_60_INT = 0;
                    
                    iSz = 1;
                    INT.Go_MSX_InterruptBack = Z80A.Z80A_REG_PC;
                    Z80A.gt_PUSH_16(Z80A.Z80A_REG_PC);
                    Z80A.Z80A_REG_PC = 0x38; //0038h
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1

                    if (MSX.Gi_MSX_Execute == 0) goto ExitProc; //계속실행 아니면 종료

                    MSX_REG_DISPLAY();
                    Application.DoEvents();
                    if (MSX.Gi_MSX_Auto_Speed == 1) MSX_AUTO_SPEED();
                };
            };

            goto LoopProc;

        ExitProc: ;
        }

        void MSX_AUTO_SPEED()
        {
          //Clock 3.57954MHz, 1 Cycle 279n * (명령State+OP코드바이트수)
          //1m(밀리)=1/1000, 1u(마이크로)=1/1000000, 1n(나노)=1/1000000000
            double oCpuTime, oPrgTime;

            oCpuTime = (MSX.Gi_Z80A_ClockSize * 279) / 1000; //u=1/1,000n
            fo_Exec_Time = fo_Exec_Time + oCpuTime;

            if (fo_Exec_Time < 10000) goto ExitProc; //1/100초(Z80A실행시간) 지날때까지 대기

        LoopProc: ;
          //Application.DoEvents();
            fo_ED_Timer = Microsoft.VisualBasic.DateAndTime.Timer; //종료시간확인, ?????.??초
            if (fo_ED_Timer < fo_ST_Timer) fo_ST_Timer = fo_ED_Timer; //일자변경됨
            oPrgTime = fo_ED_Timer - fo_ST_Timer;
            if (oPrgTime < 0.01) goto LoopProc; //1/100초(컴퓨터시간) 지날때까지대기

            fo_ST_Timer = Microsoft.VisualBasic.DateAndTime.Timer; //시작시간확인
            fo_Exec_Time = 0;

        ExitProc: ;
        }

        private void StopBtn_Click(object sender, EventArgs e)
        {
            MSX.Gi_MSX_GotFocus = 0;
            if (MSX.Gi_MSX_Execute != 1) goto LastProc;
            MSX.Gi_MSX_Execute = 0;

            MSX.GiMENU = 2; //0:초기,1:시작,2:[중지]

        LastProc: ;
            DisplayExecuteState();
        }

        private void ClearBtn_Click(object sender, EventArgs e)
        {
            MSX.Gi_MSX_GotFocus = 0;
            if (MSX.Gi_MSX_Execute == 0)
            {
                MSX.GiMENU = 0; //0:[초기],1:시작,2:중지
                SETS_MSX_SETTING();
                MSX.MSX_INIT();
            };
            DisplayExecuteState();

            ScreenModeLbl.Text = "";
            fi_MSX_SCREEN_MODE_Bak = -1;
        }

        private void SetsBtn_Click(object sender, EventArgs e)
        {
            sbyte bFocus;

            bFocus = MSX.Gi_MSX_GotFocus;

            MSX.Gi_MSX_GotFocus = 0;
            DisplayExecuteState();

            SetsFrm Frm = new SetsFrm();
            Frm.ShowDialog();

            MSX.Gi_MSX_GotFocus = bFocus;
            DisplayExecuteState();

            fi_TimerCpuInterval = (MSX.Gi_MSX_Int_Timer == 0 ? 16 : MSX.Gi_MSX_Int_Timer); //1000=1초, 16.66=1초에60번
            timer1.Interval = fi_TimerCpuInterval;
            if (MSX.Gi_MSX_DisplayFrame == 0) timer3.Interval = 16; //1초에60번
            if (MSX.Gi_MSX_DisplayFrame == 1) timer3.Interval = 33; //1초에30번
            if (MSX.Gi_MSX_DisplayFrame == 2) timer3.Interval = 45; //1초에22번
            if (MSX.Gi_MSX_DisplayFrame == 3) timer3.Interval = 62; //1초에16번
        }

        private void DiskABtn_Click(object sender, EventArgs e)
        {
            MSX.Gi_MSX_GotFocus = 0;
            DisplayExecuteState();
            if (MSX.GiMENU != 2) goto LastProc; //0:초기,1:시작,2:[중지]

            ScrnMSX.Focus(); 
            this.Cursor = Cursors.WaitCursor;
            DiskABtn.Enabled = false;

            MSL.MsxSaveStatus();

            DiskABtn.Enabled = true;
            this.Cursor = Cursors.Default;

        LastProc: ;
        }

        private void DiskBBtn_Click(object sender, EventArgs e)
        {
            string MsxFile;

            MSX.Gi_MSX_GotFocus = 0;
            DisplayExecuteState();
            if (MSX.GiMENU != 0) goto LastProc; //0:[초기],1:시작,2:중지

            MsxFile = MSX.gsGetMsxFileName(FN.gsTrim(ShowFileOpenDialog()));
            if (MsxFile == "") goto LastProc;

            ScrnMSX.Focus();
            this.Cursor = Cursors.WaitCursor;
            DiskBBtn.Enabled = false;

            MSL.MsxLoadStatus(MsxFile);

            DiskBBtn.Enabled = true;
            this.Cursor = Cursors.Default;

            ScreenModeLbl.Text = "";
            fi_MSX_SCREEN_MODE_Bak = -1;

        LastProc: ;
        }

        private void ExitBtn_Click(object sender, EventArgs e)
        {
            MSX.Gi_MSX_GotFocus = 0;
            DisplayExecuteState();

            MSX.Gi_MSX_Execute = 0; //중지

            this.Close();
        }

        private void ScrnMSX_Click(object sender, EventArgs e)
        {
            MSX.Gi_MSX_GotFocus = 1;
            DisplayExecuteState();
            ScrnMSX.Focus(); 
        }

        void DisplayExecuteState()
        {
            if (MSX.Gi_MSX_Execute == 0)
            {
                MsxExecLbl.Text = "";
            }
            else
            {
                MsxExecLbl.Text = "실행중";
            };
            if (MSX.Gi_MSX_GotFocus == 0)
            {
                MsxExecLbl.ForeColor = System.Drawing.Color.Black;
            }
            else
            {
                MsxExecLbl.ForeColor = System.Drawing.Color.Red;
            };
        }

        private void timer1_Tick(object sender, EventArgs e)
        {
          //CPU Interrupt
            MSX.Gi_MSX_Timer_60_INT = 1;
        }

        private void timer2_Tick(object sender, EventArgs e)
        {
          //사운드재생용
            if (MSX.Gi_MSX_Execute == 1) //실행중
            {
                PSGOUT.MSX_PSG_TONE_OUT_A(PSG.Gi_MSX_PSG_T_ON_A);
                PSGOUT.MSX_PSG_TONE_OUT_B(PSG.Gi_MSX_PSG_T_ON_B);
                PSGOUT.MSX_PSG_TONE_OUT_C(PSG.Gi_MSX_PSG_T_ON_C);
                PSGOUT.MSX_PSG_NOISE_OUT_A(PSG.Gi_MSX_PSG_N_ON_A);
                PSGOUT.MSX_PSG_NOISE_OUT_B(PSG.Gi_MSX_PSG_N_ON_B);
                PSGOUT.MSX_PSG_NOISE_OUT_C(PSG.Gi_MSX_PSG_N_ON_C);
            }
            else //중지
            {
                PSGOUT.MSX_PSG_TONE_OUT_A(1);
                PSGOUT.MSX_PSG_TONE_OUT_B(1);
                PSGOUT.MSX_PSG_TONE_OUT_C(1);
                PSGOUT.MSX_PSG_NOISE_OUT_A(1);
                PSGOUT.MSX_PSG_NOISE_OUT_B(1);
                PSGOUT.MSX_PSG_NOISE_OUT_C(1);
            };
 
          //Disk 구동 표시용
            if (FDC.Gi_MSX_DISK_A_Run > 0)
            {
                DiskABtn.BackColor = Color.FromArgb(192, 255, 255);
                FDC.Gi_MSX_DISK_A_Run--;
                if (FDC.Gi_MSX_DISK_A_Run == 0) DiskABtn.BackColor = Color.FromArgb(224, 224, 224);
            };
            if (FDC.Gi_MSX_DISK_B_Run > 0)
            {
                DiskBBtn.BackColor = Color.FromArgb(192, 255, 255);
                FDC.Gi_MSX_DISK_B_Run--;
                if (FDC.Gi_MSX_DISK_B_Run == 0) DiskBBtn.BackColor = Color.FromArgb(224, 224, 224);
            };
        }

        private void timer3_Tick(object sender, EventArgs e)
        {
          //화면표시용
            MSX.Gi_MSX_Timer_16_VDP = 1;
            if ((MSX.Gi_MSX_Execute == 1) && (VDT.Gi_MSX_SCREEN_MODE != fi_MSX_SCREEN_MODE_Bak)) //실행중
            {
                ScreenModeLbl.Text = "SC " + (VDT.Gi_MSX_SCREEN_MODE != 10 ? FN.gsCStr(VDT.Gi_MSX_SCREEN_MODE, 0) : "0+");
                fi_MSX_SCREEN_MODE_Bak = VDT.Gi_MSX_SCREEN_MODE; 
            };

            VDTOUT.MSX_SCREEN_DISP();
        }

        public string ShowFileOpenDialog()
        {
            string R;

            R = "";
            OpenFileDialog sDir = new OpenFileDialog();

            sDir.Title = "열기";
            sDir.FileName = "";
            sDir.Filter = "모든 파일 (*.*)|*.*|MSX 파일|*.MSX";

            DialogResult sFile = sDir.ShowDialog();

            if (sFile == DialogResult.OK)
            {
                string fileName = sDir.SafeFileName;
                string fileFullName = sDir.FileName;
                string filePath = fileFullName.Replace(fileName, "");
                R = fileFullName;
            }
            else
                if (sFile == DialogResult.Cancel)
                {
                    R = "";
                };

            return R;
        }

        void READ_MSX_SETTING()
        {
            MSX.Gi_MSX2_Sets = (sbyte)REG.giGetRegistry("MSX_Machine");
            MSX.Gi_DISK_Sets = (sbyte)REG.giGetRegistry("MSX_DiskRom");
            MSX.Gi_CHAR_Sets = (sbyte)REG.giGetRegistry("MSX_CharFont");
            MSX.Gi_SC2X_Sets = (sbyte)REG.giGetRegistry("MSX_Scale2x");

            MSX.Gi_MSX_Int_Timer = (sbyte)REG.giGetRegistry("MSX_IntTimer");
            MSX.Gi_MSX_DisplayFrame = (sbyte)REG.giGetRegistry("MSX_DisplayFrame");

            MSX.Gi_MSX_InterruptDup = (sbyte)REG.giGetRegistry("MSX_InterruptDup");
            MSX.Gi_MSX_Auto_Speed = (sbyte)REG.giGetRegistry("MSX_AutoSpeed");
            MSX.Gi_MSX_KeyChange = (sbyte)REG.giGetRegistry("MSX_KeyChange");
            MSX.Gi_MSX_JoyOn = (sbyte)REG.giGetRegistry("MSX_JoyOn");
            MSX.Gi_MSX_SpaceOn = (sbyte)REG.giGetRegistry("MSX_SpaceOn");
            MSX.Gi_MSX_VDT_ST_FF = (sbyte)REG.giGetRegistry("MSX_VdtStFf");

            MSX.Gs_CAS_FILE = MSX.gsGetCasFileName(REG.gsGetRegistry("MSX_CasFile"));
            MSX.Gs_ROM_FILE = MSX.gsGetRomFileName(REG.gsGetRegistry("MSX_RomFile"));
            MSX.Gi_ROM_TYPE = (sbyte)REG.giGetRegistry("MSX_RomType");
            MSX.Gs_DSK_A_FILE = MSX.gsGetDskFileName(REG.gsGetRegistry("MSX_DiskAFile"));
            MSX.Gs_DSK_B_FILE = MSX.gsGetDskFileName(REG.gsGetRegistry("MSX_DiskBFile"));
            MSX.Gi_DSK_A_ON = 0;
            MSX.Gi_DSK_B_ON = 0;

            if ((MSX.Gi_MSX2_Sets < 0) || (MSX.Gi_MSX2_Sets > 1)) MSX.Gi_MSX2_Sets = 0;
            if ((MSX.Gi_DISK_Sets < 0) || (MSX.Gi_DISK_Sets > 1)) MSX.Gi_DISK_Sets = 0;
            if ((MSX.Gi_CHAR_Sets < 0) || (MSX.Gi_CHAR_Sets > 1)) MSX.Gi_CHAR_Sets = 0;
            if ((MSX.Gi_SC2X_Sets < 0) || (MSX.Gi_SC2X_Sets > 1)) MSX.Gi_SC2X_Sets = 0;
            if ((MSX.Gi_MSX_Int_Timer < 10) || (MSX.Gi_MSX_Int_Timer > 100)) MSX.Gi_MSX_Int_Timer = 0;
            if ((MSX.Gi_MSX_DisplayFrame < 0) || (MSX.Gi_MSX_DisplayFrame > 3)) MSX.Gi_MSX_DisplayFrame = 0;
            if ((MSX.Gi_MSX_InterruptDup < 0) || (MSX.Gi_MSX_InterruptDup > 1)) MSX.Gi_MSX_InterruptDup = 0;
            if ((MSX.Gi_MSX_Auto_Speed < 0) || (MSX.Gi_MSX_Auto_Speed > 1)) MSX.Gi_MSX_Auto_Speed = 0;
            if ((MSX.Gi_MSX_KeyChange < 0) || (MSX.Gi_MSX_KeyChange > 1)) MSX.Gi_MSX_KeyChange = 0;
            if ((MSX.Gi_MSX_JoyOn < 0) || (MSX.Gi_MSX_JoyOn > 1)) MSX.Gi_MSX_JoyOn = 0;
            if ((MSX.Gi_MSX_SpaceOn < 0) || (MSX.Gi_MSX_SpaceOn > 1)) MSX.Gi_MSX_SpaceOn = 0;
            if ((MSX.Gi_MSX_VDT_ST_FF < 0) || (MSX.Gi_MSX_VDT_ST_FF > 1)) MSX.Gi_MSX_VDT_ST_FF = 0;
            if ((MSX.Gi_ROM_TYPE < 0) || (MSX.Gi_ROM_TYPE > 5)) MSX.Gi_ROM_TYPE = 0;
            if ((MSX.Gi_DSK_A_ON < 0) || (MSX.Gi_DSK_A_ON > 1)) MSX.Gi_DSK_A_ON = 0;
            if ((MSX.Gi_DSK_B_ON < 0) || (MSX.Gi_DSK_B_ON > 1)) MSX.Gi_DSK_B_ON = 0;   
        }

        void SETS_MSX_SETTING()
        {
            MSX.GiMSX2 = MSX.Gi_MSX2_Sets;
            MSX.GiDISK = MSX.Gi_DISK_Sets;
            MSX.GiCHAR = MSX.Gi_CHAR_Sets;
            MSX.GiSC2X = MSX.Gi_SC2X_Sets;
        }

        void MSX_REG_DISPLAY()
        {
          //PCLbl.Text = FN.gsHex(Z80A.Z80A_REG_PC, 4);
          //SPLbl.Text = FN.gsHex(Z80A.Z80A_REG_SP, 4);

          //AFLbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_AF(), 4);
          //BCLbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_BC(), 4);
          //DELbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_DE(), 4);
          //HLLbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_HL(), 4);

          //AF2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_AF2(), 4);
          //BC2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_BC2(), 4);
          //DE2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_DE2(), 4);
          //HL2Lbl.Text = FN.gsHex(Z80A.GET_Z80A_REG_HL2(), 4);

          //IXLbl.Text = FN.gsHex(Z80A.Z80A_REG_IX, 4);
          //IYLbl.Text = FN.gsHex(Z80A.Z80A_REG_IY, 4);

          //SLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_S(), 0);
          //ZLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_Z(), 0);
          //YLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_Y(), 0);
          //HLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_H(), 0);
          //XLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_X(), 0);
          //PLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_PV(), 0);
          //NLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_N(), 0);
          //CLbl.Text = FN.gsCStr(Z80A.GET_Z80A_FLAG_C(), 0);

          //ILbl.Text = FN.gsHex(Z80A.Z80A_REG_I, 2);
          //RLbl.Text = FN.gsHex(Z80A.Z80A_REG_R, 2);
          //IMLbl.Text = FN.gsCStr(INT.Z80A_INT_MODE, 0);
          //IF1Lbl.Text = FN.gsCStr(Z80A.Z80A_REG_IFF1, 0);
          //IF2Lbl.Text = FN.gsCStr(Z80A.Z80A_REG_IFF2, 0);
        }
    }
}
