﻿using System;
using System.IO;
using System.Runtime.InteropServices;

namespace csMSX2
{
    public static class FDC
    {
        [DllImport("user32.dll")] private static extern short GetAsyncKeyState(int vKey);

      //TAPE
        public static byte Gi_MSX_TAPE_Work; //'1:Read, 2:Write
        public static int Gi_MSX_TAPE_Count;
        public static byte[] MSX_TAPE_Buffer = new byte[65536]; //[0~65535]
        public static string fsCasFile;

      //DISK
        public static string Gs_DSK_A_FILE_Bak;
        public static string Gs_DSK_B_FILE_Bak;
        public const sbyte Gi_MSX_DISK_Dpb = 0;

      //Disk 구동 표시용
        public const int Gi_MSX_DISK_Run_Time = 20;
        public static int Gi_MSX_DISK_A_Run;
        public static int Gi_MSX_DISK_B_Run;

        public static string MSX_DISK_BOOT;

        public static byte[] dskBuffer = new byte[512]; //[0~511]
        public static byte[] dskCluster = new byte[1024]; //[0~1023]

        public static byte[] dskFAT12 = new byte[1536]; //[0~1535]
        public static byte[] dskFAT12Entry = new byte[714]; //[0~713]
 
        public static sbyte fiDisk;

        public static void MSX_INIT_FDC()
        {
            Gi_MSX_TAPE_Work = 0;
        }

//---------- MSX DISK BIOS --------------------------------------------------------------------------------

      //4010 - Read/Write sectors from disk
        public static void MSX_DISK_BIOS_DSKIO()
        {
            sbyte iDisk;
            bool F; int i, j, L; ushort M;

            iDisk = 0;
            if (((Z80A.Z80A_REG_A & 1) == 0) && (MSX.Gi_DSK_A_ON == 1)) iDisk = 1;
            if (((Z80A.Z80A_REG_A & 1) == 1) && (MSX.Gi_DSK_B_ON == 1)) iDisk = 2;
            if (iDisk == 0) goto ErrorProc;

            if (iDisk == 1) Gi_MSX_DISK_A_Run = Gi_MSX_DISK_Run_Time; //디스크구동표시용(DispTime)
            if (iDisk == 2) Gi_MSX_DISK_B_Run = Gi_MSX_DISK_Run_Time;

            if (Z80A.Z80A_REG_B < 1)
            {
                Z80A.Z80A_REG_A = 12; //12 - Other errors
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            };

            M = Z80A.GET_Z80A_REG_HL(); //Transfer address
            for (i = 1; i <= Z80A.Z80A_REG_B; i++) //Number of sectors
            {
                L = Z80A.GET_Z80A_REG_DE() + i - 1;
                if ((L < 0) || (L > 1439))
                {
                    Z80A.Z80A_REG_A = 6; //6 - Seek error
                    Z80A.PUT_Z80A_FLAG_C(1); //Err
                    goto LastProc;
                };
                if (Z80A.GET_Z80A_FLAG_C() == 0)
                {
                  //Read
                    F = Gb_READ_MSX_DSK_LBA(iDisk, L); //Logical sector number
                    for (j = 0; j <= (512 - 1); j++)
                    {
                        MEM.PUT_MSX_MEMORY_SLOT2(M, dskBuffer[j]);
                        M = (ushort)(M + 1);
                    };
                }
                else
                {
                 //Write
                  for (j = 0; j <= (512 - 1); j++)
                  {
                      dskBuffer[j] = MEM.GET_MSX_MEMORY_SLOT2(M);
                      M = (ushort)(M + 1);
                  };
                  F = Gb_WRITE_MSX_DSK_LBA(iDisk, L); //Logical sector number
                };
            };

            Z80A.PUT_Z80A_FLAG_C(0); //Ok

            goto LastProc;

        ErrorProc: ;
            Z80A.Z80A_REG_A = 2; //2 - Not ready
            Z80A.PUT_Z80A_FLAG_C(1); //Err

        LastProc: ;
            Z80A.Z80A_REG_PC = 0x4033; //4033: C9 RET

          //DSKIO
          //Inputs:
          // [F] = Carry flag reset for read, set for write
          // [A] = Drive number (starts at 0)
          // [B] = Number of sectors to read/write
          // [C] = Media descriptor
          // [DE] = Logical sector number (starts at 0)
          // [HL] = Transfer address
          //Outputs:
          // If successful, carry flag cleared.
          // Otherwise, carry flag set, error code is placed in [A], number of remaining in [B].
          //Registers:
          // AF, BC, DE, HL, IX, IY may be affected.
          //The drive number and media descriptor come from the drive parameter block.
          //The number of sectors may range from 1 to 255.
          //The logical sector numbers start at zero and is incremented in ones,
          // so the I/O system must map these the logical sector numbers into tracks and sectors.
          //The logical sector 0 corresponds to track O, sector 1.
          //The error codes are defined as follows:
          // 0 Write protected
          // 2 Not ready
          // 4 Data (CRC) error
          // 6 Seek error
          // 8 Record Not found
          // 10 Write fault
          // 12 Other errors

        }

      //4013 - Check disk change status
        public static void MSX_DISK_BIOS_DSKCHG()
        {  
            sbyte iDisk;
            bool F;

            iDisk = 0;
            if (((Z80A.Z80A_REG_A & 1) == 0) && (MSX.Gi_DSK_A_ON == 1)) iDisk = 1;
            if (((Z80A.Z80A_REG_A & 1) == 1) && (MSX.Gi_DSK_B_ON == 1)) iDisk = 2;
            if (iDisk == 0) goto ErrorProc;

            if (iDisk == 1) Gi_MSX_DISK_A_Run = Gi_MSX_DISK_Run_Time; //디스크구동표시용(DispTime)
            if (iDisk == 2) Gi_MSX_DISK_B_Run = Gi_MSX_DISK_Run_Time;

            if (iDisk == 1)
            {
                if (MSX.Gs_DSK_A_FILE != Gs_DSK_A_FILE_Bak)
                {
                    Gs_DSK_A_FILE_Bak = MSX.Gs_DSK_A_FILE;
                    Z80A.Z80A_REG_B = 0xFF; //Disk Changed
                    Z80A.PUT_Z80A_FLAG_C(0); //Ok
                    goto LastProc;
                };
            };
            if (iDisk == 2)
            {
                if (MSX.Gs_DSK_B_FILE != Gs_DSK_B_FILE_Bak)
                {
                    Gs_DSK_B_FILE_Bak = MSX.Gs_DSK_B_FILE;
                    Z80A.Z80A_REG_B = 0xFF; //Disk Changed
                    Z80A.PUT_Z80A_FLAG_C(0); //Ok
                    goto LastProc;
                };
            };

            F = Gb_READ_MSX_DSK_LBA(iDisk, 0);

            Z80A.Z80A_REG_B = (byte)(Z80A.Z80A_REG_C == dskBuffer[0X15] ? 0x1 : 0xFF); //1:Disk Unchanged, -1:Disk Changed
            Z80A.PUT_Z80A_FLAG_C(0); //Ok

            goto LastProc;

        ErrorProc: ;
            Z80A.Z80A_REG_A = 2; //2 - Not ready
            Z80A.PUT_Z80A_FLAG_C(1); //Err

        LastProc: ;
            Z80A.Z80A_REG_PC = 0x4033; //4033: C9 RET

          //DSKCHG
          //Inputs:
          // [A] = Drive number
          // [B] = 0
          // [C] = Media descriptor
          // [HL1 = Base address of DPB
          //Outputs:
          // If successful: Carry flag reset,
          //  [B] = Disk change status
          //        1 Disk unchanged
          //        0 Unknown
          //       -1 Disk changed
          // ELSE:
          //  Carry flag set,
          //  Error code in [A] (same as DSKIO above)
          //[NOTE]
          //If the disk has been changed or may have been changed (Unknown),
          // read the boot sector or the first byte of the FAT of the currently inserted disk
          // and transfer a new DPB as with the GETDPB call described below.
          //Registers:
          // AF, BC, DE, HL, IX, IY may be affected.

        }

      //4016 - GETDPB: Disk format
        public static void MSX_DISK_BIOS_GETDPB()
        {
            sbyte iDisk;
            bool F; int j;

            int BytesPerSector; int SectorsPerDisk; int SectorsPerFAT; int ReservedSectors;

            iDisk = 0;
            if (((Z80A.Z80A_REG_A & 1) == 0) && (MSX.Gi_DSK_A_ON == 1)) iDisk = 1;
            if (((Z80A.Z80A_REG_A & 1) == 1) && (MSX.Gi_DSK_B_ON == 1)) iDisk = 2;
            if (iDisk == 0) goto ErrorProc;

            if (iDisk == 1) Gi_MSX_DISK_A_Run = Gi_MSX_DISK_Run_Time; //디스크구동표시용(DispTime)
            if (iDisk == 2) Gi_MSX_DISK_B_Run = Gi_MSX_DISK_Run_Time;

          //if (Gi_MSX_DISK_Dpb == 0)
          //{
                F = Gb_READ_MSX_DSK_LBA(iDisk, 0);
                BytesPerSector = (dskBuffer[0xC] * 256) + dskBuffer[0xB];
                SectorsPerDisk = (dskBuffer[0x14] * 256) + dskBuffer[0x13];
                SectorsPerFAT = (dskBuffer[0x17] * 256) + dskBuffer[0x16];
                ReservedSectors = (dskBuffer[0xF] * 256) + dskBuffer[0xE];
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 1), dskBuffer[0x15]); //Format ID [F8h-FFh]
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 2), dskBuffer[0xB]); //Sector size
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 3), dskBuffer[0xC]); //-
                j = (int)(BytesPerSector / 32) - 1;
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 4), (byte)j); //(Sector Size/32)-1
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 5), (byte)FN.giLen(FN.gsCStr(FN.giVal(FN.gsBin(j, 0)), 0))); //bit수
                j = dskBuffer[0xD] - 1;
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 6), (byte)j); //(Sectors per cluster)-1
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 7), (byte)(FN.giLen(FN.gsCStr(FN.giVal(FN.gsBin(j, 0)) ,0)) + 1)); //bit수+1
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 8), dskBuffer[0xE]); //Sector # of 1st FAT
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 9), dskBuffer[0xF]); //-
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 10), dskBuffer[0x10]); //Number of FATs
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 11), dskBuffer[0x11]); //Number of Dir Ent-s
                j = ReservedSectors + (dskBuffer[0x10] * SectorsPerFAT);
                j = j + (32 * dskBuffer[0x11] / BytesPerSector);
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 12), (byte)(j & 0xFF)); //Sector # of Data
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 13), (byte)((int)(j / 256) & 0xFF)); //-
                j = (SectorsPerDisk - j) / dskBuffer[0xD];
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 14), (byte)(j & 0xFF)); //Number of Clusters
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 15), (byte)((int)(j / 256) & 0xFF)); //-
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 16), dskBuffer[0x16]); //Sectors per FAT
                j = ReservedSectors + (dskBuffer[0x10] * SectorsPerFAT);
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 17), (byte)(j & 0xFF)); //Sector # of Dir
                MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 18), (byte)((int)(j / 256) & 0xFF)); //-
          //}
          //else
          //{
          //  //2DD-720KB
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 1), 0xF9); //Format ID [F8h-FFh] - 미디어
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 2), 512 & 0xFF); //섹터 크기
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 3), (int)(512 / 256) & 0xFF);  //-
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 4), (512 / 32) - 1); //디렉토리 마스크 - (Sector Size/32)-1
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 5), (byte)FN.giLen(FN.gsCStr(FN.giVal(FN.gsBin((512 / 32) - 1, 0)), 0))); //디렉토리 쉬프트
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 6), 2 - 1); //클러스터 마스크 - (Sectors per cluster)-1
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 7), (byte)(FN.giLen(FN.gsCStr(FN.giVal(FN.gsBin(2 - 1, 0)), 0)) + 1)); //클러스터 쉬프트
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 8), 1); //FAT 선두 섹터
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 9), 0); //-
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 10), 2); //FAT의 수
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 11), 112); //디렉토리 엔트리 수
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 12), 14); //데이터 영역의 선두 섹터
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 13), 0); //-
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 14), (1024 + 1) & 0xFF); //클러스터 수 + 1
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 15), (int)(1025 / 256) & 0xFF);  //-
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 16), 3); //한 FAT의 섹터수
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 17), 7); //선두 디렉토리 섹터
          //    MEM.PUT_MSX_MEMORY((ushort)(Z80A.GET_Z80A_REG_HL() + 18), 0); //-
          //};

            Z80A.PUT_Z80A_FLAG_C(0); //Ok

            goto LastProc;

        ErrorProc: ;
            Z80A.Z80A_REG_A = 2; //2 - Not ready
            Z80A.PUT_Z80A_FLAG_C(1); //Err

        LastProc: ;
            Z80A.Z80A_REG_PC = 0x4033; //4033: C9 RET

          //GETDPB
          //Inputs:
          // [A] = Drive Number
          // [B] = First byte of FAT
          // [C] = Media Descriptor
          // [HL] = Base address of DPB
          //Outputs:
          // [HL+l]..[HL+l81 = DPB for the specified drive
          //The Drive Descriptor Block (DPB) is defined as follows:
          // Media    Byte - Media type
          // SECSIZ   Word - Sector size (Must be 2^n)
          // DIRMSK   Byte - (SECSIZ/32)-1
          // DIRSHFT  Byte - Number of one bits in DIRMSK
          // CLUSMSK  Byte - (Sectors per cluster)-1
          // CLUSSHFT Byte - (Number of one bits in CLUSMSR)+l
          // FIRFAT   Word - Logical sector number of first FAT
          // FATCNT   Byte - Number of FATs
          // MAXENT   Byte - Number of directory entries (Max=254)
          // FIRREC   Word - Logical sector number of where the data area starts
          // MAXCLUS  Word - (Number of clusters on drive [not including reserved sectors, FAT sectors, or directory sectors])+l
          // FATSIZ   Byte - Number of sectors used
          // FIRDIR   Word - FAT logical sector number of start of directory
          //Note that the logical sector number always begins at zero .

        }

      //401C - Format disk
        public static void MSX_DISK_BIOS_DSKFMT()
        {
            sbyte iDisk; string sFile;

            iDisk = 0;
            if (((Z80A.Z80A_REG_D & 1) == 0) && (MSX.Gi_DSK_A_ON == 1)) { iDisk = 1; sFile = MSX.Gs_DSK_A_FILE; };
            if (((Z80A.Z80A_REG_D & 1) == 1) && (MSX.Gi_DSK_B_ON == 1)) { iDisk = 2; sFile = MSX.Gs_DSK_B_FILE; };
            if (iDisk == 0) goto ErrorProc;

            if (iDisk == 1) Gi_MSX_DISK_A_Run = Gi_MSX_DISK_Run_Time; //디스크구동표시용(DispTime)
            if (iDisk == 2) Gi_MSX_DISK_B_Run = Gi_MSX_DISK_Run_Time;

          //Open sFile For Output As #2; //파일생성&내용삭제(파일있을경우)
          //Close #2;

            Gt_Disk_B_Create(iDisk); //2DD-720KB

            Z80A.PUT_Z80A_FLAG_C(0); //Ok

            goto LastProc;

        ErrorProc: ;
            Z80A.Z80A_REG_A = 2; //2 - Not ready
            Z80A.PUT_Z80A_FLAG_C(1); //Err

        LastProc: ;
            Z80A.Z80A_REG_PC = 0x4033; //4033: C9 RET

          //DSKFMT
          //Formats a disk, both phy sically and logically.
          //The input parameters are as follows.
          // [A] Choice specif ied by the user (1 to 9). Meaningless unless there is a choice.
          // [D] Drive number, beginning at zero
          // [HL] Beginning address of the work area which can be used by the format process.
          // [BC] Length of the work area described above.
          //All registers except SP may be affected.
          //This routine formats all of the disk//s tracks physically,
          // writing the boot sector, and clearing FATs and directory entries.
          ////Clearing FATs// means:
          // Writing the media descriptor byte at the first byte,
          //  writing OFFH at the second and the third byte,
          //  and filling the remainder with O//s
          // Clearing directory entries// means:
          //  Filling all by tes with O//s
          //If the format ends successfully, return with carry flag reset,
          // otherwise return with carry flag set.
          //The error codes are defined as follows:
          // 0 Write protected
          // 2 Not ready
          // 4 Data (CRC) error
          // 6 Seek error
          // 8 Record not found
          // 10 Write fault
          // 12 Bad parameter
          // 14 Insufficient memory
          // 16 Other errors
          //[NOTE]
          //No prompting messages should be generated by this routine.
          //OEMSTATEMENT
          // Statement for system expa nsion for use by OEMs.
          // After disk BASIC scans its own e xpanded statements,
          //  control is passed to this entry.
          // The call ing sequence is identical to using a general-purpose expansion statement handler.
          // If your ROM does not have expansion statements,
          //  set the carry flag and do a Z80 //RET// instruction.

        }
    
//---------- MSX BIOS TAPE --------------------------------------------------------------------------------
    
      //모터를 가동시켜 테이프로부터 Header를 읽는다
        public static void MSX_TAPE_BIOS_TAPION()
        {
            if ((GetAsyncKeyState(123) & 32768) > 0) //Stop[F12]
            {
                Gi_MSX_TAPE_Work = 0;
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            };

            if ((MSX.Gs_CAS_FILE == "") || (FN.giInStr(1, MSX.Gs_CAS_FILE, "MSX~") == 0))
            {
                Gi_MSX_TAPE_Work = 0;
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            }
            else
            {
                if (Gi_MSX_TAPE_Work != 1) //1:Read, 2:Write
                {                    
                    if (fb_MSX_TAPE_File_Read() == false)
                    {
                        Gi_MSX_TAPE_Work = 0;
                        Z80A.PUT_Z80A_FLAG_C(1); //Err
                        goto LastProc;
                    }
                    else
                    {
                        Gi_MSX_TAPE_Count = 0;
                    };
                };
            };

            Gi_MSX_TAPE_Work = 1; //1:Read, 2:Write
            PPI.MSX_PPI_REG_C_CMT = 0; //가동

            Z80A.PUT_Z80A_FLAG_C(0); //Ok

        LastProc: ;
            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }

      //테이프로부터 입력시킨다
        public static void MSX_TAPE_BIOS_TAPIN()
        {
            if (Gi_MSX_TAPE_Work != 1) //1:Read, 2:Write
            {
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            };

            if ((PPI.MSX_PPI_REG_C_CMT == 1) || (Gi_MSX_TAPE_Count > 65535)) //1:정지
            {
                Gi_MSX_TAPE_Work = 0;
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            };

            Z80A.Z80A_REG_A = MSX_TAPE_Buffer[Gi_MSX_TAPE_Count++];

            Z80A.PUT_Z80A_FLAG_C(0); //Ok

        LastProc: ;
            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }

      //테이프로부터 읽는 것을 멈춘다
        public static void MSX_TAPE_BIOS_TAPIOF()
        {
            if (Gi_MSX_TAPE_Work == 1) //1:Read, 2:Write
            {
                PPI.MSX_PPI_REG_C_CMT = 1; //정지
            }
            else
            {
                Gi_MSX_TAPE_Work = 0;
            };

            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }

      //모터를 가동시키고 카세트에 헤더 블록을 쓴다
        public static void MSX_TAPE_BIOS_TAPOON()
        {
            if (Z80A.Z80A_REG_A != 0) //롱헤더
            {
                Gi_MSX_TAPE_Work = 2; //1:Read, 2:Write
                Gi_MSX_TAPE_Count = 0;
                fsCasFile = "C:\\MSX~" + DateTime.Now.ToString("yyyyMMdd") + "~" + DateTime.Now.ToString("HHmmss"); //+ ".CAS"
            }
            else //숏헤더
            {
                if (Gi_MSX_TAPE_Work != 2) //1:Read, 2:Write
                {
                    Gi_MSX_TAPE_Work = 0;
                    Z80A.PUT_Z80A_FLAG_C(1); //Err
                    goto LastProc;
                };
            };

            PPI.MSX_PPI_REG_C_CMT = 0; //가동
            Z80A.PUT_Z80A_FLAG_C(0); //Ok

        LastProc: ;
            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }

      //테이프로 출력시킨다
        public static void MSX_TAPE_BIOS_TAPOUT()
        {
            if (Gi_MSX_TAPE_Work != 2) //1:Read, 2:Write
            {
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            };

            if ((PPI.MSX_PPI_REG_C_CMT == 1) || (Gi_MSX_TAPE_Count > 65535)) //1:정지
            {
                Gi_MSX_TAPE_Work = 0;
                Z80A.PUT_Z80A_FLAG_C(1); //Err
                goto LastProc;
            };

            MSX_TAPE_Buffer[Gi_MSX_TAPE_Count++] = Z80A.Z80A_REG_A;

            Z80A.PUT_Z80A_FLAG_C(0); //Ok

        LastProc: ;
            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }

      //테이프에 써넣는 것을 멈춘다
        public static void MSX_TAPE_BIOS_TAPOOF()
        {
            if (Gi_MSX_TAPE_Work == 2) //1:Read, 2:Write
            {
                PPI.MSX_PPI_REG_C_CMT = 1; //정지
                fb_MSX_TAPE_File_Write();
            }
            else
            {
                Gi_MSX_TAPE_Work = 0;
            };

            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }

      //카세트 모터의 동작을 지시한다
        public static void MSX_TAPE_BIOS_STMOTR()
        {
            if (Z80A.Z80A_REG_A == 0) PPI.MSX_PPI_REG_C_CMT = 1; //정지
            if (Z80A.Z80A_REG_A == 1) PPI.MSX_PPI_REG_C_CMT = 0; //가동
            if (Z80A.Z80A_REG_A == 255)
            {
                if (PPI.MSX_PPI_REG_C_CMT == 0)
                {
                    PPI.MSX_PPI_REG_C_CMT = 1;
                }
                else
                {
                    PPI.MSX_PPI_REG_C_CMT = 0;
                };
            };

            Z80A.Z80A_REG_PC = 0xD11; //0D11: C9 RET
        }
    
        public static bool fb_MSX_TAPE_File_Read()
        {
            bool R;
            
            int RecordCount;
            int L; string S;

            R = false;

            for (L = 0; L <= 65535; L++) MSX_TAPE_Buffer[L] = 0;

            BinaryReader br = new BinaryReader(new FileStream(MSX.Gs_CAS_FILE, FileMode.Open));
            RecordCount = 0;

            while (true)
            {
                try
                {
                    MSX_TAPE_Buffer[RecordCount++] = br.ReadByte();
                }
                catch (EndOfStreamException ex)
                {
                    S = ex.ToString(); //미사용오류? 
                    br.Close();
                    break;
                };
            };

            br.Close();

            if (RecordCount > 0) R = true;

            return R;
        }

        public static void fb_MSX_TAPE_File_Write()
        {
            int L; byte C; string CasFile; string S;

            S = "";
            for (L = 10; L <= 15; L++)
            {
                C = MSX_TAPE_Buffer[L];
                if ((C >= 32) && (C <= 126)) S = S + FN.gsChr(C);
            };
            S = FN.gsTrim(S);
            if (S != "") S = "~" + S;

            CasFile = fsCasFile + S + ".CAS";

            BinaryWriter bw = new BinaryWriter(File.Open(CasFile, FileMode.Create));

            for (L = 0; L <= (Gi_MSX_TAPE_Count - 1); L++)
            {
                bw.Write(MSX_TAPE_Buffer[L]);
            };

            bw.Close();
        }
    
//---------- DSK File I/O (720KB) --------------------------------------------------------------------------------

        public static void Gt_Disk_B_Create(sbyte iDisk)
        {
            bool F; int i, j;

            for (j = 0; j <= (512 - 1); j++)
            {
                dskBuffer[j] = 0;
            };

            for (i = 0; i <= (1440 - 1); i++)
            {
                F = Gb_WRITE_MSX_DSK_LBA(iDisk, i);
            };

            dskBuffer[0] = 0xF9; //2DD-720KB
            dskBuffer[1] = 0xFF;
            dskBuffer[2] = 0xFF;
            F = Gb_WRITE_MSX_DSK_LBA(iDisk, 1); //FAT12#1
            F = Gb_WRITE_MSX_DSK_LBA(iDisk, 4); //FAT12#2

            Gt_Read_MSX_DISK_BOOT();
            for (i = 0; i <= (512 - 1); i++)
            {
                dskBuffer[i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(MSX_DISK_BOOT, (i * 3) + 1, 2)));
            };
            F = Gb_WRITE_MSX_DSK_LBA(iDisk, 0); //BOOT
        }

        public static bool Gb_READ_MSX_DSK_CHS(sbyte iDisk, int iHead, int iTrack, int iSector)
        {
  
            return Gb_READ_MSX_DSK_LBA(iDisk, Gi_GET_CHS_TO_LBA(iHead, iTrack, iSector));
          
        }

        public static bool Gb_WRITE_MSX_DSK_CHS(sbyte iDisk, int iHead, int iTrack, int iSector)
        {
          
            return Gb_WRITE_MSX_DSK_LBA(iDisk, Gi_GET_CHS_TO_LBA(iHead, iTrack, iSector));

        }

        public static bool Gb_READ_MSX_DSK_LBA(sbyte iDisk, int iLba)
        {
            bool R; int i, iPos, P; string DskFile = "";

            R = false;
          
          //On Error GoTo LastProc
            if ((iDisk < 1) || (iDisk > 2)) goto LastProc;

            if (iDisk == 1) DskFile = MSX.Gs_DSK_A_FILE;
            if (iDisk == 2) DskFile = MSX.Gs_DSK_B_FILE;

            iPos = iLba;
            P = iPos * 512;

            Stream fdsk = new FileStream(DskFile, FileMode.Open);
            for (i = 0; i <= (512 - 1); i++)
            {
                  fdsk.Seek(P++, SeekOrigin.Begin);
                  dskBuffer[i] = (byte)fdsk.ReadByte();
            };
            fdsk.Close();

            R = true;

        LastProc: ;
            return R;
        }

        public static bool Gb_WRITE_MSX_DSK_LBA(sbyte iDisk, int iLba)
        {
            bool R; int i, iPos, P; string DskFile = "";

            R = false;

          //On Error GoTo LastProc
            if ((iDisk < 1) || (iDisk > 2)) goto LastProc;

            if (iDisk == 1) DskFile = MSX.Gs_DSK_A_FILE;
            if (iDisk == 2) DskFile = MSX.Gs_DSK_B_FILE;

            iPos = iLba;
            P = iPos * 512;

            Stream fdsk = new FileStream(DskFile, FileMode.Open);
            for (i = 0; i <= (512 - 1); i++)
            {
                  fdsk.Seek(P++, SeekOrigin.Begin);
                  fdsk.WriteByte(dskBuffer[i]);
            };
            fdsk.Close();

            R = true;

        LastProc: ;
            return R;
        }

        public static int Gi_GET_CLUSTER_TO_LBA(int iCluster)
        {     
            int R;
          
            R = -1;

            R = ((iCluster - 2) * 2) + 14;

            return R;
        }

        public static int Gi_GET_CHS_TO_LBA(int iHead, int iTrack, int iSector)
        {
            int R;
          
            R = -1;
          
            R = (((iTrack * 2) + iHead) * 9) + (iSector - 1);
          
            return R;
        }

        public static void Gt_Read_MSX_DISK_BOOT()
        {
            string S;
  
            S = "";

          //== MSX DISK BOOT [000H~1FFH:512], MSX-DOS version 1.03 ==
            S = S + "EB FE 90 76 62 4D 53 58 64 73 6B 00 02 02 01 00 "; //0000: ...vbMSXdsk.....
            S = S + "02 70 00 A0 05 F9 03 00 09 00 02 00 00 00 D0 ED "; //0010: .p..............
            S = S + "53 58 C0 32 C2 C0 36 55 23 36 C0 31 1F F5 11 9D "; //0020: SX.2..6U#6.1....
            S = S + "C0 0E 0F CD 7D F3 3C 28 28 11 00 01 0E 1A CD 7D "; //0030: ....}.<((......}
            S = S + "F3 21 01 00 22 AB C0 21 00 3F 11 9D C0 0E 27 CD "; //0040: .!.."..!.?....'.
            S = S + "7D F3 C3 00 01 57 C0 CD 00 00 79 E6 FE FE 02 20 "; //0050: }....W....y....
            S = S + "07 3A C2 C0 A7 CA 22 40 11 77 C0 0E 09 CD 7D F3 "; //0060: .:...."@.w....}.
            S = S + "0E 07 CD 7D F3 18 B4 42 6F 6F 74 20 65 72 72 6F "; //0070: ...}...Boot erro
            S = S + "72 0D 0A 50 72 65 73 73 20 61 6E 79 20 6B 65 79 "; //0080: r..Press any key
            S = S + "20 66 6F 72 20 72 65 74 72 79 0D 0A 24 00 4D 53 "; //0090:  for retry..$.MS
            S = S + "58 44 4F 53 20 20 53 59 53 00 00 00 00 00 00 00 "; //00A0: XDOS  SYS.......
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //00B0: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 F3 2A "; //00C0: ...............*
            S = S + "51 F3 11 00 01 19 01 00 01 11 00 C1 ED B0 3A EE "; //00D0: Q.............:.
            S = S + "C0 47 11 EF C0 21 00 00 CD 51 52 F3 76 C9 18 64 "; //00E0: .G...!...QR.v..d
            S = S + "3A AF 80 F9 CA 6D 48 D3 A5 0C 8C 2F 9C CB E9 89 "; //00F0: :....mH..../....
            S = S + "D2 00 32 26 40 94 61 19 20 E6 80 6D 8A 00 00 00 "; //0100: ..2&@.a. ..m....
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0110: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0120: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0130: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0140: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0150: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0160: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0170: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0180: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //0190: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //01A0: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //01B0: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //01C0: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //01D0: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //01E0: ................
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 "; //01F0: ................
  
            MSX_DISK_BOOT = S;
        }
    }
}

// 미디어종류       - 1DD(9섹터), 2DD(9섹터), 1DD(8섹터), 2DD(8섹터)
// 미디어ID         - 0F8H        0F9H        0FAH        0FBH        0FCH,0FDH,0FEH,0FFH(40트랙)
// 면수             - 1           2           1           2           1    2    1    2
// 1면당트랙수      - 80          80          80          80          40   40   40   40
// 트랙당섹터수     - 9           9           8           8           9    9    8    8
// 섹터당바이트수   - 512         512         512         512         512  512  512  512
// 클러스터의사이즈 - 2섹터       2섹터       2섹터       2섹터       1    2    1    2
// FAT의사이즈      - 2섹터       3섹터       1섹터       2섹터       2    2    1    1
// FAT의갯수        - 2           2           2           2           2    2    2    2
// 작성가능파일수   - 112         112         112         112         64   112  64   112

// FAT12, 2DD, 720KB
// 섹터 - 1440 (0~1439) = 2 Head * 80 Track * 9 Sector
// 0 - 부트섹터
// 1~3 - FAT12#1
// 4~6 - FAT12#2
// 7~13 - 디렉터리, 7*512/32=112파일
// 14~1439 - 데이터

// 부트섹터   - MSX-DOS의 기동프로그램과 디스크 고유의 정보
// FAT * 2    - 디스크상의 데이터의 물리적인 관리정보
// 디렉터리   - 디스크상의 파일의 관리정보
// 데이터영역 - 실제의 화일데이터

// FAT의 항에서 기술하는 것처럼, 클러스터는 2부터 시작하는 순차번호로 지정
// 데이터영역의 선두가 클러스터로 #2의 위치에 해당
// 1클러스터가 몇 섹터인가의 정보를 얻으려면 펑션콜 1BH(디스크정보의 획득)의 시스템콜를 사용

// 데이터영역의 개시섹터는 DPB를 읽음
// 섹터번효 = 데이터영역의개시섹터 + (클러스터번호 - 2) * 클러스터당섹터수

// 부트섹터는 섹터#0 / FAT, 디렉터리, 데이터영역의 개시섹터의 위치는 DPB 참조

// DPB(드라이브 파라미터 블록)과 부트섹터
// MSX-DOS에서는 접속되어 있는 개개의 드라이브마다 DPB라는 영역이 메모리상의 워크에어리어에 설정되고
// 각 드라이브에 고유의 정보가 기록된다
// DPB에 기입되는 정보는, 본래는 디스크상의 부트섹터에 존재하고 있는 것이며
// 그것이 MSX-DOS의 기동시에 판독되어 나온다

// 부트섹터의정보
// 0B 0C - 1섹터의 사이즈 (바이트 단위)
// 0D    = 1클러스터의 단위 (섹터 단위)
// 0E 0F - MSX-DOS가 사용하지 않는 섹터수
// 10    - FAT의 갯수
// 11 12 - 디렉터리 엔트리의 수 (즉, 작성 가능한 파일의 수)
// 13 14 - 디스크에 포함하는 섹터의 총수
// 15    - 미디어ID
// 16 17 - FAT의 사이즈 (섹터 단위)
// 18 19 - 1트렉에 포함되는 섹터수
// 1A 1B - 면의 수 (양면, 단면)
// 1C 1D - 숨겨진 섹터수

// DPB의구조
// +00    - 드라이브 번호
// +01    - 미디어ID
// +02+03 - 섹터사이즈
// +04    - 디렉터리 마스크
// +05    - 디렉터리 시프트
// +06    - 클러스터 마스크
// +07    - 클러스터 시프트
// +08+09 - FAT의 선두섹터
// +10    - FAT의 갯수
// +11    - 디렉터리 엔트리의 수
// +12+13 - 데이터 영역의 선두 섹터
// +14+15 - 클러스터 총수+1
// +16    - 1개의 FAT에 소요되는 섹터수
// +17+18 - 디렉터리 영역의 선두 섹터
// +19+20 - 메모리상에 놓여진 FAT의 어드레스

// FAT
// 데이터 기록단위는 클러스터 임
// 선두 1바이트는 FAT ID (미디어ID)
// 이후 2바이트는 더미
// 이후 FAT 엔트리 #2번부터시작으로, 링크정보 1클러스터당 12비트, FFFh는 파일종료
// FAT 엔트리번호는 그것에 대흥하는 클러스터 번호임
// 링크정보는 다음에 이어지는 클러스터 번호임
// 000h      - 비어있음
// 002h~FEFh - 사용중(역속됨)
// FF0h~FF6h - 예약(사용금지)
// FF7h      - 배드섹터
// FF8h~FFFh - 사용중(끝)
// physical sector number = 33(0~32 predefined) + FAT entry number - 2
// Address of first FAT: (Start sector for partition 1 + Reserved sector count) * Bytesper sector
// Address of root directory: Address of first FAT + Number of FATs * Sectors per FAT
// Address of data region: Address of root directory + Maximum number of root Directory entries * 32
// Start address for file: Address of data region + (Cluster number-2) * Sectors per cluster * Bytes per sector
// The "-2" is because the first cluster of the Data region is cluster #2

// 디렉터리 - 32바이트
// 00~07 - 파일명 (8자)
// 08~10 - 확장자 (3자)
// 11    - 파일속성
// 12~21 - MS-DOS와 호환성을 위한 공백 (MSX-DOS에서는 사용 안함)
// 22~23 - 파일 최종기록 시간
// 24~25 - 파일 최종기록 일자
// 26~27 - 파일의 선두 클러스터
// 28~31 = 파일 사이즈
// 사용가능문자 -> A~Z, 0~9, $, &, #, %, ', (, ), -, @, ^, {, }, ~, `, !, _

// 00 - 00h 는 미사용, E5h 는 삭제됨
// 11 - ..A(Archive)S(Sub Directory)V(Volume Label)S(System)H(Hidden)R(Read Only)
// 23 - h4,h3,h2,h1,h0,m5,m4,m3, 22  m2,m1,m0,s4,s3,s2,s1,s0
// 25 - y6,y5,y4,y3,y2,y1,y0,m3, 24 -m2,m1,m0,d4,d3,d2,d1,d0
// 시 0~23, 분 0~59, 초(0~29)/2 - 초*2는 실제 초의 값
// 연 0~99, 월 1~12, 일 1~31 - 연 0~99는 1980~2079에 해당함

// CHS -> LBA
// LBA = ( ( CYLINDER * heads per cylinder + HEAD ) * sectors per track ) + SECTOR - 1
// 섹터는 1부터 시작됨

// LBA -> CHS
// CYLINDER = LBA / ( heads per cylinder * sectors per track ) HEAD = ( LBA / sectors per track ) % heads per cylinder
// SECTOR = ( LBA % sectors per track ) + 1
//    LBA = ((cylinder * heads_per_cylinder + heads) * sectors_per_track) + sector - 1

// translate LBA sectors into CHS addressing
// initially copied and pasted from dsk.c!
//
// LBA to/from CHS conversion - see http://www.ata-atapi.com/ How It Works section on CHSxlat - CHS Translation
// LBA (logical block address) simple 0 to N-1 used internally and with extended int 13h (BIOS)
// L-CHS (logical CHS) is the CHS view when using int 13h (BIOS)
// P-CHS (physical CHS) is the CHS view when directly accessing disk, should not, but could be used in BS or MBR
//
// LBA = ((cylinder * heads_per_cylinder + heads) * sectors_per_track) + sector - 1
//
// cylinder = LBA / (heads_per_cylinder * sectors_per_track)
//     temp = LBA % (heads_per_cylinder * sectors_per_track)
//     head = temp / sectors_per_track
//   sector = temp % sectors_per_track + 1
// 
// where heads_per_cylinder and sectors_per_track are the current translation mode values.
// cyclinder and heads are 0 to N-1 based, sector is 1 to N based
