﻿namespace csMSX2
{
    public static class INT
    {
        public static sbyte Gi_MSX_Interrupt; //1:인터럽트수행중
        public static ushort Go_MSX_InterruptBack; //0~65535
        public static sbyte Gi_Z80A_EI_Chk; //1:직전명령이EI일경우(일정갯수명령실행까지인터럽트금지)
        public const sbyte Gi_Z80A_EI_Cnt = 2;

        public static sbyte Z80A_INT_MODE;
        public static sbyte Z80A_HALT;

        public static void MSX_INIT_INT()
        {
            Gi_MSX_Interrupt = 0; //1:인터럽트수행중
            Go_MSX_InterruptBack = 0;
            Gi_Z80A_EI_Chk = 0;

            Z80A_INT_MODE = 0;
            Z80A_HALT = 0;
        }

        public static void gt_NOP()
        {
          //
        }

        public static void gt_HALT()
        {
          //MsgBox ("* SYSTEM HALT !")
        }

        public static void gt_DI()
        {
            Z80A.Z80A_REG_IFF1 = 0;
            Z80A.Z80A_REG_IFF2 = 0;
        }

        public static void gt_EI()
        {
            Z80A.Z80A_REG_IFF1 = 1;
            Z80A.Z80A_REG_IFF2 = 1;
        }

        public static void gt_LD_I_A()
        {
            Z80A.Z80A_REG_I = Z80A.Z80A_REG_A;
        }

        public static void gt_LD_R_A()
        {
            Z80A.Z80A_REG_R = Z80A.Z80A_REG_A;
        }

        public static void gt_LD_A_I()
        {
          //A=I, S=Sign(A), Z=Zero(A), H=0, P=IFF2, N=0
          //If an interrupt occurs during execution of this instruction, the parity flag contains a 0.
            Z80A.PUT_Z80A_FLAG_N(0); //Not뺄셈
            Z80A.Z80A_REG_A = Z80A.Z80A_REG_I;
          //Z80A_FLAG_C = ?; //캐리
            Z80A.PUT_Z80A_FLAG_H(0); //Not하프캐리
            Z80A.PUT_Z80A_FLAG_PV(Z80A.Z80A_REG_IFF2); //오버플로
            Z80A.PUT_Z80A_FLAG_S(Z80A.giGet8Sign(Z80A.Z80A_REG_A)); //Sign
            Z80A.PUT_Z80A_FLAG_Z(Z80A.giGet8Zero(Z80A.Z80A_REG_A)); //Zero
        }

        public static void gt_LD_A_R()
        {
          //A=I, S=Sign(A), Z=Zero(A), H=0, P=IFF2, N=0
          //If an interrupt occurs during execution of this instruction, the parity flag contains a 0.
            Z80A.PUT_Z80A_FLAG_N(0); //Not뺄셈
            Z80A.Z80A_REG_A = Z80A.Z80A_REG_R;
          //Z80A_FLAG_C = ?; //캐리
            Z80A.PUT_Z80A_FLAG_H(0); //하프캐리
            Z80A.PUT_Z80A_FLAG_PV(Z80A.Z80A_REG_IFF2); //오버플로
            Z80A.PUT_Z80A_FLAG_S(Z80A.giGet8Sign(Z80A.Z80A_REG_A)); //Sign
            Z80A.PUT_Z80A_FLAG_Z(Z80A.giGet8Zero(Z80A.Z80A_REG_A)); //Zero
        }

        public static void gt_IM_0()
        {
            INT.Z80A_INT_MODE = 0;
        }

        public static void gt_IM_1()
        {
            INT.Z80A_INT_MODE = 1;
        }

        public static void gt_IM_2()
        {
            INT.Z80A_INT_MODE = 2;
        }

        public static void gt_IM_0_1()
        {
          //??? 알려지지않음
        }

        public static void gt_RETI()
        {
          //RET
        }

        public static void gt_RETN()
        {
            Z80A.Z80A_REG_IFF1 = Z80A.Z80A_REG_IFF2;
          //RET
        }

        public static void gt_RST_00()
        {
            gt_RST(0x00);
        }

        public static void gt_RST_08()
        {
            gt_RST(0x08);
        }

        public static void gt_RST_10()
        {
            gt_RST(0x10);
        }

        public static void gt_RST_18()
        {
            gt_RST(0x18);
        }

        public static void gt_RST_20()
        {
            gt_RST(0x20);
        }

        public static void gt_RST_28()
        {
            gt_RST(0x28);
        }

        public static void gt_RST_30()
        {
            gt_RST(0x30);
        }

        public static void gt_RST_38()
        {
            gt_RST(0x38);
        }
        public static void gt_RST(byte iVal) //Call 명령과 동일
        {
            Z80A.gt_PUSH_16((ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF));
            Z80A.Z80A_REG_PC = iVal;
        }
    }
}
