﻿using System.Text;
using System.IO;

namespace csMSX2
{
    public static class IO
    {
        public static byte[] MSX_PORT = new byte[256]; //0~255 [0~255]

      //MSX2, CLOCK-IC, 레지스터4비트 - 배터리로백업됨
      //BLOCK0 - 0~12(CLOCK), 13(MODE), 14(TEST-기록전용), 15(RESET-기록전용)
      //LOCK1 - 0~12(ALARM)
      //LOCK2 - 0~12(RAM-1)
      //LOCK3 - 0~12(RAM-2)
      //ODE(0:Clock카운트의정지(초이상),1:개시/0:알람출력Off,1:On/00~11:블럭0~3선택)
        public static byte[,] MSX_CLOCK_REG = new byte[4, 16]; //0~255 [0~3, 0~15]

        public static sbyte Gi_MSX_PortWrite; //1:Port Write [Test용]

        public static void MSX_INIT_IO()
        {
            for (int i = 0; i <= 255; i++)
            {
                MSX_PORT[i] = 0;
            };

            for (int i = 0; i <= 3; i++) //MSX2
            {
                for (int j = 0; j <= 15; j++)
                {
                    MSX_CLOCK_REG[i, j] = 0;
                };
            };
        }

        public static byte GET_MSX_PORT(byte iAddress)
        {
            byte GET_MSX_PORT, C;
  
          //==Test====================
            string Pt;
            if (Gi_MSX_PortWrite == 1)
            {
                if ((iAddress == 0x98) || (iAddress == 0x99) || (iAddress == 0x9A) || (iAddress == 0x9B))
                {
                    Pt = "";
                    Pt = Pt + "S:" + FN.gsCStr(VDT.Gi_MSX_SCREEN_MODE, 0) + ",";
                    Pt = Pt + "P:" + FN.gsCStr(VDT.Gi_MSX_Graphic_Page, 0) + ",";
                    Pt = Pt + "O:" + FN.gsCStr(VDT.MSX_VDT_REG_ON, 0) + " ";
                    Pt = Pt + "IN(" + FN.gsHex(iAddress, 0) + ") ";
                    if (iAddress == 0x98) Pt = Pt + "IO:" + FN.gsCStr(VDT.Gi_MSX_VRAM_IO, 0) + "-[" + FN.gsHex(VDT.Go_MSX_VRAM_ADDRESS, 0) + "(" + FN.gsCStr(VDT.MSX_VRAM[VDT.Go_MSX_VRAM_ADDRESS], 0) + ")] ";
                    if (iAddress == 0x99) Pt = Pt + "St:" + FN.gsCStr(VDT.MSX_VDT_REG[15], 0) + "(?) ";
                    FileStream fs = new FileStream("C:\\csPortInOut.Txt", FileMode.Append, FileAccess.Write);
                    StreamWriter sw = new StreamWriter(fs, Encoding.Default);
                    sw.WriteLine(FN.gsHex(Z80A.Z80A_REG_PC, 4) + ": " + Pt);
                    sw.Close();
                    fs.Close();
                };
            };
          //==End====================
              
            GET_MSX_PORT = 0; //Default

          //RS-232C (8251A)
            if (iAddress == 0x80) {}; //Data Read
            if (iAddress == 0x81) {}; //Status Read

          //프린터
            if (iAddress == 0x90) GET_MSX_PORT = MSX_PORT[iAddress]; //Status Read (b1)

          //VDP 포트 #0 (TMS9918) - CRT 콘트롤, 화면표시기능
          //MAIN-ROM [6번지]값 참조
            if (iAddress == 0x98) //Video 램에서의 Data Read / VRAM data read/write port
            {
              //if (VDT.Gi_MSX_VRAM_IO == 1)
              //{
                    GET_MSX_PORT = VDT.MSX_VRAM[VDT.Go_MSX_VRAM_ADDRESS];
                    VDT.Go_MSX_VRAM_ADDRESS = VDT.Go_MSX_VRAM_ADDRESS + 1;
                    if (MSX.GiMSX2 == 0) //MSX1
                    {
                        if (VDT.Go_MSX_VRAM_ADDRESS > 16383) VDT.Go_MSX_VRAM_ADDRESS = 0;
                    }
                    else //MSX2
                    {
                        if (VDT.Go_MSX_VRAM_ADDRESS > 131071) VDT.Go_MSX_VRAM_ADDRESS = 0;
                    };
              //};
            };
          //VDP 포트 #1
          //MAIN-ROM [6번지]값+1
            if (iAddress == 0x99) //Status Read / Status register read port
            {
                if (MSX.GiMSX2 == 0) //MSX1
                {
                    GET_MSX_PORT = VDT.MSX_VDT_REG_ST(); VDT.MSX_VDT_ST_REG_FF= 0; //Clear
                }
                else //MSX2
                {
                    if (VDT.MSX_VDT_REG[15] == 0) { GET_MSX_PORT = VDT.MSX_VDT_REG_ST(); VDT.MSX_VDT_ST_REG_FF = 0; }; //Clear //1[4]=0000
                    if (VDT.MSX_VDT_REG[15] == 1) { GET_MSX_PORT = VDT.MSX_VDT_REG_ST1(); VDT.MSX_VDT_ST_REG_FH = 0; }; //Clear
                    if (VDT.MSX_VDT_REG[15] == 2) GET_MSX_PORT = VDT.MSX_VDT_REG_ST2();
                    if (VDT.MSX_VDT_REG[15] == 3) GET_MSX_PORT = VDT.MSX_VDT_REG_ST3();
                    if (VDT.MSX_VDT_REG[15] == 4) GET_MSX_PORT = VDT.MSX_VDT_REG_ST4();
                    if (VDT.MSX_VDT_REG[15] == 5) GET_MSX_PORT = VDT.MSX_VDT_REG_ST5();
                    if (VDT.MSX_VDT_REG[15] == 6) GET_MSX_PORT = VDT.MSX_VDT_REG_ST6();
                    if (VDT.MSX_VDT_REG[15] == 7) GET_MSX_PORT = VDT.MSX_VDT_REG_ST7();
                    if (VDT.MSX_VDT_REG[15] == 8) GET_MSX_PORT = VDT.MSX_VDT_REG_ST8();
                    if (VDT.MSX_VDT_REG[15] == 9) GET_MSX_PORT = VDT.MSX_VDT_REG_ST9(); 
                };
            };

          //PSG (AY-3-8910) - 카세트, 조이스틱 콘트롤, Sound 출력 기능
            if (iAddress == 0xA2) //지정된 Register에서 읽기
            {
                C = MSX_PORT[0xA0];
                if (C == 00) GET_MSX_PORT = PSG.MSX_PSG_REG[00]; 
                if (C == 01) GET_MSX_PORT = PSG.MSX_PSG_REG[01]; 
                if (C == 02) GET_MSX_PORT = PSG.MSX_PSG_REG[02]; 
                if (C == 03) GET_MSX_PORT = PSG.MSX_PSG_REG[03]; 
                if (C == 04) GET_MSX_PORT = PSG.MSX_PSG_REG[04]; 
                if (C == 05) GET_MSX_PORT = PSG.MSX_PSG_REG[05]; 
                if (C == 06) GET_MSX_PORT = PSG.MSX_PSG_REG[06]; 
                if (C == 07) GET_MSX_PORT = PSG.MSX_PSG_REG[07]; 
                if (C == 08) GET_MSX_PORT = PSG.MSX_PSG_REG[08]; 
                if (C == 09) GET_MSX_PORT = PSG.MSX_PSG_REG[09]; 
                if (C == 10) GET_MSX_PORT = PSG.MSX_PSG_REG[10]; 
                if (C == 11) GET_MSX_PORT = PSG.MSX_PSG_REG[11]; 
                if (C == 12) GET_MSX_PORT = PSG.MSX_PSG_REG[12]; 
                if (C == 13) GET_MSX_PORT = PSG.MSX_PSG_REG[13];
                if (C == 14) { PSG.SET_MSX_PSG_STATUS(); GET_MSX_PORT = PSG.MSX_PSG_REG[14]; }; //I/O포트A(Read),Cas, Jis, Trigger B, A, R, L, D, U (1:안눌림)
                if (C == 15) { GET_MSX_PORT = PSG.MSX_PSG_REG[15]; }; //I/O포트B(Write)
            };

          //PPI (8255A) - 카트리지, 키보드, 카세트 콘트롤, Sound 출력 기능
            if (iAddress == 0xA8) //PPI-register A / Primary slot select register
            {
                GET_MSX_PORT = PPI.GET_MSX_PPI_REG_A();
            };
            if (iAddress == 0xA9) //PPI-register B / Keyboard matrix row input register
            {
                PPI.SET_MSX_KEY_STATUS(); 
                GET_MSX_PORT = PPI.MSX_PPI_REG_B; //Keyboard matrix row input register
            };
            if (iAddress == 0xAA) //PPI-register C / Keyboard and cassette interface
            {
                GET_MSX_PORT = PPI.GET_MSX_PPI_REG_C();
            };
              
            if (iAddress == 0xB5) //지정된 Clock 블록+Reg 읽기
            {
                C = MSX_PORT[0xB4];
                if (C <= 13) GET_MSX_PORT = MSX_CLOCK_REG[(C <= 12 ? MSX_CLOCK_REG[0, 13] & 3 : 0), C];
            };

            return GET_MSX_PORT;
        }

        public static void PUT_MSX_PORT(byte iAddress, byte iVal)
        {
            byte C, iBit, iReg, iRegH;
  
          //==Test====================
            string Pt; int iCmd;
            if (Gi_MSX_PortWrite == 1)
            {
                if ((iAddress == 0x98) || (iAddress == 0x99) || (iAddress == 0x9A) || (iAddress == 0x9B))
                {
                    Pt = ""; iCmd = 0;
                    Pt = Pt + "S:" + FN.gsCStr(VDT.Gi_MSX_SCREEN_MODE, 0) + ",";
                    Pt = Pt + "P:" + FN.gsCStr(VDT.Gi_MSX_Graphic_Page, 0) + ",";
                    Pt = Pt + "O:" + FN.gsCStr(VDT.MSX_VDT_REG_ON, 0) + " ";
                    Pt = Pt + "OUT(" + FN.gsHex(iAddress, 0) + "," + FN.gsHex(iVal, 0) + ") ";
                    if (iAddress == 0x98) Pt = Pt + "IO:" + FN.gsCStr(VDT.Gi_MSX_VRAM_IO, 0) + "-[" + FN.gsHex(VDT.Go_MSX_VRAM_ADDRESS, 0) + "(" + FN.gsHex(iVal, 0) + ")] ";
                    if (iAddress == 0x99)
                    {
                        Pt = Pt + "F:" + FN.gsCStr(VDT.Gi_MSX_VRAM_Flg, 0) + " ";
                        if (VDT.Gi_MSX_VRAM_Flg == 1)
                        {
                            if ((iVal & 128) > 0)
                            {
                                if ((iVal & 63) == 46) iCmd = 1;
                                Pt = Pt + "R:" + FN.gsCStr((iVal & 63), 0) + "(" + FN.gsHex(MSX_PORT[iAddress], 0) + ") ";
                            }
                            else
                            {
                                if ((iVal & 64) == 0)
                                {
                                    Pt = Pt + "Rd:[" + FN.gsHex(Z80A.goGetIntHLToLng((byte)(iVal & 63), MSX_PORT[iAddress]) + ((VDT.MSX_VDT_REG[14] & 7) * 16384), 0) + "] ";
                                }
                                else
                                {
                                    Pt = Pt + "Wt:[" + FN.gsHex(Z80A.goGetIntHLToLng((byte)(iVal & 63), MSX_PORT[iAddress]) + ((VDT.MSX_VDT_REG[14] & 7) * 16384), 0) + "] ";
                                };
                            };
                        };
                    };
                    if (iAddress == 0x9A)
                    {
                        Pt = Pt + "F2:" + FN.gsCStr(VDT.Gi_MSX2_VRAM_Flg, 0) + " R:" + FN.gsCStr(VDT.MSX_VDT_REG[16] & 15, 0) + " ";
                        if (VDT.Gi_MSX2_VRAM_Flg == 0)
                        {
                            Pt = Pt + "Red(" + FN.gsHex(TBL.Gi_D_Table16[iVal & 0x70], 0) + ")Blue(" + FN.gsHex(iVal & 7, 0) + ") ";
                        }
                        else
                        {
                            Pt = Pt + "Green(" + FN.gsHex(iVal & 7, 0) + ") ";
                        };
                    };
                    if (iAddress == 0x9B)
                    {
                        if ((VDT.MSX_VDT_REG[17] & 63) == 46) iCmd = 1;
                        Pt = Pt + "R:" + FN.gsCStr(VDT.MSX_VDT_REG[17] & 63, 0) + "(" + FN.gsHex(iVal, 0) + ") ";
                        if ((VDT.MSX_VDT_REG[17] & 128) > 0)
                        {
                            Pt = Pt + "NoAt ";
                        }
                        else
                        {
                            Pt = Pt + "Auto ";
                        };
                    };
                    if (iCmd == 1)
                    {
                        Pt = Pt + "SX:" + FN.gsHex(VDT.Go_MSX_VDT_CMD_REG_SX, 0) + ",";
                        Pt = Pt + "SY:" + FN.gsHex(VDT.Go_MSX_VDT_CMD_REG_SY, 0) + ",";
                        Pt = Pt + "DX:" + FN.gsHex(VDT.Go_MSX_VDT_CMD_REG_DX, 0) + ",";
                        Pt = Pt + "DY:" + FN.gsHex(VDT.Go_MSX_VDT_CMD_REG_DY, 0) + ",";
                        Pt = Pt + "NX(Mjg):" + FN.gsHex(VDT.Go_MSX_VDT_CMD_REG_NX, 0) + ",";
                        Pt = Pt + "NY(Min):" + FN.gsHex(VDT.Go_MSX_VDT_CMD_REG_NY, 0) + ",";
                        Pt = Pt + "DIX:" + FN.gsHex(VDT.MSX_VDT_CMD_REG_DIX, 0) + ",";
                        Pt = Pt + "DIY:" + FN.gsHex(VDT.MSX_VDT_CMD_REG_DIY, 0) + ",";
                        Pt = Pt + "MAJ:" + FN.gsHex(VDT.MSX_VDT_CMD_REG_MAJ, 0) + ",";
                        Pt = Pt + "Col:" + FN.gsHex(VDT.Gi_MSX_VDT_CMD_REG_Color, 0) + " ";
                    };
                   FileStream fs = new FileStream("C:\\csPortInOut.Txt", FileMode.Append, FileAccess.Write);
                   StreamWriter sw = new StreamWriter(fs, Encoding.Default);
                   sw.WriteLine(FN.gsHex(Z80A.Z80A_REG_PC, 4) + ": " + Pt);
                   sw.Close();
                   fs.Close();
                };
            };
          //==End====================
              
          //RS-232C (8251A)
            if (iAddress == 0x80) {}; //Data Write
            if (iAddress == 0x81) {}; //Mode Set

          //프린터
            if (iAddress == 0x90) { MSX_PORT[iAddress] = iVal; }; //Status Write (b0)
            if (iAddress == 0x91) {}; //Print Data

          //VDP 포트 #0 (TMS9918) - CRT 콘트롤, 화면표시기능
          //MAIN-ROM [7번지]값 참조
            if (iAddress == 0x98) //Video 램으로의 Data Write / VRAM data read/write port
            {
              //if (VDT.Gi_MSX_VRAM_IO == 2)
              //{
                    VDT.MSX_VRAM[VDT.Go_MSX_VRAM_ADDRESS] = iVal;
                    VDT.Go_MSX_VRAM_ADDRESS = VDT.Go_MSX_VRAM_ADDRESS + 1;
                    if (MSX.GiMSX2 == 0) //MSX1
                    {
                        if (VDT.Go_MSX_VRAM_ADDRESS > 16383) VDT.Go_MSX_VRAM_ADDRESS = 0;
                    }
                    else //MSX2
                    {
                        if (VDT.Go_MSX_VRAM_ADDRESS > 131071) VDT.Go_MSX_VRAM_ADDRESS = 0;
                    };
                    VDT.Gi_MSX_Screen_Out = 1; //화면표시작업
              //};
            };
          //VDP 포트 #1
          //MAIN-ROM [7번지]값+1
            if (iAddress == 0x99) //Command, Address Set / VDP register write port (bit 7=1 in second write), VRAM address register (bit 7=0 in second write, bit 6: read/write access (0=read))
            {
                if (VDT.Gi_MSX_VRAM_Flg == 0) //첫번째전송
                {
                    VDT.Gi_MSX_VRAM_Flg = 1;
                    MSX_PORT[iAddress] = iVal;
                }
                else                          //두번째전송
                {
                    VDT.Gi_MSX_VRAM_Flg = 0;
                    C = MSX_PORT[iAddress];
                    if ((iVal & 128) > 0) //1[1]=1 : 레지스트리에 기록
                    {
                        if (MSX.GiMSX2 == 0) //MSX1
                        {
                            iReg = (byte)(iVal & 7); //6[3] - Reg번호
                        }
                        else //MSX2
                        {
                            iReg = (byte)(iVal & 63); //3[6] - Reg번호
                        };
                        VDT.MSX_VDT_REG[iReg] = C;
                        if ((iReg == 00) || (iReg == 01)) VDT.MSX_SCREEN_MODE_SET(); //MSX1
                        if ((iReg == 08) || (iReg == 09)) VDT.MSX_SCREEN_MODE_SET(); //MSX2
                        if (iReg == 02) VDT.MSX_SCREEN_MODE_SET2(); //MSX2
                        if (iReg == 08) VDT.MSX_SCREEN_MODE_SET8(); //MSX2
                        if (iReg == 09) VDT.MSX_SCREEN_MODE_SET9(); //MSX2
                        if (iReg == 14) MSX_VDT_ADDRESS_HIGH(); //MSX2
                        if (iReg == 32) VDT.MSX_VDT_CMD_REG32_SET();
                        if (iReg == 33) VDT.MSX_VDT_CMD_REG33_SET();
                        if (iReg == 34) VDT.MSX_VDT_CMD_REG34_SET();
                        if (iReg == 35) VDT.MSX_VDT_CMD_REG35_SET();
                        if (iReg == 36) VDT.MSX_VDT_CMD_REG36_SET();
                        if (iReg == 37) VDT.MSX_VDT_CMD_REG37_SET();
                        if (iReg == 38) VDT.MSX_VDT_CMD_REG38_SET();
                        if (iReg == 39) VDT.MSX_VDT_CMD_REG39_SET();
                        if (iReg == 40) VDT.MSX_VDT_CMD_REG40_SET();
                        if (iReg == 41) VDT.MSX_VDT_CMD_REG41_SET();
                        if (iReg == 42) VDT.MSX_VDT_CMD_REG42_SET();
                        if (iReg == 43) VDT.MSX_VDT_CMD_REG43_SET();
                        if (iReg == 44) VDT.MSX_VDT_CMD_REG44_SET();
                        if (iReg == 45) VDT.MSX_VDT_CMD_REG45_SET();
                        if (iReg == 46) VDT.MSX_VDT_CMD_REG46_SET();
                        VDT.Gi_MSX_Screen_Out = 1; //화면표시작업
                    }
                    else                  //1[1]=0 : 상위 메모리번지 지정
                    {
                        iRegH = (byte)(iVal & 63); //3[6] - 상위번지(VRAM), 63=3Fh=0011 1111
                        if ((iVal & 64) == 0) //Read  : 2[1]=0, 00?? ????
                        {
                            VDT.Gi_MSX_VRAM_IO = 1; //Read
                        }
                        else                  //Write : 2[1]=1, 01?? ????
                        {                              
                            VDT.Gi_MSX_VRAM_IO = 2; //Write
                        };
                        VDT.Go_MSX_VRAM_ADDRESS = Z80A.goGetIntHLToLng(iRegH, C);
                        if (MSX.GiMSX2 == 1) MSX_VDT_ADDRESS_HIGH(); //MSX2 - 상위번지
                    };
                };
            };
          //VDP 포트 #2
          //MAIN-ROM [7번지]값+2
            if (iAddress == 0x9A) //팔레트 레지스터에의 기입
            {
                if (MSX.GiMSX2 == 1) //MSX2
                {
                    C = (byte)(VDT.MSX_VDT_REG[16] & 15); //1[4]=0000
                    if (VDT.Gi_MSX2_VRAM_Flg == 0)
                    {
                        VDT.MSX_VDT_REG_PAL_Red[C] = (byte)TBL.Gi_M_Table36[TBL.Gi_D_Table16[iVal & 0x70]]; //2[3]
                        VDT.MSX_VDT_REG_PAL_Blue[C] = (byte)TBL.Gi_M_Table36[iVal & 7]; //6[3]
                        VDT.Gi_MSX2_VRAM_Flg = 1;
                    }
                    else
                    {
                        VDT.MSX_VDT_REG_PAL_Green[C] = (byte)TBL.Gi_M_Table36[iVal & 7]; //6[3]
                        VDT.MSX_VDT_REG[16] = (byte)((VDT.MSX_VDT_REG[16] + 1) & 15);
                        VDT.Gi_MSX2_VRAM_Flg = 0;
                    };
                    VDT.MSX_COLOR_PALETTE(C, VDT.MSX_VDT_REG_PAL_Red[C], VDT.MSX_VDT_REG_PAL_Green[C], VDT.MSX_VDT_REG_PAL_Blue[C]);
                    VDT.Gi_MSX_Screen_Out = 1; //화면표시작업
                };
            };
          //VDP 포트 #3
          //MAIN-ROM [7번지]값+3
            if (iAddress == 0x9B) //간접지정된 레지스터에의 기입
            {
                if (MSX.GiMSX2 == 1) //MSX2
                {
                    iReg = (byte)(VDT.MSX_VDT_REG[17] & 63);
                    if ((iReg != 17) && (iReg <= 46)) VDT.MSX_VDT_REG[iReg] = iVal; //Reg17-금지
                    if ((iReg == 00) || (iReg == 01)) VDT.MSX_SCREEN_MODE_SET(); //MSX1
                    if (iReg == 02) VDT.MSX_SCREEN_MODE_SET2(); //MSX2
                    if (iReg == 08) VDT.MSX_SCREEN_MODE_SET8(); //MSX2
                    if (iReg == 09) VDT.MSX_SCREEN_MODE_SET9(); //MSX2
                    if (iReg == 14) MSX_VDT_ADDRESS_HIGH(); //MSX2
                    if (iReg == 32) VDT.MSX_VDT_CMD_REG32_SET();
                    if (iReg == 33) VDT.MSX_VDT_CMD_REG33_SET();
                    if (iReg == 34) VDT.MSX_VDT_CMD_REG34_SET();
                    if (iReg == 35) VDT.MSX_VDT_CMD_REG35_SET();
                    if (iReg == 36) VDT.MSX_VDT_CMD_REG36_SET();
                    if (iReg == 37) VDT.MSX_VDT_CMD_REG37_SET();
                    if (iReg == 38) VDT.MSX_VDT_CMD_REG38_SET();
                    if (iReg == 39) VDT.MSX_VDT_CMD_REG39_SET();
                    if (iReg == 40) VDT.MSX_VDT_CMD_REG40_SET();
                    if (iReg == 41) VDT.MSX_VDT_CMD_REG41_SET();
                    if (iReg == 42) VDT.MSX_VDT_CMD_REG42_SET();
                    if (iReg == 43) VDT.MSX_VDT_CMD_REG43_SET();
                    if (iReg == 44) VDT.MSX_VDT_CMD_REG44_SET();
                    if (iReg == 45) VDT.MSX_VDT_CMD_REG45_SET();
                    if (iReg == 46) VDT.MSX_VDT_CMD_REG46_SET();
                    if ((VDT.MSX_VDT_REG[17] & 128) == 0) //1[2]=10 -> Not Auto Increment
                    {
                        VDT.MSX_VDT_REG[17] = (byte)(iReg + 1); //1[2]=00 -> Auto Increment
                    };
                    VDT.Gi_MSX_Screen_Out = 1; //화면표시작업
                };
            };

          //PSG (AY-3-8910) - 카세트, 조이스틱 콘트롤, Sound 출력 기능
            if (iAddress == 0xA0) //Read Write Register 번호지정
            {
                MSX_PORT[iAddress] = iVal; //Reg(iVal)번을 포트(A0h)로 출력
            };
            if (iAddress == 0xA1) //지정된 Register로 기록
            {
                C = MSX_PORT[0xA0];
                if (C == 00) { PSG.MSX_PSG_REG[00] = iVal; PSG.MSX_PSG_REG_R00_WRITE(); };
                if (C == 01) { PSG.MSX_PSG_REG[01] = iVal; PSG.MSX_PSG_REG_R01_WRITE(); };
                if (C == 02) { PSG.MSX_PSG_REG[02] = iVal; PSG.MSX_PSG_REG_R02_WRITE(); };
                if (C == 03) { PSG.MSX_PSG_REG[03] = iVal; PSG.MSX_PSG_REG_R03_WRITE(); };
                if (C == 04) { PSG.MSX_PSG_REG[04] = iVal; PSG.MSX_PSG_REG_R04_WRITE(); };
                if (C == 05) { PSG.MSX_PSG_REG[05] = iVal; PSG.MSX_PSG_REG_R05_WRITE(); };
                if (C == 06) { PSG.MSX_PSG_REG[06] = iVal; PSG.MSX_PSG_REG_R06_WRITE(); };
                if (C == 07) { PSG.MSX_PSG_REG[07] = iVal; PSG.MSX_PSG_REG_R07_WRITE(); };
                if (C == 08) { PSG.MSX_PSG_REG[08] = iVal; PSG.MSX_PSG_REG_R08_WRITE(); };
                if (C == 09) { PSG.MSX_PSG_REG[09] = iVal; PSG.MSX_PSG_REG_R09_WRITE(); };
                if (C == 10) { PSG.MSX_PSG_REG[10] = iVal; PSG.MSX_PSG_REG_R10_WRITE(); };
                if (C == 11) { PSG.MSX_PSG_REG[11] = iVal; PSG.MSX_PSG_REG_R11_WRITE(); };
                if (C == 12) { PSG.MSX_PSG_REG[12] = iVal; PSG.MSX_PSG_REG_R12_WRITE(); };
                if (C == 13) { PSG.MSX_PSG_REG[13] = iVal; PSG.MSX_PSG_REG_R13_WRITE(); };
                if (C == 14) PSG.MSX_PSG_REG[14] = iVal; //I/O포트A(Read)
                if (C == 15) PSG.MSX_PSG_REG[15] = iVal; //I/O포트B(Write)
            };

          //PPI (8255A) - 카트리지, 키보드, 카세트 콘트롤, Sound 출력 기능
            if (iAddress == 0xA8) //PPI-register A / Primary slot select register
            {
                MEM.Gi_MEM_PAGE3 = (sbyte)((iVal & 192) >> 6); //7~6Bit
                MEM.Gi_MEM_PAGE2 = (sbyte)((iVal & 48) >> 4);  //5~4Bit
                MEM.Gi_MEM_PAGE1 = (sbyte)((iVal & 12) >> 2);  //3~2Bit
                MEM.Gi_MEM_PAGE0 = (sbyte)((iVal & 3));        //1~0Bit
            };
            if (iAddress == 0xAA) //PPI-register C / Keyboard and cassette interface
            {
                PPI.PUT_MSX_PPI_REG_C(iVal);
            };
            if (iAddress == 0xAB) //Mode Set / Command register : bit0<-1
            {
                iBit = (byte)((iVal & 14) >> 1); //5[3]
                if ((iVal & 1) == 1) //1[1]=1 Set
                {
                    PPI.PUT_MSX_PPI_REG_C((byte)((PPI.GET_MSX_PPI_REG_C() | TBL.Gi_B_Table[iBit])));
                }
                else //Res
                {
                    PPI.PUT_MSX_PPI_REG_C(((byte)(PPI.GET_MSX_PPI_REG_C() & TBL.Gi_NB_Table[iBit])));
                };
            };
         
          //MSX2 - Clock
            if (iAddress == 0xB4) //Clock Reg 지정
            {
                MSX_PORT[0xB4] = (byte)(iVal & 15);
            };
            if (iAddress == 0xB5) //지정된 Clock 블록+Reg 기록
            {
                C = MSX_PORT[0xB4];
                if (C <= 15) MSX_CLOCK_REG[(C <= 12 ? MSX_CLOCK_REG[0, 13] & 3 : 0), C] = iVal;
            };
              
          //MSX2 - Memory Mapper registers
            if (MSX.GiMSX2 == 1) //MSX2
            {
                if (iAddress == 0xFC)
                { 
                    MSX_PORT[0xFC] = iVal; 
                    MEM.MSX_MEMORY_CHANGE(0, iVal); //Memory Page0[2] Change
                };
                if (iAddress == 0xFD)
                { 
                    MSX_PORT[0xFD] = iVal; 
                    MEM.MSX_MEMORY_CHANGE(1, iVal); //Memory Page1[2] Change
                };
                if (iAddress == 0xFE)
                { 
                    MSX_PORT[0xFE] = iVal; 
                    MEM.MSX_MEMORY_CHANGE(2, iVal); //Memory Page2[2] Change
                };
                if (iAddress == 0xFF)
                { 
                    MSX_PORT[0xFF] = iVal; 
                    MEM.MSX_MEMORY_CHANGE(3, iVal); //Memory Page3[2] Change
                };
            };              
        }

        public static void MSX_VDT_ADDRESS_HIGH()
        {
            VDT.Go_MSX_VRAM_ADDRESS = (VDT.Go_MSX_VRAM_ADDRESS & 16383) + ((VDT.MSX_VDT_REG[14] & 7) * 16384); //Bit16~14, 3FFFh
        }

        public static void gt_PORT_IN_A(byte iPort)
        {
            Z80A.Z80A_REG_A = GET_MSX_PORT(iPort);
        }

        public static void gt_PORT_OUT_A(byte iPort)
        {
            PUT_MSX_PORT(iPort, Z80A.Z80A_REG_A);
        }

        public static void gt_PORT_IN(ref byte Reg8)
        {
            Z80A.PUT_Z80A_FLAG_N(0); //Not뺄셈
            Reg8 = GET_MSX_PORT(Z80A.Z80A_REG_C);
         // Z80A_FLAG_C = ?; //캐리
            Z80A.PUT_Z80A_FLAG_H(0); //Not하프캐리
            Z80A.PUT_Z80A_FLAG_PV(TBL.Gi_P_Table[Reg8]); //1:짝수,0:홀수
            Z80A.PUT_Z80A_FLAG_S(Z80A.giGet8Sign(Reg8)); //Sign
            Z80A.PUT_Z80A_FLAG_Z(Z80A.giGet8Zero(Reg8)); //Zero
        }

        public static void gt_PORT_OUT(byte Reg8)
        {
            PUT_MSX_PORT(Z80A.Z80A_REG_C, Reg8);
        }

        public static void gt_INI()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
            MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C));
            Z80A.PUT_Z80A_REG_HL((ushort)((Z80A.GET_Z80A_REG_HL() + 1) & 0xFFFF));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            Z80A.PUT_Z80A_FLAG_Z((sbyte)(Z80A.Z80A_REG_B == 0 ? 1 : 0)); //오버플로
        }

        public static void gt_INIR()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
        LoopProc: ;
            MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C));
            Z80A.PUT_Z80A_REG_HL((ushort)((Z80A.GET_Z80A_REG_HL() + 1) & 0xFFFF));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            if (Z80A.Z80A_REG_B != 0)
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            Z80A.PUT_Z80A_FLAG_Z(1); //Zero
        }

        public static void gt_IND()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
            MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C));
            Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            Z80A.PUT_Z80A_FLAG_Z((sbyte)(Z80A.Z80A_REG_B == 0 ? 1 : 0)); //오버플로
        }

        public static void gt_INDR()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
        LoopProc: ;
            MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), GET_MSX_PORT(Z80A.Z80A_REG_C));
            Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            if (Z80A.Z80A_REG_B != 0)
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            Z80A.PUT_Z80A_FLAG_Z(1); //Zero
        }

        public static void gt_OUTI()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
            PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
            Z80A.PUT_Z80A_REG_HL((ushort)((Z80A.GET_Z80A_REG_HL() + 1) & 0xFFFF));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            Z80A.PUT_Z80A_FLAG_Z((sbyte)(Z80A.Z80A_REG_B == 0 ? 1 : 0)); //오버플로
        }

        public static void gt_OTIR()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
        LoopProc: ;
            PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
            Z80A.PUT_Z80A_REG_HL((ushort)((Z80A.GET_Z80A_REG_HL() + 1) & 0xFFFF));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            if (Z80A.Z80A_REG_B != 0)
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            Z80A.PUT_Z80A_FLAG_Z(1); //Zero
        }

        public static void gt_OUTD()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
            PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
            Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            Z80A.PUT_Z80A_FLAG_Z((sbyte)(Z80A.Z80A_REG_B == 0 ? 1 : 0)); //오버플로
        }

        public static void gt_OTDR()
        {
            Z80A.PUT_Z80A_FLAG_N(1); //뺄셈
        LoopProc: ;
            PUT_MSX_PORT(Z80A.Z80A_REG_C, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
            Z80A.PUT_Z80A_REG_HL(Z80A.goGetLngToLng(Z80A.GET_Z80A_REG_HL() - 1));
            Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
            if (Z80A.Z80A_REG_B != 0)
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 21;
                goto LoopProc;
            }
            else
            {
                MSX.Gi_Z80A_CLOCK = MSX.Gi_Z80A_CLOCK + 16;
            };
            Z80A.PUT_Z80A_FLAG_Z(1); //Zero
        }
    }
}
