﻿namespace csMSX2
{
    public static class MEM
    {
      //메모리(0000h~FFFFh)
        public static byte[,] MSX_MEM = new byte[4, 65536]; //0~255 [0~3, 0~65535]

      //Memory Page
        public static sbyte Gi_MEM_PAGE0; //-128~127
        public static sbyte Gi_MEM_PAGE1;
        public static sbyte Gi_MEM_PAGE2;
        public static sbyte Gi_MEM_PAGE3;

      //MSX2 - 확장 Page
        public static sbyte Gi_MEM_EXT_PAGE0;
        public static sbyte Gi_MEM_EXT_PAGE1;
        public static sbyte Gi_MEM_EXT_PAGE2;
        public static sbyte Gi_MEM_EXT_PAGE3;

      //Mega ROM Slot#1
        public static byte[] MSX_ROM = new byte[4194304]; //0~255 [0~4194303(4MB)]
        public static sbyte Gi_Big32K_ROM;

      //MSX2 - Mapper Memory RAM Slot#2
        public static byte[] MSX_RAM = new byte[4194304]; //0~255 [0~4194303(4MB)]
        public static byte Gi_RAM_PAGE0;
        public static byte Gi_RAM_PAGE1;
        public static byte Gi_RAM_PAGE2;
        public static byte Gi_RAM_PAGE3;

        public static void MSX_INIT_MEM()
        {
            for (int i = 0; i <= 3; i++)
            {
                for (int j = 0; j <= 65535; j++)
                {
                    MSX_MEM[i, j] = 0;
                };
            };

            Gi_MEM_PAGE0 = 0;
            Gi_MEM_PAGE1 = 0;
            Gi_MEM_PAGE2 = 0;
            Gi_MEM_PAGE3 = 0;

            Gi_MEM_EXT_PAGE0 = 0;
            Gi_MEM_EXT_PAGE1 = 0;
            Gi_MEM_EXT_PAGE2 = 0;
            Gi_MEM_EXT_PAGE3 = 0;

            for (int i = 0; i <= 4194303; i++)
            {
                MSX_ROM[i] = 0;
            };
            
            Gi_Big32K_ROM = 0;

            for (int i = 0; i <= 4194303; i++)
            {
                MSX_RAM[i] = 0;
            };

            Gi_RAM_PAGE0 = 3;
            Gi_RAM_PAGE1 = 2;
            Gi_RAM_PAGE2 = 1;
            Gi_RAM_PAGE3 = 0;
        }
        
        public static byte GET_MSX_MEMORY_SLOT2(ushort oAddr)
        {
            if (MSX.GiMSX2 == 0) //MSX1
            {
                return MSX_MEM[2, oAddr];
            }
            else //MSX2
            {
                return GET_MSX_MEMORY_MAPPER(oAddr, -1);
            };
        }
        
        public static void PUT_MSX_MEMORY_SLOT2(ushort oAddr, byte iVal)
        {
            if (MSX.GiMSX2 == 0) //MSX1
            {
                MSX_MEM[2, oAddr] = iVal;
            }
            else //MSX2
            {
                PUT_MSX_MEMORY_MAPPER(oAddr, iVal, -1);
            };
        }

        public static byte GET_MSX_MEMORY(ushort oAddr)
        {
            byte iRet = 0;

            if ((oAddr >= 0) && (oAddr <= 16383)) //Page#0 [0000~3FFF]
            {
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE0 == 2)) //MSX2 Mapper RAM
                {
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 0);
                }
                else //RAM
                {
                    iRet = MSX_MEM[Gi_MEM_PAGE0, oAddr];
                };
            };

            if ((oAddr >= 16384) && (oAddr <= 32767)) //Page#1 [4000~7FFF]
            {
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE1 == 2)) //MSX2 Mapper RAM
                {
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 1);
                }
                else //RAM
                {
                    iRet = MSX_MEM[Gi_MEM_PAGE1, oAddr];
                };
            };

            if ((oAddr >= 32768) && (oAddr <= 49151)) //Page#2 [8000~BFFF]
            {
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE2 == 2)) //MSX2 Mapper RAM
                {
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 2);
                }
                else //RAM
                {
                    iRet = MSX_MEM[Gi_MEM_PAGE2, oAddr];
                };
            };

            if ((oAddr >= 49152) && (oAddr <= 65535)) //Page#3 [C000~FFFF]
            {
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE3 == 2)) //MSX2 Mapper RAM
                {
                    iRet = GET_MSX_MEMORY_MAPPER(oAddr, 3);
                }
                else //RAM
                {
                    iRet = MSX_MEM[Gi_MEM_PAGE3, oAddr];
                };
            };

            if (MSX.Gi_TEST == 1) //1:Test
            {
                if ((oAddr % 2.0) == 0)
                {
                    MSX.TEST_2_oAddr = oAddr;
                    MSX.TEST_2_iVal = iRet;
                }
                else
                {
                    MSX.TEST_3_oAddr = oAddr;
                    MSX.TEST_3_iVal = iRet;
                };
            };

            return iRet;
        }

        public static void PUT_MSX_MEMORY(ushort oAddr, byte iVal)
        {
            if (MSX.Gi_TEST == 1) //1:Test
            {
                if ((oAddr % 2.0) == 0)
                {
                    MSX.TEST_0_oAddr = oAddr;
                    MSX.TEST_0_iVal = iVal;
                }
                else
                {
                    MSX.TEST_1_oAddr = oAddr;
                    MSX.TEST_1_iVal = iVal;
                };
            };

            if (Gi_Big32K_ROM == 1) //Mega Rom Mapper
            {
                if (MSX.Gi_ROM_TYPE == 0)
                {
                  //Konami without SCC (a.k.a.Konami4) - [8KB]
                    if (Gi_MEM_PAGE1 == 1)
                    {
                        if ((oAddr >= 0x4000) && (oAddr <= 0x5FFF)) Move_Rom_To_Page_Konami4(1, iVal);
                        if ((oAddr >= 0x6000) && (oAddr <= 0x7FFF)) Move_Rom_To_Page_Konami4(2, iVal);
                    };
                    if (Gi_MEM_PAGE2 == 1)
                    {
                        if ((oAddr >= 0x8000) && (oAddr <= 0x9FFF)) Move_Rom_To_Page_Konami4(3, iVal);
                        if ((oAddr >= 0xA000) && (oAddr <= 0xBFFF)) Move_Rom_To_Page_Konami4(4, iVal);
                    };
                };
                if (MSX.Gi_ROM_TYPE == 1)
                {
                  //Konami with SCC (a.k.a.Konami5) - [8KB]
                    if (Gi_MEM_PAGE1 == 1)
                    {
                        if ((oAddr >= 0x5000) && (oAddr <= 0x57FF)) Move_Rom_To_Page_Konami5(1, iVal);
                        if ((oAddr >= 0x7000) && (oAddr <= 0x77FF)) Move_Rom_To_Page_Konami5(2, iVal);
                    };
                    if (Gi_MEM_PAGE2 == 1)
                    {
                        if ((oAddr >= 0x9000) && (oAddr <= 0x97FF)) Move_Rom_To_Page_Konami5(3, iVal);
                        if ((oAddr >= 0xB000) && (oAddr <= 0xB7FF)) Move_Rom_To_Page_Konami5(4, iVal);
                    };
                };
                if (MSX.Gi_ROM_TYPE == 2)
                {
                  //ASCII 8Kb - [8KB]
                    if (Gi_MEM_PAGE1 == 1)
                    {
                        if ((oAddr >= 0x6000) && (oAddr <= 0x67FF)) Move_Rom_To_Page_Ascii8(1, iVal);
                        if ((oAddr >= 0x6800) && (oAddr <= 0x6FFF)) Move_Rom_To_Page_Ascii8(2, iVal);
                        if ((oAddr >= 0x7000) && (oAddr <= 0x77FF)) Move_Rom_To_Page_Ascii8(3, iVal);
                        if ((oAddr >= 0x7800) && (oAddr <= 0x7FFF)) Move_Rom_To_Page_Ascii8(4, iVal);
                    };
                };
                if (MSX.Gi_ROM_TYPE == 3)
                {
                  //ASCII 16Kb - [16KB]
                    if (Gi_MEM_PAGE1 == 1)
                    {
                        if ((oAddr >= 0x6000) && (oAddr <= 0x67FF)) Move_Rom_To_Page_Ascii16(1, iVal);
                        if ((oAddr >= 0x7000) && (oAddr <= 0x77FF)) Move_Rom_To_Page_Ascii16(3, iVal);
                    };
                };
                if (MSX.Gi_ROM_TYPE == 4)
                {
                  //64-in-1 && 80-in-1 - [8KB]
                    if (Gi_MEM_PAGE1 == 1)
                    {
                        if (oAddr == 0x4000) Move_Rom_To_Page_80_in_1(1, iVal);
                        if (oAddr == 0x4001) Move_Rom_To_Page_80_in_1(2, iVal);
                        if (oAddr == 0x4002) Move_Rom_To_Page_80_in_1(3, iVal);
                        if (oAddr == 0x4003) Move_Rom_To_Page_80_in_1(4, iVal);
                    };
                };
                if (MSX.Gi_ROM_TYPE == 5)
                {
                  //126-in-1 - [16KB]
                    if (Gi_MEM_PAGE1 == 1)
                    {
                        if (oAddr == 0x4000) Move_Rom_To_Page_126_in_1(1, iVal);
                        if (oAddr == 0x4001) Move_Rom_To_Page_126_in_1(3, iVal);
                    };
                };
            };

            if ((oAddr >= 0) && (oAddr <= 16383)) //Page#0 [0000~3FFF]
            {
                if (Gi_MEM_PAGE0 == 0) goto ExitProc; //Slot#0 ROM
                if (Gi_MEM_PAGE0 == 1) goto ExitProc; //Slot#1 ROM
                if (Gi_MEM_PAGE0 == 3) goto ExitProc; //Slot#3 ROM
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE0 == 2)) //MSX2 Mapper RAM
                {
                    PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 0);
                }
                else //RAM
                {
                    if (Gi_MEM_PAGE0 == 2) MSX_MEM[Gi_MEM_PAGE0, oAddr] = iVal;
                };
            };

            if ((oAddr >= 16384) && (oAddr <= 32767)) //Page#1 [4000~7FFF]
            {
                if (Gi_MEM_PAGE1 == 0) goto ExitProc; //Slot#0 ROM
                if (Gi_MEM_PAGE1 == 1) goto ExitProc; //Slot#1 ROM
                if (Gi_MEM_PAGE1 == 3) goto ExitProc; //Slot#3 ROM
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE1 == 2)) //MSX2 Mapper RAM
                {
                    PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 1);
                }
                else //RAM
                {
                    if (Gi_MEM_PAGE1 == 2) MSX_MEM[Gi_MEM_PAGE1, oAddr] = iVal;
                };
            };

            if ((oAddr >= 32768) && (oAddr <= 49151)) //Page#2 [8000~BFFF]
            {
                if (Gi_MEM_PAGE2 == 0) goto ExitProc; //Slot#0 ROM
                if (Gi_MEM_PAGE2 == 1) goto ExitProc; //Slot#1 ROM
                if (Gi_MEM_PAGE2 == 3) goto ExitProc; //Slot#3 ROM
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE2 == 2)) //MSX2 Mapper RAM
                {
                    PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 2);
                }
                else //RAM
                {
                    if (Gi_MEM_PAGE2 == 2) MSX_MEM[Gi_MEM_PAGE2, oAddr] = iVal;
                };
            };

            if ((oAddr >= 49152) && (oAddr <= 65535)) //Page#3 [C000~FFFF]
            {
                if (Gi_MEM_PAGE3 == 0) goto ExitProc; //Slot#0 ROM
                if (Gi_MEM_PAGE3 == 1) goto ExitProc; //Slot#1 ROM
                if (Gi_MEM_PAGE3 == 3) goto ExitProc; //Slot#3 ROM
                if ((MSX.GiMSX2 == 1) && (Gi_MEM_PAGE3 == 2)) //MSX2 Mapper RAM
                {
                    PUT_MSX_MEMORY_MAPPER(oAddr, iVal, 3);
                }
                else //RAM
                {
                    if (Gi_MEM_PAGE3 == 2) MSX_MEM[Gi_MEM_PAGE3, oAddr] = iVal;     
                };
            };

       ExitProc: ;
       }

        public static ushort GET_MSX_MEMORY_16(ushort oAddr)
        {
            byte h = 0;
            byte l = 0;

            l = GET_MSX_MEMORY(oAddr); oAddr = (ushort)((oAddr + 1) & 0xFFFF);
            h = GET_MSX_MEMORY(oAddr);

            return (ushort)((h << 8) | l);
        }

        public static void PUT_MSX_MEMORY_16(ushort oAddr, ushort oVal)
        {
            byte h = (byte)(oVal >> 8);
            byte l = (byte)(oVal & 0x00FF);

            PUT_MSX_MEMORY(oAddr, l); oAddr = (ushort)((oAddr + 1) & 0xFFFF);
            PUT_MSX_MEMORY(oAddr, h);
        }
 
        public static void MSX_MEMORY_CHANGE(sbyte iPage, byte iSeg)
        {
            if (iPage == 0) Gi_RAM_PAGE0 = iSeg;
            if (iPage == 1) Gi_RAM_PAGE1 = iSeg;
            if (iPage == 2) Gi_RAM_PAGE2 = iSeg;
            if (iPage == 3) Gi_RAM_PAGE3 = iSeg;
        }

        public static byte GET_MSX_MEMORY_MAPPER(ushort oAddr, sbyte iPage)
        {
            byte iMapPage = 0;

            if (iPage == (-1))
            {
                if ((oAddr >= 0) && (oAddr <= 16383)) iPage = 0; //Page#0 [0000~3FFF]
                if ((oAddr >= 16384) && (oAddr <= 32767)) iPage = 1; //Page#1 [4000~7FFF]
                if ((oAddr >= 32768) && (oAddr <= 49151)) iPage = 2; //Page#2 [8000~BFFF]
                if ((oAddr >= 49152) && (oAddr <= 65535)) iPage = 3; //Page#3 [C000~FFFF]
            };

            if (iPage == 0) { oAddr = (ushort)(oAddr - 00000); iMapPage = Gi_RAM_PAGE0; }; //Page#0 (0000h~3FFFh)
            if (iPage == 1) { oAddr = (ushort)(oAddr - 16384); iMapPage = Gi_RAM_PAGE1; }; //Page#1 (4000h~7FFFh)
            if (iPage == 2) { oAddr = (ushort)(oAddr - 32768); iMapPage = Gi_RAM_PAGE2; }; //Page#2 (8000h~BFFFh)
            if (iPage == 3) { oAddr = (ushort)(oAddr - 49152); iMapPage = Gi_RAM_PAGE3; }; //Page#3 (C000h~FFFFh)

            return MSX_RAM[oAddr + TBL.Go_M_Table16384[iMapPage]]; //4000h
        }

        public static void PUT_MSX_MEMORY_MAPPER(ushort oAddr, byte iVal, sbyte iPage)
        {
            byte iMapPage = 0;

            if (iPage == (-1))
            {
                if ((oAddr >= 0) && (oAddr <= 16383)) iPage = 0; //Page#0 [0000~3FFF]
                if ((oAddr >= 16384) && (oAddr <= 32767)) iPage = 1; //Page#1 [4000~7FFF]
                if ((oAddr >= 32768) && (oAddr <= 49151)) iPage = 2; //Page#2 [8000~BFFF]
                if ((oAddr >= 49152) && (oAddr <= 65535)) iPage = 3; //Page#3 [C000~FFFF]
            };

            if (iPage == 0) { oAddr = (ushort)(oAddr - 00000); iMapPage = Gi_RAM_PAGE0; }; //Page#0 (0000h~3FFFh)
            if (iPage == 1) { oAddr = (ushort)(oAddr - 16384); iMapPage = Gi_RAM_PAGE1; }; //Page#1 (4000h~7FFFh)
            if (iPage == 2) { oAddr = (ushort)(oAddr - 32768); iMapPage = Gi_RAM_PAGE2; }; //Page#2 (8000h~BFFFh)
            if (iPage == 3) { oAddr = (ushort)(oAddr - 49152); iMapPage = Gi_RAM_PAGE3; }; //Page#3 (C000h~FFFFh)

            MSX_RAM[oAddr + TBL.Go_M_Table16384[iMapPage]] = iVal; //4000h
        }

      //Konami without SCC (a.k.a.Konami4)
      //8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
      //Chg - Bank1:None, Bank2:6000h~7FFFh(6000h), Bank3:8000h~9FFFh(8000h), Bank4:A000h~BFFFh(A000h)
        public static void Move_Rom_To_Page_Konami4(sbyte iBank, byte iPage)
        {
            int oAddr, oRom;

            oAddr = foGetBankAddress8(iBank);
            oRom = foGetPageAddress8(iPage);

            for (int i = 0; i <= 8191; i++) MSX_MEM[1, oAddr + i] = MSX_ROM[oRom + i]; //0000h~1FFFh
        }

      //Konami with SCC (a.k.a.Konami5)
      //8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
      //Chg - Bank1:5000h~57FFh(5000h), Bank2:7000h~77FFh(7000h), Bank3:9000h~97FFh(9000h), Bank4:B000h~B7FFh(B000h)
        public static void Move_Rom_To_Page_Konami5(sbyte iBank, byte iPage)
        {
            int oAddr, oRom;

            oAddr = foGetBankAddress8(iBank);
            oRom = foGetPageAddress8(iPage);

            for (int i = 0; i <=8191; i++) MSX_MEM[1, oAddr + i] = MSX_ROM[oRom + i]; //0000h~1FFFh
        }
             
      //ASCII 8Kb
      //8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
      //Chg - Bank1:6000h~67FFh(6000h), Bank2:6800h~6FFFh(6800h), Bank3:7000h~77FFh(7000h), Bank4:7800h~7FFFh(7800h)
        public static void Move_Rom_To_Page_Ascii8(sbyte iBank, byte iPage)
        {
            int oAddr, oRom;

            oAddr = foGetBankAddress8(iBank);
            oRom = foGetPageAddress8(iPage);

            for (int i = 0; i <= 8191; i++) MSX_MEM[1, oAddr + i] = MSX_ROM[oRom + i]; //0000h~1FFFh
        }
             
      //ASCII 16Kb
      //16Kb - Bank1:4000h~7FFFh, Bank3:8000h~BFFFh
      //Chg - Bank1:6000h~67FFh(6000h), Bank3:7000h~77FFh(7000h+77FFh)
        public static void Move_Rom_To_Page_Ascii16(sbyte iBank, byte iPage)
        {
            int oAddr, oRom;

            oAddr = foGetBankAddress8(iBank);
            oRom = foGetPageAddress16(iPage);

            for (int i = 0; i <= 16383; i++) MSX_MEM[1, oAddr + i] = MSX_ROM[oRom + i]; //0000h~3FFFh
        }

      //64-in-1 and 80-in-1
      //8Kb - Bank1:4000h~5FFFh, Bank2:6000h~7FFFh, Bank3:8000h~9FFFh, Bank4:A000h~BFFFh
      //Chg - Bank1:(4000h), Bank2:(4001h), Bank3:(4002h), Bank4:(4003h)
        public static void Move_Rom_To_Page_80_in_1(sbyte iBank, byte iPage)
        {
            int oAddr, oRom;

            oAddr = foGetBankAddress8(iBank);
            oRom = foGetPageAddress8(iPage);

            for (int i = 0; i <= 8191; i++) MSX_MEM[1, oAddr + i] = MSX_ROM[oRom + i]; //0000h~1FFFh
        }

      //126-in-1
      //16Kb - Bank1:4000h~7FFFh, Bank3:8000h~BFFFh
      //Chg - Bank1:(4000h), Bank3:(4001h)
        public static void Move_Rom_To_Page_126_in_1(sbyte iBank, byte iPage)
        {
            int oAddr, oRom;

            oAddr = foGetBankAddress8(iBank);
            oRom = foGetPageAddress16(iPage);

            for (int i = 0; i <= 16383; i++) MSX_MEM[1, oAddr + i] = MSX_ROM[oRom + i]; //0000h~3FFFh
        }

        public static int foGetBankAddress8(sbyte iBank)
        { 
            int R;
  
            R = 0;
            if (iBank == 1) R = 0x4000;
            if (iBank == 2) R = 0x6000;
            if (iBank == 3) R = 0x8000;
            if (iBank == 4) R = 0xA000;
  
           return R;
        }

        public static int foGetPageAddress8(byte iPage)
        {
            return (iPage * 8192); //2000h
        }

        public static int foGetPageAddress16(byte iPage)
        {
            return (iPage * 16384); //4000h
        }
    }
}
