﻿namespace csMSX2
{
    public static class MI
    {
        public static void EXEC_Z80A_CODE()
        {
            byte idx; //0~255
            byte iSz;
            byte Reg8 = 0;
            ushort Reg16 = 0;
            ushort PC1p;

            Z80A.Z80A_REG_R++; Z80A.Z80A_REG_R = (byte)(Z80A.Z80A_REG_R & 127); //0111 1111

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC);
            iSz = 1;

            PC1p = (ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF);

            switch (idx)
            {
                case 0x00: //NOP
                    MSX.Gi_Z80A_CLOCK = 4;
                    INT.gt_NOP();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x01: //LD BC,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.PUT_Z80A_REG_BC(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x02: //LD (BC),A
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_BC(), Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x03: //INC BC
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_INC_16TO8(Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x04: //INC B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x05: //DEC B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x06: //LD B,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x07: //RLCA
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_RLCA();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x08: //EX AF,AF
                    MSX.Gi_Z80A_CLOCK = 4;
                    Reg8 = Z80A.Z80A_REG_A; Z80A.Z80A_REG_A = Z80A.Z80A_REG_A2; Z80A.Z80A_REG_A2 = Reg8;
                    Reg8 = Z80A.Z80A_REG_F; Z80A.Z80A_REG_F = Z80A.Z80A_REG_F2; Z80A.Z80A_REG_F2 = Reg8;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x09: //ADD HL,BC
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x0A: //LD A,(BC)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_BC());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x0B: //DEC BC
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_DEC_16TO8(Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x0C: //INC C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x0D: //DEC C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x0E: //LD C,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x0F: //RRCA
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_RRCA();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x10: //DJNZ idx
                    iSz = 2;
                    Z80A.Z80A_REG_B = Z80A.giGetIntToInt(Z80A.Z80A_REG_B - 1);
                    if (Z80A.Z80A_REG_B != 0)
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)));
                        MSX.Gi_Z80A_CLOCK = 13;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 8;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0x11: //LD DE,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.PUT_Z80A_REG_DE(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x12: //LD (DE),A
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_DE(), Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x13: //INC DE
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_INC_16TO8(Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x14: //INC D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x15: //DEC D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x16: //LD D,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x17: //RLA
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_RLA();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x18: //JR idx
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 12;
                    Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)));
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0x19: //ADD HL,DE
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x1A: //LD A,(DE)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_DE());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x1B: //DEC DE
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_DEC_16TO8(Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x1C: //INC E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x1D: //DEC E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x1E: //LD E,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x1F: //RRA
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_RRA();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x20: //JR NZ,idx
                    iSz = 2;
                    if (Z80A.GET_Z80A_FLAG_Z() == 0)
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)));
                        MSX.Gi_Z80A_CLOCK = 12;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 7;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0x21: //LD HL,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.PUT_Z80A_REG_HL(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x22: //LD (nn),HL
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 16;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x23: //INC HL
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_INC_16TO8(Z80A.GET_Z80A_REG_HL(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x24: //INC H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x25: //DEC H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x26: //LD H,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x27: //DAA
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DAA();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x28: //JR Z,idx
                    iSz = 2;
                    if (Z80A.GET_Z80A_FLAG_Z() == 1)
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)));
                        MSX.Gi_Z80A_CLOCK = 12;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 7;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0x29: //ADD HL,HL
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_HL(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x2A: //LD HL,(nn)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 16;
                    Z80A.PUT_Z80A_REG_HL(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x2B: //DEC HL
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_DEC_16TO8(Z80A.GET_Z80A_REG_HL(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x2C: //INC L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x2D: //DEC L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x2E: //LD L,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x2F: //CPL
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CPL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x30: //JR NC,idx
                    iSz = 2;
                    if (Z80A.GET_Z80A_FLAG_C() == 0)
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)));
                        MSX.Gi_Z80A_CLOCK = 12;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 7;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0x31: //LD SP,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.Z80A_REG_SP = MEM.GET_MSX_MEMORY_16(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x32: //LD (nn),A
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 13;
                    MEM.PUT_MSX_MEMORY(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x33: //INC SP
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_INC_16TO16(Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_SP);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x34: //INC (HL)
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_INC_8TO8(MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x35: //DEC (HL)
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_DEC_8TO8(MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x36: //LD (HL),n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 10;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x37: //SCF
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SCF();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x38: //JR C,idx
                    iSz = 2;
                    if (Z80A.GET_Z80A_FLAG_C() == 1)
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY(PC1p)));
                        MSX.Gi_Z80A_CLOCK = 12;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 7;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0x39: //ADD HL,SP
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x3A: //LD A,(nn)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 13;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x3B: //DEC SP
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.gt_DEC_16TO16(Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_SP);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x3C: //INC A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_INC_8TO8(Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x3D: //DEC A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_DEC_8TO8(Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x3E: //LD A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x3F: //CCF
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CCF();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x40: //LD B,B
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_B = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x41: //LD B,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x42: //LD B,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x43: //LD B,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x44: //LD B,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x45: //LD B,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x46: //LD B,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x47: //LD B,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_B = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x48: //LD C,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x49: //LD C,C
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_C = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x4A: //LD C,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x4B: //LD C,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x4C: //LD C,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x4D: //LD C,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x4E: //LD C,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x4F: //LD C,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_C = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x50: //LD D,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x51: //LD D,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x52: //LD D,D
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_D = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x53: //LD D,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x54: //LD D,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x55: //LD D,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x56: //LD D,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x57: //LD D,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_D = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x58: //LD E,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x59: //LD E,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x5A: //LD E,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x5B: //LD E,E
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_E = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x5C: //LD E,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x5D: //LD E,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x5E: //LD E,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x5F: //LD E,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_E = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x60: //LD H,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x61: //LD H,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x62: //LD H,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x63: //LD H,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x64: //LD H,H
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_H = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x65: //LD H,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x66: //LD H,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x67: //LD H,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_H = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x68: //LD L,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x69: //LD L,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x6A: //LD L,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x6B: //LD L,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x6C: //LD L,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x6D: //LD L,L
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_L = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x6E: //LD L,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x6F: //LD L,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_L = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x70: //LD (HL),B
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x71: //LD (HL),C
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x72: //LD (HL),D
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x73: //LD (HL),E
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x74: //LD (HL),H
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x75: //LD (HL),L
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x76: //HALT
                    INT.gt_HALT();
                    if (INT.Z80A_HALT == 0)
                    {
                        MSX.Gi_Z80A_CLOCK = 4;
                        Z80A.EXEC_Z80A_ADD_PC(0, iSz);
                    }
                    else
                    {
                        INT.Z80A_HALT = 0;
                        MSX.Gi_Z80A_CLOCK = 4;
                        Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    };
                    break;
                case 0x77: //LD (HL),A
                    MSX.Gi_Z80A_CLOCK = 7;
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x78: //LD A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_B;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x79: //LD A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_C;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x7A: //LD A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_D;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x7B: //LD A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_E;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x7C: //LD A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_H;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x7D: //LD A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_A = Z80A.Z80A_REG_L;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x7E: //LD A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x7F: //LD A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                  //Z80A.Z80A_REG_A = Z80A.Z80A_REG_A;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x80: //ADD A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x81: //ADD A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x82: //ADD A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x83: //ADD A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x84: //ADD A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x85: //ADD A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x86: //ADD A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x87: //ADD A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x88: //ADC A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x89: //ADC A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x8A: //ADC A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x8B: //ADC A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x8C: //ADC A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x8D: //ADC A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x8E: //ADC A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x8F: //ADC A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x90: //SUB A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x91: //SUB A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x92: //SUB A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x93: //SUB A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x94: //SUB A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x95: //SUB A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x96: //SUB A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x97: //SUB A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x98: //SBC A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x99: //SBC A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x9A: //SBC A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x9B: //SBC A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x9C: //SBC A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x9D: //SBC A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x9E: //SBC A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0x9F: //SBC A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA0: //AND A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA1: //AND A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA2: //AND A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA3: //AND A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA4: //AND A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA5: //AND A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA6: //AND A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA7: //AND A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA8: //XOR A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xA9: //XOR A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xAA: //XOR A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xAB: //XOR A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xAC: //XOR A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xAD: //XOR A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xAE: //XOR A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xAF: //XOR A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB0: //OR A,B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB1: //OR A,C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_C, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB2: //OR A,D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB3: //OR A,E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_E, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB4: //OR A,H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB5: //OR A,L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_L, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB6: //OR A,(HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB7: //OR A,A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB8: //CP B
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xB9: //CP C
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xBA: //CP D
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xBB: //CP E
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xBC: //CP H
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xBD: //CP L
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xBE: //CP (HL)
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xBF: //CP A
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.gt_CP(Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xC0: //RET NZ
                    if (Z80A.GET_Z80A_FLAG_Z() == 0)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xC1: //POP BC
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_POP_16TO2(ref Z80A.Z80A_REG_B, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xC2: //JP NZ,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_Z() == 0)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xC3: //JP nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xC4: //CALL NZ,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_Z() == 0)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xC5: //PUSH BC
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_BC());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xC6: //ADD A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xC7: //RST 00H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_00();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xC8: //RET Z
                    if (Z80A.GET_Z80A_FLAG_Z() == 1)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xC9: //RET
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xCA: //JP Z,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_Z() == 1)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xCB: //CB - Bit instructions
                    Z80A.Z80A_REG_R++; Z80A.Z80A_REG_R = (byte)(Z80A.Z80A_REG_R & 127); //0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0);
                    MICB.EXEC_Z80A_CODE_CB();
                    break;
                case 0xCC: //CALL Z,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_Z() == 1)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xCD: //CALL nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 17;
                    Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                    Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xCE: //ADC A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xCF: //RST 08H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_08();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xD0: //RET NC
                    if (Z80A.GET_Z80A_FLAG_C() == 0)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xD1: //POP DE
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_POP_16TO2(ref Z80A.Z80A_REG_D, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xD2: //JP NC,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_C() == 0)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xD3: //OUT (p),A
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 11;
                    IO.gt_PORT_OUT_A(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xD4: //CALL NC,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_C() == 0)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xD5: //PUSH DE
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_DE());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xD6: //SUB A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xD7: //RST 10H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_10();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xD8: //RET C
                    if (Z80A.GET_Z80A_FLAG_C() == 1)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xD9: //EXX
                    MSX.Gi_Z80A_CLOCK = 4;
                    Reg8 = Z80A.Z80A_REG_B; Z80A.Z80A_REG_B = Z80A.Z80A_REG_B2; Z80A.Z80A_REG_B2 = Reg8;
                    Reg8 = Z80A.Z80A_REG_C; Z80A.Z80A_REG_C = Z80A.Z80A_REG_C2; Z80A.Z80A_REG_C2 = Reg8;
                    Reg8 = Z80A.Z80A_REG_D; Z80A.Z80A_REG_D = Z80A.Z80A_REG_D2; Z80A.Z80A_REG_D2 = Reg8;
                    Reg8 = Z80A.Z80A_REG_E; Z80A.Z80A_REG_E = Z80A.Z80A_REG_E2; Z80A.Z80A_REG_E2 = Reg8;
                    Reg8 = Z80A.Z80A_REG_H; Z80A.Z80A_REG_H = Z80A.Z80A_REG_H2; Z80A.Z80A_REG_H2 = Reg8;
                    Reg8 = Z80A.Z80A_REG_L; Z80A.Z80A_REG_L = Z80A.Z80A_REG_L2; Z80A.Z80A_REG_L2 = Reg8;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xDA: //JP C,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_C() == 1)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xDB: //IN A,(p)
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 11;
                    IO.gt_PORT_IN_A(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xDC: //CALL C,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_C() == 1)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xDD: //DD - IX instructions
                    Z80A.Z80A_REG_R++; Z80A.Z80A_REG_R = (byte)(Z80A.Z80A_REG_R & 127); //0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0);
                    MIDD.EXEC_Z80A_CODE_DD();
                    break;
                case 0xDE: //SBC A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xDF: //RST 18H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_18();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xE0: //RET PO
                    if (Z80A.GET_Z80A_FLAG_PV() == 0)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xE1: //POP HL
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_POP_16TO2(ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xE2: //JP PO,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_PV() == 0)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xE3: //EX (SP),HL
                    MSX.Gi_Z80A_CLOCK = 19;
                    Reg16 = MEM.GET_MSX_MEMORY_16(Z80A.Z80A_REG_SP);
                    MEM.PUT_MSX_MEMORY_16(Z80A.Z80A_REG_SP, Z80A.GET_Z80A_REG_HL());
                    Z80A.PUT_Z80A_REG_HL(Reg16);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xE4: //CALL PO,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_PV() == 0)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xE5: //PUSH HL
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xE6: //AND A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xE7: //RST 20H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_20();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xE8: //RET PE
                    if (Z80A.GET_Z80A_FLAG_PV() == 1)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xE9: //JP (HL)
                    MSX.Gi_Z80A_CLOCK = 4;
                    Z80A.Z80A_REG_PC = Z80A.GET_Z80A_REG_HL(); //PC<-HL
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xEA: //JP PE,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_PV() == 1)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xEB: //EX DE,HL
                    MSX.Gi_Z80A_CLOCK = 4;
                    Reg8 = Z80A.Z80A_REG_D; Z80A.Z80A_REG_D = Z80A.Z80A_REG_H; Z80A.Z80A_REG_H = Reg8;
                    Reg8 = Z80A.Z80A_REG_E; Z80A.Z80A_REG_E = Z80A.Z80A_REG_L; Z80A.Z80A_REG_L = Reg8;
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xEC: //CALL PE,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_PV() == 1)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xED: //ED - Extended instructions
                    Z80A.Z80A_REG_R++; Z80A.Z80A_REG_R = (byte)(Z80A.Z80A_REG_R & 127); //0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0);
                    MIED.EXEC_Z80A_CODE_ED();
                    break;
                case 0xEE: //XOR A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xEF: //RST 28H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_28();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xF0: //RET P
                    if (Z80A.GET_Z80A_FLAG_S() == 0)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xF1: //POP AF
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_POP_16TO2(ref Z80A.Z80A_REG_A, ref Z80A.Z80A_REG_F);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xF2: //JP P,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_S() == 0)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xF3: //DI
                    MSX.Gi_Z80A_CLOCK = 4;
                    INT.gt_DI();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xF4: //CALL P,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_S() == 0)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xF5: //PUSH AF
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.gt_PUSH_16(Z80A.GET_Z80A_REG_AF());
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xF6: //OR A,n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(PC1p), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xF7: //RST 30H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_30();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xF8: //RET M
                    if (Z80A.GET_Z80A_FLAG_S() == 1)
                    {
                        Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                        MSX.Gi_Z80A_CLOCK = 11;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 5;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                case 0xF9: //LD SP,HL
                    MSX.Gi_Z80A_CLOCK = 6;
                    Z80A.Z80A_REG_SP = Z80A.GET_Z80A_REG_HL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xFA: //JP M,nn
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 10;
                    if (Z80A.GET_Z80A_FLAG_S() == 1)
                    {
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xFB: //EI
                    MSX.Gi_Z80A_CLOCK = 4;
                    INT.gt_EI();
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xFC: //CALL M,nn
                    iSz = 3;
                    if (Z80A.GET_Z80A_FLAG_S() == 1)
                    {
                        Z80A.gt_PUSH_16(Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz));
                        Z80A.Z80A_REG_PC = MEM.GET_MSX_MEMORY_16(PC1p);
                        MSX.Gi_Z80A_CLOCK = 17;
                    }
                    else
                    {
                        Z80A.Z80A_REG_PC = Z80A.goGetLngToLng(Z80A.Z80A_REG_PC + iSz);
                        MSX.Gi_Z80A_CLOCK = 10;
                    };
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //3
                    break;
                case 0xFD: //FD - IY instruction
                    Z80A.Z80A_REG_R++; Z80A.Z80A_REG_R = (byte)(Z80A.Z80A_REG_R & 127); //0111 1111
                    Z80A.EXEC_Z80A_ADD_PC(1, 0);
                    MIFD.EXEC_Z80A_CODE_FD();
                    break;
                case 0xFE: //CP n
                    iSz = 2;
                    MSX.Gi_Z80A_CLOCK = 7;
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz, 0);
                    break;
                case 0xFF: //RST 38H
                    MSX.Gi_Z80A_CLOCK = 11;
                    INT.gt_RST_38();
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //1
                    break;
                default: //실행안됨
                    break;
            };
        }
    }
}
