﻿namespace csMSX2
{
    public static class MICB
    {
        public static void EXEC_Z80A_CODE_CB()
        {
            byte idx; //0~255
            byte iSz;
            byte Reg8 = 0;
 
            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC);
            iSz = 2;

            MSX.Gi_Z80A_CLOCK = 8;

            switch (idx)
            {
                case 0x00: //RLC B
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_B, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x01: //RLC C                     
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_C, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x02: //RLC D                    
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_D, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x03: //RLC E                   
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_E, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x04: //RLC H                    
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_H, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x05: //RLC L                    
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x06: //RLC (HL)                    
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RLC(ref Reg8, 0);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x07: //RLC A                     
                    Z80A.gt_RLC(ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x08: //RRC B                     
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_B, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x09: //RRC C
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_C, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x0A: //RRC D                     
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_D, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x0B: //RRC E                     
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_E, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x0C: //RRC H                     
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_H, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x0D: //RRC L                     
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x0E: //RRC (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RRC(ref Reg8, 0);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x0F: //RRC A                     
                    Z80A.gt_RRC(ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x10: //RL B                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_B, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x11: //RL C                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_C, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x12: //RL D                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_D, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x13: //RL E                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_E, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x14: //RL H                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_H, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x15: //RL L                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x16: //RL (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RL(ref Reg8, 0);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x17: //RL A                     
                    Z80A.gt_RL(ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x18: //RR B                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_B, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x19: //RR C                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_C, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x1A: //RR D                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_D, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x1B: //RR E                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_E, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x1C: //RR H                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_H, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x1D: //RR L                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_L, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x1E: //RR (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RR(ref Reg8, 0);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x1F: //RR A                     
                    Z80A.gt_RR(ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x20: //SLA B                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x21: //SLA C                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x22: //SLA D                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x23: //SLA E                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x24: //SLA H                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x25: //SLA L                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x26: //SLA (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SLA(ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x27: //SLA A                     
                    Z80A.gt_SLA(ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x28: //SRA B                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x29: //SRA C                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2A: //SRA D                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2B: //SRA E                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2C: //SRA H                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2D: //SRA L                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2E: //SRA (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SRA(ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2F: //SRA A                     
                    Z80A.gt_SRA(ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x30: //SLL B '@@@@@ SLL,SLS                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x31: //SLL C '@@@@@                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x32: //SLL D '@@@@@                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x33: //SLL E '@@@@@                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x34: //SLL H '@@@@@                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x35: //SLL L '@@@@@                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x36: //SLL (HL) '@@@@@                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SLL(ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x37: //SLL A '@@@@@                     
                    Z80A.gt_SLL(ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x38: //SRL B                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x39: //SRL C                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x3A: //SRL D                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x3B: //SRL E                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x3C: //SRL H                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x3D: //SRL L                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x3E: //SRL (HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SRL(ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x3F: //SRL A                     
                    Z80A.gt_SRL(ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x40: //BIT 0,B                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x41: //BIT 0,C                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x42: //BIT 0,D                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x43: //BIT 0,E                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x44: //BIT 0,H                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x45: //BIT 0,L                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x46: //BIT 0,(HL)                     
                    Z80A.gt_BIT(0, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x47: //BIT 0,A                     
                    Z80A.gt_BIT(0, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x48: //BIT 1,B                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x49: //BIT 1,C                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4A: //BIT 1,D                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4B: //BIT 1,E                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4C: //BIT 1,H                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4D: //BIT 1,L                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4E: //BIT 1,(HL)                     
                    Z80A.gt_BIT(1, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4F: //BIT 1,A                     
                    Z80A.gt_BIT(1, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x50: //BIT 2,B                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x51: //BIT 2,C                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x52: //BIT 2,D                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x53: //BIT 2,E                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x54: //BIT 2,H                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x55: //BIT 2,L                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x56: //BIT 2,(HL)                     
                    Z80A.gt_BIT(2, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x57: //BIT 2,A                     
                    Z80A.gt_BIT(2, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x58: //BIT 3,B                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x59: //BIT 3,C                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5A: //BIT 3,D                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5B: //BIT 3,E                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5C: //BIT 3,H                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5D: //BIT 3,L                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5E: //BIT 3,(HL)                     
                    Z80A.gt_BIT(3, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5F: //BIT 3,A                     
                    Z80A.gt_BIT(3, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x60: //BIT 4,B                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x61: //BIT 4,C                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x62: //BIT 4,D                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x63: //BIT 4,E                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x64: //BIT 4,H                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x65: //BIT 4,L                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x66: //BIT 4,(HL)                     
                    Z80A.gt_BIT(4, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x67: //BIT 4,A                     
                    Z80A.gt_BIT(4, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x68: //BIT 5,B                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x69: //BIT 5,C                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6A: //BIT 5,D                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6B: //BIT 5,E                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6C: //BIT 5,H                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6D: //BIT 5,L                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6E: //BIT 5,(HL)                     
                    Z80A.gt_BIT(5, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6F: //BIT 5,A                     
                    Z80A.gt_BIT(5, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x70: //BIT 6,B                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x71: //BIT 6,C                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x72: //BIT 6,D                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x73: //BIT 6,E                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x74: //BIT 6,H                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x75: //BIT 6,L                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x76: //BIT 6,(HL)                     
                    Z80A.gt_BIT(6, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x77: //BIT 6,A                     
                    Z80A.gt_BIT(6, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x78: //BIT 7,B                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x79: //BIT 7,C                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7A: //BIT 7,D                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7B: //BIT 7,E                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7C: //BIT 7,H
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7D: //BIT 7,L                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7E: //BIT 7,(HL)                     
                    Z80A.gt_BIT(7, MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL()));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7F: //BIT 7,A                     
                    Z80A.gt_BIT(7, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x80: //RES 0,B                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x81: //RES 0,C                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x82: //RES 0,D                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x83: //RES 0,E                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x84: //RES 0,H                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x85: //RES 0,L                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x86: //RES 0,(HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(0, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x87: //RES 0,A                     
                    Z80A.gt_RES(0, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x88: //RES 1,B                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x89: //RES 1,C                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8A: //RES 1,D                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8B: //RES 1,E                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8C: //RES 1,H                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8D: //RES 1,L                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8E: //RES 1,(HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(1, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8F: //RES 1,A                     
                    Z80A.gt_RES(1, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x90: //RES 2,B                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x91: //RES 2,C                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x92: //RES 2,D                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x93: //RES 2,E                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x94: //RES 2,H                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x95: //RES 2,L                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x96: //RES 2,(HL)                     
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(2, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x97: //RES 2,A                     
                    Z80A.gt_RES(2, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x98: //RES 3,B                     
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x99: //RES 3,C                     
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9A: //RES 3,D                     
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9B: //RES 3,E                     
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9C: //RES 3,H
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9D: //RES 3,L
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9E: //RES 3,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(3, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9F: //RES 3,A
                    Z80A.gt_RES(3, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA0: //RES 4,B
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA1: //RES 4,C
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA2: //RES 4,D
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA3: //RES 4,E
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA4: //RES 4,H
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA5: //RES 4,L
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA6: //RES 4,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(4, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA7: //RES 4,A
                    Z80A.gt_RES(4, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA8: //RES 5,B
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA9: //RES 5,C
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAA: //RES 5,D
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAB: //RES 5,E
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAC: //RES 5,H
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAD: //RES 5,L
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAE: //RES 5,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(5, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAF: //RES 5,A
                    Z80A.gt_RES(5, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB0: //RES 6,B
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB1: //RES 6,C
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB2: //RES 6,D
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB3: //RES 6,E
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB4: //RES 6,H
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB5: //RES 6,L
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB6: //RES 6,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(6, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB7: //RES 6,A
                    Z80A.gt_RES(6, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB8: //RES 7,B
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB9: //RES 7,C
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBA: //RES 7,D
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBB: //RES 7,E
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBC: //RES 7,H
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBD: //RES 7,L
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBE: //RES 7,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_RES(7, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBF: //RES 7,A
                    Z80A.gt_RES(7, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC0: //SET 0,B
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC1: //SET 0,C
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC2: //SET 0,D
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC3: //SET 0,E
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC4: //SET 0,H
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC5: //SET 0,L
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC6: //SET 0,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(0, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC7: //SET 0,A
                    Z80A.gt_SET(0, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC8: //SET 1,B
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xC9: //SET 1,C
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCA: //SET 1,D
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCB: //SET 1,E
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCC: //SET 1,H
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCD: //SET 1,L
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCE: //SET 1,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(1, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCF: //SET 1,A
                    Z80A.gt_SET(1, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD0: //SET 2,B
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD1: //SET 2,C
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD2: //SET 2,D
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD3: //SET 2,E
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD4: //SET 2,H
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD5: //SET 2,L
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD6: //SET 2,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(2, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD7: //SET 2,A
                    Z80A.gt_SET(2, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD8: //SET 3,B
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xD9: //SET 3,C
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xDA: //SET 3,D
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xDB: //SET 3,E
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xDC: //SET 3,H
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xDD: //SET 3,L
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xDE: //SET 3,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(3, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xDF: //SET 3,A
                    Z80A.gt_SET(3, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE0: //SET 4,B
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE1: //SET 4,C
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE2: //SET 4,D
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE3: //SET 4,E
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE4: //SET 4,H
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE5: //SET 4,L
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE6: //SET 4,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(4, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE7: //SET 4,A
                    Z80A.gt_SET(4, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE8: //SET 5,B
                    Z80A.gt_SET(5, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE9: //SET 5,C
                    Z80A.gt_SET(5, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xEA: //SET 5,D
                    Z80A.gt_SET(5, ref  Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xEB: //SET 5,E
                    Z80A.gt_SET(5, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xEC: //SET 5,H
                    Z80A.gt_SET(5, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xED: //SET 5,L
                    Z80A.gt_SET(5, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xEE: //SET 5,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(5, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xEF: //SET 5,A
                    Z80A.gt_SET(5, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF0: //SET 6,B
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF1: //SET 6,C
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF2: //SET 6,D
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF3: //SET 6,E
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF4: //SET 6,H
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF5: //SET 6,L
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF6: //SET 6,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(6, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF7: //SET 6,A
                    Z80A.gt_SET(6, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF8: //SET 7,B
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xF9: //SET 7,C
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xFA: //SET 7,D
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xFB: //SET 7,E
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xFC: //SET 7,H
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xFD: //SET 7,L
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xFE: //SET 7,(HL)
                    Reg8 = MEM.GET_MSX_MEMORY(Z80A.GET_Z80A_REG_HL());
                    Z80A.gt_SET(7, ref Reg8);
                    MEM.PUT_MSX_MEMORY(Z80A.GET_Z80A_REG_HL(), Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xFF: //SET 7,A
                    Z80A.gt_SET(7, ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                default: //실행안됨
                    break;
            };
        }
    }
}
