﻿namespace csMSX2
{
    public static class MIDD
    {
        public static void EXEC_Z80A_CODE_DD()
        {
            byte idx; //0~255
            byte iSz;
            byte Reg8 = 0;
            ushort Reg16 = 0;
            ushort GetIxyIdx;
            ushort PC1p;
            ushort PC2p;

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC);
            iSz = 2;

            GetIxyIdx = Z80A.goGetLngToLng(Z80A.Z80A_REG_IX + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY((ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF))));
            PC1p = (ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF);
            PC2p = (ushort)((Z80A.Z80A_REG_PC + 2) & 0xFFFF);

            switch (idx)
            {
                case 0x09: //ADD IX,BC
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_IX, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x19: //ADD IX,DE
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_IX, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x21: //LD IX,nn
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 14;
                    Z80A.Z80A_REG_IX = MEM.GET_MSX_MEMORY_16(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x22: //LD (nn),IX
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_IX);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x23: //INC IX
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_INC_16TO16(Z80A.Z80A_REG_IX, ref Z80A.Z80A_REG_IX);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x24: //INC IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IXH(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IXH(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x25: //DEC IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IXH(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IXH(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x26: //LD IXH,n '@@@@@
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.PUT_Z80A_REG_IXH(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x29: //ADD IX,IX
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.Z80A_REG_IX, ref Z80A.Z80A_REG_IX, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2A: //LD IX,(nn)
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    Z80A.Z80A_REG_IX = MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2B: //DEC IX
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_DEC_16TO16(Z80A.Z80A_REG_IX, ref Z80A.Z80A_REG_IX);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2C: //INC IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IXL(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IXL(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2D: //DEC IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IXL(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IXL(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2E: //LD IXL,n '@@@@@
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.PUT_Z80A_REG_IXL(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x34: //INC (IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 23;
                    Z80A.gt_INC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx), ref Reg8);
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x35: //DEC (IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 23;
                    Z80A.gt_DEC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx), ref Reg8);
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x36: //LD (IX+d),n
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, MEM.GET_MSX_MEMORY(PC2p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x39: //ADD IX,SP
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IX, Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_IX, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x44: //LD B,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IXH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x45: //LD B,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IXL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x46: //LD B,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4C: //LD C,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IXH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4D: //LD C,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IXL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4E: //LD C,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x54: //LD D,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IXH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x55: //LD D,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IXL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x56: //LD D,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5C: //LD E,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IXH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5D: //LD E,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IXL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5E: //LD E,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x60: //LD IXH,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x61: //LD IXH,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x62: //LD IXH,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x63: //LD IXH,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x64: //LD IXH,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                  //Z80A.PUT_Z80A_REG_IXH(Z80A.GET_Z80A_REG_IXH());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x65: //LD IXH,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXH(Z80A.GET_Z80A_REG_IXL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x66: //LD H,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x67: //LD IXH,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXH(Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x68: //LD IXL,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x69: //LD IXL,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6A: //LD IXL,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6B: //LD IXL,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6C: //LD IXL,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXL(Z80A.GET_Z80A_REG_IXH());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6D: //LD IXL,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                  //Z80A.PUT_Z80A_REG_IXL(Z80A.GET_Z80A_REG_IXL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6E: //LD L,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6F: //LD IXL,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IXL(Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x70: //LD (IX+d),B
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x71: //LD (IX+d),C
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x72: //LD (IX+d),D
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x73: //LD (IX+d),E
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x74: //LD (IX+d),H
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x75: //LD (IX+d),L
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x77: //LD (IX+d),A
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7C: //LD A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IXH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7D: //LD A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IXL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7E: //LD A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x84: //ADD A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x85: //ADD A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x86: //ADD A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8C: //ADC A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8D: //ADC A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8E: //ADC A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x94: //SUB A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x95: //SUB A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x96: //SUB A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9C: //SBC A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9D: //SBC A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9E: //SBC A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA4: //AND A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA5: //AND A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA6: //AND A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAC: //XOR A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAD: //XOR A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAE: //XOR A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB4: //OR A,IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXH(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB5: //OR A,IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IXL(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB6: //OR A,(IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBC: //CP IXH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IXH());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBD: //CP IXL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IXL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBE: //CP (IX+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(GetIxyIdx));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCB: //DD-CB - IX bit instruction
                    Z80A.EXEC_Z80A_ADD_PC(1, 0);
                    MIDDCB.EXEC_Z80A_CODE_DD_CB();
                    break;
                case 0xE1: //POP IX
                    MSX.Gi_Z80A_CLOCK = 14;
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_IX);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE3: //EX (SP),IX
                    MSX.Gi_Z80A_CLOCK = 23;
                    Reg16 = MEM.GET_MSX_MEMORY_16(Z80A.Z80A_REG_SP);
                    MEM.PUT_MSX_MEMORY_16(Z80A.Z80A_REG_SP, Z80A.Z80A_REG_IX);
                    Z80A.Z80A_REG_IX = Reg16;
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE5: //PUSH IX
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_PUSH_16(Z80A.Z80A_REG_IX);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE9: //JP (IX)
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_PC = Z80A.Z80A_REG_IX; //PC<-IX
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0xF9: //LD SP,IX
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.Z80A_REG_SP = Z80A.Z80A_REG_IX;
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                default:
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.EXEC_Z80A_ADD_PC(0, 0); //없는명령은취소됨
                    break;
            };
        }
    }
}
