﻿namespace csMSX2
{
    public static class MIED
    {
        public static void EXEC_Z80A_CODE_ED()
        {
            byte idx; //0~255
            byte iSz;
            byte Reg8 = 0;
            ushort PC1p;

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC);
            iSz = 2;

            PC1p = (ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF);

            switch (idx)
            {
                case 0x40: //IN B,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x41: //OUT (C),B
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x42: //SBC HL,BC
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x43: //LD (nn),BC
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_BC());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x44: //NEG
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x45: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    //Gi_Z80A_EI_Chk = Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x46: //IM 0
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_0();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x47: //LD I,A
                    MSX.Gi_Z80A_CLOCK = 9;
                    INT.gt_LD_I_A();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x48: //IN C,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x49: //OUT (C),C
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4A: //ADC HL,BC
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4B: //LD BC,(nn)
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    Z80A.PUT_Z80A_REG_BC(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4C: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4D: //RETI
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETI();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x4E: //IM 0/1 '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_0_1();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4F: //LD R,A
                    MSX.Gi_Z80A_CLOCK = 9;
                    INT.gt_LD_R_A();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x50: //IN D,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x51: //OUT (C),D
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x52: //SBC HL,DE
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x53: //LD (nn),DE
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_DE());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x54: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x55: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x56: //IM 1
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_1();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x57: //LD A,I
                    MSX.Gi_Z80A_CLOCK = 9;
                    INT.gt_LD_A_I();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x58: //IN E,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x59: //OUT (C),E
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5A: //ADC HL,DE
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5B: //LD DE,(nn)
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    Z80A.PUT_Z80A_REG_DE(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5C: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5D: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x5E: //IM 2
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_2();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5F: //LD A,R
                    MSX.Gi_Z80A_CLOCK = 9;
                    INT.gt_LD_A_R();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x60: //IN H,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x61: //OUT (C),H
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x62: //SBC HL,HL
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_HL(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x63: //LD (nn),HL '@@@@@
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.GET_Z80A_REG_HL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x64: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x65: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x66: //IM 0
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_0();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x67: //RRD
                    MSX.Gi_Z80A_CLOCK = 18;
                    Z80A.gt_RRD();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x68: //IN L,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x69: //OUT (C),L
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6A: //ADC HL,HL
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.GET_Z80A_REG_HL(), ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6B: //LD HL,(nn) '@@@@@
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    Z80A.PUT_Z80A_REG_HL(MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p)));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6C: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6D: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    INT.Gi_Z80A_EI_Chk = INT.Gi_Z80A_EI_Cnt; //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x6E: //IM 0/1 '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_0_1();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6F: //RLD
                    MSX.Gi_Z80A_CLOCK = 18;
                    Z80A.gt_RLD();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x70: //IN (C) '@@@@@
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x71: //OUT (C),0 '@@@@@
                    MSX.Gi_Z80A_CLOCK = 12;
                    Reg8 = 0;
                    IO.gt_PORT_OUT(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x72: //SBC HL,SP
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_SUB_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x73: //LD (nn),SP
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_SP);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x74: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x75: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    //Gi_Z80A_EI_Chk = Gi_Z80A_EI_Cnt //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x76: //IM 1
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_1();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x78: //IN A,(C)
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_IN(ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x79: //OUT (C),A
                    MSX.Gi_Z80A_CLOCK = 12;
                    IO.gt_PORT_OUT(Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7A: //ADC HL,SP
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO8(Z80A.GET_Z80A_REG_HL(), Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_H, ref Z80A.Z80A_REG_L, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7B: //LD SP,(nn)
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    Z80A.Z80A_REG_SP = MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7C: //NEG '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_NEG();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7D: //RETN
                    MSX.Gi_Z80A_CLOCK = 14;
                    INT.gt_RETN();
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_PC);
                    //Gi_Z80A_EI_Chk = Gi_Z80A_EI_Cnt //EI 확인용
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz - 1); //2
                    break;
                case 0x7E: //IM 2
                    MSX.Gi_Z80A_CLOCK = 8;
                    INT.gt_IM_2();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA0: //LDI
                    MSX.Gi_Z80A_CLOCK = 16;
                    Z80A.gt_LDI();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA1: //CPI
                    MSX.Gi_Z80A_CLOCK = 16;
                    Z80A.gt_CPI();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA2: //INI
                    MSX.Gi_Z80A_CLOCK = 16;
                    IO.gt_INI();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA3: //OUTI
                    MSX.Gi_Z80A_CLOCK = 16;
                    IO.gt_OUTI();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA8: //LDD
                    MSX.Gi_Z80A_CLOCK = 16;
                    Z80A.gt_LDD();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA9: //CPD
                    MSX.Gi_Z80A_CLOCK = 16;
                    Z80A.gt_CPD();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAA: //IND
                    MSX.Gi_Z80A_CLOCK = 16;
                    IO.gt_IND();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAB: //OUTD
                    MSX.Gi_Z80A_CLOCK = 16;
                    IO.gt_OUTD();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB0: //LDIR
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.gt_LDIR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB1: //CPIR
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.gt_CPIR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB2: //INIR
                    MSX.Gi_Z80A_CLOCK = 0;
                    IO.gt_INIR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB3: //OTIR
                    MSX.Gi_Z80A_CLOCK = 0;
                    IO.gt_OTIR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB8: //LDDR
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.gt_LDDR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB9: //CPDR
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.gt_CPDR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBA: //INDR
                    MSX.Gi_Z80A_CLOCK = 0;
                    IO.gt_INDR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBB: //OTDR
                    MSX.Gi_Z80A_CLOCK = 0;
                    IO.gt_OTDR(); //21/16
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                default:
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.EXEC_Z80A_ADD_PC(1, 0); //없는명령은NOP
                    break;
            };
        }
    }
}
