﻿namespace csMSX2
{
    public static class MIFD
    {
        public static void EXEC_Z80A_CODE_FD()
        {
            byte idx; //0~255
            byte iSz;
            byte Reg8 = 0;
            ushort Reg16 = 0;
            ushort GetIxyIdx;
            ushort PC1p;
            ushort PC2p;

            idx = MEM.GET_MSX_MEMORY(Z80A.Z80A_REG_PC);
            iSz = 2;

            GetIxyIdx = Z80A.goGetLngToLng(Z80A.Z80A_REG_IY + Z80A.giGetIdx8(MEM.GET_MSX_MEMORY((ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF))));
            PC1p = (ushort)((Z80A.Z80A_REG_PC + 1) & 0xFFFF);
            PC2p = (ushort)((Z80A.Z80A_REG_PC + 2) & 0xFFFF);

            switch (idx)
            {
                case 0x09: //ADD IY,BC
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.GET_Z80A_REG_BC(), ref Z80A.Z80A_REG_IY, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x19: //ADD IY,DE
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.GET_Z80A_REG_DE(), ref Z80A.Z80A_REG_IY, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x21: //LD IY,nn
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 14;
                    Z80A.Z80A_REG_IY = MEM.GET_MSX_MEMORY_16(PC1p);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x22: //LD (nn),IY
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    MEM.PUT_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p), Z80A.Z80A_REG_IY);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x23: //INC IY
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_INC_16TO16(Z80A.Z80A_REG_IY, ref Z80A.Z80A_REG_IY);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x24: //INC IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IYH(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IYH(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x25: //DEC IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IYH(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IYH(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x26: //LD IYH,n '@@@@@
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.PUT_Z80A_REG_IYH(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x29: //ADD IY,IY
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.Z80A_REG_IY, ref Z80A.Z80A_REG_IY, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2A: //LD IY,(nn)
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 20;
                    Z80A.Z80A_REG_IY = MEM.GET_MSX_MEMORY_16(MEM.GET_MSX_MEMORY_16(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2B: //DEC IY
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.gt_DEC_16TO16(Z80A.Z80A_REG_IY, ref Z80A.Z80A_REG_IY);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2C: //INC IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_INC_8TO8(Z80A.GET_Z80A_REG_IYL(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IYL(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2D: //DEC IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_DEC_8TO8(Z80A.GET_Z80A_REG_IYL(), ref Reg8);
                    Z80A.PUT_Z80A_REG_IYL(Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x2E: //LD IYL,n '@@@@@
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 11;
                    Z80A.PUT_Z80A_REG_IYL(MEM.GET_MSX_MEMORY(PC1p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x34: //INC (IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 23;
                    Z80A.gt_INC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx), ref Reg8);
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x35: //DEC (IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 23;
                    Z80A.gt_DEC_8TO8(MEM.GET_MSX_MEMORY(GetIxyIdx), ref Reg8);
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Reg8);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x36: //LD (IY+d),n
                    iSz = 4;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, MEM.GET_MSX_MEMORY(PC2p));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x39: //ADD IY,SP
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_ADD_16TO16(Z80A.Z80A_REG_IY, Z80A.Z80A_REG_SP, ref Z80A.Z80A_REG_IY, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x44: //LD B,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IYH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x45: //LD B,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_B = Z80A.GET_Z80A_REG_IYL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x46: //LD B,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_B = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4C: //LD C,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IYH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4D: //LD C,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_C = Z80A.GET_Z80A_REG_IYL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x4E: //LD C,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_C = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x54: //LD D,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IYH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x55: //LD D,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_D = Z80A.GET_Z80A_REG_IYL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x56: //LD D,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_D = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5C: //LD E,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IYH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5D: //LD E,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_E = Z80A.GET_Z80A_REG_IYL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x5E: //LD E,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_E = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x60: //LD IYH,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x61: //LD IYH,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x62: //LD IYH,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x63: //LD IYH,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x64: //LD IYH,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                  //Z80A.PUT_Z80A_REG_IYH(Z80A.GET_Z80A_REG_IYH());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x65: //LD IYH,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYH(Z80A.GET_Z80A_REG_IYL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x66: //LD H,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_H = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x67: //LD IYH,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYH(Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x68: //LD IYL,B '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x69: //LD IYL,C '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6A: //LD IYL,D '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6B: //LD IYL,E '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6C: //LD IYL,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYL(Z80A.GET_Z80A_REG_IYH());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6D: //LD IYL,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                  //Z80A.PUT_Z80A_REG_IYL(Z80A.GET_Z80A_REG_IYL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6E: //LD L,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_L = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x6F: //LD IYL,A '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.PUT_Z80A_REG_IYL(Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x70: //LD (IY+d),B
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_B);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x71: //LD (IY+d),C
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_C);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x72: //LD (IY+d),D
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_D);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x73: //LD (IY+d),E
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_E);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x74: //LD (IY+d),H
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_H);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x75: //LD (IY+d),L
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_L);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x77: //LD (IY+d),A
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    MEM.PUT_MSX_MEMORY(GetIxyIdx, Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7C: //LD A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IYH();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7D: //LD A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_A = Z80A.GET_Z80A_REG_IYL();
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x7E: //LD A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.Z80A_REG_A = MEM.GET_MSX_MEMORY(GetIxyIdx);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x84: //ADD A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x85: //ADD A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x86: //ADD A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8C: //ADC A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8D: //ADC A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x8E: //ADC A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_ADD_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x94: //SUB A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x95: //SUB A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x96: //SUB A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 0);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9C: //SBC A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9D: //SBC A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0x9E: //SBC A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_SUB_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A, 1);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA4: //AND A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA5: //AND A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xA6: //AND A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_AND_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAC: //XOR A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAD: //XOR A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xAE: //XOR A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_XOR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB4: //OR A,IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYH(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB5: //OR A,IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, Z80A.GET_Z80A_REG_IYL(), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xB6: //OR A,(IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_OR_8TO8(Z80A.Z80A_REG_A, MEM.GET_MSX_MEMORY(GetIxyIdx), ref Z80A.Z80A_REG_A);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBC: //CP IYH '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IYH());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBD: //CP IYL '@@@@@
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.gt_CP(Z80A.GET_Z80A_REG_IYL());
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xBE: //CP (IY+d)
                    iSz = 3;
                    MSX.Gi_Z80A_CLOCK = 19;
                    Z80A.gt_CP(MEM.GET_MSX_MEMORY(GetIxyIdx));
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xCB: //FD-CB - IY bit instruction
                    Z80A.EXEC_Z80A_ADD_PC(1, 0);
                    MIFDCB.EXEC_Z80A_CODE_FD_CB();
                    break;
                case 0xE1: //POP IY
                    MSX.Gi_Z80A_CLOCK = 14;
                    Z80A.gt_POP_16(ref Z80A.Z80A_REG_IY);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE3: //EX (SP),IY
                    MSX.Gi_Z80A_CLOCK = 23;
                    Reg16 = MEM.GET_MSX_MEMORY_16(Z80A.Z80A_REG_SP);
                    MEM.PUT_MSX_MEMORY_16(Z80A.Z80A_REG_SP, Z80A.Z80A_REG_IY);
                    Z80A.Z80A_REG_IY = Reg16;
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE5: //PUSH IY
                    MSX.Gi_Z80A_CLOCK = 15;
                    Z80A.gt_PUSH_16(Z80A.Z80A_REG_IY);
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                case 0xE9: //JP (IY)
                    MSX.Gi_Z80A_CLOCK = 8;
                    Z80A.Z80A_REG_PC = Z80A.Z80A_REG_IY; //PC<-IY
                    Z80A.EXEC_Z80A_ADD_PC(0, iSz); //2
                    break;
                case 0xF9: //LD SP,IY
                    MSX.Gi_Z80A_CLOCK = 10;
                    Z80A.Z80A_REG_SP = Z80A.Z80A_REG_IY;
                    Z80A.EXEC_Z80A_ADD_PC(iSz - 1, 0);
                    break;
                default:
                    MSX.Gi_Z80A_CLOCK = 0;
                    Z80A.EXEC_Z80A_ADD_PC(0, 0); //없는명령은취소됨
                    break; 
            };
        }
    }
}
