﻿namespace csMSX2
{
    public static class MSX
    {
        public static sbyte GiMENU; //0:초기,1:시작,2:중지
        public static string csMSX_Version = "2018.07.16";

        public static sbyte GiMSX2; //0:MSX,1:MSX2
        public static sbyte GiDISK; //1:Disk Rom Load
        public static sbyte GiCHAR; //Font - 0:8*8,1:6*8
        public static sbyte GiSC2X; //1:Scale2x

        public static sbyte Gi_MSX2_Sets;
        public static sbyte Gi_DISK_Sets;
        public static sbyte Gi_CHAR_Sets;
        public static sbyte Gi_SC2X_Sets;

        public static sbyte Gi_MSX_Int_Timer; //Timer 속도 (10~100)
        public static sbyte Gi_MSX_DisplayFrame; //1초에 0:60번[16],1:30번[33],2:22번[45],3:16번[62]

        public static sbyte Gi_MSX_InterruptDup; //1:인터럽트중복허용
        public static sbyte Gi_MSX_Auto_Speed; //1:Auto Speed
        public static sbyte Gi_MSX_KeyChange; //1:Key Change
        public static sbyte Gi_MSX_JoyOn; //1:조이스틱사용
        public static sbyte Gi_MSX_SpaceOn; //1:Space On
        public static sbyte Gi_MSX_VDT_ST_FF;

        public static string Gs_CAS_FILE;
        public static string Gs_ROM_FILE;
        public static sbyte Gi_ROM_TYPE;
        public static string Gs_DSK_A_FILE;
        public static string Gs_DSK_B_FILE;
        public static sbyte Gi_DSK_A_ON;
        public static sbyte Gi_DSK_B_ON;

        public static sbyte Gi_MSX_Execute; //0:중지,1:실행중 //-128~127
        public static sbyte Gi_MSX_GotFocus; //0:없음,1:포커스

        public static int Gi_Z80A_CLOCK; //-2,147,483,648 ~ 2,147,483,647
        public static int Gi_Z80A_ClockSize;

        public static sbyte Gi_MSX_Timer_60_INT; //1초60번확인(INT)
        public static sbyte Gi_MSX_Timer_16_VDP; //1초16번확인(VDP)

        public static sbyte Gi_TEST; //1:Test
        public static ushort TEST_0_oAddr;
        public static byte TEST_0_iVal;
        public static ushort TEST_1_oAddr;
        public static byte TEST_1_iVal;
        public static ushort TEST_2_oAddr;
        public static byte TEST_2_iVal;
        public static ushort TEST_3_oAddr;
        public static byte TEST_3_iVal;
        
        public static void MSX_INIT()
        {
            Z80A.MSX_INIT_Z80A();
            INT.MSX_INIT_INT();
            MEM.MSX_INIT_MEM();
            IO.MSX_INIT_IO();
            PPI.MSX_INIT_PPI();
            VDT.MSX_INIT_VDT();
            PSG.MSX_INIT_PSG();
            FDC.MSX_INIT_FDC();

            TBL.MSX_INIT_P_Table();
            TBL.MSX_INIT_B_Table(); 
            TBL.MSX_INIT_MD_Table();

            VDT.MSX_Color_Setting();
            PSG.MSX_Compute_Oct_Hz();

            if (GiMSX2 == 0) //MSX1
            {
                MSX_Init.Get_MSX1_ROM();
            }
            else //MSX2
            {
                MSX_Init.Get_MSX2_ROM();
            };
            if (GiDISK == 1) MSX_Init.Get_MSX_DISK_ROM(); //DISK
        }

        public static string gsGetRomFileName(string fName)
        {
            string R;

            R = "";
            fName = FN.gsTrim(fName);
            if (fName == "") goto LastProc;
            if (FN.gsUpper(FN.gsRight(fName, 4)) == ".ROM") R = fName;
        LastProc: ;
            return R;
        }

        public static string gsGetDskFileName(string fName)
        {
            string R;

            R = "";
            fName = FN.gsTrim(fName);
            if (fName == "") goto LastProc;
            if (FN.gsUpper(FN.gsRight(fName, 4)) == ".DSK") R = fName;
        LastProc: ;
            return R;
        }

        public static string gsGetCasFileName(string fName)
        {
            string R;

            R = "";
            fName = FN.gsTrim(fName);
            if (fName == "") goto LastProc;
            if (FN.gsUpper(FN.gsRight(fName, 4)) == ".CAS") R = fName;
        LastProc: ;
            return R;
        }

        public static string gsGetMsxFileName(string fName)
        {
            string R;

            R = "";
            fName = FN.gsTrim(fName);
            if (fName == "") goto LastProc;
            if (FN.gsUpper(FN.gsRight(fName, 4)) == ".MSX") R = fName;
        LastProc: ;
            return R;
        }
    }
}
