﻿namespace csMSX2
{
    public static class MSX_Init
    {
        public static void Get_MSX1_ROM()
        {
            string S;
            ushort P;

            S = gs_Get_MSX1_BIOS();
            P = 0; //0000H - Slot#0
            for (int i = 0; i <= 16383; i++)
            {
                MEM.MSX_MEM[0, P + i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(S, (i * 3) + 1, 2)));
            };

            S = gs_Get_MSX1_BASIC();
            P = 16384; //4000H - Slot#0
            for (int i = 0; i <= 16383; i++)
            {
                MEM.MSX_MEM[0, P + i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(S, (i * 3) + 1, 2)));
            };
        }

        public static void Get_MSX2_ROM()
        {
            string S;
            ushort P;

            S = gs_Get_MSX2_BIOS();
            P = 0; //0000H - Slot#0
            for (int i = 0; i <= 16383; i++)
            {
                MEM.MSX_MEM[0, P + i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(S, (i * 3) + 1, 2)));
            };

            S = gs_Get_MSX2_BASIC();
            P = 16384; //4000H - Slot#0
            for (int i = 0; i <= 16383; i++)
            {
                MEM.MSX_MEM[0, P + i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(S, (i * 3) + 1, 2)));
            };

            S = gs_Get_MSX2X_BIOS();
            P = 0; //0000H - Slot#3
            for (int i = 0; i <= 16383; i++)
            {
                MEM.MSX_MEM[3, P + i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(S, (i * 3) + 1, 2)));
            };
        }

        public static void Get_MSX_DISK_ROM()
        {
            string S;
            ushort P;

            S = gs_Get_MSX_DISK();
            P = 16384; //4000H - Slot#3
            for (int i = 0; i <= 16383; i++)
            {
                MEM.MSX_MEM[3, P + i] = (byte)FN.giHex8ToInt(FN.gsTrim(FN.gsMid(S, (i * 3) + 1, 2)));
            };
        }
        
        public static string gs_Get_MSX1_BIOS()
        {
            string S;

            S = "";

          //== MSX1 BIOS [0000H~3FFFH,4000H,16384] ==
            S = S + "F3 C3 D7 02 BF 1B 98 98 C3 83 26 00 C3 B6 01 00 ";
            S = S + "C3 86 26 00 C3 D1 01 00 C3 45 1B 00 C3 17 02 00 ";
            S = S + "C3 6A 14 00 C3 5E 02 00 C3 89 26 91 11 00 00 00 ";
            S = S + "C3 05 02 00 00 00 00 00 C3 3C 0C C3 9D 04 C3 9D ";
            S = S + "13 C3 77 05 C3 70 05 C3 7F 05 C3 D7 07 C3 CD 07 ";
            S = S + "C3 EC 07 C3 DF 07 C3 15 08 C3 0F 07 C3 44 07 C3 ";
            S = S + "4F 08 C3 F7 07 00 C3 98 13 C3 A8 06 C3 0E 05 C3 ";
            S = S + "38 05 C3 D2 05 C3 1F 06 C3 94 05 C3 B4 05 C3 02 ";
            S = S + "06 C3 59 06 C3 E4 06 C3 F9 06 C3 04 07 C3 10 15 ";
            S = S + "C3 BD 04 C3 02 11 C3 0E 11 C3 C4 11 C3 6A 0D C3 ";
            S = S + "CB 10 C3 BC 08 C3 5D 08 C3 84 08 C3 9D 08 C3 BF ";
            S = S + "23 C3 D5 23 C3 CC 23 C3 6F 04 C3 FB 03 C3 F9 10 ";
            S = S + "C3 13 11 C3 48 08 C3 8E 08 C3 26 0B C3 15 0B C3 ";
            S = S + "2B 0B C3 3B 08 C3 EE 11 C3 53 12 C3 AC 12 C3 73 ";
            S = S + "12 C3 63 1A C3 BC 1A C3 E9 19 C3 F1 19 C3 19 1A ";
            S = S + "C3 DD 19 C3 84 13 C3 EB 14 C3 92 14 C3 C5 16 C3 ";
            S = S + "EE 16 C3 5D 17 C3 3C 17 C3 2A 17 C3 0A 17 C3 99 ";
            S = S + "15 C3 DF 15 C3 39 16 C3 40 16 C3 76 16 C3 47 16 ";
            S = S + "C3 7E 16 C3 09 18 C3 C7 18 C3 CF 18 C3 E4 18 C3 ";
            S = S + "7A 19 C3 3D 0F C3 7A 0F C3 4C 14 C3 4F 14 C3 49 ";
            S = S + "14 C3 52 14 C3 8A 14 C3 8E 14 C3 5F 14 C3 63 1B ";
            S = S + "C3 70 14 C3 74 14 C3 68 04 C3 FF 01 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 CD 7E 02 FA C6 01 DB A8 57 A1 ";
            S = S + "B0 CD 80 F3 7B C9 E5 CD A3 02 E3 C5 CD B6 01 18 ";
            S = S + "1B D5 CD 7E 02 FA E1 01 D1 DB A8 57 A1 B0 C3 85 ";
            S = S + "F3 E3 E5 CD A3 02 D1 E3 C5 CD D1 01 C1 E3 F5 78 ";
            S = S + "E6 3F B1 D3 A8 7D 32 FF FF 78 D3 A8 F1 E1 C9 FD ";
            S = S + "2A C0 FC 18 12 E3 F5 D5 7E F5 FD E1 23 5E 23 56 ";
            S = S + "23 D5 DD E1 D1 F1 E3 D9 08 FD E5 F1 DD E5 E1 CD ";
            S = S + "7E 02 FA 2E 02 DB A8 F5 A1 B0 D9 C3 8C F3 CD A3 ";
            S = S + "02 F5 FD E1 E5 C5 4F 06 00 7D A4 B2 21 C5 FC 09 ";
            S = S + "77 E5 08 D9 CD 17 02 D9 08 E1 C1 D1 78 E6 3F B1 ";
            S = S + "F3 D3 A8 7B 32 FF FF 78 D3 A8 73 08 D9 C9 CD 7E ";
            S = S + "02 FA 6B 02 DB A8 A1 B0 D3 A8 C9 E5 CD A3 02 4F ";
            S = S + "06 00 7D A4 B2 21 C5 FC 09 77 E1 79 18 E0 F3 F5 ";
            S = S + "7C 07 07 E6 03 5F 3E C0 07 07 1D F2 88 02 5F 2F ";
            S = S + "4F F1 F5 E6 03 3C 47 3E AB C6 55 10 FC 57 A3 47 ";
            S = S + "F1 A7 C9 F5 7A E6 C0 4F F1 F5 57 DB A8 47 E6 3F ";
            S = S + "B1 D3 A8 7A 0F 0F E6 03 57 3E AB C6 55 15 F2 BB ";
            S = S + "02 A3 57 7B 2F 67 3A FF FF 2F 6F A4 B2 32 FF FF ";
            S = S + "78 D3 A8 F1 E6 03 C9 3E 82 D3 AB AF D3 A8 3E 50 ";
            S = S + "D3 AA 11 FF FF AF 4F D3 A8 CB 21 06 00 21 FF FF ";
            S = S + "36 F0 7E D6 0F 20 0B 77 7E 3C 20 06 04 CB C1 32 ";
            S = S + "FF FF 21 00 BF 7E 2F 77 BE 2F 77 20 07 00 00 00 ";
            S = S + "25 FA 05 03 2E 00 24 7D 93 7C 9A 30 0A EB 3A FF ";
            S = S + "FF 2F 6F DB A8 67 F9 78 A7 28 0A 3A FF FF 2F C6 ";
            S = S + "10 FE 40 38 CA DB A8 C6 50 30 AC 21 00 00 39 7C ";
            S = S + "D3 A8 7D 32 FF FF 79 07 07 07 07 4F 11 FF FF DB ";
            S = S + "A8 E6 3F D3 A8 06 00 CB 01 30 0A 04 3A FF FF 2F ";
            S = S + "E6 3F 32 FF FF 21 00 FE 7E 2F 77 BE 2F 77 20 09 ";
            S = S + "00 00 00 25 7C FE C0 30 EF 2E 00 24 7D 93 7C 9A ";
            S = S + "30 0A EB 3A FF FF 2F 6F DB A8 67 F9 78 A7 28 08 ";
            S = S + "3A FF FF 2F C6 40 30 CA DB A8 C6 40 30 B5 21 00 ";
            S = S + "00 39 7C D3 A8 7D 32 FF FF 79 01 49 0C 11 81 F3 ";
            S = S + "21 80 F3 36 00 ED B0 4F 06 04 21 C4 FC CB 19 9F ";
            S = S + "E6 80 77 2B 10 F7 DB A8 4F AF D3 A8 3A FF FF 2F ";
            S = S + "6F 3E 40 D3 A8 3A FF FF 2F 67 3E 80 D3 A8 3A FF ";
            S = S + "FF 2F 5F 3E C0 D3 A8 3A FF FF 2F 57 79 D3 A8 22 ";
            S = S + "C5 FC EB 22 C7 FC ED 56 C3 80 26 3A B1 FB A7 C0 ";
            S = S + "E5 21 9B FC F3 7E 36 00 E1 FB A7 C8 FE 03 28 1C ";
            S = S + "E5 D5 C5 CD DA 09 21 9B FC F3 7E 36 00 FB A7 28 ";
            S = S + "F8 F5 CD 27 0A F1 C1 D1 E1 FE 03 C0 E5 CD 68 04 ";
            S = S + "CD 54 04 30 0A 21 6A FC F3 CD F1 0E FB E1 C9 CD ";
            S = S + "3B 08 3A C1 FC 26 40 CD 5E 02 E1 AF ED 7B B1 F6 ";
            S = S + "C5 C3 E6 63 3A 6A FC 0F D0 2A 6B FC 7C B5 C8 2A ";
            S = S + "1C F4 23 7C B5 C8 37 C9 2A F8 F3 22 FA F3 C9 DB ";
            S = S + "AA E6 F0 F6 07 D3 AA DB A9 E6 10 C0 DB AA 3D D3 ";
            S = S + "AA DB A9 E6 02 C0 E5 2A F8 F3 22 FA F3 E1 3A E1 ";
            S = S + "FB E6 EF 32 E1 FB 3E 0D 32 F7 F3 37 C9 3E 07 1E ";
            S = S + "80 CD 02 11 3E 0F 1E CF CD 02 11 3E 0B 5F CD 02 ";
            S = S + "11 CD 0C 11 E6 40 32 AD FC 3E FF D3 90 E5 D5 C5 ";
            S = S + "F5 21 3F FB 06 71 AF 77 23 10 FC 11 75 F9 06 7F ";
            S = S + "21 80 00 E5 D5 C5 F5 CD DA 14 F1 C6 08 1E 00 CD ";
            S = S + "02 11 D6 08 F5 2E 0F CD 77 14 EB 21 08 05 01 06 ";
            S = S + "00 ED B0 F1 C1 E1 D1 19 EB 3C FE 03 38 D5 3E 07 ";
            S = S + "1E B8 CD 02 11 C3 DA 08 04 04 78 88 FF 00 CD 77 ";
            S = S + "05 AF 32 AF FC 32 B0 FC 3A AE F3 32 B0 F3 2A B3 ";
            S = S + "F3 22 22 F9 2A B7 F3 22 24 F9 CD F7 07 CD 7E 07 ";
            S = S + "CD 1E 07 CD 94 05 18 38 CD 77 05 3E 01 32 AF FC ";
            S = S + "32 B0 FC 3A AF F3 32 B0 F3 2A BD F3 22 22 F9 2A ";
            S = S + "C1 F3 22 24 F9 2A C5 F3 22 26 F9 2A C3 F3 22 28 ";
            S = S + "F9 CD F7 07 CD 7E 07 CD 1E 07 CD BB 06 CD B4 05 ";
            S = S + "3A E0 F3 F6 40 18 05 3A E0 F3 E6 BF 47 0E 01 78 ";
            S = S + "F3 D3 99 79 F6 80 D3 99 FB E5 78 06 00 21 DF F3 ";
            S = S + "09 77 E1 C9 3A DF F3 E6 01 47 0E 00 CD 7F 05 3A ";
            S = S + "E0 F3 E6 E7 F6 10 47 0C CD 7F 05 21 B3 F3 11 00 ";
            S = S + "00 C3 77 06 3A DF F3 E6 01 47 0E 00 CD 7F 05 3A ";
            S = S + "E0 F3 E6 E7 47 0C CD 7F 05 21 BD F3 11 00 00 C3 ";
            S = S + "77 06 CD 77 05 3E 02 32 AF FC 2A CF F3 22 26 F9 ";
            S = S + "2A CD F3 22 28 F9 2A C7 F3 CD DF 07 AF 06 03 D3 ";
            S = S + "98 3C 20 FB 10 F9 CD A1 07 CD BB 06 CD 02 06 C3 ";
            S = S + "70 05 3A DF F3 F6 02 47 0E 00 CD 7F 05 3A E0 F3 ";
            S = S + "E6 E7 47 0C CD 7F 05 21 C7 F3 11 03 7F 18 58 CD ";
            S = S + "77 05 3E 03 32 AF FC 2A D9 F3 22 26 F9 2A D7 F3 ";
            S = S + "22 28 F9 2A D1 F3 CD DF 07 11 06 00 0E 04 7A 06 ";
            S = S + "20 D3 98 3C 10 FB 0D 20 F5 57 1D 20 EF CD B9 07 ";
            S = S + "CD BB 06 CD 59 06 C3 70 05 3A DF F3 E6 01 47 0E ";
            S = S + "00 CD 7F 05 3A E0 F3 E6 E7 F6 08 47 0E 01 CD 7F ";
            S = S + "05 21 D1 F3 11 00 00 01 02 06 CD 90 06 06 0A 7A ";
            S = S + "CD 91 06 06 05 7B CD 91 06 06 09 CD 90 06 06 05 ";
            S = S + "AF E5 F5 7E 23 66 6F AF 29 8F 10 FC 6F F1 B5 47 ";
            S = S + "CD 7F 05 E1 23 23 0C C9 3A E0 F3 47 0E 01 CD 7F ";
            S = S + "05 2A 26 F9 01 00 08 AF CD 15 08 3A E9 F3 5F 2A ";
            S = S + "28 F9 01 00 20 3E D1 CD CD 07 23 23 79 CD CD 07 ";
            S = S + "23 0C 3A E0 F3 0F 0F 30 03 0C 0C 0C 7B CD CD 07 ";
            S = S + "23 10 E2 C9 6F 26 00 29 29 29 CD 04 07 FE 08 28 ";
            S = S + "02 29 29 EB 2A 26 F9 19 C9 6F 26 00 29 29 EB 2A ";
            S = S + "28 F9 19 C9 3A E0 F3 0F 0F 3E 08 D0 3E 20 C9 CD ";
            S = S + "EC 07 E3 E3 DB 98 12 13 0B 79 B0 20 F7 C9 CD C7 ";
            S = S + "FD 2A 24 F9 CD DF 07 3A 1F F9 2A 20 F9 01 00 08 ";
            S = S + "F5 F1 F5 C5 F3 CD B6 01 FB C1 D3 98 23 0B 79 B0 ";
            S = S + "20 EF F1 C9 EB CD DF 07 1A D3 98 13 0B 79 B0 20 ";
            S = S + "F7 C9 26 00 6F 29 29 29 EB 2A 20 F9 19 11 40 FC ";
            S = S + "06 08 3A 1F F9 F5 E5 D5 C5 CD B6 01 FB C1 D1 E1 ";
            S = S + "12 13 23 F1 10 EF C9 CD 9F 0B 28 25 30 3B 3A AF ";
            S = S + "FC A7 2A 22 F9 01 C0 03 28 03 01 00 03 3E 20 CD ";
            S = S + "15 08 CD 7F 0A 21 B2 FB 06 18 70 23 10 FC C3 26 ";
            S = S + "0B CD 32 08 01 00 18 C5 2A C9 F3 3A EA F3 CD 15 ";
            S = S + "08 2A CB F3 C1 AF C3 15 08 CD 32 08 21 EA F3 7E ";
            S = S + "87 87 87 87 B6 2A D5 F3 01 00 06 18 E9 F5 CD DF ";
            S = S + "07 E3 E3 F1 D3 98 C9 CD EC 07 E3 E3 DB 98 C9 7D ";
            S = S + "F3 D3 99 7C E6 3F F6 40 D3 99 FB C9 7D F3 D3 99 ";
            S = S + "7C E6 3F D3 99 FB C9 3A AF FC 3D FA 24 08 F5 CD ";
            S = S + "32 08 F1 C0 3A E9 F3 87 87 87 87 21 EA F3 B6 2A ";
            S = S + "BF F3 01 20 00 F5 CD DF 07 F1 D3 98 F5 0B 79 B0 ";
            S = S + "20 F7 F1 C9 3A E9 F3 87 87 87 87 21 EA F3 B6 47 ";
            S = S + "18 03 3A EB F3 47 0E 07 C3 7F 05 CD 9F 0B D8 3A ";
            S = S + "B0 FC CD BD FD C3 4F 08 C0 E5 CD 77 07 E1 C9 3D ";
            S = S + "FA 0E 05 CA 38 05 3D CA D2 05 C3 1F 06 CD B6 FF ";
            S = S + "F5 CD 6F 04 38 12 CD 84 08 28 F6 F1 F5 D3 91 AF ";
            S = S + "D3 90 3D D3 90 F1 A7 C9 AF 32 15 F4 3E 0D CD 6C ";
            S = S + "08 F1 37 C9 CD BB FF DB 90 0F 0F 3F 9F C9 3E 1B ";
            S = S + "DF 3E 59 DF 7D C6 1F DF 7C C6 1F DF C9 E5 F5 21 ";
            S = S + "A6 FC AF BE 77 28 0D F1 D6 40 FE 20 38 04 C6 40 ";
            S = S + "BF 37 E1 C9 F1 FE 01 20 F7 77 E1 C9 E5 D5 C5 F5 ";
            S = S + "CD A4 FD CD 9F 0B 30 12 CD 2E 0A F1 F5 CD DF 08 ";
            S = S + "CD E1 09 3A DD F3 3D 32 61 F6 F1 C1 D1 E1 C9 CD ";
            S = S + "9D 08 D0 4F 20 0D 21 A7 FC 7E A7 C2 8F 09 79 FE ";
            S = S + "20 38 21 2A DC F3 FE 7F CA E3 0A CD E6 0B CD 44 ";
            S = S + "0A C0 AF CD 2B 0C 26 01 CD 61 0A C0 CD 69 0A 2E ";
            S = S + "01 C3 88 0A 21 2D 09 0E 0C 23 23 A7 0D F8 BE 23 ";
            S = S + "20 F7 4E 23 46 2A DC F3 CD 2D 09 AF C9 C5 C9 07 ";
            S = S + "13 11 08 4C 0A 09 71 0A 0A 08 09 0B 7F 0A 0C 7E ";
            S = S + "07 0D 81 0A 1B 89 09 1C 5B 0A 1D 4C 0A 1E 57 0A ";
            S = S + "1F 61 0A 6A 7E 07 45 7E 07 4B EE 0A 4A 05 0B 6C ";
            S = S + "EC 0A 4C B4 0A 4D 85 0A 59 86 09 41 57 0A 42 61 ";
            S = S + "0A 43 44 0A 44 55 0A 48 7F 0A 78 80 09 79 83 09 ";
            S = S + "3E 01 01 3E 02 01 3E 04 01 3E FF 32 A7 FC C9 F2 ";
            S = S + "9D 09 36 00 79 21 51 09 0E 0F C3 19 09 3D 28 1E ";
            S = S + "3D 28 25 3D 77 3A B0 F3 11 DD F3 28 06 36 03 CD ";
            S = S + "32 0C 1B 47 79 D6 20 B8 3C 12 D8 78 12 C9 77 79 ";
            S = S + "D6 34 28 0B 3D 28 0F C9 77 79 D6 34 20 05 3C 32 ";
            S = S + "AA FC C9 3D C0 3C 32 A9 FC C9 3A A9 FC A7 C0 18 ";
            S = S + "05 3A A9 FC A7 C8 CD A9 FD CD 9F 0B D0 2A DC F3 ";
            S = S + "E5 CD D8 0B 32 CC FB 6F 26 00 29 29 29 EB 2A 24 ";
            S = S + "F9 E5 19 CD A5 0B 21 1F FC 06 08 3A AA FC A7 28 ";
            S = S + "02 06 03 7E 2F 77 2B 10 FA E1 01 F8 07 09 CD BE ";
            S = S + "0B E1 0E FF C3 E6 0B 3A A9 FC A7 C0 18 05 3A A9 ";
            S = S + "FC A7 C8 CD AE FD CD 9F 0B D0 2A DC F3 3A CC FB ";
            S = S + "4F C3 E6 0B 3A B0 F3 BC C8 24 18 1D CD 55 0A C0 ";
            S = S + "3A B0 F3 67 11 25 3E 2D C8 18 0E CD 44 0A C0 26 ";
            S = S + "01 CD 32 0C BD C8 38 05 2C 22 DC F3 C9 2D AF 18 ";
            S = S + "F8 3E 20 CD DF 08 3A DD F3 3D E6 07 20 F3 C9 2E ";
            S = S + "01 26 01 18 E4 CD 81 0A CD 32 0C 95 D8 CA EC 0A ";
            S = S + "E5 F5 4F 06 00 CD 1D 0C 6B 62 23 ED B0 21 CA FB ";
            S = S + "35 F1 E1 F5 2C CD AA 0B 2D CD C3 0B 2C F1 3D 20 ";
            S = S + "F2 C3 EC 0A CD 81 0A CD 32 0C 67 95 D8 CA EC 0A ";
            S = S + "6C E5 F5 4F 06 00 CD 1D 0C 6B 62 E5 2B ED B8 E1 ";
            S = S + "74 F1 E1 F5 2D CD AA 0B 2C CD C3 0B 2D F1 3D 20 ";
            S = S + "F2 18 09 CD 4C 0A C8 0E 20 C3 E6 0B 26 01 CD 29 ";
            S = S + "0C E5 CD F2 0B CD DF 07 E1 3E 20 D3 98 24 3A B0 ";
            S = S + "F3 BC 30 F5 C9 E5 CD EE 0A E1 CD 32 0C BD D8 C8 ";
            S = S + "26 01 2C 18 F0 CD B8 FD AF CD 9C 0B D0 E5 2A B1 ";
            S = S + "F3 CD EC 0A E1 C9 3A DE F3 A7 C8 CD B3 FD 3E FF ";
            S = S + "CD 9C 0B D0 E5 3A DC F3 21 B1 F3 BE 3E 0A 20 01 ";
            S = S + "DF 3A EB FB 0F 21 7F F8 3E 01 38 04 21 CF F8 AF ";
            S = S + "32 CD FB 11 18 FC D5 06 28 3E 20 12 13 10 FC D1 ";
            S = S + "0E 05 3A B0 F3 D6 04 38 2B 06 FF 04 D6 05 30 FB ";
            S = S + "78 A7 28 20 3E 13 C5 0E 00 7E 23 0C CD 9D 08 30 ";
            S = S + "F8 20 04 FE 20 38 01 12 13 10 EE 3E 10 91 4F 09 ";
            S = S + "C1 0D 20 E1 2A B1 F3 CD C3 0B E1 C9 32 DE F3 3A ";
            S = S + "AF FC FE 02 C9 E5 0E 08 18 0A E5 26 01 CD F2 0B ";
            S = S + "3A B0 F3 4F 06 00 11 18 FC CD 0F 07 E1 C9 E5 0E ";
            S = S + "08 18 0A E5 26 01 CD F2 0B 3A B0 F3 4F 06 00 EB ";
            S = S + "21 18 FC CD 44 07 E1 C9 E5 CD F2 0B CD EC 07 E3 ";
            S = S + "E3 DB 98 4F E1 C9 E5 CD F2 0B CD DF 07 79 D3 98 ";
            S = S + "E1 C9 C5 5C 26 00 54 2D 29 29 29 4D 44 29 29 19 ";
            S = S + "3A AF FC A7 3A B0 F3 28 04 D6 22 18 03 09 D6 2A ";
            S = S + "2F A7 1F 5F 19 EB 2A 22 F9 19 2B C1 C9 E5 11 B1 ";
            S = S + "FB 26 00 19 7E EB E1 A7 C9 3E AF F5 CD 1D 0C F1 ";
            S = S + "12 C9 3A DE F3 E5 21 B1 F3 86 E1 C9 E5 D5 C5 F5 ";
            S = S + "D9 08 E5 D5 C5 F5 FD E5 DD E5 CD 9A FD DB 99 A7 ";
            S = S + "F2 02 0D CD 9F FD FB 32 E7 F3 E6 20 21 6D FC C4 ";
            S = S + "F1 0E 2A A2 FC 2B 7C B5 20 09 21 7F FC CD F1 0E ";
            S = S + "2A A0 FC 22 A2 FC 2A 9E FC 23 22 9E FC 3A 3F FB ";
            S = S + "4F AF CB 19 F5 C5 DC 3B 11 C1 F1 3C FE 03 38 F2 ";
            S = S + "21 F6 F3 35 20 6C 36 01 AF CD 0C 12 E6 30 F5 3E ";
            S = S + "01 CD 0C 12 E6 30 07 07 C1 B0 F5 CD 26 12 E6 01 ";
            S = S + "C1 B0 4F 21 E8 F3 AE A6 71 4F 0F 21 70 FC DC F1 ";
            S = S + "0E CB 11 21 7C FC DC F1 0E CB 11 21 76 FC DC F1 ";
            S = S + "0E CB 11 21 79 FC DC F1 0E CB 11 21 73 FC DC F1 ";
            S = S + "0E AF 32 D9 FB CD 12 0D 20 18 21 F7 F3 35 20 12 ";
            S = S + "36 01 21 DA FB 11 DB FB 01 0A 00 36 FF ED B0 CD ";
            S = S + "4E 0D DD E1 FD E1 F1 C1 D1 E1 08 D9 F1 C1 D1 E1 ";
            S = S + "FB C9 DB AA E6 F0 4F 06 0B 21 E5 FB 79 D3 AA DB ";
            S = S + "A9 77 0C 23 10 F6 3A B0 FB A7 28 0E 3A EB FB FE ";
            S = S + "E8 20 07 DD 21 9B 40 C3 FF 01 11 E5 FB 06 0B 1B ";
            S = S + "2B 1A BE 20 04 10 F8 18 05 3E 0D 32 F7 F3 06 0B ";
            S = S + "21 DA FB 11 E5 FB 1A 4F AE A6 71 C4 89 0D 13 23 ";
            S = S + "10 F4 2A FA F3 3A F8 F3 95 C9 FB E5 D5 C5 CD 9F ";
            S = S + "0B 30 0F 3A CD FB 21 EB FB AE 21 DE F3 A6 0F DC ";
            S = S + "2B 0B CD 62 0D C1 D1 E1 C9 E5 D5 C5 F5 3E 0B 90 ";
            S = S + "87 87 87 4F 06 08 F1 1F C5 F5 DC 21 10 F1 C1 0C ";
            S = S + "10 F5 C3 DB 08 30 31 32 33 34 35 36 37 38 39 2D ";
            S = S + "3D 5C 5B 5D 3B 27 60 2C 2E 2F FF 61 62 63 64 65 ";
            S = S + "66 67 68 69 6A 6B 6C 6D 6E 6F 70 71 72 73 74 75 ";
            S = S + "76 77 78 79 7A 29 21 40 23 24 25 5E 26 2A 28 5F ";
            S = S + "2B 7C 7B 7D 3A 22 7E 3C 3E 3F FF 41 42 43 44 45 ";
            S = S + "46 47 48 49 4A 4B 4C 4D 4E 4F 50 51 52 53 54 55 ";
            S = S + "56 57 58 59 5A 09 AC AB BA EF BD F4 FB EC 07 17 ";
            S = S + "F1 1E 01 0D 06 05 BB F3 F2 1D FF C4 11 BC C7 CD ";
            S = S + "14 15 13 DC C6 DD C8 0B 1B C2 DB CC 18 D2 12 C0 ";
            S = S + "1A CF 1C 19 0F 0A 00 FD FC 00 00 F5 00 00 08 1F ";
            S = S + "F0 16 02 0E 04 03 F7 AE AF F6 FF FE 00 FA C1 CE ";
            S = S + "D4 10 D6 DF CA DE C9 0C D3 C3 D7 CB A9 D1 00 C5 ";
            S = S + "D5 D0 F9 AA F8 EB 9F D9 BF 9B 98 E0 E1 E7 87 EE ";
            S = S + "E9 00 ED DA B7 B9 E5 86 A6 A7 FF 84 97 8D 8B 8C ";
            S = S + "94 81 B1 A1 91 B3 B5 E6 A4 A2 A3 83 93 89 96 82 ";
            S = S + "95 88 8A A0 85 D8 AD 9E BE 9C 9D 00 00 E2 80 00 ";
            S = S + "00 00 E8 EA B6 B8 E4 8F 00 A8 FF 8E 00 00 00 00 ";
            S = S + "99 9A B0 00 92 B2 B4 00 A5 00 E3 00 00 00 00 90 ";
            S = S + "00 00 00 00 00 59 16 00 21 99 FB 19 7E A7 20 13 ";
            S = S + "EB 29 29 29 29 11 2F F5 19 EB 1A A7 C8 CD 55 0F ";
            S = S + "13 18 F7 2A 1C F4 23 7C B5 28 E5 21 AD FB 19 19 ";
            S = S + "19 7E E6 01 C8 7E F6 04 BE C8 77 EE 05 C0 3A D8 ";
            S = S + "FB 3C 32 D8 FB C9 3A EB FB 0F 3E 0C DE 00 18 45 ";
            S = S + "CD D1 FD 5F 16 00 21 03 10 19 7E A7 C8 18 36 3A ";
            S = S + "EB FB 5F F6 FE CB 63 20 02 E6 FD 2F 3C 32 AC FC ";
            S = S + "18 32 00 00 00 C9 21 AB FC 7E 2F 77 2F A7 3E 0C ";
            S = S + "28 01 3C D3 AB C9 3A EB FB 0F 0F 3E 03 30 01 3C ";
            S = S + "32 9B FC 38 0F 2A F8 F3 77 CD 5B 10 3A FA F3 BD ";
            S = S + "C8 22 F8 F3 3A DB F3 A7 C8 3A D9 FB A7 C0 3E 0F ";
            S = S + "32 D9 FB D3 AB 3E 0A 3D 20 FD A7 3E 0E 28 01 3C ";
            S = S + "D3 AB C9 3A EB FB 5F 1F 1F F5 7B 2F 30 10 1F 1F ";
            S = S + "07 E6 03 CB 4F 20 09 CB 63 20 05 F6 04 11 E6 01 ";
            S = S + "5F 87 83 87 87 87 87 5F 16 00 21 A5 0D 19 42 09 ";
            S = S + "F1 7E 3C CA 1F 0F 3D C8 38 16 E6 DF D6 40 FE 20 ";
            S = S + "D0 18 92 3A EB FB 0F 38 04 79 C6 05 4F C3 C5 0E ";
            S = S + "FE 20 30 0B F5 3E 01 CD 55 0F F1 C6 40 18 E2 21 ";
            S = S + "AB FC 34 35 28 0A FE 61 38 27 FE 7B 30 23 E6 DF ";
            S = S + "ED 5B AC FC 1C 1D 28 C9 57 F6 20 21 66 10 0E 06 ";
            S = S + "ED B9 7A 20 BC 23 0E 06 09 1D 20 FC 7E CB 6A 20 ";
            S = S + "B0 0E 1F 21 9D 10 ED B9 20 A7 0E 1F 23 09 7E 18 ";
            S = S + "A0 79 21 96 1B CD CC FD 16 0F BE 23 5E 23 D5 D8 ";
            S = S + "D1 18 F7 00 00 00 00 00 00 00 00 00 00 1B 09 00 ";
            S = S + "08 18 0D 20 0C 12 7F 1D 1E 1F 1C 00 00 00 30 31 ";
            S = S + "32 33 34 35 36 37 38 39 2D 2C 2E AF 32 AC FC 18 ";
            S = S + "61 61 65 69 6F 75 79 85 8A 8D 95 97 79 A0 82 A1 ";
            S = S + "A2 A3 79 83 88 8C 93 96 79 84 89 8B 94 81 98 83 ";
            S = S + "88 8C 93 96 84 89 8B 94 81 98 A0 82 A1 A2 A3 85 ";
            S = S + "8A 8D 95 97 B1 B3 B5 B7 A4 86 87 91 B9 79 41 45 ";
            S = S + "49 4F 55 8E 45 49 99 9A 59 41 90 49 4F 55 41 45 ";
            S = S + "49 4F 55 B0 B2 B4 B6 A5 8F 80 92 B8 59 00 00 00 ";
            S = S + "00 00 23 7D FE 18 C0 21 F0 FB C9 E5 D5 C5 CD C2 ";
            S = S + "FD CD 6A 0D 20 0B CD DA 09 CD 6A 0D 28 FB CD 27 ";
            S = S + "0A 21 9B FC 7E FE 04 20 02 36 00 2A FA F3 4E CD ";
            S = S + "C2 10 22 FA F3 79 C3 DB 08 E5 21 00 00 CD FB 03 ";
            S = S + "E1 C9 F3 D3 A0 F5 7B D3 A1 FB F1 C9 3E 0E D3 A0 ";
            S = S + "DB A2 C9 AF 1E 55 CD 02 11 5F 3C CD 02 11 1E BE ";
            S = S + "3E 07 CD 02 11 5F 3C CD 02 11 01 D0 07 CD 33 11 ";
            S = S + "C3 BD 04 0B E3 E3 78 B1 20 F9 C9 47 CD 70 14 2B ";
            S = S + "56 2B 5E 1B 73 23 72 7A B3 C0 78 32 3E FB CD E2 ";
            S = S + "11 FE FF 28 5B 57 E6 E0 07 07 07 4F 7A E6 1F 77 ";
            S = S + "CD E2 11 2B 77 0C 0D C8 CD E2 11 57 E6 C0 20 11 ";
            S = S + "CD E2 11 5F 78 07 CD 02 11 3C 5A CD 02 11 0D 18 ";
            S = S + "E5 67 E6 80 28 0F 5A 78 C6 08 CD 02 11 7B E6 10 ";
            S = S + "3E 0D C4 02 11 7C E6 40 28 CC CD E2 11 57 CD E2 ";
            S = S + "11 5F 3E 0B CD 02 11 3C 5A CD 02 11 0D 0D 18 B6 ";
            S = S + "78 C6 08 1E 00 CD 02 11 04 21 3F FB AF 37 17 10 ";
            S = S + "FD A6 AE 77 3A 3F FB B7 C0 21 40 FB 7E B7 C8 35 ";
            S = S + "21 01 00 22 41 FB 22 66 FB 22 8B FB 3E 07 32 3F ";
            S = S + "FB C9 3A 3E FB E5 D5 C5 CD AD 14 C3 DB 08 3D FA ";
            S = S + "00 12 CD 0C 12 21 33 12 E6 0F 5F 16 00 19 7E C9 ";
            S = S + "CD 26 12 0F 0F 0F 0F 21 43 12 18 EC 47 3E 0F F3 ";
            S = S + "CD 0E 11 10 06 E6 DF F6 4C 18 04 E6 AF F6 03 D3 ";
            S = S + "A1 CD 0C 11 FB C9 F3 DB AA E6 F0 C6 08 D3 AA DB ";
            S = S + "A9 FB C9 00 05 01 00 03 04 02 03 07 06 08 07 00 ";
            S = S + "05 01 00 00 03 05 04 01 02 00 03 07 00 06 05 08 ";
            S = S + "01 07 00 3D FA 6C 12 F5 E6 01 CD 0C 12 C1 05 05 ";
            S = S + "06 10 FA 67 12 06 20 A0 D6 01 9F C9 CD 26 12 E6 ";
            S = S + "01 18 F5 3C A7 1F F5 47 AF 37 17 10 FD 47 F1 0E ";
            S = S + "10 11 AF 03 30 05 0E 20 11 9F 4C 3E 0F F3 CD 0E ";
            S = S + "11 A3 B2 B1 D3 A1 A9 D3 A1 3E 0E D3 A0 0E 00 DB ";
            S = S + "A2 A0 28 05 0C C2 9F 12 0D FB 79 C9 FE 04 11 EC ";
            S = S + "0C 38 05 11 D3 03 D6 04 3D FA C5 12 3D 3A 9D FC ";
            S = S + "F8 3A 9C FC C8 F5 EB 22 66 F8 9F 2F E6 40 4F 3E ";
            S = S + "0F F3 CD 0E 11 E6 BF B1 D3 A1 F1 FA E8 12 CD 0C ";
            S = S + "11 FB E6 08 D6 01 9F C9 0E 00 CD 32 13 CD 32 13 ";
            S = S + "38 28 CD 20 13 38 23 D5 CD 20 13 C1 38 1C 78 92 ";
            S = S + "30 02 2F 3C FE 05 30 E0 79 93 30 02 2F 3C FE 05 ";
            S = S + "30 D6 7A 32 9D FC 7B 32 9C FC FB 7C D6 01 9F C9 ";
            S = S + "0E 0A CD 32 13 D8 55 D5 0E 00 CD 32 13 D1 5D AF ";
            S = S + "67 C9 CD 5B 13 06 08 51 CB 82 CB 92 CD 6D 13 CD ";
            S = S + "0C 11 67 1F 1F 1F CB 15 CB C2 CB D2 CD 6D 13 10 ";
            S = S + "E7 CB E2 CB EA CD 6D 13 7C 1F C9 3E 35 B1 57 CD ";
            S = S + "6D 13 CD 0C 11 E6 02 28 F9 CB A2 CB AA E5 D5 2A ";
            S = S + "66 F8 7D 2F A2 57 3E 0F D3 A0 DB A2 A5 B2 B4 D3 ";
            S = S + "A1 D1 E1 C9 A7 FA 92 13 20 03 3E 09 C2 3E 08 D3 ";
            S = S + "AB C9 DB AA E6 10 18 F0 CD D6 FD ED 45 01 A0 00 ";
            S = S + "11 7F F8 21 A9 13 ED B0 C9 63 6F 6C 6F 72 20 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 61 75 74 6F 20 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 67 6F 74 6F 20 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 6C 69 73 74 20 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 72 75 6E 0D 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 63 6F 6C 6F 72 20 31 ";
            S = S + "35 2C 34 2C 34 0D 00 00 00 63 6C 6F 61 64 22 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 63 6F 6E 74 0D 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 6C 69 73 74 2E 0D 1E ";
            S = S + "1E 00 00 00 00 00 00 00 00 0C 72 75 6E 0D 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 DB 99 C9 DB A8 C9 D3 ";
            S = S + "A8 C9 4F F3 DB AA E6 F0 81 D3 AA DB A9 FB C9 CD ";
            S = S + "DF FE E5 2A 64 F8 7D B4 E1 C9 7C 92 C0 7D 93 C9 ";
            S = S + "2E 02 18 03 3A 38 FB D5 11 41 FB 26 00 19 B7 28 ";
            S = S + "07 11 25 00 19 3D 20 FC D1 C9 CD A7 FF C9 CD AC ";
            S = S + "FF C9 CD FA 14 78 3C 23 A6 B9 C8 E5 2B 2B 2B E3 ";
            S = S + "23 4F 7E 23 66 6F 06 00 09 73 E1 71 C9 CD FA 14 ";
            S = S + "36 00 20 1D 79 B8 C8 23 3C A6 2B 2B E5 23 23 23 ";
            S = S + "4F 7E 23 66 6F 06 00 09 7E E1 71 B7 C0 3C 3E 00 ";
            S = S + "C9 4F 06 00 21 70 F9 09 7E C9 C5 CD 04 15 70 23 ";
            S = S + "70 23 70 23 F1 77 23 73 23 72 C9 CD FA 14 78 3C ";
            S = S + "23 A6 47 79 90 A6 6F 26 00 C9 CD 04 15 46 23 4E ";
            S = S + "23 7E B7 C9 07 47 07 80 4F 06 00 2A F3 F3 09 C9 ";
            S = S + "E5 D5 C5 F5 CD 9D 08 30 62 20 08 FE 0D 28 5F FE ";
            S = S + "20 38 58 CD 52 07 3A E9 F3 32 F2 F3 2A B9 FC EB ";
            S = S + "ED 4B B7 FC CD 99 15 30 42 CD DF 15 11 40 FC 0E ";
            S = S + "08 06 08 CD 39 16 E5 F5 1A 87 F5 DC 7E 16 CD AC ";
            S = S + "16 E1 38 04 E5 F1 10 F1 F1 E1 CD 40 16 CD 0A 17 ";
            S = S + "38 04 13 0D 20 DB CD D9 15 3A B7 FC 28 06 C6 20 ";
            S = S + "38 0C 18 04 C6 08 38 06 32 B7 FC C3 DA 08 AF 32 ";
            S = S + "B7 FC CD D9 15 3A B9 FC 28 03 C6 20 01 C6 08 FE ";
            S = S + "C0 38 01 AF 32 B9 FC 18 E2 E5 C5 06 01 EB 7C 87 ";
            S = S + "30 05 21 00 00 18 08 11 C0 00 E7 38 04 EB 2B 06 ";
            S = S + "00 E3 7C 87 30 05 21 00 00 18 08 11 00 01 E7 38 ";
            S = S + "04 EB 2B 06 00 D1 CD D9 15 28 08 CB 3D CB 3D CB ";
            S = S + "3B CB 3B 78 0F 44 4D E1 C9 3A AF FC D6 02 C9 C5 ";
            S = S + "CD D9 15 20 2E 51 79 E6 07 4F 21 0B 16 09 7E 32 ";
            S = S + "2C F9 7B 0F 0F 0F E6 1F 47 7A E6 F8 4F 7B E6 07 ";
            S = S + "B1 4F 2A CB F3 09 22 2A F9 C1 C9 80 40 20 10 08 ";
            S = S + "04 02 01 79 0F 3E F0 30 02 3E 0F 32 2C F9 79 87 ";
            S = S + "87 E6 F8 4F 7B E6 07 B1 4F 7B 0F 0F 0F E6 07 47 ";
            S = S + "2A D5 F3 09 22 2A F9 C1 C9 3A 2C F9 2A 2A F9 C9 ";
            S = S + "32 2C F9 22 2A F9 C9 C5 E5 CD 39 16 47 CD D9 15 ";
            S = S + "20 1A CD D7 07 A0 F5 01 00 20 09 CD D7 07 47 F1 ";
            S = S + "78 28 04 0F 0F 0F 0F E6 0F E1 C1 C9 CD D7 07 04 ";
            S = S + "05 F2 67 16 18 ED FE 10 3F D8 32 F2 F3 C9 E5 C5 ";
            S = S + "CD D9 15 CD 39 16 20 08 D5 CD 6C 18 D1 C1 E1 C9 ";
            S = S + "47 CD D7 07 4F 78 2F A1 4F 3A F2 F3 04 05 F2 A5 ";
            S = S + "16 87 87 87 87 B1 CD CD 07 C1 E1 C9 E5 CD D9 15 ";
            S = S + "C2 79 17 CD 39 16 0F 30 4B 7D E6 F8 FE F8 3E 80 ";
            S = S + "20 10 C3 5A 17 E5 CD D9 15 C2 8B 17 CD 39 16 0F ";
            S = S + "30 32 D5 11 08 00 18 27 E5 CD D9 15 C2 9C 17 CD ";
            S = S + "39 16 07 30 1F 7D E6 F8 3E 01 20 0F 18 6C E5 CD ";
            S = S + "D9 15 C2 AC 17 CD 39 16 07 30 09 D5 11 F8 FF 19 ";
            S = S + "22 2A F9 D1 32 2C F9 A7 E1 C9 E5 D5 2A 2A F9 CD ";
            S = S + "D9 15 C2 C6 17 E5 2A CB F3 11 00 17 19 EB E1 E7 ";
            S = S + "38 13 7D 3C E6 07 20 0D 18 2F E5 D5 2A 2A F9 CD ";
            S = S + "D9 15 C2 DC 17 23 7D 11 F8 00 18 31 E5 D5 2A 2A ";
            S = S + "F9 CD D9 15 C2 E3 17 E5 2A CB F3 11 00 01 19 EB ";
            S = S + "E1 E7 30 14 7D E6 07 20 0F D1 37 E1 C9 E5 D5 2A ";
            S = S + "2A F9 CD D9 15 C2 F8 17 7D 2B 11 08 FF E6 07 20 ";
            S = S + "01 19 22 2A F9 A7 D1 E1 C9 CD 39 16 A7 3E 0F FA ";
            S = S + "C0 17 7D E6 F8 FE F8 20 0B 18 CF CD 39 16 A7 3E ";
            S = S + "0F FA C0 17 D5 11 08 00 3E F0 18 1F CD 39 16 A7 ";
            S = S + "3E F0 F2 C0 17 7D E6 F8 20 0B 18 AE CD 39 16 A7 ";
            S = S + "3E F0 F2 C0 17 D5 11 F8 FF 3E 0F 19 22 2A F9 D1 ";
            S = S + "32 2C F9 A7 E1 C9 E5 2A D5 F3 11 00 05 19 E1 E7 ";
            S = S + "38 0A 7D 3C E6 07 20 04 37 D1 E1 C9 23 7D 11 F8 ";
            S = S + "00 18 1A E5 2A D5 F3 11 00 01 19 E1 E7 30 09 7D ";
            S = S + "E6 07 20 04 37 D1 E1 C9 7D 2B 11 08 FF E6 07 20 ";
            S = S + "01 19 22 2A F9 A7 D1 E1 C9 CD D9 15 C2 BB 18 E5 ";
            S = S + "CD 39 16 E3 87 38 18 F5 01 FF FF 0F 09 30 45 0F ";
            S = S + "30 FA F1 3D E3 E5 CD 6C 18 E1 11 08 00 19 E3 7D ";
            S = S + "E6 07 4F 7C 0F 7D 1F 0F 0F E6 3F E1 47 28 14 AF ";
            S = S + "CD CD 07 11 00 20 19 3A F2 F3 CD CD 07 11 08 20 ";
            S = S + "19 10 EC 0D F8 E5 21 5D 18 09 7E 18 0E 80 C0 E0 ";
            S = S + "F0 F8 FC FE 87 3D 2F 47 F1 3D A0 E1 47 CD D7 07 ";
            S = S + "4F 11 00 20 19 CD D7 07 F5 E6 0F 5F F1 93 57 3A ";
            S = S + "F2 F3 BB 28 19 87 87 87 87 BA 28 16 F5 78 B1 FE ";
            S = S + "FF 28 17 E5 D5 CD A2 18 D1 E1 F1 B3 18 1A 78 2F ";
            S = S + "A1 11 78 B1 11 00 20 19 18 0E F1 78 2F E5 D5 CD ";
            S = S + "A4 18 D1 E1 3A F2 F3 B2 C3 CD 07 E5 CD 7E 16 CD ";
            S = S + "C5 16 E1 2D 20 F5 C9 2A 0B F4 EB 2A 0D F4 C9 F5 ";
            S = S + "CD D9 15 28 06 F1 FE 10 3F 18 05 F1 3A F2 F3 A7 ";
            S = S + "32 B2 FC C9 21 00 00 4D CD D9 15 20 64 78 32 66 ";
            S = S + "F8 AF 32 69 F8 3A B2 FC 47 CD 47 16 B8 20 0D 1B ";
            S = S + "7A B3 C8 CD AC 16 30 F1 11 00 00 C9 CD AE 19 D5 ";
            S = S + "CD 39 16 22 42 F9 32 44 F9 11 00 00 13 CD AC 16 ";
            S = S + "38 0B CD 47 16 B8 28 05 CD AE 19 18 EF D5 CD 39 ";
            S = S + "16 E5 F5 2A 42 F9 3A 44 F9 CD 40 16 EB 22 67 F8 ";
            S = S + "3A 66 F8 A7 C4 09 18 F1 E1 CD 40 16 E1 D1 C3 A9 ";
            S = S + "19 CD C7 19 30 0D 1B 7A B3 C8 CD AC 16 30 F2 11 ";
            S = S + "00 00 C9 CD 39 16 22 42 F9 32 44 F9 21 00 00 23 ";
            S = S + "CD AC 16 D8 CD C7 19 30 F6 C9 21 00 00 4D CD D9 ";
            S = S + "15 20 37 AF 32 69 F8 3A B2 FC 47 CD D8 16 38 0F ";
            S = S + "CD 47 16 B8 28 06 CD AE 19 23 18 EF CD C5 16 E5 ";
            S = S + "ED 5B 67 F8 19 CD 09 18 E1 3A 69 F8 4F C9 E5 21 ";
            S = S + "F2 F3 BE E1 C8 3C 32 69 F8 C9 CD D8 16 D8 CD C7 ";
            S = S + "19 DA C5 16 23 18 F3 CD 47 16 47 3A B2 FC 90 37 ";
            S = S + "C8 3A F2 F3 B8 C8 CD 7E 16 0E 01 A7 C9 C5 F5 01 ";
            S = S + "00 00 0B 78 B1 20 FB F1 C1 F5 3E 09 D3 AB F1 FB ";
            S = S + "C9 B7 F5 3E 08 D3 AB 21 00 00 2B 7C B5 20 FB F1 ";
            S = S + "3A 0A F4 28 02 87 87 47 0E 00 F3 CD 4D 1A CD 3F ";
            S = S + "1A 0B 78 B1 20 F5 C3 6F 04 2A 06 F4 F5 7D D6 0E ";
            S = S + "6F CD 50 1A F1 06 08 0F DC 40 1A D4 39 1A 10 F7 ";
            S = S + "CD 40 1A CD 40 1A C3 6F 04 2A 06 F4 CD 50 1A C9 ";
            S = S + "CD 4D 1A E3 E3 00 00 00 00 CD 4D 1A C9 2A 08 F4 ";
            S = S + "F5 2D C2 51 1A 3E 0B D3 AB 25 C2 59 1A 3E 0A D3 ";
            S = S + "AB F1 C9 3E 08 D3 AB F3 3E 0E D3 A0 21 57 04 51 ";
            S = S + "CD 34 1B D8 79 FE DE 30 F3 FE 05 38 EF 92 30 02 ";
            S = S + "2F 3C FE 04 30 E6 2B 7C B5 20 E4 21 00 00 45 55 ";
            S = S + "CD 34 1B D8 09 15 C2 90 1A 01 AE 06 09 7C 1F E6 ";
            S = S + "7F 57 29 7C 92 57 D6 06 32 A4 FC 7A 87 06 00 D6 ";
            S = S + "03 04 30 FB 78 D6 03 32 A5 FC B7 C9 3A A4 FC 57 ";
            S = S + "CD 6F 04 D8 DB A2 07 30 F7 CD 6F 04 D8 DB A2 07 ";
            S = S + "38 F7 1E 00 CD 1F 1B 41 CD 1F 1B D8 78 81 DA D7 ";
            S = S + "1A BA 38 F3 2E 08 CD 03 1B FE 04 3F D8 FE 02 3F ";
            S = S + "CB 1A 79 0F D4 23 1B CD 1F 1B 2D C2 E6 1A CD 6F ";
            S = S + "04 7A C9 3A A5 FC 47 0E 00 DB A2 AB F2 17 1B 7B ";
            S = S + "2F 5F 0C 10 F4 79 C9 00 00 00 00 10 EC 79 C9 CD ";
            S = S + "6F 04 D8 0E 00 0C 28 0A DB A2 AB F2 25 1B 7B 2F ";
            S = S + "5F C9 0D C9 CD 6F 04 D8 DB A2 07 38 F7 1E 00 CD ";
            S = S + "23 1B C3 25 1B F5 CD E4 FE CD 5F 14 28 08 F1 DD ";
            S = S + "21 48 6C C3 FF 01 3A 16 F4 B7 28 5F 3A 18 F4 A7 ";
            S = S + "20 49 F1 F5 FE 09 20 0E 3E 20 CD 63 1B 3A 15 F4 ";
            S = S + "E6 07 20 F4 F1 C9 D6 0D 28 0A 38 0B FE 13 38 07 ";
            S = S + "3A 15 F4 3C 32 15 F4 3A 17 F4 A7 28 1E F1 CD 9D ";
            S = S + "08 D0 20 23 18 16 30 83 33 10 34 36 35 10 3A C3 ";
            S = S + "3C 10 3D 46 41 10 42 06 FF 10 00 F1 CD 5D 08 D0 ";
            S = S + "DD 21 B2 73 C3 FF 01 3E 20 18 F1 F1 C3 BC 08 00 ";
            S = S + "00 00 00 00 00 00 00 3C 42 A5 81 A5 99 42 3C 3C ";
            S = S + "7E DB FF FF DB 66 3C 6C FE FE FE 7C 38 10 00 10 ";
            S = S + "38 7C FE 7C 38 10 00 10 38 54 FE 54 10 38 00 10 ";
            S = S + "38 7C FE FE 10 38 00 00 00 00 30 30 00 00 00 FF ";
            S = S + "FF FF E7 E7 FF FF FF 38 44 82 82 82 44 38 00 C7 ";
            S = S + "BB 7D 7D 7D BB C7 FF 0F 03 05 79 88 88 88 70 38 ";
            S = S + "44 44 44 38 10 7C 10 30 28 24 24 28 20 E0 C0 3C ";
            S = S + "24 3C 24 24 E4 DC 18 10 54 38 EE 38 54 10 00 10 ";
            S = S + "10 10 7C 10 10 10 10 10 10 10 FF 00 00 00 00 00 ";
            S = S + "00 00 FF 10 10 10 10 10 10 10 F0 10 10 10 10 10 ";
            S = S + "10 10 1F 10 10 10 10 10 10 10 FF 10 10 10 10 10 ";
            S = S + "10 10 10 10 10 10 10 00 00 00 FF 00 00 00 00 00 ";
            S = S + "00 00 1F 10 10 10 10 00 00 00 F0 10 10 10 10 10 ";
            S = S + "10 10 1F 00 00 00 00 10 10 10 F0 00 00 00 00 81 ";
            S = S + "42 24 18 18 24 42 81 01 02 04 08 10 20 40 80 80 ";
            S = S + "40 20 10 08 04 02 01 00 10 10 FF 10 10 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 20 20 20 20 00 00 20 00 50 ";
            S = S + "50 50 00 00 00 00 00 50 50 F8 50 F8 50 50 00 20 ";
            S = S + "78 A0 70 28 F0 20 00 C0 C8 10 20 40 98 18 00 40 ";
            S = S + "A0 40 A8 90 98 60 00 10 20 40 00 00 00 00 00 10 ";
            S = S + "20 40 40 40 20 10 00 40 20 10 10 10 20 40 00 20 ";
            S = S + "A8 70 20 70 A8 20 00 00 20 20 F8 20 20 00 00 00 ";
            S = S + "00 00 00 00 20 20 40 00 00 00 78 00 00 00 00 00 ";
            S = S + "00 00 00 00 60 60 00 00 00 08 10 20 40 80 00 70 ";
            S = S + "88 98 A8 C8 88 70 00 20 60 A0 20 20 20 F8 00 70 ";
            S = S + "88 08 10 60 80 F8 00 70 88 08 30 08 88 70 00 10 ";
            S = S + "30 50 90 F8 10 10 00 F8 80 E0 10 08 10 E0 00 30 ";
            S = S + "40 80 F0 88 88 70 00 F8 88 10 20 20 20 20 00 70 ";
            S = S + "88 88 70 88 88 70 00 70 88 88 78 08 10 60 00 00 ";
            S = S + "00 20 00 00 20 00 00 00 00 20 00 00 20 20 40 18 ";
            S = S + "30 60 C0 60 30 18 00 00 00 F8 00 F8 00 00 00 C0 ";
            S = S + "60 30 18 30 60 C0 00 70 88 08 10 20 00 20 00 70 ";
            S = S + "88 08 68 A8 A8 70 00 20 50 88 88 F8 88 88 00 F0 ";
            S = S + "48 48 70 48 48 F0 00 30 48 80 80 80 48 30 00 E0 ";
            S = S + "50 48 48 48 50 E0 00 F8 80 80 F0 80 80 F8 00 F8 ";
            S = S + "80 80 F0 80 80 80 00 70 88 80 B8 88 88 70 00 88 ";
            S = S + "88 88 F8 88 88 88 00 70 20 20 20 20 20 70 00 38 ";
            S = S + "10 10 10 90 90 60 00 88 90 A0 C0 A0 90 88 00 80 ";
            S = S + "80 80 80 80 80 F8 00 88 D8 A8 A8 88 88 88 00 88 ";
            S = S + "C8 C8 A8 98 98 88 00 70 88 88 88 88 88 70 00 F0 ";
            S = S + "88 88 F0 80 80 80 00 70 88 88 88 A8 90 68 00 F0 ";
            S = S + "88 88 F0 A0 90 88 00 70 88 80 70 08 88 70 00 F8 ";
            S = S + "20 20 20 20 20 20 00 88 88 88 88 88 88 70 00 88 ";
            S = S + "88 88 88 50 50 20 00 88 88 88 A8 A8 D8 88 00 88 ";
            S = S + "88 50 20 50 88 88 00 88 88 88 70 20 20 20 00 F8 ";
            S = S + "08 10 20 40 80 F8 00 70 40 40 40 40 40 70 00 00 ";
            S = S + "00 80 40 20 10 08 00 70 10 10 10 10 10 70 00 20 ";
            S = S + "50 88 00 00 00 00 00 00 00 00 00 00 00 F8 00 40 ";
            S = S + "20 10 00 00 00 00 00 00 00 70 08 78 88 78 00 80 ";
            S = S + "80 B0 C8 88 C8 B0 00 00 00 70 88 80 88 70 00 08 ";
            S = S + "08 68 98 88 98 68 00 00 00 70 88 F8 80 70 00 10 ";
            S = S + "28 20 F8 20 20 20 00 00 00 68 98 98 68 08 70 80 ";
            S = S + "80 F0 88 88 88 88 00 20 00 60 20 20 20 70 00 10 ";
            S = S + "00 30 10 10 10 90 60 40 40 48 50 60 50 48 00 60 ";
            S = S + "20 20 20 20 20 70 00 00 00 D0 A8 A8 A8 A8 00 00 ";
            S = S + "00 B0 C8 88 88 88 00 00 00 70 88 88 88 70 00 00 ";
            S = S + "00 B0 C8 C8 B0 80 80 00 00 68 98 98 68 08 08 00 ";
            S = S + "00 B0 C8 80 80 80 00 00 00 78 80 F0 08 F0 00 40 ";
            S = S + "40 F0 40 40 48 30 00 00 00 90 90 90 90 68 00 00 ";
            S = S + "00 88 88 88 50 20 00 00 00 88 A8 A8 A8 50 00 00 ";
            S = S + "00 88 50 20 50 88 00 00 00 88 88 98 68 08 70 00 ";
            S = S + "00 F8 10 20 40 F8 00 18 20 20 40 20 20 18 00 20 ";
            S = S + "20 20 00 20 20 20 00 C0 20 20 10 20 20 C0 00 40 ";
            S = S + "A8 10 00 00 00 00 00 00 00 20 50 F8 00 00 00 70 ";
            S = S + "88 80 80 88 70 20 60 90 00 00 90 90 90 68 00 10 ";
            S = S + "20 70 88 F8 80 70 00 20 50 70 08 78 88 78 00 48 ";
            S = S + "00 70 08 78 88 78 00 20 10 70 08 78 88 78 00 20 ";
            S = S + "00 70 08 78 88 78 00 00 70 80 80 80 70 10 60 20 ";
            S = S + "50 70 88 F8 80 70 00 50 00 70 88 F8 80 70 00 20 ";
            S = S + "10 70 88 F8 80 70 00 50 00 00 60 20 20 70 00 20 ";
            S = S + "50 00 60 20 20 70 00 40 20 00 60 20 20 70 00 50 ";
            S = S + "00 20 50 88 F8 88 00 20 00 20 50 88 F8 88 00 10 ";
            S = S + "20 F8 80 F0 80 F8 00 00 00 6C 12 7E 90 6E 00 3E ";
            S = S + "50 90 9C F0 90 9E 00 60 90 00 60 90 90 60 00 90 ";
            S = S + "00 00 60 90 90 60 00 40 20 00 60 90 90 60 00 40 ";
            S = S + "A0 00 A0 A0 A0 50 00 40 20 00 A0 A0 A0 50 00 90 ";
            S = S + "00 90 90 B0 50 10 E0 50 00 70 88 88 88 70 00 50 ";
            S = S + "00 88 88 88 88 70 00 20 20 78 80 80 78 20 20 18 ";
            S = S + "24 20 F8 20 E2 5C 00 88 50 20 F8 20 F8 20 00 C0 ";
            S = S + "A0 A0 C8 9C 88 88 8C 18 20 20 F8 20 20 20 40 10 ";
            S = S + "20 70 08 78 88 78 00 10 20 00 60 20 20 70 00 20 ";
            S = S + "40 00 60 90 90 60 00 20 40 00 90 90 90 68 00 50 ";
            S = S + "A0 00 A0 D0 90 90 00 28 50 00 C8 A8 98 88 00 00 ";
            S = S + "70 08 78 88 78 00 F8 00 60 90 90 90 60 00 F0 20 ";
            S = S + "00 20 40 80 88 70 00 00 00 00 F8 80 80 00 00 00 ";
            S = S + "00 00 F8 08 08 00 00 84 88 90 A8 54 84 08 1C 84 ";
            S = S + "88 90 A8 58 A8 3C 08 20 00 00 20 20 20 20 00 00 ";
            S = S + "00 24 48 90 48 24 00 00 00 90 48 24 48 90 00 28 ";
            S = S + "50 20 50 88 F8 88 00 28 50 70 08 78 88 78 00 28 ";
            S = S + "50 00 70 20 20 70 00 28 50 00 20 20 20 70 00 28 ";
            S = S + "50 00 70 88 88 70 00 50 A0 00 60 90 90 60 00 28 ";
            S = S + "50 00 88 88 88 70 00 50 A0 00 A0 A0 A0 50 00 FC ";
            S = S + "48 48 48 E8 08 50 20 00 50 00 50 50 50 10 20 C0 ";
            S = S + "44 C8 54 EC 54 9E 04 10 A8 40 00 00 00 00 00 00 ";
            S = S + "20 50 88 50 20 00 00 88 10 20 40 80 28 00 00 7C ";
            S = S + "A8 A8 68 28 28 28 00 38 40 30 48 48 30 08 70 00 ";
            S = S + "00 00 00 00 00 FF FF F0 F0 F0 F0 0F 0F 0F 0F 00 ";
            S = S + "00 FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00 ";
            S = S + "00 00 3C 3C 00 00 00 FF FF FF FF FF FF 00 00 C0 ";
            S = S + "C0 C0 C0 C0 C0 C0 C0 0F 0F 0F 0F F0 F0 F0 F0 FC ";
            S = S + "FC FC FC FC FC FC FC 03 03 03 03 03 03 03 03 3F ";
            S = S + "3F 3F 3F 3F 3F 3F 3F 11 22 44 88 11 22 44 88 88 ";
            S = S + "44 22 11 88 44 22 11 FE 7C 38 10 00 00 00 00 00 ";
            S = S + "00 00 00 10 38 7C FE 80 C0 E0 F0 E0 C0 80 00 01 ";
            S = S + "03 07 0F 07 03 01 00 FF 7E 3C 18 18 3C 7E FF 81 ";
            S = S + "C3 E7 FF FF E7 C3 81 F0 F0 F0 F0 00 00 00 00 00 ";
            S = S + "00 00 00 0F 0F 0F 0F 0F 0F 0F 0F 00 00 00 00 00 ";
            S = S + "00 00 00 F0 F0 F0 F0 33 33 CC CC 33 33 CC CC 00 ";
            S = S + "20 20 50 50 88 F8 00 20 20 70 20 70 20 20 00 00 ";
            S = S + "00 00 50 88 A8 50 00 FF FF FF FF FF FF FF FF 00 ";
            S = S + "00 00 00 FF FF FF FF F0 F0 F0 F0 F0 F0 F0 F0 0F ";
            S = S + "0F 0F 0F 0F 0F 0F 0F FF FF FF FF 00 00 00 00 00 ";
            S = S + "00 68 90 90 90 68 00 30 48 48 70 48 48 70 C0 F8 ";
            S = S + "88 80 80 80 80 80 00 F8 50 50 50 50 50 98 00 F8 ";
            S = S + "88 40 20 40 88 F8 00 00 00 78 90 90 90 60 00 00 ";
            S = S + "50 50 50 50 68 80 80 00 50 A0 20 20 20 20 00 F8 ";
            S = S + "20 70 A8 A8 70 20 F8 20 50 88 F8 88 50 20 00 70 ";
            S = S + "88 88 88 50 50 D8 00 30 40 40 20 50 50 50 20 00 ";
            S = S + "00 00 50 A8 A8 50 00 08 70 A8 A8 A8 70 80 00 38 ";
            S = S + "40 80 F8 80 40 38 00 70 88 88 88 88 88 88 00 00 ";
            S = S + "F8 00 F8 00 F8 00 00 20 20 F8 20 20 00 F8 00 C0 ";
            S = S + "30 08 30 C0 00 F8 00 18 60 80 60 18 00 F8 00 10 ";
            S = S + "28 20 20 20 20 20 20 20 20 20 20 20 20 A0 40 00 ";
            S = S + "20 00 F8 00 20 00 00 00 50 A0 00 50 A0 00 00 00 ";
            S = S + "18 24 24 18 00 00 00 00 30 78 78 30 00 00 00 00 ";
            S = S + "00 00 00 30 00 00 00 3E 20 20 20 A0 60 20 00 A0 ";
            S = S + "50 50 50 00 00 00 00 40 A0 20 40 E0 00 00 00 00 ";
            S = S + "38 38 38 38 38 38 00 00 00 00 00 00 00 00 00 CD ";
            S = S + "DB FD 3A AA F6 A7 20 0D 2E 00 18 14 CD E0 FD 3E ";
            S = S + "3F DF 3E 20 DF CD E5 FD 2A DC F3 2D C4 29 0C 2C ";
            S = S + "22 CA FB AF 32 9B FC CD CB 10 21 37 24 0E 0B CD ";
            S = S + "19 09 F5 C4 FF 23 F1 30 EE 21 5D F5 C8 3F C9 F5 ";
            S = S + "FE 09 20 0F F1 3E 20 CD FF 23 3A DD F3 3D E6 07 ";
            S = S + "20 F3 C9 F1 21 A8 FC FE 01 28 0B FE 20 38 09 F5 ";
            S = S + "7E A7 C4 F2 24 F1 DF C9 36 00 DF 3E 3E AF F5 CD ";
            S = S + "2E 0A F1 32 AA FC C3 E1 09 08 61 25 12 E5 24 1B ";
            S = S + "FE 23 02 0E 26 06 F8 25 0E D7 25 05 B9 25 03 C5 ";
            S = S + "24 0D 5A 24 15 AE 25 7F 50 25 CD 6C 26 3A AA F6 ";
            S = S + "A7 28 02 26 01 E5 CD 2E 0A E1 11 5E F5 06 FE 2D ";
            S = S + "2C D5 C5 CD D8 0B C1 D1 A7 28 14 FE 20 30 0B 05 ";
            S = S + "28 1D 4F 3E 01 12 13 79 C6 40 12 13 05 28 10 24 ";
            S = S + "3A B0 F3 BC 30 DB D5 CD 1D 0C D1 26 01 28 D1 1B ";
            S = S + "1A FE 20 28 FA E5 D5 CD E1 09 D1 E1 13 AF 12 3E ";
            S = S + "0D A7 F5 CD 29 0C CD 8E 08 3E 0A DF AF 32 A8 FC ";
            S = S + "F1 37 E1 C9 2C CD 1D 0C 28 FA CD 2D 24 AF 32 5E ";
            S = S + "F5 26 01 E5 CD BD 04 CD 54 04 E1 38 D2 3A B1 FB ";
            S = S + "A7 20 CC 18 CD 21 A8 FC 7E EE FF 77 CA 2D 24 C3 ";
            S = S + "2C 24 CD 2E 0A 2A DC F3 0E 20 E5 C5 CD D8 0B D1 ";
            S = S + "C5 4B CD E6 0B C1 3A B0 F3 24 BC 7A 30 ED E1 CD ";
            S = S + "1D 0C 28 37 79 FE 20 F5 20 0A 3A B0 F3 BC 28 04 ";
            S = S + "F1 C3 E1 09 CD 2A 0C 2C C5 E5 CD 32 0C BD 38 05 ";
            S = S + "CD B7 0A 18 0F 21 DC F3 35 20 01 34 2E 01 CD 88 ";
            S = S + "0A E1 2D E5 E1 C1 F1 CA E1 09 2D 2C 26 01 18 AA ";
            S = S + "3A B0 F3 BC 20 05 CD 1D 0C 20 3A 3E 1C DF 2A DC ";
            S = S + "F3 E5 CD 2E 0A E1 25 C2 7A 25 24 E5 2D 28 0A 3A ";
            S = S + "B0 F3 67 CD 1D 0C 20 01 E3 E1 22 DC F3 3A B0 F3 ";
            S = S + "BC 28 12 24 CD D8 0B 25 CD E6 0B 24 24 3A B0 F3 ";
            S = S + "3C BC 20 F0 25 0E 20 CD E6 0B CD 1D 0C C2 E1 09 ";
            S = S + "E5 2C 26 01 CD D8 0B E3 CD E6 0B E1 18 CF CD 2E ";
            S = S + "0A CD 6C 26 22 DC F3 18 05 E5 CD 2E 0A E1 CD 1D ";
            S = S + "0C F5 CD EE 0A F1 20 05 26 01 2C 18 F1 CD E1 09 ";
            S = S + "AF 32 A8 FC C3 2D 24 CD 2E 0A 2A DC F3 2D 2C CD ";
            S = S + "1D 0C 28 FA 3A B0 F3 67 24 25 28 07 CD D8 0B FE ";
            S = S + "20 28 F6 CD 5B 0A 18 D5 CD 2E 0A CD 34 26 CD 24 ";
            S = S + "26 28 CA 38 F9 CD 24 26 28 C3 30 F9 18 BF CD 2E ";
            S = S + "0A CD 34 26 28 B7 30 F9 CD 34 26 28 B0 38 F9 CD ";
            S = S + "5B 0A 18 A9 2A DC F3 CD 5B 0A CD 32 0C 5F 3A B0 ";
            S = S + "F3 57 18 09 2A DC F3 CD 4C 0A 11 01 01 2A DC F3 ";
            S = S + "E7 C8 11 68 26 D5 CD D8 0B FE 30 3F D0 FE 3A D8 ";
            S = S + "FE 41 3F D0 FE 5B D8 FE 61 3F D0 FE 7B D8 FE 86 ";
            S = S + "3F D0 FE A0 D8 FE A6 3F 3E 00 3C C9 2D 28 05 CD ";
            S = S + "1D 0C 28 F8 2C 3A CA FB BD 26 01 C0 2A CA FB C9 ";
            S = S + "C3 76 7C C3 8C 55 C3 66 46 C3 97 55 21 47 F8 7E ";
            S = S + "B7 C8 EE 80 77 18 09 CD EF 2E 21 47 F8 7E B7 C8 ";
            S = S + "E6 7F 47 11 F6 F7 1A B7 CA 05 2F E6 7F 90 30 11 ";
            S = S + "2F 3C F5 E5 06 08 1A 4E 77 79 12 13 23 10 F7 E1 ";
            S = S + "F1 FE 10 D0 F5 AF 32 FE F7 32 4F F8 21 48 F8 F1 ";
            S = S + "CD A3 27 21 47 F8 3A F6 F7 AE FA F7 26 3A 4F F8 ";
            S = S + "32 FE F7 CD 59 27 D2 3C 27 EB 7E 34 AE FA 67 40 ";
            S = S + "CD DB 27 CB E6 18 45 CD 6B 27 21 F7 F7 01 00 08 ";
            S = S + "7E B7 20 08 23 0D 0D 10 F7 C3 7D 2E E6 F0 20 06 ";
            S = S + "E5 CD 97 27 E1 0D 3E 08 90 28 12 F5 C5 48 11 F7 ";
            S = S + "F7 06 00 ED B0 C1 F1 47 AF 12 13 10 FC 79 B7 28 ";
            S = S + "0B 21 F6 F7 46 86 77 A8 FA 67 40 C8 21 FE F7 06 ";
            S = S + "07 7E FE 50 D8 2B AF 37 8E 27 77 D0 2B 10 F9 7E ";
            S = S + "34 AE FA 67 40 23 36 10 C9 21 4E F8 11 FD F7 06 ";
            S = S + "07 AF 1A 8E 27 12 1B 2B 10 F8 C9 21 4F F8 7E FE ";
            S = S + "50 20 01 34 11 FE F7 06 08 AF 1A 9E 27 12 1B 2B ";
            S = S + "10 F8 D0 EB 7E EE 80 77 21 FE F7 06 08 AF 3E 00 ";
            S = S + "9E 27 77 2B 10 F8 C9 21 FE F7 C5 AF ED 6F 2B 10 ";
            S = S + "FB C1 C9 B7 1F F5 B7 CA E2 27 F5 2F 3C 4F 06 FF ";
            S = S + "11 07 00 19 54 5D 09 3E 08 81 4F C5 06 00 ED B8 ";
            S = S + "C1 F1 23 13 D5 47 AF 77 23 10 FC E1 F1 D0 79 E5 ";
            S = S + "C5 47 AF ED 67 23 10 FB C1 E1 C9 21 F7 F7 3E 08 ";
            S = S + "18 ED F1 D0 18 F8 CD 71 2E C8 3A 47 F8 B7 CA 7D ";
            S = S + "2E 47 21 F6 F7 AE E6 80 4F CB B8 7E E6 7F 80 47 ";
            S = S + "36 00 E6 C0 C8 FE C0 20 03 C3 67 40 78 C6 40 E6 ";
            S = S + "7F C8 B1 2B 77 11 45 F8 01 08 00 21 FD F7 D5 ED ";
            S = S + "B8 23 AF 06 08 77 23 10 FC D1 01 83 28 C5 CD 8A ";
            S = S + "28 E5 01 08 00 EB ED B8 EB 21 3D F8 06 08 CD 61 ";
            S = S + "27 D1 CD 8A 28 0E 07 11 4E F8 1A B7 20 04 1B 0D ";
            S = S + "18 F8 1A 1B D5 21 0D F8 87 38 08 28 14 11 08 00 ";
            S = S + "19 18 F5 F5 06 08 11 FD F7 E5 CD 61 27 E1 F1 18 ";
            S = S + "EC 06 0F 11 04 F8 21 05 F8 CD FE 2E 36 00 D1 0D ";
            S = S + "20 D0 C9 2B 7E 23 77 C3 FA 26 21 F8 FF 19 0E 03 ";
            S = S + "06 08 B7 1A 8F 27 77 2B 1B 10 F8 0D 20 F2 C9 3A ";
            S = S + "47 F8 B7 CA 58 40 47 21 F6 F7 7E B7 CA 7D 2E A8 ";
            S = S + "E6 80 4F CB B8 7E E6 7F 90 47 1F A8 E6 40 36 00 ";
            S = S + "28 07 78 E6 80 C0 C3 67 40 78 C6 41 E6 7F 77 28 ";
            S = S + "F5 B1 36 00 2B 77 11 FD F7 21 4E F8 06 07 AF BE ";
            S = S + "20 04 1B 2B 10 F9 22 F2 F7 EB 22 F0 F7 78 32 F4 ";
            S = S + "F7 21 3E F8 06 0F E5 C5 2A F2 F7 EB 2A F0 F7 3A ";
            S = S + "F4 F7 0E FF 0C 47 E5 D5 AF EB 1A 9E 27 12 2B 1B ";
            S = S + "10 F8 1A 98 12 D1 E1 3A F4 F7 30 E8 47 EB CD 61 ";
            S = S + "27 30 02 EB 34 79 C1 4F C5 CB 38 04 58 16 00 21 ";
            S = S + "F5 F7 19 CD 9A 27 C1 E1 78 0C 0D 20 36 FE 0F 28 ";
            S = S + "23 0F 07 30 2E C5 E5 21 F6 F7 06 08 AF BE 20 0F ";
            S = S + "23 10 FA E1 C1 CB 38 04 AF 77 23 10 FC 18 26 E1 ";
            S = S + "C1 78 18 0F 3A F5 F7 5F 3D 32 F5 F7 AB F2 F4 28 ";
            S = S + "C3 7D 2E 1F 79 38 05 B6 77 23 18 05 87 87 87 87 ";
            S = S + "77 05 C2 F6 28 21 FE F7 11 45 F8 06 08 CD FE 2E ";
            S = S + "C3 83 28 21 63 2D CD 3B 2C 3A F6 F7 E6 7F 32 F6 ";
            S = S + "F7 21 23 2D CD 32 2C CD 8D 2E 18 06 21 63 2D CD ";
            S = S + "3B 2C 3A F6 F7 B7 FC 80 2C CD CC 2C CD CF 30 CD ";
            S = S + "4D 2C CD E1 2C CD 8C 26 3A F6 F7 FE 40 DA F5 29 ";
            S = S + "3A F7 F7 FE 25 DA F5 29 FE 75 D2 EC 29 CD 4D 2C ";
            S = S + "21 11 2D CD 5C 2C CD 8C 26 C3 F5 29 21 1B 2D CD ";
            S = S + "50 2C CD 8C 26 21 EF 2D C3 88 2C CD CC 2C CD 93 ";
            S = S + "29 CD 6F 2C CD AC 29 CD DC 2C 3A 47 F8 B7 C2 9F ";
            S = S + "28 C3 67 40 3A F6 F7 B7 C8 FC 80 2C FE 41 DA 3C ";
            S = S + "2A CD 4D 2C 21 1B 2D CD 5C 2C CD 9F 28 CD 3C 2A ";
            S = S + "CD 4D 2C 21 43 2D CD 5C 2C C3 8C 26 21 4B 2D CD ";
            S = S + "47 2C FA 6C 2A CD CC 2C 21 53 2D CD 2C 2C CD 6F ";
            S = S + "2C 21 53 2D CD 3B 2C 21 1B 2D CD 32 2C CD DC 2C ";
            S = S + "CD 9F 28 CD 6C 2A 21 5B 2D C3 2C 2C 21 30 2E C3 ";
            S = S + "88 2C CD 71 2E FA 5A 47 CA 5A 47 21 F6 F7 7E F5 ";
            S = S + "36 41 21 2B 2D CD 47 2C FA 92 2A F1 3C F5 21 F6 ";
            S = S + "F7 35 F1 32 9D F6 CD CC 2C 21 1B 2D CD 2C 2C CD ";
            S = S + "6F 2C 21 1B 2D CD 32 2C CD DC 2C CD 9F 28 CD CC ";
            S = S + "2C CD 38 2C CD CC 2C CD CC 2C 21 C6 2D CD A3 2C ";
            S = S + "CD 6F 2C 21 A5 2D CD A3 2C CD DC 2C CD 9F 28 CD ";
            S = S + "DC 2C CD E6 27 21 33 2D CD 2C 2C CD DC 2C CD E6 ";
            S = S + "27 CD CC 2C 3A 9D F6 D6 41 6F 87 9F 67 CD CB 2F ";
            S = S + "CD 42 30 CD DC 2C CD 9A 26 21 3B 2D C3 3B 2C CD ";
            S = S + "71 2E C8 FA 5A 47 CD 4D 2C 3A F6 F7 B7 1F CE 20 ";
            S = S + "32 47 F8 3A F7 F7 B7 0F B7 0F E6 33 C6 10 32 48 ";
            S = S + "F8 3E 07 32 9D F6 CD CC 2C CD C7 2C CD 9F 28 CD ";
            S = S + "DC 2C CD 9A 26 21 11 2D CD 3B 2C CD 4D 2C CD E1 ";
            S = S + "2C 3A 9D F6 3D 20 DC C3 59 2C 21 09 2D CD 3B 2C ";
            S = S + "CD CC 2C CD 8A 2F 7D 17 9F BC 28 14 7C B7 F2 6D ";
            S = S + "2B CD 4F 30 CD E1 2C 21 13 2D C3 5C 2C C3 67 40 ";
            S = S + "22 9D F6 CD 3A 30 CD 4D 2C CD E1 2C CD 8C 26 21 ";
            S = S + "11 2D CD 47 2C F5 28 08 38 06 21 11 2D CD 32 2C ";
            S = S + "CD CC 2C 21 8C 2D CD 88 2C CD 6F 2C 21 6B 2D CD ";
            S = S + "9A 2C CD DC 2C CD C7 2C CD CC 2C CD 8C 26 21 3E ";
            S = S + "F8 CD 67 2C CD DC 2C CD E1 2C CD 9A 26 21 3E F8 ";
            S = S + "CD 50 2C CD 9F 28 F1 38 08 28 06 21 2B 2D CD 3B ";
            S = S + "2C 3A 9D F6 21 F6 F7 4E 86 77 A9 F0 C3 67 40 CD ";
            S = S + "71 2E 21 57 F8 28 2E FC 67 2C 21 3E F8 11 57 F8 ";
            S = S + "CD 6A 2C 21 F9 2C CD 50 2C 21 F1 2C CD 5C 2C 11 ";
            S = S + "45 F8 CD 2E 28 11 FE F7 21 58 F8 06 07 CD F7 2E ";
            S = S + "21 57 F8 36 00 CD 5C 2C 21 F6 F7 36 40 AF 32 FE ";
            S = S + "F7 C3 FA 26 11 01 2D 21 57 F8 18 3E CD 50 2C C3 ";
            S = S + "9A 26 CD 50 2C C3 8C 26 21 F6 F7 CD 50 2C C3 E6 ";
            S = S + "27 CD 50 2C C3 9F 28 CD 50 2C C3 5C 2F 21 F6 F7 ";
            S = S + "11 47 F8 EB CD 6A 2C EB C9 21 47 F8 11 F6 F7 18 ";
            S = S + "F2 CD CB 2F 21 57 F8 11 F6 F7 06 08 C3 F7 2E E1 ";
            S = S + "22 C5 F7 CD DC 2C CD CC 2C CD 59 2C 2A C5 F7 E9 ";
            S = S + "CD 8D 2E 21 8D 2E E3 E9 22 C5 F7 CD CC 2C 2A C5 ";
            S = S + "F7 CD 9A 2C CD DC 2C C3 E6 27 22 C5 F7 CD 38 2C ";
            S = S + "2A C5 F7 7E F5 23 E5 21 C5 F7 CD 67 2C E1 CD 5C ";
            S = S + "2C F1 3D C8 F5 E5 21 C5 F7 CD 3B 2C E1 CD 50 2C ";
            S = S + "E5 CD 9A 26 E1 18 EA 21 4E F8 18 03 21 FD F7 3E ";
            S = S + "04 D1 46 2B 4E 2B C5 3D 20 F8 EB E9 21 47 F8 18 ";
            S = S + "03 21 F6 F7 3E 04 D1 C1 71 23 70 23 3D 20 F8 EB ";
            S = S + "E9 00 14 38 98 20 42 08 21 00 21 13 24 86 54 05 ";
            S = S + "19 00 40 64 96 51 37 23 58 40 43 42 94 48 19 03 ";
            S = S + "24 40 50 00 00 00 00 00 00 00 00 41 10 00 00 00 ";
            S = S + "00 00 00 40 25 00 00 00 00 00 00 41 31 62 27 76 ";
            S = S + "60 16 84 40 86 85 88 96 38 06 50 41 23 02 58 50 ";
            S = S + "92 99 40 41 15 70 79 63 26 79 49 40 26 79 49 19 ";
            S = S + "24 31 12 41 17 32 05 08 07 56 89 40 52 35 98 77 ";
            S = S + "55 98 30 40 15 91 54 94 30 91 90 04 41 10 00 00 ";
            S = S + "00 00 00 00 43 15 93 74 15 23 60 31 44 27 09 31 ";
            S = S + "69 40 85 16 44 44 97 63 35 57 40 58 03 42 18 31 ";
            S = S + "23 60 15 92 75 43 83 14 06 72 12 93 71 44 51 78 ";
            S = S + "09 19 91 51 62 04 C0 71 43 33 82 15 32 26 41 62 ";
            S = S + "50 36 51 12 79 08 C2 13 68 23 70 24 15 03 41 85 ";
            S = S + "16 73 19 87 23 89 05 41 10 00 00 00 00 00 00 C2 ";
            S = S + "13 21 04 78 35 01 56 42 47 92 52 56 04 38 73 C2 ";
            S = S + "64 90 66 82 74 09 43 42 29 41 57 50 17 23 23 08 ";
            S = S + "C0 69 21 56 92 29 18 09 41 38 17 28 86 38 57 71 ";
            S = S + "C2 15 09 44 99 47 48 01 42 42 05 86 89 66 73 55 ";
            S = S + "C2 76 70 58 59 68 32 91 42 81 60 52 49 27 55 13 ";
            S = S + "C2 41 34 17 02 24 03 98 41 62 83 18 53 07 17 96 ";
            S = S + "08 BF 52 08 69 39 04 00 00 3F 75 30 71 49 13 48 ";
            S = S + "00 BF 90 81 34 32 24 70 50 40 11 11 07 94 18 40 ";
            S = S + "29 C0 14 28 57 08 55 48 84 40 19 99 99 99 94 89 ";
            S = S + "67 C0 33 33 33 33 33 31 60 41 10 00 00 00 00 00 ";
            S = S + "00 3A F6 F7 B7 C8 FE 2F 17 9F C0 3C C9 AF 32 F6 ";
            S = S + "F7 C9 CD A1 2E F0 EF FA 2B 32 CA 6D 40 21 F6 F7 ";
            S = S + "7E B7 C8 EE 80 77 C9 CD A1 2E 6F 17 9F 67 C3 99 ";
            S = S + "2F EF CA 6D 40 F2 71 2E 2A F8 F7 7C B5 C8 7C 18 ";
            S = S + "C7 EB 2A F8 F7 E3 E5 2A F6 F7 E3 E5 EB C9 CD DF ";
            S = S + "2E EB 22 F8 F7 60 69 22 F6 F7 EB C9 2A F8 F7 EB ";
            S = S + "2A F6 F7 4D 44 C9 4E 23 46 23 5E 23 56 23 C9 5E ";
            S = S + "23 56 23 4E 23 46 23 C9 11 F6 F7 06 04 18 08 11 ";
            S = S + "47 F8 EB 3A 63 F6 47 1A 77 13 23 10 FA C9 1A 77 ";
            S = S + "1B 2B 10 FA C9 21 47 F8 11 F2 2E 18 06 21 47 F8 ";
            S = S + "11 F3 2E D5 11 F6 F7 3A 63 F6 FE 04 D0 11 F8 F7 ";
            S = S + "C9 79 B7 CA 71 2E 21 77 2E E5 CD 71 2E 79 C8 21 ";
            S = S + "F6 F7 AE 79 F8 CD 3B 2F 1F A9 C9 79 BE C0 23 78 ";
            S = S + "BE C0 23 7B BE C0 23 7A 96 C0 E1 E1 C9 7A AC 7C ";
            S = S + "FA 78 2E BA 20 03 7D 93 C8 C3 79 2E 11 47 F8 1A ";
            S = S + "B7 CA 71 2E 21 77 2E E5 CD 71 2E 1A 4F C8 21 F6 ";
            S = S + "F7 AE 79 F8 06 08 1A 96 20 06 13 23 10 F8 C1 C9 ";
            S = S + "1F A9 C9 CD 5C 2F C2 77 2E C9 EF 2A F8 F7 F8 CA ";
            S = S + "6D 40 CD 5D 30 DA 67 40 EB 22 F8 F7 3E 02 32 63 ";
            S = S + "F6 C9 01 C5 32 11 76 80 CD 21 2F C0 21 00 80 D1 ";
            S = S + "18 E7 EF E0 FA C8 2F CA 6D 40 CD 53 30 CD 52 37 ";
            S = S + "23 78 B7 1F 47 C3 41 27 2A F8 F7 7C B7 F5 FC 21 ";
            S = S + "32 CD 53 30 EB 21 00 00 22 F6 F7 22 F8 F7 7A B3 ";
            S = S + "CA A7 66 01 00 05 21 F7 F7 E5 21 30 30 3E FF D5 ";
            S = S + "5E 23 56 23 E3 C5 44 4D 19 3C 38 FA 60 69 C1 D1 ";
            S = S + "EB 0C 0D 20 0B B7 28 1C F5 3E 40 80 32 F6 F7 F1 ";
            S = S + "0C E3 F5 79 1F 30 08 F1 87 87 87 87 77 18 04 F1 ";
            S = S + "B6 77 23 E3 7A B3 28 02 10 C3 E1 F1 F0 C3 8D 2E ";
            S = S + "F0 D8 18 FC 9C FF F6 FF FF FF EF D0 CA 6D 40 FC ";
            S = S + "C8 2F 21 00 00 22 FA F7 22 FC F7 7C 32 FE F7 3E ";
            S = S + "08 18 02 3E 04 C3 9E 2F EF C8 C3 6D 40 21 BA 30 ";
            S = S + "E5 21 F6 F7 7E E6 7F FE 46 D0 D6 41 30 06 B7 D1 ";
            S = S + "11 00 00 C9 3C 47 11 00 00 4A 23 79 0C 1F 7E 38 ";
            S = S + "06 1F 1F 1F 1F 18 01 23 E6 0F 22 F0 F7 62 6B 29 ";
            S = S + "D8 29 D8 19 D8 29 D8 5F 16 00 19 D8 EB 2A F0 F7 ";
            S = S + "10 D9 21 00 80 E7 3A F6 F7 D8 28 0A E1 B7 F0 EB ";
            S = S + "CD 21 32 EB B7 C9 B7 F0 E1 C9 37 C9 0B C9 EF F8 ";
            S = S + "CD 71 2E F2 CF 30 CD 8D 2E CD CF 30 C3 86 2E EF ";
            S = S + "F8 21 FE F7 0E 0E 30 08 CA 6D 40 21 FA F7 0E 06 ";
            S = S + "3A F6 F7 B7 FA 00 31 E6 7F D6 41 DA 7D 2E 3C 91 ";
            S = S + "D0 2F 3C 47 2B 7E E6 F0 77 05 C8 AF 77 10 F5 C9 ";
            S = S + "E6 7F D6 41 30 06 21 FF FF C3 99 2F 3C 91 D0 2F ";
            S = S + "3C 47 1E 00 2B 7E 57 E6 F0 77 BA 28 01 1C 05 28 ";
            S = S + "08 AF 77 BA 28 01 1C 10 EB 1C 1D C8 79 FE 06 01 ";
            S = S + "C1 10 11 00 00 CA 4E 32 EB 22 4D F8 22 4B F8 22 ";
            S = S + "49 F8 60 69 22 47 F8 C3 9A 26 E5 21 00 00 78 B1 ";
            S = S + "28 12 3E 10 29 DA 1D 60 EB 29 EB 30 04 09 DA 1D ";
            S = S + "60 3D 20 F0 EB E1 C9 7C 17 9F 47 CD 21 32 79 98 ";
            S = S + "18 03 7C 17 9F 47 E5 7A 17 9F 19 88 0F AC F2 AF ";
            S = S + "2F C5 EB CD CB 2F F1 E1 CD B1 2E CD CB 2F C1 D1 ";
            S = S + "C3 4E 32 7C B5 CA 99 2F E5 D5 CD 15 32 C5 44 4D ";
            S = S + "21 00 00 3E 10 29 38 1F EB 29 EB 30 03 09 38 17 ";
            S = S + "3D 20 F2 C1 D1 7C B7 FA BF 31 D1 78 C3 1D 32 EE ";
            S = S + "80 B5 28 14 EB 18 02 C1 E1 CD CB 2F E1 CD B1 2E ";
            S = S + "CD CB 2F C1 D1 C3 5C 32 78 B7 C1 FA 99 2F D5 CD ";
            S = S + "CB 2F D1 C3 8D 2E 7C B5 CA 58 40 CD 15 32 C5 EB ";
            S = S + "CD 21 32 44 4D 21 00 00 3E 11 B7 18 09 E5 09 30 ";
            S = S + "04 33 33 37 30 E1 CB 13 CB 12 ED 6A 3D 20 EE EB ";
            S = S + "C1 D5 C3 B5 31 7C AA 47 CD 1C 32 EB 7C B7 F2 99 ";
            S = S + "2F AF 4F 95 6F 79 9C 67 C3 99 2F 2A F8 F7 CD 21 ";
            S = S + "32 7C EE 80 B5 C0 AF C3 CC 2F D5 CD E6 31 AF 82 ";
            S = S + "1F 67 7B 1F 6F CD 9C 2F F1 18 D2 CD DF 2E CD 80 ";
            S = S + "32 CD 42 30 C3 9A 26 CD 8D 2E 18 F2 CD 80 32 CD ";
            S = S + "42 30 C3 E6 27 C1 D1 2A F8 F7 EB 22 F8 F7 C5 2A ";
            S = S + "F6 F7 E3 22 F6 F7 C1 CD 80 32 CD 42 30 C3 9F 28 ";
            S = S + "EB 22 49 F8 60 69 22 47 F8 21 00 00 22 4B F8 22 ";
            S = S + "4D F8 C9 3D C9 2B C9 E1 C9 EB 01 FF 00 60 68 CD ";
            S = S + "99 2F EB 7E FE 26 CA B8 4E FE 2D F5 28 05 FE 2B ";
            S = S + "28 01 2B D7 DA 86 33 FE 2E CA 4F 33 FE 65 28 02 ";
            S = S + "FE 45 20 1A E5 D7 FE 6C 28 0A FE 4C 28 06 FE 71 ";
            S = S + "28 02 FE 51 E1 28 06 EF 30 1B AF 18 19 7E FE 25 ";
            S = S + "CA 62 33 FE 23 CA 70 33 FE 21 CA 71 33 FE 64 28 ";
            S = S + "04 FE 44 20 29 B7 CD 77 33 D7 D5 16 00 CD 47 4F ";
            S = S + "4A D1 D7 30 13 7B FE 0C 30 0A 07 07 83 07 86 D6 ";
            S = S + "30 5F 18 EE 1E 80 18 EA 0C 20 03 AF 93 5F EF FA ";
            S = S + "34 33 3A F6 F7 B7 28 0C 7A 90 83 C6 40 32 F6 F7 ";
            S = S + "B7 FC 4C 33 F1 E5 CC 86 2E EF 30 0B E1 E8 E5 21 ";
            S = S + "97 32 E5 CD A2 2F C9 CD 3C 27 E1 C9 C3 67 40 EF ";
            S = S + "0C 20 CB 30 0A CD 77 33 3A F6 F7 B7 20 01 57 C3 ";
            S = S + "B3 32 D7 F1 E5 21 97 32 E5 21 8A 2F E5 F5 18 AE ";
            S = S + "B7 CD 77 33 D7 18 A7 E5 D5 C5 F5 CC B2 2F F1 C4 ";
            S = S + "3A 30 C1 D1 E1 C9 D6 30 C2 93 33 B1 CA 93 33 A2 ";
            S = S + "CA B3 32 14 7A FE 07 20 04 B7 CD 77 33 D5 78 81 ";
            S = S + "3C 47 C5 E5 7E D6 30 F5 EF F2 D1 33 2A F8 F7 11 ";
            S = S + "CD 0C E7 30 19 54 5D 29 29 19 29 F1 4F 09 7C B7 ";
            S = S + "FA CC 33 22 F8 F7 E1 C1 D1 C3 B3 32 79 F5 CD C8 ";
            S = S + "2F F1 E1 C1 D1 20 0C 3A F6 F7 B7 3E 00 20 04 57 ";
            S = S + "C3 B3 32 D5 C5 E5 F5 21 F6 F7 36 01 7A FE 10 38 ";
            S = S + "03 F1 18 D2 3C B7 1F 06 00 4F 09 F1 4F 7A 1F 79 ";
            S = S + "30 04 87 87 87 87 B6 77 18 BC E5 21 D2 3F CD 78 ";
            S = S + "66 E1 01 77 66 C5 CD 99 2F AF 32 9D F6 21 C6 F7 ";
            S = S + "36 20 B6 18 1C AF CD 5F 37 E6 08 28 02 36 2B EB ";
            S = S + "CD A1 2E EB F2 41 34 36 2D C5 E5 CD 86 2E E1 C1 ";
            S = S + "B4 23 36 30 3A 9D F6 57 17 3A 63 F6 DA F7 34 CA ";
            S = S + "EF 34 FE 04 D2 A1 34 01 00 00 CD DB 36 21 C6 F7 ";
            S = S + "46 0E 20 3A 9D F6 5F E6 20 28 0C 78 B9 0E 2A 20 ";
            S = S + "06 7B E6 04 20 01 41 71 D7 28 14 FE 45 28 10 FE ";
            S = S + "44 28 0C FE 30 28 F0 FE 2C 28 EC FE 2E 20 03 2B ";
            S = S + "36 30 7B E6 10 28 03 2B 36 24 7B E6 04 C0 2B 70 ";
            S = S + "C9 E5 CD 52 37 50 14 01 00 03 3A F6 F7 D6 3F 38 ";
            S = S + "08 14 BA 30 04 3C 47 3E 02 D6 02 E1 F5 CD 8E 36 ";
            S = S + "36 30 CC E6 2E CD B3 36 2B 7E FE 30 28 FA FE 2E ";
            S = S + "C4 E6 2E F1 28 1A 36 45 23 36 2B F2 E2 34 36 2D ";
            S = S + "2F 3C 06 2F 04 D6 0A 30 FB C6 3A 23 70 23 77 23 ";
            S = S + "36 00 EB 21 C6 F7 C9 23 C5 FE 04 7A D2 66 35 1F ";
            S = S + "DA EF 35 01 03 06 CD 86 36 D1 7A D6 05 F4 66 36 ";
            S = S + "CD DB 36 7B B7 CC 95 32 3D F4 66 36 E5 CD 5D 34 ";
            S = S + "E1 28 02 70 23 36 00 21 C5 F7 23 3A BC F6 95 92 ";
            S = S + "C8 7E FE 20 28 F4 FE 2A 28 F0 2B E5 F5 01 3C 35 ";
            S = S + "C5 D7 FE 2D C8 FE 2B C8 FE 24 C8 C1 FE 30 20 0F ";
            S = S + "23 D7 30 0B 2B 18 02 2B 77 F1 28 FB C1 18 CC F1 ";
            S = S + "28 FD E1 36 25 C9 E5 1F DA F5 35 CD 52 37 50 3A ";
            S = S + "F6 F7 D6 4F 38 0B E1 C1 CD 25 34 21 C5 F7 36 25 ";
            S = S + "C9 CD 71 2E C4 A2 37 E1 C1 FA A6 35 C5 5F 78 92 ";
            S = S + "93 F4 66 36 CD 7A 36 CD B3 36 B3 C4 74 36 B3 C4 ";
            S = S + "A0 36 D1 C3 13 35 5F 79 B7 C4 93 32 83 FA B1 35 ";
            S = S + "AF C5 F5 FC 7B 37 C1 7B 90 C1 5F 82 78 FA CB 35 ";
            S = S + "92 93 F4 66 36 C5 CD 7A 36 18 11 CD 66 36 79 CD ";
            S = S + "A3 36 4F AF 92 93 CD 66 36 C5 47 4F CD B3 36 C1 ";
            S = S + "B1 20 03 2A BC F6 83 3D F4 66 36 50 C3 1C 35 E5 ";
            S = S + "D5 CD C8 2F D1 CD 52 37 58 CD 71 2E F5 C4 A2 37 ";
            S = S + "F1 E1 C1 F5 79 B7 F5 C4 93 32 80 4F 7A E6 04 FE ";
            S = S + "01 9F 57 81 4F 93 F5 F2 28 36 CD 7B 37 20 09 E5 ";
            S = S + "CD DB 27 21 F6 F7 34 E1 F1 C5 F5 FA 2F 36 AF 2F ";
            S = S + "3C 80 3C 82 47 0E 00 CC 8E 36 CD B3 36 F1 F4 6E ";
            S = S + "36 CD A0 36 C1 F1 20 0C CD 95 32 7E FE 2E C4 E6 ";
            S = S + "2E 22 BC F6 F1 3A F6 F7 28 03 83 90 92 C5 CD D6 ";
            S = S + "34 EB D1 C3 1C 35 B7 C8 3D 36 30 23 18 F9 20 04 ";
            S = S + "C8 CD A0 36 36 30 23 3D 18 F6 7B 82 3C 47 3C D6 ";
            S = S + "03 30 FC C6 05 4F 3A 9D F6 E6 40 C0 4F C9 05 F2 ";
            S = S + "A1 36 22 BC F6 36 2E 23 36 30 04 48 20 F9 23 C9 ";
            S = S + "05 20 08 36 2E 22 BC F6 23 48 C9 0D C0 36 2C 23 ";
            S = S + "0E 03 C9 D5 E5 C5 CD 52 37 78 C1 E1 11 F7 F7 37 ";
            S = S + "F5 CD A0 36 1A 30 06 1F 1F 1F 1F 18 01 13 E6 0F ";
            S = S + "C6 30 77 23 F1 3D 3F 20 E7 18 2F D5 11 10 37 3E ";
            S = S + "05 CD A0 36 C5 F5 E5 EB 4E 23 46 C5 23 E3 EB 2A ";
            S = S + "F8 F7 06 2F 04 7D 93 6F 7C 9A 67 30 F7 19 22 F8 ";
            S = S + "F7 D1 E1 70 23 F1 C1 3D 20 D7 CD A0 36 77 D1 C9 ";
            S = S + "10 27 E8 03 64 00 0A 00 01 00 06 01 18 06 06 03 ";
            S = S + "18 02 06 04 C5 CD 39 54 11 D6 F7 AF 12 C1 4F C5 ";
            S = S + "1B A7 7C 1F 67 7D 1F 6F 79 1F 4F 10 F4 C1 C5 07 ";
            S = S + "10 FD C6 30 FE 3A 38 02 C6 07 12 C1 7D B4 20 DF ";
            S = S + "EB C9 EF 21 FD F7 06 0E D0 21 F9 F7 06 06 C9 32 ";
            S = S + "9D F6 F5 C5 D5 CD 3A 30 21 13 2D 3A F6 F7 A7 CC ";
            S = S + "5C 2C D1 C1 F1 21 C6 F7 36 20 C9 E5 D5 C5 F5 2F ";
            S = S + "3C 5F 3E 01 CA 9C 37 CD 52 37 E5 CD DB 27 1D 20 ";
            S = S + "FA E1 23 78 0F 47 CD 41 27 CD B4 37 C1 80 C1 D1 ";
            S = S + "E1 C9 C5 E5 CD 52 37 3A F6 F7 D6 40 90 32 F6 F7 ";
            S = S + "E1 C1 B7 C9 C5 CD 52 37 7E E6 0F 20 08 05 7E B7 ";
            S = S + "20 03 2B 10 F3 78 C1 C9 CD 80 32 CD 42 30 CD C7 ";
            S = S + "2C CD 6F 2C CD DC 2C 3A 47 F8 B7 CA 43 38 67 3A ";
            S = S + "F6 F7 B7 CA 4D 38 CD CC 2C CD 1A 39 38 3C EB 22 ";
            S = S + "9F F6 CD 4F 30 CD DC 2C CD 1A 39 CD 4F 30 2A 9F ";
            S = S + "F6 D2 5A 38 3A 47 F8 F5 E5 CD 59 2C 21 C5 F7 CD ";
            S = S + "67 2C 21 1B 2D CD 5C 2C E1 7C B7 F5 F2 26 38 AF ";
            S = S + "4F 95 6F 79 9C 67 E5 C3 94 38 CD 4F 30 CD 59 2C ";
            S = S + "CD 6F 2C CD 72 2A CD DC 2C CD E6 27 C3 4A 2B 7C ";
            S = S + "B5 20 06 21 01 00 C3 57 38 7A B3 20 0D 7C 17 30 ";
            S = S + "03 C3 58 40 21 00 00 C3 99 2F 22 9F F6 D5 7C B7 ";
            S = S + "F5 FC 21 32 44 4D 21 01 00 B7 78 1F 47 79 1F 4F ";
            S = S + "30 05 CD 0D 39 20 4C 78 B1 28 63 E5 62 6B CD 0D ";
            S = S + "39 EB E1 28 E4 C5 E5 21 C5 F7 CD 67 2C E1 CD CB ";
            S = S + "2F CD 42 30 C1 78 B7 1F 47 79 1F 4F 30 08 C5 21 ";
            S = S + "C5 F7 CD 3B 2C C1 78 B1 28 34 C5 CD CC 2C 21 C5 ";
            S = S + "F7 E5 CD 5C 2C E1 E5 CD 3B 2C E1 CD 67 2C CD E1 ";
            S = S + "2C 18 D1 C5 D5 CD 3A 30 CD 4D 2C E1 CD CB 2F CD ";
            S = S + "42 30 21 C5 F7 CD 67 2C CD 59 2C C1 18 C8 F1 C1 ";
            S = S + "F0 3A 63 F6 FE 02 20 08 C5 CD CB 2F CD 42 30 C1 ";
            S = S + "3A F6 F7 B7 20 0B 2A 9F F6 B4 F0 7D 0F A0 C3 67 ";
            S = S + "40 CD 4D 2C 21 1B 2D CD 5C 2C C3 9F 28 C5 D5 CD ";
            S = S + "93 31 3A 63 F6 FE 02 D1 C1 C9 CD 59 2C CD C7 2C ";
            S = S + "CD CF 30 CD DC 2C CD 5C 2F 37 C0 C3 5D 30 EA 63 ";
            S = S + "24 45 27 65 5B 48 6C 4B 9F 5E 9F 4B 80 48 E8 47 ";
            S = S + "9E 47 E5 49 C9 63 B2 47 21 48 5D 48 E3 63 24 4A ";
            S = S + "AF 64 2E 52 86 62 E4 48 1C 40 1D 50 23 54 24 64 ";
            S = S + "B7 6F 3F 70 16 40 1D 4A 29 52 C3 00 C9 51 5D 48 ";
            S = S + "38 64 39 64 3E 64 77 64 AA 49 5D 49 E2 53 B5 49 ";
            S = S + "68 54 18 47 1B 47 1E 47 21 47 0E 4B B7 6A 52 7C ";
            S = S + "5B 77 58 77 14 6C 5D 6B 5E 6B 2F 6C 48 7C 4D 7C ";
            S = S + "A3 6B 2A 6C 11 5B 80 79 6E 5D C5 59 C0 00 E5 73 ";
            S = S + "EA 57 E5 57 CA 73 CC 79 E2 7B 48 7A 37 7B 5A 7B ";
            S = S + "A8 55 11 79 6C 78 4B 7E B7 73 C6 6E 92 6E 16 7C ";
            S = S + "1B 7C 20 7C 25 7C 2A 7C 2F 7C 34 7C 66 77 61 68 ";
            S = S + "91 68 9A 68 97 2E CF 30 82 2E FF 2A DF 2B AC 29 ";
            S = S + "72 2A 4A 2B 93 29 FB 29 14 2A F2 69 01 40 CC 4F ";
            S = S + "FF 67 04 66 BB 68 0B 68 1B 68 1C 54 F5 7B 48 68 ";
            S = S + "F5 65 FA 65 C7 4F FF 65 8A 2F B2 2F 3A 30 BE 30 ";
            S = S + "40 79 4C 79 5A 79 69 79 39 7C 39 6D 66 7C 6B 7C ";
            S = S + "70 7C 25 6D 03 6D 14 6D 57 7C 5C 7C 61 7C 72 3A ";
            S = S + "88 3A 9F 3A F3 3A 2E 3B 4F 3B 69 3B 7B 3B 80 3B ";
            S = S + "9F 3B A0 3B A8 3B E8 3B 09 3C 18 3C 2B 3C 5D 3C ";
            S = S + "5E 3C 8E 3C DB 3C F6 3C FF 3C 16 3D 20 3D 24 3D ";
            S = S + "25 3D 55 54 CF A9 4E C4 F6 42 D3 06 54 CE 0E 53 ";
            S = S + "C3 15 54 54 52 A4 E9 00 41 53 C5 C9 53 41 56 C5 ";
            S = S + "D0 4C 4F 41 C4 CF 45 45 D0 C0 49 4E A4 1D 00 41 ";
            S = S + "4C CC CA 4C 4F 53 C5 B4 4F 50 D9 D6 4F 4E D4 99 ";
            S = S + "4C 45 41 D2 92 4C 4F 41 C4 9B 53 41 56 C5 9A 53 ";
            S = S + "52 4C 49 CE E8 49 4E D4 1E 53 4E C7 1F 44 42 CC ";
            S = S + "20 56 C9 28 56 D3 29 56 C4 2A 4F D3 0C 48 52 A4 ";
            S = S + "16 49 52 43 4C C5 BC 4F 4C 4F D2 BD 4C D3 9F 4D ";
            S = S + "C4 D7 00 45 4C 45 54 C5 A8 41 54 C1 84 49 CD 86 ";
            S = S + "45 46 53 54 D2 AB 45 46 49 4E D4 AC 45 46 53 4E ";
            S = S + "C7 AD 45 46 44 42 CC AE 53 4B 4F A4 D1 45 C6 97 ";
            S = S + "53 4B 49 A4 EA 53 4B C6 26 52 41 D7 BE 00 4C 53 ";
            S = S + "C5 A1 4E C4 81 52 41 53 C5 A5 52 52 4F D2 A6 52 ";
            S = S + "CC E1 52 D2 E2 58 D0 0B 4F C6 2B 51 D6 F9 00 4F ";
            S = S + "D2 82 49 45 4C C4 B1 49 4C 45 D3 B7 CE DE 52 C5 ";
            S = S + "0F 49 D8 21 50 4F D3 27 00 4F 54 CF 89 4F 20 54 ";
            S = S + "CF 89 4F 53 55 C2 8D 45 D4 B2 00 45 58 A4 1B 00 ";
            S = S + "4E 50 55 D4 85 C6 8B 4E 53 54 D2 E5 4E D4 05 4E ";
            S = S + "D0 10 4D D0 FA 4E 4B 45 59 A4 EC 50 CC D5 00 00 ";
            S = S + "49 4C CC D4 45 D9 CC 00 50 52 49 4E D4 9D 4C 49 ";
            S = S + "53 D4 9E 50 4F D3 1C 45 D4 88 4F 43 41 54 C5 D8 ";
            S = S + "49 4E C5 AF 4F 41 C4 B5 53 45 D4 B8 49 53 D4 93 ";
            S = S + "46 49 4C 45 D3 BB 4F C7 0A 4F C3 2C 45 CE 12 45 ";
            S = S + "46 54 A4 01 4F C6 2D 00 4F 54 4F D2 CE 45 52 47 ";
            S = S + "C5 B6 4F C4 FB 4B 49 A4 2E 4B 53 A4 2F 4B 44 A4 ";
            S = S + "30 49 44 A4 03 41 D8 CD 00 45 58 D4 83 41 4D C5 ";
            S = S + "D3 45 D7 94 4F D4 E0 00 50 45 CE B0 55 D4 9C CE ";
            S = S + "95 D2 F7 43 54 A4 1A 46 C6 EB 00 52 49 4E D4 91 ";
            S = S + "55 D4 B3 4F 4B C5 98 4F D3 11 45 45 CB 17 53 45 ";
            S = S + "D4 C2 52 45 53 45 D4 C3 4F 49 4E D4 ED 41 49 4E ";
            S = S + "D4 BF 44 CC 24 41 C4 25 4C 41 D9 C1 00 00 45 54 ";
            S = S + "55 52 CE 8E 45 41 C4 87 55 CE 8A 45 53 54 4F 52 ";
            S = S + "C5 8C 45 CD 8F 45 53 55 4D C5 A7 53 45 D4 B9 49 ";
            S = S + "47 48 54 A4 02 4E C4 08 45 4E 55 CD AA 00 43 52 ";
            S = S + "45 45 CE C5 50 52 49 54 C5 C7 54 4F D0 90 57 41 ";
            S = S + "D0 A4 45 D4 D2 41 56 C5 BA 50 43 A8 DF 54 45 D0 ";
            S = S + "DC 47 CE 04 51 D2 07 49 CE 09 54 52 A4 13 54 52 ";
            S = S + "49 4E 47 A4 E3 50 41 43 45 A4 19 4F 55 4E C4 C4 ";
            S = S + "54 49 43 CB 22 54 52 49 C7 23 00 48 45 CE DA 52 ";
            S = S + "4F CE A2 52 4F 46 C6 A3 41 42 A8 DB CF D9 49 4D ";
            S = S + "C5 CB 41 CE 0D 00 53 49 4E C7 E4 53 D2 DD 00 41 ";
            S = S + "CC 14 41 52 50 54 D2 E7 44 D0 C8 50 4F 4B C5 C6 ";
            S = S + "50 45 45 CB 18 00 49 44 54 C8 A0 41 49 D4 96 00 ";
            S = S + "4F D2 F8 00 00 00 AB F1 AD F2 AA F3 AF F4 DE F5 ";
            S = S + "DC FC A7 E6 BE EE BD EF BC F0 00 79 79 7C 7C 7F ";
            S = S + "50 46 3C 32 28 7A 7B 3A 30 00 00 8A 2F 58 30 B2 ";
            S = S + "2F 9A 26 8C 26 E6 27 9F 28 D7 37 83 2F 4E 32 57 ";
            S = S + "32 5C 32 67 32 C8 37 21 2F 72 31 67 31 93 31 B8 ";
            S = S + "4D 3F 38 4D 2F 00 4E 45 58 54 20 77 69 74 68 6F ";
            S = S + "75 74 20 46 4F 52 00 53 79 6E 74 61 78 20 65 72 ";
            S = S + "72 6F 72 00 52 45 54 55 52 4E 20 77 69 74 68 6F ";
            S = S + "75 74 20 47 4F 53 55 42 00 4F 75 74 20 6F 66 20 ";
            S = S + "44 41 54 41 00 49 6C 6C 65 67 61 6C 20 66 75 6E ";
            S = S + "63 74 69 6F 6E 20 63 61 6C 6C 00 4F 76 65 72 66 ";
            S = S + "6C 6F 77 00 4F 75 74 20 6F 66 20 6D 65 6D 6F 72 ";
            S = S + "79 00 55 6E 64 65 66 69 6E 65 64 20 6C 69 6E 65 ";
            S = S + "20 6E 75 6D 62 65 72 00 53 75 62 73 63 72 69 70 ";
            S = S + "74 20 6F 75 74 20 6F 66 20 72 61 6E 67 65 00 52 ";
            S = S + "65 64 69 6D 65 6E 73 69 6F 6E 65 64 20 61 72 72 ";
            S = S + "61 79 00 44 69 76 69 73 69 6F 6E 20 62 79 20 7A ";
            S = S + "65 72 6F 00 49 6C 6C 65 67 61 6C 20 64 69 72 65 ";
            S = S + "63 74 00 54 79 70 65 20 6D 69 73 6D 61 74 63 68 ";
            S = S + "00 4F 75 74 20 6F 66 20 73 74 72 69 6E 67 20 73 ";
            S = S + "70 61 63 65 00 53 74 72 69 6E 67 20 74 6F 6F 20 ";
            S = S + "6C 6F 6E 67 00 53 74 72 69 6E 67 20 66 6F 72 6D ";
            S = S + "75 6C 61 20 74 6F 6F 20 63 6F 6D 70 6C 65 78 00 ";
            S = S + "43 61 6E 27 74 20 43 4F 4E 54 49 4E 55 45 00 55 ";
            S = S + "6E 64 65 66 69 6E 65 64 20 75 73 65 72 20 66 75 ";
            S = S + "6E 63 74 69 6F 6E 00 44 65 76 69 63 65 20 49 2F ";
            S = S + "4F 20 65 72 72 6F 72 00 56 65 72 69 66 79 20 65 ";
            S = S + "72 72 6F 72 00 4E 6F 20 52 45 53 55 4D 45 00 52 ";
            S = S + "45 53 55 4D 45 20 77 69 74 68 6F 75 74 20 65 72 ";
            S = S + "72 6F 72 00 55 6E 70 72 69 6E 74 61 62 6C 65 20 ";
            S = S + "65 72 72 6F 72 00 4D 69 73 73 69 6E 67 20 6F 70 ";
            S = S + "65 72 61 6E 64 00 4C 69 6E 65 20 62 75 66 66 65 ";
            S = S + "72 20 6F 76 65 72 66 6C 6F 77 00 46 49 45 4C 44 ";
            S = S + "20 6F 76 65 72 66 6C 6F 77 00 49 6E 74 65 72 6E ";
            S = S + "61 6C 20 65 72 72 6F 72 00 42 61 64 20 66 69 6C ";
            S = S + "65 20 6E 75 6D 62 65 72 00 46 69 6C 65 20 6E 6F ";
            S = S + "74 20 66 6F 75 6E 64 00 46 69 6C 65 20 61 6C 72 ";
            S = S + "65 61 64 79 20 6F 70 65 6E 00 49 6E 70 75 74 20 ";
            S = S + "70 61 73 74 20 65 6E 64 00 42 61 64 20 66 69 6C ";
            S = S + "65 20 6E 61 6D 65 00 44 69 72 65 63 74 20 73 74 ";
            S = S + "61 74 65 6D 65 6E 74 20 69 6E 20 66 69 6C 65 00 ";
            S = S + "53 65 71 75 65 6E 74 69 61 6C 20 49 2F 4F 20 6F ";
            S = S + "6E 6C 79 00 46 69 6C 65 20 6E 6F 74 20 4F 50 45 ";
            S = S + "4E 00 20 69 6E 20 00 4F 6B 0D 0A 00 42 72 65 61 ";
            S = S + "6B 00 21 04 00 39 7E 23 FE 82 C0 4E 23 46 23 E5 ";
            S = S + "60 69 7A B3 EB 28 02 EB E7 01 16 00 E1 C8 09 18 ";

            return S;
        }

        public static string gs_Get_MSX1_BASIC()
        {
            string S;

            S = "";

          //== MSX1 BASIC [4000H~7FFFH,4000H,16384] ==
            S = S + "E5 CD 39 54 44 4D ED 78 C3 CF 4F CD 2F 54 D5 CF ";
            S = S + "2C CD 1C 52 C1 C9 CD 0B 40 ED 79 C9 CD 0B 40 C5 ";
            S = S + "F5 1E 00 2B D7 28 05 CF 2C CD 1C 52 F1 57 C1 CD ";
            S = S + "BD 00 ED 78 AB A2 28 F7 C9 CD F8 FE 2A 1C F4 7C ";
            S = S + "A5 3C 28 08 3A BB F6 B7 1E 15 20 23 C3 01 64 2A ";
            S = S + "A3 F6 22 1C F4 1E 02 01 1E 0B 01 1E 01 01 1E 0A ";
            S = S + "01 1E 12 01 1E 16 01 1E 06 01 1E 18 01 1E 0D CD ";
            S = S + "B1 FF AF 32 7C F8 2A 19 F4 7C B5 28 0A 3A 1B F4 ";
            S = S + "77 21 00 00 22 19 F4 FB 2A 1C F4 22 B3 F6 7C A5 ";
            S = S + "3C 28 03 22 B5 F6 01 A4 40 18 03 01 1E 41 2A B1 ";
            S = S + "F6 C3 F0 62 C1 7B 4B 32 14 F4 2A AF F6 22 B7 F6 ";
            S = S + "EB 2A B3 F6 7C A5 3C 28 07 22 BE F6 EB 22 C0 F6 ";
            S = S + "2A B9 F6 7C B5 EB 21 BB F6 28 08 A6 20 05 35 EB ";
            S = S + "C3 20 46 AF 77 59 CD 23 73 21 75 3D CD FD FE 7B ";
            S = S + "FE 3C 30 08 FE 32 30 06 FE 1A 38 05 3E 2F D6 18 ";
            S = S + "5F CD 5D 48 23 1D 20 F9 E5 2A B3 F6 E3 CD 02 FF ";
            S = S + "E5 CD D2 00 E1 7E FE 3F 20 06 E1 21 75 3D 18 DC ";
            S = S + "3E 07 DF CD 78 66 E1 7C A5 3C C4 0A 34 3E C1 CD ";
            S = S + "D2 00 CD 04 73 CD 7B 6D CD 07 FF CD 23 73 21 D7 ";
            S = S + "3F CD 78 66 CD 0C FF 21 FF FF 22 1C F4 21 0F F4 ";
            S = S + "22 AF F6 3A AA F6 B7 28 16 2A AB F6 E5 CD 12 34 ";
            S = S + "D1 D5 CD 95 42 3E 2A 38 02 3E 20 DF 32 AA F6 CD ";
            S = S + "4A 01 20 0C CD AE 00 30 0A AF 32 AA F6 C3 34 41 ";
            S = S + "CD 74 73 D7 3C 3D 28 BC F5 CD 69 47 30 06 CD 4A ";
            S = S + "01 CA 55 40 CD 14 45 3A AA F6 B7 28 08 FE 2A 20 ";
            S = S + "04 BE 20 01 23 7A B3 28 06 7E FE 20 20 01 23 D5 ";
            S = S + "CD B2 42 D1 F1 22 AF F6 CD 11 FF 38 07 AF 32 AA ";
            S = S + "F6 C3 48 6D D5 C5 D7 B7 F5 3A AA F6 A7 28 03 F1 ";
            S = S + "37 F5 ED 53 B5 F6 2A AD F6 19 38 0B D5 11 FA FF ";
            S = S + "E7 D1 22 AB F6 38 04 AF 32 AA F6 CD 95 42 38 0D ";
            S = S + "F1 F5 20 06 D2 1C 48 C5 18 4D B7 18 07 F1 F5 20 ";
            S = S + "02 38 F4 37 C5 F5 E5 CD EA 54 E1 F1 C1 C5 DC 05 ";
            S = S + "54 D1 F1 D5 28 31 D1 21 00 00 22 B9 F6 2A C2 F6 ";
            S = S + "E3 C1 E5 09 E5 CD 50 62 E1 22 C2 F6 EB 74 C1 D1 ";
            S = S + "E5 23 23 73 23 72 23 11 1F F4 0B 0B 0B 0B 1A 77 ";
            S = S + "23 13 0B 79 B0 20 F7 CD 16 FF D1 CD 57 42 2A 64 ";
            S = S + "F8 22 BC F6 CD 9A 62 CD 1B FF 2A BC F6 22 64 F8 ";
            S = S + "C3 34 41 2A 76 F6 EB 62 6B 7E 23 B6 C8 23 23 23 ";
            S = S + "7E B7 28 0E FE 20 30 F7 FE 0B 38 F3 CD 6A 46 D7 ";
            S = S + "18 EF 23 EB 73 23 72 18 DE 11 00 00 D5 28 09 D1 ";
            S = S + "CD 5F 47 D5 28 0B CF F2 11 FA FF C4 5F 47 C2 55 ";
            S = S + "40 EB D1 E3 E5 2A 76 F6 44 4D 7E 23 B6 2B C8 23 ";
            S = S + "23 7E 23 66 6F E7 60 69 7E 23 66 6F 3F C8 3F D0 ";
            S = S + "18 E6 AF 32 65 F6 32 64 F6 CD 20 FF 01 3B 01 11 ";
            S = S + "1F F4 7E B7 20 13 21 40 01 7D 91 4F 7C 98 47 21 ";
            S = S + "1E F4 AF 12 13 12 13 12 C9 FE 22 CA 16 43 FE 20 ";
            S = S + "28 07 3A 64 F6 B7 7E 28 3D 23 F5 FE 01 20 04 7E ";
            S = S + "A7 3E 01 C4 E0 44 F1 D6 3A 28 06 FE 4A 20 08 3E ";
            S = S + "01 32 64 F6 32 65 F6 D6 55 20 B7 F5 7E B7 E3 7C ";
            S = S + "E1 28 B3 BE 28 D3 F5 7E 23 FE 01 20 04 7E A7 3E ";
            S = S + "01 C4 E0 44 18 E6 23 B7 FA C2 42 FE 01 20 07 7E ";
            S = S + "A7 28 93 23 18 8C 2B FE 3F 3E 91 D5 C5 CA A3 43 ";
            S = S + "7E FE 5F CA A3 43 11 26 3D CD A9 4E CD A8 64 DA ";
            S = S + "1D 44 E5 CD 25 FF 21 3E 3A D6 41 87 4F 06 00 09 ";
            S = S + "5E 23 56 E1 23 E5 CD A9 4E 4F 1A E6 7F CA EB 44 ";
            S = S + "23 B9 20 24 1A 13 B7 F2 66 43 F1 1A CD 2A FF B7 ";
            S = S + "FA A2 43 C1 D1 F6 80 F5 3E FF CD E0 44 AF 32 65 ";
            S = S + "F6 F1 CD E0 44 C3 C2 42 E1 1A 13 B7 F2 99 43 13 ";
            S = S + "18 C3 2B F5 CD 2F FF 11 B5 43 4F 1A B7 28 15 13 ";
            S = S + "B9 20 F8 18 11 8C A9 AA A8 A7 E1 A1 8A 93 9E 89 ";
            S = S + "8E DA 8D 00 AF C2 3E 01 32 65 F6 F1 C1 D1 FE A1 ";
            S = S + "F5 CC DE 44 F1 FE CA 28 04 FE 5F 20 29 D4 E0 44 ";
            S = S + "23 CD A9 4E A7 CA C6 42 FA E0 43 FE 01 20 07 23 ";
            S = S + "7E A7 28 F1 18 EA FE 20 28 E3 FE 3A 28 3C FE 28 ";
            S = S + "28 38 FE 30 18 D7 FE E6 C2 B4 44 F5 CD DE 44 3E ";
            S = S + "8F CD E0 44 F1 E5 21 00 00 E3 C3 18 43 7E FE 2E ";
            S = S + "28 0A FE 3A D2 A2 44 FE 30 DA A2 44 3A 65 F6 B7 ";
            S = S + "7E C1 D1 FA E9 42 28 1F FE 2E CA E9 42 3E 0E CD ";
            S = S + "E0 44 D5 CD 69 47 CD 14 45 E3 EB 7D CD E0 44 7C ";
            S = S + "E1 CD E0 44 C3 C2 42 D5 C5 7E CD 99 32 CD 14 45 ";
            S = S + "C1 D1 E5 3A 63 F6 FE 02 20 15 2A F8 F7 7C B7 3E ";
            S = S + "02 20 0C 7D 65 2E 0F FE 0A 30 D0 C6 11 18 D1 F5 ";
            S = S + "0F C6 1B CD E0 44 21 F6 F7 3A 63 F6 FE 02 20 03 ";
            S = S + "21 F8 F7 F1 F5 7E CD E0 44 F1 23 3D 20 F6 E1 C3 ";
            S = S + "C2 42 11 25 3D 13 1A E6 7F CA FA 44 13 BE 1A 20 ";
            S = S + "F4 C3 09 45 FE 26 C2 E9 42 E5 D7 E1 CD AA 4E FE ";
            S = S + "48 28 0D FE 4F 28 05 3E 26 C3 E9 42 3E 0B 18 02 ";
            S = S + "3E 0C CD E0 44 D5 C5 CD B8 4E C1 C3 49 44 3E 3A ";
            S = S + "12 13 0B 79 B0 C0 1E 19 C3 6F 40 CD 34 FF E1 2B ";
            S = S + "3D 32 65 F6 CD A9 4E C3 CC 43 7E FE 20 30 0A FE ";
            S = S + "09 28 06 FE 0A 28 02 3E 20 F5 3A 65 F6 3C 28 01 ";
            S = S + "3D C3 C8 43 2B 7E FE 20 28 FA FE 09 28 F6 FE 0A ";
            S = S + "28 F2 23 C9 3E 64 32 A5 F6 CD 80 48 C1 E5 CD 5B ";
            S = S + "48 22 A1 F6 21 02 00 39 CD E6 3F 20 17 09 D5 2B ";
            S = S + "56 2B 5E 23 23 E5 2A A1 F6 E7 E1 D1 20 EA D1 F9 ";
            S = S + "22 B1 F6 0E D1 EB 0E 0C CD 5E 62 E5 2A A1 F6 E3 ";
            S = S + "E5 2A 1C F4 E3 CF D9 EF CA 6D 40 F5 CD 64 4C F1 ";
            S = S + "E5 30 18 F2 C2 45 CD 8A 2F E3 11 01 00 7E FE DC ";
            S = S + "CC 0E 52 D5 E5 EB CD AB 2E 18 5D CD 3A 30 D1 21 ";
            S = S + "F8 FF 39 F9 D5 CD 10 2F E1 7E FE DC 11 1B 2D 3E ";
            S = S + "01 20 0F D7 CD 64 4C E5 CD 3A 30 CD 71 2E 11 F6 ";
            S = S + "F7 E1 44 4D 21 F8 FF 39 F9 F5 C5 CD F3 2E E1 F1 ";
            S = S + "18 2D CD B2 2F CD CC 2E E1 C5 D5 01 41 10 11 00 ";
            S = S + "00 CD 39 FF 7E FE DC 3E 01 20 0E CD 65 4C E5 CD ";
            S = S + "B2 2F CD CC 2E CD 71 2E E1 D5 C5 C5 C5 C5 C5 B7 ";
            S = S + "20 02 3E 02 4F EF 47 C5 E5 2A A7 F6 E3 06 82 C5 ";
            S = S + "33 CD 3E FF ED 73 B1 F6 CD BA 00 3A D8 FB B7 C4 ";
            S = S + "89 63 FB 22 AF F6 7E FE 3A 28 25 B7 C2 55 40 23 ";
            S = S + "7E 23 B6 CA 39 40 23 5E 23 56 EB 22 1C F4 3A C4 ";
            S = S + "F7 B7 28 0B D5 3E 5B DF CD 12 34 3E 5D DF D1 EB ";
            S = S + "D7 11 01 46 D5 C8 CD 43 FF FE 5F CA A7 55 D6 81 ";
            S = S + "DA 80 48 FE 58 D2 AD 51 07 4F 06 00 EB 21 2E 39 ";
            S = S + "09 4E 23 46 C5 EB CD 48 FF 23 7E FE 3A D0 FE 20 ";
            S = S + "28 F4 30 6C B7 C8 FE 0B 38 61 FE 1E 20 05 3A 68 ";
            S = S + "F6 B7 C9 FE 10 28 34 F5 23 32 68 F6 D6 1C 30 30 ";
            S = S + "D6 F5 30 06 FE FE 20 16 7E 23 22 66 F6 26 00 6F ";
            S = S + "22 6A F6 3E 02 32 69 F6 21 E6 46 F1 B7 C9 7E 23 ";
            S = S + "23 22 66 F6 2B 66 18 E7 CD E8 46 2A 66 F6 18 AA ";
            S = S + "3C 07 32 69 F6 D5 C5 11 6A F6 EB 47 CD F7 2E EB ";
            S = S + "C1 D1 22 66 F6 F1 21 E6 46 B7 C9 FE 09 D2 66 46 ";
            S = S + "FE 30 3F 3C 3D C9 1E 10 3A 68 F6 FE 0F 30 13 FE ";
            S = S + "0D 38 0F 2A 6A F6 20 07 23 23 23 5E 23 56 EB C3 ";
            S = S + "36 32 3A 69 F6 32 63 F6 FE 02 20 06 2A 6A F6 22 ";
            S = S + "F8 F7 21 6A F6 C3 08 2F 1E 03 01 1E 02 01 1E 04 ";
            S = S + "01 1E 08 CD A7 64 01 55 40 C5 D8 D6 41 4F 47 D7 ";
            S = S + "FE F2 20 09 D7 CD A7 64 D8 D6 41 47 D7 78 91 D8 ";
            S = S + "3C E3 21 CA F6 06 00 09 73 23 3D 20 FB E1 7E FE ";
            S = S + "2C C0 D7 18 CE D7 CD 0F 52 F0 1E 05 C3 6F 40 7E ";
            S = S + "FE 2E ED 5B B5 F6 CA 66 46 2B D7 FE 0E 28 02 FE ";
            S = S + "0D ED 5B 6A F6 CA 66 46 AF 32 68 F6 11 00 00 2B ";
            S = S + "D7 D0 E5 F5 21 98 19 E7 38 11 62 6B 19 29 19 29 ";
            S = S + "F1 D6 30 5F 16 00 19 EB E1 18 E5 F1 E1 C9 CA 9A ";
            S = S + "62 FE 0E 28 05 FE 0D C2 5B 6B CD A1 62 01 01 46 ";
            S = S + "18 35 0E 03 CD 5E 62 CD 69 47 C1 E5 E5 2A 1C F4 ";
            S = S + "E3 01 00 00 C5 01 01 46 3E 8D F5 33 C5 18 1C E5 ";
            S = S + "E5 2A 1C F4 E3 C5 3E 8D F5 33 EB 2B 22 AF F6 23 ";
            S = S + "ED 73 B1 F6 C3 20 46 C5 CD 69 47 3A 68 F6 FE 0D ";
            S = S + "EB C8 FE 0E C2 55 40 EB E5 2A 66 F6 E3 CD 5D 48 ";
            S = S + "23 E5 2A 1C F4 E7 E1 DC 98 42 D4 95 42 30 0D 0B ";
            S = S + "3E 0D 32 A9 F6 E1 CD 83 55 60 69 C9 1E 08 C3 6F ";
            S = S + "40 CD 4D FF 22 A7 F6 16 FF CD E2 3F FE 8D 28 01 ";
            S = S + "2B F9 22 B1 F6 1E 03 C2 6F 40 E1 7C B5 28 06 7E ";
            S = S + "E6 01 C4 3E 63 C1 21 01 46 E3 EB 2A A7 F6 2B D7 ";
            S = S + "C2 E8 47 60 69 22 1C F4 EB 3E E1 01 3A 0E 00 06 ";
            S = S + "00 79 48 47 2B D7 B7 C8 B8 C8 23 FE 22 28 F2 3C ";
            S = S + "28 F3 D6 8C 20 EE B8 8A 57 18 E9 F1 C6 03 18 12 ";
            S = S + "CD A4 5E CF EF ED 53 A7 F6 D5 3A 63 F6 F5 CD 64 ";
            S = S + "4C F1 E3 47 3A 63 F6 B8 78 28 06 CD 7A 51 3A 63 ";
            S = S + "F6 11 F6 F7 FE 02 20 03 11 F8 F7 E5 FE 03 20 2E ";
            S = S + "2A F8 F7 E5 23 5E 23 56 21 1E F4 E7 38 14 2A C6 ";
            S = S + "F6 E7 D1 30 15 21 97 F6 E7 38 06 21 79 F6 E7 38 ";
            S = S + "09 3E D1 CD EE 67 EB CD 11 66 CD EE 67 E3 CD F3 ";
            S = S + "2E D1 E1 C9 FE A6 20 25 D7 CF 89 CD 69 47 7A B3 ";
            S = S + "28 09 CD 93 42 50 59 E1 D2 1C 48 ED 53 B9 F6 D8 ";
            S = S + "3A BB F6 B7 7B C8 3A 14 F4 5F C3 96 40 CD 10 78 ";
            S = S + "38 31 C5 D7 CF 8D AF C1 C5 B9 D2 55 40 F5 CD 69 ";
            S = S + "47 7A B3 28 09 CD 93 42 50 59 E1 D2 1C 48 F1 C1 ";
            S = S + "F5 80 C5 CD 5C 78 2B D7 C1 D1 C8 C5 D5 CF 2C F1 ";
            S = S + "3C 18 D4 CD 1C 52 7E 47 FE 8D 28 03 CF 89 2B 4B ";
            S = S + "0D 78 CA 46 46 CD 6A 47 FE 2C C0 18 F3 3A BB F6 ";
            S = S + "B7 20 09 32 B9 F6 32 BA F6 C3 64 40 3C 32 14 F4 ";
            S = S + "7E FE 83 28 10 CD 69 47 C0 7A B3 28 0C CD EB 47 ";
            S = S + "AF 32 BB F6 C9 D7 C0 18 05 AF 32 BB F6 3C 2A B7 ";
            S = S + "F6 EB 2A B3 F6 22 1C F4 EB C0 7E B7 20 04 23 23 ";
            S = S + "23 23 23 AF 32 BB F6 C3 5B 48 CD 1C 52 C0 B7 CA ";
            S = S + "5A 47 C3 6F 40 11 0A 00 D5 28 16 CD 5F 47 EB E3 ";
            S = S + "28 10 EB CF 2C ED 5B AD F6 28 06 CD 69 47 C2 55 ";
            S = S + "40 EB 7C B5 CA 5A 47 22 AD F6 32 AA F6 E1 22 AB ";
            S = S + "F6 C1 C3 34 41 CD 64 4C 7E FE 2C CC 66 46 FE 89 ";
            S = S + "28 03 CF DA 2B E5 CD A1 2E E1 28 10 D7 C8 FE 0E ";
            S = S + "CA E8 47 FE 0D C2 46 46 2A 6A F6 C9 16 01 CD 5B ";
            S = S + "48 B7 C8 D7 FE A1 20 F6 15 20 F3 18 DF 3E 01 32 ";
            S = S + "16 F4 18 05 0E 02 CD 57 6D 2B D7 CC 28 73 CA FF ";
            S = S + "4A FE E4 CA B1 60 FE DB CA C6 4A FE DF CA C6 4A ";
            S = S + "E5 FE 2C 28 4F FE 3B CA FA 4A C1 CD 64 4C E5 EF ";
            S = S + "28 3B CD 25 34 CD 35 66 36 20 2A F8 F7 34 CD 52 ";
            S = S + "FF CD 4A 01 20 23 2A F8 F7 3A 16 F4 B7 28 08 3A ";
            S = S + "15 F4 86 FE FF 18 0A 3A B0 F3 47 3A 61 F6 86 3D ";
            S = S + "B8 38 06 CC 31 73 C4 28 73 CD 7B 66 B7 CC 7B 66 ";
            S = S + "E1 C3 29 4A CD 57 FF 01 08 00 2A 64 F8 09 CD 4A ";
            S = S + "01 7E 20 1B 3A 16 F4 B7 28 07 3A 15 F4 FE EE 18 ";
            S = S + "08 3A B2 F3 47 3A 61 F6 B8 D4 28 73 D2 FA 4A D6 ";
            S = S + "0E 30 FC 2F 18 2D F5 CD 1B 52 CF 29 2B F1 D6 DF ";
            S = S + "E5 28 1C 01 08 00 2A 64 F8 09 CD 4A 01 7E 20 0F ";
            S = S + "3A 16 F4 B7 CA EC 4A 3A 15 F4 18 03 3A 61 F6 2F ";
            S = S + "83 30 07 3C 47 3E 20 DF 10 FD E1 D7 C3 2E 4A CD ";
            S = S + "5C FF AF 32 16 F4 E5 67 6F 22 64 F8 E1 C9 FE 85 ";
            S = S + "C2 A7 58 CF 85 FE 23 CA 8F 6D CD 7B 4B CD A4 5E ";
            S = S + "CD 58 30 D5 E5 CD B1 00 D1 C1 DA FE 63 C5 D5 06 ";
            S = S + "00 CD 38 66 E1 3E 03 C3 92 48 3F 52 65 64 6F 20 ";
            S = S + "66 72 6F 6D 20 73 74 61 72 74 0D 0A 00 CD 61 FF ";
            S = S + "3A A6 F6 B7 C2 4F 40 C1 21 3A 4B CD 78 66 2A AF ";
            S = S + "F6 C9 CD 55 6D E5 21 5D F5 C3 9B 4B FE 23 28 F2 ";
            S = S + "E5 F5 CD D2 00 F1 E1 01 8B 4B C5 FE 22 3E 00 C0 ";
            S = S + "CD 36 66 CF 3B E5 CD 7B 66 E1 C9 E5 CD B4 00 C1 ";
            S = S + "DA FE 63 23 7E B7 2B C5 CA 5A 48 36 2C 18 05 E5 ";
            S = S + "2A C8 F6 F6 AF 32 A6 F6 E3 01 CF 2C CD A4 5E E3 ";
            S = S + "D5 7E FE 2C 28 1B 3A A6 F6 B7 C2 40 4C 3E 3F DF ";
            S = S + "CD B4 00 D1 C1 DA FE 63 23 7E 2B B7 C5 CA 5A 48 ";
            S = S + "D5 CD 4A 01 C2 83 6D EF F5 20 22 D7 57 47 FE 22 ";
            S = S + "28 0C 3A A6 F6 B7 57 28 02 16 3A 06 2C 2B CD 39 ";
            S = S + "66 F1 C6 03 EB 21 05 4C E3 D5 C3 93 48 D7 01 F1 ";
            S = S + "4B C5 C3 99 32 2B D7 28 05 FE 2C C2 4D 4B E3 2B ";
            S = S + "D7 C2 AA 4B D1 3A A6 F6 B7 EB C2 DE 63 D5 CD 4A ";
            S = S + "01 20 08 7E B7 21 2F 4C C4 78 66 E1 C3 FF 4A 3F ";
            S = S + "45 78 74 72 61 20 69 67 6E 6F 72 65 64 0D 0A 00 ";
            S = S + "CD 5B 48 B7 20 11 23 7E 23 B6 1E 04 CA 6F 40 23 ";
            S = S + "5E 23 56 ED 53 A3 F6 D7 FE 84 20 E4 C3 D1 4B CF ";
            S = S + "EF 01 CF 28 2B 16 00 D5 0E 01 CD 5E 62 CD 66 FF ";
            S = S + "CD C7 4D 22 BC F6 2A BC F6 C1 7E 22 9D F6 FE EE ";
            S = S + "D8 FE F1 38 5F D6 F1 5F 20 09 3A 63 F6 FE 03 7B ";
            S = S + "CA 87 67 FE 0C D0 21 3B 3D 16 00 19 78 56 BA D0 ";
            S = S + "C5 01 76 4C C5 7A CD 6B FF FE 51 38 50 E6 FE FE ";
            S = S + "7A 28 4A 21 F8 F7 3A 63 F6 D6 03 CA 6D 40 B7 2A ";
            S = S + "F8 F7 E5 FA D5 4C 2A F6 F7 E5 E2 D5 4C 2A FC F7 ";
            S = S + "E5 2A FA F7 E5 C6 03 4B 47 C5 01 22 4D C5 2A 9D ";
            S = S + "F6 C3 67 4C 16 00 D6 EE 38 1E FE 03 30 1A FE 01 ";
            S = S + "17 AA BA 57 DA 55 40 22 9D F6 D7 18 E9 D5 CD 8A ";
            S = S + "2F D1 E5 01 78 4F 18 D5 78 FE 64 D0 C5 D5 11 05 ";
            S = S + "64 21 57 4F E5 EF C2 B3 4C 2A F8 F7 E5 01 C8 65 ";
            S = S + "18 BB C1 79 32 64 F6 3A 63 F6 B8 20 0B FE 02 28 ";
            S = S + "1F FE 04 CA 9D 4D 30 2B 57 78 FE 08 28 22 7A FE ";
            S = S + "08 28 44 78 FE 04 28 52 7A FE 03 CA 6D 40 30 54 ";
            S = S + "21 69 3D 06 00 09 09 4E 23 46 D1 2A F8 F7 C5 C9 ";
            S = S + "CD 3A 30 CD 0D 2F E1 22 FA F7 E1 22 FC F7 C1 D1 ";
            S = S + "CD C1 2E CD 3A 30 21 51 3D 3A 64 F6 07 85 6F 8C ";
            S = S + "95 67 7E 23 66 6F E9 78 F5 CD 0D 2F F1 32 63 F6 ";
            S = S + "FE 04 28 DA E1 22 F8 F7 18 D9 CD B2 2F C1 D1 21 ";
            S = S + "5D 3D 18 D5 E1 CD B1 2E CD CB 2F CD CC 2E E1 22 ";
            S = S + "F6 F7 E1 22 F8 F7 18 E7 E5 EB CD CB 2F E1 CD B1 ";
            S = S + "2E CD CB 2F C3 65 32 D7 CA 6A 40 DA 99 32 CD A8 ";
            S = S + "64 D2 9B 4E FE 20 DA B8 46 CD 70 FF 3C CA FC 4E ";
            S = S + "3D FE F1 28 E2 FE F2 CA 8D 4E FE 22 CA 36 66 FE ";
            S = S + "E0 CA 63 4F FE 26 CA B8 4E FE E2 20 0A D7 3A 14 ";
            S = S + "F4 E5 CD CF 4F E1 C9 FE E1 20 0A D7 E5 2A B3 F6 ";
            S = S + "CD 36 32 E1 C9 FE ED CA 03 58 FE CB CA 00 79 FE ";
            S = S + "C7 CA 84 7A FE C8 CA 47 7B FE C9 CA CB 7B FE C1 ";
            S = S + "CA 1B 79 FE EA CA 3E 7C FE E9 CA 43 7C FE E7 20 ";
            S = S + "23 D7 CF 28 FE 23 20 0B CD 1B 52 E5 CD 6D 6A EB ";
            S = S + "E1 18 03 CD 5D 5F CF 29 E5 EB 7C B5 CA 5A 47 CD ";
            S = S + "99 2F E1 C9 FE DD CA D5 4F FE E5 CA EB 68 FE EC ";
            S = S + "CA 47 73 FE E3 CA 29 68 FE 85 CA 87 6C FE E8 CA ";
            S = S + "0A 79 FE DE CA 40 50 CD 62 4C CF 29 C9 16 7D CD ";
            S = S + "67 4C 2A BC F6 E5 CD 86 2E E1 C9 CD A4 5E E5 EB ";
            S = S + "22 F8 F7 EF C4 08 2F E1 C9 7E FE 61 D8 FE 7B D0 ";
            S = S + "E6 5F C9 FE 26 C2 69 47 11 00 00 D7 CD AA 4E 01 ";
            S = S + "02 01 FE 42 28 0F 01 08 03 FE 4F 28 08 01 10 04 ";
            S = S + "FE 48 C2 55 40 23 7E EB CD AA 4E FE 3A 38 06 FE ";
            S = S + "41 38 14 D6 07 D6 30 B9 30 0D C5 29 DA 67 40 10 ";
            S = S + "FA C1 B5 6F EB 18 DE CD 99 2F EB C9 23 7E D6 81 ";
            S = S + "06 00 07 4F C5 D7 79 FE 05 30 16 CD 62 4C CF 2C ";
            S = S + "CD 58 30 EB 2A F8 F7 E3 E5 EB CD 1C 52 EB E3 18 ";
            S = S + "1A CD 87 4E E3 7D FE 0C 38 0D FE 1B CD 75 FF 30 ";
            S = S + "06 EF E5 DC 3A 30 E1 11 99 4E D5 01 DE 39 CD 7A ";
            S = S + "FF 09 4E 23 66 69 E9 15 FE F2 C8 FE 2D C8 14 FE ";
            S = S + "2B C8 FE F1 C8 2B C9 3C 8F C1 A0 C6 FF 9F CD 9A ";
            S = S + "2E 18 12 16 5A CD 67 4C CD 8A 2F 7D 2F 6F 7C 2F ";
            S = S + "67 22 F8 F7 C1 C3 76 4C 78 F5 CD 8A 2F F1 D1 FE ";
            S = S + "7A CA 3A 32 FE 7B CA E6 31 01 D1 4F C5 FE 46 20 ";
            S = S + "06 7B B5 6F 7C B2 C9 FE 50 20 06 7B A5 6F 7C A2 ";
            S = S + "C9 FE 3C 20 06 7B AD 6F 7C AA C9 FE 32 20 08 7B ";
            S = S + "AD 2F 6F 7C AA 2F C9 7D 2F A3 2F 6F 7C 2F A2 2F ";
            S = S + "C9 B7 ED 52 C3 36 32 3A 15 F4 18 03 3A 61 F6 6F ";
            S = S + "AF 67 C3 99 2F CD F4 4F D5 CD 87 4E E3 5E 23 56 ";
            S = S + "21 97 32 E5 D5 3A 63 F6 F5 FE 03 CC D3 67 F1 EB ";
            S = S + "21 F6 F7 C9 D7 01 00 00 FE 1B 30 0B FE 11 38 07 ";
            S = S + "D7 3A 6A F6 B7 17 4F EB 21 9A F3 09 EB C9 CD F4 ";
            S = S + "4F D5 CF EF CD 2F 54 E3 73 23 72 E1 C9 FE DD 28 ";
            S = S + "ED CD A1 51 CD 93 51 EB 73 23 72 EB 7E FE 28 C2 ";
            S = S + "5B 48 D7 CD A4 5E 7E FE 29 CA 5B 48 CF 2C 18 F3 ";
            S = S + "CD A1 51 3A 63 F6 B7 F5 22 BC F6 EB 7E 23 66 6F ";
            S = S + "7C B5 CA 61 40 7E FE 28 C2 F4 50 D7 22 9D F6 EB ";
            S = S + "2A BC F6 CF 28 AF F5 E5 EB 3E 80 32 A5 F6 CD A4 ";
            S = S + "5E EB E3 3A 63 F6 F5 D5 CD 64 4C 22 BC F6 E1 22 ";
            S = S + "9D F6 F1 CD 7A 51 0E 04 CD 5E 62 21 F8 FF 39 F9 ";
            S = S + "CD 10 2F 3A 63 F6 F5 2A BC F6 7E FE 29 28 0E CF ";
            S = S + "2C E5 2A 9D F6 CF 2C 18 C0 F1 32 4E F7 F1 B7 28 ";
            S = S + "38 32 63 F6 21 00 00 39 CD 08 2F 21 08 00 39 F9 ";
            S = S + "D1 2E 03 1B 1B 1B 3A 63 F6 85 47 3A 4E F7 4F 80 ";
            S = S + "FE 64 D2 5A 47 F5 7D 06 00 21 50 F7 09 4F CD 8E ";
            S = S + "51 01 A9 50 C5 C5 C3 9E 48 2A BC F6 D7 E5 2A 9D ";
            S = S + "F6 CF 29 3E D5 22 9D F6 3A E6 F6 C6 04 F5 0F 4F ";
            S = S + "CD 5E 62 F1 4F 2F 3C 6F 26 FF 39 F9 E5 11 E4 F6 ";
            S = S + "CD 8E 51 E1 22 E4 F6 2A 4E F7 22 E6 F6 44 4D 21 ";
            S = S + "E8 F6 11 50 F7 CD 8E 51 67 6F 22 4E F7 2A BA F7 ";
            S = S + "23 22 BA F7 7C B5 32 B7 F7 2A 9D F6 CD 5F 4C 2B ";
            S = S + "D7 C2 55 40 EF 20 0F 11 98 F6 2A F8 F7 E7 38 06 ";
            S = S + "CD 11 66 CD 58 66 2A E4 F6 54 5D 23 23 4E 23 46 ";
            S = S + "03 03 03 03 21 E4 F6 CD 8E 51 EB F9 2A BA F7 2B ";
            S = S + "22 BA F7 7C B5 32 B7 F7 E1 F1 E5 E6 07 21 47 3D ";
            S = S + "4F 06 00 09 CD 41 4F E1 C9 1A 77 23 13 0B 78 B1 ";
            S = S + "20 F7 C9 E5 2A 1C F4 23 7C B5 E1 C0 1E 0C C3 6F ";
            S = S + "40 CF DE 3E 80 32 A5 F6 B6 4F C3 A9 5E FE 7E 20 ";
            S = S + "15 23 7E 23 FE 83 CA 6E 69 FE A3 CA BF 77 FE 85 ";
            S = S + "CA B1 77 CD 7F FF C3 55 40 CD 1C 52 CD 84 FF A7 ";
            S = S + "28 0D 3A B0 FC A7 7B 28 04 FE 21 30 02 FE 29 D2 ";
            S = S + "5A 47 3A B0 F3 BB C8 3E 0C DF 7B 32 B0 F3 3A B0 ";
            S = S + "FC 3D 7B 20 05 32 AF F3 18 03 32 AE F3 3E 0C DF ";
            S = S + "7B D6 0E 30 FC C6 1C 2F 3C 83 32 B2 F3 C9 D7 CD ";
            S = S + "64 4C E5 CD 8A 2F EB E1 7A B7 C9 D7 CD 64 4C CD ";
            S = S + "12 52 C2 5A 47 2B D7 7B C9 3E 01 32 16 F4 CD 89 ";
            S = S + "FF C1 CD 79 42 C5 21 FF FF 22 1C F4 E1 D1 4E 23 ";
            S = S + "46 23 78 B1 CA 1F 41 CD 4A 01 CC BA 00 C5 4E 23 ";
            S = S + "46 23 C5 E3 EB E7 C1 DA 1E 41 E3 E5 C5 EB 22 B5 ";
            S = S + "F6 CD 12 34 E1 7E FE 09 28 03 3E 20 DF CD 84 52 ";
            S = S + "21 5E F5 CD 7B 52 CD 28 73 18 BB 7E B7 C8 CD 67 ";
            S = S + "73 23 18 F7 01 5E F5 16 FF AF 32 64 F6 18 04 03 ";
            S = S + "23 15 C8 7E B7 02 C8 FE 0B 38 25 FE 20 DA 61 53 ";
            S = S + "FE 22 20 0A 3A 64 F6 EE 01 32 64 F6 3E 22 FE 3A ";
            S = S + "20 0E 3A 64 F6 1F 38 06 17 E6 FD 32 64 F6 3E 3A ";
            S = S + "B7 F2 8F 52 3A 64 F6 1F 38 2E 1F 1F 30 3E 7E FE ";
            S = S + "E6 E5 C5 21 F5 52 E5 C0 0B 0A FE 4D C0 0B 0A FE ";
            S = S + "45 C0 0B 0A FE 52 C0 0B 0A FE 3A C0 F1 F1 E1 14 ";
            S = S + "14 14 14 18 25 C1 E1 7E C3 8F 52 3A 64 F6 F6 02 ";
            S = S + "32 64 F6 AF C9 3A 64 F6 F6 04 18 F4 17 38 E9 7E ";
            S = S + "FE 84 CC FB 52 FE 8F CC 05 53 7E 3C 7E 20 04 23 ";
            S = S + "7E E6 7F 23 FE A1 20 02 0B 14 E5 C5 D5 CD 8E FF ";
            S = S + "21 71 3A 47 0E 40 0C 23 54 5D 7E B7 28 F8 23 F2 ";
            S = S + "3A 53 7E B8 20 F1 EB 79 D1 C1 FE 5B 20 02 7E 23 ";
            S = S + "5F E6 7F 02 03 15 CA A7 66 B3 F2 4E 53 E1 C3 93 ";
            S = S + "52 2B D7 D5 C5 F5 CD E8 46 F1 01 7E 53 C5 FE 0B ";
            S = S + "CA 1E 37 FE 0C CA 22 37 2A 6A F6 C3 25 34 C1 D1 ";
            S = S + "3A 68 F6 1E 4F FE 0B 28 06 FE 0C 1E 48 20 0B 3E ";
            S = S + "26 02 03 15 C8 7B 02 03 15 C8 3A 69 F6 FE 04 1E ";
            S = S + "00 38 06 1E 21 28 02 1E 23 7E FE 20 20 01 23 7E ";
            S = S + "23 B7 28 20 02 03 15 C8 3A 69 F6 FE 04 38 F0 0B ";
            S = S + "0A 03 20 04 FE 2E 28 08 FE 44 28 04 FE 45 20 DF ";
            S = S + "1E 00 18 DB 7B B7 28 04 02 03 15 C8 2A 66 F6 C3 ";
            S = S + "93 52 CD 79 42 C5 CD EA 54 C1 D1 C5 C5 CD 95 42 ";
            S = S + "30 05 54 5D E3 E5 E7 D2 5A 47 21 D7 3F CD 78 66 ";
            S = S + "C1 21 37 42 E3 EB 2A C2 F6 1A 02 03 13 E7 20 F9 ";
            S = S + "60 69 22 C2 F6 22 C4 F6 22 C6 F6 C9 CD 39 54 7E ";
            S = S + "C3 CF 4F CD 2F 54 D5 CF 2C CD 1C 52 D1 12 C9 CD ";
            S = S + "64 4C E5 CD 39 54 EB E1 C9 01 8A 2F C5 EF F8 CD ";
            S = S + "93 FF CD 71 2E F8 CD B2 2F 01 45 32 11 76 80 CD ";
            S = S + "21 2F D8 01 45 65 11 53 60 CD 21 2F D2 67 40 01 ";
            S = S + "C5 65 11 53 60 C3 4E 32 01 0A 00 C5 50 58 28 26 ";
            S = S + "FE 2C 28 09 D5 CD 5F 47 42 4B D1 28 19 CF 2C CD ";
            S = S + "5F 47 28 12 F1 CF 2C D5 CD 69 47 C2 55 40 7A B3 ";
            S = S + "CA 5A 47 EB E3 EB C5 CD 95 42 D1 D5 C5 CD 95 42 ";
            S = S + "60 69 D1 E7 EB DA 5A 47 D1 C1 F1 E5 D5 18 0E 09 ";
            S = S + "DA 5A 47 EB E5 21 F9 FF E7 E1 DA 5A 47 D5 5E 23 ";
            S = S + "56 7A B3 EB D1 28 07 7E 23 B6 2B EB 20 E1 C5 CD ";
            S = S + "F6 54 C1 D1 E1 D5 5E 23 56 7A B3 28 14 EB E3 EB ";
            S = S + "23 73 23 72 EB 09 EB E1 18 EB 3A A9 F6 B7 C8 18 ";
            S = S + "06 01 1E 41 C5 FE F6 AF 32 A9 F6 2A 76 F6 2B 23 ";
            S = S + "7E 23 B6 C8 23 5E 23 56 D7 B7 28 F3 4F 3A A9 F6 ";
            S = S + "B7 79 28 56 CD 98 FF FE A6 20 14 D7 FE 89 20 E9 ";
            S = S + "D7 FE 0E 20 E4 D5 CD 71 47 7A B3 20 0A 18 27 FE ";
            S = S + "0E 20 D5 D5 CD 71 47 E5 CD 95 42 0B 3E 0D 38 3C ";
            S = S + "CD 23 73 21 5A 55 D5 CD 78 66 E1 CD 12 34 C1 E1 ";
            S = S + "E5 C5 CD 0A 34 E1 D1 2B 18 AE 55 6E 64 65 66 69 ";
            S = S + "6E 65 64 20 6C 69 6E 65 20 00 FE 0D 20 EA D5 CD ";
            S = S + "71 47 E5 EB 23 23 23 4E 23 46 3E 0E 21 55 55 E5 ";
            S = S + "2A 66 F6 E5 2B 70 2B 71 2B 77 E1 C9 7E E3 BE 23 ";
            S = S + "E3 C2 55 40 C3 66 46 3A 63 F6 FE 08 30 05 D6 03 ";
            S = S + "B7 37 C9 D6 03 B7 C9 D7 11 89 FD 06 0F 7E A7 28 ";
            S = S + "0D FE 3A 28 09 FE 28 28 05 12 13 23 10 EF 78 FE ";
            S = S + "0F 28 15 AF 12 1B 1A FE 20 28 F8 06 40 11 C9 FC ";
            S = S + "1A E6 20 20 06 13 10 F8 C3 55 40 C5 D5 E5 CD 2A ";
            S = S + "7E F5 4F 2E 04 CD 1A 7E D5 DD E1 FD E1 E1 2B D7 ";
            S = S + "CD 1C 00 D1 C1 38 DE C9 E1 78 FE 10 38 02 06 0F ";
            S = S + "CD B7 7F CD A9 4E 12 23 13 10 F8 AF 12 06 40 11 ";
            S = S + "C9 FC 1A E6 40 20 06 13 10 F8 C3 6B 6E C5 D5 CD ";
            S = S + "2A 7E F5 4F 2E 06 CD 1A 7E D5 DD E1 FD E1 3E FF ";
            S = S + "CD 1C 00 D1 C1 38 E0 4F 3E 40 90 87 87 B1 FE 09 ";
            S = S + "38 D8 FE FC 30 D4 E1 D1 A7 C9 C5 F5 1F 1F E6 3F ";
            S = S + "CD 2D 7E F5 4F 2E 06 CD 1A 7E D5 DD E1 FD E1 F1 ";
            S = S + "E6 03 32 99 FD C1 F1 D1 E1 C3 1C 00 ED 53 56 F9 ";
            S = S + "CD 64 4C E5 11 00 00 D5 F5 CD D0 67 CD DF 2E 41 ";
            S = S + "4A 53 78 B1 28 06 7A B7 28 02 C5 D5 F1 32 3B FB ";
            S = S + "E1 7C B5 20 0A 3A 58 F9 B7 CA 09 57 C3 94 74 22 ";
            S = S + "3C FB CD EE 56 28 E5 87 4F 2A 56 F9 7E 87 CC 5A ";
            S = S + "47 B9 28 05 23 23 23 18 F3 01 A2 56 C5 7E 4F 87 ";
            S = S + "30 20 B7 1F 4F C5 E5 CD EE 56 11 01 00 CA DF 56 ";
            S = S + "CD A8 64 D2 DC 56 CD 1C 57 37 18 04 CD 0B 57 B7 ";
            S = S + "E1 C1 23 7E 23 66 6F E9 CD EE 56 28 C1 C9 E5 21 ";
            S = S + "3B FB 7E B7 28 13 35 2A 3C FB 7E 23 22 3C FB FE ";
            S = S + "20 28 EC FE 60 38 02 D6 20 E1 C9 E5 21 3B FB 34 ";
            S = S + "2A 3C FB 2B 22 3C FB E1 C9 CD E8 56 FE 3D CA 7A ";
            S = S + "57 FE 2B 28 F4 FE 2D 20 06 11 95 57 D5 18 EA 11 ";
            S = S + "00 00 FE 2C 28 D5 FE 3B C8 FE 3A 30 CE FE 30 38 ";
            S = S + "CA 21 00 00 06 0A 19 38 2A 10 FB D6 30 5F 16 00 ";
            S = S + "19 38 20 EB CD EE 56 20 D9 C9 CD E8 56 11 5E F5 ";
            S = S + "D5 06 28 CD A8 64 38 0B 12 13 FE 3B 28 08 CD E8 ";
            S = S + "56 10 F5 CD 5A 47 E1 C3 9B 4E CD 5A 57 CD 8A 2F ";
            S = S + "EB C9 CD 5A 57 3A 3B FB 2A 3C FB E3 F5 0E 02 CD ";
            S = S + "5E 62 C3 79 56 AF 93 5F 9A 93 57 C9 7E FE 40 CC ";
            S = S + "66 46 01 00 00 50 59 FE F2 28 16 7E FE DC F5 CC ";
            S = S + "66 46 CF 28 CD 0F 52 D5 CF 2C CD 0F 52 CF 29 C1 ";
            S = S + "F1 E5 2A B7 FC 28 03 21 00 00 09 22 B7 FC 22 B3 ";
            S = S + "FC 44 4D 2A B9 FC 28 03 21 00 00 19 22 B9 FC 22 ";
            S = S + "B5 FC EB E1 C9 3A EA F3 18 03 3A E9 F3 F5 CD AB ";
            S = S + "57 F1 CD 50 58 E5 CD 0E 01 30 06 CD 11 01 CD 20 ";
            S = S + "01 E1 C9 D7 E5 CD 14 01 D1 E5 F5 2A B5 FC E5 2A ";
            S = S + "B3 FC E5 2A B9 FC E5 2A B7 FC E5 EB CD AB 57 E5 ";
            S = S + "CD 0E 01 21 FF FF 30 09 CD 11 01 CD 1D 01 6F 26 ";
            S = S + "00 CD 99 2F D1 E1 22 B7 FC E1 22 B9 FC E1 22 B3 ";
            S = S + "FC E1 22 B5 FC F1 E1 D5 CD 17 01 E1 C9 3A E9 F3 ";
            S = S + "C5 D5 5F CD BC 59 2B D7 28 09 CF 2C FE 2C 28 03 ";
            S = S + "CD 1C 52 7B E5 CD 1A 01 DA 5A 47 E1 D1 C1 C3 6A ";
            S = S + "46 2A B3 FC 7D 91 6F 7C 98 67 D0 AF 95 6F 9C 95 ";
            S = S + "67 37 C9 2A B5 FC 7D 93 6F 7C 9A 67 18 EC E5 2A ";
            S = S + "B5 FC EB 22 B5 FC E1 C9 CD 8E 58 E5 C5 2A B3 FC ";
            S = S + "E3 22 B3 FC C1 E1 C9 CD 9C 57 C5 D5 CF F2 CD AB ";
            S = S + "57 CD 4D 58 D1 C1 28 44 CF 2C CF 42 CA 12 59 CF ";
            S = S + "46 E5 CD 0E 01 CD 98 58 CD 0E 01 CD 83 58 DC 8E ";
            S = S + "58 23 E5 CD 71 58 DC 9B 58 23 E5 CD 11 01 D1 C1 ";
            S = S + "D5 C5 CD 14 01 F5 E5 EB CD 23 01 E1 F1 CD 17 01 ";
            S = S + "CD 08 01 C1 D1 0B 78 B1 20 E6 E1 C9 C5 D5 E5 CD ";
            S = S + "3C 59 2A B7 FC 22 B3 FC 2A B9 FC 22 B5 FC E1 D1 ";
            S = S + "C1 C9 E5 2A B5 FC E5 D5 EB CD FC 58 E1 22 B5 FC ";
            S = S + "EB CD FC 58 E1 22 B5 FC 2A B3 FC C5 44 4D CD FC ";
            S = S + "58 E1 22 B3 FC 44 4D CD FC 58 E1 C9 CD F3 FE CD ";
            S = S + "0E 01 CD 98 58 CD 0E 01 CD 83 58 DC 98 58 D5 E5 ";
            S = S + "CD 71 58 EB 21 FC 00 30 03 21 FF 00 E3 E7 30 10 ";
            S = S + "22 2D F9 E1 22 ED F3 21 08 01 22 F0 F3 EB 18 0F ";
            S = S + "E3 22 F0 F3 21 08 01 22 ED F3 EB 22 2D F9 E1 D1 ";
            S = S + "E5 CD 7B 58 22 2F F9 CD 11 01 D1 D5 CD B4 59 C1 ";
            S = S + "03 18 07 E1 78 B1 C8 CD EC F3 CD 20 01 0B E5 2A ";
            S = S + "2D F9 19 EB 2A 2F F9 19 30 E9 EB E1 78 B1 C8 CD ";
            S = S + "EF F3 18 E3 7A B7 1F 57 7B 1F 5F C9 3A AF FC FE ";
            S = S + "02 F0 C3 5A 47 CD 9C 57 C5 D5 CD 4D 58 3A F2 F3 ";
            S = S + "5F 2B D7 28 05 CF 2C CD 1C 52 7B CD 29 01 DA 5A ";
            S = S + "47 D1 C1 E5 CD 91 5E CD 11 01 11 01 00 06 00 CD ";
            S = S + "DC 5A 28 14 E5 CD ED 5A D1 19 EB AF CD CE 5A 3E ";
            S = S + "40 CD CE 5A 06 C0 18 1E E1 C9 CD BD 00 3A 4A F9 ";
            S = S + "B7 28 0C 2A 4B F9 E5 2A 49 F9 E5 2A 4D F9 E5 D1 ";
            S = S + "C1 E1 79 CD 17 01 78 32 53 F9 87 28 DB D5 30 05 ";
            S = S + "CD 05 01 18 03 CD 0B 01 D1 38 E4 06 00 CD DC 5A ";
            S = S + "CA 1F 5A AF 32 4A F9 CD ED 5A 5D 54 B7 28 1A 2B ";
            S = S + "2B 7C 87 38 14 ED 53 4D F9 CD 14 01 22 4B F9 32 ";
            S = S + "49 F9 3A 53 F9 2F 32 4A F9 2A 51 F9 19 EB CD C2 ";
            S = S + "5A 2A 42 F9 3A 44 F9 CD 17 01 2A 4F F9 ED 5B 51 ";
            S = S + "F9 B7 ED 52 28 39 38 1C EB 06 01 CD DC 5A 28 2F ";
            S = S + "B7 28 E7 EB 2A 42 F9 3A 44 F9 4F 3A 53 F9 47 CD ";
            S = S + "D3 5A 18 D6 CD 7B 58 2B 2B 7C 87 38 12 23 E5 CD ";
            S = S + "FF 00 2B 7C B5 20 F8 D1 3A 53 F9 2F CD CE 5A C3 ";
            S = S + "0A 5A 3A 54 F9 4F 3A 55 F9 B1 C8 3A 53 F9 47 CD ";
            S = S + "14 01 4F E3 C5 D5 E5 0E 02 C3 5E 62 CD 2C 01 ED ";
            S = S + "53 4F F9 22 51 F9 7C B5 79 32 55 F9 C9 CD 14 01 ";
            S = S + "E5 F5 2A 42 F9 3A 44 F9 CD 17 01 F1 E1 22 42 F9 ";
            S = S + "32 44 F9 CD 2F 01 79 32 54 F9 C9 EB CD 7B 58 EB ";
            S = S + "C9 CD 9C 57 CF 2C CD 0F 52 E5 EB 22 B3 FC CD 99 ";
            S = S + "2F CD B2 2F 01 40 70 11 71 07 CD 5C 32 CD 8A 2F ";
            S = S + "22 36 F9 AF 32 35 F9 32 41 F9 E1 CD 4D 58 0E 01 ";
            S = S + "11 00 00 CD 17 5D D5 0E 80 11 FF FF CD 17 5D E3 ";
            S = S + "AF EB E7 3E 00 30 0F 3D EB F5 3A 35 F9 4F 07 07 ";
            S = S + "B1 0F 32 35 F9 F1 32 38 F9 ED 53 3F F9 22 33 F9 ";
            S = S + "E1 2B D7 20 10 E5 CD 26 01 7C B7 28 32 3E 01 32 ";
            S = S + "41 F9 EB 18 2A CF 2C CD 64 4C E5 CD B2 2F CD 71 ";
            S = S + "2E CA 5A 47 FA 5A 47 CD 63 5D 20 07 3C 32 41 F9 ";
            S = S + "CD 67 32 01 43 25 11 60 00 CD 5C 32 CD 8A 2F 22 ";
            S = S + "31 F9 11 00 00 ED 53 3D F9 2A B3 FC 29 CD BD 00 ";
            S = S + "7B 1F 38 16 D5 E5 23 EB CD B4 59 EB 13 CD B4 59 ";
            S = S + "CD 06 5C D1 E1 E7 D2 08 5A EB 44 4D 2A 3D F9 23 ";
            S = S + "19 19 7C 87 38 0C D5 EB 60 69 29 2B EB B7 ED 52 ";
            S = S + "0B D1 22 3D F9 60 69 13 18 C3 D5 CD EB 5C E1 3A ";
            S = S + "41 F9 B7 C8 EB C9 ED 53 39 F9 E5 21 00 00 22 3B ";
            S = S + "F9 CD FA 5B 22 45 F9 E1 EB E5 CD FA 5B ED 53 47 ";
            S = S + "F9 D1 CD 0B 5B CD 48 5C E5 D5 2A 36 F9 22 3B F9 ";
            S = S + "ED 5B 39 F9 B7 ED 52 22 39 F9 2A 45 F9 CD 7B 58 ";
            S = S + "22 45 F9 D1 E1 CD 0B 5B 3E 04 F5 E5 D5 E5 D5 ED ";
            S = S + "5B 3B F9 2A 36 F9 29 19 22 3B F9 2A 39 F9 19 EB ";
            S = S + "2A 3F F9 E7 28 1A 30 08 2A 33 F9 E7 28 0A 30 20 ";
            S = S + "3A 38 F9 B7 20 24 18 1E 3A 35 F9 87 30 1C 18 06 ";
            S = S + "3A 35 F9 1F 30 14 D1 E1 CD DC 5C CD CD 5C 18 1A ";
            S = S + "3A 38 F9 B7 28 04 D1 E1 18 10 D1 E1 CD DC 5C CD ";
            S = S + "0E 01 30 06 CD 11 01 CD 20 01 D1 E1 F1 3D C8 F5 ";
            S = S + "D5 ED 5B 45 F9 CD 0B 5B 22 45 F9 EB D1 E5 2A 47 ";
            S = S + "F9 EB 22 47 F9 CD 0B 5B E1 F1 C3 4A 5C 2A B7 FC ";
            S = S + "22 B3 FC 2A B9 FC 22 B5 FC C3 3C 59 D5 ED 5B B7 ";
            S = S + "FC 19 44 4D D1 2A B9 FC 19 EB C9 2A 31 F9 7D B7 ";
            S = S + "20 04 B4 C0 EB C9 4A 16 00 F5 CD 0A 5D 1E 80 19 ";
            S = S + "59 4C F1 CD 0A 5D 59 19 EB C9 06 08 21 00 00 29 ";
            S = S + "87 30 01 19 10 F9 C9 2B D7 C8 CF 2C FE 2C C8 C5 ";
            S = S + "CD 64 4C E3 E5 CD B2 2F C1 21 F6 F7 7E B7 F2 3A ";
            S = S + "5D E6 7F 77 21 35 F9 7E B1 77 01 40 15 11 91 55 ";
            S = S + "CD 5C 32 CD 63 5D CA 5A 47 CD B1 2E 2A 36 F9 29 ";
            S = S + "29 29 CD 99 2F CD B2 2F C1 D1 CD 5C 32 CD 8A 2F ";
            S = S + "D1 EB C9 01 41 10 11 00 00 CD 21 2F 3D C9 3A AF ";
            S = S + "FC FE 02 DA 5A 47 11 83 5D AF 32 BB FC 32 58 F9 ";
            S = S + "C3 6C 56 D5 B1 5D C4 B4 5D CC B9 5D D2 BC 5D 4D ";
            S = S + "D8 5D C5 CA 5D C6 C6 5D C7 D1 5D C8 C3 5D C1 4E ";
            S = S + "5E 42 46 5E 4E 42 5E 58 82 57 C3 87 5E D3 59 5E ";
            S = S + "00 CD 0B 5B 01 00 00 18 46 CD 0B 5B 42 4B 11 00 ";
            S = S + "00 18 3C CD 0B 5B 42 4B 18 35 42 4B CD 0B 5B 18 ";
            S = S + "2E CD 0B 5B 42 4B 18 F4 CD E8 56 06 00 FE 2B 28 ";
            S = S + "05 FE 2D 28 01 04 78 F5 CD 0B 57 CD 19 57 D5 CD ";
            S = S + "E8 56 FE 2C C2 5A 47 CD 19 57 C1 F1 B7 20 23 CD ";
            S = S + "66 5E D5 50 59 CD 66 5E EB D1 3A BD FC 1F 30 06 ";
            S = S + "F5 CD 7B 58 EB F1 1F 30 06 CD 7B 58 CD 0B 5B CD ";
            S = S + "DC 5C 3A BB FC 87 38 09 F5 C5 D5 CD CD 5C D1 C1 ";
            S = S + "F1 87 38 09 ED 53 B9 FC 60 69 22 B7 FC AF 32 BB ";
            S = S + "FC C9 3E 40 18 02 3E 80 21 BB FC B6 77 C9 30 09 ";
            S = S + "7B FE 04 30 04 32 BD FC C9 D2 5A 47 7A B7 C2 5A ";
            S = S + "47 7B 32 BC FC C9 3A BC FC B7 C8 21 00 00 19 3D ";
            S = S + "20 FC EB 7A 87 F5 30 01 1B CD B4 59 CD B4 59 F1 ";
            S = S + "D0 7A F6 C0 57 13 C9 30 D0 7B CD 1A 01 DA 5A 47 ";
            S = S + "C9 E5 CD 0E 01 D2 5A 47 E1 C9 2B D7 C8 CF 2C 01 ";
            S = S + "9A 5E C5 F6 AF 32 62 F6 4E CD A2 FF CD A7 64 DA ";
            S = S + "55 40 AF 47 D7 38 05 CD A8 64 38 09 47 D7 38 FD ";
            S = S + "CD A8 64 30 F8 FE 26 30 17 11 EE 5E D5 16 02 FE ";
            S = S + "25 C8 14 FE 24 C8 14 FE 21 C8 16 08 FE 23 C8 F1 ";
            S = S + "79 E6 7F 5F 16 00 E5 21 89 F6 19 56 E1 2B 7A 32 ";
            S = S + "63 F6 D7 3A A5 F6 3D CA E8 5F F2 08 5F 7E D6 28 ";
            S = S + "CA BA 5F D6 33 CA BA 5F AF 32 A5 F6 E5 3A B7 F7 ";
            S = S + "B7 32 B4 F7 28 3C 2A E6 F6 11 E8 F6 19 22 B5 F7 ";
            S = S + "EB 18 17 1A 6F 13 1A 13 B9 20 0B 3A 63 F6 BD 20 ";
            S = S + "05 1A B8 CA A4 5F 13 26 00 19 EB 3A B5 F7 BB C2 ";
            S = S + "23 5F 3A B6 F7 BA 20 DB 3A B4 F7 B7 28 18 AF 32 ";
            S = S + "B4 F7 2A C4 F6 22 B5 F7 2A C2 F6 18 DD CD A4 5E ";
            S = S + "C9 57 5F C1 E3 C9 E1 E3 D5 11 60 5F E7 28 F2 11 ";
            S = S + "9E 4E E7 D1 28 31 E3 E5 C5 3A 63 F6 4F C5 06 00 ";
            S = S + "03 03 03 2A C6 F6 E5 09 C1 E5 CD 50 62 E1 22 C6 ";
            S = S + "F6 60 69 22 C4 F6 2B 36 00 E7 20 FA D1 73 23 D1 ";
            S = S + "73 23 72 EB 13 E1 C9 32 F6 F7 67 6F 22 F8 F7 EF ";
            S = S + "20 06 21 D6 3F 22 F8 F7 E1 C9 E5 2A 62 F6 E3 57 ";
            S = S + "D5 C5 CD 55 47 C1 F1 EB E3 E5 EB 3C 57 7E FE 2C ";
            S = S + "CA C0 5F FE 29 28 05 FE 5D C2 55 40 D7 22 BC F6 ";
            S = S + "E1 22 62 F6 1E 00 D5 11 E5 F5 2A C4 F6 3E 19 ED ";
            S = S + "5B C6 F6 E7 28 2D 5E 23 7E 23 B9 20 08 3A 63 F6 ";
            S = S + "BB 20 02 7E B8 23 5E 23 56 23 20 E2 3A 62 F6 B7 ";
            S = S + "C2 5E 40 F1 44 4D CA 97 32 96 CA 7D 60 11 09 00 ";
            S = S + "C3 6F 40 3A 63 F6 77 23 5F 16 00 F1 CA 5A 47 71 ";
            S = S + "23 70 23 4F CD 5E 62 23 23 22 9D F6 71 23 3A 62 ";
            S = S + "F6 17 79 01 0B 00 30 02 C1 03 71 F5 23 70 23 CD ";
            S = S + "4A 31 F1 3D 20 ED F5 42 4B EB 19 DA 75 62 CD 67 ";
            S = S + "62 22 C6 F6 2B 36 00 E7 20 FA 03 57 2A 9D F6 5E ";
            S = S + "EB 29 09 EB 2B 2B 73 23 72 23 F1 38 30 47 4F 7E ";
            S = S + "23 16 E1 5E 23 56 23 E3 F5 E7 D2 1D 60 CD 4A 31 ";
            S = S + "19 F1 3D 44 4D 20 EB 3A 63 F6 44 4D 29 D6 04 38 ";
            S = S + "04 29 28 06 29 B7 E2 AA 60 09 C1 09 EB 2A BC F6 ";
            S = S + "C9 CD 65 4C CD 58 30 CF 3B EB 2A F8 F7 18 08 3A ";
            S = S + "A6 F6 B7 28 0D D1 EB E5 AF 32 A6 F6 3C F5 D5 46 ";
            S = S + "04 05 CA 5A 47 23 7E 23 66 6F 18 1A 58 E5 0E 02 ";
            S = S + "7E 23 FE 5C CA 10 62 FE 20 20 03 0C 10 F2 E1 43 ";
            S = S + "3E 5C CD 46 62 DF AF 5F 57 CD 46 62 57 7E 23 FE ";
            S = S + "21 CA 0D 62 FE 23 28 3C FE 26 CA 09 62 05 CA F5 ";
            S = S + "61 FE 2B 3E 08 28 E2 2B 7E 23 FE 2E 28 40 FE 5C ";
            S = S + "28 BA BE 20 CD FE 24 28 14 FE 2A 20 C5 23 78 FE ";
            S = S + "02 38 03 7E FE 24 3E 20 20 07 05 1C FE AF C6 10 ";
            S = S + "23 1C 82 57 1C 0E 00 05 28 48 7E 23 FE 2E 28 19 ";
            S = S + "FE 23 28 F0 FE 2C 20 1B 7A F6 40 57 18 E6 7E FE ";
            S = S + "23 3E 2E C2 F2 60 0E 01 23 0C 05 28 25 7E 23 FE ";
            S = S + "23 28 F6 D5 11 90 61 D5 54 5D FE 5E C0 BE C0 23 ";
            S = S + "BE C0 23 BE C0 23 78 D6 04 D8 D1 D1 47 14 23 CA ";
            S = S + "EB D1 7A 2B 1C E6 08 20 15 1D 78 B7 28 10 7E D6 ";
            S = S + "2D 28 06 FE FE 20 07 3E 08 C6 04 82 57 05 E1 F1 ";
            S = S + "28 4C C5 D5 CD 64 4C D1 C1 C5 E5 43 78 81 FE 19 ";
            S = S + "D2 5A 47 7A F6 80 CD 26 34 CD 78 66 E1 2B D7 37 ";
            S = S + "28 0B 32 A6 F6 FE 3B 28 03 CF 2C 06 D7 C1 EB E1 ";
            S = S + "E5 F5 D5 7E 90 23 16 00 5F 7E 23 66 6F 19 78 B7 ";
            S = S + "C2 F6 60 18 04 CD 46 62 DF E1 F1 C2 BF 60 DC 28 ";
            S = S + "73 E3 CD D6 67 E1 C3 FF 4A 0E 00 18 04 0E 01 3E ";
            S = S + "F1 05 CD 46 62 E1 F1 28 E5 C5 CD 64 4C CD 58 30 ";
            S = S + "C1 C5 E5 2A F8 F7 41 0E 00 78 F5 B7 C4 68 68 CD ";
            S = S + "7B 66 2A F8 F7 F1 B7 CA CC 61 96 47 3E 20 04 05 ";
            S = S + "CA CC 61 DF 18 F9 F5 7A B7 3E 2B C4 18 00 F1 C9 ";
            S = S + "CD 67 62 C5 E3 C1 E7 7E 02 C8 0B 2B 18 F8 E5 2A ";
            S = S + "C6 F6 06 00 09 09 3E E5 3E 88 95 6F 3E FF 9C 67 ";
            S = S + "38 03 39 E1 D8 CD 53 42 2A 74 F6 2B 2B 22 B1 F6 ";
            S = S + "11 07 00 C3 6F 40 C0 2A 76 F6 CD 39 64 32 AA F6 ";
            S = S + "32 A9 F6 77 23 77 23 22 C2 F6 CD CB FE 2A 76 F6 ";
            S = S + "2B CD D0 FE 22 A7 F6 CD 6E 63 06 1A 21 CA F6 CD ";
            S = S + "D5 FE 36 08 23 10 FB CD 24 2C AF 32 BB F6 6F 67 ";
            S = S + "22 B9 F6 22 C0 F6 2A 72 F6 22 9B F6 CD C9 63 2A ";
            S = S + "C2 F6 22 C4 F6 22 C6 F6 CD 1C 6C 3A 7C F8 E6 01 ";
            S = S + "20 03 32 7C F8 C1 2A 74 F6 2B 2B 22 B1 F6 23 23 ";
            S = S + "CD DA FE F9 21 7A F6 22 78 F6 CD 04 73 CD FF 4A ";
            S = S + "AF 67 6F 22 E6 F6 32 B7 F7 22 4E F7 22 BA F7 22 ";
            S = S + "E4 F6 32 A5 F6 E5 C5 2A A7 F6 C9 F3 7E E6 04 F6 ";
            S = S + "01 BE 77 28 04 E6 04 20 26 FB C9 F3 7E 36 00 18 ";
            S = S + "07 F3 7E F5 F6 02 77 F1 EE 05 28 26 FB C9 F3 7E ";
            S = S + "E6 05 BE 77 20 02 FB C9 EE 05 28 03 FB C9 F3 3A ";
            S = S + "D8 FB 3C 32 D8 FB FB C9 F3 7E E6 03 BE 77 20 02 ";
            S = S + "FB C9 3A D8 FB D6 01 38 F7 32 D8 FB FB C9 21 4C ";
            S = S + "FC 06 1A AF 77 23 77 23 77 23 10 F8 21 CE FB 06 ";
            S = S + "0A 77 23 10 FC 32 D8 FB C9 3A BB F6 B7 C0 E5 2A ";
            S = S + "1C F4 7C A5 3C 28 0F 21 4C FC 06 1A 7E FE 05 28 ";
            S = S + "07 23 23 23 10 F6 E1 C9 C5 23 5E 23 56 2B 2B 7A ";
            S = S + "B3 C1 28 ED D5 E5 CD 58 63 CD 31 63 0E 03 CD 5E ";
            S = S + "62 C1 D1 E1 E3 E1 C3 CF 47 EB 2A 76 F6 28 0E EB ";
            S = S + "CD 69 47 E5 CD 95 42 60 69 D1 D2 1C 48 2B 22 C8 ";
            S = S + "F6 EB C9 C2 A5 77 C0 3C 18 0A C0 AF 32 BB F6 F5 ";
            S = S + "CC 1C 6C F1 22 AF F6 21 7A F6 22 78 F6 21 F6 FF ";
            S = S + "C1 2A 1C F4 E5 F5 7D A4 3C 28 09 22 BE F6 2A AF ";
            S = S + "F6 22 C0 F6 CD 04 73 CD 23 73 F1 21 DC 3F C2 FD ";
            S = S + "40 C3 1E 41 2A C0 F6 7C B5 11 11 00 CA 6F 40 ED ";
            S = S + "5B BE F6 ED 53 1C F4 C9 3E AF 32 C4 F7 C9 CD A4 ";
            S = S + "5E D5 E5 21 BC F7 CD F3 2E 2A C4 F6 E3 EF F5 CF ";
            S = S + "2C CD A4 5E F1 47 EF B8 C2 6D 40 E3 EB E5 2A C4 ";
            S = S + "F6 E7 20 10 D1 E1 E3 D5 CD F3 2E E1 11 BC F7 CD ";
            S = S + "F3 2E E1 C9 C3 5A 47 3E 01 32 A5 F6 CD A4 5E E5 ";
            S = S + "32 A5 F6 60 69 0B 0B 0B 0B 0B 19 EB 2A C6 F6 E7 ";
            S = S + "1A 02 13 03 20 F9 0B 60 69 22 C6 F6 E1 7E FE 2C ";
            S = S + "C0 D7 18 D3 F1 E1 C9 7E FE 41 D8 FE 5B 3F C9 CA ";
            S = S + "A1 62 CD 56 47 2B D7 E5 2A 4A FC 44 4D 2A 72 F6 ";
            S = S + "28 2A E1 CF 2C D5 CD 2F 54 2B D7 C2 55 40 E3 EB ";
            S = S + "7C A7 F2 5A 47 D5 11 81 F3 E7 D2 5A 47 D1 E5 01 ";
            S = S + "F5 FE 3A 5F F8 09 3D F2 E5 64 C1 2B 7D 93 5F 7C ";
            S = S + "9A 57 DA 75 62 E5 2A C2 F6 C5 01 A0 00 09 C1 E7 ";
            S = S + "D2 75 62 EB 22 74 F6 60 69 22 4A FC E1 22 72 F6 ";
            S = S + "E1 CD A1 62 3A 5F F8 CD 6B 7E 2A A7 F6 C3 01 46 ";
            S = S + "7D 93 5F 7C 9A 57 C9 11 00 00 C4 A4 5E 22 A7 F6 ";
            S = S + "CD E2 3F C2 5B 40 F9 D5 7E F5 23 D5 7E 23 B7 FA ";
            S = S + "6B 65 3D 20 04 01 08 00 09 C6 04 32 63 F6 CD 08 ";
            S = S + "2F EB E3 E5 EF 30 4E CD D6 2E CD 4E 32 E1 CD E8 ";
            S = S + "2E E1 CD DF 2E E5 CD 21 2F 18 29 01 0C 00 09 4E ";
            S = S + "23 46 23 E3 5E 23 56 E5 69 60 CD 72 31 3A 63 F6 ";
            S = S + "FE 02 C2 67 40 EB E1 72 2B 73 E1 D5 5E 23 56 23 ";
            S = S + "E3 CD 4D 2F E1 C1 90 CD DF 2E 28 1A EB 22 1C F4 ";
            S = S + "69 60 C3 FD 45 CD 97 26 E1 CD 10 2F E1 CD EF 2E ";
            S = S + "D5 CD 5C 2F 18 DE F9 22 B1 F6 EB 2A A7 F6 7E FE ";
            S = S + "2C C2 01 46 D7 CD 2A 65 CD D0 67 7E 23 4E 23 46 ";
            S = S + "D1 C5 F5 CD D7 67 F1 57 5E 23 4E 23 46 E1 7B B2 ";
            S = S + "C8 7A D6 01 D8 AF BB 3C D0 15 1D 0A 03 BE 23 28 ";
            S = S + "ED 3F C3 79 2E CD 1E 37 18 0D CD 22 37 18 08 CD ";
            S = S + "1A 37 18 03 CD 25 34 CD 35 66 CD D3 67 01 25 68 ";
            S = S + "C5 7E 23 E5 CD 8E 66 E1 4E 23 46 CD 2A 66 E5 6F ";
            S = S + "CD C7 67 D1 C9 3E 01 CD 8E 66 21 98 F6 E5 77 23 ";
            S = S + "73 23 72 E1 C9 2B 06 22 50 E5 0E FF 23 7E 0C B7 ";
            S = S + "28 06 BA 28 03 B8 20 F4 FE 22 CC 66 46 E3 23 EB ";
            S = S + "79 CD 2A 66 11 98 F6 3E D5 2A 78 F6 22 F8 F7 3E ";
            S = S + "03 32 63 F6 CD F3 2E 11 9B F6 E7 22 78 F6 E1 7E ";
            S = S + "C0 11 10 00 C3 6F 40 23 CD 35 66 CD D3 67 CD E1 ";
            S = S + "2E 14 15 C8 0A DF FE 0D CC 31 73 03 18 F4 B7 0E ";
            S = S + "F1 F5 2A 74 F6 EB 2A 9B F6 2F 4F 06 FF 09 23 E7 ";
            S = S + "38 07 22 9B F6 23 EB F1 C9 F1 11 0E 00 CA 6F 40 ";
            S = S + "BF F5 01 90 66 C5 2A 72 F6 22 9B F6 21 00 00 E5 ";
            S = S + "2A C6 F6 E5 21 7A F6 ED 5B 78 F6 E7 01 C7 66 C2 ";
            S = S + "42 67 21 4C F7 22 B8 F7 2A C4 F6 22 B5 F7 2A C2 ";
            S = S + "F6 ED 5B B5 F7 E7 28 12 7E 23 23 23 FE 03 20 04 ";
            S = S + "CD 43 67 AF 5F 16 00 19 18 E7 2A B8 F7 5E 23 56 ";
            S = S + "7A B3 2A C4 F6 28 13 EB 22 B8 F7 23 23 5E 23 56 ";
            S = S + "23 EB 19 22 B5 F7 EB 18 C8 C1 ED 5B C6 F6 E7 CA ";
            S = S + "63 67 7E 23 CD DF 2E E5 09 FE 03 20 EC 22 9F F6 ";
            S = S + "E1 4E 06 00 09 09 23 EB 2A 9F F6 EB E7 28 DB 01 ";
            S = S + "37 67 C5 AF B6 23 5E 23 56 23 C8 44 4D 2A 9B F6 ";
            S = S + "E7 60 69 D8 E1 E3 E7 E3 E5 60 69 D0 C1 F1 F1 E5 ";
            S = S + "D5 C5 C9 D1 E1 7C B5 C8 2B 46 2B 4E E5 2B 6E 26 ";
            S = S + "00 09 50 59 2B 44 4D 2A 9B F6 CD 53 62 E1 71 23 ";
            S = S + "70 60 69 2B C3 B9 66 C5 E5 2A F8 F7 E3 CD C7 4D ";
            S = S + "E3 CD 58 30 7E E5 2A F8 F7 E5 86 11 0F 00 DA 6F ";
            S = S + "40 CD 27 66 D1 CD D7 67 E3 CD D6 67 E5 2A 99 F6 ";
            S = S + "EB CD BF 67 CD BF 67 21 73 4C E3 E5 C3 54 66 E1 ";
            S = S + "E3 7E 23 4E 23 46 6F 2C 2D C8 0A 12 03 13 18 F8 ";
            S = S + "CD 58 30 2A F8 F7 EB CD EE 67 EB C0 D5 50 59 1B ";
            S = S + "4E 2A 9B F6 E7 20 05 47 09 22 9B F6 E1 C9 CD 9D ";
            S = S + "FF 2A 78 F6 2B 46 2B 4E 2B E7 C0 22 78 F6 C9 01 ";
            S = S + "CF 4F C5 CD D0 67 AF 57 7E B7 C9 01 CF 4F C5 CD ";
            S = S + "03 68 CA 5A 47 23 5E 23 56 1A C9 CD 25 66 CD 1F ";
            S = S + "52 2A 99 F6 73 C1 C3 54 66 D7 CF 28 CD 1C 52 D5 ";
            S = S + "CF 2C CD 64 4C CF 29 E3 E5 EF 28 05 CD 1F 52 18 ";
            S = S + "03 CD 0F 68 D1 CD 4D 68 CD 1F 52 3E 20 F5 7B CD ";
            S = S + "27 66 47 F1 04 05 28 CD 2A 99 F6 77 23 10 FC 18 ";
            S = S + "C4 CD E3 68 AF E3 4F 3E E5 E5 7E B8 38 02 78 11 ";
            S = S + "0E 00 C5 CD 8E 66 C1 E1 E5 23 46 23 66 68 06 00 ";
            S = S + "09 44 4D CD 2A 66 6F CD C7 67 D1 CD D7 67 C3 54 ";
            S = S + "66 CD E3 68 D1 D5 1A 90 18 CB EB 7E CD E6 68 04 ";
            S = S + "05 CA 5A 47 C5 CD E4 69 F1 E3 01 69 68 C5 3D BE ";
            S = S + "06 00 D0 4F 7E 91 BB 47 D8 43 C9 CD 03 68 CA CF ";
            S = S + "4F 5F 23 7E 23 66 6F E5 19 46 22 19 F4 78 32 1B ";
            S = S + "F4 72 E3 C5 2B D7 CD 99 32 21 00 00 22 19 F4 C1 ";
            S = S + "E1 70 C9 EB CF 29 C1 D1 C5 43 C9 D7 CD 62 4C EF ";
            S = S + "3E 01 F5 28 11 F1 CD 1F 52 B7 CA 5A 47 F5 CF 2C ";
            S = S + "CD 64 4C CD 58 30 CF 2C E5 2A F8 F7 E3 CD 64 4C ";
            S = S + "CF 29 E5 CD D0 67 EB C1 E1 F1 C5 01 97 32 C5 01 ";
            S = S + "CF 4F C5 F5 D5 CD D6 67 D1 F1 47 3D 4F BE 3E 00 ";
            S = S + "D0 1A B7 78 C8 7E 23 46 23 66 68 06 00 09 91 47 ";
            S = S + "C5 D5 E3 4E 23 5E 23 56 E1 E5 D5 C5 1A BE 20 16 ";
            S = S + "13 0D 28 09 23 10 F5 D1 D1 C1 D1 AF C9 E1 D1 D1 ";
            S = S + "C1 78 94 81 3C C9 C1 D1 E1 23 10 DD 18 EC CF 28 ";
            S = S + "CD A4 5E CD 58 30 E5 D5 EB 23 5E 23 56 2A C6 F6 ";
            S = S + "E7 38 10 2A 76 F6 E7 30 0A E1 E5 CD 11 66 E1 E5 ";
            S = S + "CD F3 2E E1 E3 CF 2C CD 1C 52 B7 CA 5A 47 F5 7E ";
            S = S + "CD E4 69 D5 CD 5F 4C E5 CD D0 67 EB E1 C1 F1 47 ";
            S = S + "E3 E5 21 97 32 E3 79 B7 C8 7E 90 DA 5A 47 3C B9 ";
            S = S + "38 01 79 48 0D 06 00 D5 23 5E 23 66 6B 09 47 D1 ";
            S = S + "EB 4E 23 7E 23 66 6F EB 79 B7 C8 1A 77 13 23 0D ";
            S = S + "C8 10 F8 C9 1E FF FE 29 28 05 CF 2C CD 1C 52 CF ";
            S = S + "29 C9 2A C6 F6 EB 21 00 00 39 EF C2 C1 4F CD D3 ";
            S = S + "67 CD B6 66 ED 5B 74 F6 2A 9B F6 C3 C1 4F CD 64 ";
            S = S + "4C E5 CD D0 67 7E B7 28 2E 23 5E 23 66 6B 5F CD ";
            S = S + "15 6F F5 01 66 F8 16 0B 1C 1D 28 35 7E FE 20 38 ";
            S = S + "16 FE 2E 28 18 02 03 23 15 20 EE F1 F5 57 3A 66 ";
            S = S + "F8 3C 28 03 F1 E1 C9 C3 6B 6E 23 18 DC 7A FE 0B ";
            S = S + "CA 47 6A FE 03 DA 47 6A 28 F0 3E 20 02 03 15 18 ";
            S = S + "EC 3E 20 02 03 15 20 F9 18 D1 CD 1F 52 6F 3A 5F ";
            S = S + "F8 BD DA 7D 6E 26 00 29 EB 2A 60 F8 19 7E 23 66 ";
            S = S + "6F 3A 7C F8 3C C8 7E B7 C8 E5 11 04 00 19 7E FE ";
            S = S + "09 30 06 CD 4E FE C3 80 6E E1 7E B7 37 C9 2B D7 ";
            S = S + "FE 23 CC 66 46 CD 1C 52 E3 E5 CD 6D 6A CA 77 6E ";
            S = S + "22 64 F8 CD 53 FE C9 01 FF 4A C5 CD 0E 6A 7E FE ";
            S = S + "82 1E 04 20 1F D7 FE 85 1E 01 28 17 FE 9C 28 0C ";
            S = S + "CF 41 CF 50 CF 50 CF 81 1E 08 18 08 D7 CF B3 1E ";
            S = S + "02 18 01 D7 CF 41 CF 53 D5 7E FE 23 CC 66 46 CD ";
            S = S + "1C 52 B7 CA 7D 6E CD 58 FE 1E D5 2B 5F D7 C2 55 ";
            S = S + "40 E3 7B F5 E5 CD 6D 6A C2 6E 6E D1 7A FE 09 CD ";
            S = S + "5D FE DA 80 6E E5 01 04 00 09 72 3E 00 E1 CD 8F ";
            S = S + "6F F1 E1 C9 E5 B7 20 08 3A 7C F8 E6 01 C2 F3 6C ";
            S = S + "CD 6D 6A 28 15 22 64 F8 E5 38 06 CD 62 FE C3 80 ";
            S = S + "6E 3E 02 CD 8F 6F CD EA 6C E1 E5 11 07 00 19 77 ";
            S = S + "67 6F 22 64 F8 E1 86 36 00 E1 C9 37 11 F6 AF F5 ";
            S = S + "CD 0E 6A CD 67 FE F1 F5 28 0C 7E D6 2C B7 20 06 ";
            S = S + "D7 CF 52 F1 37 F5 F5 AF 1E 01 CD FA 6A 2A 64 F8 ";
            S = S + "01 07 00 09 F1 9F E6 80 F6 01 32 7C F8 F1 F5 9F ";
            S = S + "32 66 F8 7E B7 FA D4 6B F1 C4 87 62 AF CD AA 6A ";
            S = S + "C3 34 41 CD 0E 6A CD 6C FE 2B D7 1E 80 37 28 07 ";
            S = S + "CF 2C CF 41 B7 1E 02 F5 7A FE 09 38 05 1E 02 F1 ";
            S = S + "AF F5 AF CD FA 6A F1 38 05 2B D7 C3 2E 52 CD 71 ";
            S = S + "FE C3 6B 6E CD 76 FE C3 6B 6E E5 D5 2A 64 F8 11 ";
            S = S + "04 00 19 7E D1 E1 C9 20 19 E5 C5 F5 11 F3 6B D5 ";
            S = S + "C5 B7 C9 F1 C1 3D F2 EA 6B E1 C9 C1 E1 7E FE 2C ";
            S = S + "C0 D7 C5 7E FE 23 CC 66 46 CD 1C 52 E3 E5 11 FB ";
            S = S + "6B D5 37 E9 01 24 6B 3A 5F F8 18 CB 3A 7C F8 B7 ";
            S = S + "F8 01 24 6B AF 3A 5F F8 18 BD 3E 01 32 16 F4 CD ";
            S = S + "7B FE C3 5A 47 F5 CD 9E 6A 38 06 CD 80 FE C3 6B ";
            S = S + "6E D1 C1 3E 04 C3 8F 6F E5 D5 C5 F5 CD 62 6C 30 ";
            S = S + "06 CD 85 FE C3 6B 6E F1 F5 4F 3E 06 CD 8F 6F C3 ";
            S = S + "FF 72 D5 2A 64 F8 EB 21 04 00 19 7E EB D1 FE 09 ";
            S = S + "C9 E5 D5 C5 CD 62 6C 30 06 CD 8A FE C3 80 6E 3E ";
            S = S + "08 CD 8F 6F C3 00 73 D7 CF 24 CF 28 E5 2A 64 F8 ";
            S = S + "E5 21 00 00 22 64 F8 E1 E3 CD 1C 52 D5 7E FE 2C ";
            S = S + "20 11 D7 CD 9E 6A FE 01 CA B0 6C FE 04 C2 83 6E ";
            S = S + "E1 AF 7E F5 CF 29 F1 E3 F5 7D B7 CA 5A 47 E5 CD ";
            S = S + "27 66 EB C1 F1 F5 28 1A CD 9F 00 F5 CD BD 00 F1 ";
            S = S + "77 23 0D 20 EF F1 C1 E1 CD 8F FE 22 64 F8 C5 C3 ";
            S = S + "54 66 CD 71 6C DA 83 6E 18 E6 CD FB 6C E5 06 00 ";
            S = S + "CD F5 6C E1 C9 AF 77 23 10 FC C9 2A 64 F8 11 09 ";
            S = S + "00 19 C9 CD 94 FE CD 6A 6A 28 20 3E 0A 38 21 CD ";
            S = S + "99 FE 18 22 CD 94 FE CD 6A 6A 28 0F 3E 0C 38 10 ";
            S = S + "CD 9E FE 18 11 CD 94 FE CD 6A 6A CA 77 6E 3E 0E ";
            S = S + "DA 8F 6F CD A3 FE C3 80 6E CD 94 FE CD 6A 6A 3E ";
            S = S + "10 38 ED CD A8 FE 18 EE CD 4A 01 CA 40 46 AF CD ";
            S = S + "24 6B C3 71 6E 0E 01 FE 23 C0 C5 CD 1B 52 CF 2C ";
            S = S + "7B E5 CD AA 6A 7E E1 C1 B9 28 0E FE 04 28 0A FE ";
            S = S + "08 20 03 79 FE 02 C2 7D 6E 7E C9 01 17 63 C5 AF ";
            S = S + "C3 24 6B EF 01 F1 4B 11 20 2C 20 17 5A 18 14 01 ";
            S = S + "FF 4A C5 CD 55 6D CD A4 5E CD 58 30 D5 01 7B 48 ";
            S = S + "AF 57 5F F5 C5 E5 CD 71 6C DA 83 6E FE 20 20 04 ";
            S = S + "14 15 20 F2 FE 22 20 0E 7B FE 2C 3E 22 20 07 57 ";
            S = S + "5F CD 71 6C 38 47 21 5E F5 06 FF 4F 7A FE 22 79 ";
            S = S + "28 2A FE 0D E5 28 50 E1 FE 0A 20 20 4F 7B FE 2C ";
            S = S + "79 C4 61 6E CD 71 6C 38 24 FE 0A 28 EF FE 0D 20 ";
            S = S + "0B 7B FE 20 28 12 FE 2C 3E 0D 28 0C B7 28 09 BA ";
            S = S + "28 0B BB 28 08 CD 61 6E CD 71 6C 30 BE E5 FE 22 ";
            S = S + "28 04 FE 20 20 2B CD 71 6C 38 26 FE 20 28 F7 FE ";
            S = S + "2C 28 1E FE 0D 20 09 CD 71 6C 38 15 FE 0A 28 11 ";
            S = S + "4F CD 62 6C 30 06 CD AD FE C3 80 6E 3E 12 CD 8F ";
            S = S + "6F E1 36 00 21 5D F5 7B D6 20 28 07 06 00 CD 38 ";
            S = S + "66 E1 C9 EF F5 D7 F1 F5 DC 99 32 F1 D4 99 32 E1 ";
            S = S + "C9 B7 C8 77 23 05 C0 F1 C3 42 6E 1E 38 01 1E 36 ";
            S = S + "01 1E 39 01 1E 35 01 1E 3B 01 1E 32 01 1E 34 01 ";
            S = S + "1E 33 01 1E 37 01 1E 3A AF 32 7C F8 32 AE FC C3 ";
            S = S + "6F 40 CD 0E 6A D5 CF 2C CD 0B 6F EB 22 BF FC EB ";
            S = S + "D5 CF 2C CD 0B 6F EB 22 7D F8 EB 2B D7 28 0A CF ";
            S = S + "2C CD 0B 6F EB 22 BF FC EB C1 D1 E5 C5 7A FE FF ";
            S = S + "CA D7 6F C3 6B 6E CD 0E 6A D5 AF 32 BE FC 2B D7 ";
            S = S + "01 00 00 28 13 CF 2C FE 52 20 08 32 BE FC D7 28 ";
            S = S + "07 CF 2C CD 0B 6F 42 4B D1 E5 C5 7A FE FF CA 14 ";
            S = S + "70 C3 6B 6E 3A BE FC B7 28 0C AF CD 24 6B 21 F3 ";
            S = S + "6C E5 2A BF FC E9 E1 AF C3 24 6B CD 64 4C E5 CD ";
            S = S + "39 54 D1 EB C9 CD B2 FE 7E FE 3A 38 1A E5 53 7E ";
            S = S + "23 1D 28 0A FE 3A 28 15 7E 23 1D F2 24 6F 5A E1 ";
            S = S + "AF 3E FF CD B7 FE C9 CD BC FE C3 6B 6E 7A 93 3D ";
            S = S + "C1 D5 C5 4F 47 11 76 6F E3 E5 CD A9 4E C5 47 1A ";
            S = S + "23 13 B8 C1 20 0D 0D 20 F1 1A B7 F2 63 6F E1 E1 ";
            S = S + "D1 B7 C9 B7 FA 59 6F 1A 87 13 30 FB 48 E1 E5 1A ";
            S = S + "B7 20 D7 C3 F8 55 43 41 53 FF 4C 50 54 FE 43 52 ";
            S = S + "54 FD 47 52 50 FC 00 C7 71 A6 72 A2 71 82 71 CD ";
            S = S + "C6 FE E5 D5 F5 11 04 00 19 7E FE FC DA 4A 56 3E ";
            S = S + "FF 96 87 5F 21 87 6F 19 5E 23 56 F1 6F 26 00 19 ";
            S = S + "5E 23 56 EB D1 E3 C9 CD 98 70 2B D7 28 05 CF 2C ";
            S = S + "CD 2D 7A E5 3E D3 CD 25 71 2A C2 F6 22 7D F8 2A ";
            S = S + "76 F6 CD 3E 71 E1 C9 3E D0 CD 25 71 AF CD F8 72 ";
            S = S + "E1 E5 CD 03 70 2A 7D F8 E5 CD 03 70 2A BF FC CD ";
            S = S + "03 70 D1 E1 7E CD DE 72 E7 30 03 23 18 F6 CD F0 ";
            S = S + "00 E1 C9 7D CD DE 72 7C C3 DE 72 CD D4 72 6F CD ";
            S = S + "D4 72 67 C9 0E D0 CD B8 70 CD E9 72 C1 CD 0B 70 ";
            S = S + "09 EB CD 0B 70 09 E5 CD 0B 70 22 BF FC EB D1 CD ";
            S = S + "D4 72 77 E7 28 03 23 18 F6 CD E7 00 C3 F4 6E D6 ";
            S = S + "91 28 02 AF 01 2F 23 FE 01 F5 CD 8C 70 0E D3 CD ";
            S = S + "B8 70 F1 32 F8 F7 DC 87 62 3A F8 F7 FE 01 32 F5 ";
            S = S + "F3 F5 CD EA 54 F1 2A 76 F6 CD 5D 71 20 10 22 C2 ";
            S = S + "F6 21 D7 3F CD 78 66 2A 76 F6 E5 C3 37 42 23 EB ";
            S = S + "2A C2 F6 E7 DA 71 70 1E 14 C3 6F 40 2B D7 20 08 ";
            S = S + "E5 21 66 F8 06 06 18 19 CD 64 4C E5 CD 0F 68 2B ";
            S = S + "2B 46 0E 06 21 66 F8 1A 77 23 13 0D 28 08 10 F7 ";
            S = S + "41 36 20 23 10 FB E1 C9 CD E9 72 06 0A CD D4 72 ";
            S = S + "B9 20 F5 10 F8 21 71 F8 E5 06 06 CD D4 72 77 23 ";
            S = S + "10 F9 E1 11 66 F8 06 06 1A 13 FE 20 20 04 10 F8 ";
            S = S + "18 0D 11 66 F8 06 06 1A BE 20 0A 23 13 10 F8 21 ";
            S = S + "FF 70 C3 0D 71 C5 21 06 71 CD 0D 71 C1 18 B9 46 ";
            S = S + "6F 75 6E 64 3A 00 53 6B 69 70 20 3A 00 ED 5B 1C ";
            S = S + "F4 13 7A B3 C0 CD 78 66 21 71 F8 06 06 7E 23 DF ";
            S = S + "10 FB C3 28 73 CD F8 72 06 0A CD DE 72 10 FB 06 ";
            S = S + "06 21 66 F8 7E 23 CD DE 72 10 F9 C3 F0 00 E5 CD ";
            S = S + "EA 54 AF CD F8 72 D1 2A 7D F8 1A 13 CD DE 72 E7 ";
            S = S + "20 F8 2E 07 CD DE 72 2D 20 FA C3 F0 00 CD E9 72 ";
            S = S + "9F 2F 57 06 0A CD D4 72 5F CD 67 62 7B 96 A2 C2 ";
            S = S + "E7 00 73 7E B7 23 20 EB 10 EB 01 FA FF 09 AF C3 ";
            S = S + "E7 00 B6 71 C2 71 86 6E 96 71 5A 47 5A 47 5A 47 ";
            S = S + "5A 47 5A 47 5A 47 3A AF FC FE 02 DA 5A 47 79 C3 ";
            S = S + "8D 00 B6 71 C2 71 86 6E C3 71 5A 47 5A 47 5A 47 ";
            S = S + "5A 47 5A 47 5A 47 CD CD 72 FE 01 CA 6B 6E 22 64 ";
            S = S + "F8 73 C9 79 C3 A2 00 DB 71 05 72 86 6E 2A 72 3F ";
            S = S + "72 5A 47 5A 47 6D 72 5A 47 7C 72 E5 D5 01 06 00 ";
            S = S + "09 AF 77 32 B1 FC CD CD 72 FE 04 CA 6B 6E FE 01 ";
            S = S + "28 09 3E EA CD 25 71 D1 E1 18 C3 0E EA CD B8 70 ";
            S = S + "CD E7 00 18 F2 7E FE 01 28 1B 3E 1A E5 CD 8B 72 ";
            S = S + "CC 2F 72 E1 CD 81 72 28 0C E5 09 36 1A 23 0C 20 ";
            S = S + "FA E1 CD 2F 72 AF 32 B1 FC C9 79 CD 8B 72 C0 AF ";
            S = S + "CD F8 72 06 00 7E CD DE 72 23 10 F9 C3 F0 00 EB ";
            S = S + "21 B1 FC CD BE 72 EB CD 9B 72 20 14 E5 CD E9 72 ";
            S = S + "E1 06 00 CD D4 72 77 23 10 F9 CD E7 00 25 AF 47 ";
            S = S + "4F 09 7E FE 1A 37 3F C0 32 B1 FC 37 C9 CD 3F 72 ";
            S = S + "21 B1 FC 77 D6 1A D6 01 9F C3 9A 2E 21 B1 FC 71 ";
            S = S + "C9 01 06 00 09 7E 4F 36 00 18 16 5F 01 06 00 09 ";
            S = S + "7E 34 23 23 23 E5 4F 09 73 E1 C9 01 06 00 09 7E ";
            S = S + "34 23 23 23 A7 C9 B6 71 C2 71 86 6E BA 72 5A 47 ";
            S = S + "5A 47 5A 47 5A 47 5A 47 5A 47 79 C3 4D 01 7E 36 ";
            S = S + "00 A7 C8 33 33 FE 1A 37 3F C0 77 37 C9 7B FE 08 ";
            S = S + "CA 6B 6E C9 E5 D5 C5 CD E4 00 30 24 18 14 E5 D5 ";
            S = S + "C5 F5 CD ED 00 30 18 18 09 E5 D5 C5 F5 CD E1 00 ";
            S = S + "30 0D CD E7 00 C3 B2 73 E5 D5 C5 F5 CD EA 00 F1 ";
            S = S + "C1 D1 E1 C9 AF 32 16 F4 3A 15 F4 B7 C8 3E 0D CD ";
            S = S + "1C 73 3E 0A CD 1C 73 AF 32 15 F4 C9 CD A5 00 D0 ";
            S = S + "C3 B2 73 3A 61 F6 B7 C8 CD E9 FE 3E 0D DF 3E 0A ";
            S = S + "DF CD 4A 01 28 02 AF C9 3A 16 F4 B7 28 05 AF 32 ";
            S = S + "15 F4 C9 32 61 F6 C9 D7 E5 CD 9C 00 28 0C CD 9F ";
            S = S + "00 F5 CD 25 66 F1 5F CD 21 68 21 D6 3F 22 F8 F7 ";
            S = S + "3E 03 32 63 F6 E1 C9 DF FE 0A C0 3E 0D DF CD 31 ";
            S = S + "73 3E 0A C9 CD EE FE 06 FF 21 5E F5 CD 71 6C 38 ";
            S = S + "16 77 FE 0D 28 0B FE 09 28 04 FE 0A 28 EE 23 10 ";
            S = S + "EB AF 77 21 5D F5 C9 04 20 F7 3A 7C F8 E6 80 32 ";
            S = S + "7C F8 CD 7B 6D 3A 66 F8 A7 CA 1E 41 CD 9A 62 C3 ";
            S = S + "01 46 1E 13 C3 6F 40 1E FF 28 0B D6 EB 5F 28 05 ";
            S = S + "CF 95 1E 01 3E D7 7B C3 F3 00 CD 1C 52 FE 0E D2 ";
            S = S + "5A 47 F5 CF 2C CD 1C 52 F1 FE 07 20 04 CB B3 CB ";
            S = S + "FB C3 93 00 20 CD C5 FF E5 21 2E 75 22 56 F9 3E ";
            S = S + "00 32 35 FB 21 F6 FF 39 22 36 FB E1 F5 CD 64 4C ";
            S = S + "E3 E5 CD D0 67 CD DF 2E 7B B7 20 07 1E 01 01 E4 ";
            S = S + "73 51 48 F1 F5 CD 50 01 73 23 72 23 71 23 54 5D ";
            S = S + "01 1C 00 09 EB 73 23 72 C1 E1 04 78 FE 03 30 16 ";
            S = S + "2B D7 28 05 C5 CF 2C 18 C4 78 32 38 FB CD 07 75 ";
            S = S + "04 78 FE 03 38 F3 2B D7 C2 55 40 E5 AF F5 32 38 ";
            S = S + "FB 47 CD 21 75 DA D6 74 78 CD 50 01 7E B7 CA D6 ";
            S = S + "74 32 3B FB 23 5E 23 56 23 ED 53 3C FB 5E 23 56 ";
            S = S + "23 E5 2E 24 CD 53 01 E5 2A 36 FB 2B C1 F3 CD 53 ";
            S = S + "62 D1 60 69 F9 FB 3E FF 32 58 F9 C3 A2 56 3A 3B ";
            S = S + "FB B7 20 03 CD 07 75 3A 38 FB CD 50 01 3A 3B FB ";
            S = S + "77 23 ED 5B 3C FB 73 23 72 21 00 00 39 EB 2A 36 ";
            S = S + "FB F3 F9 C1 C1 C1 E5 B7 ED 52 28 18 3E F0 A5 B4 ";
            S = S + "C2 5A 47 2E 24 CD 53 01 C1 0B CD 53 62 E1 2B 70 ";
            S = S + "2B 71 18 02 C1 C1 FB F1 3C FE 03 DA 4D 74 F3 3A ";
            S = S + "9B FC FE 03 28 1C 3A 35 FB 07 38 07 21 40 FB 34 ";
            S = S + "CD 99 00 FB 21 35 FB 7E F6 80 77 FE 83 C2 4C 74 ";
            S = S + "E1 C9 CD 90 00 18 F9 3A 35 FB 3C 32 35 FB 1E FF ";
            S = S + "E5 C5 D5 3A 38 FB F3 CD F9 00 FB D1 28 F4 C1 E1 ";
            S = S + "C9 3A 38 FB C5 F3 CD F6 00 FB C1 FE 08 C9 41 3E ";
            S = S + "76 42 3E 76 43 3E 76 44 3E 76 45 3E 76 46 3E 76 ";
            S = S + "47 3E 76 CD 9E 75 D6 86 75 D3 BE 75 CE 21 76 CF ";
            S = S + "EF 75 D2 FC 75 D4 E2 75 CC C8 75 58 82 57 00 10 ";
            S = S + "12 14 16 00 00 02 04 06 08 0A 0A 0C 0E 10 5D 0D ";
            S = S + "9C 0C E7 0B 3C 0B 9B 0A 02 0A 73 09 EB 08 6B 08 ";
            S = S + "F2 07 80 07 14 07 38 02 1E 08 3E 0F BB 38 50 AF ";
            S = S + "B2 20 4C 2E 12 CD 53 01 3E 40 A6 B3 77 C9 7B 38 ";
            S = S + "03 2F 3C 5F B2 28 38 2E 13 CD 53 01 E5 7E 23 66 ";
            S = S + "6F E7 E1 C8 73 23 72 2B 2B 3E 40 B6 77 C9 7B FE ";
            S = S + "10 30 1C F6 10 5F 18 C7 38 02 1E 04 7B FE 41 30 ";
            S = S + "0E 2E 10 CD 53 01 AF B2 20 05 B3 28 02 77 C9 CD ";
            S = S + "5A 47 38 02 1E 78 7B FE 20 38 F4 2E 11 18 E4 38 ";
            S = S + "02 1E 04 7B FE 09 30 E7 2E 0F 18 D7 38 02 1E 04 ";
            S = S + "AF B2 20 DB B3 28 D8 FE 41 30 D4 21 00 00 E5 2E ";
            S = S + "10 CD 53 01 E5 23 23 7E 32 39 FB 36 80 2B 2B 18 ";
            S = S + "7B 30 BC AF B2 20 B8 B3 28 E1 FE 61 30 B1 7B 06 ";
            S = S + "00 58 D6 0C 1C 30 FB C6 0C 87 4F C3 73 76 41 79 ";
            S = S + "D6 40 87 4F CD EE 56 28 1C FE 23 28 19 FE 2B 28 ";
            S = S + "15 FE 2D 28 05 CD 0B 57 18 0B 0D 78 FE 43 28 04 ";
            S = S + "FE 46 20 01 0D 0D 2E 0F CD 53 01 5E 06 00 21 5F ";
            S = S + "75 09 4E 21 6E 75 09 7B 5E 23 56 3D 28 09 CB 3A ";
            S = S + "CB 1B 18 F7 CD 5A 47 8B 5F 8A 93 57 D5 2E 10 CD ";
            S = S + "53 01 4E E5 CD EE 56 28 10 CD 2F 57 3E 40 BB 38 ";
            S = S + "E3 AF B2 20 DF B3 28 01 4B E1 16 00 42 23 5E E5 ";
            S = S + "CD 4A 31 EB CD CB 2F CD 0D 2F 21 54 77 CD BE 2E ";
            S = S + "CD 9F 28 CD 8A 2F 54 5D CD EE 56 28 16 FE 2E 20 ";
            S = S + "0F CB 3A CB 1B ED 5A 3E E0 A4 28 EC AC 67 18 03 ";
            S = S + "CD 0B 57 11 05 00 E7 38 01 EB 01 F7 FF E1 E5 09 ";
            S = S + "72 23 73 23 0E 02 E3 23 5E 7B E6 BF 77 E3 3E 80 ";
            S = S + "B3 77 23 0C E3 7B E6 40 28 0C 23 5E 23 56 E1 72 ";
            S = S + "23 73 23 0C 0C FE E1 D1 7A B3 28 05 72 23 73 0C ";
            S = S + "0C 2E 07 CD 53 01 71 79 D6 02 0F 0F 0F 23 B6 77 ";
            S = S + "2B 7A B3 20 0C E5 3A 39 FB F6 80 01 0B 00 09 77 ";
            S = S + "E1 D1 46 23 5E 23 CD 10 75 10 F9 CD 21 75 DA 8E ";
            S = S + "74 C3 A2 56 00 00 45 12 06 80 11 06 00 FE C7 CA ";
            S = S + "AF 7A 78 C3 35 6C ED 5B DC F3 D5 FE 2C 28 0B CD ";
            S = S + "1C 52 3C D1 57 D5 2B D7 28 25 CF 2C FE 2C 28 0B ";
            S = S + "CD 1C 52 3C D1 5F D5 2B D7 28 14 CF 2C CD 1C 52 ";
            S = S + "A7 3E 79 20 01 3D F5 3E 1B DF F1 DF 3E 35 DF E3 ";
            S = S + "CD C6 00 E1 C9 E5 21 6A FC 18 24 E5 21 6D FC 18 ";
            S = S + "1E CF 45 CF 52 CF FF CF 94 E5 21 7F FC 18 10 3E ";
            S = S + "04 CD 08 7C 2B D7 E5 16 00 21 70 FC 19 19 19 CD ";
            S = S + "FE 77 18 0E CD 1C 52 3D FE 0A D2 5A 47 7E E5 CD ";
            S = S + "E8 77 E1 F1 D7 C3 12 46 16 00 21 CD FB 19 E5 21 ";
            S = S + "49 FC 19 19 19 CD FE 77 7E E6 01 E1 77 C9 FE 95 ";
            S = S + "CA 1B 63 FE EB CA 2B 63 FE 90 CA 31 63 C3 55 40 ";
            S = S + "CD EA FD 01 0A 00 FE CC C8 01 01 0A FE 90 C8 04 ";
            S = S + "FE C7 C8 FE FF D8 E5 D7 FE A3 28 07 FE 85 28 08 ";
            S = S + "E1 37 C9 C1 01 05 0C C9 D7 FE 45 20 F3 C1 D7 CF ";
            S = S + "52 CF FF CF 94 CF EF CD 2F 54 7A B3 CA 5A 47 EB ";
            S = S + "22 A0 FC 22 A2 FC EB 01 01 11 2B C9 E5 47 87 80 ";
            S = S + "6F 26 00 01 4D FC 09 73 23 72 E1 C9 FE 93 20 3E ";
            S = S + "D7 E5 21 7F F8 0E 0A 06 10 7E 23 CD AB 00 38 11 ";
            S = S + "05 28 1B 7E 23 5F CD AB 00 28 06 3E 01 DF 7B 18 ";
            S = S + "0A FE 7F 28 04 FE 20 30 02 3E 20 DF 10 DB CD 28 ";
            S = S + "73 0D 20 D3 E1 C9 D7 C3 CF 00 D7 C3 CC 00 FE 28 ";
            S = S + "CA D4 77 FE 95 28 EF FE EB 28 EF CD 1C 52 3D FE ";
            S = S + "0A D2 5A 47 EB 6F 26 00 29 29 29 29 01 7F F8 09 ";
            S = S + "E5 EB CF 2C CD 64 4C E5 CD D0 67 46 23 5E 23 56 ";
            S = S + "E1 E3 0E 0F 78 A7 28 0D 1A A7 CA 5A 47 77 13 23 ";
            S = S + "0D 28 07 10 F3 70 23 0D 20 FB 71 CD C9 00 E1 C9 ";
            S = S + "D7 E5 2A 9E FC CD 36 32 E1 C9 D7 E5 3A DC F3 18 ";
            S = S + "21 CF EF CD 2F 54 ED 53 9E FC C9 D7 3E 03 CD 08 ";
            S = S + "7C E5 3A 3F FB 1D FA 38 79 0F 1D F2 29 79 3E 00 ";
            S = S + "30 01 3D CD 9A 2E E1 C9 E6 07 28 F7 3E FF 18 F3 ";
            S = S + "CD 1F 52 FE 03 30 0A CD D5 00 18 1A CD 1F 52 FE ";
            S = S + "05 D2 5A 47 CD D8 00 C3 9A 2E CD 1F 52 3D FE 0C ";
            S = S + "30 EF 3C CD DE 00 C3 CF 4F CD 1F 52 FE 08 30 E1 ";
            S = S + "F5 CD DB 00 47 F1 E6 03 3D FE 02 78 38 E8 18 D7 ";
            S = S + "01 5A 47 C5 ED 5B E9 F3 D5 FE 2C 28 0D CD 1C 52 ";
            S = S + "D1 FE 10 D0 5F D5 2B D7 28 22 CF 2C 28 1E FE 2C ";
            S = S + "28 0D CD 1C 52 D1 FE 10 D0 57 D5 2B D7 28 0D CF ";
            S = S + "2C CD 1C 52 D1 FE 10 D0 32 EB F3 D5 D1 F1 E5 EB ";
            S = S + "22 E9 F3 7D 32 F2 F3 CD 62 00 E1 C9 CD C0 FF FE ";
            S = S + "2C 28 17 CD 1C 52 FE 04 D2 5A 47 E5 CD 5F 00 3A ";
            S = S + "B0 F3 5F CD 01 52 E1 2B D7 C8 CF 2C FE 2C 28 19 ";
            S = S + "CD 1C 52 FE 04 D2 5A 47 3A E0 F3 E6 FC B3 32 E0 ";
            S = S + "F3 E5 CD 69 00 E1 2B D7 C8 CF 2C FE 2C 28 09 CD ";
            S = S + "1C 52 32 DB F3 2B D7 C8 CF 2C FE 2C 28 06 CD 2D ";
            S = S + "7A 2B D7 C8 CF 2C CD 1C 52 32 17 F4 C9 CD 1C 52 ";
            S = S + "3D FE 02 D2 5A 47 E5 01 05 00 A7 21 FC F3 28 01 ";
            S = S + "09 11 06 F4 ED B0 E1 C9 FE 24 C2 AB 77 3A AF FC ";
            S = S + "A7 CA 5A 47 CD A0 7A D5 CD 5F 4C E3 E5 CD D0 67 ";
            S = S + "23 5E 23 56 CD 8A 00 4F 06 00 2B 2B 3D BE 7E 38 ";
            S = S + "0C E1 E5 F5 AF CD 56 00 F1 A7 4F 06 00 EB D1 C4 ";
            S = S + "5C 00 E1 C9 CD 9F 7A E5 D5 CD 8A 00 4F 06 00 C5 ";
            S = S + "CD 27 66 2A 99 F6 EB C1 E1 CD 59 00 C3 54 66 D7 ";
            S = S + "CF 24 3E FF CD 08 7C E5 7B CD 84 00 EB E1 C9 05 ";
            S = S + "FA 5A 47 3A AF FC A7 CA 5A 47 D7 CD 1C 52 FE 20 ";
            S = S + "D2 5A 47 E5 CD 87 00 E3 CF 2C FE 2C 28 2B CD 9C ";
            S = S + "57 E3 7B CD 4D 00 78 87 79 06 00 30 04 C6 20 06 ";
            S = S + "80 23 CD 4D 00 23 23 CD 4A 00 E6 0F B0 CD 4D 00 ";
            S = S + "2B 2B 2B E3 2B D7 C1 C8 C5 CF 2C FE 2C 28 1E CD ";
            S = S + "1C 52 FE 10 D2 5A 47 E3 23 23 23 CD 4A 00 E6 80 ";
            S = S + "B3 CD 4D 00 2B 2B 2B E3 2B D7 C1 C8 C5 CF 2C CD ";
            S = S + "1C 52 CD 8A 00 7B 30 07 FE 40 D2 5A 47 87 87 E3 ";
            S = S + "23 23 CD 4D 00 E1 C9 3E 07 CD 08 7C D5 CF EF CD ";
            S = S + "1C 52 C1 47 C3 47 00 D7 3E 08 CD 08 7C E5 16 00 ";
            S = S + "21 DF F3 19 7E CD CF 4F E1 C9 3E 13 CD 08 7C 16 ";
            S = S + "00 D5 CF EF CD 64 4C E3 E5 CD FE 7B 4D 44 E1 7D ";
            S = S + "F5 29 EB 21 A3 7B 19 79 A6 20 03 23 78 A6 C2 5A ";
            S = S + "47 21 B3 F3 19 71 23 70 F1 1E FF 1C D6 05 30 FB ";
            S = S + "3A AF FC BB CC 99 7B E1 C9 3D FA 78 00 CA 7E 00 ";
            S = S + "C3 81 00 FF 03 3F 00 FF 07 7F 00 FF 07 FF 03 3F ";
            S = S + "00 FF 07 7F 00 FF 07 FF 03 FF 1F FF 1F 7F 00 FF ";
            S = S + "07 FF 03 3F 00 FF 07 7F 00 FF 07 D7 3E 13 CD 08 ";
            S = S + "7C E5 16 00 21 B3 F3 19 19 7E 23 66 6F CD 36 32 ";
            S = S + "E1 C9 CD 64 4C E5 CD FE 7B E3 CF 2C CD 1C 52 E3 ";
            S = S + "CD 4D 00 E1 C9 CD FE 7B CD 4A 00 C3 CF 4F CD 8A ";
            S = S + "2F 11 00 40 E7 D8 18 6B F5 CF 28 CD 1C 52 F1 BB ";
            S = S + "38 61 CF 29 7B C9 CD EF FD 18 58 CD F4 FD 18 53 ";
            S = S + "CD F9 FD 18 4E CD FE FD 18 49 CD 03 FE 18 44 CD ";
            S = S + "08 FE 18 3F CD 0D FE 18 3A CD 12 FE 18 35 CD 17 ";
            S = S + "FE 18 30 CD 1C FE 18 2B CD 21 FE 18 26 CD 26 FE ";
            S = S + "18 21 CD 2B FE 18 1C CD 30 FE 18 17 CD 35 FE 18 ";
            S = S + "12 CD 3A FE 18 0D CD 3F FE 18 08 CD 44 FE 18 03 ";
            S = S + "CD 49 FE C3 5A 47 31 76 F3 01 2F 02 11 9B FD 21 ";
            S = S + "9A FD 36 C9 ED B0 21 80 F3 22 4A FC CD 5D 7D 22 ";
            S = S + "48 FC 01 90 00 11 80 F3 21 27 7F ED B0 CD 3E 00 ";
            S = S + "AF 32 60 F6 32 7C F8 3E 2C 32 5D F5 3E 3A 32 1E ";
            S = S + "F4 2A 04 00 22 20 F9 21 E4 F6 22 4C F7 22 74 F6 ";
            S = S + "01 C8 00 09 22 72 F6 3E 01 32 C3 F6 CD 6B 7E CD ";
            S = S + "E5 62 2A 48 FC AF 77 23 22 76 F6 CD 87 62 CD 3B ";
            S = S + "00 CD 6F 00 CD 69 00 21 0B 0A 22 DC F3 21 D8 7E ";
            S = S + "CD 78 66 21 0C 0A 22 DC F3 21 E4 7E CD 78 66 21 ";
            S = S + "0E 02 22 DC F3 21 FD 7E CD 78 66 06 06 2B 7D B4 ";
            S = S + "20 FB 06 00 CD 75 7D 2A 48 FC AF 77 23 22 76 F6 ";
            S = S + "CD 87 62 CD 29 7D C3 1F 41 3E FF 32 DE F3 CD 6C ";
            S = S + "00 21 F2 7E CD 78 66 21 E4 7E CD 78 66 21 FD 7E ";
            S = S + "CD 78 66 2A C2 F6 EB 2A 74 F6 7D 93 6F 7C 9A 67 ";
            S = S + "01 F2 FF 09 CD 12 34 21 1B 7F C3 78 66 21 00 80 ";
            S = S + "C9 2F 77 BE 2F 77 20 09 2C 20 F5 7C 3D F0 67 18 ";
            S = S + "EF 2E 00 24 C9 F3 0E 00 11 C1 FC 21 C9 FC 1A B1 ";
            S = S + "4F D5 23 E5 21 00 40 CD 1A 7E E5 21 41 42 E7 E1 ";
            S = S + "06 00 20 2A CD 1A 7E E5 C5 D5 DD E1 79 F5 FD E1 ";
            S = S + "C4 1C 00 C1 E1 CD 1A 7E C6 FF CB 18 CD 1A 7E C6 ";
            S = S + "FF CB 18 CD 1A 7E C6 FF CB 18 11 F8 FF 19 E3 70 ";
            S = S + "23 E3 11 FE 3F 19 7C FE C0 38 BC E1 23 79 A7 11 ";
            S = S + "0C 00 F2 E0 7D C6 04 4F FE 90 38 A6 E6 03 4F 3E ";
            S = S + "19 D1 13 0C 79 FE 04 38 95 21 C9 FC 06 40 7E 87 ";
            S = S + "38 04 23 10 F9 C9 CD 2A 7E CD 24 00 2A C2 F6 11 ";
            S = S + "00 C0 E7 30 04 EB 22 C2 F6 2A 08 80 23 22 76 F6 ";
            S = S + "7C 32 B1 FB CD 9A 62 C3 01 46 CD 1E 7E 5A 79 C5 ";
            S = S + "D5 CD 0C 00 D1 C1 57 B3 23 C9 3E 40 90 47 26 00 ";
            S = S + "1F CB 1C 1F CB 1C 1F 1F E6 03 4F 78 06 00 E5 21 ";
            S = S + "C1 FC 09 E6 0C B1 4F 7E E1 B1 C9 CF B7 CF EF CD ";
            S = S + "1C 52 C2 55 40 FE 10 D2 5A 47 22 A7 F6 F5 CD 1C ";
            S = S + "6C F1 CD 6B 7E CD A7 62 C3 01 46 F5 2A 4A FC 11 ";
            S = S + "F5 FE 19 3D F2 72 7E EB 2A 74 F6 44 4D 2A 72 F6 ";
            S = S + "7D 91 6F 7C 98 67 F1 E5 F5 01 8C 00 09 44 4D 2A ";
            S = S + "C2 F6 09 E7 D2 75 62 F1 32 5F F8 6B 62 22 60 F8 ";
            S = S + "2B 2B 22 72 F6 C1 7D 91 6F 7C 98 67 22 74 F6 2B ";
            S = S + "2B C1 F9 C5 3A 5F F8 6F 2C 26 00 29 19 EB D5 01 ";
            S = S + "09 01 73 23 72 23 EB 36 00 09 EB 3D F2 C2 7E E1 ";
            S = S + "01 09 00 09 22 62 F8 C9 4D 53 58 20 20 73 79 73 ";
            S = S + "74 65 6D 00 76 65 72 73 69 6F 6E 20 31 2E 30 0D ";
            S = S + "0A 00 4D 53 58 20 42 41 53 49 43 20 00 43 6F 70 ";
            S = S + "79 72 69 67 68 74 20 31 39 38 33 20 62 79 20 4D ";
            S = S + "69 63 72 6F 73 6F 66 74 0D 0A 00 20 42 79 74 65 ";
            S = S + "73 20 66 72 65 65 00 D3 A8 5E 18 03 D3 A8 73 7A ";
            S = S + "D3 A8 C9 D3 A8 08 CD 98 F3 08 F1 D3 A8 08 C9 DD ";
            S = S + "E9 5A 47 5A 47 5A 47 5A 47 5A 47 5A 47 5A 47 5A ";
            S = S + "47 5A 47 5A 47 25 1D 1D 18 0E 00 00 00 00 00 08 ";
            S = S + "00 00 00 00 00 18 00 20 00 00 00 1B 00 38 00 18 ";
            S = S + "00 20 00 00 00 1B 00 38 00 08 00 00 00 00 00 1B ";
            S = S + "00 38 01 01 01 00 00 E0 00 00 00 00 00 00 00 FF ";
            S = S + "0F 04 04 C3 00 00 C3 00 00 0F 59 F9 FF 01 32 F0 ";
            S = S + "FB F0 FB 53 5C 26 2D 0F 25 2D 0E 16 1F 53 5C 26 ";
            S = S + "2D 0F 00 01 00 01 3A 11 89 FD A7 C0 04 C9 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";

            return S;
        }

         public static string gs_Get_MSX2_BIOS()
        {
            string S;

            S = "";

          //== MSX2 BIOS [0000H~3FFFH,4000H,16384] ==
            S = S + "F3 C3 16 04 BF 1B 98 98 C3 83 26 00 C3 F5 01 00 ";
            S = S + "C3 86 26 00 C3 25 02 00 C3 45 1B 00 C3 17 02 00 ";
            S = S + "C3 04 0C 00 C3 33 03 00 C3 89 26 91 11 01 00 00 ";
            S = S + "C3 C6 02 00 00 00 00 00 C3 3C 0C C3 92 05 C3 A0 ";
            S = S + "13 C3 0A 06 C3 03 06 C3 12 06 C3 E1 07 C3 D7 07 ";
            S = S + "C3 08 08 C3 F4 07 C3 3B 08 C3 3D 07 C3 80 07 C3 ";
            S = S + "B1 08 C3 1A 08 00 C3 9B 13 C3 7F 06 C3 3E 06 C3 ";
            S = S + "47 06 C3 4F 06 C3 57 06 C3 5F 06 C3 67 06 C3 6F ";
            S = S + "06 C3 77 06 C3 EC 06 C3 01 07 C3 0C 07 C3 0E 15 ";
            S = S + "C3 B2 05 C3 02 11 C3 0E 11 C3 BA 11 C3 6A 0D C3 ";
            S = S + "CB 10 C3 19 09 C3 BA 08 C3 E1 08 C3 FA 08 C3 BF ";
            S = S + "23 C3 D5 23 C3 CC 23 C3 64 05 C3 F0 04 C3 F9 10 ";
            S = S + "C3 13 11 C3 97 08 C3 EB 08 C3 3A 0B C3 29 0B C3 ";
            S = S + "3F 0B C3 9E 08 C3 E4 11 C3 49 12 C3 A2 12 C3 69 ";
            S = S + "12 C3 63 1A C3 BC 1A C3 E9 19 C3 F1 19 C3 19 1A ";
            S = S + "C3 DD 19 C3 87 13 C3 E9 14 C3 90 14 C3 56 17 C3 ";
            S = S + "90 17 C3 1F 18 C3 F6 17 C3 DC 17 C3 B4 17 C3 A5 ";
            S = S + "15 C3 04 16 C3 51 16 C3 58 16 C3 92 16 C3 5F 16 ";
            S = S + "C3 C3 16 C3 43 18 C3 01 19 C3 09 19 C3 1E 19 C3 ";
            S = S + "94 19 C3 3D 0F C3 7A 0F C3 0E 14 C3 11 14 C3 0B ";
            S = S + "14 C3 EC 0B C3 14 14 C3 18 14 C3 F9 0B C3 63 1B ";
            S = S + "C3 0A 0C C3 0E 0C C3 5D 05 C3 BF 02 C3 95 02 C3 ";
            S = S + "9B 02 C3 AC 03 C3 A9 06 C3 05 0B C3 38 08 C3 C5 ";
            S = S + "06 C3 B3 06 C3 E9 07 C3 69 07 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 F1 16 FC E6 0C 0F 0F 67 DB A8 ";
            S = S + "47 E6 3F D3 A8 3A FF FF 2F 4F A2 B4 5F 32 FF FF ";
            S = S + "78 A2 D3 A8 7B 32 C5 FC C5 D9 08 CD 98 F3 F3 08 ";
            S = S + "D9 C1 78 E6 3F D3 A8 79 32 FF FF 78 D3 A8 79 32 ";
            S = S + "C5 FC 08 D9 C9 CD 53 03 FA 05 02 DB A8 57 A1 B0 ";
            S = S + "CD 80 F3 7B C9 CD 8C 02 20 10 E5 CD 55 02 E3 CD ";
            S = S + "BE 7F 18 30 00 00 00 C3 D8 02 E5 CD 78 03 E3 C5 ";
            S = S + "CD F5 01 18 54 D5 CD 53 03 FA 35 02 D1 DB A8 57 ";
            S = S + "A1 B0 C3 85 F3 CD 8C 02 C2 6E 02 D1 E5 CD 55 02 ";
            S = S + "E3 CD C4 7F E3 F5 7D E6 3F D3 A8 7C 32 FF FF 7D ";
            S = S + "D3 A8 F1 E1 C9 F5 DB A8 6F E6 3F D3 A8 3A FF FF ";
            S = S + "2F 67 E6 F3 32 FF FF 7D E6 F3 D3 A8 F1 C9 E3 E5 ";
            S = S + "CD 78 03 D1 E3 C5 CD 25 02 C1 E3 F5 78 E6 3F B1 ";
            S = S + "D3 A8 7D 32 FF FF 78 D3 A8 F1 E1 C9 14 15 C0 47 ";
            S = S + "7B FE 03 78 C9 CD 9B 02 DD E1 C9 D9 08 E5 D5 C5 ";
            S = S + "F5 ED 57 F5 D9 08 FD E5 FD 2A F7 FA CD 17 02 FD ";
            S = S + "E1 08 D9 F1 E2 B8 02 FB F1 C1 D1 E1 D9 08 C9 FD ";
            S = S + "2A C0 FC C3 17 02 E3 F5 D5 7E F5 FD E1 23 5E 23 ";
            S = S + "56 23 D5 DD E1 D1 F1 E3 D9 08 FD E5 F1 DD E5 E1 ";
            S = S + "CD 53 03 FA EF 02 DB A8 F5 A1 B0 D9 C3 8C F3 F5 ";
            S = S + "E6 03 20 06 7C E6 C0 CA B6 01 F1 CD 78 03 F5 FD ";
            S = S + "E1 E5 C5 4F 06 00 7D A4 B2 21 C5 FC 09 77 E5 08 ";
            S = S + "D9 CD 17 02 D9 08 E1 C1 D1 ED 57 F5 78 E6 3F B1 ";
            S = S + "F3 D3 A8 7B 32 FF FF 78 D3 A8 73 F1 E2 30 03 FB ";
            S = S + "08 D9 C9 CD 53 03 FA 40 03 DB A8 A1 B0 D3 A8 C9 ";
            S = S + "E5 CD 78 03 4F 06 00 7D A4 B2 21 C5 FC 09 77 E1 ";
            S = S + "79 18 E0 F3 F5 7C 07 07 E6 03 5F 3E C0 07 07 1D ";
            S = S + "F2 5D 03 5F 2F 4F F1 F5 E6 03 3C 47 3E AB C6 55 ";
            S = S + "10 FC 57 A3 47 F1 A7 C9 F5 7A E6 C0 4F F1 F5 57 ";
            S = S + "DB A8 47 E6 3F B1 D3 A8 7A 0F 0F E6 03 57 3E AB ";
            S = S + "C6 55 15 F2 90 03 A3 57 7B 2F 67 3A FF FF 2F 6F ";
            S = S + "A4 B2 32 FF FF 78 D3 A8 F1 E6 03 C9 F3 0E 00 11 ";
            S = S + "C1 FC 21 C9 FC 1A B1 4F D5 E5 21 00 00 CD 1A 7E ";
            S = S + "E5 21 43 44 E7 E1 06 00 20 25 CD 1A 7E E5 C5 D5 ";
            S = S + "DD E1 79 F5 FD E1 C4 17 02 C1 E1 CD 1A 7E C6 FF ";
            S = S + "CB 18 CD 1A 7E C6 FF CB 18 CB 38 11 F8 FF 19 E3 ";
            S = S + "70 E3 E1 23 23 23 23 79 A7 11 0C 00 F2 0A 04 C6 ";
            S = S + "04 4F FE 90 38 B3 E6 03 4F 3E 19 D1 13 0C 79 FE ";
            S = S + "04 38 A2 C3 75 7D AF D3 FF 3C D3 FE 3C D3 FD 3C ";
            S = S + "D3 FC 3E 08 D3 BB 3E 82 D3 AB AF D3 A8 C3 D2 7B ";
            S = S + "00 11 FF FF AF 4F D3 A8 CB 21 06 00 21 FF FF 36 ";
            S = S + "F0 7E D6 0F 20 0B 77 7E 3C 20 06 04 CB C1 32 FF ";
            S = S + "FF 21 00 BF 7E 2F 77 BE 2F 77 20 07 2C 20 F5 25 ";
            S = S + "FA 54 04 2E 00 24 7D 93 7C 9A 30 0A EB 3A FF FF ";
            S = S + "2F 6F DB A8 67 F9 78 A7 28 0A 3A FF FF 2F C6 10 ";
            S = S + "FE 40 38 CA DB A8 C6 50 30 AC 21 00 00 39 7C D3 ";
            S = S + "A8 7D 32 FF FF 79 07 07 07 07 4F 11 FF FF DB A8 ";
            S = S + "E6 3F D3 A8 06 00 CB 01 30 0A 04 3A FF FF 2F E6 ";
            S = S + "3F 32 FF FF 21 00 FE 7E 2F 77 BE 2F 77 20 09 2C ";
            S = S + "20 F5 25 7C FE C0 30 EF 2E 00 24 7D 93 7C 9A 30 ";
            S = S + "0A EB 3A FF FF 2F 6F DB A8 67 F9 78 A7 28 08 3A ";
            S = S + "FF FF 2F C6 40 30 CA DB A8 C6 40 30 B5 C3 61 7B ";
            S = S + "3A B1 FB A7 C0 E5 21 9B FC F3 7E FB 36 00 E1 A7 ";
            S = S + "C8 FE 03 28 1C E5 D5 C5 CD 37 0A 21 9B FC F3 7E ";
            S = S + "FB 36 00 A7 28 F8 F5 CD 84 0A F1 C1 D1 E1 FE 03 ";
            S = S + "C0 E5 CD 5D 05 CD 49 05 30 0A 21 6A FC F3 CD F1 ";
            S = S + "0E FB E1 C9 CD 9E 08 3A C1 FC 26 40 CD 33 03 E1 ";
            S = S + "AF ED 7B B1 F6 C5 C3 E6 63 3A 6A FC 0F D0 2A 6B ";
            S = S + "FC 7C B5 C8 2A 1C F4 23 7C B5 C8 37 C9 2A F8 F3 ";
            S = S + "22 FA F3 C9 DB AA E6 F0 F6 07 D3 AA DB A9 E6 10 ";
            S = S + "C0 DB AA 3D D3 AA DB A9 E6 02 C0 E5 2A F8 F3 22 ";
            S = S + "FA F3 E1 3A E1 FB E6 EF 32 E1 FB 3E 14 32 F7 F3 ";
            S = S + "37 C9 3E 07 1E 80 CD 02 11 3E 0F 1E CF CD 02 11 ";
            S = S + "3E 0B 5F CD 02 11 CD 0C 11 E6 40 32 AD FC 3E FF ";
            S = S + "D3 90 E5 D5 C5 F5 21 3F FB 06 71 AF 77 23 10 FC ";
            S = S + "11 75 F9 06 7F 21 80 00 E5 D5 C5 F5 CD D8 14 F1 ";
            S = S + "C6 08 1E 00 CD 02 11 D6 08 F5 2E 0F CD 11 0C EB ";
            S = S + "21 FD 05 01 06 00 ED B0 F1 C1 E1 D1 19 EB 3C FE ";
            S = S + "03 38 D5 3E 07 1E B8 CD 02 11 C3 37 09 04 04 78 ";
            S = S + "88 FF 00 3A E0 F3 F6 40 18 05 3A E0 F3 E6 BF 47 ";
            S = S + "0E 01 79 A7 20 07 3A DF F3 A8 0F 30 0C FE 08 38 ";
            S = S + "08 DD E5 DD 21 2D 01 18 1B 78 F3 D3 99 79 F6 80 ";
            S = S + "FB D3 99 E5 78 06 00 21 DF F3 09 77 E1 C9 DD E5 ";
            S = S + "DD 21 D5 00 C3 95 02 DD E5 DD 21 D9 00 18 F5 DD ";
            S = S + "E5 DD 21 DD 00 18 ED DD E5 DD 21 E1 00 18 E5 DD ";
            S = S + "E5 DD 21 E5 00 18 DD DD E5 DD 21 E9 00 18 D5 DD ";
            S = S + "E5 DD 21 ED 00 18 CD DD E5 DD 21 F1 00 18 C5 DD ";
            S = S + "E5 DD 21 F5 00 18 BD EB 79 B7 78 41 C8 3C C9 EB ";
            S = S + "3A AF FC D6 05 38 0F E6 02 7C 20 01 1F 1F 67 3E ";
            S = S + "00 6F 8F 19 57 C9 16 00 C9 C5 47 3A AF FC FE 05 ";
            S = S + "78 C1 C9 C5 D5 E5 3A F6 FA A7 57 C4 8F 06 7C E6 ";
            S = S + "3F F6 40 18 0E C5 D5 E5 3A F6 FA A7 57 C4 8F 06 ";
            S = S + "7C E6 3F F5 7C E6 C0 B2 07 07 F3 D3 99 3E 8E D3 ";
            S = S + "99 7D D3 99 F1 FB D3 99 E1 D1 C1 C9 6F 26 00 29 ";
            S = S + "29 29 CD 0C 07 FE 08 28 02 29 29 EB 2A 26 F9 19 ";
            S = S + "C9 6F 26 00 29 29 EB 2A 28 F9 19 C9 3A E0 F3 0F ";
            S = S + "0F 3E 08 D0 3E 20 C9 CD C7 FD 2A 24 F9 CD F4 07 ";
            S = S + "3A 1F F9 2A 20 F9 01 00 08 F5 F1 F5 C5 F3 CD F5 ";
            S = S + "01 FB C1 D3 98 23 0B 79 B0 20 EF F1 C9 3A AF FC ";
            S = S + "FE 04 30 16 3A FC FA E6 08 20 0F CD 08 08 E3 E3 ";
            S = S + "DB 98 12 13 0B 79 B0 20 F7 C9 CD C5 06 CD 87 06 ";
            S = S + "0E 98 ED B2 3D 20 FB EB C9 F5 CD B3 06 E3 E3 F1 ";
            S = S + "D3 98 C9 00 00 00 00 DD E5 DD 21 15 01 C3 95 02 ";
            S = S + "EB 3A AF FC FE 04 30 14 3A FC FA E6 08 20 0D CD ";
            S = S + "F4 07 1A D3 98 13 0B 79 B0 20 F7 C9 CD B3 06 CD ";
            S = S + "87 06 0E 98 ED B3 3D 20 FB EB C9 26 00 6F 29 29 ";
            S = S + "29 EB 2A 20 F9 19 11 40 FC 06 08 E5 D5 C5 3A 1F ";
            S = S + "F9 CD F5 01 FB C1 D1 E1 12 13 23 10 EE C9 DD E5 ";
            S = S + "DD 21 19 01 C3 95 02 F5 CD F4 07 E3 E3 F1 D3 98 ";
            S = S + "C9 CD 08 08 E3 E3 DB 98 C9 CD C5 06 E3 E3 DB 98 ";
            S = S + "C9 CD 98 0B AF F3 D3 99 3E 8E D3 99 7D D3 99 7C ";
            S = S + "E6 3F F6 40 D3 99 FB C9 AF F3 D3 99 3E 8E D3 99 ";
            S = S + "7D D3 99 7C E6 3F D3 99 FB C9 3A AF FC 3D FA 81 ";
            S = S + "08 F5 CD 8E 08 F1 C0 3A E9 F3 87 87 87 87 21 EA ";
            S = S + "F3 B6 2A BF F3 01 20 00 F5 18 06 F5 CD A9 06 38 ";
            S = S + "12 CD B3 06 79 B7 28 01 04 F1 D3 98 0D C2 4A 08 ";
            S = S + "10 F8 C9 F1 E5 D5 5F 7C E6 3F 67 E5 09 2B 7C FE ";
            S = S + "40 E1 38 16 C5 AF 95 4F 3E 40 9C 47 7B CD 38 08 ";
            S = S + "C1 09 4D 7C D6 40 47 21 00 00 7B CD 38 08 D1 E1 ";
            S = S + "C9 3A E9 F3 87 87 87 87 21 EA F3 B6 18 03 3A EB ";
            S = S + "F3 47 0E 07 C3 12 06 C0 E5 CD 77 07 E1 C9 CD 4E ";
            S = S + "0B D8 3A B0 FC CD BD FD DD E5 DD 21 B5 01 C3 95 ";
            S = S + "02 DD E5 DD 21 D1 00 C3 95 02 CD B6 FF F5 CD 64 ";
            S = S + "05 38 12 CD E1 08 28 F6 F1 F5 D3 91 AF D3 90 3D ";
            S = S + "D3 90 F1 A7 C9 AF 32 15 F4 3E 0D CD C9 08 F1 37 ";
            S = S + "C9 CD BB FF DB 90 0F 0F 3F 9F C9 3E 1B DF 3E 59 ";
            S = S + "DF 7D C6 1F DF 7C C6 1F DF C9 E5 F5 21 A6 FC AF ";
            S = S + "BE 77 28 0D F1 D6 40 FE 20 38 04 C6 40 BF 37 E1 ";
            S = S + "C9 F1 FE 01 20 F7 77 E1 C9 E5 D5 C5 F5 CD A4 FD ";
            S = S + "CD 4E 0B 30 12 CD 8B 0A F1 F5 CD 3C 09 CD 3E 0A ";
            S = S + "3A DD F3 3D 32 61 F6 F1 C1 D1 E1 C9 CD FA 08 D0 ";
            S = S + "4F 20 0D 21 A7 FC 7E A7 C2 EC 09 79 FE 20 38 21 ";
            S = S + "2A DC F3 FE 7F CA FA 0A CD 8D 0B CD A1 0A C0 AF ";
            S = S + "CD DB 0B 26 01 CD BE 0A C0 CD C6 0A 2E 01 C3 E5 ";
            S = S + "0A 21 8A 09 0E 0C 23 23 A7 0D F8 BE 23 20 F7 4E ";
            S = S + "23 46 2A DC F3 CD 8A 09 AF C9 C5 C9 07 13 11 08 ";
            S = S + "A9 0A 09 CE 0A 0A 65 09 0B DC 0A 0C CE 07 0D DE ";
            S = S + "0A 1B E6 09 1C B8 0A 1D A9 0A 1E B4 0A 1F BE 0A ";
            S = S + "6A CE 07 45 CE 07 4B 05 0B 4A 19 0B 6C 03 0B 4C ";
            S = S + "EE 0A 4D E2 0A 59 E3 09 41 B4 0A 42 BE 0A 43 A1 ";
            S = S + "0A 44 B2 0A 48 DC 0A 78 DD 09 79 E0 09 3E 01 01 ";
            S = S + "3E 02 01 3E 04 01 3E FF 32 A7 FC C9 F2 FA 09 36 ";
            S = S + "00 79 21 AE 09 0E 0F C3 76 09 3D 28 1E 3D 28 25 ";
            S = S + "3D 77 3A B0 F3 11 DD F3 28 06 36 03 CD E2 0B 1B ";
            S = S + "47 79 D6 20 B8 3C 12 D8 78 12 C9 77 79 D6 34 28 ";
            S = S + "0B 3D 28 0F C9 77 79 D6 34 20 05 3C 32 AA FC C9 ";
            S = S + "3D C0 3C 32 A9 FC C9 3A A9 FC A7 C0 18 05 3A A9 ";
            S = S + "FC A7 C8 CD A9 FD CD 4E 0B D0 2A DC F3 E5 CD 83 ";
            S = S + "0B 32 CC FB 6F 26 00 29 29 29 EB 2A 24 F9 E5 19 ";
            S = S + "CD 54 0B 21 1F FC 06 08 3A AA FC A7 28 02 06 03 ";
            S = S + "7E 2F 77 2B 10 FA E1 01 F8 07 09 CD 6B 0B E1 0E ";
            S = S + "FF C3 8D 0B 3A A9 FC A7 C0 18 05 3A A9 FC A7 C8 ";
            S = S + "CD AE FD CD 4E 0B D0 2A DC F3 3A CC FB 4F C3 8D ";
            S = S + "0B 3A B0 F3 BC C8 24 18 1D CD B2 0A C0 3A B0 F3 ";
            S = S + "67 11 25 3E 2D C8 18 0E CD A1 0A C0 26 01 CD E2 ";
            S = S + "0B BD C8 38 05 2C 22 DC F3 C9 2D AF 18 F8 3E 20 ";
            S = S + "CD 3C 09 3A DD F3 3D E6 07 20 F3 C9 2E 01 26 01 ";
            S = S + "18 E4 CD DE 0A DD E5 DD 21 21 01 C3 95 02 CD DE ";
            S = S + "0A DD E5 DD 21 25 01 C3 95 02 CD A9 0A C8 0E 20 ";
            S = S + "C3 8D 0B 26 01 CD D9 0B E5 CD F1 07 E1 3E 20 D3 ";
            S = S + "98 24 3A B0 F3 BC 30 F5 C9 E5 CD 05 0B E1 CD E2 ";
            S = S + "0B BD D8 C8 26 01 2C 18 F0 CD B8 FD AF CD 4B 0B ";
            S = S + "D0 E5 2A B1 F3 CD 03 0B E1 C9 3A DE F3 A7 C8 CD ";
            S = S + "B3 FD DD E5 DD 21 1D 01 C3 95 02 32 DE F3 3A AF ";
            S = S + "FC FE 02 C9 E5 0E 08 18 08 E5 CD 96 0B 3A B0 F3 ";
            S = S + "4F 06 00 11 18 FC CD 3D 07 E1 C9 E5 0E 08 18 08 ";
            S = S + "E5 CD 96 0B 3A B0 F3 4F 06 00 EB 21 18 FC CD 80 ";
            S = S + "07 E1 C9 E5 CD 98 0B CD E1 07 4F E1 C9 E5 CD F1 ";
            S = S + "07 79 D3 98 E1 C9 26 01 C5 25 2D 5C 26 00 54 29 ";
            S = S + "29 29 4D 44 29 29 3A AF FC A7 3A B0 F3 28 04 DE ";
            S = S + "22 18 0D FE 29 38 06 09 29 DE 52 18 03 09 DE 2A ";
            S = S + "19 2F A7 1F 5F 19 EB 2A 22 F9 19 C1 C9 E5 11 B1 ";
            S = S + "FB 26 00 19 7E EB E1 A7 C9 3E AF F5 CD CD 0B F1 ";
            S = S + "12 C9 3A DE F3 E5 21 B1 F3 86 E1 C9 4F F3 DB AA ";
            S = S + "E6 F0 81 D3 AA FB DB A9 C9 CD DF FE E5 2A 64 F8 ";
            S = S + "7D B4 E1 C9 7C 92 C0 7D 93 C9 2E 02 18 03 3A 38 ";
            S = S + "FB D5 11 41 FB 26 00 19 B7 28 07 11 25 00 19 3D ";
            S = S + "20 FC D1 C9 00 3A EB FB 0F 38 09 AF 32 F9 FA 3C ";
            S = S + "CB C6 18 05 3E FF 32 AC FC C3 29 0F E5 D5 C5 F5 ";
            S = S + "D9 08 E5 D5 C5 F5 FD E5 DD E5 CD 9A FD CD 79 14 ";
            S = S + "F2 02 0D CD 9F FD FB 32 E7 F3 E6 20 21 6D FC C4 ";
            S = S + "F1 0E 2A A2 FC 2B 7C B5 20 09 21 7F FC CD F1 0E ";
            S = S + "2A A0 FC 22 A2 FC 2A 9E FC 23 22 9E FC 3A 3F FB ";
            S = S + "4F AF CB 19 F5 C5 DC 31 11 C1 F1 3C FE 03 38 F2 ";
            S = S + "21 F6 F3 35 20 6C 36 01 AF CD 02 12 E6 30 F5 3E ";
            S = S + "01 CD 02 12 E6 30 07 07 C1 B0 F5 CD 1C 12 E6 01 ";
            S = S + "C1 B0 4F 21 E8 F3 AE A6 71 4F 0F 21 70 FC DC F1 ";
            S = S + "0E CB 11 21 7C FC DC F1 0E CB 11 21 76 FC DC F1 ";
            S = S + "0E CB 11 21 79 FC DC F1 0E CB 11 21 73 FC DC F1 ";
            S = S + "0E AF 32 D9 FB CD 12 0D 20 18 21 F7 F3 35 20 12 ";
            S = S + "36 02 21 DA FB 11 DB FB 01 0A 00 36 FF ED B0 CD ";
            S = S + "4E 0D DD E1 FD E1 F1 C1 D1 E1 08 D9 F1 C1 D1 E1 ";
            S = S + "FB C9 DB AA E6 F0 4F 06 0B 21 E5 FB 79 D3 AA DB ";
            S = S + "A9 77 0C 23 10 F6 3A B0 FB A7 28 0E 3A EB FB FE ";
            S = S + "E8 20 07 DD 21 9B 40 C3 BF 02 11 E5 FB 06 0B 1B ";
            S = S + "2B 1A BE 20 04 10 F8 18 05 3E 20 32 F7 F3 06 0B ";
            S = S + "21 DA FB 11 E5 FB 1A 4F AE A6 71 C4 89 0D 13 23 ";
            S = S + "10 F4 2A FA F3 3A F8 F3 95 C9 FB E5 D5 C5 CD 4E ";
            S = S + "0B 30 0F 3A CD FB 21 EB FB AE 21 DE F3 A6 0F DC ";
            S = S + "3F 0B CD 62 0D C1 D1 E1 C9 E5 D5 C5 F5 3E 0B 90 ";
            S = S + "87 87 87 4F 06 08 F1 1F C5 F5 DC 21 10 F1 C1 0C ";
            S = S + "10 F5 C3 38 09 30 31 32 33 34 35 36 37 38 39 2D ";
            S = S + "3D 5C 5B 5D 3B 27 60 2C 2E 2F FF 61 62 63 64 65 ";
            S = S + "66 67 68 69 6A 6B 6C 6D 6E 6F 70 71 72 73 74 75 ";
            S = S + "76 77 78 79 7A 29 21 40 23 24 25 5E 26 2A 28 5F ";
            S = S + "2B 7C 7B 7D 3A 22 7E 3C 3E 3F FF 41 42 43 44 45 ";
            S = S + "46 47 48 49 4A 4B 4C 4D 4E 4F 50 51 52 53 54 55 ";
            S = S + "56 57 58 59 5A 09 AC AB BA EF BD F4 FB EC 07 17 ";
            S = S + "F1 1E 01 0D 06 05 BB F3 F2 1D FF C4 11 BC C7 CD ";
            S = S + "14 15 13 DC C6 DD C8 0B 1B C2 DB CC 18 D2 12 C0 ";
            S = S + "1A CF 1C 19 0F 0A 00 FD FC 00 00 F5 00 00 08 1F ";
            S = S + "F0 16 02 0E 04 03 F7 AE AF F6 FF FE 00 FA C1 CE ";
            S = S + "D4 10 D6 DF CA DE C9 0C D3 C3 D7 CB A9 D1 00 C5 ";
            S = S + "D5 D0 F9 AA F8 EB 9F D9 BF 9B 98 E0 E1 E7 87 EE ";
            S = S + "E9 00 ED DA B7 B9 E5 86 A6 A7 FF 84 97 8D 8B 8C ";
            S = S + "94 81 B1 A1 91 B3 B5 E6 A4 A2 A3 83 93 89 96 82 ";
            S = S + "95 88 8A A0 85 D8 AD 9E BE 9C 9D 00 00 E2 80 00 ";
            S = S + "00 00 E8 EA B6 B8 E4 8F 00 A8 FF 8E 00 00 00 00 ";
            S = S + "99 9A B0 00 92 B2 B4 00 A5 00 E3 00 00 00 00 90 ";
            S = S + "00 00 00 00 00 59 16 00 21 99 FB 19 7E A7 20 13 ";
            S = S + "EB 29 29 29 29 11 2F F5 19 EB 1A A7 C8 CD 55 0F ";
            S = S + "13 18 F7 2A 1C F4 23 7C B5 28 E5 21 AD FB 19 19 ";
            S = S + "19 7E E6 01 C8 7E F6 04 BE C8 77 EE 05 C0 3A D8 ";
            S = S + "FB 3C 32 D8 FB C9 3A EB FB 0F 3E 0C DE 00 18 45 ";
            S = S + "CD D1 FD 5F 16 00 21 03 10 19 7E A7 C8 18 36 3A ";
            S = S + "EB FB 5F F6 FE CB 63 20 02 E6 FD 2F 3C 32 AC FC ";
            S = S + "18 32 0C C3 25 0C 21 AB FC 7E 2F 77 2F A7 3E 0C ";
            S = S + "28 01 3C D3 AB C9 3A EB FB 0F 0F 3E 03 30 01 3C ";
            S = S + "32 9B FC 38 0F 2A F8 F3 77 CD 5B 10 3A FA F3 BD ";
            S = S + "C8 22 F8 F3 3A DB F3 A7 C8 3A D9 FB A7 C0 3E 0F ";
            S = S + "32 D9 FB D3 AB 3E 0A 3D 20 FD A7 3E 0E 28 01 3C ";
            S = S + "D3 AB C9 3A EB FB 5F 1F 1F F5 7B 2F 30 10 1F 1F ";
            S = S + "07 E6 03 CB 4F 20 09 CB 63 20 05 F6 04 11 E6 01 ";
            S = S + "5F 87 83 87 87 87 87 5F 16 00 21 A5 0D 19 42 09 ";
            S = S + "F1 7E 3C CA 1F 0F 3D C8 38 16 E6 DF D6 40 FE 20 ";
            S = S + "D0 18 92 3A EB FB 0F 38 04 79 C6 05 4F C3 C5 0E ";
            S = S + "FE 20 30 0B F5 3E 01 CD 55 0F F1 C6 40 18 E2 21 ";
            S = S + "AB FC 34 35 28 0A FE 61 38 27 FE 7B 30 23 E6 DF ";
            S = S + "ED 5B AC FC 1C 1D 28 C9 57 F6 20 21 66 10 0E 06 ";
            S = S + "ED B9 7A 20 BC 23 0E 06 09 1D 20 FC 7E CB 6A 20 ";
            S = S + "B0 0E 1F 21 9D 10 ED B9 20 A7 0E 1F 23 09 7E 18 ";
            S = S + "A0 79 21 96 1B CD CC FD 16 0F BE 23 5E 23 D5 D8 ";
            S = S + "D1 18 F7 00 00 00 00 00 00 00 00 00 00 1B 09 00 ";
            S = S + "08 18 0D 20 0C 12 7F 1D 1E 1F 1C 2A 2B 2F 30 31 ";
            S = S + "32 33 34 35 36 37 38 39 2D 2C 2E AF 32 AC FC 18 ";
            S = S + "61 61 65 69 6F 75 79 85 8A 8D 95 97 79 A0 82 A1 ";
            S = S + "A2 A3 79 83 88 8C 93 96 79 84 89 8B 94 81 98 83 ";
            S = S + "88 8C 93 96 84 89 8B 94 81 98 A0 82 A1 A2 A3 85 ";
            S = S + "8A 8D 95 97 B1 B3 B5 B7 A4 86 87 91 B9 79 41 45 ";
            S = S + "49 4F 55 8E 45 49 99 9A 59 41 90 49 4F 55 41 45 ";
            S = S + "49 4F 55 B0 B2 B4 B6 A5 8F 80 92 B8 59 51 00 5C ";
            S = S + "48 00 23 7D FE 18 C0 21 F0 FB C9 E5 D5 C5 CD C2 ";
            S = S + "FD CD 6A 0D 20 0B CD 37 0A CD 6A 0D 28 FB CD 84 ";
            S = S + "0A 21 9B FC 7E FE 04 20 02 36 00 2A FA F3 4E CD ";
            S = S + "C2 10 22 FA F3 79 C3 38 09 E5 21 00 00 CD F0 04 ";
            S = S + "E1 C9 F3 D3 A0 F5 7B FB D3 A1 F1 C9 3E 0E D3 A0 ";
            S = S + "DB A2 C9 DD E5 DD 21 7D 01 C3 95 02 F5 3E 0F D3 ";
            S = S + "A0 DB A2 E6 7F 47 F1 B7 3E 80 28 01 AF B0 D3 A1 ";
            S = S + "C9 47 CD 0A 0C 2B 56 2B 5E 1B 73 23 72 7A B3 C0 ";
            S = S + "78 32 3E FB CD D8 11 FE FF 28 5B 57 E6 E0 07 07 ";
            S = S + "07 4F 7A E6 1F 77 CD D8 11 2B 77 0C 0D C8 CD D8 ";
            S = S + "11 57 E6 C0 20 11 CD D8 11 5F 78 07 CD 02 11 3C ";
            S = S + "5A CD 02 11 0D 18 E5 67 E6 80 28 0F 5A 78 C6 08 ";
            S = S + "CD 02 11 7B E6 10 3E 0D C4 02 11 7C E6 40 28 CC ";
            S = S + "CD D8 11 57 CD D8 11 5F 3E 0B CD 02 11 3C 5A CD ";
            S = S + "02 11 0D 0D 18 B6 78 C6 08 1E 00 CD 02 11 04 21 ";
            S = S + "3F FB AF 37 17 10 FD A6 AE 77 3A 3F FB B7 C0 21 ";
            S = S + "40 FB 7E B7 C8 35 21 01 00 22 41 FB 22 66 FB 22 ";
            S = S + "8B FB 3E 07 32 3F FB C9 3A 3E FB E5 D5 C5 CD AB ";
            S = S + "14 C3 38 09 3D FA F6 11 CD 02 12 21 29 12 E6 0F ";
            S = S + "5F 16 00 19 7E C9 CD 1C 12 0F 0F 0F 0F 21 39 12 ";
            S = S + "18 EC 47 3E 0F F3 CD 0E 11 10 06 E6 DF F6 4C 18 ";
            S = S + "04 E6 AF F6 03 D3 A1 CD 0C 11 FB C9 F3 DB AA E6 ";
            S = S + "F0 C6 08 D3 AA DB A9 FB C9 00 05 01 00 03 04 02 ";
            S = S + "03 07 06 08 07 00 05 01 00 00 03 05 04 01 02 00 ";
            S = S + "03 07 00 06 05 08 01 07 00 3D FA 62 12 F5 E6 01 ";
            S = S + "CD 02 12 C1 05 05 06 10 FA 5D 12 06 20 A0 D6 01 ";
            S = S + "9F C9 CD 1C 12 E6 01 18 F5 3C A7 1F F5 47 AF 37 ";
            S = S + "17 10 FD 47 F1 0E 10 11 AF 03 30 05 0E 20 11 9F ";
            S = S + "4C 3E 0F F3 CD 0E 11 A3 B2 B1 D3 A1 A9 D3 A1 3E ";
            S = S + "0E D3 A0 0E 00 DB A2 A0 28 05 0C C2 95 12 0D FB ";
            S = S + "79 C9 FE 08 38 09 DD E5 DD 21 AD 01 C3 95 02 FE ";
            S = S + "04 11 EC 0C 38 05 11 D3 03 D6 04 3D FA C8 12 3D ";
            S = S + "3A 9D FC F8 3A 9C FC C8 F5 EB 22 66 F8 9F 2F E6 ";
            S = S + "40 4F 3E 0F F3 CD 0E 11 E6 BF B1 D3 A1 F1 FA EB ";
            S = S + "12 CD 0C 11 FB E6 08 D6 01 9F C9 0E 00 CD 35 13 ";
            S = S + "CD 35 13 38 28 CD 23 13 38 23 D5 CD 23 13 C1 38 ";
            S = S + "1C 78 92 30 02 2F 3C FE 05 30 E0 79 93 30 02 2F ";
            S = S + "3C FE 05 30 D6 7A 32 9D FC 7B 32 9C FC FB 7C D6 ";
            S = S + "01 9F C9 0E 0A CD 35 13 D8 55 D5 0E 00 CD 35 13 ";
            S = S + "D1 5D AF 67 C9 CD 5E 13 06 08 51 CB 82 CB 92 CD ";
            S = S + "70 13 CD 0C 11 67 1F 1F 1F CB 15 CB C2 CB D2 CD ";
            S = S + "70 13 10 E7 CB E2 CB EA CD 70 13 7C 1F C9 3E 35 ";
            S = S + "B1 57 CD 70 13 CD 0C 11 E6 02 28 F9 CB A2 CB AA ";
            S = S + "E5 D5 2A 66 F8 7D 2F A2 57 3E 0F D3 A0 DB A2 A5 ";
            S = S + "B2 B4 D3 A1 D1 E1 C9 A7 FA 95 13 20 03 3E 09 C2 ";
            S = S + "3E 08 D3 AB C9 DB AA E6 10 18 F0 CD D6 FD ED 45 ";
            S = S + "21 7F F8 06 9F E5 AF 77 23 10 FC E1 06 0A 11 C3 ";
            S = S + "13 0E 10 1A 13 77 23 0D B7 20 F8 C5 06 00 09 C1 ";
            S = S + "10 EF C9 63 6F 6C 6F 72 20 00 61 75 74 6F 20 00 ";
            S = S + "67 6F 74 6F 20 00 6C 69 73 74 20 00 72 75 6E 0D ";
            S = S + "00 63 6F 6C 6F 72 20 31 35 2C 34 2C 34 0D 00 63 ";
            S = S + "6C 6F 61 64 22 00 63 6F 6E 74 0D 00 6C 69 73 74 ";
            S = S + "2E 0D 1E 1E 00 0C 72 75 6E 0D 00 DB 99 C9 DB A8 ";
            S = S + "C9 D3 A8 C9 CD A7 FF C9 CD AC FF C9 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 DB BA E6 10 20 0D 21 ";
            S = S + "FF FA CB FE 3E 20 D3 BB F6 08 D3 BB DB 99 A7 C9 ";
            S = S + "CD F8 14 78 3C 23 A6 B9 C8 E5 2B 2B 2B E3 23 4F ";
            S = S + "7E 23 66 6F 06 00 09 73 E1 71 C9 CD F8 14 36 00 ";
            S = S + "20 1D 79 B8 C8 23 3C A6 2B 2B E5 23 23 23 4F 7E ";
            S = S + "23 66 6F 06 00 09 7E E1 71 B7 C0 3C 3E 00 C9 4F ";
            S = S + "06 00 21 70 F9 09 7E C9 C5 CD 02 15 70 23 70 23 ";
            S = S + "70 23 F1 77 23 73 23 72 C9 CD F8 14 78 3C 23 A6 ";
            S = S + "47 79 90 A6 6F 26 00 C9 CD 02 15 46 23 4E 23 7E ";
            S = S + "B7 C9 07 47 07 80 4F 06 00 2A F3 F3 09 C9 CD A9 ";
            S = S + "06 38 09 DD E5 DD 21 89 00 C3 95 02 E5 D5 C5 F5 ";
            S = S + "CD FA 08 30 62 20 08 FE 0D 28 5F FE 20 38 58 CD ";
            S = S + "AB 07 3A E9 F3 32 F2 F3 2A B9 FC EB ED 4B B7 FC ";
            S = S + "CD A5 15 30 42 CD 04 16 11 40 FC 0E 08 06 08 CD ";
            S = S + "51 16 E5 F5 1A 87 F5 DC C3 16 CD 35 17 E1 38 04 ";
            S = S + "E5 F1 10 F1 F1 E1 CD 58 16 CD B4 17 38 04 13 0D ";
            S = S + "20 DB CD FB 15 3A B7 FC 28 06 C6 20 38 0C 18 04 ";
            S = S + "C6 08 38 06 32 B7 FC C3 37 09 AF 32 B7 FC CD FB ";
            S = S + "15 3A B9 FC 28 03 C6 20 01 C6 08 FE C0 38 01 AF ";
            S = S + "32 B9 FC 18 E2 E5 C5 06 01 EB 7C 87 30 05 21 00 ";
            S = S + "00 18 11 11 C0 00 3A AF FC FE 05 38 02 1E D4 E7 ";
            S = S + "38 04 EB 2B 06 00 E3 7C 87 30 05 21 00 00 18 13 ";
            S = S + "11 00 01 3A AF FC E6 07 FE 06 38 02 16 02 E7 38 ";
            S = S + "04 EB 2B 06 00 D1 3A AF FC FE 03 20 08 CB 3D CB ";
            S = S + "3D CB 3B CB 3B 78 0F 44 4D E1 C9 3A AF FC FE 04 ";
            S = S + "C8 FE 02 C9 3A AF FC FE 05 30 33 FE 03 28 39 C5 ";
            S = S + "51 79 E6 07 4F 21 36 16 09 7E 32 2C F9 7B 0F 0F ";
            S = S + "0F E6 1F 47 7A E6 F8 4F 7B E6 07 B1 4F 2A CB F3 ";
            S = S + "09 22 2A F9 C1 C9 80 40 20 10 08 04 02 01 60 69 ";
            S = S + "22 2A F9 7B 32 2C F9 C9 DD E5 DD 21 91 00 C3 95 ";
            S = S + "02 3A 2C F9 2A 2A F9 C9 32 2C F9 22 2A F9 C9 CD ";
            S = S + "A9 06 38 09 DD E5 DD 21 95 00 C3 95 02 CD FB 15 ";
            S = S + "20 F2 C5 E5 CD 51 16 47 CD E1 07 A0 F5 01 00 20 ";
            S = S + "09 CD E1 07 47 F1 78 28 04 0F 0F 0F 0F E6 0F E1 ";
            S = S + "C1 C9 CD 9A 16 D8 32 F2 F3 C9 F5 3A AF FC FE 06 ";
            S = S + "28 0C FE 08 28 05 F1 FE 10 3F C9 F1 A7 C9 F1 FE ";
            S = S + "20 3F D8 FE 10 38 03 E6 0F C9 E6 03 C5 47 87 87 ";
            S = S + "80 C1 C9 3A AF FC FE 05 30 1D FE 03 28 10 E5 C5 ";
            S = S + "D5 3A 2C F9 2A 2A F9 CD A6 18 D1 C1 E1 C9 DD E5 ";
            S = S + "DD 21 9D 00 C3 95 02 2A 2A F9 3A 2C F9 F5 F3 3E ";
            S = S + "02 D3 99 3E 8F D3 99 E5 E1 DB 99 F5 AF D3 99 3E ";
            S = S + "8F D3 99 F1 FB 0F 38 E6 F3 3E 24 D3 99 3E 91 D3 ";
            S = S + "99 7D D3 9B 7C D3 9B F1 D3 9B 3A F6 FA D3 9B 3E ";
            S = S + "2C D3 99 3E 91 D3 99 3A F2 F3 D3 9B AF D3 9B 3E ";
            S = S + "50 D3 9B FB C9 CD FB 15 28 09 DD E5 DD 21 A1 00 ";
            S = S + "C3 95 02 E5 CD 51 16 0F 30 64 7D E6 F8 FE F8 3E ";
            S = S + "80 20 18 C3 1C 18 CD FB 15 28 09 DD E5 DD 21 A5 ";
            S = S + "00 C3 95 02 E5 CD 51 16 0F 30 43 D5 11 08 00 18 ";
            S = S + "38 CD FB 15 28 09 DD E5 DD 21 A9 00 C3 95 02 E5 ";
            S = S + "CD 51 16 07 30 28 7D E6 F8 3E 01 20 18 C3 1C 18 ";
            S = S + "CD FB 15 28 09 DD E5 DD 21 AD 00 C3 95 02 E5 CD ";
            S = S + "51 16 07 30 09 D5 11 F8 FF 19 22 2A F9 D1 32 2C ";
            S = S + "F9 A7 E1 C9 CD FB 15 28 09 DD E5 DD 21 B1 00 C3 ";
            S = S + "95 02 E5 D5 2A 2A F9 E5 2A CB F3 11 00 17 19 EB ";
            S = S + "E1 E7 38 1B 7D 3C E6 07 20 15 18 3F CD FB 15 28 ";
            S = S + "09 DD E5 DD 21 B5 00 C3 95 02 E5 D5 2A 2A F9 23 ";
            S = S + "7D 11 F8 00 18 41 CD FB 15 28 09 DD E5 DD 21 B9 ";
            S = S + "00 C3 95 02 E5 D5 2A 2A F9 E5 2A CB F3 11 00 01 ";
            S = S + "19 EB E1 E7 30 1C 7D E6 07 20 17 D1 37 E1 C9 CD ";
            S = S + "FB 15 28 09 DD E5 DD 21 BD 00 C3 95 02 E5 D5 2A ";
            S = S + "2A F9 7D 2B 11 08 FF E6 07 20 01 19 22 2A F9 A7 ";
            S = S + "D1 E1 C9 CD FB 15 C2 F5 18 E5 CD 51 16 E3 87 38 ";
            S = S + "18 F5 01 FF FF 0F 09 30 45 0F 30 FA F1 3D E3 E5 ";
            S = S + "CD A6 18 E1 11 08 00 19 E3 7D E6 07 4F 7C 0F 7D ";
            S = S + "1F 0F 0F E6 3F E1 47 28 14 AF CD D7 07 11 00 20 ";
            S = S + "19 3A F2 F3 CD D7 07 11 08 20 19 10 EC 0D F8 E5 ";
            S = S + "21 97 18 09 7E 18 0E 80 C0 E0 F0 F8 FC FE 87 3D ";
            S = S + "2F 47 F1 3D A0 E1 47 CD E1 07 4F 11 00 20 19 CD ";
            S = S + "E1 07 F5 E6 0F 5F F1 93 57 3A F2 F3 BB 28 19 87 ";
            S = S + "87 87 87 BA 28 16 F5 78 B1 FE FF 28 17 E5 D5 CD ";
            S = S + "DC 18 D1 E1 F1 B3 18 1A 78 2F A1 11 78 B1 11 00 ";
            S = S + "20 19 18 0E F1 78 2F E5 D5 CD DE 18 D1 E1 3A F2 ";
            S = S + "F3 B2 C3 D7 07 E5 CD C3 16 CD 56 17 E1 2D 20 F5 ";
            S = S + "C9 2A 0B F4 EB 2A 0D F4 C9 F5 CD FB 15 28 06 F1 ";
            S = S + "FE 10 3F 18 05 F1 3A F2 F3 A7 32 B2 FC C9 21 00 ";
            S = S + "00 4D CD FB 15 28 09 DD E5 DD 21 C1 00 C3 95 02 ";
            S = S + "78 32 66 F8 AF 32 69 F8 3A B2 FC 47 CD 5F 16 B8 ";
            S = S + "20 0D 1B 7A B3 C8 CD 35 17 30 F1 11 00 00 C9 CD ";
            S = S + "D1 19 D5 CD 51 16 22 42 F9 32 44 F9 11 00 00 13 ";
            S = S + "CD 35 17 38 0B CD 5F 16 B8 28 05 CD D1 19 18 EF ";
            S = S + "D5 CD 51 16 E5 F5 2A 42 F9 3A 44 F9 CD 58 16 EB ";
            S = S + "22 67 F8 3A 66 F8 A7 C4 43 18 F1 E1 CD 58 16 E1 ";
            S = S + "D1 C3 CC 19 21 00 00 4D CD FB 15 28 09 DD E5 DD ";
            S = S + "21 C5 00 C3 95 02 AF 32 69 F8 3A B2 FC 47 CD 71 ";
            S = S + "17 38 0F CD 5F 16 B8 28 06 CD D1 19 23 18 EF CD ";
            S = S + "56 17 E5 ED 5B 67 F8 19 CD 43 18 E1 3A 69 F8 4F ";
            S = S + "C9 E5 21 F2 F3 BE E1 C8 3C 32 69 F8 C9 C5 F5 01 ";
            S = S + "00 00 0B 78 B1 20 FB F1 C1 F5 3E 09 D3 AB F1 FB ";
            S = S + "C9 B7 F5 3E 08 D3 AB 21 00 00 2B 7C B5 20 FB F1 ";
            S = S + "3A 0A F4 28 02 87 87 47 0E 00 F3 CD 4D 1A CD 3F ";
            S = S + "1A 0B 78 B1 20 F5 C3 64 05 2A 06 F4 F5 7D D6 0E ";
            S = S + "6F CD 50 1A F1 06 08 0F DC 40 1A D4 39 1A 10 F7 ";
            S = S + "CD 40 1A CD 40 1A C3 64 05 2A 06 F4 CD 50 1A C9 ";
            S = S + "CD 4D 1A E3 E3 00 00 00 00 CD 4D 1A C9 2A 08 F4 ";
            S = S + "F5 2D C2 51 1A 3E 0B D3 AB 25 C2 59 1A 3E 0A D3 ";
            S = S + "AB F1 C9 3E 08 D3 AB F3 3E 0E D3 A0 21 57 04 51 ";
            S = S + "CD 34 1B D8 79 FE DE 30 F3 FE 05 38 EF 92 30 02 ";
            S = S + "2F 3C FE 04 30 E6 2B 7C B5 20 E4 21 00 00 45 55 ";
            S = S + "CD 34 1B D8 09 15 C2 90 1A 01 AE 06 09 7C 1F E6 ";
            S = S + "7F 57 29 7C 92 57 D6 06 32 A4 FC 7A 87 06 00 D6 ";
            S = S + "03 04 30 FB 78 D6 03 32 A5 FC B7 C9 3A A4 FC 57 ";
            S = S + "CD 64 05 D8 DB A2 07 30 F7 CD 64 05 D8 DB A2 07 ";
            S = S + "38 F7 1E 00 CD 1F 1B 41 CD 1F 1B D8 78 81 DA D7 ";
            S = S + "1A BA 38 F3 2E 08 CD 03 1B FE 04 3F D8 FE 02 3F ";
            S = S + "CB 1A 79 0F D4 23 1B CD 1F 1B 2D C2 E6 1A CD 64 ";
            S = S + "05 7A C9 3A A5 FC 47 0E 00 DB A2 AB F2 17 1B 7B ";
            S = S + "2F 5F 0C 10 F4 79 C9 00 00 00 00 10 EC 79 C9 CD ";
            S = S + "64 05 D8 0E 00 0C 28 0A DB A2 AB F2 25 1B 7B 2F ";
            S = S + "5F C9 0D C9 CD 64 05 D8 DB A2 07 38 F7 1E 00 CD ";
            S = S + "23 1B C3 25 1B F5 CD E4 FE CD F9 0B 28 08 F1 DD ";
            S = S + "21 48 6C C3 BF 02 3A 16 F4 B7 28 5F 3A 18 F4 A7 ";
            S = S + "20 49 F1 F5 FE 09 20 0E 3E 20 CD 63 1B 3A 15 F4 ";
            S = S + "E6 07 20 F4 F1 C9 D6 0D 28 0A 38 0B FE 13 38 07 ";
            S = S + "3A 15 F4 3C 32 15 F4 3A 17 F4 A7 28 1E F1 CD FA ";
            S = S + "08 D0 20 23 18 16 30 83 33 10 34 36 35 10 3A C3 ";
            S = S + "3C 10 3D 46 41 10 42 06 FF 10 38 F1 CD BA 08 D0 ";
            S = S + "DD 21 B2 73 C3 BF 02 3E 20 18 F1 F1 C3 19 09 00 ";
            S = S + "00 00 00 00 00 00 00 3C 42 A5 81 A5 99 42 3C 3C ";
            S = S + "7E DB FF FF DB 66 3C 6C FE FE FE 7C 38 10 00 10 ";
            S = S + "38 7C FE 7C 38 10 00 10 38 54 FE 54 10 38 00 10 ";
            S = S + "38 7C FE FE 10 38 00 00 00 00 30 30 00 00 00 FF ";
            S = S + "FF FF E7 E7 FF FF FF 38 44 82 82 82 44 38 00 C7 ";
            S = S + "BB 7D 7D 7D BB C7 FF 0F 03 05 79 88 88 88 70 38 ";
            S = S + "44 44 44 38 10 7C 10 30 28 24 24 28 20 E0 C0 3C ";
            S = S + "24 3C 24 24 E4 DC 18 10 54 38 EE 38 54 10 00 10 ";
            S = S + "10 10 7C 10 10 10 10 10 10 10 FF 00 00 00 00 00 ";
            S = S + "00 00 FF 10 10 10 10 10 10 10 F0 10 10 10 10 10 ";
            S = S + "10 10 1F 10 10 10 10 10 10 10 FF 10 10 10 10 10 ";
            S = S + "10 10 10 10 10 10 10 00 00 00 FF 00 00 00 00 00 ";
            S = S + "00 00 1F 10 10 10 10 00 00 00 F0 10 10 10 10 10 ";
            S = S + "10 10 1F 00 00 00 00 10 10 10 F0 00 00 00 00 81 ";
            S = S + "42 24 18 18 24 42 81 01 02 04 08 10 20 40 80 80 ";
            S = S + "40 20 10 08 04 02 01 00 10 10 FF 10 10 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 20 20 20 20 00 00 20 00 50 ";
            S = S + "50 50 00 00 00 00 00 50 50 F8 50 F8 50 50 00 20 ";
            S = S + "78 A0 70 28 F0 20 00 C0 C8 10 20 40 98 18 00 40 ";
            S = S + "A0 40 A8 90 98 60 00 10 20 40 00 00 00 00 00 10 ";
            S = S + "20 40 40 40 20 10 00 40 20 10 10 10 20 40 00 20 ";
            S = S + "A8 70 20 70 A8 20 00 00 20 20 F8 20 20 00 00 00 ";
            S = S + "00 00 00 00 20 20 40 00 00 00 78 00 00 00 00 00 ";
            S = S + "00 00 00 00 60 60 00 00 00 08 10 20 40 80 00 70 ";
            S = S + "88 98 A8 C8 88 70 00 20 60 A0 20 20 20 F8 00 70 ";
            S = S + "88 08 10 60 80 F8 00 70 88 08 30 08 88 70 00 10 ";
            S = S + "30 50 90 F8 10 10 00 F8 80 E0 10 08 10 E0 00 30 ";
            S = S + "40 80 F0 88 88 70 00 F8 88 10 20 20 20 20 00 70 ";
            S = S + "88 88 70 88 88 70 00 70 88 88 78 08 10 60 00 00 ";
            S = S + "00 20 00 00 20 00 00 00 00 20 00 00 20 20 40 18 ";
            S = S + "30 60 C0 60 30 18 00 00 00 F8 00 F8 00 00 00 C0 ";
            S = S + "60 30 18 30 60 C0 00 70 88 08 10 20 00 20 00 70 ";
            S = S + "88 08 68 A8 A8 70 00 20 50 88 88 F8 88 88 00 F0 ";
            S = S + "48 48 70 48 48 F0 00 30 48 80 80 80 48 30 00 E0 ";
            S = S + "50 48 48 48 50 E0 00 F8 80 80 F0 80 80 F8 00 F8 ";
            S = S + "80 80 F0 80 80 80 00 70 88 80 B8 88 88 70 00 88 ";
            S = S + "88 88 F8 88 88 88 00 70 20 20 20 20 20 70 00 38 ";
            S = S + "10 10 10 90 90 60 00 88 90 A0 C0 A0 90 88 00 80 ";
            S = S + "80 80 80 80 80 F8 00 88 D8 A8 A8 88 88 88 00 88 ";
            S = S + "C8 C8 A8 98 98 88 00 70 88 88 88 88 88 70 00 F0 ";
            S = S + "88 88 F0 80 80 80 00 70 88 88 88 A8 90 68 00 F0 ";
            S = S + "88 88 F0 A0 90 88 00 70 88 80 70 08 88 70 00 F8 ";
            S = S + "20 20 20 20 20 20 00 88 88 88 88 88 88 70 00 88 ";
            S = S + "88 88 88 50 50 20 00 88 88 88 A8 A8 D8 88 00 88 ";
            S = S + "88 50 20 50 88 88 00 88 88 88 70 20 20 20 00 F8 ";
            S = S + "08 10 20 40 80 F8 00 70 40 40 40 40 40 70 00 00 ";
            S = S + "00 80 40 20 10 08 00 70 10 10 10 10 10 70 00 20 ";
            S = S + "50 88 00 00 00 00 00 00 00 00 00 00 00 F8 00 40 ";
            S = S + "20 10 00 00 00 00 00 00 00 70 08 78 88 78 00 80 ";
            S = S + "80 B0 C8 88 C8 B0 00 00 00 70 88 80 88 70 00 08 ";
            S = S + "08 68 98 88 98 68 00 00 00 70 88 F8 80 70 00 10 ";
            S = S + "28 20 F8 20 20 20 00 00 00 68 98 98 68 08 70 80 ";
            S = S + "80 F0 88 88 88 88 00 20 00 60 20 20 20 70 00 10 ";
            S = S + "00 30 10 10 10 90 60 40 40 48 50 60 50 48 00 60 ";
            S = S + "20 20 20 20 20 70 00 00 00 D0 A8 A8 A8 A8 00 00 ";
            S = S + "00 B0 C8 88 88 88 00 00 00 70 88 88 88 70 00 00 ";
            S = S + "00 B0 C8 C8 B0 80 80 00 00 68 98 98 68 08 08 00 ";
            S = S + "00 B0 C8 80 80 80 00 00 00 78 80 F0 08 F0 00 40 ";
            S = S + "40 F0 40 40 48 30 00 00 00 90 90 90 90 68 00 00 ";
            S = S + "00 88 88 88 50 20 00 00 00 88 A8 A8 A8 50 00 00 ";
            S = S + "00 88 50 20 50 88 00 00 00 88 88 98 68 08 70 00 ";
            S = S + "00 F8 10 20 40 F8 00 18 20 20 40 20 20 18 00 20 ";
            S = S + "20 20 00 20 20 20 00 C0 20 20 10 20 20 C0 00 40 ";
            S = S + "A8 10 00 00 00 00 00 00 00 20 50 F8 00 00 00 70 ";
            S = S + "88 80 80 88 70 20 60 90 00 00 90 90 90 68 00 10 ";
            S = S + "20 70 88 F8 80 70 00 20 50 70 08 78 88 78 00 48 ";
            S = S + "00 70 08 78 88 78 00 20 10 70 08 78 88 78 00 20 ";
            S = S + "00 70 08 78 88 78 00 00 70 80 80 80 70 10 60 20 ";
            S = S + "50 70 88 F8 80 70 00 50 00 70 88 F8 80 70 00 20 ";
            S = S + "10 70 88 F8 80 70 00 50 00 00 60 20 20 70 00 20 ";
            S = S + "50 00 60 20 20 70 00 40 20 00 60 20 20 70 00 50 ";
            S = S + "00 20 50 88 F8 88 00 20 00 20 50 88 F8 88 00 10 ";
            S = S + "20 F8 80 F0 80 F8 00 00 00 6C 12 7E 90 6E 00 3E ";
            S = S + "50 90 9C F0 90 9E 00 60 90 00 60 90 90 60 00 90 ";
            S = S + "00 00 60 90 90 60 00 40 20 00 60 90 90 60 00 40 ";
            S = S + "A0 00 A0 A0 A0 50 00 40 20 00 A0 A0 A0 50 00 90 ";
            S = S + "00 90 90 B0 50 10 E0 50 00 70 88 88 88 70 00 50 ";
            S = S + "00 88 88 88 88 70 00 20 20 78 80 80 78 20 20 18 ";
            S = S + "24 20 F8 20 E2 5C 00 88 50 20 F8 20 F8 20 00 C0 ";
            S = S + "A0 A0 C8 9C 88 88 8C 18 20 20 F8 20 20 20 40 10 ";
            S = S + "20 70 08 78 88 78 00 10 20 00 60 20 20 70 00 20 ";
            S = S + "40 00 60 90 90 60 00 20 40 00 90 90 90 68 00 50 ";
            S = S + "A0 00 A0 D0 90 90 00 28 50 00 C8 A8 98 88 00 00 ";
            S = S + "70 08 78 88 78 00 F8 00 60 90 90 90 60 00 F0 20 ";
            S = S + "00 20 40 80 88 70 00 00 00 00 F8 80 80 00 00 00 ";
            S = S + "00 00 F8 08 08 00 00 84 88 90 A8 54 84 08 1C 84 ";
            S = S + "88 90 A8 58 A8 3C 08 20 00 00 20 20 20 20 00 00 ";
            S = S + "00 24 48 90 48 24 00 00 00 90 48 24 48 90 00 28 ";
            S = S + "50 20 50 88 F8 88 00 28 50 70 08 78 88 78 00 28 ";
            S = S + "50 00 70 20 20 70 00 28 50 00 20 20 20 70 00 28 ";
            S = S + "50 00 70 88 88 70 00 50 A0 00 60 90 90 60 00 28 ";
            S = S + "50 00 88 88 88 70 00 50 A0 00 A0 A0 A0 50 00 FC ";
            S = S + "48 48 48 E8 08 50 20 00 50 00 50 50 50 10 20 C0 ";
            S = S + "44 C8 54 EC 54 9E 04 10 A8 40 00 00 00 00 00 00 ";
            S = S + "20 50 88 50 20 00 00 88 10 20 40 80 28 00 00 7C ";
            S = S + "A8 A8 68 28 28 28 00 38 40 30 48 48 30 08 70 00 ";
            S = S + "00 00 00 00 00 FF FF F0 F0 F0 F0 0F 0F 0F 0F 00 ";
            S = S + "00 FF FF FF FF FF FF FF FF 00 00 00 00 00 00 00 ";
            S = S + "00 00 3C 3C 00 00 00 FF FF FF FF FF FF 00 00 C0 ";
            S = S + "C0 C0 C0 C0 C0 C0 C0 0F 0F 0F 0F F0 F0 F0 F0 FC ";
            S = S + "FC FC FC FC FC FC FC 03 03 03 03 03 03 03 03 3F ";
            S = S + "3F 3F 3F 3F 3F 3F 3F 11 22 44 88 11 22 44 88 88 ";
            S = S + "44 22 11 88 44 22 11 FE 7C 38 10 00 00 00 00 00 ";
            S = S + "00 00 00 10 38 7C FE 80 C0 E0 F0 E0 C0 80 00 01 ";
            S = S + "03 07 0F 07 03 01 00 FF 7E 3C 18 18 3C 7E FF 81 ";
            S = S + "C3 E7 FF FF E7 C3 81 F0 F0 F0 F0 00 00 00 00 00 ";
            S = S + "00 00 00 0F 0F 0F 0F 0F 0F 0F 0F 00 00 00 00 00 ";
            S = S + "00 00 00 F0 F0 F0 F0 33 33 CC CC 33 33 CC CC 00 ";
            S = S + "20 20 50 50 88 F8 00 20 20 70 20 70 20 20 00 00 ";
            S = S + "00 00 50 88 A8 50 00 FF FF FF FF FF FF FF FF 00 ";
            S = S + "00 00 00 FF FF FF FF F0 F0 F0 F0 F0 F0 F0 F0 0F ";
            S = S + "0F 0F 0F 0F 0F 0F 0F FF FF FF FF 00 00 00 00 00 ";
            S = S + "00 68 90 90 90 68 00 30 48 48 70 48 48 70 C0 F8 ";
            S = S + "88 80 80 80 80 80 00 F8 50 50 50 50 50 98 00 F8 ";
            S = S + "88 40 20 40 88 F8 00 00 00 78 90 90 90 60 00 00 ";
            S = S + "50 50 50 50 68 80 80 00 50 A0 20 20 20 20 00 F8 ";
            S = S + "20 70 A8 A8 70 20 F8 20 50 88 F8 88 50 20 00 70 ";
            S = S + "88 88 88 50 50 D8 00 30 40 40 20 50 50 50 20 00 ";
            S = S + "00 00 50 A8 A8 50 00 08 70 A8 A8 A8 70 80 00 38 ";
            S = S + "40 80 F8 80 40 38 00 70 88 88 88 88 88 88 00 00 ";
            S = S + "F8 00 F8 00 F8 00 00 20 20 F8 20 20 00 F8 00 C0 ";
            S = S + "30 08 30 C0 00 F8 00 18 60 80 60 18 00 F8 00 10 ";
            S = S + "28 20 20 20 20 20 20 20 20 20 20 20 20 A0 40 00 ";
            S = S + "20 00 F8 00 20 00 00 00 50 A0 00 50 A0 00 00 00 ";
            S = S + "18 24 24 18 00 00 00 00 30 78 78 30 00 00 00 00 ";
            S = S + "00 00 00 30 00 00 00 3E 20 20 20 A0 60 20 00 A0 ";
            S = S + "50 50 50 00 00 00 00 40 A0 20 40 E0 00 00 00 00 ";
            S = S + "38 38 38 38 38 38 00 00 00 00 00 00 00 00 00 CD ";
            S = S + "DB FD 3A AA F6 A7 20 0D 2E 00 18 14 CD E0 FD 3E ";
            S = S + "3F DF 3E 20 DF CD E5 FD 2A DC F3 2D C4 D9 0B 2C ";
            S = S + "22 CA FB AF 32 9B FC CD CB 10 21 37 24 0E 0B CD ";
            S = S + "76 09 F5 C4 FF 23 F1 30 EE 21 5D F5 C8 3F C9 F5 ";
            S = S + "FE 09 20 0F F1 3E 20 CD FF 23 3A DD F3 3D E6 07 ";
            S = S + "20 F3 C9 F1 21 A8 FC FE 01 28 0B FE 20 38 09 F5 ";
            S = S + "7E A7 C4 F2 24 F1 DF C9 36 00 DF 3E 3E AF F5 CD ";
            S = S + "8B 0A F1 32 AA FC C3 3E 0A 08 61 25 12 E5 24 1B ";
            S = S + "FE 23 02 0E 26 06 F8 25 0E D7 25 05 B9 25 03 C5 ";
            S = S + "24 0D 5A 24 15 AE 25 7F 50 25 CD 6C 26 3A AA F6 ";
            S = S + "A7 28 02 26 01 E5 CD 8B 0A E1 11 5E F5 06 FE 2D ";
            S = S + "2C D5 C5 CD 83 0B C1 D1 A7 28 14 FE 20 30 0B 05 ";
            S = S + "28 1D 4F 3E 01 12 13 79 C6 40 12 13 05 28 10 24 ";
            S = S + "3A B0 F3 BC 30 DB D5 CD CD 0B D1 26 01 28 D1 1B ";
            S = S + "1A FE 20 28 FA E5 D5 CD 3E 0A D1 E1 13 AF 12 3E ";
            S = S + "0D A7 F5 CD D9 0B CD EB 08 3E 0A DF AF 32 A8 FC ";
            S = S + "F1 37 E1 C9 2C CD CD 0B 28 FA CD 2D 24 AF 32 5E ";
            S = S + "F5 26 01 E5 CD B2 05 CD 49 05 E1 38 D2 3A B1 FB ";
            S = S + "A7 20 CC 18 CD 21 A8 FC 7E EE FF 77 CA 2D 24 C3 ";
            S = S + "2C 24 CD 8B 0A 2A DC F3 0E 20 E5 C5 CD 83 0B D1 ";
            S = S + "C5 4B CD 8D 0B C1 3A B0 F3 24 BC 7A 30 ED E1 CD ";
            S = S + "CD 0B 28 37 79 FE 20 F5 20 0A 3A B0 F3 BC 28 04 ";
            S = S + "F1 C3 3E 0A CD DA 0B 2C C5 E5 CD E2 0B BD 38 05 ";
            S = S + "CD F1 0A 18 0F 21 DC F3 35 20 01 34 2E 01 CD E5 ";
            S = S + "0A E1 2D E5 E1 C1 F1 CA 3E 0A 2D 2C 26 01 18 AA ";
            S = S + "3A B0 F3 BC 20 05 CD CD 0B 20 3A 3E 1C DF 2A DC ";
            S = S + "F3 E5 CD 8B 0A E1 25 C2 7A 25 24 E5 2D 28 0A 3A ";
            S = S + "B0 F3 67 CD CD 0B 20 01 E3 E1 22 DC F3 3A B0 F3 ";
            S = S + "BC 28 12 24 CD 83 0B 25 CD 8D 0B 24 24 3A B0 F3 ";
            S = S + "3C BC 20 F0 25 0E 20 CD 8D 0B CD CD 0B C2 3E 0A ";
            S = S + "E5 2C 26 01 CD 83 0B E3 CD 8D 0B E1 18 CF CD 8B ";
            S = S + "0A CD 6C 26 22 DC F3 18 05 E5 CD 8B 0A E1 CD CD ";
            S = S + "0B F5 CD 05 0B F1 20 05 26 01 2C 18 F1 CD 3E 0A ";
            S = S + "AF 32 A8 FC C3 2D 24 CD 8B 0A 2A DC F3 2D 2C CD ";
            S = S + "CD 0B 28 FA 3A B0 F3 67 24 25 28 07 CD 83 0B FE ";
            S = S + "20 28 F6 CD B8 0A 18 D5 CD 8B 0A CD 34 26 CD 24 ";
            S = S + "26 28 CA 38 F9 CD 24 26 28 C3 30 F9 18 BF CD 8B ";
            S = S + "0A CD 34 26 28 B7 30 F9 CD 34 26 28 B0 38 F9 CD ";
            S = S + "B8 0A 18 A9 2A DC F3 CD B8 0A CD E2 0B 5F 3A B0 ";
            S = S + "F3 57 18 09 2A DC F3 CD A9 0A 11 01 01 2A DC F3 ";
            S = S + "E7 C8 11 68 26 D5 CD 83 0B FE 30 3F D0 FE 3A D8 ";
            S = S + "FE 41 3F D0 FE 5B D8 FE 61 3F D0 FE 7B D8 FE 86 ";
            S = S + "3F D0 FE A0 D8 FE A6 3F 3E 00 3C C9 2D 28 05 CD ";
            S = S + "CD 0B 28 F8 2C 3A CA FB BD 26 01 C0 2A CA FB C9 ";
            S = S + "C3 76 7C C3 8C 55 C3 66 46 C3 97 55 21 47 F8 7E ";
            S = S + "B7 C8 EE 80 77 18 09 CD EF 2E 21 47 F8 7E B7 C8 ";
            S = S + "E6 7F 47 11 F6 F7 1A B7 CA 05 2F E6 7F 90 30 11 ";
            S = S + "2F 3C F5 E5 06 08 1A 4E 77 79 12 13 23 10 F7 E1 ";
            S = S + "F1 FE 10 D0 F5 AF 32 FE F7 32 4F F8 21 48 F8 F1 ";
            S = S + "CD A3 27 21 47 F8 3A F6 F7 AE FA F7 26 3A 4F F8 ";
            S = S + "32 FE F7 CD 59 27 D2 3C 27 EB 7E 34 AE FA 67 40 ";
            S = S + "CD DB 27 CB E6 18 45 CD 6B 27 21 F7 F7 01 00 08 ";
            S = S + "7E B7 20 08 23 0D 0D 10 F7 C3 7D 2E E6 F0 20 06 ";
            S = S + "E5 CD 97 27 E1 0D 3E 08 90 28 12 F5 C5 48 11 F7 ";
            S = S + "F7 06 00 ED B0 C1 F1 47 AF 12 13 10 FC 79 B7 28 ";
            S = S + "0B 21 F6 F7 46 86 77 A8 FA 67 40 C8 21 FE F7 06 ";
            S = S + "07 7E FE 50 D8 2B AF 37 8E 27 77 D0 2B 10 F9 7E ";
            S = S + "34 AE FA 67 40 23 36 10 C9 21 4E F8 11 FD F7 06 ";
            S = S + "07 AF 1A 8E 27 12 1B 2B 10 F8 C9 21 4F F8 7E FE ";
            S = S + "50 20 01 34 11 FE F7 06 08 AF 1A 9E 27 12 1B 2B ";
            S = S + "10 F8 D0 EB 7E EE 80 77 21 FE F7 06 08 AF 3E 00 ";
            S = S + "9E 27 77 2B 10 F8 C9 21 FE F7 C5 AF ED 6F 2B 10 ";
            S = S + "FB C1 C9 B7 1F F5 B7 CA E2 27 F5 2F 3C 4F 06 FF ";
            S = S + "11 07 00 19 54 5D 09 3E 08 81 4F C5 06 00 ED B8 ";
            S = S + "C1 F1 23 13 D5 47 AF 77 23 10 FC E1 F1 D0 79 E5 ";
            S = S + "C5 47 AF ED 67 23 10 FB C1 E1 C9 21 F7 F7 3E 08 ";
            S = S + "18 ED F1 D0 18 F8 CD 71 2E C8 3A 47 F8 B7 CA 7D ";
            S = S + "2E 47 21 F6 F7 AE E6 80 4F CB B8 7E E6 7F 80 47 ";
            S = S + "36 00 E6 C0 C8 FE C0 20 03 C3 67 40 78 C6 40 E6 ";
            S = S + "7F C8 B1 2B 77 11 45 F8 01 08 00 21 FD F7 D5 ED ";
            S = S + "B8 23 AF 06 08 77 23 10 FC D1 01 83 28 C5 CD 8A ";
            S = S + "28 E5 01 08 00 EB ED B8 EB 21 3D F8 06 08 CD 61 ";
            S = S + "27 D1 CD 8A 28 0E 07 11 4E F8 1A B7 20 04 1B 0D ";
            S = S + "18 F8 1A 1B D5 21 0D F8 87 38 08 28 14 11 08 00 ";
            S = S + "19 18 F5 F5 06 08 11 FD F7 E5 CD 61 27 E1 F1 18 ";
            S = S + "EC 06 0F 11 04 F8 21 05 F8 CD FE 2E 36 00 D1 0D ";
            S = S + "20 D0 C9 2B 7E 23 77 C3 FA 26 21 F8 FF 19 0E 03 ";
            S = S + "06 08 B7 1A 8F 27 77 2B 1B 10 F8 0D 20 F2 C9 3A ";
            S = S + "47 F8 B7 CA 58 40 47 21 F6 F7 7E B7 CA 7D 2E A8 ";
            S = S + "E6 80 4F CB B8 7E E6 7F 90 47 1F A8 E6 40 36 00 ";
            S = S + "28 07 78 E6 80 C0 C3 67 40 78 C6 41 E6 7F 77 28 ";
            S = S + "F5 B1 36 00 2B 77 11 FD F7 21 4E F8 06 07 AF BE ";
            S = S + "20 04 1B 2B 10 F9 22 F2 F7 EB 22 F0 F7 78 32 F4 ";
            S = S + "F7 21 3E F8 06 0F E5 C5 2A F2 F7 EB 2A F0 F7 3A ";
            S = S + "F4 F7 0E FF 0C 47 E5 D5 AF EB 1A 9E 27 12 2B 1B ";
            S = S + "10 F8 1A 98 12 D1 E1 3A F4 F7 30 E8 47 EB CD 61 ";
            S = S + "27 30 02 EB 34 79 C1 4F C5 CB 38 04 58 16 00 21 ";
            S = S + "F5 F7 19 CD 9A 27 C1 E1 78 0C 0D 20 36 FE 0F 28 ";
            S = S + "23 0F 07 30 2E C5 E5 21 F6 F7 06 08 AF BE 20 0F ";
            S = S + "23 10 FA E1 C1 CB 38 04 AF 77 23 10 FC 18 26 E1 ";
            S = S + "C1 78 18 0F 3A F5 F7 5F 3D 32 F5 F7 AB F2 F4 28 ";
            S = S + "C3 7D 2E 1F 79 38 05 B6 77 23 18 05 87 87 87 87 ";
            S = S + "77 05 C2 F6 28 21 FE F7 11 45 F8 06 08 CD FE 2E ";
            S = S + "C3 83 28 21 63 2D CD 3B 2C 3A F6 F7 E6 7F 32 F6 ";
            S = S + "F7 21 23 2D CD 32 2C CD 8D 2E 18 06 21 63 2D CD ";
            S = S + "3B 2C 3A F6 F7 B7 FC 80 2C CD CC 2C CD CF 30 CD ";
            S = S + "4D 2C CD E1 2C CD 8C 26 3A F6 F7 FE 40 DA F5 29 ";
            S = S + "3A F7 F7 FE 25 DA F5 29 FE 75 D2 EC 29 CD 4D 2C ";
            S = S + "21 11 2D CD 5C 2C CD 8C 26 C3 F5 29 21 1B 2D CD ";
            S = S + "50 2C CD 8C 26 21 EF 2D C3 88 2C CD CC 2C CD 93 ";
            S = S + "29 CD 6F 2C CD AC 29 CD DC 2C 3A 47 F8 B7 C2 9F ";
            S = S + "28 C3 67 40 3A F6 F7 B7 C8 FC 80 2C FE 41 DA 3C ";
            S = S + "2A CD 4D 2C 21 1B 2D CD 5C 2C CD 9F 28 CD 3C 2A ";
            S = S + "CD 4D 2C 21 43 2D CD 5C 2C C3 8C 26 21 4B 2D CD ";
            S = S + "47 2C FA 6C 2A CD CC 2C 21 53 2D CD 2C 2C CD 6F ";
            S = S + "2C 21 53 2D CD 3B 2C 21 1B 2D CD 32 2C CD DC 2C ";
            S = S + "CD 9F 28 CD 6C 2A 21 5B 2D C3 2C 2C 21 30 2E C3 ";
            S = S + "88 2C CD 71 2E FA 5A 47 CA 5A 47 21 F6 F7 7E F5 ";
            S = S + "36 41 21 2B 2D CD 47 2C FA 92 2A F1 3C F5 21 F6 ";
            S = S + "F7 35 F1 32 9D F6 CD CC 2C 21 1B 2D CD 2C 2C CD ";
            S = S + "6F 2C 21 1B 2D CD 32 2C CD DC 2C CD 9F 28 CD CC ";
            S = S + "2C CD 38 2C CD CC 2C CD CC 2C 21 C6 2D CD A3 2C ";
            S = S + "CD 6F 2C 21 A5 2D CD A3 2C CD DC 2C CD 9F 28 CD ";
            S = S + "DC 2C CD E6 27 21 33 2D CD 2C 2C CD DC 2C CD E6 ";
            S = S + "27 CD CC 2C 3A 9D F6 D6 41 6F 87 9F 67 CD CB 2F ";
            S = S + "CD 42 30 CD DC 2C CD 9A 26 21 3B 2D C3 3B 2C CD ";
            S = S + "71 2E C8 FA 5A 47 CD 4D 2C 3A F6 F7 B7 1F CE 20 ";
            S = S + "32 47 F8 3A F7 F7 B7 0F B7 0F E6 33 C6 10 32 48 ";
            S = S + "F8 3E 07 32 9D F6 CD CC 2C CD C7 2C CD 9F 28 CD ";
            S = S + "DC 2C CD 9A 26 21 11 2D CD 3B 2C CD 4D 2C CD E1 ";
            S = S + "2C 3A 9D F6 3D 20 DC C3 59 2C 21 09 2D CD 3B 2C ";
            S = S + "CD CC 2C CD 8A 2F 7D 17 9F BC 28 14 7C B7 F2 6D ";
            S = S + "2B CD 4F 30 CD E1 2C 21 13 2D C3 5C 2C C3 67 40 ";
            S = S + "22 9D F6 CD 3A 30 CD 4D 2C CD E1 2C CD 8C 26 21 ";
            S = S + "11 2D CD 47 2C F5 28 08 38 06 21 11 2D CD 32 2C ";
            S = S + "CD CC 2C 21 8C 2D CD 88 2C CD 6F 2C 21 6B 2D CD ";
            S = S + "9A 2C CD DC 2C CD C7 2C CD CC 2C CD 8C 26 21 3E ";
            S = S + "F8 CD 67 2C CD DC 2C CD E1 2C CD 9A 26 21 3E F8 ";
            S = S + "CD 50 2C CD 9F 28 F1 38 08 28 06 21 2B 2D CD 3B ";
            S = S + "2C 3A 9D F6 21 F6 F7 4E 86 77 A9 F0 C3 67 40 CD ";
            S = S + "71 2E 21 57 F8 28 2E FC 67 2C 21 3E F8 11 57 F8 ";
            S = S + "CD 6A 2C 21 F9 2C CD 50 2C 21 F1 2C CD 5C 2C 11 ";
            S = S + "45 F8 CD 2E 28 11 FE F7 21 58 F8 06 07 CD F7 2E ";
            S = S + "21 57 F8 36 00 CD 5C 2C 21 F6 F7 36 40 AF 32 FE ";
            S = S + "F7 C3 FA 26 11 01 2D 21 57 F8 18 3E CD 50 2C C3 ";
            S = S + "9A 26 CD 50 2C C3 8C 26 21 F6 F7 CD 50 2C C3 E6 ";
            S = S + "27 CD 50 2C C3 9F 28 CD 50 2C C3 5C 2F 21 F6 F7 ";
            S = S + "11 47 F8 EB CD 6A 2C EB C9 21 47 F8 11 F6 F7 18 ";
            S = S + "F2 CD CB 2F 21 57 F8 11 F6 F7 06 08 C3 F7 2E E1 ";
            S = S + "22 C5 F7 CD DC 2C CD CC 2C CD 59 2C 2A C5 F7 E9 ";
            S = S + "CD 8D 2E 21 8D 2E E3 E9 22 C5 F7 CD CC 2C 2A C5 ";
            S = S + "F7 CD 9A 2C CD DC 2C C3 E6 27 22 C5 F7 CD 38 2C ";
            S = S + "2A C5 F7 7E F5 23 E5 21 C5 F7 CD 67 2C E1 CD 5C ";
            S = S + "2C F1 3D C8 F5 E5 21 C5 F7 CD 3B 2C E1 CD 50 2C ";
            S = S + "E5 CD 9A 26 E1 18 EA 21 4E F8 18 03 21 FD F7 3E ";
            S = S + "04 D1 46 2B 4E 2B C5 3D 20 F8 EB E9 21 47 F8 18 ";
            S = S + "03 21 F6 F7 3E 04 D1 C1 71 23 70 23 3D 20 F8 EB ";
            S = S + "E9 00 14 38 98 20 42 08 21 00 21 13 24 86 54 05 ";
            S = S + "19 00 40 64 96 51 37 23 58 40 43 42 94 48 19 03 ";
            S = S + "24 40 50 00 00 00 00 00 00 00 00 41 10 00 00 00 ";
            S = S + "00 00 00 40 25 00 00 00 00 00 00 41 31 62 27 76 ";
            S = S + "60 16 84 40 86 85 88 96 38 06 50 41 23 02 58 50 ";
            S = S + "92 99 40 41 15 70 79 63 26 79 49 40 26 79 49 19 ";
            S = S + "24 31 12 41 17 32 05 08 07 56 89 40 52 35 98 77 ";
            S = S + "55 98 30 40 15 91 54 94 30 91 90 04 41 10 00 00 ";
            S = S + "00 00 00 00 43 15 93 74 15 23 60 31 44 27 09 31 ";
            S = S + "69 40 85 16 44 44 97 63 35 57 40 58 03 42 18 31 ";
            S = S + "23 60 15 92 75 43 83 14 06 72 12 93 71 44 51 78 ";
            S = S + "09 19 91 51 62 04 C0 71 43 33 82 15 32 26 41 62 ";
            S = S + "50 36 51 12 79 08 C2 13 68 23 70 24 15 03 41 85 ";
            S = S + "16 73 19 87 23 89 05 41 10 00 00 00 00 00 00 C2 ";
            S = S + "13 21 04 78 35 01 56 42 47 92 52 56 04 38 73 C2 ";
            S = S + "64 90 66 82 74 09 43 42 29 41 57 50 17 23 23 08 ";
            S = S + "C0 69 21 56 92 29 18 09 41 38 17 28 86 38 57 71 ";
            S = S + "C2 15 09 44 99 47 48 01 42 42 05 86 89 66 73 55 ";
            S = S + "C2 76 70 58 59 68 32 91 42 81 60 52 49 27 55 13 ";
            S = S + "C2 41 34 17 02 24 03 98 41 62 83 18 53 07 17 96 ";
            S = S + "08 BF 52 08 69 39 04 00 00 3F 75 30 71 49 13 48 ";
            S = S + "00 BF 90 81 34 32 24 70 50 40 11 11 07 94 18 40 ";
            S = S + "29 C0 14 28 57 08 55 48 84 40 19 99 99 99 94 89 ";
            S = S + "67 C0 33 33 33 33 33 31 60 41 10 00 00 00 00 00 ";
            S = S + "00 3A F6 F7 B7 C8 FE 2F 17 9F C0 3C C9 AF 32 F6 ";
            S = S + "F7 C9 CD A1 2E F0 EF FA 2B 32 CA 6D 40 21 F6 F7 ";
            S = S + "7E B7 C8 EE 80 77 C9 CD A1 2E 6F 17 9F 67 C3 99 ";
            S = S + "2F EF CA 6D 40 F2 71 2E 2A F8 F7 7C B5 C8 7C 18 ";
            S = S + "C7 EB 2A F8 F7 E3 E5 2A F6 F7 E3 E5 EB C9 CD DF ";
            S = S + "2E EB 22 F8 F7 60 69 22 F6 F7 EB C9 2A F8 F7 EB ";
            S = S + "2A F6 F7 4D 44 C9 4E 23 46 23 5E 23 56 23 C9 5E ";
            S = S + "23 56 23 4E 23 46 23 C9 11 F6 F7 06 04 18 08 11 ";
            S = S + "47 F8 EB 3A 63 F6 47 1A 77 13 23 10 FA C9 1A 77 ";
            S = S + "1B 2B 10 FA C9 21 47 F8 11 F2 2E 18 06 21 47 F8 ";
            S = S + "11 F3 2E D5 11 F6 F7 3A 63 F6 FE 04 D0 11 F8 F7 ";
            S = S + "C9 79 B7 CA 71 2E 21 77 2E E5 CD 71 2E 79 C8 21 ";
            S = S + "F6 F7 AE 79 F8 CD 3B 2F 1F A9 C9 79 BE C0 23 78 ";
            S = S + "BE C0 23 7B BE C0 23 7A 96 C0 E1 E1 C9 7A AC 7C ";
            S = S + "FA 78 2E BA 20 03 7D 93 C8 C3 79 2E 11 47 F8 1A ";
            S = S + "B7 CA 71 2E 21 77 2E E5 CD 71 2E 1A 4F C8 21 F6 ";
            S = S + "F7 AE 79 F8 06 08 1A 96 20 06 13 23 10 F8 C1 C9 ";
            S = S + "1F A9 C9 CD 5C 2F C2 77 2E C9 EF 2A F8 F7 F8 CA ";
            S = S + "6D 40 CD 5D 30 DA 67 40 EB 22 F8 F7 3E 02 32 63 ";
            S = S + "F6 C9 01 C5 32 11 76 80 CD 21 2F C0 21 00 80 D1 ";
            S = S + "18 E7 EF E0 FA C8 2F CA 6D 40 CD 53 30 CD 52 37 ";
            S = S + "23 78 B7 1F 47 C3 41 27 2A F8 F7 7C B7 F5 FC 21 ";
            S = S + "32 CD 53 30 EB 21 00 00 22 F6 F7 22 F8 F7 7A B3 ";
            S = S + "CA A7 66 01 00 05 21 F7 F7 E5 21 30 30 3E FF D5 ";
            S = S + "5E 23 56 23 E3 C5 44 4D 19 3C 38 FA 60 69 C1 D1 ";
            S = S + "EB 0C 0D 20 0B B7 28 1C F5 3E 40 80 32 F6 F7 F1 ";
            S = S + "0C E3 F5 79 1F 30 08 F1 87 87 87 87 77 18 04 F1 ";
            S = S + "B6 77 23 E3 7A B3 28 02 10 C3 E1 F1 F0 C3 8D 2E ";
            S = S + "F0 D8 18 FC 9C FF F6 FF FF FF EF D0 CA 6D 40 FC ";
            S = S + "C8 2F 21 00 00 22 FA F7 22 FC F7 7C 32 FE F7 3E ";
            S = S + "08 18 02 3E 04 C3 9E 2F EF C8 C3 6D 40 21 BA 30 ";
            S = S + "E5 21 F6 F7 7E E6 7F FE 46 D0 D6 41 30 06 B7 D1 ";
            S = S + "11 00 00 C9 3C 47 11 00 00 4A 23 79 0C 1F 7E 38 ";
            S = S + "06 1F 1F 1F 1F 18 01 23 E6 0F 22 F0 F7 62 6B 29 ";
            S = S + "D8 29 D8 19 D8 29 D8 5F 16 00 19 D8 EB 2A F0 F7 ";
            S = S + "10 D9 21 00 80 E7 3A F6 F7 D8 28 0A E1 B7 F0 EB ";
            S = S + "CD 21 32 EB B7 C9 B7 F0 E1 C9 37 C9 0B C9 EF F8 ";
            S = S + "CD 71 2E F2 CF 30 CD 8D 2E CD CF 30 C3 86 2E EF ";
            S = S + "F8 21 FE F7 0E 0E 30 08 CA 6D 40 21 FA F7 0E 06 ";
            S = S + "3A F6 F7 B7 FA 00 31 E6 7F D6 41 DA 7D 2E 3C 91 ";
            S = S + "D0 2F 3C 47 2B 7E E6 F0 77 05 C8 AF 77 10 F5 C9 ";
            S = S + "E6 7F D6 41 30 06 21 FF FF C3 99 2F 3C 91 D0 2F ";
            S = S + "3C 47 1E 00 2B 7E 57 E6 F0 77 BA 28 01 1C 05 28 ";
            S = S + "08 AF 77 BA 28 01 1C 10 EB 1C 1D C8 79 FE 06 01 ";
            S = S + "C1 10 11 00 00 CA 4E 32 EB 22 4D F8 22 4B F8 22 ";
            S = S + "49 F8 60 69 22 47 F8 C3 9A 26 E5 21 00 00 78 B1 ";
            S = S + "28 12 3E 10 29 DA 1D 60 EB 29 EB 30 04 09 DA 1D ";
            S = S + "60 3D 20 F0 EB E1 C9 7C 17 9F 47 CD 21 32 79 98 ";
            S = S + "18 03 7C 17 9F 47 E5 7A 17 9F 19 88 0F AC F2 AF ";
            S = S + "2F C5 EB CD CB 2F F1 E1 CD B1 2E CD CB 2F C1 D1 ";
            S = S + "C3 4E 32 7C B5 CA 99 2F E5 D5 CD 15 32 C5 44 4D ";
            S = S + "21 00 00 3E 10 29 38 1F EB 29 EB 30 03 09 38 17 ";
            S = S + "3D 20 F2 C1 D1 7C B7 FA BF 31 D1 78 C3 1D 32 EE ";
            S = S + "80 B5 28 14 EB 18 02 C1 E1 CD CB 2F E1 CD B1 2E ";
            S = S + "CD CB 2F C1 D1 C3 5C 32 78 B7 C1 FA 99 2F D5 CD ";
            S = S + "CB 2F D1 C3 8D 2E 7C B5 CA 58 40 CD 15 32 C5 EB ";
            S = S + "CD 21 32 44 4D 21 00 00 3E 11 B7 18 09 E5 09 30 ";
            S = S + "04 33 33 37 30 E1 CB 13 CB 12 ED 6A 3D 20 EE EB ";
            S = S + "C1 D5 C3 B5 31 7C AA 47 CD 1C 32 EB 7C B7 F2 99 ";
            S = S + "2F AF 4F 95 6F 79 9C 67 C3 99 2F 2A F8 F7 CD 21 ";
            S = S + "32 7C EE 80 B5 C0 AF C3 CC 2F D5 CD E6 31 AF 82 ";
            S = S + "1F 67 7B 1F 6F CD 9C 2F F1 18 D2 CD DF 2E CD 80 ";
            S = S + "32 CD 42 30 C3 9A 26 CD 8D 2E 18 F2 CD 80 32 CD ";
            S = S + "42 30 C3 E6 27 C1 D1 2A F8 F7 EB 22 F8 F7 C5 2A ";
            S = S + "F6 F7 E3 22 F6 F7 C1 CD 80 32 CD 42 30 C3 9F 28 ";
            S = S + "EB 22 49 F8 60 69 22 47 F8 21 00 00 22 4B F8 22 ";
            S = S + "4D F8 C9 3D C9 2B C9 E1 C9 EB 01 FF 00 60 68 CD ";
            S = S + "99 2F EB 7E FE 26 CA B8 4E FE 2D F5 28 05 FE 2B ";
            S = S + "28 01 2B D7 DA 86 33 FE 2E CA 4F 33 FE 65 28 02 ";
            S = S + "FE 45 20 1A E5 D7 FE 6C 28 0A FE 4C 28 06 FE 71 ";
            S = S + "28 02 FE 51 E1 28 06 EF 30 1B AF 18 19 7E FE 25 ";
            S = S + "CA 62 33 FE 23 CA 70 33 FE 21 CA 71 33 FE 64 28 ";
            S = S + "04 FE 44 20 29 B7 CD 77 33 D7 D5 16 00 CD 47 4F ";
            S = S + "4A D1 D7 30 13 7B FE 0C 30 0A 07 07 83 07 86 D6 ";
            S = S + "30 5F 18 EE 1E 80 18 EA 0C 20 03 AF 93 5F EF FA ";
            S = S + "34 33 3A F6 F7 B7 28 0C 7A 90 83 C6 40 32 F6 F7 ";
            S = S + "B7 FC 4C 33 F1 E5 CC 86 2E EF 30 0B E1 E8 E5 21 ";
            S = S + "97 32 E5 CD A2 2F C9 CD 3C 27 E1 C9 C3 67 40 EF ";
            S = S + "0C 20 CB 30 0A CD 77 33 3A F6 F7 B7 20 01 57 C3 ";
            S = S + "B3 32 D7 F1 E5 21 97 32 E5 21 8A 2F E5 F5 18 AE ";
            S = S + "B7 CD 77 33 D7 18 A7 E5 D5 C5 F5 CC B2 2F F1 C4 ";
            S = S + "3A 30 C1 D1 E1 C9 D6 30 C2 93 33 B1 CA 93 33 A2 ";
            S = S + "CA B3 32 14 7A FE 07 20 04 B7 CD 77 33 D5 78 81 ";
            S = S + "3C 47 C5 E5 7E D6 30 F5 EF F2 D1 33 2A F8 F7 11 ";
            S = S + "CD 0C E7 30 19 54 5D 29 29 19 29 F1 4F 09 7C B7 ";
            S = S + "FA CC 33 22 F8 F7 E1 C1 D1 C3 B3 32 79 F5 CD C8 ";
            S = S + "2F F1 E1 C1 D1 20 0C 3A F6 F7 B7 3E 00 20 04 57 ";
            S = S + "C3 B3 32 D5 C5 E5 F5 21 F6 F7 36 01 7A FE 10 38 ";
            S = S + "03 F1 18 D2 3C B7 1F 06 00 4F 09 F1 4F 7A 1F 79 ";
            S = S + "30 04 87 87 87 87 B6 77 18 BC E5 21 D2 3F CD 78 ";
            S = S + "66 E1 01 77 66 C5 CD 99 2F AF 32 9D F6 21 C6 F7 ";
            S = S + "36 20 B6 18 1C AF CD 5F 37 E6 08 28 02 36 2B EB ";
            S = S + "CD A1 2E EB F2 41 34 36 2D C5 E5 CD 86 2E E1 C1 ";
            S = S + "B4 23 36 30 3A 9D F6 57 17 3A 63 F6 DA F7 34 CA ";
            S = S + "EF 34 FE 04 D2 A1 34 01 00 00 CD DB 36 21 C6 F7 ";
            S = S + "46 0E 20 3A 9D F6 5F E6 20 28 0C 78 B9 0E 2A 20 ";
            S = S + "06 7B E6 04 20 01 41 71 D7 28 14 FE 45 28 10 FE ";
            S = S + "44 28 0C FE 30 28 F0 FE 2C 28 EC FE 2E 20 03 2B ";
            S = S + "36 30 7B E6 10 28 03 2B 36 24 7B E6 04 C0 2B 70 ";
            S = S + "C9 E5 CD 52 37 50 14 01 00 03 3A F6 F7 D6 3F 38 ";
            S = S + "08 14 BA 30 04 3C 47 3E 02 D6 02 E1 F5 CD 8E 36 ";
            S = S + "36 30 CC E6 2E CD B3 36 2B 7E FE 30 28 FA FE 2E ";
            S = S + "C4 E6 2E F1 28 1A 36 45 23 36 2B F2 E2 34 36 2D ";
            S = S + "2F 3C 06 2F 04 D6 0A 30 FB C6 3A 23 70 23 77 23 ";
            S = S + "36 00 EB 21 C6 F7 C9 23 C5 FE 04 7A D2 66 35 1F ";
            S = S + "DA EF 35 01 03 06 CD 86 36 D1 7A D6 05 F4 66 36 ";
            S = S + "CD DB 36 7B B7 CC 95 32 3D F4 66 36 E5 CD 5D 34 ";
            S = S + "E1 28 02 70 23 36 00 21 C5 F7 23 3A BC F6 95 92 ";
            S = S + "C8 7E FE 20 28 F4 FE 2A 28 F0 2B E5 F5 01 3C 35 ";
            S = S + "C5 D7 FE 2D C8 FE 2B C8 FE 24 C8 C1 FE 30 20 0F ";
            S = S + "23 D7 30 0B 2B 18 02 2B 77 F1 28 FB C1 18 CC F1 ";
            S = S + "28 FD E1 36 25 C9 E5 1F DA F5 35 CD 52 37 50 3A ";
            S = S + "F6 F7 D6 4F 38 0B E1 C1 CD 25 34 21 C5 F7 36 25 ";
            S = S + "C9 CD 71 2E C4 A2 37 E1 C1 FA A6 35 C5 5F 78 92 ";
            S = S + "93 F4 66 36 CD 7A 36 CD B3 36 B3 C4 74 36 B3 C4 ";
            S = S + "A0 36 D1 C3 13 35 5F 79 B7 C4 93 32 83 FA B1 35 ";
            S = S + "AF C5 F5 FC 7B 37 C1 7B 90 C1 5F 82 78 FA CB 35 ";
            S = S + "92 93 F4 66 36 C5 CD 7A 36 18 11 CD 66 36 79 CD ";
            S = S + "A3 36 4F AF 92 93 CD 66 36 C5 47 4F CD B3 36 C1 ";
            S = S + "B1 20 03 2A BC F6 83 3D F4 66 36 50 C3 1C 35 E5 ";
            S = S + "D5 CD C8 2F D1 CD 52 37 58 CD 71 2E F5 C4 A2 37 ";
            S = S + "F1 E1 C1 F5 79 B7 F5 C4 93 32 80 4F 7A E6 04 FE ";
            S = S + "01 9F 57 81 4F 93 F5 F2 28 36 CD 7B 37 20 09 E5 ";
            S = S + "CD DB 27 21 F6 F7 34 E1 F1 C5 F5 FA 2F 36 AF 2F ";
            S = S + "3C 80 3C 82 47 0E 00 CC 8E 36 CD B3 36 F1 F4 6E ";
            S = S + "36 CD A0 36 C1 F1 20 0C CD 95 32 7E FE 2E C4 E6 ";
            S = S + "2E 22 BC F6 F1 3A F6 F7 28 03 83 90 92 C5 CD D6 ";
            S = S + "34 EB D1 C3 1C 35 B7 C8 3D 36 30 23 18 F9 20 04 ";
            S = S + "C8 CD A0 36 36 30 23 3D 18 F6 7B 82 3C 47 3C D6 ";
            S = S + "03 30 FC C6 05 4F 3A 9D F6 E6 40 C0 4F C9 05 F2 ";
            S = S + "A1 36 22 BC F6 36 2E 23 36 30 04 48 20 F9 23 C9 ";
            S = S + "05 20 08 36 2E 22 BC F6 23 48 C9 0D C0 36 2C 23 ";
            S = S + "0E 03 C9 D5 E5 C5 CD 52 37 78 C1 E1 11 F7 F7 37 ";
            S = S + "F5 CD A0 36 1A 30 06 1F 1F 1F 1F 18 01 13 E6 0F ";
            S = S + "C6 30 77 23 F1 3D 3F 20 E7 18 2F D5 11 10 37 3E ";
            S = S + "05 CD A0 36 C5 F5 E5 EB 4E 23 46 C5 23 E3 EB 2A ";
            S = S + "F8 F7 06 2F 04 7D 93 6F 7C 9A 67 30 F7 19 22 F8 ";
            S = S + "F7 D1 E1 70 23 F1 C1 3D 20 D7 CD A0 36 77 D1 C9 ";
            S = S + "10 27 E8 03 64 00 0A 00 01 00 06 01 18 06 06 03 ";
            S = S + "18 02 06 04 C5 CD 39 54 11 D6 F7 AF 12 C1 4F C5 ";
            S = S + "1B A7 7C 1F 67 7D 1F 6F 79 1F 4F 10 F4 C1 C5 07 ";
            S = S + "10 FD C6 30 FE 3A 38 02 C6 07 12 C1 7D B4 20 DF ";
            S = S + "EB C9 EF 21 FD F7 06 0E D0 21 F9 F7 06 06 C9 32 ";
            S = S + "9D F6 F5 C5 D5 CD 3A 30 21 13 2D 3A F6 F7 A7 CC ";
            S = S + "5C 2C D1 C1 F1 21 C6 F7 36 20 C9 E5 D5 C5 F5 2F ";
            S = S + "3C 5F 3E 01 CA 9C 37 CD 52 37 E5 CD DB 27 1D 20 ";
            S = S + "FA E1 23 78 0F 47 CD 41 27 CD B4 37 C1 80 C1 D1 ";
            S = S + "E1 C9 C5 E5 CD 52 37 3A F6 F7 D6 40 90 32 F6 F7 ";
            S = S + "E1 C1 B7 C9 C5 CD 52 37 7E E6 0F 20 08 05 7E B7 ";
            S = S + "20 03 2B 10 F3 78 C1 C9 CD 80 32 CD 42 30 CD C7 ";
            S = S + "2C CD 6F 2C CD DC 2C 3A 47 F8 B7 CA 43 38 67 3A ";
            S = S + "F6 F7 B7 CA 4D 38 CD CC 2C CD 1A 39 38 3C EB 22 ";
            S = S + "9F F6 CD 4F 30 CD DC 2C CD 1A 39 CD 4F 30 2A 9F ";
            S = S + "F6 D2 5A 38 3A 47 F8 F5 E5 CD 59 2C 21 C5 F7 CD ";
            S = S + "67 2C 21 1B 2D CD 5C 2C E1 7C B7 F5 F2 26 38 AF ";
            S = S + "4F 95 6F 79 9C 67 E5 C3 94 38 CD 4F 30 CD 59 2C ";
            S = S + "CD 6F 2C CD 72 2A CD DC 2C CD E6 27 C3 4A 2B 7C ";
            S = S + "B5 20 06 21 01 00 C3 57 38 7A B3 20 0D 7C 17 30 ";
            S = S + "03 C3 58 40 21 00 00 C3 99 2F 22 9F F6 D5 7C B7 ";
            S = S + "F5 FC 21 32 44 4D 21 01 00 B7 78 1F 47 79 1F 4F ";
            S = S + "30 05 CD 0D 39 20 4C 78 B1 28 63 E5 62 6B CD 0D ";
            S = S + "39 EB E1 28 E4 C5 E5 21 C5 F7 CD 67 2C E1 CD CB ";
            S = S + "2F CD 42 30 C1 78 B7 1F 47 79 1F 4F 30 08 C5 21 ";
            S = S + "C5 F7 CD 3B 2C C1 78 B1 28 34 C5 CD CC 2C 21 C5 ";
            S = S + "F7 E5 CD 5C 2C E1 E5 CD 3B 2C E1 CD 67 2C CD E1 ";
            S = S + "2C 18 D1 C5 D5 CD 3A 30 CD 4D 2C E1 CD CB 2F CD ";
            S = S + "42 30 21 C5 F7 CD 67 2C CD 59 2C C1 18 C8 F1 C1 ";
            S = S + "F0 3A 63 F6 FE 02 20 08 C5 CD CB 2F CD 42 30 C1 ";
            S = S + "3A F6 F7 B7 20 0B 2A 9F F6 B4 F0 7D 0F A0 C3 67 ";
            S = S + "40 CD 4D 2C 21 1B 2D CD 5C 2C C3 9F 28 C5 D5 CD ";
            S = S + "93 31 3A 63 F6 FE 02 D1 C1 C9 CD 59 2C CD C7 2C ";
            S = S + "CD CF 30 CD DC 2C CD 5C 2F 37 C0 C3 5D 30 EA 63 ";
            S = S + "24 45 27 65 5B 48 6C 4B 9F 5E 9F 4B 80 48 E8 47 ";
            S = S + "9E 47 E5 49 C9 63 B2 47 21 48 5D 48 E3 63 24 4A ";
            S = S + "AF 64 2E 52 86 62 E4 48 1C 40 1D 50 23 54 24 64 ";
            S = S + "B7 6F 3F 70 16 40 1D 4A 29 52 C3 00 C9 51 5D 48 ";
            S = S + "38 64 39 64 3E 64 77 64 AA 49 5D 49 E2 53 B5 49 ";
            S = S + "68 54 18 47 1B 47 1E 47 21 47 0E 4B B7 6A 52 7C ";
            S = S + "5B 77 58 77 14 6C 5D 6B 5E 6B 2F 6C 48 7C 4D 7C ";
            S = S + "A3 6B 2A 6C 11 5B 80 79 6E 5D C5 59 C0 00 E5 73 ";
            S = S + "EA 57 E5 57 CA 73 CC 79 E2 7B 48 7A 37 7B 5A 7B ";
            S = S + "A8 55 11 79 6C 78 4B 7E B7 73 C6 6E 92 6E 16 7C ";
            S = S + "1B 7C 20 7C 25 7C 2A 7C 2F 7C 34 7C 66 77 61 68 ";
            S = S + "91 68 9A 68 97 2E CF 30 82 2E FF 2A DF 2B AC 29 ";
            S = S + "72 2A 4A 2B 93 29 FB 29 14 2A F2 69 01 40 CC 4F ";
            S = S + "FF 67 04 66 BB 68 0B 68 1B 68 1C 54 F5 7B 48 68 ";
            S = S + "F5 65 FA 65 C7 4F FF 65 8A 2F B2 2F 3A 30 BE 30 ";
            S = S + "40 79 4C 79 5A 79 69 79 39 7C 39 6D 66 7C 6B 7C ";
            S = S + "70 7C 25 6D 03 6D 14 6D 57 7C 5C 7C 61 7C 72 3A ";
            S = S + "88 3A 9F 3A F3 3A 2E 3B 4F 3B 69 3B 7B 3B 80 3B ";
            S = S + "9F 3B A0 3B A8 3B E8 3B 09 3C 18 3C 2B 3C 5D 3C ";
            S = S + "5E 3C 8E 3C DB 3C F6 3C FF 3C 16 3D 20 3D 24 3D ";
            S = S + "25 3D 55 54 CF A9 4E C4 F6 42 D3 06 54 CE 0E 53 ";
            S = S + "C3 15 54 54 52 A4 E9 00 41 53 C5 C9 53 41 56 C5 ";
            S = S + "D0 4C 4F 41 C4 CF 45 45 D0 C0 49 4E A4 1D 00 41 ";
            S = S + "4C CC CA 4C 4F 53 C5 B4 4F 50 D9 D6 4F 4E D4 99 ";
            S = S + "4C 45 41 D2 92 4C 4F 41 C4 9B 53 41 56 C5 9A 53 ";
            S = S + "52 4C 49 CE E8 49 4E D4 1E 53 4E C7 1F 44 42 CC ";
            S = S + "20 56 C9 28 56 D3 29 56 C4 2A 4F D3 0C 48 52 A4 ";
            S = S + "16 49 52 43 4C C5 BC 4F 4C 4F D2 BD 4C D3 9F 4D ";
            S = S + "C4 D7 00 45 4C 45 54 C5 A8 41 54 C1 84 49 CD 86 ";
            S = S + "45 46 53 54 D2 AB 45 46 49 4E D4 AC 45 46 53 4E ";
            S = S + "C7 AD 45 46 44 42 CC AE 53 4B 4F A4 D1 45 C6 97 ";
            S = S + "53 4B 49 A4 EA 53 4B C6 26 52 41 D7 BE 00 4C 53 ";
            S = S + "C5 A1 4E C4 81 52 41 53 C5 A5 52 52 4F D2 A6 52 ";
            S = S + "CC E1 52 D2 E2 58 D0 0B 4F C6 2B 51 D6 F9 00 4F ";
            S = S + "D2 82 49 45 4C C4 B1 49 4C 45 D3 B7 CE DE 52 C5 ";
            S = S + "0F 49 D8 21 50 4F D3 27 00 4F 54 CF 89 4F 20 54 ";
            S = S + "CF 89 4F 53 55 C2 8D 45 D4 B2 00 45 58 A4 1B 00 ";
            S = S + "4E 50 55 D4 85 C6 8B 4E 53 54 D2 E5 4E D4 05 4E ";
            S = S + "D0 10 4D D0 FA 4E 4B 45 59 A4 EC 50 CC D5 00 00 ";
            S = S + "49 4C CC D4 45 D9 CC 00 50 52 49 4E D4 9D 4C 49 ";
            S = S + "53 D4 9E 50 4F D3 1C 45 D4 88 4F 43 41 54 C5 D8 ";
            S = S + "49 4E C5 AF 4F 41 C4 B5 53 45 D4 B8 49 53 D4 93 ";
            S = S + "46 49 4C 45 D3 BB 4F C7 0A 4F C3 2C 45 CE 12 45 ";
            S = S + "46 54 A4 01 4F C6 2D 00 4F 54 4F D2 CE 45 52 47 ";
            S = S + "C5 B6 4F C4 FB 4B 49 A4 2E 4B 53 A4 2F 4B 44 A4 ";
            S = S + "30 49 44 A4 03 41 D8 CD 00 45 58 D4 83 41 4D C5 ";
            S = S + "D3 45 D7 94 4F D4 E0 00 50 45 CE B0 55 D4 9C CE ";
            S = S + "95 D2 F7 43 54 A4 1A 46 C6 EB 00 52 49 4E D4 91 ";
            S = S + "55 D4 B3 4F 4B C5 98 4F D3 11 45 45 CB 17 53 45 ";
            S = S + "D4 C2 52 45 53 45 D4 C3 4F 49 4E D4 ED 41 49 4E ";
            S = S + "D4 BF 44 CC 24 41 C4 25 4C 41 D9 C1 00 00 45 54 ";
            S = S + "55 52 CE 8E 45 41 C4 87 55 CE 8A 45 53 54 4F 52 ";
            S = S + "C5 8C 45 CD 8F 45 53 55 4D C5 A7 53 45 D4 B9 49 ";
            S = S + "47 48 54 A4 02 4E C4 08 45 4E 55 CD AA 00 43 52 ";
            S = S + "45 45 CE C5 50 52 49 54 C5 C7 54 4F D0 90 57 41 ";
            S = S + "D0 A4 45 D4 D2 41 56 C5 BA 50 43 A8 DF 54 45 D0 ";
            S = S + "DC 47 CE 04 51 D2 07 49 CE 09 54 52 A4 13 54 52 ";
            S = S + "49 4E 47 A4 E3 50 41 43 45 A4 19 4F 55 4E C4 C4 ";
            S = S + "54 49 43 CB 22 54 52 49 C7 23 00 48 45 CE DA 52 ";
            S = S + "4F CE A2 52 4F 46 C6 A3 41 42 A8 DB CF D9 49 4D ";
            S = S + "C5 CB 41 CE 0D 00 53 49 4E C7 E4 53 D2 DD 00 41 ";
            S = S + "CC 14 41 52 50 54 D2 E7 44 D0 C8 50 4F 4B C5 C6 ";
            S = S + "50 45 45 CB 18 00 49 44 54 C8 A0 41 49 D4 96 00 ";
            S = S + "4F D2 F8 00 00 00 AB F1 AD F2 AA F3 AF F4 DE F5 ";
            S = S + "DC FC A7 E6 BE EE BD EF BC F0 00 79 79 7C 7C 7F ";
            S = S + "50 46 3C 32 28 7A 7B 3A 30 00 00 8A 2F 58 30 B2 ";
            S = S + "2F 9A 26 8C 26 E6 27 9F 28 D7 37 83 2F 4E 32 57 ";
            S = S + "32 5C 32 67 32 C8 37 21 2F 72 31 67 31 93 31 B8 ";
            S = S + "4D 3F 38 4D 2F 00 4E 45 58 54 20 77 69 74 68 6F ";
            S = S + "75 74 20 46 4F 52 00 53 79 6E 74 61 78 20 65 72 ";
            S = S + "72 6F 72 00 52 45 54 55 52 4E 20 77 69 74 68 6F ";
            S = S + "75 74 20 47 4F 53 55 42 00 4F 75 74 20 6F 66 20 ";
            S = S + "44 41 54 41 00 49 6C 6C 65 67 61 6C 20 66 75 6E ";
            S = S + "63 74 69 6F 6E 20 63 61 6C 6C 00 4F 76 65 72 66 ";
            S = S + "6C 6F 77 00 4F 75 74 20 6F 66 20 6D 65 6D 6F 72 ";
            S = S + "79 00 55 6E 64 65 66 69 6E 65 64 20 6C 69 6E 65 ";
            S = S + "20 6E 75 6D 62 65 72 00 53 75 62 73 63 72 69 70 ";
            S = S + "74 20 6F 75 74 20 6F 66 20 72 61 6E 67 65 00 52 ";
            S = S + "65 64 69 6D 65 6E 73 69 6F 6E 65 64 20 61 72 72 ";
            S = S + "61 79 00 44 69 76 69 73 69 6F 6E 20 62 79 20 7A ";
            S = S + "65 72 6F 00 49 6C 6C 65 67 61 6C 20 64 69 72 65 ";
            S = S + "63 74 00 54 79 70 65 20 6D 69 73 6D 61 74 63 68 ";
            S = S + "00 4F 75 74 20 6F 66 20 73 74 72 69 6E 67 20 73 ";
            S = S + "70 61 63 65 00 53 74 72 69 6E 67 20 74 6F 6F 20 ";
            S = S + "6C 6F 6E 67 00 53 74 72 69 6E 67 20 66 6F 72 6D ";
            S = S + "75 6C 61 20 74 6F 6F 20 63 6F 6D 70 6C 65 78 00 ";
            S = S + "43 61 6E 27 74 20 43 4F 4E 54 49 4E 55 45 00 55 ";
            S = S + "6E 64 65 66 69 6E 65 64 20 75 73 65 72 20 66 75 ";
            S = S + "6E 63 74 69 6F 6E 00 44 65 76 69 63 65 20 49 2F ";
            S = S + "4F 20 65 72 72 6F 72 00 56 65 72 69 66 79 20 65 ";
            S = S + "72 72 6F 72 00 4E 6F 20 52 45 53 55 4D 45 00 52 ";
            S = S + "45 53 55 4D 45 20 77 69 74 68 6F 75 74 20 65 72 ";
            S = S + "72 6F 72 00 55 6E 70 72 69 6E 74 61 62 6C 65 20 ";
            S = S + "65 72 72 6F 72 00 4D 69 73 73 69 6E 67 20 6F 70 ";
            S = S + "65 72 61 6E 64 00 4C 69 6E 65 20 62 75 66 66 65 ";
            S = S + "72 20 6F 76 65 72 66 6C 6F 77 00 46 49 45 4C 44 ";
            S = S + "20 6F 76 65 72 66 6C 6F 77 00 49 6E 74 65 72 6E ";
            S = S + "61 6C 20 65 72 72 6F 72 00 42 61 64 20 66 69 6C ";
            S = S + "65 20 6E 75 6D 62 65 72 00 46 69 6C 65 20 6E 6F ";
            S = S + "74 20 66 6F 75 6E 64 00 46 69 6C 65 20 61 6C 72 ";
            S = S + "65 61 64 79 20 6F 70 65 6E 00 49 6E 70 75 74 20 ";
            S = S + "70 61 73 74 20 65 6E 64 00 42 61 64 20 66 69 6C ";
            S = S + "65 20 6E 61 6D 65 00 44 69 72 65 63 74 20 73 74 ";
            S = S + "61 74 65 6D 65 6E 74 20 69 6E 20 66 69 6C 65 00 ";
            S = S + "53 65 71 75 65 6E 74 69 61 6C 20 49 2F 4F 20 6F ";
            S = S + "6E 6C 79 00 46 69 6C 65 20 6E 6F 74 20 4F 50 45 ";
            S = S + "4E 00 20 69 6E 20 00 4F 6B 0D 0A 00 42 72 65 61 ";
            S = S + "6B 00 21 04 00 39 7E 23 FE 82 C0 4E 23 46 23 E5 ";
            S = S + "60 69 7A B3 EB 28 02 EB E7 01 16 00 E1 C8 09 18 ";

            return S;
        }

         public static string gs_Get_MSX2_BASIC()
        {
            string S;

            S = "";

          //== MSX2 BASIC [4000H~7FFFH,4000H,16384] ==
            S = S + "E5 CD 39 54 44 4D ED 78 C3 CF 4F CD 2F 54 D5 CF ";
            S = S + "2C CD 1C 52 C1 C9 CD 0B 40 ED 79 C9 CD 0B 40 C5 ";
            S = S + "F5 1E 00 2B D7 28 05 CF 2C CD 1C 52 F1 57 C1 CD ";
            S = S + "BD 00 ED 78 AB A2 28 F7 C9 CD F8 FE 2A 1C F4 7C ";
            S = S + "A5 3C 28 08 3A BB F6 B7 1E 15 20 23 C3 01 64 2A ";
            S = S + "A3 F6 22 1C F4 1E 02 01 1E 0B 01 1E 01 01 1E 0A ";
            S = S + "01 1E 12 01 1E 16 01 1E 06 01 1E 18 01 1E 0D CD ";
            S = S + "B1 FF AF CD 87 79 2A 19 F4 7C B5 28 0A 3A 1B F4 ";
            S = S + "77 21 00 00 22 19 F4 FB 2A 1C F4 22 B3 F6 7C A5 ";
            S = S + "3C 28 03 22 B5 F6 01 A4 40 18 03 01 1E 41 2A B1 ";
            S = S + "F6 C3 F0 62 C1 7B 4B 32 14 F4 2A AF F6 22 B7 F6 ";
            S = S + "EB 2A B3 F6 7C A5 3C 28 07 22 BE F6 EB 22 C0 F6 ";
            S = S + "2A B9 F6 7C B5 EB 21 BB F6 28 08 A6 20 05 35 EB ";
            S = S + "C3 20 46 AF 77 59 CD 23 73 21 75 3D CD FD FE 7B ";
            S = S + "FE 3C 30 08 FE 32 30 06 FE 1A 38 05 3E 2F D6 18 ";
            S = S + "5F CD 5D 48 23 1D 20 F9 E5 2A B3 F6 E3 CD 02 FF ";
            S = S + "E5 CD D2 00 E1 7E FE 3F 20 06 E1 21 75 3D 18 DC ";
            S = S + "CD 78 66 3E 07 DF E1 7C A5 3C C4 0A 34 3E C1 CD ";
            S = S + "D2 00 CD 04 73 CD 7B 6D CD 07 FF CD E8 7B 00 00 ";
            S = S + "00 00 00 00 CD 0C FF 21 FF FF 22 1C F4 21 0F F4 ";
            S = S + "22 AF F6 3A AA F6 B7 28 16 2A AB F6 E5 CD 12 34 ";
            S = S + "D1 D5 CD 95 42 3E 2A 38 02 3E 20 DF 32 AA F6 CD ";
            S = S + "4A 01 20 0C CD AE 00 30 0A AF 32 AA F6 C3 34 41 ";
            S = S + "CD 74 73 D7 3C 3D 28 BC F5 CD 69 47 30 06 CD 4A ";
            S = S + "01 CA 55 40 CD 14 45 3A AA F6 B7 28 08 FE 2A 20 ";
            S = S + "04 BE 20 01 23 7A B3 28 06 7E FE 20 20 01 23 D5 ";
            S = S + "CD B2 42 D1 F1 22 AF F6 CD 11 FF 38 07 AF 32 AA ";
            S = S + "F6 C3 48 6D D5 C5 D7 B7 F5 3A AA F6 A7 28 03 F1 ";
            S = S + "37 F5 ED 53 B5 F6 2A AD F6 19 38 0B D5 11 FA FF ";
            S = S + "E7 D1 22 AB F6 38 04 AF 32 AA F6 CD 95 42 38 0D ";
            S = S + "F1 F5 20 06 D2 1C 48 C5 18 4D B7 18 07 F1 F5 20 ";
            S = S + "02 38 F4 37 C5 F5 E5 CD EA 54 E1 F1 C1 C5 DC 05 ";
            S = S + "54 D1 F1 D5 28 31 D1 21 00 00 22 B9 F6 2A C2 F6 ";
            S = S + "E3 C1 E5 09 E5 CD 50 62 E1 22 C2 F6 EB 74 C1 D1 ";
            S = S + "E5 23 23 73 23 72 23 11 1F F4 0B 0B 0B 0B 1A 77 ";
            S = S + "23 13 0B 79 B0 20 F7 CD 16 FF D1 CD A1 79 2A 64 ";
            S = S + "F8 22 BC F6 CD 9A 62 CD 1B FF 2A BC F6 22 64 F8 ";
            S = S + "C3 34 41 2A 76 F6 EB 62 6B 7E 23 B6 C8 23 23 23 ";
            S = S + "7E B7 28 0E FE 20 30 F7 FE 0B 38 F3 CD 6A 46 D7 ";
            S = S + "18 EF 23 EB 73 23 72 18 DE 11 00 00 D5 28 09 D1 ";
            S = S + "CD 5F 47 D5 28 0B CF F2 11 FA FF C4 5F 47 C2 55 ";
            S = S + "40 EB D1 E3 E5 2A 76 F6 44 4D 7E 23 B6 2B C8 23 ";
            S = S + "23 7E 23 66 6F E7 60 69 7E 23 66 6F 3F C8 3F D0 ";
            S = S + "18 E6 AF 32 65 F6 32 64 F6 CD 20 FF 01 3B 01 11 ";
            S = S + "1F F4 7E B7 20 13 21 40 01 7D 91 4F 7C 98 47 21 ";
            S = S + "1E F4 AF 12 13 12 13 12 C9 FE 22 CA 16 43 FE 20 ";
            S = S + "28 07 3A 64 F6 B7 7E 28 3D 23 F5 FE 01 20 04 7E ";
            S = S + "A7 3E 01 C4 E0 44 F1 D6 3A 28 06 FE 4A 20 08 3E ";
            S = S + "01 32 64 F6 32 65 F6 D6 55 20 B7 F5 7E B7 E3 7C ";
            S = S + "E1 28 B3 BE 28 D3 F5 7E 23 FE 01 20 04 7E A7 3E ";
            S = S + "01 C4 E0 44 18 E6 23 B7 FA C2 42 FE 01 20 07 7E ";
            S = S + "A7 28 93 23 18 8C 2B FE 3F 3E 91 D5 C5 CA A3 43 ";
            S = S + "7E FE 5F CA A3 43 11 26 3D CD A9 4E CD A8 64 DA ";
            S = S + "1D 44 E5 CD 25 FF 21 3E 3A D6 41 87 4F 06 00 09 ";
            S = S + "5E 23 56 E1 23 E5 CD A9 4E 4F 1A E6 7F CA EB 44 ";
            S = S + "23 B9 20 24 1A 13 B7 F2 66 43 F1 1A CD 2A FF B7 ";
            S = S + "FA A2 43 C1 D1 F6 80 F5 3E FF CD E0 44 AF 32 65 ";
            S = S + "F6 F1 CD E0 44 C3 C2 42 E1 1A 13 B7 F2 99 43 13 ";
            S = S + "18 C3 2B F5 CD 2F FF 11 B5 43 4F 1A B7 28 15 13 ";
            S = S + "B9 20 F8 18 11 8C A9 AA A8 A7 E1 A1 8A 93 9E 89 ";
            S = S + "8E DA 8D 00 AF C2 3E 01 32 65 F6 F1 C1 D1 FE A1 ";
            S = S + "F5 CC DE 44 F1 FE CA 28 04 FE 5F 20 29 D4 E0 44 ";
            S = S + "23 CD A9 4E A7 CA C6 42 FA E0 43 FE 01 20 07 23 ";
            S = S + "7E A7 28 F1 18 EA FE 20 28 E3 FE 3A 28 3C FE 28 ";
            S = S + "28 38 FE 30 18 D7 FE E6 C2 B4 44 F5 CD DE 44 3E ";
            S = S + "8F CD E0 44 F1 E5 21 00 00 E3 C3 18 43 7E FE 2E ";
            S = S + "28 0A FE 3A D2 A2 44 FE 30 DA A2 44 3A 65 F6 B7 ";
            S = S + "7E C1 D1 FA E9 42 28 1F FE 2E CA E9 42 3E 0E CD ";
            S = S + "E0 44 D5 CD 69 47 CD 14 45 E3 EB 7D CD E0 44 7C ";
            S = S + "E1 CD E0 44 C3 C2 42 D5 C5 7E CD 99 32 CD 14 45 ";
            S = S + "C1 D1 E5 3A 63 F6 FE 02 20 15 2A F8 F7 7C B7 3E ";
            S = S + "02 20 0C 7D 65 2E 0F FE 0A 30 D0 C6 11 18 D1 F5 ";
            S = S + "0F C6 1B CD E0 44 21 F6 F7 3A 63 F6 FE 02 20 03 ";
            S = S + "21 F8 F7 F1 F5 7E CD E0 44 F1 23 3D 20 F6 E1 C3 ";
            S = S + "C2 42 11 25 3D 13 1A E6 7F CA FA 44 13 BE 1A 20 ";
            S = S + "F4 C3 09 45 FE 26 C2 E9 42 E5 D7 E1 CD AA 4E FE ";
            S = S + "48 28 0D FE 4F 28 05 3E 26 C3 E9 42 3E 0B 18 02 ";
            S = S + "3E 0C CD E0 44 D5 C5 CD B8 4E C1 C3 49 44 3E 3A ";
            S = S + "12 13 0B 79 B0 C0 1E 19 C3 6F 40 CD 34 FF E1 2B ";
            S = S + "3D 32 65 F6 CD A9 4E C3 CC 43 7E FE 20 30 0A FE ";
            S = S + "09 28 06 FE 0A 28 02 3E 20 F5 3A 65 F6 3C 28 01 ";
            S = S + "3D C3 C8 43 2B 7E FE 20 28 FA FE 09 28 F6 FE 0A ";
            S = S + "28 F2 23 C9 3E 64 32 A5 F6 CD 80 48 C1 E5 CD 5B ";
            S = S + "48 22 A1 F6 21 02 00 39 CD E6 3F 20 17 09 D5 2B ";
            S = S + "56 2B 5E 23 23 E5 2A A1 F6 E7 E1 D1 20 EA D1 F9 ";
            S = S + "22 B1 F6 0E D1 EB 0E 0C CD 5E 62 E5 2A A1 F6 E3 ";
            S = S + "E5 2A 1C F4 E3 CF D9 EF CA 6D 40 F5 CD 64 4C F1 ";
            S = S + "E5 30 18 F2 C2 45 CD 8A 2F E3 11 01 00 7E FE DC ";
            S = S + "CC 0E 52 D5 E5 EB CD AB 2E 18 5D CD 3A 30 D1 21 ";
            S = S + "F8 FF 39 F9 D5 CD 10 2F E1 7E FE DC 11 1B 2D 3E ";
            S = S + "01 20 0F D7 CD 64 4C E5 CD 3A 30 CD 71 2E 11 F6 ";
            S = S + "F7 E1 44 4D 21 F8 FF 39 F9 F5 C5 CD F3 2E E1 F1 ";
            S = S + "18 2D CD B2 2F CD CC 2E E1 C5 D5 01 41 10 11 00 ";
            S = S + "00 CD 39 FF 7E FE DC 3E 01 20 0E CD 65 4C E5 CD ";
            S = S + "B2 2F CD CC 2E CD 71 2E E1 D5 C5 C5 C5 C5 C5 B7 ";
            S = S + "20 02 3E 02 4F EF 47 C5 E5 2A A7 F6 E3 06 82 C5 ";
            S = S + "33 CD 3E FF ED 73 B1 F6 CD BA 00 3A D8 FB B7 C4 ";
            S = S + "89 63 FB 22 AF F6 7E FE 3A 28 25 B7 C2 55 40 23 ";
            S = S + "7E 23 B6 CA 39 40 23 5E 23 56 EB 22 1C F4 3A C4 ";
            S = S + "F7 B7 28 0B D5 3E 5B DF CD 12 34 3E 5D DF D1 EB ";
            S = S + "D7 11 01 46 D5 C8 CD 43 FF FE 5F CA A7 55 D6 81 ";
            S = S + "DA 80 48 FE 58 D2 AD 51 07 4F 06 00 EB 21 2E 39 ";
            S = S + "09 4E 23 46 C5 EB CD 48 FF 23 7E FE 3A D0 FE 20 ";
            S = S + "28 F4 30 6C B7 C8 FE 0B 38 61 FE 1E 20 05 3A 68 ";
            S = S + "F6 B7 C9 FE 10 28 34 F5 23 32 68 F6 D6 1C 30 30 ";
            S = S + "D6 F5 30 06 FE FE 20 16 7E 23 22 66 F6 26 00 6F ";
            S = S + "22 6A F6 3E 02 32 69 F6 21 E6 46 F1 B7 C9 7E 23 ";
            S = S + "23 22 66 F6 2B 66 18 E7 CD E8 46 2A 66 F6 18 AA ";
            S = S + "3C 07 32 69 F6 D5 C5 11 6A F6 EB 47 CD F7 2E EB ";
            S = S + "C1 D1 22 66 F6 F1 21 E6 46 B7 C9 FE 09 D2 66 46 ";
            S = S + "FE 30 3F 3C 3D C9 1E 10 3A 68 F6 FE 0F 30 13 FE ";
            S = S + "0D 38 0F 2A 6A F6 20 07 23 23 23 5E 23 56 EB C3 ";
            S = S + "36 32 3A 69 F6 32 63 F6 FE 02 20 06 2A 6A F6 22 ";
            S = S + "F8 F7 21 6A F6 C3 08 2F 1E 03 01 1E 02 01 1E 04 ";
            S = S + "01 1E 08 CD A7 64 01 55 40 C5 D8 D6 41 4F 47 D7 ";
            S = S + "FE F2 20 09 D7 CD A7 64 D8 D6 41 47 D7 78 91 D8 ";
            S = S + "3C E3 21 CA F6 06 00 09 73 23 3D 20 FB E1 7E FE ";
            S = S + "2C C0 D7 18 CE D7 CD 0F 52 F0 1E 05 C3 6F 40 7E ";
            S = S + "FE 2E ED 5B B5 F6 CA 66 46 2B D7 FE 0E 28 02 FE ";
            S = S + "0D ED 5B 6A F6 CA 66 46 AF 32 68 F6 11 00 00 2B ";
            S = S + "D7 D0 E5 F5 21 98 19 E7 38 11 62 6B 19 29 19 29 ";
            S = S + "F1 D6 30 5F 16 00 19 EB E1 18 E5 F1 E1 C9 CA 9A ";
            S = S + "62 FE 0E 28 05 FE 0D C2 5B 6B CD A1 62 01 01 46 ";
            S = S + "18 35 0E 03 CD 5E 62 CD 69 47 C1 E5 E5 2A 1C F4 ";
            S = S + "E3 01 00 00 C5 01 01 46 3E 8D F5 33 C5 18 1C E5 ";
            S = S + "E5 2A 1C F4 E3 C5 3E 8D F5 33 EB 2B 22 AF F6 23 ";
            S = S + "ED 73 B1 F6 C3 20 46 C5 CD 69 47 3A 68 F6 FE 0D ";
            S = S + "EB C8 FE 0E C2 55 40 EB E5 2A 66 F6 E3 CD 5D 48 ";
            S = S + "23 E5 2A 1C F4 E7 E1 DC 98 42 D4 95 42 30 0D 0B ";
            S = S + "3E 0D 32 A9 F6 E1 CD 83 55 60 69 C9 1E 08 C3 6F ";
            S = S + "40 CD 4D FF 22 A7 F6 16 FF CD E2 3F FE 8D 28 01 ";
            S = S + "2B F9 22 B1 F6 1E 03 C2 6F 40 E1 7C B5 28 06 7E ";
            S = S + "E6 01 C4 3E 63 C1 21 01 46 E3 EB 2A A7 F6 2B D7 ";
            S = S + "C2 E8 47 60 69 22 1C F4 EB 3E E1 01 3A 0E 00 06 ";
            S = S + "00 79 48 47 2B D7 B7 C8 B8 C8 23 FE 22 28 F2 3C ";
            S = S + "28 F3 D6 8C 20 EE B8 8A 57 18 E9 F1 C6 03 18 12 ";
            S = S + "CD A4 5E CF EF ED 53 A7 F6 D5 3A 63 F6 F5 CD 64 ";
            S = S + "4C F1 E3 47 3A 63 F6 B8 78 28 06 CD 7A 51 3A 63 ";
            S = S + "F6 11 F6 F7 FE 02 20 03 11 F8 F7 E5 FE 03 20 2E ";
            S = S + "2A F8 F7 E5 23 5E 23 56 21 1E F4 E7 38 14 2A C6 ";
            S = S + "F6 E7 D1 30 15 21 97 F6 E7 38 06 21 79 F6 E7 38 ";
            S = S + "09 3E D1 CD EE 67 EB CD 11 66 CD EE 67 E3 CD F3 ";
            S = S + "2E D1 E1 C9 FE A6 20 25 D7 CF 89 CD 69 47 7A B3 ";
            S = S + "28 09 CD 93 42 50 59 E1 D2 1C 48 ED 53 B9 F6 D8 ";
            S = S + "3A BB F6 B7 7B C8 3A 14 F4 5F C3 96 40 CD 10 78 ";
            S = S + "38 31 C5 D7 CF 8D AF C1 C5 B9 D2 55 40 F5 CD 69 ";
            S = S + "47 7A B3 28 09 CD 93 42 50 59 E1 D2 1C 48 F1 C1 ";
            S = S + "F5 80 C5 CD 5C 78 2B D7 C1 D1 C8 C5 D5 CF 2C F1 ";
            S = S + "3C 18 D4 CD 1C 52 7E 47 FE 8D 28 03 CF 89 2B 4B ";
            S = S + "0D 78 CA 46 46 CD 6A 47 FE 2C C0 18 F3 3A BB F6 ";
            S = S + "B7 20 09 32 B9 F6 32 BA F6 C3 64 40 3C 32 14 F4 ";
            S = S + "7E FE 83 28 10 CD 69 47 C0 7A B3 28 0C CD EB 47 ";
            S = S + "AF 32 BB F6 C9 D7 C0 18 05 AF 32 BB F6 3C 2A B7 ";
            S = S + "F6 EB 2A B3 F6 22 1C F4 EB C0 7E B7 20 04 23 23 ";
            S = S + "23 23 23 AF 32 BB F6 C3 5B 48 CD 1C 52 C0 B7 CA ";
            S = S + "5A 47 C3 6F 40 11 0A 00 D5 28 16 CD 5F 47 EB E3 ";
            S = S + "28 10 EB CF 2C ED 5B AD F6 28 06 CD 69 47 C2 55 ";
            S = S + "40 EB 7C B5 CA 5A 47 22 AD F6 32 AA F6 E1 22 AB ";
            S = S + "F6 C1 C3 34 41 CD 64 4C 7E FE 2C CC 66 46 FE 89 ";
            S = S + "28 03 CF DA 2B E5 CD A1 2E E1 28 10 D7 C8 FE 0E ";
            S = S + "CA E8 47 FE 0D C2 46 46 2A 6A F6 C9 16 01 CD 5B ";
            S = S + "48 B7 C8 D7 FE A1 20 F6 15 20 F3 18 DF 3E 01 32 ";
            S = S + "16 F4 18 05 0E 02 CD 57 6D 2B D7 CC 28 73 CA FF ";
            S = S + "4A FE E4 CA B1 60 FE DB CA C6 4A FE DF CA C6 4A ";
            S = S + "E5 FE 2C 28 4F FE 3B CA FA 4A C1 CD 64 4C E5 EF ";
            S = S + "28 3B CD 25 34 CD 35 66 36 20 2A F8 F7 34 CD 52 ";
            S = S + "FF CD 4A 01 20 23 2A F8 F7 3A 16 F4 B7 28 08 3A ";
            S = S + "15 F4 86 FE FF 18 0A 3A B0 F3 47 3A 61 F6 86 3D ";
            S = S + "B8 38 06 CC 31 73 C4 28 73 CD 7B 66 B7 CC 7B 66 ";
            S = S + "E1 C3 29 4A CD 57 FF 01 08 00 2A 64 F8 09 CD 4A ";
            S = S + "01 7E 20 1B 3A 16 F4 B7 28 07 3A 15 F4 FE EE 18 ";
            S = S + "08 3A B2 F3 47 3A 61 F6 B8 D4 28 73 D2 FA 4A D6 ";
            S = S + "0E 30 FC 2F 18 2D F5 CD 1B 52 CF 29 2B F1 D6 DF ";
            S = S + "E5 28 1C 01 08 00 2A 64 F8 09 CD 4A 01 7E 20 0F ";
            S = S + "3A 16 F4 B7 CA EC 4A 3A 15 F4 18 03 3A 61 F6 2F ";
            S = S + "83 30 07 3C 47 3E 20 DF 10 FD E1 D7 C3 2E 4A CD ";
            S = S + "5C FF AF 32 16 F4 E5 67 6F 22 64 F8 E1 C9 FE 85 ";
            S = S + "C2 A7 58 CF 85 FE 23 CA 8F 6D CD 7B 4B CD A4 5E ";
            S = S + "CD 58 30 D5 E5 CD B1 00 D1 C1 DA FE 63 C5 D5 06 ";
            S = S + "00 CD 38 66 E1 3E 03 C3 92 48 3F 52 65 64 6F 20 ";
            S = S + "66 72 6F 6D 20 73 74 61 72 74 0D 0A 00 CD 61 FF ";
            S = S + "3A A6 F6 B7 C2 4F 40 C1 21 3A 4B CD 78 66 2A AF ";
            S = S + "F6 C9 CD 55 6D E5 21 5D F5 C3 9B 4B FE 23 28 F2 ";
            S = S + "E5 F5 CD D2 00 F1 E1 01 8B 4B C5 FE 22 3E 00 C0 ";
            S = S + "CD 36 66 CF 3B E5 CD 7B 66 E1 C9 E5 CD B4 00 C1 ";
            S = S + "DA FE 63 23 7E B7 2B C5 CA 5A 48 36 2C 18 05 E5 ";
            S = S + "2A C8 F6 F6 AF 32 A6 F6 E3 01 CF 2C CD A4 5E E3 ";
            S = S + "D5 7E FE 2C 28 1B 3A A6 F6 B7 C2 40 4C 3E 3F DF ";
            S = S + "CD B4 00 D1 C1 DA FE 63 23 7E 2B B7 C5 CA 5A 48 ";
            S = S + "D5 CD 4A 01 C2 83 6D EF F5 20 22 D7 57 47 FE 22 ";
            S = S + "28 0C 3A A6 F6 B7 57 28 02 16 3A 06 2C 2B CD 39 ";
            S = S + "66 F1 C6 03 EB 21 05 4C E3 D5 C3 93 48 D7 01 F1 ";
            S = S + "4B C5 C3 99 32 2B D7 28 05 FE 2C C2 4D 4B E3 2B ";
            S = S + "D7 C2 AA 4B D1 3A A6 F6 B7 EB C2 DE 63 D5 CD 4A ";
            S = S + "01 20 08 7E B7 21 2F 4C C4 78 66 E1 C3 FF 4A 3F ";
            S = S + "45 78 74 72 61 20 69 67 6E 6F 72 65 64 0D 0A 00 ";
            S = S + "CD 5B 48 B7 20 11 23 7E 23 B6 1E 04 CA 6F 40 23 ";
            S = S + "5E 23 56 ED 53 A3 F6 D7 FE 84 20 E4 C3 D1 4B CF ";
            S = S + "EF 01 CF 28 2B 16 00 D5 0E 01 CD 5E 62 CD 66 FF ";
            S = S + "CD C7 4D 22 BC F6 2A BC F6 C1 7E 22 9D F6 FE EE ";
            S = S + "D8 FE F1 38 5F D6 F1 5F 20 09 3A 63 F6 FE 03 7B ";
            S = S + "CA 87 67 FE 0C D0 21 3B 3D 16 00 19 78 56 BA D0 ";
            S = S + "C5 01 76 4C C5 7A CD 6B FF FE 51 38 50 E6 FE FE ";
            S = S + "7A 28 4A 21 F8 F7 3A 63 F6 D6 03 CA 6D 40 B7 2A ";
            S = S + "F8 F7 E5 FA D5 4C 2A F6 F7 E5 E2 D5 4C 2A FC F7 ";
            S = S + "E5 2A FA F7 E5 C6 03 4B 47 C5 01 22 4D C5 2A 9D ";
            S = S + "F6 C3 67 4C 16 00 D6 EE 38 1E FE 03 30 1A FE 01 ";
            S = S + "17 AA BA 57 DA 55 40 22 9D F6 D7 18 E9 D5 CD 8A ";
            S = S + "2F D1 E5 01 78 4F 18 D5 78 FE 64 D0 C5 D5 11 05 ";
            S = S + "64 21 57 4F E5 EF C2 B3 4C 2A F8 F7 E5 01 C8 65 ";
            S = S + "18 BB C1 79 32 64 F6 3A 63 F6 B8 20 0B FE 02 28 ";
            S = S + "1F FE 04 CA 9D 4D 30 2B 57 78 FE 08 28 22 7A FE ";
            S = S + "08 28 44 78 FE 04 28 52 7A FE 03 CA 6D 40 30 54 ";
            S = S + "21 69 3D 06 00 09 09 4E 23 46 D1 2A F8 F7 C5 C9 ";
            S = S + "CD 3A 30 CD 0D 2F E1 22 FA F7 E1 22 FC F7 C1 D1 ";
            S = S + "CD C1 2E CD 3A 30 21 51 3D 3A 64 F6 07 85 6F 8C ";
            S = S + "95 67 7E 23 66 6F E9 78 F5 CD 0D 2F F1 32 63 F6 ";
            S = S + "FE 04 28 DA E1 22 F8 F7 18 D9 CD B2 2F C1 D1 21 ";
            S = S + "5D 3D 18 D5 E1 CD B1 2E CD CB 2F CD CC 2E E1 22 ";
            S = S + "F6 F7 E1 22 F8 F7 18 E7 E5 EB CD CB 2F E1 CD B1 ";
            S = S + "2E CD CB 2F C3 65 32 D7 CA 6A 40 DA 99 32 CD A8 ";
            S = S + "64 D2 9B 4E FE 20 DA B8 46 CD 70 FF 3C CA FC 4E ";
            S = S + "3D FE F1 28 E2 FE F2 CA 8D 4E FE 22 CA 36 66 FE ";
            S = S + "E0 CA 63 4F FE 26 CA B8 4E FE E2 20 0A D7 3A 14 ";
            S = S + "F4 E5 CD CF 4F E1 C9 FE E1 20 0A D7 E5 2A B3 F6 ";
            S = S + "CD 36 32 E1 C9 FE ED CA 03 58 FE CB CA 00 79 FE ";
            S = S + "C7 CA 84 7A FE C8 CA 47 7B FE C9 CA CB 7B FE C1 ";
            S = S + "CA 1B 79 FE EA CA 3E 7C FE E9 CA 43 7C FE E7 20 ";
            S = S + "23 D7 CF 28 FE 23 20 0B CD 1B 52 E5 CD 6D 6A EB ";
            S = S + "E1 18 03 CD 5D 5F CF 29 E5 EB 7C B5 CA 5A 47 CD ";
            S = S + "99 2F E1 C9 FE DD CA D5 4F FE E5 CA EB 68 FE EC ";
            S = S + "CA 47 73 FE E3 CA 29 68 FE 85 CA 87 6C FE E8 CA ";
            S = S + "0A 79 FE DE CA 40 50 CD 62 4C CF 29 C9 16 7D CD ";
            S = S + "67 4C 2A BC F6 E5 CD 86 2E E1 C9 CD A4 5E E5 EB ";
            S = S + "22 F8 F7 EF C4 08 2F E1 C9 7E FE 61 D8 FE 7B D0 ";
            S = S + "E6 5F C9 FE 26 C2 69 47 11 00 00 D7 CD AA 4E 01 ";
            S = S + "02 01 FE 42 28 0F 01 08 03 FE 4F 28 08 01 10 04 ";
            S = S + "FE 48 C2 55 40 23 7E EB CD AA 4E FE 3A 38 06 FE ";
            S = S + "41 38 14 D6 07 D6 30 B9 30 0D C5 29 DA 67 40 10 ";
            S = S + "FA C1 B5 6F EB 18 DE CD 99 2F EB C9 23 7E D6 81 ";
            S = S + "06 00 07 4F C5 D7 79 FE 05 30 16 CD 62 4C CF 2C ";
            S = S + "CD 58 30 EB 2A F8 F7 E3 E5 EB CD 1C 52 EB E3 18 ";
            S = S + "1A CD 87 4E E3 7D FE 0C 38 0D FE 1B CD 75 FF 30 ";
            S = S + "06 EF E5 DC 3A 30 E1 11 99 4E D5 01 DE 39 CD 7A ";
            S = S + "FF 09 4E 23 66 69 E9 15 FE F2 C8 FE 2D C8 14 FE ";
            S = S + "2B C8 FE F1 C8 2B C9 3C 8F C1 A0 C6 FF 9F CD 9A ";
            S = S + "2E 18 12 16 5A CD 67 4C CD 8A 2F 7D 2F 6F 7C 2F ";
            S = S + "67 22 F8 F7 C1 C3 76 4C 78 F5 CD 8A 2F F1 D1 FE ";
            S = S + "7A CA 3A 32 FE 7B CA E6 31 01 D1 4F C5 FE 46 20 ";
            S = S + "06 7B B5 6F 7C B2 C9 FE 50 20 06 7B A5 6F 7C A2 ";
            S = S + "C9 FE 3C 20 06 7B AD 6F 7C AA C9 FE 32 20 08 7B ";
            S = S + "AD 2F 6F 7C AA 2F C9 7D 2F A3 2F 6F 7C 2F A2 2F ";
            S = S + "C9 B7 ED 52 C3 36 32 3A 15 F4 18 03 3A 61 F6 6F ";
            S = S + "AF 67 C3 99 2F CD F4 4F D5 CD 87 4E E3 5E 23 56 ";
            S = S + "21 97 32 E5 D5 3A 63 F6 F5 FE 03 CC D3 67 F1 EB ";
            S = S + "21 F6 F7 C9 D7 01 00 00 FE 1B 30 0B FE 11 38 07 ";
            S = S + "D7 3A 6A F6 B7 17 4F EB 21 9A F3 09 EB C9 CD F4 ";
            S = S + "4F D5 CF EF CD 2F 54 E3 73 23 72 E1 C9 FE DD 28 ";
            S = S + "ED CD A1 51 CD 93 51 EB 73 23 72 EB 7E FE 28 C2 ";
            S = S + "5B 48 D7 CD A4 5E 7E FE 29 CA 5B 48 CF 2C 18 F3 ";
            S = S + "CD A1 51 3A 63 F6 B7 F5 22 BC F6 EB 7E 23 66 6F ";
            S = S + "7C B5 CA 61 40 7E FE 28 C2 F4 50 D7 22 9D F6 EB ";
            S = S + "2A BC F6 CF 28 AF F5 E5 EB 3E 80 32 A5 F6 CD A4 ";
            S = S + "5E EB E3 3A 63 F6 F5 D5 CD 64 4C 22 BC F6 E1 22 ";
            S = S + "9D F6 F1 CD 7A 51 0E 04 CD 5E 62 21 F8 FF 39 F9 ";
            S = S + "CD 10 2F 3A 63 F6 F5 2A BC F6 7E FE 29 28 0E CF ";
            S = S + "2C E5 2A 9D F6 CF 2C 18 C0 F1 32 4E F7 F1 B7 28 ";
            S = S + "38 32 63 F6 21 00 00 39 CD 08 2F 21 08 00 39 F9 ";
            S = S + "D1 2E 03 1B 1B 1B 3A 63 F6 85 47 3A 4E F7 4F 80 ";
            S = S + "FE 64 D2 5A 47 F5 7D 06 00 21 50 F7 09 4F CD 8E ";
            S = S + "51 01 A9 50 C5 C5 C3 9E 48 2A BC F6 D7 E5 2A 9D ";
            S = S + "F6 CF 29 3E D5 22 9D F6 3A E6 F6 C6 04 F5 0F 4F ";
            S = S + "CD 5E 62 F1 4F 2F 3C 6F 26 FF 39 F9 E5 11 E4 F6 ";
            S = S + "CD 8E 51 E1 22 E4 F6 2A 4E F7 22 E6 F6 44 4D 21 ";
            S = S + "E8 F6 11 50 F7 CD 8E 51 67 6F 22 4E F7 2A BA F7 ";
            S = S + "23 22 BA F7 7C B5 32 B7 F7 2A 9D F6 CD 5F 4C 2B ";
            S = S + "D7 C2 55 40 EF 20 0F 11 98 F6 2A F8 F7 E7 38 06 ";
            S = S + "CD 11 66 CD 58 66 2A E4 F6 54 5D 23 23 4E 23 46 ";
            S = S + "03 03 03 03 21 E4 F6 CD 8E 51 EB F9 2A BA F7 2B ";
            S = S + "22 BA F7 7C B5 32 B7 F7 E1 F1 E5 E6 07 21 47 3D ";
            S = S + "4F 06 00 09 CD 41 4F E1 C9 1A 77 23 13 0B 78 B1 ";
            S = S + "20 F7 C9 E5 2A 1C F4 23 7C B5 E1 C0 1E 0C C3 6F ";
            S = S + "40 CF DE 3E 80 32 A5 F6 B6 4F C3 A9 5E FE 7E 20 ";
            S = S + "15 23 7E 23 FE 83 CA 6E 69 FE A3 CA BF 77 FE 85 ";
            S = S + "CA B1 77 CD 7F FF C3 55 40 CD 1C 52 CD 84 FF A7 ";
            S = S + "DD 21 5D 01 C3 5F 01 D3 A8 7E 2F 4F E6 FC B2 77 ";
            S = S + "7B E6 3F 57 78 E6 C0 B2 D3 A8 D9 ED B0 D9 7B D3 ";
            S = S + "A8 79 77 78 D3 A8 C9 F3 18 03 32 AE F3 3E 0C DF ";
            S = S + "7B D6 0E 30 FC C6 1C 2F 3C 83 32 B2 F3 C9 D7 CD ";
            S = S + "64 4C E5 CD 8A 2F EB E1 7A B7 C9 D7 CD 64 4C CD ";
            S = S + "12 52 C2 5A 47 2B D7 7B C9 3E 01 32 16 F4 CD 89 ";
            S = S + "FF C1 CD 79 42 C5 21 FF FF 22 1C F4 E1 D1 4E 23 ";
            S = S + "46 23 78 B1 CA 1F 41 CD 4A 01 CC BA 00 C5 4E 23 ";
            S = S + "46 23 C5 E3 EB E7 C1 DA 1E 41 E3 E5 C5 EB 22 B5 ";
            S = S + "F6 CD 12 34 E1 7E FE 09 28 03 3E 20 DF CD 84 52 ";
            S = S + "21 5E F5 CD 7B 52 CD 28 73 18 BB 7E B7 C8 CD 67 ";
            S = S + "73 23 18 F7 01 5E F5 16 FF AF 32 64 F6 18 04 03 ";
            S = S + "23 15 C8 7E B7 02 C8 FE 0B 38 25 FE 20 DA 61 53 ";
            S = S + "FE 22 20 0A 3A 64 F6 EE 01 32 64 F6 3E 22 FE 3A ";
            S = S + "20 0E 3A 64 F6 1F 38 06 17 E6 FD 32 64 F6 3E 3A ";
            S = S + "B7 F2 8F 52 3A 64 F6 1F 38 2E 1F 1F 30 3E 7E FE ";
            S = S + "E6 E5 C5 21 F5 52 E5 C0 0B 0A FE 4D C0 0B 0A FE ";
            S = S + "45 C0 0B 0A FE 52 C0 0B 0A FE 3A C0 F1 F1 E1 14 ";
            S = S + "14 14 14 18 25 C1 E1 7E C3 8F 52 3A 64 F6 F6 02 ";
            S = S + "32 64 F6 AF C9 3A 64 F6 F6 04 18 F4 17 38 E9 7E ";
            S = S + "FE 84 CC FB 52 FE 8F CC 05 53 7E 3C 7E 20 04 23 ";
            S = S + "7E E6 7F 23 FE A1 20 02 0B 14 E5 C5 D5 CD 8E FF ";
            S = S + "21 71 3A 47 0E 40 0C 23 54 5D 7E B7 28 F8 23 F2 ";
            S = S + "3A 53 7E B8 20 F1 EB 79 D1 C1 FE 5B 20 02 7E 23 ";
            S = S + "5F E6 7F 02 03 15 CA A7 66 B3 F2 4E 53 E1 C3 93 ";
            S = S + "52 2B D7 D5 C5 F5 CD E8 46 F1 01 7E 53 C5 FE 0B ";
            S = S + "CA 1E 37 FE 0C CA 22 37 2A 6A F6 C3 25 34 C1 D1 ";
            S = S + "3A 68 F6 1E 4F FE 0B 28 06 FE 0C 1E 48 20 0B 3E ";
            S = S + "26 02 03 15 C8 7B 02 03 15 C8 3A 69 F6 FE 04 1E ";
            S = S + "00 38 06 1E 21 28 02 1E 23 7E FE 20 20 01 23 7E ";
            S = S + "23 B7 28 20 02 03 15 C8 3A 69 F6 FE 04 38 F0 0B ";
            S = S + "0A 03 20 04 FE 2E 28 08 FE 44 28 04 FE 45 20 DF ";
            S = S + "1E 00 18 DB 7B B7 28 04 02 03 15 C8 2A 66 F6 C3 ";
            S = S + "93 52 CD 79 42 C5 CD EA 54 C1 D1 C5 C5 CD 95 42 ";
            S = S + "30 05 54 5D E3 E5 E7 D2 5A 47 21 D7 3F CD E8 7B ";
            S = S + "C1 21 37 42 E3 EB 2A C2 F6 1A 02 03 13 E7 20 F9 ";
            S = S + "60 69 22 C2 F6 22 C4 F6 22 C6 F6 C9 CD 39 54 7E ";
            S = S + "C3 CF 4F CD 2F 54 D5 CF 2C CD 1C 52 D1 12 C9 CD ";
            S = S + "64 4C E5 CD 39 54 EB E1 C9 01 8A 2F C5 EF F8 CD ";
            S = S + "93 FF CD 71 2E F8 CD B2 2F 01 45 32 11 76 80 CD ";
            S = S + "21 2F D8 01 45 65 11 53 60 CD 21 2F D2 67 40 01 ";
            S = S + "C5 65 11 53 60 C3 4E 32 01 0A 00 C5 50 58 28 26 ";
            S = S + "FE 2C 28 09 D5 CD 5F 47 42 4B D1 28 19 CF 2C CD ";
            S = S + "5F 47 28 12 F1 CF 2C D5 CD 69 47 C2 55 40 7A B3 ";
            S = S + "CA 5A 47 EB E3 EB C5 CD 95 42 D1 D5 C5 CD 95 42 ";
            S = S + "60 69 D1 E7 EB DA 5A 47 D1 C1 F1 E5 D5 18 0E 09 ";
            S = S + "DA 5A 47 EB E5 21 F9 FF E7 E1 DA 5A 47 D5 5E 23 ";
            S = S + "56 7A B3 EB D1 28 07 7E 23 B6 2B EB 20 E1 C5 CD ";
            S = S + "F6 54 C1 D1 E1 D5 5E 23 56 7A B3 28 14 EB E3 EB ";
            S = S + "23 73 23 72 EB 09 EB E1 18 EB 3A A9 F6 B7 C8 18 ";
            S = S + "06 01 1E 41 C5 FE F6 AF 32 A9 F6 2A 76 F6 2B 23 ";
            S = S + "7E 23 B6 C8 23 5E 23 56 D7 B7 28 F3 4F 3A A9 F6 ";
            S = S + "B7 79 28 56 CD 98 FF FE A6 20 14 D7 FE 89 20 E9 ";
            S = S + "D7 FE 0E 20 E4 D5 CD 71 47 7A B3 20 0A 18 27 FE ";
            S = S + "0E 20 D5 D5 CD 71 47 E5 CD 95 42 0B 3E 0D 38 3C ";
            S = S + "CD 23 73 21 5A 55 D5 CD 78 66 E1 CD 12 34 C1 E1 ";
            S = S + "E5 C5 CD 0A 34 E1 D1 2B 18 AE 55 6E 64 65 66 69 ";
            S = S + "6E 65 64 20 6C 69 6E 65 20 00 FE 0D 20 EA D5 CD ";
            S = S + "71 47 E5 EB 23 23 23 4E 23 46 3E 0E 21 55 55 E5 ";
            S = S + "2A 66 F6 E5 2B 70 2B 71 2B 77 E1 C9 7E E3 BE 23 ";
            S = S + "E3 C2 55 40 C3 66 46 3A 63 F6 FE 08 30 05 D6 03 ";
            S = S + "B7 37 C9 D6 03 B7 C9 D7 11 89 FD 06 0F 7E A7 28 ";
            S = S + "0D FE 3A 28 09 FE 28 28 05 12 13 23 10 EF 78 FE ";
            S = S + "0F 28 15 AF 12 1B 1A FE 20 28 F8 06 40 11 C9 FC ";
            S = S + "1A E6 20 20 06 13 10 F8 C3 55 40 C5 D5 E5 CD 2A ";
            S = S + "7E F5 4F 2E 04 CD 1A 7E D5 DD E1 FD E1 E1 2B D7 ";
            S = S + "CD 1C 00 D1 C1 38 DE C9 E1 78 FE 10 38 02 06 0F ";
            S = S + "CD B7 7F CD A9 4E 12 23 13 10 F8 AF 12 06 40 11 ";
            S = S + "C9 FC 1A E6 40 20 06 13 10 F8 C3 6B 6E C5 D5 CD ";
            S = S + "2A 7E F5 4F 2E 06 CD 1A 7E D5 DD E1 FD E1 3E FF ";
            S = S + "CD 1C 00 D1 C1 38 E0 4F 3E 40 90 87 87 B1 FE 09 ";
            S = S + "38 D8 FE FC 30 D4 E1 D1 A7 C9 C5 F5 1F 1F E6 3F ";
            S = S + "CD 2D 7E F5 4F 2E 06 CD 1A 7E D5 DD E1 FD E1 F1 ";
            S = S + "E6 03 32 99 FD C1 F1 D1 E1 C3 1C 00 ED 53 56 F9 ";
            S = S + "CD 64 4C E5 11 00 00 D5 F5 CD D0 67 CD DF 2E 41 ";
            S = S + "4A 53 78 B1 28 06 7A B7 28 02 C5 D5 F1 32 3B FB ";
            S = S + "E1 7C B5 20 0A 3A 58 F9 B7 CA 09 57 C3 94 74 22 ";
            S = S + "3C FB CD EE 56 28 E5 87 4F 2A 56 F9 7E 87 CC 5A ";
            S = S + "47 B9 28 05 23 23 23 18 F3 01 A2 56 C5 7E 4F 87 ";
            S = S + "30 20 B7 1F 4F C5 E5 CD EE 56 11 01 00 CA DF 56 ";
            S = S + "CD A8 64 D2 DC 56 CD 1C 57 37 18 04 CD 0B 57 B7 ";
            S = S + "E1 C1 23 7E 23 66 6F E9 CD EE 56 28 C1 C9 E5 21 ";
            S = S + "3B FB 7E B7 28 13 35 2A 3C FB 7E 23 22 3C FB FE ";
            S = S + "20 28 EC FE 60 38 02 D6 20 E1 C9 E5 21 3B FB 34 ";
            S = S + "2A 3C FB 2B 22 3C FB E1 C9 CD E8 56 FE 3D CA 7A ";
            S = S + "57 FE 2B 28 F4 FE 2D 20 06 11 95 57 D5 18 EA 11 ";
            S = S + "00 00 FE 2C 28 D5 FE 3B C8 FE 3A 30 CE FE 30 38 ";
            S = S + "CA 21 00 00 06 0A 19 38 2A 10 FB D6 30 5F 16 00 ";
            S = S + "19 38 20 EB CD EE 56 20 D9 C9 CD E8 56 11 5E F5 ";
            S = S + "D5 06 28 CD A8 64 38 0B 12 13 FE 3B 28 08 CD E8 ";
            S = S + "56 10 F5 CD 5A 47 E1 C3 9B 4E CD 5A 57 CD 8A 2F ";
            S = S + "EB C9 CD 5A 57 3A 3B FB 2A 3C FB E3 F5 0E 02 CD ";
            S = S + "5E 62 C3 79 56 AF 93 5F 9A 93 57 C9 7E FE 40 CC ";
            S = S + "66 46 01 00 00 50 59 FE F2 28 16 7E FE DC F5 CC ";
            S = S + "66 46 CF 28 CD 0F 52 D5 CF 2C CD 0F 52 CF 29 C1 ";
            S = S + "F1 E5 2A B7 FC 28 03 21 00 00 09 22 B7 FC 22 B3 ";
            S = S + "FC 44 4D 2A B9 FC 28 03 21 00 00 19 22 B9 FC 22 ";
            S = S + "B5 FC EB E1 C9 3A EA F3 18 03 3A E9 F3 C3 D6 79 ";
            S = S + "57 F1 CD 50 58 E5 CD 0E 01 30 06 CD 11 01 CD 20 ";
            S = S + "01 E1 C9 D7 E5 CD 14 01 D1 E5 F5 2A B5 FC E5 2A ";
            S = S + "B3 FC E5 2A B9 FC E5 2A B7 FC E5 EB CD AB 57 E5 ";
            S = S + "CD 0E 01 21 FF FF 30 09 CD 11 01 CD 1D 01 6F 26 ";
            S = S + "00 CD 99 2F D1 E1 22 B7 FC E1 22 B9 FC E1 22 B3 ";
            S = S + "FC E1 22 B5 FC F1 E1 D5 CD 17 01 E1 C9 3A E9 F3 ";
            S = S + "C5 D5 5F CD BC 59 2B D7 28 09 CF 2C FE 2C 28 03 ";
            S = S + "CD 1C 52 7B E5 CD 1A 01 DA 5A 47 E1 D1 C1 C3 6A ";
            S = S + "46 2A B3 FC 7D 91 6F 7C 98 67 D0 AF 95 6F 9C 95 ";
            S = S + "67 37 C9 2A B5 FC 7D 93 6F 7C 9A 67 18 EC E5 2A ";
            S = S + "B5 FC EB 22 B5 FC E1 C9 CD 8E 58 E5 C5 2A B3 FC ";
            S = S + "E3 22 B3 FC C1 E1 C9 C3 E9 79 C5 D5 CF F2 CD AB ";
            S = S + "57 CD 4D 58 D1 C1 28 44 CF 2C CF 42 CA 12 59 CF ";
            S = S + "46 E5 CD 0E 01 CD 98 58 CD 0E 01 CD 83 58 DC 8E ";
            S = S + "58 23 E5 CD 71 58 DC 9B 58 23 E5 CD 11 01 D1 C1 ";
            S = S + "D5 C5 CD 14 01 F5 E5 EB CD 23 01 E1 F1 CD 17 01 ";
            S = S + "CD 08 01 C1 D1 0B 78 B1 20 E6 E1 C9 C5 D5 E5 CD ";
            S = S + "3C 59 2A B7 FC 22 B3 FC 2A B9 FC 22 B5 FC E1 D1 ";
            S = S + "C1 C9 E5 2A B5 FC E5 D5 EB CD FC 58 E1 22 B5 FC ";
            S = S + "EB CD FC 58 E1 22 B5 FC 2A B3 FC C5 44 4D CD FC ";
            S = S + "58 E1 22 B3 FC 44 4D CD FC 58 E1 C9 CD F3 FE C3 ";
            S = S + "0D 7A CD 98 58 CD 0E 01 CD 83 58 DC 98 58 D5 E5 ";
            S = S + "CD 71 58 EB 21 FC 00 30 03 21 FF 00 E3 E7 30 10 ";
            S = S + "22 2D F9 E1 22 ED F3 21 08 01 22 F0 F3 EB 18 0F ";
            S = S + "E3 22 F0 F3 21 08 01 22 ED F3 EB 22 2D F9 E1 D1 ";
            S = S + "E5 CD 7B 58 22 2F F9 CD 11 01 D1 D5 CD B4 59 C1 ";
            S = S + "03 18 07 E1 78 B1 C8 CD EC F3 CD 20 01 0B E5 2A ";
            S = S + "2D F9 19 EB 2A 2F F9 19 30 E9 EB E1 78 B1 C8 CD ";
            S = S + "EF F3 18 E3 7A B7 1F 57 7B 1F 5F C9 3A AF FC FE ";
            S = S + "02 F0 C3 5A 47 C3 FB 79 C5 D5 CD 4D 58 3A F2 F3 ";
            S = S + "5F 2B D7 28 05 CF 2C CD 1C 52 7B CD 29 01 DA 5A ";
            S = S + "47 D1 C1 E5 CD 91 5E CD 11 01 11 01 00 06 00 CD ";
            S = S + "DC 5A 28 14 E5 CD ED 5A D1 19 EB AF CD CE 5A 3E ";
            S = S + "40 CD CE 5A 06 C0 18 1E E1 C9 CD BD 00 3A 4A F9 ";
            S = S + "B7 28 0C 2A 4B F9 E5 2A 49 F9 E5 2A 4D F9 E5 D1 ";
            S = S + "C1 E1 79 CD 17 01 78 32 53 F9 87 28 DB D5 30 05 ";
            S = S + "CD 05 01 18 03 CD 0B 01 D1 38 E4 06 00 CD DC 5A ";
            S = S + "CA 1F 5A AF 32 4A F9 CD ED 5A 5D 54 B7 28 1A 2B ";
            S = S + "2B 7C 87 38 14 ED 53 4D F9 CD 14 01 22 4B F9 32 ";
            S = S + "49 F9 3A 53 F9 2F 32 4A F9 2A 51 F9 19 EB CD C2 ";
            S = S + "5A 2A 42 F9 3A 44 F9 CD 17 01 2A 4F F9 ED 5B 51 ";
            S = S + "F9 B7 ED 52 28 39 38 1C EB 06 01 CD DC 5A 28 2F ";
            S = S + "B7 28 E7 EB 2A 42 F9 3A 44 F9 4F 3A 53 F9 47 CD ";
            S = S + "D3 5A 18 D6 CD 7B 58 2B 2B 7C 87 38 12 23 E5 CD ";
            S = S + "FF 00 2B 7C B5 20 F8 D1 3A 53 F9 2F CD CE 5A C3 ";
            S = S + "0A 5A 3A 54 F9 4F 3A 55 F9 B1 C8 3A 53 F9 47 CD ";
            S = S + "14 01 4F E3 C5 D5 E5 0E 02 C3 5E 62 CD 2C 01 ED ";
            S = S + "53 4F F9 22 51 F9 7C B5 79 32 55 F9 C9 CD 14 01 ";
            S = S + "E5 F5 2A 42 F9 3A 44 F9 CD 17 01 F1 E1 22 42 F9 ";
            S = S + "32 44 F9 CD 2F 01 79 32 54 F9 C9 EB CD 7B 58 EB ";
            S = S + "C9 CD 9C 57 CF 2C CD 0F 52 E5 EB 22 B3 FC CD 99 ";
            S = S + "2F CD B2 2F 01 40 70 11 71 07 CD 5C 32 CD 8A 2F ";
            S = S + "22 36 F9 AF 32 35 F9 32 41 F9 E1 CD 4D 58 0E 01 ";
            S = S + "11 00 00 CD 17 5D D5 0E 80 11 FF FF CD 17 5D E3 ";
            S = S + "AF EB E7 3E 00 30 0F 3D EB F5 3A 35 F9 4F 07 07 ";
            S = S + "B1 0F 32 35 F9 F1 32 38 F9 ED 53 3F F9 22 33 F9 ";
            S = S + "E1 2B D7 20 10 E5 CD 26 01 7C B7 28 32 3E 01 32 ";
            S = S + "41 F9 EB 18 2A CF 2C CD 64 4C E5 CD B2 2F CD 71 ";
            S = S + "2E CA 5A 47 FA 5A 47 CD 63 5D 20 07 3C 32 41 F9 ";
            S = S + "CD 67 32 01 43 25 11 60 00 CD 5C 32 CD 8A 2F 22 ";
            S = S + "31 F9 11 00 00 ED 53 3D F9 2A B3 FC 29 CD BD 00 ";
            S = S + "7B 1F 38 16 D5 E5 23 EB CD B4 59 EB 13 CD B4 59 ";
            S = S + "CD 06 5C D1 E1 E7 D2 08 5A EB 44 4D 2A 3D F9 23 ";
            S = S + "19 19 7C 87 38 0C D5 EB 60 69 29 2B EB B7 ED 52 ";
            S = S + "0B D1 22 3D F9 60 69 13 18 C3 D5 CD EB 5C E1 3A ";
            S = S + "41 F9 B7 C8 EB C9 ED 53 39 F9 E5 21 00 00 22 3B ";
            S = S + "F9 CD FA 5B 22 45 F9 E1 EB E5 CD FA 5B ED 53 47 ";
            S = S + "F9 D1 CD 0B 5B CD 48 5C E5 D5 2A 36 F9 22 3B F9 ";
            S = S + "ED 5B 39 F9 B7 ED 52 22 39 F9 2A 45 F9 CD 7B 58 ";
            S = S + "22 45 F9 D1 E1 CD 0B 5B 3E 04 F5 E5 D5 E5 D5 ED ";
            S = S + "5B 3B F9 2A 36 F9 29 19 22 3B F9 2A 39 F9 19 EB ";
            S = S + "2A 3F F9 E7 28 1A 30 08 2A 33 F9 E7 28 0A 30 20 ";
            S = S + "3A 38 F9 B7 20 24 18 1E 3A 35 F9 87 30 1C 18 06 ";
            S = S + "3A 35 F9 1F 30 14 D1 E1 CD DC 5C CD CD 5C 18 1A ";
            S = S + "3A 38 F9 B7 28 04 D1 E1 18 10 D1 E1 CD DC 5C CD ";
            S = S + "0E 01 30 06 CD 11 01 CD 20 01 D1 E1 F1 3D C8 F5 ";
            S = S + "D5 ED 5B 45 F9 CD 0B 5B 22 45 F9 EB D1 E5 2A 47 ";
            S = S + "F9 EB 22 47 F9 CD 0B 5B E1 F1 C3 4A 5C 2A B7 FC ";
            S = S + "22 B3 FC 2A B9 FC 22 B5 FC C3 3C 59 D5 ED 5B B7 ";
            S = S + "FC 19 44 4D D1 2A B9 FC 19 EB C9 2A 31 F9 7D B7 ";
            S = S + "20 04 B4 C0 EB C9 4A 16 00 F5 CD 0A 5D 1E 80 19 ";
            S = S + "59 4C F1 CD 0A 5D 59 19 EB C9 06 08 21 00 00 29 ";
            S = S + "87 30 01 19 10 F9 C9 2B D7 C8 CF 2C FE 2C C8 C5 ";
            S = S + "CD 64 4C E3 E5 CD B2 2F C1 21 F6 F7 7E B7 F2 3A ";
            S = S + "5D E6 7F 77 21 35 F9 7E B1 77 01 40 15 11 91 55 ";
            S = S + "CD 5C 32 CD 63 5D CA 5A 47 CD B1 2E 2A 36 F9 29 ";
            S = S + "29 29 CD 99 2F CD B2 2F C1 D1 CD 5C 32 CD 8A 2F ";
            S = S + "D1 EB C9 01 41 10 11 00 00 CD 21 2F 3D C9 3A AF ";
            S = S + "FC FE 02 DA 5A 47 11 83 5D AF 32 BB FC 32 58 F9 ";
            S = S + "C3 6C 56 D5 B1 5D C4 B4 5D CC B9 5D D2 BC 5D 4D ";
            S = S + "D8 5D C5 CA 5D C6 C6 5D C7 D1 5D C8 C3 5D C1 4E ";
            S = S + "5E 42 46 5E 4E 42 5E 58 82 57 C3 87 5E D3 59 5E ";
            S = S + "00 CD 0B 5B 01 00 00 18 46 CD 0B 5B 42 4B 11 00 ";
            S = S + "00 18 3C CD 0B 5B 42 4B 18 35 42 4B CD 0B 5B 18 ";
            S = S + "2E CD 0B 5B 42 4B 18 F4 CD E8 56 06 00 FE 2B 28 ";
            S = S + "05 FE 2D 28 01 04 78 F5 CD 0B 57 CD 19 57 D5 CD ";
            S = S + "E8 56 FE 2C C2 5A 47 CD 19 57 C1 F1 B7 20 23 CD ";
            S = S + "66 5E D5 50 59 CD 66 5E EB D1 3A BD FC 1F 30 06 ";
            S = S + "F5 CD 7B 58 EB F1 1F 30 06 CD 7B 58 CD 0B 5B CD ";
            S = S + "DC 5C 3A BB FC 87 38 09 F5 C5 D5 CD CD 5C D1 C1 ";
            S = S + "F1 87 38 09 ED 53 B9 FC 60 69 22 B7 FC AF 32 BB ";
            S = S + "FC C9 3E 40 18 02 3E 80 21 BB FC B6 77 C9 30 09 ";
            S = S + "7B FE 04 30 04 32 BD FC C9 D2 5A 47 7A B7 C2 5A ";
            S = S + "47 7B 32 BC FC C9 3A BC FC B7 C8 21 00 00 19 3D ";
            S = S + "20 FC EB 7A 87 F5 30 01 1B CD B4 59 CD B4 59 F1 ";
            S = S + "D0 7A F6 C0 57 13 C9 30 D0 7B CD 1A 01 DA 5A 47 ";
            S = S + "C9 E5 CD 0E 01 D2 5A 47 E1 C9 2B D7 C8 CF 2C 01 ";
            S = S + "9A 5E C5 F6 AF 32 62 F6 4E CD A2 FF CD A7 64 DA ";
            S = S + "55 40 AF 47 D7 38 05 CD A8 64 38 09 47 D7 38 FD ";
            S = S + "CD A8 64 30 F8 FE 26 30 17 11 EE 5E D5 16 02 FE ";
            S = S + "25 C8 14 FE 24 C8 14 FE 21 C8 16 08 FE 23 C8 F1 ";
            S = S + "79 E6 7F 5F 16 00 E5 21 89 F6 19 56 E1 2B 7A 32 ";
            S = S + "63 F6 D7 3A A5 F6 3D CA E8 5F F2 08 5F 7E D6 28 ";
            S = S + "CA BA 5F D6 33 CA BA 5F AF 32 A5 F6 E5 3A B7 F7 ";
            S = S + "B7 32 B4 F7 28 3C 2A E6 F6 11 E8 F6 19 22 B5 F7 ";
            S = S + "EB 18 17 1A 6F 13 1A 13 B9 20 0B 3A 63 F6 BD 20 ";
            S = S + "05 1A B8 CA A4 5F 13 26 00 19 EB 3A B5 F7 BB C2 ";
            S = S + "23 5F 3A B6 F7 BA 20 DB 3A B4 F7 B7 28 18 AF 32 ";
            S = S + "B4 F7 2A C4 F6 22 B5 F7 2A C2 F6 18 DD CD A4 5E ";
            S = S + "C9 57 5F C1 E3 C9 E1 E3 D5 11 60 5F E7 28 F2 11 ";
            S = S + "9E 4E E7 D1 28 31 E3 E5 C5 3A 63 F6 4F C5 06 00 ";
            S = S + "03 03 03 2A C6 F6 E5 09 C1 E5 CD 50 62 E1 22 C6 ";
            S = S + "F6 60 69 22 C4 F6 2B 36 00 E7 20 FA D1 73 23 D1 ";
            S = S + "73 23 72 EB 13 E1 C9 32 F6 F7 67 6F 22 F8 F7 EF ";
            S = S + "20 06 21 D6 3F 22 F8 F7 E1 C9 E5 2A 62 F6 E3 57 ";
            S = S + "D5 C5 CD 55 47 C1 F1 EB E3 E5 EB 3C 57 7E FE 2C ";
            S = S + "CA C0 5F FE 29 28 05 FE 5D C2 55 40 D7 22 BC F6 ";
            S = S + "E1 22 62 F6 1E 00 D5 11 E5 F5 2A C4 F6 3E 19 ED ";
            S = S + "5B C6 F6 E7 28 2D 5E 23 7E 23 B9 20 08 3A 63 F6 ";
            S = S + "BB 20 02 7E B8 23 5E 23 56 23 20 E2 3A 62 F6 B7 ";
            S = S + "C2 5E 40 F1 44 4D CA 97 32 96 CA 7D 60 11 09 00 ";
            S = S + "C3 6F 40 3A 63 F6 77 23 5F 16 00 F1 CA 5A 47 71 ";
            S = S + "23 70 23 4F CD 5E 62 23 23 22 9D F6 71 23 3A 62 ";
            S = S + "F6 17 79 01 0B 00 30 02 C1 03 71 F5 23 70 23 CD ";
            S = S + "4A 31 F1 3D 20 ED F5 42 4B EB 19 DA 75 62 CD 67 ";
            S = S + "62 22 C6 F6 2B 36 00 E7 20 FA 03 57 2A 9D F6 5E ";
            S = S + "EB 29 09 EB 2B 2B 73 23 72 23 F1 38 30 47 4F 7E ";
            S = S + "23 16 E1 5E 23 56 23 E3 F5 E7 D2 1D 60 CD 4A 31 ";
            S = S + "19 F1 3D 44 4D 20 EB 3A 63 F6 44 4D 29 D6 04 38 ";
            S = S + "04 29 28 06 29 B7 E2 AA 60 09 C1 09 EB 2A BC F6 ";
            S = S + "C9 CD 65 4C CD 58 30 CF 3B EB 2A F8 F7 18 08 3A ";
            S = S + "A6 F6 B7 28 0D D1 EB E5 AF 32 A6 F6 3C F5 D5 46 ";
            S = S + "04 05 CA 5A 47 23 7E 23 66 6F 18 1A 58 E5 0E 02 ";
            S = S + "7E 23 FE 5C CA 10 62 FE 20 20 03 0C 10 F2 E1 43 ";
            S = S + "3E 5C CD 46 62 DF AF 5F 57 CD 46 62 57 7E 23 FE ";
            S = S + "21 CA 0D 62 FE 23 28 3C FE 26 CA 09 62 05 CA F5 ";
            S = S + "61 FE 2B 3E 08 28 E2 2B 7E 23 FE 2E 28 40 FE 5C ";
            S = S + "28 BA BE 20 CD FE 24 28 14 FE 2A 20 C5 23 78 FE ";
            S = S + "02 38 03 7E FE 24 3E 20 20 07 05 1C FE AF C6 10 ";
            S = S + "23 1C 82 57 1C 0E 00 05 28 48 7E 23 FE 2E 28 19 ";
            S = S + "FE 23 28 F0 FE 2C 20 1B 7A F6 40 57 18 E6 7E FE ";
            S = S + "23 3E 2E C2 F2 60 0E 01 23 0C 05 28 25 7E 23 FE ";
            S = S + "23 28 F6 D5 11 90 61 D5 54 5D FE 5E C0 BE C0 23 ";
            S = S + "BE C0 23 BE C0 23 78 D6 04 D8 D1 D1 47 14 23 CA ";
            S = S + "EB D1 7A 2B 1C E6 08 20 15 1D 78 B7 28 10 7E D6 ";
            S = S + "2D 28 06 FE FE 20 07 3E 08 C6 04 82 57 05 E1 F1 ";
            S = S + "28 4C C5 D5 CD 64 4C D1 C1 C5 E5 43 78 81 FE 19 ";
            S = S + "D2 5A 47 7A F6 80 CD 26 34 CD 78 66 E1 2B D7 37 ";
            S = S + "28 0B 32 A6 F6 FE 3B 28 03 CF 2C 06 D7 C1 EB E1 ";
            S = S + "E5 F5 D5 7E 90 23 16 00 5F 7E 23 66 6F 19 78 B7 ";
            S = S + "C2 F6 60 18 04 CD 46 62 DF E1 F1 C2 BF 60 DC 28 ";
            S = S + "73 E3 CD D6 67 E1 C3 FF 4A 0E 00 18 04 0E 01 3E ";
            S = S + "F1 05 CD 46 62 E1 F1 28 E5 C5 CD 64 4C CD 58 30 ";
            S = S + "C1 C5 E5 2A F8 F7 41 0E 00 78 F5 B7 C4 68 68 CD ";
            S = S + "7B 66 2A F8 F7 F1 B7 CA CC 61 96 47 3E 20 04 05 ";
            S = S + "CA CC 61 DF 18 F9 F5 7A B7 3E 2B C4 18 00 F1 C9 ";
            S = S + "CD 67 62 C5 E3 C1 E7 7E 02 C8 0B 2B 18 F8 E5 2A ";
            S = S + "C6 F6 06 00 09 09 3E E5 3E 60 95 6F 3E FF 9C 67 ";
            S = S + "38 03 39 E1 D8 CD 53 42 2A 74 F6 2B 2B 22 B1 F6 ";
            S = S + "11 07 00 C3 6F 40 C0 2A 76 F6 CD 39 64 32 AA F6 ";
            S = S + "32 A9 F6 77 23 77 23 22 C2 F6 CD CB FE 2A 76 F6 ";
            S = S + "2B CD D0 FE 22 A7 F6 CD 6E 63 06 1A 21 CA F6 CD ";
            S = S + "D5 FE 36 08 23 10 FB CD 24 2C AF 32 BB F6 6F 67 ";
            S = S + "22 B9 F6 22 C0 F6 2A 72 F6 22 9B F6 CD C9 63 2A ";
            S = S + "C2 F6 22 C4 F6 22 C6 F6 CD 1C 6C 3A 7C F8 E6 01 ";
            S = S + "20 03 32 7C F8 C1 2A 74 F6 2B 2B 22 B1 F6 23 23 ";
            S = S + "CD DA FE F9 21 7A F6 22 78 F6 CD 04 73 CD FF 4A ";
            S = S + "AF 67 6F 22 E6 F6 32 B7 F7 22 4E F7 22 BA F7 22 ";
            S = S + "E4 F6 32 A5 F6 E5 C5 2A A7 F6 C9 F3 7E E6 04 F6 ";
            S = S + "01 BE 77 28 04 E6 04 20 26 FB C9 F3 7E 36 00 18 ";
            S = S + "07 F3 7E F5 F6 02 77 F1 EE 05 28 26 FB C9 F3 7E ";
            S = S + "E6 05 BE 77 20 02 FB C9 EE 05 28 03 FB C9 F3 3A ";
            S = S + "D8 FB 3C 32 D8 FB FB C9 F3 7E E6 03 BE 77 20 02 ";
            S = S + "FB C9 3A D8 FB D6 01 38 F7 32 D8 FB FB C9 21 4C ";
            S = S + "FC 06 1A AF 77 23 77 23 77 23 10 F8 21 CE FB 06 ";
            S = S + "0A 77 23 10 FC 32 D8 FB C9 3A BB F6 B7 C0 E5 2A ";
            S = S + "1C F4 7C A5 3C 28 0F 21 4C FC 06 1A 7E FE 05 28 ";
            S = S + "07 23 23 23 10 F6 E1 C9 C5 23 5E 23 56 2B 2B 7A ";
            S = S + "B3 C1 28 ED D5 E5 CD 58 63 CD 31 63 0E 03 CD 5E ";
            S = S + "62 C1 D1 E1 E3 E1 C3 CF 47 EB 2A 76 F6 28 0E EB ";
            S = S + "CD 69 47 E5 CD 95 42 60 69 D1 D2 1C 48 2B 22 C8 ";
            S = S + "F6 EB C9 C2 A5 77 C0 3C 18 0A C0 AF 32 BB F6 F5 ";
            S = S + "CC 1C 6C F1 22 AF F6 21 7A F6 22 78 F6 21 F6 FF ";
            S = S + "C1 2A 1C F4 E5 F5 7D A4 3C 28 09 22 BE F6 2A AF ";
            S = S + "F6 22 C0 F6 CD 04 73 CD 23 73 F1 21 DC 3F C2 FD ";
            S = S + "40 C3 1E 41 2A C0 F6 7C B5 11 11 00 CA 6F 40 ED ";
            S = S + "5B BE F6 ED 53 1C F4 C9 3E AF 32 C4 F7 C9 CD A4 ";
            S = S + "5E D5 E5 21 BC F7 CD F3 2E 2A C4 F6 E3 EF F5 CF ";
            S = S + "2C CD A4 5E F1 47 EF B8 C2 6D 40 E3 EB E5 2A C4 ";
            S = S + "F6 E7 20 10 D1 E1 E3 D5 CD F3 2E E1 11 BC F7 CD ";
            S = S + "F3 2E E1 C9 C3 5A 47 3E 01 32 A5 F6 CD A4 5E E5 ";
            S = S + "32 A5 F6 60 69 0B 0B 0B 0B 0B 19 EB 2A C6 F6 E7 ";
            S = S + "1A 02 13 03 20 F9 0B 60 69 22 C6 F6 E1 7E FE 2C ";
            S = S + "C0 D7 18 D3 F1 E1 C9 7E FE 41 D8 FE 5B 3F C9 CA ";
            S = S + "A1 62 CD 56 47 2B D7 E5 2A 4A FC 44 4D 2A 72 F6 ";
            S = S + "28 2A E1 CF 2C D5 CD 2F 54 2B D7 C2 55 40 E3 EB ";
            S = S + "7C A7 F2 5A 47 D5 11 81 F3 E7 D2 5A 47 D1 E5 01 ";
            S = S + "F5 FE 3A 5F F8 09 3D C3 1F 7A C1 2B 7D 93 5F 7C ";
            S = S + "9A 57 DA 75 62 E5 2A C2 F6 C5 01 A0 00 09 C1 E7 ";
            S = S + "D2 75 62 EB 22 74 F6 60 69 22 4A FC E1 22 72 F6 ";
            S = S + "E1 CD A1 62 3A 5F F8 CD 6B 7E 2A A7 F6 C3 01 46 ";
            S = S + "7D 93 5F 7C 9A 57 C9 11 00 00 C4 A4 5E 22 A7 F6 ";
            S = S + "CD E2 3F C2 5B 40 F9 D5 7E F5 23 D5 7E 23 B7 FA ";
            S = S + "6B 65 3D 20 04 01 08 00 09 C6 04 32 63 F6 CD 08 ";
            S = S + "2F EB E3 E5 EF 30 4E CD D6 2E CD 4E 32 E1 CD E8 ";
            S = S + "2E E1 CD DF 2E E5 CD 21 2F 18 29 01 0C 00 09 4E ";
            S = S + "23 46 23 E3 5E 23 56 E5 69 60 CD 72 31 3A 63 F6 ";
            S = S + "FE 02 C2 67 40 EB E1 72 2B 73 E1 D5 5E 23 56 23 ";
            S = S + "E3 CD 4D 2F E1 C1 90 CD DF 2E 28 1A EB 22 1C F4 ";
            S = S + "69 60 C3 FD 45 CD 97 26 E1 CD 10 2F E1 CD EF 2E ";
            S = S + "D5 CD 5C 2F 18 DE F9 22 B1 F6 EB 2A A7 F6 7E FE ";
            S = S + "2C C2 01 46 D7 CD 2A 65 CD D0 67 7E 23 4E 23 46 ";
            S = S + "D1 C5 F5 CD D7 67 F1 57 5E 23 4E 23 46 E1 7B B2 ";
            S = S + "C8 7A D6 01 D8 AF BB 3C D0 15 1D 0A 03 BE 23 28 ";
            S = S + "ED 3F C3 79 2E CD 1E 37 18 0D CD 22 37 18 08 CD ";
            S = S + "1A 37 18 03 CD 25 34 CD 35 66 CD D3 67 01 25 68 ";
            S = S + "C5 7E 23 E5 CD 8E 66 E1 4E 23 46 CD 2A 66 E5 6F ";
            S = S + "CD C7 67 D1 C9 3E 01 CD 8E 66 21 98 F6 E5 77 23 ";
            S = S + "73 23 72 E1 C9 2B 06 22 50 E5 0E FF 23 7E 0C B7 ";
            S = S + "28 06 BA 28 03 B8 20 F4 FE 22 CC 66 46 E3 23 EB ";
            S = S + "79 CD 2A 66 11 98 F6 3E D5 2A 78 F6 22 F8 F7 3E ";
            S = S + "03 32 63 F6 CD F3 2E 11 9B F6 E7 22 78 F6 E1 7E ";
            S = S + "C0 11 10 00 C3 6F 40 23 CD 35 66 CD D3 67 CD E1 ";
            S = S + "2E 14 15 C8 0A DF FE 0D CC 31 73 03 18 F4 B7 0E ";
            S = S + "F1 F5 2A 74 F6 EB 2A 9B F6 2F 4F 06 FF 09 23 E7 ";
            S = S + "38 07 22 9B F6 23 EB F1 C9 F1 11 0E 00 CA 6F 40 ";
            S = S + "BF F5 01 90 66 C5 2A 72 F6 22 9B F6 21 00 00 E5 ";
            S = S + "2A C6 F6 E5 21 7A F6 ED 5B 78 F6 E7 01 C7 66 C2 ";
            S = S + "42 67 21 4C F7 22 B8 F7 2A C4 F6 22 B5 F7 2A C2 ";
            S = S + "F6 ED 5B B5 F7 E7 28 12 7E 23 23 23 FE 03 20 04 ";
            S = S + "CD 43 67 AF 5F 16 00 19 18 E7 2A B8 F7 5E 23 56 ";
            S = S + "7A B3 2A C4 F6 28 13 EB 22 B8 F7 23 23 5E 23 56 ";
            S = S + "23 EB 19 22 B5 F7 EB 18 C8 C1 ED 5B C6 F6 E7 CA ";
            S = S + "63 67 7E 23 CD DF 2E E5 09 FE 03 20 EC 22 9F F6 ";
            S = S + "E1 4E 06 00 09 09 23 EB 2A 9F F6 EB E7 28 DB 01 ";
            S = S + "37 67 C5 AF B6 23 5E 23 56 23 C8 44 4D 2A 9B F6 ";
            S = S + "E7 60 69 D8 E1 E3 E7 E3 E5 60 69 D0 C1 F1 F1 E5 ";
            S = S + "D5 C5 C9 D1 E1 7C B5 C8 2B 46 2B 4E E5 2B 6E 26 ";
            S = S + "00 09 50 59 2B 44 4D 2A 9B F6 CD 53 62 E1 71 23 ";
            S = S + "70 60 69 2B C3 B9 66 C5 E5 2A F8 F7 E3 CD C7 4D ";
            S = S + "E3 CD 58 30 7E E5 2A F8 F7 E5 86 11 0F 00 DA 6F ";
            S = S + "40 CD 27 66 D1 CD D7 67 E3 CD D6 67 E5 2A 99 F6 ";
            S = S + "EB CD BF 67 CD BF 67 21 73 4C E3 E5 C3 54 66 E1 ";
            S = S + "E3 7E 23 4E 23 46 6F 2C 2D C8 0A 12 03 13 18 F8 ";
            S = S + "CD 58 30 2A F8 F7 EB CD EE 67 EB C0 D5 50 59 1B ";
            S = S + "4E 2A 9B F6 E7 20 05 47 09 22 9B F6 E1 C9 CD 9D ";
            S = S + "FF 2A 78 F6 2B 46 2B 4E 2B E7 C0 22 78 F6 C9 01 ";
            S = S + "CF 4F C5 CD D0 67 AF 57 7E B7 C9 01 CF 4F C5 CD ";
            S = S + "03 68 CA 5A 47 23 5E 23 56 1A C9 CD 25 66 CD 1F ";
            S = S + "52 2A 99 F6 73 C1 C3 54 66 D7 CF 28 CD 1C 52 D5 ";
            S = S + "CF 2C CD 64 4C CF 29 E3 E5 EF 28 05 CD 1F 52 18 ";
            S = S + "03 CD 0F 68 D1 CD 4D 68 CD 1F 52 3E 20 F5 7B CD ";
            S = S + "27 66 47 F1 04 05 28 CD 2A 99 F6 77 23 10 FC 18 ";
            S = S + "C4 CD E3 68 AF E3 4F 3E E5 E5 7E B8 38 02 78 11 ";
            S = S + "0E 00 C5 CD 8E 66 C1 E1 E5 23 46 23 66 68 06 00 ";
            S = S + "09 44 4D CD 2A 66 6F CD C7 67 D1 CD D7 67 C3 54 ";
            S = S + "66 CD E3 68 D1 D5 1A 90 18 CB EB 7E CD E6 68 04 ";
            S = S + "05 CA 5A 47 C5 CD E4 69 F1 E3 01 69 68 C5 3D BE ";
            S = S + "06 00 D0 4F 7E 91 BB 47 D8 43 C9 CD 03 68 CA CF ";
            S = S + "4F 5F 23 7E 23 66 6F E5 19 46 22 19 F4 78 32 1B ";
            S = S + "F4 72 E3 C5 2B D7 CD 99 32 21 00 00 22 19 F4 C1 ";
            S = S + "E1 70 C9 EB CF 29 C1 D1 C5 43 C9 D7 CD 62 4C EF ";
            S = S + "3E 01 F5 28 11 F1 CD 1F 52 B7 CA 5A 47 F5 CF 2C ";
            S = S + "CD 64 4C CD 58 30 CF 2C E5 2A F8 F7 E3 CD 64 4C ";
            S = S + "CF 29 E5 CD D0 67 EB C1 E1 F1 C5 01 97 32 C5 01 ";
            S = S + "CF 4F C5 F5 D5 CD D6 67 D1 F1 47 3D 4F BE 3E 00 ";
            S = S + "D0 1A B7 78 C8 7E 23 46 23 66 68 06 00 09 91 47 ";
            S = S + "C5 D5 E3 4E 23 5E 23 56 E1 E5 D5 C5 1A BE 20 16 ";
            S = S + "13 0D 28 09 23 10 F5 D1 D1 C1 D1 AF C9 E1 D1 D1 ";
            S = S + "C1 78 94 81 3C C9 C1 D1 E1 23 10 DD 18 EC CF 28 ";
            S = S + "CD A4 5E CD 58 30 E5 D5 EB 23 5E 23 56 2A C6 F6 ";
            S = S + "E7 38 10 2A 76 F6 E7 30 0A E1 E5 CD 11 66 E1 E5 ";
            S = S + "CD F3 2E E1 E3 CF 2C CD 1C 52 B7 CA 5A 47 F5 7E ";
            S = S + "CD E4 69 D5 CD 5F 4C E5 CD D0 67 EB E1 C1 F1 47 ";
            S = S + "E3 E5 21 97 32 E3 79 B7 C8 7E 90 DA 5A 47 3C B9 ";
            S = S + "38 01 79 48 0D 06 00 D5 23 5E 23 66 6B 09 47 D1 ";
            S = S + "EB 4E 23 7E 23 66 6F EB 79 B7 C8 1A 77 13 23 0D ";
            S = S + "C8 10 F8 C9 1E FF FE 29 28 05 CF 2C CD 1C 52 CF ";
            S = S + "29 C9 2A C6 F6 EB 21 00 00 39 EF C2 C1 4F CD D3 ";
            S = S + "67 CD B6 66 ED 5B 74 F6 2A 9B F6 C3 C1 4F CD 64 ";
            S = S + "4C E5 CD D0 67 7E B7 28 2E 23 5E 23 66 6B 5F CD ";
            S = S + "15 6F F5 01 66 F8 16 0B 1C 1D 28 35 7E FE 20 38 ";
            S = S + "16 FE 2E 28 18 02 03 23 15 20 EE F1 F5 57 3A 66 ";
            S = S + "F8 3C 28 03 F1 E1 C9 C3 6B 6E 23 18 DC 7A FE 0B ";
            S = S + "CA 47 6A FE 03 DA 47 6A 28 F0 3E 20 02 03 15 18 ";
            S = S + "EC 3E 20 02 03 15 20 F9 18 D1 CD 1F 52 6F 3A 5F ";
            S = S + "F8 BD DA 7D 6E 26 00 29 EB 2A 60 F8 19 7E 23 66 ";
            S = S + "6F 3A 7C F8 3C C8 7E B7 C8 E5 11 04 00 19 7E FE ";
            S = S + "09 30 06 CD 4E FE C3 80 6E E1 7E B7 37 C9 2B D7 ";
            S = S + "FE 23 CC 66 46 CD 1C 52 E3 E5 CD 6D 6A CA 77 6E ";
            S = S + "22 64 F8 CD 53 FE C9 01 FF 4A C5 CD 0E 6A 7E FE ";
            S = S + "82 1E 04 20 1F D7 FE 85 1E 01 28 17 FE 9C 28 0C ";
            S = S + "CF 41 CF 50 CF 50 CF 81 1E 08 18 08 D7 CF B3 1E ";
            S = S + "02 18 01 D7 CF 41 CF 53 D5 7E FE 23 CC 66 46 CD ";
            S = S + "1C 52 B7 CA 7D 6E CD 58 FE 1E D5 2B 5F D7 C2 55 ";
            S = S + "40 E3 7B F5 E5 CD 6D 6A C2 6E 6E D1 7A FE 09 CD ";
            S = S + "5D FE DA 80 6E E5 01 04 00 09 72 3E 00 E1 CD 8F ";
            S = S + "6F F1 E1 C9 E5 B7 20 08 3A 7C F8 E6 01 C2 F3 6C ";
            S = S + "CD 6D 6A 28 15 22 64 F8 E5 38 06 CD 62 FE C3 80 ";
            S = S + "6E 3E 02 CD 8F 6F CD EA 6C E1 E5 11 07 00 19 77 ";
            S = S + "67 6F 22 64 F8 E1 86 36 00 E1 C9 37 11 F6 AF F5 ";
            S = S + "CD 0E 6A CD 67 FE F1 F5 28 0C 7E D6 2C B7 20 06 ";
            S = S + "D7 CF 52 F1 37 F5 F5 AF 1E 01 CD FA 6A 2A 64 F8 ";
            S = S + "01 07 00 09 F1 9F E6 80 F6 01 32 7C F8 F1 F5 9F ";
            S = S + "32 66 F8 7E B7 FA D4 6B F1 C4 87 62 AF CD AA 6A ";
            S = S + "C3 34 41 CD 0E 6A CD 6C FE 2B D7 1E 80 37 28 07 ";
            S = S + "CF 2C CF 41 B7 1E 02 F5 7A FE 09 38 05 1E 02 F1 ";
            S = S + "AF F5 AF CD FA 6A F1 38 05 2B D7 C3 2E 52 CD 71 ";
            S = S + "FE C3 6B 6E CD 76 FE C3 6B 6E E5 D5 2A 64 F8 11 ";
            S = S + "04 00 19 7E D1 E1 C9 20 19 E5 C5 F5 11 F3 6B D5 ";
            S = S + "C5 B7 C9 F1 C1 3D F2 EA 6B E1 C9 C1 E1 7E FE 2C ";
            S = S + "C0 D7 C5 7E FE 23 CC 66 46 CD 1C 52 E3 E5 11 FB ";
            S = S + "6B D5 37 E9 01 24 6B 3A 5F F8 18 CB 3A 7C F8 B7 ";
            S = S + "F8 01 24 6B AF 3A 5F F8 18 BD 3E 01 32 16 F4 CD ";
            S = S + "7B FE C3 5A 47 F5 CD 9E 6A 38 06 CD 80 FE C3 6B ";
            S = S + "6E D1 C1 3E 04 C3 8F 6F E5 D5 C5 F5 CD 62 6C 30 ";
            S = S + "06 CD 85 FE C3 6B 6E F1 F5 4F 3E 06 CD 8F 6F C3 ";
            S = S + "FF 72 D5 2A 64 F8 EB 21 04 00 19 7E EB D1 FE 09 ";
            S = S + "C9 E5 D5 C5 CD 62 6C 30 06 CD 8A FE C3 80 6E 3E ";
            S = S + "08 CD 8F 6F C3 00 73 D7 CF 24 CF 28 E5 2A 64 F8 ";
            S = S + "E5 21 00 00 22 64 F8 E1 E3 CD 1C 52 D5 7E FE 2C ";
            S = S + "20 11 D7 CD 9E 6A FE 01 CA B0 6C FE 04 C2 83 6E ";
            S = S + "E1 AF 7E F5 CF 29 F1 E3 F5 7D B7 CA 5A 47 E5 CD ";
            S = S + "27 66 EB C1 F1 F5 28 1A CD 9F 00 F5 CD BD 00 F1 ";
            S = S + "77 23 0D 20 EF F1 C1 E1 CD 8F FE 22 64 F8 C5 C3 ";
            S = S + "54 66 CD 71 6C DA 83 6E 18 E6 CD FB 6C E5 06 00 ";
            S = S + "CD F5 6C E1 C9 AF 77 23 10 FC C9 2A 64 F8 11 09 ";
            S = S + "00 19 C9 CD 94 FE CD 6A 6A 28 20 3E 0A 38 21 CD ";
            S = S + "99 FE 18 22 CD 94 FE CD 6A 6A 28 0F 3E 0C 38 10 ";
            S = S + "CD 9E FE 18 11 CD 94 FE CD 6A 6A CA 77 6E 3E 0E ";
            S = S + "DA 8F 6F CD A3 FE C3 80 6E CD 94 FE CD 6A 6A 3E ";
            S = S + "10 38 ED CD A8 FE 18 EE CD 4A 01 CA 40 46 AF CD ";
            S = S + "24 6B C3 71 6E 0E 01 FE 23 C0 C5 CD 1B 52 CF 2C ";
            S = S + "7B E5 CD AA 6A 7E E1 C1 B9 28 0E FE 04 28 0A FE ";
            S = S + "08 20 03 79 FE 02 C2 7D 6E 7E C9 01 17 63 C5 AF ";
            S = S + "C3 24 6B EF 01 F1 4B 11 20 2C 20 17 5A 18 14 01 ";
            S = S + "FF 4A C5 CD 55 6D CD A4 5E CD 58 30 D5 01 7B 48 ";
            S = S + "AF 57 5F F5 C5 E5 CD 71 6C DA 83 6E FE 20 20 04 ";
            S = S + "14 15 20 F2 FE 22 20 0E 7B FE 2C 3E 22 20 07 57 ";
            S = S + "5F CD 71 6C 38 47 21 5E F5 06 FF 4F 7A FE 22 79 ";
            S = S + "28 2A FE 0D E5 28 50 E1 FE 0A 20 20 4F 7B FE 2C ";
            S = S + "79 C4 61 6E CD 71 6C 38 24 FE 0A 28 EF FE 0D 20 ";
            S = S + "0B 7B FE 20 28 12 FE 2C 3E 0D 28 0C B7 28 09 BA ";
            S = S + "28 0B BB 28 08 CD 61 6E CD 71 6C 30 BE E5 FE 22 ";
            S = S + "28 04 FE 20 20 2B CD 71 6C 38 26 FE 20 28 F7 FE ";
            S = S + "2C 28 1E FE 0D 20 09 CD 71 6C 38 15 FE 0A 28 11 ";
            S = S + "4F CD 62 6C 30 06 CD AD FE C3 80 6E 3E 12 CD 8F ";
            S = S + "6F E1 36 00 21 5D F5 7B D6 20 28 07 06 00 CD 38 ";
            S = S + "66 E1 C9 EF F5 D7 F1 F5 DC 99 32 F1 D4 99 32 E1 ";
            S = S + "C9 B7 C8 77 23 05 C0 F1 C3 42 6E 1E 38 01 1E 36 ";
            S = S + "01 1E 39 01 1E 35 01 1E 3B 01 1E 32 01 1E 34 01 ";
            S = S + "1E 33 01 1E 37 01 1E 3A AF 32 7C F8 32 AE FC C3 ";
            S = S + "6F 40 CD 0E 6A D5 CF 2C CD 0B 6F EB 22 BF FC EB ";
            S = S + "D5 CF 2C CD 0B 6F EB 22 7D F8 EB 2B D7 28 0A CF ";
            S = S + "2C CD 0B 6F EB 22 BF FC EB C1 D1 E5 C5 7A FE FF ";
            S = S + "CA D7 6F C3 6B 6E CD 0E 6A D5 AF 32 BE FC 2B D7 ";
            S = S + "01 00 00 28 13 CF 2C FE 52 20 08 32 BE FC D7 28 ";
            S = S + "07 CF 2C CD 0B 6F 42 4B D1 E5 C5 7A FE FF CA 14 ";
            S = S + "70 C3 6B 6E 3A BE FC B7 28 0C AF CD 24 6B 21 F3 ";
            S = S + "6C E5 2A BF FC E9 E1 AF C3 24 6B CD 64 4C E5 CD ";
            S = S + "39 54 D1 EB C9 CD B2 FE 7E FE 3A 38 1A E5 53 7E ";
            S = S + "23 1D 28 0A FE 3A 28 15 7E 23 1D F2 24 6F 5A E1 ";
            S = S + "AF 3E FF CD B7 FE C9 CD BC FE C3 6B 6E 7A 93 3D ";
            S = S + "C1 D5 C5 4F 47 11 76 6F E3 E5 CD A9 4E C5 47 1A ";
            S = S + "23 13 B8 C1 20 0D 0D 20 F1 1A B7 F2 63 6F E1 E1 ";
            S = S + "D1 B7 C9 B7 FA 59 6F 1A 87 13 30 FB 48 E1 E5 1A ";
            S = S + "B7 20 D7 C3 F8 55 43 41 53 FF 4C 50 54 FE 43 52 ";
            S = S + "54 FD 47 52 50 FC 00 C7 71 A6 72 A2 71 82 71 CD ";
            S = S + "C6 FE E5 D5 F5 11 04 00 19 7E FE FC DA 4A 56 3E ";
            S = S + "FF 96 87 5F 21 87 6F 19 5E 23 56 F1 6F 26 00 19 ";
            S = S + "5E 23 56 EB D1 E3 C9 CD 98 70 2B D7 28 05 CF 2C ";
            S = S + "CD 2D 7A E5 3E D3 CD 25 71 2A C2 F6 22 7D F8 2A ";
            S = S + "76 F6 CD 3E 71 E1 C9 3E D0 CD 25 71 AF CD F8 72 ";
            S = S + "E1 E5 CD 03 70 2A 7D F8 E5 CD 03 70 2A BF FC CD ";
            S = S + "03 70 D1 E1 7E CD DE 72 E7 30 03 23 18 F6 CD F0 ";
            S = S + "00 E1 C9 7D CD DE 72 7C C3 DE 72 CD D4 72 6F CD ";
            S = S + "D4 72 67 C9 0E D0 CD B8 70 CD E9 72 C1 CD 0B 70 ";
            S = S + "09 EB CD 0B 70 09 E5 CD 0B 70 22 BF FC EB D1 CD ";
            S = S + "D4 72 77 E7 28 03 23 18 F6 CD E7 00 C3 F4 6E D6 ";
            S = S + "91 28 02 AF 01 2F 23 FE 01 F5 CD 8C 70 0E D3 CD ";
            S = S + "B8 70 F1 32 F8 F7 DC 87 62 3A F8 F7 FE 01 32 F5 ";
            S = S + "F3 F5 CD EA 54 F1 2A 76 F6 CD 5D 71 20 10 22 C2 ";
            S = S + "F6 21 D7 3F CD E8 7B 2A 76 F6 E5 C3 37 42 23 EB ";
            S = S + "2A C2 F6 E7 DA 71 70 1E 14 C3 6F 40 2B D7 20 08 ";
            S = S + "E5 21 66 F8 06 06 18 19 CD 64 4C E5 CD 0F 68 2B ";
            S = S + "2B 46 0E 06 21 66 F8 1A 77 23 13 0D 28 08 10 F7 ";
            S = S + "41 36 20 23 10 FB E1 C9 CD E9 72 06 0A CD D4 72 ";
            S = S + "B9 20 F5 10 F8 21 71 F8 E5 06 06 CD D4 72 77 23 ";
            S = S + "10 F9 E1 11 66 F8 06 06 1A 13 FE 20 20 04 10 F8 ";
            S = S + "18 0D 11 66 F8 06 06 1A BE 20 0A 23 13 10 F8 21 ";
            S = S + "FF 70 C3 0D 71 C5 21 06 71 CD 0D 71 C1 18 B9 46 ";
            S = S + "6F 75 6E 64 3A 00 53 6B 69 70 20 3A 00 ED 5B 1C ";
            S = S + "F4 13 7A B3 C0 CD 78 66 21 71 F8 06 06 7E 23 DF ";
            S = S + "10 FB C3 28 73 CD F8 72 06 0A CD DE 72 10 FB 06 ";
            S = S + "06 21 66 F8 7E 23 CD DE 72 10 F9 C3 F0 00 E5 CD ";
            S = S + "EA 54 AF CD F8 72 D1 2A 7D F8 1A 13 CD DE 72 E7 ";
            S = S + "20 F8 2E 07 CD DE 72 2D 20 FA C3 F0 00 CD E9 72 ";
            S = S + "9F 2F 57 06 0A CD D4 72 5F CD 67 62 7B 96 A2 C2 ";
            S = S + "E7 00 73 7E B7 23 20 EB 10 EB 01 FA FF 09 AF C3 ";
            S = S + "E7 00 B6 71 C2 71 86 6E 96 71 5A 47 5A 47 5A 47 ";
            S = S + "5A 47 5A 47 5A 47 3A AF FC FE 02 DA 5A 47 79 C3 ";
            S = S + "8D 00 B6 71 C2 71 86 6E C3 71 5A 47 5A 47 5A 47 ";
            S = S + "5A 47 5A 47 5A 47 CD CD 72 FE 01 CA 6B 6E 22 64 ";
            S = S + "F8 73 C9 79 C3 A2 00 DB 71 05 72 86 6E 2A 72 3F ";
            S = S + "72 5A 47 5A 47 6D 72 5A 47 7C 72 E5 D5 01 06 00 ";
            S = S + "09 AF 77 32 B1 FC CD CD 72 FE 04 CA 6B 6E FE 01 ";
            S = S + "28 09 3E EA CD 25 71 D1 E1 18 C3 0E EA CD B8 70 ";
            S = S + "CD E7 00 18 F2 7E FE 01 28 1B 3E 1A E5 CD 8B 72 ";
            S = S + "CC 2F 72 E1 CD 81 72 28 0C E5 09 36 1A 23 0C 20 ";
            S = S + "FA E1 CD 2F 72 AF 32 B1 FC C9 79 CD 8B 72 C0 AF ";
            S = S + "CD F8 72 06 00 7E CD DE 72 23 10 F9 C3 F0 00 EB ";
            S = S + "21 B1 FC CD BE 72 EB CD 9B 72 20 14 E5 CD E9 72 ";
            S = S + "E1 06 00 CD D4 72 77 23 10 F9 CD E7 00 25 AF 47 ";
            S = S + "4F 09 7E FE 1A 37 3F C0 32 B1 FC 37 C9 CD 3F 72 ";
            S = S + "21 B1 FC 77 D6 1A D6 01 9F C3 9A 2E 21 B1 FC 71 ";
            S = S + "C9 01 06 00 09 7E 4F 36 00 18 16 5F 01 06 00 09 ";
            S = S + "7E 34 23 23 23 E5 4F 09 73 E1 C9 01 06 00 09 7E ";
            S = S + "34 23 23 23 A7 C9 B6 71 C2 71 86 6E BA 72 5A 47 ";
            S = S + "5A 47 5A 47 5A 47 5A 47 5A 47 79 C3 4D 01 7E 36 ";
            S = S + "00 A7 C8 33 33 FE 1A 37 3F C0 77 37 C9 7B FE 08 ";
            S = S + "CA 6B 6E C9 E5 D5 C5 CD E4 00 30 24 18 14 E5 D5 ";
            S = S + "C5 F5 CD ED 00 30 18 18 09 E5 D5 C5 F5 CD E1 00 ";
            S = S + "30 0D CD E7 00 C3 B2 73 E5 D5 C5 F5 CD EA 00 F1 ";
            S = S + "C1 D1 E1 C9 AF 32 16 F4 3A 15 F4 B7 C8 3E 0D CD ";
            S = S + "1C 73 3E 0A CD 1C 73 AF 32 15 F4 C9 CD A5 00 D0 ";
            S = S + "C3 B2 73 3A 61 F6 B7 C8 CD E9 FE 3E 0D DF 3E 0A ";
            S = S + "DF CD 4A 01 28 02 AF C9 3A 16 F4 B7 28 05 AF 32 ";
            S = S + "15 F4 C9 32 61 F6 C9 D7 E5 CD 9C 00 28 0C CD 9F ";
            S = S + "00 F5 CD 25 66 F1 5F CD 21 68 21 D6 3F 22 F8 F7 ";
            S = S + "3E 03 32 63 F6 E1 C9 DF FE 0A C0 3E 0D DF CD 31 ";
            S = S + "73 3E 0A C9 CD EE FE 06 FF 21 5E F5 CD 71 6C 38 ";
            S = S + "16 77 FE 0D 28 0B FE 09 28 04 FE 0A 28 EE 23 10 ";
            S = S + "EB AF 77 21 5D F5 C9 04 20 F7 3A 7C F8 E6 80 32 ";
            S = S + "7C F8 CD 7B 6D 3A 66 F8 A7 CA 1E 41 CD 9A 62 C3 ";
            S = S + "01 46 1E 13 C3 6F 40 1E FF 28 0B D6 EB 5F 28 05 ";
            S = S + "CF 95 1E 01 3E D7 7B C3 F3 00 CD 1C 52 FE 0E D2 ";
            S = S + "5A 47 F5 CF 2C CD 1C 52 F1 FE 07 20 04 CB B3 CB ";
            S = S + "FB C3 93 00 20 CD C5 FF E5 21 2E 75 22 56 F9 3E ";
            S = S + "00 32 35 FB 21 F6 FF 39 22 36 FB E1 F5 CD 64 4C ";
            S = S + "E3 E5 CD D0 67 CD DF 2E 7B B7 20 07 1E 01 01 E4 ";
            S = S + "73 51 48 F1 F5 CD 50 01 73 23 72 23 71 23 54 5D ";
            S = S + "01 1C 00 09 EB 73 23 72 C1 E1 04 78 FE 03 30 16 ";
            S = S + "2B D7 28 05 C5 CF 2C 18 C4 78 32 38 FB CD 07 75 ";
            S = S + "04 78 FE 03 38 F3 2B D7 C2 55 40 E5 AF F5 32 38 ";
            S = S + "FB 47 CD 21 75 DA D6 74 78 CD 50 01 7E B7 CA D6 ";
            S = S + "74 32 3B FB 23 5E 23 56 23 ED 53 3C FB 5E 23 56 ";
            S = S + "23 E5 2E 24 CD 53 01 E5 2A 36 FB 2B C1 F3 CD 53 ";
            S = S + "62 D1 60 69 F9 FB 3E FF 32 58 F9 C3 A2 56 3A 3B ";
            S = S + "FB B7 20 03 CD 07 75 3A 38 FB CD 50 01 3A 3B FB ";
            S = S + "77 23 ED 5B 3C FB 73 23 72 21 00 00 39 EB 2A 36 ";
            S = S + "FB F3 F9 C1 C1 C1 E5 B7 ED 52 28 18 3E F0 A5 B4 ";
            S = S + "C2 5A 47 2E 24 CD 53 01 C1 0B CD 53 62 E1 2B 70 ";
            S = S + "2B 71 18 02 C1 C1 FB F1 3C FE 03 DA 4D 74 F3 3A ";
            S = S + "9B FC FE 03 28 1C 3A 35 FB 07 38 07 21 40 FB 34 ";
            S = S + "CD 99 00 FB 21 35 FB 7E F6 80 77 FE 83 C2 4C 74 ";
            S = S + "E1 C9 CD 90 00 18 F9 3A 35 FB 3C 32 35 FB 1E FF ";
            S = S + "E5 C5 D5 3A 38 FB F3 CD F9 00 FB D1 28 F4 C1 E1 ";
            S = S + "C9 3A 38 FB C5 F3 CD F6 00 FB C1 FE 08 C9 41 3E ";
            S = S + "76 42 3E 76 43 3E 76 44 3E 76 45 3E 76 46 3E 76 ";
            S = S + "47 3E 76 CD 9E 75 D6 86 75 D3 BE 75 CE 21 76 CF ";
            S = S + "EF 75 D2 FC 75 D4 E2 75 CC C8 75 58 82 57 00 10 ";
            S = S + "12 14 16 00 00 02 04 06 08 0A 0A 0C 0E 10 5D 0D ";
            S = S + "9C 0C E7 0B 3C 0B 9B 0A 02 0A 73 09 EB 08 6B 08 ";
            S = S + "F2 07 80 07 14 07 38 02 1E 08 3E 0F BB 38 50 AF ";
            S = S + "B2 20 4C 2E 12 CD 53 01 3E 40 A6 B3 77 C9 7B 38 ";
            S = S + "03 2F 3C 5F B2 28 38 2E 13 CD 53 01 E5 7E 23 66 ";
            S = S + "6F E7 E1 C8 73 23 72 2B 2B 3E 40 B6 77 C9 7B FE ";
            S = S + "10 30 1C F6 10 5F 18 C7 38 02 1E 04 7B FE 41 30 ";
            S = S + "0E 2E 10 CD 53 01 AF B2 20 05 B3 28 02 77 C9 CD ";
            S = S + "5A 47 38 02 1E 78 7B FE 20 38 F4 2E 11 18 E4 38 ";
            S = S + "02 1E 04 7B FE 09 30 E7 2E 0F 18 D7 38 02 1E 04 ";
            S = S + "AF B2 20 DB B3 28 D8 FE 41 30 D4 21 00 00 E5 2E ";
            S = S + "10 CD 53 01 E5 23 23 7E 32 39 FB 36 80 2B 2B 18 ";
            S = S + "7B 30 BC AF B2 20 B8 B3 28 E1 FE 61 30 B1 7B 06 ";
            S = S + "00 58 D6 0C 1C 30 FB C6 0C 87 4F C3 73 76 41 79 ";
            S = S + "D6 40 87 4F CD EE 56 28 1C FE 23 28 19 FE 2B 28 ";
            S = S + "15 FE 2D 28 05 CD 0B 57 18 0B 0D 78 FE 43 28 04 ";
            S = S + "FE 46 20 01 0D 0D 2E 0F CD 53 01 5E 06 00 21 5F ";
            S = S + "75 09 4E 21 6E 75 09 7B 5E 23 56 3D 28 09 CB 3A ";
            S = S + "CB 1B 18 F7 CD 5A 47 8B 5F 8A 93 57 D5 2E 10 CD ";
            S = S + "53 01 4E E5 CD EE 56 28 10 CD 2F 57 3E 40 BB 38 ";
            S = S + "E3 AF B2 20 DF B3 28 01 4B E1 16 00 42 23 5E E5 ";
            S = S + "CD 4A 31 EB CD CB 2F CD 0D 2F 21 54 77 CD BE 2E ";
            S = S + "CD 9F 28 CD 8A 2F 54 5D CD EE 56 28 16 FE 2E 20 ";
            S = S + "0F CB 3A CB 1B ED 5A 3E E0 A4 28 EC AC 67 18 03 ";
            S = S + "CD 0B 57 11 05 00 E7 38 01 EB 01 F7 FF E1 E5 09 ";
            S = S + "72 23 73 23 0E 02 E3 23 5E 7B E6 BF 77 E3 3E 80 ";
            S = S + "B3 77 23 0C E3 7B E6 40 28 0C 23 5E 23 56 E1 72 ";
            S = S + "23 73 23 0C 0C FE E1 D1 7A B3 28 05 72 23 73 0C ";
            S = S + "0C 2E 07 CD 53 01 71 79 D6 02 0F 0F 0F 23 B6 77 ";
            S = S + "2B 7A B3 20 0C E5 3A 39 FB F6 80 01 0B 00 09 77 ";
            S = S + "E1 D1 46 23 5E 23 CD 10 75 10 F9 CD 21 75 DA 8E ";
            S = S + "74 C3 A2 56 00 00 45 12 06 80 11 06 00 FE C7 C3 ";
            S = S + "93 79 78 C3 35 6C ED 5B DC F3 D5 FE 2C 28 0B CD ";
            S = S + "1C 52 3C D1 57 D5 2B D7 28 25 CF 2C FE 2C 28 0B ";
            S = S + "CD 1C 52 3C D1 5F D5 2B D7 28 14 CF 2C CD 1C 52 ";
            S = S + "A7 3E 79 20 01 3D F5 3E 1B DF F1 DF 3E 35 DF E3 ";
            S = S + "CD C6 00 E1 C9 E5 21 6A FC 18 24 E5 21 6D FC 18 ";
            S = S + "1E CF 45 CF 52 CF FF CF 94 E5 21 7F FC 18 10 3E ";
            S = S + "04 CD 08 7C 2B D7 E5 16 00 21 70 FC 19 19 19 CD ";
            S = S + "FE 77 18 0E CD 1C 52 3D FE 0A D2 5A 47 7E E5 CD ";
            S = S + "E8 77 E1 F1 D7 C3 12 46 16 00 21 CD FB 19 E5 21 ";
            S = S + "49 FC 19 19 19 CD FE 77 7E E6 01 E1 77 C9 FE 95 ";
            S = S + "CA 1B 63 FE EB CA 2B 63 FE 90 CA 31 63 C3 55 40 ";
            S = S + "CD EA FD 01 0A 00 FE CC C8 01 01 0A FE 90 C8 04 ";
            S = S + "FE C7 C8 FE FF D8 E5 D7 FE A3 28 07 FE 85 28 08 ";
            S = S + "E1 37 C9 C1 01 05 0C C9 D7 FE 45 20 F3 C1 D7 CF ";
            S = S + "52 CF FF CF 94 CF EF CD 2F 54 7A B3 CA 5A 47 EB ";
            S = S + "22 A0 FC 22 A2 FC EB 01 01 11 2B C9 E5 47 87 80 ";
            S = S + "6F 26 00 01 4D FC 09 73 23 72 E1 C9 FE 93 20 3E ";
            S = S + "D7 E5 21 7F F8 0E 0A 06 10 7E 23 CD AB 00 38 11 ";
            S = S + "05 28 1B 7E 23 5F CD AB 00 28 06 3E 01 DF 7B 18 ";
            S = S + "0A FE 7F 28 04 FE 20 30 02 3E 20 DF 10 DB CD 28 ";
            S = S + "73 0D 20 D3 E1 C9 D7 C3 CF 00 D7 C3 CC 00 FE 28 ";
            S = S + "CA D4 77 FE 95 28 EF FE EB 28 EF CD 1C 52 3D FE ";
            S = S + "0A D2 5A 47 EB 6F 26 00 29 29 29 29 01 7F F8 09 ";
            S = S + "E5 EB CF 2C CD 64 4C E5 CD D0 67 46 23 5E 23 56 ";
            S = S + "E1 E3 0E 0F 78 A7 28 0D 1A A7 CA 5A 47 77 13 23 ";
            S = S + "0D 28 07 10 F3 70 23 0D 20 FB 71 CD C9 00 E1 C9 ";
            S = S + "D7 E5 2A 9E FC CD 36 32 E1 C9 D7 E5 3A DC F3 18 ";
            S = S + "21 CF EF CD 2F 54 ED 53 9E FC C9 D7 3E 03 CD 08 ";
            S = S + "7C E5 3A 3F FB 1D FA 38 79 0F 1D F2 29 79 3E 00 ";
            S = S + "30 01 3D CD 9A 2E E1 C9 E6 07 28 F7 3E FF 18 F3 ";
            S = S + "CD 1F 52 FE 03 30 0A CD D5 00 18 1A CD 1F 52 FE ";
            S = S + "05 D2 5A 47 CD D8 00 C3 9A 2E CD 1F 52 3D FE 0C ";
            S = S + "30 EF 3C CD DE 00 C3 CF 4F CD 1F 52 FE 14 30 E1 ";
            S = S + "F5 CD DB 00 47 F1 CD 3E 7B FE 02 78 38 E8 18 D7 ";
            S = S + "DD 21 55 01 C3 5F 01 32 7C F8 F3 D3 99 3E AE D3 ";
            S = S + "99 FB C9 CA AF 7A DD 21 B1 01 CD 5F 01 D0 C3 62 ";
            S = S + "77 CD 57 42 23 22 C2 F6 C9 57 D5 2B D7 28 0D CF ";
            S = S + "2C CD 1C 52 D1 FE 10 D0 32 EB F3 D5 D1 F1 E5 EB ";
            S = S + "22 E9 F3 7D 32 F2 F3 CD 62 00 E1 C9 CD C0 FF DD ";
            S = S + "21 59 01 C3 5F 01 CD 65 01 38 07 DD 21 6D 00 C3 ";
            S = S + "5F 01 F5 CD AB 57 C3 F1 57 CD 65 01 38 07 DD 21 ";
            S = S + "75 00 C3 5F 01 CD 9C 57 C3 AA 58 CD 65 01 38 07 ";
            S = S + "DD 21 69 00 C3 5F 01 CD 9C 57 C3 C8 59 CD 65 01 ";
            S = S + "38 07 DD 21 85 00 C3 5F 01 CD 0E 01 C3 42 59 F2 ";
            S = S + "E5 64 2B C3 EA 64 CD 1C 52 32 17 F4 C9 CD 1C 52 ";
            S = S + "3D FE 02 D2 5A 47 E5 01 05 00 A7 21 FC F3 28 01 ";
            S = S + "09 11 06 F4 ED B0 E1 C9 FE 24 C2 AB 77 3A AF FC ";
            S = S + "A7 CA 5A 47 CD A0 7A D5 CD 5F 4C E3 E5 CD D0 67 ";
            S = S + "23 5E 23 56 CD 8A 00 4F 06 00 2B 2B 3D BE 7E 38 ";
            S = S + "0C E1 E5 F5 AF CD 6B 01 F1 A7 4F 06 00 EB D1 C4 ";
            S = S + "5C 00 E1 C9 CD 9F 7A E5 D5 CD 8A 00 4F 06 00 C5 ";
            S = S + "CD 27 66 2A 99 F6 EB C1 E1 CD 59 00 C3 54 66 D7 ";
            S = S + "CF 24 3E FF CD 08 7C E5 7B CD 84 00 EB E1 C9 05 ";
            S = S + "FA 5A 47 C3 F4 7C A7 CA 5A 47 D7 CD 1C 52 FE 20 ";
            S = S + "D2 5A 47 E5 CD 87 00 E3 CF 2C FE 2C 28 2B CD 9C ";
            S = S + "57 E3 7B CD 4D 00 78 87 79 06 00 30 04 C6 20 06 ";
            S = S + "80 23 CD 4D 00 23 23 CD 4A 00 E6 0F B0 CD 4D 00 ";
            S = S + "2B 2B 2B E3 2B D7 C1 C8 C5 CF 2C FE 2C 28 1E CD ";
            S = S + "1C 52 FE 10 D2 5A 47 E3 23 23 23 CD 4A 00 E6 80 ";
            S = S + "B3 CD 4D 00 2B 2B 2B E3 2B D7 C1 C8 C5 CF 2C CD ";
            S = S + "1C 52 CD 8A 00 7B 30 07 FE 40 D2 5A 47 87 87 E3 ";
            S = S + "23 23 CD 4D 00 E1 C9 DD 21 61 01 C3 5F 01 C6 04 ";
            S = S + "E6 F3 3D C9 C3 47 00 DD 21 65 01 C3 5F 01 16 00 ";
            S = S + "21 DF F3 19 7E CD CF 4F E1 C9 DD 21 69 01 C3 5F ";
            S = S + "01 21 00 00 39 7C D3 A8 7D 32 FF FF 79 01 77 0C ";
            S = S + "11 81 F3 21 80 F3 36 00 ED B0 4F 06 04 21 C4 FC ";
            S = S + "CB 19 9F E6 80 77 2B 10 F7 DB A8 4F AF D3 A8 3A ";
            S = S + "FF FF 2F 6F 3E 40 D3 A8 3A FF FF 2F 67 3E 80 D3 ";
            S = S + "A8 3A FF FF 2F 5F 3E C0 D3 A8 3A FF FF 2F 57 79 ";
            S = S + "D3 A8 22 C5 FC EB 22 C7 FC ED 56 C3 76 7C 21 F9 ";
            S = S + "A0 2B 7C B5 20 FB C3 31 04 FF 07 DD 21 6D 01 C3 ";
            S = S + "5F 01 3E 50 D3 AA 3E 02 D3 99 3E 89 D3 99 C3 BE ";
            S = S + "7B C9 DD 21 71 01 18 0A DD 21 81 01 18 04 DD 21 ";
            S = S + "89 01 C3 5F 01 DD 21 75 01 C3 5F 01 CF 4F CD 8A ";
            S = S + "2F 11 00 40 E7 D8 18 6B F5 CF 28 CD 1C 52 F1 BB ";
            S = S + "38 61 CF 29 7B C9 CD EF FD 18 58 C3 E3 7C 18 53 ";
            S = S + "CD F9 FD 18 4E CD FE FD 18 49 CD 03 FE 18 44 C3 ";
            S = S + "03 7D 18 3F CD 0D FE 18 3A CD 12 FE 18 35 CD 17 ";
            S = S + "FE 18 30 CD 1C FE 18 2B CD 21 FE 18 26 CD 26 FE ";
            S = S + "18 21 CD 2B FE 18 1C CD 30 FE 18 17 CD 35 FE 18 ";
            S = S + "12 CD 3A FE 18 0D CD 3F FE 18 08 CD 44 FE 18 03 ";
            S = S + "CD 49 FE C3 5A 47 31 76 F3 01 2F 02 11 9B FD 21 ";
            S = S + "9A FD 36 C9 ED B0 21 80 F3 22 4A FC CD 5D 7D 22 ";
            S = S + "48 FC 01 90 00 11 80 F3 21 27 7F ED B0 CD 3E 00 ";
            S = S + "AF 32 60 F6 32 7C F8 3E 2C 32 5D F5 3E 3A 32 1E ";
            S = S + "F4 2A 04 00 22 20 F9 21 E4 F6 22 4C F7 22 74 F6 ";
            S = S + "01 C8 00 09 22 72 F6 3E 01 32 C3 F6 CD 6B 7E CD ";
            S = S + "E5 62 2A 48 FC AF 77 23 22 76 F6 CD 87 62 CD 3B ";
            S = S + "00 18 31 CD F4 FD DD 21 79 01 C3 5F 01 DD 21 85 ";
            S = S + "01 C3 5F 01 3A AF FC FE 04 DA B6 7A DD 21 51 01 ";
            S = S + "C3 5F 01 DD 21 8D 01 CD 5F 01 D0 CD 08 FE C3 5A ";
            S = S + "47 00 00 00 CD 62 01 2A 48 FC AF 77 23 22 76 F6 ";
            S = S + "CD 87 62 CD 29 7D C3 1F 41 18 06 00 00 00 00 ED ";
            S = S + "7C CD EE 7B 21 09 FD 7E E6 20 77 00 00 21 FD 7E ";
            S = S + "CD 78 66 C9 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 21 00 EF ";
            S = S + "7E 2F 77 BE 2F 77 20 09 2C 20 F5 7C 3D F0 67 18 ";
            S = S + "EF 2E 00 24 C9 F3 0E 00 11 C1 FC 21 C9 FC 1A B1 ";
            S = S + "4F D5 23 E5 21 00 40 CD 1A 7E E5 21 41 42 E7 E1 ";
            S = S + "06 00 20 2A CD 1A 7E E5 C5 D5 DD E1 79 F5 FD E1 ";
            S = S + "C4 F5 7F C1 E1 CD 1A 7E C6 FF CB 18 CD 1A 7E C6 ";
            S = S + "FF CB 18 CD 1A 7E C6 FF CB 18 11 F8 FF 19 E3 70 ";
            S = S + "23 E3 11 FE 3F 19 7C FE C0 38 BC E1 23 79 A7 11 ";
            S = S + "0C 00 F2 E0 7D C6 04 4F FE 90 38 A6 E6 03 4F 3E ";
            S = S + "19 D1 13 0C 79 FE 04 38 95 21 C9 FC 06 40 7E 87 ";
            S = S + "38 04 23 10 F9 C9 CD 2A 7E CD 24 00 2A C2 F6 11 ";
            S = S + "00 C0 E7 30 04 EB 22 C2 F6 2A 08 80 23 22 76 F6 ";
            S = S + "7C 32 B1 FB CD 9A 62 C3 01 46 CD 1E 7E 5A 79 C5 ";
            S = S + "D5 CD 0C 00 D1 C1 57 B3 23 C9 3E 40 90 47 26 00 ";
            S = S + "1F CB 1C 1F CB 1C 1F 1F E6 03 4F 78 06 00 E5 21 ";
            S = S + "C1 FC 09 E6 0C B1 4F 7E E1 B1 C9 CF B7 CF EF CD ";
            S = S + "1C 52 C2 55 40 FE 10 D2 5A 47 22 A7 F6 F5 CD 1C ";
            S = S + "6C F1 CD 6B 7E CD A7 62 C3 01 46 F5 2A 4A FC 11 ";
            S = S + "F5 FE 19 3D F2 72 7E EB 2A 74 F6 44 4D 2A 72 F6 ";
            S = S + "7D 91 6F 7C 98 67 F1 E5 F5 01 8C 00 09 44 4D 2A ";
            S = S + "C2 F6 09 E7 D2 75 62 F1 32 5F F8 6B 62 22 60 F8 ";
            S = S + "2B 2B 22 72 F6 C1 7D 91 6F 7C 98 67 22 74 F6 2B ";
            S = S + "2B C1 F9 C5 3A 5F F8 6F 2C 26 00 29 19 EB D5 01 ";
            S = S + "09 01 73 23 72 23 EB 36 00 09 EB 3D F2 C2 7E E1 ";
            S = S + "01 09 00 09 22 62 F8 C9 4D 53 58 20 20 73 79 73 ";
            S = S + "74 65 6D 00 76 65 72 73 69 6F 6E 20 32 2E 31 0D ";
            S = S + "0A 00 4D 53 58 20 42 41 53 49 43 20 00 43 6F 70 ";
            S = S + "79 72 69 67 68 74 20 31 39 38 36 20 62 79 20 4D ";
            S = S + "69 63 72 6F 73 6F 66 74 0D 0A 00 20 42 79 74 65 ";
            S = S + "73 20 66 72 65 65 00 D3 A8 5E 18 03 D3 A8 73 7A ";
            S = S + "D3 A8 C9 D3 A8 08 CD 98 F3 08 F1 D3 A8 08 C9 DD ";
            S = S + "E9 5A 47 5A 47 5A 47 5A 47 5A 47 5A 47 5A 47 5A ";
            S = S + "47 5A 47 5A 47 25 1D 1D 18 0E 00 00 00 00 00 08 ";
            S = S + "00 00 00 00 00 18 00 20 00 00 00 1B 00 38 00 18 ";
            S = S + "00 20 00 00 00 1B 00 38 00 08 00 00 00 00 00 1B ";
            S = S + "00 38 01 01 01 00 00 E0 00 00 00 00 00 00 00 FF ";
            S = S + "0F 04 04 C3 00 00 C3 00 00 0F 59 F9 FF 01 32 F0 ";
            S = S + "FB F0 FB 53 5C 26 2D 0F 25 2D 0E 16 1F 53 5C 26 ";
            S = S + "2D 0F 00 01 00 01 3A 11 89 FD A7 C0 04 C9 CD D1 ";
            S = S + "7F 5E 18 04 CD D1 7F 73 DB A8 E6 3F D3 A8 79 18 ";
            S = S + "15 0F 0F E6 03 57 DB A8 47 E6 3F D3 A8 3A FF FF ";
            S = S + "2F 4F E6 FC B2 57 32 FF FF 78 D3 A8 7B C9 00 00 ";
            S = S + "00 00 00 00 00 DB 99 07 30 FB C3 1C 00 C3 7D F3 ";

            return S;
        }

         public static string gs_Get_MSX2X_BIOS()
        {
            string S;

            S = "";

          //== MSX2 BIOS EXT [0000H~3FFFH,4000H,16384] ==
            S = S + "43 44 36 03 49 16 2A 37 C3 32 1D 00 00 00 00 00 ";
            S = S + "C3 3A 1D 00 C3 18 02 00 C3 77 05 00 C3 62 02 00 ";
            S = S + "7C 92 C0 7D 93 C9 00 00 C3 0E 06 00 00 00 00 00 ";
            S = S + "C3 46 02 00 00 00 00 00 08 D9 F5 C5 D5 E5 08 D9 ";
            S = S + "DD E5 FD E5 DD 21 38 00 FD 2A C0 FC CD 8D 05 FD ";
            S = S + "E1 DD E1 08 D9 E1 D1 C1 F1 08 D9 FB ED 4D 00 00 ";
            S = S + "00 00 00 00 00 00 C3 D6 FD FB C3 51 26 FB C3 56 ";
            S = S + "25 FB C3 6F 25 FB C3 07 26 FB C3 2A 26 FB C3 3F ";
            S = S + "26 FB C3 48 26 FB C3 23 28 FB C3 0E 11 FB C3 C4 ";
            S = S + "12 FB C3 42 13 FB C3 84 13 FB C3 AD 13 FB C3 B5 ";
            S = S + "13 FB C3 26 14 FB C3 39 14 FB C3 E7 13 FB C3 4B ";
            S = S + "14 FB C3 FC 13 FB C3 8C 14 FB C3 14 14 FB C3 98 ";
            S = S + "14 FB C3 DB 14 FB C3 8F 15 FB C3 E7 27 FB C3 98 ";
            S = S + "28 FB C3 C3 09 FB C3 E5 09 FB C3 1A 0A FB C3 48 ";
            S = S + "0A FB C3 98 0A FB C3 42 0B FB C3 9C 0B FB C3 D2 ";
            S = S + "0B FB C3 22 0C FB C3 F5 06 FB C3 55 07 FB C3 6A ";
            S = S + "07 FB C3 7F 07 FB C3 D9 07 FB C3 CB 08 FB C3 D6 ";
            S = S + "08 FB C3 53 09 FB C3 FE 07 FB C3 64 08 FB C3 52 ";
            S = S + "0D FB C3 0F 0E FB C3 5D 0E FB C3 16 0F FB C3 47 ";
            S = S + "06 FB C3 8B 29 C9 C9 C9 C9 C9 C9 C9 C9 FB C3 A8 ";
            S = S + "06 FB C3 9F 0F FB C3 7E 0F FB C3 6A 0F FB C3 D3 ";
            S = S + "0F FB C3 8F 20 FB C3 F6 1D FB C3 E5 1E FB C3 DF ";
            S = S + "1F FB C3 C6 21 FB C3 E5 21 FB C3 20 22 FB C3 97 ";
            S = S + "22 FB C3 F4 22 FB C3 07 23 FB C3 33 18 FB C3 62 ";
            S = S + "1A FB C3 4E 1B FB C3 80 04 FB C3 70 04 FB C3 42 ";
            S = S + "23 FB C3 B9 2E FB C3 42 2F FB C3 DF 2E FB C3 A8 ";
            S = S + "30 FB C3 B4 31 FB C3 6F 30 FB C3 7C 30 FB C3 DD ";
            S = S + "34 FB C3 83 16 FB C3 BF 09 FB C3 00 00 FB C3 49 ";
            S = S + "10 78 E6 3F D3 A8 3A FF FF 2F 4F A2 5F 32 FF FF ";
            S = S + "78 A2 D3 A8 7B 32 C5 FC C5 D9 08 CD 98 F3 F3 08 ";
            S = S + "D9 C1 78 E6 3F D3 A8 79 32 FF FF 78 D3 A8 79 32 ";
            S = S + "C5 FC 08 D9 C9 FB C3 08 1D FB C3 10 1D CD DD 02 ";
            S = S + "FA 0D 02 DB A8 57 A1 B0 CD 80 F3 7B C9 E5 CD 02 ";
            S = S + "03 E3 C5 CD FD 01 18 1B D5 CD DD 02 FA 28 02 D1 ";
            S = S + "DB A8 57 A1 B0 C3 85 F3 E3 E5 CD 02 03 D1 E3 C5 ";
            S = S + "CD 18 02 C1 E3 F5 78 E6 3F B1 D3 A8 7D 32 FF FF ";
            S = S + "78 D3 A8 F1 E1 C9 E3 F5 D5 7E F5 FD E1 23 5E 23 ";
            S = S + "56 23 D5 DD E1 D1 F1 E3 D9 16 FC 18 08 D9 16 F3 ";
            S = S + "18 03 D9 16 F0 08 F3 3A C1 FC A7 DB A8 FA 76 02 ";
            S = S + "F5 A2 D9 C3 8C F3 47 3A F8 FA E6 03 20 06 7A FE ";
            S = S + "F3 C2 C1 01 78 E6 3F D3 A8 3A FF FF 2F 4F A2 32 ";
            S = S + "FF FF 5F 78 D3 A8 7B 32 C5 FC 78 C5 21 A6 02 E5 ";
            S = S + "F5 A2 D9 C3 8C F3 F3 D9 08 C1 78 E6 3F D3 A8 79 ";
            S = S + "32 FF FF 78 D3 A8 79 32 C5 FC 08 D9 C9 CD DD 02 ";
            S = S + "FA CA 02 DB A8 A1 B0 D3 A8 C9 E5 CD 02 03 4F 06 ";
            S = S + "00 7D A4 B2 21 C5 FC 09 77 E1 79 18 E0 F3 F5 7C ";
            S = S + "07 07 E6 03 5F 3E C0 07 07 1D F2 E7 02 5F 2F 4F ";
            S = S + "F1 F5 E6 03 3C 47 3E AB C6 55 10 FC 57 A3 47 F1 ";
            S = S + "A7 C9 F5 7A E6 C0 4F F1 F5 57 DB A8 47 E6 3F B1 ";
            S = S + "D3 A8 7A 0F 0F E6 03 57 3E AB C6 55 15 F2 1A 03 ";
            S = S + "A3 57 7B 2F 67 3A FF FF 2F 6F A4 B2 32 FF FF 78 ";
            S = S + "D3 A8 F1 E6 03 C9 21 F6 29 11 DF F3 01 08 00 ED ";
            S = S + "B0 11 E7 FF 01 10 00 ED B0 AF 32 F5 FA 32 F6 FA ";
            S = S + "CD 12 05 32 F8 FA 67 2E F7 22 FD FE 21 9C 3D 22 ";
            S = S + "FF FE 3A C1 FC 32 F7 FF 3E 2C 32 FF FA 3E 26 32 ";
            S = S + "01 FB 3E D3 D3 F7 CD F3 36 AF 0E FF D3 D8 3E 02 ";
            S = S + "D3 D9 21 0A 05 06 08 DB D9 BE 20 05 23 10 F8 CB ";
            S = S + "81 DB C0 FE FF 28 02 CB 91 DB F7 E6 77 FE 77 28 ";
            S = S + "02 CB 99 DB C8 FE FF 28 02 CB A1 AF D3 81 F5 F1 ";
            S = S + "D3 81 F5 F1 D3 81 F5 F1 3E 40 D3 81 E3 E3 DB 81 ";
            S = S + "E6 3F FE 05 20 02 CB A9 DB BB FE FF 28 02 CB B1 ";
            S = S + "79 D3 F5 CD F7 1C 06 00 CD D2 1C FE 0A 28 03 CD ";
            S = S + "31 04 CD F7 1C 06 03 CD D2 1C E6 01 F5 CD DB 1C ";
            S = S + "C1 FE 51 D2 DF 03 B7 CA DF 03 05 20 05 FE 21 D2 ";
            S = S + "DF 03 CD F7 1C 06 01 CD D2 1C 57 CD D2 1C 5F CD ";
            S = S + "F8 17 CD 0E 2A 06 02 21 00 00 2B 7D B4 20 FB 10 ";
            S = S + "F9 CD 3C 06 AF 01 00 40 CD 77 09 CD 1A 0A C3 9F ";
            S = S + "0F 21 1C 37 0E 02 06 0D 3E 04 91 CD 59 1A 06 0D ";
            S = S + "3E 0D 90 D3 B4 7E 23 FE FF 20 02 2B AF D3 B5 10 ";
            S = S + "EF 0D 20 E2 06 0D 3E 08 CD 59 1A AF CD 59 1A 3E ";
            S = S + "0D CD 59 1A 3E 01 CD F9 1C 06 0A 3E 01 C3 59 1A ";
            S = S + "37 CD 81 04 21 F2 7E CD F6 05 21 E4 7E C3 F6 05 ";
            S = S + "AF F5 CD F7 1C 06 03 CD D2 1C 4F E6 01 D1 F5 D5 ";
            S = S + "C5 79 07 07 E6 08 4F 3A E8 FF E6 F7 B1 47 0E 09 ";
            S = S + "CD 47 06 C1 CD DB 1C 5F F1 D5 F5 CD D2 1C 32 E9 ";
            S = S + "F3 32 F2 F3 CD D2 1C 32 EA F3 CD D2 1C 32 EB F3 ";
            S = S + "CD D2 1C 4F CB 09 9F 47 F1 30 01 78 32 DE F3 CB ";
            S = S + "09 9F 32 DB F3 CB 49 C5 01 05 00 21 FC F3 28 03 ";
            S = S + "21 01 F4 11 06 F4 ED B0 C1 CB 09 9F 32 17 F4 D1 ";
            S = S + "F1 32 B0 FC 32 AF FC D5 CD BF 09 D1 C3 FF 1F 0A ";
            S = S + "00 00 01 0D 01 0F 04 07 03 FF 00 40 20 10 08 04 ";
            S = S + "02 01 C5 E5 DB A8 E6 03 4F 06 00 21 C1 FC 09 B6 ";
            S = S + "4F 23 23 23 23 7E E6 03 07 07 B1 E1 C1 C9 DD 21 ";
            S = S + "6B 6E 18 2E DD 21 86 6E 18 28 DD 21 6E 6E 18 22 ";
            S = S + "DD 21 55 40 18 1C DD 21 5A 47 18 16 DD 21 6A 40 ";
            S = S + "18 10 DD 21 6D 40 18 0A DD 21 75 62 18 04 DD 21 ";
            S = S + "74 6E C3 18 06 DD 21 9F 00 18 22 DD 21 90 00 18 ";
            S = S + "1C DD 21 C9 00 18 16 DD 21 18 00 18 10 DD 21 0C ";
            S = S + "00 18 0A DD 21 14 00 18 04 DD 21 BD 00 C3 58 02 ";
            S = S + "DD 21 41 01 18 F7 DD 21 68 01 18 F1 DD 21 9C 57 ";
            S = S + "18 76 DD 21 AB 57 18 70 DD 21 28 73 18 46 DD 21 ";
            S = S + "23 73 18 40 DD 21 39 54 18 3A DD 21 0E 6A 18 34 ";
            S = S + "DD 21 24 6B 18 2E DD 21 6F 40 18 28 DD 21 12 34 ";
            S = S + "18 22 DD 21 58 30 18 1C DD 21 A4 5E 18 16 DD 21 ";
            S = S + "36 32 18 10 DD 21 CF 4F 18 0A DD 21 27 66 18 04 ";
            S = S + "DD 21 92 2F 18 22 DD 21 78 66 18 F8 DD 21 64 4C ";
            S = S + "18 16 DD 21 2F 54 18 10 DD 21 0F 52 18 0A DD 21 ";
            S = S + "1C 52 18 04 DD 21 D0 67 CD 62 02 FB C9 32 DE F3 ";
            S = S + "3A AF FC FE 02 C9 3A AF FC FE 04 C9 3A AF FC FE ";
            S = S + "05 C9 CD 34 10 3A E0 F3 F6 60 18 08 CD 34 10 3A ";
            S = S + "E0 F3 E6 3F 47 0E 01 ED 57 F5 E5 79 A7 20 31 78 ";
            S = S + "21 DF F3 AE E6 01 28 28 21 E8 FF 7E E6 CF 77 78 ";
            S = S + "E6 01 0F 0F 0F 0F B6 C5 47 0E 09 21 F7 FA 7E E6 ";
            S = S + "3F 77 78 07 07 2F E6 C0 B6 D3 F7 77 CD 47 06 C1 ";
            S = S + "78 F3 D3 99 79 F6 80 D3 99 C5 D5 50 79 06 00 FE ";
            S = S + "08 30 05 21 DF F3 18 07 FE 18 30 05 21 DF FF 09 ";
            S = S + "72 D1 C1 E1 F1 E0 FB C9 3A AF FC F5 C5 D5 E5 F3 ";
            S = S + "21 B8 06 CD C9 09 18 38 42 0B 9C 0B D2 0B 22 0C ";
            S = S + "D9 0B 56 0C 80 0C 97 0C C7 0C F5 C5 D5 E5 F3 AF ";
            S = S + "D3 99 3E 91 D3 99 CD 34 10 21 DF F3 06 08 7E 23 ";
            S = S + "D3 9B 10 FA 21 E7 FF 06 10 7E 23 D3 9B 10 FA FB ";
            S = S + "E1 D1 C1 F1 C9 CD 01 07 E5 21 00 00 CD E3 08 E1 ";
            S = S + "C9 3A E0 F3 47 0E 01 CD 47 06 2A 26 F9 01 00 08 ";
            S = S + "AF CD 77 09 3A E9 F3 5F 2A 28 F9 01 00 20 CD 26 ";
            S = S + "06 3E D1 38 02 3E D9 CD CB 08 23 23 79 CD CB 08 ";
            S = S + "23 0C 3A E0 F3 0F 0F 30 03 0C 0C 0C 7B CD CB 08 ";
            S = S + "23 10 DB CD 26 06 D8 2A 28 F9 01 00 02 ED 42 3A ";
            S = S + "E9 F3 C3 77 09 6F 26 00 29 29 29 CD 7F 07 FE 08 ";
            S = S + "28 02 29 29 EB 2A 26 F9 19 C9 6F 26 00 29 29 EB ";
            S = S + "2A 28 F9 19 C9 87 87 CD 6A 07 11 00 FE 19 C9 3A ";
            S = S + "E0 F3 0F 0F 3E 08 D0 3E 20 C9 CD C7 FD 2A 24 F9 ";
            S = S + "CD E3 08 3A 1F F9 2A 20 F9 01 00 08 F5 F1 F5 C5 ";
            S = S + "F3 CD 7D 05 FB C1 D3 98 23 0B 79 B0 20 EF F1 C9 ";
            S = S + "CD F1 08 79 B7 78 41 0E 98 EB 28 01 3C ED B2 3D ";
            S = S + "20 FB EB C9 EB CD E3 08 EB 79 B7 78 41 0E 98 28 ";
            S = S + "01 3C ED B3 3D 20 FB EB C9 26 00 6F 29 29 29 EB ";
            S = S + "2A 20 F9 19 11 40 FC 06 08 3A 1F F9 F5 E5 D5 C5 ";
            S = S + "CD 7D 05 FB C1 D1 E1 12 13 23 F1 10 EF C9 CD 26 ";
            S = S + "06 CA 95 08 30 0B CD 20 06 CA 95 08 D2 AD 08 18 ";
            S = S + "53 F5 C5 D5 E5 CD 80 29 3A EA F3 CD 4B 08 CD EB ";
            S = S + "29 AF 67 6F CD A5 29 AF CD DB 29 3A AF FC E6 02 ";
            S = S + "11 00 01 28 03 11 00 02 21 D4 00 CD C4 29 3E C0 ";
            S = S + "CD E3 29 CD 80 29 E1 D1 C1 F1 C9 47 3A AF FC FE ";
            S = S + "08 78 C8 07 07 07 07 B0 47 3A AF FC FE 06 78 C0 ";
            S = S + "0F 0F B0 C9 3A AF FC A7 2A 22 F9 20 11 3A B0 F3 ";
            S = S + "FE 29 30 05 01 C0 03 18 08 01 80 07 18 03 01 00 ";
            S = S + "03 3E 20 CD 77 09 CD C1 08 21 B2 FB 06 18 70 23 ";
            S = S + "10 FC C3 71 05 CD 9C 09 01 00 18 C5 2A C9 F3 3A ";
            S = S + "EA F3 CD 77 09 2A CB F3 C1 AF C3 77 09 CD 9C 09 ";
            S = S + "21 EA F3 7E 87 87 87 87 B6 2A D5 F3 01 00 06 18 ";
            S = S + "E9 21 01 01 22 DC F3 C9 CD DC 08 F5 CD E3 08 F1 ";
            S = S + "D3 98 C9 CD DC 08 CD F1 08 DB 98 C9 F5 7C E6 3F ";
            S = S + "67 F1 C9 C5 D5 E5 EB CD 14 09 7C E6 3F F6 40 18 ";
            S = S + "0A C5 D5 E5 EB CD 14 09 7C E6 3F F5 7C E6 C0 B2 ";
            S = S + "07 07 F3 D3 99 3E 8E D3 99 7D D3 99 F1 D3 99 FB ";
            S = S + "E1 D1 C1 C9 3A AF FC 4F 3A F6 FA A7 21 25 09 C2 ";
            S = S + "CA 09 EB 57 C9 37 09 45 09 45 09 45 09 45 09 44 ";
            S = S + "09 44 09 43 09 43 09 3A B0 F3 FE 29 3A F6 FA 38 ";
            S = S + "06 18 03 87 87 87 87 87 87 87 87 67 3E 00 6F 8F ";
            S = S + "19 57 C9 CD 2C 06 D2 97 09 CD A5 09 3D FA 8A 09 ";
            S = S + "F5 CD 9C 09 F1 C0 21 EA F3 3A E9 F3 87 87 87 87 ";
            S = S + "B6 2A BF F3 01 20 00 F5 CD E3 08 79 B7 28 01 04 ";
            S = S + "F1 D3 98 0D C2 81 09 10 F8 C9 21 EA F3 3A E9 F3 ";
            S = S + "87 87 87 87 B6 18 08 FE 08 C4 A5 09 3A EB F3 47 ";
            S = S + "0E 07 C3 47 06 F5 3A EA F3 E6 0F 32 EA F3 3A E9 ";
            S = S + "F3 E6 0F 32 E9 F3 F1 C9 C0 E5 CD FE 07 E1 C9 21 ";
            S = S + "9F 0F E5 FE 09 D0 21 D3 09 4F 06 00 09 09 4E 23 ";
            S = S + "66 69 E9 E5 09 1A 0A 48 0A 98 0A 71 0A D6 0A E3 ";
            S = S + "0A F0 0A FD 0A AF 32 B0 FC CD 22 0B 3A AE F3 32 ";
            S = S + "B0 F3 21 00 08 22 B5 F3 2A B3 F3 22 22 F9 2A B7 ";
            S = S + "F3 FE 29 38 03 21 00 10 22 24 F9 CD 42 0B CD 53 ";
            S = S + "09 CD 64 08 CD 8A 07 C3 32 06 3E 01 32 B0 FC CD ";
            S = S + "22 0B 3A AF F3 32 B0 F3 2A BD F3 22 22 F9 2A C1 ";
            S = S + "F3 22 24 F9 2A C5 F3 22 26 F9 2A C3 F3 22 28 F9 ";
            S = S + "CD 9C 0B CD 14 07 18 C6 3E 02 CD 22 0B 2A CD F3 ";
            S = S + "CD 82 0A E5 CD D2 0B E1 CD E3 08 AF 06 03 D3 98 ";
            S = S + "3C 20 FB 10 F9 CD 95 08 CD 53 09 CD 14 07 C3 32 ";
            S = S + "06 3E 04 CD 22 0B 21 00 1E CD 82 0A E5 CD D9 0B ";
            S = S + "18 D5 22 28 F9 2A CF F3 22 26 F9 2A CB F3 22 24 ";
            S = S + "F9 2A C7 F3 22 22 F9 C9 3E 03 CD 22 0B 2A D9 F3 ";
            S = S + "22 26 F9 2A D7 F3 22 28 F9 2A D5 F3 22 24 F9 2A ";
            S = S + "D1 F3 22 22 F9 E5 CD 22 0C E1 CD E3 08 11 06 00 ";
            S = S + "0E 04 7A 06 20 D3 98 3C 10 FB 0D 20 F5 57 1D 20 ";
            S = S + "EF CD AD 08 18 92 3E 05 11 76 78 CD 14 0B CD 56 ";
            S = S + "0C 18 25 3E 06 11 76 78 CD 14 0B CD 80 0C 18 18 ";
            S = S + "3E 07 11 FA F0 CD 14 0B CD 97 0C 18 0B 3E 08 11 ";
            S = S + "FA F0 CD 14 0B CD C7 0C CD 53 09 CD 11 08 CD 14 ";
            S = S + "07 C3 32 06 2E 00 62 22 26 F9 63 22 28 F9 65 22 ";
            S = S + "22 F9 32 AF FC AF 32 F5 FA 32 F6 FA 21 00 01 22 ";
            S = S + "0B F4 22 0D F4 CD 80 29 CD 3C 06 06 00 0E 17 C3 ";
            S = S + "47 06 CD 2D 0D 3A B0 F3 FE 29 06 00 38 02 06 04 ";
            S = S + "0E 10 CD 3F 0D 3A B0 F3 FE 29 3A F5 FA 30 13 87 ";
            S = S + "2A B7 F3 06 00 CD E6 0C 87 2A B3 F3 CD DA 0C C3 ";
            S = S + "CA 06 3A F5 FA F5 87 87 06 00 2A 24 F9 CD E6 0C ";
            S = S + "87 06 03 2A B3 F3 CD DA 0C F1 2A B5 F3 1E 00 CB ";
            S = S + "3F CB 1B 57 06 07 CD F4 0C C3 CA 06 CD 2D 0D 01 ";
            S = S + "00 00 CD 3F 0D 3A F5 FA 4F 06 00 2A C1 F3 87 87 ";
            S = S + "87 CD E6 0C 2A C5 F3 CD 20 0D 2A BD F3 87 CD DA ";
            S = S + "0C 58 51 2A BF F3 CD F4 0C CB 3A CB 1B 2A C3 F3 ";
            S = S + "18 4A AF F5 01 00 02 18 07 3E 03 B7 F5 01 00 04 ";
            S = S + "CD 3F 0D CD 2D 0D 3A F5 FA 4F 06 03 2A CB F3 87 ";
            S = S + "87 87 CD E6 0C 2A CF F3 CD 20 0D 2A C7 F3 87 06 ";
            S = S + "00 CD DA 0C 58 51 06 7F 2A C9 F3 CD F4 0C CB 3A ";
            S = S + "CB 1B F1 47 2A CD F3 28 03 2A 28 F9 CD 0B 0D C3 ";
            S = S + "CA 06 CD 2D 0D 01 08 00 CD 3F 0D 3A F5 FA 4F 06 ";
            S = S + "00 2A D5 F3 87 87 87 CD E6 0C 2A D9 F3 CD 20 0D ";
            S = S + "2A D1 F3 87 06 00 CD DA 0C 58 51 CB 3A CB 1B 06 ";
            S = S + "00 2A D7 F3 18 C6 CD 36 0D 01 00 06 CD 3F 0D 3A ";
            S = S + "F5 FA 4F 06 00 87 87 87 87 CD 1D 0D 2A 22 F9 87 ";
            S = S + "06 1F CD DA 0C 51 1E 00 06 03 CD 08 0D C3 CA 06 ";
            S = S + "CD 36 0D 01 00 08 CD 3F 0D 21 00 02 22 0B F4 21 ";
            S = S + "80 00 22 0D F4 18 C8 CD 36 0D 01 00 0A CD 3F 0D ";
            S = S + "21 00 02 22 0B F4 21 80 00 22 0D F4 3A F5 FA 4F ";
            S = S + "06 00 0F 0F 0F E6 E0 CD 1D 0D 2A 22 F9 06 1F CD ";
            S = S + "DA 0C 79 87 57 18 AF CD 36 0D 01 00 0E CD 3F 0D ";
            S = S + "3A E1 F3 CB 3F 32 E1 F3 18 D2 6F CB 3C CB 3C 84 ";
            S = S + "B0 32 E1 F3 7D C9 6F CB 3C CB 3C CB 3C 84 B0 32 ";
            S = S + "E3 F3 7D C9 F5 AF 29 8F 29 8F 6C 67 19 7D B0 32 ";
            S = S + "E2 F3 7C 32 E9 FF F1 C9 2A 28 F9 F5 AF 29 8F 6C ";
            S = S + "67 19 7D B0 32 E4 F3 7C 32 EA FF F1 C9 2A 26 F9 ";
            S = S + "6F CB 3C CB 3C CB 3C 84 32 E5 F3 7D C9 3A E8 FF ";
            S = S + "E6 7F 32 E8 FF C9 3A E8 FF F6 80 32 E8 FF C9 3A ";
            S = S + "DF F3 E6 F1 B0 32 DF F3 3A E0 F3 E6 E7 B1 32 E0 ";
            S = S + "F3 C9 3E FF CD 1D 06 D0 E5 3A DC F3 21 B1 F3 BE ";
            S = S + "3E 0A 20 01 DF 3A EB FB 0F 21 7F F8 3E 01 38 04 ";
            S = S + "21 CF F8 AF 32 CD FB CD E2 0D 0E 05 3A B0 F3 FE ";
            S = S + "29 30 1F CD F0 0D 38 12 C5 0E 00 CD FE 0D 10 FB ";
            S = S + "3E 10 91 4F 09 13 C1 0D 20 EE 2A B1 F3 CD D7 0E ";
            S = S + "E1 C9 F5 CD F0 0D F1 D6 28 C5 0E 00 08 CD FE 0D ";
            S = S + "08 3D CC D2 0D 10 F5 3D 20 04 CD D2 0D 1B 08 3E ";
            S = S + "10 91 4F 09 08 13 C1 0D 20 DF 2A B1 F3 CD F2 0E ";
            S = S + "E1 C9 C5 E5 2A B1 F3 CD D8 0E CD E2 0D E1 C1 3E ";
            S = S + "FF C9 11 18 FC D5 06 28 3E 20 12 13 10 FC D1 C9 ";
            S = S + "D6 04 D8 06 FF 04 D6 05 30 FB 78 D6 01 C9 7E 23 ";
            S = S + "0C CD A5 12 30 F8 20 04 FE 20 38 01 12 13 C9 CD ";
            S = S + "00 0F 95 D8 CA A9 0E E5 F5 4F 06 00 CD 0A 0F 6B ";
            S = S + "62 23 ED B0 21 CA FB 35 F1 E1 F5 3A B0 F3 FE 29 ";
            S = S + "30 11 F1 F5 2C CD AE 0E 2D CD D7 0E 2C F1 3D 20 ";
            S = S + "F2 18 17 F1 F5 2C CD AF 0E 2D CD D8 0E 2C CD C8 ";
            S = S + "0E 2D CD F2 0E 2C F1 3D 20 EA C3 A9 0E CD 00 0F ";
            S = S + "67 95 D8 CA A9 0E 6C E5 F5 4F 06 00 CD 0A 0F 6B ";
            S = S + "62 E5 2B ED B8 E1 74 F1 E1 F5 3A B0 F3 FE 29 30 ";
            S = S + "11 F1 F5 2D CD AE 0E 2C CD D7 0E 2D F1 3D 20 F2 ";
            S = S + "18 17 F1 F5 2D CD AF 0E 2C CD D8 0E 2D CD C8 0E ";
            S = S + "2C CD F2 0E 2D F1 3D 20 EA 26 01 C3 96 05 F6 AF ";
            S = S + "E5 F5 26 01 CD 35 0F F1 3A B0 F3 20 02 D6 28 47 ";
            S = S + "11 18 FC CD 22 0F E1 C9 E5 3A B0 F3 D6 28 3C 67 ";
            S = S + "CD 35 0F 06 28 18 E9 F6 AF E5 F5 26 01 CD 35 0F ";
            S = S + "F1 3A B0 F3 20 02 D6 28 47 EB 21 18 FC CD 2B 0F ";
            S = S + "E1 C9 E5 3A B0 F3 D6 27 67 CD 35 0F 06 28 18 E9 ";
            S = S + "3A DE F3 E5 21 B1 F3 86 E1 C9 E5 11 B1 FB 26 00 ";
            S = S + "19 7E EB E1 A7 C9 E5 CD 35 0F CD E3 08 79 D3 98 ";
            S = S + "E1 C9 CD F1 08 EB 0E 98 ED B2 C9 EB CD E3 08 EB ";
            S = S + "0E 98 ED B3 C9 C5 25 2D 5C 26 00 54 29 29 29 4D ";
            S = S + "44 29 29 3A AF FC A7 3A B0 F3 28 04 D6 22 18 0D ";
            S = S + "FE 29 38 06 09 29 D6 52 18 03 09 D6 2A 19 2F A7 ";
            S = S + "1F 5F 19 EB 2A 22 F9 19 C1 C9 E5 57 CD F9 0F CD ";
            S = S + "F1 08 E3 E3 DB 98 47 00 00 DB 98 4F E1 C9 E5 16 ";
            S = S + "00 CD F9 0F CD F1 08 42 0E 10 CD 47 06 06 10 DB ";
            S = S + "98 00 D3 9A 00 DB 98 00 D3 9A 00 10 F2 E1 C9 E5 ";
            S = S + "21 B3 0F 06 10 16 00 7E 23 5E 23 CD D3 0F 14 10 ";
            S = S + "F6 E1 C9 00 00 00 00 11 06 33 07 17 01 27 03 51 ";
            S = S + "01 27 06 71 01 73 03 61 06 64 06 11 04 65 02 55 ";
            S = S + "05 77 07 C5 E5 42 0E 10 F5 CD 47 06 F1 0E 9A ED ";
            S = S + "79 F5 F1 ED 59 CD F9 0F F5 CD E3 08 E3 E3 F1 D3 ";
            S = S + "98 F5 F1 7B D3 98 E1 C1 C9 F5 3A AF FC 21 20 10 ";
            S = S + "C5 3C 4F 06 00 3D 20 08 3A B0 F3 FE 29 30 01 0D ";
            S = S + "09 09 C1 7E 23 66 6F D5 5A 16 00 19 19 D1 F1 C9 ";
            S = S + "00 04 00 0F 20 20 80 1B 20 20 80 1B 80 76 80 76 ";
            S = S + "80 FA 80 FA 3E 02 CD 8B 29 E6 40 20 F7 3E 02 CD ";
            S = S + "8B 29 E6 40 28 F7 C9 F1 C9 F5 78 FE 21 38 F8 FE ";
            S = S + "28 38 08 FE 30 38 F0 FE 50 30 EC 79 FE 21 38 E7 ";
            S = S + "FE 7F 30 E3 F1 E5 D5 C5 F5 79 D6 20 5F 16 00 78 ";
            S = S + "D6 20 6F 62 4D 44 29 09 29 29 29 29 29 19 FE 10 ";
            S = S + "38 02 25 25 7D D3 D8 29 29 7C D3 D9 01 D9 20 21 ";
            S = S + "18 FC ED B2 F1 F5 A7 0E 02 28 2A 21 18 FC 5D 54 ";
            S = S + "3D 28 01 23 0E 02 06 08 7E 12 23 23 13 78 FE 05 ";
            S = S + "20 06 C5 01 08 00 09 C1 10 EE C5 01 F0 FF 09 C1 ";
            S = S + "0D 20 E3 0E 01 2A B7 FC E5 2A B9 FC E5 11 18 FC ";
            S = S + "2A B9 FC E5 2A B7 FC E5 06 02 C5 EB 11 40 FC 01 ";
            S = S + "08 00 ED B0 E5 CD 2D 11 D1 C1 10 EE E1 22 B7 FC ";
            S = S + "E1 C5 01 08 00 09 C1 22 B9 FC 0D 20 D3 E1 22 B9 ";
            S = S + "FC E1 01 10 00 09 22 B7 FC F1 C1 D1 E1 C9 E5 D5 ";
            S = S + "C5 F5 21 09 11 E5 CD A5 12 D0 20 08 FE 0D CA 10 ";
            S = S + "12 FE 20 D8 CD D9 07 3A E9 F3 32 F2 F3 2A B9 FC ";
            S = S + "EB ED 4B B7 FC CD C4 12 D0 CD 42 13 11 40 FC CD ";
            S = S + "80 29 D5 AF CD DB 29 CD 76 13 5F CD A5 29 7B D6 ";
            S = S + "CD 2E 08 38 05 6F 3E 07 95 6F 45 11 08 00 62 CD ";
            S = S + "C4 29 D1 3A F2 F3 6F 3A EA F3 67 1A 87 4F 7C 30 ";
            S = S + "01 7D CD EB 29 3A 02 FB E6 0F F6 B0 CD E3 29 F3 ";
            S = S + "3E AC D3 99 3E 91 D3 99 79 0E 9B F3 18 15 F3 3E ";
            S = S + "AC D3 99 3E 91 D3 99 13 1A 07 30 05 ED 69 C3 A3 ";
            S = S + "11 ED 61 07 30 05 ED 69 C3 AD 11 ED 61 07 30 05 ";
            S = S + "ED 69 C3 B7 11 ED 61 07 30 05 ED 69 C3 C1 11 ED ";
            S = S + "61 07 30 05 ED 69 C3 CB 11 ED 61 07 30 05 ED 69 ";
            S = S + "C3 D5 11 ED 61 07 30 05 ED 69 C3 DF 11 ED 61 07 ";
            S = S + "30 05 ED 69 C3 E9 11 ED 61 FB 10 A2 3A AF FC E6 ";
            S = S + "FE FE 06 28 0B 3A B7 FC C6 08 38 14 32 B7 FC C9 ";
            S = S + "2A B7 FC 01 08 00 09 7C E6 FE 20 04 22 B7 FC C9 ";
            S = S + "21 00 00 22 B7 FC 3A B9 FC C6 08 FE D4 38 01 AF ";
            S = S + "32 B9 FC C9 E5 D5 C5 F5 21 09 11 E5 CD A5 12 D0 ";
            S = S + "20 08 FE 07 CA 62 1A FE 20 D8 CD D9 07 11 40 FC ";
            S = S + "D5 CD 80 29 AF CD DB 29 CD 76 13 CD A5 29 21 08 ";
            S = S + "00 11 10 00 CD C4 29 D1 21 03 01 1A 87 4F 7C 30 ";
            S = S + "01 7D F5 CD EB 29 3E B0 CD E3 29 F3 3E AC D3 99 ";
            S = S + "3E 91 D3 99 F1 D3 9B 79 0E 9B 06 08 C5 05 18 05 ";
            S = S + "13 1A C5 06 08 07 30 08 ED 69 F5 F1 ED 69 18 06 ";
            S = S + "ED 61 F5 F1 ED 61 10 ED C1 10 E5 2A 2A F9 01 10 ";
            S = S + "00 09 C3 72 13 E5 F5 21 A6 FC AF BE 77 28 0D F1 ";
            S = S + "D6 40 FE 20 38 04 C6 40 BF 37 E1 C9 F1 FE 01 20 ";
            S = S + "F7 77 E1 C9 CD 2C 06 D2 05 13 E5 C5 06 01 EB 7C ";
            S = S + "87 30 05 21 00 00 18 08 11 C0 00 E7 38 04 EB 2B ";
            S = S + "06 00 E3 7C 87 30 05 21 00 00 18 08 11 00 01 E7 ";
            S = S + "38 04 EB 2B 06 00 D1 CB 3D CB 3D CB 3B CB 3B 78 ";
            S = S + "0F 4D 44 E1 C9 E5 C5 06 01 EB 7C 87 30 05 21 00 ";
            S = S + "00 18 08 11 D4 00 E7 38 04 EB 2B 06 00 E3 7C 87 ";
            S = S + "30 05 21 00 00 18 12 3A AF FC E6 02 11 00 02 20 ";
            S = S + "03 11 00 01 E7 38 04 EB 2B 06 00 78 0F 44 4D D1 ";
            S = S + "E1 C9 CD 2C 06 38 08 60 69 7B 32 2C F9 18 23 C5 ";
            S = S + "79 0F 3E F0 30 02 3E 0F 32 2C F9 79 87 87 E6 F8 ";
            S = S + "4F 7B E6 07 B1 4F 7B 0F 0F 0F E6 07 47 2A D5 F3 ";
            S = S + "09 C1 22 2A F9 C9 3A 2C F9 2A 2A F9 C9 32 2C F9 ";
            S = S + "22 2A F9 C9 CD 2C 06 D2 A1 13 C5 E5 CD 76 13 47 ";
            S = S + "CD D3 08 04 05 F2 9C 13 0F 0F 0F 0F E6 0F E1 C1 ";
            S = S + "C9 E5 2A 2A F9 3A 2C F9 CD 49 29 E1 C9 CD 47 1E ";
            S = S + "D8 32 F2 F3 C9 C5 D5 E5 CD 2C 06 3A 2C F9 2A 2A ";
            S = S + "F9 38 07 CD 61 29 E1 D1 C1 C9 47 CD D6 08 4F 78 ";
            S = S + "2F A1 4F 3A F2 F3 04 05 F2 DF 13 87 87 87 87 B1 ";
            S = S + "CD CB 08 E1 D1 C1 C9 E5 CD 2C 06 CD 76 13 DA 66 ";
            S = S + "14 2B 7C B7 FA 71 14 22 2A F9 E1 C9 E5 CD 2C 06 ";
            S = S + "CD 76 13 DA 74 14 3A 2C F9 FE D3 30 64 3C 32 2C ";
            S = S + "F9 E1 A7 C9 CD 2C 06 DA AE 14 3A 2C F9 B7 37 C8 ";
            S = S + "3D 32 2C F9 B7 C9 E5 CD 76 13 A7 3E 0F FA 60 14 ";
            S = S + "7D E6 F8 FE F8 20 0C 18 38 E5 CD 76 13 A7 3E 0F ";
            S = S + "FA 60 14 D5 11 08 00 3E F0 18 10 E5 CD 76 13 A7 ";
            S = S + "3E F0 F2 60 14 D5 11 F8 FF 3E 0F 19 22 2A F9 D1 ";
            S = S + "32 2C F9 A7 E1 C9 A7 3E F0 F2 60 14 7D E6 F8 20 ";
            S = S + "E4 37 E1 C9 D5 E5 2A D5 F3 11 00 05 19 EB E1 E7 ";
            S = S + "38 0C 7D 3C E6 07 20 06 37 D1 E1 C9 E5 D5 CD 76 ";
            S = S + "13 23 7D 11 F8 00 18 0A E5 D5 CD 76 13 7D 2B 11 ";
            S = S + "08 FF E6 07 20 01 19 22 2A F9 A7 D1 E1 C9 E5 D5 ";
            S = S + "2A D5 F3 11 00 01 19 EB 2A 2A F9 E7 30 DC 7D E6 ";
            S = S + "07 20 D7 37 D1 E1 C9 A7 F5 3A AF FC FE 08 28 08 ";
            S = S + "F1 FE 10 3F 32 B2 FC C9 F1 18 F9 21 00 00 4D CD ";
            S = S + "2C 06 DA 66 15 E5 C5 D5 2A 2A F9 3A 2C F9 5F 16 ";
            S = S + "00 3A B2 FC CD E0 28 38 06 D1 C1 E1 54 5C C9 D1 ";
            S = S + "E5 2A 2A F9 19 D1 B7 ED 52 38 EF 28 ED C1 C1 E5 ";
            S = S + "EB 22 42 F9 3A 2C F9 32 44 F9 5F 16 00 3A B2 FC ";
            S = S + "CD E4 28 F5 38 0D 3A AF FC E6 02 21 FF 01 20 03 ";
            S = S + "21 FF 00 22 2A F9 F1 38 01 23 E5 EB 2A 42 F9 EB ";
            S = S + "B7 ED 52 E3 E5 EB 3A 44 F9 5F 16 00 3A F2 F3 CD ";
            S = S + "E0 28 D1 30 0C E7 30 09 D1 2A 42 F9 CD DB 15 D1 ";
            S = S + "C9 0E 00 E1 D1 C9 CD 33 16 30 0D 1B 7A B3 C8 CD ";
            S = S + "26 14 30 F2 11 00 00 C9 CD 76 13 22 42 F9 32 44 ";
            S = S + "F9 21 00 00 23 CD 26 14 D8 CD 33 16 30 F6 C9 21 ";
            S = S + "00 00 4D CD 2C 06 DA 26 16 CD E7 13 D8 2A 2A F9 ";
            S = S + "E5 3A 2C F9 5F 16 00 3A B2 FC CD D8 28 F5 38 03 ";
            S = S + "21 FF FF 23 22 2A F9 EB E1 E3 E5 B7 ED 52 23 E3 ";
            S = S + "D5 3A 2C F9 5F 16 00 3A F2 F3 CD DC 28 30 4C D1 ";
            S = S + "C1 F1 C5 D5 30 03 E7 38 48 E1 D1 3E 24 F3 D3 99 ";
            S = S + "3E 91 D3 99 7D D3 9B 7C D3 9B 3A 2C F9 D3 9B 3A ";
            S = S + "F6 FA D3 9B 7B D3 9B 7A D3 9B 3E 01 D3 9B AF D3 ";
            S = S + "9B 3A F2 F3 D3 9B AF D3 9B 3A AF FC FE 08 3E 80 ";
            S = S + "20 02 3E C0 D3 9B FB EB 0E FF C9 D1 E1 D1 0E 00 ";
            S = S + "C9 D1 E1 0E 00 C9 CD E7 13 D8 CD 33 16 DA 39 14 ";
            S = S + "23 18 F3 CD 84 13 47 3A B2 FC 90 37 C8 3A F2 F3 ";
            S = S + "B8 C8 CD B5 13 0E 01 A7 C9 FB 11 60 16 E5 21 89 ";
            S = S + "FD CD AD 16 E1 D8 37 C0 CD 5E 16 FB A7 C9 D5 C9 ";
            S = S + "4D 45 4D 49 4E 49 00 66 37 4D 4B 49 4C 4C 00 78 ";
            S = S + "39 4D 4E 41 4D 45 00 DD 39 4D 46 49 4C 45 53 00 ";
            S = S + "67 38 FF F5 E5 11 99 16 CD AD 16 38 08 F1 F1 2B ";
            S = S + "CD 5E 16 A7 C9 E1 F1 37 C9 CB 00 DB 16 44 41 54 ";
            S = S + "45 00 E1 16 4B 41 4E 4A 49 00 95 21 FF E5 1A 3C ";
            S = S + "28 14 CD C9 16 28 06 13 13 13 E1 18 F0 7E E3 EB ";
            S = S + "23 5E 23 56 A7 38 37 E1 C9 1A B7 C8 BE 20 04 13 ";
            S = S + "23 18 F6 1A A7 13 20 FB 1B 3D C9 05 01 4B 17 18 ";
            S = S + "04 05 01 67 17 F2 46 05 D7 C5 CD D8 05 CD D2 05 ";
            S = S + "2B D7 28 0A CF 2C CF 41 E3 01 0E 00 09 E3 C1 E5 ";
            S = S + "D5 C5 3E 08 CD EA 05 2A 99 F6 D1 E5 1A 07 E6 01 ";
            S = S + "47 0E 04 CD 4B 19 0E 02 06 02 1A 3C 28 05 3D D3 ";
            S = S + "B4 DB B5 13 EB 86 EB 1B 27 E6 0F F6 30 77 13 13 ";
            S = S + "23 10 E7 0C 0D 28 07 1A 77 13 23 0D 18 DA CD D5 ";
            S = S + "36 D1 E1 36 08 23 73 23 72 E1 C9 05 00 04 00 3A ";
            S = S + "03 00 02 00 3A 01 00 00 00 85 00 84 00 3A 83 00 ";
            S = S + "82 00 3A 81 00 80 00 0C 08 0B 00 2F 0A 00 09 00 ";
            S = S + "2F 08 00 07 00 FF 00 FF 00 2F FF 00 FF 00 2F 88 ";
            S = S + "00 87 00 D7 E5 CD F7 1C 06 03 3A B0 FC 4F 3A E8 ";
            S = S + "FF 0F 0F E6 02 B1 CD 59 1A 3A B0 F3 CD 50 1A 3A ";
            S = S + "E9 F3 CD 59 1A 3A EA F3 CD 59 1A 3A EB F3 CD 59 ";
            S = S + "1A 0E 00 3A DE F3 B7 28 02 CB C1 3A DB F3 B7 28 ";
            S = S + "02 CB C9 3A 17 F4 B7 28 02 CB D1 3A FC F3 21 06 ";
            S = S + "F4 BE 28 02 CB D9 79 C3 8C 1A CF 28 CD 0D 18 7B ";
            S = S + "F5 CF 2C CD 0D 18 CF 29 F1 E6 0F 57 CD F8 17 CD ";
            S = S + "F7 1C 06 01 7A C3 50 1A 7B 07 07 07 07 E6 F0 B2 ";
            S = S + "57 32 F1 FF F3 D3 99 3E 92 FB D3 99 C9 CD 08 06 ";
            S = S + "E5 EB CD DC 25 EB 21 07 00 E7 30 07 21 F7 FF E7 ";
            S = S + "D2 46 05 E1 C9 CD FC 05 E5 CD 14 06 7E 23 5E 23 ";
            S = S + "56 E1 C9 FE C5 CA 83 17 FE CB CA 8A 18 FE C0 CA ";
            S = S + "A6 19 11 4F 18 CD AD 16 DA 40 05 2B D7 D5 C9 50 ";
            S = S + "41 47 45 00 B1 1F 56 49 44 45 4F 00 AF 35 41 44 ";
            S = S + "4A 55 53 54 00 DA 17 54 49 54 4C 45 00 80 19 50 ";
            S = S + "41 53 53 57 F7 44 00 DD 19 50 52 4F 4D 50 54 00 ";
            S = S + "E1 19 44 41 54 45 00 8E 18 FF D7 3E 3A 01 3E 2F ";
            S = S + "F5 CD 25 18 DD E1 FE 08 C2 40 05 E5 EB CD 5E 19 ";
            S = S + "1E 24 20 03 57 1E 13 BB 30 1A 47 CD 56 19 1E 32 ";
            S = S + "28 02 1E 60 BB 30 0D 4F CD 56 19 20 05 47 79 4A ";
            S = S + "18 05 FE 60 D2 46 05 57 E1 DD E5 2B D7 3E 00 28 ";
            S = S + "06 CF 2C CF 41 F6 01 DD E1 E5 F5 C5 D5 20 0B 01 ";
            S = S + "04 00 CD 4B 19 01 00 0E 18 0E 01 08 01 CD 4B 19 ";
            S = S + "CD 6C 19 28 08 01 00 0D 3E 0F CD 4D 19 D1 06 00 ";
            S = S + "CD 6C 19 20 02 06 07 7A CD 50 1A D1 F1 F5 28 05 ";
            S = S + "CD 6C 19 28 2C 7B CD 50 1A 7A CD 6C 19 20 1F F5 ";
            S = S + "C5 CB 67 28 02 C6 02 E6 03 F5 3E 01 CD F9 1C F1 ";
            S = S + "06 0B CD 59 1A AF CD F9 1C C1 F1 D6 80 27 CD 50 ";
            S = S + "1A F1 E1 06 04 20 02 06 08 0E 0F 3E 0D D3 B4 DB ";
            S = S + "B5 A1 B0 D3 B5 C9 DD E5 F1 BE 23 C2 40 05 CD 74 ";
            S = S + "19 07 07 07 07 E6 F0 5F CD 74 19 B3 C5 DD E5 C1 ";
            S = S + "CB 60 C1 C9 7E 23 D6 30 38 03 FE 0A D8 C3 46 05 ";
            S = S + "FE 2C 28 07 AF CD EC 19 2B D7 C8 CF 2C EF C0 3D ";
            S = S + "FE 04 30 E9 F5 CD F7 1C 06 0B CD D2 1C E6 0C 4F ";
            S = S + "F1 B1 05 C3 59 1A CD F7 1C 06 0A CD D2 1C F5 D7 ";
            S = S + "FE 2C 28 14 EF 3D FE 04 30 14 07 07 E6 0C 47 F1 ";
            S = S + "E6 03 B0 F5 2B D7 28 0F CF 2C EF 3D FE 04 D2 46 ";
            S = S + "05 47 F1 E6 0C B0 F5 06 0A F1 C3 59 1A 3E 01 18 ";
            S = S + "02 3E 02 CD EC 19 2B D7 C2 40 05 C9 F5 CD 25 18 ";
            S = S + "4F CD F3 1C 06 0C AF CD 59 1A 05 10 FA F1 CD 59 ";
            S = S + "1A E5 EB 3D 28 11 1E 06 0D 0C 28 09 7E 23 CD 50 ";
            S = S + "1A 0D 1D 20 F3 E1 C9 3E 21 CD 50 1A 3E 03 CD 59 ";
            S = S + "1A 79 F5 CD A5 1C 06 04 7B CD 50 1A 7A CD 50 1A ";
            S = S + "F1 4F AF D3 7F DB 7F FE AA 20 DA 79 B7 3E 01 28 ";
            S = S + "01 3C CD 59 1A C5 CD 97 1C C1 7B CD 50 1A 7A E1 ";
            S = S + "F5 CD 59 1A F1 0F 0F 0F 0F F5 78 D3 B4 04 F1 D3 ";
            S = S + "B5 C9 E5 CD D0 1A F5 05 28 26 05 28 40 05 28 4C ";
            S = S + "1E 55 CD 11 1B CD 1A 1B CD 32 1B 3E 08 CD 1E 1B ";
            S = S + "01 D0 07 CD 28 1B CD 6B 05 F1 06 0D E1 C3 59 1A ";
            S = S + "21 3E 1B 1E B8 CD 1C 1B 1E A7 3E 02 CD 12 1B 1E ";
            S = S + "A8 3E 04 CD 12 1B 1E A6 CD EA 1A 18 D9 21 3E 1B ";
            S = S + "CD 1A 1B 1E 2A CD EA 1A 1E 35 18 EC 21 46 1B CD ";
            S = S + "1A 1B 1E 6B CD EA 1A 1E 47 CD EA 1A 1E 55 18 D8 ";
            S = S + "06 0D CD D2 1C F5 CD F7 1C 06 0A CD D2 1C 4F 0F ";
            S = S + "0F E6 03 47 79 E6 03 4F F1 C9 CD 11 1B C5 E5 CD ";
            S = S + "32 1B E1 E5 09 09 4E 23 46 3E 08 CD 1E 1B 3E 09 ";
            S = S + "CD 1E 1B 3E 0A CD 1E 1B CD 28 1B 1D 20 EB E1 C1 ";
            S = S + "C9 AF CD 1E 1B 1E 00 3C 18 04 1E BE 3E 07 F3 D3 ";
            S = S + "A0 F5 7B FB D3 A1 F1 C9 C5 0B E3 E3 78 B1 20 F9 ";
            S = S + "C1 C9 06 00 21 3A 1B 09 5E C9 04 07 0A 0F D8 10 ";
            S = S + "A0 09 BD 06 7E 04 9D 05 35 03 3F 02 7F 01 CD AE ";
            S = S + "05 CD F3 1C CD D0 1C FE 02 21 D7 3F C2 F6 05 CD ";
            S = S + "DB 1C 28 06 DF 78 FE 0D 38 F5 C3 A8 05 CD 73 1C ";
            S = S + "4F 2F CD 74 1C CD 73 1C 2F B9 79 CD 74 1C 21 64 ";
            S = S + "1C 0E 04 28 05 21 68 1C 0E 02 E5 3A FC FA E6 F9 ";
            S = S + "B1 32 FC FA 21 68 00 3E B4 CD 2B 1D 21 76 3E CD ";
            S = S + "4B 1C E1 CD 4B 1C 21 6C 1C CD 3D 3E AF D3 99 D3 ";
            S = S + "99 D3 99 3E 8E D3 99 CD F3 1C CD D0 1C 28 76 3D ";
            S = S + "C0 CD D2 1C FE 01 C0 CD D2 1C FE 02 C0 CD D2 1C ";
            S = S + "FE 03 C0 06 08 CD D2 1C 28 15 AF D3 7F DB 7F FE ";
            S = S + "AA 20 0C C5 CD 97 1C C1 CD EA 1C E7 C8 18 11 3E ";
            S = S + "06 CD 90 05 E6 04 20 08 3E 07 CD 90 05 E6 10 C8 ";
            S = S + "21 32 00 3E D0 CD 2B 1D 21 54 1C CD 4B 1C 06 08 ";
            S = S + "CD D2 1C 3D 28 FE 21 5E F5 06 FF CD 65 05 FE 0D ";
            S = S + "28 04 77 23 10 F5 3E FF 90 CD A2 1C 06 04 CD EA ";
            S = S + "1C E7 C8 18 E1 21 C8 00 7D CD 2B 1D CD DB 1C C8 ";
            S = S + "CD 24 12 78 FE 0D 38 F4 C3 65 05 7E 23 B7 C8 CD ";
            S = S + "24 12 18 F7 50 61 73 73 77 6F 72 64 3A 00 56 52 ";
            S = S + "41 4D 3A 00 31 32 38 00 20 36 34 00 4B 62 79 74 ";
            S = S + "65 73 00 F6 37 F5 3E 07 D3 99 3E 8E D3 99 3E FF ";
            S = S + "D3 99 F1 F5 3E 7F 38 02 3E 3F D3 99 E3 E3 F1 38 ";
            S = S + "03 DB 98 C9 D3 98 C9 DB 7F 6F DB 7F 67 22 5E F5 ";
            S = S + "3E 02 21 5E F5 11 00 00 4F B7 C8 37 F5 06 08 F1 ";
            S = S + "F5 30 02 CB 06 CB 13 CB 12 30 08 7A EE 80 57 7B ";
            S = S + "EE 05 5F 10 EA 23 0D 20 E4 F1 D0 B7 0E 02 18 DC ";
            S = S + "06 00 78 D3 B4 04 DB B5 E6 0F C9 D5 CD D2 1C 57 ";
            S = S + "CD D2 1C 07 07 07 07 B2 D1 C9 CD DB 1C 6F CD DB ";
            S = S + "1C 67 C9 3E 03 18 02 3E 02 C5 F5 06 0D CD D2 1C ";
            S = S + "E6 0C C1 B0 D3 B5 C1 C9 CD 1A 1D DB B5 E6 0F C9 ";
            S = S + "F5 CD 1A 1D F1 E6 0F D3 B5 C9 79 F5 E6 30 0F 0F ";
            S = S + "0F 0F CD F9 1C F1 E6 0F D3 B4 C9 22 2A F9 32 2C ";
            S = S + "F9 C9 7E E3 BE C2 40 05 23 E3 CD 48 FF 23 7E FE ";
            S = S + "3A D0 FE 20 28 F4 30 69 B7 C8 FE 0B 38 5E FE 1E ";
            S = S + "20 05 3A 68 F6 B7 C9 FE 10 28 34 F5 23 32 68 F6 ";
            S = S + "D6 1C 30 30 D6 F5 30 06 FE FE 20 16 7E 23 22 66 ";
            S = S + "F6 26 00 6F 22 6A F6 3E 02 32 69 F6 21 E6 46 F1 ";
            S = S + "B7 C9 7E 23 23 22 66 F6 2B 66 18 E7 CD B7 1D 2A ";
            S = S + "66 F6 18 AA 3C 07 32 69 F6 D5 C5 11 6A F6 CD F0 ";
            S = S + "1D C1 D1 22 66 F6 F1 21 E6 46 B7 C9 FE 09 D2 3A ";
            S = S + "1D FE 30 3F 3C 3D C9 3A 68 F6 FE 0F 30 13 FE 0D ";
            S = S + "38 0F 2A 6A F6 20 07 23 23 23 5E 23 56 EB C3 DE ";
            S = S + "05 3A 69 F6 32 63 F6 FE 02 20 06 2A 6A F6 22 F8 ";
            S = S + "F7 21 6A F6 11 F6 F7 3A 63 F6 FE 04 30 02 13 13 ";
            S = S + "4F 06 00 ED B0 C9 CA D5 1E FE EF CA CA 1E FE C7 ";
            S = S + "CA 40 20 ED 5B E9 F3 D5 FE 2C 28 0B EF CD 40 1E ";
            S = S + "D1 5F D5 2B D7 28 1C CF 2C FE 2C 28 0B EF CD 40 ";
            S = S + "1E D1 57 D5 2B D7 28 0B CF 2C EF CD 40 1E 32 EB ";
            S = S + "F3 2B D7 E3 22 E9 F3 7D 32 F2 F3 CD 53 09 E1 C9 ";
            S = S + "CD 47 1E D0 C3 46 05 F5 3A AF FC FE 06 28 0C FE ";
            S = S + "08 28 05 F1 FE 10 3F C9 F1 A7 C9 F1 FE 20 3F D8 ";
            S = S + "FE 10 38 03 E6 0F C9 E6 03 C5 47 87 87 80 C1 C9 ";
            S = S + "D7 3E 0F CD DC 1E F5 CD 6A 0F C5 CF 2C FE 2C 28 ";
            S = S + "17 3E 07 CD DC 1E 87 87 87 87 5F C1 78 E6 0F B3 ";
            S = S + "47 C5 2B D7 FE 29 28 22 CF 2C FE 2C 28 0E 3E 07 ";
            S = S + "CD DC 1E C1 4F C5 2B D7 FE 29 28 0E CF 2C 3E 07 ";
            S = S + "CD DC 1E C1 78 E6 F0 B3 47 C5 CF 29 C1 78 59 C1 ";
            S = S + "50 F5 CD 34 10 F1 CD D3 0F C9 D7 FE 28 28 A1 FE ";
            S = S + "8C 28 05 CF 94 C3 9F 0F D7 C3 7E 0F F5 EF F1 BB ";
            S = S + "7B D0 C3 46 05 FE 2C 28 34 EF FE 09 D2 46 05 FE ";
            S = S + "05 38 1B F5 3A FC FA 0F E6 03 4F F1 FE 07 F5 79 ";
            S = S + "30 06 FE 01 38 04 18 05 FE 02 DA 46 05 F1 E5 CD ";
            S = S + "BF 09 3A B0 F3 5F CD 33 20 E1 2B D7 C8 CF 2C FE ";
            S = S + "2C 28 17 EF FE 04 D2 46 05 3A E0 F3 E6 FC B3 32 ";
            S = S + "E0 F3 E5 CD F5 06 E1 2B D7 C8 CF 2C FE 2C 28 05 ";
            S = S + "EF 32 DB F3 C8 CF 2C FE 2C 28 06 CD 7A 1F 2B D7 ";
            S = S + "C8 CF 2C FE 2C 28 05 EF 32 17 F4 C8 CF 2C EF FE ";
            S = S + "04 D2 46 05 87 CB 4F 28 02 CB DF E6 0C 47 3A E8 ";
            S = S + "FF E6 F3 B0 0E 09 47 C3 47 06 EF 3D FE 02 D2 46 ";
            S = S + "05 E5 01 05 00 A7 21 FC F3 28 01 09 11 06 F4 ED ";
            S = S + "B0 E1 C9 C5 47 CD 2C 06 38 14 FE 07 3E 01 30 0D ";
            S = S + "3A FC FA E6 06 FE 04 3E 01 38 02 3E 03 B8 78 C1 ";
            S = S + "C9 ED 5B F5 FA FE 2C 28 0E D5 EF D1 CD 93 1F DA ";
            S = S + "46 05 5F 2B D7 28 0B D5 CF 2C EF D1 CD 93 1F 38 ";
            S = S + "EE 57 ED 53 F5 FA E5 CD 80 29 CD A8 06 E1 C9 CA ";
            S = S + "46 05 3A B0 FC A7 7B 28 05 FE 21 D2 46 05 FE 29 ";
            S = S + "38 05 FE 51 D2 46 05 3A B0 F3 BB C8 3E 0C DF 7B ";
            S = S + "32 B0 F3 CD 33 20 3A B0 FC 3D 7B 20 07 32 AF F3 ";
            S = S + "3E 0C DF C9 0E 29 3A AE F3 B9 7B 32 AE F3 F5 3E ";
            S = S + "0C DF F1 38 03 B9 D0 4F B9 D8 F5 E5 AF CD BF 09 ";
            S = S + "E1 F1 5F D6 0E 30 FC C6 1C 2F 3C 83 32 B2 F3 C9 ";
            S = S + "CD 26 06 DA 46 05 D7 FE 24 28 1A 3E 1F CD 18 23 ";
            S = S + "E5 CD 75 07 E3 CF EF EF A7 FA 46 05 01 10 00 E3 ";
            S = S + "CD 77 09 E1 C9 CF 24 3E 1F CD 18 23 E5 CD 75 07 ";
            S = S + "E3 CF EF CD FC 05 E5 CD 14 06 7E FE 11 38 02 3E ";
            S = S + "10 23 5E 23 56 E1 E3 A7 47 EB C4 2B 0F E1 C9 D7 ";
            S = S + "EF FE 20 D2 46 05 32 60 F5 E5 F5 CD 75 07 22 18 ";
            S = S + "FC 11 1A FC 06 10 CD 22 0F F1 F5 CD 6A 07 22 5E ";
            S = S + "F5 F1 47 3E 20 90 47 32 61 F5 11 62 F5 D5 CD 22 ";
            S = S + "0F E1 E3 CF 2C FE 2C 28 2C CD 9C 05 E3 73 23 78 ";
            S = S + "87 79 0E 00 30 04 C6 20 0E 80 77 E5 21 1A FC 06 ";
            S = S + "10 7E E6 7F B1 77 23 10 F8 CD 7A 21 E1 23 E3 2B ";
            S = S + "D7 C1 28 3A C5 CF 2C FE 2C 28 1E EF A7 FA 46 05 ";
            S = S + "E5 21 1A FC 4F 06 10 7E E6 80 B1 77 23 10 F8 CD ";
            S = S + "7A 21 E1 2B D7 C1 28 16 C5 CF 2C EF CD 7F 07 7B ";
            S = S + "30 07 FE 40 D2 46 05 87 87 E3 77 44 4D E1 E5 3A ";
            S = S + "60 F5 D6 1F 28 34 2A 18 FC 3A 61 F5 47 11 10 00 ";
            S = S + "19 E5 C5 11 1A FC 06 10 CD 22 0F CD 87 21 C1 E1 ";
            S = S + "28 02 10 E9 3A 61 F5 90 28 10 47 21 66 F5 ED 5B ";
            S = S + "62 F5 73 23 72 23 23 23 10 F8 3C 87 87 47 21 62 ";
            S = S + "F5 ED 5B 5E F5 CD 2B 0F E1 C9 21 1A FC ED 5B 18 ";
            S = S + "FC 06 10 CD 2B 0F C9 21 1A FC 06 10 7E E6 40 C0 ";
            S = S + "23 10 F9 AF C9 05 FA 40 05 3A AF FC FE 05 DA 46 ";
            S = S + "05 D7 FE 2C C4 9C 05 CF 2C CD 08 06 D5 CD 6F 25 ";
            S = S + "CD 94 25 2B D7 FE 2C 3E 00 20 07 D7 EF FE 03 D2 ";
            S = S + "46 05 C1 C3 49 10 3E 2F CD 18 23 FE 08 38 0E CA ";
            S = S + "46 05 1D 3D FE 18 38 05 FE 20 DA 46 05 D5 CF EF ";
            S = S + "EF C1 C3 76 1F D7 CF 28 CD 08 06 CF 29 E5 7A 07 ";
            S = S + "38 1C A7 20 03 7B FE 19 D2 46 05 FE 09 30 05 21 ";
            S = S + "DF F3 18 03 21 DE FF 19 7E CD E4 05 E1 C9 EB CD ";
            S = S + "DC 25 EB 21 09 00 E7 DA 46 05 7B CD 8B 29 18 E9 ";
            S = S + "3E 13 CD 18 23 16 00 D5 CF EF CD 08 06 FE 40 D2 ";
            S = S + "46 05 E3 E5 4B 42 E1 7D F5 29 EB 21 6F 22 19 79 ";
            S = S + "A6 20 03 23 78 A6 C2 46 05 21 B3 F3 19 71 23 70 ";
            S = S + "F1 1E FF 1C D6 05 30 FB 3A AF FC BB CC 61 22 E1 ";
            S = S + "C9 3D FA 42 0B CA 9C 0B 3D CA D2 0B C3 22 0C FF ";
            S = S + "03 3F 00 FF 07 7F 00 FF 07 FF 03 3F 00 FF 07 7F ";
            S = S + "00 FF 07 FF 03 FF 1F FF 1F 7F 00 FF 07 FF 03 3F ";
            S = S + "00 FF 07 7F 00 FF 07 D7 3E 2C CD 18 23 FE 14 30 ";
            S = S + "21 E5 FE 02 20 0C 3A B0 F3 FE 29 38 05 21 00 10 ";
            S = S + "18 0B 21 B3 F3 16 00 19 19 7E 23 66 6F CD DE 05 ";
            S = S + "E1 C9 E5 D6 19 30 0C C6 0F 5F FE 0D 20 D4 2A DE ";
            S = S + "22 18 EA 16 00 5F 21 E0 22 19 66 6A 18 DF 00 1E ";
            S = S + "00 00 00 76 78 00 00 00 76 78 00 00 00 FA F0 00 ";
            S = S + "00 00 FA F0 CD 02 06 D5 CF 2C EF E3 CD CB 08 21 ";
            S = S + "00 00 CD D6 08 E1 C9 CD B4 05 CD D6 08 F5 21 00 ";
            S = S + "00 CD D6 08 F1 C3 E4 05 F5 CF 28 EF F1 BB DA 46 ";
            S = S + "05 CF 29 7B C9 3A 63 F6 FE 08 30 05 D6 03 B7 37 ";
            S = S + "C9 D6 03 B7 C9 CD 25 23 2A F8 F7 F8 CA 52 05 C3 ";
            S = S + "F0 05 FE C5 CA 76 36 22 5E F5 FE 28 28 75 CD F6 ";
            S = S + "24 ED 53 62 F5 ED 43 64 F5 30 31 2B D7 CA 4D 25 ";
            S = S + "FE D9 20 0B D7 FE 28 20 0F AF 32 6F F5 18 03 CD ";
            S = S + "2B 25 E5 21 A8 30 18 2C CD F6 24 DA 4D 25 ED 53 ";
            S = S + "66 F5 ED 43 68 F5 E5 21 6F 30 18 31 2B D7 FE D9 ";
            S = S + "20 0B D7 FE 28 20 14 AF 32 6F F5 18 03 CD 2B 25 ";
            S = S + "E5 21 42 2F 22 60 F5 E1 C3 A9 24 CD F6 24 D2 40 ";
            S = S + "05 ED 53 66 F5 ED 43 68 F5 E5 21 7C 30 22 60 F5 ";
            S = S + "C3 E4 24 E5 21 B9 2E 22 60 F5 E1 CD 9C 05 C5 D5 ";
            S = S + "CF F2 CD A2 05 2B D7 FE D9 3A F6 FA 28 03 CF 2C ";
            S = S + "EF CD 93 1F DA 46 05 32 65 F5 D1 C1 CF D9 E5 CD ";
            S = S + "C4 12 ED 43 62 F5 7B 32 64 F5 CD F1 25 CD C4 12 ";
            S = S + "CD F1 25 08 AF 08 CD D5 25 30 04 08 F6 04 08 23 ";
            S = S + "22 6A F5 CD E6 25 30 04 08 F6 08 08 23 22 6C F5 ";
            S = S + "08 32 6F F5 08 C5 D5 ED 4B 6A F5 5D 54 CD 76 33 ";
            S = S + "DA 46 05 D1 C1 E1 2B D7 FE 28 28 6D CD F6 24 ED ";
            S = S + "53 66 F5 ED 43 68 F5 30 07 E5 21 B4 31 C3 A4 24 ";
            S = S + "E5 C5 D5 ED 4B 6A F5 ED 5B 6C F5 CD 52 30 3E 00 ";
            S = S + "87 5F CD 3B 25 05 28 25 05 28 15 01 03 00 09 7B ";
            S = S + "CE 00 CB 3F CB 1C CB 1D CB 3F CB 1C CB 1D 18 0D ";
            S = S + "01 01 00 09 7B CE 00 CB 3F CB 1C CB 1D D1 19 38 ";
            S = S + "0D 00 11 04 00 19 38 06 00 D1 EB A7 ED 52 DA 46 ";
            S = S + "05 21 DF 2E 22 60 F5 18 35 CD A2 05 E5 CD C4 12 ";
            S = S + "ED 43 66 F5 7B 32 68 F5 E1 AF 32 69 F5 2B D7 3A ";
            S = S + "F6 FA 28 0A CF 2C FE 2C 3A F6 FA C4 0E 06 CD 93 ";
            S = S + "1F DA 46 05 32 69 F5 CD 94 25 32 70 F5 E5 CD 2C ";
            S = S + "06 DA 46 05 21 F0 24 E5 2A 60 F5 E5 21 62 F5 C9 ";
            S = S + "E1 DA 46 05 A7 C9 E5 CD FC 05 3A 63 F6 FE 03 28 ";
            S = S + "22 E1 3E 01 32 A5 F6 CD D8 05 C2 46 05 32 A5 F6 ";
            S = S + "E5 60 69 EB 19 2B E5 0A 87 6F 26 00 03 09 EB C1 ";
            S = S + "E1 A7 C9 E5 CD 14 06 E1 D1 37 C9 CF 2C EF FE 04 ";
            S = S + "D2 46 05 87 87 32 6F F5 CF D9 C9 06 01 3A AF FC ";
            S = S + "FE 08 C8 04 FE 05 C8 FE 07 C8 04 04 C9 AF 32 A5 ";
            S = S + "F6 2A 5E F5 37 C9 F5 CD A2 05 F1 CD 72 25 CD 94 ";
            S = S + "25 E5 CD C4 12 30 06 CD 42 13 CD B5 13 E1 C9 3A ";
            S = S + "E9 F3 C5 D5 5F CD 20 06 DA 46 05 2B D7 28 07 CF ";
            S = S + "2C FE 2C 28 01 EF 7B E5 CD AD 13 DA 46 05 E1 D1 ";
            S = S + "C1 C3 3E 1D 3E 00 D5 16 00 5F 2B D7 28 2E CF 2C ";
            S = S + "CA 4C 05 FE 2C 28 25 5F FE 54 28 18 FE D9 28 0C ";
            S = S + "3C 20 18 D7 CF 8D CF 44 1E F6 18 05 D7 CF 52 1E ";
            S = S + "F7 2B 18 05 D7 CA 40 05 5F 16 08 D7 7B CD B6 27 ";
            S = S + "DA 40 05 D1 C9 2A B3 FC A7 ED 42 D0 AF 95 6F 9C ";
            S = S + "95 67 AF D6 01 C9 2A B5 FC A7 ED 52 18 ED CD C4 ";
            S = S + "12 CD 00 26 E5 C5 2A B3 FC E3 22 B3 FC C1 E1 C9 ";
            S = S + "E5 2A B5 FC EB 18 33 CD 9C 05 C5 D5 CF F2 CD A2 ";
            S = S + "05 CD 6F 25 D1 C1 2B D7 28 25 CF 2C FE 2C 28 1F ";
            S = S + "CF 42 28 24 FE 2C 28 20 CF 46 CD 94 25 E5 CD 98 ";
            S = S + "28 2A B7 FC 22 B3 FC 2A B9 FC 22 B5 FC E1 C9 CD ";
            S = S + "94 25 E5 CD 23 28 18 E9 CD 94 25 E5 CD E7 27 18 ";
            S = S + "E0 CD 9C 05 C5 D5 CD 6F 25 3A F2 F3 5F 2B D7 28 ";
            S = S + "03 CF 2C EF 7B A7 CD C7 14 DA 46 05 D1 C1 E5 CD ";
            S = S + "AD 27 CD 42 13 11 01 00 CD 7E 27 28 14 E5 CD 8F ";
            S = S + "27 D1 19 EB AF CD 5B 27 3E 40 CD 5B 27 06 C0 18 ";
            S = S + "22 E1 C9 3A 9B FC B7 C4 89 05 3A 4A F9 B7 28 0C ";
            S = S + "2A 4B F9 E5 2A 49 F9 E5 2A 4D F9 E5 D1 C1 E1 79 ";
            S = S + "CD 7D 13 78 32 53 F9 87 28 D7 D5 30 05 CD 14 14 ";
            S = S + "18 03 CD FC 13 D1 38 E4 CD 7E 27 CA AC 26 AF 32 ";
            S = S + "4A F9 CD 8F 27 5D 54 B7 28 1A 2B 2B 7C 87 38 14 ";
            S = S + "ED 53 4D F9 CD 76 13 22 4B F9 32 49 F9 3A 53 F9 ";
            S = S + "2F 32 4A F9 2A 51 F9 19 EB CD 4F 27 2A 42 F9 3A ";
            S = S + "44 F9 CD 7D 13 2A 4F F9 ED 5B 51 F9 B7 ED 52 28 ";
            S = S + "3B 38 1C EB 06 01 CD 7E 27 28 31 B7 28 E7 EB 2A ";
            S = S + "42 F9 3A 44 F9 4F 3A 53 F9 47 CD 60 27 18 D6 CD ";
            S = S + "DC 25 2B 2B 7C 87 38 14 23 E5 EB 2A 2A F9 B7 ED ";
            S = S + "52 22 2A F9 D1 3A 53 F9 2F CD 5B 27 C3 93 26 3A ";
            S = S + "54 F9 4F 3A 55 F9 B1 C8 3A 53 F9 47 CD 76 13 4F ";
            S = S + "E3 C5 D5 E5 0E 02 E5 2A C6 F6 06 00 09 09 3E 88 ";
            S = S + "95 6F 3E FF 9C 67 38 03 39 E1 D8 C3 58 05 CD DB ";
            S = S + "14 ED 53 4F F9 22 51 F9 7C B5 79 32 55 F9 C9 CD ";
            S = S + "76 13 E5 F5 2A 42 F9 3A 44 F9 CD 7D 13 F1 E1 22 ";
            S = S + "42 F9 32 44 F9 CD 8F 15 79 32 54 F9 C9 E5 CD C4 ";
            S = S + "12 D2 46 05 E1 C9 A7 28 29 C5 47 CD 2C 06 78 C1 ";
            S = S + "D8 FE F8 28 1B FE F7 28 14 FE F6 28 0D FE C3 28 ";
            S = S + "06 FE C2 37 C0 AF C2 3E 04 C2 3E 01 C2 3E 02 C2 ";
            S = S + "3E 03 B2 32 02 FB C9 CD EE 25 CD EE 25 CD D5 25 ";
            S = S + "28 31 DC F4 25 CD E6 25 28 29 DC 00 26 2A B5 FC ";
            S = S + "E5 D5 EB CD 23 28 E1 22 B5 FC EB CD 23 28 E1 2B ";
            S = S + "13 22 B5 FC 2A B3 FC C5 4D 44 CD 23 28 E1 22 B3 ";
            S = S + "FC 4D 44 C5 D5 E5 2A B5 FC E5 2A B3 FC E5 CD EE ";
            S = S + "25 CD C4 12 CD E6 25 DC F1 25 D5 E5 08 AF 08 CD ";
            S = S + "D5 25 EB 30 04 08 F6 04 08 E1 E7 38 05 EB 08 F6 ";
            S = S + "01 08 E3 CD 80 29 3E 24 F3 D3 99 3E 91 D3 99 79 ";
            S = S + "D3 9B 78 D3 9B 7D D3 9B 3A F6 FA D3 9B 7B D3 9B ";
            S = S + "7A D3 9B E1 7D D3 9B 7C D3 9B 3A F2 F3 D3 9B 08 ";
            S = S + "D3 9B 3A 02 FB E6 0F F6 70 D3 9B FB E1 22 B3 FC ";
            S = S + "E1 22 B5 FC E1 D1 C1 C9 CD C4 12 69 60 7B CD A5 ";
            S = S + "29 CD F1 25 CD EE 25 08 AF 08 CD D5 25 30 04 08 ";
            S = S + "F6 04 08 23 E5 CD E6 25 30 04 08 F6 08 08 23 D1 ";
            S = S + "CD C4 29 08 CD DB 29 08 3A F2 F3 CD EB 29 3A 02 ";
            S = S + "FB E6 0F C6 80 CD E3 29 06 04 18 0A 06 06 18 06 ";
            S = S + "06 02 18 02 06 00 C5 CD 25 29 F1 F3 D3 99 3E AD ";
            S = S + "D3 99 3E 60 D3 99 3E AE D3 99 CD 80 29 E6 10 C8 ";
            S = S + "3E 08 F3 D3 99 3E 8F D3 99 DB 99 6F 3E 09 D3 99 ";
            S = S + "3E 8F D3 99 DB 99 F5 AF D3 99 3E 8F D3 99 FB F1 ";
            S = S + "E6 01 67 37 C9 F5 CD 80 29 3E 20 F3 D3 99 3E 91 ";
            S = S + "D3 99 7D D3 9B 7C D3 9B 7B D3 9B 3A F6 FA D3 9B ";
            S = S + "F1 D3 99 3E AC D3 99 FB C9 D5 CD A0 29 AF CD DB ";
            S = S + "29 3E 40 CD E3 29 CD 80 29 3E 07 CD 8B 29 FB D1 ";
            S = S + "C9 CD A5 29 3E 2C F3 D3 99 3E 91 D3 99 3A F2 F3 ";
            S = S + "D3 9B AF D3 9B 3A 02 FB E6 0F F6 50 D3 9B FB C9 ";
            S = S + "3E 02 CD 8B 29 FB 0F 38 F7 07 C9 F3 D3 99 3E 8F ";
            S = S + "D3 99 E5 E1 DB 99 F5 AF D3 99 3E 8F D3 99 F1 C9 ";
            S = S + "F5 3E 20 18 03 F5 3E 24 F5 CD 80 29 F3 F1 D3 99 ";
            S = S + "3E 91 D3 99 7D D3 9B 7C D3 9B F1 D3 9B 3A F6 FA ";
            S = S + "D3 9B FB C9 3E 28 F3 D3 99 3E 91 D3 99 7B D3 9B ";
            S = S + "7A D3 9B 7D D3 9B 7C D3 9B FB C9 F5 F3 D3 99 3E ";
            S = S + "AD 18 0E F5 F3 D3 99 3E AE 18 06 F5 F3 D3 99 3E ";
            S = S + "AC D3 99 FB F1 C9 00 20 00 00 00 00 00 00 08 02 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 3B 05 00 CD 14 ";
            S = S + "2A C3 6D 1B CD 40 2B F3 3E 55 21 00 00 01 00 80 ";
            S = S + "CD 77 09 CD FF 2A 11 05 07 CD C2 2A 11 00 2D CD ";
            S = S + "C2 2A 16 2A CD C2 2A 14 CD C2 2A 16 27 CD C2 2A ";
            S = S + "1E 37 21 F6 2B D9 21 6F 2B D9 11 60 01 CD C2 2A ";
            S = S + "3E F0 32 5E F5 F3 CD 34 10 3A 5E F5 47 0E 17 CD ";
            S = S + "47 06 78 3C 32 5E F5 FB 3E 03 F5 01 2D 00 16 26 ";
            S = S + "CD C2 2A D9 06 08 4E 23 D9 CD D8 2A 7E 23 FE FE ";
            S = S + "28 37 E5 C5 01 A6 01 30 03 06 00 4F CD D4 2A E1 ";
            S = S + "09 4D 44 E1 F1 EE 03 CD E3 2A F5 CD EC 2A D9 CB ";
            S = S + "21 10 04 06 08 4E 23 D9 30 CF 0B CD D8 2A 03 3E ";
            S = S + "02 CD E3 2A CD FA 2A 18 C0 1C F1 7E FE FE 20 95 ";
            S = S + "FB C9 C5 F5 F3 0E 99 ED 59 7A F6 80 E3 E3 ED 79 ";
            S = S + "FB F1 C1 C9 16 28 18 02 16 24 D5 59 CD C2 2A 58 ";
            S = S + "14 18 04 D5 5F 16 2C CD C2 2A D1 C9 D5 1E 70 16 ";
            S = S + "2E CD C2 2A CD 80 29 F3 D1 C9 D5 1E 50 18 F0 3E ";
            S = S + "02 CD F9 1C 06 0B CD D2 1C 07 07 E6 0C 4F 06 00 ";
            S = S + "21 5F 2B 09 4E 23 46 C5 23 5E 23 56 EB 11 00 10 ";
            S = S + "CD C2 2A CD 33 2B E1 CD 33 2B 21 44 04 CD 33 2B ";
            S = S + "21 77 07 C5 0E 9A F3 ED 69 E3 E3 ED 61 FB C1 C9 ";
            S = S + "06 08 21 4F 2B 56 23 5E 23 CD C2 2A 10 F7 C9 00 ";
            S = S + "08 01 20 08 2A 09 02 02 1F 05 F7 0B 00 06 0E 07 ";
            S = S + "00 00 00 20 04 27 02 72 02 56 00 70 05 70 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 6E 00 9F 00 6F 00 9F 00 ";
            S = S + "6F 00 9F 00 6F 00 9F 00 6F 00 9F 00 6F 00 9F 00 ";
            S = S + "6F 00 FF 00 07 00 FC 07 00 F7 00 07 00 F3 00 07 ";
            S = S + "00 F7 00 07 00 FF 00 07 00 FF 00 0F 00 FC 3C FC ";
            S = S + "3C FC 3C 87 C0 7B C0 87 C0 7B C0 86 C0 7B C0 86 ";
            S = S + "C0 7A C0 86 C0 78 C0 86 90 7A F0 86 F0 7F C0 83 ";
            S = S + "C0 7F C0 D7 C0 2F C0 D7 C0 2F C0 D7 C0 2F C0 D7 ";
            S = S + "C0 2F C0 D7 C0 2F C0 D7 C0 2F C0 D5 80 00 00 00 ";
            S = S + "00 00 00 00 00 00 FF FE FF FE FF FE FF FE FF FE ";
            S = S + "FF FE FF FE FF FE FF FE 44 1D 1D 1C 2F 68 2B 28 ";
            S = S + "22 FE 44 1D 1C 1E 2A 6D 29 29 22 FE 43 1F 1B 1E ";
            S = S + "26 73 25 29 24 FE 43 1F 1A 20 22 77 23 29 25 FE ";
            S = S + "42 21 19 20 1F 7C 1F 29 27 FE 42 21 18 22 1B 80 ";
            S = S + "1D 29 28 FE 41 23 17 22 19 84 1A 28 2A FE 41 23 ";
            S = S + "16 24 17 86 17 29 2B FE 40 25 15 24 15 8A 14 28 ";
            S = S + "2D FE 40 25 14 26 13 8C 11 29 2E FE 3F 27 13 26 ";
            S = S + "12 8F 0E 29 2F FE 3F 27 12 28 10 91 0C 28 31 FE ";
            S = S + "3E 29 11 28 0F 94 08 29 32 FE 3E 2A 0F 2A 0D 96 ";
            S = S + "06 28 34 FE 3D 2B 0E 2B 0C 99 02 29 35 FE 3D 2C ";
            S = S + "0D 2C 0B C2 37 FE 3C 2D 0C 2D 0A 26 4C 50 38 FE ";
            S = S + "3C 2E 0B 2E 09 23 51 4C 3A FE 3B 2F 0A 2F 09 21 ";
            S = S + "54 4A 3B FE 3B 30 09 30 08 20 57 46 3D FE 3A 31 ";
            S = S + "08 31 08 21 57 44 3E FE 3A 32 07 32 07 23 57 41 ";
            S = S + "3F FE 39 33 06 33 07 26 55 3E 41 FE 39 34 05 34 ";
            S = S + "07 47 35 3B 42 FE 38 35 04 35 07 4B 32 38 44 FE ";
            S = S + "38 36 03 36 07 4E 30 35 45 FE 37 37 02 37 08 50 ";
            S = S + "2E 32 47 FE 37 71 08 52 2D 2F 48 FE 36 72 09 54 ";
            S = S + "2B 2C 4A FE 36 73 09 55 2B 29 4B FE 35 74 0A 55 ";
            S = S + "29 2A 4B FE 35 75 0B 55 25 2D 4A FE 34 76 0C 55 ";
            S = S + "23 30 48 FE 34 1F 01 37 01 1F 0D 54 20 33 47 FE ";
            S = S + "33 20 02 36 02 1E 10 52 1E 36 45 FE 33 1F 03 35 ";
            S = S + "03 1F 12 50 1B 39 44 FE 32 20 04 34 04 1E 15 4E ";
            S = S + "19 3C 42 FE 32 1F 05 33 05 1F 18 4A 18 3E 41 FE ";
            S = S + "31 20 06 32 06 1E 1C 47 15 42 3F FE 31 1F 07 31 ";
            S = S + "07 1F 3C 26 14 44 3E FE 30 20 08 30 08 1E 40 22 ";
            S = S + "12 48 3C FE 30 1F 09 2F 09 1F 41 20 11 4A 3B FE ";
            S = S + "2F 20 0A 2E 0A 1E 41 20 0F 4E 39 FE 2F 1F 0B 2D ";
            S = S + "0B 1F 40 20 0E 28 01 27 38 FE 2E 20 0C 2C 0C 1E ";
            S = S + "3E 22 0C 29 04 27 36 FE 2E 1F 0D 2B 0D 1F 39 26 ";
            S = S + "0B 29 06 27 35 FE 2D 20 0E 2A 0E 7D 0A 28 0A 27 ";
            S = S + "33 FE 2D 1F 0F 29 0F 7C 09 29 0C 27 32 FE 2C 20 ";
            S = S + "10 28 10 7B 08 28 10 27 30 FE 2C 1F 11 27 11 7A ";
            S = S + "07 29 12 27 2F FE 2B 1F 13 25 13 78 07 28 16 27 ";
            S = S + "2D FE 2B 1F 13 25 13 77 06 29 18 27 2C FE 2A 1F ";
            S = S + "15 23 15 75 06 28 1C 27 2A FE 2A 1F 15 23 15 74 ";
            S = S + "06 27 1F 27 29 FE 29 1F 17 21 17 71 06 28 22 27 ";
            S = S + "27 FE 29 1F 17 21 17 70 06 27 25 27 26 FE 28 1F ";
            S = S + "19 1F 19 6D 06 28 28 27 24 FE 28 1F 19 1F 19 6A ";
            S = S + "08 27 2B 27 23 FE 27 1F 1B 1D 1B 66 09 28 2E 27 ";
            S = S + "21 FE 27 1F 1B 1D 1B 63 0B 27 31 27 20 FE 26 1F ";
            S = S + "1D 1B 1D 5F 0C 28 34 27 1E FE 26 1F 1D 1B 1D 5B ";
            S = S + "0E 28 37 27 1D FE FF FE FF FE FF FE FF FE FF FE ";
            S = S + "FF FE FF FE FF FE FF FE FE ED 4B 6A F5 ED 5B 6C ";
            S = S + "F5 CD 76 33 D8 CD 80 29 3E 20 CD 6E 33 21 62 F5 ";
            S = S + "01 9B 0E ED B3 7E E6 0F F6 90 ED 79 FB A7 C9 CD ";
            S = S + "20 33 3A AF FC D6 06 38 11 28 30 3D 28 0C CD 54 ";
            S = S + "33 77 23 0B 79 B0 C2 EE 2E C9 16 02 36 00 CD 13 ";
            S = S + "2F CD 54 33 B6 77 0B 79 B0 28 06 15 20 F0 23 18 ";
            S = S + "E9 15 C8 7E 87 87 87 87 77 A7 C9 16 04 36 00 7E ";
            S = S + "87 87 77 CD 54 33 B6 77 0B 79 B0 20 04 B3 28 07 ";
            S = S + "1D 15 20 EB 23 18 E4 15 C8 7E 87 87 15 20 FB 77 ";
            S = S + "A7 C9 CD C9 32 D8 CD 80 29 3E 20 CD 6E 33 C5 21 ";
            S = S + "62 F5 01 9B 0E ED B3 C1 7E E6 0F F6 B0 E1 F5 3A ";
            S = S + "AF FC D6 06 38 2C 28 6C 3D 28 27 CD 6C 33 3A A8 ";
            S = S + "F5 5F A7 C4 A2 33 7E D3 9B F1 D3 99 3E AE D3 99 ";
            S = S + "FB 0B 79 B0 C8 23 7B A7 C4 A2 33 38 F4 7E D3 9B ";
            S = S + "18 EF CD 6C 33 16 0F 3A A8 F5 5F A7 C4 A2 33 7E ";
            S = S + "0F 0F 0F 0F A2 D3 9B F1 D3 99 3E AE D3 99 FB 0B ";
            S = S + "79 B0 C8 7B A7 C4 A2 33 38 04 7E A2 D3 9B 23 0B ";
            S = S + "79 B0 C8 7B A7 C4 A2 33 38 E5 7E 0F 0F 0F 0F A2 ";
            S = S + "D3 9B 18 DB CD 6C 33 16 03 3A A8 F5 A7 C4 A2 33 ";
            S = S + "7E 0F 0F A2 D3 9B F1 D3 99 3E AE D3 99 FB 0B 79 ";
            S = S + "B0 C2 F7 2F B3 C8 1D 3A A8 F5 A7 C4 A2 33 38 08 ";
            S = S + "7E 0F 0F 0F 0F A2 D3 9B 0B 79 B0 C2 11 30 B3 C8 ";
            S = S + "1D 3A A8 F5 A7 C4 A2 33 38 06 7E 0F 0F A2 D3 9B ";
            S = S + "0B 79 B0 C2 29 30 B3 C8 1D 3A A8 F5 A7 C4 A2 33 ";
            S = S + "38 04 7E A2 D3 9B 0B 79 B0 C2 3F 30 B3 C8 1D 23 ";
            S = S + "3A A8 F5 A7 C4 A2 33 38 A5 7E 07 07 A2 D3 9B C3 ";
            S = S + "EE 2F 21 00 00 3E 10 A7 F5 29 30 03 F1 37 F5 EB ";
            S = S + "29 EB 30 06 09 30 03 F1 37 F5 F1 3D 20 EA C9 E5 ";
            S = S + "CD BB 32 E1 23 23 23 23 1E 00 18 0B E5 23 23 23 ";
            S = S + "23 CD BB 32 E1 1E 01 D5 4E 23 46 23 5E 23 56 EB ";
            S = S + "A7 ED 42 23 D1 D5 CD C7 33 D1 1D F5 C4 44 34 F1 ";
            S = S + "CC 33 34 CD 57 34 A7 C9 E5 CD BB 32 21 00 00 5D ";
            S = S + "CD C7 33 CD 44 34 22 75 F5 ED 5B 71 F5 E1 73 23 ";
            S = S + "72 2B CD C9 32 38 2C CD 80 29 3E 20 CD 6E 33 C5 ";
            S = S + "21 62 F5 01 9B 0E ED B3 C1 7E E6 0F F6 B0 21 F2 ";
            S = S + "30 E3 F5 3A AF FC D6 06 38 32 CA 5C 31 3D 28 2C ";
            S = S + "18 07 A7 F5 CD 57 34 F1 C9 CD 6C 33 CD 9D 33 7E ";
            S = S + "D3 9B F1 D3 99 3E AE D3 99 FB 0B 79 B0 C8 23 CD ";
            S = S + "79 32 CD 9D 33 38 F3 7E D3 9B 18 EE CD 6C 33 16 ";
            S = S + "00 CD 9D 33 7E 0F 0F 0F 0F E6 0F D3 9B F1 D3 99 ";
            S = S + "3E AE D3 99 FB 14 0B 79 B0 20 03 B3 C8 1D CD 79 ";
            S = S + "32 7A 0F 7E 23 38 05 2B 0F 0F 0F 0F F5 CD 9D 33 ";
            S = S + "38 07 F1 E6 0F D3 9B 18 DC F1 18 D9 CD 6C 33 16 ";
            S = S + "00 CD 9D 33 7E 0F 0F E6 03 D3 9B F1 D3 99 3E AE ";
            S = S + "D3 99 FB 14 0B 79 B0 20 03 B3 C8 1D CD 79 32 7A ";
            S = S + "E6 03 28 13 3D 28 18 3D 28 10 CD 9D 33 38 05 7E ";
            S = S + "E6 03 D3 9B 23 18 DC 7E 18 08 7E 0F 0F 18 05 7E ";
            S = S + "07 07 07 07 F5 CD 9D 33 38 07 F1 E6 03 D3 9B 18 ";
            S = S + "C2 F1 18 BF E5 23 23 23 23 E5 CD BB 32 21 00 00 ";
            S = S + "1E 01 CD C7 33 ED 5B 71 F5 E1 73 23 72 E1 CD 20 ";
            S = S + "33 3A AF FC D6 06 38 15 28 4D 3D 28 10 CD 92 32 ";
            S = S + "CD 54 33 77 23 0B 79 B0 20 F3 C3 70 32 16 00 CD ";
            S = S + "92 32 3E 07 F3 D3 99 3E 8F D3 99 E5 E1 7A 0F DB ";
            S = S + "99 30 05 B6 77 23 18 05 87 87 87 87 77 AF D3 99 ";
            S = S + "3E 8F D3 99 FB 14 0B 79 B0 20 D4 B3 28 03 1D 18 ";
            S = S + "CE 7A 0F 38 4C 18 49 16 00 CD 92 32 3E 07 F3 D3 ";
            S = S + "99 3E 8F D3 99 E5 E1 7A E6 03 28 0D 3D 28 10 3D ";
            S = S + "DB 99 28 0F B6 77 23 18 0E DB 99 0F 0F 18 07 DB ";
            S = S + "99 07 07 07 07 B6 77 AF D3 99 3E 8F D3 99 FB 14 ";
            S = S + "0B 79 B0 20 C4 B3 28 03 1D 18 BE 7A E6 03 20 01 ";
            S = S + "2B CD B0 32 CD 57 34 A7 C9 D5 E5 2A 71 F5 ED 5B ";
            S = S + "75 F5 19 EB E1 E7 D1 D8 C5 D5 CD 44 34 22 75 F5 ";
            S = S + "18 18 D5 E5 2A 71 F5 ED 5B 73 F5 19 EB E1 E7 D1 ";
            S = S + "D8 2A 73 F5 C5 D5 CD 36 34 A7 D1 C1 2A 71 F5 C9 ";
            S = S + "ED 5B 71 F5 A7 ED 52 23 C3 36 34 7E 23 66 6F CD ";
            S = S + "BA 05 7A FE 09 D8 C3 2E 05 2A 62 F5 4E 23 46 23 ";
            S = S + "5E 23 56 23 CD 76 33 D8 E5 C5 D5 2A 66 F5 3A 6F ";
            S = S + "F5 E6 04 20 08 EB CD 90 33 A7 ED 52 3E 23 22 A0 ";
            S = S + "F5 22 A2 F5 50 59 EB ED 52 30 03 21 00 00 22 A4 ";
            S = S + "F5 22 A6 F5 7C B5 32 A8 F5 D1 C1 ED 43 6A F5 ED ";
            S = S + "53 6C F5 CD 52 30 44 4D 3E 00 8F 5F A7 E1 E3 E9 ";
            S = S + "CD 80 29 3E 20 CD 6E 33 21 62 F5 01 9B 0E ED B3 ";
            S = S + "3E A0 ED 79 FB ED 4B 6A F5 ED 5B 6C F5 2A 66 F5 ";
            S = S + "71 23 70 23 73 23 72 23 E5 CD 52 30 44 4D 3E 00 ";
            S = S + "8F 5F E1 C9 F3 3E 07 D3 99 3E 8F D3 99 E5 E1 DB ";
            S = S + "99 F5 AF D3 99 3E 8F D3 99 F1 FB C9 3E AC F3 D3 ";
            S = S + "99 3E 91 D3 99 C9 78 B1 37 C8 7A B3 37 C8 E5 D5 ";
            S = S + "59 50 CD 90 33 E7 D1 E1 D8 E5 21 D4 00 E7 E1 C9 ";
            S = S + "21 00 01 3A AF FC E6 06 FE 06 C0 24 C9 3A A8 F5 ";
            S = S + "A7 C8 E5 2A A2 F5 7D B4 28 06 2B 22 A2 F5 E1 C9 ";
            S = S + "2A A6 F5 2B 7D B4 20 09 2A A0 F5 22 A2 F5 2A A4 ";
            S = S + "F5 22 A6 F5 E1 37 C9 3A A7 FF FE C9 CA 46 05 C5 ";
            S = S + "E5 21 77 F5 E5 72 7B A7 F5 EB 13 21 66 F8 01 0B ";
            S = S + "00 ED B0 AF 06 19 12 13 10 FC F1 D1 F5 0E 0F 28 ";
            S = S + "02 0E 16 CD 5C 34 3C 20 08 F1 CA 5E 05 1E 43 18 ";
            S = S + "53 21 01 00 22 85 F5 F1 E1 D1 7C B5 20 1A 21 00 ";
            S = S + "FE 39 30 0D ED 5B C6 F6 A7 ED 52 38 04 7C A7 20 ";
            S = S + "07 ED 5B 62 F8 21 00 01 ED 53 71 F5 22 73 F5 0E ";
            S = S + "1A 18 29 2A 73 F5 11 77 F5 0E 26 CD 5C 34 A7 C8 ";
            S = S + "1E 42 18 10 2A 73 F5 11 77 F5 0E 27 CD 5C 34 7D ";
            S = S + "B4 C0 1E 37 C3 C6 05 11 77 F5 0E 10 DD 21 FD 7F ";
            S = S + "C3 62 02 06 00 E6 7F 4F ED 42 C9 DB BA 2F E6 08 ";
            S = S + "C8 3E FF C9 21 FF FA AF CB 7E C8 CB BE DB BA E6 ";
            S = S + "07 57 DB B8 6F 26 00 DB B9 CB 3A 1F 5F CB 14 E5 ";
            S = S + "D5 01 FD FF 09 EB 0E EE 09 7B D3 B8 CB 1A ED 6A ";
            S = S + "7D D3 B9 7C D3 BA D1 E1 DB BA E6 20 C8 3A 01 FB ";
            S = S + "CD 63 34 01 D3 00 CD C7 34 7D 32 00 FB EB 3A FF ";
            S = S + "FA CD 63 34 01 FF 00 7C 17 38 09 E5 ED 42 E1 38 ";
            S = S + "05 69 60 DA 2E 00 7D 32 FE FA 3E FF C9 FE 08 28 ";
            S = S + "93 FE 0B 28 86 1E 0F 01 BF 00 21 EF 10 FE 0C 28 ";
            S = S + "18 01 FF 40 21 DF 20 FE 10 28 0E E6 03 D6 02 3A ";
            S = S + "FE FA F8 3A 00 FB C8 AF C9 F3 CD 7F 35 CD 9A 35 ";
            S = S + "F5 CD 85 35 CD 91 35 F5 CD 7F 35 CD 97 35 F5 CD ";
            S = S + "85 35 CD 97 35 F5 CD 7F 35 CD 97 35 F5 CD 85 35 ";
            S = S + "CD 91 35 F5 CD 7F 35 CD AA 35 CD 85 35 CD AA 35 ";
            S = S + "CD 7F 35 FB F1 E1 D1 C1 EE 08 D6 02 FE 0D 38 0D ";
            S = S + "F1 CD 77 35 32 00 FB F1 CD 77 35 18 14 7A 87 87 ";
            S = S + "87 87 B4 ED 44 32 00 FB F1 D1 87 87 87 87 B0 ED ";
            S = S + "44 32 FE FA 3E FF C9 EE 08 CB 5F C8 F6 F0 C9 CD ";
            S = S + "A2 35 A5 18 04 CD A2 35 B4 F5 7B D3 A0 F1 D3 A1 ";
            S = S + "C9 CD AA 35 CD AA 35 CD AA 35 3E 0E CD A3 35 E6 ";
            S = S + "0F C9 7B D3 A0 DB A2 A1 B0 C9 E3 E3 E3 E3 C9 FE ";
            S = S + "2C 28 3C EF FE 04 30 7D A7 28 07 FE 01 28 03 1E ";
            S = S + "00 3D D5 0F 0F 57 0F 0F 5F 3A E8 FF E6 CF B3 0E ";
            S = S + "09 CD B4 36 7A EE C0 5F 3E 3F CD 61 36 D1 7B 0F ";
            S = S + "0F 0F 5F 3A E7 FF E6 DF B3 CD B2 36 2B D7 C8 CF ";
            S = S + "2C FE 2C 28 0B CD 6C 36 3E DF CD 61 36 2B D7 C8 ";
            S = S + "CF 2C FE 2C 28 11 CD 6C 36 CB 0B 3A E7 FF E6 EF ";
            S = S + "B3 CD B2 36 2B D7 C8 CF 2C FE 2C 28 0F CD 6C 36 ";
            S = S + "07 07 07 5F 3E F7 CD 61 36 2B D7 C8 CF 2C FE 2C ";
            S = S + "28 12 CD FD 36 D2 46 05 2F E6 03 5F 3E FC CD 61 ";
            S = S + "36 2B D7 C8 CF 2C FE 2C 28 0E CD 6C 36 07 07 5F ";
            S = S + "3E FB CD 61 36 2B D7 C8 CF 2C CD 6C 36 CB 0B 3E ";
            S = S + "EF E5 21 F7 FA A6 B3 77 D3 F7 E1 C9 EF FE 02 30 ";
            S = S + "C4 A7 C8 1E 20 C9 D7 28 0D FE 2C 28 09 CD 6C 36 ";
            S = S + "3D 20 03 1E 00 01 1E 02 2B D7 3E FF 28 05 D5 CF ";
            S = S + "2C EF D1 57 3A E6 F3 F5 7A CD AE 36 CD B8 36 F6 ";
            S = S + "40 CD B4 36 CD B8 36 FB E6 BF CD B4 36 F1 0E 07 ";
            S = S + "18 02 0E 08 47 C3 47 06 3E 02 CD 8B 29 E6 40 28 ";
            S = S + "F7 3E 02 CD 8B 29 CB 77 20 F7 B3 E6 02 28 E9 3A ";
            S = S + "DF F3 0E 00 C9 CD 47 19 01 F8 FF 09 54 5D 46 23 ";
            S = S + "4E 23 CB 66 C0 23 C5 01 05 00 ED B0 C1 13 EB 70 ";
            S = S + "23 71 C9 32 F7 FA AF D3 F8 32 F8 FF C9 EF FE 10 ";
            S = S + "D0 F5 0F 0F E6 03 5F 3E FC CD 11 37 F1 E6 03 37 ";
            S = S + "C9 E5 21 F8 FF A6 B3 77 D3 F8 E1 C9 0A 00 00 00 ";
            S = S + "05 02 0F 04 04 03 01 00 02 FF FB 3C 20 06 CD C3 ";
            S = S + "39 C8 37 C9 F5 CD 88 3D F1 DD 21 AA 3C DD E5 E5 ";
            S = S + "21 4D 37 85 6F 30 01 24 7E 23 66 6F E3 C9 0D 3A ";
            S = S + "98 3A 39 39 B2 3A 2F 3B E0 38 EF 38 36 39 61 39 ";
            S = S + "8D 3B 8B 06 67 01 3A 09 FD CB 6F 20 3F E6 70 47 ";
            S = S + "3A 62 37 F6 10 B0 32 09 FD CB 77 28 0E 06 40 CD ";
            S = S + "9A 3B 3A 28 FC B7 C2 84 3D 10 F4 3A 63 37 4F 11 ";
            S = S + "00 00 2B D7 79 28 3D CF 28 C5 CD CD 3C C1 47 C5 ";
            S = S + "CF 29 C1 C0 78 B9 38 08 20 02 7A B3 C2 46 05 78 ";
            S = S + "B7 20 21 E5 21 00 E6 19 E1 38 19 E5 21 09 FD CB ";
            S = S + "B6 CD D7 38 4E 6F 20 52 41 4D 20 64 69 73 6B 0D ";
            S = S + "0A 00 E1 C9 E5 D5 F5 21 62 F5 77 2B 72 2B 73 B7 ";
            S = S + "28 09 CB E2 FE 01 28 03 11 FF 7F 2B 72 2B 73 11 ";
            S = S + "00 40 01 05 00 CD AF 3C CD 68 3C F1 D1 6F 26 00 ";
            S = S + "29 29 29 29 29 29 5A 16 00 19 11 E7 FF 19 E5 21 ";
            S = S + "FF FF 22 38 FC ED 4B 64 37 CD C2 3B 0B 78 B1 20 ";
            S = S + "F8 C1 C5 23 22 38 FC CD C2 3B 0B 78 B1 20 F8 CD ";
            S = S + "5A 38 06 40 CD 9B 3B 10 FB 21 09 FD CB F6 E1 CD ";
            S = S + "68 3D CD D7 38 20 62 79 74 65 73 20 61 6C 6C 6F ";
            S = S + "63 61 74 65 64 0D 0A 00 E1 C9 C5 AF 06 20 21 18 ";
            S = S + "FC 77 23 10 FC C1 C9 CD 88 3D CD AE 05 E5 01 00 ";
            S = S + "40 CD 9A 3B 21 18 FC 7E A7 28 33 0C C5 11 5E F5 ";
            S = S + "D5 01 0B 00 ED B0 E1 06 08 CD D1 38 7E FE 20 28 ";
            S = S + "02 3E 2E DF 06 03 CD D1 38 3A 61 F6 A7 28 0E C6 ";
            S = S + "0C 21 B0 F3 BE 30 03 3E 20 DF D4 AE 05 C1 10 C1 ";
            S = S + "79 B7 CA 5E 05 CD AE 05 CD 61 39 CD 72 3D CD D7 ";
            S = S + "38 20 62 79 74 65 73 20 66 72 65 65 0D 0A 00 E1 ";
            S = S + "C9 7E 23 DF 10 FB C9 E3 7E 23 E3 A7 C8 DF 18 F7 ";
            S = S + "CD 94 3B 2A 26 FC FD 4E 06 45 6C 26 00 18 11 CD ";
            S = S + "94 3B ED 4B 34 FC 7E 0F 38 03 FD 4E 06 2A 36 FC ";
            S = S + "C5 DD 21 FF 46 CD 1C 00 01 45 65 11 53 60 DD 21 ";
            S = S + "5C 32 CD 1C 00 21 F6 F7 11 47 F8 01 08 00 ED B0 ";
            S = S + "E1 DD 21 FF 46 CD 1C 00 DD 21 42 30 CD 1C 00 DD ";
            S = S + "21 9A 26 C3 1C 00 7E FE 01 1E 3D C2 90 3D CD 50 ";
            S = S + "39 21 FF FF 38 01 23 22 F8 F7 3E 02 32 63 F6 C9 ";
            S = S + "E5 FD E1 FD 7E 07 E6 01 C8 FD 7E 06 FD BE 05 3F ";
            S = S + "C9 ED 4B 64 37 21 00 00 CD C1 3B 20 01 23 0B 78 ";
            S = S + "B1 20 F5 45 6C 61 18 88 CD A8 39 CF 29 CD 7C 3D ";
            S = S + "AF 32 18 FC CD 9B 3B ED 5B 32 FC 7A B3 C8 E5 42 ";
            S = S + "4B CD C1 3B ED 5B 38 FC 21 00 00 22 38 FC CD C2 ";
            S = S + "3B 7A A3 3C 20 E9 E1 C9 CF 28 CD 88 3D CD BA 05 ";
            S = S + "C8 7A FE FC 30 0A FE 09 38 06 E5 CD C3 39 E1 C8 ";
            S = S + "C3 2E 05 21 89 FD 11 D8 39 1A BE 20 06 23 13 B7 ";
            S = S + "20 F7 C9 D6 30 C0 B6 C9 4D 45 4D 30 00 CD A8 39 ";
            S = S + "CD 7C 3D C5 CF 41 CF 53 CD AD 39 CF 29 CD F7 3B ";
            S = S + "1E 41 CA 90 3D C1 CD 9A 3B E5 CD 8A 3A E1 C3 9B ";
            S = S + "3B D1 3E FF FD 46 01 32 28 FC C3 9B 3B D5 CD F7 ";
            S = S + "3B DD 21 01 3A DD E5 F5 B7 C2 3A 05 7B 0F 0F 38 ";
            S = S + "49 0F DA 34 05 F1 C2 5E 05 CD B6 3C CB 43 20 1E ";
            S = S + "2A 35 FC 22 26 FC 21 34 FC 7E FD 77 06 AF 77 2A ";
            S = S + "32 FC 7C B5 C8 2A 2C FC 22 24 FC C3 35 3C 67 6F ";
            S = S + "22 24 FC 22 26 FC 2A 34 FC FD 75 05 2B 7C B7 C0 ";
            S = S + "3A 36 FC B7 C0 FD CB 07 C6 C9 F1 20 03 CD 80 39 ";
            S = S + "06 40 CD 9A 3B 3A 18 FC A7 28 07 10 F5 1E 43 C3 ";
            S = S + "90 3D 1E 02 CD B6 3C CD 5A 38 C5 11 18 FC 21 66 ";
            S = S + "F8 01 0B 00 ED B0 C1 C9 CD 94 3B C5 AF 32 28 FC ";
            S = S + "7E 0F 38 0A FD 7E 06 32 34 FC A7 C4 36 3C C1 C3 ";
            S = S + "9B 3B E5 FD E1 FD 7E 06 A7 20 4C E5 C5 CD 94 3B ";
            S = S + "01 01 00 2A 64 37 CD C1 3B 28 0B 2B 03 7C B5 20 ";
            S = S + "F5 1E 42 C3 90 3D 2A 32 FC 7C B5 20 04 ED 43 32 ";
            S = S + "FC ED 43 38 FC C5 ED 4B 24 FC C4 C2 3B C1 ED 43 ";
            S = S + "2C FC ED 43 24 FC 21 FF FF 22 38 FC CD C2 3B FD ";
            S = S + "46 01 CD 9B 3B C1 E1 E5 11 09 00 19 FD 5E 06 19 ";
            S = S + "71 FD 34 06 E1 C0 CD 94 3B C5 CD 36 3C C1 2A 35 ";
            S = S + "FC 23 22 35 FC 2A 26 FC 23 22 26 FC C3 9B 3B CD ";
            S = S + "50 39 D8 FD 7E 03 B7 0E 00 FD 71 03 C0 FD 7E 06 ";
            S = S + "A7 28 17 01 09 00 09 4F 09 7E FD 34 06 C0 F5 FD ";
            S = S + "46 01 CD 9A 3B CD 25 3B F1 C9 CD 94 3B C5 ED 4B ";
            S = S + "24 FC 78 B1 2A 32 FC 22 38 FC C4 C1 3B 2A 38 FC ";
            S = S + "22 24 FC E5 CD 35 3C FD 34 06 D1 2A 2C FC E7 20 ";
            S = S + "04 FD CB 07 C6 C1 CD 9B 3B FD 7E 09 C9 E5 FD E1 ";
            S = S + "FD 71 03 C9 23 46 2B E5 FD E1 F6 37 E5 D5 C5 F5 ";
            S = S + "78 B7 28 4E FE 41 30 4A 68 26 00 2B 29 29 29 29 ";
            S = S + "29 11 00 51 19 11 18 FC F1 30 01 EB 01 20 00 18 ";
            S = S + "18 F6 37 E5 D5 C5 F5 CD E8 3B 21 FE 40 09 09 11 ";
            S = S + "38 FC F1 30 01 EB 01 02 00 CD AF 3C CD 68 3C 2A ";
            S = S + "38 FC 7C B5 C1 D1 E1 C9 78 B1 28 06 2A 64 37 ED ";
            S = S + "42 D0 1E 3C C3 90 3D E5 D5 11 66 F8 06 0B 1A FE ";
            S = S + "61 38 07 FE 7B 30 03 E6 DF 12 13 10 F1 06 40 CD ";
            S = S + "9A 3B C5 21 18 FC 7E A7 28 11 11 66 F8 06 0B 1A ";
            S = S + "BE 20 08 13 23 10 F8 AF C1 18 04 C1 10 E1 04 3A ";
            S = S + "28 FC D1 E1 C9 F6 37 F5 FD E5 E1 01 09 00 09 E5 ";
            S = S + "ED 4B 24 FC CD E8 3B 21 18 00 09 7D E6 3F F6 40 ";
            S = S + "57 1E 00 29 29 3E 02 84 FE 04 30 02 EE 01 D3 FD ";
            S = S + "E1 F1 38 01 EB 01 00 01 D9 21 FF FF 3A 09 FD 57 ";
            S = S + "0F 0F E6 C0 4F 0F 0F 0F 0F B1 4F DB A8 47 E6 33 ";
            S = S + "B1 5F F3 D3 A8 7A E6 0C 57 7E 2F 4F E6 F3 B2 77 ";
            S = S + "7B E6 3F 57 78 E6 C0 B2 FB D3 A8 D9 ED B0 D9 7B ";
            S = S + "F3 D3 A8 79 77 78 FB D3 A8 D9 F5 3E 02 18 03 F5 ";
            S = S + "3E 03 D3 FD F1 C9 E5 FD E1 E5 AF 22 64 F8 73 23 ";
            S = S + "70 23 23 77 23 23 77 23 77 23 77 E1 C9 CD FC 05 ";
            S = S + "3A 63 F6 FE 03 CA 46 05 FE 02 20 0F ED 5B F8 F7 ";
            S = S + "13 7A 07 07 E6 03 CB BA CB B2 C9 E5 01 41 10 11 ";
            S = S + "00 00 DD 21 4E 32 CD 1C 00 2A F6 F7 ED 5B F8 F7 ";
            S = S + "E5 D5 E5 D5 21 45 16 22 F6 F7 21 38 40 22 F8 F7 ";
            S = S + "D1 C1 DD 21 67 32 CD 1C 00 2A F6 F7 E5 2A F8 F7 ";
            S = S + "E5 DD 21 DB 30 CD 1C 00 01 C5 16 11 38 40 DD 21 ";
            S = S + "5C 32 CD 1C 00 C1 E1 D1 E3 C5 4D 44 DD 21 4E 32 ";
            S = S + "CD 1C 00 DD 21 8A 2F CD 1C 00 D1 C1 E5 ED 43 F6 ";
            S = S + "F7 ED 53 F8 F7 3E 04 32 63 F6 DD 21 11 52 CD 1C ";
            S = S + "00 C2 46 05 7B D1 E1 C9 11 00 01 DD 21 93 31 CD ";
            S = S + "1C 00 DD 21 25 34 CD 1C 00 C3 F6 05 CD F7 3B C2 ";
            S = S + "5E 05 A7 C8 1E 40 18 08 3A 09 FD CB 77 C0 1E 46 ";
            S = S + "AF 32 7C F8 D5 CD C0 05 D1 C3 C6 05 01 BF 3D 0A ";
            S = S + "03 B7 C8 93 28 04 03 03 18 F5 69 60 5E 23 56 21 ";
            S = S + "5E F5 E5 77 13 23 1A 77 B7 20 F9 E1 1E 01 C9 3C ";
            S = S + "D4 3D 3D DC 3D 40 EA 3D 41 FA 3D 42 0E 3E 43 1C ";
            S = S + "3E 46 2B 3E 00 42 61 64 20 46 41 54 00 42 61 64 ";
            S = S + "20 66 69 6C 65 20 6D 6F 64 65 00 46 69 6C 65 20 ";
            S = S + "73 74 69 6C 6C 20 6F 70 65 6E 00 46 69 6C 65 20 ";
            S = S + "61 6C 72 65 61 64 79 20 65 78 69 73 74 73 00 52 ";
            S = S + "41 4D 20 64 69 73 6B 20 66 75 6C 6C 00 54 6F 6F ";
            S = S + "20 6D 61 6E 79 20 66 69 6C 65 73 00 52 41 4D 20 ";
            S = S + "64 69 73 6B 20 6F 66 66 6C 69 6E 65 00 E5 CD 4B ";
            S = S + "1C 3E BE 21 68 00 CD 2B 1D 21 81 3E CD 4B 1C 3A ";
            S = S + "63 37 3C 3C 6F 26 00 29 29 29 29 22 F8 F7 3E 02 ";
            S = S + "32 63 F6 DD 21 26 34 3E 80 01 00 03 CD 1C 00 CD ";
            S = S + "4B 1C E1 C3 4B 1C 56 49 44 45 4F 20 52 41 4D 3A ";
            S = S + "00 55 53 45 52 20 20 52 41 4D 3A 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 00 ";

            return S;
        }

         public static string gs_Get_MSX_DISK()
        {
            string S;

            S = "";

          //== MSX DISK [4000H~7FFFH,4000H,16384] ==
            S = S + "41 42 6F 57 76 65 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "C3 4D 74 C3 0B 78 C3 5F 78 C3 7F 78 C3 BE 78 C3 ";
            S = S + "8E 77 C3 3A 5B 37 C3 B1 60 C3 0D 62 00 C3 B3 5F ";
            S = S + "2A 4B F3 C9 DD E5 DD 21 B7 00 CD AB 40 DD E1 30 ";
            S = S + "0A 3E 03 32 36 F3 32 37 F3 A7 C9 3A 36 F3 A7 3A ";
            S = S + "37 F3 C0 DD E5 DD 21 9C 00 CD AB 40 DD E1 C8 3E ";
            S = S + "FF 32 36 F3 DD E5 DD 21 9F 00 CD AB 40 DD E1 32 ";
            S = S + "37 F3 C5 06 00 04 C1 C9 E5 21 36 F3 AF BE 77 23 ";
            S = S + "7E E1 C0 DD E5 DD 21 9F 00 CD AB 40 DD E1 C9 DD ";
            S = S + "E5 DD 21 A2 00 CD AB 40 DD E1 C9 DD E5 DD 21 A5 ";
            S = S + "00 CD AB 40 DD E1 C9 DD 21 9B 40 FD E5 FD 2A C0 ";
            S = S + "FC CD 1C 00 FB FD E1 C9 3E 0D D3 B4 3E 0A D3 B5 ";
            S = S + "AF D3 B4 06 0F DB B5 E6 0F A8 D3 B5 4F 00 DB B5 ";
            S = S + "E6 0F B9 C0 A8 D3 B5 10 EC 3E FF 32 38 F3 3E 0D ";
            S = S + "D3 B4 3E 09 D3 B5 3E 0A D3 B4 3E 01 D3 B5 3E 0D ";
            S = S + "D3 B4 AF D3 B5 01 00 0D 79 D3 B4 DB B5 F5 0C 10 ";
            S = S + "F7 3E 0E D3 B4 AF D3 B5 06 0D 0D 79 D3 B4 F1 D3 ";
            S = S + "B5 10 F7 18 39 22 3B F3 3A 38 F3 A7 C8 3A 4A F2 ";
            S = S + "47 3A 49 F2 4F 3A 48 F2 57 1E 07 CD 6C 7E 18 12 ";
            S = S + "3A 38 F3 A7 C8 1E 00 CD 59 41 3E 0F D3 B4 3E 02 ";
            S = S + "D3 B5 62 CD 60 41 61 CD 60 41 60 CD 60 41 3E 0D ";
            S = S + "D3 B4 DB B5 F6 08 D3 B5 C9 CD 4E 41 E6 04 18 F6 ";
            S = S + "AF 2E 08 CB 04 8F 27 2D 20 F9 CD 71 41 0F 0F 0F ";
            S = S + "0F F5 7B 1C D3 B4 F1 18 DD 3A 38 F3 A7 47 4F 57 ";
            S = S + "5F 2A 3B F3 C8 CD 59 41 1E 0D CD AD 41 CD 23 55 ";
            S = S + "CD AD 41 32 49 F2 CD AD 41 32 48 F2 1D CD AD 41 ";
            S = S + "47 CD AD 41 4F CD AD 41 CD 4E 41 37 C9 AF CD B5 ";
            S = S + "41 87 87 82 87 57 1D 7B D3 B4 DB B5 E6 0F 82 57 ";
            S = S + "C9 20 4D 53 58 2D 44 4F 53 20 76 65 72 2E 20 32 ";
            S = S + "2E 32 20 43 6F 70 79 72 69 67 68 74 20 31 39 38 ";
            S = S + "34 20 62 79 20 4D 69 63 72 6F 73 6F 66 74 20 06 ";
            S = S + "00 3E 22 C9 DD 5E 13 DD 56 14 CD 52 F2 D5 5D 54 ";
            S = S + "CB 3C CB 1D 1F 19 D1 19 17 7E 23 66 30 0C CB 3C ";
            S = S + "1F CB 3C 1F CB 3C 1F CB 3C 1F 6F 7C E6 0F 67 B5 ";
            S = S + "C9 D5 5D 54 CB 3C CB 1D 1F 19 D1 19 17 30 18 CB ";
            S = S + "21 CB 10 CB 21 CB 10 CB 21 CB 10 CB 21 CB 10 7E ";
            S = S + "E6 0F B1 77 23 70 C9 71 23 7E E6 F0 B0 77 C9 11 ";
            S = S + "B9 F2 1A BE 23 13 C0 10 F9 C9 CD 55 F2 21 F7 F1 ";
            S = S + "0E 05 06 04 CD 4F 42 20 2F 06 04 1A 13 FE 20 20 ";
            S = S + "32 10 F8 79 ED 44 32 16 F2 21 B9 F2 11 0B F2 01 ";
            S = S + "04 00 ED B0 CD 96 54 ED 43 23 F2 ED 53 21 F2 21 ";
            S = S + "0B F2 E5 FD E1 F6 01 C9 05 7D 80 6F 7C CE 00 67 ";
            S = S + "0D 20 BF 37 C9 D5 21 0E 00 19 36 00 CD B1 42 D1 ";
            S = S + "C9 CD 0E 44 D8 CD 5A 42 D0 CD D3 44 CD 58 F2 CD ";
            S = S + "0E 43 D8 7E B7 28 35 FE E5 28 31 E5 06 0B 11 B9 ";
            S = S + "F2 CD 52 42 28 06 FE 3F 20 1B 10 F5 E1 E5 FD E1 ";
            S = S + "3A C4 F2 EE 80 CB 7F C8 FD 7E 0B E6 1E C8 3A DC ";
            S = S + "F2 B7 C0 18 01 E1 CD 48 43 30 C8 C9 3A FE F2 3C ";
            S = S + "20 06 3A B8 F2 32 FE F2 7E B7 20 EA 37 C9 3A B8 ";
            S = S + "F2 3C DD BE 0B 30 50 CD 5B F2 32 B8 F2 4F DD A6 ";
            S = S + "04 6F 26 00 29 29 29 29 29 ED 5B 51 F3 19 DD 46 ";
            S = S + "05 CB 39 10 FC 3A 45 F2 B9 20 07 3A 46 F2 DD BE ";
            S = S + "00 C8 E5 CD A4 46 E1 C9 CD 5E F2 3A B8 F2 3C DD ";
            S = S + "BE 0B 30 13 32 B8 F2 11 20 00 19 DD A6 04 C0 0C ";
            S = S + "CD A4 46 2A 51 F3 C9 CD 43 47 37 C9 CD 0E 44 D4 ";
            S = S + "B5 42 3E FF D8 C0 3E E5 32 3C F2 77 FD 6E 1A FD ";
            S = S + "66 1B 7C B5 C4 9B 4F CD BC 42 30 EA CD 03 44 C3 ";
            S = S + "CF 45 CD 0E 44 38 74 11 05 00 19 11 C5 F2 CD F4 ";
            S = S + "F1 D4 B5 42 38 65 20 63 21 B9 F2 11 D0 F2 01 0C ";
            S = S + "00 ED B0 21 C5 F2 11 B9 F2 06 0B 7E FE 3F 20 03 ";
            S = S + "FD 7E 00 12 23 13 FD 23 10 F1 3E 80 12 CD 5A 42 ";
            S = S + "30 36 3A B8 F2 F5 3E FF 32 B8 F2 CD BC 42 C1 30 ";
            S = S + "27 78 CD 17 43 EB 21 B9 F2 01 0B 00 ED B0 3E FF ";
            S = S + "32 3C F2 21 D0 F2 11 B9 F2 01 0C 00 ED B0 CD BC ";
            S = S + "42 30 B0 CD 43 47 AF C9 CD 43 47 3E FF C9 CD 61 ";
            S = S + "F2 AF 32 DC F2 EB 7E 23 32 C4 F2 E6 0F CD 27 44 ";
            S = S + "D8 11 B9 F2 C3 F4 F1 4F 3A 47 F3 B9 D8 79 3D F2 ";
            S = S + "35 44 3A 47 F2 32 E1 F2 C9 FD 7E 1F B7 20 1F FD ";
            S = S + "7E 1C FD 4E 1D FD 46 1E 87 CB 11 CB 10 38 0F B7 ";
            S = S + "28 05 03 78 B1 28 07 79 CB B9 87 CB 10 D0 01 7F ";
            S = S + "FF C9 CD A5 42 38 A4 CD 39 44 3A 0C F3 04 B8 30 ";
            S = S + "9A CD 64 F2 EB 01 0F 00 09 CD 39 44 3A 0C F3 B8 ";
            S = S + "28 06 0E 80 38 02 0E 00 71 23 EB 01 1C 00 09 0E ";
            S = S + "04 ED B0 01 F8 FF 09 ED A0 ED A0 0E FC 09 ED A0 ";
            S = S + "ED A0 FD 7E 0B CB 7F 20 05 DD 7E 00 F6 40 12 13 ";
            S = S + "3A B8 F2 12 13 FD 7E 1A 12 13 13 12 1B FD 7E 1B ";
            S = S + "12 13 13 12 13 AF 12 13 12 C9 4F 3A E1 F2 CD 0A ";
            S = S + "47 18 08 3E FF 32 B8 F2 32 FE F2 CD 67 F2 CD 53 ";
            S = S + "45 3A E1 F2 DD 4E 01 06 00 B7 CD 67 60 38 DB CD ";
            S = S + "33 45 DD 6E 13 DD 66 14 2B 78 B6 3A E1 F2 2A 41 ";
            S = S + "F2 FA 0A 45 C0 BD 20 0B 25 C8 95 20 06 6F 67 2D ";
            S = S + "22 41 F2 3E FF 32 46 F2 CD FA 45 2B 36 00 23 F5 ";
            S = S + "CD D7 46 38 19 F1 46 3A E1 F2 DD 4E 01 DD E5 E1 ";
            S = S + "CD 6F 60 E5 DD E1 EB CD 61 45 73 23 72 C9 7B 81 ";
            S = S + "5F 30 01 14 F1 41 3D 20 D6 CD FA 45 E5 CD C5 46 ";
            S = S + "E1 18 D3 CD 6A F2 CD 61 45 7E 23 66 6F E5 DD E1 ";
            S = S + "C9 3A E1 F2 21 55 F3 87 85 6F D0 24 C9 00 00 D5 ";
            S = S + "FD E1 CD 0E 44 3E FF D8 FD 7E 18 E6 C0 3E 00 C0 ";
            S = S + "3A E1 F2 2A 41 F2 BD CC 2D 47 CD 53 45 FD 7E 19 ";
            S = S + "CD 17 43 06 0B CD 4F 42 20 54 FD E5 D1 0E 0B 09 ";
            S = S + "EB 0E 16 09 ED A0 ED A0 01 FC FF 09 ED A0 ED A0 ";
            S = S + "01 04 00 09 ED A0 ED A0 01 F4 FF 09 01 04 00 ED ";
            S = S + "B0 CD 48 47 DD 6E 13 DD 66 14 2B 7E FE 01 C0 CD ";
            S = S + "6D F2 CD FA 45 2B 36 00 23 F5 D5 C5 E5 CD 55 47 ";
            S = S + "E1 C1 D1 7B 80 5F 30 01 14 F1 3D 20 EC C9 DD 6E ";
            S = S + "13 DD 66 14 2B 36 00 3E FF C9 DD 7E 0A DD 6E 13 ";
            S = S + "DD 66 14 DD 46 10 DD 5E 08 DD 56 09 C9 DD 86 11 ";
            S = S + "5F DD 56 12 30 01 14 2A 51 F3 06 01 C9 D5 CD 0E ";
            S = S + "44 38 2A 23 23 36 00 21 B9 F2 3E 3F 01 0B 00 ED ";
            S = S + "B1 28 1A CD B5 42 30 19 3A FE F2 FE FF 28 0E CD ";
            S = S + "17 43 E5 FD E1 18 22 FD CB 0B 7E 20 50 D1 3E FF ";
            S = S + "C9 20 F4 3A 0C F3 B7 20 44 FD 6E 1A FD 66 1B 7C ";
            S = S + "B5 28 06 CD 9B 4F CD CF 45 FD E5 D1 21 B9 F2 01 ";
            S = S + "0B 00 ED B0 7E 17 3E 00 30 02 3E 06 12 13 EB 06 ";
            S = S + "0A AF 77 23 10 FC E5 CD 96 54 E1 73 23 72 23 71 ";
            S = S + "23 70 23 AF 06 06 77 23 10 FC CD 48 47 FD E5 E1 ";
            S = S + "D1 C3 71 44 C5 CD 43 47 C1 DD 46 00 ED 43 45 F2 ";
            S = S + "C5 79 CD 0D 46 CD C5 46 C1 C9 44 7D 32 E1 F2 CD ";
            S = S + "53 45 2A 3D F2 CD 70 F2 AF 32 FF F2 CD D7 46 D0 ";
            S = S + "CD E8 46 3D 28 EF C9 DD 7E 00 DD 4E 01 E5 D5 C5 ";
            S = S + "CD 52 60 D1 4A D1 E1 C9 F5 79 90 4F C5 06 00 EB ";
            S = S + "09 E5 D5 DD 5E 02 DD 56 03 CD 16 49 E1 D1 09 C1 ";
            S = S + "F1 4F 3A FF F2 B1 4F DD 7E 00 CD 73 F2 C5 D5 E5 ";
            S = S + "2A 23 F3 CD E8 F1 79 E1 D1 C1 FE 02 C0 C3 E2 F1 ";
            S = S + "44 7D 32 E1 F2 CD 53 45 2A 3D F2 18 28 21 42 F2 ";
            S = S + "AF BE 77 C8 DD 2A 43 F2 2A 4F F3 06 01 ED 5B 3F ";
            S = S + "F2 18 12 3A 3C F2 B7 C8 CD 76 F2 AF 32 3C F2 3A ";
            S = S + "45 F2 CD 0D 46 CD 79 F2 3E 01 32 FF F2 DD 7E 00 ";
            S = S + "DD 4E 01 E5 D5 C5 CD 54 60 D1 4A D1 E1 D0 CD E8 ";
            S = S + "46 3D 28 E1 C9 CD F8 4E CD 23 4B 18 06 CD F8 4E ";
            S = S + "CD A3 4C CD 6A 48 18 14 CD 57 48 CD 23 4B 18 09 ";
            S = S + "FD E5 D1 CD 57 48 CD A3 4C CD 44 48 7D E6 7F FD ";
            S = S + "77 20 CB 25 CB 14 FD 74 0C CB 13 FD 73 0E 3A DE ";
            S = S + "F2 C9 AF 32 06 F3 CD 5A 48 CD 23 4B 18 0A AF 32 ";
            S = S + "06 F3 CD 5A 48 CD A3 4C CD 6A 48 CD 44 48 69 60 ";
            S = S + "C9 D5 FD E1 FD 7E 10 FD 4E 11 FD 46 12 FD 5E 13 ";
            S = S + "87 CB 11 CB 10 CB 13 B7 28 06 03 78 B1 20 01 1C ";
            S = S + "FD 6E 21 FD 66 22 ED 42 28 96 FD 7E 23 9B 38 90 ";
            S = S + "E5 CD 90 47 D1 B7 C0 2A 3D F2 E5 2A 51 F3 22 3D ";
            S = S + "F2 06 80 77 23 10 FC 3D 32 46 F2 FD 6E 21 FD 66 ";
            S = S + "22 ED 52 4D 44 EB 16 00 FD 7E 23 9A 5F E5 21 01 ";
            S = S + "00 CD A3 4C CD 6A 48 4D 44 E1 2B 7C B5 20 EE E1 ";
            S = S + "22 3D F2 C9 3A DE F2 FD 75 21 FD 74 22 FD 73 23 ";
            S = S + "14 15 C8 FD 72 24 C9 21 01 00 D5 FD E1 FD 4E 21 ";
            S = S + "FD 46 22 FD 5E 23 FD 56 24 C9 C8 23 7C B5 C0 13 ";
            S = S + "C9 E1 69 60 3E 01 32 DE F2 AF 4F 47 C9 22 E8 F2 ";
            S = S + "ED 43 E4 F2 ED 53 E6 F2 FD 7E 00 CD 27 44 38 E1 ";
            S = S + "11 80 00 3A 06 F3 B7 20 0F FD 7E 0E FD 56 0F 5F ";
            S = S + "B2 20 05 1E 80 FD 73 0E 14 15 20 05 7B FE 40 38 ";
            S = S + "04 AF 32 E7 F2 2A 3D F2 22 E2 F2 AF 32 DE F2 32 ";
            S = S + "DF F2 ED 4B E8 F2 CD 16 49 FD 7E 18 B7 F8 C5 CD ";
            S = S + "53 45 ED 4B E4 F2 CD 16 49 ED 43 F4 F2 C5 ED 4B ";
            S = S + "E6 F2 CD 1C 49 ED 43 F6 F2 60 69 C1 DD 5E 02 DD ";
            S = S + "56 03 CD 32 49 22 F2 F2 ED 43 EE F2 DD 7E 06 A1 ";
            S = S + "32 DD F2 DD 7E 07 3D 28 06 CB 38 CB 19 18 F7 ED ";
            S = S + "43 EC F2 C1 AF C9 CD 7C F2 21 00 00 78 06 11 18 ";
            S = S + "07 30 01 19 CB 1C CB 1D 1F CB 19 10 F4 47 C9 21 ";
            S = S + "00 00 CD 7F F2 78 06 10 CB 11 17 CB 15 CB 14 38 ";
            S = S + "0D ED 52 30 01 19 3F CB 11 17 10 EF 47 C9 B7 ED ";
            S = S + "52 18 F4 60 69 ED 4B F2 F2 78 B1 5F 57 28 13 DD ";
            S = S + "5E 02 DD 56 03 EB ED 42 EB ED 52 30 05 19 EB 21 ";
            S = S + "00 00 ED 53 F8 F2 4D 44 DD 5E 02 DD 56 03 CD 2F ";
            S = S + "49 22 FA F2 ED 43 FC F2 C9 CD 82 F2 FD 6E 1C FD ";
            S = S + "66 1D FD 5E 1E FD 56 1F 7D B4 28 33 C5 79 93 4F ";
            S = S + "78 9A 47 30 0B C1 11 00 00 FD 6E 1A FD 66 1B F5 ";
            S = S + "F1 CD 85 F2 78 B1 C8 D5 E5 CD F4 41 D1 7C FE 0F ";
            S = S + "38 05 7D FE F8 30 05 D1 13 0B 18 E5 EB D1 C9 03 ";
            S = S + "1B C9 32 E0 F2 2A EC F2 3A DD F2 CD DB 4E EB 2A ";
            S = S + "3F F2 ED 52 20 0A 3A E1 F2 6F 3A 41 F2 BD 28 2B ";
            S = S + "D5 DD E5 CD 2D 47 DD E1 D1 3A E0 F2 B7 20 0E 3D ";
            S = S + "32 41 F2 2A 4F F3 06 01 D5 CD C5 46 D1 ED 53 3F ";
            S = S + "F2 3A E1 F2 32 41 F2 DD 22 43 F2 3E 01 32 DF F2 ";
            S = S + "2A E2 F2 E5 ED 4B F8 F2 09 22 E2 F2 2A 4F F3 ED ";
            S = S + "5B F2 F2 19 D1 C9 CD 88 F2 2A F8 F2 7C B5 C8 AF ";
            S = S + "CD D2 49 C3 D9 F1 CD 8B F2 2A F8 F2 7C B5 C8 2A ";
            S = S + "EE F2 23 22 EE F2 AF EB 2A F0 F2 ED 52 1F CD D2 ";
            S = S + "49 EB CD D9 F1 3E 01 32 42 F2 C9 21 00 00 22 F2 ";
            S = S + "F2 2A FA F2 22 F8 F2 7C B5 37 C8 3A DF F2 B7 C8 ";
            S = S + "3A DD F2 DD BE 06 38 1A ED 5B EC F2 21 F7 0F ED ";
            S = S + "52 D8 EB CD F4 41 22 EC F2 2A EA F2 23 22 EA F2 ";
            S = S + "3E FF 3C 32 DD F2 B7 C9 7E ED A0 FE 0D 20 02 36 ";
            S = S + "0A FE 0A 28 15 78 B1 20 EF 22 00 F3 ED 53 E2 F2 ";
            S = S + "C2 E2 4B FD CB 18 B6 C3 E2 4B CD A8 53 21 00 00 ";
            S = S + "79 B0 20 25 3C 18 E2 ED 5B E2 F2 3C 28 14 3C 20 ";
            S = S + "DB CD 6E 54 12 13 FE 1A 28 D2 0B 78 B1 20 F2 3C ";
            S = S + "18 CA 2A 00 F3 7C B5 20 AF 21 7F 00 3A D9 F4 BD ";
            S = S + "28 03 22 D9 F4 C5 D5 11 D9 F4 CD E0 50 D1 C1 21 ";
            S = S + "DB F4 7E FE 1A 20 91 12 13 3E 0A CD A8 53 AF 67 ";
            S = S + "6F 18 96 CD 7D 48 FA D7 4A FD 6E 10 FD 66 11 ED ";
            S = S + "5B F4 F2 B7 ED 52 E5 FD 6E 12 FD 66 13 ED 5B F6 ";
            S = S + "F2 ED 52 E1 DA 97 4C 20 0D 7C B5 CA 97 4C E5 ED ";
            S = S + "42 E1 30 02 44 4D CD 8E F2 CD 53 49 ED 4B EC F2 ";
            S = S + "CD 89 49 78 B1 C2 97 4C 22 EC F2 ED 53 EA F2 CD ";
            S = S + "36 4A 2A FC F2 7C B5 CA DC 4B CD 7B 4A 38 63 3E ";
            S = S + "01 32 DF F2 3A DD F2 ED 4B FC F2 2A EC F2 C5 CD ";
            S = S + "48 4E C5 F5 47 CD C5 46 F1 4F 06 00 38 23 3A 42 ";
            S = S + "F2 B7 28 1D C5 DD 4E 02 DD 46 03 C5 E5 2A 3F F2 ";
            S = S + "ED 52 EB CD 16 49 E1 09 C1 EB 2A 4F F3 CD D9 F1 ";
            S = S + "C1 D1 E1 B7 ED 42 28 14 4D 44 21 F7 0F ED 52 38 ";
            S = S + "11 2A EA F2 23 22 EA F2 AF EB 18 B2 CD 6B 4A D4 ";
            S = S + "36 4A CD 91 F2 2A E2 F2 ED 5B 3D F2 B7 ED 52 4D ";
            S = S + "44 11 80 00 3A 06 F3 B7 20 06 FD 5E 0E FD 56 0F ";
            S = S + "CD 2F 49 7C B5 28 10 03 EB ED 52 ED 5B E2 F2 AF ";
            S = S + "12 13 2B 7C B5 20 F8 2A E8 F2 ED 42 28 04 3C 32 ";
            S = S + "DE F2 CD 94 F2 2A EC F2 FD 75 1C FD 74 1D 2A EA ";
            S = S + "F2 FD 75 1E FD 74 1F 2A E4 F2 ED 5B E6 F2 78 B1 ";
            S = S + "C8 0B 09 03 D0 13 C9 2A 3D F2 F6 40 3C 28 24 3C ";
            S = S + "28 11 3C 28 2C 7E 23 FE 1A 28 26 CD 66 54 0B 78 ";
            S = S + "B1 18 F0 7E 23 CD 75 54 FE 1A 28 15 0B 78 B1 20 ";
            S = S + "F2 18 0E 7E 23 FE 1A 28 08 CD A8 53 0B 78 B1 20 ";
            S = S + "F2 ED 4B E8 F2 18 B0 4B 42 CD B1 49 78 B1 CA 41 ";
            S = S + "4D CD 12 4F D2 41 4D CD 97 F2 AF 4F 47 3C 32 DE ";
            S = S + "F2 18 94 CD 7D 48 F5 C5 CD 96 54 FD 71 14 FD 70 ";
            S = S + "15 FD 73 16 FD 72 17 C1 F1 FA 47 4C FD CB 18 B6 ";
            S = S + "C5 CD 53 49 C1 2A F4 F2 ED 5B F6 F2 78 B1 CA DD ";
            S = S + "4D 0B 09 30 01 13 44 4D EB DD 5E 02 DD 56 03 CD ";
            S = S + "32 49 60 69 DD 46 07 05 28 06 CB 3C CB 1D 10 FA ";
            S = S + "E5 FD 4E 10 FD 46 11 FD 6E 12 FD 66 13 CD 32 49 ";
            S = S + "7C B5 28 01 03 CD 9A F2 ED 43 F0 F2 ED 4B EC F2 ";
            S = S + "CD 89 49 22 EC F2 ED 53 EA F2 E3 B7 ED 52 EB E1 ";
            S = S + "28 1F 78 B1 CA 87 4C C5 4B 42 CD 12 4F C1 DA 97 ";
            S = S + "4C ED 5B EA F2 13 0B CD B1 49 22 EC F2 ED 53 EA ";
            S = S + "F2 CD 46 4A 2A FC F2 7C B5 28 41 ED 5B EE F2 19 ";
            S = S + "22 EE F2 CD 7B 4A 3E 01 32 DF F2 3A DD F2 2A EC ";
            S = S + "F2 ED 4B FC F2 C5 CD 48 4E C5 F5 47 38 05 3E FF ";
            S = S + "32 41 F2 CD 55 47 F1 D1 E1 4F AF 47 ED 42 28 0C ";
            S = S + "4D 44 2A EA F2 23 22 EA F2 EB 18 D9 CD 9D F2 CD ";
            S = S + "6B 4A D4 46 4A 2A E2 F2 ED 5B 3D F2 B7 ED 52 ED ";
            S = S + "5B F4 F2 19 ED 5B F6 F2 30 01 13 22 F4 F2 ED 53 ";
            S = S + "F6 F2 FD 4E 10 FD 46 11 B7 ED 42 FD 4E 12 FD 46 ";
            S = S + "13 EB ED 42 38 10 FD E5 E1 11 10 00 19 EB 21 F4 ";
            S = S + "F2 01 04 00 ED B0 ED 4B E8 F2 C3 22 4C 7C B5 B2 ";
            S = S + "B3 28 4F 01 01 00 ED 42 EB 0B ED 42 42 4B DD 5E ";
            S = S + "02 DD 56 03 CD 32 49 DD 7E 07 3D 28 06 CB 38 CB ";
            S = S + "19 18 F7 CD 89 49 78 B1 28 1C CD 12 4F DA 97 4C ";
            S = S + "01 00 00 ED 43 E8 F2 ED 43 EA F2 FD 6E 1A FD 66 ";
            S = S + "1B 22 EC F2 18 A0 01 FF 0F CD 9E 4F 1B 3E 01 12 ";
            S = S + "18 DE FD 6E 1A FD 66 1B 7C B5 28 D4 AF FD 77 1A ";
            S = S + "FD 77 1B CD 9B 4F 18 E4 CD A0 F2 57 E5 04 05 28 ";
            S = S + "02 0E FF 59 D5 DD 7E 06 32 DD F2 3C 92 47 22 EC ";
            S = S + "F2 E5 CD F4 41 D1 79 90 4F 28 0D DD 46 06 38 5A ";
            S = S + "04 13 EB ED 52 EB 28 E6 D1 E3 E5 D5 7B 91 5F 16 ";
            S = S + "00 DD 4E 02 DD 46 03 CD 16 49 F1 2A E2 F2 E5 09 ";
            S = S + "22 E2 F2 C1 E1 C5 D5 EB 2A EC F2 ED 52 ED 4B EA ";
            S = S + "F2 09 22 EA F2 EB CD DB 4E EB C1 3A 41 F2 DD BE ";
            S = S + "00 79 37 20 12 2A 3F F2 B7 ED 52 38 0A 60 69 19 ";
            S = S + "2B ED 4B 3F F2 ED 42 E1 C1 C9 80 32 DD F2 0E 00 ";
            S = S + "18 A6 CD FA 41 7D 29 29 E6 3F C9 CD A3 F2 C5 DD ";
            S = S + "46 07 2B 2B 05 28 06 CB 25 CB 14 10 FA B5 6F DD ";
            S = S + "4E 0C DD 46 0D 09 C1 C9 D5 FD E1 FD 4E 20 FD 46 ";
            S = S + "0C FD 5E 0E 16 00 CB 21 CB 3B CB 18 CB 19 21 01 ";
            S = S + "00 C9 CD A6 F2 DD 5E 13 DD 56 14 EB 7E 23 66 6F ";
            S = S + "E5 EB DD 5E 0E DD 56 0F ED 53 02 F3 E5 C5 E5 54 ";
            S = S + "5D D5 EB 2A 02 F3 2B B7 ED 52 EB D1 30 10 7B B2 ";
            S = S + "20 14 E1 E1 E1 01 FF 0F CD 9E 4F 37 18 46 23 CD ";
            S = S + "5E 4F 7B B2 28 DB 1B EB CD 5E 4F EB 18 D3 E5 D5 ";
            S = S + "CD F4 41 D1 E1 C0 C1 4D 44 E3 DD 5E 13 DD 56 14 ";
            S = S + "CD 21 42 E1 C1 0B 78 B1 20 B3 01 FF 0F CD 21 42 ";
            S = S + "1B 3E 01 12 E1 E5 CD F4 41 C1 79 B0 20 06 FD 75 ";
            S = S + "1A FD 74 1B EB C1 71 23 70 EB C9 01 00 00 CD A9 ";
            S = S + "F2 E5 CD F4 41 E3 CD 21 42 E1 7C B5 C8 7C FE 0F ";
            S = S + "38 E9 7D FE F8 38 E4 C9 CD A5 42 38 43 3A B8 F2 ";
            S = S + "28 02 3E FF 32 0B F3 DD 22 09 F3 ED 5B 3D F2 3A ";
            S = S + "E1 F2 3C 12 13 7E FE 05 20 02 36 E5 01 20 00 CD ";
            S = S + "D9 F1 CD 39 44 3A 0C F3 B8 28 04 30 13 0E 80 2A ";
            S = S + "3D F2 11 0C 00 19 46 77 23 70 23 72 23 71 AF C9 ";
            S = S + "3E FF 32 0B F3 C9 CD 0E 44 38 F5 3A 0B F3 FE FF ";
            S = S + "28 EE 32 B8 F2 DD 2A 09 F3 CD BC 42 18 9D CD A5 ";
            S = S + "42 3E FF D8 D5 DD E1 FD 7E 1C FD 4E 1D FD 46 1E ";
            S = S + "FD 5E 1F 87 CB 11 CB 10 CB 13 B7 28 06 03 78 B1 ";
            S = S + "20 01 1C DD 71 21 DD 70 22 DD 73 23 AF C9 3A 47 ";
            S = S + "F3 47 AF 37 17 10 FC C9 ED 53 3D F2 C9 AF 32 06 ";
            S = S + "F3 7B CD 27 44 3E FF D8 CD DB 44 DD 5E 13 DD 56 ";
            S = S + "14 D5 FD E1 21 02 00 44 4C DD 5E 0E DD 56 0F 1B ";
            S = S + "D5 D5 E5 CD F4 41 E1 D1 20 01 03 23 1B 7B B2 20 ";
            S = S + "F0 60 69 D1 DD 7E 06 3C DD 4E 02 DD 46 03 C9 21 ";
            S = S + "80 00 22 3D F2 AF 32 47 F2 CD 2D 47 21 55 F3 3A ";
            S = S + "47 F3 5E 23 56 23 E5 F5 D5 DD E1 CD C4 45 F1 E1 ";
            S = S + "3D 20 EF C9 3A 47 F2 C9 CD F8 4E FD 75 21 FD 74 ";
            S = S + "22 FD 73 23 C9 3A 47 F3 BB D8 C8 21 47 F2 73 C9 ";
            S = S + "D5 3A 37 F2 32 38 F2 AF 32 39 F2 62 6B 47 4E 23 ";
            S = S + "57 5E 23 DD 21 59 F4 7B B9 30 06 E5 19 7E E1 FE ";
            S = S + "0D 28 01 5A CD AC F2 CD 4E 54 E5 C5 21 74 53 01 ";
            S = S + "11 00 ED B1 09 09 09 4E 23 66 69 C1 E3 C9 CD 4E ";
            S = S + "54 FE 40 38 E5 FE 60 30 E1 F5 78 3C B9 30 2F 3E ";
            S = S + "01 DD 77 00 DD 23 04 CD 5D 53 F1 F5 78 B9 30 1E ";
            S = S + "F1 DD 77 00 DD 23 04 CD 5D 53 3A 39 F2 B7 20 B4 ";
            S = S + "14 7B BA 38 AF 7E 3D 23 20 AA 14 23 18 A6 F1 3E ";
            S = S + "07 CD A8 53 18 9E D1 3A 38 F2 47 3A 37 F2 90 28 ";
            S = S + "06 47 CD 4F 53 10 FB C3 E0 50 78 32 3A F2 CD 83 ";
            S = S + "51 18 81 3E 0D CD A8 53 3E 0A C3 A8 53 D1 CD A8 ";
            S = S + "53 D5 13 78 12 B9 F5 13 48 AF 47 B1 28 05 21 59 ";
            S = S + "F4 ED B0 F1 28 03 3E 0D 12 D1 C9 3A 3A F2 A0 FE ";
            S = S + "7F CA 44 52 04 05 28 24 05 DD 2B CD 4F 53 04 05 ";
            S = S + "28 0C 05 DD 2B DD 7E 00 3D 28 11 04 DD 23 DD 7E ";
            S = S + "00 FE 20 30 07 FE 09 28 22 CD 4F 53 3A 39 F2 B7 ";
            S = S + "20 9F 14 15 28 9B 15 7A BB 30 96 2B 7A FE 01 38 ";
            S = S + "90 2B 7E 3D 23 20 8A 15 2B 18 86 E5 C5 3A 38 F2 ";
            S = S + "4F 04 05 28 15 21 59 F4 7E 23 FE 01 28 0A 0C FE ";
            S = S + "20 30 05 FE 09 28 13 0C 10 EE 3A 37 F2 91 28 06 ";
            S = S + "47 CD 4F 53 10 FB C1 E1 18 B2 79 C6 07 E6 F8 4F ";
            S = S + "18 E6 3A 39 F2 EE 01 18 05 AF 18 02 3E 01 32 39 ";
            S = S + "F2 C3 04 51 AF 32 3A F2 C5 06 10 11 7D 54 21 00 ";
            S = S + "00 E5 CD D2 4E C6 20 CD A8 53 7C C6 20 CD A8 53 ";
            S = S + "E1 23 10 ED C1 3E 40 D1 CD 8E 51 CD 83 51 3A 38 ";
            S = S + "F2 B7 CA E0 50 47 3E 20 CD A8 53 10 FB C3 E0 50 ";
            S = S + "3E FF 18 31 CD E3 52 DA 04 51 C5 4F 06 00 09 C1 ";
            S = S + "82 57 C3 04 51 CD E3 52 DA 04 51 18 18 7A BB D2 ";
            S = S + "04 51 14 7E 3D 23 C2 04 51 14 23 C3 04 51 7E 3D ";
            S = S + "3E 01 20 01 3C F5 AF 32 39 F2 78 B9 30 21 7A BB ";
            S = S + "30 1D 7E FE 01 20 06 78 3C B9 30 13 7E 23 DD 77 ";
            S = S + "00 DD 23 CD 5D 53 04 14 F1 3D 20 D9 C3 04 51 F1 ";
            S = S + "C3 04 51 CD 4E 54 FE 01 20 35 CD 4E 54 FE 40 38 ";
            S = S + "2E FE 60 30 2A E5 D5 C5 FD 21 00 00 37 F5 3E 01 ";
            S = S + "CD 1F 53 38 15 4F 06 00 09 82 57 FD E5 F1 81 F5 ";
            S = S + "FD E1 23 F1 BE 2B 20 E4 FD E5 F1 C1 D1 E1 C9 C5 ";
            S = S + "F5 7B 92 38 26 28 24 3D 28 21 4F 06 00 F1 E5 F5 ";
            S = S + "7E 3D 20 02 23 0D F1 0C 0D 20 04 E1 C1 37 C9 23 ";
            S = S + "ED B1 E1 20 07 7B 92 3D 91 C1 C9 F1 C1 37 C9 3E ";
            S = S + "08 CD A8 53 3E 20 CD A8 53 3E 08 18 4B FE 20 30 ";
            S = S + "47 FE 09 28 43 FE 01 28 3F F5 3E 5E CD A8 53 F1 ";
            S = S + "F6 40 18 34 06 7F 08 0D 0A 15 0B 0C 1B 12 18 1C ";
            S = S + "1D 1E 1F 01 08 3B 51 1E 51 80 52 66 51 AB 51 AE ";
            S = S + "52 95 52 32 52 66 51 84 52 65 52 66 51 7A 51 8D ";
            S = S + "51 AB 51 9D 52 04 51 7B CD AF F2 FE 0B 28 39 FE ";
            S = S + "0C 28 35 FE 1C 28 1E FE 1D 28 35 FE 0D 28 29 FE ";
            S = S + "08 28 2D FE 09 28 31 FE 7F 28 25 FE 20 38 06 E5 ";
            S = S + "21 37 F2 34 E1 C5 47 CD 12 54 78 CD 8F 40 3A 3B ";
            S = S + "F2 B7 78 C1 C8 C3 9B 40 F5 AF 32 37 F2 F1 18 E5 ";
            S = S + "E5 21 37 F2 35 E1 18 DD 3E 20 CD A8 53 3A 37 F2 ";
            S = S + "E6 07 20 F4 C9 FE 10 28 14 FE 0E 28 10 FE 03 28 ";
            S = S + "0C C9 CD 34 40 C8 FE 13 20 EB CD 78 40 CD 78 40 ";
            S = S + "FE 10 28 0D FE 0E 28 0F FE 03 C0 2A 25 F3 C3 E8 ";
            S = S + "F1 3E 01 32 3B F2 C9 AF 32 3B F2 C9 CD 12 54 3E ";
            S = S + "00 C8 F6 FF C9 CD 4E 54 F5 CD A8 53 F1 C9 CD 1D ";
            S = S + "54 28 FB C9 7B FE FF C2 8F 40 CD 34 40 C2 78 40 ";
            S = S + "AF C9 C3 78 40 7B F5 CD 12 54 F1 C3 9B 40 CD 12 ";
            S = S + "54 C3 71 F3 7B F5 CD 12 54 F1 C3 74 F3 ED 8C 93 ";
            S = S + "EF 0C 88 39 40 03 70 48 97 F2 FC BA 80 0A CC B5 ";
            S = S + "5E AF 29 00 00 C9 CD B2 F2 CD C0 54 79 87 87 87 ";
            S = S + "CB 10 87 CB 10 87 CB 10 CB 3A B2 5F 50 ED 4B 49 ";
            S = S + "F2 79 87 87 87 87 87 CB 10 4F 3A 48 F2 B1 4F C9 ";
            S = S + "CD 79 41 38 46 D5 E5 ED 5B 4C F2 B7 ED 52 E1 D1 ";
            S = S + "C8 22 4C F2 C5 D5 4D 44 11 B5 05 CD 2F 49 79 87 ";
            S = S + "87 87 06 00 11 34 55 CD 15 55 CB 3F 30 04 11 C8 ";
            S = S + "00 19 CD 23 55 3E 01 11 2B F2 CD 15 55 32 49 F2 ";
            S = S + "2C 7D 32 48 F2 CD 88 55 D1 C1 C9 C5 D5 2A 4A F2 ";
            S = S + "CD 9D 55 18 F0 EB 4E 23 EB B7 ED 42 38 03 3C 18 ";
            S = S + "F4 09 C9 CD B5 F2 32 4A F2 E6 03 3E 1C 20 01 3C ";
            S = S + "32 2C F2 C9 C8 A6 C8 A5 C8 A5 C8 A5 AF 32 06 F3 ";
            S = S + "CD C0 54 2A 4A F2 11 BC 07 19 ED 5B 48 F2 3A 4E ";
            S = S + "F2 C9 01 44 F8 09 30 42 7C B7 20 3E 7D FE 78 30 ";
            S = S + "39 CD 29 55 1C 1D 28 32 7A B7 28 2E FE 0D 30 2A ";
            S = S + "E5 21 2A F2 85 6F 30 01 24 7E E1 BB 38 1C ED 53 ";
            S = S + "48 F2 CD 9D 55 CD 15 41 ED 4B 4C F2 11 07 00 03 ";
            S = S + "03 CD 2F 49 7D 32 4E F2 AF C9 3E FF C9 7D CD 23 ";
            S = S + "55 4D CB 39 CB 39 06 00 11 B5 05 CD 16 49 69 60 ";
            S = S + "3A 4A F2 E6 03 87 11 34 55 06 00 3C CD D2 55 11 ";
            S = S + "2B F2 3A 49 F2 CD D2 55 3A 48 F2 3D 4F 09 22 4C ";
            S = S + "F2 C9 3D C8 EB 4E 23 EB 09 18 F7 AF 32 06 F3 CD ";
            S = S + "C0 54 60 69 AF C9 44 4D 78 FE 18 30 AD 3E 3B B9 ";
            S = S + "38 A8 BA 38 A5 7B FE 64 30 A0 CD 30 41 AF C9 7B ";
            S = S + "32 0D F3 C9 7E FE 20 37 C8 01 02 08 FE E5 20 12 ";
            S = S + "3E 05 12 23 13 05 3E E5 CD 81 56 30 05 7E 12 23 ";
            S = S + "13 05 7E CD 81 56 30 09 12 23 13 05 37 C8 7E 18 ";
            S = S + "36 3A 0E F3 A7 7E 28 14 FE 80 38 10 FE BA 30 0C ";
            S = S + "E5 C5 4F 06 00 21 16 56 09 7E C1 E1 FE 61 38 06 ";
            S = S + "FE 7B 30 02 D6 20 FE 20 D8 E5 C5 21 77 56 01 0A ";
            S = S + "00 ED B1 C1 E1 37 C8 12 23 13 10 B6 06 03 0D 20 ";
            S = S + "B1 B7 7E 32 0C F3 C9 2E 22 2F 5B 5D 3A 2B 3D 3B ";
            S = S + "2C E5 21 0F F3 BE 3F 30 0B 23 BE 38 07 23 BE 3F ";
            S = S + "30 02 23 BE E1 C9 80 9A 45 41 8E 41 8F 80 45 45 ";
            S = S + "45 49 49 49 8E 8F 90 92 92 4F 99 4F 55 55 59 99 ";
            S = S + "9A 9B 9C 9D 9E 9F 41 49 4F 55 A5 A5 A6 A7 A8 A9 ";
            S = S + "AA AB AC AD AE AF B0 B0 B2 B2 B4 B4 B6 B6 B8 B8 ";
            S = S + "AF 47 C9 FB 3E 01 32 06 F3 79 FE 31 30 F2 D6 11 ";
            S = S + "20 04 ED 53 07 F3 3D 20 04 ED 5B 07 F3 E5 21 00 ";
            S = S + "57 E3 E5 21 0D 57 06 00 09 09 46 23 66 68 E3 C9 ";
            S = S + "F5 3A 06 F3 B7 28 04 F1 6F 60 C9 F1 C9 A7 40 45 ";
            S = S + "54 A7 53 6E 54 74 54 65 54 54 54 62 54 4E 54 C9 ";
            S = S + "F1 E0 50 3C 54 EF 41 9F 50 D5 50 62 44 6F 45 B8 ";
            S = S + "4F 06 50 6C 43 75 47 7D 47 1D 46 92 43 4E 50 C4 ";
            S = S + "50 58 50 5D 50 D0 56 D0 56 D0 56 D0 56 D0 56 88 ";
            S = S + "47 93 47 1E 50 C8 50 D0 56 BE 47 B2 47 D1 47 D0 ";
            S = S + "56 3C 55 52 55 DB 55 E6 55 FF 55 BA 46 20 47 CD ";
            S = S + "86 77 F3 3A 99 FD A7 F8 C2 0C 58 21 20 FB CB 46 ";
            S = S + "20 0C CB C6 21 CA FF 06 0F 36 C9 23 10 FB 2A 48 ";
            S = S + "FC 11 01 C0 E7 30 0C 3E 06 CD 41 01 F3 0F 38 09 ";
            S = S + "3E 07 DF 3E FF 32 99 FD C9 21 88 F3 11 C9 F1 A7 ";
            S = S + "ED 52 D4 E8 5E D8 E5 21 49 FE 01 C9 F1 AF 02 03 ";
            S = S + "23 7D B4 20 F8 22 AB F6 06 14 21 21 FB 77 23 10 ";
            S = S + "FC 21 4F F2 06 69 36 C9 23 10 FB 3E DB 21 A8 C9 ";
            S = S + "32 65 F3 22 66 F3 3E 06 CD 41 01 E6 02 32 3F F3 ";
            S = S + "3E 07 DF 21 07 58 11 CB FE 01 05 00 ED B0 CD 2D ";
            S = S + "40 32 CC FE D1 18 1E F7 00 97 58 C9 21 21 FB 06 ";
            S = S + "04 AF 86 DA CC 5E 23 23 10 F8 FE 08 D0 21 08 00 ";
            S = S + "CD E8 5E D8 EB CD CD 5F 73 23 72 2A AB F6 11 00 ";
            S = S + "02 E7 30 04 ED 53 AB F6 11 21 FB 01 00 04 1A A7 ";
            S = S + "28 09 81 4F 13 13 10 F6 C3 CC 5E 3A 3F F3 A7 79 ";
            S = S + "CD B6 77 85 FE 09 7D 38 03 3E 08 91 C5 12 13 CD ";
            S = S + "2D 40 12 C1 06 00 21 55 F3 09 09 E5 1B 1A F5 4F ";
            S = S + "11 15 00 CD 16 49 69 60 CD C8 5E EB F1 E1 73 23 ";
            S = S + "72 23 E5 21 16 74 01 15 00 ED B0 E1 3D 20 EF CD ";
            S = S + "D8 77 21 99 FD 34 C9 21 CB FE 06 05 36 C9 23 10 ";
            S = S + "FB 21 99 FD AF BE 77 F0 CD 2D 62 32 48 F3 21 97 ";
            S = S + "73 11 C9 F1 01 6E 00 ED B0 21 34 00 11 0F F3 01 ";
            S = S + "04 00 ED B0 3A 2B 00 0F 0F 0F 0F E6 07 32 0E F3 ";
            S = S + "3E FF 32 41 F2 32 46 F2 32 4D F2 3E 0D 32 5B F5 ";
            S = S + "3E 07 32 45 F3 21 B5 05 22 3B F3 06 08 21 68 F3 ";
            S = S + "36 C3 23 23 23 10 F9 2A AB F6 E5 CD C8 5E 22 4D ";
            S = S + "F3 E1 E5 CD C8 5E 22 4F F3 E1 CD C8 5E 22 51 F3 ";
            S = S + "21 21 FB 06 04 AF 86 DA CC 5E 23 23 10 F8 FE 09 ";
            S = S + "D2 CC 5E 32 47 F3 47 0E 00 21 55 F3 5E 23 56 23 ";
            S = S + "E5 D5 DD E1 DD 71 00 0C C5 DD 4E 02 DD 46 03 DD ";
            S = S + "5E 10 16 00 CD 16 49 03 69 60 CD C8 5E 22 49 F3 ";
            S = S + "36 FF 23 DD 75 13 DD 74 14 C1 E1 10 CF 21 27 F3 ";
            S = S + "36 3E 23 36 1A 06 08 23 36 C9 10 FB 21 27 F3 22 ";
            S = S + "72 F3 21 2C F3 22 75 F3 21 31 F3 22 7E F3 21 2F ";
            S = S + "7D 3A C1 FC CD 0C 00 F5 23 3A C1 FC CD 0C 00 D1 ";
            S = S + "67 6A E5 DD E1 FD 2A C0 FC CD 1C 00 CD B8 40 CD ";
            S = S + "6E 5C 3A C1 FC 32 41 F3 32 42 F3 CD 98 5F 32 43 ";
            S = S + "F3 CD 95 5F 32 44 F3 0E 00 CD 52 5E 38 03 32 41 ";
            S = S + "F3 0E 40 CD 52 5E 38 03 32 42 F3 31 00 C2 3A DA ";
            S = S + "FE FE C9 28 06 DD 21 17 7D 18 12 21 C9 FC 06 40 ";
            S = S + "7E 87 38 05 23 10 F9 18 0A DD 21 14 7E CD 16 5C ";
            S = S + "C3 59 01 21 3A 5B E5 CD E7 5A D8 CD DB 5A 2A 48 ";
            S = S + "FC 11 00 80 E7 C0 21 41 F3 3A C1 FC BE C8 23 BE ";
            S = S + "C8 AF CD 9A 60 2A 49 F3 22 4B F3 CD E7 5A DA 3A ";
            S = S + "5B 32 46 F3 3A 41 F3 26 00 CD C2 64 37 F4 A2 64 ";
            S = S + "DC AF 64 AF 6F 67 77 2C 20 FC 01 26 00 CD AD 5E ";
            S = S + "22 6F F3 EB 21 7B 63 ED B0 01 19 00 CD AD 5E 5D ";
            S = S + "54 22 69 F3 23 23 22 6C F3 21 A1 63 ED B0 01 68 ";
            S = S + "01 CD AD 5E E5 EB 21 F4 63 E5 ED B0 C1 D1 D5 21 ";
            S = S + "17 01 19 36 3B 23 36 00 21 BA 63 CD 06 63 21 0F ";
            S = S + "5B AF 47 57 5E BB 28 10 23 4E 23 E3 09 EB 36 C3 ";
            S = S + "23 73 23 72 EB E3 18 EC E1 21 5C 65 11 3B 00 01 ";
            S = S + "1A 00 ED B0 01 45 00 CD AD 5E E5 EB 21 36 63 E5 ";
            S = S + "ED B0 C1 D1 D5 21 2E 63 CD 06 63 E1 3E C3 32 38 ";
            S = S + "00 22 39 00 11 22 00 19 ED 5B 4B F3 73 23 72 01 ";
            S = S + "A0 00 CD AD 5E 3E C3 CD 62 5C 37 21 23 F3 11 68 ";
            S = S + "F3 3A 40 F3 C3 1E C0 3A 17 74 4F 06 01 2A 51 F3 ";
            S = S + "E5 AF 5F 57 CD 44 01 3E FF 32 46 F2 E1 D8 7E 11 ";
            S = S + "00 C0 01 00 01 ED B0 FE EB C8 FE E9 C8 37 C9 0C ";
            S = S + "00 14 21 30 2E 1C 12 24 47 00 00 41 55 54 4F 45 ";
            S = S + "58 45 43 42 41 53 00 52 55 4E 22 41 55 54 4F 45 ";
            S = S + "58 45 43 2E 42 41 53 00 92 5B CD 60 5C 21 27 5B ";
            S = S + "11 68 F5 01 11 00 ED B0 21 40 F3 7E A7 74 20 1E ";
            S = S + "32 46 F3 21 38 5B 22 23 F3 21 1A 5B 11 79 F5 01 ";
            S = S + "25 00 D5 ED B0 D1 CD 62 44 3C 28 26 18 32 3A 00 ";
            S = S + "00 FE C3 20 27 21 80 00 46 04 05 28 1F 23 7E FE ";
            S = S + "20 20 04 10 F8 18 15 AF 48 47 11 6C F5 ED B0 12 ";
            S = S + "18 0E 31 00 C2 3A 38 F3 A7 CC 3F 5D AF 32 6B F5 ";
            S = S + "31 00 C2 3A 43 F3 26 80 CD 24 00 3A C1 FC 26 00 ";
            S = S + "CD 24 00 2A 48 FC AF 77 23 22 76 F6 77 23 77 23 ";
            S = S + "22 C2 F6 21 FF FF 22 1C F4 CD 16 5C ED 7B 74 F6 ";
            S = S + "3E FF 32 DE F3 3E 0C DF DD 21 31 7D CD 59 01 CD ";
            S = S + "86 5F 0D 0A 44 69 73 6B 20 42 41 53 49 43 20 76 ";
            S = S + "65 72 73 69 6F 6E 20 31 2E 30 0D 0A 00 21 73 41 ";
            S = S + "E5 21 67 F5 E5 21 9E F5 E5 36 E1 23 36 C9 3A C1 ";
            S = S + "FC 26 40 C3 24 00 21 AE 72 22 23 F3 21 6C 5C 22 ";
            S = S + "25 F3 2A 49 F3 22 4A FC 3A 45 F3 4F 06 00 11 25 ";
            S = S + "00 CD 16 49 CD B8 5E 22 53 F3 01 19 00 CD B8 5E ";
            S = S + "22 78 F3 EB 21 ED 62 ED B0 21 F5 FF 19 22 7B F3 ";
            S = S + "3A 48 F3 11 F9 FF 19 77 11 0E 00 19 77 CD 5F 5F ";
            S = S + "3E C9 32 68 F3 32 6B F3 32 6E F3 C9 A7 40 21 E8 ";
            S = S + "62 11 BC FE 01 05 00 ED B0 21 96 5C 5E 23 56 23 ";
            S = S + "7B B2 C8 EB 36 F7 23 3A 48 F3 77 23 EB ED A0 ED ";
            S = S + "A0 3E C9 12 18 E6 EF FD 96 6B 17 FE 75 6B F9 FD ";
            S = S + "20 6F FE FD 00 6F 08 FE 7B 70 12 FE 61 70 21 FE ";
            S = S + "D7 6C 26 FE D6 6C 2B FE 49 6C 30 FE AF 6D 35 FE ";
            S = S + "B2 6D 3A FE B5 6D 3F FE D7 6D 44 FE DA 6D 49 FE ";
            S = S + "DD 6D 4E FE A4 66 58 FE B3 66 5D FE FC 66 62 FE ";
            S = S + "D0 68 71 FE 0E 69 76 FE 39 69 7B FE 88 6E 80 FE ";
            S = S + "DA 6B 85 FE 8E 68 8A FE 19 68 99 FE 0D 70 9E FE ";
            S = S + "09 70 A3 FE 70 6E AD FE 75 68 B2 FE 23 73 B7 FE ";
            S = S + "7C 73 FD FE D3 71 A7 FF 55 60 AC FF B0 60 31 F3 ";
            S = S + "D3 56 00 00 01 48 2D 01 41 2D 01 47 29 3A 00 4D ";
            S = S + "2D 44 2D 59 29 3A 00 44 2D 4D 2D 59 29 3A 00 ED ";
            S = S + "73 C0 F5 3E 14 32 C2 F5 CD 86 5F 0D 0A 45 6E 74 ";
            S = S + "65 72 20 64 61 74 65 20 28 00 00 00 00 00 00 3A ";
            S = S + "0E F3 FE 01 21 24 5D 38 08 21 2F 5D 28 03 21 37 ";
            S = S + "5D CD 8C 5F 21 4B 5E 22 25 F3 11 C2 F5 CD E0 50 ";
            S = S + "21 C4 F5 7E FE 0D C8 3A 0E F3 A7 20 12 CD 0D 5E ";
            S = S + "CD E9 5D 51 7E 23 B8 20 32 CD F8 5D 59 18 1A CD ";
            S = S + "F8 5D 51 CD E9 5D 59 7E 23 B8 20 05 CD 0D 5E 18 ";
            S = S + "08 D5 CD 3C 55 E5 DD E1 D1 3A 0E F3 FE 02 38 03 ";
            S = S + "7B 5A 57 DD E5 E1 CD 52 55 B7 C8 ED 7B C0 F5 CD ";
            S = S + "86 5F 0D 0A 49 6E 76 61 6C 69 64 20 64 61 74 65 ";
            S = S + "00 00 00 00 00 00 C3 48 5D 7E 23 47 FE 2F 28 08 ";
            S = S + "FE 2E 28 04 FE 2D 20 D3 CD 41 5E 38 CE 4F CD 41 ";
            S = S + "5E D8 F5 79 87 87 81 87 4F F1 81 4F C9 CD F8 5D ";
            S = S + "41 CD 41 5E 38 16 2B CD F8 5D E5 C5 48 06 00 D5 ";
            S = S + "11 64 00 CD 16 49 D1 E1 26 00 18 0F E5 48 06 00 ";
            S = S + "21 6C 07 79 FE 50 30 03 21 D0 07 09 E5 DD E1 E1 ";
            S = S + "C9 7E D6 30 D8 FE 0A 3F D8 23 C9 4D 5E ED 7B C0 ";
            S = S + "F5 C9 21 C1 FC 06 04 AF E6 03 B6 C5 E5 61 2E 10 ";
            S = S + "F5 CD 0C 00 2F 5F F1 D5 F5 CD 14 00 F1 D1 F5 D5 ";
            S = S + "CD 0C 00 C1 47 79 2F 5F F1 F5 C5 CD 14 00 C1 79 ";
            S = S + "B8 20 17 F1 2D 20 D9 24 24 24 24 4F 7C FE 40 28 ";
            S = S + "05 FE 80 79 20 C8 79 E1 E1 C9 F1 E1 C1 A7 F2 A7 ";
            S = S + "5E C6 04 FE 90 38 B4 23 3C 10 AD 37 C9 2A 4B F3 ";
            S = S + "A7 ED 42 22 4B F3 18 09 2A 4A FC A7 ED 42 22 4A ";
            S = S + "FC 38 09 7C FE C2 18 03 CD E8 5E D0 CD 86 5F 0C ";
            S = S + "4E 6F 20 65 6E 6F 75 67 68 20 6D 65 6D 6F 72 79 ";
            S = S + "00 00 00 00 00 00 F3 76 7D B4 C8 AF 95 6F 3E 00 ";
            S = S + "9C 67 4D 44 39 3F D8 ED 5B 48 FC ED 52 D8 7C FE ";
            S = S + "02 D8 C5 21 00 00 39 5D 54 09 E5 2A 74 F6 A7 ED ";
            S = S + "52 4D 44 03 E1 F9 EB ED B0 C1 2A 4A FC 09 22 4A ";
            S = S + "FC 11 EA FD 19 22 60 F8 EB 2A 72 F6 09 22 72 F6 ";
            S = S + "2A 62 F8 09 22 62 F8 2A 74 F6 09 22 74 F6 2B 2B ";
            S = S + "22 B1 F6 6B 62 23 23 23 23 3E 02 EB 73 23 72 23 ";
            S = S + "EB 01 07 00 70 09 70 01 02 01 09 3D 20 ED C9 3E ";
            S = S + "01 32 5F F8 2A 4A FC 11 EA FD 19 22 60 F8 5D 54 ";
            S = S + "2B 2B 22 72 F6 01 C8 00 A7 ED 42 E5 21 0D 00 19 ";
            S = S + "22 62 F8 E1 18 B5 E3 CD 8C 5F E3 C9 7E 23 A7 C8 ";
            S = S + "CD 8F 40 18 F7 06 06 21 06 04 CD 65 F3 C5 0F 10 ";
            S = S + "FD CD EC 5F C1 B6 4F 23 23 23 23 7E 05 05 0F 10 ";
            S = S + "FD 18 0B CD E7 5F B6 F0 4F 23 23 23 23 7E E6 0C ";
            S = S + "B1 C9 CD CD 5F 7E 23 66 6F E5 DD E1 C9 CD E7 5F ";
            S = S + "87 87 87 37 8F 4F 7E 87 9F E6 0C 23 23 23 23 A6 ";
            S = S + "B1 87 21 09 FD 18 0C CD 65 F3 0F 0F E6 03 21 C1 ";
            S = S + "FC 06 00 4F 09 C9 3A 9F FD FE C9 28 15 E5 3A 99 ";
            S = S + "FD 21 29 FB CD F1 5F 09 09 EB 21 A0 FD 0E 03 ED ";
            S = S + "B0 E1 F3 3E F7 32 9F FD 22 A1 FD 3E C9 32 A3 FD ";
            S = S + "CD 2D 40 32 A0 FD C9 F5 CD 2D 40 06 04 11 29 FB ";
            S = S + "21 22 FB BE 28 09 13 13 13 23 23 10 F6 F1 C9 EB ";
            S = S + "7E A7 28 F9 F5 FD E1 23 4E 23 46 C5 DD E1 F1 C3 ";
            S = S + "1C 00 A7 38 37 DD E5 FD E5 E5 F5 CD 86 60 6F F1 ";
            S = S + "7D DD 21 10 40 18 14 DD E5 DD 21 13 40 18 06 DD ";
            S = S + "E5 DD 21 16 40 FD E5 E5 CD 86 60 E1 E5 CD 1C 00 ";
            S = S + "C3 6E 63 00 00 00 32 3F F3 21 21 FB 96 38 04 23 ";
            S = S + "23 18 F9 86 23 66 E5 FD E1 C9 21 55 F3 CD F1 5F ";
            S = S + "09 5E 23 56 21 13 00 19 5E 23 56 1B EB 36 FF C9 ";
            S = S + "A7 ED 73 39 F3 D4 D6 62 E5 C5 3A 47 F3 3D 28 41 ";
            S = S + "CD 86 5F 44 72 69 76 65 20 6E 61 6D 65 3F 20 28 ";
            S = S + "00 00 00 00 00 00 3A 47 F3 47 3E 41 18 07 F5 3E ";
            S = S + "2C CD 8F 40 F1 CD 8F 40 3C 10 F3 CD 86 5F 29 20 ";
            S = S + "00 CD 95 61 CD C6 62 E6 DF D6 41 21 47 F3 BE 30 ";
            S = S + "BF CD 9A 60 CD 86 60 FD E5 F5 FD E5 DD 21 19 40 ";
            S = S + "CD 1C 00 7D B4 28 27 F1 F5 CD 0C 00 A7 28 07 CD ";
            S = S + "8F 40 23 F1 18 F2 F1 CD 86 5F 3F 20 00 CD 95 61 ";
            S = S + "D6 31 FE 09 30 F7 C6 31 CD C6 62 D6 30 F5 CD 74 ";
            S = S + "61 F1 D1 FD E1 C1 E1 DD 21 1C 40 CD 1C 00 21 E0 ";
            S = S + "61 30 0A 21 48 62 CD F1 5F 7E 23 66 6F CD C9 62 ";
            S = S + "CD 8C 5F C3 C9 62 AF 32 36 F3 DD 21 56 01 CD AB ";
            S = S + "40 C3 78 40 CD 86 5F 53 74 72 69 6B 65 20 61 20 ";
            S = S + "6B 65 79 20 77 68 65 6E 20 72 65 61 64 79 20 00 ";
            S = S + "00 00 00 00 00 CD 66 61 FE 03 C0 ED 7B 39 F3 CD ";
            S = S + "86 5F 0D 0A 41 62 6F 72 74 65 64 00 C9 57 72 69 ";
            S = S + "74 65 20 70 72 6F 74 65 63 74 65 64 00 4E 6F 74 ";
            S = S + "20 72 65 61 64 79 00 44 69 73 6B 20 65 72 72 6F ";
            S = S + "72 00 42 61 64 20 70 61 72 61 6D 65 74 65 72 00 ";
            S = S + "46 6F 72 6D 61 74 20 63 6F 6D 70 6C 65 74 65 00 ";
            S = S + "00 11 98 F6 2A 78 F6 22 F8 F7 3E 03 32 63 F6 CD ";
            S = S + "F3 2E 11 9B F6 E7 22 78 F6 C0 C3 F7 72 21 21 FB ";
            S = S + "06 04 23 7E F5 FD E1 23 E5 C5 21 1F 40 E5 DD E1 ";
            S = S + "A7 C4 0C 00 A7 C4 1C 00 C1 E1 10 E6 C9 3A D0 FE ";
            S = S + "FE C9 28 11 21 F2 72 11 D5 FE 01 05 00 ED B0 CD ";
            S = S + "2D 40 32 D6 FE C3 2D 40 AD 61 BD 61 C7 61 C7 61 ";
            S = S + "C7 61 C7 61 D2 61 D0 5E C7 61 3A 3F F3 C6 41 CD ";
            S = S + "4F F2 F5 CD 86 5F 0D 0A 49 6E 73 65 72 74 20 64 ";
            S = S + "69 73 6B 65 74 74 65 20 66 6F 72 20 64 72 69 76 ";
            S = S + "65 20 00 00 00 00 00 00 00 00 00 00 00 F1 CD 8F ";
            S = S + "40 CD 86 5F 3A 0D 0A 61 6E 64 20 73 74 72 69 6B ";
            S = S + "65 20 61 20 6B 65 79 20 77 68 65 6E 20 72 65 61 ";
            S = S + "64 79 00 00 00 00 00 00 00 00 00 00 00 CD 66 61 ";
            S = S + "FE 03 28 F9 18 03 CD 8F 40 F5 3E 0D CD 8F 40 3E ";
            S = S + "0A CD 8F 40 F1 C9 21 00 FF 39 ED 5B C6 F6 AF ED ";
            S = S + "52 4D 44 EB D0 4F 47 C9 33 33 C3 1D 6F 7A FE 09 ";
            S = S + "D2 C9 6E F7 00 A7 6A E5 C3 F4 6E 7A FE 09 D2 95 ";
            S = S + "6E F7 00 E7 69 C9 D5 EB A7 ED 42 E5 DD E1 EB D1 ";
            S = S + "4E 23 46 23 79 A0 3C C8 D5 EB 09 23 4E 23 46 E5 ";
            S = S + "DD E5 E1 09 4D 44 E1 70 2B 71 EB D1 18 E2 0C 00 ";
            S = S + "1E 00 2F 00 FF FF DD E5 FD E5 E5 D5 C5 F5 D9 08 ";
            S = S + "F5 E5 2A 5F 63 7D B4 E1 DD 21 38 00 FD 2A C0 FC ";
            S = S + "20 23 F1 ED 73 5F 63 31 00 00 CD 1C 00 F3 31 00 ";
            S = S + "00 E5 21 00 00 22 5F 63 E1 08 D9 F1 C1 D1 E1 FD ";
            S = S + "E1 DD E1 FB C9 F1 CD 1C 00 18 EE F5 E5 D5 C5 CD ";
            S = S + "2D 40 F5 26 40 3A 42 F3 CD 24 00 F1 C1 D1 E1 ED ";
            S = S + "B0 E5 D5 C5 CD 68 F3 26 40 CD 24 00 C1 D1 E1 F1 ";
            S = S + "C9 18 06 F5 3A 42 F3 18 04 F5 3A 48 F3 E5 D5 C5 ";
            S = S + "26 40 CD 24 00 C1 D1 E1 F1 C9 00 00 03 00 17 00 ";
            S = S + "1C 00 22 00 25 00 39 00 3F 00 69 00 6C 00 7E 00 ";
            S = S + "94 00 A8 00 AB 00 BC 00 10 00 13 00 31 00 34 00 ";
            S = S + "78 00 7B 00 B5 00 B8 00 2A 01 31 01 38 01 45 01 ";
            S = S + "4D 01 FF FF CD C2 64 FA 04 64 DB A8 57 A1 B0 CD ";
            S = S + "80 F3 7B C9 CD 11 65 CA 1E 65 E5 CD E7 64 E3 C5 ";
            S = S + "CD F4 63 18 21 D5 CD C2 64 FA 25 64 D1 DB A8 57 ";
            S = S + "A1 B0 C3 85 F3 CD 11 65 CA 24 65 E3 E5 CD E7 64 ";
            S = S + "D1 E3 C5 CD 15 64 C1 E3 F5 78 E6 3F B1 CD 46 00 ";
            S = S + "F1 E1 C9 E3 F5 D5 7E F5 FD E1 23 5E 23 56 23 D5 ";
            S = S + "DD E1 D1 F1 E3 D9 08 FD E5 F1 DD E5 E1 CD C2 64 ";
            S = S + "FA 6C 64 DB A8 F5 A1 B0 D9 C3 8C F3 CD 11 65 CA ";
            S = S + "2C 65 CD E7 64 F5 FD E1 E5 C5 4F 06 00 7D A4 B2 ";
            S = S + "21 C5 FC 09 77 E5 08 D9 CD 55 64 D9 08 E1 C1 D1 ";
            S = S + "78 E6 3F B1 F3 CD 4B 00 73 08 D9 C9 CD C2 64 FA ";
            S = S + "A9 64 DB A8 A1 B0 D3 A8 C9 CD 11 65 CA 41 65 E5 ";
            S = S + "CD E7 64 4F 06 00 7D A4 B2 21 C5 FC 09 77 E1 79 ";
            S = S + "18 DA F3 F5 7C 07 07 E6 03 5F 1C 3E C0 07 07 1D ";
            S = S + "20 FB 5F 2F 4F F1 F5 E6 03 47 04 3E AB C6 55 10 ";
            S = S + "FC 57 A3 47 F1 A7 C9 F5 7A E6 C0 4F F1 F5 57 DB ";
            S = S + "A8 47 E6 3F B1 F5 7A 0F 0F E6 03 57 14 3E AB C6 ";
            S = S + "55 15 20 FB A3 57 7B 2F 67 F1 CD 5C 65 F1 E6 03 ";
            S = S + "C9 4F 7B FE 03 79 C0 3A 41 F3 A3 B8 79 C9 CD 49 ";
            S = S + "65 5E 18 05 D1 CD 49 65 73 78 18 2B CD 41 65 E5 ";
            S = S + "C5 08 D9 CD 98 F3 D9 08 C1 CD 29 65 E1 70 08 D9 ";
            S = S + "C9 CD 49 65 21 C5 FC 72 C9 0F 0F E6 03 57 3A FF ";
            S = S + "FF 2F 47 E6 FC B2 57 32 FF FF 7B C9 D3 A8 3A FF ";
            S = S + "FF 2F 6F A4 B2 18 08 D3 A8 7D 18 03 D3 A8 7B 32 ";
            S = S + "FF FF 78 D3 A8 C9 3A 4E FE FE C9 37 C8 E5 CD 2D ";
            S = S + "40 21 48 F3 BE 20 26 21 B1 65 11 89 FD 1A BE 13 ";
            S = S + "23 20 10 A7 20 F7 7E 23 66 6F E3 CD DA 72 37 3F ";
            S = S + "C9 23 7E A7 20 FB 23 23 23 7E A7 20 DD E1 C3 1C ";
            S = S + "7B 53 59 53 54 45 4D 00 C4 65 46 4F 52 4D 41 54 ";
            S = S + "00 DC 65 00 C0 3A 46 F3 A7 CA 15 73 DD 21 1C 6C ";
            S = S + "CD 1E 73 CD D2 00 CD CC 00 C3 11 5A E5 CC B1 60 ";
            S = S + "E1 A7 C9 7A 3D F0 3A 47 F2 C9 E5 D5 C5 CD E3 65 ";
            S = S + "4F 2A 60 F8 3A 5F F8 F5 5E 23 56 23 E5 EB 7E A7 ";
            S = S + "28 2C 23 23 23 23 7E FE 09 30 23 2B 2B 56 2B 5E ";
            S = S + "1A CD E4 65 B9 20 17 13 EB 11 66 F8 06 0B 1A FE ";
            S = S + "3F 28 03 BE 20 08 13 23 10 F4 E1 E1 18 72 E1 F1 ";
            S = S + "3D F2 F7 65 18 6A E5 D5 C5 7A 32 68 F5 CD 57 66 ";
            S = S + "CD 45 66 18 5B 21 B2 F5 22 3D F2 11 68 F5 AF 32 ";
            S = S + "74 F5 CD B8 4F 3C C9 11 69 F5 21 66 F8 01 0B 00 ";
            S = S + "ED B0 C9 FB E5 D5 C5 F5 3A 48 F3 87 21 10 00 30 ";
            S = S + "02 2E 18 39 DD E5 C1 71 23 70 21 0A 00 39 EB 18 ";
            S = S + "0C FD E5 C1 4E 1A 77 79 12 23 13 10 F7 3A 48 F3 ";
            S = S + "87 21 12 00 30 02 2E 1A 39 7B 95 7A 9C 38 E2 F1 ";
            S = S + "C1 D1 E1 C9 DD 21 8B F3 FD 21 00 02 CD 63 66 E1 ";
            S = S + "7E A7 C9 FB 01 00 01 ED 43 3D F3 CD DA 72 7B C8 ";
            S = S + "F5 E5 3A 48 F3 87 21 0C 00 30 02 2E 14 39 7E FE ";
            S = S + "04 C2 18 73 23 7E FE 09 D2 18 73 E1 CD D0 72 FF ";
            S = S + "CD D0 72 92 CD D0 72 EF DD 21 56 47 CD 1E 73 1B ";
            S = S + "14 15 C2 15 73 13 ED 53 3D F3 F1 C9 FB D0 DD 21 ";
            S = S + "8B F3 FD 21 00 04 CD 63 66 CD A9 6F CD EA 65 CA ";
            S = S + "09 73 22 64 F8 7B FE 04 28 07 01 01 00 ED 43 3D ";
            S = S + "F3 F1 F5 E5 D5 21 45 F3 BE D2 0C 73 01 25 00 5F ";
            S = S + "50 2A 53 F3 CD 1C 49 AF 21 0C 00 09 77 D1 E1 23 ";
            S = S + "71 23 70 23 77 23 72 23 23 77 CD 36 66 C5 D5 7A ";
            S = S + "02 59 50 13 CD 5A 66 D1 C1 7B 20 1C E6 86 CA 12 ";
            S = S + "73 D5 C5 59 50 CD 1D 46 A7 C2 AB 71 E1 CD FE 67 ";
            S = S + "D1 2A 64 F8 73 F1 E1 C9 FE 08 28 45 FE 02 28 E1 ";
            S = S + "FE 80 28 DD D5 C5 59 50 CD 62 44 E1 CD FE 67 D1 ";
            S = S + "2A 64 F8 73 7B FE 04 28 DC E5 21 AE FC AF BE 77 ";
            S = S + "E1 20 D2 01 06 00 09 E5 36 FF 2A 64 F8 CD 2A 68 ";
            S = S + "E1 2B 2B 2B 77 FE FF 20 BC 23 23 23 23 36 80 18 ";
            S = S + "B4 C5 59 50 CD 62 44 E1 E5 CD FE 67 2A 64 F8 36 ";
            S = S + "01 01 06 00 09 36 FF 2A 64 F8 E5 CD 2A 68 E1 30 ";
            S = S + "F9 36 02 E1 01 21 00 09 0E 04 E5 37 7E 98 77 23 ";
            S = S + "0D 20 F9 E1 0C 30 02 0E 04 CD 13 68 18 C1 01 0C ";
            S = S + "00 09 70 23 70 23 ED 4B 3D F3 71 23 70 01 11 00 ";
            S = S + "09 0E 05 70 23 0D 20 FB C9 DD 21 8B F3 FD 21 00 ";
            S = S + "06 CD 63 66 CD 2A 68 C3 A0 66 E5 7E FE 01 C2 99 ";
            S = S + "71 5D 54 23 23 23 7E A7 20 2C 23 23 23 34 7E 23 ";
            S = S + "23 23 20 1D E5 22 3D F2 EB 23 5E 23 56 21 00 01 ";
            S = S + "CD B2 47 5D 54 25 7D B4 E1 28 06 E5 19 36 1A E1 ";
            S = S + "AF 4F 06 00 09 7E 47 D6 1A D6 01 78 E1 23 23 23 ";
            S = S + "36 00 D0 77 C9 FB E5 3A 48 F3 87 21 08 00 30 02 ";
            S = S + "2E 10 39 36 41 23 36 6E E1 23 23 23 71 C9 DD 21 ";
            S = S + "8B F3 FD 21 00 08 CD 63 66 7E FE 02 C2 99 71 F1 ";
            S = S + "F5 CD A7 68 C3 9F 66 E5 01 06 00 09 4E 34 23 23 ";
            S = S + "23 09 77 E1 C0 E5 23 5E 23 56 01 04 00 09 7E 23 ";
            S = S + "23 23 22 3D F2 A7 6F 60 20 01 24 CD 8F 71 E1 C9 ";
            S = S + "DD 21 8B F3 FD 21 00 04 CD 63 66 E1 7E D6 02 20 ";
            S = S + "13 E5 21 AE FC BE 77 E1 20 0A 36 04 3E 1A CD A7 ";
            S = S + "68 C4 B5 68 E5 23 5E 23 56 CD 6F 45 E1 E5 11 07 ";
            S = S + "00 19 72 6A 62 22 64 F8 E1 34 35 72 E1 C9 CD 80 ";
            S = S + "73 E5 DD 21 F7 54 CD 1E 73 3E FF CD C7 69 2A 76 ";
            S = S + "F6 22 3D F2 EB 2A C2 F6 A7 ED 52 CD 8B 71 32 7C ";
            S = S + "F8 E1 DD 21 24 6B C3 1E 73 DD 21 9A 73 FD 21 00 ";
            S = S + "02 CD 63 66 F1 CA 99 71 DD 21 1C 6C CD 1E 73 2A ";
            S = S + "53 F3 E5 CD FE 67 E1 E5 01 13 00 09 7E A7 C2 FD ";
            S = S + "72 2B B6 C2 FD 72 2B 56 2B 5E 2A 76 F6 19 DA FD ";
            S = S + "72 01 93 00 09 DA FD 72 ED 72 D2 FD 72 EB E3 EB ";
            S = S + "CD D0 69 2A 76 F6 22 3D F2 E1 2B CD B2 47 ED 5B ";
            S = S + "76 F6 19 22 C2 F6 DD 21 53 42 CD 1E 73 3A 66 F8 ";
            S = S + "A7 C0 32 7C F8 21 B9 69 11 68 F5 01 05 00 D5 ED ";
            S = S + "B0 E1 DD 21 01 46 C3 1E 73 3A 92 00 00 00 E5 7D ";
            S = S + "CD CB 69 E1 7C 18 04 ED 5B 53 F3 01 BE 47 18 03 ";
            S = S + "01 B2 47 F5 21 01 00 39 22 3D F2 D5 CD E2 69 D1 ";
            S = S + "F1 C9 21 01 00 C5 C9 D5 CD 6A 6B ED 53 BF FC D5 ";
            S = S + "CD 6A 6B ED 53 7D F8 E3 EB E7 DA 15 73 EB E3 CD ";
            S = S + "DA 72 37 28 16 CD D0 72 2C FE 53 20 06 CD DB 72 ";
            S = S + "A7 18 08 CD 6E 6B ED 53 BF FC 37 C1 30 05 04 05 ";
            S = S + "F2 15 73 D1 E5 C5 F5 AF 1E 02 DD 21 FA 6A CD 1E ";
            S = S + "73 3E FE CD C7 69 F1 E1 E5 F5 CD BE 69 2A 7D F8 ";
            S = S + "CD BE 69 2A BF FC CD BE 69 F1 C1 F5 ED 43 3D F2 ";
            S = S + "2A 7D F8 A7 ED 42 23 F1 30 13 CD 8B 71 3E FF 32 ";
            S = S + "AE FC AF DD 21 24 6B CD 1E 73 C3 F8 6E CD 65 71 ";
            S = S + "E5 ED 5B BF FC E7 F5 4D 44 2A 7D F8 E5 09 22 7D ";
            S = S + "F8 E1 ED 5B 3D F2 CD 59 00 F1 30 12 E1 E5 CD 8B ";
            S = S + "71 2A BF FC D1 A7 ED 52 22 BF FC EB 18 D2 E1 2A ";
            S = S + "BF FC CD 8B 71 18 B6 D5 AF 32 BE FC 4F 47 CD DA ";
            S = S + "72 28 1D CD D0 72 2C FE 52 28 04 FE 53 20 0C 32 ";
            S = S + "BE FC CD DB 72 28 09 CD D0 72 2C CD 6E 6B 42 4B ";
            S = S + "D1 E5 C5 3E FF 32 AE FC AF 1E 01 DD 21 FA 6A CD ";
            S = S + "1E 73 ED 5B 53 F3 CD D0 69 FE FE C2 99 71 C1 CD ";
            S = S + "5C 6B E5 CD 5C 6B E5 CD 5C 6B 22 BF FC E1 C1 A7 ";
            S = S + "ED 42 23 ED 43 3D F2 3A BE FC FE 53 28 0C CD B2 ";
            S = S + "47 DD 21 FF 4A CD 1E 73 E1 C9 CD 65 71 E5 ED 5B ";
            S = S + "BF FC E7 F5 ED 5B 53 F3 CD B2 47 F1 C1 C5 F5 2A ";
            S = S + "7D F8 E5 09 22 7D F8 D1 2A 3D F2 F1 30 10 CD 5C ";
            S = S + "00 2A BF FC D1 A7 ED 52 22 BF FC EB 18 CF C1 ED ";
            S = S + "4B BF FC CD 5C 00 AF 32 BE FC 18 B5 C5 CD D0 69 ";
            S = S + "F5 CD D0 69 67 F1 6F C1 09 C9 CD D0 72 2C DD 21 ";
            S = S + "0B 6F C3 1E 73 CD 80 73 CD DB 72 CD D0 72 28 CD ";
            S = S + "C5 6B CD D0 72 29 E5 21 D6 3F 22 F8 F7 E1 3E 03 ";
            S = S + "32 63 F6 A7 18 0B CD 80 73 CD C5 6B CD DA 72 C0 ";
            S = S + "37 F5 E5 D5 59 CD 5D 50 3C CA 9C 71 D1 E1 F1 E5 ";
            S = S + "3E FF 32 46 F2 DD 7E 00 06 01 DD 4E 01 2A 51 F3 ";
            S = S + "CD 44 01 E1 C9 DD 21 1C 52 CD 1E 73 D5 CD D0 72 ";
            S = S + "2C DD 21 2F 54 CD 1E 73 C1 C9 DD 21 8B F3 FD 21 ";
            S = S + "00 04 CD 63 66 7E FE 04 C2 99 71 23 5E 23 56 01 ";
            S = S + "07 00 09 E3 CD DA 72 28 30 D5 CD D0 72 2C DD 21 ";
            S = S + "64 4C CD 1E 73 E5 CD FB 6D 79 B0 B5 B4 CA 15 73 ";
            S = S + "79 B0 0B 20 01 2B EB E1 E3 E5 D5 11 21 00 19 D1 ";
            S = S + "71 23 70 23 73 23 72 D1 E1 E3 22 3D F2 E1 F1 E5 ";
            S = S + "A7 21 03 73 01 B2 47 28 06 21 A8 71 01 BE 47 E5 ";
            S = S + "CD E2 69 A7 C0 E1 C3 F8 6E CD 80 73 FE 23 CC DB ";
            S = S + "72 DD 21 1C 52 CD 1E 73 CA 18 73 E5 DD 21 6D 6A ";
            S = S + "CD 1E 73 5D 54 CA 00 73 DA 15 73 7E FE 04 C2 99 ";
            S = S + "71 23 7E 23 66 6F 01 0E 00 09 4E 23 46 ED 43 68 ";
            S = S + "F5 21 00 00 22 6A F5 01 09 00 E1 EB 09 EB 7E FE ";
            S = S + "2C C0 D5 DD 21 1B 52 CD 1E 73 F5 CD D0 72 41 CD ";
            S = S + "D0 72 53 DD 21 A4 5E CD 1E 73 DD 21 97 55 CD 1E ";
            S = S + "73 C2 FA 72 F1 E3 D5 E5 2A 6A F5 4F 06 00 09 22 ";
            S = S + "6A F5 EB 2A 68 F5 E7 DA 06 73 D1 E1 71 23 73 23 ";
            S = S + "72 06 00 E1 18 B5 F6 37 CD 80 73 F5 DD 21 A4 5E ";
            S = S + "CD 1E 73 DD 21 97 55 CD 1E 73 C2 FA 72 D5 DD 21 ";
            S = S + "5F 4C CD 1E 73 C1 E3 E5 C5 DD 21 D0 67 CD 1E 73 ";
            S = S + "46 E3 7E 4F C5 E5 F5 23 5E 23 56 B7 28 5C 2A 62 ";
            S = S + "F8 2B E7 38 33 2A C2 F6 E7 38 2D 59 16 00 2A 74 ";
            S = S + "F6 19 EB 2A 9B F6 E7 38 54 F1 79 DD 21 8E 66 CD ";
            S = S + "1E 73 E1 C1 E3 D5 C5 DD 21 D0 67 CD 1E 73 C1 D1 ";
            S = S + "E3 C5 E5 23 F5 73 23 72 F1 E1 23 5E 23 56 C1 E1 ";
            S = S + "23 7E 23 66 6F 79 B8 30 01 47 90 4F F1 D4 74 6D ";
            S = S + "04 05 28 0B 7E 12 23 13 18 F7 C1 C1 C1 C1 C1 DC ";
            S = S + "74 6D E1 C9 3E 20 0C 0D C8 12 13 18 FA F1 E1 C1 ";
            S = S + "E3 EB 20 25 C5 78 DD 21 27 66 CD 1E 73 11 98 F6 ";
            S = S + "2A 78 F6 22 F8 F7 3E 03 32 63 F6 CD F3 2E 11 9B ";
            S = S + "F6 E7 22 78 F6 CA F7 72 C1 E3 C5 E5 C3 2A 6D 3E ";
            S = S + "02 01 3E 04 01 3E 08 CD 80 73 F5 DD 21 7A 51 CD ";
            S = S + "1E 73 F1 DD 21 27 66 CD 1E 73 2A 99 F6 CD 10 2F ";
            S = S + "C3 F1 61 00 00 00 00 3E 01 01 3E 03 01 3E 07 CD ";
            S = S + "80 73 F5 DD 21 D0 67 CD 1E 73 F1 BE D2 15 73 3C ";
            S = S + "23 4E 23 66 69 32 63 F6 C3 08 2F DD 21 97 55 CD ";
            S = S + "1E 73 ED 4B F8 F7 21 00 00 F8 CA FA 72 21 F6 F7 ";
            S = S + "11 FC F5 01 08 00 ED B0 21 68 6E 11 47 F8 0E 08 ";
            S = S + "ED B0 CD 9F 28 A7 CD D1 30 DD 21 32 54 CD 1E 73 ";
            S = S + "D5 EB DD 21 FF 46 CD 1E 73 CD 42 30 01 45 65 11 ";
            S = S + "53 60 CD 5C 32 21 F6 F7 11 47 F8 01 08 00 ED B0 ";
            S = S + "21 FC F5 11 F6 F7 0E 08 ED B0 CD 8C 26 DD 21 32 ";
            S = S + "54 CD 1E 73 4B 42 E1 C9 45 65 53 60 00 00 00 00 ";
            S = S + "CD 80 73 E5 CD 2A 68 21 00 00 30 01 2B F5 CD 99 ";
            S = S + "2F F1 E1 23 23 23 77 C9 CD 80 73 16 00 28 06 CD ";
            S = S + "80 6F E5 18 04 E5 CD FE 6F CD 63 6F 3A 16 F4 A7 ";
            S = S + "F5 CD 45 66 CA 12 73 DD 21 23 73 CD 1E 73 21 B3 ";
            S = S + "F5 06 0B 7E 23 DF 78 FE 04 20 08 7E FE 20 28 02 ";
            S = S + "3E 2E DF 10 EE CD BD 00 F1 F5 3A B0 F3 47 3A 61 ";
            S = S + "F6 28 05 06 50 3A 15 F4 A7 28 0F C6 0C B8 30 03 ";
            S = S + "3E 20 DF DD 21 28 73 D4 1E 73 11 68 F5 AF 32 74 ";
            S = S + "F5 CD 06 50 3C 20 B7 F1 E1 DD 21 FF 4A C3 1E 73 ";
            S = S + "CD 80 73 CD 96 6F CD DA 72 C0 CD EA 65 CA A2 71 ";
            S = S + "CD 63 6F E5 11 68 F5 CD 6C 43 A7 C2 12 73 E1 C9 ";
            S = S + "CD 80 73 CD 96 6F CD EA 65 CA A2 71 CD 63 6F E5 ";
            S = S + "CD 45 66 CA 12 73 E1 CD D0 72 41 CD D0 72 53 CD ";
            S = S + "96 6F 7A 32 78 F5 E5 2A 68 F5 A7 28 04 BD C2 B7 ";
            S = S + "71 11 79 F5 CD 5A 66 11 68 F5 CD 92 43 A7 C2 A5 ";
            S = S + "71 E1 C9 CD E3 65 3C 32 68 F5 E5 D5 CD 57 66 D1 ";
            S = S + "E1 C9 DD 21 0E 6A CD 1E 73 7A FE 09 D8 C3 9C 71 ";
            S = S + "CD 72 6F E5 21 66 F8 06 0B 7E 23 FE 20 20 0B 10 ";
            S = S + "F8 CD FE 6F 18 04 CD 72 6F E5 21 66 F8 06 08 CD ";
            S = S + "F5 6F 06 03 CD F5 6F E1 F6 37 D5 E5 11 66 F8 D5 ";
            S = S + "06 0B C5 1A 21 CC 6F 01 0D 00 38 01 0B ED B1 28 ";
            S = S + "31 C1 13 10 ED E1 CD D9 6F E1 D1 C9 2E 22 2F 5C ";
            S = S + "5B 5D 3A 2B 3D 3B 2C 2A 3F 3E 20 BE 28 14 06 07 ";
            S = S + "CD E5 6F 06 03 23 BE 28 03 10 FA C9 05 C8 23 BE ";
            S = S + "28 FA C3 0F 73 7E FE 2A 28 09 23 10 F8 C9 21 66 ";
            S = S + "F8 06 0B 36 3F 23 10 FB C9 01 10 00 11 01 21 00 ";
            S = S + "CD 80 73 C5 DD 21 1F 52 CD 1E 73 DD 21 6D 6A CD ";
            S = S + "1E 73 DA 15 73 CA 00 73 C1 23 5E 23 56 EB 09 4E ";
            S = S + "23 46 23 5E 23 56 EB C5 DD 21 FF 46 CD 1E 73 01 ";
            S = S + "45 65 11 53 60 CD 5C 32 21 F6 F7 11 47 F8 01 08 ";
            S = S + "00 ED B0 E1 DD 21 FF 46 CD 1E 73 CD 42 30 C3 9A ";
            S = S + "26 CD 80 73 DD 21 1F 52 CD 1E 73 21 47 F3 BE 28 ";
            S = S + "03 D2 9C 71 5F CD 5D 50 C3 99 2F CD 80 73 CD 80 ";
            S = S + "6F CD EA 65 CA A2 71 CD 63 6F E5 3A 47 F2 3C 32 ";
            S = S + "8D F5 21 69 F5 11 8E F5 01 24 00 ED B0 E1 CD DA ";
            S = S + "72 28 20 CD D0 72 D9 CD 80 6F CD EA 65 CA A2 71 ";
            S = S + "CD E3 65 3C 32 8D F5 E5 11 8E F5 CD 5A 66 E1 CD ";
            S = S + "DA 72 C0 E5 CD 45 66 CA 12 73 CD BD 00 01 8D F5 ";
            S = S + "11 D7 F5 21 B2 F5 3E 0C F5 0A FE 3F 20 01 7E 12 ";
            S = S + "03 13 23 F1 3D 20 F1 21 B2 F5 11 D7 F5 06 0C 1A ";
            S = S + "BE 20 07 23 13 10 F8 C3 15 73 CD 6C 71 E5 AF 32 ";
            S = S + "BE F5 11 B2 F5 CD 62 44 11 D7 F5 CD 1D 46 A7 C2 ";
            S = S + "AB 71 6F 67 22 D3 F5 22 D5 F5 22 F8 F5 22 FA F5 ";
            S = S + "23 22 C0 F5 22 E5 F5 E1 E5 11 B2 F5 CD B2 47 7D ";
            S = S + "B4 28 09 11 D7 F5 CD 8F 71 E1 18 EC E1 2A C6 F5 ";
            S = S + "22 EB F5 2A C8 F5 22 ED F5 11 D7 F5 CD 6F 45 21 ";
            S = S + "B2 F5 22 3D F2 11 68 F5 AF 32 74 F5 CD 06 50 3C ";
            S = S + "C2 CA 70 E1 C9 22 BF FC ED 43 7D F8 21 00 FE 39 ";
            S = S + "30 0D ED 5B C6 F6 A7 ED 52 38 04 7C A7 20 07 ED ";
            S = S + "5B 62 F8 21 00 01 ED 53 3D F2 C9 ED 5B 53 F3 CD ";
            S = S + "BE 47 A7 C8 18 12 1E 3C 01 1E 3D 01 1E 3E 01 1E ";
            S = S + "3F 01 1E 40 01 1E 41 01 1E 42 01 1E 43 01 1E 44 ";
            S = S + "01 1E 45 01 1E 46 01 1E 47 01 00 00 AF 32 7C F8 ";
            S = S + "32 AE FC D5 DD 21 24 6B CD 1E 73 D1 DD 21 6F 40 ";
            S = S + "C3 1E 73 7B FE 3C D8 FE 48 D0 D6 3B 47 21 F5 71 ";
            S = S + "7E A7 23 20 FB 10 F9 2B 11 04 F6 D5 01 16 00 ED ";
            S = S + "B0 1E 01 E1 C9 00 42 61 64 20 46 41 54 00 42 61 ";
            S = S + "64 20 66 69 6C 65 20 6D 6F 64 65 00 42 61 64 20 ";
            S = S + "64 72 69 76 65 20 6E 61 6D 65 00 42 61 64 20 73 ";
            S = S + "65 63 74 6F 72 20 6E 75 6D 62 65 72 00 46 69 6C ";
            S = S + "65 20 73 74 69 6C 6C 20 6F 70 65 6E 00 46 69 6C ";
            S = S + "65 20 61 6C 72 65 61 64 79 20 65 78 69 73 74 73 ";
            S = S + "00 44 69 73 6B 20 66 75 6C 6C 00 54 6F 6F 20 6D ";
            S = S + "61 6E 79 20 66 69 6C 65 73 00 44 69 73 6B 20 77 ";
            S = S + "72 69 74 65 20 70 72 6F 74 65 63 74 65 64 00 44 ";
            S = S + "69 73 6B 20 49 2F 4F 20 65 72 72 6F 72 00 44 69 ";
            S = S + "73 6B 20 6F 66 66 6C 69 6E 65 00 52 65 6E 61 6D ";
            S = S + "65 20 61 63 72 6F 73 73 20 64 69 73 6B 00 B0 72 ";
            S = S + "CB 79 C2 96 71 CB 81 06 00 21 C2 72 09 7E 23 66 ";
            S = S + "6F E9 AE 71 B4 71 B1 71 B1 71 B1 71 B1 71 B1 71 ";
            S = S + "CD DA 72 E3 BE 20 41 23 E3 23 2B DD 21 66 46 18 ";
            S = S + "3D 00 00 00 3E C9 32 D5 FE ED 5B 4A FC ED 53 49 ";
            S = S + "F3 C9 F7 00 E4 72 C9 1E 10 01 1E 0D 01 1E 07 01 ";
            S = S + "1E 3B 01 1E 37 01 1E 32 01 1E 36 01 1E 34 01 1E ";
            S = S + "38 01 1E 35 01 1E 05 01 1E 02 DD 21 6F 40 CD 59 ";
            S = S + "01 FB C9 FB E5 D5 3A 48 F3 87 21 10 00 30 02 2E ";
            S = S + "18 39 5E 23 56 E5 21 95 6E E7 E1 28 0D E5 21 C9 ";
            S = S + "6E E7 E1 20 0B 11 77 F3 18 03 11 7A F3 72 2B 73 ";
            S = S + "D1 E1 7B FE 02 D8 7E FE 3A 28 B4 23 7E FE 3A 2B ";
            S = S + "C0 CD 80 73 7E E6 DF D6 40 E5 21 47 F3 BE E1 28 ";
            S = S + "03 D2 9C 71 23 23 1D 1D D5 1C D1 C9 FB 3E 00 C9 ";
            S = S + "FB E5 F5 3A 48 F3 87 21 0C 00 30 02 2E 14 39 36 ";
            S = S + "8B 23 36 F3 F1 E1 C9 CD 6B F3 1A CD 68 F3 13 FE ";
            S = S + "24 C8 CD A8 53 18 F0 CD 6B F3 ED B0 CD 68 F3 C9 ";
            S = S + "CD 6B F3 C3 00 00 11 DE F1 D5 5E 23 56 EB CD 6B ";
            S = S + "F3 E9 C3 04 56 50 52 4E 20 4C 53 54 20 4E 55 4C ";
            S = S + "20 41 55 58 20 43 4F 4E 20 20 20 20 20 20 20 20 ";
            S = S + "20 20 20 20 80 00 00 00 00 00 00 00 00 00 00 00 ";
            S = S + "00 00 00 00 00 00 00 00 00 1F 1C 1F 1E 1F 1E 1F ";
            S = S + "1F 1E 1F 1E 1F F8 00 02 0F 04 01 02 01 00 02 70 ";
            S = S + "0C 00 63 01 02 05 00 F9 00 02 0F 04 01 02 01 00 ";
            S = S + "02 70 0E 00 CA 02 03 07 00 FA 00 02 0F 04 01 02 ";
            S = S + "01 00 02 70 0A 00 3C 01 01 03 00 FB 00 02 0F 04 ";
            S = S + "01 02 01 00 02 70 0C 00 7B 02 02 05 00 D2 46 75 ";
            S = S + "CD 75 74 FB CD D4 FF F5 0E 3C 30 02 0E 00 CD 76 ";
            S = S + "77 DD 36 00 78 DD 7E 03 A7 20 05 DD 71 01 F1 C9 ";
            S = S + "DD 71 02 F1 C9 CD F7 75 D8 CD CF FF F3 7C A7 FA ";
            S = S + "AC 74 CD 32 7B CD B9 7B D8 04 05 C8 CD CF FF F3 ";
            S = S + "7C A7 FA AC 74 E5 D5 C5 ED 5B 4D F3 D5 01 00 02 ";
            S = S + "CD 6E F3 E1 C1 D1 CD B7 74 E1 18 03 CD B7 74 D8 ";
            S = S + "05 C8 CD D9 76 18 C6 1E 15 CD 36 77 3E A0 CB 72 ";
            S = S + "28 08 F6 02 CB 42 28 02 F6 08 E5 D5 C5 11 E5 74 ";
            S = S + "D5 32 F8 7F 01 FF 7F 0A 87 F0 DA D7 74 7E 32 FB ";
            S = S + "7F 23 C3 D7 74 C1 D1 E1 3A F8 7F E6 FC C8 CB 77 ";
            S = S + "20 29 F5 DD 7E 03 F6 C4 32 FD 7F CD 1B 77 F1 1D ";
            S = S + "20 B7 37 5F CB 7B 3E 02 C0 CB 6B 3E 0A C0 CB 63 ";
            S = S + "3E 08 C0 CB 5B 3E 04 C0 3E 0C C9 CD 76 77 3E 80 ";
            S = S + "32 F8 7F E3 E3 21 FF 7F 11 00 00 7E 87 DA 43 75 ";
            S = S + "F2 43 75 1B 7B B2 C2 2B 75 18 04 C1 C1 D1 E1 3E ";
            S = S + "02 37 C9 AF 37 C9 CD 4C 75 C3 53 74 CD F7 75 D8 ";
            S = S + "CD CF FF F3 7C A7 FA 88 75 CD 1E 7B CD B9 7B D8 ";
            S = S + "04 05 C8 CD CF FF F3 7C A7 FA 88 75 E5 2A 4D F3 ";
            S = S + "CD 93 75 E1 D8 E5 D5 C5 EB 2A 4D F3 01 00 02 CD ";
            S = S + "6E F3 C1 D1 E1 A7 18 04 CD 93 75 D8 05 C8 CD D9 ";
            S = S + "76 18 C1 1E 15 CD 36 77 3E 80 CB 72 28 08 F6 02 ";
            S = S + "CB 42 28 02 F6 08 E5 D5 C5 01 FF 7F 11 DB 75 D5 ";
            S = S + "32 F8 7F 11 00 00 0A 87 D2 D3 75 F0 1D C2 B6 75 ";
            S = S + "0A 87 D2 D3 75 F0 15 C2 B6 75 C3 3B 75 0A 87 F0 ";
            S = S + "DA CD 75 3A FB 7F 77 23 C3 CD 75 C1 D1 E1 3A F8 ";
            S = S + "7F E6 9C C8 F5 DD 7E 03 F6 C4 32 FD 7F CD 1B 77 ";
            S = S + "F1 1D 20 A1 C3 02 75 F5 C5 E5 CD C2 5F E1 C1 F1 ";
            S = S + "FE 02 38 04 3E 0C 37 C9 F5 79 FE F8 38 04 FE FC ";
            S = S + "38 03 F1 18 EF E3 E5 C5 CD 36 77 CB 49 4B 42 11 ";
            S = S + "08 00 20 01 13 CD 2F 49 7D 3C 32 FA 7F 69 C1 F1 ";
            S = S + "67 AF CB 41 28 05 CB 3D 30 01 3C 32 FC 7F 57 DD ";
            S = S + "7E 07 3D 28 01 7C F6 C4 CD CF FF F3 32 FD 7F DD ";
            S = S + "7E 00 A7 DD 36 00 FF FB CD D4 FF 20 0C CD 5E 77 ";
            S = S + "CD 5E 77 CD 5E 77 CD 5E 77 79 0F 0F E6 C0 B2 57 ";
            S = S + "4D DD 7E 07 3D 28 25 DD 7E 03 BC 28 4F EE 01 DD ";
            S = S + "77 03 3A F9 7F 28 08 DD 77 04 DD 7E 05 18 06 DD ";
            S = S + "77 05 DD 7E 04 32 F9 7F E3 E3 18 33 DD 7E 06 BC ";
            S = S + "DD 74 06 28 27 DD E5 D5 C5 CD CF FF F3 F5 3E 83 ";
            S = S + "32 FD 7F F1 FB CD D4 FF CD 5A 62 CD CF FF F3 3E ";
            S = S + "C4 32 FD 7F FB CD D4 FF C1 D1 DD E1 3A F9 7F CD ";
            S = S + "21 77 E1 C9 CD 36 77 18 16 CD 36 77 24 24 3A FA ";
            S = S + "7F 3C 32 FA 7F CB 7A 20 03 FE 0A D8 FE 09 D8 3E ";
            S = S + "01 32 FA 7F CB 72 28 0B CB 42 20 07 CB C2 32 FC ";
            S = S + "7F 18 14 CB 82 AF 32 FC 7F 0C CD 36 77 3E 50 32 ";
            S = S + "F8 7F E3 E3 CD 36 77 37 3F 18 49 CB 43 C0 CD 3D ";
            S = S + "77 CD 36 77 79 32 FB 7F E3 E3 3E 10 32 F8 7F E3 ";
            S = S + "E3 CD 36 77 18 2E 3A F8 7F 1F 38 FA C9 3A F9 7F ";
            S = S + "B7 20 03 CD 4D 77 CD 36 77 3E 00 18 DF C5 06 05 ";
            S = S + "CD 36 77 3E 50 32 F8 7F E3 E3 10 F4 C1 C9 E5 21 ";
            S = S + "E1 99 18 0A E5 21 7B 11 18 04 E5 21 2C 01 2B 7C ";
            S = S + "B5 20 FB E1 AF C9 3E D0 32 F8 7F E3 E3 E3 E3 3A ";
            S = S + "F8 7F 3A FB 7F C9 CD 76 77 3E C0 CD 94 77 3E 03 ";
            S = S + "32 FD 7F C9 32 FD 7F CD 4D 77 CD 36 77 3E 00 32 ";
            S = S + "F8 7F E3 E3 21 00 00 3A F8 7F 1F 30 08 2B 7D B4 ";
            S = S + "20 F5 CD 76 77 C9 C5 F5 CD C2 5F F1 F5 28 07 3E ";
            S = S + "C1 CD 94 77 20 03 2E 01 C2 2E 02 DD 75 07 CD 8E ";
            S = S + "77 F1 28 02 2E 02 C1 C9 CD C2 5F AF 06 07 77 23 ";
            S = S + "10 FC 21 E8 77 C3 F6 5F F5 CD C2 5F 7E A7 28 0B ";
            S = S + "FE FF 28 07 3D 77 20 03 CD 8E 77 23 7E A7 28 01 ";
            S = S + "35 23 7E A7 28 01 35 F1 C3 27 60 FB E5 C5 F5 CD ";
            S = S + "C2 5F F1 C1 E1 47 DD 7E 07 3D 78 20 0D DD 7E 06 ";
            S = S + "E6 03 B8 78 06 01 20 10 18 06 A7 DD 46 02 20 03 ";
            S = S + "DD 46 01 04 05 06 01 C0 C5 E5 11 01 00 2A 4D F3 ";
            S = S + "CD 46 75 38 17 2A 4D F3 46 E1 C5 CD 5F 78 3E 0A ";
            S = S + "38 0A F1 C1 B9 37 3F 06 FF C0 04 C9 D1 D1 C9 EB ";
            S = S + "13 78 D6 F8 D8 FE 04 30 14 6F 26 00 29 4D 44 29 ";
            S = S + "29 29 09 01 05 74 09 01 12 00 ED B0 C9 37 C9 3D ";
            S = S + "20 09 CD C2 5F DD 7E 07 3D 20 04 21 00 00 C9 21 ";
            S = S + "93 78 C9 31 20 2D 20 53 69 6E 67 6C 65 20 53 69 ";
            S = S + "64 65 20 2E 2E 2E 0D 0A 32 20 2D 20 44 6F 75 62 ";
            S = S + "6C 65 20 53 69 64 65 20 2E 2E 2E 0D 0A 00 FB E5 ";
            S = S + "21 A8 E4 09 E1 38 08 3F 3E 0E C9 3F 3E 0C C9 72 ";
            S = S + "01 22 00 09 F5 E5 D5 CD C2 5F D1 E1 F1 DD 46 07 ";
            S = S + "05 28 12 42 05 20 0E D6 01 38 E1 FE 02 30 DC 01 ";
            S = S + "F9 09 3D 28 07 01 F8 09 7A F5 18 1F 7A F5 D5 E5 ";
            S = S + "C5 F5 06 02 CD 4B 79 38 36 F1 C1 C5 F5 06 01 11 ";
            S = S + "00 00 CD 46 75 38 27 F1 C1 E1 D1 C5 06 50 CB 41 ";
            S = S + "28 02 06 A0 CD 4B 79 38 19 CD 3D 77 C1 F1 F5 CD ";
            S = S + "17 7A 11 00 00 F1 CD 65 79 38 08 C3 53 74 3F E1 ";
            S = S + "D1 C1 C1 C1 DA 53 74 37 C3 CC 78 11 00 00 CD 00 ";
            S = S + "76 D8 CD 7F 7A E5 CD 90 79 CD 6E 79 E1 D8 05 C8 ";
            S = S + "CD D4 76 18 ED C5 E5 37 CD 4D 74 E1 C1 C9 D8 3A ";
            S = S + "0D F3 B7 C8 C5 D5 E5 F5 CB 7A 06 09 20 02 06 08 ";
            S = S + "3E 01 32 FA 7F CD 36 77 CD 50 75 E1 E1 D1 C1 C9 ";
            S = S + "1E 15 CD 36 77 3E F0 E5 D5 C5 11 D2 79 D5 CD CF ";
            S = S + "FF F3 E3 E3 01 FF 7F 11 00 00 32 F8 7F 0A 87 D2 ";
            S = S + "CA 79 F0 1D C2 AD 79 0A 87 D2 CA 79 F0 15 C2 AD ";
            S = S + "79 C3 3B 75 0A 87 F0 DA C4 79 7E 32 FB 7F 23 C3 ";
            S = S + "C4 79 C1 D1 E1 FB CD D4 FF 3A F8 7F E6 FC C8 CB ";
            S = S + "77 20 19 F5 DD 7E 03 F6 C4 32 FD 7F CD 1B 77 F1 ";
            S = S + "1D 20 9F E6 F8 C2 02 75 37 3E 10 C9 3E D4 32 F8 ";
            S = S + "7F E3 E3 21 FF 7F 11 20 4E 7E 87 F2 43 75 1B 7B ";
            S = S + "B2 C2 09 7A C3 3F 75 DD E5 E5 DD E1 E5 11 00 02 ";
            S = S + "36 00 23 1B 7A B3 20 F8 D1 D5 C5 21 88 7E 01 B7 ";
            S = S + "00 ED B0 C1 CB 41 28 14 DD 36 13 A0 DD 36 14 05 ";
            S = S + "DD 36 15 F9 DD 36 16 03 DD 36 1A 02 E1 E5 24 24 ";
            S = S + "E5 06 01 CB 49 20 01 04 CB 41 28 01 04 CB 20 3E ";
            S = S + "07 80 47 C5 11 00 02 36 00 23 1B 7A B3 20 F8 10 ";
            S = S + "F3 C1 04 E1 71 23 36 FF 23 36 FF E1 DD E1 C9 E5 ";
            S = S + "DD E5 C5 D5 01 DF FF 09 E5 DD E1 11 FB 7A 06 21 ";
            S = S + "1A 77 23 13 10 FA 11 F0 7A CD DC 7A D1 C1 C5 D5 ";
            S = S + "CB 72 28 04 CB 42 20 04 06 00 18 02 06 01 DD 71 ";
            S = S + "06 DD 70 08 DD 36 0A 01 CB 7A 06 09 28 02 06 08 ";
            S = S + "DD E5 D1 CD DC 7A DD 34 0A 10 F5 11 00 04 36 4E ";
            S = S + "23 1B 7A B3 20 F8 D1 C1 DD E1 E1 C9 C5 D5 1A 4F ";
            S = S + "3C 28 0A 13 1A 47 13 71 23 10 FC 18 F1 D1 C1 C9 ";
            S = S + "4E 50 00 0C F6 03 FC 01 4E 1A FF 00 0C F5 03 FE ";
            S = S + "01 00 01 00 01 01 01 02 01 F7 01 4E 18 00 0C F5 ";
            S = S + "03 FB 01 E5 00 E5 00 F7 01 4E 36 FF 37 C9 E5 D5 ";
            S = S + "C5 21 BF 7B ED 5B 4D F3 01 4E 01 ED B0 21 8D 7B ";
            S = S + "18 12 E5 D5 C5 21 0D 7D ED 5B 4D F3 01 5F 01 ED ";
            S = S + "B0 21 65 7B 5E 23 56 23 7B B2 28 15 E5 2A 4D F3 ";
            S = S + "19 23 4E 23 46 EB 2A 4D F3 09 EB 72 2B 73 E1 18 ";
            S = S + "E3 C1 D1 E1 C9 06 00 24 00 29 00 3D 00 4A 00 52 ";
            S = S + "00 62 00 67 00 6F 00 A5 00 AB 00 D1 00 02 01 0C ";
            S = S + "01 16 01 19 01 29 01 3E 01 4C 01 00 00 06 00 24 ";
            S = S + "00 29 00 40 00 4C 00 51 00 56 00 5B 00 67 00 6F ";
            S = S + "00 7F 00 84 00 88 00 C0 00 F1 00 FB 00 05 01 08 ";
            S = S + "01 18 01 2D 01 3B 01 00 00 E5 2A 4D F3 E3 C9 E5 ";
            S = S + "D5 C5 CD 2D 40 32 B4 00 26 80 CD 24 00 FB 3A 42 ";
            S = S + "F3 26 40 CD 24 00 FB C1 D1 E1 CD CF FF F3 2B 7C ";
            S = S + "C6 02 23 FA A3 00 1E 15 CD 1D 01 3E 80 CB 72 28 ";
            S = S + "08 F6 02 CB 42 28 02 F6 08 E5 D5 C5 01 FF BF 11 ";
            S = S + "72 00 D5 32 F8 BF 11 00 00 0A 87 D2 6A 00 F0 1D ";
            S = S + "C2 4A 00 0A 87 D2 6A 00 F0 15 C2 4A 00 C1 C1 D1 ";
            S = S + "E1 18 3C 0A 87 F0 DA 64 00 3A FB BF 77 23 C3 64 ";
            S = S + "00 C1 D1 E1 3A F8 BF E6 9C 20 08 05 28 24 CD C0 ";
            S = S + "00 18 9B FA A0 00 F5 CD 02 01 F1 1D 20 9A 5F CB ";
            S = S + "63 3E 08 20 0C CB 5B 3E 04 20 06 3E 0C 18 02 3E ";
            S = S + "02 37 E5 D5 C5 F5 3A 43 F3 26 80 CD 24 00 CD 68 ";
            S = S + "F3 FB 3E 00 26 40 CD 24 00 FB F1 C1 D1 E1 C9 CD ";
            S = S + "1D 01 24 24 3A FA BF 3C 32 FA BF CB 7A 20 03 FE ";
            S = S + "0A D8 FE 09 D8 3E 01 32 FA BF CB 72 28 0B CB 42 ";
            S = S + "20 07 CB C2 32 FC BF 18 14 CB 82 AF 32 FC BF 0C ";
            S = S + "CD 1D 01 3E 50 32 F8 BF E3 E3 CD 1D 01 37 3F 18 ";
            S = S + "40 CB 43 C0 CD 24 01 CD 1D 01 79 32 FB BF E3 E3 ";
            S = S + "3E 10 32 F8 BF E3 E3 CD 1D 01 18 25 3A F8 BF 1F ";
            S = S + "38 FA C9 3A F9 BF B7 20 11 C5 06 05 CD 1D 01 3E ";
            S = S + "50 32 F8 BF E3 E3 05 20 F3 C1 CD 1D 01 3E 00 18 ";
            S = S + "D1 E5 21 7B 11 2B 7C B5 20 FB E1 AF C9 E5 D5 C5 ";
            S = S + "CD 2D 40 32 C5 00 26 80 CD 24 00 FB 3A 42 F3 26 ";
            S = S + "40 CD 24 00 FB C1 D1 E1 CD CF FF F3 2B 7C C6 02 ";
            S = S + "23 FA B4 00 1E 15 CD 2E 01 3E A0 CB 72 28 08 F6 ";
            S = S + "02 CB 42 28 02 F6 08 E5 D5 C5 11 55 00 D5 32 F8 ";
            S = S + "BF 01 FF BF 0A 87 F0 DA 47 00 7E 32 FB BF 23 C3 ";
            S = S + "47 00 C1 D1 E1 3A F8 BF E6 FC 20 08 05 28 52 CD ";
            S = S + "D1 00 18 B8 FA AE 00 CB 77 20 1F F5 CD 13 01 F1 ";
            S = S + "1D 20 B3 5F CB 6B 3E 0A 20 36 CB 63 3E 08 20 30 ";
            S = S + "CB 5B 3E 04 20 2A 3E 0C 18 26 3E D0 32 F8 BF E3 ";
            S = S + "E3 3E 80 32 F8 BF E3 E3 21 FF BF 11 00 00 7E 87 ";
            S = S + "38 0D C3 B2 00 1B 7B B2 C2 A1 00 3E 02 18 01 AF ";
            S = S + "37 E5 D5 C5 F5 3A 43 F3 26 80 CD 24 00 CD 68 F3 ";
            S = S + "FB 3E 00 26 40 CD 24 00 FB F1 C1 D1 E1 C9 CD 2E ";
            S = S + "01 24 24 3A FA BF 3C 32 FA BF CB 7A 20 03 FE 0A ";
            S = S + "D8 FE 09 D8 3E 01 32 FA BF CB 72 28 0B CB 42 20 ";
            S = S + "07 CB C2 32 FC BF 18 14 CB 82 AF 32 FC BF 0C CD ";
            S = S + "2E 01 3E 50 32 F8 BF E3 E3 CD 2E 01 37 3F 18 40 ";
            S = S + "CB 43 C0 CD 35 01 CD 2E 01 79 32 FB BF E3 E3 3E ";
            S = S + "10 32 F8 BF E3 E3 CD 2E 01 18 25 3A F8 BF 1F 38 ";
            S = S + "FA C9 3A F9 BF B7 20 11 C5 06 05 CD 2E 01 3E 50 ";
            S = S + "32 F8 BF E3 E3 05 20 F3 C1 CD 2E 01 3E 00 18 D1 ";
            S = S + "E5 21 7B 11 2B 7D B4 20 FB E1 AF C9 3E 0D D3 B4 ";
            S = S + "DB B5 E6 04 F5 F6 01 D3 B5 3E 0B D3 B4 78 D3 B5 ";
            S = S + "3E 0D D3 B4 F1 D3 B5 C9 EB FE 90 4E 4D 53 20 20 ";
            S = S + "32 2E 32 00 02 02 01 00 02 70 00 D0 02 F8 02 00 ";
            S = S + "09 00 01 00 00 00 D0 ED 53 59 C0 32 D0 C0 36 56 ";
            S = S + "23 36 C0 31 1F F5 11 AB C0 0E 0F CD 7D F3 3C CA ";
            S = S + "63 C0 11 00 01 0E 1A CD 7D F3 21 01 00 22 B9 C0 ";
            S = S + "21 00 3F 11 AB C0 0E 27 CD 7D F3 C3 00 01 58 C0 ";
            S = S + "CD 00 00 79 E6 FE FE 02 C2 6A C0 3A D0 C0 A7 CA ";
            S = S + "22 40 11 85 C0 CD 77 C0 0E 07 CD 7D F3 18 B4 1A ";
            S = S + "13 B7 C8 D5 5F 0E 06 CD 7D F3 D1 18 F2 42 6F 6F ";
            S = S + "74 20 65 72 72 6F 72 0D 0A 50 72 65 73 73 20 61 ";
            S = S + "6E 79 20 6B 65 79 20 66 6F 72 20 72 65 74 72 79 ";
            S = S + "0D 0A 00 00 4D 53 58 44 4F 53 20 20 53 59 53 00 ";
            S = S + "00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF ";
            S = S + "FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 ";
            S = S + "00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF ";
            S = S + "FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 ";
            S = S + "00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF ";
            S = S + "FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 ";
            S = S + "00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF ";
            S = S + "FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 ";
            S = S + "00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF ";
            S = S + "FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 ";
            S = S + "00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF 00 FF ";
            S = S + "FF 00 FF 00 FF 00 FF 00 24 00 05 00 FF FF FF FF ";

            return S;
        }
    }
}
