﻿using System.Runtime.InteropServices;

namespace csMSX2
{
    public static class PPI
    {
        [DllImport("user32.dll")] private static extern short GetAsyncKeyState(int vKey);

      //public static byte MSX_PPI_REG_A; //Slot Page
      //public static sbyte Gi_MEM_PAGE0; //-128~127
      //public static sbyte Gi_MEM_PAGE1;
      //public static sbyte Gi_MEM_PAGE2;
      //public static sbyte Gi_MEM_PAGE3;

        public static byte MSX_PPI_REG_B; //RegC(KMT) 에서 지정된 키매트릭스 상태값

      //public static byte MSX_PPI_REG_C;
        public static byte MSX_PPI_REG_C_KSO; //7 bit - 1-bit Sound output, 1:on, 0:off - 비트사운드출력
        public static byte MSX_PPI_REG_C_KCL; //6 bit - Keyboard CAPS LED, 1:off, 0:on
        public static byte MSX_PPI_REG_C_CWT; //5 bit - Cassette Write Signal, 1:on, 0:off
        public static byte MSX_PPI_REG_C_CMT; //4 bit - Cassette Motor, 1:off, 0:on
        public static byte MSX_PPI_REG_C_KMT; //3~0 bit - Keyboard Matrix의 지정행번호 (0~10)

        public static void MSX_INIT_PPI()
        {
          //MSX_PPI_REG_A = 0;
            MSX_PPI_REG_B = 0;
          //MSX_PPI_REG_C = 0;

            MSX_PPI_REG_C_KSO = 0;
            MSX_PPI_REG_C_KCL = 0;
            MSX_PPI_REG_C_CWT = 0;
            MSX_PPI_REG_C_CMT = 0;
            MSX_PPI_REG_C_KMT = 0;
        }

        public static byte GET_MSX_PPI_REG_A()
        {
            byte R;

            R = 0;
            R = (byte)(R + TBL.Gi_M_Table64[MEM.Gi_MEM_PAGE3]);
            R = (byte)(R + TBL.Gi_M_Table16[MEM.Gi_MEM_PAGE2]);
            R = (byte)(R + TBL.Gi_M_Table4[MEM.Gi_MEM_PAGE1]);
            R = (byte)(R + MEM.Gi_MEM_PAGE0);

            return R;
        }

        public static byte GET_MSX_PPI_REG_C()
        {
            byte R;

            R = 0;
            R = (byte)(R + TBL.Go_M_Table128[MSX_PPI_REG_C_KSO]);
            R = (byte)(R + TBL.Gi_M_Table64[MSX_PPI_REG_C_KCL]);
            R = (byte)(R + TBL.Gi_M_Table32[MSX_PPI_REG_C_CWT]);
            R = (byte)(R + TBL.Gi_M_Table16[MSX_PPI_REG_C_CMT]);
            R = (byte)(R + MSX_PPI_REG_C_KMT);
           
            return R;
        }

        public static void PUT_MSX_PPI_REG_C(byte iVal)
        {
            MSX_PPI_REG_C_KSO = (byte)((iVal & 128) == 0 ? 0 : 1); //1-bit Sound output, 1:on - 비트사운드출력
            MSX_PPI_REG_C_KCL = (byte)((iVal & 64) == 0 ? 0 : 1);  //Keyboard CAPS LED, 0:on
            MSX_PPI_REG_C_CWT = (byte)((iVal & 32) == 0 ? 0 : 1);  //Cassette Write Signal, 1:on
            MSX_PPI_REG_C_CMT = (byte)((iVal & 16) == 0 ? 0 : 1);  //Cassette Motor, 0:on
            MSX_PPI_REG_C_KMT = (byte)(iVal & 15);                 //Keyboard Matrix의 지정행번호 (0~10)
        }
  
        public static bool Gb_MSX_KEY_X()
        {
            return (((GetAsyncKeyState(88) & 32768) > 0) && (MSX.Gi_MSX_GotFocus == 1) ? true : false);
        }

        public static bool Gb_MSX_KEY_Z()
        {
            return (((GetAsyncKeyState(90) & 32768) > 0) && (MSX.Gi_MSX_GotFocus == 1) ? true : false);
        }

        public static bool Gb_MSX_KEY_Left()
        {
            return (((GetAsyncKeyState(37) & 32768) > 0) && (MSX.Gi_MSX_GotFocus == 1) ? true : false);
        }

        public static bool Gb_MSX_KEY_Right()
        {
            return (((GetAsyncKeyState(39) & 32768) > 0) && (MSX.Gi_MSX_GotFocus == 1) ? true : false);
        }

        public static bool Gb_MSX_KEY_Up()
        {
            return (((GetAsyncKeyState(38) & 32768) > 0) && (MSX.Gi_MSX_GotFocus == 1) ? true : false);
        }

        public static bool Gb_MSX_KEY_Down()
        {
            return (((GetAsyncKeyState(40) & 32768) > 0) && (MSX.Gi_MSX_GotFocus == 1) ? true : false);
        }

        public static void SET_MSX_KEY_STATUS()
        {
            byte T;

            sbyte Key7 = 0, Key6 = 0, Key5 = 0, Key4 = 0, Key3 = 0, Key2 = 0, Key1 = 0, Key0 = 0;

            sbyte iRet0, iRet1, iBreak, iTab;
            sbyte iSpc, iF09, iF12;
            sbyte NumS, NumP, NumA, NumK;

          //002C: 11 ;0001 0 001(1:International (QWERTY/other) Keyboard)
          //GetAsyncKeyState
          //0000h: 이전에 누른 적이 없고 호출 시점에 안 눌린 상태
          //0001h: 이전에 누른 적이 있고 호출 시점에 안 눌린 상태
          //8000h: 이전에 누른 적이 없고 호출 시점에 눌린 상태
          //8001h: 이전에 누른 적이 있고 호출 시점에 눌린 상태

            NumS = (sbyte)((GetAsyncKeyState(111) & 32768) > 0 ? 1 : 0); //[/]
            NumP = (sbyte)((GetAsyncKeyState(107) & 32768) > 0 ? 1 : 0); //[+]
            NumA = (sbyte)((GetAsyncKeyState(106) & 32768) > 0 ? 1 : 0); //[*]
            NumK = (sbyte)(NumP | NumA);

            T = 0;

            if (MSX.Gi_MSX_GotFocus != 1) goto LastProc;

          //7,6,5,4,3,2,1,0
            if (MSX_PPI_REG_C_KMT == 0)
            {
                Key7 = (sbyte)((GetAsyncKeyState(55) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(54) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(53) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(52) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(51) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(50) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(49) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)((GetAsyncKeyState(48) & 32768) > 0 ? 1 : 0);
                goto NextProc;
            };

          //;,],[,\,=,-,9,8
            if (MSX_PPI_REG_C_KMT == 1)
            {
                Key7 = (sbyte)((GetAsyncKeyState(186) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(221) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(219) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(220) & 32768) > 0 ? 1 : 0);
                if (MSX.GiMSX2 == 0)
                {
                    Key3 = (sbyte)((sbyte)((GetAsyncKeyState(187) & 32768) > 0 ? 1 : 0) | (NumP)); //[+]
                }
                else
                {
                    Key3 = (sbyte)((GetAsyncKeyState(187) & 32768) > 0 ? 1 : 0); //[+]
                };
                Key2 = (sbyte)((GetAsyncKeyState(189) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(57) & 32768) > 0 ? 1 : 0);
                if (MSX.GiMSX2 == 0)
                {
                    Key0 = (sbyte)((sbyte)((GetAsyncKeyState(56) & 32768) > 0 ? 1 : 0) | (NumA)); //[*]
                }
                else
                {
                    Key0 = (sbyte)((GetAsyncKeyState(56) & 32768) > 0 ? 1 : 0); //[*]
                };
                goto NextProc;
            };

          //B,A,DEAD-END,/,.>,,<,`~,'"
            if (MSX_PPI_REG_C_KMT == 2)
            {
                Key7 = (sbyte)((GetAsyncKeyState(66) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 0) Key6 = (sbyte)((GetAsyncKeyState(65) & 32768) > 0 ? 1 : 0); //A
                Key5 = (sbyte)((GetAsyncKeyState(35) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 1) Key5 = (sbyte)((GetAsyncKeyState(68) & 32768) > 0 ? 1 : 0); //D->-[DEAD]
                if (MSX.GiMSX2 == 0)
                {
                    Key4 = (sbyte)((sbyte)((GetAsyncKeyState(191) & 32768) > 0 ? 1 : 0) | (NumS));
                }
                else
                {
                    Key4 = (sbyte)((GetAsyncKeyState(191) & 32768) > 0 ? 1 : 0);
                };
                if (MSX.Gi_MSX_KeyChange == 1) Key4 = (sbyte)((GetAsyncKeyState(83) & 32768) > 0 ? 1 : 0); //->/?
                Key3 = (sbyte)((GetAsyncKeyState(190) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 1) Key3 = (sbyte)((GetAsyncKeyState(65) & 32768) > 0 ? 1 : 0); //A->.>
                Key2 = (sbyte)((GetAsyncKeyState(188) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(192) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)((GetAsyncKeyState(222) & 32768) > 0 ? 1 : 0);
                goto NextProc;
             };

          //J,I,H,G,F,E,D,C
            if (MSX_PPI_REG_C_KMT == 3)
            {
                Key7 = (sbyte)((GetAsyncKeyState(74) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(73) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(72) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(71) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 0) Key3 = (sbyte)((GetAsyncKeyState(70) & 32768) > 0 ? 1 : 0); //F
                Key2 = (sbyte)((GetAsyncKeyState(69) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 0) Key1 = (sbyte)((GetAsyncKeyState(68) & 32768) > 0 ? 1 : 0); //D
                Key0 = (sbyte)((GetAsyncKeyState(67) & 32768) > 0 ? 1 : 0);
                goto NextProc;
            };

          //R,Q,P,O,N,M,L,K
            if (MSX_PPI_REG_C_KMT == 4)
            {
                Key7 = (sbyte)((GetAsyncKeyState(82) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(81) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(80) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(79) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(78) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(77) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(76) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)((GetAsyncKeyState(75) & 32768) > 0 ? 1 : 0);
                goto NextProc;
            };

          //Z,Y,X,W,V,U,T,S
            if (MSX_PPI_REG_C_KMT == 5)
            {
                Key7 = (sbyte)((GetAsyncKeyState(90) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(89) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(88) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(87) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(86) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(85) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(84) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 0) Key0 = (sbyte)((GetAsyncKeyState(83) & 32768) > 0 ? 1 : 0); //S
                goto NextProc;
            };

          //F3[F8],F2[F7],F1[F6],CODE-F07,CAPLOCK,GRAPH-F08,CTRL,SHIFT
            if (MSX_PPI_REG_C_KMT == 6)
            {
              //iF08 = ((GetAsyncKeyState(119) & 32768) > 0 ? 1 : 0); 'F08
              //iHanEng = ((GetAsyncKeyState(229) & 32768) > 0 ? 1 : 0); '한/영
              //iHanJa = ((GetAsyncKeyState(25) & 32768) > 0 ? 1 : 0); '한자
                Key7 = (sbyte)((GetAsyncKeyState(114) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(113) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(112) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(118) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(20) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(119) & 32768) > 0 ? 1 : 0);
                if (MSX.Gi_MSX_KeyChange == 1) Key2 = (sbyte)((GetAsyncKeyState(70) & 32768) > 0 ? 1 : 0); //F->GRAPH
                Key1 = (sbyte)((GetAsyncKeyState(17) & 32768) > 0 ? 1 : 0);
                if (MSX.GiMSX2 == 0)
                {
                    Key0 = (sbyte)((sbyte)((GetAsyncKeyState(16) & 32768) > 0 ? 1 : 0) | (NumK)); //Shift
                }
                else
                {
                    Key0 = (sbyte)((GetAsyncKeyState(16) & 32768) > 0 ? 1 : 0); //Shift
                };
                goto NextProc;
            };

          //RETURN,SELECT-F11,BS,STOP-BREAK/PAUSE/F12,TAB-F9,ESC,F5[F10],F4[F9]
            if (MSX_PPI_REG_C_KMT == 7)
            {
                iRet0 = (sbyte)((GetAsyncKeyState(13) & 32768) > 0 ? 1 : 0); //Enter
                iRet1 = (sbyte)((GetAsyncKeyState(108) & 32768) > 0 ? 1 : 0); //Num Enter
                iBreak = (sbyte)((GetAsyncKeyState(19) & 32768) > 0 ? 1 : 0); //Pause/Break
                iTab = (sbyte)((GetAsyncKeyState(9) & 32768) > 0 ? 1 : 0); //Tab
                iF09 = (sbyte)((GetAsyncKeyState(120) & 32768) > 0 ? 1 : 0); //F09
                iF12 = (sbyte)((GetAsyncKeyState(123) & 32768) > 0 ? 1 : 0); //F12
                Key7 = (sbyte)(iRet0 | iRet1);
                Key6 = (sbyte)((GetAsyncKeyState(122) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(8) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)(iBreak | iF12);
                Key3 = (sbyte)(iTab | iF09);
                Key2 = (sbyte)((GetAsyncKeyState(27) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(116) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)((GetAsyncKeyState(115) & 32768) > 0 ? 1 : 0);
                goto NextProc;
            };

          //RIGHT,DOWN,UP,LEFT,DEL,INS,HOME[CLS],SPACE
            if (MSX_PPI_REG_C_KMT == 8)
            {
                iSpc = (sbyte)((GetAsyncKeyState(32) & 32768) > 0 ? 1 : 0); //Space
                Key7 = (sbyte)((GetAsyncKeyState(39) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(40) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(38) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(37) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(46) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(45) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(36) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)(iSpc | MSX.Gi_MSX_SpaceOn);
                goto NextProc;
            };

          //키패드 4,3,2,1,0,/,+,*
            if (MSX_PPI_REG_C_KMT == 9)
            {
                Key7 = (sbyte)((GetAsyncKeyState(100) & 32768) > 0 ? 1 : 0);
                Key6 = (sbyte)((GetAsyncKeyState(99) & 32768) > 0 ? 1 : 0);
                Key5 = (sbyte)((GetAsyncKeyState(98) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(97) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(96) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(111) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(107) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)((GetAsyncKeyState(106) & 32768) > 0 ? 1 : 0);
                goto NextProc;
            };

          //키피드 .,,-NOT,-,9,8,7,6,5
            if (MSX_PPI_REG_C_KMT == 10)
            {
                Key7 = (sbyte)((GetAsyncKeyState(110) & 32768) > 0 ? 1 : 0);
                Key6 = 0;
                Key5 = (sbyte)((GetAsyncKeyState(109) & 32768) > 0 ? 1 : 0);
                Key4 = (sbyte)((GetAsyncKeyState(105) & 32768) > 0 ? 1 : 0);
                Key3 = (sbyte)((GetAsyncKeyState(104) & 32768) > 0 ? 1 : 0);
                Key2 = (sbyte)((GetAsyncKeyState(103) & 32768) > 0 ? 1 : 0);
                Key1 = (sbyte)((GetAsyncKeyState(102) & 32768) > 0 ? 1 : 0);
                Key0 = (sbyte)((GetAsyncKeyState(101) & 32768) > 0 ? 1 : 0);
                goto NextProc;
            };

        NextProc: ;
            if (Key7 == 1) T = (byte)(T | 128);
            if (Key6 == 1) T = (byte)(T | 64);
            if (Key5 == 1) T = (byte)(T | 32);
            if (Key4 == 1) T = (byte)(T | 16);
            if (Key3 == 1) T = (byte)(T | 8);
            if (Key2 == 1) T = (byte)(T | 4);
            if (Key1 == 1) T = (byte)(T | 2);
            if (Key0 == 1) T = (byte)(T | 1);

        LastProc: ;
            MSX_PPI_REG_B = Z80A.giGetIntToInt(~T); //부정NOT
        }
    }
}

//Home = 6
//BackSpace = 8
//Tab = 9
//Enter = 13
//Shift = 16
//Ctrl = 17
//Alt = 18
//Cap Lock = 20
//한자 = 25
//Esc = 27
//Space = 32
//PageUp = 33
//PageDown = 34
//End = 35
//Left = 37
//Up = 38
//Right = 39
//Down = 40
//Insert = 45
//Delete = 46
//A~ = 65~
//0~ = 96~
//F1 ~ = 112~
//한/영 = 229

//Home = 6
//BackSpace = 8
//Tab = 9
//Enter = 13
//Shift = 16
//Ctrl = 17
//Alt = 18
//Cap Lock = 20
//한자 = 25
//Esc = 27
//Space = 32
//PageUp = 33
//PageDown = 34
//End = 35
//Left = 37
//Up = 38
//Right = 39
//Down = 40
//Insert = 45
//Delete = 46
//A~ = 65~
//0~ = 96~
//F1 ~ = 112~
//한/영 = 229
