﻿using System.Runtime.InteropServices;

namespace csMSX2
{
    public static class PSGOUT
    {
        [DllImport("winmm.dll")] public static extern int midiOutOpen(ref int lphMidiOut, int uDeviceID, int dwCallback, int dwInstance, int dwFlags);
        [DllImport("winmm.dll")] public static extern int midiOutClose(int hMidiOut);
        [DllImport("winmm.dll")] public static extern int midiOutReset(int hMidiOut);
        [DllImport("winmm.dll")] public static extern int midiOutShortMsg(int hMidiOut, int dwMsg);

        public static int Gi_MDH;
        public static bool Gb_MidiOpened;

        public const byte fiMaxVol = 127;

        public const int fiMidi = 71;   //71:Clarinet, 80:Square Wave
        public const int fiMidi2 = 0;   //0:Grand Piano
        public const int fiNoise = 127; //127:Gunshot

        public static void gt_MSX_Midi_Open()
        {
          //핸들,Mapper,0,0,CallBack_Null
            if (midiOutOpen(ref Gi_MDH, 0, 0, 0, 0) == 0) //Gi_MDH<-미디를열고핸들을저장
            {
                Gb_MidiOpened = true;
                gt_MSX_Midi_Out(0xC0, 1, fiMidi, 0); //악기선택
                gt_MSX_Midi_Out(0xC0, 2, fiMidi, 0);
                gt_MSX_Midi_Out(0xC0, 3, fiMidi, 0);
                gt_MSX_Midi_Out(0xC0, 4, fiNoise, 0); //악기선택
                gt_MSX_Midi_Out(0xC0, 5, fiNoise, 0);
                gt_MSX_Midi_Out(0xC0, 6, fiNoise, 0);
            };
        }

        public static void gt_MSX_Midi_Close()
        {
          //핸들
            if (Gb_MidiOpened)
            {
                midiOutReset(Gi_MDH);
                midiOutClose(Gi_MDH); //미디닫기(Gi_MDH핸들)
                Gb_MidiOpened = false;
            };
        }

        public static void gt_MSX_Midi_Out(byte iCmd, byte iChannel, byte iTone, byte iVolume)
        {
          //핸들,명령코드,채널(0~15),파라미터1(톤0~127),파라미터2(볼륨0~127)
          //명령코드 90h~9Fh(채널1~16)-노트On, 80h~8Fh(채널1~16)-노트Off
          //         C0h~CFh(채널1~16)-악기변경,D0h~DFh-ChannelAfterTouch,E0h~EFh-ChannelPitchWheel
          //60=도,61=도#,62=레
            if (Gb_MidiOpened)
            {
                midiOutShortMsg(Gi_MDH, (int)((iCmd + iChannel - 1) | (iTone * 256) | (iVolume * 65536)));
            };
        }

        public static void MSX_PSG_TONE_OUT_A(sbyte iOn)
        {
            if ((iOn == 0) && (PSG.Gi_MIDI_TON_A >= 0))
            {
                if ((PSG.Gi_MSX_PSG_T_ON_A_Bak == 0) || (PSG.Gi_MIDI_TON_A_Bak != PSG.Gi_MIDI_TON_A) || (PSG.Gi_MIDI_VEV_A_Bak != PSG.Gi_MSX_PSG_VEV_A) || (PSG.Gi_MIDI_VOL_A_Bak != PSG.Gi_MIDI_VOL_A))
                {
                    if (PSG.Gi_MSX_PSG_T_ON_A_Bak == 1) { gt_MSX_Midi_Out(0x80, 1, (byte)PSG.Gi_MIDI_TON_A_Bak, 0); PSG.Gi_MSX_PSG_T_ON_A_Bak = 0; };
                    if ((PSG.Gi_MIDI_VEV_A_Bak != PSG.Gi_MSX_PSG_VEV_A))
                    {
                        if ((PSG.Gi_MSX_PSG_VEV_A == 0))
                        {
                            gt_MSX_Midi_Out(0xC0, 1, fiMidi, 0); //악기선택
                        }
                        else
                        {
                            gt_MSX_Midi_Out(0xC0, 1, fiMidi2, 0); //악기선택
                        };
                    };
                    if ((PSG.Gi_MSX_PSG_VEV_A == 0) && (PSG.Gi_MIDI_VOL_A > 0)) { gt_MSX_Midi_Out(0x90, 1, (byte)PSG.Gi_MIDI_TON_A, (byte)PSG.Gi_MIDI_VOL_A); PSG.Gi_MSX_PSG_T_ON_A_Bak = 1; };
                    if (PSG.Gi_MSX_PSG_VEV_A == 1) { gt_MSX_Midi_Out(0x90, 1, (byte)PSG.Gi_MIDI_TON_A, fiMaxVol); PSG.Gi_MSX_PSG_T_ON_A_Bak = 1; };
                };
                PSG.Gi_MIDI_TON_A_Bak = PSG.Gi_MIDI_TON_A;
                PSG.Gi_MIDI_VEV_A_Bak = PSG.Gi_MSX_PSG_VEV_A;
                PSG.Gi_MIDI_VOL_A_Bak = PSG.Gi_MIDI_VOL_A;
            }
            else
            {
                if (PSG.Gi_MSX_PSG_T_ON_A_Bak == 1) { gt_MSX_Midi_Out(0x80, 1, (byte)PSG.Gi_MIDI_TON_A_Bak, 0); PSG.Gi_MSX_PSG_T_ON_A_Bak = 0; }
            };
        }

        public static void MSX_PSG_TONE_OUT_B(sbyte iOn)
        {
            if ((iOn == 0) && (PSG.Gi_MIDI_TON_B >= 0))
            {
                if ((PSG.Gi_MSX_PSG_T_ON_B_Bak == 0) || (PSG.Gi_MIDI_TON_B_Bak != PSG.Gi_MIDI_TON_B) || (PSG.Gi_MIDI_VEV_B_Bak != PSG.Gi_MSX_PSG_VEV_B) || (PSG.Gi_MIDI_VOL_B_Bak != PSG.Gi_MIDI_VOL_B))
                {
                    if (PSG.Gi_MSX_PSG_T_ON_B_Bak == 1) { gt_MSX_Midi_Out(0x80, 2, (byte)PSG.Gi_MIDI_TON_B_Bak, 0); PSG.Gi_MSX_PSG_T_ON_B_Bak = 0; };
                    if ((PSG.Gi_MIDI_VEV_B_Bak != PSG.Gi_MSX_PSG_VEV_B))
                    {
                        if ((PSG.Gi_MSX_PSG_VEV_B == 0))
                        {
                            gt_MSX_Midi_Out(0xC0, 2, fiMidi, 0); //악기선택
                        }
                        else
                        {
                            gt_MSX_Midi_Out(0xC0, 2, fiMidi2, 0); //악기선택
                        };
                    };
                    if ((PSG.Gi_MSX_PSG_VEV_B == 0) && (PSG.Gi_MIDI_VOL_B > 0)) { gt_MSX_Midi_Out(0x90, 2, (byte)PSG.Gi_MIDI_TON_B, (byte)PSG.Gi_MIDI_VOL_B); PSG.Gi_MSX_PSG_T_ON_B_Bak = 1; };
                    if (PSG.Gi_MSX_PSG_VEV_B == 1) { gt_MSX_Midi_Out(0x90, 2, (byte)PSG.Gi_MIDI_TON_B, fiMaxVol); PSG.Gi_MSX_PSG_T_ON_B_Bak = 1; };
                };
                PSG.Gi_MIDI_TON_B_Bak = PSG.Gi_MIDI_TON_B;
                PSG.Gi_MIDI_VEV_B_Bak = PSG.Gi_MSX_PSG_VEV_B;
                PSG.Gi_MIDI_VOL_B_Bak = PSG.Gi_MIDI_VOL_B;
            }
            else
            {
                if (PSG.Gi_MSX_PSG_T_ON_B_Bak == 1) { gt_MSX_Midi_Out(0x80, 2, (byte)PSG.Gi_MIDI_TON_B_Bak, 0); PSG.Gi_MSX_PSG_T_ON_B_Bak = 0; }
            };
        }

        public static void MSX_PSG_TONE_OUT_C(sbyte iOn)
        {
            if ((iOn == 0) && (PSG.Gi_MIDI_TON_C >= 0))
            {
                if ((PSG.Gi_MSX_PSG_T_ON_C_Bak == 0) || (PSG.Gi_MIDI_TON_C_Bak != PSG.Gi_MIDI_TON_C) || (PSG.Gi_MIDI_VEV_C_Bak != PSG.Gi_MSX_PSG_VEV_C) || (PSG.Gi_MIDI_VOL_C_Bak != PSG.Gi_MIDI_VOL_C))
                {
                    if (PSG.Gi_MSX_PSG_T_ON_C_Bak == 1) { gt_MSX_Midi_Out(0x80, 3, (byte)PSG.Gi_MIDI_TON_C_Bak, 0); PSG.Gi_MSX_PSG_T_ON_C_Bak = 0; };
                    if ((PSG.Gi_MIDI_VEV_C_Bak != PSG.Gi_MSX_PSG_VEV_C))
                    {
                        if ((PSG.Gi_MSX_PSG_VEV_C == 0))
                        {
                            gt_MSX_Midi_Out(0xC0, 3, fiMidi, 0); //악기선택
                        }
                        else
                        {
                            gt_MSX_Midi_Out(0xC0, 3, fiMidi2, 0); //악기선택                    
                        };
                    };
                    if ((PSG.Gi_MSX_PSG_VEV_C == 0) && (PSG.Gi_MIDI_VOL_C > 0)) { gt_MSX_Midi_Out(0x90, 3, (byte)PSG.Gi_MIDI_TON_C, (byte)PSG.Gi_MIDI_VOL_C); PSG.Gi_MSX_PSG_T_ON_C_Bak = 1; };
                    if (PSG.Gi_MSX_PSG_VEV_C == 1) { gt_MSX_Midi_Out(0x90, 3, (byte)PSG.Gi_MIDI_TON_C, fiMaxVol); PSG.Gi_MSX_PSG_T_ON_C_Bak = 1; };
                };
                PSG.Gi_MIDI_TON_C_Bak = PSG.Gi_MIDI_TON_C;
                PSG.Gi_MIDI_VEV_C_Bak = PSG.Gi_MSX_PSG_VEV_C;
                PSG.Gi_MIDI_VOL_C_Bak = PSG.Gi_MIDI_VOL_C;
            }
            else
            {
                if (PSG.Gi_MSX_PSG_T_ON_C_Bak == 1) { gt_MSX_Midi_Out(0x80, 3, (byte)PSG.Gi_MIDI_TON_C_Bak, 0); PSG.Gi_MSX_PSG_T_ON_C_Bak = 0; }
            };
        }

        public static void MSX_PSG_NOISE_OUT_A(sbyte iOn)
        {
            if ((iOn == 0) && (PSG.Gi_MIDI_TON_NS >= 0))
            {
                if ((PSG.Gi_MSX_PSG_VEV_A == 0) && (PSG.Gi_MIDI_VOL_A > 0)) gt_MSX_Midi_Out(0x90, 4, (byte)PSG.Gi_MIDI_TON_NS, (byte)PSG.Gi_MIDI_VOL_A);
                if ((PSG.Gi_MSX_PSG_VEV_A == 1)) gt_MSX_Midi_Out(0x90, 4, (byte)PSG.Gi_MIDI_TON_NS, fiMaxVol);
            };
        }

        public static void MSX_PSG_NOISE_OUT_B(sbyte iOn)
        {
            if ((iOn == 0) && (PSG.Gi_MIDI_TON_NS >= 0))
            {
                if ((PSG.Gi_MSX_PSG_VEV_B == 0) && (PSG.Gi_MIDI_VOL_B > 0)) gt_MSX_Midi_Out(0x90, 5, (byte)PSG.Gi_MIDI_TON_NS, (byte)PSG.Gi_MIDI_VOL_B);
                if ((PSG.Gi_MSX_PSG_VEV_B == 1)) gt_MSX_Midi_Out(0x90, 5, (byte)PSG.Gi_MIDI_TON_NS, fiMaxVol);
            };
        }

        public static void MSX_PSG_NOISE_OUT_C(sbyte iOn)
        {
            if ((iOn == 0) && (PSG.Gi_MIDI_TON_NS >= 0))
            {
                if ((PSG.Gi_MSX_PSG_VEV_C == 0) && (PSG.Gi_MIDI_VOL_C > 0)) gt_MSX_Midi_Out(0x90, 6, (byte)PSG.Gi_MIDI_TON_NS, (byte)PSG.Gi_MIDI_VOL_C);
                if ((PSG.Gi_MSX_PSG_VEV_C == 1)) gt_MSX_Midi_Out(0x90, 6, (byte)PSG.Gi_MIDI_TON_NS, fiMaxVol);
            };
        }
    }
}
