﻿using System;
using System.IO;
using System.Runtime.InteropServices;

namespace csMSX2
{
    public static class MSL
    {
        public static void MsxSaveStatus()
        {
            byte b, bh = 0, bl = 0;

            string FileName;

            FileName = "C:\\MSX-" + DateTime.Now.ToString("yyyyMMdd") + "-" + DateTime.Now.ToString("HHmmss") + ".MSX";

            BinaryWriter bw = new BinaryWriter(File.Open(FileName, FileMode.Create));
                 
          //Z80A
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_PC, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_SP, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_IX, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(Z80A.Z80A_REG_IY, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = Z80A.Z80A_REG_A; bw.Write(b);
            b = Z80A.Z80A_REG_F; bw.Write(b);
            b = Z80A.Z80A_REG_B; bw.Write(b);
            b = Z80A.Z80A_REG_C; bw.Write(b);
            b = Z80A.Z80A_REG_D; bw.Write(b);
            b = Z80A.Z80A_REG_E; bw.Write(b);
            b = Z80A.Z80A_REG_H; bw.Write(b);
            b = Z80A.Z80A_REG_L; bw.Write(b);
            b = Z80A.Z80A_REG_A2; bw.Write(b);
            b = Z80A.Z80A_REG_F2; bw.Write(b);
            b = Z80A.Z80A_REG_B2; bw.Write(b);
            b = Z80A.Z80A_REG_C2; bw.Write(b);
            b = Z80A.Z80A_REG_D2; bw.Write(b);
            b = Z80A.Z80A_REG_E2; bw.Write(b);
            b = Z80A.Z80A_REG_H2; bw.Write(b);
            b = Z80A.Z80A_REG_L2; bw.Write(b);
            b = Z80A.Z80A_REG_I; bw.Write(b);
            b = Z80A.Z80A_REG_R; bw.Write(b);
            b = (byte)Z80A.Z80A_REG_IFF1; bw.Write(b);
            b = (byte)Z80A.Z80A_REG_IFF2; bw.Write(b);

          //INT
            b = (byte)INT.Gi_MSX_Interrupt; bw.Write(b);
            Z80A.gtMoveLngToIntHL(INT.Go_MSX_InterruptBack, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)INT.Z80A_INT_MODE; bw.Write(b);
            b = (byte)INT.Z80A_HALT; bw.Write(b);

          //MEM
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 65536; j++)
                {
                    b = MEM.MSX_MEM[i, j]; bw.Write(b);
                };
            };
            b = (byte)MEM.Gi_MEM_PAGE0; bw.Write(b);
            b = (byte)MEM.Gi_MEM_PAGE1; bw.Write(b);
            b = (byte)MEM.Gi_MEM_PAGE2; bw.Write(b);
            b = (byte)MEM.Gi_MEM_PAGE3; bw.Write(b);
            b = (byte)MEM.Gi_MEM_EXT_PAGE0; bw.Write(b);
            b = (byte)MEM.Gi_MEM_EXT_PAGE1; bw.Write(b);
            b = (byte)MEM.Gi_MEM_EXT_PAGE2; bw.Write(b);
            b = (byte)MEM.Gi_MEM_EXT_PAGE3; bw.Write(b);
            for (int i = 0; i < 4194304; i++)
            {
                b = MEM.MSX_ROM[i]; bw.Write(b);
            };
            b = (byte)MEM.Gi_Big32K_ROM; bw.Write(b);
            for (int i = 0; i < 4194304; i++)
            {
                b = MEM.MSX_RAM[i]; bw.Write(b);
            };
            b = MEM.Gi_RAM_PAGE0; bw.Write(b);
            b = MEM.Gi_RAM_PAGE1; bw.Write(b);
            b = MEM.Gi_RAM_PAGE2; bw.Write(b);
            b = MEM.Gi_RAM_PAGE3; bw.Write(b);

          //IO
            for (int i = 0; i < 256; i++)
            {
                b = IO.MSX_PORT[i]; bw.Write(b);
            };
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 16; j++)
                {
                    b = IO.MSX_CLOCK_REG[i, j]; bw.Write(b);
                };
            };
            b = (byte)IO.Gi_MSX_PortWrite; bw.Write(b);

          //PPI
            b = PPI.MSX_PPI_REG_B; bw.Write(b);
            b = PPI.MSX_PPI_REG_C_KSO; bw.Write(b);
            b = PPI.MSX_PPI_REG_C_KCL; bw.Write(b);
            b = PPI.MSX_PPI_REG_C_CWT; bw.Write(b);
            b = PPI.MSX_PPI_REG_C_CMT; bw.Write(b);
            b = PPI.MSX_PPI_REG_C_KMT; bw.Write(b);

          //VDT
            for (int i = 0; i < 131072; i++)
            {
                b = VDT.MSX_VRAM[i]; bw.Write(b);
            };
            for (int i = 0; i < 47; i++)
            {
                b = VDT.MSX_VDT_REG[i]; bw.Write(b);
            };
            b = VDT.MSX_VDT_REG_IE1; bw.Write(b);
            b = VDT.MSX_VDT_REG_EV; bw.Write(b);
            b = VDT.MSX_VDT_REG_16K; bw.Write(b);
            b = VDT.MSX_VDT_REG_ON; bw.Write(b);
            b = VDT.MSX_VDT_REG_IE0; bw.Write(b);
            b = VDT.MSX_VDT_REG_SZ; bw.Write(b);
            b = VDT.MSX_VDT_REG_SM; bw.Write(b);
            b = VDT.MSX_VDT_REG_TP; bw.Write(b);
            b = VDT.MSX_VDT_REG_SPD; bw.Write(b);
            b = VDT.MSX_VDT_REG_LN; bw.Write(b);
            b = VDT.MSX_VDT_REG_IL; bw.Write(b);
            b = VDT.MSX_VDT_REG_EO; bw.Write(b);
            for (int i = 0; i < 131072; i++)
            {
                b = VDT.MSX_VRAM_Buff[i]; bw.Write(b);
            };
            Z80A.gtMoveLngToIntHL((ushort)VDT.Go_MSX_VRAM_Buff_Size, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)VDT.Go_MSX_VRAM_Buff_Count, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_SX, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_SY, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_DX, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_DY, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_NX, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_Mjg, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_NY, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL(VDT.Go_MSX_VDT_CMD_REG_Min, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = VDT.Gi_MSX_VDT_CMD_REG_Color; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_MXC; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_MXD; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_MXS; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_DIY; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_DIX; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_EQ; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_MAJ; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_CMD; bw.Write(b);
            b = VDT.MSX_VDT_CMD_REG_LO; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_FF; bw.Write(b);
            b = VDT.Gi_MSX_VDT_ST_REG_FF; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_5S; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_C; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_5SN; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_FL; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_LPS; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_ID; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_FH; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_TR; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_VR; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_HR; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_BD; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_EO; bw.Write(b);
            b = VDT.MSX_VDT_ST_REG_CE; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)VDT.Go_MSX_VDT_ST_REG_Column, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)VDT.Go_MSX_VDT_ST_REG_Row, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = VDT.Gi_MSX_VDT_ST_REG_Color; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)VDT.Go_MSX_VDT_ST_REG_BX, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)VDT.Gi_MSX_SCREEN_MODE; bw.Write(b);
            b = (byte)VDT.Gi_MSX_VRAM_IO; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)VDT.Go_MSX_VRAM_ADDRESS, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)VDT.Gi_MSX_VRAM_Flg; bw.Write(b);
            b = (byte)VDT.Gi_MSX2_VRAM_Flg; bw.Write(b);
            for (int i = 0; i < 16; i++)
            {
                b = VDT.MSX_VDT_REG_PAL_Red[i]; bw.Write(b);
                b = VDT.MSX_VDT_REG_PAL_Green[i]; bw.Write(b);
                b = VDT.MSX_VDT_REG_PAL_Blue[i]; bw.Write(b);
            };

          //PSG
            for (int i = 0; i < 16; i++)
            {
                b = PSG.MSX_PSG_REG[i]; bw.Write(b);
            };
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_A, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_VEV_A; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_VOL_A; bw.Write(b);
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_B, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_VEV_B; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_VOL_B; bw.Write(b);
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_C, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_VEV_C; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_VOL_C; bw.Write(b);
            b = (byte)PSG.Go_MSX_PSG_NOISE; bw.Write(b);
            Z80A.gtMoveLngToIntHL(PSG.Go_MSX_PSG_TONE_EV, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_PATN_EV; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_T_ON_A; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_T_ON_B; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_T_ON_C; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_N_ON_A; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_N_ON_B; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_N_ON_C; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_A, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_B, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_C, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_NS, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VOL_A; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VOL_B; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VOL_C; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_T_ON_A_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_T_ON_B_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MSX_PSG_T_ON_C_Bak; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_A_Bak, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_B_Bak, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            Z80A.gtMoveLngToIntHL((ushort)PSG.Gi_MIDI_TON_C_Bak, ref bh, ref bl);
            b = bl; bw.Write(b);
            b = bh; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VEV_A_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VEV_B_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VEV_C_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VOL_A_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VOL_B_Bak; bw.Write(b);
            b = (byte)PSG.Gi_MIDI_VOL_C_Bak; bw.Write(b);

            bw.Close();
        }

        public static void MsxLoadStatus(string FileName)
        {
            byte bh = 0, bl = 0;

            BinaryReader br = new BinaryReader(new FileStream(FileName, FileMode.Open));

          //Z80A
            bl = br.ReadByte();
            bh = br.ReadByte();
            Z80A.Z80A_REG_PC = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            Z80A.Z80A_REG_SP = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            Z80A.Z80A_REG_IX = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            Z80A.Z80A_REG_IY = Z80A.goGetIntHLToLng(bh, bl);
            Z80A.Z80A_REG_A = br.ReadByte();
            Z80A.Z80A_REG_F = br.ReadByte();
            Z80A.Z80A_REG_B = br.ReadByte();
            Z80A.Z80A_REG_C = br.ReadByte();
            Z80A.Z80A_REG_D = br.ReadByte();
            Z80A.Z80A_REG_E = br.ReadByte();
            Z80A.Z80A_REG_H = br.ReadByte();
            Z80A.Z80A_REG_L = br.ReadByte();
            Z80A.Z80A_REG_A2 = br.ReadByte();
            Z80A.Z80A_REG_F2 = br.ReadByte();
            Z80A.Z80A_REG_B2 = br.ReadByte();
            Z80A.Z80A_REG_C2 = br.ReadByte();
            Z80A.Z80A_REG_D2 = br.ReadByte();
            Z80A.Z80A_REG_E2 = br.ReadByte();
            Z80A.Z80A_REG_H2 = br.ReadByte();
            Z80A.Z80A_REG_L2 = br.ReadByte();
            Z80A.Z80A_REG_I = br.ReadByte();
            Z80A.Z80A_REG_R = br.ReadByte();
            Z80A.Z80A_REG_IFF1 = (sbyte)br.ReadByte();
            Z80A.Z80A_REG_IFF2 = (sbyte)br.ReadByte();

          //INT
            INT.Gi_MSX_Interrupt = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            INT.Go_MSX_InterruptBack = Z80A.goGetIntHLToLng(bh, bl);
            INT.Z80A_INT_MODE = (sbyte)br.ReadByte();
            INT.Z80A_HALT = (sbyte)br.ReadByte();

          //MEM
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 65536; j++)
                {
                    MEM.MSX_MEM[i, j] = br.ReadByte();
                };
            };
            MEM.Gi_MEM_PAGE0 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_PAGE1 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_PAGE2 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_PAGE3 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_EXT_PAGE0 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_EXT_PAGE1 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_EXT_PAGE2 = (sbyte)br.ReadByte();
            MEM.Gi_MEM_EXT_PAGE3 = (sbyte)br.ReadByte();
            for (int i = 0; i < 4194304; i++)
            {
                MEM.MSX_ROM[i] = br.ReadByte();
            };
            MEM.Gi_Big32K_ROM = (sbyte)br.ReadByte();
            for (int i = 0; i < 4194304; i++)
            {
                MEM.MSX_RAM[i] = br.ReadByte();
            };
            MEM.Gi_RAM_PAGE0 = br.ReadByte();
            MEM.Gi_RAM_PAGE1 = br.ReadByte();
            MEM.Gi_RAM_PAGE2 = br.ReadByte();
            MEM.Gi_RAM_PAGE3 = br.ReadByte();

          //IO
            for (int i = 0; i < 256; i++)
            {
                IO.MSX_PORT[i] = br.ReadByte();
            };
            for (int i = 0; i < 4; i++)
            {
                for (int j = 0; j < 16; j++)
                {
                    IO.MSX_CLOCK_REG[i, j] = br.ReadByte();
                };
            };
            IO.Gi_MSX_PortWrite = (sbyte)br.ReadByte();

          //PPI
            PPI.MSX_PPI_REG_B = br.ReadByte();
            PPI.MSX_PPI_REG_C_KSO = br.ReadByte();
            PPI.MSX_PPI_REG_C_KCL = br.ReadByte();
            PPI.MSX_PPI_REG_C_CWT = br.ReadByte();
            PPI.MSX_PPI_REG_C_CMT = br.ReadByte();
            PPI.MSX_PPI_REG_C_KMT = br.ReadByte();

          //VDT
            for (int i = 0; i < 131072; i++)
            {
                VDT.MSX_VRAM[i] = br.ReadByte();
            };
            for (int i = 0; i < 47; i++)
            {
                VDT.MSX_VDT_REG[i] = br.ReadByte();
            };
            VDT.MSX_VDT_REG_IE1 = br.ReadByte();
            VDT.MSX_VDT_REG_EV = br.ReadByte();
            VDT.MSX_VDT_REG_16K = br.ReadByte();
            VDT.MSX_VDT_REG_ON = br.ReadByte();
            VDT.MSX_VDT_REG_IE0 = br.ReadByte();
            VDT.MSX_VDT_REG_SZ  = br.ReadByte();
            VDT.MSX_VDT_REG_SM = br.ReadByte();
            VDT.MSX_VDT_REG_TP = br.ReadByte();
            VDT.MSX_VDT_REG_SPD = br.ReadByte();
            VDT.MSX_VDT_REG_LN = br.ReadByte();
            VDT.MSX_VDT_REG_IL = br.ReadByte();
            VDT.MSX_VDT_REG_EO = br.ReadByte();
            for (int i = 0; i < 131072; i++)
            {
                VDT.MSX_VRAM_Buff[i] = br.ReadByte();
            };
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VRAM_Buff_Size = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VRAM_Buff_Count = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_SX = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_DX = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_NX = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_Mjg = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_CMD_REG_Min = Z80A.goGetIntHLToLng(bh, bl);
            VDT.Gi_MSX_VDT_CMD_REG_Color = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_MXC = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_MXD = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_MXS = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_DIY = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_DIX = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_EQ = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_MAJ = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_CMD = br.ReadByte();
            VDT.MSX_VDT_CMD_REG_LO = br.ReadByte();
            VDT.MSX_VDT_ST_REG_FF = br.ReadByte();
            VDT.Gi_MSX_VDT_ST_REG_FF = br.ReadByte();
            VDT.MSX_VDT_ST_REG_5S = br.ReadByte();
            VDT.MSX_VDT_ST_REG_C = br.ReadByte();
            VDT.MSX_VDT_ST_REG_5SN = br.ReadByte();
            VDT.MSX_VDT_ST_REG_FL = br.ReadByte();
            VDT.MSX_VDT_ST_REG_LPS = br.ReadByte();
            VDT.MSX_VDT_ST_REG_ID = br.ReadByte();
            VDT.MSX_VDT_ST_REG_FH = br.ReadByte();
            VDT.MSX_VDT_ST_REG_TR = br.ReadByte();
            VDT.MSX_VDT_ST_REG_VR = br.ReadByte();
            VDT.MSX_VDT_ST_REG_HR = br.ReadByte();
            VDT.MSX_VDT_ST_REG_BD = br.ReadByte();
            VDT.MSX_VDT_ST_REG_EO = br.ReadByte();
            VDT.MSX_VDT_ST_REG_CE = br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_ST_REG_Column = Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_ST_REG_Row = Z80A.goGetIntHLToLng(bh, bl);
            VDT.Gi_MSX_VDT_ST_REG_Color = br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VDT_ST_REG_BX = Z80A.goGetIntHLToLng(bh, bl);
            VDT.Gi_MSX_SCREEN_MODE = (sbyte)br.ReadByte();
            VDT.Gi_MSX_VRAM_IO = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            VDT.Go_MSX_VRAM_ADDRESS = Z80A.goGetIntHLToLng(bh, bl);
            VDT.Gi_MSX_VRAM_Flg = (sbyte)br.ReadByte();
            VDT.Gi_MSX2_VRAM_Flg = (sbyte)br.ReadByte();
            for (int i = 0; i < 16; i++)
            {
                VDT.MSX_VDT_REG_PAL_Red[i] = br.ReadByte();
                VDT.MSX_VDT_REG_PAL_Green[i] = br.ReadByte();
                VDT.MSX_VDT_REG_PAL_Blue[i] = br.ReadByte();
                VDT.MSX_COLOR_PALETTE((byte)i, VDT.MSX_VDT_REG_PAL_Red[i], VDT.MSX_VDT_REG_PAL_Green[i], VDT.MSX_VDT_REG_PAL_Blue[i]);
            };

          //PSG
            for (int i = 0; i < 16; i++)
            {
                PSG.MSX_PSG_REG[i] = br.ReadByte();
            };
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Go_MSX_PSG_TONE_A = Z80A.goGetIntHLToLng(bh, bl);
            PSG.Gi_MSX_PSG_VEV_A = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_VOL_A = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Go_MSX_PSG_TONE_B = Z80A.goGetIntHLToLng(bh, bl);
            PSG.Gi_MSX_PSG_VEV_B = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_VOL_B = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Go_MSX_PSG_TONE_C = Z80A.goGetIntHLToLng(bh, bl);
            PSG.Gi_MSX_PSG_VEV_C = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_VOL_C = (sbyte)br.ReadByte();
            PSG.Go_MSX_PSG_NOISE = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Go_MSX_PSG_TONE_EV = Z80A.goGetIntHLToLng(bh, bl);
            PSG.Gi_MSX_PSG_PATN_EV = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_T_ON_A = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_T_ON_B = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_T_ON_C = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_N_ON_A = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_N_ON_B = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_N_ON_C = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_A = (short)Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_B = (short)Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_C = (short)Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_NS = (short)Z80A.goGetIntHLToLng(bh, bl);
            PSG.Gi_MIDI_VOL_A = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VOL_B = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VOL_C = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_T_ON_A_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_T_ON_B_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MSX_PSG_T_ON_C_Bak = (sbyte)br.ReadByte();
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_A_Bak = (short)Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_B_Bak = (short)Z80A.goGetIntHLToLng(bh, bl);
            bl = br.ReadByte();
            bh = br.ReadByte();
            PSG.Gi_MIDI_TON_C_Bak = (short)Z80A.goGetIntHLToLng(bh, bl);
            PSG.Gi_MIDI_VEV_A_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VEV_B_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VEV_C_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VOL_A_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VOL_B_Bak = (sbyte)br.ReadByte();
            PSG.Gi_MIDI_VOL_C_Bak = (sbyte)br.ReadByte();

            br.Close();
        }
    }
}
