﻿namespace csMSX2
{
    public static class TBL
    {
      //PE/PO테이블
        public static sbyte[] Gi_P_Table = new sbyte[256]; //-128~127 [0~255]
      //BIT테이블
        public static byte[] Gi_B_Table = new byte[8]; //0~255 [0~7]
        public static byte[] Gi_NB_Table = new byte[8]; //0~255 [0~7]

      //Text테이블
        public static int[] Gi_T_TableY = new int[960];  
        public static int[] Gi_T_TableX = new int[960];
        public static int[] Go_T_VRamTable = new int[960];
      //Text2테이블
        public static int[] Gi_T2_TableY = new int[2160]; 
        public static int[] Gi_T2_TableX = new int[2160];
        public static int[] Go_T2_VRamTable = new int[2160];
      //Graphic테이블
        public static int[] Gi_G_TableY = new int[768]; 
        public static int[] Gi_G_TableX = new int[768];
        public static int[] Go_G_VRamTable = new int[768];
      //Sprite-Test
        public static int[] Gi_S_Table8 = new int[1024];
        public static int[] Gi_S_TableY = new int[1024]; 
        public static int[] Gi_S_TableX = new int[1024];
        public static int[] Go_S_VRamTable = new int[1024];
      //Color테이블
        public static int[] Gi_MSX_ForeColors = new int[256];
        public static int[] Gi_MSX_BackColors = new int[256];
        public static int[] Gi_Spr_TableStart = new int[256]; //Sprite
        public static int[] Gi_Col_Pos2 = new int[512]; //16색상위치(0~1)
        public static int[] Gi_Col_Pos4 = new int[512]; //04색상위치(0~4)
      //Mul,Div테이블
        public static int[] Gi_M_Table2 = new int[256]; 
        public static int[] Gi_M_Table4 = new int[256]; 
        public static int[] Gi_M_Table8 = new int[256]; 
        public static int[] Gi_M_Table16 = new int[256]; 
        public static int[] Gi_M_Table32 = new int[256]; 
        public static int[] Gi_M_Table36 = new int[256]; 
        public static int[] Gi_M_Table64 = new int[256]; 
        public static int[] Go_M_Table128 = new int[1024];
        public static int[] Go_M_Table256 = new int[1024];
        public static int[] Go_M_Table512 = new int[1024];
        public static int[] Go_M_Table1024 = new int[256];
        public static int[] Go_M_Table2048 = new int[256];
        public static int[] Go_M_Table2560 = new int[256];
        public static int[] Go_M_Table4096 = new int[256];
        public static int[] Go_M_Table8192 = new int[256];
        public static int[] Go_M_Table16384 = new int[256];
        public static int[] Go_M_Table32768 = new int[256];
        public static int[] Go_M_Table65536 = new int[256];
        public static int[] Gi_D_Table2 = new int[512];
        public static int[] Gi_D_Table4 = new int[512];
        public static int[] Gi_D_Table8 = new int[256];
        public static int[] Gi_D_Table16 = new int[256];
        public static int[] Gi_D_Table32 = new int[768];
        public static int[] Gi_D_Table64 = new int[256];
        public static int[] Gi_D_Table128 = new int[256];
        public static int[] Gi_D_Table256 = new int[65536];

        public static void MSX_INIT_P_Table()
        {
            sbyte P;

            for (int i = 0; i <= 255; i++)
            {
                P = 0;
                if ((i & 128) != 0) P++;
                if ((i & 64) != 0) P++;
                if ((i & 32) != 0) P++;
                if ((i & 16) != 0) P++;
                if ((i & 8) != 0) P++;
                if ((i & 4) != 0) P++;
                if ((i & 2) != 0) P++;
                if ((i & 1) != 0) P++;
                if ((P == 0) || (P == 2) || (P == 4) || (P == 6) || (P == 8))
                {
                    Gi_P_Table[i] = 1;
                }
                else
                {
                    Gi_P_Table[i] = 0;
                };
            };
        }

        public static void MSX_INIT_B_Table()
        {
            Gi_B_Table[0] = 1;
            Gi_B_Table[1] = 2;
            Gi_B_Table[2] = 4;
            Gi_B_Table[3] = 8;
            Gi_B_Table[4] = 16;
            Gi_B_Table[5] = 32;
            Gi_B_Table[6] = 64;
            Gi_B_Table[7] = 128;
            Gi_NB_Table[0] = 0xFE; //1111 1110
            Gi_NB_Table[1] = 0xFD; //1111 1101
            Gi_NB_Table[2] = 0xFB; //1111 1011
            Gi_NB_Table[3] = 0xF7; //1111 0111
            Gi_NB_Table[4] = 0xEF; //1110 1111
            Gi_NB_Table[5] = 0xDF; //1101 1111
            Gi_NB_Table[6] = 0xBF; //1011 1111
            Gi_NB_Table[7] = 0x7F; //0111 1111
        }

        public static void MSX_INIT_MD_Table()
        {
            for (int i = 0; i <= 959; i++)
            {
                Gi_T_TableY[i] = (int)(i / 40);
                Gi_T_TableX[i] = i - (Gi_T_TableY[i] * 40);
                if (MSX.GiCHAR == 0)
                {
                    Go_T_VRamTable[i] = (Gi_T_TableY[i] * 2560) + (Gi_T_TableX[i] * 8); //8*8=64*40=2560, 8Dot
                }
                else
                {
                    Go_T_VRamTable[i] = (Gi_T_TableY[i] * 1920) + (Gi_T_TableX[i] * 6); //8*6=48*40=1920, 8Dot
                };
            };

            for (int i = 0; i <= 2159; i++)
            {
                Gi_T2_TableY[i] = (int)(i / 80);
                Gi_T2_TableX[i] = i - (Gi_T2_TableY[i] * 80);
                if (MSX.GiCHAR == 0)
                {
                    Go_T2_VRamTable[i] = (Gi_T2_TableY[i] * 5120) + (Gi_T2_TableX[i] * 8); //8*8=64*80=5120, 8Dot
                }
                else
                {
                    Go_T2_VRamTable[i] = (Gi_T2_TableY[i] * 3840) + (Gi_T2_TableX[i] * 6); //8*6=48*80=3840, 8Dot
                };
            };

            for (int i = 0; i <= 767; i++)
            {
                Gi_G_TableY[i] = (int)(i / 32);
                Gi_G_TableX[i] = i - (Gi_G_TableY[i] * 32);
                Go_G_VRamTable[i] = (Gi_G_TableY[i] * 2048) + (Gi_G_TableX[i] * 8); //8*8=64*32=2048, 8Dot
            };

            for (int i = 0; i <= 1023; i++)
            {
                Gi_S_Table8[i] = i * 8;
                Gi_S_TableY[i] = (int)(i / 32);
                Gi_S_TableX[i] = i - (Gi_S_TableY[i] * 32);
                Go_S_VRamTable[i] = (Gi_S_TableY[i] * 2048) + (Gi_S_TableX[i] * 8);
            };

            for (int i = 0; i <= 255; i++)
            {
                Gi_MSX_ForeColors[i] = (int)((i & 0xF0) / 16);
                Gi_MSX_BackColors[i] = (i & 0x0F);
                Gi_Spr_TableStart[i] = (int)(i / 4) * 4;
                Gi_M_Table2[i] = i * 2;
                Gi_M_Table4[i] = i * 4;
                Gi_M_Table8[i] = i * 8;
                Gi_M_Table16[i] = i * 16;
                Gi_M_Table32[i] = i * 32;
                Gi_M_Table36[i] = i * 36;
                Gi_M_Table64[i] = i * 64;
                Go_M_Table512[i] = i * 512;
                Go_M_Table1024[i] = i * 1024;
                Go_M_Table2048[i] = i * 2048;
                Go_M_Table2560[i] = i * 2560;
                Go_M_Table4096[i] = i * 4096;
                Go_M_Table8192[i] = i * 8192;
                Go_M_Table16384[i] = i * 16384;
                Go_M_Table32768[i] = i * 32768;
                Go_M_Table65536[i] = i * 65536;
                Gi_D_Table8[i] = (int)(i / 8);
                Gi_D_Table16[i] = (int)(i / 16);
                Gi_D_Table64[i] = (int)(i / 64);
                Gi_D_Table128[i] = (int)(i / 128);
            };

            for (int i = 0; i <= 511; i++)
            {
                Gi_Col_Pos2[i] = i % 2;
                Gi_Col_Pos4[i] = i % 4;
                Gi_D_Table2[i] = (int)(i / 2);
                Gi_D_Table4[i] = (int)(i / 4);
            };

            for (int i = 0; i <= 767; i++)
            {
                Gi_D_Table32[i] = (int)(i / 32);
            };

            for (int i = 0; i <= 1023; i++)
            {
                Go_M_Table128[i] = i * 128;
                Go_M_Table256[i] = i * 256;
            };

            for (int i = 0; i <= 65535; i++)
            {
                Gi_D_Table256[i] = (int)(Z80A.goGetLngToLng(i & 0xFF00) / 256);
            };
        }
    }
}
