﻿using System.Drawing;

namespace csMSX2
{
    public static class VDT
    {
      //VRAM - MSX1(3FFFh[16383])16KB, MSX2(0~1FFFFh[131071])128KB
        public static byte[] MSX_VRAM = new byte[131072]; //0~255 [0~16383 | 0~131071]

        public static byte[] MSX_VDT_REG = new byte[47]; //0~255 [0~46]
      //MSX1, #00~#07
      //#00-모드레지스터#0, Graphics Mode(7,1)
      //    '0'
      //     DG : Digitize mode: sets the color bus to the input or output mode
      //     IE2 : Enables interrupts from Light pen
      //     IE1 : Enabled interrupt from horizontal retrace
      //     M5 : Screen mode flag
      //     M4 : Screen mode flag
      //     M3 : Screen mode flag
      //     '0'
        public static byte MSX_VDT_REG_IE1; // bit - Enables interrupt from horizontal retrace
        public static byte MSX_VDT_REG_EV;  // bit - EXT VID
      //#01-모드레지스터#1, VRAM Size(1,1:4?16K), Enable(2,1/1:표시), IE(3,1), Graphics Mode(4,2), Spr Size(7,1), Spr Mag(8,1)
      //    '0'
      //    BL : Blank screen: (1:Display Enable, 0:Disable)
      //    IE0 : Enables interrupt from vertical retrace
      //    M1 : Screen mode flag
      //    M2 : Screen mode flag
      //    '0'
      //    SI : Sprite size: (1:16*16,0:8*8)
      //    MAG : Sprite enlarging: (1:Double size)
        public static byte MSX_VDT_REG_16K; //7 bit - VRAM 4K/16K
        public static byte MSX_VDT_REG_ON;  //6 bit - 1:화면표시 / BL
        public static byte MSX_VDT_REG_IE0; //5 bit - Enables interrupt from vertical retrace
        public static byte MSX_VDT_REG_SZ;  //1 bit - SPR SIZE (0:8*8,1:16*16) / SI
        public static byte MSX_VDT_REG_SM;  //0 bit - SPR MAG (0:기본,1:가로세로2배확대) / MAG
      //#02-Pattern Name Table (화면문자0~255) - 0A16~A10지정, A9~A0은0
      //#03-Color Table (4bit:bit1색+4bit:bit0색)
      //#04-Pattern Generate Table (폰트8[우측2bit표시안함]*0~255) - 00A16~A11지정, A10~A0은0
      //#05-Sprite Attribute Table
      //#06-Sprite Pattern Table
      //#07-Backdrop Color (4bit:전경색+4bit:배경색)
      //MSX2, #08~#23
      //#08-모드레지스터#2
      //    MS : Mouse
      //    LP : Light pen
      //    TP : Sets the color of code 0 to the color of the palette
      //    CB : Color bus
      //    VR : Selects the type and organization of VRAM
      //    '0'
      //    SPD : Sprite disable
      //    BW : Black/White
        public static byte MSX_VDT_REG_TP;  //5 bit - MSX2, Sets Color 0
        public static byte MSX_VDT_REG_SPD; //1 bit - MSX2, 1:소프라이트 비표시
      //#09-모드레지스터#3
      //    LN : Line: (1:212, 0:192)
      //    '0'
      //    S1 : Selects simultaneous mode
      //    S2 : Selects simultaneous mode
      //    IL : Interlace (0:1매의화면만표,1:2매의화면의교대표시)
      //    EO : Event/Odd screens (0:논인터레이스모드(보통모드),1:인터레이스모드)
      //    *NT : RGB output only: (1:PAL mode,0:NTSC mode)
      //    DC : Dot clock
        public static byte MSX_VDT_REG_LN; //7 bit - MSX2, Graphic Line - 0:192,1:212
        public static byte MSX_VDT_REG_IL; //3 bit
        public static byte MSX_VDT_REG_EO; //2 bit
      //#10-Color Table (High)
      //#11-소프라이트으트리뷰트테이블(High)
      //#12-텍스트 블링크시 문자색
      //#13-짝수페이지표시Even/6초(7~4),홀수페이지표시Odd/6초(3~0)
      //#14-VRAM의 어드레스 설정 (상위:3비트)
      //#15-S#n의 간접지정
      //#16-P#n의 간접지정
      //#17-R#n의 간접지정
      //#18-화면위치의 보정
      //#19-주사선번호, CRT가 특별한 주사선의 표시를 끝낸 순간에 가로채기를 발생시킴 (IE1=1일경우)
      //#20-컬러버스트신호1
      //#21-컬러버스트신호2
      //#22-컬러버스트신호3
      //#23-화면의 표시개시 라인을 설정 (화면의 세로방향 스크롤)

      //VRAM - MSX2, Command
        public static byte[] MSX_VRAM_Buff = new byte[131072]; //0~255 ['0~1FFFFh(131071)]
        public static int Go_MSX_VRAM_Buff_Size; 
        public static int Go_MSX_VRAM_Buff_Count;

      //VDT Command 레지스터 - Write Only
      //MSX2, #32~#46(VDT커맨드실행시사용)
      //#32-SX: Source X - 7~0
      //#33-SX:              8
        public static ushort Go_MSX_VDT_CMD_REG_SX;
      //#34-SY: Source Y - 7~0
      //#35-SY:            9,8
        public static ushort Go_MSX_VDT_CMD_REG_SY;
      //#36-DX: Destination X - 7~0
      //#37-DX:                   8
        public static ushort Go_MSX_VDT_CMD_REG_DX;
      //#38-DY: Destination Y - 7~0
      //#39-DY:                 9,8
        public static ushort Go_MSX_VDT_CMD_REG_DY;
      //#40-NX: Number of dots in X-axis - 7~0
      //#41-NX:                              8
        public static ushort Go_MSX_VDT_CMD_REG_NX;
        public static ushort Go_MSX_VDT_CMD_REG_Mjg;
      //#42-NY: Number of dots in Y=axis - 7~0
      //#43-NY:                            9,8
        public static ushort Go_MSX_VDT_CMD_REG_NY;
        public static ushort Go_MSX_VDT_CMD_REG_Min;
      //#44-Color: X=2N(7~4), X=2N+1(3~0)                           - G4,G6 (N=0..127)
      //           X=4N(7~6), X=4N+1(5~4), X=4N+2(3~2), X=4N+3(1~0) - G5 (N=0..127)
      //           X=N(One dot)(7~0)                                - G7
        public static byte Gi_MSX_VDT_CMD_REG_Color;
      //#45-뱅크변환(Bit6-0:VRAM,1:확장RAM[사용안함])
      //    Select destination memory and direction from base coordinate
        public static byte MSX_VDT_CMD_REG_MXC; //Bit6 - MSX2, 0:VRAM, 1:확장RAM
      //    MXD - Bit5-0:VRAM,1:ExpRam - Destination select
        public static byte MSX_VDT_CMD_REG_MXD; //Bit5
        public static byte MSX_VDT_CMD_REG_MXS; //Bit4
      //    DIY - Bit3-0:Down,1:Up     - Y Transfer direction
        public static byte MSX_VDT_CMD_REG_DIY; //Bit3
      //    DIX - Bit2-0:Right,1:Left  - X Transfer direction
        public static byte MSX_VDT_CMD_REG_DIX; //Bit2
        public static byte MSX_VDT_CMD_REG_EQ;  //Bit1
        public static byte MSX_VDT_CMD_REG_MAJ; //Bit0 - Line 긴변선택
      //#46-Execute the command (7~0:11110000)
        public static byte MSX_VDT_CMD_REG_CMD; //Bit7~4
        public static byte MSX_VDT_CMD_REG_LO;  //Bit3~0

      //public static byte[] MSX_VDT_ST_REG = new byte[10]; //0~255 [0~9]
      //MSX1, #0
      //MSX_VDT_REG_ST - 가로채기정보
        public static byte MSX_VDT_ST_REG_FF;  //7 bit - End of the raster scan of the last line of the active display, 1초에60번발생(60Hz), 1초에50번발행(50Hz)
        public static byte Gi_MSX_VDT_ST_REG_FF;
        public static byte MSX_VDT_ST_REG_5S;  //6 bit - 소프라이트 1줄에 5개이상 표시로, 5번째이상 표시안되는 상태
        public static byte MSX_VDT_ST_REG_C;   //5 bit - 소프라이트 충돌
        public static byte MSX_VDT_ST_REG_5SN; //4~0 bit - 표시안되는 첫번째 소프라이트 번호
      //MSX2, #1~#9
      //MSX_VDT_REG_ST1 - 가로채기정보
        public static byte MSX_VDT_ST_REG_FL;  //'7 bit - Light Pen
        public static byte MSX_VDT_ST_REG_LPS; //6 bit - Light Pen Button
        public static byte MSX_VDT_ST_REG_ID;  //5~1 bit - VDT Chip
        public static byte MSX_VDT_ST_REG_FH;  //0 bit - Horizontal scan interrup flag
      //MSX_VDT_REG_ST2
        public static byte MSX_VDT_ST_REG_TR;  //7 bit - Transfer ready flag
        public static byte MSX_VDT_ST_REG_VR;  //6 bit - Vertical retrace flag
        public static byte MSX_VDT_ST_REG_HR;  //5 bit - Horizontal retrace flag
        public static byte MSX_VDT_ST_REG_BD;  //4 bit - Color detect flag
        public static byte MSX_VDT_ST_REG_EO;  //1 bit - Display field flag
        public static byte MSX_VDT_ST_REG_CE;  //0 bit - Command execution flag
      //MSX_VDT_REG_ST3 - Column register low
      //MSX_VDT_REG_ST4 - Column register high (1111111 8)
        public static int Go_MSX_VDT_ST_REG_Column;
      //MSX_VDT_REG_ST5 - Row register row
      //MSX_VDT_REG_ST6 - Row register high (111111 9,8)
        public static int Go_MSX_VDT_ST_REG_Row;
      //MSX_VDT_REG_ST7 - Color register
        public static byte Gi_MSX_VDT_ST_REG_Color;
      //MSX_VDT_REG_ST8 - Coded color X register low
      //MSX_VDT_REG_ST9 - Coded color Y register high (1111111 8)
        public static int Go_MSX_VDT_ST_REG_BX;

        public static sbyte Gi_MSX_Screen_Out; //1:화면출력필요
        public static byte Gi_MSX_ForeColor;
        public static byte Gi_MSX_BackColor;
        public static byte Gi_MSX_OutColor;
        public static byte Gi_MSX_ForeColor_Blink;
        public static byte Gi_MSX_BackColor_Blink;
        public static byte Gi_MSX_Blink_Time_Bl;
        public static byte Gi_MSX_Blink_Time_Co;

        public static sbyte Gi_MSX_SCREEN_MODE; //0:TEXT, 1:GRAPHIC_1, 2:GRAPHIC_2, 3:MULTI_COLOR, 10:TEXT 80
        public static sbyte Gi_MSX_Screen_Mode_Prv;
        public static byte Gi_MSX_VDT_Reg_LN_Prv;
        public static sbyte Gi_MSX_Graphic_Page;

        public static sbyte Gi_MSX_VRAM_IO; //1:Read,2:Write
        public static int Go_MSX_VRAM_ADDRESS;
        public static sbyte Gi_MSX_VRAM_Flg;
        public static sbyte Gi_MSX2_VRAM_Flg;

        public static int Go_MSX_SCR_CHAR_ADDR;
        public static int Go_MSX_SCR_COLR_ADDR;
        public static int Go_MSX_SCR_FONT_ADDR;
        public static int Go_MSX_SCR_BLNK_ADDR; //MSX2 - Text 80 Blink
        public static int Go_MSX_SPR_ATRB_ADDR;
        public static int Go_MSX_SPR_FONT_ADDR;
        public static int Go_MSX_SPR_COLR_ADDR; //MSX2 - Screen 8 Sprite Color

      //VDT Palette 레지스터 - MSX1(기본설정), MSX2(팔레트레지스터로지정)
        public static byte[] MSX_VDT_REG_PAL_Red = new byte[16]; //0~255 [0~15]
        public static byte[] MSX_VDT_REG_PAL_Green = new byte[16]; //0~255 [0~15]
        public static byte[] MSX_VDT_REG_PAL_Blue = new byte[16]; //0~255 [0~15]
        public static uint[] Go_MSX_Color = new uint[16]; //'BitMap(PictureBox) 표시용
        public static uint[] Go_MSX_Color_RGB = new uint[16]; //화면표시용
        public static uint[] Go_MSX_Color_G7 = new uint[16]; //Screen 8, Graphic7용 소프라이트 고정색상
        public static uint[] Go_MSX_Color_G7_RGB = new uint[16]; //화면표시용
        public static Color[] Gc_MSX_Color = new Color[16]; //'BitMap(PictureBox) 표시용
        public static Color[] Gc_MSX_Color_RGB = new Color[16]; //화면표시용
        public static Color[] Gc_MSX_Color_G7 = new Color[16]; //Screen 8, Graphic7용 소프라이트 고정색상
        public static Color[] Gc_MSX_Color_G7_RGB = new Color[16]; //화면표시용

        public static void MSX_INIT_VDT()
        {
            for (int i = 0; i <= 131071; i++)
            {
                MSX_VRAM[i] = 0;
            };

            for (int i = 0; i <= 46; i++)
            {
                MSX_VDT_REG[i] = 0;
            };

            Gi_MSX_Screen_Out = 0;

            Gi_MSX_SCREEN_MODE = 0;
            MSX_VDT_REG_LN = 0;
            Gi_MSX_Screen_Mode_Prv = -1;
            Gi_MSX_VDT_Reg_LN_Prv = 0;
            Gi_MSX_Graphic_Page = 0;

            MSX_VDT_REG_IE1 = 0;
            MSX_VDT_REG_EV = 0;
            MSX_VDT_REG_16K = 0;
            MSX_VDT_REG_ON = 1;
            MSX_VDT_REG_IE0 = 0;
            MSX_VDT_REG_SZ = 0;
            MSX_VDT_REG_SM = 0;
            MSX_VDT_REG_TP = 0;
            MSX_VDT_REG_SPD = 0;
            MSX_VDT_REG_IL = 0;
            MSX_VDT_REG_EO = 0;

            for (int i = 0; i <= 131071; i++)
            {
                MSX_VRAM_Buff[i] = 0;
            };
            Go_MSX_VRAM_Buff_Size = 0; 
            Go_MSX_VRAM_Buff_Count = 0;

            Go_MSX_VDT_CMD_REG_SX = 0;
            Go_MSX_VDT_CMD_REG_SY = 0;
            Go_MSX_VDT_CMD_REG_DX = 0;
            Go_MSX_VDT_CMD_REG_DY = 0;
            Go_MSX_VDT_CMD_REG_NX = 0;
            Go_MSX_VDT_CMD_REG_NY = 0;
            Go_MSX_VDT_CMD_REG_Mjg = 0;
            Go_MSX_VDT_CMD_REG_Min = 0;
            Gi_MSX_VDT_CMD_REG_Color = 0;
            MSX_VDT_CMD_REG_MXC = 0;
            MSX_VDT_CMD_REG_MXD = 0;
            MSX_VDT_CMD_REG_MXS = 0;
            MSX_VDT_CMD_REG_DIY = 0;
            MSX_VDT_CMD_REG_DIX = 0;
            MSX_VDT_CMD_REG_EQ = 0;
            MSX_VDT_CMD_REG_MAJ = 0;
            MSX_VDT_CMD_REG_CMD = 0;
            MSX_VDT_CMD_REG_LO = 0;
 
            Go_MSX_VDT_CMD_REG_SX = 0;
            Go_MSX_VDT_CMD_REG_SY = 0;
            Go_MSX_VDT_CMD_REG_DX = 0;
            Go_MSX_VDT_CMD_REG_DY = 0;
            Go_MSX_VDT_CMD_REG_NX = 0;
            Go_MSX_VDT_CMD_REG_NY = 0;
            Go_MSX_VDT_CMD_REG_Mjg = 0;
            Go_MSX_VDT_CMD_REG_Min = 0;
            Gi_MSX_VDT_CMD_REG_Color = 0;
            MSX_VDT_CMD_REG_MXC = 0;
            MSX_VDT_CMD_REG_MXD = 0;
            MSX_VDT_CMD_REG_MXS = 0;
            MSX_VDT_CMD_REG_DIY = 0;
            MSX_VDT_CMD_REG_DIX = 0;
            MSX_VDT_CMD_REG_EQ = 0;
            MSX_VDT_CMD_REG_MAJ = 0;
            MSX_VDT_CMD_REG_CMD = 0;
            MSX_VDT_CMD_REG_LO = 0;

            MSX_VDT_ST_REG_FF = 0;
            Gi_MSX_VDT_ST_REG_FF = 0;
            MSX_VDT_ST_REG_5S = 0; 
            MSX_VDT_ST_REG_C = 0; 
            MSX_VDT_ST_REG_5SN = 0;
            MSX_VDT_ST_REG_FL = 0; 
            MSX_VDT_ST_REG_LPS = 0; 
            MSX_VDT_ST_REG_ID = 0; 
            MSX_VDT_ST_REG_FH = 0; 
            MSX_VDT_ST_REG_TR = 0; 
            MSX_VDT_ST_REG_VR = 0; 
            MSX_VDT_ST_REG_HR = 0; 
            MSX_VDT_ST_REG_BD = 0;
            MSX_VDT_ST_REG_EO = 0; 
            MSX_VDT_ST_REG_CE = 0;
            Go_MSX_VDT_ST_REG_Column = 0;
            Go_MSX_VDT_ST_REG_Row = 0;
            Gi_MSX_VDT_ST_REG_Color = 0;
            Go_MSX_VDT_ST_REG_BX = 0;

            Gi_MSX_VRAM_IO = 0;
            Go_MSX_VRAM_ADDRESS = 0;
            Gi_MSX_VRAM_Flg = 0;
            Gi_MSX2_VRAM_Flg = 0;

            Go_MSX_SCR_CHAR_ADDR = 0;
            Go_MSX_SCR_COLR_ADDR = 0;
            Go_MSX_SCR_FONT_ADDR = 0;
            Go_MSX_SCR_BLNK_ADDR = 0;
            Go_MSX_SPR_ATRB_ADDR = 0;
            Go_MSX_SPR_FONT_ADDR = 0;
            Go_MSX_SPR_COLR_ADDR = 0;

            for (int i = 0; i <= 15; i++)
            {
                MSX_VDT_REG_PAL_Red[i] = 0;
                MSX_VDT_REG_PAL_Green[i] = 0;
                MSX_VDT_REG_PAL_Blue[i] = 0;
                Go_MSX_Color[i] = 0;
                Go_MSX_Color_RGB[i] = 0;
                Go_MSX_Color_G7[i] = 0;
                Go_MSX_Color_G7_RGB[i] = 0;
            };
        }

        public static void MSX_SCREEN_MODE_SET()
        {
            sbyte M1, M0;

            if (MSX.GiMSX2 == 0) //MSX1
            {
                M0 = (sbyte)TBL.Gi_D_Table2[MSX_VDT_REG[0] & 2]; //R0(7,1)
            }
            else //MSX2
            {
                M0 = (sbyte)TBL.Gi_D_Table2[MSX_VDT_REG[0] & 14]; //R0(5,3)
            };
            M1 = (sbyte)TBL.Gi_D_Table8[MSX_VDT_REG[1] & 0x18];  //R1(4,2)
            if ((M1 == 2) && (M0 == 0)) Gi_MSX_SCREEN_MODE = 0;  //10+000-TEXT - MSX1
            if ((M1 == 0) && (M0 == 0)) Gi_MSX_SCREEN_MODE = 1;  //00+000-GRAPHIC_1 - MSX1
            if ((M1 == 0) && (M0 == 1)) Gi_MSX_SCREEN_MODE = 2;  //00+001-GRAPHIC_2 - MSX1
            if ((M1 == 1) && (M0 == 0)) Gi_MSX_SCREEN_MODE = 3;  //01+000-MULTI_COLOR - MSX1
            if ((M1 == 2) && (M0 == 2)) Gi_MSX_SCREEN_MODE = 10; //10+010-TEXT2 - MSX2
            if ((M1 == 0) && (M0 == 2)) Gi_MSX_SCREEN_MODE = 4;  //00+010-GRAPHIC_3 - MSX2
            if ((M1 == 0) && (M0 == 3))
            {
                Gi_MSX_SCREEN_MODE = 5; //00+011-GRAPHIC_4 - MSX2
                Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 127]; //0~3 * 8000h
            };
            if ((M1 == 0) && (M0 == 4))
            {
                Gi_MSX_SCREEN_MODE = 6; //00+100-GRAPHIC_5 - MSX2
                Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 127]; //0~3 * 8000h
            };
            if ((M1 == 0) && (M0 == 5))
            {
                Gi_MSX_SCREEN_MODE = 7; //00+101-GRAPHIC_6 - MSX2
                Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 63]; //0~1 * 10000h
            };
            if ((M1 == 0) && (M0 == 7))
            {
                Gi_MSX_SCREEN_MODE = 8; //00+111-GRAPHIC_7 - MSX2
                Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 63]; //0~1 * 10000h
            };
            MSX_VDT_REG_EV = (byte)(MSX_VDT_REG[0] & 1); //R0(8,1), EXT VID
            if (MSX.GiMSX2 == 1) //MSX2
            {
                MSX_VDT_REG_IE1 = (byte)((MSX_VDT_REG[0] & 16) == 0 ? 0 : 1);
            };
            MSX_VDT_REG_16K = (byte)((MSX_VDT_REG[1] & 128) == 0 ? 0 : 1); //R1(1,1), 4/16K
            MSX_VDT_REG_ON = (byte)((MSX_VDT_REG[1] & 64) == 0 ? 0 : 1);   //R1(2,1), 1:화면표시
            MSX_VDT_REG_IE0 = (byte)((MSX_VDT_REG[1] & 32) == 0 ? 0 : 1);  //R1(3,1), IE
            MSX_VDT_REG_SZ = (byte)((MSX_VDT_REG[1] & 2) == 0 ? 0 : 1);    //R1(7,1), SPR SIZE
            MSX_VDT_REG_SM = (byte)(MSX_VDT_REG[1] & 1);                   //R1(8,1), SPR MAG
        }

        public static void MSX_SCREEN_MODE_SET2()
        {
            if (Gi_MSX_SCREEN_MODE == 5) Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 127]; //0~3 * 8000h
            if (Gi_MSX_SCREEN_MODE == 6) Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 127]; //0~3 * 8000h
            if (Gi_MSX_SCREEN_MODE == 7) Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 63];  //0~1 * 10000h
            if (Gi_MSX_SCREEN_MODE == 8) Gi_MSX_Graphic_Page = (sbyte)TBL.Gi_D_Table32[MSX_VDT_REG[2] & 63];  //0~1 * 10000h
        }

        public static void MSX_SCREEN_MODE_SET8()
        {
            MSX_VDT_REG_TP = (byte)((MSX_VDT_REG[8] & 32) == 0 ? 0 : 1);
            MSX_VDT_REG_SPD = (byte)((MSX_VDT_REG[8] & 2) == 0 ? 0 : 1);
        }

        public static void MSX_SCREEN_MODE_SET9()
        {
            MSX_VDT_REG_LN = (byte)((MSX_VDT_REG[9] & 128) == 0 ? 0 : 1); //R9(1,1), 192/212
            MSX_VDT_REG_IL = (byte)((MSX_VDT_REG[9] & 8) == 0 ? 0 : 1);
            MSX_VDT_REG_EO = (byte)((MSX_VDT_REG[9] & 4) == 0 ? 0 : 1);
        }

        public static byte MSX_VDT_REG_ST()
        {
            byte R;
          //확인요망(부팅관련) ???
            if (MSX.Gi_MSX_VDT_ST_FF == 0)
            {
                MSX_VDT_ST_REG_FF = 1;
            }
            else
            {
                if (Gi_MSX_VDT_ST_REG_FF == 0) //화변표시후Set, 1초에60번(60Hz)
                {
                    Gi_MSX_VDT_ST_REG_FF = 1;
                }
                else
                {
                    Gi_MSX_VDT_ST_REG_FF = 0;
                };
                MSX_VDT_ST_REG_FF = Gi_MSX_VDT_ST_REG_FF;
            };
            R = 0;
            R = (byte)(R + TBL.Go_M_Table128[MSX_VDT_ST_REG_FF]);
            R = (byte)(R + TBL.Gi_M_Table64[MSX_VDT_ST_REG_5S]);
            R = (byte)(R + TBL.Gi_M_Table32[MSX_VDT_ST_REG_C]);
            R = (byte)(R + MSX_VDT_ST_REG_5SN);

            return R;
        }

        public static byte MSX_VDT_REG_ST1()
        {
            byte R;

            R = 0;
            R = (byte)(R + TBL.Go_M_Table128[MSX_VDT_ST_REG_FL]);
            R = (byte)(R + TBL.Gi_M_Table64[MSX_VDT_ST_REG_LPS]);
            R = (byte)(R + TBL.Gi_M_Table2[MSX_VDT_ST_REG_ID]);
            R = (byte)(R + MSX_VDT_ST_REG_FH);

            return R;
        }

        public static byte MSX_VDT_REG_ST2()
        {
            byte R;

            R = 0;
            R = (byte)(R + TBL.Go_M_Table128[MSX_VDT_ST_REG_TR]);
            R = (byte)(R + TBL.Gi_M_Table64[MSX_VDT_ST_REG_VR]);
            R = (byte)(R + TBL.Gi_M_Table32[MSX_VDT_ST_REG_HR]);
            R = (byte)(R + TBL.Gi_M_Table16[MSX_VDT_ST_REG_BD]);
            R = (byte)(R + TBL.Gi_M_Table2[MSX_VDT_ST_REG_EO]);
            R = (byte)(R + MSX_VDT_ST_REG_CE);
          //확인요망(부팅관련) ???
          //If MSX_VDT_REG_IE0 = 1 Then
            if (MSX_VDT_ST_REG_VR == 0)
            {
                MSX_VDT_ST_REG_VR = 1;
            }
            else
            {
                MSX_VDT_ST_REG_VR = 0;
            };
          //If MSX_VDT_REG_IE0 = 1 Then
            if (MSX_VDT_ST_REG_HR == 0)
            {
                MSX_VDT_ST_REG_HR = 1;
            }
            else
            {
                MSX_VDT_ST_REG_HR = 0;
            };

            return R;
        }

        public static byte MSX_VDT_REG_ST3()
        {
            return (byte)(Go_MSX_VDT_ST_REG_Column & 255);
        }

        public static byte MSX_VDT_REG_ST4()
        {
            return (byte)TBL.Gi_D_Table256[Go_MSX_VDT_ST_REG_Column];
        }

        public static byte MSX_VDT_REG_ST5()
        {
            return (byte)(Go_MSX_VDT_ST_REG_Row & 255);
        }

        public static byte MSX_VDT_REG_ST6()
        {
            return (byte)TBL.Gi_D_Table256[Go_MSX_VDT_ST_REG_Row];
        }

        public static byte MSX_VDT_REG_ST7()
        {
            if ((MSX_VDT_ST_REG_CE == 1) && (MSX_VDT_ST_REG_TR == 1))
            {
                if (Go_MSX_VRAM_Buff_Count > 0)
                {
                    Go_MSX_VRAM_Buff_Count = Go_MSX_VRAM_Buff_Count - 1;
                    Gi_MSX_VDT_ST_REG_Color = MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count];
                    if (Go_MSX_VRAM_Buff_Count == 0)
                    {
                        MSX_VDT_ST_REG_CE = 0;
                        MSX_VDT_ST_REG_TR = 0;
                    };
                }
                else
                {
                    MSX_VDT_ST_REG_CE = 0;
                    MSX_VDT_ST_REG_TR = 0;
                };
            };

            return Gi_MSX_VDT_ST_REG_Color;
        }

        public static byte MSX_VDT_REG_ST8()
        {
            return (byte)(Go_MSX_VDT_ST_REG_BX & 255);
        }

        public static byte MSX_VDT_REG_ST9()
        {
            return (byte)TBL.Gi_D_Table256[Go_MSX_VDT_ST_REG_BX];
        }

        public static void MSX_VDT_CMD_REG_SX()
        {
            Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SX, ref MSX_VDT_REG[33], ref MSX_VDT_REG[32]);
        }

        public static void MSX_VDT_CMD_REG32_SET()
        {
            Go_MSX_VDT_CMD_REG_SX = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[33] & 1), MSX_VDT_REG[32]);
        }

        public static void MSX_VDT_CMD_REG33_SET()
        {
            Go_MSX_VDT_CMD_REG_SX = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[33] & 1), MSX_VDT_REG[32]);
        }

        public static void MSX_VDT_CMD_REG_SY()
        {
            Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_SY, ref MSX_VDT_REG[35], ref MSX_VDT_REG[34]);
        }

        public static void MSX_VDT_CMD_REG34_SET()
        {
            Go_MSX_VDT_CMD_REG_SY = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[35] & 3), (byte)MSX_VDT_REG[34]);
        }

        public static void MSX_VDT_CMD_REG35_SET()
        {
            Go_MSX_VDT_CMD_REG_SY = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[35] & 3), MSX_VDT_REG[34]);
        }

        public static void MSX_VDT_CMD_REG_DX()
        {
            Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DX, ref MSX_VDT_REG[37], ref MSX_VDT_REG[36]);
        }

        public static void MSX_VDT_CMD_REG36_SET()
        {
            Go_MSX_VDT_CMD_REG_DX = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[37] & 1), MSX_VDT_REG[36]);
        }

        public static void MSX_VDT_CMD_REG37_SET()
        {
            Go_MSX_VDT_CMD_REG_DX = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[37] & 1), MSX_VDT_REG[36]);
        }

        public static void MSX_VDT_CMD_REG_DY()
        {
            Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_DY, ref MSX_VDT_REG[39], ref MSX_VDT_REG[38]);
        }

        public static void MSX_VDT_CMD_REG38_SET()
        {
            Go_MSX_VDT_CMD_REG_DY = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[39] & 3), MSX_VDT_REG[38]);
        }

        public static void MSX_VDT_CMD_REG39_SET()
        {
            Go_MSX_VDT_CMD_REG_DY = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[39] & 3), MSX_VDT_REG[38]);
        }

        public static void MSX_VDT_CMD_REG_NX()
        {
            Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NX, ref MSX_VDT_REG[41], ref MSX_VDT_REG[40]);
        }

        public static void MSX_VDT_CMD_REG40_SET()
        {
            Go_MSX_VDT_CMD_REG_NX = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[41] & 1), MSX_VDT_REG[40]);
            Go_MSX_VDT_CMD_REG_Mjg = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[41] & 3), MSX_VDT_REG[40]);
        }

        public static void MSX_VDT_CMD_REG41_SET()
        {
            Go_MSX_VDT_CMD_REG_NX = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[41] & 1), MSX_VDT_REG[40]);
            Go_MSX_VDT_CMD_REG_Mjg = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[41] & 3), MSX_VDT_REG[40]);
        }

        public static void MSX_VDT_CMD_REG_NY()
        {
            Z80A.gtMoveLngToIntHL(Go_MSX_VDT_CMD_REG_NY, ref MSX_VDT_REG[43], ref MSX_VDT_REG[42]);
        }

        public static void MSX_VDT_CMD_REG42_SET()
        {
            Go_MSX_VDT_CMD_REG_NY = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[43] & 3), MSX_VDT_REG[42]);
            Go_MSX_VDT_CMD_REG_Min = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[43] & 1), MSX_VDT_REG[42]);
        }

        public static void MSX_VDT_CMD_REG43_SET()
        {
            Go_MSX_VDT_CMD_REG_NY = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[43] & 3), MSX_VDT_REG[42]);
            Go_MSX_VDT_CMD_REG_Min = Z80A.goGetIntHLToLng((byte)(MSX_VDT_REG[43] & 1), MSX_VDT_REG[42]);
        }

        public static void MSX_VDT_CMD_REG_CLR()
        {
            MSX_VDT_REG[44] = Gi_MSX_VDT_CMD_REG_Color;
        }

        public static void MSX_VDT_CMD_REG44_SET()
        {
            Gi_MSX_VDT_CMD_REG_Color = MSX_VDT_REG[44];
   
            if (MSX_VDT_ST_REG_CE == 1)
            {
                if ((MSX_VDT_CMD_REG_CMD == 0xF) || (MSX_VDT_CMD_REG_CMD == 0xB))
                {
                    MSX_VRAM_Buff[Go_MSX_VRAM_Buff_Count] = MSX_VDT_REG[44];
                    Go_MSX_VRAM_Buff_Count = Go_MSX_VRAM_Buff_Count + 1;
                    if (Go_MSX_VRAM_Buff_Count >= Go_MSX_VRAM_Buff_Size)
                    {
                        MSX_VDT_ST_REG_CE = 0;
                        MSX_VDT_ST_REG_TR = 0;
                        if (MSX_VDT_CMD_REG_CMD == 0xF) VDTCMD.MSX_VDT_CMD_REG46_HMMC();
                        if (MSX_VDT_CMD_REG_CMD == 0xB) VDTCMD.MSX_VDT_CMD_REG46_LMMC();
                    };
                };
            };
        }

        public static void MSX_VDT_CMD_REG45_SET()
        {
            MSX_VDT_CMD_REG_MXC = (byte)((MSX_VDT_REG[45] & 64) == 0 ? 0 : 1);
            MSX_VDT_CMD_REG_MXD = (byte)((MSX_VDT_REG[45] & 32) == 0 ? 0 : 1);
            MSX_VDT_CMD_REG_MXS = (byte)((MSX_VDT_REG[45] & 16) == 0 ? 0 : 1);
            MSX_VDT_CMD_REG_DIY = (byte)((MSX_VDT_REG[45] & 8) == 0 ? 0 : 1);
            MSX_VDT_CMD_REG_DIX = (byte)((MSX_VDT_REG[45] & 4) == 0 ? 0 : 1);
            MSX_VDT_CMD_REG_EQ = (byte)((MSX_VDT_REG[45] & 2) == 0 ? 0 : 1);
            MSX_VDT_CMD_REG_MAJ = (byte)((MSX_VDT_REG[45] & 1) == 0 ? 0 : 1);
        }

        public static void MSX_VDT_CMD_REG46_SET()
        {
            int Nx; int Ny;

            Nx = GET_VDT_CMD_REG_NX();
            Ny = GET_VDT_CMD_REG_NY();

            MSX_VDT_ST_REG_CE = 0;
            MSX_VDT_ST_REG_TR = 0;

          //Destination, Source, Unint, Mnemonic
            MSX_VDT_CMD_REG_CMD = (byte)TBL.Gi_D_Table16[MSX_VDT_REG[46] & 0xF0];
            MSX_VDT_CMD_REG_LO = (byte)(MSX_VDT_REG[46] & 0xF);

          //High-speed move
            if (MSX_VDT_CMD_REG_CMD == 0xF)
            {
               MSX_VDT_ST_REG_CE = 1;
                Go_MSX_VRAM_Buff_Size = Nx * Ny;
                if (Gi_MSX_SCREEN_MODE == 5) Go_MSX_VRAM_Buff_Size = (int)(Go_MSX_VRAM_Buff_Size / 2);
                if (Gi_MSX_SCREEN_MODE == 6) Go_MSX_VRAM_Buff_Size = (int)(Go_MSX_VRAM_Buff_Size / 4);
                if (Gi_MSX_SCREEN_MODE == 7) Go_MSX_VRAM_Buff_Size = (int)(Go_MSX_VRAM_Buff_Size / 2);
                MSX_VRAM_Buff[0] = MSX_VDT_REG[44];
                Go_MSX_VRAM_Buff_Count = 1;
                if (Go_MSX_VRAM_Buff_Count < Go_MSX_VRAM_Buff_Size)
                {
                    MSX_VDT_ST_REG_TR = 1;
                }
                else
                {
                    MSX_VDT_ST_REG_CE = 0;
                };
            };
            if (MSX_VDT_CMD_REG_CMD == 0xE)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_YMMM(); //D:VRAM, S:VRAM, U:Byte, YMMM
                MSX_VDT_ST_REG_CE = 0;
             };
            if (MSX_VDT_CMD_REG_CMD == 0xD)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_HMMM(0); //D:VRAM, S:VRAM, U:Byte, HMMM
                MSX_VDT_ST_REG_CE = 0;
             };
            if (MSX_VDT_CMD_REG_CMD == 0xC)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_HMMV(); //D:VRAM, S:VDP, U:Byte, HMMV
                MSX_VDT_ST_REG_CE = 0;
             };

          //Logical Move
            if (MSX_VDT_CMD_REG_CMD == 0xB)
            {
                MSX_VDT_ST_REG_CE = 1;
                Go_MSX_VRAM_Buff_Size = Nx * Ny;
                MSX_VRAM_Buff[0] = MSX_VDT_REG[44];
                Go_MSX_VRAM_Buff_Count = 1;
                if (Go_MSX_VRAM_Buff_Count < Go_MSX_VRAM_Buff_Size)
                {
                    MSX_VDT_ST_REG_TR = 1;
                }
                else
                {
                    MSX_VDT_ST_REG_CE = 0;
                };
            };
            if (MSX_VDT_CMD_REG_CMD == 0xA)
            {
                MSX_VDT_ST_REG_CE = 1;
                MSX_VDT_ST_REG_TR = 0;
                VDTCMD.MSX_VDT_CMD_REG46_LMCM(); //D:CPU, S:VRAM, U:Dot, LMCM
                MSX_VDT_ST_REG_TR = 1;
            };
            if (MSX_VDT_CMD_REG_CMD == 0x9)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_LMMM(); //D:VRAM, S:VRAM, U:Dot, LMMM
                MSX_VDT_ST_REG_CE = 0;
            };
            if (MSX_VDT_CMD_REG_CMD == 0x8)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_LMMV(); //D:VRAM, S:VDP, U:Dot, LMMV
                MSX_VDT_ST_REG_CE = 0;
            };

          //Line,Search,Pset,Point
            if (MSX_VDT_CMD_REG_CMD == 0x7)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_LINE(); //D:VRAM, S:VDP, U:Dot, LINE
                MSX_VDT_ST_REG_CE = 0;
            };
            if (MSX_VDT_CMD_REG_CMD == 0x6)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_SRCH(); //D:VRAM, S:VDP, U:Dot, SRCH
                MSX_VDT_ST_REG_CE = 0;
            };
            if (MSX_VDT_CMD_REG_CMD == 0x5)
             {
               MSX_VDT_ST_REG_CE = 1;
               VDTCMD.MSX_VDT_CMD_REG46_PSET(); //D:VRAM, S:VDP, U:Dot, PSET
                MSX_VDT_ST_REG_CE = 0;
            };
            if (MSX_VDT_CMD_REG_CMD == 0x4)
            {
                MSX_VDT_ST_REG_CE = 1;
                VDTCMD.MSX_VDT_CMD_REG46_POINT(); //D:VDT, S:VRAM, U:Dot, POINT
                MSX_VDT_ST_REG_CE = 0;
            };
 
          //Invalid
          //If MSX_VDT_CMD_REG_CMD = &H3 Then 'Invalid
          //If MSX_VDT_CMD_REG_CMD = &H2 Then 'Invalid
          //If MSX_VDT_CMD_REG_CMD = &H1 Then 'Invalid
 
          //Stop
            if (MSX_VDT_CMD_REG_CMD == 0) //STOP
            {
                MSX_VDT_ST_REG_CE = 0;
                MSX_VDT_ST_REG_TR = 0;
            };
        }

        public static ushort GET_VDT_CMD_REG_NX()
        {
            ushort R;
  
            R = Go_MSX_VDT_CMD_REG_NX;
            if (R == 0)
            {
                if (Gi_MSX_SCREEN_MODE == 5) R = 256;
                if (Gi_MSX_SCREEN_MODE == 6) R = 512;
                if (Gi_MSX_SCREEN_MODE == 7) R = 512;
                if (Gi_MSX_SCREEN_MODE == 8) R = 256;
            };

            return R;
        }

        public static ushort GET_VDT_CMD_REG_NY()
        {
            ushort R;
  
            R = Go_MSX_VDT_CMD_REG_NY;  
          //if (R == 0)
          //{
          //    if (Gi_MSX_SCREEN_MODE == 5) R = 1024;
          //    if (Gi_MSX_SCREEN_MODE == 6) R = 1024;
          //    if (Gi_MSX_SCREEN_MODE == 7) R = 512;
          //    if (Gi_MSX_SCREEN_MODE == 8) R = 512;
          //};

            return R;
        }

        public static void MSX_Color_Setting()
        {
            byte i; byte iGreen = 0; byte iRed = 0; byte iBlue = 0;
          //MSX1 기본색상 - MSX2 에서는 약간 달라짐(특히White색상이더밝아짐)
          //Tranparent (투명)
            MSX_VDT_REG_PAL_Red[0] = 0x0;
            MSX_VDT_REG_PAL_Green[0] = 0x0;
            MSX_VDT_REG_PAL_Blue[0] = 0x0;
          //Black
            MSX_VDT_REG_PAL_Red[1] = 0x0;
            MSX_VDT_REG_PAL_Green[1] = 0x0;
            MSX_VDT_REG_PAL_Blue[1] = 0x0;
          //Medium Green
            MSX_VDT_REG_PAL_Red[2] = 0x20;
            MSX_VDT_REG_PAL_Green[2] = 0xC0;
            MSX_VDT_REG_PAL_Blue[2] = 0x20;
          //Light Green
            MSX_VDT_REG_PAL_Red[3] = 0x60;
            MSX_VDT_REG_PAL_Green[3] = 0xE0;
            MSX_VDT_REG_PAL_Blue[3] = 0x60;
          //Dark Blue
            MSX_VDT_REG_PAL_Red[4] = 0x20;
            MSX_VDT_REG_PAL_Green[4] = 0x20;
            MSX_VDT_REG_PAL_Blue[4] = 0xE0;
          //Light Blue
            MSX_VDT_REG_PAL_Red[5] = 0x40;
            MSX_VDT_REG_PAL_Green[5] = 0x60;
            MSX_VDT_REG_PAL_Blue[5] = 0xE0;
          //Dark Red
            MSX_VDT_REG_PAL_Red[6] = 0xA0;
            MSX_VDT_REG_PAL_Green[6] = 0x20;
            MSX_VDT_REG_PAL_Blue[6] = 0x20;
          //Cyan [Aqua Blue]
            MSX_VDT_REG_PAL_Red[7] = 0x40;
            MSX_VDT_REG_PAL_Green[7] = 0xC0;
            MSX_VDT_REG_PAL_Blue[7] = 0xE0;
          //Medium Red
            MSX_VDT_REG_PAL_Red[8] = 0xE0;
            MSX_VDT_REG_PAL_Green[8] = 0x20;
            MSX_VDT_REG_PAL_Blue[8] = 0x20;
          //Light Red
            MSX_VDT_REG_PAL_Red[9] = 0xE0;
            MSX_VDT_REG_PAL_Green[9] = 0x60;
            MSX_VDT_REG_PAL_Blue[9] = 0x60;
          //Dark Yellow
            MSX_VDT_REG_PAL_Red[10] = 0xC0;
            MSX_VDT_REG_PAL_Green[10] = 0xC0;
            MSX_VDT_REG_PAL_Blue[10] = 0x20;
          //Light Yellow
            MSX_VDT_REG_PAL_Red[11] = 0xC0;
            MSX_VDT_REG_PAL_Green[11] = 0xC0;
            MSX_VDT_REG_PAL_Blue[11] = 0x80;
          //Dark Green
            MSX_VDT_REG_PAL_Red[12] = 0x20;
            MSX_VDT_REG_PAL_Green[12] = 0x80;
            MSX_VDT_REG_PAL_Blue[12] = 0x20;
          //agenta [Purple]
            MSX_VDT_REG_PAL_Red[13] = 0xC0;
            MSX_VDT_REG_PAL_Green[13] = 0x40;
            MSX_VDT_REG_PAL_Blue[13] = 0xA0;
          //ray
            MSX_VDT_REG_PAL_Red[14] = 0xA0;
            MSX_VDT_REG_PAL_Green[14] = 0xA0;
            MSX_VDT_REG_PAL_Blue[14] = 0xA0;
          //hite
            MSX_VDT_REG_PAL_Red[15] = 0xE0;
            MSX_VDT_REG_PAL_Green[15] = 0xE0;
            MSX_VDT_REG_PAL_Blue[15] = 0xE0;

            for (i = 0; i <= 15; i++)
            {
                MSX_COLOR_PALETTE(i, MSX_VDT_REG_PAL_Red[i], MSX_VDT_REG_PAL_Green[i], MSX_VDT_REG_PAL_Blue[i]);
            };

            //MSX2 - Screen 8 소프라이트 색상
            for (i = 0; i <= 15; i++)
            {
                if (i == 00) { iGreen = 0; iRed = 0; iBlue = 0; }; //흑색
                if (i == 01) { iGreen = 0; iRed = 0; iBlue = 2; }; //어두운청색
                if (i == 02) { iGreen = 0; iRed = 3; iBlue = 0; }; //어두운적색
                if (i == 03) { iGreen = 0; iRed = 3; iBlue = 2; }; //어두운자색
                if (i == 04) { iGreen = 3; iRed = 0; iBlue = 0; }; //어두운녹색
                if (i == 05) { iGreen = 3; iRed = 0; iBlue = 2; }; //어두운물색
                if (i == 06) { iGreen = 3; iRed = 3; iBlue = 0; }; //어두운황색
                if (i == 07) { iGreen = 3; iRed = 3; iBlue = 2; }; //회색
                if (i == 08) { iGreen = 4; iRed = 7; iBlue = 2; }; //살색?
                if (i == 09) { iGreen = 0; iRed = 0; iBlue = 7; }; //청색
                if (i == 10) { iGreen = 0; iRed = 7; iBlue = 0; }; //적색
                if (i == 11) { iGreen = 0; iRed = 7; iBlue = 7; }; //자색
                if (i == 12) { iGreen = 7; iRed = 0; iBlue = 0; }; //녹색
                if (i == 13) { iGreen = 7; iRed = 0; iBlue = 7; }; //물색
                if (i == 14) { iGreen = 7; iRed = 7; iBlue = 0; }; //황색
                if (i == 15) { iGreen = 7; iRed = 7; iBlue = 7; }; //백색
                MSX_COLOR_PALETTE_G7(i, iRed, iGreen, iBlue);
            };
        }

        public static void MSX_COLOR_PALETTE(byte iReg, byte iRed, byte iGreen, byte iBlue)
        {
          //Go_MSX_Color[iReg] = FN.goRGB(iBlue, iGreen, iRed); //VB6
            Go_MSX_Color[iReg] = FN.goRGB(iRed, iGreen, iBlue);
            Go_MSX_Color_RGB[iReg] = FN.goRGB(iRed, iGreen, iBlue);
          //Gc_MSX_Color[iReg] = Color.FromArgb(iBlue, iGreen, iRed); //VB6
            Gc_MSX_Color[iReg] = Color.FromArgb(iRed, iGreen, iBlue);
            Gc_MSX_Color_RGB[iReg] = Color.FromArgb(iRed, iGreen, iBlue); 
        }

        public static void MSX_COLOR_PALETTE_G7(byte iReg, byte iRed, byte iGreen, byte iBlue)
        {
          //Go_MSX_Color_G7[iReg] = FN.goRGB((byte)TBL.Gi_M_Table36[iBlue], (byte)TBL.Gi_M_Table36[iGreen], (byte)TBL.Gi_M_Table36[iRed]); //VB6
            Go_MSX_Color_G7[iReg] = FN.goRGB((byte)TBL.Gi_M_Table36[iRed], (byte)TBL.Gi_M_Table36[iGreen], (byte)TBL.Gi_M_Table36[iBlue]);
            Go_MSX_Color_G7_RGB[iReg] = FN.goRGB((byte)TBL.Gi_M_Table36[iRed], (byte)TBL.Gi_M_Table36[iGreen], (byte)TBL.Gi_M_Table36[iBlue]);
          //Gc_MSX_Color_G7[iReg] = Color.FromArgb(TBL.Gi_M_Table36[iBlue], TBL.Gi_M_Table36[iGreen], TBL.Gi_M_Table36[iRed]); //VB6
            Gc_MSX_Color_G7[iReg] = Color.FromArgb(TBL.Gi_M_Table36[iRed], TBL.Gi_M_Table36[iGreen], TBL.Gi_M_Table36[iBlue]);
            Gc_MSX_Color_G7_RGB[iReg] = Color.FromArgb(TBL.Gi_M_Table36[iRed], TBL.Gi_M_Table36[iGreen], TBL.Gi_M_Table36[iBlue]);
        }
    }
}
