﻿namespace csMSX2
{
    public static class VDTCMD
    {
        public static void MSX_VDT_CMD_REG46_HMMC()
        {
            int X, Y;
            int X1, Y1, X2, Y2; sbyte StX, StY;
            ushort Nx, Ny;
            int oAddrY, oAddrX;
            sbyte iFlg;
            int Xp;

            int fo_MSX_VRAM_Buff_Count;

            Nx = VDT.GET_VDT_CMD_REG_NX();
            Ny = VDT.GET_VDT_CMD_REG_NY();

            X1 = VDT.Go_MSX_VDT_CMD_REG_DX;
            Y1 = VDT.Go_MSX_VDT_CMD_REG_DY;
            if (VDT.MSX_VDT_CMD_REG_DIX == 0)
            {
                X2 = X1 + (Nx - 1); StX = 1;
            }
            else
            {
                X2 = X1 - (Nx - 1); StX = -1;
            };
            if (VDT.MSX_VDT_CMD_REG_DIY == 0)
            {
                Y2 = Y1 + (Ny - 1); StY = 1;
            }
            else
            {
                Y2 = Y1 - (Ny - 1); StY = -1;
            };

            fo_MSX_VRAM_Buff_Count = 0;

            iFlg = 0;
            if (VDT.Gi_MSX_SCREEN_MODE == 5) //4 Page, 0~255*0~1023, 16색상
            {
                oAddrY = TBL.Go_M_Table128[Y1]; //(256 / 2)
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 256;
                        if (iFlg == 0)
                        {
                            oAddrX = TBL.Gi_D_Table2[Xp];
                            VDT.MSX_VRAM[oAddrY + oAddrX] = VDT.MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //16Color+16Color
                            fo_MSX_VRAM_Buff_Count = fo_MSX_VRAM_Buff_Count + 1;
                            iFlg = 1;
                        }
                        else
                        {
                            iFlg = 0;
                        };
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 128;
                    }
                    else
                    {
                        oAddrY = oAddrY - 128; if (oAddrY < 0) oAddrY = oAddrY + 128;
                    };
                };
            };

            iFlg = 0;
            if (VDT.Gi_MSX_SCREEN_MODE == 6) //4 Page, 0~511*0~1023, 4색상
            {
                oAddrY = TBL.Go_M_Table128[Y1]; //(512 / 4)
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 512;
                        if (iFlg == 0)
                        {
                            oAddrX = TBL.Gi_D_Table4[Xp];
                            VDT.MSX_VRAM[oAddrY + oAddrX] = VDT.MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //4Color+4Color+4Color+4Color
                            fo_MSX_VRAM_Buff_Count = fo_MSX_VRAM_Buff_Count + 1;
                        };
                        iFlg = (sbyte)(iFlg + 1);
                        if (iFlg == 4) iFlg = 0;
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 128;
                    }
                    else
                    {
                        oAddrY = oAddrY - 128; if (oAddrY < 0) oAddrY = oAddrY + 128;
                    };
                }; 
            };

            iFlg = 0;
            if (VDT.Gi_MSX_SCREEN_MODE == 7) //2 Page, 0~511*0~511, 16색상
            {    
                oAddrY = TBL.Go_M_Table256[Y1]; //(512 / 2)
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 512;
                        if (iFlg == 0)
                        {
                            oAddrX = TBL.Gi_D_Table2[Xp];
                            VDT.MSX_VRAM[oAddrY + oAddrX] = VDT.MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //16Color+16Color
                            fo_MSX_VRAM_Buff_Count = fo_MSX_VRAM_Buff_Count + 1;
                            iFlg = 1;
                        }
                        else
                        {
                            iFlg = 0;
                        };
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 256;
                    }
                    else
                    {
                        oAddrY = oAddrY - 256; if (oAddrY < 0) oAddrY = oAddrY + 256;
                    };
                };
            };

            if (VDT.Gi_MSX_SCREEN_MODE == 8) //2 Page, 0~255*0~511, 256색상
            {
                oAddrY = TBL.Go_M_Table256[Y1];
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY) 
                {
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 256;
                        oAddrX = Xp;
                        VDT.MSX_VRAM[oAddrY + oAddrX] = VDT.MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count]; //256Color
                        fo_MSX_VRAM_Buff_Count = fo_MSX_VRAM_Buff_Count + 1;
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 256;
                    }
                    else
                    {
                        oAddrY = oAddrY - 256; if (oAddrY < 0) oAddrY = oAddrY + 256;
                    };
                };
            };

            if (StY == 1)
            {
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY);
            }
            else
            {
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY);
            };
            VDT.MSX_VDT_CMD_REG_DY();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0); //화면끝 ?
            VDT.MSX_VDT_CMD_REG_NY();

            VDT.Gi_MSX_Screen_Out = 1; //화면표시작업
        }

        public static void MSX_VDT_CMD_REG46_YMMM()
        {
            MSX_VDT_CMD_REG46_HMMM(1);
        }

        public static void MSX_VDT_CMD_REG46_HMMM(sbyte iSel)
        {
            int X, Y;
            int X1, Y1, X2, Y2; sbyte StX, StY;
            ushort Nx, Ny;
            int oAddrY, oAddrX;
            int oAddrY2, oAddrX2, Dx2;
            sbyte iFlg; int iNx;
            int Xp;

            Nx = VDT.GET_VDT_CMD_REG_NX();
            Ny = VDT.GET_VDT_CMD_REG_NY();

            if (iSel == 0)
            {
                X1 = VDT.Go_MSX_VDT_CMD_REG_SX;
                Y1 = VDT.Go_MSX_VDT_CMD_REG_SY;
                if (VDT.MSX_VDT_CMD_REG_DIX == 0)
                {
                    X2 = X1 + (Nx - 1); StX = 1;
                }
                else
                {
                    X2 = X1 - (Nx - 1); StX = -1;
                };
                if (VDT.MSX_VDT_CMD_REG_DIY == 0)
                {
                    Y2 = Y1 + (Ny - 1); StY = 1;
                }
                else
                {
                    Y2 = Y1 - (Ny - 1); StY = -1;
                };
            }
            else
            {
                X1 = VDT.Go_MSX_VDT_CMD_REG_DX;
                Y1 = VDT.Go_MSX_VDT_CMD_REG_SY;
                if (VDT.MSX_VDT_CMD_REG_DIX == 0)
                {
                    if ((VDT.Gi_MSX_SCREEN_MODE == 5) || (VDT.Gi_MSX_SCREEN_MODE == 8))
                    {
                        iNx = 255 - X1 + 1;
                    }
                    else
                    {
                        iNx = 511 - X1 + 1;
                    };
                    X2 = X1 + (iNx - 1); StX = 1;
                }
                else
                {
                    if ((VDT.Gi_MSX_SCREEN_MODE == 5) || (VDT.Gi_MSX_SCREEN_MODE == 8))
                    {
                        iNx = X1 + 1;
                    }
                    else
                    {
                        iNx = X1 + 1;
                    };
                    X2 = X1 - (iNx - 1); StX = -1;
                };
                if (VDT.MSX_VDT_CMD_REG_DIY == 0)
                {
                    Y2 = Y1 + (Ny - 1); StY = 1;
                }
                else
                {
                    Y2 = Y1 - (Ny - 1); StY = -1;
                };
            };

            iFlg = 0;
            if (VDT.Gi_MSX_SCREEN_MODE == 5) //4 Page, 0~255*0~1023, 16색상
            {
                oAddrY = TBL.Go_M_Table128[Y1]; //(256 / 2)
                oAddrY2 = TBL.Go_M_Table128[VDT.Go_MSX_VDT_CMD_REG_DY];
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    Dx2 = 0;
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 256;
                        if (iFlg == 0)
                        {
                            oAddrX = TBL.Gi_D_Table2[Xp];
                            oAddrX2 = TBL.Gi_D_Table2[VDT.Go_MSX_VDT_CMD_REG_DX + Dx2];
                            VDT.MSX_VRAM[oAddrY2 + oAddrX2] = VDT.MSX_VRAM[oAddrY + oAddrX]; //16Color+16Color
                            iFlg = 1;
                        }
                        else
                        {
                            iFlg = 0;
                        };
                        Dx2 = Dx2 + 1;
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 128;
                        oAddrY2 = oAddrY2 + 128;
                    }
                    else
                    {
                        oAddrY = oAddrY - 128; if (oAddrY < 0) oAddrY = oAddrY + 128;
                        oAddrY2 = oAddrY2 - 128; if (oAddrY2 < 0) oAddrY2 = oAddrY2 + 128;
                    };
                };
            };

            iFlg = 0;
            if (VDT.Gi_MSX_SCREEN_MODE == 6) //4 Page, 0~511*0~1023, 4색상
            {
                oAddrY = TBL.Go_M_Table128[Y1]; //(512 / 4)
                oAddrY2 = TBL.Go_M_Table128[VDT.Go_MSX_VDT_CMD_REG_DY];
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    Dx2 = 0;
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 512;
                        if (iFlg == 0)
                        {
                            oAddrX = TBL.Gi_D_Table4[Xp];
                            oAddrX2 = TBL.Gi_D_Table4[VDT.Go_MSX_VDT_CMD_REG_DX + Dx2];
                            VDT.MSX_VRAM[oAddrY2 + oAddrX2] = VDT.MSX_VRAM[oAddrY + oAddrX]; //4Color+4Color+4Color+4Color
                        };
                        iFlg = (sbyte)(iFlg + 1);
                        if (iFlg == 4) iFlg = 0;
                        Dx2 = Dx2 + 1;
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 128;
                        oAddrY2 = oAddrY2 + 128;
                    }
                    else
                    {
                        oAddrY = oAddrY - 128; if (oAddrY < 0) oAddrY = oAddrY + 128;
                        oAddrY2 = oAddrY2 - 128; if (oAddrY2 < 0) oAddrY2 = oAddrY2 + 128;
                    };
                };
            };

            iFlg = 0;
            if (VDT.Gi_MSX_SCREEN_MODE == 7) //2 Page, 0~511*0~511, 16색상
            {
                oAddrY = TBL.Go_M_Table256[Y1]; //(512 / 2)
                oAddrY2 = TBL.Go_M_Table256[VDT.Go_MSX_VDT_CMD_REG_DY];
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    Dx2 = 0;
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 512;
                        if (iFlg == 0)
                        {
                            oAddrX = TBL.Gi_D_Table2[Xp];
                            oAddrX2 = TBL.Gi_D_Table2[VDT.Go_MSX_VDT_CMD_REG_DX + Dx2];
                            VDT.MSX_VRAM[oAddrY2 + oAddrX2] = VDT.MSX_VRAM[oAddrY + oAddrX]; //16Color+16Color
                            iFlg = 1;
                        }
                        else
                        {
                            iFlg = 0;
                        };
                        Dx2 = Dx2 + 1;
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 256;
                        oAddrY2 = oAddrY2 + 256;
                    }
                    else
                    {
                        oAddrY = oAddrY - 256; if (oAddrY < 0) oAddrY = oAddrY + 256;
                        oAddrY2 = oAddrY2 - 256; if (oAddrY2 < 0) oAddrY2 = oAddrY2 + 256;
                    };
                };
            };

            if (VDT.Gi_MSX_SCREEN_MODE == 8) //2 Page, 0~255*0~511, 256색상
            {
                oAddrY = TBL.Go_M_Table256[Y1];
                oAddrY2 = TBL.Go_M_Table256[VDT.Go_MSX_VDT_CMD_REG_DY];
                for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
                {
                    Dx2 = 0;
                    for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                    {
                        Xp = X; if (Xp < 0) Xp = Xp + 256;
                        oAddrX = Xp;
                        oAddrX2 = VDT.Go_MSX_VDT_CMD_REG_DX + Dx2;
                        VDT.MSX_VRAM[oAddrY2 + oAddrX2] = VDT.MSX_VRAM[oAddrY + oAddrX]; //256Color
                        Dx2 = Dx2 + 1;
                    };
                    if (StY == 1)
                    {
                        oAddrY = oAddrY + 256;
                        oAddrY2 = oAddrY2 + 256;
                    }
                    else
                    {
                        oAddrY = oAddrY - 256; if (oAddrY < 0) oAddrY = oAddrY + 256;
                        oAddrY2 = oAddrY2 - 256; if (oAddrY2 < 0) oAddrY2 = oAddrY2 + 256;
                    };
                };
            };

            if (StY == 1)
            {
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY + VDT.Go_MSX_VDT_CMD_REG_NY);
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY);
            }
            else
            {
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY - VDT.Go_MSX_VDT_CMD_REG_NY);
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY);
            };
            VDT.MSX_VDT_CMD_REG_SY();
            VDT.MSX_VDT_CMD_REG_DY();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0); //화면끝 ?
            VDT.MSX_VDT_CMD_REG_NY();
        }

        public static void MSX_VDT_CMD_REG46_HMMV()
        {

            byte iBak;

            iBak = VDT.MSX_VDT_CMD_REG_LO;

            VDT.MSX_VDT_CMD_REG_LO = 0;
            MSX_VDT_CMD_REG46_LMMV();

            VDT.MSX_VDT_CMD_REG_LO = iBak;
        }

        public static void MSX_VDT_CMD_REG46_LMMC()
        {
            int X, Y;
            int X1, Y1, X2, Y2; sbyte StX, StY;
            ushort Nx, Ny;
            byte iColS;
            int Dx, Dy;
            int Xp;

            int fo_MSX_VRAM_Buff_Count;

            Nx = VDT.GET_VDT_CMD_REG_NX();
            Ny = VDT.GET_VDT_CMD_REG_NY();

            X1 = 0;
            Y1 = 0;
            if (VDT.MSX_VDT_CMD_REG_DIX == 0)
            {
                X2 = (Nx - 1); StX = 1;
            }
            else
            {
                X2 = (Nx - 1) * (-1); StX = -1;
            };
            if (VDT.MSX_VDT_CMD_REG_DIY == 0)
            {
                Y2 = (Ny - 1); StY = 1;
            }
            else
            {
                Y2 = (Ny - 1) * (-1); StY = -1;
            };

            fo_MSX_VRAM_Buff_Count = 0;
              
            for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
            {
                Dy = Y + VDT.Go_MSX_VDT_CMD_REG_DY;
                for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                {
                    Xp = X;
                    if (Xp < 0)
                    {
                        if (VDT.Gi_MSX_SCREEN_MODE == 5) Xp = Xp + 256;
                        if (VDT.Gi_MSX_SCREEN_MODE == 6) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 7) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 8) Xp = Xp + 256;
                    };
                    Dx = Xp + VDT.Go_MSX_VDT_CMD_REG_DX;
                    iColS = VDT.MSX_VRAM_Buff[fo_MSX_VRAM_Buff_Count];
                    if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, iColS);
                    if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, iColS);
                    if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, iColS);
                    if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, iColS);
                    fo_MSX_VRAM_Buff_Count = fo_MSX_VRAM_Buff_Count + 1;
                };
            };

            if (StY == 1)
            {
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY);
            }
            else
            {
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY);
            };
            VDT.MSX_VDT_CMD_REG_DY();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0); //화면끝 ?
            VDT.MSX_VDT_CMD_REG_NY();

            VDT.Gi_MSX_Screen_Out = 1; //화면표시작업
        }

        public static void MSX_VDT_CMD_REG46_LMCM()
        {
            int X, Y;
            int X1, Y1, X2, Y2; sbyte StX, StY;
            ushort Nx, Ny;
            int Sx, Sy;
            int Xp;

            Nx = VDT.GET_VDT_CMD_REG_NX();
            Ny = VDT.GET_VDT_CMD_REG_NY();

            X1 = 0;
            Y1 = 0;
            if (VDT.MSX_VDT_CMD_REG_DIX == 0)
            {
                X2 = (Nx - 1); StX = 1;
            }
            else
            {
                X2 = (Nx - 1) * (-1); StX = -1;
            };
            if (VDT.MSX_VDT_CMD_REG_DIY == 0)
            {
                Y2 = (Ny - 1); StY = 1;
            }
            else
            {
                Y2 = (Ny - 1) * (-1); StY = -1;
            };

            VDT.Go_MSX_VRAM_Buff_Count = 0;

            for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
            {
                Sy = Y + VDT.Go_MSX_VDT_CMD_REG_SY;
                for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                {
                    Xp = X;
                    if (Xp < 0)
                    {
                        if (VDT.Gi_MSX_SCREEN_MODE == 5) Xp = Xp + 256;
                        if (VDT.Gi_MSX_SCREEN_MODE == 6) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 7) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 8) Xp = Xp + 256;
                    };
                    Sx = Xp + VDT.Go_MSX_VDT_CMD_REG_SX;
                    if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMCM_5(Sx, Sy);
                    if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMCM_6(Sx, Sy);
                    if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMCM_7(Sx, Sy);
                    if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMCM_8(Sx, Sy);
                    VDT.Go_MSX_VRAM_Buff_Count = VDT.Go_MSX_VRAM_Buff_Count + 1;
                }; 
            }; 

            if (StY == 1)
            {
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY + VDT.Go_MSX_VDT_CMD_REG_NY);
            }
            else
            {
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY - VDT.Go_MSX_VDT_CMD_REG_NY);
            };
            VDT.MSX_VDT_CMD_REG_SY();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0); //화면끝 ?
            VDT.MSX_VDT_CMD_REG_NY();
            VDT.MSX_VDT_CMD_REG_CLR();
        }

      //4 Page, 0~255*0~1023, 16색상
        public static void MSX_VDT_CMD_REG46_LMCM_5(int Sx, int Sy)
        {
            int iPosS;
            byte iColS = 0;
            byte iColS2;
            int oAddrS;

            iPosS = TBL.Gi_Col_Pos2[Sx];
            oAddrS = TBL.Go_M_Table128[Sy] + TBL.Gi_D_Table2[Sx]; //256/2*1024/2

            iColS2 = VDT.MSX_VRAM[oAddrS];
            if (iPosS == 0) iColS = (byte)TBL.Gi_D_Table16[iColS2 & 0xF0];
            if (iPosS == 1) iColS = (byte)(iColS2 & 0xF);

            VDT.MSX_VRAM_Buff[VDT.Go_MSX_VRAM_Buff_Count] = iColS;

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS;
        }

      //4 Page, 0~511*0~1023, 4색상
        public static void MSX_VDT_CMD_REG46_LMCM_6(int Sx, int Sy)
        {
            int iPosS;
            byte iColS = 0;
            byte iColS2;
            int oAddrS;

            iPosS = TBL.Gi_Col_Pos4[Sx];
            oAddrS = TBL.Go_M_Table128[Sy] + TBL.Gi_D_Table4[Sx]; //512/4*1024/4

            iColS2 = VDT.MSX_VRAM[oAddrS];
            if (iPosS == 0) iColS = (byte)TBL.Gi_D_Table64[iColS2];
            if (iPosS == 1) iColS = (byte)TBL.Gi_D_Table16[iColS2 & 63];
            if (iPosS == 2) iColS = (byte)TBL.Gi_D_Table4[iColS2 & 15];
            if (iPosS == 3) iColS = (byte)(iColS2 & 3);

            VDT.MSX_VRAM_Buff[VDT.Go_MSX_VRAM_Buff_Count] = iColS;

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS;
        }
              
      //2 Page, 0~511*0~511, 16색상
        public static void MSX_VDT_CMD_REG46_LMCM_7(int Sx, int Sy)
        {
            int iPosS;
            byte iColS = 0;
            byte iColS2;
            int oAddrS;

            iPosS = TBL.Gi_Col_Pos2[Sx];
            oAddrS = TBL.Go_M_Table256[Sy] + TBL.Gi_D_Table2[Sx]; //512/2*512/2

            iColS2 = VDT.MSX_VRAM[oAddrS];
            if (iPosS == 0) iColS = (byte)TBL.Gi_D_Table16[iColS2 & 0xF0];
            if (iPosS == 1) iColS = (byte)(iColS2 & 0xF);

            VDT.MSX_VRAM_Buff[VDT.Go_MSX_VRAM_Buff_Count] = iColS;

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS;
        }

      //2 Page, 0~255*0~511, 256색상
        public static void MSX_VDT_CMD_REG46_LMCM_8(int Sx, int Sy)
        {
            byte iColS;
            int oAddrS;

            oAddrS = TBL.Go_M_Table256[Sy] + Sx; //256*512

            iColS = VDT.MSX_VRAM[oAddrS];

            VDT.MSX_VRAM_Buff[VDT.Go_MSX_VRAM_Buff_Count] = iColS;

            VDT.Gi_MSX_VDT_CMD_REG_Color = iColS;
        }

        public static void MSX_VDT_CMD_REG46_LMMM()
        {
            int X, Y;
            int X1, Y1, X2, Y2; sbyte StX, StY;
            ushort Nx, Ny;
            int Sx, Sy;
            int Dx, Dy;
            int Xp;

            Nx = VDT.GET_VDT_CMD_REG_NX();
            Ny = VDT.GET_VDT_CMD_REG_NY();

            X1 = 0;
            Y1 = 0;
            if (VDT.MSX_VDT_CMD_REG_DIX == 0)
            {
                X2 = (Nx - 1); StX = 1;
            }
            else
            {
                X2 = (Nx - 1) * (-1); StX = -1;
            };
            if (VDT.MSX_VDT_CMD_REG_DIY == 0)
            {
                Y2 = (Ny - 1); StY = 1;
            }
            else
            {
                Y2 = (Ny - 1) * (-1); StY = -1;
            };
              
            for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
            {
                Sy = Y + VDT.Go_MSX_VDT_CMD_REG_SY;
                Dy = Y + VDT.Go_MSX_VDT_CMD_REG_DY;
                for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                {
                    Xp = X;
                    if (Xp < 0)
                    {
                        if (VDT.Gi_MSX_SCREEN_MODE == 5) Xp = Xp + 256;
                        if (VDT.Gi_MSX_SCREEN_MODE == 6) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 7) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 8) Xp = Xp + 256;
                    };
                    Sx = Xp + VDT.Go_MSX_VDT_CMD_REG_SX;
                    Dx = Xp + VDT.Go_MSX_VDT_CMD_REG_DX;
                    if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMMM_5(Sx, Sy, Dx, Dy);
                    if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMMM_6(Sx, Sy, Dx, Dy);
                    if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMMM_7(Sx, Sy, Dx, Dy);
                    if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMMM_8(Sx, Sy, Dx, Dy);
                }; 
            }; 

            if (StY == 1)
            {
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY + VDT.Go_MSX_VDT_CMD_REG_NY);
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY);
            }
            else
            {
                VDT.Go_MSX_VDT_CMD_REG_SY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_SY - VDT.Go_MSX_VDT_CMD_REG_NY);
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY);
            };
            VDT.MSX_VDT_CMD_REG_SY();
            VDT.MSX_VDT_CMD_REG_DY();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0); //화면끝 ?
            VDT.MSX_VDT_CMD_REG_NY();
        }

      //4 Page, 0~255*0~1023, 16색상
        public static void MSX_VDT_CMD_REG46_LMMM_5(int Sx, int Sy, int Dx, int Dy)
        {
            int iPosS, iPosD;
            byte iColS = 0, iColD = 0, iColT;
            byte iColS2, iColD2;
            int oAddrS, oAddrD;

            iPosS = TBL.Gi_Col_Pos2[Sx];
            oAddrS = (TBL.Go_M_Table128[Sy] + TBL.Gi_D_Table2[Sx]); //256/2*1024/2
            iPosD = TBL.Gi_Col_Pos2[Dx];
            oAddrD = (TBL.Go_M_Table128[Dy] + TBL.Gi_D_Table2[Dx]); //256/2*1024/2

            iColS2 = VDT.MSX_VRAM[oAddrS];
            if (iPosS == 0) iColS = (byte)TBL.Gi_D_Table16[iColS2 & 0xF0];
            if (iPosS == 1) iColS = (byte)(iColS2 & 0xF);
            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)TBL.Gi_D_Table16[iColD2 & 0xF0];
            if (iPosD == 1) iColD = (byte)(iColD2 & 0xF);

            iColT = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 15);

            if (iPosD == 0) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF) | TBL.Gi_M_Table16[iColT]);
            if (iPosD == 1) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF0) | iColT);
        }

      //4 Page, 0~511*0~1023, 4색상
        public static void MSX_VDT_CMD_REG46_LMMM_6(int Sx, int Sy, int Dx, int Dy)
        {
            int iPosS, iPosD;
            byte iColS = 0, iColD = 0, iColT;
            byte iColS2, iColD2;
            int oAddrS, oAddrD;

            iPosS = TBL.Gi_Col_Pos4[Sx];
            oAddrS = TBL.Go_M_Table128[Sy] + TBL.Gi_D_Table4[Sx]; //512/4*1024/4
            iPosD = TBL.Gi_Col_Pos4[Dx];
            oAddrD = TBL.Go_M_Table128[Dy] + TBL.Gi_D_Table4[Dx]; //512/4*1024/4

            iColS2 = VDT.MSX_VRAM[oAddrS];
            if (iPosS == 0) iColS = (byte)TBL.Gi_D_Table64[iColS2 >> 6]; //[/]64
            if (iPosS == 1) iColS = (byte)TBL.Gi_D_Table16[(iColS2 & 63) >> 4]; //[/]16
            if (iPosS == 2) iColS = (byte)TBL.Gi_D_Table4[(iColS2 & 15) >> 2]; //[/]4
            if (iPosS == 3) iColS = (byte)(iColS2 & 3);
            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)TBL.Gi_D_Table64[iColD2 >> 6]; //[/]64
            if (iPosD == 1) iColD = (byte)TBL.Gi_D_Table16[(iColD2 & 63) >> 4]; //[/]16
            if (iPosD == 2) iColD = (byte)TBL.Gi_D_Table4[(iColD2 & 15) >> 2]; //[/]4
            if (iPosD == 3) iColD = (byte)(iColD2 & 3);

            iColT = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 3);

            if (iPosD == 0) VDT.MSX_VRAM[oAddrD] = (byte)(((iColD2 & 63) & 0xF0) | (iColT << 6)); //[*]64
            if (iPosD == 1) VDT.MSX_VRAM[oAddrD] = (byte)(((iColD2 & 207) & 0xF0) | (iColT << 4)); //[*]16
            if (iPosD == 2) VDT.MSX_VRAM[oAddrD] = (byte)(((iColD2 & 243) & 0xF0) | (iColT << 2)); //[*]4
            if (iPosD == 3) VDT.MSX_VRAM[oAddrD] = (byte)(((iColD2 & 252) & 0xF0) | iColT);
        }
              
      //2 Page, 0~511*0~511, 16색상
        public static void MSX_VDT_CMD_REG46_LMMM_7(int Sx, int Sy, int Dx, int Dy)
        {
            int iPosS, iPosD;
            byte iColS = 0, iColD = 0, iColT;
            byte iColS2, iColD2;
            int oAddrS, oAddrD;

            iPosS = TBL.Gi_Col_Pos2[Sx];
            oAddrS = TBL.Go_M_Table256[Sy] + TBL.Gi_D_Table2[Sx]; //512/2*512/2
            iPosD = TBL.Gi_Col_Pos2[Dx];
            oAddrD = TBL.Go_M_Table256[Dy] + TBL.Gi_D_Table2[Dx]; //512/2*512/2

            iColS2 = VDT.MSX_VRAM[oAddrS];
            if (iPosS == 0) iColS = (byte)TBL.Gi_D_Table16[iColS2 & 0xF0];
            if (iPosS == 1) iColS = (byte)(iColS2 & 0xF);
            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)TBL.Gi_D_Table16[iColD2 & 0xF0];
            if (iPosD == 1) iColD = (byte)(iColD2 & 0xF);

            iColT = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 15);

            if (iPosD == 0) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF) | TBL.Gi_M_Table16[iColT]);
            if (iPosD == 1) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF0) | iColT);
        }

      //2 Page, 0~255*0~511, 256색상
        public static void MSX_VDT_CMD_REG46_LMMM_8(int Sx, int Sy, int Dx, int Dy)
        {
            byte iColS, iColD;
            int oAddrS, oAddrD;

            oAddrS = TBL.Go_M_Table256[Sy] + Sx; //256*512
            oAddrD = TBL.Go_M_Table256[Dy] + Dx; //256*512

            iColS = VDT.MSX_VRAM[oAddrS];
            iColD = VDT.MSX_VRAM[oAddrD];

            VDT.MSX_VRAM[oAddrD] = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 255);
        }

        public static void MSX_VDT_CMD_REG46_LMMV()
        {
            int X, Y;
            int X1, Y1, X2, Y2; sbyte StX, StY;
            ushort Nx, Ny;
            int Dx, Dy;
            int Xp;

            Nx = VDT.GET_VDT_CMD_REG_NX();
            Ny = VDT.GET_VDT_CMD_REG_NY();

            X1 = 0;
            Y1 = 0;
            if (VDT.MSX_VDT_CMD_REG_DIX == 0)
            {
                X2 = (Nx - 1); StX = 1;
            }
            else
            {
                X2 = (Nx - 1) * (-1); StX = -1;
            };
            if (VDT.MSX_VDT_CMD_REG_DIY == 0)
            {
                Y2 = (Ny - 1); StY = 1;
            }
            else
            {
                Y2 = (Ny - 1) * (-1); StY = -1;
            };

            for (Y = Y1; (StY == 1 ? Y <= Y2 : Y >= Y2); Y = Y + StY)
            {
                Dy = Y + VDT.Go_MSX_VDT_CMD_REG_DY;
                for (X = X1; (StX == 1 ? X <= X2 : X >= X2); X = X + StX)
                {
                    Xp = X;
                    if (Xp < 0)
                    {
                        if (VDT.Gi_MSX_SCREEN_MODE == 5) Xp = Xp + 256;
                        if (VDT.Gi_MSX_SCREEN_MODE == 6) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 7) Xp = Xp + 512;
                        if (VDT.Gi_MSX_SCREEN_MODE == 8) Xp = Xp + 256;
                    };
                    Dx = Xp + VDT.Go_MSX_VDT_CMD_REG_DX;
                    if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
                }; 
            }; 

            if (StY == 1)
            {
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_NY);
            }
            else
            {
                VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_NY);
            };
            VDT.MSX_VDT_CMD_REG_DY();
            VDT.Go_MSX_VDT_CMD_REG_NY = Z80A.goGetLngToLng(0); //화면끝 ?
            VDT.MSX_VDT_CMD_REG_NY();
        }

      //4 Page, 0~255*0~1023, 16색상
        public static void MSX_VDT_CMD_REG46_LMMV_5(int Dx, int Dy, int iCol)
        {
            int iPosD;
            byte iColS, iColD = 0, iColT;
            byte iColD2;
            int oAddrD;

            if ((Dx < 0) || (Dx > 255)) goto LastProc;
            if ((Dy < 0) || (Dy > 1023)) goto LastProc;

            iPosD = TBL.Gi_Col_Pos2[Dx];
            oAddrD = TBL.Go_M_Table128[Dy] + TBL.Gi_D_Table2[Dx]; //256/2*1024/2

            if (iCol == (-1))
            {
                iColS = (byte)(VDT.Gi_MSX_VDT_CMD_REG_Color & 15);
            }
            else
            {
                iColS = (byte)(iCol & 15);
            };
            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)TBL.Gi_D_Table16[iColD2 & 0xF0];
            if (iPosD == 1) iColD = (byte)(iColD2 & 0xF);

            iColT = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 15);

            if (iPosD == 0) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF) | TBL.Gi_M_Table16[iColT]);
            if (iPosD == 1) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF0) | iColT);

        LastProc: ;
        }

      //4 Page, 0~511*0~1023, 4색상
        public static void MSX_VDT_CMD_REG46_LMMV_6(int Dx, int Dy, int iCol)
        {
            int iPosD;
            byte iColS, iColD = 0, iColT;
            byte iColD2;
            int oAddrD;

            if ((Dx < 0) || (Dx > 511)) goto LastProc;
            if ((Dy < 0) || (Dy > 1023)) goto LastProc;

            iPosD = TBL.Gi_Col_Pos4[Dx];
            oAddrD = TBL.Go_M_Table128[Dy] + TBL.Gi_D_Table4[Dx]; //512/4*1024/4

            if (iCol == (-1))
            {
                iColS = (byte)(VDT.Gi_MSX_VDT_CMD_REG_Color & 3);
            }
            else
            {
                iColS = (byte)(iCol & 3);
            };
            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)TBL.Gi_D_Table64[iColD2];
            if (iPosD == 1) iColD = (byte)TBL.Gi_D_Table16[iColD2 & 63];
            if (iPosD == 2) iColD = (byte)TBL.Gi_D_Table4[iColD2 & 15];
            if (iPosD == 3) iColD = (byte)(iColD2 & 3);

            iColT = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 3);

            if (iPosD == 0) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 63) | TBL.Gi_M_Table64[iColT]);
            if (iPosD == 1) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 207) | TBL.Gi_M_Table16[iColT]);
            if (iPosD == 2) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 243) | TBL.Gi_M_Table4[iColT]);
            if (iPosD == 3) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 252) | iColT);

        LastProc: ;
        }
              
      //2 Page, 0~511*0~511, 16색상
        public static void MSX_VDT_CMD_REG46_LMMV_7(int Dx, int Dy, int iCol)
        {
            int iPosD;
            byte iColS, iColD = 0, iColT;
            byte iColD2;
            int oAddrD;

            if ((Dx < 0) || (Dx > 511)) goto LastProc;
            if ((Dy < 0) || (Dy > 511)) goto LastProc;

            iPosD = TBL.Gi_Col_Pos2[Dx];
            oAddrD = TBL.Go_M_Table256[Dy] + TBL.Gi_D_Table2[Dx]; //512/2*512/2

            if (iCol == (-1))
            {
                iColS = (byte)(VDT.Gi_MSX_VDT_CMD_REG_Color & 15);
            }
            else
            {
                iColS = (byte)(iCol & 15);
            };
            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)TBL.Gi_D_Table16[iColD2 & 0xF0];
            if (iPosD == 1) iColD = (byte)(iColD2 & 0xF);

            iColT = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 15);

            if (iPosD == 0) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF) | TBL.Gi_M_Table16[iColT]);
            if (iPosD == 1) VDT.MSX_VRAM[oAddrD] = (byte)((iColD2 & 0xF0) | iColT);

        LastProc: ;
        }

      //2 Page, 0~255*0~511, 256색상
        public static void MSX_VDT_CMD_REG46_LMMV_8(int Dx, int Dy, int iCol)
        {
            byte iColS, iColD;
            int oAddrD;

            if ((Dx < 0) || (Dx > 255)) goto LastProc;
            if ((Dy < 0) || (Dy > 511)) goto LastProc;

            oAddrD = TBL.Go_M_Table256[Dy] + Dx; //256*512

            if (iCol == (-1))
            {
                iColS = VDT.Gi_MSX_VDT_CMD_REG_Color;
            }
            else
            {
                iColS = (byte)iCol;
            };
            iColD = VDT.MSX_VRAM[oAddrD];

            VDT.MSX_VRAM[oAddrD] = (byte)(fi_MSX_VDT_CMD_LO(iColS, iColD) & 255);

        LastProc: ;
        }

      //Line
        public static void MSX_VDT_CMD_REG46_LINE()
        {
            int i;
            int X1, Y1, X2, Y2;
            int Y;
            double F; int F1, F2;
            int Dx, Dy;
             
            X1 = VDT.Go_MSX_VDT_CMD_REG_DX;
            Y1 = VDT.Go_MSX_VDT_CMD_REG_DY;
            if (VDT.MSX_VDT_CMD_REG_MAJ == 0) //X긴변
            {
                if (VDT.MSX_VDT_CMD_REG_DIX == 0)
                {
                    X2 = X1 + (VDT.Go_MSX_VDT_CMD_REG_Mjg);
                }
                else
                {
                    X2 = X1 + ((VDT.Go_MSX_VDT_CMD_REG_Mjg) * (-1));
                };
                if (VDT.MSX_VDT_CMD_REG_DIY == 0)
                {
                    Y2 = Y1 + (VDT.Go_MSX_VDT_CMD_REG_Min);
                }
                else
                {
                    Y2 = Y1 + ((VDT.Go_MSX_VDT_CMD_REG_Min) * (-1));
                };
                if (X1 > X2)
                {
                    FN.gtSwap16(ref X1, ref X2);
                    FN.gtSwap16(ref Y1, ref Y2);
                };
                F2 = X2 - X1;
                if (Y1 <= Y2)
                {
                    Y = 1;
                    F1 = Y2 - Y1;
                }
                else
                {
                    Y = -1;
                    F1 = Y1 - Y2;
                };
                F = 0; if (F2 != 0) F = (double)(F1) / (double)(F2);
                for (i = 0; i <= (X2 - X1); i++)
                {
                    Dx = X1 + i;
                    Dy = Y1 + ((int)(i * F + 0.5) * Y);
                    if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
                };
            }
            else //Y긴변
            {
                if (VDT.MSX_VDT_CMD_REG_DIX == 0)
                {
                    X2 = X1 + (VDT.Go_MSX_VDT_CMD_REG_Min);
                }
                else 
                {
                    X2 = X1 + ((VDT.Go_MSX_VDT_CMD_REG_Min) * (-1));
                };
                if (VDT.MSX_VDT_CMD_REG_DIY == 0)
                {
                    Y2 = Y1 + (VDT.Go_MSX_VDT_CMD_REG_Mjg);
                }
                else
                {
                    Y2 = Y1 + ((VDT.Go_MSX_VDT_CMD_REG_Mjg) * (-1));
                };
                if (Y1 > Y2)
                {
                    FN.gtSwap16(ref X1, ref X2);
                    FN.gtSwap16(ref Y1, ref Y2);
                };
                F2 = Y2 - Y1;
                if (X1 <= X2)
                {
                    Y = 1;
                    F1 = X2 - X1;
                }
                else
                {
                    Y = -1;
                    F1 = X1 - X2;
                };
                F = 0; if (F2 != 0) F = (double)(F1) / (double)(F2);
                for (i = 0; i <= (Y2 - Y1); i++)
                {
                    Dy = Y1 + i;
                    Dx = X1 + ((int)(i * F + 0.5) * Y);
                    if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
                    if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
                };
            };

            if (VDT.MSX_VDT_CMD_REG_MAJ == 0) //X긴변
            {
                if (VDT.MSX_VDT_CMD_REG_DIY == 0)
                {
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_Min);
                }
                else
                {
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_Min);
                };
            }
            else //Y긴변
            { 
                if (VDT.MSX_VDT_CMD_REG_DIY == 0)
                {
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY + VDT.Go_MSX_VDT_CMD_REG_Min);
                }
                else
                {
                    VDT.Go_MSX_VDT_CMD_REG_DY = Z80A.goGetLngToLng(VDT.Go_MSX_VDT_CMD_REG_DY - VDT.Go_MSX_VDT_CMD_REG_Min);
                };
            };
            VDT.MSX_VDT_CMD_REG_DY();
        }

        public static void MSX_VDT_CMD_REG46_SRCH()
        {
            int i;
            int X2 = 0; sbyte StX;
            int Sx, Sy;
            byte iCol = 0;

            Sx = VDT.Go_MSX_VDT_CMD_REG_SX;
            Sy = VDT.Go_MSX_VDT_CMD_REG_SY;

            if (VDT.MSX_VDT_CMD_REG_DIX == 0)
            {
                if (VDT.Gi_MSX_SCREEN_MODE == 5) X2 = 255;
                if (VDT.Gi_MSX_SCREEN_MODE == 6) X2 = 511;
                if (VDT.Gi_MSX_SCREEN_MODE == 7) X2 = 511;
                if (VDT.Gi_MSX_SCREEN_MODE == 8) X2 = 255;
                StX = 1;
            }
            else
            {
                X2 = 0;
                StX = -1;
            };

            VDT.MSX_VDT_ST_REG_BD = 0;

            for (i = Sx; (StX == 1 ? i <= X2 : i >= X2); i = i + StX)
            {
                if (VDT.Gi_MSX_SCREEN_MODE == 5) iCol = MSX_VDT_CMD_REG46_POINT_5(i, Sy);
                if (VDT.Gi_MSX_SCREEN_MODE == 6) iCol = MSX_VDT_CMD_REG46_POINT_6(i, Sy);
                if (VDT.Gi_MSX_SCREEN_MODE == 7) iCol = MSX_VDT_CMD_REG46_POINT_7(i, Sy);
                if (VDT.Gi_MSX_SCREEN_MODE == 8) iCol = MSX_VDT_CMD_REG46_POINT_8(i, Sy);
                if (VDT.MSX_VDT_CMD_REG_EQ == 0) //경계색발견
                {
                    if (iCol == VDT.Gi_MSX_VDT_CMD_REG_Color)
                    {
                        VDT.MSX_VDT_ST_REG_BD = 1; //발견
                        VDT.Go_MSX_VDT_ST_REG_BX = (i & 511) | 65024; //11111118 76543210
                        goto LastProc;
                    };
                }
                else //경계색이외를발견
                { 
                    if (iCol != VDT.Gi_MSX_VDT_CMD_REG_Color)
                    {
                        VDT.MSX_VDT_ST_REG_BD = 1; //발견
                        VDT.Go_MSX_VDT_ST_REG_BX = (i & 511) | 65024; //11111118 76543210
                        goto LastProc;
                    };
                };
            }; 

        LastProc: ;
        }

      //Pset
        public static void MSX_VDT_CMD_REG46_PSET()
        {
            int Dx, Dy;
              
            Dx = VDT.Go_MSX_VDT_CMD_REG_DX;
            Dy = VDT.Go_MSX_VDT_CMD_REG_DY;
            if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_VDT_CMD_REG46_LMMV_5(Dx, Dy, -1);
            if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_VDT_CMD_REG46_LMMV_6(Dx, Dy, -1);
            if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_VDT_CMD_REG46_LMMV_7(Dx, Dy, -1);
            if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_VDT_CMD_REG46_LMMV_8(Dx, Dy, -1);
        }

        public static void MSX_VDT_CMD_REG46_POINT()
        {
            int Sx, Sy;
              
            Sx = VDT.Go_MSX_VDT_CMD_REG_SX;
            Sy = VDT.Go_MSX_VDT_CMD_REG_SY;
            if (VDT.Gi_MSX_SCREEN_MODE == 5) VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_5(Sx, Sy);
            if (VDT.Gi_MSX_SCREEN_MODE == 6) VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_6(Sx, Sy);
            if (VDT.Gi_MSX_SCREEN_MODE == 7) VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_7(Sx, Sy);
            if (VDT.Gi_MSX_SCREEN_MODE == 8) VDT.Gi_MSX_VDT_ST_REG_Color = MSX_VDT_CMD_REG46_POINT_8(Sx, Sy);

            VDT.Gi_MSX_VDT_CMD_REG_Color = VDT.Gi_MSX_VDT_ST_REG_Color;
            VDT.MSX_VDT_CMD_REG_CLR();
        }

      //4 Page, 0~255*0~1023, 16색상
        public static byte MSX_VDT_CMD_REG46_POINT_5(int Sx, int Sy)
        {
            int iPosD;
            byte iColD, iColD2;
            int oAddrD;

            iColD = 0;
            if ((Sx < 0) || (Sx > 255)) goto LastProc;
            if ((Sy < 0) || (Sy > 1023)) goto LastProc;

            iPosD = TBL.Gi_Col_Pos2[Sx];
            oAddrD = TBL.Go_M_Table128[Sy] + TBL.Gi_D_Table2[Sx]; //256/2*1024/2

            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)(TBL.Gi_D_Table16[iColD2 & 0xF0]);
            if (iPosD == 1) iColD = (byte)(iColD2 & 0xF);

        LastProc: ;
            return iColD;
        }

      //4 Page, 0~511*0~1023, 4색상
        public static byte MSX_VDT_CMD_REG46_POINT_6(int Sx, int Sy)
        {
            int iPosD;
            byte iColD, iColD2;
            int oAddrD;

            iColD = 0;
            if ((Sx < 0) || (Sx > 511)) goto LastProc;
            if ((Sy < 0) || (Sy > 1023)) goto LastProc;

            iPosD = TBL.Gi_Col_Pos4[Sx];
            oAddrD = TBL.Go_M_Table128[Sy] + TBL.Gi_D_Table4[Sx]; //512/4*1024/4

            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)(TBL.Gi_D_Table64[iColD2]);
            if (iPosD == 1) iColD = (byte)(TBL.Gi_D_Table16[iColD2 & 63]);
            if (iPosD == 2) iColD = (byte)(TBL.Gi_D_Table4[iColD2 & 15]);
            if (iPosD == 3) iColD = (byte)(iColD2 & 3);

        LastProc: ;
            return iColD;
        }
              
      //2 Page, 0~511*0~511, 16색상
        public static byte MSX_VDT_CMD_REG46_POINT_7(int Sx, int Sy)
        {
            int iPosD;
            byte iColD, iColD2;
            int oAddrD;

            iColD = 0;
            if ((Sx < 0) || (Sx > 511)) goto LastProc;
            if ((Sy < 0) || (Sy > 511)) goto LastProc;

            iPosD = TBL.Gi_Col_Pos2[Sx];
            oAddrD = TBL.Go_M_Table256[Sy] + TBL.Gi_D_Table2[Sx]; //512/2*512/2

            iColD2 = VDT.MSX_VRAM[oAddrD];
            if (iPosD == 0) iColD = (byte)(TBL.Gi_D_Table16[iColD2 & 0xF0]);
            if (iPosD == 1) iColD = (byte)(iColD2 & 0xF);

        LastProc:
            return iColD;
        }

      //2 Page, 0~255*0~511, 256색상
        public static byte MSX_VDT_CMD_REG46_POINT_8(int Sx, int Sy)
        {
            byte iColD;
            int oAddrD;

            iColD = 0;
            if ((Sx < 0) || (Sx > 255)) goto LastProc;
            if ((Sy < 0) || (Sy > 511)) goto LastProc;

            oAddrD = TBL.Go_M_Table256[Sy] + Sx; //256*512

            iColD = VDT.MSX_VRAM[oAddrD];

        LastProc: ;
            return iColD;
        }

        public static byte fi_MSX_VDT_CMD_LO(byte iColS, byte iColD)
        {
            byte R;

            R = 0;

            if (VDT.MSX_VDT_CMD_REG_LO == 0x0) R = iColS;
            if (VDT.MSX_VDT_CMD_REG_LO == 0x1) R = (byte)(iColS & iColD);
            if (VDT.MSX_VDT_CMD_REG_LO == 0x2) R = (byte)(iColS | iColD);
            if (VDT.MSX_VDT_CMD_REG_LO == 0x3) R = (byte)((Z80A.giGetIntToInt(~iColS) & iColD) | (iColS & Z80A.giGetIntToInt(~iColD)));
            if (VDT.MSX_VDT_CMD_REG_LO == 0x4) R = (byte)(Z80A.giGetIntToInt(~iColS));

            if ((VDT.MSX_VDT_CMD_REG_LO >= 0x8) && (VDT.MSX_VDT_CMD_REG_LO <= 0xC))
            {
                if (iColS == 0)
                {
                    R = iColD;
                }
                else
                {
                    if (VDT.MSX_VDT_CMD_REG_LO == 0x8) R = iColS;
                    if (VDT.MSX_VDT_CMD_REG_LO == 0x9) R = (byte)(iColS & iColD);
                    if (VDT.MSX_VDT_CMD_REG_LO == 0xA) R = (byte)(iColS | iColD);
                    if (VDT.MSX_VDT_CMD_REG_LO == 0xB) R = (byte)((Z80A.giGetIntToInt(~iColS) & iColD) | (iColS & Z80A.giGetIntToInt(~iColD)));
                    if (VDT.MSX_VDT_CMD_REG_LO == 0xC) R = Z80A.giGetIntToInt(~iColS);
                };
            };

            return R;
        }
    }
}
