﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;

namespace csMSX2
{
    public static class VDTOUT
    {
        [DllImport("gdi32.dll")] static extern int StretchDIBits(IntPtr hdc, int XDest, int YDest, int nDestWidth, int nDestHeight, int XSrc, int YSrc, int nSrcWidth, int nSrcHeight, int[] lpBits, [In] ref BITMAPINFO lpBitsInfo, uint iUsage, uint dwRop);

        private const uint DIB_RGB_COLORS = 0;
        private const uint SRCCOPY = 0xCC0020;
        private const uint SRCAND = 0x008800C6;
        private const int BI_RGB = 0;
        private const int GDI_ERROR = -1;
        
        [StructLayout(LayoutKind.Sequential)]
        public struct BITMAPINFOHEADER
        {
            public uint biSize;
            public int biWidth;
            public int biHeight;
            public ushort biPlanes;
            public ushort biBitCount;
            public uint biCompression;
            public uint biSizeImage;
            public int biXPelsPerMeter;
            public int biYPelsPerMeter;
            public uint biClrUsed;
            public uint biClrImportant;
        }

        [StructLayout(LayoutKind.Sequential)]
        public struct RGBQUAD
        {
            public int rgbBlue;
            public int rgbGreen;
            public int rgbRed;
            public int rgbReserved;
        };

        [StructLayout(LayoutKind.Sequential)]
        public struct BITMAPINFO
        {
            public BITMAPINFOHEADER bmiHeader;
            public RGBQUAD bmiColors;
        }

        public static BITMAPINFO vdtBMPInfo = new BITMAPINFO();

      //MSX1
        public static int[] vdtBuffer40 = new int[61440];       //320*192(40*8*24*8)(40*24=960Char)
        public static int[] vdtBuffer46 = new int[46080];       //240*192(40*6*24*8)(40*24=960Char)//글자우측2Dot표시안함(가로로크게표시됨)
        public static int[] vdtBuffer32 = new int[49152];       //256*192(32*8*24*8)(32*24=768Char)
        public static short[] vdtBufferSpr = new short[49152];  //256*192
      //MSX2
        public static int[] vdtBuffer80 = new int[122880];      //640*192(80*8*24*8)(80*27=2160Char)
        public static int[] vdtBuffer80p = new int[135680];     //640*212(80*8*26.5*8)(80*27=2160Char)
        public static int[] vdtBuffer86 = new int[92160];       //480*192(80*6*24*8)(80*27=2160Char)//글자우측2Dot표시안함(가로로크게표시됨)
        public static int[] vdtBuffer86p = new int[101760];     //480*212(80*6*26.5*8)(80*27=2160Char)//글자우측2Dot표시안함(가로로크게표시됨)
        public static int[] vdtBuffer32p = new int[54272];      //256*212(32*8*26.5*8)
        public static int[] vdtBuffer64 = new int[98304];       //512*192(64*8*24*8)
        public static int[] vdtBuffer64p = new int[108544];     //512*212(64*8*26.5*8)
        public static short[] vdtBufferSpr2 = new short[54272]; //256*212

      //MSX1 - Scale2x
        public static int[] vdt2Buffer40 = new int[61440 * 4];
        public static int[,] vdt2XyBuffer40 = new int[320 * 2, 192 * 2];
        public static int[] vdt2Buffer46 = new int[46080 * 4];
        public static int[,] vdt2XyBuffer46 = new int[240 * 2, 192 * 2];
        public static int[] vdt2Buffer32 = new int[49152 * 4];
        public static int[,] vdt2XyBuffer32 = new int[256 * 2, 192 * 2];
      //MSX2 - Scale2x
        public static int[] vdt2Buffer80 = new int[122880 * 4];
        public static int[,] vdt2XyBuffer80 = new int[640 * 2, 192 * 2];
        public static int[] vdt2Buffer80p = new int[135680 * 4];
        public static int[,] vdt2XyBuffer80p = new int[640 * 2, 212 * 2];
        public static int[] vdt2Buffer86 = new int[92160 * 4];
        public static int[,] vdt2XyBuffer86 = new int[480 * 2, 192 * 2];
        public static int[] vdt2Buffer86p = new int[101760 * 4];
        public static int[,] vdt2XyBuffer86p = new int[480 * 2, 212 * 2];
        public static int[] vdt2Buffer32p = new int[54272 * 4];
        public static int[,] vdt2XyBuffer32p = new int[256 * 2, 212 * 2];
        public static int[] vdt2Buffer64 = new int[98304 * 4];
        public static int[,] vdt2XyBuffer64 = new int[512 * 2, 192 * 2];
        public static int[] vdt2Buffer64p = new int[108544 * 4];
        public static int[,] vdt2XyBuffer64p = new int[512 * 2, 212 * 2];

        public static void MSX_SCREEN_INIT()
        {
            if (VDT.Gi_MSX_SCREEN_MODE == 0)
            {
                if (MSX.GiCHAR == 0)
                {
                  //40*24 (320*192)
                  //With vdtBMPInfo.bmiHeader
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                    vdtBMPInfo.bmiHeader.biWidth = 320; //비트맵의 가로폭을 지정합니다.
                    vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                    //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                }
                else
                {
                  //40*24 (240*192)
                  //With vdtBMPInfo.bmiHeader
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                    vdtBMPInfo.bmiHeader.biWidth = 240; //비트맵의 가로폭을 지정합니다.
                    vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                    //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                }; 
            };

            if (VDT.Gi_MSX_SCREEN_MODE == 10)
            {
                if (MSX.GiCHAR == 0)
                {
                  //80*24/80*26.5 (640*192/640*212)
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                        vdtBMPInfo.bmiHeader.biWidth = 640; //비트맵의 가로폭을 지정합니다.
                        vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                        //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                    }
                    else
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                        vdtBMPInfo.bmiHeader.biWidth = 640; //비트맵의 가로폭을 지정합니다.
                        vdtBMPInfo.bmiHeader.biHeight = -212; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                        //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                    };
                }
                else
                {
                 //80*24/80*26.5 (480*192/480*212)
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biWidth = 480; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                        //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                    }
                    else
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biWidth = 480; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biHeight = -212; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                        //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                    };
                };
            };

            if ((VDT.Gi_MSX_SCREEN_MODE == 1) || (VDT.Gi_MSX_SCREEN_MODE == 2) || (VDT.Gi_MSX_SCREEN_MODE == 4) || (VDT.Gi_MSX_SCREEN_MODE == 3))
            {
              //32*24 (256*192) / 16*12 (64*48)
                vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biWidth = 256; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                vdtBMPInfo.bmiHeader.biCompression = 0;
                vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
            };

            if ((VDT.Gi_MSX_SCREEN_MODE == 5) || (VDT.Gi_MSX_SCREEN_MODE == 8))
            {
              //32*24/32*26vdtBMPInfo.bmiHeader.5 (256*192/256*212)
                if (VDT.MSX_VDT_REG_LN == 0)
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 256; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                }
                else
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 256; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -212; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                };
            };

            if ((VDT.Gi_MSX_SCREEN_MODE == 6) || (VDT.Gi_MSX_SCREEN_MODE == 7))
            {
                //64*24/64*26vdtBMPInfo.bmiHeader.5 (512*192/512*212)
                if (VDT.MSX_VDT_REG_LN == 0)
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 512; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -192; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                }
                else
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 512; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -212; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                };
            };

            vdtBMPInfo.bmiColors.rgbBlue = 0;
            vdtBMPInfo.bmiColors.rgbGreen = 0;
            vdtBMPInfo.bmiColors.rgbRed = 0;
            vdtBMPInfo.bmiColors.rgbReserved = 0;
        }

        public static void MSX_SCREEN_INIT_2X()
        {
            if (VDT.Gi_MSX_SCREEN_MODE == 0)
            {
                if (MSX.GiCHAR == 0)
                {
                    //40*24 (320*192)
                    //With vdtBMPInfo.bmiHeader
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                    vdtBMPInfo.bmiHeader.biWidth = 320 * 2; //비트맵의 가로폭을 지정합니다.
                    vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                    //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                }
                else
                {
                    //40*24 (240*192)
                    //With vdtBMPInfo.bmiHeader
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                    vdtBMPInfo.bmiHeader.biWidth = 240 * 2; //비트맵의 가로폭을 지정합니다.
                    vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                    //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                };
            };

            if (VDT.Gi_MSX_SCREEN_MODE == 10)
            {
                if (MSX.GiCHAR == 0)
                {
                    //80*24/80*26.5 (640*192/640*212)
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                        vdtBMPInfo.bmiHeader.biWidth = 640 * 2; //비트맵의 가로폭을 지정합니다.
                        vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                        //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                    }
                    else
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다.
                        vdtBMPInfo.bmiHeader.biWidth = 640 * 2; //비트맵의 가로폭을 지정합니다.
                        vdtBMPInfo.bmiHeader.biHeight = -212 * 2; //비트맵의 세로폭을 지정합니다. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다. 무조건 1로 지정합니다.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다. 이건 지정해도 그만 안해도 그만입니다. 지정 안해도 속도 저하 같은거 없습니다.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다. 0으로 지정하면 팔레트의 모든 요소를 사용합니다.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다.
                        //일곱번째 인수는 팔레트 처리방법인데... 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다.
                    };
                }
                else
                {
                    //80*24/80*26.5 (480*192/480*212)
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biWidth = 480 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                        //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                    }
                    else
                    {
                        vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biWidth = 480 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biHeight = -212 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                        vdtBMPInfo.bmiHeader.biCompression = 0;
                        vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                        vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                        vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                        //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                        //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                    };
                };
            };

            if ((VDT.Gi_MSX_SCREEN_MODE == 1) || (VDT.Gi_MSX_SCREEN_MODE == 2) || (VDT.Gi_MSX_SCREEN_MODE == 4) || (VDT.Gi_MSX_SCREEN_MODE == 3))
            {
                //32*24 (256*192) / 16*12 (64*48)
                vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biWidth = 256 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                vdtBMPInfo.bmiHeader.biCompression = 0;
                vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
            };

            if ((VDT.Gi_MSX_SCREEN_MODE == 5) || (VDT.Gi_MSX_SCREEN_MODE == 8))
            {
                //32*24/32*26vdtBMPInfo.bmiHeader.5 (256*192/256*212)
                if (VDT.MSX_VDT_REG_LN == 0)
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 256 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                }
                else
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 256 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -212 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                };
            };

            if ((VDT.Gi_MSX_SCREEN_MODE == 6) || (VDT.Gi_MSX_SCREEN_MODE == 7))
            {
                //64*24/64*26vdtBMPInfo.bmiHeader.5 (512*192/512*212)
                if (VDT.MSX_VDT_REG_LN == 0)
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 512 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -192 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                }
                else
                {
                    vdtBMPInfo.bmiHeader.biSize = 40; //표준 비트맵은 헤더 크기가 무조건 40입니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biWidth = 512 * 2; //비트맵의 가로폭을 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biHeight = -212 * 2; //비트맵의 세로폭을 지정합니다vdtBMPInfo.bmiHeader. 음수로 지정할 경우 비트맵 데이터의 라인 순서를 반대로 취급합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biPlanes = 1; //플레인 수입니다vdtBMPInfo.bmiHeader. 무조건 1로 지정합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biBitCount = 32; //몇 비트 컬러를 사용할지 지정합니다vdtBMPInfo.bmiHeader. 흑백=1,16컬러=4,256컬러=8,하이컬러=16, 트루컬러=24나32
                    vdtBMPInfo.bmiHeader.biCompression = 0;
                    vdtBMPInfo.bmiHeader.biSizeImage = 0; //비트맵 데이터의 크기입니다vdtBMPInfo.bmiHeader. 이건 지정해도 그만 안해도 그만입니다vdtBMPInfo.bmiHeader. 지정 안해도 속도 저하 같은거 없습니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biXPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biYPelsPerMeter = 0;
                    vdtBMPInfo.bmiHeader.biClrUsed = 0; //팔레트에서 실제 사용할 색상수를 지정합니다vdtBMPInfo.bmiHeader. 0으로 지정하면 팔레트의 모든 요소를 사용합니다vdtBMPInfo.bmiHeader.
                    vdtBMPInfo.bmiHeader.biClrImportant = 0; //팔레트에서 필수적으로 사용해야 하는 색상수를 지정합니다vdtBMPInfo.bmiHeader.
                    //나머지 요소는 모조리 0으로 지정하면 됩니다vdtBMPInfo.bmiHeader. 다만, 8비트 컬러 이하인 경우에 필요한 요소는 다음과 같습니다vdtBMPInfo.bmiHeader.
                    //일곱번째 인수는 팔레트 처리방법인데vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader.vdtBMPInfo.bmiHeader. 보통 DIB_RGB_COLORS(=0)를 지정하면 됩니다vdtBMPInfo.bmiHeader. 256컬러인 경우 DIB_PAL_COLORS(=1)를 지정하면 시스템 팔레트가 아닌 논리 팔레트를 사용합니다vdtBMPInfo.bmiHeader.
                };
            };

            vdtBMPInfo.bmiColors.rgbBlue = 0;
            vdtBMPInfo.bmiColors.rgbGreen = 0;
            vdtBMPInfo.bmiColors.rgbRed = 0;
            vdtBMPInfo.bmiColors.rgbReserved = 0;
        }

        public static void MSX_SCREEN_DISP()
        {
          //If (Gi_MSX_Screen_Out = 1) And (Gi_MSX_Timer_16_VDP = 1) Then
            if ((MSX.Gi_MSX_Execute == 1) && (MSX.Gi_MSX_Timer_16_VDP == 1))
            {
                VDT.Gi_MSX_Screen_Out = 0;
                MSX.Gi_MSX_Timer_16_VDP = 0;
                if ((VDT.Gi_MSX_SCREEN_MODE != VDT.Gi_MSX_Screen_Mode_Prv) ||
                   ((VDT.Gi_MSX_SCREEN_MODE >= 5) && (VDT.MSX_VDT_REG_LN != VDT.Gi_MSX_VDT_Reg_LN_Prv)))
                {
                    if (MSX.GiSC2X == 0) { MSX_SCREEN_INIT(); } else { MSX_SCREEN_INIT_2X(); };
                    VDT.Gi_MSX_Screen_Mode_Prv = VDT.Gi_MSX_SCREEN_MODE;
                    VDT.Gi_MSX_VDT_Reg_LN_Prv = VDT.MSX_VDT_REG_LN;
                };
                if (VDT.Gi_MSX_SCREEN_MODE == 0) MSX_SCREEN_0_DISP(); //TEXT MODE - 40*24문자*2색
                if (VDT.Gi_MSX_SCREEN_MODE == 1) MSX_SCREEN_1_DISP(); //GRAPHIC1 MODE - 32*24문자*16색
                if (VDT.Gi_MSX_SCREEN_MODE == 2) MSX_SCREEN_2_DISP(); //GRAPHIC2 MODE - 256*192도트*16색
                if (VDT.Gi_MSX_SCREEN_MODE == 3) MSX_SCREEN_3_DISP(); //MULTI COLOR MODE - 64*48도트*16색
                if (VDT.Gi_MSX_SCREEN_MODE == 10) MSX_SCREEN_10_DISP(); //TEXT2 MODE - 80*24문자*2색
                if (VDT.Gi_MSX_SCREEN_MODE == 4) MSX_SCREEN_4_DISP(); //GRAPHIC3 MODE - 256*192도트*16색
                if (VDT.Gi_MSX_SCREEN_MODE == 5) MSX_SCREEN_5_DISP(); //GRAPHIC4 MODE - 256*212도트*16색
                if (VDT.Gi_MSX_SCREEN_MODE == 6) MSX_SCREEN_6_DISP(); //GRAPHIC5 MODE - 512*212도트*4색
                if (VDT.Gi_MSX_SCREEN_MODE == 7) MSX_SCREEN_7_DISP(); //GRAPHIC6 MODE - 512*212도트*16색
                if (VDT.Gi_MSX_SCREEN_MODE == 8) MSX_SCREEN_8_DISP(); //GRAPHIC7 MODE - 256*212도트*256색
            };
        }

      //SCREEN 0[40], TEXT MODE - 40*24문자*2색
        public static void MSX_SCREEN_0_DISP()
        {
            int i, j, k, L;
            int C, b, P;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

            if (MSX.GiMSX2 == 0) //MSX1
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 7]; //R4:(?????AAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 15]; //R2:(????AAAA)+0000000000, 0400h
            }
            else
            { //MSX2
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 63]; //R4:(??AAAAAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 127]; //R2:(?AAAAAAA)+0000000000, 0400h
            };

            VDT.Gi_MSX_ForeColor = (byte)TBL.Gi_D_Table16[VDT.MSX_VDT_REG[7] & 0xF0];
            VDT.Gi_MSX_BackColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
            VDT.Gi_MSX_OutColor = VDT.Gi_MSX_BackColor;
            if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];
            
            if (MSX.GiCHAR == 0)
            {

              //61440:320*192(40*8*24*8),960:40*24
                if (VDT.MSX_VDT_REG_ON == 1)
                {
                    for (i = 0; i <= (960 - 1); i++) //화면 Char 표시
                    {
                        C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                        P = TBL.Go_T_VRamTable[i];
                        for (j = 0; j <= 7; j++) //폰트
                        {
                            b = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                            for (k = 1; k <= 8; k++)
                            {
                                if ((b & TBL.Gi_B_Table[8 - k]) > 0)
                                {
                                    vdtBuffer40[P + k - 1] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_ForeColor];
                                }
                                else
                                {
                                    vdtBuffer40[P + k - 1] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_BackColor];
                                };
                            };
                            P = P + 320; //1Line320Dot
                        };
                    };
                }
                else
                {
                    for (L = 0; L <= (61440 - 1); L++) //화면 Clear
                    {
                        vdtBuffer40[L] = (byte)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                    };
                };

                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(320 * 2.94), (int)(192 * 3.6), 0, 0, 320, 192, vdtBuffer40, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer40();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(320 * 2.94), (int)(192 * 3.6), 0, 0, 320 * 2, 192 * 2, vdt2Buffer40, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            }
            else
            {

              //46080:240*192(40*6*24*8),960:40*24
                if (VDT.MSX_VDT_REG_ON == 1)
                {
                    for (i = 0; i <= (960 - 1); i++) //화면 Char 표시
                    {
                        C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                        P = TBL.Go_T_VRamTable[i];
                        for (j = 0; j <= 7; j++) //폰트
                        {
                            b = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                            for (k = 1; k <= 6; k++)
                            {
                                if ((b & TBL.Gi_B_Table[8 - k]) > 0)
                                {
                                    vdtBuffer46[P + k - 1] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_ForeColor];
                                }
                                else
                                {
                                    vdtBuffer46[P + k - 1] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_BackColor];
                                };
                            };
                            P = P + 240; //1Line240Dot
                        };
                    };
                }
                else
                {
                    for (L = 0; L < (46080 - 1); L++) //화면 Clear
                    {
                        vdtBuffer46[L] = (byte)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                    };
                };

                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 13, 12, (int)(240 * 3.9), (int)(192 * 3.6), 0, 0, 240, 192, vdtBuffer46, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer46();
                    StretchDIBits(Grp.GetHdc(), 13, 12, (int)(240 * 3.9), (int)(192 * 3.6), 0, 0, 240 * 2, 192 * 2, vdt2Buffer46, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            };

          //StretchDIBits
          //  HDC hdc - Grp.GetHdc(), //출력 대상(윈도우)의 Device Context Handle 값
          //  int XDest - //출력 대상(윈도우)의 좌표 상단 X좌표
          //  int YDest - //출력 대상(윈도우)의 좌표 상단 Y좌표
          //  int nDestWidth - //출력 대상(윈도우)의(XDest) 좌표로부터 너비
          //  int nDestHeight - //출력 대상(윈도우)의(YDest) 좌표로부터 높이
          //  int XSrc - //출력할 DIB 영상의 좌측 상단 X좌표
          //  int YScr - //출력할 DIB 영상의 좌측 상단 Y좌표
          //  int nScrWidth - //출력할 DIB 영상의 XSrc 좌표로부터 너비
          //  int nScrHeight - //출력할 DIB 영상의 XSrc 좌표로부터 높이
          //  const void *lpBits - vdtBuffer40(0), //Pixel Data 영역의 시작 메모리 주소
          //  const BITMAPINFO *lpBitsInfo - vdtBMPInfo, //BITMAPINFO 구조체 영역의 시작 메모리 주소
          //  UNIT iUsage - //DIB 영상을 출력할 시, Color Table/Palette의 사용 방식을 지정
          //  DWORD dwRop - SRCCOPY //ROP(Raster-Operation) 연산방식을 지정

        }

      //SCREEN 0[80], TEXT2 MODE - 80*24문자*2색
        public static void MSX_SCREEN_10_DISP()
        {
            int i, j, k, L;
            int C, b, P;
            int iForeColor, iBackColor;
            int N, Nc, Np;
            int PK;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

            VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 63]; //R4:(??AAAAAA)+00000000000, 0800h - TEXT1 동일
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table4096[TBL.Gi_D_Table4[VDT.MSX_VDT_REG[2] & 127]]; //R2:(?AAAAA11)+000000000000, 1000h
            VDT.Go_MSX_SCR_BLNK_ADDR = TBL.Gi_M_Table32[VDT.MSX_VDT_REG[10] & 7] + TBL.Gi_D_Table8[VDT.MSX_VDT_REG[3]]; //R3 :(AAAAA???)+000000000
            VDT.Go_MSX_SCR_BLNK_ADDR = TBL.Go_M_Table512[VDT.Go_MSX_SCR_BLNK_ADDR]; //R10:(?????AAA)
            VDT.Gi_MSX_ForeColor = (byte)TBL.Gi_D_Table16[VDT.MSX_VDT_REG[7] & 0xF0];
            VDT.Gi_MSX_BackColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
            VDT.Gi_MSX_OutColor = VDT.Gi_MSX_BackColor;
            if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];
            VDT.Gi_MSX_ForeColor_Blink = (byte)TBL.Gi_D_Table16[VDT.MSX_VDT_REG[12] & 0xF0];
            VDT.Gi_MSX_BackColor_Blink = (byte)(VDT.MSX_VDT_REG[12] & 0xF);
            VDT.Gi_MSX_Blink_Time_Bl = (byte)TBL.Gi_D_Table16[VDT.MSX_VDT_REG[13] & 0xF0]; //Bl/6초
            VDT.Gi_MSX_Blink_Time_Co = (byte)(VDT.MSX_VDT_REG[13] & 0xF); //Co/6초

            if (MSX.GiCHAR == 0)
            {

              //122880:640*192(80*8*24*8),  2160[80*27]
              //135680:640*212(80*8*26.5*8),2160[80*27]
                Nc = 0; Np = 7;
                if (VDT.MSX_VDT_REG_ON == 1)
                {
                      for (i = 0; i <= (2160 - 1); i++) //화면 Char 표시
                      {
                          C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                          N = VDT.MSX_VRAM[VDT.Go_MSX_SCR_BLNK_ADDR + Nc];
                          if (((N & TBL.Gi_B_Table[Np]) == 0) || (VDT.Gi_MSX_Blink_Time_Bl == 0))
                          {
                             //Normal
                              iForeColor = VDT.Gi_MSX_ForeColor;
                              iBackColor = VDT.Gi_MSX_BackColor;
                          }
                          else
                          {
                             //Blink
                              iForeColor = VDT.Gi_MSX_ForeColor_Blink;
                              iBackColor = VDT.Gi_MSX_BackColor_Blink;
                          };
                          P = TBL.Go_T2_VRamTable[i];
                          for (j = 0; j <= 7; j++) //폰트
                          {
                              b = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                              for (k = 1; k <= 8; k++)
                              {
                                  PK = P + k - 1;
                                  if ((b & TBL.Gi_B_Table[8 - k]) > 0)
                                  {
                                      if (VDT.MSX_VDT_REG_LN == 0)
                                      {
                                          if (PK < 122880) vdtBuffer80[PK] = (int)VDT.Go_MSX_Color[iForeColor];
                                      }
                                      else
                                      {
                                          if (PK < 135680) vdtBuffer80p[PK] = (int)VDT.Go_MSX_Color[iForeColor];
                                      };
                                  }
                                  else
                                  {
                                      if (VDT.MSX_VDT_REG_LN == 0)
                                      {
                                          if (PK < 122880) vdtBuffer80[PK] = (int)VDT.Go_MSX_Color[iBackColor];
                                      }
                                      else
                                      {
                                          if (PK < 135680) vdtBuffer80p[PK] = (int)VDT.Go_MSX_Color[iBackColor];
                                      };
                                  };
                              };
                              P = P + 640; //1Line640Dot
                          };
                          Np = Np - 1; if (Np < 0) { Nc = Nc + 1; Np = 7; };
                      };
                }
                else
                {
                      if (VDT.MSX_VDT_REG_LN == 0)
                      {
                          for (L = 0; L <= (122880 - 1); L++) //화면 Clear
                          {
                              vdtBuffer80[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                          };
                      }
                      else
                      {
                          for (L = 0; L <= (135680 - 1); L++) //화면 Clear
                          {
                              vdtBuffer80p[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                          };
                      };
                };

                if (VDT.MSX_VDT_REG_LN == 0)
                {
                    if (MSX.GiSC2X == 0)
                    {
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(640 * 1.47), (int)(192 * 3.6), 0, 0, 640, 192, vdtBuffer80, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    }
                    else
                    {
                        MOVE_SCALE_2X_Buffer80();
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(640 * 1.47), (int)(192 * 3.6), 0, 0, 640 * 2, 192 * 2, vdt2Buffer80, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    };
                  //Pic.Refresh();
                }
                else
                {
                    if (MSX.GiSC2X == 0)
                    {
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(640 * 1.47), (int)(212 * 3.25), 0, 0, 640, 212, vdtBuffer80p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    }
                    else
                    {
                        MOVE_SCALE_2X_Buffer80p();
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(640 * 1.47), (int)(212 * 3.25), 0, 0, 640 * 2, 212 * 2, vdt2Buffer80p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    };
                  //Pic.Refresh();
                };
            }
            else
            {

              // 92160:480*192(80*6*24*8),  2160[80*27]
              //101760:480*212(80*6*26.5*8),2160[80*27]
                Nc = 0; Np = 7;
                if (VDT.MSX_VDT_REG_ON == 1)
                {
                    for (i = 0; i <= (2160 - 1); i++) //화면 Char 표시
                    {
                        C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                        N = VDT.MSX_VRAM[VDT.Go_MSX_SCR_BLNK_ADDR + Nc];
                        if (((N & TBL.Gi_B_Table[Np]) == 0) || (VDT.Gi_MSX_Blink_Time_Bl == 0))
                        {
                            //Normal
                            iForeColor = VDT.Gi_MSX_ForeColor;
                            iBackColor = VDT.Gi_MSX_BackColor;
                        }
                        else
                        {
                            //Blink
                            iForeColor = VDT.Gi_MSX_ForeColor_Blink;
                            iBackColor = VDT.Gi_MSX_BackColor_Blink;
                        };
                        P = TBL.Go_T2_VRamTable[i];
                        for (j = 0; j <= 7; j++) //폰트
                        {
                            b = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                            for (k = 1; k <= 6; k++)
                            {
                                PK = P + k - 1;
                                if ((b & TBL.Gi_B_Table[8 - k]) > 0)
                                {
                                    if (VDT.MSX_VDT_REG_LN == 0)
                                    {
                                        if (PK < 92160) vdtBuffer86[PK] = (int)VDT.Go_MSX_Color[iForeColor];
                                    }
                                    else
                                    {
                                        if (PK < 101760) vdtBuffer86p[PK] = (int)VDT.Go_MSX_Color[iForeColor];
                                    };
                                }
                                else
                                {
                                    if (VDT.MSX_VDT_REG_LN == 0)
                                    {
                                        if (PK < 92160) vdtBuffer86[PK] = (int)VDT.Go_MSX_Color[iBackColor];
                                    }
                                    else
                                    {
                                        if (PK < 101760) vdtBuffer86p[PK] = (int)VDT.Go_MSX_Color[iBackColor];
                                    };
                                };
                            };
                            P = P + 480; //1Line480Dot
                        };
                        Np = Np - 1; if (Np < 0) { Nc = Nc + 1; Np = 7; };
                    };
                }
                else
                {
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        for (L = 0; L <= (92160 - 1); L++) //화면 Clear
                        {
                            vdtBuffer86[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                        };
                    }
                    else
                    {
                        for (L = 0; L <= (101760 - 1); L++) //화면 Clear
                        {
                            vdtBuffer86p[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                        };
                    };
                };

                if (VDT.MSX_VDT_REG_LN == 0)
                {
                    if (MSX.GiSC2X == 0)
                    {
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(480 * 1.96), (int)(192 * 3.6), 0, 0, 480, 192, vdtBuffer86, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    }
                    else
                    {
                        MOVE_SCALE_2X_Buffer86();
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(480 * 1.96), (int)(192 * 3.6), 0, 0, 480 * 2, 192 * 2, vdt2Buffer86, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    };
                  //Pic.Refresh();
                }
                else
                {
                    if (MSX.GiSC2X == 0)
                    {
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(480 * 1.96), (int)(212 * 3.25), 0, 0, 480, 212, vdtBuffer86p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    }
                    else
                    {
                        MOVE_SCALE_2X_Buffer86p();
                        StretchDIBits(Grp.GetHdc(), 11, 12, (int)(480 * 1.96), (int)(212 * 3.25), 0, 0, 480 * 2, 212 * 2, vdt2Buffer86p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                    };
                  //Pic.Refresh();
                };
            };
        }

      //SCREEN 1, GRAPHIC1 MODE - 32*24문자*16색
        public static void MSX_SCREEN_1_DISP()
        {
            int i, j, k, L;
            int C, b, O, P;

            int MSX_ForeColor;
            int MSX_BackColor;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

            if (MSX.GiMSX2 == 0) //MSX1
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 7]; //R4: (?????AAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 15]; //R2: (????AAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Gi_M_Table64[VDT.MSX_VDT_REG[3]]; //R3: (AAAAAAAA)+000000, 0040h
            }
            else //MSX2
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 63]; //R4: (??AAAAAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 127]; //R2: (?AAAAAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Gi_M_Table64[VDT.MSX_VDT_REG[3]]; //R3: (AAAAAAAA)+000000, 0040h
                VDT.Go_MSX_SCR_COLR_ADDR = VDT.Go_MSX_SCR_COLR_ADDR + TBL.Go_M_Table16384[VDT.MSX_VDT_REG[10] & 7]; //R10:(?????AAA)+AAAAAAAA000000. 4???h
            };

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

          //49152:256*192(32*8*24*8),768:32*24
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                for (i = 0; i <= (768 - 1); i++) //화면 Char 표시
                {
                    C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                    O = VDT.MSX_VRAM[VDT.Go_MSX_SCR_COLR_ADDR + TBL.Gi_D_Table8[C]]; //해당문자Color테이블8Byte
                    MSX_ForeColor = TBL.Gi_MSX_ForeColors[O];
                    MSX_BackColor = TBL.Gi_MSX_BackColors[O];
                    if (MSX_ForeColor == 0) MSX_ForeColor = VDT.Gi_MSX_OutColor;
                    if (MSX_BackColor == 0) MSX_BackColor = VDT.Gi_MSX_OutColor;
                    P = TBL.Go_G_VRamTable[i];
                    for (j = 0; j <= 7; j++) //폰트
                    {
                        b = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C] + j]; //해당문자Font테이블8Byte
                        for (k = 1; k <= 8; k++)
                        {
                            if ((b & TBL.Gi_B_Table[8 - k]) > 0)
                            {
                                vdtBuffer32[P + k - 1] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                            }
                            else
                            {
                                vdtBuffer32[P + k - 1] = (int)VDT.Go_MSX_Color[MSX_BackColor];
                            };
                        };
                        P = P + 256; //1Line256Dot
                    };
                };
                VDTSPR.MSX_SPRITE_DISP();
            }
            else
            {
                for (L = 0; L <= (49152 - 1); L++) //화면 Clear
                {
                    vdtBuffer32[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                };
            };

            if (MSX.GiSC2X == 0)
            {
                StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256, 192, vdtBuffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
            }
            else
            {
                MOVE_SCALE_2X_Buffer32();
                StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256 * 2, 192 * 2, vdt2Buffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
            };
          //Pic.Refresh();
         }

      //SCREEN 2, GRAPHIC2 MODE - 256*192도트*16색
        public static void MSX_SCREEN_2_DISP()
        {
            int i, j, k, L;
            int C, b, O, P;

            int oAddr1, oAddr2;
            int MSX_ForeColor;
            int MSX_BackColor;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

            if (MSX.GiMSX2 == 0) //MSX1
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table8192[TBL.Gi_D_Table4[VDT.MSX_VDT_REG[4] & 4]]; //R4: (?????A11)+0000000000000, 2000h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 15]; //R2: (????AAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Go_M_Table8192[TBL.Gi_D_Table128[VDT.MSX_VDT_REG[3] & 128]]; //R3: (A1111111)+0000000000000, 2000h
            }
            else //MSX2
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table8192[TBL.Gi_D_Table4[VDT.MSX_VDT_REG[4] & 63]]; //R4: (??AAAA11)+0000000000000, 2000h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 127]; //R2: (?AAAAAAA)+0000000000, 0400h
                VDT.Go_MSX_SCR_COLR_ADDR = TBL.Go_M_Table8192[TBL.Gi_D_Table128[VDT.MSX_VDT_REG[3] & 128]]; //R3: (A1111111)+0000000000000, 2000h
                VDT.Go_MSX_SCR_COLR_ADDR = VDT.Go_MSX_SCR_COLR_ADDR + TBL.Go_M_Table16384[VDT.MSX_VDT_REG[10] & 7]; //R10:(?????AAA)+AAAAAAAA000000. 4???h
            };

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

          //49152:256*192(32*8*24*8),768:32*24
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                for (i = 0; i <= (768 - 1); i++) //화면 Char 표시
                {
                    C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                    P = TBL.Go_G_VRamTable[i];
                    for (j = 0; j <= 7; j++) //폰트
                    {
                        oAddr1 = VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C] + j;
                        oAddr2 = VDT.Go_MSX_SCR_COLR_ADDR + TBL.Gi_M_Table8[C] + j;
                        if (i >= 256) { oAddr1 = oAddr1 + 2048; oAddr2 = oAddr2 + 2048; }; //256*8
                        if (i >= 512) { oAddr1 = oAddr1 + 2048; oAddr2 = oAddr2 + 2048; }; //256*8
                        b = VDT.MSX_VRAM[oAddr1]; //해당문자Font테이블8Byte
                        O = VDT.MSX_VRAM[oAddr2]; //해당문자Color테이블8Byte
                        MSX_ForeColor = TBL.Gi_MSX_ForeColors[O];
                        MSX_BackColor = TBL.Gi_MSX_BackColors[O];
                        if (MSX_ForeColor == 0) MSX_ForeColor = VDT.Gi_MSX_OutColor;
                        if (MSX_BackColor == 0) MSX_BackColor = VDT.Gi_MSX_OutColor;
                        for (k = 1; k <= 8; k++)
                        {
                            if ((b & TBL.Gi_B_Table[8 - k]) > 0)
                            {
                                vdtBuffer32[P + k - 1] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                            }
                            else
                            {
                                vdtBuffer32[P + k - 1] = (int)VDT.Go_MSX_Color[MSX_BackColor];
                            };
                        };
                        P = P + 256; //1Line256Dot
                    };
                };
                if (VDT.Gi_MSX_SCREEN_MODE == 2)
                {
                    VDTSPR.MSX_SPRITE_DISP();
                }
                else
                {
                    VDTSPR.MSX_SPRITE_2_DISP(0);
                };
            }
            else
            {
                for (L = 0; L <= (49152 - 1); L++) //화면 Clear
                {
                    vdtBuffer32[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                };
            };

            if (MSX.GiSC2X == 0)
            {
                StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256, 192, vdtBuffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
            }
            else
            {
                MOVE_SCALE_2X_Buffer32();
                StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256 * 2, 192 * 2, vdt2Buffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
            };
          //Pic.Refresh();
        }

      //SCREEN 3, MULTI COLOR MODE - 32*24블록,64*48도트,(256*192)*16색
        public static void MSX_SCREEN_3_DISP()
        {
            int i, L, C, O, Co, Ch, Cl;
            int X, Y, Z;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

            if (MSX.GiMSX2 == 0) //MSX1
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 7]; //R4: (?????AAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 15]; //R2: (????AAAA)+0000000000, 0400h
            }
            else //MSX2
            {
                VDT.Go_MSX_SCR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[4] & 63]; //R4: (??AAAAAA)+00000000000, 0800h
                VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table1024[VDT.MSX_VDT_REG[2] & 127]; //R2: (?AAAAAAA)+0000000000, 0400h
            };

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

          //32*24블록,64*48도트
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                for (i = 0; i <= 767; i++)
                {
                    C = VDT.MSX_VRAM[VDT.Go_MSX_SCR_CHAR_ADDR + i];
                    O = VDT.Go_MSX_SCR_FONT_ADDR + TBL.Gi_M_Table8[C];
                  //X(32)*Y(24)블록구하기
                    Y = TBL.Gi_D_Table32[i];
                    X = i % 32;
                    Z = TBL.Gi_M_Table2[Y % 4];
                  //블록표시,32*24->64*48
                    X = TBL.Gi_M_Table2[X]; //0,2,4~62
                    Y = TBL.Gi_M_Table2[Y]; //0,2,4~46
                    Co = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + O + Z];
                    Ch = TBL.Gi_D_Table16[Co & 0xF0]; //좌
                    Cl = Co & 0xF; //우
                    ft_MSX_SCREEN_3_PSet(X + 0, Y + 0, (int)VDT.Go_MSX_Color[Ch]); //좌(상)
                    ft_MSX_SCREEN_3_PSet(X + 1, Y + 0, (int)VDT.Go_MSX_Color[Cl]); //우(상)
                    Co = VDT.MSX_VRAM[VDT.Go_MSX_SCR_FONT_ADDR + O + Z + 1];
                    Ch = TBL.Gi_D_Table16[Co & 0xF0]; //좌
                    Cl = Co & 0xF; //우
                    ft_MSX_SCREEN_3_PSet(X + 0, Y + 1, (int)VDT.Go_MSX_Color[Ch]); //좌(하)
                    ft_MSX_SCREEN_3_PSet(X + 1, Y + 1, (int)VDT.Go_MSX_Color[Cl]); //우(하)
                };
            }
            else
            {
                for (L = 0; L <= (49152 - 1); L++) //화면 Clear
                {
                    vdtBuffer32[L] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor]; //화면을배경색으로채움
                };
            };

            VDTSPR.MSX_SPRITE_DISP();

            if (MSX.GiSC2X == 0)
            {
                StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256, 192, vdtBuffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
            }
            else
            {
                MOVE_SCALE_2X_Buffer32();
                StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256 * 2, 192 * 2, vdt2Buffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
            };
          //Pic.Refresh();
        }

        public static void ft_MSX_SCREEN_3_PSet(int X, int Y, int C)
        {
            int i, L, L2;

          //64*48->256*192
            L = TBL.Go_M_Table256[TBL.Gi_M_Table4[Y]] + TBL.Gi_M_Table4[X];

            for (i = 0; i <= 3; i++) //0~3Col
            {
                L2 = L + i;
                vdtBuffer32[L2] = C;       //0Line
                vdtBuffer32[L2 + 256] = C; //1Line
                vdtBuffer32[L2 + 512] = C; //2Line
                vdtBuffer32[L2 + 768] = C; //3Line
            };
        }

      //SCREEN 4, GRAPHIC3 MODE - 256*192도트*16색
        public static void MSX_SCREEN_4_DISP()
        {
            MSX_SCREEN_2_DISP();
        }

      //SCREEN 5, GRAPHIC4 MODE - 256*212도트*16색
        public static void MSX_SCREEN_5_DISP()
        {
            int i, L, L1, L2, Lx;
            int Lt, F, C;
            int iLine, iLineDsp, iLineFlg;

            int MSX_ForeColor;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

          //VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 127)) //R2: (?AA11111)+000000000000000, 8000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768[VDT.Gi_MSX_Graphic_Page]; //0~3 * 8000h

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                Lt = 49152 - 1; //256*192
            }
            else
            {
                Lt = 54272 - 1; //256*212
            };

            iLine = 0; iLineFlg = 0;
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                F = 0;
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR;
                L2 = TBL.Go_M_Table128[VDT.MSX_VDT_REG[23]];
                L = L1 + L2; Lx = L1 + 32767;
                for (i = 0; i <= Lt; i++)
                {
                    C = VDT.MSX_VRAM[L];
                    if (F == 0)
                    {
                        MSX_ForeColor = TBL.Gi_D_Table16[C & 0xF0];
                        F = 1;
                    }
                    else
                    {
                        MSX_ForeColor = C & 0xF;
                        F = 0;
                        L = L + 1;
                        if (L > Lx) L = L - 32768;
                    };
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        if ((VDT.MSX_VDT_REG_TP == 0) && (MSX_ForeColor == 0))
                        {
                            vdtBuffer32[i] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor];
                        }
                        else
                        {
                            vdtBuffer32[i] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                        };
                    }
                    else
                    {
                        if ((VDT.MSX_VDT_REG_TP == 0) && (MSX_ForeColor == 0))
                        {
                            vdtBuffer32p[i] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor];
                        }
                        else
                        {
                            vdtBuffer32p[i] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                        };
                    };
                    iLineFlg = iLineFlg + 1;
                    if (iLineFlg == 256)
                    {
                        if (VDT.MSX_VDT_REG_IE1 == 1)
                        {
                            iLineDsp = VDT.MSX_VDT_REG[23] + iLine;
                            if (iLineDsp > 255) iLineDsp = iLineDsp - 256;
                            if (iLineDsp == (VDT.MSX_VDT_REG[19] + 3)) { VDT.MSX_VDT_ST_REG_FH = 1; goto SpriteProc; }; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        };
                        iLineFlg = 0;
                        iLine = iLine + 1;
                        L1 = TBL.Go_M_Table32768[VDT.Gi_MSX_Graphic_Page];
                        L2 = TBL.Go_M_Table128[VDT.MSX_VDT_REG[23] + iLine];
                        L = L1 + L2; Lx = L1 + 32767;
                        if (L > Lx) L = L - 32768;
                    };
                };
            }
            else
            {
                for (i = 0; i <= Lt; i++)
                {
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBuffer32[i] = 0;
                    }
                    else
                    {
                        vdtBuffer32p[i] = 0;
                    };
                };
            };

        SpriteProc: ;
            VDTSPR.MSX_SPRITE_2_DISP((sbyte)VDT.MSX_VDT_REG_LN);

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256, 192, vdtBuffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer32();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256 * 2, 192 * 2, vdt2Buffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            }
            else
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(212 * 3.25), 0, 0, 256, 212, vdtBuffer32p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer32p();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(212 * 3.25), 0, 0, 256 * 2, 212 * 2, vdt2Buffer32p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            };
        }

      //SCREEN 6, GRAPHIC5 MODE - 512*212도트*4색
        public static void MSX_SCREEN_6_DISP()
        {
            int i, L, L1, L2, Lx;
            int Lt, F, C;
            int iLine, iLineDsp, iLineFlg;

            int MSX_ForeColor = 0;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

          //VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 127)) //R2: (?AA11111)+000000000000000, 8000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table32768[VDT.Gi_MSX_Graphic_Page]; //0~3 * 8000h

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                Lt = 98304 - 1; //512*192
            }
            else
            {
                Lt = 108544 - 1; //512*212
            };

            iLine = 0; iLineFlg = 0;
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                F = 0;
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR;
                L2 = TBL.Go_M_Table128[VDT.MSX_VDT_REG[23]];
                L = L1 + L2; Lx = L1 + 32767;
                for (i = 0; i <= Lt; i++)
                {
                    C = VDT.MSX_VRAM[L];
                    if (F == 0) MSX_ForeColor = TBL.Gi_D_Table64[C & 192];
                    if (F == 1) MSX_ForeColor = TBL.Gi_D_Table16[C & 48];
                    if (F == 2) MSX_ForeColor = TBL.Gi_D_Table4[C & 12];
                    if (F == 3) MSX_ForeColor = (C & 3);
                    F = F + 1;
                    if (F == 4)
                    {
                        F = 0;
                        L = L + 1;
                        if (L > Lx) L = L - 32768;
                    };
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        if ((VDT.MSX_VDT_REG_TP == 0) && (MSX_ForeColor == 0))
                        {
                            vdtBuffer64[i] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor];
                        }
                        else
                        {
                            vdtBuffer64[i] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                        };
                    }
                    else
                    {
                        if ((VDT.MSX_VDT_REG_TP == 0) && (MSX_ForeColor == 0))
                        {
                            vdtBuffer64p[i] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor];
                        }
                        else
                        {
                            vdtBuffer64p[i] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                        };
                    };
                    iLineFlg = iLineFlg + 1;
                    if (iLineFlg == 512)
                    {
                        if (VDT.MSX_VDT_REG_IE1 == 1)
                        {
                            iLineDsp = VDT.MSX_VDT_REG[23] + iLine;
                            if (iLineDsp > 255) iLineDsp = iLineDsp - 256;
                            if (iLineDsp == (VDT.MSX_VDT_REG[19] + 3)) { VDT.MSX_VDT_ST_REG_FH = 1; goto SpriteProc; }; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        };
                        iLineFlg = 0;
                        iLine = iLine + 1;
                        L1 = TBL.Go_M_Table32768[VDT.Gi_MSX_Graphic_Page];
                        L2 = TBL.Go_M_Table128[VDT.MSX_VDT_REG[23] + iLine];
                        L = L1 + L2; Lx = L1 + 32767;
                        if (L > Lx) L = L - 32768;
                    };
                };
            }
            else
            {
                for (i = 0; i <= Lt; i++)
                {
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBuffer64[i] = 0;
                    }
                    else
                    {
                        vdtBuffer64p[i] = 0;
                    };
                };
            };

        SpriteProc: ;
            VDTSPR.MSX_SPRITE_2_DISP((sbyte)VDT.MSX_VDT_REG_LN);

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(192 * 3.6), 0, 0, 512, 192, vdtBuffer64, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer64();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(192 * 3.6), 0, 0, 512 * 2, 192 * 2, vdt2Buffer64, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            }
            else
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(212 * 3.25), 0, 0, 512, 212, vdtBuffer64p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer64p();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(212 * 3.25), 0, 0, 512 * 2, 212 * 2, vdt2Buffer64p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            };
        }

      //SCREEN 7, GRAPHIC6 MODE - 512*212도트*16색
        public static void MSX_SCREEN_7_DISP()
        {
            int i, L, L1, L2, Lx;
            int Lt, F, C;
            int iLine, iLineDsp, iLineFlg;

            int MSX_ForeColor;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

          //VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 63)) //R2: (??A11111)+0000000000000000, 10000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536[VDT.Gi_MSX_Graphic_Page]; //0~1 * 10000h

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                Lt = 98304 - 1; //512*192
            }
            else
            {
                Lt = 108544 - 1; //512*212
            };

            iLine = 0; iLineFlg = 0;
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                F = 0;
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR;
                L2 = TBL.Go_M_Table256[VDT.MSX_VDT_REG[23]];
                L = L1 + L2; Lx = L1 + 65535;
                for (i = 0; i <= Lt; i++)
                {
                    C = VDT.MSX_VRAM[L];
                    if (F == 0)
                    {
                        MSX_ForeColor = TBL.Gi_D_Table16[C & 0xF0];
                        F = 1;
                    }
                    else
                    {
                        MSX_ForeColor = C & 0xF;
                        F = 0;
                        L = L + 1;
                        if (L > Lx) L = L - 65536;
                    };
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        if ((VDT.MSX_VDT_REG_TP == 0) && (MSX_ForeColor == 0))
                        {
                            vdtBuffer64[i] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor];
                        }
                        else
                        {
                            vdtBuffer64[i] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                        };
                    }
                    else
                    {
                        if ((VDT.MSX_VDT_REG_TP == 0) && (MSX_ForeColor == 0))
                        {
                            vdtBuffer64p[i] = (int)VDT.Go_MSX_Color[VDT.Gi_MSX_OutColor];
                        }
                        else
                        {
                            vdtBuffer64p[i] = (int)VDT.Go_MSX_Color[MSX_ForeColor];
                        };
                    };
                    iLineFlg = iLineFlg + 1;
                    if (iLineFlg == 512)
                    {
                        if (VDT.MSX_VDT_REG_IE1 == 1)
                        {
                            iLineDsp = VDT.MSX_VDT_REG[23] + iLine;
                            if (iLineDsp > 255) iLineDsp = iLineDsp - 256;
                            if (iLineDsp == (VDT.MSX_VDT_REG[19] + 3)) { VDT.MSX_VDT_ST_REG_FH = 1; goto SpriteProc; }; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        };
                        iLineFlg = 0;
                        iLine = iLine + 1;
                        L1 = TBL.Go_M_Table65536[VDT.Gi_MSX_Graphic_Page];
                        L2 = TBL.Go_M_Table256[VDT.MSX_VDT_REG[23] + iLine];
                        L = L1 + L2; Lx = L1 + 65535;
                        if (L > Lx) L = L - 65536;
                    };
                };
            }
            else
            {
                for (i = 0; i <= Lt; i++)
                {
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBuffer64[i] = 0;
                    }
                    else
                    {
                        vdtBuffer64p[i] = 0;
                    };
                };
            };

        SpriteProc: ;
            VDTSPR.MSX_SPRITE_2_DISP((sbyte)VDT.MSX_VDT_REG_LN);

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(192 * 3.6), 0, 0, 512, 192, vdtBuffer64, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer64();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(192 * 3.6), 0, 0, 512 * 2, 192 * 2, vdt2Buffer64, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            }
            else
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(212 * 3.25), 0, 0, 512, 212, vdtBuffer64p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer64p();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(512 * 1.84), (int)(212 * 3.25), 0, 0, 512 * 2, 212 * 2, vdt2Buffer64p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            };
        }

      //SCREEN 8, GRAPHIC7 MODE - 256*212도트*256색
        public static void MSX_SCREEN_8_DISP()
        {
            int i, L, L1, L2, Lx;
            int Lt, C;
            int iLine, iLineDsp, iLineFlg;

            int MSX_ForeColor;
            int Color_Green;
            int Color_Red;
            int Color_Blue;

            Form Frm = Application.OpenForms["csMSX2Frm"] as Form;
            PictureBox Pic = Frm.Controls["ScrnMSX"] as PictureBox;
            Graphics Grp = Pic.CreateGraphics();

          //VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536(TBL.Gi_D_Table32(VDT.MSX_VDT_REG(2) And 63)) //R2: (??A11111)+0000000000000000, 10000h
            VDT.Go_MSX_SCR_CHAR_ADDR = TBL.Go_M_Table65536[VDT.Gi_MSX_Graphic_Page]; //0~1 * 10000h

            VDT.Gi_MSX_OutColor = (byte)(VDT.MSX_VDT_REG[7] & 0xF);
          //if (VDT.Gi_MSX_OutColor == 0) VDT.Gi_MSX_OutColor = 4; //파란색
            Pic.BackColor = VDT.Gc_MSX_Color_RGB[VDT.Gi_MSX_OutColor];

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                Lt = 49152 - 1; //256*192
            }
            else
            {
                Lt = 54272 - 1; //256*212
            };

            iLine = 0; iLineFlg = 0;
            if (VDT.MSX_VDT_REG_ON == 1)
            {
                L1 = VDT.Go_MSX_SCR_CHAR_ADDR;
                L2 = TBL.Go_M_Table256[VDT.MSX_VDT_REG[23]];
                L = L1 + L2; Lx = L1 + 65535;
                for (i = 0; i <= Lt; i++)
                {
                    C = VDT.MSX_VRAM[L];
                    L = L + 1;
                    if (L > Lx) L = L - 65536;
                    Color_Green = TBL.Gi_D_Table32[C & 224]; //11100000
                    Color_Red = TBL.Gi_D_Table4[C & 28];     //00011100
                    Color_Blue = TBL.Gi_M_Table2[C & 3];     //00000011*
                    Color_Green = TBL.Gi_M_Table36[Color_Green];
                    Color_Red = TBL.Gi_M_Table36[Color_Red];
                    Color_Blue = TBL.Gi_M_Table36[Color_Blue];
                  //MSX_ForeColor = (int)FN.goRGB((byte)Color_Blue, (byte)Color_Green, (byte)Color_Red); //VB6
                    MSX_ForeColor = (int)FN.goRGB((byte)Color_Red, (byte)Color_Green, (byte)Color_Blue);
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBuffer32[i] = (int)MSX_ForeColor;
                    }
                    else
                    {
                        vdtBuffer32p[i] = (int)MSX_ForeColor;
                    };
                    iLineFlg = iLineFlg + 1;
                    if (iLineFlg == 256)
                    {
                        if (VDT.MSX_VDT_REG_IE1 == 1)
                        {
                            iLineDsp = VDT.MSX_VDT_REG[23] + iLine;
                            if (iLineDsp > 255) iLineDsp = iLineDsp - 256;
                            if (iLineDsp == (VDT.MSX_VDT_REG[19] + 3)) { VDT.MSX_VDT_ST_REG_FH = 1; goto SpriteProc; }; //R#0 의 IE1=1 일때 R#19값의 라인 표시할때
                        };
                        iLineFlg = 0;
                        iLine = iLine + 1;
                        L1 = TBL.Go_M_Table65536[VDT.Gi_MSX_Graphic_Page];
                        L2 = TBL.Go_M_Table256[VDT.MSX_VDT_REG[23] + iLine];
                        L = L1 + L2; Lx = L1 + 65535;
                        if (L > Lx) L = L - 65536;
                    };
                };
            }
            else
            {
                for (i = 0; i <= Lt; i++)
                {
                    if (VDT.MSX_VDT_REG_LN == 0)
                    {
                        vdtBuffer32[i] = 0;
                    }
                    else
                    {
                        vdtBuffer32p[i] = 0;
                    };
                };
            };

        SpriteProc: ;
            VDTSPR.MSX_SPRITE_2_DISP((sbyte)VDT.MSX_VDT_REG_LN);

            if (VDT.MSX_VDT_REG_LN == 0)
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256, 192, vdtBuffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer32();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(192 * 3.6), 0, 0, 256 * 2, 192 * 2, vdt2Buffer32, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            }
            else
            {
                if (MSX.GiSC2X == 0)
                {
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(212 * 3.25), 0, 0, 256, 212, vdtBuffer32p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                }
                else
                {
                    MOVE_SCALE_2X_Buffer32p();
                    StretchDIBits(Grp.GetHdc(), 11, 12, (int)(256 * 3.68), (int)(212 * 3.25), 0, 0, 256 * 2, 212 * 2, vdt2Buffer32p, ref vdtBMPInfo, DIB_RGB_COLORS, SRCCOPY);
                };
              //Pic.Refresh();
            };
        }

        public static void MOVE_SCALE_2X_Buffer40()
        {
            int L, wX = 320, wY = 192, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer40[X, Y] = vdtBuffer40[L];
                    vdt2XyBuffer40[X + 1, Y] = vdtBuffer40[L];
                    vdt2XyBuffer40[X, Y + 1] = vdtBuffer40[L];
                    vdt2XyBuffer40[X + 1, Y + 1] = vdtBuffer40[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer40[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer40[L + 1];
                    if (i > 0) up = vdtBuffer40[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer40[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer40[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer40[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer40[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer40[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer40[L++] = vdt2XyBuffer40[j, i];
                };
            };
        }

        public static void MOVE_SCALE_2X_Buffer46()
        {
            int L, wX = 240, wY = 192, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer46[X, Y] = vdtBuffer46[L];
                    vdt2XyBuffer46[X + 1, Y] = vdtBuffer46[L];
                    vdt2XyBuffer46[X, Y + 1] = vdtBuffer46[L];
                    vdt2XyBuffer46[X + 1, Y + 1] = vdtBuffer46[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer46[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer46[L + 1];
                    if (i > 0) up = vdtBuffer46[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer46[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer46[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer46[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer46[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer46[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer46[L++] = vdt2XyBuffer46[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer32()
        {
            int L, wX = 256, wY = 192, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer32[X, Y] = vdtBuffer32[L];
                    vdt2XyBuffer32[X + 1, Y] = vdtBuffer32[L];
                    vdt2XyBuffer32[X, Y + 1] = vdtBuffer32[L];
                    vdt2XyBuffer32[X + 1, Y + 1] = vdtBuffer32[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer32[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer32[L + 1];
                    if (i > 0) up = vdtBuffer32[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer32[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer32[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer32[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer32[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer32[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer32[L++] = vdt2XyBuffer32[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer80()
        {
            int L, wX = 640, wY = 192, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer80[X, Y] = vdtBuffer80[L];
                    vdt2XyBuffer80[X + 1, Y] = vdtBuffer80[L];
                    vdt2XyBuffer80[X, Y + 1] = vdtBuffer80[L];
                    vdt2XyBuffer80[X + 1, Y + 1] = vdtBuffer80[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer80[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer80[L + 1];
                    if (i > 0) up = vdtBuffer80[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer80[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer80[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer80[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer80[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer80[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer80[L++] = vdt2XyBuffer80[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer80p()
        {
            int L, wX = 640, wY = 212, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer80p[X, Y] = vdtBuffer80p[L];
                    vdt2XyBuffer80p[X + 1, Y] = vdtBuffer80p[L];
                    vdt2XyBuffer80p[X, Y + 1] = vdtBuffer80p[L];
                    vdt2XyBuffer80p[X + 1, Y + 1] = vdtBuffer80p[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer80p[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer80p[L + 1];
                    if (i > 0) up = vdtBuffer80p[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer80p[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer80p[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer80p[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer80p[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer80p[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer80p[L++] = vdt2XyBuffer80p[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer86()
        {
            int L, wX = 480, wY = 192, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer86[X, Y] = vdtBuffer86[L];
                    vdt2XyBuffer86[X + 1, Y] = vdtBuffer86[L];
                    vdt2XyBuffer86[X, Y + 1] = vdtBuffer86[L];
                    vdt2XyBuffer86[X + 1, Y + 1] = vdtBuffer86[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer86[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer86[L + 1];
                    if (i > 0) up = vdtBuffer86[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer86[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer86[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer86[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer86[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer86[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer86[L++] = vdt2XyBuffer86[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer86p()
        {
            int L, wX = 480, wY = 212, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer86p[X, Y] = vdtBuffer86p[L];
                    vdt2XyBuffer86p[X + 1, Y] = vdtBuffer86p[L];
                    vdt2XyBuffer86p[X, Y + 1] = vdtBuffer86p[L];
                    vdt2XyBuffer86p[X + 1, Y + 1] = vdtBuffer86p[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer86p[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer86p[L + 1];
                    if (i > 0) up = vdtBuffer86p[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer86p[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer86p[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer86p[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer86p[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer86p[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer86p[L++] = vdt2XyBuffer86p[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer32p()
        {
            int L, wX = 256, wY = 212, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer32p[X, Y] = vdtBuffer32p[L];
                    vdt2XyBuffer32p[X + 1, Y] = vdtBuffer32p[L];
                    vdt2XyBuffer32p[X, Y + 1] = vdtBuffer32p[L];
                    vdt2XyBuffer32p[X + 1, Y + 1] = vdtBuffer32p[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer32p[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer32p[L + 1];
                    if (i > 0) up = vdtBuffer32p[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer32p[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer32p[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer32p[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer32p[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer32p[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer32p[L++] = vdt2XyBuffer32p[j, i];
                };
            };
        }
        
        public static void MOVE_SCALE_2X_Buffer64()
        {
            int L, wX = 512, wY = 192, X, Y;
            int lf, ri, up, dn;

            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer64[X, Y] = vdtBuffer64[L];
                    vdt2XyBuffer64[X + 1, Y] = vdtBuffer64[L];
                    vdt2XyBuffer64[X, Y + 1] = vdtBuffer64[L];
                    vdt2XyBuffer64[X + 1, Y + 1] = vdtBuffer64[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer64[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer64[L + 1];
                    if (i > 0) up = vdtBuffer64[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer64[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer64[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer64[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer64[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer64[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer64[L++] = vdt2XyBuffer64[j, i];
                };
            };
        }

        public static void MOVE_SCALE_2X_Buffer64p()
        {
            int L, wX = 512, wY = 212, X, Y;
            int lf, ri, up, dn;
            
            L = 0;
            for (int i = 0; i <= wY - 1; i++)
            {
                Y = i << 1;
                for (int j = 0; j <= wX - 1; j++)
                {
                    X = j << 1;
                    vdt2XyBuffer64p[X, Y] = vdtBuffer64p[L];
                    vdt2XyBuffer64p[X + 1, Y] = vdtBuffer64p[L];
                    vdt2XyBuffer64p[X, Y + 1] = vdtBuffer64p[L];
                    vdt2XyBuffer64p[X + 1, Y + 1] = vdtBuffer64p[L];
                    lf = 0; ri = 1; up = 2; dn = 3;
                    if (j > 0) lf = vdtBuffer64p[L - 1];
                    if (j < (wX - 1)) ri = vdtBuffer64p[L + 1];
                    if (i > 0) up = vdtBuffer64p[L - wX];
                    if (i < (wY - 1)) dn = vdtBuffer64p[L + wX];
                    if ((up != dn) && (lf != ri))
                    {
                        if (lf == up) vdt2XyBuffer64p[X, Y] = lf;
                        if (up == ri) vdt2XyBuffer64p[X + 1, Y] = ri;
                        if (lf == dn) vdt2XyBuffer64p[X, Y + 1] = lf;
                        if (dn == ri) vdt2XyBuffer64p[X + 1, Y + 1] = ri;
                    };
                    L++;
                };
            };

            L = 0;
            for (int i = 0; i <= wY * 2 - 1; i++)
            {
                for (int j = 0; j <= wX * 2 - 1; j++)
                {
                    vdt2Buffer64p[L++] = vdt2XyBuffer64p[j, i];
                };
            };
        }
    }
}
