﻿using System;
using System.Runtime.InteropServices;

namespace csMSX2
{
    public static class VDTSPR
    {
      //소프라이트
        public static void MSX_SPRITE_DISP()
        {
            sbyte i, j, k, M; int L;
            int V; byte b; int P, Ps, sf;
            int Sy, Sx; byte Sc; short FC; sbyte EC; int Xp;
            int[] Vpm = new int[4];
            int[] Syy = new int[4];
            int[] Sxx = new int[4];

            VDT.Go_MSX_SPR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[6] & 7];  //R6:(?????AAA)+00000000000, 0800h / 0~255 - 8*8=256, 16*16=64(4패턴번호동일지정됨), 표시순서0번이가장앞에표시
            VDT.Go_MSX_SPR_ATRB_ADDR = TBL.Go_M_Table128[VDT.MSX_VDT_REG[5] & 127]; //R5:(?AAAAAAA)+0000000, 0080h / 0~31(4Byte) - Y좌표(0~255),X좌표(0~255),패턴번호(0~255),A(EC)000AAAA(Color)

            VDT.MSX_VDT_REG_SZ = (byte)((VDT.MSX_VDT_REG[1] & 2) == 0 ? 0 : 1); //R1(7,1) - SPR SIZE (0:8*8, 1:16*16) - 16사이즈저장순서 왼쪽위,아래,오른쪽위,아래
            VDT.MSX_VDT_REG_SM = (byte)((VDT.MSX_VDT_REG[1] & 1) == 0 ? 0 : 1); //R1(8,1) - SPR MAG (0:정상, 1:가로세로2배확대)
            VDT.MSX_VDT_ST_REG_C = 0; //1:소프라이트 충돌

            for (L = 0; L <= (49152 - 1); L++) VDTOUT.vdtBufferSpr[L] = -1;

            for (i = 0; i <= 31; i++)
            {
                V = VDT.Go_MSX_SPR_ATRB_ADDR + TBL.Gi_M_Table4[i];
                Sy = VDT.MSX_VRAM[V]; //Y좌표0~255
                Sx = VDT.MSX_VRAM[V + 1]; //X좌표0~255
                if (Sy == 0xD0) goto SkipProc; //이후표시안함[D0h,208]
                Sc = VDT.MSX_VRAM[V + 2]; //패턴번호8Byte0~255
                FC = VDT.MSX_VRAM[V + 3];
                EC = (sbyte)((FC & 128) == 0 ? 0 : 1); //EC
                FC = (byte)(FC & 15); //색상0~15
                if (Sy == 255) { Sy = 0; } else { Sy = Sy + 1; };
                if (EC == 1) Sx = Sx - 32;
                Syy[0] = Sy; Sxx[0] = Sx; Vpm[0] = TBL.Go_M_Table256[Syy[0]] + Sxx[0]; //256*192
                Syy[1] = Sy + 8; Sxx[1] = Sx; Vpm[1] = TBL.Go_M_Table256[Syy[1]] + Sxx[1];
                Syy[2] = Sy; Sxx[2] = Sx + 8; Vpm[2] = TBL.Go_M_Table256[Syy[2]] + Sxx[2];
                Syy[3] = Sy + 8; Sxx[3] = Sx + 8; Vpm[3] = TBL.Go_M_Table256[Syy[3]] + Sxx[3];
                P = Vpm[0];
                if (VDT.MSX_VDT_REG_SZ == 0) //8*8
                {
                    sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8[Sc];
                    for (j = 0; j <= 7; j++) //8Byte
                    {
                        b = VDT.MSX_VRAM[sf + j];
                        for (k = 1; k <= 8; k++) //8Bit
                        {
                            if ((b & TBL.Gi_B_Table[8 - k]) > 0) //[1]
                            {
                              //If (VDT.MSX_VDT_REG_SM = 0) Then //정상
                                Xp = Sxx[0] + k - 1;
                                if ((Xp >= 0) && (Xp <= 255)) //좌우표시범위이내확인
                                {
                                    Ps = P + k - 1;
                                    if (Ps > 65535) Ps = Ps - 65536;
                                    if ((Ps >= 0) && (Ps <= 49151))
                                    {
                                        if (VDTOUT.vdtBufferSpr[Ps] == -1)
                                        {
                                            VDTOUT.vdtBufferSpr[Ps] = (short)(FC == 0 ? -2 : FC);
                                        }
                                        else
                                        {
                                            if (VDTOUT.vdtBufferSpr[Ps] == -2) VDTOUT.vdtBufferSpr[Ps] = (short)(FC == 0 ? -2 : FC);
                                            VDT.MSX_VDT_ST_REG_C = 1;
                                        };
                                    };
                                };
                              //Else //확대
                        
                              //End If
                            };
                        };
                        P = P + 256; //1Line256Dot
                    };
                }
                else //16*16
                {
                    Sc = (byte)TBL.Gi_Spr_TableStart[Sc]; //첫번째위치
                    for (M = 0; M <= 3; M++) //8Byte*4
                    {
                        sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8[Sc + M];
                        if (M == 0) P = Vpm[0];
                        if (M == 1) P = Vpm[1];
                        if (M == 2) P = Vpm[2];
                        if (M == 3) P = Vpm[3];
                        for (j = 0; j <= 7; j++) //8Byte
                        {
                            b = VDT.MSX_VRAM[sf + j];
                            for (k = 1; k <= 8; k++) //8Bit
                            {
                                if ((b & TBL.Gi_B_Table[8 - k]) > 0) //[1]
                                {
                                  //If (VDT.MSX_VDT_REG_SM = 0) Then //정상
                                    Xp = Sxx[M] + k - 1;
                                    if ((Xp >= 0) && (Xp <= 255)) //좌우표시범위이내확인
                                    {
                                        Ps = P + k - 1;
                                        if (Ps > 65535) Ps = Ps - 65536;
                                        if ((Ps >= 0) && (Ps <= 49151))
                                        {
                                            if (VDTOUT.vdtBufferSpr[Ps] == -1)
                                            {
                                                VDTOUT.vdtBufferSpr[Ps] = (short)(FC == 0 ? -2 : FC);
                                            }
                                            else
                                            {
                                                if (VDTOUT.vdtBufferSpr[Ps] == -2) VDTOUT.vdtBufferSpr[Ps] = (short)(FC == 0 ? -2 : FC);
                                                VDT.MSX_VDT_ST_REG_C = 1;
                                            };
                                        };
                                    };
                                  //Else //확대
                              
                                  //End If
                                };
                            };
                            P = P + 256; //1Line256Dot
                        };
                    };
                };
            };

        SkipProc: ;
            for (L = 0; L <= (49152 - 1); L++)
            {
                if (VDTOUT.vdtBufferSpr[L] >= 0) VDTOUT.vdtBuffer32[L] = (int)VDT.Go_MSX_Color[VDTOUT.vdtBufferSpr[L]];
            };

        }

      //소프라이트2 (MSX2)
        public static void MSX_SPRITE_2_DISP(sbyte iLn)
        {
            sbyte i, j, k, M; int L, L2;
            int V, V2; byte b; int P, Ps, sf;
            int Sy, Sx; byte Sc; short FC; int C;
            sbyte EC, Cc, IC; int Xp;
            int[] Vpm = new int[4];
            int[] Syy = new int[4];
            int[] Sxx = new int[4];

            if (VDT.MSX_VDT_REG_SPD == 1) goto ExitProc;

            VDT.Go_MSX_SPR_FONT_ADDR = TBL.Go_M_Table2048[VDT.MSX_VDT_REG[6] & 63]; //R6: (??AAAAAA)+00000000000, 0800h / 0~255 - 8*8=256, 16*16=64(4패턴번호동일지정됨), 표시순서0번이가장앞에표시
          //R11: 000000+(A16,A15), R5: (A14~A10)+1xx
            VDT.Go_MSX_SPR_ATRB_ADDR = Z80A.goGetIntHLToLng((byte)(VDT.MSX_VDT_REG[11] & 3), (byte)(VDT.MSX_VDT_REG[5] & 0xFC));
            VDT.Go_MSX_SPR_ATRB_ADDR = TBL.Go_M_Table128[VDT.Go_MSX_SPR_ATRB_ADDR];
            VDT.Go_MSX_SPR_COLR_ADDR = VDT.Go_MSX_SPR_ATRB_ADDR - 512; //200h
            if (VDT.Go_MSX_SPR_COLR_ADDR < 0) VDT.Go_MSX_SPR_COLR_ADDR = 0;

            VDT.MSX_VDT_REG_SZ = (byte)((VDT.MSX_VDT_REG[1] & 2) == 0 ? 0 : 1); //R1(7,1) - SPR SIZE (0:8*8, 1:16*16) - 16사이즈저장순서 왼쪽위,아래,오른쪽위,아래
            VDT.MSX_VDT_REG_SM = (byte)((VDT.MSX_VDT_REG[1] & 1) == 0 ? 0 : 1); //R1(8,1) - SPR MAG (0:정상, 1:가로세로2배확대)
            VDT.MSX_VDT_ST_REG_C = 0; //1:소프라이트 충돌

            for (L = 0; L <= (54272 - 1); L++) VDTOUT.vdtBufferSpr2[L] = -1; //256*212

            for (i = 0; i <= 31; i++)
            {
                V = VDT.Go_MSX_SPR_ATRB_ADDR + TBL.Gi_M_Table4[i]; //어트리뷰트테이블
                Sy = VDT.MSX_VRAM[V]; //Y좌표0~255
                Sx = VDT.MSX_VRAM[V + 1]; //X좌표0~255
                if (Sy == 0xD8) goto SkipProc; //이후표시안함[D8h,216]
                Sy = Sy - VDT.MSX_VDT_REG[23]; if (Sy < 0) Sy = Sy + 256; //스크롤반영
                Sc = VDT.MSX_VRAM[V + 2]; //패턴번호8Byte0~255
                V2 = VDT.Go_MSX_SPR_COLR_ADDR + TBL.Gi_M_Table16[i]; //칼라테이블
                FC = VDT.MSX_VRAM[V2];
                EC = (sbyte)((FC & 128) == 0 ? 0 : 1); //EC - 1:Shift Left
                if (Sy == 255) { Sy = 0; } else { Sy = Sy + 1; };
                if (EC == 1) Sx = Sx - 32;
                Syy[0] = Sy; Sxx[0] = Sx; Vpm[0] = TBL.Go_M_Table256[Syy[0]] + Sxx[0]; //256*212
                Syy[1] = Sy + 8; Sxx[1] = Sx; Vpm[1] = TBL.Go_M_Table256[Syy[1]] + Sxx[1];
                Syy[2] = Sy; Sxx[2] = Sx + 8; Vpm[2] = TBL.Go_M_Table256[Syy[2]] + Sxx[2];
                Syy[3] = Sy + 8; Sxx[3] = Sx + 8; Vpm[3] = TBL.Go_M_Table256[Syy[3]] + Sxx[3];
                P = Vpm[0];
                if (VDT.MSX_VDT_REG_SZ == 0) //8*8
                {
                    sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8[Sc]; //패턴테이블
                    for (j = 0; j <= 7; j++) //8Byte
                    {
                        FC = VDT.MSX_VRAM[V2 + j]; //칼라테이블
                        Cc = (sbyte)((FC & 64) == 0 ? 0 : 1); //CC - 1:동일우선순위,Or칼라,충돌없음
                        IC = (sbyte)((FC & 32) == 0 ? 0 : 1); //IC - 1:충돌확인안함
                        FC = (byte)(FC & 15); //색상0~15
                        b = VDT.MSX_VRAM[sf + j]; //캐릭터
                        for (k = 1; k <= 8; k++) //8Bit
                        {
                            if ((b & TBL.Gi_B_Table[8 - k]) > 0) //[1]
                            {
                              //If (VDT.MSX_VDT_REG_SM = 0) Then //정상
                                Xp = Sxx[0] + k - 1;
                                if ((Xp >= 0) && (Xp <= 255)) //좌우표시범위이내확인
                                {
                                    Ps = P + k - 1;
                                    if (Ps > 65535) Ps = Ps - 65536;
                                    if ((Ps >= 0) && (Ps <= 54271))
                                    {
                                        if (VDTOUT.vdtBufferSpr2[Ps] == -1)
                                        {
                                            VDTOUT.vdtBufferSpr2[Ps] = (short)((VDT.MSX_VDT_REG_TP == 0) && (FC == 0) ? -2 : FC);
                                        }
                                        else
                                        {
                                            if (VDTOUT.vdtBufferSpr2[Ps] == -2)
                                            {
                                                VDTOUT.vdtBufferSpr2[Ps] = (short)((VDT.MSX_VDT_REG_TP == 0) && (FC == 0) ? -2 : FC);
                                            }
                                            else
                                            {
                                                if (!((VDT.MSX_VDT_REG_TP == 0) && (FC == 0)))
                                                {
                                                    if (Cc == 1) //Or-Color
                                                    {
                                                        if (VDTOUT.vdtBufferSpr2[Ps] < 0) VDTOUT.vdtBufferSpr2[Ps] = 0;
                                                        VDTOUT.vdtBufferSpr2[Ps] = (short)(VDTOUT.vdtBufferSpr2[Ps] | FC); //소프라이트 색상 겹치는부분 OR 연산
                                                    };
                                                };
                                            };
                                            if ((Cc == 0) && (IC == 0)) VDT.MSX_VDT_ST_REG_C = 1;
                                        };
                                    };
                                };
                              //Else //확대
                          
                              //End If
                            };
                        };
                        P = P + 256; //1Line256Dot
                    };
                }
                else //16*16
                {
                    Sc = (byte)TBL.Gi_Spr_TableStart[Sc]; //첫번째위치
                    for (M = 0; M <= 3; M++) //8Byte*4
                    {
                        sf = VDT.Go_MSX_SPR_FONT_ADDR + TBL.Gi_M_Table8[Sc + M]; //패턴테이블
                        if (M == 0) P = Vpm[0];
                        if (M == 1) P = Vpm[1];
                        if (M == 2) P = Vpm[2];
                        if (M == 3) P = Vpm[3];
                        for (j = 0; j <= 7; j++) //8Byte
                        {
                            FC = VDT.MSX_VRAM[V2 + ((M == 1) || (M == 3) ? 8 : 0) + j]; //칼라테이블
                            Cc = (sbyte)((FC & 64) == 0 ? 0 : 1); //CC - 1:동일우선순위,Or칼라,충돌없음
                            IC = (sbyte)((FC & 32) == 0 ? 0 : 1); //IC - 1:충돌확인안함
                            FC = (byte)(FC & 15); //색상0~15
                            b = VDT.MSX_VRAM[sf + j]; //캐릭터
                            for (k = 1; k <= 8; k++) //8Bit
                            {
                                if ((b & TBL.Gi_B_Table[8 - k]) > 0) //[1]
                                {
                                  //If (VDT.MSX_VDT_REG_SM = 0) Then //정상
                                    Xp = Sxx[M] + k - 1;
                                    if ((Xp >= 0) && (Xp <= 255)) //좌우표시범위이내확인
                                    {
                                        Ps = P + k - 1;
                                        if (Ps > 65535) Ps = Ps - 65536;
                                        if ((Ps >= 0) && (Ps <= 54271))
                                        {
                                            if (VDTOUT.vdtBufferSpr2[Ps] == -1)
                                            {
                                                VDTOUT.vdtBufferSpr2[Ps] = (short)((VDT.MSX_VDT_REG_TP == 0) && (FC == 0) ? -2 : FC);
                                            }
                                            else
                                            {
                                                if (VDTOUT.vdtBufferSpr2[Ps] == -2)
                                                {
                                                    VDTOUT.vdtBufferSpr2[Ps] = (short)((VDT.MSX_VDT_REG_TP == 0) && (FC == 0) ? -2 : FC);
                                                }
                                                else
                                                {
                                                    if (!((VDT.MSX_VDT_REG_TP == 0) && (FC == 0)))
                                                    {
                                                        if (Cc == 1) //Or-Color
                                                        {
                                                            if (VDTOUT.vdtBufferSpr2[Ps] < 0) VDTOUT.vdtBufferSpr2[Ps] = 0;
                                                            VDTOUT.vdtBufferSpr2[Ps] = (short)(VDTOUT.vdtBufferSpr2[Ps] | FC); //소프라이트 색상 겹치는부분 OR 연산
                                                        };
                                                    };
                                                };
                                                if ((Cc == 0) && (IC == 0)) VDT.MSX_VDT_ST_REG_C = 1;
                                            };
                                        };
                                    };
                                  //Else //확대
                            
                                  //End If
                                };
                            };
                            P = P + 256; //1Line256Dot
                        };
                    };
                };
            };

        SkipProc: ;
          //256*192/256*212
            if ((VDT.Gi_MSX_SCREEN_MODE == 4) || (VDT.Gi_MSX_SCREEN_MODE == 5))
            {
                if (iLn == 0)
                {
                    for (L = 0; L <= (49152 - 1); L++)
                    {
                        if (VDTOUT.vdtBufferSpr2[L] >= 0)
                        {
                            C = (int)VDT.Go_MSX_Color[VDTOUT.vdtBufferSpr2[L]];
                            VDTOUT.vdtBuffer32[L] = C;
                        };
                    };
                }
                else
                {
                    for (L = 0; L <= (54272 - 1); L++)
                    {
                        if (VDTOUT.vdtBufferSpr2[L] >= 0)
                        {
                            C = (int)VDT.Go_MSX_Color[VDTOUT.vdtBufferSpr2[L]];
                            VDTOUT.vdtBuffer32p[L] = C;
                        };
                    };
                };
            };

          //256*192/256*212
            if (VDT.Gi_MSX_SCREEN_MODE == 8)
            {
                if (iLn == 0)
                {
                    for (L = 0; L <= (49152 - 1); L++)
                    {
                        if (VDTOUT.vdtBufferSpr2[L] >= 0)
                        {
                            C = (int)VDT.Go_MSX_Color_G7[VDTOUT.vdtBufferSpr2[L]];
                            VDTOUT.vdtBuffer32[L] = C;
                        };
                    };
                }
                else
                {
                    for (L = 0; L <= (54272 - 1); L++)
                    {
                        if (VDTOUT.vdtBufferSpr2[L] >= 0)
                        {
                            C = (int)VDT.Go_MSX_Color_G7[VDTOUT.vdtBufferSpr2[L]];
                            VDTOUT.vdtBuffer32p[L] = C;
                        };
                    };
                };
            };

          //512*192/512*212
            if ((VDT.Gi_MSX_SCREEN_MODE == 6) || (VDT.Gi_MSX_SCREEN_MODE == 7))
            {
                L2 = 0;
                if (iLn == 0)
                {
                    for (L = 0; L <= (49152 - 1); L++)
                    {
                        if (VDTOUT.vdtBufferSpr2[L] >= 0)
                        {
                            C = (int)VDT.Go_MSX_Color[VDTOUT.vdtBufferSpr2[L]];
                            VDTOUT.vdtBuffer80[L2] = C; L2 = L2 + 1;
                            VDTOUT.vdtBuffer80[L2] = C;
                        };
                    };
                }
                else
                {
                    for (L = 0; L <= (54272 - 1); L++)
                    {
                        if (VDTOUT.vdtBufferSpr2[L] >= 0)
                        {
                            C = (int)VDT.Go_MSX_Color[VDTOUT.vdtBufferSpr2[L]];
                            VDTOUT.vdtBuffer80p[L2] = C; L2 = L2 + 1;
                            VDTOUT.vdtBuffer80p[L2] = C;
                        };
                    };
                };
            };

        ExitProc: ;
        }
    }
}
